       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04506.                                         
       DATE-WRITTEN.  07/30/2011.                                       
       DATE-COMPILED.                                                   
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM WILL BE USED ON RATE ENTRY/RPM DASHBOARD TO      *        
      *  INSERT,UPDATE AND DELETE A BUSINESS PROCESS REQUEST(S).       *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : REQUUPDBUSPROCREQBUSINESSOP                       *        
      *  INPUT     : APPL_PROG_ID       CHAR(03)                       *        
      *              USER_ID            CHAR(07)                       *        
      *              ACTION_FL          CHAR(01)                       *        
      *              OVERRIDE_FL        CHAR(01)                       *        
      *              PROC_REQ_ID        DECIMAL(10)                    *        
      *              COMPANY_NO         CHAR(02)                       *        
      *              CODE_UTIL_TYPE     CHAR(01)                       *        
      *              PROC_REQ_DESC      CHAR(100)                      *        
      *              PROC_TYPE_CD       CHAR(06)                       *        
      *              STATUS_SEQ_NO      INTEGER                        *        
      *              PROC_FLOW_IND      CHAR(01)                       *        
      *              PROC_STATUS_CD     CHAR(02)                       *        
      *              PROC_GROUP_CD      CHAR(12)                       *        
      *              PROC_GROUP_DESC    CHAR(100)                      *        
      *              CREATED_BY_USERID  CHAR(07)                       *        
      *              EFFECTIVE_TS       CHAR(26)                  *             
      *              PROC_REQ_DUE_TS    CHAR(26)                       *        
      *              LAST_UPDATE_USERID CHAR(07)                       *        
      *              PROC_REQ_DUE_TS    CHAR(26)                       *        
      *              LAST_UPDATE_USERID CHAR(07)                       *        
      *              REQ_CHG_COMMENTS   CHAR(255)                      *        
      *                                                                *        
      *  OUTPUT    : RETURN_CODE             INTEGER                   *        
      *              APPL_RETURN_CODE        INTEGER                   *        
      *              PROC_REQ_ID             DECIMAL(10,0)             *        
      *              COMPANY_NO              CHAR(02)                  *        
      *              CATEGORY_ID             INTEGER                   *        
      *              CODE_UTIL_TYPE          CHAR(01)                  *        
      *              PROC_REQ_DESC           CHAR(100)                 *        
      *              PROC_TYPE_CD            CHAR(06)                  *        
      *              STATUS_SEQ_NO           INTEGER                   *        
      *              PROC_FLOW_IND           CHAR(01)                  *        
      *              PROC_STATUS_CD          CHAR(02)                  *        
      *              PROC_GROUP_CD           CHAR(12)                  *        
      *              CREATED_TS              CHAR(26)                  *        
      *              CREATED_BY_USERID       CHAR(07)                  *        
      *              EFFECTIVE_TS            CHAR(26)                  *        
      *              PROC_REQ_DUE_TS         CHAR(26)                  *        
      *              LAST_UPDATE_USERID      CHAR(07)                  *        
      *              LAST_UPDATE_TS          CHAR(26)                  *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00473*  07/30/11  DB41297    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *   888    INVALID INPUT PARAMETERS                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04506'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR CSR4506 STARTS HERE'.                   
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04506'.      
           05  MCSCB728                PIC X(08) VALUE 'MCSCB728'.      
                                                                        
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE         PIC S9(09) COMP VALUE +0.          
           05  S-APPL-RETURN-CODE    PIC S9(09) COMP VALUE +0.          
           05  S-PROC-REQ-ID         PIC S9(10)V COMP-3 VALUE +0.       
           05  S-COMPANY-NO          PIC X(02) VALUE SPACES.            
           05  S-CATEGORY-ID         PIC S9(9) COMP VALUE +0.           
           05  S-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.            
           05  S-PROC-REQ-DESC       PIC X(100) VALUE SPACES.           
           05  S-PROC-TYPE-CD        PIC X(06) VALUE SPACES.            
           05  S-STATUS-SEQ-NO       PIC S9(09) COMP VALUE +0.          
           05  S-PROC-FLOW-IND       PIC X(01) VALUE SPACES.            
           05  S-PROC-STATUS-CD      PIC X(02) VALUE SPACES.            
           05  S-PROC-GROUP-CD       PIC X(12) VALUE SPACES.            
           05  S-CREATED-TS          PIC X(26) VALUE SPACES.            
           05  S-CREATED-BY-USERID   PIC X(07) VALUE SPACES.            
           05  S-EFFECTIVE-TS        PIC X(26) VALUE SPACES.            
           05  S-PROC-REQ-DUE-TS     PIC X(26) VALUE SPACES.            
           05  S-LAST-UPDATE-USERID  PIC X(07)  VALUE SPACES.           
           05  S-LAST-UPDATE-TS      PIC X(26) VALUE SPACES.            
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
      ******************************************************************        
      * INCLUDE CSS_PROCESS_CNTRL 6P                                            
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCTLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_TYPE 2P                                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCTYP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_GROUP 5P                                            
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCGRP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_REQ_CH 4P                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCCHG                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_REQ 1P                                              
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCREQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * ERROR HANDLING                                                          
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CURSOR DEFINITIONS                                                      
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS00728                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID       PIC X(03).                           
       01  PARM-USER-ID            PIC X(07).                           
       01  PARM-ACTION-FL          PIC X(01).                           
       01  PARM-OVERRIDE-FL        PIC X(01).                           
       01  PARM-PROC-REQ-ID        PIC X(10).                           
       01  PARM-COMPANY-NO         PIC X(02).                           
       01  PARM-CODE-UTIL-TYPE     PIC X(01).                           
       01  PARM-PROC-REQ-DESC      PIC X(100).                          
       01  PARM-PROC-TYPE-CD       PIC X(06).                           
       01  PARM-STATUS-SEQ-NO      PIC X(10).                           
       01  PARM-PROC-FLOW-IND      PIC X(01).                           
       01  PARM-PROC-STATUS-CD     PIC X(02).                           
       01  PARM-PROC-GROUP-CD      PIC X(12).                           
       01  PARM-PROC-GROUP-DESC    PIC X(100).                          
       01  PARM-CREATED-BY-USERID  PIC X(07).                           
       01  PARM-EFFECTIVE-TS       PIC X(26).                           
       01  PARM-PROC-REQ-DUE-TS    PIC X(26).                           
       01  PARM-LAST-UPDATE-USERID PIC X(07).                           
       01  PARM-REQ-CHG-COMMENTS   PIC X(255).                          
       01  PARM-CURNT-LAST-UPDATE-TS PIC X(26).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                PARM-APPL-PROG-ID                                       
              , PARM-USER-ID                                            
              , PARM-ACTION-FL                                          
              , PARM-OVERRIDE-FL                                        
              , PARM-PROC-REQ-ID                                        
              , PARM-COMPANY-NO                                         
              , PARM-CODE-UTIL-TYPE                                     
              , PARM-PROC-REQ-DESC                                      
              , PARM-PROC-TYPE-CD                                       
              , PARM-STATUS-SEQ-NO                                      
              , PARM-PROC-FLOW-IND                                      
              , PARM-PROC-STATUS-CD                                     
              , PARM-PROC-GROUP-CD                                      
              , PARM-PROC-GROUP-DESC                                    
              , PARM-CREATED-BY-USERID                                  
              , PARM-EFFECTIVE-TS                                       
              , PARM-PROC-REQ-DUE-TS                                    
              , PARM-LAST-UPDATE-USERID                                 
              , PARM-REQ-CHG-COMMENTS                                   
              , PARM-CURNT-LAST-UPDATE-TS.                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. VALIDATE INPUT PARAMETERS.                              *        
      *     2. DECLARE TEMP TABLE.                                     *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           INITIALIZE LR-MCSCB728-RET-TABLE.                            
           IF PARM-PROC-REQ-ID IS NUMERIC                               
              MOVE PARM-PROC-REQ-ID    TO LN-PROC-REQ-ID                
           ELSE                                                         
              MOVE ZEROS               TO LN-PROC-REQ-ID                
           END-IF.                                                      
           IF PARM-STATUS-SEQ-NO IS NUMERIC                             
              MOVE PARM-STATUS-SEQ-NO  TO LR-MCSCB728-STATUS-SEQ-NO     
           ELSE                                                         
              MOVE ZEROS               TO LR-MCSCB728-STATUS-SEQ-NO     
           END-IF.                                                      
                                                                        
           MOVE PARM-APPL-PROG-ID      TO LS-MCSCB728-APPL-PROG-ID.     
           MOVE PARM-USER-ID           TO LS-MCSCB728-USER-ID.          
           MOVE PARM-ACTION-FL         TO LS-MCSCB728-ACTION-FL.        
           MOVE PARM-OVERRIDE-FL       TO LS-MCSCB728-OVERRIDE-FL.      
           MOVE PARM-PROC-REQ-ID       TO LR-MCSCB728-PROC-REQ-ID.      
           MOVE PARM-COMPANY-NO        TO LR-MCSCB728-COMPANY-NO.       
           MOVE PARM-CODE-UTIL-TYPE    TO LR-MCSCB728-CODE-UTIL-TYPE.   
           MOVE PARM-PROC-REQ-DESC     TO LR-MCSCB728-PROC-REQ-DESC.    
           MOVE PARM-PROC-TYPE-CD      TO LR-MCSCB728-PROC-TYPE-CD.     
           MOVE PARM-STATUS-SEQ-NO     TO LR-MCSCB728-STATUS-SEQ-NO.    
           MOVE PARM-PROC-FLOW-IND     TO LR-MCSCB728-PROC-FLOW-IND.    
           MOVE PARM-PROC-STATUS-CD    TO LR-MCSCB728-PROC-STATUS-CD.   
           MOVE PARM-PROC-GROUP-CD     TO LR-MCSCB728-PROC-GROUP-CD.    
           MOVE PARM-PROC-GROUP-DESC   TO LS-MCSCB728-PROC-GROUP-DESC.  
           MOVE PARM-CREATED-BY-USERID TO LR-MCSCB728-CREATED-BY-USERID.
           MOVE PARM-EFFECTIVE-TS      TO LR-MCSCB728-EFFECTIVE-TS.     
           MOVE PARM-PROC-REQ-DUE-TS   TO LR-MCSCB728-PROC-REQ-DUE-TS.  
           MOVE PARM-LAST-UPDATE-USERID TO                              
                LR-MCSCB728-LAST-UPDATE-USERID.                         
           MOVE PARM-REQ-CHG-COMMENTS  TO LS-MCSCB728-REQ-CHG-COMMENTS. 
           MOVE PARM-CURNT-LAST-UPDATE-TS TO                            
                                          LR-MCSCB728-CRNT-LAST-UPDT-TS.
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,PROC_REQ_ID                                               
             ,COMPANY_NO                                                
             ,CATEGORY_ID                                               
             ,CODE_UTIL_TYPE                                            
             ,PROC_REQ_DESC                                             
             ,PROC_TYPE_CD                                              
             ,STATUS_SEQ_NO                                             
             ,PROC_FLOW_IND                                             
             ,PROC_STATUS_CD                                            
             ,PROC_GROUP_CD                                             
             ,CREATED_TS                                                
             ,CREATED_BY_USERID                                         
             ,EFFECTIVE_TS                                              
             ,PROC_REQ_DUE_TS                                           
             ,LAST_UPDATE_USERID                                        
             ,LAST_UPDATE_TS                                            
                FROM #CSR04506_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,PROC_REQ_ID                                                       
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,CATEGORY_ID                                                       
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,PROC_REQ_DESC                                                     
MFA-TR*      ,PROC_TYPE_CD                                                      
MFA-TR*      ,STATUS_SEQ_NO                                                     
MFA-TR*      ,PROC_FLOW_IND                                                     
MFA-TR*      ,PROC_STATUS_CD                                                    
MFA-TR*      ,PROC_GROUP_CD                                                     
MFA-TR*      ,CREATED_TS                                                        
MFA-TR*      ,CREATED_BY_USERID                                                 
MFA-TR*      ,EFFECTIVE_TS                                                      
MFA-TR*      ,PROC_REQ_DUE_TS                                                   
MFA-TR*      ,LAST_UPDATE_USERID                                                
MFA-TR*      ,LAST_UPDATE_TS                                                    
MFA-TR*         FROM SESSION.CSR04506_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04506_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04506_R1
              (                                                        
                   RETURN_CODE             INT                      
                  ,APPL_RETURN_CODE        INT                      
                  ,PROC_REQ_ID             DECIMAL(10,0)                
                  ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CATEGORY_ID             INT                      
                  ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_REQ_DESC CHAR(100)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,PROC_TYPE_CD CHAR(06)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,STATUS_SEQ_NO           INT                      
                  ,PROC_FLOW_IND CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_GROUP_CD CHAR(12)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,CREATED_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CREATED_BY_USERID CHAR(07)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,EFFECTIVE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_REQ_DUE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710' OR SQLCODE = -601                      
              PERFORM 0150A-DELETE-GTT-ROWS THRU 0150A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS        
                  MOVE 100                  TO S-RETURN-CODE            
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                                               S-APPL-RETURN-CODE       
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04506_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0150A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       0150A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04506_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04506_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS           
               MOVE 100                  TO S-RETURN-CODE               
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
                                            S-APPL-RETURN-CODE          
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04506_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       0150A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. DATABASE RETRIEVAL                                      *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           CALL MCSCB728 USING ABEND-FILE                               
                               LS-MCSCB728-CALL-TYPE                    
                               LN-MCSCB728-ONLINE-CALL                  
                               LR-MCSCB728-RET-TABLE.                   
                                                                        
           IF LR-MCSCB728-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
           ELSE                                                         
              MOVE LR-MCSCB728-RETURN-CODE      TO S-RETURN-CODE        
              MOVE LR-MCSCB728-APPL-RETURN-CODE TO S-APPL-RETURN-CODE   
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE LR-MCSCB728-RETURN-CODE       TO S-RETURN-CODE.         
           MOVE LR-MCSCB728-APPL-RETURN-CODE  TO S-APPL-RETURN-CODE.    
           MOVE LR-MCSCB728-PROC-REQ-ID       TO S-PROC-REQ-ID.         
           MOVE LR-MCSCB728-COMPANY-NO        TO S-COMPANY-NO.          
           MOVE LR-MCSCB728-CATEGORY-ID       TO S-CATEGORY-ID.         
           MOVE LR-MCSCB728-CODE-UTIL-TYPE    TO S-CODE-UTIL-TYPE.      
           MOVE LR-MCSCB728-PROC-REQ-DESC     TO S-PROC-REQ-DESC.       
           MOVE LR-MCSCB728-PROC-TYPE-CD      TO S-PROC-TYPE-CD.        
           MOVE LR-MCSCB728-STATUS-SEQ-NO     TO S-STATUS-SEQ-NO.       
           MOVE LR-MCSCB728-PROC-FLOW-IND     TO S-PROC-FLOW-IND.       
           MOVE LR-MCSCB728-PROC-STATUS-CD    TO S-PROC-STATUS-CD.      
           MOVE LR-MCSCB728-PROC-GROUP-CD     TO S-PROC-GROUP-CD.       
           MOVE LR-MCSCB728-CREATED-TS        TO S-CREATED-TS.          
           MOVE LR-MCSCB728-CREATED-BY-USERID TO S-CREATED-BY-USERID.   
                                                                        
           IF LR-MCSCB728-EFFECTIVE-TS    = LOW-VALUES                  
              MOVE SPACES TO LR-MCSCB728-EFFECTIVE-TS                   
           END-IF.                                                      
           MOVE LR-MCSCB728-EFFECTIVE-TS      TO S-EFFECTIVE-TS.        
                                                                        
           IF LR-MCSCB728-PROC-REQ-DUE-TS = LOW-VALUES                  
              MOVE SPACES TO LR-MCSCB728-PROC-REQ-DUE-TS                
           END-IF.                                                      
           MOVE LR-MCSCB728-PROC-REQ-DUE-TS    TO S-PROC-REQ-DUE-TS.    
                                                                        
           MOVE LR-MCSCB728-LAST-UPDATE-USERID TO S-LAST-UPDATE-USERID. 
           MOVE LR-MCSCB728-LAST-UPDATE-TS     TO S-LAST-UPDATE-TS.     
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      * RETURN FIELDS TO CALLING MODULE.                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04506_R1                       
                 ( RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,PROC_REQ_ID                                          
                  ,COMPANY_NO                                           
                  ,CATEGORY_ID                                          
                  ,CODE_UTIL_TYPE                                       
                  ,PROC_REQ_DESC                                        
                  ,PROC_TYPE_CD                                         
                  ,STATUS_SEQ_NO                                        
                  ,PROC_FLOW_IND                                        
                  ,PROC_STATUS_CD                                       
                  ,PROC_GROUP_CD                                        
                  ,CREATED_TS                                           
                  ,CREATED_BY_USERID                                    
                  ,EFFECTIVE_TS                                         
                  ,PROC_REQ_DUE_TS                                      
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  )                                                     
               VALUES                                                   
               (    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-PROC-REQ-ID                                      
                   ,:S-COMPANY-NO                                       
                   ,:S-CATEGORY-ID                                      
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-PROC-REQ-DESC                                    
                   ,:S-PROC-TYPE-CD                                     
                   ,:S-STATUS-SEQ-NO                                    
                   ,:S-PROC-FLOW-IND                                    
                   ,:S-PROC-STATUS-CD                                   
                   ,:S-PROC-GROUP-CD                                    
                   ,:S-CREATED-TS                                       
                   ,:S-CREATED-BY-USERID                                
                   ,:S-EFFECTIVE-TS                                     
                   ,:S-PROC-REQ-DUE-TS                                  
                   ,:S-LAST-UPDATE-USERID                               
                   ,:S-LAST-UPDATE-TS                                   
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04506_R1                               
MFA-TR*          ( RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CATEGORY_ID                                                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,PROC_REQ_DESC                                                
MFA-TR*           ,PROC_TYPE_CD                                                 
MFA-TR*           ,STATUS_SEQ_NO                                                
MFA-TR*           ,PROC_FLOW_IND                                                
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_GROUP_CD                                                
MFA-TR*           ,CREATED_TS                                                   
MFA-TR*           ,CREATED_BY_USERID                                            
MFA-TR*           ,EFFECTIVE_TS                                                 
MFA-TR*           ,PROC_REQ_DUE_TS                                              
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (    :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-PROC-REQ-ID                                              
MFA-TR*            ,:S-COMPANY-NO                                               
MFA-TR*            ,:S-CATEGORY-ID                                              
MFA-TR*            ,:S-CODE-UTIL-TYPE                                           
MFA-TR*            ,:S-PROC-REQ-DESC                                            
MFA-TR*            ,:S-PROC-TYPE-CD                                             
MFA-TR*            ,:S-STATUS-SEQ-NO                                            
MFA-TR*            ,:S-PROC-FLOW-IND                                            
MFA-TR*            ,:S-PROC-STATUS-CD                                           
MFA-TR*            ,:S-PROC-GROUP-CD                                            
MFA-TR*            ,:S-CREATED-TS                                               
MFA-TR*            ,:S-CREATED-BY-USERID                                        
MFA-TR*            ,:S-EFFECTIVE-TS                                             
MFA-TR*            ,:S-PROC-REQ-DUE-TS                                          
MFA-TR*            ,:S-LAST-UPDATE-USERID                                       
MFA-TR*            ,:S-LAST-UPDATE-TS                                           
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04444_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9001-TERMINATE-PROGRAM.                                          
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
