       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04505.                                         
       DATE-WRITTEN.  07/30/2011.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM WILL BE USED ON RATE ENTRY/RPM DASHBOARD TO      *        
      *  RETRIEVE BUSINESS PROCESS REQUEST(S)                          *        
      *                                                                *        
      *  TRANID:                                                       *        
      *  PROGRAM:                                                      *        
      *  CALLING SP:                                                   *        
      *  BUSINESOP : REQUGETBUSPROCREQBUSINESSOP                       *        
      *  INPUT     : PROC_REQ_ID         DECIMAL(10,0)                 *        
      *              COMPANY_NO          CHAR(02)                      *        
      *              PROC_AREA_CD        CHAR(1)                       *        
      *              PENDING_FL          CHAR(1)                       *        
      *                                                                *        
      *  OUTPUT    : RETURN_CODE         INTEGER                       *        
      *              APPL_RETURN_CODE    INTEGER                       *        
      *              PROC_REQ_ID         DECIMAL(10,0)                 *        
      *              COMPANY_NO          CHAR(02)                      *        
      *              CODE_UTIL_TYPE      CHAR(01)                      *        
      *              PROC_REQ_DESC       CHAR(100)                     *        
      *              PROC_TYPE_CD        CHAR(06)                      *        
      *              STATUS_SEQ_NO       INTEGER                       *        
      *              PROC_FLOW_IND       CHAR(01)                      *        
      *              PROC_STATUS_CD      CHAR(02)                      *        
      *              PROC_GROUP_CD       CHAR(12)                      *        
      *              CREATED_BY_USERID   CHAR(07)                      *        
      *              CREATED_TS          CHAR(26)                      *        
      *              CATEGORY_ID         INTEGER                       *        
      *              PROC_REQ_DUE_TS     CHAR(26)                      *        
      *              LAST_UPDATE_USERID  CHAR(07)                      *        
      *              LAST_UPDATE_TS      CHAR(26)                      *        
      *              EFFECTIVE_TS        CHAR(26)                      *        
      *              OVERDUE_FL          CHAR(01)                      *        
      *              CAN_DELETE_FL       CHAR(01)                      *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00473*  07/30/11  DB41297    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
      *                                                                *        
      *              RETURN CODES AND MEANINGS                         *        
      *  ANY -   ERROR                                                 *        
      *   0      RECORD WAS FOUND                                      *        
      *   100    RECORD WAS NOT FOUND                                  *        
      *   803    INVALID INPUT PARAMETERS                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04505'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR CSR4505 STARTS HERE'.                   
                                                                        
       01  WORK-FIELDS.                                                 
           05  WS-NULL-IND             PIC S9(4) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04505'.      
           05  WS-PROC-REQ-ID          PIC X(10).                       
           05  WS-PROC-REQ-ID-NUM REDEFINES WS-PROC-REQ-ID PIC 9(10).   
           05  WS-PROC-AREA-CD.                                         
               10 WS-PROC-AREA-CD1     PIC X.                           
               10 WS-PROC-AREA-CD2     PIC X.                           
               10 WS-PROC-AREA-CD3     PIC X.                           
               10 WS-PROC-AREA-CD4     PIC X.                           
               10 WS-PROC-AREA-CD5     PIC X.                           
           05  WS-HAS-ACCESS-FL        PIC X(1) VALUE 'N'.              
           05  WS-CAN-DELETE-FL        PIC X(1) VALUE 'N'.              
      *    05  WS-EFF-TS1              PIC X(26).                               
      *    05  WS-EFF-TS2              PIC X(26).                               
      *    05  WS-EFF-TS               PIC X(26).                               
      *    05  FILLER REDEFINES WS-EFF-TS.                                      
      *        10 WS-EFF-DT            PIC X(10).                               
      *        10 WS-DASH1             PIC X.                                   
      *        10 WS-EFF-TIME          PIC X(8).                                
      *        10 WS-PERIOD1           PIC X.                                   
      *        10 WS-MICSEC            PIC X(6).                                
      *                                                                         
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(09) COMP VALUE +0.     
           05  S-APPL-RETURN-CODE         PIC S9(09) COMP VALUE +0.     
           05  S-PROC-REQ-ID              PIC S9(10)V COMP-3 VALUE +0.  
           05  S-COMPANY-NO               PIC X(02)  VALUE SPACES.      
           05  S-CODE-UTIL-TYPE           PIC X(02)  VALUE SPACES.      
           05  S-PROC-REQ-DESC            PIC X(100) VALUE SPACES.      
           05  S-PROC-TYPE-CD             PIC X(06)  VALUE SPACES.      
           05  S-STATUS-SEQ-NO            PIC S9(09) COMP VALUE +0.     
           05  S-PROC-FLOW-IND            PIC X(01)  VALUE SPACES.      
           05  S-PROC-STATUS-CD           PIC X(02)  VALUE SPACES.      
           05  S-PROC-GROUP-CD            PIC X(12)  VALUE SPACES.      
           05  S-CREATED-BY-USERID        PIC X(07)  VALUE SPACES.      
           05  S-CREATED-TS               PIC X(26)  VALUE SPACES.      
           05  S-CATEGORY-ID              PIC S9(09) COMP VALUE +0.     
           05  S-PROC-REQ-DUE-TS          PIC X(26)  VALUE SPACES.      
           05  S-LAST-UPDATE-USERID       PIC X(07)  VALUE SPACES.      
           05  S-LAST-UPDATE-TS           PIC X(26)  VALUE SPACES.      
           05  S-EFFECTIVE-TS             PIC X(26)  VALUE SPACES.      
           05  S-HAS-ACCESS-FL            PIC X(01)  VALUE SPACES.      
           05  S-OVERDUE-FL               PIC X(01)  VALUE SPACES.      
           05  S-CAN-DELETE-FL            PIC X(01)  VALUE SPACES.      
                                                                        
      ******************************************************************        
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_CNTRL 6P                                            
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCTLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_TYPE 2P                                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCTYP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_PROCESS_REQ 1P                                              
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCREQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_CATEGORY F5                                                 
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     *         
      *****************************************************************         
           COPY CWS00303.                                                       
                                                                        
      *****************************************************************         
      *  THIS COPYBOOK IS USED FOR CURSOR DECLARATIONS.               *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CWS0727A                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  THIS COPYBOOK IS USED FOR ERROR HANDLING                     *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *  THIS COPYBOOK IS USED FOR ERROR PROCESSING                   *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-APPL-PROG-ID       PIC X(03).                           
       01  LINK-USER-ID            PIC X(07).                           
       01  LINK-PROC-REQ-ID        PIC X(10).                           
       01  LINK-COMPANY-NO         PIC X(02).                           
       01  LINK-PROC-AREA-CD       PIC X(05).                           
       01  LINK-PENDING-FL         PIC X(01).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-APPL-PROG-ID                                       
              , LINK-USER-ID                                            
              , LINK-PROC-REQ-ID                                        
              , LINK-COMPANY-NO                                         
              , LINK-PROC-AREA-CD                                       
              , LINK-PENDING-FL.                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. VALIDATE INPUT PARMS                                    *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           MOVE LINK-PROC-REQ-ID       TO WS-PROC-REQ-ID                
           IF WS-PROC-REQ-ID IS NUMERIC                                 
              MOVE WS-PROC-REQ-ID-NUM  TO 1P-PROC-REQ-ID                
           ELSE                                                         
              MOVE ZEROS               TO 1P-PROC-REQ-ID                
           END-IF                                                       
                                                                        
           MOVE LINK-PROC-AREA-CD   TO WS-PROC-AREA-CD                  
           EVALUATE TRUE                                                
           WHEN WS-PROC-AREA-CD1 > ' '                                  
              MOVE WS-PROC-AREA-CD1 TO 2P-PROC-AREA-CD                  
           WHEN WS-PROC-AREA-CD2 > ' '                                  
              MOVE WS-PROC-AREA-CD2 TO 2P-PROC-AREA-CD                  
           WHEN WS-PROC-AREA-CD3 > ' '                                  
              MOVE WS-PROC-AREA-CD3 TO 2P-PROC-AREA-CD                  
           WHEN WS-PROC-AREA-CD4 > ' '                                  
              MOVE WS-PROC-AREA-CD4 TO 2P-PROC-AREA-CD                  
           WHEN WS-PROC-AREA-CD5 > ' '                                  
              MOVE WS-PROC-AREA-CD5 TO 2P-PROC-AREA-CD                  
           WHEN OTHER                                                   
              MOVE SPACES TO 2P-PROC-AREA-CD                            
           END-EVALUATE.                                                
                                                                        
           MOVE LINK-COMPANY-NO     TO 6P-COMPANY-NO                    
                                       1P-COMPANY-NO.                   
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
             SELECT                                                     
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,PROC_REQ_ID                                               
             ,COMPANY_NO                                                
             ,CODE_UTIL_TYPE                                            
             ,PROC_REQ_DESC                                             
             ,PROC_TYPE_CD                                              
             ,STATUS_SEQ_NO                                             
             ,PROC_FLOW_IND                                             
             ,PROC_STATUS_CD                                            
             ,PROC_GROUP_CD                                             
             ,CREATED_BY_USERID                                         
             ,CREATED_TS                                                
             ,CATEGORY_ID                                               
             ,PROC_REQ_DUE_TS                                           
             ,LAST_UPDATE_USERID                                        
             ,LAST_UPDATE_TS                                            
             ,EFFECTIVE_TS                                              
             ,HAS_ACCESS_FL                                             
             ,OVERDUE_FL                                                
             ,CAN_DELETE_FL                                             
                FROM #CSR04505_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*      SELECT                                                             
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,PROC_REQ_ID                                                       
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,PROC_REQ_DESC                                                     
MFA-TR*      ,PROC_TYPE_CD                                                      
MFA-TR*      ,STATUS_SEQ_NO                                                     
MFA-TR*      ,PROC_FLOW_IND                                                     
MFA-TR*      ,PROC_STATUS_CD                                                    
MFA-TR*      ,PROC_GROUP_CD                                                     
MFA-TR*      ,CREATED_BY_USERID                                                 
MFA-TR*      ,CREATED_TS                                                        
MFA-TR*      ,CATEGORY_ID                                                       
MFA-TR*      ,PROC_REQ_DUE_TS                                                   
MFA-TR*      ,LAST_UPDATE_USERID                                                
MFA-TR*      ,LAST_UPDATE_TS                                                    
MFA-TR*      ,EFFECTIVE_TS                                                      
MFA-TR*      ,HAS_ACCESS_FL                                                     
MFA-TR*      ,OVERDUE_FL                                                        
MFA-TR*      ,CAN_DELETE_FL                                                     
MFA-TR*         FROM SESSION.CSR04505_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04505_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04505_R1
              (                                                        
                   RETURN_CODE             INT                      
                  ,APPL_RETURN_CODE        INT                      
                  ,PROC_REQ_ID             DECIMAL(10,0)                
                  ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_REQ_DESC CHAR(100)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
                  ,PROC_TYPE_CD CHAR(06)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,STATUS_SEQ_NO           INT                      
                  ,PROC_FLOW_IND CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,PROC_GROUP_CD CHAR(12)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,CREATED_BY_USERID CHAR(07)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,CREATED_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CATEGORY_ID             INT                      
                  ,PROC_REQ_DUE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,EFFECTIVE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,HAS_ACCESS_FL CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
                  ,OVERDUE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                  ,CAN_DELETE_FL CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                     
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 0150A-DELETE-GTT-ROWS THRU 0150A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  INITIALIZE                   GTT-RETURN-FIELDS        
                  MOVE 100                  TO S-RETURN-CODE            
                  ADD 1                     TO CTR-ROWS                 
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                                               S-APPL-RETURN-CODE       
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04505_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 0150A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       0150A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
                                                                        
            EXEC SQL                                                    
                DELETE FROM #CSR04505_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04505_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                CONTINUE                                                
            ELSE                                                        
               INITIALIZE                   GTT-RETURN-FIELDS           
               MOVE 100                  TO S-RETURN-CODE               
               ADD 1                     TO CTR-ROWS                    
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
                                            S-APPL-RETURN-CODE          
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04505_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       0150A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * COPYBOOK TO BE SHARED BETWEEN BATCH AND ONLINE SUBMODULES      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00727                                                 
           END-EXEC.                                                            
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04505_R1                       
                 ( RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,PROC_REQ_ID                                          
                  ,COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,PROC_REQ_DESC                                        
                  ,PROC_TYPE_CD                                         
                  ,STATUS_SEQ_NO                                        
                  ,PROC_FLOW_IND                                        
                  ,PROC_STATUS_CD                                       
                  ,PROC_GROUP_CD                                        
                  ,CREATED_BY_USERID                                    
                  ,CREATED_TS                                           
                  ,CATEGORY_ID                                          
                  ,PROC_REQ_DUE_TS                                      
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,EFFECTIVE_TS                                         
                  ,HAS_ACCESS_FL                                        
                  ,OVERDUE_FL                                           
                  ,CAN_DELETE_FL                                        
                  )                                                     
               VALUES                                                   
               (    :S-RETURN-CODE                                      
                   ,:S-APPL-RETURN-CODE                                 
                   ,:S-PROC-REQ-ID                                      
                   ,:S-COMPANY-NO                                       
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-PROC-REQ-DESC                                    
                   ,:S-PROC-TYPE-CD                                     
                   ,:S-STATUS-SEQ-NO                                    
                   ,:S-PROC-FLOW-IND                                    
                   ,:S-PROC-STATUS-CD                                   
                   ,:S-PROC-GROUP-CD                                    
                   ,:S-CREATED-BY-USERID                                
                   ,:S-CREATED-TS                                       
                   ,:S-CATEGORY-ID                                      
                   ,:S-PROC-REQ-DUE-TS                                  
                   ,:S-LAST-UPDATE-USERID                               
                   ,:S-LAST-UPDATE-TS                                   
                   ,:S-EFFECTIVE-TS                                     
                   ,:S-HAS-ACCESS-FL                                    
                   ,:S-OVERDUE-FL                                       
                   ,:S-CAN-DELETE-FL                                    
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04505_R1                               
MFA-TR*          ( RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,PROC_REQ_DESC                                                
MFA-TR*           ,PROC_TYPE_CD                                                 
MFA-TR*           ,STATUS_SEQ_NO                                                
MFA-TR*           ,PROC_FLOW_IND                                                
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_GROUP_CD                                                
MFA-TR*           ,CREATED_BY_USERID                                            
MFA-TR*           ,CREATED_TS                                                   
MFA-TR*           ,CATEGORY_ID                                                  
MFA-TR*           ,PROC_REQ_DUE_TS                                              
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,EFFECTIVE_TS                                                 
MFA-TR*           ,HAS_ACCESS_FL                                                
MFA-TR*           ,OVERDUE_FL                                                   
MFA-TR*           ,CAN_DELETE_FL                                                
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*        (    :S-RETURN-CODE                                              
MFA-TR*            ,:S-APPL-RETURN-CODE                                         
MFA-TR*            ,:S-PROC-REQ-ID                                              
MFA-TR*            ,:S-COMPANY-NO                                               
MFA-TR*            ,:S-CODE-UTIL-TYPE                                           
MFA-TR*            ,:S-PROC-REQ-DESC                                            
MFA-TR*            ,:S-PROC-TYPE-CD                                             
MFA-TR*            ,:S-STATUS-SEQ-NO                                            
MFA-TR*            ,:S-PROC-FLOW-IND                                            
MFA-TR*            ,:S-PROC-STATUS-CD                                           
MFA-TR*            ,:S-PROC-GROUP-CD                                            
MFA-TR*            ,:S-CREATED-BY-USERID                                        
MFA-TR*            ,:S-CREATED-TS                                               
MFA-TR*            ,:S-CATEGORY-ID                                              
MFA-TR*            ,:S-PROC-REQ-DUE-TS                                          
MFA-TR*            ,:S-LAST-UPDATE-USERID                                       
MFA-TR*            ,:S-LAST-UPDATE-TS                                           
MFA-TR*            ,:S-EFFECTIVE-TS                                             
MFA-TR*            ,:S-HAS-ACCESS-FL                                            
MFA-TR*            ,:S-OVERDUE-FL                                               
MFA-TR*            ,:S-CAN-DELETE-FL                                            
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1 TO CTR-ROWS                                         
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04505_R1'        TO TABLE-1                      
              MOVE SPACES               TO TABLE-ELEMENT-1              
              MOVE SPACES               TO HOSTVAR-ELEMENT-1            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***********************************************************               
      * JOURNALING / ERROR HANDLING ROUTINE                     *               
      * 9900-SQL-ERROR-ROUTINE                                  *               
      * 9975-ABEND-CONTROL-TRANSFER                             *               
      ***********************************************************               
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
