       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04504.                                          
       AUTHOR.       GOPI DUGGIRALA.                                    
       DATE-WRITTEN. JAN 30, 2013.                                      
       DATE-COMPILED.                                                   
      *****************************************************************         
      **                          SCE&G                              **         
      *****************************************************************         
      **                STORED PROCEDURE: CSR04504                   **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      ** THIS PROGRAM WILL BE USED IN REVENUE ADJUSTMENTS PROCESS    **         
      ** FOR ALL DATABASE UPDATES.                                   **         
      **                                                             **         
      ** PARAMETERS                                                  **         
      **                                                             **         
      **  INPUT                                                      **         
      **   I_CALL_TYPE             CHAR(01)                          **         
      **   I_BILL_UNIQUE_TS        CHAR(26)                          **         
      **   I_REVENUE_MONTH         CHAR(06)                          **         
      **   I_CODE_UTIL_TYPE        CHAR(01)                          **         
      **   I_ACCOUNT_NO            CHAR(13)                          **         
      **   I_CUST_CT               CHAR(10)                          **         
      **   I_USAGE_END_DATE        CHAR(10)                          **         
      **   I_NO_OF_CONS_DAYS       CHAR(05)                          **         
      **   I_BTU_FACTOR            CHAR(09)                          **         
      **   I_GAS_BASE_USE          CHAR(10)                          **         
      **   I_CODE_REVENUE_CLASS    CHAR(03)                          **         
      **   I_RATE_PLAN_NO          CHAR(03)                          **         
      **   I_LOCAL_OFFICE          CHAR(03)                          **         
      **   I_REV_DISTRICT_CD       CHAR(03)                          **         
      **   I_CALC_SOURCE_CD        CHAR(01)                          **         
      **   I_REV_POST_STATUS_FL    CHAR(01)                          **         
      **   I_SUMMARY_UPDT_FL       CHAR(01)                          **         
      **   I_GL_INTRFCE_DB_ACCT    CHAR(08)                          **         
      **   I_GL_INTRFCE_CR_ACCT    CHAR(08)                          **         
      **   I_USER_ID               CHAR(07)                          **         
      **   I_COMMENTS              VARCHAR(250)                      **         
      **   I_REV_ADJ_DET_01        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_02        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_03        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_04        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_05        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_06        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_07        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_08        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_09        VARCHAR(126)                      **         
      **   I_REV_ADJ_DET_10        VARCHAR(126)                      **         
      **                                                             **         
      **  OUTPUT                                                     **         
      **   RETURN_CODE             INTEGER                           **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM MODIFICATION LOG                       **         
      ** DATE        INITIALS     REASON                             **         
      ** --------    ---------    ---------------------------------- **         
P00641** 02/04/13    GD43988      NEW PROGRAM.                       **         
A04581** 05/15/13    GD43988      1.ADDED BILL USAGE/DEMAND UNITS.   **         
A04581**                          2.REMOVED CALC UNITS.              **         
PRDFIX** 09/24/13    GD43988      FIXED LINKAGE LENGTH ISSUE.        **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04504'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_JOB_PARM, G6                                                     
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_DELINQUENCY, C8                                                  
           EXEC SQL                                                             
             INCLUDE TBDELQ                                                     
           END-EXEC.                                                            
      *                                                                         
      **** CSS_MNICPLTY_CNTY, F4                                                
           EXEC SQL                                                             
              INCLUDE TBMNCCTY                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_LOCAL_OFFICE, B1                                                 
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
      *                                                                         
      **** CSS_RATE_PLAN_DESC, RD                                               
           EXEC SQL                                                             
             INCLUDE TBRTDESC                                                   
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILLING_DET, RV                                                  
           EXEC SQL                                                             
               INCLUDE TBREVBLD                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILL_COMP_ADJ, RB                                                
           EXEC SQL                                                             
               INCLUDE TBREVCOM                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILL_BLOCK, R7                                                   
           EXEC SQL                                                             
               INCLUDE TBREVBLK                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILL_TAX, R9                                                     
           EXEC SQL                                                             
               INCLUDE TBREVTAX                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILL_MISC_INFO, 2Z                                               
           EXEC SQL                                                             
               INCLUDE TBREVBIL                                                 
           END-EXEC.                                                            
      *                                                                         
      **** CSS_TAX_CNTL, TC                                                     
           EXEC SQL                                                             
               INCLUDE TBTXCNTL                                                 
           END-EXEC.                                                            
      *                                                                         
      *** CSS_TAX_RATE, TR                                                      
           EXEC SQL                                                             
              INCLUDE TBTXRATE                                                  
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME               PIC X(08) VALUE 'CSR04504'.   
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                          PIC S9(9) COMP.          
           05  PARM-CALL-TYPE                  PIC X(01).               
           05  PARM-BILL-UNIQUE-TS             PIC X(26).               
           05  PARM-REVENUE-MONTH              PIC X(06).               
           05  PARM-REVENUE-MONTH-NUM REDEFINES                         
               PARM-REVENUE-MONTH              PIC 9(06).               
           05  PARM-CODE-UTIL-TYPE             PIC X(01).               
           05  PARM-ACCOUNT-NO                 PIC X(13).               
           05  PARM-ACCOUNT-NO-NUM    REDEFINES                         
               PARM-ACCOUNT-NO                 PIC 9(13).               
           05  PARM-CUST-CT.                                            
               10  PARM-CUST-CT-SGN            PIC X(01).               
               10  PARM-CUST-CT-VAL            PIC X(09).               
           05  PARM-USAGE-END-DATE             PIC X(10).               
           05  PARM-NO-OF-CONS-DAYS.                                    
               10  PARM-NO-OF-CONS-DAYS-SGN    PIC X(01).               
               10  PARM-NO-OF-CONS-DAYS-VAL    PIC X(04).               
           05  PARM-BTU-FACTOR.                                         
               10  PARM-BTU-FACTOR-SGN         PIC X(01).               
               10  PARM-BTU-FACTOR-VAL         PIC X(08).               
           05  PARM-GAS-BASE-USE.                                       
               10  PARM-GAS-BASE-USE-SGN       PIC X(01).               
               10  PARM-GAS-BASE-USE-VAL       PIC X(09).               
           05  PARM-CODE-REVENUE-CLASS         PIC X(03).               
           05  PARM-RATE-PLAN-NO               PIC X(03).               
           05  PARM-LOCAL-OFFICE               PIC X(03).               
           05  PARM-REV-DISTRICT-CD            PIC X(03).               
           05  PARM-CALC-SOURCE-CD             PIC X(01).               
           05  PARM-REV-POST-STATUS-FL         PIC X(01).               
           05  PARM-SUMMARY-UPDT-FL            PIC X(01).               
           05  PARM-GL-INTRFCE-DB-ACCT         PIC X(08).               
           05  PARM-GL-INTRFCE-CR-ACCT         PIC X(08).               
           05  PARM-USER-ID                    PIC X(07).               
           05  PARM-COMMENTS.                                           
               49  PARM-COMMENTS-LEN           PIC S9(4) USAGE COMP.    
               49  PARM-COMMENTS-TEXT          PIC X(248).              
      *                                                                         
           05  PARM-REV-ADJ-DET.                                        
               49  PARM-REV-ADJ-DET-LEN        PIC S9(4) USAGE COMP.    
A04581         49  PARM-REV-ADJ-DET-TEXT       PIC X(124).              
      *                                                                         
       01  WS-PARSED-REV-ADJ-SUMMARY.                                   
           05  WS-P-CUST-CT               PIC S9(9) USAGE COMP.         
           05  WS-P-NO-OF-CONS-DAYS       PIC S9(4) USAGE COMP.         
COB305     05 WS-P-BTU-FACTOR        PIC S9(2)V9(5) USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-P-GAS-BASE-USE        PIC S9(9)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-P-GL-INTRFCE-DB-ACCT        PIC S9(3)V9(4) 
COB305       USAGE COMP-3 VALUE 0.  
COB305     05 WS-P-GL-INTRFCE-CR-ACCT        PIC S9(3)V9(4) 
COB305       USAGE COMP-3 VALUE 0.  
      *                                                                         
       01  WS-PARSED-REV-ADJ-DET.                                       
           05  WS-P-BILL-COMP-SEQ-NO           PIC X(04).               
           05  WS-P-CMPNT-ID-CD                PIC X(02).               
           05  WS-P-CONSUMPT-TYPE-CD           PIC X(01).               
           05  WS-P-CODE-TIME-PERIOD           PIC X(04).               
           05  WS-P-RT-VERS-FROM-DT            PIC X(10).               
           05  WS-P-FACTOR-ID                  PIC X(09).               
           05  WS-P-FACTOR-BLOCK-NO.                                    
               10  WS-P-FACTOR-BLOCK-NO-SGN    PIC X(01).               
               10  WS-P-FACTOR-BLOCK-NO-VAL    PIC X(09).               
           05  WS-P-READ-UNITS.                                         
               10  WS-P-READ-UNITS-SGN         PIC X(01).               
               10  WS-P-READ-UNITS-VAL         PIC X(09).               
A04581     05  WS-P-BILL-UNITS.                                         
A04581         10  WS-P-BILL-UNITS-SGN         PIC X(01).               
A04581         10  WS-P-BILL-UNITS-VAL         PIC X(09).               
A04581     05  WS-P-DEMAND-UNITS.                                       
A04581         10  WS-P-DEMAND-UNITS-SGN       PIC X(01).               
A04581         10  WS-P-DEMAND-UNITS-VAL       PIC X(09).               
           05  WS-P-FACTOR.                                             
               10  WS-P-FACTOR-SGN             PIC X(01).               
               10  WS-P-FACTOR-VAL             PIC X(16).               
           05  WS-P-FACTOR-AMT.                                         
               10  WS-P-FACTOR-AMT-SGN         PIC X(01).               
               10  WS-P-FACTOR-AMT-VAL         PIC X(12).               
           05  WS-P-GL-ACCT-NO                 PIC X(08).               
           05  WS-P-TAX-TYPE                   PIC X(01).               
           05  WS-P-TAX-CNTRL-NO               PIC X(04).               
           05  WS-P-TAX-FROM-DT                PIC X(10).               
           05  WS-P-ROW-UPDT-FL                PIC X(01).               
      *                                                                         
       01  WS-REV-ADJ-COMP-ADJ-DATA.                                    
           05  WS-COMP-ADJ-DATA OCCURS 10 TIMES INDEXED BY WS-C-INDX.   
               10  WS-C-COMP-SEQ          PIC S9(4) USAGE COMP.         
               10  WS-C-CMPNT-ID          PIC X(2).                     
               10  WS-C-CONSUMPT-TYPE     PIC X(1).                     
               10  WS-C-CD-TIME-PRD       PIC S9(4) USAGE COMP.         
               10  WS-C-RT-VERS-FROM-DT   PIC X(10).                    
               10  WS-C-FACTOR-ID         PIC X(9).                     
               10  WS-C-FACTOR-BLK-NO     PIC S9(9) USAGE COMP.         
COB305         10 WS-C-READ-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.      
COB305         10 WS-C-BILL-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.      
COB305         10 WS-C-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.      
COB305         10 WS-C-FACTOR        PIC S9(9)V9(6) USAGE COMP-3 
COB305           VALUE 0.  
COB305         10 WS-C-BILLED-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.  
COB305         10 WS-C-GL-ACCT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305           VALUE 0.  
               10  WS-C-ROW-UPDT-FL       PIC X(01).                    
      *                                                                         
       01  WS-REV-ADJ-BILL-TAX-DATA.                                    
           05  WS-BILL-TAX-DATA OCCURS 10 TIMES INDEXED BY WS-T-INDX.   
               10  WS-T-FACTOR-ID         PIC X(9).                     
COB305         10 WS-T-GL-ACCT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305           VALUE 0.  
COB305         10 WS-T-TAX-AMT        PIC S9(7)V9(2) USAGE COMP-3 
COB305           VALUE 0.  
               10  WS-T-TAX-TYPE          PIC X(1).                     
               10  WS-T-TAX-CNTRL-NO      PIC S9(4) USAGE COMP.         
               10  WS-T-TAX-FROM-DT       PIC X(10).                    
               10  WS-T-ROW-UPDT-FL       PIC X(01).                    
      *                                                                         
       01  WS-FORMAT-VARIABLES.                                         
      *                                                                         
           05  WS-FMT-S4-SIGN             PIC S9(4).                    
           05  WS-FMT-S9-SIGN             PIC S9(9).                    
      *                                                                         
           05  WS-FMT-S2V5-GRP.                                         
               10 WS-FMT-S2V5-GRP-INT     PIC  9(2).                    
               10 WS-FMT-S2V5-GRP-FRA     PIC  9(5).                    
           05  WS-FMT-S2V5                PIC S9(7).                    
           05  WS-FMT-S2V5-SIGN REDEFINES WS-FMT-S2V5 PIC S9(2)V9(5).   
      *                                                                         
           05  WS-FMT-S3V4-GRP.                                         
               10 WS-FMT-S3V4-GRP-INT     PIC  9(3).                    
               10 WS-FMT-S3V4-GRP-FRA     PIC  9(4).                    
           05  WS-FMT-S3V4                PIC S9(7).                    
           05  WS-FMT-S3V4-SIGN REDEFINES WS-FMT-S3V4 PIC S9(3)V9(4).   
      *                                                                         
           05  WS-FMT-S7V2-GRP.                                         
               10 WS-FMT-S7V2-GRP-INT     PIC  9(7).                    
               10 WS-FMT-S7V2-GRP-FRA     PIC  9(2).                    
           05  WS-FMT-S7V2                PIC S9(9).                    
           05  WS-FMT-S7V2-SIGN REDEFINES WS-FMT-S7V2 PIC S9(7)V9(2).   
      *                                                                         
           05  WS-FMT-S9V2-GRP.                                         
               10 WS-FMT-S9V2-GRP-INT     PIC  9(9).                    
               10 WS-FMT-S9V2-GRP-FRA     PIC  9(2).                    
           05  WS-FMT-S9V2                PIC S9(11).                   
           05  WS-FMT-S9V2-SIGN REDEFINES WS-FMT-S9V2 PIC S9(9)V9(2).   
      *                                                                         
           05  WS-FMT-S9V6-GRP.                                         
               10 WS-FMT-S9V6-GRP-INT     PIC  9(9).                    
               10 WS-FMT-S9V6-GRP-FRA     PIC  9(6).                    
           05  WS-FMT-S9V6                PIC S9(15).                   
           05  WS-FMT-S9V6-SIGN REDEFINES WS-FMT-S9V6 PIC S9(9)V9(6).   
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-DATABASE                  PIC 9(01) VALUE 0.          
               88  CSR-DATABASE                       VALUE 1.          
               88  SEB-DATABASE                       VALUE 2.          
      *                                                                         
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88  SEND-DONE-ERROR                    VALUE 'N'.        
               88  SEND-DONE-OK                       VALUE 'Y'.        
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-DATE-NULL-1               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-2               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-3               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-4               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-5               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-6               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-7               PIC S9(04) COMP VALUE +0.   
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05  WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.     
           05  WS-CURR-TS-PLUS-1-MONTH      PIC X(26) VALUE SPACES.     
           05  WS-BILL-UNIQUE-TS-OLD        PIC X(26) VALUE SPACES.     
           05  WS-BILL-UNIQUE-TS-NEW        PIC X(26) VALUE SPACES.     
           05  WS-TAX-FACTOR-FLAG           PIC X(01) VALUE SPACES.     
           05  WS-COMP-SEQ-COUNT            PIC S9(4) COMP VALUE 0.     
           05  WS-REV-MTH-TEMP              PIC 9(06).                  
           05  WS-REV-MTH-TEMP-N REDEFINES WS-REV-MTH-TEMP.             
               10  WS-REV-MTH-TEMP-YYYY     PIC 9(04).                  
               10  WS-REV-MTH-TEMP-MM       PIC 9(02).                  
COB305     05 WS-REV-MTH-FUTURE-OFFSET        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.    
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-CALL-TYPE             PIC X(01).                        
       01  LINK-BILL-UNIQUE-TS        PIC X(26).                        
       01  LINK-REVENUE-MONTH         PIC X(06).                        
       01  LINK-CODE-UTIL-TYPE        PIC X(01).                        
       01  LINK-ACCOUNT-NO            PIC X(13).                        
       01  LINK-CUST-CT               PIC X(10).                        
       01  LINK-USAGE-END-DATE        PIC X(10).                        
       01  LINK-NO-OF-CONS-DAYS       PIC X(05).                        
       01  LINK-BTU-FACTOR            PIC X(09).                        
       01  LINK-GAS-BASE-USE          PIC X(10).                        
       01  LINK-CODE-REVENUE-CLASS    PIC X(03).                        
       01  LINK-RATE-PLAN-NO          PIC X(03).                        
       01  LINK-LOCAL-OFFICE          PIC X(03).                        
       01  LINK-REV-DISTRICT-CD       PIC X(03).                        
       01  LINK-CALC-SOURCE-CD        PIC X(01).                        
       01  LINK-REV-POST-STATUS-FL    PIC X(01).                        
       01  LINK-SUMMARY-UPDT-FL       PIC X(01).                        
       01  LINK-GL-INTRFCE-DB-ACCT    PIC X(08).                        
       01  LINK-GL-INTRFCE-CR-ACCT    PIC X(08).                        
       01  LINK-USER-ID               PIC X(07).                        
       01  LINK-COMMENTS              PIC X(250).                       
       01  LINK-REV-ADJ-DET-01        PIC X(126).                       
       01  LINK-REV-ADJ-DET-02        PIC X(126).                       
       01  LINK-REV-ADJ-DET-03        PIC X(126).                       
       01  LINK-REV-ADJ-DET-04        PIC X(126).                       
       01  LINK-REV-ADJ-DET-05        PIC X(126).                       
       01  LINK-REV-ADJ-DET-06        PIC X(126).                       
       01  LINK-REV-ADJ-DET-07        PIC X(126).                       
       01  LINK-REV-ADJ-DET-08        PIC X(126).                       
       01  LINK-REV-ADJ-DET-09        PIC X(126).                       
       01  LINK-REV-ADJ-DET-10        PIC X(126).                       
      *                                                                         
       PROCEDURE DIVISION USING  LINK-CALL-TYPE                         
                                ,LINK-BILL-UNIQUE-TS                    
                                ,LINK-REVENUE-MONTH                     
                                ,LINK-CODE-UTIL-TYPE                    
                                ,LINK-ACCOUNT-NO                        
                                ,LINK-CUST-CT                           
                                ,LINK-USAGE-END-DATE                    
                                ,LINK-NO-OF-CONS-DAYS                   
                                ,LINK-BTU-FACTOR                        
                                ,LINK-GAS-BASE-USE                      
                                ,LINK-CODE-REVENUE-CLASS                
                                ,LINK-RATE-PLAN-NO                      
                                ,LINK-LOCAL-OFFICE                      
                                ,LINK-REV-DISTRICT-CD                   
                                ,LINK-CALC-SOURCE-CD                    
                                ,LINK-REV-POST-STATUS-FL                
                                ,LINK-SUMMARY-UPDT-FL                   
                                ,LINK-GL-INTRFCE-DB-ACCT                
                                ,LINK-GL-INTRFCE-CR-ACCT                
                                ,LINK-USER-ID                           
                                ,LINK-COMMENTS                          
                                ,LINK-REV-ADJ-DET-01                    
                                ,LINK-REV-ADJ-DET-02                    
                                ,LINK-REV-ADJ-DET-03                    
                                ,LINK-REV-ADJ-DET-04                    
                                ,LINK-REV-ADJ-DET-05                    
                                ,LINK-REV-ADJ-DET-06                    
                                ,LINK-REV-ADJ-DET-07                    
                                ,LINK-REV-ADJ-DET-08                    
                                ,LINK-REV-ADJ-DET-09                    
                                ,LINK-REV-ADJ-DET-10.                   
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE           THRU  0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT        THRU  1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT       THRU  2000-EXIT.           
           PERFORM 9999-END-PROGRAM          THRU  9999-EXIT.           
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS          
                                             PARM-REV-ADJ-DET           
                                             WS-PARSED-REV-ADJ-SUMMARY  
                                             WS-PARSED-REV-ADJ-DET      
                                             WS-REV-ADJ-COMP-ADJ-DATA   
                                             WS-REV-ADJ-BILL-TAX-DATA   
                                             WS-FORMAT-VARIABLES.       
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT          THRU  0100A-EXIT.         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE                               **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04504_R1'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04504_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04504_R1
              (                                                    
                       RETURN_CODE            INT                   
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000-DELETE-GTT-ROWS  THRU  8000-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE           
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04504_R1'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
               FROM #CSR04504_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*        FROM SESSION.CSR04504_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-CALL-TYPE            TO PARM-CALL-TYPE.            
           MOVE LINK-BILL-UNIQUE-TS       TO PARM-BILL-UNIQUE-TS.       
           IF LINK-REVENUE-MONTH GREATER THAN SPACES                    
              MOVE LINK-REVENUE-MONTH     TO PARM-REVENUE-MONTH         
           END-IF.                                                      
           MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE.       
           IF LINK-ACCOUNT-NO GREATER THAN SPACES                       
              MOVE LINK-ACCOUNT-NO        TO PARM-ACCOUNT-NO            
           END-IF.                                                      
      *                                                                         
           IF LINK-CUST-CT GREATER THAN SPACES                          
              MOVE LINK-CUST-CT           TO PARM-CUST-CT               
              MOVE PARM-CUST-CT-VAL       TO WS-FMT-S9-SIGN             
              IF PARM-CUST-CT-SGN = '-'                                 
                 COMPUTE WS-FMT-S9-SIGN = WS-FMT-S9-SIGN * -1           
              END-IF                                                    
              MOVE WS-FMT-S9-SIGN         TO WS-P-CUST-CT               
           END-IF.                                                      
      *                                                                         
           MOVE LINK-USAGE-END-DATE       TO PARM-USAGE-END-DATE.       
      *                                                                         
           IF LINK-NO-OF-CONS-DAYS GREATER THAN SPACES                  
              MOVE LINK-NO-OF-CONS-DAYS   TO PARM-NO-OF-CONS-DAYS       
              MOVE PARM-NO-OF-CONS-DAYS-VAL TO WS-FMT-S4-SIGN           
              IF PARM-NO-OF-CONS-DAYS-SGN = '-'                         
                 COMPUTE WS-FMT-S4-SIGN = WS-FMT-S4-SIGN * -1           
              END-IF                                                    
              MOVE WS-FMT-S4-SIGN         TO WS-P-NO-OF-CONS-DAYS       
           END-IF.                                                      
      *                                                                         
           IF LINK-BTU-FACTOR GREATER THAN SPACES                       
              MOVE LINK-BTU-FACTOR           TO PARM-BTU-FACTOR         
              MOVE PARM-BTU-FACTOR-VAL(1:2)  TO WS-FMT-S2V5-GRP-INT     
              MOVE PARM-BTU-FACTOR-VAL(4:5)  TO WS-FMT-S2V5-GRP-FRA     
              MOVE WS-FMT-S2V5-GRP           TO WS-FMT-S2V5             
              IF PARM-BTU-FACTOR-SGN = '-'                              
                 COMPUTE WS-FMT-S2V5 = WS-FMT-S2V5 * -1                 
              END-IF                                                    
              MOVE WS-FMT-S2V5-SIGN       TO WS-P-BTU-FACTOR            
           END-IF.                                                      
      *                                                                         
           IF LINK-GAS-BASE-USE GREATER THAN SPACES                     
              MOVE LINK-GAS-BASE-USE      TO PARM-GAS-BASE-USE          
              MOVE PARM-GAS-BASE-USE-VAL  TO WS-FMT-S9-SIGN             
              IF PARM-GAS-BASE-USE-SGN = '-'                            
                 COMPUTE WS-FMT-S9-SIGN = WS-FMT-S9-SIGN * -1           
              END-IF                                                    
              MOVE WS-FMT-S9-SIGN         TO WS-P-GAS-BASE-USE          
           END-IF.                                                      
      *                                                                         
           MOVE LINK-CODE-REVENUE-CLASS   TO PARM-CODE-REVENUE-CLASS.   
           MOVE LINK-RATE-PLAN-NO         TO PARM-RATE-PLAN-NO.         
           MOVE LINK-LOCAL-OFFICE         TO PARM-LOCAL-OFFICE.         
           MOVE LINK-REV-DISTRICT-CD      TO PARM-REV-DISTRICT-CD.      
           MOVE LINK-CALC-SOURCE-CD       TO PARM-CALC-SOURCE-CD.       
           MOVE LINK-REV-POST-STATUS-FL   TO PARM-REV-POST-STATUS-FL.   
           MOVE LINK-SUMMARY-UPDT-FL      TO PARM-SUMMARY-UPDT-FL.      
      *                                                                         
           IF LINK-GL-INTRFCE-DB-ACCT GREATER THAN SPACES               
              MOVE LINK-GL-INTRFCE-DB-ACCT TO PARM-GL-INTRFCE-DB-ACCT   
              MOVE PARM-GL-INTRFCE-DB-ACCT(1:3) TO WS-FMT-S3V4-GRP-INT  
              MOVE PARM-GL-INTRFCE-DB-ACCT(5:4) TO WS-FMT-S3V4-GRP-FRA  
              MOVE WS-FMT-S3V4-GRP        TO WS-FMT-S3V4                
              MOVE WS-FMT-S3V4-SIGN       TO WS-P-GL-INTRFCE-DB-ACCT    
           END-IF.                                                      
      *                                                                         
           IF LINK-GL-INTRFCE-CR-ACCT GREATER THAN SPACES               
              MOVE LINK-GL-INTRFCE-CR-ACCT TO PARM-GL-INTRFCE-CR-ACCT   
              MOVE PARM-GL-INTRFCE-CR-ACCT(1:3) TO WS-FMT-S3V4-GRP-INT  
              MOVE PARM-GL-INTRFCE-CR-ACCT(5:4) TO WS-FMT-S3V4-GRP-FRA  
              MOVE WS-FMT-S3V4-GRP        TO WS-FMT-S3V4                
              MOVE WS-FMT-S3V4-SIGN       TO WS-P-GL-INTRFCE-CR-ACCT    
           END-IF.                                                      
      *                                                                         
           MOVE LINK-USER-ID              TO PARM-USER-ID.              
           MOVE LINK-COMMENTS             TO PARM-COMMENTS.             
      *                                                                         
           SET WS-C-INDX                  TO 1.                         
           SET WS-T-INDX                  TO 1.                         
      *                                                                         
           MOVE LINK-REV-ADJ-DET-01       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-02       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-03       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-04       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-05       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-06       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-07       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-08       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-09       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
           MOVE LINK-REV-ADJ-DET-10       TO PARM-REV-ADJ-DET.          
           IF PARM-REV-ADJ-DET-TEXT GREATER THAN SPACES                 
              PERFORM 1050-LOAD-REV-ADJ-DET-ARRAYS  THRU  1050-EXIT     
           END-IF.                                                      
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** LOAD REV ADJ DET ARRAYS - COMP_ADJ, BILL_TAX ETC             **        
      ******************************************************************        
      *                                                                         
       1050-LOAD-REV-ADJ-DET-ARRAYS.                                    
      *                                                                         
           MOVE '1050'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE PARM-REV-ADJ-DET-TEXT     TO WS-PARSED-REV-ADJ-DET.     
      *                                                                         
      **** LOAD COMPONENT ADJ ARRAY / TAX ARRAY                                 
      *                                                                         
           EVALUATE TRUE                                                
               WHEN WS-P-TAX-TYPE GREATER THAN SPACES                   
                    PERFORM 1070-LOAD-BILL-TAX-ARRAY THRU 1070-EXIT     
               WHEN (WS-P-FACTOR-ID = 'STATE TAX' OR 'FRAN TAX' OR      
                                      'State Tax' OR 'Fran Tax' )       
                    PERFORM 1070-LOAD-BILL-TAX-ARRAY THRU 1070-EXIT     
               WHEN OTHER                                               
                    MOVE 'N'              TO WS-TAX-FACTOR-FLAG         
                    MOVE WS-P-FACTOR-ID   TO TC-FACTOR-ID               
                    PERFORM 7040-CHECK-TAX-FACTOR       THRU 7040-EXIT  
                    IF WS-TAX-FACTOR-FLAG = 'Y'                         
                       PERFORM 1070-LOAD-BILL-TAX-ARRAY THRU 1070-EXIT  
                    ELSE                                                
                       PERFORM 1060-LOAD-COMP-ADJ-ARRAY THRU 1060-EXIT  
                    END-IF                                              
           END-EVALUATE.                                                
      *                                                                         
           INITIALIZE                        PARM-REV-ADJ-DET           
                                             WS-PARSED-REV-ADJ-DET      
                                             WS-FORMAT-VARIABLES.       
      *                                                                         
       1050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** LOAD BILL COMP ADJ ARRAY                                     **        
      ******************************************************************        
      *                                                                         
       1060-LOAD-COMP-ADJ-ARRAY.                                        
      *                                                                         
           MOVE '1060'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF PARM-CALL-TYPE = 'I' OR 'F' OR 'A'                        
              ADD 1                      TO WS-COMP-SEQ-COUNT           
              MOVE WS-COMP-SEQ-COUNT     TO WS-C-COMP-SEQ(WS-C-INDX)    
           ELSE                                                         
              MOVE WS-P-BILL-COMP-SEQ-NO TO WS-FMT-S4-SIGN              
              MOVE WS-FMT-S4-SIGN        TO WS-C-COMP-SEQ(WS-C-INDX)    
           END-IF.                                                      
      *                                                                         
           MOVE WS-P-CMPNT-ID-CD       TO WS-C-CMPNT-ID(WS-C-INDX).     
           MOVE WS-P-CONSUMPT-TYPE-CD  TO WS-C-CONSUMPT-TYPE(WS-C-INDX).
      *                                                                         
           IF WS-P-CODE-TIME-PERIOD GREATER THAN SPACES                 
              MOVE WS-P-CODE-TIME-PERIOD  TO WS-FMT-S4-SIGN             
              MOVE WS-FMT-S4-SIGN         TO WS-C-CD-TIME-PRD(WS-C-INDX)
           END-IF.                                                      
      *                                                                         
           MOVE WS-P-RT-VERS-FROM-DT TO WS-C-RT-VERS-FROM-DT(WS-C-INDX).
           MOVE WS-P-FACTOR-ID       TO WS-C-FACTOR-ID(WS-C-INDX).      
      *                                                                         
           IF WS-P-FACTOR-BLOCK-NO GREATER THAN SPACES                  
              MOVE WS-P-FACTOR-BLOCK-NO-VAL  TO WS-FMT-S9-SIGN          
              IF WS-P-FACTOR-BLOCK-NO-SGN = '-'                         
                 COMPUTE WS-FMT-S9-SIGN = WS-FMT-S9-SIGN * -1           
              END-IF                                                    
              MOVE WS-FMT-S9-SIGN    TO WS-C-FACTOR-BLK-NO(WS-C-INDX)   
           END-IF.                                                      
      *                                                                         
           IF WS-P-READ-UNITS GREATER THAN SPACES                       
              MOVE WS-P-READ-UNITS-VAL    TO WS-FMT-S9-SIGN             
              IF WS-P-READ-UNITS-SGN = '-'                              
                 COMPUTE WS-FMT-S9-SIGN = WS-FMT-S9-SIGN * -1           
              END-IF                                                    
              MOVE WS-FMT-S9-SIGN    TO WS-C-READ-UNITS(WS-C-INDX)      
           END-IF.                                                      
      *                                                                         
A04581     IF WS-P-BILL-UNITS GREATER THAN SPACES                       
A04581        MOVE WS-P-BILL-UNITS-VAL    TO WS-FMT-S9-SIGN             
A04581        IF WS-P-BILL-UNITS-SGN = '-'                              
A04581           COMPUTE WS-FMT-S9-SIGN = WS-FMT-S9-SIGN * -1           
A04581        END-IF                                                    
A04581        MOVE WS-FMT-S9-SIGN    TO WS-C-BILL-UNITS(WS-C-INDX)      
A04581     END-IF.                                                      
A04581*                                                                         
A04581     IF WS-P-DEMAND-UNITS GREATER THAN SPACES                     
A04581        MOVE WS-P-DEMAND-UNITS-VAL  TO WS-FMT-S9-SIGN             
A04581        IF WS-P-DEMAND-UNITS-SGN = '-'                            
A04581           COMPUTE WS-FMT-S9-SIGN = WS-FMT-S9-SIGN * -1           
A04581        END-IF                                                    
A04581        MOVE WS-FMT-S9-SIGN    TO WS-C-DEMAND-UNITS(WS-C-INDX)    
A04581     END-IF.                                                      
      *                                                                         
           IF WS-P-FACTOR GREATER THAN SPACES                           
              MOVE WS-P-FACTOR-VAL(1:9)   TO WS-FMT-S9V6-GRP-INT        
              MOVE WS-P-FACTOR-VAL(11:6)  TO WS-FMT-S9V6-GRP-FRA        
              MOVE WS-FMT-S9V6-GRP        TO WS-FMT-S9V6                
              IF WS-P-FACTOR-SGN = '-'                                  
                 COMPUTE WS-FMT-S9V6 = WS-FMT-S9V6 * -1                 
              END-IF                                                    
              MOVE WS-FMT-S9V6-SIGN       TO WS-C-FACTOR(WS-C-INDX)     
           END-IF.                                                      
      *                                                                         
           IF WS-P-FACTOR-AMT GREATER THAN SPACES                       
              MOVE WS-P-FACTOR-AMT-VAL(1:9)  TO WS-FMT-S9V2-GRP-INT     
              MOVE WS-P-FACTOR-AMT-VAL(11:2) TO WS-FMT-S9V2-GRP-FRA     
              MOVE WS-FMT-S9V2-GRP           TO WS-FMT-S9V2             
              IF WS-P-FACTOR-AMT-SGN = '-'                              
                 COMPUTE WS-FMT-S9V2 = WS-FMT-S9V2 * -1                 
              END-IF                                                    
              MOVE WS-FMT-S9V2-SIGN       TO WS-C-BILLED-AMT(WS-C-INDX) 
           END-IF.                                                      
      *                                                                         
           IF WS-P-GL-ACCT-NO GREATER THAN SPACES                       
              MOVE WS-P-GL-ACCT-NO(1:3)   TO WS-FMT-S3V4-GRP-INT        
              MOVE WS-P-GL-ACCT-NO(5:4)   TO WS-FMT-S3V4-GRP-FRA        
              MOVE WS-FMT-S3V4-GRP        TO WS-FMT-S3V4                
              MOVE WS-FMT-S3V4-SIGN       TO WS-C-GL-ACCT-NO(WS-C-INDX) 
           END-IF.                                                      
      *                                                                         
           MOVE WS-P-ROW-UPDT-FL        TO WS-C-ROW-UPDT-FL(WS-C-INDX). 
      *                                                                         
           SET WS-C-INDX UP BY 1.                                       
      *                                                                         
       1060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** LOAD BILL TAX ARRAY                                          **        
      ******************************************************************        
      *                                                                         
       1070-LOAD-BILL-TAX-ARRAY.                                        
      *                                                                         
           MOVE '1070'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-P-FACTOR-ID            TO WS-T-FACTOR-ID(WS-T-INDX). 
      *                                                                         
           IF WS-P-GL-ACCT-NO GREATER THAN SPACES                       
              MOVE WS-P-GL-ACCT-NO(1:3)   TO WS-FMT-S3V4-GRP-INT        
              MOVE WS-P-GL-ACCT-NO(5:4)   TO WS-FMT-S3V4-GRP-FRA        
              MOVE WS-FMT-S3V4-GRP        TO WS-FMT-S3V4                
              MOVE WS-FMT-S3V4-SIGN       TO WS-T-GL-ACCT-NO(WS-T-INDX) 
           END-IF.                                                      
      *                                                                         
           IF WS-P-FACTOR-AMT GREATER THAN SPACES                       
              MOVE WS-P-FACTOR-AMT-VAL(1:9)  TO WS-FMT-S9V2-GRP-INT     
              MOVE WS-P-FACTOR-AMT-VAL(11:2) TO WS-FMT-S9V2-GRP-FRA     
              MOVE WS-FMT-S9V2-GRP           TO WS-FMT-S9V2             
              MOVE WS-FMT-S9V2               TO WS-FMT-S7V2             
              IF WS-P-FACTOR-AMT-SGN = '-'                              
                 COMPUTE WS-FMT-S7V2 = WS-FMT-S7V2 * -1                 
              END-IF                                                    
              MOVE WS-FMT-S7V2-SIGN          TO WS-T-TAX-AMT(WS-T-INDX) 
           END-IF.                                                      
      *                                                                         
           MOVE WS-P-TAX-TYPE           TO WS-T-TAX-TYPE(WS-T-INDX).    
           IF WS-P-TAX-CNTRL-NO GREATER THAN SPACES                     
              MOVE WS-P-TAX-CNTRL-NO    TO WS-FMT-S4-SIGN               
              MOVE WS-FMT-S4-SIGN       TO WS-T-TAX-CNTRL-NO(WS-T-INDX) 
           END-IF.                                                      
           MOVE WS-P-TAX-FROM-DT        TO WS-T-TAX-FROM-DT(WS-T-INDX). 
           MOVE WS-P-ROW-UPDT-FL        TO WS-T-ROW-UPDT-FL(WS-T-INDX). 
      *                                                                         
           SET WS-T-INDX UP BY 1.                                       
      *                                                                         
       1070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** PROCESS REVENUE ADJUSTMENTS                                  **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM 7000-GET-CURRENT-TIMESTAMP  THRU  7000-EXIT.         
      *                                                                         
           MOVE ZERO                      TO WS-DATABASE.               
           MOVE '01'                      TO C8-COMPANY-NO.             
           MOVE 'DATABASE'                TO C8-DELINQ-CD.              
           PERFORM 7020-GET-DELINQUENCY-DATA   THRU  7020-EXIT.         
           MOVE C8-DELINQ-VALUE           TO WS-DATABASE.               
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO RV-ACCOUNT-NO              
                                             RB-ACCOUNT-NO              
                                             R7-ACCOUNT-NO              
                                             R9-ACCOUNT-NO              
                                             2Z-ACCOUNT-NO.             
      *                                                                         
      *** L-Delete, P-Partial Reverse with Update,                              
      *** U-Update Non-posted Charges, F-Insert with Future Offset              
      *** I-Insert, A-Add New, R-Reverse All                                    
           EVALUATE PARM-CALL-TYPE                                      
               WHEN 'L'                                                 
                  PERFORM 2100-PROCESS-DELETE       THRU  2100-EXIT     
               WHEN 'P'                                                 
                  PERFORM 2200-PROCESS-REVERSE      THRU  2200-EXIT     
               WHEN 'U'                                                 
                  PERFORM 2300-PROCESS-UPDATE       THRU  2300-EXIT     
               WHEN 'F'                                                 
                  PERFORM 2400-PROCESS-INSERT-FUTURE-OFF THRU 2400-EXIT 
               WHEN 'I'                                                 
               WHEN 'A'                                                 
                  PERFORM 2500-PROCESS-INSERT       THRU  2500-EXIT     
               WHEN 'R'                                                 
                  PERFORM 2600-PROCESS-REVERSE-ALL  THRU  2600-EXIT     
           END-EVALUATE.                                                
      *                                                                         
           PERFORM 8100-SEND-RESULT  THRU  8100-EXIT.                   
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE FROM BILLING_DET USING ACCOUNT_NO & BILL_UNIQUE_TS    **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-DELETE.                                             
      *                                                                         
           MOVE '2100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE PARM-BILL-UNIQUE-TS       TO RV-BILL-UNIQUE-TS.         
      *                                                                         
           PERFORM 8150-DELETE-BILLING-DET  THRU  8150-EXIT.            
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE DATA FROM BILLING_DET,COMP_ADJ,BILL_BLOCK & BILL_TAX **        
      ** USING ARRAY INPUTS                                           **        
      ** INSERT DATA INTO BILL_MISC_INFO WITH USERID/COMMENTS         **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-REVERSE.                                            
      *                                                                         
           MOVE '2200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-YES-NULL               TO WS-DATE-NULL-1             
                                             WS-DATE-NULL-2             
                                             WS-DATE-NULL-3.            
           MOVE PARM-BILL-UNIQUE-TS       TO WS-BILL-UNIQUE-TS-OLD.     
           MOVE WS-CURRENT-TIMESTAMP      TO WS-BILL-UNIQUE-TS-NEW.     
      *                                                                         
           PERFORM 8200-INSR-DET-REVERSE-1-OR-ALL  THRU  8200-EXIT.     
      *                                                                         
           IF PARM-SUMMARY-UPDT-FL = 'U'                                
              MOVE WS-BILL-UNIQUE-TS-NEW  TO RV-BILL-UNIQUE-TS          
              PERFORM 2325-PROCESS-BILL-DET-UPDATE  THRU  2325-EXIT     
           END-IF.                                                      
      *                                                                         
           PERFORM 2225-PROCESS-COMP-ADJ-REVERSE  THRU  2225-EXIT       
           VARYING WS-C-INDX FROM 1 BY 1 UNTIL WS-C-INDX > 10           
                OR WS-C-FACTOR-ID(WS-C-INDX) = SPACES.                  
      *                                                                         
           PERFORM 2250-PROCESS-BILL-TAX-REVERSE  THRU  2250-EXIT       
           VARYING WS-T-INDX FROM 1 BY 1 UNTIL WS-T-INDX > 10           
                OR WS-T-FACTOR-ID(WS-T-INDX) = SPACES.                  
      *                                                                         
           MOVE WS-BILL-UNIQUE-TS-NEW     TO 2Z-BILL-UNIQUE-TS.         
           MOVE WS-P-GL-INTRFCE-DB-ACCT   TO 2Z-GL-INTRFCE-DB-ACCT.     
           MOVE WS-P-GL-INTRFCE-CR-ACCT   TO 2Z-GL-INTRFCE-CR-ACCT.     
           MOVE PARM-COMMENTS-TEXT        TO 2Z-COMMENTS-TEXT.          
           MOVE PARM-COMMENTS-LEN         TO 2Z-COMMENTS-LEN.           
           MOVE PARM-USER-ID              TO 2Z-LAST-UPDATE-USERID.     
           PERFORM 8850-INSERT-REV-BILL-MISC-INFO  THRU  8850-EXIT.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE COMP_ADJ & BILL_BLOCK DATA                           **        
      ******************************************************************        
      *                                                                         
       2225-PROCESS-COMP-ADJ-REVERSE.                                   
      *                                                                         
           MOVE '2225'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-YES-NULL               TO WS-DATE-NULL-4             
                                             WS-DATE-NULL-5             
                                             WS-DATE-NULL-6             
                                             WS-DATE-NULL-7.            
           MOVE WS-C-COMP-SEQ(WS-C-INDX)  TO RB-BILL-COMP-SEQ-NO        
                                             R7-BILL-COMP-SEQ-NO.       
           MOVE WS-C-FACTOR-ID(WS-C-INDX) TO RB-FACTOR-ID.              
      *                                                                         
           PERFORM 8220-INSERT-COMP-ADJ-REVERSE    THRU  8220-EXIT.     
           PERFORM 8240-INSERT-BILL-BLOCK-REVERSE  THRU  8240-EXIT.     
      *                                                                         
           IF WS-C-ROW-UPDT-FL(WS-C-INDX) = 'U'                         
              MOVE WS-BILL-UNIQUE-TS-NEW  TO RB-BILL-UNIQUE-TS          
              PERFORM 2350-PROCESS-COMP-ADJ-UPDATE  THRU  2350-EXIT     
           END-IF.                                                      
      *                                                                         
       2225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE BILL_TAX                                             **        
      ******************************************************************        
      *                                                                         
       2250-PROCESS-BILL-TAX-REVERSE.                                   
      *                                                                         
           MOVE '2250'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF WS-T-FACTOR-ID(WS-T-INDX) = 'STATE TAX' OR 'FRAN TAX' OR  
                                          'State Tax' OR 'Fran Tax'     
              MOVE SPACES                    TO R9-FACTOR-ID            
           ELSE                                                         
              MOVE WS-T-FACTOR-ID(WS-T-INDX) TO R9-FACTOR-ID            
           END-IF.                                                      
           MOVE WS-T-TAX-TYPE(WS-T-INDX)     TO R9-TAX-TYPE.            
           MOVE WS-T-TAX-CNTRL-NO(WS-T-INDX) TO R9-TAX-CNTRL-NO.        
           MOVE WS-T-TAX-FROM-DT(WS-T-INDX)  TO R9-TAX-FROM-DT.         
      *                                                                         
           PERFORM 8260-INSERT-BILL-TAX-REVERSE  THRU  8260-EXIT.       
      *                                                                         
           IF WS-T-ROW-UPDT-FL(WS-T-INDX) = 'U'                         
              MOVE WS-BILL-UNIQUE-TS-NEW  TO R9-BILL-UNIQUE-TS          
              PERFORM 2375-PROCESS-BILL-TAX-UPDATE  THRU  2375-EXIT     
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UPDATE BILLING_DET,COMP_ADJ & BILL_TAX USING ARRAY INPUTS    **        
      ** INSERT/UPDATE BILL_MISC_INFO WITH USERID/COMMENTS            **        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-UPDATE.                                             
      *                                                                         
           MOVE '2300'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE PARM-BILL-UNIQUE-TS       TO RV-BILL-UNIQUE-TS          
                                             RB-BILL-UNIQUE-TS          
                                             R7-BILL-UNIQUE-TS          
                                             R9-BILL-UNIQUE-TS          
                                             2Z-BILL-UNIQUE-TS.         
      *                                                                         
           IF PARM-SUMMARY-UPDT-FL = 'U'                                
              PERFORM 2325-PROCESS-BILL-DET-UPDATE  THRU  2325-EXIT     
           END-IF.                                                      
      *                                                                         
           PERFORM 2350-PROCESS-COMP-ADJ-UPDATE  THRU  2350-EXIT        
           VARYING WS-C-INDX FROM 1 BY 1 UNTIL WS-C-INDX > 10           
                OR WS-C-FACTOR-ID(WS-C-INDX) = SPACES.                  
      *                                                                         
           PERFORM 2375-PROCESS-BILL-TAX-UPDATE  THRU  2375-EXIT        
           VARYING WS-T-INDX FROM 1 BY 1 UNTIL WS-T-INDX > 10           
                OR WS-T-FACTOR-ID(WS-T-INDX) = SPACES.                  
      *                                                                         
           PERFORM 7380-GET-BILL-MISC-INFO-DATA  THRU  7380-EXIT.       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF 2Z-GL-INTRFCE-DB-ACCT NOT = WS-P-GL-INTRFCE-DB-ACCT    
                 MOVE WS-P-GL-INTRFCE-DB-ACCT TO 2Z-GL-INTRFCE-DB-ACCT  
              END-IF                                                    
              IF 2Z-GL-INTRFCE-CR-ACCT NOT = WS-P-GL-INTRFCE-CR-ACCT    
                 MOVE WS-P-GL-INTRFCE-CR-ACCT TO 2Z-GL-INTRFCE-CR-ACCT  
              END-IF                                                    
              IF 2Z-COMMENTS-TEXT NOT = PARM-COMMENTS-TEXT              
                 MOVE PARM-COMMENTS-TEXT      TO 2Z-COMMENTS-TEXT       
                 MOVE PARM-COMMENTS-LEN       TO 2Z-COMMENTS-LEN        
              END-IF                                                    
              IF 2Z-LAST-UPDATE-USERID NOT = PARM-USER-ID               
                 MOVE PARM-USER-ID            TO 2Z-LAST-UPDATE-USERID  
              END-IF                                                    
              PERFORM 8875-UPDATE-REV-BILL-MISC-INFO  THRU  8875-EXIT   
           ELSE                                                         
              MOVE WS-P-GL-INTRFCE-DB-ACCT TO 2Z-GL-INTRFCE-DB-ACCT     
              MOVE WS-P-GL-INTRFCE-CR-ACCT TO 2Z-GL-INTRFCE-CR-ACCT     
              MOVE PARM-COMMENTS-TEXT      TO 2Z-COMMENTS-TEXT          
              MOVE PARM-COMMENTS-LEN       TO 2Z-COMMENTS-LEN           
              MOVE PARM-USER-ID            TO 2Z-LAST-UPDATE-USERID     
              PERFORM 8850-INSERT-REV-BILL-MISC-INFO  THRU  8850-EXIT   
           END-IF.                                                      
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UPDATE REV BILLING DET DATA                                  **        
      ******************************************************************        
      *                                                                         
       2325-PROCESS-BILL-DET-UPDATE.                                    
      *                                                                         
           MOVE '2325'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        WS-DATE-NULL-1             
                                             WS-DATE-NULL-2             
                                             WS-DATE-NULL-3.            
      *                                                                         
           PERFORM 7300-GET-REV-BILLING-DET-DATA  THRU  7300-EXIT.      
      *                                                                         
           IF RV-REVENUE-MONTH         NOT = PARM-REVENUE-MONTH-NUM     
              MOVE PARM-REVENUE-MONTH-NUM   TO RV-REVENUE-MONTH         
           END-IF.                                                      
           IF RV-CODE-UTIL-TYPE        NOT = PARM-CODE-UTIL-TYPE        
              MOVE PARM-CODE-UTIL-TYPE      TO RV-CODE-UTIL-TYPE        
           END-IF.                                                      
           IF RV-CUST-CT               NOT = WS-P-CUST-CT               
              MOVE WS-P-CUST-CT             TO RV-CUST-CT               
           END-IF.                                                      
GOPI*******IF RV-CUST-CT-EXCL-LIGHT    NOT = WS-P-CUST-CT-EXCL-LIGHT            
GOPI*******   MOVE WS-P-CUST-CT-EXCL-LIGHT  TO RV-CUST-CT-EXCL-LIGHT            
GOPI*******END-IF.                                                              
           IF PARM-USAGE-END-DATE GREATER THAN SPACES                   
              AND RV-USAGE-END-DATE    NOT = PARM-USAGE-END-DATE        
              MOVE PARM-USAGE-END-DATE      TO RV-USAGE-END-DATE        
              INITIALIZE                       WS-DATE-NULL-3           
           END-IF.                                                      
           IF RV-NO-OF-CONS-DAYS       NOT = WS-P-NO-OF-CONS-DAYS       
              MOVE WS-P-NO-OF-CONS-DAYS     TO RV-NO-OF-CONS-DAYS       
           END-IF.                                                      
           IF RV-BTU-FACTOR            NOT = WS-P-BTU-FACTOR            
              MOVE WS-P-BTU-FACTOR          TO RV-BTU-FACTOR            
           END-IF.                                                      
           IF RV-GAS-BASE-USE          NOT = WS-P-GAS-BASE-USE          
              MOVE WS-P-GAS-BASE-USE        TO RV-GAS-BASE-USE          
           END-IF.                                                      
           IF RV-CODE-REVENUE-CLASS    NOT = PARM-CODE-REVENUE-CLASS    
              MOVE PARM-CODE-REVENUE-CLASS  TO RV-CODE-REVENUE-CLASS    
           END-IF.                                                      
           IF RV-RATE-PLAN-NO          NOT = PARM-RATE-PLAN-NO          
              MOVE PARM-RATE-PLAN-NO        TO RV-RATE-PLAN-NO          
           END-IF.                                                      
           IF RV-LOCAL-OFFICE          NOT = PARM-LOCAL-OFFICE          
              MOVE PARM-LOCAL-OFFICE        TO RV-LOCAL-OFFICE          
           END-IF.                                                      
           IF RV-REV-DISTRICT-CD       NOT = PARM-REV-DISTRICT-CD       
              MOVE PARM-REV-DISTRICT-CD     TO RV-REV-DISTRICT-CD       
           END-IF.                                                      
           IF RV-CALC-SOURCE-CD        NOT = PARM-CALC-SOURCE-CD        
              MOVE PARM-CALC-SOURCE-CD      TO RV-CALC-SOURCE-CD        
           END-IF.                                                      
           IF RV-REV-POST-STATUS-FL    NOT = PARM-REV-POST-STATUS-FL    
              MOVE PARM-REV-POST-STATUS-FL  TO RV-REV-POST-STATUS-FL    
           END-IF.                                                      
      *                                                                         
           PERFORM 8300-UPDATE-REV-BILLING-DET  THRU  8300-EXIT.        
      *                                                                         
       2325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UPDATE REV BILL COMP ADJ DATA                                **        
      ******************************************************************        
      *                                                                         
       2350-PROCESS-COMP-ADJ-UPDATE.                                    
      *                                                                         
           MOVE '2350'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        WS-DATE-NULL-4             
                                             WS-DATE-NULL-5.            
      *                                                                         
           MOVE WS-C-COMP-SEQ(WS-C-INDX)  TO RB-BILL-COMP-SEQ-NO        
                                             R7-BILL-COMP-SEQ-NO.       
           MOVE WS-C-FACTOR-ID(WS-C-INDX) TO RB-FACTOR-ID.              
      *                                                                         
           PERFORM 7320-GET-BILL-COMP-ADJ-DATA  THRU  7320-EXIT.        
      *                                                                         
           IF RB-CMPNT-ID-CD NOT = WS-C-CMPNT-ID(WS-C-INDX)             
              MOVE WS-C-CMPNT-ID(WS-C-INDX)      TO RB-CMPNT-ID-CD      
           END-IF.                                                      
           IF RB-CONSUMPT-TYPE-CD NOT = WS-C-CONSUMPT-TYPE(WS-C-INDX)   
              MOVE WS-C-CONSUMPT-TYPE(WS-C-INDX) TO RB-CONSUMPT-TYPE-CD 
           END-IF.                                                      
           IF RB-CODE-TIME-PERIOD NOT = WS-C-CD-TIME-PRD(WS-C-INDX)     
              MOVE WS-C-CD-TIME-PRD(WS-C-INDX)   TO RB-CODE-TIME-PERIOD 
           END-IF.                                                      
           IF WS-C-RT-VERS-FROM-DT(WS-C-INDX) GREATER THAN SPACES       
            AND RB-RT-VERS-FROM-DT NOT = WS-C-RT-VERS-FROM-DT(WS-C-INDX)
              MOVE WS-C-RT-VERS-FROM-DT(WS-C-INDX) TO RB-RT-VERS-FROM-DT
              INITIALIZE                              WS-DATE-NULL-4    
           END-IF.                                                      
           IF RB-FACTOR-BLOCK-NO NOT = WS-C-FACTOR-BLK-NO(WS-C-INDX)    
              MOVE WS-C-FACTOR-BLK-NO(WS-C-INDX)   TO RB-FACTOR-BLOCK-NO
           END-IF.                                                      
           IF RB-READ-UNITS NOT = WS-C-READ-UNITS(WS-C-INDX)            
              MOVE WS-C-READ-UNITS(WS-C-INDX) TO RB-READ-UNITS          
           END-IF.                                                      
A04581     IF RB-BILL-USAGE-UNITS NOT = WS-C-BILL-UNITS(WS-C-INDX)      
A04581        MOVE WS-C-BILL-UNITS(WS-C-INDX)   TO RB-BILL-USAGE-UNITS  
A04581     END-IF.                                                      
A04581     IF RB-BILL-DEMAND-UNITS NOT = WS-C-DEMAND-UNITS(WS-C-INDX)   
A04581        MOVE WS-C-DEMAND-UNITS(WS-C-INDX) TO RB-BILL-DEMAND-UNITS 
A04581     END-IF.                                                      
GOPI*******IF RB-FACTOR NOT = WS-C-FACTOR(WS-C-INDX)                            
GOPI*******   MOVE WS-C-FACTOR(WS-C-INDX)     TO RB-FACTOR                      
GOPI*******END-IF.                                                              
           IF RB-BILLED-AMT NOT = WS-C-BILLED-AMT(WS-C-INDX)            
              MOVE WS-C-BILLED-AMT(WS-C-INDX) TO RB-BILLED-AMT          
           END-IF.                                                      
           IF RB-GL-ACCT-NO NOT = WS-C-GL-ACCT-NO(WS-C-INDX)            
              MOVE WS-C-GL-ACCT-NO(WS-C-INDX) TO RB-GL-ACCT-NO          
           END-IF.                                                      
      *                                                                         
           PERFORM 8320-UPDATE-BILL-COMP-ADJ-DATA  THRU  8320-EXIT.     
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UPDATE REV BILL TAX DATA                                     **        
      ******************************************************************        
      *                                                                         
       2375-PROCESS-BILL-TAX-UPDATE.                                    
      *                                                                         
           MOVE '2375'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF WS-T-FACTOR-ID(WS-T-INDX) = 'STATE TAX' OR 'FRAN TAX' OR  
                                          'State Tax' OR 'Fran Tax'     
              MOVE SPACES                    TO R9-FACTOR-ID            
           ELSE                                                         
              MOVE WS-T-FACTOR-ID(WS-T-INDX) TO R9-FACTOR-ID            
           END-IF.                                                      
           MOVE WS-T-TAX-TYPE(WS-T-INDX)     TO R9-TAX-TYPE.            
           MOVE WS-T-TAX-CNTRL-NO(WS-T-INDX) TO R9-TAX-CNTRL-NO.        
           MOVE WS-T-TAX-FROM-DT(WS-T-INDX)  TO R9-TAX-FROM-DT.         
      *                                                                         
           PERFORM 7360-GET-REV-BILL-TAX-DATA  THRU  7360-EXIT.         
      *                                                                         
           IF R9-TAX-AMT NOT = WS-T-TAX-AMT(WS-T-INDX)                  
              MOVE WS-T-TAX-AMT(WS-T-INDX)    TO R9-TAX-AMT             
           END-IF.                                                      
           IF R9-TAX-GL-ACCT-NO NOT = WS-T-GL-ACCT-NO(WS-T-INDX)        
              MOVE WS-T-GL-ACCT-NO(WS-T-INDX) TO R9-TAX-GL-ACCT-NO      
           END-IF.                                                      
      *                                                                         
           PERFORM 8360-UPDATE-REV-BILL-TAX-DATA  THRU  8360-EXIT.      
      *                                                                         
       2375-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT:                                                      **        
      ** INSERT REV BILLING DET DATA USING PARM INPUTS                **        
      ** INSERT REV BILL COMP ADJ DATA USING ARRAY INPUTS             **        
      ** INSERT REV BILL TAX DATA USING ARRAY INPUTS                  **        
      ** INSERT REV BILL MISC INFO WITH USERID/COMMENTS               **        
      ** FUTURE OFFSET USING NEXT MONTH TIMESTAMP:                    **        
      ** REVERSE ALL THE DATA FROM BILLING_DET, COMP_ADJ, BILL_BLOCK  **        
      ** AND BILL_TAX TABLES USING ACCOUNT_NO & BILL_UNIQUE_TS        **        
      ** INSERT DATA INTO BILL_MISC_INFO WITH USERID/COMMENTS         **        
      ******************************************************************        
      *                                                                         
       2400-PROCESS-INSERT-FUTURE-OFF.                                  
      *                                                                         
           MOVE '2400'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           PERFORM 2500-PROCESS-INSERT  THRU  2500-EXIT.                
      *                                                                         
           MOVE WS-YES-NULL               TO WS-DATE-NULL-1             
                                             WS-DATE-NULL-2             
                                             WS-DATE-NULL-3             
                                             WS-DATE-NULL-4             
                                             WS-DATE-NULL-5             
                                             WS-DATE-NULL-6             
                                             WS-DATE-NULL-7.            
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP      TO WS-BILL-UNIQUE-TS-OLD.     
           MOVE WS-CURR-TS-PLUS-1-MONTH   TO WS-BILL-UNIQUE-TS-NEW.     
      *                                                                         
           MOVE PARM-REVENUE-MONTH-NUM    TO WS-REV-MTH-TEMP.           
           COMPUTE WS-REV-MTH-TEMP-MM      = WS-REV-MTH-TEMP-MM + 1.    
           IF WS-REV-MTH-TEMP-MM > 12                                   
              COMPUTE WS-REV-MTH-TEMP-YYYY = WS-REV-MTH-TEMP-YYYY + 1   
              MOVE 01                     TO WS-REV-MTH-TEMP-MM         
           END-IF.                                                      
           MOVE WS-REV-MTH-TEMP           TO WS-REV-MTH-FUTURE-OFFSET.  
      *                                                                         
           PERFORM 8400-INSERT-DET-INS-FUTURE-OFF  THRU  8400-EXIT.     
           PERFORM 8620-INSERT-COMP-REVERSE-ALL    THRU  8620-EXIT.     
***********PERFORM 8640-INSERT-BLOCK-REVERSE-ALL   THRU  8640-EXIT.             
           PERFORM 8660-INSERT-TAX-REVERSE-ALL     THRU  8660-EXIT.     
      *                                                                         
           MOVE WS-BILL-UNIQUE-TS-NEW     TO 2Z-BILL-UNIQUE-TS.         
           MOVE WS-P-GL-INTRFCE-DB-ACCT   TO 2Z-GL-INTRFCE-DB-ACCT.     
           MOVE WS-P-GL-INTRFCE-CR-ACCT   TO 2Z-GL-INTRFCE-CR-ACCT.     
           MOVE PARM-COMMENTS-TEXT        TO 2Z-COMMENTS-TEXT.          
           MOVE PARM-COMMENTS-LEN         TO 2Z-COMMENTS-LEN.           
           MOVE PARM-USER-ID              TO 2Z-LAST-UPDATE-USERID.     
           PERFORM 8850-INSERT-REV-BILL-MISC-INFO  THRU  8850-EXIT.     
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT REV BILLING DET DATA USING PARM INPUTS                **        
      ** INSERT REV BILL COMP ADJ DATA USING ARRAY INPUTS             **        
      ** INSERT REV BILL TAX DATA USING ARRAY INPUTS                  **        
      ** INSERT REV BILL MISC INFO WITH USERID/COMMENTS               **        
      ******************************************************************        
      *                                                                         
       2500-PROCESS-INSERT.                                             
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE PARM-ACCOUNT-NO-NUM       TO RV-ACCOUNT-NO              
                                             RB-ACCOUNT-NO              
                                             R7-ACCOUNT-NO              
                                             R9-ACCOUNT-NO              
                                             2Z-ACCOUNT-NO.             
           MOVE WS-CURRENT-TIMESTAMP      TO RV-BILL-UNIQUE-TS          
                                             RB-BILL-UNIQUE-TS          
                                             R7-BILL-UNIQUE-TS          
                                             R9-BILL-UNIQUE-TS          
                                             2Z-BILL-UNIQUE-TS.         
      *                                                                         
           PERFORM 2525-PROCESS-BILL-DET-INSERT  THRU  2525-EXIT.       
      *                                                                         
           PERFORM 2550-PROCESS-COMP-ADJ-INSERT  THRU  2550-EXIT        
           VARYING WS-C-INDX FROM 1 BY 1 UNTIL WS-C-INDX > 10           
                OR WS-C-FACTOR-ID(WS-C-INDX) = SPACES.                  
      *                                                                         
           PERFORM 2575-PROCESS-BILL-TAX-INSERT  THRU  2575-EXIT        
           VARYING WS-T-INDX FROM 1 BY 1 UNTIL WS-T-INDX > 10           
                OR WS-T-FACTOR-ID(WS-T-INDX) = SPACES.                  
      *                                                                         
           MOVE WS-P-GL-INTRFCE-DB-ACCT   TO 2Z-GL-INTRFCE-DB-ACCT.     
           MOVE WS-P-GL-INTRFCE-CR-ACCT   TO 2Z-GL-INTRFCE-CR-ACCT.     
           MOVE PARM-COMMENTS-TEXT        TO 2Z-COMMENTS-TEXT.          
           MOVE PARM-COMMENTS-LEN         TO 2Z-COMMENTS-LEN.           
           MOVE PARM-USER-ID              TO 2Z-LAST-UPDATE-USERID.     
           PERFORM 8850-INSERT-REV-BILL-MISC-INFO  THRU  8850-EXIT.     
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT REV BILLING DET DATA USING PARM INPUTS                **        
      ******************************************************************        
      *                                                                         
       2525-PROCESS-BILL-DET-INSERT.                                    
      *                                                                         
           MOVE '2525'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        WS-DATE-NULL-1             
                                             WS-DATE-NULL-2             
                                             WS-DATE-NULL-3.            
      *                                                                         
           IF CSR-DATABASE                                              
              IF PARM-LOCAL-OFFICE > '099'                              
                 MOVE '26'                TO RV-REV-COMPANY-NO          
                                             RV-COMPANY-NO              
              ELSE                                                      
                 MOVE '01'                TO RV-REV-COMPANY-NO          
                                             RV-COMPANY-NO              
              END-IF                                                    
           ELSE                                                         
              MOVE '01'                   TO B1-COMPANY-NO              
              MOVE PARM-LOCAL-OFFICE      TO B1-LOCAL-OFFICE            
              PERFORM 7500-GET-LOCAL-OFFICE-DATA  THRU  7500-EXIT       
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF B1-REGULATED-CD = '02'                              
                    MOVE  '91'            TO RV-REV-COMPANY-NO          
                 ELSE                                                   
                    MOVE  '90'            TO RV-REV-COMPANY-NO          
                 END-IF                                                 
              ELSE                                                      
                 MOVE  '90'               TO RV-REV-COMPANY-NO          
              END-IF                                                    
              MOVE '01'                   TO RV-COMPANY-NO              
           END-IF.                                                      
      *                                                                         
           MOVE PARM-REVENUE-MONTH-NUM    TO RV-REVENUE-MONTH.          
           MOVE PARM-CODE-UTIL-TYPE       TO RV-CODE-SERVICE-TYPE.      
           MOVE 0                         TO RV-BILL-NO.                
           MOVE PARM-CODE-UTIL-TYPE       TO RV-CODE-UTIL-TYPE.         
           MOVE 0                         TO RV-IC-NO.                  
           MOVE RV-BILL-UNIQUE-TS         TO RV-BILL-ITEM-TIMESTMP.     
           MOVE WS-P-CUST-CT              TO RV-CUST-CT.                
           MOVE 0                         TO RV-CUST-CT-EXCL-LIGHT.     
      *                                                                         
           IF PARM-USAGE-END-DATE GREATER THAN SPACES                   
              MOVE PARM-USAGE-END-DATE    TO RV-USAGE-END-DATE          
           ELSE                                                         
              MOVE WS-YES-NULL            TO WS-DATE-NULL-1             
           END-IF.                                                      
      *                                                                         
           MOVE WS-P-NO-OF-CONS-DAYS      TO RV-NO-OF-CONS-DAYS.        
           MOVE SPACES                    TO RV-PRORATED-DAYS-CD.       
           MOVE WS-P-BTU-FACTOR           TO RV-BTU-FACTOR.             
           MOVE WS-P-GAS-BASE-USE         TO RV-GAS-BASE-USE.           
           MOVE 0                         TO RV-DESIGN-DAY-CAP.         
      *                                                                         
      *** NULL VALUES FOR RV-DATE-BILLED & RV-DATE-ORIG-BILL                    
      *                                                                         
           MOVE WS-YES-NULL               TO WS-DATE-NULL-2             
                                             WS-DATE-NULL-3.            
      *                                                                         
           MOVE 0                         TO RV-REV-MTH-ORIG-BILL.      
           MOVE SPACES                    TO RV-ACCT-BILL-CYCLE         
                                             RV-BILL-CALC-CYCLE.        
           MOVE PARM-CODE-REVENUE-CLASS(2:1)                            
                                          TO RV-CODE-REV-ACCT-TYPE.     
           MOVE PARM-CODE-REVENUE-CLASS   TO RV-CODE-REVENUE-CLASS.     
           MOVE PARM-RATE-PLAN-NO         TO RV-RATE-PLAN-NO.           
      *                                                                         
           MOVE RV-CODE-UTIL-TYPE         TO RD-CODE-UTIL-TYPE.         
           MOVE RV-RATE-PLAN-NO           TO RD-RATE-PLAN-NO.           
           PERFORM 7510-GET-RATE-DEPT-CD  THRU  7510-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE RD-RATE-DEPT-CD        TO RV-RATE-DEPT-CD            
           ELSE                                                         
              MOVE SPACES                 TO RV-RATE-DEPT-CD            
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                    TO RV-PRTY-SVC-CAT-CD         
                                             RV-CODE-SIC-NO             
                                             RV-NAICS-CD                
                                             RV-TIER-ACCT-TYPE-CD       
                                             RV-OPTION-CD               
                                             RV-RATE-CALC-TYPE-CD.      
      *                                                                         
           MOVE PARM-LOCAL-OFFICE         TO RV-LOCAL-OFFICE.           
           MOVE PARM-REV-DISTRICT-CD      TO RV-REV-DISTRICT-CD.        
      *                                                                         
           MOVE RV-REV-DISTRICT-CD        TO F4-REV-DISTRICT-CD.        
           PERFORM 7520-MNICPLTY-CNTY-DATA  THRU  7520-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE F4-MNICPLTY-COUNTY-CD  TO RV-MNICPLTY-COUNTY-CD      
           ELSE                                                         
              MOVE SPACES                 TO RV-MNICPLTY-COUNTY-CD      
           END-IF.                                                      
      *                                                                         
           MOVE 0                         TO RV-PREMISE-NO.             
           MOVE 'R'                       TO RV-CALC-SOURCE-CD.         
           MOVE SPACES                    TO RV-REV-CALC-CYCLE.         
           MOVE 0                         TO RV-ELEC-WNA-GROUP-NO.      
           MOVE PARM-REV-POST-STATUS-FL   TO RV-REV-POST-STATUS-FL.     
      *                                                                         
           PERFORM 8500-INSERT-REV-BILLING-DET  THRU  8500-EXIT.        
      *                                                                         
       2525-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT REV BILL COMP ADJ DATA                                **        
      ******************************************************************        
      *                                                                         
       2550-PROCESS-COMP-ADJ-INSERT.                                    
      *                                                                         
           MOVE '2550'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        WS-DATE-NULL-4             
                                             WS-DATE-NULL-5             
                                             WS-DATE-NULL-6             
                                             WS-DATE-NULL-7.            
      *                                                                         
           MOVE WS-C-COMP-SEQ(WS-C-INDX)  TO RB-BILL-COMP-SEQ-NO.       
           MOVE WS-C-CMPNT-ID(WS-C-INDX)  TO RB-CMPNT-ID-CD.            
           MOVE 'R'                       TO RB-INSTR-USE-TYPE-CD.      
           MOVE WS-C-CONSUMPT-TYPE(WS-C-INDX) TO RB-CONSUMPT-TYPE-CD.   
           MOVE WS-C-CD-TIME-PRD(WS-C-INDX)   TO RB-CODE-TIME-PERIOD.   
           MOVE SPACES                    TO RB-CODE-SEASON.            
      *                                                                         
           IF WS-C-RT-VERS-FROM-DT(WS-C-INDX) GREATER THAN SPACES       
              MOVE WS-C-RT-VERS-FROM-DT(WS-C-INDX) TO RB-RT-VERS-FROM-DT
           ELSE                                                         
              MOVE WS-YES-NULL                     TO WS-DATE-NULL-4    
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                    TO RB-RT-VERS-PRO-CD.         
           MOVE WS-C-FACTOR-ID(WS-C-INDX) TO RB-FACTOR-ID.              
           MOVE WS-C-FACTOR-BLK-NO(WS-C-INDX) TO RB-FACTOR-BLOCK-NO.    
      *                                                                         
           IF WS-C-RT-VERS-FROM-DT(WS-C-INDX) GREATER THAN SPACES       
              MOVE WS-C-RT-VERS-FROM-DT(WS-C-INDX) TO RB-RT-FCT-FROM-DT 
           ELSE                                                         
              MOVE WS-YES-NULL                     TO WS-DATE-NULL-5    
           END-IF.                                                      
      *                                                                         
           MOVE SPACES                     TO RB-RT-FCT-PRO-CD.         
           MOVE WS-C-READ-UNITS(WS-C-INDX) TO RB-READ-UNITS.            
A04581     MOVE WS-C-BILL-UNITS(WS-C-INDX)    TO RB-BILL-USAGE-UNITS.   
A04581     MOVE WS-C-DEMAND-UNITS(WS-C-INDX)  TO RB-BILL-DEMAND-UNITS.  
A04581     MOVE 0                             TO RB-CALC-UNITS.         
           MOVE WS-C-FACTOR(WS-C-INDX)     TO RB-FACTOR.                
           MOVE WS-C-BILLED-AMT(WS-C-INDX) TO RB-BILLED-AMT.            
           MOVE SPACES                     TO RB-CODE-STAT-TAX-XMT      
                                              RB-CODE-CITY-TAX-XMT      
                                              RB-CODE-OTHR-TAX-XMT.     
           MOVE 'U'                        TO RB-UTILITY-REV-CD.        
           MOVE 'C'                        TO RB-COMP-ADJ-CD.           
           MOVE WS-C-GL-ACCT-NO(WS-C-INDX) TO RB-GL-ACCT-NO.            
           MOVE SPACES                     TO RB-SPCL-GROUP-CD.         
      *                                                                         
           PERFORM 8520-INSERT-BILL-COMP-ADJ-DATA  THRU  8520-EXIT.     
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT REV BILL TAX DATA                                     **        
      ******************************************************************        
      *                                                                         
       2575-PROCESS-BILL-TAX-INSERT.                                    
      *                                                                         
           MOVE '2575'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           EVALUATE WS-T-FACTOR-ID(WS-T-INDX)                           
               WHEN 'STATE TAX'                                         
               WHEN 'State Tax'                                         
                    MOVE 'A'              TO R9-TAX-TYPE                
                    EVALUATE TRUE                                       
                      WHEN (CSR-DATABASE AND RV-COMPANY-NO = '01')      
                      WHEN (SEB-DATABASE AND RV-COMPANY-NO = '01')      
                           MOVE 10        TO R9-TAX-CNTRL-NO            
                      WHEN (CSR-DATABASE AND RV-COMPANY-NO = '26')      
                           MOVE 11        TO R9-TAX-CNTRL-NO            
                    END-EVALUATE                                        
               WHEN 'FRAN TAX'                                          
               WHEN 'Fran Tax'                                          
                    MOVE 'B'              TO R9-TAX-TYPE                
                    MOVE 20               TO R9-TAX-CNTRL-NO            
               WHEN OTHER                                               
                    CONTINUE                                            
           END-EVALUATE.                                                
      *                                                                         
           IF WS-T-FACTOR-ID(WS-T-INDX) = 'STATE TAX' OR 'FRAN TAX' OR  
                                          'State Tax' OR 'Fran Tax'     
              MOVE R9-TAX-TYPE            TO TC-TAX-TYPE                
              MOVE R9-TAX-CNTRL-NO        TO TC-TAX-CNTRL-NO            
              PERFORM 7530-GET-TAX-FACTOR-ID  THRU  7530-EXIT           
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE TC-FACTOR-ID        TO R9-FACTOR-ID               
              ELSE                                                      
                 MOVE SPACES              TO R9-FACTOR-ID               
              END-IF                                                    
           ELSE                                                         
              MOVE WS-T-FACTOR-ID(WS-T-INDX) TO R9-FACTOR-ID            
                                                TC-FACTOR-ID            
              PERFORM 7540-GET-TAX-TYPE-AND-CNTRL-NO  THRU  7540-EXIT   
              MOVE TC-TAX-TYPE            TO R9-TAX-TYPE                
              MOVE TC-TAX-CNTRL-NO        TO R9-TAX-CNTRL-NO            
           END-IF.                                                      
      *                                                                         
           MOVE R9-TAX-CNTRL-NO           TO TR-TAX-CNTRL-NO.           
           PERFORM 7550-GET-TAX-FROM-DT  THRU  7550-EXIT.               
           MOVE TR-DATE-FROM              TO R9-TAX-FROM-DT.            
      *                                                                         
           MOVE WS-T-GL-ACCT-NO(WS-T-INDX) TO R9-TAX-GL-ACCT-NO.        
           MOVE WS-T-TAX-AMT(WS-T-INDX)    TO R9-TAX-AMT.               
      *                                                                         
           PERFORM 8560-INSERT-REV-BILL-TAX-DATA  THRU  8560-EXIT.      
      *                                                                         
       2575-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE ALL THE DATA FROM BILLING_DET, COMP_ADJ, BILL_BLOCK  **        
      ** AND BILL_TAX TABLES USING ACCOUNT_NO & BILL_UNIQUE_TS        **        
      ** INSERT DATA INTO BILL_MISC_INFO WITH USERID/COMMENTS         **        
      ******************************************************************        
      *                                                                         
       2600-PROCESS-REVERSE-ALL.                                        
      *                                                                         
           MOVE '2600'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE WS-YES-NULL               TO WS-DATE-NULL-1             
                                             WS-DATE-NULL-2             
                                             WS-DATE-NULL-3             
                                             WS-DATE-NULL-4             
                                             WS-DATE-NULL-5             
                                             WS-DATE-NULL-6             
                                             WS-DATE-NULL-7.            
           MOVE PARM-BILL-UNIQUE-TS       TO WS-BILL-UNIQUE-TS-OLD.     
           MOVE WS-CURRENT-TIMESTAMP      TO WS-BILL-UNIQUE-TS-NEW.     
      *                                                                         
           PERFORM 8200-INSR-DET-REVERSE-1-OR-ALL  THRU  8200-EXIT.     
      *                                                                         
           MOVE WS-BILL-UNIQUE-TS-NEW     TO RV-BILL-UNIQUE-TS.         
           PERFORM 7600-GET-REV-BILL-DET-POST-ST  THRU  7600-EXIT.      
           IF RV-REV-POST-STATUS-FL    NOT = PARM-REV-POST-STATUS-FL    
              MOVE PARM-REV-POST-STATUS-FL  TO RV-REV-POST-STATUS-FL    
              PERFORM 8600-UPDT-REV-BILL-DET-POST-ST  THRU  8600-EXIT   
           END-IF.                                                      
      *                                                                         
           PERFORM 8620-INSERT-COMP-REVERSE-ALL    THRU  8620-EXIT.     
           PERFORM 8640-INSERT-BLOCK-REVERSE-ALL   THRU  8640-EXIT.     
           PERFORM 8660-INSERT-TAX-REVERSE-ALL     THRU  8660-EXIT.     
      *                                                                         
           MOVE WS-BILL-UNIQUE-TS-NEW     TO 2Z-BILL-UNIQUE-TS.         
           MOVE WS-P-GL-INTRFCE-DB-ACCT   TO 2Z-GL-INTRFCE-DB-ACCT.     
           MOVE WS-P-GL-INTRFCE-CR-ACCT   TO 2Z-GL-INTRFCE-CR-ACCT.     
           MOVE PARM-COMMENTS-TEXT        TO 2Z-COMMENTS-TEXT.          
           MOVE PARM-COMMENTS-LEN         TO 2Z-COMMENTS-LEN.           
           MOVE PARM-USER-ID              TO 2Z-LAST-UPDATE-USERID.     
           PERFORM 8850-INSERT-REV-BILL-MISC-INFO  THRU  8850-EXIT.     
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET CURRENT TIMESTAMP                                        **        
      ******************************************************************        
      *                                                                         
       7000-GET-CURRENT-TIMESTAMP.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MONTH, 1, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURR-TS-PLUS-1-MONTH 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-TIMESTAMP    = CURRENT TIMESTAMP                   
MFA-TR*         ,:WS-CURR-TS-PLUS-1-MONTH = CURRENT TIMESTAMP + 1 MONTH         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE SPACES                     TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              MOVE PARM-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET DELINQUENCY VALUE                                        **        
      ******************************************************************        
      *                                                                         
       7020-GET-DELINQUENCY-DATA.                                       
      *                                                                         
           EXEC SQL                                                     
             SELECT   C8.DELINQ_VALUE                                   
               INTO  :C8-DELINQ-VALUE                                   
               FROM  CSS_DELINQUENCY    C8 WITH(READUNCOMMITTED)                
              WHERE  C8.DELINQ_CD   =  :C8-DELINQ-CD                    
                AND  C8.COMPANY_NO  =  :C8-COMPANY-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   C8.DELINQ_VALUE                                           
MFA-TR*        INTO  :C8-DELINQ-VALUE                                           
MFA-TR*        FROM  CSS_DELINQUENCY    C8                                      
MFA-TR*       WHERE  C8.DELINQ_CD   =  :C8-DELINQ-CD                            
MFA-TR*         AND  C8.COMPANY_NO  =  :C8-COMPANY-NO                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-3        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              MOVE PARM-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-2      
              MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-3      
              MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CHECK FOR TAX FACTOR                                         **        
      ******************************************************************        
      *                                                                         
       7040-CHECK-TAX-FACTOR.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                
               INTO  :WS-TAX-FACTOR-FLAG                                
               FROM  CSS_TAX_CNTL        TC WITH(READUNCOMMITTED)               
              WHERE  TC.FACTOR_ID         =  :TC-FACTOR-ID              
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  'Y'                                                        
MFA-TR*        INTO  :WS-TAX-FACTOR-FLAG                                        
MFA-TR*        FROM  CSS_TAX_CNTL        TC                                     
MFA-TR*       WHERE  TC.FACTOR_ID         =  :TC-FACTOR-ID                      
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7040                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7040'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_TAX_CNTL'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-4        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
              MOVE PARM-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-3      
              MOVE TC-FACTOR-ID               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT REV BILLING DET DATA                                  **        
      ******************************************************************        
      *                                                                         
       7300-GET-REV-BILLING-DET-DATA.                                   
      *                                                                         
           EXEC SQL                                                     
             SELECT  RV.REVENUE_MONTH                                   
                    ,RV.CODE_UTIL_TYPE                                  
                    ,RV.CUST_CT                                         
                    ,RV.CUST_CT_EXCL_LIGHT                              
                    ,RV.USAGE_END_DATE                                  
                    ,RV.NO_OF_CONS_DAYS                                 
                    ,RV.BTU_FACTOR                                      
                    ,RV.GAS_BASE_USE                                    
                    ,RV.CODE_REVENUE_CLASS                              
                    ,RV.RATE_PLAN_NO                                    
                    ,RV.LOCAL_OFFICE                                    
                    ,RV.REV_DISTRICT_CD                                 
                    ,RV.CALC_SOURCE_CD                                  
                    ,RV.REV_POST_STATUS_FL                              
               INTO  :RV-REVENUE-MONTH                                  
                    ,:RV-CODE-UTIL-TYPE                                 
                    ,:RV-CUST-CT                                        
                    ,:RV-CUST-CT-EXCL-LIGHT                             
                    ,:RV-USAGE-END-DATE :WS-DATE-NULL-3                  
                    ,:RV-NO-OF-CONS-DAYS                                
                    ,:RV-BTU-FACTOR                                     
                    ,:RV-GAS-BASE-USE                                   
                    ,:RV-CODE-REVENUE-CLASS                             
                    ,:RV-RATE-PLAN-NO                                   
                    ,:RV-LOCAL-OFFICE                                   
                    ,:RV-REV-DISTRICT-CD                                
                    ,:RV-CALC-SOURCE-CD                                 
                    ,:RV-REV-POST-STATUS-FL                             
              FROM  REV_BILLING_DET    RV WITH(READUNCOMMITTED)                 
             WHERE  RV.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )            
               AND  RV.ACCOUNT_NO      =  :RV-ACCOUNT-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  RV.REVENUE_MONTH                                           
MFA-TR*             ,RV.CODE_UTIL_TYPE                                          
MFA-TR*             ,RV.CUST_CT                                                 
MFA-TR*             ,RV.CUST_CT_EXCL_LIGHT                                      
MFA-TR*             ,RV.USAGE_END_DATE                                          
MFA-TR*             ,RV.NO_OF_CONS_DAYS                                         
MFA-TR*             ,RV.BTU_FACTOR                                              
MFA-TR*             ,RV.GAS_BASE_USE                                            
MFA-TR*             ,RV.CODE_REVENUE_CLASS                                      
MFA-TR*             ,RV.RATE_PLAN_NO                                            
MFA-TR*             ,RV.LOCAL_OFFICE                                            
MFA-TR*             ,RV.REV_DISTRICT_CD                                         
MFA-TR*             ,RV.CALC_SOURCE_CD                                          
MFA-TR*             ,RV.REV_POST_STATUS_FL                                      
MFA-TR*        INTO  :RV-REVENUE-MONTH                                          
MFA-TR*             ,:RV-CODE-UTIL-TYPE                                         
MFA-TR*             ,:RV-CUST-CT                                                
MFA-TR*             ,:RV-CUST-CT-EXCL-LIGHT                                     
MFA-TR*             ,:RV-USAGE-END-DATE:WS-DATE-NULL-3                          
MFA-TR*             ,:RV-NO-OF-CONS-DAYS                                        
MFA-TR*             ,:RV-BTU-FACTOR                                             
MFA-TR*             ,:RV-GAS-BASE-USE                                           
MFA-TR*             ,:RV-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:RV-RATE-PLAN-NO                                           
MFA-TR*             ,:RV-LOCAL-OFFICE                                           
MFA-TR*             ,:RV-REV-DISTRICT-CD                                        
MFA-TR*             ,:RV-CALC-SOURCE-CD                                         
MFA-TR*             ,:RV-REV-POST-STATUS-FL                                     
MFA-TR*       FROM  REV_BILLING_DET    RV                                       
MFA-TR*      WHERE  RV.BILL_UNIQUE_TS  =  :RV-BILL-UNIQUE-TS                    
MFA-TR*        AND  RV.ACCOUNT_NO      =  :RV-ACCOUNT-NO                        
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-NULL-3 = WS-YES-NULL                           
                 MOVE SPACES                  TO RV-USAGE-END-DATE      
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE RV-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT REV BILL COMP ADJ DATA                                **        
      ******************************************************************        
      *                                                                         
       7320-GET-BILL-COMP-ADJ-DATA.                                     
      *                                                                         
           EXEC SQL                                                     
             SELECT  RB.CMPNT_ID_CD                                     
                    ,RB.CONSUMPT_TYPE_CD                                
                    ,RB.CODE_TIME_PERIOD                                
                    ,RB.RT_VERS_FROM_DT                                 
                    ,RB.FACTOR_BLOCK_NO                                 
                    ,RB.READ_UNITS                                      
A04581              ,RB.BILL_USAGE_UNITS                                
A04581              ,RB.BILL_DEMAND_UNITS                               
                    ,RB.FACTOR                                          
                    ,RB.BILLED_AMT                                      
                    ,RB.GL_ACCT_NO                                      
               INTO  :RB-CMPNT-ID-CD                                    
                    ,:RB-CONSUMPT-TYPE-CD                               
                    ,:RB-CODE-TIME-PERIOD                               
                    ,:RB-RT-VERS-FROM-DT :WS-DATE-NULL-4                 
                    ,:RB-FACTOR-BLOCK-NO                                
                    ,:RB-READ-UNITS                                     
A04581              ,:RB-BILL-USAGE-UNITS                               
A04581              ,:RB-BILL-DEMAND-UNITS                              
                    ,:RB-FACTOR                                         
                    ,:RB-BILLED-AMT                                     
                    ,:RB-GL-ACCT-NO                                     
              FROM  REV_BILL_COMP_ADJ  RB WITH(READUNCOMMITTED)                 
             WHERE  RB.BILL_UNIQUE_TS    =  CIS.CHAR2TIMESTAMP(
                                                     :RB-BILL-UNIQUE-TS
              )          
               AND  RB.ACCOUNT_NO        =  :RB-ACCOUNT-NO              
               AND  RB.BILL_COMP_SEQ_NO  =  :RB-BILL-COMP-SEQ-NO        
               AND  RB.FACTOR_ID         =  :RB-FACTOR-ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  RB.CMPNT_ID_CD                                             
MFA-TR*             ,RB.CONSUMPT_TYPE_CD                                        
MFA-TR*             ,RB.CODE_TIME_PERIOD                                        
MFA-TR*             ,RB.RT_VERS_FROM_DT                                         
MFA-TR*             ,RB.FACTOR_BLOCK_NO                                         
MFA-TR*             ,RB.READ_UNITS                                              
MFA-TR*             ,RB.BILL_USAGE_UNITS                                        
MFA-TR*             ,RB.BILL_DEMAND_UNITS                                       
MFA-TR*             ,RB.FACTOR                                                  
MFA-TR*             ,RB.BILLED_AMT                                              
MFA-TR*             ,RB.GL_ACCT_NO                                              
MFA-TR*        INTO  :RB-CMPNT-ID-CD                                            
MFA-TR*             ,:RB-CONSUMPT-TYPE-CD                                       
MFA-TR*             ,:RB-CODE-TIME-PERIOD                                       
MFA-TR*             ,:RB-RT-VERS-FROM-DT:WS-DATE-NULL-4                         
MFA-TR*             ,:RB-FACTOR-BLOCK-NO                                        
MFA-TR*             ,:RB-READ-UNITS                                             
MFA-TR*             ,:RB-BILL-USAGE-UNITS                                       
MFA-TR*             ,:RB-BILL-DEMAND-UNITS                                      
MFA-TR*             ,:RB-FACTOR                                                 
MFA-TR*             ,:RB-BILLED-AMT                                             
MFA-TR*             ,:RB-GL-ACCT-NO                                             
MFA-TR*       FROM  REV_BILL_COMP_ADJ  RB                                       
MFA-TR*      WHERE  RB.BILL_UNIQUE_TS    =  :RB-BILL-UNIQUE-TS                  
MFA-TR*        AND  RB.ACCOUNT_NO        =  :RB-ACCOUNT-NO                      
MFA-TR*        AND  RB.BILL_COMP_SEQ_NO  =  :RB-BILL-COMP-SEQ-NO                
MFA-TR*        AND  RB.FACTOR_ID         =  :RB-FACTOR-ID                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7320                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-NULL-4 = WS-YES-NULL                           
                 MOVE SPACES                  TO RB-RT-VERS-FROM-DT     
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_COMP_SEQ_NO'         TO TABLE-ELEMENT-3        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-4        
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE RB-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE RB-BILL-COMP-SEQ-NO        TO HOSTVAR-ELEMENT-3      
              MOVE RB-FACTOR-ID               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT REV BILL TAX DATA                                     **        
      ******************************************************************        
      *                                                                         
       7360-GET-REV-BILL-TAX-DATA.                                      
      *                                                                         
           EXEC SQL                                                     
             SELECT  R9.TAX_GL_ACCT_NO                                  
                    ,R9.TAX_AMT                                         
               INTO  :R9-TAX-GL-ACCT-NO                                 
                    ,:R9-TAX-AMT                                        
              FROM  REV_BILL_TAX       R9 WITH(READUNCOMMITTED)                 
             WHERE  R9.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                     :R9-BILL-UNIQUE-TS
              )            
               AND  R9.ACCOUNT_NO      =  :R9-ACCOUNT-NO                
               AND  R9.TAX_TYPE        =  :R9-TAX-TYPE                  
               AND  R9.TAX_CNTRL_NO    =  :R9-TAX-CNTRL-NO              
               AND  R9.TAX_FROM_DT     =  IIF(TRY_CONVERT(DATE, 
                                                        :R9-TAX-FROM-DT
              ) IS NULL OR (PATINDEX('%.%', :R9-TAX-FROM-DT
              ) <> 0) OR (LEN(:R9-TAX-FROM-DT) <> 10), CIS.CHAR2DATE(
                                                        :R9-TAX-FROM-DT
              ), CONVERT(DATE, :R9-TAX-FROM-DT) )               
               AND  R9.FACTOR_ID       =  :R9-FACTOR-ID                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  R9.TAX_GL_ACCT_NO                                          
MFA-TR*             ,R9.TAX_AMT                                                 
MFA-TR*        INTO  :R9-TAX-GL-ACCT-NO                                         
MFA-TR*             ,:R9-TAX-AMT                                                
MFA-TR*       FROM  REV_BILL_TAX       R9                                       
MFA-TR*      WHERE  R9.BILL_UNIQUE_TS  =  :R9-BILL-UNIQUE-TS                    
MFA-TR*        AND  R9.ACCOUNT_NO      =  :R9-ACCOUNT-NO                        
MFA-TR*        AND  R9.TAX_TYPE        =  :R9-TAX-TYPE                          
MFA-TR*        AND  R9.TAX_CNTRL_NO    =  :R9-TAX-CNTRL-NO                      
MFA-TR*        AND  R9.TAX_FROM_DT     =  :R9-TAX-FROM-DT                       
MFA-TR*        AND  R9.FACTOR_ID       =  :R9-FACTOR-ID                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7360                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7360'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-3        
              MOVE 'TAX_TYPE'                 TO TABLE-ELEMENT-4        
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE R9-FACTOR-ID               TO HOSTVAR-ELEMENT-3      
              MOVE R9-TAX-TYPE                TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET REV BILL MISC INFO DATA                                  **        
      ******************************************************************        
      *                                                                         
       7380-GET-BILL-MISC-INFO-DATA.                                    
      *                                                                         
           EXEC SQL                                                     
             SELECT  [2Z].GL_INTRFCE_DB_ACCT                              
                    ,[2Z].GL_INTRFCE_CR_ACCT                              
                    ,[2Z].COMMENTS                                        
                    ,[2Z].LAST_UPDATE_USERID                              
               INTO  :2Z-GL-INTRFCE-DB-ACCT                             
                    ,:2Z-GL-INTRFCE-CR-ACCT                             
                    ,:2Z-COMMENTS                                       
                    ,:2Z-LAST-UPDATE-USERID                             
              FROM  REV_BILL_MISC_INFO  [2Z] WITH(READUNCOMMITTED)              
             WHERE  [2Z].BILL_UNIQUE_TS   =  CIS.CHAR2TIMESTAMP(
                                                     :2Z-BILL-UNIQUE-TS
              )           
               AND  [2Z].ACCOUNT_NO       =  :2Z-ACCOUNT-NO               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  2Z.GL_INTRFCE_DB_ACCT                                      
MFA-TR*             ,2Z.GL_INTRFCE_CR_ACCT                                      
MFA-TR*             ,2Z.COMMENTS                                                
MFA-TR*             ,2Z.LAST_UPDATE_USERID                                      
MFA-TR*        INTO  :2Z-GL-INTRFCE-DB-ACCT                                     
MFA-TR*             ,:2Z-GL-INTRFCE-CR-ACCT                                     
MFA-TR*             ,:2Z-COMMENTS                                               
MFA-TR*             ,:2Z-LAST-UPDATE-USERID                                     
MFA-TR*       FROM  REV_BILL_MISC_INFO  2Z                                      
MFA-TR*      WHERE  2Z.BILL_UNIQUE_TS   =  :2Z-BILL-UNIQUE-TS                   
MFA-TR*        AND  2Z.ACCOUNT_NO       =  :2Z-ACCOUNT-NO                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7380                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7380'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_MISC_INFO'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-3        
              MOVE 2Z-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 2Z-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7380-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET LOCAL OFFICE DATA                                        **        
      ******************************************************************        
      *                                                                         
       7500-GET-LOCAL-OFFICE-DATA.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT  B1.REGULATED_CD                                   
                INTO :B1-REGULATED-CD                                   
                FROM  CSS_LOCAL_OFFICE     B1 WITH(READUNCOMMITTED)             
               WHERE  B1.COMPANY_NO    =  :B1-COMPANY-NO                
                 AND  B1.LOCAL_OFFICE  =  :B1-LOCAL-OFFICE              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  B1.REGULATED_CD                                           
MFA-TR*         INTO :B1-REGULATED-CD                                           
MFA-TR*         FROM  CSS_LOCAL_OFFICE     B1                                   
MFA-TR*        WHERE  B1.COMPANY_NO    =  :B1-COMPANY-NO                        
MFA-TR*          AND  B1.LOCAL_OFFICE  =  :B1-LOCAL-OFFICE                      
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_LOCAL_OFFICE'         TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'LOCAL_OFFICE'             TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE B1-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE B1-LOCAL-OFFICE            TO HOSTVAR-ELEMENT-2      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              MOVE RV-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET RATE PLAN DESC DATA                                      **        
      ******************************************************************        
      *                                                                         
       7510-GET-RATE-DEPT-CD.                                           
      *                                                                         
           EXEC SQL                                                     
             SELECT  RD.RATE_DEPT_CD                                    
               INTO :RD-RATE-DEPT-CD                                    
               FROM  CSS_RATE_PLAN_DESC     RD WITH(READUNCOMMITTED)            
              WHERE  RD.CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE           
                AND  RD.RATE_PLAN_NO    =  :RD-RATE-PLAN-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  RD.RATE_DEPT_CD                                            
MFA-TR*        INTO :RD-RATE-DEPT-CD                                            
MFA-TR*        FROM  CSS_RATE_PLAN_DESC     RD                                  
MFA-TR*       WHERE  RD.CODE_UTIL_TYPE  =  :RD-CODE-UTIL-TYPE                   
MFA-TR*         AND  RD.RATE_PLAN_NO    =  :RD-RATE-PLAN-NO                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7510                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7510'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE RD-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RD-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
              MOVE RV-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET MUNICIPALITY COUNTY DATA                                 **        
      ******************************************************************        
      *                                                                         
       7520-MNICPLTY-CNTY-DATA.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT  F4.MNICPLTY_COUNTY_CD                              
               INTO :F4-MNICPLTY-COUNTY-CD                              
               FROM  CSS_MNICPLTY_CNTY       F4 WITH(READUNCOMMITTED)           
              WHERE  F4.REV_DISTRICT_CD  =  :F4-REV-DISTRICT-CD         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  F4.MNICPLTY_COUNTY_CD                                      
MFA-TR*        INTO :F4-MNICPLTY-COUNTY-CD                                      
MFA-TR*        FROM  CSS_MNICPLTY_CNTY       F4                                 
MFA-TR*       WHERE  F4.REV_DISTRICT_CD  =  :F4-REV-DISTRICT-CD                 
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7520                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_MNICPLTY_CNTY'        TO TABLE-1                
              MOVE 'REV_DISTRICT_CD'          TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-4        
              MOVE F4-REV-DISTRICT-CD         TO HOSTVAR-ELEMENT-1      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE RV-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET FACTOR ID FROM TAX CNTL                                  **        
      ******************************************************************        
      *                                                                         
       7530-GET-TAX-FACTOR-ID.                                          
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) TC.FACTOR_ID                                       
               INTO :TC-FACTOR-ID                                       
               FROM  CSS_TAX_CNTL     TC WITH(READUNCOMMITTED)                  
              WHERE  TC.TAX_TYPE      =  :TC-TAX-TYPE                   
                AND  TC.TAX_CNTRL_NO  =  :TC-TAX-CNTRL-NO               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  TC.FACTOR_ID                                               
MFA-TR*        INTO :TC-FACTOR-ID                                               
MFA-TR*        FROM  CSS_TAX_CNTL     TC                                        
MFA-TR*       WHERE  TC.TAX_TYPE      =  :TC-TAX-TYPE                           
MFA-TR*         AND  TC.TAX_CNTRL_NO  =  :TC-TAX-CNTRL-NO                       
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7530                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7530'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_TAX_CNTL'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'TAX_TYPE'                 TO TABLE-ELEMENT-3        
              MOVE 'TAX_CNTRL_NO'             TO TABLE-ELEMENT-4        
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE TC-TAX-TYPE                TO HOSTVAR-ELEMENT-3      
              MOVE TC-TAX-CNTRL-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET TAX TYPE AND TAX CNTRL NO FROM TAX CNTL                  **        
      ******************************************************************        
      *                                                                         
       7540-GET-TAX-TYPE-AND-CNTRL-NO.                                  
      *                                                                         
           EXEC SQL                                                     
             SELECT TOP(1) TC.TAX_TYPE,
              TC.TAX_CNTRL_NO                                   
               INTO  :TC-TAX-TYPE                                       
                    ,:TC-TAX-CNTRL-NO                                   
               FROM  CSS_TAX_CNTL     TC WITH(READUNCOMMITTED)                  
              WHERE  TC.FACTOR_ID     =  :TC-FACTOR-ID                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT   TC.TAX_TYPE                                               
MFA-TR*              ,TC.TAX_CNTRL_NO                                           
MFA-TR*        INTO  :TC-TAX-TYPE                                               
MFA-TR*             ,:TC-TAX-CNTRL-NO                                           
MFA-TR*        FROM  CSS_TAX_CNTL     TC                                        
MFA-TR*       WHERE  TC.FACTOR_ID     =  :TC-FACTOR-ID                          
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7540                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7540'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_TAX_CNTL'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-3        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-4        
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE TC-FACTOR-ID               TO HOSTVAR-ELEMENT-3      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET "DATE FROM" FROM TAX RATE                                **        
      ******************************************************************        
      *                                                                         
       7550-GET-TAX-FROM-DT.                                            
      *                                                                         
           EXEC SQL                                                     
             SELECT  COALESCE(MAX(TR.DATE_FROM),IIF(TRY_CONVERT(DATE, 
              '1900-01-01') IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') ))             
               INTO :TR-DATE-FROM                                       
               FROM  CSS_TAX_RATE     TR WITH(READUNCOMMITTED)                  
              WHERE  TR.TAX_CNTRL_NO  =  :TR-TAX-CNTRL-NO               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(MAX(TR.DATE_FROM),'1900-01-01')                     
MFA-TR*        INTO :TR-DATE-FROM                                               
MFA-TR*        FROM  CSS_TAX_RATE     TR                                        
MFA-TR*       WHERE  TR.TAX_CNTRL_NO  =  :TR-TAX-CNTRL-NO                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7550                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7550'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_TAX_RATE'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'TAX_TYPE'                 TO TABLE-ELEMENT-3        
              MOVE 'TAX_CNTRL_NO'             TO TABLE-ELEMENT-4        
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE R9-TAX-TYPE                TO HOSTVAR-ELEMENT-3      
              MOVE TR-TAX-CNTRL-NO            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SELECT REV_POST_STATUS_FL FROM REV BILLING DET               **        
      ******************************************************************        
      *                                                                         
       7600-GET-REV-BILL-DET-POST-ST.                                   
      *                                                                         
           EXEC SQL                                                     
             SELECT  RV.REV_POST_STATUS_FL                              
               INTO :RV-REV-POST-STATUS-FL                              
              FROM  REV_BILLING_DET    RV WITH(READUNCOMMITTED)                 
             WHERE  RV.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )            
               AND  RV.ACCOUNT_NO      =  :RV-ACCOUNT-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  RV.REV_POST_STATUS_FL                                      
MFA-TR*        INTO :RV-REV-POST-STATUS-FL                                      
MFA-TR*       FROM  REV_BILLING_DET    RV                                       
MFA-TR*      WHERE  RV.BILL_UNIQUE_TS  =  :RV-BILL-UNIQUE-TS                    
MFA-TR*        AND  RV.ACCOUNT_NO      =  :RV-ACCOUNT-NO                        
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE RV-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE                                         **        
      ******************************************************************        
      *                                                                         
       8000-DELETE-GTT-ROWS.                                            
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04504_R1'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04504_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04504_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE           
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000'                   TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04504_R1'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT          
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT          
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET                                              **        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04504_R1                            
             (                                                          
              RETURN_CODE                                               
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04504_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04504_R1'              TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS.              
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** DELETE BILLING DET ROW WITH INPUT BILL UNIQUE TIMESTAMP      **        
      ******************************************************************        
      *                                                                         
       8150-DELETE-BILLING-DET.                                         
      *                                                                         
           EXEC SQL                                                     
             DELETE FROM REV_BILLING_DET                                
             WHERE  BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )               
               AND  ACCOUNT_NO      =  :RV-ACCOUNT-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM REV_BILLING_DET                                        
MFA-TR*      WHERE  BILL_UNIQUE_TS  =  :RV-BILL-UNIQUE-TS                       
MFA-TR*        AND  ACCOUNT_NO      =  :RV-ACCOUNT-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE PARM-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE/REVERSE ALL: INSERT ROW WITH CURRENT TIMESTAMP       **        
      ** BILL_ITEM_TIMESTMP = CURRENT TIMESTAMP                       **        
      ** CUST_CT            = CUST_CT * -1                            **        
      ** CUST_CT_EXCL_LIGHT = CUST_CT_EXCL_LIGHT * -1                 **        
      ** CALC_SOURCE_CD     = R(Revenue Correction)                   **        
      ******************************************************************        
      *                                                                         
       8200-INSR-DET-REVERSE-1-OR-ALL.                                  
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILLING_DET                                
                    (BILL_UNIQUE_TS                                     
                    ,REV_COMPANY_NO                                     
                    ,COMPANY_NO                                         
                    ,REVENUE_MONTH                                      
                    ,CODE_SERVICE_TYPE                                  
                    ,ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,BILL_ITEM_TIMESTMP                                 
                    ,CUST_CT                                            
                    ,CUST_CT_EXCL_LIGHT                                 
                    ,USAGE_END_DATE                                     
                    ,NO_OF_CONS_DAYS                                    
                    ,PRORATED_DAYS_CD                                   
                    ,BTU_FACTOR                                         
                    ,GAS_BASE_USE                                       
                    ,DESIGN_DAY_CAP                                     
                    ,DATE_BILLED                                        
                    ,DATE_ORIG_BILL                                     
                    ,REV_MTH_ORIG_BILL                                  
                    ,ACCT_BILL_CYCLE                                    
                    ,BILL_CALC_CYCLE                                    
                    ,CODE_REV_ACCT_TYPE                                 
                    ,CODE_REVENUE_CLASS                                 
                    ,RATE_PLAN_NO                                       
                    ,RATE_DEPT_CD                                       
                    ,PRTY_SVC_CAT_CD                                    
                    ,CODE_SIC_NO                                        
                    ,NAICS_CD                                           
                    ,TIER_ACCT_TYPE_CD                                  
                    ,OPTION_CD                                          
                    ,RATE_CALC_TYPE_CD                                  
                    ,LOCAL_OFFICE                                       
                    ,REV_DISTRICT_CD                                    
                    ,MNICPLTY_COUNTY_CD                                 
                    ,PREMISE_NO                                         
                    ,CALC_SOURCE_CD                                     
                    ,REV_CALC_CYCLE                                     
                    ,LAST_UPDATE_TS                                     
                    ,ELEC_WNA_GROUP_NO                                  
                    ,REV_POST_STATUS_FL)                                
             SELECT  CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,REV_COMPANY_NO                                     
                    ,COMPANY_NO                                         
                    ,REVENUE_MONTH                                      
                    ,CODE_SERVICE_TYPE                                  
                    ,ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,((CUST_CT)*(-1))                           
                    ,((CUST_CT_EXCL_LIGHT)*(-1))                
                    ,COALESCE(USAGE_END_DATE,                             
                        IIF(TRY_CONVERT(DATE, :RV-USAGE-END-DATE 
                                              :WS-DATE-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-1
              ) <> 0) OR (LEN(:RV-USAGE-END-DATE :WS-DATE-NULL-1
              ) <> 10), CIS.CHAR2DATE(:RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-1
              ), CONVERT(DATE, :RV-USAGE-END-DATE :WS-DATE-NULL-1) ))          
                    ,NO_OF_CONS_DAYS                                    
                    ,PRORATED_DAYS_CD                                   
                    ,BTU_FACTOR                                         
                    ,GAS_BASE_USE                                       
                    ,DESIGN_DAY_CAP                                     
                    ,COALESCE(DATE_BILLED,IIF(TRY_CONVERT(DATE, 
                                                       :RV-DATE-BILLED 
                                                        :WS-DATE-NULL-2
              ) IS NULL OR (PATINDEX('%.%', :RV-DATE-BILLED 
                                                        :WS-DATE-NULL-2
              ) <> 0) OR (LEN(:RV-DATE-BILLED :WS-DATE-NULL-2
              ) <> 10), CIS.CHAR2DATE(:RV-DATE-BILLED :WS-DATE-NULL-2
              ), CONVERT(DATE, :RV-DATE-BILLED :WS-DATE-NULL-2) )) 
                    ,COALESCE(DATE_ORIG_BILL,                             
                        IIF(TRY_CONVERT(DATE, :RV-DATE-ORIG-BILL 
                                              :WS-DATE-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :RV-DATE-ORIG-BILL 
                                                        :WS-DATE-NULL-3
              ) <> 0) OR (LEN(:RV-DATE-ORIG-BILL :WS-DATE-NULL-3
              ) <> 10), CIS.CHAR2DATE(:RV-DATE-ORIG-BILL 
                                                        :WS-DATE-NULL-3
              ), CONVERT(DATE, :RV-DATE-ORIG-BILL :WS-DATE-NULL-3) ))          
                    ,REV_MTH_ORIG_BILL                                  
                    ,ACCT_BILL_CYCLE                                    
                    ,BILL_CALC_CYCLE                                    
                    ,CODE_REV_ACCT_TYPE                                 
                    ,CODE_REVENUE_CLASS                                 
                    ,RATE_PLAN_NO                                       
                    ,RATE_DEPT_CD                                       
                    ,PRTY_SVC_CAT_CD                                    
                    ,CODE_SIC_NO                                        
                    ,NAICS_CD                                           
                    ,TIER_ACCT_TYPE_CD                                  
                    ,OPTION_CD                                          
                    ,RATE_CALC_TYPE_CD                                  
                    ,LOCAL_OFFICE                                       
                    ,REV_DISTRICT_CD                                    
                    ,MNICPLTY_COUNTY_CD                                 
                    ,PREMISE_NO                                         
                    ,'R'                                                
                    ,REV_CALC_CYCLE                                     
                    ,CIS.CURRENT$TIMESTAMP()                                  
                    ,ELEC_WNA_GROUP_NO                                  
                    ,REV_POST_STATUS_FL                                 
              FROM  REV_BILLING_DET    RV                               
             WHERE  RV.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-UNIQUE-TS-OLD
              )        
               AND  RV.ACCOUNT_NO      =  :RV-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILLING_DET                                        
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,REV_COMPANY_NO                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,CUST_CT                                                    
MFA-TR*             ,CUST_CT_EXCL_LIGHT                                         
MFA-TR*             ,USAGE_END_DATE                                             
MFA-TR*             ,NO_OF_CONS_DAYS                                            
MFA-TR*             ,PRORATED_DAYS_CD                                           
MFA-TR*             ,BTU_FACTOR                                                 
MFA-TR*             ,GAS_BASE_USE                                               
MFA-TR*             ,DESIGN_DAY_CAP                                             
MFA-TR*             ,DATE_BILLED                                                
MFA-TR*             ,DATE_ORIG_BILL                                             
MFA-TR*             ,REV_MTH_ORIG_BILL                                          
MFA-TR*             ,ACCT_BILL_CYCLE                                            
MFA-TR*             ,BILL_CALC_CYCLE                                            
MFA-TR*             ,CODE_REV_ACCT_TYPE                                         
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_DEPT_CD                                               
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,CODE_SIC_NO                                                
MFA-TR*             ,NAICS_CD                                                   
MFA-TR*             ,TIER_ACCT_TYPE_CD                                          
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,RATE_CALC_TYPE_CD                                          
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,REV_DISTRICT_CD                                            
MFA-TR*             ,MNICPLTY_COUNTY_CD                                         
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,CALC_SOURCE_CD                                             
MFA-TR*             ,REV_CALC_CYCLE                                             
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,ELEC_WNA_GROUP_NO                                          
MFA-TR*             ,REV_POST_STATUS_FL)                                        
MFA-TR*      SELECT  :WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,REV_COMPANY_NO                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,:WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,MULTIPLY_ALT(CUST_CT,-1)                                   
MFA-TR*             ,MULTIPLY_ALT(CUST_CT_EXCL_LIGHT,-1)                        
MFA-TR*             ,IFNULL(USAGE_END_DATE,                                     
MFA-TR*                 :RV-USAGE-END-DATE:WS-DATE-NULL-1)                      
MFA-TR*             ,NO_OF_CONS_DAYS                                            
MFA-TR*             ,PRORATED_DAYS_CD                                           
MFA-TR*             ,BTU_FACTOR                                                 
MFA-TR*             ,GAS_BASE_USE                                               
MFA-TR*             ,DESIGN_DAY_CAP                                             
MFA-TR*             ,IFNULL(DATE_BILLED,:RV-DATE-BILLED:WS-DATE-NULL-2)         
MFA-TR*             ,IFNULL(DATE_ORIG_BILL,                                     
MFA-TR*                 :RV-DATE-ORIG-BILL:WS-DATE-NULL-3)                      
MFA-TR*             ,REV_MTH_ORIG_BILL                                          
MFA-TR*             ,ACCT_BILL_CYCLE                                            
MFA-TR*             ,BILL_CALC_CYCLE                                            
MFA-TR*             ,CODE_REV_ACCT_TYPE                                         
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_DEPT_CD                                               
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,CODE_SIC_NO                                                
MFA-TR*             ,NAICS_CD                                                   
MFA-TR*             ,TIER_ACCT_TYPE_CD                                          
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,RATE_CALC_TYPE_CD                                          
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,REV_DISTRICT_CD                                            
MFA-TR*             ,MNICPLTY_COUNTY_CD                                         
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,'R'                                                        
MFA-TR*             ,REV_CALC_CYCLE                                             
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,ELEC_WNA_GROUP_NO                                          
MFA-TR*             ,REV_POST_STATUS_FL                                         
MFA-TR*       FROM  REV_BILLING_DET    RV                                       
MFA-TR*      WHERE  RV.BILL_UNIQUE_TS  =  :WS-BILL-UNIQUE-TS-OLD                
MFA-TR*        AND  RV.ACCOUNT_NO      =  :RV-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS_OLD'       TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS_NEW'       TO TABLE-ELEMENT-4        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-BILL-UNIQUE-TS-OLD      TO HOSTVAR-ELEMENT-3      
              MOVE WS-BILL-UNIQUE-TS-NEW      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE:INSERT COMP ADJ WITH CURRENT TIMESTAMP               **        
      ** READ_UNITS        = READ_UNITS * -1                          **        
      ** BILL_USAGE_UNITS  = BILL_USAGE_UNITS * -1                    **        
      ** BILL_DEMAND_UNITS = BILL_DEMAND_UNITS * -1                   **        
      ** CALC_UNITS        = CALC_UNITS * -1                          **        
      ** BILLED_AMT        = BILLED_AMT * -1                          **        
      ******************************************************************        
      *                                                                         
       8220-INSERT-COMP-ADJ-REVERSE.                                    
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_COMP_ADJ                              
                    (BILL_UNIQUE_TS                                     
                    ,BILL_COMP_SEQ_NO                                   
                    ,CMPNT_ID_CD                                        
                    ,INSTR_USE_TYPE_CD                                  
                    ,CONSUMPT_TYPE_CD                                   
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_SEASON                                        
                    ,RT_VERS_FROM_DT                                    
                    ,RT_VERS_PRO_CD                                     
                    ,FACTOR_ID                                          
                    ,FACTOR_BLOCK_NO                                    
                    ,RT_FCT_FROM_DT                                     
                    ,RT_FCT_PRO_CD                                      
                    ,READ_UNITS                                         
                    ,BILL_USAGE_UNITS                                   
                    ,BILL_DEMAND_UNITS                                  
                    ,CALC_UNITS                                         
                    ,FACTOR                                             
                    ,BILLED_AMT                                         
                    ,CODE_STAT_TAX_XMT                                  
                    ,CODE_CITY_TAX_XMT                                  
                    ,CODE_OTHR_TAX_XMT                                  
                    ,UTILITY_REV_CD                                     
                    ,COMP_ADJ_CD                                        
                    ,GL_ACCT_NO                                         
                    ,SPCL_GROUP_CD                                      
                    ,ACCOUNT_NO                                         
                    ,LAST_UPDATE_TS)                                    
             SELECT  CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,BILL_COMP_SEQ_NO                                   
                    ,CMPNT_ID_CD                                        
                    ,INSTR_USE_TYPE_CD                                  
                    ,CONSUMPT_TYPE_CD                                   
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_SEASON                                        
                    ,COALESCE(RT_VERS_FROM_DT,                            
                        IIF(TRY_CONVERT(DATE, :RB-RT-VERS-FROM-DT 
                                              :WS-DATE-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ) <> 0) OR (LEN(:RB-RT-VERS-FROM-DT :WS-DATE-NULL-4
              ) <> 10), CIS.CHAR2DATE(:RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ), CONVERT(DATE, :RB-RT-VERS-FROM-DT :WS-DATE-NULL-4) ))         
                    ,RT_VERS_PRO_CD                                     
                    ,FACTOR_ID                                          
                    ,FACTOR_BLOCK_NO                                    
                    ,COALESCE(RT_FCT_FROM_DT,                             
                        IIF(TRY_CONVERT(DATE, :RB-RT-FCT-FROM-DT 
                                              :WS-DATE-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :RB-RT-FCT-FROM-DT 
                                                        :WS-DATE-NULL-5
              ) <> 0) OR (LEN(:RB-RT-FCT-FROM-DT :WS-DATE-NULL-5
              ) <> 10), CIS.CHAR2DATE(:RB-RT-FCT-FROM-DT 
                                                        :WS-DATE-NULL-5
              ), CONVERT(DATE, :RB-RT-FCT-FROM-DT :WS-DATE-NULL-5) ))          
                    ,RT_FCT_PRO_CD                                      
                    ,((READ_UNITS)*(-1))                        
                    ,((BILL_USAGE_UNITS)*(-1))                  
                    ,((BILL_DEMAND_UNITS)*(-1))                 
                    ,((CALC_UNITS)*(-1))                        
                    ,FACTOR                                             
                    ,((BILLED_AMT)*(-1))                        
                    ,CODE_STAT_TAX_XMT                                  
                    ,CODE_CITY_TAX_XMT                                  
                    ,CODE_OTHR_TAX_XMT                                  
                    ,UTILITY_REV_CD                                     
                    ,COMP_ADJ_CD                                        
                    ,GL_ACCT_NO                                         
                    ,SPCL_GROUP_CD                                      
                    ,ACCOUNT_NO                                         
                    ,CIS.CURRENT$TIMESTAMP()                                  
              FROM  REV_BILL_COMP_ADJ  RB                               
             WHERE  RB.BILL_UNIQUE_TS    =  CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-UNIQUE-TS-OLD
              )      
               AND  RB.ACCOUNT_NO        =  :RB-ACCOUNT-NO              
               AND  RB.BILL_COMP_SEQ_NO  =  :RB-BILL-COMP-SEQ-NO        
               AND  RB.FACTOR_ID         =  :RB-FACTOR-ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_COMP_ADJ                                      
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,CMPNT_ID_CD                                                
MFA-TR*             ,INSTR_USE_TYPE_CD                                          
MFA-TR*             ,CONSUMPT_TYPE_CD                                           
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_SEASON                                                
MFA-TR*             ,RT_VERS_FROM_DT                                            
MFA-TR*             ,RT_VERS_PRO_CD                                             
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,FACTOR_BLOCK_NO                                            
MFA-TR*             ,RT_FCT_FROM_DT                                             
MFA-TR*             ,RT_FCT_PRO_CD                                              
MFA-TR*             ,READ_UNITS                                                 
MFA-TR*             ,BILL_USAGE_UNITS                                           
MFA-TR*             ,BILL_DEMAND_UNITS                                          
MFA-TR*             ,CALC_UNITS                                                 
MFA-TR*             ,FACTOR                                                     
MFA-TR*             ,BILLED_AMT                                                 
MFA-TR*             ,CODE_STAT_TAX_XMT                                          
MFA-TR*             ,CODE_CITY_TAX_XMT                                          
MFA-TR*             ,CODE_OTHR_TAX_XMT                                          
MFA-TR*             ,UTILITY_REV_CD                                             
MFA-TR*             ,COMP_ADJ_CD                                                
MFA-TR*             ,GL_ACCT_NO                                                 
MFA-TR*             ,SPCL_GROUP_CD                                              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,LAST_UPDATE_TS)                                            
MFA-TR*      SELECT  :WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,CMPNT_ID_CD                                                
MFA-TR*             ,INSTR_USE_TYPE_CD                                          
MFA-TR*             ,CONSUMPT_TYPE_CD                                           
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_SEASON                                                
MFA-TR*             ,IFNULL(RT_VERS_FROM_DT,                                    
MFA-TR*                 :RB-RT-VERS-FROM-DT:WS-DATE-NULL-4)                     
MFA-TR*             ,RT_VERS_PRO_CD                                             
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,FACTOR_BLOCK_NO                                            
MFA-TR*             ,IFNULL(RT_FCT_FROM_DT,                                     
MFA-TR*                 :RB-RT-FCT-FROM-DT:WS-DATE-NULL-5)                      
MFA-TR*             ,RT_FCT_PRO_CD                                              
MFA-TR*             ,MULTIPLY_ALT(READ_UNITS,-1)                                
MFA-TR*             ,MULTIPLY_ALT(BILL_USAGE_UNITS,-1)                          
MFA-TR*             ,MULTIPLY_ALT(BILL_DEMAND_UNITS,-1)                         
MFA-TR*             ,MULTIPLY_ALT(CALC_UNITS,-1)                                
MFA-TR*             ,FACTOR                                                     
MFA-TR*             ,MULTIPLY_ALT(BILLED_AMT,-1)                                
MFA-TR*             ,CODE_STAT_TAX_XMT                                          
MFA-TR*             ,CODE_CITY_TAX_XMT                                          
MFA-TR*             ,CODE_OTHR_TAX_XMT                                          
MFA-TR*             ,UTILITY_REV_CD                                             
MFA-TR*             ,COMP_ADJ_CD                                                
MFA-TR*             ,GL_ACCT_NO                                                 
MFA-TR*             ,SPCL_GROUP_CD                                              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*       FROM  REV_BILL_COMP_ADJ  RB                                       
MFA-TR*      WHERE  RB.BILL_UNIQUE_TS    =  :WS-BILL-UNIQUE-TS-OLD              
MFA-TR*        AND  RB.ACCOUNT_NO        =  :RB-ACCOUNT-NO                      
MFA-TR*        AND  RB.BILL_COMP_SEQ_NO  =  :RB-BILL-COMP-SEQ-NO                
MFA-TR*        AND  RB.FACTOR_ID         =  :RB-FACTOR-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_COMP_SEQ_NO'         TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS_OLD'       TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS_NEW'       TO TABLE-ELEMENT-4        
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE RB-BILL-COMP-SEQ-NO        TO HOSTVAR-ELEMENT-2      
              MOVE WS-BILL-UNIQUE-TS-OLD      TO HOSTVAR-ELEMENT-3      
              MOVE WS-BILL-UNIQUE-TS-NEW      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE:INSERT BLOCK ROW WITH CURRENT TIMESTAMP              **        
      ** BLK_BILL_USE_UNITS = BLK_BILL_USE_UNITS * -1                 **        
      ** BLK_BILL_DEM_UNITS = BLK_BILL_DEM_UNITS * -1                 **        
      ** BLK_BILL_LT_POLES  = BLK_BILL_LT_POLES * -1                  **        
      ** BLK_REV_AMT        = BLK_REV_AMT * -1                        **        
      ******************************************************************        
      *                                                                         
       8240-INSERT-BILL-BLOCK-REVERSE.                                  
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_BLOCK                                 
                    (BILL_UNIQUE_TS                                     
                    ,BILL_COMP_SEQ_NO                                   
                    ,BLK_NO_RT_ITM_CD                                   
                    ,BLK_USE_OR_SVCS                                    
                    ,BLK_BILL_USE_UNITS                                 
                    ,BLK_BILL_DEM_UNITS                                 
                    ,BLK_BILL_LT_POLES                                  
                    ,CUST_PER_SERVICE                                   
                    ,PRICE_TYPE_CD                                      
                    ,SCHED_PRICE_AM                                     
                    ,UNIT_PRICE_AM                                      
                    ,BLK_REV_AMT                                        
                    ,NET_UNIT_SEL_RSN                                   
                    ,KW_MDQ_DT                                          
                    ,KVA_DT                                             
                    ,CONTRACT_DEMAND                                    
                    ,READ_KW_MDQ_UNITS                                  
                    ,READ_KVA_UNITS                                     
                    ,POWER_FACTOR                                       
                    ,LOAD_FACTOR                                        
                    ,RT_VERS_PRO_PCT                                    
                    ,ACCOUNT_NO                                         
                    ,RATE_ITEM_CODE                                     
                    ,LAST_UPDATE_TS)                                    
             SELECT  CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,BILL_COMP_SEQ_NO                                   
                    ,BLK_NO_RT_ITM_CD                                   
                    ,BLK_USE_OR_SVCS                                    
                    ,((BLK_BILL_USE_UNITS)*(-1))                
                    ,((BLK_BILL_DEM_UNITS)*(-1))                
                    ,((BLK_BILL_LT_POLES)*(-1))                 
                    ,CUST_PER_SERVICE                                   
                    ,PRICE_TYPE_CD                                      
                    ,SCHED_PRICE_AM                                     
                    ,UNIT_PRICE_AM                                      
                    ,((BLK_REV_AMT)*(-1))                       
                    ,NET_UNIT_SEL_RSN                                   
                    ,COALESCE(KW_MDQ_DT,IIF(TRY_CONVERT(DATE, 
                                                         :R7-KW-MDQ-DT 
                                                        :WS-DATE-NULL-6
              ) IS NULL OR (PATINDEX('%.%', :R7-KW-MDQ-DT 
                                                        :WS-DATE-NULL-6
              ) <> 0) OR (LEN(:R7-KW-MDQ-DT :WS-DATE-NULL-6
              ) <> 10), CIS.CHAR2DATE(:R7-KW-MDQ-DT :WS-DATE-NULL-6
              ), CONVERT(DATE, :R7-KW-MDQ-DT :WS-DATE-NULL-6) ))     
                    ,COALESCE(KVA_DT,IIF(TRY_CONVERT(DATE, :R7-KVA-DT 
                                                        :WS-DATE-NULL-7
              ) IS NULL OR (PATINDEX('%.%', :R7-KVA-DT :WS-DATE-NULL-7
              ) <> 0) OR (LEN(:R7-KVA-DT :WS-DATE-NULL-7
              ) <> 10), CIS.CHAR2DATE(:R7-KVA-DT :WS-DATE-NULL-7
              ), CONVERT(DATE, :R7-KVA-DT :WS-DATE-NULL-7) ))           
                    ,CONTRACT_DEMAND                                    
                    ,READ_KW_MDQ_UNITS                                  
                    ,READ_KVA_UNITS                                     
                    ,POWER_FACTOR                                       
                    ,LOAD_FACTOR                                        
                    ,RT_VERS_PRO_PCT                                    
                    ,ACCOUNT_NO                                         
                    ,RATE_ITEM_CODE                                     
                    ,CIS.CURRENT$TIMESTAMP()                                  
              FROM  REV_BILL_BLOCK     R7                               
             WHERE  R7.BILL_UNIQUE_TS    =  CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-UNIQUE-TS-OLD
              )      
               AND  R7.ACCOUNT_NO        =  :R7-ACCOUNT-NO              
               AND  R7.BILL_COMP_SEQ_NO  =  :R7-BILL-COMP-SEQ-NO        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_BLOCK                                         
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,BLK_NO_RT_ITM_CD                                           
MFA-TR*             ,BLK_USE_OR_SVCS                                            
MFA-TR*             ,BLK_BILL_USE_UNITS                                         
MFA-TR*             ,BLK_BILL_DEM_UNITS                                         
MFA-TR*             ,BLK_BILL_LT_POLES                                          
MFA-TR*             ,CUST_PER_SERVICE                                           
MFA-TR*             ,PRICE_TYPE_CD                                              
MFA-TR*             ,SCHED_PRICE_AM                                             
MFA-TR*             ,UNIT_PRICE_AM                                              
MFA-TR*             ,BLK_REV_AMT                                                
MFA-TR*             ,NET_UNIT_SEL_RSN                                           
MFA-TR*             ,KW_MDQ_DT                                                  
MFA-TR*             ,KVA_DT                                                     
MFA-TR*             ,CONTRACT_DEMAND                                            
MFA-TR*             ,READ_KW_MDQ_UNITS                                          
MFA-TR*             ,READ_KVA_UNITS                                             
MFA-TR*             ,POWER_FACTOR                                               
MFA-TR*             ,LOAD_FACTOR                                                
MFA-TR*             ,RT_VERS_PRO_PCT                                            
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,LAST_UPDATE_TS)                                            
MFA-TR*      SELECT  :WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,BLK_NO_RT_ITM_CD                                           
MFA-TR*             ,BLK_USE_OR_SVCS                                            
MFA-TR*             ,MULTIPLY_ALT(BLK_BILL_USE_UNITS,-1)                        
MFA-TR*             ,MULTIPLY_ALT(BLK_BILL_DEM_UNITS,-1)                        
MFA-TR*             ,MULTIPLY_ALT(BLK_BILL_LT_POLES,-1)                         
MFA-TR*             ,CUST_PER_SERVICE                                           
MFA-TR*             ,PRICE_TYPE_CD                                              
MFA-TR*             ,SCHED_PRICE_AM                                             
MFA-TR*             ,UNIT_PRICE_AM                                              
MFA-TR*             ,MULTIPLY_ALT(BLK_REV_AMT,-1)                               
MFA-TR*             ,NET_UNIT_SEL_RSN                                           
MFA-TR*             ,IFNULL(KW_MDQ_DT,:R7-KW-MDQ-DT:WS-DATE-NULL-6)             
MFA-TR*             ,IFNULL(KVA_DT,:R7-KVA-DT:WS-DATE-NULL-7)                   
MFA-TR*             ,CONTRACT_DEMAND                                            
MFA-TR*             ,READ_KW_MDQ_UNITS                                          
MFA-TR*             ,READ_KVA_UNITS                                             
MFA-TR*             ,POWER_FACTOR                                               
MFA-TR*             ,LOAD_FACTOR                                                
MFA-TR*             ,RT_VERS_PRO_PCT                                            
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*       FROM  REV_BILL_BLOCK     R7                                       
MFA-TR*      WHERE  R7.BILL_UNIQUE_TS    =  :WS-BILL-UNIQUE-TS-OLD              
MFA-TR*        AND  R7.ACCOUNT_NO        =  :R7-ACCOUNT-NO                      
MFA-TR*        AND  R7.BILL_COMP_SEQ_NO  =  :R7-BILL-COMP-SEQ-NO                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8240'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_BLOCK'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_COMP_SEQ_NO'         TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS_OLD'       TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS_NEW'       TO TABLE-ELEMENT-4        
              MOVE R7-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE R7-BILL-COMP-SEQ-NO        TO HOSTVAR-ELEMENT-2      
              MOVE WS-BILL-UNIQUE-TS-OLD      TO HOSTVAR-ELEMENT-3      
              MOVE WS-BILL-UNIQUE-TS-NEW      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8240-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE: INSERT BILL TAX ROW WITH CURRENT TIMESTAMP          **        
      ** TAX_AMT = TAX_AMT * -1                                       **        
      ******************************************************************        
      *                                                                         
       8260-INSERT-BILL-TAX-REVERSE.                                    
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_TAX                                   
                    (BILL_UNIQUE_TS                                     
                    ,TAX_TYPE                                           
                    ,TAX_CNTRL_NO                                       
                    ,TAX_FROM_DT                                        
                    ,FACTOR_ID                                          
                    ,TAX_GL_ACCT_NO                                     
                    ,TAX_AMT                                            
                    ,ACCOUNT_NO                                         
                    ,LAST_UPDATE_TS)                                    
             SELECT  CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,TAX_TYPE                                           
                    ,TAX_CNTRL_NO                                       
                    ,TAX_FROM_DT                                        
                    ,FACTOR_ID                                          
                    ,TAX_GL_ACCT_NO                                     
                    ,((TAX_AMT)*(-1))                           
                    ,ACCOUNT_NO                                         
                    ,CIS.CURRENT$TIMESTAMP()                                  
              FROM  REV_BILL_TAX       R9                               
             WHERE  R9.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-UNIQUE-TS-OLD
              )        
               AND  R9.ACCOUNT_NO      =  :R9-ACCOUNT-NO                
               AND  R9.TAX_TYPE        =  :R9-TAX-TYPE                  
               AND  R9.TAX_CNTRL_NO    =  :R9-TAX-CNTRL-NO              
               AND  R9.TAX_FROM_DT     =  IIF(TRY_CONVERT(DATE, 
                                                        :R9-TAX-FROM-DT
              ) IS NULL OR (PATINDEX('%.%', :R9-TAX-FROM-DT
              ) <> 0) OR (LEN(:R9-TAX-FROM-DT) <> 10), CIS.CHAR2DATE(
                                                        :R9-TAX-FROM-DT
              ), CONVERT(DATE, :R9-TAX-FROM-DT) )               
               AND  R9.FACTOR_ID       =  :R9-FACTOR-ID                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_TAX                                           
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,TAX_TYPE                                                   
MFA-TR*             ,TAX_CNTRL_NO                                               
MFA-TR*             ,TAX_FROM_DT                                                
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,TAX_GL_ACCT_NO                                             
MFA-TR*             ,TAX_AMT                                                    
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,LAST_UPDATE_TS)                                            
MFA-TR*      SELECT  :WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,TAX_TYPE                                                   
MFA-TR*             ,TAX_CNTRL_NO                                               
MFA-TR*             ,TAX_FROM_DT                                                
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,TAX_GL_ACCT_NO                                             
MFA-TR*             ,MULTIPLY_ALT(TAX_AMT,-1)                                   
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*       FROM  REV_BILL_TAX       R9                                       
MFA-TR*      WHERE  R9.BILL_UNIQUE_TS  =  :WS-BILL-UNIQUE-TS-OLD                
MFA-TR*        AND  R9.ACCOUNT_NO      =  :R9-ACCOUNT-NO                        
MFA-TR*        AND  R9.TAX_TYPE        =  :R9-TAX-TYPE                          
MFA-TR*        AND  R9.TAX_CNTRL_NO    =  :R9-TAX-CNTRL-NO                      
MFA-TR*        AND  R9.TAX_FROM_DT     =  :R9-TAX-FROM-DT                       
MFA-TR*        AND  R9.FACTOR_ID       =  :R9-FACTOR-ID                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'TAX_TYPE'                 TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS_OLD'       TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS_NEW'       TO TABLE-ELEMENT-4        
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE R9-TAX-TYPE                TO HOSTVAR-ELEMENT-2      
              MOVE WS-BILL-UNIQUE-TS-OLD      TO HOSTVAR-ELEMENT-3      
              MOVE WS-BILL-UNIQUE-TS-NEW      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UPDATE REV BILLING DET DATA                                  **        
      ******************************************************************        
      *                                                                         
       8300-UPDATE-REV-BILLING-DET.                                     
      *                                                                         
           EXEC SQL                                                     
             UPDATE  REV_BILLING_DET                                    
                SET  REVENUE_MONTH       =  :RV-REVENUE-MONTH           
                    ,CODE_UTIL_TYPE      =  :RV-CODE-UTIL-TYPE          
                    ,CUST_CT             =  :RV-CUST-CT                 
GOPI*******         ,CUST_CT_EXCL_LIGHT  =  :RV-CUST-CT-EXCL-LIGHT              
                    ,USAGE_END_DATE      =  IIF(TRY_CONVERT(DATE, 
                                                    :RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-3
              ) <> 0) OR (LEN(:RV-USAGE-END-DATE :WS-DATE-NULL-3
              ) <> 10), CIS.CHAR2DATE(:RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-3
              ), CONVERT(DATE, :RV-USAGE-END-DATE :WS-DATE-NULL-3) )           
                    ,NO_OF_CONS_DAYS     =  :RV-NO-OF-CONS-DAYS         
                    ,BTU_FACTOR          =  :RV-BTU-FACTOR              
                    ,GAS_BASE_USE        =  :RV-GAS-BASE-USE            
                    ,CODE_REVENUE_CLASS  =  :RV-CODE-REVENUE-CLASS      
                    ,RATE_PLAN_NO        =  :RV-RATE-PLAN-NO            
                    ,LOCAL_OFFICE        =  :RV-LOCAL-OFFICE            
                    ,REV_DISTRICT_CD     =  :RV-REV-DISTRICT-CD         
                    ,CALC_SOURCE_CD      =  :RV-CALC-SOURCE-CD          
                    ,REV_POST_STATUS_FL  =  :RV-REV-POST-STATUS-FL      
             WHERE  BILL_UNIQUE_TS       =  CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )          
               AND  ACCOUNT_NO           =  :RV-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  REV_BILLING_DET                                            
MFA-TR*         SET  REVENUE_MONTH       =  :RV-REVENUE-MONTH                   
MFA-TR*             ,CODE_UTIL_TYPE      =  :RV-CODE-UTIL-TYPE                  
MFA-TR*             ,CUST_CT             =  :RV-CUST-CT                         
MFA-TR*****         ,CUST_CT_EXCL_LIGHT  =  :RV-CUST-CT-EXCL-LIGHT              
MFA-TR*             ,USAGE_END_DATE      =  :RV-USAGE-END-DATE                  
MFA-TR*                                     :WS-DATE-NULL-3                     
MFA-TR*             ,NO_OF_CONS_DAYS     =  :RV-NO-OF-CONS-DAYS                 
MFA-TR*             ,BTU_FACTOR          =  :RV-BTU-FACTOR                      
MFA-TR*             ,GAS_BASE_USE        =  :RV-GAS-BASE-USE                    
MFA-TR*             ,CODE_REVENUE_CLASS  =  :RV-CODE-REVENUE-CLASS              
MFA-TR*             ,RATE_PLAN_NO        =  :RV-RATE-PLAN-NO                    
MFA-TR*             ,LOCAL_OFFICE        =  :RV-LOCAL-OFFICE                    
MFA-TR*             ,REV_DISTRICT_CD     =  :RV-REV-DISTRICT-CD                 
MFA-TR*             ,CALC_SOURCE_CD      =  :RV-CALC-SOURCE-CD                  
MFA-TR*             ,REV_POST_STATUS_FL  =  :RV-REV-POST-STATUS-FL              
MFA-TR*      WHERE  BILL_UNIQUE_TS       =  :RV-BILL-UNIQUE-TS                  
MFA-TR*        AND  ACCOUNT_NO           =  :RV-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-3        
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE RV-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UPDATE REV BILL COMP ADJ DATA                                **        
      ******************************************************************        
      *                                                                         
       8320-UPDATE-BILL-COMP-ADJ-DATA.                                  
      *                                                                         
           EXEC SQL                                                     
             UPDATE  REV_BILL_COMP_ADJ                                  
                SET  CMPNT_ID_CD       =  :RB-CMPNT-ID-CD               
                    ,CONSUMPT_TYPE_CD  =  :RB-CONSUMPT-TYPE-CD          
                    ,CODE_TIME_PERIOD  =  :RB-CODE-TIME-PERIOD          
                    ,RT_VERS_FROM_DT   =  IIF(TRY_CONVERT(DATE, 
                                                   :RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ) <> 0) OR (LEN(:RB-RT-VERS-FROM-DT :WS-DATE-NULL-4
              ) <> 10), CIS.CHAR2DATE(:RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ), CONVERT(DATE, :RB-RT-VERS-FROM-DT :WS-DATE-NULL-4) )          
                    ,FACTOR_BLOCK_NO   =  :RB-FACTOR-BLOCK-NO           
                    ,READ_UNITS        =  :RB-READ-UNITS                
A04581              ,BILL_USAGE_UNITS  =  :RB-BILL-USAGE-UNITS          
A04581              ,BILL_DEMAND_UNITS =  :RB-BILL-DEMAND-UNITS         
GOPI*******         ,FACTOR            =  :RB-FACTOR                            
                    ,BILLED_AMT        =  :RB-BILLED-AMT                
                    ,GL_ACCT_NO        =  :RB-GL-ACCT-NO                
             WHERE  BILL_UNIQUE_TS     =  CIS.CHAR2TIMESTAMP(
                                                     :RB-BILL-UNIQUE-TS
              )            
               AND  ACCOUNT_NO         =  :RB-ACCOUNT-NO                
               AND  BILL_COMP_SEQ_NO   =  :RB-BILL-COMP-SEQ-NO          
               AND  FACTOR_ID          =  :RB-FACTOR-ID                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  REV_BILL_COMP_ADJ                                          
MFA-TR*         SET  CMPNT_ID_CD       =  :RB-CMPNT-ID-CD                       
MFA-TR*             ,CONSUMPT_TYPE_CD  =  :RB-CONSUMPT-TYPE-CD                  
MFA-TR*             ,CODE_TIME_PERIOD  =  :RB-CODE-TIME-PERIOD                  
MFA-TR*             ,RT_VERS_FROM_DT   =  :RB-RT-VERS-FROM-DT                   
MFA-TR*                                   :WS-DATE-NULL-4                       
MFA-TR*             ,FACTOR_BLOCK_NO   =  :RB-FACTOR-BLOCK-NO                   
MFA-TR*             ,READ_UNITS        =  :RB-READ-UNITS                        
MFA-TR*             ,BILL_USAGE_UNITS  =  :RB-BILL-USAGE-UNITS                  
MFA-TR*             ,BILL_DEMAND_UNITS =  :RB-BILL-DEMAND-UNITS                 
MFA-TR*****         ,FACTOR            =  :RB-FACTOR                            
MFA-TR*             ,BILLED_AMT        =  :RB-BILLED-AMT                        
MFA-TR*             ,GL_ACCT_NO        =  :RB-GL-ACCT-NO                        
MFA-TR*      WHERE  BILL_UNIQUE_TS     =  :RB-BILL-UNIQUE-TS                    
MFA-TR*        AND  ACCOUNT_NO         =  :RB-ACCOUNT-NO                        
MFA-TR*        AND  BILL_COMP_SEQ_NO   =  :RB-BILL-COMP-SEQ-NO                  
MFA-TR*        AND  FACTOR_ID          =  :RB-FACTOR-ID                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_COMP_SEQ_NO'         TO TABLE-ELEMENT-3        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-4        
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE RB-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE RB-BILL-COMP-SEQ-NO        TO HOSTVAR-ELEMENT-3      
              MOVE RB-FACTOR-ID               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UPDATE REV BILL TAX                                          **        
      ******************************************************************        
      *                                                                         
       8360-UPDATE-REV-BILL-TAX-DATA.                                   
      *                                                                         
           EXEC SQL                                                     
             UPDATE  REV_BILL_TAX                                       
                SET  TAX_GL_ACCT_NO  =  :R9-TAX-GL-ACCT-NO              
                    ,TAX_AMT         =  :R9-TAX-AMT                     
             WHERE  BILL_UNIQUE_TS   =  CIS.CHAR2TIMESTAMP(
                                                     :R9-BILL-UNIQUE-TS
              )              
               AND  ACCOUNT_NO       =  :R9-ACCOUNT-NO                  
               AND  TAX_TYPE         =  :R9-TAX-TYPE                    
               AND  TAX_CNTRL_NO     =  :R9-TAX-CNTRL-NO                
               AND  TAX_FROM_DT      =  IIF(TRY_CONVERT(DATE, 
                                                        :R9-TAX-FROM-DT
              ) IS NULL OR (PATINDEX('%.%', :R9-TAX-FROM-DT
              ) <> 0) OR (LEN(:R9-TAX-FROM-DT) <> 10), CIS.CHAR2DATE(
                                                        :R9-TAX-FROM-DT
              ), CONVERT(DATE, :R9-TAX-FROM-DT) )                 
               AND  FACTOR_ID        =  :R9-FACTOR-ID                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  REV_BILL_TAX                                               
MFA-TR*         SET  TAX_GL_ACCT_NO  =  :R9-TAX-GL-ACCT-NO                      
MFA-TR*             ,TAX_AMT         =  :R9-TAX-AMT                             
MFA-TR*      WHERE  BILL_UNIQUE_TS   =  :R9-BILL-UNIQUE-TS                      
MFA-TR*        AND  ACCOUNT_NO       =  :R9-ACCOUNT-NO                          
MFA-TR*        AND  TAX_TYPE         =  :R9-TAX-TYPE                            
MFA-TR*        AND  TAX_CNTRL_NO     =  :R9-TAX-CNTRL-NO                        
MFA-TR*        AND  TAX_FROM_DT      =  :R9-TAX-FROM-DT                         
MFA-TR*        AND  FACTOR_ID        =  :R9-FACTOR-ID                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8360'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-3        
              MOVE 'TAX_TYPE'                 TO TABLE-ELEMENT-4        
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE R9-FACTOR-ID               TO HOSTVAR-ELEMENT-3      
              MOVE R9-TAX-TYPE                TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8360-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT WITH FUTURE OFFSET:INSERT ROW WITH NEXT REVENUE MONTH **        
      ** AND NEXT MONTH'S TIMESTAMP                                   **        
      ** BILL_ITEM_TIMESTMP = NEXT MONTH TIMESTAMP                    **        
      ** CUST_CT            = CUST_CT * -1                            **        
      ** CUST_CT_EXCL_LIGHT = CUST_CT_EXCL_LIGHT * -1                 **        
      ** CALC_SOURCE_CD     = R(Revenue Correction)                   **        
      ******************************************************************        
      *                                                                         
       8400-INSERT-DET-INS-FUTURE-OFF.                                  
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILLING_DET                                
                    (BILL_UNIQUE_TS                                     
                    ,REV_COMPANY_NO                                     
                    ,COMPANY_NO                                         
                    ,REVENUE_MONTH                                      
                    ,CODE_SERVICE_TYPE                                  
                    ,ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,BILL_ITEM_TIMESTMP                                 
                    ,CUST_CT                                            
                    ,CUST_CT_EXCL_LIGHT                                 
                    ,USAGE_END_DATE                                     
                    ,NO_OF_CONS_DAYS                                    
                    ,PRORATED_DAYS_CD                                   
                    ,BTU_FACTOR                                         
                    ,GAS_BASE_USE                                       
                    ,DESIGN_DAY_CAP                                     
                    ,DATE_BILLED                                        
                    ,DATE_ORIG_BILL                                     
                    ,REV_MTH_ORIG_BILL                                  
                    ,ACCT_BILL_CYCLE                                    
                    ,BILL_CALC_CYCLE                                    
                    ,CODE_REV_ACCT_TYPE                                 
                    ,CODE_REVENUE_CLASS                                 
                    ,RATE_PLAN_NO                                       
                    ,RATE_DEPT_CD                                       
                    ,PRTY_SVC_CAT_CD                                    
                    ,CODE_SIC_NO                                        
                    ,NAICS_CD                                           
                    ,TIER_ACCT_TYPE_CD                                  
                    ,OPTION_CD                                          
                    ,RATE_CALC_TYPE_CD                                  
                    ,LOCAL_OFFICE                                       
                    ,REV_DISTRICT_CD                                    
                    ,MNICPLTY_COUNTY_CD                                 
                    ,PREMISE_NO                                         
                    ,CALC_SOURCE_CD                                     
                    ,REV_CALC_CYCLE                                     
                    ,LAST_UPDATE_TS                                     
                    ,ELEC_WNA_GROUP_NO                                  
                    ,REV_POST_STATUS_FL)                                
             SELECT  CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,REV_COMPANY_NO                                     
                    ,COMPANY_NO                                         
                    ,:WS-REV-MTH-FUTURE-OFFSET                          
                    ,CODE_SERVICE_TYPE                                  
                    ,ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,((CUST_CT)*(-1))                           
                    ,((CUST_CT_EXCL_LIGHT)*(-1))                
                    ,COALESCE(USAGE_END_DATE,                             
                        IIF(TRY_CONVERT(DATE, :RV-USAGE-END-DATE 
                                              :WS-DATE-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-1
              ) <> 0) OR (LEN(:RV-USAGE-END-DATE :WS-DATE-NULL-1
              ) <> 10), CIS.CHAR2DATE(:RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-1
              ), CONVERT(DATE, :RV-USAGE-END-DATE :WS-DATE-NULL-1) ))          
                    ,NO_OF_CONS_DAYS                                    
                    ,PRORATED_DAYS_CD                                   
                    ,BTU_FACTOR                                         
                    ,GAS_BASE_USE                                       
                    ,DESIGN_DAY_CAP                                     
                    ,COALESCE(DATE_BILLED,IIF(TRY_CONVERT(DATE, 
                                                       :RV-DATE-BILLED 
                                                        :WS-DATE-NULL-2
              ) IS NULL OR (PATINDEX('%.%', :RV-DATE-BILLED 
                                                        :WS-DATE-NULL-2
              ) <> 0) OR (LEN(:RV-DATE-BILLED :WS-DATE-NULL-2
              ) <> 10), CIS.CHAR2DATE(:RV-DATE-BILLED :WS-DATE-NULL-2
              ), CONVERT(DATE, :RV-DATE-BILLED :WS-DATE-NULL-2) )) 
                    ,COALESCE(DATE_ORIG_BILL,                             
                        IIF(TRY_CONVERT(DATE, :RV-DATE-ORIG-BILL 
                                              :WS-DATE-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :RV-DATE-ORIG-BILL 
                                                        :WS-DATE-NULL-3
              ) <> 0) OR (LEN(:RV-DATE-ORIG-BILL :WS-DATE-NULL-3
              ) <> 10), CIS.CHAR2DATE(:RV-DATE-ORIG-BILL 
                                                        :WS-DATE-NULL-3
              ), CONVERT(DATE, :RV-DATE-ORIG-BILL :WS-DATE-NULL-3) ))          
                    ,REV_MTH_ORIG_BILL                                  
                    ,ACCT_BILL_CYCLE                                    
                    ,BILL_CALC_CYCLE                                    
                    ,CODE_REV_ACCT_TYPE                                 
                    ,CODE_REVENUE_CLASS                                 
                    ,RATE_PLAN_NO                                       
                    ,RATE_DEPT_CD                                       
                    ,PRTY_SVC_CAT_CD                                    
                    ,CODE_SIC_NO                                        
                    ,NAICS_CD                                           
                    ,TIER_ACCT_TYPE_CD                                  
                    ,OPTION_CD                                          
                    ,RATE_CALC_TYPE_CD                                  
                    ,LOCAL_OFFICE                                       
                    ,REV_DISTRICT_CD                                    
                    ,MNICPLTY_COUNTY_CD                                 
                    ,PREMISE_NO                                         
                    ,'R'                                                
                    ,REV_CALC_CYCLE                                     
                    ,CIS.CURRENT$TIMESTAMP()                                  
                    ,ELEC_WNA_GROUP_NO                                  
                    ,REV_POST_STATUS_FL                                 
              FROM  REV_BILLING_DET    RV                               
             WHERE  RV.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-UNIQUE-TS-OLD
              )        
               AND  RV.ACCOUNT_NO      =  :RV-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILLING_DET                                        
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,REV_COMPANY_NO                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,CUST_CT                                                    
MFA-TR*             ,CUST_CT_EXCL_LIGHT                                         
MFA-TR*             ,USAGE_END_DATE                                             
MFA-TR*             ,NO_OF_CONS_DAYS                                            
MFA-TR*             ,PRORATED_DAYS_CD                                           
MFA-TR*             ,BTU_FACTOR                                                 
MFA-TR*             ,GAS_BASE_USE                                               
MFA-TR*             ,DESIGN_DAY_CAP                                             
MFA-TR*             ,DATE_BILLED                                                
MFA-TR*             ,DATE_ORIG_BILL                                             
MFA-TR*             ,REV_MTH_ORIG_BILL                                          
MFA-TR*             ,ACCT_BILL_CYCLE                                            
MFA-TR*             ,BILL_CALC_CYCLE                                            
MFA-TR*             ,CODE_REV_ACCT_TYPE                                         
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_DEPT_CD                                               
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,CODE_SIC_NO                                                
MFA-TR*             ,NAICS_CD                                                   
MFA-TR*             ,TIER_ACCT_TYPE_CD                                          
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,RATE_CALC_TYPE_CD                                          
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,REV_DISTRICT_CD                                            
MFA-TR*             ,MNICPLTY_COUNTY_CD                                         
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,CALC_SOURCE_CD                                             
MFA-TR*             ,REV_CALC_CYCLE                                             
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,ELEC_WNA_GROUP_NO                                          
MFA-TR*             ,REV_POST_STATUS_FL)                                        
MFA-TR*      SELECT  :WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,REV_COMPANY_NO                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,:WS-REV-MTH-FUTURE-OFFSET                                  
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,:WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,MULTIPLY_ALT(CUST_CT,-1)                                   
MFA-TR*             ,MULTIPLY_ALT(CUST_CT_EXCL_LIGHT,-1)                        
MFA-TR*             ,IFNULL(USAGE_END_DATE,                                     
MFA-TR*                 :RV-USAGE-END-DATE:WS-DATE-NULL-1)                      
MFA-TR*             ,NO_OF_CONS_DAYS                                            
MFA-TR*             ,PRORATED_DAYS_CD                                           
MFA-TR*             ,BTU_FACTOR                                                 
MFA-TR*             ,GAS_BASE_USE                                               
MFA-TR*             ,DESIGN_DAY_CAP                                             
MFA-TR*             ,IFNULL(DATE_BILLED,:RV-DATE-BILLED:WS-DATE-NULL-2)         
MFA-TR*             ,IFNULL(DATE_ORIG_BILL,                                     
MFA-TR*                 :RV-DATE-ORIG-BILL:WS-DATE-NULL-3)                      
MFA-TR*             ,REV_MTH_ORIG_BILL                                          
MFA-TR*             ,ACCT_BILL_CYCLE                                            
MFA-TR*             ,BILL_CALC_CYCLE                                            
MFA-TR*             ,CODE_REV_ACCT_TYPE                                         
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_DEPT_CD                                               
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,CODE_SIC_NO                                                
MFA-TR*             ,NAICS_CD                                                   
MFA-TR*             ,TIER_ACCT_TYPE_CD                                          
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,RATE_CALC_TYPE_CD                                          
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,REV_DISTRICT_CD                                            
MFA-TR*             ,MNICPLTY_COUNTY_CD                                         
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,'R'                                                        
MFA-TR*             ,REV_CALC_CYCLE                                             
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,ELEC_WNA_GROUP_NO                                          
MFA-TR*             ,REV_POST_STATUS_FL                                         
MFA-TR*       FROM  REV_BILLING_DET    RV                                       
MFA-TR*      WHERE  RV.BILL_UNIQUE_TS  =  :WS-BILL-UNIQUE-TS-OLD                
MFA-TR*        AND  RV.ACCOUNT_NO      =  :RV-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS_OLD'       TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS_NEW'       TO TABLE-ELEMENT-4        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-BILL-UNIQUE-TS-OLD      TO HOSTVAR-ELEMENT-3      
              MOVE WS-BILL-UNIQUE-TS-NEW      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT DATA INTO REV BILLING DET                             **        
      ******************************************************************        
      *                                                                         
       8500-INSERT-REV-BILLING-DET.                                     
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILLING_DET                                
                    (BILL_UNIQUE_TS                                     
                    ,REV_COMPANY_NO                                     
                    ,COMPANY_NO                                         
                    ,REVENUE_MONTH                                      
                    ,CODE_SERVICE_TYPE                                  
                    ,ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,CODE_UTIL_TYPE                                     
                    ,IC_NO                                              
                    ,BILL_ITEM_TIMESTMP                                 
                    ,CUST_CT                                            
                    ,CUST_CT_EXCL_LIGHT                                 
                    ,USAGE_END_DATE                                     
                    ,NO_OF_CONS_DAYS                                    
                    ,PRORATED_DAYS_CD                                   
                    ,BTU_FACTOR                                         
                    ,GAS_BASE_USE                                       
                    ,DESIGN_DAY_CAP                                     
                    ,DATE_BILLED                                        
                    ,DATE_ORIG_BILL                                     
                    ,REV_MTH_ORIG_BILL                                  
                    ,ACCT_BILL_CYCLE                                    
                    ,BILL_CALC_CYCLE                                    
                    ,CODE_REV_ACCT_TYPE                                 
                    ,CODE_REVENUE_CLASS                                 
                    ,RATE_PLAN_NO                                       
                    ,RATE_DEPT_CD                                       
                    ,PRTY_SVC_CAT_CD                                    
                    ,CODE_SIC_NO                                        
                    ,NAICS_CD                                           
                    ,TIER_ACCT_TYPE_CD                                  
                    ,OPTION_CD                                          
                    ,RATE_CALC_TYPE_CD                                  
                    ,LOCAL_OFFICE                                       
                    ,REV_DISTRICT_CD                                    
                    ,MNICPLTY_COUNTY_CD                                 
                    ,PREMISE_NO                                         
                    ,CALC_SOURCE_CD                                     
                    ,REV_CALC_CYCLE                                     
                    ,LAST_UPDATE_TS                                     
                    ,ELEC_WNA_GROUP_NO                                  
                    ,REV_POST_STATUS_FL)                                
             VALUES (                                                   
                     CIS.CHAR2TIMESTAMP(:RV-BILL-UNIQUE-TS)                     
                    ,:RV-REV-COMPANY-NO                                 
                    ,:RV-COMPANY-NO                                     
                    ,:RV-REVENUE-MONTH                                  
                    ,:RV-CODE-SERVICE-TYPE                              
                    ,:RV-ACCOUNT-NO                                     
                    ,:RV-BILL-NO                                        
                    ,:RV-CODE-UTIL-TYPE                                 
                    ,:RV-IC-NO                                          
                    ,CIS.CHAR2TIMESTAMP(:RV-BILL-ITEM-TIMESTMP)                 
                    ,:RV-CUST-CT                                        
                    ,:RV-CUST-CT-EXCL-LIGHT                             
                    ,IIF(TRY_CONVERT(DATE, :RV-USAGE-END-DATE 
                                           :WS-DATE-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-1
              ) <> 0) OR (LEN(:RV-USAGE-END-DATE :WS-DATE-NULL-1
              ) <> 10), CIS.CHAR2DATE(:RV-USAGE-END-DATE 
                                                        :WS-DATE-NULL-1
              ), CONVERT(DATE, :RV-USAGE-END-DATE :WS-DATE-NULL-1) )           
                    ,:RV-NO-OF-CONS-DAYS                                
                    ,:RV-PRORATED-DAYS-CD                               
                    ,:RV-BTU-FACTOR                                     
                    ,:RV-GAS-BASE-USE                                   
                    ,:RV-DESIGN-DAY-CAP                                 
                    ,IIF(TRY_CONVERT(DATE, :RV-DATE-BILLED 
                                           :WS-DATE-NULL-2
              ) IS NULL OR (PATINDEX('%.%', :RV-DATE-BILLED 
                                                        :WS-DATE-NULL-2
              ) <> 0) OR (LEN(:RV-DATE-BILLED :WS-DATE-NULL-2
              ) <> 10), CIS.CHAR2DATE(:RV-DATE-BILLED :WS-DATE-NULL-2
              ), CONVERT(DATE, :RV-DATE-BILLED :WS-DATE-NULL-2) )              
                    ,IIF(TRY_CONVERT(DATE, :RV-DATE-ORIG-BILL 
                                           :WS-DATE-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :RV-DATE-ORIG-BILL 
                                                        :WS-DATE-NULL-3
              ) <> 0) OR (LEN(:RV-DATE-ORIG-BILL :WS-DATE-NULL-3
              ) <> 10), CIS.CHAR2DATE(:RV-DATE-ORIG-BILL 
                                                        :WS-DATE-NULL-3
              ), CONVERT(DATE, :RV-DATE-ORIG-BILL :WS-DATE-NULL-3) )           
                    ,:RV-REV-MTH-ORIG-BILL                              
                    ,:RV-ACCT-BILL-CYCLE                                
                    ,:RV-BILL-CALC-CYCLE                                
                    ,:RV-CODE-REV-ACCT-TYPE                             
                    ,:RV-CODE-REVENUE-CLASS                             
                    ,:RV-RATE-PLAN-NO                                   
                    ,:RV-RATE-DEPT-CD                                   
                    ,:RV-PRTY-SVC-CAT-CD                                
                    ,:RV-CODE-SIC-NO                                    
                    ,:RV-NAICS-CD                                       
                    ,:RV-TIER-ACCT-TYPE-CD                              
                    ,:RV-OPTION-CD                                      
                    ,:RV-RATE-CALC-TYPE-CD                              
                    ,:RV-LOCAL-OFFICE                                   
                    ,:RV-REV-DISTRICT-CD                                
                    ,:RV-MNICPLTY-COUNTY-CD                             
                    ,:RV-PREMISE-NO                                     
                    ,:RV-CALC-SOURCE-CD                                 
                    ,:RV-REV-CALC-CYCLE                                 
                    ,CIS.CURRENT$TIMESTAMP()                                  
                    ,:RV-ELEC-WNA-GROUP-NO                              
                    ,:RV-REV-POST-STATUS-FL)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILLING_DET                                        
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,REV_COMPANY_NO                                             
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,IC_NO                                                      
MFA-TR*             ,BILL_ITEM_TIMESTMP                                         
MFA-TR*             ,CUST_CT                                                    
MFA-TR*             ,CUST_CT_EXCL_LIGHT                                         
MFA-TR*             ,USAGE_END_DATE                                             
MFA-TR*             ,NO_OF_CONS_DAYS                                            
MFA-TR*             ,PRORATED_DAYS_CD                                           
MFA-TR*             ,BTU_FACTOR                                                 
MFA-TR*             ,GAS_BASE_USE                                               
MFA-TR*             ,DESIGN_DAY_CAP                                             
MFA-TR*             ,DATE_BILLED                                                
MFA-TR*             ,DATE_ORIG_BILL                                             
MFA-TR*             ,REV_MTH_ORIG_BILL                                          
MFA-TR*             ,ACCT_BILL_CYCLE                                            
MFA-TR*             ,BILL_CALC_CYCLE                                            
MFA-TR*             ,CODE_REV_ACCT_TYPE                                         
MFA-TR*             ,CODE_REVENUE_CLASS                                         
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,RATE_DEPT_CD                                               
MFA-TR*             ,PRTY_SVC_CAT_CD                                            
MFA-TR*             ,CODE_SIC_NO                                                
MFA-TR*             ,NAICS_CD                                                   
MFA-TR*             ,TIER_ACCT_TYPE_CD                                          
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,RATE_CALC_TYPE_CD                                          
MFA-TR*             ,LOCAL_OFFICE                                               
MFA-TR*             ,REV_DISTRICT_CD                                            
MFA-TR*             ,MNICPLTY_COUNTY_CD                                         
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,CALC_SOURCE_CD                                             
MFA-TR*             ,REV_CALC_CYCLE                                             
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,ELEC_WNA_GROUP_NO                                          
MFA-TR*             ,REV_POST_STATUS_FL)                                        
MFA-TR*      VALUES (                                                           
MFA-TR*              :RV-BILL-UNIQUE-TS                                         
MFA-TR*             ,:RV-REV-COMPANY-NO                                         
MFA-TR*             ,:RV-COMPANY-NO                                             
MFA-TR*             ,:RV-REVENUE-MONTH                                          
MFA-TR*             ,:RV-CODE-SERVICE-TYPE                                      
MFA-TR*             ,:RV-ACCOUNT-NO                                             
MFA-TR*             ,:RV-BILL-NO                                                
MFA-TR*             ,:RV-CODE-UTIL-TYPE                                         
MFA-TR*             ,:RV-IC-NO                                                  
MFA-TR*             ,:RV-BILL-ITEM-TIMESTMP                                     
MFA-TR*             ,:RV-CUST-CT                                                
MFA-TR*             ,:RV-CUST-CT-EXCL-LIGHT                                     
MFA-TR*             ,:RV-USAGE-END-DATE:WS-DATE-NULL-1                          
MFA-TR*             ,:RV-NO-OF-CONS-DAYS                                        
MFA-TR*             ,:RV-PRORATED-DAYS-CD                                       
MFA-TR*             ,:RV-BTU-FACTOR                                             
MFA-TR*             ,:RV-GAS-BASE-USE                                           
MFA-TR*             ,:RV-DESIGN-DAY-CAP                                         
MFA-TR*             ,:RV-DATE-BILLED:WS-DATE-NULL-2                             
MFA-TR*             ,:RV-DATE-ORIG-BILL:WS-DATE-NULL-3                          
MFA-TR*             ,:RV-REV-MTH-ORIG-BILL                                      
MFA-TR*             ,:RV-ACCT-BILL-CYCLE                                        
MFA-TR*             ,:RV-BILL-CALC-CYCLE                                        
MFA-TR*             ,:RV-CODE-REV-ACCT-TYPE                                     
MFA-TR*             ,:RV-CODE-REVENUE-CLASS                                     
MFA-TR*             ,:RV-RATE-PLAN-NO                                           
MFA-TR*             ,:RV-RATE-DEPT-CD                                           
MFA-TR*             ,:RV-PRTY-SVC-CAT-CD                                        
MFA-TR*             ,:RV-CODE-SIC-NO                                            
MFA-TR*             ,:RV-NAICS-CD                                               
MFA-TR*             ,:RV-TIER-ACCT-TYPE-CD                                      
MFA-TR*             ,:RV-OPTION-CD                                              
MFA-TR*             ,:RV-RATE-CALC-TYPE-CD                                      
MFA-TR*             ,:RV-LOCAL-OFFICE                                           
MFA-TR*             ,:RV-REV-DISTRICT-CD                                        
MFA-TR*             ,:RV-MNICPLTY-COUNTY-CD                                     
MFA-TR*             ,:RV-PREMISE-NO                                             
MFA-TR*             ,:RV-CALC-SOURCE-CD                                         
MFA-TR*             ,:RV-REV-CALC-CYCLE                                         
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,:RV-ELEC-WNA-GROUP-NO                                      
MFA-TR*             ,:RV-REV-POST-STATUS-FL)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE RV-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT DATA INTO REV BILL COMP ADJ                           **        
      ******************************************************************        
      *                                                                         
       8520-INSERT-BILL-COMP-ADJ-DATA.                                  
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_COMP_ADJ                              
                    (BILL_UNIQUE_TS                                     
                    ,BILL_COMP_SEQ_NO                                   
                    ,CMPNT_ID_CD                                        
                    ,INSTR_USE_TYPE_CD                                  
                    ,CONSUMPT_TYPE_CD                                   
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_SEASON                                        
                    ,RT_VERS_FROM_DT                                    
                    ,RT_VERS_PRO_CD                                     
                    ,FACTOR_ID                                          
                    ,FACTOR_BLOCK_NO                                    
                    ,RT_FCT_FROM_DT                                     
                    ,RT_FCT_PRO_CD                                      
                    ,READ_UNITS                                         
                    ,BILL_USAGE_UNITS                                   
                    ,BILL_DEMAND_UNITS                                  
                    ,CALC_UNITS                                         
                    ,FACTOR                                             
                    ,BILLED_AMT                                         
                    ,CODE_STAT_TAX_XMT                                  
                    ,CODE_CITY_TAX_XMT                                  
                    ,CODE_OTHR_TAX_XMT                                  
                    ,UTILITY_REV_CD                                     
                    ,COMP_ADJ_CD                                        
                    ,GL_ACCT_NO                                         
                    ,SPCL_GROUP_CD                                      
                    ,ACCOUNT_NO                                         
                    ,LAST_UPDATE_TS)                                    
             VALUES (                                                   
                     CIS.CHAR2TIMESTAMP(:RB-BILL-UNIQUE-TS)                     
                    ,:RB-BILL-COMP-SEQ-NO                               
                    ,:RB-CMPNT-ID-CD                                    
                    ,:RB-INSTR-USE-TYPE-CD                              
                    ,:RB-CONSUMPT-TYPE-CD                               
                    ,:RB-CODE-TIME-PERIOD                               
                    ,:RB-CODE-SEASON                                    
                    ,IIF(TRY_CONVERT(DATE, :RB-RT-VERS-FROM-DT 
                                           :WS-DATE-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ) <> 0) OR (LEN(:RB-RT-VERS-FROM-DT :WS-DATE-NULL-4
              ) <> 10), CIS.CHAR2DATE(:RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ), CONVERT(DATE, :RB-RT-VERS-FROM-DT :WS-DATE-NULL-4) )          
                    ,:RB-RT-VERS-PRO-CD                                 
                    ,:RB-FACTOR-ID                                      
                    ,:RB-FACTOR-BLOCK-NO                                
                    ,IIF(TRY_CONVERT(DATE, :RB-RT-FCT-FROM-DT 
                                           :WS-DATE-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :RB-RT-FCT-FROM-DT 
                                                        :WS-DATE-NULL-5
              ) <> 0) OR (LEN(:RB-RT-FCT-FROM-DT :WS-DATE-NULL-5
              ) <> 10), CIS.CHAR2DATE(:RB-RT-FCT-FROM-DT 
                                                        :WS-DATE-NULL-5
              ), CONVERT(DATE, :RB-RT-FCT-FROM-DT :WS-DATE-NULL-5) )           
                    ,:RB-RT-FCT-PRO-CD                                  
                    ,:RB-READ-UNITS                                     
                    ,:RB-BILL-USAGE-UNITS                               
                    ,:RB-BILL-DEMAND-UNITS                              
                    ,:RB-CALC-UNITS                                     
                    ,:RB-FACTOR                                         
                    ,:RB-BILLED-AMT                                     
                    ,:RB-CODE-STAT-TAX-XMT                              
                    ,:RB-CODE-CITY-TAX-XMT                              
                    ,:RB-CODE-OTHR-TAX-XMT                              
                    ,:RB-UTILITY-REV-CD                                 
                    ,:RB-COMP-ADJ-CD                                    
                    ,:RB-GL-ACCT-NO                                     
                    ,:RB-SPCL-GROUP-CD                                  
                    ,:RB-ACCOUNT-NO                                     
                    ,CIS.CURRENT$TIMESTAMP())                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_COMP_ADJ                                      
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,CMPNT_ID_CD                                                
MFA-TR*             ,INSTR_USE_TYPE_CD                                          
MFA-TR*             ,CONSUMPT_TYPE_CD                                           
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_SEASON                                                
MFA-TR*             ,RT_VERS_FROM_DT                                            
MFA-TR*             ,RT_VERS_PRO_CD                                             
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,FACTOR_BLOCK_NO                                            
MFA-TR*             ,RT_FCT_FROM_DT                                             
MFA-TR*             ,RT_FCT_PRO_CD                                              
MFA-TR*             ,READ_UNITS                                                 
MFA-TR*             ,BILL_USAGE_UNITS                                           
MFA-TR*             ,BILL_DEMAND_UNITS                                          
MFA-TR*             ,CALC_UNITS                                                 
MFA-TR*             ,FACTOR                                                     
MFA-TR*             ,BILLED_AMT                                                 
MFA-TR*             ,CODE_STAT_TAX_XMT                                          
MFA-TR*             ,CODE_CITY_TAX_XMT                                          
MFA-TR*             ,CODE_OTHR_TAX_XMT                                          
MFA-TR*             ,UTILITY_REV_CD                                             
MFA-TR*             ,COMP_ADJ_CD                                                
MFA-TR*             ,GL_ACCT_NO                                                 
MFA-TR*             ,SPCL_GROUP_CD                                              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,LAST_UPDATE_TS)                                            
MFA-TR*      VALUES (                                                           
MFA-TR*              :RB-BILL-UNIQUE-TS                                         
MFA-TR*             ,:RB-BILL-COMP-SEQ-NO                                       
MFA-TR*             ,:RB-CMPNT-ID-CD                                            
MFA-TR*             ,:RB-INSTR-USE-TYPE-CD                                      
MFA-TR*             ,:RB-CONSUMPT-TYPE-CD                                       
MFA-TR*             ,:RB-CODE-TIME-PERIOD                                       
MFA-TR*             ,:RB-CODE-SEASON                                            
MFA-TR*             ,:RB-RT-VERS-FROM-DT:WS-DATE-NULL-4                         
MFA-TR*             ,:RB-RT-VERS-PRO-CD                                         
MFA-TR*             ,:RB-FACTOR-ID                                              
MFA-TR*             ,:RB-FACTOR-BLOCK-NO                                        
MFA-TR*             ,:RB-RT-FCT-FROM-DT:WS-DATE-NULL-5                          
MFA-TR*             ,:RB-RT-FCT-PRO-CD                                          
MFA-TR*             ,:RB-READ-UNITS                                             
MFA-TR*             ,:RB-BILL-USAGE-UNITS                                       
MFA-TR*             ,:RB-BILL-DEMAND-UNITS                                      
MFA-TR*             ,:RB-CALC-UNITS                                             
MFA-TR*             ,:RB-FACTOR                                                 
MFA-TR*             ,:RB-BILLED-AMT                                             
MFA-TR*             ,:RB-CODE-STAT-TAX-XMT                                      
MFA-TR*             ,:RB-CODE-CITY-TAX-XMT                                      
MFA-TR*             ,:RB-CODE-OTHR-TAX-XMT                                      
MFA-TR*             ,:RB-UTILITY-REV-CD                                         
MFA-TR*             ,:RB-COMP-ADJ-CD                                            
MFA-TR*             ,:RB-GL-ACCT-NO                                             
MFA-TR*             ,:RB-SPCL-GROUP-CD                                          
MFA-TR*             ,:RB-ACCOUNT-NO                                             
MFA-TR*             ,CURRENT TIMESTAMP)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'BILL_COMP_SEQ_NO'         TO TABLE-ELEMENT-3        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-4        
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE RB-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE RB-BILL-COMP-SEQ-NO        TO HOSTVAR-ELEMENT-3      
              MOVE RB-FACTOR-ID               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT REV BILL TAX DATA                                     **        
      ******************************************************************        
      *                                                                         
       8560-INSERT-REV-BILL-TAX-DATA.                                   
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_TAX                                   
                    (BILL_UNIQUE_TS                                     
                    ,TAX_TYPE                                           
                    ,TAX_CNTRL_NO                                       
                    ,TAX_FROM_DT                                        
                    ,FACTOR_ID                                          
                    ,TAX_GL_ACCT_NO                                     
                    ,TAX_AMT                                            
                    ,ACCOUNT_NO                                         
                    ,LAST_UPDATE_TS)                                    
             VALUES                                                     
                    (CIS.CHAR2TIMESTAMP(:R9-BILL-UNIQUE-TS)                     
                    ,:R9-TAX-TYPE                                       
                    ,:R9-TAX-CNTRL-NO                                   
                    ,IIF(TRY_CONVERT(DATE, :R9-TAX-FROM-DT
              ) IS NULL OR (PATINDEX('%.%', :R9-TAX-FROM-DT
              ) <> 0) OR (LEN(:R9-TAX-FROM-DT) <> 10), CIS.CHAR2DATE(
                                                        :R9-TAX-FROM-DT
              ), CONVERT(DATE, :R9-TAX-FROM-DT) )                              
                    ,:R9-FACTOR-ID                                      
                    ,:R9-TAX-GL-ACCT-NO                                 
                    ,:R9-TAX-AMT                                        
                    ,:R9-ACCOUNT-NO                                     
                    ,CIS.CURRENT$TIMESTAMP())                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_TAX                                           
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,TAX_TYPE                                                   
MFA-TR*             ,TAX_CNTRL_NO                                               
MFA-TR*             ,TAX_FROM_DT                                                
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,TAX_GL_ACCT_NO                                             
MFA-TR*             ,TAX_AMT                                                    
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,LAST_UPDATE_TS)                                            
MFA-TR*      VALUES                                                             
MFA-TR*             (:R9-BILL-UNIQUE-TS                                         
MFA-TR*             ,:R9-TAX-TYPE                                               
MFA-TR*             ,:R9-TAX-CNTRL-NO                                           
MFA-TR*             ,:R9-TAX-FROM-DT                                            
MFA-TR*             ,:R9-FACTOR-ID                                              
MFA-TR*             ,:R9-TAX-GL-ACCT-NO                                         
MFA-TR*             ,:R9-TAX-AMT                                                
MFA-TR*             ,:R9-ACCOUNT-NO                                             
MFA-TR*             ,CURRENT TIMESTAMP)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8560'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-3        
              MOVE 'TAX_TYPE'                 TO TABLE-ELEMENT-4        
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE R9-FACTOR-ID               TO HOSTVAR-ELEMENT-3      
              MOVE R9-TAX-TYPE                TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE ALL:UPDATE REV_POST_STATUS_FL OF REV BILLING DET     **        
      ******************************************************************        
      *                                                                         
       8600-UPDT-REV-BILL-DET-POST-ST.                                  
      *                                                                         
           EXEC SQL                                                     
             UPDATE  REV_BILLING_DET                                    
                SET  REV_POST_STATUS_FL  =  :RV-REV-POST-STATUS-FL      
             WHERE  BILL_UNIQUE_TS       =  CIS.CHAR2TIMESTAMP(
                                                     :RV-BILL-UNIQUE-TS
              )          
               AND  ACCOUNT_NO           =  :RV-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  REV_BILLING_DET                                            
MFA-TR*         SET  REV_POST_STATUS_FL  =  :RV-REV-POST-STATUS-FL              
MFA-TR*      WHERE  BILL_UNIQUE_TS       =  :RV-BILL-UNIQUE-TS                  
MFA-TR*        AND  ACCOUNT_NO           =  :RV-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8600'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-3        
              MOVE RV-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE RV-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE ALL: INSERT COMP ADJ WITH CURRENT TIMESTAMP          **        
      ** READ_UNITS        = READ_UNITS * -1                          **        
      ** BILL_USAGE_UNITS  = BILL_USAGE_UNITS * -1                    **        
      ** BILL_DEMAND_UNITS = BILL_DEMAND_UNITS * -1                   **        
      ** CALC_UNITS        = CALC_UNITS * -1                          **        
      ** BILLED_AMT        = BILLED_AMT * -1                          **        
      ******************************************************************        
      *                                                                         
       8620-INSERT-COMP-REVERSE-ALL.                                    
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_COMP_ADJ                              
                    (BILL_UNIQUE_TS                                     
                    ,BILL_COMP_SEQ_NO                                   
                    ,CMPNT_ID_CD                                        
                    ,INSTR_USE_TYPE_CD                                  
                    ,CONSUMPT_TYPE_CD                                   
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_SEASON                                        
                    ,RT_VERS_FROM_DT                                    
                    ,RT_VERS_PRO_CD                                     
                    ,FACTOR_ID                                          
                    ,FACTOR_BLOCK_NO                                    
                    ,RT_FCT_FROM_DT                                     
                    ,RT_FCT_PRO_CD                                      
                    ,READ_UNITS                                         
                    ,BILL_USAGE_UNITS                                   
                    ,BILL_DEMAND_UNITS                                  
                    ,CALC_UNITS                                         
                    ,FACTOR                                             
                    ,BILLED_AMT                                         
                    ,CODE_STAT_TAX_XMT                                  
                    ,CODE_CITY_TAX_XMT                                  
                    ,CODE_OTHR_TAX_XMT                                  
                    ,UTILITY_REV_CD                                     
                    ,COMP_ADJ_CD                                        
                    ,GL_ACCT_NO                                         
                    ,SPCL_GROUP_CD                                      
                    ,ACCOUNT_NO                                         
                    ,LAST_UPDATE_TS)                                    
             SELECT  CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,BILL_COMP_SEQ_NO                                   
                    ,CMPNT_ID_CD                                        
                    ,INSTR_USE_TYPE_CD                                  
                    ,CONSUMPT_TYPE_CD                                   
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_SEASON                                        
                    ,COALESCE(RT_VERS_FROM_DT,                            
                        IIF(TRY_CONVERT(DATE, :RB-RT-VERS-FROM-DT 
                                              :WS-DATE-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ) <> 0) OR (LEN(:RB-RT-VERS-FROM-DT :WS-DATE-NULL-4
              ) <> 10), CIS.CHAR2DATE(:RB-RT-VERS-FROM-DT 
                                                        :WS-DATE-NULL-4
              ), CONVERT(DATE, :RB-RT-VERS-FROM-DT :WS-DATE-NULL-4) ))         
                    ,RT_VERS_PRO_CD                                     
                    ,FACTOR_ID                                          
                    ,FACTOR_BLOCK_NO                                    
                    ,COALESCE(RT_FCT_FROM_DT,                             
                        IIF(TRY_CONVERT(DATE, :RB-RT-FCT-FROM-DT 
                                              :WS-DATE-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :RB-RT-FCT-FROM-DT 
                                                        :WS-DATE-NULL-5
              ) <> 0) OR (LEN(:RB-RT-FCT-FROM-DT :WS-DATE-NULL-5
              ) <> 10), CIS.CHAR2DATE(:RB-RT-FCT-FROM-DT 
                                                        :WS-DATE-NULL-5
              ), CONVERT(DATE, :RB-RT-FCT-FROM-DT :WS-DATE-NULL-5) ))          
                    ,RT_FCT_PRO_CD                                      
                    ,((READ_UNITS)*(-1))                        
                    ,((BILL_USAGE_UNITS)*(-1))                  
                    ,((BILL_DEMAND_UNITS)*(-1))                 
                    ,((CALC_UNITS)*(-1))                        
                    ,FACTOR                                             
                    ,((BILLED_AMT)*(-1))                        
                    ,CODE_STAT_TAX_XMT                                  
                    ,CODE_CITY_TAX_XMT                                  
                    ,CODE_OTHR_TAX_XMT                                  
                    ,UTILITY_REV_CD                                     
                    ,COMP_ADJ_CD                                        
                    ,GL_ACCT_NO                                         
                    ,SPCL_GROUP_CD                                      
                    ,ACCOUNT_NO                                         
                    ,CIS.CURRENT$TIMESTAMP()                                  
              FROM  REV_BILL_COMP_ADJ  RB                               
             WHERE  RB.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-UNIQUE-TS-OLD
              )        
               AND  RB.ACCOUNT_NO      =  :RB-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_COMP_ADJ                                      
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,CMPNT_ID_CD                                                
MFA-TR*             ,INSTR_USE_TYPE_CD                                          
MFA-TR*             ,CONSUMPT_TYPE_CD                                           
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_SEASON                                                
MFA-TR*             ,RT_VERS_FROM_DT                                            
MFA-TR*             ,RT_VERS_PRO_CD                                             
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,FACTOR_BLOCK_NO                                            
MFA-TR*             ,RT_FCT_FROM_DT                                             
MFA-TR*             ,RT_FCT_PRO_CD                                              
MFA-TR*             ,READ_UNITS                                                 
MFA-TR*             ,BILL_USAGE_UNITS                                           
MFA-TR*             ,BILL_DEMAND_UNITS                                          
MFA-TR*             ,CALC_UNITS                                                 
MFA-TR*             ,FACTOR                                                     
MFA-TR*             ,BILLED_AMT                                                 
MFA-TR*             ,CODE_STAT_TAX_XMT                                          
MFA-TR*             ,CODE_CITY_TAX_XMT                                          
MFA-TR*             ,CODE_OTHR_TAX_XMT                                          
MFA-TR*             ,UTILITY_REV_CD                                             
MFA-TR*             ,COMP_ADJ_CD                                                
MFA-TR*             ,GL_ACCT_NO                                                 
MFA-TR*             ,SPCL_GROUP_CD                                              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,LAST_UPDATE_TS)                                            
MFA-TR*      SELECT  :WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,CMPNT_ID_CD                                                
MFA-TR*             ,INSTR_USE_TYPE_CD                                          
MFA-TR*             ,CONSUMPT_TYPE_CD                                           
MFA-TR*             ,CODE_TIME_PERIOD                                           
MFA-TR*             ,CODE_SEASON                                                
MFA-TR*             ,IFNULL(RT_VERS_FROM_DT,                                    
MFA-TR*                 :RB-RT-VERS-FROM-DT:WS-DATE-NULL-4)                     
MFA-TR*             ,RT_VERS_PRO_CD                                             
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,FACTOR_BLOCK_NO                                            
MFA-TR*             ,IFNULL(RT_FCT_FROM_DT,                                     
MFA-TR*                 :RB-RT-FCT-FROM-DT:WS-DATE-NULL-5)                      
MFA-TR*             ,RT_FCT_PRO_CD                                              
MFA-TR*             ,MULTIPLY_ALT(READ_UNITS,-1)                                
MFA-TR*             ,MULTIPLY_ALT(BILL_USAGE_UNITS,-1)                          
MFA-TR*             ,MULTIPLY_ALT(BILL_DEMAND_UNITS,-1)                         
MFA-TR*             ,MULTIPLY_ALT(CALC_UNITS,-1)                                
MFA-TR*             ,FACTOR                                                     
MFA-TR*             ,MULTIPLY_ALT(BILLED_AMT,-1)                                
MFA-TR*             ,CODE_STAT_TAX_XMT                                          
MFA-TR*             ,CODE_CITY_TAX_XMT                                          
MFA-TR*             ,CODE_OTHR_TAX_XMT                                          
MFA-TR*             ,UTILITY_REV_CD                                             
MFA-TR*             ,COMP_ADJ_CD                                                
MFA-TR*             ,GL_ACCT_NO                                                 
MFA-TR*             ,SPCL_GROUP_CD                                              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*       FROM  REV_BILL_COMP_ADJ  RB                                       
MFA-TR*      WHERE  RB.BILL_UNIQUE_TS  =  :WS-BILL-UNIQUE-TS-OLD                
MFA-TR*        AND  RB.ACCOUNT_NO      =  :RB-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8620'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS_OLD'       TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS_NEW'       TO TABLE-ELEMENT-4        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-BILL-UNIQUE-TS-OLD      TO HOSTVAR-ELEMENT-3      
              MOVE WS-BILL-UNIQUE-TS-NEW      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE ALL:INSERT BILL BLOCK WITH CURRENT TIMESTAMP         **        
      ** BLK_BILL_USE_UNITS = BLK_BILL_USE_UNITS * -1                 **        
      ** BLK_BILL_DEM_UNITS = BLK_BILL_DEM_UNITS * -1                 **        
      ** BLK_BILL_LT_POLES  = BLK_BILL_LT_POLES * -1                  **        
      ** BLK_REV_AMT        = BLK_REV_AMT * -1                        **        
      ******************************************************************        
      *                                                                         
       8640-INSERT-BLOCK-REVERSE-ALL.                                   
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_BLOCK                                 
                    (BILL_UNIQUE_TS                                     
                    ,BILL_COMP_SEQ_NO                                   
                    ,BLK_NO_RT_ITM_CD                                   
                    ,BLK_USE_OR_SVCS                                    
                    ,BLK_BILL_USE_UNITS                                 
                    ,BLK_BILL_DEM_UNITS                                 
                    ,BLK_BILL_LT_POLES                                  
                    ,CUST_PER_SERVICE                                   
                    ,PRICE_TYPE_CD                                      
                    ,SCHED_PRICE_AM                                     
                    ,UNIT_PRICE_AM                                      
                    ,BLK_REV_AMT                                        
                    ,NET_UNIT_SEL_RSN                                   
                    ,KW_MDQ_DT                                          
                    ,KVA_DT                                             
                    ,CONTRACT_DEMAND                                    
                    ,READ_KW_MDQ_UNITS                                  
                    ,READ_KVA_UNITS                                     
                    ,POWER_FACTOR                                       
                    ,LOAD_FACTOR                                        
                    ,RT_VERS_PRO_PCT                                    
                    ,ACCOUNT_NO                                         
                    ,RATE_ITEM_CODE                                     
                    ,LAST_UPDATE_TS)                                    
             SELECT  CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,BILL_COMP_SEQ_NO                                   
                    ,BLK_NO_RT_ITM_CD                                   
                    ,BLK_USE_OR_SVCS                                    
                    ,((BLK_BILL_USE_UNITS)*(-1))                
                    ,((BLK_BILL_DEM_UNITS)*(-1))                
                    ,((BLK_BILL_LT_POLES)*(-1))                 
                    ,CUST_PER_SERVICE                                   
                    ,PRICE_TYPE_CD                                      
                    ,SCHED_PRICE_AM                                     
                    ,UNIT_PRICE_AM                                      
                    ,((BLK_REV_AMT)*(-1))                       
                    ,NET_UNIT_SEL_RSN                                   
                    ,COALESCE(KW_MDQ_DT,IIF(TRY_CONVERT(DATE, 
                                                         :R7-KW-MDQ-DT 
                                                        :WS-DATE-NULL-6
              ) IS NULL OR (PATINDEX('%.%', :R7-KW-MDQ-DT 
                                                        :WS-DATE-NULL-6
              ) <> 0) OR (LEN(:R7-KW-MDQ-DT :WS-DATE-NULL-6
              ) <> 10), CIS.CHAR2DATE(:R7-KW-MDQ-DT :WS-DATE-NULL-6
              ), CONVERT(DATE, :R7-KW-MDQ-DT :WS-DATE-NULL-6) ))     
                    ,COALESCE(KVA_DT,IIF(TRY_CONVERT(DATE, :R7-KVA-DT 
                                                        :WS-DATE-NULL-7
              ) IS NULL OR (PATINDEX('%.%', :R7-KVA-DT :WS-DATE-NULL-7
              ) <> 0) OR (LEN(:R7-KVA-DT :WS-DATE-NULL-7
              ) <> 10), CIS.CHAR2DATE(:R7-KVA-DT :WS-DATE-NULL-7
              ), CONVERT(DATE, :R7-KVA-DT :WS-DATE-NULL-7) ))           
                    ,CONTRACT_DEMAND                                    
                    ,READ_KW_MDQ_UNITS                                  
                    ,READ_KVA_UNITS                                     
                    ,POWER_FACTOR                                       
                    ,LOAD_FACTOR                                        
                    ,RT_VERS_PRO_PCT                                    
                    ,ACCOUNT_NO                                         
                    ,RATE_ITEM_CODE                                     
                    ,CIS.CURRENT$TIMESTAMP()                                  
              FROM  REV_BILL_BLOCK     R7                               
             WHERE  R7.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-UNIQUE-TS-OLD
              )        
               AND  R7.ACCOUNT_NO      =  :R7-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_BLOCK                                         
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,BLK_NO_RT_ITM_CD                                           
MFA-TR*             ,BLK_USE_OR_SVCS                                            
MFA-TR*             ,BLK_BILL_USE_UNITS                                         
MFA-TR*             ,BLK_BILL_DEM_UNITS                                         
MFA-TR*             ,BLK_BILL_LT_POLES                                          
MFA-TR*             ,CUST_PER_SERVICE                                           
MFA-TR*             ,PRICE_TYPE_CD                                              
MFA-TR*             ,SCHED_PRICE_AM                                             
MFA-TR*             ,UNIT_PRICE_AM                                              
MFA-TR*             ,BLK_REV_AMT                                                
MFA-TR*             ,NET_UNIT_SEL_RSN                                           
MFA-TR*             ,KW_MDQ_DT                                                  
MFA-TR*             ,KVA_DT                                                     
MFA-TR*             ,CONTRACT_DEMAND                                            
MFA-TR*             ,READ_KW_MDQ_UNITS                                          
MFA-TR*             ,READ_KVA_UNITS                                             
MFA-TR*             ,POWER_FACTOR                                               
MFA-TR*             ,LOAD_FACTOR                                                
MFA-TR*             ,RT_VERS_PRO_PCT                                            
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,LAST_UPDATE_TS)                                            
MFA-TR*      SELECT  :WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,BILL_COMP_SEQ_NO                                           
MFA-TR*             ,BLK_NO_RT_ITM_CD                                           
MFA-TR*             ,BLK_USE_OR_SVCS                                            
MFA-TR*             ,MULTIPLY_ALT(BLK_BILL_USE_UNITS,-1)                        
MFA-TR*             ,MULTIPLY_ALT(BLK_BILL_DEM_UNITS,-1)                        
MFA-TR*             ,MULTIPLY_ALT(BLK_BILL_LT_POLES,-1)                         
MFA-TR*             ,CUST_PER_SERVICE                                           
MFA-TR*             ,PRICE_TYPE_CD                                              
MFA-TR*             ,SCHED_PRICE_AM                                             
MFA-TR*             ,UNIT_PRICE_AM                                              
MFA-TR*             ,MULTIPLY_ALT(BLK_REV_AMT,-1)                               
MFA-TR*             ,NET_UNIT_SEL_RSN                                           
MFA-TR*             ,IFNULL(KW_MDQ_DT,:R7-KW-MDQ-DT:WS-DATE-NULL-6)             
MFA-TR*             ,IFNULL(KVA_DT,:R7-KVA-DT:WS-DATE-NULL-7)                   
MFA-TR*             ,CONTRACT_DEMAND                                            
MFA-TR*             ,READ_KW_MDQ_UNITS                                          
MFA-TR*             ,READ_KVA_UNITS                                             
MFA-TR*             ,POWER_FACTOR                                               
MFA-TR*             ,LOAD_FACTOR                                                
MFA-TR*             ,RT_VERS_PRO_PCT                                            
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,RATE_ITEM_CODE                                             
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*       FROM  REV_BILL_BLOCK     R7                                       
MFA-TR*      WHERE  R7.BILL_UNIQUE_TS  =  :WS-BILL-UNIQUE-TS-OLD                
MFA-TR*        AND  R7.ACCOUNT_NO      =  :R7-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8640'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_BLOCK'           TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS_OLD'       TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS_NEW'       TO TABLE-ELEMENT-4        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE R7-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-BILL-UNIQUE-TS-OLD      TO HOSTVAR-ELEMENT-3      
              MOVE WS-BILL-UNIQUE-TS-NEW      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8640-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** REVERSE ALL: INSERT BILL TAX ROW WITH CURRENT TIMESTAMP      **        
      ** TAX_AMT = TAX_AMT * -1                                       **        
      ******************************************************************        
      *                                                                         
       8660-INSERT-TAX-REVERSE-ALL.                                     
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_TAX                                   
                    (BILL_UNIQUE_TS                                     
                    ,TAX_TYPE                                           
                    ,TAX_CNTRL_NO                                       
                    ,TAX_FROM_DT                                        
                    ,FACTOR_ID                                          
                    ,TAX_GL_ACCT_NO                                     
                    ,TAX_AMT                                            
                    ,ACCOUNT_NO                                         
                    ,LAST_UPDATE_TS)                                    
             SELECT  CIS.CHAR2TIMESTAMP(:WS-BILL-UNIQUE-TS-NEW)                 
                    ,TAX_TYPE                                           
                    ,TAX_CNTRL_NO                                       
                    ,TAX_FROM_DT                                        
                    ,FACTOR_ID                                          
                    ,TAX_GL_ACCT_NO                                     
                    ,((TAX_AMT)*(-1))                           
                    ,ACCOUNT_NO                                         
                    ,CIS.CURRENT$TIMESTAMP()                                  
              FROM  REV_BILL_TAX       R9                               
             WHERE  R9.BILL_UNIQUE_TS  =  CIS.CHAR2TIMESTAMP(
                                                 :WS-BILL-UNIQUE-TS-OLD
              )        
               AND  R9.ACCOUNT_NO      =  :R9-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_TAX                                           
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,TAX_TYPE                                                   
MFA-TR*             ,TAX_CNTRL_NO                                               
MFA-TR*             ,TAX_FROM_DT                                                
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,TAX_GL_ACCT_NO                                             
MFA-TR*             ,TAX_AMT                                                    
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,LAST_UPDATE_TS)                                            
MFA-TR*      SELECT  :WS-BILL-UNIQUE-TS-NEW                                     
MFA-TR*             ,TAX_TYPE                                                   
MFA-TR*             ,TAX_CNTRL_NO                                               
MFA-TR*             ,TAX_FROM_DT                                                
MFA-TR*             ,FACTOR_ID                                                  
MFA-TR*             ,TAX_GL_ACCT_NO                                             
MFA-TR*             ,MULTIPLY_ALT(TAX_AMT,-1)                                   
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*       FROM  REV_BILL_TAX       R9                                       
MFA-TR*      WHERE  R9.BILL_UNIQUE_TS  =  :WS-BILL-UNIQUE-TS-OLD                
MFA-TR*        AND  R9.ACCOUNT_NO      =  :R9-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8660'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS_OLD'       TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS_NEW'       TO TABLE-ELEMENT-4        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE WS-BILL-UNIQUE-TS-OLD      TO HOSTVAR-ELEMENT-3      
              MOVE WS-BILL-UNIQUE-TS-NEW      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8660-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INSERT BILL MISC INFO ROW WITH CURRENT TIMESTAMP             **        
      ******************************************************************        
      *                                                                         
       8850-INSERT-REV-BILL-MISC-INFO.                                  
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO REV_BILL_MISC_INFO                             
                    (BILL_UNIQUE_TS                                     
                    ,ACCOUNT_NO                                         
                    ,GL_INTRFCE_DB_ACCT                                 
                    ,GL_INTRFCE_CR_ACCT                                 
                    ,COMMENTS                                           
                    ,LAST_UPDATE_TS                                     
                    ,LAST_UPDATE_USERID)                                
             VALUES                                                     
                    (CIS.CHAR2TIMESTAMP(:2Z-BILL-UNIQUE-TS)                     
                    ,:2Z-ACCOUNT-NO                                     
                    ,:2Z-GL-INTRFCE-DB-ACCT                             
                    ,:2Z-GL-INTRFCE-CR-ACCT                             
                    ,:2Z-COMMENTS                                       
                    ,CIS.CURRENT$TIMESTAMP()                                  
                    ,:2Z-LAST-UPDATE-USERID)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO REV_BILL_MISC_INFO                                     
MFA-TR*             (BILL_UNIQUE_TS                                             
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,GL_INTRFCE_DB_ACCT                                         
MFA-TR*             ,GL_INTRFCE_CR_ACCT                                         
MFA-TR*             ,COMMENTS                                                   
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,LAST_UPDATE_USERID)                                        
MFA-TR*      VALUES                                                             
MFA-TR*             (:2Z-BILL-UNIQUE-TS                                         
MFA-TR*             ,:2Z-ACCOUNT-NO                                             
MFA-TR*             ,:2Z-GL-INTRFCE-DB-ACCT                                     
MFA-TR*             ,:2Z-GL-INTRFCE-CR-ACCT                                     
MFA-TR*             ,:2Z-COMMENTS                                               
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,:2Z-LAST-UPDATE-USERID)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8850'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_MISC_INFO'       TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE 2Z-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE 2Z-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8850-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** UPDATE REV BILL MISC INFO DATA                               **        
      ******************************************************************        
      *                                                                         
       8875-UPDATE-REV-BILL-MISC-INFO.                                  
      *                                                                         
           EXEC SQL                                                     
             UPDATE  REV_BILL_MISC_INFO                                 
                SET  GL_INTRFCE_DB_ACCT  =  :2Z-GL-INTRFCE-DB-ACCT      
                    ,GL_INTRFCE_CR_ACCT  =  :2Z-GL-INTRFCE-CR-ACCT      
                    ,COMMENTS            =  :2Z-COMMENTS                
                    ,LAST_UPDATE_USERID  =  :2Z-LAST-UPDATE-USERID      
             WHERE   BILL_UNIQUE_TS      =  CIS.CHAR2TIMESTAMP(
                                                     :2Z-BILL-UNIQUE-TS
              )          
               AND   ACCOUNT_NO          =  :2Z-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE  REV_BILL_MISC_INFO                                         
MFA-TR*         SET  GL_INTRFCE_DB_ACCT  =  :2Z-GL-INTRFCE-DB-ACCT              
MFA-TR*             ,GL_INTRFCE_CR_ACCT  =  :2Z-GL-INTRFCE-CR-ACCT              
MFA-TR*             ,COMMENTS            =  :2Z-COMMENTS                        
MFA-TR*             ,LAST_UPDATE_USERID  =  :2Z-LAST-UPDATE-USERID              
MFA-TR*      WHERE   BILL_UNIQUE_TS      =  :2Z-BILL-UNIQUE-TS                  
MFA-TR*        AND   ACCOUNT_NO          =  :2Z-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8875'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_MISC_INFO'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-2        
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-3        
              MOVE 2Z-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 2Z-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-2      
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8875-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                 00003400
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
