       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04503.                                          
       AUTHOR.       GOPI DUGGIRALA.                                    
       DATE-WRITTEN. JAN 15, 2013.                                      
       DATE-COMPILED.                                                   
      *****************************************************************         
      **                          SCE&G                              **         
      *****************************************************************         
      **                STORED PROCEDURE: CSR04503                   **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      ** THIS PROGRAM WILL BE USED IN SUMMARY/DETAILS SCREENS IN     **         
      ** REVENUE ADJUSTMENTS PROCESS.                                **         
      **                                                             **         
      ** PARAMETERS                                                  **         
      **                                                             **         
      **  INPUT                                                      **         
      **   CALL_TYPE              CHAR(01)                           **         
      **   REVENUE_MONTH          CHAR(06)                           **         
      **   ACCOUNT_NO             CHAR(13)                           **         
      **   BILL_UNIQUE_TS         CHAR(26)                           **         
      **   REVENUE_ACTION         CHAR(01)                           **         
      **                                                             **         
      **  OUTPUT                                                     **         
      **   RES SET1:REVENUE ADJUSTMENTS-INITIAL CALL                 **         
      **   RES SET2:REVENUE ADJUSTMENTS-SUMMARY                      **         
      **   RES SET3:REVENUE ADJUSTMENTS-DETAILS                      **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM MODIFICATION LOG                       **         
      ** DATE        INITIALS     REASON                             **         
      ** --------    ---------    ---------------------------------- **         
P00641** 01/15/13    GD43988      NEW PROGRAM.                       **         
A04581** 05/15/13    GD43988      1.ADDED BILL USAGE/DEMAND UNITS.   **         
A04581**                          2.REMOVED CALC UNITS.              **         
A04581** 08/16/13    GD43988      FIX FOR READ/BILL UNITS CHECK.     **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04503'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_JOB_PARM, G6                                                     
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILLING_DET, RV                                                  
           EXEC SQL                                                             
               INCLUDE TBREVBLD                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILL_COMP_ADJ, RB                                                
           EXEC SQL                                                             
               INCLUDE TBREVCOM                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILL_BLOCK, R7                                                   
           EXEC SQL                                                             
               INCLUDE TBREVBLK                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILL_TAX, R9                                                     
           EXEC SQL                                                             
               INCLUDE TBREVTAX                                                 
           END-EXEC.                                                            
      *                                                                         
      **** REV_BILL_MISC_INFO, 2Z                                               
           EXEC SQL                                                             
               INCLUDE TBREVBIL                                                 
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04503'.      
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-CALL-TYPE          PIC X(01).                       
           05  PARM-REVENUE-MONTH      PIC X(06).                       
           05  PARM-REVENUE-MONTH-NUM REDEFINES                         
                   PARM-REVENUE-MONTH  PIC 9(06).                       
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-ACCOUNT-NO-NUM REDEFINES                            
               PARM-ACCOUNT-NO         PIC 9(13).                       
           05  PARM-BILL-UNIQUE-TS     PIC X(26).                       
           05  PARM-REVENUE-ACTION     PIC X(01).                       
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-INITIAL             PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-SUMMARY             PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-DETAILS             PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
      *                                                                         
           05  GTT-RETURN-FIELDS-INITIAL.                               
               10 S-RETURN-CODE-INIT        PIC S9(9) COMP VALUE 0.     
COB305         10 S-LIST-OF-REV-MTH        PIC S9(6)V USAGE COMP-3 
COB305           VALUE 0.    
      *                                                                         
           05  GTT-RETURN-FIELDS-SUMMARY.                               
               10 S-RETURN-CODE-SUMMARY     PIC S9(9) COMP VALUE 0.     
COB305         10 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.   
               10 S-CODE-UTIL-TYPE          PIC X(01).                  
               10 S-IC-NO                   PIC S9(4) USAGE COMP.       
               10 S-BILL-NO                 PIC S9(9) USAGE COMP.       
               10 S-BILL-ITEM-TIMESTMP      PIC X(26).                  
               10 S-CUST-CT                 PIC S9(9) USAGE COMP.       
               10 S-BILL-UNIQUE-TS          PIC X(26).                  
COB305         10 S-REVENUE-MONTH        PIC S9(6)V USAGE COMP-3 
COB305           VALUE 0.    
               10 S-REV-MTH-ORIG-BILL       PIC S9(9) USAGE COMP.       
               10 S-NO-OF-CONS-DAYS         PIC S9(4) USAGE COMP.       
               10 S-USAGE-END-DATE          PIC X(10).                  
               10 S-RATE-PLAN-NO            PIC X(3).                   
               10 S-CODE-REVENUE-CLASS      PIC X(3).                   
               10 S-LOCAL-OFFICE            PIC X(3).                   
               10 S-REV-DISTRICT-CD         PIC X(3).                   
COB305         10 S-BTU-FACTOR        PIC S9(2)V9(5) USAGE COMP-3 
COB305           VALUE 0.
COB305         10 S-GAS-BASE-USE        PIC S9(9)V USAGE COMP-3 VALUE 0.    
               10 S-CALC-SOURCE-CD          PIC X(1).                   
               10 S-REV-POST-STATUS-FL      PIC X(1).                   
COB305         10 S-TOTAL-READ-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.    
COB305         10 S-TOTAL-BILL-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.    
COB305         10 S-TOTAL-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.    
COB305         10 S-TOTAL-BILLED-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.
COB305         10 S-TOTAL-FRAN-TAX-AMT        PIC S9(7)V9(2) 
COB305           USAGE COMP-3 VALUE 0.
COB305         10 S-TOTAL-OTHR-TAX-AMT        PIC S9(7)V9(2) 
COB305           USAGE COMP-3 VALUE 0.
COB305         10 S-GL-INTRFCE-DB-ACCT        PIC S9(3)V9(4) 
COB305           USAGE COMP-3 VALUE 0.
COB305         10 S-GL-INTRFCE-CR-ACCT        PIC S9(3)V9(4) 
COB305           USAGE COMP-3 VALUE 0.
               10 S-COMMENTS                PIC X(250).                 
      *                                                                         
           05  GTT-RETURN-FIELDS-DETAILS.                               
               10 S-RETURN-CODE-DET         PIC S9(9) COMP VALUE 0.     
               10 S-RECORD-TYPE             PIC X(01) VALUE SPACES.     
               10 S-BILL-COMP-SEQ-NO        PIC S9(4) USAGE COMP.       
               10 S-CMPNT-ID-CD             PIC X(2).                   
               10 S-INSTR-USE-TYPE-CD       PIC X(1).                   
               10 S-CONSUMPT-TYPE-CD        PIC X(1).                   
               10 S-CODE-TIME-PERIOD        PIC S9(4) USAGE COMP.       
               10 S-RT-VERS-FROM-DT         PIC X(10).                  
               10 S-FACTOR-ID               PIC X(9).                   
               10 S-FACTOR-BLOCK-NO         PIC S9(9) USAGE COMP.       
COB305         10 S-READ-UNITS        PIC S9(9)V USAGE COMP-3 VALUE 0.    
COB305         10 S-BILL-USAGE-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.    
COB305         10 S-BILL-DEMAND-UNITS        PIC S9(9)V USAGE COMP-3 
COB305           VALUE 0.    
COB305         10 S-FACTOR        PIC S9(9)V9(6) USAGE COMP-3 VALUE 0.
COB305         10 S-FACTOR-AMT        PIC S9(9)V9(2) USAGE COMP-3 
COB305           VALUE 0.
COB305         10 S-GL-ACCT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305           VALUE 0.
               10 S-TAX-TYPE                PIC X(1).                   
               10 S-TAX-CNTRL-NO            PIC S9(4) USAGE COMP.       
               10 S-TAX-FROM-DT             PIC X(10).                  
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
           10  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88  SEND-DONE-ERROR                    VALUE 'N'.        
               88  SEND-DONE-OK                       VALUE 'Y'.        
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-NULL-1               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-2               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-3               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-4               PIC S9(04) COMP VALUE +0.   
           05  WS-DATE-NULL-5               PIC S9(04) COMP VALUE +0.   
      *                                                                         
       01  WS-MISC-VAR.                                                 
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-REPORTDATE-REV-MTH        PIC X(06).                  
           05  WS-REPORTDATE-REV-MTH-NUM REDEFINES                      
               WS-REPORTDATE-REV-MTH        PIC 9(06).                  
           05  WS-REV-MTH-TEMP              PIC 9(06).                  
           05  WS-REV-MTH-TEMP-N REDEFINES WS-REV-MTH-TEMP.             
               10  WS-REV-MTH-TEMP-YYYY     PIC 9(04).                  
               10  WS-REV-MTH-TEMP-MM       PIC 9(02).                  
COB305     05 WS-TOTAL-FRAN-TAX-AMT        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0.
COB305     05 WS-TOTAL-OTHR-TAX-AMT        PIC S9(7)V9(2) USAGE COMP-3 
COB305       VALUE 0.
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** DB2 AND SQL ERROR CHECKING                                           
           COPY CWS00303.                                                       
      *                                                                         
      **** ABEND ROUTINE (USED WITH CPD09900 INCLUDE MEMBER)                    
           COPY CWS09900.                                                       
      *                                                                         
      **** REVENUE ADJUSTMENTS SUMMARY DATA USING CALC SOURCE CODE              
      *                                                                         
           EXEC SQL                                                     
             DECLARE  SUMMARY_REV_CORR CURSOR FOR                       
              SELECT  RV.ACCOUNT_NO                                     
                     ,RV.CODE_UTIL_TYPE                                 
                     ,RV.IC_NO                                          
                     ,RV.BILL_NO                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           RV.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                     ,RV.CUST_CT                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           RV.BILL_UNIQUE_TS, 121), ' ', '-'), ':', '.') BILL_UNIQUE_TS        
                     ,RV.REVENUE_MONTH                                  
                     ,RV.REV_MTH_ORIG_BILL                              
                     ,RV.DATE_BILLED                                    
                     ,RV.DATE_ORIG_BILL                                 
                     ,RV.NO_OF_CONS_DAYS                                
                     ,RV.USAGE_END_DATE                                 
                     ,RV.RATE_PLAN_NO                                   
                     ,RV.CODE_REVENUE_CLASS                             
                     ,RV.LOCAL_OFFICE                                   
                     ,RV.REV_DISTRICT_CD                                
                     ,RV.BTU_FACTOR                                     
                     ,RV.GAS_BASE_USE                                   
                     ,RV.CALC_SOURCE_CD                                 
                     ,RV.REV_POST_STATUS_FL                             
               FROM  REV_BILLING_DET   RV WITH(READUNCOMMITTED)                 
              WHERE  RV.REVENUE_MONTH   =  :RV-REVENUE-MONTH            
                AND  RV.CALC_SOURCE_CD  =  'R'                          
             ORDER BY RV.ACCOUNT_NO, RV.REVENUE_MONTH                   
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  SUMMARY_REV_CORR CURSOR FOR                               
MFA-TR*       SELECT  RV.ACCOUNT_NO                                             
MFA-TR*              ,RV.CODE_UTIL_TYPE                                         
MFA-TR*              ,RV.IC_NO                                                  
MFA-TR*              ,RV.BILL_NO                                                
MFA-TR*              ,RV.BILL_ITEM_TIMESTMP                                     
MFA-TR*              ,RV.CUST_CT                                                
MFA-TR*              ,RV.BILL_UNIQUE_TS                                         
MFA-TR*              ,RV.REVENUE_MONTH                                          
MFA-TR*              ,RV.REV_MTH_ORIG_BILL                                      
MFA-TR*              ,RV.DATE_BILLED                                            
MFA-TR*              ,RV.DATE_ORIG_BILL                                         
MFA-TR*              ,RV.NO_OF_CONS_DAYS                                        
MFA-TR*              ,RV.USAGE_END_DATE                                         
MFA-TR*              ,RV.RATE_PLAN_NO                                           
MFA-TR*              ,RV.CODE_REVENUE_CLASS                                     
MFA-TR*              ,RV.LOCAL_OFFICE                                           
MFA-TR*              ,RV.REV_DISTRICT_CD                                        
MFA-TR*              ,RV.BTU_FACTOR                                             
MFA-TR*              ,RV.GAS_BASE_USE                                           
MFA-TR*              ,RV.CALC_SOURCE_CD                                         
MFA-TR*              ,RV.REV_POST_STATUS_FL                                     
MFA-TR*        FROM  REV_BILLING_DET   RV                                       
MFA-TR*       WHERE  RV.REVENUE_MONTH   =  :RV-REVENUE-MONTH                    
MFA-TR*         AND  RV.CALC_SOURCE_CD  =  'R'                                  
MFA-TR*      ORDER BY RV.ACCOUNT_NO, RV.REVENUE_MONTH                           
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **** REVENUE ADJUSTMENTS SUMMARY DATA USING ACCOUNT NO                    
      *                                                                         
           EXEC SQL                                                     
             DECLARE  SUMMARY_REV_ACCT CURSOR FOR                       
              SELECT  RV.ACCOUNT_NO                                     
                     ,RV.CODE_UTIL_TYPE                                 
                     ,RV.IC_NO                                          
                     ,RV.BILL_NO                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           RV.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                             
                     ,RV.CUST_CT                                        
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           RV.BILL_UNIQUE_TS, 121), ' ', '-'), ':', '.') BILL_UNIQUE_TS        
                     ,RV.REVENUE_MONTH                                  
                     ,RV.REV_MTH_ORIG_BILL                              
                     ,RV.DATE_BILLED                                    
                     ,RV.DATE_ORIG_BILL                                 
                     ,RV.NO_OF_CONS_DAYS                                
                     ,RV.USAGE_END_DATE                                 
                     ,RV.RATE_PLAN_NO                                   
                     ,RV.CODE_REVENUE_CLASS                             
                     ,RV.LOCAL_OFFICE                                   
                     ,RV.REV_DISTRICT_CD                                
                     ,RV.BTU_FACTOR                                     
                     ,RV.GAS_BASE_USE                                   
                     ,RV.CALC_SOURCE_CD                                 
                     ,RV.REV_POST_STATUS_FL                             
               FROM  REV_BILLING_DET   RV WITH(READUNCOMMITTED)                 
              WHERE  RV.REVENUE_MONTH  =  :RV-REVENUE-MONTH             
                AND  RV.ACCOUNT_NO     =  :RV-ACCOUNT-NO                
             ORDER BY RV.ACCOUNT_NO, RV.REVENUE_MONTH                   
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  SUMMARY_REV_ACCT CURSOR FOR                               
MFA-TR*       SELECT  RV.ACCOUNT_NO                                             
MFA-TR*              ,RV.CODE_UTIL_TYPE                                         
MFA-TR*              ,RV.IC_NO                                                  
MFA-TR*              ,RV.BILL_NO                                                
MFA-TR*              ,RV.BILL_ITEM_TIMESTMP                                     
MFA-TR*              ,RV.CUST_CT                                                
MFA-TR*              ,RV.BILL_UNIQUE_TS                                         
MFA-TR*              ,RV.REVENUE_MONTH                                          
MFA-TR*              ,RV.REV_MTH_ORIG_BILL                                      
MFA-TR*              ,RV.DATE_BILLED                                            
MFA-TR*              ,RV.DATE_ORIG_BILL                                         
MFA-TR*              ,RV.NO_OF_CONS_DAYS                                        
MFA-TR*              ,RV.USAGE_END_DATE                                         
MFA-TR*              ,RV.RATE_PLAN_NO                                           
MFA-TR*              ,RV.CODE_REVENUE_CLASS                                     
MFA-TR*              ,RV.LOCAL_OFFICE                                           
MFA-TR*              ,RV.REV_DISTRICT_CD                                        
MFA-TR*              ,RV.BTU_FACTOR                                             
MFA-TR*              ,RV.GAS_BASE_USE                                           
MFA-TR*              ,RV.CALC_SOURCE_CD                                         
MFA-TR*              ,RV.REV_POST_STATUS_FL                                     
MFA-TR*        FROM  REV_BILLING_DET   RV                                       
MFA-TR*       WHERE  RV.REVENUE_MONTH  =  :RV-REVENUE-MONTH                     
MFA-TR*         AND  RV.ACCOUNT_NO     =  :RV-ACCOUNT-NO                        
MFA-TR*      ORDER BY RV.ACCOUNT_NO, RV.REVENUE_MONTH                           
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7130                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **** SELECT REVENUE ADJUSTMENTS DETAILS DATA - BILL COMP ADJ              
      *                                                                         
           EXEC SQL                                                     
             DECLARE  REV_ADJ_DET_COMP CURSOR FOR                       
              SELECT  RB.BILL_COMP_SEQ_NO                               
                     ,RB.CMPNT_ID_CD                                    
                     ,RB.INSTR_USE_TYPE_CD                              
                     ,RB.CONSUMPT_TYPE_CD                               
                     ,RB.CODE_TIME_PERIOD                               
                     ,RB.CODE_SEASON                                    
                     ,RB.RT_VERS_FROM_DT                                
                     ,RB.RT_VERS_PRO_CD                                 
                     ,RB.FACTOR_ID                                      
                     ,RB.FACTOR_BLOCK_NO                                
                     ,RB.RT_FCT_FROM_DT                                 
                     ,RB.RT_FCT_PRO_CD                                  
                     ,RB.READ_UNITS                                     
A04581               ,RB.BILL_USAGE_UNITS                               
A04581               ,RB.BILL_DEMAND_UNITS                              
                     ,RB.FACTOR                                         
                     ,RB.BILLED_AMT                                     
                     ,RB.UTILITY_REV_CD                                 
                     ,RB.COMP_ADJ_CD                                    
                     ,RB.GL_ACCT_NO                                     
               FROM  REV_BILL_COMP_ADJ   RB WITH(READUNCOMMITTED)               
              WHERE  RB.BILL_UNIQUE_TS    =  CIS.CHAR2TIMESTAMP(
                                                     :RB-BILL-UNIQUE-TS
              )         
                AND  RB.ACCOUNT_NO        =  :RB-ACCOUNT-NO             
             ORDER BY RB.BILL_COMP_SEQ_NO                               
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  REV_ADJ_DET_COMP CURSOR FOR                               
MFA-TR*       SELECT  RB.BILL_COMP_SEQ_NO                                       
MFA-TR*              ,RB.CMPNT_ID_CD                                            
MFA-TR*              ,RB.INSTR_USE_TYPE_CD                                      
MFA-TR*              ,RB.CONSUMPT_TYPE_CD                                       
MFA-TR*              ,RB.CODE_TIME_PERIOD                                       
MFA-TR*              ,RB.CODE_SEASON                                            
MFA-TR*              ,RB.RT_VERS_FROM_DT                                        
MFA-TR*              ,RB.RT_VERS_PRO_CD                                         
MFA-TR*              ,RB.FACTOR_ID                                              
MFA-TR*              ,RB.FACTOR_BLOCK_NO                                        
MFA-TR*              ,RB.RT_FCT_FROM_DT                                         
MFA-TR*              ,RB.RT_FCT_PRO_CD                                          
MFA-TR*              ,RB.READ_UNITS                                             
MFA-TR*              ,RB.BILL_USAGE_UNITS                                       
MFA-TR*              ,RB.BILL_DEMAND_UNITS                                      
MFA-TR*              ,RB.FACTOR                                                 
MFA-TR*              ,RB.BILLED_AMT                                             
MFA-TR*              ,RB.UTILITY_REV_CD                                         
MFA-TR*              ,RB.COMP_ADJ_CD                                            
MFA-TR*              ,RB.GL_ACCT_NO                                             
MFA-TR*        FROM  REV_BILL_COMP_ADJ   RB                                     
MFA-TR*       WHERE  RB.BILL_UNIQUE_TS    =  :RB-BILL-UNIQUE-TS                 
MFA-TR*         AND  RB.ACCOUNT_NO        =  :RB-ACCOUNT-NO                     
MFA-TR*      ORDER BY RB.BILL_COMP_SEQ_NO                                       
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      **** SELECT REVENUE ADJUSTMENTS DETAILS DATA - BILL TAX                   
      *                                                                         
           EXEC SQL                                                     
             DECLARE  REV_ADJ_DET_TAX CURSOR FOR                        
              SELECT  R9.TAX_TYPE                                       
                     ,R9.TAX_CNTRL_NO                                   
                     ,R9.TAX_FROM_DT                                    
                     ,R9.FACTOR_ID                                      
                     ,R9.TAX_GL_ACCT_NO                                 
                     ,R9.TAX_AMT                                        
               FROM  REV_BILL_TAX        R9 WITH(READUNCOMMITTED)               
              WHERE  R9.BILL_UNIQUE_TS    =  CIS.CHAR2TIMESTAMP(
                                                     :R9-BILL-UNIQUE-TS
              )         
                AND  R9.ACCOUNT_NO        =  :R9-ACCOUNT-NO             
             ORDER BY R9.TAX_CNTRL_NO                                   
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  REV_ADJ_DET_TAX CURSOR FOR                                
MFA-TR*       SELECT  R9.TAX_TYPE                                               
MFA-TR*              ,R9.TAX_CNTRL_NO                                           
MFA-TR*              ,R9.TAX_FROM_DT                                            
MFA-TR*              ,R9.FACTOR_ID                                              
MFA-TR*              ,R9.TAX_GL_ACCT_NO                                         
MFA-TR*              ,R9.TAX_AMT                                                
MFA-TR*        FROM  REV_BILL_TAX        R9                                     
MFA-TR*       WHERE  R9.BILL_UNIQUE_TS    =  :R9-BILL-UNIQUE-TS                 
MFA-TR*         AND  R9.ACCOUNT_NO        =  :R9-ACCOUNT-NO                     
MFA-TR*      ORDER BY R9.TAX_CNTRL_NO                                           
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-CALL-TYPE           PIC X(01).                          
       01  LINK-REVENUE-MONTH       PIC X(06).                          
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-BILL-UNIQUE-TS      PIC X(26).                          
       01  LINK-REVENUE-ACTION      PIC X(01).                          
      *                                                                         
       PROCEDURE DIVISION USING  LINK-CALL-TYPE                         
                                ,LINK-REVENUE-MONTH                     
                                ,LINK-ACCOUNT-NO                        
                                ,LINK-BILL-UNIQUE-TS                    
                                ,LINK-REVENUE-ACTION.                   
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE           THRU  0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT        THRU  1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT       THRU  2000-EXIT.           
           PERFORM 2400-VLDT-NOTFOUND-RES    THRU  2400-EXIT.           
           PERFORM 9999-END-PROGRAM          THRU  9999-EXIT.           
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-INITIAL  THRU  0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-SUMMARY  THRU  0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-DETAILS  THRU  0100C-EXIT.         
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - INITIAL                     **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT-INITIAL.                                       
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04503_INITIAL'            
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04503_INITIAL')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04503_INITIAL
              (                                                    
                       RETURN_CODE            INT                   
                      ,REVENUE_MONTH          DECIMAL(6,0)              
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS-INITIAL THRU 8000A-EXIT     
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04503_INITIAL'    TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,REVENUE_MONTH                                    
               FROM #CSR04503_INITIAL                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*        FROM SESSION.CSR04503_INITIAL                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - SUMMARY                     **        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT-SUMMARY.                                       
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04503_SUMMARY'            
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04503_SUMMARY')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04503_SUMMARY
              (                                                    
                       RETURN_CODE            INT                   
                      ,ACCOUNT_NO             DECIMAL(13,0)             
                      ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,IC_NO                  SMALLINT                  
                      ,BILL_NO                INT                   
                      ,BILL_ITEM_TIMESTMP CHAR(26)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CUST_CT                INT                   
                      ,BILL_UNIQUE_TS CHAR(26)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,REVENUE_MONTH          DECIMAL(6,0)              
                      ,REV_MTH_ORIG_BILL      DECIMAL(6,0)              
                      ,NO_OF_CONS_DAYS        SMALLINT                  
                      ,USAGE_END_DATE CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CODE_REVENUE_CLASS CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,LOCAL_OFFICE CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,REV_DISTRICT_CD CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,BTU_FACTOR             DECIMAL(7,5)              
                      ,GAS_BASE_USE           DECIMAL(9,0)              
                      ,CALC_SOURCE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,REV_POST_STATUS_FL CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
A04581                ,TOTAL_READ_UNITS       DECIMAL(9,0)              
A04581                ,TOTAL_BILL_UNITS       DECIMAL(9,0)              
A04581                ,TOTAL_DEMAND_UNITS     DECIMAL(9,0)              
                      ,TOTAL_BILLED_AMT       DECIMAL(11,2)             
A04581                ,TOTAL_FRAN_TAX_AMT     DECIMAL(9,2)              
A04581                ,TOTAL_OTHR_TAX_AMT     DECIMAL(9,2)              
                      ,GL_INTRFCE_DB_ACCT     DECIMAL(7,4)              
                      ,GL_INTRFCE_CR_ACCT     DECIMAL(7,4)              
                      ,COMMENTS CHAR(250)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                 
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000B-DELETE-GTT-ROWS-SUMMARY THRU 8000B-EXIT     
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100B'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04503_SUMMARY'    TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,ACCOUNT_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,BILL_NO                                          
                      ,BILL_ITEM_TIMESTMP                               
                      ,CUST_CT                                          
                      ,BILL_UNIQUE_TS                                   
                      ,REVENUE_MONTH                                    
                      ,REV_MTH_ORIG_BILL                                
                      ,NO_OF_CONS_DAYS                                  
                      ,USAGE_END_DATE                                   
                      ,RATE_PLAN_NO                                     
                      ,CODE_REVENUE_CLASS                               
                      ,LOCAL_OFFICE                                     
                      ,REV_DISTRICT_CD                                  
                      ,BTU_FACTOR                                       
                      ,GAS_BASE_USE                                     
                      ,CALC_SOURCE_CD                                   
                      ,REV_POST_STATUS_FL                               
A04581                ,TOTAL_READ_UNITS                                 
A04581                ,TOTAL_BILL_UNITS                                 
A04581                ,TOTAL_DEMAND_UNITS                               
                      ,TOTAL_BILLED_AMT                                 
A04581                ,TOTAL_FRAN_TAX_AMT                               
A04581                ,TOTAL_OTHR_TAX_AMT                               
                      ,GL_INTRFCE_DB_ACCT                               
                      ,GL_INTRFCE_CR_ACCT                               
                      ,COMMENTS                                         
               FROM #CSR04503_SUMMARY                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,BILL_NO                                                  
MFA-TR*               ,BILL_ITEM_TIMESTMP                                       
MFA-TR*               ,CUST_CT                                                  
MFA-TR*               ,BILL_UNIQUE_TS                                           
MFA-TR*               ,REVENUE_MONTH                                            
MFA-TR*               ,REV_MTH_ORIG_BILL                                        
MFA-TR*               ,NO_OF_CONS_DAYS                                          
MFA-TR*               ,USAGE_END_DATE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,LOCAL_OFFICE                                             
MFA-TR*               ,REV_DISTRICT_CD                                          
MFA-TR*               ,BTU_FACTOR                                               
MFA-TR*               ,GAS_BASE_USE                                             
MFA-TR*               ,CALC_SOURCE_CD                                           
MFA-TR*               ,REV_POST_STATUS_FL                                       
MFA-TR*               ,TOTAL_READ_UNITS                                         
MFA-TR*               ,TOTAL_BILL_UNITS                                         
MFA-TR*               ,TOTAL_DEMAND_UNITS                                       
MFA-TR*               ,TOTAL_BILLED_AMT                                         
MFA-TR*               ,TOTAL_FRAN_TAX_AMT                                       
MFA-TR*               ,TOTAL_OTHR_TAX_AMT                                       
MFA-TR*               ,GL_INTRFCE_DB_ACCT                                       
MFA-TR*               ,GL_INTRFCE_CR_ACCT                                       
MFA-TR*               ,COMMENTS                                                 
MFA-TR*        FROM SESSION.CSR04503_SUMMARY                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE - DETAILS                     **        
      ******************************************************************        
      *                                                                         
       0100C-DECLARE-GTT-DETAILS.                                       
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04503_DETAILS'            
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04503_DETAILS')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04503_DETAILS
              (                                                    
                       RETURN_CODE            INT                   
                      ,RECORD_TYPE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,BILL_COMP_SEQ_NO       SMALLINT                  
                      ,CMPNT_ID_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,INSTR_USE_TYPE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CONSUMPT_TYPE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CODE_TIME_PERIOD       SMALLINT                  
                      ,RT_VERS_FROM_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,FACTOR_ID CHAR(09)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,FACTOR_BLOCK_NO        INT                   
                      ,READ_UNITS             DECIMAL(9,0)              
A04581                ,BILL_USAGE_UNITS       DECIMAL(9,0)              
A04581                ,BILL_DEMAND_UNITS      DECIMAL(9,0)              
                      ,FACTOR                 DECIMAL(15,6)             
                      ,FACTOR_AMT             DECIMAL(11,2)             
                      ,GL_ACCT_NO             DECIMAL(7,4)              
                      ,TAX_TYPE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,TAX_CNTRL_NO           SMALLINT                  
                      ,TAX_FROM_DT CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000C-DELETE-GTT-ROWS-DETAILS THRU 8000C-EXIT     
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100C'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04503_DETAILS'    TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,RECORD_TYPE                                      
                      ,BILL_COMP_SEQ_NO                                 
                      ,CMPNT_ID_CD                                      
                      ,INSTR_USE_TYPE_CD                                
                      ,CONSUMPT_TYPE_CD                                 
                      ,CODE_TIME_PERIOD                                 
                      ,RT_VERS_FROM_DT                                  
                      ,FACTOR_ID                                        
                      ,FACTOR_BLOCK_NO                                  
                      ,READ_UNITS                                       
A04581                ,BILL_USAGE_UNITS                                 
A04581                ,BILL_DEMAND_UNITS                                
                      ,FACTOR                                           
                      ,FACTOR_AMT                                       
                      ,GL_ACCT_NO                                       
                      ,TAX_TYPE                                         
                      ,TAX_CNTRL_NO                                     
                      ,TAX_FROM_DT                                      
               FROM #CSR04503_DETAILS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,RECORD_TYPE                                              
MFA-TR*               ,BILL_COMP_SEQ_NO                                         
MFA-TR*               ,CMPNT_ID_CD                                              
MFA-TR*               ,INSTR_USE_TYPE_CD                                        
MFA-TR*               ,CONSUMPT_TYPE_CD                                         
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,RT_VERS_FROM_DT                                          
MFA-TR*               ,FACTOR_ID                                                
MFA-TR*               ,FACTOR_BLOCK_NO                                          
MFA-TR*               ,READ_UNITS                                               
MFA-TR*               ,BILL_USAGE_UNITS                                         
MFA-TR*               ,BILL_DEMAND_UNITS                                        
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,FACTOR_AMT                                               
MFA-TR*               ,GL_ACCT_NO                                               
MFA-TR*               ,TAX_TYPE                                                 
MFA-TR*               ,TAX_CNTRL_NO                                             
MFA-TR*               ,TAX_FROM_DT                                              
MFA-TR*        FROM SESSION.CSR04503_DETAILS                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-CALL-TYPE            TO PARM-CALL-TYPE.            
      *                                                                         
           EVALUATE PARM-CALL-TYPE                                      
               WHEN 'I'                                                 
                    PERFORM 7000-GET-REPORTDATE-REV-MTH THRU 7000-EXIT  
                    MOVE PARM-REVENUE-MONTH-NUM TO RV-REVENUE-MONTH     
               WHEN 'S'                                                 
                    MOVE LINK-REVENUE-MONTH     TO PARM-REVENUE-MONTH   
                    MOVE PARM-REVENUE-MONTH-NUM TO RV-REVENUE-MONTH     
                    IF LINK-ACCOUNT-NO GREATER THAN SPACES              
                       MOVE LINK-ACCOUNT-NO     TO PARM-ACCOUNT-NO      
                       MOVE PARM-ACCOUNT-NO-NUM TO RV-ACCOUNT-NO        
                    END-IF                                              
               WHEN 'D'                                                 
                    MOVE LINK-ACCOUNT-NO        TO PARM-ACCOUNT-NO      
                    MOVE PARM-ACCOUNT-NO-NUM    TO RB-ACCOUNT-NO        
                                                   R7-ACCOUNT-NO        
                                                   R9-ACCOUNT-NO        
                    MOVE LINK-BILL-UNIQUE-TS    TO PARM-BILL-UNIQUE-TS  
                    MOVE PARM-BILL-UNIQUE-TS    TO RB-BILL-UNIQUE-TS    
                                                   R7-BILL-UNIQUE-TS    
                                                   R9-BILL-UNIQUE-TS    
           END-EVALUATE.                                                
      *                                                                         
           MOVE LINK-REVENUE-ACTION       TO PARM-REVENUE-ACTION.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** CALL TYPE = I (INITIAL)                                      **        
      ** POPULATE INITIAL RESULT SET WITH REV MONTH DROP DOWN LIST    **        
      ** USING "REPORT DATE" REVENUE MONTH.                           **        
      ** POPULATE SUMMARY RESULT SET USING "REPORT DATE" REV MONTH.   **        
      **                                                              **        
      ** CALL TYPE = S(SUMMARY)                                       **        
      **   CASE1:USE REVENUE MONTH ALONE TO GET SUMMARY DATA          **        
      **   CASE2:USE REVENUE MONTH & ACCOUNT NO TO GET SUMMARY DATA   **        
      **                                                              **        
      ** CALL TYPE = D(DETAILS):USE ACCOUNT NO & BILL UNIQUE TS TO    **        
      ** GET DETAIL RECORDS-BILL COMP ADJ, BILL BLOCK AND BILL TAX.   **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF PARM-CALL-TYPE = 'I'                                      
              PERFORM 2100-PROCESS-REV-ADJ-INITIAL  THRU 2100-EXIT      
           END-IF.                                                      
      *                                                                         
           EVALUATE TRUE                                                
             WHEN (PARM-CALL-TYPE = 'S' AND PARM-ACCOUNT-NO-NUM > 0)    
                  PERFORM 7130-OPEN-SUMMARY-REV-ACCT    THRU 7130-EXIT  
                  PERFORM 7140-FETCH-SUMMARY-REV-ACCT   THRU 7140-EXIT  
                  PERFORM 2200-PROCESS-REV-ADJ-SUMMARY  THRU 2200-EXIT  
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                  PERFORM 7150-CLOSE-SUMMARY-REV-ACCT   THRU 7150-EXIT  
             WHEN PARM-CALL-TYPE = 'S'                                  
             WHEN PARM-CALL-TYPE = 'I'                                  
                  PERFORM 7100-OPEN-SUMMARY-REV-CORR    THRU 7100-EXIT  
                  PERFORM 7110-FETCH-SUMMARY-REV-CORR   THRU 7110-EXIT  
                  PERFORM 2200-PROCESS-REV-ADJ-SUMMARY  THRU 2200-EXIT  
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                  PERFORM 7120-CLOSE-SUMMARY-REV-CORR   THRU 7120-EXIT  
             WHEN PARM-CALL-TYPE = 'D'                                  
                  PERFORM 7200-OPEN-REV-ADJ-DET-COMP    THRU 7200-EXIT  
                  PERFORM 7210-FETCH-REV-ADJ-DET-COMP   THRU 7210-EXIT  
                  PERFORM 2300-PROCESS-REV-ADJ-DET-COMP THRU 2300-EXIT  
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                  PERFORM 7220-CLOSE-REV-ADJ-DET-COMP   THRU 7220-EXIT  
                  PERFORM 7300-OPEN-REV-ADJ-DET-TAX     THRU 7300-EXIT  
                  PERFORM 7310-FETCH-REV-ADJ-DET-TAX    THRU 7310-EXIT  
                  PERFORM 2325-PROCESS-REV-ADJ-DET-TAX  THRU 2325-EXIT  
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                  PERFORM 7320-CLOSE-REV-ADJ-DET-TAX    THRU 7320-EXIT  
           END-EVALUATE.                                                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **POPULATE INITIAL RESULT SET WITH REVENUE MONTH DROP DOWN LIST **        
      **USING "REPORT DATE" REVENUE MONTH.                            **        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-REV-ADJ-INITIAL.                                    
      *                                                                         
           MOVE '2100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-INITIAL. 
      *                                                                         
           MOVE PARM-REVENUE-MONTH-NUM    TO S-LIST-OF-REV-MTH.         
           PERFORM 8100A-SEND-RESULT-INITIAL THRU 8100A-EXIT.           
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-INITIAL. 
      *                                                                         
           MOVE PARM-REVENUE-MONTH-NUM    TO WS-REV-MTH-TEMP.           
           COMPUTE WS-REV-MTH-TEMP-MM      = WS-REV-MTH-TEMP-MM + 1.    
           IF WS-REV-MTH-TEMP-MM > 12                                   
              COMPUTE WS-REV-MTH-TEMP-YYYY = WS-REV-MTH-TEMP-YYYY + 1   
              MOVE 01                     TO WS-REV-MTH-TEMP-MM         
           END-IF.                                                      
           MOVE WS-REV-MTH-TEMP           TO S-LIST-OF-REV-MTH.         
           PERFORM 8100A-SEND-RESULT-INITIAL THRU 8100A-EXIT.           
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **INITIAL      :USE REVENUE MONTH ALONE TO GET SUMMARY DATA     **        
      **SUMMARY-CASE1:USE REVENUE MONTH ALONE TO GET SUMMARY DATA     **        
      **SUMMARY-CASE2:USE REVENUE MONTH & ACCT NO TO GET SUMMARY DATA **        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-REV-ADJ-SUMMARY.                                    
      *                                                                         
           MOVE '2200'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-SUMMARY  
                                             2Z-GL-INTRFCE-DB-ACCT      
                                             2Z-GL-INTRFCE-CR-ACCT      
A04581                                       2Z-COMMENTS                
A04581                                       WS-TOTAL-FRAN-TAX-AMT      
A04581                                       WS-TOTAL-OTHR-TAX-AMT.     
      *                                                                         
           MOVE RV-BILL-UNIQUE-TS         TO RB-BILL-UNIQUE-TS          
                                             R7-BILL-UNIQUE-TS          
                                             R9-BILL-UNIQUE-TS          
                                             2Z-BILL-UNIQUE-TS.         
           MOVE RV-ACCOUNT-NO             TO R7-ACCOUNT-NO              
                                             RB-ACCOUNT-NO              
                                             R9-ACCOUNT-NO              
                                             2Z-ACCOUNT-NO.             
      *** GET TOTAL - READ UNITS,BILL UNITS,DEMAND UNITS & BILL AMOUNT          
           PERFORM 7160-GET-TOTAL-BILL-AMT     THRU  7160-EXIT.         
      *** GET TOTAL - FRANCHISE TAX AMOUNT & OTHER TAX AMOUNTS                  
           PERFORM 7170-GET-TOTAL-TAX-AMT      THRU  7170-EXIT.         
      *                                                                         
      *** GET REV_BILL_MISC_INFO DATA                                           
           PERFORM 7180-GET-REV-BILL-MISC-INFO THRU  7180-EXIT.         
      *                                                                         
           PERFORM 2500-MOVE-RESULT-SUMMARY    THRU  2500-EXIT.         
      *                                                                         
           INITIALIZE                        WS-DATE-NULL-1             
                                             WS-DATE-NULL-2             
                                             WS-DATE-NULL-3.            
      *                                                                         
           IF PARM-CALL-TYPE = 'S' AND PARM-ACCOUNT-NO-NUM > 0          
              PERFORM 7140-FETCH-SUMMARY-REV-ACCT  THRU  7140-EXIT      
           ELSE                                                         
              PERFORM 7110-FETCH-SUMMARY-REV-CORR  THRU  7110-EXIT      
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DETAILS DATA: POPULATE REV BILL COMP ADJ DATA                **        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-REV-ADJ-DET-COMP.                                   
      *                                                                         
           MOVE '2300'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-DETAILS. 
      *                                                                         
           PERFORM 2550-MOVE-RESULT-DET-COMP    THRU  2550-EXIT.        
      *                                                                         
           INITIALIZE                        WS-DATE-NULL-4             
                                             WS-DATE-NULL-5.            
      *                                                                         
           PERFORM 7210-FETCH-REV-ADJ-DET-COMP  THRU  7210-EXIT.        
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DETAILS DATA: POPULATE REV BILL COMP ADJ DATA                **        
      ******************************************************************        
      *                                                                         
       2325-PROCESS-REV-ADJ-DET-TAX.                                    
      *                                                                         
           MOVE '2325'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS-DETAILS. 
      *                                                                         
           PERFORM 2560-MOVE-RESULT-DET-TAX    THRU  2560-EXIT.         
      *                                                                         
           PERFORM 7310-FETCH-REV-ADJ-DET-TAX  THRU  7310-EXIT.         
      *                                                                         
       2325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** IF ROW COUNT = 0 IN A RESULT SET, SEND DUMMY RESULT SET      **        
      ******************************************************************        
      *                                                                         
       2400-VLDT-NOTFOUND-RES.                                          
      *                                                                         
           MOVE '2400'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           IF CTR-ROWS-INITIAL = 0                                      
              INITIALIZE                     GTT-RETURN-FIELDS-INITIAL  
              MOVE 100                    TO S-RETURN-CODE-INIT         
              PERFORM 8100A-SEND-RESULT-INITIAL THRU 8100A-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-SUMMARY = 0                                      
              INITIALIZE                     GTT-RETURN-FIELDS-SUMMARY  
              MOVE 100                    TO S-RETURN-CODE-SUMMARY      
              PERFORM 8100B-SEND-RESULT-SUMMARY THRU 8100B-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-DETAILS = 0                                      
              INITIALIZE                     GTT-RETURN-FIELDS-DETAILS  
              MOVE 100                    TO S-RETURN-CODE-DET          
              PERFORM 8100C-SEND-RESULT-DETAILS THRU 8100C-EXIT         
           END-IF.                                                      
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - SUMMARY                                    **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT-SUMMARY.                                        
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE RV-ACCOUNT-NO             TO S-ACCOUNT-NO.              
           MOVE RV-CODE-UTIL-TYPE         TO S-CODE-UTIL-TYPE.          
           MOVE RV-IC-NO                  TO S-IC-NO.                   
           MOVE RV-BILL-NO                TO S-BILL-NO.                 
           MOVE RV-BILL-ITEM-TIMESTMP     TO S-BILL-ITEM-TIMESTMP.      
           MOVE RV-CUST-CT                TO S-CUST-CT.                 
           MOVE RV-BILL-UNIQUE-TS         TO S-BILL-UNIQUE-TS.          
           MOVE RV-REVENUE-MONTH          TO S-REVENUE-MONTH.           
           MOVE RV-REV-MTH-ORIG-BILL      TO S-REV-MTH-ORIG-BILL.       
           MOVE RV-NO-OF-CONS-DAYS        TO S-NO-OF-CONS-DAYS.         
           MOVE RV-USAGE-END-DATE         TO S-USAGE-END-DATE.          
           MOVE RV-RATE-PLAN-NO           TO S-RATE-PLAN-NO.            
           MOVE RV-CODE-REVENUE-CLASS     TO S-CODE-REVENUE-CLASS.      
           MOVE RV-LOCAL-OFFICE           TO S-LOCAL-OFFICE.            
           MOVE RV-REV-DISTRICT-CD        TO S-REV-DISTRICT-CD.         
           MOVE RV-BTU-FACTOR             TO S-BTU-FACTOR.              
           MOVE RV-GAS-BASE-USE           TO S-GAS-BASE-USE.            
           MOVE RV-CALC-SOURCE-CD         TO S-CALC-SOURCE-CD.          
           MOVE RV-REV-POST-STATUS-FL     TO S-REV-POST-STATUS-FL.      
A04581     MOVE RB-READ-UNITS             TO S-TOTAL-READ-UNITS.        
A04581     MOVE RB-BILL-USAGE-UNITS       TO S-TOTAL-BILL-UNITS.        
A04581     MOVE RB-BILL-DEMAND-UNITS      TO S-TOTAL-DEMAND-UNITS.      
           MOVE RB-BILLED-AMT             TO S-TOTAL-BILLED-AMT.        
A04581     MOVE WS-TOTAL-FRAN-TAX-AMT     TO S-TOTAL-FRAN-TAX-AMT.      
A04581     MOVE WS-TOTAL-OTHR-TAX-AMT     TO S-TOTAL-OTHR-TAX-AMT.      
           MOVE 2Z-GL-INTRFCE-DB-ACCT     TO S-GL-INTRFCE-DB-ACCT.      
           MOVE 2Z-GL-INTRFCE-CR-ACCT     TO S-GL-INTRFCE-CR-ACCT.      
           MOVE 2Z-COMMENTS-TEXT          TO S-COMMENTS.                
      *                                                                         
      *** R-Reverse All, P-Partial Reverse with Update                          
           IF PARM-REVENUE-ACTION = 'R' OR 'P'                          
              COMPUTE S-CUST-CT = S-CUST-CT * -1                        
           END-IF.                                                      
      *                                                                         
           PERFORM 8100B-SEND-RESULT-SUMMARY THRU 8100B-EXIT.           
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - COMP ADJ DETAILS                           **        
      ******************************************************************        
      *                                                                         
       2550-MOVE-RESULT-DET-COMP.                                       
      *                                                                         
           MOVE '2550'                    TO ACTIVE-PARAGRAPH.          
      *** RECORD TYPE = BILL COMP ADJ                                           
           MOVE 'C'                       TO S-RECORD-TYPE.             
      *                                                                         
           MOVE RB-BILL-COMP-SEQ-NO       TO S-BILL-COMP-SEQ-NO.        
           MOVE RB-CMPNT-ID-CD            TO S-CMPNT-ID-CD.             
           MOVE RB-INSTR-USE-TYPE-CD      TO S-INSTR-USE-TYPE-CD.       
           MOVE RB-CONSUMPT-TYPE-CD       TO S-CONSUMPT-TYPE-CD.        
           MOVE RB-CODE-TIME-PERIOD       TO S-CODE-TIME-PERIOD.        
           MOVE RB-RT-VERS-FROM-DT        TO S-RT-VERS-FROM-DT.         
           MOVE RB-FACTOR-ID              TO S-FACTOR-ID.               
           MOVE RB-FACTOR-BLOCK-NO        TO S-FACTOR-BLOCK-NO.         
           MOVE RB-READ-UNITS             TO S-READ-UNITS.              
A04581     MOVE RB-BILL-USAGE-UNITS       TO S-BILL-USAGE-UNITS.        
A04581     MOVE RB-BILL-DEMAND-UNITS      TO S-BILL-DEMAND-UNITS.       
           MOVE RB-FACTOR                 TO S-FACTOR.                  
           MOVE RB-BILLED-AMT             TO S-FACTOR-AMT.              
           MOVE RB-GL-ACCT-NO             TO S-GL-ACCT-NO.              
      *                                                                         
           INITIALIZE                        S-TAX-TYPE                 
                                             S-TAX-CNTRL-NO             
                                             S-TAX-FROM-DT.             
      *                                                                         
      *** R-Reverse All, P-Partial Reverse with Update                          
           IF PARM-REVENUE-ACTION   = 'R' OR 'P'                        
              COMPUTE S-READ-UNITS  =  S-READ-UNITS * -1                
A04581        COMPUTE S-BILL-USAGE-UNITS  = S-BILL-USAGE-UNITS  * -1    
A04581        COMPUTE S-BILL-DEMAND-UNITS = S-BILL-DEMAND-UNITS * -1    
              COMPUTE S-FACTOR-AMT  =  S-FACTOR-AMT * -1                
           END-IF.                                                      
      *                                                                         
           PERFORM 8100C-SEND-RESULT-DETAILS THRU 8100C-EXIT.           
      *                                                                         
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET - TAX DETAILS                                **        
      ******************************************************************        
      *                                                                         
       2560-MOVE-RESULT-DET-TAX.                                        
      *                                                                         
           MOVE '2560'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
      *** RECORD TYPE = BILL TAX DATA                                           
           MOVE 'T'                       TO S-RECORD-TYPE.             
      *                                                                         
           INITIALIZE                        S-BILL-COMP-SEQ-NO         
                                             S-CMPNT-ID-CD              
                                             S-INSTR-USE-TYPE-CD        
                                             S-CONSUMPT-TYPE-CD         
                                             S-CODE-TIME-PERIOD         
                                             S-RT-VERS-FROM-DT          
                                             S-FACTOR-BLOCK-NO          
                                             S-READ-UNITS               
A04581                                       S-BILL-USAGE-UNITS         
A04581                                       S-BILL-DEMAND-UNITS        
                                             S-FACTOR.                  
      *                                                                         
           IF R9-FACTOR-ID GREATER THAN SPACES                          
              MOVE R9-FACTOR-ID           TO S-FACTOR-ID                
           ELSE                                                         
              EVALUATE R9-TAX-TYPE                                      
                  WHEN 'A'                                              
                       MOVE 'State Tax'   TO S-FACTOR-ID                
                  WHEN 'B'                                              
                       MOVE 'Fran Tax'    TO S-FACTOR-ID                
              END-EVALUATE                                              
           END-IF.                                                      
      *                                                                         
           MOVE R9-TAX-GL-ACCT-NO         TO S-GL-ACCT-NO.              
           MOVE R9-TAX-AMT                TO S-FACTOR-AMT.              
           MOVE R9-TAX-TYPE               TO S-TAX-TYPE.                
           MOVE R9-TAX-CNTRL-NO           TO S-TAX-CNTRL-NO.            
           MOVE R9-TAX-FROM-DT            TO S-TAX-FROM-DT.             
      *                                                                         
      *** R-Reverse All, P-Partial Reverse with Update                          
           IF PARM-REVENUE-ACTION   = 'R' OR 'P'                        
              COMPUTE S-FACTOR-AMT  =  S-FACTOR-AMT * -1                
           END-IF.                                                      
      *                                                                         
           PERFORM 8100C-SEND-RESULT-DETAILS THRU 8100C-EXIT.           
      *                                                                         
       2560-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET REPORT DATE - REVENUE MONTH                             **        
      ******************************************************************        
      *                                                                         
       7000-GET-REPORTDATE-REV-MTH.                                     
      *                                                                         
           EXEC SQL                                                     
             SELECT  CIS.SUBSTR3(G6.PARM_DATA,13,6)                          
               INTO  :PARM-REVENUE-MONTH                                
               FROM  CSS_JOB_PARM   G6 WITH(READUNCOMMITTED)                    
              WHERE  G6.PROGRAM_NAME  =  'REPORTDATE'                   
                AND  G6.COMPANY_NO    =  '01'                           
                AND  G6.CMND_CODE     =  'DATE'                         
                AND  G6.SEQ_NO        =  1                              
                AND  G6.STATUS        =  'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  SUBSTR(G6.PARM_DATA,13,6)                                  
MFA-TR*        INTO  :PARM-REVENUE-MONTH                                        
MFA-TR*        FROM  CSS_JOB_PARM   G6                                          
MFA-TR*       WHERE  G6.PROGRAM_NAME  =  'REPORTDATE'                           
MFA-TR*         AND  G6.COMPANY_NO    =  '01'                                   
MFA-TR*         AND  G6.CMND_CODE     =  'DATE'                                 
MFA-TR*         AND  G6.SEQ_NO        =  1                                      
MFA-TR*         AND  G6.STATUS        =  'A'                                    
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN SUMMARY_REV_CORR CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-SUMMARY-REV-CORR.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN SUMMARY_REV_CORR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SUMMARY_REV_CORR CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7110-FETCH-SUMMARY-REV-CORR.                                     
      *                                                                         
           EXEC SQL                                                     
              FETCH SUMMARY_REV_CORR                                    
               INTO :RV-ACCOUNT-NO                                      
                   ,:RV-CODE-UTIL-TYPE                                  
                   ,:RV-IC-NO                                           
                   ,:RV-BILL-NO                                         
                   ,:RV-BILL-ITEM-TIMESTMP                              
                   ,:RV-CUST-CT                                         
                   ,:RV-BILL-UNIQUE-TS                                  
                   ,:RV-REVENUE-MONTH                                   
                   ,:RV-REV-MTH-ORIG-BILL                               
                   ,:RV-DATE-BILLED :WS-DATE-NULL-1                      
                   ,:RV-DATE-ORIG-BILL :WS-DATE-NULL-2                   
                   ,:RV-NO-OF-CONS-DAYS                                 
                   ,:RV-USAGE-END-DATE :WS-DATE-NULL-3                   
                   ,:RV-RATE-PLAN-NO                                    
                   ,:RV-CODE-REVENUE-CLASS                              
                   ,:RV-LOCAL-OFFICE                                    
                   ,:RV-REV-DISTRICT-CD                                 
                   ,:RV-BTU-FACTOR                                      
                   ,:RV-GAS-BASE-USE                                    
                   ,:RV-CALC-SOURCE-CD                                  
                   ,:RV-REV-POST-STATUS-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-NULL-1 = WS-YES-NULL                           
                 MOVE SPACES                  TO RV-DATE-BILLED         
              END-IF                                                    
              IF WS-DATE-NULL-2 = WS-YES-NULL                           
                 MOVE SPACES                  TO RV-DATE-ORIG-BILL      
              END-IF                                                    
              IF WS-DATE-NULL-3 = WS-YES-NULL                           
                 MOVE SPACES                  TO RV-USAGE-END-DATE      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SUMMARY_REV_CORR CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7120-CLOSE-SUMMARY-REV-CORR.                                     
      *                                                                         
           EXEC SQL                                                     
              CLOSE SUMMARY_REV_CORR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN SUMMARY_REV_ACCT CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7130-OPEN-SUMMARY-REV-ACCT.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN SUMMARY_REV_ACCT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7130'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH SUMMARY_REV_ACCT CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7140-FETCH-SUMMARY-REV-ACCT.                                     
      *                                                                         
           EXEC SQL                                                     
              FETCH SUMMARY_REV_ACCT                                    
               INTO :RV-ACCOUNT-NO                                      
                   ,:RV-CODE-UTIL-TYPE                                  
                   ,:RV-IC-NO                                           
                   ,:RV-BILL-NO                                         
                   ,:RV-BILL-ITEM-TIMESTMP                              
                   ,:RV-CUST-CT                                         
                   ,:RV-BILL-UNIQUE-TS                                  
                   ,:RV-REVENUE-MONTH                                   
                   ,:RV-REV-MTH-ORIG-BILL                               
                   ,:RV-DATE-BILLED :WS-DATE-NULL-1                      
                   ,:RV-DATE-ORIG-BILL :WS-DATE-NULL-2                   
                   ,:RV-NO-OF-CONS-DAYS                                 
                   ,:RV-USAGE-END-DATE :WS-DATE-NULL-3                   
                   ,:RV-RATE-PLAN-NO                                    
                   ,:RV-CODE-REVENUE-CLASS                              
                   ,:RV-LOCAL-OFFICE                                    
                   ,:RV-REV-DISTRICT-CD                                 
                   ,:RV-BTU-FACTOR                                      
                   ,:RV-GAS-BASE-USE                                    
                   ,:RV-CALC-SOURCE-CD                                  
                   ,:RV-REV-POST-STATUS-FL                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-NULL-1 = WS-YES-NULL                           
                 MOVE SPACES                  TO RV-DATE-BILLED         
              END-IF                                                    
              IF WS-DATE-NULL-2 = WS-YES-NULL                           
                 MOVE SPACES                  TO RV-DATE-ORIG-BILL      
              END-IF                                                    
              IF WS-DATE-NULL-3 = WS-YES-NULL                           
                 MOVE SPACES                  TO RV-USAGE-END-DATE      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7140'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE SUMMARY_REV_ACCT CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7150-CLOSE-SUMMARY-REV-ACCT.                                     
      *                                                                         
           EXEC SQL                                                     
              CLOSE SUMMARY_REV_ACCT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILLING_DET'          TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET TOTAL BILL AMOUNT                                       **        
      ******************************************************************        
      *                                                                         
       7160-GET-TOTAL-BILL-AMT.                                         
      *                                                                         
           EXEC SQL                                                     
             SELECT  COALESCE(SUM(RB.BILLED_AMT),0)                       
A04581              ,COALESCE(SUM(CASE WHEN RB.CONSUMPT_TYPE_CD = 'D'     
A04581                          THEN (RB.READ_UNITS * 10)               
A04581                          WHEN RB.CONSUMPT_TYPE_CD IN ('B','C')   
A04581                          THEN RB.READ_UNITS                      
A04581                          ELSE 0 END),0)                          
A04581              ,COALESCE(SUM(CASE WHEN RB.CONSUMPT_TYPE_CD = 'D'     
A04581                          THEN (RB.BILL_USAGE_UNITS * 10)         
A04581                          WHEN RB.CONSUMPT_TYPE_CD IN ('B','C')   
A04581                          THEN RB.BILL_USAGE_UNITS                
A04581                          ELSE 0 END),0)                          
A04581              ,COALESCE(SUM(RB.BILL_DEMAND_UNITS),0)                
               INTO  :RB-BILLED-AMT                                     
A04581              ,:RB-READ-UNITS                                     
A04581              ,:RB-BILL-USAGE-UNITS                               
A04581              ,:RB-BILL-DEMAND-UNITS                              
               FROM  REV_BILL_COMP_ADJ   RB WITH(READUNCOMMITTED)               
              WHERE  RB.BILL_UNIQUE_TS    =  CIS.CHAR2TIMESTAMP(
                                                     :RB-BILL-UNIQUE-TS
              )         
                AND  RB.UTILITY_REV_CD    =  'U'                        
GOPI************AND  RB.ACCOUNT_NO        =  :RB-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(SUM(RB.BILLED_AMT),0)                               
MFA-TR*             ,IFNULL(SUM(CASE WHEN RB.CONSUMPT_TYPE_CD = 'D'             
MFA-TR*                         THEN (RB.READ_UNITS * 10)                       
MFA-TR*                         WHEN RB.CONSUMPT_TYPE_CD IN ('B','C')           
MFA-TR*                         THEN RB.READ_UNITS                              
MFA-TR*                         ELSE 0 END),0)                                  
MFA-TR*             ,IFNULL(SUM(CASE WHEN RB.CONSUMPT_TYPE_CD = 'D'             
MFA-TR*                         THEN (RB.BILL_USAGE_UNITS * 10)                 
MFA-TR*                         WHEN RB.CONSUMPT_TYPE_CD IN ('B','C')           
MFA-TR*                         THEN RB.BILL_USAGE_UNITS                        
MFA-TR*                         ELSE 0 END),0)                                  
MFA-TR*             ,IFNULL(SUM(RB.BILL_DEMAND_UNITS),0)                        
MFA-TR*        INTO  :RB-BILLED-AMT                                             
MFA-TR*             ,:RB-READ-UNITS                                             
MFA-TR*             ,:RB-BILL-USAGE-UNITS                                       
MFA-TR*             ,:RB-BILL-DEMAND-UNITS                                      
MFA-TR*        FROM  REV_BILL_COMP_ADJ   RB                                     
MFA-TR*       WHERE  RB.BILL_UNIQUE_TS    =  :RB-BILL-UNIQUE-TS                 
MFA-TR*         AND  RB.UTILITY_REV_CD    =  'U'                                
MFA-TR**********AND  RB.ACCOUNT_NO        =  :RB-ACCOUNT-NO                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7160                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7160'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE RB-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET TOTAL TAX AMOUNT                                        **        
      ******************************************************************        
      *                                                                         
       7170-GET-TOTAL-TAX-AMT.                                          
      *                                                                         
           EXEC SQL                                                     
A04581       SELECT  COALESCE(SUM(CASE WHEN (R9.TAX_TYPE     = 'B'        
A04581                                AND  R9.TAX_CNTRL_NO = 20)        
A04581               THEN R9.TAX_AMT ELSE 0 END),0)                     
A04581              ,COALESCE(SUM(CASE WHEN (R9.TAX_TYPE     = 'B'        
A04581                                AND  R9.TAX_CNTRL_NO = 20)        
A04581               THEN 0 ELSE R9.TAX_AMT END),0)                     
A04581         INTO  :WS-TOTAL-FRAN-TAX-AMT                             
A04581              ,:WS-TOTAL-OTHR-TAX-AMT                             
               FROM  REV_BILL_TAX        R9 WITH(READUNCOMMITTED)               
              WHERE  R9.BILL_UNIQUE_TS    =  CIS.CHAR2TIMESTAMP(
                                                     :R9-BILL-UNIQUE-TS
              )         
GOPI************AND  R9.ACCOUNT_NO        =  :R9-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  IFNULL(SUM(CASE WHEN (R9.TAX_TYPE     = 'B'                
MFA-TR*                               AND  R9.TAX_CNTRL_NO = 20)                
MFA-TR*              THEN R9.TAX_AMT ELSE 0 END),0)                             
MFA-TR*             ,IFNULL(SUM(CASE WHEN (R9.TAX_TYPE     = 'B'                
MFA-TR*                               AND  R9.TAX_CNTRL_NO = 20)                
MFA-TR*              THEN 0 ELSE R9.TAX_AMT END),0)                             
MFA-TR*        INTO  :WS-TOTAL-FRAN-TAX-AMT                                     
MFA-TR*             ,:WS-TOTAL-OTHR-TAX-AMT                                     
MFA-TR*        FROM  REV_BILL_TAX        R9                                     
MFA-TR*       WHERE  R9.BILL_UNIQUE_TS    =  :R9-BILL-UNIQUE-TS                 
MFA-TR**********AND  R9.ACCOUNT_NO        =  :R9-ACCOUNT-NO                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7170                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7170'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7170-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  GET REV_BILL_MISC_INFO DATA                                 **        
      ******************************************************************        
      *                                                                         
       7180-GET-REV-BILL-MISC-INFO.                                     
      *                                                                         
           EXEC SQL                                                     
             SELECT  [2Z].GL_INTRFCE_DB_ACCT                              
                    ,[2Z].GL_INTRFCE_CR_ACCT                              
                    ,[2Z].COMMENTS                                        
               INTO  :2Z-GL-INTRFCE-DB-ACCT                             
                    ,:2Z-GL-INTRFCE-CR-ACCT                             
                    ,:2Z-COMMENTS                                       
               FROM  REV_BILL_MISC_INFO  [2Z] WITH(READUNCOMMITTED)             
              WHERE  [2Z].BILL_UNIQUE_TS    =  CIS.CHAR2TIMESTAMP(
                                                     :2Z-BILL-UNIQUE-TS
              )         
GOPI************AND  2Z.ACCOUNT_NO        =  :2Z-ACCOUNT-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  2Z.GL_INTRFCE_DB_ACCT                                      
MFA-TR*             ,2Z.GL_INTRFCE_CR_ACCT                                      
MFA-TR*             ,2Z.COMMENTS                                                
MFA-TR*        INTO  :2Z-GL-INTRFCE-DB-ACCT                                     
MFA-TR*             ,:2Z-GL-INTRFCE-CR-ACCT                                     
MFA-TR*             ,:2Z-COMMENTS                                               
MFA-TR*        FROM  REV_BILL_MISC_INFO  2Z                                     
MFA-TR*       WHERE  2Z.BILL_UNIQUE_TS    =  :2Z-BILL-UNIQUE-TS                 
MFA-TR**********AND  2Z.ACCOUNT_NO        =  :2Z-ACCOUNT-NO                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7180                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7180'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_MISC_INFO'       TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE 2Z-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE 2Z-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7180-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN REV_ADJ_DET_COMP CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7200-OPEN-REV-ADJ-DET-COMP.                                      
      *                                                                         
           EXEC SQL                                                     
               OPEN REV_ADJ_DET_COMP                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE RB-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH REV_ADJ_DET_COMP CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7210-FETCH-REV-ADJ-DET-COMP.                                     
      *                                                                         
           EXEC SQL                                                     
              FETCH REV_ADJ_DET_COMP                                    
               INTO :RB-BILL-COMP-SEQ-NO                                
                   ,:RB-CMPNT-ID-CD                                     
                   ,:RB-INSTR-USE-TYPE-CD                               
                   ,:RB-CONSUMPT-TYPE-CD                                
                   ,:RB-CODE-TIME-PERIOD                                
                   ,:RB-CODE-SEASON                                     
                   ,:RB-RT-VERS-FROM-DT :WS-DATE-NULL-4                  
                   ,:RB-RT-VERS-PRO-CD                                  
                   ,:RB-FACTOR-ID                                       
                   ,:RB-FACTOR-BLOCK-NO                                 
                   ,:RB-RT-FCT-FROM-DT :WS-DATE-NULL-5                   
                   ,:RB-RT-FCT-PRO-CD                                   
                   ,:RB-READ-UNITS                                      
A04581             ,:RB-BILL-USAGE-UNITS                                
A04581             ,:RB-BILL-DEMAND-UNITS                               
                   ,:RB-FACTOR                                          
                   ,:RB-BILLED-AMT                                      
                   ,:RB-UTILITY-REV-CD                                  
                   ,:RB-COMP-ADJ-CD                                     
                   ,:RB-GL-ACCT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-DATE-NULL-4 = WS-YES-NULL                           
                 MOVE SPACES                  TO RB-RT-VERS-FROM-DT     
              END-IF                                                    
              IF WS-DATE-NULL-5 = WS-YES-NULL                           
                 MOVE SPACES                  TO RB-RT-FCT-FROM-DT      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7210'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE RB-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE REV_ADJ_DET_COMP CURSOR                               **        
      ******************************************************************        
      *                                                                         
       7220-CLOSE-REV-ADJ-DET-COMP.                                     
      *                                                                         
           EXEC SQL                                                     
              CLOSE REV_ADJ_DET_COMP                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_COMP_ADJ'        TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE RB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE RB-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN REV_ADJ_DET_TAX CURSOR                                 **        
      ******************************************************************        
      *                                                                         
       7300-OPEN-REV-ADJ-DET-TAX.                                       
      *                                                                         
           EXEC SQL                                                     
               OPEN REV_ADJ_DET_TAX                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH REV_ADJ_DET_TAX CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7310-FETCH-REV-ADJ-DET-TAX.                                      
      *                                                                         
           EXEC SQL                                                     
              FETCH REV_ADJ_DET_TAX                                     
               INTO :R9-TAX-TYPE                                        
                   ,:R9-TAX-CNTRL-NO                                    
                   ,:R9-TAX-FROM-DT                                     
                   ,:R9-FACTOR-ID                                       
                   ,:R9-TAX-GL-ACCT-NO                                  
                   ,:R9-TAX-AMT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7310'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE REV_ADJ_DET_TAX CURSOR                                **        
      ******************************************************************        
      *                                                                         
       7320-CLOSE-REV-ADJ-DET-TAX.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE REV_ADJ_DET_TAX                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'REV_BILL_TAX'             TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-3        
              MOVE PARM-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE R9-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
              MOVE R9-BILL-UNIQUE-TS          TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - INITIAL                               **        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS-INITIAL.                                   
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04503_INITIAL'             
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04503_INITIAL                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04503_INITIAL                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04503_INITIAL'       TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - SUMMARY                               **        
      ******************************************************************        
      *                                                                         
       8000B-DELETE-GTT-ROWS-SUMMARY.                                   
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04503_SUMMARY'             
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04503_SUMMARY                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04503_SUMMARY                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000B'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04503_SUMMARY'       TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE - DETAILS                               **        
      ******************************************************************        
      *                                                                         
       8000C-DELETE-GTT-ROWS-DETAILS.                                   
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04503_DETAILS'             
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04503_DETAILS                    
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04503_DETAILS                            
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               CONTINUE                                                 
            ELSE                                                        
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000C'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04503_DETAILS'       TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000C-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - INITIAL                                    **        
      ******************************************************************        
      *                                                                         
       8100A-SEND-RESULT-INITIAL.                                       
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04503_INITIAL                       
             (                                                          
              RETURN_CODE                                               
             ,REVENUE_MONTH                                             
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-INIT                                       
             ,:S-LIST-OF-REV-MTH                                        
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04503_INITIAL                               
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,REVENUE_MONTH                                                     
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-INIT                                               
MFA-TR*      ,:S-LIST-OF-REV-MTH                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100A'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04503_INITIAL'         TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS-INITIAL.      
      *                                                                         
       8100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - SUMMARY                                    **        
      ******************************************************************        
      *                                                                         
       8100B-SEND-RESULT-SUMMARY.                                       
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04503_SUMMARY                       
             (                                                          
              RETURN_CODE                                               
             ,ACCOUNT_NO                                                
             ,CODE_UTIL_TYPE                                            
             ,IC_NO                                                     
             ,BILL_NO                                                   
             ,BILL_ITEM_TIMESTMP                                        
             ,CUST_CT                                                   
             ,BILL_UNIQUE_TS                                            
             ,REVENUE_MONTH                                             
             ,REV_MTH_ORIG_BILL                                         
             ,NO_OF_CONS_DAYS                                           
             ,USAGE_END_DATE                                            
             ,RATE_PLAN_NO                                              
             ,CODE_REVENUE_CLASS                                        
             ,LOCAL_OFFICE                                              
             ,REV_DISTRICT_CD                                           
             ,BTU_FACTOR                                                
             ,GAS_BASE_USE                                              
             ,CALC_SOURCE_CD                                            
             ,REV_POST_STATUS_FL                                        
A04581       ,TOTAL_READ_UNITS                                          
A04581       ,TOTAL_BILL_UNITS                                          
A04581       ,TOTAL_DEMAND_UNITS                                        
             ,TOTAL_BILLED_AMT                                          
A04581       ,TOTAL_FRAN_TAX_AMT                                        
A04581       ,TOTAL_OTHR_TAX_AMT                                        
             ,GL_INTRFCE_DB_ACCT                                        
             ,GL_INTRFCE_CR_ACCT                                        
             ,COMMENTS                                                  
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-SUMMARY                                    
             ,:S-ACCOUNT-NO                                             
             ,:S-CODE-UTIL-TYPE                                         
             ,:S-IC-NO                                                  
             ,:S-BILL-NO                                                
             ,:S-BILL-ITEM-TIMESTMP                                     
             ,:S-CUST-CT                                                
             ,:S-BILL-UNIQUE-TS                                         
             ,:S-REVENUE-MONTH                                          
             ,:S-REV-MTH-ORIG-BILL                                      
             ,:S-NO-OF-CONS-DAYS                                        
             ,:S-USAGE-END-DATE                                         
             ,:S-RATE-PLAN-NO                                           
             ,:S-CODE-REVENUE-CLASS                                     
             ,:S-LOCAL-OFFICE                                           
             ,:S-REV-DISTRICT-CD                                        
             ,:S-BTU-FACTOR                                             
             ,:S-GAS-BASE-USE                                           
             ,:S-CALC-SOURCE-CD                                         
             ,:S-REV-POST-STATUS-FL                                     
A04581       ,:S-TOTAL-READ-UNITS                                       
A04581       ,:S-TOTAL-BILL-UNITS                                       
A04581       ,:S-TOTAL-DEMAND-UNITS                                     
             ,:S-TOTAL-BILLED-AMT                                       
A04581       ,:S-TOTAL-FRAN-TAX-AMT                                     
A04581       ,:S-TOTAL-OTHR-TAX-AMT                                     
             ,:S-GL-INTRFCE-DB-ACCT                                     
             ,:S-GL-INTRFCE-CR-ACCT                                     
             ,:S-COMMENTS                                               
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04503_SUMMARY                               
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,CODE_UTIL_TYPE                                                    
MFA-TR*      ,IC_NO                                                             
MFA-TR*      ,BILL_NO                                                           
MFA-TR*      ,BILL_ITEM_TIMESTMP                                                
MFA-TR*      ,CUST_CT                                                           
MFA-TR*      ,BILL_UNIQUE_TS                                                    
MFA-TR*      ,REVENUE_MONTH                                                     
MFA-TR*      ,REV_MTH_ORIG_BILL                                                 
MFA-TR*      ,NO_OF_CONS_DAYS                                                   
MFA-TR*      ,USAGE_END_DATE                                                    
MFA-TR*      ,RATE_PLAN_NO                                                      
MFA-TR*      ,CODE_REVENUE_CLASS                                                
MFA-TR*      ,LOCAL_OFFICE                                                      
MFA-TR*      ,REV_DISTRICT_CD                                                   
MFA-TR*      ,BTU_FACTOR                                                        
MFA-TR*      ,GAS_BASE_USE                                                      
MFA-TR*      ,CALC_SOURCE_CD                                                    
MFA-TR*      ,REV_POST_STATUS_FL                                                
MFA-TR*      ,TOTAL_READ_UNITS                                                  
MFA-TR*      ,TOTAL_BILL_UNITS                                                  
MFA-TR*      ,TOTAL_DEMAND_UNITS                                                
MFA-TR*      ,TOTAL_BILLED_AMT                                                  
MFA-TR*      ,TOTAL_FRAN_TAX_AMT                                                
MFA-TR*      ,TOTAL_OTHR_TAX_AMT                                                
MFA-TR*      ,GL_INTRFCE_DB_ACCT                                                
MFA-TR*      ,GL_INTRFCE_CR_ACCT                                                
MFA-TR*      ,COMMENTS                                                          
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-SUMMARY                                            
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-CODE-UTIL-TYPE                                                 
MFA-TR*      ,:S-IC-NO                                                          
MFA-TR*      ,:S-BILL-NO                                                        
MFA-TR*      ,:S-BILL-ITEM-TIMESTMP                                             
MFA-TR*      ,:S-CUST-CT                                                        
MFA-TR*      ,:S-BILL-UNIQUE-TS                                                 
MFA-TR*      ,:S-REVENUE-MONTH                                                  
MFA-TR*      ,:S-REV-MTH-ORIG-BILL                                              
MFA-TR*      ,:S-NO-OF-CONS-DAYS                                                
MFA-TR*      ,:S-USAGE-END-DATE                                                 
MFA-TR*      ,:S-RATE-PLAN-NO                                                   
MFA-TR*      ,:S-CODE-REVENUE-CLASS                                             
MFA-TR*      ,:S-LOCAL-OFFICE                                                   
MFA-TR*      ,:S-REV-DISTRICT-CD                                                
MFA-TR*      ,:S-BTU-FACTOR                                                     
MFA-TR*      ,:S-GAS-BASE-USE                                                   
MFA-TR*      ,:S-CALC-SOURCE-CD                                                 
MFA-TR*      ,:S-REV-POST-STATUS-FL                                             
MFA-TR*      ,:S-TOTAL-READ-UNITS                                               
MFA-TR*      ,:S-TOTAL-BILL-UNITS                                               
MFA-TR*      ,:S-TOTAL-DEMAND-UNITS                                             
MFA-TR*      ,:S-TOTAL-BILLED-AMT                                               
MFA-TR*      ,:S-TOTAL-FRAN-TAX-AMT                                             
MFA-TR*      ,:S-TOTAL-OTHR-TAX-AMT                                             
MFA-TR*      ,:S-GL-INTRFCE-DB-ACCT                                             
MFA-TR*      ,:S-GL-INTRFCE-CR-ACCT                                             
MFA-TR*      ,:S-COMMENTS                                                       
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100B'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04503_SUMMARY'         TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS-SUMMARY.      
      *                                                                         
       8100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET - DETAILS                                    **        
      ******************************************************************        
      *                                                                         
       8100C-SEND-RESULT-DETAILS.                                       
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04503_DETAILS                       
             (                                                          
              RETURN_CODE                                               
             ,RECORD_TYPE                                               
             ,BILL_COMP_SEQ_NO                                          
             ,CMPNT_ID_CD                                               
             ,INSTR_USE_TYPE_CD                                         
             ,CONSUMPT_TYPE_CD                                          
             ,CODE_TIME_PERIOD                                          
             ,RT_VERS_FROM_DT                                           
             ,FACTOR_ID                                                 
             ,FACTOR_BLOCK_NO                                           
             ,READ_UNITS                                                
A04581       ,BILL_USAGE_UNITS                                          
A04581       ,BILL_DEMAND_UNITS                                         
             ,FACTOR                                                    
             ,FACTOR_AMT                                                
             ,GL_ACCT_NO                                                
             ,TAX_TYPE                                                  
             ,TAX_CNTRL_NO                                              
             ,TAX_FROM_DT                                               
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE-DET                                        
             ,:S-RECORD-TYPE                                            
             ,:S-BILL-COMP-SEQ-NO                                       
             ,:S-CMPNT-ID-CD                                            
             ,:S-INSTR-USE-TYPE-CD                                      
             ,:S-CONSUMPT-TYPE-CD                                       
             ,:S-CODE-TIME-PERIOD                                       
             ,:S-RT-VERS-FROM-DT                                        
             ,:S-FACTOR-ID                                              
             ,:S-FACTOR-BLOCK-NO                                        
             ,:S-READ-UNITS                                             
A04581       ,:S-BILL-USAGE-UNITS                                       
A04581       ,:S-BILL-DEMAND-UNITS                                      
             ,:S-FACTOR                                                 
             ,:S-FACTOR-AMT                                             
             ,:S-GL-ACCT-NO                                             
             ,:S-TAX-TYPE                                               
             ,:S-TAX-CNTRL-NO                                           
             ,:S-TAX-FROM-DT                                            
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04503_DETAILS                               
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,RECORD_TYPE                                                       
MFA-TR*      ,BILL_COMP_SEQ_NO                                                  
MFA-TR*      ,CMPNT_ID_CD                                                       
MFA-TR*      ,INSTR_USE_TYPE_CD                                                 
MFA-TR*      ,CONSUMPT_TYPE_CD                                                  
MFA-TR*      ,CODE_TIME_PERIOD                                                  
MFA-TR*      ,RT_VERS_FROM_DT                                                   
MFA-TR*      ,FACTOR_ID                                                         
MFA-TR*      ,FACTOR_BLOCK_NO                                                   
MFA-TR*      ,READ_UNITS                                                        
MFA-TR*      ,BILL_USAGE_UNITS                                                  
MFA-TR*      ,BILL_DEMAND_UNITS                                                 
MFA-TR*      ,FACTOR                                                            
MFA-TR*      ,FACTOR_AMT                                                        
MFA-TR*      ,GL_ACCT_NO                                                        
MFA-TR*      ,TAX_TYPE                                                          
MFA-TR*      ,TAX_CNTRL_NO                                                      
MFA-TR*      ,TAX_FROM_DT                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE-DET                                                
MFA-TR*      ,:S-RECORD-TYPE                                                    
MFA-TR*      ,:S-BILL-COMP-SEQ-NO                                               
MFA-TR*      ,:S-CMPNT-ID-CD                                                    
MFA-TR*      ,:S-INSTR-USE-TYPE-CD                                              
MFA-TR*      ,:S-CONSUMPT-TYPE-CD                                               
MFA-TR*      ,:S-CODE-TIME-PERIOD                                               
MFA-TR*      ,:S-RT-VERS-FROM-DT                                                
MFA-TR*      ,:S-FACTOR-ID                                                      
MFA-TR*      ,:S-FACTOR-BLOCK-NO                                                
MFA-TR*      ,:S-READ-UNITS                                                     
MFA-TR*      ,:S-BILL-USAGE-UNITS                                               
MFA-TR*      ,:S-BILL-DEMAND-UNITS                                              
MFA-TR*      ,:S-FACTOR                                                         
MFA-TR*      ,:S-FACTOR-AMT                                                     
MFA-TR*      ,:S-GL-ACCT-NO                                                     
MFA-TR*      ,:S-TAX-TYPE                                                       
MFA-TR*      ,:S-TAX-CNTRL-NO                                                   
MFA-TR*      ,:S-TAX-FROM-DT                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100C'                    TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04503_DETAILS'         TO TABLE-1                
              MOVE 'CALL_TYPE'                TO TABLE-ELEMENT-1        
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
              MOVE 'BILL_UNIQUE_TS'           TO TABLE-ELEMENT-4        
              MOVE LINK-CALL-TYPE             TO HOSTVAR-ELEMENT-1      
              MOVE LINK-REVENUE-MONTH         TO HOSTVAR-ELEMENT-2      
              MOVE LINK-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3      
              MOVE LINK-BILL-UNIQUE-TS        TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT            
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS-DETAILS.      
      *                                                                         
       8100C-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 8900-SEND-DONE                                               **        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                         
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'          TO ABEND-FUNCTION                
           END-IF.                                                      
      *                                                                         
           INITIALIZE                     GTT-RETURN-FIELDS.            
      *                                                                         
           MOVE WS-ACTIVE-RETURN-CODE  TO S-RETURN-CODE-INIT            
                                          S-RETURN-CODE-SUMMARY         
                                          S-RETURN-CODE-DET.            
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-INITIAL  THRU  0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-SUMMARY  THRU  0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-DETAILS  THRU  0100C-EXIT.         
      *                                                                         
           PERFORM 8100A-SEND-RESULT-INITIAL  THRU  8100A-EXIT.         
           PERFORM 8100B-SEND-RESULT-SUMMARY  THRU  8100B-EXIT.         
           PERFORM 8100C-SEND-RESULT-DETAILS  THRU  8100C-EXIT.         
      *                                                                         
           PERFORM 9900-SQL-ERROR-ROUTINE     THRU  9900-EXIT.          
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      ** 9999-END-PROGRAM                                             **        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
      *                                                                         
           PERFORM 8900-SEND-DONE      THRU  8900-EXIT.                 
      *                                                                         
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
