       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04502.                                         
COB303 DATE-WRITTEN.  NOV 27, 2012.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS STORED PROCEDURE IS CALLED FROM THE TOFF-CRM NETAPP TO   *        
      *  GET THE EXIT FEE BASED ON THE GAS SERVICE TURN-OFF DATE       *        
      *  REQUESTED BY THE CUSTOMER.                                    *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             ACCOUNT_NO                 CHAR(13)                *        
      *             TURN_OFF_DATE              CHAR(10)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -----------------                                             *        
      *             RETURN_CODE                INTEGER                 *        
      *             SWITCH_EXIT_FEE            DECIMAL(11,6)           *        
      *                                                                *        
      *  APPL RETURN CODE                                              *        
      *  -----------------                                             *        
      *  1000 - INPUT VALUES ARE INVALID                               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *      DATE      INITIALS   COMMENTS                             *        
      *  -----------   --------   ------------------------------       *        
      *  27-NOV-2012   SS97726    INITIAL IMPLEMENTATION.              *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999   MAIN CONTROL PATH AND INITIALIZATION            *        
      *  1000 - 1999   INPUT PROCESSING CONTROL PATH                   *        
      *  2000 - 2999   OUTPUT PROCESSING CONTROL PATH                  *        
      *  3000 - 4999   NOT USED                                        *        
      *  5000 - 5999   COMMON PROGRAM MODULES                          *        
      *  6000 - 6999   COMMON SYSTEM MODULES                           *        
      *  7000 - 7999   INPUT MODULES                                   *        
      *  8000 - 8999   OUTPUT MODULES                                  *        
      *  9000 - 9999   TERMINATION,ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04502'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04502 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT        AT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_MKT_TIER  DD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMKTIER                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CSS_UTIL_ENVRNMT   UT                                      *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBUTLENV                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_FIXED_FCTR     FF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBFXDFCT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR      SF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBSPLFTR                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCT_RTPK_AGR  DF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBACCTRG                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CRM_OPT_ATTR_INCTV HQ                                      *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBOPTATT                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    CRM_RT_PKG_OPTION  FI                                      *         
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBRTPKGO                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM       G6                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBJBPARM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_WINDOW    BN                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_ATTR_PRORATE   2L                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBATRPRO                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CRM_ATTR_PRO_FCTR  2N                                       *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBATRFCT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT TO GET EXIT FEE                     *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWS04114                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04502'. 
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
                                                                        
       01  SWITCHES.                                                    
           05  CSR04502-DONE-SW             PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88 NO-MORE-ROWS                        VALUE 'Y'.        
                                                                        
       01  NULL-INDICATORS.                                             
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN               PIC S9(04) COMP.            
               49 GTT-ROW-CHAR              PIC X(1024).                
           05  GTT-SQLCODE                  PIC S9(9) COMP.             
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-ZERO                      PIC S9(4) COMP VALUE 0.     
           05  GTT-NAME                     PIC X(26) VALUE             
                                                'SESSION.CSR04502_R1'.  
       01  WS-MISC.                                                     
           05  WS-YES-NULL                  PIC S9(4) VALUE -1.         
           05  WS-DURATION-REM-NO           PIC X(04) VALUE SPACES.     
           05  WS-ACCOUNT-NO                PIC X(13) VALUE SPACES.     
           05  WS-ACCOUNT-NUM REDEFINES WS-ACCOUNT-NO                   
                                            PIC 9(13).                  
           05  WS-TURN-OFF-DATE             PIC X(10) VALUE SPACES.     
           05  WS-FACTOR-FF                 PIC S9(9)V9(6) USAGE COMP-3 
                                                      VALUE 0.          
           05  WS-HOLD-REV-MNTH             PIC 9(6)  VALUE ZEROS.      
           05  WS-HOLD-DURATION-REM         PIC S9(4) USAGE COMP.       
           05  WS-COMMON-RUN-DATE           PIC X(10) VALUE SPACES.     
           05  WS-COMMON-REV-MNTH           PIC 9(6)  VALUE ZEROS.      
           05  WS-HOLD-REV-MNTH-RED.                                    
               10  WS-HOLD-REV-MNTH-YR      PIC 9(4)  VALUE ZEROS.      
               10  WS-HOLD-REV-MNTH-MM      PIC 9(2)  VALUE ZEROS.      
           05  WS-DUMMY-DATE.                                           
               10  WS-DUMMY-DT-YYYY         PIC X(4)  VALUE SPACES.     
               10  WS-DUMMY-DT-F1           PIC X(1)  VALUE '-'.        
               10  WS-DUMMY-DT-MM           PIC X(2)  VALUE SPACES.     
               10  WS-DUMMY-DT-F2           PIC X(1)  VALUE '-'.        
               10  WS-DUMMY-DT-DD           PIC X(2)  VALUE SPACES.     
           05  WS-RESULT-DATE               PIC X(10) VALUE SPACES.     
           05  WS-DUMMY-DATE-TEMP           PIC X(10) VALUE SPACES.     
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE 0.    
           05  S-SWITCH-EXIT-FEE            PIC S9(5)V9(6) USAGE COMP-3 
                                                            VALUE 0.    
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                   PIC X(18)  VALUE SPACES.    
            10  S-SQLCODE                   PIC S9(9)  COMP VALUE 0.    
            10  S-SQLSTATE                  PIC X(5)   VALUE ' '.       
            10  S-TABLE-NAME                PIC X(18)  VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L      PIC S9(4)  USAGE COMP.      
                49  S-HOST-VARIABLES-V      PIC X(255).                 
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L       PIC S9(4)  USAGE COMP.      
                49  S-SQL-STATEMENT-V       PIC X(255).                 
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L     PIC S9(4)  USAGE COMP.      
                49  S-SQL-DESCRIPTION-V     PIC X(255).                 
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                  PIC X(13).                  
       01  PARM-TURN-OFF-DATE               PIC X(10).                  
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-TURN-OFF-DATE.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE      THRU  0100-EXIT.                
           PERFORM 1000-PROCESS-INPUT   THRU  1000-EXIT.                
           PERFORM 2000-PROCESS-OUTPUT  THRU  2000-EXIT.                
           PERFORM 9999-END-PROGRAM     THRU  9999-EXIT.                
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT    THRU  0100A-EXIT.               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT.                                             *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04502_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04502_R1
              (                                                      
                     RETURN_CODE                INT                 
                    ,SWITCH_EXIT_FEE            DECIMAL(11,6)           
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE               AS RETURN_CODE         
                      ,SWITCH_EXIT_FEE           AS SWITCH_EXIT_FEE     
                  FROM #CSR04502_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE               AS RETURN_CODE                 
MFA-TR*               ,SWITCH_EXIT_FEE           AS SWITCH_EXIT_FEE             
MFA-TR*           FROM SESSION.CSR04502_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NUM              TO WS-ACCT-NO-4114          
                                               AT-ACCOUNT-NO.           
                                                                        
           MOVE PARM-TURN-OFF-DATE          TO WS-TURN-OFF-DATE.        
                                                                        
           MOVE 'A'                         TO WS-RTPK-AGR-STAT-4114.   
           MOVE 'EXIT FEE'                  TO WS-INCTV-TYPE-4114.      
                                                                        
           PERFORM 1100-VALIDATE-INPUT         THRU  1100-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * BASIC INPUT VALIDATION FOR ACCOUNT NO / TURN OFF DATE         *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF WS-ACCOUNT-NUM > WS-ZERO AND WS-TURN-OFF-DATE > SPACES    
              CONTINUE                                                  
           ELSE                                                         
      ***********************************                                       
      * PASSED INPUT VALUES ARE INVALID *                                       
      ***********************************                                       
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'RECEIVE INPUT'          TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              MOVE +1000                    TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT         THRU  8100-EXIT          
              PERFORM 9999-END-PROGRAM         THRU  9999-EXIT          
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-GET-EXIT-FEE-DET       THRU  2100-EXIT.         
           PERFORM 2200-BUILD-RESULT-SET       THRU  2200-EXIT.         
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                      TO S-RETURN-CODE            
              PERFORM 8100-SEND-RESULT         THRU  8100-EXIT          
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETTING EXIT FEE / RATE CHANGE EXIT FEE FROM CPD04114 CPYC.    *        
      * 2100-GET-EXIT-FEE-DET.                                         *        
      ******************************************************************        
       2100-GET-EXIT-FEE-DET.                                           
                                                                        
           INITIALIZE WS-INPUT-DATE-4114                                
                      WS-REV-MTH-4114.                                  
                                                                        
           PERFORM 6000-GET-PRO-INCTV-CPD4114  THRU                     
                   6000-CPD4114-EXIT                                    
                                                                        
           IF NO-ERRORS-4114                                            
              MOVE WS-EXIT-FEE-4114         TO S-SWITCH-EXIT-FEE        
           ELSE                                                         
              MOVE WS-ZERO                  TO S-SWITCH-EXIT-FEE        
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  2200-BUILD-RESULT-SET.                                                 
      ******************************************************************        
       2200-BUILD-RESULT-SET.                                           
                                                                        
           PERFORM 7100-GET-ACCT-OPTION-DURATION                        
                                               THRU  7100-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF FF-DURATION-REMAIN-NO > 0                              
                 MOVE FF-DURATION-REMAIN-NO TO WS-HOLD-DURATION-REM     
                 IF AT-REV-MTH-LST-NRML > 0                             
                    MOVE AT-REV-MTH-LST-NRML                            
                                            TO WS-HOLD-REV-MNTH         
                 ELSE                                                   
                    PERFORM 7200-GET-COMMON-DATE                        
                                               THRU  7200-EXIT          
                    PERFORM 7300-GET-COMMON-REV-MTH                     
                                               THRU  7300-EXIT          
                    MOVE G6-PARM-DATA(15:6) TO WS-COMMON-REV-MNTH       
                    MOVE WS-COMMON-RUN-DATE TO BN-DATE-EXTRACT          
                    MOVE AT-BILL-CYCLE      TO BN-BILL-CYCLE            
                    PERFORM 7400-GET-BILL-WINDOW                        
                                               THRU  7400-EXIT          
                    IF WS-HOLD-DURATION-REM > 0                         
                       COMPUTE WS-HOLD-DURATION-REM =                   
                               WS-HOLD-DURATION-REM - 1                 
                    END-IF                                              
                 END-IF                                                 
                 PERFORM 2300-GET-EXPIRATION-DATE                       
                                               THRU  2300-EXIT          
                 PERFORM 2400-VALIDATE-EXIT-FEE                         
                                               THRU  2400-EXIT          
              ELSE                                                      
                 MOVE 0                     TO S-RETURN-CODE            
                 MOVE WS-ZERO               TO S-SWITCH-EXIT-FEE        
              END-IF                                                    
           ELSE                                                         
              MOVE 100                      TO S-RETURN-CODE            
              MOVE WS-ZERO                  TO S-SWITCH-EXIT-FEE        
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT            THRU  8100-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2300-GET-EXPIRATION-DATE.                                     *        
      ******************************************************************        
       2300-GET-EXPIRATION-DATE.                                        
                                                                        
           MOVE WS-HOLD-REV-MNTH            TO WS-HOLD-REV-MNTH-RED.    
           MOVE WS-HOLD-REV-MNTH-YR         TO WS-DUMMY-DT-YYYY.        
           MOVE WS-HOLD-REV-MNTH-MM         TO WS-DUMMY-DT-MM.          
           MOVE '01'                        TO WS-DUMMY-DT-DD.          
           MOVE '-'                         TO WS-DUMMY-DT-F1           
                                               WS-DUMMY-DT-F2.          
           MOVE WS-DUMMY-DATE               TO WS-DUMMY-DATE-TEMP.      
                                                                        
           PERFORM 7500-CALC-EXPR-DATE         THRU  7500-EXIT.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2400-VALIDATE-EXIT-FEE.                                       *        
      ******************************************************************        
       2400-VALIDATE-EXIT-FEE.                                          
                                                                        
           MOVE WS-RESULT-DATE(1:4)         TO WS-HOLD-REV-MNTH-YR.     
           MOVE WS-RESULT-DATE(6:2)         TO WS-HOLD-REV-MNTH-MM.     
           MOVE WS-HOLD-REV-MNTH-RED        TO WS-HOLD-REV-MNTH.        
           MOVE WS-HOLD-REV-MNTH            TO BN-REVENUE-MONTH.        
           MOVE AT-BILL-CYCLE               TO BN-BILL-CYCLE.           
                                                                        
           PERFORM 7600-GET-LAST-BILL-DATE     THRU  7600-EXIT          
                                                                        
           IF WS-TURN-OFF-DATE >= BN-DATE-EXTRACT                       
              MOVE ZEROS                    TO S-SWITCH-EXIT-FEE        
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6000-GET-PRO-INCTV-CPD04114                                    *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD04114                                                 
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      ** ERROR ROUTINE FOR COPYBOOK CPD04114                         **         
      *****************************************************************         
       6999-ERROR-ROUTINE-CPD4114.                                      
                                                                        
           IF ERRORS-4114                                               
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
                 CONTINUE                                               
              ELSE                                                      
                 PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT        
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6999-CPD4114-EXIT.                                               
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  GET ACCT'S OPTION DATA                                      **        
      ******************************************************************        
       7100-GET-ACCT-OPTION-DURATION.                                   
                                                                        
           EXEC SQL                                                     
               SELECT  AT.BILL_CYCLE                                    
                      ,AT.REV_MTH_LST_NRML                              
                      ,FF.DURATION_REMAIN_NO                            
                 INTO  :AT-BILL-CYCLE                                   
                      ,:AT-REV-MTH-LST-NRML                             
                      ,:FF-DURATION-REMAIN-NO                           
                 FROM  CSS_ACCOUNT         AT WITH(READUNCOMMITTED)             
                      ,CSS_UTIL_ENVRNMT    UT WITH(READUNCOMMITTED)             
                      ,CSS_ACCT_RTPK_AGR   DF WITH(READUNCOMMITTED)             
                      ,CSS_FIXED_FCTR      FF WITH(READUNCOMMITTED)             
                      ,CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)             
                      ,CSS_SPCL_FCTR       SF WITH(READUNCOMMITTED)             
                WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO            
                  AND UT.ACCOUNT_NO         =  AT.ACCOUNT_NO            
                  AND UT.CODE_UTIL_TYPE     =  'G'                      
                  AND DF.ACCOUNT_NO         =  UT.ACCOUNT_NO            
                  AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE        
                  AND DF.IC_NO              =  UT.IC_NO                 
                  AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO     
                  AND FF.ACCOUNT_NO         =  UT.ACCOUNT_NO            
                  AND FF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE        
                  AND FF.IC_NO              =  UT.IC_NO                 
                  AND FF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO     
                  AND FF.DURATION_REMAIN_NO >  0                        
                  AND SF.FACTOR_ID          =  FF.FACTOR_ID             
                  AND SF.OVR_RT_CALC_TYP_CD =  '02'                     
                  AND HQ.FACTOR_ID          =  FF.FACTOR_ID             
                  AND HQ.OPTION_CD          =  DF.OPTION_CD             
                  AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT      
                  AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT      
                  AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'            
                  AND HQ.PRIMRY_OPT_ATTR_FL =  'Y'                      
                  AND HQ.PROC_STATUS_CD     =  'AC'                     
                  AND HQ.OPT_ATTR_VSTART_TS = (                         
                      SELECT MAX(H1.OPT_ATTR_VSTART_TS)                 
                        FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)        
                       WHERE H1.OPTION_CD       = HQ.OPTION_CD          
                         AND H1.RT_ATTR_INCTV_TYPE                      
                                                = HQ.RT_ATTR_INCTV_TYPE 
                         AND H1.ATTR_INCTV_STRT_DT                      
                                               <= DF.OPT_AGRMT_EFF_DT   
                         AND H1.ATTR_INCTV_END_DT                       
                                               >= DF.OPT_AGRMT_EFF_DT   
                         AND CAST(H1.OPT_ATTR_VSTART_TS AS DATE)                
                                               <= DF.OPT_AGRMT_EFF_DT   
                         AND CAST(H1.OPT_ATTR_VEND_TS AS DATE)                  
                                               >= DF.OPT_AGRMT_EFF_DT   
                         AND H1.PROC_STATUS_CD  = 'AC')                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  AT.BILL_CYCLE                                            
MFA-TR*               ,AT.REV_MTH_LST_NRML                                      
MFA-TR*               ,FF.DURATION_REMAIN_NO                                    
MFA-TR*          INTO  :AT-BILL-CYCLE                                           
MFA-TR*               ,:AT-REV-MTH-LST-NRML                                     
MFA-TR*               ,:FF-DURATION-REMAIN-NO                                   
MFA-TR*          FROM  CSS_ACCOUNT         AT                                   
MFA-TR*               ,CSS_UTIL_ENVRNMT    UT                                   
MFA-TR*               ,CSS_ACCT_RTPK_AGR   DF                                   
MFA-TR*               ,CSS_FIXED_FCTR      FF                                   
MFA-TR*               ,CRM_OPT_ATTR_INCTV  HQ                                   
MFA-TR*               ,CSS_SPCL_FCTR       SF                                   
MFA-TR*         WHERE AT.ACCOUNT_NO         = :AT-ACCOUNT-NO                    
MFA-TR*           AND UT.ACCOUNT_NO         =  AT.ACCOUNT_NO                    
MFA-TR*           AND UT.CODE_UTIL_TYPE     =  'G'                              
MFA-TR*           AND DF.ACCOUNT_NO         =  UT.ACCOUNT_NO                    
MFA-TR*           AND DF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE                
MFA-TR*           AND DF.IC_NO              =  UT.IC_NO                         
MFA-TR*           AND DF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO             
MFA-TR*           AND FF.ACCOUNT_NO         =  UT.ACCOUNT_NO                    
MFA-TR*           AND FF.CODE_UTIL_TYPE     =  UT.CODE_UTIL_TYPE                
MFA-TR*           AND FF.IC_NO              =  UT.IC_NO                         
MFA-TR*           AND FF.RT_PKG_OPT_SEQ_NO  =  UT.RT_PKG_OPT_SEQ_NO             
MFA-TR*           AND FF.DURATION_REMAIN_NO >  0                                
MFA-TR*           AND SF.FACTOR_ID          =  FF.FACTOR_ID                     
MFA-TR*           AND SF.OVR_RT_CALC_TYP_CD =  '02'                             
MFA-TR*           AND HQ.FACTOR_ID          =  FF.FACTOR_ID                     
MFA-TR*           AND HQ.OPTION_CD          =  DF.OPTION_CD                     
MFA-TR*           AND HQ.ATTR_INCTV_STRT_DT <= DF.OPT_AGRMT_EFF_DT              
MFA-TR*           AND HQ.ATTR_INCTV_END_DT  >= DF.OPT_AGRMT_EFF_DT              
MFA-TR*           AND HQ.RT_ATTR_INCTV_TYPE =  'FIXED PRICE'                    
MFA-TR*           AND HQ.PRIMRY_OPT_ATTR_FL =  'Y'                              
MFA-TR*           AND HQ.PROC_STATUS_CD     =  'AC'                             
MFA-TR*           AND HQ.OPT_ATTR_VSTART_TS = (                                 
MFA-TR*               SELECT MAX(H1.OPT_ATTR_VSTART_TS)                         
MFA-TR*                 FROM CRM_OPT_ATTR_INCTV H1                              
MFA-TR*                WHERE H1.OPTION_CD       = HQ.OPTION_CD                  
MFA-TR*                  AND H1.RT_ATTR_INCTV_TYPE                              
MFA-TR*                                         = HQ.RT_ATTR_INCTV_TYPE         
MFA-TR*                  AND H1.ATTR_INCTV_STRT_DT                              
MFA-TR*                                        <= DF.OPT_AGRMT_EFF_DT           
MFA-TR*                  AND H1.ATTR_INCTV_END_DT                               
MFA-TR*                                        >= DF.OPT_AGRMT_EFF_DT           
MFA-TR*                  AND DATE(H1.OPT_ATTR_VSTART_TS)                        
MFA-TR*                                        <= DF.OPT_AGRMT_EFF_DT           
MFA-TR*                  AND DATE(H1.OPT_ATTR_VEND_TS)                          
MFA-TR*                                        >= DF.OPT_AGRMT_EFF_DT           
MFA-TR*                  AND H1.PROC_STATUS_CD  = 'AC')                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROS                 TO FF-DURATION-REMAIN-NO    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIXED_FCTR  '       TO TABLE-1                  
              MOVE 'CSS_SPCL_FCTR   '       TO TABLE-2                  
              MOVE 'CSS_ACCT_RTPK_AG'       TO TABLE-3                  
              MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-4                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7200-GET-COMMON-DATE.                                     **          
      ****************************************************************          
       7200-GET-COMMON-DATE.                                            
                                                                        
           EXEC SQL                                                     
               SELECT  CIS.SUBSTR3(G6.PARM_DATA,10,10)                       
                 INTO :WS-COMMON-RUN-DATE                               
                 FROM  CSS_JOB_PARM   G6 WITH(READUNCOMMITTED)                  
                WHERE  G6.PROGRAM_NAME  =  'COMMON'                     
                  AND  G6.COMPANY_NO    =  '01'                         
                  AND  G6.CMND_CODE     =  'DATE'                       
                  AND  G6.SEQ_NO        =  10                           
                  AND  G6.STATUS        =  'A'                          
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SUBSTR(G6.PARM_DATA,10,10)                               
MFA-TR*          INTO :WS-COMMON-RUN-DATE                                       
MFA-TR*          FROM  CSS_JOB_PARM   G6                                        
MFA-TR*         WHERE  G6.PROGRAM_NAME  =  'COMMON'                             
MFA-TR*           AND  G6.COMPANY_NO    =  '01'                                 
MFA-TR*           AND  G6.CMND_CODE     =  'DATE'                               
MFA-TR*           AND  G6.SEQ_NO        =  10                                   
MFA-TR*           AND  G6.STATUS        =  'A'                                  
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMMON'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7300-GET-COMMON-REV-MTH.                                  **          
      ****************************************************************          
       7300-GET-COMMON-REV-MTH.                                         
                                                                        
           EXEC SQL                                                     
               SELECT  CIS.SUBSTR3(G6.PARM_DATA,15,6)                        
                 INTO :G6-PARM-DATA                                     
                 FROM  CSS_JOB_PARM  G6 WITH(READUNCOMMITTED)                   
                WHERE  G6.PROGRAM_NAME  =  'COMMON'                     
                  AND  G6.CMND_CODE     =  'DATE'                       
                  AND  G6.SEQ_NO        =  20                           
                  AND  G6.STATUS        =  'A'                          
                  AND  G6.COMPANY_NO    =  '01'                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SUBSTR(G6.PARM_DATA,15,6)                                
MFA-TR*          INTO :G6-PARM-DATA                                             
MFA-TR*          FROM  CSS_JOB_PARM  G6                                         
MFA-TR*         WHERE  G6.PROGRAM_NAME  =  'COMMON'                             
MFA-TR*           AND  G6.CMND_CODE     =  'DATE'                               
MFA-TR*           AND  G6.SEQ_NO        =  20                                   
MFA-TR*           AND  G6.STATUS        =  'A'                                  
MFA-TR*           AND  G6.COMPANY_NO    =  '01'                                 
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMMON'                 TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7400-GET-BILL-WINDOW.                                     **          
      **      GET THE BILL WINDOW REVENUE MONTH TO GET THE START    **          
      **      DATE FOR THE FIXED FACTOR ACCOUNTS. THIS IS ONLY FOR  **          
      **      THE ACCOUNTS WHICH NEVER BILLED IN THE SYSTEM         **          
      ****************************************************************          
       7400-GET-BILL-WINDOW.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REVENUE_MONTH                                    
                 INTO :BN-REVENUE-MONTH                                 
                 FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                    
                WHERE  DATE_EXTRACT > IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                  
                  AND  BILL_CYCLE   = :BN-BILL-CYCLE                    
                ORDER  BY REVENUE_MONTH                                 
                                                   
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  REVENUE_MONTH                                            
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM  CSS_BILL_WINDOW                                          
MFA-TR*         WHERE  DATE_EXTRACT > :BN-DATE-EXTRACT                          
MFA-TR*           AND  BILL_CYCLE   = :BN-BILL-CYCLE                            
MFA-TR*         ORDER  BY REVENUE_MONTH                                         
MFA-TR*         FETCH  FIRST ROW ONLY                                           
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  MOVE BN-REVENUE-MONTH     TO WS-HOLD-REV-MNTH         
               WHEN NOT-FOUND                                           
                  MOVE WS-COMMON-REV-MNTH   TO WS-HOLD-REV-MNTH         
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7400'               TO ACTIVE-PARAGRAPH         
                  MOVE 'SELECT'             TO ABEND-FUNCTION           
                  MOVE 'CSS_BILL_WINDOW '   TO TABLE-1                  
                  MOVE 'DATE_EXTRACT'       TO TABLE-ELEMENT-1          
                  MOVE 'BILL_CYCLE'         TO TABLE-ELEMENT-2          
                  MOVE BN-DATE-EXTRACT      TO HOSTVAR-ELEMENT-1        
                  MOVE BN-BILL-CYCLE        TO HOSTVAR-ELEMENT-2        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7500-CALC-EXPR-DATE.                                      **          
      ****************************************************************          
       7500-CALC-EXPR-DATE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, :WS-HOLD-DURATION-REM, 
              IIF(TRY_CONVERT(DATE, :WS-DUMMY-DATE-TEMP
              ) IS NULL OR (PATINDEX('%.%', :WS-DUMMY-DATE-TEMP
              ) <> 0) OR (LEN(:WS-DUMMY-DATE-TEMP
              ) <> 10), CIS.CHAR2DATE(:WS-DUMMY-DATE-TEMP
              ), CONVERT(DATE, :WS-DUMMY-DATE-TEMP) ) )
            INTO
              :WS-RESULT-DATE      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-RESULT-DATE = DATE(DATE(:WS-DUMMY-DATE-TEMP)             
MFA-TR*                            + :WS-HOLD-DURATION-REM MONTHS)              
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_MODEL_SQL'          TO TABLE-1                  
              MOVE 'CAL_DATE'               TO TABLE-ELEMENT-1          
              MOVE 'DURATION_REM'           TO TABLE-ELEMENT-1          
              MOVE WS-DUMMY-DATE-TEMP       TO HOSTVAR-ELEMENT-1        
              MOVE WS-HOLD-DURATION-REM     TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  7600-GET-LAST-BILL-DATE.                                  **          
      **      GET THE DATE WHEN THE ACCOUNT WILL BILL ON THE CURRENT**          
      **      FIXED PRICE FOR THE LAST TIME.                        **          
      ****************************************************************          
       7600-GET-LAST-BILL-DATE.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DATE_EXTRACT                                     
                 INTO :BN-DATE-EXTRACT                                  
                 FROM  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                    
                WHERE  BILL_CYCLE    = :BN-BILL-CYCLE                   
                  AND  REVENUE_MONTH = :BN-REVENUE-MONTH                
                ORDER  BY DATE_EXTRACT                                  
                                                   
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DATE_EXTRACT                                             
MFA-TR*          INTO :BN-DATE-EXTRACT                                          
MFA-TR*          FROM  CSS_BILL_WINDOW                                          
MFA-TR*         WHERE  BILL_CYCLE    = :BN-BILL-CYCLE                           
MFA-TR*           AND  REVENUE_MONTH = :BN-REVENUE-MONTH                        
MFA-TR*         ORDER  BY DATE_EXTRACT                                          
MFA-TR*         FETCH  FIRST ROW ONLY                                           
MFA-TR*          WITH  UR                                                       
MFA-TR*       QUERYNO  7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7600'               TO ACTIVE-PARAGRAPH         
                  MOVE 'SELECT'             TO ABEND-FUNCTION           
                  MOVE 'CSS_BILL_WINDOW '   TO TABLE-1                  
                  MOVE 'DATE_EXTRACT'       TO TABLE-ELEMENT-1          
                  MOVE 'REVENUE_MONTH'      TO TABLE-ELEMENT-2          
                  MOVE BN-DATE-EXTRACT      TO HOSTVAR-ELEMENT-1        
                  MOVE BN-REVENUE-MONTH     TO HOSTVAR-ELEMENT-2        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04502_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04502_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '8000A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DELETE'             TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04502_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04502_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,SWITCH_EXIT_FEE                                     
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE                                      
                   ,:S-SWITCH-EXIT-FEE                                  
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04502_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,SWITCH_EXIT_FEE                                             
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-SWITCH-EXIT-FEE                                          
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04502_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
