       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04501.                                         
COB303 DATE-WRITTEN.  NOV 21, 2012.                                     
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA BUSOP.                           *00100000
      *                                                                *00110000
      *  PROGRAM:       CSR04501                                       *00120000
      *  CALLING SP:    UPDJOBPARMDETAILS                              *00130000
      *                                                                *00140000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *  THIS PROCEDURE UPDATES JOB PARM DETAILS INTO CSS_JOB_PARM     *00180000
      *                                                                *00190000
      *  INPUT PARAMETRS                                               *00190000
      *  -----------------                                             *00190000
      *       I_PROCESSING_FLAG     CHAR(01)                           *00190000
      *       I_PROGRAM_NAME        CHAR(10)                           *00190000
      *       I_COMPANY_NO          CHAR(02)                           *00190000
      *       I_CMND_CODE           CHAR(04)                           *00190000
      *       I_SEQ_NO              DECIMAL(4,0)                       *00190000
      *       I_STATUS              CHAR(01)                           *00190000
      *       I_PARM_DATA           CHAR(80)                           *00190000
      *       I_USER_ID             CHAR(07)                           *00190000
      *                                                                *00190000
      ******************************************************************00200000
      *                                                                *00210000
      *                     PROGRAM MODIFICATION LOG                   *00220000
      *                                                                *00230000
      *    DATE    INITIALS   COMMENTS                                 *00240000
      *  --------  --------   ---------------------------------------  *00250000
      *  11-21-12  MN90523    INITIAL PROGRAM VERSION                  *00260000
      ******************************************************************00270000
      ******************************************************************00280000
      *                                                                *00290000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00300000
      *                                                                *00310000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00320000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00330000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00340000
      *  3000 - 4999  NOT USED                                         *00350000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00360000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00370000
      *  7000 - 7999  INPUT MODULES                                    *00380000
      *  8000 - 8999  OUTPUT MODULES                                   *00390000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00400000
      *                                                                *00410000
      ******************************************************************00420000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04501'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04501 STARTS HERE'.                  
                                                                        
      ******************************************************************00510000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00520000
      ******************************************************************00530000
                                                                        
           COPY CWS00056.                                               00570000
           COPY CWS00303.                                               00580000
                                                                        
           EXEC SQL                                                     00630000
               INCLUDE CWSX0010                                         00640000
           END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00670000
      *    WORK AREAS                                                  *00680000
      ******************************************************************00690000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04501'.     
           05  WS-USER-HAS-ACCESS       PIC X(01) VALUE 'N'.            
           05  WS-JOB-PARM-EXISTS       PIC X(01) VALUE 'N'.            
           05  WS-MAX-SEQ-NO            PIC S9(4)V COMP-3 VALUE 0.      
                                                                        
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-ZERO                  PIC S9(01) COMP VALUE +0.       
                                                                        
       01 WS-NULL-INDICATORS.                                           
           05  WS-NULL-IND-01           PIC S9(04) COMP VALUE +0.       
                                                                        
       01  WS-LITERALS.                                                 
           05  INSERT-FLAG              PIC X(01)   VALUE 'I'.          
           05  UPDATE-FLAG              PIC X(01)   VALUE 'U'.          
           05  DELETE-FLAG              PIC X(01)   VALUE 'D'.          
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04501_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(09) COMP.                
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE            PIC S9(9) COMP VALUE 0.          
           05 S-APPL-RETURN-CODE       PIC S9(9) COMP VALUE 0.          
           05 S-BUS-RULE-ID            PIC X(10) VALUE SPACE.           
           05 S-BUS-RULE-RESULT-CD     PIC X(08) VALUE SPACE.           
           05 S-BUS-RULE-XREF-ID       PIC X(26) VALUE SPACE.           
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                 01880000
                                                                        
      ******************************************************************01900000
      *    DB2 INCLUDES                                                *01910000
      ******************************************************************01920000
           EXEC SQL                                                     01940000
              INCLUDE SQLCA                                             01950000
           END-EXEC.                                                    01960000
                                                                        
      ******************************************************************02241001
      * CSS_JOB_PARM       G6                                          *02242001
      ******************************************************************02243001
           EXEC SQL                                                     02244001
              INCLUDE TBJBPARM                                          02245001
           END-EXEC.                                                    02246001
                                                                        
      ******************************************************************02241001
      * CSS_JOBS_USER      J0                                          *02242001
      ******************************************************************02243001
           EXEC SQL                                                     02244001
              INCLUDE TBJOBUSR                                          02245001
           END-EXEC.                                                    02246001
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-PROCESSING-FLAG        PIC X(01).                       
       01  PARM-PROGRAM-NAME           PIC X(10).                       
       01  PARM-COMPANY-NO             PIC X(02).                       
       01  PARM-CMND-CODE              PIC X(04).                       
COB305 01 PARM-SEQ-NO        PIC S9(04)V COMP-3 VALUE 0.              
       01  PARM-STATUS                 PIC X(01).                       
       01  PARM-DATA                   PIC X(80).                       
       01  PARM-USER-ID                PIC X(07).                       
                                                                        
       PROCEDURE DIVISION USING PARM-PROCESSING-FLAG                    
                                PARM-PROGRAM-NAME                       
                                PARM-COMPANY-NO                         
                                PARM-CMND-CODE                          
                                PARM-SEQ-NO                             
                                PARM-STATUS                             
                                PARM-DATA                               
                                PARM-USER-ID.                           
                                                                        
      ******************************************************************02670000
      *                                                                *02671000
      * 0000-MAINLINE                                                  *02680000
      ******************************************************************02700000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02810000
      *                                                                *02811000
      * 0100-INITIALIZE                                                *02820000
      ******************************************************************02890000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE               AS RETURN_CODE       
                     ,:S-APPL-RETURN-CODE          AS APPL_RETURN_CODE  
                     ,LTRIM(RTRIM(:S-BUS-RULE-ID))        AS BUS_RULE_ID       
                     ,LTRIM(RTRIM(:S-BUS-RULE-RESULT-CD)) AS 
           BUS_RULE_RESULT_CD
                     ,LTRIM(RTRIM(:S-BUS-RULE-XREF-ID))   AS 
           BUS_RULE_XREF_ID  
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     02970000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        02980000
MFA-TR*        SELECT :S-RETURN-CODE               AS RETURN_CODE       02990000
MFA-TR*              ,:S-APPL-RETURN-CODE          AS APPL_RETURN_CODE  03000000
MFA-TR*              ,STRIP(:S-BUS-RULE-ID)        AS BUS_RULE_ID       03020000
MFA-TR*              ,STRIP(:S-BUS-RULE-RESULT-CD) AS BUS_RULE_RESULT_CD03030000
MFA-TR*              ,STRIP(:S-BUS-RULE-XREF-ID)   AS BUS_RULE_XREF_ID  03040000
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                  03050000
MFA-TR*    END-EXEC.                                                    03060000
                                                                        
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03130000
      *                                                                *03131000
      * 1000-PROCESS-INPUT.                                            *03140000
      ******************************************************************03210000
       1000-PROCESS-INPUT.                                              
                                                                        
      *    VALIDATE COMPANY NUMBER                                              
           IF PARM-COMPANY-NO = SPACES                                  
              MOVE ZEROS                 TO S-RETURN-CODE               
              MOVE ZEROS                 TO S-APPL-RETURN-CODE          
              MOVE 'JP00000005'          TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
      *    VALIDATE PROGRAM NAME                                                
           IF PARM-PROGRAM-NAME = SPACES                                
              MOVE ZEROS                 TO S-RETURN-CODE               
              MOVE ZEROS                 TO S-APPL-RETURN-CODE          
              MOVE 'JP00000006'          TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
      *    VALIDATE PARM DATA                                                   
           IF PARM-DATA  = SPACES                                       
              MOVE ZEROS                 TO S-RETURN-CODE               
              MOVE ZEROS                 TO S-APPL-RETURN-CODE          
              MOVE 'JP00000007'          TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
      *    VALIDATE COMMAND CODE                                                
           IF PARM-CMND-CODE = SPACES                                   
              MOVE ZEROS                 TO S-RETURN-CODE               
              MOVE ZEROS                 TO S-APPL-RETURN-CODE          
              MOVE 'JP00000009'          TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
      *    VALIDATE STATUS                                                      
           IF PARM-STATUS = SPACES                                      
              MOVE ZEROS                 TO S-RETURN-CODE               
              MOVE ZEROS                 TO S-APPL-RETURN-CODE          
              MOVE 'JP00000010'          TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
      *    VALIDATE USER ID                                                     
           IF PARM-USER-ID = SPACES                                     
              MOVE ZEROS                 TO S-RETURN-CODE               
              MOVE ZEROS                 TO S-APPL-RETURN-CODE          
              MOVE 'JP00000008'          TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
      *    VALIDATE PROCESSING FLAG                                             
           IF PARM-PROCESSING-FLAG = SPACES OR                          
             (PARM-PROCESSING-FLAG NOT = INSERT-FLAG AND                
              PARM-PROCESSING-FLAG NOT = UPDATE-FLAG AND                
              PARM-PROCESSING-FLAG NOT = DELETE-FLAG )                  
              MOVE ZEROS                 TO S-RETURN-CODE               
              MOVE ZEROS                 TO S-APPL-RETURN-CODE          
              MOVE 'JP00000011'          TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
      *    VALIDATE PROCESSING FLAG                                             
           IF PARM-SEQ-NO < 0                                           
              MOVE ZEROS                 TO S-RETURN-CODE               
              MOVE ZEROS                 TO S-APPL-RETURN-CODE          
              MOVE 'JP00000012'          TO S-BUS-RULE-ID               
              MOVE 'F'                   TO S-BUS-RULE-RESULT-CD        
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF.                                                      
                                                                        
           MOVE PARM-PROGRAM-NAME        TO G6-PROGRAM-NAME             
                                            J0-APPL-PROGRAM-ID.         
           MOVE PARM-COMPANY-NO          TO G6-COMPANY-NO.              
           MOVE PARM-CMND-CODE           TO G6-CMND-CODE.               
           MOVE PARM-SEQ-NO              TO G6-SEQ-NO.                  
           MOVE PARM-STATUS              TO G6-STATUS.                  
           MOVE PARM-DATA                TO G6-PARM-DATA.               
           MOVE PARM-USER-ID             TO J0-USER-ID.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03130000
      *                                                                *03131000
      * 2000-PROCESS-OUTPUT.                                           *03140000
      ******************************************************************03210000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2010-CHECK-SECURITY     THRU 2010-EXIT.              
                                                                        
           PERFORM 5000-UPDATE-PROCESS     THRU 5000-EXIT.              
           ADD +1                          TO   CTR-ROWS.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03410000
      *                                                                *03411000
      * 2010-CHECK-SECURITY                                            *03420000
      ******************************************************************03430000
       2010-CHECK-SECURITY.                                             
                                                                        
           PERFORM 7010-CHECK-JOBS-USER      THRU 7010-EXIT.            
                                                                        
           IF WS-USER-HAS-ACCESS = 'N'                                  
              MOVE ZEROS                     TO   S-RETURN-CODE         
              MOVE ZEROS                     TO   S-APPL-RETURN-CODE    
              MOVE 'JP00000001'              TO   S-BUS-RULE-ID         
              MOVE 'F'                       TO   S-BUS-RULE-RESULT-CD  
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT           
              END-IF                                                    
              ADD +1                         TO   CTR-ROWS              
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
       5000-UPDATE-PROCESS.                                             
                                                                        
           EVALUATE TRUE                                                
              WHEN PARM-PROCESSING-FLAG = INSERT-FLAG                   
                  PERFORM 7000-CHECK-JOB-PARM    THRU 7000-EXIT         
      *           CHECK ALREADY ROW EXIST.                              06313517
                  IF  WS-JOB-PARM-EXISTS = 'Y'                          
                      MOVE ZEROS                 TO S-RETURN-CODE       
                      MOVE ZEROS                 TO S-APPL-RETURN-CODE  
                      MOVE 'JP00000003'          TO S-BUS-RULE-ID       
                      MOVE 'F'                   TO S-BUS-RULE-RESULT-CD
                      IF S-BUS-RULE-ID > SPACES                         
                         PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT   
                      END-IF                                            
                      ADD +1                     TO   CTR-ROWS          
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                  END-IF                                                
                                                                        
                  IF G6-SEQ-NO = 0 THEN                                 
                     PERFORM 7100-GET-MAX-SEQ-NO THRU 7100-EXIT         
                     COMPUTE G6-SEQ-NO = WS-MAX-SEQ-NO + 10.0           
                  END-IF                                                
                                                                        
                  PERFORM 8200-INSERT-JOB-PARM   THRU 8200-EXIT         
                                                                        
              WHEN PARM-PROCESSING-FLAG = UPDATE-FLAG                   
                  PERFORM 7000-CHECK-JOB-PARM    THRU 7000-EXIT         
      *           CHECK IF ROW NOT EXISTS.                              06313517
                  IF  WS-JOB-PARM-EXISTS = 'N'                          
                      MOVE ZEROS                 TO S-RETURN-CODE       
                      MOVE ZEROS                 TO S-APPL-RETURN-CODE  
                      MOVE 'JP00000004'          TO S-BUS-RULE-ID       
                      MOVE 'F'                   TO S-BUS-RULE-RESULT-CD
                      IF S-BUS-RULE-ID > SPACES                         
                         PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT   
                      END-IF                                            
                      ADD +1                     TO   CTR-ROWS          
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                  END-IF                                                
                                                                        
                  PERFORM 8210-UPDATE-JOB-PARM   THRU 8210-EXIT         
                                                                        
              WHEN PARM-PROCESSING-FLAG = DELETE-FLAG                   
      *           CHECK IF ROW NOT EXISTS.                              06313517
                  PERFORM 7000-CHECK-JOB-PARM    THRU 7000-EXIT         
                  IF  WS-JOB-PARM-EXISTS = 'N'                          
                      MOVE ZEROS                 TO S-RETURN-CODE       
                      MOVE ZEROS                 TO S-APPL-RETURN-CODE  
                      MOVE 'JP00000004'          TO S-BUS-RULE-ID       
                      MOVE 'F'                   TO S-BUS-RULE-RESULT-CD
                      IF S-BUS-RULE-ID > SPACES                         
                         PERFORM 7020-GET-RULE-XREF-ID THRU 7020-EXIT   
                      END-IF                                            
                      ADD +1                     TO   CTR-ROWS          
                      PERFORM 9999-END-PROGRAM   THRU 9999-EXIT         
                  END-IF                                                
                                                                        
                  PERFORM 8220-DELETE-JOB-PARM   THRU 8220-EXIT         
                                                                        
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-CHECK-JOB-PARM                                            *        
      ******************************************************************        
       7000-CHECK-JOB-PARM.                                             
                                                                        
             EXEC SQL                                                   
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-JOB-PARM-EXISTS                              
                  FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                 WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME               
                   AND G6.COMPANY_NO   = :G6-COMPANY-NO                 
                   AND G6.CMND_CODE    = :G6-CMND-CODE                  
                   AND G6.SEQ_NO       = :G6-SEQ-NO                     
                                                  
                                                                 
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-JOB-PARM-EXISTS                                      
MFA-TR*           FROM CSS_JOB_PARM G6                                          
MFA-TR*          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                       
MFA-TR*            AND G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*            AND G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*            AND G6.SEQ_NO       = :G6-SEQ-NO                             
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE    
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
                 CONTINUE                                               
             ELSE                                                       
                 MOVE SPACES                TO ABEND-TABLES             
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                 MOVE '7000'                TO ACTIVE-PARAGRAPH         
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_JOB_PARM'        TO TABLE-1                  
                 MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1          
                 MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2          
                 MOVE 'CMND_CODE'           TO TABLE-ELEMENT-3          
                 MOVE 'SEQ_NO'              TO TABLE-ELEMENT-4          
                 MOVE G6-PROGRAM-NAME       TO HOSTVAR-ELEMENT-1        
                 MOVE G6-COMPANY-NO         TO HOSTVAR-ELEMENT-2        
                 MOVE G6-CMND-CODE          TO HOSTVAR-ELEMENT-3        
                 MOVE G6-SEQ-NO             TO HOSTVAR-ELEMENT-4        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
             END-IF.                                                    
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-MAX-SEQ-NO                                            *        
      ******************************************************************        
       7100-GET-MAX-SEQ-NO.                                             
                                                                        
             EXEC SQL                                                   
                SELECT TOP(1) MAX(G6.SEQ_NO)                                   
                  INTO :WS-MAX-SEQ-NO :WS-NULL-IND-01                    
                  FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                    
                 WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME               
                   AND G6.COMPANY_NO   = :G6-COMPANY-NO                 
                   AND G6.CMND_CODE    = :G6-CMND-CODE                  
                                                  
                                                                 
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT MAX(G6.SEQ_NO)                                           
MFA-TR*           INTO :WS-MAX-SEQ-NO:WS-NULL-IND-01                            
MFA-TR*           FROM CSS_JOB_PARM G6                                          
MFA-TR*          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                       
MFA-TR*            AND G6.COMPANY_NO   = :G6-COMPANY-NO                         
MFA-TR*            AND G6.CMND_CODE    = :G6-CMND-CODE                          
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE    
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
                 IF WS-NULL-IND-01 < 0                                  
                    MOVE ZERO               TO WS-MAX-SEQ-NO            
                 END-IF                                                 
             ELSE                                                       
                 MOVE SPACES                TO ABEND-TABLES             
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                 MOVE '7100'                TO ACTIVE-PARAGRAPH         
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_JOB_PARM'        TO TABLE-1                  
                 MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1          
                 MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2          
                 MOVE 'CMND_CODE'           TO TABLE-ELEMENT-3          
                 MOVE G6-PROGRAM-NAME       TO HOSTVAR-ELEMENT-1        
                 MOVE G6-COMPANY-NO         TO HOSTVAR-ELEMENT-2        
                 MOVE G6-CMND-CODE          TO HOSTVAR-ELEMENT-3        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
             END-IF.                                                    
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-CHECK-JOBS-USER                                           *        
      ******************************************************************        
       7010-CHECK-JOBS-USER.                                            
                                                                        
             EXEC SQL                                                   
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-USER-HAS-ACCESS                              
                  FROM CSS_JOBS_USER J0 WITH(READUNCOMMITTED)                   
                 WHERE ((J0.APPL_PROGRAM_ID = :J0-APPL-PROGRAM-ID       
                     AND J0.USER_ID         = :J0-USER-ID )             
                     OR (J0.APPL_PROGRAM_ID = 'ALL_PARMS'               
                     AND J0.USER_ID         = :J0-USER-ID ))            
                                                  
                                                                 
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-USER-HAS-ACCESS                                      
MFA-TR*           FROM CSS_JOBS_USER J0                                         
MFA-TR*          WHERE ((J0.APPL_PROGRAM_ID = :J0-APPL-PROGRAM-ID               
MFA-TR*              AND J0.USER_ID         = :J0-USER-ID )                     
MFA-TR*              OR (J0.APPL_PROGRAM_ID = 'ALL_PARMS'                       
MFA-TR*              AND J0.USER_ID         = :J0-USER-ID ))                    
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*          WITH UR                                                        
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE    
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
                 CONTINUE                                               
             ELSE                                                       
                 MOVE SPACES                TO ABEND-TABLES             
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                 MOVE '7010'                TO ACTIVE-PARAGRAPH         
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_JOBS_USER'       TO TABLE-1                  
                 MOVE 'USER_ID'             TO TABLE-ELEMENT-1          
                 MOVE J0-USER-ID            TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
             END-IF.                                                    
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7020-GET-RULE-XREF-ID.                                           
                                                                        
             EXEC SQL                                                   
                SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                 
                  INTO :S-BUS-RULE-XREF-ID                              
                  FROM CSS_BUS_RULE   [1R]                                
                      ,CSS_BUS_RULE_XREF [1T]                             
                 WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                  
                   AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                  
                                                  
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT BUS_RULE_XREF_ID                                         
MFA-TR*           INTO :S-BUS-RULE-XREF-ID                                      
MFA-TR*           FROM CSS_BUS_RULE   1R                                        
MFA-TR*               ,CSS_BUS_RULE_XREF 1T                                     
MFA-TR*          WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                          
MFA-TR*            AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                          
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE    
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                 CONTINUE                                               
             ELSE                                                       
                 MOVE SPACES                TO ABEND-TABLES             
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                 MOVE '7020'                TO ACTIVE-PARAGRAPH         
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE 'SELECT'              TO ABEND-FUNCTION           
                 MOVE 'CSS_BUS_RULE'        TO TABLE-1                  
                 MOVE 'BUS_RULE_ID'         TO TABLE-ELEMENT-1          
                 MOVE S-BUS-RULE-ID         TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
             END-IF.                                                    
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09925704
      * 8200-INSERT-JOB-PARM                                          * 09925804
      ******************************************************************09925904
       8200-INSERT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_JOB_PARM                                
                (                                                       
                   PROGRAM_NAME                                         
                  ,COMPANY_NO                                           
                  ,CMND_CODE                                            
                  ,SEQ_NO                                               
                  ,STATUS                                               
                  ,PARM_DATA                                            
                )                                                       
                VALUES                                                  
                (                                                       
                   :G6-PROGRAM-NAME                                     
                  ,:G6-COMPANY-NO                                       
                  ,:G6-CMND-CODE                                        
                  ,:G6-SEQ-NO                                           
                  ,:G6-STATUS                                           
                  ,:G6-PARM-DATA                                        
                )                                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE '8200'             TO ACTIVE-PARAGRAPH              
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'INSERT'           TO ABEND-FUNCTION                
               MOVE 'CSS_JOB_PARM'     TO TABLE-1                       
               MOVE 'PROGRAM_NAME'     TO TABLE-ELEMENT-1               
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2               
               MOVE 'CMND_CODE'        TO TABLE-ELEMENT-3               
               MOVE 'SEQ_NO'           TO TABLE-ELEMENT-4               
               MOVE G6-PROGRAM-NAME    TO HOSTVAR-ELEMENT-1             
               MOVE G6-COMPANY-NO      TO HOSTVAR-ELEMENT-2             
               MOVE G6-CMND-CODE       TO HOSTVAR-ELEMENT-3             
               MOVE G6-SEQ-NO          TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09925704
      * 8210-UPDATE-JOB-PARM                                          * 09925804
      ******************************************************************09925904
       8210-UPDATE-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_JOB_PARM                                     
                   SET STATUS       = :G6-STATUS                        
                      ,PARM_DATA    = :G6-PARM-DATA                     
                 WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                  
                   AND COMPANY_NO   = :G6-COMPANY-NO                    
                   AND CMND_CODE    = :G6-CMND-CODE                     
                   AND SEQ_NO       = :G6-SEQ-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE '8210'             TO ACTIVE-PARAGRAPH              
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'INSERT'           TO ABEND-FUNCTION                
               MOVE 'CSS_JOB_PARM'     TO TABLE-1                       
               MOVE 'PROGRAM_NAME'     TO TABLE-ELEMENT-1               
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2               
               MOVE 'CMND_CODE'        TO TABLE-ELEMENT-3               
               MOVE 'SEQ_NO'           TO TABLE-ELEMENT-4               
               MOVE G6-PROGRAM-NAME    TO HOSTVAR-ELEMENT-1             
               MOVE G6-COMPANY-NO      TO HOSTVAR-ELEMENT-2             
               MOVE G6-CMND-CODE       TO HOSTVAR-ELEMENT-3             
               MOVE G6-SEQ-NO          TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09925704
      * 8220-DELETE-JOB-PARM                                          * 09925804
      ******************************************************************09925904
       8220-DELETE-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_JOB_PARM                                
                 WHERE PROGRAM_NAME = :G6-PROGRAM-NAME                  
                   AND COMPANY_NO   = :G6-COMPANY-NO                    
                   AND CMND_CODE    = :G6-CMND-CODE                     
                   AND SEQ_NO       = :G6-SEQ-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
               MOVE SPACES             TO ABEND-TABLES                  
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
               MOVE '8220'             TO ACTIVE-PARAGRAPH              
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE 'DELETE'           TO ABEND-FUNCTION                
               MOVE 'CSS_JOB_PARM'     TO TABLE-1                       
               MOVE 'PROGRAM_NAME'     TO TABLE-ELEMENT-1               
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2               
               MOVE 'CMND_CODE'        TO TABLE-ELEMENT-3               
               MOVE 'SEQ_NO'           TO TABLE-ELEMENT-4               
               MOVE G6-PROGRAM-NAME    TO HOSTVAR-ELEMENT-1             
               MOVE G6-COMPANY-NO      TO HOSTVAR-ELEMENT-2             
               MOVE G6-CMND-CODE       TO HOSTVAR-ELEMENT-3             
               MOVE G6-SEQ-NO          TO HOSTVAR-ELEMENT-4             
               PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT    
               PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10060000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     10070000
      ****************************************************************  10080000
                                                                        
           EXEC SQL                                                     10100000
             INCLUDE CPDSP300                                           10110000
           END-EXEC.                                                    10120000
                                                                        
      ****************************************************************  10140000
      *       END PROGRAM COPYLIB                                       10150000
      ****************************************************************  10160000
                                                                        
           EXEC SQL                                                     10180000
              INCLUDE CPD00321                                          10190000
           END-EXEC.                                                    10200000
                                                                        
