       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04497.                                         
       DATE-WRITTEN.  OCTOBER 25,2012.                                  
       DATE-COMPILED.                                                   
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA BUSOP.                           *00100000
      *                                                                *00110000
      *  PROGRAM:       CSR04497                                       *00130001
      *  CALLING SP:    UPDACCTMNTARTRANSHISTDTLS                      *00140002
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *        
      *  THE PROGRAM UPDATES CSS_AR_TRANS_HIST TABLE AND INSERTS ROW   *00180000
      *  IN THE MAINTANENCE HISTORY TABLE.                             *00180000
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ------------------                                            *        
      *  ACCOUNT_NO          CHAR(13)                                  *        
      *  TRANS_SEQ_NO        CHAR(26)                                  *        
      *  USER_ID             CHAR(07)                                  *        
      *  COMMENT_TEXT        CHAR(210)                                 *        
      *  AMT_BILLED_UNPAID   DECIMAL(11,2)                             *        
      *  PYMT_REF_IND        CHAR(01)                                  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
PRJ743*  10/25/12  AS7C117    INITIAL PROGRAM VERSION                  *00240000
      ******************************************************************00320000
                                                                        
      ******************************************************************00330000
      *                                                                *00340000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350000
      *                                                                *00360000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390000
      *  3000 - 4999  NOT USED                                         *00400000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420000
      *  7000 - 7999  INPUT MODULES                                    *00430000
      *  8000 - 8999  OUTPUT MODULES                                   *00440000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450000
      *                                                                *00460000
      ******************************************************************00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04497'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04497 STARTS HERE'.                  
                                                                        
      ******************************************************************01080000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090000
      ******************************************************************01100000
                                                                        
          COPY CWS00303.                                                01170000
                                                                        
      ******************************************************************01240000
      *    WORK AREAS                                                  *01250000
      ******************************************************************01260000
                                                                        
       01  FILLER                       PIC X(11)      VALUE            
                                                       'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(09)     COMP.            
           05  WS-ACCOUNT-NO-C          PIC X(13).                      
           05  WS-ACCOUNT-NO REDEFINES WS-ACCOUNT-NO-C                  
                                        PIC S9(13).                     
           05  WS-AMT-BILLED-UNPAID     PIC S9(9)V9(2) USAGE COMP-3     
                                                       VALUE 0.         
           05  WS-PYMT-REF-IND          PIC X(01)      VALUE SPACES.    
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                 PIC S9(9)      COMP.            
                                                                        
       01  COUNTER-FLAG.                                                
           05  CTR-ROWS                 PIC S9(9)      COMP             
                                                       VALUE 0.         
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS          PIC S9(9)      COMP.            
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08)      VALUE 'CSR04497'.
           05  WS-PROGRAM-NAME          PIC X(08)      VALUE 'CSR04497'.
           05  ALL-DONE-SW              PIC X(01)      VALUE 'N'.       
               88 NOT-ALL-DONE                         VALUE 'N'.       
               88 ALL-DONE                             VALUE 'Y'.       
           05  SEND-DONE-SW             PIC X(01)      VALUE 'Y'.       
               88 SEND-DONE-ERROR                      VALUE 'N'.       
               88 SEND-DONE-OK                         VALUE 'Y'.       
                                                                        
       01  WS-WORK-FIELDS.                                              
           05 WS-F                        PIC X(01)  VALUE 'F'.         
           05 WS-PYMT-REFUNDED-IND        PIC X(01)  VALUE SPACES.      
           05 WS-COMP-2-CHAR-CONV         PIC -Z(08)9.99.               
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(9) COMP  VALUE 0.      
           05  S-APPL-RETURN-CODE         PIC S9(9) COMP  VALUE 0.      
           05  S-BUS-RULE-ID              PIC X(10) VALUE SPACE.        
           05  S-BUS-RULE-RESULT-CD       PIC X(08) VALUE SPACE.        
           05  S-BUS-RULE-XREF-ID         PIC X(26) VALUE SPACE.        
                                                                        
      ******************************************************************00560000
      * DB2 INCLUDES                                                   *00570000
      ******************************************************************00580000
           EXEC SQL                                                     00600000
                INCLUDE SQLCA                                           00610000
           END-EXEC.                                                    00620000
                                                                        
      *************************************************************             
      * CSS_AR_TRANS_HIST                                         *             
      *************************************************************             
           EXEC SQL                                                     00840000
                INCLUDE TBARHIST                                        00850000
           END-EXEC.                                                    00860000
                                                                        
      *************************************************************             
      *    CSS_ACCOUNT        AT                                  *             
      *************************************************************             
           EXEC SQL                                                     00840000
              INCLUDE TBACCT                                            00850000
           END-EXEC.                                                    00860000
                                                                        
      *************************************************************     02010000
      *    CSS_AR_LOCKOUT     AL                                  *     02011000
      *************************************************************     02012000
           EXEC SQL                                                     02020000
              INCLUDE TBARLOCK                                          02030000
           END-EXEC.                                                    02040000
      *************************************************************             
      *    CSS_MNT_TRANS_HIST MH                                  *             
      *************************************************************             
           EXEC SQL                                                     00840000
              INCLUDE TBMNHIST                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      *************************************************************             
      *    CSS_MT_TRN_HST_DET MI                                  *             
      *************************************************************             
           EXEC SQL                                                     00840000
              INCLUDE TBMNHDT                                           00850000
           END-EXEC.                                                    00860000
                                                                        
      ******************************************************************        
      * CSS_USER_PROFILE   PF                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO          PIC X(13)                .          
       01  PARM-TRANS-SEQ-NO        PIC X(26)                .          
       01  PARM-USER-ID             PIC X(07)                .          
       01  PARM-COMMENT-TEXT        PIC X(210)               .          
COB305 01 PARM-AMT-BILLED-UNPAID        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.        
       01  PARM-PYMT-REF-IND        PIC X(01)                .          
                                                                        
       PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
                                ,PARM-TRANS-SEQ-NO                      
                                ,PARM-USER-ID                           
                                ,PARM-COMMENT-TEXT                      
                                ,PARM-AMT-BILLED-UNPAID                 
                                ,PARM-PYMT-REF-IND.                     
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      ******************************************************************02170000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT              
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT              
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT              
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290000
      * 0100-INITIALIZE                                                *02300000
      ******************************************************************02370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC               
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC               
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC               
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE               AS RETURN_CODE        
                    ,:S-APPL-RETURN-CODE          AS APPL_RETURN_CO     
                    ,LTRIM(RTRIM(:S-BUS-RULE-ID))        AS BUS_RULE_ID        
                    ,LTRIM(RTRIM(:S-BUS-RULE-RESULT-CD)) AS 
           BUS_RULE_RESULT_CD 
                    ,LTRIM(RTRIM(:S-BUS-RULE-XREF-ID))   AS 
           BUS_RULE_XREF_ID   
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE               AS RETURN_CODE                
MFA-TR*             ,:S-APPL-RETURN-CODE          AS APPL_RETURN_CO             
MFA-TR*             ,STRIP(:S-BUS-RULE-ID)        AS BUS_RULE_ID                
MFA-TR*             ,STRIP(:S-BUS-RULE-RESULT-CD) AS BUS_RULE_RESULT_CD         
MFA-TR*             ,STRIP(:S-BUS-RULE-XREF-ID)   AS BUS_RULE_XREF_ID           
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02650000
      * 1000-PROCESS-INPUT                                             *02660000
      *                                                                *        
      ******************************************************************02700000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO-C          
           MOVE WS-ACCOUNT-NO               TO AT-ACCOUNT-NO            
                                               AR-ACCOUNT-NO            
           MOVE PARM-TRANS-SEQ-NO           TO AR-TRANS-HIST-SEQ-NO     
           MOVE PARM-USER-ID                TO PF-USER-ID               
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      *                                                                *05130000
      ******************************************************************05190000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2010-CHECK-LOCK-OUT        THRU 2010-EXIT            
           PERFORM 2200-PROCESS-DETAIL        THRU 2200-EXIT            
           ADD +1                          TO CTR-ROWS.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03410000
      *                                                                *03411000
      * 2010-CHECK-LOCK-OUT                                            *03420000
      ******************************************************************03430000
       2010-CHECK-LOCK-OUT.                                             
                                                                        
           PERFORM 7999-SELECT-AL            THRU 7999-SELECT-AL-EXIT.  
                                                                        
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE ZEROS                     TO   S-RETURN-CODE         
              MOVE ZEROS                     TO   S-APPL-RETURN-CODE    
              MOVE 'AM00000005'              TO   S-BUS-RULE-ID         
              MOVE 'F'                       TO   S-BUS-RULE-RESULT-CD  
              IF S-BUS-RULE-ID > SPACES                                 
                 PERFORM 7020-GET-RULE-XREF-ID    THRU 7020-EXIT        
              END-IF                                                    
              ADD +1                         TO   CTR-ROWS              
              PERFORM 9999-END-PROGRAM            THRU 9999-EXIT        
           ELSE                                                         
              CONTINUE                                                  
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS-DETAIL                                            *        
      * UPDATES THE AR TRANS HIST DETAIL AND CREATES A ROW IN          *        
      * MAINTANENCE HISTORY TABLE.                                     *        
      ******************************************************************        
       2200-PROCESS-DETAIL.                                             
                                                                        
           PERFORM 7100-SELECT-AR-TRAN-HIST-DTLS THRU 7100-EXIT.        
           MOVE AR-AMT-BILLED-UNPAID        TO WS-AMT-BILLED-UNPAID.    
           MOVE AR-PYMT-REFUNDED-IND        TO WS-PYMT-REFUNDED-IND.    
                                                                        
           IF PARM-AMT-BILLED-UNPAID NOT EQUAL AR-AMT-BILLED-UNPAID OR  
              PARM-PYMT-REF-IND      NOT EQUAL AR-PYMT-REFUNDED-IND     
              PERFORM 7000-SELECT-ACCOUNT   THRU 7000-EXIT              
              PERFORM 7200-GET-RESP-ARE-ID  THRU 7200-EXIT              
              PERFORM 2300-MOVE-TRAN-HEAD   THRU 2300-EXIT              
              MOVE PARM-COMMENT-TEXT        TO AR-TRAN-COMMENT-TEXT     
              MOVE LENGTH OF AR-TRAN-COMMENT-TEXT                       
                                            TO AR-TRAN-COMMENT-LEN      
              MOVE PARM-AMT-BILLED-UNPAID   TO AR-AMT-BILLED-UNPAID     
              MOVE PARM-PYMT-REF-IND        TO AR-PYMT-REFUNDED-IND     
              PERFORM 8000-UPDATE           THRU 8000-EXIT              
              PERFORM 2400-MOVE-TRAN-DET    THRU 2400-EXIT              
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-MOVE-TRAN-HEAD                                            *        
      * MOVES THE DETAILS TO THE MAINTANENCE HISTORY TABLE             *        
      ******************************************************************        
       2300-MOVE-TRAN-HEAD.                                             
                                                                        
           MOVE WS-F                        TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE AT-CUSTOMER-NO              TO MH-CUSTOMER-NO.          
           MOVE AT-PREMISE-NO               TO MH-PREMISE-NO.           
           MOVE PARM-USER-ID                TO MH-USER-ID.              
           MOVE 'CSR04497'                  TO MH-APPL-PROGRAM-ID.      
           MOVE PARM-COMMENT-TEXT           TO MH-TRAN-COMMENT-TEXT.    
           MOVE LENGTH OF MH-TRAN-COMMENT-TEXT                          
                                            TO MH-TRAN-COMMENT-LEN.     
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-MOVE-TRAN-DET.                                            *        
      * MOVES THE DETAILS TO THE MAINTANENCE HISTORY DETAIL TABLE      *        
      ******************************************************************        
       2400-MOVE-TRAN-DET.                                              
                                                                        
           IF PARM-AMT-BILLED-UNPAID NOT EQUAL WS-AMT-BILLED-UNPAID     
              MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO     
              ADD  1                        TO MI-TRAN-APPL-NO          
              MOVE '48'                     TO MI-TABLE-ID              
              MOVE PARM-AMT-BILLED-UNPAID   TO WS-COMP-2-CHAR-CONV      
              MOVE WS-COMP-2-CHAR-CONV      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                   
                                            TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-AMT-BILLED-UNPAID     TO WS-COMP-2-CHAR-CONV      
              MOVE WS-COMP-2-CHAR-CONV      TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                   
                                            TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'AMTBILLEDUNPAID'        TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF                                                       
                                                                        
           IF PARM-PYMT-REF-IND NOT EQUAL WS-PYMT-REFUNDED-IND          
              MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO     
              ADD  1                        TO MI-TRAN-APPL-NO          
              MOVE '48'                     TO MI-TABLE-ID              
              MOVE PARM-PYMT-REF-IND        TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-PYMT-REFUNDED-IND     TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 'PYMT REF IND'           TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * INCLUDING THE COPY BOOK TO INSERT DETAILS INTO THE MAINTANENCE *        
      * TRANSACTION DETAILS                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT.                                           *        
      *                                                                *        
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT PREMISE_NO                                         
                    ,CUSTOMER_NO                                        
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :AT-PREMISE-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:MH-TRANS-HIST-SEQ-NO                              
                    ,:MH-DATE-TRANS                                     
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04460001
MFA-TR*       SELECT PREMISE_NO                                         04470001
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,CURRENT TIMESTAMP                                          
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*         INTO :AT-PREMISE-NO                                             
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:MH-TRANS-HIST-SEQ-NO                                      
MFA-TR*             ,:MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC                                                     04480001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7000'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7020-GET-RULE-XREF-ID                                          *        
      ******************************************************************        
       7020-GET-RULE-XREF-ID.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :S-BUS-RULE-XREF-ID                                
                FROM CSS_BUS_RULE   [1R]                                  
                    ,CSS_BUS_RULE_XREF [1T]                               
               WHERE [1R].BUS_RULE_ID = :S-BUS-RULE-ID                    
                 AND [1R].BUS_RULE_ID = [1T].BUS_RULE_ID                    
                                                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :S-BUS-RULE-XREF-ID                                        
MFA-TR*         FROM CSS_BUS_RULE   1R                                          
MFA-TR*             ,CSS_BUS_RULE_XREF 1T                                       
MFA-TR*        WHERE 1R.BUS_RULE_ID = :S-BUS-RULE-ID                            
MFA-TR*          AND 1R.BUS_RULE_ID = 1T.BUS_RULE_ID                            
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
               MOVE '7020'                TO ACTIVE-PARAGRAPH           
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_BUS_RULE'        TO TABLE-1                    
               MOVE 'BUS_RULE_XREF_ID'    TO TABLE-ELEMENT-1            
               MOVE S-BUS-RULE-XREF-ID    TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-AR-TRAN-HIST-DTLS                                  *        
      *                                                                *        
      ******************************************************************        
       7100-SELECT-AR-TRAN-HIST-DTLS.                                   
                                                                        
           EXEC SQL                                                     
              SELECT AMT_BILLED_UNPAID                                  
                    ,TRAN_COMMENT                                       
                    ,PYMT_REFUNDED_IND                                  
                INTO :AR-AMT-BILLED-UNPAID                              
                    ,:AR-TRAN-COMMENT                                   
                    ,:AR-PYMT-REFUNDED-IND                              
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO         = :AR-ACCOUNT-NO                
                 AND TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04460001
MFA-TR*       SELECT AMT_BILLED_UNPAID                                  04470001
MFA-TR*             ,TRAN_COMMENT                                               
MFA-TR*             ,PYMT_REFUNDED_IND                                          
MFA-TR*         INTO :AR-AMT-BILLED-UNPAID                                      
MFA-TR*             ,:AR-TRAN-COMMENT                                           
MFA-TR*             ,:AR-PYMT-REFUNDED-IND                                      
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*        WHERE ACCOUNT_NO         = :AR-ACCOUNT-NO                        
MFA-TR*          AND TRANS_HIST_SEQ_NO  = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC                                                     04480001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04490001
           MOVE SQLCODE              TO    WS-ACTIVE-RETURN-CODE        
                                           S-RETURN-CODE                
      *                                                                 04510001
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE '7100'                       TO ACTIVE-PARAGRAPH    
               MOVE 'SELECT'                     TO ABEND-FUNCTION      
               MOVE 'CSS_AR_TRANS_HIST'          TO TABLE-1             
               MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
               MOVE 'DATE_TRANS'                 TO TABLE-ELEMENT-2     
               MOVE AR-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
               MOVE AR-TRANS-HIST-SEQ-NO         TO HOSTVAR-ELEMENT-2   
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      * 7200-GET-RESP-ARE-ID.                                        *          
      ****************************************************************          
       7200-GET-RESP-ARE-ID.                                            
                                                                        
           EXEC SQL                                                     
              SELECT PF.RESP_AREA_ID                                    
                  INTO :PF-RESP-AREA-ID                                 
                  FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                
                 WHERE USER_ID    = :PF-USER-ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PF.RESP_AREA_ID                                            
MFA-TR*           INTO :PF-RESP-AREA-ID                                         
MFA-TR*           FROM CSS_USER_PROFILE PF                                      
MFA-TR*          WHERE USER_ID    = :PF-USER-ID                                 
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL  SUCCESSFUL-CALL              
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_USER_PROFILE'  TO TABLE-1                       
              MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
              MOVE PF-USER-ID          TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT         THRU 9000-EXIT     
              PERFORM 9900-SQL-ERROR-ROUTINE         THRU 9900-EXIT     
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-UPDATE                                                    *        
      * MOVES THE DETAILS TO UPDATE AR TRANS HIST TABLE.               *        
      ******************************************************************        
       8000-UPDATE.                                                     
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_AR_TRANS_HIST                                
                   SET AMT_BILLED_UNPAID  = :AR-AMT-BILLED-UNPAID       
                      ,TRAN_COMMENT       = :AR-TRAN-COMMENT            
                      ,PYMT_REFUNDED_IND  = :AR-PYMT-REFUNDED-IND       
                 WHERE ACCOUNT_NO         = :AR-ACCOUNT-NO              
                   AND TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_AR_TRANS_HIST                                        
MFA-TR*            SET AMT_BILLED_UNPAID  = :AR-AMT-BILLED-UNPAID               
MFA-TR*               ,TRAN_COMMENT       = :AR-TRAN-COMMENT                    
MFA-TR*               ,PYMT_REFUNDED_IND  = :AR-PYMT-REFUNDED-IND               
MFA-TR*          WHERE ACCOUNT_NO         = :AR-ACCOUNT-NO                      
MFA-TR*            AND TRANS_HIST_SEQ_NO  = :AR-TRANS-HIST-SEQ-NO               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   S-RETURN-CODE.       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '8000'                      TO ACTIVE-PARAGRAPH     
               MOVE 'UPDATE'                    TO ABEND-FUNCTION       
               MOVE 'CSS_AR_TRANS_HIST'         TO TABLE-1              
               MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1      
               MOVE 'DATE_TRANS'                TO TABLE-ELEMENT-2      
               MOVE AR-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1    
               MOVE AR-TRANS-HIST-SEQ-NO        TO HOSTVAR-ELEMENT-2    
               PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT       
               PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT       
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************  09288404
      * 7999-SELECT-AL AR LOCKOUT AND TRANSFER ROUTINE               *  09288504
      ****************************************************************  09289004
                                                                        
           EXEC SQL                                                     09300000
                INCLUDE CPD00075                                        09310000
           END-EXEC.                                                    09320000
                                                                        
      ******************************************************************16263003
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *16265003
      ******************************************************************16267003
           EXEC SQL                                                     16269003
                INCLUDE CPDSP300                                        16270003
           END-EXEC.                                                    16280003
                                                                        
      ******************************************************************16310003
      *       END PROGRAM COPYLIB                                      *16330003
      ******************************************************************16360003
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
