       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04496.                                         
COB303 DATE-WRITTEN.  DECEMBER 10, 2013.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES CUSTOMER INFORMATION.                    *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  12/10/13   FMB       NEW PROGRAM.                             *00290000
A05317*  3/7/2016   FMB       ZERO CUSTOMER NUMBER CHECK.              *00290000
ACT233*  08/05/16   TP7R341   REPLACE CSR00028 WITH CSR04675           *00290000
      ******************************************************************00230000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04496'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE BEGINS HERE'.                               
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00770000
              INCLUDE TBBSCSTS                                          00780000
           END-EXEC.                                                    00790000
           EXEC SQL                                                     00930000
              INCLUDE TBCSTMSC                                          00940000
           END-EXEC.                                                    00950000
           EXEC SQL                                                     00970000
              INCLUDE TBCSTPHN                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                     01010000
              INCLUDE TBCSTSTS                                          01020000
           END-EXEC.                                                    01030000
           EXEC SQL                                                     01050000
              INCLUDE TBCUST                                            01060000
           END-EXEC.                                                    01070000
           EXEC SQL                                                     01090000
              INCLUDE TBNAME                                            01100000
           END-EXEC.                                                    01110000
           EXEC SQL                                                     01130000
              INCLUDE TBNAMEID                                          01140000
           END-EXEC.                                                    01150000
           EXEC SQL                                                     01170000
              INCLUDE TBNMACTX                                          01180000
           END-EXEC.                                                    01190000
           EXEC SQL                                                     01210000
              INCLUDE TBCSTCTL                                          01220000
           END-EXEC.                                                    01230000
           EXEC SQL                                                     01250000
              INCLUDE TBUSRPRF                                          01260000
           END-EXEC.                                                    01270000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBMIAXRF                                          01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRHIST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRITPA                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUSXFR                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
ACT233*    COPY CCA00001.                                               01550000
                                                                        
           EXEC SQL                                                     01630000
              INCLUDE CWS0013A                                          01640000
           END-EXEC.                                                    01650000
           EXEC SQL                                                     01670000
              INCLUDE CWS00071                                          01680000
           END-EXEC.                                                    01690000
           EXEC SQL                                                     01710000
              INCLUDE CWS0091A                                          01720000
           END-EXEC.                                                    01730000
           EXEC SQL                                                     01750000
              INCLUDE CWS0093A                                          01760000
           END-EXEC.                                                    01770000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-NEW-CUSTOMER-NO-NUM   PIC 9(10).                      
           05  WS-NEW-CUSTOMER-NO-CHAR  REDEFINES WS-NEW-CUSTOMER-NO-NUM
                                        PIC X(10).                      
           05  WS-NEW-NAME-ID-NUM       PIC 9(13).                      
           05  WS-NEW-NAME-ID-CHAR      REDEFINES WS-NEW-NAME-ID-NUM    
                                        PIC X(13).                      
           05  WS-NEW-I-NAME-ID-NUM     PIC 9(13).                      
           05  WS-NEW-I-NAME-ID-CHAR    REDEFINES WS-NEW-I-NAME-ID-NUM  
                                        PIC X(13).                      
           05  WS-COMMENTS.                                             
               10 WS-COMMENTS-LEN       PIC S9(4) COMP.                 
               10 WS-COMMENTS-TEXT      PIC X(210).                     
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04496'.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
           05  WS-CSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CSTS-EXISTS                     VALUE 'YES'.          
           05  WS-BSTS-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 BSTS-EXISTS                     VALUE 'YES'.          
           05  WS-CUST-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 CUST-EXISTS                     VALUE 'YES'.          
           05  WS-MISC-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 MISC-EXISTS                     VALUE 'YES'.          
           05  WS-PHONE-EXISTS-FLAG     PIC X(03) VALUE 'NO '.          
               88 PHONE-EXISTS                    VALUE 'YES'.          
           05  WS-HMPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 HMPH-EXISTS                     VALUE 'YES'.          
           05  WS-WKPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 WKPH-EXISTS                     VALUE 'YES'.          
           05  WS-ALPH-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 ALPH-EXISTS                     VALUE 'YES'.          
           05  WS-NAME-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 NAME-EXISTS                     VALUE 'YES'.          
           05  WS-INDV-EXISTS-FLAG      PIC X(03) VALUE 'NO '.          
               88 INDV-EXISTS                     VALUE 'YES'.          
           05  WS-NULL-1                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-3                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-4                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-5                PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-10               PIC S9(04) COMP VALUE ZERO.     
           05  WS-SPOUSE-EXISTS         PIC X(01) VALUE 'N'.            
           05  WS-SPOUSE-NAME-ID        PIC S9(13) COMP-3 VALUE 0.      
           05  WS-CU-NAME-ID            PIC S9(13) COMP-3 VALUE 0.      
           05  WS-PHONE-TYPE            PIC X(02) VALUE SPACES.         
           05  WS-HOME-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-HOME-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-HOME-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-WORK-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-WORK-EXTENSION-NO     PIC X(06) VALUE SPACES.         
           05  WS-WORK-MOBILE-FL        PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-FL           PIC X(01) VALUE SPACES.         
           05  WS-WORK-MKT-DT           PIC X(10) VALUE SPACES.         
           05  WS-BUS-PHONE-NO          PIC X(10) VALUE SPACES.         
           05  WS-BUS-MOBILE-FL         PIC X(01) VALUE SPACES.         
           05  WS-BUS-MKT-FL            PIC X(01) VALUE SPACES.         
           05  WS-BUS-MKT-DT            PIC X(10) VALUE SPACES.         
           05  WS-ALT-PHONE-NO          PIC X(10) VALUE SPACES.         
           05  WS-ALT-MOBILE-FL         PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-FL            PIC X(01) VALUE SPACES.         
           05  WS-ALT-MKT-DT            PIC X(10) VALUE SPACES.         
           05  WS-SHORT-NAME            PIC X(50) VALUE SPACES.         
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-WQ-COMMENTS-1.                                        
               10  F                    PIC X(11) VALUE                 
                   'CUSTOMER # '.                                       
               10  WS-WQ-CUST-1         PIC X(10).                      
               10  F                    PIC X(90) VALUE                 
           ' HAS REFUSED TO PROVIDE THEIR SSN. APPLICATION MUST BE COMPL        
      -    'ETED IN A BUSINESS OFFICE.'.                                        
           05  WS-WQ-COMMENTS-2.                                        
               10  F                    PIC X(11) VALUE                 
                   'CUSTOMER # '.                                       
               10  WS-WQ-CUST-2         PIC X(10).                      
               10  F                    PIC X(60) VALUE                 
           ' HAS REFUSED TO PROVIDE THEIR SSN. INVESTIGATION REQUIRED.'.
           05  WS-WQ-COMMENTS-3.                                        
               10  F                    PIC X(25) VALUE                 
                   'ITPA RECEIVED ON CUST NO '.                         
               10  WS-WQ-CUST-3         PIC X(10).                      
               10  F                    PIC X(12) VALUE                 
                   ',SSN ***-**-'.                                      
               10  WS-WQ-SSN-3          PIC X(04).                      
               10  F                    PIC X(60) VALUE                 
         '. RESEARCH REASON SSN CHANGED. REMOVE INQUIRY IF NECESSARY.'. 
           05  WS-WQ-COMMENTS-4.                                        
               10  F                    PIC X(40) VALUE                 
                   'APPLICATION STATUS ON HOLD FOR CUST NO '.           
               10  WS-WQ-CUST-4         PIC X(10).                      
               10  F                    PIC X(12) VALUE                 
                   ',SSN ***-**-'.                                      
               10  WS-WQ-SSN-4          PIC X(04).                      
               10  F                    PIC X(60) VALUE                 
         '. RESEARCH REASON SSN CHANGED. REMOVE INQUIRY IF NECESSARY.'. 
           05  WS-MISC-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 MISC-CHANGED                    VALUE 'YES'.          
           05  WS-NAME-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 NAME-CHANGED                    VALUE 'YES'.          
           05  WS-CSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CSTS-CHANGED                    VALUE 'YES'.          
           05  WS-BSTS-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 BSTS-CHANGED                    VALUE 'YES'.          
           05  WS-CUST-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 CUST-CHANGED                    VALUE 'YES'.          
           05  WS-HPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 HPFL-CHANGED                    VALUE 'YES'.          
           05  WS-WPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 WPFL-CHANGED                    VALUE 'YES'.          
           05  WS-APFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 APFL-CHANGED                    VALUE 'YES'.          
           05  WS-BPFL-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 BPFL-CHANGED                    VALUE 'YES'.          
           05  WS-REFSSN-CHANGED-FLAG   PIC X(03) VALUE 'NO '.          
               88 REFSSN-CHANGED                  VALUE 'YES'.          
           05  WS-SSN-CHANGED-FLAG      PIC X(03) VALUE 'NO '.          
               88 SSN-CHANGED                     VALUE 'YES'.          
           05  WS-INDV-CHANGED-FLAG     PIC X(03) VALUE 'NO '.          
               88 INDV-CHANGED                    VALUE 'YES'.          
           05  WS-ITPA-EXISTS-FL        PIC X(01) VALUE SPACES.         
           05  WS-DELETE-INDIV-FL       PIC X(01) VALUE SPACES.         
           05  WS-INDIV-BUS-DATA.                                       
               10  WS-FIRST-NAME        PIC X(15) VALUE SPACES.         
               10  WS-MIDDLE-NAME       PIC X(15) VALUE SPACES.         
               10  WS-LAST-NAME         PIC X(40) VALUE SPACES.         
               10  WS-TITLE             PIC X(9) VALUE SPACES.          
               10  WS-SUFFIX            PIC X(3) VALUE SPACES.          
                                                                        
ACT233 01  CSR04675-CALL-DATA.                                          
ACT233     05  IN-ITEM-ID-4675           PIC S9(10)V COMP-3 VALUE +0.   
ACT233     05  USER-ID-ASGN-4675         PIC X(07) VALUE SPACES.        
COB305     05 SERV-ORDER-NO-4675        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
ACT233     05  DATE-REQUIRED-4675        PIC X(26) VALUE SPACES.        
ACT233     05  CATEGORY-ID-4675          PIC S9(4) USAGE COMP.          
COB305     05 ACCOUNT-NO-4675        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 PREMISE-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 CUSTOMER-NO-4675        PIC S9(10)V USAGE COMP-3 VALUE 0.      
ACT233     05  USER-ID-ORIG-4675         PIC X(7) VALUE SPACES.         
ACT233     05  RESP-AREA-ID-4675         PIC X(3) VALUE SPACES.         
ACT233     05  LOCAL-OFFICE-4675         PIC X(3) VALUE SPACES.         
ACT233     05  ROUTING-CATEGORY-4675     PIC X(1) VALUE SPACES.         
ACT233     05  WQ-PRIORITY-4675          PIC X(1) VALUE SPACES.         
ACT233     05  DATE-CREATED-4675         PIC X(26) VALUE SPACES.        
ACT233     05  COMMENTS-4675.                                           
ACT233        49 COMMENTS-4675-LEN       PIC S9(4) USAGE COMP VALUE 0.  
ACT233        49 COMMENTS-4675-TEXT      PIC X(250) VALUE SPACES.       
ACT233     05  FREE-FORM-DATA-4675.                                     
ACT233        49 FREE-FORM-DATA-4675-LEN  PIC S9(4) USAGE COMP VALUE 0. 
ACT233        49 FREE-FORM-DATA-4675-TEXT PIC X(255) VALUE SPACES.      
ACT233     05  CREATED-BY-4675           PIC X(16) VALUE SPACES.        
                                                                        
ACT233 01  CSR04675-RETURN-DATA.                                        
ACT233     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT233     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-STATUS-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CUSTOMER-NO          PIC X(10) VALUE SPACES.          
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
ACT233*01 LOC4675 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4675 CURSOR
MSQ001          FOR CALL CSR04675                                             
ACT233            ( :IN-ITEM-ID-4675
                  , :ROUTING-CATEGORY-4675
                  , :LOCAL-OFFICE-4675
                  , :USER-ID-ORIG-4675
                  , :USER-ID-ASGN-4675
                  , :RESP-AREA-ID-4675
                  , :CATEGORY-ID-4675
                  , :ACCOUNT-NO-4675
                  , :PREMISE-NO-4675
                  , :CUSTOMER-NO-4675
                  , :SERV-ORDER-NO-4675
                  , :COMMENTS-4675
                  , :DATE-REQUIRED-4675
                  , :DATE-CREATED-4675
                  , :WQ-PRIORITY-4675
                  , :FREE-FORM-DATA-4675
                  , :CREATED-BY-4675
                  )
MSQ001        END-EXEC.
         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UPDATE-TYPE         PIC X(01).                          
       01  LINK-CUSTOMER-NO         PIC X(10).                          
       01  LINK-COMPANY-NO          PIC X(02).                          
       01  LINK-NAME-FORMAT         PIC X(01).                          
       01  LINK-TITLE               PIC X(09).                          
       01  LINK-FIRST-NAME          PIC X(15).                          
       01  LINK-MIDDLE-NAME         PIC X(15).                          
       01  LINK-LAST-NAME           PIC X(40).                          
       01  LINK-SUFFIX              PIC X(03).                          
       01  LINK-BUSINESS-NAME       PIC X(70).                          
       01  LINK-SSN                 PIC X(09).                          
       01  LINK-ITIN                PIC X(09).                          
       01  LINK-REFUSED-SSN         PIC X(01).                          
       01  LINK-TAX-ID              PIC X(09).                          
       01  LINK-DLN                 PIC X(19).                          
       01  LINK-DLN-STATE           PIC X(02).                          
       01  LINK-DATE-OF-BIRTH       PIC X(10).                          
       01  LINK-OTHER-ID-TYPE       PIC X(12).                          
       01  LINK-OTHER-ID            PIC X(16).                          
       01  LINK-WELCOME-KIT-CD      PIC X(01).                          
       01  LINK-DBA                 PIC X(70).                          
       01  LINK-WEBSITE             PIC X(75).                          
       01  LINK-SOS-STATUS-CD       PIC X(02).                          
       01  LINK-SOS-CONTROL-ID      PIC X(15).                          
       01  LINK-SOS-EFFECTIVE-DT    PIC X(10).                          
       01  LINK-KEY-CUSTOMER        PIC X(02).                          
       01  LINK-INFLUENTIAL-CUST    PIC X(02).                          
       01  LINK-SPECIAL-CUST        PIC X(02).                          
       01  LINK-BUILDER-FL          PIC X(01).                          
       01  LINK-LANDLORD-FL         PIC X(01).                          
       01  LINK-LL-REVERT-FL        PIC X(01).                          
       01  LINK-REALTOR-FL          PIC X(01).                          
       01  LINK-SEASONAL-FL         PIC X(01).                          
       01  LINK-ALLOW-CALL-FL       PIC X(01).                          
       01  LINK-ALLOW-EMAIL-FL      PIC X(01).                          
       01  LINK-WORK-PHONE-NO       PIC X(10).                          
       01  LINK-WORK-PHONE-EXT      PIC X(06).                          
       01  LINK-WORK-MOBILE-FL      PIC X(01).                          
       01  LINK-WORK-MKT-FL         PIC X(01).                          
       01  LINK-HOME-PHONE-NO       PIC X(10).                          
       01  LINK-HOME-MOBILE-FL      PIC X(01).                          
       01  LINK-HOME-MKT-FL         PIC X(01).                          
       01  LINK-ALT-PHONE-NO        PIC X(10).                          
       01  LINK-ALT-MOBILE-FL       PIC X(01).                          
       01  LINK-ALT-MKT-FL          PIC X(01).                          
       01  LINK-BUSINESS-TYPE-CD    PIC X(01).                          
       01  LINK-VERIFY-SSN-FL       PIC X(01).                          
       01  LINK-DHR-FL              PIC X(01).                          
       01  LINK-DOB-VERIFIED-CD     PIC X(01).                          
       01  LINK-EMPLOYER            PIC X(23).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-COMMENTS            PIC X(210).                         
       01  LINK-IB-TITLE            PIC X(09).                          
       01  LINK-IB-FIRST-NAME       PIC X(15).                          
       01  LINK-IB-MIDDLE-NAME      PIC X(15).                          
       01  LINK-IB-LAST-NAME        PIC X(40).                          
       01  LINK-IB-SUFFIX           PIC X(03).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-UPDATE-TYPE,                                       
                LINK-CUSTOMER-NO,                                       
                LINK-COMPANY-NO,                                        
                LINK-NAME-FORMAT,                                       
                LINK-TITLE,                                             
                LINK-FIRST-NAME,                                        
                LINK-MIDDLE-NAME,                                       
                LINK-LAST-NAME,                                         
                LINK-SUFFIX,                                            
                LINK-BUSINESS-NAME,                                     
                LINK-SSN,                                               
                LINK-ITIN,                                              
                LINK-REFUSED-SSN,                                       
                LINK-TAX-ID,                                            
                LINK-DLN,                                               
                LINK-DLN-STATE,                                         
                LINK-DATE-OF-BIRTH,                                     
                LINK-OTHER-ID-TYPE,                                     
                LINK-OTHER-ID,                                          
                LINK-WELCOME-KIT-CD,                                    
                LINK-DBA,                                               
                LINK-WEBSITE,                                           
                LINK-SOS-STATUS-CD,                                     
                LINK-SOS-CONTROL-ID,                                    
                LINK-SOS-EFFECTIVE-DT,                                  
                LINK-KEY-CUSTOMER,                                      
                LINK-INFLUENTIAL-CUST,                                  
                LINK-SPECIAL-CUST,                                      
                LINK-BUILDER-FL,                                        
                LINK-LANDLORD-FL,                                       
                LINK-LL-REVERT-FL,                                      
                LINK-REALTOR-FL,                                        
                LINK-SEASONAL-FL,                                       
                LINK-ALLOW-CALL-FL,                                     
                LINK-ALLOW-EMAIL-FL,                                    
                LINK-WORK-PHONE-NO,                                     
                LINK-WORK-PHONE-EXT,                                    
                LINK-WORK-MOBILE-FL,                                    
                LINK-WORK-MKT-FL,                                       
                LINK-HOME-PHONE-NO,                                     
                LINK-HOME-MOBILE-FL,                                    
                LINK-HOME-MKT-FL,                                       
                LINK-ALT-PHONE-NO,                                      
                LINK-ALT-MOBILE-FL,                                     
                LINK-ALT-MKT-FL,                                        
                LINK-BUSINESS-TYPE-CD,                                  
                LINK-VERIFY-SSN-FL,                                     
                LINK-DHR-FL,                                            
                LINK-DOB-VERIFIED-CD,                                   
                LINK-EMPLOYER,                                          
                LINK-USERID,                                            
                LINK-COMMENTS,                                          
                LINK-IB-TITLE,                                          
                LINK-IB-FIRST-NAME,                                     
                LINK-IB-MIDDLE-NAME,                                    
                LINK-IB-LAST-NAME,                                      
                LINK-IB-SUFFIX.                                         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE  AS RETURN_CODE,                  
                       :RS-STATUS-CODE AS STATUS_CODE,                  
                       :RS-CUSTOMER-NO AS CUSTOMER_NO                   
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE  AS RETURN_CODE,                          
MFA-TR*                :RS-STATUS-CODE AS STATUS_CODE,                          
MFA-TR*                :RS-CUSTOMER-NO AS CUSTOMER_NO                           
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * DATABASE VALUES                                                 05130000
      *   REFUSED SSN = SPACE OR Y                                      05130000
      *   ALLOW CALL  = SPACE OR N                                      05130000
      *   ALLOW EMAIL = SPACE OR N                                      05130000
      *   VERIFY SSN  = SPACE OR N                                      05130000
      *   DOB VERIFIED = SPACE OR D                                     05130000
      *   DHR FLAG = Y OR N                                             05130000
      *   CONSENT FLAGS = SPACE, N, OR Y                                05130000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR                 
                                    WS-WQ-CUST-1                        
                                    WS-WQ-CUST-2                        
                                    WS-WQ-CUST-3                        
                                    WS-WQ-CUST-4.                       
           MOVE LINK-COMMENTS TO WS-COMMENTS.                           
           IF LINK-DOB-VERIFIED-CD = 'N'                                
               MOVE SPACES TO LINK-DOB-VERIFIED-CD
           END-IF.                     
           IF LINK-DOB-VERIFIED-CD = 'Y'                                
               MOVE 'D' TO LINK-DOB-VERIFIED-CD
           END-IF.                        
           IF LINK-VERIFY-SSN-FL = 'Y'                                  
               MOVE ' ' TO LINK-VERIFY-SSN-FL
           END-IF.                          
           IF LINK-ALLOW-CALL-FL = 'Y'                                  
               MOVE ' ' TO LINK-ALLOW-CALL-FL
           END-IF.                          
           IF LINK-ALLOW-EMAIL-FL = 'Y'                                 
               MOVE ' ' TO LINK-ALLOW-EMAIL-FL
           END-IF.                         
           IF LINK-DHR-FL <= ' '                                        
               MOVE 'N' TO LINK-DHR-FL
           END-IF.                                 
           IF LINK-REFUSED-SSN = 'N'                                    
               MOVE ' ' TO LINK-REFUSED-SSN
           END-IF.                            
           IF LINK-LL-REVERT-FL <= ' '                                  
               MOVE 'N' TO LINK-LL-REVERT-FL
           END-IF.                           
           IF LINK-BUILDER-FL <= ' '                                    
               MOVE 'N' TO LINK-BUILDER-FL
           END-IF.                             
           IF LINK-LANDLORD-FL <= ' '                                   
               MOVE 'N' TO LINK-LANDLORD-FL
           END-IF.                            
           IF LINK-REALTOR-FL <= ' '                                    
               MOVE 'N' TO LINK-REALTOR-FL
           END-IF.                             
           IF LINK-SEASONAL-FL <= ' '                                   
               MOVE 'N' TO LINK-SEASONAL-FL
           END-IF.                            
           IF LINK-WORK-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-WORK-PHONE-EXT                       
                              LINK-WORK-MOBILE-FL                       
                              LINK-WORK-MKT-FL
           END-IF.                         
           IF LINK-HOME-PHONE-NO <= SPACES                              
               MOVE SPACES TO LINK-HOME-MOBILE-FL                       
                              LINK-HOME-MKT-FL
           END-IF.                         
           IF LINK-ALT-PHONE-NO <= SPACES                               
               MOVE SPACES TO LINK-ALT-MOBILE-FL                        
                              LINK-ALT-MKT-FL
           END-IF.                          
           IF LINK-NAME-FORMAT = 'I' OR 'B'                             
               NEXT SENTENCE                                            
           ELSE                                                         
              IF LINK-LAST-NAME > ' '                                   
                  MOVE 'I' TO LINK-NAME-FORMAT                          
              ELSE                                                      
                  MOVE 'B' TO LINK-NAME-FORMAT
              END-IF
           END-IF.                         
           INSPECT LINK-FIRST-NAME REPLACING ALL '~' BY '-'.            
           INSPECT LINK-MIDDLE-NAME REPLACING ALL '~' BY '-'.           
           INSPECT LINK-LAST-NAME REPLACING ALL '~' BY '-'.             
           INSPECT LINK-BUSINESS-NAME REPLACING ALL '~' BY '-'.         
           INSPECT LINK-DBA REPLACING ALL '~' BY '-'.                   
           IF LINK-IB-FIRST-NAME = SPACES AND                           
              LINK-IB-MIDDLE-NAME = SPACES AND                          
              LINK-IB-LAST-NAME = SPACES AND                            
              LINK-IB-TITLE = SPACES AND                                
              LINK-IB-SUFFIX = SPACES                                   
                  MOVE 'Y' TO WS-DELETE-INDIV-FL
           END-IF.                       
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
           PERFORM 7080-SELECT-RESP-AREA-ID THRU 7080-EXIT.             
           PERFORM 1100-TRANSHIST-HEADER THRU 1100-EXIT.                
                                                                        
           MOVE 1 TO WS-TRAN-APPL-NO                                    
                     MI-TRAN-APPL-NO.                                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-TRANSHIST-HEADER.                                           
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TIMESTAMP     TO MH-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-ACCOUNT-NO               
                                            MH-PREMISE-NO.              
           MOVE LINK-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL087'               TO MH-APPL-PROGRAM-ID.         
           MOVE WS-COMMENTS-LEN          TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-COMMENTS-TEXT         TO MH-TRAN-COMMENT-TEXT.       
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE LINK-UPDATE-TYPE                                    
               WHEN 'I'                                                 
                   PERFORM 3000-INSERT-CUSTOMER THRU 3000-EXIT          
               WHEN 'U'                                                 
A05317             IF WS-CUSTOMER-NO-NUM > ZEROES                       
                      PERFORM 3100-UPDATE-CUSTOMER THRU 3100-EXIT       
A05317             END-IF                                               
               WHEN 'D'                                                 
A05317             IF WS-CUSTOMER-NO-NUM > ZEROES                       
                       PERFORM 3200-DELETE-CUSTOMER THRU 3200-EXIT      
A05317             END-IF                                               
               WHEN 'V'                                                 
A05317             IF WS-CUSTOMER-NO-NUM > ZEROES                       
                       PERFORM 3300-VALIDATE-CUSTOMER THRU 3300-EXIT    
A05317             END-IF                                               
               WHEN OTHER                                               
                   PERFORM 3400-INVALID-ACTION THRU 3400-EXIT           
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-INSERT-CUSTOMER.                                            
                                                                        
           PERFORM 6602-GET-NEW-CUSTOMER-NO THRU 6602-EXIT.             
           MOVE WS-93-NEW-CUSTOMER-NO TO WS-NEW-CUSTOMER-NO-NUM.        
           MOVE WS-NEW-CUSTOMER-NO-CHAR TO RS-CUSTOMER-NO.              
           MOVE WS-NEW-CUSTOMER-NO-NUM TO MH-CUSTOMER-NO.               
                                                                        
           PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT.                 
           MOVE WS-91-NEW-NAME-ID TO WS-NEW-NAME-ID-NUM.                
                                                                        
           IF LINK-IB-LAST-NAME > SPACES                                
               PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT              
               MOVE WS-91-NEW-NAME-ID TO WS-NEW-I-NAME-ID-NUM
           END-IF.          
                                                                        
                                                                        
           PERFORM 5000-TRANSHIST-FOR-INSERT THRU 5000-EXIT.            
                                                                        
           IF LINK-IB-LAST-NAME > SPACES                                
               STRING LINK-IB-FIRST-NAME(1:1)                           
                      ' '                                               
                      LINK-IB-LAST-NAME                                 
                      DELIMITED BY SIZE                                 
                      INTO WS-SHORT-NAME                                
               END-STRING                                               
           ELSE                                                         
               MOVE SPACES TO WS-SHORT-NAME
           END-IF.                            
                                                                        
           MOVE WS-NEW-NAME-ID-NUM       TO DQ-NAME-ID.                 
           MOVE 'CN'                     TO DQ-NAME-TYPE.               
           MOVE LINK-NAME-FORMAT         TO DQ-NAME-FORMAT.             
           IF LINK-NAME-FORMAT = 'B'                                    
               MOVE LINK-BUSINESS-NAME   TO DQ-FULL-NAME                
           ELSE                                                         
               MOVE SPACES               TO DQ-FULL-NAME
           END-IF.               
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           MOVE LINK-FIRST-NAME          TO DQ-FIRST-NAME.              
           MOVE LINK-MIDDLE-NAME         TO DQ-MIDDLE-NAME.             
           MOVE LINK-LAST-NAME           TO DQ-LAST-NAME.               
           MOVE LINK-TITLE               TO DQ-TITLE-PREFIX.            
           MOVE LINK-SUFFIX              TO DQ-TITLE-SUFFIX-1.          
           MOVE SPACES                   TO DQ-TITLE-SUFFIX-2.          
           MOVE WS-CURRENT-TIMESTAMP     TO DQ-CREATED-DATE.            
           MOVE WS-SHORT-NAME            TO DQ-NICKNAME.                
           PERFORM 8011-INSERT-NAME THRU 8011-EXIT.                     
                                                                        
           IF LINK-IB-LAST-NAME > SPACES                                
               MOVE WS-NEW-I-NAME-ID-NUM TO DQ-NAME-ID                  
               MOVE 'IB'                 TO DQ-NAME-TYPE                
               MOVE 'I'                  TO DQ-NAME-FORMAT              
               MOVE SPACES               TO DQ-FULL-NAME                
               MOVE LINK-IB-FIRST-NAME   TO DQ-FIRST-NAME               
               MOVE LINK-IB-MIDDLE-NAME  TO DQ-MIDDLE-NAME              
               MOVE LINK-IB-LAST-NAME    TO DQ-LAST-NAME                
               MOVE LINK-IB-TITLE        TO DQ-TITLE-PREFIX             
               MOVE LINK-IB-SUFFIX       TO DQ-TITLE-SUFFIX-1           
               MOVE SPACES               TO DQ-TITLE-SUFFIX-2           
               MOVE WS-CURRENT-TIMESTAMP TO DQ-CREATED-DATE             
               PERFORM 8011-INSERT-NAME THRU 8011-EXIT
           END-IF.                 
                                                                        
           MOVE WS-NEW-CUSTOMER-NO-NUM   TO CU-CUSTOMER-NO.             
           MOVE WS-NEW-NAME-ID-NUM       TO CU-NAME-ID.                 
           MOVE 'B'                      TO CU-CODE-EMPL-ACCT.          
           MOVE SPACES                   TO CU-CODE-CUST-STATUS.        
           MOVE SPACES                   TO CU-CODE-STAT-REASON.        
           MOVE WS-CURRENT-DATE          TO CU-CUSTOMER-EST-DATE.       
           MOVE WS-CURRENT-TIMESTAMP     TO CU-LAST-UPDATE-TS           
                                            CU-VALIDATION-TS.           
           MOVE LINK-COMPANY-NO          TO CU-COMPANY-NO-ORIG.         
           MOVE LINK-DHR-FL              TO CU-DHR-FL.                  
           MOVE LINK-LL-REVERT-FL        TO CU-LANDLORD-REVERT-FL.      
           MOVE LINK-WELCOME-KIT-CD      TO CU-WELCOME-KIT-CD.          
           MOVE PF-LOCAL-OFFICE          TO CU-LOCAL-OFFICE-ORIG.       
           PERFORM 8002-INSERT-CUSTOMER THRU 8002-EXIT.                 
                                                                        
           MOVE WS-NEW-CUSTOMER-NO-NUM   TO HT-CUSTOMER-NO.             
           MOVE WS-NEW-NAME-ID-NUM       TO HT-NAME-ID.                 
           MOVE CU-COMPANY-NO-ORIG       TO HT-COMPANY-NO.              
           MOVE ZEROS                    TO HT-ACCOUNT-NO.              
           MOVE ZEROS                    TO HT-ADDRESS-ID.              
           MOVE ZEROS                    TO HT-PREMISE-NO.              
           MOVE ZEROS                    TO HT-CONTACT-ID.              
           PERFORM 8020-INSERT-NAME-XREF THRU 8020-EXIT.                
                                                                        
           IF HMPH-EXISTS                                               
               MOVE WS-NEW-CUSTOMER-NO-NUM  TO CB-CUSTOMER-NO           
               MOVE 'H1'                    TO CB-PHONE-TYPE            
               MOVE LINK-HOME-PHONE-NO      TO CB-PHONE-NO              
               MOVE SPACES                  TO CB-EXTENSION-NO          
               MOVE LINK-HOME-MOBILE-FL     TO CB-MOBILE-PHONE-FL       
               MOVE LINK-HOME-MKT-FL        TO CB-PERMISN-TO-MKT-FL     
               IF LINK-HOME-MKT-FL = 'Y' OR 'N'                         
                   MOVE WS-CURRENT-DATE     TO CB-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO CB-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF WKPH-EXISTS                                               
               MOVE WS-NEW-CUSTOMER-NO-NUM  TO CB-CUSTOMER-NO           
               MOVE 'W1'                    TO CB-PHONE-TYPE            
               MOVE LINK-WORK-PHONE-NO      TO CB-PHONE-NO              
               MOVE LINK-WORK-PHONE-EXT     TO CB-EXTENSION-NO          
               MOVE LINK-WORK-MOBILE-FL     TO CB-MOBILE-PHONE-FL       
               MOVE LINK-WORK-MKT-FL        TO CB-PERMISN-TO-MKT-FL     
               IF LINK-WORK-MKT-FL = 'Y' OR 'N'                         
                   MOVE WS-CURRENT-DATE     TO CB-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO CB-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF ALPH-EXISTS                                               
               MOVE WS-NEW-CUSTOMER-NO-NUM  TO CB-CUSTOMER-NO           
               MOVE 'A1'                    TO CB-PHONE-TYPE            
               MOVE LINK-ALT-PHONE-NO       TO CB-PHONE-NO              
               MOVE SPACES                  TO CB-EXTENSION-NO          
               MOVE LINK-ALT-MOBILE-FL      TO CB-MOBILE-PHONE-FL       
               MOVE LINK-ALT-MKT-FL         TO CB-PERMISN-TO-MKT-FL     
               IF LINK-ALT-MKT-FL = 'Y' OR 'N'                          
                   MOVE WS-CURRENT-DATE     TO CB-PERMISN-TO-MKT-DT     
               ELSE                                                     
                   MOVE SPACES              TO CB-PERMISN-TO-MKT-DT     
               END-IF                                                   
               PERFORM 8030-INSERT-PHONE THRU 8030-EXIT
           END-IF.                
                                                                        
           IF MISC-EXISTS                                               
               MOVE WS-NEW-CUSTOMER-NO-NUM  TO LQ-CUSTOMER-NO           
               MOVE LINK-INFLUENTIAL-CUST   TO LQ-INFLUENTIAL-CUST      
               MOVE LINK-KEY-CUSTOMER       TO LQ-KEY-CUSTOMER          
               MOVE LINK-SPECIAL-CUST       TO LQ-SPECIAL-CUST          
               MOVE LINK-BUILDER-FL         TO LQ-BUILDER-FL            
               MOVE LINK-REALTOR-FL         TO LQ-REALTOR-FL            
               MOVE LINK-DBA                TO LQ-DBA-NAME              
               MOVE LINK-WEBSITE            TO LQ-WEBSITE-ADDR          
               PERFORM 8040-INSERT-MISC-INFO THRU 8040-EXIT
           END-IF.            
                                                                        
           IF CSTS-EXISTS                                               
               MOVE WS-NEW-CUSTOMER-NO-NUM  TO CE-CUSTOMER-NO           
               MOVE 'C'                     TO CE-CUSTOMER-TYPE         
               MOVE LINK-SSN                TO CE-SSN                   
               MOVE WS-NEW-NAME-ID-NUM      TO CE-NAME-ID               
               MOVE LINK-DLN-STATE          TO CE-CODE-STATE-ID         
               MOVE LINK-DLN                TO CE-DRIVERS-LICENSE-NO    
               MOVE LINK-EMPLOYER           TO CE-EMPLOYER              
               MOVE LINK-OTHER-ID-TYPE      TO CE-OTHER-ID-TYPE         
               MOVE LINK-OTHER-ID           TO CE-OTHER-ID              
               MOVE LINK-DATE-OF-BIRTH      TO CE-DATE-OF-BIRTH         
               MOVE LINK-REFUSED-SSN        TO CE-REFUSED-SSN-FL        
               MOVE LINK-DOB-VERIFIED-CD    TO CE-DOB-VERIFIED-CD       
               MOVE LINK-ITIN               TO CE-ITIN-ID               
               MOVE LINK-ALLOW-CALL-FL      TO CE-ALLOW-CALL-FL         
               MOVE LINK-ALLOW-EMAIL-FL     TO CE-ALLOW-EMAIL-FL        
               MOVE LINK-VERIFY-SSN-FL      TO CE-VERIFY-SSN-FL         
               IF LINK-IB-LAST-NAME > SPACES                            
                   MOVE WS-NEW-I-NAME-ID-NUM TO CE-INDIV-NAME-ID        
               ELSE                                                     
                   MOVE ZEROES               TO CE-INDIV-NAME-ID        
               END-IF                                                   
               PERFORM 8050-INSERT-CUST-STATS THRU 8050-EXIT
           END-IF.           
                                                                        
           IF BSTS-EXISTS                                               
               MOVE WS-NEW-CUSTOMER-NO-NUM  TO BS-CUSTOMER-NO           
               MOVE LINK-BUSINESS-TYPE-CD   TO BS-BUSINESS-TYPE-CD      
               MOVE LINK-TAX-ID             TO BS-TAX-ID                
               MOVE LINK-SOS-STATUS-CD      TO BS-SOS-STATUS-CD         
               MOVE LINK-SOS-CONTROL-ID     TO BS-SOS-CONTROL-ID        
               MOVE LINK-SOS-EFFECTIVE-DT   TO BS-SOS-EFFECTIVE-DT      
               PERFORM 8060-INSERT-BUS-CUST-STATS THRU 8060-EXIT
           END-IF.       
                                                                        
           IF LINK-REFUSED-SSN = 'Y'                                    
               MOVE RS-CUSTOMER-NO TO WS-WQ-CUST-1                      
                                      WS-WQ-CUST-2                      
ACT233         MOVE 484 TO CATEGORY-ID-4675                             
               IF CSR-DATABASE                                          
ACT233             MOVE '5' TO ROUTING-CATEGORY-4675                    
               ELSE                                                     
ACT233             MOVE '4' TO ROUTING-CATEGORY-4675                    
               END-IF                                                   
               IF CSR-DATABASE AND                                      
                  LINK-COMPANY-NO = '01'                                
ACT233                MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT       
ACT233                MOVE 111 TO COMMENTS-4675-LEN                     
               ELSE                                                     
ACT233             MOVE WS-WQ-COMMENTS-2 TO COMMENTS-4675-TEXT          
ACT233             MOVE 85 TO COMMENTS-4675-LEN                         
               END-IF                                                   
ACT233         PERFORM 4000-CALL-CSR04675 THRU 4000-EXIT
           END-IF.               
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-UPDATE-CUSTOMER.                                            
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO                    
                                      MH-CUSTOMER-NO.                   
           MOVE LINK-CUSTOMER-NO TO RS-CUSTOMER-NO.                     
                                                                        
           PERFORM 5800-GET-BASELINE-DETAILS THRU 5800-EXIT.            
           PERFORM 5100-TRANSHIST-FOR-UPDATE THRU 5100-EXIT.            
                                                                        
           IF LINK-NAME-FORMAT = 'I' AND                                
              BSTS-EXISTS                                               
                  MOVE 'NO ' TO WS-BSTS-EXISTS-FLAG                     
                  PERFORM 8400-DELETE-BUS-CUST THRU 8400-EXIT
           END-IF.          
                                                                        
           IF INDV-CHANGED                                              
               MOVE LINK-IB-FIRST-NAME TO DQ-FIRST-NAME                 
               MOVE LINK-IB-MIDDLE-NAME TO DQ-MIDDLE-NAME               
               MOVE LINK-IB-LAST-NAME TO DQ-LAST-NAME                   
               MOVE LINK-IB-TITLE TO DQ-TITLE-PREFIX                    
               MOVE LINK-IB-SUFFIX TO DQ-TITLE-SUFFIX-1                 
               STRING LINK-IB-FIRST-NAME(1:1)                           
                      ' '                                               
                      LINK-IB-LAST-NAME                                 
                      DELIMITED BY SIZE                                 
                      INTO WS-SHORT-NAME                                
               END-STRING                                               
               MOVE 'YES' TO WS-NAME-CHANGED-FLAG                       
               IF INDV-EXISTS                                           
                   MOVE CE-INDIV-NAME-ID TO DQ-NAME-ID                  
                   PERFORM 8375-UPDATE-IB-NAME THRU 8375-EXIT           
               ELSE                                                     
                   PERFORM 6302-GET-NEW-NAME-ID THRU 6302-EXIT          
                   MOVE WS-91-NEW-NAME-ID TO DQ-NAME-ID                 
                                             CE-INDIV-NAME-ID           
                   MOVE 'IB'             TO DQ-NAME-TYPE                
                   MOVE 'I'              TO DQ-NAME-FORMAT              
                   MOVE SPACES           TO DQ-FULL-NAME                
                   MOVE SPACES           TO DQ-TITLE-SUFFIX-2           
                   MOVE WS-CURRENT-TIMESTAMP TO DQ-CREATED-DATE         
                   MOVE 'YES' TO WS-CSTS-CHANGED-FLAG                   
                   PERFORM 8011-INSERT-NAME THRU 8011-EXIT              
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-NICKNAME TO WS-SHORT-NAME
           END-IF.                       
                                                                        
           IF CSTS-CHANGED                                              
               MOVE CU-CUSTOMER-NO TO CE-CUSTOMER-NO                    
               MOVE WS-CU-NAME-ID TO CE-NAME-ID                         
               MOVE LINK-SSN TO CE-SSN                                  
               MOVE LINK-DLN-STATE TO CE-CODE-STATE-ID                  
               MOVE LINK-DLN TO CE-DRIVERS-LICENSE-NO                   
               MOVE LINK-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE              
               MOVE LINK-OTHER-ID TO CE-OTHER-ID                        
               MOVE LINK-DATE-OF-BIRTH TO CE-DATE-OF-BIRTH              
               MOVE LINK-REFUSED-SSN TO CE-REFUSED-SSN-FL               
               MOVE LINK-DOB-VERIFIED-CD TO CE-DOB-VERIFIED-CD          
               MOVE LINK-ITIN TO CE-ITIN-ID                             
               MOVE LINK-VERIFY-SSN-FL TO CE-VERIFY-SSN-FL              
               IF WS-DELETE-INDIV-FL = 'Y'                              
                   MOVE ZEROES TO CE-INDIV-NAME-ID                      
               END-IF                                                   
               IF CSTS-EXISTS                                           
                   PERFORM 8340-UPDATE-CSTS THRU 8340-EXIT              
                   PERFORM 8190-DELETE-NULL-CSTS THRU 8190-EXIT         
               ELSE                                                     
                   MOVE 'C' TO CE-CUSTOMER-TYPE                         
                   MOVE SPACES TO CE-EMPLOYER                           
                                  CE-ALLOW-CALL-FL                      
                                  CE-ALLOW-EMAIL-FL                     
                   PERFORM 8050-INSERT-CUST-STATS THRU 8050-EXIT
               END-IF
           END-IF.       
                                                                        
           IF BSTS-CHANGED                                              
               MOVE CU-CUSTOMER-NO TO BS-CUSTOMER-NO                    
               MOVE LINK-BUSINESS-TYPE-CD TO BS-BUSINESS-TYPE-CD        
               MOVE LINK-TAX-ID TO BS-TAX-ID                            
               MOVE LINK-SOS-STATUS-CD TO BS-SOS-STATUS-CD              
               MOVE LINK-SOS-CONTROL-ID TO BS-SOS-CONTROL-ID            
               MOVE LINK-SOS-EFFECTIVE-DT TO BS-SOS-EFFECTIVE-DT        
               IF BSTS-EXISTS                                           
                   PERFORM 8350-UPDATE-BSTS THRU 8350-EXIT              
                   PERFORM 8202-DELETE-NULL-BSTS THRU 8202-EXIT         
               ELSE                                                     
                   PERFORM 8060-INSERT-BUS-CUST-STATS THRU 8060-EXIT
               END-IF
           END-IF.   
                                                                        
           IF MISC-CHANGED                                              
               MOVE CU-CUSTOMER-NO TO LQ-CUSTOMER-NO                    
               MOVE LINK-INFLUENTIAL-CUST TO LQ-INFLUENTIAL-CUST        
               MOVE LINK-KEY-CUSTOMER TO LQ-KEY-CUSTOMER                
               MOVE LINK-SPECIAL-CUST TO LQ-SPECIAL-CUST                
               MOVE LINK-BUILDER-FL TO LQ-BUILDER-FL                    
               MOVE LINK-REALTOR-FL TO LQ-REALTOR-FL                    
               IF MISC-EXISTS                                           
                   PERFORM 8320-UPDATE-MISC THRU 8320-EXIT              
                   PERFORM 8180-DELETE-NULL-MISC THRU 8180-EXIT         
               ELSE                                                     
                   MOVE SPACES TO LQ-DBA-NAME                           
                                  LQ-WEBSITE-ADDR                       
                   PERFORM 8040-INSERT-MISC-INFO THRU 8040-EXIT
               END-IF
           END-IF.        
                                                                        
           IF NAME-CHANGED                                              
               MOVE WS-CU-NAME-ID TO DQ-NAME-ID                         
               MOVE LINK-NAME-FORMAT TO DQ-NAME-FORMAT                  
               MOVE LINK-FIRST-NAME TO DQ-FIRST-NAME                    
               MOVE LINK-MIDDLE-NAME TO DQ-MIDDLE-NAME                  
               MOVE LINK-LAST-NAME TO DQ-LAST-NAME                      
               MOVE LINK-TITLE TO DQ-TITLE-PREFIX                       
               MOVE LINK-SUFFIX TO DQ-TITLE-SUFFIX-1                    
               MOVE LINK-BUSINESS-NAME TO DQ-FULL-NAME                  
               MOVE WS-SHORT-NAME TO DQ-NICKNAME                        
               PERFORM 8370-UPDATE-NAME THRU 8370-EXIT
           END-IF.                 
                                                                        
           IF CUST-CHANGED                                              
               MOVE LINK-DHR-FL TO CU-DHR-FL                            
               MOVE LINK-LL-REVERT-FL TO CU-LANDLORD-REVERT-FL          
               MOVE WS-CURRENT-TIMESTAMP TO CU-LAST-UPDATE-TS           
               PERFORM 8330-UPDATE-CUSTOMER THRU 8330-EXIT
           END-IF.             
                                                                        
           IF REFSSN-CHANGED AND                                        
              LINK-REFUSED-SSN = 'Y'                                    
ACT233         MOVE 484 TO CATEGORY-ID-4675                             
               IF CSR-DATABASE                                          
ACT233             MOVE '5' TO ROUTING-CATEGORY-4675                    
               ELSE                                                     
ACT233             MOVE '4' TO ROUTING-CATEGORY-4675                    
               END-IF                                                   
               IF CSR-DATABASE AND                                      
                  LINK-COMPANY-NO = '01'                                
ACT233                MOVE WS-WQ-COMMENTS-1 TO COMMENTS-4675-TEXT       
ACT233                MOVE 111 TO COMMENTS-4675-LEN                     
               ELSE                                                     
ACT233             MOVE WS-WQ-COMMENTS-2 TO COMMENTS-4675-TEXT          
ACT233             MOVE 85 TO COMMENTS-4675-LEN                         
               END-IF                                                   
ACT233           PERFORM 4000-CALL-CSR04675 THRU 4000-EXIT
           END-IF.             
                                                                        
           IF SSN-CHANGED                                               
               PERFORM 4500-SSN-WQ THRU 4500-EXIT
           END-IF.                      
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE WS-CURRENT-TIMESTAMP TO CU-VALIDATION-TS.               
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-DELETE-CUSTOMER.                                            
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO                    
                                      MH-CUSTOMER-NO.                   
           MOVE LINK-CUSTOMER-NO   TO RS-CUSTOMER-NO.                   
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE LINK-CUSTOMER-NO      TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'CUSTOMER'            TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE 'N' TO WS-SPOUSE-EXISTS.                                
           PERFORM 7100-SPOUSE-EXISTS THRU 7100-EXIT.                   
                                                                        
           PERFORM 8150-DELETE-NAME-ACCT-XREF THRU 8150-EXIT.           
           PERFORM 8151-DELETE-MIA-XREF THRU 8151-EXIT.                 
           PERFORM 8152-DELETE-CUST-XFER THRU 8152-EXIT.                
           PERFORM 8160-DELETE-CUSTOMER THRU 8160-EXIT.                 
                                                                        
           IF WS-SPOUSE-EXISTS = 'Y'                                    
               PERFORM 8220-DELETE-SPOUSE THRU 8220-EXIT
           END-IF.               
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3300-VALIDATE-CUSTOMER.                                          
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO                    
                                      MH-CUSTOMER-NO.                   
           MOVE LINK-CUSTOMER-NO TO RS-CUSTOMER-NO.                     
           MOVE WS-CURRENT-TIMESTAMP TO CU-VALIDATION-TS.               
           PERFORM 8380-UPDATE-VALIDATION THRU 8380-EXIT.               
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*CONFIRMED*'         TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE LINK-CUSTOMER-NO      TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'CUSTOMER'            TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3400-INVALID-ACTION.                                             
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           MOVE '3400' TO ACTIVE-PARAGRAPH.                             
           MOVE 'UPDATE' TO ABEND-FUNCTION.                             
           MOVE 'PROGRAMMER LOGIC' TO TABLE-1.                          
           MOVE 'LINK-UPDATE-TYPE' TO TABLE-ELEMENT-1.                  
           MOVE LINK-UPDATE-TYPE TO HOSTVAR-ELEMENT-1.                  
           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT233 4000-CALL-CSR04675.                                              
                                                                        
ACT233     MOVE CU-CUSTOMER-NO TO CUSTOMER-NO-4675.                     
ACT233     MOVE 0 TO IN-ITEM-ID-4675.                                   
ACT233     MOVE LINK-USERID TO USER-ID-ORIG-4675.                       
ACT233     MOVE SPACES TO USER-ID-ASGN-4675                             
ACT233                    LOCAL-OFFICE-4675                             
ACT233                    RESP-AREA-ID-4675                             
ACT233                    DATE-REQUIRED-4675                            
ACT233                    DATE-CREATED-4675                             
ACT233                    FREE-FORM-DATA-4675-TEXT.                     
ACT233     MOVE 'N' TO WQ-PRIORITY-4675                                 
ACT233     MOVE 0 TO FREE-FORM-DATA-4675-LEN.                           
ACT233     MOVE ZEROES TO PREMISE-NO-4675                               
ACT233                    ACCOUNT-NO-4675                               
ACT233                    SERV-ORDER-NO-4675.                           
ACT233     MOVE 'CSR04496' TO CREATED-BY-4675.                          
                                                                        
      *    EXEC SQL                                                     
ACT233*       CALL CSR04675                                             
ACT233*           (:IN-ITEM-ID-4675,                                    
ACT233*            :ROUTING-CATEGORY-4675,                              
ACT233*            :LOCAL-OFFICE-4675,                                  
ACT233*            :USER-ID-ORIG-4675,                                  
ACT233*            :USER-ID-ASGN-4675,                                  
ACT233*            :RESP-AREA-ID-4675,                                  
ACT233*            :CATEGORY-ID-4675,                                   
ACT233*            :ACCOUNT-NO-4675,                                    
ACT233*            :PREMISE-NO-4675,                                    
ACT233*            :CUSTOMER-NO-4675,                                   
ACT233*            :SERV-ORDER-NO-4675,                                 
ACT233*            :COMMENTS-4675,                                      
ACT233*            :DATE-REQUIRED-4675,                                 
ACT233*            :DATE-CREATED-4675,                                  
ACT233*            :WQ-PRIORITY-4675,                                   
ACT233*            :FREE-FORM-DATA-4675,                                
ACT233*            :CREATED-BY-4675)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4675
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4675 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '4210'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
ACT233        MOVE 'CSR04675'            TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
ACT233        MOVE CUSTOMER-NO-4675      TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
ACT233*       (:LOC4675)                                                
ACT233*       WITH PROCEDURE CSR04675                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
ACT233*       ALLOCATE RESULT_SET_CSR_4675 CURSOR FOR RESULT SET        
ACT233*       :LOC4675                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
ACT233        FETCH RESULT_SET_CSR_4675 INTO                            
ACT233           :RETURN-CODE-4675,                                     
ACT233           :OUT-ITEM-ID-4675                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ACT233             IF RETURN-CODE-4675 NOT = 0                          
ACT233                 MOVE RETURN-CODE-4675  TO WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '4210'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
ACT233                 MOVE 'CSR04675'        TO TABLE-1                
                       MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1        
ACT233                 MOVE CUSTOMER-NO-4675  TO HOSTVAR-ELEMENT-1      
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '4210'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
ACT233             MOVE 'CSR04675'            TO TABLE-1                
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
ACT233             MOVE CUSTOMER-NO-4675      TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4500-SSN-WQ.                                                     
                                                                        
           MOVE LINK-SSN(6:4) TO WS-WQ-SSN-3                            
                                 WS-WQ-SSN-4.                           
           PERFORM 7200-CREDIT-HIST THRU 7200-EXIT.                     
           IF CK-APPL-STATUS-CD = 'D' OR 'O'                            
               IF WS-ITPA-EXISTS-FL = 'Y'                               
                   MOVE 'WQ-CHANGE-SSN-ITPA' TO C8-DELINQ-CD            
               ELSE                                                     
                   MOVE 'WQ-CHANGE-SSN' TO C8-DELINQ-CD                 
               END-IF                                                   
               PERFORM 7005-DELINQUENCY THRU 7005-EXIT                  
               IF C8-DELINQ-VALUE = 1                                   
                   PERFORM 4510-CREATE-WQ THRU 4510-EXIT
               END-IF
           END-IF.               
                                                                        
       4500-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4510-CREATE-WQ.                                                  
                                                                        
           IF WS-ITPA-EXISTS-FL = 'Y'                                   
               IF SEB-DATABASE                                          
ACT233             MOVE 515 TO CATEGORY-ID-4675                         
               ELSE                                                     
                   IF LINK-COMPANY-NO = '01'                            
ACT233                 MOVE 451 TO CATEGORY-ID-4675                     
                   ELSE                                                 
ACT233                 MOVE 514 TO CATEGORY-ID-4675                     
                   END-IF                                               
               END-IF                                                   
               IF LINK-COMPANY-NO = '30'                                
ACT233             MOVE 521 TO CATEGORY-ID-4675                         
               END-IF                                                   
ACT233         MOVE WS-WQ-COMMENTS-3 TO COMMENTS-4675-TEXT              
ACT233         MOVE 111 TO COMMENTS-4675-LEN                            
           ELSE                                                         
               IF SEB-DATABASE                                          
ACT233             MOVE 517 TO CATEGORY-ID-4675                         
               ELSE                                                     
                   IF LINK-COMPANY-NO = '01'                            
ACT233                 MOVE 452 TO CATEGORY-ID-4675                     
                   ELSE                                                 
ACT233                 MOVE 516 TO CATEGORY-ID-4675                     
                   END-IF                                               
               END-IF                                                   
               IF LINK-COMPANY-NO = '30'                                
ACT233             MOVE 522 TO CATEGORY-ID-4675                         
               END-IF                                                   
ACT233         MOVE WS-WQ-COMMENTS-4 TO COMMENTS-4675-TEXT              
ACT233         MOVE 126 TO COMMENTS-4675-LEN
           END-IF.                           
ACT233     MOVE '4' TO ROUTING-CATEGORY-4675.                           
ACT233     PERFORM 4000-CALL-CSR04675 THRU 4000-EXIT.                   
                                                                        
       4510-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5000-TRANSHIST-FOR-INSERT.                                       
                                                                        
           MOVE '5000'                   TO ACTIVE-PARAGRAPH.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
                                                                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE SPACES                TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE SPACES                TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'NEW CUSTOMER'        TO MI-COLUMN-DESC.                
           MOVE SPACES                TO MI-TABLE-ID.                   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
           MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN.     
           MOVE +10                     TO MI-CHG-COLUMN-VALUE-LEN.     
           MOVE WS-NEW-CUSTOMER-NO-CHAR TO MI-CHG-COLUMN-VALUE-TEXT.    
           MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT.    
           MOVE 'CUSTOMER NO'           TO MI-COLUMN-DESC.              
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF LINK-COMPANY-NO > SPACES                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-COMPANY-NO       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'COMPANY NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-NAME-FORMAT > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              EVALUATE LINK-NAME-FORMAT                                 
                  WHEN 'I'                                              
                      MOVE 'INDIVIDUAL'  TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'B'                                              
                      MOVE 'BUSINESS'    TO MI-CHG-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'NAME FORMAT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-TITLE > SPACES                                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TITLE            TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FIRST-NAME  > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-FIRST-NAME       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-MIDDLE-NAME  > SPACES                                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-MIDDLE-NAME  TO MI-CHG-COLUMN-VALUE-TEXT        
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-LAST-NAME > SPACES                                   
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-LAST-NAME        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SUFFIX  > SPACES                                     
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SUFFIX           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-BUSINESS-NAME  > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +70                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-BUSINESS-NAME    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'FULL NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SSN  > SPACES                                        
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SSN              TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SSN            '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ITIN  > SPACES                                       
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ITIN             TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ITIN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-REFUSED-SSN > SPACES                                 
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-REFUSED-SSN      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'REFUSED SSN'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-TAX-ID > SPACES                                      
              MOVE 'YES'                 TO WS-BSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-TAX-ID           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'TAX ID'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DLN  > SPACES                                        
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +19                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DLN              TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'LICENSE NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DLN-STATE  > SPACES                                  
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DLN-STATE        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CODE STATE ID'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DATE-OF-BIRTH  > SPACES                              
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DATE-OF-BIRTH    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-OTHER-ID-TYPE  > SPACES                              
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +12                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-OTHER-ID-TYPE    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OTHER ID TYPE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-OTHER-ID  > SPACES                                   
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +16                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-OTHER-ID         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'OTHER ID'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WELCOME-KIT-CD = 'E' OR 'P'                          
              MOVE WS-TRAN-APPL-NO     TO MI-TRAN-APPL-NO               
              MOVE +11                 TO MI-CHG-COLUMN-VALUE-LEN       
              EVALUATE LINK-WELCOME-KIT-CD                              
              WHEN 'E'                                                  
                 MOVE 'EMAIL ONLY'     TO MI-CHG-COLUMN-VALUE-TEXT      
              WHEN 'P'                                                  
                 MOVE 'PAPER/EMAIL'    TO MI-CHG-COLUMN-VALUE-TEXT      
              END-EVALUATE                                              
              MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT      
              MOVE 'WELCOME KIT CD'    TO MI-COLUMN-DESC                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DBA > SPACES                                         
              MOVE 'YES'                 TO WS-MISC-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +70                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DBA              TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DBA NAME'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WEBSITE > SPACES                                     
              MOVE 'YES'                 TO WS-MISC-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +75                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-WEBSITE          TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'WEBSITE'             TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SOS-STATUS-CD > SPACES                               
              MOVE 'YES'                 TO WS-BSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SOS-STATUS-CD    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SOS STATUS'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SOS-CONTROL-ID > SPACES                              
              MOVE 'YES'                 TO WS-BSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SOS-CONTROL-ID   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SOS CONTROL ID'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-SOS-EFFECTIVE-DT > SPACES                            
              MOVE 'YES'                 TO WS-BSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SOS-EFFECTIVE-DT TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SOS EFF DT'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-KEY-CUSTOMER > SPACES                                
              MOVE 'YES'                 TO WS-MISC-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-KEY-CUSTOMER     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'KEY CUSTOMER'        TO MI-COLUMN-DESC              
              MOVE 'D3'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID
           END-IF.                               
                                                                        
           IF LINK-INFLUENTIAL-CUST > SPACES                            
              MOVE 'YES'                 TO WS-MISC-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-INFLUENTIAL-CUST TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'INFLUENTIAL'         TO MI-COLUMN-DESC              
              MOVE 'D4'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID
           END-IF.                               
                                                                        
           IF LINK-SPECIAL-CUST > SPACES                                
              MOVE 'YES'                 TO WS-MISC-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-SPECIAL-CUST     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SPECIAL CUST'        TO MI-COLUMN-DESC              
              MOVE 'D2'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID
           END-IF.                               
                                                                        
           IF LINK-BUILDER-FL = 'Y'                                     
              MOVE 'YES'                 TO WS-MISC-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-BUILDER-FL       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BUILDER'             TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
      *    IF LINK-LANDLORD-FL = 'Y'                                            
      *       MOVE 'YES'                 TO WS-MISC-EXISTS-FLAG                 
      *       MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO                     
      *       MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN             
      *       MOVE LINK-LANDLORD-FL      TO MI-CHG-COLUMN-VALUE-TEXT            
      *       MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN             
      *       MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT            
      *       MOVE 'LANDLORD'            TO MI-COLUMN-DESC                      
      *       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT                   
      *       ADD 1 TO WS-TRAN-APPL-NO.                                         
                                                                        
           IF LINK-LL-REVERT-FL = 'Y'                                   
              MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO                
              MOVE +1                 TO MI-CHG-COLUMN-VALUE-LEN        
              MOVE LINK-LL-REVERT-FL  TO MI-CHG-COLUMN-VALUE-TEXT       
              MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN        
              MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT       
              MOVE 'REVERT ELIGIBLE'  TO MI-COLUMN-DESC                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-REALTOR-FL = 'Y'                                     
              MOVE 'YES'                 TO WS-MISC-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-REALTOR-FL       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'REALTOR'             TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALLOW-CALL-FL > SPACES                               
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALLOW-CALL-FL    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALLOW CALL'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALLOW-EMAIL-FL > SPACES                              
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALLOW-EMAIL-FL   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALLOW EMAIL'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-PHONE-NO > SPACES                               
              MOVE 'YES'                 TO WS-WKPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-WORK-PHONE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'WORK PHONE'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-PHONE-EXT > SPACES                              
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +6                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-PHONE-EXT      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK PHONE EXT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-MOBILE-FL = 'Y' OR 'N'                          
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-MOBILE-FL      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MOBILE'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-WORK-MKT-FL = 'Y' OR 'N'                             
              MOVE 'YES'                    TO WS-WKPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-WORK-MKT-FL         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MARKET'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'WORK MKT DT'            TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-PHONE-NO > SPACES                               
              MOVE 'YES'                 TO WS-HMPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-HOME-PHONE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'PRIMARY PHONE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-MOBILE-FL = 'Y' OR 'N'                          
              MOVE 'YES'                    TO WS-HMPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-HOME-MOBILE-FL      TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MOBILE'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-HOME-MKT-FL = 'Y' OR 'N'                             
              MOVE 'YES'                    TO WS-HMPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-HOME-MKT-FL         TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MARKET'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'PRIMARY MKT DT'         TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-PHONE-NO > SPACES                                
              MOVE 'YES'                 TO WS-ALPH-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-ALT-PHONE-NO     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'ALT PHONE'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-MOBILE-FL = 'Y' OR 'N'                           
              MOVE 'YES'                    TO WS-ALPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-ALT-MOBILE-FL       TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MOBILE'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-ALT-MKT-FL = 'Y' OR 'N'                              
              MOVE 'YES'                    TO WS-ALPH-EXISTS-FLAG      
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE LINK-ALT-MKT-FL          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MARKET'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE WS-CURRENT-DATE          TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE 'ALT MKT DT'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-BUSINESS-TYPE-CD  > SPACES                           
              MOVE 'YES'                 TO WS-BSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-BUSINESS-TYPE-CD TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'BUSINESS TYPE'       TO MI-COLUMN-DESC              
              MOVE 'P5'                  TO MI-TABLE-ID                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID
           END-IF.                               
                                                                        
           IF LINK-VERIFY-SSN-FL > SPACES                               
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-VERIFY-SSN-FL    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'VERIFY SSN'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DHR-FL = 'Y'                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-DHR-FL           TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'DHR FLAG'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-DOB-VERIFIED-CD = 'D'                                
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +18                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE 'DHR VERIFIED'        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN        
              MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT       
              MOVE 'DOB VERIFIED'     TO MI-COLUMN-DESC                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-EMPLOYER > SPACES                                    
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +23                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-EMPLOYER         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'EMPLOYER'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-IB-TITLE > SPACES                                    
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-IB-TITLE         TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'IB PREFIX'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-IB-FIRST-NAME > SPACES                               
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-IB-FIRST-NAME    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'IB FIRST NAME'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-IB-MIDDLE-NAME > SPACES                              
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +15                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-IB-MIDDLE-NAME   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'IB MIDDLE NAME'      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-IB-LAST-NAME > SPACES                                
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +40                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-IB-LAST-NAME     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'IB LAST NAME'        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-IB-SUFFIX > SPACES                                   
              MOVE 'YES'                 TO WS-CSTS-EXISTS-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +3                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-IB-SUFFIX        TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'IB SUFFIX'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF WS-NEW-I-NAME-ID-CHAR > SPACES                            
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-NEW-I-NAME-ID-CHAR TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'IB NAME ID'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF WS-NEW-NAME-ID-CHAR > SPACES                              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-NEW-NAME-ID-CHAR   TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'NAME ID        '     TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-TRANSHIST-FOR-UPDATE.                                       
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
                                                                        
           IF CU-COMPANY-NO-ORIG NOT = LINK-COMPANY-NO                  
              MOVE 'YES'                 TO WS-CUST-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +02                   TO MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-COMPANY-NO       TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE CU-COMPANY-NO-ORIG    TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'COMPANY NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-NAME-FORMAT NOT = LINK-NAME-FORMAT                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE +11                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE +11                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE LINK-NAME-FORMAT      TO MI-CHG-COLUMN-VALUE-TEXT    
              EVALUATE LINK-NAME-FORMAT                                 
                  WHEN 'B'                                              
                      MOVE 'BUSINESS'    TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN 'I'                                              
                      MOVE 'INDIVIDUAL'  TO MI-CHG-COLUMN-VALUE-TEXT    
                  WHEN OTHER                                            
                      MOVE SPACES        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE DQ-NAME-FORMAT        TO MI-PRV-COLUMN-VALUE-TEXT    
              EVALUATE DQ-NAME-FORMAT                                   
                  WHEN 'B'                                              
                      MOVE 'BUSINESS'    TO MI-PRV-COLUMN-VALUE-TEXT    
                  WHEN 'I'                                              
                      MOVE 'INDIVIDUAL'  TO MI-PRV-COLUMN-VALUE-TEXT    
                  WHEN OTHER                                            
                      MOVE SPACES        TO MI-PRV-COLUMN-VALUE-TEXT    
              END-EVALUATE                                              
              MOVE 'NAME FORMAT'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-PREFIX NOT = LINK-TITLE                          
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-TITLE > SPACES                                    
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-TITLE         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-PREFIX > SPACES                               
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-PREFIX    TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'PREFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FIRST-NAME NOT = LINK-FIRST-NAME                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-FIRST-NAME > SPACES                               
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT       
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-FIRST-NAME > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-FIRST-NAME      TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'FIRST NAME'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-MIDDLE-NAME NOT = LINK-MIDDLE-NAME                     
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-MIDDLE-NAME > SPACES                              
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT      
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-MIDDLE-NAME > SPACES                                
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-MIDDLE-NAME     TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'MIDDLE NAME'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-LAST-NAME NOT = LINK-LAST-NAME                         
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-LAST-NAME > SPACES                                
                 MOVE +40                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-LAST-NAME > SPACES                                  
                 MOVE +40                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-LAST-NAME       TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LAST NAME'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-TITLE-SUFFIX-1 NOT = LINK-SUFFIX                       
              MOVE 'YES'                 TO WS-NAME-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SUFFIX > SPACES                                   
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SUFFIX        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF DQ-TITLE-SUFFIX-1 > SPACES                             
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE DQ-TITLE-SUFFIX-1  TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SUFFIX'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DQ-FULL-NAME NOT = LINK-BUSINESS-NAME AND                 
              LINK-NAME-FORMAT = 'B'                                    
                  MOVE 'YES'              TO WS-NAME-CHANGED-FLAG       
                  MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO            
                  MOVE +70                TO MI-PRV-COLUMN-VALUE-LEN    
                  MOVE +70                TO MI-CHG-COLUMN-VALUE-LEN    
                  MOVE LINK-BUSINESS-NAME TO MI-CHG-COLUMN-VALUE-TEXT   
                  MOVE DQ-FULL-NAME       TO MI-PRV-COLUMN-VALUE-TEXT   
                  MOVE 'BUSINESS NAME  '  TO MI-COLUMN-DESC             
                  PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
                  ADD 1 TO WS-TRAN-APPL-NO                              
           END-IF.                                                      
                                                                        
           IF CE-SSN NOT = LINK-SSN                                     
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
                                            WS-SSN-CHANGED-FLAG         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SSN > SPACES                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SSN           TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-SSN > SPACES                                        
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-SSN             TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SSN'                 TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-ITIN-ID NOT = LINK-ITIN                                
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-ITIN > SPACES                                     
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-ITIN          TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-ITIN-ID > SPACES                                    
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-ITIN-ID         TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'ITIN'                TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-REFUSED-SSN-FL = LOW-VALUES                            
              MOVE SPACES TO CE-REFUSED-SSN-FL                          
           END-IF.                                                      
                                                                        
           IF CE-REFUSED-SSN-FL NOT = LINK-REFUSED-SSN                  
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
                                            WS-REFSSN-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-REFUSED-SSN > SPACES                              
                 MOVE +1                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-REFUSED-SSN                                  
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-REFUSED-SSN-FL > SPACES                             
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE CE-REFUSED-SSN-FL   TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'REFUSED SSN'     TO MI-COLUMN-DESC                  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF BS-TAX-ID NOT = LINK-TAX-ID                               
              MOVE 'YES'                 TO WS-BSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-TAX-ID > SPACES                                   
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-TAX-ID        TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF BS-TAX-ID > SPACES                                     
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE BS-TAX-ID          TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'TAX ID'              TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DRIVERS-LICENSE-NO NOT = LINK-DLN                      
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DLN > SPACES                                      
                 MOVE +19                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DLN           TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-DRIVERS-LICENSE-NO > SPACES                         
                 MOVE +19                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DRIVERS-LICENSE-NO TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'LICENSE NO'          TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-CODE-STATE-ID NOT = LINK-DLN-STATE                     
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DLN-STATE > SPACES                                
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DLN-STATE     TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-CODE-STATE-ID > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-CODE-STATE-ID   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'CODE STATE ID'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DATE-OF-BIRTH NOT = LINK-DATE-OF-BIRTH                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-DATE-OF-BIRTH > SPACES                            
                 MOVE +10                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-DATE-OF-BIRTH TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-DATE-OF-BIRTH    > SPACES                           
                 MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-DATE-OF-BIRTH   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'DATE OF BIRTH'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-OTHER-ID-TYPE NOT = LINK-OTHER-ID-TYPE                 
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OTHER-ID-TYPE > SPACES                            
                 MOVE +12                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OTHER-ID-TYPE TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-OTHER-ID-TYPE > SPACES                              
                 MOVE +12                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-OTHER-ID-TYPE   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OTHER ID TYPE'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-OTHER-ID NOT = LINK-OTHER-ID                           
              MOVE 'YES'                 TO WS-CSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-OTHER-ID > SPACES                                 
                 MOVE +16                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-OTHER-ID  TO MI-CHG-COLUMN-VALUE-TEXT        
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF CE-OTHER-ID > SPACES                                   
                 MOVE +16                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE CE-OTHER-ID        TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'OTHER ID'            TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF BS-SOS-STATUS-CD NOT = LINK-SOS-STATUS-CD                 
              MOVE 'YES'                 TO WS-BSTS-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-SOS-STATUS-CD > SPACES                            
                 MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-SOS-STATUS-CD TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF BS-SOS-STATUS-CD > SPACES                              
                 MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE BS-SOS-STATUS-CD   TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'SOS STATUS CD'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF BS-SOS-CONTROL-ID NOT = LINK-SOS-CONTROL-ID               
              MOVE 'YES'                  TO WS-BSTS-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-SOS-CONTROL-ID > SPACES                           
                 MOVE +15                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-SOS-CONTROL-ID TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF BS-SOS-CONTROL-ID > SPACES                             
                 MOVE +15                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE BS-SOS-CONTROL-ID   TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'SOS CONTROL ID'       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF BS-SOS-EFFECTIVE-DT NOT = LINK-SOS-EFFECTIVE-DT           
              MOVE 'YES'                    TO WS-BSTS-CHANGED-FLAG     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              IF LINK-SOS-EFFECTIVE-DT > SPACES                         
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE LINK-SOS-EFFECTIVE-DT TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BS-SOS-EFFECTIVE-DT > SPACES                           
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BS-SOS-EFFECTIVE-DT   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'SOS EFF DT'             TO MI-COLUMN-DESC           
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LQ-KEY-CUSTOMER NOT = LINK-KEY-CUSTOMER                   
              MOVE 'YES'                  TO WS-MISC-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-KEY-CUSTOMER > SPACES                             
                 MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-KEY-CUSTOMER   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF LQ-KEY-CUSTOMER > SPACES                               
                 MOVE +2                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE LQ-KEY-CUSTOMER     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'KEY CUSTOMER'         TO MI-COLUMN-DESC             
              MOVE 'D3'                   TO MI-TABLE-ID                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID                                
           END-IF.                                                      
                                                                        
           IF LQ-INFLUENTIAL-CUST NOT = LINK-INFLUENTIAL-CUST           
              MOVE 'YES'                    TO WS-MISC-CHANGED-FLAG     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              IF LINK-INFLUENTIAL-CUST > SPACES                         
                 MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE LINK-INFLUENTIAL-CUST TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF LQ-INFLUENTIAL-CUST > SPACES                           
                 MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE LQ-INFLUENTIAL-CUST   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'INFLUENTIAL'            TO MI-COLUMN-DESC           
              MOVE 'D4'                     TO MI-TABLE-ID              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID                                
           END-IF.                                                      
                                                                        
           IF LQ-SPECIAL-CUST NOT = LINK-SPECIAL-CUST                   
              MOVE 'YES'                  TO WS-MISC-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-SPECIAL-CUST > SPACES                             
                 MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-SPECIAL-CUST   TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF LQ-SPECIAL-CUST > SPACES                               
                 MOVE +2                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE LQ-SPECIAL-CUST     TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'SPECIAL CUST'         TO MI-COLUMN-DESC             
              MOVE 'D2'                   TO MI-TABLE-ID                
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID                                
           END-IF.                                                      
                                                                        
           IF LQ-BUILDER-FL NOT = LINK-BUILDER-FL                       
              MOVE 'YES'                  TO WS-MISC-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-BUILDER-FL > SPACES                               
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-BUILDER-FL     TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF LQ-BUILDER-FL > SPACES                                 
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE LQ-BUILDER-FL       TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'BUILDER'              TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *    IF LQ-LANDLORD-FL NOT = LINK-LANDLORD-FL                             
      *       MOVE 'YES'                  TO WS-MISC-CHANGED-FLAG               
      *       MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO                    
      *       IF LINK-LANDLORD-FL > SPACES                                      
      *          MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN            
      *          MOVE LINK-LANDLORD-FL    TO MI-CHG-COLUMN-VALUE-TEXT           
      *       ELSE                                                              
      *          MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN            
      *          MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT           
      *       END-IF                                                            
      *       IF LQ-LANDLORD-FL > SPACES                                        
      *          MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN            
      *          MOVE LQ-LANDLORD-FL      TO MI-PRV-COLUMN-VALUE-TEXT           
      *       ELSE                                                              
      *          MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN            
      *          MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT           
      *       END-IF                                                            
      *       MOVE 'LANDLORD'             TO MI-COLUMN-DESC                     
      *       PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT                   
      *       ADD 1 TO WS-TRAN-APPL-NO                                          
      *    END-IF.                                                              
                                                                        
           IF LQ-REALTOR-FL NOT = LINK-REALTOR-FL                       
              MOVE 'YES'                  TO WS-MISC-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-REALTOR-FL > SPACES                               
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-REALTOR-FL     TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF LQ-REALTOR-FL > SPACES                                 
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE LQ-REALTOR-FL       TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'REALTOR'              TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-LL-REVERT-FL <= ' '                                  
               MOVE 'N' TO LINK-LL-REVERT-FL
           END-IF.                           
           IF CU-LANDLORD-REVERT-FL <= ' '                              
               MOVE 'N' TO CU-LANDLORD-REVERT-FL
           END-IF.                       
           IF CU-LANDLORD-REVERT-FL NOT = LINK-LL-REVERT-FL             
              MOVE 'YES'                    TO WS-CUST-CHANGED-FLAG     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              IF LINK-LL-REVERT-FL > SPACES                             
                 MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE LINK-LL-REVERT-FL     TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF CU-LANDLORD-REVERT-FL > SPACES                         
                 MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE CU-LANDLORD-REVERT-FL TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'REVERT ELIGIBLE'  TO MI-COLUMN-DESC                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF BS-BUSINESS-TYPE-CD NOT = LINK-BUSINESS-TYPE-CD           
              MOVE 'YES'                   TO WS-BSTS-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-BUSINESS-TYPE-CD > SPACES                         
                 MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE LINK-BUSINESS-TYPE-CD TO MI-CHG-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
              END-IF                                                    
              IF BS-BUSINESS-TYPE-CD > SPACES                           
                 MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE BS-BUSINESS-TYPE-CD   TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'BUSINESS TYPE'          TO MI-COLUMN-DESC           
              MOVE 'P5'                     TO MI-TABLE-ID              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
              MOVE SPACES TO MI-TABLE-ID                                
           END-IF.                                                      
                                                                        
           IF CE-VERIFY-SSN-FL NOT = LINK-VERIFY-SSN-FL                 
              MOVE 'YES'                  TO WS-CSTS-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-VERIFY-SSN-FL    > SPACES                         
                 MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-VERIFY-SSN-FL  TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF CE-VERIFY-SSN-FL > SPACES                              
                 MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE CE-VERIFY-SSN-FL    TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'VERIFY VIA SSN'       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF LINK-DHR-FL <= ' '                                        
               MOVE 'N' TO LINK-DHR-FL
           END-IF.                                 
           IF CU-DHR-FL <= ' '                                          
               MOVE 'N' TO CU-DHR-FL
           END-IF.                                   
           IF CU-DHR-FL NOT = LINK-DHR-FL                               
              MOVE 'YES'                   TO WS-CUST-CHANGED-FLAG      
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              IF LINK-DHR-FL > SPACES                                   
                 MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE LINK-DHR-FL          TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF CU-DHR-FL > SPACES                                     
                 MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE CU-DHR-FL            TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'DHR FLAG'              TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF CE-DOB-VERIFIED-CD = LOW-VALUES                           
              MOVE SPACES TO CE-DOB-VERIFIED-CD                         
           END-IF.                                                      
           IF CSTS-EXISTS                                               
             IF CE-DOB-VERIFIED-CD NOT = LINK-DOB-VERIFIED-CD           
                MOVE 'YES'               TO WS-CSTS-CHANGED-FLAG        
                MOVE WS-TRAN-APPL-NO     TO MI-TRAN-APPL-NO             
                IF LINK-DOB-VERIFIED-CD > SPACES                        
                   MOVE +18              TO MI-CHG-COLUMN-VALUE-LEN     
                   EVALUATE LINK-DOB-VERIFIED-CD                        
                    WHEN ' '                                            
                        MOVE 'NOT APPLICABLE' TO                        
                              MI-CHG-COLUMN-VALUE-TEXT                  
                    WHEN 'D'                                            
                        MOVE 'DHR VERIFIED' TO                          
                              MI-CHG-COLUMN-VALUE-TEXT                  
                   END-EVALUATE                                         
                ELSE                                                    
                   MOVE +9               TO MI-CHG-COLUMN-VALUE-LEN     
                   MOVE '*DELETED*'      TO MI-CHG-COLUMN-VALUE-TEXT    
                END-IF                                                  
                IF CE-DOB-VERIFIED-CD > SPACES                          
                   MOVE +18               TO MI-PRV-COLUMN-VALUE-LEN    
                   EVALUATE CE-DOB-VERIFIED-CD                          
                    WHEN ' '                                            
                        MOVE 'NOT APPLICABLE' TO                        
                              MI-PRV-COLUMN-VALUE-TEXT                  
                    WHEN 'D'                                            
                        MOVE 'DHR VERIFIED' TO                          
                              MI-PRV-COLUMN-VALUE-TEXT                  
                   END-EVALUATE                                         
                ELSE                                                    
                   MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN     
                   MOVE '*NEW*'          TO MI-PRV-COLUMN-VALUE-TEXT    
                END-IF                                                  
                MOVE 'DOB VERIFIED CD' TO MI-COLUMN-DESC                
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1 TO WS-TRAN-APPL-NO                                
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF WS-TITLE NOT = LINK-IB-TITLE                              
              MOVE 'YES'                 TO WS-INDV-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-IB-TITLE > SPACES                                 
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-IB-TITLE      TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF WS-TITLE > SPACES                                      
                 MOVE +9                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-TITLE           TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'IB PREFIX'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-FIRST-NAME NOT = LINK-IB-FIRST-NAME                    
              MOVE 'YES'                 TO WS-INDV-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-IB-FIRST-NAME > SPACES                            
                 MOVE +15                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-IB-FIRST-NAME TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF WS-FIRST-NAME > SPACES                                 
                 MOVE +15                TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-FIRST-NAME      TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'IB FIRST NAME'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-MIDDLE-NAME NOT = LINK-IB-MIDDLE-NAME                  
              MOVE 'YES'                  TO WS-INDV-CHANGED-FLAG       
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              IF LINK-IB-MIDDLE-NAME > SPACES                           
                 MOVE +15                 TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE LINK-IB-MIDDLE-NAME TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              END-IF                                                    
              IF WS-MIDDLE-NAME > SPACES                                
                 MOVE +15                 TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE WS-MIDDLE-NAME      TO MI-PRV-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT   
              END-IF                                                    
              MOVE 'IB MIDDLE NAME'       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-LAST-NAME NOT = LINK-IB-LAST-NAME                      
              MOVE 'YES'                TO WS-INDV-CHANGED-FLAG         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              IF LINK-IB-LAST-NAME > SPACES                             
                 MOVE +40               TO MI-CHG-COLUMN-VALUE-LEN      
                 MOVE LINK-IB-LAST-NAME TO MI-CHG-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 MOVE +9                TO MI-CHG-COLUMN-VALUE-LEN      
                 MOVE '*DELETED*'       TO MI-CHG-COLUMN-VALUE-TEXT     
              END-IF                                                    
              IF WS-LAST-NAME > SPACES                                  
                 MOVE +40               TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE WS-LAST-NAME      TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 MOVE +5                TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE '*NEW*'           TO MI-PRV-COLUMN-VALUE-TEXT     
              END-IF                                                    
              MOVE 'IB LAST NAME'       TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF WS-SUFFIX NOT = LINK-IB-SUFFIX                            
              MOVE 'YES'                 TO WS-INDV-CHANGED-FLAG        
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              IF LINK-IB-SUFFIX > SPACES                                
                 MOVE +3                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE LINK-IB-SUFFIX     TO MI-CHG-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT    
              END-IF                                                    
              IF WS-SUFFIX > SPACES                                     
                 MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE WS-SUFFIX          TO MI-PRV-COLUMN-VALUE-TEXT    
              ELSE                                                      
                 MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
              END-IF                                                    
              MOVE 'IB SUFFIX'           TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5800-GET-BASELINE-DETAILS.                                       
                                                                        
           PERFORM 7020-SELECT-CUSTOMER THRU 7020-EXIT.                 
           MOVE CU-NAME-ID TO WS-CU-NAME-ID.                            
                                                                        
           PERFORM 7030-SELECT-CUST-STATS THRU 7030-EXIT.               
           IF NOT CSTS-EXISTS                                           
               INITIALIZE DCLCSS-CUST-STATS
           END-IF.                            
                                                                        
           PERFORM 7040-SELECT-BUS-STATS THRU 7040-EXIT.                
           IF NOT BSTS-EXISTS                                           
              INITIALIZE DCLCSS-BUS-CUST-STATS
           END-IF.                         
                                                                        
           PERFORM 7060-SELECT-MISC-INFO THRU 7060-EXIT.                
           IF NOT MISC-EXISTS                                           
              INITIALIZE DCLCSS-CUST-MISC-INFO                          
              MOVE 'N' TO LQ-BUILDER-FL                                 
                          LQ-REALTOR-FL
           END-IF.                                
                                                                        
           PERFORM 7070-SELECT-NAME THRU 7070-EXIT.                     
           IF CE-INDIV-NAME-ID > 0                                      
               MOVE 'YES' TO WS-INDV-EXISTS-FLAG                        
               PERFORM 7075-SELECT-IB-NAME THRU 7075-EXIT
           END-IF.              
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = :LINK-COMPANY-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :LINK-COMPANY-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 1 TO C8-DELINQ-VALUE                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'       TO TABLE-ELEMENT-1            
                   MOVE C8-DELINQ-CD      TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              NAME_ID,
              DHR_FL,
              LANDLORD_REVERT_FL,
              WELCOME_KIT_CD,
              COMPANY_NO_ORIG                                    
                INTO :WS-CUST-EXISTS-FLAG,                              
                     :CU-NAME-ID,                                       
                     :CU-DHR-FL,                                        
                     :CU-LANDLORD-REVERT-FL,                            
                     :CU-WELCOME-KIT-CD,                                
                     :CU-COMPANY-NO-ORIG                                
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                 
                                                            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              NAME_ID,                                                   
MFA-TR*              DHR_FL,                                                    
MFA-TR*              LANDLORD_REVERT_FL,                                        
MFA-TR*              WELCOME_KIT_CD,                                            
MFA-TR*              COMPANY_NO_ORIG                                            
MFA-TR*         INTO :WS-CUST-EXISTS-FLAG,                                      
MFA-TR*              :CU-NAME-ID,                                               
MFA-TR*              :CU-DHR-FL,                                                
MFA-TR*              :CU-LANDLORD-REVERT-FL,                                    
MFA-TR*              :CU-WELCOME-KIT-CD,                                        
MFA-TR*              :CU-COMPANY-NO-ORIG                                        
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-SELECT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              CUSTOMER_TYPE,
              SSN,
              NAME_ID,
              CODE_STATE_ID,
              DRIVERS_LICENSE_NO,
              EMPLOYER,
              OTHER_ID_TYPE,
              OTHER_ID,
              DATE_OF_BIRTH,
              REFUSED_SSN_FL,
              DOB_VERIFIED_CD,
              ALLOW_CALL_FL,
              ALLOW_EMAIL_FL,
              ITIN_ID,
              VERIFY_SSN_FL,
              INDIV_NAME_ID                                      
                INTO :WS-CSTS-EXISTS-FLAG,                              
                     :CE-CUSTOMER-TYPE,                                 
                     :CE-SSN,                                           
                     :CE-NAME-ID,                                       
                     :CE-CODE-STATE-ID,                                 
                     :CE-DRIVERS-LICENSE-NO,                            
                     :CE-EMPLOYER,                                      
                     :CE-OTHER-ID-TYPE,                                 
                     :CE-OTHER-ID,                                      
                     :CE-DATE-OF-BIRTH :WS-NULL-3,                       
                     :CE-REFUSED-SSN-FL,                                
                     :CE-DOB-VERIFIED-CD,                               
                     :CE-ALLOW-CALL-FL,                                 
                     :CE-ALLOW-EMAIL-FL,                                
                     :CE-ITIN-ID,                                       
                     :CE-VERIFY-SSN-FL,                                 
                     :CE-INDIV-NAME-ID                                  
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE CUSTOMER_NO    = :CU-CUSTOMER-NO                   
                 AND CUSTOMER_TYPE  = 'C'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              NAME_ID,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              REFUSED_SSN_FL,                                            
MFA-TR*              DOB_VERIFIED_CD,                                           
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL,                                            
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              VERIFY_SSN_FL,                                             
MFA-TR*              INDIV_NAME_ID                                              
MFA-TR*         INTO :WS-CSTS-EXISTS-FLAG,                                      
MFA-TR*              :CE-CUSTOMER-TYPE,                                         
MFA-TR*              :CE-SSN,                                                   
MFA-TR*              :CE-NAME-ID,                                               
MFA-TR*              :CE-CODE-STATE-ID,                                         
MFA-TR*              :CE-DRIVERS-LICENSE-NO,                                    
MFA-TR*              :CE-EMPLOYER,                                              
MFA-TR*              :CE-OTHER-ID-TYPE,                                         
MFA-TR*              :CE-OTHER-ID,                                              
MFA-TR*              :CE-DATE-OF-BIRTH:WS-NULL-3,                               
MFA-TR*              :CE-REFUSED-SSN-FL,                                        
MFA-TR*              :CE-DOB-VERIFIED-CD,                                       
MFA-TR*              :CE-ALLOW-CALL-FL,                                         
MFA-TR*              :CE-ALLOW-EMAIL-FL,                                        
MFA-TR*              :CE-ITIN-ID,                                               
MFA-TR*              :CE-VERIFY-SSN-FL,                                         
MFA-TR*              :CE-INDIV-NAME-ID                                          
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE CUSTOMER_NO    = :CU-CUSTOMER-NO                           
MFA-TR*          AND CUSTOMER_TYPE  = 'C'                                       
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7030                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7030'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2             
                   MOVE 'C'              TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              BUSINESS_TYPE_CD,
              TAX_ID,
              SOS_STATUS_CD,
              SOS_CONTROL_ID,
              SOS_EFFECTIVE_DT                                   
                INTO :WS-BSTS-EXISTS-FLAG,                              
                     :BS-BUSINESS-TYPE-CD,                              
                     :BS-TAX-ID,                                        
                     :BS-SOS-STATUS-CD,                                 
                     :BS-SOS-CONTROL-ID,                                
                     :BS-SOS-EFFECTIVE-DT :WS-NULL-1                     
                FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              BUSINESS_TYPE_CD,                                          
MFA-TR*              TAX_ID,                                                    
MFA-TR*              SOS_STATUS_CD,                                             
MFA-TR*              SOS_CONTROL_ID,                                            
MFA-TR*              SOS_EFFECTIVE_DT                                           
MFA-TR*         INTO :WS-BSTS-EXISTS-FLAG,                                      
MFA-TR*              :BS-BUSINESS-TYPE-CD,                                      
MFA-TR*              :BS-TAX-ID,                                                
MFA-TR*              :BS-SOS-STATUS-CD,                                         
MFA-TR*              :BS-SOS-CONTROL-ID,                                        
MFA-TR*              :BS-SOS-EFFECTIVE-DT:WS-NULL-1                             
MFA-TR*         FROM CSS_BUS_CUST_STATS                                         
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7040                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO BS-SOS-EFFECTIVE-DT               
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7040'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-MISC-INFO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'YES',
              BUILDER_FL,
              REALTOR_FL,
              DBA_NAME,
              WEBSITE_ADDR,
              KEY_CUSTOMER,
              INFLUENTIAL_CUST,
              SPECIAL_CUST                                       
                INTO :WS-MISC-EXISTS-FLAG,                              
                     :LQ-BUILDER-FL,                                    
                     :LQ-REALTOR-FL,                                    
                     :LQ-DBA-NAME,                                      
                     :LQ-WEBSITE-ADDR,                                  
                     :LQ-KEY-CUSTOMER,                                  
                     :LQ-INFLUENTIAL-CUST,                              
                     :LQ-SPECIAL-CUST                                   
                FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              BUILDER_FL,                                                
MFA-TR*              REALTOR_FL,                                                
MFA-TR*              DBA_NAME,                                                  
MFA-TR*              WEBSITE_ADDR,                                              
MFA-TR*              KEY_CUSTOMER,                                              
MFA-TR*              INFLUENTIAL_CUST,                                          
MFA-TR*              SPECIAL_CUST                                               
MFA-TR*         INTO :WS-MISC-EXISTS-FLAG,                                      
MFA-TR*              :LQ-BUILDER-FL,                                            
MFA-TR*              :LQ-REALTOR-FL,                                            
MFA-TR*              :LQ-DBA-NAME,                                              
MFA-TR*              :LQ-WEBSITE-ADDR,                                          
MFA-TR*              :LQ-KEY-CUSTOMER,                                          
MFA-TR*              :LQ-INFLUENTIAL-CUST,                                      
MFA-TR*              :LQ-SPECIAL-CUST                                           
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_MISC_INFO'  TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_TYPE,
              NAME_FORMAT,
              FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              NICKNAME,
              FULL_NAME                                          
                INTO :DQ-NAME-TYPE,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-NICKNAME,                                      
                     :DQ-FULL-NAME                                      
                FROM CSS_NAME WITH(READUNCOMMITTED)                             
               WHERE NAME_ID = :WS-CU-NAME-ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              NICKNAME,                                                  
MFA-TR*              FULL_NAME                                                  
MFA-TR*         INTO :DQ-NAME-TYPE,                                             
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-NICKNAME,                                              
MFA-TR*              :DQ-FULL-NAME                                              
MFA-TR*         FROM CSS_NAME                                                   
MFA-TR*        WHERE NAME_ID = :WS-CU-NAME-ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7070'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME'            TO TABLE-1                     
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE WS-CU-NAME-ID         TO HOSTVAR-ELEMENT-1           
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7075-SELECT-IB-NAME.                                             
                                                                        
           EXEC SQL                                                     
              SELECT FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1                                     
                INTO :WS-FIRST-NAME,                                    
                     :WS-MIDDLE-NAME,                                   
                     :WS-LAST-NAME,                                     
                     :WS-TITLE,                                         
                     :WS-SUFFIX                                         
                FROM CSS_NAME WITH(READUNCOMMITTED)                             
               WHERE NAME_ID = :CE-INDIV-NAME-ID                        
                 AND NAME_FORMAT = 'I'                                  
                 AND NAME_TYPE = 'IB'                                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1                                             
MFA-TR*         INTO :WS-FIRST-NAME,                                            
MFA-TR*              :WS-MIDDLE-NAME,                                           
MFA-TR*              :WS-LAST-NAME,                                             
MFA-TR*              :WS-TITLE,                                                 
MFA-TR*              :WS-SUFFIX                                                 
MFA-TR*         FROM CSS_NAME                                                   
MFA-TR*        WHERE NAME_ID = :CE-INDIV-NAME-ID                                
MFA-TR*          AND NAME_FORMAT = 'I'                                          
MFA-TR*          AND NAME_TYPE = 'IB'                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7075                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO LINK-IB-FIRST-NAME                    
                                  LINK-IB-MIDDLE-NAME                   
                                  LINK-IB-LAST-NAME                     
                                  LINK-IB-TITLE                         
                                  LINK-IB-SUFFIX                        
                   INITIALIZE WS-INDIV-BUS-DATA                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7075'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_NAME'       TO TABLE-1                     
                   MOVE 'INDIV_NAME_ID'  TO TABLE-ELEMENT-1             
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-2             
                   MOVE CE-INDIV-NAME-ID TO HOSTVAR-ELEMENT-1           
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID,
              LOCAL_OFFICE                                       
                INTO :PF-RESP-AREA-ID,                                  
                     :PF-LOCAL-OFFICE                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID,                                              
MFA-TR*              LOCAL_OFFICE                                               
MFA-TR*         INTO :PF-RESP-AREA-ID,                                          
MFA-TR*              :PF-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7080                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7080'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              MOVE LINK-CUSTOMER-NO      TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SPOUSE-EXISTS.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y',
              HT.NAME_ID                                         
                INTO :WS-SPOUSE-EXISTS,                                 
                     :HT-NAME-ID                                        
                FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),               
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE HT.CUSTOMER_NO = :CU-CUSTOMER-NO                   
                 AND HT.NAME_ID     = DQ.NAME_ID                        
                 AND DQ.NAME_TYPE   = 'SN'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y',                                                       
MFA-TR*              HT.NAME_ID                                                 
MFA-TR*         INTO :WS-SPOUSE-EXISTS,                                         
MFA-TR*              :HT-NAME-ID                                                
MFA-TR*         FROM CSS_NAME_ACCT_XREF HT,                                     
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE HT.CUSTOMER_NO = :CU-CUSTOMER-NO                           
MFA-TR*          AND HT.NAME_ID     = DQ.NAME_ID                                
MFA-TR*          AND DQ.NAME_TYPE   = 'SN'                                      
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SPOUSE-EXISTS                         
                   MOVE HT-NAME-ID TO WS-SPOUSE-NAME-ID                 
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SPOUSE-EXISTS                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7100'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'CSS_NAME'           TO TABLE-2                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CREDIT-HIST.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CK.CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), ':', 
           '.') CR_HIST_TRAN_TM,
              LF.ITPA_RSLT_CURR_CD,
              CK.APPL_STATUS_CD                                 
                 INTO :CK-CR-HIST-TRAN-DT,                              
                      :CK-CR-HIST-TRAN-TM,                              
                      :LF-ITPA-RSLT-CURR-CD,                            
                      :CK-APPL-STATUS-CD                                
                 FROM CSS_CREDIT_HIST CK WITH(READUNCOMMITTED),                 
                      CSS_CRED_ITPA_HIST LF WITH(READUNCOMMITTED)               
                WHERE CK.CUSTOMER_NO = :CU-CUSTOMER-NO                  
                  AND CK.CR_HIST_TRAN_TM =                              
                     (SELECT MAX(CR_HIST_TRAN_TM)                       
                        FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)              
                       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO              
                         AND CR_HIST_TRAN_DT =                          
                          (SELECT MAX(CR_HIST_TRAN_DT)                  
                             FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)         
                            WHERE CUSTOMER_NO = :CU-CUSTOMER-NO))       
                  AND CK.CR_HIST_TRAN_DT =                              
                   (SELECT MAX(CR_HIST_TRAN_DT)                         
                       FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)               
                 WHERE CUSTOMER_NO = :CU-CUSTOMER-NO)                   
                   AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                  
                   AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT          
                   AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CK.CR_HIST_TRAN_DT,                                       
MFA-TR*               CK.CR_HIST_TRAN_TM,                                       
MFA-TR*               LF.ITPA_RSLT_CURR_CD,                                     
MFA-TR*               CK.APPL_STATUS_CD                                         
MFA-TR*          INTO :CK-CR-HIST-TRAN-DT,                                      
MFA-TR*               :CK-CR-HIST-TRAN-TM,                                      
MFA-TR*               :LF-ITPA-RSLT-CURR-CD,                                    
MFA-TR*               :CK-APPL-STATUS-CD                                        
MFA-TR*          FROM CSS_CREDIT_HIST CK,                                       
MFA-TR*               CSS_CRED_ITPA_HIST LF                                     
MFA-TR*         WHERE CK.CUSTOMER_NO = :CU-CUSTOMER-NO                          
MFA-TR*           AND CK.CR_HIST_TRAN_TM =                                      
MFA-TR*              (SELECT MAX(CR_HIST_TRAN_TM)                               
MFA-TR*                 FROM CSS_CREDIT_HIST                                    
MFA-TR*                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
MFA-TR*                  AND CR_HIST_TRAN_DT =                                  
MFA-TR*                   (SELECT MAX(CR_HIST_TRAN_DT)                          
MFA-TR*                      FROM CSS_CREDIT_HIST                               
MFA-TR*                     WHERE CUSTOMER_NO = :CU-CUSTOMER-NO))               
MFA-TR*           AND CK.CR_HIST_TRAN_DT =                                      
MFA-TR*            (SELECT MAX(CR_HIST_TRAN_DT)                                 
MFA-TR*                FROM CSS_CREDIT_HIST                                     
MFA-TR*          WHERE CUSTOMER_NO = :CU-CUSTOMER-NO)                           
MFA-TR*            AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                          
MFA-TR*            AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT                  
MFA-TR*            AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7200                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF LF-ITPA-RSLT-CURR-CD = ' ' OR 'R'                 
                       MOVE 'N' TO WS-ITPA-EXISTS-FL                    
                   ELSE                                                 
                       MOVE 'Y' TO WS-ITPA-EXISTS-FL                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_CREDIT_HIST'    TO TABLE-1                 
                   MOVE 'CSS_CRED_ITPA_HIST' TO TABLE-2                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-INSERT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUSTOMER                                  
                   ( CUSTOMER_NO,                                       
                     CODE_EMPL_ACCT,                                    
                     CODE_CUST_STATUS,                                  
                     CODE_STAT_REASON,                                  
                     CUSTOMER_EST_DATE,                                 
                     NAME_ID,                                           
                     LAST_UPDATE_TS,                                    
                     LOCAL_OFFICE_ORIG,                                 
                     COMPANY_NO_ORIG,                                   
                     DHR_FL,                                            
                     LANDLORD_REVERT_FL,                                
                     WELCOME_KIT_CD,                                    
                     VALIDATION_TS)                                     
              VALUES                                                    
                   (:CU-CUSTOMER-NO,                                    
                    :CU-CODE-EMPL-ACCT,                                 
                    :CU-CODE-CUST-STATUS,                               
                    :CU-CODE-STAT-REASON,                               
                    IIF(TRY_CONVERT(DATE, :CU-CUSTOMER-EST-DATE
              ) IS NULL OR (PATINDEX('%.%', :CU-CUSTOMER-EST-DATE
              ) <> 0) OR (LEN(:CU-CUSTOMER-EST-DATE
              ) <> 10), CIS.CHAR2DATE(:CU-CUSTOMER-EST-DATE
              ), CONVERT(DATE, :CU-CUSTOMER-EST-DATE) ),                       
                    :CU-NAME-ID,                                        
                    CIS.CHAR2TIMESTAMP(:CU-LAST-UPDATE-TS),                     
                    :CU-LOCAL-OFFICE-ORIG,                              
                    :CU-COMPANY-NO-ORIG,                                
                    :CU-DHR-FL,                                         
                    :CU-LANDLORD-REVERT-FL,                             
                    :CU-WELCOME-KIT-CD,                                 
                    CIS.CHAR2TIMESTAMP(:CU-VALIDATION-TS))                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUSTOMER                                          
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CODE_EMPL_ACCT,                                            
MFA-TR*              CODE_CUST_STATUS,                                          
MFA-TR*              CODE_STAT_REASON,                                          
MFA-TR*              CUSTOMER_EST_DATE,                                         
MFA-TR*              NAME_ID,                                                   
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              LOCAL_OFFICE_ORIG,                                         
MFA-TR*              COMPANY_NO_ORIG,                                           
MFA-TR*              DHR_FL,                                                    
MFA-TR*              LANDLORD_REVERT_FL,                                        
MFA-TR*              WELCOME_KIT_CD,                                            
MFA-TR*              VALIDATION_TS)                                             
MFA-TR*       VALUES                                                            
MFA-TR*            (:CU-CUSTOMER-NO,                                            
MFA-TR*             :CU-CODE-EMPL-ACCT,                                         
MFA-TR*             :CU-CODE-CUST-STATUS,                                       
MFA-TR*             :CU-CODE-STAT-REASON,                                       
MFA-TR*             :CU-CUSTOMER-EST-DATE,                                      
MFA-TR*             :CU-NAME-ID,                                                
MFA-TR*             :CU-LAST-UPDATE-TS,                                         
MFA-TR*             :CU-LOCAL-OFFICE-ORIG,                                      
MFA-TR*             :CU-COMPANY-NO-ORIG,                                        
MFA-TR*             :CU-DHR-FL,                                                 
MFA-TR*             :CU-LANDLORD-REVERT-FL,                                     
MFA-TR*             :CU-WELCOME-KIT-CD,                                         
MFA-TR*             :CU-VALIDATION-TS)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8002'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'NAME_ID'             TO TABLE-ELEMENT-2             
              MOVE 'CUSTOMER_EST_DATE'   TO TABLE-ELEMENT-3             
              MOVE 'CUST_LAST_VISIT_DT'  TO TABLE-ELEMENT-4             
              MOVE CU-NAME-ID            TO HOSTVAR-ELEMENT-2           
              MOVE CU-CUSTOMER-EST-DATE  TO HOSTVAR-ELEMENT-3           
              MOVE CU-CUST-LAST-VISIT-DT TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8011-INSERT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME                                      
                   ( NAME_ID,                                           
                     NAME_TYPE,                                         
                     NAME_FORMAT,                                       
                     CREATED_DATE,                                      
                     FIRST_NAME,                                        
                     MIDDLE_NAME,                                       
                     LAST_NAME,                                         
                     TITLE_PREFIX,                                      
                     TITLE_SUFFIX_1,                                    
                     TITLE_SUFFIX_2,                                    
                     NICKNAME,                                          
                     FULL_NAME)                                         
              VALUES                                                    
                   (:DQ-NAME-ID,                                        
                    :DQ-NAME-TYPE,                                      
                    :DQ-NAME-FORMAT,                                    
                    CIS.CHAR2TIMESTAMP(:DQ-CREATED-DATE),                       
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :DQ-NICKNAME,                                       
                    :DQ-FULL-NAME)                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NAME                                              
MFA-TR*            ( NAME_ID,                                                   
MFA-TR*              NAME_TYPE,                                                 
MFA-TR*              NAME_FORMAT,                                               
MFA-TR*              CREATED_DATE,                                              
MFA-TR*              FIRST_NAME,                                                
MFA-TR*              MIDDLE_NAME,                                               
MFA-TR*              LAST_NAME,                                                 
MFA-TR*              TITLE_PREFIX,                                              
MFA-TR*              TITLE_SUFFIX_1,                                            
MFA-TR*              TITLE_SUFFIX_2,                                            
MFA-TR*              NICKNAME,                                                  
MFA-TR*              FULL_NAME)                                                 
MFA-TR*       VALUES                                                            
MFA-TR*            (:DQ-NAME-ID,                                                
MFA-TR*             :DQ-NAME-TYPE,                                              
MFA-TR*             :DQ-NAME-FORMAT,                                            
MFA-TR*             :DQ-CREATED-DATE,                                           
MFA-TR*             :DQ-FIRST-NAME,                                             
MFA-TR*             :DQ-MIDDLE-NAME,                                            
MFA-TR*             :DQ-LAST-NAME,                                              
MFA-TR*             :DQ-TITLE-PREFIX,                                           
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                         
MFA-TR*             :DQ-TITLE-SUFFIX-2,                                         
MFA-TR*             :DQ-NICKNAME,                                               
MFA-TR*             :DQ-FULL-NAME)                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8011'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_TYPE'          TO TABLE-ELEMENT-2              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-3              
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-TYPE         TO HOSTVAR-ELEMENT-2            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-3            
              MOVE LINK-CUSTOMER-NO     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-NAME-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_NAME_ACCT_XREF                            
                   ( NAME_ID,                                           
                     COMPANY_NO,                                        
                     CUSTOMER_NO,                                       
                     ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     PREMISE_NO,                                        
                     CONTACT_ID)                                        
              VALUES                                                    
                   (:HT-NAME-ID,                                        
                    :HT-COMPANY-NO,                                     
                    :HT-CUSTOMER-NO,                                    
                    :HT-ACCOUNT-NO,                                     
                    :HT-ADDRESS-ID,                                     
                    :HT-PREMISE-NO,                                     
                    :HT-CONTACT-ID)                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8020'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-3              
              MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-3            
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE HT-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8030-INSERT-PHONE.                                               
                                                                        
           IF CB-PERMISN-TO-MKT-DT <= SPACES                            
               MOVE -1 TO WS-NULL-10                                    
           ELSE                                                         
               MOVE 0 TO WS-NULL-10
           END-IF.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_PHONE                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     MOBILE_PHONE_FL,                                   
                     PERMISN_TO_MKT_FL,                                 
                     PERMISN_TO_MKT_DT)                                 
              VALUES                                                    
                   (:CB-CUSTOMER-NO,                                    
                    'C',                                                
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO,                                   
                    :CB-MOBILE-PHONE-FL,                                
                    :CB-PERMISN-TO-MKT-FL,                              
                    IIF(TRY_CONVERT(DATE, :CB-PERMISN-TO-MKT-DT 
                                          :WS-NULL-10
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                            :WS-NULL-10
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-10
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-10
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-10) ))           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_PHONE                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              PHONE_TYPE,                                                
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              MOBILE_PHONE_FL,                                           
MFA-TR*              PERMISN_TO_MKT_FL,                                         
MFA-TR*              PERMISN_TO_MKT_DT)                                         
MFA-TR*       VALUES                                                            
MFA-TR*            (:CB-CUSTOMER-NO,                                            
MFA-TR*             'C',                                                        
MFA-TR*             :CB-PHONE-TYPE,                                             
MFA-TR*             :CB-PHONE-NO,                                               
MFA-TR*             :CB-EXTENSION-NO,                                           
MFA-TR*             :CB-MOBILE-PHONE-FL,                                        
MFA-TR*             :CB-PERMISN-TO-MKT-FL,                                      
MFA-TR*             :CB-PERMISN-TO-MKT-DT:WS-NULL-10)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8030'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-3            
              MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8040-INSERT-MISC-INFO.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_MISC_INFO                            
                   ( CUSTOMER_NO,                                       
                     INFLUENTIAL_CUST,                                  
                     KEY_CUSTOMER,                                      
                     SPECIAL_CUST,                                      
                     BUILDER_FL,                                        
                     REALTOR_FL,                                        
                     DBA_NAME,                                          
                     WEBSITE_ADDR )                                     
              VALUES                                                    
                   ( :LQ-CUSTOMER-NO,                                   
                     :LQ-INFLUENTIAL-CUST,                              
                     :LQ-KEY-CUSTOMER,                                  
                     :LQ-SPECIAL-CUST,                                  
                     :LQ-BUILDER-FL,                                    
                     :LQ-REALTOR-FL,                                    
                     :LQ-DBA-NAME,                                      
                     :LQ-WEBSITE-ADDR )                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8040'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'INFLUENTIAL_CUST'   TO TABLE-ELEMENT-2              
              MOVE 'KEY_CUSTOMER'       TO TABLE-ELEMENT-3              
              MOVE 'CONSLT_PRJ_END_DT'  TO TABLE-ELEMENT-4              
              MOVE LQ-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE LQ-INFLUENTIAL-CUST  TO HOSTVAR-ELEMENT-2            
              MOVE LQ-KEY-CUSTOMER      TO HOSTVAR-ELEMENT-3            
              MOVE LQ-CONSLT-PRJ-END-DT TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-INSERT-CUST-STATS.                                          
                                                                        
           IF CE-DATE-OF-BIRTH <= ' '                                   
               MOVE -1 TO WS-NULL-3                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-3
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     SSN,                                               
                     NAME_ID,                                           
                     CODE_STATE_ID,                                     
                     DRIVERS_LICENSE_NO,                                
                     EMPLOYER,                                          
                     OTHER_ID_TYPE,                                     
                     OTHER_ID,                                          
                     DATE_OF_BIRTH,                                     
                     REFUSED_SSN_FL,                                    
                     DOB_VERIFIED_CD,                                   
                     ITIN_ID,                                           
                     ALLOW_CALL_FL,                                     
                     ALLOW_EMAIL_FL,                                    
                     VERIFY_SSN_FL,                                     
                     INDIV_NAME_ID)                                     
              VALUES                                                    
                   (:CE-CUSTOMER-NO,                                    
                    :CE-CUSTOMER-TYPE,                                  
                    :CE-SSN,                                            
                    :CE-NAME-ID,                                        
                    :CE-CODE-STATE-ID,                                  
                    :CE-DRIVERS-LICENSE-NO,                             
                    :CE-EMPLOYER,                                       
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-OTHER-ID,                                       
                    IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-3
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-3
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-3) ),                
                    :CE-REFUSED-SSN-FL,                                 
                    :CE-DOB-VERIFIED-CD,                                
                    :CE-ITIN-ID,                                        
                    :CE-ALLOW-CALL-FL,                                  
                    :CE-ALLOW-EMAIL-FL,                                 
                    :CE-VERIFY-SSN-FL,                                  
                    :CE-INDIV-NAME-ID)                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_STATS                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              CUSTOMER_TYPE,                                             
MFA-TR*              SSN,                                                       
MFA-TR*              NAME_ID,                                                   
MFA-TR*              CODE_STATE_ID,                                             
MFA-TR*              DRIVERS_LICENSE_NO,                                        
MFA-TR*              EMPLOYER,                                                  
MFA-TR*              OTHER_ID_TYPE,                                             
MFA-TR*              OTHER_ID,                                                  
MFA-TR*              DATE_OF_BIRTH,                                             
MFA-TR*              REFUSED_SSN_FL,                                            
MFA-TR*              DOB_VERIFIED_CD,                                           
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              ALLOW_CALL_FL,                                             
MFA-TR*              ALLOW_EMAIL_FL,                                            
MFA-TR*              VERIFY_SSN_FL,                                             
MFA-TR*              INDIV_NAME_ID)                                             
MFA-TR*       VALUES                                                            
MFA-TR*            (:CE-CUSTOMER-NO,                                            
MFA-TR*             :CE-CUSTOMER-TYPE,                                          
MFA-TR*             :CE-SSN,                                                    
MFA-TR*             :CE-NAME-ID,                                                
MFA-TR*             :CE-CODE-STATE-ID,                                          
MFA-TR*             :CE-DRIVERS-LICENSE-NO,                                     
MFA-TR*             :CE-EMPLOYER,                                               
MFA-TR*             :CE-OTHER-ID-TYPE,                                          
MFA-TR*             :CE-OTHER-ID,                                               
MFA-TR*             :CE-DATE-OF-BIRTH:WS-NULL-3,                                
MFA-TR*             :CE-REFUSED-SSN-FL,                                         
MFA-TR*             :CE-DOB-VERIFIED-CD,                                        
MFA-TR*             :CE-ITIN-ID,                                                
MFA-TR*             :CE-ALLOW-CALL-FL,                                          
MFA-TR*             :CE-ALLOW-EMAIL-FL,                                         
MFA-TR*             :CE-VERIFY-SSN-FL,                                          
MFA-TR*             :CE-INDIV-NAME-ID)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8050'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'SSN'                TO TABLE-ELEMENT-3              
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-4              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2            
              MOVE CE-SSN               TO HOSTVAR-ELEMENT-3            
              MOVE CE-NAME-ID           TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-INSERT-BUS-CUST-STATS.                                      
                                                                        
           IF BS-SOS-EFFECTIVE-DT <= SPACES                             
               MOVE -1 TO WS-NULL-4                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-4
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BUS_CUST_STATS                            
                   ( CUSTOMER_NO,                                       
                     BUSINESS_TYPE_CD,                                  
                     TAX_ID,                                            
                     INTRA_CO_IND,                                      
                     SUBSIDIARY_IND,                                    
                     TRADE_ALLY_IND,                                    
                     CONTRACTOR_TYPE,                                   
                     SOS_STATUS_CD,                                     
                     SOS_CONTROL_ID,                                    
                     SOS_EFFECTIVE_DT)                                  
              VALUES                                                    
                   (:BS-CUSTOMER-NO,                                    
                    :BS-BUSINESS-TYPE-CD,                               
                    :BS-TAX-ID,                                         
                    ' ',                                                
                    ' ',                                                
                    ' ',                                                
                    ' ',                                                
                    :BS-SOS-STATUS-CD,                                  
                    :BS-SOS-CONTROL-ID,                                 
                    IIF(TRY_CONVERT(DATE, :BS-SOS-EFFECTIVE-DT 
                                          :WS-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :BS-SOS-EFFECTIVE-DT 
                                                             :WS-NULL-4
              ) <> 0) OR (LEN(:BS-SOS-EFFECTIVE-DT :WS-NULL-4
              ) <> 10), CIS.CHAR2DATE(:BS-SOS-EFFECTIVE-DT :WS-NULL-4
              ), CONVERT(DATE, :BS-SOS-EFFECTIVE-DT :WS-NULL-4) ))             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BUS_CUST_STATS                                    
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              BUSINESS_TYPE_CD,                                          
MFA-TR*              TAX_ID,                                                    
MFA-TR*              INTRA_CO_IND,                                              
MFA-TR*              SUBSIDIARY_IND,                                            
MFA-TR*              TRADE_ALLY_IND,                                            
MFA-TR*              CONTRACTOR_TYPE,                                           
MFA-TR*              SOS_STATUS_CD,                                             
MFA-TR*              SOS_CONTROL_ID,                                            
MFA-TR*              SOS_EFFECTIVE_DT)                                          
MFA-TR*       VALUES                                                            
MFA-TR*            (:BS-CUSTOMER-NO,                                            
MFA-TR*             :BS-BUSINESS-TYPE-CD,                                       
MFA-TR*             :BS-TAX-ID,                                                 
MFA-TR*             ' ',                                                        
MFA-TR*             ' ',                                                        
MFA-TR*             ' ',                                                        
MFA-TR*             ' ',                                                        
MFA-TR*             :BS-SOS-STATUS-CD,                                          
MFA-TR*             :BS-SOS-CONTROL-ID,                                         
MFA-TR*             :BS-SOS-EFFECTIVE-DT:WS-NULL-4)                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8060'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'BUSINESS_TYPE_CD'   TO TABLE-ELEMENT-2              
              MOVE 'TAX_ID'             TO TABLE-ELEMENT-3              
              MOVE 'ALIAS'              TO TABLE-ELEMENT-4              
              MOVE BS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE BS-BUSINESS-TYPE-CD  TO HOSTVAR-ELEMENT-2            
              MOVE BS-TAX-ID            TO HOSTVAR-ELEMENT-3            
              MOVE BS-ALIAS             TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8150-DELETE-NAME-ACCT-XREF.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME_ACCT_XREF                            
              WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME_ACCT_XREF                                    
MFA-TR*       WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8150'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8151-DELETE-MIA-XREF.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_SEB_MIA_XREF                              
              WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_SEB_MIA_XREF                                      
MFA-TR*       WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8151                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8151'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_SEB_MIA_XREF'    TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8151-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8152-DELETE-CUST-XFER.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUSTOMER_XFER                             
              WHERE  ASSOC_CUSTOMER_NO = :CU-CUSTOMER-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUSTOMER_XFER                                     
MFA-TR*       WHERE  ASSOC_CUSTOMER_NO = :CU-CUSTOMER-NO                        
MFA-TR*       QUERYNO 8152                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8152'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER_XFER'   TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8152-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8160-DELETE-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUSTOMER                                  
              WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUSTOMER                                          
MFA-TR*       WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8160                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8160'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8180-DELETE-NULL-MISC.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_MISC_INFO                            
               WHERE CUSTOMER_NO        =  :LQ-CUSTOMER-NO              
                 AND INFLUENTIAL_CUST   =  ' '                          
                 AND KEY_CUSTOMER       =  ' '                          
                 AND SPECIAL_CUST       =  ' '                          
                 AND CONSULTING_PROJECT =  ' '                          
                 AND CONSLT_PRJ_END_DT  IS NULL                         
                 AND LOSS_RESERVE_CD    =  0                            
                 AND LOSS_RESRVE_EFF_DT IS NULL                         
                 AND IVR_NDO_EXEMPT     = 'N'                           
                 AND BUILDER_FL         = 'N'                           
                 AND REALTOR_FL         = 'N'                           
                 AND LANDLORD_FL        = 'N'                           
                 AND DBA_NAME           = ' '                           
                 AND DBA_TAX_ID         = ' '                           
                 AND WEBSITE_ADDR       = ' '                           
                 AND INTR_CO_IND        = ' '                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_MISC_INFO                                    
MFA-TR*        WHERE CUSTOMER_NO        =  :LQ-CUSTOMER-NO                      
MFA-TR*          AND INFLUENTIAL_CUST   =  ' '                                  
MFA-TR*          AND KEY_CUSTOMER       =  ' '                                  
MFA-TR*          AND SPECIAL_CUST       =  ' '                                  
MFA-TR*          AND CONSULTING_PROJECT =  ' '                                  
MFA-TR*          AND CONSLT_PRJ_END_DT  IS NULL                                 
MFA-TR*          AND LOSS_RESERVE_CD    =  0                                    
MFA-TR*          AND LOSS_RESRVE_EFF_DT IS NULL                                 
MFA-TR*          AND IVR_NDO_EXEMPT     = 'N'                                   
MFA-TR*          AND BUILDER_FL         = 'N'                                   
MFA-TR*          AND REALTOR_FL         = 'N'                                   
MFA-TR*          AND LANDLORD_FL        = 'N'                                   
MFA-TR*          AND DBA_NAME           = ' '                                   
MFA-TR*          AND DBA_TAX_ID         = ' '                                   
MFA-TR*          AND WEBSITE_ADDR       = ' '                                   
MFA-TR*          AND INTR_CO_IND        = ' '                                   
MFA-TR*       QUERYNO 8180                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE LQ-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8190-DELETE-NULL-CSTS.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_STATS                                
               WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO              
                 AND CUSTOMER_TYPE      =  'C'                          
                 AND SSN                =  ' '                          
                 AND CODE_STATE_ID      =  ' '                          
                 AND DRIVERS_LICENSE_NO =  ' '                          
                 AND EMPLOYER           =  ' '                          
                 AND EMPLOYED_DATE      IS NULL                         
                 AND OCCUPATION         =  ' '                          
                 AND OTHER_ID_TYPE      =  ' '                          
                 AND OTHER_ID           =  ' '                          
                 AND DRVR_LIC_ISS_DT    IS NULL                         
                 AND DATE_OF_BIRTH      IS NULL                         
                 AND EMPLOYEE_NBR       =  ' '                          
                 AND INTR_CO_IND        =  ' '                          
                 AND EBILL_REGISTER_IND =  ' '                          
                 AND PASSWORD_HINT_CD   = ' '                           
                 AND PASSWORD_TX        = ' '                           
                 AND REFUSED_SSN_FL     = ' '                           
                 AND LANGUAGE_PREF_CD   = ' '                           
                 AND DOB_VERIFIED_CD    = ' '                           
                 AND ACCESS_LEVEL_CD    = ' '                           
                 AND ALLOW_CALL_FL      = ' '                           
                 AND ITIN_ID            = ' '                           
                 AND VERIFY_SSN_FL      = ' '                           
                 AND PASSWORD_HINT      = ' '                           
                 AND ALLOW_EMAIL_FL     = ' '                           
                 AND INDIV_NAME_ID      = 0                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_STATS                                        
MFA-TR*        WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO                      
MFA-TR*          AND CUSTOMER_TYPE      =  'C'                                  
MFA-TR*          AND SSN                =  ' '                                  
MFA-TR*          AND CODE_STATE_ID      =  ' '                                  
MFA-TR*          AND DRIVERS_LICENSE_NO =  ' '                                  
MFA-TR*          AND EMPLOYER           =  ' '                                  
MFA-TR*          AND EMPLOYED_DATE      IS NULL                                 
MFA-TR*          AND OCCUPATION         =  ' '                                  
MFA-TR*          AND OTHER_ID_TYPE      =  ' '                                  
MFA-TR*          AND OTHER_ID           =  ' '                                  
MFA-TR*          AND DRVR_LIC_ISS_DT    IS NULL                                 
MFA-TR*          AND DATE_OF_BIRTH      IS NULL                                 
MFA-TR*          AND EMPLOYEE_NBR       =  ' '                                  
MFA-TR*          AND INTR_CO_IND        =  ' '                                  
MFA-TR*          AND EBILL_REGISTER_IND =  ' '                                  
MFA-TR*          AND PASSWORD_HINT_CD   = ' '                                   
MFA-TR*          AND PASSWORD_TX        = ' '                                   
MFA-TR*          AND REFUSED_SSN_FL     = ' '                                   
MFA-TR*          AND LANGUAGE_PREF_CD   = ' '                                   
MFA-TR*          AND DOB_VERIFIED_CD    = ' '                                   
MFA-TR*          AND ACCESS_LEVEL_CD    = ' '                                   
MFA-TR*          AND ALLOW_CALL_FL      = ' '                                   
MFA-TR*          AND ITIN_ID            = ' '                                   
MFA-TR*          AND VERIFY_SSN_FL      = ' '                                   
MFA-TR*          AND PASSWORD_HINT      = ' '                                   
MFA-TR*          AND ALLOW_EMAIL_FL     = ' '                                   
MFA-TR*          AND INDIV_NAME_ID      = 0                                     
MFA-TR*       QUERYNO 8190                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8190'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8202-DELETE-NULL-BSTS.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_BUS_CUST_STATS                            
               WHERE CUSTOMER_NO        = :BS-CUSTOMER-NO               
                 AND BUSINESS_TYPE_CD   = ' '                           
                 AND TAX_ID             = ' '                           
                 AND ALIAS              = ' '                           
                 AND INTRA_CO_IND       = ' '                           
                 AND SUBSIDIARY_IND     = ' '                           
                 AND TRADE_ALLY_IND     = ' '                           
                 AND CONTRACTOR_TYPE    = ' '                           
                 AND DUNN_BRAD_ID_NO    = ' '                           
                 AND SOS_STATUS_CD      = ' '                           
                 AND SOS_CONTROL_ID     = ' '                           
                 AND SOS_EFFECTIVE_DT   IS NULL                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_BUS_CUST_STATS                                    
MFA-TR*        WHERE CUSTOMER_NO        = :BS-CUSTOMER-NO                       
MFA-TR*          AND BUSINESS_TYPE_CD   = ' '                                   
MFA-TR*          AND TAX_ID             = ' '                                   
MFA-TR*          AND ALIAS              = ' '                                   
MFA-TR*          AND INTRA_CO_IND       = ' '                                   
MFA-TR*          AND SUBSIDIARY_IND     = ' '                                   
MFA-TR*          AND TRADE_ALLY_IND     = ' '                                   
MFA-TR*          AND CONTRACTOR_TYPE    = ' '                                   
MFA-TR*          AND DUNN_BRAD_ID_NO    = ' '                                   
MFA-TR*          AND SOS_STATUS_CD      = ' '                                   
MFA-TR*          AND SOS_CONTROL_ID     = ' '                                   
MFA-TR*          AND SOS_EFFECTIVE_DT   IS NULL                                 
MFA-TR*       QUERYNO 8202                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8202'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE BS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8202-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8210-DELETE-NULL-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PHONE                                
               WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO               
                 AND PHONE_TYPE         = :CB-PHONE-TYPE                
                 AND PHONE_NO           = ' '                           
                 AND EXTENSION_NO       = ' '                           
                 AND CUSTOMER_TYPE      = 'C'                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PHONE                                        
MFA-TR*        WHERE CUSTOMER_NO        = :CB-CUSTOMER-NO                       
MFA-TR*          AND PHONE_TYPE         = :CB-PHONE-TYPE                        
MFA-TR*          AND PHONE_NO           = ' '                                   
MFA-TR*          AND EXTENSION_NO       = ' '                                   
MFA-TR*          AND CUSTOMER_TYPE      = 'C'                                   
MFA-TR*       QUERYNO 8210                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE-TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8220-DELETE-SPOUSE.                                              
                                                                        
           MOVE WS-SPOUSE-NAME-ID TO DQ-NAME-ID.                        
           EXEC SQL                                                     
              DELETE FROM CSS_NAME                                      
               WHERE NAME_ID = :DQ-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_NAME                                              
MFA-TR*        WHERE NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       QUERYNO 8220                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE        
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '8220'                 TO ACTIVE-PARAGRAPH           
              MOVE 'DELETE'               TO ABEND-FUNCTION             
              MOVE 'CSS_NAME'             TO TABLE-1                    
              MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
              MOVE 'NAME_ID'              TO TABLE-ELEMENT-2            
              MOVE WS-CUSTOMER-NO-NUM     TO HOSTVAR-ELEMENT-1          
              MOVE WS-SPOUSE-NAME-ID      TO HOSTVAR-ELEMENT-2          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8320-UPDATE-MISC.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_MISC_INFO                                 
                 SET INFLUENTIAL_CUST = :LQ-INFLUENTIAL-CUST,           
                     KEY_CUSTOMER = :LQ-KEY-CUSTOMER,                   
                     SPECIAL_CUST = :LQ-SPECIAL-CUST,                   
                     BUILDER_FL = :LQ-BUILDER-FL,                       
                     REALTOR_FL = :LQ-REALTOR-FL                        
               WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_MISC_INFO                                         
MFA-TR*          SET INFLUENTIAL_CUST = :LQ-INFLUENTIAL-CUST,                   
MFA-TR*              KEY_CUSTOMER = :LQ-KEY-CUSTOMER,                           
MFA-TR*              SPECIAL_CUST = :LQ-SPECIAL-CUST,                           
MFA-TR*              BUILDER_FL = :LQ-BUILDER-FL,                               
MFA-TR*              REALTOR_FL = :LQ-REALTOR-FL                                
MFA-TR*        WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8320                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8320'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE LQ-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8330-UPDATE-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUSTOMER                                       
                 SET LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                     :CU-LAST-UPDATE-TS
              ),               
                     DHR_FL = :CU-DHR-FL,                               
                     LANDLORD_REVERT_FL = :CU-LANDLORD-REVERT-FL,       
                     VALIDATION_TS = CIS.CHAR2TIMESTAMP(
                                                     :CU-LAST-UPDATE-TS
              )                 
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUSTOMER                                               
MFA-TR*          SET LAST_UPDATE_TS = :CU-LAST-UPDATE-TS,                       
MFA-TR*              DHR_FL = :CU-DHR-FL,                                       
MFA-TR*              LANDLORD_REVERT_FL = :CU-LANDLORD-REVERT-FL,               
MFA-TR*              VALIDATION_TS = :CU-LAST-UPDATE-TS                         
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8330                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8330'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER'       TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8340-UPDATE-CSTS.                                                
                                                                        
           IF CE-DATE-OF-BIRTH <= SPACES                                
               MOVE -1 TO WS-NULL-3                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-3
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
                 SET SSN = :CE-SSN,                                     
                     CODE_STATE_ID = :CE-CODE-STATE-ID,                 
                     DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO,       
                     OTHER_ID_TYPE = :CE-OTHER-ID-TYPE,                 
                     OTHER_ID = :CE-OTHER-ID,                           
                     DATE_OF_BIRTH = IIF(TRY_CONVERT(DATE, 
                                                     :CE-DATE-OF-BIRTH 
                                                           :WS-NULL-3
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                             :WS-NULL-3
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-3
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-3
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-3) ),       
                     REFUSED_SSN_FL = :CE-REFUSED-SSN-FL,               
                     DOB_VERIFIED_CD = :CE-DOB-VERIFIED-CD,             
                     ITIN_ID = :CE-ITIN-ID,                             
                     VERIFY_SSN_FL = :CE-VERIFY-SSN-FL,                 
                     INDIV_NAME_ID = :CE-INDIV-NAME-ID                  
               WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                      
                 AND CUSTOMER_TYPE = 'C'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*          SET SSN = :CE-SSN,                                             
MFA-TR*              CODE_STATE_ID = :CE-CODE-STATE-ID,                         
MFA-TR*              DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO,               
MFA-TR*              OTHER_ID_TYPE = :CE-OTHER-ID-TYPE,                         
MFA-TR*              OTHER_ID = :CE-OTHER-ID,                                   
MFA-TR*              DATE_OF_BIRTH = :CE-DATE-OF-BIRTH:WS-NULL-3,               
MFA-TR*              REFUSED_SSN_FL = :CE-REFUSED-SSN-FL,                       
MFA-TR*              DOB_VERIFIED_CD = :CE-DOB-VERIFIED-CD,                     
MFA-TR*              ITIN_ID = :CE-ITIN-ID,                                     
MFA-TR*              VERIFY_SSN_FL = :CE-VERIFY-SSN-FL,                         
MFA-TR*              INDIV_NAME_ID = :CE-INDIV-NAME-ID                          
MFA-TR*        WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*       QUERYNO 8340                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8340'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CE-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_TYPE'       TO TABLE-ELEMENT-2             
              MOVE 'C'                   TO HOSTVAR-ELEMENT-2           
              MOVE 'DRIVERS_LICENSE_NO'  TO TABLE-ELEMENT-3             
              MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-3           
              MOVE 'DATE_OF_BIRTH'       TO TABLE-ELEMENT-4             
              MOVE CE-DATE-OF-BIRTH      TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8350-UPDATE-BSTS.                                                
                                                                        
           IF BS-SOS-EFFECTIVE-DT <= SPACES                             
               MOVE -1 TO WS-NULL-4                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-4
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_BUS_CUST_STATS                                 
                 SET BUSINESS_TYPE_CD  = :BS-BUSINESS-TYPE-CD,          
                     TAX_ID = :BS-TAX-ID,                               
                     SOS_STATUS_CD = :BS-SOS-STATUS-CD,                 
                     SOS_CONTROL_ID = :BS-SOS-CONTROL-ID,               
                     SOS_EFFECTIVE_DT = IIF(TRY_CONVERT(DATE, 
                                                  :BS-SOS-EFFECTIVE-DT 
                                                              :WS-NULL-4
              ) IS NULL OR (PATINDEX('%.%', :BS-SOS-EFFECTIVE-DT 
                                                             :WS-NULL-4
              ) <> 0) OR (LEN(:BS-SOS-EFFECTIVE-DT :WS-NULL-4
              ) <> 10), CIS.CHAR2DATE(:BS-SOS-EFFECTIVE-DT :WS-NULL-4
              ), CONVERT(DATE, :BS-SOS-EFFECTIVE-DT :WS-NULL-4) )  
               WHERE CUSTOMER_NO = :BS-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BUS_CUST_STATS                                         
MFA-TR*          SET BUSINESS_TYPE_CD  = :BS-BUSINESS-TYPE-CD,                  
MFA-TR*              TAX_ID = :BS-TAX-ID,                                       
MFA-TR*              SOS_STATUS_CD = :BS-SOS-STATUS-CD,                         
MFA-TR*              SOS_CONTROL_ID = :BS-SOS-CONTROL-ID,                       
MFA-TR*              SOS_EFFECTIVE_DT = :BS-SOS-EFFECTIVE-DT:WS-NULL-4          
MFA-TR*        WHERE CUSTOMER_NO = :BS-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8350                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8350'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'BUSINESS_TYPE_CD'   TO TABLE-ELEMENT-2              
              MOVE 'TAX_ID'             TO TABLE-ELEMENT-3              
              MOVE 'ALIAS'              TO TABLE-ELEMENT-4              
              MOVE BS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE BS-BUSINESS-TYPE-CD  TO HOSTVAR-ELEMENT-2            
              MOVE BS-TAX-ID            TO HOSTVAR-ELEMENT-3            
              MOVE BS-ALIAS             TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8360-UPDATE-PHONE.                                               
                                                                        
           IF CB-PERMISN-TO-MKT-DT <= ' '                               
               MOVE -1 TO WS-NULL-5                                     
           ELSE                                                         
               MOVE 0 TO WS-NULL-5
           END-IF.                                     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_PHONE                                     
                 SET PHONE_NO = :CB-PHONE-NO,                           
                     EXTENSION_NO = :CB-EXTENSION-NO,                   
                     MOBILE_PHONE_FL = :CB-MOBILE-PHONE-FL,             
                     PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,         
                     PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-5
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-5
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-5
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-5
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-5) )
               WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                      
                 AND PHONE_TYPE    = :CB-PHONE-TYPE                     
                 AND CUSTOMER_TYPE = 'C'                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_PHONE                                             
MFA-TR*          SET PHONE_NO = :CB-PHONE-NO,                                   
MFA-TR*              EXTENSION_NO = :CB-EXTENSION-NO,                           
MFA-TR*              MOBILE_PHONE_FL = :CB-MOBILE-PHONE-FL,                     
MFA-TR*              PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :CB-PERMISN-TO-MKT-DT:WS-NULL-5        
MFA-TR*        WHERE CUSTOMER_NO = :CB-CUSTOMER-NO                              
MFA-TR*          AND PHONE_TYPE    = :CB-PHONE-TYPE                             
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*       QUERYNO 8360                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8360'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3              
              MOVE 'C'                  TO HOSTVAR-ELEMENT-3            
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4              
              MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8370-UPDATE-NAME.                                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
                 SET NAME_FORMAT = :DQ-NAME-FORMAT,                     
                     FIRST_NAME = :DQ-FIRST-NAME,                       
                     MIDDLE_NAME = :DQ-MIDDLE-NAME,                     
                     LAST_NAME = :DQ-LAST-NAME,                         
                     TITLE_PREFIX = :DQ-TITLE-PREFIX,                   
                     TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1,               
                     FULL_NAME = :DQ-FULL-NAME,                         
                     NICKNAME = :DQ-NICKNAME                            
               WHERE NAME_ID = :DQ-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*          SET NAME_FORMAT = :DQ-NAME-FORMAT,                             
MFA-TR*              FIRST_NAME = :DQ-FIRST-NAME,                               
MFA-TR*              MIDDLE_NAME = :DQ-MIDDLE-NAME,                             
MFA-TR*              LAST_NAME = :DQ-LAST-NAME,                                 
MFA-TR*              TITLE_PREFIX = :DQ-TITLE-PREFIX,                           
MFA-TR*              TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1,                       
MFA-TR*              FULL_NAME = :DQ-FULL-NAME,                                 
MFA-TR*              NICKNAME = :DQ-NICKNAME                                    
MFA-TR*        WHERE NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       QUERYNO 8370                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8370'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'NAME_FORMAT'        TO TABLE-ELEMENT-2              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-3              
              MOVE 'MIDDLE_NAME'        TO TABLE-ELEMENT-4              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-NAME-FORMAT       TO HOSTVAR-ELEMENT-2            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-3            
              MOVE DQ-MIDDLE-NAME       TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8370-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8375-UPDATE-IB-NAME.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_NAME                                           
                 SET FIRST_NAME  = :DQ-FIRST-NAME,                      
                     MIDDLE_NAME = :DQ-MIDDLE-NAME,                     
                     LAST_NAME = :DQ-LAST-NAME,                         
                     TITLE_PREFIX = :DQ-TITLE-PREFIX,                   
                     TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1                
               WHERE NAME_ID = :DQ-NAME-ID                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NAME                                                   
MFA-TR*          SET FIRST_NAME  = :DQ-FIRST-NAME,                              
MFA-TR*              MIDDLE_NAME = :DQ-MIDDLE-NAME,                             
MFA-TR*              LAST_NAME = :DQ-LAST-NAME,                                 
MFA-TR*              TITLE_PREFIX = :DQ-TITLE-PREFIX,                           
MFA-TR*              TITLE_SUFFIX_1 = :DQ-TITLE-SUFFIX-1                        
MFA-TR*        WHERE NAME_ID = :DQ-NAME-ID                                      
MFA-TR*       QUERYNO 8375                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8375'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'NAME_ID'            TO TABLE-ELEMENT-1              
              MOVE 'FIRST_NAME'         TO TABLE-ELEMENT-2              
              MOVE 'MIDDLE_NAME'        TO TABLE-ELEMENT-3              
              MOVE DQ-NAME-ID           TO HOSTVAR-ELEMENT-1            
              MOVE DQ-FIRST-NAME        TO HOSTVAR-ELEMENT-2            
              MOVE DQ-MIDDLE-NAME       TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8375-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8380-UPDATE-VALIDATION.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUSTOMER                                       
                 SET VALIDATION_TS = CIS.CHAR2TIMESTAMP(
                                                      :CU-VALIDATION-TS
              ),                 
                     LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(
                                                      :CU-VALIDATION-TS
              )                 
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUSTOMER                                               
MFA-TR*          SET VALIDATION_TS = :CU-VALIDATION-TS,                         
MFA-TR*              LAST_UPDATE_TS = :CU-VALIDATION-TS                         
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8380                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8380'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUSTOMER'       TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE CU-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8380-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-DELETE-BUS-CUST.                                            
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_BUS_CUST_STATS                            
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_BUS_CUST_STATS                                    
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 8400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                   CONTINUE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8400'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_BUS_CUST_STATS'  TO TABLE-1                     
              MOVE 'CUSTOMER-NO'         TO TABLE-ELEMENT-1             
              MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29700000
              INCLUDE CPD00013                                          29710000
           END-EXEC.                                                    29720000
                                                                        
           EXEC SQL                                                     29740000
              INCLUDE CPD00071                                          29750000
           END-EXEC.                                                    29760000
                                                                        
           EXEC SQL                                                     29780000
              INCLUDE CPD00091                                          29790000
           END-EXEC.                                                    29800000
                                                                        
           EXEC SQL                                                     29820000
              INCLUDE CPD00093                                          29830000
           END-EXEC.                                                    29840000
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     16360000
                INCLUDE CPD00331                                        16360000
           END-EXEC.                                                    16360000
