       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04495.                                          
COB303 DATE-WRITTEN. DECEMBER 12, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS CUSTOMER DATA.                          *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/12/13    FMB      NEW PROGRAM.                                      
A05317*  04/26/16    FMB      BOTH OTHER ID AND TYPE MUST BE PRESENT            
A05317*                       TO BE RETURNED.                                   
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04495'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04495 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBSCSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBEMAIL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRHIST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREMLN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCOAPP                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBROOMT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHCOAPP                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHROOMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04495_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04495_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-CUSTOMER-NO       PIC S9(13)V COMP-3 VALUE 0.       
               10 S-COMPANY-NO        PIC X(02) VALUE SPACES.           
               10 S-NAME-FORMAT       PIC X(01) VALUE SPACES.           
               10 S-TITLE             PIC X(09) VALUE SPACES.           
               10 S-FIRST-NAME        PIC X(15) VALUE SPACES.           
               10 S-MIDDLE-NAME       PIC X(15) VALUE SPACES.           
               10 S-LAST-NAME         PIC X(40) VALUE SPACES.           
               10 S-SUFFIX            PIC X(03) VALUE SPACES.           
               10 S-BUSINESS-NAME     PIC X(70) VALUE SPACES.           
               10 S-SSN               PIC X(09) VALUE SPACES.           
               10 S-ITIN              PIC X(09) VALUE SPACES.           
               10 S-REFUSED-SSN       PIC X(01) VALUE SPACES.           
               10 S-TAX-ID            PIC X(09) VALUE SPACES.           
               10 S-DLN               PIC X(19) VALUE SPACES.           
               10 S-DLN-STATE         PIC X(02) VALUE SPACES.           
               10 S-DOB               PIC X(10) VALUE SPACES.           
               10 S-OTHER-ID-TYPE     PIC X(12) VALUE SPACES.           
               10 S-OTHER-ID          PIC X(16) VALUE SPACES.           
               10 S-SOS-STATUS-CD     PIC X(02) VALUE SPACES.           
               10 S-SOS-CONTROL-ID    PIC X(15) VALUE SPACES.           
               10 S-SOS-EFFECTIVE-DT  PIC X(10) VALUE SPACES.           
               10 S-KEY-CUST          PIC X(02) VALUE SPACES.           
               10 S-INFLUENTIAL-CUST  PIC X(02) VALUE SPACES.           
               10 S-SPECIAL-CUST      PIC X(02) VALUE SPACES.           
               10 S-BUILDER-FL        PIC X(01) VALUE SPACES.           
               10 S-LANDLORD-FL       PIC X(01) VALUE SPACES.           
               10 S-LL-REVERT-FL      PIC X(01) VALUE SPACES.           
               10 S-REALTOR-FL        PIC X(01) VALUE SPACES.           
               10 S-SEASONAL-FL       PIC X(01) VALUE SPACES.           
               10 S-BUSINESS-TYPE     PIC X(01) VALUE SPACES.           
               10 S-VERIFY-SSN        PIC X(01) VALUE SPACES.           
               10 S-DHR-QUALIFIED     PIC X(01) VALUE SPACES.           
               10 S-DOB-VERIFIED      PIC X(01) VALUE SPACES.           
               10 S-DELETE-FL         PIC X(01) VALUE SPACES.           
               10 S-DISABLE-NAME-FL   PIC X(01) VALUE SPACES.           
               10 S-CUSTOMER-EST-DT   PIC X(10) VALUE SPACES.           
               10 S-SERVICE-EST-DT    PIC X(10) VALUE SPACES.           
               10 S-AGL-CUST-NO       PIC S9(9)V COMP-3 VALUE 0.        
               10 S-SECURED-RATE-FL   PIC X(01) VALUE SPACES.           
               10 S-COMPANY-CHG-FL    PIC X(01) VALUE SPACES.           
               10 S-MASK-SSN-FL       PIC X(01) VALUE SPACES.           
               10 S-IB-TITLE          PIC X(09) VALUE SPACES.           
               10 S-IB-FIRST-NAME     PIC X(15) VALUE SPACES.           
               10 S-IB-MIDDLE-NAME    PIC X(15) VALUE SPACES.           
               10 S-IB-LAST-NAME      PIC X(40) VALUE SPACES.           
               10 S-IB-SUFFIX         PIC X(03) VALUE SPACES.           
               10 S-VALIDATION-TS     PIC X(10) VALUE SPACES.           
               10 S-CONFIRM-FL        PIC X(01) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04495'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-8                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-9                PIC S9(4) COMP VALUE +0.        
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  WS-CUT-OFF-DT            PIC X(10) VALUE SPACES.         
           05  WS-MASK-SSN-CUST-DAYS    PIC 9(09) VALUE 0.              
           05  WS-MASK-SSN-SCORE-HOURS  PIC 9(09) VALUE 0.              
           05  WS-CURRENT-DT-NUM        PIC 9(08) VALUE 0.              
           05  WS-CURRENT-HR-NUM        PIC 9(08) VALUE 0.              
           05  WS-DATE.                                                 
               10  WS-DATE-YYYY         PIC X(04).                      
               10  WS-DATE-MM           PIC X(02).                      
               10  WS-DATE-DD           PIC X(02).                      
           05  WS-DATE-R REDEFINES WS-DATE PIC 9(08).                   
           05  WS-DAYS                  PIC 9(09) VALUE 0.              
           05  WS-HOURS                 PIC S9(09) VALUE 0.             
           05  WS-SPACES                PIC S9(02) COMP-3 VALUE +0.     
           05  WS-LENGTH                PIC S9(02) COMP-3 VALUE +0.     
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1    AS RETURN_CODE,               
                      :S-STATUS-CODE      AS STATUS_CD,                 
                      :S-CUSTOMER-NO      AS CUSTOMER_NO,               
                      :S-COMPANY-NO       AS COMPANY_NO,                
                      :S-NAME-FORMAT      AS NAME_FORMAT,               
                      :S-TITLE            AS TITLE,                     
                      :S-FIRST-NAME       AS FIRST_NAME,                
                      :S-MIDDLE-NAME      AS MIDDLE_NAME,               
                      :S-LAST-NAME        AS LAST_NAME,                 
                      :S-SUFFIX           AS SUFFIX,                    
                      :S-BUSINESS-NAME    AS BUSINESS_NAME,             
                      :S-SSN              AS SSN,                       
                      :S-ITIN             AS ITIN,                      
                      :S-REFUSED-SSN      AS REFUSED_SSN,               
                      :S-TAX-ID           AS TAX_ID,                    
                      :S-DLN              AS DLN,                       
                      :S-DLN-STATE        AS DLN_STATE,                 
                      :S-DOB              AS DOB,                       
                      :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,             
                      :S-OTHER-ID         AS OTHER_ID,                  
                      :S-SOS-STATUS-CD    AS SOS_STATUS_CD,             
                      :S-SOS-CONTROL-ID   AS SOS_CONTROL_ID,            
                      :S-SOS-EFFECTIVE-DT AS SOS_EFFECTIVE_DT,          
                      :S-KEY-CUST         AS KEY_CUST,                  
                      :S-INFLUENTIAL-CUST AS INFLUENTIAL_CUST,          
                      :S-SPECIAL-CUST     AS SPECIAL_CUST,              
                      :S-BUILDER-FL       AS BUILDER_FL,                
                      :S-LANDLORD-FL      AS LANDLORD_FL,               
                      :S-LL-REVERT-FL     AS LL_REVERT_FL,              
                      :S-REALTOR-FL       AS REALTOR_FL,                
                      :S-SEASONAL-FL      AS SEASONAL_FL,               
                      :S-BUSINESS-TYPE    AS BUSINESS_TYPE,             
                      :S-VERIFY-SSN       AS VERIFY_SSN,                
                      :S-DHR-QUALIFIED    AS DHR_QUALIFIED,             
                      :S-DOB-VERIFIED     AS DOB_VERIFIED,              
                      :S-DELETE-FL        AS RESTRICT_DELETE_FL,        
                      :S-DISABLE-NAME-FL  AS DISABLE_NAME_FL,           
                      :S-CUSTOMER-EST-DT  AS CUSTOMER_EST_DT,           
                      :S-SERVICE-EST-DT   AS SERVICE_EST_DT,            
                      :S-AGL-CUST-NO      AS AGL_CUST_NO,               
                      :S-SECURED-RATE-FL  AS SECURED_RATE_FL,           
                      :S-COMPANY-CHG-FL   AS ALLOW_COMPANY_CHG_FL,      
                      :S-MASK-SSN-FL      AS MASK_SSN_FL,               
                      :S-IB-TITLE         AS IB_TITLE,                  
                      :S-IB-FIRST-NAME    AS IB_FIRST_NAME,             
                      :S-IB-MIDDLE-NAME   AS IB_MIDDLE_NAME,            
                      :S-IB-LAST-NAME     AS IB_LAST_NAME,              
                      :S-IB-SUFFIX        AS IB_SUFFIX,                 
                      :S-VALIDATION-TS    AS VALIDATION_TS,             
                      :S-CONFIRM-FL       AS CONFORM_FL                 
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1    AS RETURN_CODE,                       
MFA-TR*               :S-STATUS-CODE      AS STATUS_CD,                         
MFA-TR*               :S-CUSTOMER-NO      AS CUSTOMER_NO,                       
MFA-TR*               :S-COMPANY-NO       AS COMPANY_NO,                        
MFA-TR*               :S-NAME-FORMAT      AS NAME_FORMAT,                       
MFA-TR*               :S-TITLE            AS TITLE,                             
MFA-TR*               :S-FIRST-NAME       AS FIRST_NAME,                        
MFA-TR*               :S-MIDDLE-NAME      AS MIDDLE_NAME,                       
MFA-TR*               :S-LAST-NAME        AS LAST_NAME,                         
MFA-TR*               :S-SUFFIX           AS SUFFIX,                            
MFA-TR*               :S-BUSINESS-NAME    AS BUSINESS_NAME,                     
MFA-TR*               :S-SSN              AS SSN,                               
MFA-TR*               :S-ITIN             AS ITIN,                              
MFA-TR*               :S-REFUSED-SSN      AS REFUSED_SSN,                       
MFA-TR*               :S-TAX-ID           AS TAX_ID,                            
MFA-TR*               :S-DLN              AS DLN,                               
MFA-TR*               :S-DLN-STATE        AS DLN_STATE,                         
MFA-TR*               :S-DOB              AS DOB,                               
MFA-TR*               :S-OTHER-ID-TYPE    AS OTHER_ID_TYPE,                     
MFA-TR*               :S-OTHER-ID         AS OTHER_ID,                          
MFA-TR*               :S-SOS-STATUS-CD    AS SOS_STATUS_CD,                     
MFA-TR*               :S-SOS-CONTROL-ID   AS SOS_CONTROL_ID,                    
MFA-TR*               :S-SOS-EFFECTIVE-DT AS SOS_EFFECTIVE_DT,                  
MFA-TR*               :S-KEY-CUST         AS KEY_CUST,                          
MFA-TR*               :S-INFLUENTIAL-CUST AS INFLUENTIAL_CUST,                  
MFA-TR*               :S-SPECIAL-CUST     AS SPECIAL_CUST,                      
MFA-TR*               :S-BUILDER-FL       AS BUILDER_FL,                        
MFA-TR*               :S-LANDLORD-FL      AS LANDLORD_FL,                       
MFA-TR*               :S-LL-REVERT-FL     AS LL_REVERT_FL,                      
MFA-TR*               :S-REALTOR-FL       AS REALTOR_FL,                        
MFA-TR*               :S-SEASONAL-FL      AS SEASONAL_FL,                       
MFA-TR*               :S-BUSINESS-TYPE    AS BUSINESS_TYPE,                     
MFA-TR*               :S-VERIFY-SSN       AS VERIFY_SSN,                        
MFA-TR*               :S-DHR-QUALIFIED    AS DHR_QUALIFIED,                     
MFA-TR*               :S-DOB-VERIFIED     AS DOB_VERIFIED,                      
MFA-TR*               :S-DELETE-FL        AS RESTRICT_DELETE_FL,                
MFA-TR*               :S-DISABLE-NAME-FL  AS DISABLE_NAME_FL,                   
MFA-TR*               :S-CUSTOMER-EST-DT  AS CUSTOMER_EST_DT,                   
MFA-TR*               :S-SERVICE-EST-DT   AS SERVICE_EST_DT,                    
MFA-TR*               :S-AGL-CUST-NO      AS AGL_CUST_NO,                       
MFA-TR*               :S-SECURED-RATE-FL  AS SECURED_RATE_FL,                   
MFA-TR*               :S-COMPANY-CHG-FL   AS ALLOW_COMPANY_CHG_FL,              
MFA-TR*               :S-MASK-SSN-FL      AS MASK_SSN_FL,                       
MFA-TR*               :S-IB-TITLE         AS IB_TITLE,                          
MFA-TR*               :S-IB-FIRST-NAME    AS IB_FIRST_NAME,                     
MFA-TR*               :S-IB-MIDDLE-NAME   AS IB_MIDDLE_NAME,                    
MFA-TR*               :S-IB-LAST-NAME     AS IB_LAST_NAME,                      
MFA-TR*               :S-IB-SUFFIX        AS IB_SUFFIX,                         
MFA-TR*               :S-VALIDATION-TS    AS VALIDATION_TS,                     
MFA-TR*               :S-CONFIRM-FL       AS CONFORM_FL                         
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO        PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF LINK-CUSTOMER-NO = ZEROES                                 
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
               MOVE 'ALL PARMS ZERO' TO S-LAST-NAME                     
               ADD +1 TO CTR-ROWS                                       
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-1.                              
                                                                        
           PERFORM 7000-SELECT-CUSTOMER THRU 7000-EXIT.                 
           PERFORM 7100-SELECT-CUST-STATS THRU 7100-EXIT.               
           PERFORM 7200-SELECT-BUS-STATS THRU 7200-EXIT.                
           PERFORM 7300-SELECT-MISC-INFO THRU 7300-EXIT.                
           PERFORM 7600-SECURED-RATE THRU 7600-EXIT.                    
                                                                        
           MOVE CU-CUSTOMER-NO         TO S-CUSTOMER-NO.                
           MOVE DQ-NAME-FORMAT         TO S-NAME-FORMAT.                
           MOVE CU-COMPANY-NO-ORIG     TO S-COMPANY-NO.                 
           MOVE CU-DHR-FL              TO S-DHR-QUALIFIED.              
           MOVE CU-LANDLORD-REVERT-FL  TO S-LL-REVERT-FL.               
           MOVE CU-VALIDATION-TS(1:10) TO S-VALIDATION-TS.              
           MOVE 'CASA-CONTACT-CONFIRM' TO C8-DELINQ-CD.                 
           MOVE CU-COMPANY-NO-ORIG TO C8-COMPANY-NO.                    
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           EVALUATE C8-DELINQ-VALUE                                     
               WHEN 0                                                   
                   MOVE 'N' TO S-CONFIRM-FL                             
               WHEN 1                                                   
                   MOVE 'Y' TO S-CONFIRM-FL                             
           END-EVALUATE.                                                
           IF DQ-NAME-FORMAT = 'I'                                      
              MOVE DQ-FIRST-NAME       TO S-FIRST-NAME                  
              MOVE DQ-MIDDLE-NAME      TO S-MIDDLE-NAME                 
              MOVE DQ-LAST-NAME        TO S-LAST-NAME                   
              MOVE DQ-TITLE-PREFIX     TO S-TITLE                       
              MOVE DQ-TITLE-SUFFIX-1   TO S-SUFFIX                      
           ELSE                                                         
              MOVE DQ-FULL-NAME        TO S-BUSINESS-NAME               
              IF CE-INDIV-NAME-ID > 0                                   
                  PERFORM 7015-GET-INDIV-NAME THRU 7015-EXIT            
                  MOVE DQ-FIRST-NAME TO S-IB-FIRST-NAME                 
                  MOVE DQ-MIDDLE-NAME TO S-IB-MIDDLE-NAME               
                  MOVE DQ-LAST-NAME TO S-IB-LAST-NAME                   
                  MOVE DQ-TITLE-PREFIX TO S-IB-TITLE                    
                  MOVE DQ-TITLE-SUFFIX-1 TO S-IB-SUFFIX                 
              ELSE                                                      
                  MOVE SPACES TO CE-SSN
              END-IF
           END-IF.                                
           IF (DQ-FIRST-NAME = 'INACTIVE' AND                           
               DQ-LAST-NAME = 'ACCOUNT') OR                             
              (DQ-LAST-NAME = 'INACTIVE' AND                            
               DQ-FIRST-NAME = 'ACCOUNT')                               
                   MOVE 'Y' TO S-DISABLE-NAME-FL
           END-IF.                       
           MOVE CU-CUSTOMER-EST-DATE TO S-CUSTOMER-EST-DT.              
           MOVE CU-SERVICE-EST-DATE TO S-SERVICE-EST-DT.                
           MOVE CU-AGL-CUST-NO TO S-AGL-CUST-NO.                        
                                                                        
           MOVE CE-SSN TO S-SSN.                                        
           IF CE-SSN > ' '                                              
               PERFORM 2400-SSN-MASKING THRU 2400-EXIT
           END-IF.                 
           MOVE CE-CODE-STATE-ID TO S-DLN-STATE.                        
           MOVE CE-DRIVERS-LICENSE-NO TO S-DLN.                         
           MOVE CE-OTHER-ID-TYPE TO S-OTHER-ID-TYPE.                    
           MOVE CE-OTHER-ID TO S-OTHER-ID.                              
           IF (CE-OTHER-ID > ' ' AND                                    
               CE-OTHER-ID-TYPE <= ' ') OR                              
              (CE-OTHER-ID <= ' ' AND                                   
               CE-OTHER-ID-TYPE > ' ')                                  
                   MOVE SPACES TO S-OTHER-ID-TYPE                       
                                  S-OTHER-ID
           END-IF.                           
           MOVE CE-REFUSED-SSN-FL TO S-REFUSED-SSN.                     
           MOVE CE-DOB-VERIFIED-CD TO S-DOB-VERIFIED.                   
           MOVE CE-DATE-OF-BIRTH TO S-DOB.                              
           MOVE CE-VERIFY-SSN-FL TO S-VERIFY-SSN.                       
           MOVE CE-ITIN-ID TO S-ITIN.                                   
           IF CE-OTHER-ID-TYPE = 'ITIN' AND                             
              S-ITIN <= SPACES AND                                      
              CE-OTHER-ID(1:1) = '9'                                    
                  MOVE 0 TO WS-SPACES WS-LENGTH                         
                  INSPECT FUNCTION REVERSE (CE-OTHER-ID) TALLYING       
                      WS-SPACES FOR LEADING SPACES                      
                  COMPUTE WS-LENGTH = 16 - WS-SPACES                    
                  IF WS-LENGTH = 9 OR 11                                
                      PERFORM 2100-FORMAT-ITIN THRU 2100-EXIT           
                      IF S-ITIN > SPACES                                
                          MOVE SPACES TO S-OTHER-ID                     
                                         S-OTHER-ID-TYPE
                      END-IF
                  END-IF
           END-IF.               
           IF S-ITIN > SPACES AND                                       
              S-OTHER-ID-TYPE = 'ITIN'                                  
                  MOVE SPACES TO S-OTHER-ID                             
                                 S-OTHER-ID-TYPE
           END-IF.                       
                                                                        
                                                                        
           MOVE BS-BUSINESS-TYPE-CD TO S-BUSINESS-TYPE.                 
           MOVE BS-TAX-ID TO S-TAX-ID.                                  
           MOVE BS-SOS-STATUS-CD TO S-SOS-STATUS-CD.                    
           MOVE BS-SOS-CONTROL-ID TO S-SOS-CONTROL-ID.                  
           MOVE BS-SOS-EFFECTIVE-DT TO S-SOS-EFFECTIVE-DT.              
                                                                        
           MOVE LQ-BUILDER-FL TO S-BUILDER-FL.                          
           MOVE LQ-REALTOR-FL TO S-REALTOR-FL.                          
           MOVE LQ-LANDLORD-FL TO S-LANDLORD-FL.                        
           MOVE LQ-KEY-CUSTOMER TO S-KEY-CUST.                          
           MOVE LQ-INFLUENTIAL-CUST TO S-INFLUENTIAL-CUST.              
           MOVE LQ-SPECIAL-CUST TO S-SPECIAL-CUST.                      
                                                                        
           MOVE RD-SECURED-RATE-FL TO S-SECURED-RATE-FL.                
                                                                        
           PERFORM 7700-CHECK-ACCOUNT THRU 7700-EXIT.                   
           IF S-DELETE-FL NOT = 'Y'                                     
               PERFORM 7705-CHECK-ARCHIVE THRU 7705-EXIT
           END-IF.               
           IF S-DELETE-FL NOT = 'Y'                                     
               PERFORM 7710-CHECK-ROOMMATE THRU 7710-EXIT
           END-IF.              
           IF S-DELETE-FL NOT = 'Y'                                     
               PERFORM 7715-CHECK-COAPP THRU 7715-EXIT
           END-IF.                 
           IF S-DELETE-FL NOT = 'Y'                                     
               PERFORM 7720-CHECK-H-ROOMMATE THRU 7720-EXIT
           END-IF.            
           IF S-DELETE-FL NOT = 'Y'                                     
               PERFORM 7725-CHECK-H-COAPP THRU 7725-EXIT
           END-IF.               
           IF S-DELETE-FL NOT = 'Y'                                     
               PERFORM 7750-CHECK-CREDIT-HIST THRU 7750-EXIT
           END-IF.           
           IF S-DELETE-FL NOT = 'Y'                                     
               PERFORM 7800-CHECK-GAS-LINE THRU 7800-EXIT
           END-IF.              
           IF S-DELETE-FL NOT = 'Y'                                     
               PERFORM 7810-CHECK-LANDLORD THRU 7810-EXIT
           END-IF.              
                                                                        
           ADD +1 TO CTR-ROWS.                                          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FORMAT-ITIN.                                                
                                                                        
           IF CE-OTHER-ID(1:9) NUMERIC                                  
               MOVE CE-OTHER-ID(1:9) TO S-ITIN                          
           ELSE                                                         
               IF CE-OTHER-ID(4:1) = '-' AND                            
                  CE-OTHER-ID(7:1) = '-' AND                            
                  CE-OTHER-ID(1:3) NUMERIC AND                          
                  CE-OTHER-ID(5:2) NUMERIC AND                          
                  CE-OTHER-ID(8:4) NUMERIC                              
                      MOVE CE-OTHER-ID(1:3) TO S-ITIN(1:3)              
                      MOVE CE-OTHER-ID(5:2) TO S-ITIN(4:2)              
                      MOVE CE-OTHER-ID(8:4) TO S-ITIN(6:4)
               END-IF
           END-IF.             
           IF S-ITIN > SPACES AND                                       
             (S-ITIN(4:1) = '7' OR '8' OR '9') AND                      
              S-ITIN(4:2) NOT = '89' AND                                
              S-ITIN(4:2) NOT = '93'                                    
                  CONTINUE                                              
           ELSE                                                         
               MOVE SPACES TO S-ITIN
           END-IF.                                   
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-SSN-MASKING.                                                
                                                                        
           MOVE 'N' TO S-MASK-SSN-FL.                                   
                                                                        
           MOVE 'MASK-SSN-CUST-DAYS' TO C8-DELINQ-CD.                   
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-MASK-SSN-CUST-DAYS.               
                                                                        
           MOVE 'MASK-SSN-SCORE-HOURS' TO C8-DELINQ-CD.                 
           MOVE '01' TO C8-COMPANY-NO.                                  
           PERFORM 7010-GET-DELINQUENCY-VALUES THRU 7010-EXIT.          
           MOVE C8-DELINQ-VALUE TO WS-MASK-SSN-SCORE-HOURS.             
                                                                        
           MOVE FUNCTION CURRENT-DATE(1:8) TO WS-CURRENT-DT-NUM.        
           MOVE CU-CUSTOMER-EST-DATE(1:4) TO WS-DATE-YYYY.              
           MOVE CU-CUSTOMER-EST-DATE(6:2) TO WS-DATE-MM.                
           MOVE CU-CUSTOMER-EST-DATE(9:2) TO WS-DATE-DD.                
           COMPUTE WS-DAYS =                                            
               FUNCTION INTEGER-OF-DATE (WS-CURRENT-DT-NUM) -           
               FUNCTION INTEGER-OF-DATE (WS-DATE-R).                    
                                                                        
           IF WS-DAYS > WS-MASK-SSN-CUST-DAYS                           
               MOVE 'Y' TO S-MASK-SSN-FL                                
               PERFORM 7775-CREDIT-HIST-DATE THRU 7775-EXIT             
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   MOVE FUNCTION CURRENT-DATE(9:2) TO WS-CURRENT-HR-NUM 
                   MOVE CK-CR-HIST-TRAN-DT(1:4) TO WS-DATE-YYYY         
                   MOVE CK-CR-HIST-TRAN-DT(6:2) TO WS-DATE-MM           
                   MOVE CK-CR-HIST-TRAN-DT(9:2) TO WS-DATE-DD           
                   MOVE CK-CR-HIST-TRAN-TM(1:2) TO WS-HOURS             
                   COMPUTE WS-DAYS =                                    
                       FUNCTION INTEGER-OF-DATE (WS-CURRENT-DT-NUM) -   
                       FUNCTION INTEGER-OF-DATE (WS-DATE-R)             
                   COMPUTE WS-HOURS = WS-CURRENT-HR-NUM - WS-HOURS      
                   IF WS-DAYS > 0                                       
                       COMPUTE WS-HOURS = (WS-DAYS * 24) + WS-HOURS     
                   END-IF                                               
                   IF WS-HOURS < WS-MASK-SSN-SCORE-HOURS                
                       MOVE 'N' TO S-MASK-SSN-FL                        
                   END-IF                                               
               ELSE                                                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE
               END-IF
           END-IF.                
                                                                        
       2400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) CUSTOMER_EST_DATE,
              SERVICE_EST_DATE,
              COMPANY_NO_ORIG,
              NAME_FORMAT,
              FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              FULL_NAME,
              DHR_FL,
              LANDLORD_REVERT_FL,
              AGL_CUST_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), VALIDATION_TS, 121), 
           ' ', '-'), ':', '.') VALIDATION_TS                                  
               INTO :CU-CUSTOMER-EST-DATE :WS-NULL-1,                    
                    :CU-SERVICE-EST-DATE :WS-NULL-2,                     
                    :CU-COMPANY-NO-ORIG,                                
                    :DQ-NAME-FORMAT,                                    
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-FULL-NAME,                                      
                    :CU-DHR-FL,                                         
                    :CU-LANDLORD-REVERT-FL,                             
                    :CU-AGL-CUST-NO,                                    
                    :CU-VALIDATION-TS :WS-NULL-9                         
               FROM  CSS_CUSTOMER CU WITH(READUNCOMMITTED),                     
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
              WHERE  CU.CUSTOMER_NO = :CU-CUSTOMER-NO                   
                AND  CU.NAME_ID     =  DQ.NAME_ID                       
                AND  DQ.NAME_TYPE   = 'CN'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     13320000
MFA-TR*      SELECT  CUSTOMER_EST_DATE,                                 13330000
MFA-TR*              SERVICE_EST_DATE,                                  13330200
MFA-TR*              COMPANY_NO_ORIG,                                   13330500
MFA-TR*              NAME_FORMAT,                                       13330700
MFA-TR*              FIRST_NAME,                                        13330800
MFA-TR*              MIDDLE_NAME,                                       13330900
MFA-TR*              LAST_NAME,                                         13331000
MFA-TR*              TITLE_PREFIX,                                      13332000
MFA-TR*              TITLE_SUFFIX_1,                                    13380000
MFA-TR*              FULL_NAME,                                         13390000
MFA-TR*              DHR_FL,                                                    
MFA-TR*              LANDLORD_REVERT_FL,                                        
MFA-TR*              AGL_CUST_NO,                                               
MFA-TR*              VALIDATION_TS                                              
MFA-TR*        INTO :CU-CUSTOMER-EST-DATE:WS-NULL-1,                    13440101
MFA-TR*             :CU-SERVICE-EST-DATE:WS-NULL-2,                     13440300
MFA-TR*             :CU-COMPANY-NO-ORIG,                                13440600
MFA-TR*             :DQ-NAME-FORMAT,                                    13440700
MFA-TR*             :DQ-FIRST-NAME,                                     13440800
MFA-TR*             :DQ-MIDDLE-NAME,                                    13440900
MFA-TR*             :DQ-LAST-NAME,                                      13441000
MFA-TR*             :DQ-TITLE-PREFIX,                                   13441200
MFA-TR*             :DQ-TITLE-SUFFIX-1,                                 13441300
MFA-TR*             :DQ-FULL-NAME,                                      13442000
MFA-TR*             :CU-DHR-FL,                                         13443000
MFA-TR*             :CU-LANDLORD-REVERT-FL,                             13443000
MFA-TR*             :CU-AGL-CUST-NO,                                    13443000
MFA-TR*             :CU-VALIDATION-TS:WS-NULL-9                                 
MFA-TR*        FROM  CSS_CUSTOMER CU,                                   13550000
MFA-TR*              CSS_NAME DQ                                        13551000
MFA-TR*       WHERE  CU.CUSTOMER_NO = :CU-CUSTOMER-NO                   13560000
MFA-TR*         AND  CU.NAME_ID     =  DQ.NAME_ID                       13561000
MFA-TR*         AND  DQ.NAME_TYPE   = 'CN'                              13562000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    13570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO CU-CUSTOMER-EST-DATE              
                   END-IF                                               
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO CU-SERVICE-EST-DATE               
                   END-IF                                               
                   IF WS-NULL-9 < 0                                     
                       MOVE SPACES TO CU-VALIDATION-TS                  
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7000'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER' TO TABLE-1                       
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-GET-DELINQUENCY-VALUES.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
              WHERE DELINQ_CD = :C8-DELINQ-CD                           
                AND COMPANY_NO = :C8-COMPANY-NO                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*       WHERE DELINQ_CD = :C8-DELINQ-CD                                   
MFA-TR*         AND COMPANY_NO = :C8-COMPANY-NO                                 
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   EVALUATE C8-DELINQ-CD                                
                       WHEN 'DATABASE'                                  
                           MOVE 1 TO C8-DELINQ-VALUE                    
                       WHEN 'MASK-SSN-CUST-DAYS'                        
                           MOVE 2 TO C8-DELINQ-VALUE                    
                       WHEN 'MASK-SSN-SCORE-HOURS'                      
                           MOVE 48 TO C8-DELINQ-VALUE                   
                       WHEN 'CASA-CONTACT-CONFIRM'                      
                           MOVE 1 TO C8-DELINQ-VALUE                    
                   END-EVALUATE                                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7010'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_CD'   TO TABLE-ELEMENT-1                
                   MOVE C8-DELINQ-CD  TO HOSTVAR-ELEMENT-1              
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-GET-INDIV-NAME.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) FIRST_NAME,
              MIDDLE_NAME,
              LAST_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1                                     
                INTO :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1                                 
                FROM CSS_NAME WITH(READUNCOMMITTED)                             
              WHERE NAME_ID = :CE-INDIV-NAME-ID                         
                AND NAME_FORMAT = 'I'                                   
                AND NAME_TYPE = 'IB'                                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FIRST_NAME,                                        13330800
MFA-TR*              MIDDLE_NAME,                                       13330900
MFA-TR*              LAST_NAME,                                         13331000
MFA-TR*              TITLE_PREFIX,                                      13332000
MFA-TR*              TITLE_SUFFIX_1                                     13380000
MFA-TR*         INTO :DQ-FIRST-NAME,                                    13440800
MFA-TR*              :DQ-MIDDLE-NAME,                                   13440900
MFA-TR*              :DQ-LAST-NAME,                                     13441000
MFA-TR*              :DQ-TITLE-PREFIX,                                  13441200
MFA-TR*              :DQ-TITLE-SUFFIX-1                                 13441300
MFA-TR*         FROM CSS_NAME                                                   
MFA-TR*       WHERE NAME_ID = :CE-INDIV-NAME-ID                                 
MFA-TR*         AND NAME_FORMAT = 'I'                                           
MFA-TR*         AND NAME_TYPE = 'IB'                                            
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-NAME                               
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7015'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME'    TO TABLE-1                        
                   MOVE 'NAME_ID'     TO TABLE-ELEMENT-1                
                   MOVE CE-INDIV-NAME-ID TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) SSN,
              CODE_STATE_ID,
              DRIVERS_LICENSE_NO,
              OTHER_ID_TYPE,
              OTHER_ID,
              DATE_OF_BIRTH,
              REFUSED_SSN_FL,
              DOB_VERIFIED_CD,
              VERIFY_SSN_FL,
              ITIN_ID,
              INDIV_NAME_ID                                      
               INTO :CE-SSN,                                            
                    :CE-CODE-STATE-ID,                                  
                    :CE-DRIVERS-LICENSE-NO,                             
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-OTHER-ID,                                       
                    :CE-DATE-OF-BIRTH :WS-NULL-3,                        
                    :CE-REFUSED-SSN-FL,                                 
                    :CE-DOB-VERIFIED-CD,                                
                    :CE-VERIFY-SSN-FL,                                  
                    :CE-ITIN-ID,                                        
                    :CE-INDIV-NAME-ID                                   
               FROM  CSS_CUST_STATS WITH(READUNCOMMITTED)                       
              WHERE  CUSTOMER_NO   = :CU-CUSTOMER-NO                    
                AND  CUSTOMER_TYPE = 'C'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14200000
MFA-TR*      SELECT  SSN,                                               14210000
MFA-TR*              CODE_STATE_ID,                                     14240000
MFA-TR*              DRIVERS_LICENSE_NO,                                14250000
MFA-TR*              OTHER_ID_TYPE,                                     14310000
MFA-TR*              OTHER_ID,                                          14320000
MFA-TR*              DATE_OF_BIRTH,                                     14340000
MFA-TR*              REFUSED_SSN_FL,                                    14370000
MFA-TR*              DOB_VERIFIED_CD,                                           
MFA-TR*              VERIFY_SSN_FL,                                             
MFA-TR*              ITIN_ID,                                                   
MFA-TR*              INDIV_NAME_ID                                              
MFA-TR*        INTO :CE-SSN,                                            14380000
MFA-TR*             :CE-CODE-STATE-ID,                                  14410000
MFA-TR*             :CE-DRIVERS-LICENSE-NO,                             14420000
MFA-TR*             :CE-OTHER-ID-TYPE,                                  14480000
MFA-TR*             :CE-OTHER-ID,                                       14490000
MFA-TR*             :CE-DATE-OF-BIRTH:WS-NULL-3,                        14510000
MFA-TR*             :CE-REFUSED-SSN-FL,                                 14540000
MFA-TR*             :CE-DOB-VERIFIED-CD,                                        
MFA-TR*             :CE-VERIFY-SSN-FL,                                          
MFA-TR*             :CE-ITIN-ID,                                                
MFA-TR*             :CE-INDIV-NAME-ID                                           
MFA-TR*        FROM  CSS_CUST_STATS                                     14550000
MFA-TR*       WHERE  CUSTOMER_NO   = :CU-CUSTOMER-NO                    14560000
MFA-TR*         AND  CUSTOMER_TYPE = 'C'                                14561000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                   13562000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    14570000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-SSN > SPACES AND                               
                      CE-OTHER-ID > SPACES AND                          
                      CE-OTHER-ID-TYPE = 'ITIN'                         
                          MOVE 'OTHER' TO CE-OTHER-ID-TYPE              
                   END-IF                                               
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO CE-DATE-OF-BIRTH                  
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CUST-STATS                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7100'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) BUSINESS_TYPE_CD,
              TAX_ID,
              SOS_STATUS_CD,
              SOS_CONTROL_ID,
              SOS_EFFECTIVE_DT                                   
               INTO :BS-BUSINESS-TYPE-CD,                               
                    :BS-TAX-ID,                                         
                    :BS-SOS-STATUS-CD,                                  
                    :BS-SOS-CONTROL-ID,                                 
                    :BS-SOS-EFFECTIVE-DT :WS-NULL-4                      
               FROM CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                    
              WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14830000
MFA-TR*      SELECT  BUSINESS_TYPE_CD,                                  14850000
MFA-TR*              TAX_ID,                                            14851000
MFA-TR*              SOS_STATUS_CD,                                             
MFA-TR*              SOS_CONTROL_ID,                                            
MFA-TR*              SOS_EFFECTIVE_DT                                           
MFA-TR*        INTO :BS-BUSINESS-TYPE-CD,                               14930000
MFA-TR*             :BS-TAX-ID,                                         14931000
MFA-TR*             :BS-SOS-STATUS-CD,                                          
MFA-TR*             :BS-SOS-CONTROL-ID,                                         
MFA-TR*             :BS-SOS-EFFECTIVE-DT:WS-NULL-4                              
MFA-TR*        FROM CSS_BUS_CUST_STATS                                  15000000
MFA-TR*       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       15010000
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    15020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-4 < 0                                     
                       MOVE SPACES TO BS-SOS-EFFECTIVE-DT               
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-BUS-CUST-STATS                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7200'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-MISC-INFO.                                           
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) BUILDER_FL,
              REALTOR_FL,
              LANDLORD_FL,
              KEY_CUSTOMER,
              INFLUENTIAL_CUST,
              SPECIAL_CUST                                       
               INTO :LQ-BUILDER-FL,                                     
                    :LQ-REALTOR-FL,                                     
                    :LQ-LANDLORD-FL,                                    
                    :LQ-KEY-CUSTOMER,                                   
                    :LQ-INFLUENTIAL-CUST,                               
                    :LQ-SPECIAL-CUST                                    
               FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                    
              WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15210900
MFA-TR*      SELECT  BUILDER_FL,                                        15211000
MFA-TR*              REALTOR_FL,                                        15211200
MFA-TR*              LANDLORD_FL,                                       15211200
MFA-TR*              KEY_CUSTOMER,                                              
MFA-TR*              INFLUENTIAL_CUST,                                          
MFA-TR*              SPECIAL_CUST                                               
MFA-TR*        INTO :LQ-BUILDER-FL,                                     15211400
MFA-TR*             :LQ-REALTOR-FL,                                     15211600
MFA-TR*             :LQ-LANDLORD-FL,                                    15211600
MFA-TR*             :LQ-KEY-CUSTOMER,                                           
MFA-TR*             :LQ-INFLUENTIAL-CUST,                                       
MFA-TR*             :LQ-SPECIAL-CUST                                            
MFA-TR*        FROM CSS_CUST_MISC_INFO                                  15211800
MFA-TR*       WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                       15211900
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                    15212000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CUST-MISC-INFO                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7300'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-SECURED-RATE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RD.SECURED_RATE_FL                                 
              INTO  :RD-SECURED-RATE-FL                                 
              FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED),                       
                    CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                  
                    CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
              WHERE AT.CUSTOMER_NO   = :CU-CUSTOMER-NO                  
                AND AT.ACCOUNT_NO    = UT.ACCOUNT_NO                    
                AND UT.RATE_PLAN_NO  = RD.RATE_PLAN_NO                  
                AND RD.SECURED_RATE_FL = 'Y'                            
                                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT RD.SECURED_RATE_FL                                 15225200
MFA-TR*       INTO  :RD-SECURED-RATE-FL                                 15225400
MFA-TR*       FROM  CSS_ACCOUNT AT,                                     15225600
MFA-TR*             CSS_UTIL_ENVRNMT UT,                                        
MFA-TR*             CSS_RATE_PLAN_DESC RD                                       
MFA-TR*       WHERE AT.CUSTOMER_NO   = :CU-CUSTOMER-NO                  15225700
MFA-TR*         AND AT.ACCOUNT_NO    = UT.ACCOUNT_NO                    15225800
MFA-TR*         AND UT.RATE_PLAN_NO  = RD.RATE_PLAN_NO                  15225900
MFA-TR*         AND RD.SECURED_RATE_FL = 'Y'                                    
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                 13562000
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO RD-SECURED-RATE-FL                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7600'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-2                 
                   MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-3                 
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-CHECK-ACCOUNT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  CSS_ACCOUNT                                         15225600
MFA-TR*       WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      15225700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-COMPANY-CHG-FL                         
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO S-COMPANY-CHG-FL                         
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7700'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'  TO TABLE-1                       
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7705-CHECK-ARCHIVE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  HST_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  HST_ACCOUNT                                         15225600
MFA-TR*       WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      15225700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7705                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7705'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'HST_ACCOUNT'  TO TABLE-1                       
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7705-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7710-CHECK-ROOMMATE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  CSS_ROOMMATE WITH(READUNCOMMITTED)                          
              WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  CSS_ROOMMATE                                        15225600
MFA-TR*       WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      15225700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7710                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7710'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_ROOMMATE' TO TABLE-1                       
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7715-CHECK-COAPP.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  CSS_COAPPLICANT WITH(READUNCOMMITTED)                       
              WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  CSS_COAPPLICANT                                     15225600
MFA-TR*       WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      15225700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7715                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7715'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_COAPPLICANT' TO TABLE-1                    
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7715-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7720-CHECK-H-ROOMMATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  HST_ROOMMATE WITH(READUNCOMMITTED)                          
              WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  HST_ROOMMATE                                        15225600
MFA-TR*       WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      15225700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7720                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7720'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'HST_ROOMMATE' TO TABLE-1                       
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7725-CHECK-H-COAPP.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  HST_COAPPLICANT WITH(READUNCOMMITTED)                       
              WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  HST_COAPPLICANT                                     15225600
MFA-TR*       WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                      15225700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7725                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7725'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'HST_COAPPLICANT' TO TABLE-1                    
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7725-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7750-CHECK-CREDIT-HIST.                                          
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( YEAR, -3, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CUT-OFF-DT             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CUT-OFF-DT = (CURRENT DATE - 3 YEARS)                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  CSS_CREDIT_HIST WITH(READUNCOMMITTED)                       
              WHERE CUSTOMER_NO      = :CU-CUSTOMER-NO                  
                AND CR_HIST_TRAN_DT >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CUT-OFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CUT-OFF-DT
              ) <> 0) OR (LEN(:WS-CUT-OFF-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CUT-OFF-DT
              ), CONVERT(DATE, :WS-CUT-OFF-DT) )                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  CSS_CREDIT_HIST                                     15225600
MFA-TR*       WHERE CUSTOMER_NO      = :CU-CUSTOMER-NO                  15225700
MFA-TR*         AND CR_HIST_TRAN_DT >= :WS-CUT-OFF-DT                   15225800
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7750                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7750'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CREDIT_HIST'    TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   MOVE WS-CUT-OFF-DT TO TABLE-ELEMENT-2                
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7775-CREDIT-HIST-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) MAX(CR_HIST_TRAN_DT),
              REPLACE(CONVERT(CHAR(8), MAX(CR_HIST_TRAN_TM), 108), ':', 
           '.')                               
              INTO  :CK-CR-HIST-TRAN-DT :WS-NULL-7,                      
                    :CK-CR-HIST-TRAN-TM :WS-NULL-8                       
              FROM   CSS_CREDIT_HIST WITH(READUNCOMMITTED)                      
              WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                      
                AND  CR_RQST_REASON_CD <> 'B'                           
              GROUP BY CR_HIST_TRAN_DT,                                 
                       CR_HIST_TRAN_TM                                  
                                                    
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(CR_HIST_TRAN_DT),                                      
MFA-TR*              MAX(CR_HIST_TRAN_TM)                                       
MFA-TR*       INTO  :CK-CR-HIST-TRAN-DT:WS-NULL-7,                              
MFA-TR*             :CK-CR-HIST-TRAN-TM:WS-NULL-8                               
MFA-TR*       FROM   CSS_CREDIT_HIST                                            
MFA-TR*       WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*         AND  CR_RQST_REASON_CD <> 'B'                                   
MFA-TR*       GROUP BY CR_HIST_TRAN_DT,                                         
MFA-TR*                CR_HIST_TRAN_TM                                          
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-7 < 0                                     
                       MOVE '1950-01-01' TO CK-CR-HIST-TRAN-DT          
                   END-IF                                               
                   IF WS-NULL-8 < 0                                     
                       MOVE '00.00.00' TO CK-CR-HIST-TRAN-TM            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7775'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_CREDIT_HIST'    TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   MOVE WS-CUT-OFF-DT TO TABLE-ELEMENT-2                
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7775-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7800-CHECK-GAS-LINE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  CSS_PREM_GAS_LINE WITH(READUNCOMMITTED)                     
              WHERE CUSTOMER_NO      = :CU-CUSTOMER-NO                  
                 OR BUILDER_CUST_NO  = :CU-CUSTOMER-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  CSS_PREM_GAS_LINE                                   15225600
MFA-TR*       WHERE CUSTOMER_NO      = :CU-CUSTOMER-NO                  15225700
MFA-TR*          OR BUILDER_CUST_NO  = :CU-CUSTOMER-NO                  15225800
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN -811                                                
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7800'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_PREM_GAS_LINE'  TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7810-CHECK-LANDLORD.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :S-DELETE-FL                                        
              FROM  CSS_LANDLORD WITH(READUNCOMMITTED)                          
              WHERE CUSTOMER_NO      = :CU-CUSTOMER-NO                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15225100
MFA-TR*       SELECT 'Y'                                                15225200
MFA-TR*       INTO  :S-DELETE-FL                                        15225400
MFA-TR*       FROM  CSS_LANDLORD                                        15225600
MFA-TR*       WHERE CUSTOMER_NO      = :CU-CUSTOMER-NO                  15225700
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                   13562000
MFA-TR*       QUERYNO 7810                                                      
MFA-TR*    END-EXEC.                                                    15226000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-DELETE-FL                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7810'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE SPACES        TO ABEND-SQL-PREDICATES           
                                            ABEND-TABLES                
                   MOVE 'CSS_LANDLORD' TO TABLE-1                       
                   MOVE 'CUSTOMER_NO'  TO TABLE-ELEMENT-1               
                   MOVE CU-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
