       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04494.                                          
COB303 DATE-WRITTEN. NOVEMBER 22, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM BUILDS THE AUDIT DISPLAY FROM AN INPUT ACCOUNT   *        
      *  NUMBER AND DATE. NAVIGATION FROM ACCESS HISTORY.              *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/22/13    FMB      NEW PROGRAM.                                      
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04494'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04494 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHSTUPD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPGMDSC                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKCST                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04494_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-USER-ID-UPDT-BY      PIC X(07) VALUE SPACES.           
           05  S-UPDATE-DT            PIC X(10) VALUE SPACES.           
           05  S-UPDATE-TM            PIC X(08) VALUE SPACES.           
           05  S-ASSIGNED-TS          PIC X(26) VALUE SPACES.           
           05  S-WANTED-BY-TS         PIC X(26) VALUE SPACES.           
           05  S-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.           
           05  S-ORDER-TYPE-DESC      PIC X(15) VALUE SPACES.           
           05  S-SERV-ORDER-STATUS    PIC X(02) VALUE SPACES.           
           05  S-STATUS-DESC          PIC X(25) VALUE SPACES.           
           05  S-ORDER-STATE-CD       PIC X(01) VALUE SPACES.           
           05  S-STATE-DESC           PIC X(25) VALUE SPACES.           
           05  S-APPL-PROGRAM-DESC    PIC X(20) VALUE SPACES.           
           05  S-EMPLOYEE-NAME        PIC X(40) VALUE SPACES.           
           05  S-ACCOUNT-NO           PIC S9(13)V COMP-3 VALUE 0.       
           05  S-ACCOUNT-NO-PRIOR     PIC S9(13)V COMP-3 VALUE 0.       
           05  S-SERV-ORDER-NO        PIC S9(13)V COMP-3 VALUE 0.       
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-INPUT-DATE            PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04494'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL1                 PIC S9(4) COMP VALUE 0.         
           05  WS-NULL2                 PIC S9(4) COMP VALUE 0.         
           05  WS-NULL3                 PIC S9(4) COMP VALUE 0.         
           05  WS-NULL4                 PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
               DECLARE ORDER-CURSOR CURSOR FOR                          
                   SELECT VO.SERV_ORDER_NO,                             
                          VO.ACCOUNT_NO,                                
                          VO.ACCOUNT_NO_PRIOR,                          
                          VW.USER_ID_UPDT_BY,                           
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           VW.UPDATE_DATETIME, 121), ' ', '-'), ':', '.') 
           UPDATE_DATETIME,                           
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           VW.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                         
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           VW.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                        
                          VW.ORDER_TYPE_CD,                             
                          VW.SERV_ORDER_STATUS,                         
                          VW.ORDER_STATE_CD,                            
                          VW.PANEL_NO,                                  
                          C2.ORDER_TYPE_DESC,                           
                          C2.WORK_CLASS_ID                              
                     FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                 
                          CSS_SO_UPDATE VW WITH(READUNCOMMITTED),               
                          CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED)               
                    WHERE VO.PREMISE_NO = :AT-PREMISE-NO                
                      AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO           
                      AND CAST(VW.UPDATE_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )     
                      AND VW.ORDER_TYPE_CD = C2.ORDER_TYPE_CD           
                      AND VO.COMPANY_NO = C2.COMPANY_NO                 
               UNION                                                    
                   SELECT YV.SERV_ORDER_NO,                             
                          YV.ACCOUNT_NO,                                
                          YV.ACCOUNT_NO_PRIOR,                          
                          OK.USER_ID_UPDT_BY,                           
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           OK.UPDATE_DATETIME, 121), ' ', '-'), ':', '.') 
           UPDATE_DATETIME,                           
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           OK.ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME,                         
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           OK.WANTED_BY_DATETIME, 121), ' ', '-'), ':', '.') 
           WANTED_BY_DATETIME,                        
                          OK.ORDER_TYPE_CD,                             
                          OK.SERV_ORDER_STATUS,                         
                          OK.ORDER_STATE_CD,                            
                          OK.PANEL_NO,                                  
                          C2.ORDER_TYPE_DESC,                           
                          C2.WORK_CLASS_ID                              
                     FROM HST_SO_DATA YV WITH(READUNCOMMITTED),                 
                          HST_SO_UPDATE OK WITH(READUNCOMMITTED),               
                          CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED)               
                    WHERE YV.PREMISE_NO = :AT-PREMISE-NO                
                      AND YV.SERV_ORDER_NO = OK.SERV_ORDER_NO           
                      AND CAST(OK.UPDATE_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) )     
                      AND OK.ORDER_TYPE_CD = C2.ORDER_TYPE_CD           
                    ORDER BY 5 DESC                                     
                    FOR READ ONLY                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ORDER-CURSOR CURSOR FOR                                  
MFA-TR*            SELECT VO.SERV_ORDER_NO,                                     
MFA-TR*                   VO.ACCOUNT_NO,                                        
MFA-TR*                   VO.ACCOUNT_NO_PRIOR,                                  
MFA-TR*                   VW.USER_ID_UPDT_BY,                                   
MFA-TR*                   VW.UPDATE_DATETIME,                                   
MFA-TR*                   VW.ASSIGNED_DATETIME,                                 
MFA-TR*                   VW.WANTED_BY_DATETIME,                                
MFA-TR*                   VW.ORDER_TYPE_CD,                                     
MFA-TR*                   VW.SERV_ORDER_STATUS,                                 
MFA-TR*                   VW.ORDER_STATE_CD,                                    
MFA-TR*                   VW.PANEL_NO,                                          
MFA-TR*                   C2.ORDER_TYPE_DESC,                                   
MFA-TR*                   C2.WORK_CLASS_ID                                      
MFA-TR*              FROM CSS_SO_DATA VO,                                       
MFA-TR*                   CSS_SO_UPDATE VW,                                     
MFA-TR*                   CSS_ORDER_TYPE C2                                     
MFA-TR*             WHERE VO.PREMISE_NO = :AT-PREMISE-NO                        
MFA-TR*               AND VO.SERV_ORDER_NO = VW.SERV_ORDER_NO                   
MFA-TR*               AND DATE(VW.UPDATE_DATETIME) = :WS-INPUT-DATE             
MFA-TR*               AND VW.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                   
MFA-TR*               AND VO.COMPANY_NO = C2.COMPANY_NO                         
MFA-TR*        UNION                                                            
MFA-TR*            SELECT YV.SERV_ORDER_NO,                                     
MFA-TR*                   YV.ACCOUNT_NO,                                        
MFA-TR*                   YV.ACCOUNT_NO_PRIOR,                                  
MFA-TR*                   OK.USER_ID_UPDT_BY,                                   
MFA-TR*                   OK.UPDATE_DATETIME,                                   
MFA-TR*                   OK.ASSIGNED_DATETIME,                                 
MFA-TR*                   OK.WANTED_BY_DATETIME,                                
MFA-TR*                   OK.ORDER_TYPE_CD,                                     
MFA-TR*                   OK.SERV_ORDER_STATUS,                                 
MFA-TR*                   OK.ORDER_STATE_CD,                                    
MFA-TR*                   OK.PANEL_NO,                                          
MFA-TR*                   C2.ORDER_TYPE_DESC,                                   
MFA-TR*                   C2.WORK_CLASS_ID                                      
MFA-TR*              FROM HST_SO_DATA YV,                                       
MFA-TR*                   HST_SO_UPDATE OK,                                     
MFA-TR*                   CSS_ORDER_TYPE C2                                     
MFA-TR*             WHERE YV.PREMISE_NO = :AT-PREMISE-NO                        
MFA-TR*               AND YV.SERV_ORDER_NO = OK.SERV_ORDER_NO                   
MFA-TR*               AND DATE(OK.UPDATE_DATETIME) = :WS-INPUT-DATE             
MFA-TR*               AND OK.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                   
MFA-TR*             ORDER BY 5 DESC                                             
MFA-TR*             FOR FETCH ONLY                                              
MFA-TR*            WITH UR                                                      
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE         AS RETURN_CODE,               
                      USER_ID_UPDT_BY     AS USER_ID_UPDT_BY,           
                      UPDATE_DT           AS UPDATE_DT,                 
                      UPDATE_TM           AS UPDATE_TM,                 
                      ASSIGNED_TS         AS ASSIGNED_TS,               
                      WANTED_BY_TS        AS WANTED_BY_TS,              
                      ORDER_TYPE_CD       AS ORDER_TYPE_CD,             
                      ORDER_TYPE_DESC     AS ORDER_TYPE_DESC,           
                      SERV_ORDER_STATUS   AS SERV_ORDER_STATUS,         
                      STATUS_DESC         AS STATUS_DESC,               
                      ORDER_STATE_CD      AS ORDER_STATE_CD,            
                      STATE_DESC          AS STATE_DESC,                
                      APPL_PROGRAM_DESC   AS APPL_PROGRAM_DESC,         
                      EMPLOYEE_NAME       AS EMPLOYEE_NAME,             
                      ACCOUNT_NO          AS ACCOUNT_NO,                
                      ACCOUNT_NO_PRIOR    AS ACCOUNT_NO_PRIOR,          
                      SERV_ORDER_NO       AS SERV_ORDER_NO              
               FROM #CSR04494_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               USER_ID_UPDT_BY     AS USER_ID_UPDT_BY,                   
MFA-TR*               UPDATE_DT           AS UPDATE_DT,                         
MFA-TR*               UPDATE_TM           AS UPDATE_TM,                         
MFA-TR*               ASSIGNED_TS         AS ASSIGNED_TS,                       
MFA-TR*               WANTED_BY_TS        AS WANTED_BY_TS,                      
MFA-TR*               ORDER_TYPE_CD       AS ORDER_TYPE_CD,                     
MFA-TR*               ORDER_TYPE_DESC     AS ORDER_TYPE_DESC,                   
MFA-TR*               SERV_ORDER_STATUS   AS SERV_ORDER_STATUS,                 
MFA-TR*               STATUS_DESC         AS STATUS_DESC,                       
MFA-TR*               ORDER_STATE_CD      AS ORDER_STATE_CD,                    
MFA-TR*               STATE_DESC          AS STATE_DESC,                        
MFA-TR*               APPL_PROGRAM_DESC   AS APPL_PROGRAM_DESC,                 
MFA-TR*               EMPLOYEE_NAME       AS EMPLOYEE_NAME,                     
MFA-TR*               ACCOUNT_NO          AS ACCOUNT_NO,                        
MFA-TR*               ACCOUNT_NO_PRIOR    AS ACCOUNT_NO_PRIOR,                  
MFA-TR*               SERV_ORDER_NO       AS SERV_ORDER_NO                      
MFA-TR*        FROM SESSION.CSR04494_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-DATE               PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO,                              
                          LINK-DATE.                                    
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04494_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04494_R1
              (                                                          
               RETURN_CODE          INT,                            
               USER_ID_UPDT_BY CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               UPDATE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,             
               UPDATE_TM CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,             
               ASSIGNED_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,           
               WANTED_BY_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ORDER_TYPE_CD CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ORDER_TYPE_DESC CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               SERV_ORDER_STATUS CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               STATUS_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ORDER_STATE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               STATE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,            
               APPL_PROGRAM_DESC CHAR(20)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               EMPLOYEE_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ACCOUNT_NO           DECIMAL(13,0),                      
               ACCOUNT_NO_PRIOR     DECIMAL(13,0),                      
               SERV_ORDER_NO        DECIMAL(13,0)                       
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04494_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
               END-IF
           END-IF.        
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE LINK-DATE TO WS-INPUT-DATE.                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 7010-OPEN-ORDER-CURSOR THRU 7010-EXIT.               
           PERFORM 1100-PROCESS-ORDERS THRU 1100-EXIT.                  
           PERFORM 7030-CLOSE-ORDER-CURSOR THRU 7030-EXIT.              
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE +100 TO S-RETURN-CODE                                
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-PROCESS-ORDERS.                                             
                                                                        
           EXEC SQL                                                     
               FETCH ORDER-CURSOR                                       
               INTO :VO-SERV-ORDER-NO,                                  
                    :VO-ACCOUNT-NO,                                     
                    :VO-ACCOUNT-NO-PRIOR,                               
                    :VW-USER-ID-UPDT-BY,                                
                    :VW-UPDATE-DATETIME,                                
                    :VW-ASSIGNED-DATETIME :WS-NULL1,                     
                    :VW-WANTED-BY-DATETIME :WS-NULL2,                    
                    :VW-ORDER-TYPE-CD,                                  
                    :VW-SERV-ORDER-STATUS,                              
                    :VW-ORDER-STATE-CD,                                 
                    :VW-PANEL-NO,                                       
                    :C2-ORDER-TYPE-DESC,                                
                    :C2-WORK-CLASS-ID                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL1 < 0                                      
                       MOVE SPACES TO VW-ASSIGNED-DATETIME              
                   END-IF                                               
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO VW-WANTED-BY-DATETIME             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE '1100'            TO ACTIVE-PARAGRAPH            
                  MOVE 'FETCH'           TO ABEND-FUNCTION              
                  MOVE SPACES            TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                  MOVE 'CSS_SO_DATA'     TO TABLE-1                     
                  MOVE 'CSS_SO_UPDATE'   TO TABLE-2                     
                  MOVE 'CSS_ORDER_TYPE'  TO TABLE-3                     
                  MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1             
                  MOVE AT-PREMISE-NO     TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE VO-SERV-ORDER-NO TO S-SERV-ORDER-NO.                    
           MOVE VO-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           MOVE VO-ACCOUNT-NO-PRIOR TO S-ACCOUNT-NO-PRIOR.              
           MOVE VW-USER-ID-UPDT-BY TO S-USER-ID-UPDT-BY.                
           PERFORM 7100-SELECT-NAME THRU 7100-EXIT.                     
           MOVE VW-UPDATE-DATETIME(1:10) TO S-UPDATE-DT.                
           MOVE VW-UPDATE-DATETIME(12:8) TO S-UPDATE-TM.                
           MOVE VW-ASSIGNED-DATETIME TO S-ASSIGNED-TS.                  
           MOVE VW-WANTED-BY-DATETIME TO S-WANTED-BY-TS.                
           MOVE VW-ORDER-TYPE-CD TO S-ORDER-TYPE-CD.                    
           MOVE VW-SERV-ORDER-STATUS TO S-SERV-ORDER-STATUS.            
           MOVE VW-ORDER-STATE-CD TO S-ORDER-STATE-CD.                  
           MOVE C2-ORDER-TYPE-DESC TO S-ORDER-TYPE-DESC.                
           PERFORM 7200-STATUS-DESC THRU 7200-EXIT.                     
           MOVE R6-STATUS-TX TO S-STATUS-DESC.                          
           EVALUATE VW-ORDER-STATE-CD                                   
               WHEN 'A'                                                 
                   MOVE 'ACTIVE' TO S-STATE-DESC                        
               WHEN 'B'                                                 
                   MOVE 'TURNED DOWN COMPANY' TO S-STATE-DESC           
               WHEN 'C'                                                 
                   MOVE 'CANCELED' TO S-STATE-DESC                      
               WHEN 'D'                                                 
                   MOVE 'TURNED DOWN CUSTOMER' TO S-STATE-DESC          
               WHEN 'H'                                                 
                   MOVE 'HOLD' TO S-STATE-DESC                          
               WHEN 'R'                                                 
                   MOVE 'PAYMENT REQUIRED' TO S-STATE-DESC              
               WHEN 'Q'                                                 
                   MOVE 'ACT - CANCEL PEND' TO S-STATE-DESC             
               WHEN 'Z'                                                 
                   MOVE 'COMPLETED' TO S-STATE-DESC                     
           END-EVALUATE.                                                
           STRING 'PANEL'                                               
                  VW-PANEL-NO                                           
                  DELIMITED BY SIZE                                     
                  INTO K9-APPL-PROGRAM-ID.                              
           PERFORM 7300-PROGRAM-DESC THRU 7300-EXIT.                    
           MOVE K9-APPL-PROGRAM-DESC TO S-APPL-PROGRAM-DESC.            
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           GO TO 1100-PROCESS-ORDERS.                                   
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) PREMISE_NO                                        
                INTO :AT-PREMISE-NO                                     
                FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  PREMISE_NO                                                
MFA-TR*         INTO :AT-PREMISE-NO                                             
MFA-TR*         FROM  CSS_ACCOUNT                                               
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-ORDER-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN ORDER-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7010'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'CSS_SO_UPDATE'         TO TABLE-2                  
               MOVE 'CSS_ORDER_TYPE'        TO TABLE-3                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-ORDER-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE ORDER-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_SO_DATA'           TO TABLE-1                  
               MOVE 'CSS_SO_UPDATE'         TO TABLE-2                  
               MOVE 'CSS_ORDER_TYPE'        TO TABLE-3                  
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-1          
               MOVE AT-PREMISE-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RTRIM(LTRIM(RTRIM(FIRST_NAME) + ' ' + RTRIM(
           MIDDLE_NAME) + ' ' + RTRIM(LAST_NAME)))                             
                INTO :S-EMPLOYEE-NAME                                   
                FROM  CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
               WHERE  USER_ID = :VW-USER-ID-UPDT-BY                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  RTRIM(LTRIM(RTRIM(FIRST_NAME) || ' ' ||                   
MFA-TR*               RTRIM(MIDDLE_NAME) || ' ' ||                              
MFA-TR*               RTRIM(LAST_NAME)))                                        
MFA-TR*         INTO :S-EMPLOYEE-NAME                                           
MFA-TR*         FROM  CSS_USER_PROFILE                                          
MFA-TR*        WHERE  USER_ID = :VW-USER-ID-UPDT-BY                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO S-EMPLOYEE-NAME                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_USER_PROFILE' TO TABLE-1                   
                   MOVE 'USER_ID'        TO TABLE-ELEMENT-1             
                   MOVE VW-USER-ID-UPDT-BY TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-STATUS-DESC.                                                
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) STATUS_TX                                         
                INTO :R6-STATUS-TX                                      
                FROM  CSS_WK_CLASS_STAT WITH(READUNCOMMITTED)                   
               WHERE  WORK_CLASS_ID = :C2-WORK-CLASS-ID                 
                 AND  SERV_ORDER_STATUS = :VW-SERV-ORDER-STATUS         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  STATUS_TX                                                 
MFA-TR*         INTO :R6-STATUS-TX                                              
MFA-TR*         FROM  CSS_WK_CLASS_STAT                                         
MFA-TR*        WHERE  WORK_CLASS_ID = :C2-WORK-CLASS-ID                         
MFA-TR*          AND  SERV_ORDER_STATUS = :VW-SERV-ORDER-STATUS                 
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO R6-STATUS-TX                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_WK_CLASS_STAT' TO TABLE-1                  
                   MOVE 'WORK_CLASS_ID'  TO TABLE-ELEMENT-1             
                   MOVE C2-WORK-CLASS-ID TO HOSTVAR-ELEMENT-1           
                   MOVE 'SERV_ORDER_STATUS'  TO TABLE-ELEMENT-1         
                   MOVE VW-SERV-ORDER-STATUS TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-PROGRAM-DESC.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) APPL_PROGRAM_DESC                                 
                INTO :K9-APPL-PROGRAM-DESC                              
                FROM  CSS_APPL_PGM_DESC WITH(READUNCOMMITTED)                   
               WHERE  APPL_PROGRAM_ID = :K9-APPL-PROGRAM-ID             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  APPL_PROGRAM_DESC                                         
MFA-TR*         INTO :K9-APPL-PROGRAM-DESC                                      
MFA-TR*         FROM  CSS_APPL_PGM_DESC                                         
MFA-TR*        WHERE  APPL_PROGRAM_ID = :K9-APPL-PROGRAM-ID                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE K9-APPL-PROGRAM-ID TO K9-APPL-PROGRAM-DESC      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_APPL_PGM_DESC' TO TABLE-1                  
                   MOVE 'APPL_PROGRAM_ID'  TO TABLE-ELEMENT-1           
                   MOVE K9-APPL-PROGRAM-ID TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04494_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04494_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04494_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04494_R1                            
             (                                                          
               RETURN_CODE,                                             
               USER_ID_UPDT_BY,                                         
               UPDATE_DT,                                               
               UPDATE_TM,                                               
               ASSIGNED_TS,                                             
               WANTED_BY_TS,                                            
               ORDER_TYPE_CD,                                           
               ORDER_TYPE_DESC,                                         
               SERV_ORDER_STATUS,                                       
               STATUS_DESC,                                             
               ORDER_STATE_CD,                                          
               STATE_DESC,                                              
               APPL_PROGRAM_DESC,                                       
               EMPLOYEE_NAME,                                           
               ACCOUNT_NO,                                              
               ACCOUNT_NO_PRIOR,                                        
               SERV_ORDER_NO                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-USER-ID-UPDT-BY,                                      
               :S-UPDATE-DT,                                            
               :S-UPDATE-TM,                                            
               :S-ASSIGNED-TS,                                          
               :S-WANTED-BY-TS,                                         
               :S-ORDER-TYPE-CD,                                        
               :S-ORDER-TYPE-DESC,                                      
               :S-SERV-ORDER-STATUS,                                    
               :S-STATUS-DESC,                                          
               :S-ORDER-STATE-CD,                                       
               :S-STATE-DESC,                                           
               :S-APPL-PROGRAM-DESC,                                    
               :S-EMPLOYEE-NAME,                                        
               :S-ACCOUNT-NO,                                           
               :S-ACCOUNT-NO-PRIOR,                                     
               :S-SERV-ORDER-NO                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04494_R1                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        USER_ID_UPDT_BY,                                                 
MFA-TR*        UPDATE_DT,                                                       
MFA-TR*        UPDATE_TM,                                                       
MFA-TR*        ASSIGNED_TS,                                                     
MFA-TR*        WANTED_BY_TS,                                                    
MFA-TR*        ORDER_TYPE_CD,                                                   
MFA-TR*        ORDER_TYPE_DESC,                                                 
MFA-TR*        SERV_ORDER_STATUS,                                               
MFA-TR*        STATUS_DESC,                                                     
MFA-TR*        ORDER_STATE_CD,                                                  
MFA-TR*        STATE_DESC,                                                      
MFA-TR*        APPL_PROGRAM_DESC,                                               
MFA-TR*        EMPLOYEE_NAME,                                                   
MFA-TR*        ACCOUNT_NO,                                                      
MFA-TR*        ACCOUNT_NO_PRIOR,                                                
MFA-TR*        SERV_ORDER_NO                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-USER-ID-UPDT-BY,                                              
MFA-TR*        :S-UPDATE-DT,                                                    
MFA-TR*        :S-UPDATE-TM,                                                    
MFA-TR*        :S-ASSIGNED-TS,                                                  
MFA-TR*        :S-WANTED-BY-TS,                                                 
MFA-TR*        :S-ORDER-TYPE-CD,                                                
MFA-TR*        :S-ORDER-TYPE-DESC,                                              
MFA-TR*        :S-SERV-ORDER-STATUS,                                            
MFA-TR*        :S-STATUS-DESC,                                                  
MFA-TR*        :S-ORDER-STATE-CD,                                               
MFA-TR*        :S-STATE-DESC,                                                   
MFA-TR*        :S-APPL-PROGRAM-DESC,                                            
MFA-TR*        :S-EMPLOYEE-NAME,                                                
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-ACCOUNT-NO-PRIOR,                                             
MFA-TR*        :S-SERV-ORDER-NO                                                 
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04494_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
