       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04492.                                          
COB303 DATE-WRITTEN. AUGUST 7, 2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM BUILDS THE PENDING/WRITE OFF ACCOUNT LISTING     *        
      *  FOR THE SEB WEB.                                              *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/07/13    FMB      NEW PROGRAM.                                      
P00613*  02/20/14    LG41184  ADD REG_GROUP_CD TO THE RESULT.          *        
P00836*  08/26/15    FMB      EXCLUDE THE SEB WEB TESTFILE.            *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04492'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04492 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCOLHST                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
P00613                                                                  
P00613     EXEC SQL                                                             
P00613        INCLUDE TBREGPRF                                                  
P00613     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04492_R1'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
COB305     05 S-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.         
COB305     05 S-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.         
           05  S-LOCAL-OFFICE         PIC X(03) VALUE SPACES.           
           05  S-CREDIT-GROUP         PIC X(01) VALUE SPACES.           
           05  S-COMPANY-NO           PIC X(02) VALUE SPACES.           
COB305     05 S-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.         
           05  S-MST-SUB-ACCT-IND     PIC X(01) VALUE SPACES.           
           05  S-CODE-ACCT-STAT       PIC X(01) VALUE SPACES.           
           05  S-ACCOUNT-TYPE-CODE    PIC X(01) VALUE SPACES.           
           05  S-CODE-PRNT-BLL-MST    PIC X(01) VALUE SPACES.           
COB305     05 S-REV-MTH-LST-NRML        PIC S9(6)V USAGE COMP-3 VALUE 0.        
           05  S-EPP-OFFER-DATE       PIC X(10) VALUE SPACES.           
           05  S-NO-BILL-COPIES       PIC S9(4) USAGE COMP.             
COB305     05 S-TOTAL-AR-BALANCE        PIC S9(11)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05  S-DATE-BILL-DAY-00     PIC X(10) VALUE SPACES.           
           05  S-CODES-DATA-PRESENT   PIC X(32) VALUE SPACES.           
           05  S-EPP-FL               PIC X(01) VALUE SPACES.           
           05  S-PROJECT-SHARE-FL     PIC X(01) VALUE SPACES.           
           05  S-STATE                PIC X(02) VALUE SPACES.           
           05  S-TOWN                 PIC X(26) VALUE SPACES.           
           05  S-HOUSE-NO             PIC X(15) VALUE SPACES.           
           05  S-ADDR-PREFIX-1        PIC X(03) VALUE SPACES.           
           05  S-ADDR-PREFIX-2        PIC X(02) VALUE SPACES.           
           05  S-STREET-NAME          PIC X(30) VALUE SPACES.           
           05  S-ADDRESS-OVERFLOW     PIC X(35) VALUE SPACES.           
           05  S-ADDR-USAGE-CD        PIC X(01) VALUE SPACES.           
           05  S-STREET-SUFFIX        PIC X(04) VALUE SPACES.           
           05  S-STREET-LOCATION-1    PIC X(04) VALUE SPACES.           
           05  S-STREET-LOCATION-2    PIC X(11) VALUE SPACES.           
           05  S-ADDR-SUFFIX          PIC X(02) VALUE SPACES.           
           05  S-ZIP-CODE             PIC X(05) VALUE SPACES.           
           05  S-NAME-TYPE            PIC X(02) VALUE SPACES.           
           05  S-FULL-NAME            PIC X(70) VALUE SPACES.           
           05  S-FIRST-NAME           PIC X(15) VALUE SPACES.           
           05  S-MIDDLE-NAME          PIC X(15) VALUE SPACES.           
           05  S-LAST-NAME            PIC X(40) VALUE SPACES.           
           05  S-NAME-FORMAT          PIC X(01) VALUE SPACES.           
           05  S-TITLE-PREFIX         PIC X(09) VALUE SPACES.           
           05  S-TITLE-SUFFIX-1       PIC X(03) VALUE SPACES.           
           05  S-TITLE-SUFFIX-2       PIC X(03) VALUE SPACES.           
P00613     05  S-REG-GROUP-CD         PIC X(03) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-DATE-MINUS-90-DAYS    PIC X(10) VALUE SPACES.         
           05  WS-TS-MINUS-90-DAYS      PIC X(26) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04492'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL1                 PIC S9(4) COMP VALUE 0.         
           05  WS-NULL2                 PIC S9(4) COMP VALUE 0.         
           05  WS-NULL3                 PIC S9(4) COMP VALUE 0.         
           05  WS-NULL4                 PIC S9(4) COMP VALUE 0.         
P00613     05  WS-NULL5                 PIC S9(4) COMP VALUE 0.         
           05  WS-EPP-FL                PIC X(01) VALUE 'N'.            
           05  WS-PROJECT-SHARE-FL      PIC X(01) VALUE 'N'.            
           05  WS-INCLUDE-WO-FL         PIC X(01) VALUE 'N'.            
           05  WS-COLLECT-CONTACT-FL    PIC X(01) VALUE 'N'.            
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
               DECLARE ACCOUNT-CURSOR CURSOR FOR                        
                   SELECT DISTINCT                                      
                          AT.ACCOUNT_NO,                                
                          AT.CUSTOMER_NO,                               
                          AT.LOCAL_OFFICE,                              
                          AT.CREDIT_GROUP,                              
                          AT.COMPANY_NO,                                
                          AT.PREMISE_NO,                                
                          AT.MST_SUB_ACCT_IND,                          
                          AT.CODE_ACCT_STAT,                            
                          AT.ACCOUNT_TYPE_CODE,                         
                          AT.CODE_PRNT_BLL_MST,                         
                          AT.REV_MTH_LST_NRML,                          
                          AT.EPP_OFFER_DATE,                            
                          AT.NO_BILL_COPIES,                            
                          AT.TOTAL_AR_BALANCE,                          
                          AT.DATE_BILL_DAY_00,                          
                          AT.CODES_DATA_PRESENT,                        
                          CIS.SUBSTR3(AT.CODES_DATA_PRESENT,3,1),            
                          CIS.SUBSTR3(AT.CODES_DATA_PRESENT,28,1),           
                          A4.STATE,                                     
                          A4.TOWN,                                      
                          DY.HOUSE_NO,                                  
                          DY.ADDR_PREFIX_1,                             
                          DY.ADDR_PREFIX_2,                             
                          DY.STREET_NAME,                               
                          DY.ADDRESS_OVERFLOW,                          
                          DY.ADDR_USAGE_CD,                             
                          DY.STREET_SUFFIX,                             
                          DY.STREET_LOCATION_1,                         
                          DY.STREET_LOCATION_2,                         
                          DY.ADDR_SUFFIX,                               
                          DY.ZIP_CODE,                                  
                          DQ.NAME_TYPE,                                 
                          DQ.FULL_NAME,                                 
                          DQ.FIRST_NAME,                                
                          DQ.MIDDLE_NAME,                               
                          DQ.LAST_NAME,                                 
                          DQ.NAME_FORMAT,                               
                          DQ.TITLE_PREFIX,                              
                          DQ.TITLE_SUFFIX_1,                            
                          DQ.TITLE_SUFFIX_2,                            
                          REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_CREATE_DT, 121), ' ', '-'), ':', '.') 
           ACCT_CREATE_DT,                            
P00613                    LR.REG_GROUP_CD                               
P00613             FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED) LEFT JOIN          
P00613                  CSS_REG_PROFILE LR WITH(READUNCOMMITTED) ON             
P00613                          (AT.ACCOUNT_NO = LR.ACCOUNT_NO),        
                        CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),            
                        CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),            
                        CSS_NAME DQ WITH(READUNCOMMITTED),                      
                        CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                   
                   WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO               
                     AND MST_SUB_ACCT_IND <> 'S'                        
                     AND AT.CODE_ACCT_STAT IN ('P', 'S')                
                     AND HT.ACCOUNT_NO = AT.ACCOUNT_NO                  
                     AND HT.ADDRESS_ID = DY.ADDRESS_ID                  
                     AND HT.NAME_ID = DQ.NAME_ID                        
                     AND HT.CUSTOMER_ROLE_CD = ' '                      
                     AND A4.ZIP_CODE = DY.ZIP_CODE                      
                     AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN          
                     AND (DQ.NAME_TYPE = 'DB'                           
                      OR (DQ.NAME_TYPE = 'CN'                           
                     AND NOT EXISTS (                                   
                             SELECT DQ2.NAME_ID                         
                               FROM CSS_NAME DQ2 WITH(READUNCOMMITTED)          
                                   ,CSS_NAME_ACCT_XREF HT2
                           WITH(READUNCOMMITTED)              
                              WHERE HT.ACCOUNT_NO = HT2.ACCOUNT_NO      
                                AND HT2.NAME_ID=DQ2.NAME_ID             
                                AND DQ2.NAME_TYPE = 'DB' )))            
                   ORDER BY AT.ACCOUNT_NO                               
                   FOR READ ONLY                                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCOUNT-CURSOR CURSOR FOR                                
MFA-TR*            SELECT DISTINCT                                              
MFA-TR*                   AT.ACCOUNT_NO,                                        
MFA-TR*                   AT.CUSTOMER_NO,                                       
MFA-TR*                   AT.LOCAL_OFFICE,                                      
MFA-TR*                   AT.CREDIT_GROUP,                                      
MFA-TR*                   AT.COMPANY_NO,                                        
MFA-TR*                   AT.PREMISE_NO,                                        
MFA-TR*                   AT.MST_SUB_ACCT_IND,                                  
MFA-TR*                   AT.CODE_ACCT_STAT,                                    
MFA-TR*                   AT.ACCOUNT_TYPE_CODE,                                 
MFA-TR*                   AT.CODE_PRNT_BLL_MST,                                 
MFA-TR*                   AT.REV_MTH_LST_NRML,                                  
MFA-TR*                   AT.EPP_OFFER_DATE,                                    
MFA-TR*                   AT.NO_BILL_COPIES,                                    
MFA-TR*                   AT.TOTAL_AR_BALANCE,                                  
MFA-TR*                   AT.DATE_BILL_DAY_00,                                  
MFA-TR*                   AT.CODES_DATA_PRESENT,                                
MFA-TR*                   SUBSTR(AT.CODES_DATA_PRESENT,3,1),                    
MFA-TR*                   SUBSTR(AT.CODES_DATA_PRESENT,28,1),                   
MFA-TR*                   A4.STATE,                                             
MFA-TR*                   A4.TOWN,                                              
MFA-TR*                   DY.HOUSE_NO,                                          
MFA-TR*                   DY.ADDR_PREFIX_1,                                     
MFA-TR*                   DY.ADDR_PREFIX_2,                                     
MFA-TR*                   DY.STREET_NAME,                                       
MFA-TR*                   DY.ADDRESS_OVERFLOW,                                  
MFA-TR*                   DY.ADDR_USAGE_CD,                                     
MFA-TR*                   DY.STREET_SUFFIX,                                     
MFA-TR*                   DY.STREET_LOCATION_1,                                 
MFA-TR*                   DY.STREET_LOCATION_2,                                 
MFA-TR*                   DY.ADDR_SUFFIX,                                       
MFA-TR*                   DY.ZIP_CODE,                                          
MFA-TR*                   DQ.NAME_TYPE,                                         
MFA-TR*                   DQ.FULL_NAME,                                         
MFA-TR*                   DQ.FIRST_NAME,                                        
MFA-TR*                   DQ.MIDDLE_NAME,                                       
MFA-TR*                   DQ.LAST_NAME,                                         
MFA-TR*                   DQ.NAME_FORMAT,                                       
MFA-TR*                   DQ.TITLE_PREFIX,                                      
MFA-TR*                   DQ.TITLE_SUFFIX_1,                                    
MFA-TR*                   DQ.TITLE_SUFFIX_2,                                    
MFA-TR*                   AT.ACCT_CREATE_DT,                                    
MFA-TR*                   LR.REG_GROUP_CD                                       
MFA-TR*            FROM CSS_ACCOUNT AT LEFT JOIN                                
MFA-TR*                 CSS_REG_PROFILE LR ON                                   
MFA-TR*                         (AT.ACCOUNT_NO = LR.ACCOUNT_NO),                
MFA-TR*                 CSS_NAME_ACCT_XREF HT,                                  
MFA-TR*                 CSS_ADDR_FORMATTED DY,                                  
MFA-TR*                 CSS_NAME DQ,                                            
MFA-TR*                 CSS_ZIP_CODE A4                                         
MFA-TR*            WHERE AT.CUSTOMER_NO = :AT-CUSTOMER-NO                       
MFA-TR*              AND MST_SUB_ACCT_IND <> 'S'                                
MFA-TR*              AND AT.CODE_ACCT_STAT IN ('P', 'S')                        
MFA-TR*              AND HT.ACCOUNT_NO = AT.ACCOUNT_NO                          
MFA-TR*              AND HT.ADDRESS_ID = DY.ADDRESS_ID                          
MFA-TR*              AND HT.NAME_ID = DQ.NAME_ID                                
MFA-TR*              AND HT.CUSTOMER_ROLE_CD = ' '                              
MFA-TR*              AND A4.ZIP_CODE = DY.ZIP_CODE                              
MFA-TR*              AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN                  
MFA-TR*              AND (DQ.NAME_TYPE = 'DB'                                   
MFA-TR*               OR (DQ.NAME_TYPE = 'CN'                                   
MFA-TR*              AND NOT EXISTS (                                           
MFA-TR*                      SELECT DQ2.NAME_ID                                 
MFA-TR*                        FROM CSS_NAME DQ2                                
MFA-TR*                            ,CSS_NAME_ACCT_XREF HT2                      
MFA-TR*                       WHERE HT.ACCOUNT_NO = HT2.ACCOUNT_NO              
MFA-TR*                         AND HT2.NAME_ID=DQ2.NAME_ID                     
MFA-TR*                         AND DQ2.NAME_TYPE = 'DB' )))                    
MFA-TR*            ORDER BY AT.ACCOUNT_NO                                       
MFA-TR*            FOR FETCH ONLY                                               
MFA-TR*            WITH UR                                                      
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE         AS RETURN_CODE,               
                      ACCOUNT_NO          AS ACCOUNT_NO,                
                      CUSTOMER_NO         AS CUSTOMER_NO,               
                      LOCAL_OFFICE        AS LOCAL_OFFICE,              
                      CREDIT_GROUP        AS CREDIT_GROUP,              
                      COMPANY_NO          AS COMPANY_NO,                
                      PREMISE_NO          AS PREMISE_NO,                
                      MST_SUB_ACCT_IND    AS MST_SUB_ACCT_IND,          
                      CODE_ACCT_STAT      AS CODE_ACCT_STAT,            
                      ACCOUNT_TYPE_CODE   AS ACCOUNT_TYPE_CODE,         
                      CODE_PRNT_BLL_MST   AS CODE_PRNT_BLL_MST,         
                      REV_MTH_LST_NRML    AS REV_MTH_LST_NRML,          
                      EPP_OFFER_DATE      AS EPP_OFFER_DATE,            
                      NO_BILL_COPIES      AS NO_BILL_COPIES,            
                      TOTAL_AR_BALANCE    AS TOTAL_AR_BALANCE,          
                      DATE_BILL_DAY_00    AS DATE_BILL_DAY_00,          
                      CODES_DATA_PRESENT  AS CODES_DATA_PRESENT,        
                      EPP                 AS EPP,                       
                      PROJECT_SHARE       AS PROJECT_SHARE,             
                      STATE               AS STATE,                     
                      TOWN                AS TOWN,                      
                      HOUSE_NO            AS HOUSE_NO,                  
                      ADDR_PREFIX_1       AS ADDR_PREFIX_1,             
                      ADDR_PREFIX_2       AS ADDR_PREFIX_2,             
                      STREET_NAME         AS STREET_NAME,               
                      ADDRESS_OVERFLOW    AS ADDRESS_OVERFLOW,          
                      ADDR_USAGE_CD       AS ADDR_USAGE_CD,             
                      STREET_SUFFIX       AS STREET_SUFFIX,             
                      STREET_LOCATION_1   AS STREET_LOCATION_1,         
                      STREET_LOCATION_2   AS STREET_LOCATION_2,         
                      ADDR_SUFFIX         AS ADDR_SUFFIX,               
                      ZIP_CODE            AS ZIP_CODE,                  
                      NAME_TYPE           AS NAME_TYPE,                 
                      FULL_NAME           AS FULL_NAME,                 
                      FIRST_NAME          AS FIRST_NAME,                
                      MIDDLE_NAME         AS MIDDLE_NAME,               
                      LAST_NAME           AS LAST_NAME,                 
                      NAME_FORMAT         AS NAME_FORMAT,               
                      TITLE_PREFIX        AS TITLE_PREFIX,              
                      TITLE_SUFFIX_1      AS TITLE_SUFFIX_1,            
                      TITLE_SUFFIX_2      AS TITLE_SUFFIX_2,            
P00613                REG_GROUP_CD        AS REG_GROUP_CD               
               FROM #CSR04492_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               ACCOUNT_NO          AS ACCOUNT_NO,                        
MFA-TR*               CUSTOMER_NO         AS CUSTOMER_NO,                       
MFA-TR*               LOCAL_OFFICE        AS LOCAL_OFFICE,                      
MFA-TR*               CREDIT_GROUP        AS CREDIT_GROUP,                      
MFA-TR*               COMPANY_NO          AS COMPANY_NO,                        
MFA-TR*               PREMISE_NO          AS PREMISE_NO,                        
MFA-TR*               MST_SUB_ACCT_IND    AS MST_SUB_ACCT_IND,                  
MFA-TR*               CODE_ACCT_STAT      AS CODE_ACCT_STAT,                    
MFA-TR*               ACCOUNT_TYPE_CODE   AS ACCOUNT_TYPE_CODE,                 
MFA-TR*               CODE_PRNT_BLL_MST   AS CODE_PRNT_BLL_MST,                 
MFA-TR*               REV_MTH_LST_NRML    AS REV_MTH_LST_NRML,                  
MFA-TR*               EPP_OFFER_DATE      AS EPP_OFFER_DATE,                    
MFA-TR*               NO_BILL_COPIES      AS NO_BILL_COPIES,                    
MFA-TR*               TOTAL_AR_BALANCE    AS TOTAL_AR_BALANCE,                  
MFA-TR*               DATE_BILL_DAY_00    AS DATE_BILL_DAY_00,                  
MFA-TR*               CODES_DATA_PRESENT  AS CODES_DATA_PRESENT,                
MFA-TR*               EPP                 AS EPP,                               
MFA-TR*               PROJECT_SHARE       AS PROJECT_SHARE,                     
MFA-TR*               STATE               AS STATE,                             
MFA-TR*               TOWN                AS TOWN,                              
MFA-TR*               HOUSE_NO            AS HOUSE_NO,                          
MFA-TR*               ADDR_PREFIX_1       AS ADDR_PREFIX_1,                     
MFA-TR*               ADDR_PREFIX_2       AS ADDR_PREFIX_2,                     
MFA-TR*               STREET_NAME         AS STREET_NAME,                       
MFA-TR*               ADDRESS_OVERFLOW    AS ADDRESS_OVERFLOW,                  
MFA-TR*               ADDR_USAGE_CD       AS ADDR_USAGE_CD,                     
MFA-TR*               STREET_SUFFIX       AS STREET_SUFFIX,                     
MFA-TR*               STREET_LOCATION_1   AS STREET_LOCATION_1,                 
MFA-TR*               STREET_LOCATION_2   AS STREET_LOCATION_2,                 
MFA-TR*               ADDR_SUFFIX         AS ADDR_SUFFIX,                       
MFA-TR*               ZIP_CODE            AS ZIP_CODE,                          
MFA-TR*               NAME_TYPE           AS NAME_TYPE,                         
MFA-TR*               FULL_NAME           AS FULL_NAME,                         
MFA-TR*               FIRST_NAME          AS FIRST_NAME,                        
MFA-TR*               MIDDLE_NAME         AS MIDDLE_NAME,                       
MFA-TR*               LAST_NAME           AS LAST_NAME,                         
MFA-TR*               NAME_FORMAT         AS NAME_FORMAT,                       
MFA-TR*               TITLE_PREFIX        AS TITLE_PREFIX,                      
MFA-TR*               TITLE_SUFFIX_1      AS TITLE_SUFFIX_1,                    
MFA-TR*               TITLE_SUFFIX_2      AS TITLE_SUFFIX_2,                    
MFA-TR*               REG_GROUP_CD        AS REG_GROUP_CD                       
MFA-TR*        FROM SESSION.CSR04492_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO        PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-CUSTOMER-NO.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04492_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04492_R1
              (                                                          
               RETURN_CODE          INT,                            
               ACCOUNT_NO           DECIMAL(13,0),                      
               CUSTOMER_NO          DECIMAL(10,0),                      
               LOCAL_OFFICE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CREDIT_GROUP CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               PREMISE_NO           DECIMAL(10,0),                      
               MST_SUB_ACCT_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ACCOUNT_TYPE_CODE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODE_PRNT_BLL_MST CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               REV_MTH_LST_NRML     DECIMAL(6,0),                       
               EPP_OFFER_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               NO_BILL_COPIES       SMALLINT,                           
               TOTAL_AR_BALANCE     DECIMAL(13,2),                      
               DATE_BILL_DAY_00 CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODES_DATA_PRESENT CHAR(32)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               EPP CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,                   
               PROJECT_SHARE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,                  
               HOUSE_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ADDR_PREFIX_1 CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ADDR_PREFIX_2 CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,         
               STREET_NAME CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ADDR_USAGE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               STREET_SUFFIX CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,         
               STREET_LOCATION_1 CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               STREET_LOCATION_2 CHAR(11)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ADDR_SUFFIX CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ZIP_CODE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,              
               NAME_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2,             
               FIRST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,            
               MIDDLE_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,           
               LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,             
               NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               TITLE_PREFIX CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,          
               TITLE_SUFFIX_1 CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
               TITLE_SUFFIX_2 CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
               REG_GROUP_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04492_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
               END-IF
           END-IF.        
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, -90, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-90-DAYS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 90 DAYS)                       
MFA-TR*          INTO :WS-DATE-MINUS-90-DAYS                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-DATE-MINUS-90-DAYS TO WS-TS-MINUS-90-DAYS(1:10).     
           MOVE '-00.00.00.000000' TO WS-TS-MINUS-90-DAYS(11:16).       
                                                                        
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE '0000000000' TO LINK-CUSTOMER-NO
           END-IF.                   
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO AT-CUSTOMER-NO.                   
                                                                        
           PERFORM 7010-OPEN-ACCT-CURSOR THRU 7010-EXIT.                
           PERFORM 1100-PROCESS-ACCOUNTS THRU 1100-EXIT.                
           PERFORM 7030-CLOSE-ACCT-CURSOR THRU 7030-EXIT.               
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE +100 TO S-RETURN-CODE                                
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-PROCESS-ACCOUNTS.                                           
                                                                        
           EXEC SQL                                                     
               FETCH ACCOUNT-CURSOR                                     
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-CUSTOMER-NO,                                    
                    :AT-LOCAL-OFFICE,                                   
                    :AT-CREDIT-GROUP,                                   
                    :AT-COMPANY-NO,                                     
                    :AT-PREMISE-NO,                                     
                    :AT-MST-SUB-ACCT-IND,                               
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-CODE-PRNT-BLL-MST,                              
                    :AT-REV-MTH-LST-NRML,                               
                    :AT-EPP-OFFER-DATE :WS-NULL1,                        
                    :AT-NO-BILL-COPIES,                                 
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-DATE-BILL-DAY-00 :WS-NULL2,                      
                    :AT-CODES-DATA-PRESENT,                             
                    :WS-EPP-FL,                                         
                    :WS-PROJECT-SHARE-FL,                               
                    :A4-STATE,                                          
                    :A4-TOWN,                                           
                    :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-ADDRESS-OVERFLOW,                               
                    :DY-ADDR-USAGE-CD,                                  
                    :DY-STREET-SUFFIX,                                  
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2,                              
                    :DY-ADDR-SUFFIX,                                    
                    :DY-ZIP-CODE,                                       
                    :DQ-NAME-TYPE,                                      
                    :DQ-FULL-NAME,                                      
                    :DQ-FIRST-NAME,                                     
                    :DQ-MIDDLE-NAME,                                    
                    :DQ-LAST-NAME,                                      
                    :DQ-NAME-FORMAT,                                    
                    :DQ-TITLE-PREFIX,                                   
                    :DQ-TITLE-SUFFIX-1,                                 
                    :DQ-TITLE-SUFFIX-2,                                 
                    :AT-ACCT-CREATE-DT :WS-NULL3,                        
P00613              :LR-REG-GROUP-CD :WS-NULL5                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL1 < 0                                      
                       MOVE SPACES TO AT-EPP-OFFER-DATE                 
                   END-IF                                               
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO AT-DATE-BILL-DAY-00               
                   END-IF                                               
                   IF WS-NULL3 < 0                                      
                       MOVE SPACES TO AT-ACCT-CREATE-DT                 
                   END-IF                                               
P00613             IF WS-NULL5 < 0                                      
P00613                 MOVE SPACES TO LR-REG-GROUP-CD                   
P00613             END-IF                                               
               WHEN NOT-FOUND                                           
                   GO TO 1100-EXIT                                      
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
                  MOVE '1100'            TO ACTIVE-PARAGRAPH            
                  MOVE 'FETCH'           TO ABEND-FUNCTION              
                  MOVE SPACES            TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                  MOVE 'CSS_ACCOUNT'     TO TABLE-1                     
                  MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1             
                  MOVE AT-CUSTOMER-NO    TO HOSTVAR-ELEMENT-1           
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
           END-EVALUATE.                                                
                                                                        
           IF AT-CODE-ACCT-STAT = 'P' AND                               
              AT-ACCT-CREATE-DT < WS-TS-MINUS-90-DAYS AND               
P00836        AT-ACCOUNT-NO NOT = 9310129132623                         
                  GO TO 1100-PROCESS-ACCOUNTS
           END-IF.                          
           IF AT-CODE-ACCT-STAT = 'S'                                   
               MOVE 'N' TO WS-INCLUDE-WO-FL                             
               PERFORM 1200-WRITE-OFF THRU 1200-EXIT                    
               IF WS-INCLUDE-WO-FL = 'N'                                
                   GO TO 1100-PROCESS-ACCOUNTS
               END-IF
           END-IF.                         
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE AT-ACCOUNT-NO TO S-ACCOUNT-NO.                          
           MOVE AT-CUSTOMER-NO TO S-CUSTOMER-NO.                        
           MOVE AT-LOCAL-OFFICE TO S-LOCAL-OFFICE.                      
           MOVE AT-CREDIT-GROUP TO S-CREDIT-GROUP.                      
           MOVE AT-COMPANY-NO TO S-COMPANY-NO.                          
           MOVE AT-PREMISE-NO TO S-PREMISE-NO.                          
           MOVE AT-MST-SUB-ACCT-IND TO S-MST-SUB-ACCT-IND.              
           MOVE AT-CODE-ACCT-STAT TO S-CODE-ACCT-STAT.                  
           MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-CODE.            
           MOVE AT-CODE-PRNT-BLL-MST TO S-CODE-PRNT-BLL-MST.            
           MOVE AT-REV-MTH-LST-NRML TO S-REV-MTH-LST-NRML.              
           MOVE AT-EPP-OFFER-DATE TO S-EPP-OFFER-DATE.                  
           MOVE AT-NO-BILL-COPIES TO S-NO-BILL-COPIES.                  
           IF AT-CODE-ACCT-STAT = 'S'                                   
               MOVE CO-AMT-TRANS TO S-TOTAL-AR-BALANCE                  
           ELSE                                                         
               MOVE AT-TOTAL-AR-BALANCE TO S-TOTAL-AR-BALANCE
           END-IF.          
           MOVE AT-DATE-BILL-DAY-00 TO S-DATE-BILL-DAY-00.              
           MOVE AT-CODES-DATA-PRESENT TO S-CODES-DATA-PRESENT.          
           MOVE WS-EPP-FL TO S-EPP-FL.                                  
           MOVE WS-PROJECT-SHARE-FL TO S-PROJECT-SHARE-FL.              
           MOVE A4-STATE TO S-STATE.                                    
           MOVE A4-TOWN TO S-TOWN.                                      
           MOVE DY-HOUSE-NO TO S-HOUSE-NO.                              
           MOVE DY-ADDR-PREFIX-1 TO S-ADDR-PREFIX-1.                    
           MOVE DY-ADDR-PREFIX-2 TO S-ADDR-PREFIX-2.                    
           MOVE DY-STREET-NAME TO S-STREET-NAME.                        
           MOVE DY-ADDRESS-OVERFLOW TO S-ADDRESS-OVERFLOW.              
           MOVE DY-ADDR-USAGE-CD TO S-ADDR-USAGE-CD.                    
           MOVE DY-STREET-SUFFIX TO S-STREET-SUFFIX.                    
           MOVE DY-STREET-LOCATION-1 TO S-STREET-LOCATION-1.            
           MOVE DY-STREET-LOCATION-2 TO S-STREET-LOCATION-2.            
           MOVE DY-ADDR-SUFFIX TO S-ADDR-SUFFIX.                        
           MOVE DY-ZIP-CODE TO S-ZIP-CODE.                              
           MOVE DQ-NAME-TYPE TO S-NAME-TYPE.                            
           MOVE DQ-FULL-NAME TO S-FULL-NAME.                            
           MOVE DQ-FIRST-NAME TO S-FIRST-NAME.                          
           MOVE DQ-MIDDLE-NAME TO S-MIDDLE-NAME.                        
           MOVE DQ-LAST-NAME TO S-LAST-NAME.                            
           MOVE DQ-NAME-FORMAT TO S-NAME-FORMAT.                        
           MOVE DQ-TITLE-PREFIX TO S-TITLE-PREFIX.                      
           MOVE DQ-TITLE-SUFFIX-1 TO S-TITLE-SUFFIX-1.                  
           MOVE DQ-TITLE-SUFFIX-2 TO S-TITLE-SUFFIX-2.                  
P00613     MOVE LR-REG-GROUP-CD   TO S-REG-GROUP-CD.                    
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           GO TO 1100-PROCESS-ACCOUNTS.                                 
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1200-WRITE-OFF.                                                  
                                                                        
           PERFORM 7100-CHARGE-OFF THRU 7100-EXIT.                      
           IF CO-AMT-TRANS > 0                                          
               PERFORM 7000-SELECT-FINAL-WO THRU 7000-EXIT              
               IF FW-COLLECT-STATUS-CD = 'D' OR 'E'                     
                      MOVE 'N' TO WS-INCLUDE-WO-FL                      
               ELSE                                                     
                   MOVE 'Y' TO WS-INCLUDE-WO-FL
               END-IF
           END-IF.                        
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-FINAL-WO.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) COLLECT_STATUS_CD                                 
                INTO :FW-COLLECT-STATUS-CD                              
                FROM  CSS_FINAL_WO WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  COLLECT_STATUS_CD                                         
MFA-TR*         INTO :FW-COLLECT-STATUS-CD                                      
MFA-TR*         FROM  CSS_FINAL_WO                                              
MFA-TR*        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_FINAL_WO'   TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN ACCOUNT-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7010'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE ACCOUNT-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CHARGE-OFF.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_TRANS)                                    
                 INTO :CO-AMT-TRANS :WS-NULL4                            
                 FROM CSS_CHRG_OFF CO WITH(READUNCOMMITTED)                     
                WHERE CO.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_TRANS)                                            
MFA-TR*          INTO :CO-AMT-TRANS:WS-NULL4                                    
MFA-TR*          FROM CSS_CHRG_OFF CO                                           
MFA-TR*         WHERE CO.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7105                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL4 < 0                                      
                       MOVE 0.00 TO CO-AMT-TRANS                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  CO-AMT-TRANS                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CHRG_OFF'      TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-COLLECT-CONTACT.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :HC-ACCOUNT-NO                                    
                 FROM CSS_COLLECT_HIST WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND FUTURE_WORK_DT IS NOT NULL                        
                  AND CALL_TYPE_CD IN ('A', 'M')                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :HC-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_COLLECT_HIST                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND FUTURE_WORK_DT IS NOT NULL                                
MFA-TR*           AND CALL_TYPE_CD IN ('A', 'M')                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-COLLECT-CONTACT-FL                    
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-COLLECT-CONTACT-FL                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_COLLECT_HIST'   TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04492_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04492_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04492_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04492_R1                            
             (                                                          
               RETURN_CODE,                                             
               ACCOUNT_NO,                                              
               CUSTOMER_NO,                                             
               LOCAL_OFFICE,                                            
               CREDIT_GROUP,                                            
               COMPANY_NO,                                              
               PREMISE_NO,                                              
               MST_SUB_ACCT_IND,                                        
               CODE_ACCT_STAT,                                          
               ACCOUNT_TYPE_CODE,                                       
               CODE_PRNT_BLL_MST,                                       
               REV_MTH_LST_NRML,                                        
               EPP_OFFER_DATE,                                          
               NO_BILL_COPIES,                                          
               TOTAL_AR_BALANCE,                                        
               DATE_BILL_DAY_00,                                        
               CODES_DATA_PRESENT,                                      
               EPP,                                                     
               PROJECT_SHARE,                                           
               STATE,                                                   
               TOWN,                                                    
               HOUSE_NO,                                                
               ADDR_PREFIX_1,                                           
               ADDR_PREFIX_2,                                           
               STREET_NAME,                                             
               ADDRESS_OVERFLOW,                                        
               ADDR_USAGE_CD,                                           
               STREET_SUFFIX,                                           
               STREET_LOCATION_1,                                       
               STREET_LOCATION_2,                                       
               ADDR_SUFFIX,                                             
               ZIP_CODE,                                                
               NAME_TYPE,                                               
               FULL_NAME,                                               
               FIRST_NAME,                                              
               MIDDLE_NAME,                                             
               LAST_NAME,                                               
               NAME_FORMAT,                                             
               TITLE_PREFIX,                                            
               TITLE_SUFFIX_1,                                          
               TITLE_SUFFIX_2,                                          
P00613         REG_GROUP_CD                                             
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-ACCOUNT-NO,                                           
               :S-CUSTOMER-NO,                                          
               :S-LOCAL-OFFICE,                                         
               :S-CREDIT-GROUP,                                         
               :S-COMPANY-NO,                                           
               :S-PREMISE-NO,                                           
               :S-MST-SUB-ACCT-IND,                                     
               :S-CODE-ACCT-STAT,                                       
               :S-ACCOUNT-TYPE-CODE,                                    
               :S-CODE-PRNT-BLL-MST,                                    
               :S-REV-MTH-LST-NRML,                                     
               :S-EPP-OFFER-DATE,                                       
               :S-NO-BILL-COPIES,                                       
               :S-TOTAL-AR-BALANCE,                                     
               :S-DATE-BILL-DAY-00,                                     
               :S-CODES-DATA-PRESENT,                                   
               :S-EPP-FL,                                               
               :S-PROJECT-SHARE-FL,                                     
               :S-STATE,                                                
               :S-TOWN,                                                 
               :S-HOUSE-NO,                                             
               :S-ADDR-PREFIX-1,                                        
               :S-ADDR-PREFIX-2,                                        
               :S-STREET-NAME,                                          
               :S-ADDRESS-OVERFLOW,                                     
               :S-ADDR-USAGE-CD,                                        
               :S-STREET-SUFFIX,                                        
               :S-STREET-LOCATION-1,                                    
               :S-STREET-LOCATION-2,                                    
               :S-ADDR-SUFFIX,                                          
               :S-ZIP-CODE,                                             
               :S-NAME-TYPE,                                            
               :S-FULL-NAME,                                            
               :S-FIRST-NAME,                                           
               :S-MIDDLE-NAME,                                          
               :S-LAST-NAME,                                            
               :S-NAME-FORMAT,                                          
               :S-TITLE-PREFIX,                                         
               :S-TITLE-SUFFIX-1,                                       
               :S-TITLE-SUFFIX-2,                                       
P00613         :S-REG-GROUP-CD                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04492_R1                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        ACCOUNT_NO,                                                      
MFA-TR*        CUSTOMER_NO,                                                     
MFA-TR*        LOCAL_OFFICE,                                                    
MFA-TR*        CREDIT_GROUP,                                                    
MFA-TR*        COMPANY_NO,                                                      
MFA-TR*        PREMISE_NO,                                                      
MFA-TR*        MST_SUB_ACCT_IND,                                                
MFA-TR*        CODE_ACCT_STAT,                                                  
MFA-TR*        ACCOUNT_TYPE_CODE,                                               
MFA-TR*        CODE_PRNT_BLL_MST,                                               
MFA-TR*        REV_MTH_LST_NRML,                                                
MFA-TR*        EPP_OFFER_DATE,                                                  
MFA-TR*        NO_BILL_COPIES,                                                  
MFA-TR*        TOTAL_AR_BALANCE,                                                
MFA-TR*        DATE_BILL_DAY_00,                                                
MFA-TR*        CODES_DATA_PRESENT,                                              
MFA-TR*        EPP,                                                             
MFA-TR*        PROJECT_SHARE,                                                   
MFA-TR*        STATE,                                                           
MFA-TR*        TOWN,                                                            
MFA-TR*        HOUSE_NO,                                                        
MFA-TR*        ADDR_PREFIX_1,                                                   
MFA-TR*        ADDR_PREFIX_2,                                                   
MFA-TR*        STREET_NAME,                                                     
MFA-TR*        ADDRESS_OVERFLOW,                                                
MFA-TR*        ADDR_USAGE_CD,                                                   
MFA-TR*        STREET_SUFFIX,                                                   
MFA-TR*        STREET_LOCATION_1,                                               
MFA-TR*        STREET_LOCATION_2,                                               
MFA-TR*        ADDR_SUFFIX,                                                     
MFA-TR*        ZIP_CODE,                                                        
MFA-TR*        NAME_TYPE,                                                       
MFA-TR*        FULL_NAME,                                                       
MFA-TR*        FIRST_NAME,                                                      
MFA-TR*        MIDDLE_NAME,                                                     
MFA-TR*        LAST_NAME,                                                       
MFA-TR*        NAME_FORMAT,                                                     
MFA-TR*        TITLE_PREFIX,                                                    
MFA-TR*        TITLE_SUFFIX_1,                                                  
MFA-TR*        TITLE_SUFFIX_2,                                                  
MFA-TR*        REG_GROUP_CD                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-CUSTOMER-NO,                                                  
MFA-TR*        :S-LOCAL-OFFICE,                                                 
MFA-TR*        :S-CREDIT-GROUP,                                                 
MFA-TR*        :S-COMPANY-NO,                                                   
MFA-TR*        :S-PREMISE-NO,                                                   
MFA-TR*        :S-MST-SUB-ACCT-IND,                                             
MFA-TR*        :S-CODE-ACCT-STAT,                                               
MFA-TR*        :S-ACCOUNT-TYPE-CODE,                                            
MFA-TR*        :S-CODE-PRNT-BLL-MST,                                            
MFA-TR*        :S-REV-MTH-LST-NRML,                                             
MFA-TR*        :S-EPP-OFFER-DATE,                                               
MFA-TR*        :S-NO-BILL-COPIES,                                               
MFA-TR*        :S-TOTAL-AR-BALANCE,                                             
MFA-TR*        :S-DATE-BILL-DAY-00,                                             
MFA-TR*        :S-CODES-DATA-PRESENT,                                           
MFA-TR*        :S-EPP-FL,                                                       
MFA-TR*        :S-PROJECT-SHARE-FL,                                             
MFA-TR*        :S-STATE,                                                        
MFA-TR*        :S-TOWN,                                                         
MFA-TR*        :S-HOUSE-NO,                                                     
MFA-TR*        :S-ADDR-PREFIX-1,                                                
MFA-TR*        :S-ADDR-PREFIX-2,                                                
MFA-TR*        :S-STREET-NAME,                                                  
MFA-TR*        :S-ADDRESS-OVERFLOW,                                             
MFA-TR*        :S-ADDR-USAGE-CD,                                                
MFA-TR*        :S-STREET-SUFFIX,                                                
MFA-TR*        :S-STREET-LOCATION-1,                                            
MFA-TR*        :S-STREET-LOCATION-2,                                            
MFA-TR*        :S-ADDR-SUFFIX,                                                  
MFA-TR*        :S-ZIP-CODE,                                                     
MFA-TR*        :S-NAME-TYPE,                                                    
MFA-TR*        :S-FULL-NAME,                                                    
MFA-TR*        :S-FIRST-NAME,                                                   
MFA-TR*        :S-MIDDLE-NAME,                                                  
MFA-TR*        :S-LAST-NAME,                                                    
MFA-TR*        :S-NAME-FORMAT,                                                  
MFA-TR*        :S-TITLE-PREFIX,                                                 
MFA-TR*        :S-TITLE-SUFFIX-1,                                               
MFA-TR*        :S-TITLE-SUFFIX-2,                                               
MFA-TR*        :S-REG-GROUP-CD                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04492_R1'        TO TABLE-1                      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
