       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04491.                                     
COB303 DATE-WRITTEN.  JULY 30, 2013                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE UPDATES/INSERTS/DELETES THE CORRESPONDENCE     *        
      *  ADDRESS.                                                      *        
      *                                                                *        
      *  STATUS CODE VALUES                                            *        
      *      +200              INVALID ACTION CODE                     *        
      *      +300              CUSTOMER NUMBER IS 0                    *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/30/13    FMB      PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04491'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04491 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSADRX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           COPY CCA00001.                                                       
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00071                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS0090A                                                  
           END-EXEC.                                                            
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04491'.     
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-ADDRESS-ID-CHAR       PIC X(13).                      
           05  WS-ADDRESS-ID-NUM        REDEFINES WS-ADDRESS-ID-CHAR    
                                        PIC 9(13).                      
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-ADDR-EXISTS-FL        PIC X(01) VALUE 'N'.            
           05  WS-OLD-ADDRESS-ID        PIC 9(13) VALUE ZEROES.         
           05  WS-OLD-ADDRESS-FORMAT    PIC X(01) VALUE SPACES.         
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
               88 MAIL-EXISTS                     VALUE 'Y'.            
           05  WS-BLANK-PARM            PIC X(01) VALUE 'N'.            
           05  WS-TRAN-APPL-NO          PIC 9(04).                      
           05  WS-TRAN-COMMENT.                                         
               49  WS-TRAN-COMMENT-LEN                                  
                                   PIC S9(04) COMP SYNC VALUE +0.       
               49  WS-TRAN-COMMENT-TEXT PIC X(210) VALUE SPACES.        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-STATUS-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-ADDRESS-ID             PIC X(13) VALUE SPACES.         
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACTION-CD             PIC X(01).                        
       01  LINK-CUSTOMER-NO           PIC X(10).                        
       01  LINK-ADDRESS-ID            PIC X(13).                        
       01  LINK-ADDRESS-FORMAT        PIC X(01).                        
       01  LINK-FRE-STREET            PIC X(55).                        
       01  LINK-FRE-CITY-STATE        PIC X(30).                        
       01  LINK-FRE-ZIP-CODE          PIC X(09).                        
       01  LINK-FRE-ADDR-OVERFLOW     PIC X(35).                        
       01  LINK-FRE-COUNTRY           PIC X(35).                        
       01  LINK-FMT-HOUSE-NO          PIC X(15).                        
       01  LINK-FMT-ADDR-PREFIX-1     PIC X(03).                        
       01  LINK-FMT-ADDR-PREFIX-2     PIC X(02).                        
       01  LINK-FMT-STREET-NAME       PIC X(30).                        
       01  LINK-FMT-STREET-SUFFIX     PIC X(04).                        
       01  LINK-FMT-STREET-LOC-1      PIC X(04).                        
       01  LINK-FMT-STREET-LOC-2      PIC X(11).                        
       01  LINK-FMT-ADDR-SUFFIX       PIC X(02).                        
       01  LINK-FMT-ZIP-CODE          PIC X(05).                        
       01  LINK-FMT-ZIP-CODE-PLUS-4   PIC X(04).                        
       01  LINK-FMT-ZIP-CODE-TOKEN    PIC X(01).                        
       01  LINK-FMT-ADDR-OVERFLOW     PIC X(35).                        
       01  LINK-FMT-DELIVERY-PT       PIC X(02).                        
       01  LINK-USER-ID               PIC X(07).                        
       01  LINK-TRAN-CMNT-LEN         PIC S9(04) COMP.                  
       01  LINK-TRAN-CMNT-TXT         PIC X(210).                       
       01  LINK-FMT-TOWN              PIC X(26).                        
       01  LINK-FMT-STATE             PIC X(02).                        
                                                                        
       PROCEDURE DIVISION USING LINK-ACTION-CD                          
                                LINK-CUSTOMER-NO                        
                                LINK-ADDRESS-ID                         
                                LINK-ADDRESS-FORMAT                     
                                LINK-FRE-STREET                         
                                LINK-FRE-CITY-STATE                     
                                LINK-FRE-ZIP-CODE                       
                                LINK-FRE-ADDR-OVERFLOW                  
                                LINK-FRE-COUNTRY                        
                                LINK-FMT-HOUSE-NO                       
                                LINK-FMT-ADDR-PREFIX-1                  
                                LINK-FMT-ADDR-PREFIX-2                  
                                LINK-FMT-STREET-NAME                    
                                LINK-FMT-STREET-SUFFIX                  
                                LINK-FMT-STREET-LOC-1                   
                                LINK-FMT-STREET-LOC-2                   
                                LINK-FMT-ADDR-SUFFIX                    
                                LINK-FMT-ZIP-CODE                       
                                LINK-FMT-ZIP-CODE-PLUS-4                
                                LINK-FMT-ZIP-CODE-TOKEN                 
                                LINK-FMT-ADDR-OVERFLOW                  
                                LINK-FMT-DELIVERY-PT                    
                                LINK-USER-ID                            
                                LINK-TRAN-CMNT-LEN                      
                                LINK-TRAN-CMNT-TXT                      
                                LINK-FMT-TOWN                           
                                LINK-FMT-STATE.                         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE THRU 0100-EXIT.                      
           PERFORM 1000-PROCESS-INPUT THRU 1000-EXIT.                   
           IF LINK-CUSTOMER-NO > 0                                      
               PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT               
           ELSE                                                         
               MOVE +300 TO S-STATUS-CODE
           END-IF.                              
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE      AS  RETURN_CODE,              
                      :S-STATUS-CODE      AS  STATUS_CODE,              
                      :S-ADDRESS-ID       AS  ADDRESS_ID                
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE      AS  RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE      AS  STATUS_CODE,                      
MFA-TR*               :S-ADDRESS-ID       AS  ADDRESS_ID                        
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-TRAN-CMNT-LEN TO WS-TRAN-COMMENT-LEN.              
           MOVE LINK-TRAN-CMNT-TXT TO WS-TRAN-COMMENT-TEXT.             
           IF LINK-ADDRESS-ID NOT NUMERIC                               
               MOVE ZEROES TO LINK-ADDRESS-ID
           END-IF.                          
           IF LINK-CUSTOMER-NO NOT NUMERIC                              
               MOVE ZEROES TO LINK-CUSTOMER-NO
           END-IF.                         
                                                                        
           MOVE 'Y' TO WS-BLANK-PARM.                                   
           IF LINK-ADDRESS-FORMAT = 'B'                                 
               IF LINK-FRE-STREET        > ' ' OR                       
                  LINK-FRE-CITY-STATE    > ' ' OR                       
                  LINK-FRE-ZIP-CODE      > ' ' OR                       
                  LINK-FRE-ADDR-OVERFLOW > ' ' OR                       
                  LINK-FRE-COUNTRY > ' '                                
                      MOVE 'N' TO WS-BLANK-PARM
               END-IF
           END-IF.                        
           IF LINK-ADDRESS-FORMAT = 'A'                                 
               IF LINK-FMT-HOUSE-NO      > ' ' OR                       
                  LINK-FMT-ADDR-PREFIX-1 > ' ' OR                       
                  LINK-FMT-ADDR-PREFIX-2 > ' ' OR                       
                  LINK-FMT-STREET-NAME   > ' ' OR                       
                  LINK-FMT-STREET-SUFFIX > ' ' OR                       
                  LINK-FMT-STREET-LOC-1 > ' ' OR                        
                  LINK-FMT-STREET-LOC-2 > ' ' OR                        
                  LINK-FMT-ADDR-SUFFIX  > ' ' OR                        
                  LINK-FMT-ZIP-CODE     > ' ' OR                        
                  LINK-FMT-ZIP-CODE-PLUS-4 > ' ' OR                     
                  LINK-FMT-ZIP-CODE-TOKEN > ' ' OR                      
                  LINK-FMT-ADDR-OVERFLOW > ' '                          
                      MOVE 'N' TO WS-BLANK-PARM
               END-IF
           END-IF.                        
           IF WS-BLANK-PARM = 'Y'                                       
               MOVE 'D' TO LINK-ACTION-CD
           END-IF.                              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-RESP-AREA THRU 7000-EXIT.                   
                                                                        
           MOVE LINK-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.                
           MOVE WS-CUSTOMER-NO-NUM TO DM-CUSTOMER-NO.                   
           PERFORM 7050-CUST-ADDRESS THRU 7050-EXIT.                    
           IF WS-ADDR-EXISTS-FL = 'Y' AND                               
              LINK-ACTION-CD = 'A'                                      
                  MOVE 'C' TO LINK-ACTION-CD
           END-IF.                           
                                                                        
           MOVE LINK-ADDRESS-ID TO WS-ADDRESS-ID-CHAR.                  
                                                                        
           MOVE WS-CURRENT-TS TO MH-TRANS-HIST-SEQ-NO.                  
           MOVE WS-CURRENT-DATE TO MH-DATE-TRANS.                       
           MOVE 'F' TO MH-CODE-TRAN-TYPE.                               
           MOVE 'PANEL030' TO MH-APPL-PROGRAM-ID.                       
           MOVE LINK-USER-ID TO MH-USER-ID.                             
           MOVE PF-RESP-AREA-ID TO MH-RESP-AREA-ID.                     
           IF WS-TRAN-COMMENT-TEXT = SPACES                             
              MOVE ZERO TO MH-TRAN-COMMENT-LEN                          
           ELSE                                                         
              MOVE WS-TRAN-COMMENT-LEN TO MH-TRAN-COMMENT-LEN
           END-IF.          
           MOVE WS-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-TEXT.           
           MOVE ZEROES TO MH-ACCOUNT-NO.                                
           MOVE WS-CUSTOMER-NO-NUM TO MH-CUSTOMER-NO.                   
           MOVE ZEROES TO MH-PREMISE-NO.                                
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
                                                                        
           EVALUATE LINK-ACTION-CD                                      
               WHEN 'A'                                                 
                   PERFORM 2100-ADD-CORR-ADDR THRU 2100-EXIT            
               WHEN 'C'                                                 
                   PERFORM 2300-DELETE-CORR-ADDR THRU 2300-EXIT         
                   PERFORM 2100-ADD-CORR-ADDR THRU 2100-EXIT            
               WHEN 'D'                                                 
                   PERFORM 2300-DELETE-CORR-ADDR THRU 2300-EXIT         
               WHEN OTHER                                               
                   MOVE +200 TO S-STATUS-CODE                           
           END-EVALUATE.                                                
                                                                        
           ADD +1 TO CTR-ROWS.                                          
           MOVE RS-RETURN-CODE TO S-RETURN-CODE.                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-ADD-CORR-ADDR.                                              
                                                                        
           MOVE 'M' TO DM-ADDRESS-TYPE                                  
                                                                        
           MOVE 'PANEL030' TO WS-90-PANEL-NO.                           
           MOVE LINK-USER-ID TO WS-90-USERID.                           
           MOVE ZEROES TO WS-90-ACCOUNT-NO.                             
           MOVE LINK-CUSTOMER-NO TO WS-90-CUSTOMER-NO.                  
           MOVE ZEROES TO WS-90-PREMISE-NO.                             
           PERFORM 6202-GET-NEW-ADDRESS-ID THRU 6202-EXIT.              
           MOVE WS-90-NEW-ADDRESS-ID TO I8-ADDRESS-ID.                  
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO DM-CUSTOMER-NO.                   
           MOVE I8-ADDRESS-ID TO DM-ADDRESS-ID                          
                                 DZ-ADDRESS-ID                          
                                 DY-ADDRESS-ID.                         
                                                                        
           IF LINK-ADDRESS-FORMAT = 'A'                                 
               PERFORM 7300-GET-TOKEN THRU 7300-EXIT                    
               PERFORM 6215-JOURNAL-FMT-INSERT THRU 6215-EXIT           
               MOVE 'A' TO DM-ADDRESS-FORMAT                            
               MOVE LINK-FMT-HOUSE-NO TO DY-HOUSE-NO                    
               MOVE LINK-FMT-ADDR-PREFIX-1 TO DY-ADDR-PREFIX-1          
               MOVE LINK-FMT-ADDR-PREFIX-2 TO DY-ADDR-PREFIX-2          
               MOVE LINK-FMT-STREET-NAME TO DY-STREET-NAME              
               MOVE LINK-FMT-STREET-SUFFIX TO DY-STREET-SUFFIX          
               MOVE LINK-FMT-STREET-LOC-1 TO DY-STREET-LOCATION-1       
               MOVE LINK-FMT-STREET-LOC-2 TO DY-STREET-LOCATION-2       
               MOVE LINK-FMT-ADDR-SUFFIX TO DY-ADDR-SUFFIX              
               MOVE LINK-FMT-ZIP-CODE TO DY-ZIP-CODE                    
               MOVE LINK-FMT-ZIP-CODE-PLUS-4 TO DY-ZIP-CODE-PLUS-FOUR   
               MOVE A4-ZIP-CODE-TOKEN TO DY-ZIP-CODE-TOKEN              
               MOVE LINK-FMT-ADDR-OVERFLOW TO DY-ADDRESS-OVERFLOW       
               MOVE LINK-FMT-DELIVERY-PT TO DY-USPS-DELIV-PT-CD         
               PERFORM 8700-INSERT-ADDR-FMT THRU 8700-EXIT              
           ELSE                                                         
               PERFORM 6211-JOURNAL-FRE-INSERT THRU 6211-EXIT           
               MOVE 'B' TO DM-ADDRESS-FORMAT                            
               MOVE LINK-FRE-STREET TO DZ-ADDR-STREET                   
               MOVE LINK-FRE-CITY-STATE TO DZ-ADDR-CITY-STATE           
               MOVE LINK-FRE-ZIP-CODE TO DZ-ADDR-ZIP-CODE               
               MOVE LINK-FRE-COUNTRY TO DZ-ADDR-COUNTRY                 
               MOVE LINK-FRE-ADDR-OVERFLOW TO DZ-ADDRESS-OVERFLOW       
               PERFORM 8500-INSERT-ADDR-FREE THRU 8500-EXIT
           END-IF.            
                                                                        
           PERFORM 8400-DELETE-ADDR-XREF THRU 8400-EXIT.                
           PERFORM 8300-INSERT-ADDR-XREF THRU 8300-EXIT.                
           MOVE I8-ADDRESS-ID TO S-ADDRESS-ID.                          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-DELETE-CORR-ADDR.                                           
                                                                        
           IF WS-OLD-ADDRESS-FORMAT = 'A'                               
               MOVE WS-OLD-ADDRESS-ID TO DY-ADDRESS-ID                  
               PERFORM 7200-SELECT-ADDR-FMT THRU 7200-EXIT              
               PERFORM 6235-JOURNAL-FMT-DELETE THRU 6235-EXIT           
           ELSE                                                         
               MOVE WS-OLD-ADDRESS-ID TO DZ-ADDRESS-ID                  
               PERFORM 7100-SELECT-ADDR-FREE THRU 7100-EXIT             
               PERFORM 6230-JOURNAL-FRE-DELETE THRU 6230-EXIT
           END-IF.          
           PERFORM 8400-DELETE-ADDR-XREF THRU 8400-EXIT.                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6211-JOURNAL-FRE-INSERT.                                         
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COR ADR STREET'         TO MI-COLUMN-DESC.             
           MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 55                       TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LINK-FRE-STREET          TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COR ADR CITY ST'        TO MI-COLUMN-DESC.             
           MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 30                       TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE LINK-FRE-CITY-STATE      TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF LINK-FRE-ZIP-CODE > SPACES                                
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ADR ZIP'        TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FRE-ZIP-CODE    TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FRE-ADDR-OVERFLOW > SPACES                           
               MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
               MOVE 'COR ADR OVRFLOW'       TO MI-COLUMN-DESC           
               MOVE 5                       TO MI-PRV-COLUMN-VALUE-LEN  
               MOVE 35                      TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE LINK-FRE-ADDR-OVERFLOW TO                           
                    MI-CHG-COLUMN-VALUE-TEXT                            
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FRE-COUNTRY > SPACES                                 
               MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO          
               MOVE 'COR COUNTRY'           TO MI-COLUMN-DESC           
               MOVE 5                       TO MI-PRV-COLUMN-VALUE-LEN  
               MOVE 35                      TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE '*NEW*'                 TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE LINK-FRE-COUNTRY        TO MI-CHG-COLUMN-VALUE-TEXT 
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
       6211-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6215-JOURNAL-FMT-INSERT.                                         
                                                                        
           IF LINK-FMT-HOUSE-NO > SPACES                                
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR HOUSE NO'       TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 15                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-HOUSE-NO    TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-ADDR-PREFIX-1 > SPACES                           
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ADDR PRE 1'     TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 3                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-ADDR-PREFIX-1 TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-ADDR-PREFIX-2 > SPACES                           
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ADDR PRE 2'     TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 2                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-ADDR-PREFIX-2 TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-STREET-NAME > SPACES                             
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR STREET NAME'    TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 30                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-STREET-NAME TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-STREET-SUFFIX > SPACES                           
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR STREET SUFF'    TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 4                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-STREET-SUFFIX TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-STREET-LOC-1 > SPACES                            
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR STREET LOC1'    TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 4                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-STREET-LOC-1 TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-STREET-LOC-2 > SPACES                            
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR STREET LOC2'    TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 11                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-STREET-LOC-2 TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-ADDR-SUFFIX > SPACES                             
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ADDR SUFFIX'    TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 2                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-ADDR-SUFFIX TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-ZIP-CODE > SPACES                                
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ZIP CODE'       TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 5                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-ZIP-CODE    TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-ZIP-CODE-PLUS-4 > SPACES                         
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ZIP +4'         TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 4                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-ZIP-CODE-PLUS-4 TO MI-CHG-COLUMN-VALUE-TEXT
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-ADDR-OVERFLOW > SPACES                           
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR OVERFLOW'       TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 35                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-ADDR-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF LINK-FMT-DELIVERY-PT > SPACES                             
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR DEL PT'         TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 2                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE LINK-FMT-DELIVERY-PT TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
       6215-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6220-JOURNAL-FRE-UPDATE.                                         
                                                                        
           IF LINK-FRE-STREET = DZ-ADDR-STREET                          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ADR STREET'     TO MI-COLUMN-DESC               
              MOVE 55                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-STREET       TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FRE-STREET      TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FRE-CITY-STATE = DZ-ADDR-CITY-STATE                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE 'COR ADR CITY ST'      TO MI-COLUMN-DESC             
              MOVE 30                     TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE DZ-ADDR-CITY-STATE     TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE LINK-FRE-CITY-STATE    TO MI-CHG-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FRE-ZIP-CODE = DZ-ADDR-ZIP-CODE                      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ADR ZIPCODE'    TO MI-COLUMN-DESC               
              MOVE 9                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-ZIP-CODE     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FRE-ZIP-CODE    TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FRE-ADDR-OVERFLOW = DZ-ADDRESS-OVERFLOW              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ADR OVRFLOW'    TO MI-COLUMN-DESC               
              MOVE 35                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDRESS-OVERFLOW  TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FRE-ADDR-OVERFLOW TO                            
                   MI-CHG-COLUMN-VALUE-TEXT                             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FRE-COUNTRY = DZ-ADDR-COUNTRY                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ADR COUNTRY'    TO MI-COLUMN-DESC               
              MOVE 35                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-COUNTRY      TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FRE-COUNTRY     TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       6220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6225-JOURNAL-FMT-UPDATE.                                         
                                                                        
           IF LINK-FMT-HOUSE-NO = DY-HOUSE-NO                           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR HOUSE NO'       TO MI-COLUMN-DESC               
              MOVE 15                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-HOUSE-NO          TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-HOUSE-NO    TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-ADDR-PREFIX-1 = DY-ADDR-PREFIX-1                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR PREFIX 1'       TO MI-COLUMN-DESC               
              MOVE 3                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-ADDR-PREFIX-1     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-ADDR-PREFIX-1 TO MI-CHG-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-ADDR-PREFIX-2 = DY-ADDR-PREFIX-2                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR PREFIX 2'       TO MI-COLUMN-DESC               
              MOVE 2                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-ADDR-PREFIX-2     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-ADDR-PREFIX-2 TO MI-CHG-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-STREET-NAME = DY-STREET-NAME                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR STREET NAME'    TO MI-COLUMN-DESC               
              MOVE 30                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-STREET-NAME       TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-STREET-NAME TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-STREET-SUFFIX = DY-STREET-SUFFIX                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR STREET SUFF'    TO MI-COLUMN-DESC               
              MOVE 4                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-STREET-SUFFIX     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-STREET-SUFFIX TO MI-CHG-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-STREET-LOC-1 = DY-STREET-LOCATION-1              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR STREET LOC1'    TO MI-COLUMN-DESC               
              MOVE 4                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-STREET-LOCATION-1 TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-STREET-LOC-1 TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-STREET-LOC-2 = DY-STREET-LOCATION-2              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR STREET LOC2'    TO MI-COLUMN-DESC               
              MOVE 11                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-STREET-LOCATION-2 TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-STREET-LOC-2 TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-ADDR-SUFFIX = DY-ADDR-SUFFIX                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ADDR SUFFIX'    TO MI-COLUMN-DESC               
              MOVE 2                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-ADDR-SUFFIX       TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-ADDR-SUFFIX TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-ZIP-CODE = DY-ZIP-CODE                           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ZIP CODE'       TO MI-COLUMN-DESC               
              MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-ZIP-CODE          TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-ZIP-CODE    TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-ZIP-CODE-PLUS-4 = DY-ZIP-CODE-PLUS-FOUR          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ZIP +4'         TO MI-COLUMN-DESC               
              MOVE 4                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-ZIP-CODE-PLUS-FOUR TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE LINK-FMT-ZIP-CODE-PLUS-4 TO MI-CHG-COLUMN-VALUE-TEXT 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-ADDR-OVERFLOW = DY-ADDRESS-OVERFLOW              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR OVERFLOW'       TO MI-COLUMN-DESC               
              MOVE 35                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-ADDRESS-OVERFLOW  TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-ADDR-OVERFLOW TO MI-CHG-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF LINK-FMT-DELIVERY-PT = DY-USPS-DELIV-PT-CD                
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR OVERFLOW'       TO MI-COLUMN-DESC               
              MOVE 2                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DY-USPS-DELIV-PT-CD  TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE LINK-FMT-DELIVERY-PT TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       6225-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6230-JOURNAL-FRE-DELETE.                                         
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COR ADR STREET'         TO MI-COLUMN-DESC.             
           MOVE 55                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DZ-ADDR-STREET           TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COR ADR CITY ST'        TO MI-COLUMN-DESC.             
           MOVE 30                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DZ-ADDR-CITY-STATE       TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF DZ-ADDR-ZIP-CODE > SPACES                                 
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'COR ADR ZIPCODE'     TO MI-COLUMN-DESC              
              MOVE 9                     TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 9                     TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE DZ-ADDR-ZIP-CODE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF DZ-ADDRESS-OVERFLOW > SPACES                              
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'COR ADR OVRFLOW'       TO MI-COLUMN-DESC            
              MOVE 35                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE 9                       TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE DZ-ADDRESS-OVERFLOW     TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
           IF DZ-ADDR-COUNTRY > SPACES                                  
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'COR ADR COUNTRY'       TO MI-COLUMN-DESC            
              MOVE 35                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE 9                       TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE DZ-ADDR-COUNTRY         TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                 
                                                                        
       6230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6235-JOURNAL-FMT-DELETE.                                         
                                                                        
           IF DY-HOUSE-NO > SPACES                                      
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR HOUSE NO'       TO MI-COLUMN-DESC              
               MOVE 15                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-HOUSE-NO          TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-ADDR-PREFIX-1 > SPACES                                 
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ADD PREF 1'     TO MI-COLUMN-DESC              
               MOVE 3                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-ADDR-PREFIX-1     TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-ADDR-PREFIX-2 > SPACES                                 
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ADD PREF 2'     TO MI-COLUMN-DESC              
               MOVE 2                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-ADDR-PREFIX-2     TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-STREET-NAME > SPACES                                   
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR STREET NM '     TO MI-COLUMN-DESC              
               MOVE 30                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-STREET-NAME       TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-STREET-SUFFIX > SPACES                                 
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR STREET SUF'     TO MI-COLUMN-DESC              
               MOVE 4                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-STREET-SUFFIX     TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-STREET-LOCATION-1 > SPACES                             
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR STREET L1'      TO MI-COLUMN-DESC              
               MOVE 4                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-STREET-LOCATION-1 TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-STREET-LOCATION-2 > SPACES                             
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR STREET L2'      TO MI-COLUMN-DESC              
               MOVE 11                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-STREET-LOCATION-2 TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-ADDR-SUFFIX > SPACES                                   
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ADD SUFF'       TO MI-COLUMN-DESC              
               MOVE 2                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-ADDR-SUFFIX       TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-ZIP-CODE > SPACES                                      
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ZIP CODE'       TO MI-COLUMN-DESC              
               MOVE 5                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-ZIP-CODE          TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-ZIP-CODE-PLUS-FOUR > SPACES                            
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ZIP +4'         TO MI-COLUMN-DESC              
               MOVE 4                    TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-ZIP-CODE-PLUS-FOUR TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
           IF DY-ADDRESS-OVERFLOW > SPACES                              
               MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO             
               MOVE 'COR ADDR OVER'      TO MI-COLUMN-DESC              
               MOVE 35                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 9                    TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE DY-ADDRESS-OVERFLOW  TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRAN-APPL-NO
           END-IF.                                
                                                                        
       6235-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00090                                                  
           END-EXEC.                                                            
                                                                        
       7000-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RESP_AREA_ID                                      
                 INTO :PF-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :LINK-USER-ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :LINK-USER-ID                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO PF-RESP-AREA-ID                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_USER_PROFILE' TO TABLE-1                   
                   MOVE 'USER_ID'          TO TABLE-ELEMENT-1           
                   MOVE LINK-USER-ID       TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-CUST-ADDRESS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ADDRESS_ID,
              ADDRESS_FORMAT                                    
                 INTO :DM-ADDRESS-ID,                                   
                      :DM-ADDRESS-FORMAT                                
                 FROM CSS_CUST_ADDR_XREF WITH(READUNCOMMITTED)                  
                WHERE CUSTOMER_NO = :DM-CUSTOMER-NO                     
                  AND ADDRESS_TYPE = 'M'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_ID,                                               
MFA-TR*               ADDRESS_FORMAT                                            
MFA-TR*          INTO :DM-ADDRESS-ID,                                           
MFA-TR*               :DM-ADDRESS-FORMAT                                        
MFA-TR*          FROM CSS_CUST_ADDR_XREF                                        
MFA-TR*         WHERE CUSTOMER_NO = :DM-CUSTOMER-NO                             
MFA-TR*           AND ADDRESS_TYPE = 'M'                                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ADDR-EXISTS-FL                        
                   MOVE DM-ADDRESS-ID TO WS-OLD-ADDRESS-ID              
                   MOVE DM-ADDRESS-FORMAT TO WS-OLD-ADDRESS-FORMAT      
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ADDR-EXISTS-FL                        
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7050'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_ADDR_XREF' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1           
                   MOVE DM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW                                   
              INTO  :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDR-COUNTRY,                                   
                    :DZ-ADDRESS-OVERFLOW                                
              FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                      
              WHERE ADDRESS_ID = :DZ-ADDRESS-ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDR_STREET,                                               
MFA-TR*              ADDR_CITY_STATE,                                           
MFA-TR*              ADDR_ZIP_CODE,                                             
MFA-TR*              ADDR_COUNTRY,                                              
MFA-TR*              ADDRESS_OVERFLOW                                           
MFA-TR*       INTO  :DZ-ADDR-STREET,                                            
MFA-TR*             :DZ-ADDR-CITY-STATE,                                        
MFA-TR*             :DZ-ADDR-ZIP-CODE,                                          
MFA-TR*             :DZ-ADDR-COUNTRY,                                           
MFA-TR*             :DZ-ADDRESS-OVERFLOW                                        
MFA-TR*       FROM CSS_ADDR_FREEFORM                                            
MFA-TR*       WHERE ADDRESS_ID = :DZ-ADDRESS-ID                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ADDR-FREEFORM                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME TO ABEND-PROGRAM                   
                   MOVE '7100'     TO ACTIVE-PARAGRAPH                  
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
                   MOVE 'ADDRESS-ID'    TO TABLE-ELEMENT-1              
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-2              
                   MOVE DZ-ADDRESS-ID   TO HOSTVAR-ELEMENT-1            
                   MOVE LINK-CUSTOMER-NO TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-ADDR-FMT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT HOUSE_NO,                                          
                     ADDR_PREFIX_1,                                     
                     ADDR_PREFIX_2,                                     
                     STREET_NAME,                                       
                     STREET_SUFFIX,                                     
                     STREET_LOCATION_1,                                 
                     STREET_LOCATION_2,                                 
                     ADDR_SUFFIX,                                       
                     ZIP_CODE,                                          
                     ZIP_CODE_PLUS_FOUR,                                
                     ZIP_CODE_TOKEN,                                    
                     ADDRESS_OVERFLOW,                                  
                     USPS_DELIV_PT_CD                                   
              INTO  :DY-HOUSE-NO,                                       
                    :DY-ADDR-PREFIX-1,                                  
                    :DY-ADDR-PREFIX-2,                                  
                    :DY-STREET-NAME,                                    
                    :DY-STREET-SUFFIX,                                  
                    :DY-STREET-LOCATION-1,                              
                    :DY-STREET-LOCATION-2,                              
                    :DY-ADDR-SUFFIX,                                    
                    :DY-ZIP-CODE,                                       
                    :DY-ZIP-CODE-PLUS-FOUR,                             
                    :DY-ZIP-CODE-TOKEN,                                 
                    :DY-ADDRESS-OVERFLOW,                               
                    :DY-USPS-DELIV-PT-CD                                
              FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                     
              WHERE ADDRESS_ID = :DY-ADDRESS-ID                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT HOUSE_NO,                                                  
MFA-TR*              ADDR_PREFIX_1,                                             
MFA-TR*              ADDR_PREFIX_2,                                             
MFA-TR*              STREET_NAME,                                               
MFA-TR*              STREET_SUFFIX,                                             
MFA-TR*              STREET_LOCATION_1,                                         
MFA-TR*              STREET_LOCATION_2,                                         
MFA-TR*              ADDR_SUFFIX,                                               
MFA-TR*              ZIP_CODE,                                                  
MFA-TR*              ZIP_CODE_PLUS_FOUR,                                        
MFA-TR*              ZIP_CODE_TOKEN,                                            
MFA-TR*              ADDRESS_OVERFLOW,                                          
MFA-TR*              USPS_DELIV_PT_CD                                           
MFA-TR*       INTO  :DY-HOUSE-NO,                                               
MFA-TR*             :DY-ADDR-PREFIX-1,                                          
MFA-TR*             :DY-ADDR-PREFIX-2,                                          
MFA-TR*             :DY-STREET-NAME,                                            
MFA-TR*             :DY-STREET-SUFFIX,                                          
MFA-TR*             :DY-STREET-LOCATION-1,                                      
MFA-TR*             :DY-STREET-LOCATION-2,                                      
MFA-TR*             :DY-ADDR-SUFFIX,                                            
MFA-TR*             :DY-ZIP-CODE,                                               
MFA-TR*             :DY-ZIP-CODE-PLUS-FOUR,                                     
MFA-TR*             :DY-ZIP-CODE-TOKEN,                                         
MFA-TR*             :DY-ADDRESS-OVERFLOW,                                       
MFA-TR*             :DY-USPS-DELIV-PT-CD                                        
MFA-TR*       FROM CSS_ADDR_FORMATTED                                           
MFA-TR*       WHERE ADDRESS_ID = :DY-ADDRESS-ID                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME TO ABEND-PROGRAM                   
                   MOVE '7200'     TO ACTIVE-PARAGRAPH                  
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS-ID'    TO TABLE-ELEMENT-1              
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-2              
                   MOVE DY-ADDRESS-ID   TO HOSTVAR-ELEMENT-1            
                   MOVE LINK-CUSTOMER-NO TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-TOKEN.                                                  
                                                                        
           MOVE LINK-FMT-TOWN TO A4-TOWN.                               
           MOVE LINK-FMT-STATE TO A4-STATE.                             
           MOVE LINK-FMT-ZIP-CODE TO A4-ZIP-CODE.                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ZIP_CODE_TOKEN                                    
                 INTO :A4-ZIP-CODE-TOKEN                                
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE TOWN = :A4-TOWN                                   
                  AND STATE = :A4-STATE                                 
                  AND ZIP_CODE = :A4-ZIP-CODE                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ZIP_CODE_TOKEN                                            
MFA-TR*          INTO :A4-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE TOWN = :A4-TOWN                                           
MFA-TR*           AND STATE = :A4-STATE                                         
MFA-TR*           AND ZIP_CODE = :A4-ZIP-CODE                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE '1' TO A4-ZIP-CODE-TOKEN                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-1                 
                   MOVE 'TOWN'               TO TABLE-ELEMENT-1         
                   MOVE A4-TOWN              TO HOSTVAR-ELEMENT-1       
                   MOVE 'STATE'              TO TABLE-ELEMENT-2         
                   MOVE A4-STATE             TO HOSTVAR-ELEMENT-2       
                   MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-2         
                   MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-2       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-INSERT-ADDR-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_ADDR_XREF                            
                    (CUSTOMER_NO,                                       
                     ADDRESS_TYPE,                                      
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT)                                    
              VALUES                                                    
                   (:DM-CUSTOMER-NO,                                    
                    :DM-ADDRESS-TYPE,                                   
                    :DM-ADDRESS-ID,                                     
                    :DM-ADDRESS-FORMAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_ADDR_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'ADDRESS_TYPE'       TO TABLE-ELEMENT-2              
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
              MOVE 'ADDRESS_FORMAT'     TO TABLE-ELEMENT-4              
              MOVE DM-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE DM-ADDRESS-TYPE      TO HOSTVAR-ELEMENT-2            
              MOVE DM-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
              MOVE DM-ADDRESS-FORMAT    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-DELETE-ADDR-XREF.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_ADDR_XREF                            
              WHERE CUSTOMER_NO  = :DM-CUSTOMER-NO                      
                AND ADDRESS_TYPE = 'M'                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_ADDR_XREF                                    
MFA-TR*       WHERE CUSTOMER_NO  = :DM-CUSTOMER-NO                              
MFA-TR*         AND ADDRESS_TYPE = 'M'                                          
MFA-TR*       QUERYNO 8400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME TO ABEND-PROGRAM                   
                   MOVE '8400' TO ACTIVE-PARAGRAPH                      
                   MOVE 'DELETE' TO ABEND-FUNCTION                      
                   MOVE 'CSS_CUST_ADDR_XREF' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE 'ADDRESS_TYPE' TO TABLE-ELEMENT-2               
                   MOVE DM-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
                   MOVE 'M' TO HOSTVAR-ELEMENT-2                        
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-INSERT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FREEFORM                             
                    (ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW)                                  
              VALUES                                                    
                   (:DZ-ADDRESS-ID,                                     
                    :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDR-COUNTRY,                                   
                    :DZ-ADDRESS-OVERFLOW)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8500'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ADDR_CITY_STATE'    TO TABLE-ELEMENT-2              
              MOVE 'ADDR_ZIP_CODE'      TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DZ-ADDR-CITY-STATE   TO HOSTVAR-ELEMENT-2            
              MOVE DZ-ADDR-ZIP-CODE     TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-UPDATE-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FREEFORM                                  
              SET    ADDR_STREET        = :DZ-ADDR-STREET,              
                     ADDR_CITY_STATE    = :DZ-ADDR-CITY-STATE,          
                     ADDR_ZIP_CODE      = :DZ-ADDR-ZIP-CODE,            
                     ADDRESS_OVERFLOW   = :DZ-ADDRESS-OVERFLOW          
              WHERE  ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FREEFORM                                          
MFA-TR*       SET    ADDR_STREET        = :DZ-ADDR-STREET,                      
MFA-TR*              ADDR_CITY_STATE    = :DZ-ADDR-CITY-STATE,                  
MFA-TR*              ADDR_ZIP_CODE      = :DZ-ADDR-ZIP-CODE,                    
MFA-TR*              ADDRESS_OVERFLOW   = :DZ-ADDRESS-OVERFLOW                  
MFA-TR*       WHERE  ADDRESS_ID = :DZ-ADDRESS-ID                                
MFA-TR*       QUERYNO 8600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8600'          TO ACTIVE-PARAGRAPH                  
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'ADDR_CITY_STATE'    TO TABLE-ELEMENT-2              
              MOVE 'ADDR_ZIP_CODE'      TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DZ-ADDR-CITY-STATE   TO HOSTVAR-ELEMENT-2            
              MOVE DZ-ADDR-ZIP-CODE     TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8700-INSERT-ADDR-FMT.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FORMATTED                            
                    (ADDRESS_ID,                                        
                     HOUSE_NO,                                          
                     ADDR_PREFIX_1,                                     
                     ADDR_PREFIX_2,                                     
                     STREET_NAME,                                       
                     STREET_SUFFIX,                                     
                     STREET_LOCATION_1,                                 
                     STREET_LOCATION_2,                                 
                     ADDRESS_OVERFLOW,                                  
                     ZIP_CODE,                                          
                     ZIP_CODE_PLUS_FOUR,                                
                     ZIP_CODE_TOKEN,                                    
                     ADDR_SUFFIX,                                       
                     CARRIER_ROUTE,                                     
                     ADDR_USAGE_CD,                                     
                     USPS_DELIV_PT_CD)                                  
              VALUES                                                    
                    (:DY-ADDRESS-ID,                                    
                     :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-1,                                 
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-SUFFIX,                                 
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-ADDRESS-OVERFLOW,                              
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :DY-ZIP-CODE-TOKEN,                                
                     :DY-ADDR-SUFFIX,                                   
                     '     ',                                           
                     'F',                                               
                     :DY-USPS-DELIV-PT-CD)                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8800'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'STREET_NAME'        TO TABLE-ELEMENT-2              
              MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-3              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DY-STREET-NAME       TO HOSTVAR-ELEMENT-2            
              MOVE DY-ZIP-CODE          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-UPDATE-ADDR-FMT.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FORMATTED                                 
              SET    HOUSE_NO           = :DY-HOUSE-NO,                 
                     ADDR_PREFIX_1      = :DY-ADDR-PREFIX-1,            
                     ADDR_PREFIX_2      = :DY-ADDR-PREFIX-2,            
                     STREET_NAME        = :DY-STREET-NAME,              
                     STREET_SUFFIX      = :DY-STREET-SUFFIX,            
                     STREET_LOCATION_1  = :DY-STREET-LOCATION-1,        
                     STREET_LOCATION_2  = :DY-STREET-LOCATION-2,        
                     ADDR_SUFFIX        = :DY-ADDR-SUFFIX,              
                     ZIP_CODE           = :DY-ZIP-CODE,                 
                     ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,       
                     ZIP_CODE_TOKEN     = :DY-ZIP-CODE-TOKEN,           
                     ADDRESS_OVERFLOW   = :DY-ADDRESS-OVERFLOW,         
                     USPS_DELIV_PT_CD   = :DY-USPS-DELIV-PT-CD          
              WHERE  ADDRESS_ID = :DY-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ADDR_FORMATTED                                         
MFA-TR*       SET    HOUSE_NO           = :DY-HOUSE-NO,                         
MFA-TR*              ADDR_PREFIX_1      = :DY-ADDR-PREFIX-1,                    
MFA-TR*              ADDR_PREFIX_2      = :DY-ADDR-PREFIX-2,                    
MFA-TR*              STREET_NAME        = :DY-STREET-NAME,                      
MFA-TR*              STREET_SUFFIX      = :DY-STREET-SUFFIX,                    
MFA-TR*              STREET_LOCATION_1  = :DY-STREET-LOCATION-1,                
MFA-TR*              STREET_LOCATION_2  = :DY-STREET-LOCATION-2,                
MFA-TR*              ADDR_SUFFIX        = :DY-ADDR-SUFFIX,                      
MFA-TR*              ZIP_CODE           = :DY-ZIP-CODE,                         
MFA-TR*              ZIP_CODE_PLUS_FOUR = :DY-ZIP-CODE-PLUS-FOUR,               
MFA-TR*              ZIP_CODE_TOKEN     = :DY-ZIP-CODE-TOKEN,                   
MFA-TR*              ADDRESS_OVERFLOW   = :DY-ADDRESS-OVERFLOW,                 
MFA-TR*              USPS_DELIV_PT_CD   = :DY-USPS-DELIV-PT-CD                  
MFA-TR*       WHERE  ADDRESS_ID = :DY-ADDRESS-ID                                
MFA-TR*       QUERYNO 8800                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8800'          TO ACTIVE-PARAGRAPH                  
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE 'HOUSE_NO'           TO TABLE-ELEMENT-2              
              MOVE 'STREET_NAME'        TO TABLE-ELEMENT-3              
              MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-4              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              MOVE DY-HOUSE-NO          TO HOSTVAR-ELEMENT-2            
              MOVE DY-STREET-NAME       TO HOSTVAR-ELEMENT-3            
              MOVE DY-ZIP-CODE          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD00331                                                
           END-EXEC.                                                            
