       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04490.                                          
COB303 DATE-WRITTEN. NOVEMBER 12, 2013.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DISPLAYS RELATED ACCOUNTS DATA.                  *        
      *  STATUS CODE VALUES:                                           *        
      *     1.  MISSING SEARCH METHOD OR CRITERIA                      *        
      *     2.  NO DATA RETURNED / +100 RETURN CODE                    *        
      *     3.  ACCOUNT COUNT > DELINQUENCY CUTOFF; DISPLAY MESSAGE    *        
      *  RESULTS SETS:                                                 *        
      *     1.  SUMMARY INFORMATION                                    *        
      *     2.  DETAILED ACCOUNT DATA                                  *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/12/13    FMB      NEW PROGRAM.                                      
P00740*  09/30/15    FMB      ADD BANKRUPTCY IND.                               
A05317*  04/05/16    FMB      INCLUDE TOTAL_AR_BALANCE IN WO BALANCE            
A05317*                       CALCULATION.                                      
A05317*  06/26/16    FMB      ADD BANK DRAFT INDICATOR TO RS.                   
A05317*  08/09/16    FMB      ADD CUSTOMER AND PREMISE NUMBERS TO RS.           
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04490'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04490 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBHACCT                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDEPREQ                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDEPHST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCRHIST                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBSTYBND                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBGTNTR                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBREGPRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMKTIER                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTIACTP                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
           COPY CCA00001.                                                       
           COPY CWS0068L.                                                       
A05317     COPY CWS00056.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00068                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CWS00308                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04490_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04490_R2'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE 0.           
               10 S-ACCOUNT-TYPE-1    PIC X(01) VALUE SPACES.           
               10 S-ACCOUNT-CT        PIC S9(4) COMP VALUE 0.           
               10 S-FULL-BAL-TOT      PIC S9(11)V99 VALUE 0 COMP-3.     
               10 S-PAST-DUE-TOT      PIC S9(11)V99 VALUE 0 COMP-3.     
               10 S-SECURITY-TOT      PIC S9(11)V99 VALUE 0 COMP-3.     
           05  GTT-RETURN-FIELDS-2.                                     
               10 S-RETURN-CODE-2     PIC S9(9) COMP VALUE 0.           
               10 S-ACCT-STATUS       PIC X(01) VALUE SPACES.           
               10 S-COMPANY-NO        PIC X(02) VALUE SPACES.           
               10 S-ACCOUNT-TYPE-2    PIC X(01) VALUE SPACES.           
               10 S-CREDIT-GROUP      PIC X(01) VALUE SPACES.           
               10 S-ACCOUNT-NO        PIC S9(13)V VALUE 0 COMP-3.       
               10 S-SERVICE-ADDR      PIC X(80) VALUE SPACES.           
               10 S-ACCOUNT-BALANCE   PIC S9(11)V99 VALUE 0 COMP-3.     
               10 S-PAST-DUE          PIC S9(11)V99 VALUE 0 COMP-3.     
               10 S-SECURITY          PIC S9(11)V99 VALUE 0 COMP-3.     
               10 S-LAST-PYMT-DT      PIC X(10) VALUE SPACES.           
               10 S-GAS-RATE          PIC X(03) VALUE SPACES.           
               10 S-ELEC-RATE         PIC X(03) VALUE SPACES.           
               10 S-LIGHT-RATE        PIC X(03) VALUE SPACES.           
               10 S-SUB-LIGHT-RATE    PIC X(03) VALUE SPACES.           
               10 S-ARREARS-HIST      PIC X(24) VALUE SPACES.           
               10 S-DISC-HIST         PIC X(24) VALUE SPACES.           
               10 S-DISC-EXCEP-HIST   PIC X(24) VALUE SPACES.           
               10 S-NU-ARREARS-HIST   PIC X(24) VALUE SPACES.           
               10 S-NU-DISC-HIST      PIC X(24) VALUE SPACES.           
               10 S-NU-DISC-EXCEP-HIST PIC X(24) VALUE SPACES.          
               10 S-CREATE-DT         PIC X(10) VALUE SPACES.           
               10 S-FINAL-DT          PIC X(10) VALUE SPACES.           
               10 S-LAST-BILL-DT      PIC X(10) VALUE SPACES.           
               10 S-RET-CHECK-CT-12   PIC S9(9) COMP VALUE 0.           
               10 S-RET-CHECK-CT-24   PIC S9(9) COMP VALUE 0.           
               10 S-DIVISION          PIC X(05) VALUE SPACES.           
               10 S-ACCT-SUB-TYPE     PIC X(30) VALUE SPACES.           
               10 S-MIN-DEPOSIT       PIC S9(9)V99 VALUE 0 COMP-3.      
               10 S-MAX-DEPOSIT       PIC S9(9)V99 VALUE 0 COMP-3.      
               10 S-WAIVER-FL         PIC X(01) VALUE SPACES.           
P00740         10 S-BANKRUPTCY-IND    PIC X(01) VALUE SPACES.           
A05317         10 S-BANK-DRAFT-FL     PIC X(01) VALUE SPACES.           
A05317         10 S-CUSTOMER-NO       PIC S9(10)V COMP-3 VALUE 0.       
A05317         10 S-PREMISE-NO        PIC S9(10)V COMP-3 VALUE 0.       
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-TABLES.                                                   
           05 T1-SUMMARY          OCCURS 10                             
                                      INDEXED BY T1-INDEX.              
               10 T1-ACCOUNT-TYPE     PIC X(01) VALUE SPACES.           
               10 T1-ACCT-CT          PIC S9(4) COMP VALUE 0.           
               10 T1-FULL-BAL-TOT     PIC S9(11)V99 VALUE 0 COMP-3.     
               10 T1-PAST-DUE-TOT     PIC S9(11)V99 VALUE 0 COMP-3.     
               10 T1-SECURITY-TOT     PIC S9(11)V99 VALUE 0 COMP-3.     
                                                                        
       01  WS-MISC.                                                     
           05  PARM-SEARCH-METHOD       PIC X(3).                       
               88  SEL-METH-CUS         VALUE 'CUS'.                    
               88  SEL-METH-PRE         VALUE 'PRE'.                    
               88  SEL-METH-GRP         VALUE 'GRP'.                    
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04490'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-NULL-1                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-2                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-3                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-4                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-5                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-6                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-7                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-8                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-9                PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-10               PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-11               PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-12               PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-13               PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-14               PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-FULL-BAL         PIC S9(4) COMP VALUE +0.        
           05  WS-DATE-BILL-00-IND      PIC S9(04) COMP VALUE +0.       
           05  WS-DATE-BILL-30-IND      PIC S9(04) COMP VALUE +0.       
           05  WS-DATE-BILL-60-IND      PIC S9(04) COMP VALUE +0.       
           05  WS-DATE-BILL-90-IND      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-PYMT-DATE        PIC S9(04) COMP VALUE +0.       
           05  WS-CODE-ACCT-USAGE-IND   PIC S9(04) COMP VALUE +0.       
           05  WS-FINAL-NULL-IND        PIC S9(04) COMP VALUE +0.       
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-UNMTR-FOUND           PIC X(01) VALUE 'N'.            
           05  WS-TOTAL-CT              PIC S9(9)   COMP VALUE 0.       
           05  WS-ACCOUNT-CT            PIC S9(9)   COMP VALUE 0.       
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88  CSR-DATABASE                   VALUE 1.              
               88  SEB-DATABASE                   VALUE 2.              
           05  SW-FETCH                 PIC X(01) VALUE 'Y'.            
               88 NO-MORE-ROWS                    VALUE 'N'.            
               88 MORE-ROWS                       VALUE 'Y'.            
           05  MULTIPLE-ROWS            PIC S9(04) COMP VALUE -811.     
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-ITERATION-STORAGE.                                    
               10 WS-ARCHIVE-IND        PIC X(01) VALUE SPACES.         
               10 WS-GAS-RATE           PIC X(03) VALUE SPACES.         
               10 WS-ELEC-RATE          PIC X(03) VALUE SPACES.         
               10 WS-LIGHT-RATE         PIC X(03) VALUE SPACES.         
               10 WS-SUB-LIGHT-RATE     PIC X(03) VALUE SPACES.         
               10 WS-ADDRESS-LINE       PIC X(80) VALUE SPACES.         
               10 WS-ADDRESS-LINE-I     PIC X(80) VALUE SPACES.         
               10 WS-FULL-BALANCE-A     PIC S9(11)V99 VALUE 0 COMP-3.   
               10 WS-FULL-BALANCE-B     PIC S9(11)V99 VALUE 0 COMP-3.   
               10 WS-SECURITY-TOTAL     PIC S9(11)V99 VALUE 0 COMP-3.   
               10 WS-RET-CHECK-CT-12    PIC S9(09) COMP VALUE 0.        
               10 WS-RET-CHECK-CT-24    PIC S9(09) COMP VALUE 0.        
               10 WS-BILL-MINUS-12-MONTHS PIC X(10) VALUE SPACES.       
               10 WS-BILL-MINUS-24-MONTHS PIC X(10) VALUE SPACES.       
               10 WS-WAIVER-FL          PIC X(01) VALUE SPACES.         
               10 WS-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE 0.     
               10 RS-MIN-DEPOSIT-AMT    PIC S9(11)V99 COMP-3 VALUE 0.   
               10 RS-MAX-DEPOSIT-AMT    PIC S9(11)V99 COMP-3 VALUE 0.   
                                                                        
       01  DYNAMIC-CALLS.                                               
           05  WS-MCSCB068             PIC X(08) VALUE 'MCSCB068'.      
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL DECLARE CU-CURSOR CURSOR FOR                        
               SELECT HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN CODE_ACCT_STAT = 'R' THEN               
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                  
                  AND HT.CUSTOMER_ROLE_CD = '  '                        
                  AND HT.ACCOUNT_NO > 0                                 
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CU-CURSOR CURSOR FOR                                
MFA-TR*        SELECT HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN CODE_ACCT_STAT = 'R' THEN                       
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.CUSTOMER_NO = :HT-CUSTOMER-NO                          
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = '  '                                
MFA-TR*           AND HT.ACCOUNT_NO > 0                                         
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE PR-CURSOR CURSOR FOR                        
               SELECT HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN CODE_ACCT_STAT = 'R' THEN               
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE HT.PREMISE_NO = :HT-PREMISE-NO                    
                  AND HT.CUSTOMER_ROLE_CD = '  '                        
                  AND HT.ACCOUNT_NO > 0                                 
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE PR-CURSOR CURSOR FOR                                
MFA-TR*        SELECT HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN CODE_ACCT_STAT = 'R' THEN                       
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE HT.PREMISE_NO = :HT-PREMISE-NO                            
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = '  '                                
MFA-TR*           AND HT.ACCOUNT_NO > 0                                         
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7105                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE TA-CURSOR CURSOR FOR                        
               SELECT HT.ACCOUNT_NO,                                    
                      HT.PREMISE_NO,                                    
                      HT.ADDRESS_ID,                                    
                      HT.COMPANY_NO,                                    
                      HT.ACCOUNT_TYPE_CODE,                             
                      HT.CODE_ACCT_STAT,                                
                      CASE WHEN CODE_ACCT_STAT = 'R' THEN               
                            'Y' ELSE 'N' END                            
                 FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_ACCT_MISC_INFO TA WITH(READUNCOMMITTED)               
                WHERE TA.GROUP_ID = :TA-GROUP-ID                        
                  AND TA.ACCOUNT_NO = HT.ACCOUNT_NO                     
                  AND HT.CUSTOMER_ROLE_CD = '  '                        
                  AND HT.ACCOUNT_NO > 0                                 
                  AND HT.NAME_ID = DQ.NAME_ID                           
                  AND DQ.NAME_TYPE = 'CN'                               
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE TA-CURSOR CURSOR FOR                                
MFA-TR*        SELECT HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               HT.ACCOUNT_TYPE_CODE,                                     
MFA-TR*               HT.CODE_ACCT_STAT,                                        
MFA-TR*               CASE WHEN CODE_ACCT_STAT = 'R' THEN                       
MFA-TR*                     'Y' ELSE 'N' END                                    
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_ACCT_MISC_INFO TA                                     
MFA-TR*         WHERE TA.GROUP_ID = :TA-GROUP-ID                                
MFA-TR*           AND TA.ACCOUNT_NO = HT.ACCOUNT_NO                             
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = '  '                                
MFA-TR*           AND HT.ACCOUNT_NO > 0                                         
MFA-TR*           AND HT.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7115                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE UT-CURSOR CURSOR FOR                        
               SELECT CODE_UTIL_TYPE, MIN(RATE_PLAN_NO)                 
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
             GROUP BY CODE_UTIL_TYPE                                    
               HAVING CODE_UTIL_TYPE IN ('E','G','U')                   
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UT-CURSOR CURSOR FOR                                
MFA-TR*        SELECT CODE_UTIL_TYPE, MIN(RATE_PLAN_NO)                         
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*      GROUP BY CODE_UTIL_TYPE                                            
MFA-TR*        HAVING CODE_UTIL_TYPE IN ('E','G','U')                           
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT RETURN_CODE         AS RETURN_CODE,               
                      STATUS_CODE         AS STATUS_CODE,               
                      ACCT_TYPE           AS ACCOUNT_TYPE,              
                      ACCT_CT             AS ACCOUNT_COUNT,             
                      FULL_BAL_TOT        AS FULL_BAL_TOTAL,            
                      PAST_DUE_TOT        AS PAST_DUE_TOTAL,            
                      SECURITY_TOT        AS SECURITY_TOTAL             
                FROM #CSR04490_R1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               STATUS_CODE         AS STATUS_CODE,                       
MFA-TR*               ACCT_TYPE           AS ACCOUNT_TYPE,                      
MFA-TR*               ACCT_CT             AS ACCOUNT_COUNT,                     
MFA-TR*               FULL_BAL_TOT        AS FULL_BAL_TOTAL,                    
MFA-TR*               PAST_DUE_TOT        AS PAST_DUE_TOTAL,                    
MFA-TR*               SECURITY_TOT        AS SECURITY_TOTAL                     
MFA-TR*         FROM SESSION.CSR04490_R1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1    AS RETURN_CODE,               
                      :S-STATUS-CODE      AS STATUS_CODE,               
                      :S-ACCOUNT-TYPE-1   AS ACCOUNT_TYPE,              
                      :S-ACCOUNT-CT       AS ACCOUNT_COUNT,             
                      :S-FULL-BAL-TOT     AS FULL_BAL_TOTAL,            
                      :S-PAST-DUE-TOT     AS PAST_DUE_TOTAL,            
                      :S-SECURITY-TOT     AS SECURITY_TOTAL             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1    AS RETURN_CODE,                       
MFA-TR*               :S-STATUS-CODE      AS STATUS_CODE,                       
MFA-TR*               :S-ACCOUNT-TYPE-1   AS ACCOUNT_TYPE,                      
MFA-TR*               :S-ACCOUNT-CT       AS ACCOUNT_COUNT,                     
MFA-TR*               :S-FULL-BAL-TOT     AS FULL_BAL_TOTAL,                    
MFA-TR*               :S-PAST-DUE-TOT     AS PAST_DUE_TOTAL,                    
MFA-TR*               :S-SECURITY-TOT     AS SECURITY_TOTAL                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE       AS RETURN_CODE,                 
                      ACCOUNT_STATUS    AS ACCOUNT_STATUS,              
                      COMPANY_NO        AS COMPANY_NO,                  
                      ACCOUNT_TYPE      AS ACCOUNT_TYPE,                
                      CREDIT_GROUP      AS CREDIT_GROUP,                
                      ACCOUNT_NO        AS ACCOUNT_NO,                  
                      SERVICE_ADDR      AS SERVICE_ADDRESS,             
                      ACCT_BALANCE      AS ACCOUNT_BALANCE,             
                      PAST_DUE_AMT      AS PAST_DUE_AMT,                
                      SECURITY_AMT      AS SECURITY_AMT,                
                      LAST_PYMT_DT      AS LAST_PYMT_DT,                
                      GAS_RATE          AS GAS_RATE,                    
                      ELEC_RATE         AS ELEC_RATE,                   
                      LIGHT_RATE        AS LIGHT_RATE,                  
                      SUB_LIGHT_RATE    AS SUB_LIGHT_RATE,              
                      ARREARS_HIST      AS ARREARS_HIST,                
                      DISC_HIST         AS DISC_HIST,                   
                      DISC_EXCEP_HIST   AS DISC_EXCEP_HIST,             
                      NU_ARREARS_HIST   AS NU_ARREARS_HIST,             
                      NU_DISC_HIST      AS NU_DISC_HIST,                
                      NU_DISC_EXCEP_HIST AS NU_DISC_EXCEP_HIST,         
                      ACCT_CREATE_DT    AS ACCT_CREATE_DT,              
                      ACCT_FINAL_DT     AS ACCT_FINAL_DT,               
                      LAST_BILL_DT      AS LAST_BILL_DT,                
                      RET_CHECK_CT_12   AS RET_CHECK_CT_12,             
                      RET_CHECK_CT_24   AS RET_CHECK_CT_24,             
                      DIVISION          AS DIVISION,                    
                      ACCT_SUB_TYPE     AS ACCT_SUB_TYPE,               
                      MIN_DEPOSIT       AS MIN_DEPOSIT,                 
                      MAX_DEPOSIT       AS MAX_DEPOSIT,                 
                      WAIVER_FL         AS WAIVER_FL,                   
P00740                BANKRUPTCY_IND    AS BANKRUPTCY_IND,              
A05317                BANK_DRAFT_FL     AS BANK_DRAFT_FL,               
A05317                CUSTOMER_NO       AS CUSTOMER_NO,                 
A05317                PREMISE_NO        AS PREMISE_NO                   
                FROM #CSR04490_R2                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE       AS RETURN_CODE,                         
MFA-TR*               ACCOUNT_STATUS    AS ACCOUNT_STATUS,                      
MFA-TR*               COMPANY_NO        AS COMPANY_NO,                          
MFA-TR*               ACCOUNT_TYPE      AS ACCOUNT_TYPE,                        
MFA-TR*               CREDIT_GROUP      AS CREDIT_GROUP,                        
MFA-TR*               ACCOUNT_NO        AS ACCOUNT_NO,                          
MFA-TR*               SERVICE_ADDR      AS SERVICE_ADDRESS,                     
MFA-TR*               ACCT_BALANCE      AS ACCOUNT_BALANCE,                     
MFA-TR*               PAST_DUE_AMT      AS PAST_DUE_AMT,                        
MFA-TR*               SECURITY_AMT      AS SECURITY_AMT,                        
MFA-TR*               LAST_PYMT_DT      AS LAST_PYMT_DT,                        
MFA-TR*               GAS_RATE          AS GAS_RATE,                            
MFA-TR*               ELEC_RATE         AS ELEC_RATE,                           
MFA-TR*               LIGHT_RATE        AS LIGHT_RATE,                          
MFA-TR*               SUB_LIGHT_RATE    AS SUB_LIGHT_RATE,                      
MFA-TR*               ARREARS_HIST      AS ARREARS_HIST,                        
MFA-TR*               DISC_HIST         AS DISC_HIST,                           
MFA-TR*               DISC_EXCEP_HIST   AS DISC_EXCEP_HIST,                     
MFA-TR*               NU_ARREARS_HIST   AS NU_ARREARS_HIST,                     
MFA-TR*               NU_DISC_HIST      AS NU_DISC_HIST,                        
MFA-TR*               NU_DISC_EXCEP_HIST AS NU_DISC_EXCEP_HIST,                 
MFA-TR*               ACCT_CREATE_DT    AS ACCT_CREATE_DT,                      
MFA-TR*               ACCT_FINAL_DT     AS ACCT_FINAL_DT,                       
MFA-TR*               LAST_BILL_DT      AS LAST_BILL_DT,                        
MFA-TR*               RET_CHECK_CT_12   AS RET_CHECK_CT_12,                     
MFA-TR*               RET_CHECK_CT_24   AS RET_CHECK_CT_24,                     
MFA-TR*               DIVISION          AS DIVISION,                            
MFA-TR*               ACCT_SUB_TYPE     AS ACCT_SUB_TYPE,                       
MFA-TR*               MIN_DEPOSIT       AS MIN_DEPOSIT,                         
MFA-TR*               MAX_DEPOSIT       AS MAX_DEPOSIT,                         
MFA-TR*               WAIVER_FL         AS WAIVER_FL,                           
MFA-TR*               BANKRUPTCY_IND    AS BANKRUPTCY_IND,                      
MFA-TR*               BANK_DRAFT_FL     AS BANK_DRAFT_FL,                       
MFA-TR*               CUSTOMER_NO       AS CUSTOMER_NO,                         
MFA-TR*               PREMISE_NO        AS PREMISE_NO                           
MFA-TR*         FROM SESSION.CSR04490_R2                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-COMPANY-NO        AS COMPANY_NO,               
                      :S-ACCOUNT-TYPE-2    AS ACCOUNT_TYPE,             
                      :S-CREDIT-GROUP      AS CREDIT_GROUP,             
                      :S-ACCOUNT-NO        AS ACCOUNT_NO,               
                      :S-SERVICE-ADDR      AS SERVICE_ADDRESS,          
                      :S-ACCOUNT-BALANCE   AS ACCOUNT_BALANCE,          
                      :S-PAST-DUE          AS PAST_DUE_AMT,             
                      :S-SECURITY          AS SECURITY_AMT,             
                      :S-LAST-PYMT-DT      AS LAST_PYMT_DT,             
                      :S-GAS-RATE          AS GAS_RATE,                 
                      :S-ELEC-RATE         AS ELEC_RATE,                
                      :S-LIGHT-RATE        AS LIGHT_RATE,               
                      :S-SUB-LIGHT-RATE    AS SUB_LIGHT_RATE,           
                      :S-ARREARS-HIST      AS ARREARS_HIST,             
                      :S-DISC-HIST         AS DISC_HIST,                
                      :S-DISC-EXCEP-HIST   AS DISC_EXCEP_HIST,          
                      :S-NU-ARREARS-HIST   AS NU_ARREARS_HIST,          
                      :S-NU-DISC-HIST      AS NU_DISC_HIST,             
                      :S-NU-DISC-EXCEP-HIST AS NU_DISC_EXCEP_HIST,      
                      :S-CREATE-DT         AS ACCT_CREATE_DT,           
                      :S-FINAL-DT          AS ACCT_FINAL_DT,            
                      :S-LAST-BILL-DT      AS LAST_BILL_DT,             
                      :S-RET-CHECK-CT-12   AS RET_CHECK_CT_12,          
                      :S-RET-CHECK-CT-24   AS RET_CHECK_CT_24,          
                      :S-DIVISION          AS DIVISION,                 
                      :S-ACCT-SUB-TYPE     AS ACCT_SUB_TYPE,            
                      :S-MIN-DEPOSIT       AS MIN_DEPOSIT,              
                      :S-MAX-DEPOSIT       AS MAX_DEPOSIT,              
                      :S-WAIVER-FL         AS WAIVER_FL,                
P00740                :S-BANKRUPTCY-IND    AS BANKRUPTCY_IND,           
A05317                :S-BANK-DRAFT-FL     AS BANK_DRAFT_FL,            
A05317                :S-CUSTOMER-NO       AS CUSTOMER_NO,              
A05317                :S-PREMISE-NO        AS PREMISE_NO                
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-COMPANY-NO        AS COMPANY_NO,                       
MFA-TR*               :S-ACCOUNT-TYPE-2    AS ACCOUNT_TYPE,                     
MFA-TR*               :S-CREDIT-GROUP      AS CREDIT_GROUP,                     
MFA-TR*               :S-ACCOUNT-NO        AS ACCOUNT_NO,                       
MFA-TR*               :S-SERVICE-ADDR      AS SERVICE_ADDRESS,                  
MFA-TR*               :S-ACCOUNT-BALANCE   AS ACCOUNT_BALANCE,                  
MFA-TR*               :S-PAST-DUE          AS PAST_DUE_AMT,                     
MFA-TR*               :S-SECURITY          AS SECURITY_AMT,                     
MFA-TR*               :S-LAST-PYMT-DT      AS LAST_PYMT_DT,                     
MFA-TR*               :S-GAS-RATE          AS GAS_RATE,                         
MFA-TR*               :S-ELEC-RATE         AS ELEC_RATE,                        
MFA-TR*               :S-LIGHT-RATE        AS LIGHT_RATE,                       
MFA-TR*               :S-SUB-LIGHT-RATE    AS SUB_LIGHT_RATE,                   
MFA-TR*               :S-ARREARS-HIST      AS ARREARS_HIST,                     
MFA-TR*               :S-DISC-HIST         AS DISC_HIST,                        
MFA-TR*               :S-DISC-EXCEP-HIST   AS DISC_EXCEP_HIST,                  
MFA-TR*               :S-NU-ARREARS-HIST   AS NU_ARREARS_HIST,                  
MFA-TR*               :S-NU-DISC-HIST      AS NU_DISC_HIST,                     
MFA-TR*               :S-NU-DISC-EXCEP-HIST AS NU_DISC_EXCEP_HIST,              
MFA-TR*               :S-CREATE-DT         AS ACCT_CREATE_DT,                   
MFA-TR*               :S-FINAL-DT          AS ACCT_FINAL_DT,                    
MFA-TR*               :S-LAST-BILL-DT      AS LAST_BILL_DT,                     
MFA-TR*               :S-RET-CHECK-CT-12   AS RET_CHECK_CT_12,                  
MFA-TR*               :S-RET-CHECK-CT-24   AS RET_CHECK_CT_24,                  
MFA-TR*               :S-DIVISION          AS DIVISION,                         
MFA-TR*               :S-ACCT-SUB-TYPE     AS ACCT_SUB_TYPE,                    
MFA-TR*               :S-MIN-DEPOSIT       AS MIN_DEPOSIT,                      
MFA-TR*               :S-MAX-DEPOSIT       AS MAX_DEPOSIT,                      
MFA-TR*               :S-WAIVER-FL         AS WAIVER_FL,                        
MFA-TR*               :S-BANKRUPTCY-IND    AS BANKRUPTCY_IND,                   
MFA-TR*               :S-BANK-DRAFT-FL     AS BANK_DRAFT_FL,                    
MFA-TR*               :S-CUSTOMER-NO       AS CUSTOMER_NO,                      
MFA-TR*               :S-PREMISE-NO        AS PREMISE_NO                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-SEARCH-METHOD      PIC X(03).                           
       01  LINK-CRITERIA           PIC X(50).                           
       01  LINK-BYPASS-ARCHIVE-FL  PIC X(01).                           
       01  LINK-OVERRIDE-FL        PIC X(01).                           
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-SEARCH-METHOD                            
                          LINK-CRITERIA                                 
                          LINK-BYPASS-ARCHIVE-FL                        
                          LINK-OVERRIDE-FL.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04490_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04490_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               ACCT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               ACCT_CT              SMALLINT,                           
               FULL_BAL_TOT         DECIMAL(11,2),                      
               PAST_DUE_TOT         DECIMAL(11,2),                      
               SECURITY_TOT         DECIMAL(11,2)                       
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04490_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04490_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04490_R2
              (                                                          
               RETURN_CODE          INT,                            
               ACCOUNT_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,            
               ACCOUNT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CREDIT_GROUP CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ACCOUNT_NO           DECIMAL(13,0),                      
               SERVICE_ADDR CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2,          
               ACCT_BALANCE         DECIMAL(11,2),                      
               PAST_DUE_AMT         DECIMAL(11,2),                      
               SECURITY_AMT         DECIMAL(11,2),                      
               LAST_PYMT_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
               GAS_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ELEC_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,             
               LIGHT_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,            
               SUB_LIGHT_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ARREARS_HIST CHAR(24)  COLLATE LATIN1_GENERAL_100_BIN2,          
               DISC_HIST CHAR(24)  COLLATE LATIN1_GENERAL_100_BIN2,             
               DISC_EXCEP_HIST CHAR(24)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               NU_ARREARS_HIST CHAR(24)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               NU_DISC_HIST CHAR(24)  COLLATE LATIN1_GENERAL_100_BIN2,          
               NU_DISC_EXCEP_HIST CHAR(24)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ACCT_CREATE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ACCT_FINAL_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
               LAST_BILL_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
               RET_CHECK_CT_12      INT,                            
               RET_CHECK_CT_24      INT,                            
               DIVISION CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ACCT_SUB_TYPE CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2,         
               MIN_DEPOSIT          DECIMAL(11,2),                      
               MAX_DEPOSIT          DECIMAL(11,2),                      
               WAIVER_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
P00740         BANKRUPTCY_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
A05317         BANK_DRAFT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
A05317         CUSTOMER_NO          DECIMAL(10,0),                      
A05317         PREMISE_NO           DECIMAL(10,0)                       
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04490_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
               END-IF
           END-IF.       
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-SEARCH-METHOD TO PARM-SEARCH-METHOD.               
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'DATABASE' TO C8-DELINQ-CD.                             
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-DATABASE.                         
                                                                        
           MOVE 'RA-ACCOUNT-CT' TO C8-DELINQ-CD.                        
           PERFORM 7005-DELINQUENCY THRU 7005-EXIT.                     
           MOVE C8-DELINQ-VALUE TO WS-ACCOUNT-CT.                       
                                                                        
           IF LINK-BYPASS-ARCHIVE-FL = 'Y' OR 'N'                       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'N' TO LINK-BYPASS-ARCHIVE-FL
           END-IF.                      
           IF LINK-OVERRIDE-FL = 'Y' OR 'N'                             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'N' TO LINK-OVERRIDE-FL
           END-IF.                            
                                                                        
           EVALUATE TRUE                                                
               WHEN SEL-METH-CUS                                        
                   MOVE LINK-CRITERIA(1:10) TO WS-CUSTOMER-NO-CHAR      
                   MOVE WS-CUSTOMER-NO-NUM TO HT-CUSTOMER-NO            
               WHEN SEL-METH-PRE                                        
                   MOVE LINK-CRITERIA(1:10) TO WS-PREMISE-NO-CHAR       
                   MOVE WS-PREMISE-NO-NUM TO HT-PREMISE-NO              
               WHEN SEL-METH-GRP                                        
                   MOVE LINK-CRITERIA(1:25) TO TA-GROUP-ID              
           END-EVALUATE.                                                
                                                                        
           MOVE 'A' TO T1-ACCOUNT-TYPE (1).                             
           MOVE 'B' TO T1-ACCOUNT-TYPE (2).                             
           MOVE 'S' TO T1-ACCOUNT-TYPE (3).                             
           MOVE 'P' TO T1-ACCOUNT-TYPE (4).                             
           MOVE 'J' TO T1-ACCOUNT-TYPE (5).                             
           MOVE 'R' TO T1-ACCOUNT-TYPE (6).                             
           MOVE 'T' TO T1-ACCOUNT-TYPE (7).                             
                                                                        
           IF LINK-SEARCH-METHOD = SPACES OR                            
              LINK-CRITERIA = SPACES                                    
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                  MOVE +001 TO S-STATUS-CODE                            
                  PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT             
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
                  PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT             
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE TRUE                                                
               WHEN SEL-METH-CUS                                        
                   PERFORM 2010-SEL-METH-CUS THRU 2010-EXIT             
               WHEN SEL-METH-PRE                                        
                   PERFORM 2015-SEL-METH-PRE THRU 2015-EXIT             
               WHEN SEL-METH-GRP                                        
                   PERFORM 2020-SEL-METH-GRP THRU 2020-EXIT             
           END-EVALUATE.                                                
                                                                        
           PERFORM 2100-BUILD-RESULTS-1 THRU 2100-EXIT.                 
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE +100 TO S-RETURN-CODE-1                              
              MOVE +002 TO S-STATUS-CODE                                
              PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                 
              PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                 
              PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                 
              PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-SEL-METH-CUS.                                               
                                                                        
           IF LINK-OVERRIDE-FL = 'N'                                    
               PERFORM 7600-COUNT-ACCT-CUST THRU 7600-EXIT              
               IF WS-TOTAL-CT > WS-ACCOUNT-CT                           
                   GO TO 2010-EXIT
               END-IF
           END-IF.                                     
                                                                        
           PERFORM 7100-OPEN-CU-CURSOR THRU 7100-EXIT.                  
           PERFORM 7101-FETCH-CU-CURSOR THRU 7101-EXIT.                 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 2050-PROCESS-ROW THRU 2050-EXIT                  
               PERFORM 7101-FETCH-CU-CURSOR THRU 7101-EXIT              
           END-PERFORM.                                                 
           PERFORM 7102-CLOSE-CU-CURSOR THRU 7102-EXIT.                 
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2015-SEL-METH-PRE.                                               
                                                                        
           IF LINK-OVERRIDE-FL = 'N'                                    
               PERFORM 7630-COUNT-ACCT-PREM THRU 7630-EXIT              
               IF WS-TOTAL-CT > WS-ACCOUNT-CT                           
                   GO TO 2015-EXIT
               END-IF
           END-IF.                                     
                                                                        
           PERFORM 7105-OPEN-PR-CURSOR THRU 7105-EXIT.                  
           PERFORM 7106-FETCH-PR-CURSOR THRU 7106-EXIT.                 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 2050-PROCESS-ROW THRU 2050-EXIT                  
               PERFORM 7106-FETCH-PR-CURSOR THRU 7106-EXIT              
           END-PERFORM.                                                 
           PERFORM 7107-CLOSE-PR-CURSOR THRU 7107-EXIT.                 
                                                                        
       2015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2020-SEL-METH-GRP.                                               
                                                                        
           IF LINK-OVERRIDE-FL = 'N'                                    
               PERFORM 7640-COUNT-ACCT-GRP THRU 7640-EXIT               
               IF WS-TOTAL-CT > WS-ACCOUNT-CT                           
                   GO TO 2020-EXIT
               END-IF
           END-IF.                                     
                                                                        
           PERFORM 7115-OPEN-TA-CURSOR THRU 7115-EXIT.                  
           PERFORM 7116-FETCH-TA-CURSOR THRU 7116-EXIT.                 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 2050-PROCESS-ROW THRU 2050-EXIT                  
               PERFORM 7116-FETCH-TA-CURSOR THRU 7116-EXIT              
           END-PERFORM.                                                 
           PERFORM 7117-CLOSE-TA-CURSOR THRU 7117-EXIT.                 
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2050-PROCESS-ROW.                                                
                                                                        
           IF WS-ARCHIVE-IND = 'Y' AND                                  
              LINK-BYPASS-ARCHIVE-FL = 'N'                              
                  PERFORM 2700-ARCHIVED-ACCOUNTS THRU 2700-EXIT
           END-IF.        
                                                                        
           IF WS-ARCHIVE-IND = 'N'                                      
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT               
               PERFORM 7350-SERVICE-ADDRESS THRU 7350-EXIT              
               PERFORM 3000-UTILITY-PROCESSING THRU 3000-EXIT           
               PERFORM 7250-SELECT-CRED-PROF THRU 7250-EXIT             
               PERFORM 7300-GET-FULL-BALANCE-A THRU 7300-EXIT           
               PERFORM 7310-GET-FULL-BALANCE-B THRU 7310-EXIT           
               INITIALIZE GTT-RETURN-FIELDS-2                           
               MOVE HT-COMPANY-NO TO S-COMPANY-NO                       
               MOVE HT-ACCOUNT-NO TO S-ACCOUNT-NO                       
               MOVE AT-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-2            
               MOVE AT-CREDIT-GROUP TO S-CREDIT-GROUP                   
               MOVE AT-ACCT-CREATE-DT(1:10) TO S-CREATE-DT              
               MOVE AT-ACCT-FINALED-DT(1:10) TO S-FINAL-DT              
               MOVE AT-LAST-PYMT-DATE TO S-LAST-PYMT-DT                 
               MOVE AT-DATE-BILL-DAY-00 TO S-LAST-BILL-DT               
               IF AT-DATE-BILL-DAY-00 > ' '                             
                   PERFORM 7065-SELECT-NSF-HIST THRU 7065-EXIT          
                   MOVE WS-RET-CHECK-CT-12 TO S-RET-CHECK-CT-12         
                   MOVE WS-RET-CHECK-CT-24 TO S-RET-CHECK-CT-24         
               END-IF                                                   
P00740         MOVE AT-BANKRUPTCY-IND TO S-BANKRUPTCY-IND               
A05317         IF WS-CODE-BANK-EFT = 'A'                                
A05317             MOVE 'Y' TO S-BANK-DRAFT-FL                          
A05317         END-IF                                                   
A05317         MOVE AT-CUSTOMER-NO TO S-CUSTOMER-NO                     
A05317         MOVE AT-PREMISE-NO TO S-PREMISE-NO                       
               IF DY-ADDR-USAGE-CD = 'I'                                
                   MOVE WS-ADDRESS-LINE-I TO S-SERVICE-ADDR             
               ELSE                                                     
                   MOVE WS-ADDRESS-LINE TO S-SERVICE-ADDR               
               END-IF                                                   
               MOVE WS-ELEC-RATE TO S-ELEC-RATE                         
               MOVE WS-GAS-RATE TO S-GAS-RATE                           
               MOVE WS-LIGHT-RATE TO S-LIGHT-RATE                       
               MOVE WS-SUB-LIGHT-RATE TO S-SUB-LIGHT-RATE               
               MOVE CZ-ARREARS-HIST TO S-ARREARS-HIST                   
               MOVE CZ-DISCONNECT-HIST TO S-DISC-HIST                   
               MOVE CZ-DISC-EXCEPTN-HIST TO S-DISC-EXCEP-HIST           
               MOVE CZ-NON-UTL-ARRER-HIST TO S-NU-ARREARS-HIST          
               MOVE CZ-NON-UTL-CR-HST-EX TO S-NU-DISC-EXCEP-HIST        
               MOVE CZ-NON-UTL-CR-HST TO S-NU-DISC-HIST                 
               IF SEB-DATABASE                                          
                   PERFORM 7610-REG-PROFILE THRU 7610-EXIT              
                   PERFORM 7620-SELECT-MKT-TIER THRU 7620-EXIT          
                   MOVE TT-TIER-ACCT-DESC-LNG TO S-ACCT-SUB-TYPE        
               END-IF                                                   
               EVALUATE AT-CODE-ACCT-STAT                               
                   WHEN 'A'                                             
                       PERFORM 2200-ACTIVE-ACCOUNTS THRU 2200-EXIT      
                   WHEN 'B'                                             
                       PERFORM 2300-FB-ACCOUNTS THRU 2300-EXIT          
                   WHEN 'S'                                             
                       PERFORM 2400-WO-ACCOUNTS THRU 2400-EXIT          
                   WHEN 'P'                                             
                       PERFORM 2500-PENDING-ACCOUNTS THRU 2500-EXIT     
                   WHEN 'J'                                             
                       PERFORM 2600-INACTIVE-ACCOUNTS THRU 2600-EXIT    
               END-EVALUATE                                             
               IF WS-GTT02-DECLARED = 'N'                               
                   PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT            
               END-IF                                                   
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT
           END-IF.               
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  SUMMARY DATA                                                           
                                                                        
       2100-BUILD-RESULTS-1.                                            
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1                         
               UNTIL T1-ACCOUNT-TYPE (T1-INDEX) <= SPACES               
                   INITIALIZE GTT-RETURN-FIELDS-1                       
                   MOVE T1-ACCOUNT-TYPE (T1-INDEX) TO S-ACCOUNT-TYPE-1  
                   MOVE T1-ACCT-CT (T1-INDEX) TO S-ACCOUNT-CT           
                   MOVE T1-FULL-BAL-TOT (T1-INDEX) TO S-FULL-BAL-TOT    
                   MOVE T1-PAST-DUE-TOT (T1-INDEX) TO S-PAST-DUE-TOT    
                   MOVE T1-SECURITY-TOT (T1-INDEX) TO S-SECURITY-TOT    
                   IF WS-TOTAL-CT > WS-ACCOUNT-CT AND                   
                      LINK-OVERRIDE-FL = 'N'                            
                          MOVE +003 TO S-STATUS-CODE                    
                   END-IF                                               
                   IF WS-GTT01-DECLARED = 'N'                           
                       PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT        
                   END-IF                                               
                   PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT            
           END-PERFORM.                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-CPD00068-CALL.                                              
                                                                        
           MOVE 'Y' TO CALC-ARREARS-SW.                                 
           MOVE 'N' TO CALC-PAST-DUE-SW                                 
                       LOAD-DNP-DATE-SW                                 
                       LOAD-DUE-DATES-SW                                
                       LOAD-WS-AMOUNTS-SW                               
                       CALC-BALANCE-SW.                                 
           MOVE 'CSR02023' TO WS-CPD00068-CALLING-PGM.                  
           PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT.                   
           IF ABEND-FUNCTION > SPACES                                   
               IF ABEND-FUNCTION = 'BADDATA'                            
                   MOVE 100 TO S-RETURN-CODE-1                          
                   MOVE -1 TO S-STATUS-CODE                             
                              WS-ACTIVE-RETURN-CODE                     
               END-IF                                                   
               MOVE PROGRAM-NAME TO ABEND-PROGRAM                       
               MOVE '2200' TO ACTIVE-PARAGRAPH                          
               MOVE 'CALL' TO ABEND-FUNCTION                            
               MOVE 'MCSCB068' TO TABLE-1                               
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  ACTIVE ACCOUNTS                                                        
                                                                        
       2200-ACTIVE-ACCOUNTS.                                            
                                                                        
           ADD +1 TO T1-ACCT-CT (1)                                     
                     T1-ACCT-CT (7).                                    
           MOVE 'A' TO S-ACCT-STATUS.                                   
           IF AT-REV-MTH-LST-NRML = ZEROES                              
               MOVE SPACES TO S-LAST-BILL-DT
           END-IF.                           
                                                                        
           COMPUTE S-ACCOUNT-BALANCE =                                  
                   WS-FULL-BALANCE-A +                                  
                   WS-FULL-BALANCE-B.                                   
           ADD S-ACCOUNT-BALANCE TO T1-FULL-BAL-TOT (1)                 
                                      T1-FULL-BAL-TOT (7).              
           IF WS-TOTAL-CT > 50                                          
               MOVE ZEROES TO S-PAST-DUE                                
           ELSE                                                         
               IF S-ACCOUNT-BALANCE > 0                                 
                   PERFORM 2110-CPD00068-CALL THRU 2110-EXIT            
                   COMPUTE S-PAST-DUE =                                 
                           WS-AMT-ARREARS-UTL +                         
                           WS-AMT-ARREARS-NONUTL                        
               ELSE                                                     
                   MOVE 0.00 TO S-PAST-DUE
               END-IF
           END-IF.                             
           ADD S-PAST-DUE TO T1-PAST-DUE-TOT (1)                        
                               T1-PAST-DUE-TOT (7).                     
           PERFORM 3100-SECURITY THRU 3100-EXIT.                        
           MOVE WS-WAIVER-FL TO S-WAIVER-FL.                            
           MOVE WS-SECURITY-TOTAL TO S-SECURITY.                        
           ADD S-SECURITY TO T1-SECURITY-TOT (1)                        
                               T1-SECURITY-TOT (7).                     
           MOVE HT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
           MOVE ZEROES TO WS-PREMISE-NO.                                
           MOVE 0.00 TO WS-MAX-DEPOSIT-AMT                              
                        WS-MIN-DEPOSIT-AMT.                             
           PERFORM 5650-GET-MAX-DEPOSIT THRU 5650-GET-MAX-DEPOSIT-EXIT. 
           MOVE WS-MAX-DEPOSIT-AMT TO S-MAX-DEPOSIT.                    
           MOVE WS-MIN-DEPOSIT-AMT TO S-MIN-DEPOSIT.                    
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  FINAL BILLED ACCOUNTS                                                  
                                                                        
       2300-FB-ACCOUNTS.                                                
                                                                        
           ADD +1 TO T1-ACCT-CT (2)                                     
                     T1-ACCT-CT (7).                                    
           MOVE 'B' TO S-ACCT-STATUS.                                   
                                                                        
           COMPUTE S-ACCOUNT-BALANCE =                                  
                   WS-FULL-BALANCE-A +                                  
                   WS-FULL-BALANCE-B.                                   
           ADD S-ACCOUNT-BALANCE TO T1-FULL-BAL-TOT (2)                 
                                    T1-FULL-BAL-TOT (7).                
           IF WS-TOTAL-CT > 50                                          
               MOVE ZEROES TO S-PAST-DUE                                
           ELSE                                                         
               IF S-ACCOUNT-BALANCE > 0                                 
                   PERFORM 2110-CPD00068-CALL THRU 2110-EXIT            
                   COMPUTE S-PAST-DUE =                                 
                           WS-AMT-ARREARS-UTL +                         
                           WS-AMT-ARREARS-NONUTL                        
               ELSE                                                     
                   MOVE 0.00 TO S-PAST-DUE
               END-IF
           END-IF.                             
           ADD S-PAST-DUE TO T1-PAST-DUE-TOT (2)                        
                             T1-PAST-DUE-TOT (7).                       
           MOVE HT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
           MOVE ZEROES TO WS-PREMISE-NO.                                
           MOVE 0.00 TO WS-MAX-DEPOSIT-AMT                              
                        WS-MIN-DEPOSIT-AMT.                             
           PERFORM 5650-GET-MAX-DEPOSIT THRU 5650-GET-MAX-DEPOSIT-EXIT. 
           MOVE WS-MAX-DEPOSIT-AMT TO S-MAX-DEPOSIT.                    
           MOVE WS-MIN-DEPOSIT-AMT TO S-MIN-DEPOSIT.                    
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  WRITE OFF ACCOUNTS                                                     
                                                                        
       2400-WO-ACCOUNTS.                                                
                                                                        
           ADD +1 TO T1-ACCT-CT (3)                                     
                     T1-ACCT-CT (7).                                    
           MOVE 'S' TO S-ACCT-STATUS.                                   
                                                                        
           PERFORM 7200-WO-FULL-BALANCE THRU 7200-EXIT.                 
A05317     COMPUTE S-ACCOUNT-BALANCE =                                  
A05317             CO-AMT-TRANS +                                       
A05317             AT-TOTAL-AR-BALANCE.                                 
           ADD CO-AMT-TRANS TO T1-FULL-BAL-TOT (3)                      
                               T1-FULL-BAL-TOT (7).                     
           MOVE HT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
           MOVE ZEROES TO WS-PREMISE-NO.                                
           MOVE 0.00 TO WS-MAX-DEPOSIT-AMT                              
                        WS-MIN-DEPOSIT-AMT.                             
           PERFORM 5650-GET-MAX-DEPOSIT THRU 5650-GET-MAX-DEPOSIT-EXIT. 
           MOVE WS-MAX-DEPOSIT-AMT TO S-MAX-DEPOSIT.                    
           MOVE WS-MIN-DEPOSIT-AMT TO S-MIN-DEPOSIT.                    
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  PENDING ACCOUNTS                                                       
                                                                        
       2500-PENDING-ACCOUNTS.                                           
                                                                        
           ADD +1 TO T1-ACCT-CT (4)                                     
                     T1-ACCT-CT (7).                                    
           MOVE 'P' TO S-ACCT-STATUS.                                   
           IF AT-REV-MTH-LST-NRML = ZEROES                              
               MOVE SPACES TO S-LAST-BILL-DT
           END-IF.                           
                                                                        
           COMPUTE S-ACCOUNT-BALANCE =                                  
                   WS-FULL-BALANCE-A +                                  
                   WS-FULL-BALANCE-B.                                   
           ADD S-ACCOUNT-BALANCE TO T1-FULL-BAL-TOT (4)                 
                                      T1-FULL-BAL-TOT (7).              
           PERFORM 3100-SECURITY THRU 3100-EXIT.                        
           MOVE WS-WAIVER-FL TO S-WAIVER-FL.                            
           MOVE WS-SECURITY-TOTAL TO S-SECURITY.                        
           ADD S-SECURITY TO T1-SECURITY-TOT (4)                        
                               T1-SECURITY-TOT (7).                     
           MOVE HT-ACCOUNT-NO TO WS-ACCOUNT-NO.                         
           MOVE ZEROES TO WS-PREMISE-NO.                                
           MOVE 0.00 TO WS-MAX-DEPOSIT-AMT                              
                        WS-MIN-DEPOSIT-AMT.                             
           PERFORM 5650-GET-MAX-DEPOSIT THRU 5650-GET-MAX-DEPOSIT-EXIT. 
           MOVE WS-MAX-DEPOSIT-AMT TO S-MAX-DEPOSIT.                    
           MOVE WS-MIN-DEPOSIT-AMT TO S-MIN-DEPOSIT.                    
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  INACTIVE ACCOUNTS                                                      
                                                                        
       2600-INACTIVE-ACCOUNTS.                                          
                                                                        
           ADD +1 TO T1-ACCT-CT (5).                                    
           MOVE 'J' TO S-ACCT-STATUS.                                   
           IF AT-REV-MTH-LST-NRML = ZEROES                              
               MOVE SPACES TO S-LAST-BILL-DT
           END-IF.                           
                                                                        
           COMPUTE S-ACCOUNT-BALANCE =                                  
                   WS-FULL-BALANCE-A +                                  
                   WS-FULL-BALANCE-B.                                   
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  ARCHIVED ACCOUNTS                                                      
                                                                        
       2700-ARCHIVED-ACCOUNTS.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-2.                              
           ADD +1 TO T1-ACCT-CT (6).                                    
           MOVE 'R' TO S-ACCT-STATUS.                                   
           MOVE HT-COMPANY-NO TO S-COMPANY-NO.                          
           MOVE HT-ACCOUNT-NO TO S-ACCOUNT-NO                           
                                 HA-ACCOUNT-NO.                         
           PERFORM 7400-ARCHIVE-ACCOUNT THRU 7400-EXIT.                 
           MOVE HA-ACCOUNT-TYPE-CODE TO S-ACCOUNT-TYPE-2.               
           MOVE HA-CREDIT-GROUP TO S-CREDIT-GROUP.                      
           MOVE HA-ACCT-CREATE-DT(1:10) TO S-CREATE-DT.                 
           MOVE HA-ACCT-FINALED-DT(1:10) TO S-FINAL-DT                  
                                            S-LAST-BILL-DT.             
           MOVE HA-LAST-PYMT-DATE  TO S-LAST-PYMT-DT.                   
           PERFORM 7350-SERVICE-ADDRESS THRU 7350-EXIT.                 
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE WS-ADDRESS-LINE-I TO S-SERVICE-ADDR                 
           ELSE                                                         
               MOVE WS-ADDRESS-LINE TO S-SERVICE-ADDR
           END-IF.                  
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-UTILITY-PROCESSING.                                         
                                                                        
           PERFORM 7110-OPEN-UT-CURSOR THRU 7110-EXIT.                  
           PERFORM 7111-FETCH-UT-CURSOR THRU 7111-EXIT.                 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               EVALUATE UT-CODE-UTIL-TYPE                               
                   WHEN 'E'                                             
                       PERFORM 3010-CHECK-RATE THRU 3010-EXIT           
                       IF WS-UNMTR-FOUND = 'N'                          
                          MOVE UT-RATE-PLAN-NO TO WS-ELEC-RATE          
                          PERFORM 7720-CHECK-UNMTR-ELEC THRU 7720-EXIT  
                       ELSE                                             
                          PERFORM 7700-GET-ELEC-RATE THRU 7700-EXIT     
                       END-IF                                           
                   WHEN 'G'                                             
                       PERFORM 3010-CHECK-RATE THRU 3010-EXIT           
                       IF WS-UNMTR-FOUND = 'N'                          
                          MOVE UT-RATE-PLAN-NO TO WS-GAS-RATE           
                          PERFORM 7730-CHECK-UNMTR-GAS   THRU 7730-EXIT 
                       ELSE                                             
                          PERFORM 7710-GET-GAS-RATE   THRU 7710-EXIT    
                       END-IF                                           
                   WHEN 'U'                                             
                      IF UT-RATE-PLAN-NO = '064'                        
                          MOVE UT-RATE-PLAN-NO TO WS-SUB-LIGHT-RATE     
                      ELSE                                              
                           IF UT-RATE-PLAN-NO > WS-LIGHT-RATE           
                              MOVE UT-RATE-PLAN-NO TO WS-LIGHT-RATE     
                           END-IF                                       
                           PERFORM 7740-CHECK-SUBD-LIGHT THRU 7740-EXIT 
                      END-IF                                            
               END-EVALUATE                                             
               PERFORM 7111-FETCH-UT-CURSOR THRU 7111-EXIT              
           END-PERFORM.                                                 
           PERFORM 7112-CLOSE-UT-CURSOR THRU 7112-EXIT.                 
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-CHECK-RATE.                                                 
                                                                        
            MOVE 'N'                          TO WS-UNMTR-FOUND.        
                                                                        
            IF UT-CODE-UTIL-TYPE = 'E'                                  
               IF UT-RATE-PLAN-NO = '013' OR '029' OR '069' OR '079' OR 
                                    '68A' OR '68B' OR '69A' OR '69B' OR 
                                    '69C' OR '69D' OR 'A68' OR 'A69' OR 
                                    'B68' OR 'B69' OR 'C69' OR 'D69'    
                  MOVE 'Y'                  TO WS-UNMTR-FOUND           
               END-IF                                                   
            ELSE                                                        
               IF UT-RATE-PLAN-NO = '049' OR '079' OR '047'             
                  MOVE 'Y'                  TO WS-UNMTR-FOUND           
               END-IF                                                   
            END-IF.                                                     
                                                                        
            IF WS-UNMTR-FOUND = 'Y' AND UT-RATE-PLAN-NO >               
                                        WS-LIGHT-RATE                   
               MOVE UT-RATE-PLAN-NO         TO WS-LIGHT-RATE            
            END-IF.                                                     
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3100-SECURITY.                                                   
                                                                        
           PERFORM 7500-DEPOSITS THRU 7500-EXIT.                        
           ADD DO-AMT-DEPOSIT TO WS-SECURITY-TOTAL.                     
                                                                        
           PERFORM 7510-SURETY-BONDS THRU 7510-EXIT.                    
           ADD SB-AMT-BOND TO WS-SECURITY-TOTAL.                        
                                                                        
           PERFORM 7520-GUARANTORS THRU 7520-EXIT.                      
           ADD GU-AMOUNT-GUARANTEED TO WS-SECURITY-TOTAL.               
                                                                        
           PERFORM 7530-WAIVERS THRU 7530-EXIT.                         
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODE_ACCT_STAT,                                    
                     CODE_STATUS_REASON,                                
                     CREDIT_GROUP,                                      
                     BANKRUPTCY_IND,                                    
                     ACCT_XFER_TO,                                      
                     ACCT_XFER_FROM_LST,                                
                     TOTAL_AR_BALANCE,                                  
                     CODES_DATA_PRESENT,                                
                     MST_SUB_ACCT_IND,                                  
                     PREMISE_NO,                                        
                     BILL_CYCLE,                                        
                     BILL_CYCLE_CHG_CD,                                 
                     DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90,                                  
                     CREDIT_STATUS_CODE,                                
                     REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                     CODE_MAJOR_ACCT,                                   
                     CODE_ACCT_USAGE,                                   
                     NOTICE_EXEMPT_CD,                                  
                     CODE_DISC_OK,                                      
                     COMPANY_NO,                                        
                     LOCAL_OFFICE,                                      
                     CUSTOMER_NO,                                       
                     JUDGEMENT_IND,                                     
                     REV_MTH_LST_NRML,                                  
                     NXT_BILL_NO,                                       
                     LAST_NRML_BILL_NO,                                 
                     CODE_BILL_FREQ,                                    
                     ADDRESS_ID,                                        
                     NO_BILL_COPIES,                                    
                     LAST_PYMT_AMOUNT,                                  
                     LAST_PYMT_DATE,                                    
                     IVR_EXEMPT_CD,                                     
                     ACCOUNT_TYPE_CODE,                                 
                     REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                     CT_METER_RATED_IND,                                
                     CANREB_CODE_00_DAY,                                
                     CANREB_CODE_30_DAY,                                
                     CANREB_CODE_60_DAY,                                
                     CANREB_CODE_90_DAY,                                
                     CODE_CRIT_OUTAGE,                                  
                     CODE_LPC_XMT,                                      
                     EPP_OFFER_AMOUNT                                   
              INTO  :AT-CODE-ACCT-STAT,                                 
                    :AT-CODE-STATUS-REASON,                             
                    :AT-CREDIT-GROUP,                                   
                    :AT-BANKRUPTCY-IND,                                 
                    :AT-ACCT-XFER-TO,                                   
                    :AT-ACCT-XFER-FROM-LST,                             
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-CODES-DATA-PRESENT,                             
                    :AT-MST-SUB-ACCT-IND,                               
                    :AT-PREMISE-NO,                                     
                    :AT-BILL-CYCLE,                                     
                    :AT-BILL-CYCLE-CHG-CD,                              
                    :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND,           
                    :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND,           
                    :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND,           
                    :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND,           
                    :AT-CREDIT-STATUS-CODE,                             
                    :AT-ACCT-FINALED-DT :WS-FINAL-NULL-IND,              
                    :AT-CODE-MAJOR-ACCT,                                
                    :AT-CODE-ACCT-USAGE :WS-CODE-ACCT-USAGE-IND,         
                    :AT-NOTICE-EXEMPT-CD,                               
                    :AT-CODE-DISC-OK,                                   
                    :AT-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-CUSTOMER-NO,                                    
                    :AT-JUDGEMENT-IND,                                  
                    :AT-REV-MTH-LST-NRML,                               
                    :AT-NXT-BILL-NO,                                    
                    :AT-LAST-NRML-BILL-NO,                              
                    :AT-CODE-BILL-FREQ,                                 
                    :AT-ADDRESS-ID,                                     
                    :AT-NO-BILL-COPIES,                                 
                    :AT-LAST-PYMT-AMOUNT,                               
                    :AT-LAST-PYMT-DATE :WS-NULL-PYMT-DATE,              
                    :AT-IVR-EXEMPT-CD,                                  
                    :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-ACCT-CREATE-DT :WS-NULL-1,                       
                    :AT-CT-METER-RATED-IND,                             
                    :AT-CANREB-CODE-00-DAY,                             
                    :AT-CANREB-CODE-30-DAY,                             
                    :AT-CANREB-CODE-60-DAY,                             
                    :AT-CANREB-CODE-90-DAY,                             
                    :AT-CODE-CRIT-OUTAGE,                               
                    :AT-CODE-LPC-XMT,                                   
                    :AT-EPP-OFFER-AMOUNT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_ACCT_STAT,                                            
MFA-TR*              CODE_STATUS_REASON,                                        
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              BANKRUPTCY_IND,                                            
MFA-TR*              ACCT_XFER_TO,                                              
MFA-TR*              ACCT_XFER_FROM_LST,                                        
MFA-TR*              TOTAL_AR_BALANCE,                                          
MFA-TR*              CODES_DATA_PRESENT,                                        
MFA-TR*              MST_SUB_ACCT_IND,                                          
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              BILL_CYCLE,                                                
MFA-TR*              BILL_CYCLE_CHG_CD,                                         
MFA-TR*              DATE_BILL_DAY_00,                                          
MFA-TR*              DATE_BILL_DAY_30,                                          
MFA-TR*              DATE_BILL_DAY_60,                                          
MFA-TR*              DATE_BILL_DAY_90,                                          
MFA-TR*              CREDIT_STATUS_CODE,                                        
MFA-TR*              ACCT_FINALED_DT,                                           
MFA-TR*              CODE_MAJOR_ACCT,                                           
MFA-TR*              CODE_ACCT_USAGE,                                           
MFA-TR*              NOTICE_EXEMPT_CD,                                          
MFA-TR*              CODE_DISC_OK,                                              
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              JUDGEMENT_IND,                                             
MFA-TR*              REV_MTH_LST_NRML,                                          
MFA-TR*              NXT_BILL_NO,                                               
MFA-TR*              LAST_NRML_BILL_NO,                                         
MFA-TR*              CODE_BILL_FREQ,                                            
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              NO_BILL_COPIES,                                            
MFA-TR*              LAST_PYMT_AMOUNT,                                          
MFA-TR*              LAST_PYMT_DATE,                                            
MFA-TR*              IVR_EXEMPT_CD,                                             
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              ACCT_CREATE_DT,                                            
MFA-TR*              CT_METER_RATED_IND,                                        
MFA-TR*              CANREB_CODE_00_DAY,                                        
MFA-TR*              CANREB_CODE_30_DAY,                                        
MFA-TR*              CANREB_CODE_60_DAY,                                        
MFA-TR*              CANREB_CODE_90_DAY,                                        
MFA-TR*              CODE_CRIT_OUTAGE,                                          
MFA-TR*              CODE_LPC_XMT,                                              
MFA-TR*              EPP_OFFER_AMOUNT                                           
MFA-TR*       INTO  :AT-CODE-ACCT-STAT,                                         
MFA-TR*             :AT-CODE-STATUS-REASON,                                     
MFA-TR*             :AT-CREDIT-GROUP,                                           
MFA-TR*             :AT-BANKRUPTCY-IND,                                         
MFA-TR*             :AT-ACCT-XFER-TO,                                           
MFA-TR*             :AT-ACCT-XFER-FROM-LST,                                     
MFA-TR*             :AT-TOTAL-AR-BALANCE,                                       
MFA-TR*             :AT-CODES-DATA-PRESENT,                                     
MFA-TR*             :AT-MST-SUB-ACCT-IND,                                       
MFA-TR*             :AT-PREMISE-NO,                                             
MFA-TR*             :AT-BILL-CYCLE,                                             
MFA-TR*             :AT-BILL-CYCLE-CHG-CD,                                      
MFA-TR*             :AT-DATE-BILL-DAY-00:WS-DATE-BILL-00-IND,                   
MFA-TR*             :AT-DATE-BILL-DAY-30:WS-DATE-BILL-30-IND,                   
MFA-TR*             :AT-DATE-BILL-DAY-60:WS-DATE-BILL-60-IND,                   
MFA-TR*             :AT-DATE-BILL-DAY-90:WS-DATE-BILL-90-IND,                   
MFA-TR*             :AT-CREDIT-STATUS-CODE,                                     
MFA-TR*             :AT-ACCT-FINALED-DT:WS-FINAL-NULL-IND,                      
MFA-TR*             :AT-CODE-MAJOR-ACCT,                                        
MFA-TR*             :AT-CODE-ACCT-USAGE:WS-CODE-ACCT-USAGE-IND,                 
MFA-TR*             :AT-NOTICE-EXEMPT-CD,                                       
MFA-TR*             :AT-CODE-DISC-OK,                                           
MFA-TR*             :AT-COMPANY-NO,                                             
MFA-TR*             :AT-LOCAL-OFFICE,                                           
MFA-TR*             :AT-CUSTOMER-NO,                                            
MFA-TR*             :AT-JUDGEMENT-IND,                                          
MFA-TR*             :AT-REV-MTH-LST-NRML,                                       
MFA-TR*             :AT-NXT-BILL-NO,                                            
MFA-TR*             :AT-LAST-NRML-BILL-NO,                                      
MFA-TR*             :AT-CODE-BILL-FREQ,                                         
MFA-TR*             :AT-ADDRESS-ID,                                             
MFA-TR*             :AT-NO-BILL-COPIES,                                         
MFA-TR*             :AT-LAST-PYMT-AMOUNT,                                       
MFA-TR*             :AT-LAST-PYMT-DATE :WS-NULL-PYMT-DATE,                      
MFA-TR*             :AT-IVR-EXEMPT-CD,                                          
MFA-TR*             :AT-ACCOUNT-TYPE-CODE,                                      
MFA-TR*             :AT-ACCT-CREATE-DT:WS-NULL-1,                               
MFA-TR*             :AT-CT-METER-RATED-IND,                                     
MFA-TR*             :AT-CANREB-CODE-00-DAY,                                     
MFA-TR*             :AT-CANREB-CODE-30-DAY,                                     
MFA-TR*             :AT-CANREB-CODE-60-DAY,                                     
MFA-TR*             :AT-CANREB-CODE-90-DAY,                                     
MFA-TR*             :AT-CODE-CRIT-OUTAGE,                                       
MFA-TR*             :AT-CODE-LPC-XMT,                                           
MFA-TR*             :AT-EPP-OFFER-AMOUNT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE HT-ACCOUNT-NO TO AT-ACCOUNT-NO                  
                   MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT  
                   IF WS-NULL-PYMT-DATE < 0                             
                       MOVE SPACES TO AT-LAST-PYMT-DATE                 
                   END-IF                                               
                   IF WS-CODE-ACCT-USAGE-IND < 0                        
                       MOVE SPACES TO AT-CODE-ACCT-USAGE                
                   END-IF                                               
                   IF WS-FINAL-NULL-IND < 0                             
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
                   IF WS-DATE-BILL-00-IND < 0                           
                       MOVE SPACES TO AT-DATE-BILL-DAY-00               
                   END-IF                                               
                   IF WS-DATE-BILL-30-IND < 0                           
                       MOVE SPACES TO AT-DATE-BILL-DAY-30               
                   END-IF                                               
                   IF WS-DATE-BILL-60-IND < 0                           
                       MOVE SPACES TO AT-DATE-BILL-DAY-60               
                   END-IF                                               
                   IF WS-DATE-BILL-90-IND < 0                           
                       MOVE SPACES TO AT-DATE-BILL-DAY-90               
                   END-IF                                               
                   IF WS-NULL-1 < 0                                     
                       MOVE SPACES TO AT-ACCT-CREATE-DT                 
                   END-IF                                               
                   EXEC SQL                                             
                       SELECT
              DATEADD( MONTH, -12, IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) ) )
            INTO
              :WS-BILL-MINUS-12-MONTHS                  
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*            EXEC SQL                                                     
MFA-TR*                VALUES (DATE(:AT-DATE-BILL-DAY-00) - 12 MONTHS)          
MFA-TR*                  INTO :WS-BILL-MINUS-12-MONTHS                          
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   EXEC SQL                                             
                       SELECT
              DATEADD( MONTH, -24, IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) ) )
            INTO
              :WS-BILL-MINUS-24-MONTHS                  
                   END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*            EXEC SQL                                                     
MFA-TR*                VALUES (DATE(:AT-DATE-BILL-DAY-00) - 24 MONTHS)          
MFA-TR*                  INTO :WS-BILL-MINUS-24-MONTHS                          
MFA-TR*            END-EXEC                                                     
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-DELINQUENCY.                                                
                                                                        
           EXEC SQL                                                     
              SELECT DELINQ_VALUE                                       
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
               WHERE DELINQ_CD = :C8-DELINQ-CD                          
                 AND COMPANY_NO = '01'                                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   EVALUATE C8-DELINQ-CD                                
                       WHEN 'DATABASE'                                  
                           MOVE +1 TO C8-DELINQ-VALUE                   
                       WHEN 'RA-ACCOUNT-CT'                             
                           MOVE +50 TO C8-DELINQ-VALUE                  
                   END-EVALUATE                                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7005'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE C8-DELINQ-CD     TO TABLE-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7065-SELECT-NSF-HIST.                                            
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-RET-CHECK-CT-12                                
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND DATE_TRAN  >IIF(TRY_CONVERT(DATE, 
                                               :WS-BILL-MINUS-12-MONTHS
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-MINUS-12-MONTHS
              ) <> 0) OR (LEN(:WS-BILL-MINUS-12-MONTHS
              ) <> 10), CIS.CHAR2DATE(:WS-BILL-MINUS-12-MONTHS
              ), CONVERT(DATE, :WS-BILL-MINUS-12-MONTHS) )               
                 AND NSF_STATUS_CD IN ('C','F')                         
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-RET-CHECK-CT-12                                        
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND DATE_TRAN  >:WS-BILL-MINUS-12-MONTHS                       
MFA-TR*          AND NSF_STATUS_CD IN ('C','F')                                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 70651                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-RET-CHECK-CT-12                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7065'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NSF_HIST'   TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE '12 MONTHS'      TO TABLE-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-RET-CHECK-CT-24                                
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND DATE_TRAN  >IIF(TRY_CONVERT(DATE, 
                                               :WS-BILL-MINUS-24-MONTHS
              ) IS NULL OR (PATINDEX('%.%', :WS-BILL-MINUS-24-MONTHS
              ) <> 0) OR (LEN(:WS-BILL-MINUS-24-MONTHS
              ) <> 10), CIS.CHAR2DATE(:WS-BILL-MINUS-24-MONTHS
              ), CONVERT(DATE, :WS-BILL-MINUS-24-MONTHS) )               
                 AND NSF_STATUS_CD IN ('C','F')                         
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-RET-CHECK-CT-24                                        
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND DATE_TRAN  >:WS-BILL-MINUS-24-MONTHS                       
MFA-TR*          AND NSF_STATUS_CD IN ('C','F')                                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 70652                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-RET-CHECK-CT-24                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7065'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NSF_HIST'   TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE '24 MONTHS'      TO TABLE-ELEMENT-1             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7065-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-CU-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN CU-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE HT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7101-FETCH-CU-CURSOR.                                            
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
                                                                        
           EXEC SQL                                                     
               FETCH CU-CURSOR                                          
                INTO :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7101'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE HT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7102-CLOSE-CU-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE CU-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7102'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE HT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7105-OPEN-PR-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN PR-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7105'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7106-FETCH-PR-CURSOR.                                            
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
                                                                        
           EXEC SQL                                                     
               FETCH PR-CURSOR                                          
                INTO :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7106'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7106-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7107-CLOSE-PR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE PR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7107'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7107-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-OPEN-UT-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN UT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7110'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7111-FETCH-UT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               FETCH UT-CURSOR                                          
                INTO :UT-CODE-UTIL-TYPE,                                
                     :UT-RATE-PLAN-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7111'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE UT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7111-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7112-CLOSE-UT-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE UT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7112'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7112-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7115-OPEN-TA-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN TA-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7115'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'GROUP_ID'       TO TABLE-ELEMENT-1             
                   MOVE TA-GROUP-ID      TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7115-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7116-FETCH-TA-CURSOR.                                            
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
                                                                        
           EXEC SQL                                                     
               FETCH TA-CURSOR                                          
                INTO :HT-ACCOUNT-NO,                                    
                     :HT-PREMISE-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :HT-COMPANY-NO,                                    
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-CODE-ACCT-STAT,                                
                     :WS-ARCHIVE-IND                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7116'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'GROUP_ID'       TO TABLE-ELEMENT-1             
                   MOVE TA-GROUP-ID      TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7116-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7117-CLOSE-TA-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE TA-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7117'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                 
                   MOVE 'GROUP_ID'       TO TABLE-ELEMENT-1             
                   MOVE TA-GROUP-ID      TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7117-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-WO-FULL-BALANCE.                                            
                                                                        
           EXEC SQL                                                     
               SELECT SUM (AMT_TRANS)                                   
                 INTO :CO-AMT-TRANS :WS-NULL-6                           
                 FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_TRANS)                                           
MFA-TR*          INTO :CO-AMT-TRANS:WS-NULL-6                                   
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-6 < 0                                     
                      MOVE ZEROS TO CO-AMT-TRANS                        
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  CO-AMT-TRANS                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_CHRG_OFF'       TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-SELECT-CRED-PROF.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CASH_ONLY_FL,
              DISCONNECT_HIST,
              DISC_EXCEPTN_HIST,
              NON_UTL_ARRER_HIST,
              ARREARS_HIST,
              NON_UTL_CR_HST_EX,
              NON_UTL_CR_HST                                     
                INTO :CZ-CASH-ONLY-FL,                                  
                     :CZ-DISCONNECT-HIST,                               
                     :CZ-DISC-EXCEPTN-HIST,                             
                     :CZ-NON-UTL-ARRER-HIST,                            
                     :CZ-ARREARS-HIST,                                  
                     :CZ-NON-UTL-CR-HST-EX,                             
                     :CZ-NON-UTL-CR-HST                                 
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CASH_ONLY_FL,                                              
MFA-TR*              DISCONNECT_HIST,                                           
MFA-TR*              DISC_EXCEPTN_HIST,                                         
MFA-TR*              NON_UTL_ARRER_HIST,                                        
MFA-TR*              ARREARS_HIST,                                              
MFA-TR*              NON_UTL_CR_HST_EX,                                         
MFA-TR*              NON_UTL_CR_HST                                             
MFA-TR*         INTO :CZ-CASH-ONLY-FL,                                          
MFA-TR*              :CZ-DISCONNECT-HIST,                                       
MFA-TR*              :CZ-DISC-EXCEPTN-HIST,                                     
MFA-TR*              :CZ-NON-UTL-ARRER-HIST,                                    
MFA-TR*              :CZ-ARREARS-HIST,                                          
MFA-TR*              :CZ-NON-UTL-CR-HST-EX,                                     
MFA-TR*              :CZ-NON-UTL-CR-HST                                         
MFA-TR*         FROM CSS_CREDIT_PROFILE                                         
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   INITIALIZE DCLCSS-CREDIT-PROFILE                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7250'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CREDIT_PROFILE' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-FULL-BALANCE-A.                                         
                                                                        
           EXEC SQL                                                     
               SELECT SUM (AMT_AR_DAY_00                                
                         + AMT_AR_DAY_30                                
                         + AMT_AR_DAY_60                                
                         + AMT_AR_DAY_90                                
                         + AMT_UNUSED_CR                                
                         + AMT_TRAN_BALANCE                             
                         + TOT_SUMM_UNBILLED)                           
                 INTO :WS-FULL-BALANCE-A :WS-NULL-4                      
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL < 50                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_AR_DAY_00                                        
MFA-TR*                  + AMT_AR_DAY_30                                        
MFA-TR*                  + AMT_AR_DAY_60                                        
MFA-TR*                  + AMT_AR_DAY_90                                        
MFA-TR*                  + AMT_UNUSED_CR                                        
MFA-TR*                  + AMT_TRAN_BALANCE                                     
MFA-TR*                  + TOT_SUMM_UNBILLED)                                   
MFA-TR*          INTO :WS-FULL-BALANCE-A:WS-NULL-4                              
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL < 50                                    
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-4 < 0                                     
                      MOVE ZEROS TO WS-FULL-BALANCE-A                   
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-FULL-BALANCE-A                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7300'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_AR_CNTL'        TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-GET-FULL-BALANCE-B.                                         
                                                                        
           EXEC SQL                                                     
               SELECT SUM (AMT_TRAN_BALANCE)                            
                 INTO :WS-FULL-BALANCE-B :WS-NULL-5                      
                 FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND PYMT_PRIORITY_LVL > 49                            
                  AND ITEM_ID > 0                                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_TRAN_BALANCE)                                    
MFA-TR*          INTO :WS-FULL-BALANCE-B:WS-NULL-5                              
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL > 49                                    
MFA-TR*           AND ITEM_ID > 0                                               
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-5 < 0                                     
                      MOVE ZEROS TO WS-FULL-BALANCE-B                   
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-FULL-BALANCE-B                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7310'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_AR_CNTL'        TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7350-SERVICE-ADDRESS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),
              RTRIM(LTRIM(RTRIM(STREET_NAME) + ' &  ' + LTRIM(RTRIM(
           ADDRESS_OVERFLOW) + ' ' + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(
           RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE))))))),
              DY.ADDRESS_ID,
              HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              ADDR_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              DY.ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              TOWN,
              ADDR_USAGE_CD                                     
                 INTO :WS-ADDRESS-LINE,                                 
                      :WS-ADDRESS-LINE-I,                               
                      :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :A4-TOWN,                                         
                      :DY-ADDR-USAGE-CD                                 
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
               WHERE ADDRESS_ID = :HT-ADDRESS-ID                        
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||             00010002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||              00020002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||              00030002
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                00040002
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||              00050002
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                00060002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||          00070002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||           00080002
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                      00090006
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                      00100002
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),             00110004
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_NAME) || ' &  ' ||       00010002
MFA-TR*               LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||           00020002
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                      00090006
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                      00100002
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE))))))),                   00110004
MFA-TR*               DY.ADDRESS_ID,                                            
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               ZIP_CODE_PLUS_FOUR,                                       
MFA-TR*               DY.ZIP_CODE_TOKEN,                                        
MFA-TR*               TOWN,                                                     
MFA-TR*               ADDR_USAGE_CD                                             
MFA-TR*          INTO :WS-ADDRESS-LINE,                                         
MFA-TR*               :WS-ADDRESS-LINE-I,                                       
MFA-TR*               :DY-ADDRESS-ID,                                           
MFA-TR*               :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                                   
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :A4-TOWN,                                                 
MFA-TR*               :DY-ADDR-USAGE-CD                                         
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            00130001
MFA-TR*               CSS_ZIP_CODE A4                                   00140001
MFA-TR*        WHERE ADDRESS_ID = :HT-ADDRESS-ID                        00170000
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                          00180000
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              00190000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00200000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7350                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-ADDRESS-LINE                       
                                  WS-ADDRESS-LINE-I                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7350'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ZIP-CODE'   TO TABLE-2                     
                   MOVE 'ADDRESS_ID'     TO TABLE-ELEMENT-1             
                   MOVE HT-ADDRESS-ID    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-ARCHIVE-ACCOUNT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_TYPE_CODE,
              ACCT_CREATE_DT,
              ACCT_FINALED_DT,
              CREDIT_GROUP,
              LAST_PYMT_DATE                                     
                INTO :HA-ACCOUNT-TYPE-CODE,                             
                     :HA-ACCT-CREATE-DT :WS-NULL-2,                      
                     :HA-ACCT-FINALED-DT :WS-NULL-3,                     
                     :HA-CREDIT-GROUP,                                  
                     :HA-LAST-PYMT-DATE :WS-NULL-8                       
                FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_TYPE_CODE,                                         
MFA-TR*              ACCT_CREATE_DT,                                            
MFA-TR*              ACCT_FINALED_DT,                                           
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              LAST_PYMT_DATE                                             
MFA-TR*         INTO :HA-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :HA-ACCT-CREATE-DT:WS-NULL-2,                              
MFA-TR*              :HA-ACCT-FINALED-DT:WS-NULL-3,                             
MFA-TR*              :HA-CREDIT-GROUP,                                          
MFA-TR*              :HA-LAST-PYMT-DATE:WS-NULL-8                               
MFA-TR*         FROM HST_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-2 < 0                                     
                       MOVE SPACES TO HA-ACCT-CREATE-DT                 
                   END-IF                                               
                   IF WS-NULL-3 < 0                                     
                       MOVE SPACES TO HA-ACCT-FINALED-DT                
                   END-IF                                               
                   IF WS-NULL-8 < 0                                     
                       MOVE SPACES TO HA-LAST-PYMT-DATE                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7400'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'HST_ACCOUNT'   TO TABLE-1                      
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE HT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-DEPOSITS.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
                 INTO :DO-AMT-DEPOSIT :WS-NULL-12                        
                 FROM CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND DEPOSIT_STATUS_CD IN ('A', 'P')                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*          INTO :DO-AMT-DEPOSIT:WS-NULL-12                                
MFA-TR*          FROM CSS_DEP_ON_HAND                                           
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND DEPOSIT_STATUS_CD IN ('A', 'P')                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-12 < 0                                    
                       MOVE ZEROES TO DO-AMT-DEPOSIT                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  DO-AMT-DEPOSIT                        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7500'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_DEP_ON_HAND' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE HT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-SURETY-BONDS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_BOND)                                     
                 INTO :SB-AMT-BOND :WS-NULL-13                           
                 FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_BOND_TYPE IN ('A', 'B')                      
                  AND CODE_STATUS = 'A'                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_BOND)                                             
MFA-TR*          INTO :SB-AMT-BOND:WS-NULL-13                                   
MFA-TR*          FROM CSS_SURETY_BOND                                           
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND CODE_BOND_TYPE IN ('A', 'B')                              
MFA-TR*           AND CODE_STATUS = 'A'                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-13 < 0                                    
                       MOVE ZEROES TO SB-AMT-BOND                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  SB-AMT-BOND                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7510'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_SURETY_BOND' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE HT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7520-GUARANTORS.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMOUNT_GUARANTEED)                            
                 INTO :GU-AMOUNT-GUARANTEED :WS-NULL-14                  
                 FROM CSS_GUARANTOR WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND GUAR_STATUS_CD = 'A'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMOUNT_GUARANTEED)                                    
MFA-TR*          INTO :GU-AMOUNT-GUARANTEED:WS-NULL-14                          
MFA-TR*          FROM CSS_GUARANTOR                                             
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND GUAR_STATUS_CD = 'A'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7520                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-14 < 0                                    
                       MOVE ZEROES TO GU-AMOUNT-GUARANTEED              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  GU-AMOUNT-GUARANTEED                  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7520'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_GUARANTOR' TO TABLE-1                      
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE HT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7530-WAIVERS.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-WAIVER-FL                                     
                 FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_BOND_TYPE = 'C'                              
                  AND CODE_STATUS = 'A'                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-WAIVER-FL                                             
MFA-TR*          FROM CSS_SURETY_BOND                                           
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND CODE_BOND_TYPE = 'C'                                      
MFA-TR*           AND CODE_STATUS = 'A'                                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7530                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-WAIVER-FL                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-WAIVER-FL                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '7530'          TO ACTIVE-PARAGRAPH             
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_SURETY_BOND' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1              
                   MOVE HT-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-COUNT-ACCT-CUST.                                            
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-TOTAL-CT                                      
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-TOTAL-CT                                              
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                             
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7600                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-TOTAL-CT                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7600'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7610-REG-PROFILE.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REG_GROUP_CD                                      
                 INTO :LR-REG-GROUP-CD                                  
                 FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT REG_GROUP_CD                                              
MFA-TR*          INTO :LR-REG-GROUP-CD                                          
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7610                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'REG' TO S-DIVISION                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'DEREG' TO S-DIVISION                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7610'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_REG_PROFILE'    TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7620-SELECT-MKT-TIER.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TIER_ACCT_DESC_LNG                                
                 INTO :TT-TIER-ACCT-DESC-LNG                            
                 FROM CSS_ACCT_MKT_TIER DD WITH(READUNCOMMITTED),               
                      CRM_TIER_ACCT_TYPE TT WITH(READUNCOMMITTED)               
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND EFF_START_DT =                                    
                      (SELECT MAX(EFF_START_DT)                         
                         FROM CSS_ACCT_MKT_TIER WITH(READUNCOMMITTED)           
                        WHERE ACCOUNT_NO = :HT-ACCOUNT-NO)              
                  AND DD.TIER_ACCT_TYPE_CD = TT.TIER_ACCT_TYPE_CD       
                  AND TT.COMPANY_NO = :HT-COMPANY-NO                    
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TIER_ACCT_DESC_LNG                                41146600
MFA-TR*          INTO :TT-TIER-ACCT-DESC-LNG                            41146600
MFA-TR*          FROM CSS_ACCT_MKT_TIER DD,                             41146600
MFA-TR*               CRM_TIER_ACCT_TYPE TT                                     
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       41146600
MFA-TR*           AND EFF_START_DT =                                    41146600
MFA-TR*               (SELECT MAX(EFF_START_DT)                         41146600
MFA-TR*                  FROM CSS_ACCT_MKT_TIER                         41146600
MFA-TR*                 WHERE ACCOUNT_NO = :HT-ACCOUNT-NO)              41146600
MFA-TR*           AND DD.TIER_ACCT_TYPE_CD = TT.TIER_ACCT_TYPE_CD               
MFA-TR*           AND TT.COMPANY_NO = :HT-COMPANY-NO                            
MFA-TR*         FETCH FIRST ROW ONLY                                    41146600
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7620                                                     
MFA-TR*    END-EXEC.                                                    41146600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO TT-TIER-ACCT-DESC-LNG                 
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7620'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_ACCT_MKT_TIER' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE HT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7630-COUNT-ACCT-PREM.                                            
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-TOTAL-CT                                      
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE PREMISE_NO = :HT-PREMISE-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-TOTAL-CT                                              
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE PREMISE_NO = :HT-PREMISE-NO                               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7630                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-TOTAL-CT                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7630'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1         
                   MOVE HT-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7640-COUNT-ACCT-GRP.                                             
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-TOTAL-CT                                      
                 FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                  
                WHERE GROUP_ID = :TA-GROUP-ID                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-TOTAL-CT                                              
MFA-TR*          FROM CSS_ACCT_MISC_INFO                                        
MFA-TR*         WHERE GROUP_ID = :TA-GROUP-ID                                   
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7640                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-TOTAL-CT                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '7640'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
                   MOVE 'GROUP_ID'           TO TABLE-ELEMENT-1         
                   MOVE TA-GROUP-ID          TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-GET-ELEC-RATE.                                              
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :UT-RATE-PLAN-NO :WS-NULL-9                        
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND RATE_PLAN_NO NOT IN ('013','029','069','079',     
                                           '68A','68B','69A','69B',     
                                           '69C','69D','A68','A69',     
                                           'B68','B69','C69','D69')     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :UT-RATE-PLAN-NO:WS-NULL-9                                
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND RATE_PLAN_NO NOT IN ('013','029','069','079',             
MFA-TR*                                    '68A','68B','69A','69B',             
MFA-TR*                                    '69C','69D','A68','A69',             
MFA-TR*                                    'B68','B69','C69','D69')             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-9 < 0                                     
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE UT-RATE-PLAN-NO TO WS-ELEC-RATE             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-ELEC-RATE                          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7700'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'E'                   TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7710-GET-GAS-RATE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :UT-RATE-PLAN-NO :WS-NULL-10                       
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND RATE_PLAN_NO NOT IN ('049','079','047')           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :UT-RATE-PLAN-NO:WS-NULL-10                               
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND RATE_PLAN_NO NOT IN ('049','079','047')                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7710                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-10 < 0                                    
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE UT-RATE-PLAN-NO TO WS-GAS-RATE              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-GAS-RATE                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7710'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'G'                   TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7720-CHECK-UNMTR-ELEC.                                           
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :UT-RATE-PLAN-NO :WS-NULL-11                       
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND RATE_PLAN_NO IN ('013','029','069','079',         
                                       '68A','68B','69A','69B',         
                                       '69C','69D','A68','A69',         
                                       'B68','B69','C69','D69')         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :UT-RATE-PLAN-NO:WS-NULL-11                               
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND RATE_PLAN_NO IN ('013','029','069','079',                 
MFA-TR*                                '68A','68B','69A','69B',                 
MFA-TR*                                '69C','69D','A68','A69',                 
MFA-TR*                                'B68','B69','C69','D69')                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7720                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-11 < 0                                    
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE UT-RATE-PLAN-NO TO WS-LIGHT-RATE            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7720'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'E'                   TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7730-CHECK-UNMTR-GAS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :UT-RATE-PLAN-NO :WS-NULL-12                       
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND RATE_PLAN_NO IN ('049','079','047')               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                         
MFA-TR*          INTO :UT-RATE-PLAN-NO:WS-NULL-12                               
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND RATE_PLAN_NO IN ('049','079','047')                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7730                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-12 < 0                                    
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE UT-RATE-PLAN-NO TO WS-LIGHT-RATE            
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7730'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'G'                   TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7740-CHECK-SUBD-LIGHT.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RATE_PLAN_NO                                      
                 INTO :UT-RATE-PLAN-NO                                  
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = 'U'                              
                  AND RATE_PLAN_NO = '064'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RATE_PLAN_NO                                              
MFA-TR*          INTO :UT-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*           AND RATE_PLAN_NO = '064'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7740                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE UT-RATE-PLAN-NO TO WS-SUB-LIGHT-RATE            
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7740'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
                   MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2        
                   MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'U'                   TO HOSTVAR-ELEMENT-2      
                   MOVE '064'                 TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04490_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04490_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8001'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04490_R1'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04490_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04490_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE SQLCODE          TO ABEND-SQLCODE               
                   MOVE SQLSTATE         TO ABEND-SQLSTATE              
                   MOVE '8002'           TO ACTIVE-PARAGRAPH            
                   MOVE 'DELETE'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                ABEND-TABLES            
                   MOVE 'CSR04490_R2'    TO TABLE-1                     
                   MOVE SPACES           TO TABLE-ELEMENT-1             
                   MOVE SPACES           TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04490_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              ACCT_TYPE,                                                
              ACCT_CT,                                                  
              FULL_BAL_TOT,                                             
              PAST_DUE_TOT,                                             
              SECURITY_TOT                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-ACCOUNT-TYPE-1,                                       
               :S-ACCOUNT-CT,                                           
               :S-FULL-BAL-TOT,                                         
               :S-PAST-DUE-TOT,                                         
               :S-SECURITY-TOT                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04490_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       ACCT_TYPE,                                                        
MFA-TR*       ACCT_CT,                                                          
MFA-TR*       FULL_BAL_TOT,                                                     
MFA-TR*       PAST_DUE_TOT,                                                     
MFA-TR*       SECURITY_TOT                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-ACCOUNT-TYPE-1,                                               
MFA-TR*        :S-ACCOUNT-CT,                                                   
MFA-TR*        :S-FULL-BAL-TOT,                                                 
MFA-TR*        :S-PAST-DUE-TOT,                                                 
MFA-TR*        :S-SECURITY-TOT                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04490_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04490_R2                            
             (                                                          
              RETURN_CODE,                                              
              ACCOUNT_STATUS,                                           
              COMPANY_NO,                                               
              ACCOUNT_TYPE,                                             
              CREDIT_GROUP,                                             
              ACCOUNT_NO,                                               
              SERVICE_ADDR,                                             
              ACCT_BALANCE,                                             
              PAST_DUE_AMT,                                             
              SECURITY_AMT,                                             
              LAST_PYMT_DT,                                             
              GAS_RATE,                                                 
              ELEC_RATE,                                                
              LIGHT_RATE,                                               
              SUB_LIGHT_RATE,                                           
              ARREARS_HIST,                                             
              DISC_HIST,                                                
              DISC_EXCEP_HIST,                                          
              NU_ARREARS_HIST,                                          
              NU_DISC_HIST,                                             
              NU_DISC_EXCEP_HIST,                                       
              ACCT_CREATE_DT,                                           
              ACCT_FINAL_DT,                                            
              LAST_BILL_DT,                                             
              RET_CHECK_CT_12,                                          
              RET_CHECK_CT_24,                                          
              DIVISION,                                                 
              ACCT_SUB_TYPE,                                            
              MIN_DEPOSIT,                                              
              MAX_DEPOSIT,                                              
              WAIVER_FL,                                                
P00740        BANKRUPTCY_IND,                                           
A05317        BANK_DRAFT_FL,                                            
A05317        CUSTOMER_NO,                                              
A05317        PREMISE_NO                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-ACCT-STATUS,                                          
               :S-COMPANY-NO,                                           
               :S-ACCOUNT-TYPE-2,                                       
               :S-CREDIT-GROUP,                                         
               :S-ACCOUNT-NO,                                           
               :S-SERVICE-ADDR,                                         
               :S-ACCOUNT-BALANCE,                                      
               :S-PAST-DUE,                                             
               :S-SECURITY,                                             
               :S-LAST-PYMT-DT,                                         
               :S-GAS-RATE,                                             
               :S-ELEC-RATE,                                            
               :S-LIGHT-RATE,                                           
               :S-SUB-LIGHT-RATE,                                       
               :S-ARREARS-HIST,                                         
               :S-DISC-HIST,                                            
               :S-DISC-EXCEP-HIST,                                      
               :S-NU-ARREARS-HIST,                                      
               :S-NU-DISC-HIST,                                         
               :S-NU-DISC-EXCEP-HIST,                                   
               :S-CREATE-DT,                                            
               :S-FINAL-DT,                                             
               :S-LAST-BILL-DT,                                         
               :S-RET-CHECK-CT-12,                                      
               :S-RET-CHECK-CT-24,                                      
               :S-DIVISION,                                             
               :S-ACCT-SUB-TYPE,                                        
               :S-MIN-DEPOSIT,                                          
               :S-MAX-DEPOSIT,                                          
               :S-WAIVER-FL,                                            
P00740         :S-BANKRUPTCY-IND,                                       
A05317         :S-BANK-DRAFT-FL,                                        
A05317         :S-CUSTOMER-NO,                                          
A05317         :S-PREMISE-NO                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04490_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ACCOUNT_STATUS,                                                   
MFA-TR*       COMPANY_NO,                                                       
MFA-TR*       ACCOUNT_TYPE,                                                     
MFA-TR*       CREDIT_GROUP,                                                     
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       SERVICE_ADDR,                                                     
MFA-TR*       ACCT_BALANCE,                                                     
MFA-TR*       PAST_DUE_AMT,                                                     
MFA-TR*       SECURITY_AMT,                                                     
MFA-TR*       LAST_PYMT_DT,                                                     
MFA-TR*       GAS_RATE,                                                         
MFA-TR*       ELEC_RATE,                                                        
MFA-TR*       LIGHT_RATE,                                                       
MFA-TR*       SUB_LIGHT_RATE,                                                   
MFA-TR*       ARREARS_HIST,                                                     
MFA-TR*       DISC_HIST,                                                        
MFA-TR*       DISC_EXCEP_HIST,                                                  
MFA-TR*       NU_ARREARS_HIST,                                                  
MFA-TR*       NU_DISC_HIST,                                                     
MFA-TR*       NU_DISC_EXCEP_HIST,                                               
MFA-TR*       ACCT_CREATE_DT,                                                   
MFA-TR*       ACCT_FINAL_DT,                                                    
MFA-TR*       LAST_BILL_DT,                                                     
MFA-TR*       RET_CHECK_CT_12,                                                  
MFA-TR*       RET_CHECK_CT_24,                                                  
MFA-TR*       DIVISION,                                                         
MFA-TR*       ACCT_SUB_TYPE,                                                    
MFA-TR*       MIN_DEPOSIT,                                                      
MFA-TR*       MAX_DEPOSIT,                                                      
MFA-TR*       WAIVER_FL,                                                        
MFA-TR*       BANKRUPTCY_IND,                                                   
MFA-TR*       BANK_DRAFT_FL,                                                    
MFA-TR*       CUSTOMER_NO,                                                      
MFA-TR*       PREMISE_NO                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-ACCT-STATUS,                                                  
MFA-TR*        :S-COMPANY-NO,                                                   
MFA-TR*        :S-ACCOUNT-TYPE-2,                                               
MFA-TR*        :S-CREDIT-GROUP,                                                 
MFA-TR*        :S-ACCOUNT-NO,                                                   
MFA-TR*        :S-SERVICE-ADDR,                                                 
MFA-TR*        :S-ACCOUNT-BALANCE,                                              
MFA-TR*        :S-PAST-DUE,                                                     
MFA-TR*        :S-SECURITY,                                                     
MFA-TR*        :S-LAST-PYMT-DT,                                                 
MFA-TR*        :S-GAS-RATE,                                                     
MFA-TR*        :S-ELEC-RATE,                                                    
MFA-TR*        :S-LIGHT-RATE,                                                   
MFA-TR*        :S-SUB-LIGHT-RATE,                                               
MFA-TR*        :S-ARREARS-HIST,                                                 
MFA-TR*        :S-DISC-HIST,                                                    
MFA-TR*        :S-DISC-EXCEP-HIST,                                              
MFA-TR*        :S-NU-ARREARS-HIST,                                              
MFA-TR*        :S-NU-DISC-HIST,                                                 
MFA-TR*        :S-NU-DISC-EXCEP-HIST,                                           
MFA-TR*        :S-CREATE-DT,                                                    
MFA-TR*        :S-FINAL-DT,                                                     
MFA-TR*        :S-LAST-BILL-DT,                                                 
MFA-TR*        :S-RET-CHECK-CT-12,                                              
MFA-TR*        :S-RET-CHECK-CT-24,                                              
MFA-TR*        :S-DIVISION,                                                     
MFA-TR*        :S-ACCT-SUB-TYPE,                                                
MFA-TR*        :S-MIN-DEPOSIT,                                                  
MFA-TR*        :S-MAX-DEPOSIT,                                                  
MFA-TR*        :S-WAIVER-FL,                                                    
MFA-TR*        :S-BANKRUPTCY-IND,                                               
MFA-TR*        :S-BANK-DRAFT-FL,                                                
MFA-TR*        :S-CUSTOMER-NO,                                                  
MFA-TR*        :S-PREMISE-NO                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04490_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
      *    EXEC SQL                                                     00340100
      *        ROLLBACK                                                 00340300
      *    END-EXEC.                                                    00340500
      *                                                                 00340600
      *    IF SQLCODE = 0                                               00340700
      *       CONTINUE                                                  00340800
      *    ELSE                                                         00340900
      *       MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                00341000
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9500-CALL-CPD00068.                                              
                                                                        
           CALL WS-MCSCB068 USING CWS00068-FIELDS,                      
                                  AT-CODES-DATA-PRESENT,                
                                  DCLCSS-ACCOUNT,                       
                                  ABEND-FILE,                           
                                  RS-RETURN-CODE.                       
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00308                                                 
           END-EXEC.                                                            
                                                                        
