       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04487.                                          
COB303 DATE-WRITTEN.      AUGUST 28, 2012.                              
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM DETERMINES AVAILABLE APPOINTMENTS FOR A WORK     *        
      *  AREA.                                                         *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/28/12    FMB      NEW PROGRAM.                                      
A04670*  11/04/13    FMB      ACCOUNT FOR NEW ORDER IN TOTALS.         *        
A04670*  11/12/13    FMB      INITIALIZE BUSINESS PROCESS.             *        
A04670*                       ADD RANGE AVAILABLE FLAG TO RS3.         *        
A04670*  11/20/13    FMB      COMPARE SPECIFIC APPT TIME AGAINST       *        
A04670*                       RANGE TIMES AND FLAGS.                   *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04487'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04487 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKARPR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKABLO                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLCKID                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04487_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04487_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04487_R3'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  GTT-RETURN-FIELDS-1.                                     
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE ZERO.        
               10 S-STATUS-CODE       PIC S9(9) COMP VALUE ZERO.        
               10 S-BUS-RULE-ID       PIC X(10) VALUE SPACES.           
               10 S-RULE-RESULT-CD    PIC X(08) VALUE SPACES.           
               10 S-BUS-RULE-XREF-ID  PIC X(26) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-2.                                     
               10  S-RETURN-CODE-2    PIC S9(9) COMP VALUE 0.           
               10  S-INTERVAL-TS      PIC X(26) VALUE SPACES.           
           05  GTT-RETURN-FIELDS-3.                                     
               10  S-RETURN-CODE-3    PIC S9(9) COMP VALUE 0.           
               10  S-RANGE-CD         PIC X(02) VALUE SPACES.           
               10  S-RANGE-BEGIN-TS   PIC X(26) VALUE SPACES.           
               10  S-RANGE-END-TS     PIC X(26) VALUE SPACES.           
A04670         10  S-RANGE-AVAIL-FL   PIC X(01) VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-PROCESS-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04487'.     
           05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-NULL1                 PIC S9(4) COMP VALUE 0.         
           05  WS-NULL2                 PIC S9(4) COMP VALUE 0.         
           05  WS-DAY-OF-WEEK           PIC 9(01) VALUE ZEROES.         
           05  WS-BLOCK-ID-TYPE         PIC X(01) VALUE SPACES.         
           05  WS-DAYOFWEEK-ISO         PIC S9(9) COMP VALUE 0.         
           05  WS-APPOINTMENT-CT        PIC S9(9) COMP VALUE 0.         
           05  WS-ORDER-CT              PIC S9(9) COMP VALUE 0.         
           05  WS-AM-APPT-CT            PIC S9(9) COMP VALUE 0.         
           05  WS-PM-APPT-CT            PIC S9(9) COMP VALUE 0.         
           05  WS-AH-APPT-CT            PIC S9(9) COMP VALUE 0.         
           05  WS-TOTAL-MINUTES         PIC S9(9) COMP VALUE 0.         
           05  WS-AM-MINUTES            PIC S9(9) COMP VALUE 0.         
           05  WS-PM-MINUTES            PIC S9(9) COMP VALUE 0.         
           05  WS-AH-MINUTES            PIC S9(9) COMP VALUE 0.         
           05  WS-ORDER-MINUTES         PIC S9(9) COMP VALUE 0.         
           05  WS-START-SHIFT-AM-TM     PIC X(26) VALUE SPACES.         
           05  WS-START-SHIFT-PM-TM     PIC X(26) VALUE SPACES.         
           05  WS-START-SHIFT-AH-TM     PIC X(26) VALUE SPACES.         
           05  WS-STOP-SHIFT-AM-TM      PIC X(26) VALUE SPACES.         
           05  WS-STOP-SHIFT-PM-TM      PIC X(26) VALUE SPACES.         
           05  WS-STOP-SHIFT-AH-TM      PIC X(26) VALUE SPACES.         
A04670     05  WS-AM-AVAILABLE-FL       PIC X(01) VALUE SPACES.         
A04670     05  WS-PM-AVAILABLE-FL       PIC X(01) VALUE SPACES.         
           05  WS-BLOCK-FROM-TIME       PIC X(26) VALUE SPACES.         
           05  WS-BLOCK-UNTIL-TIME      PIC X(26) VALUE SPACES.         
           05  WS-ASSIGNED-TS           PIC X(26) VALUE SPACES.         
           05  WS-ASSIGNED-DATE         PIC X(10) VALUE SPACES.         
           05  WS-TIME-DIFFERENCE       PIC S9(9) COMP VALUE 0.         
           05  WS-NULL-DIFF             PIC S9(04) COMP VALUE ZERO.     
           05  WS-TIMESTAMP             PIC X(26) VALUE SPACES.         
           05  WS-INTERVALS-PER-DAY     PIC S9(9) COMP VALUE 0.         
           05  WS-INTERVAL-TS           PIC X(26) VALUE SPACES.         
           05  WS-VALID-INTERVAL-FL     PIC X(01) VALUE 'N'.            
           05  WS-BLOCK-FOUND-FL        PIC X(01) VALUE 'N'.            
           05  WS-PROCESS-BLOCK-FL      PIC X(01) VALUE 'N'.            
           05  WS-INTERVALS-NEEDED-CEIL PIC S9(9) COMP-3 VALUE 0.       
           05  WS-INTERVALS-NEEDED      PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-ORD-RE-CEIL           PIC S9(5) COMP-3 VALUE 0.       
           05  WS-ORDER-DURATION-SECS   PIC S9(5) COMP-3 VALUE 0.       
           05  WS-ORDER-DURATION-TS     PIC X(26) VALUE SPACES.         
           05  WS-ORD-RE-MIN            PIC S9(4) COMP VALUE 0.         
           05  WS-CALCULATED-END-TS     PIC X(26) VALUE SPACES.         
           05  WS-BEGIN-APPT-TS         PIC X(26) VALUE SPACES.         
           05  WS-EST-RE                PIC S9(5)V9(1) USAGE COMP-3     
                                                       VALUE 0.         
           05  WS-SUB1                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUB2                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUB3                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUB4                  PIC S9(4) COMP VALUE 0.         
           05  WS-SUB5                  PIC S9(4) COMP VALUE 0.         
           05  WS-LAST-START-INTERVAL   PIC S9(4) COMP VALUE 0.         
           05  WS-CALC-LAST-INTERVAL    PIC S9(4) COMP VALUE 0.         
           05  WS-END-LOOP-FL           PIC X(01) VALUE 'N'.            
           05  WS-CAN-MOVE-FL           PIC X(01) VALUE 'N'.            
           05  WS-CAN-FIT-FL            PIC X(01) VALUE 'N'.            
           05  WS-INTERVAL-DISPLAY-FL   PIC X(01) VALUE 'N'.            
A04670     05  WS-AM-AVAIL-FL           PIC X(01) VALUE 'Y'.            
A04670     05  WS-PM-AVAIL-FL           PIC X(01) VALUE 'Y'.            
A04670     05  WS-AH-AVAIL-FL           PIC X(01) VALUE 'Y'.            
                                                                        
       01  WS-TABLES.                                                   
           05  T1-INTERVALS           OCCURS 200                        
                                      INDEXED BY T1-INDEX.              
               10  T1-INTERVAL-TS          PIC X(26) VALUE SPACES.      
               10  T1-AVAILABLE            PIC X(01) VALUE SPACES.      
               10  T1-MOVEABLE             PIC X(01) VALUE SPACES.      
               10  T1-FLOATER              PIC X(01) VALUE SPACES.      
               10  T1-EARLIEST-START       PIC X(26) VALUE SPACES.      
               10  T1-LATEST-START         PIC X(26) VALUE SPACES.      
               10  T1-NEEDED               PIC S9(9)V COMP-3 VALUE 0.   
               10  T1-APPTS-THIS-INT       PIC S9(9)V COMP-3 VALUE 0.   
               10  T1-SHOWABLE             PIC X(01) VALUE SPACES.      
               10  T1-MOVETO               PIC X(26) VALUE SPACES.      
               10  T1-ALLOW-SPECIFIC-APPTS PIC X(01) VALUE SPACES.      
           05  T2-ORDERS              OCCURS 500                        
                                      INDEXED BY T2-INDEX.              
               10 T2-SERV-ORDER-NO      PIC S9(13)V COMP-3 VALUE 0.     
               10 T2-BEGIN-APPT-TS      PIC X(26) VALUE SPACES.         
               10 T2-END-APPT-TS        PIC X(26) VALUE SPACES.         
               10 T2-APPT-AM-PM-CD      PIC X(01) VALUE SPACES.         
               10 T2-EST-RE             PIC S9(5)V9(1) USAGE COMP-3     
                                                       VALUE 0.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
           EXEC SQL                                                     
              DECLARE SO-CURSOR CURSOR FOR                              
               SELECT SERV_ORDER_NO,                                    
                      REPLACE(REPLACE(CONVERT(CHAR(26), BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT,                         
                      REPLACE(REPLACE(CONVERT(CHAR(26), END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT,                           
                      APPT_AM_PM_CD,                                    
                      SO_EST_LABOR_HR                                   
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE WORK_AREA_ID = :VO-WORK-AREA-ID                   
                  AND CAST(ASSIGNED_DATETIME AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) )        
                  AND ORDER_STATE_CD NOT IN ('C', 'Z')                  
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SO-CURSOR CURSOR FOR                                      
MFA-TR*        SELECT SERV_ORDER_NO,                                            
MFA-TR*               BEGIN_APPT_DT,                                            
MFA-TR*               END_APPT_DT,                                              
MFA-TR*               APPT_AM_PM_CD,                                            
MFA-TR*               SO_EST_LABOR_HR                                           
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE WORK_AREA_ID = :VO-WORK-AREA-ID                           
MFA-TR*           AND DATE(ASSIGNED_DATETIME) = :WS-PROCESS-DATE                
MFA-TR*           AND ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 STATUS_CODE          AS STATUS_CODE,                   
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 RULE_RESULT_CD       AS RULE_RESULT_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID               
              FROM #CSR04487_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          STATUS_CODE          AS STATUS_CODE,                           
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          RULE_RESULT_CD       AS RULE_RESULT_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID                       
MFA-TR*       FROM SESSION.CSR04487_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CODE,              
                      :S-BUS-RULE-ID       AS BUS_RULE_ID,              
                      :S-RULE-RESULT-CD    AS RULE_RESULT_CD,           
                      :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID          
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CODE,                      
MFA-TR*               :S-BUS-RULE-ID       AS BUS_RULE_ID,                      
MFA-TR*               :S-RULE-RESULT-CD    AS RULE_RESULT_CD,                   
MFA-TR*               :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID                  
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE         AS RETURN_CODE,               
                      INTERVAL_TS         AS INTERVAL_TS                
               FROM #CSR04487_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               INTERVAL_TS         AS INTERVAL_TS                        
MFA-TR*        FROM SESSION.CSR04487_R2                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
                  SELECT :S-RETURN-CODE-2     AS RETURN_CODE,           
                         :S-INTERVAL-TS       AS INTERVAL_TS            
                     FROM CIS.SYSDUMMY1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*           SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                   
MFA-TR*                  :S-INTERVAL-TS       AS INTERVAL_TS                    
MFA-TR*              FROM SYSIBM.SYSDUMMY1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
               SELECT RETURN_CODE         AS RETURN_CODE,               
                      RANGE_CD            AS RANGE_CD,                  
                      RANGE_BEGIN_TS      AS RANGE_BEGIN_TS,            
                      RANGE_END_TS        AS RANGE_END_TS,              
A04670                RANGE_AVAIL_FL      AS RANGE_AVAIL_FL             
               FROM #CSR04487_R3                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*        SELECT RETURN_CODE         AS RETURN_CODE,                       
MFA-TR*               RANGE_CD            AS RANGE_CD,                          
MFA-TR*               RANGE_BEGIN_TS      AS RANGE_BEGIN_TS,                    
MFA-TR*               RANGE_END_TS        AS RANGE_END_TS,                      
MFA-TR*               RANGE_AVAIL_FL      AS RANGE_AVAIL_FL                     
MFA-TR*        FROM SESSION.CSR04487_R3                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
                  SELECT :S-RETURN-CODE-3     AS RETURN_CODE,           
                         :S-RANGE-CD          AS RANGE_CD,              
                         :S-RANGE-BEGIN-TS    AS RANGE_BEGIN_TS,        
                         :S-RANGE-END-TS      AS RANGE_END_TS,          
A04670                   :S-RANGE-AVAIL-FL    AS RANGE_AVAIL_FL         
                     FROM CIS.SYSDUMMY1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*           SELECT :S-RETURN-CODE-3     AS RETURN_CODE,                   
MFA-TR*                  :S-RANGE-CD          AS RANGE_CD,                      
MFA-TR*                  :S-RANGE-BEGIN-TS    AS RANGE_BEGIN_TS,                
MFA-TR*                  :S-RANGE-END-TS      AS RANGE_END_TS,                  
MFA-TR*                  :S-RANGE-AVAIL-FL    AS RANGE_AVAIL_FL                 
MFA-TR*              FROM SYSIBM.SYSDUMMY1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-WORK-AREA-ID       PIC X(12).                           
       01  LINK-ASSIGNED-DT        PIC X(10).                           
COB305 01 LINK-TOTAL-RE        PIC S9(5)V9(1) COMP-3 VALUE 0.               
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-WORK-AREA-ID                             
                          LINK-ASSIGNED-DT                              
                          LINK-TOTAL-RE.                                
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
               MOVE 'NO DATA' TO S-BUS-RULE-ID                          
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04487_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04487_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               RULE_RESULT_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT1'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04487_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04487_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04487_R2
              (                                                          
               RETURN_CODE          INT,                            
               INTERVAL_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04487_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
               END-IF
           END-IF.      
           MOVE 'Y' TO  WS-GTT02-DECLARED.                              
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04487_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04487_R3
              (                                                          
               RETURN_CODE          INT,                            
               RANGE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,              
               RANGE_BEGIN_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,        
               RANGE_END_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2,          
A04670         RANGE_AVAIL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04487_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
               END-IF
           END-IF.      
           MOVE 'Y' TO  WS-GTT03-DECLARED.                              
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-TOTAL-RE NOT NUMERIC                                 
               MOVE ZEROES TO LINK-TOTAL-RE
           END-IF.                            
           MOVE LINK-ASSIGNED-DT TO WS-PROCESS-DATE.                    
           MOVE LINK-WORK-AREA-ID TO I4-WORK-AREA-ID                    
                                     H5-WORK-AREA-ID                    
                                     VO-WORK-AREA-ID.                   
A04670     MOVE 'SOINIT0001' TO 1T-BUS-PROCESS-ID.                      
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-WORK-AREA-ID = SPACES OR                             
              LINK-ASSIGNED-DT = SPACES                                 
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                               S-RETURN-CODE-2                          
                               S-RETURN-CODE-3                          
                  MOVE 'PARMS ZERO' TO S-BUS-RULE-ID                    
                  ADD +1 TO CTR-ROWS                                    
                  PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT             
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
                  PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT             
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                  PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT             
                  PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT             
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * APPT_AM_PM_CD                                                           
      * A = AM                                                                  
      * E = AFTER HOURS                                                         
      * F = RANGE                                                               
      * N = SPECIFIC INTERVAL                                                   
      * O = OVERRIDE                                                            
      * P = PM                                                                  
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT
              CIS.DAYOFWEEK_ISO( IIF(TRY_CONVERT(DATE, :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) ) )
            INTO
              :WS-DAYOFWEEK-ISO                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES DAYOFWEEK_ISO(:WS-PROCESS-DATE)                           
MFA-TR*          INTO :WS-DAYOFWEEK-ISO                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-DAYOFWEEK-ISO TO WS-DAY-OF-WEEK.                     
           MOVE WS-DAY-OF-WEEK TO WS-BLOCK-ID-TYPE.                     
           PERFORM 7100-CHECK-HOLIDAY THRU 7100-EXIT.                   
           MOVE WS-BLOCK-ID-TYPE TO I4-BLOCK-TYPE-ID                    
                                    H7-BLOCK-TYPE-ID.                   
                                                                        
      * WS-BLOCK-ID-TYPE = DAY OF WEEK STARTING ON MONDAY; HOLIDAY = 8          
      * GET PERMISSIONS FOR WORK AREA AND BLOCK ID TYPE                         
                                                                        
           PERFORM 7000-PERMISSIONS THRU 7000-EXIT.                     
                                                                        
      * GET BLOCKS FOR WORK AREA AND BLOCK ID TYPE                              
      * BLOCK_ID = CODE OF SPECIFIC BLOCK (GOOD FRIDAY, NON WORK MON..)         
                                                                        
           MOVE 'N' TO WS-BLOCK-FOUND-FL                                
                       WS-PROCESS-BLOCK-FL.                             
           PERFORM 7200-BLOCKS THRU 7200-EXIT.                          
                                                                        
           PERFORM 2020-CONVERT-DATES THRU 2020-EXIT.                   
                                                                        
      * PROCESS THE BLOCK IF THE ASSIGNED DATE IS WITHIN THE BLOCK              
      * WINDOW                                                                  
                                                                        
           IF WS-BLOCK-FOUND-FL = 'Y'                                   
               IF WS-ASSIGNED-TS <= H5-BLOCK-EXP-DATE AND               
                  WS-ASSIGNED-TS >= H5-BLOCK-EFF-DATE                   
                      MOVE 'Y' TO WS-PROCESS-BLOCK-FL                   
               ELSE                                                     
                   MOVE 'N' TO WS-PROCESS-BLOCK-FL
               END-IF
           END-IF.                     
                                                                        
      * GET ALL ORDERS FOR THE WORK AREA FOR THE ASSIGNED DATE THAT             
      * ARE NOT COMPLETED OR CANCELLED                                          
      * ORDER DATA IS IN THE T2 WORKING STORAGE TABLE                           
                                                                        
           SET T2-INDEX TO +1.                                          
           PERFORM 7300-OPEN-SO-CURSOR THRU 7300-EXIT.                  
           PERFORM 2010-FETCH-ROWS THRU 2010-EXIT.                      
           PERFORM 7310-CLOSE-SO-CURSOR THRU 7310-EXIT.                 
                                                                        
      * ACCUMULATE COUNTS OF ORDERS, APPTS, AND RES FOR THE DATE                
      * AND WORK AREA. CREATE MESSAGES IF ANYTHING IS OVER THE MAX.             
                                                                        
           PERFORM 2100-PROCESS-ORDERS THRU 2100-EXIT VARYING           
               T2-INDEX FROM 1 BY 1 UNTIL                               
               T2-INDEX > 500 OR                                        
               T2-SERV-ORDER-NO (T2-INDEX) = 0.                         
                                                                        
A04670* ALLOW FOR THE NEW ORDER WHEN COMPARING COUNTS AND RES.                  
                                                                        
A04670     ADD +1 TO WS-ORDER-CT                                        
A04670               WS-APPOINTMENT-CT                                  
A04670               WS-AM-APPT-CT                                      
A04670               WS-PM-APPT-CT                                      
A04670               WS-AH-APPT-CT.                                     
                                                                        
A04670     COMPUTE WS-ORDER-MINUTES = LINK-TOTAL-RE * 60.               
A04670     ADD WS-ORDER-MINUTES TO WS-TOTAL-MINUTES                     
A04670                             WS-AM-MINUTES                        
A04670                             WS-PM-MINUTES                        
A04670                             WS-AH-MINUTES.                       
                                                                        
           IF I4-MAX-DAY-WK-REQ-FL = 'Y' AND                            
              WS-ORDER-CT > I4-MAX-DAILY-WK-REQ                         
A04670            MOVE 'N' TO WS-AM-AVAIL-FL                            
A04670                        WS-PM-AVAIL-FL                            
A04670                        WS-AH-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO138' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000029' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
           IF I4-MAX-DAILY-APPT-FL = 'Y' AND                            
              WS-APPOINTMENT-CT > I4-MAX-DAILY-APPT AND                 
              I4-MAX-DAILY-APPT > 0                                     
A04670            MOVE 'N' TO WS-AM-AVAIL-FL                            
A04670                        WS-PM-AVAIL-FL                            
A04670                        WS-AH-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO138' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000029' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
           IF I4-MAX-RE-PER-DAY-FL = 'Y' AND                            
              WS-TOTAL-MINUTES >= (I4-MAX-RE-PER-DAY * 60)              
A04670            MOVE 'N' TO WS-AM-AVAIL-FL                            
A04670                        WS-PM-AVAIL-FL                            
A04670                        WS-AH-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO138' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000029' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
           IF WS-AM-APPT-CT > I4-MAX-AM-APPT-QT AND                     
A04670        I4-MAX-AM-APPT-QT > 0                                     
A04670            MOVE 'N' TO WS-AM-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO319' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000030' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
           IF WS-AM-MINUTES >= (I4-MAX-RE-AM-QT * 60) AND               
A04670        I4-MAX-RE-AM-QT > 0                                       
A04670            MOVE 'N' TO WS-AM-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO322' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000033' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
           IF WS-PM-APPT-CT > I4-MAX-PM-APPT-QT AND                     
A04670        I4-MAX-PM-APPT-QT > 0                                     
A04670            MOVE 'N' TO WS-PM-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO320' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000031' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
           IF WS-PM-MINUTES >= (I4-MAX-RE-PM-QT * 60) AND               
A04670        I4-MAX-RE-PM-QT > 0                                       
A04670            MOVE 'N' TO WS-PM-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO323' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000034' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
           IF WS-AH-APPT-CT > I4-MAX-AH-APPT-QT AND                     
A04670        I4-MAX-AH-APPT-QT > 0                                     
A04670            MOVE 'N' TO WS-AH-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO321' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000032' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
           IF WS-AH-MINUTES >= (I4-MAX-RE-AH-QT * 60) AND               
A04670        I4-MAX-RE-AH-QT > 0                                       
A04670            MOVE 'N' TO WS-AH-AVAIL-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
      *           MOVE 'SO324' TO S-BUS-RULE-ID                                 
                  MOVE 'ORDR000035' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-RULE-RESULT-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
A04670     IF I4-MAX-AM-APPT-QT = 0                                     
A04670         MOVE 'N' TO WS-AM-AVAIL-FL
           END-IF.                              
A04670     IF I4-MAX-RE-AM-QT = 0                                       
A04670         MOVE 'N' TO WS-AM-AVAIL-FL
           END-IF.                              
A04670     IF I4-MAX-PM-APPT-QT = 0                                     
A04670         MOVE 'N' TO WS-PM-AVAIL-FL
           END-IF.                              
A04670     IF I4-MAX-RE-PM-QT = 0                                       
A04670         MOVE 'N' TO WS-PM-AVAIL-FL
           END-IF.                              
A04670     IF I4-MAX-AH-APPT-QT = 0                                     
A04670         MOVE 'N' TO WS-AH-AVAIL-FL
           END-IF.                              
A04670     IF I4-MAX-RE-AH-QT = 0                                       
A04670         MOVE 'N' TO WS-AH-AVAIL-FL
           END-IF.                              
                                                                        
A04670     PERFORM 2030-AM-PM-RANGES THRU 2030-EXIT.                    
                                                                        
      * CALCULATE THE NUMBER OF INTERVALS PER DAY                               
      * INTERVAL TIME IS IN MINUTES (1440 MINUTES PER DAY)                      
      * BUILD THE INTERVAL TEMPLATE IN THE T1 WORKING STORAGE TABLE             
      * THE SHOWABLE FIELD DETERMINES IF THE INTERVAL WILL BE SENT              
      * TO THE UI.                                                              
                                                                        
           IF I4-INTERVAL-NM = 0                                        
               MOVE 60 TO I4-INTERVAL-NM
           END-IF.                               
           COMPUTE WS-INTERVALS-PER-DAY = 1440 / I4-INTERVAL-NM.        
           MOVE WS-ASSIGNED-TS TO WS-INTERVAL-TS.                       
                                                                        
           PERFORM 2200-BUILD-INTERVALS THRU 2200-EXIT VARYING          
               T1-INDEX FROM 1 BY 1 UNTIL                               
               T1-INDEX > WS-INTERVALS-PER-DAY.                         
                                                                        
      * USE EXISTING APPOINTMENTS TO MARK INTERVALS                             
                                                                        
           PERFORM 2300-PROCESS-ORDERS THRU 2300-EXIT VARYING           
               T2-INDEX FROM 1 BY 1 UNTIL                               
               T2-INDEX > 500 OR                                        
               T2-SERV-ORDER-NO (T2-INDEX) = 0.                         
                                                                        
      * PROCESS FLOATERS AND DETERMINE IF NEW APPOINTMENT WILL FIT              
      * INTO INTERVAL WITH FLOATER                                              
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1                         
                   UNTIL T1-INDEX > WS-INTERVALS-PER-DAY                
               IF T1-FLOATER (T1-INDEX) = 'Y'                           
                   PERFORM 2400-MARK-FLOATERS THRU 2400-EXIT            
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
      * SEE IF THERE ARE AN ADEQUATE NUMBER OF INTERVALS TO HOLD THE            
      * APPOINTMENT BEING MADE.                                                 
                                                                        
           MOVE 'N' TO WS-CAN-FIT-FL.                                   
           COMPUTE WS-SUB1 = WS-INTERVALS-PER-DAY -                     
                             WS-INTERVALS-NEEDED.                       
           PERFORM 2500-MOVERS-AND-FLOATERS THRU 2500-EXIT              
               VARYING T1-INDEX FROM 1 BY 1 UNTIL                       
                       T1-INDEX > WS-SUB1.                              
                                                                        
      * DO INTERVALS NEEDED EXCEED INTERVALS LEFT IN THE DAY                    
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
                           T1-INDEX > WS-INTERVALS-PER-DAY              
               SET WS-SUB1 TO T1-INDEX                                  
               COMPUTE WS-SUB2 = ((WS-SUB1 +                            
                                   WS-INTERVALS-NEEDED) - 1)            
A04670         IF WS-INTERVALS-PER-DAY < WS-SUB2                        
                   MOVE 'N' TO T1-SHOWABLE (T1-INDEX)                   
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
      * DO INTERVALS FALL WITHIN A FULL AM/PM RANGE                             
                                                                        
A04670     PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
A04670                     T1-INDEX > WS-INTERVALS-PER-DAY              
A04670         IF WS-AM-AVAILABLE-FL = 'N' AND                          
A04670            T1-INTERVAL-TS (T1-INDEX) >= WS-START-SHIFT-AM-TM AND 
A04670            T1-INTERVAL-TS (T1-INDEX) <= WS-STOP-SHIFT-AM-TM      
A04670                MOVE 'N' TO T1-SHOWABLE (T1-INDEX)                
A04670         END-IF                                                   
A04670         IF WS-PM-AVAILABLE-FL = 'N' AND                          
A04670            T1-INTERVAL-TS (T1-INDEX) >= WS-START-SHIFT-PM-TM AND 
A04670            T1-INTERVAL-TS (T1-INDEX) <= WS-STOP-SHIFT-PM-TM      
A04670                MOVE 'N' TO T1-SHOWABLE (T1-INDEX)                
A04670         END-IF                                                   
A04670     END-PERFORM.                                                 
                                                                        
      * RETURN SHOWABLE INTERVALS TO THE UI                                     
                                                                        
           MOVE 'N' TO WS-INTERVAL-DISPLAY-FL.                          
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
                           T1-INDEX > WS-INTERVALS-PER-DAY              
               IF T1-SHOWABLE (T1-INDEX) = 'Y' AND                      
                  T1-ALLOW-SPECIFIC-APPTS (T1-INDEX) = 'Y'              
                      MOVE 'Y' TO WS-INTERVAL-DISPLAY-FL                
                      MOVE 0 TO S-RETURN-CODE-2                         
                      MOVE T1-INTERVAL-TS (T1-INDEX) TO S-INTERVAL-TS   
                      IF WS-GTT02-DECLARED = 'N'                        
                          PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT     
                      END-IF                                            
                      PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT         
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           IF WS-INTERVAL-DISPLAY-FL = 'N'                              
               IF I4-SPEC-APPT-AM-FL = 'N' AND                          
                  I4-SPEC-APPT-PM-FL = 'N' AND                          
                  I4-SPEC-APPT-AH-FL = 'N'                              
                      MOVE 'ORDR000037' TO S-BUS-RULE-ID                
               ELSE                                                     
                   MOVE 'ORDR000036' TO S-BUS-RULE-ID                   
               END-IF                                                   
               MOVE 0 TO S-RETURN-CODE-1                                
               MOVE 'F' TO S-RULE-RESULT-CD                             
               PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH SO-CURSOR                                          
                INTO :VO-SERV-ORDER-NO,                                 
                     :VO-BEGIN-APPT-DT :WS-NULL1,                        
                     :VO-END-APPT-DT :WS-NULL2,                          
                     :VO-APPT-AM-PM-CD,                                 
                     :VO-SO-EST-LABOR-HR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL1 < 0                                      
                       MOVE SPACES TO VO-BEGIN-APPT-DT                  
                   END-IF                                               
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO VO-END-APPT-DT                    
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2010-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'WORK_AREA_ID'      TO TABLE-ELEMENT-1          
                   MOVE VO-WORK-AREA-ID     TO HOSTVAR-ELEMENT-1        
                   MOVE 'ASSIGNED_DATETIME' TO TABLE-ELEMENT-2          
                   MOVE WS-PROCESS-DATE     TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE VO-SERV-ORDER-NO TO T2-SERV-ORDER-NO (T2-INDEX).        
           MOVE VO-BEGIN-APPT-DT TO T2-BEGIN-APPT-TS (T2-INDEX).        
           MOVE VO-END-APPT-DT TO T2-END-APPT-TS (T2-INDEX).            
           MOVE VO-APPT-AM-PM-CD TO T2-APPT-AM-PM-CD (T2-INDEX).        
           MOVE VO-SO-EST-LABOR-HR TO T2-EST-RE (T2-INDEX).             
           SET T2-INDEX UP BY +1.                                       
                                                                        
           GO TO 2010-FETCH-ROWS.                                       
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * FORMAT DATES WITH THE DATE FROM LINKAGE AND THE TIMES FROM              
      * THE TABLES.                                                             
      * BUILD THE TIME PERIODS FOR AM, PM, AND AH.                              
                                                                        
       2020-CONVERT-DATES.                                              
                                                                        
           MOVE I4-START-SHIFT-AM-TM TO WS-START-SHIFT-AM-TM.           
           MOVE WS-PROCESS-DATE TO WS-START-SHIFT-AM-TM(1:10).          
           MOVE I4-START-SHIFT-PM-TM TO WS-START-SHIFT-PM-TM.           
           MOVE WS-PROCESS-DATE TO WS-START-SHIFT-PM-TM(1:10).          
           MOVE I4-START-SHIFT-AH-TM TO WS-START-SHIFT-AH-TM.           
           MOVE WS-PROCESS-DATE TO WS-START-SHIFT-AH-TM(1:10).          
           MOVE I4-STOP-SHIFT-AM-TM TO WS-STOP-SHIFT-AM-TM.             
           MOVE WS-PROCESS-DATE TO WS-STOP-SHIFT-AM-TM(1:10).           
           MOVE I4-STOP-SHIFT-PM-TM TO WS-STOP-SHIFT-PM-TM.             
           MOVE WS-PROCESS-DATE TO WS-STOP-SHIFT-PM-TM(1:10).           
           MOVE I4-STOP-SHIFT-AH-TM TO WS-STOP-SHIFT-AH-TM.             
           MOVE WS-PROCESS-DATE TO WS-STOP-SHIFT-AH-TM(1:10).           
           MOVE H5-BLOCK-FROM-TIME TO WS-BLOCK-FROM-TIME.               
           MOVE WS-PROCESS-DATE TO WS-BLOCK-FROM-TIME(1:10).            
           MOVE H5-BLOCK-UNTIL-TIME TO WS-BLOCK-UNTIL-TIME.             
           MOVE WS-PROCESS-DATE TO WS-BLOCK-UNTIL-TIME(1:10).           
                                                                        
           MOVE WS-PROCESS-DATE TO WS-ASSIGNED-DATE                     
                                    WS-ASSIGNED-TS(1:10).               
           MOVE '-00.00.00.000000' TO WS-ASSIGNED-TS(11:16).            
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04670 2030-AM-PM-RANGES.                                               
                                                                        
           MOVE 0 TO S-RETURN-CODE-3.                                   
           MOVE 'A' TO S-RANGE-CD.                                      
           MOVE WS-START-SHIFT-AM-TM TO S-RANGE-BEGIN-TS.               
           MOVE WS-STOP-SHIFT-AM-TM TO S-RANGE-END-TS.                  
A04670     IF WS-AM-AVAIL-FL = 'Y'                                      
A04670         MOVE 'Y' TO S-RANGE-AVAIL-FL                             
A04670                     WS-AM-AVAILABLE-FL                           
A04670     ELSE                                                         
A04670         MOVE 'N' TO S-RANGE-AVAIL-FL                             
A04670                     WS-AM-AVAILABLE-FL
           END-IF.                          
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
           MOVE 0 TO S-RETURN-CODE-3.                                   
           MOVE 'P' TO S-RANGE-CD.                                      
           MOVE WS-START-SHIFT-PM-TM TO S-RANGE-BEGIN-TS.               
           MOVE WS-STOP-SHIFT-PM-TM TO S-RANGE-END-TS.                  
A04670     IF WS-PM-AVAIL-FL = 'Y'                                      
A04670         MOVE 'Y' TO S-RANGE-AVAIL-FL                             
A04670                     WS-PM-AVAILABLE-FL                           
A04670     ELSE                                                         
A04670         MOVE 'N' TO S-RANGE-AVAIL-FL                             
A04670                     WS-PM-AVAILABLE-FL
           END-IF.                          
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
           END-IF                                                       
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
           MOVE 0 TO S-RETURN-CODE-3.                                   
           MOVE 'E' TO S-RANGE-CD.                                      
           MOVE WS-START-SHIFT-AH-TM TO S-RANGE-BEGIN-TS.               
           MOVE WS-STOP-SHIFT-AH-TM TO S-RANGE-END-TS.                  
A04670     IF WS-AH-AVAIL-FL = 'Y'                                      
A04670         MOVE 'Y' TO S-RANGE-AVAIL-FL                             
A04670     ELSE                                                         
A04670         MOVE 'N' TO S-RANGE-AVAIL-FL
           END-IF.                            
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
A04670 2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * RUNNING COUNT OF ORDERS AND TOTAL RES IN MINUTES                        
                                                                        
       2100-PROCESS-ORDERS.                                             
                                                                        
           ADD +1 TO WS-ORDER-CT.                                       
           COMPUTE WS-ORDER-MINUTES =                                   
                   T2-EST-RE (T2-INDEX) * 60.                           
           COMPUTE WS-TOTAL-MINUTES =                                   
                   WS-TOTAL-MINUTES +                                   
                   WS-ORDER-MINUTES.                                    
           IF T2-BEGIN-APPT-TS (T2-INDEX) > SPACES AND                  
              T2-END-APPT-TS (T2-INDEX) > SPACES                        
                  ADD +1 TO WS-APPOINTMENT-CT                           
                  PERFORM 2110-ACCUMULATE-APPTS THRU 2110-EXIT
           END-IF.         
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * RUNNING COUNT OF APPOINTMENTS, AND TOTAL RES IN MINUTES                 
      * WITHIN TIME PERIODS                                                     
      * DETERMINE IF COUNT AND MINUTES SHOULD BE SPLIT BETWEEN                  
      * TIME PERIODS                                                            
                                                                        
       2110-ACCUMULATE-APPTS.                                           
                                                                        
           IF T2-BEGIN-APPT-TS (T2-INDEX) < WS-STOP-SHIFT-AM-TM         
               ADD +1 TO WS-AM-APPT-CT                                  
               COMPUTE WS-AM-MINUTES = WS-AM-MINUTES +                  
                                       WS-ORDER-MINUTES                 
               IF T2-END-APPT-TS (T2-INDEX) > WS-START-SHIFT-PM-TM      
                   ADD +1 TO WS-PM-APPT-CT                              
                   MOVE 0 TO WS-TIME-DIFFERENCE                         
                   MOVE T2-END-APPT-TS (T2-INDEX) TO WS-TIMESTAMP       
                   EXEC SQL                                             
                       SELECT
              CIS.TIMESTAMPDIFF(4,CIS.DECIMAL2CHAR(                     
                              CIS.DIFFTIMESTAMP( CIS.CHAR2TIMESTAMP(
                                               :WS-START-SHIFT-PM-TM), 
           CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP) )))
            INTO
              :WS-TIME-DIFFERENCE :WS-NULL-DIFF          
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*            EXEC SQL                                                     
MFA-TR*                VALUES TIMESTAMPDIFF(4,CHAR(                             
MFA-TR*                       TIMESTAMP(:WS-START-SHIFT-PM-TM) -                
MFA-TR*                       TIMESTAMP(:WS-TIMESTAMP)))                        
MFA-TR*                  INTO :WS-TIME-DIFFERENCE:WS-NULL-DIFF                  
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   IF WS-NULL-DIFF < 0                                  
                       MOVE 0 TO WS-TIME-DIFFERENCE                     
                   END-IF                                               
                   COMPUTE WS-PM-MINUTES =                              
                           WS-PM-MINUTES + WS-TIME-DIFFERENCE           
                   COMPUTE WS-AM-MINUTES =                              
                           WS-AM-MINUTES - WS-TIME-DIFFERENCE           
               END-IF                                                   
               IF T2-END-APPT-TS (T2-INDEX) > WS-START-SHIFT-AH-TM      
                   ADD +1 TO WS-AH-APPT-CT                              
                   MOVE 0 TO WS-TIME-DIFFERENCE                         
                   MOVE T2-END-APPT-TS (T2-INDEX) TO WS-TIMESTAMP       
                   EXEC SQL                                             
                       SELECT
              CIS.TIMESTAMPDIFF(4,CIS.DECIMAL2CHAR(                     
                              CIS.DIFFTIMESTAMP( CIS.CHAR2TIMESTAMP(
                                               :WS-START-SHIFT-AH-TM), 
           CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP) )))
            INTO
              :WS-TIME-DIFFERENCE :WS-NULL-DIFF          
                   END-EXEC                                             

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*            EXEC SQL                                                     
MFA-TR*                VALUES TIMESTAMPDIFF(4,CHAR(                             
MFA-TR*                       TIMESTAMP(:WS-START-SHIFT-AH-TM) -                
MFA-TR*                       TIMESTAMP(:WS-TIMESTAMP)))                        
MFA-TR*                  INTO :WS-TIME-DIFFERENCE:WS-NULL-DIFF                  
MFA-TR*            END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                   IF WS-NULL-DIFF < 0                                  
                       MOVE 0 TO WS-TIME-DIFFERENCE                     
                   END-IF                                               
                   COMPUTE WS-AH-MINUTES =                              
                           WS-AH-MINUTES + WS-TIME-DIFFERENCE           
                   COMPUTE WS-PM-MINUTES =                              
                           WS-PM-MINUTES - WS-TIME-DIFFERENCE           
               END-IF                                                   
           ELSE                                                         
               IF T2-BEGIN-APPT-TS (T2-INDEX) < WS-STOP-SHIFT-PM-TM     
                   ADD +1 TO WS-PM-APPT-CT                              
                   COMPUTE WS-PM-MINUTES = WS-PM-MINUTES +              
                           WS-ORDER-MINUTES                             
                   IF T2-END-APPT-TS (T2-INDEX) > WS-START-SHIFT-AH-TM  
                       ADD +1 TO WS-AH-APPT-CT                          
                       MOVE 0 TO WS-TIME-DIFFERENCE                     
                       MOVE T2-END-APPT-TS (T2-INDEX) TO WS-TIMESTAMP   
                       EXEC SQL                                         
                           SELECT
              CIS.TIMESTAMPDIFF(4,CIS.DECIMAL2CHAR(                 
                                 CIS.DIFFTIMESTAMP( CIS.CHAR2TIMESTAMP(
                                               :WS-START-SHIFT-AH-TM), 
           CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP) )))
            INTO
              :WS-TIME-DIFFERENCE :WS-NULL-DIFF      
                       END-EXEC                                         

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ050
MFA-TR*                EXEC SQL                                                 
MFA-TR*                    VALUES TIMESTAMPDIFF(4,CHAR(                         
MFA-TR*                          TIMESTAMP(:WS-START-SHIFT-AH-TM) -             
MFA-TR*                          TIMESTAMP(:WS-TIMESTAMP)))                     
MFA-TR*                      INTO :WS-TIME-DIFFERENCE:WS-NULL-DIFF              
MFA-TR*                END-EXEC                                                 

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                       IF WS-NULL-DIFF < 0                              
                           MOVE 0 TO WS-TIME-DIFFERENCE                 
                       END-IF                                           
                       COMPUTE WS-AH-MINUTES =                          
                               WS-AH-MINUTES + WS-TIME-DIFFERENCE       
                       COMPUTE WS-PM-MINUTES =                          
                               WS-PM-MINUTES - WS-TIME-DIFFERENCE       
                   END-IF                                               
               ELSE                                                     
                   IF T2-BEGIN-APPT-TS (T2-INDEX) < WS-STOP-SHIFT-AH-TM 
                       ADD +1 TO WS-AH-APPT-CT                          
                       COMPUTE WS-AH-MINUTES =                          
                               WS-AH-MINUTES +                          
                               WS-ORDER-MINUTES
                   END-IF
               END-IF
           END-IF.                        
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * LOOP TO BUILD THE INTERVAL TABLE IN WORKING STORAGE (T1).               
      * ADD THE NUMBER OF MINUTES IN THE INTERVAL TO THE TIMESTAMP.             
      * IF THE RESULTING TS IN WITHIN THE AM TO AH RANGE, THE                   
      * INTERVAL IS POTENTIALLY VALID AND SHOULD BE MOVED TO THE TABLE.         
      * INTERVAL IS UNSHOWABLE IF NO AM/PM/AH APPTS ARE ALLOWED AND THE         
      * INTERVAL FALLS WITHIN THAT RANGE; OR IF THERE IS A BLOCK AND THE        
      * INTERVAL FALLS WITHIN THE BLOCK RANGE.                                  
                                                                        
       2200-BUILD-INTERVALS.                                            
                                                                        
           MOVE 'N' TO WS-VALID-INTERVAL-FL.                            
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.TIMESTAMPADD(4, 
                                                       :I4-INTERVAL-NM,        
                      CIS.CHAR2TIMESTAMP(:WS-INTERVAL-TS)), 121), ' ', 
           '-'), ':', '.')
            INTO
              :WS-INTERVAL-TS                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES TIMESTAMPADD(4, :I4-INTERVAL-NM,                          
MFA-TR*               TIMESTAMP(:WS-INTERVAL-TS))                               
MFA-TR*          INTO :WS-INTERVAL-TS                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF WS-INTERVAL-TS >= WS-START-SHIFT-AM-TM AND                
              WS-INTERVAL-TS < WS-STOP-SHIFT-AH-TM                      
                  MOVE WS-INTERVAL-TS TO                                
                       T1-INTERVAL-TS (T1-INDEX)                        
                  MOVE 'Y' TO WS-VALID-INTERVAL-FL                      
                  MOVE 'Y' TO T1-AVAILABLE (T1-INDEX)                   
                              T1-SHOWABLE (T1-INDEX)                    
                  MOVE 'N' TO T1-MOVEABLE (T1-INDEX)                    
                              T1-FLOATER (T1-INDEX)                     
                  MOVE 0 TO T1-APPTS-THIS-INT (T1-INDEX)                
                  IF I4-SPEC-APPT-AM-FL = 'N' AND                       
                    (WS-INTERVAL-TS >= WS-START-SHIFT-AM-TM AND         
                     WS-INTERVAL-TS < WS-STOP-SHIFT-AM-TM)              
                         MOVE 'N' TO WS-VALID-INTERVAL-FL               
                  END-IF                                                
                  IF I4-SPEC-APPT-PM-FL = 'N' AND                       
                    (WS-INTERVAL-TS >= WS-START-SHIFT-PM-TM AND         
                     WS-INTERVAL-TS < WS-STOP-SHIFT-PM-TM)              
                         MOVE 'N' TO WS-VALID-INTERVAL-FL               
                  END-IF                                                
                  IF I4-SPEC-APPT-AH-FL = 'N' AND                       
                    (WS-INTERVAL-TS >= WS-START-SHIFT-AH-TM AND         
                     WS-INTERVAL-TS < WS-STOP-SHIFT-AH-TM)              
                         MOVE 'N' TO WS-VALID-INTERVAL-FL               
                  END-IF                                                
                  IF WS-PROCESS-BLOCK-FL = 'Y' AND                      
                    (WS-INTERVAL-TS >= WS-BLOCK-FROM-TIME AND           
                     WS-INTERVAL-TS <= WS-BLOCK-UNTIL-TIME)             
                         MOVE 'N' TO T1-SHOWABLE (T1-INDEX)             
                                     T1-AVAILABLE (T1-INDEX)            
                  END-IF                                                
                  IF WS-VALID-INTERVAL-FL = 'Y'                         
                      MOVE 'Y' TO T1-ALLOW-SPECIFIC-APPTS (T1-INDEX)    
                  ELSE                                                  
                      MOVE 'N' TO T1-ALLOW-SPECIFIC-APPTS (T1-INDEX)    
                                  T1-SHOWABLE (T1-INDEX)
                  END-IF
           END-IF.               
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PROCESS EXISTING ORDERS WITH APPOINTMENTS FOR THE ASSIGNED              
      * DATE. MARK INTERVALS AS UNSHOWABLE BASED ON DATA.                       
                                                                        
       2300-PROCESS-ORDERS.                                             
                                                                        
      * GET THE NUMBER OF INTERVALS NEEDED TO WORK THE ORDER. MUST BE           
      * A WHOLE NUMBER.                                                         
                                                                        
           COMPUTE WS-ORDER-MINUTES =                                   
                   T2-EST-RE (T2-INDEX) * 60.                           
           COMPUTE WS-INTERVALS-NEEDED =                                
                  WS-ORDER-MINUTES /                                    
                  I4-INTERVAL-NM.                                       
           EXEC SQL                                                     
               SELECT
              CEILING(:WS-INTERVALS-NEEDED)
            INTO
              :WS-INTERVALS-NEEDED-CEIL                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CEILING(:WS-INTERVALS-NEEDED)                             
MFA-TR*          INTO :WS-INTERVALS-NEEDED-CEIL                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      * GET THE NUMBER OF RES FOR THE ORDER. MUST BE A WHOLE NUMBER.            
      * CONVERT TO MINUTES. CALCULATE THE END TIME OF THE APPOINTMENT           
      * FROM THE START TIME AND THE RES IN MINUTES.                             
                                                                        
           MOVE T2-EST-RE (T2-INDEX) TO WS-EST-RE.                      
           EXEC SQL                                                     
               SELECT
              CEILING(:WS-EST-RE)
            INTO
              :WS-ORD-RE-CEIL                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES CEILING(:WS-EST-RE)                                       
MFA-TR*          INTO :WS-ORD-RE-CEIL                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           COMPUTE WS-ORD-RE-MIN =                                      
                   WS-ORD-RE-CEIL * 60.                                 
           MOVE T2-BEGIN-APPT-TS (T2-INDEX) TO WS-BEGIN-APPT-TS.        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.TIMESTAMPADD(4, 
                                                        :WS-ORD-RE-MIN,        
                      CIS.CHAR2TIMESTAMP(:WS-BEGIN-APPT-TS)), 121), 
           ' ', '-'), ':', '.')
            INTO
              :WS-CALCULATED-END-TS                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES TIMESTAMPADD(4, :WS-ORD-RE-MIN,                           
MFA-TR*               TIMESTAMP(:WS-BEGIN-APPT-TS))                             
MFA-TR*          INTO :WS-CALCULATED-END-TS                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      * FOR EXACT COMMITMENT APPOINTMENTS, MARK AS UNSHOWABLE IF                
      * NUMBER OF APPOINTMENTS PER INTERVAL >= NUMBER OF EMPLOYEES.             
                                                                        
           IF T2-APPT-AM-PM-CD (T2-INDEX) = 'N' OR 'O'                  
               PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL               
                               T1-INDEX > WS-INTERVALS-PER-DAY          
                   IF T1-INTERVAL-TS (T1-INDEX) <                       
                      T2-END-APPT-TS (T2-INDEX) AND                     
                      T1-INTERVAL-TS (T1-INDEX) >=                      
                      T2-BEGIN-APPT-TS (T2-INDEX)                       
                          ADD +1 TO T1-APPTS-THIS-INT (T1-INDEX)        
                          IF T1-APPTS-THIS-INT (T1-INDEX) >=            
                             I4-EMPLOYEE-QT                             
                                 MOVE 'N' TO T1-AVAILABLE (T1-INDEX)    
                                             T1-SHOWABLE (T1-INDEX)     
                          END-IF                                        
                   END-IF                                               
               END-PERFORM
           END-IF.                                             
                                                                        
      * INTERVAL CONTAINS FLOATING APPOINTMENTS                                 
                                                                        
           IF T2-APPT-AM-PM-CD (T2-INDEX) = 'F' OR 'A' OR 'P' OR 'E'    
               PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL               
                               T1-INDEX > WS-INTERVALS-PER-DAY          
                   IF T1-INTERVAL-TS (T1-INDEX) <                       
                      WS-CALCULATED-END-TS AND                          
                      T1-INTERVAL-TS (T1-INDEX) >=                      
                      T2-BEGIN-APPT-TS (T2-INDEX)                       
                          MOVE 'Y' TO T1-FLOATER (T1-INDEX)             
                          MOVE T2-BEGIN-APPT-TS (T2-INDEX) TO           
                               T1-EARLIEST-START (T1-INDEX)             
                          MOVE T2-END-APPT-TS (T2-INDEX) TO             
                               T1-LATEST-START (T1-INDEX)               
                          MOVE WS-INTERVALS-NEEDED-CEIL TO              
                               T1-NEEDED (T1-INDEX)                     
                          ADD +1 TO T1-APPTS-THIS-INT (T1-INDEX)        
                   END-IF                                               
               END-PERFORM
           END-IF.                                             
                                                                        
      * CHECK IF APPOINTMENTS SCHEDULED FOR THE INTERVAL HAVE                   
      * EXCEEDED APPOINTMENTS ALLOWED                                           
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL                   
                           T1-INDEX > WS-INTERVALS-PER-DAY              
               IF T1-APPTS-THIS-INT (T1-INDEX) < I4-MAX-INTERVAL-APPT   
                   MOVE 'Y' TO T1-AVAILABLE (T1-INDEX)                  
                               T1-SHOWABLE (T1-INDEX)                   
                   MOVE 'N' TO T1-FLOATER (T1-INDEX)                    
                   MOVE SPACES TO T1-EARLIEST-START (T1-INDEX)          
                                  T1-LATEST-START (T1-INDEX)            
                   MOVE 0 TO T1-NEEDED (T1-INDEX)                       
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * IF THE RE OF THE NEW APPOINTMENT <= THE RE OF THE FLOATING              
      * APPOINTMENT, AND THERE ARE INTERVALS THE FLOATER CAN FIT INTO,          
      * THE FLOATER IS MARKED AS AVAILABLE.                                     
                                                                        
       2400-MARK-FLOATERS.                                              
                                                                        
           MOVE 'N' TO WS-END-LOOP-FL.                                  
           COMPUTE WS-LAST-START-INTERVAL = (WS-INTERVALS-PER-DAY + 1) -
                                             T1-NEEDED (T1-INDEX).      
           PERFORM VARYING WS-SUB1 FROM T1-INDEX BY 1 UNTIL             
                   WS-SUB1 > WS-LAST-START-INTERVAL OR                  
                   WS-END-LOOP-FL = 'Y'                                 
               PERFORM 2410-CAN-APPT-MOVE-FORWARD THRU 2410-EXIT        
           END-PERFORM.                                                 
                                                                        
           IF WS-CAN-MOVE-FL = 'N'                                      
               MOVE 0 TO WS-SUB1                                        
                         WS-SUB2                                        
                         WS-SUB3                                        
                         WS-SUB4                                        
                         WS-SUB5                                        
               SET WS-SUB1 TO T1-INDEX                                  
               COMPUTE WS-SUB1 = WS-SUB1 - 1                            
               MOVE 'N' TO WS-END-LOOP-FL                               
               PERFORM VARYING WS-SUB2 FROM 1 BY 1 UNTIL                
                   WS-SUB2 >= WS-SUB1 OR                                
                   WS-END-LOOP-FL = 'Y'                                 
                       PERFORM 2420-CAN-APPT-MOVE-BACK THRU 2420-EXIT   
               END-PERFORM
           END-IF.                                             
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * SEE IF THE FLOATER CAN MOVE FORWARD.                                    
                                                                        
       2410-CAN-APPT-MOVE-FORWARD.                                      
                                                                        
           COMPUTE WS-CALC-LAST-INTERVAL = WS-SUB1 +                    
                             T1-NEEDED (T1-INDEX).                      
           IF WS-CALC-LAST-INTERVAL > WS-INTERVALS-PER-DAY              
               MOVE 'Y' TO WS-END-LOOP-FL                               
               GO TO 2410-EXIT
           END-IF.                                         
                                                                        
           COMPUTE WS-SUB2 = WS-SUB1 +                                  
                             T1-NEEDED (T1-INDEX).                      
           IF T1-INTERVAL-TS (WS-SUB2) > T1-LATEST-START (T1-INDEX)     
               MOVE 'Y' TO WS-END-LOOP-FL                               
               GO TO 2410-EXIT
           END-IF.                                         
           MOVE 'Y' TO WS-CAN-MOVE-FL.                                  
           COMPUTE WS-SUB5 = WS-SUB1 + 1.                               
           PERFORM VARYING WS-SUB3 FROM WS-SUB5 BY 1 UNTIL              
               WS-SUB3 >= WS-SUB2 OR                                    
               WS-CAN-MOVE-FL = 'N'                                     
                   IF T1-AVAILABLE (WS-SUB3) = 'N'                      
                       MOVE 'N' TO WS-CAN-MOVE-FL                       
                   END-IF                                               
           END-PERFORM.                                                 
           IF WS-CAN-MOVE-FL = 'Y'                                      
               COMPUTE WS-SUB4 = WS-SUB3 - T1-NEEDED (T1-INDEX)         
               MOVE T1-INTERVAL-TS (WS-SUB4) TO T1-MOVETO (T1-INDEX)    
               MOVE 'Y' TO T1-MOVEABLE (T1-INDEX)                       
               MOVE 'N' TO T1-AVAILABLE (T1-INDEX)                      
               MOVE 'Y' TO WS-END-LOOP-FL
           END-IF.                              
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * IF THE FLOATER CAN'T MOVE FORWARD, SEE IF IT CAN MOVE BACK.             
                                                                        
       2420-CAN-APPT-MOVE-BACK.                                         
                                                                        
           IF T1-EARLIEST-START (T1-INDEX) <= T1-INTERVAL-TS (WS-SUB2)  
               MOVE 'Y' TO WS-CAN-MOVE-FL                               
               COMPUTE WS-SUB4 = (WS-SUB2 +                             
                                  T1-NEEDED (T1-INDEX)) -               
                                  1                                     
               PERFORM VARYING WS-SUB3 FROM WS-SUB2 BY 1 UNTIL          
                   WS-SUB3 >= WS-SUB4 OR                                
                   WS-CAN-MOVE-FL = 'N'                                 
                       IF T1-AVAILABLE (WS-SUB3) = 'N'                  
                           MOVE 'N' TO WS-CAN-MOVE-FL                   
                       END-IF                                           
               END-PERFORM                                              
               IF WS-CAN-MOVE-FL = 'Y'                                  
                   MOVE T1-INTERVAL-TS (WS-SUB2) TO T1-MOVETO (T1-INDEX)
                   MOVE 'Y' TO T1-MOVEABLE (T1-INDEX)                   
                   MOVE 'N' TO T1-AVAILABLE (T1-INDEX)                  
                   MOVE 'Y' TO WS-END-LOOP-FL
               END-IF
           END-IF.                          
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-MOVERS-AND-FLOATERS.                                        
                                                                        
           IF T1-FLOATER (T1-INDEX) = 'Y' AND                           
              T1-MOVEABLE (T1-INDEX) = 'Y'                              
                   IF WS-INTERVALS-NEEDED <= T1-NEEDED (T1-INDEX)       
                       MOVE 'Y' TO T1-SHOWABLE (T1-INDEX)               
                   ELSE                                                 
                       MOVE 'N' TO T1-SHOWABLE (T1-INDEX)               
                   END-IF                                               
            ELSE                                                        
                IF T1-AVAILABLE (T1-INDEX) = 'Y'                        
                    MOVE 'Y' TO WS-CAN-FIT-FL                           
                    SET WS-SUB2 TO T1-INDEX                             
                    COMPUTE WS-SUB3 = ((WS-SUB2 +                       
                                       WS-INTERVALS-NEEDED) - 1)        
                    PERFORM VARYING WS-SUB4 FROM WS-SUB2 BY 1 UNTIL     
                                    WS-SUB4 >= WS-SUB3 OR               
                                    WS-CAN-FIT-FL = 'N'                 
                        IF T1-AVAILABLE (WS-SUB4) = 'N'                 
                            MOVE 'N' TO WS-CAN-FIT-FL                   
                        END-IF                                          
                    END-PERFORM                                         
                    IF WS-CAN-FIT-FL = 'Y'                              
                        MOVE 'Y' TO T1-SHOWABLE (T1-INDEX)
                    END-IF
                END-IF
           END-IF.             
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-PERMISSIONS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) INTERVAL_NM,
              BY_START_TIME_FL,
              REPLACE(REPLACE(CONVERT(CHAR(26), START_TIME, 121), ' ', 
           '-'), ':', '.') START_TIME,
              BY_STOP_TIME_FL,
              REPLACE(REPLACE(CONVERT(CHAR(26), STOP_TIME, 121), ' ', 
           '-'), ':', '.') STOP_TIME,
              MAX_INT_APPT_FL,
              MAX_INTERVAL_APPT,
              MAX_DAILY_APPT_FL,
              MAX_DAILY_APPT,
              MAX_DAY_WK_REQ_FL,
              MAX_DAILY_WK_REQ,
              MAX_RE_PER_DAY_FL,
              MAX_RE_PER_DAY,
              REPLACE(REPLACE(CONVERT(CHAR(26), START_SHIFT_AM_TM
           , 121), ' ', '-'), ':', '.') START_SHIFT_AM_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), START_SHIFT_PM_TM
           , 121), ' ', '-'), ':', '.') START_SHIFT_PM_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), START_SHIFT_AH_TM
           , 121), ' ', '-'), ':', '.') START_SHIFT_AH_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), STOP_SHIFT_AM_TM, 121), 
           ' ', '-'), ':', '.') STOP_SHIFT_AM_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), STOP_SHIFT_PM_TM, 121), 
           ' ', '-'), ':', '.') STOP_SHIFT_PM_TM,
              REPLACE(REPLACE(CONVERT(CHAR(26), STOP_SHIFT_AH_TM, 121), 
           ' ', '-'), ':', '.') STOP_SHIFT_AH_TM,
              MAX_AM_APPT_QT,
              MAX_PM_APPT_QT,
              MAX_AH_APPT_QT,
              MAX_RE_AM_QT,
              MAX_RE_PM_QT,
              MAX_RE_AH_QT,
              SPEC_APPT_AM_FL,
              SPEC_APPT_PM_FL,
              SPEC_APPT_AH_FL,
              EMPLOYEE_QT                                       
                 INTO :I4-INTERVAL-NM,                                  
                      :I4-BY-START-TIME-FL,                             
                      :I4-START-TIME,                                   
                      :I4-BY-STOP-TIME-FL,                              
                      :I4-STOP-TIME,                                    
                      :I4-MAX-INT-APPT-FL,                              
                      :I4-MAX-INTERVAL-APPT,                            
                      :I4-MAX-DAILY-APPT-FL,                            
                      :I4-MAX-DAILY-APPT,                               
                      :I4-MAX-DAY-WK-REQ-FL,                            
                      :I4-MAX-DAILY-WK-REQ,                             
                      :I4-MAX-RE-PER-DAY-FL,                            
                      :I4-MAX-RE-PER-DAY,                               
                      :I4-START-SHIFT-AM-TM,                            
                      :I4-START-SHIFT-PM-TM,                            
                      :I4-START-SHIFT-AH-TM,                            
                      :I4-STOP-SHIFT-AM-TM,                             
                      :I4-STOP-SHIFT-PM-TM,                             
                      :I4-STOP-SHIFT-AH-TM,                             
                      :I4-MAX-AM-APPT-QT,                               
                      :I4-MAX-PM-APPT-QT,                               
                      :I4-MAX-AH-APPT-QT,                               
                      :I4-MAX-RE-AM-QT,                                 
                      :I4-MAX-RE-PM-QT,                                 
                      :I4-MAX-RE-AH-QT,                                 
                      :I4-SPEC-APPT-AM-FL,                              
                      :I4-SPEC-APPT-PM-FL,                              
                      :I4-SPEC-APPT-AH-FL,                              
                      :I4-EMPLOYEE-QT                                   
                 FROM CSS_WKAREA_PRMSSN WITH(READUNCOMMITTED)                   
                WHERE WORK_AREA_ID = :I4-WORK-AREA-ID                   
                  AND BLOCK_TYPE_ID = :I4-BLOCK-TYPE-ID                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT INTERVAL_NM,                                              
MFA-TR*               BY_START_TIME_FL,                                         
MFA-TR*               START_TIME,                                               
MFA-TR*               BY_STOP_TIME_FL,                                          
MFA-TR*               STOP_TIME,                                                
MFA-TR*               MAX_INT_APPT_FL,                                          
MFA-TR*               MAX_INTERVAL_APPT,                                        
MFA-TR*               MAX_DAILY_APPT_FL,                                        
MFA-TR*               MAX_DAILY_APPT,                                           
MFA-TR*               MAX_DAY_WK_REQ_FL,                                        
MFA-TR*               MAX_DAILY_WK_REQ,                                         
MFA-TR*               MAX_RE_PER_DAY_FL,                                        
MFA-TR*               MAX_RE_PER_DAY,                                           
MFA-TR*               START_SHIFT_AM_TM,                                        
MFA-TR*               START_SHIFT_PM_TM,                                        
MFA-TR*               START_SHIFT_AH_TM,                                        
MFA-TR*               STOP_SHIFT_AM_TM,                                         
MFA-TR*               STOP_SHIFT_PM_TM,                                         
MFA-TR*               STOP_SHIFT_AH_TM,                                         
MFA-TR*               MAX_AM_APPT_QT,                                           
MFA-TR*               MAX_PM_APPT_QT,                                           
MFA-TR*               MAX_AH_APPT_QT,                                           
MFA-TR*               MAX_RE_AM_QT,                                             
MFA-TR*               MAX_RE_PM_QT,                                             
MFA-TR*               MAX_RE_AH_QT,                                             
MFA-TR*               SPEC_APPT_AM_FL,                                          
MFA-TR*               SPEC_APPT_PM_FL,                                          
MFA-TR*               SPEC_APPT_AH_FL,                                          
MFA-TR*               EMPLOYEE_QT                                               
MFA-TR*          INTO :I4-INTERVAL-NM,                                          
MFA-TR*               :I4-BY-START-TIME-FL,                                     
MFA-TR*               :I4-START-TIME,                                           
MFA-TR*               :I4-BY-STOP-TIME-FL,                                      
MFA-TR*               :I4-STOP-TIME,                                            
MFA-TR*               :I4-MAX-INT-APPT-FL,                                      
MFA-TR*               :I4-MAX-INTERVAL-APPT,                                    
MFA-TR*               :I4-MAX-DAILY-APPT-FL,                                    
MFA-TR*               :I4-MAX-DAILY-APPT,                                       
MFA-TR*               :I4-MAX-DAY-WK-REQ-FL,                                    
MFA-TR*               :I4-MAX-DAILY-WK-REQ,                                     
MFA-TR*               :I4-MAX-RE-PER-DAY-FL,                                    
MFA-TR*               :I4-MAX-RE-PER-DAY,                                       
MFA-TR*               :I4-START-SHIFT-AM-TM,                                    
MFA-TR*               :I4-START-SHIFT-PM-TM,                                    
MFA-TR*               :I4-START-SHIFT-AH-TM,                                    
MFA-TR*               :I4-STOP-SHIFT-AM-TM,                                     
MFA-TR*               :I4-STOP-SHIFT-PM-TM,                                     
MFA-TR*               :I4-STOP-SHIFT-AH-TM,                                     
MFA-TR*               :I4-MAX-AM-APPT-QT,                                       
MFA-TR*               :I4-MAX-PM-APPT-QT,                                       
MFA-TR*               :I4-MAX-AH-APPT-QT,                                       
MFA-TR*               :I4-MAX-RE-AM-QT,                                         
MFA-TR*               :I4-MAX-RE-PM-QT,                                         
MFA-TR*               :I4-MAX-RE-AH-QT,                                         
MFA-TR*               :I4-SPEC-APPT-AM-FL,                                      
MFA-TR*               :I4-SPEC-APPT-PM-FL,                                      
MFA-TR*               :I4-SPEC-APPT-AH-FL,                                      
MFA-TR*               :I4-EMPLOYEE-QT                                           
MFA-TR*          FROM CSS_WKAREA_PRMSSN                                         
MFA-TR*         WHERE WORK_AREA_ID = :I4-WORK-AREA-ID                           
MFA-TR*           AND BLOCK_TYPE_ID = :I4-BLOCK-TYPE-ID                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF I4-MAX-INT-APPT-FL = 'Y'                          
                       CONTINUE                                         
                   ELSE                                                 
                       MOVE 1 TO I4-MAX-INTERVAL-APPT                   
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_WKAREA_PRMSSN' TO TABLE-1                  
                   MOVE 'WORK_AREA_ID'   TO TABLE-ELEMENT-1             
                   MOVE I4-WORK-AREA-ID  TO HOSTVAR-ELEMENT-1           
                   MOVE 'BLOCK_TYPE_ID'  TO TABLE-ELEMENT-2             
                   MOVE I4-BLOCK-TYPE-ID TO HOSTVAR-ELEMENT-2           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7013-RULE-XREF.                                                  
                                                                        
           MOVE S-BUS-RULE-ID TO 1T-BUS-RULE-ID.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                    
               WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                   
                 AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                
                 AND APPLICATION_ID = 'CSR'                             
                 AND COMPANY_NO     = '00'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE_XREF                                          
MFA-TR*        WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                           
MFA-TR*          AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                        
MFA-TR*          AND APPLICATION_ID = 'CSR'                                     
MFA-TR*          AND COMPANY_NO     = '00'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7013                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID       
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BUS-RULE-XREF-ID                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7013'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_RULE_XREF' TO TABLE-1                  
                   MOVE 'BUS_RULE_ID'       TO TABLE-ELEMENT-1          
                   MOVE 1T-BUS-RULE-ID      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7013-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CHECK-HOLIDAY.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HOLIDAY_DT                                        
                 INTO :J8-HOLIDAY-DT                                    
                 FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                         
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-PROCESS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PROCESS-DATE
              ) <> 0) OR (LEN(:WS-PROCESS-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-PROCESS-DATE
              ), CONVERT(DATE, :WS-PROCESS-DATE) )                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOLIDAY_DT                                                
MFA-TR*          INTO :J8-HOLIDAY-DT                                            
MFA-TR*          FROM CSS_HOLIDAY                                               
MFA-TR*         WHERE HOLIDAY_DT = :WS-PROCESS-DATE                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE '8' TO WS-BLOCK-ID-TYPE                         
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_HOLIDAY'    TO TABLE-1                     
                   MOVE 'HOLIDAY_DT'     TO TABLE-ELEMENT-1             
                   MOVE J8-HOLIDAY-DT    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-BLOCKS.                                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           H5.BLOCK_FROM_TIME, 121), ' ', '-'), ':', '.') 
           BLOCK_FROM_TIME,
              REPLACE(REPLACE(CONVERT(CHAR(26), H5.BLOCK_UNTIL_TIME
           , 121), ' ', '-'), ':', '.') BLOCK_UNTIL_TIME,
              REPLACE(REPLACE(CONVERT(CHAR(26), H5.BLOCK_EFF_DATE
           , 121), ' ', '-'), ':', '.') BLOCK_EFF_DATE,
              REPLACE(REPLACE(CONVERT(CHAR(26), H5.BLOCK_EXP_DATE
           , 121), ' ', '-'), ':', '.') BLOCK_EXP_DATE,
              H7.BLOCK_NA,
              H7.BLOCK_TX                                       
                INTO :H5-BLOCK-FROM-TIME,                               
                     :H5-BLOCK-UNTIL-TIME,                              
                     :H5-BLOCK-EFF-DATE,                                
                     :H5-BLOCK-EXP-DATE,                                
                     :H7-BLOCK-NA,                                      
                     :H7-BLOCK-TX                                       
                 FROM CSS_WKAREA_BLOCK H5 WITH(READUNCOMMITTED),                
                      CSS_BLOCK_ID H7 WITH(READUNCOMMITTED)                     
                WHERE H5.WORK_AREA_ID = :H5-WORK-AREA-ID                
                  AND BLOCK_TYPE_ID = :H7-BLOCK-TYPE-ID                 
                  AND H5.BLOCK_ID = H7.BLOCK_ID                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT H5.BLOCK_FROM_TIME,                                       
MFA-TR*               H5.BLOCK_UNTIL_TIME,                                      
MFA-TR*               H5.BLOCK_EFF_DATE,                                        
MFA-TR*               H5.BLOCK_EXP_DATE,                                        
MFA-TR*               H7.BLOCK_NA,                                              
MFA-TR*               H7.BLOCK_TX                                               
MFA-TR*         INTO :H5-BLOCK-FROM-TIME,                                       
MFA-TR*              :H5-BLOCK-UNTIL-TIME,                                      
MFA-TR*              :H5-BLOCK-EFF-DATE,                                        
MFA-TR*              :H5-BLOCK-EXP-DATE,                                        
MFA-TR*              :H7-BLOCK-NA,                                              
MFA-TR*              :H7-BLOCK-TX                                               
MFA-TR*          FROM CSS_WKAREA_BLOCK H5,                                      
MFA-TR*               CSS_BLOCK_ID H7                                           
MFA-TR*         WHERE H5.WORK_AREA_ID = :H5-WORK-AREA-ID                        
MFA-TR*           AND BLOCK_TYPE_ID = :H7-BLOCK-TYPE-ID                         
MFA-TR*           AND H5.BLOCK_ID = H7.BLOCK_ID                                 
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-BLOCK-FOUND-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-BLOCK-FOUND-FL                        
                   MOVE '1900-01-01-00.00.00.000000' TO                 
                                  H5-BLOCK-FROM-TIME                    
                                  H5-BLOCK-UNTIL-TIME                   
                                  H5-BLOCK-EFF-DATE                     
                                  H5-BLOCK-EXP-DATE                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_WKAREA_BLOCK' TO TABLE-1                   
                   MOVE 'CSS_BLOCK_ID'     TO TABLE-2                   
                   MOVE 'WORK_AREA_ID'   TO TABLE-ELEMENT-1             
                   MOVE H5-WORK-AREA-ID  TO HOSTVAR-ELEMENT-1           
                   MOVE 'BLOCK_TYPE_ID'  TO TABLE-ELEMENT-2             
                   MOVE H7-BLOCK-TYPE-ID TO HOSTVAR-ELEMENT-2           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-OPEN-SO-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN SO-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7300'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'WORK_AREA_ID'      TO TABLE-ELEMENT-1          
                   MOVE VO-WORK-AREA-ID     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-CLOSE-SO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE SO-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7310'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'WORK_AREA_ID'      TO TABLE-ELEMENT-1          
                   MOVE VO-WORK-AREA-ID     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04487_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04487_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8002'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04487_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04487_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04487_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8002'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04487_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04487_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04487_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8003'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04487_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04487_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              BUS_RULE_ID,                                              
              RULE_RESULT_CD,                                           
              BUS_RULE_XREF_ID                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-BUS-RULE-ID,                                          
               :S-RULE-RESULT-CD,                                       
               :S-BUS-RULE-XREF-ID                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04487_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       RULE_RESULT_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-BUS-RULE-ID,                                                  
MFA-TR*        :S-RULE-RESULT-CD,                                               
MFA-TR*        :S-BUS-RULE-XREF-ID                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04487_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04487_R2                            
             (                                                          
               RETURN_CODE,                                             
               INTERVAL_TS                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-INTERVAL-TS                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04487_R2                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        INTERVAL_TS                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-INTERVAL-TS                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04487_R2'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04487_R3                            
             (                                                          
               RETURN_CODE,                                             
               RANGE_CD,                                                
               RANGE_BEGIN_TS,                                          
               RANGE_END_TS,                                            
A04670         RANGE_AVAIL_FL                                           
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-RANGE-CD,                                             
               :S-RANGE-BEGIN-TS,                                       
               :S-RANGE-END-TS,                                         
A04670         :S-RANGE-AVAIL-FL                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04487_R3                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        RANGE_CD,                                                        
MFA-TR*        RANGE_BEGIN_TS,                                                  
MFA-TR*        RANGE_END_TS,                                                    
MFA-TR*        RANGE_AVAIL_FL                                                   
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-RANGE-CD,                                                     
MFA-TR*        :S-RANGE-BEGIN-TS,                                               
MFA-TR*        :S-RANGE-END-TS,                                                 
MFA-TR*        :S-RANGE-AVAIL-FL                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04487_R3'        TO TABLE-1                      
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
