       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04486.                                         
COB303 DATE-WRITTEN.      AUGUST 17, 2012.                              
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES CUSTOMER TELEPHONE, DOB, & EMAIL INFO.   *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  08/26/12  SC41135    SP  ORIGINALLY ADDED.                    *00290000
P00740*  03/19/14  FMB        CASA MODS.                               *00290000
P00740*  01/05/15  FMB        SPACE OUT DOB IF CURRENT DATE.           *00290000
P00740*  03/10/15  FMB        FORCE EMAIL ADDRESS TO LOWERCASE.        *00290000
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04486'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04486 STARTS HERE'.                  
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
           EXEC SQL                                                     00970000
              INCLUDE TBCUST                                            00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                             
              INCLUDE TBCNTACT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     00970000
              INCLUDE TBCSTPHN                                          00980000
           END-EXEC.                                                    00990000
           EXEC SQL                                                             
              INCLUDE TBCNTPHN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     01000000
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTHDPHO                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTHDPTY                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCAT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCCS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCNTCPR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                     01300000
              INCLUDE TBMODEL                                           01310000
           END-EXEC.                                                    01320000
           EXEC SQL                                                     01340000
              INCLUDE TBRSAREA                                          01350000
           END-EXEC.                                                    01360000
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
           EXEC SQL                                                     01420000
              INCLUDE TBUSRPRF                                          01430000
           END-EXEC.                                                    01440000
P00740     EXEC SQL                                                     01420000
P00740        INCLUDE TBCONEML                                          01430000
P00740     END-EXEC.                                                    01440000
P00740     EXEC SQL                                                     01420000
P00740        INCLUDE TBCONSTA                                          01430000
P00740     END-EXEC.                                                    01440000
P00740     EXEC SQL                                                     01420000
P00740        INCLUDE TBTHDEML                                          01430000
P00740     END-EXEC.                                                    01440000
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
           COPY CWS00027.                                               01560000
                                                                        
           EXEC SQL                                                     01590000
              INCLUDE CWS00013                                          01600000
           END-EXEC.                                                    01610000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-TRANS-APPL-NO         PIC S9(04) COMP VALUE 0.        
           05  WS-PREV-HOME-PHONE-NO    PIC X(10) VALUE SPACES.         
           05  WS-PREV-WORK-PHONE-NO    PIC X(10) VALUE SPACES.         
           05  WS-PREV-BUS-PHONE-NO     PIC X(10) VALUE SPACES.         
           05  WS-PREV-ALT-PHONE-NO     PIC X(10) VALUE SPACES.         
           05  WS-PREV-PHONE-NO         PIC X(10) VALUE SPACES.         
           05  WS-PREV-PHONE-TYPE       PIC X(02) VALUE SPACES.         
           05  WS-PREV-WORK-EXT         PIC X(06) VALUE SPACES.         
           05  WS-PREV-DOB              PIC X(10) VALUE SPACES.         
           05  WS-PREV-EMAIL-TEXT       PIC X(100) VALUE SPACES.        
           05  WS-HOME-PHONE-CHGD       PIC X(01) VALUE 'N'.            
           05  WS-WORK-PHONE-CHGD       PIC X(01) VALUE 'N'.            
           05  WS-BUS-PHONE-CHGD        PIC X(01) VALUE 'N'.            
           05  WS-ALT-PHONE-CHGD        PIC X(01) VALUE 'N'.            
           05  WS-CONTACT-TYPE          PIC X(02) VALUE SPACES.         
           05  WS-CONTACT-IND           PIC X(01) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04486'.     
           05  WS-NULL-IND-1            PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-1                PIC S9(04) COMP VALUE 0.        
           05  WS-EMAIL-TEXT            PIC X(100) VALUE SPACES.        
           05  WS-EMAIL-LEN             PIC 9(04).                      
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
P00740     05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
P00740     05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  RS-RETURN-CODE            PIC S9(9) COMP VALUE 0.        
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
           EXEC SQL DECLARE CUST-PHONE-CUR CURSOR FOR                   
                 SELECT PHONE_NO,                                       
                        EXTENSION_NO,                                   
                        PHONE_TYPE                                      
                   FROM CSS_CUST_PHONE                                  
                  WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                 
                    AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE CUST-PHONE-CUR CURSOR FOR                           
MFA-TR*          SELECT PHONE_NO,                                               
MFA-TR*                 EXTENSION_NO,                                           
MFA-TR*                 PHONE_TYPE                                              
MFA-TR*            FROM CSS_CUST_PHONE                                          
MFA-TR*           WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                         
MFA-TR*             AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                       
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE THD-PRTY-PHONE-CUR CURSOR FOR               
              SELECT PHONE_NO,                                          
                     EXTENSION_NO,                                      
                     PHONE_TYPE                                         
                FROM CSS_THD_PRTY_PHONE                                 
               WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE THD-PRTY-PHONE-CUR CURSOR FOR                       
MFA-TR*       SELECT PHONE_NO,                                                  
MFA-TR*              EXTENSION_NO,                                              
MFA-TR*              PHONE_TYPE                                                 
MFA-TR*         FROM CSS_THD_PRTY_PHONE                                         
MFA-TR*        WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                              
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE CONTACT-PHONE-CUR CURSOR FOR                
               SELECT PHONE_NO,                                         
                      EXTENSION_NO,                                     
                      PHONE_TYPE                                        
                 FROM CSS_CONTACT_PHONE                                 
                WHERE CONTACT_ID = :LP-CONTACT-ID                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL DECLARE CONTACT-PHONE-CUR CURSOR FOR                        
MFA-TR*        SELECT PHONE_NO,                                                 
MFA-TR*               EXTENSION_NO,                                             
MFA-TR*               PHONE_TYPE                                                
MFA-TR*          FROM CSS_CONTACT_PHONE                                         
MFA-TR*         WHERE CONTACT_ID = :LP-CONTACT-ID                               
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-ID           PIC X(10).                        
       01  LINK-CONTACT-TYPE          PIC X(02).                        
       01  LINK-HOME-PHONE-NO         PIC X(10).                        
       01  LINK-ALT-PHONE-NO          PIC X(10).                        
       01  LINK-BUS-PHONE-NO          PIC X(10).                        
       01  LINK-WORK-PHONE-NO         PIC X(10).                        
       01  LINK-WORK-PHONE-EXT        PIC X(06).                        
       01  LINK-DOB                   PIC X(10).                        
       01  LINK-EMAIL-TEXT            PIC X(100).                       
       01  LINK-USERID                PIC X(07).                        
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-ID,                                       
                LINK-CONTACT-TYPE,                                      
                LINK-HOME-PHONE-NO,                                     
                LINK-ALT-PHONE-NO,                                      
                LINK-BUS-PHONE-NO,                                      
                LINK-WORK-PHONE-NO,                                     
                LINK-WORK-PHONE-EXT,                                    
                LINK-DOB,                                               
                LINK-EMAIL-TEXT,                                        
                LINK-USERID.                                            
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
              SELECT :S-RETURN-CODE AS RETURN_CODE                      
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*       SELECT :S-RETURN-CODE AS RETURN_CODE                              
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
P00740     EXEC SQL                                                     
P00740          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740     EXEC SQL                                                     
P00740          SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
P00740     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-CUSTOMER-ID <= SPACES                                
               MOVE ZEROES TO LINK-CUSTOMER-ID
           END-IF.                         
           MOVE LINK-CUSTOMER-ID TO WS-CUSTOMER-NO-CHAR.                
                                                                        
           MOVE LINK-CONTACT-TYPE TO WS-CONTACT-TYPE.                   
P00740     IF LINK-DOB = WS-CURRENT-DATE                                
P00740         MOVE SPACES TO LINK-DOB
           END-IF.                                 
                                                                        
           IF LINK-EMAIL-TEXT = SPACES                                  
               MOVE 0 TO WS-EMAIL-LEN                                   
           ELSE                                                         
               STRING LINK-EMAIL-TEXT                                   
                      DELIMITED BY ' '                                  
                      INTO WS-EMAIL-TEXT                                
               INSPECT WS-EMAIL-TEXT                                    
                       TALLYING WS-EMAIL-LEN                            
                       FOR CHARACTERS BEFORE ' '
           END-IF.                       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE WS-CONTACT-TYPE                                     
               WHEN 'CU'                                                
               WHEN 'SP'                                                
               WHEN 'RO'                                                
               WHEN 'CO'                                                
                   PERFORM 2100-BUILD-CUSTOMER-RESULT THRU 2100-EXIT    
               WHEN 'TP'                                                
                   PERFORM 2200-BUILD-THD-PRTY-RESULT THRU 2200-EXIT    
               WHEN OTHER                                               
                   PERFORM 2300-BUILD-CONTACT-RESULT THRU 2300-EXIT     
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                 
                                         S-RETURN-CODE.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-BUILD-CUSTOMER-RESULT.                                      
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO CB-CUSTOMER-NO                    
                                      CU-CUSTOMER-NO                    
                                      CE-CUSTOMER-NO                    
P00740                                NE-CUSTOMER-NO.                   
           PERFORM 7000-VALIDATE-CUSTOMER THRU 7000-EXIT.               
                                                                        
           IF LINK-CONTACT-TYPE = 'SP'                                  
               MOVE 'S' TO CB-CUSTOMER-TYPE                             
                           CE-CUSTOMER-TYPE                             
P00740         MOVE 'S1' TO NE-EMAIL-TYPE-CD                            
           ELSE                                                         
               MOVE 'C' TO CB-CUSTOMER-TYPE                             
                           CE-CUSTOMER-TYPE                             
P00740         MOVE 'P1' TO NE-EMAIL-TYPE-CD
           END-IF.                           
           PERFORM 2110-PROCESS-UPDATE-CUST-PHONE THRU 2110-EXIT.       
           PERFORM 2120-PROCESS-UPDATE-CUST-DOB THRU 2120-EXIT.         
           PERFORM 2130-PROCESS-UPDATE-CUST-EMAIL THRU 2130-EXIT.       
           PERFORM 5100-FORMAT-MH THRU 5100-EXIT.                       
           PERFORM 5200-JRNL-INSERT THRU 5200-EXIT.                     
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-PROCESS-UPDATE-CUST-PHONE.                                  
                                                                        
            PERFORM 7050-OPEN-CUST-PHONE-CUR THRU 7050-EXIT.            
            PERFORM 7100-FETCH-CUST-PHONE-CUR THRU 7100-EXIT.           
            PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
                EVALUATE WS-PREV-PHONE-TYPE                             
                    WHEN 'H1'                                           
                        MOVE WS-PREV-PHONE-NO TO WS-PREV-HOME-PHONE-NO  
                        IF LINK-HOME-PHONE-NO <= ' '                    
                           MOVE WS-PREV-PHONE-NO TO CB-PHONE-NO         
                           PERFORM 8075-DELETE-CUST-PHONE THRU 8075-EXIT
                        ELSE                                            
                            IF LINK-HOME-PHONE-NO NOT = WS-PREV-PHONE-NO
                                MOVE LINK-HOME-PHONE-NO TO CB-PHONE-NO  
                                PERFORM 8050-UPDATE-CUST-PHONE THRU     
                                        8050-EXIT                       
                            END-IF                                      
                            MOVE 'Y' TO WS-HOME-PHONE-CHGD              
                        END-IF                                          
                    WHEN 'W1'                                           
                       MOVE WS-PREV-PHONE-NO TO WS-PREV-WORK-PHONE-NO   
                       IF LINK-WORK-PHONE-NO <= ' '                     
                           MOVE WS-PREV-PHONE-NO TO CB-PHONE-NO         
                           PERFORM 8075-DELETE-CUST-PHONE THRU 8075-EXIT
                       ELSE                                             
                         IF LINK-WORK-PHONE-NO NOT = WS-PREV-PHONE-NO OR
                            LINK-WORK-PHONE-EXT NOT = WS-PREV-WORK-EXT  
                                MOVE LINK-WORK-PHONE-NO TO CB-PHONE-NO  
                                MOVE LINK-WORK-PHONE-EXT TO             
                                     CB-EXTENSION-NO                    
                                PERFORM 8050-UPDATE-CUST-PHONE THRU     
                                        8050-EXIT                       
                         END-IF                                         
                         MOVE 'Y' TO WS-WORK-PHONE-CHGD                 
                       END-IF                                           
                    WHEN 'B1'                                           
                        MOVE WS-PREV-PHONE-NO TO WS-PREV-BUS-PHONE-NO   
                        IF LINK-BUS-PHONE-NO <= ' '                     
                           MOVE WS-PREV-PHONE-NO TO CB-PHONE-NO         
                           PERFORM 8075-DELETE-CUST-PHONE THRU 8075-EXIT
                        ELSE                                            
                           IF LINK-BUS-PHONE-NO NOT = WS-PREV-PHONE-NO  
                              MOVE LINK-BUS-PHONE-NO TO CB-PHONE-NO     
                              PERFORM 8050-UPDATE-CUST-PHONE THRU       
                                      8050-EXIT                         
                           END-IF                                       
                           MOVE 'Y' TO WS-BUS-PHONE-CHGD                
                        END-IF                                          
                    WHEN 'A1'                                           
                        MOVE WS-PREV-PHONE-NO TO WS-PREV-ALT-PHONE-NO   
                        IF LINK-ALT-PHONE-NO <= ' '                     
                           MOVE WS-PREV-PHONE-NO TO CB-PHONE-NO         
                           PERFORM 8075-DELETE-CUST-PHONE THRU 8075-EXIT
                        ELSE                                            
                            IF LINK-ALT-PHONE-NO NOT = WS-PREV-PHONE-NO 
                               MOVE LINK-ALT-PHONE-NO TO CB-PHONE-NO    
                               PERFORM 8050-UPDATE-CUST-PHONE THRU      
                                       8050-EXIT                        
                            END-IF                                      
                            MOVE 'Y' TO WS-ALT-PHONE-CHGD               
                        END-IF                                          
                END-EVALUATE                                            
                PERFORM 7100-FETCH-CUST-PHONE-CUR THRU 7100-EXIT        
            END-PERFORM.                                                
            PERFORM 7150-CLOSE-CUST-PHONE-CUR THRU 7150-EXIT.           
                                                                        
            IF LINK-HOME-PHONE-NO > ' ' AND                             
               WS-HOME-PHONE-CHGD = 'N'                                 
                   MOVE LINK-HOME-PHONE-NO TO CB-PHONE-NO               
                   MOVE 'H1' TO CB-PHONE-TYPE                           
                   MOVE SPACES TO CB-EXTENSION-NO                       
                   PERFORM 8000-INSERT-CUST-PHONE THRU 8000-EXIT
            END-IF.       
            IF LINK-WORK-PHONE-NO > ' ' AND                             
               WS-WORK-PHONE-CHGD = 'N'                                 
                   MOVE LINK-WORK-PHONE-NO TO CB-PHONE-NO               
                   MOVE LINK-WORK-PHONE-EXT TO CB-EXTENSION-NO          
                   MOVE 'W1' TO CB-PHONE-TYPE                           
                   PERFORM 8000-INSERT-CUST-PHONE THRU 8000-EXIT
            END-IF.       
            IF LINK-BUS-PHONE-NO > ' ' AND                              
               WS-BUS-PHONE-CHGD = 'N'                                  
                   MOVE LINK-BUS-PHONE-NO TO CB-PHONE-NO                
                   MOVE 'B1' TO CB-PHONE-TYPE                           
                   MOVE SPACES TO CB-EXTENSION-NO                       
                   PERFORM 8000-INSERT-CUST-PHONE THRU 8000-EXIT
            END-IF.       
            IF LINK-ALT-PHONE-NO > ' ' AND                              
               WS-ALT-PHONE-CHGD = 'N'                                  
                   MOVE LINK-ALT-PHONE-NO TO CB-PHONE-NO                
                   MOVE 'A1' TO CB-PHONE-TYPE                           
                   MOVE SPACES TO CB-EXTENSION-NO                       
                   PERFORM 8000-INSERT-CUST-PHONE THRU 8000-EXIT
            END-IF.       
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2120-PROCESS-UPDATE-CUST-DOB.                                    
                                                                        
             PERFORM 7010-SELECT-CUST-DTLS THRU 7010-EXIT.              
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND             
                LINK-DOB NOT = WS-PREV-DOB                              
                    PERFORM 8600-UPDATE-DATE-OF-BIRTH THRU 8600-EXIT    
             ELSE                                                       
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND               
                    LINK-DOB > SPACES                                   
                       PERFORM 8650-INSERT-DATE-OF-BIRTH THRU 8650-EXIT
                 END-IF
             END-IF.
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2130-PROCESS-UPDATE-CUST-EMAIL.                                  
                                                                        
            PERFORM 7020-SELECT-CUST-EMAIL THRU 7020-EXIT.              
            IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                    
               WS-EMAIL-LEN > 0                                         
                   PERFORM 8880-INSERT-CUST-EMAIL THRU 8880-EXIT        
            ELSE                                                        
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                    IF WS-EMAIL-LEN = 0 AND                             
                       NE-EMAIL-ADDRESS-TX-LEN > 0                      
                           PERFORM 8870-DELETE-CUST-EMAIL THRU 8870-EXIT
                    ELSE                                                
                        IF NE-EMAIL-ADDRESS-TX-TEXT                     
                           (1:NE-EMAIL-ADDRESS-TX-LEN) NOT =            
                            WS-EMAIL-TEXT(1:WS-EMAIL-LEN)               
                                PERFORM 8800-UPDATE-CUST-EMAIL THRU     
                                        8800-EXIT
                        END-IF
                    END-IF
                END-IF
            END-IF.                      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-BUILD-THD-PRTY-RESULT.                                      
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO ZW-THD-PRTY-ID                    
                                      ZY-THD-PRTY-ID                    
P00740                                3N-THD-PRTY-ID.                   
                                                                        
           PERFORM 7055-VALIDATE-THD-PRTY THRU 7055-EXIT.               
                                                                        
           PERFORM 2210-PROCESS-THD-PRTY-PHONE THRU 2210-EXIT.          
P00740     PERFORM 2220-PROCESS-UPDATE-3RD-DOB THRU 2220-EXIT.          
P00740     PERFORM 2230-PROCESS-UPDATE-3RD-EMAIL THRU 2230-EXIT.        
                                                                        
           PERFORM 5100-FORMAT-MH THRU 5100-EXIT.                       
           PERFORM 5200-JRNL-INSERT THRU 5200-EXIT.                     
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-PROCESS-THD-PRTY-PHONE.                                     
                                                                        
           PERFORM 7060-OPEN-THD-PRTY-PHONE-CUR THRU 7060-EXIT.         
           PERFORM 7110-FETCH-THD-PRTY-PHONE-CUR THRU 7110-EXIT.        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               EVALUATE WS-PREV-PHONE-TYPE                              
                   WHEN 'H1'                                            
                       MOVE WS-PREV-PHONE-NO TO WS-PREV-HOME-PHONE-NO   
                       IF LINK-HOME-PHONE-NO <= ' '                     
                           MOVE WS-PREV-PHONE-NO TO ZY-PHONE-NO         
                           PERFORM 8085-DELETE-THD-PRTY-PHONE THRU      
                                   8085-EXIT                            
                       ELSE                                             
                           IF LINK-HOME-PHONE-NO NOT = WS-PREV-PHONE-NO 
                               MOVE LINK-HOME-PHONE-NO TO ZY-PHONE-NO   
                               MOVE SPACES TO ZY-EXTENSION-NO           
                               PERFORM 8060-UPDATE-THD-PRTY-PHONE THRU  
                                       8060-EXIT                        
                           END-IF                                       
                           MOVE 'Y' TO WS-HOME-PHONE-CHGD               
                       END-IF                                           
P00740             WHEN 'A1'                                            
P00740                 MOVE WS-PREV-PHONE-NO TO WS-PREV-ALT-PHONE-NO    
P00740                 IF LINK-ALT-PHONE-NO <= ' '                      
P00740                     MOVE WS-PREV-PHONE-NO TO ZY-PHONE-NO         
P00740                     PERFORM 8085-DELETE-THD-PRTY-PHONE THRU      
P00740                             8085-EXIT                            
P00740                 ELSE                                             
P00740                     IF LINK-ALT-PHONE-NO NOT = WS-PREV-PHONE-NO  
P00740                         MOVE LINK-ALT-PHONE-NO TO ZY-PHONE-NO    
P00740                         MOVE SPACES TO ZY-EXTENSION-NO           
P00740                         PERFORM 8060-UPDATE-THD-PRTY-PHONE THRU  
P00740                                 8060-EXIT                        
P00740                     END-IF                                       
P00740                     MOVE 'Y' TO WS-ALT-PHONE-CHGD                
P00740                 END-IF                                           
P00740             WHEN 'B1'                                            
P00740                 MOVE WS-PREV-PHONE-NO TO WS-PREV-BUS-PHONE-NO    
P00740                 IF LINK-BUS-PHONE-NO <= ' '                      
P00740                     MOVE WS-PREV-PHONE-NO TO ZY-PHONE-NO         
P00740                     PERFORM 8085-DELETE-THD-PRTY-PHONE THRU      
P00740                             8085-EXIT                            
P00740                 ELSE                                             
P00740                     IF LINK-BUS-PHONE-NO NOT = WS-PREV-PHONE-NO  
P00740                         MOVE LINK-BUS-PHONE-NO TO ZY-PHONE-NO    
P00740                         MOVE SPACES TO ZY-EXTENSION-NO           
P00740                         PERFORM 8060-UPDATE-THD-PRTY-PHONE THRU  
P00740                                 8060-EXIT                        
P00740                     END-IF                                       
P00740                     MOVE 'Y' TO WS-BUS-PHONE-CHGD                
P00740                 END-IF                                           
                   WHEN 'W1'                                            
                       MOVE WS-PREV-PHONE-NO TO WS-PREV-WORK-PHONE-NO   
                       IF LINK-WORK-PHONE-NO <= ' '                     
                           MOVE WS-PREV-PHONE-NO TO ZY-PHONE-NO         
                           PERFORM 8085-DELETE-THD-PRTY-PHONE THRU      
                                   8085-EXIT                            
                       ELSE                                             
                         IF LINK-WORK-PHONE-NO NOT = WS-PREV-PHONE-NO OR
                            LINK-WORK-PHONE-EXT NOT = WS-PREV-WORK-EXT  
                                MOVE LINK-WORK-PHONE-NO TO ZY-PHONE-NO  
                                MOVE LINK-WORK-PHONE-EXT TO             
                                     ZY-EXTENSION-NO                    
                                PERFORM 8060-UPDATE-THD-PRTY-PHONE THRU 
                                        8060-EXIT                       
                         END-IF                                         
                         MOVE 'Y' TO WS-WORK-PHONE-CHGD                 
                       END-IF                                           
               END-EVALUATE                                             
               PERFORM 7110-FETCH-THD-PRTY-PHONE-CUR THRU 7110-EXIT     
           END-PERFORM.                                                 
           PERFORM 7160-CLOSE-THD-PRTY-PHONE-CUR THRU 7160-EXIT.        
                                                                        
           IF LINK-HOME-PHONE-NO > ' ' AND                              
              WS-HOME-PHONE-CHGD = 'N'                                  
                MOVE LINK-HOME-PHONE-NO TO ZY-PHONE-NO                  
                MOVE 'H1' TO ZY-PHONE-TYPE                              
                MOVE SPACES TO ZY-EXTENSION-NO                          
                PERFORM 8010-INSERT-THD-PRTY-PHONE THRU 8010-EXIT
           END-IF.      
           IF LINK-WORK-PHONE-NO > ' ' AND                              
              WS-WORK-PHONE-CHGD = 'N'                                  
                MOVE LINK-WORK-PHONE-NO TO ZY-PHONE-NO                  
                MOVE LINK-WORK-PHONE-EXT TO ZY-EXTENSION-NO             
                MOVE 'W1' TO ZY-PHONE-TYPE                              
                PERFORM 8010-INSERT-THD-PRTY-PHONE THRU 8010-EXIT
           END-IF.      
P00740     IF LINK-ALT-PHONE-NO > ' ' AND                               
P00740        WS-ALT-PHONE-CHGD = 'N'                                   
P00740          MOVE LINK-ALT-PHONE-NO TO ZY-PHONE-NO                   
P00740          MOVE SPACES TO ZY-EXTENSION-NO                          
P00740          MOVE 'A1' TO ZY-PHONE-TYPE                              
P00740          PERFORM 8010-INSERT-THD-PRTY-PHONE THRU 8010-EXIT
           END-IF.      
P00740     IF LINK-BUS-PHONE-NO > ' ' AND                               
P00740        WS-BUS-PHONE-CHGD = 'N'                                   
P00740          MOVE LINK-BUS-PHONE-NO TO ZY-PHONE-NO                   
P00740          MOVE SPACES TO ZY-EXTENSION-NO                          
P00740          MOVE 'B1' TO ZY-PHONE-TYPE                              
P00740          PERFORM 8010-INSERT-THD-PRTY-PHONE THRU 8010-EXIT
           END-IF.      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 2220-PROCESS-UPDATE-3RD-DOB.                                     
P00740                                                                  
P00740       IF LINK-DOB NOT = WS-PREV-DOB                              
P00740           PERFORM 8610-UPDATE-DATE-OF-BIRTH THRU 8610-EXIT
             END-IF.      
P00740                                                                  
P00740 2220-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2230-PROCESS-UPDATE-3RD-EMAIL.                                   
P00740                                                                  
P00740      PERFORM 7030-SELECT-3RD-EMAIL THRU 7030-EXIT.               
P00740      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                    
P00740         WS-EMAIL-LEN > 0                                         
P00740             PERFORM 8890-INSERT-3RD-EMAIL THRU 8890-EXIT         
P00740      ELSE                                                        
P00740          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
P00740              IF LINK-EMAIL-TEXT = SPACES AND                     
P00740                 3N-EMAIL-ADDRESS-TX > SPACES                     
P00740                     PERFORM 8875-DELETE-3RD-EMAIL THRU 8875-EXIT 
P00740              ELSE                                                
P00740                  IF 3N-EMAIL-ADDRESS-TX NOT = LINK-EMAIL-TEXT    
P00740                      PERFORM 8810-UPDATE-3RD-EMAIL THRU          
P00740                              8810-EXIT
                        END-IF
                    END-IF
                END-IF
            END-IF.                          
P00740                                                                  
P00740 2230-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       2300-BUILD-CONTACT-RESULT.                                       
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO CV-CONTACT-ID                     
                                      LP-CONTACT-ID                     
P00740                                3G-CONTACT-ID                     
P00740                                3H-CONTACT-ID.                    
                                                                        
           PERFORM 2310-PROCESS-CONTACT-PHONE THRU 2310-EXIT.           
P00740     PERFORM 2320-PROCESS-UPDATE-CONT-DOB THRU 2320-EXIT.         
P00740     PERFORM 2330-PROCESS-UPDATE-CONT-EMAIL THRU 2330-EXIT.       
                                                                        
           PERFORM 5100-FORMAT-MH THRU 5100-EXIT.                       
           PERFORM 5200-JRNL-INSERT THRU 5200-EXIT.                     
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-PROCESS-CONTACT-PHONE.                                      
                                                                        
           PERFORM 7070-OPEN-CONTACT-PHONE-CUR THRU 7070-EXIT.          
           PERFORM 7120-FETCH-CONTACT-PHONE-CUR THRU 7120-EXIT.         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               EVALUATE WS-PREV-PHONE-TYPE                              
                   WHEN 'H1'                                            
                       MOVE WS-PREV-PHONE-NO TO WS-PREV-HOME-PHONE-NO   
                       IF LINK-HOME-PHONE-NO <= ' '                     
                           MOVE WS-PREV-PHONE-NO TO LP-PHONE-NO         
                           PERFORM 8095-DELETE-CONTACT-PHONE THRU       
                                   8095-EXIT                            
                       ELSE                                             
                           IF LINK-HOME-PHONE-NO NOT = WS-PREV-PHONE-NO 
                               MOVE LINK-HOME-PHONE-NO TO LP-PHONE-NO   
                               PERFORM 8070-UPDATE-CONTACT-PHONE THRU   
                                       8070-EXIT                        
                           END-IF                                       
                           MOVE 'Y' TO WS-HOME-PHONE-CHGD               
                       END-IF                                           
                   WHEN 'W1'                                            
                       MOVE WS-PREV-PHONE-NO TO WS-PREV-WORK-PHONE-NO   
                       IF LINK-WORK-PHONE-NO <= ' '                     
                           MOVE WS-PREV-PHONE-NO TO LP-PHONE-NO         
                           PERFORM 8095-DELETE-CONTACT-PHONE THRU       
                                   8095-EXIT                            
                       ELSE                                             
                         IF LINK-WORK-PHONE-NO NOT = WS-PREV-PHONE-NO OR
                            LINK-WORK-PHONE-EXT NOT = WS-PREV-WORK-EXT  
                                 MOVE LINK-WORK-PHONE-NO TO LP-PHONE-NO 
                                 MOVE LINK-WORK-PHONE-EXT TO            
                                      LP-EXTENSION-NO                   
                                 PERFORM 8070-UPDATE-CONTACT-PHONE THRU 
                                         8070-EXIT                      
                         END-IF                                         
                         MOVE 'Y' TO WS-WORK-PHONE-CHGD                 
                       END-IF                                           
                   WHEN 'B1'                                            
                       MOVE WS-PREV-PHONE-NO TO WS-PREV-BUS-PHONE-NO    
                       IF LINK-BUS-PHONE-NO <= ' '                      
                           MOVE WS-PREV-PHONE-NO TO LP-PHONE-NO         
                           PERFORM 8095-DELETE-CONTACT-PHONE THRU       
                                   8095-EXIT                            
                       ELSE                                             
                           IF LINK-BUS-PHONE-NO NOT = WS-PREV-PHONE-NO  
                               MOVE LINK-BUS-PHONE-NO TO LP-PHONE-NO    
                               PERFORM 8070-UPDATE-CONTACT-PHONE THRU   
                                       8070-EXIT                        
                           END-IF                                       
                           MOVE 'Y' TO WS-BUS-PHONE-CHGD                
                       END-IF                                           
                   WHEN 'A1'                                            
                       MOVE WS-PREV-PHONE-NO TO WS-PREV-ALT-PHONE-NO    
                       IF LINK-ALT-PHONE-NO <= ' '                      
                           MOVE WS-PREV-PHONE-NO TO LP-PHONE-NO         
                           PERFORM 8095-DELETE-CONTACT-PHONE THRU       
                                   8095-EXIT                            
                       ELSE                                             
                           IF LINK-ALT-PHONE-NO NOT = WS-PREV-PHONE-NO  
                               MOVE LINK-ALT-PHONE-NO TO LP-PHONE-NO    
                               PERFORM 8070-UPDATE-CONTACT-PHONE THRU   
                                       8070-EXIT                        
                           END-IF                                       
                           MOVE 'Y' TO WS-ALT-PHONE-CHGD                
                       END-IF                                           
               END-EVALUATE                                             
               PERFORM 7120-FETCH-CONTACT-PHONE-CUR THRU 7120-EXIT      
           END-PERFORM.                                                 
           PERFORM 7170-CLOSE-CONTACT-PHONE-CUR THRU 7170-EXIT.         
                                                                        
           IF LINK-HOME-PHONE-NO > ' ' AND                              
              WS-HOME-PHONE-CHGD = 'N'                                  
                  MOVE LINK-HOME-PHONE-NO TO LP-PHONE-NO                
                  MOVE 'H1' TO LP-PHONE-TYPE                            
                  MOVE SPACES TO LP-EXTENSION-NO                        
                  PERFORM 8020-INSERT-CONTACT-PHONE THRU 8020-EXIT
           END-IF.     
           IF LINK-WORK-PHONE-NO > ' ' AND                              
              WS-WORK-PHONE-CHGD = 'N'                                  
                  MOVE LINK-WORK-PHONE-NO TO LP-PHONE-NO                
                  MOVE LINK-WORK-PHONE-EXT TO LP-EXTENSION-NO           
                  MOVE 'W1' TO LP-PHONE-TYPE                            
                  PERFORM 8020-INSERT-CONTACT-PHONE THRU 8020-EXIT
           END-IF.     
           IF LINK-BUS-PHONE-NO > ' ' AND                               
              WS-BUS-PHONE-CHGD = 'N'                                   
                  MOVE LINK-BUS-PHONE-NO TO LP-PHONE-NO                 
                  MOVE 'B1' TO LP-PHONE-TYPE                            
                  MOVE SPACES TO LP-EXTENSION-NO                        
                  PERFORM 8020-INSERT-CONTACT-PHONE THRU 8020-EXIT
           END-IF.     
           IF LINK-ALT-PHONE-NO > ' ' AND                               
              WS-ALT-PHONE-CHGD = 'N'                                   
                  MOVE LINK-ALT-PHONE-NO TO LP-PHONE-NO                 
                  MOVE 'A1' TO  LP-PHONE-TYPE                           
                  MOVE SPACES TO LP-EXTENSION-NO                        
                  PERFORM 8020-INSERT-CONTACT-PHONE THRU 8020-EXIT
           END-IF.     
                                                                        
           PERFORM 7330-GET-CONTACT-ACCT-IND THRU 7330-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               PERFORM 7340-GET-CONTACT-CUST-IND THRU 7340-EXIT         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   PERFORM 7345-GET-CONTACT-PREM-IND THRU 7345-EXIT
               END-IF
           END-IF.    
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 2320-PROCESS-UPDATE-CONT-DOB.                                    
P00740                                                                  
P00740       PERFORM 7015-SELECT-CONT-DTLS THRU 7015-EXIT.              
P00740       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND             
P00740          LINK-DOB NOT = WS-PREV-DOB                              
P00740              PERFORM 8620-UPDATE-DATE-OF-BIRTH THRU 8620-EXIT    
P00740       ELSE                                                       
P00740           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND               
P00740              LINK-DOB > SPACES                                   
P00740                 PERFORM 8660-INSERT-DATE-OF-BIRTH THRU 8660-EXIT
                 END-IF
             END-IF.
P00740                                                                  
P00740 2320-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 2330-PROCESS-UPDATE-CONT-EMAIL.                                  
P00740                                                                  
P00740      PERFORM 7040-SELECT-CONT-EMAIL THRU 7040-EXIT.              
P00740      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                    
P00740         LINK-EMAIL-TEXT > SPACES                                 
P00740             PERFORM 8910-INSERT-CONT-EMAIL THRU 8910-EXIT        
P00740      ELSE                                                        
P00740          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
P00740              IF LINK-EMAIL-TEXT = SPACES AND                     
P00740                 3G-EMAIL-ADDRESS-TX > SPACES                     
P00740                     PERFORM 8876-DELETE-CONT-EMAIL THRU 8876-EXIT
P00740              ELSE                                                
P00740                  IF 3G-EMAIL-ADDRESS-TX NOT = LINK-EMAIL-TEXT    
P00740                      PERFORM 8820-UPDATE-CONT-EMAIL THRU         
P00740                              8820-EXIT
                        END-IF
                    END-IF
                END-IF
            END-IF.                          
P00740                                                                  
P00740 2330-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       5100-FORMAT-MH.                                                  
                                                                        
           MOVE '5100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-DATE-TRANS = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           PERFORM 7200-RESP-AREA THRU 7200-EXIT.                       
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           EVALUATE LINK-CONTACT-TYPE                                   
              WHEN 'CU'                                                 
              WHEN 'SP'                                                 
              WHEN 'RO'                                                 
              WHEN 'CO'                                                 
                  MOVE CU-CUSTOMER-NO TO MH-CUSTOMER-NO                 
                  MOVE ZEROS          TO MH-PREMISE-NO                  
                  MOVE ZEROS          TO MH-ACCOUNT-NO                  
              WHEN 'TP'                                                 
                  MOVE ZW-ACCOUNT-NO  TO MH-ACCOUNT-NO                  
                  MOVE ZEROS          TO MH-PREMISE-NO                  
                  MOVE ZEROS          TO MH-CUSTOMER-NO                 
              WHEN OTHER                                                
                  EVALUATE WS-CONTACT-IND                               
                      WHEN 'A'                                          
                          MOVE DW-ACCOUNT-NO TO MH-ACCOUNT-NO           
                          MOVE ZEROS         TO MH-PREMISE-NO           
                          MOVE ZEROS         TO MH-CUSTOMER-NO          
                      WHEN 'P'                                          
                          MOVE DX-PREMISE-NO TO MH-PREMISE-NO           
                          MOVE ZEROS         TO MH-ACCOUNT-NO           
                          MOVE ZEROS         TO MH-CUSTOMER-NO          
                      WHEN 'C'                                          
                          MOVE DT-CUSTOMER-NO TO MH-CUSTOMER-NO         
                          MOVE ZEROS          TO MH-ACCOUNT-NO          
                          MOVE ZEROS          TO MH-PREMISE-NO          
                  END-EVALUATE                                          
           END-EVALUATE.                                                
           MOVE LINK-USERID              TO MH-USER-ID.                 
           EVALUATE WS-CONTACT-TYPE                                     
               WHEN 'CU'                                                
               WHEN 'RO'                                                
               WHEN 'CO'                                                
                   MOVE 'PANEL087' TO MH-APPL-PROGRAM-ID                
               WHEN 'TP'                                                
                   MOVE 'PANEL037' TO MH-APPL-PROGRAM-ID                
               WHEN 'SP'                                                
                   MOVE 'PANEL032' TO MH-APPL-PROGRAM-ID                
               WHEN OTHER                                               
                   MOVE 'PANEL433' TO MH-APPL-PROGRAM-ID                
           END-EVALUATE.                                                
           MOVE ' '                      TO MH-TRAN-COMMENT-TEXT.       
           MOVE 1                        TO MH-TRAN-COMMENT-LEN.        
           MOVE 1                        TO WS-TRANS-APPL-NO.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-JRNL-INSERT.                                                
                                                                        
           MOVE '5200'                TO ACTIVE-PARAGRAPH.              
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           IF LINK-HOME-PHONE-NO NOT =  WS-PREV-HOME-PHONE-NO           
               MOVE +10               TO MI-PRV-COLUMN-VALUE-LEN        
               MOVE +10               TO MI-CHG-COLUMN-VALUE-LEN        
               MOVE LINK-HOME-PHONE-NO TO MI-CHG-COLUMN-VALUE-TEXT      
               MOVE WS-PREV-HOME-PHONE-NO TO MI-PRV-COLUMN-VALUE-TEXT   
               IF MI-PRV-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*NEW*'  TO MI-PRV-COLUMN-VALUE-TEXT            
               END-IF                                                   
               IF MI-CHG-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               MOVE 'PRIMARY PHONE ' TO MI-COLUMN-DESC                  
               MOVE WS-TRANS-APPL-NO  TO MI-TRAN-APPL-NO                
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRANS-APPL-NO
           END-IF.                               
                                                                        
           IF LINK-BUS-PHONE-NO NOT = WS-PREV-BUS-PHONE-NO              
               MOVE +10               TO MI-PRV-COLUMN-VALUE-LEN        
               MOVE +10               TO MI-CHG-COLUMN-VALUE-LEN        
               MOVE LINK-BUS-PHONE-NO TO MI-CHG-COLUMN-VALUE-TEXT       
               MOVE WS-PREV-BUS-PHONE-NO TO MI-PRV-COLUMN-VALUE-TEXT    
               IF MI-PRV-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*NEW*'  TO MI-PRV-COLUMN-VALUE-TEXT            
               END-IF                                                   
               IF MI-CHG-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               MOVE 'BUSINESS PHONE ' TO MI-COLUMN-DESC                 
               MOVE WS-TRANS-APPL-NO  TO MI-TRAN-APPL-NO                
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRANS-APPL-NO
           END-IF.                               
                                                                        
           IF LINK-WORK-PHONE-NO NOT = WS-PREV-WORK-PHONE-NO            
               MOVE +10               TO MI-PRV-COLUMN-VALUE-LEN        
               MOVE +10               TO MI-CHG-COLUMN-VALUE-LEN        
               MOVE LINK-WORK-PHONE-NO TO MI-CHG-COLUMN-VALUE-TEXT      
               MOVE WS-PREV-WORK-PHONE-NO TO MI-PRV-COLUMN-VALUE-TEXT   
               IF MI-PRV-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*NEW*'  TO MI-PRV-COLUMN-VALUE-TEXT            
               END-IF                                                   
               IF MI-CHG-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               MOVE 'WORK PHONE ' TO MI-COLUMN-DESC                     
               MOVE WS-TRANS-APPL-NO  TO MI-TRAN-APPL-NO                
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRANS-APPL-NO
           END-IF.                               
                                                                        
           IF LINK-WORK-PHONE-EXT NOT =      WS-PREV-WORK-EXT           
               MOVE +06               TO MI-PRV-COLUMN-VALUE-LEN        
               MOVE +09               TO MI-CHG-COLUMN-VALUE-LEN        
               MOVE LINK-WORK-PHONE-EXT TO MI-CHG-COLUMN-VALUE-TEXT     
               MOVE WS-PREV-WORK-EXT     TO MI-PRV-COLUMN-VALUE-TEXT    
               IF MI-PRV-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*NEW*'  TO MI-PRV-COLUMN-VALUE-TEXT            
               END-IF                                                   
               IF MI-CHG-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               MOVE 'WORK PHONE EXT' TO MI-COLUMN-DESC                  
               MOVE WS-TRANS-APPL-NO  TO MI-TRAN-APPL-NO                
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRANS-APPL-NO
           END-IF.                               
                                                                        
           IF LINK-ALT-PHONE-NO NOT = WS-PREV-ALT-PHONE-NO              
               MOVE +10               TO MI-PRV-COLUMN-VALUE-LEN        
               MOVE +10               TO MI-CHG-COLUMN-VALUE-LEN        
               MOVE LINK-ALT-PHONE-NO TO MI-CHG-COLUMN-VALUE-TEXT       
               MOVE WS-PREV-ALT-PHONE-NO TO MI-PRV-COLUMN-VALUE-TEXT    
               IF MI-PRV-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*NEW*'  TO MI-PRV-COLUMN-VALUE-TEXT            
               END-IF                                                   
               IF MI-CHG-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               MOVE 'ALTERNATE PHONE ' TO MI-COLUMN-DESC                
               MOVE WS-TRANS-APPL-NO  TO MI-TRAN-APPL-NO                
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRANS-APPL-NO
           END-IF.                               
                                                                        
           IF LINK-DOB NOT = WS-PREV-DOB                                
               MOVE +10               TO MI-PRV-COLUMN-VALUE-LEN        
               MOVE +10               TO MI-CHG-COLUMN-VALUE-LEN        
               MOVE LINK-DOB TO MI-CHG-COLUMN-VALUE-TEXT                
               MOVE WS-PREV-DOB TO MI-PRV-COLUMN-VALUE-TEXT             
               IF MI-PRV-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*NEW*'  TO MI-PRV-COLUMN-VALUE-TEXT            
               END-IF                                                   
               IF MI-CHG-COLUMN-VALUE-TEXT = SPACES                     
                   MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT         
               END-IF                                                   
               MOVE 'DATE OF BIRTH ' TO MI-COLUMN-DESC                  
               MOVE WS-TRANS-APPL-NO  TO MI-TRAN-APPL-NO                
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
               ADD 1 TO WS-TRANS-APPL-NO
           END-IF.                               
                                                                        
           IF LINK-EMAIL-TEXT NOT = WS-PREV-EMAIL-TEXT                  
               IF WS-PREV-EMAIL-TEXT = SPACES                           
                   MOVE +5               TO MI-PRV-COLUMN-VALUE-LEN     
                   MOVE +75               TO MI-CHG-COLUMN-VALUE-LEN    
                   MOVE '*NEW*'  TO MI-PRV-COLUMN-VALUE-TEXT            
                   MOVE LINK-EMAIL-TEXT   TO MI-CHG-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   IF LINK-EMAIL-TEXT = SPACES                          
                       MOVE +75              TO MI-PRV-COLUMN-VALUE-LEN 
                       MOVE +9               TO MI-CHG-COLUMN-VALUE-LEN 
                       MOVE WS-PREV-EMAIL-TEXT TO                       
                            MI-PRV-COLUMN-VALUE-TEXT                    
                       MOVE '*DELETED*' TO MI-CHG-COLUMN-VALUE-TEXT     
                   ELSE                                                 
                       MOVE +75        TO MI-PRV-COLUMN-VALUE-LEN       
                       MOVE +75        TO MI-CHG-COLUMN-VALUE-LEN       
                       MOVE LINK-EMAIL-TEXT TO MI-CHG-COLUMN-VALUE-TEXT 
                       MOVE WS-PREV-EMAIL-TEXT TO                       
                            MI-PRV-COLUMN-VALUE-TEXT                    
                   END-IF                                               
               END-IF                                                   
               MOVE 'EMAIL  ' TO MI-COLUMN-DESC                         
               MOVE WS-TRANS-APPL-NO  TO MI-TRAN-APPL-NO                
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT
           END-IF.         
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-VALIDATE-CUSTOMER.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) NAME_ID                                            
                INTO :CU-NAME-ID                                        
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                     
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NAME_ID                                                    
MFA-TR*         INTO :CU-NAME-ID                                                
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO  = :CU-CUSTOMER-NO                             
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7000'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUSTOMER'   TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE CU-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-CUST-DTLS.                                           
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) DATE_OF_BIRTH                                    
                  INTO :CE-DATE-OF-BIRTH :WS-NULL-IND-1                  
                  FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                     
                 WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                  
                   AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT DATE_OF_BIRTH                                            
MFA-TR*           INTO :CE-DATE-OF-BIRTH:WS-NULL-IND-1                          
MFA-TR*           FROM CSS_CUST_STATS                                           
MFA-TR*          WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                          
MFA-TR*            AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                        
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7010                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            EVALUATE WS-ACTIVE-RETURN-CODE                              
              WHEN SUCCESSFUL-CALL                                      
                  IF WS-NULL-IND-1 < 0                                  
                      MOVE SPACES TO CE-DATE-OF-BIRTH                   
                  END-IF                                                
                  MOVE CE-DATE-OF-BIRTH TO WS-PREV-DOB                  
              WHEN NOT-FOUND                                            
                  CONTINUE                                              
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME     TO ABEND-PROGRAM                
                  MOVE '7010'           TO ACTIVE-PARAGRAPH             
                  MOVE 'SELECT'         TO ABEND-FUNCTION               
                  MOVE 'CSS_CUST_STATS' TO TABLE-1                      
                  MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1              
                  MOVE CE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1            
                  MOVE 'CUSTOMER_TYPE'  TO TABLE-ELEMENT-2              
                  MOVE CE-CUSTOMER-TYPE TO HOSTVAR-ELEMENT-2            
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
            END-EVALUATE.                                               
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-SELECT-CONT-DTLS.                                           
                                                                        
            EXEC SQL                                                    
                SELECT TOP(1) DATE_OF_BIRTH                                    
                  INTO :3H-DATE-OF-BIRTH :WS-NULL-IND-1                  
                  FROM CSS_CONTACT_STATS WITH(READUNCOMMITTED)                  
                 WHERE CONTACT_ID = :3H-CONTACT-ID                      
                                                    
                                                                 
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT DATE_OF_BIRTH                                            
MFA-TR*           INTO :3H-DATE-OF-BIRTH:WS-NULL-IND-1                          
MFA-TR*           FROM CSS_CONTACT_STATS                                        
MFA-TR*          WHERE CONTACT_ID = :3H-CONTACT-ID                              
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7015                                                    
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            EVALUATE WS-ACTIVE-RETURN-CODE                              
              WHEN SUCCESSFUL-CALL                                      
                  IF WS-NULL-IND-1 < 0                                  
                      MOVE SPACES TO 3H-DATE-OF-BIRTH                   
                  END-IF                                                
                  MOVE 3H-DATE-OF-BIRTH TO WS-PREV-DOB                  
              WHEN NOT-FOUND                                            
                  CONTINUE                                              
              WHEN OTHER                                                
                  MOVE PROGRAM-NAME     TO ABEND-PROGRAM                
                  MOVE '7015'           TO ACTIVE-PARAGRAPH             
                  MOVE 'SELECT'         TO ABEND-FUNCTION               
                  MOVE 'CSS_CONTACT_STATS' TO TABLE-1                   
                  MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1              
                  MOVE 3H-CONTACT-ID    TO HOSTVAR-ELEMENT-1            
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
            END-EVALUATE.                                               
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-CUST-EMAIL.                                          
                                                                        
            EXEC SQL                                                    
               SELECT TOP(1) EMAIL_ADDRESS_TX                                  
                 INTO :NE-EMAIL-ADDRESS-TX                              
                 FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                     
P00740            AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                 
                                          
                                                            
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT EMAIL_ADDRESS_TX                                          
MFA-TR*          INTO :NE-EMAIL-ADDRESS-TX                                      
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                             
MFA-TR*           AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY WITH UR                                 
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                MOVE NE-EMAIL-ADDRESS-TX-TEXT(1:NE-EMAIL-ADDRESS-TX-LEN)
                         TO WS-PREV-EMAIL-TEXT                          
              WHEN NOT-FOUND                                            
                   MOVE 0 TO NE-EMAIL-ADDRESS-TX-LEN                    
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7020'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE NE-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
P00740             MOVE 'EMAIL_TYPE_CD'  TO TABLE-ELEMENT-2             
P00740             MOVE NE-EMAIL-TYPE-CD TO HOSTVAR-ELEMENT-2           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 7030-SELECT-3RD-EMAIL.                                           
P00740                                                                  
P00740      EXEC SQL                                                    
P00740         SELECT TOP(1) EMAIL_ADDRESS_TX                                  
P00740           INTO :3N-EMAIL-ADDRESS-TX                              
P00740           FROM CSS_THD_PRTY_EMAIL WITH(READUNCOMMITTED)                  
P00740          WHERE THD_PRTY_ID = :3N-THD-PRTY-ID                     
P00740            AND EMAIL_TYPE_CD = 'T1'                              
P00740                                    
P00740                                                      
P00740      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT EMAIL_ADDRESS_TX                                          
MFA-TR*          INTO :3N-EMAIL-ADDRESS-TX                                      
MFA-TR*          FROM CSS_THD_PRTY_EMAIL                                        
MFA-TR*         WHERE THD_PRTY_ID = :3N-THD-PRTY-ID                             
MFA-TR*           AND EMAIL_TYPE_CD = 'T1'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY WITH UR                                 
MFA-TR*        QUERYNO 7030                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740        WHEN SUCCESSFUL-CALL                                      
P00740            MOVE 3N-EMAIL-ADDRESS-TX TO WS-PREV-EMAIL-TEXT        
P00740        WHEN NOT-FOUND                                            
P00740            MOVE SPACES TO WS-PREV-EMAIL-TEXT                     
P00740        WHEN OTHER                                                
P00740            MOVE PROGRAM-NAME     TO ABEND-PROGRAM                
P00740            MOVE '7030'           TO ACTIVE-PARAGRAPH             
P00740            MOVE 'SELECT'         TO ABEND-FUNCTION               
P00740            MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                  
P00740            MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1              
P00740            MOVE 3N-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1            
P00740            MOVE 'EMAIL_TYPE_CD'  TO TABLE-ELEMENT-2              
P00740            MOVE 'T1'             TO HOSTVAR-ELEMENT-2            
P00740            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
P00740            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7030-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 7040-SELECT-CONT-EMAIL.                                          
P00740                                                                  
P00740      EXEC SQL                                                    
P00740         SELECT TOP(1) EMAIL_ADDRESS_TX                                  
P00740           INTO :3G-EMAIL-ADDRESS-TX                              
P00740           FROM CSS_CONTACT_EMAIL WITH(READUNCOMMITTED)                   
P00740          WHERE CONTACT_ID = :3G-CONTACT-ID                       
P00740            AND EMAIL_TYPE_CD = 'N1'                              
P00740                                    
P00740                                                      
P00740      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT EMAIL_ADDRESS_TX                                          
MFA-TR*          INTO :3G-EMAIL-ADDRESS-TX                                      
MFA-TR*          FROM CSS_CONTACT_EMAIL                                         
MFA-TR*         WHERE CONTACT_ID = :3G-CONTACT-ID                               
MFA-TR*           AND EMAIL_TYPE_CD = 'N1'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY WITH UR                                 
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740        WHEN SUCCESSFUL-CALL                                      
P00740            MOVE 3G-EMAIL-ADDRESS-TX TO WS-PREV-EMAIL-TEXT        
P00740        WHEN NOT-FOUND                                            
P00740            MOVE SPACES TO WS-PREV-EMAIL-TEXT                     
P00740        WHEN OTHER                                                
P00740            MOVE PROGRAM-NAME     TO ABEND-PROGRAM                
P00740            MOVE '7040'           TO ACTIVE-PARAGRAPH             
P00740            MOVE 'SELECT'         TO ABEND-FUNCTION               
P00740            MOVE 'CSS_CONTACT_EMAIL' TO TABLE-1                   
P00740            MOVE 'CONTACT_ID'     TO TABLE-ELEMENT-1              
P00740            MOVE 3G-CONTACT-ID    TO HOSTVAR-ELEMENT-1            
P00740            MOVE 'EMAIL_TYPE_CD'  TO TABLE-ELEMENT-2              
P00740            MOVE 'N1'             TO HOSTVAR-ELEMENT-2            
P00740            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
P00740            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
P00740     END-EVALUATE.                                                
P00740                                                                  
P00740 7040-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       7050-OPEN-CUST-PHONE-CUR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN CUST-PHONE-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7050'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE  CB-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1         
P00740         MOVE 'CUSTOMER_TYPE'        TO TABLE-ELEMENT-2           
P00740         MOVE  CB-CUSTOMER-TYPE      TO HOSTVAR-ELEMENT-2         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7055-VALIDATE-THD-PRTY.                                          
                                                                        
           EXEC SQL                                                     
P00740        SELECT TOP(1) DATE_OF_BIRTH,
              ACCOUNT_NO                                         
P00740          INTO :ZW-DATE-OF-BIRTH :WS-NULL-IND-1,                   
P00740               :ZW-ACCOUNT-NO                                     
                FROM CSS_THD_PRTY WITH(READUNCOMMITTED)                         
               WHERE THD_PRTY_ID = :ZW-THD-PRTY-ID                      
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_OF_BIRTH,                                             
MFA-TR*              ACCOUNT_NO                                                 
MFA-TR*         INTO :ZW-DATE-OF-BIRTH:WS-NULL-IND-1,                           
MFA-TR*              :ZW-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_THD_PRTY                                               
MFA-TR*        WHERE THD_PRTY_ID = :ZW-THD-PRTY-ID                              
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7055                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-IND-1 < 0                                 
P00740                 MOVE SPACES TO ZW-DATE-OF-BIRTH                  
P00740             END-IF                                               
P00740             MOVE ZW-DATE-OF-BIRTH TO WS-PREV-DOB                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7055'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_THD_PRTY'   TO TABLE-1                     
                   MOVE 'THD_PRTY_ID'    TO TABLE-ELEMENT-1             
                   MOVE ZW-THD-PRTY-ID   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-OPEN-THD-PRTY-PHONE-CUR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN THD-PRTY-PHONE-CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7060'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_THD_PRTY_PHONE'   TO TABLE-1                   
               MOVE 'THD_PRTY_ID'          TO TABLE-ELEMENT-1           
               MOVE ZY-THD-PRTY-ID        TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-OPEN-CONTACT-PHONE-CUR.                                     
                                                                        
           EXEC SQL                                                     
              OPEN CONTACT-PHONE-CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7070'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CONTACT_PHONE'    TO TABLE-1                   
               MOVE 'CONTACT_ID'           TO TABLE-ELEMENT-1           
               MOVE LP-CONTACT-ID         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-FETCH-CUST-PHONE-CUR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH CUST-PHONE-CUR                                     
                INTO :CB-PHONE-NO,                                      
                     :CB-EXTENSION-NO,                                  
                     :CB-PHONE-TYPE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE CB-PHONE-TYPE TO WS-PREV-PHONE-TYPE                 
               MOVE CB-PHONE-NO TO WS-PREV-PHONE-NO                     
               MOVE CB-EXTENSION-NO TO WS-PREV-WORK-EXT
           END-IF.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE  CB-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-FETCH-THD-PRTY-PHONE-CUR.                                   
                                                                        
           EXEC SQL                                                     
               FETCH THD-PRTY-PHONE-CUR                                 
                INTO :ZY-PHONE-NO,                                      
                     :ZY-EXTENSION-NO,                                  
                     :ZY-PHONE-TYPE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE ZY-PHONE-TYPE TO WS-PREV-PHONE-TYPE                 
               MOVE ZY-EXTENSION-NO TO WS-PREV-WORK-EXT                 
               MOVE ZY-PHONE-NO TO WS-PREV-PHONE-NO
           END-IF.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7110'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_THD_PRTY_PHONE'   TO TABLE-1                   
               MOVE 'THD_PRTY_ID'          TO TABLE-ELEMENT-1           
               MOVE  ZY-THD-PRTY-ID        TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-FETCH-CONTACT-PHONE-CUR.                                    
                                                                        
           EXEC SQL                                                     
               FETCH CONTACT-PHONE-CUR                                  
                INTO :LP-PHONE-NO,                                      
                     :LP-EXTENSION-NO,                                  
                     :LP-PHONE-TYPE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE LP-PHONE-TYPE TO WS-PREV-PHONE-TYPE                 
               MOVE LP-EXTENSION-NO TO WS-PREV-WORK-EXT                 
               MOVE LP-PHONE-NO TO WS-PREV-PHONE-NO
           END-IF.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               CONTINUE                                                 
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'CSS_CONTACT_PHONE'   TO TABLE-1                    
               MOVE 'CONTACT_ID'           TO TABLE-ELEMENT-1           
               MOVE  LP-CONTACT-ID         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-CLOSE-CUST-PHONE-CUR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE CUST-PHONE-CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7150'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PHONE'       TO TABLE-1                   
               MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
               MOVE CB-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7160-CLOSE-THD-PRTY-PHONE-CUR.                                   
                                                                        
           EXEC SQL                                                     
               CLOSE THD-PRTY-PHONE-CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7160'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_THD_PRTY_PHONE'   TO TABLE-1                   
               MOVE 'THD_PRTY_ID'          TO TABLE-ELEMENT-1           
               MOVE ZY-THD-PRTY-ID         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-CLOSE-CONTACT-PHONE-CUR.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE CONTACT-PHONE-CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7170'                TO ACTIVE-PARAGRAPH           
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                     
               MOVE 'CONTACT_ID'           TO TABLE-ELEMENT-1           
               MOVE  LP-CONTACT-ID         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-RESP-AREA.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :LINK-USERID                             
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :LINK-USERID                                     
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE LINK-USERID           TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7330-GET-CONTACT-ACCT-IND.                                       
                                                                        
           MOVE LP-CONTACT-ID TO DW-CONTACT-ID.                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'A',
              ACCOUNT_NO                                         
                INTO :WS-CONTACT-IND,                                   
                     :DW-ACCOUNT-NO                                     
                FROM CSS_CONTACT_ACCT WITH(READUNCOMMITTED)                     
               WHERE CONTACT_ID = :DW-CONTACT-ID                        
                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'A',                                                       
MFA-TR*              ACCOUNT_NO                                                 
MFA-TR*         INTO :WS-CONTACT-IND,                                           
MFA-TR*              :DW-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_CONTACT_ACCT                                           
MFA-TR*        WHERE CONTACT_ID = :DW-CONTACT-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7330'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CONTACT_ACCT'   TO TABLE-1                     
               MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
               MOVE DW-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7340-GET-CONTACT-CUST-IND.                                       
                                                                        
           MOVE LP-CONTACT-ID TO DT-CONTACT-ID.                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'C',
              CUSTOMER_NO                                      
                 INTO :WS-CONTACT-IND,                                  
                      :DT-CUSTOMER-NO                                   
                 FROM CSS_CONTACT_CUST WITH(READUNCOMMITTED)                    
                WHERE CONTACT_ID = :DT-CONTACT-ID                       
                                          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'C',                                                      
MFA-TR*                CUSTOMER_NO                                              
MFA-TR*          INTO :WS-CONTACT-IND,                                          
MFA-TR*               :DT-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_CONTACT_CUST                                          
MFA-TR*         WHERE CONTACT_ID = :DT-CONTACT-ID                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7340'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                     
               MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
               MOVE DT-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7345-GET-CONTACT-PREM-IND.                                       
                                                                        
           MOVE LP-CONTACT-ID TO DX-CONTACT-ID.                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'P',
              PREMISE_NO                                        
                INTO :WS-CONTACT-IND,                                   
                     :DX-PREMISE-NO                                     
                FROM CSS_CONTACT_PREM WITH(READUNCOMMITTED)                     
               WHERE CONTACT_ID = :DX-CONTACT-ID                        
                                          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'P',                                                      
MFA-TR*               PREMISE_NO                                                
MFA-TR*         INTO :WS-CONTACT-IND,                                           
MFA-TR*              :DX-PREMISE-NO                                             
MFA-TR*         FROM CSS_CONTACT_PREM                                           
MFA-TR*        WHERE CONTACT_ID = :DX-CONTACT-ID                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY WITH UR                                  
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7345'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CONTACT_PREM'   TO TABLE-1                     
               MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
               MOVE DX-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7345-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-INSERT-CUST-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_PHONE                                
                   ( CUSTOMER_NO,                                       
                     CUSTOMER_TYPE,                                     
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO)                                      
              VALUES                                                    
                   (:CB-CUSTOMER-NO,                                    
                    :CB-CUSTOMER-TYPE,                                  
                    :CB-PHONE-TYPE,                                     
                    :CB-PHONE-NO,                                       
                    :CB-EXTENSION-NO)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8000'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_PHONE'     TO TABLE-1                     
               MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
               MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2             
               MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3             
               MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4             
               MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
               MOVE CB-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2           
               MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-3           
               MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-INSERT-THD-PRTY-PHONE.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_THD_PRTY_PHONE                            
                   ( THD_PRTY_ID,                                       
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO)                                      
              VALUES                                                    
                   (:ZY-THD-PRTY-ID,                                    
                    :ZY-PHONE-TYPE,                                     
                    :ZY-PHONE-NO,                                       
                    :ZY-EXTENSION-NO)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8010'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                     
               MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1             
               MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3             
               MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4             
               MOVE ZY-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1           
               MOVE ZY-PHONE-TYPE        TO HOSTVAR-ELEMENT-3           
               MOVE ZY-PHONE-NO          TO HOSTVAR-ELEMENT-4           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8020-INSERT-CONTACT-PHONE.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT_PHONE                             
                   ( CONTACT_ID,                                        
                     PHONE_TYPE,                                        
                     PHONE_NO,                                          
                     EXTENSION_NO)                                      
              VALUES                                                    
                   (:LP-CONTACT-ID,                                     
                    :LP-PHONE-TYPE,                                     
                    :LP-PHONE-NO,                                       
                    :LP-EXTENSION-NO)                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8020'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                     
               MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
               MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2             
               MOVE 'PHONE_NO'           TO TABLE-ELEMENT-3             
               MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
               MOVE LP-PHONE-TYPE        TO HOSTVAR-ELEMENT-2           
               MOVE LP-PHONE-NO          TO HOSTVAR-ELEMENT-3           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8050-UPDATE-CUST-PHONE.                                          
                                                                        
P00740     MOVE SPACES TO CB-PERMISN-TO-MKT-FL                          
P00740                    CB-PERMISN-TO-MKT-DT.                         
P00740     MOVE -1 TO WS-NULL-1.                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_PHONE                                     
                 SET PHONE_NO      = :CB-PHONE-NO,                      
                     EXTENSION_NO  = :CB-EXTENSION-NO,                  
P00740               PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,         
P00740               PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :CB-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:CB-PERMISN-TO-MKT-DT :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:CB-PERMISN-TO-MKT-DT :WS-NULL-1
              ), CONVERT(DATE, :CB-PERMISN-TO-MKT-DT :WS-NULL-1) )
               WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                    
                 AND PHONE_TYPE    = :CB-PHONE-TYPE                     
                 AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_PHONE                                             
MFA-TR*          SET PHONE_NO      = :CB-PHONE-NO,                              
MFA-TR*              EXTENSION_NO  = :CB-EXTENSION-NO,                          
MFA-TR*              PERMISN_TO_MKT_FL = :CB-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :CB-PERMISN-TO-MKT-DT:WS-NULL-1        
MFA-TR*        WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                            
MFA-TR*          AND PHONE_TYPE    = :CB-PHONE-TYPE                             
MFA-TR*          AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                          
MFA-TR*       QUERYNO 8050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8050'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_PHONE'     TO TABLE-1                     
               MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
               MOVE CB-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
               MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2             
               MOVE CB-PHONE-TYPE        TO HOSTVAR-ELEMENT-2           
               MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-3             
               MOVE CB-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-3           
               MOVE 'PHONE_NO'           TO TABLE-ELEMENT-4             
               MOVE CB-PHONE-NO          TO HOSTVAR-ELEMENT-4           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8060-UPDATE-THD-PRTY-PHONE.                                      
                                                                        
P00740     MOVE SPACES TO ZY-PERMISN-TO-MKT-FL                          
P00740                    ZY-PERMISN-TO-MKT-DT.                         
P00740     MOVE -1 TO WS-NULL-1.                                        
           EXEC SQL                                                     
              UPDATE CSS_THD_PRTY_PHONE                                 
                 SET PHONE_NO     = :ZY-PHONE-NO,                       
                     EXTENSION_NO = :ZY-EXTENSION-NO,                   
P00740               PERMISN_TO_MKT_FL = :ZY-PERMISN-TO-MKT-FL,         
P00740               PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :ZY-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :ZY-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:ZY-PERMISN-TO-MKT-DT :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:ZY-PERMISN-TO-MKT-DT :WS-NULL-1
              ), CONVERT(DATE, :ZY-PERMISN-TO-MKT-DT :WS-NULL-1) )
               WHERE THD_PRTY_ID  = :ZY-THD-PRTY-ID                     
                 AND PHONE_TYPE   = :ZY-PHONE-TYPE                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_THD_PRTY_PHONE                                         
MFA-TR*          SET PHONE_NO     = :ZY-PHONE-NO,                               
MFA-TR*              EXTENSION_NO = :ZY-EXTENSION-NO,                           
MFA-TR*              PERMISN_TO_MKT_FL = :ZY-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :ZY-PERMISN-TO-MKT-DT:WS-NULL-1        
MFA-TR*        WHERE THD_PRTY_ID  = :ZY-THD-PRTY-ID                             
MFA-TR*          AND PHONE_TYPE   = :ZY-PHONE-TYPE                              
MFA-TR*       QUERYNO 8060                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8060'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                     
               MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1             
               MOVE ZY-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1           
               MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2             
               MOVE ZY-PHONE-TYPE        TO HOSTVAR-ELEMENT-2           
               MOVE 'PHONE_NO'           TO TABLE-ELEMENT-3             
               MOVE ZY-PHONE-NO          TO HOSTVAR-ELEMENT-3           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8070-UPDATE-CONTACT-PHONE.                                       
                                                                        
P00740     MOVE SPACES TO LP-PERMISN-TO-MKT-FL                          
P00740                    LP-PERMISN-TO-MKT-DT.                         
P00740     MOVE -1 TO WS-NULL-1.                                        
           EXEC SQL                                                     
              UPDATE CSS_CONTACT_PHONE                                  
                 SET PHONE_NO     = :LP-PHONE-NO,                       
                     EXTENSION_NO = :LP-EXTENSION-NO,                   
P00740               PERMISN_TO_MKT_FL = :LP-PERMISN-TO-MKT-FL,         
P00740               PERMISN_TO_MKT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :LP-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-1
              ) IS NULL OR (PATINDEX('%.%', :LP-PERMISN-TO-MKT-DT 
                                                             :WS-NULL-1
              ) <> 0) OR (LEN(:LP-PERMISN-TO-MKT-DT :WS-NULL-1
              ) <> 10), CIS.CHAR2DATE(:LP-PERMISN-TO-MKT-DT :WS-NULL-1
              ), CONVERT(DATE, :LP-PERMISN-TO-MKT-DT :WS-NULL-1) )
               WHERE CONTACT_ID   = :LP-CONTACT-ID                      
                 AND PHONE_TYPE   = :LP-PHONE-TYPE                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT_PHONE                                          
MFA-TR*          SET PHONE_NO     = :LP-PHONE-NO,                               
MFA-TR*              EXTENSION_NO = :LP-EXTENSION-NO,                           
MFA-TR*              PERMISN_TO_MKT_FL = :LP-PERMISN-TO-MKT-FL,                 
MFA-TR*              PERMISN_TO_MKT_DT = :LP-PERMISN-TO-MKT-DT:WS-NULL-1        
MFA-TR*        WHERE CONTACT_ID   = :LP-CONTACT-ID                              
MFA-TR*          AND PHONE_TYPE   = :LP-PHONE-TYPE                              
MFA-TR*       QUERYNO 8070                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8070'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-2              
              MOVE LP-PHONE-TYPE        TO HOSTVAR-ELEMENT-2            
              MOVE 'PHONE_NO'           TO TABLE-ELEMENT-3              
              MOVE LP-PHONE-NO          TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8075-DELETE-CUST-PHONE.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_PHONE                                
               WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                    
                 AND PHONE_TYPE    = :CB-PHONE-TYPE                     
                 AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                  
                 AND PHONE_NO      = :CB-PHONE-NO                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_PHONE                                        
MFA-TR*        WHERE CUSTOMER_NO   = :CB-CUSTOMER-NO                            
MFA-TR*          AND PHONE_TYPE    = :CB-PHONE-TYPE                             
MFA-TR*          AND CUSTOMER_TYPE = :CB-CUSTOMER-TYPE                          
MFA-TR*          AND PHONE_NO      = :CB-PHONE-NO                               
MFA-TR*       QUERYNO 8075                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8075'          TO ACTIVE-PARAGRAPH             
                   MOVE 'DELETE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
                   MOVE CB-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
                   MOVE 'PHONE_TYPE'    TO TABLE-ELEMENT-2              
                   MOVE CB-PHONE-TYPE   TO HOSTVAR-ELEMENT-2            
                   MOVE 'CUSTOMER_TYPE' TO TABLE-ELEMENT-3              
                   MOVE CB-CUSTOMER-TYPE TO HOSTVAR-ELEMENT-3           
                   MOVE 'PHONE_NO'      TO TABLE-ELEMENT-4              
                   MOVE CB-PHONE-NO     TO HOSTVAR-ELEMENT-4            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8075-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8085-DELETE-THD-PRTY-PHONE.                                      
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_THD_PRTY_PHONE                            
               WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                      
                 AND PHONE_TYPE  = :ZY-PHONE-TYPE                       
                 AND PHONE_NO    = :ZY-PHONE-NO                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_THD_PRTY_PHONE                                    
MFA-TR*        WHERE THD_PRTY_ID = :ZY-THD-PRTY-ID                              
MFA-TR*          AND PHONE_TYPE  = :ZY-PHONE-TYPE                               
MFA-TR*          AND PHONE_NO    = :ZY-PHONE-NO                                 
MFA-TR*       QUERYNO 8085                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8085'          TO ACTIVE-PARAGRAPH             
                   MOVE 'DELETE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_THD_PRTY_PHONE' TO TABLE-1                 
                   MOVE 'THD_PRTY_ID'   TO TABLE-ELEMENT-1              
                   MOVE ZY-THD-PRTY-ID  TO HOSTVAR-ELEMENT-1            
                   MOVE 'PHONE_TYPE'    TO TABLE-ELEMENT-2              
                   MOVE ZY-PHONE-TYPE   TO HOSTVAR-ELEMENT-2            
                   MOVE 'PHONE_NO'      TO TABLE-ELEMENT-3              
                   MOVE ZY-PHONE-NO     TO HOSTVAR-ELEMENT-3            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8085-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8095-DELETE-CONTACT-PHONE.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CONTACT_PHONE                             
               WHERE CONTACT_ID = :LP-CONTACT-ID                        
                 AND PHONE_TYPE = :LP-PHONE-TYPE                        
                 AND PHONE_NO   = :LP-PHONE-NO                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_PHONE                                     
MFA-TR*        WHERE CONTACT_ID = :LP-CONTACT-ID                                
MFA-TR*          AND PHONE_TYPE = :LP-PHONE-TYPE                                
MFA-TR*          AND PHONE_NO   = :LP-PHONE-NO                                  
MFA-TR*       QUERYNO 8095                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE '8095'          TO ACTIVE-PARAGRAPH             
                   MOVE 'DELETE'        TO ABEND-FUNCTION               
                   MOVE 'CSS_CONTACT_PHONE' TO TABLE-1                  
                   MOVE 'CONTACT_ID'    TO TABLE-ELEMENT-1              
                   MOVE LP-CONTACT-ID   TO HOSTVAR-ELEMENT-1            
                   MOVE 'PHONE_TYPE'    TO TABLE-ELEMENT-2              
                   MOVE LP-PHONE-TYPE   TO HOSTVAR-ELEMENT-2            
                   MOVE 'PHONE_NO'      TO TABLE-ELEMENT-4              
                   MOVE LP-PHONE-NO     TO HOSTVAR-ELEMENT-4            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       8095-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-UPDATE-DATE-OF-BIRTH.                                       
                                                                        
           IF LINK-DOB > ' '                                            
               MOVE LINK-DOB TO CE-DATE-OF-BIRTH                        
               MOVE 0 TO WS-NULL-IND-1                                  
           ELSE                                                         
               MOVE SPACES TO CE-DATE-OF-BIRTH                          
               MOVE -1 TO WS-NULL-IND-1
           END-IF.                                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
                 SET DATE_OF_BIRTH = IIF(TRY_CONVERT(DATE, 
                                                     :CE-DATE-OF-BIRTH 
                                                         :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-IND-1
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-IND-1) )    
               WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                    
                 AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_STATS                                             
MFA-TR*          SET DATE_OF_BIRTH = :CE-DATE-OF-BIRTH:WS-NULL-IND-1            
MFA-TR*        WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                            
MFA-TR*          AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                          
MFA-TR*       QUERYNO 8600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8600'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_STATS'     TO TABLE-1                     
               MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
               MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
               MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2             
               MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2           
               MOVE 'DATE_OF_BIRTH'      TO TABLE-ELEMENT-3             
               MOVE CE-DATE-OF-BIRTH     TO HOSTVAR-ELEMENT-3           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 8610-UPDATE-DATE-OF-BIRTH.                                       
P00740                                                                  
P00740     IF LINK-DOB > ' '                                            
P00740         MOVE LINK-DOB TO ZW-DATE-OF-BIRTH                        
P00740         MOVE 0 TO WS-NULL-IND-1                                  
P00740     ELSE                                                         
P00740         MOVE SPACES TO ZW-DATE-OF-BIRTH                          
P00740         MOVE -1 TO WS-NULL-IND-1
           END-IF.                                
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        UPDATE CSS_THD_PRTY                                       
P00740           SET DATE_OF_BIRTH = IIF(TRY_CONVERT(DATE, 
                                                     :ZW-DATE-OF-BIRTH 
                                                         :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :ZW-DATE-OF-BIRTH 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:ZW-DATE-OF-BIRTH :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:ZW-DATE-OF-BIRTH :WS-NULL-IND-1
              ), CONVERT(DATE, :ZW-DATE-OF-BIRTH :WS-NULL-IND-1) )    
P00740         WHERE THD_PRTY_ID   = :ZW-THD-PRTY-ID                    
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_THD_PRTY                                               
MFA-TR*          SET DATE_OF_BIRTH = :ZW-DATE-OF-BIRTH:WS-NULL-IND-1            
MFA-TR*        WHERE THD_PRTY_ID   = :ZW-THD-PRTY-ID                            
MFA-TR*       QUERYNO 8610                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00740         MOVE '8610'               TO ACTIVE-PARAGRAPH            
P00740         MOVE 'UPDATE'             TO ABEND-FUNCTION              
P00740         MOVE 'CSS_THD_PRTY'      TO TABLE-1                      
P00740         MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1             
P00740         MOVE ZW-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'DATE_OF_BIRTH'      TO TABLE-ELEMENT-2             
P00740         MOVE ZW-DATE-OF-BIRTH     TO HOSTVAR-ELEMENT-2           
P00740         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00740         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
P00740                                                                  
P00740 8610-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 8620-UPDATE-DATE-OF-BIRTH.                                       
P00740                                                                  
P00740     IF LINK-DOB > ' '                                            
P00740         MOVE LINK-DOB TO 3H-DATE-OF-BIRTH                        
P00740         MOVE 0 TO WS-NULL-IND-1                                  
P00740     ELSE                                                         
P00740         MOVE SPACES TO 3H-DATE-OF-BIRTH                          
P00740         MOVE -1 TO WS-NULL-IND-1
           END-IF.                                
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        UPDATE CSS_CONTACT_STATS                                  
P00740           SET DATE_OF_BIRTH = IIF(TRY_CONVERT(DATE, 
                                                     :3H-DATE-OF-BIRTH 
                                                         :WS-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :3H-DATE-OF-BIRTH 
                                                         :WS-NULL-IND-1
              ) <> 0) OR (LEN(:3H-DATE-OF-BIRTH :WS-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:3H-DATE-OF-BIRTH :WS-NULL-IND-1
              ), CONVERT(DATE, :3H-DATE-OF-BIRTH :WS-NULL-IND-1) )    
P00740         WHERE CONTACT_ID    = :3H-CONTACT-ID                     
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT_STATS                                          
MFA-TR*          SET DATE_OF_BIRTH = :3H-DATE-OF-BIRTH:WS-NULL-IND-1            
MFA-TR*        WHERE CONTACT_ID    = :3H-CONTACT-ID                             
MFA-TR*       QUERYNO 8620                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00740         MOVE '8620'               TO ACTIVE-PARAGRAPH            
P00740         MOVE 'UPDATE'             TO ABEND-FUNCTION              
P00740         MOVE 'CSS_CONTACT_STATS'  TO TABLE-1                     
P00740         MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
P00740         MOVE 3H-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'DATE_OF_BIRTH'      TO TABLE-ELEMENT-2             
P00740         MOVE 3H-DATE-OF-BIRTH     TO HOSTVAR-ELEMENT-2           
P00740         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00740         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
P00740                                                                  
P00740 8620-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       8650-INSERT-DATE-OF-BIRTH.                                       
                                                                        
           MOVE LINK-DOB TO CE-DATE-OF-BIRTH.                           
           MOVE CU-NAME-ID TO CE-NAME-ID.                               
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                     (CUSTOMER_NO,                                      
                      NAME_ID,                                          
                      CUSTOMER_TYPE,                                    
                      DATE_OF_BIRTH                                     
                     )                                                  
              VALUES (:CE-CUSTOMER-NO,                                  
                      :CE-NAME-ID,                                      
                      :CE-CUSTOMER-TYPE,                                
                      IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH) <> 10), CIS.CHAR2DATE(
                                                      :CE-DATE-OF-BIRTH
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH) )                            
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_STATS                                        
MFA-TR*              (CUSTOMER_NO,                                              
MFA-TR*               NAME_ID,                                                  
MFA-TR*               CUSTOMER_TYPE,                                            
MFA-TR*               DATE_OF_BIRTH                                             
MFA-TR*              )                                                          
MFA-TR*       VALUES (:CE-CUSTOMER-NO,                                          
MFA-TR*               :CE-NAME-ID,                                              
MFA-TR*               :CE-CUSTOMER-TYPE,                                        
MFA-TR*               :CE-DATE-OF-BIRTH                                         
MFA-TR*              )                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8650'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_STATS'     TO TABLE-1                     
               MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
               MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
               MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2             
               MOVE CE-CUSTOMER-TYPE     TO HOSTVAR-ELEMENT-2           
               MOVE 'DATE_OF_BIRTH'      TO TABLE-ELEMENT-3             
               MOVE CE-DATE-OF-BIRTH     TO HOSTVAR-ELEMENT-3           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8650-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8660-INSERT-DATE-OF-BIRTH.                                       
                                                                        
           MOVE LINK-DOB TO 3H-DATE-OF-BIRTH.                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CONTACT_STATS                             
                     (CONTACT_ID,                                       
                      DATE_OF_BIRTH                                     
                     )                                                  
              VALUES (:3H-CONTACT-ID,                                   
                      IIF(TRY_CONVERT(DATE, :3H-DATE-OF-BIRTH
              ) IS NULL OR (PATINDEX('%.%', :3H-DATE-OF-BIRTH
              ) <> 0) OR (LEN(:3H-DATE-OF-BIRTH) <> 10), CIS.CHAR2DATE(
                                                      :3H-DATE-OF-BIRTH
              ), CONVERT(DATE, :3H-DATE-OF-BIRTH) )                            
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CONTACT_STATS                                     
MFA-TR*              (CONTACT_ID,                                               
MFA-TR*               DATE_OF_BIRTH                                             
MFA-TR*              )                                                          
MFA-TR*       VALUES (:3H-CONTACT-ID,                                           
MFA-TR*               :3H-DATE-OF-BIRTH                                         
MFA-TR*              )                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8660'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_CONTACT_STATS'  TO TABLE-1                     
               MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
               MOVE 3H-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
               MOVE 'DATE_OF_BIRTH'      TO TABLE-ELEMENT-2             
               MOVE 3H-DATE-OF-BIRTH     TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8660-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-UPDATE-CUST-EMAIL.                                          
                                                                        
           MOVE WS-EMAIL-TEXT TO NE-EMAIL-ADDRESS-TX-TEXT.              
           MOVE WS-EMAIL-LEN TO NE-EMAIL-ADDRESS-TX-LEN.                
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_EMAIL                                     
                 SET EMAIL_ADDRESS_TX = LOWER(:NE-EMAIL-ADDRESS-TX)     
               WHERE CUSTOMER_NO      = :NE-CUSTOMER-NO                 
P00740           AND EMAIL_TYPE_CD    = :NE-EMAIL-TYPE-CD               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_EMAIL                                             
MFA-TR*          SET EMAIL_ADDRESS_TX = LOWER(:NE-EMAIL-ADDRESS-TX)             
MFA-TR*        WHERE CUSTOMER_NO      = :NE-CUSTOMER-NO                         
MFA-TR*          AND EMAIL_TYPE_CD    = :NE-EMAIL-TYPE-CD                       
MFA-TR*       QUERYNO 8800                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8800'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_EMAIL'     TO TABLE-1                     
               MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
               MOVE NE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
               MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
               MOVE NE-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 8810-UPDATE-3RD-EMAIL.                                           
P00740                                                                  
P00740     MOVE LINK-EMAIL-TEXT TO 3N-EMAIL-ADDRESS-TX.                 
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        UPDATE CSS_THD_PRTY_EMAIL                                 
P00740           SET EMAIL_ADDRESS_TX = :3N-EMAIL-ADDRESS-TX            
P00740         WHERE THD_PRTY_ID      = :3N-THD-PRTY-ID                 
P00740           AND EMAIL_TYPE_CD    = 'T1'                            
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_THD_PRTY_EMAIL                                         
MFA-TR*          SET EMAIL_ADDRESS_TX = :3N-EMAIL-ADDRESS-TX                    
MFA-TR*        WHERE THD_PRTY_ID      = :3N-THD-PRTY-ID                         
MFA-TR*          AND EMAIL_TYPE_CD    = 'T1'                                    
MFA-TR*       QUERYNO 8810                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00740         MOVE '8810'               TO ACTIVE-PARAGRAPH            
P00740         MOVE 'UPDATE'             TO ABEND-FUNCTION              
P00740         MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                     
P00740         MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1             
P00740         MOVE 3N-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
P00740         MOVE 'T1'                 TO HOSTVAR-ELEMENT-2           
P00740         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00740         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
P00740                                                                  
P00740 8810-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 8820-UPDATE-CONT-EMAIL.                                          
P00740                                                                  
P00740     MOVE LINK-EMAIL-TEXT TO 3G-EMAIL-ADDRESS-TX.                 
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        UPDATE CSS_CONTACT_EMAIL                                  
P00740           SET EMAIL_ADDRESS_TX = :3G-EMAIL-ADDRESS-TX            
P00740         WHERE CONTACT_ID       = :3G-CONTACT-ID                  
P00740           AND EMAIL_TYPE_CD    = 'N1'                            
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CONTACT_EMAIL                                          
MFA-TR*          SET EMAIL_ADDRESS_TX = :3G-EMAIL-ADDRESS-TX                    
MFA-TR*        WHERE CONTACT_ID       = :3G-CONTACT-ID                          
MFA-TR*          AND EMAIL_TYPE_CD    = 'N1'                                    
MFA-TR*       QUERYNO 8820                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00740         MOVE '8820'               TO ACTIVE-PARAGRAPH            
P00740         MOVE 'UPDATE'             TO ABEND-FUNCTION              
P00740         MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                     
P00740         MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
P00740         MOVE 3G-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
P00740         MOVE 'N1'                 TO HOSTVAR-ELEMENT-2           
P00740         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00740         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
P00740                                                                  
P00740 8820-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       8870-DELETE-CUST-EMAIL.                                          
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_EMAIL                                
               WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                      
P00740           AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_EMAIL                                        
MFA-TR*        WHERE CUSTOMER_NO = :NE-CUSTOMER-NO                              
MFA-TR*          AND EMAIL_TYPE_CD = :NE-EMAIL-TYPE-CD                          
MFA-TR*       QUERYNO 8870                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE       
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8870'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_EMAIL'     TO TABLE-1                     
               MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
               MOVE NE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
P00740         MOVE NE-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8870-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 8875-DELETE-3RD-EMAIL.                                           
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        DELETE FROM CSS_THD_PRTY_EMAIL                            
P00740         WHERE THD_PRTY_ID = :3N-THD-PRTY-ID                      
P00740           AND EMAIL_TYPE_CD = 'T1'                               
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_THD_PRTY_EMAIL                                    
MFA-TR*        WHERE THD_PRTY_ID = :3N-THD-PRTY-ID                              
MFA-TR*          AND EMAIL_TYPE_CD = 'T1'                                       
MFA-TR*       QUERYNO 8875                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00740         MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE       
P00740     ELSE                                                         
P00740         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00740         MOVE '8875'               TO ACTIVE-PARAGRAPH            
P00740         MOVE 'DELETE'             TO ABEND-FUNCTION              
P00740         MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                     
P00740         MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1             
P00740         MOVE 3N-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
P00740         MOVE 'T1'                 TO HOSTVAR-ELEMENT-2           
P00740         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00740         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00740     END-IF.                                                      
P00740                                                                  
P00740 8875-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 8876-DELETE-CONT-EMAIL.                                          
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        DELETE FROM CSS_CONTACT_EMAIL                             
P00740         WHERE CONTACT_ID = :3G-CONTACT-ID                        
P00740           AND EMAIL_TYPE_CD = 'N1'                               
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CONTACT_EMAIL                                     
MFA-TR*        WHERE CONTACT_ID = :3G-CONTACT-ID                                
MFA-TR*          AND EMAIL_TYPE_CD = 'N1'                                       
MFA-TR*       QUERYNO 8876                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00740         MOVE SUCCESSFUL-CALL      TO WS-ACTIVE-RETURN-CODE       
P00740     ELSE                                                         
P00740         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00740         MOVE '8876'               TO ACTIVE-PARAGRAPH            
P00740         MOVE 'DELETE'             TO ABEND-FUNCTION              
P00740         MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                     
P00740         MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
P00740         MOVE 3G-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
P00740         MOVE 'N1'                 TO HOSTVAR-ELEMENT-2           
P00740         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00740         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
P00740     END-IF.                                                      
P00740                                                                  
P00740 8876-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
       8880-INSERT-CUST-EMAIL.                                          
                                                                        
           MOVE WS-EMAIL-TEXT TO NE-EMAIL-ADDRESS-TX-TEXT.              
           MOVE WS-EMAIL-LEN TO NE-EMAIL-ADDRESS-TX-LEN.                
           MOVE 'H' TO NE-EMAIL-DISP-PREF-CD.                           
           MOVE 'D' TO NE-EMAIL-SOURCE-CD.                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_EMAIL                                
                   ( CUSTOMER_NO,                                       
                     EMAIL_TYPE_CD,                                     
                     EMAIL_DISP_PREF_CD,                                
                     EMAIL_ADDRESS_TX,                                  
                     EMAIL_SOURCE_CD)                                   
              VALUES                                                    
                   (:NE-CUSTOMER-NO,                                    
                    :NE-EMAIL-TYPE-CD,                                  
                    :NE-EMAIL-DISP-PREF-CD,                             
                    LOWER(:NE-EMAIL-ADDRESS-TX),                        
                    :NE-EMAIL-SOURCE-CD)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CUST_EMAIL                                        
MFA-TR*            ( CUSTOMER_NO,                                               
MFA-TR*              EMAIL_TYPE_CD,                                             
MFA-TR*              EMAIL_DISP_PREF_CD,                                        
MFA-TR*              EMAIL_ADDRESS_TX,                                          
MFA-TR*              EMAIL_SOURCE_CD)                                           
MFA-TR*       VALUES                                                            
MFA-TR*            (:NE-CUSTOMER-NO,                                            
MFA-TR*             :NE-EMAIL-TYPE-CD,                                          
MFA-TR*             :NE-EMAIL-DISP-PREF-CD,                                     
MFA-TR*             LOWER(:NE-EMAIL-ADDRESS-TX),                                
MFA-TR*             :NE-EMAIL-SOURCE-CD)                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8880'               TO ACTIVE-PARAGRAPH            
               MOVE 'INSERT'             TO ABEND-FUNCTION              
               MOVE 'CSS_CUST_EMAIL'     TO TABLE-1                     
               MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
               MOVE NE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1           
               MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
               MOVE NE-EMAIL-TYPE-CD     TO HOSTVAR-ELEMENT-2           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
                                                                        
       8880-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00740 8890-INSERT-3RD-EMAIL.                                           
P00740                                                                  
P00740     MOVE WS-EMAIL-TEXT TO 3N-EMAIL-ADDRESS-TX.                   
P00740     MOVE 'T1' TO 3N-EMAIL-TYPE-CD.                               
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        INSERT INTO CSS_THD_PRTY_EMAIL                            
P00740             ( THD_PRTY_ID,                                       
P00740               EMAIL_TYPE_CD,                                     
P00740               EMAIL_ADDRESS_TX)                                  
P00740        VALUES                                                    
P00740             (:3N-THD-PRTY-ID,                                    
P00740              :3N-EMAIL-TYPE-CD,                                  
P00740              :3N-EMAIL-ADDRESS-TX)                               
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00740         MOVE '8890'               TO ACTIVE-PARAGRAPH            
P00740         MOVE 'INSERT'             TO ABEND-FUNCTION              
P00740         MOVE 'CSS_THD_PRTY_EMAIL' TO TABLE-1                     
P00740         MOVE 'THD_PRTY_ID'        TO TABLE-ELEMENT-1             
P00740         MOVE 3N-THD-PRTY-ID       TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
P00740         MOVE 'T1'                 TO HOSTVAR-ELEMENT-2           
P00740         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00740         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
P00740                                                                  
P00740 8890-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
P00740 8910-INSERT-CONT-EMAIL.                                          
P00740                                                                  
P00740     MOVE LINK-EMAIL-TEXT TO 3G-EMAIL-ADDRESS-TX.                 
P00740     MOVE 'N1' TO 3G-EMAIL-TYPE-CD.                               
P00740                                                                  
P00740     EXEC SQL                                                     
P00740        INSERT INTO CSS_CONTACT_EMAIL                             
P00740             ( CONTACT_ID,                                        
P00740               EMAIL_TYPE_CD,                                     
P00740               EMAIL_ADDRESS_TX)                                  
P00740        VALUES                                                    
P00740             (:3G-CONTACT-ID,                                     
P00740              :3G-EMAIL-TYPE-CD,                                  
P00740              :3G-EMAIL-ADDRESS-TX)                               
P00740     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740                                                                  
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00740         NEXT SENTENCE                                            
P00740     ELSE                                                         
P00740         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
P00740         MOVE '8910'               TO ACTIVE-PARAGRAPH            
P00740         MOVE 'INSERT'             TO ABEND-FUNCTION              
P00740         MOVE 'CSS_CONTACT_EMAIL'  TO TABLE-1                     
P00740         MOVE 'CONTACT_ID'         TO TABLE-ELEMENT-1             
P00740         MOVE 3G-CONTACT-ID        TO HOSTVAR-ELEMENT-1           
P00740         MOVE 'EMAIL_TYPE_CD'      TO TABLE-ELEMENT-2             
P00740         MOVE 'N1'                 TO HOSTVAR-ELEMENT-2           
P00740         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00740         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.          
P00740                                                                  
P00740 8910-EXIT.                                                       
P00740     EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
