       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04484.                                          
       AUTHOR.       PADMA KONETI.                                      
       DATE-WRITTEN. AUG 2012.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES MESSAGES TO BE DISPLAYED ON THE        *        
      *  CONFIRMATION VIEW IN SST.                                     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  08/22/2012 PK98692   INITIAL VERSION                          *        
P00795*  08/01/2014 DB18339   ADDED ARRANGEMENT6 FOR EM002             *        
P0795A*  09/17/2014 PK44514   RETURN WORK TYPE FOR MARKETING AND       *        
P0795A*                       UNMETERED ORDERS                         *        
P0795B*  10/21/2014 PK44514   SEND BACK MESSAGE WHEN ORDER IS IN NON-  *        
P0795B*                       ACTIVE STATE ** COMMENTING THIS CALL. TKN*        
P0795B* *11/20/2014 PK44514   CARE OF IN UI. CAN OPEN IF REQD.S        *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04484'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04484 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04484_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04484_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04484_R3'.          
            05  GTT-NAME-4              PIC X(26) VALUE                 
                                        'SESSION.CSR04484_R4'.          
            05  GTT-NAME-5              PIC X(26) VALUE                 
                                        'SESSION.CSR04484_R5'.          
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1        PIC S9(9) COMP VALUE ZERO.       
             10 S-STATUS-CODE-1        PIC S9(9) COMP VALUE ZERO.       
             10 S-BUS-PROCESS-ID-1     PIC X(10) VALUE SPACES.          
             10 S-GROUP-CODE-1         PIC X(04) VALUE SPACES.          
             10 S-GROUP-SORT-ORDER-1   PIC S9(9) COMP VALUE 0.          
             10 S-RULE-MESSAGE-ID-1    PIC X(10) VALUE SPACES.          
             10 S-MSG-SORT-ORDER-CD-1  PIC X(07) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(9) COMP VALUE ZERO.       
             10 S-BUS-PROCESS-ID-2     PIC X(10) VALUE SPACES.          
             10 S-GROUP-CODE-2         PIC X(04) VALUE SPACES.          
             10 S-GROUP-SORT-ORDER-2   PIC S9(9) COMP VALUE 0.          
             10 S-ORDER-TYPE-2         PIC X(05) VALUE SPACES.          
             10 S-WORK-TYPE-2          PIC X(03) VALUE SPACES.          
             10 S-RULE-MESSAGE-ID-2    PIC X(10) VALUE SPACES.          
             10 S-MSG-SORT-ORDER-CD-2  PIC X(07) VALUE SPACES.          
             10 S-PYMT-REQD-FL-2       PIC X(01) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3        PIC S9(9) COMP VALUE ZERO.       
             10 S-BUS-PROCESS-ID-3     PIC X(10) VALUE SPACES.          
             10 S-GROUP-CODE-3         PIC X(04) VALUE SPACES.          
             10 S-GROUP-SORT-ORDER-3   PIC S9(9) COMP VALUE 0.          
             10 S-RULE-MESSAGE-ID-3    PIC X(10) VALUE SPACES.          
             10 S-MSG-SORT-ORDER-CD-3  PIC X(07) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4        PIC S9(9) COMP VALUE ZERO.       
             10 S-BUS-PROCESS-ID-4     PIC X(10) VALUE SPACES.          
             10 S-GROUP-CODE-4         PIC X(04) VALUE SPACES.          
             10 S-GROUP-SORT-ORDER-4   PIC S9(9) COMP VALUE 0.          
             10 S-RULE-MESSAGE-ID-4    PIC X(10) VALUE SPACES.          
             10 S-MSG-SORT-ORDER-CD-4  PIC X(07) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5        PIC S9(9) COMP VALUE ZERO.       
             10 S-BUS-PROCESS-ID-5     PIC X(10) VALUE SPACES.          
             10 S-GROUP-CODE-5         PIC X(04) VALUE SPACES.          
             10 S-GROUP-SORT-ORDER-5   PIC S9(9) COMP VALUE 0.          
             10 S-RULE-MESSAGE-ID-5    PIC X(10) VALUE SPACES.          
             10 S-MSG-SORT-ORDER-CD-5  PIC X(07) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01 WS-TABLES.                                                    
      *TO ALLOW FOR A MAXIMUM OF 10 ORDERS BEING CREATED AT ONE TIME.           
          05 T1-ORDER-PARM OCCURS 10 TIMES                              
                                       INDEXED BY T1-INDEX.             
             10 T1-ORDER-TYPE-CD  PIC X(05).                            
             10 T1-APPOINTMENT-FL PIC X(01).                            
HALDAY       10 T1-HOME-ALLDAY-FL PIC X(01).                            
             10 T1-CALL-BEFORE-FL PIC X(01).                            
             10 T1-ALT-PHONE-FL   PIC X(01).                            
             10 T1-MTR-ACCESS-FL  PIC X(01).                            
P0795B       10 T1-NOT-ACTIVE-FL  PIC X(01).                            
             10 T1-UTIL-WKTYP-CD  PIC X(250).                           
                                                                        
          05 T2-CHARGE-LINE            PIC X(100).                      
          05 T2-CHARGE-DTLS       REDEFINES T2-CHARGE-LINE.             
             10 T2-CHARGE-TYPES   OCCURS 10 TIMES                       
                                   INDEXED BY T2-INDEX.                 
                 15 T2-CHARGE-TYPE       PIC X(10).                     
                                                                        
      * TO ALLOW FOR A MAXIMUM OF 50 METERS IN AN ORDER                         
          05 T3-UTIL-WKTYP-LINE       PIC X(250).                       
          05 T3-UTIL-WKTYP-DTLS   REDEFINES T3-UTIL-WKTYP-LINE.         
             10 T3-UTIL-WKTYP-CD   OCCURS 50 TIMES                      
                                   INDEXED BY T3-INDEX.                 
                 15 T3-WORK-TYPE-CD    PIC X(03).                       
                 15 T3-UTIL-TYPE-CD    PIC X(01).                       
                 15 T3-RLSE-REQD-FL    PIC X(01).                       
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04484'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT04-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT05-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-HARD-ERROR-FOUND      PIC X(01) VALUE 'N'.             
          05  WS-PREMISE-NO            PIC X(10) VALUE SPACES.          
          05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO          
                                       PIC 9(10).                       
          05  WS-ORDER-TYPE-CD         PIC X(05)  VALUE SPACES.         
      *   05  WS-PREV-ORDER-TYPE-CD    PIC X(05)  VALUE SPACES.                 
          05  WS-WORK-TYPE-CD          PIC X(05)  VALUE SPACES.         
          05  WS-BUS-PROCESS-ID        PIC X(10)  VALUE SPACES.         
          05  WS-LIGHTING-FL           PIC X(10)  VALUE SPACES.         
          05  WS-CHARGE-TYPES          PIC X(100) VALUE SPACES.         
          05  WS-UTIL-TYPE-CD          PIC X(03)  VALUE SPACES.         
          05  WS-CURR-UTILS-CD         PIC X(03)  VALUE SPACES.         
          05  WS-CNFIRM-PROPERTY-ID    PIC X(20)  VALUE SPACES.         
          05  WS-APPOINTMENT-FL        PIC X(01)  VALUE SPACES.         
          05  WS-HOME-ALLDAY-FL        PIC X(01)  VALUE SPACES.         
          05  WS-CALL-BEFORE-FL        PIC X(01)  VALUE SPACES.         
          05  WS-ALT-PHONE-FL          PIC X(01)  VALUE SPACES.         
          05  WS-MTR-ACCESS-FL         PIC X(01)  VALUE SPACES.         
          05  WS-NOT-ACTIVE-FL         PIC X(01)  VALUE SPACES.         
          05  WS-RLSE-REQD-FL          PIC X(01)  VALUE SPACES.         
          05  WS-PYMT-REQD-FL          PIC X(01)  VALUE SPACES.         
          05  WS-ELEC-AVAILABLE-FL     PIC X(01)  VALUE 'N'.            
              88 ELEC-AVAILABLE                   VALUE 'Y'.            
          05  WS-GAS-AVAILABLE-FL      PIC X(01)  VALUE 'N'.            
              88 GAS-AVAILABLE                    VALUE 'Y'.            
          05  WS-LIGHT-AVAILABLE-FL    PIC X(01)  VALUE 'N'.            
              88 LIGHT-AVAILABLE                  VALUE 'Y'.            
      *   05  WS-ORDER-PARM            PIC X(120) VALUE SPACES.                 
          05  WS-ORDER-PARM.                                            
              10  WS-ORDER-PARM-LEN    PIC S9(04) COMP.                 
HALDAY        10  WS-ORDER-PARM-TEXT   PIC X(2600).                     
      *       10  WS-ORDER-PARM-TEXT   PIC X(2090).                             
HALDAY    05  WS-ORDER-DETAILS         PIC X(2600) VALUE SPACES.        
      *   05  WS-ORDER-DETAILS         PIC X(2090) VALUE SPACES.                
HALDAY    05  WS-ORDER-DETAILS-REST    PIC X(2600) VALUE SPACES.        
      *   05  WS-ORDER-DETAILS-REST    PIC X(2090) VALUE SPACES.                
HALDAY    05  WS-ORDER-DETAILS-CURR    PIC X(260) VALUE SPACES.         
      *   05  WS-ORDER-DETAILS-CURR    PIC X(209) VALUE SPACES.                 
          05  WS-UTIL-DEPENDENCY-CD    PIC X(03)  VALUE SPACES.         
P0795B    05  WS-BILLDATE-CHG-FL       PIC X(01)  VALUE SPACES.         
          05  WS-DELIMITER             PIC X(01)  VALUE ';'.            
          05  WS-START-POS             PIC S9(04) COMP.                 
          05  WS-CURR-LENGTH           PIC S9(04) COMP.                 
          05  WS-STRING-LEN            PIC S9(04) COMP.                 
          05  WS-COUNT-O               PIC S9(04) COMP.                 
          05  WS-COUNT-C               PIC S9(04) COMP.                 
          05  WS-LEN-ORDER             PIC S9(04) COMP.                 
          05  WS-A                     PIC X(01) VALUE 'A'.             
          05 WS-GROUP-CODE.                                             
              10  WS-SERVICES          PIC X(04)  VALUE 'SVCS'.         
              10  WS-ORDERS            PIC X(04)  VALUE 'ORDR'.         
              10  WS-CHARGES           PIC X(04)  VALUE 'CHRG'.         
              10  WS-BILLING           PIC X(04)  VALUE 'BILL'.         
              10  WS-FINALBILLADDR     PIC X(04)  VALUE 'FBAD'.         
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_UTIL_ENVRNMT         UT                                   *         
      ******************************************************************        
           EXEC SQL                                                     00640000
              INCLUDE TBUTLENV                                          00650000
           END-EXEC.                                                    00660000
      ******************************************************************        
      * CSS_BUS_CNFIRM_GRP       2V                                   *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBUSGRP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BUS_CNFIRM_MSG       2U                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBUSCON                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ORDER_TYPE           C2                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CSS_ORDER_WK_TYPE        L3                                    *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBORWT                                                    
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     
              DECLARE CONFIRM1-CURSOR CURSOR FOR                        
              SELECT BUS_PROCESS_ID                                     
                    ,RULE_MESSAGE_ID                                    
                    ,RULE_RESULT_CD                                     
                    ,GROUP_CD                                           
                    ,MSG_SORT_ORDER_CD                                  
              FROM CSS_BUS_CNFIRM_MSG WITH(READUNCOMMITTED)                     
              WHERE BUS_PROCESS_ID     = :2U-BUS-PROCESS-ID             
              AND   ORDER_TYPE_CD      = :2U-ORDER-TYPE-CD              
              AND   WORK_TYPE_CD       = :2U-WORK-TYPE-CD               
              AND   UTIL_DEPENDENCY_CD = :2U-UTIL-DEPENDENCY-CD         
              AND   CNFIRM_PROPERTY_ID = :2U-CNFIRM-PROPERTY-ID         
              FOR READ ONLY                                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONFIRM1-CURSOR CURSOR FOR                                
MFA-TR*       SELECT BUS_PROCESS_ID                                             
MFA-TR*             ,RULE_MESSAGE_ID                                            
MFA-TR*             ,RULE_RESULT_CD                                             
MFA-TR*             ,GROUP_CD                                                   
MFA-TR*             ,MSG_SORT_ORDER_CD                                          
MFA-TR*       FROM CSS_BUS_CNFIRM_MSG                                           
MFA-TR*       WHERE BUS_PROCESS_ID     = :2U-BUS-PROCESS-ID                     
MFA-TR*       AND   ORDER_TYPE_CD      = :2U-ORDER-TYPE-CD                      
MFA-TR*       AND   WORK_TYPE_CD       = :2U-WORK-TYPE-CD                       
MFA-TR*       AND   UTIL_DEPENDENCY_CD = :2U-UTIL-DEPENDENCY-CD                 
MFA-TR*       AND   CNFIRM_PROPERTY_ID = :2U-CNFIRM-PROPERTY-ID                 
MFA-TR*       FOR FETCH ONLY                                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 STATUS_CODE          AS STATUS_CODE,                   
                 BUS_PROCESS_ID       AS BUS_PROCESS_ID,                
                 GROUP_CODE           AS GROUP_CODE,                    
                 GRP_SORT_ORDER       AS GRP_SORT_ORDER,                
                 RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,               
                 MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD              
              FROM #CSR04484_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          STATUS_CODE          AS STATUS_CODE,                           
MFA-TR*          BUS_PROCESS_ID       AS BUS_PROCESS_ID,                        
MFA-TR*          GROUP_CODE           AS GROUP_CODE,                            
MFA-TR*          GRP_SORT_ORDER       AS GRP_SORT_ORDER,                        
MFA-TR*          RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,                       
MFA-TR*          MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD                      
MFA-TR*       FROM SESSION.CSR04484_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1         AS RETURN_CODE,          
                      :S-STATUS-CODE-1         AS STATUS_CODE,          
                      :S-BUS-PROCESS-ID-1      AS BUS_PROCESS_ID,       
                      :S-GROUP-CODE-1          AS GROUP_CODE,           
                      :S-GROUP-SORT-ORDER-1    AS GRP_SORT_ORDER,       
                      :S-RULE-MESSAGE-ID-1     AS RULE_MESSAGE_ID,      
                      :S-MSG-SORT-ORDER-CD-1   AS MSG_SORT_ORDER_CD     
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1         AS RETURN_CODE,                  
MFA-TR*               :S-STATUS-CODE-1         AS STATUS_CODE,                  
MFA-TR*               :S-BUS-PROCESS-ID-1      AS BUS_PROCESS_ID,               
MFA-TR*               :S-GROUP-CODE-1          AS GROUP_CODE,                   
MFA-TR*               :S-GROUP-SORT-ORDER-1    AS GRP_SORT_ORDER,               
MFA-TR*               :S-RULE-MESSAGE-ID-1     AS RULE_MESSAGE_ID,              
MFA-TR*               :S-MSG-SORT-ORDER-CD-1   AS MSG_SORT_ORDER_CD             
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  FOR                         
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 BUS_PROCESS_ID       AS BUS_PROCESS_ID,                
                 GROUP_CODE           AS GROUP_CODE,                    
                 GRP_SORT_ORDER       AS GRP_SORT_ORDER,                
                 ORDER_TYPE           AS ORDER_TYPE,                    
                 WORK_TYPE            AS WORK_TYPE,                     
                 RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,               
                 MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD,             
                 PYMT_REQD_FL         AS PYMT_REQD_FL                   
              FROM #CSR04484_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          BUS_PROCESS_ID       AS BUS_PROCESS_ID,                        
MFA-TR*          GROUP_CODE           AS GROUP_CODE,                            
MFA-TR*          GRP_SORT_ORDER       AS GRP_SORT_ORDER,                        
MFA-TR*          ORDER_TYPE           AS ORDER_TYPE,                            
MFA-TR*          WORK_TYPE            AS WORK_TYPE,                             
MFA-TR*          RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,                       
MFA-TR*          MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD,                     
MFA-TR*          PYMT_REQD_FL         AS PYMT_REQD_FL                           
MFA-TR*       FROM SESSION.CSR04484_R2                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2         AS RETURN_CODE,          
                      :S-BUS-PROCESS-ID-2      AS BUS_PROCESS_ID,       
                      :S-GROUP-CODE-2          AS GROUP_CODE,           
                      :S-GROUP-SORT-ORDER-2    AS GRP_SORT_ORDER,       
                      :S-ORDER-TYPE-2          AS ORDER_TYPE,           
                      :S-WORK-TYPE-2           AS WORK_TYPE,            
                      :S-RULE-MESSAGE-ID-2     AS RULE_MESSAGE_ID,      
                      :S-MSG-SORT-ORDER-CD-2   AS MSG_SORT_ORDER_CD,    
                      :S-PYMT-REQD-FL-2        AS PYMT_REQD_FL          
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2         AS RETURN_CODE,                  
MFA-TR*               :S-BUS-PROCESS-ID-2      AS BUS_PROCESS_ID,               
MFA-TR*               :S-GROUP-CODE-2          AS GROUP_CODE,                   
MFA-TR*               :S-GROUP-SORT-ORDER-2    AS GRP_SORT_ORDER,               
MFA-TR*               :S-ORDER-TYPE-2          AS ORDER_TYPE,                   
MFA-TR*               :S-WORK-TYPE-2           AS WORK_TYPE,                    
MFA-TR*               :S-RULE-MESSAGE-ID-2     AS RULE_MESSAGE_ID,              
MFA-TR*               :S-MSG-SORT-ORDER-CD-2   AS MSG_SORT_ORDER_CD,            
MFA-TR*               :S-PYMT-REQD-FL-2        AS PYMT_REQD_FL                  
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  FOR                         
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 BUS_PROCESS_ID       AS BUS_PROCESS_ID,                
                 GROUP_CODE           AS GROUP_CODE,                    
                 GRP_SORT_ORDER       AS GRP_SORT_ORDER,                
                 RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,               
                 MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD              
              FROM #CSR04484_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          BUS_PROCESS_ID       AS BUS_PROCESS_ID,                        
MFA-TR*          GROUP_CODE           AS GROUP_CODE,                            
MFA-TR*          GRP_SORT_ORDER       AS GRP_SORT_ORDER,                        
MFA-TR*          RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,                       
MFA-TR*          MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD                      
MFA-TR*       FROM SESSION.CSR04484_R3                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3         AS RETURN_CODE,          
                      :S-BUS-PROCESS-ID-3      AS BUS_PROCESS_ID,       
                      :S-GROUP-CODE-3          AS GROUP_CODE,           
                      :S-GROUP-SORT-ORDER-3    AS GRP_SORT_ORDER,       
                      :S-RULE-MESSAGE-ID-3     AS RULE_MESSAGE_ID,      
                      :S-MSG-SORT-ORDER-CD-3   AS MSG_SORT_ORDER_CD     
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3         AS RETURN_CODE,                  
MFA-TR*               :S-BUS-PROCESS-ID-3      AS BUS_PROCESS_ID,               
MFA-TR*               :S-GROUP-CODE-3          AS GROUP_CODE,                   
MFA-TR*               :S-GROUP-SORT-ORDER-3    AS GRP_SORT_ORDER,               
MFA-TR*               :S-RULE-MESSAGE-ID-3     AS RULE_MESSAGE_ID,              
MFA-TR*               :S-MSG-SORT-ORDER-CD-3   AS MSG_SORT_ORDER_CD             
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C4 CURSOR  FOR                         
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 BUS_PROCESS_ID       AS BUS_PROCESS_ID,                
                 GROUP_CODE           AS GROUP_CODE,                    
                 GRP_SORT_ORDER       AS GRP_SORT_ORDER,                
                 RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,               
                 MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD              
              FROM #CSR04484_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          BUS_PROCESS_ID       AS BUS_PROCESS_ID,                        
MFA-TR*          GROUP_CODE           AS GROUP_CODE,                            
MFA-TR*          GRP_SORT_ORDER       AS GRP_SORT_ORDER,                        
MFA-TR*          RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,                       
MFA-TR*          MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD                      
MFA-TR*       FROM SESSION.CSR04484_R4                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N4 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-4         AS RETURN_CODE,          
                      :S-BUS-PROCESS-ID-4      AS BUS_PROCESS_ID,       
                      :S-GROUP-CODE-4          AS GROUP_CODE,           
                      :S-GROUP-SORT-ORDER-4    AS GRP_SORT_ORDER,       
                      :S-RULE-MESSAGE-ID-4     AS RULE_MESSAGE_ID,      
                      :S-MSG-SORT-ORDER-CD-4   AS MSG_SORT_ORDER_CD     
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N4 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-4         AS RETURN_CODE,                  
MFA-TR*               :S-BUS-PROCESS-ID-4      AS BUS_PROCESS_ID,               
MFA-TR*               :S-GROUP-CODE-4          AS GROUP_CODE,                   
MFA-TR*               :S-GROUP-SORT-ORDER-4    AS GRP_SORT_ORDER,               
MFA-TR*               :S-RULE-MESSAGE-ID-4     AS RULE_MESSAGE_ID,              
MFA-TR*               :S-MSG-SORT-ORDER-CD-4   AS MSG_SORT_ORDER_CD             
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C5 CURSOR  FOR                         
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 BUS_PROCESS_ID       AS BUS_PROCESS_ID,                
                 GROUP_CODE           AS GROUP_CODE,                    
                 GRP_SORT_ORDER       AS GRP_SORT_ORDER,                
                 RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,               
                 MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD              
              FROM #CSR04484_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C5 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          BUS_PROCESS_ID       AS BUS_PROCESS_ID,                        
MFA-TR*          GROUP_CODE           AS GROUP_CODE,                            
MFA-TR*          GRP_SORT_ORDER       AS GRP_SORT_ORDER,                        
MFA-TR*          RULE_MESSAGE_ID      AS RULE_MESSAGE_ID,                       
MFA-TR*          MSG_SORT_ORDER_CD    AS MSG_SORT_ORDER_CD                      
MFA-TR*       FROM SESSION.CSR04484_R5                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N5 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-5         AS RETURN_CODE,          
                      :S-BUS-PROCESS-ID-5      AS BUS_PROCESS_ID,       
                      :S-GROUP-CODE-5          AS GROUP_CODE,           
                      :S-GROUP-SORT-ORDER-5    AS GRP_SORT_ORDER,       
                      :S-RULE-MESSAGE-ID-5     AS RULE_MESSAGE_ID,      
                      :S-MSG-SORT-ORDER-CD-5   AS MSG_SORT_ORDER_CD     
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N5 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-5         AS RETURN_CODE,                  
MFA-TR*               :S-BUS-PROCESS-ID-5      AS BUS_PROCESS_ID,               
MFA-TR*               :S-GROUP-CODE-5          AS GROUP_CODE,                   
MFA-TR*               :S-GROUP-SORT-ORDER-5    AS GRP_SORT_ORDER,               
MFA-TR*               :S-RULE-MESSAGE-ID-5     AS RULE_MESSAGE_ID,              
MFA-TR*               :S-MSG-SORT-ORDER-CD-5   AS MSG_SORT_ORDER_CD             
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-PROCESS-ID          PIC X(10).                          
       01  LINK-LIGHTING-FL         PIC X(01).                          
P0795B 01  LINK-BILLDATE-CHG-FL     PIC X(01).                          
       01  LINK-CHARGE-TYPES        PIC X(100).                         
P0795B 01  LINK-ORDER-PARMS         PIC X(2610).                        
P0795B*01  LINK-ORDER-PARMS         PIC X(2600).                                
                                                                        
       PROCEDURE DIVISION USING  LINK-PREMISE-NO,                       
                                 LINK-PROCESS-ID,                       
                                 LINK-LIGHTING-FL,                      
P0795B                           LINK-BILLDATE-CHG-FL,                  
                                 LINK-CHARGE-TYPES,                     
                                 LINK-ORDER-PARMS.                      
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
                            S-RETURN-CODE-5                             
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT                
               PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                
           END-IF.                                                      
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED                                
                       WS-GTT04-DECLARED                                
                       WS-GTT05-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04484_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04484_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               BUS_PROCESS_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               GROUP_CODE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,            
               GRP_SORT_ORDER       INT,                            
               RULE_MESSAGE_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MSG_SORT_ORDER_CD CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT1'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04484_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04484_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04484_R2
              (                                                          
               RETURN_CODE          INT,                            
               BUS_PROCESS_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               GROUP_CODE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,            
               GRP_SORT_ORDER       INT,                            
               ORDER_TYPE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,            
               WORK_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,             
               RULE_MESSAGE_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MSG_SORT_ORDER_CD CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               PYMT_REQD_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT2'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04484_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04484_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04484_R3
              (                                                          
               RETURN_CODE          INT,                            
               BUS_PROCESS_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               GROUP_CODE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,            
               GRP_SORT_ORDER       INT,                            
               RULE_MESSAGE_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MSG_SORT_ORDER_CD CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT3'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04484_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0104-DECLARE-GTT04.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04484_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04484_R4
              (                                                          
               RETURN_CODE          INT,                            
               BUS_PROCESS_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               GROUP_CODE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,            
               GRP_SORT_ORDER       INT,                            
               RULE_MESSAGE_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MSG_SORT_ORDER_CD CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8004-DELETE-GTT4-ROWS THRU 8004-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0104'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT4'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04484_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT04-DECLARED.                               
                                                                        
       0104-EXIT.                                                       
                                                                        
       0105-DECLARE-GTT05.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04484_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04484_R5
              (                                                          
               RETURN_CODE          INT,                            
               BUS_PROCESS_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               GROUP_CODE CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2,            
               GRP_SORT_ORDER       INT,                            
               RULE_MESSAGE_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MSG_SORT_ORDER_CD CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8005-DELETE-GTT5-ROWS THRU 8005-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0105'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT5'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04484_R5'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT05-DECLARED.                               
                                                                        
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE LINK-PREMISE-NO    TO WS-PREMISE-NO.                    
           MOVE LINK-PROCESS-ID    TO WS-BUS-PROCESS-ID.                
           MOVE LINK-CHARGE-TYPES  TO WS-CHARGE-TYPES.                  
           MOVE WS-CHARGE-TYPES    TO T2-CHARGE-LINE.                   
      *    MOVE LINK-ORDER-PARMS   TO T1-ORDER-LINE.                            
           MOVE LINK-ORDER-PARMS   TO WS-ORDER-PARM.                    
           MOVE WS-ORDER-PARM-TEXT TO WS-ORDER-DETAILS.                 
           MOVE WS-ORDER-DETAILS   TO WS-ORDER-DETAILS-CURR.            
           INSPECT WS-ORDER-DETAILS REPLACING ALL LOW-VALUES            
                           BY SPACES.                                   
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL T1-INDEX > 10 OR  
                           WS-ORDER-DETAILS <= ' '                      
             UNSTRING WS-ORDER-DETAILS DELIMITED BY WS-DELIMITER        
                 INTO WS-ORDER-DETAILS-CURR,                            
                      WS-ORDER-DETAILS-REST                             
              MOVE ZEROS TO WS-COUNT-O                                  
              MOVE ZEROS TO WS-COUNT-C                                  
              MOVE ZEROS TO WS-CURR-LENGTH                              
              MOVE ZEROS TO WS-LEN-ORDER                                
              MOVE ZEROS TO WS-START-POS                                
              MOVE ZEROS TO WS-STRING-LEN                               
              INSPECT FUNCTION REVERSE(WS-ORDER-DETAILS) TALLYING       
                             WS-COUNT-O FOR LEADING SPACES              
              INSPECT FUNCTION REVERSE(WS-ORDER-DETAILS-CURR) TALLYING  
                                   WS-COUNT-C FOR LEADING SPACES        
              COMPUTE WS-CURR-LENGTH = LENGTH OF WS-ORDER-DETAILS-CURR  
                                      - WS-COUNT-C                      
              COMPUTE WS-LEN-ORDER = LENGTH OF WS-ORDER-DETAILS         
                                      - WS-COUNT-O                      
              COMPUTE WS-START-POS = WS-CURR-LENGTH + 2                 
              COMPUTE WS-STRING-LEN = WS-LEN-ORDER - WS-CURR-LENGTH     
              MOVE WS-ORDER-DETAILS-CURR TO T1-ORDER-PARM (T1-INDEX)    
              MOVE WS-ORDER-DETAILS(WS-START-POS : WS-STRING-LEN)       
                           TO WS-ORDER-DETAILS                          
           END-PERFORM.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-PROCESS-ID = SPACES                                  
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
                            S-RETURN-CODE-5                             
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT                
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      * GET SERVICES AVAILABLE ON THE PREMISES.                                 
                                                                        
           PERFORM 5010-GET-UTIL-SERVICES    THRU  5010-EXIT.           
                                                                        
      * FETCH CONFIRMATION MESSAGE FOR THE PROCESS.                             
                                                                        
           PERFORM 5100-GET-PROCESS-MESSAGES THRU  5100-EXIT.           
                                                                        
      * FETCH CONFIRMATION MESSAGE FOR PROCESS/PROPERTY (LIGHTING).             
                                                                        
           IF WS-LIGHTING-FL > ' ' THEN                                 
             MOVE 'LIGHTING' TO WS-CNFIRM-PROPERTY-ID                   
             PERFORM 5200-GET-PROPERTY-MESSAGES THRU  5200-EXIT         
           END-IF.                                                      
                                                                        
           IF LINK-BILLDATE-CHG-FL  = 'Y'                               
             MOVE 'BILLDATECHG' TO WS-CNFIRM-PROPERTY-ID                
             PERFORM 5200-GET-PROPERTY-MESSAGES THRU  5200-EXIT         
           END-IF.                                                      
                                                                        
                                                                        
      * FETCH CONFIRMATION MESSAGE FOR PROCESS/PROPERTY (CHARGES).              
                                                                        
           PERFORM VARYING T2-INDEX FROM 1 BY 1 UNTIL T2-INDEX > 10 OR  
                           T2-CHARGE-TYPE (T2-INDEX) <= ' '             
             MOVE T2-CHARGE-TYPE (T2-INDEX)                             
                                       TO WS-CNFIRM-PROPERTY-ID         
             PERFORM 5200-GET-PROPERTY-MESSAGES THRU  5200-EXIT         
           END-PERFORM.                                                 
                                                                        
      *FETCH MESSAGES VALID FOR THE PROCESS/ORDER TYPE/WORK TYPE                
      *AND UTILITIES.                                                           
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL T1-INDEX > 10 OR  
                           T1-ORDER-TYPE-CD (T1-INDEX) <= ' '           
             MOVE T1-ORDER-TYPE-CD(T1-INDEX)   TO WS-ORDER-TYPE-CD      
             MOVE WS-ORDER-TYPE-CD             TO C2-ORDER-TYPE-CD      
             PERFORM 7300-GET-ORDER-GROUP-CD   THRU 7300-EXIT           
             MOVE T1-APPOINTMENT-FL(T1-INDEX)  TO WS-APPOINTMENT-FL     
HALDAY       MOVE T1-HOME-ALLDAY-FL(T1-INDEX)  TO WS-HOME-ALLDAY-FL     
             MOVE T1-CALL-BEFORE-FL(T1-INDEX)  TO WS-CALL-BEFORE-FL     
             MOVE T1-ALT-PHONE-FL(T1-INDEX)    TO WS-ALT-PHONE-FL       
             MOVE T1-MTR-ACCESS-FL(T1-INDEX)   TO WS-MTR-ACCESS-FL      
             MOVE T1-NOT-ACTIVE-FL(T1-INDEX)  TO WS-NOT-ACTIVE-FL       
             MOVE T1-UTIL-WKTYP-CD(T1-INDEX)   TO T3-UTIL-WKTYP-LINE    
             MOVE SPACES  TO WS-PYMT-REQD-FL                            
             MOVE SPACES   TO WS-CURR-UTILS-CD                          
             MOVE SPACES   TO WS-RLSE-REQD-FL                           
             PERFORM VARYING T3-INDEX FROM 1 BY 1 UNTIL T3-INDEX > 50 OR
                        (T3-WORK-TYPE-CD (T3-INDEX) <= ' ' AND          
                         T3-UTIL-TYPE-CD (T3-INDEX) <= ' ')             
                MOVE T3-UTIL-TYPE-CD (T3-INDEX)  TO WS-UTIL-TYPE-CD     
                MOVE T3-WORK-TYPE-CD (T3-INDEX)  TO WS-WORK-TYPE-CD     
                MOVE T3-RLSE-REQD-FL (T3-INDEX)  TO WS-RLSE-REQD-FL     
                IF WS-WORK-TYPE-CD NOT EQUAL SPACES                     
                   IF WS-PYMT-REQD-FL NOT = 'Y'                         
                      PERFORM 7320-GET-PYMT-REQD-FL  THRU  7320-EXIT    
                      MOVE L3-PAY-REQ-ORD-ST-FL      TO WS-PYMT-REQD-FL 
                   END-IF                                               
                   PERFORM 5400-GET-WKTYP-MESSAGES    THRU  5400-EXIT   
                   PERFORM 5500-GET-UTIL-DEPEND-CODE  THRU  5500-EXIT   
                   PERFORM 5420-GET-WKTYP-UTIL-MSGS   THRU  5420-EXIT   
                   PERFORM 5550-GET-CURR-UTIL-TYPES   THRU  5550-EXIT   
                   PERFORM 5280-GET-RELEASE-MESSAGES  THRU  5280-EXIT   
                END-IF                                                  
             END-PERFORM                                                
             PERFORM 5300-GET-ORDER-MESSAGES   THRU 5300-EXIT           
             PERFORM 5220-GET-APPOINTMENT-MSGS THRU 5220-EXIT           
             PERFORM 5240-GET-ARRANGEMENT-MSGS THRU 5240-EXIT           
             PERFORM 5260-GET-MTR-ACCESS-MSGS  THRU 5260-EXIT           
P0795B*      PERFORM 5270-GET-NOT-ACTIVE-MSGS  THRU 5270-EXIT                   
           END-PERFORM.                                                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-CONFIRM1-MSGS.                                        
                                                                        
           EXEC SQL                                                     
               FETCH CONFIRM1-CURSOR                                    
                INTO  :2U-BUS-PROCESS-ID                                
                     ,:2U-RULE-MESSAGE-ID                               
                     ,:2U-RULE-RESULT-CD                                
                     ,:2U-GROUP-CD                                      
                     ,:2U-MSG-SORT-ORDER-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 2U-GROUP-CD             TO 2V-GROUP-CD          
                   MOVE 2U-BUS-PROCESS-ID       TO 2V-BUS-PROCESS-ID    
                   PERFORM 2200-GET-GROUP-DESC THRU 2200-EXIT           
                   PERFORM 5900-GROUP-RESULT   THRU 5900-EXIT           
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_CNFIRM_MSG' TO TABLE-1                 
                   MOVE 'PROCESS_ID'        TO TABLE-ELEMENT-1          
                   MOVE 2U-BUS-PROCESS-ID   TO HOSTVAR-ELEMENT-1        
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
                   MOVE 2U-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2100-FETCH-CONFIRM1-MSGS.                              
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2200-GET-GROUP-DESC.                                             
                                                                        
           MOVE  SPACES TO 2V-GROUP-DESC.                               
           MOVE  0      TO 2V-GROUP-SORT-ORDER.                         
                                                                        
           EXEC SQL                                                     
              SELECT  GROUP_DESC,                                       
                      GROUP_SORT_ORDER                                  
                INTO  :2V-GROUP-DESC,                                   
                      :2V-GROUP-SORT-ORDER                              
                FROM  CSS_BUS_CNFIRM_GRP WITH(READUNCOMMITTED)                  
               WHERE  GROUP_CD       = :2V-GROUP-CD                     
                 AND  BUS_PROCESS_ID = :2V-BUS-PROCESS-ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  GROUP_DESC,                                               
MFA-TR*               GROUP_SORT_ORDER                                          
MFA-TR*         INTO  :2V-GROUP-DESC,                                           
MFA-TR*               :2V-GROUP-SORT-ORDER                                      
MFA-TR*         FROM  CSS_BUS_CNFIRM_GRP                                        
MFA-TR*        WHERE  GROUP_CD       = :2V-GROUP-CD                             
MFA-TR*          AND  BUS_PROCESS_ID = :2V-BUS-PROCESS-ID                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 2200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2200-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '2200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'FETCH'              TO ABEND-FUNCTION          
                   MOVE 'CSS_BUS_CNFIRM_GRP' TO TABLE-1                 
                   MOVE 'PROCESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE 2V-BUS-PROCESS-ID    TO HOSTVAR-ELEMENT-1       
                   MOVE 'GROUP_CD'           TO TABLE-ELEMENT-2         
                   MOVE 2V-GROUP-CD          TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * GET UTILITY SERVICES AVAILABLE ON THE PREMISE                           
       5010-GET-UTIL-SERVICES.                                          
                                                                        
            MOVE WS-PREMISE-NO-NUM  TO UT-PREMISE-NO.                   
            PERFORM 7200-CHECK-ELEC-AVAILABLE  THRU 7200-EXIT.          
            PERFORM 7220-CHECK-GAS-AVAILABLE   THRU 7220-EXIT.          
            PERFORM 7240-CHECK-LIGHT-AVAILABLE THRU 7240-EXIT.          
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
       5100-GET-PROCESS-MESSAGES.                                       
                                                                        
           MOVE WS-BUS-PROCESS-ID TO 2U-BUS-PROCESS-ID.                 
           MOVE SPACES            TO 2U-ORDER-TYPE-CD                   
                                     2U-WORK-TYPE-CD                    
                                     2U-UTIL-DEPENDENCY-CD              
                                     2U-CNFIRM-PROPERTY-ID.             
                                                                        
           PERFORM 7100-OPEN-CONFIRM1-CURSOR  THRU 7100-EXIT.           
           PERFORM 2100-FETCH-CONFIRM1-MSGS   THRU 2100-EXIT.           
           PERFORM 7140-CLOSE-CONFIRM1-CURSOR THRU 7140-EXIT.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-GET-PROPERTY-MESSAGES.                                      
                                                                        
           MOVE WS-BUS-PROCESS-ID      TO 2U-BUS-PROCESS-ID.            
           MOVE WS-CNFIRM-PROPERTY-ID  TO 2U-CNFIRM-PROPERTY-ID.        
           MOVE SPACES                 TO 2U-ORDER-TYPE-CD              
                                          2U-WORK-TYPE-CD               
                                          2U-UTIL-DEPENDENCY-CD.        
                                                                        
           PERFORM 7100-OPEN-CONFIRM1-CURSOR  THRU 7100-EXIT.           
           PERFORM 2100-FETCH-CONFIRM1-MSGS   THRU 2100-EXIT.           
           PERFORM 7140-CLOSE-CONFIRM1-CURSOR THRU 7140-EXIT.           
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5210-GET-PROPERTY-UTIL-MSGS.                                     
                                                                        
           MOVE WS-BUS-PROCESS-ID      TO 2U-BUS-PROCESS-ID.            
           MOVE WS-CNFIRM-PROPERTY-ID  TO 2U-CNFIRM-PROPERTY-ID.        
           MOVE WS-CURR-UTILS-CD       TO 2U-UTIL-DEPENDENCY-CD.        
           MOVE SPACES                 TO 2U-ORDER-TYPE-CD              
                                          2U-WORK-TYPE-CD.              
                                                                        
           PERFORM 7100-OPEN-CONFIRM1-CURSOR  THRU 7100-EXIT.           
           PERFORM 2100-FETCH-CONFIRM1-MSGS   THRU 2100-EXIT.           
           PERFORM 7140-CLOSE-CONFIRM1-CURSOR THRU 7140-EXIT.           
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5220-GET-APPOINTMENT-MSGS.                                       
                                                                        
           MOVE SPACES TO WS-CNFIRM-PROPERTY-ID.                        
           IF WS-APPOINTMENT-FL  = 'Y'                                  
              MOVE 'APPOINTMENT' TO WS-CNFIRM-PROPERTY-ID               
              PERFORM 5200-GET-PROPERTY-MESSAGES   THRU 5200-EXIT       
           END-IF.                                                      
                                                                        
       5220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5240-GET-ARRANGEMENT-MSGS.                                       
                                                                        
           MOVE SPACES TO WS-CNFIRM-PROPERTY-ID.                        
           IF WS-CALL-BEFORE-FL = 'Y'                                   
              IF WS-ALT-PHONE-FL = 'Y'                                  
                 MOVE 'ARRANGEMENT3' TO WS-CNFIRM-PROPERTY-ID           
              ELSE                                                      
                 MOVE 'ARRANGEMENT2' TO WS-CNFIRM-PROPERTY-ID           
              END-IF                                                    
              PERFORM 5210-GET-PROPERTY-UTIL-MSGS  THRU 5210-EXIT       
HALDAY     ELSE IF WS-HOME-ALLDAY-FL = 'A'                              
HALDAY        MOVE 'ARRANGEMENT1' TO WS-CNFIRM-PROPERTY-ID              
HALDAY        PERFORM 5200-GET-PROPERTY-MESSAGES   THRU 5200-EXIT       
HALDAY     ELSE IF WS-HOME-ALLDAY-FL = 'B'                              
HALDAY        MOVE 'ARRANGEMENT4' TO WS-CNFIRM-PROPERTY-ID              
HALDAY        PERFORM 5200-GET-PROPERTY-MESSAGES   THRU 5200-EXIT       
P00795     ELSE IF WS-HOME-ALLDAY-FL = 'N'                              
P00795        IF WS-ORDER-TYPE-CD = 'EM002'                             
P00795          MOVE 'ARRANGEMENT6' TO WS-CNFIRM-PROPERTY-ID            
P00795          PERFORM 5200-GET-PROPERTY-MESSAGES   THRU 5200-EXIT     
P00795        END-IF                                                    
P00795     END-IF
                END-IF
                END-IF
           END-IF.                                                      
                                                                        
       5240-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       5260-GET-MTR-ACCESS-MSGS.                                        
                                                                        
           MOVE SPACES TO WS-CNFIRM-PROPERTY-ID.                        
           IF WS-MTR-ACCESS-FL = 'Y' THEN                               
              MOVE 'MTRACCESS' TO WS-CNFIRM-PROPERTY-ID                 
              PERFORM 5200-GET-PROPERTY-MESSAGES THRU  5200-EXIT        
           END-IF.                                                      
                                                                        
       5260-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5270-GET-NOT-ACTIVE-MSGS.                                        
                                                                        
           MOVE SPACES TO WS-CNFIRM-PROPERTY-ID.                        
           IF WS-NOT-ACTIVE-FL = 'Y' THEN                               
              MOVE 'ORDNOTACTIVE' TO WS-CNFIRM-PROPERTY-ID              
              PERFORM 5200-GET-PROPERTY-MESSAGES THRU  5200-EXIT        
           END-IF.                                                      
                                                                        
       5270-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       5280-GET-RELEASE-MESSAGES.                                       
                                                                        
           MOVE SPACES TO WS-CNFIRM-PROPERTY-ID.                        
           IF WS-RLSE-REQD-FL = 'Y'                                     
              IF WS-UTIL-TYPE-CD = 'G'                                  
                 MOVE 'RLSEREQDGAS' TO WS-CNFIRM-PROPERTY-ID            
              ELSE                                                      
                 MOVE 'RLSEREQDELEC' TO WS-CNFIRM-PROPERTY-ID           
              END-IF                                                    
              PERFORM 5200-GET-PROPERTY-MESSAGES   THRU 5200-EXIT       
           END-IF.                                                      
                                                                        
       5280-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5300-GET-ORDER-MESSAGES.                                         
                                                                        
           MOVE WS-BUS-PROCESS-ID            TO 2U-BUS-PROCESS-ID.      
           MOVE WS-ORDER-TYPE-CD             TO 2U-ORDER-TYPE-CD        
           MOVE SPACES                       TO 2U-CNFIRM-PROPERTY-ID   
                                                2U-WORK-TYPE-CD         
                                                2U-UTIL-DEPENDENCY-CD.  
                                                                        
           PERFORM 7100-OPEN-CONFIRM1-CURSOR  THRU 7100-EXIT.           
           PERFORM 2100-FETCH-CONFIRM1-MSGS   THRU 2100-EXIT.           
           PERFORM 7140-CLOSE-CONFIRM1-CURSOR THRU 7140-EXIT.           
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5400-GET-WKTYP-MESSAGES.                                         
                                                                        
           MOVE WS-BUS-PROCESS-ID            TO 2U-BUS-PROCESS-ID.      
           MOVE WS-ORDER-TYPE-CD             TO 2U-ORDER-TYPE-CD.       
           MOVE WS-WORK-TYPE-CD              TO 2U-WORK-TYPE-CD.        
           MOVE SPACES                       TO 2U-CNFIRM-PROPERTY-ID   
                                                2U-UTIL-DEPENDENCY-CD.  
                                                                        
           PERFORM 7100-OPEN-CONFIRM1-CURSOR  THRU 7100-EXIT.           
           PERFORM 2100-FETCH-CONFIRM1-MSGS   THRU 2100-EXIT.           
           PERFORM 7140-CLOSE-CONFIRM1-CURSOR THRU 7140-EXIT.           
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5420-GET-WKTYP-UTIL-MSGS.                                        
                                                                        
           MOVE WS-BUS-PROCESS-ID            TO 2U-BUS-PROCESS-ID.      
           MOVE WS-WORK-TYPE-CD              TO 2U-WORK-TYPE-CD.        
           MOVE WS-UTIL-DEPENDENCY-CD        TO 2U-UTIL-DEPENDENCY-CD.  
           MOVE SPACES                       TO 2U-CNFIRM-PROPERTY-ID   
                                                2U-ORDER-TYPE-CD.       
                                                                        
           PERFORM 7100-OPEN-CONFIRM1-CURSOR  THRU 7100-EXIT.           
           PERFORM 2100-FETCH-CONFIRM1-MSGS   THRU 2100-EXIT.           
           PERFORM 7140-CLOSE-CONFIRM1-CURSOR THRU 7140-EXIT.           
                                                                        
       5420-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       5500-GET-UTIL-DEPEND-CODE.                                       
                                                                        
           MOVE SPACES   TO WS-UTIL-DEPENDENCY-CD.                      
                                                                        
           IF WS-UTIL-TYPE-CD = 'E'                                     
              IF GAS-AVAILABLE THEN                                     
                 MOVE 'EB ' TO WS-UTIL-DEPENDENCY-CD                    
              ELSE                                                      
                 MOVE 'EE ' TO WS-UTIL-DEPENDENCY-CD                    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-UTIL-TYPE-CD = 'G'                                     
              IF ELEC-AVAILABLE THEN                                    
                 MOVE 'GB ' TO WS-UTIL-DEPENDENCY-CD                    
              ELSE                                                      
                 MOVE 'GG ' TO WS-UTIL-DEPENDENCY-CD                    
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       5550-GET-CURR-UTIL-TYPES.                                        
                                                                        
NEWNEW*    MOVE SPACES   TO WS-CURR-UTILS-CD.                                   
                                                                        
           IF WS-UTIL-TYPE-CD = 'E' AND WS-CURR-UTILS-CD = SPACES       
              MOVE 'EE' TO WS-CURR-UTILS-CD                             
           ELSE IF WS-UTIL-TYPE-CD = 'G' AND WS-CURR-UTILS-CD = SPACES  
              MOVE 'GG' TO WS-CURR-UTILS-CD                             
           ELSE  MOVE 'EG' TO WS-CURR-UTILS-CD                          
           END-IF
           END-IF.                                                      
                                                                        
       5550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5900-GROUP-RESULT.                                               
                                                                        
           EVALUATE 2V-GROUP-CD                                         
               WHEN WS-SERVICES                                         
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 0 TO S-STATUS-CODE-1                             
                  MOVE 2U-BUS-PROCESS-ID TO S-BUS-PROCESS-ID-1          
                  MOVE 2V-GROUP-CD TO S-GROUP-CODE-1                    
                  MOVE 2V-GROUP-SORT-ORDER TO S-GROUP-SORT-ORDER-1      
                  MOVE 2U-RULE-MESSAGE-ID  TO S-RULE-MESSAGE-ID-1       
                  MOVE 2U-MSG-SORT-ORDER-CD TO S-MSG-SORT-ORDER-CD-1    
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
                                                                        
               WHEN WS-ORDERS                                           
                  MOVE 0 TO S-RETURN-CODE-2                             
                  MOVE 2U-BUS-PROCESS-ID TO S-BUS-PROCESS-ID-2          
                  MOVE 2V-GROUP-CD TO S-GROUP-CODE-2                    
                  MOVE 2V-GROUP-SORT-ORDER TO S-GROUP-SORT-ORDER-2      
                  MOVE WS-ORDER-TYPE-CD  TO S-ORDER-TYPE-2              
                  MOVE WS-PYMT-REQD-FL   TO S-PYMT-REQD-FL-2            
                  IF C2-ORDER-GROUP-CD = WS-A OR                        
                     WS-ORDER-TYPE-CD = 'FM007' OR                      
                     WS-ORDER-TYPE-CD (1:2) = 'UM'                      
                     MOVE WS-WORK-TYPE-CD   TO S-WORK-TYPE-2            
                  ELSE                                                  
                     MOVE SPACES            TO S-WORK-TYPE-2            
                  END-IF                                                
                  MOVE 2U-RULE-MESSAGE-ID TO S-RULE-MESSAGE-ID-2        
                  MOVE 2U-MSG-SORT-ORDER-CD TO S-MSG-SORT-ORDER-CD-2    
                  IF WS-GTT02-DECLARED = 'N'                            
                      PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT         
                  END-IF                                                
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                                                                        
                                                                        
               WHEN WS-CHARGES                                          
                  MOVE 0 TO S-RETURN-CODE-3                             
                  MOVE 2U-BUS-PROCESS-ID TO S-BUS-PROCESS-ID-3          
                  MOVE 2V-GROUP-CD TO S-GROUP-CODE-3                    
                  MOVE 2V-GROUP-SORT-ORDER TO S-GROUP-SORT-ORDER-3      
                  MOVE 2U-RULE-MESSAGE-ID TO S-RULE-MESSAGE-ID-3        
                  MOVE 2U-MSG-SORT-ORDER-CD TO S-MSG-SORT-ORDER-CD-3    
                  IF WS-GTT03-DECLARED = 'N'                            
                      PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT         
                  END-IF                                                
                  PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT             
                                                                        
               WHEN WS-BILLING                                          
                  MOVE 0 TO S-RETURN-CODE-4                             
                  MOVE 2U-BUS-PROCESS-ID TO S-BUS-PROCESS-ID-4          
                  MOVE 2V-GROUP-CD TO S-GROUP-CODE-4                    
                  MOVE 2V-GROUP-SORT-ORDER TO S-GROUP-SORT-ORDER-4      
                  MOVE 2U-RULE-MESSAGE-ID TO S-RULE-MESSAGE-ID-4        
                  MOVE 2U-MSG-SORT-ORDER-CD TO S-MSG-SORT-ORDER-CD-4    
                  IF WS-GTT04-DECLARED = 'N'                            
                      PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT         
                  END-IF                                                
                  PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT             
                                                                        
               WHEN WS-FINALBILLADDR                                    
                  MOVE 0 TO S-RETURN-CODE-5                             
                  MOVE 2U-BUS-PROCESS-ID TO S-BUS-PROCESS-ID-5          
                  MOVE 2V-GROUP-CD TO S-GROUP-CODE-5                    
                  MOVE 2V-GROUP-SORT-ORDER TO S-GROUP-SORT-ORDER-5      
                  MOVE 2U-RULE-MESSAGE-ID TO S-RULE-MESSAGE-ID-5        
                  MOVE 2U-MSG-SORT-ORDER-CD TO S-MSG-SORT-ORDER-CD-5    
                  IF WS-GTT05-DECLARED = 'N'                            
                      PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT         
                  END-IF                                                
                  PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT             
                                                                        
               WHEN OTHER                                               
                   CONTINUE                                             
                                                                        
           END-EVALUATE.                                                
                                                                        
       5900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-CONFIRM1-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN CONFIRM1-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_CNFIRM_MSG' TO TABLE-1                 
                   MOVE 'PROCESS_ID'        TO TABLE-ELEMENT-1          
                   MOVE 2U-BUS-PROCESS-ID   TO HOSTVAR-ELEMENT-1        
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
                   MOVE 2U-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7140-CLOSE-CONFIRM1-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE CONFIRM1-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7140'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_CNFIRM_MSG' TO TABLE-1                 
                   MOVE 'PROCESS_ID'        TO TABLE-ELEMENT-1          
                   MOVE 2U-BUS-PROCESS-ID   TO HOSTVAR-ELEMENT-1        
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
                   MOVE 2U-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-CHECK-ELEC-AVAILABLE.                                       
                                                                        
           MOVE 'N' TO WS-ELEC-AVAILABLE-FL.                            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
             INTO   :WS-ELEC-AVAILABLE-FL                               
             FROM   CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                      
             WHERE  PREMISE_NO  = :UT-PREMISE-NO                        
             AND    CODE_UTIL_TYPE = 'E'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*      INTO   :WS-ELEC-AVAILABLE-FL                                       
MFA-TR*      FROM   CSS_UTIL_ENVRNMT                                            
MFA-TR*      WHERE  PREMISE_NO  = :UT-PREMISE-NO                                
MFA-TR*      AND    CODE_UTIL_TYPE = 'E'                                        
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE UT-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CHECK-GAS-AVAILABLE.                                        
                                                                        
           MOVE SPACES TO WS-GAS-AVAILABLE-FL.                          
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
             INTO   :WS-GAS-AVAILABLE-FL                                
             FROM   CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                      
             WHERE  PREMISE_NO  = :UT-PREMISE-NO                        
             AND    CODE_UTIL_TYPE = 'G'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*      INTO   :WS-GAS-AVAILABLE-FL                                        
MFA-TR*      FROM   CSS_UTIL_ENVRNMT                                            
MFA-TR*      WHERE  PREMISE_NO  = :UT-PREMISE-NO                                
MFA-TR*      AND    CODE_UTIL_TYPE = 'G'                                        
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7220                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7220'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE UT-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-CHECK-LIGHT-AVAILABLE.                                      
                                                                        
           MOVE SPACES TO WS-LIGHT-AVAILABLE-FL.                        
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'Y'                                                 
             INTO   :WS-LIGHT-AVAILABLE-FL                              
             FROM   CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                      
             WHERE  PREMISE_NO  = :UT-PREMISE-NO                        
             AND    CODE_UTIL_TYPE = 'U'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'Y'                                                         
MFA-TR*      INTO   :WS-LIGHT-AVAILABLE-FL                                      
MFA-TR*      FROM   CSS_UTIL_ENVRNMT                                            
MFA-TR*      WHERE  PREMISE_NO  = :UT-PREMISE-NO                                
MFA-TR*      AND    CODE_UTIL_TYPE = 'U'                                        
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7240                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7240'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE UT-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-ORDER-GROUP-CD.                                         
                                                                        
           MOVE SPACES TO C2-ORDER-GROUP-CD.                            
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) ORDER_GROUP_CD                                      
             INTO   :C2-ORDER-GROUP-CD                                  
             FROM   CSS_ORDER_TYPE WITH(READUNCOMMITTED)                        
             WHERE  ORDER_TYPE_CD = :C2-ORDER-TYPE-CD                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT ORDER_GROUP_CD                                              
MFA-TR*      INTO   :C2-ORDER-GROUP-CD                                          
MFA-TR*      FROM   CSS_ORDER_TYPE                                              
MFA-TR*      WHERE  ORDER_TYPE_CD = :C2-ORDER-TYPE-CD                           
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7300'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ORDER_TYPE'    TO TABLE-1                  
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-1          
                   MOVE C2-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7320-GET-PYMT-REQD-FL.                                           
                                                                        
           MOVE WS-ORDER-TYPE-CD             TO L3-ORDER-TYPE-CD.       
           MOVE WS-WORK-TYPE-CD              TO L3-WORK-TYPE-CD.        
           MOVE SPACES                       TO L3-PAY-REQ-ORD-ST-FL.   
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) PAY_REQ_ORD_ST_FL                                   
             INTO   :L3-PAY-REQ-ORD-ST-FL                               
             FROM   CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                     
             WHERE  ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                   
               AND  WORK_TYPE_CD =  :L3-WORK-TYPE-CD                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PAY_REQ_ORD_ST_FL                                           
MFA-TR*      INTO   :L3-PAY-REQ-ORD-ST-FL                                       
MFA-TR*      FROM   CSS_ORDER_WK_TYPE                                           
MFA-TR*      WHERE  ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                           
MFA-TR*        AND  WORK_TYPE_CD =  :L3-WORK-TYPE-CD                            
MFA-TR*      FETCH FIRST 1 ROWS ONLY                                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7320                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO L3-PAY-REQ-ORD-ST-FL                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7320'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ORDER_WK_TYPE' TO TABLE-1                  
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-1          
                   MOVE C2-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04484_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              BUS_PROCESS_ID,                                           
              GROUP_CODE,                                               
              GRP_SORT_ORDER,                                           
              RULE_MESSAGE_ID,                                          
              MSG_SORT_ORDER_CD                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE-1,                                        
               :S-BUS-PROCESS-ID-1,                                     
               :S-GROUP-CODE-1,                                         
               :S-GROUP-SORT-ORDER-1,                                   
               :S-RULE-MESSAGE-ID-1,                                    
               :S-MSG-SORT-ORDER-CD-1                                   
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04484_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       BUS_PROCESS_ID,                                                   
MFA-TR*       GROUP_CODE,                                                       
MFA-TR*       GRP_SORT_ORDER,                                                   
MFA-TR*       RULE_MESSAGE_ID,                                                  
MFA-TR*       MSG_SORT_ORDER_CD                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE-1,                                                
MFA-TR*        :S-BUS-PROCESS-ID-1,                                             
MFA-TR*        :S-GROUP-CODE-1,                                                 
MFA-TR*        :S-GROUP-SORT-ORDER-1,                                           
MFA-TR*        :S-RULE-MESSAGE-ID-1,                                            
MFA-TR*        :S-MSG-SORT-ORDER-CD-1                                           
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04484_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04484_R2                            
             (                                                          
              RETURN_CODE,                                              
              BUS_PROCESS_ID,                                           
              GROUP_CODE,                                               
              GRP_SORT_ORDER,                                           
              ORDER_TYPE,                                               
              WORK_TYPE,                                                
              RULE_MESSAGE_ID,                                          
              MSG_SORT_ORDER_CD,                                        
              PYMT_REQD_FL                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-BUS-PROCESS-ID-2,                                     
               :S-GROUP-CODE-2,                                         
               :S-GROUP-SORT-ORDER-2,                                   
               :S-ORDER-TYPE-2,                                         
               :S-WORK-TYPE-2,                                          
               :S-RULE-MESSAGE-ID-2,                                    
               :S-MSG-SORT-ORDER-CD-2,                                  
               :S-PYMT-REQD-FL-2                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04484_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       BUS_PROCESS_ID,                                                   
MFA-TR*       GROUP_CODE,                                                       
MFA-TR*       GRP_SORT_ORDER,                                                   
MFA-TR*       ORDER_TYPE,                                                       
MFA-TR*       WORK_TYPE,                                                        
MFA-TR*       RULE_MESSAGE_ID,                                                  
MFA-TR*       MSG_SORT_ORDER_CD,                                                
MFA-TR*       PYMT_REQD_FL                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-BUS-PROCESS-ID-2,                                             
MFA-TR*        :S-GROUP-CODE-2,                                                 
MFA-TR*        :S-GROUP-SORT-ORDER-2,                                           
MFA-TR*        :S-ORDER-TYPE-2,                                                 
MFA-TR*        :S-WORK-TYPE-2,                                                  
MFA-TR*        :S-RULE-MESSAGE-ID-2,                                            
MFA-TR*        :S-MSG-SORT-ORDER-CD-2,                                          
MFA-TR*        :S-PYMT-REQD-FL-2                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04484_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04484_R3                            
             (                                                          
              RETURN_CODE,                                              
              BUS_PROCESS_ID,                                           
              GROUP_CODE,                                               
              GRP_SORT_ORDER,                                           
              RULE_MESSAGE_ID,                                          
              MSG_SORT_ORDER_CD                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-BUS-PROCESS-ID-3,                                     
               :S-GROUP-CODE-3,                                         
               :S-GROUP-SORT-ORDER-3,                                   
               :S-RULE-MESSAGE-ID-3,                                    
               :S-MSG-SORT-ORDER-CD-3                                   
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04484_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       BUS_PROCESS_ID,                                                   
MFA-TR*       GROUP_CODE,                                                       
MFA-TR*       GRP_SORT_ORDER,                                                   
MFA-TR*       RULE_MESSAGE_ID,                                                  
MFA-TR*       MSG_SORT_ORDER_CD                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-BUS-PROCESS-ID-3,                                             
MFA-TR*        :S-GROUP-CODE-3,                                                 
MFA-TR*        :S-GROUP-SORT-ORDER-3,                                           
MFA-TR*        :S-RULE-MESSAGE-ID-3,                                            
MFA-TR*        :S-MSG-SORT-ORDER-CD-3                                           
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04484_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-SEND-RESULT-4.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04484_R4                            
             (                                                          
              RETURN_CODE,                                              
              BUS_PROCESS_ID,                                           
              GROUP_CODE,                                               
              GRP_SORT_ORDER,                                           
              RULE_MESSAGE_ID,                                          
              MSG_SORT_ORDER_CD                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-4,                                        
               :S-BUS-PROCESS-ID-4,                                     
               :S-GROUP-CODE-4,                                         
               :S-GROUP-SORT-ORDER-4,                                   
               :S-RULE-MESSAGE-ID-4,                                    
               :S-MSG-SORT-ORDER-CD-4                                   
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04484_R4                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       BUS_PROCESS_ID,                                                   
MFA-TR*       GROUP_CODE,                                                       
MFA-TR*       GRP_SORT_ORDER,                                                   
MFA-TR*       RULE_MESSAGE_ID,                                                  
MFA-TR*       MSG_SORT_ORDER_CD                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-4,                                                
MFA-TR*        :S-BUS-PROCESS-ID-4,                                             
MFA-TR*        :S-GROUP-CODE-4,                                                 
MFA-TR*        :S-GROUP-SORT-ORDER-4,                                           
MFA-TR*        :S-RULE-MESSAGE-ID-4,                                            
MFA-TR*        :S-MSG-SORT-ORDER-CD-4                                           
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04484_R4'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-SEND-RESULT-5.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04484_R5                            
             (                                                          
              RETURN_CODE,                                              
              BUS_PROCESS_ID,                                           
              GROUP_CODE,                                               
              GRP_SORT_ORDER,                                           
              RULE_MESSAGE_ID,                                          
              MSG_SORT_ORDER_CD                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-5,                                        
               :S-BUS-PROCESS-ID-5,                                     
               :S-GROUP-CODE-5,                                         
               :S-GROUP-SORT-ORDER-5,                                   
               :S-RULE-MESSAGE-ID-5,                                    
               :S-MSG-SORT-ORDER-CD-5                                   
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04484_R5                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       BUS_PROCESS_ID,                                                   
MFA-TR*       GROUP_CODE,                                                       
MFA-TR*       GRP_SORT_ORDER,                                                   
MFA-TR*       RULE_MESSAGE_ID,                                                  
MFA-TR*       MSG_SORT_ORDER_CD                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-5,                                                
MFA-TR*        :S-BUS-PROCESS-ID-5,                                             
MFA-TR*        :S-GROUP-CODE-5,                                                 
MFA-TR*        :S-GROUP-SORT-ORDER-5,                                           
MFA-TR*        :S-RULE-MESSAGE-ID-5,                                            
MFA-TR*        :S-MSG-SORT-ORDER-CD-5                                           
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04484_R5'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04484_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04484_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8001'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04484_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04484_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04484_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8002'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04484_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04484_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04484_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8003'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04484_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8004-DELETE-GTT4-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04484_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04484_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8004'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04484_R4'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8004-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8005-DELETE-GTT5-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04484_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04484_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8005'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04484_R5'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8006-DELETE-GTT6-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04484_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04484_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8006'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04484_R6'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8006-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT04-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-4                             
               EXEC SQL                                                 
                   OPEN N4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT05-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-5                             
               EXEC SQL                                                 
                   OPEN N5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
