       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04483.                                          
COB303 DATE-WRITTEN. JUNE 6, 2012.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  ORDER INITIATION CHARGES CALCULATION PROGRAM.                 *        
      *  PROGRAM RETURNS:                                              *        
      *     E&G GAS SEASONAL BLOCK CHARGE                              *        
      *     E&G ELECTRIC SEASONAL CHARGE                               *        
      *     PSNC SAME CUSTOMER CHARGE                                  *        
      *     PSNC NEW CUSTOMER CHARGE                                   *        
      *     E&G ELECTRIC RECONNECT CHARGE                              *        
      *     ORDER TYPE / SERVICE CHARGE DEFAULT CHARGES                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  06/06/12    FMB      NEW PROGRAM.                             *        
A04670*  06/04/13    FMB      ADD MESSAGES FOR SEABLKELEC AND SCEGRECON*        
P00795*  07/02/14    DB18339  ADDING CSS_ORD_SERV_CHG TABLE AND WORK   *        
P00795*                       TYPE CD AS NEW RETURN COLUMN.            *        
P00795*  07/24/14    DB18339  ADDING CODE_UTIL_TYPE TO ORD_SERV_CHG    *        
P00795*                       TABLE.                                   *        
P00795*  09/15/14    DB18339  REMOVED CHECK FOR CSS_ORDER_TYPE         *        
P0795A*  10/31/14    PK44514  DEFECT 6029 - ERROR ON SAME CUSTOMER     *        
      *                       OCCUPANT CHANGE ORDER FOR SCEG           *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04483'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04483 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04483_R1'.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-STATUS-CODE          PIC S9(9) COMP VALUE 0.           
           05  S-BUS-RULE-ID          PIC X(10) VALUE SPACES.           
           05  S-ACTION-TYPE-CD       PIC X(10) VALUE SPACES.           
           05  S-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.           
           05  S-CHARGE-AMT           PIC S9(9)V9(2) COMP-3 VALUE 0.    
P00795     05  S-WORK-TYPE-CD         PIC X(03) VALUE SPACES.           
           05  S-WAIVER-TYPE          PIC X(01) VALUE SPACES.           
           05  S-WORK-PERIOD          PIC X(01) VALUE SPACES.           
           05  S-CHARGE-TYPE          PIC X(10) VALUE SPACES.           
           05  S-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.           
           05  S-MESSAGE-PARMS        PIC X(200) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  WS-DATE-MINUS-12-MONTHS  PIC X(10).                      
           05  WS-DATE-MINUS-36-MONTHS  PIC X(10).                      
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04483'.     
           05  WS-CHARGE-SEASONAL       PIC X(01) VALUE 'N'.            
           05  WS-SAME-CUST-12          PIC X(01) VALUE 'N'.            
           05  WS-SAME-CUST-36          PIC X(01) VALUE 'N'.            
           05  WS-UNBLOCK-GAS-FL        PIC X(01) VALUE 'N'.            
P00795     05  WS-SERV-CHARGE-EXISTS    PIC X(01) VALUE 'N'.            
P00795     05  WS-WORK-TYPE-CD          PIC X(03) VALUE SPACES.         
P00795     05  WS-CODE-UT-TYPE          PIC X(01) VALUE SPACES.         
P00795     05  WS-WORK-PERIOD-CD        PIC X(01) VALUE SPACES.         
           05  WS-OLDEST-STATUS-DT      PIC X(10) VALUE SPACES.         
           05  WS-ELEC-METER-COUNT      PIC 9(04) VALUE ZEROES.         
           05  WS-GAS-METER-COUNT       PIC 9(04) VALUE ZEROES.         
           05  WS-STD-CHG-AMT           PIC S9(9)V99 VALUE 0.00.        
           05  WS-IC-NO                 PIC 9(04) VALUE ZEROES.         
           05  WS-MTR-REF-NO            PIC 9(04) VALUE ZEROES.         
           05  WS-SQLSTATE              PIC X(05) VALUE '     '.        
           05  WS-NULL1                 PIC S9(04) COMP VALUE 0.        
           05  WS-NULL2                 PIC S9(04) COMP VALUE 0.        
           05  WS-NULL3                 PIC S9(04) COMP VALUE 0.        
           05  WS-NULL4                 PIC S9(04) COMP VALUE 0.        
           05  WS-NULL5                 PIC S9(04) COMP VALUE 0.        
           05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-METER-PARM.                                           
               10  WS-METER-PARM-LEN    PIC S9(04) COMP.                
               10  WS-METER-PARM-TEXT   PIC X(650).                     
           05  WS-DATABASE              PIC 9(01) VALUE 0.              
               88 CSR-DATABASE                    VALUE 1.              
               88 SEB-DATABASE                    VALUE 2.              
           05  WS-FROM-DATE             PIC X(10).                      
           05  WS-TO-DATE               PIC X(10).                      
COB305     05 WS-DATE-DIFF        PIC S9(8)V COMP-3 VALUE 0.              
           05  WS-DATE-DIFF-UNPACKED    PIC 9(8).                       
           05  WS-YEARS                 PIC 99.                         
           05  WS-MONTHS                PIC 99.                         
           05  WS-COUNT-MONTHS          PIC 9(9) VALUE 0.               
           05  WS-OLD-SPOUSE-NO         PIC S9(10)V COMP-3 VALUE 0.     
           05  WS-NEW-SPOUSE-NO         PIC S9(10)V COMP-3 VALUE 0.     
           05  WS-CUST-AS-SPOUSE-NO     PIC S9(10)V COMP-3 VALUE 0.     
           05  WS-SEAS-BLOCK-GAS-AMT    PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-SEAS-BLOCK-ELEC-AMT   PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-PSNC-SAME-CUST-AMT    PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-SCEG-RECONNECT-AMT    PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-ELEC-DEFAULT-AMT      PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-GAS-DEFAULT-AMT       PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-DELINQ-SCEGRECON      PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-DELINQ-SEABLKELEC     PIC S9(9)V9(2) COMP-3 VALUE 0.  
           05  WS-FORMAT-MONTHS         PIC 99 VALUE 0.                 
           05  WS-FORMAT-AMT            PIC $$$,$$$,$$$.99.             
           05  WS-FORMAT-COUNT          PIC ZZZ,ZZZ,ZZ9.                
                                                                        
       01  WS-TABLES.                                                   
           05  T1-METER-LINE             PIC X(650).                    
           05  T1-METER-TABLE REDEFINES T1-METER-LINE.                  
               10  T1-PARM-METER         OCCURS 50                      
                                      INDEXED BY T1-INDEX.              
                   15  T1-CODE-UTIL-TYPE  PIC X(01).                    
                   15  T1-METER-STATUS    PIC X(01).                    
                   15  T1-IC-NO           PIC X(04).                    
                   15  T1-MTR-REF-NO      PIC X(04).                    
                   15  T1-WORK-TYPE       PIC X(03).                    
           05  T2-GAS-METERS          OCCURS 50                         
                                   INDEXED BY T2-INDEX.                 
               10  T2-METER-STATUS         PIC X(01).                   
               10  T2-IC-NO                PIC 9(04).                   
               10  T2-MTR-REF-NO           PIC 9(04).                   
               10  T2-WORK-TYPE            PIC X(03).                   
               10  T2-SEAS-BLOCK-FL        PIC X(01).                   
               10  T2-STATUS-CHG-DT        PIC X(10).                   
               10  T2-MTR-STATUS-REASON    PIC X(01).                   
               10  T2-RATE-PLAN-NO         PIC X(03).                   
                                                                        
       01  CSR03817-CALL-DATA.                                          
           03  ACCOUNT-NO-IN-3817       PIC X(13) VALUE SPACES.         
           03  OFF-DATE-IN-3817         PIC X(10) VALUE SPACES.         
           03  ON-DATE-IN-3817          PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR03817-RETURN-DATA.                                        
           03  ACCOUNT-NO-OUT-3817      PIC X(13) VALUE SPACES.         
           03  OFF-DATE-OUT-3817        PIC X(10) VALUE SPACES.         
           03  ON-DATE-OUT-3817         PIC X(10) VALUE SPACES.         
           03  RETURN-CODE-3817         PIC S9(9) COMP VALUE 0.         
           03  CHARGE-AMT-3817          PIC S9(9)V99 COMP-3 VALUE 0.    
           03  MONTH-CT-3817            PIC S9(4) COMP VALUE 0.         
           03  MONTH-AVG-3817           PIC S9(9)V99 COMP-3 VALUE 0.    
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC3817 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
P00795     EXEC SQL                                                             
P00795        INCLUDE TBORSVCH                                                  
P00795     END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBSOWAIV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 STATUS_CODE          AS STATUS_CODE,                   
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 ACTION_TYPE_CD       AS ACTION_TYPE_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,              
                 CHARGE_AMT           AS CHARGE_AMT,                    
P00795           WORK_TYPE_CD         AS WORK_TYPE_CD,                  
                 WAIVER_TYPE          AS WAIVER_TYPE,                   
                 WORK_PERIOD          AS WORK_PERIOD,                   
                 CHARGE_TYPE          AS CHARGE_TYPE,                   
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 MESSAGE_PARMS        AS MESSAGE_PARMS                  
              FROM #CSR04483_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          STATUS_CODE          AS STATUS_CODE,                           
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          ACTION_TYPE_CD       AS ACTION_TYPE_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,                      
MFA-TR*          CHARGE_AMT           AS CHARGE_AMT,                            
MFA-TR*          WORK_TYPE_CD         AS WORK_TYPE_CD,                          
MFA-TR*          WAIVER_TYPE          AS WAIVER_TYPE,                           
MFA-TR*          WORK_PERIOD          AS WORK_PERIOD,                           
MFA-TR*          CHARGE_TYPE          AS CHARGE_TYPE,                           
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          MESSAGE_PARMS        AS MESSAGE_PARMS                          
MFA-TR*       FROM SESSION.CSR04483_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
              SELECT                                                    
                 :S-RETURN-CODE       AS RETURN_CODE,                   
                 :S-STATUS-CODE       AS STATUS_CODE,                   
                 :S-BUS-RULE-ID       AS BUS_RULE_ID,                   
                 :S-ACTION-TYPE-CD    AS ACTION_TYPE_CD,                
                 :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID,              
                 :S-CHARGE-AMT        AS CHARGE_AMT,                    
P00795           :S-WORK-TYPE-CD      AS WORK_TYPE_CD,                  
                 :S-WAIVER-TYPE       AS WAIVER_TYPE,                   
                 :S-WORK-PERIOD       AS WORK_PERIOD,                   
                 :S-CHARGE-TYPE       AS CHARGE_TYPE,                   
                 :S-CODE-UTIL-TYPE    AS CODE_UTIL_TYPE,                
                 :S-MESSAGE-PARMS     AS MESSAGE_PARMS                  
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*          :S-RETURN-CODE       AS RETURN_CODE,                           
MFA-TR*          :S-STATUS-CODE       AS STATUS_CODE,                           
MFA-TR*          :S-BUS-RULE-ID       AS BUS_RULE_ID,                           
MFA-TR*          :S-ACTION-TYPE-CD    AS ACTION_TYPE_CD,                        
MFA-TR*          :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID,                      
MFA-TR*          :S-CHARGE-AMT        AS CHARGE_AMT,                            
MFA-TR*          :S-WORK-TYPE-CD      AS WORK_TYPE_CD,                          
MFA-TR*          :S-WAIVER-TYPE       AS WAIVER_TYPE,                           
MFA-TR*          :S-WORK-PERIOD       AS WORK_PERIOD,                           
MFA-TR*          :S-CHARGE-TYPE       AS CHARGE_TYPE,                           
MFA-TR*          :S-CODE-UTIL-TYPE    AS CODE_UTIL_TYPE,                        
MFA-TR*          :S-MESSAGE-PARMS     AS MESSAGE_PARMS                          
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_3817 CURSOR
MSQ001          FOR CALL CSR03817                                             
                  ( :ACCOUNT-NO-IN-3817
                  , :OFF-DATE-IN-3817
                  , :ON-DATE-IN-3817
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO         PIC X(13).                           
       01  LINK-NEW-CUSTOMER-NO    PIC X(10).                           
       01  LINK-ORDER-TYPE-CD      PIC X(05).                           
       01  LINK-PROCESS            PIC X(10).                           
       01  LINK-ASSIGNED-DATE      PIC X(10).                           
       01  LINK-METER-PARMS        PIC X(650).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                          LINK-ACCOUNT-NO,                              
                          LINK-NEW-CUSTOMER-NO,                         
                          LINK-ORDER-TYPE-CD,                           
                          LINK-PROCESS,                                 
                          LINK-ASSIGNED-DATE,                           
                          LINK-METER-PARMS.                             
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           MOVE 'N' TO WS-GTT01-DECLARED.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04483_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04483_R1
              (                                                          
                 RETURN_CODE          INT,                          
                 STATUS_CODE          INT,                          
                 BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
                 ACTION_TYPE_CD CHAR(10)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 CHARGE_AMT           DECIMAL(11,2),                    
P00795           WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 WAIVER_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
                 WORK_PERIOD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
                 CHARGE_TYPE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
                 CODE_UTIL_TYPE CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 MESSAGE_PARMS CHAR(200)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04483_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-NEW-CUSTOMER-NO NOT NUMERIC                          
               MOVE ZEROES TO LINK-NEW-CUSTOMER-NO
           END-IF.                     
                                                                        
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO-CHAR.                  
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           MOVE LINK-NEW-CUSTOMER-NO TO WS-CUSTOMER-NO-CHAR.            
           MOVE WS-CUSTOMER-NO-NUM TO CU-CUSTOMER-NO.                   
           MOVE LINK-METER-PARMS TO WS-METER-PARM.                      
           MOVE WS-METER-PARM-TEXT TO T1-METER-LINE.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -12, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-12-MONTHS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 12 MONTHS)                     
MFA-TR*          INTO :WS-DATE-MINUS-12-MONTHS                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              DATEADD( MONTH, -36, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-DATE-MINUS-36-MONTHS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-CURRENT-DATE) - 36 MONTHS)                     
MFA-TR*          INTO :WS-DATE-MINUS-36-MONTHS                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-PROCESS = 'START'                                    
               MOVE 'SOINIT0002' TO 1T-BUS-PROCESS-ID
           END-IF.                  
           IF LINK-PROCESS = 'STOP'                                     
               MOVE 'SOINIT0001' TO 1T-BUS-PROCESS-ID
           END-IF.                  
P00795     IF LINK-PROCESS = 'AOO'                                      
P00795         MOVE 'SOINIT0005' TO 1T-BUS-PROCESS-ID
           END-IF.                  
                                                                        
            IF LINK-ACCOUNT-NO = ZEROES                                 
                INITIALIZE GTT-RETURN-FIELDS                            
                MOVE +100 TO S-RETURN-CODE                              
                MOVE 'PARM ZERO' TO S-BUS-RULE-ID                       
                ADD +1 TO CTR-ROWS                                      
                PERFORM 9999-END-PROGRAM THRU 9999-EXIT
            END-IF.                
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * CODE_STATUS_REASON                                                      
      *     CSS_MTRD_ENVRNMT                                                    
      *        B = NON-PAYMENT                                                  
      *        C = SEASONAL                                                     
      *        Y = REQUEST CUSTOMER                                             
      *     CSS_ACCOUNT                                                         
      *        B = SEASONAL                                                     
      *        C = NON-PAYMENT                                                  
                                                                        
      *      CUSTOMER NUMBER WS FIELDS                                          
      * CU-CUSTOMER-NO = NEW CUSTOMER NUMBER (FROM LINKAGE)                     
      * AT-CUSTOMER-NO = OLD CUSTOMER NUMBER (FROM CSS_ACCOUNT)                 
      * WS-OLD-SPOUSE-NO = CUSTOMER NO WITH OLD SPOUSE SSN                      
      * WS-NEW-SPOUSE-NO = CUSTOMER NO WITH NEW SPOUSE SSN                      
      * WS-CUST-AS-SPOUSE-NO = CUSTOMER NO WHERE CUSTOMER IS SPOUSE             
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 7010-SELECT-DELINQ THRU 7010-EXIT.                   
                                                                        
           MOVE 9999999999 TO WS-OLD-SPOUSE-NO                          
                              WS-NEW-SPOUSE-NO                          
                              WS-CUST-AS-SPOUSE-NO.                     
           IF AT-CUSTOMER-NO > 0                                        
               MOVE AT-CUSTOMER-NO TO CE-CUSTOMER-NO                    
               PERFORM 7070-SELECT-SPOUSE THRU 7070-EXIT                
               IF CE-SSN > ' '                                          
                   PERFORM 7080-SELECT-SPOUSE-CUSTNO THRU 7080-EXIT     
                   MOVE CE-CUSTOMER-NO TO WS-OLD-SPOUSE-NO
               END-IF
           END-IF.             
           IF CU-CUSTOMER-NO > 0                                        
               MOVE CU-CUSTOMER-NO TO CE-CUSTOMER-NO                    
               PERFORM 7070-SELECT-SPOUSE THRU 7070-EXIT                
               IF CE-SSN > ' '                                          
                   PERFORM 7080-SELECT-SPOUSE-CUSTNO THRU 7080-EXIT     
                   MOVE CE-CUSTOMER-NO TO WS-NEW-SPOUSE-NO              
               END-IF                                                   
               PERFORM 7090-SELECT-CUST-SSN THRU 7090-EXIT              
               IF CE-SSN > ' '                                          
                   PERFORM 7095-SELECT-CUSTNO THRU 7095-EXIT            
                   MOVE CE-CUSTOMER-NO TO WS-CUST-AS-SPOUSE-NO
               END-IF
           END-IF.         
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL T1-INDEX > 50 OR  
                           T1-CODE-UTIL-TYPE (T1-INDEX) <= ' '          
               IF T1-CODE-UTIL-TYPE (T1-INDEX) = 'G' AND                
                  T1-WORK-TYPE (T1-INDEX) > ' '                         
                      ADD +1 TO WS-GAS-METER-COUNT                      
               END-IF                                                   
               IF T1-CODE-UTIL-TYPE (T1-INDEX) = 'E' AND                
                  T1-WORK-TYPE (T1-INDEX) > ' '                         
                      ADD +1 TO WS-ELEC-METER-COUNT                     
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           IF LINK-ORDER-TYPE-CD NOT = 'FM006' AND                      
              AT-COMPANY-NO = '01'                                      
                  IF WS-GAS-METER-COUNT > 0 AND                         
                     CSR-DATABASE                                       
                         PERFORM 2100-SEASONAL-GAS-CHARGE THRU 2100-EXIT
                  END-IF                                                
                  IF LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC'             
                      PERFORM 2300-SEASONAL-ELEC-CHARGE THRU            
                              2300-EXIT                                 
                      PERFORM 2400-ELEC-RECONNECT-CHARGE THRU           
                              2400-EXIT
                  END-IF
           END-IF.                                
                                                                        
P00795     IF AT-COMPANY-NO = '26' AND                                  
P0795A         (LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC')                 
                  PERFORM 2200-PSNC-SAME-CUSTOMER THRU 2200-EXIT
           END-IF.       
                                                                        
P00795     IF LINK-ORDER-TYPE-CD(1:2) NOT = 'CC' AND                    
P00795        LINK-ORDER-TYPE-CD(1:2) NOT = 'NC'                        
P00795       PERFORM 7120-SELECT-SO-WAIVER THRU 7120-EXIT               
P00795       PERFORM 2500-GET-CHARGE THRU 2500-EXIT                     
P00795     END-IF.                                                      
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE +100 TO S-RETURN-CODE                                
              MOVE 'NO DATA' TO S-BUS-RULE-ID                           
              ADD +1 TO CTR-ROWS                                        
              PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * SCE&G GAS SEASONAL BLOCK CHARGES                                        
                                                                        
       2100-SEASONAL-GAS-CHARGE.                                        
                                                                        
           MOVE 'N' TO WS-CHARGE-SEASONAL.                              
                                                                        
           IF (LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC') AND              
               CU-CUSTOMER-NO NOT = AT-CUSTOMER-NO                      
                   GO TO 2100-EXIT
           END-IF.                                     
                                                                        
           SET T2-INDEX TO 1.                                           
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL T1-INDEX > 50 OR  
                           T1-CODE-UTIL-TYPE (T1-INDEX) <= ' '          
               IF T1-CODE-UTIL-TYPE (T1-INDEX) = 'G' AND                
                  T1-METER-STATUS (T1-INDEX) NOT = 'A' AND              
                 (T1-WORK-TYPE (T1-INDEX) = 'UNB' OR 'SOL' OR   'SOR'   
                                          OR 'SOS' OR 'REC')            
                      MOVE T1-METER-STATUS (T1-INDEX) TO                
                           T2-METER-STATUS (T2-INDEX)                   
                      MOVE T1-WORK-TYPE (T1-INDEX) TO                   
                           T2-WORK-TYPE (T2-INDEX)                      
                      IF T1-IC-NO (T1-INDEX) NUMERIC                    
                          MOVE T1-IC-NO (T1-INDEX) TO                   
                               T2-IC-NO (T2-INDEX)                      
                      ELSE                                              
                          MOVE 0001 TO T2-IC-NO (T2-INDEX)              
                      END-IF                                            
                      IF T1-MTR-REF-NO (T1-INDEX) NUMERIC               
                          MOVE T1-MTR-REF-NO (T1-INDEX) TO              
                               T2-MTR-REF-NO (T2-INDEX)                 
                      ELSE                                              
                          MOVE 0001 TO T2-MTR-REF-NO (T2-INDEX)         
                      END-IF                                            
                      MOVE T2-IC-NO (T2-INDEX) TO MN-IC-NO              
                      MOVE T2-MTR-REF-NO (T2-INDEX) TO MN-MTR-REF-NO    
                      MOVE 'G' TO MN-CODE-UTIL-TYPE                     
                      PERFORM 7020-SELECT-METER-INFO THRU               
                              7020-EXIT                                 
                      MOVE MN-MTR-STATUS-CHNG-DT TO                     
                           T2-STATUS-CHG-DT (T2-INDEX)                  
                      MOVE MN-CODE-STATUS-REAS TO                       
                           T2-MTR-STATUS-REASON (T2-INDEX)              
                      IF (MN-CODE-STATUS-REAS = 'C' OR 'Y' OR 'B') AND  
                          MN-MTR-STATUS-CHNG-DT NOT =                   
                          LINK-ASSIGNED-DATE AND                        
                          MN-MTR-STATUS-CHNG-DT > '2005-10-31'          
                              MOVE 'Y' TO T2-SEAS-BLOCK-FL (T2-INDEX)   
                      ELSE                                              
                          MOVE 'N' TO T2-SEAS-BLOCK-FL (T2-INDEX)       
                      END-IF                                            
                      MOVE UT-RATE-PLAN-NO TO T2-RATE-PLAN-NO (T2-INDEX)
                      SET T2-INDEX UP BY 1                              
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING T2-INDEX FROM 1 BY 1 UNTIL T2-INDEX > 50 OR  
               T2-METER-STATUS (T2-INDEX) <= ' '                        
                   IF T2-SEAS-BLOCK-FL (T2-INDEX) = 'Y'                 
                       PERFORM 2110-SEAS-BLOCK-EDITS THRU 2110-EXIT     
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING T2-INDEX FROM 1 BY 1 UNTIL T2-INDEX > 50 OR  
               T2-METER-STATUS (T2-INDEX) <= ' '                        
                   IF T2-SEAS-BLOCK-FL (T2-INDEX) = 'Y'                 
                       MOVE 'Y' TO WS-CHARGE-SEASONAL                   
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
           IF WS-CHARGE-SEASONAL = 'Y'                                  
               PERFORM 5000-CALL-CSR03817 THRU 5000-EXIT
           END-IF.               
                                                                        
           IF WS-SEAS-BLOCK-GAS-AMT > 0                                 
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE 'ORDRCF0018' TO S-BUS-RULE-ID                       
               MOVE 'CHARGES' TO S-ACTION-TYPE-CD                       
               PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               MOVE WS-SEAS-BLOCK-GAS-AMT TO S-CHARGE-AMT               
               MOVE 'SEABLKGAS' TO S-CHARGE-TYPE                        
               MOVE 'G' TO S-CODE-UTIL-TYPE                             
               MOVE MONTH-CT-3817 TO WS-FORMAT-MONTHS                   
               MOVE MONTH-AVG-3817 TO WS-FORMAT-AMT                     
               STRING WS-FORMAT-MONTHS                                  
                      ';'                                               
                      WS-FORMAT-AMT                                     
                      DELIMITED BY SIZE                                 
                      INTO S-MESSAGE-PARMS                              
               END-STRING                                               
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-SEAS-BLOCK-EDITS.                                           
                                                                        
           IF LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC'                    
               NEXT SENTENCE                                            
           ELSE                                                         
               IF (T2-STATUS-CHG-DT (T2-INDEX) <=                       
                   AT-ACCT-CREATE-DT(1:10)) OR                          
                   T2-MTR-STATUS-REASON (T2-INDEX) = 'B'                
                        MOVE 'N' TO T2-SEAS-BLOCK-FL (T2-INDEX)
               END-IF
           END-IF.        
                                                                        
           IF LINK-ORDER-TYPE-CD = 'FM003' AND                          
              CU-CUSTOMER-NO NOT = AT-CUSTOMER-NO                       
                  MOVE 'N' TO T2-SEAS-BLOCK-FL (T2-INDEX)
           END-IF.              
                                                                        
           IF T2-SEAS-BLOCK-FL (T2-INDEX) = 'Y'                         
               MOVE T2-RATE-PLAN-NO (T2-INDEX) TO RT-RATE-PLAN-NO       
               PERFORM 7030-RATE-CREATOR THRU 7030-EXIT                 
               IF RT-SEASNAL-BLK-CHG-CD NOT = 'Y'                       
                   MOVE 'N' TO T2-SEAS-BLOCK-FL (T2-INDEX)
               END-IF
           END-IF.             
                                                                        
           IF T2-SEAS-BLOCK-FL (T2-INDEX) = 'Y'                         
               PERFORM 2120-COUNT-MONTHS THRU 2120-EXIT                 
               IF WS-COUNT-MONTHS > 12                                  
                   MOVE 'N' TO T2-SEAS-BLOCK-FL (T2-INDEX)
               END-IF
           END-IF.             
                                                                        
           IF T2-SEAS-BLOCK-FL (T2-INDEX) = 'Y' AND                     
              (WS-OLDEST-STATUS-DT <= ' ' OR                            
               T2-STATUS-CHG-DT (T2-INDEX) <= WS-OLDEST-STATUS-DT)      
                  MOVE T2-STATUS-CHG-DT (T2-INDEX) TO                   
                       WS-OLDEST-STATUS-DT
           END-IF.                             
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2120-COUNT-MONTHS.                                               
                                                                        
           MOVE T2-STATUS-CHG-DT (T2-INDEX) TO WS-FROM-DATE.            
           MOVE LINK-ASSIGNED-DATE TO WS-TO-DATE.                       
           MOVE '01' TO WS-FROM-DATE(9:2)                               
                        WS-TO-DATE(9:2).                                
           EXEC SQL                                                     
               SELECT
              CIS.DIFFDATE( IIF(TRY_CONVERT(DATE, :WS-TO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TO-DATE) <> 0) OR (LEN(
                                                            :WS-TO-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-TO-DATE), CONVERT(DATE, 
                                                            :WS-TO-DATE
              ) ), IIF(TRY_CONVERT(DATE, :WS-FROM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FROM-DATE
              ) <> 0) OR (LEN(:WS-FROM-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-FROM-DATE
              ), CONVERT(DATE, :WS-FROM-DATE) ) )
            INTO
              :WS-DATE-DIFF                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES (DATE(:WS-TO-DATE) - DATE(:WS-FROM-DATE))                 
MFA-TR*          INTO :WS-DATE-DIFF                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-DATE-DIFF TO WS-DATE-DIFF-UNPACKED.                  
           MOVE WS-DATE-DIFF-UNPACKED(3:2) TO WS-YEARS.                 
           MOVE WS-DATE-DIFF-UNPACKED(5:2) TO WS-MONTHS.                
           COMPUTE WS-COUNT-MONTHS =                                    
               (WS-YEARS * 12) +                                        
                WS-MONTHS +                                             
                1.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * PSNC SAME CUSTOMER MOVING BACK IN WITHIN 12 MONTHS (OR                  
      * WITHIN 36 MONTHS AFTER DNPFB) REGARDLESS OF INTERVENING                 
      * CUSTOMERS AT PREMISE. PSNC NEW CUSTOMER ROW IS A PLACEHOLDER            
      * TO ALLOW USER TO SELECT AH/HOLIDAY/WEEKEND CHARGE.                      
                                                                        
       2200-PSNC-SAME-CUSTOMER.                                         
                                                                        
           PERFORM 7040-SELECT-LANDLORD THRU 7040-EXIT.                 
           IF SI-CUSTOMER-NO = CU-CUSTOMER-NO                           
               GO TO 2200-EXIT
           END-IF.                                         
                                                                        
           MOVE 'N' TO WS-SAME-CUST-12                                  
                       WS-SAME-CUST-36.                                 
           PERFORM 7050-SELECT-PREMHIST-12 THRU 7050-EXIT.              
           IF WS-SAME-CUST-12 = 'N'                                     
               PERFORM 7060-SELECT-PREMHIST-36 THRU 7060-EXIT
           END-IF.          
           IF WS-SAME-CUST-12 = 'Y' OR                                  
              WS-SAME-CUST-36 = 'Y'                                     
                  PERFORM 7130-SELECT-PSNC-CHG THRU 7130-EXIT           
P00795            MOVE XA-STD-LABOR-CHRG TO WS-PSNC-SAME-CUST-AMT
           END-IF.      
                                                                        
           IF WS-PSNC-SAME-CUST-AMT > 0                                 
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE WS-PSNC-SAME-CUST-AMT TO S-CHARGE-AMT               
P00795         MOVE 'RDO' TO S-WORK-TYPE-CD                             
               MOVE 'X' TO S-WORK-PERIOD                                
               MOVE 'PSNCSAMCUS' TO S-CHARGE-TYPE                       
               MOVE 'G' TO S-CODE-UTIL-TYPE                             
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
           ELSE                                                         
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE 0.00 TO S-CHARGE-AMT                                
P00795         MOVE 'RDO' TO S-WORK-TYPE-CD                             
               MOVE 'X' TO S-WORK-PERIOD                                
               MOVE 'PSNCNEWCUS' TO S-CHARGE-TYPE                       
               MOVE 'G' TO S-CODE-UTIL-TYPE                             
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * SCE&G SAME CUSTOMER/SPOUSE UNBLOCKING METER WHICH WAS BLOCKED           
      * WITH A REASON OF SEASONAL WITHIN 12 MONTHS.                             
                                                                        
       2300-SEASONAL-ELEC-CHARGE.                                       
                                                                        
           IF CU-CUSTOMER-NO = AT-CUSTOMER-NO OR WS-OLD-SPOUSE-NO       
               CONTINUE                                                 
           ELSE                                                         
               GO TO 2300-EXIT
           END-IF.                                         
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL T1-INDEX > 50 OR  
                           T1-CODE-UTIL-TYPE (T1-INDEX) <= ' '          
               IF T1-CODE-UTIL-TYPE (T1-INDEX) = 'E' AND                
                  T1-METER-STATUS (T1-INDEX) NOT = 'A' AND              
                 (T1-WORK-TYPE (T1-INDEX) = 'UNB' OR 'SOL' OR   'SOR'   
                                          OR 'SOS' OR 'REC')            
                      IF T1-IC-NO (T1-INDEX) NUMERIC                    
                          MOVE T1-IC-NO (T1-INDEX) TO MN-IC-NO          
                      ELSE                                              
                          MOVE 0001 TO MN-IC-NO                         
                      END-IF                                            
                      IF T1-MTR-REF-NO (T1-INDEX) NUMERIC               
                          MOVE T1-MTR-REF-NO (T1-INDEX) TO              
                               MN-MTR-REF-NO                            
                      ELSE                                              
                          MOVE 0001 TO MN-MTR-REF-NO                    
                      END-IF                                            
                      MOVE 'E' TO MN-CODE-UTIL-TYPE                     
                      PERFORM 7020-SELECT-METER-INFO THRU               
                              7020-EXIT                                 
                      IF MN-CODE-STATUS-REAS = 'C' AND                  
                         MN-MTR-STATUS-CHNG-DT >=                       
                         WS-DATE-MINUS-12-MONTHS                        
                             MOVE WS-DELINQ-SEABLKELEC TO               
                                  WS-SEAS-BLOCK-ELEC-AMT                
                      END-IF                                            
               END-IF                                                   
           END-PERFORM.                                                 
                                                                        
           IF WS-SEAS-BLOCK-ELEC-AMT > 0                                
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE 0 TO S-RETURN-CODE                                  
A04670         MOVE 'ORDRCF0017' TO S-BUS-RULE-ID                       
A04670         MOVE 'PSEABLKELE' TO S-ACTION-TYPE-CD                    
A04670         PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               MOVE WS-SEAS-BLOCK-ELEC-AMT TO S-CHARGE-AMT              
               MOVE 'SEABLKELEC' TO S-CHARGE-TYPE                       
               MOVE 'E' TO S-CODE-UTIL-TYPE                             
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * SCE&G SAME CUSTOMER/SPOUSE RECONNECT ELECTRIC AFTER DNPFB               
      * WITHIN 12 MONTHS                                                        
                                                                        
       2400-ELEC-RECONNECT-CHARGE.                                      
                                                                        
           IF (LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC') AND              
              (CU-CUSTOMER-NO = AT-CUSTOMER-NO OR                       
                                WS-OLD-SPOUSE-NO) AND                   
               WS-ELEC-METER-COUNT > 0 AND                              
               AT-CODE-STATUS-REASON = 'C' AND                          
               AT-ACCT-FINALED-DT(1:10) >= WS-DATE-MINUS-12-MONTHS      
                   MOVE WS-DELINQ-SCEGRECON TO WS-SCEG-RECONNECT-AMT
           END-IF.   
                                                                        
           IF WS-SCEG-RECONNECT-AMT > 0                                 
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE 0 TO S-RETURN-CODE                                  
A04670         MOVE 'ORDRCF0017' TO S-BUS-RULE-ID                       
A04670         MOVE 'PSCEGRECON' TO S-ACTION-TYPE-CD                    
A04670         PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               MOVE WS-SCEG-RECONNECT-AMT TO S-CHARGE-AMT               
               MOVE 'SCEGRECON' TO S-CHARGE-TYPE                        
               MOVE 'E' TO S-CODE-UTIL-TYPE                             
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795* 2500-GET-CHARGE *********************************************           
P00795* LOADS HIGHEST CHARGE AMT AND SENDS WORK TYPE CODE OF THAT               
P00795* HIGHEST CHARGE. WE WILL SEND ONLY ONE ROW FOR GAS DEFAULT AND           
P00795* ONE ROW FOR ELEC DEFAULT.                                               
P00795                                                                  
P00795 2500-GET-CHARGE.                                                 
P00795                                                                  
P00795     MOVE 0 TO WS-GAS-DEFAULT-AMT.                                
P00795     MOVE 0 TO WS-STD-CHG-AMT.                                    
P00795                                                                  
P00795     PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL T1-INDEX > 50 OR  
P00795                     T1-CODE-UTIL-TYPE (T1-INDEX) <= ' '          
P00795         IF T1-CODE-UTIL-TYPE (T1-INDEX) = 'G' AND                
P00795           (T1-WORK-TYPE (T1-INDEX) NOT = '   ' )                 
P00795              MOVE T1-WORK-TYPE (T1-INDEX) TO XA-WORK-TYPE-CD     
P00795              MOVE T1-CODE-UTIL-TYPE (T1-INDEX) TO WS-CODE-UT-TYPE
P00795              MOVE 'N' TO WS-SERV-CHARGE-EXISTS                   
P00795              PERFORM 7110-SELECT-SERVICE-CHG THRU 7110-EXIT      
P00795              IF WS-SERV-CHARGE-EXISTS = 'Y'                      
P00795                 MOVE XA-STD-LABOR-CHRG TO WS-STD-CHG-AMT         
P00795              ELSE                                                
P00795                 MOVE ZEROES            TO WS-STD-CHG-AMT         
P00795              END-IF                                              
P00795              IF WS-STD-CHG-AMT >= WS-GAS-DEFAULT-AMT             
P00795                 MOVE WS-STD-CHG-AMT TO WS-GAS-DEFAULT-AMT        
P00795                 MOVE XA-WORK-TYPE-CD TO WS-WORK-TYPE-CD          
P00795                 MOVE XA-WORK-PERIOD-CD TO WS-WORK-PERIOD-CD      
P00795              END-IF                                              
P00795         END-IF                                                   
P00795     END-PERFORM.                                                 
                                                                        
P00795*    IF WS-GAS-DEFAULT-AMT = 0 AND XA-WORK-PERIOD-CD NOT = 'W'            
P00795*        PERFORM 7100-SELECT-ORDER-TYPE THRU 7100-EXIT                    
P00795*        IF C2-ORDER-CHARGE-AMT > 0                                       
P00795*          MOVE C2-ORDER-CHARGE-AMT TO WS-GAS-DEFAULT-AMT                 
P00795*          MOVE 'W'                 TO WS-WORK-PERIOD-CD                  
P00795*        ELSE                                                             
P00795*          MOVE SPACES              TO WS-WORK-PERIOD-CD                  
P00795*        END-IF                                                           
P00795*    END-IF.                                                              
                                                                        
P00795     IF WS-GAS-DEFAULT-AMT >= 0 AND WS-WORK-PERIOD-CD > ' '       
P00795         INITIALIZE GTT-RETURN-FIELDS                             
P00795         MOVE WS-GAS-DEFAULT-AMT TO S-CHARGE-AMT                  
P00795         MOVE WS-WORK-TYPE-CD TO S-WORK-TYPE-CD                   
P00795         MOVE SU-WAIVER-TYPE-CD TO S-WAIVER-TYPE                  
P00795         MOVE WS-WORK-PERIOD-CD TO S-WORK-PERIOD                  
P00795         MOVE 'GASDEF' TO S-CHARGE-TYPE                           
P00795         MOVE 'G' TO S-CODE-UTIL-TYPE                             
P00795         IF WS-GTT01-DECLARED = 'N'                               
P00795             PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
P00795         END-IF                                                   
P00795         PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
P00795     MOVE 0 TO WS-ELEC-DEFAULT-AMT.                               
P00795     MOVE 0 TO WS-STD-CHG-AMT.                                    
                                                                        
P00795     PERFORM VARYING T1-INDEX FROM 1 BY 1 UNTIL T1-INDEX > 50 OR  
P00795                     T1-CODE-UTIL-TYPE (T1-INDEX) <= ' '          
P00795         IF T1-CODE-UTIL-TYPE (T1-INDEX) = 'E' AND                
P00795           (T1-WORK-TYPE (T1-INDEX) NOT = '   ' )                 
P00795              MOVE T1-WORK-TYPE (T1-INDEX) TO XA-WORK-TYPE-CD     
P00795              MOVE T1-CODE-UTIL-TYPE (T1-INDEX) TO WS-CODE-UT-TYPE
P00795              MOVE 'N' TO WS-SERV-CHARGE-EXISTS                   
P00795              PERFORM 7110-SELECT-SERVICE-CHG THRU 7110-EXIT      
P00795              IF WS-SERV-CHARGE-EXISTS = 'Y'                      
P00795                 MOVE XA-STD-LABOR-CHRG TO WS-STD-CHG-AMT         
P00795              ELSE                                                
P00795                 MOVE ZEROES            TO WS-STD-CHG-AMT         
P00795              END-IF                                              
P00795              IF WS-STD-CHG-AMT > WS-ELEC-DEFAULT-AMT             
P00795                 MOVE WS-STD-CHG-AMT TO WS-ELEC-DEFAULT-AMT       
P00795                 MOVE XA-WORK-TYPE-CD TO WS-WORK-TYPE-CD          
P00795                 MOVE XA-WORK-PERIOD-CD TO WS-WORK-PERIOD-CD      
P00795              END-IF                                              
P00795         END-IF                                                   
P00795     END-PERFORM.                                                 
                                                                        
P00795     IF WS-ELEC-DEFAULT-AMT > 0 AND WS-WORK-PERIOD-CD > ' '       
P00795         INITIALIZE GTT-RETURN-FIELDS                             
P00795         MOVE WS-ELEC-DEFAULT-AMT TO S-CHARGE-AMT                 
P00795         MOVE WS-WORK-TYPE-CD TO S-WORK-TYPE-CD                   
P00795         MOVE SU-WAIVER-TYPE-CD TO S-WAIVER-TYPE                  
P00795         MOVE WS-WORK-PERIOD-CD TO S-WORK-PERIOD                  
P00795         MOVE 'ELECDEF' TO S-CHARGE-TYPE                          
P00795         MOVE 'E' TO S-CODE-UTIL-TYPE                             
P00795         IF WS-GTT01-DECLARED = 'N'                               
P00795             PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
P00795         END-IF                                                   
P00795         PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
P00795                                                                  
P00795 2500-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
       5000-CALL-CSR03817.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-IN-3817.                  
           MOVE LINK-ASSIGNED-DATE TO ON-DATE-IN-3817.                  
           MOVE WS-OLDEST-STATUS-DT TO OFF-DATE-IN-3817.                
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR03817                                             
      *           (:ACCOUNT-NO-IN-3817,                                 
      *            :OFF-DATE-IN-3817,                                   
      *            :ON-DATE-IN-3817)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_3817
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_3817
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_3817 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR03817'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-IN-3817    TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC3817)                                                
      *       WITH PROCEDURE CSR03817                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_3817 CURSOR FOR RESULT SET        
      *       :LOC3817                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_3817 INTO                            
                 :ACCOUNT-NO-OUT-3817,                                  
                 :OFF-DATE-OUT-3817,                                    
                 :ON-DATE-OUT-3817,                                     
                 :RETURN-CODE-3817,                                     
                 :CHARGE-AMT-3817,                                      
                 :MONTH-CT-3817,                                        
                 :MONTH-AVG-3817                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-3817 NOT = 0                          
                        MOVE RETURN-CODE-3817 TO WS-ACTIVE-RETURN-CODE  
                        MOVE PROGRAM-NAME      TO ABEND-PROGRAM         
                        MOVE '5000'            TO ACTIVE-PARAGRAPH      
                        MOVE 'FETCH'           TO ABEND-FUNCTION        
                        MOVE 'CSR03817'        TO TABLE-1               
                        MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1       
                        MOVE ACCOUNT-NO-IN-3817 TO HOSTVAR-ELEMENT-1    
                        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT       
                   END-IF                                               
                   MOVE CHARGE-AMT-3817 TO WS-SEAS-BLOCK-GAS-AMT        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5000'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR03817'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-IN-3817    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CUSTOMER_NO,                                      
                      COMPANY_NO,                                       
                      CODE_STATUS_REASON,                               
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
                      REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                      PREMISE_NO,                                       
                      ACCOUNT_TYPE_CODE                                 
                 INTO :AT-CUSTOMER-NO,                                  
                      :AT-COMPANY-NO,                                   
                      :AT-CODE-STATUS-REASON,                           
                      :AT-ACCT-CREATE-DT :WS-NULL2,                      
                      :AT-ACCT-FINALED-DT :WS-NULL3,                     
                      :AT-PREMISE-NO,                                   
                      :AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO,                                              
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               CODE_STATUS_REASON,                                       
MFA-TR*               ACCT_CREATE_DT,                                           
MFA-TR*               ACCT_FINALED_DT,                                          
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               ACCOUNT_TYPE_CODE                                         
MFA-TR*          INTO :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-COMPANY-NO,                                           
MFA-TR*               :AT-CODE-STATUS-REASON,                                   
MFA-TR*               :AT-ACCT-CREATE-DT:WS-NULL2,                              
MFA-TR*               :AT-ACCT-FINALED-DT:WS-NULL3,                             
MFA-TR*               :AT-PREMISE-NO,                                           
MFA-TR*               :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO AT-ACCT-CREATE-DT                 
                   END-IF                                               
                   IF WS-NULL3 < 0                                      
                       MOVE SPACES TO AT-ACCT-FINALED-DT                
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-DELINQ.                                              
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD  = 'DATABASE'                           
                 AND  COMPANY_NO = :AT-COMPANY-NO                       
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = 'DATABASE'                                   
MFA-TR*          AND  COMPANY_NO = :AT-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 70101                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE C8-DELINQ-VALUE TO WS-DATABASE                      
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7010'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSS_DELINQUENCY'  TO TABLE-1                       
               MOVE 'DELINQ_VALUE'     TO TABLE-ELEMENT-1               
               MOVE 'DATABASE'         TO HOSTVAR-ELEMENT-1             
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2               
               MOVE AT-COMPANY-NO      TO HOSTVAR-ELEMENT-2             
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD  = 'SCEGRECON'                          
                 AND  COMPANY_NO = '01'                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = 'SCEGRECON'                                  
MFA-TR*          AND  COMPANY_NO = '01'                                         
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 70102                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-DELINQ-SCEGRECON          
               WHEN NOT-FOUND                                           
                   MOVE 25.00 TO WS-DELINQ-SCEGRECON                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME   TO ABEND-PROGRAM                 
                   MOVE '7010'         TO ACTIVE-PARAGRAPH              
                   MOVE 'SELECT'       TO ABEND-FUNCTION                
                   MOVE SPACES         TO ABEND-SQL-PREDICATES          
                                              ABEND-TABLES              
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_VALUE' TO TABLE-ELEMENT-1               
                   MOVE 'SCEGRECON'    TO HOSTVAR-ELEMENT-1             
                   MOVE '01'           TO TABLE-ELEMENT-2               
                   MOVE AT-COMPANY-NO  TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD  = 'SEABLKELEC'                         
                 AND  COMPANY_NO = '01'                                 
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = 'SEABLKELEC'                                 
MFA-TR*          AND  COMPANY_NO = '01'                                         
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 70103                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE C8-DELINQ-VALUE TO WS-DELINQ-SEABLKELEC         
               WHEN NOT-FOUND                                           
                   MOVE 25.00 TO WS-DELINQ-SEABLKELEC                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME   TO ABEND-PROGRAM                 
                   MOVE '7010'         TO ACTIVE-PARAGRAPH              
                   MOVE 'SELECT'       TO ABEND-FUNCTION                
                   MOVE SPACES         TO ABEND-SQL-PREDICATES          
                                              ABEND-TABLES              
                   MOVE 'CSS_DELINQUENCY' TO TABLE-1                    
                   MOVE 'DELINQ_VALUE' TO TABLE-ELEMENT-1               
                   MOVE 'SEABLKELEC'   TO HOSTVAR-ELEMENT-1             
                   MOVE '01'           TO TABLE-ELEMENT-2               
                   MOVE AT-COMPANY-NO  TO HOSTVAR-ELEMENT-2             
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7013-RULE-XREF.                                                  
                                                                        
           MOVE S-BUS-RULE-ID TO 1T-BUS-RULE-ID.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                    
               WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                   
                 AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                
                 AND APPLICATION_ID = 'CSR'                             
                 AND COMPANY_NO     = '00'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE_XREF                                          
MFA-TR*        WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                           
MFA-TR*          AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                        
MFA-TR*          AND APPLICATION_ID = 'CSR'                                     
MFA-TR*          AND COMPANY_NO     = '00'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7013                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID       
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BUS-RULE-XREF-ID                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7013'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_RULE_XREF' TO TABLE-1                  
                   MOVE 'BUS_RULE_ID'       TO TABLE-ELEMENT-1          
                   MOVE 1T-BUS-RULE-ID      TO HOSTVAR-ELEMENT-1        
                   MOVE 'BUS_PROCESS_ID'    TO TABLE-ELEMENT-2          
                   MOVE 1T-BUS-PROCESS-ID   TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7013-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-METER-INFO.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MTR_STATUS_CHNG_DT,
              CODE_STATUS_REAS,
              RATE_PLAN_NO                                      
                 INTO :MN-MTR-STATUS-CHNG-DT :WS-NULL1,                  
                      :MN-CODE-STATUS-REAS,                             
                      :UT-RATE-PLAN-NO                                  
                 FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED),                
                      CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE MN.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE            
                  AND MN.IC_NO = :MN-IC-NO                              
                  AND MN.MTR_REF_NO = :MN-MTR-REF-NO                    
                  AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                     
                  AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE             
                  AND MN.IC_NO = UT.IC_NO                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MTR_STATUS_CHNG_DT,                                       
MFA-TR*               CODE_STATUS_REAS,                                         
MFA-TR*               RATE_PLAN_NO                                              
MFA-TR*          INTO :MN-MTR-STATUS-CHNG-DT:WS-NULL1,                          
MFA-TR*               :MN-CODE-STATUS-REAS,                                     
MFA-TR*               :UT-RATE-PLAN-NO                                          
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN,                                      
MFA-TR*               CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE MN.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                    
MFA-TR*           AND MN.IC_NO = :MN-IC-NO                                      
MFA-TR*           AND MN.MTR_REF_NO = :MN-MTR-REF-NO                            
MFA-TR*           AND MN.ACCOUNT_NO = UT.ACCOUNT_NO                             
MFA-TR*           AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                     
MFA-TR*           AND MN.IC_NO = UT.IC_NO                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7020                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL1 < 0                                      
                       MOVE '2005-01-01' TO MN-MTR-STATUS-CHNG-DT       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO MN-MTR-STATUS-CHNG-DT                 
                                  MN-CODE-STATUS-REAS                   
                                  UT-RATE-PLAN-NO                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7020'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-2                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   MOVE 'IC_NO'            TO TABLE-ELEMENT-2           
                   MOVE MN-IC-NO           TO HOSTVAR-ELEMENT-2         
                   MOVE 'MTR_REF_NO'       TO TABLE-ELEMENT-3           
                   MOVE MN-MTR-REF-NO      TO HOSTVAR-ELEMENT-3         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-RATE-CREATOR.                                               
                                                                        
           EXEC SQL                                                     
               SELECT SEASNAL_BLK_CHG_CD                                
                 INTO :RT-SEASNAL-BLK-CHG-CD                            
                 FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)                    
                WHERE CODE_UTIL_TYPE = 'G'                              
                  AND RATE_PLAN_NO = :RT-RATE-PLAN-NO                   
                  AND CODE_STATUS  = 'A'                                
                  AND VERSION_NO_CNTRL =                                
                     (SELECT MAX(VERSION_NO_CNTRL)                      
                        FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)             
                       WHERE CODE_UTIL_TYPE = 'G'                       
                         AND RATE_PLAN_NO = :RT-RATE-PLAN-NO            
                         AND CODE_STATUS = 'A')                         
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     46540000
MFA-TR*        SELECT SEASNAL_BLK_CHG_CD                                        
MFA-TR*          INTO :RT-SEASNAL-BLK-CHG-CD                                    
MFA-TR*          FROM CSS_RATE_CREATOR                                          
MFA-TR*         WHERE CODE_UTIL_TYPE = 'G'                                      
MFA-TR*           AND RATE_PLAN_NO = :RT-RATE-PLAN-NO                           
MFA-TR*           AND CODE_STATUS  = 'A'                                        
MFA-TR*           AND VERSION_NO_CNTRL =                                        
MFA-TR*              (SELECT MAX(VERSION_NO_CNTRL)                      46550000
MFA-TR*                 FROM CSS_RATE_CREATOR                           46570000
MFA-TR*                WHERE CODE_UTIL_TYPE = 'G'                       46580000
MFA-TR*                  AND RATE_PLAN_NO = :RT-RATE-PLAN-NO            46590000
MFA-TR*                  AND CODE_STATUS = 'A')                         46600000
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                    46630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7030'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_RATE_CREATOR' TO TABLE-1                   
                   MOVE 'RATE_PLAN_NO'     TO TABLE-ELEMENT-1           
                   MOVE RT-RATE-PLAN-NO    TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-LANDLORD.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO                                       
                 INTO :SI-CUSTOMER-NO                                   
                 FROM CSS_LANDLORD WITH(READUNCOMMITTED)                        
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     46540000
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :SI-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE PREMISE_NO = :AT-PREMISE-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7040                                                    
MFA-TR*    END-EXEC.                                                    46630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO SI-CUSTOMER-NO                        
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7040'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_LANDLORD'     TO TABLE-1                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-PREMHIST-12.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :CH-ACCOUNT-NO                                    
                 FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)                  
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
                  AND CUSTOMER_NO IN (:CU-CUSTOMER-NO,                  
                                      :WS-NEW-SPOUSE-NO,                
                                      :WS-CUST-AS-SPOUSE-NO)            
                  AND (DATE_UTIL_SVC_END >= IIF(TRY_CONVERT(DATE, 
                                               :WS-DATE-MINUS-12-MONTHS
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-MINUS-12-MONTHS
              ) <> 0) OR (LEN(:WS-DATE-MINUS-12-MONTHS
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-MINUS-12-MONTHS
              ), CONVERT(DATE, :WS-DATE-MINUS-12-MONTHS) )    
                   OR  DATE_UTIL_SVC_END IS NULL)                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     46540000
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :CH-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_CUST_PREM_HIST                                        
MFA-TR*         WHERE PREMISE_NO = :AT-PREMISE-NO                               
MFA-TR*           AND CUSTOMER_NO IN (:CU-CUSTOMER-NO,                          
MFA-TR*                               :WS-NEW-SPOUSE-NO,                        
MFA-TR*                               :WS-CUST-AS-SPOUSE-NO)                    
MFA-TR*           AND (DATE_UTIL_SVC_END >= :WS-DATE-MINUS-12-MONTHS            
MFA-TR*            OR  DATE_UTIL_SVC_END IS NULL)                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                    46630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SAME-CUST-12                          
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SAME-CUST-12                          
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7050'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                 
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-2           
                   MOVE CU-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2         
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-3           
                   MOVE WS-NEW-SPOUSE-NO   TO HOSTVAR-ELEMENT-3         
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-4           
                   MOVE WS-CUST-AS-SPOUSE-NO TO HOSTVAR-ELEMENT-4       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-PREMHIST-36.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CH.ACCOUNT_NO                                     
                 INTO :CH-ACCOUNT-NO                                    
                 FROM CSS_CUST_PREM_HIST CH WITH(READUNCOMMITTED),              
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE CH.PREMISE_NO = :AT-PREMISE-NO                    
                  AND CH.CUSTOMER_NO IN (:CU-CUSTOMER-NO,               
                                         :WS-NEW-SPOUSE-NO,             
                                         :WS-CUST-AS-SPOUSE-NO)         
                  AND DATE_UTIL_SVC_END >= IIF(TRY_CONVERT(DATE, 
                                               :WS-DATE-MINUS-36-MONTHS
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-MINUS-36-MONTHS
              ) <> 0) OR (LEN(:WS-DATE-MINUS-36-MONTHS
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-MINUS-36-MONTHS
              ), CONVERT(DATE, :WS-DATE-MINUS-36-MONTHS) )     
                  AND CH.ACCOUNT_NO = AT.ACCOUNT_NO                     
                  AND CODE_STATUS_REASON = 'C'                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     46540000
MFA-TR*        SELECT CH.ACCOUNT_NO                                             
MFA-TR*          INTO :CH-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_CUST_PREM_HIST CH,                                    
MFA-TR*               CSS_ACCOUNT AT                                            
MFA-TR*         WHERE CH.PREMISE_NO = :AT-PREMISE-NO                            
MFA-TR*           AND CH.CUSTOMER_NO IN (:CU-CUSTOMER-NO,                       
MFA-TR*                                  :WS-NEW-SPOUSE-NO,                     
MFA-TR*                                  :WS-CUST-AS-SPOUSE-NO)                 
MFA-TR*           AND DATE_UTIL_SVC_END >= :WS-DATE-MINUS-36-MONTHS             
MFA-TR*           AND CH.ACCOUNT_NO = AT.ACCOUNT_NO                             
MFA-TR*           AND CODE_STATUS_REASON = 'C'                                  
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                    46630000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SAME-CUST-36                          
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SAME-CUST-36                          
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7060'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                 
                   MOVE 'CSS_ACCOUNT'      TO TABLE-2                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-2           
                   MOVE CU-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2         
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-3           
                   MOVE WS-NEW-SPOUSE-NO   TO HOSTVAR-ELEMENT-3         
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-4           
                   MOVE WS-CUST-AS-SPOUSE-NO TO HOSTVAR-ELEMENT-4       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-SELECT-SPOUSE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SSN                                                
                INTO :CE-SSN                                            
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
               WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                      
                 AND CUSTOMER_TYPE   = 'S'                              
                 AND SSN <> ' '                                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SSN                                                        
MFA-TR*         INTO :CE-SSN                                                    
MFA-TR*         FROM CSS_CUST_STATS CE                                          
MFA-TR*        WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE   = 'S'                                      
MFA-TR*          AND SSN <> ' '                                                 
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO CE-SSN                                
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7070'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_STATS'   TO TABLE-1                   
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1           
                   MOVE CE-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1         
                   MOVE 'CUSTOMER_TYPE'    TO TABLE-ELEMENT-2           
                   MOVE 'S'                TO HOSTVAR-ELEMENT-2         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7080-SELECT-SPOUSE-CUSTNO.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO                                        
                INTO :CE-CUSTOMER-NO                                    
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE SSN = :CE-SSN                                      
                 AND CUSTOMER_TYPE = 'C'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*         INTO :CE-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE SSN = :CE-SSN                                              
MFA-TR*          AND CUSTOMER_TYPE = 'C'                                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7080                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO CE-CUSTOMER-NO                        
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7080'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_STATS'   TO TABLE-1                   
                   MOVE 'SSN'              TO TABLE-ELEMENT-1           
                   MOVE CE-SSN             TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7080-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7090-SELECT-CUST-SSN.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SSN                                                
                INTO :CE-SSN                                            
                FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                    
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
                 AND CUSTOMER_TYPE   = 'C'                              
                 AND SSN <> ' '                                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SSN                                                        
MFA-TR*         INTO :CE-SSN                                                    
MFA-TR*         FROM CSS_CUST_STATS CE                                          
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*          AND CUSTOMER_TYPE   = 'C'                                      
MFA-TR*          AND SSN <> ' '                                                 
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO CE-SSN                                
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7090'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_STATS'   TO TABLE-1                   
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1           
                   MOVE CU-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1         
                   MOVE 'CUSTOMER_TYPE'    TO TABLE-ELEMENT-2           
                   MOVE 'C'                TO HOSTVAR-ELEMENT-2         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7095-SELECT-CUSTNO.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO                                        
                INTO :CE-CUSTOMER-NO                                    
                FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                       
               WHERE SSN = :CE-SSN                                      
                 AND CUSTOMER_TYPE = 'S'                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*         INTO :CE-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_CUST_STATS                                             
MFA-TR*        WHERE SSN = :CE-SSN                                              
MFA-TR*          AND CUSTOMER_TYPE = 'S'                                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7095                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 999999999 TO CE-CUSTOMER-NO                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7095'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CUST_STATS'   TO TABLE-1                   
                   MOVE 'SSN'              TO TABLE-ELEMENT-1           
                   MOVE CE-SSN             TO HOSTVAR-ELEMENT-1         
                   MOVE 'CUSTOMER_TYPE'    TO TABLE-ELEMENT-2           
                   MOVE 'S'                TO HOSTVAR-ELEMENT-2         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7095-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-ORDER-TYPE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ORDER_CHARGE_AMT,
              CODE_UTIL_TYPE                                     
                INTO :C2-ORDER-CHARGE-AMT,                              
                     :C2-CODE-UTIL-TYPE                                 
                FROM CSS_ORDER_TYPE WITH(READUNCOMMITTED)                       
               WHERE ORDER_TYPE_CD = :LINK-ORDER-TYPE-CD                
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ORDER_CHARGE_AMT,                                          
MFA-TR*              CODE_UTIL_TYPE                                             
MFA-TR*         INTO :C2-ORDER-CHARGE-AMT,                                      
MFA-TR*              :C2-CODE-UTIL-TYPE                                         
MFA-TR*         FROM CSS_ORDER_TYPE                                             
MFA-TR*        WHERE ORDER_TYPE_CD = :LINK-ORDER-TYPE-CD                        
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO C2-ORDER-CHARGE-AMT                   
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7100'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_ORDER_TYPE'   TO TABLE-1                   
                   MOVE 'ORDER_TYPE_CD'    TO TABLE-ELEMENT-1           
                   MOVE LINK-ORDER-TYPE-CD TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-SELECT-SERVICE-CHG.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) STD_LABOR_CHRG,
              WORK_PERIOD_CD                                     
P00795          INTO :XA-STD-LABOR-CHRG,                                
P00795               :XA-WORK-PERIOD-CD                                 
P00795          FROM CSS_ORD_SERV_CHG WITH(READUNCOMMITTED)                     
               WHERE ORDER_TYPE_CD = :LINK-ORDER-TYPE-CD                
P00795           AND WORK_TYPE_CD = :XA-WORK-TYPE-CD                    
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                 AND ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE          
P00795           AND DEFAULT_FL = 'Y'                                   
P00795           AND CODE_UTIL_TYPE = :WS-CODE-UT-TYPE                  
P00795           AND EXPIRATION_DT > CAST(SYSDATETIMEOFFSET() AS DATE)          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STD_LABOR_CHRG,                                            
MFA-TR*              WORK_PERIOD_CD                                             
MFA-TR*         INTO :XA-STD-LABOR-CHRG,                                        
MFA-TR*              :XA-WORK-PERIOD-CD                                         
MFA-TR*         FROM CSS_ORD_SERV_CHG                                           
MFA-TR*        WHERE ORDER_TYPE_CD = :LINK-ORDER-TYPE-CD                        
MFA-TR*          AND WORK_TYPE_CD = :XA-WORK-TYPE-CD                            
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*          AND ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE                  
MFA-TR*          AND DEFAULT_FL = 'Y'                                           
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UT-TYPE                          
MFA-TR*          AND EXPIRATION_DT > CURRENT DATE                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
P00795             MOVE 'Y'    TO WS-SERV-CHARGE-EXISTS                 
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
P00795             MOVE ZEROES TO XA-STD-LABOR-CHRG                     
                                  WS-ACTIVE-RETURN-CODE                 
P00795             MOVE 'N'    TO WS-SERV-CHARGE-EXISTS                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7110'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
P00795             MOVE 'CSS_ORD_SERV_CHG' TO TABLE-1                   
                   MOVE 'ORDER_TYPE_CD'    TO TABLE-ELEMENT-1           
                   MOVE LINK-ORDER-TYPE-CD TO HOSTVAR-ELEMENT-1         
                   MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2           
                   MOVE AT-COMPANY-NO      TO HOSTVAR-ELEMENT-2         
                   MOVE 'ACCOUNT_TYPE_CODE' TO TABLE-ELEMENT-3          
                   MOVE AT-ACCOUNT-TYPE-CODE TO HOSTVAR-ELEMENT-3       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-SELECT-SO-WAIVER.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) WAIVER_TYPE_CD                                     
                INTO :SU-WAIVER-TYPE-CD                                 
                FROM CSS_SO_WAIVER WITH(READUNCOMMITTED)                        
               WHERE ORDER_TYPE_CD = :LINK-ORDER-TYPE-CD                
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                 AND DEFAULT_IND = 'Y'                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WAIVER_TYPE_CD                                             
MFA-TR*         INTO :SU-WAIVER-TYPE-CD                                         
MFA-TR*         FROM CSS_SO_WAIVER                                              
MFA-TR*        WHERE ORDER_TYPE_CD = :LINK-ORDER-TYPE-CD                        
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*          AND DEFAULT_IND = 'Y'                                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO SU-WAIVER-TYPE-CD                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7120'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_WAIVER'    TO TABLE-1                   
                   MOVE 'ORDER_TYPE_CD'    TO TABLE-ELEMENT-1           
                   MOVE LINK-ORDER-TYPE-CD TO HOSTVAR-ELEMENT-1         
                   MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2           
                   MOVE AT-COMPANY-NO      TO HOSTVAR-ELEMENT-2         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7130-SELECT-PSNC-CHG.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) STD_LABOR_CHRG                                     
P00795          INTO :XA-STD-LABOR-CHRG                                 
P00795          FROM CSS_ORD_SERV_CHG WITH(READUNCOMMITTED)                     
               WHERE ORDER_TYPE_CD = :LINK-ORDER-TYPE-CD                
P00795           AND WORK_TYPE_CD = 'RDO'                               
                 AND COMPANY_NO = :AT-COMPANY-NO                        
                 AND ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE          
                 AND WORK_PERIOD_CD = 'X'                               
P00795           AND CODE_UTIL_TYPE = 'G'                               
P00795           AND EXPIRATION_DT > CAST(SYSDATETIMEOFFSET() AS DATE)          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT STD_LABOR_CHRG                                             
MFA-TR*         INTO :XA-STD-LABOR-CHRG                                         
MFA-TR*         FROM CSS_ORD_SERV_CHG                                           
MFA-TR*        WHERE ORDER_TYPE_CD = :LINK-ORDER-TYPE-CD                        
MFA-TR*          AND WORK_TYPE_CD = 'RDO'                                       
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*          AND ACCOUNT_TYPE_CODE = :AT-ACCOUNT-TYPE-CODE                  
MFA-TR*          AND WORK_PERIOD_CD = 'X'                                       
MFA-TR*          AND CODE_UTIL_TYPE = 'G'                                       
MFA-TR*          AND EXPIRATION_DT > CURRENT DATE                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
P00795             MOVE ZEROES TO XA-STD-LABOR-CHRG                     
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7130'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
P00795             MOVE 'CSS_ORD_SERV_CHG' TO TABLE-1                   
                   MOVE 'ORDER_TYPE_CD'    TO TABLE-ELEMENT-1           
                   MOVE LINK-ORDER-TYPE-CD TO HOSTVAR-ELEMENT-1         
                   MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2           
                   MOVE AT-COMPANY-NO      TO HOSTVAR-ELEMENT-2         
                   MOVE 'ACCOUNT_TYPE_CODE' TO TABLE-ELEMENT-3          
                   MOVE AT-ACCOUNT-TYPE-CODE TO HOSTVAR-ELEMENT-3       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04483_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04483_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8001'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04483_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04483_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              BUS_RULE_ID,                                              
              ACTION_TYPE_CD,                                           
              BUS_RULE_XREF_ID,                                         
              CHARGE_AMT,                                               
P00795        WORK_TYPE_CD,                                             
              WAIVER_TYPE,                                              
              WORK_PERIOD,                                              
              CHARGE_TYPE,                                              
              CODE_UTIL_TYPE,                                           
              MESSAGE_PARMS                                             
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-STATUS-CODE,                                          
               :S-BUS-RULE-ID,                                          
               :S-ACTION-TYPE-CD,                                       
               :S-BUS-RULE-XREF-ID,                                     
               :S-CHARGE-AMT,                                           
P00795         :S-WORK-TYPE-CD,                                         
               :S-WAIVER-TYPE,                                          
               :S-WORK-PERIOD,                                          
               :S-CHARGE-TYPE,                                          
               :S-CODE-UTIL-TYPE,                                       
               :S-MESSAGE-PARMS                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04483_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       ACTION_TYPE_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID,                                                 
MFA-TR*       CHARGE_AMT,                                                       
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       WAIVER_TYPE,                                                      
MFA-TR*       WORK_PERIOD,                                                      
MFA-TR*       CHARGE_TYPE,                                                      
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       MESSAGE_PARMS                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-BUS-RULE-ID,                                                  
MFA-TR*        :S-ACTION-TYPE-CD,                                               
MFA-TR*        :S-BUS-RULE-XREF-ID,                                             
MFA-TR*        :S-CHARGE-AMT,                                                   
MFA-TR*        :S-WORK-TYPE-CD,                                                 
MFA-TR*        :S-WAIVER-TYPE,                                                  
MFA-TR*        :S-WORK-PERIOD,                                                  
MFA-TR*        :S-CHARGE-TYPE,                                                  
MFA-TR*        :S-CODE-UTIL-TYPE,                                               
MFA-TR*        :S-MESSAGE-PARMS                                                 
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04483_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE                               
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF SQLCODE = 0                                               
               CONTINUE                                                 
           ELSE                                                         
               MOVE 'ROLLBACK'         TO ABEND-FUNCTION
           END-IF.               
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
