       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04482.                                          
       AUTHOR.       FRAN BARRY.                                        
       DATE-WRITTEN. APR 2012.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS IS THE 'NEXT' AND DATE CHANGE DRIVER.                    *        
      *  LINK FUNCTION VALUES ARE:                                     *        
      *       A - DATE CHANGE PROCESSING                               *        
      *       B - DATE/WORK TYPE/SPLIT PROCESSING                      *        
      *       C - DATE/WORK TYPE PROCESSING                            *        
      *       D - SPLIT PROCESSING                                     *        
      *       E - APPLIANCE MESSAGES ONLY                              *        
      *  WORKING STORAGE TABLES:                                       *        
      *       T3      ORDER DATA                                       *        
      *       T4      METER DATA                                       *        
      *       T5      ORDER INSTRUCTIONS                               *        
      *       T7      WORK GROUP CALENDAR                              *        
      *       T8      SPLIT SCENARIOS                                  *        
      *       T9      LIGHTING                                         *        
      *       T10     PARM METER DATA                                  *        
      *       T11     UTILITY DATA                                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  04/11/2012 FMB       INITIAL VERSION                          *        
A04670*  06/04/2013 FMB       OMIT PAYMENT REQUIRED FOR XFER.          *        
A04670*                       ADD PR THRESHOLD PROCESSING.             *        
A04670*  08/02/2013 FMB       ONLY PERFORM PR PROCESSING ONCE.         *        
A04670*  08/08/2013 FMB       HANDLE SEASONAL REVERTS FOR DATE CHANGE. *        
A04670*  11/05/2013 FMB       SET RS2 RETURN CODE TO +100 FOR E CALL   *        
A04670*                       SO UI WILL NOT OVERLAY RES WITH 0.       *        
A04670*  12/26/2013 DB18339   ADDING NEW BUSINESS RULE FOR DEFECT 1946 *        
A4670A*  02/27/2014 DB18339   ADDED NEW BUSINESS RULE FOR DEFECT 1946  *        
P00795*  03/10/2014 PK44514   AOO CHANGES                              *        
P00718*  03/11/2014 VV90387   ADDED BUSINESS UNIT                      *        
P00795*  06/11/2014 PK44514   AOO CHANGES - FOR NEW SET ORDER          *        
A05020*  11/10/2014 VV90387   INITIALIZE WORK DISTRICT                 *        
P0795A*  12/02/2014 PK44514   UPDATE STATE TO PR FOR SPLIT ORDERS.     *        
P0795B*  12/19/2014 PK44514   ADD MESSAGE_PARM TO RESULT SET 4.        *        
P0795C*  01/29/2015 DB18339   ADDED ORDER BUS RULE ID TO SPLITS SET 7. *        
A05189*  02/24/2015 PK44514   AROP CHANGES FOR MOD                     *        
P0795D*  03/12/2015 PK44514   DEFECT 6955:FOR SET CHK CSS_REV_DISTRICT *        
P0795D*                       TO DETERMINE IF RELEASE IS REQUIRED      *        
P0795E*  04/23/2015 PK44514   DEFECT 7074:ADDED INPUT PARM FOR CRAWL   *        
P0795E*                       APPLIANCE ADDED TO THE ORDER. TO BE USED *        
P0795E*                       WHEN CALCULATING WORK AREA               *        
P0795F*  05/23/2015 DB18339   DEFECT 7115:ADDED ORDER UTIL CD FOR 4154.*        
P0795G*  06/22/2015 PK44514   AOO MAINTENANCE                          *        
DT6878*  05/02/2016 PK44514   SEB ORDER INITIATION AND MAINTENANCE     *        
D12002*  08/09/2016 PK44514   FIX RELEASE INFO SENT BACK FOR SPLIT     *        
D12002*                       ORDERS WHEN IT BRIDGES.                  *        
P01176*  10/17/2016 PK44514   GAS SAMPLING CHANGES                     *        
D12436*  10/19/2016 PK44514   FIX FOR RECALCULATION OF WORK AREA WHEN  *        
D12436*                       CC CHANGED TO OFF                        *        
D25931*  02/01/2017 PK44514   RELEASE NOT STICKING WHEN MANUALLY UPDTED*        
D26070*  02/03/2017 PK44514   WORK AREA RECALULATION FIX FOR DATE      *        
D26070*                       CHANGE IN MAINTAIN                       *        
A05821*  03/22/17   PK44514   CHECK BUILDER/REALTOR FLAGS BEFORE CALLING        
A05821*                       PAYMENT REQUIRED.                                 
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04482'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04482 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04482_R1'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04482_R3'.          
            05  GTT-NAME-4              PIC X(26) VALUE                 
                                        'SESSION.CSR04482_R4'.          
            05  GTT-NAME-5              PIC X(26) VALUE                 
                                        'SESSION.CSR04482_R5'.          
            05  GTT-NAME-6              PIC X(26) VALUE                 
                                        'SESSION.CSR04482_R6'.          
            05  GTT-NAME-7              PIC X(26) VALUE                 
                                        'SESSION.CSR04482_R7'.          
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1        PIC S9(9) COMP VALUE ZERO.       
             10 S-STATUS-CODE          PIC S9(9) COMP VALUE ZERO.       
             10 S-BUS-RULE-ID          PIC X(10) VALUE SPACES.          
             10 S-ACTION-TYPE-CD       PIC X(08) VALUE SPACES.          
             10 S-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.          
             10 S-MESSAGE-PARMS        PIC X(200) VALUE SPACES.         
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(9) COMP VALUE 0.          
             10 S-REVERT-FL            PIC X(01) VALUE SPACES.          
             10 S-WORK-AREA-2          PIC X(12) VALUE SPACES.          
             10 S-TOTAL-RES            PIC S9(5)V9 COMP-3 VALUE 0.      
             10 S-DISCONNECT-CD        PIC X(01) VALUE SPACES.          
             10 S-ARRANGEMENT-FL-2     PIC X(01) VALUE SPACES.          
             10 S-BAD-ELEC-WK-TYPE     PIC X(01) VALUE 'N'.             
             10 S-BAD-GAS-WK-TYPE      PIC X(01) VALUE 'N'.             
             10 S-PAYMENT-REQ-FL       PIC X(01) VALUE 'N'.             
A04670       10 S-RECALC-ORDER-TYPE-CD PIC X(05) VALUE SPACES.          
P00718       10 S-BUSINESS-UNIT-2      PIC X(03) VALUE SPACES.          
P00718       10 S-WORK-DISTRICT-2      PIC X(40) VALUE SPACES.          
A05189       10 S-AROP-READ-ONLY-FL-2  PIC X(01) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3        PIC S9(9) COMP VALUE ZERO.       
             10 S-ASSIGNED-DATE        PIC X(10) VALUE SPACES.          
             10 S-SERV-ORDER-NO-3      PIC S9(13)V COMP-3 VALUE 0.      
             10 S-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.          
             10 S-ORDER-STATE-CD       PIC X(01) VALUE SPACES.          
             10 S-CUSTOMER-NAME        PIC X(76) VALUE SPACES.          
             10 S-REMARKS              PIC X(210) VALUE SPACES.         
             10 S-WORK-AREA-3          PIC X(12) VALUE SPACES.          
             10 S-PHONE                PIC X(10) VALUE SPACES.          
             10 S-REMARK-TYPE          PIC X(01) VALUE SPACES.          
P00718*      10 S-BUSINESS-UNIT-3      PIC X(03) VALUE SPACES.                  
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4        PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-UTIL-TYPE-4     PIC X(01) VALUE SPACES.          
             10 S-METER-NO-4           PIC X(09) VALUE SPACES.          
             10 S-RATE-PLAN            PIC X(03) VALUE SPACES.          
             10 S-SUPPLIES             PIC X(15) VALUE SPACES.          
             10 S-METER-LOC            PIC X(02) VALUE SPACES.          
             10 S-METER-STATUS         PIC X(01) VALUE SPACES.          
             10 S-METER-STATUS-REASON  PIC X(01) VALUE SPACES.          
             10 S-WORK-TYPE-CD-4       PIC X(03) VALUE SPACES.          
             10 S-METER-READ-INST      PIC X(02) VALUE SPACES.          
             10 S-METER-IND            PIC X(01) VALUE SPACES.          
             10 S-IC-NO-4              PIC S9(4) COMP VALUE 0.          
             10 S-MTR-REF-NO-4         PIC S9(4) COMP VALUE 0.          
             10 S-RLSE-REQUIRED        PIC X(01) VALUE SPACES.          
             10 S-RLSE-NO              PIC X(10) VALUE SPACES.          
             10 S-RLSE-MSG             PIC X(05) VALUE SPACES.          
             10 S-RLSE-ADDL-MSG        PIC X(05) VALUE SPACES.          
             10 S-RLSE-PHONE           PIC X(12) VALUE SPACES.          
             10 S-RLSE-ALT-PHONE       PIC X(12) VALUE SPACES.          
             10 S-RLSE-REV-DIST        PIC X(25) VALUE SPACES.          
             10 S-BUS-RULE-ID-4        PIC X(10) VALUE SPACES.          
             10 S-ACTION-TYPE-CD-4     PIC X(08) VALUE SPACES.          
             10 S-BUS-RULE-XREF-ID-4   PIC X(26) VALUE SPACES.          
             10 S-MESSAGE-PARMS-4      PIC X(200) VALUE SPACES.         
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5        PIC S9(9) COMP VALUE ZERO.       
             10 S-SERV-ORDER-NO-5      PIC S9(13)V COMP-3 VALUE 0.      
             10 S-CODE-UTIL-TYPE-5     PIC X(01) VALUE SPACES.          
             10 S-WORK-TYPE-CD-5       PIC X(03) VALUE SPACES.          
             10 S-IC-NO-5              PIC S9(4) COMP VALUE 0.          
             10 S-METER-NO-5           PIC X(09) VALUE SPACES.          
             10 S-MTR-REF-NO-5         PIC S9(4) COMP VALUE 0.          
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6        PIC S9(9) COMP VALUE ZERO.       
             10 S-CALENDAR-DT          PIC X(10) VALUE SPACES.          
             10 S-GOOD-DAY-FL          PIC X(02) VALUE SPACES.          
             10 S-SCENARIO-SEQ-6       PIC S9(4) COMP VALUE ZERO.       
             10 S-SCENARIO-SEQ-CHOICE-6 PIC S9(4) COMP VALUE ZERO.      
          05 GTT-RETURN-FIELDS-7.                                       
             10 S-RETURN-CODE-7        PIC S9(9) COMP VALUE ZERO.       
             10 S-SCENARIO-SEQ-7       PIC S9(4) COMP VALUE ZERO.       
             10 S-SCENARIO-SEQ-CHOICE-7 PIC S9(4) COMP VALUE ZERO.      
             10 S-NEW-ORDER-TYPE       PIC X(05) VALUE SPACES.          
             10 S-NEW-E-WORK-TYPE      PIC X(03) VALUE SPACES.          
             10 S-NEW-G-WORK-TYPE      PIC X(03) VALUE SPACES.          
             10 S-NEW-ORDER-STATE-CD   PIC X(01) VALUE SPACES.          
             10 S-DISPATCH-NOT-WQ      PIC X(01) VALUE SPACES.          
             10 S-ADDL-SO-REMARKS      PIC X(50) VALUE SPACES.          
             10 S-SO-HOLD-COMMENTS     PIC X(25) VALUE SPACES.          
             10 S-SCHED-DT-FUNC-CD     PIC X(01) VALUE SPACES.          
             10 S-MAX-DATE             PIC X(10) VALUE SPACES.          
             10 S-ORD-AUTO-SEL-CD      PIC X(01) VALUE SPACES.          
             10 S-WORK-AREA-7          PIC X(12) VALUE SPACES.          
             10 S-ARRANGEMENT-FL-7     PIC X(01) VALUE SPACES.          
             10 S-ELEC-RLSE-FL         PIC X(01) VALUE SPACES.          
             10 S-GAS-RLSE-FL          PIC X(01) VALUE SPACES.          
P00718       10 S-BUSINESS-UNIT-7      PIC X(03) VALUE SPACES.          
P00718       10 S-WORK-DISTRICT-7      PIC X(40) VALUE SPACES.          
P0795C       10 S-ORDER-BUS-RULE-ID    PIC X(10) VALUE SPACES.          
A05189       10 S-AROP-READ-ONLY-FL-7  PIC X(01) VALUE SPACES.          
P0795F       10 S-ORDER-UTILITY-CD     PIC X(01) VALUE SPACES.          
D12002       10 S-ELEC-RLSE-NO         PIC X(10) VALUE SPACES.          
D12002       10 S-GAS-RLSE-NO          PIC X(10) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
A4670A    05 WS-START-EXISTS-FL          PIC X(01) VALUE 'N'.           
A4670A       88 START-EXISTS-NO                    VALUE 'N'.           
A4670A       88 START-EXISTS-YES                   VALUE 'Y'.           
A4670A    05 WS-STOP-EXISTS-FL           PIC X(01) VALUE 'N'.           
A4670A       88 STOP-EXISTS-NO                     VALUE 'N'.           
A4670A       88 STOP-EXISTS-YES                    VALUE 'Y'.           
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04482'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.          
          05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
          05  WS-PREMISE-NO-NUM        PIC 9(10) VALUE ZEROES.          
          05  WS-PREMISE-NO            REDEFINES WS-PREMISE-NO-NUM      
                                       PIC X(10).                       
          05  WS-CUSTOMER-NO-NUM       PIC 9(10) VALUE ZEROES.          
          05  WS-CUSTOMER-NO           REDEFINES WS-CUSTOMER-NO-NUM     
                                       PIC X(10).                       
          05  WS-NEW-CUSTOMER-NO       PIC X(10) VALUE SPACES.          
          05  WS-NEW-CUSTOMER-NO-NUM   REDEFINES WS-NEW-CUSTOMER-NO     
                                       PIC 9(10).                       
          05  WS-SERV-ORDER-NO-NUM     PIC 9(13).                       
          05  WS-SERV-ORDER-NO-CHAR    REDEFINES WS-SERV-ORDER-NO-NUM   
                                       PIC X(13).                       
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT04-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT05-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT06-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT07-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-BUILD-INPUT-PARMS.                                     
              10 WS-METER-NO.                                           
                  15 WS-METER-NO-SUB PIC X(09) OCCURS 50.               
              10 WS-CODE-UTIL-TYPE.                                     
                  15 WS-CODE-UTIL-TYPE-SUB PIC X(01) OCCURS 50.         
              10 WS-WORK-TYPE.                                          
                  15 WS-WORK-TYPE-SUB  PIC X(03) OCCURS 50.             
              10 WS-METER-IND.                                          
                  15 WS-METER-IND-SUB  PIC X(01) OCCURS 50.             
              10 WS-METER-STATUS.                                       
                  15 WS-METER-STATUS-SUB PIC X(01) OCCURS 50.           
              10 WS-IC-NO.                                              
                  15 WS-IC-NO-SUB        PIC 9(04) OCCURS 50.           
              10 WS-MTR-REF.                                            
                  15 WS-MTR-REF-SUB      PIC 9(04) OCCURS 50.           
              10 WS-USER-CHG-WK-TYPE.                                   
                  15 WS-USER-CHG-WK-TYPE-SUB PIC X(01) OCCURS 50.       
P00795        10 WS-SUPPLYING.                                          
P00795            15 WS-SUPPLYING-SUB     PIC X(15) OCCURS 50.          
D25931        10 WS-RLSE-REQD.                                          
D25931            15 WS-RLSE-REQD-SUB     PIC X(01) OCCURS 50.          
              10 WS-SUB1               PIC 999   VALUE 0.               
          05  WS-PARM-METER-COUNT      PIC 999   VALUE 0.               
          05  WS-GAS-METER-COUNT       PIC 999   VALUE 0.               
          05  WS-ELEC-METER-COUNT      PIC 999   VALUE 0.               
          05  WS-1ST-ELEC              PIC 999   VALUE 0.               
          05  WS-1ST-GAS               PIC 999   VALUE 0.               
          05  WS-METER-PARM.                                            
              10  WS-METER-PARM-LEN    PIC S9(04) COMP.                 
              10  WS-METER-PARM-TEXT   PIC X(800).                      
          05  WS-TOTAL-DUE             PIC S9(9)V99 COMP-3 VALUE +0.    
P00718    05  WS-WORK-DISTRICT         PIC X(40) VALUE SPACES.          
          05  WS-ELEC-METER-IND        PIC X(01) VALUE 'N'.             
          05  WS-GAS-METER-IND         PIC X(01) VALUE 'N'.             
          05  WS-CHG-WK-TYPE-FL        PIC X(01) VALUE 'N'.             
          05  WS-APPLIANCE-FL          PIC X(01) VALUE 'N'.             
          05  WS-APPL-MSG-1-FL         PIC X(01) VALUE 'N'.             
          05  WS-APPL-MSG-2-FL         PIC X(01) VALUE 'N'.             
          05  WS-APPL-MSG-3-FL         PIC X(01) VALUE 'N'.             
          05  WS-APPL-MSG-4-FL         PIC X(01) VALUE 'N'.             
          05  WS-APPL-MSG-5-FL         PIC X(01) VALUE 'N'.             
          05  WS-APPL-MSG-6-FL         PIC X(01) VALUE 'N'.             
          05  WS-APPL-MSG-FL           PIC X(01) VALUE 'N'.             
          05  WS-HEATING-APPL-FL       PIC X(01) VALUE 'N'.             
          05  WS-HEAT-WK-TYPE-FL       PIC X(01) VALUE 'N'.             
          05  WS-HEAT-WK-AREA-FL       PIC X(01) VALUE 'N'.             
          05  WS-HEAT-LOCOFF-FL        PIC X(01) VALUE 'N'.             
          05  WS-RLSE-FL               PIC X(01) VALUE 'N'.             
          05  WS-CRAWL-FL              PIC X(01) VALUE 'N'.             
          05  WS-CRAWL-LOCAL-OFFICE    PIC X(01) VALUE 'N'.             
          05  WS-SPLIT-CALENDAR-FL     PIC X(01) VALUE 'N'.             
          05  WS-GAS-ARRANGE-FL        PIC X(01) VALUE 'N'.             
          05  WS-ELEC-ORDER-FL         PIC X(01) VALUE 'N'.             
          05  WS-ELEC-UNBLOCK-FL       PIC X(01) VALUE 'N'.             
          05  WS-GAS-UNBLOCK-FL        PIC X(01) VALUE 'N'.             
          05  WS-ELEC-IC-FL            PIC X(01) VALUE 'N'.             
          05  WS-SPLIT-RLSE-FL         PIC X(01) VALUE 'N'.             
          05  WS-NEW-CUST-IS-LL-FL     PIC X(01) VALUE 'N'.             
A05821    05  WS-CUST-BLDR-RLTR-FL     PIC X(01) VALUE 'N'.             
P00718    05  WS-MULTI-REG-MTR         PIC X(01) VALUE 'N'.             
A04670    05  WS-PR-EXECUTED-FL        PIC X(01) VALUE 'N'.             
A04670    05  WS-THRESHOLD             PIC S9(4)V9(5) COMP-3 VALUE +0.  
A04670    05  WS-COUNT                 PIC S9(4) COMP VALUE 0.          
P00795    05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.          
A05189    05  WS-READ-ONLY-ORDER       PIC X(01) VALUE SPACES.          
A05189    05  WS-RLSE-REQD-4480        PIC X(01) VALUE SPACES.          
A05189    05  RLSE-REQD-4480           PIC X(01) VALUE SPACES.          
A05189    05  WS-WORK-TYPES-4109       PIC X(150) VALUE SPACES.         
P0795D    05  WS-CHECK-RLSE-FL         PIC X(01) VALUE SPACES.          
          05  WS-WK-TOTAL-RES          PIC S9(5)V9(1) COMP-3 VALUE 0.0. 
          05  WS-TOTAL-RES             PIC 9(06) VALUE ZEROES.          
          05  WS-TOTAL-RES-DEC         PIC 9(05)V9 VALUE ZEROES.        
          05  WS-READ-ROUTE-NUM        PIC 9(04).                       
          05  WS-READ-ROUTE-CHAR       REDEFINES WS-READ-ROUTE-NUM      
                                       PIC X(04).                       
          05  WS-GIS-POINT-ID          PIC 9(09).                       
          05  WS-GIS-POINT-ID-CHAR     REDEFINES WS-GIS-POINT-ID        
                                       PIC X(09).                       
          05  WS-IC-NO-NUM             PIC 9(04).                       
          05  WS-IC-NO-CHAR            REDEFINES WS-IC-NO-NUM           
                                       PIC X(04).                       
          05  WS-IC-CHAR               PIC X(04).                       
          05  WS-IC-NUM                REDEFINES WS-IC-CHAR             
                                       PIC 9(04).                       
          05  WS-MTR-REF-NO-NUM        PIC 9(04).                       
          05  WS-MTR-REF-NO-CHAR       REDEFINES WS-MTR-REF-NO-NUM      
                                       PIC X(04).                       
          05  WS-MTR-REF-CHAR          PIC X(04).                       
          05  WS-MTR-REF-NUM           REDEFINES WS-MTR-REF-CHAR        
                                       PIC 9(04).                       
DT6878    05  WS-DATABASE              PIC 9(01) VALUE 0.               
DT6878        88 CSR-DATABASE                    VALUE 1.               
DT6878        88 SEB-DATABASE                    VALUE 2.               
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01 IND-VARIABLES.                                                
          05 WS-NULL1                    PIC S9(04) COMP.               
          05 WS-NULL2                    PIC S9(04) COMP.               
          05 WS-NULL3                    PIC S9(04) COMP.               
                                                                        
       01  CSR04479-CALL-DATA.                                          
           03  ACCOUNT-NO-4479          PIC X(13) VALUE SPACES.         
           03  PREMISE-NO-4479          PIC X(10) VALUE SPACES.         
           03  PROCESS-4479             PIC X(10) VALUE SPACES.         
           03  ASSIGNED-DATE-IN-4479    PIC X(10) VALUE SPACES.         
           03  PROGRAM-ID-4479          PIC X(08) VALUE SPACES.         
P00795     03  ORDER-TYPE-CD-4479       PIC X(05) VALUE SPACES.         
P00795     03  SERV-ORDER-NO-4479       PIC X(13) VALUE SPACES.         
P00795     03  CURRENT-HISTORY-FL-4479  PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04479-RETURN-DATA-A.                                      
           03  RETURN-CODE-4479-A       PIC S9(9) COMP VALUE 0.         
           03  ASSIGNED-DATE-OUT-4479   PIC X(10) VALUE SPACES.         
           03  SERV-ORDER-NO-4479-A     PIC S9(13)V COMP-3 VALUE 0.     
           03  OUT-ORDER-TYPE-CD-4479   PIC X(05) VALUE SPACES.         
           03  ORDER-STATE-CD-4479      PIC X(01) VALUE SPACES.         
           03  CUSTOMER-NAME-4479       PIC X(76) VALUE SPACES.         
           03  REMARKS-4479             PIC X(210) VALUE SPACES.        
           03  WORK-AREA-4479           PIC X(12) VALUE SPACES.         
           03  PHONE-4479               PIC X(10) VALUE SPACES.         
           03  REMARK-TYPE-4479         PIC X(01) VALUE SPACES.         
P00718*    03  BUSINESS-UNIT-4479       PIC X(03) VALUE SPACES.                 
                                                                        
       01  CSR04479-RETURN-DATA-B.                                      
           03  RETURN-CODE-4479-B       PIC S9(9) COMP VALUE 0.         
           03  CODE-UTIL-TYPE-4479-B    PIC X(03) VALUE SPACES.         
           03  METER-NO-4479-B          PIC X(09) VALUE SPACES.         
           03  RATE-PLAN-4479-B         PIC X(03) VALUE SPACES.         
           03  SUPPLIES-4479            PIC X(15) VALUE SPACES.         
           03  METER-LOC-4479           PIC X(02) VALUE SPACES.         
           03  METER-STATUS-4479        PIC X(01) VALUE SPACES.         
           03  METER-STATUS-REASON-4479 PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-CD-4479-B      PIC X(03) VALUE SPACES.         
           03  METER-READ-INST-4479     PIC X(02) VALUE SPACES.         
           03  METER-IND-4479           PIC X(01) VALUE SPACES.         
           03  IC-NO-4479-B             PIC S9(4) COMP VALUE 0.         
           03  MTR-REF-NO-4479-B        PIC S9(4) COMP VALUE 0.         
           03  GAS-MTRS-COUNT-4479      PIC S9(4) COMP VALUE 0.         
           03  ELEC-MTRS-COUNT-4479     PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSR04479-RETURN-DATA-C.                                      
           03  RETURN-CODE-4479-C       PIC S9(9) COMP VALUE 0.         
           03  SERV-ORDER-NO-4479-C     PIC S9(13)V COMP-3 VALUE 0.     
           03  CODE-UTIL-TYPE-4479-C    PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-CD-4479-C      PIC X(03) VALUE SPACES.         
           03  IC-NO-4479-C             PIC S9(4) COMP VALUE 0.         
           03  METER-NO-4479-C          PIC X(09) VALUE SPACES.         
           03  MTR-REF-NO-4479-C        PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSR04479-RETURN-DATA-D.                                      
           03  RETURN-CODE-4479-D       PIC S9(9) COMP VALUE 0.         
           03  RATE-PLAN-4479-D         PIC X(03) VALUE SPACES.         
           03  RATE-ITEM-CODE-4479      PIC S9(4) COMP VALUE 0.         
           03  CODE-PLAN-STATUS-4479    PIC X(01) VALUE SPACES.         
           03  CODE-STATUS-REASON-4479  PIC X(01) VALUE SPACES.         
           03  MONTHLY-AMOUNT-4479      PIC S9(3)V99 COMP-3 VALUE 0.    
           03  NO-UNITS-4479            PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSR04479-RETURN-DATA-E.                                      
           03  RETURN-CODE-4479-E       PIC S9(9) COMP VALUE 0.         
           03  CODE-UTIL-TYPE-4479-E    PIC X(01) VALUE SPACES.         
           03  IC-NO-4479-E             PIC S9(4) COMP VALUE 0.         
           03  RATE-PLAN-4479-E         PIC X(03) VALUE SPACES.         
           03  CODE-REV-CLASS-4479-E    PIC X(03) VALUE SPACES.         
           03  RATE-PLAN-DESC-4479-E    PIC X(25) VALUE SPACES.         
           03  TOU-FL-4479              PIC X(01) VALUE SPACES.         
           03  FIXED-FACTOR-FL-4479     PIC X(01) VALUE SPACES.         
           03  BILL-CONTRACT-FL-4479    PIC X(01) VALUE SPACES.         
           03  INTERRUPT-FL-4479        PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04480-CALL-DATA.                                          
           03  CODE-UTIL-TYPE-4480      PIC X(50) VALUE SPACES.         
           03  WORK-TYPE-4480           PIC X(150) VALUE SPACES.        
           03  METER-IND-4480           PIC X(50) VALUE SPACES.         
           03  METER-STATUS-4480        PIC X(50) VALUE SPACES.         
           03  ACCOUNT-NO-4480          PIC X(13) VALUE SPACES.         
           03  PREMISE-NO-4480          PIC X(10) VALUE SPACES.         
           03  ORDER-TYPE-CD-4480       PIC X(05) VALUE SPACES.         
           03  ASSIGNED-DATE-4480       PIC X(10) VALUE SPACES.         
           03  PROGRAM-ID-4480          PIC X(08) VALUE SPACES.         
           03  APPLIANCE-LIT-4480       PIC X(01) VALUE SPACES.         
           03  RELEASE-REQD-4480        PIC X(01) VALUE SPACES.         
           03  FRO-FL-4480              PIC X(01) VALUE SPACES.         
P0795E     03  CRAWL-APPL-FL-4480       PIC X(01) VALUE SPACES.         
P0795G     03  SERV-ORDER-NO-4480       PIC X(13) VALUE SPACES.         
P0795G     03  NEW-ORDER-STATE-CD-4480  PIC X(01) VALUE SPACES.         
P0795G     03  WORK-AREA-ID-4480        PIC X(12) VALUE SPACES.         
                                                                        
       01  CSR04480-RETURN-DATA-A.                                      
           03  RETURN-CODE-4480-A       PIC S9(9) COMP VALUE 0.         
           03  WORK-AREA-4480           PIC X(12) VALUE SPACES.         
           03  DISCONNECT-CD-4480       PIC X(01) VALUE SPACES.         
           03  TOTAL-RES-4480           PIC S9(5)V9(1) COMP-3 VALUE 0.  
           03  ARRANGEMENT-FL-4480      PIC X(01) VALUE SPACES.         
           03  REVERT-FL-4480           PIC X(01) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-4480       PIC X(03) VALUE SPACES.         
P00718     03  WORK-DISTRICT-4480       PIC X(40) VALUE SPACES.         
A05189     03  AROP-READ-ONLY-4480      PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04480-RETURN-DATA-B.                                      
           03  RETURN-CODE-4480-B       PIC S9(9) COMP VALUE 0.         
           03  CALENDAR-DT-4480         PIC X(10) VALUE SPACES.         
           03  GOOD-DAY-FL-4480         PIC X(01) VALUE SPACES.         
           03  TOTAL-SO-HRS-4480        PIC S9(5)V9(1) COMP-3 VALUE 0.  
           03  MAX-RE-PER-DAY-4480      PIC S9(4) COMP VALUE 0.         
           03  TOTAL-SO-4480            PIC S9(4) COMP VALUE 0.         
           03  MAX-DAILY-WK-REQ-4480    PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSR01684-CALL-DATA.                                          
           03  ORDER-TYPE-CD-1684       PIC X(05) VALUE SPACES.         
           03  WORK-TYPE-1-1684         PIC X(03) VALUE SPACES.         
           03  METER-STATUS-1-1684      PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-2-1684         PIC X(03) VALUE SPACES.         
           03  METER-STATUS-2-1684      PIC X(01) VALUE SPACES.         
           03  COMPANY-NO-1684          PIC X(02) VALUE SPACES.         
           03  CODE-UTIL-1-1684         PIC X(01) VALUE SPACES.         
           03  CODE-UTIL-2-1684         PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01684-RETURN-DATA.                                        
           03  RETURN-CODE-E-1684       PIC X(01) VALUE SPACES.         
           03  RETURN-CODE-G-1684       PIC X(01) VALUE SPACES.         
           03  RETURN-CODE-1684         PIC S9(9) COMP VALUE 0.         
                                                                        
       01  CSR04153-CALL-DATA.                                          
           03  COMPANY-NO-4153          PIC X(02) VALUE SPACES.         
           03  LOCAL-OFFICE-4153        PIC X(03) VALUE SPACES.         
           03  ORDER-TYPE-CD-4153       PIC X(05) VALUE SPACES.         
           03  ELEC-WORK-TYPE-4153      PIC X(03) VALUE SPACES.         
           03  GAS-WORK-TYPE-4153       PIC X(03) VALUE SPACES.         
           03  RELEASE-CD-4153          PIC X(01) VALUE SPACES.         
           03  CRAWL-IND-4153           PIC X(01) VALUE SPACES.         
           03  ACCOUNT-NO-4153          PIC X(13) VALUE SPACES.         
           03  ELEC-IC-NO-4153          PIC S9(4) COMP VALUE 0.         
           03  ELEC-MTR-REF-4153        PIC S9(4) COMP VALUE 0.         
           03  GAS-IC-NO-4153           PIC S9(4) COMP VALUE 0.         
           03  GAS-MTR-REF-4153         PIC S9(4) COMP VALUE 0.         
           03  CALLING-SYSTEM-4153      PIC X(03) VALUE SPACES.         
           03  PREMISE-NO-4153          PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR04153-RETURN-DATA.                                        
           03  RETURN-CODE-4153         PIC S9(9) COMP VALUE 0.         
           03  SPLIT-CD-4153            PIC X(01) VALUE SPACES.         
           03  SCENARIO-CD-4153         PIC X(15) VALUE SPACES.         
           03  ERROR-MSG-4153           PIC X(05) VALUE SPACES.         
           03  DATAWINDOW-CD-4153       PIC X(01) VALUE SPACES.         
           03  TOU-ERROR-MSG-4153       PIC X(05) VALUE SPACES.         
           03  TOU-ACCOUNT-4153         PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04154-CALL-DATA.                                          
           03  COMPANY-NO-4154          PIC X(02) VALUE SPACES.         
           03  SCENARIO-CD-4154         PIC X(15) VALUE SPACES.         
           03  FRO-FL-4154              PIC X(01) VALUE SPACES.         
           03  PREMISE-NO-4154          PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR04154-RETURN-DATA.                                        
           03  RETURN-CODE-4154         PIC S9(9) COMP VALUE 0.         
           03  SCENARIO-SEQ-4154        PIC S9(4) COMP VALUE 0.         
           03  SCENARIO-SEQ-CHOICE-4154 PIC S9(4) COMP VALUE 0.         
           03  NEW-ORDER-TYPE-4154      PIC X(05) VALUE SPACES.         
           03  NEW-E-WORK-TYPE-4154     PIC X(03) VALUE SPACES.         
           03  NEW-G-WORK-TYPE-4154     PIC X(03) VALUE SPACES.         
           03  NEW-ORDER-STATE-CD-4154  PIC X(01) VALUE SPACES.         
           03  DISPATCH-NOT-WQ-4154     PIC X(01) VALUE SPACES.         
           03  ADDL-SO-REMARKS-4154     PIC X(50) VALUE SPACES.         
           03  SO-HOLD-COMMENTS-4154    PIC X(25) VALUE SPACES.         
           03  DATAWINDOW-DESC-4154     PIC X(60) VALUE SPACES.         
           03  SCHED-DT-FUNC-CD-4154    PIC X(01) VALUE SPACES.         
           03  MAX-DATE-4154            PIC X(10) VALUE SPACES.         
           03  ORD-AUTO-SEL-CD-4154     PIC X(01) VALUE SPACES.         
P0795C     03  ORDER-BUS-RULE-ID-4154   PIC X(10) VALUE SPACES.         
P0795F     03  ORDER-UTILITY-CD-4154    PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01116-CALL-DATA.                                          
           03  LOCAL-OFFICE-1116        PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-1116      PIC X(50) VALUE SPACES.         
           03  WORK-TYPE-CD-1116        PIC X(150) VALUE SPACES.        
           03  CRAWL-IND-1116           PIC X(01) VALUE SPACES.         
           03  METER-IND-1116           PIC X(50) VALUE SPACES.         
           03  ZIP-CODE-1116            PIC X(05) VALUE SPACES.         
           03  READ-ROUTE-1116          PIC X(04) VALUE SPACES.         
           03  POINT-ID-1116            PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR01116-RETURN-DATA.                                        
           03  RETURN-CODE-1116         PIC S9(9) COMP VALUE 0.         
           03  WORK-AREA-1116           PIC X(12) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-1116       PIC X(03) VALUE SPACES.         
                                                                        
       01  CSR04012-CALL-DATA.                                          
           03  COMPANY-NO-4012          PIC X(02) VALUE SPACES.         
           03  REV-DISTRICT-CD-4012     PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-4012      PIC X(01) VALUE SPACES.         
           03  ORDER-TYPE-CD-4012       PIC X(05) VALUE SPACES.         
           03  WORK-TYPE-CD-4012        PIC X(03) VALUE SPACES.         
           03  RLSE-CHECK-CD-4012       PIC X(01) VALUE SPACES.         
           03  ACCOUNT-NO-4012          PIC X(13) VALUE SPACES.         
           03  IC-NO-4012               PIC X(04) VALUE SPACES.         
           03  MTR-REF-NO-4012          PIC X(04) VALUE SPACES.         
           03  METER-SUPPLYING-CD-4012  PIC X(02) VALUE SPACES.         
           03  CODE-STATUS-REAS-4012    PIC X(01) VALUE SPACES.         
           03  CALLING-SYSTEM-4012      PIC X(03) VALUE SPACES.         
           03  WANTED-BY-DATE-4012      PIC X(10) VALUE SPACES.         
           03  PREMISE-NO-4012          PIC X(10) VALUE SPACES.         
           03  RLSE-TYPE-4012           PIC X(02) VALUE SPACES.         
           03  RLSE-SUPPLIES-4012       PIC X(15) VALUE SPACES.         
                                                                        
       01  CSR04012-RETURN-DATA.                                        
           05  RETURN-CODE-4012      PIC S9(9)     COMP VALUE 0.        
           05  RLSE-REQUIRED-FL-4012 PIC X(01)     VALUE SPACES.        
           05  MESSAGE-4012          PIC X(05)     VALUE SPACES.        
           05  ADTL-MESSAGE-4012     PIC X(05)     VALUE SPACES.        
           05  PHONE-4012            PIC X(12)     VALUE SPACES.        
           05  ALT-PHONE-4012        PIC X(12)     VALUE SPACES.        
           05  UTIL-TYPE-4012        PIC X(04)     VALUE SPACES.        
           05  REV-DIST-DESC-4012    PIC X(25)     VALUE SPACES.        
           05  RLSE-EXISTS-4012      PIC X(01)     VALUE SPACES.        
           05  RLSE-NO-4012          PIC X(10)     VALUE SPACES.        
                                                                        
       01  CSR04109-CALL-DATA.                                          
           03 WORK-AREA-ID-4109         PIC X(12) VALUE SPACES.         
           03 ASSIGNED-DATETIME-4109    PIC X(26) VALUE SPACES.         
           03 SERV-ORDER-NO-4109        PIC X(13) VALUE SPACES.         
           03 TOTAL-RES-4109            PIC X(06) VALUE SPACES.         
           03 NO-DAYS-4109              PIC X(03) VALUE SPACES.         
           03 SYSTEM-INITIATED-4109     PIC X(03) VALUE SPACES.         
           03 WORK-TYPES-4109           PIC X(150) VALUE SPACES.        
                                                                        
       01  CSR04109-RETURN-DATA.                                        
           05  RETURN-CODE-4109      PIC S9(9) COMP VALUE 0.            
           05  CALENDAR-DT-4109      PIC X(10) VALUE SPACES.            
           05  GOOD-DAY-4109         PIC X(01) VALUE SPACES.            
           05  TOTAL-SO-HRS-4109     PIC X(06) VALUE SPACES.            
           05  MAX-RE-PER-DAY-4109   PIC S9(4) COMP VALUE 0.            
           05  TOTAL-SO-4109         PIC S9(4) COMP VALUE 0.            
           05  MAX-DAILY-WK-REQ-4109 PIC S9(4) COMP VALUE 0.            
                                                                        
       01  CSR04281-CALL-DATA.                                          
           05  CUSTOMER-NO-4281         PIC X(10) VALUE SPACES.         
           05  COMPANY-NO-4281          PIC X(02) VALUE SPACES.         
                                                                        
       01  CSR04281-RETURN-DATA.                                        
           05  RETURN-CODE-4281         PIC S9(9) COMP VALUE 0.         
           05  ACCOUNT-NO-4281          PIC S9(13)V COMP-3 VALUE +0.    
           05  CODE-ACCT-STAT-4281      PIC X(01) VALUE  SPACES.        
           05  PAST-DUE-UTIL-4281       PIC S9(09)V99 COMP-3 VALUE +0.  
           05  PAST-DUE-NONUTIL-4281    PIC S9(09)V99 COMP-3 VALUE +0.  
           05  CUST-TYPE-4281           PIC X(30) VALUE  SPACES.        
           05  SSN-4281                 PIC X(09) VALUE SPACES.         
           05  SERV-ADDRESS-4281        PIC X(75) VALUE SPACES.         
           05  PREMISE-NO-4281          PIC S9(10)V COMP-3 VALUE +0.    
           05  CIA-4281                 PIC S9(09)V99 COMP-3 VALUE +0.  
           05  BILLED-BALANCE-4281      PIC S9(09)V99 COMP-3 VALUE +0.  
           05  DEPOSIT-DUE-4281         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  PAYMENTS-4281            PIC S9(09)V99 COMP-3 VALUE +0.  
           05  PSNC-LABOR-CHG-4281      PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RET-CHECK-FL-4281        PIC X(01) VALUE SPACES.         
           05  ARREARS-UTIL-4281        PIC S9(9)V99 COMP-3 VALUE +0.   
           05  ARREARS-NONUTIL-4281     PIC S9(9)V99 COMP-3 VALUE +0.   
           05  AMT-INSTALL-DEP-4281     PIC S9(9)V99 COMP-3 VALUE +0.   
           05  NAME-4281                PIC X(76) VALUE SPACES.         
           05  TOTAL-DUE-4281           PIC S9(9)V99 COMP-3 VALUE +0.   
                                                                        
A05189 01  CSR04849-CALL-DATA.                                          
A05189     03 ACCOUNT-NO-4849           PIC X(13) VALUE SPACES.         
A05189     03 PREMISE-NO-4849           PIC X(10) VALUE SPACES.         
A05189     03 SERV-ORDER-NO-4849        PIC X(13) VALUE SPACES.         
                                                                        
A05189 01  CSR04849-RETURN-DATA.                                        
A05189     05  RETURN-CODE-4849      PIC S9(9) COMP VALUE 0.            
A05189     05  AROP-ELIGIBLE-FL-4849 PIC X(01) VALUE SPACES.            
                                                                        
       01  WS-TABLES.                                                   
           05  WS-SUPPLYING-TABLE.                                      
               10  WS-SUPPLYING-DATA.                                   
                   15  FILLER  PIC X(17) VALUE 'A APARTMENT      '.     
                   15  FILLER  PIC X(17) VALUE 'B BALL PARK      '.     
                   15  FILLER  PIC X(17) VALUE 'C BARN           '.     
                   15  FILLER  PIC X(17) VALUE 'D BOAT HOUSE/DOCK'.     
                   15  FILLER  PIC X(17) VALUE 'E CAMPER/RV TRLR '.     
                   15  FILLER  PIC X(17) VALUE 'F COMMERCIAL     '.     
                   15  FILLER  PIC X(17) VALUE 'G COMM TRAILER   '.     
                   15  FILLER  PIC X(17) VALUE 'H COTTAGE APT    '.     
                   15  FILLER  PIC X(17) VALUE 'I FIRECRACKER STD'.     
                   15  FILLER  PIC X(17) VALUE 'J GARAGE         '.     
                   15  FILLER  PIC X(17) VALUE 'K GARAGE APT     '.     
                   15  FILLER  PIC X(17) VALUE 'L GREENHOUSE     '.     
                   15  FILLER  PIC X(17) VALUE 'M HOUSE          '.     
                   15  FILLER  PIC X(17) VALUE 'N INDUSTRIAL     '.     
                   15  FILLER  PIC X(17) VALUE 'O IRRIGATION     '.     
                   15  FILLER  PIC X(17) VALUE 'P LIFT STATION   '.     
                   15  FILLER  PIC X(17) VALUE 'Q MOBILE HOME    '.     
                   15  FILLER  PIC X(17) VALUE 'R POOL HEATER    '.     
                   15  FILLER  PIC X(17) VALUE 'S PUMP/WELL      '.     
                   15  FILLER  PIC X(17) VALUE 'T STANDBY GEN    '.     
                   15  FILLER  PIC X(17) VALUE 'U T-SAW POLE     '.     
                   15  FILLER  PIC X(17) VALUE 'V TOBACCO BARN   '.     
                   15  FILLER  PIC X(17) VALUE 'W TURKEY SHOOT   '.     
                   15  FILLER  PIC X(17) VALUE 'X WAREHOUSE      '.     
                   15  FILLER  PIC X(17) VALUE 'Y WHOLESALE CUST '.     
                   15  FILLER  PIC X(17) VALUE 'Z XMAS TREE STAND'.     
                   15  FILLER  PIC X(17) VALUE '0 UNKNOWN        '.     
               10  WS-SUPPLYING-DATA-R REDEFINES WS-SUPPLYING-DATA.     
                   15  WS-SUPPLYING-LINE  OCCURS 27                     
                                          INDEXED BY WS-SUPPLYING-INDEX.
                       20 WS-SUPPLYING-CD   PIC X(02).                  
                       20 WS-SUPPLYING-DESC PIC X(15).                  
           05  T3-CSR04479A           OCCURS 25                         
                                      INDEXED BY T3-INDEX.              
               10 T3-RETURN-CODE        PIC S9(9) COMP VALUE 0.         
               10 T3-ASSIGNED-DATE      PIC X(10) VALUE SPACES.         
               10 T3-SERV-ORDER-NO      PIC S9(13)V COMP-3 VALUE 0.     
               10 T3-ORDER-TYPE-CD      PIC X(05) VALUE SPACES.         
               10 T3-ORDER-STATE-CD     PIC X(01) VALUE SPACES.         
               10 T3-CUSTOMER-NAME      PIC X(76) VALUE SPACES.         
               10 T3-REMARKS            PIC X(210) VALUE SPACES.        
               10 T3-WORK-AREA          PIC X(12) VALUE SPACES.         
               10 T3-PHONE              PIC X(10) VALUE SPACES.         
               10 T3-REMARK-TYPE        PIC X(01) VALUE SPACES.         
P00718*        10 T3-BUSINESS-UNIT      PIC X(03) VALUE SPACES.                 
           05  T4-CSR04479B           OCCURS 100                        
                                      INDEXED BY T4-INDEX.              
               10 T4-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
               10 T4-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.        
               10 T4-METER-NO            PIC X(09) VALUE SPACES.        
               10 T4-RATE-PLAN           PIC X(03) VALUE SPACES.        
               10 T4-SUPPLIES            PIC X(15) VALUE SPACES.        
               10 T4-METER-LOC           PIC X(02) VALUE SPACES.        
               10 T4-METER-STATUS        PIC X(02) VALUE SPACES.        
               10 T4-METER-STATUS-REASON PIC X(02) VALUE SPACES.        
               10 T4-WORK-TYPE-CD        PIC X(03) VALUE SPACES.        
               10 T4-METER-READ-INST     PIC X(02) VALUE SPACES.        
               10 T4-METER-IND           PIC X(01) VALUE SPACES.        
               10 T4-IC-NO               PIC S9(4) COMP VALUE 0.        
               10 T4-MTR-REF-NO          PIC S9(4) COMP VALUE 0.        
               10 T4-RLSE-REQUIRED       PIC X(01) VALUE SPACES.        
               10 T4-RLSE-NO             PIC X(10) VALUE SPACES.        
               10 T4-RLSE-MSG            PIC X(05) VALUE SPACES.        
               10 T4-RLSE-ADDL-MSG       PIC X(05) VALUE SPACES.        
               10 T4-RLSE-PHONE          PIC X(12) VALUE SPACES.        
               10 T4-RLSE-ALT-PHONE      PIC X(12) VALUE SPACES.        
               10 T4-RLSE-REV-DIST       PIC X(25) VALUE SPACES.        
               10 T4-BUS-RULE-ID         PIC X(10) VALUE SPACES.        
               10 T4-ACTION-TYPE-CD      PIC X(08) VALUE SPACES.        
               10 T4-BUS-RULE-XREF-ID    PIC X(26) VALUE SPACES.        
           05  T5-CSR04479C           OCCURS 40                         
                                      INDEXED BY T5-INDEX.              
               10 T5-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
               10 T5-SERV-ORDER-NO       PIC S9(13)V COMP-3 VALUE 0.    
               10 T5-CODE-UTIL-TYPE      PIC X(01) VALUE SPACES.        
               10 T5-WORK-TYPE-CD        PIC X(03) VALUE SPACES.        
               10 T5-IC-NO               PIC S9(4) COMP VALUE 0.        
               10 T5-METER-NO            PIC X(09) VALUE SPACES.        
               10 T5-MTR-REF-NO          PIC S9(4) COMP VALUE 0.        
           05  T7-CSR04480B           OCCURS 200                        
                                      INDEXED BY T7-INDEX.              
               10 T7-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
               10 T7-CALENDAR-DT         PIC X(10) VALUE SPACES.        
               10 T7-GOOD-DAY-FL         PIC X(01) VALUE SPACES.        
               10 T7-TOTAL-SO-HRS        PIC S9(5)V9(1) COMP-3 VALUE 0. 
               10 T7-MAX-RE-PER-DAY      PIC S9(4) COMP VALUE 0.        
               10 T7-TOTAL-SO            PIC S9(4) COMP VALUE 0.        
               10 T7-MAX-DAILY-WK-REQ    PIC S9(4) COMP VALUE 0.        
           05  T8-CSR04154            OCCURS 25                         
                                      INDEXED BY T8-INDEX.              
               10 T8-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
               10 T8-SCENARIO-SEQ        PIC S9(4) COMP VALUE 0.        
               10 T8-SCENARIO-SEQ-CHOICE PIC S9(4) COMP VALUE 0.        
               10 T8-NEW-ORDER-TYPE      PIC X(05) VALUE SPACES.        
               10 T8-NEW-E-WORK-TYPE     PIC X(03) VALUE SPACES.        
               10 T8-NEW-G-WORK-TYPE     PIC X(03) VALUE SPACES.        
               10 T8-NEW-ORDER-STATE-CD  PIC X(01) VALUE SPACES.        
               10 T8-DISPATCH-NOT-WQ     PIC X(01) VALUE SPACES.        
               10 T8-ADDL-SO-REMARKS     PIC X(50) VALUE SPACES.        
               10 T8-SO-HOLD-COMMENTS    PIC X(25) VALUE SPACES.        
               10 T8-SCHED-DT-FUNC-CD    PIC X(01) VALUE SPACES.        
               10 T8-MAX-DATE            PIC X(10) VALUE SPACES.        
               10 T8-ORD-AUTO-SEL-CD     PIC X(01) VALUE SPACES.        
               10 T8-WORK-AREA           PIC X(12) VALUE SPACES.        
               10 T8-ARRANGEMENT-FL      PIC X(01) VALUE SPACES.        
               10 T8-ELEC-RLSE-FL        PIC X(01) VALUE SPACES.        
               10 T8-GAS-RLSE-FL         PIC X(01) VALUE SPACES.        
P00718         10 T8-BUSINESS-UNIT       PIC X(03) VALUE SPACES.        
P00718         10 T8-WORK-DISTRICT       PIC X(40) VALUE SPACES.        
P0795C         10 T8-ORDER-BUS-RULE-ID   PIC X(10) VALUE SPACES.        
A05189         10 T8-AROP-READ-ONLY-FL   PIC X(01) VALUE SPACES.        
P0795F         10 T8-ORDER-UTILITY-CD    PIC X(01) VALUE SPACES.        
D12002         10 T8-ELEC-RLSE-NO        PIC X(10) VALUE SPACES.        
D12002         10 T8-GAS-RLSE-NO         PIC X(10) VALUE SPACES.        
           05  T9-CSR04479D           OCCURS 40                         
                                      INDEXED BY T9-INDEX.              
               10 T9-RETURN-CODE         PIC S9(9) COMP VALUE 0.        
               10 T9-RATE-PLAN           PIC X(03) VALUE SPACES.        
               10 T9-RATE-ITEM-CODE      PIC S9(4) COMP VALUE 0.        
               10 T9-CODE-PLAN-STATUS    PIC X(01) VALUE SPACES.        
               10 T9-CODE-STATUS-REASON  PIC X(01) VALUE SPACES.        
               10 T9-MONTHLY-AMOUNT      PIC S9(3)V99 COMP-3 VALUE 0.   
               10 T9-NO-UNITS            PIC S9(4) COMP VALUE 0.        
           05  T10-METER-LINE            PIC X(2000).                   
           05  T10-METER-TABLE REDEFINES T10-METER-LINE.                
               10  T10-PARM-METER        OCCURS 50                      
                                      INDEXED BY T10-INDEX.             
                   15  T10-METER-NO       PIC X(09).                    
                   15  T10-CODE-UTIL-TYPE PIC X(01).                    
                   15  T10-METER-IND      PIC X(01).                    
                   15  T10-METER-STATUS   PIC X(01).                    
                   15  T10-USER-CHG-TYPE  PIC X(01).                    
                   15  T10-RLSE-CD        PIC X(01).                    
                   15  T10-IC-NO          PIC X(04).                    
                   15  T10-MTR-REF        PIC X(04).                    
                   15  T10-WORK-TYPE      PIC X(03).                    
                   15  T10-SUPPLYING      PIC X(15).                    
           05  T11-CSR04479E           OCCURS 40                        
                                      INDEXED BY T11-INDEX.             
               10 T11-RETURN-CODE        PIC S9(9) COMP VALUE 0.        
               10 T11-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.        
               10 T11-IC-NO              PIC S9(4) COMP VALUE 0.        
               10 T11-RATE-PLAN          PIC X(03) VALUE SPACES.        
               10 T11-CODE-REV-CLASS     PIC X(03) VALUE SPACES.        
               10 T11-RATE-PLAN-DESC     PIC X(25) VALUE SPACES.        
               10 T11-TOU-FL             PIC X(01) VALUE SPACES.        
               10 T11-FIXED-FACTOR-FL    PIC X(01) VALUE SPACES.        
               10 T11-BILL-CONTRACT-FL   PIC X(01) VALUE SPACES.        
               10 T11-INTERRUPT-FL       PIC X(01) VALUE SPACES.        
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
           COPY CWS04423.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBWKAR                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBORWT                                                    
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
A04670     EXEC SQL                                                             
A04670        INCLUDE TBSODAT                                                   
A04670     END-EXEC.                                                            
P00718     EXEC SQL                                                             
P00718        INCLUDE TBSOLOC                                                   
P00718     END-EXEC.                                                            
P00718     EXEC SQL                                                             
P00718        INCLUDE TBRGREAD                                                  
P00718     END-EXEC.                                                            
P0795D*  A9   - CSS_REV_DISTRICT                                                
P0795D     EXEC SQL                                                             
P0795D        INCLUDE TBRVDST                                                   
P0795D     END-EXEC.                                                            
                                                                        
P01176*  *** CSS_SAMPL_TST_PULL 6Z                                              
P01176     EXEC SQL                                                             
P01176         INCLUDE TBSAMTST                                                 
P01176     END-EXEC.                                                            
                                                                        
A05821*  *** CSS_CUST_MISC_INFO LQ                                              
A05821     EXEC SQL                                                             
A05821         INCLUDE TBCSTMSC                                                 
A05821     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
      *01 LOC4479A USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479B USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479C USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479D USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479E USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4480A USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4480B USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC1684  USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4153  USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4154  USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC1116 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4109 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4012 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4281 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
A05189*01 LOC4849 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
              DECLARE APPL-CURSOR CURSOR FOR                            
               SELECT SEASONAL_RT_FL,                                   
                      CRAWL_FL                                          
                 FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                   
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :LA-PREMISE-NO                       
                  AND PRIMARY_FUEL_CD = 'NA-GAS'                        
                  AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                 
                  AND LA.COMPANY_NO = JA.COMPANY_NO                     
                  AND CIS_DISPLAY_FL = 'Y'                              
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE APPL-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT SEASONAL_RT_FL,                                           
MFA-TR*               CRAWL_FL                                                  
MFA-TR*          FROM CSS_APPLIANCE LA,                                         
MFA-TR*               CSS_MKT_APPLIANCE JA                                      
MFA-TR*         WHERE PREMISE_NO = :LA-PREMISE-NO                               
MFA-TR*           AND PRIMARY_FUEL_CD = 'NA-GAS'                                
MFA-TR*           AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                         
MFA-TR*           AND LA.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 STATUS_CODE          AS STATUS_CODE,                   
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 ACTION_TYPE_CD       AS ACTION_TYPE_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,              
                 MESSAGE_PARMS        AS MESSAGE_PARMS                  
              FROM #CSR04482_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          STATUS_CODE          AS STATUS_CODE,                           
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          ACTION_TYPE_CD       AS ACTION_TYPE_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,                      
MFA-TR*          MESSAGE_PARMS        AS MESSAGE_PARMS                          
MFA-TR*       FROM SESSION.CSR04482_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CODE,              
                      :S-BUS-RULE-ID       AS BUS_RULE_ID,              
                      :S-ACTION-TYPE-CD    AS ACTION_TYPE_CD,           
                      :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID,         
                      :S-MESSAGE-PARMS     AS MESSAGE_PARMS             
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CODE,                      
MFA-TR*               :S-BUS-RULE-ID       AS BUS_RULE_ID,                      
MFA-TR*               :S-ACTION-TYPE-CD    AS ACTION_TYPE_CD,                   
MFA-TR*               :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID,                 
MFA-TR*               :S-MESSAGE-PARMS     AS MESSAGE_PARMS                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR  FOR                        
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-REVERT-FL         AS REVERT_FL,                
                      :S-WORK-AREA-2       AS WORK_AREA,                
                      :S-TOTAL-RES         AS TOTAL_RES,                
                      :S-DISCONNECT-CD     AS DISCONNECT_CD,            
                      :S-ARRANGEMENT-FL-2  AS ARRANGEMENT_FL,           
                      :S-BAD-ELEC-WK-TYPE  AS BAD_ELEC_WK_TYPE,         
                      :S-BAD-GAS-WK-TYPE   AS BAD_GAS_WK_TYPE,          
                      :S-PAYMENT-REQ-FL    AS PAYMENT_REQ_FL,           
A04670                :S-RECALC-ORDER-TYPE-CD AS RECALC_ORDER_TYPE_CD,  
P00718                :S-BUSINESS-UNIT-2   AS BUSINESS_UNIT,            
P00718          LTRIM(RTRIM(:S-WORK-DISTRICT-2))  AS WORK_DISTRICT,            
A05189                :S-AROP-READ-ONLY-FL-2  AS AROP_READ_ONLY         
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-REVERT-FL         AS REVERT_FL,                        
MFA-TR*               :S-WORK-AREA-2       AS WORK_AREA,                        
MFA-TR*               :S-TOTAL-RES         AS TOTAL_RES,                        
MFA-TR*               :S-DISCONNECT-CD     AS DISCONNECT_CD,                    
MFA-TR*               :S-ARRANGEMENT-FL-2  AS ARRANGEMENT_FL,                   
MFA-TR*               :S-BAD-ELEC-WK-TYPE  AS BAD_ELEC_WK_TYPE,                 
MFA-TR*               :S-BAD-GAS-WK-TYPE   AS BAD_GAS_WK_TYPE,                  
MFA-TR*               :S-PAYMENT-REQ-FL    AS PAYMENT_REQ_FL,                   
MFA-TR*               :S-RECALC-ORDER-TYPE-CD AS RECALC_ORDER_TYPE_CD,          
MFA-TR*               :S-BUSINESS-UNIT-2   AS BUSINESS_UNIT,                    
MFA-TR*         STRIP(:S-WORK-DISTRICT-2)  AS WORK_DISTRICT,                    
MFA-TR*               :S-AROP-READ-ONLY-FL-2  AS AROP_READ_ONLY                 
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 ASSIGNED_DATE        AS ASSIGNED_DATE,                 
                 SERV_ORDER_NO        AS SERV_ORDER_NO,                 
                 ORDER_TYPE_CD        AS ORDER_TYPE_CD,                 
                 ORDER_STATE_CD       AS ORDER_STATE_CD,                
                 CUSTOMER_NAME        AS CUSTOMER_NAME,                 
                 REMARKS              AS REMARKS,                       
                 WORK_AREA            AS WORK_AREA,                     
                 PHONE                AS PHONE,                         
                 REMARK_TYPE          AS REMARK_TYPE                    
P00718*          BUSINESS_UNIT        AS BUSINESS_UNIT                          
              FROM #CSR04482_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          ASSIGNED_DATE        AS ASSIGNED_DATE,                         
MFA-TR*          SERV_ORDER_NO        AS SERV_ORDER_NO,                         
MFA-TR*          ORDER_TYPE_CD        AS ORDER_TYPE_CD,                         
MFA-TR*          ORDER_STATE_CD       AS ORDER_STATE_CD,                        
MFA-TR*          CUSTOMER_NAME        AS CUSTOMER_NAME,                         
MFA-TR*          REMARKS              AS REMARKS,                               
MFA-TR*          WORK_AREA            AS WORK_AREA,                             
MFA-TR*          PHONE                AS PHONE,                                 
MFA-TR*          REMARK_TYPE          AS REMARK_TYPE                            
MFA-TR*          BUSINESS_UNIT        AS BUSINESS_UNIT                          
MFA-TR*       FROM SESSION.CSR04482_R3                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3     AS RETURN_CODE,              
                      :S-ASSIGNED-DATE     AS ASSIGNED_DATE,            
                      :S-SERV-ORDER-NO-3   AS SERV_ORDER_NO,            
                      :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,            
                      :S-ORDER-STATE-CD    AS ORDER_STATE_CD,           
                      :S-CUSTOMER-NAME     AS CUSTOMER_NAME,            
                      :S-REMARKS           AS REMARKS,                  
                      :S-WORK-AREA-3       AS WORK_AREA,                
                      :S-PHONE             AS PHONE,                    
                      :S-REMARK-TYPE       AS REMARK_TYPE               
P00718*               :S-BUSINESS-UNIT-3   AS BUSINESS_UNIT                     
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3     AS RETURN_CODE,                      
MFA-TR*               :S-ASSIGNED-DATE     AS ASSIGNED_DATE,                    
MFA-TR*               :S-SERV-ORDER-NO-3   AS SERV_ORDER_NO,                    
MFA-TR*               :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,                    
MFA-TR*               :S-ORDER-STATE-CD    AS ORDER_STATE_CD,                   
MFA-TR*               :S-CUSTOMER-NAME     AS CUSTOMER_NAME,                    
MFA-TR*               :S-REMARKS           AS REMARKS,                          
MFA-TR*               :S-WORK-AREA-3       AS WORK_AREA,                        
MFA-TR*               :S-PHONE             AS PHONE,                            
MFA-TR*               :S-REMARK-TYPE       AS REMARK_TYPE                       
MFA-TR*               :S-BUSINESS-UNIT-3   AS BUSINESS_UNIT                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C4 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 METER_NO             AS METER_NO,                      
                 RATE_PLAN            AS RATE_PLAN,                     
                 SUPPLIES             AS SUPPLIES,                      
                 METER_LOC            AS METER_LOC,                     
                 METER_STATUS         AS METER_STATUS,                  
                 METER_STATUS_REASON  AS METER_STATUS_REASON,           
                 WORK_TYPE_CD         AS WORK_TYPE_CD,                  
                 METER_READ_INST      AS METER_READ_INST,               
                 METER_IND            AS METER_IND,                     
                 IC_NO                AS IC_NO,                         
                 MTR_REF_NO           AS MTR_REF_NO,                    
                 RLSE_REQUIRED        AS RLSE_REQUIRED,                 
                 RLSE_NO              AS RLSE_NO,                       
                 RLSE_MSG             AS RLSE_MSG,                      
                 RLSE_ADDL_MSG        AS RLSE_ADDL_MSG,                 
                 RLSE_PHONE           AS RLSE_PHONE,                    
                 RLSE_ALT_PHONE       AS RLSE_ALT_PHONE,                
                 RLSE_REV_DIST        AS RLSE_REV_DIST,                 
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 ACTION_TYPE_CD       AS ACTION_TYPE_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,              
P0795B           MESSAGE_PARMS        AS MESSAGE_PARMS                  
              FROM #CSR04482_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          METER_NO             AS METER_NO,                              
MFA-TR*          RATE_PLAN            AS RATE_PLAN,                             
MFA-TR*          SUPPLIES             AS SUPPLIES,                              
MFA-TR*          METER_LOC            AS METER_LOC,                             
MFA-TR*          METER_STATUS         AS METER_STATUS,                          
MFA-TR*          METER_STATUS_REASON  AS METER_STATUS_REASON,                   
MFA-TR*          WORK_TYPE_CD         AS WORK_TYPE_CD,                          
MFA-TR*          METER_READ_INST      AS METER_READ_INST,                       
MFA-TR*          METER_IND            AS METER_IND,                             
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          MTR_REF_NO           AS MTR_REF_NO,                            
MFA-TR*          RLSE_REQUIRED        AS RLSE_REQUIRED,                         
MFA-TR*          RLSE_NO              AS RLSE_NO,                               
MFA-TR*          RLSE_MSG             AS RLSE_MSG,                              
MFA-TR*          RLSE_ADDL_MSG        AS RLSE_ADDL_MSG,                         
MFA-TR*          RLSE_PHONE           AS RLSE_PHONE,                            
MFA-TR*          RLSE_ALT_PHONE       AS RLSE_ALT_PHONE,                        
MFA-TR*          RLSE_REV_DIST        AS RLSE_REV_DIST,                         
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          ACTION_TYPE_CD       AS ACTION_TYPE_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,                      
MFA-TR*          MESSAGE_PARMS        AS MESSAGE_PARMS                          
MFA-TR*       FROM SESSION.CSR04482_R4                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N4 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-4     AS RETURN_CODE,              
                      :S-CODE-UTIL-TYPE-4  AS CODE_UTIL_TYPE,           
                      :S-METER-NO-4        AS METER_NO,                 
                      :S-RATE-PLAN         AS RATE_PLAN,                
                      :S-SUPPLIES          AS SUPPLIES,                 
                      :S-METER-LOC         AS METER_LOC,                
                      :S-METER-STATUS      AS METER_STATUS,             
                      :S-METER-STATUS-REASON AS METER_STATUS_REASON,    
                      :S-WORK-TYPE-CD-4    AS WORK_TYPE_CD,             
                      :S-METER-READ-INST   AS METER_READ_INST,          
                      :S-METER-IND         AS METER_IND,                
                      :S-IC-NO-4           AS IC_NO,                    
                      :S-MTR-REF-NO-4      AS MTR_REF_NO,               
                      :S-RLSE-REQUIRED     AS RLSE_REQUIRED,            
                      :S-RLSE-NO           AS RLSE_NO,                  
                      :S-RLSE-MSG          AS RLSE_MSG,                 
                      :S-RLSE-ADDL-MSG     AS RLSE_ADDL_MSG,            
                      :S-RLSE-PHONE        AS RLSE_PHONE,               
                      :S-RLSE-ALT-PHONE    AS RLSE_ALT_PHONE,           
                      :S-RLSE-REV-DIST     AS RLSE_REV_DIST,            
                      :S-BUS-RULE-ID-4     AS BUS_RULE_ID,              
                      :S-ACTION-TYPE-CD-4  AS ACTION_TYPE_CD,           
                      :S-BUS-RULE-XREF-ID-4 AS BUS_RULE_XREF_ID,        
P0795B                :S-MESSAGE-PARMS-4    AS MESSAGE_PARMS            
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N4 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-4     AS RETURN_CODE,                      
MFA-TR*               :S-CODE-UTIL-TYPE-4  AS CODE_UTIL_TYPE,                   
MFA-TR*               :S-METER-NO-4        AS METER_NO,                         
MFA-TR*               :S-RATE-PLAN         AS RATE_PLAN,                        
MFA-TR*               :S-SUPPLIES          AS SUPPLIES,                         
MFA-TR*               :S-METER-LOC         AS METER_LOC,                        
MFA-TR*               :S-METER-STATUS      AS METER_STATUS,                     
MFA-TR*               :S-METER-STATUS-REASON AS METER_STATUS_REASON,            
MFA-TR*               :S-WORK-TYPE-CD-4    AS WORK_TYPE_CD,                     
MFA-TR*               :S-METER-READ-INST   AS METER_READ_INST,                  
MFA-TR*               :S-METER-IND         AS METER_IND,                        
MFA-TR*               :S-IC-NO-4           AS IC_NO,                            
MFA-TR*               :S-MTR-REF-NO-4      AS MTR_REF_NO,                       
MFA-TR*               :S-RLSE-REQUIRED     AS RLSE_REQUIRED,                    
MFA-TR*               :S-RLSE-NO           AS RLSE_NO,                          
MFA-TR*               :S-RLSE-MSG          AS RLSE_MSG,                         
MFA-TR*               :S-RLSE-ADDL-MSG     AS RLSE_ADDL_MSG,                    
MFA-TR*               :S-RLSE-PHONE        AS RLSE_PHONE,                       
MFA-TR*               :S-RLSE-ALT-PHONE    AS RLSE_ALT_PHONE,                   
MFA-TR*               :S-RLSE-REV-DIST     AS RLSE_REV_DIST,                    
MFA-TR*               :S-BUS-RULE-ID-4     AS BUS_RULE_ID,                      
MFA-TR*               :S-ACTION-TYPE-CD-4  AS ACTION_TYPE_CD,                   
MFA-TR*               :S-BUS-RULE-XREF-ID-4 AS BUS_RULE_XREF_ID,                
MFA-TR*               :S-MESSAGE-PARMS-4    AS MESSAGE_PARMS                    
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C5 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 SERV_ORDER_NO        AS SERV_ORDER_NO,                 
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 WORK_TYPE_CD         AS WORK_TYPE_CD,                  
                 IC_NO                AS IC_NO,                         
                 METER_NO             AS METER_NO,                      
                 MTR_REF_NO           AS MTR_REF_NO                     
              FROM #CSR04482_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C5 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          SERV_ORDER_NO        AS SERV_ORDER_NO,                         
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          WORK_TYPE_CD         AS WORK_TYPE_CD,                          
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          METER_NO             AS METER_NO,                              
MFA-TR*          MTR_REF_NO           AS MTR_REF_NO                             
MFA-TR*       FROM SESSION.CSR04482_R5                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N5 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-5     AS RETURN_CODE,              
                      :S-SERV-ORDER-NO-5   AS SERV_ORDER_NO,            
                      :S-CODE-UTIL-TYPE-5  AS CODE_UTIL_TYPE,           
                      :S-WORK-TYPE-CD-5    AS WORK_TYPE_CD,             
                      :S-IC-NO-5           AS IC_NO,                    
                      :S-METER-NO-5        AS METER_NO,                 
                      :S-MTR-REF-NO-5      AS MTR_REF_NO                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N5 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-5     AS RETURN_CODE,                      
MFA-TR*               :S-SERV-ORDER-NO-5   AS SERV_ORDER_NO,                    
MFA-TR*               :S-CODE-UTIL-TYPE-5  AS CODE_UTIL_TYPE,                   
MFA-TR*               :S-WORK-TYPE-CD-5    AS WORK_TYPE_CD,                     
MFA-TR*               :S-IC-NO-5           AS IC_NO,                            
MFA-TR*               :S-METER-NO-5        AS METER_NO,                         
MFA-TR*               :S-MTR-REF-NO-5      AS MTR_REF_NO                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C6 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CALENDAR_DT          AS CALENDAR_DT,                   
                 GOOD_DAY_FL          AS GOOD_DAY_FL,                   
                 SCENARIO_SEQ         AS SCENARIO_SEQ,                  
                 SCENARIO_SEQ_CHOICE  AS SCENARIO_SEQ_CHOICE            
              FROM #CSR04482_R6                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C6 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CALENDAR_DT          AS CALENDAR_DT,                           
MFA-TR*          GOOD_DAY_FL          AS GOOD_DAY_FL,                           
MFA-TR*          SCENARIO_SEQ         AS SCENARIO_SEQ,                          
MFA-TR*          SCENARIO_SEQ_CHOICE  AS SCENARIO_SEQ_CHOICE                    
MFA-TR*       FROM SESSION.CSR04482_R6                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N6 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-6     AS RETURN_CODE,              
                      :S-CALENDAR-DT       AS CALENDAR_DT,              
                      :S-GOOD-DAY-FL       AS GOOD_DAY_FL,              
                      :S-SCENARIO-SEQ-6    AS SCENARIO_SEQ,             
                      :S-SCENARIO-SEQ-CHOICE-6 AS SCENARIO_SEQ_CHOICE   
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N6 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-6     AS RETURN_CODE,                      
MFA-TR*               :S-CALENDAR-DT       AS CALENDAR_DT,                      
MFA-TR*               :S-GOOD-DAY-FL       AS GOOD_DAY_FL,                      
MFA-TR*               :S-SCENARIO-SEQ-6    AS SCENARIO_SEQ,                     
MFA-TR*               :S-SCENARIO-SEQ-CHOICE-6 AS SCENARIO_SEQ_CHOICE           
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C7 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 SCENARIO_SEQ         AS SCENARIO_SEQ,                  
                 SCENARIO_SEQ_CHOICE  AS SCENARIO_SEQ_CHOICE,           
                 NEW_ORDER_TYPE       AS NEW_ORDER_TYPE,                
                 NEW_E_WORK_TYPE      AS NEW_E_WORK_TYPE,               
                 NEW_G_WORK_TYPE      AS NEW_G_WORK_TYPE,               
                 NEW_ORDER_STATE_CD   AS NEW_ORDER_STATE_CD,            
                 DISPATCH_NOT_WQ      AS DISPATCH_NOT_WQ,               
                 ADDL_SO_REMARKS      AS ADDL_SO_REMARKS,               
                 SO_HOLD_COMMENTS     AS SO_HOLD_COMMENTS,              
                 SCHED_DT_FUNC_CD     AS SCHED_DT_FUNC_CD,              
                 MAX_DATE             AS MAX_DATE,                      
                 ORD_AUTO_SEL_CD      AS ORD_AUTO_SEL_CD,               
                 WORK_AREA            AS WORK_AREA,                     
                 ARRANGEMENT_FL       AS ARRANGEMENT_FL,                
                 ELEC_RLSE_FL         AS ELEC_RLSE_FL,                  
                 GAS_RLSE_FL          AS GAS_RLSE_FL,                   
P00718           BUSINESS_UNIT        AS BUSINESS_UNIT,                 
P00718           WORK_DISTRICT        AS WORK_DISTRICT,                 
P0795C           ORDER_BUS_RULE_ID    AS ORDER_BUS_RULE_ID,             
A05189           AROP_READ_ONLY       AS AROP_READ_ONLY,                
P0795F           ORDER_UTILITY_CD     AS ORDER_UTILITY_CD,              
D12002           ELEC_RLSE_NO         AS ELEC_RLSE_NO,                  
D12002           GAS_RLSE_NO          AS GAS_RLSE_NO                    
              FROM #CSR04482_R7                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C7 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          SCENARIO_SEQ         AS SCENARIO_SEQ,                          
MFA-TR*          SCENARIO_SEQ_CHOICE  AS SCENARIO_SEQ_CHOICE,                   
MFA-TR*          NEW_ORDER_TYPE       AS NEW_ORDER_TYPE,                        
MFA-TR*          NEW_E_WORK_TYPE      AS NEW_E_WORK_TYPE,                       
MFA-TR*          NEW_G_WORK_TYPE      AS NEW_G_WORK_TYPE,                       
MFA-TR*          NEW_ORDER_STATE_CD   AS NEW_ORDER_STATE_CD,                    
MFA-TR*          DISPATCH_NOT_WQ      AS DISPATCH_NOT_WQ,                       
MFA-TR*          ADDL_SO_REMARKS      AS ADDL_SO_REMARKS,                       
MFA-TR*          SO_HOLD_COMMENTS     AS SO_HOLD_COMMENTS,                      
MFA-TR*          SCHED_DT_FUNC_CD     AS SCHED_DT_FUNC_CD,                      
MFA-TR*          MAX_DATE             AS MAX_DATE,                              
MFA-TR*          ORD_AUTO_SEL_CD      AS ORD_AUTO_SEL_CD,                       
MFA-TR*          WORK_AREA            AS WORK_AREA,                             
MFA-TR*          ARRANGEMENT_FL       AS ARRANGEMENT_FL,                        
MFA-TR*          ELEC_RLSE_FL         AS ELEC_RLSE_FL,                          
MFA-TR*          GAS_RLSE_FL          AS GAS_RLSE_FL,                           
MFA-TR*          BUSINESS_UNIT        AS BUSINESS_UNIT,                         
MFA-TR*          WORK_DISTRICT        AS WORK_DISTRICT,                         
MFA-TR*          ORDER_BUS_RULE_ID    AS ORDER_BUS_RULE_ID,                     
MFA-TR*          AROP_READ_ONLY       AS AROP_READ_ONLY,                        
MFA-TR*          ORDER_UTILITY_CD     AS ORDER_UTILITY_CD,                      
MFA-TR*          ELEC_RLSE_NO         AS ELEC_RLSE_NO,                          
MFA-TR*          GAS_RLSE_NO          AS GAS_RLSE_NO                            
MFA-TR*       FROM SESSION.CSR04482_R7                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N7 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-7       AS RETURN_CODE,            
                      :S-SCENARIO-SEQ-7      AS SCENARIO_SEQ,           
                      :S-SCENARIO-SEQ-CHOICE-7 AS SCENARIO_SEQ_CHOICE,  
                      :S-NEW-ORDER-TYPE      AS NEW_ORDER_TYPE,         
                      :S-NEW-E-WORK-TYPE     AS NEW_E_WORK_TYPE,        
                      :S-NEW-G-WORK-TYPE     AS NEW_G_WORK_TYPE,        
                      :S-NEW-ORDER-STATE-CD  AS NEW_ORDER_STATE_CD,     
                      :S-DISPATCH-NOT-WQ     AS DISPATCH_NOT_WQ,        
                      :S-ADDL-SO-REMARKS     AS ADDL_SO_REMARKS,        
                      :S-SO-HOLD-COMMENTS    AS SO_HOLD_COMMENTS,       
                      :S-SCHED-DT-FUNC-CD    AS SCHED_DT_FUNC_CD,       
                      :S-MAX-DATE            AS MAX_DATE,               
                      :S-ORD-AUTO-SEL-CD     AS ORD_AUTO_SEL_CD,        
                      :S-WORK-AREA-7         AS WORK_AREA,              
                      :S-ARRANGEMENT-FL-7    AS ARRANGEMENT_FL,         
                      :S-ELEC-RLSE-FL        AS ELEC_RLSE_FL,           
                      :S-GAS-RLSE-FL         AS GAS_RLSE_FL,            
P00718                :S-BUSINESS-UNIT-7     AS BUSINESS_UNIT,          
P00718          LTRIM(RTRIM(:S-WORK-DISTRICT-7))    AS WORK_DISTRICT,          
P0795C          LTRIM(RTRIM(:S-ORDER-BUS-RULE-ID))  AS 
           ORDER_BUS_RULE_ID,      
A05189                :S-AROP-READ-ONLY-FL-7 AS AROP_READ_ONLY,         
P0795F          LTRIM(RTRIM(:S-ORDER-UTILITY-CD))   AS ORDER_UTILITY_CD,       
D12002          LTRIM(RTRIM(:S-ELEC-RLSE-NO))       AS ELEC_RLSE_NO,           
D12002          LTRIM(RTRIM(:S-GAS-RLSE-NO))        AS GAS_RLSE_NO             
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N7 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-7       AS RETURN_CODE,                    
MFA-TR*               :S-SCENARIO-SEQ-7      AS SCENARIO_SEQ,                   
MFA-TR*               :S-SCENARIO-SEQ-CHOICE-7 AS SCENARIO_SEQ_CHOICE,          
MFA-TR*               :S-NEW-ORDER-TYPE      AS NEW_ORDER_TYPE,                 
MFA-TR*               :S-NEW-E-WORK-TYPE     AS NEW_E_WORK_TYPE,                
MFA-TR*               :S-NEW-G-WORK-TYPE     AS NEW_G_WORK_TYPE,                
MFA-TR*               :S-NEW-ORDER-STATE-CD  AS NEW_ORDER_STATE_CD,             
MFA-TR*               :S-DISPATCH-NOT-WQ     AS DISPATCH_NOT_WQ,                
MFA-TR*               :S-ADDL-SO-REMARKS     AS ADDL_SO_REMARKS,                
MFA-TR*               :S-SO-HOLD-COMMENTS    AS SO_HOLD_COMMENTS,               
MFA-TR*               :S-SCHED-DT-FUNC-CD    AS SCHED_DT_FUNC_CD,               
MFA-TR*               :S-MAX-DATE            AS MAX_DATE,                       
MFA-TR*               :S-ORD-AUTO-SEL-CD     AS ORD_AUTO_SEL_CD,                
MFA-TR*               :S-WORK-AREA-7         AS WORK_AREA,                      
MFA-TR*               :S-ARRANGEMENT-FL-7    AS ARRANGEMENT_FL,                 
MFA-TR*               :S-ELEC-RLSE-FL        AS ELEC_RLSE_FL,                   
MFA-TR*               :S-GAS-RLSE-FL         AS GAS_RLSE_FL,                    
MFA-TR*               :S-BUSINESS-UNIT-7     AS BUSINESS_UNIT,                  
MFA-TR*         STRIP(:S-WORK-DISTRICT-7)    AS WORK_DISTRICT,                  
MFA-TR*         STRIP(:S-ORDER-BUS-RULE-ID)  AS ORDER_BUS_RULE_ID,              
MFA-TR*               :S-AROP-READ-ONLY-FL-7 AS AROP_READ_ONLY,                 
MFA-TR*         STRIP(:S-ORDER-UTILITY-CD)   AS ORDER_UTILITY_CD,               
MFA-TR*         STRIP(:S-ELEC-RLSE-NO)       AS ELEC_RLSE_NO,                   
MFA-TR*         STRIP(:S-GAS-RLSE-NO)        AS GAS_RLSE_NO                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_CUR_1 CURSOR
MSQ001          FOR CALL CSR04479                                             
                  ( :ACCOUNT-NO-4479
                  , :PREMISE-NO-4479
                  , :PROCESS-4479
                  , :ASSIGNED-DATE-IN-4479
                  , :PROGRAM-ID-4479
                  , :ORDER-TYPE-CD-4479
                  , :SERV-ORDER-NO-4479
                  , :CURRENT-HISTORY-FL-4479
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_CUR_2 CURSOR
MSQ001          FOR CALL CSR04480                                             
                  ( :CODE-UTIL-TYPE-4480
                  , :WORK-TYPE-4480
                  , :METER-IND-4480
                  , :METER-STATUS-4480
                  , :ACCOUNT-NO-4480
                  , :PREMISE-NO-4480
                  , :ORDER-TYPE-CD-4480
                  , :ASSIGNED-DATE-4480
                  , :PROGRAM-ID-4480
                  , :APPLIANCE-LIT-4480
                  , :RELEASE-REQD-4480
                  , :FRO-FL-4480
                  , :CRAWL-APPL-FL-4480
                  , :SERV-ORDER-NO-4480
                  , :NEW-ORDER-STATE-CD-4480
                  , :WORK-AREA-ID-4480
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1684 CURSOR
MSQ001          FOR CALL CSR01684                                             
                  ( :ORDER-TYPE-CD-1684
                  , :WORK-TYPE-1-1684
                  , :METER-STATUS-1-1684
                  , :WORK-TYPE-2-1684
                  , :METER-STATUS-2-1684
                  , :COMPANY-NO-1684
                  , :CODE-UTIL-1-1684
                  , :CODE-UTIL-2-1684
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4153 CURSOR
MSQ001          FOR CALL CSR04153                                             
                  ( :COMPANY-NO-4153
                  , :LOCAL-OFFICE-4153
                  , :ORDER-TYPE-CD-4153
                  , :ELEC-WORK-TYPE-4153
                  , :GAS-WORK-TYPE-4153
                  , :RELEASE-CD-4153
                  , :CRAWL-IND-4153
                  , :ACCOUNT-NO-4153
                  , :ELEC-IC-NO-4153
                  , :ELEC-MTR-REF-4153
                  , :GAS-IC-NO-4153
                  , :GAS-MTR-REF-4153
                  , :CALLING-SYSTEM-4153
                  , :PREMISE-NO-4153
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4154 CURSOR
MSQ001          FOR CALL CSR04154                                             
                  ( :COMPANY-NO-4154
                  , :SCENARIO-CD-4154
                  , :FRO-FL-4154
                  , :PREMISE-NO-4154
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1116 CURSOR
MSQ001          FOR CALL CSR01116                                             
                   ( :LOCAL-OFFICE-1116
                  , :CODE-UTIL-TYPE-1116
                  , :WORK-TYPE-CD-1116
                  , :CRAWL-IND-1116
                  , :METER-IND-1116
                  , :ZIP-CODE-1116
                  , :READ-ROUTE-1116
                  , :POINT-ID-1116
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4109 CURSOR
MSQ001          FOR CALL CSR04109                                             
                   ( :WORK-AREA-ID-4109
                  , :ASSIGNED-DATETIME-4109
                  , :SERV-ORDER-NO-4109
                  , :TOTAL-RES-4109
                  , :NO-DAYS-4109
                  , :SYSTEM-INITIATED-4109
                  , :WORK-TYPES-4109
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4012 CURSOR
MSQ001          FOR CALL CSR04012                                             
                  ( :COMPANY-NO-4012
                  , :REV-DISTRICT-CD-4012
                  , :CODE-UTIL-TYPE-4012
                  , :ORDER-TYPE-CD-4012
                  , :WORK-TYPE-CD-4012
                  , :RLSE-CHECK-CD-4012
                  , :ACCOUNT-NO-4012
                  , :IC-NO-4012
                  , :MTR-REF-NO-4012
                  , :METER-SUPPLYING-CD-4012
                  , :CODE-STATUS-REAS-4012
                  , :CALLING-SYSTEM-4012
                  , :WANTED-BY-DATE-4012
                  , :PREMISE-NO-4012
                  , :RLSE-TYPE-4012
                  , :RLSE-SUPPLIES-4012
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4281 CURSOR
MSQ001          FOR CALL CSR04281                                             
                  ( :CUSTOMER-NO-4281
                  , :COMPANY-NO-4281
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4849 CURSOR
MSQ001          FOR CALL CSR04849                                             
A05189             ( :ACCOUNT-NO-4849
                  , :PREMISE-NO-4849
                  , :SERV-ORDER-NO-4849
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-ORDER-TYPE-CD       PIC X(05).                          
       01  LINK-PROCESS             PIC X(10).                          
       01  LINK-ASSIGNED-DATETIME   PIC X(10).                          
       01  LINK-FUNCTION            PIC X(01).                          
       01  LINK-FRO-FL              PIC X(01).                          
       01  LINK-METER-PARMS         PIC X(800).                         
       01  LINK-NEW-CUSTOMER-NO     PIC X(10).                          
A04670 01  LINK-XFER-FL             PIC X(01).                          
A04670 01  LINK-CANCEL-REVERT-FL    PIC X(01).                          
A05189 01  LINK-APPLIANCE-LIT-FL    PIC X(01).                          
P0795E 01  LINK-CRAWL-APPL-FL       PIC X(01).                          
P0795G 01  LINK-SERV-ORDER-NO       PIC X(13).                          
P0795G 01  LINK-NEW-ORDER-STATE-CD   PIC X(01).                         
P0795G 01  LINK-WORK-AREA-ID        PIC X(12).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO,                       
                                 LINK-PREMISE-NO,                       
                                 LINK-ORDER-TYPE-CD,                    
                                 LINK-PROCESS,                          
                                 LINK-ASSIGNED-DATETIME,                
                                 LINK-FUNCTION,                         
                                 LINK-FRO-FL,                           
                                 LINK-METER-PARMS,                      
                                 LINK-NEW-CUSTOMER-NO,                  
A04670                           LINK-XFER-FL,                          
A04670                           LINK-CANCEL-REVERT-FL,                 
A05189                           LINK-APPLIANCE-LIT-FL,                 
P0795E                           LINK-CRAWL-APPL-FL,                    
P0795G                           LINK-SERV-ORDER-NO,                    
P0795G                           LINK-NEW-ORDER-STATE-CD,               
P0795G                           LINK-WORK-AREA-ID.                     
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
      * FORMAT AND SEND ORDER DATA                                              
                                                                        
           SET T3-INDEX TO 1.                                           
           IF T3-SERV-ORDER-NO (T3-INDEX) > 0                           
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM VARYING T3-INDEX FROM 1 BY 1 UNTIL               
SCA006             T3-INDEX > 25 OR 
                   T3-SERV-ORDER-NO (T3-INDEX) = ZEROES                         
                       INITIALIZE GTT-RETURN-FIELDS-3                   
                       MOVE T3-RETURN-CODE (T3-INDEX) TO S-RETURN-CODE-3
                       MOVE T3-ASSIGNED-DATE (T3-INDEX) TO              
                            S-ASSIGNED-DATE                             
                       MOVE T3-SERV-ORDER-NO (T3-INDEX) TO              
                            S-SERV-ORDER-NO-3                           
                       MOVE T3-ORDER-TYPE-CD (T3-INDEX) TO              
                            S-ORDER-TYPE-CD                             
                       MOVE T3-ORDER-STATE-CD (T3-INDEX) TO             
                            S-ORDER-STATE-CD                            
                       MOVE T3-CUSTOMER-NAME (T3-INDEX) TO              
                            S-CUSTOMER-NAME                             
                       MOVE T3-REMARKS (T3-INDEX) TO S-REMARKS          
                       MOVE T3-WORK-AREA (T3-INDEX) TO S-WORK-AREA-3    
                       MOVE T3-PHONE (T3-INDEX) TO S-PHONE              
                       MOVE T3-REMARK-TYPE (T3-INDEX) TO S-REMARK-TYPE  
P00718*                MOVE T3-BUSINESS-UNIT (T3-INDEX) TO                      
P00718*                     S-BUSINESS-UNIT-3                                   
                       PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT        
               END-PERFORM
           END-IF.                                             
                                                                        
      * FORMAT AND SEND METER DATA                                              
                                                                        
           SET T4-INDEX TO 1.                                           
           IF T4-CODE-UTIL-TYPE (T4-INDEX) > ' '                        
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT                
               PERFORM VARYING T4-INDEX FROM 1 BY 1 UNTIL               
SCA006             T4-INDEX > 100 OR 
                   T4-CODE-UTIL-TYPE (T4-INDEX) <= SPACES                       
                       INITIALIZE GTT-RETURN-FIELDS-4                   
                       MOVE T4-RETURN-CODE (T4-INDEX) TO S-RETURN-CODE-4
                       MOVE T4-CODE-UTIL-TYPE (T4-INDEX) TO             
                            S-CODE-UTIL-TYPE-4                          
                       MOVE T4-METER-NO (T4-INDEX) TO S-METER-NO-4      
                       MOVE T4-RATE-PLAN (T4-INDEX) TO S-RATE-PLAN      
                       MOVE T4-SUPPLIES (T4-INDEX) TO S-SUPPLIES        
                       MOVE T4-METER-LOC (T4-INDEX) TO S-METER-LOC      
                       MOVE T4-METER-STATUS (T4-INDEX) TO S-METER-STATUS
                       MOVE T4-METER-STATUS-REASON (T4-INDEX) TO        
                            S-METER-STATUS-REASON                       
                       MOVE T4-WORK-TYPE-CD (T4-INDEX) TO               
                            S-WORK-TYPE-CD-4                            
                       MOVE T4-METER-READ-INST (T4-INDEX) TO            
                            S-METER-READ-INST                           
                       MOVE T4-METER-IND (T4-INDEX) TO S-METER-IND      
                       MOVE T4-IC-NO (T4-INDEX) TO S-IC-NO-4            
                       MOVE T4-MTR-REF-NO (T4-INDEX) TO S-MTR-REF-NO-4  
                       MOVE T4-RLSE-REQUIRED (T4-INDEX) TO              
                            S-RLSE-REQUIRED                             
                       MOVE T4-RLSE-NO (T4-INDEX) TO S-RLSE-NO          
                       MOVE T4-RLSE-MSG (T4-INDEX) TO S-RLSE-MSG        
                       MOVE T4-RLSE-ADDL-MSG (T4-INDEX) TO              
                            S-RLSE-ADDL-MSG                             
                       MOVE T4-RLSE-PHONE (T4-INDEX) TO S-RLSE-PHONE    
                       MOVE T4-RLSE-ALT-PHONE (T4-INDEX) TO             
                            S-RLSE-ALT-PHONE                            
                       MOVE T4-RLSE-REV-DIST (T4-INDEX) TO              
                            S-RLSE-REV-DIST                             
                       MOVE T4-BUS-RULE-ID (T4-INDEX) TO                
                            S-BUS-RULE-ID-4                             
                       MOVE T4-ACTION-TYPE-CD (T4-INDEX) TO             
                            S-ACTION-TYPE-CD-4                          
                       MOVE T4-BUS-RULE-XREF-ID (T4-INDEX) TO           
                            S-BUS-RULE-XREF-ID-4                        
                       PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT        
               END-PERFORM
           END-IF.                                             
                                                                        
      * FORMAT AND SEND ORDER INSTRUCTIONS                                      
                                                                        
           SET T5-INDEX TO 1.                                           
           IF T5-SERV-ORDER-NO (T5-INDEX) > 0                           
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT                
               PERFORM VARYING T5-INDEX FROM 1 BY 1 UNTIL               
SCA006             T5-INDEX > 40 OR 
                   T5-SERV-ORDER-NO (T5-INDEX) = ZEROES                         
                       INITIALIZE GTT-RETURN-FIELDS-5                   
                       MOVE T5-RETURN-CODE (T5-INDEX) TO S-RETURN-CODE-5
                       MOVE T5-SERV-ORDER-NO (T5-INDEX) TO              
                            S-SERV-ORDER-NO-5                           
                       MOVE T5-CODE-UTIL-TYPE (T5-INDEX) TO             
                            S-CODE-UTIL-TYPE-5                          
                       MOVE T5-WORK-TYPE-CD (T5-INDEX) TO               
                            S-WORK-TYPE-CD-5                            
                       MOVE T5-IC-NO (T5-INDEX) TO S-IC-NO-5            
                       MOVE T5-METER-NO (T5-INDEX) TO S-METER-NO-5      
                       MOVE T5-MTR-REF-NO (T5-INDEX) TO S-MTR-REF-NO-5  
                       PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT        
               END-PERFORM
           END-IF.                                             
                                                                        
      * FORMAT AND SEND SPLIT DATA                                              
                                                                        
           SET T8-INDEX TO 1.                                           
           IF T8-NEW-ORDER-TYPE (T8-INDEX) > ' '                        
               PERFORM 0107-DECLARE-GTT07 THRU 0107-EXIT                
               PERFORM VARYING T8-INDEX FROM 1 BY 1 UNTIL               
SCA006             T8-INDEX > 25 OR 
                   T8-NEW-ORDER-TYPE (T8-INDEX) = SPACES                        
                       INITIALIZE GTT-RETURN-FIELDS-7                   
                       MOVE T8-RETURN-CODE (T8-INDEX) TO S-RETURN-CODE-7
                       MOVE T8-SCENARIO-SEQ (T8-INDEX) TO               
                            S-SCENARIO-SEQ-7                            
                       MOVE T8-SCENARIO-SEQ-CHOICE (T8-INDEX) TO        
                            S-SCENARIO-SEQ-CHOICE-7                     
                       MOVE T8-NEW-ORDER-TYPE (T8-INDEX) TO             
                            S-NEW-ORDER-TYPE                            
                       MOVE T8-NEW-E-WORK-TYPE (T8-INDEX) TO            
                            S-NEW-E-WORK-TYPE                           
                            L4-WORK-TYPE-CD                             
                       IF L4-WORK-TYPE-CD > ' '                         
                           PERFORM 7250-WORK-TYPE THRU 7250-EXIT        
A05189                     STRING WS-WORK-TYPES-4109 DELIMITED BY SPACE 
A05189                         L4-WORK-TYPE-CD DELIMITED BY SIZE        
A05189                         'E' DELIMITED BY SIZE                    
A05189                         ';' DELIMITED BY SIZE                    
A05189                         INTO WS-WORK-TYPES-4109                  
                       END-IF                                           
                       MOVE T8-NEW-G-WORK-TYPE (T8-INDEX) TO            
                            S-NEW-G-WORK-TYPE                           
                            L4-WORK-TYPE-CD                             
                       IF L4-WORK-TYPE-CD > ' '                         
                           PERFORM 7250-WORK-TYPE THRU 7250-EXIT        
A05189                     STRING WS-WORK-TYPES-4109 DELIMITED BY SPACE 
A05189                         L4-WORK-TYPE-CD DELIMITED BY SIZE        
A05189                         'G' DELIMITED BY SIZE                    
A05189                         ';' DELIMITED BY SIZE                    
A05189                         INTO WS-WORK-TYPES-4109                  
                       END-IF                                           
                       MOVE T8-WORK-AREA (T8-INDEX) TO S-WORK-AREA-7    
                       MOVE T8-NEW-ORDER-STATE-CD (T8-INDEX) TO         
                            S-NEW-ORDER-STATE-CD                        
A05189           IF S-WORK-AREA-7 (1:4) = 'AROP'                        
A05189           MOVE 'H' TO S-NEW-ORDER-STATE-CD                       
A05189           END-IF                                                 
P0795A                 IF (LINK-PROCESS = 'START' AND                   
P0795A                    LINK-NEW-CUSTOMER-NO > SPACES AND             
P0795A                    (LINK-NEW-CUSTOMER-NO NOT = ZEROES) AND       
P0795A                    (WS-NEW-CUST-IS-LL-FL NOT = 'Y') AND          
A05821                    (WS-CUST-BLDR-RLTR-FL NOT = 'Y') AND          
P0795A                    S-PAYMENT-REQ-FL = 'Y' AND                    
P0795A                    (S-NEW-ORDER-TYPE (1:2) = 'CC' OR 'OC') AND   
P0795A                    ((S-NEW-G-WORK-TYPE = 'UNB' OR 'SOL' OR       
P0795A                              'SOS' OR 'SOR' OR 'REC' OR 'UDP') OR
P0795A                     (S-NEW-E-WORK-TYPE = 'UNB' OR 'SOL' OR       
P0795A                              'SOS' OR 'SOR' OR 'REC' OR 'UDP'))) 
P0795A                    MOVE 'R' TO  S-NEW-ORDER-STATE-CD             
P0795A                 END-IF                                           
                       MOVE T8-DISPATCH-NOT-WQ (T8-INDEX) TO            
                            S-DISPATCH-NOT-WQ                           
                       MOVE T8-ADDL-SO-REMARKS (T8-INDEX) TO            
                            S-ADDL-SO-REMARKS                           
                       MOVE T8-SO-HOLD-COMMENTS (T8-INDEX) TO           
                            S-SO-HOLD-COMMENTS                          
                       MOVE T8-SCHED-DT-FUNC-CD (T8-INDEX) TO           
                            S-SCHED-DT-FUNC-CD                          
                       MOVE T8-MAX-DATE (T8-INDEX) TO S-MAX-DATE        
                       IF (LINK-ORDER-TYPE-CD(1:3) = 'OFF' AND          
                           (S-NEW-ORDER-TYPE(1:3) = 'OFF' OR            
                            S-NEW-ORDER-TYPE = 'FM003'))OR              
                         (LINK-PROCESS = 'AOO' AND                      
                          LINK-ORDER-TYPE-CD = 'FM003' AND              
                          S-NEW-ORDER-TYPE = 'FM003')                   
                           MOVE 'X' TO S-ORD-AUTO-SEL-CD                
                       ELSE                                             
                           MOVE T8-ORD-AUTO-SEL-CD (T8-INDEX) TO        
                                S-ORD-AUTO-SEL-CD                       
                       END-IF                                           
                       MOVE T8-AROP-READ-ONLY-FL (T8-INDEX) TO          
                                    S-AROP-READ-ONLY-FL-7               
                       MOVE T8-ARRANGEMENT-FL (T8-INDEX) TO             
                            S-ARRANGEMENT-FL-7                          
                       MOVE T8-ELEC-RLSE-FL (T8-INDEX) TO               
                            S-ELEC-RLSE-FL                              
                       MOVE T8-GAS-RLSE-FL (T8-INDEX) TO                
                            S-GAS-RLSE-FL                               
P00718                 MOVE T8-BUSINESS-UNIT (T8-INDEX) TO              
P00718                      S-BUSINESS-UNIT-7                           
P00718                 MOVE T8-WORK-DISTRICT (T8-INDEX) TO              
P00718                      S-WORK-DISTRICT-7                           
P0795C                 MOVE T8-ORDER-BUS-RULE-ID (T8-INDEX) TO          
P0795C                      S-ORDER-BUS-RULE-ID                         
P0795F                 MOVE T8-ORDER-UTILITY-CD (T8-INDEX) TO           
P0795F                      S-ORDER-UTILITY-CD                          
D12002                 MOVE T8-ELEC-RLSE-NO (T8-INDEX) TO               
D12002                      S-ELEC-RLSE-NO                              
D12002                 MOVE T8-GAS-RLSE-NO (T8-INDEX) TO                
D12002                      S-GAS-RLSE-NO                               
                       PERFORM 8700-SEND-RESULT-7 THRU 8700-EXIT        
                       PERFORM 5700-CALL-CSR04109 THRU 5700-EXIT        
               END-PERFORM
           END-IF.                                             
                                                                        
      * FORMAT AND SEND WORK GROUP CALENDAR (NO SPLIT)                          
                                                                        
           SET T7-INDEX TO 1.                                           
           IF WS-SPLIT-CALENDAR-FL = 'N' AND                            
              T7-CALENDAR-DT (T7-INDEX) > ' '                           
                  PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT             
                  PERFORM VARYING T7-INDEX FROM 1 BY 1 UNTIL            
SCA006                T7-INDEX > 200 OR 
                      T7-CALENDAR-DT (T7-INDEX) = SPACES                        
                          INITIALIZE GTT-RETURN-FIELDS-6                
                          MOVE T7-RETURN-CODE (T7-INDEX) TO             
                               S-RETURN-CODE-6                          
                          MOVE T7-CALENDAR-DT (T7-INDEX) TO             
                               S-CALENDAR-DT                            
                          MOVE T7-GOOD-DAY-FL (T7-INDEX) TO             
                               S-GOOD-DAY-FL                            
                          PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT     
                  END-PERFORM
           END-IF.                                          
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
                            S-RETURN-CODE-5                             
                            S-RETURN-CODE-6                             
                            S-RETURN-CODE-7                             
               MOVE 'NO DATA' TO S-BUS-RULE-ID                          
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT                
               PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT                
               PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT                
               PERFORM 0107-DECLARE-GTT07 THRU 0107-EXIT                
               PERFORM 8700-SEND-RESULT-7 THRU 8700-EXIT                
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
                                                                        
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT03-DECLARED                                
                       WS-GTT04-DECLARED                                
                       WS-GTT05-DECLARED                                
                       WS-GTT06-DECLARED                                
                       WS-GTT07-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04482_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04482_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ACTION_TYPE_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MESSAGE_PARMS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT1'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04482_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04482_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04482_R3
              (                                                          
               RETURN_CODE          INT,                            
               ASSIGNED_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
               SERV_ORDER_NO        DECIMAL(13,0),                      
               ORDER_TYPE_CD CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ORDER_STATE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               CUSTOMER_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2,         
               REMARKS CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2,              
               WORK_AREA CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,             
               PHONE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               REMARK_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
P00718*        BUSINESS_UNIT        CHAR(03)                                    
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT3'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04482_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0104-DECLARE-GTT04.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04482_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04482_R4
              (                                                          
               RETURN_CODE          INT,                            
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               RATE_PLAN CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,             
               SUPPLIES CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,              
               METER_LOC CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               METER_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               METER_STATUS_REASON CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               METER_READ_INST CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               METER_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               IC_NO                SMALLINT,                           
               MTR_REF_NO           SMALLINT,                           
               RLSE_REQUIRED CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,               
               RLSE_MSG CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,              
               RLSE_ADDL_MSG CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               RLSE_PHONE CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,            
               RLSE_ALT_PHONE CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,        
               RLSE_REV_DIST CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,         
               BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ACTION_TYPE_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P0795B         MESSAGE_PARMS CHAR(200)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8004-DELETE-GTT4-ROWS THRU 8004-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0104'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT4'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04482_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT04-DECLARED.                               
                                                                        
       0104-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0105-DECLARE-GTT05.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04482_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04482_R5
              (                                                          
               RETURN_CODE          INT,                            
               SERV_ORDER_NO        DECIMAL(13,0),                      
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               IC_NO                SMALLINT,                           
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               MTR_REF_NO           SMALLINT                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8005-DELETE-GTT5-ROWS THRU 8005-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0105'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT5'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04482_R5'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT05-DECLARED.                               
                                                                        
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0106-DECLARE-GTT06.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04482_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04482_R6
              (                                                          
               RETURN_CODE          INT,                            
               CALENDAR_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               GOOD_DAY_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SCENARIO_SEQ         SMALLINT,                           
               SCENARIO_SEQ_CHOICE  SMALLINT                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8006-DELETE-GTT6-ROWS THRU 8006-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0106'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT6'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04482_R6'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT06-DECLARED.                               
                                                                        
       0106-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0107-DECLARE-GTT07.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04482_R7')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04482_R7
              (                                                          
               RETURN_CODE          INT,                            
               SCENARIO_SEQ         SMALLINT,                           
               SCENARIO_SEQ_CHOICE  SMALLINT,                           
               NEW_ORDER_TYPE CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,        
               NEW_E_WORK_TYPE CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               NEW_G_WORK_TYPE CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               NEW_ORDER_STATE_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               DISPATCH_NOT_WQ CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               ADDL_SO_REMARKS CHAR(50)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               SO_HOLD_COMMENTS CHAR(25)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               SCHED_DT_FUNC_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MAX_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,              
               ORD_AUTO_SEL_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               WORK_AREA CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,             
               ARRANGEMENT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ELEC_RLSE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               GAS_RLSE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
P00718         BUSINESS_UNIT CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,         
P00718         WORK_DISTRICT CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,         
P0795C         ORDER_BUS_RULE_ID CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
P0795C         AROP_READ_ONLY CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
P0795F         ORDER_UTILITY_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
D12002         ELEC_RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
D12002         GAS_RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8007-DELETE-GTT7-ROWS THRU 8007-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0107'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT7'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04482_R7'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT07-DECLARED.                               
                                                                        
       0107-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO TO WS-ACCOUNT-NO.                       
           MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO.                     
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           MOVE LINK-PREMISE-NO TO WS-PREMISE-NO.                       
           MOVE WS-PREMISE-NO-NUM TO AT-PREMISE-NO                      
                                     PR-PREMISE-NO                      
                                     LA-PREMISE-NO.                     
                                                                        
           MOVE LINK-METER-PARMS TO WS-METER-PARM.                      
           MOVE WS-METER-PARM-TEXT TO T10-METER-LINE.                   
           IF LINK-NEW-CUSTOMER-NO NOT NUMERIC                          
               MOVE ZEROES TO LINK-NEW-CUSTOMER-NO
           END-IF.                     
           MOVE LINK-NEW-CUSTOMER-NO TO WS-NEW-CUSTOMER-NO.             
A04670     IF LINK-CANCEL-REVERT-FL NOT = 'Y'                           
A04670         MOVE 'N' TO LINK-CANCEL-REVERT-FL
           END-IF.                       
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-PROCESS = 'START'                                    
               MOVE 'SOINIT0002' TO 1T-BUS-PROCESS-ID
           END-IF.                  
           IF LINK-PROCESS = 'STOP'                                     
               MOVE 'SOINIT0001' TO 1T-BUS-PROCESS-ID
           END-IF.                  
           IF LINK-PROCESS = 'AOO'                                      
               MOVE 'SOINIT0005' TO 1T-BUS-PROCESS-ID
           END-IF.                  
           IF LINK-PROCESS = 'MAINTAIN'                                 
               MOVE 'SOINIT0006' TO 1T-BUS-PROCESS-ID
           END-IF.                  
                                                                        
           IF LINK-ORDER-TYPE-CD = SPACES OR                            
              LINK-PROCESS = SPACES OR                                  
              LINK-ASSIGNED-DATETIME = SPACES OR                        
              LINK-FUNCTION = SPACES OR                                 
             (LINK-ACCOUNT-NO = ZEROES AND                              
              LINK-PREMISE-NO = ZEROES)                                 
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                               S-RETURN-CODE-2                          
                               S-RETURN-CODE-3                          
                               S-RETURN-CODE-4                          
                               S-RETURN-CODE-5                          
                               S-RETURN-CODE-6                          
                               S-RETURN-CODE-7                          
                  MOVE 'PARMS ZERO' TO S-BUS-RULE-ID                    
                  ADD +1 TO CTR-ROWS                                    
                  PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT             
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
                  PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT             
                  PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT             
                  PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT             
                  PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT             
                  PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT             
                  PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT             
                  PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT             
                  PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT             
                  PERFORM 0107-DECLARE-GTT07 THRU 0107-EXIT             
                  PERFORM 8700-SEND-RESULT-7 THRU 8700-EXIT             
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT               
               PERFORM 7300-GET-READ-ROUTE THRU 7300-EXIT               
               PERFORM 7400-GET-POINT-ID THRU 7400-EXIT                 
               PERFORM 7060-LANDLORD THRU 7060-EXIT                     
               PERFORM 7510-BUILDER-REALTOR THRU 7510-EXIT              
               MOVE AT-CUSTOMER-NO TO WS-CUSTOMER-NO-NUM                
               MOVE AT-PREMISE-NO TO WS-PREMISE-NO-NUM                  
               MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO                  
                                         LA-PREMISE-NO                  
           ELSE                                                         
               PERFORM 7500-GET-PREM-LOCOFF THRU 7500-EXIT              
P00795         MOVE PR-COMPANY-NO TO AT-COMPANY-NO
           END-IF.                     
                                                                        
           PERFORM 7010-SELECT-DELINQ THRU 7010-EXIT                    
           PERFORM 7200-GET-ZIP THRU 7200-EXIT.                         
           IF B1-SERV-ORDER-WORK-CD = 'METRO' OR 'DISTC'                
               MOVE 'Y' TO WS-CRAWL-LOCAL-OFFICE
           END-IF.                       
           IF B1-SERV-ORDER-WORK-CD = 'METRO' OR 'DISTC' OR 'DISTR'     
               MOVE 'Y' TO WS-HEAT-LOCOFF-FL
           END-IF.                           
                                                                        
      * FUNCTION A = DATE CHANGE VALIDATION                                     
      *              DOES NOT USE INPUT METER PARM DATA                         
      *              SEASONAL REVERT PROCESSING                                 
      *              CALL CSR04479 FOR EXISTING ORDERS, METERS, AND             
      *                            INPUT DATA TO CSR04480                       
      *              CALL CSR04012 FOR RELEASE REQUIREMENTS                     
      *              CALL CSR04480 FOR WORK GROUP CALENDAR AND                  
      *                                WORK TYPES                               
                                                                        
      * DATE CHANGE VALIDATION CALLED FROM UI WHEN                              
      *    1. ORDERS EXIST FOR THE PREMISE                                      
      *    2. THE DATE IS OUTSIDE OF THE ORIGINAL 60 DAY WINDOW                 
      *    3. THE PREMISE IS DEFINED AS A SEASONAL REVERT                       
                                                                        
           IF LINK-FUNCTION = 'A'                                       
A04670         IF (LINK-CANCEL-REVERT-FL = 'N' AND                      
A04670             PR-CODE-RENTAL-PROP = 'S' AND                        
A04670             LINK-PROCESS = 'STOP')                               
A04670                IF (LINK-ASSIGNED-DATETIME(6:2) > '04' AND        
A04670                    LINK-ASSIGNED-DATETIME(6:2) < '10')           
A04670                       MOVE 'STOP' TO LINK-PROCESS                
A04670                       PERFORM 7700-COUNT-PENDING-OFF THRU        
A04670                               7700-EXIT                          
A04670                       IF S-RECALC-ORDER-TYPE-CD =                
A04670                          LINK-ORDER-TYPE-CD                      
A04670                             MOVE SPACES TO S-RECALC-ORDER-TYPE-CD
A04670                       ELSE                                       
A04670                           MOVE S-RECALC-ORDER-TYPE-CD TO         
A04670                                LINK-ORDER-TYPE-CD                
A04670                       END-IF                                     
A04670                END-IF                                            
A04670                IF (LINK-ASSIGNED-DATETIME(6:2) >= '10' OR        
A04670                    LINK-ASSIGNED-DATETIME(6:2) <= '04') AND      
A04670                    WS-NEW-CUST-IS-LL-FL NOT = 'Y'                
A04670                       MOVE 'START' TO LINK-PROCESS               
A04670                       PERFORM 7750-COUNT-PENDING-CC THRU         
A04670                               7750-EXIT                          
A04670                       IF S-RECALC-ORDER-TYPE-CD =                
A04670                          LINK-ORDER-TYPE-CD                      
A04670                             MOVE SPACES TO S-RECALC-ORDER-TYPE-CD
A04670                       ELSE                                       
A04670                           MOVE S-RECALC-ORDER-TYPE-CD TO         
A04670                                LINK-ORDER-TYPE-CD                
A04670                       END-IF                                     
A04670                END-IF                                            
A04670         END-IF                                                   
               PERFORM 5200-CALL-CSR04479 THRU 5200-EXIT                
               MOVE WS-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-4480            
               MOVE WS-WORK-TYPE TO WORK-TYPE-4480                      
               MOVE WS-METER-IND TO METER-IND-4480                      
               MOVE WS-METER-STATUS TO METER-STATUS-4480                
               PERFORM 5300-CALL-CSR04480 THRU 5300-EXIT                
           ELSE                                                         
               PERFORM 2100-NOT-FUNCTION-A THRU 2100-EXIT
           END-IF.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-NOT-FUNCTION-A.                                             
                                                                        
      * SET APPLIANCE FLAGS                                                     
      * FUNCTION E IS APPLIANCE VALIDATION ONLY                                 
                                                                        
           PERFORM 7600-OPEN-APPL-CURSOR THRU 7600-EXIT.                
           PERFORM 2110-FETCH-ROWS THRU 2110-EXIT.                      
           PERFORM 7610-CLOSE-APPL-CURSOR THRU 7610-EXIT.               
                                                                        
      * LOAD INPUT PARMS INTO WORKING STORAGE                                   
                                                                        
           INITIALIZE WS-BUILD-INPUT-PARMS.                             
           MOVE +1 TO WS-SUB1.                                          
           SET T4-INDEX TO 1.                                           
           PERFORM VARYING T10-INDEX FROM 1 BY 1 UNTIL                  
               T10-INDEX > 50 OR                                        
               T10-CODE-UTIL-TYPE (T10-INDEX) <= ' '                    
                   IF T10-USER-CHG-TYPE (T10-INDEX) = 'Y'               
                       MOVE 'Y' TO WS-CHG-WK-TYPE-FL                    
                   END-IF                                               
                   IF T10-RLSE-CD (T10-INDEX) = 'Y'                     
                       MOVE 'Y' TO WS-RLSE-FL                           
                                   WS-RLSE-REQD-4480                    
                   END-IF                                               
D25931             MOVE T10-RLSE-CD (T10-INDEX) TO                      
D25931                  WS-RLSE-REQD-SUB (WS-SUB1)                      
                   MOVE T10-METER-NO (T10-INDEX) TO                     
                        WS-METER-NO-SUB (WS-SUB1)                       
P00795                  T4-METER-NO (T4-INDEX)                          
                   MOVE T10-CODE-UTIL-TYPE (T10-INDEX) TO               
                        WS-CODE-UTIL-TYPE-SUB (WS-SUB1)                 
P00795                  T4-CODE-UTIL-TYPE (T4-INDEX)                    
                   MOVE T10-USER-CHG-TYPE (T10-INDEX) TO                
                        WS-USER-CHG-WK-TYPE-SUB (WS-SUB1)               
                   MOVE T10-METER-IND (T10-INDEX) TO                    
                        WS-METER-IND-SUB (WS-SUB1)                      
P00795                  T4-METER-IND (T4-INDEX)                         
                   MOVE T10-METER-STATUS (T10-INDEX) TO                 
                        WS-METER-STATUS-SUB (WS-SUB1)                   
P00795                  T4-METER-STATUS (T4-INDEX)                      
                   MOVE T10-IC-NO (T10-INDEX) TO                        
                        WS-IC-NO-SUB (WS-SUB1)                          
P00795                  T4-IC-NO (T4-INDEX)                             
                   MOVE T10-MTR-REF (T10-INDEX) TO                      
                        WS-MTR-REF-SUB (WS-SUB1)                        
P00795                  T4-MTR-REF-NO (T4-INDEX)                        
                   MOVE T10-WORK-TYPE (T10-INDEX) TO                    
                        WS-WORK-TYPE-SUB (WS-SUB1)                      
P00795                  T4-WORK-TYPE-CD (T4-INDEX)                      
P00795             MOVE T10-SUPPLYING (T10-INDEX) TO                    
P00795                  WS-SUPPLYING-SUB (WS-SUB1)                      
P00795                  T4-SUPPLIES (T4-INDEX)                          
                   ADD +1 TO WS-SUB1                                    
                   SET T4-INDEX UP BY 1                                 
           END-PERFORM.                                                 
                                                                        
      * USES INPUT METER PARM DATA                                              
                                                                        
           MOVE WS-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-4480.               
           MOVE WS-WORK-TYPE TO WORK-TYPE-4480.                         
           MOVE WS-METER-IND TO METER-IND-4480.                         
           MOVE WS-METER-STATUS TO METER-STATUS-4480.                   
                                                                        
      * PROCESS INPUT METER DATA; COUNT METERS; SET FLAGS                       
      * PAYMENT REQUIRED ROUTINE                                                
                                                                        
           PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
               WS-WORK-TYPE-SUB (WS-SUB1) <= SPACES AND                 
               WS-CODE-UTIL-TYPE-SUB (WS-SUB1) <= SPACES                
                   ADD +1 TO WS-PARM-METER-COUNT                        
                   IF WS-CODE-UTIL-TYPE-SUB (WS-SUB1) = 'E' AND         
                      WS-WORK-TYPE-SUB (WS-SUB1) > SPACES               
                       ADD +1 TO WS-ELEC-METER-COUNT                    
                       IF WS-1ST-ELEC = 0                               
                           MOVE WS-SUB1 TO WS-1ST-ELEC                  
                       END-IF                                           
                       MOVE 'Y' TO WS-ELEC-IC-FL                        
                       IF WS-WORK-TYPE-SUB (WS-SUB1) = ('UNB' OR        
                             'SOL' OR 'SOR' OR 'SOS' OR 'REC' OR 'UDP') 
                           MOVE 'Y' TO WS-ELEC-UNBLOCK-FL               
                       END-IF                                           
                   END-IF                                               
                   IF WS-CODE-UTIL-TYPE-SUB (WS-SUB1) = 'G' AND         
                      WS-WORK-TYPE-SUB (WS-SUB1) > SPACES               
                       ADD +1 TO WS-GAS-METER-COUNT                     
                       IF WS-1ST-GAS = 0                                
                           MOVE WS-SUB1 TO WS-1ST-GAS                   
                       END-IF                                           
                       IF WS-WORK-TYPE-SUB (WS-SUB1) = ('UNB' OR        
                             'SOL' OR 'SOR' OR 'SOS' OR 'REC' OR 'UDP') 
                           MOVE 'Y' TO WS-GAS-UNBLOCK-FL                
                       END-IF                                           
                       IF WS-WORK-TYPE-SUB (WS-SUB1) = 'UNB' OR         
                                                       'UDP'            
                           MOVE 'Y' TO WS-HEAT-WK-TYPE-FL               
                       END-IF                                           
                       IF WS-WORK-TYPE-SUB (WS-SUB1) = 'SOL' OR         
                             'SOS' OR 'UNB' OR 'UDP' OR 'ST2'           
                           MOVE 'Y' TO WS-APPL-MSG-1-FL                 
                       END-IF                                           
                       IF WS-WORK-TYPE-SUB (WS-SUB1) = 'ARA' OR         
                             'COA' OR 'LTP'                             
                           MOVE 'Y' TO WS-APPL-MSG-2-FL                 
                       END-IF                                           
                       IF LINK-ORDER-TYPE-CD = 'FM008' AND              
                         (WS-WORK-TYPE-SUB (WS-SUB1) = 'MSC' OR         
                                                       'MS1')           
                           MOVE 'Y' TO WS-APPL-MSG-2-FL                 
                       END-IF                                           
                       IF WS-WORK-TYPE-SUB (WS-SUB1) = 'MTC' OR         
                                                       'ICX'            
                           MOVE 'Y' TO WS-APPL-MSG-3-FL                 
                       END-IF                                           
                       IF WS-WORK-TYPE-SUB (WS-SUB1) = 'COC'            
                           MOVE 'Y' TO WS-APPL-MSG-4-FL                 
                       END-IF                                           
                       IF WS-WORK-TYPE-SUB (WS-SUB1) = 'BLK' OR         
                             'HOF' OR 'SOR' OR 'REC' OR 'RMM' OR        
                             'RS2' OR 'VRB'                             
                           MOVE 'Y' TO WS-APPL-MSG-5-FL                 
                       END-IF                                           
                   END-IF                                               
                   IF (WS-WORK-TYPE-SUB (WS-SUB1) = 'UNB' OR 'SOL' OR   
                                         'SOS' OR 'SOR' OR              
                                         'REC' OR 'UDP') AND            
                      S-PAYMENT-REQ-FL = 'N' AND                        
                      LINK-NEW-CUSTOMER-NO > SPACES AND                 
                     (LINK-NEW-CUSTOMER-NO NOT = ZEROES) AND            
                      LINK-PROCESS = 'START' AND                        
                    (WS-CHG-WK-TYPE-FL = 'Y' OR LINK-FUNCTION = 'D') AND
A04670                WS-PR-EXECUTED-FL = 'N' AND                       
                     (LINK-FUNCTION NOT = 'E') AND                      
                     (WS-NEW-CUST-IS-LL-FL NOT = 'Y') AND               
A05821               (WS-CUST-BLDR-RLTR-FL NOT = 'Y') AND               
A04670               (LINK-XFER-FL NOT = 'Y')                           
                          PERFORM 5900-CALL-CSR04281 THRU 5900-EXIT     
A04670                    MOVE 'Y' TO WS-PR-EXECUTED-FL                 
A04670                    IF WS-TOTAL-DUE > WS-THRESHOLD                
                              MOVE 'Y' TO S-PAYMENT-REQ-FL              
                          END-IF                                        
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
      * BREAKERS OFF MESSAGE                                                    
                                                                        
           IF WS-ELEC-UNBLOCK-FL = 'Y' AND                              
              WS-CHG-WK-TYPE-FL = 'Y' AND                               
              LINK-FUNCTION NOT = 'E' AND                               
DT6878        CSR-DATABASE                                              
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDRCF0008' TO S-BUS-RULE-ID                    
                  MOVE 'ORDER' TO S-ACTION-TYPE-CD                      
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
                                                                        
      * WATER ON MESSAGE                                                        
      * BREAKERS OFF MESSAGE                                                    
                                                                        
           IF WS-GAS-UNBLOCK-FL = 'Y' AND                               
              WS-CHG-WK-TYPE-FL = 'Y' AND                               
              LINK-FUNCTION NOT = 'E' AND                               
DT6878        CSR-DATABASE                                              
                  IF WS-ELEC-IC-FL = 'Y'                                
                      INITIALIZE GTT-RETURN-FIELDS-1                    
                      MOVE 0 TO S-RETURN-CODE-1                         
                      MOVE 'ORDRCF0014' TO S-BUS-RULE-ID                
                      MOVE 'ORDER' TO S-ACTION-TYPE-CD                  
                      PERFORM 7013-RULE-XREF THRU 7013-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT         
                  ELSE                                                  
                      INITIALIZE GTT-RETURN-FIELDS-1                    
                      MOVE 0 TO S-RETURN-CODE-1                         
                      MOVE 'ORDRCF0009' TO S-BUS-RULE-ID                
                      MOVE 'ORDER' TO S-ACTION-TYPE-CD                  
                      PERFORM 7013-RULE-XREF THRU 7013-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
                  END-IF
           END-IF.        
                                                                        
      * FORMAT APPLIANCE MESSAGES                                               
                                                                        
           PERFORM 2130-APPLIANCE-MESSAGES THRU 2130-EXIT.              
                                                                        
      * WORK TYPE VALIDATION; PERFORMED IF USER HAS CHANGED WORK TYPE           
      * CHECK IF RELEASE IS REQUIRED FOR NEW WORK TYPE                          
                                                                        
           IF (LINK-FUNCTION = 'B' OR 'C') AND                          
DT6878         WS-CHG-WK-TYPE-FL = 'Y'  AND CSR-DATABASE                
                   MOVE 'N' TO WS-RLSE-REQD-4480                        
                   MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-1684        
                   MOVE AT-COMPANY-NO TO COMPANY-NO-1684                
                   SET T4-INDEX TO 1                                    
                   PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL            
                                   WS-SUB1 > WS-PARM-METER-COUNT        
                       IF WS-USER-CHG-WK-TYPE-SUB (WS-SUB1) = 'Y'       
                           PERFORM 2120-VALIDATE-WORK-TYPE THRU         
                                   2120-EXIT                            
                                                                        
                           PERFORM 2140-RELEASE-PROCESSING THRU         
                                   2140-EXIT                            
                                                                        
                           IF (RLSE-REQUIRED-FL-4012 = 'Y' OR 'E') AND  
                               RLSE-EXISTS-4012 NOT = 'Y'               
                                 MOVE 'Y' TO WS-RLSE-REQD-4480          
                           END-IF                                       
                           SET T4-INDEX UP BY 1                         
                       END-IF                                           
                   END-PERFORM                                          
                   IF S-BAD-ELEC-WK-TYPE = 'Y' OR                       
                      S-BAD-GAS-WK-TYPE = 'Y'                           
                          INITIALIZE GTT-RETURN-FIELDS-1                
                          MOVE 0 TO S-RETURN-CODE-1                     
                          MOVE 'ORDR000001' TO S-BUS-RULE-ID            
                          MOVE 'F' TO S-ACTION-TYPE-CD                  
                          PERFORM 7013-RULE-XREF THRU 7013-EXIT         
                          EVALUATE S-BAD-ELEC-WK-TYPE ALSO              
                                   S-BAD-GAS-WK-TYPE                    
                              WHEN 'Y' ALSO 'Y'                         
                                  MOVE 'ELECTRIC AND GAS' TO            
                                       S-MESSAGE-PARMS                  
                              WHEN 'Y' ALSO 'N'                         
                                  MOVE 'ELECTRIC' TO S-MESSAGE-PARMS    
                              WHEN 'N' ALSO 'Y'                         
                                  MOVE 'GAS' TO S-MESSAGE-PARMS         
                          END-EVALUATE                                  
                          IF WS-GTT01-DECLARED = 'N'                    
                              PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT 
                          END-IF                                        
                          PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
                   END-IF
           END-IF.    
                                                                        
      * WORK GROUP CALENDAR                                                     
      * A WORK TYPE CHANGE COULD CHANGE RES AND MAKE DATE UNAVAILABLE           
                                                                        
           IF LINK-FUNCTION = 'B' OR 'C' OR 'D'                         
               PERFORM 5300-CALL-CSR04480 THRU 5300-EXIT
           END-IF.               
                                                                        
      * SPLITS PROCESSING                                                       
                                                                        
           IF (LINK-FUNCTION = 'B' OR 'D') AND                          
               WS-ELEC-METER-COUNT <= 1 AND                             
               WS-GAS-METER-COUNT <= 1                                  
                   PERFORM 5500-CALL-CSR04153 THRU 5500-EXIT            
                   IF ERROR-MSG-4153 = 'SP001'                          
                       INITIALIZE GTT-RETURN-FIELDS-1                   
                       MOVE 0 TO S-RETURN-CODE-1                        
                       MOVE 'ORDR000011' TO S-BUS-RULE-ID               
                       MOVE 'F' TO S-ACTION-TYPE-CD                     
                       PERFORM 7013-RULE-XREF THRU 7013-EXIT            
                       IF WS-GTT01-DECLARED = 'N'                       
                           PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT    
                       END-IF                                           
                       PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT        
                   END-IF                                               
                   IF TOU-ERROR-MSG-4153 = 'SP012'                      
                       INITIALIZE GTT-RETURN-FIELDS-1                   
                       MOVE 0 TO S-RETURN-CODE-1                        
                       MOVE 'ORDR000013' TO S-BUS-RULE-ID               
                       MOVE 'F' TO S-ACTION-TYPE-CD                     
                       PERFORM 7013-RULE-XREF THRU 7013-EXIT            
                       IF WS-GTT01-DECLARED = 'N'                       
                           PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT    
                       END-IF                                           
                       PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT        
                   END-IF                                               
                   IF SPLIT-CD-4153 = 'Y'                               
                       PERFORM 5600-CALL-CSR04154 THRU 5600-EXIT        
                   END-IF                                               
                   IF WS-GAS-ARRANGE-FL = 'Y' AND                       
                      WS-ELEC-ORDER-FL     = 'Y'                        
                          INITIALIZE GTT-RETURN-FIELDS-1                
                          MOVE 0 TO S-RETURN-CODE-1                     
                          MOVE 'ORDR000012' TO S-BUS-RULE-ID            
                          MOVE 'F' TO S-ACTION-TYPE-CD                  
                          PERFORM 7013-RULE-XREF THRU 7013-EXIT         
                          IF WS-GTT01-DECLARED = 'N'                    
                              PERFORM 0101-DECLARE-GTT01 THRU           
                                      0101-EXIT                         
                          END-IF                                        
                          PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
                   END-IF
           END-IF.    
                                                                        
A04670     IF LINK-FUNCTION = 'E'                                       
A04670         MOVE +100 TO S-RETURN-CODE-2
           END-IF.                            
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH APPL-CURSOR                                        
                INTO :JA-SEASONAL-RT-FL,                                
                     :JA-CRAWL-FL                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2110-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE 'Y' TO WS-APPLIANCE-FL.                                 
           IF JA-CRAWL-FL = 'Y'                                         
               MOVE 'Y' TO WS-CRAWL-FL
           END-IF.                                 
           IF JA-SEASONAL-RT-FL = 'Y'                                   
               MOVE 'Y' TO WS-HEATING-APPL-FL
           END-IF.                          
                                                                        
           GO TO 2110-FETCH-ROWS.                                       
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2120-VALIDATE-WORK-TYPE.                                         
                                                                        
           MOVE WS-WORK-TYPE-SUB (WS-SUB1) TO WORK-TYPE-1-1684.         
           MOVE WS-CODE-UTIL-TYPE-SUB (WS-SUB1) TO CODE-UTIL-1-1684.    
           MOVE WS-METER-STATUS-SUB (WS-SUB1) TO                        
                METER-STATUS-1-1684.                                    
           MOVE SPACES TO WORK-TYPE-2-1684                              
                          CODE-UTIL-2-1684                              
                          METER-STATUS-2-1684.                          
           PERFORM 5400-CALL-CSR01684 THRU 5400-EXIT.                   
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2130-APPLIANCE-MESSAGES.                                         
                                                                        
           MOVE 'N' TO WS-APPL-MSG-FL.                                  
           IF WS-APPLIANCE-FL = 'Y'                                     
               IF WS-APPL-MSG-1-FL = 'Y'                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 'Y' TO WS-APPL-MSG-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDR000016' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
               END-IF                                                   
               IF WS-APPL-MSG-2-FL = 'Y'                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 'Y' TO WS-APPL-MSG-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDR000018' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
               END-IF                                                   
           ELSE                                                         
               IF WS-APPL-MSG-1-FL = 'Y'                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 'Y' TO WS-APPL-MSG-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDR000017' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
               END-IF                                                   
               IF WS-APPL-MSG-2-FL = 'Y'                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 'Y' TO WS-APPL-MSG-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDR000019' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
               END-IF                                                   
               IF WS-APPL-MSG-4-FL = 'Y'                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 'Y' TO WS-APPL-MSG-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDR000020' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
               END-IF
           END-IF.            
           IF WS-APPL-MSG-3-FL = 'Y'                                    
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 'Y' TO WS-APPL-MSG-FL                                
              MOVE 0 TO S-RETURN-CODE-1                                 
              MOVE 'ORDR000026' TO S-BUS-RULE-ID                        
              MOVE 'P' TO S-ACTION-TYPE-CD                              
              PERFORM 7013-RULE-XREF THRU 7013-EXIT                     
              IF WS-GTT01-DECLARED = 'N'                                
                  PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT             
              END-IF                                                    
              PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.                
           IF WS-APPL-MSG-5-FL = 'Y' AND                                
              WS-APPL-MSG-FL = 'N'                                      
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 'Y' TO WS-APPL-MSG-FL                            
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDR000021' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
MAINTN*    IF WS-HEATING-APPL-FL = 'N' AND                                      
MAINTN*       AT-COMPANY-NO = '01' AND                                          
MAINTN*       WS-APPLIANCE-FL = 'Y' AND                                         
MAINTN*       CSR-DATABASE AND                                                  
MAINTN*       WS-HEAT-WK-AREA-FL = 'N' AND                                      
MAINTN*       WS-HEAT-LOCOFF-FL = 'Y' AND                                       
MAINTN*       WS-HEAT-WK-TYPE-FL = 'Y'                                          
MAINTN*           INITIALIZE GTT-RETURN-FIELDS-1                                
MAINTN*           MOVE 'Y' TO WS-APPL-MSG-FL                                    
MAINTN*           MOVE 0 TO S-RETURN-CODE-1                                     
MAINTN*           MOVE 'ORDR000022' TO S-BUS-RULE-ID                            
MAINTN*           MOVE 'F' TO S-ACTION-TYPE-CD                                  
MAINTN*           PERFORM 7013-RULE-XREF THRU 7013-EXIT                         
MAINTN*           IF WS-GTT01-DECLARED = 'N'                                    
MAINTN*               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                 
MAINTN*           END-IF                                                        
MAINTN*           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                    
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2140-RELEASE-PROCESSING.                                         
                                                                        
           MOVE LINK-ORDER-TYPE-CD TO L3-ORDER-TYPE-CD.                 
           MOVE WS-WORK-TYPE-SUB (WS-SUB1) TO L3-WORK-TYPE-CD.          
           PERFORM 7050-RELEASE-RQMT THRU 7050-EXIT.                    
           IF L3-RLSE-CHECK-CD = 'C'                                    
               MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-4012            
               MOVE 'N' TO WS-SPLIT-RLSE-FL                             
P0795D         IF LINK-ORDER-TYPE-CD NOT = 'FM002'                      
                  PERFORM 5800-CALL-CSR04012 THRU 5800-EXIT             
P0795D         ELSE                                                     
P0795D            PERFORM 7772-REV-DIST-RLSE THRU 7772-EXIT             
P0795D            IF A9-RLSE-REQUIRED-IND = 'Y'                         
P0795D               PERFORM 5800-CALL-CSR04012 THRU 5800-EXIT          
P0795D            END-IF                                                
P0795D         END-IF                                                   
P0795D     END-IF.                                                      
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-CALL-CSR04479.                                              
                                                                        
           INITIALIZE WS-BUILD-INPUT-PARMS.                             
           MOVE WS-ACCOUNT-NO TO ACCOUNT-NO-4479.                       
           MOVE WS-PREMISE-NO TO PREMISE-NO-4479.                       
P00795     MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-4479.               
           IF LINK-ORDER-TYPE-CD(1:2) = 'CC' AND                        
              LINK-PROCESS = 'STOP'                                     
                  MOVE 'START' TO PROCESS-4479                          
           ELSE                                                         
               MOVE LINK-PROCESS TO PROCESS-4479
           END-IF.                       
           MOVE LINK-ASSIGNED-DATETIME TO ASSIGNED-DATE-IN-4479.        
           MOVE PROGRAM-NAME TO PROGRAM-ID-4479.                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-4479.               
           MOVE 'C' TO CURRENT-HISTORY-FL-4479.                         
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04479                                             
      *           (:ACCOUNT-NO-4479,                                    
      *            :PREMISE-NO-4479,                                    
      *            :PROCESS-4479,                                       
      *            :ASSIGNED-DATE-IN-4479,                              
      *            :PROGRAM-ID-4479,                                    
P00795*            :ORDER-TYPE-CD-4479,                                 
MAINTN*            :SERV-ORDER-NO-4479,                                 
MAINTN*            :CURRENT-HISTORY-FL-4479)                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_CUR_1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_CUR_1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04479'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4479A, :LOC4479B, :LOC4479C, :LOC4479D, :LOC4479E)   
      *       WITH PROCEDURE CSR04479                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479A CURSOR FOR RESULT SET       
      *       :LOC4479A                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479B CURSOR FOR RESULT SET       
      *       :LOC4479B                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479C CURSOR FOR RESULT SET       
      *       :LOC4479C                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479D CURSOR FOR RESULT SET       
      *       :LOC4479D                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479E CURSOR FOR RESULT SET       
      *       :LOC4479E                                                 
      *    END-EXEC.                                                    
                                                                        
           SET T3-INDEX TO 1.                                           
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4479-A,                                 
                   :ASSIGNED-DATE-OUT-4479,                             
                   :SERV-ORDER-NO-4479-A,                               
                   :OUT-ORDER-TYPE-CD-4479,                             
                   :ORDER-STATE-CD-4479,                                
                   :CUSTOMER-NAME-4479,                                 
                   :REMARKS-4479,                                       
                   :WORK-AREA-4479,                                     
                   :PHONE-4479,                                         
                   :REMARK-TYPE-4479                                    
P00718*            :BUSINESS-UNIT-4479                                          
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479A INTO                                 
MFA-TR*            :RETURN-CODE-4479-A,                                         
MFA-TR*            :ASSIGNED-DATE-OUT-4479,                                     
MFA-TR*            :SERV-ORDER-NO-4479-A,                                       
MFA-TR*            :OUT-ORDER-TYPE-CD-4479,                                     
MFA-TR*            :ORDER-STATE-CD-4479,                                        
MFA-TR*            :CUSTOMER-NAME-4479,                                         
MFA-TR*            :REMARKS-4479,                                               
MFA-TR*            :WORK-AREA-4479,                                             
MFA-TR*            :PHONE-4479,                                                 
MFA-TR*            :REMARK-TYPE-4479                                            
MFA-TR*            :BUSINESS-UNIT-4479                                          
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                 WHEN +354                                              
                    IF RETURN-CODE-4479-A NOT = 0 AND                   
                       RETURN-CODE-4479-A NOT = +100 AND                
                       RETURN-CODE-4479-A NOT = +354                    
                         MOVE RETURN-CODE-4479-A TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479A'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-A = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5210-PROCESS-4479A THRU 5210-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479A'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           SET T4-INDEX TO 1.                                           
           MOVE +1 TO WS-SUB1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4479-B,                                 
                   :CODE-UTIL-TYPE-4479-B,                              
                   :METER-NO-4479-B,                                    
                   :RATE-PLAN-4479-B,                                   
                   :SUPPLIES-4479,                                      
                   :METER-LOC-4479,                                     
                   :METER-STATUS-4479,                                  
                   :METER-STATUS-REASON-4479,                           
                   :WORK-TYPE-CD-4479-B,                                
                   :METER-READ-INST-4479,                               
                   :METER-IND-4479,                                     
                   :IC-NO-4479-B,                                       
                   :MTR-REF-NO-4479-B,                                  
                   :GAS-MTRS-COUNT-4479,                                
                   :ELEC-MTRS-COUNT-4479                                
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479B INTO                                 
MFA-TR*            :RETURN-CODE-4479-B,                                         
MFA-TR*            :CODE-UTIL-TYPE-4479-B,                                      
MFA-TR*            :METER-NO-4479-B,                                            
MFA-TR*            :RATE-PLAN-4479-B,                                           
MFA-TR*            :SUPPLIES-4479,                                              
MFA-TR*            :METER-LOC-4479,                                             
MFA-TR*            :METER-STATUS-4479,                                          
MFA-TR*            :METER-STATUS-REASON-4479,                                   
MFA-TR*            :WORK-TYPE-CD-4479-B,                                        
MFA-TR*            :METER-READ-INST-4479,                                       
MFA-TR*            :METER-IND-4479,                                             
MFA-TR*            :IC-NO-4479-B,                                               
MFA-TR*            :MTR-REF-NO-4479-B,                                          
MFA-TR*            :GAS-MTRS-COUNT-4479,                                        
MFA-TR*            :ELEC-MTRS-COUNT-4479                                        
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                 WHEN +354                                              
                    IF RETURN-CODE-4479-B NOT = 0 AND                   
                       RETURN-CODE-4479-B NOT = +100 AND                
                       RETURN-CODE-4479-A NOT = +354                    
                         MOVE RETURN-CODE-4479-B TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479B'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-B = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5220-PROCESS-4479B THRU 5220-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479B'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           SET T5-INDEX TO 1.                                           
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4479-C,                                 
                   :SERV-ORDER-NO-4479-C,                               
                   :CODE-UTIL-TYPE-4479-C,                              
                   :WORK-TYPE-CD-4479-C,                                
                   :IC-NO-4479-C,                                       
                   :METER-NO-4479-C,                                    
                   :MTR-REF-NO-4479-C                                   
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479C INTO                                 
MFA-TR*            :RETURN-CODE-4479-C,                                         
MFA-TR*            :SERV-ORDER-NO-4479-C,                                       
MFA-TR*            :CODE-UTIL-TYPE-4479-C,                                      
MFA-TR*            :WORK-TYPE-CD-4479-C,                                        
MFA-TR*            :IC-NO-4479-C,                                               
MFA-TR*            :METER-NO-4479-C,                                            
MFA-TR*            :MTR-REF-NO-4479-C                                           
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                 WHEN +354                                              
                    IF RETURN-CODE-4479-C NOT = 0 AND                   
                       RETURN-CODE-4479-C NOT = +100 AND                
                       RETURN-CODE-4479-C NOT = +354                    
                         MOVE RETURN-CODE-4479-C TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479C'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-C = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5230-PROCESS-4479C THRU 5230-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479C'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           SET T9-INDEX TO 1.                                           
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4479-D,                                 
                   :RATE-PLAN-4479-D,                                   
                   :RATE-ITEM-CODE-4479,                                
                   :CODE-PLAN-STATUS-4479,                              
                   :CODE-STATUS-REASON-4479,                            
                   :MONTHLY-AMOUNT-4479,                                
                   :NO-UNITS-4479                                       
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479D INTO                                 
MFA-TR*            :RETURN-CODE-4479-D,                                         
MFA-TR*            :RATE-PLAN-4479-D,                                           
MFA-TR*            :RATE-ITEM-CODE-4479,                                        
MFA-TR*            :CODE-PLAN-STATUS-4479,                                      
MFA-TR*            :CODE-STATUS-REASON-4479,                                    
MFA-TR*            :MONTHLY-AMOUNT-4479,                                        
MFA-TR*            :NO-UNITS-4479                                               
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                 WHEN +354                                              
                    IF RETURN-CODE-4479-D NOT = 0 AND                   
                       RETURN-CODE-4479-D NOT = +100 AND                
                       RETURN-CODE-4479-D NOT = +354                    
                         MOVE RETURN-CODE-4479-D TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479D'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-D = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5240-PROCESS-4479D THRU 5240-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479D'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           SET T11-INDEX TO 1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4479-E,                                 
                   :CODE-UTIL-TYPE-4479-E,                              
                   :IC-NO-4479-E,                                       
                   :RATE-PLAN-4479-E,                                   
                   :CODE-REV-CLASS-4479-E,                              
                   :RATE-PLAN-DESC-4479-E,                              
                   :TOU-FL-4479,                                        
                   :FIXED-FACTOR-FL-4479,                               
                   :BILL-CONTRACT-FL-4479,                              
                   :INTERRUPT-FL-4479                                   
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479E INTO                                 
MFA-TR*            :RETURN-CODE-4479-E,                                         
MFA-TR*            :CODE-UTIL-TYPE-4479-E,                                      
MFA-TR*            :IC-NO-4479-E,                                               
MFA-TR*            :RATE-PLAN-4479-E,                                           
MFA-TR*            :CODE-REV-CLASS-4479-E,                                      
MFA-TR*            :RATE-PLAN-DESC-4479-E,                                      
MFA-TR*            :TOU-FL-4479,                                                
MFA-TR*            :FIXED-FACTOR-FL-4479,                                       
MFA-TR*            :BILL-CONTRACT-FL-4479,                                      
MFA-TR*            :INTERRUPT-FL-4479                                           
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                 WHEN +354                                              
                    IF RETURN-CODE-4479-E NOT = 0 AND                   
                       RETURN-CODE-4479-E NOT = +100 AND                
                       RETURN-CODE-4479-E NOT = +354                    
                         MOVE RETURN-CODE-4479-E TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479E'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-E = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5250-PROCESS-4479E THRU 5250-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479E'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5210-PROCESS-4479A.                                              
                                                                        
           MOVE 0 TO T3-RETURN-CODE (T3-INDEX).                         
           MOVE ASSIGNED-DATE-OUT-4479 TO T3-ASSIGNED-DATE (T3-INDEX).  
           MOVE SERV-ORDER-NO-4479-A TO T3-SERV-ORDER-NO (T3-INDEX).    
           MOVE OUT-ORDER-TYPE-CD-4479 TO T3-ORDER-TYPE-CD (T3-INDEX).  
           MOVE ORDER-STATE-CD-4479 TO T3-ORDER-STATE-CD (T3-INDEX).    
           MOVE CUSTOMER-NAME-4479 TO T3-CUSTOMER-NAME (T3-INDEX).      
           MOVE REMARKS-4479 TO T3-REMARKS (T3-INDEX).                  
           MOVE WORK-AREA-4479 TO T3-WORK-AREA (T3-INDEX).              
           MOVE PHONE-4479 TO T3-PHONE (T3-INDEX).                      
           MOVE REMARK-TYPE-4479 TO T3-REMARK-TYPE (T3-INDEX).          
P00718*    MOVE BUSINESS-UNIT-4479 TO T3-BUSINESS-UNIT (T3-INDEX).              
                                                                        
A4670A     IF OUT-ORDER-TYPE-CD-4479(1:2) = 'CC' OR 'NC'                
A4670A         MOVE 'Y' TO WS-START-EXISTS-FL
           END-IF.                          
A4670A     IF OUT-ORDER-TYPE-CD-4479(1:3) = 'OFF'                       
A4670A         MOVE 'Y' TO WS-STOP-EXISTS-FL
           END-IF.                           
                                                                        
A4670A     IF START-EXISTS-YES AND STOP-EXISTS-YES                      
A4670A         INITIALIZE GTT-RETURN-FIELDS-1                           
A4670A         MOVE 0 TO S-RETURN-CODE-1                                
A4670A         MOVE 'ORDR000156' TO S-BUS-RULE-ID                       
A4670A         MOVE 'P' TO S-ACTION-TYPE-CD                             
A4670A         PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
A4670A         IF WS-GTT01-DECLARED = 'N'                               
A4670A             PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
A4670A         END-IF                                                   
A4670A         PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF LINK-ASSIGNED-DATETIME = ASSIGNED-DATE-OUT-4479           
              IF (LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC') AND           
                  OUT-ORDER-TYPE-CD-4479(1:3) = 'OFF'                   
                      INITIALIZE GTT-RETURN-FIELDS-1                    
                      MOVE 0 TO S-RETURN-CODE-1                         
                      MOVE 'ORDR000063' TO S-BUS-RULE-ID                
                      MOVE 'P' TO S-ACTION-TYPE-CD                      
                      PERFORM 7013-RULE-XREF THRU 7013-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT         
MAINTN* NEW MESSAGE FOR 8060 USERS                                              
                       INITIALIZE GTT-RETURN-FIELDS-1                   
                       MOVE 0 TO S-RETURN-CODE-1                        
                       MOVE 'ORDR000348' TO S-BUS-RULE-ID               
                       MOVE 'P' TO S-ACTION-TYPE-CD                     
                       PERFORM 7013-RULE-XREF THRU 7013-EXIT            
                       IF WS-GTT01-DECLARED = 'N'                       
                           PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT    
                       END-IF                                           
                       PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT        
               END-IF                                                   
               IF LINK-ORDER-TYPE-CD(1:3) = 'OFF' AND                   
                 (OUT-ORDER-TYPE-CD-4479(1:2) = 'CC' OR 'NC')           
                      INITIALIZE GTT-RETURN-FIELDS-1                    
                      MOVE 0 TO S-RETURN-CODE-1                         
                      MOVE 'ORDR000064' TO S-BUS-RULE-ID                
                      MOVE 'P' TO S-ACTION-TYPE-CD                      
                      PERFORM 7013-RULE-XREF THRU 7013-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
               END-IF
           END-IF.        
                                                                        
A04670     IF ASSIGNED-DATE-OUT-4479 > LINK-ASSIGNED-DATETIME           
A04670        IF (LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC') AND           
A04670            OUT-ORDER-TYPE-CD-4479(1:3) = 'OFF'                   
A04670                INITIALIZE GTT-RETURN-FIELDS-1                    
A04670                MOVE 0 TO S-RETURN-CODE-1                         
A04670                MOVE 'ORDR000152' TO S-BUS-RULE-ID                
A04670                MOVE 'P' TO S-ACTION-TYPE-CD                      
A04670                PERFORM 7013-RULE-XREF THRU 7013-EXIT             
A04670                IF WS-GTT01-DECLARED = 'N'                        
A04670                    PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
A04670                END-IF                                            
A04670                PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT         
A04670*  A NEW MESSGE FOR 8060 USERS                                            
                      INITIALIZE GTT-RETURN-FIELDS-1                    
                      MOVE 0 TO S-RETURN-CODE-1                         
                      MOVE 'ORDR000347' TO S-BUS-RULE-ID                
                      MOVE 'P' TO S-ACTION-TYPE-CD                      
                      PERFORM 7013-RULE-XREF THRU 7013-EXIT             
                      IF WS-GTT01-DECLARED = 'N'                        
                          PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
                      END-IF                                            
                      PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT         
A04670         END-IF                                                   
A04670         IF LINK-ORDER-TYPE-CD(1:3) = 'OFF' AND                   
A04670           (OUT-ORDER-TYPE-CD-4479(1:2) = 'CC' OR 'NC')           
A04670                INITIALIZE GTT-RETURN-FIELDS-1                    
A04670                MOVE 0 TO S-RETURN-CODE-1                         
A04670                MOVE 'ORDR000153' TO S-BUS-RULE-ID                
A04670                MOVE 'P' TO S-ACTION-TYPE-CD                      
A04670                PERFORM 7013-RULE-XREF THRU 7013-EXIT             
A04670                IF WS-GTT01-DECLARED = 'N'                        
A04670                    PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
A04670                END-IF                                            
A04670                PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
               END-IF
           END-IF.        
                                                                        
           SET T3-INDEX UP BY 1.                                        
                                                                        
       5210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5220-PROCESS-4479B.                                              
                                                                        
           MOVE 0 TO T4-RETURN-CODE (T4-INDEX).                         
           MOVE CODE-UTIL-TYPE-4479-B TO T4-CODE-UTIL-TYPE (T4-INDEX)   
                                       WS-CODE-UTIL-TYPE-SUB (WS-SUB1). 
           MOVE METER-NO-4479-B TO T4-METER-NO (T4-INDEX).              
           MOVE RATE-PLAN-4479-B TO T4-RATE-PLAN (T4-INDEX).            
           MOVE SUPPLIES-4479 TO T4-SUPPLIES (T4-INDEX).                
           MOVE METER-LOC-4479 TO T4-METER-LOC (T4-INDEX).              
           MOVE METER-STATUS-4479 TO T4-METER-STATUS (T4-INDEX)         
                                     WS-METER-STATUS-SUB (WS-SUB1).     
           MOVE METER-STATUS-REASON-4479 TO                             
                T4-METER-STATUS-REASON (T4-INDEX).                      
           MOVE WORK-TYPE-CD-4479-B TO T4-WORK-TYPE-CD (T4-INDEX)       
                                        WS-WORK-TYPE-SUB (WS-SUB1).     
           MOVE METER-READ-INST-4479 TO T4-METER-READ-INST (T4-INDEX).  
           MOVE METER-IND-4479 TO T4-METER-IND (T4-INDEX)               
                                  WS-METER-IND-SUB (WS-SUB1).           
           MOVE IC-NO-4479-B TO T4-IC-NO (T4-INDEX).                    
           MOVE MTR-REF-NO-4479-B TO T4-MTR-REF-NO (T4-INDEX).          
                                                                        
           MOVE LINK-ORDER-TYPE-CD TO L3-ORDER-TYPE-CD.                 
           MOVE WORK-TYPE-CD-4479-B TO L3-WORK-TYPE-CD.                 
           PERFORM 7050-RELEASE-RQMT THRU 7050-EXIT.                    
           IF L3-RLSE-CHECK-CD = 'C'                                    
               MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-4012            
               MOVE 'N' TO WS-SPLIT-RLSE-FL                             
P0795D         IF LINK-ORDER-TYPE-CD NOT = 'FM002'                      
                  PERFORM 5800-CALL-CSR04012 THRU 5800-EXIT             
P0795D         ELSE                                                     
P0795D            PERFORM 7772-REV-DIST-RLSE THRU 7772-EXIT             
P0795D            IF A9-RLSE-REQUIRED-IND = 'Y'                         
P0795D               PERFORM 5800-CALL-CSR04012 THRU 5800-EXIT          
P0795D            END-IF                                                
P0795D         END-IF                                                   
P0795D     END-IF.                                                      
                                                                        
           SET T4-INDEX UP BY 1.                                        
           ADD +1 TO WS-SUB1.                                           
                                                                        
       5220-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5230-PROCESS-4479C.                                              
                                                                        
           MOVE 0 TO T5-RETURN-CODE (T5-INDEX).                         
           MOVE SERV-ORDER-NO-4479-C TO T5-SERV-ORDER-NO (T5-INDEX).    
           MOVE CODE-UTIL-TYPE-4479-C TO T5-CODE-UTIL-TYPE (T5-INDEX).  
           MOVE WORK-TYPE-CD-4479-C TO T5-WORK-TYPE-CD (T5-INDEX).      
           MOVE IC-NO-4479-C TO T5-IC-NO (T5-INDEX).                    
           MOVE METER-NO-4479-C TO T5-METER-NO (T5-INDEX).              
           MOVE MTR-REF-NO-4479-C TO T5-MTR-REF-NO (T5-INDEX).          
           SET T5-INDEX UP BY 1.                                        
                                                                        
       5230-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5240-PROCESS-4479D.                                              
                                                                        
           MOVE 0 TO T9-RETURN-CODE (T9-INDEX).                         
           MOVE RATE-PLAN-4479-D TO T9-RATE-PLAN (T9-INDEX).            
           MOVE RATE-ITEM-CODE-4479 TO T9-RATE-ITEM-CODE (T9-INDEX).    
           MOVE CODE-PLAN-STATUS-4479 TO T9-CODE-PLAN-STATUS (T9-INDEX).
           MOVE CODE-STATUS-REASON-4479 TO                              
                T9-CODE-STATUS-REASON (T9-INDEX).                       
           MOVE MONTHLY-AMOUNT-4479 TO T9-MONTHLY-AMOUNT (T9-INDEX).    
           MOVE NO-UNITS-4479 TO T9-NO-UNITS (T9-INDEX).                
           SET T9-INDEX UP BY 1.                                        
                                                                        
       5240-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5250-PROCESS-4479E.                                              
                                                                        
           MOVE 0 TO T11-RETURN-CODE (T11-INDEX).                       
           MOVE CODE-UTIL-TYPE-4479-E TO T11-CODE-UTIL-TYPE (T11-INDEX).
           MOVE IC-NO-4479-E TO T11-IC-NO (T11-INDEX).                  
           MOVE RATE-PLAN-4479-E TO T11-RATE-PLAN (T11-INDEX).          
           MOVE CODE-REV-CLASS-4479-E TO T11-CODE-REV-CLASS (T11-INDEX).
           MOVE RATE-PLAN-DESC-4479-E TO T11-RATE-PLAN-DESC (T11-INDEX).
           MOVE TOU-FL-4479 TO T11-TOU-FL (T11-INDEX).                  
           MOVE FIXED-FACTOR-FL-4479 TO T11-FIXED-FACTOR-FL (T11-INDEX).
           MOVE BILL-CONTRACT-FL-4479 TO                                
                T11-BILL-CONTRACT-FL (T11-INDEX).                       
           MOVE INTERRUPT-FL-4479 TO T11-INTERRUPT-FL (T11-INDEX).      
           SET T11-INDEX UP BY 1.                                       
                                                                        
       5250-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5300-CALL-CSR04480.                                              
                                                                        
           MOVE WS-ACCOUNT-NO TO ACCOUNT-NO-4480.                       
           MOVE WS-PREMISE-NO TO PREMISE-NO-4480.                       
           MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-4480.               
           MOVE LINK-ASSIGNED-DATETIME TO ASSIGNED-DATE-4480.           
           MOVE PROGRAM-NAME TO PROGRAM-ID-4480.                        
A05189     MOVE LINK-APPLIANCE-LIT-FL TO APPLIANCE-LIT-4480.            
A05189     MOVE WS-RLSE-REQD-4480 TO RELEASE-REQD-4480.                 
A05189     MOVE LINK-FRO-FL TO FRO-FL-4480.                             
P0795E     MOVE LINK-CRAWL-APPL-FL TO CRAWL-APPL-FL-4480.               
D12436     IF LINK-PROCESS = 'MAINTAIN' AND                             
D12436        LINK-ORDER-TYPE-CD(1:3) = 'OFF'                           
D12436         MOVE 'N' TO CRAWL-APPL-FL-4480                           
D12436     END-IF                                                       
D26070*    IF LINK-PROCESS = 'MAINTAIN' AND                                     
D26070*       LINK-FUNCTION = 'A'                                               
D26070*        MOVE 'D' TO CRAWL-APPL-FL-4480                                   
D26070*    END-IF                                                               
P0795G     MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-4480.               
P0795G     MOVE LINK-NEW-ORDER-STATE-CD TO NEW-ORDER-STATE-CD-4480.     
P0795G     MOVE LINK-WORK-AREA-ID TO WORK-AREA-ID-4480.                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04480                                             
      *           (:CODE-UTIL-TYPE-4480,                                
      *            :WORK-TYPE-4480,                                     
      *            :METER-IND-4480,                                     
      *            :METER-STATUS-4480,                                  
      *            :ACCOUNT-NO-4480,                                    
      *            :PREMISE-NO-4480,                                    
      *            :ORDER-TYPE-CD-4480,                                 
      *            :ASSIGNED-DATE-4480,                                 
      *            :PROGRAM-ID-4480,                                    
A05189*            :APPLIANCE-LIT-4480,                                 
A05189*            :RELEASE-REQD-4480,                                  
A05189*            :FRO-FL-4480,                                        
P0795E*            :CRAWL-APPL-FL-4480,                                 
P0795G*            :SERV-ORDER-NO-4480,                                 
P0795G*            :NEW-ORDER-STATE-CD-4480,                            
P0795G*            :WORK-AREA-ID-4480)                                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_CUR_2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_CUR_2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_CUR_2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04480'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4480       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4480A, :LOC4480B)                                    
      *       WITH PROCEDURE CSR04480                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4480A CURSOR FOR RESULT SET       
      *       :LOC4480A                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4480B CURSOR FOR RESULT SET       
      *       :LOC4480B                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH MSQ001_CUR_2 INTO                           
                 :RETURN-CODE-4480-A,                                   
                 :WORK-AREA-4480,                                       
                 :DISCONNECT-CD-4480,                                   
                 :TOTAL-RES-4480,                                       
                 :ARRANGEMENT-FL-4480,                                  
                 :REVERT-FL-4480,                                       
P00718           :BUSINESS-UNIT-4480,                                   
P00718           :WORK-DISTRICT-4480,                                   
A05189           :AROP-READ-ONLY-4480                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH RESULT_SET_CSR_4480A INTO                                   
MFA-TR*          :RETURN-CODE-4480-A,                                           
MFA-TR*          :WORK-AREA-4480,                                               
MFA-TR*          :DISCONNECT-CD-4480,                                           
MFA-TR*          :TOTAL-RES-4480,                                               
MFA-TR*          :ARRANGEMENT-FL-4480,                                          
MFA-TR*          :REVERT-FL-4480,                                               
MFA-TR*          :BUSINESS-UNIT-4480,                                           
MFA-TR*          :WORK-DISTRICT-4480,                                           
MFA-TR*          :AROP-READ-ONLY-4480                                           
MFA-TR*    END-EXEC.                                                            

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  IF RETURN-CODE-4480-A NOT = 0                         
                      MOVE RETURN-CODE-4480-A TO WS-ACTIVE-RETURN-CODE  
                      MOVE PROGRAM-NAME        TO ABEND-PROGRAM         
                      MOVE '5300'              TO ACTIVE-PARAGRAPH      
                      MOVE 'FETCH'             TO ABEND-FUNCTION        
                      MOVE 'CSR04480A'         TO TABLE-1               
                      MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1       
                      MOVE ACCOUNT-NO-4480     TO HOSTVAR-ELEMENT-1     
                      PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT         
                  END-IF                                                
                  PERFORM 5310-PROCESS-4480A THRU 5310-EXIT             
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '5300'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CSR04480A'           TO TABLE-1                 
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1         
                  MOVE ACCOUNT-NO-4480       TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
           SET T7-INDEX TO 1.                                           
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_2 INTO                         
                   :RETURN-CODE-4480-B,                                 
                   :CALENDAR-DT-4480,                                   
                   :GOOD-DAY-FL-4480,                                   
                   :TOTAL-SO-HRS-4480,                                  
                   :MAX-RE-PER-DAY-4480,                                
                   :TOTAL-SO-4480,                                      
                   :MAX-DAILY-WK-REQ-4480                               
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4480B INTO                                 
MFA-TR*            :RETURN-CODE-4480-B,                                         
MFA-TR*            :CALENDAR-DT-4480,                                           
MFA-TR*            :GOOD-DAY-FL-4480,                                           
MFA-TR*            :TOTAL-SO-HRS-4480,                                          
MFA-TR*            :MAX-RE-PER-DAY-4480,                                        
MFA-TR*            :TOTAL-SO-4480,                                              
MFA-TR*            :MAX-DAILY-WK-REQ-4480                                       
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4480-B NOT = 0 AND                   
                       RETURN-CODE-4480-B NOT = +100                    
                         MOVE RETURN-CODE-4480-B TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5300'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04480B'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4480   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4480-B = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5320-PROCESS-4480B THRU 5320-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5300'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04480B'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4480       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_2
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5310-PROCESS-4480A.                                              
                                                                        
           MOVE WORK-AREA-4480 TO S-WORK-AREA-2                         
                                  I2-WORK-AREA-ID.                      
           MOVE DISCONNECT-CD-4480 TO S-DISCONNECT-CD.                  
           MOVE TOTAL-RES-4480 TO S-TOTAL-RES.                          
           MOVE ARRANGEMENT-FL-4480 TO S-ARRANGEMENT-FL-2.              
           MOVE REVERT-FL-4480 TO S-REVERT-FL.                          
           IF S-REVERT-FL = 'Y'                                         
               MOVE 'N' TO S-PAYMENT-REQ-FL
           END-IF.                            
P00718     MOVE BUSINESS-UNIT-4480  TO S-BUSINESS-UNIT-2.               
P00718     MOVE WORK-DISTRICT-4480  TO S-WORK-DISTRICT-2.               
A05189     MOVE AROP-READ-ONLY-4480 TO S-AROP-READ-ONLY-FL-2.           
                                                                        
           PERFORM 7020-WORK-AREA THRU 7020-EXIT.                       
                                                                        
       5310-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5320-PROCESS-4480B.                                              
                                                                        
           MOVE 0 TO T7-RETURN-CODE (T7-INDEX).                         
           MOVE CALENDAR-DT-4480 TO T7-CALENDAR-DT (T7-INDEX).          
           MOVE GOOD-DAY-FL-4480 TO T7-GOOD-DAY-FL (T7-INDEX).          
           MOVE TOTAL-SO-HRS-4480 TO T7-TOTAL-SO-HRS (T7-INDEX).        
           MOVE MAX-RE-PER-DAY-4480 TO T7-MAX-RE-PER-DAY (T7-INDEX).    
           MOVE TOTAL-SO-4480 TO T7-TOTAL-SO (T7-INDEX).                
           MOVE MAX-DAILY-WK-REQ-4480 TO T7-MAX-DAILY-WK-REQ (T7-INDEX).
           SET T7-INDEX UP BY 1.                                        
                                                                        
       5320-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5400-CALL-CSR01684.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01684                                             
      *           (:ORDER-TYPE-CD-1684,                                 
      *            :WORK-TYPE-1-1684,                                   
      *            :METER-STATUS-1-1684,                                
      *            :WORK-TYPE-2-1684,                                   
      *            :METER-STATUS-2-1684,                                
      *            :COMPANY-NO-1684,                                    
      *            :CODE-UTIL-1-1684,                                   
      *            :CODE-UTIL-2-1684)                                   
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1684
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1684
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1684 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5400'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01684'            TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE COMPANY-NO-1684       TO HOSTVAR-ELEMENT-1           
              MOVE 'ORDER_TYPE_CD'       TO TABLE-ELEMENT-2             
              MOVE ORDER-TYPE-CD-1684    TO HOSTVAR-ELEMENT-2           
              MOVE 'WORK_TYPE_CD'        TO TABLE-ELEMENT-3             
              MOVE WORK-TYPE-1-1684      TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1684)                                                
      *       WITH PROCEDURE CSR01684                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1684 CURSOR FOR RESULT SET        
      *       :LOC1684                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1684 INTO                            
                 :RETURN-CODE-E-1684 :WS-NULL2,                          
                 :RETURN-CODE-G-1684 :WS-NULL3,                          
                 :RETURN-CODE-1684                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  IF WS-NULL2 < 0                                       
                      MOVE SPACES TO RETURN-CODE-E-1684                 
                  END-IF                                                
                  IF WS-NULL3 < 0                                       
                      MOVE SPACES TO RETURN-CODE-G-1684                 
                  END-IF                                                
                  IF RETURN-CODE-1684 = -1                              
                      MOVE ZEROES TO RETURN-CODE-1684                   
                  END-IF                                                
                  IF RETURN-CODE-1684 NOT = 0                           
                      MOVE RETURN-CODE-1684   TO WS-ACTIVE-RETURN-CODE  
                      MOVE PROGRAM-NAME       TO ABEND-PROGRAM          
                      MOVE '5400'             TO ACTIVE-PARAGRAPH       
                      MOVE 'FETCH'            TO ABEND-FUNCTION         
                      MOVE 'CSR01684'         TO TABLE-1                
                      MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1        
                      MOVE COMPANY-NO-1684    TO HOSTVAR-ELEMENT-1      
                      MOVE 'ORDER_TYPE_CD'    TO TABLE-ELEMENT-2        
                      MOVE ORDER-TYPE-CD-1684 TO HOSTVAR-ELEMENT-2      
                      MOVE 'WORK_TYPE_CD'     TO TABLE-ELEMENT-3        
                      MOVE WORK-TYPE-1-1684   TO HOSTVAR-ELEMENT-3      
                      PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT         
                  END-IF                                                
                  IF RETURN-CODE-E-1684 = 'Y'                           
                      MOVE 'Y' TO S-BAD-ELEC-WK-TYPE                    
                  END-IF                                                
                  IF RETURN-CODE-G-1684 = 'Y'                           
                      MOVE 'Y' TO S-BAD-GAS-WK-TYPE                     
                  END-IF                                                
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '5400'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CSR01684'            TO TABLE-1                 
                  MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1         
                  MOVE COMPANY-NO-1684       TO HOSTVAR-ELEMENT-1       
                  MOVE 'ORDER_TYPE_CD'       TO TABLE-ELEMENT-2         
                  MOVE ORDER-TYPE-CD-1684    TO HOSTVAR-ELEMENT-2       
                  MOVE 'WORK_TYPE_CD'        TO TABLE-ELEMENT-3         
                  MOVE WORK-TYPE-1-1684      TO HOSTVAR-ELEMENT-3       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
       5400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5500-CALL-CSR04153.                                              
                                                                        
           MOVE AT-COMPANY-NO TO COMPANY-NO-4153.                       
           MOVE AT-LOCAL-OFFICE TO LOCAL-OFFICE-4153.                   
           MOVE LINK-ORDER-TYPE-CD TO ORDER-TYPE-CD-4153.               
           MOVE WS-RLSE-FL TO RELEASE-CD-4153.                          
           IF WS-CRAWL-FL = 'Y' OR LINK-CRAWL-APPL-FL = 'Y'             
               MOVE 'G' TO CRAWL-IND-4153                               
           ELSE                                                         
               MOVE 'N' TO CRAWL-IND-4153
           END-IF.                              
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-4153.                     
           MOVE LINK-PREMISE-NO TO PREMISE-NO-4153.                     
           MOVE 'CIS' TO CALLING-SYSTEM-4153.                           
           IF WS-1ST-ELEC > 0                                           
               MOVE WS-WORK-TYPE-SUB (WS-1ST-ELEC) TO                   
                    ELEC-WORK-TYPE-4153                                 
               MOVE WS-IC-NO-SUB (WS-1ST-ELEC) TO ELEC-IC-NO-4153       
               MOVE WS-MTR-REF-SUB (WS-1ST-ELEC) TO ELEC-MTR-REF-4153   
               MOVE WS-METER-IND-SUB (WS-1ST-ELEC) TO WS-ELEC-METER-IND 
           ELSE                                                         
               MOVE SPACES TO ELEC-WORK-TYPE-4153                       
                              WS-ELEC-METER-IND                         
               MOVE ZEROES TO ELEC-IC-NO-4153                           
                              ELEC-MTR-REF-4153
           END-IF.                        
           IF WS-1ST-GAS > 0                                            
               MOVE WS-WORK-TYPE-SUB (WS-1ST-GAS) TO                    
                    GAS-WORK-TYPE-4153                                  
               MOVE WS-IC-NO-SUB (WS-1ST-GAS) TO GAS-IC-NO-4153         
               MOVE WS-MTR-REF-SUB (WS-1ST-GAS) TO GAS-MTR-REF-4153     
               MOVE WS-METER-IND-SUB (WS-1ST-GAS) TO WS-GAS-METER-IND   
           ELSE                                                         
               MOVE SPACES TO GAS-WORK-TYPE-4153                        
                              WS-GAS-METER-IND                          
               MOVE ZEROES TO GAS-IC-NO-4153                            
                              GAS-MTR-REF-4153
           END-IF.                         
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04153                                             
      *           (:COMPANY-NO-4153,                                    
      *            :LOCAL-OFFICE-4153,                                  
      *            :ORDER-TYPE-CD-4153,                                 
      *            :ELEC-WORK-TYPE-4153,                                
      *            :GAS-WORK-TYPE-4153,                                 
      *            :RELEASE-CD-4153,                                    
      *            :CRAWL-IND-4153,                                     
      *            :ACCOUNT-NO-4153,                                    
      *            :ELEC-IC-NO-4153,                                    
      *            :ELEC-MTR-REF-4153,                                  
      *            :GAS-IC-NO-4153,                                     
      *            :GAS-MTR-REF-4153,                                   
      *            :CALLING-SYSTEM-4153,                                
      *            :PREMISE-NO-4153)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4153
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4153
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4153 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5500'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04153'            TO TABLE-1                     
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
              MOVE COMPANY-NO-4153       TO HOSTVAR-ELEMENT-1           
              MOVE 'ORDER_TYPE_CD'       TO TABLE-ELEMENT-2             
              MOVE ORDER-TYPE-CD-4153    TO HOSTVAR-ELEMENT-2           
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-3             
              MOVE LOCAL-OFFICE-4153     TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4153)                                                
      *       WITH PROCEDURE CSR04153                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4153 CURSOR FOR RESULT SET        
      *       :LOC4153                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4153 INTO                            
                 :RETURN-CODE-4153,                                     
                 :SPLIT-CD-4153,                                        
                 :SCENARIO-CD-4153,                                     
                 :ERROR-MSG-4153,                                       
                 :DATAWINDOW-CD-4153,                                   
                 :TOU-ERROR-MSG-4153,                                   
                 :TOU-ACCOUNT-4153                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  IF RETURN-CODE-4153 NOT = 0                           
                      MOVE RETURN-CODE-4153   TO WS-ACTIVE-RETURN-CODE  
                      MOVE PROGRAM-NAME       TO ABEND-PROGRAM          
                      MOVE '5500'             TO ACTIVE-PARAGRAPH       
                      MOVE 'FETCH'            TO ABEND-FUNCTION         
                      MOVE 'CSR04153'         TO TABLE-1                
                      MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-1        
                      MOVE COMPANY-NO-4153    TO HOSTVAR-ELEMENT-1      
                      MOVE 'ORDER_TYPE_CD'    TO TABLE-ELEMENT-2        
                      MOVE ORDER-TYPE-CD-4153 TO HOSTVAR-ELEMENT-2      
                      MOVE 'LOCAL_OFFICE'     TO TABLE-ELEMENT-3        
                      MOVE LOCAL-OFFICE-4153  TO HOSTVAR-ELEMENT-3      
                      PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT         
                  END-IF                                                
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '5500'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CSR04153'            TO TABLE-1                 
                  MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1         
                  MOVE COMPANY-NO-4153       TO HOSTVAR-ELEMENT-1       
                  MOVE 'ORDER_TYPE_CD'       TO TABLE-ELEMENT-2         
                  MOVE ORDER-TYPE-CD-4153    TO HOSTVAR-ELEMENT-2       
                  MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-3         
                  MOVE LOCAL-OFFICE-4153     TO HOSTVAR-ELEMENT-3       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
       5500-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5600-CALL-CSR04154.                                              
                                                                        
           MOVE AT-COMPANY-NO TO COMPANY-NO-4154.                       
           MOVE SCENARIO-CD-4153 TO SCENARIO-CD-4154.                   
           MOVE LINK-FRO-FL TO FRO-FL-4154.                             
           MOVE LINK-PREMISE-NO TO PREMISE-NO-4154.                     
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04154                                             
      *           (:COMPANY-NO-4154,                                    
      *            :SCENARIO-CD-4154,                                   
      *            :FRO-FL-4154,                                        
      *            :PREMISE-NO-4154)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4154
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4154
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4154 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5600'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04154'            TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE PREMISE-NO-4154       TO HOSTVAR-ELEMENT-1           
              MOVE 'SCENARIO_CD'         TO TABLE-ELEMENT-2             
              MOVE SCENARIO-CD-4154      TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4154)                                                
      *       WITH PROCEDURE CSR04154                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4154 CURSOR FOR RESULT SET        
      *       :LOC4154                                                  
      *    END-EXEC.                                                    
                                                                        
           SET T8-INDEX TO 1.                                           
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_4154 INTO                          
                   :RETURN-CODE-4154,                                   
                   :SCENARIO-SEQ-4154,                                  
                   :SCENARIO-SEQ-CHOICE-4154,                           
                   :NEW-ORDER-TYPE-4154,                                
                   :NEW-E-WORK-TYPE-4154,                               
                   :NEW-G-WORK-TYPE-4154,                               
                   :NEW-ORDER-STATE-CD-4154,                            
                   :DISPATCH-NOT-WQ-4154,                               
                   :ADDL-SO-REMARKS-4154,                               
                   :SO-HOLD-COMMENTS-4154,                              
                   :DATAWINDOW-DESC-4154,                               
                   :SCHED-DT-FUNC-CD-4154,                              
                   :MAX-DATE-4154,                                      
                   :ORD-AUTO-SEL-CD-4154,                               
P0795C             :ORDER-BUS-RULE-ID-4154,                             
P0795F             :ORDER-UTILITY-CD-4154                               
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4154 NOT = 0 AND                     
                       RETURN-CODE-4154 NOT = +100                      
                         MOVE RETURN-CODE-4154 TO                       
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5600'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04154'        TO TABLE-1              
                         MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1      
                         MOVE PREMISE-NO-4154   TO HOSTVAR-ELEMENT-1    
                         MOVE 'SCENARIO_CD'     TO TABLE-ELEMENT-2      
                         MOVE SCENARIO-CD-4154  TO HOSTVAR-ELEMENT-2    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4154 = +100                          
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5610-PROCESS-4154 THRU 5610-EXIT        
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5600'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04154'            TO TABLE-1              
                     MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1      
                     MOVE PREMISE-NO-4154       TO HOSTVAR-ELEMENT-1    
                     MOVE 'SCENARIO_CD'         TO TABLE-ELEMENT-2      
                     MOVE SCENARIO-CD-4154      TO HOSTVAR-ELEMENT-2    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5600-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5610-PROCESS-4154.                                               
                                                                        
           MOVE 'Y' TO WS-READ-ONLY-ORDER.                              
           MOVE 0 TO T8-RETURN-CODE (T8-INDEX).                         
           MOVE SCENARIO-SEQ-4154 TO T8-SCENARIO-SEQ (T8-INDEX).        
           MOVE SCENARIO-SEQ-CHOICE-4154 TO                             
                T8-SCENARIO-SEQ-CHOICE (T8-INDEX).                      
           MOVE NEW-ORDER-TYPE-4154 TO T8-NEW-ORDER-TYPE (T8-INDEX)     
                                       L3-ORDER-TYPE-CD                 
                                       ORDER-TYPE-CD-4012.              
           MOVE NEW-E-WORK-TYPE-4154 TO T8-NEW-E-WORK-TYPE (T8-INDEX).  
           IF NEW-E-WORK-TYPE-4154 > ' '                                
               MOVE 'Y' TO WS-ELEC-ORDER-FL                             
A05189         MOVE NEW-E-WORK-TYPE-4154 TO L4-WORK-TYPE-CD             
A05189         PERFORM 7250-WORK-TYPE  THRU 7250-EXIT                   
A05189     END-IF                                                       
           MOVE NEW-G-WORK-TYPE-4154 TO T8-NEW-G-WORK-TYPE (T8-INDEX).  
A05189     IF NEW-G-WORK-TYPE-4154 > ' ' AND                            
A05189           WS-READ-ONLY-ORDER = 'Y'                               
A05189         MOVE NEW-G-WORK-TYPE-4154 TO L4-WORK-TYPE-CD             
A05189         PERFORM 7250-WORK-TYPE  THRU 7250-EXIT                   
A05189     END-IF                                                       
           MOVE NEW-ORDER-STATE-CD-4154 TO                              
                T8-NEW-ORDER-STATE-CD (T8-INDEX).                       
           MOVE DISPATCH-NOT-WQ-4154 TO T8-DISPATCH-NOT-WQ (T8-INDEX).  
           MOVE ADDL-SO-REMARKS-4154 TO T8-ADDL-SO-REMARKS (T8-INDEX).  
           MOVE SO-HOLD-COMMENTS-4154 TO T8-SO-HOLD-COMMENTS (T8-INDEX).
           MOVE SCHED-DT-FUNC-CD-4154 TO T8-SCHED-DT-FUNC-CD (T8-INDEX).
           MOVE MAX-DATE-4154 TO T8-MAX-DATE (T8-INDEX).                
           MOVE ORD-AUTO-SEL-CD-4154 TO T8-ORD-AUTO-SEL-CD (T8-INDEX).  
P0795C     MOVE ORDER-BUS-RULE-ID-4154                                  
P0795C                              TO T8-ORDER-BUS-RULE-ID (T8-INDEX). 
A05189     MOVE WS-READ-ONLY-ORDER TO T8-AROP-READ-ONLY-FL (T8-INDEX).  
P0795F     MOVE ORDER-UTILITY-CD-4154                                   
P0795F                              TO T8-ORDER-UTILITY-CD (T8-INDEX).  
                                                                        
           PERFORM 5630-ARRANGEMENT THRU 5630-EXIT.                     
           MOVE WS-4423-ARRANGEMENT-FL TO T8-ARRANGEMENT-FL (T8-INDEX). 
           IF WS-4423-ARRANGEMENT-FL = 'Y'                              
               MOVE 'Y' TO WS-GAS-ARRANGE-FL
           END-IF.                           
           MOVE 'Y' TO WS-SPLIT-RLSE-FL.                                
           IF NEW-E-WORK-TYPE-4154 > ' '                                
               MOVE NEW-E-WORK-TYPE-4154 TO L3-WORK-TYPE-CD             
               PERFORM 7050-RELEASE-RQMT THRU 7050-EXIT                 
               IF L3-RLSE-CHECK-CD = 'C'                                
                  MOVE WS-1ST-ELEC TO WS-SUB1                           
                  MOVE NEW-E-WORK-TYPE-4154 TO WORK-TYPE-CD-4012        
P0795D            IF ORDER-TYPE-CD-4012 NOT = 'FM002'                   
                     PERFORM 5800-CALL-CSR04012 THRU 5800-EXIT          
                     IF ((RLSE-REQUIRED-FL-4012 = 'Y' OR 'E') OR        
D25931                   (WS-RLSE-REQD-SUB(WS-1ST-ELEC) = 'Y')) AND     
                        RLSE-EXISTS-4012 NOT = 'Y'                      
                           MOVE 'Y' TO T8-ELEC-RLSE-FL (T8-INDEX)       
                     END-IF                                             
D12002               IF RLSE-EXISTS-4012 = 'Y'                          
D12002                  MOVE 'Y' TO T8-ELEC-RLSE-FL (T8-INDEX)          
D12002                  MOVE RLSE-NO-4012 TO T8-ELEC-RLSE-NO (T8-INDEX) 
D12002               END-IF                                             
P0795D            ELSE                                                  
P0795D               PERFORM 7772-REV-DIST-RLSE THRU 7772-EXIT          
P0795D               IF A9-RLSE-REQUIRED-IND = 'Y' OR                   
D25931                  WS-RLSE-REQD-SUB(WS-1ST-ELEC) = 'Y'             
P0795D                  PERFORM 5800-CALL-CSR04012 THRU 5800-EXIT       
                        IF ((RLSE-REQUIRED-FL-4012 = 'Y' OR 'E') OR     
D25931                     (WS-RLSE-REQD-SUB(WS-1ST-ELEC) = 'Y')) AND   
                           RLSE-EXISTS-4012 NOT = 'Y'                   
                           MOVE 'Y' TO T8-ELEC-RLSE-FL (T8-INDEX)       
                        END-IF                                          
D12002                  IF RLSE-EXISTS-4012 = 'Y'                       
D12002                     MOVE 'Y' TO T8-ELEC-RLSE-FL (T8-INDEX)       
D12002                     MOVE RLSE-NO-4012 TO                         
D12002                                   T8-ELEC-RLSE-NO (T8-INDEX)     
D12002                  END-IF                                          
                    END-IF                                              
P0795D            END-IF                                                
P0795D         END-IF                                                   
P0795D      END-IF                                                      
           IF NEW-G-WORK-TYPE-4154 > ' '                                
               MOVE NEW-G-WORK-TYPE-4154 TO L3-WORK-TYPE-CD             
               PERFORM 7050-RELEASE-RQMT THRU 7050-EXIT                 
               IF L3-RLSE-CHECK-CD = 'C'                                
                  MOVE WS-1ST-GAS TO WS-SUB1                            
                  MOVE NEW-G-WORK-TYPE-4154 TO WORK-TYPE-CD-4012        
P0795D            IF ORDER-TYPE-CD-4012 NOT = 'FM002'                   
                     PERFORM 5800-CALL-CSR04012 THRU 5800-EXIT          
                     IF ((RLSE-REQUIRED-FL-4012 = 'Y' OR 'E') OR        
D25931                   (WS-RLSE-REQD-SUB(WS-1ST-GAS) = 'Y')) AND      
                        RLSE-EXISTS-4012 NOT = 'Y'                      
                           MOVE 'Y' TO T8-GAS-RLSE-FL (T8-INDEX)        
                     END-IF                                             
D12002               IF RLSE-EXISTS-4012 = 'Y'                          
D12002                  MOVE 'Y' TO T8-GAS-RLSE-FL (T8-INDEX)           
D12002                  MOVE RLSE-NO-4012 TO T8-GAS-RLSE-NO (T8-INDEX)  
D12002               END-IF                                             
P0795D            ELSE                                                  
P0795D               PERFORM 7772-REV-DIST-RLSE THRU 7772-EXIT          
P0795D               IF A9-RLSE-REQUIRED-IND = 'Y' OR                   
P0795D                  WS-RLSE-REQD-SUB(WS-1ST-GAS) = 'Y'              
P0795D                  PERFORM 5800-CALL-CSR04012 THRU 5800-EXIT       
                        IF ((RLSE-REQUIRED-FL-4012 = 'Y' OR 'E') OR     
D25931                     (WS-RLSE-REQD-SUB(WS-1ST-GAS) = 'Y')) AND    
                           RLSE-EXISTS-4012 NOT = 'Y'                   
                           MOVE 'Y' TO T8-GAS-RLSE-FL (T8-INDEX)        
                        END-IF                                          
D12002                  IF RLSE-EXISTS-4012 = 'Y'                       
D12002                     MOVE 'Y' TO T8-GAS-RLSE-FL (T8-INDEX)        
D12002                     MOVE RLSE-NO-4012 TO                         
D12002                                    T8-GAS-RLSE-NO (T8-INDEX)     
D12002                  END-IF                                          
                    END-IF                                              
P0795D            END-IF                                                
P0795D         END-IF                                                   
P0795D      END-IF                                                      
           MOVE 'N' TO WS-SPLIT-RLSE-FL.                                
A05189     IF WS-READ-ONLY-ORDER = 'Y' AND                              
A05189                LINK-APPLIANCE-LIT-FL NOT = 'Y' AND               
A05189                T8-ELEC-RLSE-FL (T8-INDEX) NOT = 'Y' AND          
A05189                T8-GAS-RLSE-FL (T8-INDEX) NOT = 'Y' AND           
A05189                LINK-FRO-FL NOT = 'Y'                             
A05189        PERFORM 5910-CALL-CSR04849  THRU 5910-EXIT                
A05189     END-IF                                                       
A05189     IF AROP-ELIGIBLE-FL-4849 = 'Y'                               
A05189        IF L4-COMPANY-NO = '26'                                   
A05189            MOVE 'AROPPSNC' TO T8-WORK-AREA (T8-INDEX)            
A05189        ELSE                                                      
A05189            MOVE 'AROPSCEG' TO T8-WORK-AREA (T8-INDEX)            
A05189        END-IF                                                    
A05189        MOVE SPACES TO T8-BUSINESS-UNIT (T8-INDEX)                
A05189        MOVE SPACES TO T8-WORK-DISTRICT (T8-INDEX)                
A05189     ELSE                                                         
              PERFORM 5620-CALL-CSR01116 THRU 5620-EXIT                 
              MOVE WORK-AREA-1116 TO T8-WORK-AREA (T8-INDEX)            
P00718        MOVE BUSINESS-UNIT-1116 TO T8-BUSINESS-UNIT (T8-INDEX)    
A05200        MOVE SPACES TO WS-WORK-DISTRICT                           
P00718        PERFORM 5640-GET-WKDIST    THRU 5640-EXIT                 
P00718        MOVE WS-WORK-DISTRICT TO T8-WORK-DISTRICT (T8-INDEX)      
A05186     END-IF                                                       
           SET T8-INDEX UP BY 1.                                        
                                                                        
       5610-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5620-CALL-CSR01116.                                              
                                                                        
           MOVE AT-LOCAL-OFFICE TO LOCAL-OFFICE-1116.                   
           MOVE DY-ZIP-CODE TO ZIP-CODE-1116.                           
           MOVE UT-READ-ROUTE TO WS-READ-ROUTE-NUM.                     
           MOVE WS-READ-ROUTE-CHAR TO READ-ROUTE-1116.                  
           MOVE MN-GIS-POINT-ID TO WS-GIS-POINT-ID.                     
           MOVE WS-GIS-POINT-ID-CHAR TO POINT-ID-1116.                  
           IF NEW-E-WORK-TYPE-4154 > ' '                                
               MOVE NEW-E-WORK-TYPE-4154 TO WORK-TYPE-CD-1116(1:3)      
               MOVE WS-ELEC-METER-IND TO METER-IND-1116 (1:1)           
               MOVE 'E' TO CODE-UTIL-TYPE-1116(1:1)                     
               IF NEW-G-WORK-TYPE-4154 > ' '                            
                   MOVE NEW-G-WORK-TYPE-4154 TO WORK-TYPE-CD-1116(4:3)  
                   MOVE WS-GAS-METER-IND TO METER-IND-1116 (2:1)        
                   MOVE 'G' TO CODE-UTIL-TYPE-1116(2:1)                 
               END-IF                                                   
           ELSE                                                         
               MOVE NEW-G-WORK-TYPE-4154 TO WORK-TYPE-CD-1116(1:3)      
               MOVE WS-GAS-METER-IND TO METER-IND-1116 (1:1)            
               MOVE 'G' TO CODE-UTIL-TYPE-1116(1:1)
           END-IF.                    
                                                                        
           MOVE 'N' TO CRAWL-IND-1116.                                  
           IF WS-CRAWL-LOCAL-OFFICE = 'Y' AND                           
P0795E       (LINK-CRAWL-APPL-FL = 'Y' OR                               
              WS-CRAWL-FL = 'Y' OR                                      
              WS-APPLIANCE-FL = 'N') AND                                
              NEW-G-WORK-TYPE-4154 = 'SOL' OR 'SOS' OR 'UNB' OR         
                                     'UDP' OR 'ST2'                     
                  MOVE 'Y' TO CRAWL-IND-1116
           END-IF.                           
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01116                                             
      *            (:LOCAL-OFFICE-1116,                                 
      *             :CODE-UTIL-TYPE-1116,                               
      *             :WORK-TYPE-CD-1116,                                 
      *             :CRAWL-IND-1116,                                    
      *             :METER-IND-1116,                                    
      *             :ZIP-CODE-1116,                                     
      *             :READ-ROUTE-1116,                                   
      *             :POINT-ID-1116)                                     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1116 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01116'            TO TABLE-1                     
              MOVE 'LOCAL_OFFICE_NO'     TO TABLE-ELEMENT-1             
              MOVE LOCAL-OFFICE-1116     TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE CODE-UTIL-TYPE-1116   TO HOSTVAR-ELEMENT-2           
              MOVE 'WORK_TYPE_CD'        TO TABLE-ELEMENT-3             
              MOVE WORK-TYPE-CD-1116     TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1116)                                                
      *       WITH PROCEDURE CSR01116                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1116 CURSOR FOR RESULT SET        
      *       :LOC1116                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_1116 INTO                           
                   :RETURN-CODE-1116 ,                                  
                   :WORK-AREA-1116,                                     
P00718             :BUSINESS-UNIT-1116                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3000'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01116'            TO TABLE-1                
                   MOVE 'LOCAL_OFFICE_NO'     TO TABLE-ELEMENT-1        
                   MOVE LOCAL-OFFICE-1116     TO HOSTVAR-ELEMENT-1      
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
                   MOVE CODE-UTIL-TYPE-1116   TO HOSTVAR-ELEMENT-2      
                   MOVE 'WORK_TYPE_CD'        TO TABLE-ELEMENT-3        
                   MOVE WORK-TYPE-CD-1116     TO HOSTVAR-ELEMENT-3      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       5620-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5630-ARRANGEMENT.                                                
                                                                        
           MOVE AT-COMPANY-NO TO WS-4423-COMPANY-NO.                    
           MOVE LINK-ORDER-TYPE-CD  TO  WS-4423-ORDER-TYPE-CD           
           IF NEW-E-WORK-TYPE-4154 > ' '                                
               MOVE NEW-E-WORK-TYPE-4154 TO WS-4423-WORK-TYPE-CD (1)    
               MOVE 'E' TO WS-4423-CODE-UTIL-TYPE (1)                   
               IF NEW-G-WORK-TYPE-4154 > ' '                            
                   MOVE NEW-G-WORK-TYPE-4154 TO WS-4423-WORK-TYPE-CD (2)
                   MOVE 'G' TO WS-4423-CODE-UTIL-TYPE (2)               
               END-IF                                                   
           ELSE                                                         
               MOVE NEW-G-WORK-TYPE-4154 TO WS-4423-WORK-TYPE-CD (1)    
               MOVE 'G' TO WS-4423-CODE-UTIL-TYPE (1)
           END-IF.                  
           PERFORM A1000-APPT-ARRG-REQ THRU A1000-EXIT.                 
                                                                        
       5630-EXIT.                                                       
            EXIT.                                                       
                                                                        
P00718 5640-GET-WKDIST.                                                 
P00718                                                                  
P00718     INSPECT PR-FM-ELEC-SVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-GAS-OPS-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-FLD-SVCS-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-REV-PRT-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-DSM-ESVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     EVALUATE TRUE                                                
P00718        WHEN BUSINESS-UNIT-1116 = 'EOP'                           
P00718         AND PR-FM-ELEC-SVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-ELEC-SVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN BUSINESS-UNIT-1116 = 'GOP'                           
P00718         AND PR-FM-GAS-OPS-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-GAS-OPS-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN BUSINESS-UNIT-1116 = 'FSV'                           
P00718         AND PR-FM-FLD-SVCS-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-FLD-SVCS-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN BUSINESS-UNIT-1116 = 'RVP'                           
P00718         AND PR-FM-REV-PRT-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-REV-PRT-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN BUSINESS-UNIT-1116 = 'DSM'                           
P00718         AND PR-FM-DSM-ESVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-DSM-ESVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718     PERFORM 7760-GET-PRINT-LOC                THRU 7760-EXIT.    
P00718     MOVE WS-ACCOUNT-NO-NUM                    TO RG-ACCOUNT-NO.  
P00718     PERFORM 7770-GET-REGISTER-DTLS            THRU 7770-EXIT.    
P00718     IF (C4-CAD-WORKAREA-FL = 'Y' AND WS-MULTI-REG-MTR = 'N')     
P00718        MOVE WS-WORK-DISTRICT                  TO WS-WORK-DISTRICT
P00718     ELSE                                                         
P00718        MOVE SPACES                            TO WS-WORK-DISTRICT
P00718     END-IF.                                                      
       5640-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5700-CALL-CSR04109.                                              
                                                                        
           MOVE T8-WORK-AREA (T8-INDEX) TO WORK-AREA-ID-4109.           
           MOVE WS-CURRENT-DATE TO ASSIGNED-DATETIME-4109 (1:10).       
           MOVE '-00.00.00.000000' TO ASSIGNED-DATETIME-4109 (11:16).   
           MOVE ZEROES TO SERV-ORDER-NO-4109.                           
           MOVE WS-WK-TOTAL-RES  TO WS-TOTAL-RES-DEC.                   
           MOVE WS-TOTAL-RES-DEC(1:5) TO WS-TOTAL-RES(1:5).             
           MOVE WS-TOTAL-RES-DEC(6:1) TO WS-TOTAL-RES(6:1).             
           MOVE WS-TOTAL-RES TO TOTAL-RES-4109.                         
           MOVE '062' TO NO-DAYS-4109.                                  
           MOVE SPACES TO SYSTEM-INITIATED-4109.                        
A05189     INSPECT WS-WORK-TYPES-4109 REPLACING ALL LOW-VALUES          
A05189                                               BY SPACES.         
A05189     MOVE WS-WORK-TYPES-4109 TO WORK-TYPES-4109.                  
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04109                                             
      *            (:WORK-AREA-ID-4109,                                 
      *             :ASSIGNED-DATETIME-4109,                            
      *             :SERV-ORDER-NO-4109,                                
      *             :TOTAL-RES-4109,                                    
      *             :NO-DAYS-4109,                                      
      *             :SYSTEM-INITIATED-4109,                             
      *             :WORK-TYPES-4109)                                   
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4109
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4109
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4109 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5700'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04109'            TO TABLE-1                     
              MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-1             
              MOVE WORK-AREA-ID-4109     TO HOSTVAR-ELEMENT-1           
              MOVE 'ASSIGNED_DATETIME'   TO TABLE-ELEMENT-2             
              MOVE ASSIGNED-DATETIME-4109 TO HOSTVAR-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4109)                                                
      *       WITH PROCEDURE CSR04109                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4109 CURSOR FOR RESULT SET        
      *       :LOC4109                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
              EXEC SQL                                                  
                  FETCH RESULT_SET_CSR_4109 INTO                        
                      :RETURN-CODE-4109,                                
                      :CALENDAR-DT-4109,                                
                      :GOOD-DAY-4109,                                   
                      :TOTAL-SO-HRS-4109,                               
                      :MAX-RE-PER-DAY-4109,                             
                      :TOTAL-SO-4109,                                   
                      :MAX-DAILY-WK-REQ-4109                            
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-4109 NOT = 0 AND                    
                        RETURN-CODE-4109 NOT = +100                     
                        MOVE RETURN-CODE-4109 TO WS-ACTIVE-RETURN-CODE  
                        MOVE PROGRAM-NAME      TO ABEND-PROGRAM         
                        MOVE '5700'            TO ACTIVE-PARAGRAPH      
                        MOVE 'FETCH'           TO ABEND-FUNCTION        
                        MOVE 'CSR04109'        TO TABLE-1               
                        MOVE 'WORK_AREA_ID'    TO TABLE-ELEMENT-1       
                        MOVE WORK-AREA-ID-4109 TO HOSTVAR-ELEMENT-1     
                        MOVE 'ASSIGNED_DATETIME' TO TABLE-ELEMENT-2     
                        MOVE ASSIGNED-DATETIME-4109 TO HOSTVAR-ELEMENT-2
                        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT       
                   END-IF                                               
                   IF RETURN-CODE-4109 = +100                           
                       SET NO-MORE-ROWS TO TRUE                         
                   ELSE                                                 
                       PERFORM 5710-PROCESS-4109 THRU 5710-EXIT         
                   END-IF                                               
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5700'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04109'            TO TABLE-1              
                     MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-1      
                     MOVE WORK-AREA-ID-4109     TO HOSTVAR-ELEMENT-1    
                     MOVE 'ASSIGNED_DATETIME'   TO TABLE-ELEMENT-2      
                     MOVE ASSIGNED-DATETIME-4109 TO HOSTVAR-ELEMENT-2   
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y' TO SW-FETCH.                                        
                                                                        
       5700-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5710-PROCESS-4109.                                               
                                                                        
           IF WS-GTT06-DECLARED = 'N'                                   
               PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-6.                              
           MOVE CALENDAR-DT-4109 TO S-CALENDAR-DT.                      
           MOVE GOOD-DAY-4109 TO S-GOOD-DAY-FL.                         
           MOVE T8-SCENARIO-SEQ (T8-INDEX) TO S-SCENARIO-SEQ-6          
           MOVE T8-SCENARIO-SEQ-CHOICE (T8-INDEX) TO                    
                S-SCENARIO-SEQ-CHOICE-6                                 
           PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT.                   
           MOVE 'Y' TO WS-SPLIT-CALENDAR-FL.                            
                                                                        
       5710-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5800-CALL-CSR04012.                                              
                                                                        
           MOVE 'N' TO WS-RLSE-REQD-4480.                               
           MOVE AT-COMPANY-NO TO COMPANY-NO-4012.                       
           MOVE PR-REV-DISTRICT-CD TO REV-DISTRICT-CD-4012.             
           MOVE LINK-ASSIGNED-DATETIME TO WANTED-BY-DATE-4012.          
           MOVE 'CIS' TO CALLING-SYSTEM-4012.                           
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-4012.                     
           MOVE L3-RLSE-CHECK-CD TO RLSE-CHECK-CD-4012.                 
           MOVE 'P' TO RLSE-TYPE-4012(2:1).                             
           MOVE WS-PREMISE-NO TO PREMISE-NO-4012.                       
                                                                        
           IF LINK-FUNCTION = 'A'                                       
               MOVE WORK-TYPE-CD-4479-B TO WORK-TYPE-CD-4012            
               MOVE CODE-UTIL-TYPE-4479-B TO CODE-UTIL-TYPE-4012        
                                             RLSE-TYPE-4012(1:1)        
               MOVE METER-STATUS-REASON-4479 TO CODE-STATUS-REAS-4012   
               MOVE IC-NO-4479-B TO WS-IC-NO-NUM                        
               MOVE WS-IC-NO-CHAR TO IC-NO-4012                         
               MOVE MTR-REF-NO-4479-B TO WS-MTR-REF-NO-NUM              
               MOVE WS-MTR-REF-NO-CHAR TO MTR-REF-NO-4012               
               MOVE SUPPLIES-4479 TO RLSE-SUPPLIES-4012                 
               INSPECT RLSE-SUPPLIES-4012 REPLACING ALL LOW-VALUES      
                                                        BY SPACES       
               SET WS-SUPPLYING-INDEX TO +1                             
               SEARCH WS-SUPPLYING-LINE                                 
                   AT END                                               
                       MOVE SPACES TO METER-SUPPLYING-CD-4012           
                   WHEN SUPPLIES-4479 =                                 
                        WS-SUPPLYING-DESC (WS-SUPPLYING-INDEX)          
                            MOVE WS-SUPPLYING-CD (WS-SUPPLYING-INDEX) TO
                                 METER-SUPPLYING-CD-4012                
               END-SEARCH                                               
           ELSE                                                         
               IF WS-SPLIT-RLSE-FL = 'N'                                
                   MOVE WS-WORK-TYPE-SUB (WS-SUB1) TO WORK-TYPE-CD-4012 
               END-IF                                                   
               MOVE WS-CODE-UTIL-TYPE-SUB (WS-SUB1) TO                  
                    CODE-UTIL-TYPE-4012                                 
                    RLSE-TYPE-4012(1:1)                                 
                    MN-CODE-UTIL-TYPE                                   
               IF WS-IC-NO-SUB (WS-SUB1) NOT NUMERIC                    
                   MOVE ZEROES TO WS-IC-NO-SUB (WS-SUB1)                
               END-IF                                                   
               MOVE WS-IC-NO-SUB (WS-SUB1) TO IC-NO-4012                
                                              WS-IC-CHAR                
               MOVE WS-IC-NUM TO MN-IC-NO                               
               IF WS-MTR-REF-SUB (WS-SUB1) NOT NUMERIC                  
                   MOVE ZEROES TO WS-MTR-REF-SUB (WS-SUB1)              
               END-IF                                                   
               MOVE WS-MTR-REF-SUB (WS-SUB1) TO MTR-REF-NO-4012         
                                                WS-MTR-REF-CHAR         
               MOVE WS-MTR-REF-NUM TO MN-MTR-REF-NO                     
               PERFORM 7450-GET-MTRENV THRU 7450-EXIT                   
               MOVE MN-CODE-STATUS-REAS TO CODE-STATUS-REAS-4012        
               MOVE MN-METER-SUPPLYING TO RLSE-SUPPLIES-4012            
               INSPECT RLSE-SUPPLIES-4012 REPLACING ALL LOW-VALUES      
                                                        BY SPACES       
P00795         IF LINK-ORDER-TYPE-CD = 'FM002' AND                      
P00795            WS-SUPPLYING-SUB (WS-SUB1) > SPACES                   
P00795            MOVE WS-SUPPLYING-SUB (WS-SUB1) TO RLSE-SUPPLIES-4012 
P00795                                               MN-METER-SUPPLYING 
P00795         END-IF                                                   
               INSPECT MN-METER-SUPPLYING REPLACING ALL LOW-VALUES      
                                                        BY SPACES       
               INSPECT RLSE-SUPPLIES-4012 REPLACING ALL LOW-VALUES      
                                                        BY SPACES       
               SET WS-SUPPLYING-INDEX TO +1                             
               SEARCH WS-SUPPLYING-LINE                                 
                   AT END                                               
                       MOVE SPACES TO METER-SUPPLYING-CD-4012           
                   WHEN MN-METER-SUPPLYING =                            
                        WS-SUPPLYING-DESC (WS-SUPPLYING-INDEX)          
                            MOVE WS-SUPPLYING-CD (WS-SUPPLYING-INDEX) TO
                                 METER-SUPPLYING-CD-4012                
               END-SEARCH
           END-IF.                                              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04012                                             
      *           (:COMPANY-NO-4012,                                    
      *            :REV-DISTRICT-CD-4012,                               
      *            :CODE-UTIL-TYPE-4012,                                
      *            :ORDER-TYPE-CD-4012,                                 
      *            :WORK-TYPE-CD-4012,                                  
      *            :RLSE-CHECK-CD-4012,                                 
      *            :ACCOUNT-NO-4012,                                    
      *            :IC-NO-4012,                                         
      *            :MTR-REF-NO-4012,                                    
      *            :METER-SUPPLYING-CD-4012,                            
      *            :CODE-STATUS-REAS-4012,                              
      *            :CALLING-SYSTEM-4012,                                
      *            :WANTED-BY-DATE-4012,                                
      *            :PREMISE-NO-4012,                                    
      *            :RLSE-TYPE-4012,                                     
      *            :RLSE-SUPPLIES-4012)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4012
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4012
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4012 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5800'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04012'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4012       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE REV-DISTRICT-CD-4012  TO HOSTVAR-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE CODE-UTIL-TYPE-4012   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4012)                                                
      *       WITH PROCEDURE CSR04012                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4012 CURSOR FOR RESULT SET        
      *       :LOC4012                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4012 INTO                            
                 :RETURN-CODE-4012,                                     
                 :RLSE-REQUIRED-FL-4012,                                
                 :MESSAGE-4012,                                         
                 :ADTL-MESSAGE-4012,                                    
                 :PHONE-4012,                                           
                 :ALT-PHONE-4012,                                       
                 :UTIL-TYPE-4012,                                       
                 :REV-DIST-DESC-4012,                                   
                 :RLSE-EXISTS-4012,                                     
                 :RLSE-NO-4012                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4012 NOT = 0 AND                      
                      RETURN-CODE-4012 NOT = 100                        
                          IF RLSE-REQUIRED-FL-4012 = 'E' AND            
                             WS-SPLIT-RLSE-FL = 'N'                     
                                 PERFORM 5810-MANUAL-RELEASE-CHECK THRU 
                                         5810-EXIT                      
                          ELSE                                          
                              MOVE RETURN-CODE-4012 TO                  
                                   WS-ACTIVE-RETURN-CODE                
                                   S-STATUS-CODE                        
                              MOVE PROGRAM-NAME TO ABEND-PROGRAM        
                              MOVE '5800'     TO ACTIVE-PARAGRAPH       
                              MOVE 'FETCH'    TO ABEND-FUNCTION         
                              MOVE 'CSR04012' TO TABLE-1                
                              MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1      
                              MOVE ACCOUNT-NO-4012 TO HOSTVAR-ELEMENT-1 
                              MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2 
                              MOVE REV-DISTRICT-CD-4012 TO              
                                   HOSTVAR-ELEMENT-2                    
                              MOVE 'CODE_UTIL_TYPE' TO TABLE-ELEMENT-3  
                              MOVE CODE-UTIL-TYPE-4012 TO               
                                   HOSTVAR-ELEMENT-3                    
                              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT 
                          END-IF                                        
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5800'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04012'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-4012       TO HOSTVAR-ELEMENT-1      
                   MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2        
                   MOVE REV-DISTRICT-CD-4012  TO HOSTVAR-ELEMENT-2      
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3        
                   MOVE CODE-UTIL-TYPE-4012   TO HOSTVAR-ELEMENT-3      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF WS-SPLIT-RLSE-FL = 'Y'                                    
               GO TO 5800-EXIT
           END-IF.                                         
                                                                        
           MOVE RLSE-REQUIRED-FL-4012 TO T4-RLSE-REQUIRED (T4-INDEX).   
           IF RLSE-REQUIRED-FL-4012 = 'Y' OR 'E'                        
A05189         MOVE 'Y' TO WS-RLSE-REQD-4480
           END-IF.                           
               IF RLSE-EXISTS-4012 = 'Y'                                
                   MOVE RLSE-NO-4012 TO T4-RLSE-NO (T4-INDEX)           
A05189             MOVE 'N' TO WS-RLSE-REQD-4480                        
               ELSE                                                     
                   MOVE MESSAGE-4012 TO T4-RLSE-MSG (T4-INDEX)          
                   MOVE ADTL-MESSAGE-4012 TO T4-RLSE-ADDL-MSG (T4-INDEX)
                   MOVE PHONE-4012 TO T4-RLSE-PHONE (T4-INDEX)          
                   MOVE ALT-PHONE-4012 TO T4-RLSE-ALT-PHONE (T4-INDEX)  
                   MOVE REV-DIST-DESC-4012 TO                           
                        T4-RLSE-REV-DIST (T4-INDEX)                     
                   MOVE 'P' TO T4-ACTION-TYPE-CD (T4-INDEX) (1:1)       
                   MOVE MESSAGE-4012 TO                                 
                        T4-ACTION-TYPE-CD (T4-INDEX) (2:5)              
                   MOVE 'ORDR000039' TO T4-BUS-RULE-ID (T4-INDEX)       
                                        S-BUS-RULE-ID                   
                   PERFORM 7013-RULE-XREF THRU 7013-EXIT                
                   MOVE 1T-BUS-RULE-XREF-ID TO                          
                        T4-BUS-RULE-XREF-ID (T4-INDEX)
               END-IF.                 
                                                                        
       5800-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5810-MANUAL-RELEASE-CHECK.                                       
                                                                        
           MOVE 'RE006' TO S-RLSE-MSG.                                  
           MOVE ADTL-MESSAGE-4012 TO S-RLSE-ADDL-MSG.                   
           MOVE PHONE-4012 TO S-RLSE-PHONE.                             
           MOVE ALT-PHONE-4012 TO S-RLSE-ALT-PHONE.                     
           MOVE REV-DIST-DESC-4012 TO S-RLSE-REV-DIST.                  
           MOVE 'ORDR000039' TO S-BUS-RULE-ID-4.                        
           MOVE 'P' TO S-ACTION-TYPE-CD-4.                              
           PERFORM 7013-RULE-XREF THRU 7013-EXIT.                       
           MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID-4.            
                                                                        
       5810-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5900-CALL-CSR04281.                                              
                                                                        
           MOVE LINK-NEW-CUSTOMER-NO TO CUSTOMER-NO-4281.               
           MOVE AT-COMPANY-NO TO COMPANY-NO-4281.                       
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04281                                             
      *           (:CUSTOMER-NO-4281,                                   
      *            :COMPANY-NO-4281)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4281
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4281
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4281 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5900'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04281'            TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CUSTOMER-NO-4281      TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE COMPANY-NO-4281       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4281)                                                
      *       WITH PROCEDURE CSR04281                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4281 CURSOR FOR RESULT SET        
      *       :LOC4281                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_4281 INTO                          
                   :RETURN-CODE-4281,                                   
                   :ACCOUNT-NO-4281,                                    
                   :CODE-ACCT-STAT-4281,                                
                   :PAST-DUE-UTIL-4281,                                 
                   :PAST-DUE-NONUTIL-4281,                              
                   :CUST-TYPE-4281,                                     
                   :SSN-4281,                                           
                   :SERV-ADDRESS-4281,                                  
                   :CIA-4281,                                           
                   :BILLED-BALANCE-4281,                                
                   :DEPOSIT-DUE-4281,                                   
                   :PAYMENTS-4281,                                      
                   :PSNC-LABOR-CHG-4281,                                
                   :RET-CHECK-FL-4281,                                  
                   :NAME-4281,                                          
                   :TOTAL-DUE-4281                                      
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-4281 NOT = 0 AND                    
                        RETURN-CODE-4281 NOT = +100                     
                          MOVE RETURN-CODE-4281 TO WS-ACTIVE-RETURN-CODE
                          MOVE PROGRAM-NAME      TO ABEND-PROGRAM       
                          MOVE '5900'            TO ACTIVE-PARAGRAPH    
                          MOVE 'FETCH'           TO ABEND-FUNCTION      
                          MOVE 'CSR04281'        TO TABLE-1             
                          MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1     
                          MOVE CUSTOMER-NO-4281  TO HOSTVAR-ELEMENT-1   
                          MOVE 'COMPANY_NO'      TO TABLE-ELEMENT-2     
                          MOVE COMPANY-NO-4281   TO HOSTVAR-ELEMENT-2   
                          PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT     
                     END-IF                                             
                     IF RETURN-CODE-4281 = +100                         
                         SET NO-MORE-ROWS TO TRUE                       
                     ELSE                                               
                         ADD TOTAL-DUE-4281 TO WS-TOTAL-DUE             
                     END-IF                                             
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5900'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04281'            TO TABLE-1              
                     MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1      
                     MOVE CUSTOMER-NO-4281      TO HOSTVAR-ELEMENT-1    
                     MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2      
                     MOVE COMPANY-NO-4281       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y' TO SW-FETCH.                                        
                                                                        
       5900-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
A05189*   CHECK IF ORDER ELIGIBLE FOR AROP                                      
      *                                                                         
A05189 5910-CALL-CSR04849.                                              
A05189                                                                  
A05189     MOVE WS-ACCOUNT-NO  TO ACCOUNT-NO-4849.                      
A05189     MOVE WS-PREMISE-NO  TO PREMISE-NO-4849.                      
A05189     MOVE ZEROS          TO SERV-ORDER-NO-4849.                   
A05189                                                                  
A05189*    EXEC SQL                                                     
A05189*       CALL CSR04849                                             
A05189*            (:ACCOUNT-NO-4849,                                   
A05189*             :PREMISE-NO-4849,                                   
A05189*             :SERV-ORDER-NO-4849)                                
A05189*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4849
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4849
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4849 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A05189                                                                  
A05189     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05189                                                                  
A05189     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
A05189        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A05189        MOVE '3200'                TO ACTIVE-PARAGRAPH            
A05189        MOVE 'CALL'                TO ABEND-FUNCTION              
A05189        MOVE 'CSR04849'            TO TABLE-1                     
A05189        MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
A05189        MOVE ACCOUNT-NO-4849       TO HOSTVAR-ELEMENT-1           
A05189        MOVE 'PREMISE-NO'          TO TABLE-ELEMENT-2             
A05189        MOVE PREMISE-NO-4849       TO HOSTVAR-ELEMENT-2           
A05189        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A05189     END-IF.                                                      
A05189                                                                  
A05189*    EXEC SQL                                                     
A05189*       ASSOCIATE LOCATORS                                        
A05189*       (:LOC4849)                                                
A05189*       WITH PROCEDURE CSR04849                                   
A05189*    END-EXEC.                                                    
A05189                                                                  
A05189*    EXEC SQL                                                     
A05189*       ALLOCATE RESULT_SET_CSR_4849 CURSOR FOR RESULT SET        
A05189*       :LOC4849                                                  
A05189*    END-EXEC.                                                    
A05189                                                                  
A05189     EXEC SQL                                                     
A05189         FETCH RESULT_SET_CSR_4849 INTO                           
A05189             :RETURN-CODE-4849 ,                                  
A05189             :AROP-ELIGIBLE-FL-4849                               
A05189     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05189                                                                  
A05189     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A05189     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05189         WHEN SUCCESSFUL-CALL                                     
A05189             CONTINUE                                             
A05189         WHEN NOT-FOUND                                           
A05189             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05189             MOVE 'N' TO AROP-ELIGIBLE-FL-4849                    
A05189         WHEN OTHER                                               
A05189             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
A05189             MOVE '5910'                TO ACTIVE-PARAGRAPH       
A05189             MOVE 'FETCH'               TO ABEND-FUNCTION         
A05189             MOVE 'CSR04849'            TO TABLE-1                
A05189             MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1        
A05189             MOVE ACCOUNT-NO-4849       TO HOSTVAR-ELEMENT-1      
A05189             MOVE 'PREMISE-NO'          TO TABLE-ELEMENT-2        
A05189             MOVE PREMISE-NO-4849       TO HOSTVAR-ELEMENT-2      
A05189             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05189     END-EVALUATE.                                                
A05189*                                                                         
A05189 5910-EXIT.                                                       
A05189      EXIT.                                                       
      *                                                                         
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     AT.COMPANY_NO,                                     
                     AT.LOCAL_OFFICE,                                   
                     SERV_ORDER_WORK_CD                                 
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-COMPANY-NO,                                    
                     :AT-LOCAL-OFFICE,                                  
                     :B1-SERV-ORDER-WORK-CD                             
                FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
                     CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                  
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND B1.COMPANY_NO = AT.COMPANY_NO                      
                 AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              SERV_ORDER_WORK_CD                                         
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-LOCAL-OFFICE,                                          
MFA-TR*              :B1-SERV-ORDER-WORK-CD                                     
MFA-TR*         FROM CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_LOCAL_OFFICE B1                                        
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND B1.COMPANY_NO = AT.COMPANY_NO                              
MFA-TR*          AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'CSS_LOCAL_OFFICE'  TO TABLE-3                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-DELINQ.                                              
                                                                        
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
                INTO :C8-DELINQ-VALUE                                   
                FROM  CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD  = 'DATABASE'                           
                 AND  COMPANY_NO = :AT-COMPANY-NO                       
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM  CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD  = 'DATABASE'                                   
MFA-TR*          AND  COMPANY_NO = :AT-COMPANY-NO                               
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 70101                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE C8-DELINQ-VALUE TO WS-DATABASE                      
           ELSE                                                         
               MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
               MOVE '7010'             TO ACTIVE-PARAGRAPH              
               MOVE 'SELECT'           TO ABEND-FUNCTION                
               MOVE SPACES             TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
               MOVE 'CSS_DELINQUENCY'  TO TABLE-1                       
               MOVE 'DELINQ_VALUE'     TO TABLE-ELEMENT-1               
               MOVE 'DATABASE'         TO HOSTVAR-ELEMENT-1             
               MOVE 'COMPANY_NO'       TO TABLE-ELEMENT-2               
               MOVE AT-COMPANY-NO      TO HOSTVAR-ELEMENT-2             
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
A04670     EXEC SQL                                                     
A04670        SELECT C8.DELINQ_VALUE                                    
A04670          INTO :WS-THRESHOLD                                      
A04670          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
A04670         WHERE C8.DELINQ_CD   = 'AMT-STRTUP-THRESHOLD'            
A04670           AND  COMPANY_NO    = :AT-COMPANY-NO                    
A04670                                                           
A04670                                                     
A04670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :WS-THRESHOLD                                              
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD   = 'AMT-STRTUP-THRESHOLD'                    
MFA-TR*          AND  COMPANY_NO    = :AT-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 70102                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04670                                                                  
A04670     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04670     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04670         WHEN SUCCESSFUL-CALL                                     
A04670             CONTINUE                                             
A04670         WHEN NOT-FOUND                                           
A04670             MOVE 0.00 TO WS-THRESHOLD                            
A04670         WHEN OTHER                                               
A04670             MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
A04670             MOVE '7010'                   TO ACTIVE-PARAGRAPH    
A04670             MOVE 'SELECT'                 TO ABEND-FUNCTION      
A04670             MOVE SPACES                   TO ABEND-SQL-PREDICATES
A04670                                             ABEND-TABLES         
A04670             MOVE 'CSS_DELINQUENCY'        TO TABLE-1             
A04670             MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1     
A04670             MOVE 'AMT-STRTUP-THRESHOLD'   TO HOSTVAR-ELEMENT-1   
A04670             MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2     
A04670             MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2   
A04670             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A04670     END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7013-RULE-XREF.                                                  
                                                                        
           MOVE S-BUS-RULE-ID TO 1T-BUS-RULE-ID.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                    
               WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                   
                 AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                
                 AND APPLICATION_ID = 'CSR'                             
                 AND COMPANY_NO     = '00'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE_XREF                                          
MFA-TR*        WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                           
MFA-TR*          AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                        
MFA-TR*          AND APPLICATION_ID = 'CSR'                                     
MFA-TR*          AND COMPANY_NO     = '00'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7013                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID       
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BUS-RULE-XREF-ID                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7013'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_RULE_XREF' TO TABLE-1                  
                   MOVE 'BUS_RULE_ID'       TO TABLE-ELEMENT-1          
                   MOVE 1T-BUS-RULE-ID      TO HOSTVAR-ELEMENT-1        
                   MOVE 'BUS_PROCESS_ID'    TO TABLE-ELEMENT-2          
                   MOVE 1T-BUS-PROCESS-ID   TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7013-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-WORK-AREA.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) WORK_AREA_TX                                       
                INTO :I2-WORK-AREA-TX                                   
                FROM CSS_WORK_AREA WITH(READUNCOMMITTED)                        
               WHERE WORK_AREA_ID = :I2-WORK-AREA-ID                    
                 AND WORK_AREA_TX LIKE '%GAS%'                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT WORK_AREA_TX                                               
MFA-TR*         INTO :I2-WORK-AREA-TX                                           
MFA-TR*         FROM CSS_WORK_AREA                                              
MFA-TR*        WHERE WORK_AREA_ID = :I2-WORK-AREA-ID                            
MFA-TR*          AND WORK_AREA_TX LIKE '%GAS%'                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-HEAT-WK-AREA-FL                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-HEAT-WK-AREA-FL                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_WORK_AREA'     TO TABLE-1                  
                   MOVE 'WORK_AREA_ID'      TO TABLE-ELEMENT-1          
                   MOVE I2-WORK-AREA-ID     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-RELEASE-RQMT.                                               
                                                                        
           MOVE SPACES TO L3-RLSE-CHECK-CD.                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RLSE_CHECK_CD                                     
                 INTO :L3-RLSE-CHECK-CD                                 
                 FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                   
                WHERE ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                 
                  AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                  
                  AND COMPANY_NO    = :AT-COMPANY-NO                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RLSE_CHECK_CD                                             
MFA-TR*          INTO :L3-RLSE-CHECK-CD                                         
MFA-TR*          FROM CSS_ORDER_WK_TYPE                                         
MFA-TR*         WHERE ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                         
MFA-TR*           AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                          
MFA-TR*           AND COMPANY_NO    = :AT-COMPANY-NO                            
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ' ' TO L3-RLSE-CHECK-CD                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER_WK_TYPE'  TO TABLE-1                 
                   MOVE 'ORDER_TYPE_CD'      TO TABLE-ELEMENT-1         
                   MOVE L3-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
                   MOVE 'WORK_TYPE_CD'       TO TABLE-ELEMENT-2         
                   MOVE L3-WORK-TYPE-CD      TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-LANDLORD.                                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO                                       
                 INTO :SI-CUSTOMER-NO                                   
                 FROM CSS_LANDLORD WITH(READUNCOMMITTED)                        
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :SI-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF SI-CUSTOMER-NO = WS-NEW-CUSTOMER-NO-NUM           
                       MOVE 'Y' TO WS-NEW-CUST-IS-LL-FL                 
                   ELSE                                                 
                       MOVE 'N' TO WS-NEW-CUST-IS-LL-FL                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-NEW-CUST-IS-LL-FL                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_LANDLORD'   TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE L3-WORK-TYPE-CD      TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-GET-ZIP.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DY.ZIP_CODE,
              REV_DISTRICT_CD,
              CODE_RENTAL_PROP,
              FM_ELEC_SVC_WKDIST,
              FM_GAS_OPS_WKDIST,
              FM_FLD_SVCS_WKDIST,
              FM_REV_PRT_WKDIST,
              FM_DSM_ESVC_WKDIST                                
                 INTO :DY-ZIP-CODE,                                     
                      :PR-REV-DISTRICT-CD,                              
A04670                :PR-CODE-RENTAL-PROP,                             
P00718                :PR-FM-ELEC-SVC-WKDIST,                           
P00718                :PR-FM-GAS-OPS-WKDIST,                            
P00718                :PR-FM-FLD-SVCS-WKDIST,                           
P00718                :PR-FM-REV-PRT-WKDIST,                            
P00718                :PR-FM-DSM-ESVC-WKDIST                            
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND PR.ADDRESS_ID = DY.ADDRESS_ID                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DY.ZIP_CODE,                                              
MFA-TR*               REV_DISTRICT_CD,                                          
MFA-TR*               CODE_RENTAL_PROP,                                         
MFA-TR*               FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST                                        
MFA-TR*          INTO :DY-ZIP-CODE,                                             
MFA-TR*               :PR-REV-DISTRICT-CD,                                      
MFA-TR*               :PR-CODE-RENTAL-PROP,                                     
MFA-TR*               :PR-FM-ELEC-SVC-WKDIST,                                   
MFA-TR*               :PR-FM-GAS-OPS-WKDIST,                                    
MFA-TR*               :PR-FM-FLD-SVCS-WKDIST,                                   
MFA-TR*               :PR-FM-REV-PRT-WKDIST,                                    
MFA-TR*               :PR-FM-DSM-ESVC-WKDIST                                    
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND PR.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO DY-ZIP-CODE                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
D26070 7205-GET-SO-DATA.                                                
                                                                        
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-CHAR.            
           MOVE WS-SERV-ORDER-NO-NUM TO VO-SERV-ORDER-NO.               
           EXEC SQL                                                     
               SELECT WORK_AREA_ID                                      
                 INTO :VO-WORK-AREA-ID                                  
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_AREA_ID                                              
MFA-TR*          INTO :VO-WORK-AREA-ID                                          
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7205                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7205'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7205-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-WORK-TYPE.                                                  
                                                                        
A05189     MOVE AT-COMPANY-NO TO L4-COMPANY-NO.                         
           EXEC SQL                                                     
               SELECT TOP(1) EST_LABOR_HRS,
              AROP_EXTRACT_IND                                  
                 INTO :L4-EST-LABOR-HRS,                                
A05189                :L4-AROP-EXTRACT-IND                              
                 FROM CSS_WORK_TYPE WITH(READUNCOMMITTED)                       
                WHERE WORK_TYPE_CD = :L4-WORK-TYPE-CD                   
A05189            AND COMPANY_NO   = :L4-COMPANY-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EST_LABOR_HRS,                                            
MFA-TR*               AROP_EXTRACT_IND                                          
MFA-TR*          INTO :L4-EST-LABOR-HRS,                                        
MFA-TR*               :L4-AROP-EXTRACT-IND                                      
MFA-TR*          FROM CSS_WORK_TYPE                                             
MFA-TR*         WHERE WORK_TYPE_CD = :L4-WORK-TYPE-CD                           
MFA-TR*           AND COMPANY_NO   = :L4-COMPANY-NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   ADD L4-EST-LABOR-HRS TO WS-WK-TOTAL-RES              
A05189             MOVE L4-AROP-EXTRACT-IND TO WS-READ-ONLY-ORDER       
               WHEN NOT-FOUND                                           
                   MOVE 1 TO L4-EST-LABOR-HRS                           
A05189             MOVE 'N' TO WS-READ-ONLY-ORDER                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7250'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_WORK_TYPE'     TO TABLE-1                  
                   MOVE 'WORK_TYPE_CD'      TO TABLE-ELEMENT-1          
                   MOVE L4-WORK-TYPE-CD     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-READ-ROUTE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) READ_ROUTE                                        
                 INTO :UT-READ-ROUTE                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND READ_ROUTE > 0                                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_ROUTE                                                
MFA-TR*          INTO :UT-READ-ROUTE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND READ_ROUTE > 0                                            
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO UT-READ-ROUTE                         
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-GET-POINT-ID.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) GIS_POINT_ID                                      
                 INTO :MN-GIS-POINT-ID                                  
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND GIS_POINT_ID > 0                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GIS_POINT_ID                                              
MFA-TR*          INTO :MN-GIS-POINT-ID                                          
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND GIS_POINT_ID > 0                                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO MN-GIS-POINT-ID                       
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7450-GET-MTRENV.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CODE_STATUS_REAS,
              METER_SUPPLYING                                   
                 INTO :MN-CODE-STATUS-REAS,                             
                      :MN-METER-SUPPLYING                               
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE               
                  AND IC_NO = :MN-IC-NO                                 
                  AND MTR_REF_NO = :MN-MTR-REF-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_STATUS_REAS,                                         
MFA-TR*               METER_SUPPLYING                                           
MFA-TR*          INTO :MN-CODE-STATUS-REAS,                                     
MFA-TR*               :MN-METER-SUPPLYING                                       
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :MN-IC-NO                                         
MFA-TR*           AND MTR_REF_NO = :MN-MTR-REF-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7450                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO MN-METER-SUPPLYING                    
                                  MN-CODE-STATUS-REAS                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7450'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   MOVE 'CODE_UTIL_TYPE' TO TABLE-ELEMENT-2             
                   MOVE MN-CODE-UTIL-TYPE TO HOSTVAR-ELEMENT-2          
                   MOVE 'IC_NO'          TO TABLE-ELEMENT-3             
                   MOVE MN-IC-NO         TO HOSTVAR-ELEMENT-3           
                   MOVE 'MTR_REF_NO'     TO TABLE-ELEMENT-4             
                   MOVE MN-MTR-REF-NO    TO HOSTVAR-ELEMENT-4           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-GET-PREM-LOCOFF.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PR.LOCAL_OFFICE,
              SERV_ORDER_WORK_CD,
              PR.COMPANY_NO                                     
                 INTO :AT-LOCAL-OFFICE,                                 
                      :B1-SERV-ORDER-WORK-CD,                           
P00795                :PR-COMPANY-NO                                    
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                 
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND B1.COMPANY_NO = PR.COMPANY_NO                     
                  AND B1.LOCAL_OFFICE = PR.LOCAL_OFFICE                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PR.LOCAL_OFFICE,                                          
MFA-TR*               SERV_ORDER_WORK_CD,                                       
MFA-TR*               PR.COMPANY_NO                                             
MFA-TR*          INTO :AT-LOCAL-OFFICE,                                         
MFA-TR*               :B1-SERV-ORDER-WORK-CD,                                   
MFA-TR*               :PR-COMPANY-NO                                            
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_LOCAL_OFFICE B1                                       
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND B1.COMPANY_NO = PR.COMPANY_NO                             
MFA-TR*           AND B1.LOCAL_OFFICE = PR.LOCAL_OFFICE                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO AT-LOCAL-OFFICE                       
                                  B1-SERV-ORDER-WORK-CD                 
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7500'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'CSS_LOCAL_OFFICE'  TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05821 7510-BUILDER-REALTOR.                                            
A05821                                                                  
A05821     MOVE WS-NEW-CUSTOMER-NO-NUM TO LQ-CUSTOMER-NO                
A05821     EXEC SQL                                                     
A05821        SELECT BUILDER_FL,                                        
A05821               REALTOR_FL                                         
A05821          INTO :LQ-BUILDER-FL,                                    
A05821               :LQ-REALTOR-FL                                     
A05821          FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
A05821         WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                      
A05821                                                           
A05821                                                      
A05821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUILDER_FL,                                                
MFA-TR*              REALTOR_FL                                                 
MFA-TR*         INTO :LQ-BUILDER-FL,                                            
MFA-TR*              :LQ-REALTOR-FL                                             
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05821                                                                  
A05821     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
A05821                                                                  
A05821     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05821         WHEN SUCCESSFUL-CALL                                     
A05821             IF LQ-BUILDER-FL = 'Y' OR                            
A05821                LQ-REALTOR-FL = 'Y'                               
A05821                    MOVE 'Y' TO WS-CUST-BLDR-RLTR-FL              
A05821             ELSE                                                 
A05821                 MOVE 'N' TO WS-CUST-BLDR-RLTR-FL                 
A05821             END-IF                                               
A05821         WHEN NOT-FOUND                                           
A05821             MOVE 'N' TO WS-CUST-BLDR-RLTR-FL                     
A05821             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05821         WHEN OTHER                                               
A05821             MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
A05821             MOVE '7510'        TO ACTIVE-PARAGRAPH               
A05821             MOVE 'SELECT'      TO ABEND-FUNCTION                 
A05821             MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
A05821             MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
A05821             MOVE LQ-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
A05821             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05821     END-EVALUATE.                                                
A05821                                                                  
A05821 7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-OPEN-APPL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN APPL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7600'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7610-CLOSE-APPL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE APPL-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7610'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04670 7700-COUNT-PENDING-OFF.                                          
A04670                                                                  
A04670     EXEC SQL                                                     
A04670        SELECT COUNT(*)                                           
A04670          INTO :WS-COUNT                                          
A04670          FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
A04670         WHERE PREMISE_NO      = :PR-PREMISE-NO                   
A04670           AND ORDER_TYPE_CD   LIKE 'OFF%'                        
A04670           AND ORDER_STATE_CD  NOT IN ('C', 'Z')                  
A04670                                                           
A04670                                                      
A04670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-COUNT                                                  
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO      = :PR-PREMISE-NO                           
MFA-TR*          AND ORDER_TYPE_CD   LIKE 'OFF%'                                
MFA-TR*          AND ORDER_STATE_CD  NOT IN ('C', 'Z')                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04670                                                                  
A04670     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A04670                                                                  
A04670     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04670         WHEN SUCCESSFUL-CALL                                     
A04670             EVALUATE WS-COUNT                                    
A04670                 WHEN 0                                           
A04670                     MOVE 'OFF01' TO S-RECALC-ORDER-TYPE-CD       
A04670                 WHEN 1                                           
A04670                     MOVE 'OFF02' TO S-RECALC-ORDER-TYPE-CD       
A04670                 WHEN 2                                           
A04670                     MOVE 'OFF03' TO S-RECALC-ORDER-TYPE-CD       
A04670                 WHEN OTHER                                       
A04670                     MOVE PROGRAM-NAME TO ABEND-PROGRAM           
A04670                     MOVE +111        TO ABEND-SQLCODE            
A04670                     MOVE SQLSTATE    TO ABEND-SQLSTATE           
A04670                     MOVE '7700'      TO ACTIVE-PARAGRAPH         
A04670                     MOVE 'SELECT'    TO ABEND-FUNCTION           
A04670                     MOVE 'CSS_SO_DATA' TO TABLE-1                
A04670                     MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1         
A04670                     MOVE 'ORDER TYPE' TO TABLE-ELEMENT-2         
A04670                     MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1      
A04670                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT    
A04670             END-EVALUATE                                         
A04670         WHEN NOT-FOUND                                           
A04670             MOVE 0 TO WS-COUNT                                   
A04670             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A04670         WHEN OTHER                                               
A04670             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A04670             MOVE SQLCODE             TO ABEND-SQLCODE            
A04670             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A04670             MOVE '7700'              TO ACTIVE-PARAGRAPH         
A04670             MOVE 'SELECT'            TO ABEND-FUNCTION           
A04670             MOVE 'CSS_SO_DATA'       TO TABLE-1                  
A04670             MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
A04670             MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
A04670             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A04670     END-EVALUATE.                                                
A04670                                                                  
A04670 7700-EXIT.                                                       
A04670     EXIT.                                                        
A04670                                                                  
A04670 7750-COUNT-PENDING-CC.                                           
A04670                                                                  
A04670     EXEC SQL                                                     
A04670        SELECT COUNT(*)                                           
A04670          INTO :WS-COUNT                                          
A04670          FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
A04670         WHERE PREMISE_NO      = :PR-PREMISE-NO                   
A04670           AND ORDER_TYPE_CD   LIKE 'CC%'                         
A04670           AND ORDER_STATE_CD  NOT IN ('C', 'Z')                  
A04670                                                           
A04670                                                      
A04670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-COUNT                                                  
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO      = :PR-PREMISE-NO                           
MFA-TR*          AND ORDER_TYPE_CD   LIKE 'CC%'                                 
MFA-TR*          AND ORDER_STATE_CD  NOT IN ('C', 'Z')                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7750                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04670                                                                  
A04670     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
A04670                                                                  
A04670     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04670         WHEN SUCCESSFUL-CALL                                     
A04670             EVALUATE WS-COUNT                                    
A04670                 WHEN 0                                           
A04670                     MOVE 'CC001' TO S-RECALC-ORDER-TYPE-CD       
A04670                 WHEN 1                                           
A04670                     MOVE 'CC002' TO S-RECALC-ORDER-TYPE-CD       
A04670                 WHEN 2                                           
A04670                     MOVE 'CC003' TO S-RECALC-ORDER-TYPE-CD       
A04670                 WHEN OTHER                                       
A04670                     MOVE PROGRAM-NAME TO ABEND-PROGRAM           
A04670                     MOVE +111        TO ABEND-SQLCODE            
A04670                     MOVE SQLSTATE    TO ABEND-SQLSTATE           
A04670                     MOVE '7750'      TO ACTIVE-PARAGRAPH         
A04670                     MOVE 'SELECT'    TO ABEND-FUNCTION           
A04670                     MOVE 'CSS_SO_DATA' TO TABLE-1                
A04670                     MOVE 'PREMISE_NO' TO TABLE-ELEMENT-1         
A04670                     MOVE 'ORDER TYPE' TO TABLE-ELEMENT-2         
A04670                     MOVE PR-PREMISE-NO TO HOSTVAR-ELEMENT-1      
A04670                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT    
A04670             END-EVALUATE                                         
A04670         WHEN NOT-FOUND                                           
A04670             MOVE 0 TO WS-COUNT                                   
A04670             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A04670         WHEN OTHER                                               
A04670             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
A04670             MOVE SQLCODE             TO ABEND-SQLCODE            
A04670             MOVE SQLSTATE            TO ABEND-SQLSTATE           
A04670             MOVE '7750'              TO ACTIVE-PARAGRAPH         
A04670             MOVE 'SELECT'            TO ABEND-FUNCTION           
A04670             MOVE 'CSS_SO_DATA'       TO TABLE-1                  
A04670             MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
A04670             MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
A04670             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A04670     END-EVALUATE.                                                
A04670                                                                  
A04670 7750-EXIT.                                                       
A04670     EXIT.                                                        
                                                                        
P00718 7760-GET-PRINT-LOC.                                              
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         SELECT CAD_WORKAREA_FL                                   
P00718           INTO :C4-CAD-WORKAREA-FL                               
P00718           FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                    
P00718          WHERE WORK_AREA_ID = :WORK-AREA-1116                    
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CAD_WORKAREA_FL                                           
MFA-TR*          INTO :C4-CAD-WORKAREA-FL                                       
MFA-TR*          FROM CSS_SO_PRINT_LOC                                          
MFA-TR*         WHERE WORK_AREA_ID = :WORK-AREA-1116                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7760                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN NOT-FOUND                                           
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7760'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_SO_PRINT_LOC' TO TABLE-1                   
P00718             MOVE 'WORK_AREA_ID'   TO TABLE-ELEMENT-1             
P00718             MOVE WORK-AREA-1116   TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7760-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P00718 7770-GET-REGISTER-DTLS.                                          
P00718                                                                  
P00718     EXEC SQL                                                     
P00718        SELECT TOP(1) 'Y'                                                
P00718          INTO :WS-MULTI-REG-MTR                                  
P00718          FROM CSS_REGISTER_READ RG WITH(READUNCOMMITTED),                
P00718               CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
P00718         WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO               
P00718           AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                
P00718           AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE            
P00718           AND MN.METER_NO         = RG.METER_NO                  
P00718           AND MN.IC_NO            = RG.IC_NO                     
P00718           AND MN.MTR_REF_NO       = RG.MTR_REF_NO                
P00718                                            
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-MULTI-REG-MTR                                          
MFA-TR*         FROM CSS_REGISTER_READ RG,                                      
MFA-TR*              CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO                       
MFA-TR*          AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                        
MFA-TR*          AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE                    
MFA-TR*          AND MN.METER_NO         = RG.METER_NO                          
MFA-TR*          AND MN.IC_NO            = RG.IC_NO                             
MFA-TR*          AND MN.MTR_REF_NO       = RG.MTR_REF_NO                        
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7770                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN -811                                                
P00718             CONTINUE                                             
P00718         WHEN NOT-FOUND                                           
P00718             MOVE 'N'              TO WS-MULTI-REG-MTR            
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7770'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_REGISTER_READ' TO TABLE-1                  
P00718             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
P00718             MOVE RG-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7770-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P0795D 7772-REV-DIST-RLSE.                                              
P0795D                                                                  
P0795D     EXEC SQL                                                     
P0795D        SELECT A9.RLSE_REQUIRED_IND                               
P0795D          INTO :A9-RLSE-REQUIRED-IND                              
P0795D          FROM CSS_REV_DISTRICT A9 WITH(READUNCOMMITTED)                  
P0795D         WHERE REV_DISTRICT_CD = :PR-REV-DISTRICT-CD              
P0795D                                                           
P0795D                                                      
P0795D     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A9.RLSE_REQUIRED_IND                                       
MFA-TR*         INTO :A9-RLSE-REQUIRED-IND                                      
MFA-TR*         FROM CSS_REV_DISTRICT A9                                        
MFA-TR*        WHERE REV_DISTRICT_CD = :PR-REV-DISTRICT-CD                      
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7772                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795D                                                                  
P0795D     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0795D     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795D         WHEN SUCCESSFUL-CALL                                     
P0795D                CONTINUE                                          
P0795D         WHEN NOT-FOUND                                           
P0795D             MOVE 'N' TO A9-RLSE-REQUIRED-IND                     
P0795D         WHEN OTHER                                               
P0795D             MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
P0795D             MOVE '7772'                   TO ACTIVE-PARAGRAPH    
P0795D             MOVE 'SELECT'                 TO ABEND-FUNCTION      
P0795D             MOVE SPACES                   TO ABEND-SQL-PREDICATES
P0795D                                             ABEND-TABLES         
P0795D             MOVE 'CSS_REV-DISTRICT'       TO TABLE-1             
P0795D             MOVE 'REV_DISTRICT_CD'        TO TABLE-ELEMENT-1     
P0795D             MOVE A9-REV-DISTRICT-CD       TO HOSTVAR-ELEMENT-1   
P0795D             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0795D     END-EVALUATE.                                                
P0795D                                                                  
P0795D 7772-EXIT.                                                       
P0795D     EXIT.                                                        
                                                                        
P01176 7800-GET-ORIG-WORKTYPE.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) WORK_TYPE_CD                                      
                 INTO :6Z-WORK-TYPE-CD                                  
                 FROM CSS_SAMPL_TST_PULL [6Z] WITH(READUNCOMMITTED)             
                WHERE COMPANY_NO         = :6Z-COMPANY-NO               
                  AND CODE_UTIL_TYPE     = :6Z-CODE-UTIL-TYPE           
                  AND ORDER_TYPE_CD      = :6Z-ORDER-TYPE-CD            
                  AND SAMPL_WORK_TYPE_CD = :6Z-SAMPL-WORK-TYPE-CD       
                  AND (VALID_THROUGH_TS IS NULL                         
                   OR  CAST(VALID_THROUGH_TS AS DATE)  > 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_TYPE_CD                                              
MFA-TR*          INTO :6Z-WORK-TYPE-CD                                          
MFA-TR*          FROM CSS_SAMPL_TST_PULL 6Z                                     
MFA-TR*         WHERE COMPANY_NO         = :6Z-COMPANY-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :6Z-CODE-UTIL-TYPE                   
MFA-TR*           AND ORDER_TYPE_CD      = :6Z-ORDER-TYPE-CD                    
MFA-TR*           AND SAMPL_WORK_TYPE_CD = :6Z-SAMPL-WORK-TYPE-CD               
MFA-TR*           AND (VALID_THROUGH_TS IS NULL                                 
MFA-TR*            OR  DATE(VALID_THROUGH_TS)  > :WS-CURRENT-DATE)              
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE SPACES TO 6Z-WORK-TYPE-CD                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SAMPL_TST_PULL' TO TABLE-1                 
                   MOVE 'WORK_TYPE_CD'  TO TABLE-ELEMENT-1              
                   MOVE 6Z-WORK-TYPE-CD  TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04482_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              BUS_RULE_ID,                                              
              ACTION_TYPE_CD,                                           
              BUS_RULE_XREF_ID,                                         
              MESSAGE_PARMS                                             
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-BUS-RULE-ID,                                          
               :S-ACTION-TYPE-CD,                                       
               :S-BUS-RULE-XREF-ID,                                     
               :S-MESSAGE-PARMS                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04482_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       ACTION_TYPE_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID,                                                 
MFA-TR*       MESSAGE_PARMS                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-BUS-RULE-ID,                                                  
MFA-TR*        :S-ACTION-TYPE-CD,                                               
MFA-TR*        :S-BUS-RULE-XREF-ID,                                             
MFA-TR*        :S-MESSAGE-PARMS                                                 
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04482_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04482_R3                            
             (                                                          
              RETURN_CODE,                                              
              ASSIGNED_DATE,                                            
              SERV_ORDER_NO,                                            
              ORDER_TYPE_CD,                                            
              ORDER_STATE_CD,                                           
              CUSTOMER_NAME,                                            
              REMARKS,                                                  
              WORK_AREA,                                                
              PHONE,                                                    
              REMARK_TYPE                                               
P00718*       BUSINESS_UNIT                                                     
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-ASSIGNED-DATE,                                        
               :S-SERV-ORDER-NO-3,                                      
               :S-ORDER-TYPE-CD,                                        
               :S-ORDER-STATE-CD,                                       
               :S-CUSTOMER-NAME,                                        
               :S-REMARKS,                                              
               :S-WORK-AREA-3,                                          
               :S-PHONE,                                                
               :S-REMARK-TYPE                                           
P00718*        :S-BUSINESS-UNIT-3                                               
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04482_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ASSIGNED_DATE,                                                    
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       ORDER_TYPE_CD,                                                    
MFA-TR*       ORDER_STATE_CD,                                                   
MFA-TR*       CUSTOMER_NAME,                                                    
MFA-TR*       REMARKS,                                                          
MFA-TR*       WORK_AREA,                                                        
MFA-TR*       PHONE,                                                            
MFA-TR*       REMARK_TYPE                                                       
MFA-TR*       BUSINESS_UNIT                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-ASSIGNED-DATE,                                                
MFA-TR*        :S-SERV-ORDER-NO-3,                                              
MFA-TR*        :S-ORDER-TYPE-CD,                                                
MFA-TR*        :S-ORDER-STATE-CD,                                               
MFA-TR*        :S-CUSTOMER-NAME,                                                
MFA-TR*        :S-REMARKS,                                                      
MFA-TR*        :S-WORK-AREA-3,                                                  
MFA-TR*        :S-PHONE,                                                        
MFA-TR*        :S-REMARK-TYPE                                                   
MFA-TR*        :S-BUSINESS-UNIT-3                                               
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04482_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-SEND-RESULT-4.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04482_R4                            
             (                                                          
              RETURN_CODE,                                              
              CODE_UTIL_TYPE,                                           
              METER_NO,                                                 
              RATE_PLAN,                                                
              SUPPLIES,                                                 
              METER_LOC,                                                
              METER_STATUS,                                             
              METER_STATUS_REASON,                                      
              WORK_TYPE_CD,                                             
              METER_READ_INST,                                          
              METER_IND,                                                
              IC_NO,                                                    
              MTR_REF_NO,                                               
              RLSE_REQUIRED,                                            
              RLSE_NO,                                                  
              RLSE_MSG,                                                 
              RLSE_ADDL_MSG,                                            
              RLSE_PHONE,                                               
              RLSE_ALT_PHONE,                                           
              RLSE_REV_DIST,                                            
              BUS_RULE_ID,                                              
              ACTION_TYPE_CD,                                           
              BUS_RULE_XREF_ID                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-4,                                        
               :S-CODE-UTIL-TYPE-4,                                     
               :S-METER-NO-4,                                           
               :S-RATE-PLAN,                                            
               :S-SUPPLIES,                                             
               :S-METER-LOC,                                            
               :S-METER-STATUS,                                         
               :S-METER-STATUS-REASON,                                  
               :S-WORK-TYPE-CD-4,                                       
               :S-METER-READ-INST,                                      
               :S-METER-IND,                                            
               :S-IC-NO-4,                                              
               :S-MTR-REF-NO-4,                                         
               :S-RLSE-REQUIRED,                                        
               :S-RLSE-NO,                                              
               :S-RLSE-MSG,                                             
               :S-RLSE-ADDL-MSG,                                        
               :S-RLSE-PHONE,                                           
               :S-RLSE-ALT-PHONE,                                       
               :S-RLSE-REV-DIST,                                        
               :S-BUS-RULE-ID-4,                                        
               :S-ACTION-TYPE-CD-4,                                     
               :S-BUS-RULE-XREF-ID-4                                    
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04482_R4                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       METER_NO,                                                         
MFA-TR*       RATE_PLAN,                                                        
MFA-TR*       SUPPLIES,                                                         
MFA-TR*       METER_LOC,                                                        
MFA-TR*       METER_STATUS,                                                     
MFA-TR*       METER_STATUS_REASON,                                              
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       METER_READ_INST,                                                  
MFA-TR*       METER_IND,                                                        
MFA-TR*       IC_NO,                                                            
MFA-TR*       MTR_REF_NO,                                                       
MFA-TR*       RLSE_REQUIRED,                                                    
MFA-TR*       RLSE_NO,                                                          
MFA-TR*       RLSE_MSG,                                                         
MFA-TR*       RLSE_ADDL_MSG,                                                    
MFA-TR*       RLSE_PHONE,                                                       
MFA-TR*       RLSE_ALT_PHONE,                                                   
MFA-TR*       RLSE_REV_DIST,                                                    
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       ACTION_TYPE_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-4,                                                
MFA-TR*        :S-CODE-UTIL-TYPE-4,                                             
MFA-TR*        :S-METER-NO-4,                                                   
MFA-TR*        :S-RATE-PLAN,                                                    
MFA-TR*        :S-SUPPLIES,                                                     
MFA-TR*        :S-METER-LOC,                                                    
MFA-TR*        :S-METER-STATUS,                                                 
MFA-TR*        :S-METER-STATUS-REASON,                                          
MFA-TR*        :S-WORK-TYPE-CD-4,                                               
MFA-TR*        :S-METER-READ-INST,                                              
MFA-TR*        :S-METER-IND,                                                    
MFA-TR*        :S-IC-NO-4,                                                      
MFA-TR*        :S-MTR-REF-NO-4,                                                 
MFA-TR*        :S-RLSE-REQUIRED,                                                
MFA-TR*        :S-RLSE-NO,                                                      
MFA-TR*        :S-RLSE-MSG,                                                     
MFA-TR*        :S-RLSE-ADDL-MSG,                                                
MFA-TR*        :S-RLSE-PHONE,                                                   
MFA-TR*        :S-RLSE-ALT-PHONE,                                               
MFA-TR*        :S-RLSE-REV-DIST,                                                
MFA-TR*        :S-BUS-RULE-ID-4,                                                
MFA-TR*        :S-ACTION-TYPE-CD-4,                                             
MFA-TR*        :S-BUS-RULE-XREF-ID-4                                            
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04482_R4'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-SEND-RESULT-5.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04482_R5                            
             (                                                          
              RETURN_CODE,                                              
              SERV_ORDER_NO,                                            
              CODE_UTIL_TYPE,                                           
              WORK_TYPE_CD,                                             
              IC_NO,                                                    
              METER_NO,                                                 
              MTR_REF_NO                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-5,                                        
               :S-SERV-ORDER-NO-5,                                      
               :S-CODE-UTIL-TYPE-5,                                     
               :S-WORK-TYPE-CD-5,                                       
               :S-IC-NO-5,                                              
               :S-METER-NO-5,                                           
               :S-MTR-REF-NO-5                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04482_R5                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       IC_NO,                                                            
MFA-TR*       METER_NO,                                                         
MFA-TR*       MTR_REF_NO                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-5,                                                
MFA-TR*        :S-SERV-ORDER-NO-5,                                              
MFA-TR*        :S-CODE-UTIL-TYPE-5,                                             
MFA-TR*        :S-WORK-TYPE-CD-5,                                               
MFA-TR*        :S-IC-NO-5,                                                      
MFA-TR*        :S-METER-NO-5,                                                   
MFA-TR*        :S-MTR-REF-NO-5                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04482_R5'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-SEND-RESULT-6.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04482_R6                            
             (                                                          
              RETURN_CODE,                                              
              CALENDAR_DT,                                              
              GOOD_DAY_FL,                                              
              SCENARIO_SEQ,                                             
              SCENARIO_SEQ_CHOICE                                       
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-6,                                        
               :S-CALENDAR-DT,                                          
               :S-GOOD-DAY-FL,                                          
               :S-SCENARIO-SEQ-6,                                       
               :S-SCENARIO-SEQ-CHOICE-6                                 
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04482_R6                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CALENDAR_DT,                                                      
MFA-TR*       GOOD_DAY_FL,                                                      
MFA-TR*       SCENARIO_SEQ,                                                     
MFA-TR*       SCENARIO_SEQ_CHOICE                                               
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-6,                                                
MFA-TR*        :S-CALENDAR-DT,                                                  
MFA-TR*        :S-GOOD-DAY-FL,                                                  
MFA-TR*        :S-SCENARIO-SEQ-6,                                               
MFA-TR*        :S-SCENARIO-SEQ-CHOICE-6                                         
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8700'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04482_R6'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8700-SEND-RESULT-7.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04482_R7                            
             (                                                          
               RETURN_CODE,                                             
               SCENARIO_SEQ,                                            
               SCENARIO_SEQ_CHOICE,                                     
               NEW_ORDER_TYPE,                                          
               NEW_E_WORK_TYPE,                                         
               NEW_G_WORK_TYPE,                                         
               NEW_ORDER_STATE_CD,                                      
               DISPATCH_NOT_WQ,                                         
               ADDL_SO_REMARKS,                                         
               SO_HOLD_COMMENTS,                                        
               SCHED_DT_FUNC_CD,                                        
               MAX_DATE,                                                
               ORD_AUTO_SEL_CD,                                         
               WORK_AREA,                                               
               ARRANGEMENT_FL,                                          
               ELEC_RLSE_FL,                                            
               GAS_RLSE_FL,                                             
P00718         BUSINESS_UNIT,                                           
P00718         WORK_DISTRICT,                                           
P0795C         ORDER_BUS_RULE_ID,                                       
A05189         AROP_READ_ONLY,                                          
P0795F         ORDER_UTILITY_CD,                                        
D12002         ELEC_RLSE_NO,                                            
D12002         GAS_RLSE_NO                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-7,                                        
               :S-SCENARIO-SEQ-7,                                       
               :S-SCENARIO-SEQ-CHOICE-7,                                
               :S-NEW-ORDER-TYPE,                                       
               :S-NEW-E-WORK-TYPE,                                      
               :S-NEW-G-WORK-TYPE,                                      
               :S-NEW-ORDER-STATE-CD,                                   
               :S-DISPATCH-NOT-WQ,                                      
               :S-ADDL-SO-REMARKS,                                      
               :S-SO-HOLD-COMMENTS,                                     
               :S-SCHED-DT-FUNC-CD,                                     
               :S-MAX-DATE,                                             
               :S-ORD-AUTO-SEL-CD,                                      
               :S-WORK-AREA-7,                                          
               :S-ARRANGEMENT-FL-7,                                     
               :S-ELEC-RLSE-FL,                                         
               :S-GAS-RLSE-FL,                                          
P00718         :S-BUSINESS-UNIT-7,                                      
P00718         :S-WORK-DISTRICT-7,                                      
P0795C         :S-ORDER-BUS-RULE-ID,                                    
A05189         :S-AROP-READ-ONLY-FL-7,                                  
P0795F         :S-ORDER-UTILITY-CD,                                     
D12002         :S-ELEC-RLSE-NO,                                         
D12002         :S-GAS-RLSE-NO                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04482_R7                                    
MFA-TR*      (                                                                  
MFA-TR*        RETURN_CODE,                                                     
MFA-TR*        SCENARIO_SEQ,                                                    
MFA-TR*        SCENARIO_SEQ_CHOICE,                                             
MFA-TR*        NEW_ORDER_TYPE,                                                  
MFA-TR*        NEW_E_WORK_TYPE,                                                 
MFA-TR*        NEW_G_WORK_TYPE,                                                 
MFA-TR*        NEW_ORDER_STATE_CD,                                              
MFA-TR*        DISPATCH_NOT_WQ,                                                 
MFA-TR*        ADDL_SO_REMARKS,                                                 
MFA-TR*        SO_HOLD_COMMENTS,                                                
MFA-TR*        SCHED_DT_FUNC_CD,                                                
MFA-TR*        MAX_DATE,                                                        
MFA-TR*        ORD_AUTO_SEL_CD,                                                 
MFA-TR*        WORK_AREA,                                                       
MFA-TR*        ARRANGEMENT_FL,                                                  
MFA-TR*        ELEC_RLSE_FL,                                                    
MFA-TR*        GAS_RLSE_FL,                                                     
MFA-TR*        BUSINESS_UNIT,                                                   
MFA-TR*        WORK_DISTRICT,                                                   
MFA-TR*        ORDER_BUS_RULE_ID,                                               
MFA-TR*        AROP_READ_ONLY,                                                  
MFA-TR*        ORDER_UTILITY_CD,                                                
MFA-TR*        ELEC_RLSE_NO,                                                    
MFA-TR*        GAS_RLSE_NO                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-7,                                                
MFA-TR*        :S-SCENARIO-SEQ-7,                                               
MFA-TR*        :S-SCENARIO-SEQ-CHOICE-7,                                        
MFA-TR*        :S-NEW-ORDER-TYPE,                                               
MFA-TR*        :S-NEW-E-WORK-TYPE,                                              
MFA-TR*        :S-NEW-G-WORK-TYPE,                                              
MFA-TR*        :S-NEW-ORDER-STATE-CD,                                           
MFA-TR*        :S-DISPATCH-NOT-WQ,                                              
MFA-TR*        :S-ADDL-SO-REMARKS,                                              
MFA-TR*        :S-SO-HOLD-COMMENTS,                                             
MFA-TR*        :S-SCHED-DT-FUNC-CD,                                             
MFA-TR*        :S-MAX-DATE,                                                     
MFA-TR*        :S-ORD-AUTO-SEL-CD,                                              
MFA-TR*        :S-WORK-AREA-7,                                                  
MFA-TR*        :S-ARRANGEMENT-FL-7,                                             
MFA-TR*        :S-ELEC-RLSE-FL,                                                 
MFA-TR*        :S-GAS-RLSE-FL,                                                  
MFA-TR*        :S-BUSINESS-UNIT-7,                                              
MFA-TR*        :S-WORK-DISTRICT-7,                                              
MFA-TR*        :S-ORDER-BUS-RULE-ID,                                            
MFA-TR*        :S-AROP-READ-ONLY-FL-7,                                          
MFA-TR*        :S-ORDER-UTILITY-CD,                                             
MFA-TR*        :S-ELEC-RLSE-NO,                                                 
MFA-TR*        :S-GAS-RLSE-NO                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8700'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04482_R7'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04482_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04482_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8001'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04482_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04482_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04482_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8001'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04482_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8004-DELETE-GTT4-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04482_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04482_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8004'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04482_R4'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8004-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8005-DELETE-GTT5-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04482_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04482_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8005'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04482_R5'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8006-DELETE-GTT6-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04482_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04482_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8006'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04482_R6'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8006-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8007-DELETE-GTT7-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04482_R7                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04482_R7                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8007'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04482_R7'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8007-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT04-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-4                             
               EXEC SQL                                                 
                   OPEN N4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT05-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-5                             
               EXEC SQL                                                 
                   OPEN N5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT06-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C6                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-6                             
               EXEC SQL                                                 
                   OPEN N6                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT07-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C7                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-7                             
               EXEC SQL                                                 
                   OPEN N7                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD04423.                                                       
                                                                        
