       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04480.                                          
       AUTHOR.       FRAN BARRY.                                        
       DATE-WRITTEN. FEB 2012.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH IS USED TO     *        
      *  CALCULATE WORK AREA, GET TOTAL RES, DETERMINE IF DISCONNECT   *        
      *  REASON IS REQUIRED, AND VALIDATE THE ASSIGNED DATE AGAINST    *        
      *  THE WORK GROUP CALENDAR.                                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  02/13/2012 FMB       INITIAL VERSION                          *        
P00718*  02/20/2014 VV        ADDITIONAL PARM FOR BUSINESS UNIT        *        
P00795*  08/27/2014 PK44514   FIX FOR WORK AREA IS INCORRECT           *        
P00718*  09/04/2014 PK44514   FOR VIDHU - COMMENTING OUT CODE. MULTI   *        
      *                       REGISTER CHECK MOVED TO UI               *        
P0795A*  01/12/2015 PK44514   PASS ONLY NON-BLANK WORK TYPE DETAILS TO *        
      *                       WORK AREA CALCULATION PROGRAM CSR01116   *        
A05189*  02/13/2015 PK44514   TO SEND ORDERS TO AROP WORK AREA IF ALL  *        
      *                       WORKTYPES HAVE AROP_EXTRACT='Y'AND       *        
      *                       ELIGIBLE FOR AROP.                       *        
P0795B*  03/09/2015 PK44514   DEFECT 6950 - DISCONNECT REASON NOT REQD *        
      *                       FOR RMM FOR MOW(FM008) - NOT REQD IF MTR *        
      *                       IS REMOVED OR TURNED-OFF                 *        
P0795C*  04/25/2015 PK44514   DEFECT 7074 - ADDING CRAWL-APPLIANCE FLAG*        
      *                       AS INPUT PARM AND CHECK IN WORK AREA CALC*        
P0795D*  06/25/2015 PK44514   AOO MAINTENANCE                          *        
P0795E*  03/14/2016 PK44514   WORK AREA CALC FOR ORDER STATE CHANGE    *        
D11099*  04/12/2016 PK44514   WORK AREA CALC FOR DATE CHANGE           *        
DT6878*  04/27/2016 PK44514   SEB ORDERS INITIATE AND MAINTAIN         *        
P00941*  08/30/2016 SC41135   WORKAREA CHANGES FOR SMARTSYNC METERS    *        
P01176*  11/03/2016 PK44514   GAS SAMPLING CHANGES                     *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04480'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04480 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04480_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04480_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04480_R3'.          
       01 GTT-RETURN-FIELDS.                                            
           05 GTT-RETURN-FIELDS-1.                                      
              10 S-RETURN-CODE-1       PIC S9(9) COMP VALUE ZERO.       
              10 S-WORK-AREA           PIC X(12) VALUE SPACES.          
              10 S-DISCONNECT-CD       PIC X(01) VALUE SPACES.          
              10 S-TOTAL-RES           PIC S9(5)V9(1) COMP-3 VALUE 0.   
              10 S-ARRANGEMENT-FL      PIC X(01) VALUE SPACES.          
              10 S-REVERT-FL           PIC X(01) VALUE SPACES.          
P00718        10 S-BUSINESS-UNIT       PIC X(03) VALUE SPACES.          
P00718        10 S-WORK-DISTRICT       PIC X(40) VALUE SPACES.          
A05189        10 S-AROP-READ-ONLY      PIC X(01) VALUE SPACES.          
           05 GTT-RETURN-FIELDS-2.                                      
              10 S-RETURN-CODE-2       PIC S9(9) COMP VALUE ZERO.       
              10 S-CALENDAR-DT         PIC X(10) VALUE SPACES.          
              10 S-GOOD-DAY            PIC X(01) VALUE SPACES.          
              10 S-TOTAL-SO-HRS        PIC S9(5)V9(1) COMP-3 VALUE 0.   
              10 S-MAX-RE-PER-DAY      PIC S9(4) COMP VALUE 0.          
              10 S-TOTAL-SO            PIC S9(4) COMP VALUE 0.          
              10 S-MAX-DAILY-WK-REQ    PIC S9(4) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04480'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-CUSTOMER-NO           PIC X(10) VALUE SPACES.          
          05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO         
                                       PIC 9(10).                       
          05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.          
          05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
          05  WS-SERV-ORDER-NO         PIC X(13) VALUE SPACES.          
          05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO       
                                       PIC 9(13).                       
          05  WS-PREMISE-NO            PIC X(10) VALUE SPACES.          
          05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO          
                                       PIC 9(10).                       
          05  WS-READ-ROUTE-NUM        PIC 9(04).                       
          05  WS-READ-ROUTE-CHAR       REDEFINES WS-READ-ROUTE-NUM      
                                       PIC X(04).                       
          05  WS-GIS-POINT-ID          PIC 9(09).                       
          05  WS-GIS-POINT-ID-CHAR     REDEFINES WS-GIS-POINT-ID        
                                       PIC X(09).                       
          05  WS-CURR-ACCOUNT-NO       PIC 9(13) VALUE 0.               
          05  WS-CURR-ACCOUNT-CHAR     REDEFINES WS-CURR-ACCOUNT-NO     
                                       PIC X(13).                       
          05  WS-NEW-CUSTOMER-NO       PIC S9(10)V COMP-3 VALUE 0.      
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-CRAWL-LOCAL-OFFICE    PIC X(01) VALUE 'N'.             
          05  WS-APPLIANCES-AT-PREMISE PIC X(01) VALUE 'N'.             
          05  WS-CHECK-CRAWL           PIC X(01) VALUE 'N'.             
          05  WS-SEASONAL-FL           PIC X(01) VALUE 'N'.             
          05  WS-SUB1                  PIC 9(03) VALUE 0.               
          05  WS-NB-SUB1               PIC 9(03) VALUE 0.               
          05  WS-WORK-TYPE-LINE.                                        
              10  WS-WORK-TYPE         PIC X(03) OCCURS 50.             
          05  WS-UTIL-TYPE-LINE.                                        
              10  WS-UTIL-TYPE         PIC X(01) OCCURS 50.             
          05  WS-METER-STATUS-LINE.                                     
              10  WS-METER-STATUS      PIC X(01) OCCURS 50.             
P0795A    05  WS-METER-IND-LINE.                                        
P0795A        10  WS-METER-IND         PIC X(01) OCCURS 50.             
P0795A*NON-BLANK WORK TYPE DETAILS TO PASS TO CSR01161                          
P0795A    05  WS-WORK-TYPE-LINE-NB.                                     
P0795A        10  WS-WORK-TYPE-NB      PIC X(03) OCCURS 50.             
P0795A    05  WS-UTIL-TYPE-LINE-NB.                                     
P0795A        10  WS-UTIL-TYPE-NB      PIC X(01) OCCURS 50.             
P0795A    05  WS-METER-IND-LINE-NB.                                     
P0795A        10  WS-METER-IND-NB      PIC X(01) OCCURS 50.             
          05  WS-CALCULATE-RES         PIC 9(5)V9 VALUE 0.0.            
          05  WS-WK-TOTAL-RES          PIC S9(5)V9(1) COMP-3 VALUE 0.0. 
          05  WS-TOTAL-RES             PIC 9(06) VALUE ZEROES.          
          05  WS-TOTAL-RES-DEC         PIC 9(05)V9 VALUE ZEROES.        
          05  WS-AUTO-UPDATE           PIC X(01) VALUE 'N'.             
          05  WS-LOG-TURNOFF           PIC X(01) VALUE 'N'.             
P00718    05  WS-MULTI-REG-MTR         PIC X(01) VALUE 'N'.             
          05  WS-TOTAL-SO-HRS          PIC S9(5)V9 COMP-3 VALUE 0.      
          05  WS-TOTAL-SO-HRS-NODEC    PIC 9(6)  VALUE 0.               
P00718    05  WS-WORK-DISTRICT         PIC X(40) VALUE SPACES.          
P0795D    05  WS-CALC-ACTIVE-WKAREA    PIC X(01) VALUE SPACES.          
P0795D    05  WS-CALCULATE-WKAREA      PIC X(01) VALUE 'Y'.             
P0795D    05  WS-NEW-ORDER-FL          PIC X(01) VALUE SPACES.          
COB305    05 WS-ACCOUNT-NO-H        PIC S9(13)V USAGE COMP-3 VALUE 0.        
A05189    05  WS-READ-ONLY-ORDER       PIC X(01) VALUE SPACES.          
P00941    05  WS-ELEC-ONLY-ORDER       PIC X(01) VALUE SPACES.          
P00941    05  WS-SS-READ-SOURCE        PIC X(01) VALUE SPACES.          
A05189    05  WS-AROP-EXTRACT-IND      PIC X(01) VALUE SPACES.          
A05189    05  WS-AROP-METER-STATUS     PIC X(01) VALUE SPACES.          
A05189    05  WS-AROP-METER-REAS       PIC X(01) VALUE SPACES.          
A05189    05  WS-WORK-TYPES-4109       PIC X(150) VALUE SPACES.         
MAINTN    05  WS-SO-CRAWL-EXISTS       PIC X(01) VALUE SPACES.          
DT6878    05  WS-DATABASE              PIC 9(01) VALUE ZERO.            
DT6878        88  CSR-DATABASE                   VALUE 1.               
DT6878        88  SEB-DATABASE                   VALUE 2.               
                                                                        
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01 IND-VARIABLES.                                                
          05 WS-NULL1                    PIC S9(04) COMP.               
                                                                        
       01  CSR04109-CALL-DATA.                                          
           03 WORK-AREA-ID-4109         PIC X(12) VALUE SPACES.         
           03 ASSIGNED-DATETIME-4109    PIC X(26) VALUE SPACES.         
           03 SERV-ORDER-NO-4109        PIC X(13) VALUE SPACES.         
           03 TOTAL-RES-4109            PIC X(06) VALUE SPACES.         
           03 NO-DAYS-4109              PIC X(03) VALUE SPACES.         
           03 SYSTEM-INITIATED-4109     PIC X(03) VALUE SPACES.         
           03 WORK-TYPES-4109           PIC X(150) VALUE SPACES.        
                                                                        
       01  CSR04109-RETURN-DATA.                                        
           05  RETURN-CODE-4109      PIC S9(9) COMP VALUE 0.            
           05  CALENDAR-DT-4109      PIC X(10) VALUE SPACES.            
           05  GOOD-DAY-4109         PIC X(01) VALUE SPACES.            
           05  TOTAL-SO-HRS-4109     PIC X(06) VALUE SPACES.            
           05  MAX-RE-PER-DAY-4109   PIC S9(4) COMP VALUE 0.            
           05  TOTAL-SO-4109         PIC S9(4) COMP VALUE 0.            
           05  MAX-DAILY-WK-REQ-4109 PIC S9(4) COMP VALUE 0.            
                                                                        
       01  CSR01116-CALL-DATA.                                          
           03  LOCAL-OFFICE-1116        PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-1116      PIC X(50) VALUE SPACES.         
           03  WORK-TYPE-CD-1116        PIC X(150) VALUE SPACES.        
           03  CRAWL-IND-1116           PIC X(01) VALUE SPACES.         
           03  METER-IND-1116           PIC X(50) VALUE SPACES.         
           03  ZIP-CODE-1116            PIC X(05) VALUE SPACES.         
           03  READ-ROUTE-1116          PIC X(04) VALUE SPACES.         
           03  POINT-ID-1116            PIC X(10) VALUE SPACES.         
                                                                        
       01  CSR01116-RETURN-DATA.                                        
           03  RETURN-CODE-1116         PIC S9(9) COMP VALUE 0.         
           03  WORK-AREA-1116           PIC X(12) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-1116       PIC X(03) VALUE SPACES.         
                                                                        
A05189 01  CSR04849-CALL-DATA.                                          
A05189     03 ACCOUNT-NO-4849           PIC X(13) VALUE SPACES.         
A05189     03 PREMISE-NO-4849           PIC X(10) VALUE SPACES.         
A05189     03 SERV-ORDER-NO-4849        PIC X(13) VALUE SPACES.         
                                                                        
A05189 01  CSR04849-RETURN-DATA.                                        
A05189     05  RETURN-CODE-4849      PIC S9(9) COMP VALUE 0.            
A05189     05  AROP-ELIGIBLE-FL-4849 PIC X(01) VALUE SPACES.            
                                                                        
       01 WS-TABLES.                                                    
           05  T1-WORK-TYPE           OCCURS 300                        
                                      INDEXED BY T1-INDEX.              
               10  T1-WORK-TYPE-CD      PIC X(03).                      
COB305         10 T1-EST-LABOR-HRS        PIC S9(1)V9(1) USAGE COMP-3 
COB305           VALUE 0.    
               10  T1-AROP-EXTRACT-IND  PIC X(01).                      
               10  T1-CODE-METER-STATUS PIC X(01).                      
               10  T1-CODE-STATUS-REAS  PIC X(01).                      
           05  T2-CALENDAR            OCCURS 100                        
                                      INDEXED BY T2-INDEX.              
               10 T2-CALENDAR-DT      PIC X(10) VALUE SPACES.           
               10 T2-GOOD-DAY         PIC X(01) VALUE SPACES.           
               10 T2-TOTAL-SO-HRS     PIC X(06) VALUE SPACES.           
               10 T2-MAX-RE-PER-DAY   PIC S9(4) COMP VALUE 0.           
               10 T2-TOTAL-SO         PIC S9(4) COMP VALUE 0.           
               10 T2-MAX-DAILY-WK-REQ PIC S9(4) COMP VALUE 0.           
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
           COPY CWS04423.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
P0795D* TABLE-ID:VO                                                             
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
P00941* TABLE-ID:VC                                                             
            EXEC SQL                                                            
              INCLUDE TBSOMCG                                                   
            END-EXEC.                                                           
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLOCOFC                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBSOLOC                                                   
P00718     END-EXEC.                                                            
                                                                        
P00718     EXEC SQL                                                             
P00718        INCLUDE TBRGREAD                                                  
P00718     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOEQP                                                   
           END-EXEC.                                                            
                                                                        
DT6878     EXEC SQL                                                             
DT6878        INCLUDE TBDELQ                                                    
DT6878     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
      *01 LOC4109 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1116 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4849 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
               DECLARE WORK_TYPE_CURSOR CURSOR FOR                      
                   SELECT WORK_TYPE_CD,                                 
                          EST_LABOR_HRS,                                
A05189                    AROP_EXTRACT_IND,                             
A05189                    CODE_METER_STATUS,                            
A05189                    CODE_STATUS_REAS                              
                     FROM CSS_WORK_TYPE WITH(READUNCOMMITTED)                   
                    WHERE COMPANY_NO = :L4-COMPANY-NO                   
                   FOR READ ONLY                                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE WORK_TYPE_CURSOR CURSOR FOR                              
MFA-TR*            SELECT WORK_TYPE_CD,                                         
MFA-TR*                   EST_LABOR_HRS,                                        
MFA-TR*                   AROP_EXTRACT_IND,                                     
MFA-TR*                   CODE_METER_STATUS,                                    
MFA-TR*                   CODE_STATUS_REAS                                      
MFA-TR*              FROM CSS_WORK_TYPE                                         
MFA-TR*             WHERE COMPANY_NO = :L4-COMPANY-NO                           
MFA-TR*            FOR FETCH ONLY                                               
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7010                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-WORK-AREA         AS WORK_AREA,                
                      :S-DISCONNECT-CD     AS DISCONNECT_CD,            
                      :S-TOTAL-RES         AS TOTAL_RES,                
                      :S-ARRANGEMENT-FL    AS ARRANGEMENT_FL,           
                      :S-REVERT-FL         AS REVERT_FL,                
P00718                :S-BUSINESS-UNIT     AS BUSINESS_UNIT,            
P00718                :S-WORK-DISTRICT     AS WORK_DISTRICT,            
A05189                :S-AROP-READ-ONLY    AS AROP_READ_ONLY            
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-WORK-AREA         AS WORK_AREA,                        
MFA-TR*               :S-DISCONNECT-CD     AS DISCONNECT_CD,                    
MFA-TR*               :S-TOTAL-RES         AS TOTAL_RES,                        
MFA-TR*               :S-ARRANGEMENT-FL    AS ARRANGEMENT_FL,                   
MFA-TR*               :S-REVERT-FL         AS REVERT_FL,                        
MFA-TR*               :S-BUSINESS-UNIT     AS BUSINESS_UNIT,                    
MFA-TR*               :S-WORK-DISTRICT     AS WORK_DISTRICT,                    
MFA-TR*               :S-AROP-READ-ONLY    AS AROP_READ_ONLY                    
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CALENDAR_DT          AS CALENDAR_DT,                   
                 GOOD_DAY             AS GOOD_DAY,                      
                 TOTAL_SO_HRS         AS TOTAL_SO_HRS,                  
                 MAX_RE_PER_DAY       AS MAX_RE_PER_DAY,                
                 TOTAL_SO             AS TOTAL_SO,                      
                 MAX_DAILY_WK_REQ     AS MAX_DAILY_WK_REQ               
              FROM #CSR04480_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CALENDAR_DT          AS CALENDAR_DT,                           
MFA-TR*          GOOD_DAY             AS GOOD_DAY,                              
MFA-TR*          TOTAL_SO_HRS         AS TOTAL_SO_HRS,                          
MFA-TR*          MAX_RE_PER_DAY       AS MAX_RE_PER_DAY,                        
MFA-TR*          TOTAL_SO             AS TOTAL_SO,                              
MFA-TR*          MAX_DAILY_WK_REQ     AS MAX_DAILY_WK_REQ                       
MFA-TR*       FROM SESSION.CSR04480_R2                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-CALENDAR-DT       AS CALENDAR_DT,              
                      :S-GOOD-DAY          AS GOOD_DAY,                 
                      :S-TOTAL-SO-HRS      AS TOTAL_SO_HRS,             
                      :S-MAX-RE-PER-DAY    AS MAX_RE_PER_DAY,           
                      :S-TOTAL-SO          AS TOTAL_SO,                 
                      :S-MAX-DAILY-WK-REQ  AS MAX_DAILY_WK_REQ          
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-CALENDAR-DT       AS CALENDAR_DT,                      
MFA-TR*               :S-GOOD-DAY          AS GOOD_DAY,                         
MFA-TR*               :S-TOTAL-SO-HRS      AS TOTAL_SO_HRS,                     
MFA-TR*               :S-MAX-RE-PER-DAY    AS MAX_RE_PER_DAY,                   
MFA-TR*               :S-TOTAL-SO          AS TOTAL_SO,                         
MFA-TR*               :S-MAX-DAILY-WK-REQ  AS MAX_DAILY_WK_REQ                  
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1116 CURSOR
MSQ001          FOR CALL CSR01116                                             
                   ( :LOCAL-OFFICE-1116
                  , :CODE-UTIL-TYPE-1116
                  , :WORK-TYPE-CD-1116
                  , :CRAWL-IND-1116
                  , :METER-IND-1116
                  , :ZIP-CODE-1116
                  , :READ-ROUTE-1116
                  , :POINT-ID-1116
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4109 CURSOR
MSQ001          FOR CALL CSR04109                                             
                   ( :WORK-AREA-ID-4109
                  , :ASSIGNED-DATETIME-4109
                  , :SERV-ORDER-NO-4109
                  , :TOTAL-RES-4109
                  , :NO-DAYS-4109
                  , :SYSTEM-INITIATED-4109
                  , :WORK-TYPES-4109
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4849 CURSOR
MSQ001          FOR CALL CSR04849                                             
                   ( :ACCOUNT-NO-4849
                  , :PREMISE-NO-4849
                  , :SERV-ORDER-NO-4849
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-UTIL-TYPE           PIC X(50).                          
       01  LINK-WORK-TYPE           PIC X(150).                         
       01  LINK-METER-IND           PIC X(50).                          
       01  LINK-METER-STATUS        PIC X(50).                          
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-ORDER-TYPE-CD       PIC X(05).                          
       01  LINK-ASSIGNED-DATE       PIC X(10).                          
       01  LINK-PROGRAM-ID          PIC X(08).                          
       01  LINK-APPLIANCE-LIT-FL    PIC X(01).                          
       01  LINK-RELEASE-REQD-FL     PIC X(01).                          
       01  LINK-FRO-FL              PIC X(01).                          
P0795C 01  LINK-CRAWL-APPL-FL       PIC X(01).                          
P0795D 01  LINK-SERV-ORDER-NO       PIC X(13).                          
P0795D 01  LINK-NEW-ORDER-STATE-CD  PIC X(01).                          
P0795D 01  LINK-WORK-AREA-ID        PIC X(12).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-UTIL-TYPE,                        
                                 LINK-WORK-TYPE,                        
                                 LINK-METER-IND,                        
                                 LINK-METER-STATUS,                     
                                 LINK-ACCOUNT-NO,                       
                                 LINK-PREMISE-NO,                       
                                 LINK-ORDER-TYPE-CD,                    
                                 LINK-ASSIGNED-DATE,                    
                                 LINK-PROGRAM-ID,                       
                                 LINK-APPLIANCE-LIT-FL,                 
                                 LINK-RELEASE-REQD-FL,                  
                                 LINK-FRO-FL,                           
P0795C                           LINK-CRAWL-APPL-FL,                    
P0795D                           LINK-SERV-ORDER-NO,                    
P0795D                           LINK-NEW-ORDER-STATE-CD,               
P0795D                           LINK-WORK-AREA-ID.                     
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04480_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04480_R2
              (                                                          
                 RETURN_CODE          INT,                          
                 CALENDAR_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
                 GOOD_DAY CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
                 TOTAL_SO_HRS         DECIMAL(6,1),                     
                 MAX_RE_PER_DAY       SMALLINT,                         
                 TOTAL_SO             SMALLINT,                         
                 MAX_DAILY_WK_REQ     SMALLINT                          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04480_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
               MOVE ZEROES TO LINK-SERV-ORDER-NO
           END-IF.                       
           MOVE LINK-ACCOUNT-NO         TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO.               
           MOVE LINK-SERV-ORDER-NO      TO WS-SERV-ORDER-NO.            
           MOVE WS-SERV-ORDER-NO-NUM    TO VO-SERV-ORDER-NO.            
P00941     MOVE WS-SERV-ORDER-NO-NUM    TO VC-SERV-ORDER-NO.            
           MOVE LINK-PREMISE-NO         TO WS-PREMISE-NO.               
           MOVE WS-PREMISE-NO-NUM       TO PR-PREMISE-NO.               
           MOVE LINK-UTIL-TYPE          TO WS-UTIL-TYPE-LINE.           
           MOVE LINK-WORK-TYPE          TO WS-WORK-TYPE-LINE.           
           MOVE LINK-METER-STATUS       TO WS-METER-STATUS-LINE.        
           MOVE LINK-METER-IND          TO WS-METER-IND-LINE.           
           IF WS-SERV-ORDER-NO-NUM > ZEROES                             
              MOVE 'N' TO WS-NEW-ORDER-FL                               
           ELSE                                                         
              MOVE 'Y' TO WS-NEW-ORDER-FL                               
           END-IF                                                       
           IF LINK-ASSIGNED-DATE(6:2) NUMERIC                           
               IF LINK-ASSIGNED-DATE(6:2) >= '10' OR                    
                  LINK-ASSIGNED-DATE(6:2) <= '04'                       
                      MOVE 'Y' TO WS-SEASONAL-FL                        
               ELSE                                                     
                   MOVE 'N' TO WS-SEASONAL-FL                           
               END-IF                                                   
           ELSE                                                         
               MOVE 'N' TO WS-SEASONAL-FL
           END-IF.                              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-ACCOUNT-NO = ZEROES AND                              
              LINK-PREMISE-NO = ZEROES                                  
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                               S-RETURN-CODE-2                          
                  MOVE 'PARMS ZERO' TO S-WORK-AREA                      
                  ADD +1 TO CTR-ROWS                                    
                  PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT             
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      *  WORK AREA CALCULATION / RES                                            
                                                                        
           IF VO-SERV-ORDER-NO > 0                                      
              PERFORM 7610-GET-SO-DATA THRU 7610-EXIT                   
              IF LINK-ORDER-TYPE-CD <= SPACES                           
                 MOVE VO-ORDER-TYPE-CD TO LINK-ORDER-TYPE-CD            
              END-IF                                                    
MAINTN*       IF VO-WORK-AREA-ID (1:3) = 'ARO' AND                              
              IF ((VO-ORDER-STATE-CD NOT = 'A'   AND                    
                  LINK-NEW-ORDER-STATE-CD = 'A')  OR                    
                 (LINK-ASSIGNED-DATE NOT = VO-ASSIGNED-DATETIME (1:10)  
                                           AND                          
                  LINK-ASSIGNED-DATE = WS-CURRENT-DATE))                
                 MOVE 'Y' TO WS-CALC-ACTIVE-WKAREA                      
              END-IF                                                    
MAINTN*       IF VO-WORK-AREA-ID NOT= LINK-WORK-AREA-ID                         
              IF LINK-WORK-AREA-ID NOT = SPACES                         
                 MOVE 'N' TO WS-CALCULATE-WKAREA                        
              END-IF                                                    
           END-IF.                                                      
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7000-GET-ACCT-LOCOFF THRU 7000-EXIT              
               IF AT-CODE-ACCT-STAT = 'P'                               
                  PERFORM 2200-GET-CURRENT-ACCT THRU 2200-EXIT          
               END-IF                                                   
               PERFORM 7300-GET-READ-ROUTE THRU 7300-EXIT               
               PERFORM 7400-GET-POINT-ID THRU 7400-EXIT                 
           ELSE                                                         
               PERFORM 7100-GET-PREM-LOCOFF THRU 7100-EXIT              
           END-IF.                                                      
DT6878     PERFORM 7620-GET-DATABASE  THRU 7620-EXIT                    
           PERFORM 7010-OPEN-CURSOR THRU 7010-EXIT.                     
           PERFORM 2100-BUILD-TABLE THRU 2100-EXIT VARYING              
                T1-INDEX FROM 1 BY 1 UNTIL                              
                T1-INDEX > 300 OR                                       
                WS-ACTIVE-RETURN-CODE = NOT-FOUND.                      
           PERFORM 7030-CLOSE-CURSOR THRU 7030-EXIT.                    
           PERFORM 7200-GET-ZIP THRU 7200-EXIT.                         
           IF B1-SERV-ORDER-WORK-CD = 'METRO' OR 'DISTC'                
               MOVE 'Y' TO WS-CRAWL-LOCAL-OFFICE
           END-IF.                       
                                                                        
A05189     MOVE SPACES TO WS-READ-ONLY-ORDER                            
           MOVE 'N' TO WS-CHECK-CRAWL.                                  
           MOVE +1 TO WS-4423-SUB1.                                     
           MOVE +1 TO WS-NB-SUB1.                                       
A05189     MOVE SPACES TO WS-WORK-TYPES-4109.                           
           PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                    
               WS-SUB1 > 50 OR (WS-WORK-TYPE (WS-SUB1) = SPACES         
P00795                      AND WS-UTIL-TYPE (WS-SUB1) = SPACES)        
                                                                        
                   MOVE WS-WORK-TYPE (WS-SUB1) TO                       
                        WS-4423-WORK-TYPE-CD (WS-4423-SUB1)             
                   MOVE WS-UTIL-TYPE (WS-SUB1) TO                       
                        WS-4423-CODE-UTIL-TYPE (WS-4423-SUB1)           
                   ADD +1 TO WS-4423-SUB1                               
                                                                        
                   IF WS-WORK-TYPE (WS-SUB1) = 'UNB' AND                
                      WS-UTIL-TYPE (WS-SUB1) = 'G'                      
                          MOVE 'Y' TO WS-CHECK-CRAWL                    
                   END-IF                                               
                                                                        
                   SET T1-INDEX TO +1                                   
                   SEARCH T1-WORK-TYPE                                  
                      AT END                                            
                          MOVE ZEROES TO WS-CALCULATE-RES               
A05189                    MOVE SPACES TO WS-AROP-EXTRACT-IND            
A05189                    MOVE SPACES TO WS-AROP-METER-STATUS           
A05189                    MOVE SPACES TO WS-AROP-METER-REAS             
                      WHEN WS-WORK-TYPE (WS-SUB1) =                     
                           T1-WORK-TYPE-CD (T1-INDEX)                   
                               MOVE T1-EST-LABOR-HRS (T1-INDEX) TO      
                                   WS-CALCULATE-RES                     
A05189                         MOVE T1-AROP-EXTRACT-IND (T1-INDEX) TO   
A05189                             WS-AROP-EXTRACT-IND                  
A05189                         MOVE T1-CODE-METER-STATUS (T1-INDEX) TO  
A05189                             WS-AROP-METER-STATUS                 
A05189                         MOVE T1-CODE-STATUS-REAS (T1-INDEX) TO   
A05189                             WS-AROP-METER-REAS                   
                   END-SEARCH                                           
                   ADD WS-CALCULATE-RES TO WS-WK-TOTAL-RES              
                                                                        
                   EVALUATE TRUE                                        
                      WHEN LINK-ORDER-TYPE-CD(1:3) = 'OFF'              
                          IF WS-UTIL-TYPE (WS-SUB1) = 'E' AND           
                             AT-ACCOUNT-TYPE-CODE = 'R'                 
                                MOVE 'Y' TO WS-AUTO-UPDATE              
                          END-IF                                        
                          IF WS-UTIL-TYPE (WS-SUB1) = 'G' AND           
                            (WS-METER-STATUS (WS-SUB1) = 'J' OR 'K')    
                                CONTINUE                                
                          ELSE                                          
                            IF WS-UTIL-TYPE (WS-SUB1) = 'G' AND         
                             (WS-WORK-TYPE (WS-SUB1) = 'BLK' OR 'CAT' OR
                                           'RMC' OR 'RS2' OR 'RMM')     
                                 MOVE 'Y' TO WS-LOG-TURNOFF             
                            END-IF                                      
                          END-IF                                        
                      WHEN LINK-ORDER-TYPE-CD(1:2) = 'CC'               
                      WHEN LINK-ORDER-TYPE-CD(1:2) = 'NC'               
                      WHEN LINK-ORDER-TYPE-CD = 'FM001'                 
P0795B                    IF WS-UTIL-TYPE (WS-SUB1) = 'G' AND           
P0795B                      (WS-METER-STATUS (WS-SUB1) = 'J' OR 'K')    
P0795B                          CONTINUE                                
P0795B                    ELSE                                          
                            IF WS-UTIL-TYPE (WS-SUB1) = 'G' AND         
                              (WS-WORK-TYPE (WS-SUB1) = 'BLK' OR 'RMM') 
                                MOVE 'Y' TO WS-LOG-TURNOFF              
                            END-IF                                      
                          END-IF                                        
                      WHEN LINK-ORDER-TYPE-CD = 'FM003'                 
P0795B                    IF WS-UTIL-TYPE (WS-SUB1) = 'G' AND           
P0795B                      (WS-METER-STATUS (WS-SUB1) = 'J' OR 'K')    
P0795B                          CONTINUE                                
P0795B                    ELSE                                          
                            IF WS-UTIL-TYPE (WS-SUB1) = 'G' AND         
                              (WS-WORK-TYPE (WS-SUB1) = 'BLK' OR        
                                                      'RMM' OR 'RS2')   
                                MOVE 'Y' TO WS-LOG-TURNOFF              
                            END-IF                                      
                          END-IF                                        
                  END-EVALUATE                                          
P0795A            IF WS-WORK-TYPE (WS-SUB1) > SPACES                    
P0795A               MOVE WS-WORK-TYPE (WS-SUB1) TO                     
P0795A                       WS-WORK-TYPE-NB (WS-NB-SUB1)               
P01176               IF WS-WORK-TYPE (WS-SUB1) = 'MCU' OR 'MCB'         
P01176                  MOVE 'SOL' TO WS-WORK-TYPE-NB (WS-NB-SUB1)      
P01176               ELSE                                               
P01176                 IF WS-WORK-TYPE (WS-SUB1) = 'RMT'                
P01176                    MOVE 'RMM' TO WS-WORK-TYPE-NB (WS-NB-SUB1)    
P01176                 END-IF                                           
P01176               END-IF                                             
P0795A               MOVE WS-UTIL-TYPE (WS-SUB1) TO                     
P0795A                       WS-UTIL-TYPE-NB (WS-NB-SUB1)               
P0795A               MOVE WS-METER-IND (WS-SUB1) TO                     
P0795A                       WS-METER-IND-NB (WS-NB-SUB1)               
P0795A               ADD +1 TO WS-NB-SUB1                               
A05189               IF WS-READ-ONLY-ORDER = SPACES                     
A05189                  MOVE WS-AROP-EXTRACT-IND TO WS-READ-ONLY-ORDER  
A05189               ELSE                                               
A05189                  IF WS-AROP-EXTRACT-IND NOT = 'Y' AND            
A05189                     WS-READ-ONLY-ORDER = 'Y'                     
A05189                       MOVE 'N' TO WS-READ-ONLY-ORDER             
A05189                  END-IF                                          
A05189               END-IF                                             
A05189               STRING WS-WORK-TYPES-4109 DELIMITED BY SPACE       
A05189                      WS-WORK-TYPE (WS-SUB1) DELIMITED BY SIZE    
A05189                      WS-UTIL-TYPE (WS-SUB1) DELIMITED BY SIZE    
A05189                      ';' DELIMITED BY SIZE                       
A05189                     INTO WS-WORK-TYPES-4109                      
P0795A            END-IF                                                
           END-PERFORM.                                                 
                                                                        
A05189     IF WS-READ-ONLY-ORDER = 'Y' AND                              
A05189         LINK-APPLIANCE-LIT-FL NOT = 'Y' AND                      
A05189         LINK-RELEASE-REQD-FL  NOT = 'Y' AND                      
A05189         LINK-ASSIGNED-DATE NOT = WS-CURRENT-DATE AND             
A05189         LINK-FRO-FL NOT = 'Y' AND                                
A05189         WS-CALC-ACTIVE-WKAREA NOT = 'Y' AND                      
A05189         WS-CALCULATE-WKAREA = 'Y'                                
A05189        PERFORM 3200-CALL-CSR04849  THRU 3200-EXIT                
A05189     END-IF                                                       
A05189     IF AROP-ELIGIBLE-FL-4849 = 'Y'                               
A05189        IF L4-COMPANY-NO = '26'                                   
A05189            MOVE 'AROPPSNC' TO S-WORK-AREA                        
A05189        ELSE                                                      
A05189            MOVE 'AROPSCEG' TO S-WORK-AREA                        
A05189        END-IF                                                    
A05189        MOVE SPACES TO S-BUSINESS-UNIT                            
A05189        MOVE SPACES TO S-WORK-DISTRICT                            
A05189     ELSE                                                         
              IF WS-CALCULATE-WKAREA NOT = 'N'                          
                 MOVE 'N' TO CRAWL-IND-1116                             
                 IF LINK-PROGRAM-ID = 'CSR04482' AND                    
                    (LINK-CRAWL-APPL-FL  = 'Y' OR 'N')                  
                       MOVE 'Y' TO WS-CHECK-CRAWL                       
                 END-IF                                                 
                 IF WS-NEW-ORDER-FL = 'N'AND                            
                    (LINK-PROGRAM-ID = 'CSR04476' OR                    
D11099              (LINK-PROGRAM-ID = 'CSR04482' AND                   
D11099               LINK-CRAWL-APPL-FL = 'P'))                         
                       MOVE 'Y' TO WS-CHECK-CRAWL                       
                 END-IF                                                 
                 IF WS-CHECK-CRAWL = 'Y' AND                            
                    WS-CRAWL-LOCAL-OFFICE = 'Y'                         
                      IF LINK-PROGRAM-ID = 'CSR04482' AND               
P0795C                   (LINK-CRAWL-APPL-FL  = 'Y' OR 'N')             
                         MOVE LINK-CRAWL-APPL-FL TO CRAWL-IND-1116      
P0795C                ELSE                                              
                        IF WS-NEW-ORDER-FL = 'Y'                        
                          PERFORM 7600-APPLIANCES-EXIST THRU 7600-EXIT  
                          IF WS-APPLIANCES-AT-PREMISE = 'N'             
                             MOVE 'Y' TO CRAWL-IND-1116                 
                          ELSE                                          
                            PERFORM 7500-CRAWL-APPLIANCES THRU 7500-EXIT
                          END-IF                                        
                        ELSE                                            
                          PERFORM 7510-SO-CRAWL-APPLIANCE THRU 7510-EXIT
                          MOVE WS-SO-CRAWL-EXISTS TO CRAWL-IND-1116     
                        END-IF                                          
P0795C                END-IF                                            
                 END-IF                                                 
                 PERFORM 3000-CALL-CSR01116 THRU 3000-EXIT              
                 MOVE WORK-AREA-1116 TO S-WORK-AREA                     
P00718           MOVE BUSINESS-UNIT-1116 TO S-BUSINESS-UNIT             
P00718           PERFORM 3120-GET-WKDIST    THRU 3120-EXIT              
              ELSE                                                      
                 MOVE LINK-WORK-AREA-ID TO S-WORK-AREA                  
P00718           MOVE SPACES            TO S-BUSINESS-UNIT              
P00718           MOVE SPACES            TO S-WORK-DISTRICT              
              END-IF                                                    
A05189     END-IF                                                       
A05189     MOVE WS-READ-ONLY-ORDER TO S-AROP-READ-ONLY                  
           ADD +1 TO CTR-ROWS.                                          
           MOVE WS-WK-TOTAL-RES TO S-TOTAL-RES.                         
DT6878     IF WS-NEW-ORDER-FL = 'N'  OR SEB-DATABASE                    
              MOVE 'N' TO WS-LOG-TURNOFF                                
           END-IF                                                       
           IF WS-LOG-TURNOFF = 'Y'                                      
               EVALUATE WS-AUTO-UPDATE                                  
                   WHEN 'Y'                                             
                       MOVE 'A' TO S-DISCONNECT-CD                      
                   WHEN 'N'                                             
                       MOVE 'D' TO S-DISCONNECT-CD                      
               END-EVALUATE                                             
           ELSE                                                         
               MOVE 'N' TO S-DISCONNECT-CD
           END-IF.                             
                                                                        
      *  VALIDATE ASSIGNED DATE                                                 
                                                                        
           PERFORM 3100-CALL-CSR04109 THRU 3100-EXIT.                   
                                                                        
           PERFORM VARYING T2-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T2-INDEX > 100 OR 
               T2-CALENDAR-DT (T2-INDEX) = SPACES                               
                   MOVE T2-CALENDAR-DT (T2-INDEX) TO S-CALENDAR-DT      
                   MOVE T2-GOOD-DAY (T2-INDEX) TO S-GOOD-DAY            
                   MOVE T2-TOTAL-SO-HRS (T2-INDEX) TO                   
                        WS-TOTAL-SO-HRS-NODEC                           
                   COMPUTE WS-TOTAL-SO-HRS =                            
                           WS-TOTAL-SO-HRS-NODEC  * .1                  
                   MOVE WS-TOTAL-SO-HRS TO S-TOTAL-SO-HRS               
                   MOVE T2-MAX-RE-PER-DAY (T2-INDEX) TO                 
                        S-MAX-RE-PER-DAY                                
                   MOVE T2-TOTAL-SO (T2-INDEX) TO S-TOTAL-SO            
                   MOVE T2-MAX-DAILY-WK-REQ (T2-INDEX) TO               
                        S-MAX-DAILY-WK-REQ                              
                   IF WS-GTT02-DECLARED = 'N'                           
                       PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT        
                   END-IF                                               
                   PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT            
           END-PERFORM.                                                 
                                                                        
           MOVE L4-COMPANY-NO TO WS-4423-COMPANY-NO.                    
           MOVE LINK-ORDER-TYPE-CD TO WS-4423-ORDER-TYPE-CD.            
           PERFORM A1000-APPT-ARRG-REQ THRU A1000-EXIT.                 
           MOVE WS-4423-ARRANGEMENT-FL TO S-ARRANGEMENT-FL.             
                                                                        
P00941     IF AROP-ELIGIBLE-FL-4849 NOT= 'Y' AND                        
P00941        WS-READ-ONLY-ORDER = 'Y'                                  
P00941            MOVE 'Y'    TO WS-ELEC-ONLY-ORDER                     
P00941            PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL             
P00941             WS-SUB1 > 50 OR (WS-UTIL-TYPE (WS-SUB1) = SPACES)    
P00941             IF   WS-UTIL-TYPE (WS-SUB1) NOT = 'E'                
P00941                     AND WS-WORK-TYPE (WS-SUB1) > SPACES          
P00941                  MOVE 'N' TO    WS-ELEC-ONLY-ORDER               
P00941             END-IF                                               
P00941            END-PERFORM                                           
P00941            IF WS-ELEC-ONLY-ORDER NOT= 'N'                        
P00941            IF VC-SERV-ORDER-NO  > ZEROES                         
P00941              PERFORM 7810-CHECK-READ-SOURCE    THRU 7810-EXIT    
P00941            ELSE                                                  
P00941              MOVE AT-ACCOUNT-NO TO MN-ACCOUNT-NO                 
P00941              PERFORM 7811-CHECK-MTRD-RD-SOURCE  THRU 7811-EXIT   
P00941            END-IF                                                
P00941              IF WS-SS-READ-SOURCE NOT= 'N'                       
P00941                MOVE 'SMARTSYNCH'  TO S-WORK-AREA                 
P00941                MOVE SPACES TO S-BUSINESS-UNIT                    
P00941                MOVE SPACES TO S-WORK-DISTRICT                    
P00941              END-IF                                              
P00941            END-IF                                                
P00941       END-IF                                                     
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
               MOVE 'NO DATA' TO S-WORK-AREA                            
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-BUILD-TABLE.                                                
                                                                        
           EXEC SQL                                                     
               FETCH WORK_TYPE_CURSOR                                   
               INTO :L4-WORK-TYPE-CD,                                   
                    :L4-EST-LABOR-HRS,                                  
                    :L4-AROP-EXTRACT-IND,                               
                    :L4-CODE-METER-STATUS,                              
                    :L4-CODE-STATUS-REAS                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE L4-WORK-TYPE-CD    TO                           
                        T1-WORK-TYPE-CD   (T1-INDEX)                    
                   MOVE L4-EST-LABOR-HRS   TO                           
                        T1-EST-LABOR-HRS  (T1-INDEX)                    
                   MOVE L4-AROP-EXTRACT-IND TO                          
                        T1-AROP-EXTRACT-IND (T1-INDEX)                  
                   MOVE L4-CODE-METER-STATUS TO                         
                        T1-CODE-METER-STATUS (T1-INDEX)                 
                   MOVE L4-CODE-STATUS-REAS TO                          
                        T1-CODE-STATUS-REAS (T1-INDEX)                  
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE '2100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE SPACES              TO ABEND-SQL-PREDICATES     
                                                   ABEND-TABLES         
                   MOVE 'CSS_WORK_TYPE'     TO TABLE-1                  
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
                   MOVE L4-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-GET-CURRENT-ACCT.                                           
           MOVE PR-PREMISE-NO TO WS-CPD99-PREMISE-NO.                   
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO TO WS-CURR-ACCOUNT-NO.              
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-CALL-CSR01116.                                              
                                                                        
           MOVE AT-LOCAL-OFFICE TO LOCAL-OFFICE-1116.                   
           MOVE DY-ZIP-CODE TO ZIP-CODE-1116.                           
           MOVE UT-READ-ROUTE TO WS-READ-ROUTE-NUM.                     
           MOVE WS-READ-ROUTE-CHAR TO READ-ROUTE-1116.                  
           MOVE MN-GIS-POINT-ID TO WS-GIS-POINT-ID.                     
           MOVE WS-GIS-POINT-ID-CHAR TO POINT-ID-1116.                  
P0795A*    MOVE LINK-UTIL-TYPE TO CODE-UTIL-TYPE-1116.                          
P0795A*    MOVE LINK-METER-IND TO METER-IND-1116.                               
P0795A*    MOVE LINK-WORK-TYPE TO WORK-TYPE-CD-1116.                            
P0795A     INSPECT WS-UTIL-TYPE-LINE-NB REPLACING ALL LOW-VALUES        
P0795A                                               BY SPACES.         
P0795A     INSPECT WS-METER-IND-LINE-NB REPLACING ALL LOW-VALUES        
P0795A                                               BY SPACES.         
P0795A     INSPECT WS-WORK-TYPE-LINE-NB REPLACING ALL LOW-VALUES        
P0795A                                               BY SPACES.         
           MOVE WS-UTIL-TYPE-LINE-NB TO CODE-UTIL-TYPE-1116.            
           MOVE WS-METER-IND-LINE-NB TO METER-IND-1116.                 
           MOVE WS-WORK-TYPE-LINE-NB TO WORK-TYPE-CD-1116.              
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01116                                             
      *            (:LOCAL-OFFICE-1116,                                 
      *             :CODE-UTIL-TYPE-1116,                               
      *             :WORK-TYPE-CD-1116,                                 
      *             :CRAWL-IND-1116,                                    
      *             :METER-IND-1116,                                    
      *             :ZIP-CODE-1116,                                     
      *             :READ-ROUTE-1116,                                   
      *             :POINT-ID-1116)                                     
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1116
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1116 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01116'            TO TABLE-1                     
              MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1             
              MOVE LOCAL-OFFICE-1116     TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE CODE-UTIL-TYPE-1116   TO HOSTVAR-ELEMENT-2           
              MOVE 'WORK_TYPE_CD'        TO TABLE-ELEMENT-3             
              MOVE WORK-TYPE-CD-1116     TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1116)                                                
      *       WITH PROCEDURE CSR01116                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1116 CURSOR FOR RESULT SET        
      *       :LOC1116                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_1116 INTO                           
                   :RETURN-CODE-1116 ,                                  
                   :WORK-AREA-1116,                                     
P00718             :BUSINESS-UNIT-1116                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3000'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01116'            TO TABLE-1                
                   MOVE 'LOCAL_OFFICE'        TO TABLE-ELEMENT-1        
                   MOVE LOCAL-OFFICE-1116     TO HOSTVAR-ELEMENT-1      
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2        
                   MOVE CODE-UTIL-TYPE-1116   TO HOSTVAR-ELEMENT-2      
                   MOVE 'WORK_TYPE_CD'        TO TABLE-ELEMENT-3        
                   MOVE WORK-TYPE-CD-1116 TO HOSTVAR-ELEMENT-3          
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3100-CALL-CSR04109.                                              
                                                                        
           MOVE S-WORK-AREA TO WORK-AREA-ID-4109.                       
      *    MOVE LINK-ASSIGNED-DATE TO ASSIGNED-DATETIME-4109 (1:10).            
           MOVE WS-CURRENT-DATE TO ASSIGNED-DATETIME-4109 (1:10).       
           MOVE '-00.00.00.000000' TO ASSIGNED-DATETIME-4109 (11:16).   
P0795D*    MOVE ZEROES TO SERV-ORDER-NO-4109.                                   
           MOVE LINK-SERV-ORDER-NO  TO SERV-ORDER-NO-4109.              
           MOVE S-TOTAL-RES TO WS-TOTAL-RES-DEC.                        
           MOVE WS-TOTAL-RES-DEC(1:5) TO WS-TOTAL-RES(1:5).             
           MOVE WS-TOTAL-RES-DEC(6:1) TO WS-TOTAL-RES(6:1).             
           MOVE WS-TOTAL-RES TO TOTAL-RES-4109.                         
           MOVE '062' TO NO-DAYS-4109.                                  
           MOVE SPACES TO SYSTEM-INITIATED-4109.                        
A05189     INSPECT WS-WORK-TYPES-4109 REPLACING ALL LOW-VALUES          
A05189                                               BY SPACES.         
A05189     MOVE WS-WORK-TYPES-4109 TO WORK-TYPES-4109.                  
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04109                                             
      *            (:WORK-AREA-ID-4109,                                 
      *             :ASSIGNED-DATETIME-4109,                            
      *             :SERV-ORDER-NO-4109,                                
      *             :TOTAL-RES-4109,                                    
      *             :NO-DAYS-4109,                                      
      *             :SYSTEM-INITIATED-4109,                             
      *             :WORK-TYPES-4109)                                   
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4109
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4109
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4109 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04109'            TO TABLE-1                     
              MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-1             
              MOVE WORK-AREA-ID-4109     TO HOSTVAR-ELEMENT-1           
              MOVE 'ASSIGNED_DATETIME'   TO TABLE-ELEMENT-2             
              MOVE ASSIGNED-DATETIME-4109 TO HOSTVAR-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4109)                                                
      *       WITH PROCEDURE CSR04109                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4109 CURSOR FOR RESULT SET        
      *       :LOC4109                                                  
      *    END-EXEC.                                                    
                                                                        
           SET T2-INDEX TO 1.                                           
           PERFORM UNTIL NO-MORE-ROWS                                   
              EXEC SQL                                                  
                  FETCH RESULT_SET_CSR_4109 INTO                        
                      :RETURN-CODE-4109,                                
                      :CALENDAR-DT-4109,                                
                      :GOOD-DAY-4109,                                   
                      :TOTAL-SO-HRS-4109,                               
                      :MAX-RE-PER-DAY-4109,                             
                      :TOTAL-SO-4109,                                   
                      :MAX-DAILY-WK-REQ-4109                            
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-4109 NOT = 0 AND                    
                        RETURN-CODE-4109 NOT = +100                     
                        MOVE RETURN-CODE-4109 TO WS-ACTIVE-RETURN-CODE  
                        MOVE PROGRAM-NAME      TO ABEND-PROGRAM         
                        MOVE '3100'            TO ACTIVE-PARAGRAPH      
                        MOVE 'FETCH'           TO ABEND-FUNCTION        
                        MOVE 'CSR04109'        TO TABLE-1               
                        MOVE 'WORK_AREA_ID'    TO TABLE-ELEMENT-1       
                        MOVE WORK-AREA-ID-4109 TO HOSTVAR-ELEMENT-1     
                        MOVE 'ASSIGNED_DATETIME' TO TABLE-ELEMENT-2     
                        MOVE ASSIGNED-DATETIME-4109 TO HOSTVAR-ELEMENT-2
                        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT       
                   END-IF                                               
                   IF RETURN-CODE-4109 = +100                           
                       SET NO-MORE-ROWS TO TRUE                         
                   ELSE                                                 
                       PERFORM 3110-PROCESS-4109 THRU 3110-EXIT         
                   END-IF                                               
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '3100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04109'            TO TABLE-1              
                     MOVE 'WORK_AREA_ID'        TO TABLE-ELEMENT-1      
                     MOVE WORK-AREA-ID-4109     TO HOSTVAR-ELEMENT-1    
                     MOVE 'ASSIGNED_DATETIME'   TO TABLE-ELEMENT-2      
                     MOVE ASSIGNED-DATETIME-4109 TO HOSTVAR-ELEMENT-2   
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y' TO SW-FETCH.                                        
                                                                        
       3100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3110-PROCESS-4109.                                               
                                                                        
           MOVE CALENDAR-DT-4109 TO T2-CALENDAR-DT (T2-INDEX).          
           MOVE GOOD-DAY-4109 TO T2-GOOD-DAY (T2-INDEX).                
           MOVE TOTAL-SO-HRS-4109 TO T2-TOTAL-SO-HRS (T2-INDEX).        
           MOVE MAX-RE-PER-DAY-4109 TO T2-MAX-RE-PER-DAY (T2-INDEX).    
           MOVE TOTAL-SO-4109 TO T2-TOTAL-SO (T2-INDEX).                
           MOVE MAX-DAILY-WK-REQ-4109 TO T2-MAX-DAILY-WK-REQ (T2-INDEX).
           SET T2-INDEX UP BY 1.                                        
                                                                        
       3110-EXIT.                                                       
            EXIT.                                                       
                                                                        
P00718 3120-GET-WKDIST.                                                 
P00718                                                                  
P00718     INSPECT PR-FM-ELEC-SVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-GAS-OPS-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-FLD-SVCS-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-REV-PRT-WKDIST-TEXT  REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     INSPECT PR-FM-DSM-ESVC-WKDIST-TEXT REPLACING ALL LOW-VALUES  
P00718                                                  BY SPACES.      
P00718     EVALUATE TRUE                                                
P00718        WHEN S-BUSINESS-UNIT = 'EOP'                              
P00718         AND PR-FM-ELEC-SVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-ELEC-SVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN S-BUSINESS-UNIT = 'GOP'                              
P00718         AND PR-FM-GAS-OPS-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-GAS-OPS-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN S-BUSINESS-UNIT = 'FSV'                              
P00718         AND PR-FM-FLD-SVCS-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-FLD-SVCS-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718        WHEN S-BUSINESS-UNIT = 'RVP'                              
P00718         AND PR-FM-REV-PRT-WKDIST-TEXT  > ' '                     
P00718             MOVE PR-FM-REV-PRT-WKDIST-TEXT    TO WS-WORK-DISTRICT
P00718        WHEN S-BUSINESS-UNIT = 'DSM'                              
P00718         AND PR-FM-DSM-ESVC-WKDIST-TEXT > ' '                     
P00718             MOVE PR-FM-DSM-ESVC-WKDIST-TEXT   TO WS-WORK-DISTRICT
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718     PERFORM 7700-GET-PRINT-LOC                 THRU 7700-EXIT.   
P00718     MOVE WS-ACCOUNT-NO-NUM                    TO RG-ACCOUNT-NO.  
P00718*    PERFORM 7800-GET-REGISTER-DTLS             THRU 7800-EXIT.           
P00718*    IF (C4-CAD-WORKAREA-FL = 'Y' AND WS-MULTI-REG-MTR = 'N')             
P00718     IF (C4-CAD-WORKAREA-FL = 'Y')                                
P00718        MOVE WS-WORK-DISTRICT                  TO S-WORK-DISTRICT 
P00718     ELSE                                                         
P00718        MOVE SPACES                            TO S-WORK-DISTRICT 
P00718     END-IF.                                                      
P00718                                                                  
P00718 3120-EXIT.                                                       
P00718      EXIT.                                                       
                                                                        
       7000-GET-ACCT-LOCOFF.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AT.LOCAL_OFFICE,
              SERV_ORDER_WORK_CD,
              AT.PREMISE_NO,
              AT.COMPANY_NO,
              ACCOUNT_TYPE_CODE,
              CODE_ACCT_STAT,
              CODE_RENTAL_PROP,
              CUSTOMER_NO,
              FM_ELEC_SVC_WKDIST,
              FM_GAS_OPS_WKDIST,
              FM_FLD_SVCS_WKDIST,
              FM_REV_PRT_WKDIST,
              FM_DSM_ESVC_WKDIST                                
                 INTO :AT-LOCAL-OFFICE,                                 
                      :B1-SERV-ORDER-WORK-CD,                           
                      :PR-PREMISE-NO,                                   
                      :L4-COMPANY-NO,                                   
                      :AT-ACCOUNT-TYPE-CODE,                            
                      :AT-CODE-ACCT-STAT,                               
                      :PR-CODE-RENTAL-PROP,                             
                      :AT-CUSTOMER-NO,                                  
                      :PR-FM-ELEC-SVC-WKDIST,                           
                      :PR-FM-GAS-OPS-WKDIST,                            
                      :PR-FM-FLD-SVCS-WKDIST,                           
                      :PR-FM-REV-PRT-WKDIST,                            
                      :PR-FM-DSM-ESVC-WKDIST                            
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                     
                      CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED),                
                      CSS_PREMISE PR WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND B1.COMPANY_NO = AT.COMPANY_NO                     
                  AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                 
                  AND AT.PREMISE_NO = PR.PREMISE_NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.LOCAL_OFFICE,                                          
MFA-TR*               SERV_ORDER_WORK_CD,                                       
MFA-TR*               AT.PREMISE_NO,                                            
MFA-TR*               AT.COMPANY_NO,                                            
MFA-TR*               ACCOUNT_TYPE_CODE,                                        
MFA-TR*               CODE_ACCT_STAT,                                           
MFA-TR*               CODE_RENTAL_PROP,                                         
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST                                        
MFA-TR*          INTO :AT-LOCAL-OFFICE,                                         
MFA-TR*               :B1-SERV-ORDER-WORK-CD,                                   
MFA-TR*               :PR-PREMISE-NO,                                           
MFA-TR*               :L4-COMPANY-NO,                                           
MFA-TR*               :AT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :AT-CODE-ACCT-STAT,                                       
MFA-TR*               :PR-CODE-RENTAL-PROP,                                     
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :PR-FM-ELEC-SVC-WKDIST,                                   
MFA-TR*               :PR-FM-GAS-OPS-WKDIST,                                    
MFA-TR*               :PR-FM-FLD-SVCS-WKDIST,                                   
MFA-TR*               :PR-FM-REV-PRT-WKDIST,                                    
MFA-TR*               :PR-FM-DSM-ESVC-WKDIST                                    
MFA-TR*          FROM CSS_ACCOUNT AT,                                           
MFA-TR*               CSS_LOCAL_OFFICE B1,                                      
MFA-TR*               CSS_PREMISE PR                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND B1.COMPANY_NO = AT.COMPANY_NO                             
MFA-TR*           AND B1.LOCAL_OFFICE = AT.LOCAL_OFFICE                         
MFA-TR*           AND AT.PREMISE_NO = PR.PREMISE_NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO AT-LOCAL-OFFICE                       
                                   B1-SERV-ORDER-WORK-CD                
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'CSS_LOCAL_OFFICE'  TO TABLE-2                  
                   MOVE 'CSS_PREMISE'       TO TABLE-3                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3200-CALL-CSR04849.                                              
                                                                        
           MOVE LINK-ACCOUNT-NO  TO ACCOUNT-NO-4849.                    
           MOVE LINK-PREMISE-NO  TO PREMISE-NO-4849.                    
           MOVE ZEROS            TO SERV-ORDER-NO-4849.                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04849                                             
      *            (:ACCOUNT-NO-4849,                                   
      *             :PREMISE-NO-4849,                                   
      *             :SERV-ORDER-NO-4849)                                
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4849
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4849
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4849 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04849'            TO TABLE-1                     
              MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4849       TO HOSTVAR-ELEMENT-1           
              MOVE 'PREMISE-NO'          TO TABLE-ELEMENT-2             
              MOVE PREMISE-NO-4849       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4849)                                                
      *       WITH PROCEDURE CSR04849                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4849 CURSOR FOR RESULT SET        
      *       :LOC4849                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               FETCH RESULT_SET_CSR_4849 INTO                           
                   :RETURN-CODE-4849 ,                                  
                   :AROP-ELIGIBLE-FL-4849                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO AROP-ELIGIBLE-FL-4849                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3200'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04849'            TO TABLE-1                
                   MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-4849       TO HOSTVAR-ELEMENT-1      
                   MOVE 'PREMISE-NO'          TO TABLE-ELEMENT-2        
                   MOVE PREMISE-NO-4849       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       3200-EXIT.                                                       
            EXIT.                                                       
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                   
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7010-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN WORK_TYPE_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_WORK_TYPE'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE L4-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE WORK_TYPE_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7030'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_WORK_TYPE'         TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE L4-COMPANY-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-PREM-LOCOFF.                                            
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PR.LOCAL_OFFICE,
              SERV_ORDER_WORK_CD,
              PR.COMPANY_NO,
              CODE_RENTAL_PROP,
              FM_ELEC_SVC_WKDIST,
              FM_GAS_OPS_WKDIST,
              FM_FLD_SVCS_WKDIST,
              FM_REV_PRT_WKDIST,
              FM_DSM_ESVC_WKDIST                                
                 INTO :AT-LOCAL-OFFICE,                                 
                      :B1-SERV-ORDER-WORK-CD,                           
                      :L4-COMPANY-NO,                                   
                      :PR-CODE-RENTAL-PROP,                             
                      :PR-FM-ELEC-SVC-WKDIST,                           
                      :PR-FM-GAS-OPS-WKDIST,                            
                      :PR-FM-FLD-SVCS-WKDIST,                           
                      :PR-FM-REV-PRT-WKDIST,                            
                      :PR-FM-DSM-ESVC-WKDIST                            
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_LOCAL_OFFICE B1 WITH(READUNCOMMITTED)                 
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND B1.COMPANY_NO = PR.COMPANY_NO                     
                  AND B1.LOCAL_OFFICE = PR.LOCAL_OFFICE                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PR.LOCAL_OFFICE,                                          
MFA-TR*               SERV_ORDER_WORK_CD,                                       
MFA-TR*               PR.COMPANY_NO,                                            
MFA-TR*               CODE_RENTAL_PROP,                                         
MFA-TR*               FM_ELEC_SVC_WKDIST,                                       
MFA-TR*               FM_GAS_OPS_WKDIST,                                        
MFA-TR*               FM_FLD_SVCS_WKDIST,                                       
MFA-TR*               FM_REV_PRT_WKDIST,                                        
MFA-TR*               FM_DSM_ESVC_WKDIST                                        
MFA-TR*          INTO :AT-LOCAL-OFFICE,                                         
MFA-TR*               :B1-SERV-ORDER-WORK-CD,                                   
MFA-TR*               :L4-COMPANY-NO,                                           
MFA-TR*               :PR-CODE-RENTAL-PROP,                                     
MFA-TR*               :PR-FM-ELEC-SVC-WKDIST,                                   
MFA-TR*               :PR-FM-GAS-OPS-WKDIST,                                    
MFA-TR*               :PR-FM-FLD-SVCS-WKDIST,                                   
MFA-TR*               :PR-FM-REV-PRT-WKDIST,                                    
MFA-TR*               :PR-FM-DSM-ESVC-WKDIST                                    
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_LOCAL_OFFICE B1                                       
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND B1.COMPANY_NO = PR.COMPANY_NO                             
MFA-TR*           AND B1.LOCAL_OFFICE = PR.LOCAL_OFFICE                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7100                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO AT-LOCAL-OFFICE                       
                                  B1-SERV-ORDER-WORK-CD                 
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'CSS_LOCAL_OFFICE'  TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-GET-ZIP.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DY.ZIP_CODE                                       
                 INTO :DY-ZIP-CODE                                      
                 FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                     
                      CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)               
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND PR.ADDRESS_ID = DY.ADDRESS_ID                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DY.ZIP_CODE                                               
MFA-TR*          INTO :DY-ZIP-CODE                                              
MFA-TR*          FROM CSS_PREMISE PR,                                           
MFA-TR*               CSS_ADDR_FORMATTED DY                                     
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND PR.ADDRESS_ID = DY.ADDRESS_ID                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO DY-ZIP-CODE                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-GET-READ-ROUTE.                                             
                                                                        
           IF WS-NEW-ORDER-FL = 'N'                                     
              MOVE VO-ACCOUNT-NO-PRIOR TO WS-ACCOUNT-NO-H               
           ELSE                                                         
              IF AT-CODE-ACCT-STAT = 'P' AND                            
                 AT-ACCOUNT-NO NOT = WS-CURR-ACCOUNT-NO                 
                 MOVE WS-CURR-ACCOUNT-NO TO WS-ACCOUNT-NO-H             
              ELSE                                                      
                 MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO-H                  
              END-IF                                                    
           END-IF                                                       
           EXEC SQL                                                     
               SELECT TOP(1) READ_ROUTE                                        
                 INTO :UT-READ-ROUTE                                    
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-H                     
                  AND READ_ROUTE > 0                                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT READ_ROUTE                                                
MFA-TR*          INTO :UT-READ-ROUTE                                            
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-H                             
MFA-TR*           AND READ_ROUTE > 0                                            
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO UT-READ-ROUTE                         
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_UTIL_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-GET-POINT-ID.                                               
                                                                        
           IF WS-NEW-ORDER-FL = 'N'                                     
              MOVE VO-ACCOUNT-NO-PRIOR TO WS-ACCOUNT-NO-H               
           ELSE                                                         
              MOVE AT-ACCOUNT-NO TO WS-ACCOUNT-NO-H                     
           END-IF                                                       
           EXEC SQL                                                     
               SELECT TOP(1) GIS_POINT_ID                                      
                 INTO :MN-GIS-POINT-ID                                  
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-H                     
                  AND GIS_POINT_ID > 0                                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GIS_POINT_ID                                              
MFA-TR*          INTO :MN-GIS-POINT-ID                                          
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-H                             
MFA-TR*           AND GIS_POINT_ID > 0                                          
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO MN-GIS-POINT-ID                       
                                  WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-CRAWL-APPLIANCES.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CRAWL_FL                                          
                 INTO :JA-CRAWL-FL                                      
                 FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                   
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                  AND LA.COMPANY_NO = JA.COMPANY_NO                     
                  AND LA.APPLIANCE_CD =  JA.APPLIANCE_CD                
                  AND CRAWL_FL = 'Y'                                    
                  AND CIS_DISPLAY_FL = 'Y'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CRAWL_FL                                                  
MFA-TR*          INTO :JA-CRAWL-FL                                              
MFA-TR*          FROM CSS_APPLIANCE LA,                                         
MFA-TR*               CSS_MKT_APPLIANCE JA                                      
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*           AND LA.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND LA.APPLIANCE_CD =  JA.APPLIANCE_CD                        
MFA-TR*           AND CRAWL_FL = 'Y'                                            
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO CRAWL-IND-1116                           
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO CRAWL-IND-1116                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7500'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'    TO TABLE-1                   
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
MAINTN 7510-SO-CRAWL-APPLIANCE.                                         
MAINTN                                                                  
MAINTN     MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO.                 
MAINTN     MOVE WS-SERV-ORDER-NO-NUM TO VQ-SERV-ORDER-NO.               
MAINTN                                                                  
MAINTN     EXEC SQL                                                     
MAINTN         SELECT TOP(1) 'Y'                                               
MAINTN           INTO :WS-SO-CRAWL-EXISTS                               
MAINTN           FROM  CSS_SO_APPLIANCE  VQ WITH(READUNCOMMITTED)               
MAINTN                ,CSS_SO_DATA       VO WITH(READUNCOMMITTED)               
MAINTN                ,CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)               
MAINTN          WHERE VQ.SERV_ORDER_NO = :VQ-SERV-ORDER-NO              
MAINTN             AND VO.SERV_ORDER_NO = VQ.SERV_ORDER_NO              
MAINTN             AND JA.APPLIANCE_CD = VQ.APPLIANCE_CD                
MAINTN             AND JA.COMPANY_NO   = VO.COMPANY_NO                  
MAINTN             AND VQ.LIGHT_IND = 'Y'                               
MAINTN             AND JA.CRAWL_FL = 'Y'                                
MAINTN                                                           
                                                 
MAINTN                                                      
MAINTN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-SO-CRAWL-EXISTS                                       
MFA-TR*          FROM  CSS_SO_APPLIANCE  VQ                                     
MFA-TR*               ,CSS_SO_DATA       VO                                     
MFA-TR*               ,CSS_MKT_APPLIANCE JA                                     
MFA-TR*         WHERE VQ.SERV_ORDER_NO = :VQ-SERV-ORDER-NO                      
MFA-TR*            AND VO.SERV_ORDER_NO = VQ.SERV_ORDER_NO                      
MFA-TR*            AND JA.APPLIANCE_CD = VQ.APPLIANCE_CD                        
MFA-TR*            AND JA.COMPANY_NO   = VO.COMPANY_NO                          
MFA-TR*            AND VQ.LIGHT_IND = 'Y'                                       
MFA-TR*            AND JA.CRAWL_FL = 'Y'                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MAINTN                                                                  
MAINTN     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
MAINTN                                                                  
MAINTN     EVALUATE WS-ACTIVE-RETURN-CODE                               
MAINTN         WHEN SUCCESSFUL-CALL                                     
MAINTN             CONTINUE                                             
MAINTN         WHEN NOT-FOUND                                           
MAINTN             MOVE 'N'  TO  WS-SO-CRAWL-EXISTS                     
MAINTN         WHEN OTHER                                               
MAINTN             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
MAINTN             MOVE '7510'           TO ACTIVE-PARAGRAPH            
MAINTN             MOVE 'SELECT'         TO ABEND-FUNCTION              
MAINTN             MOVE SPACES           TO ABEND-SQL-PREDICATES        
MAINTN                                           ABEND-TABLES           
MAINTN             MOVE 'CSS_SO_APPLIANCE'   TO TABLE-1                 
MAINTN             MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
MAINTN             MOVE VQ-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
MAINTN             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
MAINTN     END-EVALUATE.                                                
MAINTN                                                                  
MAINTN 7510-EXIT.                                                       
MAINTN     EXIT.                                                        
                                                                        
       7600-APPLIANCES-EXIST.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) PREMISE_NO                                        
                 INTO :LA-PREMISE-NO                                    
                 FROM CSS_APPLIANCE WITH(READUNCOMMITTED)                       
                WHERE PREMISE_NO = :PR-PREMISE-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*          INTO :LA-PREMISE-NO                                            
MFA-TR*          FROM CSS_APPLIANCE                                             
MFA-TR*         WHERE PREMISE_NO = :PR-PREMISE-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-APPLIANCES-AT-PREMISE                 
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-APPLIANCES-AT-PREMISE                 
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7600'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'    TO TABLE-1                   
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE PR-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7610-GET-SO-DATA.                                                
                                                                        
           EXEC SQL                                                     
               SELECT WORK_AREA_ID                                      
                     ,ACCOUNT_NO_PRIOR                                  
                     ,ORDER_TYPE_CD                                     
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           ASSIGNED_DATETIME, 121), ' ', '-'), ':', '.') 
           ASSIGNED_DATETIME                                 
                     ,ORDER_STATE_CD                                    
                 INTO :VO-WORK-AREA-ID                                  
                     ,:VO-ACCOUNT-NO-PRIOR                              
                     ,:VO-ORDER-TYPE-CD                                 
                     ,:VO-ASSIGNED-DATETIME                             
                     ,:VO-ORDER-STATE-CD                                
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_AREA_ID                                              
MFA-TR*              ,ACCOUNT_NO_PRIOR                                          
MFA-TR*              ,ORDER_TYPE_CD                                             
MFA-TR*              ,ASSIGNED_DATETIME                                         
MFA-TR*              ,ORDER_STATE_CD                                            
MFA-TR*          INTO :VO-WORK-AREA-ID                                          
MFA-TR*              ,:VO-ACCOUNT-NO-PRIOR                                      
MFA-TR*              ,:VO-ORDER-TYPE-CD                                         
MFA-TR*              ,:VO-ASSIGNED-DATETIME                                     
MFA-TR*              ,:VO-ORDER-STATE-CD                                        
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7610                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7610'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
DT6878*****************************************************************         
DT6878* 7620-GET-DATABASE.                                            *         
DT6878*     SELECTS   DATABASE     (SEB OR CSR) FROM CSS_DELINQUENCY *          
DT6878*****************************************************************         
DT6878 7620-GET-DATABASE.                                               
DT6878                                                                  
DT6878     MOVE 'DATABASE'                       TO   C8-DELINQ-CD.     
DT6878     MOVE L4-COMPANY-NO                    TO   C8-COMPANY-NO.    
DT6878     EXEC SQL                                                     
DT6878        SELECT DELINQ_VALUE                                       
DT6878          INTO :C8-DELINQ-VALUE                                   
DT6878          FROM CSS_DELINQUENCY                                    
DT6878         WHERE DELINQ_CD = :C8-DELINQ-CD                          
DT6878           AND COMPANY_NO = :C8-COMPANY-NO                        
DT6878     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DT6878                                                                  
DT6878     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
DT6878                                                                  
DT6878     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
DT6878        MOVE C8-DELINQ-VALUE TO WS-DATABASE                       
DT6878     ELSE                                                         
DT6878        MOVE '7620'                     TO ACTIVE-PARAGRAPH       
DT6878        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
DT6878        MOVE 'SELECT'                   TO ABEND-FUNCTION         
DT6878        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
DT6878        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
DT6878        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
DT6878        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
DT6878        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
DT6878     END-IF.                                                      
DT6878                                                                  
DT6878 7620-EXIT.                                                       
DT6878     EXIT.                                                        
DT6878*                                                                         
P00718 7700-GET-PRINT-LOC.                                              
P00718                                                                  
P00718     EXEC SQL                                                     
P00718         SELECT CAD_WORKAREA_FL                                   
P00718           INTO :C4-CAD-WORKAREA-FL                               
P00718           FROM CSS_SO_PRINT_LOC WITH(READUNCOMMITTED)                    
P00718          WHERE WORK_AREA_ID = :S-WORK-AREA                       
P00718                                                           
P00718                                                      
P00718     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CAD_WORKAREA_FL                                           
MFA-TR*          INTO :C4-CAD-WORKAREA-FL                                       
MFA-TR*          FROM CSS_SO_PRINT_LOC                                          
MFA-TR*         WHERE WORK_AREA_ID = :S-WORK-AREA                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7700                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00718                                                                  
P00718     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00718                                                                  
P00718     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00718         WHEN SUCCESSFUL-CALL                                     
P00718         WHEN NOT-FOUND                                           
P00718             CONTINUE                                             
P00718         WHEN OTHER                                               
P00718             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00718             MOVE '7700'           TO ACTIVE-PARAGRAPH            
P00718             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00718             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00718                                           ABEND-TABLES           
P00718             MOVE 'CSS_SO_PRINT_LOC' TO TABLE-1                   
P00718             MOVE 'WORK_AREA_ID'   TO TABLE-ELEMENT-1             
P00718             MOVE S-WORK-AREA      TO HOSTVAR-ELEMENT-1           
P00718             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00718     END-EVALUATE.                                                
P00718                                                                  
P00718 7700-EXIT.                                                       
P00718     EXIT.                                                        
                                                                        
P00718*7800-GET-REGISTER-DTLS.                                                  
P00718*                                                                         
P00718*    EXEC SQL                                                             
P00718*       SELECT 'Y'                                                        
P00718*         INTO :WS-MULTI-REG-MTR                                          
P00718*         FROM CSS_REGISTER_READ RG,                                      
P00718*              CSS_MTRD_ENVRNMT MN                                        
P00718*        WHERE MN.ACCOUNT_NO       = :RG-ACCOUNT-NO                       
P00718*          AND MN.ACCOUNT_NO       = RG.ACCOUNT_NO                        
P00718*          AND MN.CODE_UTIL_TYPE   = RG.CODE_UTIL_TYPE                    
P00718*          AND MN.METER_NO         = RG.METER_NO                          
P00718*          AND MN.IC_NO            = RG.IC_NO                             
P00718*          AND MN.MTR_REF_NO       = RG.MTR_REF_NO                        
P00718*        FETCH FIRST 1 ROW ONLY                                           
P00718*         WITH UR                                                         
P00718*         QUERYNO 7800                                                    
P00718*    END-EXEC.                                                            
P00718*                                                                         
P00718*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
P00718*                                                                         
P00718*    EVALUATE WS-ACTIVE-RETURN-CODE                                       
P00718*        WHEN SUCCESSFUL-CALL                                             
P00718*        WHEN -811                                                        
P00718*            CONTINUE                                                     
P00718*        WHEN NOT-FOUND                                                   
P00718*            MOVE 'N'              TO WS-MULTI-REG-MTR                    
P00718*        WHEN OTHER                                                       
P00718*            MOVE PROGRAM-NAME     TO ABEND-PROGRAM                       
P00718*            MOVE '7800'           TO ACTIVE-PARAGRAPH                    
P00718*            MOVE 'SELECT'         TO ABEND-FUNCTION                      
P00718*            MOVE SPACES           TO ABEND-SQL-PREDICATES                
P00718*                                          ABEND-TABLES                   
P00718*            MOVE 'CSS_REGISTER_READ' TO TABLE-1                          
P00718*            MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1                     
P00718*            MOVE RG-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1                   
P00718*            PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                    
P00718*    END-EVALUATE.                                                        
P00718*                                                                         
P00718*7800-EXIT.                                                               
P00718*    EXIT.                                                                
                                                                        
P00941 7810-CHECK-READ-SOURCE.                                          
P00941                                                                  
P00941       EXEC SQL                                                   
P00941          SELECT TOP(1) 'N'                                              
P00941            INTO :WS-SS-READ-SOURCE                               
P00941           FROM CSS_SO_MTR_CHG VC WITH(READUNCOMMITTED)                   
P00941           WHERE VC.SERV_ORDER_NO    = :VC-SERV-ORDER-NO          
P00941             AND VC.MTR_READ_SOURCE_CD NOT IN ('P','R')           
P00941             AND VC.CODE_UTIL_TYPE   = 'E'                        
P00941             AND VC.POST_MTR_CHG_IND = 'Y'                        
P00941                                            
P00941                                                           
P00941                                                      
P00941       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT 'N'                                                      
MFA-TR*           INTO :WS-SS-READ-SOURCE                                       
MFA-TR*          FROM CSS_SO_MTR_CHG VC                                         
MFA-TR*          WHERE VC.SERV_ORDER_NO    = :VC-SERV-ORDER-NO                  
MFA-TR*            AND VC.MTR_READ_SOURCE_CD NOT IN ('P','R')                   
MFA-TR*            AND VC.CODE_UTIL_TYPE   = 'E'                                
MFA-TR*            AND VC.POST_MTR_CHG_IND = 'Y'                                
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7810                                                  
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00941      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
P00941       EVALUATE WS-ACTIVE-RETURN-CODE                             
P00941           WHEN SUCCESSFUL-CALL                                   
P00941           WHEN -811                                              
P00941               CONTINUE                                           
P00941           WHEN NOT-FOUND                                         
P00941               MOVE 'Y' TO WS-SS-READ-SOURCE                      
P00941           WHEN OTHER                                             
P00941               MOVE PROGRAM-NAME     TO ABEND-PROGRAM             
P00941               MOVE '7810'           TO ACTIVE-PARAGRAPH          
P00941               MOVE 'SELECT'         TO ABEND-FUNCTION            
P00941               MOVE SPACES           TO ABEND-SQL-PREDICATES      
P00941                                             ABEND-TABLES         
P00941               MOVE 'CSS_SO_METER' TO TABLE-1                     
P00941               MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1        
P00941               MOVE VC-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
P00941               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
P00941      END-EVALUATE.                                               
                                                                        
P00941 7810-EXIT.                                                       
P00941     EXIT.                                                        
                                                                        
P00941 7811-CHECK-MTRD-RD-SOURCE.                                       
P00941                                                                  
P00941       EXEC SQL                                                   
P00941          SELECT TOP(1) 'N'                                              
P00941            INTO :WS-SS-READ-SOURCE                               
P00941           FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
P00941           WHERE MN.ACCOUNT_NO = :MN-ACCOUNT-NO                   
P00941             AND MN.MTR_READ_SOURCE_CD NOT IN ('P','R')           
P00941             AND MN.CODE_UTIL_TYPE   = 'E'                        
P00941             AND MN.CODE_METER_STATUS <> 'K'                      
P00941                                            
P00941                                                           
P00941                                                      
P00941       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SELECT 'N'                                                      
MFA-TR*           INTO :WS-SS-READ-SOURCE                                       
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN                                       
MFA-TR*          WHERE MN.ACCOUNT_NO = :MN-ACCOUNT-NO                           
MFA-TR*            AND MN.MTR_READ_SOURCE_CD NOT IN ('P','R')                   
MFA-TR*            AND MN.CODE_UTIL_TYPE   = 'E'                                
MFA-TR*            AND MN.CODE_METER_STATUS <> 'K'                              
MFA-TR*          FETCH FIRST 1 ROW ONLY                                         
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7811                                                  
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P00941      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
P00941       EVALUATE WS-ACTIVE-RETURN-CODE                             
P00941           WHEN SUCCESSFUL-CALL                                   
P00941           WHEN -811                                              
P00941               CONTINUE                                           
P00941           WHEN NOT-FOUND                                         
P00941               MOVE 'Y' TO WS-SS-READ-SOURCE                      
P00941           WHEN OTHER                                             
P00941               MOVE PROGRAM-NAME     TO ABEND-PROGRAM             
P00941               MOVE '7811'           TO ACTIVE-PARAGRAPH          
P00941               MOVE 'SELECT'         TO ABEND-FUNCTION            
P00941               MOVE SPACES           TO ABEND-SQL-PREDICATES      
P00941                                             ABEND-TABLES         
P00941               MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                 
P00941               MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1        
P00941               MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1      
P00941               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
P00941      END-EVALUATE.                                               
                                                                        
P00941 7811-EXIT.                                                       
P00941     EXIT.                                                        
                                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04480_R2                            
             (                                                          
              RETURN_CODE,                                              
              CALENDAR_DT,                                              
              GOOD_DAY,                                                 
              TOTAL_SO_HRS,                                             
              MAX_RE_PER_DAY,                                           
              TOTAL_SO,                                                 
              MAX_DAILY_WK_REQ                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-CALENDAR-DT,                                          
               :S-GOOD-DAY,                                             
               :S-TOTAL-SO-HRS,                                         
               :S-MAX-RE-PER-DAY,                                       
               :S-TOTAL-SO,                                             
               :S-MAX-DAILY-WK-REQ                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04480_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CALENDAR_DT,                                                      
MFA-TR*       GOOD_DAY,                                                         
MFA-TR*       TOTAL_SO_HRS,                                                     
MFA-TR*       MAX_RE_PER_DAY,                                                   
MFA-TR*       TOTAL_SO,                                                         
MFA-TR*       MAX_DAILY_WK_REQ                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-CALENDAR-DT,                                                  
MFA-TR*        :S-GOOD-DAY,                                                     
MFA-TR*        :S-TOTAL-SO-HRS,                                                 
MFA-TR*        :S-MAX-RE-PER-DAY,                                               
MFA-TR*        :S-TOTAL-SO,                                                     
MFA-TR*        :S-MAX-DAILY-WK-REQ                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04480_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04480_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04480_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8002'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04480_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD04423.                                               00440000
                                                                        
