       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04479.                                          
       AUTHOR.       FRAN BARRY.                                        
       DATE-WRITTEN. AUG 2011.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH IS USED TO     *        
      *  GET PREMISE ORDERS AND METER INFORMATION DURING THE SERVICE   *        
      *  ORDER INITIATION PROCESS.                                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  08/16/2011 FMB       INITIAL VERSION                          *        
A04670*  07/17/2011 FMB       INCLUDE ON HOLD MOW ORDERS IN DEFAULT    *        
A04670*                       WORK TYPE CALCULATION IF ACTIVE CC       *        
A04670*                       EXISTS. BUILD UT FROM ORDER NOT PREMISE  *        
A04670*                       IF PENDING ACCOUNT CREATED VIA SAVE AS.  *        
P00795*  03/10/2014 PK44514   ALL OTHER ORDER CHANGES.                 *        
P00795*  07/14/2014 PK44514   SEND BACK NUMEBR OF GAS & ELEC METERS    *        
P0795A*  11/18/2014 PK44514   RETURN UTILTIY DETAILS FROM ACCT WHEN    *        
P0795A*                       SET ADDL DONE ON PREMISES WHERE RATES ARE*        
P0795A*                       COPIED OVER FROM EXISTING PREMISES       *        
P0795B*  01/26/2015 PK44514   TO NOT SEND BACK UNMETERED ROW FOR SETS  *        
P0795B*                       WITH THE METER DETAILS - DEFECT 6418     *        
MAINTN*  05/25/2015 PK44514   MAINTAIN                                 *        
D10486*  04/11/2016 PK44514   ENABLE READ ROUTE FOR SET ADDL           *        
DT6878*  05/02/2016 PK44514   SEB ORDERS INITIATE AND MAINTAIN         *        
D11837*  08/12/2016 PK44514   SEND BACK SO INST SEQ NO                 *        
P01176*  09/15/2016 PK44514   AUTOMATED GAS METER SAMPLING CHANGES     *        
A05317*  01/03/2017 FMB       INITIALIZE T2-INDEX FOR OPTIMIZATION.    *        
D25926*  01/08/2017 PK44514   CSR02210 - TO NOT ERROR OUT FOR RETURN   *        
D25926*                       CD 100 - REMOVED UTILITIES HAVE 100      *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04479'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04479 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04479_R1'.          
            05  GTT-NAME-2              PIC X(26) VALUE                 
                                        'SESSION.CSR04479_R2'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04479_R3'.          
            05  GTT-NAME-4              PIC X(26) VALUE                 
                                        'SESSION.CSR04479_R4'.          
            05  GTT-NAME-5              PIC X(26) VALUE                 
                                        'SESSION.CSR04479_R5'.          
       01 GTT-RETURN-FIELDS.                                            
           05 GTT-RETURN-FIELDS-1.                                      
              10 S-RETURN-CODE-1       PIC S9(9) COMP VALUE ZERO.       
              10 S-ASSIGNED-DATE       PIC X(10) VALUE SPACES.          
              10 S-SERV-ORDER-NO-1     PIC S9(13)V COMP-3 VALUE 0.      
              10 S-ORDER-TYPE-CD       PIC X(05) VALUE SPACES.          
              10 S-ORDER-STATE-CD      PIC X(01) VALUE SPACES.          
              10 S-CUSTOMER-NAME       PIC X(76) VALUE SPACES.          
              10 S-REMARKS             PIC X(210) VALUE SPACES.         
              10 S-WORK-AREA           PIC X(12) VALUE SPACES.          
              10 S-PHONE               PIC X(10) VALUE SPACES.          
              10 S-REMARK-TYPE         PIC X(01) VALUE SPACES.          
              10 S-SERV-ORDER-STATUS   PIC X(02) VALUE SPACES.          
           05 GTT-RETURN-FIELDS-2.                                      
              10 S-RETURN-CODE-2       PIC S9(9) COMP VALUE ZERO.       
              10 S-CODE-UTIL-TYPE-2    PIC X(01) VALUE SPACES.          
              10 S-METER-NO-2          PIC X(09) VALUE SPACES.          
              10 S-RATE-PLAN-2         PIC X(03) VALUE SPACES.          
              10 S-SUPPLIES            PIC X(15) VALUE SPACES.          
              10 S-METER-LOC           PIC X(02) VALUE SPACES.          
              10 S-METER-STATUS        PIC X(01) VALUE SPACES.          
              10 S-METER-STATUS-REASON PIC X(01) VALUE SPACES.          
              10 S-WORK-TYPE-CD-2      PIC X(03) VALUE SPACES.          
              10 S-METER-READ-INST     PIC X(02) VALUE SPACES.          
              10 S-METER-IND           PIC X(01) VALUE SPACES.          
              10 S-IC-NO-2             PIC S9(4) COMP VALUE ZERO.       
              10 S-MTR-REF-NO-2        PIC S9(4) COMP VALUE 0.          
              10 S-CODE-REV-CLASS-2    PIC X(03) VALUE SPACES.          
              10 S-GAS-MTRS-COUNT-2    PIC S9(4) COMP VALUE 0.          
              10 S-ELEC-MTRS-COUNT-2   PIC S9(4) COMP VALUE 0.          
              10 S-RLSE-IND-2          PIC X(01) VALUE SPACES.          
              10 S-RLSE-NO-2           PIC X(10) VALUE SPACES.          
              10 S-SO-SEQ-NO-2         PIC S9(4) COMP VALUE ZERO.       
           05 GTT-RETURN-FIELDS-3.                                      
              10 S-RETURN-CODE-3       PIC S9(9) COMP VALUE ZERO.       
              10 S-SERV-ORDER-NO-3     PIC S9(13)V COMP-3 VALUE 0.      
              10 S-CODE-UTIL-TYPE-3    PIC X(01) VALUE SPACES.          
              10 S-WORK-TYPE-CD-3      PIC X(03) VALUE SPACES.          
              10 S-IC-NO-3             PIC S9(4) COMP VALUE ZERO.       
              10 S-METER-NO-3          PIC X(09) VALUE SPACES.          
              10 S-MTR-REF-NO-3        PIC S9(4) COMP VALUE 0.          
           05 GTT-RETURN-FIELDS-4.                                      
              10 S-RETURN-CODE-4       PIC S9(9) COMP VALUE ZERO.       
              10 S-RATE-PLAN-4         PIC X(03) VALUE SPACES.          
              10 S-RATE-ITEM-CODE      PIC S9(4) COMP VALUE 0.          
              10 S-CODE-PLAN-STATUS    PIC X(01) VALUE SPACES.          
              10 S-CODE-STATUS-REASON  PIC X(01) VALUE SPACES.          
              10 S-MONTHLY-AMOUNT      PIC S9(3)V99 COMP-3 VALUE 0.     
              10 S-NO-UNITS            PIC S9(4) COMP VALUE 0.          
              10 S-SUBDIVISION-FL      PIC X(01) VALUE SPACES.          
              10 S-IC-NO-4             PIC S9(4) COMP VALUE ZERO.       
              10 S-RATE-PLAN-DESC-4    PIC X(25) VALUE SPACES.          
              10 S-SERVICE-TYPE        PIC X(01) VALUE SPACES.          
              10 S-DIST-NO             PIC X(03) VALUE SPACES.          
              10 S-POLE-NO             PIC X(07) VALUE SPACES.          
           05 GTT-RETURN-FIELDS-5.                                      
              10 S-RETURN-CODE-5       PIC S9(9) COMP VALUE ZERO.       
              10 S-CODE-UTIL-TYPE-5    PIC X(01) VALUE SPACES.          
              10 S-IC-NO-5             PIC S9(4) COMP VALUE 0.          
              10 S-RATE-PLAN-5         PIC X(03) VALUE SPACES.          
              10 S-CODE-REV-CLASS-5    PIC X(03) VALUE SPACES.          
              10 S-RATE-PLAN-DESC-5    PIC X(25) VALUE SPACES.          
              10 S-TOU-FL              PIC X(01) VALUE 'N'.             
              10 S-FIXED-FACTOR-FL     PIC X(01) VALUE 'N'.             
              10 S-BILL-CONTRACT-FL    PIC X(01) VALUE 'N'.             
              10 S-INTERRUPT-FL        PIC X(01) VALUE 'N'.             
              10 S-READ-ROUTE-5        PIC S9(4) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04479'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-CUSTOMER-NO           PIC X(10) VALUE SPACES.          
          05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO         
                                       PIC 9(10).                       
          05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.          
          05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
          05  WS-PREMISE-NO            PIC X(10) VALUE SPACES.          
          05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO          
                                       PIC 9(10).                       
          05  WS-CURR-ACCOUNT-NO       PIC 9(13) VALUE 0.               
          05  WS-NEW-CUSTOMER-NO       PIC S9(10)V COMP-3 VALUE 0.      
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT04-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT05-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-CUST-NAME             PIC X(76) VALUE SPACES.          
          05  WS-WORK-TYPE-S           PIC X(03) VALUE SPACES.          
P00795    05  WS-ORDER-WK-TYPE         PIC X(03) VALUE SPACES.          
P00795    05  WS-WORK-TYPE-COUNT       PIC S9(9) USAGE COMP.            
          05  WS-INPUT-STATUS          PIC X(01) VALUE SPACES.          
          05  WS-INPUT-REASON          PIC X(01) VALUE SPACES.          
          05  WS-RATE-PLAN             PIC X(03) VALUE SPACES.          
          05  WS-REVENUE-CLASS         PIC X(03) VALUE SPACES.          
          05  WS-ACTIVE-ORDERS         PIC X(01) VALUE 'N'.             
A04670    05  WS-ACTIVE-CC-ORDER       PIC X(01) VALUE 'N'.             
          05  WS-SUBDIV-LIGHT          PIC X(01) VALUE 'N'.             
          05  WS-PRICE-FOUND           PIC X(01) VALUE 'Y'.             
          05  WS-2210-DATA-FL          PIC X(01) VALUE 'Y'.             
          05  WS-MN-DATA-FL            PIC X(01) VALUE 'N'.             
P0795A    05  WS-UT-DATA-FL            PIC X(01) VALUE 'N'.             
P0795A    05  WS-SET-ADDL-ORDER-FL     PIC X(01) VALUE 'N'.             
          05  WS-CP-DATA-FL            PIC X(01) VALUE 'N'.             
          05  WS-SET-ORDER-NO          PIC 9(13) VALUE 0.               
          05  WS-SET-ORDER-NO-CHAR     REDEFINES WS-SET-ORDER-NO        
                                       PIC X(13).                       
          05  WS-SET-ORDER-NO-E        PIC 9(13) VALUE 0.               
          05  WS-SET-ORDER-NO-G        PIC 9(13) VALUE 0.               
          05  WS-IC-NO-CHAR            PIC X(04).                       
          05  WS-IC-NO-NUM             REDEFINES WS-IC-NO-CHAR          
                                       PIC 9(04).                       
MAINTN    05  WS-CURRENT-HISTORY-FL    PIC X(01) VALUE SPACES.          
MAINTN    05  WS-SERV-ORDER-NO-C       PIC X(13).                       
MAINTN    05  WS-SERV-ORDER-NO-N       REDEFINES WS-SERV-ORDER-NO-C     
MAINTN                                 PIC 9(13).                       
MAINTN*   05  LINK-SERV-ORDER-NO       PIC X(13) VALUE SPACES.                  
MAINTN*   05  LINK-CURRENT-HISTORY-FL  PIC X(01) VALUE SPACES.                  
MAINTN    05  WS-MAINTAIN              PIC X(08) VALUE 'MAINTAIN'.      
DT6878    05  WS-DATABASE              PIC 9(01) VALUE ZERO.            
DT6878        88  CSR-DATABASE                   VALUE 1.               
DT6878        88  SEB-DATABASE                   VALUE 2.               
                                                                        
          05  WS-ITERATION-STORAGE.                                     
              10  WS-SUB1              PIC 9(02) VALUE ZEROES.          
              10  WS-1ST-STATUS        PIC X(01) VALUE SPACES.          
              10  WS-WORKING-STATUS    PIC X(01) VALUE SPACES.          
              10  WS-WORK-TYPE-O       PIC X(03) OCCURS 25 VALUE SPACES.
              10  WS-MATCH-FOUND       PIC X(01) VALUE SPACES.          
              10  WS-GAS-MTRS-COUNT    PIC 9(04) VALUE ZEROS.           
              10  WS-ELEC-MTRS-COUNT   PIC 9(04) VALUE ZEROS.           
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01 IND-VARIABLES.                                                
          05 WS-NULL1                    PIC S9(04) COMP.               
          05 WS-NULL2                    PIC S9(04) COMP.               
          05 WS-NULL3                    PIC S9(04) COMP.               
          05 WS-NULL4                    PIC S9(04) COMP.               
          05 WS-NULL-RLSE-DT             PIC S9(04) COMP VALUE ZERO.    
                                                                        
       01  CSR02210-CALL-DATA.                                          
           03 ACCOUNT-NO-2210           PIC X(13) VALUE SPACES.         
           03 PREMISE-NO-2210           PIC X(10) VALUE SPACES.         
           03 COMPANY-NO-2210           PIC X(02) VALUE SPACES.         
           03 MKTG-ORDER-2210           PIC X(01) VALUE SPACES.         
           03 RETURN-UTILS-2210         PIC X(01) VALUE SPACES.         
           03 RETURN-DISC-BAL-2210      PIC X(01) VALUE SPACES.         
           03 ORDER-REASON-2210         PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR02210-RETURN-DATA.                                        
           05  RETURN-CODE-2210      PIC S9(9)     COMP VALUE 0.        
           05  ACTIVE-PARA-2210      PIC X(30)     VALUE SPACES.        
           05  TABLE-NAME-2210       PIC X(30)     VALUE SPACES.        
           05  TABLE-ID-2210         PIC X(2)      VALUE SPACES.        
           05  UT-CODE-UTIL-TY-2210  PIC X(1)      VALUE SPACES.        
           05  UT-IC-NO-2210         PIC S9(4)     COMP VALUE 0.        
           05  UT-READ-ROUTE-2210    PIC S9(4)     COMP VALUE 0.        
           05  UT-RATE-PLAN-NO-2210  PIC X(3)      VALUE SPACES.        
           05  UT-RATE-DESC-2210     PIC X(25)     VALUE SPACES.        
           05  UT-CODE-REV-CLA-2210  PIC X(3)      VALUE SPACES.        
           05  UT-READ-CYCLE-2210    PIC X(2)      VALUE SPACES.        
           05  UT-CODE-SIC-NO-2210   PIC X(4)      VALUE SPACES.        
           05  MN-METER-NO-2210      PIC X(9)      VALUE SPACES.        
           05  MN-MTR-REF-NO-2210    PIC S9(4)     COMP VALUE 0.        
           05  MN-CODE-TIME-PE-2210  PIC S9(4)     COMP VALUE 0.        
           05  MN-LAST-READ-VA-2210  PIC S9(12)V999 COMP-3 VALUE 0.     
           05  MN-CD-STUS-RS-2210    PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-T-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-I-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-USAGE-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-CODE-METER-S-2210  PIC X(1)      VALUE SPACES.        
           05  MN-METER-SUPPLY-2210  PIC X(15)     VALUE SPACES.        
           05  MN-CODE-METER-L-2210  PIC X(2)      VALUE SPACES.        
           05  MN-METER-LOC-DE-2210  PIC X(14)     VALUE SPACES.        
           05  MN-METER-IND-2210     PIC X(1)      VALUE SPACES.        
           05  MN-CONSTANT-2210      PIC S9(6)V    COMP-3 VALUE 0.      
           05  MN-NO-DIALS-2210      PIC S9(4) COMP VALUE 0.            
           05  MN-DIST-NODE-PO-2210  PIC X(20)     VALUE SPACES.        
           05  MN-POINT-ID-2210      PIC X(10)     VALUE SPACES.        
           05  MN-SEAL-CODE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-HEX-LOCATION-2210  PIC X(02)     VALUE SPACES.        
           05  MN-INSULATED-IN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-LOCK-TYPE-ID-2210  PIC X(01)     VALUE SPACES.        
           05  MN-DELIVERY-LEV-2210  PIC X(01)     VALUE SPACES.        
           05  MN-UTILITY-SOUR-2210  PIC X(01)     VALUE SPACES.        
           05  MN-IDR-RECIPIEN-2210  PIC X(01)     VALUE SPACES.        
           05  MN-PROGRAM-ID-2210    PIC X(02)     VALUE SPACES.        
           05  MN-MTR-READ-SO-2210   PIC X(01)     VALUE SPACES.        
           05  RG-CODE-REG-ST-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-STATUS-2210   PIC X(1)      VALUE SPACES.        
           05  RG-CODE-TIME-P-2210   PIC S9(4)     COMP VALUE 0.        
           05  RG-CODE-USAGE-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-SRC-2210    PIC X(1)      VALUE SPACES.        
           05  RG-CD-USG-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  RG-LAST-READD-2210    PIC X(10)     VALUE SPACES.        
           05  RG-LST-READVL-2210    PIC S9(12)V9(3) COMP-3 VALUE 0.    
           05  RG-REG-ID-NO-2210     PIC S9(4)     COMP VALUE 0.        
           05  CP-NO-UNITS-2210      PIC S9(9)     COMP VALUE 0.        
           05  CP-CODE-PLAN-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-STATRS-2210     PIC X(1)      VALUE SPACES.        
           05  CP-CD-SVC-TYP-2210    PIC X(1)      VALUE SPACES.        
           05  CP-MTLY-AMT-FX-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-RT-ITEM-CD-2210    PIC S9(4)     COMP VALUE 0.        
           05  CP-LIGHT-NO-2210      PIC S9(4)     COMP VALUE 0.        
           05  CP-POLE-NO-2210       PIC X(7)      VALUE SPACES.        
           05  CP-DIST-NO-2210       PIC X(3)      VALUE SPACES.        
           05  CP-USAGE-FIXED-2210   PIC S9(9)V    COMP-3 VALUE 0.      
           05  CP-ITEM-SEQ-NO-2210   PIC S9(4)     COMP VALUE 0.        
           05  CP-EQUIP-ID-2210      PIC X(2)      VALUE SPACES.        
           05  PREM-DIR-IND-2210     PIC X(1)      VALUE SPACES.        
           05  SUBDIV-LIGHT-2210 PIC S9(3)V        COMP-3 VALUE 0.      
           05  ACCT-TYPE-2210        PIC X(1)      VALUE SPACES.        
           05  CD-RNTL-PROP-2210     PIC X(1)      VALUE SPACES.        
           05  LL-CUSTOMER-NO-2210   PIC S9(10)    COMP-3 VALUE 0.      
           05  REV-DIST-CD-2210      PIC X(3)      VALUE SPACES.        
           05  DISC-BAL-2210         PIC S9(11)V99 COMP-3 VALUE 0.      
           05  OUT-ACCOUNT-NO-2210   PIC S9(13)V   COMP-3 VALUE 0.      
           05  ACCT-STATUS-2210      PIC X(1)      VALUE SPACES.        
           05  ROW-NO-2210           PIC S9(4)     COMP VALUE 0.        
           05  DEPOSIT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  SEC-TOT-AMT-2210      PIC S9(9)V99  COMP-3 VALUE 0.      
           05  CUR-MTH-ARR-CD-2210   PIC X(01)     VALUE SPACES.        
           05  CREDIT-GROUP-2210     PIC X(01)     VALUE SPACES.        
           05  CURRENT-ACCOUNT-2210  PIC X(01)     VALUE 'Y'.           
           05  DATE-BNKRPT-FL-2210   PIC X(10)     VALUE SPACES.        
           05  FILED-CASE-NO-2210    PIC X(10)     VALUE SPACES.        
           05  DL-NO-2210            PIC X(19)     VALUE SPACES.        
           05  DL-STATE-2210         PIC X(02)     VALUE SPACES.        
           05  SSN-2210              PIC X(09)     VALUE SPACES.        
           05  PRIOR-ACCT-STAT-2210  PIC X(01)     VALUE SPACES.        
           05  READ-CYCLE-2210       PIC X(02)     VALUE SPACES.        
           05  SERV-STRT-DT-2210     PIC X(10)     VALUE SPACES.        
           05  DEP-INTST-RT-2210     PIC S9(2)V99  COMP-3 VALUE 0.      
           05  CP-DT-PLN-ST-2210     PIC X(10)     VALUE SPACES.        
           05  ACTIVE-CONTRACT-2210  PIC X(01)     VALUE SPACES.        
           05  SECURED-RATE-FL-2210  PIC X(01)     VALUE SPACES.        
           05  MN-CODE-MTR-RD-2210   PIC X(02)     VALUE SPACES.        
           05  MN-MTR-PRESS-2210     PIC X(03)     VALUE SPACES.        
           05  ERROR-MSG-NO-02-2210  PIC X(05)     VALUE SPACES.        
           05  ERROR-MSG-NO-A4-2210  PIC X(05)     VALUE SPACES.        
                                                                        
       01  CSR01121-CALL-DATA.                                          
           03  SERV-ORDER-NO-1121       PIC X(13) VALUE SPACES.         
           03  CURRENT-HISTORY-1121     PIC X(01) VALUE 'C'.            
                                                                        
       01  CSR01121-RETURN-DATA.                                        
           03  RETURN-CODE-1121         PIC S9(9) COMP VALUE 0.         
           03  CODE-UTIL-TYPE-1121      PIC X(01) VALUE SPACES.         
           03  SO-INST-SEQ-NO-1121      PIC S9(4) COMP VALUE 0.         
           03  RATE-PLAN-NO-1121        PIC X(03) VALUE SPACES.         
           03  RATE-DESC-1121           PIC X(50) VALUE SPACES.         
           03  METER-NO-1121            PIC X(09) VALUE SPACES.         
           03  METER-LOC-DESC-1121      PIC X(14) VALUE SPACES.         
           03  CODE-MTR-STATUS-WS-1121  PIC X(01) VALUE SPACES.         
           03  CODE-STATUS-REA-WS-1121  PIC X(01) VALUE SPACES.         
           03  METER-SUPPLYING-1121     PIC X(15) VALUE SPACES.         
           03  WORK-TYPE-CD-1121        PIC X(03) VALUE SPACES.         
           03  HOLD-RELEASE-1121        PIC X(01) VALUE SPACES.         
           03  RLSE-NO-1121             PIC X(10) VALUE SPACES.         
           03  RLSE-DATE-1121           PIC X(26) VALUE SPACES.         
           03  CODE-METER-LOC-1121      PIC X(02) VALUE SPACES.         
           03  PER-TEMP-IND-1121        PIC X(01) VALUE SPACES.         
           03  IC-NO-1121               PIC S9(4) COMP VALUE 0.         
           03  METER-IND-1121           PIC X(01) VALUE SPACES.         
           03  MTR-REF-NO-1121          PIC S9(4) COMP VALUE 0.         
           03  RLSE-IND-1121            PIC X(01) VALUE SPACES.         
                                                                        
       01  WS-TABLES.                                                   
           05  WS-STATUS-TABLE.                                         
               10  WS-STATUS-DATA.                                      
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       BLK J'.                              
P01176             15  FILLER  PIC X(16) VALUE                          
P01176                 'STOP       MCB J'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       CAT J'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       RDO A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       RMM K'.                              
P01176             15  FILLER  PIC X(16) VALUE                          
P01176                 'STOP       RMT K'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       HOF A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       RMC K'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       RS2 K'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       RTM K'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       IXC A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       MTC A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       REC A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       UNB A'.                              
P01176             15  FILLER  PIC X(16) VALUE                          
P01176                 'STOP       MCU A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       VRB J'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       UDP A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       SOL A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       SOR A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       SOS A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       FIN K'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       SET A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       ST1 A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       ST2 A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       ST3 A'.                              
                   15  FILLER  PIC X(16) VALUE                          
                       'STOP       TMP A'.                              
               10  WS-STATUS-DATA-R REDEFINES WS-STATUS-DATA.           
                   15  WS-STATUS-LINE     OCCURS 23                     
                                          INDEXED BY WS-STATUS-INDEX  . 
                       20 WS-PROCESS        PIC X(10).                  
                       20 F                 PIC X(01).                  
                       20 WS-WORK-TYPE      PIC X(03).                  
                       20 F                 PIC X(01).                  
                       20 WS-NEW-STATUS     PIC X(01).                  
           05  T2-CSR01121            OCCURS 50                         
                                      INDEXED BY T2-INDEX.              
               10 T2-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.         
               10 T2-SO-INST-SEQ-NO     PIC S9(4) COMP VALUE 0.         
               10 T2-RATE-PLAN-NO       PIC X(03) VALUE SPACES.         
               10 T2-RATE-DESC          PIC X(50) VALUE SPACES.         
               10 T2-METER-NO           PIC X(09) VALUE SPACES.         
               10 T2-METER-LOC-DESC     PIC X(14) VALUE SPACES.         
               10 T2-CODE-MTR-STATUS-WS PIC X(01) VALUE SPACES.         
               10 T2-CODE-STATUS-REA-WS PIC X(01) VALUE SPACES.         
               10 T2-METER-SUPPLYING    PIC X(15) VALUE SPACES.         
               10 T2-OLD-WORK-TYPE-CD   PIC X(03) VALUE SPACES.         
               10 T2-HOLD-RELEASE       PIC X(01) VALUE SPACES.         
               10 T2-RLSE-NO            PIC X(10) VALUE SPACES.         
               10 T2-RLSE-DATE          PIC X(26) VALUE SPACES.         
               10 T2-CODE-METER-LOC     PIC X(02) VALUE SPACES.         
               10 T2-PER-TEMP-IND       PIC X(01) VALUE SPACES.         
               10 T2-IC-NO              PIC S9(4) COMP VALUE 0.         
               10 T2-METER-IND          PIC X(01) VALUE SPACES.         
               10 T2-MTR-REF-NO         PIC S9(4) COMP VALUE 0.         
               10 T2-RLSE-IND           PIC X(01) VALUE SPACES.         
               10 T2-WORK-TYPE-CD       PIC X(03) VALUE SPACES.         
               10 T2-RLSE-REQUIRED      PIC X(01) VALUE SPACES.         
               10 T2-WORK-TYPE          PIC X(03) VALUE SPACES.         
               10 T2-WORK-TYPE-SOURCE   PIC X(01) VALUE SPACES.         
               10 T2-CODE-REV-CLASS     PIC X(03) VALUE SPACES.         
               10 T2-READ-ROUTE         PIC S9(4) COMP VALUE 0.         
           05  T3-ORDERS              OCCURS 25                         
                                      INDEXED BY T3-INDEX.              
               10 T3-ASSIGNED-DATE      PIC X(10) VALUE SPACES.         
               10 T3-SERV-ORDER-NO      PIC S9(13)V COMP-3 VALUE 0.     
               10 T3-ORDER-TYPE-CD      PIC X(05) VALUE SPACES.         
               10 T3-ORDER-STATE-CD     PIC X(01) VALUE SPACES.         
               10 T3-ORDER-GROUP-CD     PIC X(01) VALUE SPACES.         
               10 T3-CUSTOMER-NAME      PIC X(76) VALUE SPACES.         
               10 T3-REMARKS            PIC X(210) VALUE SPACES.        
               10 T3-WORK-AREA          PIC X(12) VALUE SPACES.         
               10 T3-PHONE              PIC X(10) VALUE SPACES.         
               10 T3-REMARK-TYPE        PIC X(01) VALUE SPACES.         
               10 T3-SERV-ORDER-STATUS  PIC X(02) VALUE SPACES.         
           05  T4-CSR02210            OCCURS 100                        
                                      INDEXED BY T4-INDEX.              
               10 T4-RETURN-CODE        PIC S9(9) COMP VALUE 0.         
               10 T4-TABLE-ID           PIC X(02) VALUE SPACES.         
               10 T4-UT-CODE-UTIL-TYPE  PIC X(01) VALUE SPACES.         
               10 T4-UT-IC-NO           PIC S9(4) COMP VALUE 0.         
               10 T4-UT-READ-ROUTE      PIC S9(4) COMP VALUE 0.         
               10 T4-UT-RATE-PLAN-NO    PIC X(03).                      
               10 T4-UT-RATE-DESC       PIC X(25).                      
               10 T4-UT-CODE-REV-CLASS  PIC X(03).                      
               10 T4-UT-READ-CYCLE      PIC X(02).                      
               10 T4-UT-CODE-SIC-NO     PIC X(04).                      
               10 T4-MN-METER-NO        PIC X(09).                      
               10 T4-MN-MTR-REF-NO      PIC S9(4) COMP VALUE 0.         
               10 T4-MN-CODE-TIME-PER   PIC S9(4) COMP VALUE 0.         
               10 T4-MN-LAST-READ-VAL   PIC S9(12)V9(3) COMP-3 VALUE 0. 
               10 T4-MN-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T4-MN-CODE-USAGE-T    PIC X(01) VALUE SPACES.         
               10 T4-MN-CODE-USAGE-I    PIC X(01) VALUE SPACES.         
               10 T4-MN-CODE-USAGE-S    PIC X(01) VALUE SPACES.         
               10 T4-MN-CODE-METER-S    PIC X(01) VALUE SPACES.         
               10 T4-MN-METER-SUPPLY    PIC X(15) VALUE SPACES.         
               10 T4-MN-CODE-METER-LOC  PIC X(02) VALUE SPACES.         
               10 T4-MN-METER-LOC-DESC  PIC X(14) VALUE SPACES.         
               10 T4-MN-METER-IND       PIC X(01) VALUE SPACES.         
               10 T4-MN-CONSTANT        PIC S9(6)V COMP-3 VALUE 0.      
               10 T4-MN-NO-DIALS        PIC S9(4) COMP VALUE 0.         
               10 T4-MN-DIST-NODE-PO    PIC X(20) VALUE SPACES.         
               10 T4-MN-POINT-ID        PIC X(10) VALUE SPACES.         
               10 T4-MN-SEAL-CODE-ID    PIC X(01) VALUE SPACES.         
               10 T4-MN-HEX-LOCATION    PIC X(02) VALUE SPACES.         
               10 T4-MN-INSULATED-IND   PIC X(01) VALUE SPACES.         
               10 T4-MN-LOCK-TYPE-ID    PIC X(01) VALUE SPACES.         
               10 T4-MN-DELIVERY-LEV    PIC X(01) VALUE SPACES.         
               10 T4-MN-UTILITY-SOURCE  PIC X(01) VALUE SPACES.         
               10 T4-MN-IDR-RECIPIENT   PIC X(01) VALUE SPACES.         
               10 T4-MN-PROGRAM-ID      PIC X(02) VALUE SPACES.         
               10 T4-MN-MTR-READ-SOURCE PIC X(01) VALUE SPACES.         
               10 T4-RG-LAST-READD      PIC X(10) VALUE SPACES.         
               10 T4-RG-REG-ID-NO       PIC S9(4) COMP VALUE 0.         
               10 T4-CP-NO-UNITS        PIC S9(9) COMP VALUE 0.         
               10 T4-CP-CODE-PLAN       PIC X(01) VALUE SPACES.         
               10 T4-CP-CD-STAT-REAS    PIC X(01) VALUE SPACES.         
               10 T4-CP-CD-SVC-TYPE     PIC X(01) VALUE SPACES.         
               10 T4-CP-MTHLY-AMT       PIC S9(9)V COMP-3 VALUE 0.      
               10 T4-CP-RT-ITEM-CD      PIC S9(4) COMP VALUE 0.         
               10 T4-CP-LIGHT-NO        PIC S9(4) COMP VALUE 0.         
               10 T4-CP-POLE-NO         PIC X(07) VALUE SPACES.         
               10 T4-CP-DIST-NO         PIC X(03) VALUE SPACES.         
               10 T4-CP-USAGE-FIXED     PIC S9(9)V COMP-3 VALUE 0.      
               10 T4-CP-ITEM-SEQ-NO     PIC S9(4) COMP VALUE 0.         
               10 T4-CP-EQUIP-ID        PIC X(02) VALUE SPACES.         
               10 T4-PREM-DIR-IND       PIC X(01) VALUE SPACES.         
               10 T4-SUBDIV-LIGHT       PIC S9(3)V COMP-3 VALUE 0.      
               10 T4-ACCT-TYPE-CODE     PIC X(01) VALUE SPACES.         
               10 T4-CD-RENTAL-PROP     PIC X(01) VALUE SPACES.         
               10 T4-LL-CUSTOMER-NO     PIC S9(10)V COMP-3 VALUE 0.     
               10 T4-REV-DISTRICT-CD    PIC X(03) VALUE SPACES.         
               10 T4-DISC-BAL           PIC S9(11)V99 COMP-3 VALUE 0.   
               10 T4-OUT-ACCOUNT-NO     PIC S9(13)V COMP-3 VALUE 0.     
               10 T4-ACCT-STATUS        PIC X(01) VALUE SPACES.         
               10 T4-ROW-NO             PIC S9(4) COMP VALUE 0.         
               10 T4-DEPOSIT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T4-SEC-TOT-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
               10 T4-CUR-MTH-ARR-CD     PIC X(01) VALUE SPACES.         
               10 T4-CREDIT-GROUP       PIC X(01) VALUE SPACES.         
               10 T4-CURRENT-ACCOUNT    PIC X(01) VALUE SPACES.         
               10 T4-DATE-BANKRUPT      PIC X(10) VALUE SPACES.         
               10 T4-FILED-CASE-NO      PIC X(10) VALUE SPACES.         
               10 T4-DL-NO              PIC X(19) VALUE SPACES.         
               10 T4-DL-STATE           PIC X(02) VALUE SPACES.         
               10 T4-SSN                PIC X(09) VALUE SPACES.         
               10 T4-PRIOR-ACCT-STAT    PIC X(01) VALUE SPACES.         
               10 T4-READ-CYCLE         PIC X(02) VALUE SPACES.         
               10 T4-SERV-STRT-DT       PIC X(10) VALUE SPACES.         
               10 T4-DEP-INTST-RT       PIC S9(2)V99 COMP-3 VALUE 0.    
               10 T4-CP-DT-PLAN-ST      PIC X(10) VALUE SPACES.         
               10 T4-ACTIVE-CONTRACT    PIC X(01) VALUE SPACES.         
               10 T4-SECURED-RATE-FL    PIC X(01) VALUE SPACES.         
               10 T4-MN-CODE-MTR-RD     PIC X(02) VALUE SPACES.         
               10 T4-MN-MTR-PRESS       PIC X(03) VALUE SPACES.         
               10 T4-WORK-TYPE          PIC X(03) VALUE SPACES.         
               10 T4-WORK-TYPE-SOURCE   PIC X(01) VALUE SPACES.         
           05  T5-INSTRUCTIONS        OCCURS 50                         
                                      INDEXED BY T5-INDEX.              
               10 T5-SERV-ORDER-NO      PIC S9(13)V COMP-3 VALUE 0.     
               10 T5-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.         
               10 T5-WORK-TYPE-CD       PIC X(03) VALUE SPACES.         
               10 T5-IC-NO              PIC S9(04) COMP VALUE 0.        
               10 T5-METER-NO           PIC X(09) VALUE SPACES.         
               10 T5-MTR-REF-NO         PIC S9(04) COMP VALUE 0.        
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOREM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLCNTR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBINTACT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOUTL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOUTG                                                   
           END-EXEC.                                                            
                                                                        
P00795* CSS_ORDER_WK_TYPE L3                                                    
P00795     EXEC SQL                                                             
P00795        INCLUDE TBORWT                                                    
P00795     END-EXEC.                                                            
                                                                        
DT6878     EXEC SQL                                                             
DT6878        INCLUDE TBDELQ                                                    
DT6878     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
      *01 LOC2210 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1121 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
              DECLARE SO-CURSOR CURSOR FOR                              
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,                     
                     SERV_ORDER_NO,                                     
                     VO.ORDER_TYPE_CD,                                  
                     ORDER_STATE_CD,                                    
                     ORDER_GROUP_CD,                                    
                     WORK_AREA_ID,                                      
                     PHONE_NO,                                          
                     SERV_ORDER_STATUS,                                 
                     CASE                                               
                     WHEN DQ.NAME_FORMAT = 'I' THEN                     
                         RTRIM(RTRIM(DQ.LAST_NAME) + ', ' + RTRIM(
           DQ.FIRST_NAME) + ' ' + RTRIM(CIS.SUBSTR3(DQ.MIDDLE_NAME,1,1)
           ))       
                     WHEN DQ.NAME_FORMAT = 'B' THEN                     
                         DQ.FULL_NAME                                   
                     END                                                
              FROM CSS_SO_DATA VO WITH(READUNCOMMITTED),                        
                   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                        
                   CSS_CUSTOMER CU WITH(READUNCOMMITTED),                       
                   CSS_NAME DQ WITH(READUNCOMMITTED),                           
                   CSS_ORDER_TYPE C2 WITH(READUNCOMMITTED)                      
             WHERE VO.PREMISE_NO = :VO-PREMISE-NO                       
      *        AND ASSIGNED_DATETIME >= :VO-ASSIGNED-DATETIME                   
               AND VO.ACCOUNT_NO = AT.ACCOUNT_NO                        
               AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                      
               AND CU.NAME_ID = DQ.NAME_ID                              
               AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                  
               AND VO.COMPANY_NO = C2.COMPANY_NO                        
               AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')                  
               AND VO.SERV_ORDER_NO <> :VO-SERV-ORDER-NO                
             ORDER BY ASSIGNED_DATETIME,                                
                      SERV_ORDER_NO                                     
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SO-CURSOR CURSOR FOR                                      
MFA-TR*       SELECT ASSIGNED_DATETIME,                                         
MFA-TR*              SERV_ORDER_NO,                                             
MFA-TR*              VO.ORDER_TYPE_CD,                                          
MFA-TR*              ORDER_STATE_CD,                                            
MFA-TR*              ORDER_GROUP_CD,                                            
MFA-TR*              WORK_AREA_ID,                                              
MFA-TR*              PHONE_NO,                                                  
MFA-TR*              SERV_ORDER_STATUS,                                         
MFA-TR*              CASE                                                       
MFA-TR*              WHEN DQ.NAME_FORMAT = 'I' THEN                             
MFA-TR*                  RTRIM(RTRIM(DQ.LAST_NAME) || ', ' ||                   
MFA-TR*                        RTRIM(DQ.FIRST_NAME) || ' ' ||                   
MFA-TR*                        RTRIM(SUBSTR(DQ.MIDDLE_NAME,1,1)))               
MFA-TR*              WHEN DQ.NAME_FORMAT = 'B' THEN                             
MFA-TR*                  DQ.FULL_NAME                                           
MFA-TR*              END                                                        
MFA-TR*       FROM CSS_SO_DATA VO,                                              
MFA-TR*            CSS_ACCOUNT AT,                                              
MFA-TR*            CSS_CUSTOMER CU,                                             
MFA-TR*            CSS_NAME DQ,                                                 
MFA-TR*            CSS_ORDER_TYPE C2                                            
MFA-TR*      WHERE VO.PREMISE_NO = :VO-PREMISE-NO                               
MFA-TR*        AND ASSIGNED_DATETIME >= :VO-ASSIGNED-DATETIME                   
MFA-TR*        AND VO.ACCOUNT_NO = AT.ACCOUNT_NO                                
MFA-TR*        AND AT.CUSTOMER_NO = CU.CUSTOMER_NO                              
MFA-TR*        AND CU.NAME_ID = DQ.NAME_ID                                      
MFA-TR*        AND VO.ORDER_TYPE_CD = C2.ORDER_TYPE_CD                          
MFA-TR*        AND VO.COMPANY_NO = C2.COMPANY_NO                                
MFA-TR*        AND VO.ORDER_STATE_CD NOT IN ('C', 'Z')                          
MFA-TR*        AND VO.SERV_ORDER_NO <> :VO-SERV-ORDER-NO                        
MFA-TR*      ORDER BY ASSIGNED_DATETIME,                                        
MFA-TR*               SERV_ORDER_NO                                             
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE SO-INST-CURSOR CURSOR FOR                         
              SELECT CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     MTR_REF_NO,                                        
                     METER_NO,                                          
                     WORK_TYPE_CD                                       
              FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                      
             WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SO-INST-CURSOR CURSOR FOR                                 
MFA-TR*       SELECT CODE_UTIL_TYPE,                                            
MFA-TR*              IC_NO,                                                     
MFA-TR*              MTR_REF_NO,                                                
MFA-TR*              METER_NO,                                                  
MFA-TR*              WORK_TYPE_CD                                               
MFA-TR*       FROM CSS_SO_ORDER_INST                                            
MFA-TR*      WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                            
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 ASSIGNED_DATE        AS ASSIGNED_DATE,                 
                 SERV_ORDER_NO        AS SERV_ORDER_NO,                 
                 ORDER_TYPE_CD        AS ORDER_TYPE_CD,                 
                 ORDER_STATE_CD       AS ORDER_STATE_CD,                
                 CUSTOMER_NAME        AS CUSTOMER_NAME,                 
                 REMARKS              AS REMARKS,                       
                 WORK_AREA            AS WORK_AREA,                     
                 PHONE                AS PHONE,                         
                 REMARK_TYPE          AS REMARK_TYPE,                   
                 SERV_ORDER_STATUS    AS SERV_ORDER_STATUS              
              FROM #CSR04479_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          ASSIGNED_DATE        AS ASSIGNED_DATE,                         
MFA-TR*          SERV_ORDER_NO        AS SERV_ORDER_NO,                         
MFA-TR*          ORDER_TYPE_CD        AS ORDER_TYPE_CD,                         
MFA-TR*          ORDER_STATE_CD       AS ORDER_STATE_CD,                        
MFA-TR*          CUSTOMER_NAME        AS CUSTOMER_NAME,                         
MFA-TR*          REMARKS              AS REMARKS,                               
MFA-TR*          WORK_AREA            AS WORK_AREA,                             
MFA-TR*          PHONE                AS PHONE,                                 
MFA-TR*          REMARK_TYPE          AS REMARK_TYPE,                           
MFA-TR*          SERV_ORDER_STATUS    AS SERV_ORDER_STATUS                      
MFA-TR*       FROM SESSION.CSR04479_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-ASSIGNED-DATE     AS ASSIGNED_DATE,            
                      :S-SERV-ORDER-NO-1   AS SERV_ORDER_NO,            
                      :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,            
                      :S-ORDER-STATE-CD    AS ORDER_STATE_CD,           
                      :S-CUSTOMER-NAME     AS CUSTOMER_NAME,            
                      :S-REMARKS           AS REMARKS,                  
                      :S-WORK-AREA         AS WORK_AREA,                
                      :S-PHONE             AS PHONE,                    
                      :S-REMARK-TYPE       AS REMARK_TYPE,              
                      :S-SERV-ORDER-STATUS AS SERV_ORDER_STATUS         
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-ASSIGNED-DATE     AS ASSIGNED_DATE,                    
MFA-TR*               :S-SERV-ORDER-NO-1   AS SERV_ORDER_NO,                    
MFA-TR*               :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,                    
MFA-TR*               :S-ORDER-STATE-CD    AS ORDER_STATE_CD,                   
MFA-TR*               :S-CUSTOMER-NAME     AS CUSTOMER_NAME,                    
MFA-TR*               :S-REMARKS           AS REMARKS,                          
MFA-TR*               :S-WORK-AREA         AS WORK_AREA,                        
MFA-TR*               :S-PHONE             AS PHONE,                            
MFA-TR*               :S-REMARK-TYPE       AS REMARK_TYPE,                      
MFA-TR*               :S-SERV-ORDER-STATUS AS SERV_ORDER_STATUS                 
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 METER_NO             AS METER_NO,                      
                 RATE_PLAN            AS RATE_PLAN,                     
                 SUPPLIES             AS SUPPLIES,                      
                 METER_LOC            AS METER_LOC,                     
                 METER_STATUS         AS METER_STATUS,                  
                 METER_STATUS_REASON  AS METER_STATUS_REASON,           
                 WORK_TYPE_CD         AS WORK_TYPE_CD,                  
                 METER_READ_INST      AS METER_READ_INST,               
                 METER_IND            AS METER_IND,                     
                 IC_NO                AS IC_NO,                         
                 MTR_REF_NO           AS MTR_REF_NO,                    
                 CODE_REV_CLASS       AS CODE_REV_CLASS,                
                 GAS_MTRS_COUNT       AS GAS_MTRS_COUNT,                
                 ELEC_MTRS_COUNT      AS ELEC_MTRS_COUNT,               
                 RLSE_IND             AS RLSE_IND,                      
                 RLSE_NO              AS RLSE_NO,                       
                 SO_SEQ_NO            AS SO_SEQ_NO                      
              FROM #CSR04479_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          METER_NO             AS METER_NO,                              
MFA-TR*          RATE_PLAN            AS RATE_PLAN,                             
MFA-TR*          SUPPLIES             AS SUPPLIES,                              
MFA-TR*          METER_LOC            AS METER_LOC,                             
MFA-TR*          METER_STATUS         AS METER_STATUS,                          
MFA-TR*          METER_STATUS_REASON  AS METER_STATUS_REASON,                   
MFA-TR*          WORK_TYPE_CD         AS WORK_TYPE_CD,                          
MFA-TR*          METER_READ_INST      AS METER_READ_INST,                       
MFA-TR*          METER_IND            AS METER_IND,                             
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          MTR_REF_NO           AS MTR_REF_NO,                            
MFA-TR*          CODE_REV_CLASS       AS CODE_REV_CLASS,                        
MFA-TR*          GAS_MTRS_COUNT       AS GAS_MTRS_COUNT,                        
MFA-TR*          ELEC_MTRS_COUNT      AS ELEC_MTRS_COUNT,                       
MFA-TR*          RLSE_IND             AS RLSE_IND,                              
MFA-TR*          RLSE_NO              AS RLSE_NO,                               
MFA-TR*          SO_SEQ_NO            AS SO_SEQ_NO                              
MFA-TR*       FROM SESSION.CSR04479_R2                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-CODE-UTIL-TYPE-2  AS CODE_UTIL_TYPE,           
                      :S-METER-NO-2        AS METER_NO,                 
                      :S-RATE-PLAN-2       AS RATE_PLAN,                
                      :S-SUPPLIES          AS SUPPLIES,                 
                      :S-METER-LOC         AS METER_LOC,                
                      :S-METER-STATUS      AS METER_STATUS,             
                      :S-METER-STATUS-REASON AS METER_STATUS_REASON,    
                      :S-WORK-TYPE-CD-2    AS WORK_TYPE_CD,             
                      :S-METER-READ-INST   AS METER_READ_INST,          
                      :S-METER-IND         AS METER_IND,                
                      :S-IC-NO-2           AS IC_NO,                    
                      :S-MTR-REF-NO-2      AS MTR_REF_NO,               
                      :S-CODE-REV-CLASS-2  AS CODE_REV_CLASS,           
                      :S-GAS-MTRS-COUNT-2  AS GAS_MTRS_COUNT,           
                      :S-ELEC-MTRS-COUNT-2 AS ELEC_MTRS_COUNT,          
                      :S-RLSE-IND-2        AS RLSE_IND,                 
                      :S-RLSE-NO-2         AS RLSE_NO,                  
                      :S-SO-SEQ-NO-2       AS SO_SEQ_NO                 
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-CODE-UTIL-TYPE-2  AS CODE_UTIL_TYPE,                   
MFA-TR*               :S-METER-NO-2        AS METER_NO,                         
MFA-TR*               :S-RATE-PLAN-2       AS RATE_PLAN,                        
MFA-TR*               :S-SUPPLIES          AS SUPPLIES,                         
MFA-TR*               :S-METER-LOC         AS METER_LOC,                        
MFA-TR*               :S-METER-STATUS      AS METER_STATUS,                     
MFA-TR*               :S-METER-STATUS-REASON AS METER_STATUS_REASON,            
MFA-TR*               :S-WORK-TYPE-CD-2    AS WORK_TYPE_CD,                     
MFA-TR*               :S-METER-READ-INST   AS METER_READ_INST,                  
MFA-TR*               :S-METER-IND         AS METER_IND,                        
MFA-TR*               :S-IC-NO-2           AS IC_NO,                            
MFA-TR*               :S-MTR-REF-NO-2      AS MTR_REF_NO,                       
MFA-TR*               :S-CODE-REV-CLASS-2  AS CODE_REV_CLASS,                   
MFA-TR*               :S-GAS-MTRS-COUNT-2  AS GAS_MTRS_COUNT,                   
MFA-TR*               :S-ELEC-MTRS-COUNT-2 AS ELEC_MTRS_COUNT,                  
MFA-TR*               :S-RLSE-IND-2        AS RLSE_IND,                         
MFA-TR*               :S-RLSE-NO-2         AS RLSE_NO,                          
MFA-TR*               :S-SO-SEQ-NO-2       AS SO_SEQ_NO                         
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 SERV_ORDER_NO        AS SERV_ORDER_NO,                 
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 WORK_TYPE_CD         AS WORK_TYPE_CD,                  
                 IC_NO                AS IC_NO,                         
                 METER_NO             AS METER_NO,                      
                 MTR_REF_NO           AS MTR_REF_NO                     
              FROM #CSR04479_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          SERV_ORDER_NO        AS SERV_ORDER_NO,                         
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          WORK_TYPE_CD         AS WORK_TYPE_CD,                          
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          METER_NO             AS METER_NO,                              
MFA-TR*          MTR_REF_NO           AS MTR_REF_NO                             
MFA-TR*       FROM SESSION.CSR04479_R3                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3     AS RETURN_CODE,              
                      :S-SERV-ORDER-NO-3   AS SERV_ORDER_NO,            
                      :S-CODE-UTIL-TYPE-3  AS CODE_UTIL_TYPE,           
                      :S-WORK-TYPE-CD-3    AS WORK_TYPE_CD,             
                      :S-IC-NO-3           AS IC_NO,                    
                      :S-METER-NO-3        AS METER_NO,                 
                      :S-MTR-REF-NO-3      AS MTR_REF_NO                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3     AS RETURN_CODE,                      
MFA-TR*               :S-SERV-ORDER-NO-3   AS SERV_ORDER_NO,                    
MFA-TR*               :S-CODE-UTIL-TYPE-3  AS CODE_UTIL_TYPE,                   
MFA-TR*               :S-WORK-TYPE-CD-3    AS WORK_TYPE_CD,                     
MFA-TR*               :S-IC-NO-3           AS IC_NO,                            
MFA-TR*               :S-METER-NO-3        AS METER_NO,                         
MFA-TR*               :S-MTR-REF-NO-3      AS MTR_REF_NO                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C4 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 RATE_PLAN_NO         AS RATE_PLAN_NO,                  
                 RATE_ITEM_CODE       AS RATE_ITEM_CODE,                
                 CODE_PLAN_STATUS     AS CODE_PLAN_STATUS,              
                 CODE_STATUS_REASON   AS CODE_STATUS_REASON,            
                 MONTHLY_AMOUNT       AS MONTHLY_AMOUNT,                
                 NO_UNITS             AS NO_UNITS,                      
                 SUBDIVISION_FL       AS SUBDIVISION_FL,                
                 IC_NO                AS IC_NO,                         
                 RATE_PLAN_DESC       AS RATE_PLAN_DESC,                
                 SERVICE_TYPE         AS SERVICE_TYPE,                  
                 DIST_NO              AS DIST_NO,                       
                 POLE_NO              AS POLE_NO                        
              FROM #CSR04479_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          RATE_PLAN_NO         AS RATE_PLAN_NO,                          
MFA-TR*          RATE_ITEM_CODE       AS RATE_ITEM_CODE,                        
MFA-TR*          CODE_PLAN_STATUS     AS CODE_PLAN_STATUS,                      
MFA-TR*          CODE_STATUS_REASON   AS CODE_STATUS_REASON,                    
MFA-TR*          MONTHLY_AMOUNT       AS MONTHLY_AMOUNT,                        
MFA-TR*          NO_UNITS             AS NO_UNITS,                              
MFA-TR*          SUBDIVISION_FL       AS SUBDIVISION_FL,                        
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          RATE_PLAN_DESC       AS RATE_PLAN_DESC,                        
MFA-TR*          SERVICE_TYPE         AS SERVICE_TYPE,                          
MFA-TR*          DIST_NO              AS DIST_NO,                               
MFA-TR*          POLE_NO              AS POLE_NO                                
MFA-TR*       FROM SESSION.CSR04479_R4                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N4 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-4     AS RETURN_CODE,              
                      :S-RATE-PLAN-4       AS RATE_PLAN_NO,             
                      :S-RATE-ITEM-CODE    AS RATE_ITEM_CODE,           
                      :S-CODE-PLAN-STATUS  AS CODE_PLAN_STATUS,         
                      :S-CODE-STATUS-REASON AS CODE_STATUS_REASON,      
                      :S-MONTHLY-AMOUNT    AS MONTHLY_AMOUNT,           
                      :S-NO-UNITS          AS NO_UNITS,                 
                      :S-SUBDIVISION-FL    AS SUBDIVISION_FL,           
                      :S-IC-NO-4           AS IC_NO,                    
                      :S-RATE-PLAN-DESC-4  AS RATE_PLAN_DESC,           
                      :S-SERVICE-TYPE      AS SERVICE_TYPE,             
                      :S-DIST-NO           AS DIST_NO,                  
                      :S-POLE-NO           AS POLE_NO                   
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N4 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-4     AS RETURN_CODE,                      
MFA-TR*               :S-RATE-PLAN-4       AS RATE_PLAN_NO,                     
MFA-TR*               :S-RATE-ITEM-CODE    AS RATE_ITEM_CODE,                   
MFA-TR*               :S-CODE-PLAN-STATUS  AS CODE_PLAN_STATUS,                 
MFA-TR*               :S-CODE-STATUS-REASON AS CODE_STATUS_REASON,              
MFA-TR*               :S-MONTHLY-AMOUNT    AS MONTHLY_AMOUNT,                   
MFA-TR*               :S-NO-UNITS          AS NO_UNITS,                         
MFA-TR*               :S-SUBDIVISION-FL    AS SUBDIVISION_FL,                   
MFA-TR*               :S-IC-NO-4           AS IC_NO,                            
MFA-TR*               :S-RATE-PLAN-DESC-4  AS RATE_PLAN_DESC,                   
MFA-TR*               :S-SERVICE-TYPE      AS SERVICE_TYPE,                     
MFA-TR*               :S-DIST-NO           AS DIST_NO,                          
MFA-TR*               :S-POLE-NO           AS POLE_NO                           
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C5 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 IC_NO                AS IC_NO,                         
                 RATE_PLAN_NO         AS RATE_PLAN_NO,                  
                 CODE_REV_CLASS       AS CODE_REV_CLASS,                
                 RATE_PLAN_DESC       AS RATE_PLAN_DESC,                
                 TOU_FL               AS TOU_FL,                        
                 FIXED_FACTOR_FL      AS FIXED_FACTOR_FL,               
                 BILL_CONTRACT_FL     AS BILL_CONTRACT_FL,              
                 INTERRUPT_FL         AS INTERRUPT_FL,                  
                 READ_ROUTE           AS READ_ROUTE                     
              FROM #CSR04479_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C5 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          RATE_PLAN_NO         AS RATE_PLAN_NO,                          
MFA-TR*          CODE_REV_CLASS       AS CODE_REV_CLASS,                        
MFA-TR*          RATE_PLAN_DESC       AS RATE_PLAN_DESC,                        
MFA-TR*          TOU_FL               AS TOU_FL,                                
MFA-TR*          FIXED_FACTOR_FL      AS FIXED_FACTOR_FL,                       
MFA-TR*          BILL_CONTRACT_FL     AS BILL_CONTRACT_FL,                      
MFA-TR*          INTERRUPT_FL         AS INTERRUPT_FL,                          
MFA-TR*          READ_ROUTE           AS READ_ROUTE                             
MFA-TR*       FROM SESSION.CSR04479_R5                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N5 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-5     AS RETURN_CODE,              
                      :S-CODE-UTIL-TYPE-5  AS CODE_UTIL_TYPE,           
                      :S-IC-NO-5           AS IC_NO,                    
                      :S-RATE-PLAN-5       AS RATE_PLAN_NO,             
                      :S-CODE-REV-CLASS-5  AS CODE_REV_CLASS,           
                      :S-RATE-PLAN-DESC-5  AS RATE_PLAN_DESC,           
                      :S-TOU-FL            AS TOU_FL,                   
                      :S-FIXED-FACTOR-FL   AS FIXED_FACTOR_FL,          
                      :S-BILL-CONTRACT-FL  AS BILL_CONTRACT_FL,         
                      :S-INTERRUPT-FL      AS INTERRUPT_FL,             
                      :S-READ-ROUTE-5      AS READ_ROUTE                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N5 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-5     AS RETURN_CODE,                      
MFA-TR*               :S-CODE-UTIL-TYPE-5  AS CODE_UTIL_TYPE,                   
MFA-TR*               :S-IC-NO-5           AS IC_NO,                            
MFA-TR*               :S-RATE-PLAN-5       AS RATE_PLAN_NO,                     
MFA-TR*               :S-CODE-REV-CLASS-5  AS CODE_REV_CLASS,                   
MFA-TR*               :S-RATE-PLAN-DESC-5  AS RATE_PLAN_DESC,                   
MFA-TR*               :S-TOU-FL            AS TOU_FL,                           
MFA-TR*               :S-FIXED-FACTOR-FL   AS FIXED_FACTOR_FL,                  
MFA-TR*               :S-BILL-CONTRACT-FL  AS BILL_CONTRACT_FL,                 
MFA-TR*               :S-INTERRUPT-FL      AS INTERRUPT_FL,                     
MFA-TR*               :S-READ-ROUTE-5      AS READ_ROUTE                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_2210 CURSOR
MSQ001          FOR CALL CSR02210                                             
                  ( :ACCOUNT-NO-2210
                  , :PREMISE-NO-2210
                  , :COMPANY-NO-2210
                  , :MKTG-ORDER-2210
                  , :RETURN-UTILS-2210
                  , :RETURN-DISC-BAL-2210
                  , :ORDER-REASON-2210
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1121 CURSOR
MSQ001          FOR CALL CSR01121                                             
                  ( :SERV-ORDER-NO-1121
                  , :CURRENT-HISTORY-1121
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-PROCESS             PIC X(10).                          
       01  LINK-ASSIGNED-DATE       PIC X(10).                          
       01  LINK-PROGRAM-ID          PIC X(08).                          
P00795 01  LINK-ORDER-TYPE-CD       PIC X(05).                          
MAINTN 01  LINK-SERV-ORDER-NO       PIC X(13).                          
MAINTN 01  LINK-CURRENT-HISTORY-FL  PIC X(01).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO,                       
                                 LINK-PREMISE-NO,                       
                                 LINK-PROCESS,                          
                                 LINK-ASSIGNED-DATE,                    
                                 LINK-PROGRAM-ID,                       
P00795                           LINK-ORDER-TYPE-CD,                    
MAINTN                           LINK-SERV-ORDER-NO,                    
MAINTN                           LINK-CURRENT-HISTORY-FL.               
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT02-DECLARED                                
                       WS-GTT03-DECLARED                                
                       WS-GTT04-DECLARED                                
                       WS-GTT05-DECLARED.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04479_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04479_R1
              (                                                          
               RETURN_CODE          INT,                            
               ASSIGNED_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
               SERV_ORDER_NO        DECIMAL(13,0),                      
               ORDER_TYPE_CD CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ORDER_STATE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               CUSTOMER_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2,         
               REMARKS CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2,              
               WORK_AREA CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,             
               PHONE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               REMARK_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SERV_ORDER_STATUS CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04479_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04479_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04479_R2
              (                                                          
                 RETURN_CODE          INT,                          
                 CODE_UTIL_TYPE CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,            
                 RATE_PLAN CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,           
                 SUPPLIES CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,            
                 METER_LOC CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,           
                 METER_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 METER_STATUS_REASON CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 METER_READ_INST CHAR(02)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 METER_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
                 IC_NO                SMALLINT,                         
                 MTR_REF_NO           SMALLINT,                         
                 CODE_REV_CLASS CHAR(03)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 GAS_MTRS_COUNT       SMALLINT,                         
                 ELEC_MTRS_COUNT      SMALLINT,                         
                 RLSE_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
                 RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,             
                 SO_SEQ_NO            SMALLINT                          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04479_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04479_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04479_R3
              (                                                          
                 RETURN_CODE          INT,                          
                 SERV_ORDER_NO        DECIMAL(13,0),                    
                 CODE_UTIL_TYPE CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 IC_NO                SMALLINT,                         
                 METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,            
                 MTR_REF_NO           SMALLINT                          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04479_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0104-DECLARE-GTT04.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04479_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04479_R4
              (                                                          
                 RETURN_CODE          INT,                          
                 RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 RATE_ITEM_CODE       SMALLINT,                         
                 CODE_PLAN_STATUS CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 CODE_STATUS_REASON CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 MONTHLY_AMOUNT       DECIMAL(5,2),                     
                 NO_UNITS             SMALLINT,                         
                 SUBDIVISION_FL CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 IC_NO                SMALLINT,                         
                 RATE_PLAN_DESC CHAR(25)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 SERVICE_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 DIST_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,             
                 POLE_NO CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2              
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8004-DELETE-GTT4-ROWS THRU 8004-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0104'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04479_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT04-DECLARED.                               
                                                                        
       0104-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0105-DECLARE-GTT05.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04479_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04479_R5
              (                                                          
                 RETURN_CODE          INT,                          
                 CODE_UTIL_TYPE CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 IC_NO                SMALLINT,                         
                 RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 CODE_REV_CLASS CHAR(03)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 RATE_PLAN_DESC CHAR(25)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 TOU_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,              
                 FIXED_FACTOR_FL CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 BILL_CONTRACT_FL CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 INTERRUPT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 READ_ROUTE           SMALLINT                          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8005-DELETE-GTT5-ROWS THRU 8005-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0105'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04479_R5'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT05-DECLARED.                               
                                                                        
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-SERV-ORDER-NO NOT NUMERIC                            
               MOVE ZEROES TO LINK-SERV-ORDER-NO
           END-IF.                       
           MOVE LINK-PREMISE-NO         TO WS-PREMISE-NO.               
           MOVE WS-PREMISE-NO-NUM       TO VO-PREMISE-NO.               
           MOVE LINK-ACCOUNT-NO         TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO.               
                                                                        
           MOVE LINK-ORDER-TYPE-CD      TO L3-ORDER-TYPE-CD.            
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF (LINK-PROCESS = WS-MAINTAIN AND                           
                 (LINK-SERV-ORDER-NO = ZEROES OR                        
                  LINK-CURRENT-HISTORY-FL = SPACES))  OR                
              (LINK-PROCESS NOT = WS-MAINTAIN AND                       
                 (LINK-PREMISE-NO = ZEROES OR                           
                  LINK-ACCOUNT-NO = ZEROES OR                           
                  LINK-ASSIGNED-DATE = SPACES))                         
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE +100 TO S-RETURN-CODE-1                          
                               S-RETURN-CODE-2                          
                               S-RETURN-CODE-3                          
                               S-RETURN-CODE-4                          
                               S-RETURN-CODE-5                          
                  MOVE 'PARMS ZERO' TO S-CUSTOMER-NAME                  
                  ADD +1 TO CTR-ROWS                                    
                  PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT             
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
                  PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT             
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                  PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT             
                  PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT             
                  PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT             
                  PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT             
                  PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT             
                  PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT             
                  PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           SET T3-INDEX TO 1.                                           
           SET T5-INDEX TO 1.                                           
           MOVE 'N' TO WS-ACTIVE-ORDERS                                 
                       WS-ACTIVE-CC-ORDER.                              
           MOVE WS-CURRENT-TS TO VO-ASSIGNED-DATETIME.                  
           MOVE '00.00.00.000000' TO VO-ASSIGNED-DATETIME(12:15).       
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-C.               
           MOVE WS-SERV-ORDER-NO-N TO VO-SERV-ORDER-NO.                 
           PERFORM 7010-OPEN-SO-CURSOR THRU 7010-EXIT.                  
           PERFORM 2010-FETCH-ROWS THRU 2010-EXIT.                      
           PERFORM 7020-CLOSE-SO-CURSOR THRU 7020-EXIT.                 
                                                                        
           PERFORM 7100-SELECT-ACCOUNT THRU 7100-EXIT.                  
                                                                        
      * T3 - EXISTING ORDERS DATA                                               
           PERFORM 4320-T3-DATA-FOR-RETURN   THRU 4320-EXIT.            
      * T5 - INSTRUCTION ROWS FOR EXISTING ORDERS                               
           PERFORM 4340-T5-DATA-FOR-RETURN   THRU 4340-EXIT.            
                                                                        
DT6878     PERFORM 7500-GET-DATABASE  THRU 7500-EXIT                    
                                                                        
           IF LINK-PROCESS NOT = WS-MAINTAIN                            
              PERFORM 2600-PROCESS-NON-MAINTAIN THRU 2600-EXIT          
           ELSE                                                         
              PERFORM 2610-PROCESS-MAINTAIN THRU 2610-EXIT              
           END-IF                                                       
                                                                        
                                                                        
           IF WS-SUBDIV-LIGHT = 'Y'                                     
               PERFORM 2400-FORMAT-SUBDIV-LIGHT THRU 2400-EXIT
           END-IF.         
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
                            S-RETURN-CODE-5                             
               MOVE 'NO DATA' TO S-CUSTOMER-NAME                        
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT                
               PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT                
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2010-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH SO-CURSOR                                          
                INTO :VO-ASSIGNED-DATETIME,                             
                     :VO-SERV-ORDER-NO,                                 
                     :VO-ORDER-TYPE-CD,                                 
                     :VO-ORDER-STATE-CD,                                
                     :C2-ORDER-GROUP-CD,                                
                     :VO-WORK-AREA-ID,                                  
                     :VO-PHONE-NO,                                      
                     :VO-SERV-ORDER-STATUS,                             
                     :WS-CUST-NAME                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VO-ASSIGNED-DATETIME(1:10) TO                   
                        T3-ASSIGNED-DATE (T3-INDEX)                     
                   MOVE VO-SERV-ORDER-NO TO                             
                        T3-SERV-ORDER-NO (T3-INDEX)                     
                   MOVE VO-ORDER-TYPE-CD TO                             
                        T3-ORDER-TYPE-CD (T3-INDEX)                     
                   MOVE VO-ORDER-STATE-CD TO                            
                        T3-ORDER-STATE-CD (T3-INDEX)                    
                   MOVE C2-ORDER-GROUP-CD TO                            
                        T3-ORDER-GROUP-CD (T3-INDEX)                    
                   MOVE VO-WORK-AREA-ID TO T3-WORK-AREA (T3-INDEX)      
                   MOVE VO-PHONE-NO TO T3-PHONE (T3-INDEX)              
                   MOVE VO-SERV-ORDER-STATUS TO                         
                        T3-SERV-ORDER-STATUS (T3-INDEX)                 
                   IF VO-ORDER-STATE-CD = 'A'                           
                       MOVE 'Y' TO WS-ACTIVE-ORDERS                     
                       IF VO-ORDER-TYPE-CD(1:2) = 'CC'                  
                           MOVE 'Y' TO WS-ACTIVE-CC-ORDER               
                       END-IF                                           
                   END-IF                                               
                   MOVE WS-CUST-NAME TO                                 
                        T3-CUSTOMER-NAME (T3-INDEX)                     
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2010-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_ACCOUNT'        TO TABLE-2                 
                   MOVE 'CSS_CUSTOMER'      TO TABLE-3                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           PERFORM 7000-SELECT-REMARKS THRU 7000-EXIT.                  
           PERFORM 2100-INSTRUCTIONS THRU 2100-EXIT.                    
                                                                        
           SET T3-INDEX UP BY 1.                                        
                                                                        
           GO TO 2010-FETCH-ROWS.                                       
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-INSTRUCTIONS.                                               
                                                                        
           PERFORM 7030-OPEN-INST-CURSOR THRU 7030-EXIT.                
           PERFORM 2110-FETCH-ROWS THRU 2110-EXIT.                      
           PERFORM 7040-CLOSE-INST-CURSOR THRU 7040-EXIT.               
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH SO-INST-CURSOR                                     
                INTO :VI-CODE-UTIL-TYPE,                                
                     :VI-IC-NO,                                         
                     :VI-MTR-REF-NO,                                    
                     :VI-METER-NO,                                      
                     :VI-WORK-TYPE-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VO-SERV-ORDER-NO TO                             
                        T5-SERV-ORDER-NO (T5-INDEX)                     
                   MOVE VI-CODE-UTIL-TYPE TO                            
                        T5-CODE-UTIL-TYPE (T5-INDEX)                    
                   MOVE VI-IC-NO TO T5-IC-NO (T5-INDEX)                 
                   MOVE VI-MTR-REF-NO TO T5-MTR-REF-NO (T5-INDEX)       
                   MOVE VI-METER-NO TO T5-METER-NO (T5-INDEX)           
                   MOVE VI-WORK-TYPE-CD TO T5-WORK-TYPE-CD (T5-INDEX)   
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2110-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2110'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           IF VO-ORDER-TYPE-CD = 'FM002' AND                            
             (VO-ORDER-STATE-CD = 'A' OR 'H' OR 'D' OR 'B' OR 'R')      
                 EVALUATE VI-CODE-UTIL-TYPE                             
                     WHEN 'E'                                           
                         MOVE VO-SERV-ORDER-NO TO WS-SET-ORDER-NO-E     
                     WHEN 'G'                                           
                         MOVE VO-SERV-ORDER-NO TO WS-SET-ORDER-NO-G     
                 END-EVALUATE
           END-IF.                                          
                                                                        
           SET T5-INDEX UP BY 1.                                        
                                                                        
           GO TO 2110-FETCH-ROWS.                                       
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-CALL-CSR02210.                                              
                                                                        
           MOVE AT-ACCOUNT-NO TO ACCOUNT-NO-2210.                       
           MOVE VO-PREMISE-NO TO PREMISE-NO-2210.                       
           MOVE AT-COMPANY-NO TO COMPANY-NO-2210.                       
           MOVE 'N' TO MKTG-ORDER-2210.                                 
           MOVE 'Y' TO RETURN-UTILS-2210.                               
           MOVE 'N' TO RETURN-DISC-BAL-2210.                            
           MOVE ' ' TO ORDER-REASON-2210.                               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR02210                                             
      *           (:ACCOUNT-NO-2210,                                    
      *            :PREMISE-NO-2210,                                    
      *            :COMPANY-NO-2210,                                    
      *            :MKTG-ORDER-2210,                                    
      *            :RETURN-UTILS-2210,                                  
      *            :RETURN-DISC-BAL-2210,                               
      *            :ORDER-REASON-2210)                                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_2210
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_2210 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR02210'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-2210       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC2210)                                                
      *       WITH PROCEDURE CSR02210                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_2210 CURSOR FOR RESULT SET        
      *       :LOC2210                                                  
      *    END-EXEC.                                                    
                                                                        
P00795     MOVE 0 TO WS-GAS-MTRS-COUNT.                                 
P00795     MOVE 0 TO WS-ELEC-MTRS-COUNT.                                
           MOVE 'Y' TO SW-FETCH.                                        
           SET T4-INDEX TO +1.                                          
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_2210 INTO                          
                   :RETURN-CODE-2210,                                   
                   :ACTIVE-PARA-2210,                                   
                   :TABLE-NAME-2210,                                    
                   :TABLE-ID-2210,                                      
                   :UT-CODE-UTIL-TY-2210,                               
                   :UT-IC-NO-2210,                                      
                   :UT-READ-ROUTE-2210,                                 
                   :UT-RATE-PLAN-NO-2210,                               
                   :UT-RATE-DESC-2210,                                  
                   :UT-CODE-REV-CLA-2210,                               
                   :UT-READ-CYCLE-2210,                                 
                   :UT-CODE-SIC-NO-2210,                                
                   :MN-METER-NO-2210,                                   
                   :MN-MTR-REF-NO-2210,                                 
                   :MN-CODE-TIME-PE-2210,                               
                   :MN-LAST-READ-VA-2210,                               
                   :MN-CD-STUS-RS-2210,                                 
                   :MN-CODE-USAGE-T-2210,                               
                   :MN-CODE-USAGE-I-2210,                               
                   :MN-CODE-USAGE-S-2210,                               
                   :MN-CODE-METER-S-2210,                               
                   :MN-METER-SUPPLY-2210,                               
                   :MN-CODE-METER-L-2210,                               
                   :MN-METER-LOC-DE-2210,                               
                   :MN-METER-IND-2210,                                  
                   :MN-CONSTANT-2210,                                   
                   :MN-NO-DIALS-2210,                                   
                   :MN-DIST-NODE-PO-2210,                               
                   :MN-POINT-ID-2210,                                   
                   :MN-SEAL-CODE-ID-2210,                               
                   :MN-HEX-LOCATION-2210,                               
                   :MN-INSULATED-IN-2210,                               
                   :MN-LOCK-TYPE-ID-2210,                               
                   :MN-DELIVERY-LEV-2210,                               
                   :MN-UTILITY-SOUR-2210,                               
                   :MN-IDR-RECIPIEN-2210,                               
                   :MN-PROGRAM-ID-2210,                                 
                   :MN-MTR-READ-SO-2210,                                
                   :RG-CODE-REG-ST-2210,                                
                   :RG-CODE-STATUS-2210,                                
                   :RG-CODE-TIME-P-2210,                                
                   :RG-CODE-USAGE-2210,                                 
                   :RG-CD-USG-SRC-2210,                                 
                   :RG-CD-USG-TYP-2210,                                 
                   :RG-LAST-READD-2210,                                 
                   :RG-LST-READVL-2210,                                 
                   :RG-REG-ID-NO-2210,                                  
                   :CP-NO-UNITS-2210,                                   
                   :CP-CODE-PLAN-2210,                                  
                   :CP-CD-STATRS-2210,                                  
                   :CP-CD-SVC-TYP-2210,                                 
                   :CP-MTLY-AMT-FX-2210,                                
                   :CP-RT-ITEM-CD-2210,                                 
                   :CP-LIGHT-NO-2210,                                   
                   :CP-POLE-NO-2210,                                    
                   :CP-DIST-NO-2210,                                    
                   :CP-USAGE-FIXED-2210,                                
                   :CP-ITEM-SEQ-NO-2210,                                
                   :CP-EQUIP-ID-2210,                                   
                   :PREM-DIR-IND-2210,                                  
                   :SUBDIV-LIGHT-2210,                                  
                   :ACCT-TYPE-2210,                                     
                   :CD-RNTL-PROP-2210,                                  
                   :LL-CUSTOMER-NO-2210,                                
                   :REV-DIST-CD-2210,                                   
                   :DISC-BAL-2210,                                      
                   :OUT-ACCOUNT-NO-2210,                                
                   :ACCT-STATUS-2210,                                   
                   :ROW-NO-2210,                                        
                   :DEPOSIT-AMT-2210,                                   
                   :SEC-TOT-AMT-2210,                                   
                   :CUR-MTH-ARR-CD-2210,                                
                   :CREDIT-GROUP-2210,                                  
                   :CURRENT-ACCOUNT-2210,                               
                   :DATE-BNKRPT-FL-2210,                                
                   :FILED-CASE-NO-2210,                                 
                   :DL-NO-2210,                                         
                   :DL-STATE-2210,                                      
                   :SSN-2210,                                           
                   :PRIOR-ACCT-STAT-2210,                               
                   :READ-CYCLE-2210,                                    
                   :SERV-STRT-DT-2210,                                  
                   :DEP-INTST-RT-2210,                                  
                   :CP-DT-PLN-ST-2210,                                  
                   :ACTIVE-CONTRACT-2210,                               
                   :SECURED-RATE-FL-2210,                               
                   :MN-CODE-MTR-RD-2210,                                
                   :MN-MTR-PRESS-2210,                                  
                   :ERROR-MSG-NO-02-2210,                               
                   :ERROR-MSG-NO-A4-2210                                
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-2210 NOT = 0 AND                    
D25926                  RETURN-CODE-2210 NOT = 100                      
                         MOVE RETURN-CODE-2210 TO WS-ACTIVE-RETURN-CODE 
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '2300'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR02210'        TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-2210   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                     END-IF                                             
                     IF TABLE-ID-2210 = 'CP'                            
                         MOVE 'Y' TO WS-CP-DATA-FL                      
                     END-IF                                             
                     IF TABLE-ID-2210 = 'XX'                            
                         MOVE 'N' TO WS-2210-DATA-FL                    
                     ELSE                                               
                         MOVE 'Y' TO WS-2210-DATA-FL                    
                         PERFORM 2310-LOAD-CSR02210-TABLE THRU 2310-EXIT
                     END-IF                                             
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '2300'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR02210'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-2210       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       2300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2310-LOAD-CSR02210-TABLE.                                        
                                                                        
           MOVE 0 TO T4-RETURN-CODE (T4-INDEX).                         
           MOVE TABLE-ID-2210 TO T4-TABLE-ID (T4-INDEX).                
           MOVE MN-CODE-METER-S-2210 TO T4-MN-CODE-METER-S (T4-INDEX).  
           MOVE UT-CODE-UTIL-TY-2210 TO T4-UT-CODE-UTIL-TYPE (T4-INDEX).
           MOVE UT-IC-NO-2210 TO T4-UT-IC-NO (T4-INDEX).                
           MOVE UT-READ-ROUTE-2210 TO T4-UT-READ-ROUTE (T4-INDEX).      
           MOVE UT-RATE-PLAN-NO-2210 TO T4-UT-RATE-PLAN-NO (T4-INDEX).  
           MOVE UT-RATE-DESC-2210 TO T4-UT-RATE-DESC (T4-INDEX).        
           MOVE UT-CODE-REV-CLA-2210 TO                                 
                T4-UT-CODE-REV-CLASS (T4-INDEX).                        
           MOVE UT-READ-CYCLE-2210 TO T4-UT-READ-CYCLE (T4-INDEX).      
           MOVE UT-CODE-SIC-NO-2210 TO T4-UT-CODE-SIC-NO (T4-INDEX).    
           MOVE MN-METER-NO-2210 TO T4-MN-METER-NO (T4-INDEX).          
           MOVE MN-MTR-REF-NO-2210 TO T4-MN-MTR-REF-NO (T4-INDEX).      
           MOVE MN-CODE-TIME-PE-2210 TO T4-MN-CODE-TIME-PER (T4-INDEX). 
           MOVE MN-LAST-READ-VA-2210 TO T4-MN-LAST-READ-VAL (T4-INDEX). 
           MOVE MN-CD-STUS-RS-2210 TO T4-MN-CD-STAT-REAS (T4-INDEX).    
           MOVE MN-CODE-USAGE-T-2210 TO T4-MN-CODE-USAGE-T (T4-INDEX).  
           MOVE MN-CODE-USAGE-I-2210 TO T4-MN-CODE-USAGE-I (T4-INDEX).  
           MOVE MN-CODE-USAGE-S-2210 TO T4-MN-CODE-USAGE-S (T4-INDEX).  
           MOVE MN-CODE-METER-S-2210 TO T4-MN-CODE-METER-S (T4-INDEX).  
           MOVE MN-METER-SUPPLY-2210 TO T4-MN-METER-SUPPLY (T4-INDEX).  
           MOVE MN-CODE-METER-L-2210 TO                                 
                T4-MN-CODE-METER-LOC (T4-INDEX).                        
           MOVE MN-METER-LOC-DE-2210 TO                                 
                T4-MN-METER-LOC-DESC (T4-INDEX).                        
           MOVE MN-METER-IND-2210 TO T4-MN-METER-IND (T4-INDEX).        
           MOVE MN-CONSTANT-2210 TO T4-MN-CONSTANT (T4-INDEX).          
           MOVE MN-NO-DIALS-2210 TO T4-MN-NO-DIALS (T4-INDEX).          
           MOVE MN-DIST-NODE-PO-2210 TO                                 
                T4-MN-DIST-NODE-PO (T4-INDEX).                          
           MOVE MN-POINT-ID-2210 TO T4-MN-POINT-ID (T4-INDEX).          
           MOVE MN-SEAL-CODE-ID-2210 TO T4-MN-SEAL-CODE-ID (T4-INDEX).  
           MOVE MN-HEX-LOCATION-2210 TO T4-MN-HEX-LOCATION (T4-INDEX).  
           MOVE MN-INSULATED-IN-2210 TO T4-MN-INSULATED-IND (T4-INDEX). 
           MOVE MN-LOCK-TYPE-ID-2210 TO T4-MN-LOCK-TYPE-ID (T4-INDEX).  
           MOVE MN-DELIVERY-LEV-2210 TO T4-MN-DELIVERY-LEV (T4-INDEX).  
           MOVE MN-UTILITY-SOUR-2210 TO                                 
                T4-MN-UTILITY-SOURCE (T4-INDEX).                        
           MOVE MN-IDR-RECIPIEN-2210 TO T4-MN-IDR-RECIPIENT (T4-INDEX). 
           MOVE MN-PROGRAM-ID-2210 TO T4-MN-PROGRAM-ID (T4-INDEX).      
           MOVE MN-MTR-READ-SO-2210 TO                                  
                T4-MN-MTR-READ-SOURCE (T4-INDEX).                       
           MOVE RG-LAST-READD-2210 TO T4-RG-LAST-READD (T4-INDEX).      
           MOVE RG-REG-ID-NO-2210 TO T4-RG-REG-ID-NO (T4-INDEX).        
           MOVE CP-NO-UNITS-2210 TO T4-CP-NO-UNITS (T4-INDEX).          
           MOVE CP-CODE-PLAN-2210 TO T4-CP-CODE-PLAN (T4-INDEX).        
           MOVE CP-CD-STATRS-2210 TO T4-CP-CD-STAT-REAS (T4-INDEX).     
           MOVE CP-CD-SVC-TYP-2210 TO T4-CP-CD-SVC-TYPE (T4-INDEX).     
           MOVE CP-MTLY-AMT-FX-2210 TO T4-CP-MTHLY-AMT (T4-INDEX).      
           MOVE CP-RT-ITEM-CD-2210 TO T4-CP-RT-ITEM-CD (T4-INDEX).      
           MOVE CP-LIGHT-NO-2210 TO T4-CP-LIGHT-NO (T4-INDEX).          
           MOVE CP-POLE-NO-2210 TO T4-CP-POLE-NO (T4-INDEX).            
           MOVE CP-DIST-NO-2210 TO T4-CP-DIST-NO (T4-INDEX).            
           MOVE CP-USAGE-FIXED-2210 TO T4-CP-USAGE-FIXED (T4-INDEX).    
           MOVE CP-ITEM-SEQ-NO-2210 TO T4-CP-ITEM-SEQ-NO (T4-INDEX).    
           MOVE CP-EQUIP-ID-2210 TO T4-CP-EQUIP-ID (T4-INDEX).          
           MOVE PREM-DIR-IND-2210 TO T4-PREM-DIR-IND (T4-INDEX).        
           MOVE SUBDIV-LIGHT-2210 TO T4-SUBDIV-LIGHT (T4-INDEX).        
           MOVE ACCT-TYPE-2210 TO T4-ACCT-TYPE-CODE (T4-INDEX).         
           MOVE CD-RNTL-PROP-2210 TO T4-CD-RENTAL-PROP (T4-INDEX).      
           MOVE LL-CUSTOMER-NO-2210 TO T4-LL-CUSTOMER-NO (T4-INDEX).    
           MOVE REV-DIST-CD-2210 TO T4-REV-DISTRICT-CD (T4-INDEX).      
           MOVE DISC-BAL-2210 TO T4-DISC-BAL (T4-INDEX).                
           MOVE OUT-ACCOUNT-NO-2210 TO T4-OUT-ACCOUNT-NO (T4-INDEX).    
           MOVE ACCT-STATUS-2210 TO T4-ACCT-STATUS (T4-INDEX).          
           MOVE ROW-NO-2210 TO T4-ROW-NO (T4-INDEX).                    
           MOVE DEPOSIT-AMT-2210 TO T4-DEPOSIT-AMT (T4-INDEX).          
           MOVE SEC-TOT-AMT-2210 TO T4-SEC-TOT-AMT (T4-INDEX).          
           MOVE CUR-MTH-ARR-CD-2210 TO T4-CUR-MTH-ARR-CD (T4-INDEX).    
           MOVE CREDIT-GROUP-2210 TO T4-CREDIT-GROUP (T4-INDEX).        
           MOVE CURRENT-ACCOUNT-2210 TO T4-CURRENT-ACCOUNT (T4-INDEX).  
           MOVE DATE-BNKRPT-FL-2210 TO T4-DATE-BANKRUPT (T4-INDEX).     
           MOVE FILED-CASE-NO-2210 TO T4-FILED-CASE-NO (T4-INDEX).      
           MOVE DL-NO-2210 TO T4-DL-NO (T4-INDEX).                      
           MOVE DL-STATE-2210 TO T4-DL-STATE (T4-INDEX).                
           MOVE SSN-2210 TO T4-SSN (T4-INDEX).                          
           MOVE PRIOR-ACCT-STAT-2210 TO T4-PRIOR-ACCT-STAT (T4-INDEX).  
           MOVE READ-CYCLE-2210 TO T4-READ-CYCLE (T4-INDEX).            
           MOVE SERV-STRT-DT-2210 TO T4-SERV-STRT-DT (T4-INDEX).        
           MOVE DEP-INTST-RT-2210 TO T4-DEP-INTST-RT (T4-INDEX).        
           MOVE CP-DT-PLN-ST-2210 TO T4-CP-DT-PLAN-ST (T4-INDEX).       
           MOVE ACTIVE-CONTRACT-2210 TO T4-ACTIVE-CONTRACT (T4-INDEX).  
           MOVE SECURED-RATE-FL-2210 TO T4-SECURED-RATE-FL (T4-INDEX).  
           MOVE MN-CODE-MTR-RD-2210 TO T4-MN-CODE-MTR-RD (T4-INDEX).    
           MOVE MN-MTR-PRESS-2210 TO T4-MN-MTR-PRESS (T4-INDEX).        
P0795A     IF TABLE-ID-2210 = 'UT'                                      
P0795A         MOVE 'Y' TO WS-UT-DATA-FL                                
P0795A     END-IF                                                       
           IF TABLE-ID-2210 = 'MN'                                      
               MOVE 'Y' TO WS-MN-DATA-FL                                
               MOVE MN-CODE-METER-S-2210 TO WS-INPUT-STATUS             
               MOVE MN-CD-STUS-RS-2210 TO WS-INPUT-REASON               
               MOVE UT-RATE-PLAN-NO-2210 TO WS-RATE-PLAN                
               MOVE UT-CODE-REV-CLA-2210 TO WS-REVENUE-CLASS            
P00795         IF T4-UT-CODE-UTIL-TYPE (T4-INDEX) = 'G'                 
P00795            ADD 1 TO WS-GAS-MTRS-COUNT                            
P00795         ELSE IF T4-UT-CODE-UTIL-TYPE (T4-INDEX) = 'E'            
P00795                 ADD 1 TO WS-ELEC-MTRS-COUNT                      
P00795              END-IF                                              
P00795         END-IF                                                   
P00795         IF (LINK-PROCESS = 'STOP' OR 'START') AND                
DT6878               CSR-DATABASE                                       
P00795            PERFORM 3000-TYPE-FROM-STATUS THRU 3000-EXIT          
P00795            MOVE WS-WORK-TYPE-S TO T4-WORK-TYPE (T4-INDEX)        
P00795            MOVE 'S' TO T4-WORK-TYPE-SOURCE (T4-INDEX)            
P00795         ELSE                                                     
P00795            MOVE T4-UT-CODE-UTIL-TYPE (T4-INDEX) TO               
P00795                             L3-CODE-UTIL-TYPE                    
P00795            PERFORM 7400-GET-WORK-TYPE THRU 7400-EXIT             
P00795            MOVE WS-ORDER-WK-TYPE TO T4-WORK-TYPE (T4-INDEX)      
P00795            MOVE 'T' TO T4-WORK-TYPE-SOURCE (T4-INDEX)            
P00795         END-IF                                                   
           END-IF                                                       
           SET T4-INDEX UP BY 1.                                        
                                                                        
       2310-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2350-CALL-CSR01121.                                              
                                                                        
MAINTN     MOVE 0 TO WS-GAS-MTRS-COUNT.                                 
MAINTN     MOVE 0 TO WS-ELEC-MTRS-COUNT.                                
                                                                        
MAINTN     MOVE WS-SERV-ORDER-NO-C TO  SERV-ORDER-NO-1121.              
MAINTN     MOVE WS-SERV-ORDER-NO-N TO  VT-SERV-ORDER-NO.                
MAINTN     MOVE WS-CURRENT-HISTORY-FL TO CURRENT-HISTORY-1121           
      *    EXEC SQL                                                     
      *       CALL CSR01121                                             
      *           (:SERV-ORDER-NO-1121,                                 
      *            :CURRENT-HISTORY-1121)                               
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1121
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1121
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1121 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2350'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01121'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE SERV-ORDER-NO-1121    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1121)                                                
      *       WITH PROCEDURE CSR01121                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1121 CURSOR FOR RESULT SET        
      *       :LOC1121                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_1121 INTO                          
                   :RETURN-CODE-1121,                                   
                   :CODE-UTIL-TYPE-1121,                                
                   :SO-INST-SEQ-NO-1121,                                
                   :RATE-PLAN-NO-1121 :WS-NULL3,                         
                   :RATE-DESC-1121 :WS-NULL4,                            
                   :METER-NO-1121,                                      
                   :METER-LOC-DESC-1121,                                
                   :CODE-MTR-STATUS-WS-1121,                            
                   :CODE-STATUS-REA-WS-1121,                            
                   :METER-SUPPLYING-1121,                               
                   :WORK-TYPE-CD-1121,                                  
                   :HOLD-RELEASE-1121,                                  
                   :RLSE-NO-1121,                                       
                   :RLSE-DATE-1121 :WS-NULL-RLSE-DT,                     
                   :CODE-METER-LOC-1121,                                
                   :PER-TEMP-IND-1121,                                  
                   :IC-NO-1121,                                         
                   :METER-IND-1121,                                     
                   :MTR-REF-NO-1121,                                    
                   :RLSE-IND-1121                                       
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE     
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-1121 NOT = 0                        
                         MOVE RETURN-CODE-1121 TO WS-ACTIVE-RETURN-CODE 
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '2350'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR01121'        TO TABLE-1              
                         MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1      
                         MOVE SERV-ORDER-NO-1121 TO HOSTVAR-ELEMENT-1   
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                     END-IF                                             
                     IF WS-NULL-RLSE-DT < 0                             
                         MOVE SPACES TO RLSE-DATE-1121                  
                     END-IF                                             
                     IF WS-NULL3 < 0                                    
                         MOVE SPACES TO RATE-PLAN-NO-1121               
                     END-IF                                             
                     IF WS-NULL4 < 0                                    
                         MOVE SPACES TO RATE-DESC-1121                  
                     END-IF                                             
                     PERFORM 2360-LOAD-CSR01121-TABLE THRU 2360-EXIT    
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '2350'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR01121'            TO TABLE-1              
                     MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1      
                     MOVE SERV-ORDER-NO-1121    TO HOSTVAR-ELEMENT-1    
                     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT      
                     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT      
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       2350-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2360-LOAD-CSR01121-TABLE.                                        
                                                                        
           MOVE CODE-UTIL-TYPE-1121 TO T2-CODE-UTIL-TYPE (T2-INDEX)     
                                       VT-CODE-UTIL-TYPE.               
P00795     IF T2-CODE-UTIL-TYPE (T2-INDEX) = 'G'                        
P00795            ADD 1 TO WS-GAS-MTRS-COUNT                            
P00795     ELSE IF T2-CODE-UTIL-TYPE (T2-INDEX) = 'E'                   
P00795                 ADD 1 TO WS-ELEC-MTRS-COUNT                      
P00795          END-IF                                                  
P00795     END-IF                                                       
           MOVE SO-INST-SEQ-NO-1121 TO T2-SO-INST-SEQ-NO (T2-INDEX).    
           MOVE RATE-PLAN-NO-1121 TO T2-RATE-PLAN-NO (T2-INDEX).        
           MOVE RATE-DESC-1121 TO T2-RATE-DESC (T2-INDEX).              
           MOVE METER-NO-1121 TO T2-METER-NO (T2-INDEX).                
           MOVE METER-LOC-DESC-1121 TO T2-METER-LOC-DESC (T2-INDEX).    
           MOVE CODE-MTR-STATUS-WS-1121 TO                              
                T2-CODE-MTR-STATUS-WS (T2-INDEX).                       
           MOVE CODE-STATUS-REA-WS-1121 TO                              
                T2-CODE-STATUS-REA-WS (T2-INDEX).                       
           MOVE METER-SUPPLYING-1121 TO T2-METER-SUPPLYING (T2-INDEX).  
           MOVE WORK-TYPE-CD-1121 TO T2-WORK-TYPE-CD (T2-INDEX)         
           MOVE WORK-TYPE-CD-1121 TO T2-OLD-WORK-TYPE-CD (T2-INDEX).    
           MOVE HOLD-RELEASE-1121 TO T2-HOLD-RELEASE (T2-INDEX).        
           MOVE RLSE-NO-1121 TO T2-RLSE-NO (T2-INDEX).                  
           MOVE RLSE-DATE-1121 TO T2-RLSE-DATE (T2-INDEX).              
           MOVE CODE-METER-LOC-1121 TO T2-CODE-METER-LOC (T2-INDEX).    
           MOVE PER-TEMP-IND-1121 TO T2-PER-TEMP-IND (T2-INDEX).        
           MOVE IC-NO-1121 TO T2-IC-NO (T2-INDEX)                       
                              WS-IC-NO-CHAR.                            
           MOVE WS-IC-NO-NUM TO VT-IC-NO.                               
           MOVE METER-IND-1121 TO T2-METER-IND (T2-INDEX).              
           MOVE MTR-REF-NO-1121 TO T2-MTR-REF-NO (T2-INDEX).            
           MOVE RLSE-IND-1121 TO T2-RLSE-IND (T2-INDEX).                
           PERFORM 7050-SELECT-UTILITY THRU 7050-EXIT.                  
           PERFORM 7060-SELECT-RR-UTILITY THRU 7060-EXIT.               
                                                                        
           SET T2-INDEX UP BY 1.                                        
                                                                        
       2360-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2400-FORMAT-SUBDIV-LIGHT.                                        
                                                                        
           MOVE '064' TO UT-RATE-PLAN-NO.                               
           MOVE 'U' TO UT-CODE-UTIL-TYPE.                               
           PERFORM 7200-SELECT-CUST-PLAN THRU 7200-EXIT.                
           PERFORM 2410-LIGHT-PRICE THRU 2410-EXIT.                     
           IF WS-PRICE-FOUND = 'Y'                                      
               MOVE '064' TO S-RATE-PLAN-4                              
               MOVE CP-NO-UNITS TO S-NO-UNITS                           
               MOVE CP-CODE-PLAN-STATUS TO S-CODE-PLAN-STATUS           
               MOVE CP-CODE-STAT-REASON TO S-CODE-STATUS-REASON         
               MOVE CP-RATE-ITEM-CODE TO S-RATE-ITEM-CODE               
               MOVE UP-PRICE-PER-SERV TO S-MONTHLY-AMOUNT               
               MOVE 'Y' TO S-SUBDIVISION-FL                             
               MOVE UT-IC-NO TO S-IC-NO-4                               
               MOVE CP-CODE-SERVICE-TYPE TO S-SERVICE-TYPE              
               MOVE SPACES TO S-DIST-NO                                 
                              S-POLE-NO                                 
                              S-RATE-PLAN-DESC-4                        
               IF WS-GTT04-DECLARED = 'N'                               
                   PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT            
               END-IF                                                   
               PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT
           END-IF.               
                                                                        
       2400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2410-LIGHT-PRICE.                                                
                                                                        
           IF WS-PRICE-FOUND = 'Y'                                      
               PERFORM 7210-SELECT-RATE-CREATOR THRU 7210-EXIT
           END-IF.         
           IF WS-PRICE-FOUND = 'Y'                                      
               PERFORM 7220-SELECT-UNMTR-PLAN THRU 7220-EXIT
           END-IF.           
                                                                        
       2410-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2500-UTILITY-FLAGS.                                              
                                                                        
           MOVE S-CODE-UTIL-TYPE-5 TO FF-CODE-UTIL-TYPE                 
                                      BK-CODE-UTIL-TYPE                 
                                      IP-CODE-UTIL-TYPE                 
                                      J1-CODE-UTIL-TYPE                 
                                      RT-CODE-UTIL-TYPE.                
           MOVE S-IC-NO-5 TO FF-IC-NO                                   
                             BK-IC-NO                                   
                             IP-IC-NO.                                  
           MOVE S-RATE-PLAN-5 TO J1-RATE-PLAN-NO                        
                                 RT-RATE-PLAN-NO.                       
           PERFORM 7300-TOU THRU 7300-EXIT.                             
           PERFORM 7310-FIXED-FACTORS THRU 7310-EXIT.                   
           PERFORM 7320-BILL-CONTRACT THRU 7320-EXIT.                   
           PERFORM 7330-INTERRUPT THRU 7330-EXIT.                       
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
       2600-PROCESS-NON-MAINTAIN.                                       
      *                                                                         
           PERFORM 2300-CALL-CSR02210 THRU 2300-EXIT.                   
P0795A     IF (LINK-PROCESS = 'AOO' AND                                 
P0795A         LINK-ORDER-TYPE-CD  = 'FM002' AND                        
P0795A         LINK-ACCOUNT-NO NOT = ZEROES)                            
P0795A            MOVE 'Y' TO WS-SET-ADDL-ORDER-FL                      
P0795A     END-IF                                                       
                                                                        
                                                                        
      * IF NO MN DATA IS RETURNED FROM CSR02210 AND A SET ORDER EXISTS,         
      * CALL CSR01121 TO GET METER AND UTILITY DATA                             
      * WORK TYPES DEFAULT TO RDO                                               
                                                                        
           IF WS-MN-DATA-FL = 'N' AND WS-CP-DATA-FL = 'N' AND           
P0795A        WS-2210-DATA-FL = 'Y' AND                                 
P0795A        (WS-UT-DATA-FL = 'Y' AND  WS-SET-ADDL-ORDER-FL NOT = 'Y') 
                  MOVE 'N' TO WS-2210-DATA-FL
           END-IF.                          
                                                                        
           IF WS-2210-DATA-FL = 'N'                                     
               SET T2-INDEX TO +1                                       
               IF WS-SET-ORDER-NO-E > 0                                 
                   MOVE WS-SET-ORDER-NO-E TO WS-SET-ORDER-NO            
MAINTN             MOVE WS-SET-ORDER-NO-CHAR   TO WS-SERV-ORDER-NO-C    
MAINTN             MOVE 'C' TO WS-CURRENT-HISTORY-FL                    
                   PERFORM 2350-CALL-CSR01121 THRU 2350-EXIT            
               END-IF                                                   
               IF WS-SET-ORDER-NO-G > 0                                 
                   MOVE WS-SET-ORDER-NO-G TO WS-SET-ORDER-NO            
MAINTN             MOVE WS-SET-ORDER-NO-CHAR   TO WS-SERV-ORDER-NO-C    
MAINTN             MOVE 'C' TO WS-CURRENT-HISTORY-FL                    
                   PERFORM 2350-CALL-CSR01121 THRU 2350-EXIT
               END-IF
           END-IF.           
                                                                        
      * PERFORMED ON DATA FROM CSR02210                                         
                                                                        
           IF WS-ACTIVE-ORDERS = 'Y'                                    
                PERFORM VARYING T4-INDEX FROM 1 BY 1 UNTIL              
SCA006              T4-INDEX > 100 OR 
                    T4-UT-CODE-UTIL-TYPE (T4-INDEX) = SPACES                    
                        IF T4-TABLE-ID (T4-INDEX) = 'MN'                
P00795                     IF (LINK-PROCESS = 'STOP' OR 'START') AND    
DT6878                          CSR-DATABASE                            
P00795                         PERFORM 4000-CALCULATE-WORK-TYPES THRU   
P00795                                 4000-EXIT                        
P00795                     ELSE                                         
P00795                         MOVE T4-UT-CODE-UTIL-TYPE (T4-INDEX) TO  
P00795                              L3-CODE-UTIL-TYPE                   
P00795                         PERFORM 7400-GET-WORK-TYPE THRU          
P00795                                 7400-EXIT                        
P00795                         MOVE WS-ORDER-WK-TYPE TO                 
P00795                                     T4-WORK-TYPE (T4-INDEX)      
P00795                         MOVE 'T' TO                              
P00795                                    T4-WORK-TYPE-SOURCE (T4-INDEX)
P00795                     END-IF                                       
                        END-IF                                          
                END-PERFORM
           END-IF.                                            
                                                                        
      * WILL HAVE DATA IN EITHER T4 OR T2, NOT BOTH UNLESS PENDING              
      * ACCOUNT WAS CREATED VIA SAVE-AS. IF SO, BYPASS T4 PROCESSING.           
      * T4 DATA COMES FROM CSR02210                                             
      * T2 DATA COMES FROM THE EXISTING SET ORDER                               
      *                                                                         
      * T4 - CSR02210 DATA                                                      
           PERFORM 4360-T4-DATA-FOR-RETURN THRU 4360-EXIT.              
      * T2 - 1121 DATA - GOT FOR MAINTAIN PROCESS AND CC ON PENDING SET         
           PERFORM 4300-T2-DATA-FOR-RETURN THRU 4300-EXIT.              
                                                                        
       2600-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2610-PROCESS-MAINTAIN.                                           
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-C.               
           MOVE LINK-CURRENT-HISTORY-FL  TO WS-CURRENT-HISTORY-FL.      
           IF LINK-SERV-ORDER-NO NOT= SPACES                            
A05317        SET T2-INDEX TO +1                                        
              PERFORM 2350-CALL-CSR01121 THRU 2350-EXIT                 
              PERFORM 4300-T2-DATA-FOR-RETURN THRU 4300-EXIT            
           END-IF.                                                      
       2610-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3000-TYPE-FROM-STATUS.                                           
                                                                        
           MOVE SPACES TO WS-WORK-TYPE-S.                               
           EVALUATE LINK-PROCESS                                        
               WHEN 'STOP'                                              
                   EVALUATE WS-INPUT-STATUS                             
                       WHEN 'K'                                         
                           MOVE 'FIN' TO WS-WORK-TYPE-S                 
                       WHEN 'A'                                         
                           IF WS-RATE-PLAN = '005'                      
                               MOVE 'RMM' TO WS-WORK-TYPE-S             
                           ELSE                                         
                               IF WS-REVENUE-CLASS = '021'              
                                   MOVE 'RTM' TO WS-WORK-TYPE-S         
                               ELSE                                     
                                   MOVE 'BLK' TO WS-WORK-TYPE-S         
                               END-IF                                   
                           END-IF                                       
                       WHEN 'B'                                         
                       WHEN 'I'                                         
                           MOVE 'BLK' TO WS-WORK-TYPE-S                 
                       WHEN 'J'                                         
                           IF WS-RATE-PLAN = '005'                      
                               MOVE 'RMM' TO WS-WORK-TYPE-S             
                           ELSE                                         
                               MOVE 'VRB' TO WS-WORK-TYPE-S             
                           END-IF                                       
                       WHEN OTHER                                       
                           MOVE '   ' TO WS-WORK-TYPE-S                 
                   END-EVALUATE                                         
               WHEN 'START'                                             
                   EVALUATE WS-INPUT-STATUS                             
                       WHEN 'K'                                         
                           IF WS-INPUT-REASON = 'O'                     
                               MOVE 'SOR' TO WS-WORK-TYPE-S             
                           ELSE                                         
                               MOVE 'SOL' TO WS-WORK-TYPE-S             
                           END-IF                                       
                       WHEN 'A'                                         
                       WHEN 'B'                                         
                       WHEN 'I'                                         
                           MOVE 'RDO' TO WS-WORK-TYPE-S                 
                       WHEN 'J'                                         
                           IF WS-INPUT-REASON = 'O'                     
                               MOVE 'REC' TO WS-WORK-TYPE-S             
                           ELSE                                         
                               MOVE 'UNB' TO WS-WORK-TYPE-S             
                           END-IF                                       
                       WHEN OTHER                                       
                           MOVE '   ' TO WS-WORK-TYPE-S                 
                   END-EVALUATE                                         
               WHEN OTHER                                               
                   MOVE '   ' TO WS-WORK-TYPE-S                         
           END-EVALUATE.                                                
                                                                        
       3000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4000-CALCULATE-WORK-TYPES.                                       
                                                                        
           INITIALIZE WS-ITERATION-STORAGE.                             
           MOVE T4-MN-CODE-METER-S (T4-INDEX) TO WS-1ST-STATUS.         
           SET T3-INDEX TO 1.                                           
           PERFORM VARYING T3-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T3-INDEX > 25 OR 
               T3-ASSIGNED-DATE (T3-INDEX) = SPACES                             
                   IF T3-ASSIGNED-DATE (T3-INDEX) <=                    
                      LINK-ASSIGNED-DATE AND                            
                     (T3-ORDER-STATE-CD (T3-INDEX) = 'A' OR             
                     (T3-ORDER-STATE-CD (T3-INDEX) = 'H' AND            
                      T3-ORDER-TYPE-CD (T3-INDEX) = 'FM003' AND         
                      WS-ACTIVE-CC-ORDER = 'Y')) AND                    
                      T3-ORDER-GROUP-CD (T3-INDEX) NOT = 'A' AND        
                      T3-ORDER-GROUP-CD (T3-INDEX) NOT = 'G'            
                          PERFORM 4100-TYPE-FROM-ORDER THRU 4100-EXIT   
                   END-IF                                               
           END-PERFORM.                                                 
                                                                        
       4000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4100-TYPE-FROM-ORDER.                                            
                                                                        
           MOVE 1 TO WS-SUB1.                                           
           PERFORM VARYING T5-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T5-INDEX > 50 OR 
               T5-SERV-ORDER-NO (T5-INDEX) = ZEROES                             
                   IF T5-SERV-ORDER-NO (T5-INDEX) =                     
                      T3-SERV-ORDER-NO (T3-INDEX) AND                   
                      T5-CODE-UTIL-TYPE (T5-INDEX) =                    
                      T4-UT-CODE-UTIL-TYPE (T4-INDEX) AND               
                      T5-IC-NO (T5-INDEX) = T4-UT-IC-NO (T4-INDEX) AND  
                      T5-MTR-REF-NO (T5-INDEX) =                        
                      T4-MN-MTR-REF-NO (T4-INDEX) AND                   
                      T5-WORK-TYPE-CD (T5-INDEX) > SPACES               
                          MOVE T5-WORK-TYPE-CD (T5-INDEX) TO            
                               WS-WORK-TYPE-O (WS-SUB1)                 
                          ADD 1 TO WS-SUB1                              
                   END-IF                                               
           END-PERFORM.                                                 
           MOVE WS-1ST-STATUS TO WS-WORKING-STATUS.                     
           MOVE 1 TO WS-SUB1.                                           
           PERFORM UNTIL WS-SUB1 > 25 OR                                
                         WS-WORK-TYPE-O (WS-SUB1) = SPACES OR           
                         WS-MATCH-FOUND = 'N'                           
               PERFORM 4200-PROCESS-TYPE-TABLE THRU 4200-EXIT           
               ADD 1 TO WS-SUB1                                         
           END-PERFORM.                                                 
           IF WS-MATCH-FOUND = 'N'                                      
               MOVE T4-MN-CODE-METER-S (T4-INDEX) TO WS-INPUT-STATUS    
               MOVE T4-MN-CD-STAT-REAS (T4-INDEX) TO WS-INPUT-REASON    
               MOVE 'S' TO T4-WORK-TYPE-SOURCE (T4-INDEX)               
           ELSE                                                         
               MOVE WS-WORKING-STATUS TO WS-INPUT-STATUS                
               MOVE SPACES TO WS-INPUT-REASON                           
               MOVE 'O' TO T4-WORK-TYPE-SOURCE (T4-INDEX)
           END-IF.              
           MOVE T4-UT-RATE-PLAN-NO (T4-INDEX) TO WS-RATE-PLAN.          
           MOVE T4-UT-CODE-REV-CLASS (T4-INDEX) TO WS-REVENUE-CLASS.    
           PERFORM 3000-TYPE-FROM-STATUS THRU 3000-EXIT.                
           MOVE WS-WORK-TYPE-S TO T4-WORK-TYPE (T4-INDEX).              
                                                                        
       4100-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4200-PROCESS-TYPE-TABLE.                                         
                                                                        
           MOVE ' ' TO WS-MATCH-FOUND.                                  
           SET WS-STATUS-INDEX TO +1.                                   
           SEARCH WS-STATUS-LINE                                        
               AT END                                                   
                    MOVE 'N' TO WS-MATCH-FOUND                          
      *        WHEN WS-PROCESS (WS-STATUS-INDEX) = LINK-PROCESS AND             
               WHEN WS-WORK-TYPE (WS-STATUS-INDEX) =                    
                    WS-WORK-TYPE-O (WS-SUB1)                            
                        MOVE WS-NEW-STATUS (WS-STATUS-INDEX) TO         
                             WS-WORKING-STATUS                          
                        MOVE 'Y' TO WS-MATCH-FOUND                      
           END-SEARCH.                                                  
                                                                        
       4200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4300-T2-DATA-FOR-RETURN.                                         
                                                                        
           PERFORM VARYING T2-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T2-INDEX > 50 OR 
               T2-CODE-UTIL-TYPE (T2-INDEX) = SPACES                            
                   MOVE T2-CODE-UTIL-TYPE (T2-INDEX) TO                 
                        S-CODE-UTIL-TYPE-5                              
                   MOVE T2-IC-NO (T2-INDEX) TO S-IC-NO-5                
                   MOVE T2-IC-NO (T2-INDEX) TO S-IC-NO-5                
                   MOVE T2-RATE-PLAN-NO (T2-INDEX) TO S-RATE-PLAN-5     
                   MOVE T2-CODE-REV-CLASS (T2-INDEX) TO                 
                        S-CODE-REV-CLASS-5                              
                   MOVE T2-READ-ROUTE (T2-INDEX) TO                     
                        S-READ-ROUTE-5                                  
                   MOVE T2-RATE-DESC (T2-INDEX) TO S-RATE-PLAN-DESC-5   
                   IF LINK-PROCESS = 'START'                            
                       PERFORM 2500-UTILITY-FLAGS THRU 2500-EXIT        
                   END-IF                                               
                   IF WS-GTT05-DECLARED = 'N'                           
                       PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT        
                   END-IF                                               
                   PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT            
                                                                        
                   MOVE T2-CODE-UTIL-TYPE (T2-INDEX) TO                 
                        S-CODE-UTIL-TYPE-2                              
                   MOVE T2-METER-NO (T2-INDEX) TO S-METER-NO-2          
                   MOVE T2-RATE-PLAN-NO (T2-INDEX) TO S-RATE-PLAN-2     
                   MOVE T2-METER-SUPPLYING (T2-INDEX) TO S-SUPPLIES     
                   MOVE T2-CODE-METER-LOC (T2-INDEX) TO S-METER-LOC     
                   MOVE T2-CODE-MTR-STATUS-WS (T2-INDEX) TO             
                        S-METER-STATUS                                  
                   MOVE T2-CODE-STATUS-REA-WS (T2-INDEX) TO             
                         S-METER-STATUS-REASON                          
MAINTN             IF LINK-PROCESS NOT = WS-MAINTAIN                    
                      MOVE 'RDO' TO S-WORK-TYPE-CD-2                    
MAINTN             ELSE                                                 
MAINTN                MOVE T2-WORK-TYPE-CD (T2-INDEX) TO                
MAINTN                                           S-WORK-TYPE-CD-2       
MAINTN             END-IF                                               
                   MOVE SPACES TO S-METER-READ-INST                     
                   MOVE T2-METER-IND (T2-INDEX) TO S-METER-IND          
                   MOVE T2-IC-NO (T2-INDEX) TO S-IC-NO-2                
                   MOVE T2-MTR-REF-NO (T2-INDEX) TO S-MTR-REF-NO-2      
                   MOVE T2-SO-INST-SEQ-NO (T2-INDEX) TO S-SO-SEQ-NO-2   
                   MOVE T2-CODE-REV-CLASS (T2-INDEX) TO                 
                        S-CODE-REV-CLASS-2                              
MAINTN             MOVE WS-GAS-MTRS-COUNT TO S-GAS-MTRS-COUNT-2         
MAINTN             MOVE WS-ELEC-MTRS-COUNT TO S-ELEC-MTRS-COUNT-2       
                   MOVE T2-HOLD-RELEASE (T2-INDEX) TO S-RLSE-IND-2      
                   MOVE T2-RLSE-NO (T2-INDEX) TO S-RLSE-NO-2            
                   IF WS-GTT02-DECLARED = 'N'                           
                       PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT        
                   END-IF                                               
                   PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT            
           END-PERFORM.                                                 
                                                                        
       4300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4320-T3-DATA-FOR-RETURN.                                         
           PERFORM VARYING T3-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T3-INDEX > 25 OR 
               T3-ASSIGNED-DATE (T3-INDEX) = SPACES                             
                    MOVE T3-ASSIGNED-DATE (T3-INDEX) TO S-ASSIGNED-DATE 
                    MOVE T3-SERV-ORDER-NO (T3-INDEX) TO                 
                         S-SERV-ORDER-NO-1                              
                    MOVE T3-ORDER-TYPE-CD (T3-INDEX) TO S-ORDER-TYPE-CD 
                    MOVE T3-ORDER-STATE-CD (T3-INDEX) TO                
                         S-ORDER-STATE-CD                               
                    MOVE T3-CUSTOMER-NAME (T3-INDEX) TO S-CUSTOMER-NAME 
                    MOVE T3-REMARKS (T3-INDEX) TO S-REMARKS             
                    MOVE T3-WORK-AREA (T3-INDEX) TO S-WORK-AREA         
                    MOVE T3-PHONE (T3-INDEX) TO S-PHONE                 
                    MOVE T3-REMARK-TYPE (T3-INDEX) TO S-REMARK-TYPE     
                    MOVE T3-SERV-ORDER-STATUS (T3-INDEX) TO             
                         S-SERV-ORDER-STATUS                            
                    IF WS-GTT01-DECLARED = 'N'                          
                        PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT       
                    END-IF                                              
                    PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT           
           END-PERFORM.                                                 
       4320-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4340-T5-DATA-FOR-RETURN.                                         
     *                                                                  
           PERFORM VARYING T5-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T5-INDEX > 50 OR 
               T5-SERV-ORDER-NO (T5-INDEX) = ZEROES                             
                   MOVE T5-SERV-ORDER-NO (T5-INDEX) TO                  
                        S-SERV-ORDER-NO-3                               
                   MOVE T5-CODE-UTIL-TYPE (T5-INDEX) TO                 
                        S-CODE-UTIL-TYPE-3                              
                   MOVE T5-WORK-TYPE-CD (T5-INDEX) TO                   
                        S-WORK-TYPE-CD-3                                
                   MOVE T5-IC-NO (T5-INDEX) TO S-IC-NO-3                
                   MOVE T5-METER-NO (T5-INDEX) TO S-METER-NO-3          
                   MOVE T5-MTR-REF-NO (T5-INDEX) TO S-MTR-REF-NO-3      
                   IF WS-GTT03-DECLARED = 'N'                           
                       PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT        
                   END-IF                                               
                   PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT            
           END-PERFORM.                                                 
       4340-EXIT.                                                       
            EXIT.                                                       
                                                                        
       4360-T4-DATA-FOR-RETURN.                                         
     *                                                                  
           PERFORM VARYING T4-INDEX FROM 1 BY 1 UNTIL                   
SCA006         T4-INDEX > 100 OR 
SCA006         WS-2210-DATA-FL = 'N' OR 
               T4-TABLE-ID (T4-INDEX) = SPACES                                  
                   IF T4-SUBDIV-LIGHT (T4-INDEX) > 0                    
                       MOVE 'Y' TO WS-SUBDIV-LIGHT                      
                   END-IF                                               
                   IF T4-TABLE-ID (T4-INDEX) = 'UT'                     
                       MOVE T4-UT-CODE-UTIL-TYPE (T4-INDEX) TO          
                            S-CODE-UTIL-TYPE-5                          
                       MOVE T4-UT-IC-NO (T4-INDEX) TO S-IC-NO-5         
                       MOVE T4-UT-RATE-PLAN-NO (T4-INDEX) TO            
                            S-RATE-PLAN-5                               
                       MOVE T4-UT-CODE-REV-CLASS (T4-INDEX) TO          
                            S-CODE-REV-CLASS-5                          
                       MOVE T4-UT-RATE-DESC (T4-INDEX) TO               
                            S-RATE-PLAN-DESC-5                          
                       MOVE T4-UT-READ-ROUTE (T4-INDEX) TO              
                            S-READ-ROUTE-5                              
      *                IF LINK-PROCESS = 'START'                                
                           PERFORM 2500-UTILITY-FLAGS THRU 2500-EXIT    
      *                END-IF                                                   
                       IF WS-GTT05-DECLARED = 'N'                       
                           PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT    
                       END-IF                                           
                       PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT        
                   END-IF                                               
                   IF WS-MN-DATA-FL ='N' AND WS-UT-DATA-FL = 'Y' AND    
                      WS-SET-ADDL-ORDER-FL = 'Y' AND                    
P0795B                (T4-TABLE-ID (T4-INDEX) = 'UT' AND                
P0795B                 T4-UT-CODE-UTIL-TYPE (T4-INDEX) NOT = 'U')       
                       MOVE T4-UT-CODE-UTIL-TYPE (T4-INDEX) TO          
                            S-CODE-UTIL-TYPE-2                          
                       MOVE T4-MN-METER-NO (T4-INDEX) TO S-METER-NO-2   
                       MOVE T4-UT-RATE-PLAN-NO (T4-INDEX) TO            
                            S-RATE-PLAN-2                               
                       MOVE T4-MN-METER-SUPPLY (T4-INDEX) TO S-SUPPLIES 
                       MOVE T4-MN-CODE-METER-LOC (T4-INDEX) TO          
                            S-METER-LOC                                 
                       MOVE T4-MN-CODE-METER-S (T4-INDEX) TO            
                            S-METER-STATUS                              
                       MOVE T4-MN-CD-STAT-REAS (T4-INDEX) TO            
                            S-METER-STATUS-REASON                       
                       MOVE T4-WORK-TYPE (T4-INDEX) TO S-WORK-TYPE-CD-2 
                       MOVE T4-MN-CODE-MTR-RD (T4-INDEX) TO             
                            S-METER-READ-INST                           
                       MOVE T4-MN-METER-IND (T4-INDEX) TO S-METER-IND   
                       MOVE T4-UT-IC-NO (T4-INDEX) TO S-IC-NO-2         
                       MOVE T4-MN-MTR-REF-NO (T4-INDEX) TO              
                            S-MTR-REF-NO-2                              
                       MOVE T4-UT-CODE-REV-CLASS (T4-INDEX) TO          
                            S-CODE-REV-CLASS-2                          
P00795                 MOVE WS-GAS-MTRS-COUNT TO S-GAS-MTRS-COUNT-2     
P00795                 MOVE WS-ELEC-MTRS-COUNT TO S-ELEC-MTRS-COUNT-2   
                       IF WS-GTT02-DECLARED = 'N'                       
                           PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT    
                       END-IF                                           
                       PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT        
                   END-IF                                               
                   IF T4-TABLE-ID (T4-INDEX) = 'MN'                     
                       MOVE T4-UT-CODE-UTIL-TYPE (T4-INDEX) TO          
                            S-CODE-UTIL-TYPE-2                          
                       MOVE T4-MN-METER-NO (T4-INDEX) TO S-METER-NO-2   
                       MOVE T4-UT-RATE-PLAN-NO (T4-INDEX) TO            
                            S-RATE-PLAN-2                               
                       MOVE T4-MN-METER-SUPPLY (T4-INDEX) TO S-SUPPLIES 
                       MOVE T4-MN-CODE-METER-LOC (T4-INDEX) TO          
                            S-METER-LOC                                 
                       MOVE T4-MN-CODE-METER-S (T4-INDEX) TO            
                            S-METER-STATUS                              
                       MOVE T4-MN-CD-STAT-REAS (T4-INDEX) TO            
                            S-METER-STATUS-REASON                       
                       MOVE T4-WORK-TYPE (T4-INDEX) TO S-WORK-TYPE-CD-2 
                       MOVE T4-MN-CODE-MTR-RD (T4-INDEX) TO             
                            S-METER-READ-INST                           
                       MOVE T4-MN-METER-IND (T4-INDEX) TO S-METER-IND   
                       MOVE T4-UT-IC-NO (T4-INDEX) TO S-IC-NO-2         
                       MOVE T4-MN-MTR-REF-NO (T4-INDEX) TO              
                            S-MTR-REF-NO-2                              
                       MOVE T4-UT-CODE-REV-CLASS (T4-INDEX) TO          
                            S-CODE-REV-CLASS-2                          
P00795                 MOVE WS-GAS-MTRS-COUNT TO S-GAS-MTRS-COUNT-2     
P00795                 MOVE WS-ELEC-MTRS-COUNT TO S-ELEC-MTRS-COUNT-2   
                       IF WS-GTT02-DECLARED = 'N'                       
                           PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT    
                       END-IF                                           
                       PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT        
                   END-IF                                               
                   IF T4-TABLE-ID (T4-INDEX) = 'CP'                     
                       MOVE T4-UT-RATE-PLAN-NO (T4-INDEX) TO            
                            S-RATE-PLAN-4                               
                            UT-RATE-PLAN-NO                             
                       MOVE T4-UT-CODE-UTIL-TYPE (T4-INDEX) TO          
                            UT-CODE-UTIL-TYPE                           
                       MOVE T4-UT-IC-NO (T4-INDEX) TO S-IC-NO-4         
                       IF T4-UT-CODE-UTIL-TYPE (T4-INDEX) = 'E' OR 'G'  
                           MOVE 'X' TO S-SUBDIVISION-FL                 
                       ELSE                                             
                           MOVE 'N' TO S-SUBDIVISION-FL                 
                       END-IF                                           
                       MOVE T4-CP-RT-ITEM-CD (T4-INDEX) TO              
                            S-RATE-ITEM-CODE                            
                            CP-RATE-ITEM-CODE                           
                       MOVE T4-CP-NO-UNITS (T4-INDEX) TO S-NO-UNITS     
                       MOVE T4-CP-CODE-PLAN (T4-INDEX) TO               
                            S-CODE-PLAN-STATUS                          
                       MOVE T4-CP-CD-STAT-REAS (T4-INDEX) TO            
                            S-CODE-STATUS-REASON                        
                       MOVE T4-UT-RATE-DESC (T4-INDEX) TO               
                            S-RATE-PLAN-DESC-4                          
                       MOVE T4-CP-CD-SVC-TYPE (T4-INDEX) TO             
                            S-SERVICE-TYPE                              
                       MOVE T4-CP-DIST-NO (T4-INDEX) TO S-DIST-NO       
                       MOVE T4-CP-POLE-NO (T4-INDEX) TO S-POLE-NO       
                       PERFORM 2410-LIGHT-PRICE THRU 2410-EXIT          
                       IF WS-PRICE-FOUND = 'Y'                          
                           COMPUTE S-MONTHLY-AMOUNT =                   
                                   UP-PRICE-PER-SERV *                  
                                   S-NO-UNITS                           
                       ELSE                                             
                           MOVE 0.00 TO S-MONTHLY-AMOUNT                
                       END-IF                                           
                       IF WS-GTT04-DECLARED = 'N'                       
                           PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT    
                       END-IF                                           
                       PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT        
                   END-IF                                               
           END-PERFORM.                                                 
       4360-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-REMARKS.                                             
                                                                        
           MOVE SPACES TO EF-REMARK-TX.                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REMARK_TX                                        
                INTO   :EF-REMARK-TX                                    
                FROM   CSS_SO_REMARKS WITH(READUNCOMMITTED)                     
               WHERE   SERV_ORDER_NO     = :VO-SERV-ORDER-NO            
                 AND   REMARK_TYPE_CD    = 'G'                          
               ORDER BY REMARK_DATETIME DESC                            
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   REMARK_TX                                                
MFA-TR*         INTO   :EF-REMARK-TX                                            
MFA-TR*         FROM   CSS_SO_REMARKS                                           
MFA-TR*        WHERE   SERV_ORDER_NO     = :VO-SERV-ORDER-NO                    
MFA-TR*          AND   REMARK_TYPE_CD    = 'G'                                  
MFA-TR*        ORDER BY REMARK_DATETIME DESC                                    
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE EF-REMARK-TX-TEXT TO T3-REMARKS (T3-INDEX)      
                   MOVE 'G' TO T3-REMARK-TYPE (T3-INDEX)                
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE SPACES TO S-REMARKS                             
                                  S-REMARK-TYPE                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_REMARKS'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-OPEN-SO-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN SO-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_ACCOUNT'        TO TABLE-2                 
                   MOVE 'CSS_CUSTOMER'      TO TABLE-3                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CLOSE-SO-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE SO-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'CSS_ACCOUNT'        TO TABLE-2                 
                   MOVE 'CSS_CUSTOMER'      TO TABLE-3                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7030-OPEN-INST-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN SO-INST-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7030'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-CLOSE-INST-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE SO-INST-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7040'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   MOVE VO-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-SELECT-UTILITY.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_REVENUE_CLASS                               
                INTO   :VT-CODE-REVENUE-CLASS                           
                FROM   CSS_SO_UTILITY WITH(READUNCOMMITTED)                     
               WHERE   SERV_ORDER_NO     = :VT-SERV-ORDER-NO            
                 AND   CODE_UTIL_TYPE    = :VT-CODE-UTIL-TYPE           
                 AND   IC_NO             = :VT-IC-NO                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   CODE_REVENUE_CLASS                                       
MFA-TR*         INTO   :VT-CODE-REVENUE-CLASS                                   
MFA-TR*         FROM   CSS_SO_UTILITY                                           
MFA-TR*        WHERE   SERV_ORDER_NO     = :VT-SERV-ORDER-NO                    
MFA-TR*          AND   CODE_UTIL_TYPE    = :VT-CODE-UTIL-TYPE                   
MFA-TR*          AND   IC_NO             = :VT-IC-NO                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VT-CODE-REVENUE-CLASS TO                        
                        T2-CODE-REV-CLASS (T2-INDEX)                    
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   PERFORM 7055-SELECT-UTL-CHG THRU 7055-EXIT           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7050'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UTILITY'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE VT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7055-SELECT-UTL-CHG.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CODE_REVENUE_CLASS                               
                INTO   :VE-CODE-REVENUE-CLASS                           
                FROM   CSS_SO_UTL_CHG WITH(READUNCOMMITTED)                     
               WHERE   SERV_ORDER_NO     = :VT-SERV-ORDER-NO            
                 AND   CODE_UTIL_TYPE    = :VT-CODE-UTIL-TYPE           
                 AND   IC_NO             = :VT-IC-NO                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   CODE_REVENUE_CLASS                                       
MFA-TR*         INTO   :VE-CODE-REVENUE-CLASS                                   
MFA-TR*         FROM   CSS_SO_UTL_CHG                                           
MFA-TR*        WHERE   SERV_ORDER_NO     = :VT-SERV-ORDER-NO                    
MFA-TR*          AND   CODE_UTIL_TYPE    = :VT-CODE-UTIL-TYPE                   
MFA-TR*          AND   IC_NO             = :VT-IC-NO                            
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7055                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VE-CODE-REVENUE-CLASS TO                        
                        T2-CODE-REV-CLASS (T2-INDEX)                    
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE SPACES TO T2-CODE-REV-CLASS (T2-INDEX)          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7055'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UTL_CHG'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE VT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7055-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-SELECT-RR-UTILITY.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) VT.READ_ROUTE                                    
                INTO   :VT-READ-ROUTE                                   
                FROM   CSS_SO_DATA VO WITH(READUNCOMMITTED)                     
                       ,CSS_SO_UTILITY VT WITH(READUNCOMMITTED)                 
               WHERE   VO.ACCOUNT_NO =  :AT-ACCOUNT-NO                  
                 AND   VO.SERV_ORDER_NO  = VT.SERV_ORDER_NO             
                 AND   VT.READ_ROUTE        > 0                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   VT.READ_ROUTE                                            
MFA-TR*         INTO   :VT-READ-ROUTE                                           
MFA-TR*         FROM   CSS_SO_DATA VO                                           
MFA-TR*                ,CSS_SO_UTILITY VT                                       
MFA-TR*        WHERE   VO.ACCOUNT_NO =  :AT-ACCOUNT-NO                          
MFA-TR*          AND   VO.SERV_ORDER_NO  = VT.SERV_ORDER_NO                     
MFA-TR*          AND   VT.READ_ROUTE        > 0                                 
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7060                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VT-READ-ROUTE         TO                        
                        T2-READ-ROUTE (T2-INDEX)                        
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   PERFORM 7065-SELECT-RR-UTL-CHG THRU 7065-EXIT        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7060'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UTILITY'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7065-SELECT-RR-UTL-CHG.                                          
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) VE.READ_ROUTE                                     
                INTO  :VE-READ-ROUTE                                    
                FROM   CSS_SO_DATA VO WITH(READUNCOMMITTED)                     
                       ,CSS_SO_UTL_CHG VE WITH(READUNCOMMITTED)                 
               WHERE   VO.ACCOUNT_NO     = :AT-ACCOUNT-NO               
                 AND   VO.SERV_ORDER_NO  = VE.SERV_ORDER_NO             
                 AND   VE.READ_ROUTE > 0                                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  VE.READ_ROUTE                                             
MFA-TR*         INTO  :VE-READ-ROUTE                                            
MFA-TR*         FROM   CSS_SO_DATA VO                                           
MFA-TR*                ,CSS_SO_UTL_CHG VE                                       
MFA-TR*        WHERE   VO.ACCOUNT_NO     = :AT-ACCOUNT-NO                       
MFA-TR*          AND   VO.SERV_ORDER_NO  = VE.SERV_ORDER_NO                     
MFA-TR*          AND   VE.READ_ROUTE > 0                                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7065                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VE-READ-ROUTE         TO                        
                        T2-READ-ROUTE (T2-INDEX)                        
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   MOVE 0 TO T2-READ-ROUTE (T2-INDEX)                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7065'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_UTL_CHG'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VO-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7065-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT   COMPANY_NO                                       
                INTO   :AT-COMPANY-NO                                   
                FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                        
               WHERE   ACCOUNT_NO = :AT-ACCOUNT-NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   COMPANY_NO                                               
MFA-TR*         INTO   :AT-COMPANY-NO                                           
MFA-TR*         FROM   CSS_ACCOUNT                                              
MFA-TR*        WHERE   ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SELECT-CUST-PLAN.                                           
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RATE_ITEM_CODE,
              CODE_PLAN_STATUS,
              CODE_STAT_REASON,
              NO_UNITS,
              UT.IC_NO,
              CP.CODE_SERVICE_TYPE                               
                INTO :CP-RATE-ITEM-CODE,                                
                     :CP-CODE-PLAN-STATUS,                              
                     :CP-CODE-STAT-REASON,                              
                     :CP-NO-UNITS,                                      
                     :UT-IC-NO,                                         
                     :CP-CODE-SERVICE-TYPE                              
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                 
                     CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                     
               WHERE UT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                 AND UT.ACCOUNT_NO = CP.ACCOUNT_NO                      
                 AND UT.CODE_UTIL_TYPE = CP.CODE_UTIL_TYPE              
                 AND UT.IC_NO = CP.IC_NO                                
                 AND UT.CODE_UTIL_TYPE = 'U'                            
                 AND UT.RATE_PLAN_NO = :UT-RATE-PLAN-NO                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_ITEM_CODE,                                            
MFA-TR*              CODE_PLAN_STATUS,                                          
MFA-TR*              CODE_STAT_REASON,                                          
MFA-TR*              NO_UNITS,                                                  
MFA-TR*              UT.IC_NO,                                                  
MFA-TR*              CP.CODE_SERVICE_TYPE                                       
MFA-TR*         INTO :CP-RATE-ITEM-CODE,                                        
MFA-TR*              :CP-CODE-PLAN-STATUS,                                      
MFA-TR*              :CP-CODE-STAT-REASON,                                      
MFA-TR*              :CP-NO-UNITS,                                              
MFA-TR*              :UT-IC-NO,                                                 
MFA-TR*              :CP-CODE-SERVICE-TYPE                                      
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT,                                       
MFA-TR*              CSS_CUST_PLAN CP                                           
MFA-TR*        WHERE UT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*          AND UT.ACCOUNT_NO = CP.ACCOUNT_NO                              
MFA-TR*          AND UT.CODE_UTIL_TYPE = CP.CODE_UTIL_TYPE                      
MFA-TR*          AND UT.IC_NO = CP.IC_NO                                        
MFA-TR*          AND UT.CODE_UTIL_TYPE = 'U'                                    
MFA-TR*          AND UT.RATE_PLAN_NO = :UT-RATE-PLAN-NO                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-PRICE-FOUND                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7200'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                  
                   MOVE 'CSS_CUST_PLAN'     TO TABLE-2                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-SELECT-RATE-CREATOR.                                        
                                                                        
           EXEC SQL                                                     
               SELECT MAX(VERSION_NO_CNTRL)                             
                 INTO :RT-VERSION-NO-CNTRL :WS-NULL2                    
                 FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)                    
                WHERE CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND RATE_PLAN_NO = :UT-RATE-PLAN-NO                   
                  AND CODE_STATUS IN ('A','I')                          
                  AND FROM_EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(VERSION_NO_CNTRL)                                     
MFA-TR*          INTO :RT-VERSION-NO-CNTRL :WS-NULL2                            
MFA-TR*          FROM CSS_RATE_CREATOR                                          
MFA-TR*         WHERE CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND RATE_PLAN_NO = :UT-RATE-PLAN-NO                           
MFA-TR*           AND CODE_STATUS IN ('A','I')                                  
MFA-TR*           AND FROM_EFFECTIVE_DT <= :WS-CURRENT-DATE                     
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL2 < 0                                      
                       MOVE 'N' TO WS-PRICE-FOUND                       
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-PRICE-FOUND                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7210'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_RATE_CREATOR'  TO TABLE-1                  
                   MOVE 'RATE_PLAN_NO'      TO TABLE-ELEMENT-1          
                   MOVE UT-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-SELECT-UNMTR-PLAN.                                          
                                                                        
           EXEC SQL                                                     
               SELECT PRICE_PER_SERV                                    
                 INTO :UP-PRICE-PER-SERV                                
                 FROM CSS_UNMTR_PLAN WITH(READUNCOMMITTED)                      
                WHERE CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE               
                  AND RATE_PLAN_NO = :UT-RATE-PLAN-NO                   
                  AND VERSION_NO_CNTRL = :RT-VERSION-NO-CNTRL           
                  AND RATE_ITEM_CODE = :CP-RATE-ITEM-CODE               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRICE_PER_SERV                                            
MFA-TR*          INTO :UP-PRICE-PER-SERV                                        
MFA-TR*          FROM CSS_UNMTR_PLAN                                            
MFA-TR*         WHERE CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                       
MFA-TR*           AND RATE_PLAN_NO = :UT-RATE-PLAN-NO                           
MFA-TR*           AND VERSION_NO_CNTRL = :RT-VERSION-NO-CNTRL                   
MFA-TR*           AND RATE_ITEM_CODE = :CP-RATE-ITEM-CODE                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-PRICE-FOUND                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7220'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UNMTR_PLAN'    TO TABLE-1                  
                   MOVE 'RATE_PLAN_NO'      TO TABLE-ELEMENT-1          
                   MOVE UT-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-TOU.                                                        
                                                                        
           EXEC SQL                                                     
              SELECT REG_TYPE_CD,                                       
                     DEM_REG_TYPE_CD                                    
                INTO :J1-REG-TYPE-CD,                                   
                     :J1-DEM-REG-TYPE-CD                                
                FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE  = :J1-CODE-UTIL-TYPE               
                 AND RATE_PLAN_NO    = :J1-RATE-PLAN-NO                 
                 AND CMPNT_ID_CD     = '10'                             
                 AND VERSION_NO_CNTRL   =                               
                     (SELECT MAX(VERSION_NO_CNTRL)                      
                        FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)             
                       WHERE CODE_UTIL_TYPE = :RT-CODE-UTIL-TYPE        
                         AND RATE_PLAN_NO   = :RT-RATE-PLAN-NO          
                         AND CODE_STATUS    = 'A')                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REG_TYPE_CD,                                               
MFA-TR*              DEM_REG_TYPE_CD                                            
MFA-TR*         INTO :J1-REG-TYPE-CD,                                           
MFA-TR*              :J1-DEM-REG-TYPE-CD                                        
MFA-TR*         FROM CSS_RATE_COMP_DEF                                          
MFA-TR*        WHERE CODE_UTIL_TYPE  = :J1-CODE-UTIL-TYPE                       
MFA-TR*          AND RATE_PLAN_NO    = :J1-RATE-PLAN-NO                         
MFA-TR*          AND CMPNT_ID_CD     = '10'                                     
MFA-TR*          AND VERSION_NO_CNTRL   =                                       
MFA-TR*              (SELECT MAX(VERSION_NO_CNTRL)                              
MFA-TR*                 FROM CSS_RATE_CREATOR                                   
MFA-TR*                WHERE CODE_UTIL_TYPE = :RT-CODE-UTIL-TYPE                
MFA-TR*                  AND RATE_PLAN_NO   = :RT-RATE-PLAN-NO                  
MFA-TR*                  AND CODE_STATUS    = 'A')                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'N' TO S-TOU-FL                                 
                   IF J1-REG-TYPE-CD = '2' OR '3' OR '4'                
                       MOVE 'Y' TO S-TOU-FL                             
                   END-IF                                               
                   IF J1-DEM-REG-TYPE-CD = '2' OR '3' OR '4'            
                       MOVE 'Y' TO S-TOU-FL                             
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO S-TOU-FL                                 
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7300'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_RATE_COMP_DEF' TO TABLE-1                  
                   MOVE 'CSS_RATE_CREATOR'  TO TABLE-2                  
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-1          
                   MOVE J1-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-1        
                   MOVE 'RATE_PLAN_NO'      TO TABLE-ELEMENT-2          
                   MOVE J1-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-FIXED-FACTORS.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :FF-ACCOUNT-NO                                    
                 FROM CSS_FIXED_FCTR WITH(READUNCOMMITTED)                      
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE               
                  AND IC_NO = :FF-IC-NO                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :FF-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_FIXED_FCTR                                            
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :FF-IC-NO                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7310                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-FIXED-FACTOR-FL                        
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO S-FIXED-FACTOR-FL                        
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7310'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_FIXED_FCTR'    TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE FF-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-BILL-CONTRACT.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :BK-ACCOUNT-NO                                    
                 FROM CSS_BILL_CONTRACT WITH(READUNCOMMITTED)                   
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :BK-CODE-UTIL-TYPE               
                  AND IC_NO = :BK-IC-NO                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :BK-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_BILL_CONTRACT                                         
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :BK-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :BK-IC-NO                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7320                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-BILL-CONTRACT-FL                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO S-BILL-CONTRACT-FL                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7320'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BILL_CONTRACT' TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE BK-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7330-INTERRUPT.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) ACCOUNT_NO                                        
                 INTO :IP-ACCOUNT-NO                                    
                 FROM CSS_INTERRUPT_ACCT WITH(READUNCOMMITTED)                  
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
                  AND CODE_UTIL_TYPE = :IP-CODE-UTIL-TYPE               
                  AND IC_NO = :IP-IC-NO                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*          INTO :IP-ACCOUNT-NO                                            
MFA-TR*          FROM CSS_INTERRUPT_ACCT                                        
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*           AND CODE_UTIL_TYPE = :IP-CODE-UTIL-TYPE                       
MFA-TR*           AND IC_NO = :IP-IC-NO                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7330                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-INTERRUPT-FL                           
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO S-INTERRUPT-FL                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7330'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_INTERRUPT_ACCT' TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2          
                   MOVE IP-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795 7400-GET-WORK-TYPE.                                              
P00795                                                                  
P00795     MOVE AT-COMPANY-NO TO L3-COMPANY-NO.                         
P00795     EXEC SQL                                                     
P00795         SELECT COUNT(*)                                          
P00795           INTO :WS-WORK-TYPE-COUNT                               
P00795           FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                   
P00795          WHERE COMPANY_NO = :L3-COMPANY-NO                       
P00795            AND ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                 
P00795            AND STATUS_CHANGE_DT IS NULL                          
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-WORK-TYPE-COUNT                                       
MFA-TR*          FROM CSS_ORDER_WK_TYPE                                         
MFA-TR*         WHERE COMPANY_NO = :L3-COMPANY-NO                               
MFA-TR*           AND ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                         
MFA-TR*           AND STATUS_CHANGE_DT IS NULL                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00795                                                                  
P00795     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00795         WHEN SUCCESSFUL-CALL                                     
P00795             IF WS-WORK-TYPE-COUNT = 1                            
P00795                PERFORM 7410-SELECT-WORK-TYPE THRU 7410-EXIT      
P00795             ELSE                                                 
P00795                MOVE SPACES TO WS-ORDER-WK-TYPE                   
P00795             END-IF                                               
P00795         WHEN NOT-FOUND                                           
P00795             MOVE SPACES TO WS-ORDER-WK-TYPE                      
P00795             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00795         WHEN OTHER                                               
P00795             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
P00795             MOVE SQLCODE             TO ABEND-SQLCODE            
P00795             MOVE SQLSTATE            TO ABEND-SQLSTATE           
P00795             MOVE '7400'              TO ACTIVE-PARAGRAPH         
P00795             MOVE 'SELECT'            TO ABEND-FUNCTION           
P00795             MOVE 'CSS_ORDER_WK_TYPE' TO TABLE-1                  
P00795             MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
P00795             MOVE L3-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
P00795             MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
P00795             MOVE L3-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
P00795             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00795     END-EVALUATE.                                                
P00795                                                                  
P00795 7400-EXIT.                                                       
P00795     EXIT.                                                        
P00795                                                                  
P00795 7410-SELECT-WORK-TYPE.                                           
P00795                                                                  
P00795     EXEC SQL                                                     
P00795         SELECT WORK_TYPE_CD                                      
P00795           INTO :L3-WORK-TYPE-CD                                  
P00795           FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                   
P00795          WHERE COMPANY_NO = :L3-COMPANY-NO                       
P00795            AND ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                 
P00795            AND STATUS_CHANGE_DT IS NULL                          
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT WORK_TYPE_CD                                              
MFA-TR*          INTO :L3-WORK-TYPE-CD                                          
MFA-TR*          FROM CSS_ORDER_WK_TYPE                                         
MFA-TR*         WHERE COMPANY_NO = :L3-COMPANY-NO                               
MFA-TR*           AND ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                         
MFA-TR*           AND STATUS_CHANGE_DT IS NULL                                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7410                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00795                                                                  
P00795     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00795         WHEN SUCCESSFUL-CALL                                     
P00795                MOVE L3-WORK-TYPE-CD TO WS-ORDER-WK-TYPE          
P00795         WHEN NOT-FOUND                                           
P00795             MOVE SPACES TO WS-ORDER-WK-TYPE                      
P00795             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00795         WHEN OTHER                                               
P00795             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
P00795             MOVE SQLCODE             TO ABEND-SQLCODE            
P00795             MOVE SQLSTATE            TO ABEND-SQLSTATE           
P00795             MOVE '7410'              TO ACTIVE-PARAGRAPH         
P00795             MOVE 'SELECT'            TO ABEND-FUNCTION           
P00795             MOVE 'CSS_ORDER_WK_TYPE' TO TABLE-1                  
P00795             MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
P00795             MOVE  L3-COMPANY-NO      TO HOSTVAR-ELEMENT-1        
P00795             MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
P00795             MOVE L3-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
P00795             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00795     END-EVALUATE.                                                
P00795                                                                  
P00795 7410-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
DT6878*****************************************************************         
DT6878* 7500-GET-DATABASE.                                            *         
DT6878*     SELECTS   DATABASE     (SEB OR CSR) FROM CSS_DELINQUENCY *          
DT6878*****************************************************************         
DT6878 7500-GET-DATABASE.                                               
DT6878                                                                  
DT6878     MOVE 'DATABASE'                       TO   C8-DELINQ-CD.     
DT6878     MOVE AT-COMPANY-NO                    TO   C8-COMPANY-NO.    
DT6878     EXEC SQL                                                     
DT6878        SELECT DELINQ_VALUE                                       
DT6878          INTO :C8-DELINQ-VALUE                                   
DT6878          FROM CSS_DELINQUENCY                                    
DT6878         WHERE DELINQ_CD = :C8-DELINQ-CD                          
DT6878           AND COMPANY_NO = :C8-COMPANY-NO                        
DT6878     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DT6878                                                                  
DT6878     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
DT6878                                                                  
DT6878     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
DT6878        MOVE C8-DELINQ-VALUE TO WS-DATABASE                       
DT6878     ELSE                                                         
DT6878        MOVE '7500'                     TO ACTIVE-PARAGRAPH       
DT6878        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
DT6878        MOVE 'SELECT'                   TO ABEND-FUNCTION         
DT6878        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
DT6878        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
DT6878        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
DT6878        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
DT6878        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
DT6878     END-IF.                                                      
DT6878                                                                  
DT6878 7500-EXIT.                                                       
DT6878     EXIT.                                                        
DT6878*                                                                         
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04479_R1                            
             (                                                          
              RETURN_CODE,                                              
              ASSIGNED_DATE,                                            
              SERV_ORDER_NO,                                            
              ORDER_TYPE_CD,                                            
              ORDER_STATE_CD,                                           
              CUSTOMER_NAME,                                            
              REMARKS,                                                  
              WORK_AREA,                                                
              PHONE,                                                    
              REMARK_TYPE,                                              
              SERV_ORDER_STATUS                                         
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-ASSIGNED-DATE,                                        
               :S-SERV-ORDER-NO-1,                                      
               :S-ORDER-TYPE-CD,                                        
               :S-ORDER-STATE-CD,                                       
               :S-CUSTOMER-NAME,                                        
               :S-REMARKS,                                              
               :S-WORK-AREA,                                            
               :S-PHONE,                                                
               :S-REMARK-TYPE,                                          
               :S-SERV-ORDER-STATUS                                     
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04479_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ASSIGNED_DATE,                                                    
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       ORDER_TYPE_CD,                                                    
MFA-TR*       ORDER_STATE_CD,                                                   
MFA-TR*       CUSTOMER_NAME,                                                    
MFA-TR*       REMARKS,                                                          
MFA-TR*       WORK_AREA,                                                        
MFA-TR*       PHONE,                                                            
MFA-TR*       REMARK_TYPE,                                                      
MFA-TR*       SERV_ORDER_STATUS                                                 
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-ASSIGNED-DATE,                                                
MFA-TR*        :S-SERV-ORDER-NO-1,                                              
MFA-TR*        :S-ORDER-TYPE-CD,                                                
MFA-TR*        :S-ORDER-STATE-CD,                                               
MFA-TR*        :S-CUSTOMER-NAME,                                                
MFA-TR*        :S-REMARKS,                                                      
MFA-TR*        :S-WORK-AREA,                                                    
MFA-TR*        :S-PHONE,                                                        
MFA-TR*        :S-REMARK-TYPE,                                                  
MFA-TR*        :S-SERV-ORDER-STATUS                                             
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04479_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04479_R2                            
             (                                                          
              RETURN_CODE,                                              
              CODE_UTIL_TYPE,                                           
              METER_NO,                                                 
              RATE_PLAN,                                                
              SUPPLIES,                                                 
              METER_LOC,                                                
              METER_STATUS,                                             
              METER_STATUS_REASON,                                      
              WORK_TYPE_CD,                                             
              METER_READ_INST,                                          
              METER_IND,                                                
              IC_NO,                                                    
              MTR_REF_NO,                                               
              CODE_REV_CLASS,                                           
              GAS_MTRS_COUNT,                                           
              ELEC_MTRS_COUNT,                                          
              RLSE_IND,                                                 
              RLSE_NO,                                                  
              SO_SEQ_NO                                                 
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-CODE-UTIL-TYPE-2,                                     
               :S-METER-NO-2,                                           
               :S-RATE-PLAN-2,                                          
               :S-SUPPLIES,                                             
               :S-METER-LOC,                                            
               :S-METER-STATUS,                                         
               :S-METER-STATUS-REASON,                                  
               :S-WORK-TYPE-CD-2,                                       
               :S-METER-READ-INST,                                      
               :S-METER-IND,                                            
               :S-IC-NO-2,                                              
               :S-MTR-REF-NO-2,                                         
               :S-CODE-REV-CLASS-2,                                     
               :S-GAS-MTRS-COUNT-2,                                     
               :S-ELEC-MTRS-COUNT-2,                                    
               :S-RLSE-IND-2,                                           
               :S-RLSE-NO-2,                                            
               :S-SO-SEQ-NO-2                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04479_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       METER_NO,                                                         
MFA-TR*       RATE_PLAN,                                                        
MFA-TR*       SUPPLIES,                                                         
MFA-TR*       METER_LOC,                                                        
MFA-TR*       METER_STATUS,                                                     
MFA-TR*       METER_STATUS_REASON,                                              
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       METER_READ_INST,                                                  
MFA-TR*       METER_IND,                                                        
MFA-TR*       IC_NO,                                                            
MFA-TR*       MTR_REF_NO,                                                       
MFA-TR*       CODE_REV_CLASS,                                                   
MFA-TR*       GAS_MTRS_COUNT,                                                   
MFA-TR*       ELEC_MTRS_COUNT,                                                  
MFA-TR*       RLSE_IND,                                                         
MFA-TR*       RLSE_NO,                                                          
MFA-TR*       SO_SEQ_NO                                                         
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-CODE-UTIL-TYPE-2,                                             
MFA-TR*        :S-METER-NO-2,                                                   
MFA-TR*        :S-RATE-PLAN-2,                                                  
MFA-TR*        :S-SUPPLIES,                                                     
MFA-TR*        :S-METER-LOC,                                                    
MFA-TR*        :S-METER-STATUS,                                                 
MFA-TR*        :S-METER-STATUS-REASON,                                          
MFA-TR*        :S-WORK-TYPE-CD-2,                                               
MFA-TR*        :S-METER-READ-INST,                                              
MFA-TR*        :S-METER-IND,                                                    
MFA-TR*        :S-IC-NO-2,                                                      
MFA-TR*        :S-MTR-REF-NO-2,                                                 
MFA-TR*        :S-CODE-REV-CLASS-2,                                             
MFA-TR*        :S-GAS-MTRS-COUNT-2,                                             
MFA-TR*        :S-ELEC-MTRS-COUNT-2,                                            
MFA-TR*        :S-RLSE-IND-2,                                                   
MFA-TR*        :S-RLSE-NO-2,                                                    
MFA-TR*        :S-SO-SEQ-NO-2                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04479_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04479_R3                            
             (                                                          
              RETURN_CODE,                                              
              SERV_ORDER_NO,                                            
              CODE_UTIL_TYPE,                                           
              WORK_TYPE_CD,                                             
              IC_NO,                                                    
              METER_NO,                                                 
              MTR_REF_NO                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-SERV-ORDER-NO-3,                                      
               :S-CODE-UTIL-TYPE-3,                                     
               :S-WORK-TYPE-CD-3,                                       
               :S-IC-NO-3,                                              
               :S-METER-NO-3,                                           
               :S-MTR-REF-NO-3                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04479_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       IC_NO,                                                            
MFA-TR*       METER_NO,                                                         
MFA-TR*       MTR_REF_NO                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-SERV-ORDER-NO-3,                                              
MFA-TR*        :S-CODE-UTIL-TYPE-3,                                             
MFA-TR*        :S-WORK-TYPE-CD-3,                                               
MFA-TR*        :S-IC-NO-3,                                                      
MFA-TR*        :S-METER-NO-3,                                                   
MFA-TR*        :S-MTR-REF-NO-3                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04479_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-SEND-RESULT-4.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04479_R4                            
             (                                                          
              RETURN_CODE,                                              
              RATE_PLAN_NO,                                             
              RATE_ITEM_CODE,                                           
              CODE_PLAN_STATUS,                                         
              CODE_STATUS_REASON,                                       
              MONTHLY_AMOUNT,                                           
              NO_UNITS,                                                 
              SUBDIVISION_FL,                                           
              IC_NO,                                                    
              RATE_PLAN_DESC,                                           
              SERVICE_TYPE,                                             
              DIST_NO,                                                  
              POLE_NO                                                   
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-4,                                        
               :S-RATE-PLAN-4,                                          
               :S-RATE-ITEM-CODE,                                       
               :S-CODE-PLAN-STATUS,                                     
               :S-CODE-STATUS-REASON,                                   
               :S-MONTHLY-AMOUNT,                                       
               :S-NO-UNITS,                                             
               :S-SUBDIVISION-FL,                                       
               :S-IC-NO-4,                                              
               :S-RATE-PLAN-DESC-4,                                     
               :S-SERVICE-TYPE,                                         
               :S-DIST-NO,                                              
               :S-POLE-NO                                               
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04479_R4                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       RATE_PLAN_NO,                                                     
MFA-TR*       RATE_ITEM_CODE,                                                   
MFA-TR*       CODE_PLAN_STATUS,                                                 
MFA-TR*       CODE_STATUS_REASON,                                               
MFA-TR*       MONTHLY_AMOUNT,                                                   
MFA-TR*       NO_UNITS,                                                         
MFA-TR*       SUBDIVISION_FL,                                                   
MFA-TR*       IC_NO,                                                            
MFA-TR*       RATE_PLAN_DESC,                                                   
MFA-TR*       SERVICE_TYPE,                                                     
MFA-TR*       DIST_NO,                                                          
MFA-TR*       POLE_NO                                                           
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-4,                                                
MFA-TR*        :S-RATE-PLAN-4,                                                  
MFA-TR*        :S-RATE-ITEM-CODE,                                               
MFA-TR*        :S-CODE-PLAN-STATUS,                                             
MFA-TR*        :S-CODE-STATUS-REASON,                                           
MFA-TR*        :S-MONTHLY-AMOUNT,                                               
MFA-TR*        :S-NO-UNITS,                                                     
MFA-TR*        :S-SUBDIVISION-FL,                                               
MFA-TR*        :S-IC-NO-4,                                                      
MFA-TR*        :S-RATE-PLAN-DESC-4,                                             
MFA-TR*        :S-SERVICE-TYPE,                                                 
MFA-TR*        :S-DIST-NO,                                                      
MFA-TR*        :S-POLE-NO                                                       
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04479_R4'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-SEND-RESULT-5.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04479_R5                            
             (                                                          
              RETURN_CODE,                                              
              CODE_UTIL_TYPE,                                           
              IC_NO,                                                    
              RATE_PLAN_NO,                                             
              CODE_REV_CLASS,                                           
              RATE_PLAN_DESC,                                           
              TOU_FL,                                                   
              FIXED_FACTOR_FL,                                          
              BILL_CONTRACT_FL,                                         
              INTERRUPT_FL,                                             
              READ_ROUTE                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-5,                                        
               :S-CODE-UTIL-TYPE-5,                                     
               :S-IC-NO-5,                                              
               :S-RATE-PLAN-5,                                          
               :S-CODE-REV-CLASS-5,                                     
               :S-RATE-PLAN-DESC-5,                                     
               :S-TOU-FL,                                               
               :S-FIXED-FACTOR-FL,                                      
               :S-BILL-CONTRACT-FL,                                     
               :S-INTERRUPT-FL,                                         
               :S-READ-ROUTE-5                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04479_R5                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       IC_NO,                                                            
MFA-TR*       RATE_PLAN_NO,                                                     
MFA-TR*       CODE_REV_CLASS,                                                   
MFA-TR*       RATE_PLAN_DESC,                                                   
MFA-TR*       TOU_FL,                                                           
MFA-TR*       FIXED_FACTOR_FL,                                                  
MFA-TR*       BILL_CONTRACT_FL,                                                 
MFA-TR*       INTERRUPT_FL,                                                     
MFA-TR*       READ_ROUTE                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-5,                                                
MFA-TR*        :S-CODE-UTIL-TYPE-5,                                             
MFA-TR*        :S-IC-NO-5,                                                      
MFA-TR*        :S-RATE-PLAN-5,                                                  
MFA-TR*        :S-CODE-REV-CLASS-5,                                             
MFA-TR*        :S-RATE-PLAN-DESC-5,                                             
MFA-TR*        :S-TOU-FL,                                                       
MFA-TR*        :S-FIXED-FACTOR-FL,                                              
MFA-TR*        :S-BILL-CONTRACT-FL,                                             
MFA-TR*        :S-INTERRUPT-FL,                                                 
MFA-TR*        :S-READ-ROUTE-5                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04479_R5'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04479_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04479_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8001'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04479_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04479_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04479_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8002'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04479_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04479_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04479_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8003'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04479_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8004-DELETE-GTT4-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04479_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04479_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8004'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04479_R4'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8004-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8005-DELETE-GTT5-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04479_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04479_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8005'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04479_R5'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT04-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-4                             
               EXEC SQL                                                 
                   OPEN N4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT05-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-5                             
               EXEC SQL                                                 
                   OPEN N5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
