       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04478.                                          
COB303 DATE-WRITTEN.      AUGUST 9, 2011.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETURNS MISC SERVICE ORDER INITIATION INFO.      *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/09/11    FMB      NEW PROGRAM.                             *        
A04670*  08/06/13    FMB      HANDLE -100 RETURN CODE.                 *        
P00795*  03/19/14    PK44514  AOO - CHANGES TO CONTACT MATRIX FOR      *        
P00795*                       GROUP A ORDERS.                          *        
P0795A*  03/19/15    PK44514  DEFECT 6994 - FIX FOR CONTACT INFO       *        
P0795A*                       INCORRECT FOR STOP/REVERT.               *        
P0795A*  05/26/15    PK44514  MAINTAIN                                 *        
DT9459*  05/26/15    PK44514  DEFECT 9459-MAINTIAN SHOULD GET BILLING  *        
DT9459*                       ADDR FOR ACCT_NO_PRIOR                   *        
DT9498*  10/30/15    PK44514  DEFECT 9498-NEW SERVICE ADDRESS NOT      *        
DT9498*                       DISPLAYING IN MAINTAIN                   *        
DT9511*  11/06/15    PK44514  RETRIVE SO CONTRACTS DETAILS.            *        
DT9130*  02/01/16    PK44514  RETRIVE PREMISE APPLIANCES FOR GROUP A   *        
      *                       ORDERS IN MAINTAIN                       *        
DT9528*  02/16/16    PK44514  RETURN CONTRACT DETAILS FOR CC AND NC    *        
      *                       ORDERS IN MAINTAIN, RETURN CDP           *        
D10775*  06/16/16    PK44514  FB ADDRESS CHANGES FOR BANKRUPTCY        *        
D11722*  06/29/16    PK44514  PLACED BY FIX FOR NC001 ORDERS           *        
DT9519*  08/16/16    PK44514  DNP CANCEL CHANGES.                      *        
A05317*  01/05/16    PK44514  REMOVE CALL TO CSR02364 AND GET DATA     *        
A05317*                       DIRECTLY FROM CSS_CRED_FORECAST TABLE    *        
A05317*  01/12/16    PK44514  FIX BILL DATE NOT SHOWING FOR OFF TO CC  *        
A05317*                       ORDERS                                   *        
D26359*  02/09/17    PK44514  TO PREVENT UPDATE TO WORK TYPE IF A ROW  *        
D26359*                       EXISTS IN SO_METER FOR SOME WORK TYPES.  *        
D26741*  03/07/17    PK44514  TO ADD NULL INDICATOR FOR FETCH HST-SO-AP*        
D26741*                       PL-CURSOR WHEN APPL DELETED FROM PREMISE *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04478'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
           'WORKING STORAGE FOR CSR04478 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTEML                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCONMAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCOAPP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTCCS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTACT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOEQP                                                   
           END-EXEC.                                                            
                                                                        
DT9130* CSS_ORDER_TYPE C2                                                       
DT9130     EXEC SQL                                                             
DT9130        INCLUDE TBORTYP                                                   
DT9130     END-EXEC.                                                            
                                                                        
MAINTN* ** VO                                                                   
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
MAINTN* ** YT                                                                   
           EXEC SQL                                                             
              INCLUDE TBMTRTOF                                                  
           END-EXEC.                                                            
                                                                        
MAINTN* ** YV                                                                   
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
                                                                        
MAINTN* ** XD                                                                   
           EXEC SQL                                                             
              INCLUDE TBSOFIN                                                   
           END-EXEC.                                                            
                                                                        
MAINTN* ** YZ                                                                   
           EXEC SQL                                                             
              INCLUDE TBHSTFIN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_REMARKS     EF                                       *        
      ******************************************************************        
MAINTN     EXEC SQL                                                             
MAINTN        INCLUDE TBSOREM                                                   
MAINTN     END-EXEC.                                                            
      ******************************************************************        
      *    HST_SO_REMARKS     OE                                       *        
      ******************************************************************        
MAINTN     EXEC SQL                                                             
MAINTN        INCLUDE TBHSTREM                                                  
MAINTN     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_DNP         AI                                       *        
      ******************************************************************        
DT9519     EXEC SQL                                                             
DT9519        INCLUDE TBSODNP                                                   
DT9519     END-EXEC.                                                            
      ******************************************************************        
      *    HST_SO_DNP         YW                                       *        
      ******************************************************************        
DT9519     EXEC SQL                                                             
DT9519        INCLUDE TBHSTDNP                                                  
DT9519     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    HST_SO_APPLIANCE   XZ                                       *        
      ******************************************************************        
MAINTN     EXEC SQL                                                             
MAINTN        INCLUDE TBHSTEQP                                                  
MAINTN     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CRED_FORECAST  CM                                       *        
      ******************************************************************        
A05317     EXEC SQL                                                             
A05317        INCLUDE TBCRFCST                                                  
A05317     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SO_METER       VM                                       *        
      ******************************************************************        
D26359     EXEC SQL                                                             
D26359        INCLUDE TBSOMTR                                                   
D26359     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04478_R1'.          
            05  GTT-NAME-2              PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04478_R2'.          
            05  GTT-NAME-3              PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04478_R3'.          
            05  GTT-NAME-5              PIC X(26)                       
                                             VALUE                      
                                        'SESSION.CSR04478_R5'.          
DT9511      05  GTT-NAME-8              PIC X(26)                       
DT9511                                       VALUE                      
DT9511                                  'SESSION.CSR04478_R8'.          
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 GTT-RETURN-FIELDS-1.                                      
               10 S-RETURN-CODE-1     PIC S9(9) COMP VALUE 0.           
               10 S-BILL-ADDRESS      PIC X(80) VALUE SPACES.           
               10 S-SPCL-READ-INST    PIC X(114) VALUE SPACES.          
               10 S-SPCL-INST         PIC X(255) VALUE SPACES.          
               10 S-PREM-DIRECTIONS   PIC X(255) VALUE SPACES.          
               10 S-SCRATCHPAD        PIC X(255) VALUE SPACES.          
               10 S-ADDRESS-DATA.                                       
                   15 S-ADDRESS-ID    PIC S9(13)V COMP-3 VALUE 0.       
                   15 S-ADDRESS-FORMAT PIC X(01) VALUE SPACES.          
                   15 S-ADDR-STREET   PIC X(55) VALUE SPACES.           
                   15 S-ADDR-CITY-STATE PIC X(30) VALUE SPACES.         
                   15 S-ADDR-ZIP-CODE PIC X(09) VALUE SPACES.           
                   15 S-ADDR-COUNTRY  PIC X(35) VALUE SPACES.           
                   15 S-ADDR-STREET-2 PIC X(55) VALUE SPACES.           
                   15 S-HOUSE-NO      PIC X(15) VALUE SPACES.           
                   15 S-ADDR-PREFIX-1 PIC X(03) VALUE SPACES.           
                   15 S-ADDR-PREFIX-2 PIC X(02) VALUE SPACES.           
                   15 S-STREET-NAME   PIC X(30) VALUE SPACES.           
                   15 S-STREET-SUFFIX PIC X(04) VALUE SPACES.           
                   15 S-ADDR-SUFFIX   PIC X(02) VALUE SPACES.           
                   15 S-STREET-LOCATION-1 PIC X(04) VALUE SPACES.       
                   15 S-STREET-LOCATION-2 PIC X(11) VALUE SPACES.       
                   15 S-ZIP-CODE      PIC X(09) VALUE SPACES.           
                   15 S-ZIP-CODE-PLUS-FOUR PIC X(04) VALUE SPACES.      
                   15 S-ZIP-CODE-TOKEN PIC X(01) VALUE SPACES.          
                   15 S-STATE          PIC X(02) VALUE SPACES.          
               10 S-SUBDIVISION-ID     PIC X(03) VALUE SPACES.          
               10 S-EST-BILL-DAY       PIC X(02) VALUE SPACES.          
               10 S-EST-DUE-DAY        PIC X(02) VALUE SPACES.          
               10 S-EMAIL-ADDRESS      PIC X(100) VALUE SPACES.         
           05 GTT-RETURN-FIELDS-2.                                      
               10 S-RETURN-CODE-2     PIC S9(9) COMP VALUE 0.           
               10 S-NAME-TYPE         PIC X(02) VALUE SPACES.           
               10 S-CONTACT-TYPE      PIC X(02) VALUE SPACES.           
               10 S-MATRIX-NAME       PIC X(76) VALUE SPACES.           
           05 GTT-RETURN-FIELDS-3.                                      
               10 S-RETURN-CODE-3     PIC S9(9) COMP VALUE 0.           
               10 S-EQUIPMENT-NO      PIC X(20) VALUE SPACES.           
               10 S-APPLIANCE-CD      PIC X(02) VALUE SPACES.           
               10 S-CAUTION-TAG-IND   PIC X(01) VALUE SPACES.           
               10 S-CUT-IND           PIC X(01) VALUE SPACES.           
               10 S-TAG-NO            PIC X(10) VALUE SPACES.           
               10 S-CONDITION-CD      PIC X(03) VALUE SPACES.           
               10 S-LOCATION-CD       PIC X(03) VALUE SPACES.           
               10 S-APPL-COMMENTS     PIC X(255) VALUE SPACES.          
               10 S-CAUTION-TAG-DT    PIC X(10) VALUE SPACES.           
               10 S-SOURCE-SYSTEM-CD-3  PIC X(03) VALUE SPACES.         
               10 S-INSTALL-DT        PIC X(10) VALUE SPACES.           
               10 S-SERIAL-NO         PIC X(40) VALUE SPACES.           
               10 S-CAD-VERIFY-DT     PIC X(10) VALUE SPACES.           
               10 S-APPLIANCE-DESC    PIC X(20) VALUE SPACES.           
               10 S-SEASONAL-RT-FL    PIC X(01) VALUE SPACES.           
               10 S-CRAWL-FL          PIC X(01) VALUE SPACES.           
               10 S-APPL-LONG-DESC    PIC X(255) VALUE SPACES.          
               10 S-PRIMARY-FUEL-CD   PIC X(06) VALUE SPACES.           
               10 S-AVERAGE-BTU       PIC S9(09) COMP VALUE 0.          
               10 S-LEAK-IND          PIC X(01) VALUE SPACES.           
               10 S-LIGHT-IND         PIC X(01) VALUE SPACES.           
               10 S-REPAIR-IND        PIC X(01) VALUE SPACES.           
               10 S-CUTOFF-IND        PIC X(01) VALUE SPACES.           
               10 S-REPLACE-APP-FL    PIC X(01) VALUE SPACES.           
          05 GTT-RETURN-FIELDS-4.                                       
               10 S-RETURN-CODE-4             PIC S9(9) COMP VALUE 0.   
               10 S-ORDER-TYPE-CD-4           PIC X(05) VALUE SPACES.   
               10 S-ORDER-REASON              PIC X(15) VALUE SPACES.   
               10 S-STATUS-TX                 PIC X(25) VALUE SPACES.   
               10 S-ORDER-STATE-CD            PIC X(01) VALUE SPACES.   
               10 S-ORDER-PLACED-BY           PIC X(25) VALUE SPACES.   
               10 S-PHONE-NO                  PIC X(10) VALUE SPACES.   
               10 S-PHONE-NO-EXT              PIC X(06) VALUE SPACES.   
               10 S-WANTED-BY-DATE            PIC X(10) VALUE SPACES.   
               10 S-ASSIGNED-DATE             PIC X(10) VALUE SPACES.   
               10 S-CALL-BEFORE-MINUTS        PIC X(03) VALUE SPACES.   
               10 S-WORK-AREA-ID              PIC X(12) VALUE SPACES.   
               10 S-BREAKERS-OFF-IND          PIC X(01) VALUE SPACES.   
               10 S-INIT-BY-CNTRCT-IND        PIC X(01) VALUE SPACES.   
               10 S-NOTIFY-CSR-IND            PIC X(01) VALUE SPACES.   
               10 S-NOTIFY-CUST-IND           PIC X(01) VALUE SPACES.   
               10 S-ORDER-PRIORITY-CD         PIC S9(4) COMP VALUE 0.   
               10 S-STD-LABOR-CHRG            PIC S9(7)V9(2) COMP-3     
                                                         VALUE 0.       
               10 S-WORK-TYPE-CD-4            PIC X(03) VALUE SPACES.   
               10 S-BACK-DATED-IND            PIC X(01) VALUE SPACES.   
               10 S-DEPOSIT-AMT               PIC S9(9)V9(2) COMP-3     
                                                           VALUE 0.     
               10 S-ORDER-RECVED-BY           PIC X(07) VALUE SPACES.   
               10 S-VERIFY-RATE               PIC X(01) VALUE SPACES.   
               10 S-PREMISE-NO              PIC S9(10)V COMP-3 VALUE 0. 
               10 S-ACCOUNT-NO              PIC S9(13)V COMP-3 VALUE 0. 
               10 S-ACCOUNT-NO-PRIOR        PIC S9(13)V COMP-3 VALUE 0. 
               10 S-BEGIN-APPT-DATE           PIC X(26) VALUE SPACES.   
               10 S-SO-EST-LABOR-HR         PIC S9(5)V9 COMP-3 VALUE 0. 
               10 S-CUSTCHG-ORD-TYPE-FL       PIC X(01) VALUE SPACES.   
               10 S-AMOUNT-DISC-BAL           PIC S9(9)V9(2) COMP-3     
                                                           VALUE 0.     
               10 S-CURRENT-DATE              PIC X(10) VALUE SPACES.   
               10 S-CODE-UTIL-TYPE-4          PIC X(01) VALUE SPACES.   
               10 S-PRICE-PER-SERV            PIC S9(3)V9(6) COMP-3     
                                                             VALUE 0.   
               10 S-ACCOUNT-TYPE-DESC         PIC X(25) VALUE SPACES.   
               10 S-ORDER-CHARGE-AMT          PIC S9(3)V9(2) COMP-3     
                                                            VALUE 0.    
               10 S-TOTAL-CHARGES-AMT         PIC S9(7)V9(2) COMP-3     
                                                            VALUE 0.    
               10 S-CUST-CNT-ID               PIC X(10) VALUE SPACES.   
               10 S-MTR-ACCESSIBLE-CD         PIC X(02) VALUE SPACES.   
               10 S-MTR-ACCESSIBLE-DT         PIC X(10) VALUE SPACES.   
               10 S-MTR-ACCESSIBLE-RSN        PIC X(02) VALUE SPACES.   
               10 S-SOURCE-SYSTEM-CD-4        PIC X(03) VALUE SPACES.   
               10 S-ALT-PHONE-NO              PIC X(10) VALUE SPACES.   
               10 S-ALT-PHONE-NO-EXT          PIC X(06) VALUE SPACES.   
               10 S-HOME-ALL-DAY-FL           PIC X(01) VALUE SPACES.   
               10 S-BUSINESS-UNIT             PIC X(03) VALUE SPACES.   
               10 S-OPTIMIZE-ORDER            PIC X(01) VALUE SPACES.   
               10 S-END-APPT-DATE             PIC X(26) VALUE SPACES.   
               10 S-APPT-AM-PM-CD             PIC X(01) VALUE SPACES.   
               10 S-MTR-TURNOFF-RSN-CD        PIC X(01) VALUE SPACES.   
               10 S-FUEL-CHNG-RSN-CD          PIC X(01) VALUE SPACES.   
               10 S-FUEL-CHNG-TYPE-CD         PIC X(01) VALUE SPACES.   
               10 S-TURNOFF-COMMENTS          PIC X(255) VALUE SPACES.  
               10 S-WORK-DISTRICT             PIC X(40) VALUE SPACES.   
DT9528         10 S-CODES-DATA-PRESENT        PIC X(35) VALUE SPACES.   
DT9528         10 S-CANCEL-REASON-CD          PIC X(01) VALUE SPACES.   
D26359         10 S-SO-MTR-ROW-EXISTS         PIC X(01) VALUE SPACES.   
          05 GTT-RETURN-FIELDS-5.                                       
               10 S-RETURN-CODE-5            PIC S9(04) COMP VALUE 0.   
               10 S-SERV-ORDER-NO-5          PIC S9(13)V COMP-3 VALUE 0.
               10 S-REMARK-TYPE-CD           PIC X(01)  VALUE SPACES.   
               10 S-REMARK-TX                PIC X(210).                
          05 GTT-RETURN-FIELDS-6.                                       
               10 S-RETURN-CODE-6          PIC S9(09) COMP VALUE 0.     
               10 S-TO-ACCT-NO-6           PIC S9(13)V COMP-3 VALUE 0.  
               10 S-ROOMMATE-XFER-IND-6    PIC X(01) VALUE SPACES.      
               10 S-EPP-XFER-IND-6         PIC X(01) VALUE SPACES.      
               10 S-DEPOSIT-XFER-IND-6     PIC X(01) VALUE SPACES.      
               10 S-OTHER-AR-XFER-IND-6    PIC X(01) VALUE SPACES.      
               10 S-PROJ-SHR-XFER-IND-6    PIC X(01) VALUE SPACES.      
               10 S-WRITE-OFF-XFER-IND-6 PIC X(01) VALUE SPACES.        
               10 S-IN-LIEU-XFER-IND-6     PIC X(01) VALUE SPACES.      
               10 S-WHT-CROSS-XFER-IND-6 PIC X(01) VALUE SPACES.        
               10 S-COAPPL-XFER-IND-6      PIC X(01) VALUE SPACES.      
               10 S-MED-CERT-XFER-IND-6    PIC X(01) VALUE SPACES.      
               10 S-NAME-FORMAT-6          PIC X(01) VALUE SPACES.      
               10 S-FIRST-NAME-6           PIC X(15) VALUE SPACES.      
               10 S-MIDDLE-NAME-6          PIC X(15) VALUE SPACES.      
               10 S-LAST-NAME-6            PIC X(40) VALUE SPACES.      
               10 S-FULL-NAME-6            PIC X(70) VALUE SPACES.      
               10 S-HOUSE-NO-6             PIC X(15) VALUE SPACES.      
               10 S-ADDR-PREFIX-1-6        PIC X(03) VALUE SPACES.      
               10 S-ADDR-PREFIX-2-6        PIC X(02) VALUE SPACES.      
               10 S-STREET-NAME-6          PIC X(30) VALUE SPACES.      
               10 S-STREET-LOCATION-1-6    PIC X(04) VALUE SPACES.      
               10 S-STREET-LOCATION-2-6    PIC X(11) VALUE SPACES.      
               10 S-STREET-SUFFIX-6        PIC X(04) VALUE SPACES.      
               10 S-CUSTOMER-FROM-6        PIC S9(10)V COMP-3 VALUE 0.  
                                                                        
          05 GTT-RETURN-FIELDS-7.                                       
               10 S-RETURN-CODE-7          PIC S9(09) COMP VALUE 0.     
               10 S-ACCOUNT-NO-PRIOR-7     PIC X(13) VALUE SPACES.      
               10 S-SERV-ORDER-NO-7        PIC X(13) VALUE SPACES.      
               10 S-WANTED-BY-DATETIME-7   PIC X(26) VALUE SPACES.      
               10 S-CREDIT-LETTER-IND-7    PIC X(01) VALUE SPACES.      
               10 S-STREET-LOCATION-1-7    PIC X(04) VALUE SPACES.      
               10 S-STREET-LOCATION-2-7    PIC X(11) VALUE SPACES.      
               10 S-ADDR-ST-7              PIC X(55) VALUE SPACES.      
               10 S-ADDR-ZIP-CODE-7        PIC X(09) VALUE SPACES.      
               10 S-ADDR-PREFIX-1-7        PIC X(03) VALUE SPACES.      
               10 S-ADDR-PREFIX-2-7        PIC X(02) VALUE SPACES.      
               10 S-ADDR-SUFFIX-7          PIC X(02) VALUE SPACES.      
               10 S-ADDRESS-OVERFLOW-7     PIC X(35) VALUE SPACES.      
               10 S-HOUSE-NO-7             PIC X(15) VALUE SPACES.      
               10 S-ADDRESS-FORMAT-7       PIC X(01) VALUE SPACES.      
               10 S-STREET-NAME-7          PIC X(30) VALUE SPACES.      
               10 S-STREET-SUFFIX-7        PIC X(04) VALUE SPACES.      
               10 S-ZIP-CODE-7             PIC X(05) VALUE SPACES.      
               10 S-ZIP-CODE-PLUS-FOUR-7   PIC X(04) VALUE SPACES.      
               10 S-ZIP-CODE-TOKEN-7       PIC X(01) VALUE SPACES.      
               10 S-SEND-TO-LOCOFF-IND-7   PIC X(01) VALUE SPACES.      
               10 S-ADDR-COUNTRY-7         PIC X(35) VALUE SPACES.      
               10 S-CARRIER-ROUTE-7        PIC X(05) VALUE SPACES.      
               10 S-FINAL-BILL-CY-ST-7     PIC X(30) VALUE SPACES.      
               10 S-FINAL-BILL-OVFL-7      PIC X(35) VALUE SPACES.      
               10 S-DEPOSIT-AMT-7          PIC S9(9)V9(2) COMP-3        
                                                    VALUE 0.            
               10 S-FB-ADDR-TYPE-7         PIC X(01) VALUE SPACES.      
               10 S-FB-ADDR-LINE-7         PIC X(80) VALUE SPACES.      
                                                                        
DT9511    05 GTT-RETURN-FIELDS-8.                                       
DT9511         10 S-RETURN-CODE-8          PIC S9(09) COMP VALUE 0.     
DT9511         10 S-CONTRACT-ID-8          PIC S9(09) COMP VALUE 0.     
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
P00795     05  SW-CONTACT              PIC X(01) VALUE 'N'.             
P00795         88 NO-CONTACT-EXIST               VALUE 'N'.             
P00795         88 CONTACT-EXIST                  VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-PREMISE-NO-CHAR       PIC X(10).                      
           05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO-CHAR    
                                        PIC 9(10).                      
           05  WS-ACCOUNT-NO-CHAR       PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-CHAR    
                                        PIC 9(13).                      
           05  WS-CUSTOMER-NO-CHAR      PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-CHAR   
                                        PIC 9(10).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04478'.     
           05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.         
           05  WS-ADDRESS-LINE1         PIC X(80) VALUE SPACES.         
           05  WS-NULL1                 PIC S9(4) COMP VALUE +0.        
           05  WS-NULL2                 PIC S9(4) COMP VALUE +0.        
           05  WS-NULL3                 PIC S9(4) COMP VALUE +0.        
           05  WS-NULL4                 PIC S9(4) COMP VALUE +0.        
           05  WS-NULL-APPT-DT          PIC S9(04) COMP.                
           05  WS-NULL-BEGIN-APPT-DT    PIC S9(04) COMP.                
           05  WS-NULL-END-APPT-DT      PIC S9(04) COMP.                
           05  WS-NULL-ACCESS-DT        PIC S9(04) COMP.                
           05  WS-NULL-ACCT-DESC        PIC S9(04) COMP.                
           05  WS-FUEL-NULL-IND         PIC S9(04) COMP.                
           05  WS-SERIAL-NULL-IND       PIC S9(04) COMP.                
           05  WS-SOURCE-NULL-IND       PIC S9(04) COMP.                
           05  WS-COMMENTS-NULL-IND     PIC S9(04) COMP.                
           05  WS-LOCATION-NULL-IND     PIC S9(04) COMP.                
           05  WS-CONDITION-NULL-IND    PIC S9(04) COMP.                
           05  WS-CUT-NULL-IND          PIC S9(04) COMP.                
           05  WS-TAG-NULL-IND          PIC S9(04) COMP.                
           05  WS-FBILL-NULL1           PIC S9(04) COMP.                
           05  WS-FBILL-NULL2           PIC S9(04) COMP.                
           05  WS-FBILL-NULL3           PIC S9(04) COMP.                
           05  WS-FBILL-NULL4           PIC S9(04) COMP.                
           05  WS-FBILL-NULL5           PIC S9(04) COMP.                
           05  WS-FBILL-NULL6           PIC S9(04) COMP.                
           05  WS-FBILL-NULL7           PIC S9(04) COMP.                
           05  WS-FBILL-NULL8           PIC S9(04) COMP.                
           05  WS-FBILL-NULL9           PIC S9(04) COMP.                
           05  WS-FBILL-NULL10          PIC S9(04) COMP.                
           05  WS-FBILL-NULL11          PIC S9(04) COMP.                
           05  WS-FBILL-NULL12          PIC S9(04) COMP.                
           05  WS-FBILL-NULL13          PIC S9(04) COMP.                
           05  WS-FBILL-NULL14          PIC S9(04) COMP.                
           05  WS-FBILL-NULL15          PIC S9(04) COMP.                
           05  WS-FBILL-NULL16          PIC S9(04) COMP.                
           05  WS-FBILL-NULL17          PIC S9(04) COMP.                
           05  WS-FBILL-NULL18          PIC S9(04) COMP.                
           05  WS-FBILL-NULL19          PIC S9(04) COMP.                
           05  WS-FBILL-NULL20          PIC S9(04) COMP.                
           05  WS-FBILL-NULL21          PIC S9(04) COMP.                
           05  WS-FB-ADDR-TYPE          PIC X(01)  VALUE SPACES.        
           05  WS-FB-ADDR-LINE          PIC X(80)  VALUE SPACES.        
           05  WS-OLD-CUSTOMER-NO       PIC S9(10) COMP VALUE +0.       
           05  WS-NEW-CUSTOMER-NO       PIC S9(10) COMP VALUE +0.       
           05  WS-ORDER-GROUP-CD        PIC X(01) VALUE SPACES.         
           05  WS-ORDER-TYPE-CD         PIC X(05) VALUE SPACES.         
           05  WS-SEASONAL-FL           PIC X(01) VALUE 'N'.            
           05  WS-GTT02-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT05-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT06-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-GTT08-DECLARED        PIC X(01) VALUE 'N'.            
           05  WS-SQLSTATE              PIC X(05) VALUE '     '.        
           05  WS-PROCESS               PIC X(05) VALUE SPACES.         
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-SPACE-CNT             PIC S9(04) COMP VALUE +0.       
           05  WS-LENGTH                PIC S9(04) COMP VALUE +0.       
MAINTN     05  WS-SERV-ORDER-NO-C       PIC X(13).                      
MAINTN     05  WS-SERV-ORDER-NO-N       REDEFINES WS-SERV-ORDER-NO-C    
MAINTN                                  PIC 9(13).                      
MAINTN     05  WS-NEW-ORDER-FL          PIC X(01) VALUE 'Y'.            
DT9459     05  WS-AT-ACCOUNT-NO         PIC S9(13)V COMP-3 VALUE 0.     
DT9459     05  WS-AT-ACCOUNT-NO-PRIOR   PIC S9(13)V COMP-3 VALUE 0.     
           05  WS-A                     PIC X(01) VALUE 'A'.            
A05317     05  WS-REVENUE-MONTH-TEMP    PIC X(06) VALUE SPACES.         
D26359     05  WS-SO-MTR-ROW-EXISTS     PIC X(01) VALUE SPACES.         
           05  WS-ITERATION-STORAGE.                                    
               10  WS-NAME              PIC X(76).                      
               10  WS-CUST-NAME         PIC X(76).                      
               10  WS-SPOUSE-NAME       PIC X(70).                      
               10  WS-COAPP-NAME        PIC X(76).                      
               10  WS-PA-NAME           PIC X(76).                      
               10  WS-MP-NAME           PIC X(76).                      
               10  WS-TA-NAME           PIC X(76).                      
A05317*01  CSR02364-CALL-DATA.                                                  
A05317*    03 REV-MONTH-2364            PIC X(06) VALUE SPACES.                 
A05317*    03 BILL-CYCLE-IN-2364        PIC X(02) VALUE SPACES.                 
A05317*    03 CREDIT-GROUP-2364         PIC X(01) VALUE SPACES.                 
A05317*    03 COMPANY-NO-2364           PIC X(02) VALUE SPACES.                 
A05317*                                                                         
A05317*01  CSR02364-RETURN-DATA.                                                
A05317*    05  RETURN-CODE-2364      PIC S9(9) COMP VALUE 0.                    
A05317*    05  BILL-CYCLE-OUT-2364   PIC X(02) VALUE SPACES.                    
A05317*    05  READ-DT-2364          PIC X(10) VALUE SPACES.                    
A05317*    05  BILL-FROM-2364        PIC X(10) VALUE SPACES.                    
A05317*    05  BILL-TO-2364          PIC X(10) VALUE SPACES.                    
A05317*    05  MAIL-DT-2364          PIC X(10) VALUE SPACES.                    
A05317*    05  BILL-DUE-DT-2364      PIC X(10) VALUE SPACES.                    
A05317*    05  AVOID-LPC-DT-2364     PIC X(10) VALUE SPACES.                    
A05317*    05  FIRST-NOTICE-DT-2364  PIC X(10) VALUE SPACES.                    
A05317*    05  SECOND-NOTICE-DT-2364 PIC X(10) VALUE SPACES.                    
A05317*    05  DNP-DT-2364           PIC X(10) VALUE SPACES.                    
A05317*    05  DUE-EXCEPT-2364       PIC X(10) VALUE SPACES.                    
A05317*    05  SECOND-EXCEPT-2364    PIC X(10) VALUE SPACES.                    
A05317*    05  DNP-EXCEPT-2364       PIC X(10) VALUE SPACES.                    
A05317*    05  SECOND-FIELD-DT-2364  PIC X(10) VALUE SPACES.                    
A05317*    05  3RD-PRTY-READ-DT-2364 PIC X(10) VALUE SPACES.                    
A05317*    05  EXCEPT-IVR-DT-2364    PIC X(10) VALUE SPACES.                    
                                                                        
                                                                        
      ******************************************************************        
      * CSR01105 - GET DATA FOR EXISTING SERVICE ORDER                 *        
      ******************************************************************        
                                                                        
       01  CSR01105-CALL-DATA.                                          
           03  SERV-ORDER-NO-1105       PIC X(13) VALUE SPACES.         
           03  CURRENT-HISTORY-FL-1105  PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01105-RETURN-DATA.                                        
           05  RETURN-CODE-1105          PIC S9(9) COMP VALUE 0.        
           05  ORDER-TYPE-CD-1105        PIC X(05) VALUE SPACES.        
           05  ORDER-REASON-1105         PIC X(15) VALUE SPACES.        
           05  STATUS-TX-1105            PIC X(25) VALUE SPACES.        
           05  ORDER-STATE-CD-1105       PIC X(01) VALUE SPACES.        
           05  ORDER-PLACED-BY-1105      PIC X(25) VALUE SPACES.        
           05  PHONE-NO-1105             PIC X(10) VALUE SPACES.        
           05  PHONE-NO-EXT-1105         PIC X(06) VALUE SPACES.        
           05  WANTED-BY-DATETIME-1105   PIC X(26) VALUE SPACES.        
           05  ASSIGNED-DATETIME-1105    PIC X(26) VALUE SPACES.        
           05  CALL-BEFORE-MINUTS-1105   PIC X(03) VALUE SPACES.        
           05  WORK-AREA-ID-1105         PIC X(12) VALUE SPACES.        
           05  BREAKERS-OFF-IND-1105     PIC X(01) VALUE SPACES.        
           05  INIT-BY-CNTRCT-IND-1105   PIC X(01) VALUE SPACES.        
           05  NOTIFY-CSR-IND-1105       PIC X(01) VALUE SPACES.        
           05  NOTIFY-CUST-IND-1105      PIC X(01) VALUE SPACES.        
           05  ORDER-PRIORITY-CD-1105    PIC S9(4) COMP VALUE 0.        
           05  STD-LABOR-CHRG-1105       PIC S9(7)V9(2) COMP-3 VALUE 0. 
           05  WORK-TYPE-CD-1105         PIC X(03) VALUE SPACES.        
           05  BACK-DATED-IND-1105       PIC X(01) VALUE SPACES.        
           05  DEPOSIT-AMT-1105          PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  ORDER-RECVED-BY-1105      PIC X(07) VALUE SPACES.        
           05  VERIFY-RATE-1105          PIC X(01) VALUE SPACES.        
           05  PREMISE-NO-1105           PIC S9(10)V COMP-3 VALUE 0.    
           05  ACCOUNT-NO-1105           PIC S9(13)V COMP-3 VALUE 0.    
           05  ACCOUNT-NO-PRIOR-1105     PIC S9(13)V COMP-3 VALUE 0.    
           05  BEGIN-APPT-DATE-1105      PIC X(26) VALUE SPACES.        
           05  SO-EST-LABOR-HR-1105      PIC S9(5)V9 COMP-3 VALUE 0.    
           05  CUSTCHG-ORD-TYPE-FL-1105  PIC X(01) VALUE SPACES.        
           05  AMOUNT-DISC-BAL-1105      PIC S9(9)V9(2) COMP-3 VALUE 0. 
           05  FILLER-1105               PIC S9(4) COMP VALUE 0.        
           05  CURRENT-DATE-1105         PIC X(10) VALUE SPACES.        
           05  CODE-UTIL-TYPE-1105       PIC X(01) VALUE SPACES.        
           05  PRICE-PER-SERV-1105       PIC S9(3)V9(6) COMP-3 VALUE 0. 
           05  ACCOUNT-TYPE-DESC-1105    PIC X(25) VALUE SPACES.        
           05  ORDER-CHARGE-AMT-1105     PIC S9(3)V9(2) COMP-3 VALUE 0. 
           05  TOTAL-CHARGES-AMT-1105    PIC S9(7)V9(2) COMP-3 VALUE 0. 
           05  CUST-CNT-ID-1105          PIC X(10) VALUE SPACES.        
           05  FILLER-A-1105             PIC X(01) VALUE SPACES.        
           05  FILLER-B-1105             PIC X(10) VALUE SPACES.        
           05  FILLER-C-1105             PIC X(08) VALUE SPACES.        
           05  FILLER-D-1105             PIC X(10) VALUE SPACES.        
           05  FILLER-E-1105             PIC X(04) VALUE SPACES.        
           05  MTR-ACCESSIBLE-CD-1105    PIC X(02) VALUE SPACES.        
           05  MTR-ACCESSIBLE-DT-1105    PIC X(10) VALUE SPACES.        
           05  MTR-ACCESSIBLE-RSN-1105   PIC X(02) VALUE SPACES.        
           05  SOURCE-SYSTEM-CD-1105     PIC X(03) VALUE SPACES.        
           05  ALT-PHONE-NO-1105         PIC X(10) VALUE SPACES.        
           05  ALT-PHONE-NO-EXT-1105     PIC X(06) VALUE SPACES.        
           05  HOME-ALL-DAY-FL-1105      PIC X(01) VALUE SPACES.        
           05  BUSINESS-UNIT-1105        PIC X(03) VALUE SPACES.        
           05  OPTIMIZE-ORDER-1105       PIC X(01) VALUE SPACES.        
                                                                        
      ******************************************************************        
      * CSR01243 - GET DATA FROM SO_ACCT_XFER FOR EXISTING ORDER       *        
      ******************************************************************        
                                                                        
       01  CSR01243-CALL-DATA.                                          
           03  SERV-ORDER-NO-1243       PIC X(13) VALUE SPACES.         
           03  CURRENT-HISTORY-FL-1243  PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01243-RETURN-DATA.                                        
           05  RETURN-CODE-1243         PIC S9(09) COMP VALUE 0.        
           05  TO-ACCT-NO-1243          PIC S9(13)V COMP-3 VALUE 0.     
           05  ROOMMATE-XFER-IND-1243   PIC X(01) VALUE SPACES.         
           05  EPP-XFER-IND-1243        PIC X(01) VALUE SPACES.         
           05  DEPOSIT-XFER-IND-1243    PIC X(01) VALUE SPACES.         
           05  OTHER-AR-XFER-IND-1243   PIC X(01) VALUE SPACES.         
           05  PROJ-SHR-XFER-IND-1243   PIC X(01) VALUE SPACES.         
           05  WRITE-OFF-XFER-IND-1243  PIC X(01) VALUE SPACES.         
           05  IN-LIEU-XFER-IND-1243    PIC X(01) VALUE SPACES.         
           05  WHT-CROSS-XFER-IND-1243  PIC X(01) VALUE SPACES.         
           05  COAPPL-XFER-IND-1243     PIC X(01) VALUE SPACES.         
           05  MED-CERT-XFER-IND-1243   PIC X(01) VALUE SPACES.         
           05  NAME-FORMAT-1243         PIC X(01) VALUE SPACES.         
           05  FIRST-NAME-1243          PIC X(15) VALUE SPACES.         
           05  MIDDLE-NAME-1243         PIC X(15) VALUE SPACES.         
           05  LAST-NAME-1243           PIC X(40) VALUE SPACES.         
           05  FULL-NAME-1243           PIC X(70) VALUE SPACES.         
           05  HOUSE-NO-1243            PIC X(15) VALUE SPACES.         
           05  ADDR-PREFIX-1-1243       PIC X(03) VALUE SPACES.         
           05  ADDR-PREFIX-2-1243       PIC X(02) VALUE SPACES.         
           05  STREET-NAME-1243         PIC X(30) VALUE SPACES.         
           05  STREET-LOCATION-1-1243   PIC X(04) VALUE SPACES.         
           05  STREET-LOCATION-2-1243   PIC X(11) VALUE SPACES.         
           05  STREET-SUFFIX-1243       PIC X(04) VALUE SPACES.         
           05  CUSTOMER-FROM-1243       PIC S9(10)V COMP-3 VALUE 0.     
                                                                        
      ******************************************************************        
      * CSR00181 - GET DATA FROM SO_CNTRCT_XFER FOR EXISTING ORDER     *        
      ******************************************************************        
                                                                        
       01  CSR00181-CALL-DATA.                                          
           03  TO-ACCOUNT-NO-0181       PIC X(13) VALUE SPACES.         
           03  SERV-ORDER-NO-0181       PIC X(13) VALUE SPACES.         
                                                                        
       01  CSR00181-RETURN-DATA.                                        
           05  RETURN-CODE-0181         PIC S9(09) COMP VALUE 0.        
           05  CONTRACT-ID-0181         PIC S9(09) COMP VALUE 0.        
                                                                        
      ******************************************************************        
      * CSR01204 - GET DATA FROM SO_FINAL_BILL FOR EXISTING ORDER      *        
      ******************************************************************        
                                                                        
       01  CSR01204-CALL-DATA.                                          
           03  SERV-ORDER-NO-1204       PIC X(13) VALUE SPACES.         
           03  CURRENT-HISTORY-FL-1204  PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR01204-RETURN-DATA.                                        
            05 RETURN-CODE-1204         PIC S9(09) COMP VALUE 0.        
            05 ACCOUNT-NO-PRIOR-1204    PIC X(13) VALUE SPACES.         
            05 SERV-ORDER-NO-R-1204     PIC X(13) VALUE SPACES.         
            05 WANTED-BY-DATETIME-1204  PIC X(26) VALUE SPACES.         
            05 CREDIT-LETTER-IND-1204   PIC X(01) VALUE SPACES.         
            05 STREET-LOCATION-1-1204   PIC X(04) VALUE SPACES.         
            05 STREET-LOCATION-2-1204   PIC X(11) VALUE SPACES.         
            05 ADDR-ST-1204             PIC X(55) VALUE SPACES.         
            05 ADDR-ZIP-CODE-1204       PIC X(09) VALUE SPACES.         
            05 ADDR-PREFIX-1-1204       PIC X(03) VALUE SPACES.         
            05 ADDR-PREFIX-2-1204       PIC X(02) VALUE SPACES.         
            05 ADDR-SUFFIX-1204         PIC X(02) VALUE SPACES.         
            05 ADDRESS-OVERFLOW-1204    PIC X(35) VALUE SPACES.         
            05 HOUSE-NO-1204            PIC X(15) VALUE SPACES.         
            05 ADDRESS-FORMAT-1204      PIC X(01) VALUE SPACES.         
            05 STREET-NAME-1204         PIC X(30) VALUE SPACES.         
            05 STREET-SUFFIX-1204       PIC X(04) VALUE SPACES.         
            05 ZIP-CODE-1204            PIC X(05) VALUE SPACES.         
            05 ZIP-CODE-PLUS-FOUR-1204  PIC X(04) VALUE SPACES.         
            05 ZIP-CODE-TOKEN-1204      PIC X(01) VALUE SPACES.         
            05 SEND-TO-LOCOFF-IND-1204  PIC X(01) VALUE SPACES.         
            05 ADDR-COUNTRY-1204        PIC X(35) VALUE SPACES.         
            05 CARRIER-ROUTE-1204       PIC X(05) VALUE SPACES.         
            05 FINAL-BILL-CY-ST-1204    PIC X(30) VALUE SPACES.         
            05 FINAL-BILL-OVFL-1204     PIC X(35) VALUE SPACES.         
            05 DEPOSIT-AMT-1204         PIC S9(9)V9(2) COMP-3           
                                                     VALUE 0.           
                                                                        
      ******************************************************************        
      * CSR04747 - CHECK IF CLICK AND GET WORK DISTRICT                *        
      ******************************************************************        
                                                                        
       01  CSR04747-CALL-DATA.                                          
           03  SERV-ORDER-NO-4747       PIC X(13) VALUE SPACES.         
           03  PRIORITY-4747            PIC X(01) VALUE SPACES.         
           03  ACTION-CD-4747           PIC X(01) VALUE SPACES.         
           03  USER-ID-4747             PIC X(07) VALUE SPACES.         
           03  WORK-DISTRICT-IN-4747    PIC X(40) VALUE SPACES.         
                                                                        
       01  CSR04747-RETURN-DATA.                                        
           05  RETURN-CODE-4747          PIC S9(9) COMP VALUE 0.        
           05  WORK-DISTRICT-OUT-4747    PIC X(40) VALUE SPACES.        
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *01 LOC2364 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1105 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4747 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1243 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC1204 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC0181 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
              DECLARE CONTACT-CURSOR CURSOR FOR                         
              SELECT NAME_TYPE,                                         
                     CONTACT_TYPE                                       
              FROM CSS_SO_CONT_MATRIX WITH(READUNCOMMITTED)                     
             WHERE COMPANY_NO = :3C-COMPANY-NO                          
               AND ORDER_TYPE_CD = :3C-ORDER-TYPE-CD                    
             FOR READ ONLY                                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CONTACT-CURSOR CURSOR FOR                                 
MFA-TR*       SELECT NAME_TYPE,                                                 
MFA-TR*              CONTACT_TYPE                                               
MFA-TR*       FROM CSS_SO_CONT_MATRIX                                           
MFA-TR*      WHERE COMPANY_NO = :3C-COMPANY-NO                                  
MFA-TR*        AND ORDER_TYPE_CD = :3C-ORDER-TYPE-CD                            
MFA-TR*      FOR FETCH ONLY                                                     
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7030                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE COAPP-CURSOR CURSOR FOR                           
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(FIRST_NAME) + ' ' + RTRIM(
           MIDDLE_NAME),                               
                      FULL_NAME,                                        
                      NAME_FORMAT                                       
                 FROM CSS_COAPPLICANT IC WITH(READUNCOMMITTED),                 
                      CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_CUSTOMER CU WITH(READUNCOMMITTED)                     
                WHERE IC.ACCOUNT_NO = :IC-ACCOUNT-NO                    
                  AND IC.CUSTOMER_NO = CU.CUSTOMER_NO                   
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE COAPP-CURSOR CURSOR FOR                                   
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT                                               
MFA-TR*          FROM CSS_COAPPLICANT IC,                                       
MFA-TR*               CSS_NAME DQ,                                              
MFA-TR*               CSS_CUSTOMER CU                                           
MFA-TR*         WHERE IC.ACCOUNT_NO = :IC-ACCOUNT-NO                            
MFA-TR*           AND IC.CUSTOMER_NO = CU.CUSTOMER_NO                           
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE PA-CURSOR CURSOR FOR                              
              SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(TITLE_SUFFIX_1
           )) + ', ' + RTRIM(FIRST_NAME) + ' ' + RTRIM(MIDDLE_NAME),           
                     FULL_NAME,                                         
                     NAME_FORMAT                                        
                FROM CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                 
                     CSS_CONTACT CV WITH(READUNCOMMITTED),                      
                     CSS_NAME DQ WITH(READUNCOMMITTED)                          
               WHERE DT.CUSTOMER_NO = :AT-CUSTOMER-NO                   
                  AND DT.CONTACT_ID = CV.CONTACT_ID                     
                  AND CV.NAME_ID = DQ.NAME_ID                           
                  AND CONTACT_TYPE = 'PA'                               
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PA-CURSOR CURSOR FOR                                      
MFA-TR*       SELECT RTRIM(RTRIM(LAST_NAME) ||                                  
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(TITLE_SUFFIX_1)) ||                                  
MFA-TR*              ', ' ||                                                    
MFA-TR*              RTRIM(FIRST_NAME) ||                                       
MFA-TR*              ' ' ||                                                     
MFA-TR*              RTRIM(MIDDLE_NAME),                                        
MFA-TR*              FULL_NAME,                                                 
MFA-TR*              NAME_FORMAT                                                
MFA-TR*         FROM CSS_CONTACT_CUST DT,                                       
MFA-TR*              CSS_CONTACT CV,                                            
MFA-TR*              CSS_NAME DQ                                                
MFA-TR*        WHERE DT.CUSTOMER_NO = :AT-CUSTOMER-NO                           
MFA-TR*           AND DT.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE = 'PA'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE MP-CURSOR CURSOR FOR                              
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(FIRST_NAME) + ' ' + RTRIM(
           MIDDLE_NAME),                               
                      FULL_NAME,                                        
                      NAME_FORMAT                                       
                 FROM CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                
                      CSS_CONTACT CV WITH(READUNCOMMITTED),                     
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE DT.CUSTOMER_NO = :AT-CUSTOMER-NO                  
                  AND DT.CONTACT_ID = CV.CONTACT_ID                     
                  AND CV.NAME_ID = DQ.NAME_ID                           
                  AND CONTACT_TYPE = 'MP'                               
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MP-CURSOR CURSOR FOR                                      
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT                                               
MFA-TR*          FROM CSS_CONTACT_CUST DT,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DT.CUSTOMER_NO = :AT-CUSTOMER-NO                          
MFA-TR*           AND DT.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE = 'MP'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7450                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE TA-CURSOR CURSOR FOR                              
               SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(FIRST_NAME) + ' ' + RTRIM(
           MIDDLE_NAME),                               
                      FULL_NAME,                                        
                      NAME_FORMAT                                       
                 FROM CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                
                      CSS_CONTACT CV WITH(READUNCOMMITTED),                     
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE DT.CUSTOMER_NO = :AT-CUSTOMER-NO                  
                  AND DT.CONTACT_ID = CV.CONTACT_ID                     
                  AND CV.NAME_ID = DQ.NAME_ID                           
                  AND CONTACT_TYPE = 'TA'                               
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TA-CURSOR CURSOR FOR                                      
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT                                               
MFA-TR*          FROM CSS_CONTACT_CUST DT,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DT.CUSTOMER_NO = :AT-CUSTOMER-NO                          
MFA-TR*           AND DT.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND CONTACT_TYPE = 'TA'                                       
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
P00795*    GETS ALL THE CONTACTS FOR THE CUSTOMER                               
P00795     EXEC SQL                                                     
P00795        DECLARE ALL-CONTACTS-CURSOR CURSOR FOR                    
P00795         SELECT RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(FIRST_NAME) + ' ' + RTRIM(
           MIDDLE_NAME),                               
P00795                FULL_NAME,                                        
P00795                NAME_FORMAT,                                      
P00795                CV.CONTACT_TYPE                                   
P00795           FROM CSS_CONTACT_CUST DT WITH(READUNCOMMITTED),                
P00795                CSS_CONTACT CV WITH(READUNCOMMITTED),                     
P00795                CSS_NAME DQ WITH(READUNCOMMITTED)                         
P00795          WHERE DT.CUSTOMER_NO = :AT-CUSTOMER-NO                  
P00795            AND DT.CONTACT_ID = CV.CONTACT_ID                     
P00795            AND CV.NAME_ID = DQ.NAME_ID                           
P00795            AND NOT (CV.CONTACT_TYPE  = 'RR'                      
P00795                 AND CV.CONTACT_ORDER = 0)                        
P00795                                                           
P00795          FOR READ ONLY                                          
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ALL-CONTACTS-CURSOR CURSOR FOR                            
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT,                                              
MFA-TR*               CV.CONTACT_TYPE                                           
MFA-TR*          FROM CSS_CONTACT_CUST DT,                                      
MFA-TR*               CSS_CONTACT CV,                                           
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE DT.CUSTOMER_NO = :AT-CUSTOMER-NO                          
MFA-TR*           AND DT.CONTACT_ID = CV.CONTACT_ID                             
MFA-TR*           AND CV.NAME_ID = DQ.NAME_ID                                   
MFA-TR*           AND NOT (CV.CONTACT_TYPE  = 'RR'                              
MFA-TR*                AND CV.CONTACT_ORDER = 0)                                
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH REMARKS                                   
      ******************************************************************        
                                                                        
MAINTN     EXEC SQL                                                     
MAINTN         DECLARE SO-REMARKS-CSR CURSOR FOR                        
MAINTN          SELECT EF.SERV_ORDER_NO                                 
MAINTN                ,EF.REMARK_TYPE_CD                                
MAINTN                ,EF.REMARK_TX                                     
MAINTN            FROM CSS_SO_REMARKS EF WITH(READUNCOMMITTED)                  
MAINTN           WHERE EF.SERV_ORDER_NO      = :EF-SERV-ORDER-NO        
MAINTN             AND EF.REMARK_TYPE_CD IN ('G','H','C','A')           
MAINTN             AND EF.REMARK_DATETIME =                             
MAINTN                 (SELECT MAX(R1.REMARK_DATETIME)                  
MAINTN                    FROM CSS_SO_REMARKS R1 WITH(READUNCOMMITTED)          
MAINTN                   WHERE R1.SERV_ORDER_NO  = EF.SERV_ORDER_NO     
MAINTN                     AND R1.REMARK_TYPE_CD =EF.REMARK_TYPE_CD)    
MAINTN             FOR READ ONLY                                
MAINTN                                                      
MAINTN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SO-REMARKS-CSR CURSOR FOR                                
MFA-TR*         SELECT EF.SERV_ORDER_NO                                         
MFA-TR*               ,EF.REMARK_TYPE_CD                                        
MFA-TR*               ,EF.REMARK_TX                                             
MFA-TR*           FROM CSS_SO_REMARKS EF                                        
MFA-TR*          WHERE EF.SERV_ORDER_NO      = :EF-SERV-ORDER-NO                
MFA-TR*            AND EF.REMARK_TYPE_CD IN ('G','H','C','A')                   
MFA-TR*            AND EF.REMARK_DATETIME =                                     
MFA-TR*                (SELECT MAX(R1.REMARK_DATETIME)                          
MFA-TR*                   FROM CSS_SO_REMARKS R1                                
MFA-TR*                  WHERE R1.SERV_ORDER_NO  = EF.SERV_ORDER_NO             
MFA-TR*                    AND R1.REMARK_TYPE_CD =EF.REMARK_TYPE_CD)            
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
MAINTN                                                                  
MAINTN******************************************************************        
MAINTN*   CURSOR DECLARATION TO FETCH HST REMARKS                               
MAINTN******************************************************************        
MAINTN                                                                  
MAINTN     EXEC SQL                                                     
MAINTN         DECLARE HST-SO-REMARKS-CSR CURSOR FOR                    
MAINTN          SELECT OE.SERV_ORDER_NO                                 
MAINTN                ,OE.REMARK_TYPE_CD                                
MAINTN                ,OE.REMARK_TX                                     
MAINTN            FROM HST_SO_REMARKS OE WITH(READUNCOMMITTED)                  
MAINTN           WHERE OE.SERV_ORDER_NO      = :OE-SERV-ORDER-NO        
MAINTN             AND OE.REMARK_TYPE_CD IN ('G','H','C','A')           
MAINTN             AND OE.REMARK_DATETIME =                             
MAINTN                 (SELECT MAX(R1.REMARK_DATETIME)                  
MAINTN                    FROM HST_SO_REMARKS R1 WITH(READUNCOMMITTED)          
MAINTN                   WHERE R1.SERV_ORDER_NO  = OE.SERV_ORDER_NO     
MAINTN                     AND R1.REMARK_TYPE_CD = OE.REMARK_TYPE_CD)   
MAINTN             FOR READ ONLY                                
MAINTN                                                      
MAINTN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE HST-SO-REMARKS-CSR CURSOR FOR                            
MFA-TR*         SELECT OE.SERV_ORDER_NO                                         
MFA-TR*               ,OE.REMARK_TYPE_CD                                        
MFA-TR*               ,OE.REMARK_TX                                             
MFA-TR*           FROM HST_SO_REMARKS OE                                        
MFA-TR*          WHERE OE.SERV_ORDER_NO      = :OE-SERV-ORDER-NO                
MFA-TR*            AND OE.REMARK_TYPE_CD IN ('G','H','C','A')                   
MFA-TR*            AND OE.REMARK_DATETIME =                                     
MFA-TR*                (SELECT MAX(R1.REMARK_DATETIME)                          
MFA-TR*                   FROM HST_SO_REMARKS R1                                
MFA-TR*                  WHERE R1.SERV_ORDER_NO  = OE.SERV_ORDER_NO             
MFA-TR*                    AND R1.REMARK_TYPE_CD = OE.REMARK_TYPE_CD)           
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE APPL-CURSOR CURSOR FOR                            
               SELECT EQUIPMENT_NO,                                     
                      LA.APPLIANCE_CD,                                  
                      CAUTION_TAG_IND,                                  
                      CUT_IND,                                          
                      TAG_NO,                                           
                      CONDITION_CD,                                     
                      LOCATION_CD,                                      
                      APPLIANCE_COMMENTS,                               
                      CAUTION_TAG_DT,                                   
                      SOURCE_SYSTEM_CD,                                 
                      INSTALL_DT,                                       
                      SERIAL_NO,                                        
                      CAD_VERIFY_DT,                                    
                      APPLIANCE_DESC,                                   
                      SEASONAL_RT_FL,                                   
                      CRAWL_FL,                                         
                      APPL_LONG_DESC,                                   
                      PRIMARY_FUEL_CD,                                  
                      AVERAGE_BTU                                       
                 FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                   
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :LA-PREMISE-NO                       
                  AND PRIMARY_FUEL_CD = 'NA-GAS'                        
                  AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                 
                  AND LA.COMPANY_NO = JA.COMPANY_NO                     
                  AND CIS_DISPLAY_FL = 'Y'                              
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE APPL-CURSOR CURSOR FOR                                    
MFA-TR*        SELECT EQUIPMENT_NO,                                             
MFA-TR*               LA.APPLIANCE_CD,                                          
MFA-TR*               CAUTION_TAG_IND,                                          
MFA-TR*               CUT_IND,                                                  
MFA-TR*               TAG_NO,                                                   
MFA-TR*               CONDITION_CD,                                             
MFA-TR*               LOCATION_CD,                                              
MFA-TR*               APPLIANCE_COMMENTS,                                       
MFA-TR*               CAUTION_TAG_DT,                                           
MFA-TR*               SOURCE_SYSTEM_CD,                                         
MFA-TR*               INSTALL_DT,                                               
MFA-TR*               SERIAL_NO,                                                
MFA-TR*               CAD_VERIFY_DT,                                            
MFA-TR*               APPLIANCE_DESC,                                           
MFA-TR*               SEASONAL_RT_FL,                                           
MFA-TR*               CRAWL_FL,                                                 
MFA-TR*               APPL_LONG_DESC,                                           
MFA-TR*               PRIMARY_FUEL_CD,                                          
MFA-TR*               AVERAGE_BTU                                               
MFA-TR*          FROM CSS_APPLIANCE LA,                                         
MFA-TR*               CSS_MKT_APPLIANCE JA                                      
MFA-TR*         WHERE PREMISE_NO = :LA-PREMISE-NO                               
MFA-TR*           AND PRIMARY_FUEL_CD = 'NA-GAS'                                
MFA-TR*           AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                         
MFA-TR*           AND LA.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
MAINTN     EXEC SQL                                                     
MAINTN        DECLARE CSS-SO-APPL-CURSOR CURSOR FOR                     
MAINTN         SELECT VQ.EQUIPMENT_UNQ,                                 
MAINTN                VQ.APPLIANCE_CD,                                  
MAINTN                VQ.CAUTION_TAG_IND,                               
MAINTN                LA.CUT_IND,                                       
MAINTN                LA.TAG_NO,                                        
MAINTN                LA.CONDITION_CD,                                  
MAINTN                LA.LOCATION_CD,                                   
MAINTN                LA.APPLIANCE_COMMENTS,                            
MAINTN                LA.CAUTION_TAG_DT,                                
MAINTN                LA.SOURCE_SYSTEM_CD,                              
MAINTN                REPLACE(REPLACE(CONVERT(CHAR(26), VQ.INSTALL_DT
           , 121), ' ', '-'), ':', '.') INSTALL_DT,                            
MAINTN                LA.SERIAL_NO,                                     
MAINTN                LA.CAD_VERIFY_DT,                                 
MAINTN                JA.APPLIANCE_DESC,                                
MAINTN                JA.SEASONAL_RT_FL,                                
MAINTN                JA.CRAWL_FL,                                      
MAINTN                JA.APPL_LONG_DESC,                                
MAINTN                LA.PRIMARY_FUEL_CD,                               
MAINTN                JA.AVERAGE_BTU,                                   
MAINTN                VQ.LEAK_IND,                                      
MAINTN                VQ.LIGHT_IND,                                     
MAINTN                VQ.REPAIR_IND,                                    
MAINTN                VQ.CUTOFF_IND,                                    
MAINTN                VQ.REPLACE_APP_FL                                 
MAINTN           FROM CSS_SO_APPLIANCE VQ WITH(READUNCOMMITTED)                 
MAINTN                JOIN CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)           
MAINTN                 ON JA.APPLIANCE_CD = VQ.APPLIANCE_CD             
MAINTN                JOIN CSS_SO_DATA VO WITH(READUNCOMMITTED)                 
MAINTN                 ON VO.SERV_ORDER_NO = VQ.SERV_ORDER_NO           
MAINTN                LEFT OUTER JOIN CSS_APPLIANCE LA
                           WITH(READUNCOMMITTED)                  
MAINTN                 ON LA.EQUIPMENT_NO = VQ.EQUIPMENT_UNQ            
MAINTN          WHERE VQ.SERV_ORDER_NO = :VQ-SERV-ORDER-NO              
MAINTN            AND VO.COMPANY_NO = JA.COMPANY_NO                     
MAINTN            AND CIS_DISPLAY_FL = 'Y'                              
MAINTN                                                           
MAINTN          FOR READ ONLY                                          
MAINTN                                                      
MAINTN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CSS-SO-APPL-CURSOR CURSOR FOR                             
MFA-TR*        SELECT VQ.EQUIPMENT_UNQ,                                         
MFA-TR*               VQ.APPLIANCE_CD,                                          
MFA-TR*               VQ.CAUTION_TAG_IND,                                       
MFA-TR*               LA.CUT_IND,                                               
MFA-TR*               LA.TAG_NO,                                                
MFA-TR*               LA.CONDITION_CD,                                          
MFA-TR*               LA.LOCATION_CD,                                           
MFA-TR*               LA.APPLIANCE_COMMENTS,                                    
MFA-TR*               LA.CAUTION_TAG_DT,                                        
MFA-TR*               LA.SOURCE_SYSTEM_CD,                                      
MFA-TR*               VQ.INSTALL_DT,                                            
MFA-TR*               LA.SERIAL_NO,                                             
MFA-TR*               LA.CAD_VERIFY_DT,                                         
MFA-TR*               JA.APPLIANCE_DESC,                                        
MFA-TR*               JA.SEASONAL_RT_FL,                                        
MFA-TR*               JA.CRAWL_FL,                                              
MFA-TR*               JA.APPL_LONG_DESC,                                        
MFA-TR*               LA.PRIMARY_FUEL_CD,                                       
MFA-TR*               JA.AVERAGE_BTU,                                           
MFA-TR*               VQ.LEAK_IND,                                              
MFA-TR*               VQ.LIGHT_IND,                                             
MFA-TR*               VQ.REPAIR_IND,                                            
MFA-TR*               VQ.CUTOFF_IND,                                            
MFA-TR*               VQ.REPLACE_APP_FL                                         
MFA-TR*          FROM CSS_SO_APPLIANCE VQ                                       
MFA-TR*               JOIN CSS_MKT_APPLIANCE JA                                 
MFA-TR*                ON JA.APPLIANCE_CD = VQ.APPLIANCE_CD                     
MFA-TR*               JOIN CSS_SO_DATA VO                                       
MFA-TR*                ON VO.SERV_ORDER_NO = VQ.SERV_ORDER_NO                   
MFA-TR*               LEFT OUTER JOIN CSS_APPLIANCE LA                          
MFA-TR*                ON LA.EQUIPMENT_NO = VQ.EQUIPMENT_UNQ                    
MFA-TR*         WHERE VQ.SERV_ORDER_NO = :VQ-SERV-ORDER-NO                      
MFA-TR*           AND VO.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            
MAINTN*                                                                         
MAINTN     EXEC SQL                                                     
MAINTN        DECLARE HST-SO-APPL-CURSOR CURSOR FOR                     
MAINTN         SELECT XZ.EQUIPMENT_UNQ,                                 
MAINTN                XZ.APPLIANCE_CD,                                  
MAINTN                XZ.CAUTION_TAG_IND,                               
MAINTN                LA.CUT_IND,                                       
MAINTN                LA.TAG_NO,                                        
MAINTN                LA.CONDITION_CD,                                  
MAINTN                LA.LOCATION_CD,                                   
MAINTN                LA.APPLIANCE_COMMENTS,                            
MAINTN                LA.CAUTION_TAG_DT,                                
MAINTN                LA.SOURCE_SYSTEM_CD,                              
MAINTN                REPLACE(REPLACE(CONVERT(CHAR(26), XZ.INSTALL_DT
           , 121), ' ', '-'), ':', '.') INSTALL_DT,                            
MAINTN                LA.SERIAL_NO,                                     
MAINTN                LA.CAD_VERIFY_DT,                                 
MAINTN                JA.APPLIANCE_DESC,                                
MAINTN                JA.SEASONAL_RT_FL,                                
MAINTN                JA.CRAWL_FL,                                      
MAINTN                JA.APPL_LONG_DESC,                                
MAINTN                LA.PRIMARY_FUEL_CD,                               
MAINTN                JA.AVERAGE_BTU,                                   
MAINTN                XZ.LEAK_IND,                                      
MAINTN                XZ.LIGHT_IND,                                     
MAINTN                XZ.REPAIR_IND,                                    
MAINTN                XZ.CUTOFF_IND,                                    
MAINTN                XZ.REPLACE_APP_FL                                 
MAINTN           FROM HST_SO_APPLIANCE XZ WITH(READUNCOMMITTED)                 
MAINTN                JOIN CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)           
MAINTN                 ON JA.APPLIANCE_CD = XZ.APPLIANCE_CD             
MAINTN                JOIN HST_SO_DATA   YV WITH(READUNCOMMITTED)               
MAINTN                 ON YV.SERV_ORDER_NO = XZ.SERV_ORDER_NO           
MAINTN                LEFT OUTER JOIN CSS_APPLIANCE LA
                           WITH(READUNCOMMITTED)                  
MAINTN                 ON LA.EQUIPMENT_NO = XZ.EQUIPMENT_UNQ            
MAINTN          WHERE XZ.SERV_ORDER_NO = :XZ-SERV-ORDER-NO              
MAINTN            AND YV.COMPANY_NO = JA.COMPANY_NO                     
MAINTN            AND CIS_DISPLAY_FL = 'Y'                              
MAINTN                                                           
MAINTN          FOR READ ONLY                                          
MAINTN                                                      
MAINTN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE HST-SO-APPL-CURSOR CURSOR FOR                             
MFA-TR*        SELECT XZ.EQUIPMENT_UNQ,                                         
MFA-TR*               XZ.APPLIANCE_CD,                                          
MFA-TR*               XZ.CAUTION_TAG_IND,                                       
MFA-TR*               LA.CUT_IND,                                               
MFA-TR*               LA.TAG_NO,                                                
MFA-TR*               LA.CONDITION_CD,                                          
MFA-TR*               LA.LOCATION_CD,                                           
MFA-TR*               LA.APPLIANCE_COMMENTS,                                    
MFA-TR*               LA.CAUTION_TAG_DT,                                        
MFA-TR*               LA.SOURCE_SYSTEM_CD,                                      
MFA-TR*               XZ.INSTALL_DT,                                            
MFA-TR*               LA.SERIAL_NO,                                             
MFA-TR*               LA.CAD_VERIFY_DT,                                         
MFA-TR*               JA.APPLIANCE_DESC,                                        
MFA-TR*               JA.SEASONAL_RT_FL,                                        
MFA-TR*               JA.CRAWL_FL,                                              
MFA-TR*               JA.APPL_LONG_DESC,                                        
MFA-TR*               LA.PRIMARY_FUEL_CD,                                       
MFA-TR*               JA.AVERAGE_BTU,                                           
MFA-TR*               XZ.LEAK_IND,                                              
MFA-TR*               XZ.LIGHT_IND,                                             
MFA-TR*               XZ.REPAIR_IND,                                            
MFA-TR*               XZ.CUTOFF_IND,                                            
MFA-TR*               XZ.REPLACE_APP_FL                                         
MFA-TR*          FROM HST_SO_APPLIANCE XZ                                       
MFA-TR*               JOIN CSS_MKT_APPLIANCE JA                                 
MFA-TR*                ON JA.APPLIANCE_CD = XZ.APPLIANCE_CD                     
MFA-TR*               JOIN HST_SO_DATA   YV                                     
MFA-TR*                ON YV.SERV_ORDER_NO = XZ.SERV_ORDER_NO                   
MFA-TR*               LEFT OUTER JOIN CSS_APPLIANCE LA                          
MFA-TR*                ON LA.EQUIPMENT_NO = XZ.EQUIPMENT_UNQ                    
MFA-TR*         WHERE XZ.SERV_ORDER_NO = :XZ-SERV-ORDER-NO                      
MFA-TR*           AND YV.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 NAME_TYPE            AS NAME_TYPE,                     
                 CONTACT_TYPE         AS CONTACT_TYPE,                  
                 MATRIX_NAME          AS MATRIX_NAME                    
              FROM #CSR04478_R2                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          NAME_TYPE            AS NAME_TYPE,                             
MFA-TR*          CONTACT_TYPE         AS CONTACT_TYPE,                          
MFA-TR*          MATRIX_NAME          AS MATRIX_NAME                            
MFA-TR*       FROM SESSION.CSR04478_R2                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N2 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-NAME-TYPE         AS NAME_TYPE,                
                      :S-CONTACT-TYPE      AS CONTACT_TYPE,             
                      :S-MATRIX-NAME       AS MATRIX_NAME               
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N2 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-NAME-TYPE         AS NAME_TYPE,                        
MFA-TR*               :S-CONTACT-TYPE      AS CONTACT_TYPE,                     
MFA-TR*               :S-MATRIX-NAME       AS MATRIX_NAME                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 EQUIPMENT_NO         AS EQUIPMENT_NO,                  
                 APPLIANCE_CD         AS APPLIANCE_CD,                  
                 CAUTION_TAG_IND      AS CAUTION_TAG_IND,               
                 CUT_IND              AS CUT_IND,                       
                 TAG_NO               AS TAG_NO,                        
                 CONDITION_CD         AS CONDITION_CD,                  
                 LOCATION_CD          AS LOCATION_CD,                   
                 APPL_COMMENTS        AS APPL_COMMENTS,                 
                 CAUTION_TAG_DT       AS CAUTION_TAG_DT,                
                 SOURCE_SYSTEM_CD     AS SOURCE_SYSTEM_CD,              
                 INSTALL_DT           AS INSTALL_DT,                    
                 SERIAL_NO            AS SERIAL_NO,                     
                 CAD_VERIFY_DT        AS CAD_VERIFY_DT,                 
                 APPLIANCE_DESC       AS APPLIANCE_DESC,                
                 SEASONAL_RT_FL       AS SEASONAL_RT_FL,                
                 CRAWL_FL             AS CRAWL_FL,                      
                 APPL_LONG_DESC       AS APPL_LONG_DESC,                
                 PRIMARY_FUEL_CD      AS PRIMARY_FUEL_CD,               
                 AVERAGE_BTU          AS AVERAGE_BTU,                   
                 LEAK_IND             AS LEAK_IND,                      
                 LIGHT_IND            AS LIGHT_IND,                     
                 REPAIR_IND           AS REPAIR_IND,                    
                 CUTOFF_IND           AS CUTOFF_IND,                    
                 REPLACE_APP_FL       AS REPLACE_APP_FL                 
              FROM #CSR04478_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          EQUIPMENT_NO         AS EQUIPMENT_NO,                          
MFA-TR*          APPLIANCE_CD         AS APPLIANCE_CD,                          
MFA-TR*          CAUTION_TAG_IND      AS CAUTION_TAG_IND,                       
MFA-TR*          CUT_IND              AS CUT_IND,                               
MFA-TR*          TAG_NO               AS TAG_NO,                                
MFA-TR*          CONDITION_CD         AS CONDITION_CD,                          
MFA-TR*          LOCATION_CD          AS LOCATION_CD,                           
MFA-TR*          APPL_COMMENTS        AS APPL_COMMENTS,                         
MFA-TR*          CAUTION_TAG_DT       AS CAUTION_TAG_DT,                        
MFA-TR*          SOURCE_SYSTEM_CD     AS SOURCE_SYSTEM_CD,                      
MFA-TR*          INSTALL_DT           AS INSTALL_DT,                            
MFA-TR*          SERIAL_NO            AS SERIAL_NO,                             
MFA-TR*          CAD_VERIFY_DT        AS CAD_VERIFY_DT,                         
MFA-TR*          APPLIANCE_DESC       AS APPLIANCE_DESC,                        
MFA-TR*          SEASONAL_RT_FL       AS SEASONAL_RT_FL,                        
MFA-TR*          CRAWL_FL             AS CRAWL_FL,                              
MFA-TR*          APPL_LONG_DESC       AS APPL_LONG_DESC,                        
MFA-TR*          PRIMARY_FUEL_CD      AS PRIMARY_FUEL_CD,                       
MFA-TR*          AVERAGE_BTU          AS AVERAGE_BTU,                           
MFA-TR*          LEAK_IND             AS LEAK_IND,                              
MFA-TR*          LIGHT_IND            AS LIGHT_IND,                             
MFA-TR*          REPAIR_IND           AS REPAIR_IND,                            
MFA-TR*          CUTOFF_IND           AS CUTOFF_IND,                            
MFA-TR*          REPLACE_APP_FL       AS REPLACE_APP_FL                         
MFA-TR*       FROM SESSION.CSR04478_R3                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3     AS RETURN_CODE,              
                      :S-EQUIPMENT-NO      AS EQUIPMENT_NO,             
                      :S-APPLIANCE-CD      AS APPLIANCE_CD,             
                      :S-CAUTION-TAG-IND   AS CAUTION_TAG_IND,          
                      :S-CUT-IND           AS CUT_IND,                  
                      :S-TAG-NO            AS TAG_NO,                   
                      :S-CONDITION-CD      AS CONDITION_CD,             
                      :S-LOCATION-CD       AS LOCATION_CD,              
                      :S-APPL-COMMENTS     AS APPL_COMMENTS,            
                      :S-CAUTION-TAG-DT    AS CAUTION_TAG_DT,           
                      :S-SOURCE-SYSTEM-CD-3  AS SOURCE_SYSTEM_CD,       
                      :S-INSTALL-DT        AS INSTALL_DT,               
                      :S-SERIAL-NO         AS SERIAL_NO,                
                      :S-CAD-VERIFY-DT     AS CAD_VERIFY_DT,            
                      :S-APPLIANCE-DESC    AS APPLIANCE_DESC,           
                      :S-SEASONAL-RT-FL    AS SEASONAL_RT_FL,           
                      :S-CRAWL-FL          AS CRAWL_FL,                 
                      :S-APPL-LONG-DESC    AS APPL_LONG_DESC,           
                      :S-PRIMARY-FUEL-CD   AS PRIMARY_FUEL_CD,          
                      :S-AVERAGE-BTU       AS AVERAGE_BTU,              
                      :S-LEAK-IND          AS LEAK_IND,                 
                      :S-LIGHT-IND         AS LIGHT_IND,                
                      :S-REPAIR-IND        AS REPAIR_IND,               
                      :S-CUTOFF-IND        AS CUTOFF_IND,               
                      :S-REPLACE-APP-FL    AS REPLACE_APP_FL            
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3     AS RETURN_CODE,                      
MFA-TR*               :S-EQUIPMENT-NO      AS EQUIPMENT_NO,                     
MFA-TR*               :S-APPLIANCE-CD      AS APPLIANCE_CD,                     
MFA-TR*               :S-CAUTION-TAG-IND   AS CAUTION_TAG_IND,                  
MFA-TR*               :S-CUT-IND           AS CUT_IND,                          
MFA-TR*               :S-TAG-NO            AS TAG_NO,                           
MFA-TR*               :S-CONDITION-CD      AS CONDITION_CD,                     
MFA-TR*               :S-LOCATION-CD       AS LOCATION_CD,                      
MFA-TR*               :S-APPL-COMMENTS     AS APPL_COMMENTS,                    
MFA-TR*               :S-CAUTION-TAG-DT    AS CAUTION_TAG_DT,                   
MFA-TR*               :S-SOURCE-SYSTEM-CD-3  AS SOURCE_SYSTEM_CD,               
MFA-TR*               :S-INSTALL-DT        AS INSTALL_DT,                       
MFA-TR*               :S-SERIAL-NO         AS SERIAL_NO,                        
MFA-TR*               :S-CAD-VERIFY-DT     AS CAD_VERIFY_DT,                    
MFA-TR*               :S-APPLIANCE-DESC    AS APPLIANCE_DESC,                   
MFA-TR*               :S-SEASONAL-RT-FL    AS SEASONAL_RT_FL,                   
MFA-TR*               :S-CRAWL-FL          AS CRAWL_FL,                         
MFA-TR*               :S-APPL-LONG-DESC    AS APPL_LONG_DESC,                   
MFA-TR*               :S-PRIMARY-FUEL-CD   AS PRIMARY_FUEL_CD,                  
MFA-TR*               :S-AVERAGE-BTU       AS AVERAGE_BTU,                      
MFA-TR*               :S-LEAK-IND          AS LEAK_IND,                         
MFA-TR*               :S-LIGHT-IND         AS LIGHT_IND,                        
MFA-TR*               :S-REPAIR-IND        AS REPAIR_IND,                       
MFA-TR*               :S-CUTOFF-IND        AS CUTOFF_IND,                       
MFA-TR*               :S-REPLACE-APP-FL    AS REPLACE_APP_FL                    
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR  WITH ROWSET POSITIONING FOR
               SELECT :S-RETURN-CODE-4     AS RETURN_CODE,              
                      :S-ORDER-TYPE-CD-4    AS ORDER_TYPE_CD,           
                      :S-ORDER-REASON       AS ORDER_REASON,            
                      :S-STATUS-TX          AS STATUS_TX,               
                      :S-ORDER-STATE-CD     AS ORDER_STATE_CD,          
                      :S-ORDER-PLACED-BY    AS ORDER_PLACED_BY,         
                      :S-PHONE-NO           AS PHONE_NO,                
                      :S-PHONE-NO-EXT       AS PHONE_NO_EXT,            
                      :S-WANTED-BY-DATE     AS WANTED_BY_DATE,          
                      :S-ASSIGNED-DATE      AS ASSIGNED_DATE,           
                      :S-CALL-BEFORE-MINUTS AS CALL_BEFORE_MINUTS,      
                      :S-WORK-AREA-ID       AS WORK_AREA_ID,            
                      :S-BREAKERS-OFF-IND   AS BREAKERS_OFF_IND,        
                      :S-INIT-BY-CNTRCT-IND AS INIT_BY_CNTRCT_IND,      
                      :S-NOTIFY-CSR-IND     AS [NOTIFY-CSR_IND],          
                      :S-NOTIFY-CUST-IND    AS NOTIFY_CUST_IND,         
                      :S-ORDER-PRIORITY-CD  AS ORDER_PRIORITY_CD,       
                      :S-STD-LABOR-CHRG     AS STD_LABOR_CHRG,          
                      :S-WORK-TYPE-CD-4     AS WORK_TYPE_CD,            
                      :S-BACK-DATED-IND     AS BACK_DATED_IND,          
                      :S-DEPOSIT-AMT        AS DEPOSIT_AMT,             
                      :S-ORDER-RECVED-BY    AS ORDER_RECVED_BY,         
                      :S-VERIFY-RATE        AS VERIFY_RATE,             
                      :S-PREMISE-NO         AS PREMISE_NO,              
                      :S-ACCOUNT-NO         AS ACCOUNT_NO,              
                      :S-ACCOUNT-NO-PRIOR   AS ACCOUNT_NO_PRIOR,        
                      :S-BEGIN-APPT-DATE    AS BEGIN_APPT_DATE,         
                      :S-SO-EST-LABOR-HR    AS SO_EST_LABOR_HR,         
                      :S-CUSTCHG-ORD-TYPE-FL AS CUSTCHG_ORD_TYPE_FL,    
                      :S-AMOUNT-DISC-BAL    AS AMOUNT_DISC_BAL,         
                      :S-CURRENT-DATE       AS [CURRENT_DATE],            
                      :S-CODE-UTIL-TYPE-4   AS CODE_UTIL_TYPE,          
                      :S-PRICE-PER-SERV     AS PRICE_PER_SERV,          
                      :S-ACCOUNT-TYPE-DESC  AS ACCOUNT_TYPE_DESC,       
                      :S-ORDER-CHARGE-AMT   AS ORDER_CHARGE_AMT,        
                      :S-TOTAL-CHARGES-AMT  AS TOTAL_CHARGES_AMT,       
                      :S-CUST-CNT-ID        AS CUST_CNT_ID,             
                      :S-MTR-ACCESSIBLE-CD  AS MTR_ACCESSIBLE_CD,       
                      :S-MTR-ACCESSIBLE-DT  AS MTR_ACCESSIBLE_DT,       
                      :S-MTR-ACCESSIBLE-RSN AS MTR_ACCESSIBLE_RSN,      
                      :S-SOURCE-SYSTEM-CD-4   AS SOURCE_SYSTEM_CD,      
                      :S-ALT-PHONE-NO       AS ALT_PHONE_NO,            
                      :S-ALT-PHONE-NO-EXT   AS ALT_PHONE_NO_EXT,        
                      :S-HOME-ALL-DAY-FL    AS HOME_ALL_DAY_FL,         
                      :S-BUSINESS-UNIT      AS BUSINESS_UNIT,           
                      :S-OPTIMIZE-ORDER     AS OPTIMIZE_ORDER,          
                      :S-END-APPT-DATE      AS END_APPT_DATE,           
                      :S-APPT-AM-PM-CD      AS APPT_AM_PM_CD,           
                      :S-MTR-TURNOFF-RSN-CD AS MTR_TURNOFF_RSN_CD,      
                      :S-FUEL-CHNG-RSN-CD   AS FUEL_CHANGE_RSN_CD,      
                      :S-FUEL-CHNG-TYPE-CD  AS FUEL_CHANGE_TYPE_CD,     
                      :S-TURNOFF-COMMENTS   AS TURNOFF_COMMENTS,        
                      :S-WORK-DISTRICT      AS WORK_DISTRICT,           
                      :S-CODES-DATA-PRESENT AS CODES_DATA_PRESENT,      
                      :S-CANCEL-REASON-CD   AS CANCEL_REASON_CD,        
                      :S-SO-MTR-ROW-EXISTS  AS SO_METER_ROW_EXISTS      
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*        SELECT :S-RETURN-CODE-4     AS RETURN_CODE,                      
MFA-TR*               :S-ORDER-TYPE-CD-4    AS ORDER_TYPE_CD,                   
MFA-TR*               :S-ORDER-REASON       AS ORDER_REASON,                    
MFA-TR*               :S-STATUS-TX          AS STATUS_TX,                       
MFA-TR*               :S-ORDER-STATE-CD     AS ORDER_STATE_CD,                  
MFA-TR*               :S-ORDER-PLACED-BY    AS ORDER_PLACED_BY,                 
MFA-TR*               :S-PHONE-NO           AS PHONE_NO,                        
MFA-TR*               :S-PHONE-NO-EXT       AS PHONE_NO_EXT,                    
MFA-TR*               :S-WANTED-BY-DATE     AS WANTED_BY_DATE,                  
MFA-TR*               :S-ASSIGNED-DATE      AS ASSIGNED_DATE,                   
MFA-TR*               :S-CALL-BEFORE-MINUTS AS CALL_BEFORE_MINUTS,              
MFA-TR*               :S-WORK-AREA-ID       AS WORK_AREA_ID,                    
MFA-TR*               :S-BREAKERS-OFF-IND   AS BREAKERS_OFF_IND,                
MFA-TR*               :S-INIT-BY-CNTRCT-IND AS INIT_BY_CNTRCT_IND,              
MFA-TR*               :S-NOTIFY-CSR-IND     AS NOTIFY-CSR_IND,                  
MFA-TR*               :S-NOTIFY-CUST-IND    AS NOTIFY_CUST_IND,                 
MFA-TR*               :S-ORDER-PRIORITY-CD  AS ORDER_PRIORITY_CD,               
MFA-TR*               :S-STD-LABOR-CHRG     AS STD_LABOR_CHRG,                  
MFA-TR*               :S-WORK-TYPE-CD-4     AS WORK_TYPE_CD,                    
MFA-TR*               :S-BACK-DATED-IND     AS BACK_DATED_IND,                  
MFA-TR*               :S-DEPOSIT-AMT        AS DEPOSIT_AMT,                     
MFA-TR*               :S-ORDER-RECVED-BY    AS ORDER_RECVED_BY,                 
MFA-TR*               :S-VERIFY-RATE        AS VERIFY_RATE,                     
MFA-TR*               :S-PREMISE-NO         AS PREMISE_NO,                      
MFA-TR*               :S-ACCOUNT-NO         AS ACCOUNT_NO,                      
MFA-TR*               :S-ACCOUNT-NO-PRIOR   AS ACCOUNT_NO_PRIOR,                
MFA-TR*               :S-BEGIN-APPT-DATE    AS BEGIN_APPT_DATE,                 
MFA-TR*               :S-SO-EST-LABOR-HR    AS SO_EST_LABOR_HR,                 
MFA-TR*               :S-CUSTCHG-ORD-TYPE-FL AS CUSTCHG_ORD_TYPE_FL,            
MFA-TR*               :S-AMOUNT-DISC-BAL    AS AMOUNT_DISC_BAL,                 
MFA-TR*               :S-CURRENT-DATE       AS CURRENT_DATE,                    
MFA-TR*               :S-CODE-UTIL-TYPE-4   AS CODE_UTIL_TYPE,                  
MFA-TR*               :S-PRICE-PER-SERV     AS PRICE_PER_SERV,                  
MFA-TR*               :S-ACCOUNT-TYPE-DESC  AS ACCOUNT_TYPE_DESC,               
MFA-TR*               :S-ORDER-CHARGE-AMT   AS ORDER_CHARGE_AMT,                
MFA-TR*               :S-TOTAL-CHARGES-AMT  AS TOTAL_CHARGES_AMT,               
MFA-TR*               :S-CUST-CNT-ID        AS CUST_CNT_ID,                     
MFA-TR*               :S-MTR-ACCESSIBLE-CD  AS MTR_ACCESSIBLE_CD,               
MFA-TR*               :S-MTR-ACCESSIBLE-DT  AS MTR_ACCESSIBLE_DT,               
MFA-TR*               :S-MTR-ACCESSIBLE-RSN AS MTR_ACCESSIBLE_RSN,              
MFA-TR*               :S-SOURCE-SYSTEM-CD-4   AS SOURCE_SYSTEM_CD,              
MFA-TR*               :S-ALT-PHONE-NO       AS ALT_PHONE_NO,                    
MFA-TR*               :S-ALT-PHONE-NO-EXT   AS ALT_PHONE_NO_EXT,                
MFA-TR*               :S-HOME-ALL-DAY-FL    AS HOME_ALL_DAY_FL,                 
MFA-TR*               :S-BUSINESS-UNIT      AS BUSINESS_UNIT,                   
MFA-TR*               :S-OPTIMIZE-ORDER     AS OPTIMIZE_ORDER,                  
MFA-TR*               :S-END-APPT-DATE      AS END_APPT_DATE,                   
MFA-TR*               :S-APPT-AM-PM-CD      AS APPT_AM_PM_CD,                   
MFA-TR*               :S-MTR-TURNOFF-RSN-CD AS MTR_TURNOFF_RSN_CD,              
MFA-TR*               :S-FUEL-CHNG-RSN-CD   AS FUEL_CHANGE_RSN_CD,              
MFA-TR*               :S-FUEL-CHNG-TYPE-CD  AS FUEL_CHANGE_TYPE_CD,             
MFA-TR*               :S-TURNOFF-COMMENTS   AS TURNOFF_COMMENTS,                
MFA-TR*               :S-WORK-DISTRICT      AS WORK_DISTRICT,                   
MFA-TR*               :S-CODES-DATA-PRESENT AS CODES_DATA_PRESENT,              
MFA-TR*               :S-CANCEL-REASON-CD   AS CANCEL_REASON_CD,                
MFA-TR*               :S-SO-MTR-ROW-EXISTS  AS SO_METER_ROW_EXISTS              
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE              AS RETURN_CODE          
                      ,SERV_ORDER_NO            AS SERV_ORDER_NO        
                      ,LTRIM(RTRIM(REMARK_TYPE_CD))    AS REMARK_TYPE_CD       
                      ,LTRIM(RTRIM(REMARK_TX))         AS REMARK_TEXT          
                 FROM #CSR04478_R5                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE              AS RETURN_CODE                  
MFA-TR*               ,SERV_ORDER_NO            AS SERV_ORDER_NO                
MFA-TR*               ,STRIP(REMARK_TYPE_CD)    AS REMARK_TYPE_CD               
MFA-TR*               ,STRIP(REMARK_TX)         AS REMARK_TEXT                  
MFA-TR*          FROM SESSION.CSR04478_R5                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N5 CURSOR  FOR                         
                SELECT :S-RETURN-CODE-5          AS RETURN_CODE         
                      ,:S-SERV-ORDER-NO-5        AS SERV_ORDER_NO       
                      ,:S-REMARK-TYPE-CD         AS REMARK_TYPE_CD      
                      ,:S-REMARK-TX              AS REMARK_TEXT         
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N5 CURSOR WITH RETURN FOR                                 
MFA-TR*         SELECT :S-RETURN-CODE-5          AS RETURN_CODE                 
MFA-TR*               ,:S-SERV-ORDER-NO-5        AS SERV_ORDER_NO               
MFA-TR*               ,:S-REMARK-TYPE-CD         AS REMARK_TYPE_CD              
MFA-TR*               ,:S-REMARK-TX              AS REMARK_TEXT                 
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C6 CURSOR  WITH ROWSET POSITIONING FOR
               SELECT :S-RETURN-CODE-6        AS RETURN_CODE            
                     ,:S-TO-ACCT-NO-6         AS TO_ACCT_NO             
                     ,:S-ROOMMATE-XFER-IND-6  AS ROOMMATE_XFER_IND      
                     ,:S-EPP-XFER-IND-6       AS EPP_XFER_IND           
                     ,:S-DEPOSIT-XFER-IND-6   AS DEPOSIT_XFER_IND       
                     ,:S-OTHER-AR-XFER-IND-6  AS [OTHER-AR-XFER_IND]      
                     ,:S-PROJ-SHR-XFER-IND-6  AS PROJ_SHR_XFER_IND      
                     ,:S-WRITE-OFF-XFER-IND-6 AS WRITE_OFF_XFER_IND     
                     ,:S-IN-LIEU-XFER-IND-6   AS IN_LIEU_XFER_IND       
                     ,:S-WHT-CROSS-XFER-IND-6 AS WHT_CROSS_XFER_IND     
                     ,:S-COAPPL-XFER-IND-6    AS COAPPL_XFER_IND        
                     ,:S-MED-CERT-XFER-IND-6  AS MED_CERT_XFER_IND      
                     ,:S-NAME-FORMAT-6        AS NAME_FORMAT            
                     ,:S-FIRST-NAME-6         AS FIRST_NAME             
                     ,:S-MIDDLE-NAME-6        AS MIDDLE_NAME            
                     ,:S-LAST-NAME-6          AS LAST_NAME              
                     ,:S-FULL-NAME-6          AS FULL_NAME              
                     ,:S-HOUSE-NO-6           AS HOUSE_NO               
                     ,:S-ADDR-PREFIX-1-6      AS ADDR_PREFIX_1          
                     ,:S-ADDR-PREFIX-2-6      AS ADDR_PREFIX_2          
                     ,:S-STREET-NAME-6        AS STREET_NAME            
                     ,:S-STREET-LOCATION-1-6  AS STREET_LOCATION_1      
                     ,:S-STREET-LOCATION-2-6  AS STREET_LOCATION_2      
                     ,:S-STREET-SUFFIX-6      AS STREET_SUFFIX          
                     ,:S-CUSTOMER-FROM-6      AS CUSTOMER_FROM          
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C6 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*        SELECT :S-RETURN-CODE-6        AS RETURN_CODE                    
MFA-TR*              ,:S-TO-ACCT-NO-6         AS TO_ACCT_NO                     
MFA-TR*              ,:S-ROOMMATE-XFER-IND-6  AS ROOMMATE_XFER_IND              
MFA-TR*              ,:S-EPP-XFER-IND-6       AS EPP_XFER_IND                   
MFA-TR*              ,:S-DEPOSIT-XFER-IND-6   AS DEPOSIT_XFER_IND               
MFA-TR*              ,:S-OTHER-AR-XFER-IND-6  AS OTHER-AR-XFER_IND              
MFA-TR*              ,:S-PROJ-SHR-XFER-IND-6  AS PROJ_SHR_XFER_IND              
MFA-TR*              ,:S-WRITE-OFF-XFER-IND-6 AS WRITE_OFF_XFER_IND             
MFA-TR*              ,:S-IN-LIEU-XFER-IND-6   AS IN_LIEU_XFER_IND               
MFA-TR*              ,:S-WHT-CROSS-XFER-IND-6 AS WHT_CROSS_XFER_IND             
MFA-TR*              ,:S-COAPPL-XFER-IND-6    AS COAPPL_XFER_IND                
MFA-TR*              ,:S-MED-CERT-XFER-IND-6  AS MED_CERT_XFER_IND              
MFA-TR*              ,:S-NAME-FORMAT-6        AS NAME_FORMAT                    
MFA-TR*              ,:S-FIRST-NAME-6         AS FIRST_NAME                     
MFA-TR*              ,:S-MIDDLE-NAME-6        AS MIDDLE_NAME                    
MFA-TR*              ,:S-LAST-NAME-6          AS LAST_NAME                      
MFA-TR*              ,:S-FULL-NAME-6          AS FULL_NAME                      
MFA-TR*              ,:S-HOUSE-NO-6           AS HOUSE_NO                       
MFA-TR*              ,:S-ADDR-PREFIX-1-6      AS ADDR_PREFIX_1                  
MFA-TR*              ,:S-ADDR-PREFIX-2-6      AS ADDR_PREFIX_2                  
MFA-TR*              ,:S-STREET-NAME-6        AS STREET_NAME                    
MFA-TR*              ,:S-STREET-LOCATION-1-6  AS STREET_LOCATION_1              
MFA-TR*              ,:S-STREET-LOCATION-2-6  AS STREET_LOCATION_2              
MFA-TR*              ,:S-STREET-SUFFIX-6      AS STREET_SUFFIX                  
MFA-TR*              ,:S-CUSTOMER-FROM-6      AS CUSTOMER_FROM                  
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C7 CURSOR  WITH ROWSET POSITIONING FOR
               SELECT :S-RETURN-CODE-7        AS RETURN_CODE            
                     ,:S-ACCOUNT-NO-PRIOR-7   AS ACCOUNT_NO_PRIOR       
                     ,:S-SERV-ORDER-NO-7      AS SERV_ORDER_NO          
                     ,:S-WANTED-BY-DATETIME-7 AS WANTED_BY_DATETIME     
                     ,:S-CREDIT-LETTER-IND-7  AS CREDIT_LETTER_IND      
                     ,:S-STREET-LOCATION-1-7  AS STREET_LOCATION_1      
                     ,:S-STREET-LOCATION-2-7  AS STREET_LOCATION_2      
                     ,:S-ADDR-ST-7            AS ADDR_ST                
                     ,:S-ADDR-ZIP-CODE-7      AS ADDR_ZIP_CODE          
                     ,:S-ADDR-PREFIX-1-7      AS ADDR_PREFIX_1          
                     ,:S-ADDR-PREFIX-2-7      AS ADDR_PREFIX_2          
                     ,:S-ADDR-SUFFIX-7        AS ADDR_SUFFIX            
                     ,:S-ADDRESS-OVERFLOW-7   AS ADDRESS_OVERFLOW       
                     ,:S-HOUSE-NO-7           AS HOUSE_NO               
                     ,:S-ADDRESS-FORMAT-7     AS ADDRESS_FORMAT         
                     ,:S-STREET-NAME-7        AS STREET_NAME            
                     ,:S-STREET-SUFFIX-7      AS STREET_SUFFIX          
                     ,:S-ZIP-CODE-7           AS ZIP_CODE               
                     ,:S-ZIP-CODE-PLUS-FOUR-7 AS ZIP_CODE_PLUS_FOUR     
                     ,:S-ZIP-CODE-TOKEN-7     AS ZIP_CODE_TOKEN         
                     ,:S-SEND-TO-LOCOFF-IND-7 AS SEND_TO_LOCOFF_IND     
                     ,:S-ADDR-COUNTRY-7       AS ADDR_COUNTRY           
                     ,:S-CARRIER-ROUTE-7      AS CARRIER_ROUTE          
                     ,:S-FINAL-BILL-CY-ST-7   AS FINAL_BILL_CY_ST       
                     ,:S-FINAL-BILL-OVFL-7    AS FINAL_BILL_OVFL        
                     ,:S-DEPOSIT-AMT-7        AS DEPOSIT_AMT            
                     ,:S-FB-ADDR-TYPE-7       AS FB_ADDR_TYPE           
                     ,:S-FB-ADDR-LINE-7       AS FB_ADDR_LINE           
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C7 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*        SELECT :S-RETURN-CODE-7        AS RETURN_CODE                    
MFA-TR*              ,:S-ACCOUNT-NO-PRIOR-7   AS ACCOUNT_NO_PRIOR               
MFA-TR*              ,:S-SERV-ORDER-NO-7      AS SERV_ORDER_NO                  
MFA-TR*              ,:S-WANTED-BY-DATETIME-7 AS WANTED_BY_DATETIME             
MFA-TR*              ,:S-CREDIT-LETTER-IND-7  AS CREDIT_LETTER_IND              
MFA-TR*              ,:S-STREET-LOCATION-1-7  AS STREET_LOCATION_1              
MFA-TR*              ,:S-STREET-LOCATION-2-7  AS STREET_LOCATION_2              
MFA-TR*              ,:S-ADDR-ST-7            AS ADDR_ST                        
MFA-TR*              ,:S-ADDR-ZIP-CODE-7      AS ADDR_ZIP_CODE                  
MFA-TR*              ,:S-ADDR-PREFIX-1-7      AS ADDR_PREFIX_1                  
MFA-TR*              ,:S-ADDR-PREFIX-2-7      AS ADDR_PREFIX_2                  
MFA-TR*              ,:S-ADDR-SUFFIX-7        AS ADDR_SUFFIX                    
MFA-TR*              ,:S-ADDRESS-OVERFLOW-7   AS ADDRESS_OVERFLOW               
MFA-TR*              ,:S-HOUSE-NO-7           AS HOUSE_NO                       
MFA-TR*              ,:S-ADDRESS-FORMAT-7     AS ADDRESS_FORMAT                 
MFA-TR*              ,:S-STREET-NAME-7        AS STREET_NAME                    
MFA-TR*              ,:S-STREET-SUFFIX-7      AS STREET_SUFFIX                  
MFA-TR*              ,:S-ZIP-CODE-7           AS ZIP_CODE                       
MFA-TR*              ,:S-ZIP-CODE-PLUS-FOUR-7 AS ZIP_CODE_PLUS_FOUR             
MFA-TR*              ,:S-ZIP-CODE-TOKEN-7     AS ZIP_CODE_TOKEN                 
MFA-TR*              ,:S-SEND-TO-LOCOFF-IND-7 AS SEND_TO_LOCOFF_IND             
MFA-TR*              ,:S-ADDR-COUNTRY-7       AS ADDR_COUNTRY                   
MFA-TR*              ,:S-CARRIER-ROUTE-7      AS CARRIER_ROUTE                  
MFA-TR*              ,:S-FINAL-BILL-CY-ST-7   AS FINAL_BILL_CY_ST               
MFA-TR*              ,:S-FINAL-BILL-OVFL-7    AS FINAL_BILL_OVFL                
MFA-TR*              ,:S-DEPOSIT-AMT-7        AS DEPOSIT_AMT                    
MFA-TR*              ,:S-FB-ADDR-TYPE-7       AS FB_ADDR_TYPE                   
MFA-TR*              ,:S-FB-ADDR-LINE-7       AS FB_ADDR_LINE                   
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C8 CURSOR                              
                                 WITH ROWSET POSITIONING FOR            
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CONTRACT_ID          AS CONTRACT_ID                    
              FROM #CSR04478_R8                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C8 CURSOR WITH RETURN                                     
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CONTRACT_ID          AS CONTRACT_ID                            
MFA-TR*       FROM SESSION.CSR04478_R8                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N8 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-8     AS RETURN_CODE,              
                      :S-CONTRACT-ID-8     AS CONTRACT_ID               
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N8 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-8     AS RETURN_CODE,                      
MFA-TR*               :S-CONTRACT-ID-8     AS CONTRACT_ID                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1105 CURSOR
MSQ001          FOR CALL CSR01105                                             
                  ( :SERV-ORDER-NO-1105
                  , :CURRENT-HISTORY-FL-1105
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_CSR_4747 CURSOR
MSQ001          FOR CALL CSR04747 ( :SERV-ORDER-NO-4747
                  , :PRIORITY-4747
                  , :ACTION-CD-4747
                  , :USER-ID-4747
                  , :WORK-DISTRICT-IN-4747 OUTPUT
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1243 CURSOR
MSQ001          FOR CALL CSR01243                                             
                  ( :SERV-ORDER-NO-1243
                  , :CURRENT-HISTORY-FL-1243
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_0181 CURSOR
MSQ001          FOR CALL CSR00181                                             
                  ( :TO-ACCOUNT-NO-0181
                  , :SERV-ORDER-NO-0181
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_1204 CURSOR
MSQ001          FOR CALL CSR01204                                             
                  ( :SERV-ORDER-NO-1204
                  , :CURRENT-HISTORY-FL-1204
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-OLD-CUSTOMER-NO     PIC X(10).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-ORDER-TYPE-CD       PIC X(05).                          
       01  LINK-NEXT-BUS-DAY        PIC X(10).                          
       01  LINK-PROGRAM-ID          PIC X(08).                          
       01  LINK-NEW-CUSTOMER-NO     PIC X(10).                          
       01  LINK-XFER-FL             PIC X(01).                          
       01  LINK-XFER-FROM-ACCT      PIC X(13).                          
       01  LINK-REVERT-FL           PIC X(01).                          
MAINTN 01  LINK-SERV-ORDER-NO       PIC X(13).                          
MAINTN 01  LINK-CURRENT-HISTORY-FL  PIC X(01).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO,                       
                                 LINK-OLD-CUSTOMER-NO,                  
                                 LINK-PREMISE-NO,                       
                                 LINK-ORDER-TYPE-CD,                    
                                 LINK-NEXT-BUS-DAY,                     
                                 LINK-PROGRAM-ID,                       
                                 LINK-NEW-CUSTOMER-NO,                  
                                 LINK-XFER-FL,                          
                                 LINK-XFER-FROM-ACCT,                   
                                 LINK-REVERT-FL,                        
MAINTN                           LINK-SERV-ORDER-NO,                    
MAINTN                           LINK-CURRENT-HISTORY-FL.               
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-BILL-ADDRESS      AS BILL_ADDRESS,             
                      :S-SPCL-READ-INST    AS SPCL_READ_INST,           
                      :S-SPCL-INST         AS SPCL_INST,                
                      :S-PREM-DIRECTIONS   AS PREM_DIRECTIONS,          
                      :S-SCRATCHPAD        AS SCRATCHPAD,               
                      :S-ADDRESS-ID        AS ADDRESS_ID,               
                      :S-ADDRESS-FORMAT    AS ADDRESS_FORMAT,           
                      :S-ADDR-STREET       AS ADDR_STREET,              
                      :S-ADDR-CITY-STATE   AS ADDR_CITY_STATE,          
                      :S-ADDR-ZIP-CODE     AS ADDR_ZIP_CODE,            
                      :S-ADDR-COUNTRY      AS ADDR_COUNTRY,             
                      :S-ADDR-STREET-2     AS ADDR_STREET_2,            
                      :S-HOUSE-NO          AS HOUSE_NO,                 
                      :S-ADDR-PREFIX-1     AS ADDR_PREFIX_1,            
                      :S-ADDR-PREFIX-2     AS ADDR_PREFIX_2,            
                      :S-STREET-NAME       AS STREET_NAME,              
                      :S-STREET-SUFFIX     AS STREET_SUFFIX,            
                      :S-ADDR-SUFFIX       AS ADDR_SUFFIX,              
                      :S-STREET-LOCATION-1 AS STREET_LOCATION_1,        
                      :S-STREET-LOCATION-2 AS STREET_LOCATION_2,        
                      :S-ZIP-CODE          AS ZIP_CODE,                 
                      :S-ZIP-CODE-PLUS-FOUR AS ZIP_CODE_PLUS_FOUR,      
                      :S-ZIP-CODE-TOKEN    AS ZIP_CODE_TOKEN,           
                      :S-STATE             AS STATE,                    
                      :S-SUBDIVISION-ID    AS SUBDIVISION_ID,           
                      :S-EST-BILL-DAY      AS EST_BILL_DAY,             
                      :S-EST-DUE-DAY       AS EST_DUE_DAY,              
                      :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS             
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-BILL-ADDRESS      AS BILL_ADDRESS,                     
MFA-TR*               :S-SPCL-READ-INST    AS SPCL_READ_INST,                   
MFA-TR*               :S-SPCL-INST         AS SPCL_INST,                        
MFA-TR*               :S-PREM-DIRECTIONS   AS PREM_DIRECTIONS,                  
MFA-TR*               :S-SCRATCHPAD        AS SCRATCHPAD,                       
MFA-TR*               :S-ADDRESS-ID        AS ADDRESS_ID,                       
MFA-TR*               :S-ADDRESS-FORMAT    AS ADDRESS_FORMAT,                   
MFA-TR*               :S-ADDR-STREET       AS ADDR_STREET,                      
MFA-TR*               :S-ADDR-CITY-STATE   AS ADDR_CITY_STATE,                  
MFA-TR*               :S-ADDR-ZIP-CODE     AS ADDR_ZIP_CODE,                    
MFA-TR*               :S-ADDR-COUNTRY      AS ADDR_COUNTRY,                     
MFA-TR*               :S-ADDR-STREET-2     AS ADDR_STREET_2,                    
MFA-TR*               :S-HOUSE-NO          AS HOUSE_NO,                         
MFA-TR*               :S-ADDR-PREFIX-1     AS ADDR_PREFIX_1,                    
MFA-TR*               :S-ADDR-PREFIX-2     AS ADDR_PREFIX_2,                    
MFA-TR*               :S-STREET-NAME       AS STREET_NAME,                      
MFA-TR*               :S-STREET-SUFFIX     AS STREET_SUFFIX,                    
MFA-TR*               :S-ADDR-SUFFIX       AS ADDR_SUFFIX,                      
MFA-TR*               :S-STREET-LOCATION-1 AS STREET_LOCATION_1,                
MFA-TR*               :S-STREET-LOCATION-2 AS STREET_LOCATION_2,                
MFA-TR*               :S-ZIP-CODE          AS ZIP_CODE,                         
MFA-TR*               :S-ZIP-CODE-PLUS-FOUR AS ZIP_CODE_PLUS_FOUR,              
MFA-TR*               :S-ZIP-CODE-TOKEN    AS ZIP_CODE_TOKEN,                   
MFA-TR*               :S-STATE             AS STATE,                            
MFA-TR*               :S-SUBDIVISION-ID    AS SUBDIVISION_ID,                   
MFA-TR*               :S-EST-BILL-DAY      AS EST_BILL_DAY,                     
MFA-TR*               :S-EST-DUE-DAY       AS EST_DUE_DAY,                      
MFA-TR*               :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS                     
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
           MOVE 'N' TO WS-GTT02-DECLARED.                               
           MOVE 'N' TO WS-GTT03-DECLARED.                               
           MOVE 'N' TO WS-GTT05-DECLARED.                               
           MOVE 'N' TO WS-GTT08-DECLARED.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0102-DECLARE-GTT02.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04478_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04478_R2
              (                                                          
                 RETURN_CODE          INT,                          
                 NAME_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,           
                 CONTACT_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 MATRIX_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8002-DELETE-GTT2-ROWS THRU 8002-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0102'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04478_R2'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT02-DECLARED.                               
                                                                        
       0102-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04478_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04478_R3
              (                                                          
                 RETURN_CODE          INT,                          
                 EQUIPMENT_NO CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 APPLIANCE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 CAUTION_TAG_IND CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 CUT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
                 TAG_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,              
                 CONDITION_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
                 LOCATION_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,         
                 APPL_COMMENTS CHAR(255)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                        
                 CAUTION_TAG_DT CHAR(10)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 SOURCE_SYSTEM_CD CHAR(03)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 INSTALL_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,          
                 SERIAL_NO CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,           
                 CAD_VERIFY_DT CHAR(10)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 APPLIANCE_DESC CHAR(20)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 SEASONAL_RT_FL CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 CRAWL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
                 APPL_LONG_DESC CHAR(255)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                        
                 PRIMARY_FUEL_CD CHAR(06)  COLLATE 
                              LATIN1_GENERAL_100_BIN2,                         
                 AVERAGE_BTU          INT,                          
                 LEAK_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
                 LIGHT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
                 REPAIR_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
                 CUTOFF_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
                 REPLACE_APP_FL CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04478_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0105-DECLARE-GTT05.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04478_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04478_R5
              (                                                          
                 RETURN_CODE          INT                           
                ,SERV_ORDER_NO           DECIMAL(13,0)                  
                ,REMARK_TYPE_CD CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                       
                ,REMARK_TX CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8005-DELETE-GTT5-ROWS THRU 8005-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0105'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04478_R5'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT05-DECLARED.                               
                                                                        
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0108-DECLARE-GTT08.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04478_R8')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04478_R8
              (                                                          
                 RETURN_CODE          INT                           
                ,CONTRACT_ID          INT                           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8008-DELETE-GTT8-ROWS THRU 8008-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0108'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04478_R8'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT08-DECLARED.                               
                                                                        
       0108-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-OLD-CUSTOMER-NO NOT NUMERIC                          
               MOVE ZEROES TO LINK-OLD-CUSTOMER-NO
           END-IF.                     
           IF LINK-NEW-CUSTOMER-NO NOT NUMERIC                          
               MOVE ZEROES TO LINK-NEW-CUSTOMER-NO
           END-IF.                     
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           IF LINK-XFER-FROM-ACCT NOT NUMERIC                           
               MOVE ZEROES TO LINK-XFER-FROM-ACCT
           END-IF.                      
           IF LINK-NEXT-BUS-DAY(6:2) NUMERIC                            
               IF LINK-NEXT-BUS-DAY(6:2) >= '10' OR                     
                  LINK-NEXT-BUS-DAY(6:2) <= '04'                        
                      MOVE 'Y' TO WS-SEASONAL-FL                        
               ELSE                                                     
                   MOVE 'N' TO WS-SEASONAL-FL                           
               END-IF                                                   
           ELSE                                                         
               MOVE 'N' TO WS-SEASONAL-FL
           END-IF.                              
                                                                        
MAINTN     IF LINK-SERV-ORDER-NO > SPACES AND                           
MAINTN          LINK-SERV-ORDER-NO NOT = '0000000000000'                
MAINTN        MOVE 'N' TO WS-NEW-ORDER-FL                               
MAINTN     ELSE                                                         
MAINTN        MOVE 'Y' TO WS-NEW-ORDER-FL                               
MAINTN     END-IF                                                       
                                                                        
           MOVE LINK-PREMISE-NO            TO WS-PREMISE-NO-CHAR.       
           MOVE WS-PREMISE-NO-NUM          TO PR-PREMISE-NO             
                                              LA-PREMISE-NO.            
           MOVE LINK-OLD-CUSTOMER-NO       TO WS-CUSTOMER-NO-CHAR.      
           MOVE WS-CUSTOMER-NO-NUM         TO WS-OLD-CUSTOMER-NO.       
           MOVE LINK-NEW-CUSTOMER-NO       TO WS-CUSTOMER-NO-CHAR.      
           MOVE WS-CUSTOMER-NO-NUM         TO WS-NEW-CUSTOMER-NO.       
           MOVE LINK-ACCOUNT-NO            TO WS-ACCOUNT-NO-CHAR.       
           MOVE WS-ACCOUNT-NO-NUM          TO AT-ACCOUNT-NO.            
                                                                        
           EVALUATE TRUE                                                
               WHEN LINK-ORDER-TYPE-CD(1:3) = 'OFF'                     
P0795A             MOVE 'OFF01' TO 3C-ORDER-TYPE-CD                     
                   MOVE 'STOP ' TO WS-PROCESS                           
               WHEN LINK-ORDER-TYPE-CD(1:2) = 'CC'                      
                   IF LINK-XFER-FL = 'Y' OR                             
                      LINK-REVERT-FL = 'Y'                              
P0795A                    MOVE 'OFF01' TO 3C-ORDER-TYPE-CD              
                   ELSE                                                 
P0795A                 MOVE 'CC001' TO 3C-ORDER-TYPE-CD                 
                   END-IF                                               
                   MOVE 'START' TO WS-PROCESS                           
D11722         WHEN LINK-ORDER-TYPE-CD(1:2) = 'NC'                      
D11722             MOVE 'NC001' TO 3C-ORDER-TYPE-CD                     
D11722             MOVE 'START' TO WS-PROCESS                           
               WHEN OTHER                                               
P00795*            MOVE LINK-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD                  
P0795A             MOVE LINK-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD          
MAINTN             IF WS-NEW-ORDER-FL = 'N'                             
                      MOVE 'MAINTAIN' TO WS-PROCESS                     
                   ELSE                                                 
P00795                MOVE 'AOO' TO WS-PROCESS                          
                   END-IF                                               
P00795*            MOVE SPACES TO 3C-ORDER-TYPE-CD                              
P00795*                           WS-PROCESS                                    
           END-EVALUATE.                                                
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TIMESTAMP                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-ACCOUNT-NO = ZEROES AND                              
              LINK-OLD-CUSTOMER-NO = ZEROES AND                         
              LINK-PREMISE-NO = ZEROES                                  
                  INITIALIZE GTT-RETURN-FIELDS                          
                  MOVE +100 TO S-RETURN-CODE-1                          
                               S-RETURN-CODE-2                          
                               S-RETURN-CODE-3                          
                               S-RETURN-CODE-4                          
                               S-RETURN-CODE-5                          
                               S-RETURN-CODE-6                          
                               S-RETURN-CODE-7                          
                  MOVE 'PARMS ZERO' TO S-BILL-ADDRESS                   
                  ADD 1 TO  CTR-ROWS                                    
                  PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT             
                  PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT             
                  PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT             
                  PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT             
                  PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           IF PR-PREMISE-NO > 0                                         
              PERFORM 7000-SELECT-PREMISE THRU 7000-EXIT                
              IF WS-NEW-ORDER-FL = 'N'                                  
                MOVE LINK-ORDER-TYPE-CD TO C2-ORDER-TYPE-CD             
DT9130          PERFORM 7830-GET-ORDER-TYPE-INFO THRU 7830-EXIT         
                IF C2-ORDER-GROUP-CD NOT = 'A'                          
MAINTN            MOVE LINK-SERV-ORDER-NO TO  WS-SERV-ORDER-NO-C        
                  IF LINK-CURRENT-HISTORY-FL = 'C'                      
MAINTN              MOVE WS-SERV-ORDER-NO-N TO VQ-SERV-ORDER-NO         
                    PERFORM 2550-SO-APPLIANCES THRU 2550-EXIT           
                  ELSE                                                  
MAINTN              MOVE WS-SERV-ORDER-NO-N TO XZ-SERV-ORDER-NO         
                    PERFORM 2570-HST-APPLIANCES THRU 2570-EXIT          
                  END-IF                                                
                ELSE                                                    
                  PERFORM 2500-APPLIANCES THRU 2500-EXIT                
                END-IF                                                  
              ELSE                                                      
                 PERFORM 2500-APPLIANCES THRU 2500-EXIT                 
              END-IF                                                    
           END-IF.                                                      
           MOVE SPACES TO WS-ADDRESS-LINE.                              
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7005-SELECT-ACCOUNT THRU 7005-EXIT               
               PERFORM 7150-EMAIL-ADDRESS THRU 7150-EXIT                
DT9459         IF WS-NEW-ORDER-FL = 'Y'                                 
                  MOVE AT-ACCOUNT-NO TO WS-AT-ACCOUNT-NO                
                  IF AT-ADDRESS-ID > 0                                  
DT9459               PERFORM 5010-BUILD-BILL-ADDR THRU 5010-EXIT
                  END-IF
               END-IF
           END-IF.       
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
                                                                        
           IF LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC'                    
A05317         PERFORM 7760-GET-BILL-DATES THRU 7760-EXIT
           END-IF.              
A05317*        PERFORM 3000-CALL-CSR02364 THRU 3000-EXIT.                       
                                                                        
           IF WS-NEW-ORDER-FL = 'N'                                     
MAINTN        PERFORM 3020-CALL-CSR01105 THRU 3020-EXIT                 
MAINTN        MOVE LINK-SERV-ORDER-NO TO  WS-SERV-ORDER-NO-C            
MAINTN        MOVE WS-SERV-ORDER-NO-N TO VO-SERV-ORDER-NO               
              IF (ORDER-TYPE-CD-1105(1:2) = 'CC' OR                     
                  ORDER-TYPE-CD-1105(1:2) = 'NC' OR                     
                  ORDER-TYPE-CD-1105 = 'UMRCC')                         
                  MOVE ACCOUNT-NO-1105 TO AT-ACCOUNT-NO                 
              ELSE                                                      
                  MOVE ACCOUNT-NO-PRIOR-1105 TO AT-ACCOUNT-NO           
              END-IF                                                    
              IF AT-ACCOUNT-NO > 0                                      
                 PERFORM 7005-SELECT-ACCOUNT THRU 7005-EXIT             
              END-IF                                                    
MAINTN        IF LINK-CURRENT-HISTORY-FL = 'C'                          
MAINTN            MOVE WS-SERV-ORDER-NO-N TO EF-SERV-ORDER-NO           
MAINTN                                       VO-SERV-ORDER-NO           
MAINTN            PERFORM  7750-GET-SO-DATA THRU 7750-EXIT              
MAINTN            PERFORM  7860-GET-SO-MTR-EXISTS THRU 7860-EXIT        
DT9519            PERFORM  7840-GET-CANCEL-REASON THRU 7840-EXIT        
MAINTN            PERFORM  2600-SO-REMARKS  THRU 2600-EXIT              
MAINTN            PERFORM  3040-CALL-CSR04747 THRU 3040-EXIT            
MAINTN        ELSE                                                      
MAINTN            MOVE WS-SERV-ORDER-NO-N TO OE-SERV-ORDER-NO           
MAINTN                                       YV-SERV-ORDER-NO           
MAINTN            PERFORM 7755-GET-HST-SO-DATA THRU 7755-EXIT           
DT9519            PERFORM 7850-GET-HST-CANCEL-REASON THRU 7850-EXIT     
MAINTN            PERFORM 2630-HST-SO-REMARKS  THRU 2630-EXIT           
MAINTN        END-IF                                                    
MAINTN        MOVE WS-SERV-ORDER-NO-N TO YT-SERV-ORDER-NO               
MAINTN        IF ORDER-TYPE-CD-1105(1:3) = 'OFF' OR                     
MAINTN           ORDER-TYPE-CD-1105(1:2) = 'CC'  OR                     
MAINTN           (ORDER-TYPE-CD-1105 = 'NC001' OR 'UMRCC' OR 'UMROC')   
MAINTN*         *GET SO ACCT TRANSFER DETAILS -RSLT SET 6                       
MAINTN           PERFORM 3025-CALL-CSR01243 THRU 3025-EXIT              
DT9511*         *GET SO CONTRACT XFER DETAILS -RSLT SET 8                       
DT9511           PERFORM 3026-CALL-CSR00181 THRU 3026-EXIT              
MAINTN        ELSE                                                      
MAINTN           MOVE +100 TO S-RETURN-CODE-6                           
MAINTN        END-IF                                                    
              MOVE SPACES TO WS-ADDRESS-LINE                            
MAINTN        IF ORDER-TYPE-CD-1105(1:3) = 'OFF' OR                     
MAINTN           ORDER-TYPE-CD-1105(1:2) = 'CC'  OR                     
MAINTN           (ORDER-TYPE-CD-1105 = 'NC001' OR 'UMRCC' OR 'UMROC')   
DT9459            MOVE ACCOUNT-NO-PRIOR-1105 TO WS-AT-ACCOUNT-NO        
DT9459            PERFORM 7020-GET-BILL-ADDR-ID THRU 7020-EXIT          
DT9459            IF AT-ADDRESS-ID > 0                                  
DT9459               PERFORM 5010-BUILD-BILL-ADDR THRU 5010-EXIT        
DT9459           END-IF                                                 
MAINTN*         *GET SO FINAL BILL DETAILS - RSLT SET 7                         
MAINTN           PERFORM 3030-CALL-CSR01204 THRU 3030-EXIT              
MAINTN        ELSE                                                      
MAINTN           MOVE +100 TO S-RETURN-CODE-7                           
MAINTN        END-IF                                                    
MAINTN        PERFORM 7210-METER-TURNOFF THRU 7210-EXIT                 
MAINTN     ELSE                                                         
MAINTN        MOVE +100 TO S-RETURN-CODE-4                              
MAINTN        MOVE +100 TO S-RETURN-CODE-6                              
MAINTN        MOVE +100 TO S-RETURN-CODE-7                              
MAINTN     END-IF.                                                      
DT9536* TO GET CONTACT DETAIL FROM THE MATRIX                                   
           MOVE PR-COMPANY-NO TO 3C-COMPANY-NO.                         
                                                                        
           PERFORM 7030-OPEN-CONTACT-CURSOR THRU 7030-EXIT.             
           PERFORM 2100-FETCH-ROWS THRU 2100-EXIT.                      
           PERFORM 7040-CLOSE-CONTACT-CURSOR THRU 7040-EXIT.            
                                                                        
P00795     IF NO-CONTACT-EXIST                                          
P00795        MOVE 'NC' TO 3C-NAME-TYPE                                 
P00795                     3C-CONTACT-TYPE                              
P00795        MOVE 'NO CONTACT MATRIX DATA' TO WS-NAME                  
P00795        PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT              
           END-IF.                                                      
                                                                        
           MOVE 'NA' TO 3C-NAME-TYPE                                    
                        3C-CONTACT-TYPE.                                
           MOVE 'N/A' TO WS-NAME.                                       
           PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT.                
           MOVE 'NL' TO 3C-NAME-TYPE                                    
                        3C-CONTACT-TYPE.                                
           IF AT-ACCOUNT-TYPE-CODE = 'C'                                
              MOVE 'PERSON REQUESTING ORDER' TO WS-NAME                 
           ELSE                                                         
              MOVE 'PERSON NOT LISTED' TO WS-NAME
           END-IF.                      
                                                                        
           PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT.                
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH CONTACT-CURSOR                                     
                INTO :3C-NAME-TYPE,                                     
                     :3C-CONTACT-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   INITIALIZE WS-ITERATION-STORAGE                      
                   PERFORM 2110-GET-CONTACT THRU 2110-EXIT              
P00795             MOVE 'Y' TO SW-CONTACT                               
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2100-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2100'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_CONT_MATRIX' TO TABLE-1                 
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
                   MOVE 3C-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
                   MOVE 3C-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2100-FETCH-ROWS.                                       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-GET-CONTACT.                                                
                                                                        
           MOVE 0 TO S-RETURN-CODE-2.                                   
                                                                        
           EVALUATE 3C-NAME-TYPE ALSO 3C-CONTACT-TYPE                   
               WHEN 'CU' ALSO '  '                                      
                   PERFORM 7100-CUSTOMER-NAME THRU 7100-EXIT            
                   IF WS-NAME > ' '                                     
                       PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT     
                   END-IF                                               
               WHEN 'SP' ALSO '  '                                      
                   PERFORM 7200-SPOUSE-NAME THRU 7200-EXIT              
                   IF WS-NAME > ' '                                     
                       PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT     
                   END-IF                                               
               WHEN 'CO' ALSO '  '                                      
                   PERFORM 2200-COAPP-NAME THRU 2200-EXIT               
               WHEN 'CC' ALSO 'PA'                                      
                   PERFORM 2300-PA-NAME THRU 2300-EXIT                  
               WHEN 'CC' ALSO 'MP'                                      
                   PERFORM 2350-MP-NAME THRU 2350-EXIT                  
               WHEN 'CC' ALSO 'TA'                                      
                   PERFORM 2400-TA-NAME THRU 2400-EXIT                  
           END-EVALUATE.                                                
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2120-LOAD-MATRIX-DATA.                                           
                                                                        
           MOVE 3C-NAME-TYPE TO S-NAME-TYPE.                            
           MOVE 3C-CONTACT-TYPE TO S-CONTACT-TYPE.                      
           MOVE WS-NAME TO S-MATRIX-NAME.                               
           IF WS-GTT02-DECLARED = 'N'                                   
               PERFORM 0102-DECLARE-GTT02 THRU 0102-EXIT
           END-IF.               
           PERFORM 8200-SEND-RESULT-2 THRU 8200-EXIT.                   
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2140-GET-CUSTOMER-NAME.                                          
                                                                        
           PERFORM 7100-CUSTOMER-NAME THRU 7100-EXIT                    
           IF WS-NAME > ' '                                             
              PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT              
           END-IF.                                                      
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-COAPP-NAME.                                                 
                                                                        
           IF LINK-XFER-FROM-ACCT > ZEROES                              
               MOVE LINK-XFER-FROM-ACCT TO WS-ACCOUNT-NO-CHAR           
               MOVE WS-ACCOUNT-NO-NUM TO IC-ACCOUNT-NO                  
           ELSE                                                         
               GO TO 2200-EXIT
           END-IF.                                         
           PERFORM 7300-OPEN-COAPP-CURSOR THRU 7300-EXIT.               
           PERFORM 2210-FETCH-ROWS THRU 2210-EXIT.                      
           PERFORM 7310-CLOSE-COAPP-CURSOR THRU 7310-EXIT.              
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH COAPP-CURSOR                                       
                INTO :WS-COAPP-NAME,                                    
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'I'                              
                       MOVE WS-COAPP-NAME TO WS-NAME                    
                   ELSE                                                 
                       MOVE DQ-FULL-NAME TO WS-NAME                     
                   END-IF                                               
                   PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2210-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2210'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_COAPPLICANT'   TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2210-FETCH-ROWS.                                       
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-PA-NAME.                                                    
                                                                        
           PERFORM 7400-OPEN-PA-CURSOR THRU 7400-EXIT.                  
           PERFORM 2310-FETCH-ROWS THRU 2310-EXIT.                      
           PERFORM 7410-CLOSE-PA-CURSOR THRU 7410-EXIT.                 
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH PA-CURSOR                                          
                INTO :WS-PA-NAME,                                       
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'I'                              
                       MOVE WS-PA-NAME TO WS-NAME                       
                   ELSE                                                 
                       MOVE DQ-FULL-NAME TO WS-NAME                     
                   END-IF                                               
                   PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2310-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2310'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2310-FETCH-ROWS.                                       
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2350-MP-NAME.                                                    
                                                                        
           PERFORM 7450-OPEN-MP-CURSOR THRU 7450-EXIT.                  
           PERFORM 2360-FETCH-ROWS THRU 2360-EXIT.                      
           PERFORM 7460-CLOSE-MP-CURSOR THRU 7460-EXIT.                 
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2360-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH MP-CURSOR                                          
                INTO :WS-MP-NAME,                                       
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'I'                              
                       MOVE WS-MP-NAME TO WS-NAME                       
                   ELSE                                                 
                       MOVE DQ-FULL-NAME TO WS-NAME                     
                   END-IF                                               
                   PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2360-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2360'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2360-FETCH-ROWS.                                       
                                                                        
       2360-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-TA-NAME.                                                    
                                                                        
           PERFORM 7500-OPEN-TA-CURSOR THRU 7500-EXIT.                  
           PERFORM 2410-FETCH-ROWS THRU 2410-EXIT.                      
           PERFORM 7510-CLOSE-TA-CURSOR THRU 7510-EXIT.                 
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2410-FETCH-ROWS.                                                 
                                                                        
           EXEC SQL                                                     
               FETCH TA-CURSOR                                          
                INTO :WS-TA-NAME,                                       
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'I'                              
                       MOVE WS-TA-NAME TO WS-NAME                       
                   ELSE                                                 
                       MOVE DQ-FULL-NAME TO WS-NAME                     
                   END-IF                                               
                   PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2410-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2410'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2410-FETCH-ROWS.                                       
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2450-FETCH-ALL-CONTACTS-ROWS.                                    
                                                                        
           EXEC SQL                                                     
               FETCH ALL-CONTACTS-CURSOR                                
                INTO :WS-TA-NAME,                                       
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :CV-CONTACT-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CV-CONTACT-TYPE TO 3C-NAME-TYPE                 
                                           3C-CONTACT-TYPE              
                   IF DQ-NAME-FORMAT = 'I'                              
                       MOVE WS-TA-NAME TO WS-NAME                       
                   ELSE                                                 
                       MOVE DQ-FULL-NAME TO WS-NAME                     
                   END-IF                                               
                   PERFORM 2120-LOAD-MATRIX-DATA THRU 2120-EXIT         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2450-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2450'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2450-FETCH-ALL-CONTACTS-ROWS.                          
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-APPLIANCES.                                                 
                                                                        
           MOVE 0 TO S-RETURN-CODE-3.                                   
           PERFORM 7600-OPEN-APPL-CURSOR THRU 7600-EXIT.                
           PERFORM 2510-FETCH-ROWS THRU 2510-EXIT.                      
           PERFORM 7610-CLOSE-APPL-CURSOR THRU 7610-EXIT.               
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2510-FETCH-ROWS.                                                 
                                                                        
           MOVE SPACES TO LA-APPLIANCE-COMMENTS                         
                          JA-APPL-LONG-DESC.                            
                                                                        
           EXEC SQL                                                     
               FETCH APPL-CURSOR                                        
                INTO :LA-EQUIPMENT-NO,                                  
                     :LA-APPLIANCE-CD,                                  
                     :LA-CAUTION-TAG-IND,                               
                     :LA-CUT-IND,                                       
                     :LA-TAG-NO,                                        
                     :LA-CONDITION-CD,                                  
                     :LA-LOCATION-CD,                                   
                     :LA-APPLIANCE-COMMENTS,                            
                     :LA-CAUTION-TAG-DT :WS-NULL2,                       
                     :LA-SOURCE-SYSTEM-CD,                              
                     :LA-INSTALL-DT :WS-NULL3,                           
                     :LA-SERIAL-NO,                                     
                     :LA-CAD-VERIFY-DT :WS-NULL4,                        
                     :JA-APPLIANCE-DESC,                                
                     :JA-SEASONAL-RT-FL,                                
                     :JA-CRAWL-FL,                                      
                     :JA-APPL-LONG-DESC,                                
                     :LA-PRIMARY-FUEL-CD,                               
                     :JA-AVERAGE-BTU                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO LA-CAUTION-TAG-DT                 
                   END-IF                                               
                   IF WS-NULL3 < 0                                      
                       MOVE SPACES TO LA-INSTALL-DT                     
                   END-IF                                               
                   IF WS-NULL4 < 0                                      
                       MOVE SPACES TO LA-CAD-VERIFY-DT                  
                   END-IF                                               
                   PERFORM 2520-LOAD-APPL-DATA THRU 2520-EXIT           
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2510-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2510'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2510-FETCH-ROWS.                                       
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2520-LOAD-APPL-DATA.                                             
                                                                        
           MOVE LA-EQUIPMENT-NO TO S-EQUIPMENT-NO.                      
           MOVE LA-APPLIANCE-CD TO S-APPLIANCE-CD.                      
           MOVE LA-CAUTION-TAG-IND TO S-CAUTION-TAG-IND.                
           MOVE LA-CUT-IND TO S-CUT-IND.                                
           MOVE LA-TAG-NO TO S-TAG-NO.                                  
           MOVE LA-CONDITION-CD TO S-CONDITION-CD.                      
           MOVE LA-LOCATION-CD TO S-LOCATION-CD.                        
           MOVE LA-APPLIANCE-COMMENTS-TEXT TO S-APPL-COMMENTS.          
           MOVE LA-CAUTION-TAG-DT TO S-CAUTION-TAG-DT.                  
           MOVE LA-SOURCE-SYSTEM-CD TO S-SOURCE-SYSTEM-CD-3.            
           MOVE LA-INSTALL-DT TO S-INSTALL-DT.                          
           MOVE LA-SERIAL-NO TO S-SERIAL-NO.                            
           MOVE LA-CAD-VERIFY-DT TO S-CAD-VERIFY-DT.                    
           MOVE JA-APPLIANCE-DESC TO S-APPLIANCE-DESC.                  
           MOVE JA-SEASONAL-RT-FL TO S-SEASONAL-RT-FL.                  
           MOVE JA-CRAWL-FL TO S-CRAWL-FL.                              
           MOVE JA-APPL-LONG-DESC-TEXT TO S-APPL-LONG-DESC.             
           MOVE LA-PRIMARY-FUEL-CD TO S-PRIMARY-FUEL-CD.                
           MOVE JA-AVERAGE-BTU TO S-AVERAGE-BTU.                        
           MOVE SPACES         TO S-LEAK-IND.                           
           MOVE SPACES         TO S-LIGHT-IND.                          
           MOVE SPACES         TO S-REPAIR-IND.                         
           MOVE SPACES         TO S-CUTOFF-IND.                         
           MOVE SPACES         TO S-REPLACE-APP-FL.                     
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2550-SO-APPLIANCES.                                              
                                                                        
           MOVE 0 TO S-RETURN-CODE-3.                                   
           PERFORM 7620-OPEN-SO-APPL-CURSOR  THRU 7620-EXIT.            
           PERFORM 2555-FETCH-SO-APPL-ROWS THRU 2555-EXIT.              
           PERFORM 7625-CLOSE-SO-APPL-CURSOR  THRU 7625-EXIT.           
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2555-FETCH-SO-APPL-ROWS.                                         
                                                                        
           MOVE SPACES TO LA-APPLIANCE-COMMENTS                         
                          JA-APPL-LONG-DESC.                            
                                                                        
           EXEC SQL                                                     
               FETCH CSS-SO-APPL-CURSOR                                 
                INTO :VQ-EQUIPMENT-UNQ,                                 
                     :VQ-APPLIANCE-CD,                                  
                     :VQ-CAUTION-TAG-IND,                               
                     :LA-CUT-IND :WS-CUT-NULL-IND,                       
                     :LA-TAG-NO :WS-TAG-NULL-IND,                        
                     :LA-CONDITION-CD :WS-CONDITION-NULL-IND,            
                     :LA-LOCATION-CD :WS-LOCATION-NULL-IND,              
                     :LA-APPLIANCE-COMMENTS :WS-COMMENTS-NULL-IND,       
                     :LA-CAUTION-TAG-DT :WS-NULL2,                       
                     :LA-SOURCE-SYSTEM-CD :WS-SOURCE-NULL-IND,           
                     :VQ-INSTALL-DT :WS-NULL3,                           
                     :LA-SERIAL-NO :WS-SERIAL-NULL-IND,                  
                     :LA-CAD-VERIFY-DT :WS-NULL4,                        
                     :JA-APPLIANCE-DESC,                                
                     :JA-SEASONAL-RT-FL,                                
                     :JA-CRAWL-FL,                                      
                     :JA-APPL-LONG-DESC,                                
                     :LA-PRIMARY-FUEL-CD :WS-FUEL-NULL-IND,              
                     :JA-AVERAGE-BTU,                                   
                     :VQ-LEAK-IND,                                      
                     :VQ-LIGHT-IND,                                     
                     :VQ-REPAIR-IND,                                    
                     :VQ-CUTOFF-IND,                                    
                     :VQ-REPLACE-APP-FL                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO LA-CAUTION-TAG-DT                 
                   END-IF                                               
                   IF WS-NULL3 < 0                                      
                       MOVE SPACES TO VQ-INSTALL-DT                     
                   END-IF                                               
                   IF WS-NULL4 < 0                                      
                       MOVE SPACES TO LA-CAD-VERIFY-DT                  
                   END-IF                                               
                   IF  WS-FUEL-NULL-IND < 0                             
                       MOVE SPACES TO LA-PRIMARY-FUEL-CD                
                   END-IF                                               
                   IF  WS-SERIAL-NULL-IND < 0                           
                       MOVE SPACES TO LA-SERIAL-NO                      
                   END-IF                                               
                   IF  WS-SOURCE-NULL-IND < 0                           
                       MOVE SPACES TO LA-SOURCE-SYSTEM-CD               
                   END-IF                                               
                   IF  WS-COMMENTS-NULL-IND  < 0                        
                       MOVE SPACES TO LA-APPLIANCE-COMMENTS             
                   END-IF                                               
                   IF  WS-LOCATION-NULL-IND < 0                         
                       MOVE SPACES TO LA-LOCATION-CD                    
                   END-IF                                               
                   IF  WS-CONDITION-NULL-IND  < 0                       
                       MOVE SPACES TO LA-CONDITION-CD                   
                   END-IF                                               
                   IF  WS-CUT-NULL-IND  < 0                             
                       MOVE SPACES TO LA-CUT-IND                        
                   END-IF                                               
                   IF  WS-TAG-NULL-IND < 0                              
                       MOVE SPACES TO LA-TAG-NO                         
                   END-IF                                               
                   PERFORM 2560-LOAD-SO-APPL-DATA THRU 2560-EXIT        
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2555-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2555'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2555-FETCH-SO-APPL-ROWS.                               
                                                                        
       2555-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2560-LOAD-SO-APPL-DATA.                                          
                                                                        
           MOVE VQ-EQUIPMENT-UNQ TO S-EQUIPMENT-NO.                     
           MOVE VQ-APPLIANCE-CD TO S-APPLIANCE-CD.                      
           MOVE VQ-CAUTION-TAG-IND TO S-CAUTION-TAG-IND.                
           MOVE LA-CUT-IND TO S-CUT-IND.                                
           MOVE LA-TAG-NO TO S-TAG-NO.                                  
           MOVE LA-CONDITION-CD TO S-CONDITION-CD.                      
           MOVE LA-LOCATION-CD TO S-LOCATION-CD.                        
           MOVE LA-APPLIANCE-COMMENTS-TEXT TO S-APPL-COMMENTS.          
           MOVE LA-CAUTION-TAG-DT TO S-CAUTION-TAG-DT.                  
           MOVE LA-SOURCE-SYSTEM-CD TO S-SOURCE-SYSTEM-CD-3.            
           MOVE VQ-INSTALL-DT TO S-INSTALL-DT.                          
           MOVE LA-SERIAL-NO TO S-SERIAL-NO.                            
           MOVE LA-CAD-VERIFY-DT TO S-CAD-VERIFY-DT.                    
           MOVE JA-APPLIANCE-DESC TO S-APPLIANCE-DESC.                  
           MOVE JA-SEASONAL-RT-FL TO S-SEASONAL-RT-FL.                  
           MOVE JA-CRAWL-FL TO S-CRAWL-FL.                              
           MOVE JA-APPL-LONG-DESC-TEXT TO S-APPL-LONG-DESC.             
           MOVE LA-PRIMARY-FUEL-CD TO S-PRIMARY-FUEL-CD.                
           MOVE JA-AVERAGE-BTU TO S-AVERAGE-BTU.                        
           MOVE VQ-LEAK-IND    TO S-LEAK-IND.                           
           MOVE VQ-LIGHT-IND   TO S-LIGHT-IND.                          
           MOVE VQ-REPAIR-IND  TO S-REPAIR-IND.                         
           MOVE VQ-CUTOFF-IND  TO S-CUTOFF-IND.                         
           MOVE VQ-REPLACE-APP-FL TO S-REPLACE-APP-FL.                  
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
       2560-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2570-HST-APPLIANCES.                                             
                                                                        
           MOVE 0 TO S-RETURN-CODE-3.                                   
           PERFORM 7630-OPEN-HST-APPL-CURSOR  THRU 7630-EXIT.           
           PERFORM 2575-FETCH-HST-APPL-ROWS THRU 2575-EXIT.             
           PERFORM 7635-CLOSE-HST-APPL-CURSOR  THRU 7635-EXIT.          
                                                                        
       2570-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2575-FETCH-HST-APPL-ROWS.                                        
                                                                        
           MOVE SPACES TO LA-APPLIANCE-COMMENTS                         
                          JA-APPL-LONG-DESC.                            
                                                                        
           EXEC SQL                                                     
               FETCH HST-SO-APPL-CURSOR                                 
                INTO :XZ-EQUIPMENT-UNQ,                                 
                     :XZ-APPLIANCE-CD,                                  
                     :XZ-CAUTION-TAG-IND,                               
D26741               :LA-CUT-IND :WS-CUT-NULL-IND,                       
D26741               :LA-TAG-NO :WS-TAG-NULL-IND,                        
D26741               :LA-CONDITION-CD :WS-CONDITION-NULL-IND,            
D26741               :LA-LOCATION-CD :WS-LOCATION-NULL-IND,              
D26741               :LA-APPLIANCE-COMMENTS :WS-COMMENTS-NULL-IND,       
D26741               :LA-CAUTION-TAG-DT :WS-NULL2,                       
D26741               :LA-SOURCE-SYSTEM-CD :WS-SOURCE-NULL-IND,           
                     :XZ-INSTALL-DT :WS-NULL3,                           
D26741               :LA-SERIAL-NO :WS-SERIAL-NULL-IND,                  
D26741               :LA-CAD-VERIFY-DT :WS-NULL4,                        
                     :JA-APPLIANCE-DESC,                                
                     :JA-SEASONAL-RT-FL,                                
                     :JA-CRAWL-FL,                                      
                     :JA-APPL-LONG-DESC,                                
D26741               :LA-PRIMARY-FUEL-CD :WS-FUEL-NULL-IND,              
                     :JA-AVERAGE-BTU,                                   
                     :XZ-LEAK-IND,                                      
                     :XZ-LIGHT-IND,                                     
                     :XZ-REPAIR-IND,                                    
                     :XZ-CUTOFF-IND,                                    
                     :XZ-REPLACE-APP-FL                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL2 < 0                                      
                       MOVE SPACES TO LA-CAUTION-TAG-DT                 
                   END-IF                                               
                   IF WS-NULL3 < 0                                      
                       MOVE SPACES TO XZ-INSTALL-DT                     
                   END-IF                                               
                   IF WS-NULL4 < 0                                      
                       MOVE SPACES TO LA-CAD-VERIFY-DT                  
                   END-IF                                               
                   IF  WS-FUEL-NULL-IND < 0                             
                        MOVE SPACES TO LA-PRIMARY-FUEL-CD               
                    END-IF                                              
                    IF  WS-SERIAL-NULL-IND < 0                          
                        MOVE SPACES TO LA-SERIAL-NO                     
                    END-IF                                              
                    IF  WS-SOURCE-NULL-IND < 0                          
                       MOVE SPACES TO LA-SOURCE-SYSTEM-CD               
                   END-IF                                               
                   IF  WS-COMMENTS-NULL-IND  < 0                        
                       MOVE SPACES TO LA-APPLIANCE-COMMENTS             
                   END-IF                                               
                   IF  WS-LOCATION-NULL-IND < 0                         
                       MOVE SPACES TO LA-LOCATION-CD                    
                   END-IF                                               
                   IF  WS-CONDITION-NULL-IND  < 0                       
                       MOVE SPACES TO LA-CONDITION-CD                   
                   END-IF                                               
                   IF  WS-CUT-NULL-IND  < 0                             
                       MOVE SPACES TO LA-CUT-IND                        
                   END-IF                                               
                   IF  WS-TAG-NULL-IND < 0                              
                       MOVE SPACES TO LA-TAG-NO                         
                   END-IF                                               
                   PERFORM 2580-LOAD-HST-APPL-DATA THRU 2580-EXIT       
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2575-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2575'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'HST_SO_APPLIANCE'  TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE XZ-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2575-FETCH-HST-APPL-ROWS.                              
                                                                        
       2575-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2580-LOAD-HST-APPL-DATA.                                         
                                                                        
           MOVE XZ-EQUIPMENT-UNQ TO S-EQUIPMENT-NO.                     
           MOVE XZ-APPLIANCE-CD TO S-APPLIANCE-CD.                      
           MOVE XZ-CAUTION-TAG-IND TO S-CAUTION-TAG-IND.                
           MOVE LA-CUT-IND TO S-CUT-IND.                                
           MOVE LA-TAG-NO TO S-TAG-NO.                                  
           MOVE LA-CONDITION-CD TO S-CONDITION-CD.                      
           MOVE LA-LOCATION-CD TO S-LOCATION-CD.                        
           MOVE LA-APPLIANCE-COMMENTS-TEXT TO S-APPL-COMMENTS.          
           MOVE LA-CAUTION-TAG-DT TO S-CAUTION-TAG-DT.                  
           MOVE LA-SOURCE-SYSTEM-CD TO S-SOURCE-SYSTEM-CD-3.            
           MOVE XZ-INSTALL-DT TO S-INSTALL-DT.                          
           MOVE LA-SERIAL-NO TO S-SERIAL-NO.                            
           MOVE LA-CAD-VERIFY-DT TO S-CAD-VERIFY-DT.                    
           MOVE JA-APPLIANCE-DESC TO S-APPLIANCE-DESC.                  
           MOVE JA-SEASONAL-RT-FL TO S-SEASONAL-RT-FL.                  
           MOVE JA-CRAWL-FL TO S-CRAWL-FL.                              
           MOVE JA-APPL-LONG-DESC-TEXT TO S-APPL-LONG-DESC.             
           MOVE LA-PRIMARY-FUEL-CD TO S-PRIMARY-FUEL-CD.                
           MOVE JA-AVERAGE-BTU TO S-AVERAGE-BTU.                        
           MOVE XZ-LEAK-IND    TO S-LEAK-IND.                           
           MOVE XZ-LIGHT-IND   TO S-LIGHT-IND.                          
           MOVE XZ-REPAIR-IND  TO S-REPAIR-IND.                         
           MOVE XZ-CUTOFF-IND  TO S-CUTOFF-IND.                         
           MOVE XZ-REPLACE-APP-FL TO S-REPLACE-APP-FL.                  
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
       2580-EXIT.                                                       
           EXIT.                                                        
       2600-SO-REMARKS.                                                 
                                                                        
           MOVE 0 TO S-RETURN-CODE-5.                                   
           PERFORM 7700-OPEN-REMARKS-CSR THRU 7700-EXIT.                
           PERFORM 2610-FETCH-REMARKS THRU 2610-EXIT.                   
           PERFORM 7710-CLOSE-REMARKS-CSR THRU 7710-EXIT.               
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2610-FETCH-REMARKS.                                              
                                                                        
           EXEC SQL                                                     
               FETCH SO-REMARKS-CSR                                     
                INTO :EF-SERV-ORDER-NO                                  
                    ,:EF-REMARK-TYPE-CD                                 
                    ,:EF-REMARK-TX                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 2620-LOAD-REMARKS-DATA THRU 2620-EXIT        
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2610-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2620'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_REMRKS'     TO TABLE-1                  
                   MOVE 'SERV ORDER NO'     TO TABLE-ELEMENT-1          
                   MOVE EF-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2610-FETCH-REMARKS.                                    
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2620-LOAD-REMARKS-DATA.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-5.                              
           INITIALIZE WS-SPACE-CNT.                                     
           MOVE EF-SERV-ORDER-NO               TO S-SERV-ORDER-NO-5.    
           MOVE EF-REMARK-TYPE-CD              TO S-REMARK-TYPE-CD.     
           INSPECT EF-REMARK-TX-TEXT                                    
                   REPLACING ALL LOW-VALUES BY SPACES                   
           INSPECT FUNCTION REVERSE (EF-REMARK-TX-TEXT) TALLYING        
                   WS-SPACE-CNT FOR LEADING SPACES.                     
           COMPUTE WS-LENGTH = 210 - WS-SPACE-CNT.                      
           MOVE EF-REMARK-TX-TEXT(1:WS-LENGTH) TO S-REMARK-TX.          
           IF WS-GTT05-DECLARED = 'N'                                   
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT
           END-IF.               
           PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT.                   
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
       2630-HST-SO-REMARKS.                                             
                                                                        
           MOVE 0 TO S-RETURN-CODE-5.                                   
           PERFORM 7730-OPEN-HST-REMARKS-CSR THRU 7730-EXIT.            
           PERFORM 2640-FETCH-HST-REMARKS THRU 2640-EXIT.               
           PERFORM 7740-CLOSE-HST-REMARKS-CSR THRU 7740-EXIT.           
                                                                        
       2630-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2640-FETCH-HST-REMARKS.                                          
                                                                        
           EXEC SQL                                                     
               FETCH HST-SO-REMARKS-CSR                                 
                INTO :OE-SERV-ORDER-NO                                  
                    ,:OE-REMARK-TYPE-CD                                 
                    ,:OE-REMARK-TX                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 2650-LOAD-HST-REMARKS-DATA THRU 2650-EXIT    
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-ACTIVE-RETURN-CODE                      
                   GO TO 2640-EXIT                                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '2640'              TO ACTIVE-PARAGRAPH         
                   MOVE 'FETCH'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_REMARKS'    TO TABLE-1                  
                   MOVE 'SERV ORDER NO'     TO TABLE-ELEMENT-1          
                   MOVE OE-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           GO TO 2640-FETCH-HST-REMARKS.                                
                                                                        
       2640-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2650-LOAD-HST-REMARKS-DATA.                                      
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-5.                              
           INITIALIZE WS-SPACE-CNT.                                     
           MOVE OE-SERV-ORDER-NO               TO S-SERV-ORDER-NO-5.    
           MOVE OE-REMARK-TYPE-CD              TO S-REMARK-TYPE-CD.     
           INSPECT OE-REMARK-TX-TEXT                                    
                   REPLACING ALL LOW-VALUES BY SPACES                   
           INSPECT FUNCTION REVERSE (OE-REMARK-TX-TEXT) TALLYING        
                   WS-SPACE-CNT FOR LEADING SPACES.                     
           COMPUTE WS-LENGTH = 210 - WS-SPACE-CNT.                      
           MOVE OE-REMARK-TX-TEXT(1:WS-LENGTH) TO S-REMARK-TX.          
           IF WS-GTT05-DECLARED = 'N'                                   
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT
           END-IF.               
           PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT.                   
                                                                        
       2650-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317*                                                                         
A05317*3000-CALL-CSR02364.                                                      
A05317*                                                                         
A05317*    MOVE WS-CURRENT-DATE(1:4) TO REV-MONTH-2364(1:4).                    
A05317*    MOVE WS-CURRENT-DATE(6:2) TO REV-MONTH-2364(5:2).                    
A05317*    MOVE AT-BILL-CYCLE TO BILL-CYCLE-IN-2364.                            
A05317*    MOVE 'N' TO CREDIT-GROUP-2364.                                       
A05317*    MOVE PR-COMPANY-NO TO COMPANY-NO-2364.                               
A05317*                                                                         
A05317*    EXEC SQL                                                             
A05317*       CALL CSR02364                                                     
A05317*            (:REV-MONTH-2364,                                            
A05317*             :BILL-CYCLE-IN-2364,                                        
A05317*             :CREDIT-GROUP-2364,                                         
A05317*             :COMPANY-NO-2364)                                           
A05317*    END-EXEC.                                                            
A05317*                                                                         
A05317*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
A05317*                                                                         
A05317*    IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                              
A05317*       MOVE PROGRAM-NAME          TO ABEND-PROGRAM                       
A05317*       MOVE '3000'                TO ACTIVE-PARAGRAPH                    
A05317*       MOVE 'CALL'                TO ABEND-FUNCTION                      
A05317*       MOVE 'CSR02364'            TO TABLE-1                             
A05317*       MOVE 'REV_MONTH'           TO TABLE-ELEMENT-1                     
A05317*       MOVE REV-MONTH-2364        TO HOSTVAR-ELEMENT-1                   
A05317*       MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2                     
A05317*       MOVE BILL-CYCLE-IN-2364    TO HOSTVAR-ELEMENT-2                   
A05317*       MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3                     
A05317*       MOVE COMPANY-NO-2364       TO HOSTVAR-ELEMENT-3                   
A05317*       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                         
A05317*    END-IF.                                                              
A05317*                                                                         
A05317*    EXEC SQL                                                             
A05317*       ASSOCIATE LOCATORS                                                
A05317*       (:LOC2364)                                                        
A05317*       WITH PROCEDURE CSR02364                                           
A05317*    END-EXEC.                                                            
A05317*                                                                         
A05317*    EXEC SQL                                                             
A05317*       ALLOCATE RESULT_SET_CSR_2364 CURSOR FOR RESULT SET                
A05317*       :LOC2364                                                          
A05317*    END-EXEC.                                                            
A05317*                                                                         
A05317*    PERFORM UNTIL NO-MORE-ROWS                                           
A05317*       EXEC SQL                                                          
A05317*           FETCH RESULT_SET_CSR_2364 INTO                                
A05317*               :RETURN-CODE-2364,                                        
A05317*               :BILL-CYCLE-OUT-2364,                                     
A05317*               :READ-DT-2364,                                            
A05317*               :BILL-FROM-2364,                                          
A05317*               :BILL-TO-2364,                                            
A05317*               :MAIL-DT-2364,                                            
A05317*               :BILL-DUE-DT-2364,                                        
A05317*               :AVOID-LPC-DT-2364,                                       
A05317*               :FIRST-NOTICE-DT-2364,                                    
A05317*               :SECOND-NOTICE-DT-2364,                                   
A05317*               :DNP-DT-2364,                                             
A05317*               :DUE-EXCEPT-2364,                                         
A05317*               :SECOND-EXCEPT-2364,                                      
A05317*               :DNP-EXCEPT-2364,                                         
A05317*               :SECOND-FIELD-DT-2364,                                    
A05317*               :3RD-PRTY-READ-DT-2364,                                   
A05317*               :EXCEPT-IVR-DT-2364                                       
A05317*       END-EXEC                                                          
A05317*       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                             
A05317*       EVALUATE WS-ACTIVE-RETURN-CODE                                    
A05317*          WHEN SUCCESSFUL-CALL                                           
A05317*              IF RETURN-CODE-2364 NOT = 0 AND                            
A05317*                 RETURN-CODE-2364 NOT = +100 AND                         
A04670*                 RETURN-CODE-2364 NOT = -100                             
A05317*                   MOVE RETURN-CODE-2364 TO WS-ACTIVE-RETURN-CODE        
A05317*                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
A05317*                   MOVE '3100'            TO ACTIVE-PARAGRAPH            
A05317*                   MOVE 'FETCH'           TO ABEND-FUNCTION              
A05317*                   MOVE 'CSR02364'        TO TABLE-1                     
A05317*                   MOVE 'REV_MONTH'       TO TABLE-ELEMENT-1             
A05317*                   MOVE REV-MONTH-2364    TO HOSTVAR-ELEMENT-1           
A05317*                   MOVE 'BILL_CYCLE'      TO TABLE-ELEMENT-2             
A05317*                   MOVE BILL-CYCLE-IN-2364 TO HOSTVAR-ELEMENT-2          
A05317*                   MOVE 'COMPANY_NO'      TO TABLE-ELEMENT-3             
A05317*                   MOVE COMPANY-NO-2364   TO HOSTVAR-ELEMENT-3           
A05317*                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
A05317*            END-IF                                                       
A05317*            IF RETURN-CODE-2364 = +100                                   
A05317*                MOVE SPACES TO S-EST-BILL-DAY                            
A05317*                MOVE SPACES TO S-EST-DUE-DAY                             
A05317*                SET NO-MORE-ROWS TO TRUE                                 
A05317*            ELSE                                                         
A04670*                IF RETURN-CODE-2364 = -100                               
A04670*                    MOVE SPACES TO S-EST-BILL-DAY                        
A04670*                    MOVE SPACES TO S-EST-DUE-DAY                         
A04670*                    SET NO-MORE-ROWS TO TRUE                             
A04670*                ELSE                                                     
A05317*                    MOVE BILL-FROM-2364(4:2) TO S-EST-BILL-DAY           
A05317*                    MOVE BILL-DUE-DT-2364(4:2) TO S-EST-DUE-DAY          
A04670*                END-IF                                                   
A05317*            END-IF                                                       
A05317*          WHEN NOT-FOUND                                                 
A05317*              SET NO-MORE-ROWS TO TRUE                                   
A05317*              MOVE 0 TO WS-ACTIVE-RETURN-CODE                            
A05317*          WHEN OTHER                                                     
A05317*              MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
A05317*              MOVE '3100'                TO ACTIVE-PARAGRAPH             
A05317*              MOVE 'FETCH'               TO ABEND-FUNCTION               
A05317*              MOVE 'CSR02364'            TO TABLE-1                      
A05317*              MOVE 'REV_MONTH'           TO TABLE-ELEMENT-1              
A05317*              MOVE REV-MONTH-2364        TO HOSTVAR-ELEMENT-1            
A05317*              MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2              
A05317*              MOVE BILL-CYCLE-IN-2364    TO HOSTVAR-ELEMENT-2            
A05317*              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3              
A05317*              MOVE COMPANY-NO-2364       TO HOSTVAR-ELEMENT-3            
A05317*              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                  
A05317*      END-EVALUATE                                                       
A05317*    END-PERFORM.                                                         
A05317*    MOVE 'Y' TO SW-FETCH.                                                
A05317*                                                                         
A05317*3000-EXIT.                                                               
A05317*     EXIT.                                                               
                                                                        
      ****************************************************************          
      **  CALL CSR01105 TO GET DATA FOR THE EXISTING ORDER.         **          
      ****************************************************************          
                                                                        
       3020-CALL-CSR01105.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-1105.               
           MOVE LINK-CURRENT-HISTORY-FL TO CURRENT-HISTORY-FL-1105.     
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01105                                             
      *           (:SERV-ORDER-NO-1105,                                 
      *            :CURRENT-HISTORY-FL-1105)                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1105
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1105
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1105 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3020'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01105'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1105)                                                
      *       WITH PROCEDURE CSR01105                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1105 CURSOR FOR RESULT SET        
      *       :LOC1105                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1105 INTO                            
                   :RETURN-CODE-1105,                                   
                   :ORDER-TYPE-CD-1105,                                 
                   :ORDER-REASON-1105,                                  
                   :STATUS-TX-1105,                                     
                   :ORDER-STATE-CD-1105,                                
                   :ORDER-PLACED-BY-1105,                               
                   :PHONE-NO-1105,                                      
                   :PHONE-NO-EXT-1105,                                  
                   :WANTED-BY-DATETIME-1105,                            
                   :ASSIGNED-DATETIME-1105,                             
                   :CALL-BEFORE-MINUTS-1105,                            
                   :WORK-AREA-ID-1105,                                  
                   :BREAKERS-OFF-IND-1105,                              
                   :INIT-BY-CNTRCT-IND-1105,                            
                   :NOTIFY-CSR-IND-1105,                                
                   :NOTIFY-CUST-IND-1105,                               
                   :ORDER-PRIORITY-CD-1105,                             
                   :STD-LABOR-CHRG-1105,                                
                   :WORK-TYPE-CD-1105,                                  
                   :BACK-DATED-IND-1105,                                
                   :DEPOSIT-AMT-1105,                                   
                   :ORDER-RECVED-BY-1105,                               
                   :VERIFY-RATE-1105,                                   
                   :PREMISE-NO-1105,                                    
                   :ACCOUNT-NO-1105,                                    
                   :ACCOUNT-NO-PRIOR-1105,                              
                   :BEGIN-APPT-DATE-1105 :WS-NULL-APPT-DT,               
                   :SO-EST-LABOR-HR-1105,                               
                   :CUSTCHG-ORD-TYPE-FL-1105,                           
                   :AMOUNT-DISC-BAL-1105,                               
                   :FILLER-1105,                                        
                   :CURRENT-DATE-1105,                                  
                   :CODE-UTIL-TYPE-1105,                                
                   :PRICE-PER-SERV-1105,                                
                   :ACCOUNT-TYPE-DESC-1105 :WS-NULL-ACCT-DESC,           
                   :ORDER-CHARGE-AMT-1105,                              
                   :TOTAL-CHARGES-AMT-1105,                             
                   :CUST-CNT-ID-1105,                                   
                   :FILLER-A-1105,                                      
                   :FILLER-B-1105,                                      
                   :FILLER-C-1105,                                      
                   :FILLER-D-1105,                                      
                   :FILLER-E-1105,                                      
                   :MTR-ACCESSIBLE-CD-1105,                             
                   :MTR-ACCESSIBLE-DT-1105 :WS-NULL-ACCESS-DT,           
                   :MTR-ACCESSIBLE-RSN-1105,                            
                   :SOURCE-SYSTEM-CD-1105,                              
                   :ALT-PHONE-NO-1105,                                  
                   :ALT-PHONE-NO-EXT-1105,                              
                   :HOME-ALL-DAY-FL-1105,                               
                   :BUSINESS-UNIT-1105,                                 
                   :OPTIMIZE-ORDER-1105                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1105 NOT = 0                          
                       MOVE RETURN-CODE-1105  TO                        
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3020'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01105'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE LINK-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
                   IF WS-NULL-ACCESS-DT < 0                             
                       MOVE SPACES TO MTR-ACCESSIBLE-DT-1105            
                   END-IF                                               
                   IF WS-NULL-ACCT-DESC < 0                             
                       MOVE SPACES TO ACCOUNT-TYPE-DESC-1105            
                   END-IF                                               
                   PERFORM 5000-UPDATE-ORDER-DATA THRU 5000-EXIT        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3020'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01105'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3020-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
MAINTN* CALL CSR04747 - CHECK IF CLICK ORDER- RETURNS WORK DISTRICT *   08064003
      ******************************************************************        
       3040-CALL-CSR04747.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO  SERV-ORDER-NO-4747.              
           MOVE '1'                TO  PRIORITY-4747.                   
           MOVE 'S'                TO  ACTION-CD-4747                   
           MOVE SPACES             TO  USER-ID-4747                     
           MOVE SPACES             TO  WORK-DISTRICT-IN-4747.           
                                                                        
      *    EXEC SQL                                                     
      *     CALL CSR04747 (                                             
      *                 :SERV-ORDER-NO-4747                             
      *                ,:PRIORITY-4747                                  
      *                ,:ACTION-CD-4747                                 
      *                ,:USER-ID-4747                                   
      *                ,:WORK-DISTRICT-IN-4747)                         
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_CSR_4747
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_CSR_4747
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_CSR_4747 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3040'                TO ACTIVE-PARAGRAPH            
              MOVE 'CHECK CLICK'         TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSR04747'            TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4747)                                                
      *       WITH PROCEDURE CSR04747                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_CSR_4747 CURSOR FOR RESULT SET            
      *       :LOC4747                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_CSR_4747 INTO                                
                 :RETURN-CODE-4747,                                     
                 :WORK-DISTRICT-OUT-4747                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WORK-DISTRICT-OUT-4747 TO S-WORK-DISTRICT       
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3040'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04747'            TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-EVALUATE.                                                
                                                                        
       3040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-UPDATE-ORDER-DATA.                                          
                                                                        
           MOVE  RETURN-CODE-1105    TO    S-RETURN-CODE-4              
           MOVE  ORDER-TYPE-CD-1105  TO S-ORDER-TYPE-CD-4               
           MOVE  ORDER-REASON-1105   TO S-ORDER-REASON                  
           MOVE  STATUS-TX-1105      TO S-STATUS-TX                     
           MOVE  ORDER-STATE-CD-1105 TO S-ORDER-STATE-CD                
           MOVE  ORDER-PLACED-BY-1105 TO S-ORDER-PLACED-BY              
           MOVE  PHONE-NO-1105   TO S-PHONE-NO                          
           MOVE  PHONE-NO-EXT-1105 TO S-PHONE-NO-EXT                    
           MOVE  WANTED-BY-DATETIME-1105 (1:10) TO S-WANTED-BY-DATE     
           MOVE  ASSIGNED-DATETIME-1105 (1:10) TO S-ASSIGNED-DATE       
           MOVE  CALL-BEFORE-MINUTS-1105 TO S-CALL-BEFORE-MINUTS        
           MOVE  WORK-AREA-ID-1105 TO S-WORK-AREA-ID                    
           MOVE  BREAKERS-OFF-IND-1105 TO S-BREAKERS-OFF-IND            
           MOVE  INIT-BY-CNTRCT-IND-1105 TO S-INIT-BY-CNTRCT-IND        
           MOVE  NOTIFY-CSR-IND-1105 TO S-NOTIFY-CSR-IND                
           MOVE  NOTIFY-CUST-IND-1105 TO S-NOTIFY-CUST-IND              
           MOVE  ORDER-PRIORITY-CD-1105 TO S-ORDER-PRIORITY-CD          
           MOVE  STD-LABOR-CHRG-1105 TO S-STD-LABOR-CHRG                
           MOVE  WORK-TYPE-CD-1105 TO S-WORK-TYPE-CD-4                  
           MOVE  BACK-DATED-IND-1105 TO S-BACK-DATED-IND                
           MOVE  DEPOSIT-AMT-1105 TO S-DEPOSIT-AMT                      
           MOVE  ORDER-RECVED-BY-1105 TO S-ORDER-RECVED-BY              
           MOVE  VERIFY-RATE-1105 TO S-VERIFY-RATE                      
           MOVE  PREMISE-NO-1105 TO S-PREMISE-NO                        
           MOVE  ACCOUNT-NO-1105 TO S-ACCOUNT-NO                        
           MOVE  ACCOUNT-NO-PRIOR-1105 TO S-ACCOUNT-NO-PRIOR            
           MOVE  BEGIN-APPT-DATE-1105 TO S-BEGIN-APPT-DATE              
           MOVE  SO-EST-LABOR-HR-1105 TO S-SO-EST-LABOR-HR              
           MOVE  CUSTCHG-ORD-TYPE-FL-1105 TO S-CUSTCHG-ORD-TYPE-FL      
           MOVE  AMOUNT-DISC-BAL-1105 TO S-AMOUNT-DISC-BAL              
           MOVE  CURRENT-DATE-1105 TO   S-CURRENT-DATE                  
           MOVE  CODE-UTIL-TYPE-1105 TO S-CODE-UTIL-TYPE-4              
           MOVE  PRICE-PER-SERV-1105 TO S-PRICE-PER-SERV                
           MOVE  ACCOUNT-TYPE-DESC-1105 TO S-ACCOUNT-TYPE-DESC          
           MOVE  ORDER-CHARGE-AMT-1105 TO S-ORDER-CHARGE-AMT            
           MOVE  TOTAL-CHARGES-AMT-1105 TO S-TOTAL-CHARGES-AMT          
           MOVE  CUST-CNT-ID-1105 TO S-CUST-CNT-ID                      
           MOVE  MTR-ACCESSIBLE-CD-1105 TO S-MTR-ACCESSIBLE-CD          
           MOVE  MTR-ACCESSIBLE-DT-1105 TO S-MTR-ACCESSIBLE-DT          
           MOVE  MTR-ACCESSIBLE-RSN-1105 TO S-MTR-ACCESSIBLE-RSN        
           MOVE  SOURCE-SYSTEM-CD-1105 TO S-SOURCE-SYSTEM-CD-4.         
           MOVE  ALT-PHONE-NO-1105 TO S-ALT-PHONE-NO                    
           MOVE  ALT-PHONE-NO-EXT-1105 TO S-ALT-PHONE-NO-EXT            
           MOVE  HOME-ALL-DAY-FL-1105 TO S-HOME-ALL-DAY-FL              
           MOVE  BUSINESS-UNIT-1105 TO S-BUSINESS-UNIT                  
           MOVE  OPTIMIZE-ORDER-1105 TO S-OPTIMIZE-ORDER.               
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
DT9459 5010-BUILD-BILL-ADDR.                                            
DT9459      EVALUATE AT-ADDRESS-FORMAT                                  
DT9459         WHEN 'A'                                                 
DT9459             PERFORM 7010-FMT-BILLADDR THRU 7010-EXIT             
DT9459         WHEN 'B'                                                 
DT9459             PERFORM 7015-FF-BILLADDR THRU 7015-EXIT              
DT9459         WHEN OTHER                                               
DT9459             MOVE SPACES TO S-BILL-ADDRESS                        
DT9459             INITIALIZE S-ADDRESS-DATA                            
DT9459      END-EVALUATE.                                               
                                                                        
DT9459 5010-EXIT.                                                       
DT9459      EXIT.                                                       
      ****************************************************************          
      **  CALL CSR01243 TO GET SO_ACCT_XFER DATA FOR EXISTING ORDER **          
      ****************************************************************          
                                                                        
       3025-CALL-CSR01243.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-1243.               
           MOVE LINK-CURRENT-HISTORY-FL TO CURRENT-HISTORY-FL-1243.     
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01243                                             
      *           (:SERV-ORDER-NO-1243,                                 
      *            :CURRENT-HISTORY-FL-1243)                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1243
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1243
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1243 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3025'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01243'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1243)                                                
      *       WITH PROCEDURE CSR01243                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1243 CURSOR FOR RESULT SET        
      *       :LOC1243                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1243 INTO                            
                   :RETURN-CODE-1243,                                   
                   :TO-ACCT-NO-1243,                                    
                   :ROOMMATE-XFER-IND-1243,                             
                   :EPP-XFER-IND-1243,                                  
                   :DEPOSIT-XFER-IND-1243,                              
                   :OTHER-AR-XFER-IND-1243,                             
                   :PROJ-SHR-XFER-IND-1243,                             
                   :WRITE-OFF-XFER-IND-1243,                            
                   :IN-LIEU-XFER-IND-1243,                              
                   :WHT-CROSS-XFER-IND-1243,                            
                   :COAPPL-XFER-IND-1243,                               
                   :MED-CERT-XFER-IND-1243,                             
                   :NAME-FORMAT-1243,                                   
                   :FIRST-NAME-1243,                                    
                   :MIDDLE-NAME-1243,                                   
                   :LAST-NAME-1243,                                     
                   :FULL-NAME-1243,                                     
                   :HOUSE-NO-1243,                                      
                   :ADDR-PREFIX-1-1243,                                 
                   :ADDR-PREFIX-2-1243,                                 
                   :STREET-NAME-1243,                                   
                   :STREET-LOCATION-1-1243,                             
                   :STREET-LOCATION-2-1243,                             
                   :STREET-SUFFIX-1243,                                 
                   :CUSTOMER-FROM-1243                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1243 NOT = 0                          
                       MOVE RETURN-CODE-1243  TO                        
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3025'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01243'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE LINK-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
                   IF TO-ACCT-NO-1243 = 0                               
                      MOVE 100 TO RETURN-CODE-1243                      
                   END-IF                                               
                   PERFORM 5100-UPDATE-SO-XFER-DATA THRU 5100-EXIT      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3025'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01243'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3025-EXIT.                                                       
            EXIT.                                                       
                                                                        
       3026-CALL-CSR00181.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-0181.               
           MOVE TO-ACCT-NO-1243  TO TO-ACCOUNT-NO-0181.                 
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR00181                                             
      *           (:TO-ACCOUNT-NO-0181,                                 
      *            :SERV-ORDER-NO-0181)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_0181
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_0181
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_0181 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3026'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR00181'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC0181)                                                
      *       WITH PROCEDURE CSR00181                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_0181 CURSOR FOR RESULT SET        
      *       :LOC0181                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
              EXEC SQL                                                  
                 FETCH RESULT_SET_CSR_0181 INTO                         
                      :RETURN-CODE-0181,                                
                      :CONTRACT-ID-0181                                 
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
              EVALUATE WS-ACTIVE-RETURN-CODE                            
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-0181 = +100                         
                       SET NO-MORE-ROWS TO TRUE                         
                     ELSE                                               
                       IF RETURN-CODE-0181 NOT = 0                      
                         MOVE RETURN-CODE-0181  TO                      
                                                 WS-ACTIVE-RETURN-CODE  
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '3026'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR00181'        TO TABLE-1              
                         MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1      
                         MOVE LINK-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1   
                         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT  
                         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT  
                       END-IF                                           
                    END-IF                                              
                    MOVE RETURN-CODE-0181 TO S-RETURN-CODE-8            
                    MOVE CONTRACT-ID-0181 TO S-CONTRACT-ID-8            
                    IF WS-GTT08-DECLARED = 'N'                          
                       PERFORM 0108-DECLARE-GTT08 THRU 0108-EXIT        
                    END-IF                                              
                    PERFORM 8800-SEND-RESULT-8 THRU 8800-EXIT           
                 WHEN NOT-FOUND                                         
                    SET NO-MORE-ROWS TO TRUE                            
                    MOVE 0 TO WS-ACTIVE-RETURN-CODE                     
                 WHEN OTHER                                             
                    MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
                    MOVE '3026'                TO ACTIVE-PARAGRAPH      
                    MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE 'CSR00181'            TO TABLE-1               
                    MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1       
                    MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1     
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
             END-EVALUATE                                               
           END-PERFORM.                                                 
                                                                        
       3026-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ****************************************************************          
      **  CALL CSR01204 TO GET SO_FINAL_BILL INFO FOR EXISTING ORDER *          
      ****************************************************************          
                                                                        
       3030-CALL-CSR01204.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-1204.               
           MOVE LINK-CURRENT-HISTORY-FL TO CURRENT-HISTORY-FL-1204.     
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR01204                                             
      *           (:SERV-ORDER-NO-1204,                                 
      *            :CURRENT-HISTORY-FL-1204)                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_1204
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_1204
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_1204 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '3030'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR01204'            TO TABLE-1                     
              MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1             
              MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC1204)                                                
      *       WITH PROCEDURE CSR01204                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_1204 CURSOR FOR RESULT SET        
      *       :LOC1204                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_1204 INTO                            
                  :ACCOUNT-NO-PRIOR-1204,                               
                  :SERV-ORDER-NO-R-1204,                                
                  :WANTED-BY-DATETIME-1204,                             
                  :CREDIT-LETTER-IND-1204 :WS-FBILL-NULL1,               
                  :STREET-LOCATION-1-1204 :WS-FBILL-NULL2,               
                  :STREET-LOCATION-2-1204 :WS-FBILL-NULL3,               
                  :ADDR-ST-1204 :WS-FBILL-NULL4,                         
                  :ADDR-ZIP-CODE-1204 :WS-FBILL-NULL5,                   
                  :ADDR-PREFIX-1-1204 :WS-FBILL-NULL6,                   
                  :ADDR-PREFIX-2-1204 :WS-FBILL-NULL7,                   
                  :ADDR-SUFFIX-1204 :WS-FBILL-NULL8,                     
                  :ADDRESS-OVERFLOW-1204 :WS-FBILL-NULL9,                
                  :HOUSE-NO-1204 :WS-FBILL-NULL10,                       
                  :ADDRESS-FORMAT-1204 :WS-FBILL-NULL11,                 
                  :STREET-NAME-1204 :WS-FBILL-NULL12,                    
                  :STREET-SUFFIX-1204 :WS-FBILL-NULL13,                  
                  :ZIP-CODE-1204 :WS-FBILL-NULL14,                       
                  :ZIP-CODE-PLUS-FOUR-1204 :WS-FBILL-NULL15,             
                  :ZIP-CODE-TOKEN-1204 :WS-FBILL-NULL16,                 
                  :SEND-TO-LOCOFF-IND-1204 :WS-FBILL-NULL17,             
                  :ADDR-COUNTRY-1204 :WS-FBILL-NULL18,                   
                  :CARRIER-ROUTE-1204 :WS-FBILL-NULL19,                  
                  :FINAL-BILL-CY-ST-1204 :WS-FBILL-NULL20,               
                  :FINAL-BILL-OVFL-1204 :WS-FBILL-NULL21,                
                  :DEPOSIT-AMT-1204                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-1204 NOT = 0                          
                       MOVE RETURN-CODE-1204  TO                        
                                                 WS-ACTIVE-RETURN-CODE  
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '3030'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR01204'        TO TABLE-1                
                       MOVE 'SERV_ORDER_NO'   TO TABLE-ELEMENT-1        
                       MOVE LINK-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1     
                       PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
                   END-IF                                               
                   IF WS-FBILL-NULL1 < 0                                
                     MOVE SPACES TO CREDIT-LETTER-IND-1204              
                   END-IF                                               
                   IF WS-FBILL-NULL2 < 0                                
                     MOVE SPACES TO STREET-LOCATION-1-1204              
                   END-IF                                               
                   IF WS-FBILL-NULL3 < 0                                
                     MOVE SPACES TO STREET-LOCATION-2-1204              
                   END-IF                                               
                   IF WS-FBILL-NULL4 < 0                                
                     MOVE SPACES TO ADDR-ST-1204                        
                   END-IF                                               
                   IF WS-FBILL-NULL5 < 0                                
                     MOVE SPACES TO ADDR-ZIP-CODE-1204                  
                   END-IF                                               
                   IF WS-FBILL-NULL6 < 0                                
                     MOVE SPACES TO ADDR-PREFIX-1-1204                  
                   END-IF                                               
                   IF WS-FBILL-NULL7 < 0                                
                     MOVE SPACES TO ADDR-PREFIX-2-1204                  
                   END-IF                                               
                   IF WS-FBILL-NULL8 < 0                                
                     MOVE SPACES TO ADDR-SUFFIX-1204                    
                   END-IF                                               
                   IF WS-FBILL-NULL9 < 0                                
                     MOVE SPACES TO ADDRESS-OVERFLOW-1204               
                   END-IF                                               
                   IF WS-FBILL-NULL10 < 0                               
                     MOVE SPACES TO HOUSE-NO-1204                       
                   END-IF                                               
                   IF WS-FBILL-NULL11 < 0                               
                     MOVE SPACES TO ADDRESS-FORMAT-1204                 
                   END-IF                                               
                   IF WS-FBILL-NULL12 < 0                               
                     MOVE SPACES TO STREET-NAME-1204                    
                   END-IF                                               
                   IF WS-FBILL-NULL13 < 0                               
                     MOVE SPACES TO STREET-SUFFIX-1204                  
                   END-IF                                               
                   IF WS-FBILL-NULL14 < 0                               
                     MOVE SPACES TO ZIP-CODE-1204                       
                   END-IF                                               
                   IF WS-FBILL-NULL15 < 0                               
                     MOVE SPACES TO ZIP-CODE-PLUS-FOUR-1204             
                   END-IF                                               
                   IF WS-FBILL-NULL16 < 0                               
                     MOVE SPACES TO ZIP-CODE-TOKEN-1204                 
                   END-IF                                               
                   IF WS-FBILL-NULL17 < 0                               
                     MOVE SPACES TO SEND-TO-LOCOFF-IND-1204             
                   END-IF                                               
                   IF WS-FBILL-NULL18 < 0                               
                     MOVE SPACES TO ADDR-COUNTRY-1204                   
                   END-IF                                               
                   IF WS-FBILL-NULL19 < 0                               
                     MOVE SPACES TO CARRIER-ROUTE-1204                  
                   END-IF                                               
                   IF WS-FBILL-NULL20 < 0                               
                     MOVE SPACES TO FINAL-BILL-CY-ST-1204               
                   END-IF                                               
                   IF WS-FBILL-NULL21 < 0                               
                     MOVE SPACES TO FINAL-BILL-OVFL-1204                
                   END-IF                                               
                   MOVE SPACES TO WS-FB-ADDR-LINE                       
                                  WS-FB-ADDR-TYPE                       
                   IF  SERV-ORDER-NO-R-1204 <= SPACES                   
                          MOVE 100 TO RETURN-CODE-1204                  
                   END-IF                                               
                   IF ADDRESS-FORMAT-1204 = 'A'                         
                      PERFORM 5130-COMPARE-PREM-ADDRESS THRU 5130-EXIT  
                   ELSE IF ADDRESS-FORMAT-1204 = 'B'                    
                           PERFORM 7815-FORMAT-FF-FB-ADDR THRU          
                                                           7815-EXIT    
                           MOVE 'N' TO WS-FB-ADDR-TYPE                  
                           MOVE WS-ADDRESS-LINE TO WS-FB-ADDR-LINE      
DT9459*                ELSE                                                     
DT9459*                    MOVE 'S' TO WS-FB-ADDR-TYPE                          
                       END-IF                                           
                   END-IF                                               
                   PERFORM 5150-UPDATE-SO-FBILL-DATA THRU 5150-EXIT     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '3030'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR01204'            TO TABLE-1                
                   MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
                   MOVE LINK-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       3030-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5100-UPDATE-SO-XFER-DATA.                                        
                                                                        
           MOVE RETURN-CODE-1243         TO    S-RETURN-CODE-6.         
           MOVE TO-ACCT-NO-1243          TO S-TO-ACCT-NO-6.             
           MOVE ROOMMATE-XFER-IND-1243   TO S-ROOMMATE-XFER-IND-6.      
           MOVE EPP-XFER-IND-1243        TO S-EPP-XFER-IND-6.           
           MOVE DEPOSIT-XFER-IND-1243    TO S-DEPOSIT-XFER-IND-6.       
           MOVE OTHER-AR-XFER-IND-1243   TO S-OTHER-AR-XFER-IND-6.      
           MOVE PROJ-SHR-XFER-IND-1243   TO S-PROJ-SHR-XFER-IND-6.      
           MOVE WRITE-OFF-XFER-IND-1243  TO S-WRITE-OFF-XFER-IND-6.     
           MOVE IN-LIEU-XFER-IND-1243    TO S-IN-LIEU-XFER-IND-6.       
           MOVE WHT-CROSS-XFER-IND-1243  TO S-WHT-CROSS-XFER-IND-6.     
           MOVE COAPPL-XFER-IND-1243     TO S-COAPPL-XFER-IND-6.        
           MOVE MED-CERT-XFER-IND-1243   TO S-MED-CERT-XFER-IND-6.      
           MOVE NAME-FORMAT-1243         TO S-NAME-FORMAT-6.            
           MOVE FIRST-NAME-1243          TO S-FIRST-NAME-6.             
           MOVE MIDDLE-NAME-1243         TO S-MIDDLE-NAME-6.            
           MOVE LAST-NAME-1243           TO S-LAST-NAME-6.              
           MOVE FULL-NAME-1243           TO S-FULL-NAME-6.              
           MOVE HOUSE-NO-1243            TO S-HOUSE-NO-6.               
           MOVE ADDR-PREFIX-1-1243       TO S-ADDR-PREFIX-1-6.          
           MOVE ADDR-PREFIX-2-1243       TO S-ADDR-PREFIX-2-6.          
           MOVE STREET-NAME-1243         TO S-STREET-NAME-6.            
           MOVE STREET-LOCATION-1-1243   TO S-STREET-LOCATION-1-6.      
           MOVE STREET-LOCATION-2-1243   TO S-STREET-LOCATION-2-6.      
           MOVE STREET-SUFFIX-1243       TO S-STREET-SUFFIX-6.          
           MOVE CUSTOMER-FROM-1243       TO S-CUSTOMER-FROM-6.          
                                                                        
       5100-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
       5130-COMPARE-PREM-ADDRESS.                                       
           MOVE PR-ADDRESS-ID TO DY-ADDRESS-ID.                         
           PERFORM 7800-FORMATTED-ADDRESS THRU 7800-EXIT.               
           IF HOUSE-NO-1204      =       DY-HOUSE-NO AND                
              ADDR-PREFIX-1-1204 =       DY-ADDR-PREFIX-1 AND           
              ADDR-PREFIX-2-1204 =       DY-ADDR-PREFIX-2 AND           
              STREET-NAME-1204 =         DY-STREET-NAME AND             
              STREET-SUFFIX-1204 =       DY-STREET-SUFFIX AND           
              ADDR-SUFFIX-1204 =         DY-ADDR-SUFFIX AND             
              STREET-LOCATION-1-1204 =   DY-STREET-LOCATION-1 AND       
              STREET-LOCATION-2-1204 =   DY-STREET-LOCATION-2 AND       
              ZIP-CODE-1204          =   DY-ZIP-CODE   AND              
              ZIP-CODE-TOKEN-1204    =   DY-ZIP-CODE-TOKEN              
                MOVE 'S' TO WS-FB-ADDR-TYPE                             
           ELSE                                                         
                MOVE 'N' TO WS-FB-ADDR-TYPE                             
                PERFORM 7810-FORMAT-FR-FB-ADDR  THRU 7810-EXIT          
                MOVE WS-ADDRESS-LINE TO WS-FB-ADDR-LINE                 
           END-IF.                                                      
       5130-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5150-UPDATE-SO-FBILL-DATA.                                       
                                                                        
           MOVE  RETURN-CODE-1204        TO    S-RETURN-CODE-7.         
           MOVE ACCOUNT-NO-PRIOR-1204    TO S-ACCOUNT-NO-PRIOR-7.       
           MOVE SERV-ORDER-NO-R-1204     TO S-SERV-ORDER-NO-7.          
           MOVE WANTED-BY-DATETIME-1204  TO S-WANTED-BY-DATETIME-7.     
           MOVE CREDIT-LETTER-IND-1204   TO S-CREDIT-LETTER-IND-7.      
           MOVE STREET-LOCATION-1-1204   TO S-STREET-LOCATION-1-7.      
           MOVE STREET-LOCATION-2-1204   TO S-STREET-LOCATION-2-7.      
           MOVE ADDR-ST-1204             TO S-ADDR-ST-7.                
           MOVE ADDR-ZIP-CODE-1204       TO S-ADDR-ZIP-CODE-7.          
           MOVE ADDR-PREFIX-1-1204       TO S-ADDR-PREFIX-1-7.          
           MOVE ADDR-PREFIX-2-1204       TO S-ADDR-PREFIX-2-7.          
           MOVE ADDR-SUFFIX-1204         TO S-ADDR-SUFFIX-7.            
           MOVE ADDRESS-OVERFLOW-1204    TO S-ADDRESS-OVERFLOW-7.       
           MOVE HOUSE-NO-1204            TO S-HOUSE-NO-7.               
           MOVE ADDRESS-FORMAT-1204      TO S-ADDRESS-FORMAT-7.         
           MOVE STREET-NAME-1204         TO S-STREET-NAME-7.            
           MOVE STREET-SUFFIX-1204       TO S-STREET-SUFFIX-7.          
           MOVE ZIP-CODE-1204            TO S-ZIP-CODE-7.               
           MOVE ZIP-CODE-PLUS-FOUR-1204  TO S-ZIP-CODE-PLUS-FOUR-7.     
           MOVE ZIP-CODE-TOKEN-1204      TO S-ZIP-CODE-TOKEN-7.         
           MOVE SEND-TO-LOCOFF-IND-1204  TO S-SEND-TO-LOCOFF-IND-7.     
           MOVE ADDR-COUNTRY-1204        TO S-ADDR-COUNTRY-7.           
           MOVE CARRIER-ROUTE-1204       TO S-CARRIER-ROUTE-7.          
           MOVE FINAL-BILL-CY-ST-1204    TO S-FINAL-BILL-CY-ST-7.       
           MOVE FINAL-BILL-OVFL-1204     TO S-FINAL-BILL-OVFL-7.        
           MOVE DEPOSIT-AMT-1204         TO S-DEPOSIT-AMT-7.            
DT9498     IF WS-FB-ADDR-TYPE <= SPACES                                 
              IF S-BILL-ADDRESS > SPACES                                
                 MOVE 'B' TO WS-FB-ADDR-TYPE                            
DT9459        ELSE                                                      
DT9459           MOVE 'S' TO WS-FB-ADDR-TYPE                            
              END-IF                                                    
DT9498     END-IF                                                       
           MOVE WS-FB-ADDR-TYPE          TO S-FB-ADDR-TYPE-7.           
           MOVE WS-FB-ADDR-LINE          TO S-FB-ADDR-LINE-7.           
       5150-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT SPCL_READ_INSTR,                                  
                      SPCL_INSTRUCTIONS,                                
                      PREMISE_DIRECTIONS,                               
                      SCRATCH_PAD,                                      
                      CODE_RENTAL_PROP,                                 
                      COMPANY_NO,                                       
                      SUBDIVISION_ID,                                   
                      ADDRESS_ID                                        
                 INTO :PR-SPCL-READ-INSTR,                              
                      :PR-SPCL-INSTRUCTIONS,                            
                      :PR-PREMISE-DIRECTIONS,                           
                      :PR-SCRATCH-PAD,                                  
                      :PR-CODE-RENTAL-PROP,                             
                      :PR-COMPANY-NO,                                   
                      :PR-SUBDIVISION-ID,                               
                      :PR-ADDRESS-ID                                    
                 FROM CSS_PREMISE WITH(READUNCOMMITTED)                         
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SPCL_READ_INSTR,                                  00010002
MFA-TR*               SPCL_INSTRUCTIONS,                                        
MFA-TR*               PREMISE_DIRECTIONS,                                       
MFA-TR*               SCRATCH_PAD,                                              
MFA-TR*               CODE_RENTAL_PROP,                                         
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               SUBDIVISION_ID,                                           
MFA-TR*               ADDRESS_ID                                                
MFA-TR*          INTO :PR-SPCL-READ-INSTR,                                      
MFA-TR*               :PR-SPCL-INSTRUCTIONS,                                    
MFA-TR*               :PR-PREMISE-DIRECTIONS,                                   
MFA-TR*               :PR-SCRATCH-PAD,                                          
MFA-TR*               :PR-CODE-RENTAL-PROP,                                     
MFA-TR*               :PR-COMPANY-NO,                                           
MFA-TR*               :PR-SUBDIVISION-ID,                                       
MFA-TR*               :PR-ADDRESS-ID                                            
MFA-TR*          FROM CSS_PREMISE                                       00130001
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                        00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE PR-SPCL-READ-INSTR-TEXT TO S-SPCL-READ-INST     
                   MOVE PR-SPCL-INSTRUCTIONS-TEXT TO S-SPCL-INST        
                   MOVE PR-PREMISE-DIRECTIONS-TEXT TO S-PREM-DIRECTIONS 
                   MOVE PR-SCRATCH-PAD-TEXT TO S-SCRATCHPAD             
                   MOVE PR-SUBDIVISION-ID TO S-SUBDIVISION-ID           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7000'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_PREMISE'      TO TABLE-1                   
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE PR-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_FORMAT,                                   
                      ADDRESS_ID,                                       
                      COMPANY_NO,                                       
                      CUSTOMER_NO,                                      
                      BILL_CYCLE,                                       
                      ACCOUNT_TYPE_CODE                                 
                 INTO :AT-ADDRESS-FORMAT,                               
                      :AT-ADDRESS-ID,                                   
                      :PR-COMPANY-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-BILL-CYCLE,                                   
                      :AT-ACCOUNT-TYPE-CODE                             
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_FORMAT,                                   00010002
MFA-TR*               ADDRESS_ID,                                       00020002
MFA-TR*               COMPANY_NO,                                       00020002
MFA-TR*               CUSTOMER_NO,                                      00020002
MFA-TR*               BILL_CYCLE,                                               
MFA-TR*               ACCOUNT_TYPE_CODE                                         
MFA-TR*          INTO :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :AT-ADDRESS-ID,                                           
MFA-TR*               :PR-COMPANY-NO,                                           
MFA-TR*               :AT-CUSTOMER-NO,                                          
MFA-TR*               :AT-BILL-CYCLE,                                           
MFA-TR*               :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*          FROM CSS_ACCOUNT                                       00130001
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-PROCESS = 'START'                              
                       MOVE WS-NEW-CUSTOMER-NO TO AT-CUSTOMER-NO        
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7005'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *  VALUE AFTER STREET LOC 2 IN CONCATENATION IS HEX 0A (NEWLINE)          
                                                                        
       7010-FMT-BILLADDR.                                               
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + CHAR(10) + LTRIM(RTRIM(TOWN) + 
           ', ' + LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE
           ) + ' ' + LTRIM(RTRIM(CASE DY.ZIP_CODE_PLUS_FOUR            
                                  WHEN '' THEN ''                       
                                  ELSE '- ' + DY.ZIP_CODE_PLUS_FOUR    
                                  END)))))))))))))),
              DY.ADDRESS_ID,
              HOUSE_NO,
              ADDR_PREFIX_1,
              ADDR_PREFIX_2,
              STREET_NAME,
              STREET_SUFFIX,
              ADDR_SUFFIX,
              STREET_LOCATION_1,
              STREET_LOCATION_2,
              DY.ZIP_CODE,
              ZIP_CODE_PLUS_FOUR,
              DY.ZIP_CODE_TOKEN,
              STATE                                             
                 INTO :WS-ADDRESS-LINE,                                 
                      :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :A4-STATE                                         
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                    
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
DT9459         WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                     
                 AND AT.ADDRESS_ID = DY.ADDRESS_ID                      
                 AND DY.ZIP_CODE = A4.ZIP_CODE                          
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||             00010002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||              00020002
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||              00030002
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                00040002
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||              00050002
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                00060002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||          00070002
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||           00080002
MFA-TR*               ' ' ||                                                    
MFA-TR*               BINCHAR(10) ||
MFA-TR*               LTRIM(RTRIM(TOWN) || ', ' ||                      00090006
MFA-TR*               LTRIM(RTRIM(STATE) || ' ' ||                      00100002
MFA-TR*               LTRIM(RTRIM(DY.ZIP_CODE) || ' ' ||                00110004
MFA-TR*               LTRIM(RTRIM(CASE DY.ZIP_CODE_PLUS_FOUR            00110004
MFA-TR*                           WHEN '' THEN ''                       00110004
MFA-TR*                           ELSE '- ' || DY.ZIP_CODE_PLUS_FOUR    00110004
MFA-TR*                           END)))))))))))))),                    00110004
MFA-TR*               DY.ADDRESS_ID,                                            
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               ZIP_CODE_PLUS_FOUR,                                       
MFA-TR*               DY.ZIP_CODE_TOKEN,                                        
MFA-TR*               STATE                                                     
MFA-TR*          INTO :WS-ADDRESS-LINE,                                         
MFA-TR*               :DY-ADDRESS-ID,                                           
MFA-TR*               :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                                   
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :A4-STATE                                                 
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            00130001
MFA-TR*               CSS_ZIP_CODE A4,                                  00140001
MFA-TR*               CSS_ACCOUNT AT                                    00150001
MFA-TR*        WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                     00160000
MFA-TR*          AND AT.ADDRESS_ID = DY.ADDRESS_ID                      00170000
MFA-TR*          AND DY.ZIP_CODE = A4.ZIP_CODE                          00180000
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              00190000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00200000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-ADDRESS-LINE TO S-BILL-ADDRESS               
                   MOVE DY-ADDRESS-ID TO S-ADDRESS-ID                   
                   MOVE DY-HOUSE-NO TO S-HOUSE-NO                       
                   MOVE DY-ADDR-PREFIX-1 TO S-ADDR-PREFIX-1             
                   MOVE DY-ADDR-PREFIX-2 TO S-ADDR-PREFIX-2             
                   MOVE DY-STREET-NAME TO S-STREET-NAME                 
                   MOVE DY-STREET-SUFFIX TO S-STREET-SUFFIX             
                   MOVE DY-ADDR-SUFFIX TO S-ADDR-SUFFIX                 
                   MOVE DY-STREET-LOCATION-1 TO S-STREET-LOCATION-1     
                   MOVE DY-STREET-LOCATION-2 TO S-STREET-LOCATION-2     
                   MOVE DY-ZIP-CODE TO S-ZIP-CODE                       
                   MOVE DY-ZIP-CODE-PLUS-FOUR TO S-ZIP-CODE-PLUS-FOUR   
                   MOVE DY-ZIP-CODE-TOKEN TO S-ZIP-CODE-TOKEN           
                   MOVE A4-STATE TO S-STATE                             
                   MOVE 'A' TO S-ADDRESS-FORMAT                         
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BILL-ADDRESS                        
                   INITIALIZE S-ADDRESS-DATA                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7010'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_PREMISE'      TO TABLE-1                   
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-3                 
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE WS-AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-FF-BILLADDR.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(ADDR_STREET) + ' ' + 
           LTRIM(RTRIM(ADDR_CITY_STATE) + ' ' + LTRIM(RTRIM(
           CIS.SUBSTR3(ADDR_ZIP_CODE,1,5)) + '-' + LTRIM(RTRIM(
           CIS.SUBSTR3(ADDR_ZIP_CODE,6,4)) + ' ' + LTRIM(RTRIM(
           ADDR_COUNTRY))))))),
              DZ.ADDRESS_ID,
              ADDR_STREET,
              ADDR_CITY_STATE,
              ADDR_ZIP_CODE,
              ADDR_COUNTRY,
              ADDR_STREET_2                                     
                 INTO :WS-ADDRESS-LINE,                                 
                      :DZ-ADDRESS-ID,                                   
                      :DZ-ADDR-STREET,                                  
                      :DZ-ADDR-CITY-STATE,                              
                      :DZ-ADDR-ZIP-CODE,                                
                      :DZ-ADDR-COUNTRY,                                 
                      :DZ-ADDR-STREET-2                                 
                 FROM CSS_ADDR_FREEFORM DZ WITH(READUNCOMMITTED),               
                      CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
DT9459         WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                     
                 AND AT.ADDRESS_ID = DZ.ADDRESS_ID                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(ADDR_STREET) || ' ' ||          00010002
MFA-TR*               LTRIM(RTRIM(ADDR_CITY_STATE) || ' ' ||            00020002
MFA-TR*               LTRIM(RTRIM(SUBSTR(ADDR_ZIP_CODE,1,5)) || '-' ||  00030002
MFA-TR*               LTRIM(RTRIM(SUBSTR(ADDR_ZIP_CODE,6,4)) || ' ' ||  00030002
MFA-TR*               LTRIM(RTRIM(ADDR_COUNTRY))))))),                  00040002
MFA-TR*               DZ.ADDRESS_ID,                                            
MFA-TR*               ADDR_STREET,                                              
MFA-TR*               ADDR_CITY_STATE,                                          
MFA-TR*               ADDR_ZIP_CODE,                                            
MFA-TR*               ADDR_COUNTRY,                                             
MFA-TR*               ADDR_STREET_2                                             
MFA-TR*          INTO :WS-ADDRESS-LINE,                                         
MFA-TR*               :DZ-ADDRESS-ID,                                           
MFA-TR*               :DZ-ADDR-STREET,                                          
MFA-TR*               :DZ-ADDR-CITY-STATE,                                      
MFA-TR*               :DZ-ADDR-ZIP-CODE,                                        
MFA-TR*               :DZ-ADDR-COUNTRY,                                         
MFA-TR*               :DZ-ADDR-STREET-2                                         
MFA-TR*          FROM CSS_ADDR_FREEFORM DZ,                             00130001
MFA-TR*               CSS_ACCOUNT AT                                    00150001
MFA-TR*        WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                     00160000
MFA-TR*          AND AT.ADDRESS_ID = DZ.ADDRESS_ID                      00170000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00200000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-ADDRESS-LINE = '-'                             
                       MOVE SPACES TO WS-ADDRESS-LINE                   
                       INITIALIZE S-ADDRESS-DATA                        
                   END-IF                                               
                   IF DZ-ADDR-COUNTRY > ' '                             
                       INSPECT WS-ADDRESS-LINE REPLACING                
                           ALL ' -' BY '  '                             
                   END-IF                                               
                   MOVE WS-ADDRESS-LINE TO S-BILL-ADDRESS               
                   MOVE DZ-ADDRESS-ID TO S-ADDRESS-ID                   
                   MOVE DZ-ADDR-STREET TO S-ADDR-STREET                 
                   MOVE DZ-ADDR-CITY-STATE TO S-ADDR-CITY-STATE         
                   MOVE DZ-ADDR-ZIP-CODE TO S-ADDR-ZIP-CODE             
                   MOVE DZ-ADDR-COUNTRY TO S-ADDR-COUNTRY               
                   MOVE DZ-ADDR-STREET-2 TO S-ADDR-STREET-2             
                   MOVE 'B' TO S-ADDRESS-FORMAT                         
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BILL-ADDRESS                        
                   INITIALIZE S-ADDRESS-DATA                            
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7015'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_PREMISE'      TO TABLE-1                   
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-2                  
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE WS-AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
DT9459 7020-GET-BILL-ADDR-ID.                                           
DT9459                                                                  
DT9459     EXEC SQL                                                     
DT9459         SELECT ADDRESS_FORMAT,                                   
DT9459                ADDRESS_ID                                        
DT9459           INTO :AT-ADDRESS-FORMAT,                               
DT9459                :AT-ADDRESS-ID                                    
DT9459           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
DT9459         WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                     
DT9459                                                           
DT9459                                                      
DT9459     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_FORMAT,                                   00010002
MFA-TR*               ADDRESS_ID                                        00020002
MFA-TR*          INTO :AT-ADDRESS-FORMAT,                                       
MFA-TR*               :AT-ADDRESS-ID                                            
MFA-TR*          FROM CSS_ACCOUNT                                       00130001
MFA-TR*        WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO                     00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DT9459                                                                  
DT9459     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
DT9459                                                                  
DT9459     EVALUATE WS-ACTIVE-RETURN-CODE                               
DT9459         WHEN SUCCESSFUL-CALL                                     
DT9459             CONTINUE                                             
DT9459         WHEN OTHER                                               
DT9459             MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
DT9459             MOVE '7020'             TO ACTIVE-PARAGRAPH          
DT9459             MOVE 'SELECT'           TO ABEND-FUNCTION            
DT9459             MOVE SPACES             TO ABEND-SQL-PREDICATES      
DT9459                                        ABEND-TABLES              
DT9459             MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
DT9459             MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
DT9459             MOVE WS-AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1      
DT9459             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
DT9459     END-EVALUATE.                                                
                                                                        
DT9459 7020-EXIT.                                                       
DT9459     EXIT.                                                        
                                                                        
       7030-OPEN-CONTACT-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN CONTACT-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7030'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_CONT_MATRIX' TO TABLE-1                 
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
                   MOVE 3C-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
                   MOVE 3C-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-CLOSE-CONTACT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE CONTACT-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7040'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_CONT_MATRIX' TO TABLE-1                 
                   MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1          
                   MOVE 3C-COMPANY-NO       TO HOSTVAR-ELEMENT-1        
                   MOVE 'ORDER_TYPE_CD'     TO TABLE-ELEMENT-2          
                   MOVE 3C-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-2        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-OPEN-ALL-CONTACTS-CURSOR.                                   
                                                                        
           EXEC SQL                                                     
               OPEN ALL-CONTACTS-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7050'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT'       TO TABLE-1                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE WS-OLD-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-CLOSE-ALL-CONTACTS-CURSOR.                                  
                                                                        
           EXEC SQL                                                     
               CLOSE ALL-CONTACTS-CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7060'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT'       TO TABLE-1                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE WS-OLD-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-CUSTOMER-NAME.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(RTRIM(LAST_NAME) + ' ' + RTRIM(
           TITLE_SUFFIX_1)) + ', ' + RTRIM(FIRST_NAME) + ' ' + RTRIM(
           MIDDLE_NAME),
              FULL_NAME,
              NAME_FORMAT                                       
                 INTO :WS-CUST-NAME,                                    
                      :DQ-FULL-NAME,                                    
                      :DQ-NAME-FORMAT                                   
                 FROM CSS_CUSTOMER CU WITH(READUNCOMMITTED),                    
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                  AND CU.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(RTRIM(LAST_NAME) ||                                 
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(TITLE_SUFFIX_1)) ||                                 
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME),                                       
MFA-TR*               FULL_NAME,                                                
MFA-TR*               NAME_FORMAT                                               
MFA-TR*          INTO :WS-CUST-NAME,                                            
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NAME-FORMAT                                           
MFA-TR*          FROM CSS_CUSTOMER CU,                                          
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*           AND CU.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DQ-NAME-FORMAT = 'B'                              
                       MOVE DQ-FULL-NAME TO WS-NAME                     
                   ELSE                                                 
                       MOVE WS-CUST-NAME TO WS-NAME                     
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-NAME                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUSTOMER'   TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-EMAIL-ADDRESS.                                              
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) EMAIL_ADDRESS_TX                                  
                 INTO :NE-EMAIL-ADDRESS-TX                              
                 FROM CSS_CUST_EMAIL WITH(READUNCOMMITTED)                      
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT EMAIL_ADDRESS_TX                                          
MFA-TR*          INTO :NE-EMAIL-ADDRESS-TX                                      
MFA-TR*          FROM CSS_CUST_EMAIL                                            
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE NE-EMAIL-ADDRESS-TX-TEXT TO S-EMAIL-ADDRESS     
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO S-EMAIL-ADDRESS                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_EMAIL' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-SPOUSE-NAME.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LAST_NAME) + ', ' + RTRIM(FIRST_NAME
           ) + ' ' + RTRIM(MIDDLE_NAME)                                
                 INTO :WS-SPOUSE-NAME                                   
                 FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                  
                      CSS_NAME DQ WITH(READUNCOMMITTED)                         
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                     
                  AND CUSTOMER_TYPE = 'S'                               
                  AND CE.NAME_ID = DQ.NAME_ID                           
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LAST_NAME) ||                                       
MFA-TR*               ', ' ||                                                   
MFA-TR*               RTRIM(FIRST_NAME) ||                                      
MFA-TR*               ' ' ||                                                    
MFA-TR*               RTRIM(MIDDLE_NAME)                                        
MFA-TR*          INTO :WS-SPOUSE-NAME                                           
MFA-TR*          FROM CSS_CUST_STATS CE,                                        
MFA-TR*               CSS_NAME DQ                                               
MFA-TR*         WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                             
MFA-TR*           AND CUSTOMER_TYPE = 'S'                                       
MFA-TR*           AND CE.NAME_ID = DQ.NAME_ID                                   
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-SPOUSE-NAME TO WS-NAME                       
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE SPACES TO WS-NAME                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CSS_NAME'       TO TABLE-2                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE AT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7210-METER-TURNOFF.                                              
                                                                        
           EXEC SQL                                                     
               SELECT MTR_TURNOFF_RSN_CD,                               
                      FUEL_CHNG_RSN_CD,                                 
                      FUEL_CHNG_TYPE_CD,                                
                      COMMENTS                                          
                 INTO :YT-MTR-TURNOFF-RSN-CD,                           
                      :YT-FUEL-CHNG-RSN-CD,                             
                      :YT-FUEL-CHNG-TYPE-CD,                            
                      :YT-COMMENTS                                      
                 FROM CSS_METER_TURNOFF YT WITH(READUNCOMMITTED)                
               WHERE YT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
                 AND YT.SERV_ORDER_NO = :YT-SERV-ORDER-NO               
                 AND YT.CODE_UTIL_TYPE = 'G'                            
                 AND CREATED_TS =                                       
                  (SELECT MAX(YT1.CREATED_TS)                           
                     FROM CSS_METER_TURNOFF YT1 WITH(READUNCOMMITTED)           
                    WHERE YT.ACCOUNT_NO = YT1.ACCOUNT_NO                
                      AND YT.SERV_ORDER_NO = YT1.SERV_ORDER_NO          
                      AND YT1.CODE_UTIL_TYPE = 'G')                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MTR_TURNOFF_RSN_CD,                               00010002
MFA-TR*               FUEL_CHNG_RSN_CD,                                 00020002
MFA-TR*               FUEL_CHNG_TYPE_CD,                                00020002
MFA-TR*               COMMENTS                                          00020002
MFA-TR*          INTO :YT-MTR-TURNOFF-RSN-CD,                                   
MFA-TR*               :YT-FUEL-CHNG-RSN-CD,                                     
MFA-TR*               :YT-FUEL-CHNG-TYPE-CD,                                    
MFA-TR*               :YT-COMMENTS                                              
MFA-TR*          FROM CSS_METER_TURNOFF YT                              00130001
MFA-TR*        WHERE YT.ACCOUNT_NO = :AT-ACCOUNT-NO                     00160000
MFA-TR*          AND YT.SERV_ORDER_NO = :YT-SERV-ORDER-NO               00160000
MFA-TR*          AND YT.CODE_UTIL_TYPE = 'G'                            00160000
MFA-TR*          AND CREATED_TS =                                       00160000
MFA-TR*           (SELECT MAX(YT1.CREATED_TS)                           00160000
MFA-TR*              FROM CSS_METER_TURNOFF YT1                         00160000
MFA-TR*             WHERE YT.ACCOUNT_NO = YT1.ACCOUNT_NO                00160000
MFA-TR*               AND YT.SERV_ORDER_NO = YT1.SERV_ORDER_NO          00160000
MFA-TR*               AND YT1.CODE_UTIL_TYPE = 'G')                     00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE YT-MTR-TURNOFF-RSN-CD TO S-MTR-TURNOFF-RSN-CD   
                   MOVE YT-FUEL-CHNG-RSN-CD TO S-FUEL-CHNG-RSN-CD       
                   MOVE YT-FUEL-CHNG-TYPE-CD TO S-FUEL-CHNG-TYPE-CD     
                   MOVE YT-COMMENTS TO S-TURNOFF-COMMENTS               
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-MTR-TURNOFF-RSN-CD                  
                   MOVE SPACES TO S-FUEL-CHNG-RSN-CD                    
                   MOVE SPACES TO S-FUEL-CHNG-TYPE-CD                   
                   MOVE SPACES TO S-TURNOFF-COMMENTS                    
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7005'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_ACCOUNT'      TO TABLE-1                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7300-OPEN-COAPP-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               OPEN COAPP-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7300'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_COAPPLICANT'   TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-CLOSE-COAPP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE COAPP-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7310'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_COAPPLICANT'   TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-OPEN-PA-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN PA-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7400'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7410-CLOSE-PA-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE PA-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7410'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7450-OPEN-MP-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN MP-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7450'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7460-CLOSE-MP-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE MP-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7410'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-OPEN-TA-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
               OPEN TA-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7500'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-CLOSE-TA-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
               CLOSE TA-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7510'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_CONTACT_CUST'  TO TABLE-1                  
                   MOVE 'CSS_CONTACT'       TO TABLE-2                  
                   MOVE 'CSS_NAME'          TO TABLE-3                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE AT-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-OPEN-APPL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN APPL-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7600'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7610-CLOSE-APPL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE APPL-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7610'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_APPLIANCE'     TO TABLE-1                  
                   MOVE 'CSS_MKT_APPLIANCE' TO TABLE-2                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7620-OPEN-SO-APPL-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
               OPEN CSS-SO-APPL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7620'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_APPLIANCE'  TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VQ-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7625-CLOSE-SO-APPL-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE CSS-SO-APPL-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7625'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_APPLIANCE'  TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VQ-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7625-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7630-OPEN-HST-APPL-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN HST-SO-APPL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7630'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'HST-SO-APPLIANCE'  TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE XZ-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7635-CLOSE-HST-APPL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE HST-SO-APPL-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7630'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'HST_SO_APPLIANCE'  TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE XZ-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7635-EXIT.                                                       
           EXIT.                                                        
       7700-OPEN-REMARKS-CSR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN SO-REMARKS-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7700'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_REMARKS'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE EF-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7710-CLOSE-REMARKS-CSR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE SO-REMARKS-CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7710'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'            TO ABEND-FUNCTION            
                   MOVE 'CSS_SO_REMARKS'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE EF-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7730-OPEN-HST-REMARKS-CSR.                                       
                                                                        
           EXEC SQL                                                     
               OPEN HST-SO-REMARKS-CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7730'              TO ACTIVE-PARAGRAPH         
                   MOVE 'OPEN'              TO ABEND-FUNCTION           
                   MOVE 'HST_SO_REMARKS'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE OE-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7740-CLOSE-HST-REMARKS-CSR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE HST-SO-REMARKS-CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7740'              TO ACTIVE-PARAGRAPH         
                   MOVE 'CLOSE'             TO ABEND-FUNCTION           
                   MOVE 'HST_SO_REMARKS'    TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE OE-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7750-GET-SO-DATA.                                                
                                                                        
           EXEC SQL                                                     
               SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT                          
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT                            
                      ,APPT_AM_PM_CD                                    
DT9528                ,CODES_DATA_PRESENT                               
                 INTO  :VO-BEGIN-APPT-DT :WS-NULL-BEGIN-APPT-DT         
                      ,:VO-END-APPT-DT :WS-NULL-END-APPT-DT             
                      ,:VO-APPT-AM-PM-CD                                
DT9528                ,:VO-CODES-DATA-PRESENT                           
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
               WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  BEGIN_APPT_DT                                    00010002
MFA-TR*               ,END_APPT_DT                                      00020002
MFA-TR*               ,APPT_AM_PM_CD                                    00020002
MFA-TR*               ,CODES_DATA_PRESENT                               00020002
MFA-TR*          INTO  :VO-BEGIN-APPT-DT :WS-NULL-BEGIN-APPT-DT                 
MFA-TR*               ,:VO-END-APPT-DT :WS-NULL-END-APPT-DT                     
MFA-TR*               ,:VO-APPT-AM-PM-CD                                        
MFA-TR*               ,:VO-CODES-DATA-PRESENT                                   
MFA-TR*          FROM CSS_SO_DATA                                       00130001
MFA-TR*        WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                  00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7750                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-BEGIN-APPT-DT < 0                         
                       MOVE SPACES TO VO-BEGIN-APPT-DT                  
                   END-IF                                               
                   IF WS-NULL-END-APPT-DT < 0                           
                       MOVE SPACES TO VO-END-APPT-DT                    
                   END-IF                                               
                   MOVE VO-BEGIN-APPT-DT TO S-BEGIN-APPT-DATE           
                   MOVE VO-END-APPT-DT TO S-END-APPT-DATE               
                   MOVE VO-APPT-AM-PM-CD  TO S-APPT-AM-PM-CD            
DT9528             MOVE VO-CODES-DATA-PRESENT TO S-CODES-DATA-PRESENT   
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7750'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
                   MOVE VO-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7755-GET-HST-SO-DATA.                                            
                                                                        
           EXEC SQL                                                     
               SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), BEGIN_APPT_DT
           , 121), ' ', '-'), ':', '.') BEGIN_APPT_DT                          
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), END_APPT_DT
           , 121), ' ', '-'), ':', '.') END_APPT_DT                            
                      ,APPT_AM_PM_CD                                    
DT9528                ,CODES_DATA_PRESENT                               
                 INTO  :YV-BEGIN-APPT-DT :WS-NULL-BEGIN-APPT-DT         
                      ,:YV-END-APPT-DT :WS-NULL-END-APPT-DT             
                      ,:YV-APPT-AM-PM-CD                                
DT9528                ,:YV-CODES-DATA-PRESENT                           
                 FROM HST_SO_DATA YV WITH(READUNCOMMITTED)                      
               WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  BEGIN_APPT_DT                                    00010002
MFA-TR*               ,END_APPT_DT                                      00020002
MFA-TR*               ,APPT_AM_PM_CD                                    00020002
MFA-TR*               ,CODES_DATA_PRESENT                               00020002
MFA-TR*          INTO  :YV-BEGIN-APPT-DT :WS-NULL-BEGIN-APPT-DT                 
MFA-TR*               ,:YV-END-APPT-DT :WS-NULL-END-APPT-DT                     
MFA-TR*               ,:YV-APPT-AM-PM-CD                                        
MFA-TR*               ,:YV-CODES-DATA-PRESENT                                   
MFA-TR*          FROM HST_SO_DATA YV                                    00130001
MFA-TR*        WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                  00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7755                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-BEGIN-APPT-DT < 0                         
                       MOVE SPACES TO YV-BEGIN-APPT-DT                  
                   END-IF                                               
                   IF WS-NULL-END-APPT-DT < 0                           
                       MOVE SPACES TO YV-END-APPT-DT                    
                   END-IF                                               
                   MOVE YV-BEGIN-APPT-DT TO S-BEGIN-APPT-DATE           
                   MOVE YV-END-APPT-DT TO S-END-APPT-DATE               
                   MOVE YV-APPT-AM-PM-CD  TO S-APPT-AM-PM-CD            
DT9528             MOVE YV-CODES-DATA-PRESENT TO S-CODES-DATA-PRESENT   
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7755'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'HST_SO_DATA'      TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
                   MOVE YV-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7755-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7760-GET-BILL-DATES.                                             
                                                                        
A05317     MOVE WS-CURRENT-DATE(1:4) TO WS-REVENUE-MONTH-TEMP(1:4).     
A05317     MOVE WS-CURRENT-DATE(6:2) TO WS-REVENUE-MONTH-TEMP(5:2).     
A05317     MOVE WS-REVENUE-MONTH-TEMP TO CM-REVENUE-MONTH.              
A05317     MOVE AT-BILL-CYCLE TO CM-BILL-CYCLE.                         
A05317     MOVE PR-COMPANY-NO TO CM-COMPANY-NO.                         
A05317     MOVE 'N' TO CM-CREDIT-GROUP.                                 
A05317     MOVE SPACES TO CM-CREDIT-GROUP-ID.                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CIS.CHAR2$DATE(BILL_DT,'USA'),
              COALESCE(CIS.CHAR2$DATE(CURR_CHG_DUE_DT,'USA'),' ')            
                 INTO  :CM-BILL-DT                                      
                      ,:CM-CURR-CHG-DUE-DT                              
                 FROM  CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)               
                WHERE  REVENUE_MONTH   = :CM-REVENUE-MONTH              
                  AND  BILL_CYCLE      = :CM-BILL-CYCLE                 
                  AND  COMPANY_NO      = :CM-COMPANY-NO                 
                  AND  CREDIT_GROUP    = :CM-CREDIT-GROUP               
                  AND  CREDIT_GROUP_ID = :CM-CREDIT-GROUP-ID            
               ORDER BY BILL_DT                                         
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CHAR(BILL_DT,USA)                                00010002
MFA-TR*               ,IFNULL(CHAR(CURR_CHG_DUE_DT,USA),' ')            00020002
MFA-TR*          INTO  :CM-BILL-DT                                              
MFA-TR*               ,:CM-CURR-CHG-DUE-DT                                      
MFA-TR*          FROM  CSS_CRED_FORECAST CM                             00130001
MFA-TR*         WHERE  REVENUE_MONTH   = :CM-REVENUE-MONTH              00160000
MFA-TR*           AND  BILL_CYCLE      = :CM-BILL-CYCLE                 00160000
MFA-TR*           AND  COMPANY_NO      = :CM-COMPANY-NO                 00160000
MFA-TR*           AND  CREDIT_GROUP    = :CM-CREDIT-GROUP               00160000
MFA-TR*           AND  CREDIT_GROUP_ID = :CM-CREDIT-GROUP-ID            00160000
MFA-TR*        ORDER BY BILL_DT                                         00160000
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                  00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7760                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CM-BILL-DT(4:2) TO S-EST-BILL-DAY               
                   MOVE CM-CURR-CHG-DUE-DT(4:2) TO S-EST-DUE-DAY        
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-EST-BILL-DAY                        
                   MOVE SPACES TO S-EST-DUE-DAY                         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7760'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_CRED_FORECAST' TO TABLE-1                  
                   MOVE 'REVENUE_MONTH'    TO TABLE-ELEMENT-1           
                   MOVE CM-REVENUE-MONTH   TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
A05317 7760-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
                                                                        
                                                                        
       7800-FORMATTED-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT ADDRESS_ID,                                       
                      HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      STREET_SUFFIX,                                    
                      ADDRESS_OVERFLOW,                                 
                      CARRIER_ROUTE,                                    
                      DY.ZIP_CODE,                                      
                      ZIP_CODE_PLUS_FOUR,                               
                      DY.ZIP_CODE_TOKEN,                                
                      ADDR_USAGE_CD,                                    
                      ADDR_SUFFIX,                                      
                      USPS_DELIV_PT_CD,                                 
                      TOWN,                                             
                      STATE                                             
                 INTO :DY-ADDRESS-ID,                                   
                      :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-STREET-SUFFIX,                                
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-CARRIER-ROUTE,                                
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-USAGE-CD,                                
                      :DY-ADDR-SUFFIX,                                  
                      :DY-USPS-DELIV-PT-CD,                             
                      :A4-TOWN,                                         
                      :A4-STATE                                         
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
                  AND DY.ZIP_CODE = A4.ZIP_CODE                         
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDRESS_ID,                                               
MFA-TR*               HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               CARRIER_ROUTE,                                            
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               ZIP_CODE_PLUS_FOUR,                                       
MFA-TR*               DY.ZIP_CODE_TOKEN,                                        
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               ADDR_SUFFIX,                                              
MFA-TR*               USPS_DELIV_PT_CD,                                         
MFA-TR*               TOWN,                                                     
MFA-TR*               STATE                                                     
MFA-TR*          INTO :DY-ADDRESS-ID,                                           
MFA-TR*               :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-CARRIER-ROUTE,                                        
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-PLUS-FOUR,                                   
MFA-TR*               :DY-ZIP-CODE-TOKEN,                                       
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-USPS-DELIV-PT-CD,                                     
MFA-TR*               :A4-TOWN,                                                 
MFA-TR*               :A4-STATE                                                 
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4                                           
MFA-TR*         WHERE ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*           AND DY.ZIP_CODE = A4.ZIP_CODE                                 
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ' ' TO WS-FB-ADDR-TYPE                          
                   INITIALIZE DCLCSS-ADDR-FORMATTED                     
                              DCLCSS-ZIP-CODE                           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7800'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'CSS_ZIP_CODE'       TO TABLE-2                 
                   MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1         
                   MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7810-FORMAT-FR-FB-ADDR.                                          
           MOVE LINK-SERV-ORDER-NO TO  WS-SERV-ORDER-NO-C               
           MOVE WS-SERV-ORDER-NO-N TO XD-SERV-ORDER-NO                  
           EXEC SQL                                                     
              SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + CHAR(10) + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(
           STATE) + ' ' + LTRIM(RTRIM(XD.ZIP_CODE) + ' ' + LTRIM(RTRIM(
           CASE XD.ZIP_CODE_PLUS_FOUR             
                                  WHEN '' THEN ''                       
                                  ELSE '- ' + XD.ZIP_CODE_PLUS_FOUR    
                                  END))))))))))))))                     
                INTO :WS-ADDRESS-LINE                                   
                FROM CSS_SO_FINAL_BILL XD WITH(READUNCOMMITTED),                
                     CSS_ZIP_CODE  A4 WITH(READUNCOMMITTED)                     
               WHERE SERV_ORDER_NO = :XD-SERV-ORDER-NO                  
                 AND XD.ZIP_CODE = A4.ZIP_CODE                          
                 AND XD.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||              00010002
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||               00020002
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||               00030002
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                 00040002
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||               00050002
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                 00060002
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||           00070002
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||            00080002
MFA-TR*               ' ' ||                                                    
MFA-TR*               BINCHAR(10) ||
MFA-TR*              LTRIM(RTRIM(TOWN) || ', ' ||                       00090006
MFA-TR*              LTRIM(RTRIM(STATE) || ' ' ||                       00100002
MFA-TR*              LTRIM(RTRIM(XD.ZIP_CODE) || ' ' ||                 00110004
MFA-TR*              LTRIM(RTRIM(CASE XD.ZIP_CODE_PLUS_FOUR             00110004
MFA-TR*                           WHEN '' THEN ''                       00110004
MFA-TR*                           ELSE '- ' || XD.ZIP_CODE_PLUS_FOUR    00110004
MFA-TR*                           END))))))))))))))                     00110004
MFA-TR*         INTO :WS-ADDRESS-LINE                                           
MFA-TR*         FROM CSS_SO_FINAL_BILL XD,                              00130001
MFA-TR*              CSS_ZIP_CODE  A4                                   00130001
MFA-TR*        WHERE SERV_ORDER_NO = :XD-SERV-ORDER-NO                          
MFA-TR*          AND XD.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND XD.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-ADDRESS-LINE TO WS-ADDRESS-LINE1             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7810'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSR04478_R6'      TO TABLE-1                   
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-2                  
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7815-FORMAT-FF-FB-ADDR.                                          
           MOVE LINK-SERV-ORDER-NO TO  WS-SERV-ORDER-NO-C               
           MOVE WS-SERV-ORDER-NO-N TO XD-SERV-ORDER-NO                  
           EXEC SQL                                                     
               SELECT RTRIM(LTRIM(RTRIM(ADDR_ST) + ' ' + RTRIM(LTRIM(
           RTRIM(ADDR_ST_2) + ' ' + RTRIM(LTRIM(RTRIM(FINAL_BILL_OVFL
           ) + ' ' + CHAR(10) + LTRIM(RTRIM(FINAL_BILL_CY_ST) + ' ' + 
           LTRIM(RTRIM(CIS.SUBSTR3(ADDR_ZIP_CODE,1,5)) + '-' + LTRIM(
           RTRIM(CIS.SUBSTR3(ADDR_ZIP_CODE,6,4)) + '-' + LTRIM(RTRIM(
           ADDR_COUNTRY)))))))))))               
                 INTO :WS-ADDRESS-LINE                                  
                 FROM CSS_SO_FINAL_BILL                                 
                 WHERE SERV_ORDER_NO = :XD-SERV-ORDER-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(ADDR_ST) || ' ' ||              00010002
MFA-TR*               RTRIM(LTRIM(RTRIM(ADDR_ST_2) || ' ' ||            00010002
MFA-TR*               RTRIM(LTRIM(RTRIM(FINAL_BILL_OVFL)|| ' ' ||       00010002
MFA-TR*               ' ' ||                                                    
MFA-TR*               BINCHAR(10) ||
MFA-TR*               LTRIM(RTRIM(FINAL_BILL_CY_ST) || ' ' ||           00020002
MFA-TR*               LTRIM(RTRIM(SUBSTR(ADDR_ZIP_CODE,1,5)) ||         00030002
MFA-TR*               '-' ||                                            00030002
MFA-TR*               LTRIM(RTRIM(SUBSTR(ADDR_ZIP_CODE,6,4)) ||         00030002
MFA-TR*               '-' ||                                            00030002
MFA-TR*               LTRIM(RTRIM(ADDR_COUNTRY)))))))))))               00040002
MFA-TR*          INTO :WS-ADDRESS-LINE                                          
MFA-TR*          FROM CSS_SO_FINAL_BILL                                 00130001
MFA-TR*          WHERE SERV_ORDER_NO = :XD-SERV-ORDER-NO                        
MFA-TR*        QUERYNO 7815                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-ADDRESS-LINE TO WS-ADDRESS-LINE1             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7815'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_FINAL_BILL' TO TABLE-1                  
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
       7815-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7820-FORMAT-FR-FB-ADDR-HST.                                      
           MOVE LINK-SERV-ORDER-NO TO  WS-SERV-ORDER-NO-C               
           MOVE WS-SERV-ORDER-NO-N TO YZ-SERV-ORDER-NO                  
           EXEC SQL                                                     
              SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2) + 
           ' ' + CHAR(10) + LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(
           STATE) + ' ' + LTRIM(RTRIM(YZ.ZIP_CODE)))))))))))))               
                INTO :WS-ADDRESS-LINE                                   
                FROM HST_SO_FINAL_BILL YZ WITH(READUNCOMMITTED),                
                     CSS_ZIP_CODE  A4 WITH(READUNCOMMITTED)                     
               WHERE SERV_ORDER_NO = :YZ-SERV-ORDER-NO                  
                 AND YZ.ZIP_CODE = A4.ZIP_CODE                          
                 AND YZ.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||              00010002
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||               00020002
MFA-TR*              LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||               00030002
MFA-TR*              LTRIM(RTRIM(STREET_NAME) || ' ' ||                 00040002
MFA-TR*              LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||               00050002
MFA-TR*              LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                 00060002
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||           00070002
MFA-TR*              LTRIM(RTRIM(STREET_LOCATION_2)|| ' ' ||            00080002
MFA-TR*               ' ' ||                                                    
MFA-TR*               BINCHAR(10) ||
MFA-TR*              LTRIM(RTRIM(TOWN) || ', ' ||                       00090006
MFA-TR*              LTRIM(RTRIM(STATE) || ' ' ||                       00100002
MFA-TR*              LTRIM(RTRIM(YZ.ZIP_CODE)))))))))))))               00110004
MFA-TR*         INTO :WS-ADDRESS-LINE                                           
MFA-TR*         FROM HST_SO_FINAL_BILL YZ,                              00130001
MFA-TR*              CSS_ZIP_CODE  A4                                   00130001
MFA-TR*        WHERE SERV_ORDER_NO = :YZ-SERV-ORDER-NO                          
MFA-TR*          AND YZ.ZIP_CODE = A4.ZIP_CODE                                  
MFA-TR*          AND YZ.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-ADDRESS-LINE TO WS-ADDRESS-LINE1             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7820'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'HST_SO_FINAL_BILL' TO TABLE-1                  
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7825-FORMAT-FF-FB-ADDR-HST.                                      
           MOVE LINK-SERV-ORDER-NO TO  WS-SERV-ORDER-NO-C               
           MOVE WS-SERV-ORDER-NO-N TO YZ-SERV-ORDER-NO                  
           EXEC SQL                                                     
               SELECT RTRIM(LTRIM(RTRIM(ADDR_ST) + ' ' + RTRIM(LTRIM(
           RTRIM(ADDR_ST_2) + ' ' + RTRIM(LTRIM(RTRIM(FINAL_BILL_OVFL
           ) + ' ' + CHAR(10) + LTRIM(RTRIM(FINAL_BILL_CY_ST) + ' ' + 
           LTRIM(RTRIM(CIS.SUBSTR3(ADDR_ZIP_CODE,1,5)) + '-' + LTRIM(
           RTRIM(CIS.SUBSTR3(ADDR_ZIP_CODE,6,4)) + '-' + LTRIM(RTRIM(
           ADDR_COUNTRY)))))))))))               
                 INTO :WS-ADDRESS-LINE                                  
                 FROM HST_SO_FINAL_BILL YZ                              
                 WHERE SERV_ORDER_NO = :YZ-SERV-ORDER-NO                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(ADDR_ST) || ' ' ||              00010002
MFA-TR*               RTRIM(LTRIM(RTRIM(ADDR_ST_2) || ' ' ||            00010002
MFA-TR*               RTRIM(LTRIM(RTRIM(FINAL_BILL_OVFL)|| ' ' ||       00010002
MFA-TR*               ' ' ||                                                    
MFA-TR*               BINCHAR(10) ||
MFA-TR*               LTRIM(RTRIM(FINAL_BILL_CY_ST) || ' ' ||           00020002
MFA-TR*               LTRIM(RTRIM(SUBSTR(ADDR_ZIP_CODE,1,5)) ||         00030002
MFA-TR*               '-' ||                                            00030002
MFA-TR*               LTRIM(RTRIM(SUBSTR(ADDR_ZIP_CODE,6,4)) ||         00030002
MFA-TR*               '-' ||                                            00030002
MFA-TR*               LTRIM(RTRIM(ADDR_COUNTRY)))))))))))               00040002
MFA-TR*          INTO :WS-ADDRESS-LINE                                          
MFA-TR*          FROM HST_SO_FINAL_BILL YZ                              00130001
MFA-TR*          WHERE SERV_ORDER_NO = :YZ-SERV-ORDER-NO                        
MFA-TR*        QUERYNO 7825                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE WS-ADDRESS-LINE TO WS-ADDRESS-LINE1             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7825'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'HST_SO_FINAL_BILL' TO TABLE-2                  
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
       7825-EXIT.                                                       
           EXIT.                                                        
                                                                        
DT9130 7830-GET-ORDER-TYPE-INFO.                                        
DT9130                                                                  
DT9130     EXEC SQL                                                     
DT9130         SELECT ORDER_GROUP_CD                                    
DT9130           INTO :C2-ORDER-GROUP-CD                                
DT9130           FROM CSS_ORDER_TYPE WITH(READUNCOMMITTED)                      
DT9130          WHERE ORDER_TYPE_CD =  :C2-ORDER-TYPE-CD                
DT9130            AND COMPANY_NO    = :PR-COMPANY-NO                    
DT9130                                                           
DT9130                                                      
DT9130     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ORDER_GROUP_CD                                            
MFA-TR*          INTO :C2-ORDER-GROUP-CD                                        
MFA-TR*          FROM CSS_ORDER_TYPE                                            
MFA-TR*         WHERE ORDER_TYPE_CD =  :C2-ORDER-TYPE-CD                        
MFA-TR*           AND COMPANY_NO    = :PR-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7830                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DT9130                                                                  
DT9130     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
DT9130                                                                  
DT9130     EVALUATE WS-ACTIVE-RETURN-CODE                               
DT9130         WHEN SUCCESSFUL-CALL                                     
DT9130              CONTINUE                                            
DT9130         WHEN OTHER                                               
DT9130             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
DT9130             MOVE '7830'           TO ACTIVE-PARAGRAPH            
DT9130             MOVE 'SELECT'         TO ABEND-FUNCTION              
DT9130             MOVE SPACES           TO ABEND-SQL-PREDICATES        
DT9130                                           ABEND-TABLES           
DT9130             MOVE 'CSS_ORDER-TYPE'     TO TABLE-1                 
DT9130             MOVE 'ORDER-TYPE'         TO TABLE-ELEMENT-1         
DT9130             MOVE C2-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
DT9130             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
DT9130     END-EVALUATE.                                                
DT9130                                                                  
DT9130 7830-EXIT.                                                       
DT9130     EXIT.                                                        
                                                                        
DT9519 7840-GET-CANCEL-REASON.                                          
                                                                        
           EXEC SQL                                                     
               SELECT  DNP_CNCL_REASON_CD                               
                 INTO  :AI-DNP-CNCL-REASON-CD                           
                 FROM  CSS_SO_DNP WITH(READUNCOMMITTED)                         
                WHERE  SERV_ORDER_NO = :VO-SERV-ORDER-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DNP_CNCL_REASON_CD                               00010002
MFA-TR*          INTO  :AI-DNP-CNCL-REASON-CD                                   
MFA-TR*          FROM  CSS_SO_DNP                                       00130001
MFA-TR*         WHERE  SERV_ORDER_NO = :VO-SERV-ORDER-NO                00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7840                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AI-DNP-CNCL-REASON-CD TO S-CANCEL-REASON-CD     
               WHEN NOT-FOUND                                           
                   MOVE SPACES                TO S-CANCEL-REASON-CD     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7840'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_DNP'       TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
                   MOVE VO-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7840-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7850-GET-HST-CANCEL-REASON.                                      
                                                                        
           EXEC SQL                                                     
               SELECT  DNP_CNCL_REASON_CD                               
                 INTO  :YW-DNP-CNCL-REASON-CD                           
                 FROM HST_SO_DNP YW WITH(READUNCOMMITTED)                       
               WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DNP_CNCL_REASON_CD                               00010002
MFA-TR*          INTO  :YW-DNP-CNCL-REASON-CD                                   
MFA-TR*          FROM HST_SO_DNP YW                                     00130001
MFA-TR*        WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                  00160000
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE YW-DNP-CNCL-REASON-CD TO S-CANCEL-REASON-CD     
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-CANCEL-REASON-CD                    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7850'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'HST_SO_DNP'       TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
                   MOVE YV-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7860-GET-SO-MTR-EXISTS.                                          
                                                                        
           MOVE LINK-SERV-ORDER-NO TO  WS-SERV-ORDER-NO-C               
           MOVE WS-SERV-ORDER-NO-N TO VM-SERV-ORDER-NO                  
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-SO-MTR-ROW-EXISTS                              
                FROM CSS_SO_METER VM WITH(READUNCOMMITTED),                     
                     CSS_SO_ORDER_INST  VI WITH(READUNCOMMITTED)                
               WHERE VM.SERV_ORDER_NO = :VM-SERV-ORDER-NO               
                 AND VM.SERV_ORDER_NO = VI.SERV_ORDER_NO                
                 AND VM.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE              
                 AND VM.IC_NO = VI.IC_NO                                
                 AND VI.WORK_TYPE_CD IN ('SOL','SOR','SOS','MCB','MCU') 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SO-MTR-ROW-EXISTS                                      
MFA-TR*         FROM CSS_SO_METER VM,                                           
MFA-TR*              CSS_SO_ORDER_INST  VI                                      
MFA-TR*        WHERE VM.SERV_ORDER_NO = :VM-SERV-ORDER-NO                       
MFA-TR*          AND VM.SERV_ORDER_NO = VI.SERV_ORDER_NO                        
MFA-TR*          AND VM.CODE_UTIL_TYPE = VI.CODE_UTIL_TYPE                      
MFA-TR*          AND VM.IC_NO = VI.IC_NO                                        
MFA-TR*          AND VI.WORK_TYPE_CD IN ('SOL','SOR','SOS','MCB','MCU')         
MFA-TR*        WITH UR                                                  00210000
MFA-TR*        QUERYNO 7860                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO S-SO-MTR-ROW-EXISTS                      
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO S-SO-MTR-ROW-EXISTS                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7860'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_SO_METER'     TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'    TO TABLE-ELEMENT-1           
                   MOVE VM-SERV-ORDER-NO   TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7860-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8002-DELETE-GTT2-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04478_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04478_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8002'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04478_R2'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04478_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04478_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8003'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04478_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8005-DELETE-GTT5-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04478_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04478_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8005'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04478_R5'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8008-DELETE-GTT8-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04478_R8                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04478_R8                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8008'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04478_R8'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8008-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       8200-SEND-RESULT-2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04478_R2                            
             (                                                          
              RETURN_CODE,                                              
              CONTACT_TYPE,                                             
              NAME_TYPE,                                                
              MATRIX_NAME                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-2,                                        
               :S-CONTACT-TYPE,                                         
               :S-NAME-TYPE,                                            
               :S-MATRIX-NAME                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04478_R2                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CONTACT_TYPE,                                                     
MFA-TR*       NAME_TYPE,                                                        
MFA-TR*       MATRIX_NAME                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-2,                                                
MFA-TR*        :S-CONTACT-TYPE,                                                 
MFA-TR*        :S-NAME-TYPE,                                                    
MFA-TR*        :S-MATRIX-NAME                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04478_R2'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04478_R3                            
             (                                                          
              RETURN_CODE,                                              
              EQUIPMENT_NO,                                             
              APPLIANCE_CD,                                             
              CAUTION_TAG_IND,                                          
              CUT_IND,                                                  
              TAG_NO,                                                   
              CONDITION_CD,                                             
              LOCATION_CD,                                              
              APPL_COMMENTS,                                            
              CAUTION_TAG_DT,                                           
              SOURCE_SYSTEM_CD,                                         
              INSTALL_DT,                                               
              SERIAL_NO,                                                
              CAD_VERIFY_DT,                                            
              APPLIANCE_DESC,                                           
              SEASONAL_RT_FL,                                           
              CRAWL_FL,                                                 
              APPL_LONG_DESC,                                           
              PRIMARY_FUEL_CD,                                          
              AVERAGE_BTU,                                              
              LEAK_IND,                                                 
              LIGHT_IND,                                                
              REPAIR_IND,                                               
              CUTOFF_IND,                                               
              REPLACE_APP_FL                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-EQUIPMENT-NO,                                         
               :S-APPLIANCE-CD,                                         
               :S-CAUTION-TAG-IND,                                      
               :S-CUT-IND,                                              
               :S-TAG-NO,                                               
               :S-CONDITION-CD,                                         
               :S-LOCATION-CD,                                          
               :S-APPL-COMMENTS,                                        
               :S-CAUTION-TAG-DT,                                       
               :S-SOURCE-SYSTEM-CD-3,                                   
               :S-INSTALL-DT,                                           
               :S-SERIAL-NO,                                            
               :S-CAD-VERIFY-DT,                                        
               :S-APPLIANCE-DESC,                                       
               :S-SEASONAL-RT-FL,                                       
               :S-CRAWL-FL,                                             
               :S-APPL-LONG-DESC,                                       
               :S-PRIMARY-FUEL-CD,                                      
               :S-AVERAGE-BTU,                                          
               :S-LEAK-IND,                                             
               :S-LIGHT-IND,                                            
               :S-REPAIR-IND,                                           
               :S-CUTOFF-IND,                                           
               :S-REPLACE-APP-FL                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04478_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       EQUIPMENT_NO,                                                     
MFA-TR*       APPLIANCE_CD,                                                     
MFA-TR*       CAUTION_TAG_IND,                                                  
MFA-TR*       CUT_IND,                                                          
MFA-TR*       TAG_NO,                                                           
MFA-TR*       CONDITION_CD,                                                     
MFA-TR*       LOCATION_CD,                                                      
MFA-TR*       APPL_COMMENTS,                                                    
MFA-TR*       CAUTION_TAG_DT,                                                   
MFA-TR*       SOURCE_SYSTEM_CD,                                                 
MFA-TR*       INSTALL_DT,                                                       
MFA-TR*       SERIAL_NO,                                                        
MFA-TR*       CAD_VERIFY_DT,                                                    
MFA-TR*       APPLIANCE_DESC,                                                   
MFA-TR*       SEASONAL_RT_FL,                                                   
MFA-TR*       CRAWL_FL,                                                         
MFA-TR*       APPL_LONG_DESC,                                                   
MFA-TR*       PRIMARY_FUEL_CD,                                                  
MFA-TR*       AVERAGE_BTU,                                                      
MFA-TR*       LEAK_IND,                                                         
MFA-TR*       LIGHT_IND,                                                        
MFA-TR*       REPAIR_IND,                                                       
MFA-TR*       CUTOFF_IND,                                                       
MFA-TR*       REPLACE_APP_FL                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-EQUIPMENT-NO,                                                 
MFA-TR*        :S-APPLIANCE-CD,                                                 
MFA-TR*        :S-CAUTION-TAG-IND,                                              
MFA-TR*        :S-CUT-IND,                                                      
MFA-TR*        :S-TAG-NO,                                                       
MFA-TR*        :S-CONDITION-CD,                                                 
MFA-TR*        :S-LOCATION-CD,                                                  
MFA-TR*        :S-APPL-COMMENTS,                                                
MFA-TR*        :S-CAUTION-TAG-DT,                                               
MFA-TR*        :S-SOURCE-SYSTEM-CD-3,                                           
MFA-TR*        :S-INSTALL-DT,                                                   
MFA-TR*        :S-SERIAL-NO,                                                    
MFA-TR*        :S-CAD-VERIFY-DT,                                                
MFA-TR*        :S-APPLIANCE-DESC,                                               
MFA-TR*        :S-SEASONAL-RT-FL,                                               
MFA-TR*        :S-CRAWL-FL,                                                     
MFA-TR*        :S-APPL-LONG-DESC,                                               
MFA-TR*        :S-PRIMARY-FUEL-CD,                                              
MFA-TR*        :S-AVERAGE-BTU,                                                  
MFA-TR*        :S-LEAK-IND,                                                     
MFA-TR*        :S-LIGHT-IND,                                                    
MFA-TR*        :S-REPAIR-IND,                                                   
MFA-TR*        :S-CUTOFF-IND,                                                   
MFA-TR*        :S-REPLACE-APP-FL                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04478_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-SEND-RESULT-5.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04478_R5                            
             (                                                          
              RETURN_CODE,                                              
              SERV_ORDER_NO,                                            
              REMARK_TYPE_CD,                                           
              REMARK_TX                                                 
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-5,                                        
               :S-SERV-ORDER-NO-5,                                      
               :S-REMARK-TYPE-CD,                                       
               :S-REMARK-TX                                             
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04478_R5                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       REMARK_TYPE_CD,                                                   
MFA-TR*       REMARK_TX                                                         
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-5,                                                
MFA-TR*        :S-SERV-ORDER-NO-5,                                              
MFA-TR*        :S-REMARK-TYPE-CD,                                               
MFA-TR*        :S-REMARK-TX                                                     
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04478_R5'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       8800-SEND-RESULT-8.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04478_R8                            
             (                                                          
              RETURN_CODE,                                              
              CONTRACT_ID                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-8,                                        
               :S-CONTRACT-ID-8                                         
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04478_R8                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CONTRACT_ID                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-8,                                                
MFA-TR*        :S-CONTRACT-ID-8                                                 
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8800'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04478_R8'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT02-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-2                             
               EXEC SQL                                                 
                   OPEN N2                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT05-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-5                             
               EXEC SQL                                                 
                   OPEN N5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           EXEC SQL                                                     
               OPEN C6                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C7                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT08-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C8                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C8 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-8                             
               EXEC SQL                                                 
                   OPEN N8                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N8 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
