       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04477.                                          
       AUTHOR.       FRAN BARRY.                                        
       DATE-WRITTEN. JUL 2011.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A COBOL STORED PROCEDURE WHICH IS USED TO     *        
      *  GET SERVICE ORDER INITIATION ERROR MESSAGES.                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  07/28/2011 FMB       INITIAL VERSION                          *        
A4670A*  02/18/2014 PK44514   A04670 - DEFECT 3142: TO SEND BACK THE   *        
      *                       CURRENT ACCOUNT AT THE PREMISES          *        
P00795*  06/02/2014 PK44514   NEW SET ORDER CHANGES                    *        
P0795A*  10/16/2014 PK44514   FIX-ALLOW B, D, AND E ORDERS ON PENDING  *        
P0795A*                       ACCOUNT EVEN WHEN NO METERS ON ACCOUNT   *        
P0795C*  01/22/2015 PK44514   DEFECT 5590 - GIVE INFO MSG IF LIGHT-MNT *        
P0795C*                       ELEC ORDER INITIATED ON ACCT WITH ONLY   *        
P0795C*                       GAS METERS & NOT IN GAS ONLY LOCAL OFFICE*        
P0795B*  03/10/2015 PK44514   CHECK IF CURRENT ACCOUNT HAS METERS WHEN *        
P0795B*                       INITIATING ORDERS ON PENDING ACCOUNTS    *        
P0795D*  04/13/2015 PK44514   DEFECT 7052-SHOULD BE ABLE TO ENTER NON- *        
P0795D*                       GROUP D ORDERS ON ANY ACCOUNT.           *        
P0795E*  04/22/2015 PK44514   DEFECT 7119-WHEN SHOWING GAS ONLY ACCOUNT*        
P0795E*                       MSG FOR LIGHT MNT -ELEC ORDERS ALSO CHECK*        
P0795E*                       FOR GAS METERS ON THE ACCOUNT.           *        
P0795F*  08/19/2015 PK44514   DEFECT 8967-CHECK FOR SECURED ACCOUNTS   *        
P0795F*                       FOR AOO PROCESS                          *        
DT9493*  11/18/2015 PK44514   DEFECT 9493-REORDER OFF AND CC FOR MAINT *        
DT9493*                       PROCESS                                  *        
D13065*  12/02/2016 PK44514   DEFECT 13065-ALLOW ORDERS OTHER THAN     *        
D13065*                       MARKETING AND JOBBING ON INACTIVE ACCT   *        
P0795G*  12/28/2016 PK44514   REMOVE REFERENCE TO CSS_NAVIGATION       *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04477'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04477 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04477_R1'.          
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE             PIC S9(9) COMP VALUE ZERO.       
      *   05 S-BUS-RULE-ID             PIC X(10) VALUE SPACES.                  
          05 S-BUS-RULE-ID             PIC X(13) VALUE SPACES.          
          05 S-ACTION-TYPE-CD          PIC X(08) VALUE SPACES.          
          05 S-BUS-RULE-XREF-ID        PIC X(26) VALUE SPACES.          
          05 S-HARD-ERROR              PIC X(01) VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04477'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-CUSTOMER-NO           PIC X(10) VALUE SPACES.          
          05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO         
                                       PIC 9(10).                       
          05  WS-CUSTOMER-NO-LL        PIC 9(10) VALUE ZEROES.          
          05  WS-CUSTOMER-NO-CHAR      REDEFINES WS-CUSTOMER-NO-LL      
                                       PIC X(10).                       
          05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.          
          05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
          05  WS-PREMISE-NO            PIC X(10) VALUE SPACES.          
          05  WS-PREMISE-NO-NUM        REDEFINES WS-PREMISE-NO          
                                       PIC 9(10).                       
          05  WS-CURR-ACCOUNT-NO       PIC 9(13) VALUE 0.               
          05  WS-CURR-ACCOUNT-CHAR     REDEFINES WS-CURR-ACCOUNT-NO     
                                       PIC X(13).                       
          05  WS-NEW-CUSTOMER-NO       PIC S9(10)V COMP-3 VALUE 0.      
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-MN-FOUND              PIC X(01) VALUE 'N'.             
          05  WS-CP-FOUND              PIC X(01) VALUE 'N'.             
          05  WS-SECURED-RATE          PIC X(01) VALUE 'N'.             
          05  WS-SECURITY-OK           PIC X(01) VALUE 'N'.             
          05  WS-NEW-CUST-ACTIVE       PIC X(01) VALUE 'N'.             
P00795    05  WS-NEW-CUST-COMPANY      PIC X(02) VALUE SPACES.          
P00795    05  WS-COMPANY-NO            PIC X(02) VALUE SPACES.          
          05  WS-COUNT                 PIC S9(4) COMP VALUE 0.          
          05  WS-INPUT-DATE            PIC X(10) VALUE SPACES.          
          05  WS-OUTPUT-DATE           PIC X(10) VALUE SPACES.          
          05  WS-STEP                  PIC S9(08) COMP-3 VALUE +0.      
          05  WS-DAYOFWEEK-ISO         PIC S9(09) COMP VALUE 0.         
          05  WS-DAY-OF-WEEK           PIC 9(01) VALUE ZEROES.          
          05  WS-HOLIDAY               PIC X(01) VALUE SPACES.          
          05  WS-REVERT-FL             PIC X(01) VALUE 'N'.             
          05  WS-SET-ORDER-FL          PIC X(01) VALUE 'N'.             
          05  WS-ITPA-FL               PIC X(01) VALUE 'N'.             
P0795E    05  WS-GAS-METER-FOUND       PIC X(01) VALUE 'N'.             
P0795C    05  WS-ELEC-METER-FOUND      PIC X(01) VALUE 'N'.             
P0795C    05  WS-LOCOFF-GAS-ONLY-FL    PIC X(01) VALUE 'N'.             
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01 IND-VARIABLES.                                                
          05 WS-NULL1                    PIC S9(04) COMP.               
          05 WS-NULL2                    PIC S9(04) COMP.               
          05 WS-NULL3                    PIC S9(04) COMP.               
          05 WS-NULL4                    PIC S9(04) COMP.               
          05 WS-NULL5                    PIC S9(04) COMP.               
          05 WS-NULL6                    PIC S9(04) COMP.               
          05 WS-NULL7                    PIC S9(04) COMP.               
          05 WS-NULL8                    PIC S9(04) COMP.               
          05 WS-NULL9                    PIC S9(04) COMP.               
          05 WS-NULL10                   PIC S9(04) COMP.               
          05 WS-NULL11                   PIC S9(04) COMP.               
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *CSS_MTRD_ENVRNMT MN                                                      
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNVGTN                                                   
           END-EXEC.                                                            
                                                                        
      *CSS_ORDER_TYPE C2                                                        
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLCOFRT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCRITPA                                                  
           END-EXEC.                                                            
                                                                        
P0795C*CSS_LOCAL_OFFICE B1                                                      
P0795C     EXEC SQL                                                             
P0795C        INCLUDE TBLOCOFC                                                  
P0795C     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 ACTION_TYPE_CD       AS ACTION_TYPE_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,              
                 HARD_ERROR           AS HARD_ERROR                     
              FROM #CSR04477_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          ACTION_TYPE_CD       AS ACTION_TYPE_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,                      
MFA-TR*          HARD_ERROR           AS HARD_ERROR                             
MFA-TR*       FROM SESSION.CSR04477_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE       AS RETURN_CODE,              
                      :S-BUS-RULE-ID       AS BUS_RULE_ID,              
                      :S-ACTION-TYPE-CD    AS ACTION_TYPE_CD,           
                      :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID,         
                      :S-HARD-ERROR        AS HARD_ERROR                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE       AS RETURN_CODE,                      
MFA-TR*               :S-BUS-RULE-ID       AS BUS_RULE_ID,                      
MFA-TR*               :S-ACTION-TYPE-CD    AS ACTION_TYPE_CD,                   
MFA-TR*               :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID,                 
MFA-TR*               :S-HARD-ERROR        AS HARD_ERROR                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-OLD-CUSTOMER-NO     PIC X(10).                          
       01  LINK-PREMISE-NO          PIC X(10).                          
       01  LINK-NEW-CUSTOMER-NO     PIC X(10).                          
       01  LINK-ORDER-TYPE-CD       PIC X(05).                          
       01  LINK-PROCESS             PIC X(10).                          
       01  LINK-STEP                PIC X(10).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-PROGRAM-ID          PIC X(08).                          
       01  LINK-CANCEL-REVERT-FL    PIC X(01).                          
       01  LINK-XFER-FL             PIC X(01).                          
       01  LINK-ORDER-TYPE-CHG-FL   PIC X(01).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO,                       
                                 LINK-OLD-CUSTOMER-NO,                  
                                 LINK-PREMISE-NO,                       
                                 LINK-NEW-CUSTOMER-NO,                  
                                 LINK-ORDER-TYPE-CD,                    
                                 LINK-PROCESS,                          
                                 LINK-STEP,                             
                                 LINK-USERID,                           
                                 LINK-PROGRAM-ID,                       
                                 LINK-CANCEL-REVERT-FL,                 
                                 LINK-XFER-FL,                          
                                 LINK-ORDER-TYPE-CHG-FL.                
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
           MOVE 'N' TO WS-GTT01-DECLARED.                               
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04477_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04477_R1
              (                                                          
               RETURN_CODE          INT,                            
               BUS_RULE_ID CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ACTION_TYPE_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               HARD_ERROR CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04477_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-OLD-CUSTOMER-NO NOT NUMERIC                          
               MOVE ZEROES TO LINK-OLD-CUSTOMER-NO
           END-IF.                     
           IF LINK-NEW-CUSTOMER-NO NOT NUMERIC                          
               MOVE ZEROES TO LINK-NEW-CUSTOMER-NO
           END-IF.                     
           IF LINK-PREMISE-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-PREMISE-NO
           END-IF.                          
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-OLD-CUSTOMER-NO    TO WS-CUSTOMER-NO.              
           MOVE WS-CUSTOMER-NO-NUM      TO CU-CUSTOMER-NO.              
           MOVE LINK-PREMISE-NO         TO WS-PREMISE-NO.               
           MOVE WS-PREMISE-NO-NUM       TO PR-PREMISE-NO.               
           MOVE LINK-ACCOUNT-NO         TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO.               
           MOVE LINK-NEW-CUSTOMER-NO    TO WS-CUSTOMER-NO.              
           MOVE WS-CUSTOMER-NO-NUM      TO WS-NEW-CUSTOMER-NO.          
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF LINK-ACCOUNT-NO = ZEROES AND                              
              LINK-OLD-CUSTOMER-NO = ZEROES AND                         
              LINK-PREMISE-NO = ZEROES                                  
                  INITIALIZE GTT-RETURN-FIELDS                          
                  MOVE +100 TO S-RETURN-CODE                            
                  MOVE 'PARMS ZERO' TO S-BUS-RULE-ID                    
                  ADD +1 TO CTR-ROWS                                    
                  PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
           PERFORM 7009-SECURITY THRU 7009-EXIT.                        
           IF AT-ACCOUNT-NO > 0                                         
               PERFORM 7008-SELECT-ACCOUNT THRU 7008-EXIT               
               IF PR-PREMISE-NO = 0                                     
                   MOVE AT-PREMISE-NO TO PR-PREMISE-NO                  
               END-IF                                                   
               IF CU-CUSTOMER-NO = 0                                    
                   MOVE AT-CUSTOMER-NO TO CU-CUSTOMER-NO                
               END-IF                                                   
               PERFORM 7006-SELECT-MTRENV THRU 7006-EXIT                
               PERFORM 7007-SELECT-CSTPLN THRU 7007-EXIT                
               PERFORM 7010-SECURED-RATES THRU 7010-EXIT                
               PERFORM 7014-BARRIER-ISLAND THRU 7014-EXIT
           END-IF.              
           PERFORM 7000-SELECT-PREMISE THRU 7000-EXIT.                  
           IF CU-CUSTOMER-NO NOT = 0                                    
              PERFORM 7001-SELECT-CUSTOMER THRU 7001-EXIT               
           END-IF                                                       
           MOVE PR-PREMISE-NO TO WS-CPD99-PREMISE-NO.                   
           PERFORM 6990-FETCH-CUR-ACCOUNT THRU 6990-EXIT.               
           MOVE WS-CPD99-ACCOUNT-NO TO WS-CURR-ACCOUNT-NO.              
                                                                        
A4670A*SENDING BACK THE CURRENT ACCOUNT AT THE PREMISES ***                     
A4670A     MOVE 0 TO S-RETURN-CODE.                                     
A4670A     MOVE WS-CURR-ACCOUNT-CHAR TO S-BUS-RULE-ID.                  
A4670A     MOVE 'ACCOUNT' TO S-ACTION-TYPE-CD.                          
A4670A     MOVE SPACES TO S-BUS-RULE-XREF-ID                            
A4670A                    S-HARD-ERROR.                                 
A4670A     PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           MOVE 1 TO WS-STEP.                                           
           MOVE WS-CURRENT-DATE TO WS-INPUT-DATE.                       
           PERFORM 3000-NEXT-BUSINESS-DAY THRU 3000-EXIT.               
           MOVE 0 TO S-RETURN-CODE.                                     
           MOVE WS-OUTPUT-DATE TO S-BUS-RULE-ID.                        
           MOVE 'D' TO S-ACTION-TYPE-CD.                                
           MOVE SPACES TO S-BUS-RULE-XREF-ID                            
                          S-HARD-ERROR.                                 
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           IF LINK-PROCESS = 'STOP' AND                                 
              LINK-STEP = 'INITIATION'                                  
                  MOVE 'SOINIT0001' TO 1T-BUS-PROCESS-ID                
                  PERFORM 2100-STOP-INIT THRU 2100-EXIT
           END-IF.                
                                                                        
           IF LINK-PROCESS = 'START' AND                                
              LINK-STEP = 'INITIATION'                                  
                  MOVE 'SOINIT0002' TO 1T-BUS-PROCESS-ID                
                  PERFORM 2200-START-INIT THRU 2200-EXIT
           END-IF.               
                                                                        
           IF LINK-PROCESS = 'AOO' AND                                  
              LINK-STEP = 'INITIATION'                                  
                  MOVE 'SOINIT0005' TO 1T-BUS-PROCESS-ID                
                  PERFORM 2300-AOO-INIT THRU 2300-EXIT
           END-IF.                 
                                                                        
           IF LINK-PROCESS = 'MAINTAIN' AND                             
              LINK-STEP = 'INITIATION'                                  
                  MOVE 'SOINIT0006' TO 1T-BUS-PROCESS-ID                
                  PERFORM 2400-MAINTAIN-INIT THRU 2400-EXIT
           END-IF.            
                                                                        
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE +100 TO S-RETURN-CODE                                
              MOVE 'NO DATA' TO S-BUS-RULE-ID                           
              ADD +1 TO CTR-ROWS                                        
              PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2100-STOP-INIT.                                                  
                                                                        
           IF LINK-CANCEL-REVERT-FL = 'Y'                               
               NEXT SENTENCE                                            
           ELSE                                                         
               IF (PR-CODE-RENTAL-PROP = 'D') OR                        
                  (PR-CODE-RENTAL-PROP = 'S' AND                        
                  (WS-OUTPUT-DATE(6:2) >= '10' OR                       
                   WS-OUTPUT-DATE(6:2) <= '04'))                        
                       PERFORM 7005-LL-CUSTOMER THRU 7005-EXIT          
                       MOVE 0 TO S-RETURN-CODE                          
                       MOVE 'ORDR000004' TO S-BUS-RULE-ID               
                       MOVE 'N' TO S-HARD-ERROR                         
                       IF SI-CUSTOMER-NO NOT = CU-CUSTOMER-NO           
                           MOVE 'P' TO S-ACTION-TYPE-CD                 
                           MOVE 'Y' TO WS-REVERT-FL                     
                           MOVE SI-CUSTOMER-NO TO WS-CUSTOMER-NO-LL     
                       ELSE                                             
                           MOVE 'F' TO S-ACTION-TYPE-CD                 
                       END-IF                                           
                       PERFORM 7013-RULE-XREF THRU 7013-EXIT            
                       PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
                       IF WS-REVERT-FL = 'Y'                            
                           PERFORM 2110-LL-CUSTOMER-NO THRU 2110-EXIT
                       END-IF
               END-IF
           END-IF.  
P00795     IF LINK-ORDER-TYPE-CD(1:2) = 'OF' OR                         
P00795        LINK-ORDER-TYPE-CD = 'DNPFB'                              
             IF WS-REVERT-FL = 'N'                                      
P00795          IF LINK-ORDER-TYPE-CD(1:2) = 'OF'                       
                   PERFORM 7002-COUNT-PENDING-OFF THRU 7002-EXIT        
                   IF WS-COUNT > 2                                      
                       MOVE 0 TO S-RETURN-CODE                          
                       MOVE 'ORDR000003' TO S-BUS-RULE-ID               
                       MOVE 'F' TO S-ACTION-TYPE-CD                     
                       MOVE 'Y' TO S-HARD-ERROR                         
                       PERFORM 7013-RULE-XREF THRU 7013-EXIT            
                       PERFORM 8100-SEND-RESULT THRU 8100-EXIT          
                   END-IF                                               
P00795          END-IF                                                  
             ELSE                                                       
               PERFORM 7003-COUNT-PENDING-CC THRU 7003-EXIT             
               IF WS-COUNT > 2                                          
                   MOVE 0 TO S-RETURN-CODE                              
                   MOVE 'ORDR000002' TO S-BUS-RULE-ID                   
                   MOVE 'F' TO S-ACTION-TYPE-CD                         
                   MOVE 'Y' TO S-HARD-ERROR                             
                   PERFORM 7013-RULE-XREF THRU 7013-EXIT                
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
               END-IF                                                   
           END-IF
           END-IF.                                                      
           IF LINK-ORDER-TYPE-CD(1:2) = 'OF' AND                        
              WS-MN-FOUND = 'N' AND                                     
              AT-CODE-ACCT-STAT NOT = 'P'                               
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ACCT000002' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF AT-ACCOUNT-NO NOT = WS-CURR-ACCOUNT-NO AND                
              AT-CODE-ACCT-STAT NOT = 'P'                               
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000006' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF LINK-ORDER-TYPE-CD(1:2) = 'UM' AND                        
              WS-MN-FOUND = 'Y'                                         
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'SO282' TO S-BUS-RULE-ID                         
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF LINK-ORDER-TYPE-CD(1:2) = 'UM' AND                        
              WS-CP-FOUND = 'N'                                         
                  MOVE 0 TO S-RETURN-CODE                               
      *           MOVE 'SO288' TO S-BUS-RULE-ID                                 
                  MOVE '??????????' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
      *           PERFORM 7013-RULE-XREF THRU 7013-EXIT                         
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF WS-SECURED-RATE = 'Y' AND                                 
              WS-SECURITY-OK = 'N'                                      
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ACCT000005' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF (AT-CODE-ACCT-STAT = 'J' OR 'B' OR 'S') OR                
              CU-CUSTOMER-NO = 0  OR                                    
              AT-ACCOUNT-NO = 0  OR                                     
              AT-ACCOUNT-TYPE-CODE = 'N'                                
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000010' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF AT-NO-BILL-COPIES = 0                                     
                MOVE 0 TO S-RETURN-CODE                                 
                MOVE 'ORDR000028' TO S-BUS-RULE-ID                      
                MOVE 'P' TO S-ACTION-TYPE-CD                            
                PERFORM 7013-RULE-XREF THRU 7013-EXIT                   
                PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                
           IF A4-ERROR-MSG-NO > ' '                                     
               MOVE 0 TO S-RETURN-CODE                                  
               MOVE 'ORDR000009' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-ACTION-TYPE-CD(1:1)                        
               MOVE A4-ERROR-MSG-NO TO S-ACTION-TYPE-CD(2:5)            
               MOVE 'N' TO S-HARD-ERROR                                 
               PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
           IF O2-ERROR-MSG-NO > ' '                                     
               MOVE 0 TO S-RETURN-CODE                                  
               MOVE 'ORDR000009' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-ACTION-TYPE-CD(1:1)                        
               MOVE O2-ERROR-MSG-NO TO S-ACTION-TYPE-CD(2:5)            
               MOVE 'N' TO S-HARD-ERROR                                 
               PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2110-LL-CUSTOMER-NO.                                             
                                                                        
           MOVE 0 TO S-RETURN-CODE.                                     
           MOVE WS-CUSTOMER-NO-CHAR TO S-BUS-RULE-ID                    
           MOVE 'L' TO S-ACTION-TYPE-CD.                                
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2200-START-INIT.                                                 
                                                                        
           IF LINK-ORDER-TYPE-CD(1:2) = 'CC'                            
               PERFORM 7003-COUNT-PENDING-CC THRU 7003-EXIT             
               IF WS-COUNT > 2                                          
                   MOVE 0 TO S-RETURN-CODE                              
                   MOVE 'ORDR000002' TO S-BUS-RULE-ID                   
                   MOVE 'F' TO S-ACTION-TYPE-CD                         
                   MOVE 'Y' TO S-HARD-ERROR                             
                   PERFORM 7013-RULE-XREF THRU 7013-EXIT                
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT
               END-IF
           END-IF.             
           IF LINK-ORDER-TYPE-CD(1:2) = 'NC'                            
               PERFORM 7004-PENDING-NC THRU 7004-EXIT                   
               IF WS-COUNT > 0                                          
                   MOVE 0 TO S-RETURN-CODE                              
                   MOVE 'ORDR000005' TO S-BUS-RULE-ID                   
                   MOVE 'F' TO S-ACTION-TYPE-CD                         
                   MOVE 'Y' TO S-HARD-ERROR                             
                   PERFORM 7013-RULE-XREF THRU 7013-EXIT                
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT
               END-IF
           END-IF.             
           IF LINK-ORDER-TYPE-CD(1:2) = 'UM' AND                        
              WS-MN-FOUND = 'Y'                                         
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'SO282' TO S-BUS-RULE-ID                         
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF LINK-ORDER-TYPE-CD(1:2) = 'UM' AND                        
              WS-CP-FOUND = 'N'                                         
                  MOVE 0 TO S-RETURN-CODE                               
      *           MOVE 'SO288' TO S-BUS-RULE-ID                                 
                  MOVE '??????????' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
      *           PERFORM 7013-RULE-XREF THRU 7013-EXIT                         
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF LINK-XFER-FL = 'Y'                                        
              NEXT SENTENCE                                             
P00795*   NOT ALLOW INTER COMPANY TRANSFER - CHECK                              
P00795*       PERFORM 7025-NEW-CUSTOMER-INFO  THRU 7025-EXIT                    
P00795*       MOVE AT-COMPANY-NO TO WS-COMPANY-NO                               
P00795*       IF AT-COMPANY-NO <= SPACES                                        
P00795*          MOVE PR-COMPANY-NO TO WS-COMPANY-NO                            
P00795*       END-IF                                                            
P00795*       IF WS-NEW-CUST-COMPANY NOT = WS-COMPANY-NO                        
P00795*           MOVE 0 TO S-RETURN-CODE                                       
P00795*           MOVE 'ORDR000067' TO S-BUS-RULE-ID                            
P00795*           MOVE 'P' TO S-ACTION-TYPE-CD                                  
P00795*           MOVE 'Y' TO S-HARD-ERROR                                      
P00795*           PERFORM 7013-RULE-XREF THRU 7013-EXIT                         
P00795*           PERFORM 8100-SEND-RESULT THRU 8100-EXIT                       
P00795*       END-IF                                                            
           ELSE                                                         
               IF LINK-ORDER-TYPE-CD(1:2) = 'CC'                        
                   PERFORM 7012-NEW-CUSTOMER THRU 7012-EXIT             
                   IF WS-NEW-CUST-ACTIVE = 'Y'                          
                       MOVE 0 TO S-RETURN-CODE                          
                       MOVE 'ORDR000027' TO S-BUS-RULE-ID               
                       MOVE 'P' TO S-ACTION-TYPE-CD                     
                       MOVE 'N' TO S-HARD-ERROR                         
                       PERFORM 7013-RULE-XREF THRU 7013-EXIT            
                       PERFORM 8100-SEND-RESULT THRU 8100-EXIT
                   END-IF
               END-IF
           END-IF.         
           IF AT-NO-BILL-COPIES = 0                                     
                MOVE 0 TO S-RETURN-CODE                                 
                MOVE 'ORDR000028' TO S-BUS-RULE-ID                      
                MOVE 'P' TO S-ACTION-TYPE-CD                            
                PERFORM 7013-RULE-XREF THRU 7013-EXIT                   
                PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                
           IF A4-ERROR-MSG-NO > ' '                                     
               MOVE 0 TO S-RETURN-CODE                                  
               MOVE 'ORDR000009' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-ACTION-TYPE-CD(1:1)                        
               MOVE A4-ERROR-MSG-NO TO S-ACTION-TYPE-CD(2:5)            
               MOVE 'N' TO S-HARD-ERROR                                 
               PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
           IF O2-ERROR-MSG-NO > ' '                                     
               MOVE 0 TO S-RETURN-CODE                                  
               MOVE 'ORDR000009' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-ACTION-TYPE-CD(1:1)                        
               MOVE O2-ERROR-MSG-NO TO S-ACTION-TYPE-CD(2:5)            
               MOVE 'N' TO S-HARD-ERROR                                 
               PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
           IF (LINK-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC') AND              
              WS-MN-FOUND = 'N' AND                                     
              AT-CODE-ACCT-STAT NOT = 'P'                               
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ACCT000002' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF AT-ACCOUNT-NO NOT = WS-CURR-ACCOUNT-NO AND                
              AT-CODE-ACCT-STAT NOT = 'P'                               
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000006' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF WS-SECURED-RATE = 'Y' AND                                 
              WS-SECURITY-OK = 'N'                                      
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ACCT000005' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF ((CU-CUSTOMER-NO = 0  OR                                  
              AT-ACCOUNT-NO = 0) AND                                    
              LINK-ORDER-TYPE-CD NOT= 'FM002') OR                       
              AT-ACCOUNT-TYPE-CODE = 'N'                                
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000010' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF AT-CODE-ACCT-STAT = 'P'                                   
               PERFORM 7015-SET-ORDERS THRU 7015-EXIT                   
               IF WS-SET-ORDER-FL = 'N'                                 
                   MOVE 0 TO S-RETURN-CODE                              
                   MOVE 'ORDR000054' TO S-BUS-RULE-ID                   
                   MOVE 'F' TO S-ACTION-TYPE-CD                         
                   MOVE 'Y' TO S-HARD-ERROR                             
                   PERFORM 7013-RULE-XREF THRU 7013-EXIT                
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT
               END-IF
           END-IF.             
           IF WS-NEW-CUSTOMER-NO > 0                                    
               PERFORM 7020-ITPA THRU 7020-EXIT                         
               IF WS-ITPA-FL = 'Y'                                      
                   MOVE 0 TO S-RETURN-CODE                              
                   MOVE 'ORDR000062' TO S-BUS-RULE-ID                   
                   MOVE 'P' TO S-ACTION-TYPE-CD                         
                   MOVE 'Y' TO S-HARD-ERROR                             
                   PERFORM 7013-RULE-XREF THRU 7013-EXIT                
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT
               END-IF
           END-IF.             
P00795* IF THE ACCOUNT IS INACTIVE SO NOT ALLOW INITIATION OF ORDERS            
           IF AT-CODE-ACCT-STAT = 'J'                                   
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000225' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
P00795* FOR FINALBILLED OR WRITEOFF SUBACCOUNTS DO NOT ALLOW INITIATION         
P00795* OF OCCUPANT CHANGE AND UNMETERED OCCUPANT CHANGE                        
           IF AT-MST-SUB-ACCT-IND = 'S' AND                             
              (AT-CODE-ACCT-STAT = 'S' OR 'B') AND                      
               (LINK-ORDER-TYPE-CD = 'NC001' OR 'UMROC')                
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000226' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       2300-AOO-INIT.                                                   
           PERFORM 7030-GET-ORDER-TYPE-INFO  THRU 7030-EXIT.            
P0795D     IF C2-ORDER-GROUP-CD = 'D' AND                               
              AT-ACCOUNT-NO NOT = WS-CURR-ACCOUNT-NO AND                
              AT-CODE-ACCT-STAT NOT = 'P'                               
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000006' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
           IF AT-CODE-ACCT-STAT = 'J' AND                               
D13065        (LINK-ORDER-TYPE-CD = 'FM007' OR                          
D13065         LINK-ORDER-TYPE-CD = 'FW022')                            
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000225' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
P00795*    IF (LINK-ORDER-TYPE-CD = 'FM001' OR 'ON001') AND                     
P00795*       WS-MN-FOUND = 'N' AND                                             
P00795*       AT-CODE-ACCT-STAT NOT = 'P'                                       
P00795*           MOVE 0 TO S-RETURN-CODE                                       
P00795*           MOVE 'ORDR000300' TO S-BUS-RULE-ID                            
P00795*           MOVE 'P' TO S-ACTION-TYPE-CD                                  
P00795*           MOVE 'Y' TO S-HARD-ERROR                                      
P00795*           PERFORM 7013-RULE-XREF THRU 7013-EXIT                         
P00795*           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                      
P0795B     IF AT-ACCOUNT-NO NOT = WS-CURR-ACCOUNT-NO AND                
P0795B        AT-CODE-ACCT-STAT = 'P'                                   
P0795B         MOVE WS-CURR-ACCOUNT-NO TO AT-ACCOUNT-NO                 
P0795B         PERFORM 7006-SELECT-MTRENV THRU 7006-EXIT                
P0795B     END-IF                                                       
           IF (C2-ORDER-GROUP-CD = 'B' OR 'D' OR 'E') AND               
              WS-MN-FOUND = 'N'                                         
P0795A*       AT-CODE-ACCT-STAT NOT = 'P'                                       
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ORDR000300' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
                                                                        
P0795F* AOO PROCESS-CHECK FOR SECURED ACCT                                      
           IF ((C2-ORDER-GROUP-CD = 'C' OR 'D') OR                      
              (LINK-ORDER-TYPE-CD = 'FM003' OR                          
               LINK-ORDER-TYPE-CD = 'MC001')) AND                       
              WS-SECURED-RATE = 'Y' AND                                 
              WS-SECURITY-OK = 'N'                                      
                  MOVE 0 TO S-RETURN-CODE                               
                  MOVE 'ACCT000005' TO S-BUS-RULE-ID                    
                  MOVE 'F' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO S-HARD-ERROR                              
                  PERFORM 7013-RULE-XREF THRU 7013-EXIT                 
                  PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.              
                                                                        
P0795C      IF LINK-ORDER-TYPE-CD = 'FW003' AND                         
P0795C         AT-ACCOUNT-NO > 0 AND AT-CODE-ACCT-STAT NOT = 'P'        
P0795C         PERFORM 7035-SELECT-LOCAL-OFFICE THRU 7035-EXIT          
P0795C         PERFORM 7040-CHECK-ELEC-METER   THRU 7040-EXIT           
P0795E         PERFORM 7042-CHECK-GAS-METER   THRU 7042-EXIT            
P0795C         IF WS-LOCOFF-GAS-ONLY-FL = 'N' AND                       
P0795C            WS-ELEC-METER-FOUND = 'N' AND                         
P0795C            WS-GAS-METER-FOUND = 'Y'                              
P0795C             MOVE 0 TO S-RETURN-CODE                              
P0795C             MOVE 'ORDR000327' TO S-BUS-RULE-ID                   
P0795C             MOVE 'P' TO S-ACTION-TYPE-CD                         
P0795C             PERFORM 7013-RULE-XREF THRU 7013-EXIT                
P0795C             PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
P0795C         END-IF                                                   
P0795C      END-IF.                                                     
                                                                        
           IF A4-ERROR-MSG-NO > ' '                                     
               MOVE 0 TO S-RETURN-CODE                                  
               MOVE 'ORDR000009' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-ACTION-TYPE-CD(1:1)                        
               MOVE A4-ERROR-MSG-NO TO S-ACTION-TYPE-CD(2:5)            
               MOVE 'N' TO S-HARD-ERROR                                 
               PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
                                                                        
           IF O2-ERROR-MSG-NO > ' '                                     
               MOVE 0 TO S-RETURN-CODE                                  
               MOVE 'ORDR000009' TO S-BUS-RULE-ID                       
               MOVE 'F' TO S-ACTION-TYPE-CD(1:1)                        
               MOVE O2-ERROR-MSG-NO TO S-ACTION-TYPE-CD(2:5)            
               MOVE 'N' TO S-HARD-ERROR                                 
               PERFORM 7013-RULE-XREF THRU 7013-EXIT                    
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                 
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-MAINTAIN-INIT.                                              
                                                                        
           IF LINK-ORDER-TYPE-CHG-FL = 'Y'                              
                                                                        
              IF LINK-ORDER-TYPE-CD(1:2) = 'CC'                         
                PERFORM 7003-COUNT-PENDING-CC THRU 7003-EXIT            
              END-IF                                                    
                                                                        
              IF LINK-ORDER-TYPE-CD(1:2) = 'OFF'                        
                PERFORM 7002-COUNT-PENDING-OFF THRU 7002-EXIT           
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3000-NEXT-BUSINESS-DAY.                                          
                                                                        
           EXEC SQL                                                     
               SELECT
              DATEADD( DAY, CIS.DECIMAL2DAY(:WS-STEP), 
              IIF(TRY_CONVERT(DATE, :WS-INPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-INPUT-DATE
              ) <> 0) OR (LEN(:WS-INPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :WS-INPUT-DATE
              ), CONVERT(DATE, :WS-INPUT-DATE) ) )
            INTO
              :WS-OUTPUT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (DATE(:WS-INPUT-DATE) +                                  
MFA-TR*                 DAY(:WS-STEP) DAYS)                                     
MFA-TR*          INTO :WS-OUTPUT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              CIS.DAYOFWEEK_ISO( IIF(TRY_CONVERT(DATE, :WS-OUTPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OUTPUT-DATE
              ) <> 0) OR (LEN(:WS-OUTPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-OUTPUT-DATE
              ), CONVERT(DATE, :WS-OUTPUT-DATE) ) )
            INTO
              :WS-DAYOFWEEK-ISO                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  DAYOFWEEK_ISO(:WS-OUTPUT-DATE)                           
MFA-TR*          INTO :WS-DAYOFWEEK-ISO                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-DAYOFWEEK-ISO TO WS-DAY-OF-WEEK.                     
           IF WS-DAY-OF-WEEK = 6 OR 7                                   
               ADD 1 TO WS-STEP                                         
               GO TO 3000-NEXT-BUSINESS-DAY
           END-IF.                            
           PERFORM 7011-HOLIDAY THRU 7011-EXIT.                         
           IF WS-HOLIDAY = 'Y'                                          
               ADD 1 TO WS-STEP                                         
               GO TO 3000-NEXT-BUSINESS-DAY
           END-IF.                            
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00099                                                 
           END-EXEC.                                                            
                                                                        
       6995-CPD99-ERROR-ROUTINE.                                        
                                                                        
           MOVE PROGRAM-NAME TO ABEND-PROGRAM.                          
           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                   
                                                                        
       6995-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODE_RENTAL_PROP,                                  
                     ERROR_MSG_NO,                                      
                     COMPANY_NO                                         
                INTO :PR-CODE-RENTAL-PROP,                              
                     :A4-ERROR-MSG-NO,                                  
                     :PR-COMPANY-NO                                     
                FROM CSS_PREMISE PR WITH(READUNCOMMITTED),                      
                     CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
                     CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
               WHERE PREMISE_NO        = :PR-PREMISE-NO                 
                 AND DY.ADDRESS_ID     = PR.ADDRESS_ID                  
                 AND DY.ZIP_CODE       = A4.ZIP_CODE                    
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_RENTAL_PROP,                                          
MFA-TR*              ERROR_MSG_NO,                                              
MFA-TR*              COMPANY_NO                                                 
MFA-TR*         INTO :PR-CODE-RENTAL-PROP,                                      
MFA-TR*              :A4-ERROR-MSG-NO,                                          
MFA-TR*              :PR-COMPANY-NO                                             
MFA-TR*         FROM CSS_PREMISE PR,                                            
MFA-TR*              CSS_ADDR_FORMATTED DY,                                     
MFA-TR*              CSS_ZIP_CODE A4                                            
MFA-TR*        WHERE PREMISE_NO        = :PR-PREMISE-NO                         
MFA-TR*          AND DY.ADDRESS_ID     = PR.ADDRESS_ID                          
MFA-TR*          AND DY.ZIP_CODE       = A4.ZIP_CODE                            
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                 
                   MOVE 'CSS_ZIP_CODE'      TO TABLE-3                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7001-SELECT-CUSTOMER.                                            
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO                                        
                INTO :CU-CUSTOMER-NO                                    
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO     = :CU-CUSTOMER-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*         INTO :CU-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO     = :CU-CUSTOMER-NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7001'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUSTOMER'      TO TABLE-1                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE CU-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7002-COUNT-PENDING-OFF.                                          
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-COUNT                                          
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO      = :PR-PREMISE-NO                   
                 AND ORDER_TYPE_CD   LIKE 'OFF%'                        
                 AND ORDER_STATE_CD  NOT IN ('C', 'Z')                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-COUNT                                                  
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO      = :PR-PREMISE-NO                           
MFA-TR*          AND ORDER_TYPE_CD   LIKE 'OFF%'                                
MFA-TR*          AND ORDER_STATE_CD  NOT IN ('C', 'Z')                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7002                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   EVALUATE WS-COUNT                                    
                       WHEN 0                                           
                           MOVE 0 TO S-RETURN-CODE                      
                           MOVE 'OFF01' TO S-BUS-RULE-ID                
                           MOVE 'T' TO S-ACTION-TYPE-CD                 
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                       WHEN 1                                           
                           MOVE 0 TO S-RETURN-CODE                      
                           MOVE 'OFF02' TO S-BUS-RULE-ID                
                           MOVE 'T' TO S-ACTION-TYPE-CD                 
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                       WHEN 2                                           
                           MOVE 0 TO S-RETURN-CODE                      
                           MOVE 'OFF03' TO S-BUS-RULE-ID                
                           MOVE 'T' TO S-ACTION-TYPE-CD                 
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                       WHEN OTHER                                       
                           MOVE 0 TO S-RETURN-CODE                      
                           MOVE 'OFF01' TO S-BUS-RULE-ID                
                           MOVE 'T' TO S-ACTION-TYPE-CD                 
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                   END-EVALUATE                                         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT                                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7002'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7003-COUNT-PENDING-CC.                                           
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-COUNT                                          
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO      = :PR-PREMISE-NO                   
                 AND ORDER_TYPE_CD   LIKE 'CC%'                         
                 AND ORDER_STATE_CD  NOT IN ('C', 'Z')                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-COUNT                                                  
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO      = :PR-PREMISE-NO                           
MFA-TR*          AND ORDER_TYPE_CD   LIKE 'CC%'                                 
MFA-TR*          AND ORDER_STATE_CD  NOT IN ('C', 'Z')                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7003                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   EVALUATE WS-COUNT                                    
                       WHEN 0                                           
                           MOVE 0 TO S-RETURN-CODE                      
                           MOVE 'CC001' TO S-BUS-RULE-ID                
                           MOVE 'T' TO S-ACTION-TYPE-CD                 
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                       WHEN 1                                           
                           MOVE 0 TO S-RETURN-CODE                      
                           MOVE 'CC002' TO S-BUS-RULE-ID                
                           MOVE 'T' TO S-ACTION-TYPE-CD                 
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                       WHEN 2                                           
                           MOVE 0 TO S-RETURN-CODE                      
                           MOVE 'CC003' TO S-BUS-RULE-ID                
                           MOVE 'T' TO S-ACTION-TYPE-CD                 
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                       WHEN OTHER                                       
                           MOVE 0 TO S-RETURN-CODE                      
                           MOVE 'CC001' TO S-BUS-RULE-ID                
                           MOVE 'T' TO S-ACTION-TYPE-CD                 
                           PERFORM 8100-SEND-RESULT THRU 8100-EXIT      
                   END-EVALUATE                                         
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT                                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7003'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7004-PENDING-NC.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 1                                                  
                INTO :WS-COUNT                                          
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO      = :PR-PREMISE-NO                   
                 AND ORDER_TYPE_CD   = 'NC001'                          
                 AND ORDER_STATE_CD  NOT IN ('C', 'Z')                  
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1                                                          
MFA-TR*         INTO :WS-COUNT                                                  
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO      = :PR-PREMISE-NO                           
MFA-TR*          AND ORDER_TYPE_CD   = 'NC001'                                  
MFA-TR*          AND ORDER_STATE_CD  NOT IN ('C', 'Z')                          
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7004                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT                                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7004'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7004-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7005-LL-CUSTOMER.                                                
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO                                        
                INTO :SI-CUSTOMER-NO                                    
                FROM CSS_LANDLORD WITH(READUNCOMMITTED)                         
               WHERE PREMISE_NO      = :PR-PREMISE-NO                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO                                                
MFA-TR*         INTO :SI-CUSTOMER-NO                                            
MFA-TR*         FROM CSS_LANDLORD                                               
MFA-TR*        WHERE PREMISE_NO      = :PR-PREMISE-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7005                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO SI-CUSTOMER-NO                             
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7005'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_LANDLORD'      TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7006-SELECT-MTRENV.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO                                           
                INTO :MN-METER-NO                                       
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*         INTO :MN-METER-NO                                               
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7006                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-MN-FOUND                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-MN-FOUND                              
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7006'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7006-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7007-SELECT-CSTPLN.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RATE_ITEM_CODE                                     
                INTO :CP-RATE-ITEM-CODE                                 
                FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_ITEM_CODE                                             
MFA-TR*         INTO :CP-RATE-ITEM-CODE                                         
MFA-TR*         FROM CSS_CUST_PLAN                                              
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7007                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-CP-FOUND                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-CP-FOUND                              
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7007'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_PLAN'     TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7007-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7008-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO,                                        
                     CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     CODE_ACCT_STAT,                                    
                     ACCOUNT_TYPE_CODE,                                 
                     MST_SUB_ACCT_IND,                                  
                     NO_BILL_COPIES,                                    
                     LOCAL_OFFICE                                       
                INTO :AT-COMPANY-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-CODE-ACCT-STAT,                                
                     :AT-ACCOUNT-TYPE-CODE,                             
                     :AT-MST-SUB-ACCT-IND,                              
                     :AT-NO-BILL-COPIES,                                
                     :AT-LOCAL-OFFICE                                   
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              MST_SUB_ACCT_IND,                                          
MFA-TR*              NO_BILL_COPIES,                                            
MFA-TR*              LOCAL_OFFICE                                               
MFA-TR*         INTO :AT-COMPANY-NO,                                            
MFA-TR*              :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-MST-SUB-ACCT-IND,                                      
MFA-TR*              :AT-NO-BILL-COPIES,                                        
MFA-TR*              :AT-LOCAL-OFFICE                                           
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7008                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7008'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7008-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7009-SECURITY.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-SECURITY-OK                                    
P0795G          FROM CSS_CATEGORY F5 WITH(READUNCOMMITTED)                      
               WHERE (F5.CATEGORY_ID = 220                              
                  OR F5.CATEGORY_ID = 9999)                             
                 AND F5.USER_ID = :LINK-USERID                          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-SECURITY-OK                                            
MFA-TR*         FROM CSS_CATEGORY F5                                            
MFA-TR*        WHERE (F5.CATEGORY_ID = 220                                      
MFA-TR*           OR F5.CATEGORY_ID = 9999)                                     
MFA-TR*          AND F5.USER_ID = :LINK-USERID                                  
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7009                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SECURITY-OK                           
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SECURITY-OK                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7009'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_NAVIGATION'    TO TABLE-1                  
                   MOVE 'CSS_CATEGORY'      TO TABLE-2                  
                   MOVE 'USER_ID'           TO TABLE-ELEMENT-1          
                   MOVE LINK-USERID         TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7009-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SECURED-RATES.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) SECURED_RATE_FL                                    
                INTO :RD-SECURED-RATE-FL                                
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                 
                     CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              
                 AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                  
                 AND SECURED_RATE_FL = 'Y'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SECURED_RATE_FL                                            
MFA-TR*         INTO :RD-SECURED-RATE-FL                                        
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT,                                       
MFA-TR*              CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE                      
MFA-TR*          AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                          
MFA-TR*          AND SECURED_RATE_FL = 'Y'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SECURED-RATE                          
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SECURED-RATE                          
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                  
                   MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-2                 
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7011-HOLIDAY.                                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-HOLIDAY                                       
                 FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                         
                WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :WS-OUTPUT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OUTPUT-DATE
              ) <> 0) OR (LEN(:WS-OUTPUT-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-OUTPUT-DATE
              ), CONVERT(DATE, :WS-OUTPUT-DATE) )                      
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-HOLIDAY                                               
MFA-TR*          FROM CSS_HOLIDAY                                               
MFA-TR*         WHERE HOLIDAY_DT = :WS-OUTPUT-DATE                              
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7011                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-HOLIDAY                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-HOLIDAY                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7011'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_HOLIDAY'    TO TABLE-1                     
                   MOVE 'HOLIDAY_DT'     TO TABLE-ELEMENT-1             
                   MOVE WS-OUTPUT-DATE   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7012-NEW-CUSTOMER.                                               
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-NEW-CUST-ACTIVE                                
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE CUSTOMER_NO     = :WS-NEW-CUSTOMER-NO              
                 AND CODE_ACCT_STAT  = 'A'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-NEW-CUST-ACTIVE                                        
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE CUSTOMER_NO     = :WS-NEW-CUSTOMER-NO                      
MFA-TR*          AND CODE_ACCT_STAT  = 'A'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7012                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-NEW-CUST-ACTIVE                       
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-NEW-CUST-ACTIVE                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7012'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1          
                   MOVE WS-NEW-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7012-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7013-RULE-XREF.                                                  
                                                                        
           MOVE S-BUS-RULE-ID TO 1T-BUS-RULE-ID.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                    
               WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                   
                 AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                
                 AND APPLICATION_ID = 'CSR'                             
                 AND COMPANY_NO     = '00'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE_XREF                                          
MFA-TR*        WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                           
MFA-TR*          AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                        
MFA-TR*          AND APPLICATION_ID = 'CSR'                                     
MFA-TR*          AND COMPANY_NO     = '00'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7013                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID       
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BUS-RULE-XREF-ID                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7013'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_RULE_XREF' TO TABLE-1                  
                   MOVE 'BUS_RULE_ID'       TO TABLE-ELEMENT-1          
                   MOVE 1T-BUS-RULE-ID      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7013-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7014-BARRIER-ISLAND.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ERROR_MSG_NO                                       
                INTO :O2-ERROR-MSG-NO                                   
                FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),                 
                     CSS_LOC_OFF_CYC_RT O2 WITH(READUNCOMMITTED)                
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                 AND O2.LOCAL_OFFICE = :AT-LOCAL-OFFICE                 
                 AND UT.READ_ROUTE = O2.READ_ROUTE                      
                 AND UT.READ_CYCLE = O2.READ_CYCLE                      
                 AND ERROR_MSG_NO > ' '                                 
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ERROR_MSG_NO                                               
MFA-TR*         INTO :O2-ERROR-MSG-NO                                           
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT,                                       
MFA-TR*              CSS_LOC_OFF_CYC_RT O2                                      
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*          AND O2.LOCAL_OFFICE = :AT-LOCAL-OFFICE                         
MFA-TR*          AND UT.READ_ROUTE = O2.READ_ROUTE                              
MFA-TR*          AND UT.READ_CYCLE = O2.READ_CYCLE                              
MFA-TR*          AND ERROR_MSG_NO > ' '                                         
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7014                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO O2-ERROR-MSG-NO                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7014'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-1                  
                   MOVE 'CSS_LOC_OFF_CYC_RT' TO TABLE-2                 
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7014-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7015-SET-ORDERS.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) ACCOUNT_NO                                         
                INTO :VO-ACCOUNT-NO                                     
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
                 AND ORDER_TYPE_CD = 'FM002'                            
                 AND ORDER_STATE_CD NOT IN ('C', 'Z')                   
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :VO-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*          AND ORDER_TYPE_CD = 'FM002'                                    
MFA-TR*          AND ORDER_STATE_CD NOT IN ('C', 'Z')                           
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7015                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-SET-ORDER-FL                          
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SET-ORDER-FL                          
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7015'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-ITPA.                                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CK.CR_HIST_TRAN_DT,
              REPLACE(CONVERT(CHAR(8), CK.CR_HIST_TRAN_TM, 108), ':', 
           '.') CR_HIST_TRAN_TM,
              LF.ITPA_RSLT_CURR_CD                              
                 INTO :CK-CR-HIST-TRAN-DT,                              
                      :CK-CR-HIST-TRAN-TM,                              
                      :LF-ITPA-RSLT-CURR-CD                             
                 FROM CSS_CREDIT_HIST CK WITH(READUNCOMMITTED),                 
                      CSS_CRED_ITPA_HIST LF WITH(READUNCOMMITTED)               
                WHERE CK.CUSTOMER_NO = :WS-NEW-CUSTOMER-NO              
                  AND CK.CR_HIST_TRAN_TM =                              
                     (SELECT MAX(CR_HIST_TRAN_TM)                       
                        FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)              
                       WHERE CUSTOMER_NO = :WS-NEW-CUSTOMER-NO          
                         AND CR_HIST_TRAN_DT =                          
                          (SELECT MAX(CR_HIST_TRAN_DT)                  
                             FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)         
                            WHERE CUSTOMER_NO = :WS-NEW-CUSTOMER-NO))   
                  AND CK.CR_HIST_TRAN_DT =                              
                   (SELECT MAX(CR_HIST_TRAN_DT)                         
                       FROM CSS_CREDIT_HIST WITH(READUNCOMMITTED)               
                 WHERE CUSTOMER_NO = :WS-NEW-CUSTOMER-NO)               
                   AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                  
                   AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT          
                   AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM          
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CK.CR_HIST_TRAN_DT,                                       
MFA-TR*               CK.CR_HIST_TRAN_TM,                                       
MFA-TR*               LF.ITPA_RSLT_CURR_CD                                      
MFA-TR*          INTO :CK-CR-HIST-TRAN-DT,                                      
MFA-TR*               :CK-CR-HIST-TRAN-TM,                                      
MFA-TR*               :LF-ITPA-RSLT-CURR-CD                                     
MFA-TR*          FROM CSS_CREDIT_HIST CK,                                       
MFA-TR*               CSS_CRED_ITPA_HIST LF                                     
MFA-TR*         WHERE CK.CUSTOMER_NO = :WS-NEW-CUSTOMER-NO                      
MFA-TR*           AND CK.CR_HIST_TRAN_TM =                                      
MFA-TR*              (SELECT MAX(CR_HIST_TRAN_TM)                               
MFA-TR*                 FROM CSS_CREDIT_HIST                                    
MFA-TR*                WHERE CUSTOMER_NO = :WS-NEW-CUSTOMER-NO                  
MFA-TR*                  AND CR_HIST_TRAN_DT =                                  
MFA-TR*                   (SELECT MAX(CR_HIST_TRAN_DT)                          
MFA-TR*                      FROM CSS_CREDIT_HIST                               
MFA-TR*                     WHERE CUSTOMER_NO = :WS-NEW-CUSTOMER-NO))           
MFA-TR*           AND CK.CR_HIST_TRAN_DT =                                      
MFA-TR*            (SELECT MAX(CR_HIST_TRAN_DT)                                 
MFA-TR*                FROM CSS_CREDIT_HIST                                     
MFA-TR*          WHERE CUSTOMER_NO = :WS-NEW-CUSTOMER-NO)                       
MFA-TR*            AND CK.CUSTOMER_NO = LF.CUSTOMER_NO                          
MFA-TR*            AND CK.CR_HIST_TRAN_DT = LF.CR_HIST_TRAN_DT                  
MFA-TR*            AND CK.CR_HIST_TRAN_TM = LF.CR_HIST_TRAN_TM                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7020                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF LF-ITPA-RSLT-CURR-CD = 'R'                        
                       MOVE 'N' TO WS-ITPA-FL                           
                   ELSE                                                 
                       MOVE 'Y' TO WS-ITPA-FL                           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-ITPA-FL                               
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
                   MOVE '7020'        TO ACTIVE-PARAGRAPH               
                   MOVE 'SELECT'      TO ABEND-FUNCTION                 
                   MOVE 'CSS_CREDIT_HIST' TO TABLE-1                    
                   MOVE 'CSS_CRED_ITPA_HIST' TO TABLE-2                 
                   MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
                   MOVE WS-NEW-CUSTOMER-NO TO HOSTVAR-ELEMENT-1         
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-NEW-CUSTOMER-INFO.                                          
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO_ORIG                                    
                INTO :WS-NEW-CUST-COMPANY                               
                FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
               WHERE CUSTOMER_NO   = :WS-NEW-CUSTOMER-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO_ORIG                                            
MFA-TR*         INTO :WS-NEW-CUST-COMPANY                                       
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO   = :WS-NEW-CUSTOMER-NO                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7025'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUSTOMER'      TO TABLE-1                  
                   MOVE 'CUSTOMER NO'       TO TABLE-ELEMENT-1          
                   MOVE WS-NEW-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795 7030-GET-ORDER-TYPE-INFO.                                        
P00795*                                                                         
P00795     MOVE LINK-ORDER-TYPE-CD  TO  C2-ORDER-TYPE-CD                
P00795     EXEC SQL                                                     
P00795         SELECT ORDER_GROUP_CD                                    
P00795           INTO :C2-ORDER-GROUP-CD                                
P00795           FROM CSS_ORDER_TYPE WITH(READUNCOMMITTED)                      
P00795          WHERE ORDER_TYPE_CD =  :C2-ORDER-TYPE-CD                
P00795            AND COMPANY_NO    = :AT-COMPANY-NO                    
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ORDER_GROUP_CD                                            
MFA-TR*          INTO :C2-ORDER-GROUP-CD                                        
MFA-TR*          FROM CSS_ORDER_TYPE                                            
MFA-TR*         WHERE ORDER_TYPE_CD =  :C2-ORDER-TYPE-CD                        
MFA-TR*           AND COMPANY_NO    = :AT-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795*                                                                         
P00795     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P00795*                                                                         
P00795     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00795         WHEN SUCCESSFUL-CALL                                     
P00795             CONTINUE                                             
P00795         WHEN NOT-FOUND                                           
P00795             MOVE SPACES TO C2-ORDER-TYPE-CD                      
P00795         WHEN OTHER                                               
P00795             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00795             MOVE SQLCODE             TO ABEND-SQLCODE            
P00795             MOVE SQLSTATE            TO ABEND-SQLSTATE           
P00795             MOVE '7030'           TO ACTIVE-PARAGRAPH            
P00795             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00795             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00795                                           ABEND-TABLES           
P00795             MOVE 'CSS_ORDER-TYPE'     TO TABLE-1                 
P00795             MOVE 'ORDER-TYPE'         TO TABLE-ELEMENT-1         
P00795             MOVE C2-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
P00795             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00795     END-EVALUATE.                                                
P00795*                                                                         
P00795 7030-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
P0795C 7035-SELECT-LOCAL-OFFICE.                                        
P0795C                                                                  
P0795C     MOVE AT-LOCAL-OFFICE TO B1-LOCAL-OFFICE                      
P0795C     MOVE AT-COMPANY-NO TO B1-COMPANY-NO                          
P0795C                                                                  
P0795C     EXEC SQL                                                     
P0795C        SELECT TOP(1) SERV_ORDER_WORK_CD                                 
P0795C          INTO :B1-SERV-ORDER-WORK-CD                             
P0795C          FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
P0795C         WHERE LOCAL_OFFICE  = :B1-LOCAL-OFFICE                   
P0795C           AND COMPANY_NO    = :B1-COMPANY-NO                     
P0795C                                           
P0795C                                                           
P0795C                                                      
P0795C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SERV_ORDER_WORK_CD                                         
MFA-TR*         INTO :B1-SERV-ORDER-WORK-CD                                     
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE LOCAL_OFFICE  = :B1-LOCAL-OFFICE                           
MFA-TR*          AND COMPANY_NO    = :B1-COMPANY-NO                             
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7035                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795C                                                                  
P0795C     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0795C                                                                  
P0795C     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795C         WHEN SUCCESSFUL-CALL                                     
P0795C              IF B1-SERV-ORDER-WORK-CD = 'DISTR' OR 'METRO'       
P0795C                 MOVE 'N' TO WS-LOCOFF-GAS-ONLY-FL                
P0795C              ELSE                                                
P0795C                 MOVE 'Y' TO WS-LOCOFF-GAS-ONLY-FL                
P0795C              END-IF                                              
P0795C         WHEN OTHER                                               
P0795C             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
P0795C             MOVE SQLCODE             TO ABEND-SQLCODE            
P0795C             MOVE SQLSTATE            TO ABEND-SQLSTATE           
P0795C             MOVE '7035'              TO ACTIVE-PARAGRAPH         
P0795C             MOVE 'SELECT'            TO ABEND-FUNCTION           
P0795C             MOVE 'CSS_LOCAL_OFFICE'  TO TABLE-1                  
P0795C             MOVE 'LOCAL-OFFICE'      TO TABLE-ELEMENT-1          
P0795C             MOVE B1-LOCAL-OFFICE     TO HOSTVAR-ELEMENT-1        
P0795C             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0795C     END-EVALUATE.                                                
P0795C                                                                  
P0795C 7035-EXIT.                                                       
P0795C     EXIT.                                                        
P0795C                                                                  
P0795C 7040-CHECK-ELEC-METER.                                           
P0795C                                                                  
P0795C     EXEC SQL                                                     
P0795C        SELECT TOP(1) METER_NO                                           
P0795C          INTO :MN-METER-NO                                       
P0795C          FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
P0795C         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
P0795C           AND CODE_UTIL_TYPE = 'E'                               
P0795C                                           
P0795C                                                           
P0795C                                                      
P0795C     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*         INTO :MN-METER-NO                                               
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*          AND CODE_UTIL_TYPE = 'E'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795C                                                                  
P0795C     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0795C                                                                  
P0795C     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795C         WHEN SUCCESSFUL-CALL                                     
P0795C             MOVE 'Y' TO WS-ELEC-METER-FOUND                      
P0795C         WHEN NOT-FOUND                                           
P0795C             MOVE 'N' TO WS-ELEC-METER-FOUND                      
P0795C             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P0795C         WHEN OTHER                                               
P0795C             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
P0795C             MOVE SQLCODE             TO ABEND-SQLCODE            
P0795C             MOVE SQLSTATE            TO ABEND-SQLSTATE           
P0795C             MOVE '7040'              TO ACTIVE-PARAGRAPH         
P0795C             MOVE 'SELECT'            TO ABEND-FUNCTION           
P0795C             MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
P0795C             MOVE 'ACCOUNT-NO'        TO TABLE-ELEMENT-1          
P0795C             MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
P0795C             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0795C     END-EVALUATE.                                                
P0795C                                                                  
P0795C 7040-EXIT.                                                       
P0795C     EXIT.                                                        
                                                                        
P0795E 7042-CHECK-GAS-METER.                                            
P0795E                                                                  
P0795E     EXEC SQL                                                     
P0795E        SELECT TOP(1) METER_NO                                           
P0795E          INTO :MN-METER-NO                                       
P0795E          FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
P0795E         WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
P0795E           AND CODE_UTIL_TYPE = 'G'                               
P0795E                                           
P0795E                                                           
P0795E                                                      
P0795E     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*         INTO :MN-METER-NO                                               
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*          AND CODE_UTIL_TYPE = 'G'                                       
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7042                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795E                                                                  
P0795E     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0795E                                                                  
P0795E     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795E         WHEN SUCCESSFUL-CALL                                     
P0795E             MOVE 'Y' TO WS-GAS-METER-FOUND                       
P0795E         WHEN NOT-FOUND                                           
P0795E             MOVE 'N' TO WS-GAS-METER-FOUND                       
P0795E             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P0795E         WHEN OTHER                                               
P0795E             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
P0795E             MOVE SQLCODE             TO ABEND-SQLCODE            
P0795E             MOVE SQLSTATE            TO ABEND-SQLSTATE           
P0795E             MOVE '7042'              TO ACTIVE-PARAGRAPH         
P0795E             MOVE 'SELECT'            TO ABEND-FUNCTION           
P0795E             MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
P0795E             MOVE 'ACCOUNT-NO'        TO TABLE-ELEMENT-1          
P0795E             MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
P0795E             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0795E     END-EVALUATE.                                                
P0795E                                                                  
P0795E 7042-EXIT.                                                       
P0795E     EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04477_R1                            
             (                                                          
              RETURN_CODE,                                              
              BUS_RULE_ID,                                              
              ACTION_TYPE_CD,                                           
              BUS_RULE_XREF_ID,                                         
              HARD_ERROR                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE,                                          
               :S-BUS-RULE-ID,                                          
               :S-ACTION-TYPE-CD,                                       
               :S-BUS-RULE-XREF-ID,                                     
               :S-HARD-ERROR                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04477_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       ACTION_TYPE_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID,                                                 
MFA-TR*       HARD_ERROR                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE,                                                  
MFA-TR*        :S-BUS-RULE-ID,                                                  
MFA-TR*        :S-ACTION-TYPE-CD,                                               
MFA-TR*        :S-BUS-RULE-XREF-ID,                                             
MFA-TR*        :S-HARD-ERROR                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04477_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04477_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04477_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04477_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE                               
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
