       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04476.                                          
       AUTHOR.       FRAN BARRY.                                        
       DATE-WRITTEN. AUG 2011.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS IS THE ORDER INITIATION RETRIEVE DRIVER.                 *        
      *  STATUS CODE VALUES ARE:                                       *        
      *       150    UNABLE TO DETERMINE ORDER TYPE (OF/UM)            *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE     INITIAL   COMMENTS                                 *        
      *  ---------- -------   ---------------------------------------  *        
      *  08/16/2011 FMB       INITIAL VERSION                          *        
A04670*  06/04/2013 FMB       ADD PR THRESHOLD PROCESSING.             *        
A04670*  08/02/2013 FMB       PERFORM PR PROCESSING ONLY ONCE.         *        
A04670*  08/06/2013 FMB       HANDLE -204 SQLCODE TO AVOID LOOPING.    *        
A04670*  09/03/2013 FMB       ADD CODE_RENTAL_PROP TO RS2. RETURN      *        
A04670*                       LANDLORD CUSTOMER NUMBER IN A NON-REVERT *        
A04670*                       SITUATION.                               *        
A04670*  09/30/2013 FMB       NEW BUSINESS RULE FOR ELECTRIC SOL.      *        
A04670*  12/26/2013 DB18339   ADDING NEW BUSINESS RULE FOR DEFECT 1946 *        
A4670A*  02/18/2014 PK44514   DEFECT 3142 - SENDING BACK CURR ACCOUNT  *        
A4670A*                       AT A PREMISES IN RS2                     *        
A4670B*  02/27/2014 DB18339   ADDED NEW BUSINESS RULE FOR DEFECT 1946  *        
P00795*  03/05/2014 PK44514   AOO - ADD INPUT PARM ORDER_TYPE_CD       *        
P00795*  06/20/2014 PK44514         AND WORK_TYPE_CODE, CODE_UTIL_TYPE *        
P00718*  03/17/2014 VV90387   CHANGES FOR BUSINESS UNIT                *        
P0795A** 04/17/2014 PK44514   RETURN MARKET CONTRACTS IN RS12          *        
P0795B** 06/02/2014 PK44514   NEW SET ORDER INITIATION                 *        
P0795C** 07/14/2014 PK44514   DO NOT DEFAULT WORK TYPE FOR AOO, WHEN   *        
P0795C**                      > 1 METERS EXISTS FOR THE UTILITY SENT IN*        
P0795D*  01/22/2015 PK44514   DEFECT 5515 - CHECK IF ORDER TYPE/WORK   *        
P0795D*                       TYPE IS STILL VALID - FOR ALL PROCESSES  *        
A05189*  02/20/2015 PK44514   AROP CHANGES- SEND BACK AROP-READ-ONLY-FL*        
A05189*                       IN RS2                                   *        
P0795E*  03/24/2015 PK44514   DEFECT 7014 - DO NOT ALLOW ACCOUNT XFER  *        
P0795E*                       ON SUB ACCOUNTS. FILTER OUT SUBACCOUNTS  *        
P0795E*                       FROM LIST OF TRANSFER TO ACCOUNTS.       *        
P0795F*  04/21/2015 PK44514   DEFECT 7103 - DO NOT SEND BACK AVAILABLE *        
P0795F*                       DATES FOR SAME DAY ORDERS.               *        
P0795G*  04/24/2015 PK44514   DEFECT 7074 - ADD CRAWL APPLIANCE FLAG TO*        
P0795G*                       CSR04480                                 *        
P0795H*  04/30/2015 PK44514   DEFECT 7069 - ENABLE RLSE CHECKBOX FOR   *        
P0795H*                       AOO/SST BASED ON CSS_ORDER_WK TYPE TABLE *        
P0795I*  05/25/2015 PK44514   MAINTN                                   *        
P0795J*  08/28/2015 PK44514   SHOW SUDBIV LIGHTING CHRGS FOR NEW SETS  *        
DT9484*  10/29/2015 PK44514   FOR MAINTAIN CHECK FOR 3 OFFS ON PREMISES*        
      *                       AND SPACE OUT ORDER REASON IF CC TO OFF  *        
      *                       ON REVERT                                *        
DT9505*  11/02/2015 PK44514   FIX FOR TRANSFER TO ACCOUNTS SHOWING FOR *        
      *                       THE NEW CU AND NOT FOR MOVING-OUT CU     *        
DT9511*  11/06/2015 PK44514   RETRIEVE SO CONTRACT INFO                *        
DT6945*  12/14/2015 DB18339   USING SAME DAY FL FROM ORDER_WK_TYPE     *        
DT6945*                       WHEN NECESSARY.                          *        
DT9985*  01/14/2016 PK44514   FOR MAINTAIN PROCESS RETURN CODE RENTAL  *        
DT9985*                       PROP AS SPACES                           *        
D00087*  02/03/2016 PK44514   FIX WORK AREA ISSUES WHEN VIEWING GAS    *        
D00087*                       CONSTR ORDERS IN PREMISE ONLY            *        
DT9528*  02/19/2016 PK44514   RETURN CDP FOR MAINTAIN                  *        
DT8959*  02/19/2016 PK44514   ACCT XFER  FOR MAINTAIN                  *        
D10742*  03/23/2016 PK44514   DO NOT ALLOW ACCT TRANSFER TO NON-UTILITY*        
D10742*                       AND MASTER ACCOUNTS.                     *        
D10605*  04/01/2016 PK44514   DISABLE RLSE ENABLED FLAG FOR CANCELLED  *        
D10605*                       AND COMPLETED ORDERS.                    *        
D10675*  04/22/2016 PK44514   SEND CORRECT WORK DISTRICT WHEN ORDER    *        
D10675*                       TYPE CHANGED                             *        
D10004*  05/12/2016 PK44514   PAYMENT REQUIRED FOR CLICK CHANGES       *        
D10775*  05/20/2016 PK44514   EASY ORDERS BANKRUPTCY                   *        
D11837*  08/12/2016 PK44514   SENDING BACK SO SEQ NO:TO SEND CANCEL TO *        
D11837*                       CLICK FOR ROW WHERE WORK TYPE IS BLANKED *        
DT9519*  08/16/2016 PK44514   SENDING BACK CANCEL REASON CODE          *        
A10004*  08/31/2016 PK44514   FIX FOR NOT ABLE TO VIEW HISTORY ORDERS  *        
D12436*  10/18/2016 PK44514   DEFECT 12436-WHEN CHANGING CC TO OFF     *        
D12436*                       REMOVE LIGHT INDICATOR                   *        
12436A*  12/12/2016 PK44514   DEFECT 12436-RLSE IND NOT DISPLAYING IN  *        
12436A*                       MAINT IF WORK TYPE IS BLANK.             *        
D26004*  01/19/2017 PK44514   DEFECT 26004 -GCR WORKTYPE SHOULD DEFAULT*        
D26004*                       SAME WAY AS CKR WKTYPE IN INITIATION     *        
D26359*  02/09/2017 PK44514   TO PREVENT UPDATE TO WORK TYPE IF A ROW  *        
D26359*                       EXISTS IN SO_METER FOR SOME WORK TYPES.  *        
D26613*  02/28/2017 PK44514   DEFECT 26613-TO DEFAULT CALCULATED WORK  *        
D26613*                       TYPES FOR CC TO OFF REQUEST TYPE CHANGE  *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04476'.
MSQ017     COPY MFASQLM.
                                                                        
       01 WS-START                       PIC X(40)  VALUE               
           'WORKING STORAGE FOR CSR04476 STARTS HERE'.                  
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME-1              PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R1'.          
            05  GTT-NAME-3              PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R3'.          
            05  GTT-NAME-4              PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R4'.          
            05  GTT-NAME-5              PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R5'.          
            05  GTT-NAME-6              PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R6'.          
            05  GTT-NAME-7              PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R7'.          
            05  GTT-NAME-8              PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R8'.          
            05  GTT-NAME-9              PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R9'.          
            05  GTT-NAME-10             PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R10'.         
            05  GTT-NAME-11             PIC X(26) VALUE                 
                                        'SESSION.CSR04476_R11'.         
P0795A*     05  GTT-NAME-12             PIC X(26) VALUE                         
P0795A*                                 'SESSION.CSR04476_R12'.                 
DT9511      05  GTT-NAME-16             PIC X(26) VALUE                 
DT9511                                  'SESSION.CSR04476_R16'.         
       01 GTT-RETURN-FIELDS.                                            
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1        PIC S9(9) COMP VALUE ZERO.       
             10 S-STATUS-CODE          PIC S9(9) COMP VALUE ZERO.       
             10 S-BUS-RULE-ID          PIC X(10) VALUE SPACES.          
             10 S-ACTION-TYPE-CD       PIC X(08) VALUE SPACES.          
             10 S-BUS-RULE-XREF-ID     PIC X(26) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2        PIC S9(9) COMP VALUE 0.          
             10 S-BILL-ADDRESS         PIC X(80) VALUE SPACES.          
             10 S-NEXT-BUS-DAY         PIC X(10) VALUE SPACES.          
             10 S-HIGH-LEVEL-ORDER     PIC X(05) VALUE SPACES.          
             10 S-HARD-ERROR           PIC X(01) VALUE SPACES.          
             10 S-REVERT-FL            PIC X(01) VALUE SPACES.          
             10 S-SPCL-READ-INST       PIC X(114) VALUE SPACES.         
             10 S-SPCL-INST            PIC X(255) VALUE SPACES.         
             10 S-PREM-DIRECTIONS      PIC X(255) VALUE SPACES.         
             10 S-SCRATCHPAD           PIC X(255) VALUE SPACES.         
             10 S-ADDRESS-DATA.                                         
                15 S-ADDRESS-ID        PIC S9(13)V COMP-3 VALUE 0.      
                15 S-ADDRESS-FORMAT   PIC X(01) VALUE SPACES.           
                15 S-ADDR-STREET      PIC X(55) VALUE SPACES.           
                15 S-ADDR-CITY-STATE  PIC X(30) VALUE SPACES.           
                15 S-ADDR-ZIP-CODE    PIC X(09) VALUE SPACES.           
                15 S-ADDR-COUNTRY     PIC X(35) VALUE SPACES.           
                15 S-ADDR-STREET-2    PIC X(55) VALUE SPACES.           
                15 S-HOUSE-NO         PIC X(15) VALUE SPACES.           
                15 S-ADDR-PREFIX-1    PIC X(03) VALUE SPACES.           
                15 S-ADDR-PREFIX-2    PIC X(02) VALUE SPACES.           
                15 S-STREET-NAME      PIC X(30) VALUE SPACES.           
                15 S-STREET-SUFFIX    PIC X(04) VALUE SPACES.           
                15 S-ADDR-SUFFIX      PIC X(02) VALUE SPACES.           
                15 S-STREET-LOCATION-1 PIC X(04) VALUE SPACES.          
                15 S-STREET-LOCATION-2 PIC X(11) VALUE SPACES.          
                15 S-ZIP-CODE         PIC X(09) VALUE SPACES.           
                15 S-ZIP-CODE-PLUS-FOUR PIC X(04) VALUE SPACES.         
                15 S-ZIP-CODE-TOKEN   PIC X(01) VALUE SPACES.           
                15 S-STATE            PIC X(02) VALUE SPACES.           
             10 S-WORK-AREA-2          PIC X(12) VALUE SPACES.          
             10 S-TOTAL-RES            PIC S9(5)V9 COMP-3 VALUE 0.      
             10 S-DISCONNECT-CD        PIC X(01) VALUE SPACES.          
             10 S-ARRANGEMENT-FL       PIC X(01) VALUE SPACES.          
             10 S-PREMISE-NO           PIC S9(10)V COMP-3 VALUE 0.      
             10 S-LL-CUSTOMER-NO       PIC S9(10)V COMP-3 VALUE 0.      
             10 S-SUBDIVISION-ID       PIC X(03) VALUE SPACES.          
             10 S-EST-BILL-DAY         PIC X(02) VALUE SPACES.          
             10 S-EST-DUE-DAY          PIC X(02) VALUE SPACES.          
             10 S-EMAIL-ADDRESS        PIC X(100) VALUE SPACES.         
             10 S-PAYMENT-REQ-FL       PIC X(01) VALUE 'N'.             
A04670       10 S-CODE-RENTAL-PROP     PIC X(01) VALUE SPACES.          
A4670A       10 S-CURR-ACCOUNT-NO      PIC S9(13)V COMP-3 VALUE 0.      
P00718       10 S-BUSINESS-UNIT-2      PIC X(03) VALUE SPACES.          
P00718       10 S-WORK-DISTRICT-2      PIC X(40) VALUE SPACES.          
P00795       10 S-UNMTR-WORK-TYPE      PIC X(03) VALUE SPACES.          
P00795       10 S-ORIG-WORK-TYPE       PIC X(03) VALUE SPACES.          
P00795       10 S-ORIG-UTIL-TYPE       PIC X(01) VALUE SPACES.          
P0795B       10 S-SET-RLSE-REQD-FL     PIC X(01) VALUE SPACES.          
A05189       10 S-AROP-READ-ONLY-FL    PIC X(01) VALUE SPACES.          
DT6945       10 S-SAME-DAY-FL          PIC X(01) VALUE SPACES.          
MAINTN       10 S-APPLIANCE-RELOAD-FL  PIC X(01) VALUE SPACES.          
MAINTN       10 S-READ-ROUTE           PIC S9(04) COMP VALUE 0.         
D10775       10 S-BNKRPT-CASE-NO       PIC X(10) VALUE SPACES.          
D10775       10 S-BNKRPT-FILED-CASE-NO PIC X(10) VALUE SPACES.          
D10775       10 S-BNKRPT-FILED-DATE    PIC X(10) VALUE SPACES.          
D10775       10 S-BNKRPT-CHAPTER       PIC X(02) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3        PIC S9(9) COMP VALUE ZERO.       
             10 S-ASSIGNED-DATE        PIC X(10) VALUE SPACES.          
             10 S-SERV-ORDER-NO-3      PIC S9(13)V COMP-3 VALUE 0.      
             10 S-ORDER-TYPE-CD        PIC X(05) VALUE SPACES.          
             10 S-ORDER-STATE-CD       PIC X(01) VALUE SPACES.          
             10 S-CUSTOMER-NAME        PIC X(76) VALUE SPACES.          
             10 S-REMARKS              PIC X(210) VALUE SPACES.         
             10 S-WORK-AREA-3          PIC X(12) VALUE SPACES.          
             10 S-PHONE                PIC X(10) VALUE SPACES.          
             10 S-REMARK-TYPE          PIC X(01) VALUE SPACES.          
             10 S-SERV-ORDER-STATUS    PIC X(02) VALUE SPACES.          
P00718*      10 S-BUSINESS-UNIT-3      PIC X(03) VALUE SPACES.                  
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4        PIC S9(9) COMP VALUE ZERO.       
             10 S-CODE-UTIL-TYPE-4     PIC X(01) VALUE SPACES.          
             10 S-METER-NO-4           PIC X(09) VALUE SPACES.          
             10 S-RATE-PLAN-4          PIC X(03) VALUE SPACES.          
             10 S-SUPPLIES             PIC X(15) VALUE SPACES.          
             10 S-METER-LOC            PIC X(02) VALUE SPACES.          
             10 S-METER-STATUS         PIC X(01) VALUE SPACES.          
             10 S-METER-STATUS-REASON  PIC X(01) VALUE SPACES.          
             10 S-WORK-TYPE-CD-4       PIC X(03) VALUE SPACES.          
             10 S-METER-READ-INST      PIC X(02) VALUE SPACES.          
             10 S-METER-IND            PIC X(01) VALUE SPACES.          
             10 S-IC-NO-4              PIC S9(4) COMP VALUE 0.          
             10 S-MTR-REF-NO-4         PIC S9(4) COMP VALUE 0.          
             10 S-CODE-REV-CLASS-4     PIC X(03) VALUE SPACES.          
             10 S-RLSE-REQUIRED        PIC X(01) VALUE SPACES.          
             10 S-RLSE-NO              PIC X(10) VALUE SPACES.          
             10 S-RLSE-MSG             PIC X(05) VALUE SPACES.          
             10 S-RLSE-ADDL-MSG        PIC X(05) VALUE SPACES.          
             10 S-RLSE-PHONE           PIC X(12) VALUE SPACES.          
             10 S-RLSE-ALT-PHONE       PIC X(12) VALUE SPACES.          
             10 S-RLSE-REV-DIST        PIC X(25) VALUE SPACES.          
             10 S-BUS-RULE-ID-4        PIC X(10) VALUE SPACES.          
             10 S-ACTION-TYPE-CD-4     PIC X(08) VALUE SPACES.          
             10 S-BUS-RULE-XREF-ID-4   PIC X(26) VALUE SPACES.          
             10 S-RLSE-ENABLED-FL      PIC X(01) VALUE SPACES.          
             10 S-OLD-WORK-TYPE-CD-4   PIC X(03) VALUE SPACES.          
             10 S-SO-SEQ-NO-4          PIC S9(4) COMP VALUE 0.          
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5        PIC S9(9) COMP VALUE ZERO.       
             10 S-SERV-ORDER-NO-5      PIC S9(13)V COMP-3 VALUE 0.      
             10 S-CODE-UTIL-TYPE-5     PIC X(01) VALUE SPACES.          
             10 S-WORK-TYPE-CD-5       PIC X(03) VALUE SPACES.          
             10 S-IC-NO-5              PIC S9(4) COMP VALUE 0.          
             10 S-METER-NO-5           PIC X(09) VALUE SPACES.          
             10 S-MTR-REF-NO-5         PIC S9(4) COMP VALUE 0.          
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6        PIC S9(9) COMP VALUE ZERO.       
             10 S-CONTACT-TYPE         PIC X(02) VALUE SPACES.          
             10 S-NAME-TYPE            PIC X(02) VALUE SPACES.          
             10 S-MATRIX-NAME          PIC X(76) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-7.                                       
             10 S-RETURN-CODE-7        PIC S9(9) COMP VALUE ZERO.       
             10 S-CALENDAR-DT          PIC X(10) VALUE SPACES.          
             10 S-GOOD-DAY-FL          PIC X(02) VALUE SPACES.          
          05 GTT-RETURN-FIELDS-8.                                       
             10 S-RETURN-CODE-8       PIC S9(9) COMP VALUE ZERO.        
             10 S-RATE-PLAN-8         PIC X(03) VALUE SPACES.           
             10 S-RATE-ITEM-CODE      PIC S9(4) COMP VALUE 0.           
             10 S-CODE-PLAN-STATUS    PIC X(01) VALUE SPACES.           
             10 S-CODE-STATUS-REASON  PIC X(01) VALUE SPACES.           
             10 S-MONTHLY-AMOUNT      PIC S9(3)V99 COMP-3 VALUE 0.      
             10 S-NO-UNITS            PIC S9(4) COMP VALUE 0.           
             10 S-SUBDIVISION-FL      PIC X(01) VALUE SPACES.           
             10 S-IC-NO-8             PIC S9(4) COMP VALUE 0.           
             10 S-RATE-PLAN-DESC-8    PIC X(25) VALUE SPACES.           
             10 S-SERVICE-TYPE        PIC X(01) VALUE SPACES.           
             10 S-DIST-NO             PIC X(03) VALUE SPACES.           
             10 S-POLE-NO             PIC X(07) VALUE SPACES.           
          05 GTT-RETURN-FIELDS-9.                                       
             10 S-RETURN-CODE-9       PIC S9(9) COMP VALUE ZERO.        
             10 S-EQUIPMENT-NO        PIC X(20) VALUE SPACES.           
             10 S-APPLIANCE-CD        PIC X(02) VALUE SPACES.           
             10 S-CAUTION-TAG-IND     PIC X(01) VALUE SPACES.           
             10 S-CUT-IND             PIC X(01) VALUE SPACES.           
             10 S-TAG-NO              PIC X(10) VALUE SPACES.           
             10 S-CONDITION-CD        PIC X(03) VALUE SPACES.           
             10 S-LOCATION-CD         PIC X(03) VALUE SPACES.           
             10 S-APPL-COMMENTS       PIC X(255) VALUE SPACES.          
             10 S-CAUTION-TAG-DT      PIC X(10) VALUE SPACES.           
             10 S-SOURCE-SYSTEM-CD    PIC X(03) VALUE SPACES.           
             10 S-INSTALL-DT          PIC X(10) VALUE SPACES.           
             10 S-SERIAL-NO           PIC X(40) VALUE SPACES.           
             10 S-CAD-VERIFY-DT       PIC X(10) VALUE SPACES.           
             10 S-APPLIANCE-DESC      PIC X(20) VALUE SPACES.           
             10 S-SEASONAL-RT-FL      PIC X(01) VALUE SPACES.           
             10 S-CRAWL-FL            PIC X(01) VALUE SPACES.           
             10 S-APPL-LONG-DESC      PIC X(255) VALUE SPACES.          
             10 S-PRIMARY-FUEL-CD     PIC X(06) VALUE SPACES.           
             10 S-AVERAGE-BTU         PIC S9(9) COMP VALUE 0.           
             10 S-LEAK-IND            PIC X(01) VALUE SPACES.           
             10 S-LIGHT-IND           PIC X(01) VALUE SPACES.           
             10 S-REPAIR-IND          PIC X(01) VALUE SPACES.           
             10 S-CUTOFF-IND          PIC X(01) VALUE SPACES.           
             10 S-REPLACE-APP-FL      PIC X(01) VALUE SPACES.           
          05 GTT-RETURN-FIELDS-10.                                      
             10 S-RETURN-CODE-10      PIC S9(9) COMP VALUE ZERO.        
             10 S-CODE-UTIL-TYPE-10   PIC X(01) VALUE SPACES.           
             10 S-IC-NO-10            PIC S9(4) COMP VALUE 0.           
             10 S-RATE-PLAN-10        PIC X(03) VALUE SPACES.           
             10 S-CODE-REV-CLASS-10   PIC X(03) VALUE SPACES.           
             10 S-RATE-PLAN-DESC-10   PIC X(25) VALUE SPACES.           
             10 S-TOU-FL              PIC X(01) VALUE SPACES.           
             10 S-FIXED-FACTOR-FL     PIC X(01) VALUE SPACES.           
             10 S-BILL-CONTRACT-FL    PIC X(01) VALUE SPACES.           
             10 S-INTERRUPT-FL        PIC X(01) VALUE SPACES.           
          05 GTT-RETURN-FIELDS-11.                                      
             10 S-RETURN-CODE-11      PIC S9(9) COMP VALUE ZERO.        
             10 S-ACCOUNT-NO-11       PIC S9(13)V COMP-3 VALUE 0.       
             10 S-CODE-ACCT-STAT-11   PIC X(01) VALUE SPACES.           
             10 S-ADDRESS-LINE        PIC X(80) VALUE SPACES.           
MAINTN    05 GTT-RETURN-FIELDS-12.                                      
             10 S-RETURN-CODE-12       PIC S9(9) COMP VALUE 0.          
             10 S-SERV-ORDER-NO-12       PIC X(13) VALUE SPACES.        
             10 S-ORDER-TYPE-CD-12       PIC X(05) VALUE SPACES.        
             10 S-ORDER-REASON-12        PIC X(15) VALUE SPACES.        
             10 S-STATUS-TX-12           PIC X(25) VALUE SPACES.        
             10 S-ORDER-STATE-CD-12      PIC X(01) VALUE SPACES.        
             10 S-ORDER-PLACED-BY-12     PIC X(25) VALUE SPACES.        
             10 S-PHONE-NO-12            PIC X(10) VALUE SPACES.        
             10 S-PHONE-NO-EXT-12        PIC X(06) VALUE SPACES.        
             10 S-WANTED-BY-DATE-12      PIC X(10) VALUE SPACES.        
             10 S-ASSIGNED-DATE-12       PIC X(10) VALUE SPACES.        
             10 S-CALL-BEFORE-MINUTS-12  PIC X(03) VALUE SPACES.        
             10 S-WORK-AREA-ID-12        PIC X(12) VALUE SPACES.        
             10 S-BREAKERS-OFF-IND-12    PIC X(01) VALUE SPACES.        
             10 S-INIT-BY-CNTRCT-IND-12  PIC X(01) VALUE SPACES.        
             10 S-NOTIFY-CSR-IND-12      PIC X(01) VALUE SPACES.        
             10 S-NOTIFY-CUST-IND-12     PIC X(01) VALUE SPACES.        
             10 S-ORDER-PRIORITY-CD-12   PIC S9(4) COMP VALUE 0.        
             10 S-STD-LABOR-CHRG-12      PIC S9(7)V9(2) COMP-3          
                                                     VALUE 0.           
             10 S-WORK-TYPE-CD-4-12      PIC X(03) VALUE SPACES.        
             10 S-BACK-DATED-IND-12      PIC X(01) VALUE SPACES.        
             10 S-DEPOSIT-AMT-12         PIC S9(9)V9(2) COMP-3          
                                                     VALUE 0.           
             10 S-ORDER-RECVED-BY-12     PIC X(07) VALUE SPACES.        
             10 S-VERIFY-RATE-12         PIC X(01) VALUE SPACES.        
             10 S-PREMISE-NO-12          PIC S9(10)V COMP-3 VALUE 0.    
             10 S-ACCOUNT-NO-12          PIC S9(13)V COMP-3 VALUE 0.    
             10 S-ACCOUNT-NO-PRIOR-12    PIC S9(13)V COMP-3 VALUE 0.    
             10 S-BEGIN-APPT-DATE-12     PIC X(26) VALUE SPACES.        
             10 S-SO-EST-LABOR-HR-12     PIC S9(5)V9 COMP-3 VALUE 0.    
             10 S-CUSTCHG-ORD-TYPE-FL-12 PIC X(01) VALUE SPACES.        
             10 S-AMOUNT-DISC-BAL-12     PIC S9(9)V9(2) COMP-3          
                                                       VALUE 0.         
             10 S-CURRENT-DATE-12        PIC X(10) VALUE SPACES.        
             10 S-CODE-UTIL-TYPE-12-D    PIC X(01) VALUE SPACES.        
             10 S-PRICE-PER-SERV-12      PIC S9(3)V9(6) COMP-3          
                                                         VALUE 0.       
             10 S-ACCOUNT-TYPE-DESC-12   PIC X(25) VALUE SPACES.        
             10 S-ORDER-CHARGE-AMT-12    PIC S9(3)V9(2) COMP-3          
                                                        VALUE 0.        
             10 S-TOTAL-CHARGES-AMT-12   PIC S9(7)V9(2) COMP-3          
                                                        VALUE 0.        
             10 S-CUST-CNT-ID-12         PIC X(10) VALUE SPACES.        
             10 S-MTR-ACCESSIBLE-CD-12   PIC X(02) VALUE SPACES.        
             10 S-MTR-ACCESSIBLE-DT-12   PIC X(10) VALUE SPACES.        
             10 S-MTR-ACCESSIBLE-RSN-12  PIC X(02) VALUE SPACES.        
             10 S-SOURCE-SYSTEM-CD-12    PIC X(03) VALUE SPACES.        
             10 S-ALT-PHONE-NO-12        PIC X(10) VALUE SPACES.        
             10 S-ALT-PHONE-NO-EXT-12    PIC X(06) VALUE SPACES.        
             10 S-HOME-ALL-DAY-FL-12     PIC X(01) VALUE SPACES.        
             10 S-BUSINESS-UNIT-12       PIC X(03) VALUE SPACES.        
             10 S-OPTIMIZE-ORDER-12      PIC X(01) VALUE SPACES.        
             10 S-END-APPT-DATE-12     PIC X(26) VALUE SPACES.          
             10 S-AM-PM-APPT-CD-12     PIC X(01) VALUE SPACES.          
             10 S-MTR-TURNOFF-RSN-CD-12 PIC X(01) VALUE SPACES.         
             10 S-FUEL-CHNG-RSN-CD-12   PIC X(01) VALUE SPACES.         
             10 S-FUEL-CHNG-TYPE-CD-12  PIC X(01) VALUE SPACES.         
             10 S-TURNOFF-COMMENTS-12   PIC X(255) VALUE SPACES.        
             10 S-OLD-ORDER-TYPE-CD-12  PIC X(05) VALUE SPACES.         
             10 S-WORK-DISTRICT-12      PIC X(40) VALUE SPACES.         
             10 S-CODES-DATA-PRESENT-12 PIC X(35) VALUE SPACES.         
             10 S-TASK-STATUS-CD-12     PIC X(01) VALUE SPACES.         
DT9519       10 S-CANCEL-REASON-CD-12   PIC X(01) VALUE SPACES.         
D26359       10 S-SO-MTR-ROW-EXISTS-12  PIC X(01) VALUE SPACES.         
MAINTN    05 GTT-RETURN-FIELDS-13.                                      
             10 S-RETURN-CODE-13          PIC S9(09) COMP VALUE 0.      
             10 S-SERV-ORDER-NO-13        PIC S9(13)V COMP-3 VALUE 0.   
             10 S-REMARK-TYPE-CD-13      PIC X(01)  VALUE SPACES.       
             10 S-REMARK-TX-13           PIC X(210).                    
          05 GTT-RETURN-FIELDS-14.                                      
             10 S-RETURN-CODE-14         PIC S9(09) COMP VALUE 0.       
             10 S-TO-ACCT-NO-14          PIC S9(13)V COMP-3 VALUE 0.    
             10 S-ROOMMATE-XFER-IND-14   PIC X(01) VALUE SPACES.        
             10 S-EPP-XFER-IND-14        PIC X(01) VALUE SPACES.        
             10 S-DEPOSIT-XFER-IND-14    PIC X(01) VALUE SPACES.        
             10 S-OTHER-AR-XFER-IND-14   PIC X(01) VALUE SPACES.        
             10 S-PROJ-SHR-XFER-IND-14   PIC X(01) VALUE SPACES.        
             10 S-WRITE-OFF-XFER-IND-14  PIC X(01) VALUE SPACES.        
             10 S-IN-LIEU-XFER-IND-14    PIC X(01) VALUE SPACES.        
             10 S-WHT-CROSS-XFER-IND-14  PIC X(01) VALUE SPACES.        
             10 S-COAPPL-XFER-IND-14     PIC X(01) VALUE SPACES.        
             10 S-MED-CERT-XFER-IND-14   PIC X(01) VALUE SPACES.        
             10 S-NAME-FORMAT-14         PIC X(01) VALUE SPACES.        
             10 S-FIRST-NAME-14          PIC X(15) VALUE SPACES.        
             10 S-MIDDLE-NAME-14         PIC X(15) VALUE SPACES.        
             10 S-LAST-NAME-14           PIC X(40) VALUE SPACES.        
             10 S-FULL-NAME-14           PIC X(70) VALUE SPACES.        
             10 S-HOUSE-NO-14            PIC X(15) VALUE SPACES.        
             10 S-ADDR-PREFIX-1-14       PIC X(03) VALUE SPACES.        
             10 S-ADDR-PREFIX-2-14       PIC X(02) VALUE SPACES.        
             10 S-STREET-NAME-14         PIC X(30) VALUE SPACES.        
             10 S-STREET-LOCATION-1-14   PIC X(04) VALUE SPACES.        
             10 S-STREET-LOCATION-2-14   PIC X(11) VALUE SPACES.        
             10 S-STREET-SUFFIX-14       PIC X(04) VALUE SPACES.        
             10 S-CUSTOMER-FROM-14       PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
          05 GTT-RETURN-FIELDS-15.                                      
             10 S-RETURN-CODE-15         PIC S9(09) COMP VALUE 0.       
             10 S-ACCOUNT-NO-PRIOR-15    PIC X(13) VALUE SPACES.        
             10 S-SERV-ORDER-NO-15       PIC X(13) VALUE SPACES.        
             10 S-WANTED-BY-DATETIME-15  PIC X(26) VALUE SPACES.        
             10 S-CREDIT-LETTER-IND-15   PIC X(01) VALUE SPACES.        
             10 S-STREET-LOCATION-1-15   PIC X(04) VALUE SPACES.        
             10 S-STREET-LOCATION-2-15   PIC X(11) VALUE SPACES.        
             10 S-ADDR-ST-15             PIC X(55) VALUE SPACES.        
             10 S-ADDR-ZIP-CODE-15       PIC X(09) VALUE SPACES.        
             10 S-ADDR-PREFIX-1-15       PIC X(03) VALUE SPACES.        
             10 S-ADDR-PREFIX-2-15       PIC X(02) VALUE SPACES.        
             10 S-ADDR-SUFFIX-15         PIC X(02) VALUE SPACES.        
             10 S-ADDRESS-OVERFLOW-15    PIC X(35) VALUE SPACES.        
             10 S-HOUSE-NO-15            PIC X(15) VALUE SPACES.        
             10 S-ADDRESS-FORMAT-15      PIC X(01) VALUE SPACES.        
             10 S-STREET-NAME-15         PIC X(30) VALUE SPACES.        
             10 S-STREET-SUFFIX-15       PIC X(04) VALUE SPACES.        
             10 S-ZIP-CODE-15            PIC X(05) VALUE SPACES.        
             10 S-ZIP-CODE-PLUS-FOUR-15  PIC X(04) VALUE SPACES.        
             10 S-ZIP-CODE-TOKEN-15      PIC X(01) VALUE SPACES.        
             10 S-SEND-TO-LOCOFF-IND-15  PIC X(01) VALUE SPACES.        
             10 S-ADDR-COUNTRY-15        PIC X(35) VALUE SPACES.        
             10 S-CARRIER-ROUTE-15       PIC X(05) VALUE SPACES.        
             10 S-FINAL-BILL-CY-ST-15    PIC X(30) VALUE SPACES.        
             10 S-FINAL-BILL-OVFL-15     PIC X(35) VALUE SPACES.        
             10 S-DEPOSIT-AMT-15         PIC S9(9)V9(2) COMP-3          
                                                    VALUE 0.            
             10 S-FBILL-ADDR-TYPE-15     PIC X(01) VALUE SPACES.        
             10 S-FBILL-ADDR-LINE-15     PIC X(80) VALUE SPACES.        
DT9511    05 GTT-RETURN-FIELDS-16.                                      
DT9511       10 S-RETURN-CODE-16         PIC S9(09) COMP VALUE 0.       
DT9511       10 S-CONTRACT-ID-16         PIC S9(09) COMP VALUE 0.       
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SW-FETCH                PIC X(01) VALUE 'Y'.             
               88 NO-MORE-ROWS                   VALUE 'N'.             
               88 MORE-ROWS                      VALUE 'Y'.             
           05  SW-SAME-DAY-CHECK       PIC X(01) VALUE 'N'.             
               88 SAME-DAY-CHK-NOT-DONE          VALUE 'N'.             
               88 SAME-DAY-CHK-DONE              VALUE 'Y'.             
                                                                        
       01 WS-MISC.                                                      
          05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04476'.      
          05  WS-RETURN-CODE           PIC S9(01) USAGE COMP.           
          05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.          
          05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO          
                                       PIC 9(13).                       
          05  WS-PREMISE-NO-NUM        PIC 9(10) VALUE ZEROES.          
          05  WS-PREMISE-NO            REDEFINES WS-PREMISE-NO-NUM      
                                       PIC X(10).                       
          05  WS-CUSTOMER-NO-NUM       PIC 9(10) VALUE ZEROES.          
          05  WS-CUSTOMER-NO           REDEFINES WS-CUSTOMER-NO-NUM     
                                       PIC X(10).                       
          05  WS-NEW-CUSTOMER-NO       PIC X(10) VALUE SPACES.          
          05  WS-NEW-CUSTOMER-NO-NUM   REDEFINES WS-NEW-CUSTOMER-NO     
                                       PIC 9(10).                       
P0795B    05  WS-NEW-PREMISE-NO        PIC X(10) VALUE SPACES.          
P0795B    05  WS-NEW-PREMISE-NO-NUM    REDEFINES WS-NEW-PREMISE-NO      
P0795B                                 PIC 9(10).                       
          05  WS-SERV-ORDER-NO-C       PIC X(13) VALUE SPACES.          
          05  WS-SERV-ORDER-NO-N       REDEFINES WS-SERV-ORDER-NO-C     
                                       PIC 9(13).                       
          05  WS-SQLSTATE              PIC X(05) VALUE '     '.         
          05  WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
          05  WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
          05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
          05  WS-GTT01-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT03-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT04-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT05-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT06-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT07-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT08-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT09-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT10-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT11-DECLARED        PIC X(01) VALUE 'N'.             
MAINTN*   05  WS-GTT12-DECLARED        PIC X(01) VALUE 'N'.                     
          05  WS-GTT13-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-GTT16-DECLARED        PIC X(01) VALUE 'N'.             
          05  WS-TS-MINUS-31-DAYS      PIC X(26) VALUE SPACES.          
          05  WS-MN-FOUND              PIC X(01) VALUE 'N'.             
          05  WS-CP-FOUND              PIC X(01) VALUE 'N'.             
          05  WS-LIGHTING-FL           PIC X(01) VALUE 'N'.             
          05  WS-SUBDIV-LITE-FL        PIC X(01) VALUE 'N'.             
          05  WS-ELEC-UNBLOCK-FL       PIC X(01) VALUE 'N'.             
          05  WS-GAS-UNBLOCK-FL        PIC X(01) VALUE 'N'.             
          05  WS-ELEC-IC-FL            PIC X(01) VALUE 'N'.             
          05  WS-METERED-LIGHT-FL      PIC X(01) VALUE 'N'.             
          05  WS-NEW-CUST-IS-LL-FL     PIC X(01) VALUE 'N'.             
A05821    05  WS-CUST-BLDR-RLTR-FL     PIC X(01) VALUE 'N'.             
          05  WS-ORDER-TYPE-CD         PIC X(05) VALUE SPACES.          
P00795    05  WS-IS-UNMTR-ORDER        PIC X(01) VALUE 'N'.             
P00795    05  WS-WORK-TYPE-INCLUDED    PIC X(01) VALUE 'N'.             
P00795*   05  WS-ORIG-UTIL-COUNT       PIC 9(02) VALUE ZEROS.                   
          05  WS-NEXT-BUS-DAY          PIC X(10) VALUE SPACES.          
          05  WS-LL-CUSTOMER-NO        PIC 9(10) VALUE ZEROES.          
A4670A    05  WS-CURR-ACCOUNT-NO       PIC 9(13) VALUE ZEROES.          
DT9505    05  WS-AT-ACCOUNT-NO-PR      PIC S9(13)V USAGE COMP-3 VALUE 0.
DT9505    05  WS-AT-CUSTOMER-NO-PR     PIC S9(10)V USAGE COMP-3 VALUE 0.
DT9505    05  WS-AT-COMPANY-NO-PR      PIC X(2) VALUE SPACES.           
DT9505    05  WS-AT-MST-SUB-IND-PR     PIC X(1) VALUE SPACES.           
          05  WS-HARD-ERROR-FOUND      PIC X(01) VALUE 'N'.             
A04670    05  WS-PR-EXECUTED-FL        PIC X(01) VALUE 'N'.             
A04670    05  WS-ELEC-SOR-FL           PIC X(01) VALUE 'N'.             
A05189    05  WS-RLSE-REQD-4480        PIC X(01) VALUE 'N'.             
P0795H    05  WS-RLSE-ENABLED-FL       PIC X(01) VALUE 'N'.             
          05  WS-TOTAL-DUE             PIC S9(9)V99 COMP-3 VALUE +0.    
          05  WS-ADDRESS-LINE          PIC X(80) VALUE SPACES.          
          05  WS-ADDRESS-LINE-I        PIC X(80) VALUE SPACES.          
          05  WS-ORDER-FL              PIC X(01) VALUE 'N'.             
P0795D    05  WS-ORDWK-VALID-FL        PIC X(01) VALUE 'N'.             
A04670    05  WS-THRESHOLD             PIC S9(4)V9(5) COMP-3 VALUE +0.  
MAINTN    05  WS-MAINTAIN              PIC X(08) VALUE 'MAINTAIN'.      
DT9484    05  WS-REVERT                PIC X(01) VALUE 'R'.             
MAINTN    05  WS-HISTORY-ORDER         PIC X(01) VALUE 'H'.             
MAINTN    05  WS-NEW-SET-ORDER         PIC X(01) VALUE 'N'.             
MAINTN    05  WS-SUBDIV-RATE-EXISTS    PIC X(01) VALUE SPACES.          
MAINTN    05  WS-SAME-DAY-FL           PIC X(01) VALUE 'N'.             
MAINTN    05  WS-SAME-DAY-FL-PRIOR     PIC X(01) VALUE 'N'.             
MAINTN    05  WS-ORDER-TYPE-PRIOR      PIC X(05) VALUE 'N'.             
MAINTN    05  WS-WORK-TYPE-PRIOR       PIC X(03) VALUE 'N'.             
MAINTN    05  WS-ORDER-TYPE-CHANGED    PIC X(01) VALUE 'N'.             
MAINTN    05  WS-APPLIANCE-RELOAD-FL   PIC X(01) VALUE 'N'.             
APPLCO    05  WS-APPL-MATCH            PIC X(01) VALUE SPACES.          
MAINTN    05  WS-SO-APPL-COUNT         PIC S9(4) COMP.                  
MAINTN    05  WS-PREMISE-APPL-COUNT    PIC S9(4) COMP.                  
MAINTN    05  WS-OFF-TO-CC-CONVERT     PIC X(01) VALUE 'N'.             
D26613    05  WS-CC-TO-OFF-CONVERT     PIC X(01) VALUE 'N'.             
MAINTN    05  WS-NEW-ORDER-FL          PIC X(01) VALUE 'Y'.             
DT8959    05  WS-XFER-TO-ACCT-ADDED    PIC X(01) VALUE SPACES.          
D10775    05  WS-BNKRPTCY-ORDER-FL     PIC X(01) VALUE 'N'.             
D10775    05  WS-HAS-2000-ACCESS       PIC X(01) VALUE 'N'.             
          05  WS-COUNT                 PIC S9(4) COMP VALUE 0.          
          05  WS-IC-NO-NUM             PIC 9(04).                       
          05  WS-IC-NO-CHAR            REDEFINES WS-IC-NO-NUM           
                                       PIC X(04).                       
          05  WS-MTR-REF-NO-NUM        PIC 9(04).                       
          05  WS-MTR-REF-NO-CHAR       REDEFINES WS-MTR-REF-NO-NUM      
                                       PIC X(04).                       
DT6878    05  WS-DATABASE              PIC 9(01) VALUE ZERO.            
DT6878        88  CSR-DATABASE                   VALUE 1.               
DT6878        88  SEB-DATABASE                   VALUE 2.               
          05  WS-BUILD-INPUT-PARMS.                                     
              10 WS-CODE-UTIL-TYPE.                                     
                  15 WS-CODE-UTIL-TYPE-SUB PIC X(01) OCCURS 50.         
              10 WS-WORK-TYPE.                                          
                  15 WS-WORK-TYPE-SUB  PIC X(03) OCCURS 50.             
              10 WS-METER-IND.                                          
                  15 WS-METER-IND-SUB  PIC X(01) OCCURS 50.             
              10 WS-METER-STATUS.                                       
                  15 WS-METER-STATUS-SUB PIC X(01) OCCURS 50.           
              10 WS-SUB1               PIC 999   VALUE 0.               
                                                                        
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW                PIC X(01) VALUE 'Y'.           
             88 SEND-DONE-ERROR                    VALUE 'N'.           
             88 SEND-DONE-OK                       VALUE 'Y'.           
A4670B    05 WS-START-EXISTS-FL          PIC X(01) VALUE 'N'.           
A4670B       88 START-EXISTS-NO                    VALUE 'N'.           
A4670B       88 START-EXISTS-YES                   VALUE 'Y'.           
A4670B    05 WS-STOP-EXISTS-FL           PIC X(01) VALUE 'N'.           
A4670B       88 STOP-EXISTS-NO                     VALUE 'N'.           
A4670B       88 STOP-EXISTS-YES                    VALUE 'Y'.           
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01 IND-VARIABLES.                                                
          05 WS-NULL1                    PIC S9(04) COMP.               
                                                                        
       01  CSR04477-CALL-DATA.                                          
           03  ACCOUNT-NO-4477          PIC X(13) VALUE SPACES.         
           03  OLD-CUSTOMER-NO-4477     PIC X(10) VALUE SPACES.         
           03  PREMISE-NO-4477          PIC X(10) VALUE SPACES.         
           03  NEW-CUSTOMER-NO-4477     PIC X(10) VALUE SPACES.         
           03  ORDER-TYPE-CD-4477       PIC X(05) VALUE SPACES.         
           03  PROCESS-4477             PIC X(10) VALUE SPACES.         
           03  STEP-4477                PIC X(10) VALUE SPACES.         
           03  USERID-4477              PIC X(07) VALUE SPACES.         
           03  PROGRAM-ID-4477          PIC X(08) VALUE SPACES.         
           03  CANCEL-REVERT-FL-4477    PIC X(01) VALUE SPACES.         
           03  XFER-FL-4477             PIC X(01) VALUE SPACES.         
           03  ORDER-TYPE-CHG-FL-4477   PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04477-RETURN-DATA.                                        
           03  RETURN-CODE-4477         PIC S9(9) COMP VALUE 0.         
A4670A*    03  BUS-RULE-ID-4477         PIC X(10) VALUE SPACES.                 
A4670A     03  BUS-RULE-ID-4477         PIC X(13) VALUE SPACES.         
           03  ACTION-TYPE-CD-4477      PIC X(08) VALUE SPACES.         
           03  BUS-RULE-XREF-ID-4477    PIC X(26) VALUE SPACES.         
           03  HARD-ERROR-4477          PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04478-CALL-DATA.                                          
           03  ACCOUNT-NO-4478          PIC X(13) VALUE SPACES.         
           03  OLD-CUSTOMER-NO-4478     PIC X(10) VALUE SPACES.         
           03  PREMISE-NO-4478          PIC X(10) VALUE SPACES.         
           03  ORDER-TYPE-CD-4478       PIC X(05) VALUE SPACES.         
           03  NEXT-BUS-DAY-4478        PIC X(10) VALUE SPACES.         
           03  PROGRAM-ID-4478          PIC X(08) VALUE SPACES.         
           03  NEW-CUSTOMER-NO-4478     PIC X(10) VALUE SPACES.         
           03  XFER-FL-4478             PIC X(01) VALUE SPACES.         
           03  XFER-FROM-ACCT-4478      PIC X(13) VALUE SPACES.         
           03  REVERT-FL-4478           PIC X(01) VALUE SPACES.         
MAINTN     03  SERV-ORDER-NO-4478       PIC X(13) VALUE SPACES.         
MAINTN     03  CURRENT-HISTORY-FL-4478  PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04478-RETURN-DATA-A.                                      
           03  RETURN-CODE-4478-A       PIC S9(9) COMP VALUE 0.         
           03  BILL-ADDRESS-4478        PIC X(80) VALUE SPACES.         
           03  SPCL-READ-INST-4478      PIC X(114) VALUE SPACES.        
           03  SPCL-INST-4478           PIC X(255) VALUE SPACES.        
           03  PREM-DIRECTIONS-4478     PIC X(255) VALUE SPACES.        
           03  SCRATCHPAD-4478          PIC X(255) VALUE SPACES.        
           03  ADDRESS-ID-4478          PIC S9(13)V COMP-3 VALUE 0.     
           03  ADDRESS-FORMAT-4478      PIC X(01) VALUE SPACES.         
           03  ADDR-STREET-4478         PIC X(55) VALUE SPACES.         
           03  ADDR-CITY-STATE-4478     PIC X(30) VALUE SPACES.         
           03  ADDR-ZIP-CODE-4478       PIC X(09) VALUE SPACES.         
           03  ADDR-COUNTRY-4478        PIC X(35) VALUE SPACES.         
           03  ADDR-STREET-2-4478       PIC X(55) VALUE SPACES.         
           03  HOUSE-NO-4478            PIC X(15) VALUE SPACES.         
           03  ADDR-PREFIX-1-4478       PIC X(03) VALUE SPACES.         
           03  ADDR-PREFIX-2-4478       PIC X(02) VALUE SPACES.         
           03  STREET-NAME-4478         PIC X(30) VALUE SPACES.         
           03  STREET-SUFFIX-4478       PIC X(04) VALUE SPACES.         
           03  ADDR-SUFFIX-4478         PIC X(02) VALUE SPACES.         
           03  STREET-LOCATION-1-4478   PIC X(04) VALUE SPACES.         
           03  STREET-LOCATION-2-4478   PIC X(11) VALUE SPACES.         
           03  ZIP-CODE-4478            PIC X(05) VALUE SPACES.         
           03  ZIP-CODE-PLUS-FOUR-4478  PIC X(04) VALUE SPACES.         
           03  ZIP-CODE-TOKEN-4478      PIC X(01) VALUE SPACES.         
           03  STATE-4478               PIC X(02) VALUE SPACES.         
           03  SUBDIVISION-ID-4478      PIC X(03) VALUE SPACES.         
           03  EST-BILL-DAY-4478        PIC X(02) VALUE SPACES.         
           03  EST-DUE-DAY-4478         PIC X(02) VALUE SPACES.         
           03  EMAIL-ADDRESS-4478       PIC X(100) VALUE SPACES.        
                                                                        
       01  CSR04478-RETURN-DATA-B.                                      
           03  RETURN-CODE-4478-B       PIC S9(9) COMP VALUE 0.         
           03  CONTACT-TYPE-4478        PIC X(02) VALUE SPACES.         
           03  NAME-TYPE-4478           PIC X(02) VALUE SPACES.         
           03  MATRIX-NAME-4478         PIC X(76) VALUE SPACES.         
                                                                        
       01  CSR04478-RETURN-DATA-C.                                      
           03  RETURN-CODE-4478-C       PIC S9(9) COMP VALUE 0.         
           03  EQUIPMENT-NO-4478        PIC X(20) VALUE SPACES.         
           03  APPLIANCE-CD-4478        PIC X(02) VALUE SPACES.         
           03  CAUTION-TAG-IND-4478     PIC X(01) VALUE SPACES.         
           03  CUT-IND-4478             PIC X(01) VALUE SPACES.         
           03  TAG-NO-4478              PIC X(10) VALUE SPACES.         
           03  CONDITION-CD-4478        PIC X(03) VALUE SPACES.         
           03  LOCATION-CD-4478         PIC X(03) VALUE SPACES.         
           03  APPL-COMMENTS-4478       PIC X(255) VALUE SPACES.        
           03  CAUTION-TAG-DT-4478      PIC X(10) VALUE SPACES.         
           03  SOURCE-SYSTEM-CD-4478    PIC X(03) VALUE SPACES.         
           03  INSTALL-DT-4478          PIC X(10) VALUE SPACES.         
           03  SERIAL-NO-4478           PIC X(40) VALUE SPACES.         
           03  CAD-VERIFY-DT-4478       PIC X(10) VALUE SPACES.         
           03  APPLIANCE-DESC-4478      PIC X(20) VALUE SPACES.         
           03  SEASONAL-RT-FL-4478      PIC X(01) VALUE SPACES.         
           03  CRAWL-FL-4478            PIC X(01) VALUE SPACES.         
           03  APPL-LONG-DESC-4478      PIC X(255) VALUE SPACES.        
           03  PRIMARY-FUEL-CD-4478     PIC X(06) VALUE SPACES.         
           03  AVERAGE-BTU-4478         PIC S9(9) COMP VALUE 0.         
           03  LEAK-IND-4478            PIC X(01) VALUE SPACES.         
           03  LIGHT-IND-4478           PIC X(01) VALUE SPACES.         
           03  REPAIR-IND-4478          PIC X(01) VALUE SPACES.         
           03  CUTOFF-IND-4478          PIC X(01) VALUE SPACES.         
           03  REPLACE-APP-FL-4478      PIC X(01) VALUE SPACES.         
                                                                        
        01 CSR04478-RETURN-DATA-D.                                      
           03  RETURN-CODE-4478-D        PIC S9(9) COMP VALUE 0.        
           03  ORDER-TYPE-CD-4478-D      PIC X(05) VALUE SPACES.        
           03  ORDER-REASON-4478         PIC X(15) VALUE SPACES.        
           03  STATUS-TX-4478            PIC X(25) VALUE SPACES.        
           03  ORDER-STATE-CD-4478       PIC X(01) VALUE SPACES.        
           03  ORDER-PLACED-BY-4478      PIC X(25) VALUE SPACES.        
           03  PHONE-NO-4478             PIC X(10) VALUE SPACES.        
           03  PHONE-NO-EXT-4478         PIC X(06) VALUE SPACES.        
           03  WANTED-BY-DATE-4478       PIC X(10) VALUE SPACES.        
           03  ASSIGNED-DATE-4478        PIC X(10) VALUE SPACES.        
           03  CALL-BEFORE-MINUTS-4478   PIC X(03) VALUE SPACES.        
           03  WORK-AREA-ID-4478         PIC X(12) VALUE SPACES.        
           03  BREAKERS-OFF-IND-4478     PIC X(01) VALUE SPACES.        
           03  INIT-BY-CNTRCT-IND-4478   PIC X(01) VALUE SPACES.        
           03  NOTIFY-CSR-IND-4478       PIC X(01) VALUE SPACES.        
           03  NOTIFY-CUST-IND-4478      PIC X(01) VALUE SPACES.        
           03  ORDER-PRIORITY-CD-4478    PIC S9(4) COMP VALUE 0.        
           03  STD-LABOR-CHRG-4478       PIC S9(7)V9(2) COMP-3          
                                                     VALUE 0.           
           03  WORK-TYPE-CD-4-4478       PIC X(03) VALUE SPACES.        
           03  BACK-DATED-IND-4478       PIC X(01) VALUE SPACES.        
           03  DEPOSIT-AMT-4478          PIC S9(9)V9(2) COMP-3          
                                                       VALUE 0.         
           03  ORDER-RECVED-BY-4478      PIC X(07) VALUE SPACES.        
           03  VERIFY-RATE-4478          PIC X(01) VALUE SPACES.        
           03  PREMISE-NO-4478-D         PIC S9(10)V COMP-3 VALUE 0.    
           03  ACCOUNT-NO-4478-D         PIC S9(13)V COMP-3 VALUE 0.    
           03  ACCOUNT-NO-PRIOR-4478     PIC S9(13)V COMP-3 VALUE 0.    
           03  BEGIN-APPT-DATE-4478      PIC X(26) VALUE SPACES.        
           03  SO-EST-LABOR-HR-4478      PIC S9(5)V9 COMP-3 VALUE 0.    
           03  CUSTCHG-ORD-TYPE-FL-4478  PIC X(01) VALUE SPACES.        
           03  AMOUNT-DISC-BAL-4478      PIC S9(9)V9(2) COMP-3          
                                                       VALUE 0.         
           03  CURRENT-DATE-4478         PIC X(10) VALUE SPACES.        
           03  CODE-UTIL-TYPE-4478-D     PIC X(01) VALUE SPACES.        
           03  PRICE-PER-SERV-4478       PIC S9(3)V9(6) COMP-3          
                                                         VALUE 0.       
           03  ACCOUNT-TYPE-DESC-4478    PIC X(25) VALUE SPACES.        
           03  ORDER-CHARGE-AMT-4478     PIC S9(3)V9(2) COMP-3          
                                                        VALUE 0.        
           03  TOTAL-CHARGES-AMT-4478    PIC S9(7)V9(2) COMP-3          
                                                        VALUE 0.        
           03  CUST-CNT-ID-4478          PIC X(10) VALUE SPACES.        
           03  MTR-ACCESSIBLE-CD-4478    PIC X(02) VALUE SPACES.        
           03  MTR-ACCESSIBLE-DT-4478    PIC X(10) VALUE SPACES.        
           03  MTR-ACCESSIBLE-RSN-4478   PIC X(02) VALUE SPACES.        
           03  SOURCE-SYSTEM-CD-4478-D   PIC X(03) VALUE SPACES.        
           03  ALT-PHONE-NO-4478         PIC X(10) VALUE SPACES.        
           03  ALT-PHONE-NO-EXT-4478     PIC X(06) VALUE SPACES.        
           03  HOME-ALL-DAY-FL-4478      PIC X(01) VALUE SPACES.        
           03  BUSINESS-UNIT-4478        PIC X(03) VALUE SPACES.        
           03  OPTIMIZE-ORDER-4478       PIC X(01) VALUE SPACES.        
           03  END-APPT-DATE-4478      PIC X(26) VALUE SPACES.          
           03  AM-PM-APPT-CD-4478      PIC X(01) VALUE SPACES.          
           03  MTR-TURNOFF-RSN-CD-4478 PIC X(01) VALUE SPACES.          
           03  FUEL-CHNG-RSN-CD-4478   PIC X(01) VALUE SPACES.          
           03  FUEL-CHNG-TYPE-CD-4478  PIC X(01) VALUE SPACES.          
           03  TURNOFF-COMMENTS-4478   PIC X(255) VALUE SPACES.         
           03  WORK-DISTRICT-4478      PIC X(40) VALUE SPACES.          
DT9528     03  CODES-DATA-PRESENT-4478 PIC X(35) VALUE SPACES.          
DT9519     03  CANCEL-REASON-CD-4478   PIC X(01) VALUE SPACES.          
D26359     03  SO-MTR-ROW-EXISTS-4478  PIC X(01) VALUE SPACES.          
        01 CSR04478-RETURN-DATA-E.                                      
           03  RETURN-CODE-4478-E        PIC S9(9) COMP VALUE 0.        
           03  SERV-ORDER-NO-4478-E      PIC X(13) VALUE SPACES.        
           03  REMARK-TYPE-CD           PIC X(01)  VALUE SPACES.        
           03  REMARK-TX                PIC X(210).                     
       01  CSR04478-RETURN-DATA-F.                                      
           03  RETURN-CODE-4478-F          PIC S9(9) COMP VALUE 0.      
           03  TO-ACCT-NO-4478             PIC S9(13)V COMP-3 VALUE 0.  
           03  ROOMMATE-XFER-IND-4478      PIC X(01) VALUE SPACES.      
           03  EPP-XFER-IND-4478           PIC X(01) VALUE SPACES.      
           03  DEPOSIT-XFER-IND-4478       PIC X(01) VALUE SPACES.      
           03  OTHER-AR-XFER-IND-4478      PIC X(01) VALUE SPACES.      
           03  PROJ-SHR-XFER-IND-4478      PIC X(01) VALUE SPACES.      
           03  WRITE-OFF-XFER-IND-4478     PIC X(01) VALUE SPACES.      
           03  IN-LIEU-XFER-IND-4478       PIC X(01) VALUE SPACES.      
           03  WHT-CROSS-XFER-IND-4478     PIC X(01) VALUE SPACES.      
           03  COAPPL-XFER-IND-4478        PIC X(01) VALUE SPACES.      
           03  MED-CERT-XFER-IND-4478      PIC X(01) VALUE SPACES.      
           03  NAME-FORMAT-4478            PIC X(01) VALUE SPACES.      
           03  FIRST-NAME-4478             PIC X(15) VALUE SPACES.      
           03  MIDDLE-NAME-4478            PIC X(15) VALUE SPACES.      
           03  LAST-NAME-4478              PIC X(40) VALUE SPACES.      
           03  FULL-NAME-4478              PIC X(70) VALUE SPACES.      
           03  HOUSE-NO-4478-F             PIC X(15) VALUE SPACES.      
           03  ADDR-PREFIX-1-4478-F        PIC X(03) VALUE SPACES.      
           03  ADDR-PREFIX-2-4478-F        PIC X(02) VALUE SPACES.      
           03  STREET-NAME-4478-F          PIC X(30) VALUE SPACES.      
           03  STREET-LOCATION-1-4478-F    PIC X(04) VALUE SPACES.      
           03  STREET-LOCATION-2-4478-F    PIC X(11) VALUE SPACES.      
           03  STREET-SUFFIX-4478-F        PIC X(04) VALUE SPACES.      
           03  CUSTOMER-FROM-4478          PIC S9(10)V COMP-3 VALUE 0.  
                                                                        
       01  CSR04478-RETURN-DATA-G.                                      
           03 RETURN-CODE-4478-G           PIC S9(9) COMP VALUE 0.      
           03 ACCOUNT-NO-PRIOR-4478-G      PIC X(13) VALUE SPACES.      
           03 SERV-ORDER-NO-R-4478-G       PIC X(13) VALUE SPACES.      
           03 WANTED-BY-DATETIME-4478      PIC X(26) VALUE SPACES.      
           03 CREDIT-LETTER-IND-4478       PIC X(01) VALUE SPACES.      
           03 STREET-LOCATION-1-4478-G     PIC X(04) VALUE SPACES.      
           03 STREET-LOCATION-2-4478-G     PIC X(11) VALUE SPACES.      
           03 ADDR-ST-4478-G               PIC X(55) VALUE SPACES.      
           03 ADDR-ZIP-CODE-4478-G         PIC X(09) VALUE SPACES.      
           03 ADDR-PREFIX-1-4478-G         PIC X(03) VALUE SPACES.      
           03 ADDR-PREFIX-2-4478-G         PIC X(02) VALUE SPACES.      
           03 ADDR-SUFFIX-4478-G           PIC X(02) VALUE SPACES.      
           03 ADDRESS-OVERFLOW-4478-G      PIC X(35) VALUE SPACES.      
           03 HOUSE-NO-4478-G              PIC X(15) VALUE SPACES.      
           03 ADDRESS-FORMAT-4478-G        PIC X(01) VALUE SPACES.      
           03 STREET-NAME-4478-G           PIC X(30) VALUE SPACES.      
           03 STREET-SUFFIX-4478-G         PIC X(04) VALUE SPACES.      
           03 ZIP-CODE-4478-G              PIC X(05) VALUE SPACES.      
           03 ZIP-CODE-PLUS-FOUR-4478-G    PIC X(04) VALUE SPACES.      
           03 ZIP-CODE-TOKEN-4478-G        PIC X(01) VALUE SPACES.      
           03 SEND-TO-LOCOFF-IND-4478-G    PIC X(01) VALUE SPACES.      
           03 ADDR-COUNTRY-4478-G          PIC X(35) VALUE SPACES.      
           03 CARRIER-ROUTE-4478           PIC X(05) VALUE SPACES.      
           03 FINAL-BILL-CY-ST-4478        PIC X(30) VALUE SPACES.      
           03 FINAL-BILL-OVFL-4478         PIC X(35) VALUE SPACES.      
           03 DEPOSIT-AMT-4478-G           PIC S9(9)V9(2) COMP-3        
                                                     VALUE 0.           
           03 FBILL-ADDR-TYPE-4478         PIC X(01) VALUE SPACES.      
           03 FBILL-ADDR-LINE-4478         PIC X(80) VALUE SPACES.      
                                                                        
DT9511 01  CSR04478-RETURN-DATA-H.                                      
DT9511     03 RETURN-CODE-4478-H           PIC S9(9) COMP VALUE 0.      
DT9511     03 CONTRACT-ID-4478-H           PIC S9(9) COMP VALUE 0.      
                                                                        
                                                                        
       01  CSR04479-CALL-DATA.                                          
           03  ACCOUNT-NO-4479          PIC X(13) VALUE SPACES.         
           03  PREMISE-NO-4479          PIC X(10) VALUE SPACES.         
           03  PROCESS-4479             PIC X(10) VALUE SPACES.         
           03  ASSIGNED-DATE-IN-4479    PIC X(10) VALUE SPACES.         
           03  PROGRAM-ID-4479          PIC X(08) VALUE SPACES.         
           03  ORDER-TYPE-CD-4479       PIC X(05) VALUE SPACES.         
MAINTN     03  SERV-ORDER-NO-4479       PIC X(13) VALUE SPACES.         
MAINTN     03  CURRENT-HISTORY-FL-4479  PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04479-RETURN-DATA-A.                                      
           03  RETURN-CODE-4479-A       PIC S9(9) COMP VALUE 0.         
           03  ASSIGNED-DATE-OUT-4479   PIC X(10) VALUE SPACES.         
           03  SERV-ORDER-NO-4479-A     PIC S9(13)V COMP-3 VALUE 0.     
           03  OUT-ORDER-TYPE-CD-4479   PIC X(05) VALUE SPACES.         
           03  ORDER-STATE-CD-4479      PIC X(01) VALUE SPACES.         
           03  CUSTOMER-NAME-4479       PIC X(76) VALUE SPACES.         
           03  REMARKS-4479             PIC X(210) VALUE SPACES.        
           03  WORK-AREA-4479           PIC X(12) VALUE SPACES.         
           03  PHONE-4479               PIC X(10) VALUE SPACES.         
           03  REMARK-TYPE-4479         PIC X(01) VALUE SPACES.         
           03  SERV-ORDER-STATUS-4479   PIC X(02) VALUE SPACES.         
                                                                        
       01  CSR04479-RETURN-DATA-B.                                      
           03  RETURN-CODE-4479-B       PIC S9(9) COMP VALUE 0.         
           03  CODE-UTIL-TYPE-4479-B    PIC X(03) VALUE SPACES.         
           03  METER-NO-4479-B          PIC X(09) VALUE SPACES.         
           03  RATE-PLAN-4479-B         PIC X(03) VALUE SPACES.         
           03  SUPPLIES-4479            PIC X(15) VALUE SPACES.         
           03  METER-LOC-4479           PIC X(02) VALUE SPACES.         
           03  METER-STATUS-4479        PIC X(01) VALUE SPACES.         
           03  METER-STATUS-REASON-4479 PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-CD-4479-B      PIC X(03) VALUE SPACES.         
           03  METER-READ-INST-4479     PIC X(02) VALUE SPACES.         
           03  METER-IND-4479           PIC X(01) VALUE SPACES.         
           03  IC-NO-4479-B             PIC S9(4) COMP VALUE 0.         
           03  MTR-REF-NO-4479-B        PIC S9(4) COMP VALUE 0.         
           03  CODE-REV-CLASS-4479-B    PIC X(03) VALUE SPACES.         
           03  GAS-MTRS-COUNT-4479      PIC S9(4) COMP VALUE 0.         
           03  ELEC-MTRS-COUNT-4479     PIC S9(4) COMP VALUE 0.         
           03  RLSE-IND-4479-B          PIC X(01) VALUE SPACES.         
           03  RLSE-NO-4479-B           PIC X(10) VALUE SPACES.         
           03  SO-SEQ-NO-4479-B         PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSR04479-RETURN-DATA-C.                                      
           03  RETURN-CODE-4479-C       PIC S9(9) COMP VALUE 0.         
           03  SERV-ORDER-NO-4479-C     PIC S9(13)V COMP-3 VALUE 0.     
           03  CODE-UTIL-TYPE-4479-C    PIC X(01) VALUE SPACES.         
           03  WORK-TYPE-CD-4479-C      PIC X(03) VALUE SPACES.         
           03  IC-NO-4479-C             PIC S9(4) COMP VALUE 0.         
           03  METER-NO-4479-C          PIC X(09) VALUE SPACES.         
           03  MTR-REF-NO-4479-C        PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSR04479-RETURN-DATA-D.                                      
           03  RETURN-CODE-4479-D       PIC S9(9) COMP VALUE 0.         
           03  RATE-PLAN-4479-D         PIC X(03) VALUE SPACES.         
           03  RATE-ITEM-CODE-4479      PIC S9(4) COMP VALUE 0.         
           03  CODE-PLAN-STATUS-4479    PIC X(01) VALUE SPACES.         
           03  CODE-STATUS-REASON-4479  PIC X(01) VALUE SPACES.         
           03  MONTHLY-AMOUNT-4479      PIC S9(3)V99 COMP-3 VALUE 0.    
           03  NO-UNITS-4479            PIC S9(4) COMP VALUE 0.         
           03  SUBDIVISION-FL-4479      PIC X(01) VALUE SPACES.         
           03  IC-NO-4479-D             PIC S9(4) COMP VALUE 0.         
           03  RATE-PLAN-DESC-4479-D    PIC X(25) VALUE SPACES.         
           03  SERVICE-TYPE-4479        PIC X(01) VALUE SPACES.         
           03  DIST-NO-4479             PIC X(03) VALUE SPACES.         
           03  POLE-NO-4479             PIC X(07) VALUE SPACES.         
                                                                        
       01  CSR04479-RETURN-DATA-E.                                      
           03  RETURN-CODE-4479-E       PIC S9(9) COMP VALUE 0.         
           03  CODE-UTIL-TYPE-4479-E    PIC X(01) VALUE SPACES.         
           03  IC-NO-4479-E             PIC S9(4) COMP VALUE 0.         
           03  RATE-PLAN-4479-E         PIC X(03) VALUE SPACES.         
           03  CODE-REV-CLASS-4479-E    PIC X(03) VALUE SPACES.         
           03  RATE-PLAN-DESC-4479-E    PIC X(25) VALUE SPACES.         
           03  TOU-FL-4479              PIC X(01) VALUE SPACES.         
           03  FIXED-FACTOR-FL-4479     PIC X(01) VALUE SPACES.         
           03  BILL-CONTRACT-FL-4479    PIC X(01) VALUE SPACES.         
           03  INTERRUPT-FL-4479        PIC X(01) VALUE SPACES.         
           03  READ-ROUTE-4479          PIC S9(9) COMP VALUE 0.         
                                                                        
                                                                        
       01  CSR04480-CALL-DATA.                                          
           03  CODE-UTIL-TYPE-4480      PIC X(50) VALUE SPACES.         
           03  WORK-TYPE-4480           PIC X(150) VALUE SPACES.        
           03  METER-IND-4480           PIC X(50) VALUE SPACES.         
           03  METER-STATUS-4480        PIC X(50) VALUE SPACES.         
           03  ACCOUNT-NO-4480          PIC X(13) VALUE SPACES.         
           03  PREMISE-NO-4480          PIC X(10) VALUE SPACES.         
           03  ORDER-TYPE-CD-4480       PIC X(05) VALUE SPACES.         
           03  ASSIGNED-DATE-4480       PIC X(10) VALUE SPACES.         
           03  PROGRAM-ID-4480          PIC X(08) VALUE SPACES.         
A05189     03  APPLIANCE-LIT-4480       PIC X(01) VALUE SPACES.         
A05189     03  RELEASE-REQD-4480        PIC X(01) VALUE SPACES.         
A05189     03  FRO-FL-4480              PIC X(01) VALUE SPACES.         
P0795G     03  CRAWL-APPL-FL-4480       PIC X(01) VALUE SPACES.         
P0795H     03  SERV-ORDER-NO-4480       PIC X(13) VALUE SPACES.         
P0795H     03  NEW-ORDER-STATE-CD-4480  PIC X(01) VALUE SPACES.         
P0795H     03  WORK-AREA-ID-4480        PIC X(12) VALUE SPACES.         
                                                                        
       01  CSR04480-RETURN-DATA-A.                                      
           03  RETURN-CODE-4480-A       PIC S9(9) COMP VALUE 0.         
           03  WORK-AREA-4480           PIC X(12) VALUE SPACES.         
           03  DISCONNECT-CD-4480       PIC X(01) VALUE SPACES.         
           03  TOTAL-RES-4480           PIC S9(5)V9(1) COMP-3 VALUE 0.  
           03  ARRANGEMENT-FL-4480      PIC X(01) VALUE SPACES.         
           03  REVERT-FL-4480           PIC X(01) VALUE SPACES.         
P00718     03  BUSINESS-UNIT-4480       PIC X(03) VALUE SPACES.         
P00718     03  WORK-DISTRICT-4480       PIC X(40) VALUE SPACES.         
A05189     03  AROP-READ-ONLY-4480      PIC X(01) VALUE SPACES.         
                                                                        
       01  CSR04480-RETURN-DATA-B.                                      
           03  RETURN-CODE-4480-B       PIC S9(9) COMP VALUE 0.         
           03  CALENDAR-DT-4480         PIC X(10) VALUE SPACES.         
           03  GOOD-DAY-FL-4480         PIC X(01) VALUE SPACES.         
           03  TOTAL-SO-HRS-4480        PIC S9(5)V9(1) COMP-3 VALUE 0.  
           03  MAX-RE-PER-DAY-4480      PIC S9(4) COMP VALUE 0.         
           03  TOTAL-SO-4480            PIC S9(4) COMP VALUE 0.         
           03  MAX-DAILY-WK-REQ-4480    PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSR04012-CALL-DATA.                                          
           03  COMPANY-NO-4012          PIC X(02) VALUE SPACES.         
           03  REV-DISTRICT-CD-4012     PIC X(03) VALUE SPACES.         
           03  CODE-UTIL-TYPE-4012      PIC X(01) VALUE SPACES.         
           03  ORDER-TYPE-CD-4012       PIC X(05) VALUE SPACES.         
           03  WORK-TYPE-CD-4012        PIC X(03) VALUE SPACES.         
           03  RLSE-CHECK-CD-4012       PIC X(01) VALUE SPACES.         
           03  ACCOUNT-NO-4012          PIC X(13) VALUE SPACES.         
           03  IC-NO-4012               PIC X(04) VALUE SPACES.         
           03  MTR-REF-NO-4012          PIC X(04) VALUE SPACES.         
           03  METER-SUPPLYING-CD-4012  PIC X(02) VALUE SPACES.         
           03  CODE-STATUS-REAS-4012    PIC X(01) VALUE SPACES.         
           03  CALLING-SYSTEM-4012      PIC X(03) VALUE SPACES.         
           03  WANTED-BY-DATE-4012      PIC X(10) VALUE SPACES.         
           03  PREMISE-NO-4012          PIC X(10) VALUE SPACES.         
           03  RLSE-TYPE-4012           PIC X(02) VALUE SPACES.         
           03  RLSE-SUPPLIES-4012       PIC X(15) VALUE SPACES.         
                                                                        
       01  CSR04012-RETURN-DATA.                                        
           05  RETURN-CODE-4012      PIC S9(9)     COMP VALUE 0.        
           05  RLSE-REQUIRED-FL-4012 PIC X(01)     VALUE SPACES.        
           05  MESSAGE-4012          PIC X(05)     VALUE SPACES.        
           05  ADTL-MESSAGE-4012     PIC X(05)     VALUE SPACES.        
           05  PHONE-4012            PIC X(12)     VALUE SPACES.        
           05  ALT-PHONE-4012        PIC X(12)     VALUE SPACES.        
           05  UTIL-TYPE-4012        PIC X(04)     VALUE SPACES.        
           05  REV-DIST-DESC-4012    PIC X(25)     VALUE SPACES.        
           05  RLSE-EXISTS-4012      PIC X(01)     VALUE SPACES.        
           05  RLSE-NO-4012          PIC X(10)     VALUE SPACES.        
                                                                        
       01  CSR04281-CALL-DATA.                                          
           05  CUSTOMER-NO-4281         PIC X(10) VALUE SPACES.         
           05  COMPANY-NO-4281          PIC X(02) VALUE SPACES.         
                                                                        
       01  CSR04281-RETURN-DATA.                                        
           05  RETURN-CODE-4281         PIC S9(9) COMP VALUE 0.         
           05  ACCOUNT-NO-4281          PIC S9(13)V COMP-3 VALUE +0.    
           05  CODE-ACCT-STAT-4281      PIC X(01) VALUE  SPACES.        
           05  PAST-DUE-UTIL-4281       PIC S9(09)V99 COMP-3 VALUE +0.  
           05  PAST-DUE-NONUTIL-4281    PIC S9(09)V99 COMP-3 VALUE +0.  
           05  CUST-TYPE-4281           PIC X(30) VALUE  SPACES.        
           05  SSN-4281                 PIC X(09) VALUE SPACES.         
           05  SERV-ADDRESS-4281        PIC X(75) VALUE SPACES.         
           05  PREMISE-NO-4281          PIC S9(10)V COMP-3 VALUE +0.    
           05  CIA-4281                 PIC S9(09)V99 COMP-3 VALUE +0.  
           05  BILLED-BALANCE-4281      PIC S9(09)V99 COMP-3 VALUE +0.  
           05  DEPOSIT-DUE-4281         PIC S9(09)V99 COMP-3 VALUE +0.  
           05  PAYMENTS-4281            PIC S9(09)V99 COMP-3 VALUE +0.  
           05  PSNC-LABOR-CHG-4281      PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RET-CHECK-FL-4281        PIC X(01) VALUE SPACES.         
           05  ARREARS-UTIL-4281        PIC S9(9)V99 COMP-3 VALUE +0.   
           05  ARREARS-NONUTIL-4281     PIC S9(9)V99 COMP-3 VALUE +0.   
           05  AMT-INSTALL-DEP-4281     PIC S9(9)V99 COMP-3 VALUE +0.   
           05  NAME-4281                PIC X(76) VALUE SPACES.         
           05  TOTAL-DUE-4281           PIC S9(9)V99 COMP-3 VALUE +0.   
                                                                        
       01  WS-TABLES.                                                   
           05  WS-SUPPLYING-TABLE.                                      
               10  WS-SUPPLYING-DATA.                                   
                   15  FILLER  PIC X(17) VALUE 'A APARTMENT      '.     
                   15  FILLER  PIC X(17) VALUE 'B BALL PARK      '.     
                   15  FILLER  PIC X(17) VALUE 'C BARN           '.     
                   15  FILLER  PIC X(17) VALUE 'D BOAT HOUSE/DOCK'.     
                   15  FILLER  PIC X(17) VALUE 'E CAMPER/RV TRLR '.     
                   15  FILLER  PIC X(17) VALUE 'F COMMERCIAL     '.     
                   15  FILLER  PIC X(17) VALUE 'G COMM TRAILER   '.     
                   15  FILLER  PIC X(17) VALUE 'H COTTAGE APT    '.     
                   15  FILLER  PIC X(17) VALUE 'I FIRECRACKER STD'.     
                   15  FILLER  PIC X(17) VALUE 'J GARAGE         '.     
                   15  FILLER  PIC X(17) VALUE 'K GARAGE APT     '.     
                   15  FILLER  PIC X(17) VALUE 'L GREENHOUSE     '.     
                   15  FILLER  PIC X(17) VALUE 'M HOUSE          '.     
                   15  FILLER  PIC X(17) VALUE 'N INDUSTRIAL     '.     
                   15  FILLER  PIC X(17) VALUE 'O IRRIGATION     '.     
                   15  FILLER  PIC X(17) VALUE 'P LIFT STATION   '.     
                   15  FILLER  PIC X(17) VALUE 'Q MOBILE HOME    '.     
                   15  FILLER  PIC X(17) VALUE 'R POOL HEATER    '.     
                   15  FILLER  PIC X(17) VALUE 'S PUMP/WELL      '.     
                   15  FILLER  PIC X(17) VALUE 'T STANDBY GEN    '.     
                   15  FILLER  PIC X(17) VALUE 'U T-SAW POLE     '.     
                   15  FILLER  PIC X(17) VALUE 'V TOBACCO BARN   '.     
                   15  FILLER  PIC X(17) VALUE 'W TURKEY SHOOT   '.     
                   15  FILLER  PIC X(17) VALUE 'X WAREHOUSE      '.     
                   15  FILLER  PIC X(17) VALUE 'Y WHOLESALE CUST '.     
                   15  FILLER  PIC X(17) VALUE 'Z XMAS TREE STAND'.     
                   15  FILLER  PIC X(17) VALUE '0 UNKNOWN        '.     
               10  WS-SUPPLYING-DATA-R REDEFINES WS-SUPPLYING-DATA.     
                   15  WS-SUPPLYING-LINE  OCCURS 27                     
                                          INDEXED BY WS-SUPPLYING-INDEX.
                       20 WS-SUPPLYING-CD   PIC X(02).                  
                       20 WS-SUPPLYING-DESC PIC X(15).                  
                                                                        
           05  T1-PREM-APPLIANCES     OCCURS 30                         
                                      INDEXED BY T1-INDEX.              
               10  T1-EQUIPMENT-NO      PIC X(20).                      
               10  T1-APPLIANCE-CD      PIC X(02).                      
                                                                        
           05  T2-ORDER-APPLIANCES    OCCURS 30                         
                                      INDEXED BY T2-INDEX.              
               10  T2-EQUIPMENT-NO      PIC X(20).                      
               10  T2-APPLIANCE-CD      PIC X(02).                      
                                                                        
                                                                        
           COPY CWS00303.                                                       
           COPY CWSSP001.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPLN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRULXRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORWT                                                    
           END-EXEC.                                                            
      * CSS_ORDER_TYPE C2                                                       
           EXEC SQL                                                             
              INCLUDE TBORTYP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBORDPRI                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
MAINTN*  HST_SO_DATA YV                                                         
           EXEC SQL                                                             
              INCLUDE TBHSTDAT                                                  
           END-EXEC.                                                            
                                                                        
A10004*  HST_SO_ORDER_INST ZG                                                   
           EXEC SQL                                                             
              INCLUDE TBHSTODR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOEQP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBAPPLAN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMKTAPL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLNDLRD                                                  
           END-EXEC.                                                            
                                                                        
P0795J*   CSS_UNMTR_PLAN UP                                                     
P0795J     EXEC SQL                                                             
P0795J        INCLUDE TBUMPLAN                                                  
P0795J     END-EXEC.                                                            
                                                                        
P0795J*   CSS_ZIPCODE_SUBDIV  ZS                                                
P0795J     EXEC SQL                                                             
P0795J        INCLUDE TBZIPSUB                                                  
P0795J     END-EXEC.                                                            
P0795J                                                                  
P0795J*   CSS_RATE_PLAN_DESC RD                                                 
P0795J     EXEC SQL                                                             
P0795J        INCLUDE TBRTDESC                                                  
P0795J     END-EXEC.                                                            
                                                                        
A04670     EXEC SQL                                                             
A04670        INCLUDE TBDELQ                                                    
A04670     END-EXEC.                                                            
                                                                        
                                                                        
P0796B*  A9   - CSS_REV_DISTRICT                                                
P0796B     EXEC SQL                                                             
P0796B        INCLUDE TBRVDST                                                   
P0796B     END-EXEC.                                                            
                                                                        
P0796B*  BA   - CSS_RLSE_REV_DIST                                               
P0796B     EXEC SQL                                                             
P0796B        INCLUDE TBRLSERD                                                  
P0796B     END-EXEC.                                                            
                                                                        
D10775*  BQ   - CSS_BANKRUPTCY                                                  
D10775     EXEC SQL                                                             
D10775        INCLUDE TBBNKRPT                                                  
D10775     END-EXEC.                                                            
                                                                        
D10775*  F5   - CSS_CATEGORY                                                    
D10775     EXEC SQL                                                             
D10775        INCLUDE TBCAT                                                     
D10775     END-EXEC.                                                            
                                                                        
A05821*  *** CSS_CUST_MISC_INFO LQ                                              
A05821     EXEC SQL                                                             
A05821         INCLUDE TBCSTMSC                                                 
A05821     END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00099                                                
           END-EXEC.                                                            
                                                                        
      *01 LOC4477 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4478A USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4478B USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4478C USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4478D USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4478E USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4478F USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4478G USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4478H USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479A USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479B USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479C USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479D USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4479E USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4480A USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4480B USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.        
      *01 LOC4012 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
      *01 LOC4281 USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.         
                                                                        
           EXEC SQL                                                     
              DECLARE ACCT-CURSOR CURSOR FOR                            
                  SELECT ACCOUNT_NO,                                    
                         CODE_ACCT_STAT,                                
                         ADDR_USAGE_CD,                                 
                         RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + ';' + ' ' + LTRIM(RTRIM(TOWN) + 
           ', ' + LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE)))
           )))))))))),          
                         RTRIM(LTRIM(RTRIM(STREET_NAME) + ' & ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW) + ' ' + ';' + ' ' + LTRIM(RTRIM(TOWN
           ) + ', ' + LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(
           DY.ZIP_CODE)))))))                 
                    FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                  
                         CSS_PREMISE PR WITH(READUNCOMMITTED),                  
                         CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),           
                         CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                  
                   WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                  
                     AND AT.COMPANY_NO = :AT-COMPANY-NO                 
                     AND CODE_ACCT_STAT IN ('A', 'P')                   
                     AND ACCOUNT_NO <> :AT-ACCOUNT-NO                   
P0795E               AND MST_SUB_ACCT_IND <> 'S'                        
D10742               AND AT.CREDIT_GROUP NOT IN ('M','D')               
                     AND ACCT_CREATE_DT >= CIS.CHAR2TIMESTAMP(
                                                   :WS-TS-MINUS-31-DAYS
              )         
                     AND AT.PREMISE_NO = PR.PREMISE_NO                  
                     AND PR.ADDRESS_ID = DY.ADDRESS_ID                  
                     AND DY.ZIP_CODE = A4.ZIP_CODE                      
                     AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN          
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ACCT-CURSOR CURSOR FOR                                    
MFA-TR*           SELECT ACCOUNT_NO,                                            
MFA-TR*                  CODE_ACCT_STAT,                                        
MFA-TR*                  ADDR_USAGE_CD,                                         
MFA-TR*                  RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                  
MFA-TR*                  LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(STREET_NAME) || ' ' ||                     
MFA-TR*                  LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                     
MFA-TR*                  LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||               
MFA-TR*                  LTRIM(RTRIM(STREET_LOCATION_2) || ' ' ||               
MFA-TR*                  ';' || ' ' ||                                          
MFA-TR*                  LTRIM(RTRIM(TOWN) || ', ' ||                           
MFA-TR*                  LTRIM(RTRIM(STATE) || ' ' ||                           
MFA-TR*                  LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),                  
MFA-TR*                  RTRIM(LTRIM(RTRIM(STREET_NAME) || ' & ' ||             
MFA-TR*                  LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||                
MFA-TR*                  ';' || ' ' ||                                          
MFA-TR*                  LTRIM(RTRIM(TOWN) || ', ' ||                           
MFA-TR*                  LTRIM(RTRIM(STATE) || ' ' ||                           
MFA-TR*                  LTRIM(RTRIM(DY.ZIP_CODE)))))))                         
MFA-TR*             FROM CSS_ACCOUNT AT,                                        
MFA-TR*                  CSS_PREMISE PR,                                        
MFA-TR*                  CSS_ADDR_FORMATTED DY,                                 
MFA-TR*                  CSS_ZIP_CODE A4                                        
MFA-TR*            WHERE CUSTOMER_NO = :AT-CUSTOMER-NO                          
MFA-TR*              AND AT.COMPANY_NO = :AT-COMPANY-NO                         
MFA-TR*              AND CODE_ACCT_STAT IN ('A', 'P')                           
MFA-TR*              AND ACCOUNT_NO <> :AT-ACCOUNT-NO                           
MFA-TR*              AND MST_SUB_ACCT_IND <> 'S'                                
MFA-TR*              AND AT.CREDIT_GROUP NOT IN ('M','D')                       
MFA-TR*              AND ACCT_CREATE_DT >= :WS-TS-MINUS-31-DAYS                 
MFA-TR*              AND AT.PREMISE_NO = PR.PREMISE_NO                          
MFA-TR*              AND PR.ADDRESS_ID = DY.ADDRESS_ID                          
MFA-TR*              AND DY.ZIP_CODE = A4.ZIP_CODE                              
MFA-TR*              AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                  
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7100                                                  
MFA-TR*    END-EXEC.                                                            
MAINTN* CURSOR TO GET ALL ACTIVE AND PENDING ACCTS FOR MAINTAIN XFER            
           EXEC SQL                                                     
              DECLARE MAINT-ACCT-CURSOR CURSOR FOR                      
                  SELECT ACCOUNT_NO,                                    
                         CODE_ACCT_STAT,                                
                         ADDR_USAGE_CD,                                 
                         RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + ';' + ' ' + LTRIM(RTRIM(TOWN) + 
           ', ' + LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE)))
           )))))))))),          
                         RTRIM(LTRIM(RTRIM(STREET_NAME) + ' & ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW) + ' ' + ';' + ' ' + LTRIM(RTRIM(TOWN
           ) + ', ' + LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(
           DY.ZIP_CODE)))))))                 
                    FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                  
                         CSS_PREMISE PR WITH(READUNCOMMITTED),                  
                         CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),           
                         CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                  
                   WHERE CUSTOMER_NO = :WS-AT-CUSTOMER-NO-PR            
                     AND AT.COMPANY_NO = :WS-AT-COMPANY-NO-PR           
DT8959*              AND CODE_ACCT_STAT IN ('A', 'P')                           
DT9505               AND ACCOUNT_NO <> :WS-AT-ACCOUNT-NO-PR             
P0795E               AND MST_SUB_ACCT_IND <> 'S'                        
D10742               AND CREDIT_GROUP NOT IN ('M', 'D')                 
                     AND AT.PREMISE_NO = PR.PREMISE_NO                  
                     AND PR.ADDRESS_ID = DY.ADDRESS_ID                  
                     AND DY.ZIP_CODE = A4.ZIP_CODE                      
                     AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN          
                  FOR READ ONLY                                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MAINT-ACCT-CURSOR CURSOR FOR                              
MFA-TR*           SELECT ACCOUNT_NO,                                            
MFA-TR*                  CODE_ACCT_STAT,                                        
MFA-TR*                  ADDR_USAGE_CD,                                         
MFA-TR*                  RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                  
MFA-TR*                  LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(STREET_NAME) || ' ' ||                     
MFA-TR*                  LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                     
MFA-TR*                  LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||               
MFA-TR*                  LTRIM(RTRIM(STREET_LOCATION_2) || ' ' ||               
MFA-TR*                  ';' || ' ' ||                                          
MFA-TR*                  LTRIM(RTRIM(TOWN) || ', ' ||                           
MFA-TR*                  LTRIM(RTRIM(STATE) || ' ' ||                           
MFA-TR*                  LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),                  
MFA-TR*                  RTRIM(LTRIM(RTRIM(STREET_NAME) || ' & ' ||             
MFA-TR*                  LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||                
MFA-TR*                  ';' || ' ' ||                                          
MFA-TR*                  LTRIM(RTRIM(TOWN) || ', ' ||                           
MFA-TR*                  LTRIM(RTRIM(STATE) || ' ' ||                           
MFA-TR*                  LTRIM(RTRIM(DY.ZIP_CODE)))))))                         
MFA-TR*             FROM CSS_ACCOUNT AT,                                        
MFA-TR*                  CSS_PREMISE PR,                                        
MFA-TR*                  CSS_ADDR_FORMATTED DY,                                 
MFA-TR*                  CSS_ZIP_CODE A4                                        
MFA-TR*            WHERE CUSTOMER_NO = :WS-AT-CUSTOMER-NO-PR                    
MFA-TR*              AND AT.COMPANY_NO = :WS-AT-COMPANY-NO-PR                   
MFA-TR*              AND CODE_ACCT_STAT IN ('A', 'P')                           
MFA-TR*              AND ACCOUNT_NO <> :WS-AT-ACCOUNT-NO-PR                     
MFA-TR*              AND MST_SUB_ACCT_IND <> 'S'                                
MFA-TR*              AND CREDIT_GROUP NOT IN ('M', 'D')                         
MFA-TR*              AND AT.PREMISE_NO = PR.PREMISE_NO                          
MFA-TR*              AND PR.ADDRESS_ID = DY.ADDRESS_ID                          
MFA-TR*              AND DY.ZIP_CODE = A4.ZIP_CODE                              
MFA-TR*              AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                  
MFA-TR*           FOR FETCH ONLY                                                
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7200                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE PREM-APPL-CURSOR CURSOR FOR                       
               SELECT EQUIPMENT_NO,                                     
                      LA.APPLIANCE_CD                                   
                 FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                   
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :LA-PREMISE-NO                       
                  AND PRIMARY_FUEL_CD = 'NA-GAS'                        
                  AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                 
                  AND LA.COMPANY_NO = JA.COMPANY_NO                     
                  AND CIS_DISPLAY_FL = 'Y'                              
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE PREM-APPL-CURSOR CURSOR FOR                               
MFA-TR*        SELECT EQUIPMENT_NO,                                             
MFA-TR*               LA.APPLIANCE_CD                                           
MFA-TR*          FROM CSS_APPLIANCE LA,                                         
MFA-TR*               CSS_MKT_APPLIANCE JA                                      
MFA-TR*         WHERE PREMISE_NO = :LA-PREMISE-NO                               
MFA-TR*           AND PRIMARY_FUEL_CD = 'NA-GAS'                                
MFA-TR*           AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                         
MFA-TR*           AND LA.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE ORDER-APPL-CURSOR CURSOR FOR                      
               SELECT EQUIPMENT_UNQ,                                    
                      APPLIANCE_CD                                      
                 FROM CSS_SO_APPLIANCE VQ WITH(READUNCOMMITTED)                 
                WHERE SERV_ORDER_NO = :VQ-SERV-ORDER-NO                 
                                                                 
                FOR READ ONLY                                          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ORDER-APPL-CURSOR CURSOR FOR                              
MFA-TR*        SELECT EQUIPMENT_UNQ,                                            
MFA-TR*               APPLIANCE_CD                                              
MFA-TR*          FROM CSS_SO_APPLIANCE VQ                                       
MFA-TR*         WHERE SERV_ORDER_NO = :VQ-SERV-ORDER-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         QUERYNO 8000                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
TESTIN*    EXEC-SQL                                                             
TESTIN*       DECLARE ORDER-APPL-CURSOR CURSOR FOR                              
TESTIN*        SELECT VQ.EQUIPMENT_UNQ,                                         
TESTIN*               VQ.APPLIANCE_CD                                           
TESTIN*          FROM CSS_SO_APPLIANCE VQ                                       
TESTIN*         WHERE VQ.SERV_ORDER_NO = :VQ-SERV-ORDER-NO                      
TESTIN*         WITH UR                                                         
TESTIN*         FOR FETCH ONLY                                                  
TESTIN*         QUERYNO 7601                                                    
TESTIN*    END-EXEC.                                                            
                                                                        
P0795A*    EXEC SQL                                                             
P0795A*       DECLARE MKT-CONTRACTS CURSOR WITH RETURN                          
P0795A*                                    WITH ROWSET POSITIONING FOR          
P0795A*           SELECT CUST_CNT_ID,                                           
P0795A*                  CNT_STATUS_CD                                          
P0795A*             FROM CSS_MSE_CNT_SUMM AW                                    
P0795A*            WHERE ACCOUNT_NO  = :AW-ACCOUNT-NO                           
P0795A*              AND CNT_STATUS_CD IN ('P', 'D', 'Z', 'O', 'A', 'L')        
P0795A*           WITH UR                                                       
P0795A*           QUERYNO 7111                                                  
P0795A*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 STATUS_CODE          AS STATUS_CODE,                   
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 ACTION_TYPE_CD       AS ACTION_TYPE_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID               
              FROM #CSR04476_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          STATUS_CODE          AS STATUS_CODE,                           
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          ACTION_TYPE_CD       AS ACTION_TYPE_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID                       
MFA-TR*       FROM SESSION.CSR04476_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N1 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-1     AS RETURN_CODE,              
                      :S-STATUS-CODE       AS STATUS_CODE,              
                      :S-BUS-RULE-ID       AS BUS_RULE_ID,              
                      :S-ACTION-TYPE-CD    AS ACTION_TYPE_CD,           
                      :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID          
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N1 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-1     AS RETURN_CODE,                      
MFA-TR*               :S-STATUS-CODE       AS STATUS_CODE,                      
MFA-TR*               :S-BUS-RULE-ID       AS BUS_RULE_ID,                      
MFA-TR*               :S-ACTION-TYPE-CD    AS ACTION_TYPE_CD,                   
MFA-TR*               :S-BUS-RULE-XREF-ID  AS BUS_RULE_XREF_ID                  
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR  WITH ROWSET POSITIONING FOR
               SELECT :S-RETURN-CODE-2     AS RETURN_CODE,              
                      :S-BILL-ADDRESS      AS BILL_ADDRESS,             
                      :S-REVERT-FL         AS REVERT_FL,                
                      :S-NEXT-BUS-DAY      AS NEXT_BUS_DAY,             
                      :S-HIGH-LEVEL-ORDER  AS NEW_ORDER_TYPE_CD,        
                      :S-HARD-ERROR        AS HARD_ERROR,               
                      :S-SPCL-READ-INST    AS SPCL_READ_INST,           
                      :S-SPCL-INST         AS SPCL_INST,                
                      :S-PREM-DIRECTIONS   AS PREM_DIRECTIONS,          
                      :S-SCRATCHPAD        AS SCRATCHPAD,               
                      :S-ADDRESS-ID        AS ADDRESS_ID,               
                      :S-ADDRESS-FORMAT    AS ADDRESS_FORMAT,           
                      :S-ADDR-STREET       AS ADDR_STREET,              
                      :S-ADDR-CITY-STATE   AS ADDR_CITY_STATE,          
                      :S-ADDR-ZIP-CODE     AS ADDR_ZIP_CODE,            
                      :S-ADDR-COUNTRY      AS ADDR_COUNTRY,             
                      :S-ADDR-STREET-2     AS ADDR_STREET_2,            
                      :S-HOUSE-NO          AS HOUSE_NO,                 
                      :S-ADDR-PREFIX-1     AS ADDR_PREFIX_1,            
                      :S-ADDR-PREFIX-2     AS ADDR_PREFIX_2,            
                      :S-STREET-NAME       AS STREET_NAME,              
                      :S-STREET-SUFFIX     AS STREET_SUFFIX,            
                      :S-ADDR-SUFFIX       AS ADDR_SUFFIX,              
                      :S-STREET-LOCATION-1 AS STREET_LOCATION_1,        
                      :S-STREET-LOCATION-2 AS STREET_LOCATION_2,        
                      :S-ZIP-CODE          AS ZIP_CODE,                 
                      :S-ZIP-CODE-PLUS-FOUR AS ZIP_CODE_PLUS_FOUR,      
                      :S-ZIP-CODE-TOKEN    AS ZIP_CODE_TOKEN,           
                      :S-STATE             AS STATE,                    
                      :S-WORK-AREA-2       AS WORK_AREA,                
                      :S-TOTAL-RES         AS TOTAL_RES,                
                      :S-DISCONNECT-CD     AS DISCONNECT_CD,            
                      :S-ARRANGEMENT-FL    AS ARRANGEMENT_FL,           
                      :S-PREMISE-NO        AS PREMISE_NO,               
                      :S-LL-CUSTOMER-NO    AS LL_CUSTOMER_NO,           
                      :S-SUBDIVISION-ID    AS SUBDIVISION_ID,           
                      :S-EST-BILL-DAY      AS EST_BILL_DAY,             
                      :S-EST-DUE-DAY       AS EST_DUE_DAY,              
                      :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS,            
                      :S-PAYMENT-REQ-FL    AS PAYMENT_REQ_FL,           
A04670                :S-CODE-RENTAL-PROP  AS CODE_RENTAL_PROP,         
A4670A                :S-CURR-ACCOUNT-NO   AS CURR_ACCOUNT_NO,          
P00718                :S-BUSINESS-UNIT-2   AS BUSINESS_UNIT,            
P00718          LTRIM(RTRIM(:S-WORK-DISTRICT-2))  AS WORK_DISTRICT,            
P00795                :S-UNMTR-WORK-TYPE   AS UNMTR_WORK_TYPE,          
P00795                :S-ORIG-WORK-TYPE    AS ORIG_WORK_TYPE,           
P00795                :S-ORIG-UTIL-TYPE    AS ORIG_UTIL_TYPE,           
P0795B                :S-SET-RLSE-REQD-FL  AS SET_RLSE_REQD_FL,         
A05189                :S-AROP-READ-ONLY-FL AS AROP_READ_ONLY_FL,        
DT6945                :S-SAME-DAY-FL AS SAME_DAY_ORDER_FL,              
MAINTN                :S-APPLIANCE-RELOAD-FL AS APPLIANCE_RELOAD_FL,    
D10775                :S-READ-ROUTE          AS READ_ROUTE,             
D10775                :S-BNKRPT-CASE-NO      AS BNKRPT_CASE_NO,         
D10775                :S-BNKRPT-FILED-CASE-NO AS BNKRPT_FILED_CASE_NO,  
D10775                :S-BNKRPT-FILED-DATE   AS BNKRPT_FILED_DATE,      
D10775                :S-BNKRPT-CHAPTER      AS BNKRPT_CHAPTER          
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*        SELECT :S-RETURN-CODE-2     AS RETURN_CODE,                      
MFA-TR*               :S-BILL-ADDRESS      AS BILL_ADDRESS,                     
MFA-TR*               :S-REVERT-FL         AS REVERT_FL,                        
MFA-TR*               :S-NEXT-BUS-DAY      AS NEXT_BUS_DAY,                     
MFA-TR*               :S-HIGH-LEVEL-ORDER  AS NEW_ORDER_TYPE_CD,                
MFA-TR*               :S-HARD-ERROR        AS HARD_ERROR,                       
MFA-TR*               :S-SPCL-READ-INST    AS SPCL_READ_INST,                   
MFA-TR*               :S-SPCL-INST         AS SPCL_INST,                        
MFA-TR*               :S-PREM-DIRECTIONS   AS PREM_DIRECTIONS,                  
MFA-TR*               :S-SCRATCHPAD        AS SCRATCHPAD,                       
MFA-TR*               :S-ADDRESS-ID        AS ADDRESS_ID,                       
MFA-TR*               :S-ADDRESS-FORMAT    AS ADDRESS_FORMAT,                   
MFA-TR*               :S-ADDR-STREET       AS ADDR_STREET,                      
MFA-TR*               :S-ADDR-CITY-STATE   AS ADDR_CITY_STATE,                  
MFA-TR*               :S-ADDR-ZIP-CODE     AS ADDR_ZIP_CODE,                    
MFA-TR*               :S-ADDR-COUNTRY      AS ADDR_COUNTRY,                     
MFA-TR*               :S-ADDR-STREET-2     AS ADDR_STREET_2,                    
MFA-TR*               :S-HOUSE-NO          AS HOUSE_NO,                         
MFA-TR*               :S-ADDR-PREFIX-1     AS ADDR_PREFIX_1,                    
MFA-TR*               :S-ADDR-PREFIX-2     AS ADDR_PREFIX_2,                    
MFA-TR*               :S-STREET-NAME       AS STREET_NAME,                      
MFA-TR*               :S-STREET-SUFFIX     AS STREET_SUFFIX,                    
MFA-TR*               :S-ADDR-SUFFIX       AS ADDR_SUFFIX,                      
MFA-TR*               :S-STREET-LOCATION-1 AS STREET_LOCATION_1,                
MFA-TR*               :S-STREET-LOCATION-2 AS STREET_LOCATION_2,                
MFA-TR*               :S-ZIP-CODE          AS ZIP_CODE,                         
MFA-TR*               :S-ZIP-CODE-PLUS-FOUR AS ZIP_CODE_PLUS_FOUR,              
MFA-TR*               :S-ZIP-CODE-TOKEN    AS ZIP_CODE_TOKEN,                   
MFA-TR*               :S-STATE             AS STATE,                            
MFA-TR*               :S-WORK-AREA-2       AS WORK_AREA,                        
MFA-TR*               :S-TOTAL-RES         AS TOTAL_RES,                        
MFA-TR*               :S-DISCONNECT-CD     AS DISCONNECT_CD,                    
MFA-TR*               :S-ARRANGEMENT-FL    AS ARRANGEMENT_FL,                   
MFA-TR*               :S-PREMISE-NO        AS PREMISE_NO,                       
MFA-TR*               :S-LL-CUSTOMER-NO    AS LL_CUSTOMER_NO,                   
MFA-TR*               :S-SUBDIVISION-ID    AS SUBDIVISION_ID,                   
MFA-TR*               :S-EST-BILL-DAY      AS EST_BILL_DAY,                     
MFA-TR*               :S-EST-DUE-DAY       AS EST_DUE_DAY,                      
MFA-TR*               :S-EMAIL-ADDRESS     AS EMAIL_ADDRESS,                    
MFA-TR*               :S-PAYMENT-REQ-FL    AS PAYMENT_REQ_FL,                   
MFA-TR*               :S-CODE-RENTAL-PROP  AS CODE_RENTAL_PROP,                 
MFA-TR*               :S-CURR-ACCOUNT-NO   AS CURR_ACCOUNT_NO,                  
MFA-TR*               :S-BUSINESS-UNIT-2   AS BUSINESS_UNIT,                    
MFA-TR*         STRIP(:S-WORK-DISTRICT-2)  AS WORK_DISTRICT,                    
MFA-TR*               :S-UNMTR-WORK-TYPE   AS UNMTR_WORK_TYPE,                  
MFA-TR*               :S-ORIG-WORK-TYPE    AS ORIG_WORK_TYPE,                   
MFA-TR*               :S-ORIG-UTIL-TYPE    AS ORIG_UTIL_TYPE,                   
MFA-TR*               :S-SET-RLSE-REQD-FL  AS SET_RLSE_REQD_FL,                 
MFA-TR*               :S-AROP-READ-ONLY-FL AS AROP_READ_ONLY_FL,                
MFA-TR*               :S-SAME-DAY-FL AS SAME_DAY_ORDER_FL,                      
MFA-TR*               :S-APPLIANCE-RELOAD-FL AS APPLIANCE_RELOAD_FL,            
MFA-TR*               :S-READ-ROUTE          AS READ_ROUTE,                     
MFA-TR*               :S-BNKRPT-CASE-NO      AS BNKRPT_CASE_NO,                 
MFA-TR*               :S-BNKRPT-FILED-CASE-NO AS BNKRPT_FILED_CASE_NO,          
MFA-TR*               :S-BNKRPT-FILED-DATE   AS BNKRPT_FILED_DATE,              
MFA-TR*               :S-BNKRPT-CHAPTER      AS BNKRPT_CHAPTER                  
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C3 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 ASSIGNED_DATE        AS ASSIGNED_DATE,                 
                 SERV_ORDER_NO        AS SERV_ORDER_NO,                 
                 ORDER_TYPE_CD        AS ORDER_TYPE_CD,                 
                 ORDER_STATE_CD       AS ORDER_STATE_CD,                
                 CUSTOMER_NAME        AS CUSTOMER_NAME,                 
                 REMARKS              AS REMARKS,                       
                 WORK_AREA            AS WORK_AREA,                     
                 PHONE                AS PHONE,                         
                 REMARK_TYPE          AS REMARK_TYPE,                   
                 SERV_ORDER_STATUS    AS SERV_ORDER_STATUS              
P00718*          BUSINESS_UNIT        AS BUSINESS_UNIT                          
              FROM #CSR04476_R3                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C3 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          ASSIGNED_DATE        AS ASSIGNED_DATE,                         
MFA-TR*          SERV_ORDER_NO        AS SERV_ORDER_NO,                         
MFA-TR*          ORDER_TYPE_CD        AS ORDER_TYPE_CD,                         
MFA-TR*          ORDER_STATE_CD       AS ORDER_STATE_CD,                        
MFA-TR*          CUSTOMER_NAME        AS CUSTOMER_NAME,                         
MFA-TR*          REMARKS              AS REMARKS,                               
MFA-TR*          WORK_AREA            AS WORK_AREA,                             
MFA-TR*          PHONE                AS PHONE,                                 
MFA-TR*          REMARK_TYPE          AS REMARK_TYPE,                           
MFA-TR*          SERV_ORDER_STATUS    AS SERV_ORDER_STATUS                      
MFA-TR*          BUSINESS_UNIT        AS BUSINESS_UNIT                          
MFA-TR*       FROM SESSION.CSR04476_R3                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N3 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-3     AS RETURN_CODE,              
                      :S-ASSIGNED-DATE     AS ASSIGNED_DATE,            
                      :S-SERV-ORDER-NO-3   AS SERV_ORDER_NO,            
                      :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,            
                      :S-ORDER-STATE-CD    AS ORDER_STATE_CD,           
                      :S-CUSTOMER-NAME     AS CUSTOMER_NAME,            
                      :S-REMARKS           AS REMARKS,                  
                      :S-WORK-AREA-3       AS WORK_AREA,                
                      :S-PHONE             AS PHONE,                    
                      :S-REMARK-TYPE       AS REMARK_TYPE,              
                      :S-SERV-ORDER-STATUS AS SERV_ORDER_STATUS         
P00718*               :S-BUSINESS-UNIT-3   AS BUSINESS_UNIT                     
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N3 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-3     AS RETURN_CODE,                      
MFA-TR*               :S-ASSIGNED-DATE     AS ASSIGNED_DATE,                    
MFA-TR*               :S-SERV-ORDER-NO-3   AS SERV_ORDER_NO,                    
MFA-TR*               :S-ORDER-TYPE-CD     AS ORDER_TYPE_CD,                    
MFA-TR*               :S-ORDER-STATE-CD    AS ORDER_STATE_CD,                   
MFA-TR*               :S-CUSTOMER-NAME     AS CUSTOMER_NAME,                    
MFA-TR*               :S-REMARKS           AS REMARKS,                          
MFA-TR*               :S-WORK-AREA-3       AS WORK_AREA,                        
MFA-TR*               :S-PHONE             AS PHONE,                            
MFA-TR*               :S-REMARK-TYPE       AS REMARK_TYPE,                      
MFA-TR*               :S-SERV-ORDER-STATUS AS SERV_ORDER_STATUS                 
MFA-TR*               :S-BUSINESS-UNIT-3   AS BUSINESS_UNIT                     
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C4 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 METER_NO             AS METER_NO,                      
                 RATE_PLAN            AS RATE_PLAN,                     
                 SUPPLIES             AS SUPPLIES,                      
                 METER_LOC            AS METER_LOC,                     
                 METER_STATUS         AS METER_STATUS,                  
                 METER_STATUS_REASON  AS METER_STATUS_REASON,           
                 WORK_TYPE_CD         AS WORK_TYPE_CD,                  
                 METER_READ_INST      AS METER_READ_INST,               
                 METER_IND            AS METER_IND,                     
                 IC_NO                AS IC_NO,                         
                 MTR_REF_NO           AS MTR_REF_NO,                    
                 CODE_REV_CLASS       AS CODE_REV_CLASS,                
                 RLSE_REQUIRED        AS RLSE_REQUIRED,                 
                 RLSE_NO              AS RLSE_NO,                       
                 RLSE_MSG             AS RLSE_MSG,                      
                 RLSE_ADDL_MSG        AS RLSE_ADDL_MSG,                 
                 RLSE_PHONE           AS RLSE_PHONE,                    
                 RLSE_ALT_PHONE       AS RLSE_ALT_PHONE,                
                 RLSE_REV_DIST        AS RLSE_REV_DIST,                 
                 BUS_RULE_ID          AS BUS_RULE_ID,                   
                 ACTION_TYPE_CD       AS ACTION_TYPE_CD,                
                 BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,              
                 RLSE_ENABLED_FL      AS RLSE_ENABLED_FL,               
                 OLD_WORK_TYPE_CD     AS OLD_WORK_TYPE_CD,              
                 SO_SEQ_NO            AS SO_INST_SEQ_NO                 
              FROM #CSR04476_R4                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C4 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          METER_NO             AS METER_NO,                              
MFA-TR*          RATE_PLAN            AS RATE_PLAN,                             
MFA-TR*          SUPPLIES             AS SUPPLIES,                              
MFA-TR*          METER_LOC            AS METER_LOC,                             
MFA-TR*          METER_STATUS         AS METER_STATUS,                          
MFA-TR*          METER_STATUS_REASON  AS METER_STATUS_REASON,                   
MFA-TR*          WORK_TYPE_CD         AS WORK_TYPE_CD,                          
MFA-TR*          METER_READ_INST      AS METER_READ_INST,                       
MFA-TR*          METER_IND            AS METER_IND,                             
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          MTR_REF_NO           AS MTR_REF_NO,                            
MFA-TR*          CODE_REV_CLASS       AS CODE_REV_CLASS,                        
MFA-TR*          RLSE_REQUIRED        AS RLSE_REQUIRED,                         
MFA-TR*          RLSE_NO              AS RLSE_NO,                               
MFA-TR*          RLSE_MSG             AS RLSE_MSG,                              
MFA-TR*          RLSE_ADDL_MSG        AS RLSE_ADDL_MSG,                         
MFA-TR*          RLSE_PHONE           AS RLSE_PHONE,                            
MFA-TR*          RLSE_ALT_PHONE       AS RLSE_ALT_PHONE,                        
MFA-TR*          RLSE_REV_DIST        AS RLSE_REV_DIST,                         
MFA-TR*          BUS_RULE_ID          AS BUS_RULE_ID,                           
MFA-TR*          ACTION_TYPE_CD       AS ACTION_TYPE_CD,                        
MFA-TR*          BUS_RULE_XREF_ID     AS BUS_RULE_XREF_ID,                      
MFA-TR*          RLSE_ENABLED_FL      AS RLSE_ENABLED_FL,                       
MFA-TR*          OLD_WORK_TYPE_CD     AS OLD_WORK_TYPE_CD,                      
MFA-TR*          SO_SEQ_NO            AS SO_INST_SEQ_NO                         
MFA-TR*       FROM SESSION.CSR04476_R4                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N4 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-4     AS RETURN_CODE,              
                      :S-CODE-UTIL-TYPE-4  AS CODE_UTIL_TYPE,           
                      :S-METER-NO-4        AS METER_NO,                 
                      :S-RATE-PLAN-4       AS RATE_PLAN,                
                      :S-SUPPLIES          AS SUPPLIES,                 
                      :S-METER-LOC         AS METER_LOC,                
                      :S-METER-STATUS      AS METER_STATUS,             
                      :S-METER-STATUS-REASON AS METER_STATUS_REASON,    
                      :S-WORK-TYPE-CD-4    AS WORK_TYPE_CD,             
                      :S-METER-READ-INST   AS METER_READ_INST,          
                      :S-METER-IND         AS METER_IND,                
                      :S-IC-NO-4           AS IC_NO,                    
                      :S-MTR-REF-NO-4      AS MTR_REF_NO,               
                      :S-CODE-REV-CLASS-4  AS CODE_REV_CLASS,           
                      :S-RLSE-REQUIRED     AS RLSE_REQUIRED,            
                      :S-RLSE-NO           AS RLSE_NO,                  
                      :S-RLSE-MSG          AS RLSE_MSG,                 
                      :S-RLSE-ADDL-MSG     AS RLSE_ADDL_MSG,            
                      :S-RLSE-PHONE        AS RLSE_PHONE,               
                      :S-RLSE-ALT-PHONE    AS RLSE_ALT_PHONE,           
                      :S-RLSE-REV-DIST     AS RLSE_REV_DIST,            
                      :S-BUS-RULE-ID-4     AS BUS_RULE_ID,              
                      :S-ACTION-TYPE-CD-4  AS ACTION_TYPE_CD,           
                      :S-BUS-RULE-XREF-ID-4 AS BUS_RULE_XREF_ID,        
                      :S-RLSE-ENABLED-FL    AS RLSE_ENABLED_FL,         
                      :S-OLD-WORK-TYPE-CD-4 AS OLD_WORK_TYPE_CD,        
                      :S-SO-SEQ-NO-4        AS SO_INST_SEQ_NO           
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N4 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-4     AS RETURN_CODE,                      
MFA-TR*               :S-CODE-UTIL-TYPE-4  AS CODE_UTIL_TYPE,                   
MFA-TR*               :S-METER-NO-4        AS METER_NO,                         
MFA-TR*               :S-RATE-PLAN-4       AS RATE_PLAN,                        
MFA-TR*               :S-SUPPLIES          AS SUPPLIES,                         
MFA-TR*               :S-METER-LOC         AS METER_LOC,                        
MFA-TR*               :S-METER-STATUS      AS METER_STATUS,                     
MFA-TR*               :S-METER-STATUS-REASON AS METER_STATUS_REASON,            
MFA-TR*               :S-WORK-TYPE-CD-4    AS WORK_TYPE_CD,                     
MFA-TR*               :S-METER-READ-INST   AS METER_READ_INST,                  
MFA-TR*               :S-METER-IND         AS METER_IND,                        
MFA-TR*               :S-IC-NO-4           AS IC_NO,                            
MFA-TR*               :S-MTR-REF-NO-4      AS MTR_REF_NO,                       
MFA-TR*               :S-CODE-REV-CLASS-4  AS CODE_REV_CLASS,                   
MFA-TR*               :S-RLSE-REQUIRED     AS RLSE_REQUIRED,                    
MFA-TR*               :S-RLSE-NO           AS RLSE_NO,                          
MFA-TR*               :S-RLSE-MSG          AS RLSE_MSG,                         
MFA-TR*               :S-RLSE-ADDL-MSG     AS RLSE_ADDL_MSG,                    
MFA-TR*               :S-RLSE-PHONE        AS RLSE_PHONE,                       
MFA-TR*               :S-RLSE-ALT-PHONE    AS RLSE_ALT_PHONE,                   
MFA-TR*               :S-RLSE-REV-DIST     AS RLSE_REV_DIST,                    
MFA-TR*               :S-BUS-RULE-ID-4     AS BUS_RULE_ID,                      
MFA-TR*               :S-ACTION-TYPE-CD-4  AS ACTION_TYPE_CD,                   
MFA-TR*               :S-BUS-RULE-XREF-ID-4 AS BUS_RULE_XREF_ID,                
MFA-TR*               :S-RLSE-ENABLED-FL    AS RLSE_ENABLED_FL,                 
MFA-TR*               :S-OLD-WORK-TYPE-CD-4 AS OLD_WORK_TYPE_CD,                
MFA-TR*               :S-SO-SEQ-NO-4        AS SO_INST_SEQ_NO                   
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C5 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 SERV_ORDER_NO        AS SERV_ORDER_NO,                 
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 WORK_TYPE_CD         AS WORK_TYPE_CD,                  
                 IC_NO                AS IC_NO,                         
                 METER_NO             AS METER_NO,                      
                 MTR_REF_NO           AS MTR_REF_NO                     
              FROM #CSR04476_R5                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C5 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          SERV_ORDER_NO        AS SERV_ORDER_NO,                         
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          WORK_TYPE_CD         AS WORK_TYPE_CD,                          
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          METER_NO             AS METER_NO,                              
MFA-TR*          MTR_REF_NO           AS MTR_REF_NO                             
MFA-TR*       FROM SESSION.CSR04476_R5                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N5 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-5     AS RETURN_CODE,              
                      :S-SERV-ORDER-NO-5   AS SERV_ORDER_NO,            
                      :S-CODE-UTIL-TYPE-5  AS CODE_UTIL_TYPE,           
                      :S-WORK-TYPE-CD-5    AS WORK_TYPE_CD,             
                      :S-IC-NO-5           AS IC_NO,                    
                      :S-METER-NO-5        AS METER_NO,                 
                      :S-MTR-REF-NO-5      AS MTR_REF_NO                
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N5 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-5     AS RETURN_CODE,                      
MFA-TR*               :S-SERV-ORDER-NO-5   AS SERV_ORDER_NO,                    
MFA-TR*               :S-CODE-UTIL-TYPE-5  AS CODE_UTIL_TYPE,                   
MFA-TR*               :S-WORK-TYPE-CD-5    AS WORK_TYPE_CD,                     
MFA-TR*               :S-IC-NO-5           AS IC_NO,                            
MFA-TR*               :S-METER-NO-5        AS METER_NO,                         
MFA-TR*               :S-MTR-REF-NO-5      AS MTR_REF_NO                        
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C6 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CONTACT_TYPE         AS CONTACT_TYPE,                  
                 NAME_TYPE            AS NAME_TYPE,                     
                 MATRIX_NAME          AS MATRIX_NAME                    
              FROM #CSR04476_R6                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C6 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CONTACT_TYPE         AS CONTACT_TYPE,                          
MFA-TR*          NAME_TYPE            AS NAME_TYPE,                             
MFA-TR*          MATRIX_NAME          AS MATRIX_NAME                            
MFA-TR*       FROM SESSION.CSR04476_R6                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N6 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-6     AS RETURN_CODE,              
                      :S-CONTACT-TYPE      AS CONTACT_TYPE,             
                      :S-NAME-TYPE         AS NAME_TYPE,                
                      :S-MATRIX-NAME       AS MATRIX_NAME               
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N6 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-6     AS RETURN_CODE,                      
MFA-TR*               :S-CONTACT-TYPE      AS CONTACT_TYPE,                     
MFA-TR*               :S-NAME-TYPE         AS NAME_TYPE,                        
MFA-TR*               :S-MATRIX-NAME       AS MATRIX_NAME                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C7 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CALENDAR_DT          AS CALENDAR_DT,                   
                 GOOD_DAY_FL          AS GOOD_DAY_FL                    
              FROM #CSR04476_R7                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C7 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CALENDAR_DT          AS CALENDAR_DT,                           
MFA-TR*          GOOD_DAY_FL          AS GOOD_DAY_FL                            
MFA-TR*       FROM SESSION.CSR04476_R7                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N7 CURSOR  FOR                         
               SELECT :S-RETURN-CODE-7     AS RETURN_CODE,              
                      :S-CALENDAR-DT       AS CALENDAR_DT,              
                      :S-GOOD-DAY-FL       AS GOOD_DAY_FL               
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N7 CURSOR WITH RETURN FOR                                 
MFA-TR*        SELECT :S-RETURN-CODE-7     AS RETURN_CODE,                      
MFA-TR*               :S-CALENDAR-DT       AS CALENDAR_DT,                      
MFA-TR*               :S-GOOD-DAY-FL       AS GOOD_DAY_FL                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C8 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE           AS RETURN_CODE,                  
                 RATE_PLAN_NO          AS RATE_PLAN_NO,                 
                 RATE_ITEM_CODE        AS RATE_ITEM_CODE,               
                 CODE_PLAN_STATUS      AS CODE_PLAN_STATUS,             
                 CODE_STATUS_REASON    AS CODE_STATUS_REASON,           
                 MONTHLY_AMOUNT        AS MONTHLY_AMOUNT,               
                 NO_UNITS              AS NO_UNITS,                     
                 SUBDIVISION_FL        AS SUBDIVISION_FL,               
                 IC_NO                 AS IC_NO,                        
                 RATE_PLAN_DESC        AS RATE_PLAN_DESC,               
                 SERVICE_TYPE          AS SERVICE_TYPE,                 
                 DIST_NO               AS DIST_NO,                      
                 POLE_NO               AS POLE_NO                       
              FROM #CSR04476_R8                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C8 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE           AS RETURN_CODE,                          
MFA-TR*          RATE_PLAN_NO          AS RATE_PLAN_NO,                         
MFA-TR*          RATE_ITEM_CODE        AS RATE_ITEM_CODE,                       
MFA-TR*          CODE_PLAN_STATUS      AS CODE_PLAN_STATUS,                     
MFA-TR*          CODE_STATUS_REASON    AS CODE_STATUS_REASON,                   
MFA-TR*          MONTHLY_AMOUNT        AS MONTHLY_AMOUNT,                       
MFA-TR*          NO_UNITS              AS NO_UNITS,                             
MFA-TR*          SUBDIVISION_FL        AS SUBDIVISION_FL,                       
MFA-TR*          IC_NO                 AS IC_NO,                                
MFA-TR*          RATE_PLAN_DESC        AS RATE_PLAN_DESC,                       
MFA-TR*          SERVICE_TYPE          AS SERVICE_TYPE,                         
MFA-TR*          DIST_NO               AS DIST_NO,                              
MFA-TR*          POLE_NO               AS POLE_NO                               
MFA-TR*       FROM SESSION.CSR04476_R8                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N8 CURSOR  FOR                         
                 SELECT :S-RETURN-CODE-8     AS RETURN_CODE,            
                        :S-RATE-PLAN-8       AS RATE_PLAN_NO,           
                        :S-RATE-ITEM-CODE    AS RATE_ITEM_CODE,         
                        :S-CODE-PLAN-STATUS  AS CODE_PLAN_STATUS,       
                        :S-CODE-STATUS-REASON AS CODE_STATUS_REASON,    
                        :S-MONTHLY-AMOUNT    AS MONTHLY_AMOUNT,         
                        :S-NO-UNITS          AS NO_UNITS,               
                        :S-SUBDIVISION-FL    AS SUBDIVISION_FL,         
                        :S-IC-NO-8           AS IC_NO,                  
                        :S-RATE-PLAN-DESC-8  AS RATE_PLAN_DESC,         
                        :S-SERVICE-TYPE      AS SERVICE_TYPE,           
                        :S-DIST-NO           AS DIST_NO,                
                        :S-POLE-NO           AS POLE_NO                 
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N8 CURSOR WITH RETURN FOR                                 
MFA-TR*          SELECT :S-RETURN-CODE-8     AS RETURN_CODE,                    
MFA-TR*                 :S-RATE-PLAN-8       AS RATE_PLAN_NO,                   
MFA-TR*                 :S-RATE-ITEM-CODE    AS RATE_ITEM_CODE,                 
MFA-TR*                 :S-CODE-PLAN-STATUS  AS CODE_PLAN_STATUS,               
MFA-TR*                 :S-CODE-STATUS-REASON AS CODE_STATUS_REASON,            
MFA-TR*                 :S-MONTHLY-AMOUNT    AS MONTHLY_AMOUNT,                 
MFA-TR*                 :S-NO-UNITS          AS NO_UNITS,                       
MFA-TR*                 :S-SUBDIVISION-FL    AS SUBDIVISION_FL,                 
MFA-TR*                 :S-IC-NO-8           AS IC_NO,                          
MFA-TR*                 :S-RATE-PLAN-DESC-8  AS RATE_PLAN_DESC,                 
MFA-TR*                 :S-SERVICE-TYPE      AS SERVICE_TYPE,                   
MFA-TR*                 :S-DIST-NO           AS DIST_NO,                        
MFA-TR*                 :S-POLE-NO           AS POLE_NO                         
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C9 CURSOR  WITH ROWSET POSITIONING FOR 
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 EQUIPMENT_NO         AS EQUIPMENT_NO,                  
                 APPLIANCE_CD         AS APPLIANCE_CD,                  
                 CAUTION_TAG_IND      AS CAUTION_TAG_IND,               
                 CUT_IND              AS CUT_IND,                       
                 TAG_NO               AS TAG_NO,                        
                 CONDITION_CD         AS CONDITION_CD,                  
                 LOCATION_CD          AS LOCATION_CD,                   
                 APPL_COMMENTS        AS APPL_COMMENTS,                 
                 CAUTION_TAG_DT       AS CAUTION_TAG_DT,                
                 SOURCE_SYSTEM_CD     AS SOURCE_SYSTEM_CD,              
                 INSTALL_DT           AS INSTALL_DT,                    
                 SERIAL_NO            AS SERIAL_NO,                     
                 CAD_VERIFY_DT        AS CAD_VERIFY_DT,                 
                 APPLIANCE_DESC       AS APPLIANCE_DESC,                
                 SEASONAL_RT_FL       AS SEASONAL_RT_FL,                
                 CRAWL_FL             AS CRAWL_FL,                      
                 APPL_LONG_DESC       AS APPL_LONG_DESC,                
                 PRIMARY_FUEL_CD      AS PRIMARY_FUEL_CD,               
                 AVERAGE_BTU          AS AVERAGE_BTU,                   
                 LEAK_IND             AS LEAK_IND,                      
                 LIGHT_IND            AS LIGHT_IND,                     
                 REPAIR_IND           AS REPAIR_IND,                    
                 CUTOFF_IND           AS CUTOFF_IND,                    
                 REPLACE_APP_FL       AS REPLACE_APPL_FL                
              FROM #CSR04476_R9                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C9 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR         
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          EQUIPMENT_NO         AS EQUIPMENT_NO,                          
MFA-TR*          APPLIANCE_CD         AS APPLIANCE_CD,                          
MFA-TR*          CAUTION_TAG_IND      AS CAUTION_TAG_IND,                       
MFA-TR*          CUT_IND              AS CUT_IND,                               
MFA-TR*          TAG_NO               AS TAG_NO,                                
MFA-TR*          CONDITION_CD         AS CONDITION_CD,                          
MFA-TR*          LOCATION_CD          AS LOCATION_CD,                           
MFA-TR*          APPL_COMMENTS        AS APPL_COMMENTS,                         
MFA-TR*          CAUTION_TAG_DT       AS CAUTION_TAG_DT,                        
MFA-TR*          SOURCE_SYSTEM_CD     AS SOURCE_SYSTEM_CD,                      
MFA-TR*          INSTALL_DT           AS INSTALL_DT,                            
MFA-TR*          SERIAL_NO            AS SERIAL_NO,                             
MFA-TR*          CAD_VERIFY_DT        AS CAD_VERIFY_DT,                         
MFA-TR*          APPLIANCE_DESC       AS APPLIANCE_DESC,                        
MFA-TR*          SEASONAL_RT_FL       AS SEASONAL_RT_FL,                        
MFA-TR*          CRAWL_FL             AS CRAWL_FL,                              
MFA-TR*          APPL_LONG_DESC       AS APPL_LONG_DESC,                        
MFA-TR*          PRIMARY_FUEL_CD      AS PRIMARY_FUEL_CD,                       
MFA-TR*          AVERAGE_BTU          AS AVERAGE_BTU,                           
MFA-TR*          LEAK_IND             AS LEAK_IND,                              
MFA-TR*          LIGHT_IND            AS LIGHT_IND,                             
MFA-TR*          REPAIR_IND           AS REPAIR_IND,                            
MFA-TR*          CUTOFF_IND           AS CUTOFF_IND,                            
MFA-TR*          REPLACE_APP_FL       AS REPLACE_APPL_FL                        
MFA-TR*       FROM SESSION.CSR04476_R9                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N9 CURSOR  FOR                         
                 SELECT :S-RETURN-CODE-9     AS RETURN_CODE,            
                        :S-EQUIPMENT-NO      AS EQUIPMENT_NO,           
                        :S-APPLIANCE-CD      AS APPLIANCE_CD,           
                        :S-CAUTION-TAG-IND   AS CAUTION_TAG_IND,        
                        :S-CUT-IND           AS CUT_IND,                
                        :S-TAG-NO            AS TAG_NO,                 
                        :S-CONDITION-CD      AS CONDITION_CD,           
                        :S-LOCATION-CD       AS LOCATION_CD,            
                        :S-APPL-COMMENTS     AS APPL_COMMENTS,          
                        :S-CAUTION-TAG-DT    AS CAUTION_TAG_DT,         
                        :S-SOURCE-SYSTEM-CD  AS SOURCE_SYSTEM_CD,       
                        :S-INSTALL-DT        AS INSTALL_DT,             
                        :S-SERIAL-NO         AS SERIAL_NO,              
                        :S-CAD-VERIFY-DT     AS CAD_VERIFY_DT,          
                        :S-APPLIANCE-DESC    AS APPLIANCE_DESC,         
                        :S-SEASONAL-RT-FL    AS SEASONAL_RT_FL,         
                        :S-CRAWL-FL          AS CRAWL_FL,               
                        :S-APPL-LONG-DESC    AS APPL_LONG_DESC,         
                        :S-PRIMARY-FUEL-CD   AS PRIMARY_FUEL_CD,        
                        :S-AVERAGE-BTU       AS AVERAGE_BTU,            
                        :S-LEAK-IND          AS LEAK_IND,               
                        :S-LIGHT-IND         AS LIGHT_IND,              
                        :S-REPAIR-IND        AS REPAIR_IND,             
                        :S-CUTOFF-IND        AS CUTOFF_IND,             
                        :S-REPLACE-APP-FL    AS REPLACE_APP_FL          
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N9 CURSOR WITH RETURN FOR                                 
MFA-TR*          SELECT :S-RETURN-CODE-9     AS RETURN_CODE,                    
MFA-TR*                 :S-EQUIPMENT-NO      AS EQUIPMENT_NO,                   
MFA-TR*                 :S-APPLIANCE-CD      AS APPLIANCE_CD,                   
MFA-TR*                 :S-CAUTION-TAG-IND   AS CAUTION_TAG_IND,                
MFA-TR*                 :S-CUT-IND           AS CUT_IND,                        
MFA-TR*                 :S-TAG-NO            AS TAG_NO,                         
MFA-TR*                 :S-CONDITION-CD      AS CONDITION_CD,                   
MFA-TR*                 :S-LOCATION-CD       AS LOCATION_CD,                    
MFA-TR*                 :S-APPL-COMMENTS     AS APPL_COMMENTS,                  
MFA-TR*                 :S-CAUTION-TAG-DT    AS CAUTION_TAG_DT,                 
MFA-TR*                 :S-SOURCE-SYSTEM-CD  AS SOURCE_SYSTEM_CD,               
MFA-TR*                 :S-INSTALL-DT        AS INSTALL_DT,                     
MFA-TR*                 :S-SERIAL-NO         AS SERIAL_NO,                      
MFA-TR*                 :S-CAD-VERIFY-DT     AS CAD_VERIFY_DT,                  
MFA-TR*                 :S-APPLIANCE-DESC    AS APPLIANCE_DESC,                 
MFA-TR*                 :S-SEASONAL-RT-FL    AS SEASONAL_RT_FL,                 
MFA-TR*                 :S-CRAWL-FL          AS CRAWL_FL,                       
MFA-TR*                 :S-APPL-LONG-DESC    AS APPL_LONG_DESC,                 
MFA-TR*                 :S-PRIMARY-FUEL-CD   AS PRIMARY_FUEL_CD,                
MFA-TR*                 :S-AVERAGE-BTU       AS AVERAGE_BTU,                    
MFA-TR*                 :S-LEAK-IND          AS LEAK_IND,                       
MFA-TR*                 :S-LIGHT-IND         AS LIGHT_IND,                      
MFA-TR*                 :S-REPAIR-IND        AS REPAIR_IND,                     
MFA-TR*                 :S-CUTOFF-IND        AS CUTOFF_IND,                     
MFA-TR*                 :S-REPLACE-APP-FL    AS REPLACE_APP_FL                  
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C10 CURSOR  WITH ROWSET POSITIONING FOR
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                
                 IC_NO                AS IC_NO,                         
                 RATE_PLAN_NO         AS RATE_PLAN_NO,                  
                 CODE_REV_CLASS       AS CODE_REV_CLASS,                
                 RATE_PLAN_DESC       AS RATE_PLAN_DESC,                
                 TOU_FL               AS TOU_FL,                        
                 FIXED_FACTOR_FL      AS FIXED_FACTOR_FL,               
                 BILL_CONTRACT_FL     AS BILL_CONTRACT_FL,              
                 INTERRUPT_FL         AS INTERRUPT_FL                   
              FROM #CSR04476_R10                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C10 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CODE_UTIL_TYPE       AS CODE_UTIL_TYPE,                        
MFA-TR*          IC_NO                AS IC_NO,                                 
MFA-TR*          RATE_PLAN_NO         AS RATE_PLAN_NO,                          
MFA-TR*          CODE_REV_CLASS       AS CODE_REV_CLASS,                        
MFA-TR*          RATE_PLAN_DESC       AS RATE_PLAN_DESC,                        
MFA-TR*          TOU_FL               AS TOU_FL,                                
MFA-TR*          FIXED_FACTOR_FL      AS FIXED_FACTOR_FL,                       
MFA-TR*          BILL_CONTRACT_FL     AS BILL_CONTRACT_FL,                      
MFA-TR*          INTERRUPT_FL         AS INTERRUPT_FL                           
MFA-TR*       FROM SESSION.CSR04476_R10                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N10 CURSOR  FOR                        
                 SELECT :S-RETURN-CODE-10    AS RETURN_CODE,            
                        :S-CODE-UTIL-TYPE-10 AS CODE_UTIL_TYPE,         
                        :S-IC-NO-10          AS IC_NO,                  
                        :S-RATE-PLAN-10      AS RATE_PLAN_NO,           
                        :S-CODE-REV-CLASS-10 AS CODE_REV_CLASS,         
                        :S-RATE-PLAN-DESC-10 AS RATE_PLAN_DESC,         
                        :S-TOU-FL            AS TOU_FL,                 
                        :S-FIXED-FACTOR-FL   AS FIXED_FACTOR_FL,        
                        :S-BILL-CONTRACT-FL  AS BILL_CONTRACT_FL,       
                        :S-INTERRUPT-FL      AS INTERRUPT_FL            
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N10 CURSOR WITH RETURN FOR                                
MFA-TR*          SELECT :S-RETURN-CODE-10    AS RETURN_CODE,                    
MFA-TR*                 :S-CODE-UTIL-TYPE-10 AS CODE_UTIL_TYPE,                 
MFA-TR*                 :S-IC-NO-10          AS IC_NO,                          
MFA-TR*                 :S-RATE-PLAN-10      AS RATE_PLAN_NO,                   
MFA-TR*                 :S-CODE-REV-CLASS-10 AS CODE_REV_CLASS,                 
MFA-TR*                 :S-RATE-PLAN-DESC-10 AS RATE_PLAN_DESC,                 
MFA-TR*                 :S-TOU-FL            AS TOU_FL,                         
MFA-TR*                 :S-FIXED-FACTOR-FL   AS FIXED_FACTOR_FL,                
MFA-TR*                 :S-BILL-CONTRACT-FL  AS BILL_CONTRACT_FL,               
MFA-TR*                 :S-INTERRUPT-FL      AS INTERRUPT_FL                    
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C11 CURSOR  WITH ROWSET POSITIONING FOR
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 ACCOUNT_NO           AS ACCOUNT_NO,                    
                 CODE_ACCT_STAT       AS CODE_ACCT_STAT,                
                 ADDRESS_LINE         AS ADDRESS_LINE                   
              FROM #CSR04476_R11                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C11 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          ACCOUNT_NO           AS ACCOUNT_NO,                            
MFA-TR*          CODE_ACCT_STAT       AS CODE_ACCT_STAT,                        
MFA-TR*          ADDRESS_LINE         AS ADDRESS_LINE                           
MFA-TR*       FROM SESSION.CSR04476_R11                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N11 CURSOR  FOR                        
                 SELECT :S-RETURN-CODE-11    AS RETURN_CODE,            
                        :S-ACCOUNT-NO-11     AS ACCOUNT_NO,             
                        :S-CODE-ACCT-STAT-11 AS CODE_ACCT_STAT,         
                        :S-ADDRESS-LINE      AS ADDRESS_LINE            
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N11 CURSOR WITH RETURN FOR                                
MFA-TR*          SELECT :S-RETURN-CODE-11    AS RETURN_CODE,                    
MFA-TR*                 :S-ACCOUNT-NO-11     AS ACCOUNT_NO,                     
MFA-TR*                 :S-CODE-ACCT-STAT-11 AS CODE_ACCT_STAT,                 
MFA-TR*                 :S-ADDRESS-LINE      AS ADDRESS_LINE                    
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
MAINTN     EXEC SQL                                                     
MAINTN        DECLARE C12 CURSOR  WITH ROWSET POSITIONING FOR
               SELECT :S-RETURN-CODE-12 AS RETURN_CODE,                 
                      :S-SERV-ORDER-NO-12      AS SERV_ORDER_NO,        
                      :S-ORDER-TYPE-CD-12      AS ORDER_TYPE_CD,        
                      :S-ORDER-REASON-12       AS ORDER_REASON,         
                      :S-STATUS-TX-12          AS STATUS_TX,            
                      :S-ORDER-STATE-CD-12     AS ORDER_STATE_CD,       
                      :S-ORDER-PLACED-BY-12    AS ORDER_PLACED_BY,      
                      :S-PHONE-NO-12           AS PHONE_NO,             
                      :S-PHONE-NO-EXT-12       AS PHONE_NO_EXT,         
                      :S-WANTED-BY-DATE-12 AS WANTED_BY_DATE,           
                      :S-ASSIGNED-DATE-12      AS ASSIGNED_DATE,        
                      :S-CALL-BEFORE-MINUTS-12 AS CALL_BEFORE_MINS,     
                      :S-WORK-AREA-ID-12       AS WORK_AREA_ID,         
                      :S-BREAKERS-OFF-IND-12   AS BREAKERS_OFF_IND,     
                      :S-INIT-BY-CNTRCT-IND-12 AS INIT_BY_CNTRCT_IND,   
                      :S-NOTIFY-CSR-IND-12     AS NOTIFY_CSR_IND,       
                      :S-NOTIFY-CUST-IND-12    AS NOTIFY_CUST_IND,      
                      :S-ORDER-PRIORITY-CD-12  AS ORDER_PRIORITY_CD,    
                      :S-STD-LABOR-CHRG-12     AS STD_LABOR_CHRG,       
                      :S-WORK-TYPE-CD-4-12     AS WORK_TYPE_CD,         
                      :S-BACK-DATED-IND-12     AS BACK_DATED_IND,       
                      :S-DEPOSIT-AMT-12        AS DEPOSIT_AMT,          
                      :S-ORDER-RECVED-BY-12    AS ORDER_RECVED_BY,      
                      :S-VERIFY-RATE-12        AS VERIFY_RATE,          
                      :S-PREMISE-NO-12         AS PREMISE_NO,           
                      :S-ACCOUNT-NO-12         AS ACCOUNT_NO,           
                      :S-ACCOUNT-NO-PRIOR-12   AS ACCOUNT_NO_PRIOR,     
                      :S-BEGIN-APPT-DATE-12    AS BEGIN_APPT_DATE,      
                      :S-SO-EST-LABOR-HR-12    AS SO_EST_LABOR_HR,      
                      :S-CUSTCHG-ORD-TYPE-FL-12 AS CUSTCHG_ORD_TYPE_FL, 
                      :S-AMOUNT-DISC-BAL-12    AS AMOUNT_DISC_BAL,      
                      :S-CURRENT-DATE-12       AS [CURRENT_DATE],         
                      :S-CODE-UTIL-TYPE-12-D   AS CODE_UTIL_TYPE,       
                      :S-PRICE-PER-SERV-12     AS PRICE_PER_SERV,       
                      :S-ACCOUNT-TYPE-DESC-12  AS ACCOUNT_TYPE_DESC,    
                      :S-ORDER-CHARGE-AMT-12   AS ORDER_CHARGE_AMT,     
                      :S-TOTAL-CHARGES-AMT-12  AS TOTAL_CHARGES_AMT,    
                      :S-CUST-CNT-ID-12        AS CUST_CNT_ID,          
                      :S-MTR-ACCESSIBLE-CD-12  AS MTR_ACCESSIBLE_CD,    
                      :S-MTR-ACCESSIBLE-DT-12  AS MTR_ACCESSIBLE_DT,    
                      :S-MTR-ACCESSIBLE-RSN-12 AS MTR_ACCESSIBLE_RSN,   
                      :S-SOURCE-SYSTEM-CD-12   AS SOURCE_SYSTEM,        
                      :S-ALT-PHONE-NO-12       AS ALT_PHONE_NO,         
                      :S-ALT-PHONE-NO-EXT-12   AS ALT_PHONE_EXT,        
                      :S-HOME-ALL-DAY-FL-12    AS HOME_ALL_DAY_FL,      
                      :S-BUSINESS-UNIT-12      AS BUSINESS_UNIT,        
                      :S-OPTIMIZE-ORDER-12     AS OPTIMIZE_ORDER,       
                      :S-END-APPT-DATE-12     AS END_APPT_DATE,         
                      :S-AM-PM-APPT-CD-12     AS AM_PM_APPT_CD,         
                      :S-MTR-TURNOFF-RSN-CD-12 AS MTR_TURNOFF_RSN_CD,   
                      :S-FUEL-CHNG-RSN-CD-12  AS FUEL_CHNG_RSN_CD,      
                      :S-FUEL-CHNG-TYPE-CD-12 AS FUEL_CHNG_TYPE_CD,     
                      :S-TURNOFF-COMMENTS-12  AS TURNOFF_COMMENTS,      
                      :S-OLD-ORDER-TYPE-CD-12 AS OLD_ORDER_TYPE_CD,     
                      :S-WORK-DISTRICT-12     AS WORK_DISTRICT,         
DT9528                :S-CODES-DATA-PRESENT-12 AS CODES_DATA_PRESENT,   
D10004                :S-TASK-STATUS-CD-12    AS TASK_STATUS_CD,        
DT9519                :S-CANCEL-REASON-CD-12  AS CANCEL_REASON_CD,      
D26359                :S-SO-MTR-ROW-EXISTS-12 AS SO_MTR_ROW_EXISTS      
                 FROM CIS.SYSDUMMY1                                  
MAINTN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C12 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*        SELECT :S-RETURN-CODE-12 AS RETURN_CODE,                         
MFA-TR*               :S-SERV-ORDER-NO-12      AS SERV_ORDER_NO,                
MFA-TR*               :S-ORDER-TYPE-CD-12      AS ORDER_TYPE_CD,                
MFA-TR*               :S-ORDER-REASON-12       AS ORDER_REASON,                 
MFA-TR*               :S-STATUS-TX-12          AS STATUS_TX,                    
MFA-TR*               :S-ORDER-STATE-CD-12     AS ORDER_STATE_CD,               
MFA-TR*               :S-ORDER-PLACED-BY-12    AS ORDER_PLACED_BY,              
MFA-TR*               :S-PHONE-NO-12           AS PHONE_NO,                     
MFA-TR*               :S-PHONE-NO-EXT-12       AS PHONE_NO_EXT,                 
MFA-TR*               :S-WANTED-BY-DATE-12 AS WANTED_BY_DATE,                   
MFA-TR*               :S-ASSIGNED-DATE-12      AS ASSIGNED_DATE,                
MFA-TR*               :S-CALL-BEFORE-MINUTS-12 AS CALL_BEFORE_MINS,             
MFA-TR*               :S-WORK-AREA-ID-12       AS WORK_AREA_ID,                 
MFA-TR*               :S-BREAKERS-OFF-IND-12   AS BREAKERS_OFF_IND,             
MFA-TR*               :S-INIT-BY-CNTRCT-IND-12 AS INIT_BY_CNTRCT_IND,           
MFA-TR*               :S-NOTIFY-CSR-IND-12     AS NOTIFY_CSR_IND,               
MFA-TR*               :S-NOTIFY-CUST-IND-12    AS NOTIFY_CUST_IND,              
MFA-TR*               :S-ORDER-PRIORITY-CD-12  AS ORDER_PRIORITY_CD,            
MFA-TR*               :S-STD-LABOR-CHRG-12     AS STD_LABOR_CHRG,               
MFA-TR*               :S-WORK-TYPE-CD-4-12     AS WORK_TYPE_CD,                 
MFA-TR*               :S-BACK-DATED-IND-12     AS BACK_DATED_IND,               
MFA-TR*               :S-DEPOSIT-AMT-12        AS DEPOSIT_AMT,                  
MFA-TR*               :S-ORDER-RECVED-BY-12    AS ORDER_RECVED_BY,              
MFA-TR*               :S-VERIFY-RATE-12        AS VERIFY_RATE,                  
MFA-TR*               :S-PREMISE-NO-12         AS PREMISE_NO,                   
MFA-TR*               :S-ACCOUNT-NO-12         AS ACCOUNT_NO,                   
MFA-TR*               :S-ACCOUNT-NO-PRIOR-12   AS ACCOUNT_NO_PRIOR,             
MFA-TR*               :S-BEGIN-APPT-DATE-12    AS BEGIN_APPT_DATE,              
MFA-TR*               :S-SO-EST-LABOR-HR-12    AS SO_EST_LABOR_HR,              
MFA-TR*               :S-CUSTCHG-ORD-TYPE-FL-12 AS CUSTCHG_ORD_TYPE_FL,         
MFA-TR*               :S-AMOUNT-DISC-BAL-12    AS AMOUNT_DISC_BAL,              
MFA-TR*               :S-CURRENT-DATE-12       AS CURRENT_DATE,                 
MFA-TR*               :S-CODE-UTIL-TYPE-12-D   AS CODE_UTIL_TYPE,               
MFA-TR*               :S-PRICE-PER-SERV-12     AS PRICE_PER_SERV,               
MFA-TR*               :S-ACCOUNT-TYPE-DESC-12  AS ACCOUNT_TYPE_DESC,            
MFA-TR*               :S-ORDER-CHARGE-AMT-12   AS ORDER_CHARGE_AMT,             
MFA-TR*               :S-TOTAL-CHARGES-AMT-12  AS TOTAL_CHARGES_AMT,            
MFA-TR*               :S-CUST-CNT-ID-12        AS CUST_CNT_ID,                  
MFA-TR*               :S-MTR-ACCESSIBLE-CD-12  AS MTR_ACCESSIBLE_CD,            
MFA-TR*               :S-MTR-ACCESSIBLE-DT-12  AS MTR_ACCESSIBLE_DT,            
MFA-TR*               :S-MTR-ACCESSIBLE-RSN-12 AS MTR_ACCESSIBLE_RSN,           
MFA-TR*               :S-SOURCE-SYSTEM-CD-12   AS SOURCE_SYSTEM,                
MFA-TR*               :S-ALT-PHONE-NO-12       AS ALT_PHONE_NO,                 
MFA-TR*               :S-ALT-PHONE-NO-EXT-12   AS ALT_PHONE_EXT,                
MFA-TR*               :S-HOME-ALL-DAY-FL-12    AS HOME_ALL_DAY_FL,              
MFA-TR*               :S-BUSINESS-UNIT-12      AS BUSINESS_UNIT,                
MFA-TR*               :S-OPTIMIZE-ORDER-12     AS OPTIMIZE_ORDER,               
MFA-TR*               :S-END-APPT-DATE-12     AS END_APPT_DATE,                 
MFA-TR*               :S-AM-PM-APPT-CD-12     AS AM_PM_APPT_CD,                 
MFA-TR*               :S-MTR-TURNOFF-RSN-CD-12 AS MTR_TURNOFF_RSN_CD,           
MFA-TR*               :S-FUEL-CHNG-RSN-CD-12  AS FUEL_CHNG_RSN_CD,              
MFA-TR*               :S-FUEL-CHNG-TYPE-CD-12 AS FUEL_CHNG_TYPE_CD,             
MFA-TR*               :S-TURNOFF-COMMENTS-12  AS TURNOFF_COMMENTS,              
MFA-TR*               :S-OLD-ORDER-TYPE-CD-12 AS OLD_ORDER_TYPE_CD,             
MFA-TR*               :S-WORK-DISTRICT-12     AS WORK_DISTRICT,                 
MFA-TR*               :S-CODES-DATA-PRESENT-12 AS CODES_DATA_PRESENT,           
MFA-TR*               :S-TASK-STATUS-CD-12    AS TASK_STATUS_CD,                
MFA-TR*               :S-CANCEL-REASON-CD-12  AS CANCEL_REASON_CD,              
MFA-TR*               :S-SO-MTR-ROW-EXISTS-12 AS SO_MTR_ROW_EXISTS              
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MAINTN     EXEC SQL                                                     
               DECLARE C13 CURSOR                            
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE              AS RETURN_CODE          
                      ,SERV_ORDER_NO            AS SERV_ORDER_NO        
                      ,LTRIM(RTRIM(REMARK_TYPE_CD))    AS REMARK_TYPE_CD       
                      ,LTRIM(RTRIM(REMARK_TX))         AS REMARK_TEXT          
                 FROM #CSR04476_R13                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C13 CURSOR WITH RETURN                                   
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE              AS RETURN_CODE                  
MFA-TR*               ,SERV_ORDER_NO            AS SERV_ORDER_NO                
MFA-TR*               ,STRIP(REMARK_TYPE_CD)    AS REMARK_TYPE_CD               
MFA-TR*               ,STRIP(REMARK_TX)         AS REMARK_TEXT                  
MFA-TR*          FROM SESSION.CSR04476_R13                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N13 CURSOR  FOR                        
                SELECT :S-RETURN-CODE-13          AS RETURN_CODE        
                      ,:S-SERV-ORDER-NO-13        AS SERV_ORDER_NO      
                      ,:S-REMARK-TYPE-CD-13      AS REMARK_TYPE_CD      
                      ,:S-REMARK-TX-13           AS REMARK_TEXT         
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N13 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE-13          AS RETURN_CODE                
MFA-TR*               ,:S-SERV-ORDER-NO-13        AS SERV_ORDER_NO              
MFA-TR*               ,:S-REMARK-TYPE-CD-13      AS REMARK_TYPE_CD              
MFA-TR*               ,:S-REMARK-TX-13           AS REMARK_TEXT                 
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C14 CURSOR                            
                                      WITH ROWSET POSITIONING FOR       
               SELECT :S-RETURN-CODE-14       AS RETURN_CODE            
                     ,:S-TO-ACCT-NO-14        AS TO_ACCT_NO             
                     ,:S-ROOMMATE-XFER-IND-14 AS ROOMMATE_XFER_IND      
                     ,:S-EPP-XFER-IND-14      AS EPP_XFER_IND           
                     ,:S-DEPOSIT-XFER-IND-14  AS DEPOSIT_XFER_IND       
                     ,:S-OTHER-AR-XFER-IND-14 AS OTHER_AR_XFER_IND      
                     ,:S-PROJ-SHR-XFER-IND-14 AS PROJ_SHR_XFER_IND      
                     ,:S-WRITE-OFF-XFER-IND-14 AS WRITE_OFF_XFER_IND    
                     ,:S-IN-LIEU-XFER-IND-14  AS IN_LIEU_XFER_IND       
                     ,:S-WHT-CROSS-XFER-IND-14 AS WHT_CROSS_XFER_IND    
                     ,:S-COAPPL-XFER-IND-14   AS COAPPL_XFER_IND        
                     ,:S-MED-CERT-XFER-IND-14 AS MED_CERT_XFER_IND      
                     ,:S-NAME-FORMAT-14       AS NAME_FORMAT            
                     ,:S-FIRST-NAME-14        AS FIRST_NAME             
                     ,:S-MIDDLE-NAME-14       AS MIDDLE_NAME            
                     ,:S-LAST-NAME-14         AS LAST_NAME              
                     ,:S-FULL-NAME-14         AS FULL_NAME              
                     ,:S-HOUSE-NO-14          AS HOUSE_NO               
                     ,:S-ADDR-PREFIX-1-14     AS ADDR_PREFIX_1          
                     ,:S-ADDR-PREFIX-2-14     AS ADDR_PREFIX_2          
                     ,:S-STREET-NAME-14       AS STREET_NAME            
                     ,:S-STREET-LOCATION-1-14 AS STREET_LOCATION_1      
                     ,:S-STREET-LOCATION-2-14 AS STREET_LOCATION_2      
                     ,:S-STREET-SUFFIX-14     AS STREET_SUFFIX          
                     ,:S-CUSTOMER-FROM-14     AS CUSTOMER_FROM          
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C14 CURSOR WITH RETURN                                   
MFA-TR*                               WITH ROWSET POSITIONING FOR               
MFA-TR*        SELECT :S-RETURN-CODE-14       AS RETURN_CODE                    
MFA-TR*              ,:S-TO-ACCT-NO-14        AS TO_ACCT_NO                     
MFA-TR*              ,:S-ROOMMATE-XFER-IND-14 AS ROOMMATE_XFER_IND              
MFA-TR*              ,:S-EPP-XFER-IND-14      AS EPP_XFER_IND                   
MFA-TR*              ,:S-DEPOSIT-XFER-IND-14  AS DEPOSIT_XFER_IND               
MFA-TR*              ,:S-OTHER-AR-XFER-IND-14 AS OTHER_AR_XFER_IND              
MFA-TR*              ,:S-PROJ-SHR-XFER-IND-14 AS PROJ_SHR_XFER_IND              
MFA-TR*              ,:S-WRITE-OFF-XFER-IND-14 AS WRITE_OFF_XFER_IND            
MFA-TR*              ,:S-IN-LIEU-XFER-IND-14  AS IN_LIEU_XFER_IND               
MFA-TR*              ,:S-WHT-CROSS-XFER-IND-14 AS WHT_CROSS_XFER_IND            
MFA-TR*              ,:S-COAPPL-XFER-IND-14   AS COAPPL_XFER_IND                
MFA-TR*              ,:S-MED-CERT-XFER-IND-14 AS MED_CERT_XFER_IND              
MFA-TR*              ,:S-NAME-FORMAT-14       AS NAME_FORMAT                    
MFA-TR*              ,:S-FIRST-NAME-14        AS FIRST_NAME                     
MFA-TR*              ,:S-MIDDLE-NAME-14       AS MIDDLE_NAME                    
MFA-TR*              ,:S-LAST-NAME-14         AS LAST_NAME                      
MFA-TR*              ,:S-FULL-NAME-14         AS FULL_NAME                      
MFA-TR*              ,:S-HOUSE-NO-14          AS HOUSE_NO                       
MFA-TR*              ,:S-ADDR-PREFIX-1-14     AS ADDR_PREFIX_1                  
MFA-TR*              ,:S-ADDR-PREFIX-2-14     AS ADDR_PREFIX_2                  
MFA-TR*              ,:S-STREET-NAME-14       AS STREET_NAME                    
MFA-TR*              ,:S-STREET-LOCATION-1-14 AS STREET_LOCATION_1              
MFA-TR*              ,:S-STREET-LOCATION-2-14 AS STREET_LOCATION_2              
MFA-TR*              ,:S-STREET-SUFFIX-14     AS STREET_SUFFIX                  
MFA-TR*              ,:S-CUSTOMER-FROM-14     AS CUSTOMER_FROM                  
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C15 CURSOR                            
                                     WITH ROWSET POSITIONING FOR        
               SELECT :S-RETURN-CODE-15       AS RETURN_CODE            
                     ,:S-ACCOUNT-NO-PRIOR-15  AS ACCOUNT_NO_PRIOR       
                     ,:S-SERV-ORDER-NO-15     AS SERV_ORDER_NO          
                     ,:S-WANTED-BY-DATETIME-15 AS WANTED_BY_DATETIME    
                     ,:S-CREDIT-LETTER-IND-15 AS CREDIT_LETTER_IND      
                     ,:S-STREET-LOCATION-1-15 AS STREET_LOCATION_1      
                     ,:S-STREET-LOCATION-2-15 AS STREET_LOCATION_2      
                     ,:S-ADDR-ST-15           AS ADDR_ST                
                     ,:S-ADDR-ZIP-CODE-15     AS ADDR_ZIP_CODE          
                     ,:S-ADDR-PREFIX-1-15     AS ADDR_PREFIX_1          
                     ,:S-ADDR-PREFIX-2-15     AS ADDR_PREFIX_2          
                     ,:S-ADDR-SUFFIX-15       AS ADDR_SUFFIX            
                     ,:S-ADDRESS-OVERFLOW-15  AS ADDRESS_OVERFLOW       
                     ,:S-HOUSE-NO-15          AS HOUSE_NO               
                     ,:S-ADDRESS-FORMAT-15    AS ADDRESS_FORMAT         
                     ,:S-STREET-NAME-15       AS STREET_NAME            
                     ,:S-STREET-SUFFIX-15     AS STREET_SUFFIX          
                     ,:S-ZIP-CODE-15          AS ZIP_CODE               
                     ,:S-ZIP-CODE-PLUS-FOUR-15 AS ZIP_CODE_PLUS_FOUR    
                     ,:S-ZIP-CODE-TOKEN-15    AS ZIP_CODE_TOKEN         
                     ,:S-SEND-TO-LOCOFF-IND-15 AS SEND_TO_LOCOFF_IND    
                     ,:S-ADDR-COUNTRY-15      AS ADDR_COUNTRY           
                     ,:S-CARRIER-ROUTE-15     AS CARRIER_ROUTE          
                     ,:S-FINAL-BILL-CY-ST-15  AS FINAL_BILL_CY_ST       
                     ,:S-FINAL-BILL-OVFL-15   AS FINAL_BILL_OVFL        
                     ,:S-DEPOSIT-AMT-15       AS DEPOSIT_AMT            
                     ,:S-FBILL-ADDR-TYPE-15   AS FBILL_ADDR_TYPE        
                     ,:S-FBILL-ADDR-LINE-15   AS FBILL_ADDR_LINE        
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C15 CURSOR WITH RETURN                                   
MFA-TR*                              WITH ROWSET POSITIONING FOR                
MFA-TR*        SELECT :S-RETURN-CODE-15       AS RETURN_CODE                    
MFA-TR*              ,:S-ACCOUNT-NO-PRIOR-15  AS ACCOUNT_NO_PRIOR               
MFA-TR*              ,:S-SERV-ORDER-NO-15     AS SERV_ORDER_NO                  
MFA-TR*              ,:S-WANTED-BY-DATETIME-15 AS WANTED_BY_DATETIME            
MFA-TR*              ,:S-CREDIT-LETTER-IND-15 AS CREDIT_LETTER_IND              
MFA-TR*              ,:S-STREET-LOCATION-1-15 AS STREET_LOCATION_1              
MFA-TR*              ,:S-STREET-LOCATION-2-15 AS STREET_LOCATION_2              
MFA-TR*              ,:S-ADDR-ST-15           AS ADDR_ST                        
MFA-TR*              ,:S-ADDR-ZIP-CODE-15     AS ADDR_ZIP_CODE                  
MFA-TR*              ,:S-ADDR-PREFIX-1-15     AS ADDR_PREFIX_1                  
MFA-TR*              ,:S-ADDR-PREFIX-2-15     AS ADDR_PREFIX_2                  
MFA-TR*              ,:S-ADDR-SUFFIX-15       AS ADDR_SUFFIX                    
MFA-TR*              ,:S-ADDRESS-OVERFLOW-15  AS ADDRESS_OVERFLOW               
MFA-TR*              ,:S-HOUSE-NO-15          AS HOUSE_NO                       
MFA-TR*              ,:S-ADDRESS-FORMAT-15    AS ADDRESS_FORMAT                 
MFA-TR*              ,:S-STREET-NAME-15       AS STREET_NAME                    
MFA-TR*              ,:S-STREET-SUFFIX-15     AS STREET_SUFFIX                  
MFA-TR*              ,:S-ZIP-CODE-15          AS ZIP_CODE                       
MFA-TR*              ,:S-ZIP-CODE-PLUS-FOUR-15 AS ZIP_CODE_PLUS_FOUR            
MFA-TR*              ,:S-ZIP-CODE-TOKEN-15    AS ZIP_CODE_TOKEN                 
MFA-TR*              ,:S-SEND-TO-LOCOFF-IND-15 AS SEND_TO_LOCOFF_IND            
MFA-TR*              ,:S-ADDR-COUNTRY-15      AS ADDR_COUNTRY                   
MFA-TR*              ,:S-CARRIER-ROUTE-15     AS CARRIER_ROUTE                  
MFA-TR*              ,:S-FINAL-BILL-CY-ST-15  AS FINAL_BILL_CY_ST               
MFA-TR*              ,:S-FINAL-BILL-OVFL-15   AS FINAL_BILL_OVFL                
MFA-TR*              ,:S-DEPOSIT-AMT-15       AS DEPOSIT_AMT                    
MFA-TR*              ,:S-FBILL-ADDR-TYPE-15   AS FBILL_ADDR_TYPE                
MFA-TR*              ,:S-FBILL-ADDR-LINE-15   AS FBILL_ADDR_LINE                
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE C16 CURSOR                             
                                  WITH ROWSET POSITIONING FOR           
              SELECT                                                    
                 RETURN_CODE          AS RETURN_CODE,                   
                 CONTRACT_ID          AS CONTRACT_ID                    
              FROM #CSR04476_R16                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C16 CURSOR WITH RETURN                                    
MFA-TR*                           WITH ROWSET POSITIONING FOR                   
MFA-TR*       SELECT                                                            
MFA-TR*          RETURN_CODE          AS RETURN_CODE,                           
MFA-TR*          CONTRACT_ID          AS CONTRACT_ID                            
MFA-TR*       FROM SESSION.CSR04476_R16                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
              DECLARE N16 CURSOR  FOR                        
               SELECT :S-RETURN-CODE-16    AS RETURN_CODE,              
                      :S-CONTRACT-ID-16    AS CONTRACT_ID               
                 FROM CIS.SYSDUMMY1                                  
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE N16 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :S-RETURN-CODE-16    AS RETURN_CODE,                      
MFA-TR*               :S-CONTRACT-ID-16    AS CONTRACT_ID                       
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4477 CURSOR
MSQ001          FOR CALL CSR04477                                             
                  ( :ACCOUNT-NO-4477
                  , :OLD-CUSTOMER-NO-4477
                  , :PREMISE-NO-4477
                  , :NEW-CUSTOMER-NO-4477
                  , :ORDER-TYPE-CD-4477
                  , :PROCESS-4477
                  , :STEP-4477
                  , :USERID-4477
                  , :PROGRAM-ID-4477
                  , :CANCEL-REVERT-FL-4477
                  , :XFER-FL-4477
                  , :ORDER-TYPE-CHG-FL-4477
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_CUR_1 CURSOR
MSQ001          FOR CALL CSR04478                                             
                  ( :ACCOUNT-NO-4478
                  , :OLD-CUSTOMER-NO-4478
                  , :PREMISE-NO-4478
                  , :ORDER-TYPE-CD-4478
                  , :NEXT-BUS-DAY-4478
                  , :PROGRAM-ID-4478
                  , :NEW-CUSTOMER-NO-4478
                  , :XFER-FL-4478
                  , :XFER-FROM-ACCT-4478
                  , :REVERT-FL-4478
                  , :SERV-ORDER-NO-4478
                  , :CURRENT-HISTORY-FL-4478
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_CUR_2 CURSOR
MSQ001          FOR CALL CSR04479                                             
                  ( :ACCOUNT-NO-4479
                  , :PREMISE-NO-4479
                  , :PROCESS-4479
                  , :ASSIGNED-DATE-IN-4479
                  , :PROGRAM-ID-4479
                  , :ORDER-TYPE-CD-4479
                  , :SERV-ORDER-NO-4479
                  , :CURRENT-HISTORY-FL-4479
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE MSQ001_CUR_3 CURSOR
MSQ001          FOR CALL CSR04480                                             
                  ( :CODE-UTIL-TYPE-4480
                  , :WORK-TYPE-4480
                  , :METER-IND-4480
                  , :METER-STATUS-4480
                  , :ACCOUNT-NO-4480
                  , :PREMISE-NO-4480
                  , :ORDER-TYPE-CD-4480
                  , :ASSIGNED-DATE-4480
                  , :PROGRAM-ID-4480
                  , :APPLIANCE-LIT-4480
                  , :RELEASE-REQD-4480
                  , :FRO-FL-4480
                  , :CRAWL-APPL-FL-4480
                  , :SERV-ORDER-NO-4480
                  , :NEW-ORDER-STATE-CD-4480
                  , :WORK-AREA-ID-4480
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4012 CURSOR
MSQ001          FOR CALL CSR04012                                             
                  ( :COMPANY-NO-4012
                  , :REV-DISTRICT-CD-4012
                  , :CODE-UTIL-TYPE-4012
                  , :ORDER-TYPE-CD-4012
                  , :WORK-TYPE-CD-4012
                  , :RLSE-CHECK-CD-4012
                  , :ACCOUNT-NO-4012
                  , :IC-NO-4012
                  , :MTR-REF-NO-4012
                  , :METER-SUPPLYING-CD-4012
                  , :CODE-STATUS-REAS-4012
                  , :CALLING-SYSTEM-4012
                  , :WANTED-BY-DATE-4012
                  , :PREMISE-NO-4012
                  , :RLSE-TYPE-4012
                  , :RLSE-SUPPLIES-4012
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE RESULT_SET_CSR_4281 CURSOR
MSQ001          FOR CALL CSR04281                                             
                  ( :CUSTOMER-NO-4281
                  , :COMPANY-NO-4281
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-ACCOUNT-NO          PIC X(13).                          
       01  LINK-USERID              PIC X(07).                          
       01  LINK-PROCESS             PIC X(10).                          
       01  LINK-SOURCE-SYSTEM       PIC X(03).                          
       01  LINK-NEW-CUSTOMER-NO     PIC X(10).                          
       01  LINK-CANCEL-REVERT-FL    PIC X(01).                          
       01  LINK-XFER-FL             PIC X(01).                          
       01  LINK-XFER-FROM-ACCT      PIC X(13).                          
P00795 01  LINK-ORDER-TYPE-CD       PIC X(05).                          
P0795B 01  LINK-NEW-PREMISE-NO      PIC X(10).                          
P00795 01  LINK-WORK-TYPE-CD        PIC X(03).                          
P00795 01  LINK-CODE-UTIL-TYPE      PIC X(01).                          
MAINTN 01  LINK-SERV-ORDER-NO       PIC X(13).                          
MAINTN 01  LINK-CURRENT-HISTORY-FL  PIC X(13).                          
MAINTN 01  LINK-ORDER-STATE-CD      PIC X(01).                          
                                                                        
       PROCEDURE DIVISION USING  LINK-ACCOUNT-NO,                       
                                 LINK-USERID,                           
                                 LINK-PROCESS,                          
                                 LINK-SOURCE-SYSTEM,                    
                                 LINK-NEW-CUSTOMER-NO,                  
                                 LINK-CANCEL-REVERT-FL,                 
                                 LINK-XFER-FL,                          
                                 LINK-XFER-FROM-ACCT,                   
P00795                           LINK-ORDER-TYPE-CD,                    
P0795B                           LINK-NEW-PREMISE-NO,                   
P00795                           LINK-WORK-TYPE-CD,                     
P00795                           LINK-CODE-UTIL-TYPE,                   
MAINTN                           LINK-SERV-ORDER-NO,                    
MAINTN                           LINK-CURRENT-HISTORY-FL,               
MAINTN                           LINK-ORDER-STATE-CD.                   
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           IF CTR-ROWS = 0                                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
                            S-RETURN-CODE-5                             
                            S-RETURN-CODE-6                             
                            S-RETURN-CODE-7                             
                            S-RETURN-CODE-8                             
                            S-RETURN-CODE-9                             
                            S-RETURN-CODE-10                            
                            S-RETURN-CODE-11                            
P0795A                      S-RETURN-CODE-12                            
P0795A                      S-RETURN-CODE-13                            
DT9511                      S-RETURN-CODE-16                            
               MOVE 'NO DATA' TO S-BUS-RULE-ID                          
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT                
               PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT                
               PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT                
               PERFORM 0107-DECLARE-GTT07 THRU 0107-EXIT                
               PERFORM 8700-SEND-RESULT-7 THRU 8700-EXIT                
               PERFORM 0108-DECLARE-GTT08 THRU 0108-EXIT                
               PERFORM 8800-SEND-RESULT-8 THRU 8800-EXIT                
               PERFORM 0109-DECLARE-GTT09 THRU 0109-EXIT                
               PERFORM 8810-SEND-RESULT-9 THRU 8810-EXIT                
               PERFORM 0110-DECLARE-GTT10 THRU 0110-EXIT                
               PERFORM 8820-SEND-RESULT-10 THRU 8820-EXIT               
               PERFORM 0111-DECLARE-GTT11 THRU 0111-EXIT                
               PERFORM 8830-SEND-RESULT-11 THRU 8830-EXIT               
MAINTN         PERFORM 0113-DECLARE-GTT13 THRU 0113-EXIT                
MAINTN         PERFORM 8850-SEND-RESULT-13 THRU 8850-EXIT               
DT9511         PERFORM 0116-DECLARE-GTT16 THRU 0116-EXIT                
DT9511         PERFORM 8880-SEND-RESULT-16 THRU 8880-EXIT               
               PERFORM 9999-END-PROGRAM    THRU 9999-EXIT
           END-IF.              
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZATION.                                             
                                                                        
           MOVE 'N' TO WS-GTT01-DECLARED                                
                       WS-GTT03-DECLARED                                
                       WS-GTT04-DECLARED                                
                       WS-GTT05-DECLARED                                
                       WS-GTT06-DECLARED                                
                       WS-GTT07-DECLARED                                
                       WS-GTT08-DECLARED                                
                       WS-GTT09-DECLARED                                
                       WS-GTT10-DECLARED                                
                       WS-GTT11-DECLARED                                
P0795A                 WS-GTT13-DECLARED                                
DT9511                 WS-GTT16-DECLARED.                               
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0101-DECLARE-GTT01.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R1
              (                                                          
               RETURN_CODE          INT,                            
               STATUS_CODE          INT,                            
               BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ACTION_TYPE_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8001-DELETE-GTT1-ROWS THRU 8001-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0101'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT1'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT01-DECLARED.                               
                                                                        
       0101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0103-DECLARE-GTT03.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R3
              (                                                          
               RETURN_CODE          INT,                            
               ASSIGNED_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
               SERV_ORDER_NO        DECIMAL(13,0),                      
               ORDER_TYPE_CD CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               ORDER_STATE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               CUSTOMER_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2,         
               REMARKS CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2,              
               WORK_AREA CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,             
               PHONE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                 
               REMARK_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,           
               SERV_ORDER_STATUS CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                            
P00718*        BUSINESS_UNIT        CHAR(03)                                    
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8003-DELETE-GTT3-ROWS THRU 8003-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0103'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT3'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R3'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT03-DECLARED.                               
                                                                        
       0103-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0104-DECLARE-GTT04.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R4
              (                                                          
               RETURN_CODE          INT,                            
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               RATE_PLAN CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,             
               SUPPLIES CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2,              
               METER_LOC CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               METER_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               METER_STATUS_REASON CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               METER_READ_INST CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               METER_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               IC_NO                SMALLINT,                           
               MTR_REF_NO           SMALLINT,                           
               CODE_REV_CLASS CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
               RLSE_REQUIRED CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,         
               RLSE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,               
               RLSE_MSG CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,              
               RLSE_ADDL_MSG CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2,         
               RLSE_PHONE CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,            
               RLSE_ALT_PHONE CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2,        
               RLSE_REV_DIST CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,         
               BUS_RULE_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               ACTION_TYPE_CD CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2,        
               BUS_RULE_XREF_ID CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               RLSE_ENABLED_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               OLD_WORK_TYPE_CD CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               SO_SEQ_NO            SMALLINT                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8004-DELETE-GTT4-ROWS THRU 8004-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0104'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT4'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R4'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT04-DECLARED.                               
                                                                        
       0104-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0105-DECLARE-GTT05.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R5
              (                                                          
               RETURN_CODE          INT,                            
               SERV_ORDER_NO        DECIMAL(13,0),                      
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               WORK_TYPE_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               IC_NO                SMALLINT,                           
               METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2,              
               MTR_REF_NO           SMALLINT                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8005-DELETE-GTT5-ROWS THRU 8005-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0105'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT5'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R5'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT05-DECLARED.                               
                                                                        
       0105-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0106-DECLARE-GTT06.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R6
              (                                                          
               RETURN_CODE          INT,                            
               CONTACT_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,          
               NAME_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,             
               MATRIX_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8006-DELETE-GTT6-ROWS THRU 8006-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0106'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT6'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R6'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT06-DECLARED.                               
                                                                        
       0106-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0107-DECLARE-GTT07.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R7')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R7
              (                                                          
               RETURN_CODE          INT,                            
               CALENDAR_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,           
               GOOD_DAY_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8007-DELETE-GTT7-ROWS THRU 8007-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0107'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT7'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R7'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT07-DECLARED.                               
                                                                        
       0107-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0108-DECLARE-GTT08.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R8')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R8
              (                                                          
               RETURN_CODE          INT,                            
               RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               RATE_ITEM_CODE       SMALLINT,                           
               CODE_PLAN_STATUS CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CODE_STATUS_REASON CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               MONTHLY_AMOUNT       DECIMAL(5,2),                       
               NO_UNITS             SMALLINT,                           
               SUBDIVISION_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               IC_NO                SMALLINT,                           
               RATE_PLAN_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,        
               SERVICE_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,          
               DIST_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,               
               POLE_NO CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2                
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8008-DELETE-GTT8-ROWS THRU 8008-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0108'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT8'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R8'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT08-DECLARED.                               
                                                                        
       0108-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0109-DECLARE-GTT09.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R9')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R9
              (                                                          
               RETURN_CODE          INT,                            
               EQUIPMENT_NO CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2,          
               APPLIANCE_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CAUTION_TAG_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               CUT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,               
               TAG_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,                
               CONDITION_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               LOCATION_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,           
               APPL_COMMENTS CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2,        
               CAUTION_TAG_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
               SOURCE_SYSTEM_CD CHAR(03)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               INSTALL_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,            
               SERIAL_NO CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2,             
               CAD_VERIFY_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,         
               APPLIANCE_DESC CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2,        
               SEASONAL_RT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               CRAWL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,              
               APPL_LONG_DESC CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                          
               PRIMARY_FUEL_CD CHAR(06)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               AVERAGE_BTU          INT,                            
               LEAK_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,              
               LIGHT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,             
               REPAIR_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
               CUTOFF_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,            
               REPLACE_APP_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8009-DELETE-GTT9-ROWS THRU 8009-EXIT              
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0109'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT9'       TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R9'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT09-DECLARED.                               
                                                                        
       0109-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0110-DECLARE-GTT10.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R10')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R10
              (                                                          
               RETURN_CODE          INT,                            
               CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               IC_NO                SMALLINT,                           
               RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,          
               CODE_REV_CLASS CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2,        
               RATE_PLAN_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2,        
               TOU_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,                
               FIXED_FACTOR_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               BILL_CONTRACT_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2,                           
               INTERRUPT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8010-DELETE-GTT10-ROWS THRU 8010-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0110'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT10'      TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R10'       TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT10-DECLARED.                               
                                                                        
       0110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0111-DECLARE-GTT11.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R11')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R11
              (                                                          
               RETURN_CODE          INT,                            
               ACCOUNT_NO           DECIMAL(13,0),                      
               CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2,        
               ADDRESS_LINE CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8011-DELETE-GTT11-ROWS THRU 8011-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0111'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT11'      TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R11'       TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT11-DECLARED.                               
                                                                        
       0111-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0113-DECLARE-GTT13.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R13')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R13
              (                                                          
                 RETURN_CODE          INT                           
                ,SERV_ORDER_NO           DECIMAL(13,0)                  
                ,REMARK_TYPE_CD CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                       
                ,REMARK_TX CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8013-DELETE-GTT13-ROWS THRU 8013-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0113'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R13'        TO TABLE-1                 
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT13-DECLARED.                               
                                                                        
       0113-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0116-DECLARE-GTT16.                                              
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04476_R16')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04476_R16
              (                                                          
                 RETURN_CODE          INT                           
                ,CONTRACT_ID          INT                           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8016-DELETE-GTT16-ROWS THRU 8016-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0116'               TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04476_R16'        TO TABLE-1                 
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
               END-IF
           END-IF.            
           MOVE 'Y' TO WS-GTT16-DECLARED.                               
                                                                        
       0116-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           IF LINK-ACCOUNT-NO NOT NUMERIC                               
               MOVE ZEROES TO LINK-ACCOUNT-NO
           END-IF.                          
           MOVE LINK-ACCOUNT-NO         TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO.               
           IF LINK-NEW-CUSTOMER-NO NOT NUMERIC                          
               MOVE ZEROES TO LINK-NEW-CUSTOMER-NO
           END-IF.                     
           MOVE LINK-NEW-CUSTOMER-NO TO WS-NEW-CUSTOMER-NO.             
                                                                        
           IF LINK-NEW-PREMISE-NO NOT NUMERIC                           
               MOVE ZEROES TO LINK-NEW-PREMISE-NO
           END-IF.                      
                                                                        
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-DATE                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( DAY, -31, 
           CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS) ), 121), ' ', '-'), ':', 
           '.')
            INTO
              :WS-TS-MINUS-31-DAYS                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        VALUES  (TIMESTAMP(:WS-CURRENT-TS) - 31 DAYS)                    
MFA-TR*          INTO :WS-TS-MINUS-31-DAYS                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
P0795B*  IF SET, THEN ACCOUNT NUMBER CAN BE 0. SO ALSO CHECK FOR                
P0795B*  PREMISE BEING 0                                                        
                                                                        
           IF LINK-ACCOUNT-NO = ZEROES  AND                             
              LINK-NEW-PREMISE-NO = ZEROES                              
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE +100 TO S-RETURN-CODE-1                             
                            S-RETURN-CODE-2                             
                            S-RETURN-CODE-3                             
                            S-RETURN-CODE-4                             
                            S-RETURN-CODE-5                             
                            S-RETURN-CODE-6                             
                            S-RETURN-CODE-7                             
                            S-RETURN-CODE-8                             
                            S-RETURN-CODE-9                             
                            S-RETURN-CODE-10                            
                            S-RETURN-CODE-11                            
P0795A                      S-RETURN-CODE-12                            
DT9511                      S-RETURN-CODE-16                            
               MOVE 'PARMS ZERO' TO S-BUS-RULE-ID                       
               ADD +1 TO CTR-ROWS                                       
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT                
               PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT                
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT                
               PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT                
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT                
               PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT                
               PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT                
               PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT                
               PERFORM 0107-DECLARE-GTT07 THRU 0107-EXIT                
               PERFORM 8700-SEND-RESULT-7 THRU 8700-EXIT                
               PERFORM 0108-DECLARE-GTT08 THRU 0108-EXIT                
               PERFORM 8800-SEND-RESULT-8 THRU 8800-EXIT                
               PERFORM 0109-DECLARE-GTT09 THRU 0109-EXIT                
               PERFORM 8810-SEND-RESULT-9 THRU 8810-EXIT                
               PERFORM 0110-DECLARE-GTT10 THRU 0110-EXIT                
               PERFORM 8820-SEND-RESULT-10 THRU 8820-EXIT               
               PERFORM 0111-DECLARE-GTT11 THRU 0111-EXIT                
               PERFORM 8830-SEND-RESULT-11 THRU 8830-EXIT               
DT9511         PERFORM 0116-DECLARE-GTT16 THRU 0116-EXIT                
DT9511         PERFORM 8880-SEND-RESULT-16 THRU 8880-EXIT               
               PERFORM 9999-END-PROGRAM THRU 9999-EXIT
           END-IF.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
P0795B     IF LINK-ACCOUNT-NO NOT= ZEROS                                
              PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT                
P0795B        PERFORM 7010-SELECT-MTRENV THRU 7010-EXIT                 
P0795B        PERFORM 7020-SELECT-CSTPLN THRU 7020-EXIT                 
D10775        PERFORM 7300-CHECK-2000-ACCESS THRU 7300-EXIT             
D10775        IF AT-BANKRUPTCY-IND = 'B' AND                            
D10775           LINK-XFER-FROM-ACCT = LINK-ACCOUNT-NO AND              
D10775           (LINK-ORDER-TYPE-CD <= SPACES OR                       
D10775            LINK-ORDER-TYPE-CD (1:2) = 'CC') AND                  
D10775            WS-HAS-2000-ACCESS = 'Y'                              
D10775           PERFORM 7290-SELECT-BANKRUPTCY  THRU 7290-EXIT         
D10775        END-IF                                                    
P0795B        MOVE AT-PREMISE-NO TO WS-PREMISE-NO-NUM                   
P0795B     ELSE                                                         
P0795B        MOVE LINK-NEW-PREMISE-NO     TO WS-NEW-PREMISE-NO         
P0795B        MOVE WS-NEW-PREMISE-NO-NUM   TO WS-PREMISE-NO-NUM         
P0795B     END-IF                                                       
                                                                        
           IF LINK-SERV-ORDER-NO > SPACES AND                           
              LINK-SERV-ORDER-NO NOT = '0000000000000'                  
               MOVE 'N' TO WS-NEW-ORDER-FL                              
           END-IF                                                       
                                                                        
           PERFORM 7040-SELECT-PREMISE THRU 7040-EXIT.                  
P00795     IF LINK-ACCOUNT-NO = ZEROS                                   
P00795        MOVE PR-COMPANY-NO TO AT-COMPANY-NO
           END-IF.                      
                                                                        
DT6878     PERFORM 7620-GET-DATABASE  THRU 7620-EXIT.                   
A04670     PERFORM 7070-SELECT-DELINQ THRU 7070-EXIT.                   
                                                                        
A04670     PERFORM 7060-LANDLORD THRU 7060-EXIT.                        
A05821     PERFORM 7510-BUILDER-REALTOR THRU 7510-EXIT.                 
P0795N* SET FLAG TO SEE IF THE REQUEST IS AN OFF TO CC CONVERT                  
           IF LINK-PROCESS = 'START' AND                                
              (LINK-ORDER-TYPE-CD (1:2) = 'CC' OR                       
               LINK-ORDER-TYPE-CD = 'UMRCC')  AND                       
               LINK-SERV-ORDER-NO > '0000000000000'                     
                  MOVE 'Y' TO WS-OFF-TO-CC-CONVERT                      
           END-IF                                                       
P00795     IF (LINK-PROCESS = 'START' OR 'STOP') AND                    
P00795          (LINK-ORDER-TYPE-CD (1:2) = 'CC' OR                     
P00795           LINK-ORDER-TYPE-CD (1:3) = 'OFF')                      
P00795           MOVE SPACES TO LINK-ORDER-TYPE-CD                      
P00795     END-IF                                                       
                                                                        
           IF LINK-PROCESS = 'START'                                    
               MOVE 'SOINIT0002' TO 1T-BUS-PROCESS-ID                   
                                                                        
P00795*  IF A SET ORDER IS INITIATED ON AN NEW ACCOUNT WITH PENDING             
P00795*  SET, MAKE THAT INTO A CC ORDER                                         
P00795         IF LINK-ACCOUNT-NO > ZEROS AND                           
P00795              LINK-ORDER-TYPE-CD = 'FM002'                        
P00795            MOVE SPACES TO LINK-ORDER-TYPE-CD                     
P00795         END-IF                                                   
P00795*                                                                         
P00795         IF LINK-ORDER-TYPE-CD <= SPACES                          
P00795            MOVE 'CC' TO WS-ORDER-TYPE-CD                         
P0795D            MOVE 'CC001' TO L3-ORDER-TYPE-CD                      
P00795         ELSE                                                     
P00795            MOVE LINK-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD           
P0795D                                       L3-ORDER-TYPE-CD           
P00795         END-IF                                                   
           END-IF.                                                      
           IF LINK-PROCESS = 'STOP'                                     
               MOVE 'SOINIT0001' TO 1T-BUS-PROCESS-ID                   
P00795         IF LINK-ORDER-TYPE-CD <= SPACES                          
P00795            MOVE 'OFF' TO WS-ORDER-TYPE-CD                        
P0795D            MOVE 'OFF01' TO L3-ORDER-TYPE-CD                      
P00795         ELSE                                                     
P00795            MOVE LINK-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD           
P0795D                                       L3-ORDER-TYPE-CD           
P00795         END-IF                                                   
           END-IF.                                                      
P00795     IF LINK-PROCESS = 'AOO'                                      
P00795         MOVE 'SOINIT0005' TO 1T-BUS-PROCESS-ID
           END-IF.                  
                                                                        
MAINTN     IF LINK-PROCESS = WS-MAINTAIN                                
MAINTN         MOVE 'SOINIT0006' TO 1T-BUS-PROCESS-ID
           END-IF.                  
                                                                        
                                                                        
P00795     IF LINK-ORDER-TYPE-CD > SPACES                               
P00795         MOVE LINK-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD              
P00795                                    C2-ORDER-TYPE-CD              
P00795                                    L3-ORDER-TYPE-CD              
           ELSE                                                         
             IF LINK-PROCESS = WS-MAINTAIN                              
               IF LINK-CURRENT-HISTORY-FL = WS-HISTORY-ORDER            
                  PERFORM 7260-GET-HST-SO-DATA THRU 7260-EXIT           
               ELSE                                                     
                  PERFORM 7250-GET-SO-DATA THRU 7250-EXIT               
               END-IF                                                   
             END-IF                                                     
           END-IF                                                       
           IF C2-ORDER-TYPE-CD > SPACES                                 
P00795         PERFORM 7160-GET-ORDER-TYPE-INFO THRU 7160-EXIT          
MAINTN         MOVE C2-SAME-DAY-ORDER-FL TO WS-SAME-DAY-FL              
MAINTN                                      S-SAME-DAY-FL               
P00795     END-IF.                                                      
P0795D     MOVE LINK-WORK-TYPE-CD TO L3-WORK-TYPE-CD                    
                                                                        
           MOVE AT-CUSTOMER-NO TO WS-CUSTOMER-NO-NUM.                   
                                                                        
P0795D* IF ORDER/WORK TYPE IS NOT VALID GIVE HARD ERROR                         
                                                                        
P0795D     IF L3-ORDER-TYPE-CD > SPACES AND L3-WORK-TYPE-CD > SPACES    
P0795D        PERFORM  7165-IS-ORDWK-TYPE-VALID THRU 7165-EXIT          
P0795D        IF WS-ORDWK-VALID-FL = 'N'                                
P0795D           IF WS-GTT01-DECLARED = 'N'                             
P0795D              PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT           
P0795D           END-IF                                                 
P0795D           INITIALIZE GTT-RETURN-FIELDS-1                         
P0795D           MOVE 0 TO S-RETURN-CODE-1                              
P0795D                     S-STATUS-CODE                                
P0795D           MOVE 'ORDR000326' TO S-BUS-RULE-ID                     
P0795D           MOVE 'P' TO S-ACTION-TYPE-CD                           
P0795D           MOVE 'Y' TO WS-HARD-ERROR-FOUND                        
P0795D           PERFORM 7025-RULE-XREF THRU 7025-EXIT                  
P0795D           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT              
DT6945        ELSE                                                      
DT6945           IF L3-SAME-DAY-FL = 'Y'                                
DT6945              MOVE 'Y' TO WS-SAME-DAY-FL                          
DT6945           END-IF                                                 
P0795D        END-IF                                                    
P0795D     END-IF                                                       
                                                                        
           IF LINK-PROCESS  = 'START'  AND                              
              LINK-ACCOUNT-NO = ZEROS AND                               
              LINK-ORDER-TYPE-CD = 'FM002'                              
                MOVE 'Y' TO WS-NEW-SET-ORDER                            
           END-IF                                                       
           IF LINK-PROCESS = WS-MAINTAIN AND                            
MAINTN        (LINK-ORDER-TYPE-CD > SPACES OR                           
MAINTN        LINK-WORK-TYPE-CD > SPACES)                               
MAINTN         MOVE 'Y'  TO WS-ORDER-TYPE-CHANGED                       
D26613        IF LINK-ORDER-TYPE-CD (1:3) = 'OFF'  AND                  
D26613           LINK-SERV-ORDER-NO > '0000000000000'                   
D26613             MOVE 'Y' TO WS-CC-TO-OFF-CONVERT                     
D26613        END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 5000-CALL-CSR04477 THRU 5000-EXIT.                   
           PERFORM 5100-CALL-CSR04478 THRU 5100-EXIT.                   
                                                                        
D10004     IF LINK-PROCESS = WS-MAINTAIN                                
A10004        IF LINK-CURRENT-HISTORY-FL = WS-HISTORY-ORDER             
A10004          PERFORM 7282-GET-TASK-STATUS-HIST THRU 7282-EXIT        
A10004        ELSE                                                      
D10004          PERFORM 7280-GET-TASK-STATUS THRU 7280-EXIT             
A10004        END-IF                                                    
D10004     END-IF                                                       
                                                                        
           IF LINK-PROCESS = WS-MAINTAIN AND                            
              S-ORDER-STATE-CD-12 NOT = 'C' AND                         
              S-ORDER-STATE-CD-12 NOT = 'Z'                             
              MOVE 'N' TO WS-APPLIANCE-RELOAD-FL                        
APPLCO        PERFORM 7170-SO-APPL-COUNT  THRU 7170-EXIT                
APPLCO        PERFORM 7175-PREMISE-APPL-COUNT THRU 7175-EXIT            
              IF WS-SO-APPL-COUNT NOT = WS-PREMISE-APPL-COUNT           
                 MOVE 'Y' TO WS-APPLIANCE-RELOAD-FL                     
              ELSE                                                      
                 MOVE WS-PREMISE-NO-NUM TO LA-PREMISE-NO                
APPLCO           PERFORM 7180-GET-PREM-APPL  THRU 7180-EXIT             
APPLCO           PERFORM 7185-GET-ORDER-APPL THRU 7185-EXIT             
APPLCO           PERFORM 7190-COMPARE-APPLIANCE THRU 7190-EXIT          
              END-IF                                                    
                                                                        
MAINTN        IF WS-ORDER-TYPE-CHANGED = 'Y'                            
MAINTN*  MESSAGE THAT CHARGES WILL CHANGE WHEN ORDER TYPE CHAGNED               
MAINTN           IF WS-GTT01-DECLARED = 'N'                             
MAINTN              PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT           
MAINTN           END-IF                                                 
MAINTN           INITIALIZE GTT-RETURN-FIELDS-1                         
MAINTN           MOVE 0 TO S-RETURN-CODE-1                              
MAINTN                     S-STATUS-CODE                                
MAINTN           MOVE 'ORDR000345' TO S-BUS-RULE-ID                     
MAINTN           MOVE 'P' TO S-ACTION-TYPE-CD                           
MAINTN           PERFORM 7025-RULE-XREF THRU 7025-EXIT                  
MAINTN           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT              
MAINTN        END-IF                                                    
           END-IF                                                       
           MOVE WS-APPLIANCE-RELOAD-FL TO S-APPLIANCE-RELOAD-FL.        
                                                                        
P0795B*  FOR SET ORDERS THE RLSE REQD FL IS SET BASED ON CSS_REV_DIST           
P0795B*  AND CSS_RLSE_REV_DIST                                                  
           MOVE WS-ORDER-TYPE-CD TO L3-ORDER-TYPE-CD                    
           MOVE LINK-WORK-TYPE-CD TO L3-WORK-TYPE-CD                    
P0795H     PERFORM 7052-RELEASE-ENABLED THRU 7052-EXIT                  
DT6878     IF SEB-DATABASE OR                                           
D10605       (LINK-PROCESS = WS-MAINTAIN AND                            
D10605      (S-ORDER-STATE-CD-12 = 'C' OR 'Z'))                         
D10605        MOVE 'N' TO WS-RLSE-ENABLED-FL                            
D10605     END-IF                                                       
P0795H     MOVE WS-RLSE-ENABLED-FL TO S-RLSE-ENABLED-FL                 
                                                                        
P0795B     IF LINK-ACCOUNT-NO > ZEROES                                  
              PERFORM 5200-CALL-CSR04479 THRU 5200-EXIT                 
P0795B     END-IF                                                       
P0795J     IF WS-NEW-SET-ORDER = 'Y'                                    
P0795J        PERFORM 7045-SELECT-PREM-ADDRESS   THRU 7045-EXIT         
P0795J        IF PR-SUBDIVISION-ID > SPACES                             
P0795J           PERFORM 7046-GET-ZIPCODE-SUBDIV    THRU 7046-EXIT      
P0795J        END-IF                                                    
P0795J        IF WS-SUBDIV-RATE-EXISTS = 'Y'                            
P0795J           PERFORM 7047-GET-SUBDIV-LIGHT-CHRG THRU 7047-EXIT      
P0795J        END-IF                                                    
P0795J     END-IF                                                       
                                                                        
P0795B     IF LINK-ORDER-TYPE-CD = 'FM002'                              
              MOVE LINK-CODE-UTIL-TYPE TO  BA-CODE-UTIL-TYPE            
              PERFORM 7050-RELEASE-RQMT THRU 7050-EXIT                  
              IF L3-RLSE-CHECK-CD = 'C'                                 
                  PERFORM 7080-REV-DIST-RLSE      THRU 7080-EXIT        
P0795B            IF LINK-ACCOUNT-NO = ZEROS                            
                    MOVE '000000000' TO S-METER-NO-4                    
                    MOVE BA-SET-NEW-SET-FL TO S-RLSE-REQUIRED           
DT6878              IF SEB-DATABASE OR                                  
D10605                (LINK-PROCESS = WS-MAINTAIN AND                   
D10605                (S-ORDER-STATE-CD-12 = 'C' OR 'Z'))               
D10605                     MOVE 'N' TO WS-RLSE-ENABLED-FL               
D10605              ELSE                                                
                           MOVE 'Y' TO S-RLSE-ENABLED-FL                
D10605              END-IF                                              
                    MOVE LINK-CODE-UTIL-TYPE TO  S-CODE-UTIL-TYPE-4     
                    MOVE LINK-WORK-TYPE-CD TO S-WORK-TYPE-CD-4          
                    IF WS-GTT04-DECLARED = 'N'                          
                        PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT       
                    END-IF                                              
                    PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT           
P0795B            END-IF                                                
                  MOVE BA-SET-NEW-SET-FL TO S-SET-RLSE-REQD-FL          
              END-IF                                                    
P0795B     END-IF                                                       
                                                                        
           IF LINK-ORDER-TYPE-CD > SPACES                               
              IF ((C2-ORDER-GROUP-CD = 'A'OR 'G') OR                    
                  LINK-ORDER-TYPE-CD(1:2) = 'UM')                       
                  MOVE LINK-WORK-TYPE-CD TO WS-WORK-TYPE                
                                            S-UNMTR-WORK-TYPE           
                  IF (C2-ORDER-GROUP-CD = 'G')                          
                     MOVE LINK-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE      
                  ELSE                                                  
                     MOVE C2-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE        
                  END-IF                                                
                  MOVE SPACES TO WS-METER-STATUS                        
                  MOVE SPACES TO WS-METER-IND                           
MAINTN*           MOVE LINK-ORDER-TYPE-CD TO L3-ORDER-TYPE-CD                   
MAINTN*           MOVE LINK-WORK-TYPE-CD TO L3-WORK-TYPE-CD                     
MAINTN*           PERFORM 7170-IS-SAME-DAY-ORDER THRU 7170-EXIT                 
                  PERFORM 7050-RELEASE-RQMT THRU 7050-EXIT              
                  MOVE WS-SAME-DAY-FL TO S-SAME-DAY-FL                  
              END-IF                                                    
              IF WS-NEW-SET-ORDER  = 'Y'                                
                 MOVE 'Y' TO WS-NEW-SET-ORDER                           
                 MOVE LINK-WORK-TYPE-CD TO WS-WORK-TYPE                 
                 MOVE LINK-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE          
                 MOVE SPACES TO WS-METER-STATUS                         
                 MOVE SPACES TO WS-METER-IND                            
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE LINK-WORK-TYPE-CD TO S-ORIG-WORK-TYPE                   
           MOVE LINK-CODE-UTIL-TYPE TO S-ORIG-UTIL-TYPE                 
           IF (LINK-PROCESS = WS-MAINTAIN  AND                          
               LINK-CURRENT-HISTORY-FL NOT = WS-HISTORY-ORDER) OR       
              LINK-PROCESS NOT = WS-MAINTAIN                            
              PERFORM 5300-CALL-CSR04480 THRU 5300-EXIT                 
           END-IF                                                       
DT9985     IF LINK-PROCESS NOT= 'MAINTAIN'                              
A04670        MOVE PR-CODE-RENTAL-PROP TO S-CODE-RENTAL-PROP            
DT9985     ELSE                                                         
DT9985        MOVE SPACES TO S-CODE-RENTAL-PROP                         
DT9985     END-IF                                                       
                                                                        
           IF WS-LIGHTING-FL = 'Y' AND                                  
              LINK-PROCESS = 'START'                                    
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 0 TO S-RETURN-CODE-1                             
                            S-STATUS-CODE                               
                  MOVE 'ORDR000014' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7025-RULE-XREF THRU 7025-EXIT                 
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
                                                                        
           IF WS-SUBDIV-LITE-FL = 'Y' AND                               
              LINK-PROCESS = 'START'                                    
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 0 TO S-RETURN-CODE-1                             
                            S-STATUS-CODE                               
                  MOVE 'ORDR000015' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7025-RULE-XREF THRU 7025-EXIT                 
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
                                                                        
           IF WS-METERED-LIGHT-FL = 'Y' AND                             
              LINK-PROCESS = 'START'                                    
                  IF WS-GTT01-DECLARED = 'N'                            
                      PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT         
                  END-IF                                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 0 TO S-RETURN-CODE-1                             
                            S-STATUS-CODE                               
                  MOVE 'ORDR000056' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7025-RULE-XREF THRU 7025-EXIT                 
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.            
                                                                        
           IF S-ARRANGEMENT-FL = 'Y'                                    
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'APPT/ARRG' TO S-BUS-RULE-ID                        
               MOVE 'P' TO S-ACTION-TYPE-CD                             
               PERFORM 7025-RULE-XREF THRU 7025-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
A04670     IF WS-ELEC-SOR-FL = 'Y' AND S-SO-MTR-ROW-EXISTS-12 NOT= 'Y'  
A04670         IF WS-GTT01-DECLARED = 'N'                               
A04670             PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
A04670         END-IF                                                   
A04670         INITIALIZE GTT-RETURN-FIELDS-1                           
A04670         MOVE 0 TO S-RETURN-CODE-1                                
A04670                   S-STATUS-CODE                                  
A04670         MOVE 'ORDR000065' TO S-BUS-RULE-ID                       
A04670         MOVE 'P' TO S-ACTION-TYPE-CD                             
A04670         PERFORM 7025-RULE-XREF THRU 7025-EXIT                    
A04670         PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-ELEC-UNBLOCK-FL = 'Y'                                  
               IF WS-GTT01-DECLARED = 'N'                               
                   PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
               END-IF                                                   
               INITIALIZE GTT-RETURN-FIELDS-1                           
               MOVE 0 TO S-RETURN-CODE-1                                
                         S-STATUS-CODE                                  
               MOVE 'ORDRCF0008' TO S-BUS-RULE-ID                       
               MOVE 'ORDER' TO S-ACTION-TYPE-CD                         
               PERFORM 7025-RULE-XREF THRU 7025-EXIT                    
               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-GAS-UNBLOCK-FL = 'Y'                                   
               IF WS-ELEC-IC-FL = 'Y'                                   
                   IF WS-GTT01-DECLARED = 'N'                           
                       PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT        
                   END-IF                                               
                   INITIALIZE GTT-RETURN-FIELDS-1                       
                   MOVE 0 TO S-RETURN-CODE-1                            
                             S-STATUS-CODE                              
                   MOVE 'ORDRCF0014' TO S-BUS-RULE-ID                   
                   MOVE 'ORDER' TO S-ACTION-TYPE-CD                     
                   PERFORM 7025-RULE-XREF THRU 7025-EXIT                
                   PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT            
      *            IF WS-GTT01-DECLARED = 'N'                                   
      *                PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT                
      *            END-IF                                                       
      *            INITIALIZE GTT-RETURN-FIELDS-1                               
      *            MOVE 0 TO S-RETURN-CODE-1                                    
      *                      S-STATUS-CODE                                      
      *            MOVE 'ORDRCF0008' TO S-BUS-RULE-ID                           
      *            MOVE 'ORDER' TO S-ACTION-TYPE-CD                             
      *            PERFORM 7025-RULE-XREF THRU 7025-EXIT                        
      *            PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT                    
               ELSE                                                     
                   IF WS-GTT01-DECLARED = 'N'                           
                       PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT        
                   END-IF                                               
                   INITIALIZE GTT-RETURN-FIELDS-1                       
                   MOVE 0 TO S-RETURN-CODE-1                            
                             S-STATUS-CODE                              
                   MOVE 'ORDRCF0009' TO S-BUS-RULE-ID                   
                   MOVE 'ORDER' TO S-ACTION-TYPE-CD                     
                   PERFORM 7025-RULE-XREF THRU 7025-EXIT                
                   PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
               END-IF
           END-IF.           
                                                                        
             IF LINK-PROCESS = WS-MAINTAIN AND                          
                WS-ORDER-TYPE-CHANGED = 'Y'                             
                IF WS-SAME-DAY-FL = 'Y' AND                             
                   WS-SAME-DAY-FL-PRIOR NOT = 'Y'                       
                     IF WS-GTT01-DECLARED = 'N'                         
                         PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT      
                     END-IF                                             
                     INITIALIZE GTT-RETURN-FIELDS-1                     
                     MOVE 0 TO S-RETURN-CODE-1                          
                               S-STATUS-CODE                            
                     MOVE 'ORDR000344' TO S-BUS-RULE-ID                 
                     MOVE 'P' TO S-ACTION-TYPE-CD                       
                     PERFORM 7025-RULE-XREF THRU 7025-EXIT              
                     PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT          
                END-IF                                                  
                IF WS-SAME-DAY-FL NOT = 'Y' AND                         
                   WS-SAME-DAY-FL-PRIOR = 'Y'                           
                     IF WS-GTT01-DECLARED = 'N'                         
                         PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT      
                     END-IF                                             
                     INITIALIZE GTT-RETURN-FIELDS-1                     
                     MOVE 0 TO S-RETURN-CODE-1                          
                               S-STATUS-CODE                            
                     MOVE 'ORDR000346' TO S-BUS-RULE-ID                 
                     MOVE 'P' TO S-ACTION-TYPE-CD                       
                     PERFORM 7025-RULE-XREF THRU 7025-EXIT              
                     PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT          
                END-IF                                                  
           END-IF                                                       
                                                                        
           IF LINK-PROCESS = 'STOP' AND                                 
P0795E             AT-MST-SUB-ACCT-IND NOT= 'S'                         
               PERFORM 7100-OPEN-ACCT-CURSOR THRU 7100-EXIT             
               PERFORM 7101-FETCH-ACCT-CURSOR THRU 7101-EXIT            
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
                   IF S-CODE-ACCT-STAT-11 = 'A' OR                      
                     (S-CODE-ACCT-STAT-11 = 'P' AND                     
                      WS-ORDER-FL = 'Y')                                
DT9484                  IF WS-GTT11-DECLARED = 'N'                      
DT9484                    PERFORM 0111-DECLARE-GTT11 THRU 0111-EXIT     
DT9484                  END-IF                                          
                        PERFORM 8830-SEND-RESULT-11 THRU 8830-EXIT      
                   END-IF                                               
                   PERFORM 7101-FETCH-ACCT-CURSOR THRU 7101-EXIT        
               END-PERFORM                                              
               PERFORM 7102-CLOSE-ACCT-CURSOR THRU 7102-EXIT            
           END-IF.                                                      
           IF LINK-PROCESS = 'MAINTAIN' AND                             
P0795E             AT-MST-SUB-ACCT-IND NOT= 'S' AND                     
                   ACCOUNT-NO-PRIOR-4478 > 0                            
DT9505         MOVE ACCOUNT-NO-PRIOR-4478  TO WS-AT-ACCOUNT-NO-PR       
DT8959         MOVE 'N' TO WS-XFER-TO-ACCT-ADDED                        
DT9505         PERFORM 7002-SELECT-ACCOUNT-PRIOR THRU 7002-EXIT         
               PERFORM 7200-OPEN-MAINT-ACCT-CURSOR THRU 7200-EXIT       
               PERFORM 7201-FETCH-MAINT-ACCT-CURSOR THRU 7201-EXIT      
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
                   IF S-CODE-ACCT-STAT-11 = 'A' OR                      
                     (S-CODE-ACCT-STAT-11 = 'P' AND                     
                      WS-ORDER-FL = 'Y') OR                             
DT8959                S-ACCOUNT-NO-11 = TO-ACCT-NO-4478                 
DT9484                 IF WS-GTT11-DECLARED = 'N'                       
DT9484                   PERFORM 0111-DECLARE-GTT11 THRU 0111-EXIT      
DT9484                 END-IF                                           
                       PERFORM 8830-SEND-RESULT-11 THRU 8830-EXIT       
DT8959                 IF S-ACCOUNT-NO-11 = TO-ACCT-NO-4478             
DT8959                   MOVE 'Y' TO WS-XFER-TO-ACCT-ADDED              
DT8959                 END-IF                                           
                   END-IF                                               
                   PERFORM 7201-FETCH-MAINT-ACCT-CURSOR THRU 7201-EXIT  
               END-PERFORM                                              
               PERFORM 7202-CLOSE-MAINT-ACCT-CURSOR THRU 7202-EXIT      
               IF WS-XFER-TO-ACCT-ADDED  = 'N' AND                      
                  TO-ACCT-NO-4478 > 0                                   
                  PERFORM 7092-GET-XFER-TO-INFO THRU 7092-EXIT          
DT8959            IF WS-GTT11-DECLARED = 'N'                            
DT8959               PERFORM 0111-DECLARE-GTT11 THRU 0111-EXIT          
DT8959            END-IF                                                
                  PERFORM 8830-SEND-RESULT-11 THRU 8830-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-CALL-CSR04477.                                              
                                                                        
           MOVE 'N' TO WS-HARD-ERROR-FOUND.                             
           MOVE WS-ACCOUNT-NO TO ACCOUNT-NO-4477.                       
           MOVE WS-CUSTOMER-NO TO OLD-CUSTOMER-NO-4477.                 
           MOVE WS-PREMISE-NO TO PREMISE-NO-4477.                       
           MOVE LINK-NEW-CUSTOMER-NO TO NEW-CUSTOMER-NO-4477.           
           MOVE WS-ORDER-TYPE-CD TO ORDER-TYPE-CD-4477.                 
           MOVE LINK-PROCESS TO PROCESS-4477.                           
           MOVE 'INITIATION' TO STEP-4477.                              
           MOVE LINK-USERID TO USERID-4477.                             
           MOVE PROGRAM-NAME TO PROGRAM-ID-4477.                        
           MOVE LINK-CANCEL-REVERT-FL TO CANCEL-REVERT-FL-4477.         
           MOVE LINK-XFER-FL TO XFER-FL-4477.                           
           MOVE WS-ORDER-TYPE-CHANGED TO  ORDER-TYPE-CHG-FL-4477.       
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04477                                             
      *           (:ACCOUNT-NO-4477,                                    
      *            :OLD-CUSTOMER-NO-4477,                               
      *            :PREMISE-NO-4477,                                    
      *            :NEW-CUSTOMER-NO-4477,                               
      *            :ORDER-TYPE-CD-4477,                                 
      *            :PROCESS-4477,                                       
      *            :STEP-4477,                                          
      *            :USERID-4477,                                        
      *            :PROGRAM-ID-4477,                                    
      *            :CANCEL-REVERT-FL-4477,                              
      *            :XFER-FL-4477,                                       
      *            :ORDER-TYPE-CHG-FL-4477)                             
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4477
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4477
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4477 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5000'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04477'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4477       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4477)                                                
      *       WITH PROCEDURE CSR04477                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4477 CURSOR FOR RESULT SET        
      *       :LOC4477                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_4477 INTO                          
                   :RETURN-CODE-4477,                                   
                   :BUS-RULE-ID-4477,                                   
                   :ACTION-TYPE-CD-4477,                                
                   :BUS-RULE-XREF-ID-4477,                              
                   :HARD-ERROR-4477                                     
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-4477 NOT = 0 AND                    
                        RETURN-CODE-4477 NOT = +100                     
                          MOVE RETURN-CODE-4477 TO WS-ACTIVE-RETURN-CODE
                          MOVE PROGRAM-NAME      TO ABEND-PROGRAM       
                          MOVE '5000'            TO ACTIVE-PARAGRAPH    
                          MOVE 'FETCH'           TO ABEND-FUNCTION      
                          MOVE 'CSR04477'        TO TABLE-1             
                          MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1     
                          MOVE ACCOUNT-NO-4477   TO HOSTVAR-ELEMENT-1   
                          PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT     
                     END-IF                                             
                     IF RETURN-CODE-4477 = +100                         
                         SET NO-MORE-ROWS TO TRUE                       
                     ELSE                                               
                         PERFORM 5010-PROCESS-4477 THRU 5010-EXIT       
                     END-IF                                             
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5000'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04477'            TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4477       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y' TO SW-FETCH.                                        
                                                                        
       5000-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5010-PROCESS-4477.                                               
                                                                        
           EVALUATE ACTION-TYPE-CD-4477                                 
               WHEN 'D'                                                 
                  MOVE BUS-RULE-ID-4477 TO WS-NEXT-BUS-DAY              
               WHEN 'T'                                                 
                  MOVE BUS-RULE-ID-4477 TO WS-ORDER-TYPE-CD             
A4670A         WHEN 'ACCOUNT'                                           
A4670A            IF BUS-RULE-ID-4477 NUMERIC                           
A4670A                MOVE BUS-RULE-ID-4477 TO WS-CURR-ACCOUNT-NO       
A4670A            ELSE                                                  
A4670A                MOVE ZEROES TO WS-CURR-ACCOUNT-NO                 
A4670A            END-IF                                                
               WHEN 'L'                                                 
                  IF BUS-RULE-ID-4477(1:10) NUMERIC                     
                      MOVE BUS-RULE-ID-4477(1:10) TO WS-LL-CUSTOMER-NO  
                      MOVE 'Y' TO S-REVERT-FL                           
                  ELSE                                                  
                      MOVE ZEROES TO WS-LL-CUSTOMER-NO                  
                  END-IF                                                
               WHEN OTHER                                               
                   IF HARD-ERROR-4477 = 'Y'                             
                       MOVE 'Y' TO WS-HARD-ERROR-FOUND                  
                   END-IF                                               
                   IF WS-GTT01-DECLARED = 'N'                           
                       PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT        
                   END-IF                                               
                   INITIALIZE GTT-RETURN-FIELDS-1                       
                   MOVE 0 TO S-RETURN-CODE-1                            
                             S-STATUS-CODE                              
                   MOVE BUS-RULE-ID-4477 TO S-BUS-RULE-ID               
                   MOVE ACTION-TYPE-CD-4477 TO S-ACTION-TYPE-CD         
                   MOVE BUS-RULE-XREF-ID-4477 TO S-BUS-RULE-XREF-ID     
                   PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT            
           END-EVALUATE.                                                
                                                                        
       5010-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5100-CALL-CSR04478.                                              
                                                                        
           MOVE WS-ACCOUNT-NO TO ACCOUNT-NO-4478.                       
           MOVE WS-CUSTOMER-NO TO OLD-CUSTOMER-NO-4478.                 
           MOVE WS-PREMISE-NO TO PREMISE-NO-4478.                       
           MOVE WS-ORDER-TYPE-CD TO ORDER-TYPE-CD-4478.                 
           MOVE WS-NEXT-BUS-DAY TO NEXT-BUS-DAY-4478.                   
           MOVE PROGRAM-NAME TO PROGRAM-ID-4478.                        
           IF S-REVERT-FL = 'Y'                                         
               MOVE WS-CUSTOMER-NO TO NEW-CUSTOMER-NO-4478              
               MOVE 'Y' TO REVERT-FL-4478                               
           ELSE                                                         
               MOVE LINK-NEW-CUSTOMER-NO TO NEW-CUSTOMER-NO-4478
           END-IF.       
           MOVE LINK-XFER-FL TO XFER-FL-4478.                           
           MOVE LINK-XFER-FROM-ACCT TO XFER-FROM-ACCT-4478.             
MAINTN     MOVE LINK-SERV-ORDER-NO  TO SERV-ORDER-NO-4478.              
MAINTN     MOVE LINK-CURRENT-HISTORY-FL TO CURRENT-HISTORY-FL-4478.     
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04478                                             
      *           (:ACCOUNT-NO-4478,                                    
      *            :OLD-CUSTOMER-NO-4478,                               
      *            :PREMISE-NO-4478,                                    
      *            :ORDER-TYPE-CD-4478,                                 
      *            :NEXT-BUS-DAY-4478,                                  
      *            :PROGRAM-ID-4478,                                    
      *            :NEW-CUSTOMER-NO-4478,                               
      *            :XFER-FL-4478,                                       
      *            :XFER-FROM-ACCT-4478,                                
      *            :REVERT-FL-4478,                                     
MAINTN*            :SERV-ORDER-NO-4478,                                 
MAINTN*            :CURRENT-HISTORY-FL-4478)                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_CUR_1
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_CUR_1 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04478'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4478A, :LOC4478B, :LOC4478C, :LOC4478D, :LOC4478E,   
      *        :LOC4478F, :LOC4478G, :LOC4478H)                         
      *       WITH PROCEDURE CSR04478                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4478A CURSOR FOR RESULT SET       
      *       :LOC4478A                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4478B CURSOR FOR RESULT SET       
      *       :LOC4478B                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4478C CURSOR FOR RESULT SET       
      *       :LOC4478C                                                 
      *    END-EXEC.                                                    
                                                                        
MAINTN*    EXEC SQL                                                     
MAINTN*       ALLOCATE RESULT_SET_CSR_4478D CURSOR FOR RESULT SET       
MAINTN*       :LOC4478D                                                 
MAINTN*    END-EXEC.                                                    
                                                                        
MAINTN*    EXEC SQL                                                     
MAINTN*       ALLOCATE RESULT_SET_CSR_4478E CURSOR FOR RESULT SET       
MAINTN*       :LOC4478E                                                 
MAINTN*    END-EXEC.                                                    
                                                                        
MAINTN*    EXEC SQL                                                     
MAINTN*       ALLOCATE RESULT_SET_CSR_4478F CURSOR FOR RESULT SET       
MAINTN*       :LOC4478F                                                 
MAINTN*    END-EXEC.                                                    
                                                                        
MAINTN*    EXEC SQL                                                     
MAINTN*       ALLOCATE RESULT_SET_CSR_4478G CURSOR FOR RESULT SET       
MAINTN*       :LOC4478G                                                 
MAINTN*    END-EXEC.                                                    
                                                                        
DT9511*    EXEC SQL                                                     
DT9511*       ALLOCATE RESULT_SET_CSR_4478H CURSOR FOR RESULT SET       
DT9511*       :LOC4478H                                                 
DT9511*    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH MSQ001_CUR_1 INTO                           
                 :RETURN-CODE-4478-A,                                   
                 :BILL-ADDRESS-4478,                                    
                 :SPCL-READ-INST-4478,                                  
                 :SPCL-INST-4478,                                       
                 :PREM-DIRECTIONS-4478,                                 
                 :SCRATCHPAD-4478,                                      
                 :ADDRESS-ID-4478,                                      
                 :ADDRESS-FORMAT-4478,                                  
                 :ADDR-STREET-4478,                                     
                 :ADDR-CITY-STATE-4478,                                 
                 :ADDR-ZIP-CODE-4478,                                   
                 :ADDR-COUNTRY-4478,                                    
                 :ADDR-STREET-2-4478,                                   
                 :HOUSE-NO-4478,                                        
                 :ADDR-PREFIX-1-4478,                                   
                 :ADDR-PREFIX-2-4478,                                   
                 :STREET-NAME-4478,                                     
                 :STREET-SUFFIX-4478,                                   
                 :ADDR-SUFFIX-4478,                                     
                 :STREET-LOCATION-1-4478,                               
                 :STREET-LOCATION-2-4478,                               
                 :ZIP-CODE-4478,                                        
                 :ZIP-CODE-PLUS-FOUR-4478,                              
                 :ZIP-CODE-TOKEN-4478,                                  
                 :STATE-4478,                                           
                 :SUBDIVISION-ID-4478,                                  
                 :EST-BILL-DAY-4478,                                    
                 :EST-DUE-DAY-4478,                                     
                 :EMAIL-ADDRESS-4478                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH RESULT_SET_CSR_4478A INTO                                   
MFA-TR*          :RETURN-CODE-4478-A,                                           
MFA-TR*          :BILL-ADDRESS-4478,                                            
MFA-TR*          :SPCL-READ-INST-4478,                                          
MFA-TR*          :SPCL-INST-4478,                                               
MFA-TR*          :PREM-DIRECTIONS-4478,                                         
MFA-TR*          :SCRATCHPAD-4478,                                              
MFA-TR*          :ADDRESS-ID-4478,                                              
MFA-TR*          :ADDRESS-FORMAT-4478,                                          
MFA-TR*          :ADDR-STREET-4478,                                             
MFA-TR*          :ADDR-CITY-STATE-4478,                                         
MFA-TR*          :ADDR-ZIP-CODE-4478,                                           
MFA-TR*          :ADDR-COUNTRY-4478,                                            
MFA-TR*          :ADDR-STREET-2-4478,                                           
MFA-TR*          :HOUSE-NO-4478,                                                
MFA-TR*          :ADDR-PREFIX-1-4478,                                           
MFA-TR*          :ADDR-PREFIX-2-4478,                                           
MFA-TR*          :STREET-NAME-4478,                                             
MFA-TR*          :STREET-SUFFIX-4478,                                           
MFA-TR*          :ADDR-SUFFIX-4478,                                             
MFA-TR*          :STREET-LOCATION-1-4478,                                       
MFA-TR*          :STREET-LOCATION-2-4478,                                       
MFA-TR*          :ZIP-CODE-4478,                                                
MFA-TR*          :ZIP-CODE-PLUS-FOUR-4478,                                      
MFA-TR*          :ZIP-CODE-TOKEN-4478,                                          
MFA-TR*          :STATE-4478,                                                   
MFA-TR*          :SUBDIVISION-ID-4478,                                          
MFA-TR*          :EST-BILL-DAY-4478,                                            
MFA-TR*          :EST-DUE-DAY-4478,                                             
MFA-TR*          :EMAIL-ADDRESS-4478                                            
MFA-TR*    END-EXEC.                                                            

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4478-A NOT = 0                        
                       MOVE RETURN-CODE-4478-A TO WS-ACTIVE-RETURN-CODE 
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5100'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR04478A'       TO TABLE-1                
                       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1        
                       MOVE ACCOUNT-NO-4478   TO HOSTVAR-ELEMENT-1      
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
                   END-IF                                               
                   PERFORM 5110-PROCESS-4478 THRU 5110-EXIT             
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04478A'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE.                                              
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4478-B,                                 
                   :CONTACT-TYPE-4478,                                  
                   :NAME-TYPE-4478,                                     
                   :MATRIX-NAME-4478                                    
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4478B INTO                                 
MFA-TR*            :RETURN-CODE-4478-B,                                         
MFA-TR*            :CONTACT-TYPE-4478,                                          
MFA-TR*            :NAME-TYPE-4478,                                             
MFA-TR*            :MATRIX-NAME-4478                                            
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4478-B NOT = 0 AND                   
                       RETURN-CODE-4478-B NOT = +100                    
                         MOVE RETURN-CODE-4478-B TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04478B'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4478   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4478-B = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5120-PROCESS-4478B THRU 5120-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04478B'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4478-C,                                 
                   :EQUIPMENT-NO-4478,                                  
                   :APPLIANCE-CD-4478,                                  
                   :CAUTION-TAG-IND-4478,                               
                   :CUT-IND-4478,                                       
                   :TAG-NO-4478,                                        
                   :CONDITION-CD-4478,                                  
                   :LOCATION-CD-4478,                                   
                   :APPL-COMMENTS-4478,                                 
                   :CAUTION-TAG-DT-4478,                                
                   :SOURCE-SYSTEM-CD-4478,                              
                   :INSTALL-DT-4478,                                    
                   :SERIAL-NO-4478,                                     
                   :CAD-VERIFY-DT-4478,                                 
                   :APPLIANCE-DESC-4478,                                
                   :SEASONAL-RT-FL-4478,                                
                   :CRAWL-FL-4478,                                      
                   :APPL-LONG-DESC-4478,                                
                   :PRIMARY-FUEL-CD-4478,                               
                   :AVERAGE-BTU-4478,                                   
                   :LEAK-IND-4478,                                      
                   :LIGHT-IND-4478,                                     
                   :REPAIR-IND-4478,                                    
                   :CUTOFF-IND-4478,                                    
                   :REPLACE-APP-FL-4478                                 
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4478C INTO                                 
MFA-TR*            :RETURN-CODE-4478-C,                                         
MFA-TR*            :EQUIPMENT-NO-4478,                                          
MFA-TR*            :APPLIANCE-CD-4478,                                          
MFA-TR*            :CAUTION-TAG-IND-4478,                                       
MFA-TR*            :CUT-IND-4478,                                               
MFA-TR*            :TAG-NO-4478,                                                
MFA-TR*            :CONDITION-CD-4478,                                          
MFA-TR*            :LOCATION-CD-4478,                                           
MFA-TR*            :APPL-COMMENTS-4478,                                         
MFA-TR*            :CAUTION-TAG-DT-4478,                                        
MFA-TR*            :SOURCE-SYSTEM-CD-4478,                                      
MFA-TR*            :INSTALL-DT-4478,                                            
MFA-TR*            :SERIAL-NO-4478,                                             
MFA-TR*            :CAD-VERIFY-DT-4478,                                         
MFA-TR*            :APPLIANCE-DESC-4478,                                        
MFA-TR*            :SEASONAL-RT-FL-4478,                                        
MFA-TR*            :CRAWL-FL-4478,                                              
MFA-TR*            :APPL-LONG-DESC-4478,                                        
MFA-TR*            :PRIMARY-FUEL-CD-4478,                                       
MFA-TR*            :AVERAGE-BTU-4478,                                           
MFA-TR*            :LEAK-IND-4478,                                              
MFA-TR*            :LIGHT-IND-4478,                                             
MFA-TR*            :REPAIR-IND-4478,                                            
MFA-TR*            :CUTOFF-IND-4478,                                            
MFA-TR*            :REPLACE-APP-FL-4478                                         
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4478-C NOT = 0 AND                   
                       RETURN-CODE-4478-C NOT = +100                    
                         MOVE RETURN-CODE-4478-C TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04478C'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4478   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4478-C = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5130-PROCESS-4478C THRU 5130-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04478C'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           EXEC SQL                                                     
              FETCH MSQ001_CUR_1 INTO                           
                 :RETURN-CODE-4478-D,                                   
                 :ORDER-TYPE-CD-4478-D,                                 
                 :ORDER-REASON-4478,                                    
                 :STATUS-TX-4478,                                       
                 :ORDER-STATE-CD-4478,                                  
                 :ORDER-PLACED-BY-4478,                                 
                 :PHONE-NO-4478,                                        
                 :PHONE-NO-EXT-4478,                                    
                 :WANTED-BY-DATE-4478,                                  
                 :ASSIGNED-DATE-4478,                                   
                 :CALL-BEFORE-MINUTS-4478,                              
                 :WORK-AREA-ID-4478,                                    
                 :BREAKERS-OFF-IND-4478,                                
                 :INIT-BY-CNTRCT-IND-4478,                              
                 :NOTIFY-CSR-IND-4478,                                  
                 :NOTIFY-CUST-IND-4478,                                 
                 :ORDER-PRIORITY-CD-4478,                               
                 :STD-LABOR-CHRG-4478,                                  
                 :WORK-TYPE-CD-4-4478,                                  
                 :BACK-DATED-IND-4478,                                  
                 :DEPOSIT-AMT-4478,                                     
                 :ORDER-RECVED-BY-4478,                                 
                 :VERIFY-RATE-4478,                                     
                 :PREMISE-NO-4478-D,                                    
                 :ACCOUNT-NO-4478-D,                                    
                 :ACCOUNT-NO-PRIOR-4478,                                
                 :BEGIN-APPT-DATE-4478,                                 
                 :SO-EST-LABOR-HR-4478,                                 
                 :CUSTCHG-ORD-TYPE-FL-4478,                             
                 :AMOUNT-DISC-BAL-4478,                                 
                 :CURRENT-DATE-4478,                                    
                 :CODE-UTIL-TYPE-4478-D,                                
                 :PRICE-PER-SERV-4478,                                  
                 :ACCOUNT-TYPE-DESC-4478,                               
                 :ORDER-CHARGE-AMT-4478,                                
                 :TOTAL-CHARGES-AMT-4478,                               
                 :CUST-CNT-ID-4478,                                     
                 :MTR-ACCESSIBLE-CD-4478,                               
                 :MTR-ACCESSIBLE-DT-4478,                               
                 :MTR-ACCESSIBLE-RSN-4478,                              
                 :SOURCE-SYSTEM-CD-4478-D,                              
                 :ALT-PHONE-NO-4478,                                    
                 :ALT-PHONE-NO-EXT-4478,                                
                 :HOME-ALL-DAY-FL-4478,                                 
                 :BUSINESS-UNIT-4478,                                   
                 :OPTIMIZE-ORDER-4478,                                  
                 :END-APPT-DATE-4478,                                   
                 :AM-PM-APPT-CD-4478,                                   
                 :MTR-TURNOFF-RSN-CD-4478,                              
                 :FUEL-CHNG-RSN-CD-4478,                                
                 :FUEL-CHNG-TYPE-CD-4478,                               
                 :TURNOFF-COMMENTS-4478,                                
                 :WORK-DISTRICT-4478,                                   
DT9528           :CODES-DATA-PRESENT-4478,                              
DT9519           :CANCEL-REASON-CD-4478,                                
D26359           :SO-MTR-ROW-EXISTS-4478                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH RESULT_SET_CSR_4478D INTO                                   
MFA-TR*          :RETURN-CODE-4478-D,                                           
MFA-TR*          :ORDER-TYPE-CD-4478-D,                                         
MFA-TR*          :ORDER-REASON-4478,                                            
MFA-TR*          :STATUS-TX-4478,                                               
MFA-TR*          :ORDER-STATE-CD-4478,                                          
MFA-TR*          :ORDER-PLACED-BY-4478,                                         
MFA-TR*          :PHONE-NO-4478,                                                
MFA-TR*          :PHONE-NO-EXT-4478,                                            
MFA-TR*          :WANTED-BY-DATE-4478,                                          
MFA-TR*          :ASSIGNED-DATE-4478,                                           
MFA-TR*          :CALL-BEFORE-MINUTS-4478,                                      
MFA-TR*          :WORK-AREA-ID-4478,                                            
MFA-TR*          :BREAKERS-OFF-IND-4478,                                        
MFA-TR*          :INIT-BY-CNTRCT-IND-4478,                                      
MFA-TR*          :NOTIFY-CSR-IND-4478,                                          
MFA-TR*          :NOTIFY-CUST-IND-4478,                                         
MFA-TR*          :ORDER-PRIORITY-CD-4478,                                       
MFA-TR*          :STD-LABOR-CHRG-4478,                                          
MFA-TR*          :WORK-TYPE-CD-4-4478,                                          
MFA-TR*          :BACK-DATED-IND-4478,                                          
MFA-TR*          :DEPOSIT-AMT-4478,                                             
MFA-TR*          :ORDER-RECVED-BY-4478,                                         
MFA-TR*          :VERIFY-RATE-4478,                                             
MFA-TR*          :PREMISE-NO-4478-D,                                            
MFA-TR*          :ACCOUNT-NO-4478-D,                                            
MFA-TR*          :ACCOUNT-NO-PRIOR-4478,                                        
MFA-TR*          :BEGIN-APPT-DATE-4478,                                         
MFA-TR*          :SO-EST-LABOR-HR-4478,                                         
MFA-TR*          :CUSTCHG-ORD-TYPE-FL-4478,                                     
MFA-TR*          :AMOUNT-DISC-BAL-4478,                                         
MFA-TR*          :CURRENT-DATE-4478,                                            
MFA-TR*          :CODE-UTIL-TYPE-4478-D,                                        
MFA-TR*          :PRICE-PER-SERV-4478,                                          
MFA-TR*          :ACCOUNT-TYPE-DESC-4478,                                       
MFA-TR*          :ORDER-CHARGE-AMT-4478,                                        
MFA-TR*          :TOTAL-CHARGES-AMT-4478,                                       
MFA-TR*          :CUST-CNT-ID-4478,                                             
MFA-TR*          :MTR-ACCESSIBLE-CD-4478,                                       
MFA-TR*          :MTR-ACCESSIBLE-DT-4478,                                       
MFA-TR*          :MTR-ACCESSIBLE-RSN-4478,                                      
MFA-TR*          :SOURCE-SYSTEM-CD-4478-D,                                      
MFA-TR*          :ALT-PHONE-NO-4478,                                            
MFA-TR*          :ALT-PHONE-NO-EXT-4478,                                        
MFA-TR*          :HOME-ALL-DAY-FL-4478,                                         
MFA-TR*          :BUSINESS-UNIT-4478,                                           
MFA-TR*          :OPTIMIZE-ORDER-4478,                                          
MFA-TR*          :END-APPT-DATE-4478,                                           
MFA-TR*          :AM-PM-APPT-CD-4478,                                           
MFA-TR*          :MTR-TURNOFF-RSN-CD-4478,                                      
MFA-TR*          :FUEL-CHNG-RSN-CD-4478,                                        
MFA-TR*          :FUEL-CHNG-TYPE-CD-4478,                                       
MFA-TR*          :TURNOFF-COMMENTS-4478,                                        
MFA-TR*          :WORK-DISTRICT-4478,                                           
MFA-TR*          :CODES-DATA-PRESENT-4478,                                      
MFA-TR*          :CANCEL-REASON-CD-4478,                                        
MFA-TR*          :SO-MTR-ROW-EXISTS-4478                                        
MFA-TR*    END-EXEC.                                                            

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4478-D NOT = 0 AND                    
                      RETURN-CODE-4478-D NOT = +100                     
                       MOVE RETURN-CODE-4478-D TO WS-ACTIVE-RETURN-CODE 
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5100'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR04478D'       TO TABLE-1                
                       MOVE 'SERV-ORDER-NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-4478 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
                   END-IF                                               
                   IF RETURN-CODE-4478-D = 0                            
                      PERFORM 5140-PROCESS-4478D THRU 5140-EXIT         
                   ELSE                                                 
                      MOVE +100 TO S-RETURN-CODE-12                     
                   END-IF                                               
                 WHEN NOT-FOUND                                         
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04478D'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE.                                              
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_1 INTO                         
                   :RETURN-CODE-4478-E,                                 
                   :SERV-ORDER-NO-4478-E,                               
                   :REMARK-TYPE-CD,                                     
                   :REMARK-TX                                           
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4478E INTO                                 
MFA-TR*            :RETURN-CODE-4478-E,                                         
MFA-TR*            :SERV-ORDER-NO-4478-E,                                       
MFA-TR*            :REMARK-TYPE-CD,                                             
MFA-TR*            :REMARK-TX                                                   
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4478-E NOT = 0 AND                   
                       RETURN-CODE-4478-E NOT = +100                    
                         MOVE RETURN-CODE-4478-E TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5100'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04478E'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4478   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4478-E = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5150-PROCESS-4478E THRU 5150-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04478E'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
           EXEC SQL                                                     
              FETCH MSQ001_CUR_1 INTO                           
                 :RETURN-CODE-4478-F,                                   
                 :TO-ACCT-NO-4478,                                      
                 :ROOMMATE-XFER-IND-4478,                               
                 :EPP-XFER-IND-4478,                                    
                 :DEPOSIT-XFER-IND-4478,                                
                 :OTHER-AR-XFER-IND-4478,                               
                 :PROJ-SHR-XFER-IND-4478,                               
                 :WRITE-OFF-XFER-IND-4478,                              
                 :IN-LIEU-XFER-IND-4478,                                
                 :WHT-CROSS-XFER-IND-4478,                              
                 :COAPPL-XFER-IND-4478,                                 
                 :MED-CERT-XFER-IND-4478,                               
                 :NAME-FORMAT-4478,                                     
                 :FIRST-NAME-4478,                                      
                 :MIDDLE-NAME-4478,                                     
                 :LAST-NAME-4478,                                       
                 :FULL-NAME-4478,                                       
                 :HOUSE-NO-4478-F,                                      
                 :ADDR-PREFIX-1-4478-F,                                 
                 :ADDR-PREFIX-2-4478-F,                                 
                 :STREET-NAME-4478-F,                                   
                 :STREET-LOCATION-1-4478-F,                             
                 :STREET-LOCATION-2-4478-F,                             
                 :STREET-SUFFIX-4478-F,                                 
                 :CUSTOMER-FROM-4478                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH RESULT_SET_CSR_4478F INTO                                   
MFA-TR*          :RETURN-CODE-4478-F,                                           
MFA-TR*          :TO-ACCT-NO-4478,                                              
MFA-TR*          :ROOMMATE-XFER-IND-4478,                                       
MFA-TR*          :EPP-XFER-IND-4478,                                            
MFA-TR*          :DEPOSIT-XFER-IND-4478,                                        
MFA-TR*          :OTHER-AR-XFER-IND-4478,                                       
MFA-TR*          :PROJ-SHR-XFER-IND-4478,                                       
MFA-TR*          :WRITE-OFF-XFER-IND-4478,                                      
MFA-TR*          :IN-LIEU-XFER-IND-4478,                                        
MFA-TR*          :WHT-CROSS-XFER-IND-4478,                                      
MFA-TR*          :COAPPL-XFER-IND-4478,                                         
MFA-TR*          :MED-CERT-XFER-IND-4478,                                       
MFA-TR*          :NAME-FORMAT-4478,                                             
MFA-TR*          :FIRST-NAME-4478,                                              
MFA-TR*          :MIDDLE-NAME-4478,                                             
MFA-TR*          :LAST-NAME-4478,                                               
MFA-TR*          :FULL-NAME-4478,                                               
MFA-TR*          :HOUSE-NO-4478-F,                                              
MFA-TR*          :ADDR-PREFIX-1-4478-F,                                         
MFA-TR*          :ADDR-PREFIX-2-4478-F,                                         
MFA-TR*          :STREET-NAME-4478-F,                                           
MFA-TR*          :STREET-LOCATION-1-4478-F,                                     
MFA-TR*          :STREET-LOCATION-2-4478-F,                                     
MFA-TR*          :STREET-SUFFIX-4478-F,                                         
MFA-TR*          :CUSTOMER-FROM-4478                                            
MFA-TR*    END-EXEC.                                                            

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4478-F NOT = 0 AND                    
                      RETURN-CODE-4478-F NOT = +100                     
                       MOVE RETURN-CODE-4478-F TO WS-ACTIVE-RETURN-CODE 
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5100'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR04478F'       TO TABLE-1                
                       MOVE 'SERV-ORDER-NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-4478 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
                   END-IF                                               
                   IF RETURN-CODE-4478-F = 0                            
                      PERFORM 5160-PROCESS-4478F THRU 5160-EXIT         
                   ELSE                                                 
                      MOVE +100 TO S-RETURN-CODE-14                     
                   END-IF                                               
                 WHEN NOT-FOUND                                         
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04478F'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE.                                              
                                                                        
           MOVE 'Y'                TO SW-FETCH.                         
           EXEC SQL                                                     
              FETCH MSQ001_CUR_1 INTO                           
                 :RETURN-CODE-4478-G,                                   
                 :ACCOUNT-NO-PRIOR-4478-G,                              
                 :SERV-ORDER-NO-R-4478-G,                               
                 :WANTED-BY-DATETIME-4478,                              
                 :CREDIT-LETTER-IND-4478,                               
                 :STREET-LOCATION-1-4478-G,                             
                 :STREET-LOCATION-2-4478-G,                             
                 :ADDR-ST-4478-G,                                       
                 :ADDR-ZIP-CODE-4478-G,                                 
                 :ADDR-PREFIX-1-4478-G,                                 
                 :ADDR-PREFIX-2-4478-G,                                 
                 :ADDR-SUFFIX-4478-G,                                   
                 :ADDRESS-OVERFLOW-4478-G,                              
                 :HOUSE-NO-4478-G,                                      
                 :ADDRESS-FORMAT-4478-G,                                
                 :STREET-NAME-4478-G,                                   
                 :STREET-SUFFIX-4478-G,                                 
                 :ZIP-CODE-4478-G,                                      
                 :ZIP-CODE-PLUS-FOUR-4478-G,                            
                 :ZIP-CODE-TOKEN-4478-G,                                
                 :SEND-TO-LOCOFF-IND-4478-G,                            
                 :ADDR-COUNTRY-4478-G,                                  
                 :CARRIER-ROUTE-4478,                                   
                 :FINAL-BILL-CY-ST-4478,                                
                 :FINAL-BILL-OVFL-4478,                                 
                 :DEPOSIT-AMT-4478-G,                                   
                 :FBILL-ADDR-TYPE-4478,                                 
                 :FBILL-ADDR-LINE-4478                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH RESULT_SET_CSR_4478G INTO                                   
MFA-TR*          :RETURN-CODE-4478-G,                                           
MFA-TR*          :ACCOUNT-NO-PRIOR-4478-G,                                      
MFA-TR*          :SERV-ORDER-NO-R-4478-G,                                       
MFA-TR*          :WANTED-BY-DATETIME-4478,                                      
MFA-TR*          :CREDIT-LETTER-IND-4478,                                       
MFA-TR*          :STREET-LOCATION-1-4478-G,                                     
MFA-TR*          :STREET-LOCATION-2-4478-G,                                     
MFA-TR*          :ADDR-ST-4478-G,                                               
MFA-TR*          :ADDR-ZIP-CODE-4478-G,                                         
MFA-TR*          :ADDR-PREFIX-1-4478-G,                                         
MFA-TR*          :ADDR-PREFIX-2-4478-G,                                         
MFA-TR*          :ADDR-SUFFIX-4478-G,                                           
MFA-TR*          :ADDRESS-OVERFLOW-4478-G,                                      
MFA-TR*          :HOUSE-NO-4478-G,                                              
MFA-TR*          :ADDRESS-FORMAT-4478-G,                                        
MFA-TR*          :STREET-NAME-4478-G,                                           
MFA-TR*          :STREET-SUFFIX-4478-G,                                         
MFA-TR*          :ZIP-CODE-4478-G,                                              
MFA-TR*          :ZIP-CODE-PLUS-FOUR-4478-G,                                    
MFA-TR*          :ZIP-CODE-TOKEN-4478-G,                                        
MFA-TR*          :SEND-TO-LOCOFF-IND-4478-G,                                    
MFA-TR*          :ADDR-COUNTRY-4478-G,                                          
MFA-TR*          :CARRIER-ROUTE-4478,                                           
MFA-TR*          :FINAL-BILL-CY-ST-4478,                                        
MFA-TR*          :FINAL-BILL-OVFL-4478,                                         
MFA-TR*          :DEPOSIT-AMT-4478-G,                                           
MFA-TR*          :FBILL-ADDR-TYPE-4478,                                         
MFA-TR*          :FBILL-ADDR-LINE-4478                                          
MFA-TR*    END-EXEC.                                                            

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4478-G NOT = 0 AND                    
                      RETURN-CODE-4478-G NOT = +100                     
                       MOVE RETURN-CODE-4478-G TO WS-ACTIVE-RETURN-CODE 
                       MOVE PROGRAM-NAME      TO ABEND-PROGRAM          
                       MOVE '5100'            TO ACTIVE-PARAGRAPH       
                       MOVE 'FETCH'           TO ABEND-FUNCTION         
                       MOVE 'CSR04478G'       TO TABLE-1                
                       MOVE 'SERV-ORDER-NO'   TO TABLE-ELEMENT-1        
                       MOVE SERV-ORDER-NO-4478 TO HOSTVAR-ELEMENT-1     
                       PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT        
                   END-IF                                               
                   IF RETURN-CODE-4478-G = 0                            
                      PERFORM 5170-PROCESS-4478G THRU 5170-EXIT         
                   ELSE                                                 
                      MOVE +100 TO S-RETURN-CODE-15                     
                   END-IF                                               
                 WHEN NOT-FOUND                                         
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5100'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04478G'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE.                                              
                                                                        
           MOVE 'Y'                TO SW-FETCH.                         
DT9511     PERFORM UNTIL NO-MORE-ROWS                                   
DT9511       EXEC SQL                                                   
DT9511          FETCH MSQ001_CUR_1 INTO                         
DT9511             :RETURN-CODE-4478-H,                                 
DT9511             :CONTRACT-ID-4478-H                                  
DT9511       END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4478H INTO                                 
MFA-TR*            :RETURN-CODE-4478-H,                                         
MFA-TR*            :CONTRACT-ID-4478-H                                          
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DT9511                                                                  
DT9511       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
DT9511       EVALUATE WS-ACTIVE-RETURN-CODE                             
DT9511           WHEN SUCCESSFUL-CALL                                   
DT9511              IF RETURN-CODE-4478-H NOT = 0 AND                   
DT9511                 RETURN-CODE-4478-H NOT = +100                    
DT9511                   MOVE RETURN-CODE-4478-H TO                     
DT9511                        WS-ACTIVE-RETURN-CODE                     
DT9511                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
DT9511                   MOVE '5100'            TO ACTIVE-PARAGRAPH     
DT9511                   MOVE 'FETCH'           TO ABEND-FUNCTION       
DT9511                   MOVE 'CSR04478H'       TO TABLE-1              
DT9511                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
DT9511                   MOVE ACCOUNT-NO-4478   TO HOSTVAR-ELEMENT-1    
DT9511                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
DT9511              END-IF                                              
DT9511              IF RETURN-CODE-4478-H = +100                        
DT9511                  SET NO-MORE-ROWS TO TRUE                        
DT9511              ELSE                                                
DT9511                  IF WS-GTT16-DECLARED = 'N'                      
DT9511                     PERFORM 0116-DECLARE-GTT16 THRU 0116-EXIT    
DT9511                  END-IF                                          
DT9511                  MOVE RETURN-CODE-4478-H TO S-RETURN-CODE-16     
DT9511                  MOVE CONTRACT-ID-4478-H TO S-CONTRACT-ID-16     
DT9511                  PERFORM 8880-SEND-RESULT-16 THRU 8880-EXIT      
DT9511              END-IF                                              
DT9511           WHEN NOT-FOUND                                         
DT9511               SET NO-MORE-ROWS TO TRUE                           
DT9511               MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
DT9511           WHEN OTHER                                             
DT9511               MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
DT9511               MOVE '5100'                TO ACTIVE-PARAGRAPH     
DT9511               MOVE 'FETCH'               TO ABEND-FUNCTION       
DT9511               MOVE 'CSR04478H'           TO TABLE-1              
DT9511               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
DT9511               MOVE ACCOUNT-NO-4478       TO HOSTVAR-ELEMENT-1    
DT9511               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
DT9511       END-EVALUATE                                               
DT9511     END-PERFORM.
MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_1
MSQ001        END-EXEC.
                                                 
DT9511 5100-EXIT.                                                       
DT9511      EXIT.                                                       
                                                                        
       5110-PROCESS-4478.                                               
                                                                        
           MOVE 0 TO S-RETURN-CODE-2.                                   
           MOVE BILL-ADDRESS-4478 TO S-BILL-ADDRESS.                    
           MOVE SPCL-READ-INST-4478 TO S-SPCL-READ-INST.                
           MOVE SPCL-INST-4478 TO S-SPCL-INST.                          
           MOVE PREM-DIRECTIONS-4478 TO S-PREM-DIRECTIONS.              
           MOVE SCRATCHPAD-4478 TO S-SCRATCHPAD.                        
           MOVE WS-NEXT-BUS-DAY TO S-NEXT-BUS-DAY.                      
           MOVE WS-ORDER-TYPE-CD TO S-HIGH-LEVEL-ORDER.                 
           MOVE WS-HARD-ERROR-FOUND TO S-HARD-ERROR.                    
           MOVE ADDRESS-ID-4478 TO S-ADDRESS-ID.                        
           MOVE ADDRESS-FORMAT-4478 TO S-ADDRESS-FORMAT.                
           MOVE ADDR-STREET-4478 TO S-ADDR-STREET.                      
           MOVE ADDR-CITY-STATE-4478 TO S-ADDR-CITY-STATE.              
           MOVE ADDR-ZIP-CODE-4478 TO S-ADDR-ZIP-CODE.                  
           MOVE ADDR-COUNTRY-4478 TO S-ADDR-COUNTRY.                    
           MOVE ADDR-STREET-2-4478 TO S-ADDR-STREET-2.                  
           MOVE HOUSE-NO-4478 TO S-HOUSE-NO.                            
           MOVE ADDR-PREFIX-1-4478 TO S-ADDR-PREFIX-1.                  
           MOVE ADDR-PREFIX-2-4478 TO S-ADDR-PREFIX-2.                  
           MOVE STREET-NAME-4478 TO S-STREET-NAME.                      
           MOVE STREET-SUFFIX-4478 TO S-STREET-SUFFIX.                  
           MOVE ADDR-SUFFIX-4478 TO S-ADDR-SUFFIX.                      
           MOVE STREET-LOCATION-1-4478 TO S-STREET-LOCATION-1.          
           MOVE STREET-LOCATION-2-4478 TO S-STREET-LOCATION-2.          
           MOVE ZIP-CODE-4478 TO S-ZIP-CODE.                            
           MOVE ZIP-CODE-PLUS-FOUR-4478 TO S-ZIP-CODE-PLUS-FOUR.        
           MOVE ZIP-CODE-TOKEN-4478 TO S-ZIP-CODE-TOKEN.                
           MOVE STATE-4478 TO S-STATE.                                  
           MOVE SUBDIVISION-ID-4478 TO S-SUBDIVISION-ID.                
           MOVE EST-BILL-DAY-4478 TO S-EST-BILL-DAY.                    
           MOVE EST-DUE-DAY-4478 TO S-EST-DUE-DAY.                      
           MOVE EMAIL-ADDRESS-4478 TO S-EMAIL-ADDRESS.                  
P0795B*    MOVE AT-PREMISE-NO TO S-PREMISE-NO.                                  
           MOVE WS-PREMISE-NO-NUM TO S-PREMISE-NO.                      
           MOVE WS-LL-CUSTOMER-NO TO S-LL-CUSTOMER-NO.                  
A04670     IF S-LL-CUSTOMER-NO = ZEROES AND                             
A04670        SI-CUSTOMER-NO > 0                                        
A04670            MOVE SI-CUSTOMER-NO TO S-LL-CUSTOMER-NO
           END-IF.              
A4670A     MOVE WS-CURR-ACCOUNT-NO TO S-CURR-ACCOUNT-NO.                
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       5110-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5120-PROCESS-4478B.                                              
                                                                        
           IF WS-GTT06-DECLARED = 'N'                                   
               PERFORM 0106-DECLARE-GTT06 THRU 0106-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-6.                              
           MOVE 0 TO S-RETURN-CODE-6.                                   
           MOVE CONTACT-TYPE-4478 TO S-CONTACT-TYPE.                    
           IF NAME-TYPE-4478 <= SPACES                                  
               MOVE CONTACT-TYPE-4478 TO S-NAME-TYPE                    
           ELSE                                                         
               MOVE NAME-TYPE-4478 TO S-NAME-TYPE
           END-IF.                      
           MOVE MATRIX-NAME-4478 TO S-MATRIX-NAME.                      
           PERFORM 8600-SEND-RESULT-6 THRU 8600-EXIT.                   
                                                                        
       5120-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5130-PROCESS-4478C.                                              
                                                                        
           IF WS-GTT09-DECLARED = 'N'                                   
               PERFORM 0109-DECLARE-GTT09 THRU 0109-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-9.                              
           MOVE 0 TO S-RETURN-CODE-9.                                   
           MOVE EQUIPMENT-NO-4478 TO S-EQUIPMENT-NO.                    
           MOVE APPLIANCE-CD-4478 TO S-APPLIANCE-CD.                    
           MOVE CAUTION-TAG-IND-4478 TO S-CAUTION-TAG-IND.              
           MOVE CUT-IND-4478 TO S-CUT-IND.                              
           MOVE TAG-NO-4478 TO S-TAG-NO.                                
           MOVE CONDITION-CD-4478 TO S-CONDITION-CD.                    
           MOVE LOCATION-CD-4478 TO S-LOCATION-CD.                      
           MOVE APPL-COMMENTS-4478 TO S-APPL-COMMENTS.                  
           MOVE CAUTION-TAG-DT-4478 TO S-CAUTION-TAG-DT.                
           MOVE SOURCE-SYSTEM-CD-4478 TO S-SOURCE-SYSTEM-CD.            
           MOVE INSTALL-DT-4478 TO S-INSTALL-DT.                        
           MOVE SERIAL-NO-4478 TO S-SERIAL-NO.                          
           MOVE CAD-VERIFY-DT-4478 TO S-CAD-VERIFY-DT.                  
           MOVE APPLIANCE-DESC-4478 TO S-APPLIANCE-DESC.                
           MOVE SEASONAL-RT-FL-4478 TO S-SEASONAL-RT-FL.                
           MOVE CRAWL-FL-4478 TO S-CRAWL-FL.                            
           MOVE APPL-LONG-DESC-4478 TO S-APPL-LONG-DESC.                
           MOVE PRIMARY-FUEL-CD-4478 TO S-PRIMARY-FUEL-CD.              
           MOVE AVERAGE-BTU-4478 TO S-AVERAGE-BTU.                      
D12436     IF WS-ORDER-TYPE-CHANGED = 'Y' AND                           
D12436         LINK-ORDER-TYPE-CD(1:3) = 'OFF'                          
D12436       MOVE 'N'              TO S-LIGHT-IND                       
D12436     ELSE                                                         
D12436       MOVE LIGHT-IND-4478   TO S-LIGHT-IND                       
D12436     END-IF                                                       
           MOVE LEAK-IND-4478    TO S-LEAK-IND                          
           MOVE REPAIR-IND-4478  TO S-REPAIR-IND.                       
           MOVE CUTOFF-IND-4478  TO S-CUTOFF-IND.                       
           MOVE REPLACE-APP-FL-4478 TO S-REPLACE-APP-FL.                
           PERFORM 8810-SEND-RESULT-9 THRU 8810-EXIT.                   
                                                                        
       5130-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5140-PROCESS-4478D.                                              
           MOVE RETURN-CODE-4478-D    TO S-RETURN-CODE-12               
           MOVE LINK-SERV-ORDER-NO TO S-SERV-ORDER-NO-12                
           IF WS-ORDER-TYPE-CHANGED = 'Y'                               
             IF LINK-ORDER-TYPE-CD = 'UMOFF' AND                        
                (ORDER-TYPE-CD-4478-D = 'UMRCC' OR 'UMROC')             
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDR000343' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  MOVE 'Y' TO WS-HARD-ERROR-FOUND                       
                  PERFORM 7025-RULE-XREF THRU 7025-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                     PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT          
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
DT9484       ELSE                                                       
DT9484          IF LINK-ORDER-TYPE-CD(1:3) = 'OFF' AND                  
DT9484             (ORDER-TYPE-CD-4478-D(1:2) = 'CC' OR 'OC')           
DT9484             PERFORM 7090-COUNT-PENDING-OFF THRU 7090-EXIT        
DT9484             IF WS-COUNT > 2                                      
DT9484               INITIALIZE GTT-RETURN-FIELDS-1                     
DT9484               MOVE 0 TO S-RETURN-CODE-1                          
DT9484               MOVE 'ORDR000003' TO S-BUS-RULE-ID                 
DT9484               MOVE 'F' TO S-ACTION-TYPE-CD                       
DT9484               MOVE 'Y' TO S-HARD-ERROR                           
DT9484               PERFORM 7025-RULE-XREF THRU 7025-EXIT              
DT9484               IF WS-GTT01-DECLARED = 'N'                         
DT9484                 PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT        
DT9484               END-IF                                             
DT9484               PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT          
DT9484             END-IF                                               
DT9484             MOVE LINK-ORDER-TYPE-CD   TO S-ORDER-TYPE-CD-12      
DT9484                                          S-HIGH-LEVEL-ORDER      
                ELSE                                                    
                  MOVE LINK-ORDER-TYPE-CD   TO S-ORDER-TYPE-CD-12       
                                               S-HIGH-LEVEL-ORDER       
                END-IF                                                  
             END-IF                                                     
            ELSE                                                        
             IF WS-OFF-TO-CC-CONVERT  = 'Y'                             
                  IF (ORDER-TYPE-CD-4478-D (1:3) = 'OFF')               
                      MOVE 'CC001'  TO S-ORDER-TYPE-CD-12               
                                      S-HIGH-LEVEL-ORDER                
                  ELSE                                                  
                      MOVE 'UMRCC'  TO S-ORDER-TYPE-CD-12               
                                      S-HIGH-LEVEL-ORDER                
                  END-IF                                                
                  INITIALIZE GTT-RETURN-FIELDS-1                        
                  MOVE 0 TO S-RETURN-CODE-1                             
                  MOVE 'ORDR000342' TO S-BUS-RULE-ID                    
                  MOVE 'P' TO S-ACTION-TYPE-CD                          
                  PERFORM 7025-RULE-XREF THRU 7025-EXIT                 
                  IF WS-GTT01-DECLARED = 'N'                            
                     PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT          
                  END-IF                                                
                  PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT             
             ELSE                                                       
                   MOVE ORDER-TYPE-CD-4478-D TO S-ORDER-TYPE-CD-12      
                                           S-HIGH-LEVEL-ORDER           
             END-IF                                                     
           END-IF                                                       
           MOVE ORDER-TYPE-CD-4478-D TO S-OLD-ORDER-TYPE-CD-12          
                                        WS-ORDER-TYPE-PRIOR             
           IF WS-ORDER-TYPE-CHANGED = 'Y'                               
              PERFORM 7056-SAME-DAY-ORDER-PRIOR THRU 7056-EXIT          
           END-IF                                                       
DT9484     IF WS-ORDER-TYPE-CHANGED = 'Y' AND                           
DT9484        LINK-ORDER-TYPE-CD(1:3) = 'OFF' AND                       
DT9494        (ORDER-TYPE-CD-4478-D(1:2) = 'CC' OR 'OC') AND            
DT9484        ORDER-REASON-4478 = WS-REVERT                             
DT9484        MOVE SPACES            TO S-ORDER-REASON-12               
DT9484     ELSE                                                         
              MOVE ORDER-REASON-4478 TO S-ORDER-REASON-12               
DT9484     END-IF                                                       
           MOVE STATUS-TX-4478 TO S-STATUS-TX-12                        
           IF LINK-ORDER-STATE-CD > SPACES                              
              MOVE LINK-ORDER-STATE-CD  TO S-ORDER-STATE-CD-12          
           ELSE                                                         
              MOVE ORDER-STATE-CD-4478 TO S-ORDER-STATE-CD-12           
           END-IF                                                       
           MOVE ORDER-PLACED-BY-4478 TO S-ORDER-PLACED-BY-12            
           MOVE PHONE-NO-4478 TO S-PHONE-NO-12                          
           MOVE PHONE-NO-EXT-4478 TO S-PHONE-NO-EXT-12                  
           MOVE WANTED-BY-DATE-4478 TO S-WANTED-BY-DATE-12              
           MOVE ASSIGNED-DATE-4478 TO S-ASSIGNED-DATE-12                
           MOVE CALL-BEFORE-MINUTS-4478 TO S-CALL-BEFORE-MINUTS-12      
           MOVE WORK-AREA-ID-4478 TO S-WORK-AREA-ID-12                  
                                     S-WORK-AREA-2.                     
           MOVE BREAKERS-OFF-IND-4478 TO S-BREAKERS-OFF-IND-12          
           MOVE INIT-BY-CNTRCT-IND-4478 TO S-INIT-BY-CNTRCT-IND-12      
           MOVE NOTIFY-CSR-IND-4478 TO S-NOTIFY-CSR-IND-12              
           MOVE NOTIFY-CUST-IND-4478 TO S-NOTIFY-CUST-IND-12            
           MOVE ORDER-PRIORITY-CD-4478 TO S-ORDER-PRIORITY-CD-12        
           IF WS-ORDER-TYPE-CHANGED = 'Y'                               
              MOVE C2-PRIORITY-CD TO S-ORDER-PRIORITY-CD-12             
           END-IF                                                       
           MOVE STD-LABOR-CHRG-4478  TO S-STD-LABOR-CHRG-12             
           IF  WS-ORDER-TYPE-CHANGED = 'Y'                              
             MOVE LINK-WORK-TYPE-CD   TO S-WORK-TYPE-CD-4-12            
                                         S-UNMTR-WORK-TYPE              
           ELSE                                                         
             MOVE WORK-TYPE-CD-4-4478 TO S-WORK-TYPE-CD-4-12            
                                         S-UNMTR-WORK-TYPE              
D00087       IF LINK-ACCOUNT-NO   = '0000000000000' AND                 
D00087          LINK-WORK-TYPE-CD = SPACES                              
D00087          MOVE WORK-TYPE-CD-4-4478 TO WS-WORK-TYPE                
D00087       END-IF                                                     
           END-IF                                                       
           MOVE BACK-DATED-IND-4478 TO S-BACK-DATED-IND-12              
           MOVE DEPOSIT-AMT-4478 TO S-DEPOSIT-AMT-12                    
           MOVE ORDER-RECVED-BY-4478 TO S-ORDER-RECVED-BY-12            
           MOVE VERIFY-RATE-4478 TO S-VERIFY-RATE-12                    
           MOVE PREMISE-NO-4478-D TO S-PREMISE-NO-12                    
           MOVE ACCOUNT-NO-4478-D TO S-ACCOUNT-NO-12                    
           MOVE ACCOUNT-NO-PRIOR-4478 TO S-ACCOUNT-NO-PRIOR-12          
           MOVE BEGIN-APPT-DATE-4478 TO S-BEGIN-APPT-DATE-12            
           MOVE SO-EST-LABOR-HR-4478 TO S-SO-EST-LABOR-HR-12            
           MOVE CUSTCHG-ORD-TYPE-FL-4478 TO S-CUSTCHG-ORD-TYPE-FL-12    
           MOVE AMOUNT-DISC-BAL-4478 TO S-AMOUNT-DISC-BAL-12            
           MOVE CURRENT-DATE-4478 TO S-CURRENT-DATE-12                  
           MOVE CODE-UTIL-TYPE-4478-D TO S-CODE-UTIL-TYPE-12-D          
D00087     IF LINK-ACCOUNT-NO   = '0000000000000' AND                   
D00087        LINK-CODE-UTIL-TYPE = SPACES                              
D00087          MOVE CODE-UTIL-TYPE-4478-D  TO WS-CODE-UTIL-TYPE        
D00087     END-IF                                                       
           MOVE PRICE-PER-SERV-4478  TO S-PRICE-PER-SERV-12             
           MOVE ACCOUNT-TYPE-DESC-4478 TO S-ACCOUNT-TYPE-DESC-12        
           MOVE ORDER-CHARGE-AMT-4478 TO S-ORDER-CHARGE-AMT-12          
           MOVE TOTAL-CHARGES-AMT-4478 TO S-TOTAL-CHARGES-AMT-12        
           MOVE CUST-CNT-ID-4478 TO S-CUST-CNT-ID-12                    
           MOVE MTR-ACCESSIBLE-CD-4478 TO S-MTR-ACCESSIBLE-CD-12        
           MOVE MTR-ACCESSIBLE-DT-4478 TO S-MTR-ACCESSIBLE-DT-12        
           MOVE MTR-ACCESSIBLE-RSN-4478 TO S-MTR-ACCESSIBLE-RSN-12      
           MOVE SOURCE-SYSTEM-CD-4478-D TO S-SOURCE-SYSTEM-CD-12        
           MOVE ALT-PHONE-NO-4478 TO S-ALT-PHONE-NO-12                  
           MOVE ALT-PHONE-NO-EXT-4478 TO S-ALT-PHONE-NO-EXT-12          
           MOVE HOME-ALL-DAY-FL-4478 TO S-HOME-ALL-DAY-FL-12            
           MOVE BUSINESS-UNIT-4478 TO S-BUSINESS-UNIT-12                
                                      S-BUSINESS-UNIT-2                 
           MOVE OPTIMIZE-ORDER-4478 TO S-OPTIMIZE-ORDER-12.             
           MOVE END-APPT-DATE-4478 TO S-END-APPT-DATE-12.               
           MOVE AM-PM-APPT-CD-4478 TO S-AM-PM-APPT-CD-12.               
           MOVE MTR-TURNOFF-RSN-CD-4478 TO S-MTR-TURNOFF-RSN-CD-12.     
           MOVE FUEL-CHNG-RSN-CD-4478 TO S-FUEL-CHNG-RSN-CD-12.         
           MOVE FUEL-CHNG-TYPE-CD-4478 TO S-FUEL-CHNG-TYPE-CD-12.       
           MOVE TURNOFF-COMMENTS-4478  TO S-TURNOFF-COMMENTS-12.        
           MOVE WORK-DISTRICT-4478     TO S-WORK-DISTRICT-12.           
DT9528     MOVE CODES-DATA-PRESENT-4478 TO S-CODES-DATA-PRESENT-12.     
DT9519     MOVE CANCEL-REASON-CD-4478 TO S-CANCEL-REASON-CD-12.         
D26359     MOVE SO-MTR-ROW-EXISTS-4478 TO S-SO-MTR-ROW-EXISTS-12.       
                                                                        
       5140-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5150-PROCESS-4478E.                                              
                                                                        
           IF WS-GTT13-DECLARED = 'N'                                   
               PERFORM 0113-DECLARE-GTT13 THRU 0113-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-13.                             
           MOVE 0 TO S-RETURN-CODE-13                                   
           MOVE SERV-ORDER-NO-4478-E TO S-SERV-ORDER-NO-13              
           MOVE REMARK-TYPE-CD TO S-REMARK-TYPE-CD-13                   
           MOVE REMARK-TX  TO S-REMARK-TX-13                            
           PERFORM 8850-SEND-RESULT-13 THRU 8850-EXIT.                  
                                                                        
       5150-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5160-PROCESS-4478F.                                              
           MOVE RETURN-CODE-4478-F         TO S-RETURN-CODE-14          
           MOVE TO-ACCT-NO-4478            TO S-TO-ACCT-NO-14           
           MOVE ROOMMATE-XFER-IND-4478     TO S-ROOMMATE-XFER-IND-14    
           MOVE EPP-XFER-IND-4478          TO S-EPP-XFER-IND-14         
           MOVE DEPOSIT-XFER-IND-4478      TO S-DEPOSIT-XFER-IND-14     
           MOVE OTHER-AR-XFER-IND-4478     TO S-OTHER-AR-XFER-IND-14    
           MOVE PROJ-SHR-XFER-IND-4478     TO S-PROJ-SHR-XFER-IND-14    
           MOVE WRITE-OFF-XFER-IND-4478    TO S-WRITE-OFF-XFER-IND-14   
           MOVE IN-LIEU-XFER-IND-4478      TO S-IN-LIEU-XFER-IND-14     
           MOVE WHT-CROSS-XFER-IND-4478    TO S-WHT-CROSS-XFER-IND-14   
           MOVE COAPPL-XFER-IND-4478       TO S-COAPPL-XFER-IND-14      
           MOVE MED-CERT-XFER-IND-4478     TO S-MED-CERT-XFER-IND-14    
           MOVE NAME-FORMAT-4478           TO S-NAME-FORMAT-14          
           MOVE FIRST-NAME-4478            TO S-FIRST-NAME-14           
           MOVE MIDDLE-NAME-4478           TO S-MIDDLE-NAME-14          
           MOVE LAST-NAME-4478             TO S-LAST-NAME-14            
           MOVE FULL-NAME-4478             TO S-FULL-NAME-14            
           MOVE HOUSE-NO-4478-F            TO S-HOUSE-NO-14             
           MOVE ADDR-PREFIX-1-4478-F       TO S-ADDR-PREFIX-1-14        
           MOVE ADDR-PREFIX-2-4478-F       TO S-ADDR-PREFIX-2-14        
           MOVE STREET-NAME-4478-F         TO S-STREET-NAME-14          
           MOVE STREET-LOCATION-1-4478-F   TO S-STREET-LOCATION-1-14    
           MOVE STREET-LOCATION-2-4478-F   TO S-STREET-LOCATION-2-14    
           MOVE STREET-SUFFIX-4478-F       TO S-STREET-SUFFIX-14        
           MOVE CUSTOMER-FROM-4478         TO S-CUSTOMER-FROM-14.       
                                                                        
       5160-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5170-PROCESS-4478G.                                              
           MOVE RETURN-CODE-4478-G         TO S-RETURN-CODE-15          
           MOVE ACCOUNT-NO-PRIOR-4478-G    TO  S-ACCOUNT-NO-PRIOR-15    
           MOVE SERV-ORDER-NO-R-4478-G     TO S-SERV-ORDER-NO-15        
           MOVE WANTED-BY-DATETIME-4478    TO S-WANTED-BY-DATETIME-15   
           MOVE CREDIT-LETTER-IND-4478     TO S-CREDIT-LETTER-IND-15    
           MOVE STREET-LOCATION-1-4478-G   TO S-STREET-LOCATION-1-15    
           MOVE STREET-LOCATION-2-4478-G   TO S-STREET-LOCATION-2-15    
           MOVE ADDR-ST-4478-G             TO S-ADDR-ST-15              
           MOVE ADDR-ZIP-CODE-4478-G       TO S-ADDR-ZIP-CODE-15        
           MOVE ADDR-PREFIX-1-4478-G       TO S-ADDR-PREFIX-1-15        
           MOVE ADDR-PREFIX-2-4478-G       TO S-ADDR-PREFIX-2-15        
           MOVE ADDR-SUFFIX-4478-G         TO S-ADDR-SUFFIX-15          
           MOVE ADDRESS-OVERFLOW-4478-G    TO S-ADDRESS-OVERFLOW-15     
           MOVE HOUSE-NO-4478-G            TO S-HOUSE-NO-15             
           MOVE ADDRESS-FORMAT-4478-G      TO S-ADDRESS-FORMAT-15       
           MOVE STREET-NAME-4478-G         TO S-STREET-NAME-15          
           MOVE STREET-SUFFIX-4478-G       TO S-STREET-SUFFIX-15        
           MOVE ZIP-CODE-4478-G            TO S-ZIP-CODE-15             
           MOVE ZIP-CODE-PLUS-FOUR-4478-G  TO S-ZIP-CODE-PLUS-FOUR-15   
           MOVE ZIP-CODE-TOKEN-4478-G      TO S-ZIP-CODE-TOKEN-15       
           MOVE SEND-TO-LOCOFF-IND-4478-G  TO S-SEND-TO-LOCOFF-IND-15   
           MOVE ADDR-COUNTRY-4478-G        TO S-ADDR-COUNTRY-15         
           MOVE CARRIER-ROUTE-4478         TO S-CARRIER-ROUTE-15        
           MOVE FINAL-BILL-CY-ST-4478      TO S-FINAL-BILL-CY-ST-15     
           MOVE FINAL-BILL-OVFL-4478       TO S-FINAL-BILL-OVFL-15      
           MOVE DEPOSIT-AMT-4478-G         TO S-DEPOSIT-AMT-15.         
           MOVE FBILL-ADDR-TYPE-4478       TO S-FBILL-ADDR-TYPE-15.     
           MOVE FBILL-ADDR-LINE-4478       TO S-FBILL-ADDR-LINE-15.     
                                                                        
       5170-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5200-CALL-CSR04479.                                              
                                                                        
           INITIALIZE WS-BUILD-INPUT-PARMS.                             
           MOVE WS-ACCOUNT-NO TO ACCOUNT-NO-4479.                       
           MOVE WS-PREMISE-NO TO PREMISE-NO-4479.                       
P00795     MOVE WS-ORDER-TYPE-CD TO ORDER-TYPE-CD-4479.                 
           IF S-REVERT-FL = 'Y'                                         
               MOVE 'START' TO PROCESS-4479                             
           ELSE                                                         
             IF WS-CC-TO-OFF-CONVERT = 'Y'                              
                MOVE 'STOP' TO PROCESS-4479                             
             ELSE                                                       
               MOVE LINK-PROCESS TO PROCESS-4479                        
             END-IF                                                     
           END-IF                                                       
           MOVE WS-NEXT-BUS-DAY TO ASSIGNED-DATE-IN-4479.               
           MOVE PROGRAM-NAME TO PROGRAM-ID-4479.                        
MAINTN     MOVE LINK-SERV-ORDER-NO  TO SERV-ORDER-NO-4479.              
MAINTN     MOVE LINK-CURRENT-HISTORY-FL TO CURRENT-HISTORY-FL-4479.     
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04479                                             
      *           (:ACCOUNT-NO-4479,                                    
      *            :PREMISE-NO-4479,                                    
      *            :PROCESS-4479,                                       
      *            :ASSIGNED-DATE-IN-4479,                              
      *            :PROGRAM-ID-4479,                                    
P00795*            :ORDER-TYPE-CD-4479,                                 
MAINTN*            :SERV-ORDER-NO-4479,                                 
MAINTN*            :CURRENT-HISTORY-FL-4479)                            
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_CUR_2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_CUR_2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_CUR_2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5200'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04479'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4479A, :LOC4479B, :LOC4479C, :LOC4479D, :LOC4479E)   
      *       WITH PROCEDURE CSR04479                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479A CURSOR FOR RESULT SET       
      *       :LOC4479A                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479B CURSOR FOR RESULT SET       
      *       :LOC4479B                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479C CURSOR FOR RESULT SET       
      *       :LOC4479C                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479D CURSOR FOR RESULT SET       
      *       :LOC4479D                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4479E CURSOR FOR RESULT SET       
      *       :LOC4479E                                                 
      *    END-EXEC.                                                    
                                                                        
           MOVE 'Y'                TO SW-FETCH.                         
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_2 INTO                         
                   :RETURN-CODE-4479-A,                                 
                   :ASSIGNED-DATE-OUT-4479,                             
                   :SERV-ORDER-NO-4479-A,                               
                   :OUT-ORDER-TYPE-CD-4479,                             
                   :ORDER-STATE-CD-4479,                                
                   :CUSTOMER-NAME-4479,                                 
                   :REMARKS-4479,                                       
                   :WORK-AREA-4479,                                     
                   :PHONE-4479,                                         
                   :REMARK-TYPE-4479,                                   
                   :SERV-ORDER-STATUS-4479                              
P00718*            :BUSINESS-UNIT-4479                                          
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479A INTO                                 
MFA-TR*            :RETURN-CODE-4479-A,                                         
MFA-TR*            :ASSIGNED-DATE-OUT-4479,                                     
MFA-TR*            :SERV-ORDER-NO-4479-A,                                       
MFA-TR*            :OUT-ORDER-TYPE-CD-4479,                                     
MFA-TR*            :ORDER-STATE-CD-4479,                                        
MFA-TR*            :CUSTOMER-NAME-4479,                                         
MFA-TR*            :REMARKS-4479,                                               
MFA-TR*            :WORK-AREA-4479,                                             
MFA-TR*            :PHONE-4479,                                                 
MFA-TR*            :REMARK-TYPE-4479,                                           
MFA-TR*            :SERV-ORDER-STATUS-4479                                      
MFA-TR*            :BUSINESS-UNIT-4479                                          
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4479-A NOT = 0 AND                   
                       RETURN-CODE-4479-A NOT = +100                    
                         MOVE RETURN-CODE-4479-A TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479A'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-A = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5210-PROCESS-4479A THRU 5210-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479A'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_2
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           MOVE +1 TO WS-SUB1.                                          
P00795*    MOVE  1 TO WS-ORIG-UTIL-COUNT.                                       
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_2 INTO                         
                   :RETURN-CODE-4479-B,                                 
                   :CODE-UTIL-TYPE-4479-B,                              
                   :METER-NO-4479-B,                                    
                   :RATE-PLAN-4479-B,                                   
                   :SUPPLIES-4479,                                      
                   :METER-LOC-4479,                                     
                   :METER-STATUS-4479,                                  
                   :METER-STATUS-REASON-4479,                           
                   :WORK-TYPE-CD-4479-B,                                
                   :METER-READ-INST-4479,                               
                   :METER-IND-4479,                                     
                   :IC-NO-4479-B,                                       
                   :MTR-REF-NO-4479-B,                                  
                   :CODE-REV-CLASS-4479-B,                              
                   :GAS-MTRS-COUNT-4479,                                
                   :ELEC-MTRS-COUNT-4479,                               
                   :RLSE-IND-4479-B,                                    
                   :RLSE-NO-4479-B,                                     
                   :SO-SEQ-NO-4479-B                                    
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479B INTO                                 
MFA-TR*            :RETURN-CODE-4479-B,                                         
MFA-TR*            :CODE-UTIL-TYPE-4479-B,                                      
MFA-TR*            :METER-NO-4479-B,                                            
MFA-TR*            :RATE-PLAN-4479-B,                                           
MFA-TR*            :SUPPLIES-4479,                                              
MFA-TR*            :METER-LOC-4479,                                             
MFA-TR*            :METER-STATUS-4479,                                          
MFA-TR*            :METER-STATUS-REASON-4479,                                   
MFA-TR*            :WORK-TYPE-CD-4479-B,                                        
MFA-TR*            :METER-READ-INST-4479,                                       
MFA-TR*            :METER-IND-4479,                                             
MFA-TR*            :IC-NO-4479-B,                                               
MFA-TR*            :MTR-REF-NO-4479-B,                                          
MFA-TR*            :CODE-REV-CLASS-4479-B,                                      
MFA-TR*            :GAS-MTRS-COUNT-4479,                                        
MFA-TR*            :ELEC-MTRS-COUNT-4479,                                       
MFA-TR*            :RLSE-IND-4479-B,                                            
MFA-TR*            :RLSE-NO-4479-B,                                             
MFA-TR*            :SO-SEQ-NO-4479-B                                            
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4479-B NOT = 0 AND                   
                       RETURN-CODE-4479-B NOT = +100                    
                         MOVE RETURN-CODE-4479-B TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479B'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-B = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5220-PROCESS-4479B THRU 5220-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                     MOVE WS-SAME-DAY-FL TO S-SAME-DAY-FL               
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479B'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_2
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_2 INTO                         
                   :RETURN-CODE-4479-C,                                 
                   :SERV-ORDER-NO-4479-C,                               
                   :CODE-UTIL-TYPE-4479-C,                              
                   :WORK-TYPE-CD-4479-C,                                
                   :IC-NO-4479-C,                                       
                   :METER-NO-4479-C,                                    
                   :MTR-REF-NO-4479-C                                   
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479C INTO                                 
MFA-TR*            :RETURN-CODE-4479-C,                                         
MFA-TR*            :SERV-ORDER-NO-4479-C,                                       
MFA-TR*            :CODE-UTIL-TYPE-4479-C,                                      
MFA-TR*            :WORK-TYPE-CD-4479-C,                                        
MFA-TR*            :IC-NO-4479-C,                                               
MFA-TR*            :METER-NO-4479-C,                                            
MFA-TR*            :MTR-REF-NO-4479-C                                           
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4479-C NOT = 0 AND                   
                       RETURN-CODE-4479-C NOT = +100                    
                         MOVE RETURN-CODE-4479-C TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479C'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-C = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5230-PROCESS-4479C THRU 5230-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479C'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_2
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_2 INTO                         
                   :RETURN-CODE-4479-D,                                 
                   :RATE-PLAN-4479-D,                                   
                   :RATE-ITEM-CODE-4479,                                
                   :CODE-PLAN-STATUS-4479,                              
                   :CODE-STATUS-REASON-4479,                            
                   :MONTHLY-AMOUNT-4479,                                
                   :NO-UNITS-4479,                                      
                   :SUBDIVISION-FL-4479,                                
                   :IC-NO-4479-D,                                       
                   :RATE-PLAN-DESC-4479-D,                              
                   :SERVICE-TYPE-4479,                                  
                   :DIST-NO-4479,                                       
                   :POLE-NO-4479                                        
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479D INTO                                 
MFA-TR*            :RETURN-CODE-4479-D,                                         
MFA-TR*            :RATE-PLAN-4479-D,                                           
MFA-TR*            :RATE-ITEM-CODE-4479,                                        
MFA-TR*            :CODE-PLAN-STATUS-4479,                                      
MFA-TR*            :CODE-STATUS-REASON-4479,                                    
MFA-TR*            :MONTHLY-AMOUNT-4479,                                        
MFA-TR*            :NO-UNITS-4479,                                              
MFA-TR*            :SUBDIVISION-FL-4479,                                        
MFA-TR*            :IC-NO-4479-D,                                               
MFA-TR*            :RATE-PLAN-DESC-4479-D,                                      
MFA-TR*            :SERVICE-TYPE-4479,                                          
MFA-TR*            :DIST-NO-4479,                                               
MFA-TR*            :POLE-NO-4479                                                
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4479-D NOT = 0 AND                   
                       RETURN-CODE-4479-D NOT = +100                    
                         MOVE RETURN-CODE-4479-D TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479D'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-D = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5240-PROCESS-4479D THRU 5240-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479D'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_2
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_2 INTO                         
                   :RETURN-CODE-4479-E,                                 
                   :CODE-UTIL-TYPE-4479-E,                              
                   :IC-NO-4479-E,                                       
                   :RATE-PLAN-4479-E,                                   
                   :CODE-REV-CLASS-4479-E,                              
                   :RATE-PLAN-DESC-4479-E,                              
                   :TOU-FL-4479,                                        
                   :FIXED-FACTOR-FL-4479,                               
                   :BILL-CONTRACT-FL-4479,                              
                   :INTERRUPT-FL-4479,                                  
                   :READ-ROUTE-4479                                     
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4479E INTO                                 
MFA-TR*            :RETURN-CODE-4479-E,                                         
MFA-TR*            :CODE-UTIL-TYPE-4479-E,                                      
MFA-TR*            :IC-NO-4479-E,                                               
MFA-TR*            :RATE-PLAN-4479-E,                                           
MFA-TR*            :CODE-REV-CLASS-4479-E,                                      
MFA-TR*            :RATE-PLAN-DESC-4479-E,                                      
MFA-TR*            :TOU-FL-4479,                                                
MFA-TR*            :FIXED-FACTOR-FL-4479,                                       
MFA-TR*            :BILL-CONTRACT-FL-4479,                                      
MFA-TR*            :INTERRUPT-FL-4479,                                          
MFA-TR*            :READ-ROUTE-4479                                             
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4479-E NOT = 0 AND                   
                       RETURN-CODE-4479-E NOT = +100                    
                         MOVE RETURN-CODE-4479-E TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5200'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04479E'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4479   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4479-E = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
                        PERFORM 5250-PROCESS-4479E THRU 5250-EXIT       
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5200'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04479E'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4479       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_2
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5210-PROCESS-4479A.                                              
                                                                        
           IF WS-GTT03-DECLARED = 'N'                                   
               PERFORM 0103-DECLARE-GTT03 THRU 0103-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-3.                              
           MOVE 0 TO S-RETURN-CODE-3.                                   
           MOVE ASSIGNED-DATE-OUT-4479 TO S-ASSIGNED-DATE.              
           MOVE SERV-ORDER-NO-4479-A TO S-SERV-ORDER-NO-3.              
           MOVE OUT-ORDER-TYPE-CD-4479 TO S-ORDER-TYPE-CD.              
           MOVE ORDER-STATE-CD-4479 TO S-ORDER-STATE-CD.                
           MOVE CUSTOMER-NAME-4479 TO S-CUSTOMER-NAME.                  
           MOVE REMARKS-4479 TO S-REMARKS.                              
           MOVE WORK-AREA-4479 TO S-WORK-AREA-3.                        
P00718*    MOVE BUSINESS-UNIT-4479 TO S-BUSINESS-UNIT-3.                        
           MOVE PHONE-4479 TO S-PHONE.                                  
           MOVE REMARK-TYPE-4479 TO S-REMARK-TYPE.                      
           MOVE SERV-ORDER-STATUS-4479 TO S-SERV-ORDER-STATUS.          
           PERFORM 8300-SEND-RESULT-3 THRU 8300-EXIT.                   
                                                                        
A4670B     IF OUT-ORDER-TYPE-CD-4479(1:2) = 'CC' OR 'NC'                
A4670B         MOVE 'Y' TO WS-START-EXISTS-FL
           END-IF.                          
A4670B     IF OUT-ORDER-TYPE-CD-4479(1:3) = 'OFF'                       
A4670B         MOVE 'Y' TO WS-STOP-EXISTS-FL
           END-IF.                           
                                                                        
A4670B     IF START-EXISTS-YES AND STOP-EXISTS-YES AND                  
MAINTN        WS-OFF-TO-CC-CONVERT = 'N' AND                            
MAINTN        LINK-PROCESS NOT = WS-MAINTAIN                            
A4670B         INITIALIZE GTT-RETURN-FIELDS-1                           
A4670B         MOVE 0 TO S-RETURN-CODE-1                                
A4670B         MOVE 'ORDR000156' TO S-BUS-RULE-ID                       
A4670B         MOVE 'P' TO S-ACTION-TYPE-CD                             
A4670B         PERFORM 7025-RULE-XREF THRU 7025-EXIT                    
A4670B         IF WS-GTT01-DECLARED = 'N'                               
A4670B             PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT            
A4670B         END-IF                                                   
A4670B         PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
           END-IF.               
                                                                        
           IF WS-NEXT-BUS-DAY = ASSIGNED-DATE-OUT-4479                  
               IF (WS-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC') AND            
                   OUT-ORDER-TYPE-CD-4479(1:3) = 'OFF'  AND             
MAINTN             WS-OFF-TO-CC-CONVERT = 'N' AND                       
MAINTN             LINK-PROCESS NOT = WS-MAINTAIN                       
                       INITIALIZE GTT-RETURN-FIELDS-1                   
                       MOVE 0 TO S-RETURN-CODE-1                        
                       MOVE 'ORDR000063' TO S-BUS-RULE-ID               
                       MOVE 'P' TO S-ACTION-TYPE-CD                     
                       PERFORM 7025-RULE-XREF THRU 7025-EXIT            
                       IF WS-GTT01-DECLARED = 'N'                       
                           PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT    
                       END-IF                                           
                       PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT        
MAINTN* NEW MESSAGE FOR 8060 USERS                                              
                       INITIALIZE GTT-RETURN-FIELDS-1                   
                       MOVE 0 TO S-RETURN-CODE-1                        
                       MOVE 'ORDR000348' TO S-BUS-RULE-ID               
                       MOVE 'P' TO S-ACTION-TYPE-CD                     
                       PERFORM 7025-RULE-XREF THRU 7025-EXIT            
                       IF WS-GTT01-DECLARED = 'N'                       
                           PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT    
                       END-IF                                           
                       PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT        
               END-IF                                                   
               IF WS-ORDER-TYPE-CD(1:3) = 'OFF' AND                     
                 (OUT-ORDER-TYPE-CD-4479(1:2) = 'CC' OR 'NC') AND       
MAINTN             LINK-PROCESS NOT = WS-MAINTAIN                       
                       INITIALIZE GTT-RETURN-FIELDS-1                   
                       MOVE 0 TO S-RETURN-CODE-1                        
                       MOVE 'ORDR000064' TO S-BUS-RULE-ID               
                       MOVE 'P' TO S-ACTION-TYPE-CD                     
                       PERFORM 7025-RULE-XREF THRU 7025-EXIT            
                       IF WS-GTT01-DECLARED = 'N'                       
                           PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT    
                       END-IF                                           
                       PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
               END-IF
           END-IF.       
                                                                        
A04670     IF ASSIGNED-DATE-OUT-4479 > WS-NEXT-BUS-DAY                  
A04670        IF (WS-ORDER-TYPE-CD(1:2) = 'CC' OR 'NC') AND             
A04670            OUT-ORDER-TYPE-CD-4479(1:3) = 'OFF' AND               
MAINTN             WS-OFF-TO-CC-CONVERT = 'N' AND                       
MAINTN             LINK-PROCESS NOT = WS-MAINTAIN                       
A04670                INITIALIZE GTT-RETURN-FIELDS-1                    
A04670                MOVE 0 TO S-RETURN-CODE-1                         
A04670                MOVE 'ORDR000152' TO S-BUS-RULE-ID                
A04670                MOVE 'P' TO S-ACTION-TYPE-CD                      
A04670                PERFORM 7025-RULE-XREF THRU 7025-EXIT             
A04670                IF WS-GTT01-DECLARED = 'N'                        
A04670                    PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
A04670                END-IF                                            
A04670                PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT         
A04670*  A NEW MESSGE FOR 8060 USERS                                            
A04670                INITIALIZE GTT-RETURN-FIELDS-1                    
A04670                MOVE 0 TO S-RETURN-CODE-1                         
A04670                MOVE 'ORDR000347' TO S-BUS-RULE-ID                
A04670                MOVE 'P' TO S-ACTION-TYPE-CD                      
A04670                PERFORM 7025-RULE-XREF THRU 7025-EXIT             
A04670                IF WS-GTT01-DECLARED = 'N'                        
A04670                    PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
A04670                END-IF                                            
A04670                PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT         
A04670         END-IF                                                   
A04670         IF WS-ORDER-TYPE-CD(1:3) = 'OFF' AND                     
A04670           (OUT-ORDER-TYPE-CD-4479(1:2) = 'CC' OR 'NC') AND       
MAINTN             LINK-PROCESS NOT = WS-MAINTAIN                       
A04670                INITIALIZE GTT-RETURN-FIELDS-1                    
A04670                MOVE 0 TO S-RETURN-CODE-1                         
A04670                MOVE 'ORDR000153' TO S-BUS-RULE-ID                
A04670                MOVE 'P' TO S-ACTION-TYPE-CD                      
A04670                PERFORM 7025-RULE-XREF THRU 7025-EXIT             
A04670                IF WS-GTT01-DECLARED = 'N'                        
A04670                    PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT     
A04670                END-IF                                            
A04670                PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT
               END-IF
           END-IF.        
                                                                        
       5210-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5220-PROCESS-4479B.                                              
                                                                        
           IF WS-GTT04-DECLARED = 'N'                                   
               PERFORM 0104-DECLARE-GTT04 THRU 0104-EXIT
           END-IF.               
                                                                        
           MOVE 'N' TO WS-WORK-TYPE-INCLUDED.                           
           INITIALIZE GTT-RETURN-FIELDS-4.                              
           MOVE 0 TO S-RETURN-CODE-4.                                   
           MOVE CODE-UTIL-TYPE-4479-B TO S-CODE-UTIL-TYPE-4             
                                       WS-CODE-UTIL-TYPE-SUB (WS-SUB1). 
           MOVE METER-NO-4479-B TO S-METER-NO-4.                        
           MOVE RATE-PLAN-4479-B TO S-RATE-PLAN-4.                      
           MOVE SUPPLIES-4479 TO S-SUPPLIES.                            
           MOVE METER-LOC-4479 TO S-METER-LOC.                          
           MOVE METER-STATUS-4479 TO S-METER-STATUS                     
                                     WS-METER-STATUS-SUB (WS-SUB1).     
           MOVE METER-STATUS-REASON-4479 TO S-METER-STATUS-REASON.      
           MOVE WORK-TYPE-CD-4479-B TO S-OLD-WORK-TYPE-CD-4             
                                       WS-WORK-TYPE-PRIOR               
P00795     IF ((LINK-PROCESS = 'START' OR 'STOP')  AND                  
P00795        (LINK-ORDER-TYPE-CD <= SPACES OR                          
P00795         LINK-ORDER-TYPE-CD (1:2) = 'NC')) OR                     
P00795         (LINK-PROCESS = WS-MAINTAIN AND                          
MAINTN           WS-ORDER-TYPE-CHANGED = 'N'OR                          
MAINTN           WS-CC-TO-OFF-CONVERT = 'Y')                            
DT6878          IF (SEB-DATABASE AND WORK-TYPE-CD-4479-B <= SPACES)     
DT6878             MOVE LINK-WORK-TYPE-CD TO WORK-TYPE-CD-4479-B        
DT6878          END-IF                                                  
P00795          MOVE WORK-TYPE-CD-4479-B TO S-WORK-TYPE-CD-4            
P00795                                  WS-WORK-TYPE-SUB (WS-SUB1)      
P00795     ELSE                                                         
P00795        IF LINK-CODE-UTIL-TYPE = CODE-UTIL-TYPE-4479-B            
P00795           IF ((LINK-PROCESS = 'AOO' AND                          
P00795               LINK-ORDER-TYPE-CD NOT = 'FM002') OR               
P00795              (SEB-DATABASE                     AND               
P00795               (LINK-PROCESS = 'START' OR 'STOP')) OR             
MAINTN              (LINK-PROCESS = 'MAINTAIN')) AND                    
P00795              ((LINK-CODE-UTIL-TYPE = 'G' AND                     
P00795                      GAS-MTRS-COUNT-4479 = 1)  OR                
P00795              (LINK-CODE-UTIL-TYPE = 'E' AND                      
P00795                    ELEC-MTRS-COUNT-4479 = 1))                    
P00795               MOVE LINK-WORK-TYPE-CD TO WORK-TYPE-CD-4479-B      
P00795               MOVE WORK-TYPE-CD-4479-B TO S-WORK-TYPE-CD-4       
P00795                                  WS-WORK-TYPE-SUB (WS-SUB1)      
                 ELSE                                                   
D26004               IF (LINK-WORK-TYPE-CD = 'CKR' OR 'GCR') AND        
                       METER-STATUS-4479 NOT = 'K'                      
                       MOVE LINK-WORK-TYPE-CD TO WORK-TYPE-CD-4479-B    
                     ELSE                                               
                       MOVE SPACES TO WORK-TYPE-CD-4479-B               
                     END-IF                                             
                     MOVE WORK-TYPE-CD-4479-B TO S-WORK-TYPE-CD-4       
                     IF WS-WORK-TYPE <= SPACES                          
                        MOVE LINK-WORK-TYPE-CD TO                       
                                     WS-WORK-TYPE-SUB (WS-SUB1)         
                        MOVE 'Y' TO WS-WORK-TYPE-INCLUDED               
                     END-IF                                             
                 END-IF                                                 
P00795        ELSE                                                      
D26004           IF (LINK-WORK-TYPE-CD = 'CKR' OR 'GCR') AND            
                         METER-STATUS-4479 NOT = 'K'                    
                    MOVE LINK-WORK-TYPE-CD TO WORK-TYPE-CD-4479-B       
                 ELSE                                                   
                    MOVE SPACES TO WORK-TYPE-CD-4479-B                  
                 END-IF                                                 
P00795           MOVE WORK-TYPE-CD-4479-B TO S-WORK-TYPE-CD-4           
P00795                                  WS-WORK-TYPE-SUB (WS-SUB1)      
P00795        END-IF                                                    
P00795     END-IF                                                       
           MOVE METER-READ-INST-4479 TO S-METER-READ-INST.              
           MOVE METER-IND-4479 TO S-METER-IND                           
                                  WS-METER-IND-SUB (WS-SUB1).           
           MOVE IC-NO-4479-B TO S-IC-NO-4.                              
           MOVE MTR-REF-NO-4479-B TO S-MTR-REF-NO-4.                    
           MOVE CODE-REV-CLASS-4479-B TO S-CODE-REV-CLASS-4.            
           MOVE SO-SEQ-NO-4479-B      TO S-SO-SEQ-NO-4.                 
                                                                        
P00795     IF WORK-TYPE-CD-4479-B > SPACES                              
             IF LINK-PROCESS NOT = WS-MAINTAIN                          
               MOVE WS-ORDER-TYPE-CD TO L3-ORDER-TYPE-CD                
               MOVE WORK-TYPE-CD-4479-B TO L3-WORK-TYPE-CD              
               PERFORM 7050-RELEASE-RQMT THRU 7050-EXIT                 
               IF L3-RLSE-CHECK-CD = 'C'                                
A05189             MOVE 'N' TO WS-RLSE-REQD-4480                        
                   PERFORM 5400-CALL-CSR04012 THRU 5400-EXIT            
               END-IF                                                   
             ELSE                                                       
               MOVE RLSE-IND-4479-B TO S-RLSE-REQUIRED                  
               MOVE RLSE-NO-4479-B TO S-RLSE-NO                         
             END-IF                                                     
             IF L3-SAME-DAY-FL = 'Y'                                    
                MOVE 'Y' TO WS-SAME-DAY-FL                              
             END-IF                                                     
             MOVE 'Y' TO SW-SAME-DAY-CHECK                              
12436A     ELSE                                                         
12436A       IF LINK-PROCESS = WS-MAINTAIN                              
12436A         MOVE RLSE-IND-4479-B TO S-RLSE-REQUIRED                  
12436A         MOVE RLSE-NO-4479-B TO S-RLSE-NO                         
12436A       END-IF                                                     
P00795     END-IF.                                                      
           IF WS-ORDER-TYPE-CHANGED = 'Y' AND                           
              WS-WORK-TYPE-PRIOR >= SPACES                              
              PERFORM 7054-SAME-DAY-WKTYP-PRIOR THRU 7054-EXIT          
           END-IF                                                       
A04670     IF WORK-TYPE-CD-4479-B = 'SOL' AND                           
A04670        CODE-UTIL-TYPE-4479-B = 'E'                               
A04670            MOVE 'Y' TO WS-ELEC-SOR-FL
           END-IF.                           
                                                                        
           IF WORK-TYPE-CD-4479-B = ('UNB' OR 'SOL' OR 'SOS' OR         
                                     'SOR' OR 'REC' OR 'UDP')           
               EVALUATE CODE-UTIL-TYPE-4479-B                           
                   WHEN 'E'                                             
                       MOVE 'Y' TO WS-ELEC-UNBLOCK-FL                   
                   WHEN 'G'                                             
                       MOVE 'Y' TO WS-GAS-UNBLOCK-FL                    
               END-EVALUATE
           END-IF.                                            
           IF CODE-UTIL-TYPE-4479-B = 'E'                               
               MOVE 'Y' TO WS-ELEC-IC-FL
           END-IF.                               
                                                                        
           IF (WORK-TYPE-CD-4479-B = 'UNB' OR 'SOL' OR 'SOS' OR         
                                     'SOR' OR 'REC' OR 'UDP') AND       
              S-PAYMENT-REQ-FL = 'N' AND                                
              S-REVERT-FL <= ' ' AND                                    
              LINK-NEW-CUSTOMER-NO > SPACES AND                         
             (LINK-NEW-CUSTOMER-NO NOT = ZEROES) AND                    
              LINK-PROCESS = 'START' AND                                
A04670        WS-PR-EXECUTED-FL = 'N' AND                               
             (LINK-XFER-FL NOT = 'Y') AND                               
              WS-NEW-CUST-IS-LL-FL NOT = 'Y'  AND                       
A05821        WS-CUST-BLDR-RLTR-FL NOT = 'Y'                            
                  PERFORM 5500-CALL-CSR04281 THRU 5500-EXIT             
A04670            MOVE 'Y' TO WS-PR-EXECUTED-FL                         
A04670            IF WS-TOTAL-DUE > WS-THRESHOLD                        
                      MOVE 'Y' TO S-PAYMENT-REQ-FL
                  END-IF
           END-IF.                     
P0795H     MOVE WS-RLSE-ENABLED-FL TO S-RLSE-ENABLED-FL.                
           PERFORM 8400-SEND-RESULT-4 THRU 8400-EXIT.                   
           IF WORK-TYPE-CD-4479-B > SPACES  OR                          
              (WORK-TYPE-CD-4479-B <= SPACES AND                        
                WS-WORK-TYPE-INCLUDED = 'Y')                            
               ADD +1 TO WS-SUB1                                        
           END-IF.                                                      
       5220-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5230-PROCESS-4479C.                                              
                                                                        
           IF WS-GTT05-DECLARED = 'N'                                   
               PERFORM 0105-DECLARE-GTT05 THRU 0105-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-5.                              
           MOVE 0 TO S-RETURN-CODE-5.                                   
           MOVE SERV-ORDER-NO-4479-C TO S-SERV-ORDER-NO-5.              
           MOVE CODE-UTIL-TYPE-4479-C TO S-CODE-UTIL-TYPE-5.            
           MOVE WORK-TYPE-CD-4479-C TO S-WORK-TYPE-CD-5.                
           MOVE IC-NO-4479-C TO S-IC-NO-5.                              
           MOVE METER-NO-4479-C TO S-METER-NO-5.                        
           MOVE MTR-REF-NO-4479-C TO S-MTR-REF-NO-5.                    
           PERFORM 8500-SEND-RESULT-5 THRU 8500-EXIT.                   
                                                                        
       5230-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5240-PROCESS-4479D.                                              
                                                                        
           IF WS-GTT08-DECLARED = 'N'                                   
               PERFORM 0108-DECLARE-GTT08 THRU 0108-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-8.                              
           MOVE 0 TO S-RETURN-CODE-8.                                   
           MOVE RATE-PLAN-4479-D TO S-RATE-PLAN-8.                      
           IF RATE-PLAN-4479-D = '064'                                  
               MOVE 'Y' TO WS-SUBDIV-LITE-FL                            
           ELSE                                                         
               MOVE 'Y' TO WS-LIGHTING-FL
           END-IF.                              
           MOVE RATE-ITEM-CODE-4479 TO S-RATE-ITEM-CODE.                
           MOVE CODE-PLAN-STATUS-4479 TO S-CODE-PLAN-STATUS.            
           MOVE CODE-STATUS-REASON-4479 TO S-CODE-STATUS-REASON.        
           MOVE MONTHLY-AMOUNT-4479 TO S-MONTHLY-AMOUNT.                
           MOVE NO-UNITS-4479 TO S-NO-UNITS.                            
           IF SUBDIVISION-FL-4479 = 'X'                                 
               MOVE 'Y' TO WS-METERED-LIGHT-FL                          
               MOVE 'N' TO SUBDIVISION-FL-4479
           END-IF.                         
           MOVE SUBDIVISION-FL-4479 TO S-SUBDIVISION-FL.                
           MOVE IC-NO-4479-D TO S-IC-NO-8.                              
           MOVE RATE-PLAN-DESC-4479-D TO S-RATE-PLAN-DESC-8.            
           MOVE SERVICE-TYPE-4479 TO S-SERVICE-TYPE.                    
           MOVE DIST-NO-4479 TO S-DIST-NO.                              
           MOVE POLE-NO-4479 TO S-POLE-NO.                              
           PERFORM 8800-SEND-RESULT-8 THRU 8800-EXIT.                   
                                                                        
       5240-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5250-PROCESS-4479E.                                              
                                                                        
           IF WS-GTT10-DECLARED = 'N'                                   
               PERFORM 0110-DECLARE-GTT10 THRU 0110-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-10.                             
           MOVE 0 TO S-RETURN-CODE-10.                                  
           MOVE CODE-UTIL-TYPE-4479-E TO S-CODE-UTIL-TYPE-10.           
           MOVE IC-NO-4479-E TO S-IC-NO-10.                             
           MOVE RATE-PLAN-4479-E TO S-RATE-PLAN-10.                     
           MOVE CODE-REV-CLASS-4479-E TO S-CODE-REV-CLASS-10.           
           MOVE RATE-PLAN-DESC-4479-E TO S-RATE-PLAN-DESC-10.           
           MOVE TOU-FL-4479 TO S-TOU-FL.                                
           MOVE FIXED-FACTOR-FL-4479 TO S-FIXED-FACTOR-FL.              
           MOVE BILL-CONTRACT-FL-4479 TO S-BILL-CONTRACT-FL.            
           MOVE INTERRUPT-FL-4479 TO S-INTERRUPT-FL.                    
           IF (LINK-ORDER-TYPE-CD = 'FM002' OR                          
               LINK-ORDER-TYPE-CD = SPACES) AND                         
               READ-ROUTE-4479 > 0                                      
               MOVE READ-ROUTE-4479 TO S-READ-ROUTE                     
           END-IF                                                       
           PERFORM 8820-SEND-RESULT-10 THRU 8820-EXIT.                  
                                                                        
       5250-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5300-CALL-CSR04480.                                              
                                                                        
           MOVE WS-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-4480.               
P01176*    PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL                            
P01176*         WS-WORK-TYPE-SUB (WS-SUB1) <= SPACES                            
P01176*       IF WS-WORK-TYPE-SUB (WS-SUB1) = 'MCU' OR 'MCB'                    
P01176*          MOVE 'SOL' TO WS-WORK-TYPE-SUB (WS-SUB1)                       
P01176*       ELSE                                                              
P01176*         IF WS-WORK-TYPE-SUB (WS-SUB1) = 'RMT'                           
P01176*            MOVE 'RMM' TO WS-WORK-TYPE-SUB (WS-SUB1)                     
P01176*         END-IF                                                          
P01176*       END-IF                                                            
P01176*    END-PERFORM                                                          
           MOVE WS-WORK-TYPE TO WORK-TYPE-4480.                         
           MOVE WS-METER-IND TO METER-IND-4480.                         
           MOVE WS-METER-STATUS TO METER-STATUS-4480.                   
                                                                        
           MOVE WS-ACCOUNT-NO TO ACCOUNT-NO-4480.                       
           MOVE WS-PREMISE-NO TO PREMISE-NO-4480.                       
           MOVE WS-ORDER-TYPE-CD TO ORDER-TYPE-CD-4480.                 
           MOVE WS-NEXT-BUS-DAY TO ASSIGNED-DATE-4480.                  
           MOVE PROGRAM-NAME TO PROGRAM-ID-4480.                        
A05189     MOVE 'N'          TO APPLIANCE-LIT-4480.                     
A05189     MOVE WS-RLSE-REQD-4480  TO RELEASE-REQD-4480.                
P0795G     IF WS-NEW-ORDER-FL = 'Y'                                     
D10775        IF WS-BNKRPTCY-ORDER-FL = 'Y'                             
D10775           MOVE 'Y'          TO FRO-FL-4480                       
D10775        ELSE                                                      
A05189           MOVE 'N'          TO FRO-FL-4480                       
D10775        END-IF                                                    
P0795G     ELSE                                                         
P0795G        MOVE BACK-DATED-IND-4478 TO FRO-FL-4480                   
P0795G     END-IF                                                       
P0795G     MOVE 'N'          TO CRAWL-APPL-FL-4480.                     
P0795G     MOVE LINK-SERV-ORDER-NO TO SERV-ORDER-NO-4480.               
P0795G     MOVE LINK-ORDER-STATE-CD TO NEW-ORDER-STATE-CD-4480.         
P0795G     MOVE SPACES              TO WORK-AREA-ID-4480.               
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04480                                             
      *           (:CODE-UTIL-TYPE-4480,                                
      *            :WORK-TYPE-4480,                                     
      *            :METER-IND-4480,                                     
      *            :METER-STATUS-4480,                                  
      *            :ACCOUNT-NO-4480,                                    
      *            :PREMISE-NO-4480,                                    
      *            :ORDER-TYPE-CD-4480,                                 
      *            :ASSIGNED-DATE-4480,                                 
      *            :PROGRAM-ID-4480,                                    
A05189*            :APPLIANCE-LIT-4480,                                 
A05189*            :RELEASE-REQD-4480,                                  
A05189*            :FRO-FL-4480,                                        
P0795G*            :CRAWL-APPL-FL-4480,                                 
P0795H*            :SERV-ORDER-NO-4480,                                 
P0795H*            :NEW-ORDER-STATE-CD-4480,                            
P0795H*            :WORK-AREA-ID-4480)                                  
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE MSQ001_CUR_3
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN MSQ001_CUR_3
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR MSQ001_CUR_3 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5300'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04480'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4480       TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4480A, :LOC4480B)                                    
      *       WITH PROCEDURE CSR04480                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4480A CURSOR FOR RESULT SET       
      *       :LOC4480A                                                 
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4480B CURSOR FOR RESULT SET       
      *       :LOC4480B                                                 
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH MSQ001_CUR_3 INTO                           
                 :RETURN-CODE-4480-A,                                   
                 :WORK-AREA-4480,                                       
                 :DISCONNECT-CD-4480,                                   
                 :TOTAL-RES-4480,                                       
                 :ARRANGEMENT-FL-4480,                                  
                 :REVERT-FL-4480,                                       
P00718           :BUSINESS-UNIT-4480,                                   
P00718           :WORK-DISTRICT-4480,                                   
A05189           :AROP-READ-ONLY-4480                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*    EXEC SQL                                                             
MFA-TR*       FETCH RESULT_SET_CSR_4480A INTO                                   
MFA-TR*          :RETURN-CODE-4480-A,                                           
MFA-TR*          :WORK-AREA-4480,                                               
MFA-TR*          :DISCONNECT-CD-4480,                                           
MFA-TR*          :TOTAL-RES-4480,                                               
MFA-TR*          :ARRANGEMENT-FL-4480,                                          
MFA-TR*          :REVERT-FL-4480,                                               
MFA-TR*          :BUSINESS-UNIT-4480,                                           
MFA-TR*          :WORK-DISTRICT-4480,                                           
MFA-TR*          :AROP-READ-ONLY-4480                                           
MFA-TR*    END-EXEC.                                                            

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_3
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  IF RETURN-CODE-4480-A NOT = 0                         
                      MOVE RETURN-CODE-4480-A TO WS-ACTIVE-RETURN-CODE  
                      MOVE PROGRAM-NAME        TO ABEND-PROGRAM         
                      MOVE '5300'              TO ACTIVE-PARAGRAPH      
                      MOVE 'FETCH'             TO ABEND-FUNCTION        
                      MOVE 'CSR04480A'         TO TABLE-1               
                      MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1       
                      MOVE ACCOUNT-NO-4480     TO HOSTVAR-ELEMENT-1     
                      PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT         
                  END-IF                                                
                  PERFORM 5310-PROCESS-4480A THRU 5310-EXIT             
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '5300'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CSR04480A'           TO TABLE-1                 
                  MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1         
                  MOVE ACCOUNT-NO-4480       TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT             
           END-EVALUATE.                                                
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH MSQ001_CUR_3 INTO                         
                   :RETURN-CODE-4480-B,                                 
                   :CALENDAR-DT-4480,                                   
                   :GOOD-DAY-FL-4480,                                   
                   :TOTAL-SO-HRS-4480,                                  
                   :MAX-RE-PER-DAY-4480,                                
                   :TOTAL-SO-4480,                                      
                   :MAX-DAILY-WK-REQ-4480                               
             END-EXEC                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ001
MFA-TR*      EXEC SQL                                                           
MFA-TR*         FETCH RESULT_SET_CSR_4480B INTO                                 
MFA-TR*            :RETURN-CODE-4480-B,                                         
MFA-TR*            :CALENDAR-DT-4480,                                           
MFA-TR*            :GOOD-DAY-FL-4480,                                           
MFA-TR*            :TOTAL-SO-HRS-4480,                                          
MFA-TR*            :MAX-RE-PER-DAY-4480,                                        
MFA-TR*            :TOTAL-SO-4480,                                              
MFA-TR*            :MAX-DAILY-WK-REQ-4480                                       
MFA-TR*      END-EXEC                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                    IF RETURN-CODE-4480-B NOT = 0 AND                   
                       RETURN-CODE-4480-B NOT = +100                    
                         MOVE RETURN-CODE-4480-B TO                     
                              WS-ACTIVE-RETURN-CODE                     
                         MOVE PROGRAM-NAME      TO ABEND-PROGRAM        
                         MOVE '5300'            TO ACTIVE-PARAGRAPH     
                         MOVE 'FETCH'           TO ABEND-FUNCTION       
                         MOVE 'CSR04480B'       TO TABLE-1              
                         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1      
                         MOVE ACCOUNT-NO-4480   TO HOSTVAR-ELEMENT-1    
                         PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT      
                    END-IF                                              
                    IF RETURN-CODE-4480-B = +100                        
                        SET NO-MORE-ROWS TO TRUE                        
                    ELSE                                                
P0795F                 IF WS-SAME-DAY-FL NOT = 'Y'                      
P0795F                  PERFORM 5320-PROCESS-4480B THRU 5320-EXIT       
P0795F                 END-IF                                           
                    END-IF                                              
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5300'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04480B'           TO TABLE-1              
                     MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1      
                     MOVE ACCOUNT-NO-4480       TO HOSTVAR-ELEMENT-1    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 

MSQ001        EXEC SQL
MSQ001          GET NEXT RESULT SET 
MSQ001          FOR MSQ001_CUR_3
MSQ001        END-EXEC
           MOVE 'Y'                TO SW-FETCH.                         
                                                                        
       5300-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5310-PROCESS-4480A.                                              
                                                                        
           MOVE WORK-AREA-4480 TO S-WORK-AREA-2.                        
P00718     MOVE BUSINESS-UNIT-4480 TO S-BUSINESS-UNIT-2.                
P00718     MOVE WORK-DISTRICT-4480 TO S-WORK-DISTRICT-2.                
           MOVE DISCONNECT-CD-4480 TO S-DISCONNECT-CD.                  
           MOVE TOTAL-RES-4480 TO S-TOTAL-RES.                          
           MOVE ARRANGEMENT-FL-4480 TO S-ARRANGEMENT-FL.                
           MOVE AROP-READ-ONLY-4480 TO S-AROP-READ-ONLY-FL.             
           IF LINK-SERV-ORDER-NO > SPACES AND                           
              LINK-SERV-ORDER-NO NOT = '0000000000000' AND              
              (LINK-ORDER-STATE-CD = 'A' OR                             
               WS-ORDER-TYPE-CHANGED = 'Y')                             
              MOVE WORK-AREA-4480 TO S-WORK-AREA-ID-12                  
              MOVE BUSINESS-UNIT-4480 TO S-BUSINESS-UNIT-12             
D10675        MOVE WORK-DISTRICT-4480 TO S-WORK-DISTRICT-12             
              IF WORK-AREA-4480 (1:3) = 'ARO'                           
                 MOVE 'H' TO S-ORDER-STATE-CD-12 S-ORDER-STATE-CD       
              END-IF                                                    
              IF  WS-ORDER-TYPE-CHANGED = 'Y' AND                       
                 (WORK-AREA-ID-4478 (1:3) = 'ARO' OR                    
                  WORK-AREA-ID-4478 (1:4) =  'OORR') AND                
                  WORK-AREA-4480 (1:3) NOT= 'ARO'                       
                 MOVE 'A' TO S-ORDER-STATE-CD-12 S-ORDER-STATE-CD       
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       5310-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5320-PROCESS-4480B.                                              
                                                                        
           IF WS-GTT07-DECLARED = 'N'                                   
               PERFORM 0107-DECLARE-GTT07 THRU 0107-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-7.                              
           MOVE 0 TO S-RETURN-CODE-7.                                   
           MOVE CALENDAR-DT-4480 TO S-CALENDAR-DT.                      
           MOVE GOOD-DAY-FL-4480 TO S-GOOD-DAY-FL.                      
           PERFORM 8700-SEND-RESULT-7 THRU 8700-EXIT.                   
                                                                        
       5320-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5400-CALL-CSR04012.                                              
                                                                        
           MOVE AT-COMPANY-NO TO COMPANY-NO-4012.                       
           MOVE PR-REV-DISTRICT-CD TO REV-DISTRICT-CD-4012.             
           MOVE WS-ORDER-TYPE-CD TO ORDER-TYPE-CD-4012.                 
           MOVE WORK-TYPE-CD-4479-B TO WORK-TYPE-CD-4012.               
           MOVE L3-RLSE-CHECK-CD TO RLSE-CHECK-CD-4012.                 
           MOVE LINK-ACCOUNT-NO TO ACCOUNT-NO-4012.                     
           MOVE 'CIS' TO CALLING-SYSTEM-4012.                           
           MOVE WS-NEXT-BUS-DAY TO WANTED-BY-DATE-4012.                 
           MOVE CODE-UTIL-TYPE-4479-B TO CODE-UTIL-TYPE-4012            
                                         RLSE-TYPE-4012(1:1).           
           MOVE 'P' TO RLSE-TYPE-4012(2:1).                             
           MOVE METER-STATUS-REASON-4479 TO CODE-STATUS-REAS-4012.      
           MOVE IC-NO-4479-B TO WS-IC-NO-NUM.                           
           MOVE WS-IC-NO-CHAR TO IC-NO-4012.                            
           MOVE MTR-REF-NO-4479-B TO WS-MTR-REF-NO-NUM.                 
           MOVE WS-MTR-REF-NO-CHAR TO MTR-REF-NO-4012.                  
           MOVE WS-PREMISE-NO TO PREMISE-NO-4012.                       
           MOVE SUPPLIES-4479 TO RLSE-SUPPLIES-4012.                    
                                                                        
P0795B     IF LINK-ACCOUNT-NO = ZEROS AND                               
P0795B        LINK-ORDER-TYPE-CD = 'FM002'                              
               MOVE LINK-WORK-TYPE-CD   TO WORK-TYPE-CD-4012            
               MOVE LINK-CODE-UTIL-TYPE TO CODE-UTIL-TYPE-4012          
                                           RLSE-TYPE-4012(1:1)          
               MOVE SPACES TO CODE-STATUS-REAS-4012                     
               MOVE '000' TO IC-NO-4012                                 
               MOVE '000' TO MTR-REF-NO-4012                            
               MOVE SPACES        TO RLSE-SUPPLIES-4012                 
           END-IF                                                       
                                                                        
           SET WS-SUPPLYING-INDEX TO +1.                                
           SEARCH WS-SUPPLYING-LINE                                     
               AT END                                                   
                   MOVE SPACES TO METER-SUPPLYING-CD-4012               
               WHEN SUPPLIES-4479 =                                     
                    WS-SUPPLYING-DESC (WS-SUPPLYING-INDEX)              
                        MOVE WS-SUPPLYING-CD (WS-SUPPLYING-INDEX) TO    
                             METER-SUPPLYING-CD-4012                    
           END-SEARCH.                                                  
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04012                                             
      *           (:COMPANY-NO-4012,                                    
      *            :REV-DISTRICT-CD-4012,                               
      *            :CODE-UTIL-TYPE-4012,                                
      *            :ORDER-TYPE-CD-4012,                                 
      *            :WORK-TYPE-CD-4012,                                  
      *            :RLSE-CHECK-CD-4012,                                 
      *            :ACCOUNT-NO-4012,                                    
      *            :IC-NO-4012,                                         
      *            :MTR-REF-NO-4012,                                    
      *            :METER-SUPPLYING-CD-4012,                            
      *            :CODE-STATUS-REAS-4012,                              
      *            :CALLING-SYSTEM-4012,                                
      *            :WANTED-BY-DATE-4012,                                
      *            :PREMISE-NO-4012,                                    
      *            :RLSE-TYPE-4012,                                     
      *            :RLSE-SUPPLIES-4012)                                 
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4012
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4012
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4012 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5400'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04012'            TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE ACCOUNT-NO-4012       TO HOSTVAR-ELEMENT-1           
              MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2             
              MOVE REV-DISTRICT-CD-4012  TO HOSTVAR-ELEMENT-2           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3             
              MOVE CODE-UTIL-TYPE-4012   TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4012)                                                
      *       WITH PROCEDURE CSR04012                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4012 CURSOR FOR RESULT SET        
      *       :LOC4012                                                  
      *    END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
              FETCH RESULT_SET_CSR_4012 INTO                            
                 :RETURN-CODE-4012,                                     
                 :RLSE-REQUIRED-FL-4012,                                
                 :MESSAGE-4012,                                         
                 :ADTL-MESSAGE-4012,                                    
                 :PHONE-4012,                                           
                 :ALT-PHONE-4012,                                       
                 :UTIL-TYPE-4012,                                       
                 :REV-DIST-DESC-4012,                                   
                 :RLSE-EXISTS-4012,                                     
                 :RLSE-NO-4012                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF RETURN-CODE-4012 NOT = 0 AND                      
                      RETURN-CODE-4012 NOT = 100                        
                          IF RLSE-REQUIRED-FL-4012 = 'E'                
                              PERFORM 5410-MANUAL-RELEASE-CHECK THRU    
                                      5410-EXIT                         
                          ELSE                                          
                              MOVE RETURN-CODE-4012 TO                  
                                   WS-ACTIVE-RETURN-CODE                
                                   S-STATUS-CODE                        
                              MOVE PROGRAM-NAME TO ABEND-PROGRAM        
                              MOVE '5400'     TO ACTIVE-PARAGRAPH       
                              MOVE 'FETCH'    TO ABEND-FUNCTION         
                              MOVE 'CSR04012' TO TABLE-1                
                              MOVE 'ACCOUNT_NO' TO TABLE-ELEMENT-1      
                              MOVE ACCOUNT-NO-4012 TO HOSTVAR-ELEMENT-1 
                              MOVE 'REV_DISTRICT_CD' TO TABLE-ELEMENT-2 
                              MOVE REV-DISTRICT-CD-4012 TO              
                                   HOSTVAR-ELEMENT-2                    
                              MOVE 'CODE_UTIL_TYPE' TO TABLE-ELEMENT-3  
                              MOVE CODE-UTIL-TYPE-4012 TO               
                                   HOSTVAR-ELEMENT-3                    
                              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT 
                          END-IF                                        
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '5400'                TO ACTIVE-PARAGRAPH       
                   MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSR04012'            TO TABLE-1                
                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
                   MOVE ACCOUNT-NO-4012       TO HOSTVAR-ELEMENT-1      
                   MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-2        
                   MOVE REV-DISTRICT-CD-4012  TO HOSTVAR-ELEMENT-2      
                   MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3        
                   MOVE CODE-UTIL-TYPE-4012   TO HOSTVAR-ELEMENT-3      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
           MOVE RLSE-REQUIRED-FL-4012 TO S-RLSE-REQUIRED.               
           IF RLSE-REQUIRED-FL-4012 = 'Y' OR 'E'                        
A05189         MOVE 'Y' TO WS-RLSE-REQD-4480                            
               IF RLSE-EXISTS-4012 = 'Y'                                
                   MOVE RLSE-NO-4012 TO S-RLSE-NO                       
A05189             MOVE 'N' TO WS-RLSE-REQD-4480                        
               ELSE                                                     
                   MOVE MESSAGE-4012 TO S-RLSE-MSG                      
                   MOVE ADTL-MESSAGE-4012 TO S-RLSE-ADDL-MSG            
                   MOVE PHONE-4012 TO S-RLSE-PHONE                      
                   MOVE ALT-PHONE-4012 TO S-RLSE-ALT-PHONE              
                   MOVE REV-DIST-DESC-4012 TO S-RLSE-REV-DIST           
                   MOVE 'ORDR000039' TO S-BUS-RULE-ID-4                 
                                        S-BUS-RULE-ID                   
                   MOVE 'P' TO S-ACTION-TYPE-CD-4(1:1)                  
                   MOVE MESSAGE-4012 TO S-ACTION-TYPE-CD-4(2:5)         
                   PERFORM 7025-RULE-XREF THRU 7025-EXIT                
                   MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID-4
               END-IF
           END-IF.    
                                                                        
       5400-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5410-MANUAL-RELEASE-CHECK.                                       
                                                                        
           MOVE 'RE006' TO S-RLSE-MSG.                                  
           MOVE ADTL-MESSAGE-4012 TO S-RLSE-ADDL-MSG.                   
           MOVE PHONE-4012 TO S-RLSE-PHONE.                             
           MOVE ALT-PHONE-4012 TO S-RLSE-ALT-PHONE.                     
           MOVE REV-DIST-DESC-4012 TO S-RLSE-REV-DIST.                  
           MOVE 'ORDR000039' TO S-BUS-RULE-ID-4.                        
           MOVE 'P' TO S-ACTION-TYPE-CD-4.                              
           PERFORM 7025-RULE-XREF THRU 7025-EXIT.                       
           MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID-4.            
                                                                        
       5410-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5500-CALL-CSR04281.                                              
                                                                        
           MOVE LINK-NEW-CUSTOMER-NO TO CUSTOMER-NO-4281.               
           MOVE AT-COMPANY-NO TO COMPANY-NO-4281.                       
                                                                        
      *    EXEC SQL                                                     
      *       CALL CSR04281                                             
      *           (:CUSTOMER-NO-4281,                                   
      *            :COMPANY-NO-4281)                                    
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE RESULT_SET_CSR_4281
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN RESULT_SET_CSR_4281
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR RESULT_SET_CSR_4281 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5500'                TO ACTIVE-PARAGRAPH            
              MOVE 'CALL'                TO ABEND-FUNCTION              
              MOVE 'CSR04281'            TO TABLE-1                     
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
              MOVE CUSTOMER-NO-4281      TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE COMPANY-NO-4281       TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
      *    EXEC SQL                                                     
      *       ASSOCIATE LOCATORS                                        
      *       (:LOC4281)                                                
      *       WITH PROCEDURE CSR04281                                   
      *    END-EXEC.                                                    
                                                                        
      *    EXEC SQL                                                     
      *       ALLOCATE RESULT_SET_CSR_4281 CURSOR FOR RESULT SET        
      *       :LOC4281                                                  
      *    END-EXEC.                                                    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             EXEC SQL                                                   
                FETCH RESULT_SET_CSR_4281 INTO                          
                   :RETURN-CODE-4281,                                   
                   :ACCOUNT-NO-4281,                                    
                   :CODE-ACCT-STAT-4281,                                
                   :PAST-DUE-UTIL-4281,                                 
                   :PAST-DUE-NONUTIL-4281,                              
                   :CUST-TYPE-4281,                                     
                   :SSN-4281,                                           
                   :SERV-ADDRESS-4281,                                  
                   :CIA-4281,                                           
                   :BILLED-BALANCE-4281,                                
                   :DEPOSIT-DUE-4281,                                   
                   :PAYMENTS-4281,                                      
                   :PSNC-LABOR-CHG-4281,                                
                   :RET-CHECK-FL-4281,                                  
                   :NAME-4281,                                          
                   :TOTAL-DUE-4281                                      
             END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
             EVALUATE WS-ACTIVE-RETURN-CODE                             
                 WHEN SUCCESSFUL-CALL                                   
                     IF RETURN-CODE-4281 NOT = 0 AND                    
                        RETURN-CODE-4281 NOT = +100                     
                          MOVE RETURN-CODE-4281 TO WS-ACTIVE-RETURN-CODE
                          MOVE PROGRAM-NAME      TO ABEND-PROGRAM       
                          MOVE '5500'            TO ACTIVE-PARAGRAPH    
                          MOVE 'FETCH'           TO ABEND-FUNCTION      
                          MOVE 'CSR04281'        TO TABLE-1             
                          MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-1     
                          MOVE CUSTOMER-NO-4281  TO HOSTVAR-ELEMENT-1   
                          MOVE 'COMPANY_NO'      TO TABLE-ELEMENT-2     
                          MOVE COMPANY-NO-4281   TO HOSTVAR-ELEMENT-2   
                          PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT     
                     END-IF                                             
                     IF RETURN-CODE-4281 = +100                         
                         SET NO-MORE-ROWS TO TRUE                       
                     ELSE                                               
                         ADD TOTAL-DUE-4281 TO WS-TOTAL-DUE             
                     END-IF                                             
                 WHEN NOT-FOUND                                         
                     SET NO-MORE-ROWS TO TRUE                           
                     MOVE 0 TO WS-ACTIVE-RETURN-CODE                    
                 WHEN OTHER                                             
                     MOVE PROGRAM-NAME          TO ABEND-PROGRAM        
                     MOVE '5500'                TO ACTIVE-PARAGRAPH     
                     MOVE 'FETCH'               TO ABEND-FUNCTION       
                     MOVE 'CSR04281'            TO TABLE-1              
                     MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1      
                     MOVE CUSTOMER-NO-4281      TO HOSTVAR-ELEMENT-1    
                     MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2      
                     MOVE COMPANY-NO-4281       TO HOSTVAR-ELEMENT-2    
                     PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT          
             END-EVALUATE                                               
           END-PERFORM.                                                 
           MOVE 'Y' TO SW-FETCH.                                        
                                                                        
       5500-EXIT.                                                       
            EXIT.                                                       
                                                                        
       5600-SEND-LIGHT-CHRG.                                            
                                                                        
           IF WS-GTT08-DECLARED = 'N'                                   
               PERFORM 0108-DECLARE-GTT08 THRU 0108-EXIT
           END-IF.               
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-8.                              
           MOVE 0 TO S-RETURN-CODE-8.                                   
           MOVE '064'             TO S-RATE-PLAN-8.                     
           MOVE 'Y'               TO WS-SUBDIV-LITE-FL                  
           MOVE ZS-RATE-ITEM-CD   TO S-RATE-ITEM-CODE.                  
           MOVE 'A'               TO S-CODE-PLAN-STATUS.                
           MOVE 'A'               TO S-CODE-STATUS-REASON.              
           MOVE UP-PRICE-PER-SERV TO S-MONTHLY-AMOUNT.                  
           MOVE 1                 TO S-NO-UNITS.                        
           MOVE 'Y'               TO S-SUBDIVISION-FL.                  
           MOVE 1                 TO S-IC-NO-8.                         
           MOVE RD-RATE-DESC      TO S-RATE-PLAN-DESC-8.                
           MOVE 'U'               TO S-SERVICE-TYPE.                    
           MOVE 0                 TO S-DIST-NO.                         
           MOVE 0                 TO S-POLE-NO.                         
           PERFORM 8800-SEND-RESULT-8 THRU 8800-EXIT.                   
                                                                        
       5600-EXIT.                                                       
            EXIT.                                                       
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     COMPANY_NO,                                        
P0795E               MST_SUB_ACCT_IND,                                  
D10775               BANKRUPTCY_IND,                                    
D10775               BNKRPT_CASE_NO                                     
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :AT-COMPANY-NO,                                    
P0795E               :AT-MST-SUB-ACCT-IND,                              
D10775               :AT-BANKRUPTCY-IND,                                
D10775               :AT-BNKRPT-CASE-NO                                 
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              MST_SUB_ACCT_IND,                                          
MFA-TR*              BANKRUPTCY_IND,                                            
MFA-TR*              BNKRPT_CASE_NO                                             
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-COMPANY-NO,                                            
MFA-TR*              :AT-MST-SUB-ACCT-IND,                                      
MFA-TR*              :AT-BANKRUPTCY-IND,                                        
MFA-TR*              :AT-BNKRPT-CASE-NO                                         
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7000'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
DT9505 7002-SELECT-ACCOUNT-PRIOR.                                       
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     COMPANY_NO,                                        
                     MST_SUB_ACCT_IND                                   
                INTO :WS-AT-CUSTOMER-NO-PR,                             
                     :WS-AT-COMPANY-NO-PR,                              
                     :WS-AT-MST-SUB-IND-PR                              
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO-PR                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              MST_SUB_ACCT_IND                                           
MFA-TR*         INTO :WS-AT-CUSTOMER-NO-PR,                                     
MFA-TR*              :WS-AT-COMPANY-NO-PR,                                      
MFA-TR*              :WS-AT-MST-SUB-IND-PR                                      
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :WS-AT-ACCOUNT-NO-PR                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7002                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7002'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE WS-AT-ACCOUNT-NO-PR TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-SELECT-MTRENV.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) METER_NO                                           
                INTO :MN-METER-NO                                       
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT METER_NO                                                   
MFA-TR*         INTO :MN-METER-NO                                               
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-MN-FOUND                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-MN-FOUND                              
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7010'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-SELECT-CSTPLN.                                              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) RATE_ITEM_CODE                                     
                INTO :CP-RATE-ITEM-CODE                                 
                FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_ITEM_CODE                                             
MFA-TR*         INTO :CP-RATE-ITEM-CODE                                         
MFA-TR*         FROM CSS_CUST_PLAN                                              
MFA-TR*        WHERE ACCOUNT_NO  = :AT-ACCOUNT-NO                               
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-CP-FOUND                              
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-CP-FOUND                              
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7020'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_CUST_PLAN'     TO TABLE-1                  
                   MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
                   MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7025-RULE-XREF.                                                  
                                                                        
           MOVE S-BUS-RULE-ID TO 1T-BUS-RULE-ID.                        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           BUS_RULE_XREF_ID, 121), ' ', '-'), ':', '.') 
           BUS_RULE_XREF_ID                                   
                INTO :1T-BUS-RULE-XREF-ID                               
                FROM CSS_BUS_RULE_XREF WITH(READUNCOMMITTED)                    
               WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                   
                 AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                
                 AND APPLICATION_ID = 'CSR'                             
                 AND COMPANY_NO     = '00'                              
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUS_RULE_XREF_ID                                           
MFA-TR*         INTO :1T-BUS-RULE-XREF-ID                                       
MFA-TR*         FROM CSS_BUS_RULE_XREF                                          
MFA-TR*        WHERE BUS_RULE_ID    = :1T-BUS-RULE-ID                           
MFA-TR*          AND BUS_PROCESS_ID = :1T-BUS-PROCESS-ID                        
MFA-TR*          AND APPLICATION_ID = 'CSR'                                     
MFA-TR*          AND COMPANY_NO     = '00'                                      
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7025                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 1T-BUS-RULE-XREF-ID TO S-BUS-RULE-XREF-ID       
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO S-BUS-RULE-XREF-ID                    
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7025'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_BUS_RULE_XREF' TO TABLE-1                  
                   MOVE 'BUS_RULE_ID'       TO TABLE-ELEMENT-1          
                   MOVE 1T-BUS-RULE-ID      TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7040-SELECT-PREMISE.                                             
P0795B     MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO                      
           EXEC SQL                                                     
              SELECT REV_DISTRICT_CD,                                   
A04670               CODE_RENTAL_PROP,                                  
P0795B               COMPANY_NO,                                        
MAINTN               READ_ROUTE,                                        
MAINTN               SUBDIVISION_ID,                                    
MAINTN               ADDRESS_ID                                         
                INTO :PR-REV-DISTRICT-CD,                               
A04670               :PR-CODE-RENTAL-PROP,                              
P0795B               :PR-COMPANY-NO,                                    
MAINTN               :PR-READ-ROUTE,                                    
MAINTN               :PR-SUBDIVISION-ID,                                
MAINTN               :PR-ADDRESS-ID                                     
                FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
P0795B         WHERE PREMISE_NO = :PR-PREMISE-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REV_DISTRICT_CD,                                           
MFA-TR*              CODE_RENTAL_PROP,                                          
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              READ_ROUTE,                                                
MFA-TR*              SUBDIVISION_ID,                                            
MFA-TR*              ADDRESS_ID                                                 
MFA-TR*         INTO :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :PR-CODE-RENTAL-PROP,                                      
MFA-TR*              :PR-COMPANY-NO,                                            
MFA-TR*              :PR-READ-ROUTE,                                            
MFA-TR*              :PR-SUBDIVISION-ID,                                        
MFA-TR*              :PR-ADDRESS-ID                                             
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7040                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
MAINTN             MOVE PR-READ-ROUTE TO S-READ-ROUTE                   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7040'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_PREMISE'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0795J 7045-SELECT-PREM-ADDRESS.                                        
           MOVE PR-ADDRESS-ID TO DY-ADDRESS-ID.                         
           EXEC SQL                                                     
              SELECT ZIP_CODE                                           
                INTO :DY-ZIP-CODE                                       
                FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                   
               WHERE ADDRESS_ID = :DY-ADDRESS-ID                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ZIP_CODE                                                   
MFA-TR*         INTO :DY-ZIP-CODE                                               
MFA-TR*         FROM CSS_ADDR_FORMATTED                                         
MFA-TR*        WHERE ADDRESS_ID = :DY-ADDRESS-ID                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7045                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7045'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS_ID'        TO TABLE-ELEMENT-1          
                   MOVE DY-ADDRESS-ID       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0795J 7046-GET-ZIPCODE-SUBDIV.                                         
           MOVE PR-SUBDIVISION-ID TO ZS-SUBDIVISION-ID                  
           MOVE DY-ZIP-CODE TO ZS-ZIP-CODE                              
           EXEC SQL                                                     
              SELECT RATE_ITEM_CD                                       
                INTO :ZS-RATE-ITEM-CD                                   
                FROM CSS_ZIPCODE_SUBDIV  ZS WITH(READUNCOMMITTED)               
               WHERE SUBDIVISION_ID = :ZS-SUBDIVISION-ID                
                 AND ZIP_CODE = :ZS-ZIP-CODE                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_ITEM_CD                                               
MFA-TR*         INTO :ZS-RATE-ITEM-CD                                           
MFA-TR*         FROM CSS_ZIPCODE_SUBDIV  ZS                                     
MFA-TR*        WHERE SUBDIVISION_ID = :ZS-SUBDIVISION-ID                        
MFA-TR*          AND ZIP_CODE = :ZS-ZIP-CODE                                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7046                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF ZS-RATE-ITEM-CD > 0                              
                       MOVE 'Y' TO  WS-SUBDIV-RATE-EXISTS               
                    ELSE                                                
                       MOVE 'N' TO  WS-SUBDIV-RATE-EXISTS               
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 'N' TO  WS-SUBDIV-RATE-EXISTS                  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7046'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ZIPCODE_SUBDIV' TO TABLE-1                 
                   MOVE 'SUBDIVISION_ID'    TO TABLE-ELEMENT-1          
                   MOVE ZS-SUBDIVISION-ID   TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7046-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0795J 7047-GET-SUBDIV-LIGHT-CHRG.                                      
           MOVE ZS-RATE-ITEM-CD TO  UP-RATE-ITEM-CODE                   
                                                                        
           EXEC SQL                                                     
                SELECT PRICE_PER_SERV                                   
                  INTO :UP-PRICE-PER-SERV                               
                  FROM CSS_UNMTR_PLAN                                   
                WHERE RATE_PLAN_NO = '064'                              
                  AND CODE_UTIL_TYPE = 'U'                              
                  AND RATE_ITEM_CODE = :UP-RATE-ITEM-CODE               
                  AND VERSION_NO_CNTRL =                                
                    (SELECT MAX(VERSION_NO_CNTRL)                       
                         FROM CSS_UNMTR_PLAN                            
                         WHERE RATE_PLAN_NO = '064'                     
                         AND CODE_UTIL_TYPE = 'U'                       
                         AND RATE_ITEM_CODE = :UP-RATE-ITEM-CODE)       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT PRICE_PER_SERV                                           
MFA-TR*           INTO :UP-PRICE-PER-SERV                                       
MFA-TR*           FROM CSS_UNMTR_PLAN                                           
MFA-TR*         WHERE RATE_PLAN_NO = '064'                                      
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*           AND RATE_ITEM_CODE = :UP-RATE-ITEM-CODE                       
MFA-TR*           AND VERSION_NO_CNTRL =                                        
MFA-TR*             (SELECT MAX(VERSION_NO_CNTRL)                               
MFA-TR*                  FROM CSS_UNMTR_PLAN                                    
MFA-TR*                  WHERE RATE_PLAN_NO = '064'                             
MFA-TR*                  AND CODE_UTIL_TYPE = 'U'                               
MFA-TR*                  AND RATE_ITEM_CODE = :UP-RATE-ITEM-CODE)               
MFA-TR*               QUERYNO 7047                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    PERFORM 7048-GET-RATE-DESC  THRU  7048-EXIT         
                    PERFORM 5600-SEND-LIGHT-CHRG THRU  5600-EXIT        
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7047'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_UNMTR_PLAN'    TO TABLE-1                  
                   MOVE 'RATE_ITEM_CD'      TO TABLE-ELEMENT-1          
                   MOVE UP-RATE-ITEM-CODE   TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7047-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0795J 7048-GET-RATE-DESC.                                              
           MOVE '064' TO RD-RATE-PLAN-NO.                               
                                                                        
           EXEC SQL                                                     
                SELECT RATE_DESC                                        
                  INTO :RD-RATE-DESC                                    
                  FROM CSS_RATE_PLAN_DESC RD                            
                WHERE RATE_PLAN_NO = :RD-RATE-PLAN-NO                   
                  AND CODE_UTIL_TYPE = 'U'                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RATE_DESC                                                
MFA-TR*           INTO :RD-RATE-DESC                                            
MFA-TR*           FROM CSS_RATE_PLAN_DESC RD                                    
MFA-TR*         WHERE RATE_PLAN_NO = :RD-RATE-PLAN-NO                           
MFA-TR*           AND CODE_UTIL_TYPE = 'U'                                      
MFA-TR*      QUERYNO 7048                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7048'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-1                 
                   MOVE 'RATE_PLAN_NO'      TO TABLE-ELEMENT-1          
                   MOVE RD-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7048-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7050-RELEASE-RQMT.                                               
                                                                        
           MOVE SPACES TO L3-RLSE-CHECK-CD.                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RLSE_CHECK_CD,
              SAME_DAY_FL                                       
                 INTO :L3-RLSE-CHECK-CD,                                
                      :L3-SAME-DAY-FL                                   
                 FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                   
                WHERE ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                 
                  AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                  
                  AND COMPANY_NO    = :AT-COMPANY-NO                    
MAINTN            AND (STATUS_CHANGE_DT IS NULL                         
MAINTN            OR STATUS_CHANGE_DT > CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              ) )                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RLSE_CHECK_CD,                                            
MFA-TR*               SAME_DAY_FL                                               
MFA-TR*          INTO :L3-RLSE-CHECK-CD,                                        
MFA-TR*               :L3-SAME-DAY-FL                                           
MFA-TR*          FROM CSS_ORDER_WK_TYPE                                         
MFA-TR*         WHERE ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                         
MFA-TR*           AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                          
MFA-TR*           AND COMPANY_NO    = :AT-COMPANY-NO                            
MFA-TR*           AND (STATUS_CHANGE_DT IS NULL                                 
MFA-TR*           OR STATUS_CHANGE_DT > :WS-CURRENT-TS )                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ' ' TO L3-RLSE-CHECK-CD                         
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7050'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER_WK_TYPE'  TO TABLE-1                 
                   MOVE 'ORDER_TYPE_CD'      TO TABLE-ELEMENT-1         
                   MOVE L3-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
                   MOVE 'WORK_TYPE_CD'       TO TABLE-ELEMENT-2         
                   MOVE L3-WORK-TYPE-CD      TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0795H 7052-RELEASE-ENABLED.                                            
                                                                        
           MOVE 'N'    TO WS-RLSE-ENABLED-FL.                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-RLSE-ENABLED-FL                               
                 FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                   
                WHERE ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                 
                  AND COMPANY_NO    = :AT-COMPANY-NO                    
                  AND RLSE_CHECK_CD = 'C'                               
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-RLSE-ENABLED-FL                                       
MFA-TR*          FROM CSS_ORDER_WK_TYPE                                         
MFA-TR*         WHERE ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                         
MFA-TR*           AND COMPANY_NO    = :AT-COMPANY-NO                            
MFA-TR*           AND RLSE_CHECK_CD = 'C'                                       
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7052                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-RLSE-ENABLED-FL                       
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7052'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER_WK_TYPE'  TO TABLE-1                 
                   MOVE 'ORDER_TYPE_CD'      TO TABLE-ELEMENT-1         
                   MOVE L3-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7052-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7054-SAME-DAY-WKTYP-PRIOR.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SAME_DAY_FL                                       
                 INTO :WS-SAME-DAY-FL-PRIOR                             
                 FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                   
                WHERE ORDER_TYPE_CD = :WS-ORDER-TYPE-PRIOR              
                  AND WORK_TYPE_CD  = :WS-WORK-TYPE-PRIOR               
                  AND COMPANY_NO    = :AT-COMPANY-NO                    
MAINTN            AND (STATUS_CHANGE_DT IS NULL                         
MAINTN            OR STATUS_CHANGE_DT > CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              ) )                
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SAME_DAY_FL                                               
MFA-TR*          INTO :WS-SAME-DAY-FL-PRIOR                                     
MFA-TR*          FROM CSS_ORDER_WK_TYPE                                         
MFA-TR*         WHERE ORDER_TYPE_CD = :WS-ORDER-TYPE-PRIOR                      
MFA-TR*           AND WORK_TYPE_CD  = :WS-WORK-TYPE-PRIOR                       
MFA-TR*           AND COMPANY_NO    = :AT-COMPANY-NO                            
MFA-TR*           AND (STATUS_CHANGE_DT IS NULL                                 
MFA-TR*           OR STATUS_CHANGE_DT > :WS-CURRENT-TS )                        
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7054                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SAME-DAY-FL-PRIOR                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7054'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER_WK_TYPE'  TO TABLE-1                 
                   MOVE 'ORDER_TYPE_CD'      TO TABLE-ELEMENT-1         
                   MOVE WS-ORDER-TYPE-PRIOR  TO HOSTVAR-ELEMENT-1       
                   MOVE 'WORK_TYPE_CD'       TO TABLE-ELEMENT-2         
                   MOVE WS-WORK-TYPE-PRIOR   TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7054-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7056-SAME-DAY-ORDER-PRIOR.                                       
                                                                        
           EXEC SQL                                                     
               SELECT SAME_DAY_ORDER_FL                                 
                 INTO :WS-SAME-DAY-FL-PRIOR                             
                 FROM CSS_ORDER_TYPE                                    
                WHERE ORDER_TYPE_CD = :WS-ORDER-TYPE-PRIOR              
                  AND COMPANY_NO    = :AT-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-SAME-DAY-FL-PRIOR                     
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7056'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER_TYPE'     TO TABLE-1                 
                   MOVE 'ORDER_TYPE_CD'      TO TABLE-ELEMENT-1         
                   MOVE WS-ORDER-TYPE-PRIOR  TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7056-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7060-LANDLORD.                                                   
           MOVE WS-PREMISE-NO-NUM TO SI-PREMISE-NO                      
           EXEC SQL                                                     
               SELECT TOP(1) CUSTOMER_NO                                       
                 INTO :SI-CUSTOMER-NO                                   
                 FROM CSS_LANDLORD WITH(READUNCOMMITTED)                        
                WHERE PREMISE_NO = :SI-PREMISE-NO                       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*          INTO :SI-CUSTOMER-NO                                           
MFA-TR*          FROM CSS_LANDLORD                                              
MFA-TR*         WHERE PREMISE_NO = :SI-PREMISE-NO                               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7060                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF SI-CUSTOMER-NO = WS-NEW-CUSTOMER-NO-NUM           
                       MOVE 'Y' TO WS-NEW-CUST-IS-LL-FL                 
                   ELSE                                                 
                       MOVE 'N' TO WS-NEW-CUST-IS-LL-FL                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A04670                            SI-CUSTOMER-NO                        
                   MOVE 'N' TO WS-NEW-CUST-IS-LL-FL                     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7060'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                   MOVE 'CSS_LANDLORD'   TO TABLE-1                     
                   MOVE 'PREMISE_NO'     TO TABLE-ELEMENT-1             
                   MOVE SI-PREMISE-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04670 7070-SELECT-DELINQ.                                              
A04670                                                                  
A04670     EXEC SQL                                                     
A04670        SELECT C8.DELINQ_VALUE                                    
A04670          INTO :WS-THRESHOLD                                      
A04670          FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
A04670         WHERE C8.DELINQ_CD   = 'AMT-STRTUP-THRESHOLD'            
A04670           AND  COMPANY_NO    = :AT-COMPANY-NO                    
A04670                                                           
A04670                                                     
A04670     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :WS-THRESHOLD                                              
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD   = 'AMT-STRTUP-THRESHOLD'                    
MFA-TR*          AND  COMPANY_NO    = :AT-COMPANY-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 70102                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04670                                                                  
A04670     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04670     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04670         WHEN SUCCESSFUL-CALL                                     
A04670             CONTINUE                                             
A04670         WHEN NOT-FOUND                                           
A04670             MOVE 0.00 TO WS-THRESHOLD                            
A04670         WHEN OTHER                                               
A04670             MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
A04670             MOVE '7010'                   TO ACTIVE-PARAGRAPH    
A04670             MOVE 'SELECT'                 TO ABEND-FUNCTION      
A04670             MOVE SPACES                   TO ABEND-SQL-PREDICATES
A04670                                             ABEND-TABLES         
A04670             MOVE 'CSS_DELINQUENCY'        TO TABLE-1             
A04670             MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1     
A04670             MOVE 'AMT-STRTUP-THRESHOLD'   TO HOSTVAR-ELEMENT-1   
A04670             MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2     
A04670             MOVE AT-COMPANY-NO            TO HOSTVAR-ELEMENT-2   
A04670             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A04670     END-EVALUATE.                                                
A04670                                                                  
A04670 7070-EXIT.                                                       
A04670     EXIT.                                                        
                                                                        
                                                                        
P0795B 7080-REV-DIST-RLSE.                                              
P0795B                                                                  
P0795B     EXEC SQL                                                     
P0795B        SELECT A9.RLSE_REQUIRED_IND                               
P0795B          INTO :A9-RLSE-REQUIRED-IND                              
P0795B          FROM CSS_REV_DISTRICT A9 WITH(READUNCOMMITTED)                  
P0795B         WHERE REV_DISTRICT_CD = :PR-REV-DISTRICT-CD              
P0795B                                                           
P0795B                                                      
P0795B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A9.RLSE_REQUIRED_IND                                       
MFA-TR*         INTO :A9-RLSE-REQUIRED-IND                                      
MFA-TR*         FROM CSS_REV_DISTRICT A9                                        
MFA-TR*        WHERE REV_DISTRICT_CD = :PR-REV-DISTRICT-CD                      
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795B                                                                  
P0795B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0795B     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795B         WHEN SUCCESSFUL-CALL                                     
P0795B                PERFORM 7085-NEWSET-RLSE-RQMT THRU 7085-EXIT      
P0795B         WHEN NOT-FOUND                                           
P0795B             MOVE 'N' TO A9-RLSE-REQUIRED-IND                     
P0795B         WHEN OTHER                                               
P0795B             MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
P0795B             MOVE '7080'                   TO ACTIVE-PARAGRAPH    
P0795B             MOVE 'SELECT'                 TO ABEND-FUNCTION      
P0795B             MOVE SPACES                   TO ABEND-SQL-PREDICATES
P0795B                                             ABEND-TABLES         
P0795B             MOVE 'CSS_REV-DISTRICT'       TO TABLE-1             
P0795B             MOVE 'REV_DISTRICT_CD'        TO TABLE-ELEMENT-1     
P0795B             MOVE A9-REV-DISTRICT-CD       TO HOSTVAR-ELEMENT-1   
P0795B             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0795B     END-EVALUATE.                                                
P0795B                                                                  
P0795B 7080-EXIT.                                                       
P0795B     EXIT.                                                        
                                                                        
P0795B 7085-NEWSET-RLSE-RQMT.                                           
P0795B                                                                  
P0795B     EXEC SQL                                                     
P0795B        SELECT BA.SET_NEW_SET_FL                                  
P0795B          INTO :BA-SET-NEW-SET-FL                                 
P0795B          FROM CSS_RLSE_REV_DIST  BA WITH(READUNCOMMITTED)                
P0795B         WHERE REV_DISTRICT_CD = :PR-REV-DISTRICT-CD              
P0795B           AND COMPANY_NO      = :AT-COMPANY-NO                   
P0795B           AND CODE_UTIL_TYPE  = :BA-CODE-UTIL-TYPE               
P0795B                                                           
P0795B                                                      
P0795B     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BA.SET_NEW_SET_FL                                          
MFA-TR*         INTO :BA-SET-NEW-SET-FL                                         
MFA-TR*         FROM CSS_RLSE_REV_DIST  BA                                      
MFA-TR*        WHERE REV_DISTRICT_CD = :PR-REV-DISTRICT-CD                      
MFA-TR*          AND COMPANY_NO      = :AT-COMPANY-NO                           
MFA-TR*          AND CODE_UTIL_TYPE  = :BA-CODE-UTIL-TYPE                       
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7085                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795B                                                                  
P0795B     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0795B     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795B         WHEN SUCCESSFUL-CALL                                     
P0795B             CONTINUE                                             
P0795B         WHEN NOT-FOUND                                           
P0795B             MOVE 'N' TO BA-SET-NEW-SET-FL                        
P0795B         WHEN OTHER                                               
P0795B             MOVE PROGRAM-NAME             TO ABEND-PROGRAM       
P0795B             MOVE '7085'                   TO ACTIVE-PARAGRAPH    
P0795B             MOVE 'SELECT'                 TO ABEND-FUNCTION      
P0795B             MOVE SPACES                   TO ABEND-SQL-PREDICATES
P0795B                                             ABEND-TABLES         
P0795B             MOVE 'CSS_RLSE-REV-DIST'      TO TABLE-1             
P0795B             MOVE 'REV_DISTRICT_CD'        TO TABLE-ELEMENT-1     
P0795B             MOVE BA-REV-DISTRICT-CD       TO HOSTVAR-ELEMENT-1   
P0795B             MOVE 'COMPANY-NO'             TO TABLE-ELEMENT-2     
P0795B             MOVE BA-COMPANY-NO            TO HOSTVAR-ELEMENT-2   
P0795B             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0795B     END-EVALUATE.                                                
P0795B                                                                  
P0795B 7085-EXIT.                                                       
P0795B     EXIT.                                                        
                                                                        
DT9484 7090-COUNT-PENDING-OFF.                                          
           MOVE WS-PREMISE-NO-NUM TO PR-PREMISE-NO                      
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-COUNT                                          
                FROM CSS_SO_DATA WITH(READUNCOMMITTED)                          
               WHERE PREMISE_NO      = :PR-PREMISE-NO                   
                 AND ORDER_TYPE_CD   LIKE 'OFF%'                        
                 AND ORDER_STATE_CD  NOT IN ('C', 'Z')                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-COUNT                                                  
MFA-TR*         FROM CSS_SO_DATA                                                
MFA-TR*        WHERE PREMISE_NO      = :PR-PREMISE-NO                           
MFA-TR*          AND ORDER_TYPE_CD   LIKE 'OFF%'                                
MFA-TR*          AND ORDER_STATE_CD  NOT IN ('C', 'Z')                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 0 TO WS-COUNT                                   
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7090'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_SO_DATA'       TO TABLE-1                  
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7090-EXIT.                                                       
           EXIT.                                                        
                                                                        
DT8959 7092-GET-XFER-TO-INFO.                                           
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-11.                             
           EXEC SQL                                                     
                  SELECT ACCOUNT_NO,                                    
                         CODE_ACCT_STAT,                                
                         ADDR_USAGE_CD,                                 
                         RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + 
           LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2) + ' ' + ';' + ' ' + LTRIM(RTRIM(TOWN) + 
           ', ' + LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(DY.ZIP_CODE)))
           )))))))))),          
                         RTRIM(LTRIM(RTRIM(STREET_NAME) + ' & ' + LTRIM(
           RTRIM(ADDRESS_OVERFLOW) + ' ' + ';' + ' ' + LTRIM(RTRIM(TOWN
           ) + ', ' + LTRIM(RTRIM(STATE) + ' ' + LTRIM(RTRIM(
           DY.ZIP_CODE)))))))                 
                    INTO :S-ACCOUNT-NO-11,                              
                         :S-CODE-ACCT-STAT-11,                          
                         :DY-ADDR-USAGE-CD,                             
                         :WS-ADDRESS-LINE,                              
                         :WS-ADDRESS-LINE-I                             
                    FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED),                  
                         CSS_PREMISE PR WITH(READUNCOMMITTED),                  
                         CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),           
                         CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                  
                   WHERE ACCOUNT_NO = :TO-ACCT-NO-4478                  
                     AND AT.PREMISE_NO = PR.PREMISE_NO                  
                     AND PR.ADDRESS_ID = DY.ADDRESS_ID                  
                     AND DY.ZIP_CODE = A4.ZIP_CODE                      
                     AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*           SELECT ACCOUNT_NO,                                            
MFA-TR*                  CODE_ACCT_STAT,                                        
MFA-TR*                  ADDR_USAGE_CD,                                         
MFA-TR*                  RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                  
MFA-TR*                  LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(STREET_NAME) || ' ' ||                     
MFA-TR*                  LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                   
MFA-TR*                  LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                     
MFA-TR*                  LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||               
MFA-TR*                  LTRIM(RTRIM(STREET_LOCATION_2) || ' ' ||               
MFA-TR*                  ';' || ' ' ||                                          
MFA-TR*                  LTRIM(RTRIM(TOWN) || ', ' ||                           
MFA-TR*                  LTRIM(RTRIM(STATE) || ' ' ||                           
MFA-TR*                  LTRIM(RTRIM(DY.ZIP_CODE))))))))))))),                  
MFA-TR*                  RTRIM(LTRIM(RTRIM(STREET_NAME) || ' & ' ||             
MFA-TR*                  LTRIM(RTRIM(ADDRESS_OVERFLOW) || ' ' ||                
MFA-TR*                  ';' || ' ' ||                                          
MFA-TR*                  LTRIM(RTRIM(TOWN) || ', ' ||                           
MFA-TR*                  LTRIM(RTRIM(STATE) || ' ' ||                           
MFA-TR*                  LTRIM(RTRIM(DY.ZIP_CODE)))))))                         
MFA-TR*             INTO :S-ACCOUNT-NO-11,                                      
MFA-TR*                  :S-CODE-ACCT-STAT-11,                                  
MFA-TR*                  :DY-ADDR-USAGE-CD,                                     
MFA-TR*                  :WS-ADDRESS-LINE,                                      
MFA-TR*                  :WS-ADDRESS-LINE-I                                     
MFA-TR*             FROM CSS_ACCOUNT AT,                                        
MFA-TR*                  CSS_PREMISE PR,                                        
MFA-TR*                  CSS_ADDR_FORMATTED DY,                                 
MFA-TR*                  CSS_ZIP_CODE A4                                        
MFA-TR*            WHERE ACCOUNT_NO = :TO-ACCT-NO-4478                          
MFA-TR*              AND AT.PREMISE_NO = PR.PREMISE_NO                          
MFA-TR*              AND PR.ADDRESS_ID = DY.ADDRESS_ID                          
MFA-TR*              AND DY.ZIP_CODE = A4.ZIP_CODE                              
MFA-TR*              AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                  
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 7092                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF DY-ADDR-USAGE-CD = 'I'                            
                       MOVE WS-ADDRESS-LINE-I TO S-ADDRESS-LINE         
                   ELSE                                                 
                       MOVE WS-ADDRESS-LINE TO S-ADDRESS-LINE           
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
                   MOVE SQLCODE             TO ABEND-SQLCODE            
                   MOVE SQLSTATE            TO ABEND-SQLSTATE           
                   MOVE '7092'              TO ACTIVE-PARAGRAPH         
                   MOVE 'SELECT'            TO ABEND-FUNCTION           
                   MOVE 'CSS_ACCOUNT'       TO TABLE-1                  
                   MOVE 'ACCOUNT-NO'        TO TABLE-ELEMENT-1          
                   MOVE TO-ACCT-NO-4478     TO HOSTVAR-ELEMENT-1        
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7092-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-ACCT-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
               OPEN ACCT-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7101-FETCH-ACCT-CURSOR.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-11.                             
           MOVE 'N' TO WS-ORDER-FL.                                     
                                                                        
           EXEC SQL                                                     
               FETCH ACCT-CURSOR                                        
                INTO :S-ACCOUNT-NO-11,                                  
                     :S-CODE-ACCT-STAT-11,                              
                     :DY-ADDR-USAGE-CD,                                 
                     :WS-ADDRESS-LINE,                                  
                     :WS-ADDRESS-LINE-I                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF S-CODE-ACCT-STAT-11 = 'P'                         
                       PERFORM 7150-PENDING-ACCT-ORDERS THRU 7150-EXIT  
                   END-IF                                               
                   IF DY-ADDR-USAGE-CD = 'I'                            
                       MOVE WS-ADDRESS-LINE-I TO S-ADDRESS-LINE         
                   ELSE                                                 
                       MOVE WS-ADDRESS-LINE TO S-ADDRESS-LINE           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7101'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7102-CLOSE-ACCT-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
               CLOSE ACCT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7102'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
P0795A*7110-OPEN-MKT-CONTRACTS.                                                 
P0795A*                                                                         
P0795A*    EXEC SQL                                                             
P0795A*        OPEN MKT-CONTRACTS                                               
P0795A*    END-EXEC.                                                            
P0795A*                                                                         
P0795A*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
P0795A*                                                                         
P0795A*    EVALUATE WS-ACTIVE-RETURN-CODE                                       
P0795A*        WHEN SUCCESSFUL-CALL                                             
P0795A*            CONTINUE                                                     
P0795A*        WHEN OTHER                                                       
P0795A*            MOVE PROGRAM-NAME     TO ABEND-PROGRAM                       
P0795A*            MOVE '7110'           TO ACTIVE-PARAGRAPH                    
P0795A*            MOVE 'OPEN'           TO ABEND-FUNCTION                      
P0795A*            MOVE SPACES           TO ABEND-SQL-PREDICATES                
P0795A*                                          ABEND-TABLES                   
P0795A*            MOVE 'CSS_MSE_CNT_SUMM'   TO TABLE-1                         
P0795A*            MOVE 'ACCOUNT-NO'        TO TABLE-ELEMENT-1                  
P0795A*            MOVE AW-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2                
P0795A*            PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                    
P0795A*    END-EVALUATE.                                                        
P0795A*                                                                         
P0795A*7110-EXIT.                                                               
P0795A*    EXIT.                                                                
P0795A**                                                                        
P0795A*7111-FETCH-MKT-CONTRACTS.                                                
P0795A*                                                                         
P0795A*    INITIALIZE GTT-RETURN-FIELDS-12.                                     
P0795A*                                                                         
P0795A*    EXEC SQL                                                             
P0795A*        FETCH MKT-CONTRACTS                                              
P0795A*         INTO :S-CUST-CNT-ID,                                            
P0795A*              :S-CNT-STATUS-CD                                           
P0795A*    END-EXEC.                                                            
P0795A*                                                                         
P0795A*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
P0795A*                                                                         
P0795A*    EVALUATE WS-ACTIVE-RETURN-CODE                                       
P0795A*        WHEN SUCCESSFUL-CALL                                             
P0795A*            CONTINUE                                                     
P0795A*        WHEN NOT-FOUND                                                   
P0795A*            CONTINUE                                                     
P0795A*        WHEN OTHER                                                       
P0795A*            MOVE PROGRAM-NAME     TO ABEND-PROGRAM                       
P0795A*            MOVE '7111'           TO ACTIVE-PARAGRAPH                    
P0795A*            MOVE 'FETCH'          TO ABEND-FUNCTION                      
P0795A*            MOVE SPACES           TO ABEND-SQL-PREDICATES                
P0795A*                                          ABEND-TABLES                   
P0795A*            MOVE 'CSS_MSE_CNT_SUMM'   TO TABLE-1                         
P0795A*            MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1                  
P0795A*            MOVE AW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2               
P0795A*            PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                    
P0795A*    END-EVALUATE.                                                        
P0795A*                                                                         
P0795A*7111-EXIT.                                                               
P0795A*    EXIT.                                                                
P0795A*                                                                         
P0795A*7112-CLOSE-MKT-CONTRACTS.                                                
P0795A*                                                                         
P0795A*    EXEC SQL                                                             
P0795A*        CLOSE MKT-CONTRACTS                                              
P0795A*    END-EXEC.                                                            
P0795A*                                                                         
P0795A*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
P0795A*                                                                         
P0795A*    EVALUATE WS-ACTIVE-RETURN-CODE                                       
P0795A*        WHEN SUCCESSFUL-CALL                                             
P0795A*            CONTINUE                                                     
P0795A*        WHEN OTHER                                                       
P0795A*            MOVE PROGRAM-NAME     TO ABEND-PROGRAM                       
P0795A*            MOVE '7112'           TO ACTIVE-PARAGRAPH                    
P0795A*            MOVE 'CLOSE'          TO ABEND-FUNCTION                      
P0795A*            MOVE SPACES           TO ABEND-SQL-PREDICATES                
P0795A*                                          ABEND-TABLES                   
P0795A*            MOVE 'CSS_MSE_CNT_SUMM'   TO TABLE-1                         
P0795A*            MOVE 'ACCOUNT-NO'        TO TABLE-ELEMENT-1                  
P0795A*            MOVE AW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2               
P0795A*            PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                    
P0795A*    END-EVALUATE.                                                        
P0795A*                                                                         
P0795A*7112-EXIT.                                                               
P0795A*    EXIT.                                                                
                                                                        
       7150-PENDING-ACCT-ORDERS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) SERV_ORDER_NO                                     
                 INTO :VO-SERV-ORDER-NO                                 
                 FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :S-ACCOUNT-NO-11                     
                  AND ORDER_STATE_CD IN ('A', 'H', 'D', 'B', 'R')       
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SERV_ORDER_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO                                         
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE ACCOUNT_NO = :S-ACCOUNT-NO-11                             
MFA-TR*           AND ORDER_STATE_CD IN ('A', 'H', 'D', 'B', 'R')               
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7150                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE 'Y' TO WS-ORDER-FL                              
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                   MOVE 'N' TO WS-ORDER-FL                              
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7150'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'        TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE S-ACCOUNT-NO-11      TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795 7160-GET-ORDER-TYPE-INFO.                                        
P00795                                                                  
P0795F     MOVE SPACES TO C2-SAME-DAY-ORDER-FL                          
P00795     EXEC SQL                                                     
P00795         SELECT ORDER_GROUP_CD                                    
P00795               ,CODE_UTIL_TYPE                                    
P0795F               ,SAME_DAY_ORDER_FL                                 
P0795F               ,PRIORITY_CD                                       
P00795           INTO :C2-ORDER-GROUP-CD                                
P00795               ,:C2-CODE-UTIL-TYPE                                
P0795F               ,:C2-SAME-DAY-ORDER-FL                             
P0795F               ,:C2-PRIORITY-CD                                   
P00795           FROM CSS_ORDER_TYPE WITH(READUNCOMMITTED)                      
P00795          WHERE ORDER_TYPE_CD =  :C2-ORDER-TYPE-CD                
P00795            AND COMPANY_NO    = :AT-COMPANY-NO                    
P00795                                                           
P00795                                                      
P00795     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ORDER_GROUP_CD                                            
MFA-TR*              ,CODE_UTIL_TYPE                                            
MFA-TR*              ,SAME_DAY_ORDER_FL                                         
MFA-TR*              ,PRIORITY_CD                                               
MFA-TR*          INTO :C2-ORDER-GROUP-CD                                        
MFA-TR*              ,:C2-CODE-UTIL-TYPE                                        
MFA-TR*              ,:C2-SAME-DAY-ORDER-FL                                     
MFA-TR*              ,:C2-PRIORITY-CD                                           
MFA-TR*          FROM CSS_ORDER_TYPE                                            
MFA-TR*         WHERE ORDER_TYPE_CD =  :C2-ORDER-TYPE-CD                        
MFA-TR*           AND COMPANY_NO    = :AT-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7160                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00795                                                                  
P00795     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00795         WHEN SUCCESSFUL-CALL                                     
P00795              CONTINUE                                            
P00795         WHEN OTHER                                               
P00795             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
P00795             MOVE '7160'           TO ACTIVE-PARAGRAPH            
P00795             MOVE 'SELECT'         TO ABEND-FUNCTION              
P00795             MOVE SPACES           TO ABEND-SQL-PREDICATES        
P00795                                           ABEND-TABLES           
P00795             MOVE 'CSS_ORDER-TYPE'     TO TABLE-1                 
P00795             MOVE 'ORDER-TYPE'         TO TABLE-ELEMENT-1         
P00795             MOVE C2-ORDER-TYPE-CD     TO HOSTVAR-ELEMENT-1       
P00795             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P00795     END-EVALUATE.                                                
P00795                                                                  
P00795 7160-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
P0795D 7165-IS-ORDWK-TYPE-VALID.                                        
P0795D                                                                  
P0795D     MOVE 'N' TO WS-ORDWK-VALID-FL.                               
P0795D     EXEC SQL                                                     
DT6945        SELECT TOP(1) 'Y',
              SAME_DAY_FL                                   
P0795D          INTO :WS-ORDWK-VALID-FL,                                
DT6945               :L3-SAME-DAY-FL                                    
P0795D          FROM CSS_ORDER_WK_TYPE WITH(READUNCOMMITTED)                    
P0795D         WHERE ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                  
P0795D           AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                   
P0795D           AND COMPANY_NO    = :AT-COMPANY-NO                     
P0795D           AND (STATUS_CHANGE_DT IS NULL                          
P0795D            OR STATUS_CHANGE_DT > CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              ) )                
P0795D                                           
P0795D                                                           
P0795D                                                      
P0795D     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y', SAME_DAY_FL                                           
MFA-TR*         INTO :WS-ORDWK-VALID-FL,                                        
MFA-TR*              :L3-SAME-DAY-FL                                            
MFA-TR*         FROM CSS_ORDER_WK_TYPE                                          
MFA-TR*        WHERE ORDER_TYPE_CD = :L3-ORDER-TYPE-CD                          
MFA-TR*          AND WORK_TYPE_CD  = :L3-WORK-TYPE-CD                           
MFA-TR*          AND COMPANY_NO    = :AT-COMPANY-NO                             
MFA-TR*          AND (STATUS_CHANGE_DT IS NULL                                  
MFA-TR*           OR STATUS_CHANGE_DT > :WS-CURRENT-TS )                        
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7165                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0795D                                                                  
P0795D     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
P0795D                                                                  
P0795D     EVALUATE WS-ACTIVE-RETURN-CODE                               
P0795D         WHEN SUCCESSFUL-CALL                                     
P0795D             MOVE 'Y' TO WS-ORDWK-VALID-FL                        
P0795D         WHEN NOT-FOUND                                           
P0795D             MOVE 'N' TO WS-ORDWK-VALID-FL                        
P0795D             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P0795D         WHEN OTHER                                               
P0795D             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
P0795D             MOVE SQLCODE             TO ABEND-SQLCODE            
P0795D             MOVE SQLSTATE            TO ABEND-SQLSTATE           
P0795D             MOVE '7165'              TO ACTIVE-PARAGRAPH         
P0795D             MOVE 'SELECT'            TO ABEND-FUNCTION           
P0795D             MOVE 'CSS_ORDER_TYPE'    TO TABLE-1                  
P0795D             MOVE 'ORDER-TYPE-CD'     TO TABLE-ELEMENT-1          
P0795D             MOVE L3-ORDER-TYPE-CD    TO HOSTVAR-ELEMENT-1        
P0795D             MOVE 'WORK-TYPE-CD'      TO TABLE-ELEMENT-2          
P0795D             MOVE L3-WORK-TYPE-CD     TO HOSTVAR-ELEMENT-2        
P0795D             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
P0795D     END-EVALUATE.                                                
P0795D                                                                  
P0795D 7165-EXIT.                                                       
P0795D     EXIT.                                                        
                                                                        
                                                                        
       7170-SO-APPL-COUNT.                                              
                                                                        
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-C.               
           MOVE WS-SERV-ORDER-NO-N TO VQ-SERV-ORDER-NO.                 
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-SO-APPL-COUNT                                 
                 FROM CSS_SO_APPLIANCE WITH(READUNCOMMITTED)                    
                WHERE SERV_ORDER_NO = :VQ-SERV-ORDER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-SO-APPL-COUNT                                         
MFA-TR*          FROM CSS_SO_APPLIANCE                                          
MFA-TR*         WHERE SERV_ORDER_NO = :VQ-SERV-ORDER-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7170                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-SO-APPL-COUNT                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7170'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_APPLIANCE'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'      TO TABLE-ELEMENT-1         
                   MOVE VQ-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7175-PREMISE-APPL-COUNT.                                         
           MOVE WS-PREMISE-NO-NUM TO LA-PREMISE-NO                      
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-PREMISE-APPL-COUNT                            
                 FROM CSS_APPLIANCE LA WITH(READUNCOMMITTED),                   
                      CSS_MKT_APPLIANCE JA WITH(READUNCOMMITTED)                
                WHERE PREMISE_NO = :LA-PREMISE-NO                       
                  AND PRIMARY_FUEL_CD = 'NA-GAS'                        
                  AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                 
                  AND LA.COMPANY_NO = JA.COMPANY_NO                     
                  AND CIS_DISPLAY_FL = 'Y'                              
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-PREMISE-APPL-COUNT                                    
MFA-TR*          FROM CSS_APPLIANCE LA,                                         
MFA-TR*               CSS_MKT_APPLIANCE JA                                      
MFA-TR*         WHERE PREMISE_NO = :LA-PREMISE-NO                               
MFA-TR*           AND PRIMARY_FUEL_CD = 'NA-GAS'                                
MFA-TR*           AND LA.APPLIANCE_CD = JA.APPLIANCE_CD                         
MFA-TR*           AND LA.COMPANY_NO = JA.COMPANY_NO                             
MFA-TR*           AND CIS_DISPLAY_FL = 'Y'                                      
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7175                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
                                  WS-PREMISE-APPL-COUNT                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7175'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'   TO TABLE-1                    
                   MOVE 'PREMISE_NO'      TO TABLE-ELEMENT-1            
                   MOVE LA-PREMISE-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7175-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7180-GET-PREM-APPL.                                              
           PERFORM 7210-OPEN-PREM-APPL-CURSOR  THRU 7210-EXIT.          
           PERFORM 7211-FETCH-PREM-APPL-CURSOR THRU 7211-EXIT VARYING   
                     T1-INDEX FROM 1 BY 1 UNTIL                         
                     T1-INDEX > 30 OR                                   
                     WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
           PERFORM 7212-CLOSE-PREM-APPL-CURSOR THRU 7212-EXIT.          
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7185-GET-ORDER-APPL.                                             
           PERFORM 7220-OPEN-ORDER-APPL-CURSOR THRU 7220-EXIT.          
           PERFORM 7221-FETCH-ORDER-APPL-CURSOR THRU 7221-EXIT VARYING  
                     T2-INDEX FROM 1 BY 1 UNTIL                         
                     T2-INDEX > 30 OR                                   
                     WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
           PERFORM 7222-CLOSE-ORDER-APPL-CURSOR THRU 7222-EXIT.         
                                                                        
       7185-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7190-COMPARE-APPLIANCE.                                          
                                                                        
           PERFORM VARYING T1-INDEX FROM 1 BY 1                         
SCA006       UNTIL WS-APPLIANCE-RELOAD-FL = 'Y' OR 
                   T1-INDEX > 30 OR 
                   T1-EQUIPMENT-NO (T1-INDEX) <= ' '                      
             MOVE 'N' TO WS-APPL-MATCH                                  
             PERFORM VARYING T2-INDEX FROM 1 BY 1                       
               UNTIL T2-INDEX > 30 OR T1-EQUIPMENT-NO (T2-INDEX) <= ' ' 
                  IF  T1-EQUIPMENT-NO(T1-INDEX) =                       
                                     T2-EQUIPMENT-NO(T2-INDEX)          
                      MOVE 'Y' TO WS-APPL-MATCH                         
                  END-IF                                                
             END-PERFORM                                                
             IF WS-APPL-MATCH = 'N'                                     
                MOVE 'Y' TO WS-APPLIANCE-RELOAD-FL                      
             END-IF                                                     
           END-PERFORM.                                                 
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-MAINT-ACCT-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               OPEN MAINT-ACCT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7200'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7201-FETCH-MAINT-ACCT-CURSOR.                                    
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-11.                             
           MOVE 'N' TO WS-ORDER-FL.                                     
                                                                        
           EXEC SQL                                                     
               FETCH MAINT-ACCT-CURSOR                                  
                INTO :S-ACCOUNT-NO-11,                                  
                     :S-CODE-ACCT-STAT-11,                              
                     :DY-ADDR-USAGE-CD,                                 
                     :WS-ADDRESS-LINE,                                  
                     :WS-ADDRESS-LINE-I                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF S-CODE-ACCT-STAT-11 = 'P'                         
                       PERFORM 7150-PENDING-ACCT-ORDERS THRU 7150-EXIT  
                   END-IF                                               
                   IF DY-ADDR-USAGE-CD = 'I'                            
                       MOVE WS-ADDRESS-LINE-I TO S-ADDRESS-LINE         
                   ELSE                                                 
                       MOVE WS-ADDRESS-LINE TO S-ADDRESS-LINE           
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7201'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7201-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7202-CLOSE-MAINT-ACCT-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE MAINT-ACCT-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7202'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ACCOUNT'        TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1         
                   MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7202-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-OPEN-PREM-APPL-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               OPEN PREM-APPL-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7210'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'      TO TABLE-1                 
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7211-FETCH-PREM-APPL-CURSOR.                                     
                                                                        
                                                                        
           EXEC SQL                                                     
               FETCH PREM-APPL-CURSOR                                   
                INTO :LA-EQUIPMENT-NO                                   
                    ,:LA-APPLIANCE-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE LA-EQUIPMENT-NO TO T1-EQUIPMENT-NO (T1-INDEX)  
                    MOVE LA-APPLIANCE-CD TO T1-APPLIANCE-CD (T1-INDEX)  
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7211'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'      TO TABLE-1                 
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7211-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7212-CLOSE-PREM-APPL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               CLOSE PREM-APPL-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7212'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_APPLIANCE'      TO TABLE-1                 
                   MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1          
                   MOVE LA-PREMISE-NO        TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7212-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-OPEN-ORDER-APPL-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               OPEN ORDER-APPL-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7220'           TO ACTIVE-PARAGRAPH            
                   MOVE 'OPEN'           TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_APPLIANCE'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VQ-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7221-FETCH-ORDER-APPL-CURSOR.                                    
                                                                        
                                                                        
           EXEC SQL                                                     
               FETCH ORDER-APPL-CURSOR                                  
                INTO :VQ-EQUIPMENT-UNQ                                  
                    ,:VQ-APPLIANCE-CD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE VQ-EQUIPMENT-UNQ TO T2-EQUIPMENT-NO (T2-INDEX) 
                    MOVE VQ-APPLIANCE-CD TO T2-APPLIANCE-CD (T2-INDEX)  
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7221'           TO ACTIVE-PARAGRAPH            
                   MOVE 'FETCH'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_APPLIANCE'  TO TABLE-1                  
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VQ-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7221-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7222-CLOSE-ORDER-APPL-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE ORDER-APPL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7222'           TO ACTIVE-PARAGRAPH            
                   MOVE 'CLOSE'          TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_APPLIANCE'   TO TABLE-1                 
                   MOVE 'SERV_ORDER_NO'     TO TABLE-ELEMENT-1          
                   MOVE VQ-SERV-ORDER-NO     TO HOSTVAR-ELEMENT-2       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7222-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-GET-SO-DATA.                                                
                                                                        
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-C.               
           MOVE WS-SERV-ORDER-NO-N TO VO-SERV-ORDER-NO.                 
           EXEC SQL                                                     
               SELECT ORDER_TYPE_CD                                     
                 INTO :VO-ORDER-TYPE-CD                                 
                 FROM CSS_SO_DATA VO WITH(READUNCOMMITTED)                      
                WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ORDER_TYPE_CD                                             
MFA-TR*          INTO :VO-ORDER-TYPE-CD                                         
MFA-TR*          FROM CSS_SO_DATA VO                                            
MFA-TR*         WHERE SERV_ORDER_NO = :VO-SERV-ORDER-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7250                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE VO-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD           
                                               C2-ORDER-TYPE-CD         
                                               L3-ORDER-TYPE-CD         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7250'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_DATA'      TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE VO-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7260-GET-HST-SO-DATA.                                            
                                                                        
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-C.               
           MOVE WS-SERV-ORDER-NO-N TO YV-SERV-ORDER-NO.                 
           EXEC SQL                                                     
               SELECT ORDER_TYPE_CD                                     
                 INTO :YV-ORDER-TYPE-CD                                 
                 FROM HST_SO_DATA YV WITH(READUNCOMMITTED)                      
                WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ORDER_TYPE_CD                                             
MFA-TR*          INTO :YV-ORDER-TYPE-CD                                         
MFA-TR*          FROM HST_SO_DATA YV                                            
MFA-TR*         WHERE SERV_ORDER_NO = :YV-SERV-ORDER-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7260                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE YV-ORDER-TYPE-CD TO WS-ORDER-TYPE-CD            
                                              C2-ORDER-TYPE-CD          
                                              L3-ORDER-TYPE-CD          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7260'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'HST_SO_DATA'      TO TABLE-1                   
                   MOVE 'SERV_ORDER_NO'  TO TABLE-ELEMENT-1             
                   MOVE YV-SERV-ORDER-NO TO HOSTVAR-ELEMENT-1           
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      **  GET PRIORITY FROM CSS_ORDER_PRIORITY TABLE                **          
      ****************************************************************          
                                                                        
       7270-OVERRIDE-PRIORITY.                                          
                                                                        
           EXEC SQL                                                     
               SELECT OVERRIDE_PRTY_CD                                  
                 INTO :OY-OVERRIDE-PRTY-CD                              
                 FROM CSS_ORDER_PRIORITY WITH(READUNCOMMITTED)                  
                WHERE PRIORITY_CD = :OY-PRIORITY-CD                     
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT OVERRIDE_PRTY_CD                                          
MFA-TR*          INTO :OY-OVERRIDE-PRTY-CD                                      
MFA-TR*          FROM CSS_ORDER_PRIORITY                                        
MFA-TR*         WHERE PRIORITY_CD = :OY-PRIORITY-CD                             
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7270                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'Y' TO OY-OVERRIDE-PRTY-CD                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7270'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_ORDER-PRIORITY' TO TABLE-1                 
                   MOVE OY-OVERRIDE-PRTY-CD     TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **  GET TASK-STATUS-CD FROM CSS_SO_ORDER_INST                 **          
      ****************************************************************          
                                                                        
D10004 7280-GET-TASK-STATUS.                                            
                                                                        
           MOVE SPACES TO VI-TASK-STATUS-CD                             
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-C.               
           MOVE WS-SERV-ORDER-NO-N TO VI-SERV-ORDER-NO.                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TASK_STATUS_CD                                    
                 INTO :VI-TASK-STATUS-CD                                
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                 
                  AND WORK_TYPE_CD <> ''                                
                                                  
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TASK_STATUS_CD                                            
MFA-TR*          INTO :VI-TASK-STATUS-CD                                        
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO = :VI-SERV-ORDER-NO                         
MFA-TR*           AND WORK_TYPE_CD <> ''                                        
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7280                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE VI-TASK-STATUS-CD TO S-TASK-STATUS-CD-12        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7280'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_SO_ORDER_INST' TO TABLE-1                  
                   MOVE VI-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
A10004 7282-GET-TASK-STATUS-HIST.                                       
                                                                        
           MOVE SPACES TO ZG-TASK-STATUS-CD                             
           MOVE LINK-SERV-ORDER-NO TO WS-SERV-ORDER-NO-C.               
           MOVE WS-SERV-ORDER-NO-N TO ZG-SERV-ORDER-NO.                 
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) TASK_STATUS_CD                                    
                 INTO :ZG-TASK-STATUS-CD                                
                 FROM HST_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO = :ZG-SERV-ORDER-NO                 
                  AND WORK_TYPE_CD <> ''                                
                                                  
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TASK_STATUS_CD                                            
MFA-TR*          INTO :ZG-TASK-STATUS-CD                                        
MFA-TR*          FROM HST_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO = :ZG-SERV-ORDER-NO                         
MFA-TR*           AND WORK_TYPE_CD <> ''                                        
MFA-TR*         FETCH FIRST 1 ROW ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7282                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE ZG-TASK-STATUS-CD TO S-TASK-STATUS-CD-12        
               WHEN NOT-FOUND                                           
                   MOVE SPACES            TO S-TASK-STATUS-CD-12        
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7282'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'HST_SO_ORDER_INST' TO TABLE-1                  
                   MOVE ZG-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7282-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
D10775 7290-SELECT-BANKRUPTCY.                                          
                                                                        
           MOVE AT-BNKRPT-CASE-NO  TO BQ-BNKRPT-CASE-NO .               
           EXEC SQL                                                     
               SELECT BNKRPT_CASE_NO                                    
                     ,FILED_CASE_NO                                     
                     ,DATE_BNKRPT_FILED                                 
                     ,BANKRUPTCY_CHAPTER                                
                 INTO :BQ-BNKRPT-CASE-NO                                
                     ,:BQ-FILED-CASE-NO                                 
                     ,:BQ-DATE-BNKRPT-FILED                             
                     ,:BQ-BANKRUPTCY-CHAPTER                            
                 FROM CSS_BANKRUPTCY BQ WITH(READUNCOMMITTED)                   
                WHERE BNKRPT_CASE_NO = :BQ-BNKRPT-CASE-NO               
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BNKRPT_CASE_NO                                            
MFA-TR*              ,FILED_CASE_NO                                             
MFA-TR*              ,DATE_BNKRPT_FILED                                         
MFA-TR*              ,BANKRUPTCY_CHAPTER                                        
MFA-TR*          INTO :BQ-BNKRPT-CASE-NO                                        
MFA-TR*              ,:BQ-FILED-CASE-NO                                         
MFA-TR*              ,:BQ-DATE-BNKRPT-FILED                                     
MFA-TR*              ,:BQ-BANKRUPTCY-CHAPTER                                    
MFA-TR*          FROM CSS_BANKRUPTCY BQ                                         
MFA-TR*         WHERE BNKRPT_CASE_NO = :BQ-BNKRPT-CASE-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7290                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE BQ-BNKRPT-CASE-NO   TO S-BNKRPT-CASE-NO         
                   MOVE BQ-FILED-CASE-NO    TO S-BNKRPT-FILED-CASE-NO   
                   MOVE BQ-DATE-BNKRPT-FILED TO S-BNKRPT-FILED-DATE     
                   MOVE BQ-BANKRUPTCY-CHAPTER TO S-BNKRPT-CHAPTER       
                   MOVE 'Y'             TO WS-BNKRPTCY-ORDER-FL         
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO  BQ-BNKRPT-CASE-NO                    
                   MOVE SPACES TO  BQ-FILED-CASE-NO                     
                   MOVE SPACES TO  BQ-DATE-BNKRPT-FILED                 
                   MOVE SPACES TO  BQ-BANKRUPTCY-CHAPTER                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7290'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_BANKRUPTCY' TO TABLE-1                     
                   MOVE BQ-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
D10775 7300-CHECK-2000-ACCESS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-HAS-2000-ACCESS                               
                 FROM CSS_CATEGORY   F5 WITH(READUNCOMMITTED)                   
                WHERE USER_ID  = :LINK-USERID                           
                AND   CATEGORY_ID = 2000                                
                                                                 
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-HAS-2000-ACCESS                                       
MFA-TR*          FROM CSS_CATEGORY   F5                                         
MFA-TR*         WHERE USER_ID  = :LINK-USERID                                   
MFA-TR*         AND   CATEGORY_ID = 2000                                        
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO  7300                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE 'N' TO WS-HAS-2000-ACCESS                       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE SPACES           TO ABEND-SQL-PREDICATES        
                                                 ABEND-TABLES           
                   MOVE 'CSS_CATEGORY' TO TABLE-1                       
                   MOVE '2000'                  TO HOSTVAR-ELEMENT-1    
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05821 7510-BUILDER-REALTOR.                                            
A05821                                                                  
A05821     MOVE WS-NEW-CUSTOMER-NO-NUM TO LQ-CUSTOMER-NO                
A05821     EXEC SQL                                                     
A05821        SELECT BUILDER_FL,                                        
A05821               REALTOR_FL                                         
A05821          INTO :LQ-BUILDER-FL,                                    
A05821               :LQ-REALTOR-FL                                     
A05821          FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
A05821         WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                      
A05821                                                           
A05821                                                      
A05821     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT BUILDER_FL,                                                
MFA-TR*              REALTOR_FL                                                 
MFA-TR*         INTO :LQ-BUILDER-FL,                                            
MFA-TR*              :LQ-REALTOR-FL                                             
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :LQ-CUSTOMER-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05821                                                                  
A05821     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
A05821                                                                  
A05821     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05821         WHEN SUCCESSFUL-CALL                                     
A05821             IF LQ-BUILDER-FL = 'Y' OR                            
A05821                LQ-REALTOR-FL = 'Y'                               
A05821                    MOVE 'Y' TO WS-CUST-BLDR-RLTR-FL              
A05821             ELSE                                                 
A05821                 MOVE 'N' TO WS-CUST-BLDR-RLTR-FL                 
A05821             END-IF                                               
A05821         WHEN NOT-FOUND                                           
A05821             MOVE 'N' TO WS-CUST-BLDR-RLTR-FL                     
A05821             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05821         WHEN OTHER                                               
A05821             MOVE PROGRAM-NAME  TO ABEND-PROGRAM                  
A05821             MOVE '7510'        TO ACTIVE-PARAGRAPH               
A05821             MOVE 'SELECT'      TO ABEND-FUNCTION                 
A05821             MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
A05821             MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
A05821             MOVE LQ-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
A05821             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
A05821     END-EVALUATE.                                                
A05821                                                                  
A05821 7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
DT6878*****************************************************************         
DT6878* 7620-GET-DATABASE.                                            *         
DT6878*     SELECTS   DATABASE     (SEB OR CSR) FROM CSS_DELINQUENCY *          
DT6878*****************************************************************         
DT6878 7620-GET-DATABASE.                                               
DT6878                                                                  
DT6878     MOVE 'DATABASE'                       TO   C8-DELINQ-CD.     
DT6878     MOVE AT-COMPANY-NO                    TO   C8-COMPANY-NO.    
DT6878     EXEC SQL                                                     
DT6878        SELECT DELINQ_VALUE                                       
DT6878          INTO :C8-DELINQ-VALUE                                   
DT6878          FROM CSS_DELINQUENCY                                    
DT6878         WHERE DELINQ_CD = :C8-DELINQ-CD                          
DT6878           AND COMPANY_NO = :C8-COMPANY-NO                        
DT6878     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DT6878                                                                  
DT6878     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
DT6878                                                                  
DT6878     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
DT6878        MOVE C8-DELINQ-VALUE TO WS-DATABASE                       
DT6878     ELSE                                                         
DT6878        MOVE '7620'                     TO ACTIVE-PARAGRAPH       
DT6878        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
DT6878        MOVE 'SELECT'                   TO ABEND-FUNCTION         
DT6878        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
DT6878        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
DT6878        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
DT6878        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
DT6878        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
DT6878     END-IF.                                                      
DT6878                                                                  
DT6878 7620-EXIT.                                                       
DT6878     EXIT.                                                        
DT6878*                                                                         
                                                                        
                                                                        
       8100-SEND-RESULT-1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R1                            
             (                                                          
              RETURN_CODE,                                              
              STATUS_CODE,                                              
              BUS_RULE_ID,                                              
              ACTION_TYPE_CD,                                           
              BUS_RULE_XREF_ID                                          
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-1,                                        
               :S-STATUS-CODE,                                          
               :S-BUS-RULE-ID,                                          
               :S-ACTION-TYPE-CD,                                       
               :S-BUS-RULE-XREF-ID                                      
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       STATUS_CODE,                                                      
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       ACTION_TYPE_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-1,                                                
MFA-TR*        :S-STATUS-CODE,                                                  
MFA-TR*        :S-BUS-RULE-ID,                                                  
MFA-TR*        :S-ACTION-TYPE-CD,                                               
MFA-TR*        :S-BUS-RULE-XREF-ID                                              
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
A04670     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -204           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R1'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-SEND-RESULT-3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R3                            
             (                                                          
              RETURN_CODE,                                              
              ASSIGNED_DATE,                                            
              SERV_ORDER_NO,                                            
              ORDER_TYPE_CD,                                            
              ORDER_STATE_CD,                                           
              CUSTOMER_NAME,                                            
              REMARKS,                                                  
              WORK_AREA,                                                
              PHONE,                                                    
              REMARK_TYPE,                                              
              SERV_ORDER_STATUS                                         
P00718*       BUSINESS_UNIT                                                     
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-3,                                        
               :S-ASSIGNED-DATE,                                        
               :S-SERV-ORDER-NO-3,                                      
               :S-ORDER-TYPE-CD,                                        
               :S-ORDER-STATE-CD,                                       
               :S-CUSTOMER-NAME,                                        
               :S-REMARKS,                                              
               :S-WORK-AREA-3,                                          
               :S-PHONE,                                                
               :S-REMARK-TYPE,                                          
               :S-SERV-ORDER-STATUS                                     
P00718*        :S-BUSINESS-UNIT-3                                               
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R3                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ASSIGNED_DATE,                                                    
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       ORDER_TYPE_CD,                                                    
MFA-TR*       ORDER_STATE_CD,                                                   
MFA-TR*       CUSTOMER_NAME,                                                    
MFA-TR*       REMARKS,                                                          
MFA-TR*       WORK_AREA,                                                        
MFA-TR*       PHONE,                                                            
MFA-TR*       REMARK_TYPE,                                                      
MFA-TR*       SERV_ORDER_STATUS                                                 
MFA-TR*       BUSINESS_UNIT                                                     
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-3,                                                
MFA-TR*        :S-ASSIGNED-DATE,                                                
MFA-TR*        :S-SERV-ORDER-NO-3,                                              
MFA-TR*        :S-ORDER-TYPE-CD,                                                
MFA-TR*        :S-ORDER-STATE-CD,                                               
MFA-TR*        :S-CUSTOMER-NAME,                                                
MFA-TR*        :S-REMARKS,                                                      
MFA-TR*        :S-WORK-AREA-3,                                                  
MFA-TR*        :S-PHONE,                                                        
MFA-TR*        :S-REMARK-TYPE,                                                  
MFA-TR*        :S-SERV-ORDER-STATUS                                             
MFA-TR*        :S-BUSINESS-UNIT-3                                               
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R3'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8400-SEND-RESULT-4.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R4                            
             (                                                          
              RETURN_CODE,                                              
              CODE_UTIL_TYPE,                                           
              METER_NO,                                                 
              RATE_PLAN,                                                
              SUPPLIES,                                                 
              METER_LOC,                                                
              METER_STATUS,                                             
              METER_STATUS_REASON,                                      
              WORK_TYPE_CD,                                             
              METER_READ_INST,                                          
              METER_IND,                                                
              IC_NO,                                                    
              MTR_REF_NO,                                               
              CODE_REV_CLASS,                                           
              RLSE_REQUIRED,                                            
              RLSE_NO,                                                  
              RLSE_MSG,                                                 
              RLSE_ADDL_MSG,                                            
              RLSE_PHONE,                                               
              RLSE_ALT_PHONE,                                           
              RLSE_REV_DIST,                                            
              BUS_RULE_ID,                                              
              ACTION_TYPE_CD,                                           
              BUS_RULE_XREF_ID,                                         
              RLSE_ENABLED_FL,                                          
              OLD_WORK_TYPE_CD,                                         
              SO_SEQ_NO                                                 
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-4,                                        
               :S-CODE-UTIL-TYPE-4,                                     
               :S-METER-NO-4,                                           
               :S-RATE-PLAN-4,                                          
               :S-SUPPLIES,                                             
               :S-METER-LOC,                                            
               :S-METER-STATUS,                                         
               :S-METER-STATUS-REASON,                                  
               :S-WORK-TYPE-CD-4,                                       
               :S-METER-READ-INST,                                      
               :S-METER-IND,                                            
               :S-IC-NO-4,                                              
               :S-MTR-REF-NO-4,                                         
               :S-CODE-REV-CLASS-4,                                     
               :S-RLSE-REQUIRED,                                        
               :S-RLSE-NO,                                              
               :S-RLSE-MSG,                                             
               :S-RLSE-ADDL-MSG,                                        
               :S-RLSE-PHONE,                                           
               :S-RLSE-ALT-PHONE,                                       
               :S-RLSE-REV-DIST,                                        
               :S-BUS-RULE-ID-4,                                        
               :S-ACTION-TYPE-CD-4,                                     
               :S-BUS-RULE-XREF-ID-4,                                   
               :S-RLSE-ENABLED-FL,                                      
               :S-OLD-WORK-TYPE-CD-4,                                   
               :S-SO-SEQ-NO-4                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R4                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       METER_NO,                                                         
MFA-TR*       RATE_PLAN,                                                        
MFA-TR*       SUPPLIES,                                                         
MFA-TR*       METER_LOC,                                                        
MFA-TR*       METER_STATUS,                                                     
MFA-TR*       METER_STATUS_REASON,                                              
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       METER_READ_INST,                                                  
MFA-TR*       METER_IND,                                                        
MFA-TR*       IC_NO,                                                            
MFA-TR*       MTR_REF_NO,                                                       
MFA-TR*       CODE_REV_CLASS,                                                   
MFA-TR*       RLSE_REQUIRED,                                                    
MFA-TR*       RLSE_NO,                                                          
MFA-TR*       RLSE_MSG,                                                         
MFA-TR*       RLSE_ADDL_MSG,                                                    
MFA-TR*       RLSE_PHONE,                                                       
MFA-TR*       RLSE_ALT_PHONE,                                                   
MFA-TR*       RLSE_REV_DIST,                                                    
MFA-TR*       BUS_RULE_ID,                                                      
MFA-TR*       ACTION_TYPE_CD,                                                   
MFA-TR*       BUS_RULE_XREF_ID,                                                 
MFA-TR*       RLSE_ENABLED_FL,                                                  
MFA-TR*       OLD_WORK_TYPE_CD,                                                 
MFA-TR*       SO_SEQ_NO                                                         
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-4,                                                
MFA-TR*        :S-CODE-UTIL-TYPE-4,                                             
MFA-TR*        :S-METER-NO-4,                                                   
MFA-TR*        :S-RATE-PLAN-4,                                                  
MFA-TR*        :S-SUPPLIES,                                                     
MFA-TR*        :S-METER-LOC,                                                    
MFA-TR*        :S-METER-STATUS,                                                 
MFA-TR*        :S-METER-STATUS-REASON,                                          
MFA-TR*        :S-WORK-TYPE-CD-4,                                               
MFA-TR*        :S-METER-READ-INST,                                              
MFA-TR*        :S-METER-IND,                                                    
MFA-TR*        :S-IC-NO-4,                                                      
MFA-TR*        :S-MTR-REF-NO-4,                                                 
MFA-TR*        :S-CODE-REV-CLASS-4,                                             
MFA-TR*        :S-RLSE-REQUIRED,                                                
MFA-TR*        :S-RLSE-NO,                                                      
MFA-TR*        :S-RLSE-MSG,                                                     
MFA-TR*        :S-RLSE-ADDL-MSG,                                                
MFA-TR*        :S-RLSE-PHONE,                                                   
MFA-TR*        :S-RLSE-ALT-PHONE,                                               
MFA-TR*        :S-RLSE-REV-DIST,                                                
MFA-TR*        :S-BUS-RULE-ID-4,                                                
MFA-TR*        :S-ACTION-TYPE-CD-4,                                             
MFA-TR*        :S-BUS-RULE-XREF-ID-4,                                           
MFA-TR*        :S-RLSE-ENABLED-FL,                                              
MFA-TR*        :S-OLD-WORK-TYPE-CD-4,                                           
MFA-TR*        :S-SO-SEQ-NO-4                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R4'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8500-SEND-RESULT-5.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R5                            
             (                                                          
              RETURN_CODE,                                              
              SERV_ORDER_NO,                                            
              CODE_UTIL_TYPE,                                           
              WORK_TYPE_CD,                                             
              IC_NO,                                                    
              METER_NO,                                                 
              MTR_REF_NO                                                
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-5,                                        
               :S-SERV-ORDER-NO-5,                                      
               :S-CODE-UTIL-TYPE-5,                                     
               :S-WORK-TYPE-CD-5,                                       
               :S-IC-NO-5,                                              
               :S-METER-NO-5,                                           
               :S-MTR-REF-NO-5                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R5                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       WORK_TYPE_CD,                                                     
MFA-TR*       IC_NO,                                                            
MFA-TR*       METER_NO,                                                         
MFA-TR*       MTR_REF_NO                                                        
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-5,                                                
MFA-TR*        :S-SERV-ORDER-NO-5,                                              
MFA-TR*        :S-CODE-UTIL-TYPE-5,                                             
MFA-TR*        :S-WORK-TYPE-CD-5,                                               
MFA-TR*        :S-IC-NO-5,                                                      
MFA-TR*        :S-METER-NO-5,                                                   
MFA-TR*        :S-MTR-REF-NO-5                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R5'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8600-SEND-RESULT-6.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R6                            
             (                                                          
              RETURN_CODE,                                              
              CONTACT_TYPE,                                             
              NAME_TYPE,                                                
              MATRIX_NAME                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-6,                                        
               :S-CONTACT-TYPE,                                         
               :S-NAME-TYPE,                                            
               :S-MATRIX-NAME                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R6                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CONTACT_TYPE,                                                     
MFA-TR*       NAME_TYPE,                                                        
MFA-TR*       MATRIX_NAME                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-6,                                                
MFA-TR*        :S-CONTACT-TYPE,                                                 
MFA-TR*        :S-NAME-TYPE,                                                    
MFA-TR*        :S-MATRIX-NAME                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8600'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R6'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8700-SEND-RESULT-7.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R7                            
             (                                                          
              RETURN_CODE,                                              
              CALENDAR_DT,                                              
              GOOD_DAY_FL                                               
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-7,                                        
               :S-CALENDAR-DT,                                          
               :S-GOOD-DAY-FL                                           
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R7                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CALENDAR_DT,                                                      
MFA-TR*       GOOD_DAY_FL                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-7,                                                
MFA-TR*        :S-CALENDAR-DT,                                                  
MFA-TR*        :S-GOOD-DAY-FL                                                   
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8700'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R7'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8800-SEND-RESULT-8.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R8                            
             (                                                          
              RETURN_CODE,                                              
              RATE_PLAN_NO,                                             
              RATE_ITEM_CODE,                                           
              CODE_PLAN_STATUS,                                         
              CODE_STATUS_REASON,                                       
              MONTHLY_AMOUNT,                                           
              NO_UNITS,                                                 
              SUBDIVISION_FL,                                           
              IC_NO,                                                    
              RATE_PLAN_DESC,                                           
              SERVICE_TYPE,                                             
              DIST_NO,                                                  
              POLE_NO                                                   
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-8,                                        
               :S-RATE-PLAN-8,                                          
               :S-RATE-ITEM-CODE,                                       
               :S-CODE-PLAN-STATUS,                                     
               :S-CODE-STATUS-REASON,                                   
               :S-MONTHLY-AMOUNT,                                       
               :S-NO-UNITS,                                             
               :S-SUBDIVISION-FL,                                       
               :S-IC-NO-8,                                              
               :S-RATE-PLAN-DESC-8,                                     
               :S-SERVICE-TYPE,                                         
               :S-DIST-NO,                                              
               :S-POLE-NO                                               
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R8                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       RATE_PLAN_NO,                                                     
MFA-TR*       RATE_ITEM_CODE,                                                   
MFA-TR*       CODE_PLAN_STATUS,                                                 
MFA-TR*       CODE_STATUS_REASON,                                               
MFA-TR*       MONTHLY_AMOUNT,                                                   
MFA-TR*       NO_UNITS,                                                         
MFA-TR*       SUBDIVISION_FL,                                                   
MFA-TR*       IC_NO,                                                            
MFA-TR*       RATE_PLAN_DESC,                                                   
MFA-TR*       SERVICE_TYPE,                                                     
MFA-TR*       DIST_NO,                                                          
MFA-TR*       POLE_NO                                                           
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-8,                                                
MFA-TR*        :S-RATE-PLAN-8,                                                  
MFA-TR*        :S-RATE-ITEM-CODE,                                               
MFA-TR*        :S-CODE-PLAN-STATUS,                                             
MFA-TR*        :S-CODE-STATUS-REASON,                                           
MFA-TR*        :S-MONTHLY-AMOUNT,                                               
MFA-TR*        :S-NO-UNITS,                                                     
MFA-TR*        :S-SUBDIVISION-FL,                                               
MFA-TR*        :S-IC-NO-8,                                                      
MFA-TR*        :S-RATE-PLAN-DESC-8,                                             
MFA-TR*        :S-SERVICE-TYPE,                                                 
MFA-TR*        :S-DIST-NO,                                                      
MFA-TR*        :S-POLE-NO                                                       
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8800'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R8'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8810-SEND-RESULT-9.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R9                            
             (                                                          
              RETURN_CODE,                                              
              EQUIPMENT_NO,                                             
              APPLIANCE_CD,                                             
              CAUTION_TAG_IND,                                          
              CUT_IND,                                                  
              TAG_NO,                                                   
              CONDITION_CD,                                             
              LOCATION_CD,                                              
              APPL_COMMENTS,                                            
              CAUTION_TAG_DT,                                           
              SOURCE_SYSTEM_CD,                                         
              INSTALL_DT,                                               
              SERIAL_NO,                                                
              CAD_VERIFY_DT,                                            
              APPLIANCE_DESC,                                           
              SEASONAL_RT_FL,                                           
              CRAWL_FL,                                                 
              APPL_LONG_DESC,                                           
              PRIMARY_FUEL_CD,                                          
              AVERAGE_BTU,                                              
              LEAK_IND,                                                 
              LIGHT_IND,                                                
              REPAIR_IND,                                               
              CUTOFF_IND,                                               
              REPLACE_APP_FL                                            
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-9,                                        
               :S-EQUIPMENT-NO,                                         
               :S-APPLIANCE-CD,                                         
               :S-CAUTION-TAG-IND,                                      
               :S-CUT-IND,                                              
               :S-TAG-NO,                                               
               :S-CONDITION-CD,                                         
               :S-LOCATION-CD,                                          
               :S-APPL-COMMENTS,                                        
               :S-CAUTION-TAG-DT,                                       
               :S-SOURCE-SYSTEM-CD,                                     
               :S-INSTALL-DT,                                           
               :S-SERIAL-NO,                                            
               :S-CAD-VERIFY-DT,                                        
               :S-APPLIANCE-DESC,                                       
               :S-SEASONAL-RT-FL,                                       
               :S-CRAWL-FL,                                             
               :S-APPL-LONG-DESC,                                       
               :S-PRIMARY-FUEL-CD,                                      
               :S-AVERAGE-BTU,                                          
               :S-LEAK-IND,                                             
               :S-LIGHT-IND,                                            
               :S-REPAIR-IND,                                           
               :S-CUTOFF-IND,                                           
               :S-REPLACE-APP-FL                                        
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R9                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       EQUIPMENT_NO,                                                     
MFA-TR*       APPLIANCE_CD,                                                     
MFA-TR*       CAUTION_TAG_IND,                                                  
MFA-TR*       CUT_IND,                                                          
MFA-TR*       TAG_NO,                                                           
MFA-TR*       CONDITION_CD,                                                     
MFA-TR*       LOCATION_CD,                                                      
MFA-TR*       APPL_COMMENTS,                                                    
MFA-TR*       CAUTION_TAG_DT,                                                   
MFA-TR*       SOURCE_SYSTEM_CD,                                                 
MFA-TR*       INSTALL_DT,                                                       
MFA-TR*       SERIAL_NO,                                                        
MFA-TR*       CAD_VERIFY_DT,                                                    
MFA-TR*       APPLIANCE_DESC,                                                   
MFA-TR*       SEASONAL_RT_FL,                                                   
MFA-TR*       CRAWL_FL,                                                         
MFA-TR*       APPL_LONG_DESC,                                                   
MFA-TR*       PRIMARY_FUEL_CD,                                                  
MFA-TR*       AVERAGE_BTU,                                                      
MFA-TR*       LEAK_IND,                                                         
MFA-TR*       LIGHT_IND,                                                        
MFA-TR*       REPAIR_IND,                                                       
MFA-TR*       CUTOFF_IND,                                                       
MFA-TR*       REPLACE_APP_FL                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-9,                                                
MFA-TR*        :S-EQUIPMENT-NO,                                                 
MFA-TR*        :S-APPLIANCE-CD,                                                 
MFA-TR*        :S-CAUTION-TAG-IND,                                              
MFA-TR*        :S-CUT-IND,                                                      
MFA-TR*        :S-TAG-NO,                                                       
MFA-TR*        :S-CONDITION-CD,                                                 
MFA-TR*        :S-LOCATION-CD,                                                  
MFA-TR*        :S-APPL-COMMENTS,                                                
MFA-TR*        :S-CAUTION-TAG-DT,                                               
MFA-TR*        :S-SOURCE-SYSTEM-CD,                                             
MFA-TR*        :S-INSTALL-DT,                                                   
MFA-TR*        :S-SERIAL-NO,                                                    
MFA-TR*        :S-CAD-VERIFY-DT,                                                
MFA-TR*        :S-APPLIANCE-DESC,                                               
MFA-TR*        :S-SEASONAL-RT-FL,                                               
MFA-TR*        :S-CRAWL-FL,                                                     
MFA-TR*        :S-APPL-LONG-DESC,                                               
MFA-TR*        :S-PRIMARY-FUEL-CD,                                              
MFA-TR*        :S-AVERAGE-BTU,                                                  
MFA-TR*        :S-LEAK-IND,                                                     
MFA-TR*        :S-LIGHT-IND,                                                    
MFA-TR*        :S-REPAIR-IND,                                                   
MFA-TR*        :S-CUTOFF-IND,                                                   
MFA-TR*        :S-REPLACE-APP-FL                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8810'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R9'        TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8810-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8820-SEND-RESULT-10.                                             
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R10                           
             (                                                          
              RETURN_CODE,                                              
              CODE_UTIL_TYPE,                                           
              IC_NO,                                                    
              RATE_PLAN_NO,                                             
              CODE_REV_CLASS,                                           
              RATE_PLAN_DESC,                                           
              TOU_FL,                                                   
              FIXED_FACTOR_FL,                                          
              BILL_CONTRACT_FL,                                         
              INTERRUPT_FL                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-10,                                       
               :S-CODE-UTIL-TYPE-10,                                    
               :S-IC-NO-10,                                             
               :S-RATE-PLAN-10,                                         
               :S-CODE-REV-CLASS-10,                                    
               :S-RATE-PLAN-DESC-10,                                    
               :S-TOU-FL,                                               
               :S-FIXED-FACTOR-FL,                                      
               :S-BILL-CONTRACT-FL,                                     
               :S-INTERRUPT-FL                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R10                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CODE_UTIL_TYPE,                                                   
MFA-TR*       IC_NO,                                                            
MFA-TR*       RATE_PLAN_NO,                                                     
MFA-TR*       CODE_REV_CLASS,                                                   
MFA-TR*       RATE_PLAN_DESC,                                                   
MFA-TR*       TOU_FL,                                                           
MFA-TR*       FIXED_FACTOR_FL,                                                  
MFA-TR*       BILL_CONTRACT_FL,                                                 
MFA-TR*       INTERRUPT_FL                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-10,                                               
MFA-TR*        :S-CODE-UTIL-TYPE-10,                                            
MFA-TR*        :S-IC-NO-10,                                                     
MFA-TR*        :S-RATE-PLAN-10,                                                 
MFA-TR*        :S-CODE-REV-CLASS-10,                                            
MFA-TR*        :S-RATE-PLAN-DESC-10,                                            
MFA-TR*        :S-TOU-FL,                                                       
MFA-TR*        :S-FIXED-FACTOR-FL,                                              
MFA-TR*        :S-BILL-CONTRACT-FL,                                             
MFA-TR*        :S-INTERRUPT-FL                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8820'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R10'       TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8820-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8830-SEND-RESULT-11.                                             
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04476_R11                           
             (                                                          
              RETURN_CODE,                                              
              ACCOUNT_NO,                                               
              CODE_ACCT_STAT,                                           
              ADDRESS_LINE                                              
              )                                                         
              VALUES                                                    
              (                                                         
               :S-RETURN-CODE-11,                                       
               :S-ACCOUNT-NO-11,                                        
               :S-CODE-ACCT-STAT-11,                                    
               :S-ADDRESS-LINE                                          
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R11                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       CODE_ACCT_STAT,                                                   
MFA-TR*       ADDRESS_LINE                                                      
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-11,                                               
MFA-TR*        :S-ACCOUNT-NO-11,                                                
MFA-TR*        :S-CODE-ACCT-STAT-11,                                            
MFA-TR*        :S-ADDRESS-LINE                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8830'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04476_R11'       TO TABLE-1                      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
                                                                        
           ADD 1 TO CTR-ROWS.                                           
                                                                        
       8830-EXIT.                                                       
           EXIT.                                                        
                                                                        
MAINTN 8850-SEND-RESULT-13.                                             
MAINTN                                                                  
MAINTN     EXEC SQL                                                     
MAINTN       INSERT INTO #CSR04476_R13                           
MAINTN       (                                                          
MAINTN        RETURN_CODE,                                              
MAINTN        SERV_ORDER_NO,                                            
MAINTN        REMARK_TYPE_CD,                                           
MAINTN        REMARK_TX                                                 
MAINTN        )                                                         
MAINTN        VALUES                                                    
MAINTN        (                                                         
MAINTN         :S-RETURN-CODE-13,                                       
MAINTN         :S-SERV-ORDER-NO-13,                                     
MAINTN         :S-REMARK-TYPE-CD-13,                                    
MAINTN         :S-REMARK-TX-13                                          
MAINTN        )                                                         
MAINTN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R13                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       SERV_ORDER_NO,                                                    
MFA-TR*       REMARK_TYPE_CD,                                                   
MFA-TR*       REMARK_TX                                                         
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-13,                                               
MFA-TR*        :S-SERV-ORDER-NO-13,                                             
MFA-TR*        :S-REMARK-TYPE-CD-13,                                            
MFA-TR*        :S-REMARK-TX-13                                                  
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MAINTN     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
MAINTN                                                                  
MAINTN     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
MAINTN        NEXT SENTENCE                                             
MAINTN     ELSE                                                         
MAINTN        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
MAINTN        MOVE SQLCODE              TO ABEND-SQLCODE                
MAINTN        MOVE SQLSTATE             TO ABEND-SQLSTATE               
MAINTN        MOVE '8850'               TO ACTIVE-PARAGRAPH             
MAINTN        MOVE 'INSERT'             TO ABEND-FUNCTION               
MAINTN        MOVE 'CSR04476_R13'       TO TABLE-1                      
MAINTN        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
MAINTN                                                                  
MAINTN     ADD 1 TO CTR-ROWS.                                           
MAINTN                                                                  
MAINTN 8850-EXIT.                                                       
MAINTN     EXIT.                                                        
                                                                        
DT9511 8880-SEND-RESULT-16.                                             
DT9511                                                                  
DT9511     EXEC SQL                                                     
DT9511       INSERT INTO #CSR04476_R16                           
DT9511       (                                                          
DT9511        RETURN_CODE,                                              
DT9511        CONTRACT_ID                                               
DT9511        )                                                         
DT9511        VALUES                                                    
DT9511        (                                                         
DT9511         :S-RETURN-CODE-16,                                       
DT9511         :S-CONTRACT-ID-16                                        
DT9511        )                                                         
DT9511     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04476_R16                                   
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE,                                                      
MFA-TR*       CONTRACT_ID                                                       
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*        :S-RETURN-CODE-16,                                               
MFA-TR*        :S-CONTRACT-ID-16                                                
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

DT9511     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
DT9511                                                                  
DT9511     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
DT9511        NEXT SENTENCE                                             
DT9511     ELSE                                                         
DT9511        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
DT9511        MOVE SQLCODE              TO ABEND-SQLCODE                
DT9511        MOVE SQLSTATE             TO ABEND-SQLSTATE               
DT9511        MOVE '8880'               TO ACTIVE-PARAGRAPH             
DT9511        MOVE 'INSERT'             TO ABEND-FUNCTION               
DT9511        MOVE 'CSR04476_R16'       TO TABLE-1                      
DT9511        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT
           END-IF.             
DT9511                                                                  
DT9511     ADD 1 TO CTR-ROWS.                                           
DT9511                                                                  
DT9511 8880-EXIT.                                                       
DT9511     EXIT.                                                        
                                                                        
       8001-DELETE-GTT1-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8001'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8003-DELETE-GTT3-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8003'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R3'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8003-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8004-DELETE-GTT4-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8004'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R4'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8004-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8005-DELETE-GTT5-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8005'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R5'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8005-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8006-DELETE-GTT6-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8006'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R6'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8006-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8007-DELETE-GTT7-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R7                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R7                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8007'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R7'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8007-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8008-DELETE-GTT8-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R8                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R8                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8008'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R8'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8008-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8009-DELETE-GTT9-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R9                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R9                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8009'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R9'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8009-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8010-DELETE-GTT10-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R10                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R10                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8010'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R10'       TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8011-DELETE-GTT11-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R11                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R11                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8011'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R11'       TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8011-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8013-DELETE-GTT13-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R13                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R13                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8013'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R13'       TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8013-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8016-DELETE-GTT16-ROWS.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04476_R16                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04476_R16                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8016'               TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR04476_R16'       TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
       8016-EXIT.                                                       
           EXIT.                                                        
                                                                        
P0795A*8012-DELETE-GTT12-ROWS.                                                  
P0795A*                                                                         
P0795A**   EXEC SQL                                                             
P0795A*        DELETE FROM SESSION.CSR04476_R12                                 
P0795A*    END-EXEC.                                                            
P0795A*                                                                         
P0795A*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
P0795A*                                                                         
P0795A*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
P0795A*        NEXT SENTENCE                                                    
P0795A*    ELSE                                                                 
P0795A*        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                       
P0795A*        MOVE SQLCODE              TO ABEND-SQLCODE                       
P0795A*        MOVE SQLSTATE             TO ABEND-SQLSTATE                      
P0795A*        MOVE '8012'               TO ACTIVE-PARAGRAPH                    
P0795A*        MOVE 'DELETE'             TO ABEND-FUNCTION                      
P0795A*        MOVE SPACES               TO ABEND-SQL-PREDICATES                
P0795A*                                     ABEND-TABLES                        
P0795A**       MOVE 'CSR04476_R12'       TO TABLE-1                             
P0795A*        MOVE SPACES               TO TABLE-ELEMENT-1                     
P0795A*        MOVE SPACES               TO HOSTVAR-ELEMENT-1                   
P0795A*        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT.                       
P0795A*                                                                         
P0795A*8012-EXIT.                                                               
P0795A*    EXIT.                                                                
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           IF WS-GTT01-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-1                             
               EXEC SQL                                                 
                   OPEN N1                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT03-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-3                             
               EXEC SQL                                                 
                   OPEN N3                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT04-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-4                             
               EXEC SQL                                                 
                   OPEN N4                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT05-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-5                             
               EXEC SQL                                                 
                   OPEN N5                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT06-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C6                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-6                             
               EXEC SQL                                                 
                   OPEN N6                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT07-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C7                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-7                             
               EXEC SQL                                                 
                   OPEN N7                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT08-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C8                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C8 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-8                             
               EXEC SQL                                                 
                   OPEN N8                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N8 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT09-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C9                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C9 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-9                             
               EXEC SQL                                                 
                   OPEN N9                                              
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N9 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT10-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C10                                             
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C10 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-10                            
               EXEC SQL                                                 
                   OPEN N10                                             
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N10 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
           IF WS-GTT11-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C11                                             
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C11 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-11                            
               EXEC SQL                                                 
                   OPEN N11                                             
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N11 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
MAINTN     EXEC SQL                                                     
MAINTN          OPEN C12                                                
MAINTN     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C12 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           IF WS-GTT13-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C13                                             
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C13 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-13                            
               EXEC SQL                                                 
                   OPEN N13                                             
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N13 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
MAINTN     EXEC SQL                                                     
MAINTN          OPEN C14                                                
MAINTN     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C14 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
MAINTN     EXEC SQL                                                     
MAINTN          OPEN C15                                                
MAINTN     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C15 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
DT9511     IF WS-GTT16-DECLARED = 'Y'                                   
               EXEC SQL                                                 
                   OPEN C16                                             
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C16 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                 
           ELSE                                                         
               MOVE +100 TO S-RETURN-CODE-16                            
               EXEC SQL                                                 
                   OPEN N16                                             
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE N16 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF

           END-IF.                                                
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE-1                
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
           IF WS-GTT01-DECLARED = 'N'                                   
               PERFORM 0101-DECLARE-GTT01 THRU 0101-EXIT
           END-IF.               
           PERFORM 8100-SEND-RESULT-1 THRU 8100-EXIT.                   
                                                                        
      *    EXEC SQL                                                             
      *        ROLLBACK                                                         
      *    END-EXEC.                                                            
      *    IF SQLCODE = 0                                                       
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'ROLLBACK'         TO ABEND-FUNCTION.                       
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.              
           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.              
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9900-SQL-ERROR-ROUTINE.                                          

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + ',' + 
           LTRIM(RTRIM(:TABLE-3)) + ',' + LTRIM(RTRIM(:TABLE-4)) + 
           ',' + 'ERRMSG-' + LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
                                                                        
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           
           
MSQ016        GOBACK.                                                    
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT
           END-IF.                 
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
