       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04474.                                      
COB303 DATE-WRITTEN.     JUL 18, 2011.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  07/18/11  SM77699    PROCEDURE ORIGINALLY CODED.              *00280088
A03967*  07/18/12  VP43661    MODIFIED ORDER BY CALUSE.                *00280088
a04527*  06/07/13  MC95456    REMOVED UNUSED COPY BOOK CWS00056        *        
PRJ914*  09/29/15  SS95855    Openway AMI Metering                     *        
      *                                                                *00290000
      ******************************************************************00580000
      *                                                                *00590000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00600000
      *                                                                *00610000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00620000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00630000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00640000
      *  7000 - 7999  INPUT MODULES                                    *00680000
      *  8000 - 8999  OUTPUT MODULES                                   *00690000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00700000
      *                                                                *00710000
      ******************************************************************00720000
 .                                                                      
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04474'.
MSQ017     COPY MFASQLM.
 .                                                                      
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04474 STARTS HERE'.                  
                                                                        
      ******************************************************************00810000
      *    DB2 INCLUDES                                                *00820000
      ******************************************************************00830000
                                                                        
           EXEC SQL                                                     00850000
              INCLUDE SQLCA                                             00860000
           END-EXEC.                                                    00870000
                                                                        
           EXEC SQL                                                     00930016
               INCLUDE TBACCT                                           00940016
           END-EXEC.                                                    00950016
                                                                        
           EXEC SQL                                                     00961016
               INCLUDE TBPREM                                           00962016
           END-EXEC.                                                    00963016
                                                                        
           EXEC SQL                                                     00963216
               INCLUDE TBZIPCD                                          00963316
           END-EXEC.                                                    00963416
                                                                        
           EXEC SQL                                                     00964016
               INCLUDE TBADRFMT                                         00965016
           END-EXEC.                                                    00966016
                                                                        
           EXEC SQL                                                     00966288
               INCLUDE TBADRFRE                                         00966388
           END-EXEC.                                                    00966488
                                                                        
           EXEC SQL                                                     00968062
               INCLUDE TBBLLDET                                         00969062
           END-EXEC.                                                    00969162
                                                                        
           EXEC SQL                                                     00969394
               INCLUDE TBBLCLDT                                         00969494
           END-EXEC.                                                    00969594
                                                                        
           EXEC SQL                                                     00969794
               INCLUDE TBBLLHDR                                         00969894
           END-EXEC.                                                    00969994
                                                                        
           EXEC SQL                                                     00970163
               INCLUDE TBCNSMP                                          00970263
           END-EXEC.                                                    00970363
                                                                        
           EXEC SQL                                                     00970563
               INCLUDE TBMTRENV                                         00970663
           END-EXEC.                                                    00970763
                                                                        
      *                                                                 00971014
      ******************************************************************00980014
      *    COBOL WORKING STORAGE COPY BOOKS                            *00990014
      ******************************************************************01000014
      *                                                                 01010061
           EXEC SQL                                                     01050014
              INCLUDE CWSX0010                                          01060014
           END-EXEC.                                                    01070014
           COPY CWS00303.                                               01110014
      *                                                                 01190014
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE SPACES.                   
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
      *                                                                 01261082
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.               
             88 SEND-DONE-ERROR                VALUE 'N'.               
             88 SEND-DONE-OK                   VALUE 'Y'.               
          05 WS-EOF-CURSOR           PIC X(01) VALUE 'N'.               
             88 NO-MORE-DATA                   VALUE 'Y'.               
          05 WS-CURSOR-SW            PIC X(01) VALUE 'N'.               
             88 NO-MORE-ROWS                   VALUE 'Y'.               
      *                                                                 01270014
       01  WORK-FIELDS.                                                 
      *                                                                 01272081
           05 WS-SERV-ADDR             PIC X(100).                      
           05 WS-MAIL-ADDR             PIC X(100).                      
           05 WS-SQLSTATE              PIC X(5).                        
           05 CTR-ROWS                 PIC S9(09) VALUE 0    COMP.      
           05 PROGRAM-NAME             PIC X(08)  VALUE 'CSR04474'.     
           05 WS-HEADER-REC-ID         PIC X(01) VALUE 'H'.             
           05 WS-DETAIL-REC-ID         PIC X(01) VALUE 'D'.             
           05 WS-GTT-IND-R1            PIC X(01) VALUE 'N'.             
           05 WS-GTT-IND-R2            PIC X(01) VALUE 'N'.             
           05 WS-BILL-DATE.                                             
              10  WS-CCYY              PIC X(04).                       
              10  FILLER               PIC X(01).                       
              10  WS-MM                PIC X(02).                       
              10  FILLER               PIC X(01).                       
              10  WS-DD                PIC X(02).                       
C37544     05 WS-BILL-DATE-CH   REDEFINES   WS-BILL-DATE                
C37544                                 PIC X(10).                       
           05 WS-BILL-DATE-MMDDCCYY.                                    
              10  WS-MM                PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-DD                PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-CCYY              PIC X(04) VALUE SPACES.          
           05 WS-DATE-READ.                                             
              10  WS-CCYY              PIC X(04).                       
              10  FILLER               PIC X(01).                       
              10  WS-MM                PIC X(02).                       
              10  FILLER               PIC X(01).                       
              10  WS-DD                PIC X(02).                       
           05 WS-DATE-READ-MMDDCCYY.                                    
              10  WS-MM                PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-DD                PIC X(02) VALUE SPACES.          
              10  FILLER               PIC X(01) VALUE '/'.             
              10  WS-CCYY              PIC X(04) VALUE SPACES.          
           05 WS-METER-NO.                                              
              10  WS-COMPANY-NO        PIC X(02) VALUE '01'.            
              10  WS-UTILITY           PIC X(01) VALUE 'E'.             
              10  WS-MTR-NO            PIC X(09) VALUE SPACES.          
      *                                                                 01282181
                                                                        
       01  GTT-RETURN-FIELDS.                                           
          05 GTT-RETURN-FIELDS-1.                                       
            10 S-RETURN-CODE          PIC S9(9)  VALUE 0 COMP.          
            10 S-RECORD-ID            PIC X(01)  VALUE SPACES.          
            10 S-ACCOUNT-NO           PIC X(13)  VALUE SPACES.          
            10 S-PREMISE-NO           PIC S9(10) VALUE 0 COMP.          
            10 S-CUSTOMER-NO          PIC S9(10) VALUE 0 COMP.          
            10 S-SERV-ADDR            PIC X(100) VALUE SPACES.          
            10 S-SERV-TOWN            PIC X(30)  VALUE SPACES.          
            10 S-SERV-STATE           PIC X(02)  VALUE SPACES.          
            10 S-SERV-ZIP             PIC X(10)  VALUE SPACES.          
            10 S-MAIL-ADDR            PIC X(100) VALUE SPACES.          
            10 S-MAIL-TOWN            PIC X(30)  VALUE SPACES.          
            10 S-MAIL-ZIP             PIC X(10)  VALUE SPACES.          
          05 GTT-RETURN-FIELDS-2.                                       
            10 S-RETURN-CODE-2        PIC S9(9)  VALUE 0 COMP.          
            10 S-RECORD-ID-2          PIC X(01)  VALUE SPACES.          
            10 S-ACCOUNT-NO-2         PIC X(13)  VALUE SPACES.          
            10 S-BILL-NO              PIC S9(03) VALUE 0 COMP.          
            10 S-BILL-DATE            PIC X(26)  VALUE SPACES.          
            10 S-METER-NO             PIC X(12)  VALUE SPACES.          
            10 S-CODE-USAGE-TYPE      PIC X(01)  VALUE SPACES.          
            10 S-NO-DAYS              PIC S9(04) VALUE 0 COMP.          
            10 S-NO-UNITS             PIC S9(09) VALUE 0 COMP.          
            10 S-NO-DEMAND-UNITS      PIC S9(09) VALUE 0 COMP.          
            10 S-BILL-UNITS           PIC S9(09) VALUE 0 COMP.          
            10 S-READ-DATE            PIC X(10)  VALUE SPACES.          
            10 S-REVENUE-MONTH        PIC S9(06) VALUE 0 COMP.          
            10 S-RATE-PLAN-NO         PIC X(03)  VALUE SPACES.          
            10 S-MTR-READ-SOURCE-CD   PIC X(01)  VALUE SPACES.          
            10 S-AMT-BILL-ITEM        PIC S9(11)V99                     
                                                 VALUE 0 COMP-3.        
            10 S-BILLED-COMP-AMT      PIC S9(11)V99                     
                                                 VALUE 0 COMP-3.        
            10 S-AMT-STATE-TAX        PIC S9(09)V99                     
                                                 VALUE 0 COMP-3.        
            10 S-AMT-OTHER-TAX        PIC S9(09)V99                     
                                                 VALUE 0 COMP-3.        
            10 S-AMT-CITY-TAX         PIC S9(09)V99                     
                                                 VALUE 0 COMP-3.        
      *                                                                 01533094
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
HPCCDM*   EJECT                                                         01680015
      ******************************************************************01690015
      *                    C U R S O R  D E C L A R A T I O N S        *01700015
      ******************************************************************01710015
                                                                        
      ******************************************************************01730015
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING             *01740088
      **  CUSTOMER AND PREMISE DETAILS.                                *01750088
      ******************************************************************01770015
           EXEC SQL                                                     
               DECLARE AT-CURSOR CURSOR FOR                             
                   SELECT AT.ACCOUNT_NO,                                
                          AT.CUSTOMER_NO,                               
                          AT.PREMISE_NO,                                
                          (RTRIM(DY.ADDR_PREFIX_1) + ' ' + RTRIM(
           DY.HOUSE_NO) + ' ' + RTRIM(DY.ADDR_PREFIX_2) + ' ' + RTRIM(
           DY.STREET_NAME) + ' ' + RTRIM(DY.STREET_SUFFIX) + ' ' + 
           RTRIM(DY.ADDR_SUFFIX) + ' ' + RTRIM(DY.STREET_LOCATION_2
           )) AS SERV_ADDRESS, 
                          A4.TOWN,                                      
                          A4.STATE,                                     
                          A4.ZIP_CODE                                   
                   FROM CSS_ACCOUNT AT,                                 
                        CSS_PREMISE PR,                                 
                        CSS_ADDR_FORMATTED DY,                          
                        CSS_ZIP_CODE A4                                 
                   WHERE AT.PREMISE_NO = PR.PREMISE_NO                  
                         AND DY.ADDRESS_ID = PR.ADDRESS_ID              
                         AND A4.ZIP_CODE = DY.ZIP_CODE                  
                         AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN      
                         AND AT.ACCOUNT_NO = :AT-ACCOUNT-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     01780015
MFA-TR*        DECLARE AT-CURSOR CURSOR FOR                             01790016
MFA-TR*            SELECT AT.ACCOUNT_NO,                                01800016
MFA-TR*                   AT.CUSTOMER_NO,                               01801016
MFA-TR*                   AT.PREMISE_NO,                                01804016
MFA-TR*                   (RTRIM(DY.ADDR_PREFIX_1) ||' ' ||             01805016
MFA-TR*                   RTRIM(DY.HOUSE_NO) || ' ' ||                  01806016
MFA-TR*                   RTRIM(DY.ADDR_PREFIX_2) ||' ' ||              01807016
MFA-TR*                   RTRIM(DY.STREET_NAME) ||' ' ||                01808016
MFA-TR*                   RTRIM(DY.STREET_SUFFIX) ||' ' ||              01809016
MFA-TR*                   RTRIM(DY.ADDR_SUFFIX) ||' ' ||                01809116
MFA-TR*                   RTRIM(DY.STREET_LOCATION_2)) AS SERV_ADDRESS, 01809216
MFA-TR*                   A4.TOWN,                                      01809316
MFA-TR*                   A4.STATE,                                     01809416
MFA-TR*                   A4.ZIP_CODE                                   01809516
MFA-TR*            FROM CSS_ACCOUNT AT,                                 01860016
MFA-TR*                 CSS_PREMISE PR,                                 01861016
MFA-TR*                 CSS_ADDR_FORMATTED DY,                          01862016
MFA-TR*                 CSS_ZIP_CODE A4                                 01863016
MFA-TR*            WHERE AT.PREMISE_NO = PR.PREMISE_NO                  01870016
MFA-TR*                  AND DY.ADDRESS_ID = PR.ADDRESS_ID              01871016
MFA-TR*                  AND A4.ZIP_CODE = DY.ZIP_CODE                  01872016
MFA-TR*                  AND A4.ZIP_CODE_TOKEN = DY.ZIP_CODE_TOKEN      01873016
MFA-TR*                  AND AT.ACCOUNT_NO = :AT-ACCOUNT-NO             01874016
MFA-TR*    END-EXEC.                                                    01900015
HPCCDM*EJECT                                                            01910015
      ******************************************************************01910188
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING             *01910288
      **  CUSTOMER MAILING ADDRESS DETAILS.                            *01910388
      ******************************************************************01910488
           EXEC SQL                                                     
               DECLARE DY-CURSOR CURSOR FOR                             
                   SELECT AT1.ACCOUNT_NO,                               
                          AT1.ADDRESS_ID,                               
                          (RTRIM(DY1.ADDR_STREET) + ' ' + RTRIM(
           DY1.ADDRESS_OVERFLOW) )AS MAIL_ADDR,    
                          RTRIM(DY1.ADDR_CITY_STATE) AS MAIL_TOWN,      
                          CIS.SUBSTR3(DY1.ADDR_ZIP_CODE,1,5) AS MAIL_ZIP     
                   FROM CSS_ACCOUNT AT1,                                
                        CSS_ADDR_FREEFORM DY1                           
                   WHERE AT1.ADDRESS_ID = DY1.ADDRESS_ID                
                         AND AT1.ACCOUNT_NO = :AT-ACCOUNT-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     01910588
MFA-TR*        DECLARE DY-CURSOR CURSOR FOR                             01910688
MFA-TR*            SELECT AT1.ACCOUNT_NO,                               01910788
MFA-TR*                   AT1.ADDRESS_ID,                               01910888
MFA-TR*                   (RTRIM(DY1.ADDR_STREET)  || ' ' ||            01910988
MFA-TR*                   RTRIM(DY1.ADDRESS_OVERFLOW) )AS MAIL_ADDR,    01911088
MFA-TR*                   RTRIM(DY1.ADDR_CITY_STATE) AS MAIL_TOWN,      01911188
MFA-TR*                   SUBSTR(DY1.ADDR_ZIP_CODE,1,5) AS MAIL_ZIP     01911288
MFA-TR*            FROM CSS_ACCOUNT AT1,                                01912088
MFA-TR*                 CSS_ADDR_FREEFORM DY1                           01912288
MFA-TR*            WHERE AT1.ADDRESS_ID = DY1.ADDRESS_ID                01912488
MFA-TR*                  AND AT1.ACCOUNT_NO = :AT-ACCOUNT-NO            01912889
MFA-TR*    END-EXEC.                                                    01912988
HPCCDM*EJECT                                                            01913088
      ******************************************************************01913163
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING            **01913288
      **  BILLING DETAILS FOR 24 MONTH                                **01913388
      ******************************************************************01913488
           EXEC SQL                                                     
               DECLARE BG-CURSOR CURSOR FOR                             
                 SELECT CX2.ACCOUNT_NO                                  
                ,CX2.BILL_NO                                            
                ,CX2.METER_NO                                           
                ,CX2.CODE_USAGE_TYPE                                    
                ,CX2.NO_DAYS                                            
                ,COALESCE(CX2.NO_UNITS,0)AS NO_UNITS                      
                ,COALESCE(CX2.NO_DEMAND_UNITS,0) AS NO_DEMAND_UNITS       
                ,CX2.DATE_READ AS READ_DATE                             
                ,BI.DATE_BILLED                                         
                ,CASE                                                   
                  WHEN BG2.REV_MTH_ORIG_BILL > 0                        
                  THEN BG2.REV_MTH_ORIG_BILL                            
                  ELSE BG2.REVENUE_MONTH                                
                 END AS REVENUE_MONTH                                   
                ,BG2.RATE_PLAN_NO                                       
                ,BG2.AMT_BILL_ITEM                                      
                ,BG2.AMT_STATE_TAX                                      
                ,BG2.AMT_OTHER_TAX                                      
                ,BG2.AMT_CITY_TAX                                       
                ,BZ.BILL_UNITS                                          
                ,BZ.BILLED_COMP_AM                                      
                ,MN2.MTR_READ_SOURCE_CD                                 
          FROM CSS_CNSMPTN_HIST CX2 WITH(READUNCOMMITTED)                       
              ,CSS_BILLING_DET BG2 WITH(READUNCOMMITTED)                        
              ,CSS_MTRD_ENVRNMT MN2 WITH(READUNCOMMITTED)                       
              ,CSS_BILLING_HDR BI WITH(READUNCOMMITTED)                         
              ,CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED)                       
          WHERE BI.BILL_NO            = BG2.BILL_NO                     
            AND BI.ACCOUNT_NO         = BG2.ACCOUNT_NO                  
            AND BZ.ACCOUNT_NO         = BG2.ACCOUNT_NO                  
            AND BZ.IC_NO              = BG2.IC_NO                       
            AND BZ.BILL_NO            = BG2.BILL_NO                     
            AND BZ.BILL_ITEM_TIMESTMP = BG2.BILL_ITEM_TIMESTMP          
            AND CX2.ACCOUNT_NO        = BG2.ACCOUNT_NO                  
            AND CX2.CODE_UTIL_TYPE    = BG2.CODE_UTIL_TYPE              
            AND CX2.IC_NO             = BG2.IC_NO                       
            AND CX2.BILL_NO           = BG2.BILL_NO                     
            AND CX2.BILL_ITEM_TIMESTMP = BG2.BILL_ITEM_TIMESTMP         
            AND CX2.CODE_USAGE_TYPE   = BZ.CONSUMPT_TYPE_CD             
            AND CX2.MTR_REF_NO        = MN2.MTR_REF_NO                  
            AND MN2.ACCOUNT_NO        = BG2.ACCOUNT_NO                  
            AND MN2.IC_NO             = BG2.IC_NO                       
            AND MN2.CODE_UTIL_TYPE    = BG2.CODE_UTIL_TYPE              
PRJ914      AND MN2.MTR_READ_SOURCE_CD IN ('R','M','X','P')             
            AND CX2.ACCOUNT_NO         = :CX-ACCOUNT-NO                 
            AND CX2.CODE_UTIL_TYPE      = 'E'                           
            AND BG2.CODE_BILL_CALC     = 'A'                            
            AND BG2.CODE_BILL_ITM_TYPE = 'C'                            
            AND BG2.CODE_BILL_ITM_IND  = 'A'                            
            AND BG2.REVENUE_MONTH     <= (SELECT MAX(ZA.REVENUE_MONTH)  
             FROM CSS_BILLING_DET ZA WITH(READUNCOMMITTED)                      
             WHERE ZA.ACCOUNT_NO         = BG2.ACCOUNT_NO               
               AND ZA.CODE_UTIL_TYPE     = BG2.CODE_UTIL_TYPE           
               AND ZA.IC_NO              = BG2.IC_NO                    
               AND ZA.REVENUE_MONTH      > 0                            
               AND ZA.CODE_BILL_CALC     = 'A'                          
               AND ZA.CODE_BILL_ITM_TYPE = 'C'                          
               AND ZA.CODE_BILL_ITM_IND  = 'A')                         
        AND BG2.REVENUE_MONTH > (SELECT CIS.CHAR2DECIMAL((SUBSTRING(
           CAST(DATEADD( MONTH, -24, 
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           CIS.SUBSTR3$(CIS.DECIMAL2CHAR(MAX(ZB.REVENUE_MONTH)), 2, 4
           ) + '-' + CIS.SUBSTR3$(CIS.DECIMAL2CHAR(MAX(
           ZB.REVENUE_MONTH)), 6, 2) + '-' + '01' E) T) ) AS CHAR(10))
           , 1, 4) + SUBSTRING(CAST(DATEADD( MONTH, -24, 
              (SELECT IIF(TRY_CONVERT(DATE, E) IS NULL OR 
              (PATINDEX('%.%', E) <> 0) OR (LEN(E) <> 10), 
              CIS.CHAR2DATE(E), CONVERT(DATE, E)) FROM (SELECT 
           CIS.SUBSTR3$(CIS.DECIMAL2CHAR                  
                (MAX(ZB.REVENUE_MONTH)), 2, 4) + '-' + CIS.SUBSTR3$(
           CIS.DECIMAL2CHAR(MAX(ZB.REVENUE_MONTH)), 6, 2) + '-' + '01'
               E) T) ) AS CHAR(10)), 6, 2)))                          
                FROM CSS_BILLING_DET ZB WITH(READUNCOMMITTED)                   
                WHERE ZB.ACCOUNT_NO         = BG2.ACCOUNT_NO            
                AND ZB.CODE_UTIL_TYPE     = BG2.CODE_UTIL_TYPE          
                AND ZB.IC_NO              = BG2.IC_NO                   
                AND ZB.REVENUE_MONTH      > 0                           
                AND ZB.CODE_BILL_CALC     = 'A'                         
                AND ZB.CODE_BILL_ITM_TYPE = 'C'                         
                AND ZB.CODE_BILL_ITM_IND  = 'A')                        
                AND BG2.REVENUE_MONTH >= 201106                         
                ORDER BY DATE_BILLED DESC,                              
                         BILL_NO DESC,                                  
                         METER_NO DESC,                                 
A03967                   DATE_READ DESC                                 
A37342         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     01914071
MFA-TR*        DECLARE BG-CURSOR CURSOR FOR                             01915071
MFA-TR*          SELECT CX2.ACCOUNT_NO                                  01916071
MFA-TR*         ,CX2.BILL_NO                                            01917063
MFA-TR*         ,CX2.METER_NO                                           01919063
MFA-TR*         ,CX2.CODE_USAGE_TYPE                                    01919194
MFA-TR*         ,CX2.NO_DAYS                                            01919263
MFA-TR*         ,IFNULL(CX2.NO_UNITS,0)AS NO_UNITS                      01919394
MFA-TR*         ,IFNULL(CX2.NO_DEMAND_UNITS,0) AS NO_DEMAND_UNITS       01919494
MFA-TR*         ,CX2.DATE_READ AS READ_DATE                             01919594
MFA-TR*         ,BI.DATE_BILLED                                         01919694
MFA-TR*         ,CASE                                                   01919794
MFA-TR*           WHEN BG2.REV_MTH_ORIG_BILL > 0                        01919894
MFA-TR*           THEN BG2.REV_MTH_ORIG_BILL                            01919994
MFA-TR*           ELSE BG2.REVENUE_MONTH                                01920094
MFA-TR*          END AS REVENUE_MONTH                                   01920194
MFA-TR*         ,BG2.RATE_PLAN_NO                                       01920294
MFA-TR*         ,BG2.AMT_BILL_ITEM                                      01920394
MFA-TR*         ,BG2.AMT_STATE_TAX                                      01920494
MFA-TR*         ,BG2.AMT_OTHER_TAX                                      01920594
MFA-TR*         ,BG2.AMT_CITY_TAX                                       01920694
MFA-TR*         ,BZ.BILL_UNITS                                          01920794
MFA-TR*         ,BZ.BILLED_COMP_AM                                      01920894
MFA-TR*         ,MN2.MTR_READ_SOURCE_CD                                         
MFA-TR*   FROM CSS_CNSMPTN_HIST CX2                                     01920994
MFA-TR*       ,CSS_BILLING_DET BG2                                      01921094
MFA-TR*       ,CSS_MTRD_ENVRNMT MN2                                     01921194
MFA-TR*       ,CSS_BILLING_HDR BI                                       01921294
MFA-TR*       ,CSS_BILL_CALC_DET BZ                                     01921394
MFA-TR*   WHERE BI.BILL_NO            = BG2.BILL_NO                     01921494
MFA-TR*     AND BI.ACCOUNT_NO         = BG2.ACCOUNT_NO                  01921594
MFA-TR*     AND BZ.ACCOUNT_NO         = BG2.ACCOUNT_NO                  01921694
MFA-TR*     AND BZ.IC_NO              = BG2.IC_NO                       01921794
MFA-TR*     AND BZ.BILL_NO            = BG2.BILL_NO                     01921894
MFA-TR*     AND BZ.BILL_ITEM_TIMESTMP = BG2.BILL_ITEM_TIMESTMP          01921994
MFA-TR*     AND CX2.ACCOUNT_NO        = BG2.ACCOUNT_NO                  01922094
MFA-TR*     AND CX2.CODE_UTIL_TYPE    = BG2.CODE_UTIL_TYPE              01922194
MFA-TR*     AND CX2.IC_NO             = BG2.IC_NO                       01922294
MFA-TR*     AND CX2.BILL_NO           = BG2.BILL_NO                     01922394
MFA-TR*     AND CX2.BILL_ITEM_TIMESTMP = BG2.BILL_ITEM_TIMESTMP         01922494
MFA-TR*     AND CX2.CODE_USAGE_TYPE   = BZ.CONSUMPT_TYPE_CD             01922594
MFA-TR*     AND CX2.MTR_REF_NO        = MN2.MTR_REF_NO                  01922694
MFA-TR*     AND MN2.ACCOUNT_NO        = BG2.ACCOUNT_NO                  01922794
MFA-TR*     AND MN2.IC_NO             = BG2.IC_NO                       01922894
MFA-TR*     AND MN2.CODE_UTIL_TYPE    = BG2.CODE_UTIL_TYPE              01922994
MFA-TR*     AND MN2.MTR_READ_SOURCE_CD IN ('R','M','X','P')             01923094
MFA-TR*     AND CX2.ACCOUNT_NO         = :CX-ACCOUNT-NO                 01923294
MFA-TR*     AND CX2.CODE_UTIL_TYPE      = 'E'                           01923394
MFA-TR*     AND BG2.CODE_BILL_CALC     = 'A'                            01923494
MFA-TR*     AND BG2.CODE_BILL_ITM_TYPE = 'C'                            01923594
MFA-TR*     AND BG2.CODE_BILL_ITM_IND  = 'A'                            01923694
MFA-TR*     AND BG2.REVENUE_MONTH     <= (SELECT MAX(ZA.REVENUE_MONTH)  01923794
MFA-TR*      FROM CSS_BILLING_DET ZA                                    01923894
MFA-TR*      WHERE ZA.ACCOUNT_NO         = BG2.ACCOUNT_NO               01923994
MFA-TR*        AND ZA.CODE_UTIL_TYPE     = BG2.CODE_UTIL_TYPE           01924094
MFA-TR*        AND ZA.IC_NO              = BG2.IC_NO                    01924194
MFA-TR*        AND ZA.REVENUE_MONTH      > 0                            01924294
MFA-TR*        AND ZA.CODE_BILL_CALC     = 'A'                          01924394
MFA-TR*        AND ZA.CODE_BILL_ITM_TYPE = 'C'                          01924494
MFA-TR*        AND ZA.CODE_BILL_ITM_IND  = 'A')                         01924594
MFA-TR* AND BG2.REVENUE_MONTH > (SELECT DEC((CHAR(SUBSTR(CHAR(DATE(     01924694
MFA-TR*         CHAR(SUBSTR(CHAR(MAX(ZB.REVENUE_MONTH)),2,4) ||         01924794
MFA-TR*         '-' || SUBSTR(CHAR(MAX(ZB.REVENUE_MONTH)),6,2) || '-'   01924894
MFA-TR*         || '01')) - 24 MONTHS),1,4)) ||                         01924994
MFA-TR*         CHAR(SUBSTR(CHAR(DATE(CHAR(SUBSTR(CHAR                  01925094
MFA-TR*         (MAX(ZB.REVENUE_MONTH)),2,4) ||                         01925194
MFA-TR*         '-' || SUBSTR(CHAR(MAX(ZB.REVENUE_MONTH)),6,2) || '-'   01925294
MFA-TR*         || '01')) - 24 MONTHS),6,2))))                          01925394
MFA-TR*         FROM CSS_BILLING_DET ZB                                 01925494
MFA-TR*         WHERE ZB.ACCOUNT_NO         = BG2.ACCOUNT_NO            01925594
MFA-TR*         AND ZB.CODE_UTIL_TYPE     = BG2.CODE_UTIL_TYPE          01925694
MFA-TR*         AND ZB.IC_NO              = BG2.IC_NO                   01925794
MFA-TR*         AND ZB.REVENUE_MONTH      > 0                           01925894
MFA-TR*         AND ZB.CODE_BILL_CALC     = 'A'                         01925994
MFA-TR*         AND ZB.CODE_BILL_ITM_TYPE = 'C'                         01926094
MFA-TR*         AND ZB.CODE_BILL_ITM_IND  = 'A')                        01926194
MFA-TR*         AND BG2.REVENUE_MONTH >= 201106                         01926294
MFA-TR*         ORDER BY DATE_BILLED DESC,                              01926394
MFA-TR*                  BILL_NO DESC,                                  01926494
MFA-TR*                  METER_NO DESC,                                 01926594
MFA-TR*                  DATE_READ DESC                                 01919594
MFA-TR*        FOR FETCH ONLY WITH UR                                   01926694
MFA-TR*    END-EXEC.                                                    01926794
      *EJECT                                                            01926894
      ******************************************************************01927094
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************01990015
      * 0000-MAINLINE                                                  *02000015
      *                                                                *02010015
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02020015
      ******************************************************************02030015
      *                                                                 02040015
       0000-MAINLINE.                                                   
      *                                                                 02060015
           PERFORM 0100-INITIALIZE                                      
              THRU 0100-EXIT.                                           
           PERFORM 1000-PROCESS-INPUT                                   
              THRU 1000-EXIT.                                           
           PERFORM 2000-PROCESS-OUTPUT                                  
              THRU 2000-EXIT.                                           
           PERFORM 9999-END-PROGRAM                                     
              THRU 9999-EXIT.                                           
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02180015
      * 0100-INITIALIZE                                                *02190015
      *                                                                *02200015
      ******************************************************************02260015
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************03020015
REARCH*0100A-DECLARE-GTT-R1.                                            03030035
REARCH******************************************************************03040015
REARCH 0100A-DECLARE-GTT-R1.                                            
REARCH*                                                                 03060015
            MOVE 'SESSION.CSR04474_R1'       TO GTT-NAME.               
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04474_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04474_R1
               (                                                       
REARCH              RETURN_CODE        INT                          
REARCH             ,RECORD_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,CUSTOMER_NO        DECIMAL(10,0)                    
                   ,PREMISE_NO         DECIMAL(10,0)                    
                   ,SERV_ADDR CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,SERV_TOWN CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,SERV_STATE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,SERV_ZIP CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,MAIL_ADDR CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,MAIL_TOWN CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,MAIL_ZIP CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
P00411          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 03580015
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                 03610015
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE GTT-NAME           TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                 03820157
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR                             
A37342         WITH ROWSET POSITIONING FOR                              
REARCH         SELECT                                                   
REARCH             *                                                    
REARCH         FROM                                                     
REARCH             #CSR04474_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03821057
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            03822057
MFA-TR*        WITH ROWSET POSITIONING FOR                              03823057
MFA-TR*        SELECT                                                   03824057
MFA-TR*            *                                                    03825057
MFA-TR*        FROM                                                     03826057
MFA-TR*            SESSION.CSR04474_R1                                  03827059
MFA-TR*    END-EXEC.                                                    03828057
REARCH*                                                                 03830015
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH******************************************************************03860052
REARCH*0100B-DECLARE-GTT-R2.                                            03861052
REARCH******************************************************************03862052
REARCH 0100B-DECLARE-GTT-R2.                                            
REARCH*                                                                 03863152
            MOVE 'SESSION.CSR04474_R2'       TO GTT-NAME.               
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR04474_R2')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR04474_R2
               (                                                       
REARCH              RETURN_CODE_2      INT                          
REARCH             ,RECORD_ID_2 CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,ACCOUNT_NO_2 CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[BILL-NO]            INT                          
                   ,[BILL-DATE] CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[METER-NO] CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,[CODE-USAGE-TYPE] CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[NO-DAYS]            SMALLINT                         
                   ,[NO-UNITS]           INT                          
                   ,[NO-DEMAND-UNITS]    INT                          
                   ,[BILL-UNITS]         INT                          
                   ,[READ-DATE] CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[REVENUE-MONTH]      INT                          
                   ,[RATE-PLAN-NO] CHAR(3)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[MTR-READ-SOURCE-CD] CHAR(1)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,[AMT-BILL-ITEM]      DECIMAL(11,2)                    
                   ,[BILLED-COMP-AMT]    DECIMAL(11,2)                    
                   ,[AMT-STATE-TAX]      DECIMAL(09,2)                    
                   ,[AMT-OTHER-TAX]      DECIMAL(09,2)                    
                   ,[AMT-CITY-TAX]       DECIMAL(09,2)                    
P00411          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 03866094
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                 03866394
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000B-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000B-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100B'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE GTT-NAME           TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
PRJ411                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C2 CURSOR                             
A37342         WITH ROWSET POSITIONING FOR                              
REARCH         SELECT                                                   
REARCH             *                                                    
REARCH         FROM                                                     
REARCH             #CSR04474_R2                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03868694
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            03868794
MFA-TR*        WITH ROWSET POSITIONING FOR                              03868894
MFA-TR*        SELECT                                                   03868994
MFA-TR*            *                                                    03869094
MFA-TR*        FROM                                                     03869194
MFA-TR*            SESSION.CSR04474_R2                                  03869294
MFA-TR*    END-EXEC.                                                    03869394
REARCH*                                                                 03869494
REARCH 0100B-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************03869794
      * 1000-PROCESS-INPUT                                             *03870015
      *                                                                *03880015
      *     1. RECEIVE PARMS.                                          *03890015
      ******************************************************************03900015
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                 03930015
           MOVE PARM-ACCOUNT-NO         TO AT-ACCOUNT-NO                
                                           CX-ACCOUNT-NO.               
      *                                                                 04000015
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04040015
      * 2000-PROCESS-OUTPUT.                                           *04050015
      *                                                                *04060015
      ******************************************************************04140015
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           PERFORM 2200-BUILD-RESULT-HEADER                             
              THRU 2200-EXIT.                                           
                                                                        
           PERFORM 2300-BUILD-RESULT-DETAILS                            
              THRU 2300-EXIT.                                           
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************04760015
      * 2200-BUILD-RESULT-HEADER                                       *04770015
      *                                                                *04780015
      ****************************************************************  04910015
                                                                        
       2200-BUILD-RESULT-HEADER.                                        
                                                                        
           PERFORM 7000-OPEN-AT-CURSOR                                  
              THRU 7000-EXIT.                                           
                                                                        
               PERFORM 7010-FETCH-AT-ROW                                
                  THRU 7010-EXIT.                                       
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE.               
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE WS-HEADER-REC-ID        TO S-RECORD-ID              
               MOVE AT-CUSTOMER-NO          TO S-CUSTOMER-NO            
               MOVE PARM-ACCOUNT-NO         TO S-ACCOUNT-NO             
               MOVE AT-PREMISE-NO           TO S-PREMISE-NO             
               MOVE WS-SERV-ADDR            TO S-SERV-ADDR              
               MOVE A4-TOWN                 TO S-SERV-TOWN              
               MOVE A4-STATE                TO S-SERV-STATE             
               MOVE A4-ZIP-CODE             TO S-SERV-ZIP               
                                                                        
               PERFORM 7200-OPEN-DY-CURSOR                              
                  THRU 7200-EXIT                                        
                                                                        
               PERFORM 7210-FETCH-DY-ROW                                
                  THRU 7210-EXIT                                        
                                                                        
               PERFORM 8100A-SEND-RESULT                                
                  THRU 8100A-EXIT                                       
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '2200'              TO ACTIVE-PARAGRAPH             
               MOVE 'FETCH'             TO ABEND-FUNCTION               
               MOVE 'CSS_ACCOUNT      ' TO TABLE-1                      
               MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1              
               MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9000-SEND-ERROR-RESULT                           
                  THRU 9000-EXIT                                        
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                  THRU 9900-EXIT                                        
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 7020-CLOSE-AT-CURSOR                                 
              THRU 7020-EXIT.                                           
           PERFORM 7220-CLOSE-DY-CURSOR                                 
              THRU 7220-EXIT.                                           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        06310015
      *                                                                 06320015
      ******************************************************************06330065
      * 2300-BUILD-RESULT-DETAILS                                      *06340065
      ****************************************************************  06360065
                                                                        
       2300-BUILD-RESULT-DETAILS.                                       
                                                                        
           PERFORM 7100-OPEN-BG-CURSOR                                  
              THRU 7100-EXIT.                                           
                                                                        
      *        PERFORM 7110-FETCH-BG-ROW                                06430083
      *           THRU 7110-EXIT.                                       06440083
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-2.             
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2310-BUILD-RESULT-DETAILS                        
                  THRU 2310-EXIT                                        
                  UNTIL NO-MORE-DATA                                    
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE '2300'              TO ACTIVE-PARAGRAPH             
               MOVE 'FETCH'             TO ABEND-FUNCTION               
               MOVE 'CSS_BILLING_DET ' TO TABLE-1                       
               MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1              
               MOVE CX-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9000-SEND-ERROR-RESULT                           
                  THRU 9000-EXIT                                        
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                  THRU 9900-EXIT                                        
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 7120-CLOSE-BG-CURSOR                                 
              THRU 7120-EXIT.                                           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        06810065
      *                                                                 06820065
REARCH******************************************************************06830083
REARCH*2310-BUILD-RESULT-DETAILS.                                       06840083
REARCH******************************************************************06850083
REARCH 2310-BUILD-RESULT-DETAILS.                                       
REARCH*                                                                 06870083
               PERFORM 7110-FETCH-BG-ROW                                
                  THRU 7110-EXIT.                                       
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE   TO S-RETURN-CODE-2.             
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE WS-DETAIL-REC-ID        TO S-RECORD-ID-2            
               MOVE PARM-ACCOUNT-NO         TO S-ACCOUNT-NO-2           
               MOVE CX-BILL-NO              TO S-BILL-NO                
               MOVE BI-DATE-BILLED          TO S-BILL-DATE              
               MOVE CX-METER-NO             TO WS-MTR-NO                
               MOVE WS-METER-NO             TO S-METER-NO               
      ***      STRING '01E',CX-METER-NO DELIMITED BY SIZE               06871286
      ***      INTO S-METER-NO END-STRING                               06871286
               MOVE CX-CODE-USAGE-TYPE      TO S-CODE-USAGE-TYPE        
               MOVE CX-NO-DAYS              TO S-NO-DAYS                
               MOVE CX-NO-UNITS             TO S-NO-UNITS               
               MOVE CX-NO-DEMAND-UNITS      TO S-NO-DEMAND-UNITS        
               MOVE BZ-BILL-UNITS           TO S-BILL-UNITS             
               MOVE CX-DATE-READ            TO S-READ-DATE              
               MOVE BG-REVENUE-MONTH        TO S-REVENUE-MONTH          
               MOVE BG-RATE-PLAN-NO         TO S-RATE-PLAN-NO           
               MOVE BG-AMT-BILL-ITEM        TO S-AMT-BILL-ITEM          
               MOVE BZ-BILLED-COMP-AM       TO S-BILLED-COMP-AMT        
               MOVE BG-AMT-STATE-TAX        TO S-AMT-STATE-TAX          
               MOVE BG-AMT-OTHER-TAX        TO S-AMT-OTHER-TAX          
               MOVE BG-AMT-CITY-TAX         TO S-AMT-CITY-TAX           
               MOVE MN-MTR-READ-SOURCE-CD   TO S-MTR-READ-SOURCE-CD     
               PERFORM 8100B-SEND-RESULT                                
                  THRU 8100B-EXIT                                       
           ELSE                                                         
               SET NO-MORE-DATA           TO TRUE                       
           END-IF.                                                      
REARCH*                                                                 06970083
REARCH 2310-EXIT.                                                       
REARCH     EXIT.                                                        
HPCCDM*    EJECT                                                        07000083
      *                                                                 07010083
       7000-OPEN-AT-CURSOR.                                             
      ******************************************************************07340016
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **07350016
      **  ROWS FROM THE CSS_ACCOUNT AND CSS_ADDR_FORMATTED TABLE      **07360016
      ******************************************************************07370016
      *                                                                 07380016
           EXEC SQL                                                     
               OPEN AT-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07420016
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 07440016
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
CBSI           MOVE '7000'              TO ACTIVE-PARAGRAPH             
CBSI           MOVE 'OPEN'              TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
               MOVE 'CSS_ACCOUNT'       TO TABLE-1                      
               MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1              
               MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9000-SEND-ERROR-RESULT                           
                  THRU 9000-EXIT                                        
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                  THRU 9900-EXIT                                        
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07630016
      *                                                                 07631065
       7100-OPEN-BG-CURSOR.                                             
      ******************************************************************07633065
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **07634065
      **  ROWS FROM THE CSS_BILLING_DET,CSS_CNSMPTN_HIST TABLES       **07635065
      ******************************************************************07636065
      *                                                                 07637065
           EXEC SQL                                                     
               OPEN BG-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07639265
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 07639465
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
CBSI           MOVE '7100'              TO ACTIVE-PARAGRAPH             
CBSI           MOVE 'OPEN'              TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
               MOVE 'CSS_CNSMPTN_HIST'  TO TABLE-1                      
               MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1              
               MOVE CX-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9000-SEND-ERROR-RESULT                           
                  THRU 9000-EXIT                                        
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                  THRU 9900-EXIT                                        
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07641365
       7200-OPEN-DY-CURSOR.                                             
      ******************************************************************07641588
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **07641688
      **  ROWS FROM THE CSS_ACCOUNT AND CSS_ADDR_FREEFORM  TABLE      **07641788
      ******************************************************************07641888
      *                                                                 07641988
           EXEC SQL                                                     
               OPEN DY-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07642388
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                 07642588
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
CBSI           MOVE '7200'              TO ACTIVE-PARAGRAPH             
CBSI           MOVE 'OPEN'              TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
               MOVE 'CSS_ADDR-FREEFORM' TO TABLE-1                      
               MOVE 'ACCOUNT_NO  '      TO TABLE-ELEMENT-1              
               MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
               PERFORM 9000-SEND-ERROR-RESULT                           
                  THRU 9000-EXIT                                        
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                  THRU 9900-EXIT                                        
           END-IF.                                                      
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07644488
       7010-FETCH-AT-ROW.                                               
      *                                                                 07660016
      ******************************************************************07670016
      *                                                                 07680016
           EXEC SQL                                                     
               FETCH AT-CURSOR                                          
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
                     :WS-SERV-ADDR,                                     
                     :A4-TOWN,                                          
                     :A4-STATE,                                         
                     :A4-ZIP-CODE                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07781016
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 07800016
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI           MOVE '7010'              TO ACTIVE-PARAGRAPH             
CBSI           MOVE 'FETCH'             TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ACCOUNT      '  TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            08100016
                                                                        
      *                                                                 08111065
      ******************************************************************08111165
       7110-FETCH-BG-ROW.                                               
      ******************************************************************08114065
      *                                                                 08115065
           EXEC SQL                                                     
               FETCH BG-CURSOR                                          
                INTO :CX-ACCOUNT-NO,                                    
                     :CX-BILL-NO,                                       
                     :CX-METER-NO,                                      
                     :CX-CODE-USAGE-TYPE,                               
                     :CX-NO-DAYS,                                       
                     :CX-NO-UNITS,                                      
                     :CX-NO-DEMAND-UNITS,                               
                     :CX-DATE-READ,                                     
                     :BI-DATE-BILLED,                                   
                     :BG-REVENUE-MONTH,                                 
                     :BG-RATE-PLAN-NO,                                  
                     :BG-AMT-BILL-ITEM,                                 
                     :BG-AMT-STATE-TAX,                                 
                     :BG-AMT-OTHER-TAX,                                 
                     :BG-AMT-CITY-TAX,                                  
                     :BZ-BILL-UNITS,                                    
                     :BZ-BILLED-COMP-AM,                                
                     :MN-MTR-READ-SOURCE-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08120894
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 08121094
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                    SET NO-MORE-DATA           TO TRUE                  
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI           MOVE '7110'              TO ACTIVE-PARAGRAPH             
CBSI           MOVE 'FETCH'             TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CNSMPTN      '  TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE CX-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF                                                       
           END-IF.                                                      
       7110-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            08123394
      *                                                                 08123494
       7210-FETCH-DY-ROW.                                               
      ******************************************************************08123694
      *                                                                 08123794
           EXEC SQL                                                     
               FETCH DY-CURSOR                                          
                INTO :AT-ACCOUNT-NO,                                    
                     :AT-ADDRESS-ID,                                    
                     :WS-MAIL-ADDR,                                     
                     :DZ-ADDR-CITY-STATE,                               
                     :DZ-ADDR-ZIP-CODE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08124694
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 08124894
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               MOVE WS-MAIL-ADDR            TO S-MAIL-ADDR              
               MOVE DZ-ADDR-CITY-STATE      TO S-MAIL-TOWN              
               MOVE DZ-ADDR-ZIP-CODE        TO S-MAIL-ZIP               
           ELSE IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                  MOVE SPACE                   TO S-MAIL-ADDR           
                  MOVE SPACE                   TO S-MAIL-TOWN           
                  MOVE SPACE                   TO S-MAIL-ZIP            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI           MOVE '7210'              TO ACTIVE-PARAGRAPH             
CBSI           MOVE 'FETCH'             TO ABEND-FUNCTION               
CBSI           MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF                                                       
           END-IF.                                                      
       7210-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            08127488
                                                                        
      *                                                                 08127688
                                                                        
       7020-CLOSE-AT-CURSOR.                                            
      ******************************************************************08130016
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **08140016
      **  ROWS FROM THE CSS_ACCOUNT     TABLE.                        **08150016
      ******************************************************************08160016
      *                                                                 08170016
           EXEC SQL                                                     
               CLOSE AT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08210016
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 08230016
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '7020'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ACCOUNT      '  TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF.                                                      
       7020-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            08420016
      *                                                                 08430016
       7120-CLOSE-BG-CURSOR.                                            
      ******************************************************************08430265
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **08430365
      **  ROWS FROM THE CSS_CNSMPTN_HIST & CSS_BILLING_DET TABLE      **08430465
      ******************************************************************08430565
      *                                                                 08430665
           EXEC SQL                                                     
               CLOSE BG-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08431065
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 08431265
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '7120'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_CNSMPTN_HIST '  TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE CX-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            08433165
      *                                                                 08433265
                                                                        
       7220-CLOSE-DY-CURSOR.                                            
      ******************************************************************08433588
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **08433688
      **  ROWS FROM THE CSS_ACCOUNT     TABLE.                        **08433788
      ******************************************************************08433888
      *                                                                 08433988
           EXEC SQL                                                     
               CLOSE DY-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 08434388
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
      *                                                                 08434588
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '7220'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT                            
                 THRU 9000-EXIT                                         
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                 THRU 9900-EXIT                                         
           END-IF.                                                      
       7220-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                            08436488
      *                                                                 08436588
REARCH******************************************************************08436620
REARCH*8000A-DELETE-GTT-ROWS.                                           08436720
REARCH******************************************************************08436820
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                 08437020
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR04474_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    08438020
MFA-TR*         DELETE FROM SESSION.CSR04474_R1                         08439059
MFA-TR*     END-EXEC.                                                   08439120

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 08439220
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                 08439420
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR04474_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                 08441220
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                 08441520
REARCH******************************************************************08441652
REARCH*8000B-DELETE-GTT-ROWS.                                           08441752
REARCH******************************************************************08441852
REARCH 8000B-DELETE-GTT-ROWS.                                           
REARCH*                                                                 08442052
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR04474_R2                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    08444152
MFA-TR*         DELETE FROM SESSION.CSR04474_R2                         08444259
MFA-TR*     END-EXEC.                                                   08444352

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 08444452
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                 08444652
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000B'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR04474_R2'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                 08446452
REARCH 8000B-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                 08446752
REARCH******************************************************************08447016
REARCH*8100A-SEND-RESULT.                                               08450035
REARCH******************************************************************08460016
REARCH 8100A-SEND-RESULT.                                               
      *                                                                 08471058
           IF WS-GTT-IND-R1 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
REARCH        PERFORM 0100A-DECLARE-GTT-R1  THRU 0100A-EXIT             
              MOVE 'Y'                        TO WS-GTT-IND-R1          
           END-IF                                                       
REARCH     MOVE WS-ACTIVE-RETURN-CODE         TO S-RETURN-CODE.         
      *                                                                 08479058
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR04474_R1                        
REARCH           (                                                      
REARCH                 RETURN_CODE                                      
REARCH                ,RECORD_ID                                        
REARCH                ,ACCOUNT_NO                                       
REARCH                ,CUSTOMER_NO                                      
REARCH                ,PREMISE_NO                                       
REARCH                ,SERV_ADDR                                        
REARCH                ,SERV_TOWN                                        
REARCH                ,SERV_STATE                                       
REARCH                ,SERV_ZIP                                         
REARCH                ,MAIL_ADDR                                        
REARCH                ,MAIL_TOWN                                        
REARCH                ,MAIL_ZIP                                         
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH                :S-RETURN-CODE                                    
REARCH               ,:S-RECORD-ID                                      
REARCH               ,:S-ACCOUNT-NO                                     
REARCH               ,:S-CUSTOMER-NO                                    
REARCH               ,:S-PREMISE-NO                                     
REARCH               ,:S-SERV-ADDR                                      
REARCH               ,:S-SERV-TOWN                                      
REARCH               ,:S-SERV-STATE                                     
REARCH               ,:S-SERV-ZIP                                       
REARCH               ,:S-MAIL-ADDR                                      
REARCH               ,:S-MAIL-TOWN                                      
REARCH               ,:S-MAIL-ZIP                                       
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    08490016
MFA-TR*          INSERT INTO SESSION.CSR04474_R1                        08500059
MFA-TR*          (                                                      08510016
MFA-TR*                RETURN_CODE                                      08520016
MFA-TR*               ,RECORD_ID                                        08530016
MFA-TR*               ,ACCOUNT_NO                                       08540016
MFA-TR*               ,CUSTOMER_NO                                      08550016
MFA-TR*               ,PREMISE_NO                                       08560016
MFA-TR*               ,SERV_ADDR                                        08570016
MFA-TR*               ,SERV_TOWN                                        08580016
MFA-TR*               ,SERV_STATE                                       08590016
MFA-TR*               ,SERV_ZIP                                         08600016
MFA-TR*               ,MAIL_ADDR                                        08610088
MFA-TR*               ,MAIL_TOWN                                        08620088
MFA-TR*               ,MAIL_ZIP                                         08640088
MFA-TR*          )                                                      08930016
MFA-TR*          VALUES                                                 08940016
MFA-TR*          (                                                      08950016
MFA-TR*               :S-RETURN-CODE                                    08960016
MFA-TR*              ,:S-RECORD-ID                                      08970016
MFA-TR*              ,:S-ACCOUNT-NO                                     08980016
MFA-TR*              ,:S-CUSTOMER-NO                                    08990016
MFA-TR*              ,:S-PREMISE-NO                                     09000016
MFA-TR*              ,:S-SERV-ADDR                                      09010016
MFA-TR*              ,:S-SERV-TOWN                                      09020016
MFA-TR*              ,:S-SERV-STATE                                     09030016
MFA-TR*              ,:S-SERV-ZIP                                       09040016
MFA-TR*              ,:S-MAIL-ADDR                                      09050088
MFA-TR*              ,:S-MAIL-TOWN                                      09060088
MFA-TR*              ,:S-MAIL-ZIP                                       09080088
MFA-TR*          )                                                      09370016
MFA-TR*      END-EXEC.                                                  09380016

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 09390016
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                 09410016
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100A'              TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR04474_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                 09560016
REARCH  8100A-EXIT.                                                     
REARCH      EXIT.                                                       
REARCH******************************************************************09581052
REARCH*8100B-SEND-RESULT.                                               09582052
REARCH******************************************************************09583052
REARCH 8100B-SEND-RESULT.                                               
      *                                                                 09584158
           IF WS-GTT-IND-R2 = 'Y'                                       
              CONTINUE                                                  
           ELSE                                                         
REARCH        PERFORM 0100B-DECLARE-GTT-R2  THRU 0100B-EXIT             
              MOVE 'Y'                        TO WS-GTT-IND-R2          
           END-IF                                                       
REARCH     MOVE WS-ACTIVE-RETURN-CODE         TO S-RETURN-CODE-2.       
      *                                                                 09585058
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR04474_R2                        
REARCH           (                                                      
REARCH                 RETURN_CODE_2                                    
REARCH                ,RECORD_ID_2                                      
                      ,ACCOUNT_NO_2                                     
                      ,[BILL-NO]                                          
                      ,[BILL-DATE]                                        
                      ,[METER-NO]                                         
                      ,[CODE-USAGE-TYPE]                                  
                      ,[NO-DAYS]                                          
                      ,[NO-UNITS]                                         
                      ,[NO-DEMAND-UNITS]                                  
                      ,[BILL-UNITS]                                       
                      ,[READ-DATE]                                        
                      ,[REVENUE-MONTH]                                    
                      ,[RATE-PLAN-NO]                                     
                      ,[AMT-BILL-ITEM]                                    
                      ,[BILLED-COMP-AMT]                                  
                      ,[AMT-STATE-TAX]                                    
                      ,[AMT-OTHER-TAX]                                    
                      ,[AMT-CITY-TAX]                                     
                      ,[MTR-READ-SOURCE-CD]                               
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH               :S-RETURN-CODE-2,                                  
REARCH               :S-RECORD-ID-2,                                    
                     :S-ACCOUNT-NO-2,                                   
                     :S-BILL-NO,                                        
                     :S-BILL-DATE,                                      
                     :S-METER-NO,                                       
                     :S-CODE-USAGE-TYPE,                                
                     :S-NO-DAYS,                                        
                     :S-NO-UNITS,                                       
                     :S-NO-DEMAND-UNITS,                                
                     :S-BILL-UNITS,                                     
                     :S-READ-DATE,                                      
                     :S-REVENUE-MONTH,                                  
                     :S-RATE-PLAN-NO,                                   
                     :S-AMT-BILL-ITEM,                                  
                     :S-BILLED-COMP-AMT,                                
                     :S-AMT-STATE-TAX,                                  
                     :S-AMT-OTHER-TAX,                                  
                     :S-AMT-CITY-TAX,                                   
                     :S-MTR-READ-SOURCE-CD                              
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    09586052
MFA-TR*          INSERT INTO SESSION.CSR04474_R2                        09587059
MFA-TR*          (                                                      09588052
MFA-TR*                RETURN_CODE_2                                    09589055
MFA-TR*               ,RECORD_ID_2                                      09589155
MFA-TR*               ,ACCOUNT_NO_2                                     09589265
MFA-TR*               ,BILL-NO                                          09589365
MFA-TR*               ,BILL-DATE                                        09589480
MFA-TR*               ,METER-NO                                         09589565
MFA-TR*               ,CODE-USAGE-TYPE                                  09589694
MFA-TR*               ,NO-DAYS                                          09589794
MFA-TR*               ,NO-UNITS                                         09589894
MFA-TR*               ,NO-DEMAND-UNITS                                  09589994
MFA-TR*               ,BILL-UNITS                                       09590094
MFA-TR*               ,READ-DATE                                        09590194
MFA-TR*               ,REVENUE-MONTH                                    09590294
MFA-TR*               ,RATE-PLAN-NO                                     09590394
MFA-TR*               ,AMT-BILL-ITEM                                    09590494
MFA-TR*               ,BILLED-COMP-AMT                                  09590594
MFA-TR*               ,AMT-STATE-TAX                                    09590694
MFA-TR*               ,AMT-OTHER-TAX                                    09590794
MFA-TR*               ,AMT-CITY-TAX                                     09590894
MFA-TR*               ,MTR-READ-SOURCE-CD                               09590894
MFA-TR*          )                                                      09590994
MFA-TR*          VALUES                                                 09591094
MFA-TR*          (                                                      09591194
MFA-TR*              :S-RETURN-CODE-2,                                  09591294
MFA-TR*              :S-RECORD-ID-2,                                    09591394
MFA-TR*              :S-ACCOUNT-NO-2,                                   09591494
MFA-TR*              :S-BILL-NO,                                        09591594
MFA-TR*              :S-BILL-DATE,                                      09591694
MFA-TR*              :S-METER-NO,                                       09591794
MFA-TR*              :S-CODE-USAGE-TYPE,                                09591894
MFA-TR*              :S-NO-DAYS,                                        09591994
MFA-TR*              :S-NO-UNITS,                                       09592094
MFA-TR*              :S-NO-DEMAND-UNITS,                                09592194
MFA-TR*              :S-BILL-UNITS,                                     09592294
MFA-TR*              :S-READ-DATE,                                      09592394
MFA-TR*              :S-REVENUE-MONTH,                                  09592494
MFA-TR*              :S-RATE-PLAN-NO,                                   09592594
MFA-TR*              :S-AMT-BILL-ITEM,                                  09592694
MFA-TR*              :S-BILLED-COMP-AMT,                                09592794
MFA-TR*              :S-AMT-STATE-TAX,                                  09592894
MFA-TR*              :S-AMT-OTHER-TAX,                                  09592994
MFA-TR*              :S-AMT-CITY-TAX,                                   09593094
MFA-TR*              :S-MTR-READ-SOURCE-CD                              09593094
MFA-TR*          )                                                      09593194
MFA-TR*      END-EXEC.                                                  09593294

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 09593394
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                 09593594
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100B'              TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR04474_R2'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                 09595094
REARCH  8100B-EXIT.                                                     
REARCH      EXIT.                                                       
HPCCDM*EJECT                                                            09596094
      **********************End Of Program *****************************09600047
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     09610047
      ******************************************************************09620047
REARCH     EXEC SQL                                                     09621047
REARCH        INCLUDE CPDSP300                                          09622047
REARCH     END-EXEC.                                                    09623047
                                                                        
      ******************************************************************09623442
      * 8900-SEND-DONE.                                                *09623542
      ******************************************************************09623642
      *                                                                 09623742
       8900-SEND-DONE.                                                  
      *                                                                 09623942
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                 09633442
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09633742
      ******************************************************************09633838
      * 9000-SEND-ERROR-RESULT                                         *09633938
      ******************************************************************09634038
      *                                                                 09634138
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 09634338
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 09634947
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09635347
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                 09635958
           MOVE 'N'                         TO WS-GTT-IND-R1            
                                               WS-GTT-IND-R2.           
      *                                                                 09636647
           PERFORM 8100A-SEND-RESULT        THRU 8100A-EXIT.            
           PERFORM 8100B-SEND-RESULT        THRU 8100B-EXIT.            
      *                                                                 09637138
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09638038
      * 9999-END-PROGRAM.                                      *        09760041
      ******************************************************************09770041
      *                                                                 09780041
       9999-END-PROGRAM.                                                
      *                                                                 09800041
           IF CTR-ROWS < 1                                              
      ******************************************************************09820047
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *09830047
      ******************************************************************09840047
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
      *                                                                 09930041
           
MSQ016        GOBACK.                                                    
      *                                                                 09950041
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                *09980041
      **********************End Of Program *****************************09990041
