       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04472.                                         
COB303 DATE-WRITTEN.  JULY 01, 2011.                                    
       DATE-COMPILED.                                                   
      *                                                                         
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *                                                               *         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                  *         
      *                                                               *         
      *  THIS PROGRAM CHECKS FOR PENDING ORDERS ON A PREMISE FOR EVERY*         
      *  POWER OUTAGE EVENT REPORTED BY SAMRT-SYNCH METERS.           *         
      *                                                               *         
      *****************************************************************         
      *                                                               *         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   --------------------------------------- *         
P00462*  07/01/10  VENKAT P   PROCEDURE ORIGINALLY CODED.             *         
P00462*  02/02/12  VENKAT P   REMOVED VALIDATION BY ASSIGNED-DATETIME *         
A#5347*  06/30/16  SS95855    OPENWAY CHANGES                         *         
A#5347*  08/11/16  SS95855    INCLUDE LOGIC FOR HANDLING CUST GEN MTR *         
      *                       AND METER INVENTORY BLOCK.(ACT004)      *         
      *                                                               *         
      *****************************************************************         
      *****************************************************************         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *****************************************************************         
      *                                                               *         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04472'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01  WS-START                          PIC X(40) VALUE            
           'WORKING STORAGE FOR CSR04472 STARTS HERE'.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                  PIC X(08) VALUE 'CSR04472'.
           05  SEND-DONE-SW                  PIC X(01) VALUE 'Y'.       
               88 SEND-DONE-ERROR                      VALUE 'N'.       
               88 SEND-DONE-OK                         VALUE 'Y'.       
           05  WS-WANTED-BY-TS-1             PIC X(26) VALUE SPACES.    
           05  WS-WANTED-BY-TS-2             PIC X(26) VALUE SPACES.    
           05  WS-TEMP-CONTACT-NAME          PIC X(25) VALUE SPACES.    
ACT004     05  WS-TEMP-METER-NO              PIC X(09) VALUE SPACES.    
ACT004     05  WS-COMM-LEN                   PIC S9(4) COMP  VALUE +59. 
ACT004     05 WS-COMM-TEXT.                                             
ACT004        10 WS-COMM-MESG                PIC X(50) VALUE            
ACT004        'OMS Storm/Outage Order Initiated - LIGHTS OUT.MTR#'.     
ACT004        10 WS-COMM-MTR-NO              PIC X(09) VALUE SPACES.    
ACT004     05 WS-CUST-GENERATION-PBI         PIC X(01) VALUE 'B'.       
ACT004     05 WS-CUST-GENERATION-BCA         PIC X(01) VALUE 'D'.       
ACT004     05 WS-N                           PIC X(01) VALUE 'N'.       
ACT004     05 WS-Y                           PIC X(01) VALUE 'Y'.       
ACT004     05 WS-SS001                       PIC X(05) VALUE 'SS001'.   
ACT004     05 WS-SS001-RSN                   PIC X(20) VALUE            
ACT004                                       'Acct/Meter not valid'.    
ACT004     05 WS-SS002                       PIC X(05) VALUE 'SS002'.   
ACT004     05 WS-SS002-RSN                   PIC X(19) VALUE            
ACT004                                       'Acct/Prem not valid'.     
ACT004     05 WS-SS003                       PIC X(05) VALUE 'SS003'.   
ACT004     05 WS-SS003-RSN                   PIC X(23) VALUE            
ACT004                                       'Acct not Active/Pending'. 
ACT004     05 WS-SS004                       PIC X(05) VALUE 'SS004'.   
ACT004     05 WS-SS004-RSN                   PIC X(16) VALUE            
ACT004                                       'Meter not Active'.        
ACT004     05 WS-SS005                       PIC X(05) VALUE 'SS005'.   
ACT004     05 WS-SS005-RSN                   PIC X(13) VALUE            
ACT004                                       'Solar Account'.           
ACT004     05 WS-SS006                       PIC X(05) VALUE 'SS006'.   
ACT004     05 WS-SS006-RSN                   PIC X(13) VALUE            
ACT004                                       'Service Order'.           
ACT004     05 WS-SS007                       PIC X(05) VALUE 'SS007'.   
ACT004     05 WS-SS007-RSN                   PIC X(15) VALUE            
ACT004                                       'Meter Inventory'.         
ACT004 01  WS-FETCH-COMM-DATA                PIC X(01) VALUE 'Y'.       
ACT004     88  WS-NO-MORE-COMM-DATA                    VALUE 'N'.       
ACT004     88  WS-MORE-COMM-DATA                       VALUE 'Y'.       
       01 WS-NULL-IND.                                                  
           05 WS-NULL-IND-1                  PIC S9(04) COMP.           
           05 WS-RED-FL-NULL-IND             PIC S9(04) COMP.           
           05 WS-END-NULL-IND                PIC S9(04) COMP.           
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                      PIC S9(9) COMP VALUE 0.    
      *                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
A#5347     05  S-RETURN-CODE                 PIC S9(09) COMP  VALUE 0.  
           05  S-APPL-STATUS-CODE            PIC X(06)  VALUE SPACES.   
           05  S-SERV-ORDER-NO               PIC S9(13) COMP-3 VALUE 0. 
           05  S-WORK-TYPE-DESC              PIC X(25)  VALUE SPACES.   
A#5347     05  S-MTR-READ-SOURCE-CD          PIC X(01)  VALUE ' '.      
A#5347     05  S-UTILITY-SOURCE-CD           PIC X(01)  VALUE ' '.      
A#5347     05  S-METER-SUPPLYING             PIC X(15)  VALUE SPACES.   
ACT004     05  S-PALETTE-NO                  PIC X(04)  VALUE SPACES.   
ACT004     05  S-BLOCK-OUTAGE                PIC X(01)  VALUE SPACES.   
ACT004     05  S-BLOCK-REASON                PIC X(25)  VALUE SPACES.   
ACT004     05  S-ORDER-STATE-CD              PIC X(01)  VALUE SPACES.   
      *                                                                         
      *****************************************************************         
      *               COBOL WORKING STORAGE COPY BOOKS                *         
      *****************************************************************         
      *                                                                         
      *****************************************************************         
      *    ERROR HANDLING                                             *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    USED IN REDUCING EMBDDED BLANKS                            *         
      *****************************************************************         
      *                                                                         
           COPY CWS00011.                                                       
      *                                                                         
      *****************************************************************         
      *    WORKING STORAGE FOR ABEND SWITCH                           *         
      *****************************************************************         
      *                                                                         
           COPY CWS09900.                                                       
      *                                                                         
      *****************************************************************         
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                        *         
      *****************************************************************         
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      *****************************************************************         
      *   SQL COMMUNICATION AREA                                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   CSS_ACCOUNT - AT                                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_CUST_STATS - CE                                        *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCSTSTS                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_NAME - DQ                                              *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_NAME_ACCT_XREF - HT                                    *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   CSS_COMM_DATA - KO                                          *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBCOMDAT                                                
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   CSS_MTRD_ENVRNMT - MN                                       *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   CSS_WORK_TYPE - L4                                                    
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBWKTYP                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   CSS_SO_ORDER_INST - VI                                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *   CSS_SO_DATA - VO                                            *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_CODE_VALUE - UV                                          *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      *                                                                         
ACT004******************************************************************        
ACT004*   CSS_EQUIPMENT  - EQ                                          *        
ACT004******************************************************************        
ACT004*                                                                         
ACT004     EXEC SQL                                                             
ACT004        INCLUDE TBEQUIP                                                   
ACT004     END-EXEC.                                                            
ACT004*                                                                         
ACT004******************************************************************        
ACT004*   CSS_UTIL_ENVRNMT UT                                          *        
ACT004******************************************************************        
ACT004*                                                                         
ACT004     EXEC SQL                                                             
ACT004        INCLUDE TBUTLENV                                                  
ACT004     END-EXEC.                                                            
ACT004*                                                                         
ACT004******************************************************************        
ACT004*   CSS_RATE_PLAN_DESC RD                                        *        
ACT004******************************************************************        
ACT004*                                                                         
ACT004     EXEC SQL                                                             
ACT004        INCLUDE TBRTDESC                                                  
ACT004     END-EXEC.                                                            
ACT004*                                                                         
       01  WS-END                            PIC X(40)                  
           VALUE 'WORKING STORAGE FOR CSR04386 ENDS HERE  '.            
ACT004*                                                                         
ACT004******************************************************************        
ACT004* CURSOR TO FETCH EXISITNG COMM RECORD FOR THE METER             *        
ACT004******************************************************************        
ACT004     EXEC SQL                                                     
ACT004          DECLARE COMM_REC CURSOR FOR                             
ACT004             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           KO.COMMUNICATION_ID, 121), ' ', '-'), ':', '.') 
           COMMUNICATION_ID                           
ACT004                   ,KO.INITIAL_COMMENT_TX                         
ACT004               FROM CSS_COMM_DATA KO WITH(READUNCOMMITTED)                
ACT004              WHERE CAST(KO.COMMUNICATION_ID AS DATE) = 
           CAST(SYSDATETIMEOFFSET() AS DATE)      
ACT004                AND KO.ACCOUNT_NO   = :AT-ACCOUNT-NO              
ACT004                AND KO.PREMISE_NO   = :AT-PREMISE-NO              
ACT004                AND KO.CUSTOMER_NO  = :AT-CUSTOMER-NO             
ACT004                AND KO.COMPANY_NO   = :AT-COMPANY-NO              
ACT004                AND KO.USER_ID_ORIG = 'CSR4472'                   
ACT004              FOR READ ONLY                               
ACT004                                                      
ACT004     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE COMM_REC CURSOR FOR                                     
MFA-TR*            SELECT KO.COMMUNICATION_ID                                   
MFA-TR*                  ,KO.INITIAL_COMMENT_TX                                 
MFA-TR*              FROM CSS_COMM_DATA KO                                      
MFA-TR*             WHERE DATE(KO.COMMUNICATION_ID) = CURRENT DATE              
MFA-TR*               AND KO.ACCOUNT_NO   = :AT-ACCOUNT-NO                      
MFA-TR*               AND KO.PREMISE_NO   = :AT-PREMISE-NO                      
MFA-TR*               AND KO.CUSTOMER_NO  = :AT-CUSTOMER-NO                     
MFA-TR*               AND KO.COMPANY_NO   = :AT-COMPANY-NO                      
MFA-TR*               AND KO.USER_ID_ORIG = 'CSR4472'                           
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*             QUERYNO 7510                                                
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
COB305 01 PARM-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.         
       01  PARM-METER-NO                     PIC X(09).                 
COB305 01 PARM-PREMISE-NO        PIC S9(10) COMP-3 VALUE 0.         
      *                                                                         
       PROCEDURE DIVISION USING   PARM-ACCOUNT-NO                       
                                , PARM-METER-NO                         
                                , PARM-PREMISE-NO.                      
      *                                                                         
      *****************************************************************         
      * 0000-MAINLINE                                                 *         
      *****************************************************************         
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 0100-INITIALIZE                                               *         
      *****************************************************************         
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
              WITH ROWSET POSITIONING FOR                               
              SELECT                                                    
                  :S-RETURN-CODE             AS    RETURN_CODE          
                 ,:S-APPL-STATUS-CODE        AS    APPL_STATUS_CODE     
                 ,:S-SERV-ORDER-NO           AS    SERV_ORDER_NO        
                 ,:S-WORK-TYPE-DESC          AS    WORK_TYPE_DESC       
A#5347           ,:S-MTR-READ-SOURCE-CD      AS    MTR_READ_SOURCE_CD   
A#5347           ,:S-UTILITY-SOURCE-CD       AS    UTILITY_SOURCE_CD    
A#5347           ,:S-METER-SUPPLYING         AS    METER_SUPPLYING      
ACT004           ,:S-PALETTE-NO              AS    PALETTE_NO           
ACT004           ,:S-BLOCK-OUTAGE            AS    BLOCK_OUTAGE         
ACT004           ,:S-BLOCK-REASON            AS    BLOCK_REASON         
ACT004           ,:S-ORDER-STATE-CD          AS    ORDER_STATE_CD       
              FROM                                                      
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*       WITH ROWSET POSITIONING FOR                                       
MFA-TR*       SELECT                                                            
MFA-TR*           :S-RETURN-CODE             AS    RETURN_CODE                  
MFA-TR*          ,:S-APPL-STATUS-CODE        AS    APPL_STATUS_CODE             
MFA-TR*          ,:S-SERV-ORDER-NO           AS    SERV_ORDER_NO                
MFA-TR*          ,:S-WORK-TYPE-DESC          AS    WORK_TYPE_DESC               
MFA-TR*          ,:S-MTR-READ-SOURCE-CD      AS    MTR_READ_SOURCE_CD           
MFA-TR*          ,:S-UTILITY-SOURCE-CD       AS    UTILITY_SOURCE_CD            
MFA-TR*          ,:S-METER-SUPPLYING         AS    METER_SUPPLYING              
MFA-TR*          ,:S-PALETTE-NO              AS    PALETTE_NO                   
MFA-TR*          ,:S-BLOCK-OUTAGE            AS    BLOCK_OUTAGE                 
MFA-TR*          ,:S-BLOCK-REASON            AS    BLOCK_REASON                 
MFA-TR*          ,:S-ORDER-STATE-CD          AS    ORDER_STATE_CD               
MFA-TR*       FROM                                                              
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 1000-PROCESS-INPUT                                            *         
      *****************************************************************         
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO              TO AT-ACCOUNT-NO           
                                                MN-ACCOUNT-NO.          
           MOVE PARM-PREMISE-NO              TO VO-PREMISE-NO.          
           MOVE PARM-METER-NO                TO MN-METER-NO             
                                                VI-METER-NO.            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2000-PROCESS-OUTPUT                                           *         
      *****************************************************************         
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7100-SEL-ACCT-MTR-DET     THRU 7100-EXIT.            
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  IF AT-PREMISE-NO = PARM-PREMISE-NO                    
ACT004               CONTINUE                                           
                  ELSE                                                  
      * 'SS002' - Invalid Account & Premise combination                         
ACT004               MOVE WS-Y                TO S-BLOCK-OUTAGE         
ACT004               MOVE WS-SS002            TO S-APPL-STATUS-CODE     
ACT004               MOVE WS-SS002-RSN        TO S-BLOCK-REASON         
                     PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT         
                     GO TO 2000-EXIT                                    
                  END-IF                                                
                  IF AT-CODE-ACCT-STAT = 'A' OR 'P'                     
                     CONTINUE                                           
                  ELSE                                                  
      * 'SS003' - Account is not in Active or Pending status                    
ACT004               MOVE WS-Y                TO S-BLOCK-OUTAGE         
ACT004               MOVE WS-SS003            TO S-APPL-STATUS-CODE     
ACT004               MOVE WS-SS003-RSN        TO S-BLOCK-REASON         
                     PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT         
                     GO TO 2000-EXIT                                    
                  END-IF                                                
      * 'A'-Normal Billing  'B'-Lmited Service  'I'-Installed                 
                  IF MN-CODE-METER-STATUS = 'A' OR 'B' OR 'I'           
                     CONTINUE                                           
                  ELSE                                                  
      * 'SS004' - Meter is not in Active status                                 
ACT004               MOVE WS-Y                TO S-BLOCK-OUTAGE         
ACT004               MOVE WS-SS004            TO S-APPL-STATUS-CODE     
ACT004               MOVE WS-SS004-RSN        TO S-BLOCK-REASON         
                     PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT         
                     GO TO 2000-EXIT                                    
                  END-IF                                                
             WHEN NOT-FOUND                                             
ACT004* 'SS001' - Invalid Account & Meter combination                           
ACT004            MOVE WS-Y                  TO S-BLOCK-OUTAGE          
ACT004            MOVE WS-SS001              TO S-APPL-STATUS-CODE      
ACT004            MOVE WS-SS001-RSN          TO S-BLOCK-REASON          
                  PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT            
                  GO TO 2000-EXIT                                       
           END-EVALUATE.                                                
      *                                                                         
ACT004     MOVE MN-MTR-READ-SOURCE-CD        TO S-MTR-READ-SOURCE-CD.   
ACT004     MOVE MN-UTILITY-SOURCE-CD         TO S-UTILITY-SOURCE-CD.    
ACT004     MOVE MN-METER-SUPPLYING           TO S-METER-SUPPLYING.      
ACT004*                                                                         
ACT004     MOVE UT-RATE-PLAN-NO              TO RD-RATE-PLAN-NO.        
ACT004     MOVE MN-CODE-UTIL-TYPE            TO RD-CODE-UTIL-TYPE.      
ACT004     PERFORM 7400-GET-RATE-SUB-GRP-TYP THRU 7400-EXIT.            
ACT004                                                                  
ACT004* 'SS005' - Customer Generation meter                                     
ACT004     IF RD-RATE-SUB-GRP-TYPE = WS-CUST-GENERATION-PBI OR          
ACT004                               WS-CUST-GENERATION-BCA             
ACT004        MOVE WS-Y                      TO S-BLOCK-OUTAGE          
ACT004        MOVE WS-SS005                  TO S-APPL-STATUS-CODE      
ACT004        MOVE WS-SS005-RSN              TO S-BLOCK-REASON          
ACT004        PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
ACT004        GO TO 2000-EXIT                                           
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004     MOVE MN-CODE-UTIL-TYPE            TO VI-CODE-UTIL-TYPE       
           PERFORM 7200-SEL-SO-DETAILS       THRU 7200-EXIT.            
                                                                        
ACT004* 'SS006' - Existing Service Order                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT004        MOVE VO-ORDER-STATE-CD         TO S-ORDER-STATE-CD        
ACT004        IF VO-ORDER-STATE-CD = 'A'                                
ACT004           MOVE VO-SERV-ORDER-NO       TO S-SERV-ORDER-NO         
ACT004           MOVE L4-WORK-TYPE-DESC      TO S-WORK-TYPE-DESC        
ACT004           MOVE WS-Y                   TO S-BLOCK-OUTAGE          
ACT004           MOVE WS-SS006               TO S-APPL-STATUS-CODE      
ACT004           MOVE WS-SS006-RSN           TO S-BLOCK-REASON          
ACT004           PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT            
ACT004           GO TO 2000-EXIT                                        
ACT004        END-IF                                                    
           END-IF.                                                      
ACT004*                                                                         
ACT004     MOVE MN-CODE-UTIL-TYPE            TO EQ-CODE-UTIL-TYPE.      
ACT004     MOVE MN-METER-NO                  TO EQ-DEVICE-NO.           
ACT004     MOVE AT-COMPANY-NO                TO EQ-COMPANY-NO.          
ACT004     PERFORM 7300-GET-EQ-DETAILS       THRU 7300-EXIT.            
ACT004     MOVE EQ-PALETTE-NO                TO S-PALETTE-NO.           
                                                                        
ACT004* 'SS007' - Blocked by Meter Inventory                                    
ACT004     IF EQ-PALETTE-NO = WS-Y                                      
ACT004        MOVE WS-SS007                  TO S-APPL-STATUS-CODE      
ACT004        MOVE WS-Y                      TO S-BLOCK-OUTAGE          
ACT004        MOVE WS-SS007-RSN              TO S-BLOCK-REASON          
ACT004        PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
ACT004        GO TO 2000-EXIT                                           
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004     MOVE WS-N                         TO S-BLOCK-OUTAGE.         
ACT004     MOVE SPACES                       TO S-BLOCK-REASON          
ACT004                                          S-APPL-STATUS-CODE.     
ACT004*                                                                         
ACT004* If a communication record already exists for the current date           
ACT004* Update the Last TimeStamp on that record otherwise create a             
ACT004* new record for the meter.                                               
ACT004*                                                                         
ACT004     PERFORM 7510-OPEN-COMM-REC        THRU 7510-EXIT.            
ACT004*                                                                         
ACT004     PERFORM 7520-FETCH-COMM-REC       THRU 7520-EXIT.            
ACT004*                                                                         
ACT004     PERFORM 2200-CHECK-COMM-DATA      THRU 2200-EXIT             
ACT004       UNTIL WS-NO-MORE-COMM-DATA                                 
ACT004          OR MN-METER-NO = WS-TEMP-METER-NO.                      
ACT004*                                                                         
ACT004     IF MN-METER-NO = WS-TEMP-METER-NO                            
ACT004        PERFORM 8100-UPDATE-COMM-DET   THRU 8100-EXIT             
ACT004     ELSE                                                         
ACT004        PERFORM 2100-PROCESS-COMM-DET  THRU 2100-EXIT             
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004     PERFORM 7530-CLOSE-COMM-REC       THRU 7530-EXIT.            
ACT004*                                                                         
           PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2000A-MOVE-RESULT                                             *         
      *****************************************************************         
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
             ADD 1                           TO CTR-ROWS.               
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
ACT004*****************************************************************         
ACT004* 2200-CHECK-COMM-DATA                                          *         
ACT004*****************************************************************         
ACT004*                                                                         
ACT004 2200-CHECK-COMM-DATA.                                            
ACT004*                                                                         
ACT004     MOVE SPACES                     TO WS-TEMP-METER-NO.         
ACT004     MOVE KO-INITIAL-COMMENT-TX-TEXT(51:9)                        
ACT004                                     TO WS-TEMP-METER-NO.         
ACT004     PERFORM 7520-FETCH-COMM-REC       THRU 7520-EXIT.            
ACT004*                                                                         
ACT004 2200-EXIT.                                                       
ACT004     EXIT.                                                        
ACT004*                                                                         
      *****************************************************************         
      * 2100-PROCESS-COMM-DET.                                        *         
      *****************************************************************         
      *                                                                         
       2100-PROCESS-COMM-DET.                                           
      *                                                                         
           MOVE AT-ACCOUNT-NO              TO KO-ACCOUNT-NO.            
           MOVE AT-PREMISE-NO              TO KO-PREMISE-NO.            
           MOVE AT-CUSTOMER-NO             TO KO-CUSTOMER-NO.           
           MOVE AT-COMPANY-NO              TO KO-COMPANY-NO.            
           MOVE 'A'                        TO KO-COMM-METHOD.           
           MOVE 'I'                        TO KO-COMM-DIRECTION.        
           MOVE '41'                       TO KO-COMM-TYPE-CD.          
           MOVE '05'                       TO KO-COMM-SUBTYPE-CODE.     
ACT004     MOVE 'CSR4472'                  TO KO-USER-ID-ORIG.          
ACT004     MOVE MN-METER-NO                TO WS-COMM-MTR-NO.           
           MOVE WS-COMM-LEN                TO KO-INITIAL-COMMENT-TX-LEN 
           MOVE WS-COMM-TEXT               TO KO-INITIAL-COMMENT-TX-TEXT
           MOVE 'N'                        TO KO-RED-FLAG-IND.          
           MOVE SPACES                     TO KO-RED-FLAG-EXPIRE-DT.    
           MOVE -1                         TO WS-RED-FL-NULL-IND.       
           MOVE SPACES                     TO KO-PROMOTION-ID.          
           MOVE 'N'                        TO KO-PSC-COMPLIANCE-IND.    
           MOVE 0                          TO KO-CALL-ORIGIN-ID.        
           MOVE SPACES                     TO KO-CALL-END-TIME.         
           MOVE -1                         TO WS-END-NULL-IND.          
           MOVE 0                          TO KO-NUMBER-TRANSFERS.      
           MOVE 0                          TO KO-HOLD-TIME.             
           MOVE 0                          TO KO-QUEUE-TIME.            
           MOVE 'N'                        TO KO-SCREEN-POP-IND.        
           MOVE 0                          TO KO-TOTAL-CALL-TIME.       
           MOVE SPACES                     TO KO-RESPONSE-REASON-CD.    
           MOVE SPACES                     TO KO-RESPONSE-TYPE-CD.      
           MOVE SPACES                     TO KO-SOLICITATION-CD.       
           MOVE 'A'                        TO KO-COMM-ASSOC-CD.         
           MOVE 'N'                        TO KO-COMPLAINT-FL.          
           MOVE SPACES                     TO KO-DISCOVERY-MTHD-CD.     
           MOVE SPACES                     TO KO-PREV-MARKETER-CD.      
      *                                                                         
           MOVE AT-CUSTOMER-NO             TO CE-CUSTOMER-NO.           
           PERFORM 7010-GET-CUST-DETAILS   THRU 7010-EXIT.              
           IF DQ-FULL-NAME > SPACES                                     
              MOVE DQ-FULL-NAME            TO WS-EMB-INPUT              
           ELSE                                                         
              STRING DQ-LAST-NAME,                                      
                     ', ',                                              
                     DQ-FIRST-NAME,                                     
                     ' ',                                               
                     DQ-MIDDLE-NAME                                     
              DELIMITED BY SIZE INTO WS-EMB-INPUT                       
           END-IF.                                                      
           MOVE 70                         TO WS-EMB-LENG.              
      *                                                                         
           PERFORM 6010-REDUCE-EMBEDDED-SPACES                          
                                           THRU 6010-EXIT.              
           MOVE WS-CMP-TABLE               TO WS-TEMP-CONTACT-NAME.     
           MOVE WS-TEMP-CONTACT-NAME       TO KO-CONTACT-NAME.          
      *                                                                         
           PERFORM 8000-INSERT-COMM-DATA   THRU 8000-EXIT.              
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6010-REDUCE-EMBEDDED-SPACES.                                   *        
      ******************************************************************        
      *                                                                         
       COPY CPD00004.                                                           
      *                                                                         
      ******************************************************************        
      * SELECTS CUTOMER NAME.                                          *        
      ******************************************************************        
      *                                                                         
       7010-GET-CUST-DETAILS.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) DQ.FIRST_NAME,
              DQ.MIDDLE_NAME,
              DQ.LAST_NAME,
              DQ.FULL_NAME                                     
                  INTO :DQ-FIRST-NAME                                   
                      ,:DQ-MIDDLE-NAME                                  
                      ,:DQ-LAST-NAME                                    
                      ,:DQ-FULL-NAME                                    
                  FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED),                 
                       CSS_NAME DQ WITH(READUNCOMMITTED),                       
                       CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
                 WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO               
                   AND CE.CUSTOMER_TYPE = 'C'                           
                   AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                
                   AND CE.NAME_ID       = HT.NAME_ID                    
                   AND HT.NAME_ID       = DQ.NAME_ID                    
                                                 
                                                                 
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DQ.FIRST_NAME                                            
MFA-TR*               ,DQ.MIDDLE_NAME                                           
MFA-TR*               ,DQ.LAST_NAME                                             
MFA-TR*               ,DQ.FULL_NAME                                             
MFA-TR*           INTO :DQ-FIRST-NAME                                           
MFA-TR*               ,:DQ-MIDDLE-NAME                                          
MFA-TR*               ,:DQ-LAST-NAME                                            
MFA-TR*               ,:DQ-FULL-NAME                                            
MFA-TR*           FROM CSS_CUST_STATS CE,                                       
MFA-TR*                CSS_NAME DQ,                                             
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*          WHERE CE.CUSTOMER_NO   = :CE-CUSTOMER-NO                       
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*            AND CE.CUSTOMER_NO   = HT.CUSTOMER_NO                        
MFA-TR*            AND CE.NAME_ID       = HT.NAME_ID                            
MFA-TR*            AND HT.NAME_ID       = DQ.NAME_ID                            
MFA-TR*            FETCH FIRST 1 ROWS ONLY                                      
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CUST_STATS'          TO TABLE-1                 
              MOVE 'CSS_NAME'                TO TABLE-2                 
              MOVE 'CSS_NAME_ACCT_XREF'      TO TABLE-3                 
              MOVE 'CUSTOMER-NO'             TO TABLE-ELEMENT-1         
              MOVE CE-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7100-SEL-ACCT-MTR-DET                                         *         
      *****************************************************************         
      *                                                                         
       7100-SEL-ACCT-MTR-DET.                                           
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                      AT.PREMISE_NO                                     
                     ,AT.CUSTOMER_NO                                    
                     ,AT.COMPANY_NO                                     
                     ,AT.CODE_ACCT_STAT                                 
                     ,MN.CODE_METER_STATUS                              
                     ,MN.CODE_UTIL_TYPE                                 
A#5347               ,MN.MTR_READ_SOURCE_CD                             
A#5347               ,MN.UTILITY_SOURCE_CD                              
A#5347               ,MN.METER_SUPPLYING                                
ACT004               ,UT.RATE_PLAN_NO                                   
                  INTO                                                  
                      :AT-PREMISE-NO                                    
                     ,:AT-CUSTOMER-NO                                   
                     ,:AT-COMPANY-NO                                    
                     ,:AT-CODE-ACCT-STAT                                
                     ,:MN-CODE-METER-STATUS                             
                     ,:MN-CODE-UTIL-TYPE                                
A#5347               ,:MN-MTR-READ-SOURCE-CD                            
A#5347               ,:MN-UTILITY-SOURCE-CD                             
A#5347               ,:MN-METER-SUPPLYING                               
ACT004               ,:UT-RATE-PLAN-NO                                  
                 FROM                                                   
                      CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                 
                     ,CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
ACT004               ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
                WHERE                                                   
                      AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                  AND MN.ACCOUNT_NO =  AT.ACCOUNT_NO                    
                  AND MN.METER_NO   = :MN-METER-NO                      
ACT004            AND UT.ACCOUNT_NO     = MN.ACCOUNT_NO                 
ACT004            AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE             
ACT004            AND MN.IC_NO          = UT.IC_NO                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*               AT.PREMISE_NO                                             
MFA-TR*              ,AT.CUSTOMER_NO                                            
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*              ,AT.CODE_ACCT_STAT                                         
MFA-TR*              ,MN.CODE_METER_STATUS                                      
MFA-TR*              ,MN.CODE_UTIL_TYPE                                         
MFA-TR*              ,MN.MTR_READ_SOURCE_CD                                     
MFA-TR*              ,MN.UTILITY_SOURCE_CD                                      
MFA-TR*              ,MN.METER_SUPPLYING                                        
MFA-TR*              ,UT.RATE_PLAN_NO                                           
MFA-TR*           INTO                                                          
MFA-TR*               :AT-PREMISE-NO                                            
MFA-TR*              ,:AT-CUSTOMER-NO                                           
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:AT-CODE-ACCT-STAT                                        
MFA-TR*              ,:MN-CODE-METER-STATUS                                     
MFA-TR*              ,:MN-CODE-UTIL-TYPE                                        
MFA-TR*              ,:MN-MTR-READ-SOURCE-CD                                    
MFA-TR*              ,:MN-UTILITY-SOURCE-CD                                     
MFA-TR*              ,:MN-METER-SUPPLYING                                       
MFA-TR*              ,:UT-RATE-PLAN-NO                                          
MFA-TR*          FROM                                                           
MFA-TR*               CSS_ACCOUNT      AT                                       
MFA-TR*              ,CSS_MTRD_ENVRNMT MN                                       
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE                                                           
MFA-TR*               AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*           AND MN.ACCOUNT_NO =  AT.ACCOUNT_NO                            
MFA-TR*           AND MN.METER_NO   = :MN-METER-NO                              
MFA-TR*           AND UT.ACCOUNT_NO     = MN.ACCOUNT_NO                         
MFA-TR*           AND MN.CODE_UTIL_TYPE = UT.CODE_UTIL_TYPE                     
MFA-TR*           AND MN.IC_NO          = UT.IC_NO                              
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'CSS_MTRD_ENVRNMT'        TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'METER_NO'                TO TABLE-ELEMENT-2         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE MN-METER-NO               TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7200-SEL-SO-DETAILS.                                          *         
      *****************************************************************         
      *                                                                         
       7200-SEL-SO-DETAILS.                                             
      *                                                                         
           EXEC SQL                                                     
                SELECT TOP(1) VO.SERV_ORDER_NO,
              L4.WORK_TYPE_DESC,
              VO.ORDER_STATE_CD                                 
                  INTO                                                  
                      :VO-SERV-ORDER-NO                                 
                     ,:L4-WORK-TYPE-DESC                                
ACT004               ,:VO-ORDER-STATE-CD                                
                 FROM                                                   
                      CSS_SO_DATA       VO WITH(READUNCOMMITTED)                
                     ,CSS_SO_ORDER_INST VI WITH(READUNCOMMITTED)                
                     ,CSS_WORK_TYPE     L4 WITH(READUNCOMMITTED)                
                WHERE                                                   
                      VO.PREMISE_NO        =  :VO-PREMISE-NO            
                  AND VI.SERV_ORDER_NO     =  VO.SERV_ORDER_NO          
ACT004            AND VO.ORDER_STATE_CD IN ('A','B','D','H')            
                  AND VI.CODE_UTIL_TYPE    =  :VI-CODE-UTIL-TYPE        
                  AND L4.COMPANY_NO        =  VO.COMPANY_NO             
                  AND L4.WORK_TYPE_CD      =  VI.WORK_TYPE_CD           
                  AND VI.WORK_TYPE_CD IN                                
                      (                                                 
                       SELECT UV.CODE_VALUE                             
                         FROM CSS_CODE_VALUE UV WITH(READUNCOMMITTED)           
                        WHERE UV.COLUMN_NA  = 'WORK_TYPE_CD'            
                          AND UV.COMPANY_NO = VO.COMPANY_NO             
                          AND UV.PROGRAM_ID = 'CSR04472'                
                          AND UV.TABLE_NA   = 'CSS_WORK_TYPE'           
                      )                                                 
                ORDER BY VO.ASSIGNED_DATETIME DESC                      
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*               VO.SERV_ORDER_NO                                          
MFA-TR*              ,L4.WORK_TYPE_DESC                                         
MFA-TR*              ,VO.ORDER_STATE_CD                                         
MFA-TR*           INTO                                                          
MFA-TR*               :VO-SERV-ORDER-NO                                         
MFA-TR*              ,:L4-WORK-TYPE-DESC                                        
MFA-TR*              ,:VO-ORDER-STATE-CD                                        
MFA-TR*          FROM                                                           
MFA-TR*               CSS_SO_DATA       VO                                      
MFA-TR*              ,CSS_SO_ORDER_INST VI                                      
MFA-TR*              ,CSS_WORK_TYPE     L4                                      
MFA-TR*         WHERE                                                           
MFA-TR*               VO.PREMISE_NO        =  :VO-PREMISE-NO                    
MFA-TR*           AND VI.SERV_ORDER_NO     =  VO.SERV_ORDER_NO                  
MFA-TR*           AND VO.ORDER_STATE_CD IN ('A','B','D','H')                    
MFA-TR*           AND VI.CODE_UTIL_TYPE    =  :VI-CODE-UTIL-TYPE                
MFA-TR*           AND L4.COMPANY_NO        =  VO.COMPANY_NO                     
MFA-TR*           AND L4.WORK_TYPE_CD      =  VI.WORK_TYPE_CD                   
MFA-TR*           AND VI.WORK_TYPE_CD IN                                        
MFA-TR*               (                                                         
MFA-TR*                SELECT UV.CODE_VALUE                                     
MFA-TR*                  FROM CSS_CODE_VALUE UV                                 
MFA-TR*                 WHERE UV.COLUMN_NA  = 'WORK_TYPE_CD'                    
MFA-TR*                   AND UV.COMPANY_NO = VO.COMPANY_NO                     
MFA-TR*                   AND UV.PROGRAM_ID = 'CSR04472'                        
MFA-TR*                   AND UV.TABLE_NA   = 'CSS_WORK_TYPE'                   
MFA-TR*               )                                                         
MFA-TR*         ORDER BY VO.ASSIGNED_DATETIME DESC                              
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO S-RETURN-CODE           
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SO_DATA'             TO TABLE-1                 
              MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1         
              MOVE 'METER_NO'                TO TABLE-ELEMENT-2         
              MOVE VO-PREMISE-NO             TO HOSTVAR-ELEMENT-1       
              MOVE VI-METER-NO               TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
ACT004*****************************************************************         
ACT004* 7300-GET-EQ-DETAILS.                                          *         
ACT004*****************************************************************         
ACT004*                                                                         
ACT004 7300-GET-EQ-DETAILS.                                             
ACT004*                                                                         
ACT004     EXEC SQL                                                     
ACT004          SELECT EQ.PALETTE_NO                                    
ACT004            INTO :EQ-PALETTE-NO                                   
ACT004            FROM CSS_EQUIPMENT EQ WITH(READUNCOMMITTED)                   
ACT004           WHERE EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE           
ACT004             AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                
ACT004             AND EQ.COMPANY_NO     = :EQ-COMPANY-NO               
ACT004                                                           
ACT004                                                      
ACT004     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT EQ.PALETTE_NO                                            
MFA-TR*           INTO :EQ-PALETTE-NO                                           
MFA-TR*           FROM CSS_EQUIPMENT EQ                                         
MFA-TR*          WHERE EQ.CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE                   
MFA-TR*            AND EQ.DEVICE_NO      = :EQ-DEVICE-NO                        
MFA-TR*            AND EQ.COMPANY_NO     = :EQ-COMPANY-NO                       
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004*                                                                         
ACT004     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT004*                                                                         
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT004        NEXT SENTENCE                                             
ACT004     ELSE                                                         
ACT004        MOVE SQLCODE                   TO S-RETURN-CODE           
ACT004        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT004        MOVE '7300'                    TO ACTIVE-PARAGRAPH        
ACT004        MOVE 'SELECT'                  TO ABEND-FUNCTION          
ACT004        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT004                                          ABEND-TABLES            
ACT004        MOVE 'CSS_EQUIPMENT'           TO TABLE-1                 
ACT004        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
ACT004        MOVE 'DEVICE_NO'               TO TABLE-ELEMENT-2         
ACT004        MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
ACT004        MOVE EQ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
ACT004        MOVE EQ-DEVICE-NO              TO HOSTVAR-ELEMENT-2       
ACT004        MOVE EQ-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
ACT004        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004 7300-EXIT.                                                       
ACT004     EXIT.                                                        
ACT004*                                                                         
ACT004*****************************************************************         
ACT004* 7400-GET-RATE-SUB-GRP-TYP.                                    *         
ACT004*****************************************************************         
ACT004*                                                                         
ACT004 7400-GET-RATE-SUB-GRP-TYP.                                       
ACT004*                                                                         
ACT004     EXEC SQL                                                     
ACT004          SELECT RD.RATE_SUB_GRP_TYPE                             
ACT004            INTO :RD-RATE-SUB-GRP-TYPE                            
ACT004            FROM CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)              
ACT004           WHERE RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE           
ACT004             AND RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO             
ACT004                                                           
ACT004                                                      
ACT004     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RD.RATE_SUB_GRP_TYPE                                     
MFA-TR*           INTO :RD-RATE-SUB-GRP-TYPE                                    
MFA-TR*           FROM CSS_RATE_PLAN_DESC RD                                    
MFA-TR*          WHERE RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                   
MFA-TR*            AND RD.RATE_PLAN_NO   = :RD-RATE-PLAN-NO                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004*                                                                         
ACT004     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT004*                                                                         
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT004        NEXT SENTENCE                                             
ACT004     ELSE                                                         
ACT004        MOVE SQLCODE                   TO S-RETURN-CODE           
ACT004        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT004        MOVE '7400'                    TO ACTIVE-PARAGRAPH        
ACT004        MOVE 'SELECT'                  TO ABEND-FUNCTION          
ACT004        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT004                                          ABEND-TABLES            
ACT004        MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
ACT004        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
ACT004        MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
ACT004        MOVE RD-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
ACT004        MOVE RD-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
ACT004        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004 7400-EXIT.                                                       
ACT004     EXIT.                                                        
ACT004*                                                                         
ACT004*================================================================*        
ACT004 7510-OPEN-COMM-REC.                                              
ACT004*================================================================*        
ACT004*                                                                         
ACT004     EXEC SQL                                                     
ACT004         OPEN COMM_REC                                            
ACT004     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004*                                                                         
ACT004     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT004*                                                                         
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT004        NEXT SENTENCE                                             
ACT004     ELSE                                                         
ACT004        MOVE SQLCODE                   TO S-RETURN-CODE           
ACT004        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT004        MOVE '7510'                    TO ACTIVE-PARAGRAPH        
ACT004        MOVE 'OPEN'                    TO ABEND-FUNCTION          
ACT004        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT004                                          ABEND-TABLES            
ACT004        MOVE 'CSS_COMM_DATA'           TO TABLE-1                 
ACT004        MOVE 'ACCOUNT_NO  : '          TO TABLE-ELEMENT-1         
ACT004        MOVE 'PREMISE_NO  : '          TO TABLE-ELEMENT-2         
ACT004        MOVE 'CUSTOMER_NO : '          TO TABLE-ELEMENT-3         
ACT004        MOVE 'COMPANY_NO  : '          TO TABLE-ELEMENT-4         
ACT004        MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT004        MOVE AT-PREMISE-NO             TO HOSTVAR-ELEMENT-2       
ACT004        MOVE AT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-3       
ACT004        MOVE AT-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
ACT004        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004 7510-EXIT.                                                       
ACT004     EXIT.                                                        
ACT004*                                                                         
ACT004*================================================================*        
ACT004 7520-FETCH-COMM-REC.                                             
ACT004*================================================================*        
ACT004*                                                                         
ACT004     EXEC SQL                                                     
ACT004         FETCH COMM_REC                                           
ACT004          INTO :KO-COMMUNICATION-ID                               
ACT004              ,:KO-INITIAL-COMMENT-TX                             
ACT004     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004*                                                                         
ACT004     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT004*                                                                         
ACT004     EVALUATE WS-ACTIVE-RETURN-CODE                               
ACT004        WHEN SUCCESSFUL-CALL                                      
ACT004          CONTINUE                                                
ACT004        WHEN NOT-FOUND                                            
ACT004          SET WS-NO-MORE-COMM-DATA TO TRUE                        
ACT004        WHEN OTHER                                                
ACT004          MOVE SQLCODE                 TO S-RETURN-CODE           
ACT004          MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
ACT004          MOVE '7520'                  TO ACTIVE-PARAGRAPH        
ACT004          MOVE 'FETCH'                 TO ABEND-FUNCTION          
ACT004          MOVE SPACES                  TO ABEND-SQL-PREDICATES    
ACT004                                          ABEND-TABLES            
ACT004          MOVE 'CSS_COMM_DATA'         TO TABLE-1                 
ACT004          MOVE 'ACCOUNT_NO  : '        TO TABLE-ELEMENT-1         
ACT004          MOVE 'PREMISE_NO  : '        TO TABLE-ELEMENT-2         
ACT004          MOVE 'CUSTOMER_NO : '        TO TABLE-ELEMENT-3         
ACT004          MOVE 'COMPANY_NO  : '        TO TABLE-ELEMENT-4         
ACT004          MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
ACT004          MOVE AT-PREMISE-NO           TO HOSTVAR-ELEMENT-2       
ACT004          MOVE AT-CUSTOMER-NO          TO HOSTVAR-ELEMENT-3       
ACT004          MOVE AT-COMPANY-NO           TO HOSTVAR-ELEMENT-4       
ACT004          PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT             
ACT004     END-EVALUATE.                                                
ACT004*                                                                         
ACT004 7520-EXIT.                                                       
ACT004     EXIT.                                                        
ACT004*                                                                         
ACT004*================================================================*        
ACT004 7530-CLOSE-COMM-REC.                                             
ACT004*================================================================*        
ACT004*                                                                         
ACT004     EXEC SQL                                                     
ACT004         CLOSE COMM_REC                                           
ACT004     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004*                                                                         
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT004        NEXT SENTENCE                                             
ACT004     ELSE                                                         
ACT004        MOVE SQLCODE                   TO S-RETURN-CODE           
ACT004        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT004        MOVE '7530'                    TO ACTIVE-PARAGRAPH        
ACT004        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
ACT004        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
ACT004                                          ABEND-TABLES            
ACT004        MOVE 'CSS_COMM_DATA'           TO TABLE-1                 
ACT004        MOVE 'ACCOUNT_NO  : '          TO TABLE-ELEMENT-1         
ACT004        MOVE 'PREMISE_NO  : '          TO TABLE-ELEMENT-2         
ACT004        MOVE 'CUSTOMER_NO : '          TO TABLE-ELEMENT-3         
ACT004        MOVE 'COMPANY_NO  : '          TO TABLE-ELEMENT-4         
ACT004        MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT004        MOVE AT-PREMISE-NO             TO HOSTVAR-ELEMENT-2       
ACT004        MOVE AT-CUSTOMER-NO            TO HOSTVAR-ELEMENT-3       
ACT004        MOVE AT-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
ACT004        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004 7530-EXIT.                                                       
ACT004     EXIT.                                                        
ACT004*                                                                         
      ******************************************************************        
      * 8000-INSERT-COMM-DATA.                                         *        
      ******************************************************************        
      *                                                                         
       8000-INSERT-COMM-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (                                               
                         COMMUNICATION_ID                               
                        ,ACCOUNT_NO                                     
                        ,CUSTOMER_NO                                    
                        ,PREMISE_NO                                     
                        ,COMPANY_NO                                     
                        ,RED_FLAG_IND                                   
                        ,RED_FLAG_EXPIRE_DT                             
                        ,COMM_METHOD                                    
                        ,COMM_DIRECTION                                 
                        ,COMM_TYPE_CD                                   
                        ,COMM_SUBTYPE_CODE                              
                        ,USER_ID_ORIG                                   
                        ,CONTACT_NAME                                   
                        ,PROMOTION_ID                                   
                        ,PSC_COMPLIANCE_IND                             
                        ,CALL_ORIGIN_ID                                 
                        ,CALL_END_TIME                                  
                        ,NUMBER_TRANSFERS                               
                        ,HOLD_TIME                                      
                        ,QUEUE_TIME                                     
                        ,SCREEN_POP_IND                                 
                        ,TOTAL_CALL_TIME                                
                        ,INITIAL_COMMENT_TX                             
                        ,RESPONSE_REASON_CD                             
                        ,RESPONSE_TYPE_CD                               
                        ,SOLICITATION_CD                                
                        ,COMM_ASSOC_CD                                  
                        ,COMPLAINT_FL                                   
                        ,DISCOVERY_MTHD_CD                              
                        ,PREV_MARKETER_CD                               
                       )                                                
                VALUES                                                  
                       (                                                
                          CIS.CURRENT$TIMESTAMP()                             
                        ,:KO-ACCOUNT-NO                                 
                        ,:KO-CUSTOMER-NO                                
                        ,:KO-PREMISE-NO                                 
                        ,:KO-COMPANY-NO                                 
                        ,:KO-RED-FLAG-IND                               
                        ,CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND)      
                        ,:KO-COMM-METHOD                                
                        ,:KO-COMM-DIRECTION                             
                        ,:KO-COMM-TYPE-CD                               
                        ,:KO-COMM-SUBTYPE-CODE                          
                        ,:KO-USER-ID-ORIG                               
                        ,:KO-CONTACT-NAME                               
                        ,:KO-PROMOTION-ID                               
                        ,:KO-PSC-COMPLIANCE-IND                         
                        ,:KO-CALL-ORIGIN-ID                             
                        ,CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND)              
                        ,:KO-NUMBER-TRANSFERS                           
                        ,:KO-HOLD-TIME                                  
                        ,:KO-QUEUE-TIME                                 
                        ,:KO-SCREEN-POP-IND                             
                        ,:KO-TOTAL-CALL-TIME                            
                        ,:KO-INITIAL-COMMENT-TX                         
                        ,:KO-RESPONSE-REASON-CD                         
                        ,:KO-RESPONSE-TYPE-CD                           
                        ,:KO-SOLICITATION-CD                            
                        ,:KO-COMM-ASSOC-CD                              
                        ,:KO-COMPLAINT-FL                               
                        ,:KO-DISCOVERY-MTHD-CD                          
                        ,:KO-PREV-MARKETER-CD                           
                       )                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (                                                       
MFA-TR*                  COMMUNICATION_ID                                       
MFA-TR*                 ,ACCOUNT_NO                                             
MFA-TR*                 ,CUSTOMER_NO                                            
MFA-TR*                 ,PREMISE_NO                                             
MFA-TR*                 ,COMPANY_NO                                             
MFA-TR*                 ,RED_FLAG_IND                                           
MFA-TR*                 ,RED_FLAG_EXPIRE_DT                                     
MFA-TR*                 ,COMM_METHOD                                            
MFA-TR*                 ,COMM_DIRECTION                                         
MFA-TR*                 ,COMM_TYPE_CD                                           
MFA-TR*                 ,COMM_SUBTYPE_CODE                                      
MFA-TR*                 ,USER_ID_ORIG                                           
MFA-TR*                 ,CONTACT_NAME                                           
MFA-TR*                 ,PROMOTION_ID                                           
MFA-TR*                 ,PSC_COMPLIANCE_IND                                     
MFA-TR*                 ,CALL_ORIGIN_ID                                         
MFA-TR*                 ,CALL_END_TIME                                          
MFA-TR*                 ,NUMBER_TRANSFERS                                       
MFA-TR*                 ,HOLD_TIME                                              
MFA-TR*                 ,QUEUE_TIME                                             
MFA-TR*                 ,SCREEN_POP_IND                                         
MFA-TR*                 ,TOTAL_CALL_TIME                                        
MFA-TR*                 ,INITIAL_COMMENT_TX                                     
MFA-TR*                 ,RESPONSE_REASON_CD                                     
MFA-TR*                 ,RESPONSE_TYPE_CD                                       
MFA-TR*                 ,SOLICITATION_CD                                        
MFA-TR*                 ,COMM_ASSOC_CD                                          
MFA-TR*                 ,COMPLAINT_FL                                           
MFA-TR*                 ,DISCOVERY_MTHD_CD                                      
MFA-TR*                 ,PREV_MARKETER_CD                                       
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                   CURRENT TIMESTAMP                                     
MFA-TR*                 ,:KO-ACCOUNT-NO                                         
MFA-TR*                 ,:KO-CUSTOMER-NO                                        
MFA-TR*                 ,:KO-PREMISE-NO                                         
MFA-TR*                 ,:KO-COMPANY-NO                                         
MFA-TR*                 ,:KO-RED-FLAG-IND                                       
MFA-TR*                 ,:KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND              
MFA-TR*                 ,:KO-COMM-METHOD                                        
MFA-TR*                 ,:KO-COMM-DIRECTION                                     
MFA-TR*                 ,:KO-COMM-TYPE-CD                                       
MFA-TR*                 ,:KO-COMM-SUBTYPE-CODE                                  
MFA-TR*                 ,:KO-USER-ID-ORIG                                       
MFA-TR*                 ,:KO-CONTACT-NAME                                       
MFA-TR*                 ,:KO-PROMOTION-ID                                       
MFA-TR*                 ,:KO-PSC-COMPLIANCE-IND                                 
MFA-TR*                 ,:KO-CALL-ORIGIN-ID                                     
MFA-TR*                 ,:KO-CALL-END-TIME:WS-END-NULL-IND                      
MFA-TR*                 ,:KO-NUMBER-TRANSFERS                                   
MFA-TR*                 ,:KO-HOLD-TIME                                          
MFA-TR*                 ,:KO-QUEUE-TIME                                         
MFA-TR*                 ,:KO-SCREEN-POP-IND                                     
MFA-TR*                 ,:KO-TOTAL-CALL-TIME                                    
MFA-TR*                 ,:KO-INITIAL-COMMENT-TX                                 
MFA-TR*                 ,:KO-RESPONSE-REASON-CD                                 
MFA-TR*                 ,:KO-RESPONSE-TYPE-CD                                   
MFA-TR*                 ,:KO-SOLICITATION-CD                                    
MFA-TR*                 ,:KO-COMM-ASSOC-CD                                      
MFA-TR*                 ,:KO-COMPLAINT-FL                                       
MFA-TR*                 ,:KO-DISCOVERY-MTHD-CD                                  
MFA-TR*                 ,:KO-PREV-MARKETER-CD                                   
MFA-TR*                )                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SQLCODE                   TO S-RETURN-CODE           
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8000'                   TO  ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
                                                S-RETURN-CODE           
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_COMM_DATA'          TO  TABLE-1                 
              MOVE 'ACCOUNT_NO'             TO  TABLE-ELEMENT-1         
              MOVE 'PREMISE_NO'             TO  TABLE-ELEMENT-2         
              MOVE 'CUSTOMER_NO'            TO  TABLE-ELEMENT-3         
              MOVE AT-ACCOUNT-NO            TO  HOSTVAR-ELEMENT-1       
              MOVE AT-PREMISE-NO            TO  HOSTVAR-ELEMENT-2       
              MOVE AT-CUSTOMER-NO           TO  HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
ACT004******************************************************************        
ACT004* 8100-UPDATE-COMM-DET.                                          *        
ACT004******************************************************************        
ACT004*                                                                         
ACT004 8100-UPDATE-COMM-DET.                                            
ACT004*                                                                         
ACT004     EXEC SQL                                                     
ACT004         UPDATE CSS_COMM_DATA                                     
ACT004            SET LAST_UPDATE_TS   = CIS.CURRENT$TIMESTAMP()              
ACT004          WHERE COMMUNICATION_ID = CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )           
ACT004     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COMM_DATA                                             
MFA-TR*           SET LAST_UPDATE_TS   = CURRENT TIMESTAMP                      
MFA-TR*         WHERE COMMUNICATION_ID = :KO-COMMUNICATION-ID                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT004*                                                                         
ACT004     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ACT004*                                                                         
ACT004     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT004        NEXT SENTENCE                                             
ACT004     ELSE                                                         
ACT004        MOVE SQLCODE                  TO S-RETURN-CODE            
ACT004        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
ACT004        MOVE '8100'                   TO ACTIVE-PARAGRAPH         
ACT004        MOVE 'UPDATE'                 TO ABEND-FUNCTION           
ACT004        MOVE SQLCODE                  TO ABEND-SQLCODE            
ACT004                                         S-RETURN-CODE            
ACT004        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
ACT004                                         ABEND-TABLES             
ACT004        MOVE 'CSS_COMM_DATA'          TO TABLE-1                  
ACT004        MOVE 'ACCOUNT_NO  : '         TO TABLE-ELEMENT-1          
ACT004        MOVE 'COMMUNICATION_ID'       TO TABLE-ELEMENT-2          
ACT004        MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
ACT004        MOVE KO-COMMUNICATION-ID      TO HOSTVAR-ELEMENT-2        
ACT004        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
ACT004     END-IF.                                                      
ACT004*                                                                         
ACT004 8100-EXIT.                                                       
ACT004      EXIT.                                                       
      *                                                                         
      *****************************************************************         
      *   9700-PROCESS-ABENDG / ABEND PROCESSING                      *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *       9900 - JOURNALING / ERROR HANDLING ROUTINE              *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *       END PROGRAM COPYLIB                                     *         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
