       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04467.                                          
       AUTHOR.       SB93596                                            
COB303 DATE-WRITTEN. MAY 2011.                                          
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04467              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04467 :                                                --         
      *--                                                            --         
      *--  #  INVOKED FROM BASELINE PANEL SCREENS                    --         
      *--  #  UPDATE  FOR CSS_BILL_BSLN_CNTR                          --        
      *----------------------------------------------------------------         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--            I_ACCOUNT_NO      CHAR(13)                      --         
      *--            I_CODE_UTIL_TYPE  CHAR(01)                      --         
      *--            I_IC_NO           SMALLINT                      --         
      *--            I_CNTRCT_START_DT CHAR(10)                      --         
      *--            I_TRANS_CMNT_TEXT CHAR(210)                     --         
      *--            I_TRANS_CMNT_LEN  SMALLINT                      --         
      *--            I_UPDATE_DATA     VARCHAR(2000)                 --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--            RETURN_CODE           INTEGER                   --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    -----------------------------   --         
P00496*--  05/01/2011    SB93596     PROGRAM INTIALLY WRITTEN TO     --         
P00496*--                            UPDATE  ON BASELINE PANEL.      --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04467'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_BILL_BSLN_CNTR  LN                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLCNTB                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_MT_TRN_HST_DET. MI                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_MNT_TRANS_HIST. MH                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
      *    COPY CCA00001.                                                       
      ******************************************************************        
      *                                                                         
       01  WS-TRAN-COMMENT-TEXT            PIC X(24).                   
       01  WS-MISC.                                                     
           05 WS-HOLD-BASELINE-VAL         PIC S999999999V9.            
                                                                        
           05 WS-BASELINE-VAL-Z            PIC ---------.9(1).          
                                                                        
           05 WS-MONTH-DESC                PIC X(03) VALUE SPACES.      
           05 WS-MONTH-NO                  PIC X(02) VALUE SPACES.      
                                                                        
COB305     05 WS-BASELINE-UNITS-PRV        PIC S9(9)V9(1) USAGE COMP-3 
COB305       VALUE 0. 
                                                                        
           05 WS-CODE-TIME-PERIOD          PIC X(4).                    
                                                                        
           05 WS-CURRENT-TS                PIC X(26).                   
                                                                        
       01 WS-BASELINE-UNITS-CHAR            PIC X(10).                  
       01 WS-BASELINE-UNITS-NUM REDEFINES WS-BASELINE-UNITS-CHAR        
                                            PIC S9(09)V9.               
      ****************************************************************          
      *    CSS_BILL_BSLN_CNTR  - LN                                  *          
      ****************************************************************          
       01  WS-CSS-DATA-LAYOUT.                                          
COB305     05 WS-ACCOUNT-NO-LN        PIC S9(13)V USAGE COMP-3 VALUE 0.   
           05 WS-CODE-UTIL-TYPE-LN          PIC X(01).                  
           05 WS-IC-NO-LN                   PIC S9(04)  USAGE COMP.     
           05 WS-CNTRCT-START-DT-LN         PIC X(10).                  
           05 WS-UPDATE-DATA.                                           
              10 WS-UPDATE-DATA-TEXT                                    
                    OCCURS 100 TIMES INDEXED BY WS-UPD-INDX.            
                 15 WS-BASELINE-MONTH-LN    PIC X(2).                   
                 15 WS-CMPNT-ID-CD-LN       PIC X(2).                   
                 15 WS-INSTR-USE-TYPE-CD-LN PIC X(1).                   
                 15 WS-CODE-TIME-PERIOD-LN  PIC X(4).                   
                 15 WS-BASELINE-UNITS-LN    PIC X(10).                  
                 15 WS-CSS-BSLN-UPDT-IND    PIC X(01) VALUE SPACES.     
                    88 CSS-BSLN-INSERT                VALUE 'I'.        
                    88 CSS-BSLN-UPDATE                VALUE 'U'.        
                    88 CSS-BSLN-DELETE                VALUE 'D'.        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE                   PIC X(05) VALUE SPACES.     
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW                   PIC X(01) VALUE 'N'.        
              88 NOT-ALL-DONE                         VALUE 'N'.        
              88 ALL-DONE                             VALUE 'Y'.        
           05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.        
              88 SEND-DONE-ERROR                      VALUE 'N'.        
              88 SEND-DONE-OK                         VALUE 'Y'.        
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME                  PIC X(08) VALUE 'CSR04467'. 
           05 WS-TRAN-APPL-NO               PIC S9(04) COMP VALUE +1.   
           05 WS-N                          PIC X(01) VALUE 'N'.        
           05 GTT-NAME                      PIC X(26)                   
                                            VALUE 'SESSION.CSR04467_R1'.
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05 GTT-ROW.                                                 
               49 GTT-ROW-LEN               PIC S9(04) COMP.            
               49 GTT-ROW-CHAR              PIC X(1024).                
            05 GTT-SQLCODE                  PIC S9(9) COMP.             
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-COLUMN                    PIC S9(9) COMP VALUE 1.     
           05 CTR-ROWS                      PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
           05 MAX-LENGTH-PARM               PIC S9(9) COMP.             
           05 WRKLEN1                       PIC S9(9) COMP.             
           05 WRKLEN2                       PIC S9(9) COMP.             
           05 WRK-DONE-STATUS               PIC S9(9) COMP.             
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE                PIC S9(09) COMP VALUE 0.    
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE 0.    
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                   PIC X(18) VALUE SPACES.     
            10  S-SQLCODE                   PIC S9(9) COMP VALUE 0.     
            10  S-SQLSTATE                  PIC X(5)  VALUE ' '.        
            10  S-TABLE-NAME                PIC X(18) VALUE SPACES.     
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L      PIC S9(4) USAGE COMP.       
                49  S-HOST-VARIABLES-V      PIC X(255).                 
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L       PIC S9(4) USAGE COMP.       
                49  S-SQL-STATEMENT-V       PIC X(255).                 
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L     PIC S9(4) USAGE COMP.       
                49  S-SQL-DESCRIPTION-V     PIC X(255).                 
                                                                        
       01 WS-CODE-TIME-PERIOD-LN-NUMB       PIC S9(4).                  
                                                                        
                                                                        
       01 WS-BASELINE-MONTH-NUM             PIC S9(4) USAGE COMP.       
       01 WS-BASELINE-MONTH-NUMB            PIC S9(4).                  
       01 WS-BASELINE-MONTH-CHAR            PIC X(2).                   
       01 WS-ACCOUNT-NO-LN-NUM              PIC S9(13)V .               
                                                                        
       01 WS-PARM-UPDATE-DATA.                                          
           49 WS-PARM-UPDATE-DATA-LEN       PIC S9(4) USAGE COMP.       
           49 WS-PARM-UPDATE-DATA-TEXT      PIC X(2000).                
       01  WS-PARM-TRANS-COMMENT.                                       
           49  WS-TRANS-COMMENT-LEN         PIC S9(4) COMP.             
           49  WS-TRANS-COMMENT-TEXT        PIC X(210).                 
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACCOUNT-NO                  PIC X(13).                  
       01  PARM-CODE-UTIL-TYPE              PIC X(1).                   
       01  PARM-IC-NO                       PIC S9(4) USAGE COMP.       
       01  PARM-CNTRCT-START-DT             PIC X(10).                  
       01  PARM-TRANS-CMNT-TEXT             PIC X(210).                 
       01  PARM-TRANS-CMNT-LEN              PIC S9(4) COMP SYNC.        
                                                                        
       01  PARM-UPDATE-DATA                 PIC X(2000).                
                                                                        
       PROCEDURE DIVISION  USING PARM-ACCOUNT-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-IC-NO                             
                                 PARM-CNTRCT-START-DT                   
                                 PARM-TRANS-CMNT-TEXT                   
                                 PARM-TRANS-CMNT-LEN                    
                                 PARM-UPDATE-DATA.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
                 SELECT :S-RETURN-CODE AS RETURN_CODE                   
                   FROM CIS.SYSDUMMY1                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*          SELECT :S-RETURN-CODE AS RETURN_CODE                           
MFA-TR*            FROM SYSIBM.SYSDUMMY1                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE WS-UPDATE-DATA.                                   
                                                                        
           MOVE PARM-ACCOUNT-NO                TO WS-ACCOUNT-NO-LN-NUM. 
           MOVE WS-ACCOUNT-NO-LN-NUM           TO WS-ACCOUNT-NO-LN.     
           MOVE PARM-CODE-UTIL-TYPE            TO WS-CODE-UTIL-TYPE-LN. 
           MOVE PARM-IC-NO                     TO WS-IC-NO-LN.          
           MOVE PARM-CNTRCT-START-DT           TO WS-CNTRCT-START-DT-LN.
           MOVE PARM-TRANS-CMNT-LEN            TO                       
                                                 WS-TRANS-COMMENT-LEN.  
           MOVE PARM-TRANS-CMNT-TEXT           TO                       
                                                WS-TRANS-COMMENT-TEXT.  
           MOVE PARM-UPDATE-DATA               TO WS-PARM-UPDATE-DATA.  
           MOVE WS-PARM-UPDATE-DATA-TEXT       TO WS-UPDATE-DATA.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-ACCOUNT-NO-LN            TO LN-ACCOUNT-NO.           
           MOVE PARM-CODE-UTIL-TYPE         TO LN-CODE-UTIL-TYPE.       
           MOVE PARM-IC-NO                  TO LN-IC-NO.                
           MOVE PARM-CNTRCT-START-DT        TO LN-CNTRCT-START-DT.      
           PERFORM 2025-PROCESS-BL-CTR           THRU 2025-EXIT.        
           PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      *****************************************************************         
      *2025-PROCESS-BL-CTR                                            *         
      *****************************************************************         
       2025-PROCESS-BL-CTR.                                             
                                                                        
           PERFORM 7600-GET-CURRENT-TS           THRU 7600-EXIT         
                                                                        
           PERFORM VARYING WS-UPD-INDX FROM 1 BY 1                      
                     UNTIL WS-UPD-INDX > 100                            
                        OR WS-UPDATE-DATA-TEXT(WS-UPD-INDX) = SPACES    
              PERFORM 5050-MOVE-CSS-BSLN-CNTR     THRU 5050-EXIT        
                                                                        
              EVALUATE TRUE                                             
                                                                        
              WHEN CSS-BSLN-INSERT(WS-UPD-INDX)                         
                   PERFORM 5200-MOVE-INS-TRAN-DET THRU 5200-EXIT        
                   PERFORM 8080-INS-BIL-BSLN-CNTR THRU 8080-EXIT        
                                                                        
              WHEN CSS-BSLN-UPDATE(WS-UPD-INDX)                         
                   PERFORM 5300-MOVE-UPD-TRAN-DET THRU 5300-EXIT        
                                                                        
              WHEN CSS-BSLN-DELETE(WS-UPD-INDX)                         
                   PERFORM 5400-MOVE-DEL-TRAN-DET THRU 5400-EXIT        
                   PERFORM 8110-DEL-BIL-BSLN-CNTR THRU 8110-EXIT        
                                                                        
              END-EVALUATE                                              
                                                                        
           END-PERFORM.                                                 
                                                                        
       2025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
      *                                                                         
       5100-MOVE-TRAN-HEAD.                                             
                                                                        
           MOVE '5100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-CURRENT-TS                TO MH-TRANS-HIST-SEQ-NO    
           MOVE WS-CURRENT-TS(1:10)          TO MH-DATE-TRANS           
                                                                        
           MOVE 'F'                          TO MH-CODE-TRAN-TYPE.      
           MOVE SPACES                       TO MH-RESP-AREA-ID.        
           MOVE PARM-ACCOUNT-NO              TO MH-ACCOUNT-NO.          
           MOVE ZEROS                        TO MH-CUSTOMER-NO          
                                                MH-PREMISE-NO.          
           MOVE 'SYSTEM'                     TO MH-USER-ID.             
           MOVE 'PANEL653'                   TO MH-APPL-PROGRAM-ID.     
           MOVE WS-PARM-TRANS-COMMENT           TO MH-TRAN-COMMENT.     
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5200-MOVE-INS-TRAN-DET.                                          
                                                                        
             MOVE '5200'                    TO ACTIVE-PARAGRAPH.        
                                                                        
             IF WS-TRAN-APPL-NO = 1                                     
                PERFORM 5100-MOVE-TRAN-HEAD      THRU 5100-EXIT         
             END-IF.                                                    
                                                                        
             MOVE '*NEW*'                   TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE +5                        TO MI-PRV-COLUMN-VALUE-LEN. 
                                                                        
             MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.    
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
                                                                        
             INITIALIZE WS-MONTH-DESC                                   
                        WS-MONTH-NO.                                    
                                                                        
             MOVE WS-BASELINE-MONTH-CHAR    TO WS-MONTH-NO              
             PERFORM 5500-GET-BASELINE-MTH-DESC  THRU 5500-EXIT         
             MOVE WS-MONTH-DESC             TO                          
                                            MI-CHG-COLUMN-VALUE-TEXT.   
             MOVE +3                        TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE 'BASELINE MONTH'          TO MI-COLUMN-DESC.          
             MOVE SPACES                    TO MI-TABLE-ID.             
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE LN-CMPNT-ID-CD            TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE +2                        TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE 'COMPONENT ID CD'         TO MI-COLUMN-DESC.          
             MOVE 'N6'                      TO MI-TABLE-ID              
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE LN-INSTR-USE-TYPE-CD      TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE 'INSTR TYPE CD'           TO MI-COLUMN-DESC.          
             MOVE '43'                      TO MI-TABLE-ID              
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE WS-CODE-TIME-PERIOD(4:1)  TO MI-CHG-COLUMN-VALUE-TEXT 
             MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN  
             MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                    
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE 'TIME PERIOD'             TO MI-COLUMN-DESC.          
             MOVE '44'                      TO MI-TABLE-ID              
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
                                                                        
             MOVE WS-BASELINE-UNITS-NUM     TO WS-BASELINE-VAL-Z        
             MOVE WS-BASELINE-VAL-Z         TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                    
                                            TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
             MOVE 'BASELINE UNITS'          TO MI-COLUMN-DESC.          
             MOVE SPACES                    TO MI-TABLE-ID.             
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
      *                                                                         
       5300-MOVE-UPD-TRAN-DET.                                          
                                                                        
             MOVE '5300'                    TO ACTIVE-PARAGRAPH         
                                                                        
             PERFORM 7000-GET-UNITS-PREV-UPDATE  THRU 7000-EXIT         
                                                                        
             IF WS-BASELINE-UNITS-NUM NOT EQUAL                         
                                            WS-BASELINE-UNITS-PRV       
                IF WS-TRAN-APPL-NO = 1                                  
                   PERFORM 5100-MOVE-TRAN-HEAD   THRU 5100-EXIT         
                END-IF                                                  
                                                                        
                MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO     
                MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO          
                                                                        
                INITIALIZE  WS-MONTH-DESC                               
                            WS-MONTH-NO                                 
                MOVE WS-BASELINE-MONTH-CHAR  TO WS-MONTH-NO             
                                                                        
                PERFORM 5500-GET-BASELINE-MTH-DESC THRU 5500-EXIT       
                                                                        
                MOVE WS-MONTH-DESC                                      
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                                               MI-PRV-COLUMN-VALUE-TEXT 
                MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'BASELINE MONTH'       TO MI-COLUMN-DESC           
                MOVE SPACES                 TO MI-TABLE-ID              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                       TO WS-TRAN-APPL-NO          
                                                                        
                MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO          
                INITIALIZE MI-PRV-COLUMN-VALUE-TEXT                     
                MOVE LN-CMPNT-ID-CD         TO                          
                                               MI-CHG-COLUMN-VALUE-TEXT 
                                               MI-PRV-COLUMN-VALUE-TEXT 
                MOVE +2                     TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'COMPONENT ID CD'      TO MI-COLUMN-DESC           
                MOVE 'N6'                   TO MI-TABLE-ID              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                       TO WS-TRAN-APPL-NO          
                                                                        
                MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO          
                MOVE LN-INSTR-USE-TYPE-CD   TO                          
                                               MI-CHG-COLUMN-VALUE-TEXT 
                                               MI-PRV-COLUMN-VALUE-TEXT 
                MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                MOVE '43'                   TO MI-TABLE-ID              
                MOVE 'INSTR TYPE CD'        TO MI-COLUMN-DESC           
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                       TO WS-TRAN-APPL-NO          
                                                                        
                MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO          
                MOVE WS-CODE-TIME-PERIOD(4:1)                           
                                            TO MI-CHG-COLUMN-VALUE-TEXT 
                                               MI-PRV-COLUMN-VALUE-TEXT 
                                                                        
                MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'TIME PERIOD'          TO MI-COLUMN-DESC           
                MOVE '44'                   TO MI-TABLE-ID              
                PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT         
                ADD 1                       TO WS-TRAN-APPL-NO          
                                                                        
                MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO          
                                                                        
                MOVE WS-BASELINE-UNITS-PRV  TO WS-HOLD-BASELINE-VAL     
                MOVE WS-HOLD-BASELINE-VAL   TO WS-BASELINE-VAL-Z        
                MOVE WS-BASELINE-VAL-Z      TO                          
                                               MI-PRV-COLUMN-VALUE-TEXT 
                MOVE WS-BASELINE-UNITS-NUM     TO WS-BASELINE-VAL-Z     
                MOVE WS-BASELINE-VAL-Z     TO MI-CHG-COLUMN-VALUE-TEXT  
                MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                 
                                            TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                 
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                MOVE 'BASELINE UNITS'       TO MI-COLUMN-DESC           
                MOVE SPACES                 TO MI-TABLE-ID              
                PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT      
                ADD 1                       TO WS-TRAN-APPL-NO          
                INITIALIZE WS-BASELINE-UNITS-PRV                        
                                                                        
                PERFORM 8090-UPT-BIL-BSLN-CNTR   THRU 8090-EXIT         
             END-IF.                                                    
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5400-MOVE-DEL-TRAN-DET.                                          
                                                                        
             MOVE '5400' TO ACTIVE-PARAGRAPH.                           
                                                                        
             IF WS-TRAN-APPL-NO = 1                                     
                PERFORM 5100-MOVE-TRAN-HEAD      THRU 5100-EXIT         
             END-IF.                                                    
                                                                        
             MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.    
             MOVE '*DELETED*'               TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE +9                        TO MI-CHG-COLUMN-VALUE-LEN. 
                                                                        
             INITIALIZE WS-MONTH-NO.                                    
             MOVE WS-BASELINE-MONTH-CHAR    TO WS-MONTH-NO              
                                                                        
             PERFORM 5500-GET-BASELINE-MTH-DESC THRU 5500-EXIT          
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE WS-MONTH-DESC                                         
                                            TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE +3                        TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE 'BASELINE MONTH'          TO MI-COLUMN-DESC.          
             MOVE SPACES                    TO MI-TABLE-ID.             
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
                                                                        
             MOVE LN-CMPNT-ID-CD            TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE +2                        TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE 'COMPONENT ID CD'         TO MI-COLUMN-DESC.          
             MOVE 'N6'                      TO MI-TABLE-ID              
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE LN-INSTR-USE-TYPE-CD      TO MI-PRV-COLUMN-VALUE-TEXT.
             MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE 'INSTR TYPE CD'           TO MI-COLUMN-DESC.          
             MOVE '43'                      TO MI-TABLE-ID              
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
             MOVE +1                        TO MI-PRV-COLUMN-VALUE-LEN  
             MOVE WS-CODE-TIME-PERIOD(4:1)                              
                                            TO MI-PRV-COLUMN-VALUE-TEXT 
             MOVE 'TIME PERIOD'             TO MI-COLUMN-DESC.          
             MOVE '44'                      TO MI-TABLE-ID              
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
             MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO.         
                                                                        
             PERFORM 7000-GET-UNITS-PREV-UPDATE  THRU 7000-EXIT         
                                                                        
             MOVE WS-BASELINE-UNITS-PRV     TO WS-HOLD-BASELINE-VAL     
                                                                        
             MOVE WS-HOLD-BASELINE-VAL                                  
                                            TO WS-BASELINE-VAL-Z        
             MOVE WS-BASELINE-VAL-Z         TO                          
                                               MI-PRV-COLUMN-VALUE-TEXT 
             MOVE LENGTH OF MI-PRV-COLUMN-VALUE-TEXT                    
                                            TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE 'BASELINE UNITS'          TO MI-COLUMN-DESC.          
             MOVE SPACES                    TO MI-TABLE-ID.             
             PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT.        
             ADD 1                          TO WS-TRAN-APPL-NO.         
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * GETTING THE DESCREPTION OF BASELINE MONTH.                  *           
      ***************************************************************           
       5500-GET-BASELINE-MTH-DESC.                                      
                                                                        
             MOVE '5500' TO ACTIVE-PARAGRAPH.                           
             EVALUATE WS-MONTH-NO                                       
                WHEN '01'                                               
                   MOVE 'JAN'               TO WS-MONTH-DESC            
                WHEN '02'                                               
                   MOVE 'FEB'               TO WS-MONTH-DESC            
                WHEN '03'                                               
                   MOVE 'MAR'               TO WS-MONTH-DESC            
                WHEN '04'                                               
                   MOVE 'APR'               TO WS-MONTH-DESC            
                WHEN '05'                                               
                   MOVE 'MAY'               TO WS-MONTH-DESC            
                WHEN '06'                                               
                   MOVE 'JUN'               TO WS-MONTH-DESC            
                WHEN '07'                                               
                   MOVE 'JUL'               TO WS-MONTH-DESC            
                WHEN '08'                                               
                   MOVE 'AUG'               TO WS-MONTH-DESC            
                WHEN '09'                                               
                   MOVE 'SEP'               TO WS-MONTH-DESC            
                WHEN '10'                                               
                   MOVE 'OCT'               TO WS-MONTH-DESC            
                WHEN '11'                                               
                   MOVE 'NOV'               TO WS-MONTH-DESC            
                WHEN '12'                                               
                   MOVE 'DEC'               TO WS-MONTH-DESC            
                WHEN OTHER                                              
                   MOVE SPACES              TO WS-MONTH-DESC            
             END-EVALUATE.                                              
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5050-MOVE-CSS-BSLN-CNTR.                                      *         
      *****************************************************************         
       5050-MOVE-CSS-BSLN-CNTR.                                         
                                                                        
           MOVE WS-BASELINE-MONTH-LN(WS-UPD-INDX)                       
                                            TO WS-BASELINE-MONTH-NUMB   
                                               WS-BASELINE-MONTH-CHAR.  
           MOVE WS-BASELINE-MONTH-NUMB      TO LN-BASELINE-MONTH.       
           MOVE WS-CMPNT-ID-CD-LN(WS-UPD-INDX)                          
                                            TO LN-CMPNT-ID-CD.          
           MOVE WS-INSTR-USE-TYPE-CD-LN(WS-UPD-INDX)                    
                                            TO LN-INSTR-USE-TYPE-CD.    
           MOVE WS-CODE-TIME-PERIOD-LN(WS-UPD-INDX)                     
                                          TO WS-CODE-TIME-PERIOD-LN-NUMB
                                             WS-CODE-TIME-PERIOD.       
           MOVE WS-CODE-TIME-PERIOD-LN-NUMB TO LN-CODE-TIME-PERIOD.     
                                                                        
           MOVE WS-BASELINE-UNITS-LN(WS-UPD-INDX)                       
                                            TO WS-BASELINE-UNITS-CHAR.  
           MOVE WS-BASELINE-UNITS-NUM       TO LN-BASELINE-UNITS.       
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-UNITS-PREV-UPDATE.                                    *        
      ******************************************************************        
       7000-GET-UNITS-PREV-UPDATE.                                      
                                                                        
           EXEC SQL                                                     
               SELECT BASELINE_UNITS                                    
                 INTO :WS-BASELINE-UNITS-PRV                            
                 FROM CSS_BILL_BSLN_CNTR LN                             
                WHERE BASELINE_MONTH     = :LN-BASELINE-MONTH           
                  AND CMPNT_ID_CD        = :LN-CMPNT-ID-CD              
                  AND INSTR_USE_TYPE_CD  = :LN-INSTR-USE-TYPE-CD        
                  AND CODE_TIME_PERIOD   = :LN-CODE-TIME-PERIOD         
                  AND ACCOUNT_NO         = :LN-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :LN-CODE-UTIL-TYPE           
                  AND IC_NO              = :LN-IC-NO                    
                  AND CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :LN-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :LN-CNTRCT-START-DT
              ) <> 0) OR (LEN(:LN-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:LN-CNTRCT-START-DT
              ), CONVERT(DATE, :LN-CNTRCT-START-DT) )          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BASELINE_UNITS                                            
MFA-TR*          INTO :WS-BASELINE-UNITS-PRV                                    
MFA-TR*          FROM CSS_BILL_BSLN_CNTR LN                                     
MFA-TR*         WHERE BASELINE_MONTH     = :LN-BASELINE-MONTH                   
MFA-TR*           AND CMPNT_ID_CD        = :LN-CMPNT-ID-CD                      
MFA-TR*           AND INSTR_USE_TYPE_CD  = :LN-INSTR-USE-TYPE-CD                
MFA-TR*           AND CODE_TIME_PERIOD   = :LN-CODE-TIME-PERIOD                 
MFA-TR*           AND ACCOUNT_NO         = :LN-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :LN-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :LN-IC-NO                            
MFA-TR*           AND CNTRCT_START_DT    = :LN-CNTRCT-START-DT                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_BSLN_CNTR'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BASELINE_MONTH'          TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'CNTRCT_START_DT'         TO TABLE-ELEMENT-4         
              MOVE LN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE LN-BASELINE-MONTH         TO HOSTVAR-ELEMENT-2       
              MOVE LN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              MOVE LN-CNTRCT-START-DT        TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-GET-CURRENT-TS.                                           *        
      ******************************************************************        
       7600-GET-CURRENT-TS.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TS = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7600'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SET'                   TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE PARM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
               PERFORM 9910-SQL-ERROR            THRU 9910-EXIT         
           END-IF.                                                      
      *                                                                         
         7600-EXIT.                                                     
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * 8080-INS-BIL-BSLN-CNTR.                                        *        
      ******************************************************************        
       8080-INS-BIL-BSLN-CNTR.                                          
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BILL_BSLN_CNTR                           
               (                                                        
                  ACCOUNT_NO                                            
                 ,CODE_UTIL_TYPE                                        
                 ,IC_NO                                                 
                 ,CNTRCT_START_DT                                       
                 ,CMPNT_ID_CD                                           
                 ,INSTR_USE_TYPE_CD                                     
                 ,CODE_TIME_PERIOD                                      
                 ,BASELINE_MONTH                                        
                 ,BASELINE_UNITS                                        
               )                                                        
               VALUES                                                   
               (                                                        
                  :LN-ACCOUNT-NO                                        
                 ,:LN-CODE-UTIL-TYPE                                    
                 ,:LN-IC-NO                                             
                 ,IIF(TRY_CONVERT(DATE, :LN-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :LN-CNTRCT-START-DT
              ) <> 0) OR (LEN(:LN-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:LN-CNTRCT-START-DT
              ), CONVERT(DATE, :LN-CNTRCT-START-DT) )                          
                 ,:LN-CMPNT-ID-CD                                       
                 ,:LN-INSTR-USE-TYPE-CD                                 
                 ,:LN-CODE-TIME-PERIOD                                  
                 ,:LN-BASELINE-MONTH                                    
                 ,:LN-BASELINE-UNITS                                    
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_BILL_BSLN_CNTR                                   
MFA-TR*        (                                                                
MFA-TR*           ACCOUNT_NO                                                    
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,IC_NO                                                         
MFA-TR*          ,CNTRCT_START_DT                                               
MFA-TR*          ,CMPNT_ID_CD                                                   
MFA-TR*          ,INSTR_USE_TYPE_CD                                             
MFA-TR*          ,CODE_TIME_PERIOD                                              
MFA-TR*          ,BASELINE_MONTH                                                
MFA-TR*          ,BASELINE_UNITS                                                
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :LN-ACCOUNT-NO                                                
MFA-TR*          ,:LN-CODE-UTIL-TYPE                                            
MFA-TR*          ,:LN-IC-NO                                                     
MFA-TR*          ,:LN-CNTRCT-START-DT                                           
MFA-TR*          ,:LN-CMPNT-ID-CD                                               
MFA-TR*          ,:LN-INSTR-USE-TYPE-CD                                         
MFA-TR*          ,:LN-CODE-TIME-PERIOD                                          
MFA-TR*          ,:LN-BASELINE-MONTH                                            
MFA-TR*          ,:LN-BASELINE-UNITS                                            
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8080'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_BSLN_CNTR'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BASELINE_MONTH'          TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'CNTRCT_START_DT'         TO TABLE-ELEMENT-4         
              MOVE LN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE LN-BASELINE-MONTH         TO HOSTVAR-ELEMENT-2       
              MOVE LN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              MOVE LN-CNTRCT-START-DT        TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8090-UPT-BIL-BSLN-CNTR.                                        *        
      ******************************************************************        
       8090-UPT-BIL-BSLN-CNTR.                                          
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILL_BSLN_CNTR                                
                  SET BASELINE_UNITS     = :LN-BASELINE-UNITS           
                WHERE BASELINE_MONTH     = :LN-BASELINE-MONTH           
                  AND CMPNT_ID_CD        = :LN-CMPNT-ID-CD              
                  AND INSTR_USE_TYPE_CD  = :LN-INSTR-USE-TYPE-CD        
                  AND CODE_TIME_PERIOD   = :LN-CODE-TIME-PERIOD         
                  AND ACCOUNT_NO         = :LN-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :LN-CODE-UTIL-TYPE           
                  AND IC_NO              = :LN-IC-NO                    
                  AND CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :LN-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :LN-CNTRCT-START-DT
              ) <> 0) OR (LEN(:LN-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:LN-CNTRCT-START-DT
              ), CONVERT(DATE, :LN-CNTRCT-START-DT) )          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILL_BSLN_CNTR                                        
MFA-TR*           SET BASELINE_UNITS     = :LN-BASELINE-UNITS                   
MFA-TR*         WHERE BASELINE_MONTH     = :LN-BASELINE-MONTH                   
MFA-TR*           AND CMPNT_ID_CD        = :LN-CMPNT-ID-CD                      
MFA-TR*           AND INSTR_USE_TYPE_CD  = :LN-INSTR-USE-TYPE-CD                
MFA-TR*           AND CODE_TIME_PERIOD   = :LN-CODE-TIME-PERIOD                 
MFA-TR*           AND ACCOUNT_NO         = :LN-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :LN-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :LN-IC-NO                            
MFA-TR*           AND CNTRCT_START_DT    = :LN-CNTRCT-START-DT                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8090'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_BSLN_CNTR'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BASELINE_MONTH'          TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'CNTRCT_START_DT'         TO TABLE-ELEMENT-4         
              MOVE LN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE LN-BASELINE-MONTH         TO HOSTVAR-ELEMENT-2       
              MOVE LN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              MOVE LN-CNTRCT-START-DT        TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8090-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
              ADD +1                       TO CTR-ROWS.                 
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8110-DEL-BIL-BSLN-CNTR.                                        *        
      ******************************************************************        
       8110-DEL-BIL-BSLN-CNTR.                                          
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_BILL_BSLN_CNTR                           
                WHERE BASELINE_MONTH     = :LN-BASELINE-MONTH           
                  AND CMPNT_ID_CD        = :LN-CMPNT-ID-CD              
                  AND INSTR_USE_TYPE_CD  = :LN-INSTR-USE-TYPE-CD        
                  AND CODE_TIME_PERIOD   = :LN-CODE-TIME-PERIOD         
                  AND ACCOUNT_NO         = :LN-ACCOUNT-NO               
                  AND CODE_UTIL_TYPE     = :LN-CODE-UTIL-TYPE           
                  AND IC_NO              = :LN-IC-NO                    
                  AND CNTRCT_START_DT    = IIF(TRY_CONVERT(DATE, 
                                                    :LN-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :LN-CNTRCT-START-DT
              ) <> 0) OR (LEN(:LN-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:LN-CNTRCT-START-DT
              ), CONVERT(DATE, :LN-CNTRCT-START-DT) )          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_BILL_BSLN_CNTR                                   
MFA-TR*         WHERE BASELINE_MONTH     = :LN-BASELINE-MONTH                   
MFA-TR*           AND CMPNT_ID_CD        = :LN-CMPNT-ID-CD                      
MFA-TR*           AND INSTR_USE_TYPE_CD  = :LN-INSTR-USE-TYPE-CD                
MFA-TR*           AND CODE_TIME_PERIOD   = :LN-CODE-TIME-PERIOD                 
MFA-TR*           AND ACCOUNT_NO         = :LN-ACCOUNT-NO                       
MFA-TR*           AND CODE_UTIL_TYPE     = :LN-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :LN-IC-NO                            
MFA-TR*           AND CNTRCT_START_DT    = :LN-CNTRCT-START-DT                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BILL_BSLN_CNTR'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'BASELINE_MONTH'          TO TABLE-ELEMENT-2         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-3         
              MOVE 'CNTRCT_START_DT'         TO TABLE-ELEMENT-4         
              MOVE LN-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE LN-BASELINE-MONTH         TO HOSTVAR-ELEMENT-2       
              MOVE LN-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-3       
              MOVE LN-CNTRCT-START-DT        TO HOSTVAR-ELEMENT-4       
              PERFORM 9910-SQL-ERROR            THRU 9910-EXIT          
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST.                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      * 9910-SQL-ERROR.                                               *         
      *****************************************************************         
       9910-SQL-ERROR.                                                  
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00321                                                   
           END-EXEC.                                                            
                                                                        
