       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04459.                                         
COB303 DATE-WRITTEN.  MAY 15, 2012.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000100
      *                   SOUTH CAROLINA ELECTRIC & GAS                *00080000
      ******************************************************************00000100
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00090000
      *  THIS PROCEDURE UPDATES/INSERTS/DELETES MULTIPLE LIGHTNING     *00180000
      *  COMPONENTS (TABLE CSS_UNMTR_PLAN) IN SINGLE CALL.             *00100000
      *                                                                *00110000
      ******************************************************************00150000
      *  INPUT PARAMETERS                OUTPUT PARAMETERS             *00200000
      ******************************************************************00150000
      *                                                                *00110000
      *  APPL_PROG_ID         X(03)      RETURN-CODE        S9(04)     *00202000
      *  USER_ID              X(07)      APPL_RETURN_CODE   S9(04)     *00202000
      *  CODE_UTIL_TYPE       X(01)      RATE_ITEM_CODE      X(04)     *00202000
      *  RATE_PLAN_NO         X(03)      UM_EQUIP_ID         X(02)     *00203000
      *  VERSION_NO_CNTRL    S9(04)                                    *00204000
      *  UMPLAN_ROW_COUNT    S9(04)                                    *00205000
      *  UMPLAN_ROW_1         X(20)                                    *00206000
      *    UMPLAN_UPD_FLAG      X(01)                                  *00206000
      *    RATE_ITEM_CODE       X(04)                                  *00206000
      *    UM_EQUIP_ID          X(02)                                  *00207000
      *    CUST_PER_SERVICE     X(04)                                  *00208000
      *    PRICE_PER_SERV       X(09)                                  *00209000
      *  UMPLAN_ROW_2  TO                                              *00206000
      *  UMPLAN_ROW_30        MAXIMUM COUNT 30                         *00206000
      *                                                                *00209100
      ******************************************************************00000100
      *  TABLES USED:                                                  *00209200
      *                                                                *00209600
      *      TABLE NAME          DCLGEN NAME    2 CHAR ID              *00209300
      *      ------------------  -----------    ---------              *00209400
      *      CSS_UNMTR_PLAN      TBUMPLAN       UP                     *00209500
      *                                                                *00209600
      ******************************************************************00209700
      *                     PROGRAM MODIFICATION LOG                   *00209900
      *                                                                *00210000
      *    DATE    INITIALS   COMMENTS                                 *00220000
      *  --------  --------   ---------------------------------------  *00230000
      *  05/15/12  HA7A338    INITIAL VERSION.                         *00240000
      *                                                                *00209800
      ******************************************************************00260000
      ******************************************************************00270000
      *                                                                *00280000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00290000
      *                                                                *00300000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00310000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00320000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00330000
      *  3000 - 4999  NOT USED                                         *00340000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00350000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00360000
      *  7000 - 7999  INPUT MODULES                                    *00370000
      *  8000 - 8999  OUTPUT MODULES                                   *00380000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00390000
      *                                                                *00400000
      ******************************************************************00410000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04459'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04459 STARTS HERE'.                  
                                                                        
      ******************************************************************00500000
      *    DB2 INCLUDES                                                *00510000
      ******************************************************************00520000
                                                                        
           EXEC SQL                                                     00540000
              INCLUDE SQLCA                                             00550000
           END-EXEC.                                                    00560000
                                                                        
      *--------< CSS_UNMTR_PLAN >                                       00620000
                                                                        
           EXEC SQL                                                     00640000
              INCLUDE TBUMPLAN                                          00650000
           END-EXEC.                                                    00660000
                                                                        
      ******************************************************************00690000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00700000
      ******************************************************************00710000
                                                                        
      *--------<COMMON SYSTEM AREA >                                    00780000
           COPY CCA00001.                                               00790000
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       00820000
           COPY CWS00027.                                               00830000
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  00840000
           COPY CWS00303.                                               00850000
      *--------< ERROR HANDLING >                                       00840000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
      ******************************************************************00870000
      *    WORK AREAS                                                  *00880000
      ******************************************************************00890000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04459'.    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                  PIC S9(9) COMP VALUE 0.        
                                                                        
       01  WS-PARM-FIELDS.                                              
           05  S-RATE-ITEM-CODE          PIC S9(4) COMP VALUE 0.        
           05  S-UM-EQUIP-ID             PIC X(02) VALUE SPACES.        
           05  WS-CODE-UTIL-TYPE         PIC X(01) VALUE SPACES.        
           05  WS-RATE-PLAN-NO           PIC X(03) VALUE SPACES.        
           05  WS-VERSION-NO-CNTRL       PIC S9(4) COMP  VALUE 0.       
           05  WS-RATE-ITEM-CODE         PIC S9(4) COMP  VALUE 0.       
           05  WS-MAX-RATE-ITEM-CODE     PIC S9(4) COMP  VALUE 0.       
           05  WS-MRIC-NULL-IND          PIC S9(4) COMP  VALUE 0.       
           05  WS-UMPLAN-ROW-COUNT       PIC S9(4) COMP  VALUE 0.       
           05  WS-MAX-ROW-COUNT          PIC S9(4) COMP  VALUE 30.      
           05  WS-TEMP-INDX              PIC S9(4) COMP  VALUE 0.       
           05  WS-TEMP-VALUE             PIC X(20) VALUE SPACES.        
           05  WS-UMPLAN-ROW-VALUE   OCCURS 30 TIMES                    
                                       INDEXED BY WS-UMPLAN-ROW-INDX.   
             10  WS-UMPLAN-UPD-FLAG      PIC  X(01)  VALUE SPACES.      
                 88 UMPLAN-FLAG-DELETE               VALUE 'D'.         
                 88 UMPLAN-FLAG-UPDATE               VALUE 'U'.         
                 88 UMPLAN-FLAG-INSERT               VALUE 'I'.         
             10  WS-RATE-ITEM-CODE-C     PIC  X(04)  VALUE SPACES.      
             10  WS-RATE-ITEM-CODE-N REDEFINES WS-RATE-ITEM-CODE-C      
                                         PIC S9(04).                    
             10  WS-UM-EQUIP-ID          PIC  X(02)  VALUE SPACES.      
             10  WS-CUST-PER-SERVICE-C   PIC  X(04)  VALUE SPACES.      
             10  WS-CUST-PER-SERVICE-N REDEFINES WS-CUST-PER-SERVICE-C  
                                         PIC S9(04).                    
             10  WS-PRICE-PER-SERV-C     PIC  X(09)  VALUE SPACES.      
             10  WS-PRICE-PER-SERV-N REDEFINES WS-PRICE-PER-SERV-C      
                                         PIC S9(09).                    
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
           05  S-APPL-RETURN-CODE        PIC S9(09) COMP VALUE 0.       
      *                                                                 01520000
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID        PIC  X(03).                         
       01  PARM-USER-ID             PIC  X(07).                         
       01  PARM-CODE-UTIL-TYPE      PIC  X(01).                         
       01  PARM-RATE-PLAN-NO        PIC  X(03).                         
       01  PARM-VERSION-NO-CNTRL    PIC  S9(4) USAGE COMP.              
       01  PARM-UMPLAN-ROW-COUNT    PIC  S9(4) USAGE COMP.              
       01  PARM-UMPLAN-1            PIC  X(20).                         
       01  PARM-UMPLAN-2            PIC  X(20).                         
       01  PARM-UMPLAN-3            PIC  X(20).                         
       01  PARM-UMPLAN-4            PIC  X(20).                         
       01  PARM-UMPLAN-5            PIC  X(20).                         
       01  PARM-UMPLAN-6            PIC  X(20).                         
       01  PARM-UMPLAN-7            PIC  X(20).                         
       01  PARM-UMPLAN-8            PIC  X(20).                         
       01  PARM-UMPLAN-9            PIC  X(20).                         
       01  PARM-UMPLAN-10           PIC  X(20).                         
       01  PARM-UMPLAN-11           PIC  X(20).                         
       01  PARM-UMPLAN-12           PIC  X(20).                         
       01  PARM-UMPLAN-13           PIC  X(20).                         
       01  PARM-UMPLAN-14           PIC  X(20).                         
       01  PARM-UMPLAN-15           PIC  X(20).                         
       01  PARM-UMPLAN-16           PIC  X(20).                         
       01  PARM-UMPLAN-17           PIC  X(20).                         
       01  PARM-UMPLAN-18           PIC  X(20).                         
       01  PARM-UMPLAN-19           PIC  X(20).                         
       01  PARM-UMPLAN-20           PIC  X(20).                         
       01  PARM-UMPLAN-21           PIC  X(20).                         
       01  PARM-UMPLAN-22           PIC  X(20).                         
       01  PARM-UMPLAN-23           PIC  X(20).                         
       01  PARM-UMPLAN-24           PIC  X(20).                         
       01  PARM-UMPLAN-25           PIC  X(20).                         
       01  PARM-UMPLAN-26           PIC  X(20).                         
       01  PARM-UMPLAN-27           PIC  X(20).                         
       01  PARM-UMPLAN-28           PIC  X(20).                         
       01  PARM-UMPLAN-29           PIC  X(20).                         
       01  PARM-UMPLAN-30           PIC  X(20).                         
                                                                        
       PROCEDURE DIVISION USING                                         
                 PARM-APPL-PROG-ID                                      
               , PARM-USER-ID                                           
               , PARM-CODE-UTIL-TYPE                                    
               , PARM-RATE-PLAN-NO                                      
               , PARM-VERSION-NO-CNTRL                                  
               , PARM-UMPLAN-ROW-COUNT                                  
               , PARM-UMPLAN-1                                          
               , PARM-UMPLAN-2                                          
               , PARM-UMPLAN-3                                          
               , PARM-UMPLAN-4                                          
               , PARM-UMPLAN-5                                          
               , PARM-UMPLAN-6                                          
               , PARM-UMPLAN-7                                          
               , PARM-UMPLAN-8                                          
               , PARM-UMPLAN-9                                          
               , PARM-UMPLAN-10                                         
               , PARM-UMPLAN-11                                         
               , PARM-UMPLAN-12                                         
               , PARM-UMPLAN-13                                         
               , PARM-UMPLAN-14                                         
               , PARM-UMPLAN-15                                         
               , PARM-UMPLAN-16                                         
               , PARM-UMPLAN-17                                         
               , PARM-UMPLAN-18                                         
               , PARM-UMPLAN-19                                         
               , PARM-UMPLAN-20                                         
               , PARM-UMPLAN-21                                         
               , PARM-UMPLAN-22                                         
               , PARM-UMPLAN-23                                         
               , PARM-UMPLAN-24                                         
               , PARM-UMPLAN-25                                         
               , PARM-UMPLAN-26                                         
               , PARM-UMPLAN-27                                         
               , PARM-UMPLAN-28                                         
               , PARM-UMPLAN-29                                         
               , PARM-UMPLAN-30                                         
               .                                                        
                                                                        
      ******************************************************************01560000
      * 0000-MAINLINE                                                  *01570000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01630000
      ******************************************************************01640000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01760000
      * 0100-INITIALIZE                                                *01770000
      *                                                                *01870000
      ******************************************************************01880000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                :S-RETURN-CODE              AS  RETURN_CODE             
               ,:S-APPL-RETURN-CODE         AS  APPL_RETURN_CODE        
               ,:S-RATE-ITEM-CODE           AS  RATE_ITEM_CODE          
               ,:S-UM-EQUIP-ID              AS  UM_EQUIP_ID             
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*         :S-RETURN-CODE              AS  RETURN_CODE                     
MFA-TR*        ,:S-APPL-RETURN-CODE         AS  APPL_RETURN_CODE                
MFA-TR*        ,:S-RATE-ITEM-CODE           AS  RATE_ITEM_CODE                  
MFA-TR*        ,:S-UM-EQUIP-ID              AS  UM_EQUIP_ID                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02170000
      * 1000-PROCESS-INPUT                                             *02180000
      *     1. RECEIVE PARMS.                                          *02230000
      ******************************************************************02240000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CODE-UTIL-TYPE          TO WS-CODE-UTIL-TYPE  .    
           MOVE PARM-RATE-PLAN-NO            TO WS-RATE-PLAN-NO    .    
           MOVE PARM-VERSION-NO-CNTRL        TO WS-VERSION-NO-CNTRL.    
           MOVE PARM-UMPLAN-ROW-COUNT        TO WS-UMPLAN-ROW-COUNT.    
                                                                        
           PERFORM 1100-VALIDATE-INPUT THRU 1100-EXIT.                  
                                                                        
      *    PERFORM VARYING WS-UMPLAN-ROW-INDX FROM 1 BY 1                       
      *         UNTIL WS-UMPLAN-ROW-INDX      > (WS-MAX OR                      
      *                                          WS-UMPLAN-ROW-COUNT)           
      *       MOVE PARM-UMPLAN-UPD-FLAG(UMPLAN-ROW-INDX)                        
      *                                      TO                                 
      *                       WS-UMPLAN-UPD-FLAG(WS-UMPLAN-ROW-INDX)            
      *       MOVE PARM-RATE-ITEM-CODE(UMPLAN-ROW-INDX)                         
      *                                      TO                                 
      *                       WS-RATE-ITEM-CODE(WS-UMPLAN-ROW-INDX)             
      *       MOVE PARM-UM-EQUIP-ID(UMPLAN-ROW-INDX)                            
      *                                      TO                                 
      *                       WS-UM-EQUIP-ID(WS-UMPLAN-ROW-INDX)                
      *       MOVE PARM-CUST-PER-SERVICE(UMPLAN-ROW-INDX)                       
      *                                      TO                                 
      *                       WS-CUST-PER-SERVICE(WS-UMPLAN-ROW-INDX)           
      *       MOVE PARM-PRICE-PER-SERV(UMPLAN-ROW-INDX)                         
      *                                      TO                                 
      *                       WS-PRICE-PER-SERV(WS-UMPLAN-ROW-INDX)             
      *    END-PERFORM.                                                 02330000
           MOVE PARM-UMPLAN-1                TO WS-UMPLAN-ROW-VALUE(01).
           MOVE PARM-UMPLAN-2                TO WS-UMPLAN-ROW-VALUE(02).
           MOVE PARM-UMPLAN-3                TO WS-UMPLAN-ROW-VALUE(03).
           MOVE PARM-UMPLAN-4                TO WS-UMPLAN-ROW-VALUE(04).
           MOVE PARM-UMPLAN-5                TO WS-UMPLAN-ROW-VALUE(05).
           MOVE PARM-UMPLAN-6                TO WS-UMPLAN-ROW-VALUE(06).
           MOVE PARM-UMPLAN-7                TO WS-UMPLAN-ROW-VALUE(07).
           MOVE PARM-UMPLAN-8                TO WS-UMPLAN-ROW-VALUE(08).
           MOVE PARM-UMPLAN-9                TO WS-UMPLAN-ROW-VALUE(09).
           MOVE PARM-UMPLAN-10               TO WS-UMPLAN-ROW-VALUE(10).
           MOVE PARM-UMPLAN-11               TO WS-UMPLAN-ROW-VALUE(11).
           MOVE PARM-UMPLAN-12               TO WS-UMPLAN-ROW-VALUE(12).
           MOVE PARM-UMPLAN-13               TO WS-UMPLAN-ROW-VALUE(13).
           MOVE PARM-UMPLAN-14               TO WS-UMPLAN-ROW-VALUE(14).
           MOVE PARM-UMPLAN-15               TO WS-UMPLAN-ROW-VALUE(15).
           MOVE PARM-UMPLAN-16               TO WS-UMPLAN-ROW-VALUE(16).
           MOVE PARM-UMPLAN-17               TO WS-UMPLAN-ROW-VALUE(17).
           MOVE PARM-UMPLAN-18               TO WS-UMPLAN-ROW-VALUE(18).
           MOVE PARM-UMPLAN-19               TO WS-UMPLAN-ROW-VALUE(19).
           MOVE PARM-UMPLAN-20               TO WS-UMPLAN-ROW-VALUE(20).
           MOVE PARM-UMPLAN-21               TO WS-UMPLAN-ROW-VALUE(21).
           MOVE PARM-UMPLAN-22               TO WS-UMPLAN-ROW-VALUE(22).
           MOVE PARM-UMPLAN-23               TO WS-UMPLAN-ROW-VALUE(23).
           MOVE PARM-UMPLAN-24               TO WS-UMPLAN-ROW-VALUE(24).
           MOVE PARM-UMPLAN-25               TO WS-UMPLAN-ROW-VALUE(25).
           MOVE PARM-UMPLAN-26               TO WS-UMPLAN-ROW-VALUE(26).
           MOVE PARM-UMPLAN-27               TO WS-UMPLAN-ROW-VALUE(27).
           MOVE PARM-UMPLAN-28               TO WS-UMPLAN-ROW-VALUE(28).
           MOVE PARM-UMPLAN-29               TO WS-UMPLAN-ROW-VALUE(29).
           MOVE PARM-UMPLAN-30               TO WS-UMPLAN-ROW-VALUE(30).
                                                                        
           PERFORM VARYING WS-UMPLAN-ROW-INDX FROM 1 BY 1               
                UNTIL WS-UMPLAN-ROW-INDX      > (WS-MAX-ROW-COUNT  OR   
                                                 WS-UMPLAN-ROW-COUNT)   
              PERFORM VARYING WS-TEMP-INDX FROM WS-UMPLAN-ROW-INDX BY 1 
                UNTIL WS-TEMP-INDX            > (WS-MAX-ROW-COUNT  OR   
                                                 WS-UMPLAN-ROW-COUNT)   
                IF WS-UMPLAN-UPD-FLAG(WS-TEMP-INDX) <                   
                              WS-UMPLAN-UPD-FLAG(WS-UMPLAN-ROW-INDX)    
                   MOVE WS-UMPLAN-ROW-VALUE(WS-TEMP-INDX)               
                                             TO                         
                              WS-TEMP-VALUE                             
                   MOVE WS-UMPLAN-ROW-VALUE(WS-UMPLAN-ROW-INDX)         
                                             TO                         
                              WS-UMPLAN-ROW-VALUE(WS-TEMP-INDX)         
                   MOVE WS-TEMP-VALUE        TO                         
                              WS-UMPLAN-ROW-VALUE(WS-UMPLAN-ROW-INDX)   
                END-IF                                                  
              END-PERFORM                                               
           END-PERFORM.                                                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02360000
      *1100-VALIDATE-INPUT.                                            *02360000
      *      VALIDATE INPUT PARAMETERS                                 *02360000
      * WHEN INPUT PARAMETERS ARE INVALID PASS APPROPRIATE RETURN CODE *02360000
      ******************************************************************02360000
                                                                        
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF  WS-UMPLAN-ROW-COUNT > 0                                  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE SPACES                    TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              MOVE NOT-FOUND                 TO WS-ACTIVE-RETURN-CODE   
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03005000
      * 2000-PROCESS-OUTPUT.                                           *03006000
      ******************************************************************03070000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE         THRU 5000-EXIT.                  
           PERFORM 8100-SEND-RESULT    THRU 8100-EXIT.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03560000
      * 5000-UPDATE                                                    *03570000
      *     FORMATS A ROW BASED ON THE PASSED PARAMS AND THEN          *03650000
      *     DETERMINES WHETHER THIS IS AN UPDATE OR AN INSERT OR DELETE*03660000
      *     NEXT THE APPROPRIATE PARA IS CALLED TO DO THE INSERT /     *03660000
      *     UPDATE / DELETE.                                           *03680000
      ******************************************************************03690000
                                                                        
       5000-UPDATE.                                                     
                                                                        
           PERFORM VARYING WS-UMPLAN-ROW-INDX FROM 1 BY 1               
                UNTIL WS-UMPLAN-ROW-INDX      > (WS-MAX-ROW-COUNT OR    
                                                 WS-UMPLAN-ROW-COUNT)   
                   OR WS-UM-EQUIP-ID(WS-UMPLAN-ROW-INDX)                
                                              <= SPACES                 
                                                                        
              PERFORM 5100-FORMAT-ROW  THRU 5100-EXIT                   
                                                                        
              EVALUATE TRUE                                             
                WHEN UMPLAN-FLAG-DELETE(WS-UMPLAN-ROW-INDX)             
                     PERFORM 8200-DELETE-UMPLAN  THRU 8200-EXIT         
                WHEN UMPLAN-FLAG-INSERT(WS-UMPLAN-ROW-INDX)             
                     PERFORM 8300-INSERT-UMPLAN  THRU 8300-EXIT         
                WHEN UMPLAN-FLAG-UPDATE(WS-UMPLAN-ROW-INDX)             
                     PERFORM 8400-UPDATE-UMPLAN  THRU 8400-EXIT         
              END-EVALUATE                                              
                                                                        
           END-PERFORM.                                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03920000
      * 5100-FORMAT-ROW                                                *03930000
      *     FORMATS THE CSS_UNMTR_PLAN ROW FROM THE PASSED PARAMS      *03980000
      ******************************************************************03990000
                                                                        
       5100-FORMAT-ROW.                                                 
                                                                        
           IF UMPLAN-FLAG-INSERT(WS-UMPLAN-ROW-INDX)                    
              PERFORM 7000-SELECT-MAX-ITEM-CD THRU 7000-EXIT            
                                                                        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
              OR WS-MRIC-NULL-IND      < 0                              
                 MOVE 1                      TO WS-RATE-ITEM-CODE       
              ELSE                                                      
                 MOVE WS-MAX-RATE-ITEM-CODE  TO WS-RATE-ITEM-CODE       
                 ADD  1                      TO WS-RATE-ITEM-CODE       
              END-IF                                                    
           ELSE                                                         
              MOVE  WS-RATE-ITEM-CODE-N(WS-UMPLAN-ROW-INDX)             
                                             TO WS-RATE-ITEM-CODE       
           END-IF.                                                      
                                                                        
           MOVE  WS-CODE-UTIL-TYPE           TO  UP-CODE-UTIL-TYPE.     
           MOVE  WS-RATE-PLAN-NO             TO  UP-RATE-PLAN-NO.       
           MOVE  WS-VERSION-NO-CNTRL         TO  UP-VERSION-NO-CNTRL.   
           MOVE  WS-RATE-ITEM-CODE           TO  UP-RATE-ITEM-CODE.     
           MOVE  WS-UM-EQUIP-ID(WS-UMPLAN-ROW-INDX)                     
                                             TO  UP-UM-EQUIP-ID.        
           MOVE  WS-CUST-PER-SERVICE-N(WS-UMPLAN-ROW-INDX)              
                                             TO  UP-CUST-PER-SERVICE.   
                                                                        
           DIVIDE WS-PRICE-PER-SERV-N(WS-UMPLAN-ROW-INDX) BY 1000000    
           GIVING UP-PRICE-PER-SERV.                                    
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 04320000
      * 7000-SELECT-MAX-ITEM-CD                                       * 04330000
      *     SELECTS CSS_UNMTR_PLAN                                    * 04390000
      ***************************************************************** 04400000
                                                                        
       7000-SELECT-MAX-ITEM-CD.                                         
                                                                        
           MOVE '7000'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              SELECT  MAX(RATE_ITEM_CODE)                               
                INTO  :WS-MAX-RATE-ITEM-CODE :WS-MRIC-NULL-IND           
                FROM  CSS_UNMTR_PLAN WITH(READUNCOMMITTED)                      
               WHERE  CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                 AND  RATE_PLAN_NO      = :WS-RATE-PLAN-NO              
                 AND  VERSION_NO_CNTRL  = :WS-VERSION-NO-CNTRL          
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04460000
MFA-TR*       SELECT  MAX(RATE_ITEM_CODE)                               04470000
MFA-TR*         INTO  :WS-MAX-RATE-ITEM-CODE:WS-MRIC-NULL-IND           04480000
MFA-TR*         FROM  CSS_UNMTR_PLAN                                    04490000
MFA-TR*        WHERE  CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            04500000
MFA-TR*          AND  RATE_PLAN_NO      = :WS-RATE-PLAN-NO              04510000
MFA-TR*          AND  VERSION_NO_CNTRL  = :WS-VERSION-NO-CNTRL          04520000
MFA-TR*        WITH UR                                                  04520000
MFA-TR*        QUERYNO 7000                                             04520000
MFA-TR*    END-EXEC.                                                    04530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL OR NOT-FOUND   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UNMTR_PLAN'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 05730000
      * 8100-SEND-RESULT.                                             * 05740000
      *     INCREMENT THE CTR ROW COUNT.                              * 05800000
      ***************************************************************** 05810000
       8100-SEND-RESULT.                                                
             ADD 1                           TO CTR-ROWS.               
                                                                        
       8100-EXIT.                                                       
              EXIT.                                                     
                                                                        
      ***************************************************************** 05270000
      * 8200-DELETE-UMPLAN                                            * 05280000
      *     DELETES CSS_UNMTR_PLAN.                                   * 05340000
      ***************************************************************** 05350000
                                                                        
       8200-DELETE-UMPLAN.                                              
                                                                        
           MOVE '8200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_UNMTR_PLAN                                
               WHERE CODE_UTIL_TYPE     = :UP-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :UP-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :UP-VERSION-NO-CNTRL          
                 AND RATE_ITEM_CODE     = :UP-RATE-ITEM-CODE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UNMTR_PLAN'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'RATE_ITEM_CODE'          TO TABLE-ELEMENT-4         
              MOVE UP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE UP-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE UP-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE UP-RATE-ITEM-CODE         TO HOSTVAR-ELEMENT-4       
                                                S-RATE-ITEM-CODE        
              MOVE UP-UM-EQUIP-ID            TO S-UM-EQUIP-ID           
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 05730000
      * 8300-INSERT-UMPLAN                                            * 05740000
      *     INSERTS CSS_UNMTR_PLAN.                                   * 05800000
      ***************************************************************** 05810000
                                                                        
       8300-INSERT-UMPLAN.                                              
                                                                        
           MOVE '8300'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_UNMTR_PLAN                                
                    (CODE_UTIL_TYPE                                     
                   , RATE_PLAN_NO                                       
                   , VERSION_NO_CNTRL                                   
                   , RATE_ITEM_CODE                                     
                   , UM_EQUIP_ID                                        
                   , CUST_PER_SERVICE                                   
                   , PRICE_PER_SERV)                                    
              VALUES                                                    
                   (:UP-CODE-UTIL-TYPE                                  
                   ,:UP-RATE-PLAN-NO                                    
                   ,:UP-VERSION-NO-CNTRL                                
                   ,:UP-RATE-ITEM-CODE                                  
                   ,:UP-UM-EQUIP-ID                                     
                   ,:UP-CUST-PER-SERVICE                                
                   ,:UP-PRICE-PER-SERV)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UNMTR_PLAN'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'RATE_ITEM_CODE'          TO TABLE-ELEMENT-4         
              MOVE UP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE UP-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE UP-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE UP-RATE-ITEM-CODE         TO HOSTVAR-ELEMENT-4       
                                                S-RATE-ITEM-CODE        
              MOVE UP-UM-EQUIP-ID            TO S-UM-EQUIP-ID           
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 04780000
      * 8400-UPDATE-UMPLAN                                            * 04790000
      *     UPDATES CSS_UNMTR_PLAN.                                   * 04850000
      ***************************************************************** 04860000
                                                                        
       8400-UPDATE-UMPLAN.                                              
                                                                        
           MOVE '8400'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_UNMTR_PLAN                                     
                 SET UM_EQUIP_ID        = :UP-UM-EQUIP-ID               
                    ,CUST_PER_SERVICE   = :UP-CUST-PER-SERVICE          
                    ,PRICE_PER_SERV     = :UP-PRICE-PER-SERV            
               WHERE CODE_UTIL_TYPE     = :UP-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :UP-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :UP-VERSION-NO-CNTRL          
                 AND RATE_ITEM_CODE     = :UP-RATE-ITEM-CODE            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_UNMTR_PLAN'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'RATE_ITEM_CODE'          TO TABLE-ELEMENT-4         
              MOVE UP-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE UP-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE UP-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE UP-RATE-ITEM-CODE         TO HOSTVAR-ELEMENT-4       
                                                S-RATE-ITEM-CODE        
              MOVE UP-UM-EQUIP-ID            TO S-UM-EQUIP-ID           
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06300000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     06310000
      ******************************************************************06320000
           EXEC SQL                                                     06330000
              INCLUDE CPDSP300                                          06340000
           END-EXEC.                                                    06350000
                                                                        
      ******************************************************************06300000
      * 8900-SEND-DONE                                                  06310000
      * 9000-SEND-ERROR-RESULT                                          06310000
      * 9999-END-PROGRAM                                                06310000
      ******************************************************************06320000
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
