       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04458.                                         
COB303 DATE-WRITTEN.  MAY 15, 2012.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00180000
      ******************************************************************00181002
      *                STORED PROCEDURE:  CSR04458                      00190002
      ******************************************************************00191002
      *  CSR04458 CLONED FROM SP CSR02222 ON 05/15/2012.               *00200001
      *  FOR RATE MANAGEMENT MODULE.                                   *00210001
      *                                                                *00250000
      ******************************************************************00260000
      *                 P R O G R A M  S U M M A R Y                   *00270000
      *                                                                *00280000
      *  USED TO RETRIEVE DATA FROM DATABASE TO POPULATE COMPONENT     *00310001
      *  AND PRICING STEP OF RATE WIZARD FOR UNMETERED RATE.           *00320001
      ******************************************************************00320102
      *  INPUT PARAMETERS                                              *00321002
      *  -------------------                                           *00322002
      *  APPL_PROG_ID         CHAR(03)                                 *00323002
      *  USER_ID              CHAR(07)                                 *00323102
      *  CODE_UTIL_TYPE       CHAR(01)                                 *00330802
      *  RATE_PLAN_NO         CHAR(03)                                 *00330902
      *  VERSION_NO_CNTRL     SMALLINT                                 *00331002
      *                                                                *00331102
      *  OUTPUT PARAMETERS                                             *00331202
      *  -------------------------                                     *00331302
      *  RETURN_CODE          INTEGER                                  *00331402
      *  APPL_RETURN_CODE     INTEGER                                  *00331502
      *  RATE_ITEM_CODE       SMALLINT                                 *00331602
      *  UM_EQUIP_ID          CHAR(02)                                 *00331702
      *  PRICE_PER_SERV       DECIMAL(9,6)                             *00331802
      *  UM_EQUIP_KWH         INTEGER                                  *00331902
      *  CUST_PER_SERVICE     SMALLINT                                 *00332002
      *                                                                *00332102
      ******************************************************************00333000
      *                                                                *00340000
      *                     PROGRAM MODIFICATION LOG                   *00350000
      *                                                                *00360000
      *    DATE    INITIALS   COMMENTS                                 *00370000
      *  --------  --------   ---------------------------------------  *00380000
      *  05/15/12  MS93554    NEW PROGRAM                              *00390001
      ******************************************************************00530000
      ******************************************************************00540000
      *                                                                *00550000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00560000
      *                                                                *00570000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00580000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00590000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00600000
      *  3000 - 4999  NOT USED                                         *00610000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00620000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00630000
      *  7000 - 7999  INPUT MODULES                                    *00640000
      *  8000 - 8999  OUTPUT MODULES                                   *00650000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00660000
      *                                                                *00670000
      ******************************************************************00680000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04458'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04458 STARTS HERE'.                  
                                                                        
      ******************************************************************00770000
      *    DB2 INCLUDES                                                *00780000
      ******************************************************************00790000
           EXEC SQL                                                     00810000
              INCLUDE SQLCA                                             00820000
           END-EXEC.                                                    00830000
                                                                        
      ******************************************************************00850002
      *    CSS_UNMTR_PLAN   UP                                         *00860002
      ******************************************************************00870002
           EXEC SQL                                                     00890000
              INCLUDE TBUMPLAN                                          00900000
           END-EXEC.                                                    00910000
                                                                        
      ******************************************************************00921002
      *    CSS_UM_EQUIPMENT L9                                         *00922002
      ******************************************************************00923002
           EXEC SQL                                                     00930000
              INCLUDE TBUMEQP                                           00940000
           END-EXEC.                                                    00950000
                                                                        
      ******************************************************************00970002
      *  COBOL WORKING STORAGE COPY BOOKS                              *00980002
      ******************************************************************00990000
                                                                        
      ******************************************************************01010002
      *  COMMON SYSTEM AREA                                            *01020002
      ******************************************************************01030002
           COPY CCA00001.                                               01070000
      ******************************************************************01080002
      *  ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                *01090002
      ******************************************************************01100002
           COPY CWS00027.                                               01110000
      ******************************************************************01120002
      *  SUPPORTS DB2 AND SQL ERROR CHECKING                           *01121002
      ******************************************************************01122002
           COPY CWS00303.                                               01130000
      ******************************************************************01131002
      *  ERROR HANDLING                                              *  01132002
      ******************************************************************01133002
           EXEC SQL                                                     01134002
              INCLUDE CWSX0010                                          01135002
           END-EXEC.                                                    01136002
                                                                        
      ******************************************************************01150000
      *    WORK AREAS                                                  *01160000
      ******************************************************************01170000
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04458'.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(9) COMP VALUE 0.          
           05  S-RATE-ITEM-CODE        PIC S9(4) USAGE COMP.            
           05  S-UM-EQUIP-ID           PIC X(02) VALUE SPACE.           
           05  S-PRICE-PER-SERV        PIC S9(3)V9(6) USAGE COMP-3      
                                                 VALUE 0.               
           05  S-UM-EQUIP-KWH          PIC S9(9) USAGE COMP.            
           05  S-CUST-PER-SERVICE      PIC S9(4) USAGE COMP.            
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
                                                                        
      ******************************************************************01980000
      *    CURSOR DECLARATIONS                                         *01990000
      ******************************************************************02000000
                                                                        
      ******************************************************************02001001
      *  CURSOR DECLARATION TO FETCH UNMETER COMPONENT ROWS.           *02002001
      ******************************************************************02003001
                                                                        
           EXEC SQL DECLARE UNMTR_CMPNT_CUR CURSOR FOR                  
               SELECT UP.RATE_ITEM_CODE                                 
                     ,UM.UM_EQUIP_ID                                    
                     ,UP.PRICE_PER_SERV                                 
                     ,UM.UM_EQUIP_KWH                                   
                     ,UP.CUST_PER_SERVICE                               
                 FROM CSS_UNMTR_PLAN   UP WITH(READUNCOMMITTED)                 
                     ,CSS_UM_EQUIPMENT UM WITH(READUNCOMMITTED)                 
                WHERE UP.CODE_UTIL_TYPE    = :UP-CODE-UTIL-TYPE         
                  AND UP.RATE_PLAN_NO      = :UP-RATE-PLAN-NO           
                  AND UP.VERSION_NO_CNTRL  = :UP-VERSION-NO-CNTRL       
                  AND UM.UM_EQUIP_ID       =  UP.UM_EQUIP_ID            
                ORDER BY UP.RATE_ITEM_CODE                              
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UNMTR_CMPNT_CUR CURSOR FOR                  02040001
MFA-TR*        SELECT UP.RATE_ITEM_CODE                                 02050001
MFA-TR*              ,UM.UM_EQUIP_ID                                    02060001
MFA-TR*              ,UP.PRICE_PER_SERV                                 02070001
MFA-TR*              ,UM.UM_EQUIP_KWH                                   02080001
MFA-TR*              ,UP.CUST_PER_SERVICE                               02090001
MFA-TR*          FROM CSS_UNMTR_PLAN   UP                               02100001
MFA-TR*              ,CSS_UM_EQUIPMENT UM                               02110001
MFA-TR*         WHERE UP.CODE_UTIL_TYPE    = :UP-CODE-UTIL-TYPE         02120003
MFA-TR*           AND UP.RATE_PLAN_NO      = :UP-RATE-PLAN-NO           02130003
MFA-TR*           AND UP.VERSION_NO_CNTRL  = :UP-VERSION-NO-CNTRL       02140003
MFA-TR*           AND UM.UM_EQUIP_ID       =  UP.UM_EQUIP_ID            02150001
MFA-TR*         ORDER BY UP.RATE_ITEM_CODE                              02160001
MFA-TR*           FOR FETCH ONLY WITH UR                                02160101
MFA-TR*       QUERYNO 7000                                              02161001
MFA-TR*    END-EXEC.                                                    02170000
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID        PIC X(03).                          
       01  PARM-USER-ID             PIC X(07).                          
       01  PARM-CODE-UTIL-TYPE      PIC X(01).                          
       01  PARM-RATE-PLAN-NO        PIC X(03).                          
       01  PARM-VERSION-NO-CNTRL    PIC S9(04) USAGE COMP.              
                                                                        
       PROCEDURE DIVISION USING  PARM-APPL-PROG-ID                      
                                ,PARM-USER-ID                           
                                ,PARM-CODE-UTIL-TYPE                    
                                ,PARM-RATE-PLAN-NO                      
                                ,PARM-VERSION-NO-CNTRL.                 
                                                                        
      ******************************************************************02800000
      *                                                                *02801002
      * 0000-MAINLINE.                                                 *02810002
      ******************************************************************02880000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03000000
      *                                                                *03001002
      * 0100-INITIALIZE.                                               *03010002
      ******************************************************************03120000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT           THRU 0100A-EXIT.         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03441002
      *                                                                *03442002
      * 0100A-DECLARE-GTT.                                             *03443002
      ******************************************************************03444002
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04458_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04458_R1
              (                                                          
               RETURN_CODE          INT                             
              ,APPL_RETURN_CODE     INT                             
              ,RATE_ITEM_CODE       SMALLINT                            
              ,UM_EQUIP_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,PRICE_PER_SERV       DECIMAL(9,6)                        
              ,UM_EQUIP_KWH         INT                             
              ,CUST_PER_SERVICE     SMALLINT                            
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR04458_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
               SELECT RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,RATE_ITEM_CODE                                    
                     ,LTRIM(RTRIM(UM_EQUIP_ID))     AS UM_EQUIP_ID             
                     ,PRICE_PER_SERV                                    
                     ,UM_EQUIP_KWH                                      
                     ,CUST_PER_SERVICE                                  
                 FROM #CSR04458_R1                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     03791002
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                         03792002
MFA-TR*        SELECT RETURN_CODE                                       03793002
MFA-TR*              ,APPL_RETURN_CODE                                  03795002
MFA-TR*              ,RATE_ITEM_CODE                                    03796002
MFA-TR*              ,STRIP(UM_EQUIP_ID)     AS UM_EQUIP_ID             03797002
MFA-TR*              ,PRICE_PER_SERV                                    03798002
MFA-TR*              ,UM_EQUIP_KWH                                      03799002
MFA-TR*              ,CUST_PER_SERVICE                                  03799102
MFA-TR*          FROM SESSION.CSR04458_R1                               03799302
MFA-TR*    END-EXEC.                                                    03799402
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************03840000
      *                                                                *03841002
      * 1000-PROCESS-INPUT                                             *03850000
      ******************************************************************03910000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO UP-CODE-UTIL-TYPE.       
           MOVE PARM-RATE-PLAN-NO           TO UP-RATE-PLAN-NO.         
           MOVE PARM-VERSION-NO-CNTRL       TO UP-VERSION-NO-CNTRL.     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04540000
      *                                                                *04541002
      * 2000-PROCESS-OUTPUT.                                           *04550000
      ******************************************************************04640000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-BUILD-RESULT           THRU 2100-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07840000
      *                                                                *07841002
      * 2100-BUILD-RESULT                                              *07850003
      ******************************************************************07920000
       2100-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-OPEN-UNMTR-CMPNT-CUR   THRU 7000-EXIT.          
           PERFORM 7100-FETCH-UNMTR-CMPNT-CUR  THRU 7100-EXIT.          
           PERFORM 2200-MOVE-RESULT-SET        THRU 2200-EXIT           
                                              UNTIL NO-MORE-ROWS.       
           PERFORM 7200-CLOSE-UNMTR-CMPNT-CUR  THRU 7200-EXIT.          
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                         TO S-RETURN-CODE         
              MOVE   0                         TO S-APPL-RETURN-CODE    
              PERFORM 8100-SEND-RESULT            THRU 8100-EXIT        
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08160000
      *                                                                *08161002
      * 2200-MOVE-RESULT-SET.                                          *08170003
      ******************************************************************08250000
       2200-MOVE-RESULT-SET.                                            
                                                                        
           MOVE UP-RATE-ITEM-CODE           TO S-RATE-ITEM-CODE.        
           MOVE L9-UM-EQUIP-ID              TO S-UM-EQUIP-ID.           
           MOVE UP-PRICE-PER-SERV           TO S-PRICE-PER-SERV.        
           MOVE L9-UM-EQUIP-KWH             TO S-UM-EQUIP-KWH.          
           MOVE UP-CUST-PER-SERVICE         TO S-CUST-PER-SERVICE.      
                                                                        
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
           PERFORM 7100-FETCH-UNMTR-CMPNT-CUR  THRU 7100-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08950000
      *                                                                *08951002
      * 7000-OPEN-UNMTR-CMPNT-CUR                                      *08960003
      ******************************************************************09030000
       7000-OPEN-UNMTR-CMPNT-CUR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN UNMTR_CMPNT_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7700'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE 'CSS_UNMTR_PLAN'         TO TABLE-1                  
              MOVE 'CSS_UM_EQUIPMENT'       TO TABLE-2                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'VERSION_NO_CNTRL'       TO TABLE-ELEMENT-3          
              MOVE UP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE UP-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE UP-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09341003
      *                                                                *09342003
      * 7100-FETCH-UNMTR-CMPNT-CUR                                     *09343003
      ******************************************************************09344003
       7100-FETCH-UNMTR-CMPNT-CUR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH UNMTR_CMPNT_CUR                                     
               INTO :UP-RATE-ITEM-CODE                                  
                   ,:L9-UM-EQUIP-ID                                     
                   ,:UP-PRICE-PER-SERV                                  
                   ,:L9-UM-EQUIP-KWH                                    
                   ,:UP-CUST-PER-SERVICE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7100'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE 'CSS_UNMTR_PLAN'   TO TABLE-1                  
                    MOVE 'CSS_UM_EQUIPMENT' TO TABLE-2                  
                    MOVE 'CODE_UTIL_TYPE'   TO TABLE-ELEMENT-1          
                    MOVE 'RATE_PLAN_NO'     TO TABLE-ELEMENT-2          
                    MOVE 'VERSION_NO_CNTRL' TO TABLE-ELEMENT-3          
                    MOVE UP-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-1        
                    MOVE UP-RATE-PLAN-NO    TO HOSTVAR-ELEMENT-2        
                    MOVE UP-VERSION-NO-CNTRL TO HOSTVAR-ELEMENT-3       
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09352300
      *                                                                *09353002
      * 7200-CLOSE-UNMTR_CMPNT_CUR                                     *09360003
      ******************************************************************09430000
       7200-CLOSE-UNMTR-CMPNT-CUR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE UNMTR_CMPNT_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE       EQUAL SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_UNMTR_PLAN'         TO TABLE-1                  
              MOVE 'CSS_UM_EQUIPMENT'       TO TABLE-2                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'VERSION_NO_CNTRL'       TO TABLE-ELEMENT-3          
              MOVE UP-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE UP-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE UP-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09732003
      * 8000A-DEL-GTT-ROWS.                                           * 09733003
      ***************************************************************** 09734003
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04458_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     09737003
MFA-TR*        DELETE FROM SESSION.CSR04458_R1                          09738003
MFA-TR*    END-EXEC.                                                    09739003

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04458_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************10611002
      *                                                                *10612002
      * 8100-SEND-RESULT.                                              *10613003
      ******************************************************************10614002
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04458_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,RATE_ITEM_CODE                                            
             ,UM_EQUIP_ID                                               
             ,PRICE_PER_SERV                                            
             ,UM_EQUIP_KWH                                              
             ,CUST_PER_SERVICE                                          
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-APPL-RETURN-CODE                                       
             ,:S-RATE-ITEM-CODE                                         
             ,:S-UM-EQUIP-ID                                            
             ,:S-PRICE-PER-SERV                                         
             ,:S-UM-EQUIP-KWH                                           
             ,:S-CUST-PER-SERVICE                                       
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     10616002
MFA-TR*      INSERT INTO SESSION.CSR04458_R1                            10617002
MFA-TR*      (                                                          10618002
MFA-TR*       RETURN_CODE                                               10619002
MFA-TR*      ,APPL_RETURN_CODE                                          10619103
MFA-TR*      ,RATE_ITEM_CODE                                            10619203
MFA-TR*      ,UM_EQUIP_ID                                               10619303
MFA-TR*      ,PRICE_PER_SERV                                            10619403
MFA-TR*      ,UM_EQUIP_KWH                                              10619503
MFA-TR*      ,CUST_PER_SERVICE                                          10619603
MFA-TR*      )                                                          10619803
MFA-TR*      VALUES                                                     10619903
MFA-TR*      (                                                          10620003
MFA-TR*       :S-RETURN-CODE                                            10620103
MFA-TR*      ,:S-APPL-RETURN-CODE                                       10620204
MFA-TR*      ,:S-RATE-ITEM-CODE                                         10620303
MFA-TR*      ,:S-UM-EQUIP-ID                                            10620403
MFA-TR*      ,:S-PRICE-PER-SERV                                         10620503
MFA-TR*      ,:S-UM-EQUIP-KWH                                           10620603
MFA-TR*      ,:S-CUST-PER-SERVICE                                       10620703
MFA-TR*      )                                                          10620903
MFA-TR*    END-EXEC.                                                    10621003

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              ADD 1                         TO CTR-ROWS                 
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE '8100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'CSR04458_R1'            TO TABLE-1                  
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10623003
      *                                                                *10623103
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *10623203
      ******************************************************************10623303
           EXEC SQL                                                     10623403
              INCLUDE CPDSP300                                          10623503
           END-EXEC.                                                    10623603
                                                                        
      ******************************************************************10623803
      *       END PROGRAM COPYLIB                                      *10623903
      ******************************************************************10624003
           EXEC SQL                                                     10625003
               INCLUDE CPD00320                                         10630000
           END-EXEC.                                                    10640000
                                                                        
