       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04457.                                         
COB303 DATE-WRITTEN.  JUNE 6, 2012.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000100
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *        
      *  CSR04457 CLONED FROM SP'S CSR02221/CSR02008/CSR02009/CSR02056 *        
      *  TO UPDATE RATE COMPONENT & PRICING DETAILS                    *        
      *                                                                *00090000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE UPDATE/INSERT/DELETE ROWS IN COMP_DEF,         *00190000
      *  PRICE_SCHED, TOU_INSTR & DEMAND_RATCHET TABLES.               *00190000
      ******************************************************************00200000
      *                                                                *00210000
      *                     PROGRAM MODIFICATION LOG                   *00220000
      *                                                                *00230000
      *    DATE    INITIALS   COMMENTS                                 *00240000
      *  --------  --------   ---------------------------------------  *00250000
      *  06/06/12  HA7A338    PROCEDURE ORIGINALLY CODED.              *00260000
      *  09/15/16  DB41297    REMOVE CSS_RATE_MIN                      *00260000
      *                                                                *00270000
      ******************************************************************00280000
      ******************************************************************00290000
      *                                                                *00300000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00310000
      *                                                                *00320000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00330000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00340000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00350000
      *  3000 - 4999  NOT USED                                         *00360000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00370000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00380000
      *  7000 - 7999  INPUT MODULES                                    *00390000
      *  8000 - 8999  OUTPUT MODULES                                   *00400000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00410000
      *                                                                *00420000
      ******************************************************************00430000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04457'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04457 STARTS HERE'.                  
                                                                        
      ******************************************************************00520000
      *    DB2 INCLUDES                                                *00530000
      ******************************************************************00540000
                                                                        
           EXEC SQL                                                     00560000
              INCLUDE SQLCA                                             00570000
           END-EXEC.                                                    00580000
                                                                        
      *--------< CSS_RATE_VRSN_DEF  J4 >                                00631000
                                                                        
           EXEC SQL                                                     00633000
              INCLUDE TBRTVRSN                                          00634000
           END-EXEC.                                                    00635000
                                                                        
      *--------< CSS_RATE_COMP_DEF  J1 >                                00631000
                                                                        
           EXEC SQL                                                     00633000
              INCLUDE TBRTCDEF                                          00634000
           END-EXEC.                                                    00635000
                                                                        
      *--------< CSS_DEMAND_INSTR   DI >                                00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBDMDINS                                          00700000
           END-EXEC.                                                    00710000
                                                                        
      *--------< CSS_RATE_TOU_DEF   RJ >                                00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBRTTOUD                                          00700000
           END-EXEC.                                                    00710000
                                                                        
      *--------< CSS_PRICE_SCHED    PS >                                00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBPRCSCH                                          00700000
           END-EXEC.                                                    00710000
                                                                        
      *--------< CSS_RATE_TOU_INSTR RK >                                00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBRTTOU                                           00700000
           END-EXEC.                                                    00710000
                                                                        
      *--------< CSS_DEMAND_RATCHET J2 >                                00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBDEMRCH                                          00700000
           END-EXEC.                                                    00710000
                                                                        
                                                                        
      ******************************************************************00740000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00750000
      ******************************************************************00760000
                                                                        
      *--------<COMMON SYSTEM AREA >                                    00830000
           COPY CCA00001.                                               00840000
                                                                        
      *--------< ERROR WORK AREA - ERROR HANDLING COPY BOOK >           00870000
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       00870000
           COPY CWS00027.                                               00880000
                                                                        
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  00890000
           COPY CWS00303.                                               00900000
                                                                        
      ******************************************************************00920000
      *    WORK AREAS                                                  *00930000
      ******************************************************************00940000
       01  WS-MISC.                                                     
           05  PROGRAM-NAME               PIC X(08)   VALUE 'CSR04457'. 
           05  ALL-DONE-SW                PIC X(01)   VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW               PIC X(01)   VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
           05  WS-COMP-DEF-INFO.                                        
               10 WS-COMP-DEF-LEN         PIC S9(4)   COMP.             
               10 WS-COMP-DEF-TXT         PIC X(92)   VALUE SPACES.     
           05  WS-COMP-PRC-SCHD-INFO.                                   
               10 WS-COMP-PRC-SCHD-LEN    PIC S9(4)   COMP.             
               10 WS-COMP-PRC-SCHD-TXT    PIC X(6030) VALUE SPACES.     
           05  WS-DMND-RTCHT-INFO.                                      
               10 WS-DMND-RTCHT-LEN       PIC S9(4)   COMP.             
               10 WS-DMND-RTCHT-TXT       PIC X(57)   VALUE SPACES.     
           05  WS-RATCHET-ID              PIC X(04)   VALUE SPACES.     
                                                                        
       01  WS-AMOUNT-FIELDS.                                            
           05  WS-AMT-CUST-CHRG           PIC X(07)  VALUE SPACES.      
           05  WS-AMT-CUST-CHRG-N         REDEFINES                     
               WS-AMT-CUST-CHRG           PIC S9(05)V9(2).              
COB305     05 WS-J4-AMT-CUST-CHRG        PIC S9(05)V9(2) COMP-3 VALUE 0.     
COB305     05 WS-AMT-MIN-CHRG        PIC S9(11)V9(2) COMP-3 VALUE 0.     
COB305     05 WS-QTY-MIN-USAGE        PIC S9(11)V9(2) COMP-3 VALUE 0.     
COB305     05 WS-MIN-DMD-CHRG        PIC S9(11)V9(2) COMP-3 VALUE 0.     
COB305     05 WS-MIN-DMD-QTY        PIC S9(11)V COMP-3 VALUE 0.     
COB305     05 WS-PWR-FCTR-MIN-PCT        PIC S9(02)V9(3) COMP-3 VALUE 0.     
COB305     05 WS-LFTM-PEAK-PCT        PIC S9(03)V9(2) COMP-3 VALUE 0.     
COB305     05 WS-LD-FCTR-MIN-PCT        PIC S9(02)V9(3) COMP-3 VALUE 0.     
COB305     05 WS-PS-SCHED-PRICE-AMT        PIC S9(11) COMP-3 VALUE 0.     
COB305     05 WS-SCHED-PRICE-AMT        PIC S9(05)V9(6) COMP-3 VALUE 0.     
COB305     05 WS-SCHED-WNA-RATE-AMT        PIC S9(01)V9(5) COMP-3 
COB305       VALUE 0.     
COB305     05 WS-CNTRCT-MIN-IP-PCT        PIC S9(03)V9(2) COMP-3 
COB305       VALUE 0.     
COB305     05 WS-CNTRCT-MIN-PCT        PIC S9(02)V9(3) COMP-3 VALUE 0.     
COB305     05 WS-RATCHET-IP-PCT        PIC S9(03)V9(2) COMP-3 VALUE 0.     
COB305     05 WS-RATCHET-PCT        PIC S9(02)V9(3) COMP-3 VALUE 0.     
                                                                        
       01  WS-FLAGS-LTRLS.                                              
           05  WS-DMND-INSTR-EXISTS       PIC X(01)      VALUE 'N'.     
           05  WS-PRC-SCHD-EXISTS         PIC X(01)      VALUE 'N'.     
           05  WS-RTCHT-EXISTS            PIC X(01)      VALUE 'N'.     
           05  WS-DMND-EXISTS             PIC X(01)      VALUE 'N'.     
           05  WS-INSERT                  PIC X(01)      VALUE 'I'.     
           05  WS-UPDATE                  PIC X(01)      VALUE 'U'.     
           05  WS-DELETE                  PIC X(01)      VALUE 'D'.     
           05  WS-YES                     PIC X(01)      VALUE 'Y'.     
           05  WS-NO                      PIC X(01)      VALUE 'N'.     
           05  WS-DEMAND                  PIC X(01)      VALUE 'D'.     
           05  WS-DAILY-READ-D            PIC X(01)      VALUE 'D'.     
           05  WS-HOURLY-READ-H           PIC X(01)      VALUE 'H'.     
           05  WS-SINGLE-READ-B           PIC X(01)      VALUE 'B'.     
           05  WS-ON-OFF-PEAK-READ-2      PIC X(01)      VALUE '2'.     
           05  WS-INTRVL-DATA-READ-I      PIC X(01)      VALUE 'I'.     
           05  WS-ON-OFF-SHOULDER-READ-3  PIC X(01)      VALUE '3'.     
           05  WS-READ                    PIC X(01)      VALUE ' '.     
               88 WS-DAILY-READ                          VALUE 'D'.     
               88 WS-HOURLY-READ                         VALUE 'H'.     
               88 WS-SINGLE-READ                         VALUE 'B'.     
               88 WS-ON-OFF-PEAK-READ                    VALUE '2'.     
               88 WS-INTRVL-DATA-READ                    VALUE 'I'.     
               88 WS-ON-OFF-SHOULDER-READ                VALUE '3'.     
           05  WS-MAX-CODE-TIME-PERIOD    PIC S9(4) COMP VALUE  00.     
           05  WS-CODE-TIME-PRD-NULL-ID   PIC S9(4) COMP VALUE  00.     
           05  WS-J1-MAX-ROW-COUNT        PIC S9(4) COMP VALUE  10.     
           05  WS-PS-RK-MAX-ROW-COUNT     PIC S9(4) COMP VALUE  10.     
           05  WS-PS-BLK-MAX-ROW-COUNT    PIC S9(4) COMP VALUE  10.     
           05  WS-J2-MAX-ROW-COUNT        PIC S9(4) COMP VALUE  03.     
                                                                        
       01  WS-COMP-PRC-LAYOUT.                                          
           05 WS-COMP-PRC-DATA OCCURS 10  TIMES INDEXED BY              
                                          WS-COMP-PRC-INDX.             
              10 WS-COMP-DEF              PIC X(92)   VALUE SPACES.     
              10 WS-PRC-SCHD              PIC X(6030) VALUE SPACES.     
                                                                        
       01  WS-CSR04457-LAYOUT.                                          
           05  WS-J1-PS-RK-DATA.                                        
             10 WS-J1-PS-RK OCCURS 10 TIMES INDEXED BY                  
                                          WS-COMP-DEF-INDX.             
               15 WS-J1-ACTION-IND        PIC X(01)  VALUE SPACES.      
               15 WS-J1-CMPNT-ID-CD       PIC X(02)  VALUE SPACES.      
               15 WS-J1-REG-TYPE-CD       PIC X(01)  VALUE SPACES.      
               15 WS-J1-ENERGY-UNIT-CD    PIC X(01)  VALUE SPACES.      
               15 WS-J1-ENERGY-SEAS-CD    PIC X(01)  VALUE SPACES.      
               15 WS-J1-LAST-ENERGY-BLOCK PIC X(04)  VALUE SPACES.      
               15 WS-J1-LAST-ENRGY-BLCK-N REDEFINES                     
                  WS-J1-LAST-ENERGY-BLOCK PIC S9(04).                   
               15 WS-J1-DEM-REG-TYPE-CD   PIC X(01)  VALUE SPACES.      
               15 WS-J1-DEM-UNIT-CD       PIC X(01)  VALUE SPACES.      
               15 WS-J1-DEM-SEASON-CD     PIC X(01)  VALUE SPACES.      
               15 WS-J1-LAST-DEM-BLOCK    PIC X(04)  VALUE SPACES.      
               15 WS-J1-LAST-DEM-BLCK-N   REDEFINES                     
                  WS-J1-LAST-DEM-BLOCK    PIC S9(04).                   
               15 WS-RM-AMT-MIN-CHRG      PIC X(13)  VALUE SPACES.      
               15 WS-RM-AMT-MIN-CHRG-N    REDEFINES                     
                  WS-RM-AMT-MIN-CHRG      PIC S9(13).                   
               15 WS-RM-QTY-MIN-USAGE     PIC X(13)  VALUE SPACES.      
               15 WS-RM-QTY-MIN-USAGE-N   REDEFINES                     
                  WS-RM-QTY-MIN-USAGE     PIC S9(13).                   
               15 WS-DI-MIN-DMD-CHRG      PIC X(13)  VALUE SPACES.      
               15 WS-DI-MIN-DMD-CHRG-N    REDEFINES                     
                  WS-DI-MIN-DMD-CHRG      PIC S9(13).                   
               15 WS-DI-MIN-DMD-QTY       PIC X(11)  VALUE SPACES.      
               15 WS-DI-MIN-DMD-QTY-N     REDEFINES                     
                  WS-DI-MIN-DMD-QTY       PIC S9(11).                   
               15 WS-DI-PWR-FCTR-MIN-PCT  PIC X(05)  VALUE SPACES.      
               15 WS-DI-PWR-FCT-MIN-PCT-N REDEFINES                     
                  WS-DI-PWR-FCTR-MIN-PCT  PIC S9(5).                    
               15 WS-DI-LFTM-PEAK-PCT     PIC X(05)  VALUE SPACES.      
               15 WS-DI-LFTM-PEAK-PCT-N   REDEFINES                     
                  WS-DI-LFTM-PEAK-PCT     PIC S9(5).                    
               15 WS-DI-LD-FCTR-MIN-PCT   PIC X(05)  VALUE SPACES.      
               15 WS-DI-LD-FCTR-MIN-PCT-N REDEFINES                     
                  WS-DI-LD-FCTR-MIN-PCT   PIC S9(5).                    
               15 WS-J1-RTP-BASELINE-RATE PIC X(03)  VALUE SPACES.      
               15 WS-J1-BAL-FWD-CD        PIC X(01)  VALUE SPACES.      
               15 WS-J1-BAL-RESET-MMDD    PIC X(04)  VALUE SPACES.      
               15 WS-J1-BAL-RESET-MMDD-N  REDEFINES                     
                  WS-J1-BAL-RESET-MMDD    PIC S9(4).                    
               15 WS-J1-BAL-RESET-PRO-CD  PIC X(01)  VALUE SPACES.      
               15 WS-J1-BAL-OFFSET-TOU-CD PIC X(01)  VALUE SPACES.      
               15 WS-PRC-GROUP-N-TOU OCCURS 10 TIMES INDEXED BY         
                                            WS-PRC-GRP-INDX.            
                 20 WS-PS-ACTION-IND        PIC X(01)  VALUE SPACES.    
                 20 WS-PS-CMPNT-ID-CD       PIC X(02)  VALUE SPACES.    
                 20 WS-PS-CODE-SEASON       PIC X(01)  VALUE SPACES.    
                 20 WS-PS-CODE-TIME-PERIOD  PIC X(04)  VALUE SPACES.    
                 20 WS-PS-CODE-TIME-PRD-N   REDEFINES                   
                    WS-PS-CODE-TIME-PERIOD  PIC S9(4).                  
                 20 WS-PS-CD-USE-INST-TYPE  PIC X(01)  VALUE SPACES.    
                 20 WS-RK-RATE-MIN-IND      PIC X(01)  VALUE SPACES.    
                 20 WS-RK-CNTRCT-MIN-IND    PIC X(01)  VALUE SPACES.    
                 20 WS-RK-MAX-DEMAND-IND    PIC X(01)  VALUE SPACES.    
                 20 WS-RK-RATCHET-ID-1      PIC X(01)  VALUE SPACES.    
                 20 WS-RK-RATCHET-ID-2      PIC X(01)  VALUE SPACES.    
                 20 WS-RK-RATCHET-ID-3      PIC X(01)  VALUE SPACES.    
                 20 WS-RK-MRG-OFF-PK-IND    PIC X(01)  VALUE SPACES.    
                 20 WS-RK-MRG-CTR-MIN-IND   PIC X(01)  VALUE SPACES.    
                 20 WS-RK-MRG-RT-MIN        PIC X(01)  VALUE SPACES.    
                 20 WS-RK-CNTRCT-MIN-PCT    PIC X(05)  VALUE SPACES.    
                 20 WS-RK-CNTRCT-MIN-PCT-N  REDEFINES                   
                    WS-RK-CNTRCT-MIN-PCT    PIC 9(03)V99.               
                 20 WS-BLOCK-DETAILS OCCURS 10 TIMES INDEXED BY         
                                            WS-BLK-DTLS-INDX.           
                   25 WS-PS-BCK-DESC          PIC X(30)  VALUE SPACES.  
                   25 WS-PS-BCK-USE-OR-SVC    PIC X(09)  VALUE SPACES.  
                   25 WS-PS-BCK-USE-OR-SVC-N  REDEFINES                 
                      WS-PS-BCK-USE-OR-SVC    PIC S9(9).                
                   25 WS-PS-SCHED-PRICE-AM    PIC X(12)  VALUE SPACES.  
                   25 WS-PS-PRICE-TYPE-CD     PIC X(01)  VALUE SPACES.  
                   25 WS-PS-SHD-WNA-RT-AMT    PIC X(06)  VALUE SPACES.  
                   25 WS-PS-SHD-WNA-RT-AMT-N  REDEFINES                 
                      WS-PS-SHD-WNA-RT-AMT    PIC S9(6).                
           05  WS-DMND-RTCHT.                                           
             10 WS-DMND-RTCHT-DATA OCCURS 03 TIMES INDEXED BY           
                                           WS-DMND-RTCHT-INDX.          
               15 WS-J2-ACTION-IND        PIC X(01)  VALUE SPACES.      
               15 WS-J2-RATCHET-ID        PIC X(04)  VALUE SPACES.      
               15 WS-J2-RATCHET-ID-N      REDEFINES                     
                  WS-J2-RATCHET-ID        PIC S9(4).                    
               15 WS-J2-FROM-MONTH        PIC X(04)  VALUE SPACES.      
               15 WS-J2-FROM-MONTH-N      REDEFINES                     
                  WS-J2-FROM-MONTH        PIC S9(4).                    
               15 WS-J2-TO-MONTH          PIC X(04)  VALUE SPACES.      
               15 WS-J2-TO-MONTH-N        REDEFINES                     
                  WS-J2-TO-MONTH          PIC S9(4).                    
               15 WS-J2-RATCHET-PCT       PIC X(05)  VALUE SPACES.      
               15 WS-J2-RATCHET-PCT-N     REDEFINES                     
                  WS-J2-RATCHET-PCT       PIC S9(5).                    
               15 WS-J2-RATCHET-YR-IND    PIC X(01)  VALUE SPACES.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                   PIC S9(09) COMP VALUE 0.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(09) COMP VALUE 0.      
           05  S-APPL-RETURN-CODE         PIC S9(09) COMP VALUE 0.      
           05  S-RATE-PLAN-NO             PIC  X(03) VALUE SPACES.      
           05  S-ERR-CMPNT-ID-CD          PIC  X(02) VALUE SPACES.      
           05  S-ERR-RATCHET-ID           PIC  X(04) VALUE SPACES.      
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                  PIC X(18)  VALUE SPACES.      
           10  S-SQLCODE                  PIC S9(9)  COMP VALUE 0.      
           10  S-SQLSTATE                 PIC X(05)  VALUE SPACES.      
           10  S-TABLE-NAME               PIC X(18)  VALUE SPACES.      
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L     PIC S9(4)  USAGE COMP.        
               49  S-HOST-VARIABLES-V     PIC X(255).                   
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L      PIC S9(4)  USAGE COMP.        
               49  S-SQL-STATEMENT-V      PIC X(255).                   
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L    PIC S9(4)  USAGE COMP.        
               49  S-SQL-DESCRIPTION-V    PIC X(255).                   
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID              PIC X(03)  .                  
       01  PARM-USER-ID                   PIC X(07)  .                  
       01  PARM-CODE-UTIL-TYPE            PIC X(01)  .                  
       01  PARM-RATE-PLAN-NO              PIC X(03)  .                  
       01  PARM-VERSION-NO-CNTRL          PIC X(04)  .                  
       01  PARM-BSC-FCLTY-CHRG            PIC X(07)  .                  
       01  PARM-COMP-01-DEF               PIC X(94)  .                  
       01  PARM-COMP-01-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-02-DEF               PIC X(94)  .                  
       01  PARM-COMP-02-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-03-DEF               PIC X(94)  .                  
       01  PARM-COMP-03-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-04-DEF               PIC X(94)  .                  
       01  PARM-COMP-04-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-05-DEF               PIC X(94)  .                  
       01  PARM-COMP-05-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-06-DEF               PIC X(94)  .                  
       01  PARM-COMP-06-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-07-DEF               PIC X(94)  .                  
       01  PARM-COMP-07-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-08-DEF               PIC X(94)  .                  
       01  PARM-COMP-08-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-09-DEF               PIC X(94)  .                  
       01  PARM-COMP-09-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-COMP-10-DEF               PIC X(94)  .                  
       01  PARM-COMP-10-PRC-SCHD-N-TOU    PIC X(6032).                  
       01  PARM-DMND-RTCHT-1-3            PIC X(59)  .                  
                                                                        
       PROCEDURE DIVISION USING                                         
                 PARM-APPL-PROG-ID                                      
               , PARM-USER-ID                                           
               , PARM-CODE-UTIL-TYPE                                    
               , PARM-RATE-PLAN-NO                                      
               , PARM-VERSION-NO-CNTRL                                  
               , PARM-BSC-FCLTY-CHRG                                    
               , PARM-COMP-01-DEF                                       
               , PARM-COMP-01-PRC-SCHD-N-TOU                            
               , PARM-COMP-02-DEF                                       
               , PARM-COMP-02-PRC-SCHD-N-TOU                            
               , PARM-COMP-03-DEF                                       
               , PARM-COMP-03-PRC-SCHD-N-TOU                            
               , PARM-COMP-04-DEF                                       
               , PARM-COMP-04-PRC-SCHD-N-TOU                            
               , PARM-COMP-05-DEF                                       
               , PARM-COMP-05-PRC-SCHD-N-TOU                            
               , PARM-COMP-06-DEF                                       
               , PARM-COMP-06-PRC-SCHD-N-TOU                            
               , PARM-COMP-07-DEF                                       
               , PARM-COMP-07-PRC-SCHD-N-TOU                            
               , PARM-COMP-08-DEF                                       
               , PARM-COMP-08-PRC-SCHD-N-TOU                            
               , PARM-COMP-09-DEF                                       
               , PARM-COMP-09-PRC-SCHD-N-TOU                            
               , PARM-COMP-10-DEF                                       
               , PARM-COMP-10-PRC-SCHD-N-TOU                            
               , PARM-DMND-RTCHT-1-3.                                   
                                                                        
      ******************************************************************01870000
      * 0000-MAINLINE                                                  *01880000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01940000
      ******************************************************************01950000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02070000
      * 0100-INITIALIZE                                                *02080000
      *                                                                *02180000
      ******************************************************************02190000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                  :S-RETURN-CODE        AS    RETURN_CODE               
                 ,:S-APPL-RETURN-CODE   AS    APPL_RETURN_CODE          
                 ,:S-RATE-PLAN-NO       AS    RATE_PLAN_NO              
                 ,:S-ERR-CMPNT-ID-CD    AS    ERR_CMPNT_ID_CD           
                 ,:S-ERR-RATCHET-ID     AS    ERR_RATCHET_ID            
             FROM CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*           :S-RETURN-CODE        AS    RETURN_CODE                       
MFA-TR*          ,:S-APPL-RETURN-CODE   AS    APPL_RETURN_CODE                  
MFA-TR*          ,:S-RATE-PLAN-NO       AS    RATE_PLAN_NO                      
MFA-TR*          ,:S-ERR-CMPNT-ID-CD    AS    ERR_CMPNT_ID_CD                   
MFA-TR*          ,:S-ERR-RATCHET-ID     AS    ERR_RATCHET_ID                    
MFA-TR*      FROM SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05132600
      * 2000-PROCESS-OUTPUT.                                           *05132700
      *     1. DESCRIBE RESULT SET                                     *05137000
      *     2. UPDATE DB2 DATA                                         *05138000
      *     3. SEND RESULT SET                                         *05139000
      ******************************************************************05140000
      *                                                                 05150000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 05170000
           PERFORM 5000-UPDATE               THRU 5000-EXIT.            
           ADD 1                             TO   CTR-ROWS.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05630000
      * 5000-UPDATE                                                    *05640000
      *     FORMATS A ROW BASED ON THE PASSED PARAMS AND THEN          *05675000
      *     DETERMINES WHETHER THIS IS AN UPDATE OR AN INSERT OR DELETE*05676000
      *     THEN THE APPROPRIATE PARA IS CALLED TO DO THE INSERT/UPDATE*05677000
      *     /DELETE.                                                   *05678000
      ******************************************************************05679000
                                                                        
       5000-UPDATE.                                                     
                                                                        
           PERFORM 5010-FORMAT-ROW               THRU 5010-EXIT.        
                                                                        
           PERFORM 5075-UPDATE-RATE-VRSN-DEF     THRU 5075-EXIT.        
                                                                        
           PERFORM VARYING WS-COMP-DEF-INDX      FROM 1 BY 1            
                UNTIL WS-COMP-DEF-INDX        >  WS-J1-MAX-ROW-COUNT    
                   OR WS-J1-CMPNT-ID-CD(WS-COMP-DEF-INDX)               
                                              <= SPACES OR LOW-VALUES   
              PERFORM 5100-UPDATE-RATE-COMP-DEF  THRU 5100-EXIT         
                                                                        
              PERFORM VARYING WS-PRC-GRP-INDX    FROM 1 BY 1            
                UNTIL WS-PRC-GRP-INDX         >  WS-PS-RK-MAX-ROW-COUNT 
                   OR                                                   
                    WS-PS-CMPNT-ID-CD(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)
                                              <= SPACES OR LOW-VALUES   
                 PERFORM 5200-UPDATE-PRC-SCHD    THRU 5200-EXIT         
                 IF  WS-PS-CD-USE-INST-TYPE                             
                                     (WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)
                                               = WS-DEMAND              
                    PERFORM 5300-UPDATE-TOU-INSR    THRU 5300-EXIT      
                 END-IF                                                 
              END-PERFORM                                               
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM VARYING WS-DMND-RTCHT-INDX    FROM 1 BY 1            
                UNTIL WS-DMND-RTCHT-INDX      >  WS-J2-MAX-ROW-COUNT    
                   OR WS-J2-RATCHET-ID(WS-DMND-RTCHT-INDX)              
                                              <= SPACES OR LOW-VALUES   
              PERFORM 5400-UPDATE-DMND-RTCHT     THRU 5400-EXIT         
           END-PERFORM.                                                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06020000
      * 5010-FORMAT-ROW                                                *06030000
      *     FORMATS THE GROUP STRING TO ARRAY VARIABLES.               *06080000
      ******************************************************************06090000
                                                                        
       5010-FORMAT-ROW.                                                 
                                                                        
           MOVE  PARM-CODE-UTIL-TYPE         TO J1-CODE-UTIL-TYPE       
                                                J4-CODE-UTIL-TYPE       
                                                DI-CODE-UTIL-TYPE       
                                                RJ-CODE-UTIL-TYPE       
                                                PS-CODE-UTIL-TYPE       
                                                RK-CODE-UTIL-TYPE       
                                                J2-CODE-UTIL-TYPE.      
           MOVE  PARM-RATE-PLAN-NO           TO J1-RATE-PLAN-NO         
                                                J4-RATE-PLAN-NO         
                                                DI-RATE-PLAN-NO         
                                                RJ-RATE-PLAN-NO         
                                                PS-RATE-PLAN-NO         
                                                RK-RATE-PLAN-NO         
                                                J2-RATE-PLAN-NO         
                                                 S-RATE-PLAN-NO.        
           MOVE  PARM-VERSION-NO-CNTRL       TO J1-VERSION-NO-CNTRL     
                                                J4-VERSION-NO-CNTRL     
                                                DI-VERSION-NO-CNTRL     
                                                RJ-VERSION-NO-CNTRL     
                                                PS-VERSION-NO-CNTRL     
                                                RK-VERSION-NO-CNTRL     
                                                J2-VERSION-NO-CNTRL.    
           IF PARM-BSC-FCLTY-CHRG > SPACES                              
              MOVE  PARM-BSC-FCLTY-CHRG      TO WS-AMT-CUST-CHRG        
              MOVE  WS-AMT-CUST-CHRG-N       TO J4-AMT-CUST-CHRG        
           END-IF.                                                      
                                                                        
           MOVE  PARM-COMP-01-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(01).        
           MOVE  PARM-COMP-02-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(02).        
           MOVE  PARM-COMP-03-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(03).        
           MOVE  PARM-COMP-04-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(04).        
           MOVE  PARM-COMP-05-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(05).        
           MOVE  PARM-COMP-06-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(06).        
           MOVE  PARM-COMP-07-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(07).        
           MOVE  PARM-COMP-08-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(08).        
           MOVE  PARM-COMP-09-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(09).        
           MOVE  PARM-COMP-10-DEF            TO WS-COMP-DEF-INFO.       
           MOVE  WS-COMP-DEF-TXT             TO WS-COMP-DEF(10).        
                                                                        
           MOVE  PARM-COMP-01-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(01).        
           MOVE  PARM-COMP-02-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(02).        
           MOVE  PARM-COMP-03-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(03).        
           MOVE  PARM-COMP-04-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(04).        
           MOVE  PARM-COMP-05-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(05).        
           MOVE  PARM-COMP-06-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(06).        
           MOVE  PARM-COMP-07-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(07).        
           MOVE  PARM-COMP-08-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(08).        
           MOVE  PARM-COMP-09-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(09).        
           MOVE  PARM-COMP-10-PRC-SCHD-N-TOU TO WS-COMP-PRC-SCHD-INFO.  
           MOVE  WS-COMP-PRC-SCHD-TXT        TO WS-PRC-SCHD(10).        
                                                                        
           MOVE  WS-COMP-PRC-LAYOUT          TO WS-J1-PS-RK-DATA.       
                                                                        
           MOVE  PARM-DMND-RTCHT-1-3         TO WS-DMND-RTCHT-INFO.     
           MOVE  WS-DMND-RTCHT-TXT           TO WS-DMND-RTCHT.          
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06020000
      * 5020-FORMAT-ROW-COMP-DEF                                       *06030000
      *     FORMATS THE CSS_RATE_COMP_DEF ROW FROM THE PASSED PARAMS   *06080000
      ******************************************************************06090000
                                                                        
       5020-FORMAT-ROW-COMP-DEF.                                        
                                                                        
           MOVE  WS-J1-CMPNT-ID-CD(WS-COMP-DEF-INDX)                    
                                             TO  J1-CMPNT-ID-CD         
                                                 DI-CMPNT-ID-CD         
                                                 RJ-CMPNT-ID-CD.        
           MOVE  WS-J1-REG-TYPE-CD(WS-COMP-DEF-INDX)                    
                                             TO  J1-REG-TYPE-CD.        
           MOVE  WS-J1-ENERGY-UNIT-CD(WS-COMP-DEF-INDX)                 
                                             TO  J1-ENERGY-UNIT-CD.     
           MOVE  WS-J1-ENERGY-SEAS-CD(WS-COMP-DEF-INDX)                 
                                             TO  J1-ENERGY-SEAS-CD.     
           MOVE  WS-J1-LAST-ENRGY-BLCK-N(WS-COMP-DEF-INDX)              
                                             TO  J1-LAST-ENERGY-BLOCK.  
           MOVE  WS-J1-DEM-REG-TYPE-CD(WS-COMP-DEF-INDX)                
                                             TO  J1-DEM-REG-TYPE-CD.    
           MOVE  WS-J1-DEM-UNIT-CD(WS-COMP-DEF-INDX)                    
                                             TO  J1-DEM-UNIT-CD.        
           MOVE  WS-J1-DEM-SEASON-CD(WS-COMP-DEF-INDX)                  
                                             TO  J1-DEM-SEASON-CD.      
           MOVE  WS-J1-LAST-DEM-BLCK-N(WS-COMP-DEF-INDX)                
                                             TO  J1-LAST-DEM-BLOCK.     
           MOVE  WS-J1-BAL-FWD-CD(WS-COMP-DEF-INDX)                     
                                             TO  J1-BAL-FWD-CD.         
           MOVE  WS-J1-BAL-RESET-MMDD-N(WS-COMP-DEF-INDX)               
                                             TO  J1-BAL-RESET-MMDD.     
           MOVE  WS-J1-BAL-RESET-PRO-CD(WS-COMP-DEF-INDX)               
                                             TO  J1-BAL-RESET-PRO-CD.   
           IF WS-J1-BAL-OFFSET-TOU-CD(WS-COMP-DEF-INDX) <= SPACES       
                                                        OR LOW-VALUES   
              MOVE SPACES TO J1-BAL-OFFSET-TOU-CD                       
           ELSE                                                         
              MOVE  WS-J1-BAL-OFFSET-TOU-CD(WS-COMP-DEF-INDX)           
                                             TO  J1-BAL-OFFSET-TOU-CD   
           END-IF.                                                      
           MOVE  SPACES                      TO  J1-ON-PEAK-DAYS.       
           MOVE  SPACES                      TO  J1-CALENDAR-CD.        
           MOVE  WS-J1-RTP-BASELINE-RATE(WS-COMP-DEF-INDX)              
                                             TO  J1-RTP-BASELINE-RATE.  
           MOVE  ZEROES                      TO  DI-DMD-YLD-PR-RTE-LMT. 
                                                                        
           DIVIDE WS-DI-MIN-DMD-CHRG-N(WS-COMP-DEF-INDX)                
               BY 100  GIVING                    WS-MIN-DMD-CHRG.       
           MOVE   WS-MIN-DMD-CHRG            TO  DI-MIN-DMD-CHRG.       
                                                                        
           MOVE   WS-DI-MIN-DMD-QTY-N(WS-COMP-DEF-INDX)                 
                                             TO  DI-MIN-DMD-QTY.        
                                                                        
           DIVIDE WS-DI-PWR-FCT-MIN-PCT-N(WS-COMP-DEF-INDX)             
               BY 1000 GIVING                    WS-PWR-FCTR-MIN-PCT.   
           MOVE   WS-PWR-FCTR-MIN-PCT        TO  DI-PWR-FCTR-MIN-PCT.   
                                                                        
           DIVIDE WS-DI-LFTM-PEAK-PCT-N(WS-COMP-DEF-INDX)               
               BY 10000 GIVING                   WS-LFTM-PEAK-PCT.      
           MOVE   WS-LFTM-PEAK-PCT           TO  DI-LFTM-PEAK-PCT.      
                                                                        
           DIVIDE WS-DI-LD-FCTR-MIN-PCT-N(WS-COMP-DEF-INDX)             
               BY 1000  GIVING                   WS-LD-FCTR-MIN-PCT.    
           MOVE   WS-LD-FCTR-MIN-PCT         TO  DI-LD-FCTR-MIN-PCT.    
                                                                        
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06020000
      * 5030-FORMAT-ROW-PRC-SCHED                                      *06030000
      *     FORMATS THE CSS_PRICE_SCHED PRICE GROUP DETAILS FROM THE   *06080000
      *     PASSED PARM VALUES.                                        *06080000
      ******************************************************************06090000
                                                                        
       5030-FORMAT-ROW-PRC-SCHD.                                        
                                                                        
           MOVE WS-PS-CMPNT-ID-CD(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)    
                                             TO PS-CMPNT-ID-CD          
                                                RK-CMPNT-ID-CD.         
           MOVE WS-PS-CODE-SEASON(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)    
                                             TO PS-CODE-SEASON          
                                                RK-CODE-SEASON.         
           MOVE                                                         
            WS-PS-CODE-TIME-PRD-N(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)    
                                             TO PS-CODE-TIME-PERIOD     
                                                RK-CODE-TIME-PERIOD.    
           MOVE                                                         
            WS-PS-CD-USE-INST-TYPE(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)   
                                             TO PS-CODE-USE-INST-TYPE.  
                                                                        
           MOVE ZEROES                       TO PS-BLOCK-NO.            
                                                                        
       5030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06020000
      * 5035-FORMAT-ROW-BLOCK-DTLS                                     *06030000
      *     FORMATS THE CSS_PRICE_SCHED BLOCK DETAILS FROM THE PASSED  *06080000
      *     PARM VALUES.                                               *06080000
      ******************************************************************06090000
                                                                        
       5035-FORMAT-ROW-BLOCK-DTLS.                                      
                                                                        
           ADD  1                            TO PS-BLOCK-NO.            
           MOVE WS-PS-BCK-DESC                                          
                (WS-COMP-DEF-INDX, WS-PRC-GRP-INDX, WS-BLK-DTLS-INDX)   
                                             TO PS-BLOCK-DESC.          
           MOVE SPACES                       TO PS-LAST-PRICE-DAY-MTH.  
           MOVE SPACES                       TO PS-BEGN-PRICE-DAY-MTH.  
           MOVE 0                            TO PS-ITEM-ID.             
           MOVE SPACES                       TO PS-DATE-PRICE-END.      
           MOVE SPACES                       TO PS-DAYS-PRICE-APPLIES.  
           MOVE WS-PS-BCK-USE-OR-SVC-N                                  
                (WS-COMP-DEF-INDX, WS-PRC-GRP-INDX, WS-BLK-DTLS-INDX)   
                                             TO PS-BLOCK-USE-OR-SVCS.   
           COMPUTE WS-PS-SCHED-PRICE-AMT =                              
             FUNCTION NUMVAL (WS-PS-SCHED-PRICE-AM                      
            (WS-COMP-DEF-INDX, WS-PRC-GRP-INDX, WS-BLK-DTLS-INDX)).     
                                                                        
           DIVIDE WS-PS-SCHED-PRICE-AMT BY 1000000 GIVING               
                                                WS-SCHED-PRICE-AMT.     
           MOVE WS-SCHED-PRICE-AMT           TO PS-SCHED-PRICE-AM.      
                                                                        
           MOVE WS-PS-PRICE-TYPE-CD                                     
                (WS-COMP-DEF-INDX, WS-PRC-GRP-INDX, WS-BLK-DTLS-INDX)   
                                             TO PS-PRICE-TYPE-CD.       
           DIVIDE WS-PS-SHD-WNA-RT-AMT-N                                
               (WS-COMP-DEF-INDX, WS-PRC-GRP-INDX, WS-BLK-DTLS-INDX)    
             BY 100000 GIVING                   WS-SCHED-WNA-RATE-AMT.  
                                                                        
           MOVE WS-SCHED-WNA-RATE-AMT        TO PS-SCHED-WNA-RATE-AMT.  
                                                                        
       5035-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06020000
      * 5040-FORMAT-ROW-TOU-INSR                                       *06030000
      *     FORMATS THE CSS_RATE_TOU_INSTR ROW FROM THE PASSED PARMS   *06080000
      ******************************************************************06090000
                                                                        
       5040-FORMAT-ROW-TOU-INSR.                                        
                                                                        
           MOVE WS-RK-RATE-MIN-IND(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)   
                                             TO RK-RATE-MIN-IND.        
           MOVE WS-RK-CNTRCT-MIN-IND(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX) 
                                             TO RK-CNTRCT-MIN-IND.      
           MOVE WS-RK-MAX-DEMAND-IND(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX) 
                                             TO RK-MAX-DEMAND-IND.      
           MOVE WS-RK-RATCHET-ID-1(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)   
                                             TO RK-RATCHET-ID-1.        
           MOVE WS-RK-RATCHET-ID-2(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)   
                                             TO RK-RATCHET-ID-2.        
           MOVE WS-RK-RATCHET-ID-3(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)   
                                             TO RK-RATCHET-ID-3.        
           MOVE WS-RK-MRG-OFF-PK-IND(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX) 
                                             TO RK-MRG-OFF-PK-IND.      
           MOVE WS-RK-MRG-CTR-MIN-IND(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)
                                             TO RK-MRG-CTR-MIN-IND.     
           MOVE WS-RK-MRG-RT-MIN(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)     
                                             TO RK-MRG-RT-MIN.          
           MOVE WS-RK-CNTRCT-MIN-PCT-N                                  
                                (WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)     
                                             TO WS-CNTRCT-MIN-IP-PCT.   
           DIVIDE WS-CNTRCT-MIN-IP-PCT BY 100 GIVING                    
                                                WS-CNTRCT-MIN-PCT.      
           MOVE WS-CNTRCT-MIN-PCT            TO RK-CNTRCT-MIN-PCT.      
                                                                        
       5040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06020000
      * 5050-FORMAT-ROW-DMND-RTCHT.                                    *06030000
      *     FORMATS THE CSS_DEMAND_RATCHET ROW FROM THE PASSED PARMS.  *06080000
      ******************************************************************06090000
                                                                        
       5050-FORMAT-ROW-DMND-RTCHT.                                      
                                                                        
           MOVE WS-J2-RATCHET-ID(WS-DMND-RTCHT-INDX)                    
                                             TO WS-RATCHET-ID.          
           MOVE WS-J2-RATCHET-ID-N(WS-DMND-RTCHT-INDX)                  
                                             TO J2-RATCHET-ID.          
           MOVE WS-J2-FROM-MONTH-N(WS-DMND-RTCHT-INDX)                  
                                             TO J2-FROM-MONTH.          
           MOVE WS-J2-TO-MONTH-N(WS-DMND-RTCHT-INDX)                    
                                             TO J2-TO-MONTH.            
           MOVE WS-J2-RATCHET-YR-IND(WS-DMND-RTCHT-INDX)                
                                             TO J2-RATCHET-YR-IND.      
           MOVE WS-J2-RATCHET-PCT-N(WS-DMND-RTCHT-INDX)                 
                                             TO WS-RATCHET-IP-PCT.      
           DIVIDE WS-RATCHET-IP-PCT  BY 100 GIVING                      
                                                WS-RATCHET-PCT.         
           DIVIDE WS-RATCHET-PCT     BY 100 GIVING                      
                                                J2-RATCHET-PCT.         
                                                                        
       5050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05630000
      * 5075-UPDATE-RATE-VRSN-DEF                                      *05640000
      * ~~~~~~~~~~~~~~~~~~~~~~~~~                                      *05640000
      * UPDATES RATE_VRSN_DEF TABLE BASED ON PARM VALUE                *05675000
      *   1.UPDATE                                                     *05677000
      *     CSS_RATE_VRSN_DEF - UPDATES AMT_CUST_CHRG                  *05678000
      ******************************************************************05630000
                                                                        
       5075-UPDATE-RATE-VRSN-DEF.                                       
                                                                        
           PERFORM 7075-SELECT-RT-VRSN-DEF    THRU 7075-EXIT.           
                                                                        
           IF WS-J4-AMT-CUST-CHRG NOT EQUAL J4-AMT-CUST-CHRG            
              PERFORM 8200A-UPDATE-RTVRSN     THRU 8200A-EXIT           
           END-IF.                                                      
                                                                        
       5075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05630000
      * 5100-UPDATE-RATE-COMP-DEF                                      *05640000
      * ~~~~~~~~~~~~~~~~~~~~~~~~~                                      *05640000
      * INSERTS/UPDATES/DELETES COMP_DEF & CORRES TBLS BASED ON PARM VAL05675000
      *   1.UPDATE                                                     *05677000
      *     CSS_RATE_COMP_DEF - UPDATES THE COLUMNS PASSED THROUGH PARM*05678000
      *     CSS_DEMAND_INSTR  - WHEN DMDINS AMOUNT FIELD > 0           *05678000
      *                         => UPDATES IF ROW PRESENT              *05678000
      *                         => INSERTS IF NO ROW FOUND             *05678000
      *     CSS_RATE_TOU_DEF  - BASED ON THE VALUES OF REG_TYPE_CD &   *05678000
      *                         DEM_REG_TYPE_CD DELETE UNWANTED ENTRIES*05678000
      *                         IN RATE_TOU_DEF TABLE                  *05678000
      *                         => DELETE UNWANTED ENTRIES FROM TOU_DEF*05678000
      *                         => UPDATE ON_PEAK_DAYS & CALENDAR_CD AS*05678000
      *                            SPACES IN COMP_DEF TABLE WHEN NO ON-*05678000
      *                            PEAK ENTRY PRESENT IN TOU_DEF TABLE *05678000
      *   2.DELETE                                                     *05677000
      *     CSS_RATE_COMP_DEF - DELETE THE ROW                         *05678000
      *     CSS_DEMAND_INSTR  - DELETE IF ROW PRESENT                  *05678000
      *     CSS_DEMAND_RATCHET- IF ALL ROW(S) PRESENT IN COMP_DEF TABLE*05678000
      *                         WITH DEM_REG_TYPE_CD AS SPACES FOR THAT*05678000
      *                         RATE VERSION                           *05678000
      *                         => DELETE ALL ROWS IN DEMAND_RATCHET   *05678000
      *                            FOR THAT RATE VERSION               *05678000
      *                         => SET RETURN CODE AS 0 IF NO ROW PRSNT*05678000
      *                            IN DEMAND_RATCHET TABLE             *05678000
      *   3.INSERT                                                     *05677000
      *     CSS_RATE_COMP_DEF - INSERT NEW ENTRY                       *05678000
      *     CSS_DEMAND_INSTR  - WHEN DMDINS AMOUNT FIELD > 0           *05678000
      *                         => INSERTS NEW ENTRY                   *05678000
      ******************************************************************05679000
                                                                        
       5100-UPDATE-RATE-COMP-DEF.                                       
                                                                        
           PERFORM 5020-FORMAT-ROW-COMP-DEF   THRU 5020-EXIT.           
                                                                        
           PERFORM 7200-SELECT-DMDINS-EXISTS  THRU 7200-EXIT.           
           PERFORM 7250-SELECT-TOU-DEF-MAX    THRU 7250-EXIT.           
                                                                        
           EVALUATE WS-J1-ACTION-IND(WS-COMP-DEF-INDX)                  
               WHEN WS-UPDATE                                           
                  PERFORM 8200-UPDATE-RTCOMP      THRU 8200-EXIT        
                                                                        
                  IF DI-MIN-DMD-CHRG     > 0                            
                  OR DI-MIN-DMD-QTY      > 0                            
                  OR DI-PWR-FCTR-MIN-PCT > 0                            
                  OR DI-LFTM-PEAK-PCT    > 0                            
                  OR DI-LD-FCTR-MIN-PCT  > 0                            
                     IF WS-DMND-INSTR-EXISTS = WS-YES                   
                        PERFORM 8220-UPDATE-DMDINS  THRU 8220-EXIT      
                     ELSE                                               
                        PERFORM 8420-INSERT-DMDINS  THRU 8420-EXIT      
                     END-IF                                             
                  END-IF                                                
      ***************************************************************** 05780000
      * DETERMINE MAX READ REQUIRED FROM ENERGY OR DEMAND IN THE      * 05780000
      * FOLLOWING ORDER 1. ON-OFF-SHOULDER 2. IDR 3. HOURLY 4. ON-OFF * 05780000
      * 5. OTHERS (DAILY, SINGLE)                                     * 05780000
      ***************************************************************** 05780000
                  IF J1-REG-TYPE-CD          = WS-ON-OFF-SHOULDER-READ-3
                  OR J1-DEM-REG-TYPE-CD      = WS-ON-OFF-SHOULDER-READ-3
                     MOVE WS-ON-OFF-SHOULDER-READ-3                     
                                             TO WS-READ                 
                  ELSE                                                  
                     IF J1-REG-TYPE-CD        = WS-INTRVL-DATA-READ-I   
                     OR J1-DEM-REG-TYPE-CD    = WS-INTRVL-DATA-READ-I   
                        MOVE WS-INTRVL-DATA-READ-I                      
                                             TO WS-READ                 
                     ELSE                                               
                        IF J1-REG-TYPE-CD     = WS-HOURLY-READ-H        
                        OR J1-DEM-REG-TYPE-CD = WS-HOURLY-READ-H        
                           MOVE WS-HOURLY-READ-H                        
                                             TO WS-READ                 
                        ELSE                                            
                           IF J1-REG-TYPE-CD     = WS-ON-OFF-PEAK-READ-2
                           OR J1-DEM-REG-TYPE-CD = WS-ON-OFF-PEAK-READ-2
                              MOVE WS-ON-OFF-PEAK-READ-2                
                                             TO WS-READ                 
                           ELSE                                         
                              MOVE WS-SINGLE-READ-B                     
                                             TO WS-READ                 
                           END-IF                                       
                        END-IF                                          
                     END-IF                                             
                  END-IF                                                
                  PERFORM 5150-DEL-UNWNTD-TOU-DEF   THRU 5150-EXIT      
               WHEN WS-DELETE                                           
                                                                        
                  IF WS-DMND-INSTR-EXISTS = WS-YES                      
                     PERFORM 8320-DELETE-DMDINS     THRU 8320-EXIT      
                  END-IF                                                
                                                                        
                  PERFORM 8300-DELETE-RTCOMP        THRU 8300-EXIT      
                  PERFORM 7300-SELECT-DMND-EXISTS THRU 7300-EXIT        
                  IF WS-DMND-EXISTS = WS-NO                             
                     PERFORM 8330-DELETE-DEMAND-RATCHET THRU 8330-EXIT  
                     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND               
                        MOVE 0               TO WS-ACTIVE-RETURN-CODE   
                                                 S-RETURN-CODE          
                     END-IF                                             
                  END-IF                                                
               WHEN WS-INSERT                                           
                  PERFORM 8400-INSERT-RTCOMP      THRU 8400-EXIT        
                                                                        
                  IF DI-MIN-DMD-CHRG     > 0                            
                  OR DI-MIN-DMD-QTY      > 0                            
                  OR DI-PWR-FCTR-MIN-PCT > 0                            
                  OR DI-LFTM-PEAK-PCT    > 0                            
                  OR DI-LD-FCTR-MIN-PCT  > 0                            
                     PERFORM 8420-INSERT-DMDINS   THRU 8420-EXIT        
                  END-IF                                                
                                                                        
           END-EVALUATE.                                                
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05630000
      * 5150-DEL-UNWNTD-TOU-DEF.                                       *05640000
      * ~~~~~~~~~~~~~~~~~~~~~~~~                                       *05640000
      * DELETE UNWANTED TOU-DEF ROWS BASED ON READ VALUE IN RATE-COMP- *05675000
      * DEF TABLE REG-TYPE-CD & DMD-REG-TYPE-CD.                       *05675000
      * >>REG_TYPE_CD / DEM_REG_TYPE_CD = B OR D                       *05675000
      *    =>DELETE ALL ROWS PRSNT IN TOU_DEF WITH CODE_TIME_PERIOD > 0*05675000
      *    =>UPDATE ON_PEAK_DAYS & CALENDAR_CD AS SPACES IN COMP_DEF TB*05675000
      * >>REG_TYPE_CD / DEM_REG_TYPE_CD = 2                            *05675000
      *    =>DELETE ALL ROWS PRSNT IN TOU_DEF WITH CODE_TIME_PERIOD > 2*05675000
      * >>REG_TYPE_CD / DEM_REG_TYPE_CD = 3 OR I OR H                  *05675000
      *    =>DELETE ALL ROWS PRSNT IN TOU_DEF WITH CODE_TIME_PERIOD > 3*05675000
      ******************************************************************05679000
                                                                        
       5150-DEL-UNWNTD-TOU-DEF.                                         
                                                                        
           EVALUATE TRUE                                                
               WHEN WS-DAILY-READ                                       
               WHEN WS-SINGLE-READ                                      
                    IF WS-MAX-CODE-TIME-PERIOD > 0                      
                       MOVE 1                TO WS-MAX-CODE-TIME-PERIOD 
                       MOVE SPACES           TO J1-ON-PEAK-DAYS         
                       MOVE SPACES           TO J1-CALENDAR-CD          
                       PERFORM 8335-DELETE-TOU-DEF THRU 8335-EXIT       
                       PERFORM 8205-UPDATE-RTCOMP-4-SNGL-DLY            
                                                   THRU 8205-EXIT       
                    END-IF                                              
               WHEN WS-ON-OFF-PEAK-READ                                 
                    IF WS-MAX-CODE-TIME-PERIOD > 2                      
                       PERFORM 8335-DELETE-TOU-DEF THRU 8335-EXIT       
                    END-IF                                              
               WHEN WS-HOURLY-READ                                      
               WHEN WS-INTRVL-DATA-READ                                 
               WHEN WS-ON-OFF-SHOULDER-READ                             
                    IF WS-MAX-CODE-TIME-PERIOD > 3                      
                       PERFORM 8335-DELETE-TOU-DEF THRU 8335-EXIT       
                    END-IF                                              
           END-EVALUATE.                                                
                                                                        
       5150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05630000
      * 5200-UPDATE-PRC-SCHD                                           *05640000
      * ~~~~~~~~~~~~~~~~~~~~                                           *05640000
      * INSERTS/UPDATES/DELETES PRICE_SCHED TABLE ROW BASED ON PARM VAL*05675000
      *   1.UPDATE                                                     *05677000
      *     CSS_PRICE_SCHED     => DELETE THE EXISTING SET OF BLOCKS   *05678000
      *                         => INSERT NEW BLOCKS                   *05678000
      *   2.DELETE                                                     *05677000
      *     CSS_PRICE_SCHED     => DELETE THE EXISTING SET OF BLOCKS   *05678000
      *   3.INSERT                                                     *05677000
      *     CSS_PRICE_SCHED     => INSERT NEW BLOCKS IF NOT PRESENT    *05678000
      ******************************************************************05679000
                                                                        
       5200-UPDATE-PRC-SCHD.                                            
                                                                        
           PERFORM 5030-FORMAT-ROW-PRC-SCHD   THRU 5030-EXIT.           
                                                                        
           EVALUATE                                                     
                WS-PS-ACTION-IND(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX)     
              WHEN WS-DELETE                                            
                   PERFORM 8340-DELETE-PRICE-SCHED  THRU 8340-EXIT      
              WHEN WS-UPDATE                                            
                   PERFORM 8340-DELETE-PRICE-SCHED  THRU 8340-EXIT      
                   PERFORM 5250-INSERT-BLOCK-DTLS   THRU 5250-EXIT      
              WHEN WS-INSERT                                            
                   PERFORM 5250-INSERT-BLOCK-DTLS   THRU 5250-EXIT      
           END-EVALUATE.                                                
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05630000
      * 5250-INSERT-BLOCK-DTLS.                                        *05640000
      * ~~~~~~~~~~~~~~~~~~~~~~~                                        *05640000
      * INSERTS BLOCK DETAILS IN PRICE_SCHED TABLE BASED ON PARM VALUE *05675000
      ******************************************************************05679000
                                                                        
       5250-INSERT-BLOCK-DTLS.                                          
                                                                        
           PERFORM 7400-SELECT-PRC-SCHD-EXISTS THRU 7400-EXIT           
                                                                        
           IF WS-PRC-SCHD-EXISTS = WS-NO                                
                                                                        
              PERFORM VARYING WS-BLK-DTLS-INDX   FROM 1 BY 1            
                UNTIL WS-BLK-DTLS-INDX        >  WS-PS-BLK-MAX-ROW-COUNT
                   OR WS-PS-BCK-USE-OR-SVC                              
                   (WS-COMP-DEF-INDX, WS-PRC-GRP-INDX, WS-BLK-DTLS-INDX)
                                              <= SPACES OR LOW-VALUES   
                PERFORM 5035-FORMAT-ROW-BLOCK-DTLS THRU 5035-EXIT       
                PERFORM 8430-INSERT-PRICE-SCHED    THRU 8430-EXIT       
              END-PERFORM                                               
                                                                        
           END-IF.                                                      
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05630000
      * 5300-UPDATE-TOU-INSR                                           *05640000
      * ~~~~~~~~~~~~~~~~~~~~                                           *05640000
      * INSERTS/UPDATES/DELETES TOU_INSTR TABLE ROW BASED ON PARM VALUE*05675000
      *   1.UPDATE                                                     *05677000
      *     CSS_RATE_TOU_INSTR  => UPDATE THE EXISTING ROW             *05678000
      *   2.DELETE                                                     *05677000
      *     CSS_RATE_TOU_INSTR  => DELETE THE EXISTING ROW             *05678000
      *   3.INSERT                                                     *05677000
      *     CSS_RATE_TOU_INSTR  => INSERT NEW ROW                      *05678000
      ******************************************************************05679000
                                                                        
       5300-UPDATE-TOU-INSR.                                            
                                                                        
           PERFORM 5040-FORMAT-ROW-TOU-INSR   THRU 5040-EXIT.           
                                                                        
           EVALUATE WS-PS-ACTION-IND(WS-COMP-DEF-INDX, WS-PRC-GRP-INDX) 
               WHEN WS-UPDATE                                           
                    PERFORM 8230-UPDATE-TOU-INSTR THRU 8230-EXIT        
               WHEN WS-DELETE                                           
                    PERFORM 8350-DELETE-TOU-INSTR THRU 8350-EXIT        
               WHEN WS-INSERT                                           
                    PERFORM 8440-INSERT-TOU-INSTR THRU 8440-EXIT        
           END-EVALUATE.                                                
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05630000
      * 5400-UPDATE-DMND-RTCHT                                         *05640000
      * ~~~~~~~~~~~~~~~~~~~~~~                                         *05640000
      * INSERTS/UPDATES/DELETES DEMAND_RATCHET TBL ROW BASED ON PARM VL*05675000
      *   1.UPDATE                                                     *05677000
      *     CSS_DEMAND_RATCHET  => UPDATE THE ROW (IF PRESENT)         *05678000
      *   2.DELETE                                                     *05677000
      *     CSS_DEMAND_RATCHET  => DELETE THE ROW (IF PRESENT)         *05678000
      *   3.INSERT                                                     *05677000
      *     CSS_DEMAND_RATCHET  => INSERT NEW ROW IF NOT PRESENT       *05678000
      ******************************************************************05679000
                                                                        
       5400-UPDATE-DMND-RTCHT.                                          
                                                                        
           PERFORM 5050-FORMAT-ROW-DMND-RTCHT THRU 5050-EXIT.           
           PERFORM 7500-SELECT-RTCHT-EXISTS   THRU 7500-EXIT.           
                                                                        
           EVALUATE WS-J2-ACTION-IND(WS-DMND-RTCHT-INDX)                
               ALSO WS-RTCHT-EXISTS                                     
               WHEN WS-UPDATE ALSO WS-YES                               
                    PERFORM 8240-UPDATE-RATCHET    THRU 8240-EXIT       
               WHEN WS-DELETE ALSO WS-YES                               
                    PERFORM 8360-DELETE-RATCHET    THRU 8360-EXIT       
               WHEN WS-INSERT ALSO WS-NO                                
                    PERFORM 8450-INSERT-RATCHET    THRU 8450-EXIT       
           END-EVALUATE.                                                
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 06740000
      * 7075-SELECT-RT-VRSN-DEF                                       * 06750000
      *     SELECT AMT_CUST_CHRG VALUE                                * 06810000
      ***************************************************************** 06820000
                                                                        
       7075-SELECT-RT-VRSN-DEF.                                         
                                                                        
           MOVE '7075'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE 0                            TO WS-J4-AMT-CUST-CHRG.    
                                                                        
           EXEC SQL                                                     
              SELECT AMT_CUST_CHRG                                      
                INTO :WS-J4-AMT-CUST-CHRG                               
                FROM CSS_RATE_VRSN_DEF                                  
               WHERE CODE_UTIL_TYPE     = :J4-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :J4-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :J4-VERSION-NO-CNTRL          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_VRSN_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J4-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J4-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J4-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE DI-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7075-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07250000
      * 7200-SELECT-DMDINS-EXISTS.                                    * 07260000
      *     SELECTS CSS_DEMAND_INSTR FOR EXISTENCE                    * 07320000
      ***************************************************************** 07330000
                                                                        
       7200-SELECT-DMDINS-EXISTS.                                       
                                                                        
           MOVE '7200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-NO                        TO WS-DMND-INSTR-EXISTS.   
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT 'Y'                                       
                INTO :WS-DMND-INSTR-EXISTS                              
                FROM CSS_DEMAND_INSTR                                   
               WHERE CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :DI-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :DI-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :DI-CMPNT-ID-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
           OR                                   NOT-FOUND               
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_INSTR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE DI-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE DI-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE DI-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE DI-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE DI-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07751000
      * 7250-SELECT-TOU-DEF-MAX.                                      * 07752000
      *     SELECTS CSS_RATE_TOU_DEF MAX CODE_TIME_PERIOD             * 07758000
      ***************************************************************** 07759000
                                                                        
       7250-SELECT-TOU-DEF-MAX.                                         
                                                                        
           MOVE '7250'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE 0                            TO WS-CODE-TIME-PRD-NULL-ID
                                                WS-MAX-CODE-TIME-PERIOD.
                                                                        
           EXEC SQL                                                     
              SELECT MAX(CODE_TIME_PERIOD)                              
                INTO :WS-MAX-CODE-TIME-PERIOD :WS-CODE-TIME-PRD-NULL-ID  
                FROM CSS_RATE_TOU_DEF                                   
               WHERE CODE_UTIL_TYPE     = :RJ-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :RJ-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :RJ-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :RJ-CMPNT-ID-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
           OR                                   NOT-FOUND               
              IF WS-CODE-TIME-PRD-NULL-ID     = -1                      
                 MOVE 0                      TO WS-MAX-CODE-TIME-PERIOD 
              END-IF                                                    
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_TOU_DEF'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE RJ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RJ-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RJ-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RJ-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE RJ-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07751000
      * 7300-SELECT-DMND-EXISTS.                                      * 07752000
      *     SELECTS CSS_RATE_COMP_DEF FOR DEMAND EXISTENCE            * 07758000
      ***************************************************************** 07759000
                                                                        
       7300-SELECT-DMND-EXISTS.                                         
                                                                        
           MOVE '7300'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-NO                        TO WS-DMND-EXISTS.         
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT 'Y'                                       
                INTO :WS-DMND-EXISTS                                    
                FROM CSS_RATE_COMP_DEF                                  
               WHERE CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :J1-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :J1-VERSION-NO-CNTRL          
                 AND DEM_REG_TYPE_CD    > ' '                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
           OR                                   NOT-FOUND               
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J1-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J1-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J1-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE J1-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07751000
      * 7400-SELECT-PRC-SCHD-EXISTS.                                   *07752000
      *     SELECTS CSS_PRICE_SCHED FOR DEMAND EXISTENCE               *07758000
      ***************************************************************** 07759000
                                                                        
       7400-SELECT-PRC-SCHD-EXISTS.                                     
                                                                        
           MOVE '7400'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-NO                        TO WS-PRC-SCHD-EXISTS.     
                                                                        
           EXEC SQL                                                     
               SELECT 'Y'                                               
                 INTO :WS-PRC-SCHD-EXISTS                               
                 FROM CSS_PRICE_SCHED WITH(READUNCOMMITTED)                     
                WHERE CODE_UTIL_TYPE       = :PS-CODE-UTIL-TYPE         
                  AND RATE_PLAN_NO         = :PS-RATE-PLAN-NO           
                  AND VERSION_NO_CNTRL     = :PS-VERSION-NO-CNTRL       
                  AND CMPNT_ID_CD          = :PS-CMPNT-ID-CD            
                  AND CODE_SEASON          = :PS-CODE-SEASON            
                  AND CODE_TIME_PERIOD     = :PS-CODE-TIME-PERIOD       
                  AND CODE_USE_INST_TYPE   = :PS-CODE-USE-INST-TYPE     
                  AND BLOCK_NO             = 1                          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02357700
MFA-TR*        SELECT 'Y'                                               02357800
MFA-TR*          INTO :WS-PRC-SCHD-EXISTS                               02358000
MFA-TR*          FROM CSS_PRICE_SCHED                                   02358100
MFA-TR*         WHERE CODE_UTIL_TYPE       = :PS-CODE-UTIL-TYPE         02358200
MFA-TR*           AND RATE_PLAN_NO         = :PS-RATE-PLAN-NO           02358300
MFA-TR*           AND VERSION_NO_CNTRL     = :PS-VERSION-NO-CNTRL       02358400
MFA-TR*           AND CMPNT_ID_CD          = :PS-CMPNT-ID-CD            02358500
MFA-TR*           AND CODE_SEASON          = :PS-CODE-SEASON            02358600
MFA-TR*           AND CODE_TIME_PERIOD     = :PS-CODE-TIME-PERIOD       02358700
MFA-TR*           AND CODE_USE_INST_TYPE   = :PS-CODE-USE-INST-TYPE     02358800
MFA-TR*           AND BLOCK_NO             = 1                          02359700
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    02362200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
           OR                                   NOT-FOUND               
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE PS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE PS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE PS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE PS-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE PS-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7500-SELECT-RTCHT-EXISTS                                      *         
      *     SELECTS CSS_DEMAND_RATCHET - CHECKS TO SEE IF THE RATCHET *         
      *     ALREADY EXISTS                                            *         
      *****************************************************************         
                                                                        
       7500-SELECT-RTCHT-EXISTS.                                        
                                                                        
           MOVE '7500'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-NO                        TO WS-RTCHT-EXISTS.        
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-RTCHT-EXISTS                                   
                FROM CSS_DEMAND_RATCHET                                 
               WHERE CODE_UTIL_TYPE   = :J2-CODE-UTIL-TYPE              
                 AND RATE_PLAN_NO     = :J2-RATE-PLAN-NO                
                 AND VERSION_NO_CNTRL = :J2-VERSION-NO-CNTRL            
                 AND RATCHET_ID       = :J2-RATCHET-ID                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
           OR                                   NOT-FOUND               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_RATCHET'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J2-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE WS-RATCHET-ID             TO S-ERR-RATCHET-ID        
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07764000
      * 8200A-UPDATE-RTVRSN                                           * 07770000
      *     UPDATES CSS_RATE_VRSN_DEF TABLE.                          * 07830000
      ***************************************************************** 07840000
                                                                        
       8200A-UPDATE-RTVRSN.                                             
                                                                        
           MOVE '8200A'                      TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_VRSN_DEF                                  
                 SET AMT_CUST_CHRG      = :J4-AMT-CUST-CHRG             
               WHERE CODE_UTIL_TYPE     = :J4-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :J4-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :J4-VERSION-NO-CNTRL          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_VRSN_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J4-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J4-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J4-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE DI-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ***************************************************************** 07764000
      * 8200-UPDATE-RTCOMP                                            * 07770000
      *     UPDATES CSS_RATE_COMP_DEF TABLE.                          * 07830000
      ***************************************************************** 07840000
                                                                        
       8200-UPDATE-RTCOMP.                                              
                                                                        
           MOVE '8200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_COMP_DEF                                  
                 SET REG_TYPE_CD        = :J1-REG-TYPE-CD               
                    ,ENERGY_UNIT_CD     = :J1-ENERGY-UNIT-CD            
                    ,ENERGY_SEAS_CD     = :J1-ENERGY-SEAS-CD            
                    ,LAST_ENERGY_BLOCK  = :J1-LAST-ENERGY-BLOCK         
                    ,DEM_REG_TYPE_CD    = :J1-DEM-REG-TYPE-CD           
                    ,DEM_UNIT_CD        = :J1-DEM-UNIT-CD               
                    ,DEM_SEASON_CD      = :J1-DEM-SEASON-CD             
                    ,LAST_DEM_BLOCK     = :J1-LAST-DEM-BLOCK            
                    ,BAL_FWD_CD         = :J1-BAL-FWD-CD                
                    ,BAL_RESET_MMDD     = :J1-BAL-RESET-MMDD            
                    ,BAL_RESET_PRO_CD   = :J1-BAL-RESET-PRO-CD          
                    ,BAL_OFFSET_TOU_CD  = :J1-BAL-OFFSET-TOU-CD         
               WHERE CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :J1-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :J1-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :J1-CMPNT-ID-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE J1-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J1-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J1-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE J1-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE J1-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07764000
      * 8205-UPDATE-RTCOMP-4-SNGL-DLY                                 * 07770000
      *     UPDATES CSS_RATE_COMP_DEF TABLE FOR SINGLE/DAILY READING  * 07830000
      ***************************************************************** 07840000
                                                                        
       8205-UPDATE-RTCOMP-4-SNGL-DLY.                                   
                                                                        
           MOVE '8205'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_COMP_DEF                                  
                 SET ON_PEAK_DAYS       = :J1-ON-PEAK-DAYS              
                    ,CALENDAR_CD        = :J1-CALENDAR-CD               
               WHERE CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :J1-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :J1-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :J1-CMPNT-ID-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE J1-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J1-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J1-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE J1-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE J1-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08780000
      * 8220-UPDATE-DMDINS                                            * 08790000
      *     UPDATES CSS_DEMAND_INSTR TABLE ENTRY.                     * 08850000
      ***************************************************************** 08860000
                                                                        
       8220-UPDATE-DMDINS.                                              
                                                                        
           MOVE '8220'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_DEMAND_INSTR                                   
                 SET MIN_DMD_CHRG       = :DI-MIN-DMD-CHRG              
                    ,MIN_DMD_QTY        = :DI-MIN-DMD-QTY               
                    ,PWR_FCTR_MIN_PCT   = :DI-PWR-FCTR-MIN-PCT          
                    ,LFTM_PEAK_PCT      = :DI-LFTM-PEAK-PCT             
                    ,LD_FCTR_MIN_PCT    = :DI-LD-FCTR-MIN-PCT           
               WHERE CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :DI-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :DI-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :DI-CMPNT-ID-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_INSTR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE DI-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE DI-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE DI-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE DI-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE DI-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08780000
      * 8230-UPDATE-TOU-INSTR                                         * 08790000
      *     UPDATES CSS_RATE_TOU_INSTR TABLE ENTRY.                   * 08850000
      ***************************************************************** 08860000
                                                                        
       8230-UPDATE-TOU-INSTR.                                           
                                                                        
           MOVE '8230'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_TOU_INSTR                                 
                 SET RATE_MIN_IND      = :RK-RATE-MIN-IND               
                    ,CNTRCT_MIN_IND    = :RK-CNTRCT-MIN-IND             
                    ,MAX_DEMAND_IND    = :RK-MAX-DEMAND-IND             
                    ,RATCHET_ID_1      = :RK-RATCHET-ID-1               
                    ,RATCHET_ID_2      = :RK-RATCHET-ID-2               
                    ,RATCHET_ID_3      = :RK-RATCHET-ID-3               
                    ,MRG_OFF_PK_IND    = :RK-MRG-OFF-PK-IND             
                    ,MRG_CTR_MIN_IND   = :RK-MRG-CTR-MIN-IND            
                    ,MRG_RT_MIN        = :RK-MRG-RT-MIN                 
                    ,CNTRCT_MIN_PCT    = :RK-CNTRCT-MIN-PCT             
               WHERE CODE_UTIL_TYPE    = :RK-CODE-UTIL-TYPE             
                 AND RATE_PLAN_NO      = :RK-RATE-PLAN-NO               
                 AND VERSION_NO_CNTRL  = :RK-VERSION-NO-CNTRL           
                 AND CMPNT_ID_CD       = :RK-CMPNT-ID-CD                
                 AND CODE_TIME_PERIOD  = :RK-CODE-TIME-PERIOD           
                 AND CODE_SEASON       = :RK-CODE-SEASON                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_TOU_INSTR'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE RK-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RK-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RK-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RK-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE RK-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8240-UPDATE-RATCHET                                           *         
      *     UPDATES CSS_DEMAND_RATCHET TABLE ENTRY.                   *         
      *****************************************************************         
                                                                        
       8240-UPDATE-RATCHET.                                             
                                                                        
           MOVE '8240'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_DEMAND_RATCHET                                 
                 SET CODE_UTIL_TYPE     = :J2-CODE-UTIL-TYPE            
                    ,RATE_PLAN_NO       = :J2-RATE-PLAN-NO              
                    ,VERSION_NO_CNTRL   = :J2-VERSION-NO-CNTRL          
                    ,RATCHET_ID         = :J2-RATCHET-ID                
                    ,FROM_MONTH         = :J2-FROM-MONTH                
                    ,TO_MONTH           = :J2-TO-MONTH                  
                    ,RATCHET_PCT        = :J2-RATCHET-PCT               
                    ,RATCHET_YR_IND     = :J2-RATCHET-YR-IND            
              WHERE  CODE_UTIL_TYPE     = :J2-CODE-UTIL-TYPE            
                AND  RATE_PLAN_NO       = :J2-RATE-PLAN-NO              
                AND  VERSION_NO_CNTRL   = :J2-VERSION-NO-CNTRL          
                AND  RATCHET_ID         = :J2-RATCHET-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_RATCHET'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J2-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE WS-RATCHET-ID             TO S-ERR-RATCHET-ID        
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09290000
      * 8300-DELETE-RTCOMP                                            * 09300000
      *     DELETES CSS_RATE_COMP_DEF TABLE ENTRY.                    * 09360000
      ***************************************************************** 09370000
                                                                        
       8300-DELETE-RTCOMP.                                              
                                                                        
           MOVE '8300'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_RATE_COMP_DEF                             
               WHERE CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :J1-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :J1-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :J1-CMPNT-ID-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE J1-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J1-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J1-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE J1-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE J1-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10210000
      * 8320-DELETE-DMDINS                                            * 10220000
      *     DELETES CSS_DEMAND_INSTR TABLE ENTRY.                     * 10280000
      ***************************************************************** 10290000
                                                                        
       8320-DELETE-DMDINS.                                              
                                                                        
           MOVE '8320'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_DEMAND_INSTR                              
               WHERE CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :DI-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :DI-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :DI-CMPNT-ID-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_INSTR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE DI-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE DI-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE DI-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE DI-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE DI-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10661000
      * 8330-DELETE-DEMAND-RATCHET                                    * 10662000
      *     DELETES CSS_DEMAND_RATCHET TABLE ENTRY.                   * 10668000
      ***************************************************************** 10669000
                                                                        
       8330-DELETE-DEMAND-RATCHET.                                      
                                                                        
           MOVE '8330'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_DEMAND_RATCHET                            
               WHERE CODE_UTIL_TYPE     = :J2-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :J2-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :J2-VERSION-NO-CNTRL          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
           OR                                   NOT-FOUND               
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_RATCHET'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J2-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE WS-RATCHET-ID             TO S-ERR-RATCHET-ID        
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10661000
      * 8335-DELETE-TOU-DEF                                           * 10662000
      *     DELETES CSS_RATE_TOU_DEF TABLE ENTRY.                     * 10668000
      ***************************************************************** 10669000
                                                                        
       8335-DELETE-TOU-DEF.                                             
                                                                        
           MOVE '8335'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE WS-MAX-CODE-TIME-PERIOD      TO RJ-CODE-TIME-PERIOD.    
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_RATE_TOU_DEF                              
               WHERE CODE_UTIL_TYPE     = :RJ-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :RJ-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :RJ-VERSION-NO-CNTRL          
                 AND CODE_TIME_PERIOD  >= :RJ-CODE-TIME-PERIOD          
                 AND CMPNT_ID_CD        = :RJ-CMPNT-ID-CD               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_TOU_DEF'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CODE_TIME_PERIOD'        TO TABLE-ELEMENT-4         
              MOVE RJ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RJ-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RJ-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RJ-CODE-TIME-PERIOD       TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE RJ-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8335-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10661000
      * 8340-DELETE-PRICE-SCHED                                       * 10662000
      *     DELETES CSS_PRICE_SCHED TABLE ENTRY.                      * 10668000
      ***************************************************************** 10669000
                                                                        
       8340-DELETE-PRICE-SCHED.                                         
                                                                        
           MOVE '8340'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_PRICE_SCHED                             
                 WHERE CODE_UTIL_TYPE       = :PS-CODE-UTIL-TYPE        
                   AND RATE_PLAN_NO         = :PS-RATE-PLAN-NO          
                   AND VERSION_NO_CNTRL     = :PS-VERSION-NO-CNTRL      
                   AND CMPNT_ID_CD          = :PS-CMPNT-ID-CD           
                   AND CODE_SEASON          = :PS-CODE-SEASON           
                   AND CODE_TIME_PERIOD     = :PS-CODE-TIME-PERIOD      
                   AND CODE_USE_INST_TYPE   = :PS-CODE-USE-INST-TYPE    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE PS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE PS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE PS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE PS-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE PS-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10661000
      * 8350-DELETE-TOU-INSTR                                         * 10662000
      *     DELETES CSS_RATE_TOU_INSTR TABLE ENTRY.                   * 10668000
      ***************************************************************** 10669000
                                                                        
       8350-DELETE-TOU-INSTR.                                           
                                                                        
           MOVE '8350'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_RATE_TOU_INSTR                            
               WHERE CODE_UTIL_TYPE    = :RK-CODE-UTIL-TYPE             
                 AND RATE_PLAN_NO      = :RK-RATE-PLAN-NO               
                 AND VERSION_NO_CNTRL  = :RK-VERSION-NO-CNTRL           
                 AND CMPNT_ID_CD       = :RK-CMPNT-ID-CD                
                 AND CODE_TIME_PERIOD  = :RK-CODE-TIME-PERIOD           
                 AND CODE_SEASON       = :RK-CODE-SEASON                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_TOU_INSTR'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE RK-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RK-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RK-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RK-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE RK-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8360-DELETE-RATCHET                                           *         
      *     UPDATES CSS_DEMAND_RATCHET TABLE ENTRY                    *         
      *****************************************************************         
                                                                        
       8360-DELETE-RATCHET.                                             
                                                                        
           MOVE '8360'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_DEMAND_RATCHET                            
               WHERE CODE_UTIL_TYPE     = :J2-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :J2-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :J2-VERSION-NO-CNTRL          
                 AND RATCHET_ID         = :J2-RATCHET-ID                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_RATCHET'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J2-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE WS-RATCHET-ID             TO S-ERR-RATCHET-ID        
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10673000
      * 8400-INSERT-RTCOMP                                            * 10680000
      *     INSERTS ROW IN CSS_RATE_COMP_DEF TABLE                    * 10740000
      ***************************************************************** 10750000
                                                                        
       8400-INSERT-RTCOMP.                                              
                                                                        
           MOVE '8400'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_COMP_DEF                             
                     (CODE_UTIL_TYPE                                    
                     ,RATE_PLAN_NO                                      
                     ,VERSION_NO_CNTRL                                  
                     ,CMPNT_ID_CD                                       
                     ,REG_TYPE_CD                                       
                     ,ENERGY_UNIT_CD                                    
                     ,ENERGY_SEAS_CD                                    
                     ,LAST_ENERGY_BLOCK                                 
                     ,DEM_REG_TYPE_CD                                   
                     ,DEM_UNIT_CD                                       
                     ,DEM_SEASON_CD                                     
                     ,LAST_DEM_BLOCK                                    
                     ,ON_PEAK_DAYS                                      
                     ,CALENDAR_CD                                       
                     ,RTP_BASELINE_RATE                                 
                     ,BAL_FWD_CD                                        
                     ,BAL_RESET_MMDD                                    
                     ,BAL_RESET_PRO_CD                                  
                     ,BAL_OFFSET_TOU_CD)                                
              VALUES                                                    
                     (:J1-CODE-UTIL-TYPE                                
                     ,:J1-RATE-PLAN-NO                                  
                     ,:J1-VERSION-NO-CNTRL                              
                     ,:J1-CMPNT-ID-CD                                   
                     ,:J1-REG-TYPE-CD                                   
                     ,:J1-ENERGY-UNIT-CD                                
                     ,:J1-ENERGY-SEAS-CD                                
                     ,:J1-LAST-ENERGY-BLOCK                             
                     ,:J1-DEM-REG-TYPE-CD                               
                     ,:J1-DEM-UNIT-CD                                   
                     ,:J1-DEM-SEASON-CD                                 
                     ,:J1-LAST-DEM-BLOCK                                
                     ,:J1-ON-PEAK-DAYS                                  
                     ,:J1-CALENDAR-CD                                   
                     ,:J1-RTP-BASELINE-RATE                             
                     ,:J1-BAL-FWD-CD                                    
                     ,:J1-BAL-RESET-MMDD                                
                     ,:J1-BAL-RESET-PRO-CD                              
                     ,:J1-BAL-OFFSET-TOU-CD)                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE J1-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J1-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J1-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE J1-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE J1-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11990000
      * 8420-INSERT-DMDINS                                            * 12000000
      *     INSERTS ROW IN CSS_DEMAND_INSTR TABLE                     * 12060000
      ***************************************************************** 12070000
                                                                        
       8420-INSERT-DMDINS.                                              
                                                                        
           MOVE '8420'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_DEMAND_INSTR                              
                     (CODE_UTIL_TYPE                                    
                     ,RATE_PLAN_NO                                      
                     ,VERSION_NO_CNTRL                                  
                     ,CMPNT_ID_CD                                       
                     ,DMD_YLD_PR_RTE_LMT                                
                     ,MIN_DMD_CHRG                                      
                     ,MIN_DMD_QTY                                       
                     ,PWR_FCTR_MIN_PCT                                  
                     ,LFTM_PEAK_PCT                                     
                     ,LD_FCTR_MIN_PCT)                                  
              VALUES                                                    
                     (:DI-CODE-UTIL-TYPE                                
                     ,:DI-RATE-PLAN-NO                                  
                     ,:DI-VERSION-NO-CNTRL                              
                     ,:DI-CMPNT-ID-CD                                   
                     ,:DI-DMD-YLD-PR-RTE-LMT                            
                     ,:DI-MIN-DMD-CHRG                                  
                     ,:DI-MIN-DMD-QTY                                   
                     ,:DI-PWR-FCTR-MIN-PCT                              
                     ,:DI-LFTM-PEAK-PCT                                 
                     ,:DI-LD-FCTR-MIN-PCT)                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_INSTR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE DI-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE DI-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE DI-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE DI-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE DI-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11990000
      * 8430-INSERT-PRICE-SCHED                                       * 12000000
      *     INSERTS ROW IN CSS_PRICE_SCHED TABLE                      * 12060000
      ***************************************************************** 12070000
                                                                        
       8430-INSERT-PRICE-SCHED.                                         
                                                                        
           MOVE '8430'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_PRICE_SCHED                              
                      (CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,VERSION_NO_CNTRL                                 
                      ,CMPNT_ID_CD                                      
                      ,CODE_SEASON                                      
                      ,CODE_TIME_PERIOD                                 
                      ,CODE_USE_INST_TYPE                               
                      ,BLOCK_NO                                         
                      ,BLOCK_USE_OR_SVCS                                
                      ,SCHED_PRICE_AM                                   
                      ,PRICE_TYPE_CD                                    
                      ,LAST_PRICE_DAY_MTH                               
                      ,BEGN_PRICE_DAY_MTH                               
                      ,ITEM_ID                                          
                      ,DATE_PRICE_END                                   
                      ,DAYS_PRICE_APPLIES                               
                      ,SCHED_WNA_RATE_AMT                               
                      ,BLOCK_DESC                                       
                      )                                                 
               VALUES (:PS-CODE-UTIL-TYPE                               
                      ,:PS-RATE-PLAN-NO                                 
                      ,:PS-VERSION-NO-CNTRL                             
                      ,:PS-CMPNT-ID-CD                                  
                      ,:PS-CODE-SEASON                                  
                      ,:PS-CODE-TIME-PERIOD                             
                      ,:PS-CODE-USE-INST-TYPE                           
                      ,:PS-BLOCK-NO                                     
                      ,:PS-BLOCK-USE-OR-SVCS                            
                      ,:PS-SCHED-PRICE-AM                               
                      ,:PS-PRICE-TYPE-CD                                
                      ,:PS-LAST-PRICE-DAY-MTH                           
                      ,:PS-BEGN-PRICE-DAY-MTH                           
                      ,:PS-ITEM-ID                                      
                      ,:PS-DATE-PRICE-END                               
                      ,:PS-DAYS-PRICE-APPLIES                           
                      ,:PS-SCHED-WNA-RATE-AMT                           
                      ,:PS-BLOCK-DESC                                   
                      )                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE RK-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RK-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RK-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RK-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE RK-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11990000
      * 8440-INSERT-TOU-INSTR                                         * 12000000
      *     INSERTS ROW IN CSS_RATE_TOU_INSTR TABLE                   * 12060000
      ***************************************************************** 12070000
                                                                        
       8440-INSERT-TOU-INSTR.                                           
                                                                        
           MOVE '8440'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_RATE_TOU_INSTR                          
                       (CODE_UTIL_TYPE                                  
                       ,RATE_PLAN_NO                                    
                       ,VERSION_NO_CNTRL                                
                       ,CMPNT_ID_CD                                     
                       ,CODE_TIME_PERIOD                                
                       ,RATE_MIN_IND                                    
                       ,CNTRCT_MIN_IND                                  
                       ,MAX_DEMAND_IND                                  
                       ,RATCHET_ID_1                                    
                       ,RATCHET_ID_2                                    
                       ,RATCHET_ID_3                                    
                       ,MRG_OFF_PK_IND                                  
                       ,MRG_CTR_MIN_IND                                 
                       ,MRG_RT_MIN                                      
                       ,CODE_SEASON                                     
                       ,CNTRCT_MIN_PCT)                                 
                VALUES (:RK-CODE-UTIL-TYPE                              
                       ,:RK-RATE-PLAN-NO                                
                       ,:RK-VERSION-NO-CNTRL                            
                       ,:RK-CMPNT-ID-CD                                 
                       ,:RK-CODE-TIME-PERIOD                            
                       ,:RK-RATE-MIN-IND                                
                       ,:RK-CNTRCT-MIN-IND                              
                       ,:RK-MAX-DEMAND-IND                              
                       ,:RK-RATCHET-ID-1                                
                       ,:RK-RATCHET-ID-2                                
                       ,:RK-RATCHET-ID-3                                
                       ,:RK-MRG-OFF-PK-IND                              
                       ,:RK-MRG-CTR-MIN-IND                             
                       ,:RK-MRG-RT-MIN                                  
                       ,:RK-CODE-SEASON                                 
                       ,:RK-CNTRCT-MIN-PCT)                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_TOU_INSTR'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE RK-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RK-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RK-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RK-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE RK-CMPNT-ID-CD            TO S-ERR-CMPNT-ID-CD       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8450-INSERT-RATCHET                                           *         
      *     INSERTS ROW IN CSS_DEMAND_RATCHET TABLE                   *         
      *****************************************************************         
                                                                        
       8450-INSERT-RATCHET.                                             
                                                                        
           MOVE '8450'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_DEMAND_RATCHET                            
                     (CODE_UTIL_TYPE                                    
                     ,RATE_PLAN_NO                                      
                     ,VERSION_NO_CNTRL                                  
                     ,RATCHET_ID                                        
                     ,FROM_MONTH                                        
                     ,TO_MONTH                                          
                     ,RATCHET_PCT                                       
                     ,RATCHET_YR_IND)                                   
              VALUES                                                    
                     (:J2-CODE-UTIL-TYPE                                
                     ,:J2-RATE-PLAN-NO                                  
                     ,:J2-VERSION-NO-CNTRL                              
                     ,:J2-RATCHET-ID                                    
                     ,:J2-FROM-MONTH                                    
                     ,:J2-TO-MONTH                                      
                     ,:J2-RATCHET-PCT                                   
                     ,:J2-RATCHET-YR-IND)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE WS-ACTIVE-RETURN-CODE     TO S-RETURN-CODE           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_RATCHET'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J2-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              MOVE WS-RATCHET-ID             TO S-ERR-RATCHET-ID        
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12564200
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     12564300
      ******************************************************************12564400
           EXEC SQL                                                     12564500
              INCLUDE CPDSP300                                          12564600
           END-EXEC.                                                    12564700
                                                                        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
