       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04456.                                         
COB303 DATE-WRITTEN.  MAY 04, 2012.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00180000
      *                                                                *00190000
      *  CSR04456 CLONED FROM SP'S CSR02220/CSR02006/CSR02007/CSR02015/*00200000
      *  CSR02057 TO RETRIEVE RATE COMPONENT & PRICING DETAILS         *00210000
      *                                                                *00250000
      ******************************************************************00260000
      *                 P R O G R A M  S U M M A R Y                   *00270000
      *                                                                *00280000
      *  THIS PROGRAM RETRIEVES RATE COMPONENT DEFINITION, PRICING &   *00310000
      *  FACILITY CHARGE DETAILS FOR RATE PLAN NUMBER & RATE VERSION   *00320000
      *  PASSED.                                                       *00330000
      ******************************************************************00340000
      *                                                                *00350000
      *                     PROGRAM MODIFICATION LOG                   *00360000
      *                                                                *00370000
      *    DATE    INITIALS   COMMENTS                                 *00380000
      *  --------  --------   ---------------------------------------  *00390000
      *  05/04/12  HA7A338    CREATED.                                 *00400000
      *  09/15/16  DB41297    REMOVE CSS_RATE_MIN                      *00410000
      *                                                                *00504000
      ******************************************************************00510000
      ******************************************************************00520000
      *                                                                *00530000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00540000
      *                                                                *00550000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00560000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00570000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00580000
      *  3000 - 4999  NOT USED                                         *00590000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00600000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00610000
      *  7000 - 7999  INPUT MODULES                                    *00620000
      *  8000 - 8999  OUTPUT MODULES                                   *00630000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00640000
      *                                                                *00650000
      ******************************************************************00660000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04456'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR CSR04456 STARTS HERE'.                  
                                                                        
      ******************************************************************01200000
      *    WORK AREAS                                                  *01210000
      ******************************************************************01220000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR04456'.    
           05  GWL-STATUS-SUBCODE        PIC S9(9) COMP.                
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(9) COMP.                
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS2              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS3              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS4              PIC S9(9) COMP VALUE 0.        
           05  CTR-ROWS-RS5              PIC S9(9) COMP VALUE 0.        
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS           PIC S9(9) COMP.                
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                    PIC X(01) VALUE 'Y'.           
           05  WS-NO                     PIC X(01) VALUE 'N'.           
           05  WS-ACTIVE-CODE            PIC X(01) VALUE 'A'.           
           05  WS-RATCHET-EXISTS         PIC X(01) VALUE 'N'.           
           05  WS-BFC-SEASONAL-FL        PIC X(01) VALUE 'N'.           
           05  WS-ADD-TO-BFC             PIC X(01) VALUE 'L'.           
           05  WS-SUB-FROM-BFC           PIC X(01) VALUE 'O'.           
                                                                        
       01  WS-RETURN-CODES.                                             
           05  WS-ERROR-CODE-295         PIC S9(4) COMP VALUE +295.     
           05  WS-APPL-RETURN-CODE       PIC S9(4) COMP VALUE 0.        
           05  WS-J1-ACTIVE-RETURN-CODE  PIC S9(4) COMP VALUE 0.        
           05  WS-PS-ACTIVE-RETURN-CODE  PIC S9(4) COMP VALUE 0.        
           05  WS-RK-ACTIVE-RETURN-CODE  PIC S9(4) COMP VALUE 0.        
           05  WS-J2-ACTIVE-RETURN-CODE  PIC S9(4) COMP VALUE 0.        
           05  WS-RT-ACTIVE-RETURN-CODE  PIC S9(4) COMP VALUE 0.        
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-CODE-UTIL-TYPE         PIC X(01) VALUE  SPACE.        
           05  WS-RATE-PLAN-NO           PIC X(03) VALUE  SPACE.        
           05  WS-MAX-FETCH-COUNT        PIC 9(02) VALUE  03.           
           05  WS-FETCH-COUNT            PIC 9(02) VALUE  01.           
           05  WS-MAX-VRSN-NO            PIC S9(4) USAGE  COMP          
                                                   VALUE  0.            
           05  WS-VERSION-NO-CNTRL       PIC S9(4) USAGE  COMP          
                                                   VALUE  0.            
           05  WS-AMT-CUST-CHRG          PIC S9(05)V9(02) USAGE COMP-3  
                                                   VALUE 0.             
           05  WS-WINTER-AMT-CUST-CHRG   PIC S9(05)V9(02) USAGE COMP-3  
                                                   VALUE 0.             
           05  WS-WINTER-ADJ-AMT         PIC S9(03)V9(06) USAGE COMP-3  
                                                   VALUE 0.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
       01  FILLER                        PIC X(32) VALUE                
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP  VALUE 0.       
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
           10  WS-GTT-NAME               PIC X(19) VALUE SPACES.        
                                                                        
        01  GTT-RETURN-FIELDS.                                          
      *********************************************************         02001100
      *   GTT TABLE LAYOUT FOR CSS_RATE_COMP_DEF J1           *         02001200
      *********************************************************         02001300
           05 GTT-RETURN-FIELDS-RS1.                                    
              10 S-R1-RETURN-CODE        PIC S9(09) COMP  VALUE 0.      
              10 S-R1-APPL-RETURN-CODE   PIC S9(04) COMP  VALUE 0.      
              10 S-R1-CMPNT-ID-CD        PIC X(02)  VALUE SPACE.        
              10 S-R1-REG-TYPE-CD        PIC X(01)  VALUE SPACE.        
              10 S-R1-ENERGY-UNIT-CD     PIC X(01)  VALUE SPACE.        
              10 S-R1-ENERGY-SEAS-CD     PIC X(01)  VALUE SPACE.        
              10 S-R1-LAST-ENERGY-BLOCK  PIC S9(04) USAGE COMP          
                                                    VALUE 0.            
              10 S-R1-DEM-REG-TYPE-CD    PIC X(01)  VALUE SPACE.        
              10 S-R1-DEM-UNIT-CD        PIC X(01)  VALUE SPACE.        
              10 S-R1-DEM-SEASON-CD      PIC X(01)  VALUE SPACE.        
              10 S-R1-LAST-DEM-BLOCK     PIC S9(04) USAGE COMP          
                                                    VALUE 0.            
              10 S-R1-AMT-MIN-CHRG       PIC S9(11)V9(02) COMP-3        
                                                    VALUE 0.            
              10 S-R1-QTY-MIN-USAGE      PIC S9(11)V9(02) COMP-3        
                                                    VALUE 0.            
              10 S-R1-MIN-DMD-CHRG       PIC S9(11)V9(02) COMP-3        
                                                    VALUE 0.            
              10 S-R1-MIN-DMD-QTY        PIC S9(11)V      COMP-3        
                                                    VALUE 0.            
              10 S-R1-PWR-FCTR-MIN-PCT   PIC SV9(05)      COMP-3        
                                                    VALUE 0.            
              10 S-R1-LFTM-PEAK-PCT      PIC S9(03)V9(02) COMP-3        
                                                    VALUE 0.            
              10 S-R1-LD-FCTR-MIN-PCT    PIC SV9(05)      COMP-3        
                                                    VALUE 0.            
              10 S-R1-ON-PEAK-DAYS       PIC X(07)  VALUE SPACE.        
              10 S-R1-CALENDAR-CD        PIC X(02)  VALUE SPACE.        
              10 S-R1-BAL-FWD-CD         PIC X(01)  VALUE SPACE.        
              10 S-R1-BAL-RESET-MMDD     PIC S9(04) COMP  VALUE 0.      
              10 S-R1-BAL-RESET-PRO-CD   PIC X(01)  VALUE SPACE.        
              10 S-R1-BAL-OFFSET-TOU-CD  PIC X(01)  VALUE SPACE.        
      *********************************************************         02011700
      *   GTT TABLE LAYOUT FOR CSS_PRICE_SCHED PS             *         02011800
      *********************************************************         02011900
           05 GTT-RETURN-FIELDS-RS2.                                    
              10 S-R2-RETURN-CODE        PIC S9(09) COMP  VALUE 0.      
              10 S-R2-APPL-RETURN-CODE   PIC S9(04) COMP  VALUE 0.      
              10 S-R2-CMPNT-ID-CD        PIC X(02)  VALUE SPACE.        
              10 S-R2-CODE-USE-INST-TYPE PIC X(01)  VALUE SPACE.        
              10 S-R2-CODE-TIME-PERIOD   PIC S9(04) COMP  VALUE 0.      
              10 S-R2-CODE-SEASON        PIC X(01)  VALUE SPACE.        
              10 S-R2-BLOCK-NO           PIC S9(04) COMP  VALUE 0.      
              10 S-R2-BLOCK-USE-OR-SVCS  PIC S9(09)V COMP-3             
                                                          VALUE 0.      
              10 S-R2-BLOCK-DESC         PIC X(30)  VALUE SPACE.        
              10 S-R2-SCHED-PRICE-AM     PIC S9(05)V9(06) COMP-3        
                                                          VALUE 0.      
              10 S-R2-PRICE-TYPE-CD      PIC X(01)  VALUE SPACE.        
              10 S-R2-SCHED-WNA-RATE-AMT PIC S9(01)V9(05) COMP-3        
                                                          VALUE 0.      
      *********************************************************         02013600
      *   GTT TABLE LAYOUT FOR CSS_RATE_TOU_INSTR RK          *         02013700
      *********************************************************         02013800
           05 GTT-RETURN-FIELDS-RS3.                                    
              10 S-R3-RETURN-CODE        PIC S9(09) COMP  VALUE 0.      
              10 S-R3-APPL-RETURN-CODE   PIC S9(04) COMP  VALUE 0.      
              10 S-R3-CMPNT-ID-CD        PIC X(02)  VALUE SPACE.        
              10 S-R3-CODE-TIME-PERIOD   PIC S9(04) COMP  VALUE 0.      
              10 S-R3-CODE-SEASON        PIC X(01)  VALUE SPACE.        
              10 S-R3-MAX-DEMAND-IND     PIC X(01)  VALUE SPACE.        
              10 S-R3-RATE-MIN-IND       PIC X(01)  VALUE SPACE.        
              10 S-R3-CNTRCT-MIN-IND     PIC X(01)  VALUE SPACE.        
              10 S-R3-MRG-OFF-PK-IND     PIC X(01)  VALUE SPACE.        
              10 S-R3-MRG-RT-MIN         PIC X(01)  VALUE SPACE.        
              10 S-R3-MRG-CTR-MIN-IND    PIC X(01)  VALUE SPACE.        
              10 S-R3-RATCHET-ID-1       PIC X(01)  VALUE SPACE.        
              10 S-R3-RATCHET-ID-2       PIC X(01)  VALUE SPACE.        
              10 S-R3-RATCHET-ID-3       PIC X(01)  VALUE SPACE.        
              10 S-R3-CNTRCT-MIN-PCT     PIC S9(02)V9(03) USAGE         
                                                   COMP-3 VALUE 0.      
      *********************************************************         02015600
      *   GTT TABLE LAYOUT FOR CSS_DEMAND_RATCHET J2          *         02015700
      *********************************************************         02015800
           05 GTT-RETURN-FIELDS-RS4.                                    
              10 S-R4-RETURN-CODE        PIC S9(09) COMP  VALUE 0.      
              10 S-R4-APPL-RETURN-CODE   PIC S9(04) COMP  VALUE 0.      
              10 S-R4-RATCHET-ID         PIC S9(04) USAGE COMP          
                                                          VALUE 0.      
              10 S-R4-FROM-MONTH         PIC S9(04) USAGE COMP          
                                                          VALUE 0.      
              10 S-R4-TO-MONTH           PIC S9(04) USAGE COMP          
                                                          VALUE 0.      
              10 S-R4-RATCHET-PCT        PIC S9(03)V9(02) COMP-3        
                                                          VALUE 0.      
              10 S-R4-RATCHET-YR-IND     PIC X(01)  VALUE SPACE.        
              10 S-R4-RATCHET-EXISTS     PIC X(01)  VALUE SPACE.        
      *********************************************************         02017700
      *   GTT TABLE LAYOUT FOR CSS_SPCL_FCTR SF               *         02017800
      *********************************************************         02017900
           05 GTT-RETURN-FIELDS-RS5.                                    
              10 S-R5-RETURN-CODE        PIC S9(09) COMP   VALUE 0.     
              10 S-R5-APPL-RETURN-CODE   PIC S9(04) COMP   VALUE 0.     
              10 S-R5-BFC-SEASONAL-FL    PIC X(01)  VALUE  SPACE.       
              10 S-R5-AMT-CUST-CHRG      PIC S9(05)V9(02)  USAGE        
                                                    COMP-3 VALUE 0.     
              10 S-R5-WINTER-AMT-CUST-CHRG                              
                                         PIC S9(05)V9(02)  USAGE        
                                                    COMP-3 VALUE 0.     
              10 S-R5-WINTER-ADJ-AMT     PIC S9(03)V9(06)  USAGE        
                                                    COMP-3 VALUE 0.     
                                                                        
      ******************************************************************02070000
      *    DB2 INCLUDES                                                *02080000
      ******************************************************************02090000
                                                                        
           EXEC SQL                                                     02110000
              INCLUDE SQLCA                                             02120000
           END-EXEC.                                                    02130000
                                                                        
      *-------< INCLUDE CSS_RATE_COMP_DEF J1 >                          02150000
           EXEC SQL                                                     02160000
              INCLUDE TBRTCDEF                                          02170000
           END-EXEC.                                                    02180000
                                                                        
      *-------< INCLUDE CSS_DEMAND_INSTR DI >                           02250000
           EXEC SQL                                                     02260000
              INCLUDE TBDMDINS                                          02270000
           END-EXEC.                                                    02280000
                                                                        
      *-------< INCLUDE CSS_PRICE_SCHED PS >                            02300000
           EXEC SQL                                                     02310000
              INCLUDE TBPRCSCH                                          02320000
           END-EXEC.                                                    02330000
                                                                        
      *-------< INCLUDE CSS_RATE_TOU_INSTR RK >                         02350000
           EXEC SQL                                                     02360000
              INCLUDE TBRTTOU                                           02370000
           END-EXEC.                                                    02380000
                                                                        
      *-------< INCLUDE CSS_DEMAND_RATCHET J2 >                         02400000
           EXEC SQL                                                     02410000
              INCLUDE TBDEMRCH                                          02420000
           END-EXEC.                                                    02430000
                                                                        
      *-------< INCLUDE CSS_RATE_VRSN_DEF J4 >                          02450000
           EXEC SQL                                                     02460000
              INCLUDE TBRTVRSN                                          02470000
           END-EXEC.                                                    02480000
                                                                        
      *-------< INCLUDE CSS_RATE_CREATOR RT >                           02500000
           EXEC SQL                                                     02510000
              INCLUDE TBRTCRTR                                          02511000
           END-EXEC.                                                    02512000
                                                                        
      *-------< INCLUDE CSS_SPCL_FCTR_APPL SA >                         02514000
           EXEC SQL                                                     02515000
              INCLUDE TBSPLAPL                                          02516000
           END-EXEC.                                                    02517000
                                                                        
      *-------< INCLUDE CSS_SPCL_FCTR SF >                              02519000
           EXEC SQL                                                     02519100
              INCLUDE TBSPLFTR                                          02519200
           END-EXEC.                                                    02519300
                                                                        
      ******************************************************************02519500
      *    COBOL WORKING STORAGE COPY BOOKS                            *02519600
      ******************************************************************02519700
                                                                        
      *--------<ERROR HANDLING >                                        02519900
           EXEC SQL                                                     02520000
               INCLUDE CWSX0010                                         02520100
           END-EXEC.                                                    02520200
                                                                        
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  02520400
           COPY CWS00303.                                               02520500
                                                                        
      *--------<WORK AREAS TO XFER DATA >                               02520700
           COPY CCA00001.                                               02520800
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       02521000
           COPY CWS00027.                                               02521100
                                                                        
      ******************************************************************02522000
      *    CURSOR DECLARATIONS                                         *02530000
      ******************************************************************02540000
      *** J1-RT-COMP-DEF CURSOR:                              ***       02560100
      *** FETCH ALL ROWS IN THE CSS_RATE_COMP_DEF TABLE FOR   ***       02560200
      *** THE SPECIFIED CRITERIA                              ***       02560300
      ***********************************************************       02561000
                                                                        
           EXEC SQL DECLARE J1-RT-COMP-DEF CURSOR FOR                   
               SELECT   CMPNT_ID_CD                                     
                       ,REG_TYPE_CD                                     
                       ,ENERGY_UNIT_CD                                  
                       ,ENERGY_SEAS_CD                                  
                       ,LAST_ENERGY_BLOCK                               
                       ,DEM_REG_TYPE_CD                                 
                       ,DEM_UNIT_CD                                     
                       ,DEM_SEASON_CD                                   
                       ,LAST_DEM_BLOCK                                  
                       ,ON_PEAK_DAYS                                    
                       ,CALENDAR_CD                                     
                       ,BAL_FWD_CD                                      
                       ,BAL_RESET_MMDD                                  
                       ,BAL_RESET_PRO_CD                                
                       ,BAL_OFFSET_TOU_CD                               
                 FROM   CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                 
                WHERE   CODE_UTIL_TYPE    = :J1-CODE-UTIL-TYPE          
                  AND   RATE_PLAN_NO      = :J1-RATE-PLAN-NO            
                  AND   VERSION_NO_CNTRL  = :J1-VERSION-NO-CNTRL        
               ORDER BY CMPNT_ID_CD                                     
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE J1-RT-COMP-DEF CURSOR FOR                   02580000
MFA-TR*        SELECT   CMPNT_ID_CD                                     02590000
MFA-TR*                ,REG_TYPE_CD                                     02600000
MFA-TR*                ,ENERGY_UNIT_CD                                  02610000
MFA-TR*                ,ENERGY_SEAS_CD                                  02620000
MFA-TR*                ,LAST_ENERGY_BLOCK                               02630000
MFA-TR*                ,DEM_REG_TYPE_CD                                 02640000
MFA-TR*                ,DEM_UNIT_CD                                     02650000
MFA-TR*                ,DEM_SEASON_CD                                   02660000
MFA-TR*                ,LAST_DEM_BLOCK                                  02670000
MFA-TR*                ,ON_PEAK_DAYS                                    02690000
MFA-TR*                ,CALENDAR_CD                                     02700000
MFA-TR*                ,BAL_FWD_CD                                      02701000
MFA-TR*                ,BAL_RESET_MMDD                                  02702000
MFA-TR*                ,BAL_RESET_PRO_CD                                02703000
MFA-TR*                ,BAL_OFFSET_TOU_CD                               02704000
MFA-TR*          FROM   CSS_RATE_COMP_DEF                               02710000
MFA-TR*         WHERE   CODE_UTIL_TYPE    = :J1-CODE-UTIL-TYPE          02720000
MFA-TR*           AND   RATE_PLAN_NO      = :J1-RATE-PLAN-NO            02730000
MFA-TR*           AND   VERSION_NO_CNTRL  = :J1-VERSION-NO-CNTRL        02740000
MFA-TR*        ORDER BY CMPNT_ID_CD                                     02741000
MFA-TR*        FOR FETCH ONLY WITH UR                                   02742000
MFA-TR*        QUERYNO 7110                                             02743000
MFA-TR*    END-EXEC.                                                    02750000
                                                                        
      ***********************************************************       02751100
      *** PS-PRICE-SCHED CURSOR:                              ***       02752000
      *** FETCH ALL ROWS IN THE CSS_PRICE_SCHED TABLE FOR THE ***       02753000
      *** SPECIFIED CRITERIA                                  ***       02755000
      ***********************************************************       02756000
                                                                        
           EXEC SQL                                                     
             DECLARE PS-PRICE-SCHED CURSOR FOR                          
             SELECT  CMPNT_ID_CD                                        
                    ,CODE_USE_INST_TYPE                                 
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_SEASON                                        
                    ,BLOCK_NO                                           
                    ,BLOCK_USE_OR_SVCS                                  
                    ,BLOCK_DESC                                         
                    ,SCHED_PRICE_AM                                     
                    ,PRICE_TYPE_CD                                      
                    ,SCHED_WNA_RATE_AMT                                 
               FROM  CSS_PRICE_SCHED WITH(READUNCOMMITTED)                      
              WHERE  CODE_UTIL_TYPE       = :PS-CODE-UTIL-TYPE          
                AND  RATE_PLAN_NO         = :PS-RATE-PLAN-NO            
                AND  VERSION_NO_CNTRL     = :PS-VERSION-NO-CNTRL        
                AND  CMPNT_ID_CD          = :PS-CMPNT-ID-CD             
             ORDER BY CMPNT_ID_CD                                       
                     ,CODE_USE_INST_TYPE                                
                     ,CODE_TIME_PERIOD                                  
                     ,CODE_SEASON                                       
                     ,BLOCK_NO                                          
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02758000
MFA-TR*      DECLARE PS-PRICE-SCHED CURSOR FOR                          02759000
MFA-TR*      SELECT  CMPNT_ID_CD                                        02759100
MFA-TR*             ,CODE_USE_INST_TYPE                                 02759200
MFA-TR*             ,CODE_TIME_PERIOD                                   02759300
MFA-TR*             ,CODE_SEASON                                        02759400
MFA-TR*             ,BLOCK_NO                                           02759500
MFA-TR*             ,BLOCK_USE_OR_SVCS                                  02759600
MFA-TR*             ,BLOCK_DESC                                         02759700
MFA-TR*             ,SCHED_PRICE_AM                                     02759800
MFA-TR*             ,PRICE_TYPE_CD                                      02759900
MFA-TR*             ,SCHED_WNA_RATE_AMT                                 02760000
MFA-TR*        FROM  CSS_PRICE_SCHED                                    02760100
MFA-TR*       WHERE  CODE_UTIL_TYPE       = :PS-CODE-UTIL-TYPE          02760200
MFA-TR*         AND  RATE_PLAN_NO         = :PS-RATE-PLAN-NO            02760300
MFA-TR*         AND  VERSION_NO_CNTRL     = :PS-VERSION-NO-CNTRL        02760400
MFA-TR*         AND  CMPNT_ID_CD          = :PS-CMPNT-ID-CD             02761000
MFA-TR*      ORDER BY CMPNT_ID_CD                                       02762000
MFA-TR*              ,CODE_USE_INST_TYPE                                02763000
MFA-TR*              ,CODE_TIME_PERIOD                                  02764000
MFA-TR*              ,CODE_SEASON                                       02765000
MFA-TR*              ,BLOCK_NO                                          02765100
MFA-TR*      FOR FETCH ONLY WITH UR                                     02766000
MFA-TR*      QUERYNO 7210                                               02767000
MFA-TR*    END-EXEC.                                                    02770000
                                                                        
      ***********************************************************       02790100
      *** RK-PRICE-TOU CURSOR:                                ***       02790200
      *** FETCH ALL ROWS IN THE CSS_RATE-TOU-INSTR TABLE FOR  ***       02790300
      *** THE SPECIFIED CRITERIA                              ***       02790400
      ***********************************************************       02790500
                                                                        
           EXEC SQL                                                     
             DECLARE RK-PRICE-TOU CURSOR FOR                            
             SELECT  CMPNT_ID_CD                                        
                    ,CODE_TIME_PERIOD                                   
                    ,CODE_SEASON                                        
                    ,MAX_DEMAND_IND                                     
                    ,RATE_MIN_IND                                       
                    ,CNTRCT_MIN_IND                                     
                    ,MRG_OFF_PK_IND                                     
                    ,MRG_RT_MIN                                         
                    ,MRG_CTR_MIN_IND                                    
                    ,RATCHET_ID_1                                       
                    ,RATCHET_ID_2                                       
                    ,RATCHET_ID_3                                       
                    ,CNTRCT_MIN_PCT                                     
               FROM  CSS_RATE_TOU_INSTR WITH(READUNCOMMITTED)                   
              WHERE  CODE_UTIL_TYPE       = :RK-CODE-UTIL-TYPE          
                AND  RATE_PLAN_NO         = :RK-RATE-PLAN-NO            
                AND  VERSION_NO_CNTRL     = :RK-VERSION-NO-CNTRL        
                AND  CMPNT_ID_CD          = :RK-CMPNT-ID-CD             
             ORDER BY CMPNT_ID_CD                                       
                     ,CODE_TIME_PERIOD                                  
                     ,CODE_SEASON                                       
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02790700
MFA-TR*      DECLARE RK-PRICE-TOU CURSOR FOR                            02790800
MFA-TR*      SELECT  CMPNT_ID_CD                                        02790900
MFA-TR*             ,CODE_TIME_PERIOD                                   02791000
MFA-TR*             ,CODE_SEASON                                        02791100
MFA-TR*             ,MAX_DEMAND_IND                                     02791200
MFA-TR*             ,RATE_MIN_IND                                       02791300
MFA-TR*             ,CNTRCT_MIN_IND                                     02791400
MFA-TR*             ,MRG_OFF_PK_IND                                     02791500
MFA-TR*             ,MRG_RT_MIN                                         02791600
MFA-TR*             ,MRG_CTR_MIN_IND                                    02791700
MFA-TR*             ,RATCHET_ID_1                                       02791800
MFA-TR*             ,RATCHET_ID_2                                       02791900
MFA-TR*             ,RATCHET_ID_3                                       02792000
MFA-TR*             ,CNTRCT_MIN_PCT                                     02792100
MFA-TR*        FROM  CSS_RATE_TOU_INSTR                                 02792300
MFA-TR*       WHERE  CODE_UTIL_TYPE       = :RK-CODE-UTIL-TYPE          02792400
MFA-TR*         AND  RATE_PLAN_NO         = :RK-RATE-PLAN-NO            02792500
MFA-TR*         AND  VERSION_NO_CNTRL     = :RK-VERSION-NO-CNTRL        02792600
MFA-TR*         AND  CMPNT_ID_CD          = :RK-CMPNT-ID-CD             02792700
MFA-TR*      ORDER BY CMPNT_ID_CD                                       02792800
MFA-TR*              ,CODE_TIME_PERIOD                                  02793000
MFA-TR*              ,CODE_SEASON                                       02793100
MFA-TR*      FOR FETCH ONLY WITH UR                                     02793200
MFA-TR*      QUERYNO 7310                                               02793300
MFA-TR*    END-EXEC.                                                    02793400
                                                                        
      ***********************************************************       02793600
      *** J2-DMND-RTCHT CURSOR:                               ***       02793700
      *** FETCH ALL ROWS IN THE CSS_DEMAND_RATCHET TABLE FOR  ***       02793800
      *** THE SPECIFIED CRITERIA                              ***       02793900
      ***********************************************************       02794000
                                                                        
           EXEC SQL DECLARE J2-DMND-RTCHT CURSOR FOR                    
               SELECT  RATCHET_ID                                       
                      ,FROM_MONTH                                       
                      ,TO_MONTH                                         
                      ,RATCHET_PCT                                      
                      ,RATCHET_YR_IND                                   
                      ,'Y'                                              
                 FROM  CSS_DEMAND_RATCHET WITH(READUNCOMMITTED)                 
                WHERE  CODE_UTIL_TYPE     = :J2-CODE-UTIL-TYPE          
                  AND  RATE_PLAN_NO       = :J2-RATE-PLAN-NO            
                  AND  VERSION_NO_CNTRL   = :J2-VERSION-NO-CNTRL        
               ORDER BY RATCHET_ID                                      
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE J2-DMND-RTCHT CURSOR FOR                    02794200
MFA-TR*        SELECT  RATCHET_ID                                       02794300
MFA-TR*               ,FROM_MONTH                                       02794400
MFA-TR*               ,TO_MONTH                                         02794500
MFA-TR*               ,RATCHET_PCT                                      02794600
MFA-TR*               ,RATCHET_YR_IND                                   02794700
MFA-TR*               ,'Y'                                              02794800
MFA-TR*          FROM  CSS_DEMAND_RATCHET                               02794900
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :J2-CODE-UTIL-TYPE          02795000
MFA-TR*           AND  RATE_PLAN_NO       = :J2-RATE-PLAN-NO            02795100
MFA-TR*           AND  VERSION_NO_CNTRL   = :J2-VERSION-NO-CNTRL        02795200
MFA-TR*        ORDER BY RATCHET_ID                                      02795300
MFA-TR*        FOR FETCH ONLY WITH UR                                   02795400
MFA-TR*        QUERYNO 7410                                             02795500
MFA-TR*    END-EXEC.                                                    02795600
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID        PIC X(03).                          
       01  PARM-USER_ID             PIC X(07).                          
       01  PARM-CODE-UTIL-TYPE      PIC X(01).                          
       01  PARM-RATE-PLAN-NO        PIC X(03).                          
       01  PARM-VERSION-NO-CNTRL    PIC X(04).                          
                                                                        
       PROCEDURE DIVISION USING                                         
                 PARM-APPL-PROG-ID                                      
               , PARM-USER_ID                                           
               , PARM-CODE-UTIL-TYPE                                    
               , PARM-RATE-PLAN-NO                                      
               , PARM-VERSION-NO-CNTRL.                                 
                                                                        
      ******************************************************************03420000
      * 0000-MAINLINE                                                  *03430000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03490000
      ******************************************************************03500000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03620000
      * 0100A-DECLARE-GTT-R1 - CSS_RATE_COMP_DEF                       *03630000
      ******************************************************************03740000
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04456_R1'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04456_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04456_R1
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,CMPNT_ID_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,REG_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,ENERGY_UNIT_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,ENERGY_SEAS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,LAST_ENERGY_BLOCK        SMALLINT                        
              ,DEM_REG_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,DEM_UNIT_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,DEM_SEASON_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,LAST_DEM_BLOCK           SMALLINT                        
              ,AMT_MIN_CHRG             DECIMAL(13,2)                   
              ,QTY_MIN_USAGE            DECIMAL(13,2)                   
              ,MIN_DMD_CHRG             DECIMAL(13,2)                   
              ,MIN_DMD_QTY              DECIMAL(11,0)                   
              ,PWR_FCTR_MIN_PCT         DECIMAL(05,5)                   
              ,LFTM_PEAK_PCT            DECIMAL(05,2)                   
              ,LD_FCTR_MIN_PCT          DECIMAL(05,5)                   
              ,ON_PEAK_DAYS CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CALENDAR_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,BAL_FWD_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,BAL_RESET_MMDD           SMALLINT                        
              ,BAL_RESET_PRO_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,BAL_OFFSET_TOU_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS   THRU 8000A-EXIT           
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL             
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE WS-GTT-NAME           TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,LTRIM(RTRIM(CMPNT_ID_CD))        AS CMPNT_ID_CD              
                 ,LTRIM(RTRIM(REG_TYPE_CD))        AS REG_TYPE_CD              
                 ,LTRIM(RTRIM(ENERGY_UNIT_CD))     AS ENERGY_UNIT_CD           
                 ,LTRIM(RTRIM(ENERGY_SEAS_CD))     AS ENERGY_SEAS_CD           
                 ,LAST_ENERGY_BLOCK                                     
                 ,LTRIM(RTRIM(DEM_REG_TYPE_CD))    AS DEM_REG_TYPE_CD          
                 ,LTRIM(RTRIM(DEM_UNIT_CD))        AS DEM_UNIT_CD              
                 ,LTRIM(RTRIM(DEM_SEASON_CD))      AS DEM_SEASON_CD            
                 ,LAST_DEM_BLOCK                                        
                 ,AMT_MIN_CHRG                                          
                 ,QTY_MIN_USAGE                                         
                 ,MIN_DMD_CHRG                                          
                 ,MIN_DMD_QTY                                           
                 ,PWR_FCTR_MIN_PCT                                      
                 ,LFTM_PEAK_PCT                                         
                 ,LD_FCTR_MIN_PCT                                       
                 ,LTRIM(RTRIM(ON_PEAK_DAYS))       AS ON_PEAK_DAYS             
                 ,LTRIM(RTRIM(CALENDAR_CD))        AS CALENDAR_CD              
                 ,BAL_FWD_CD                                            
                 ,BAL_RESET_MMDD                                        
                 ,BAL_RESET_PRO_CD                                      
                 ,BAL_OFFSET_TOU_CD                                     
               FROM #CSR04456_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04570200
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            04570300
MFA-TR*                          WITH ROWSET POSITIONING FOR            04570400
MFA-TR*        SELECT                                                   04570500
MFA-TR*           RETURN_CODE                                           04570600
MFA-TR*          ,APPL_RETURN_CODE                                      04570700
MFA-TR*          ,STRIP(CMPNT_ID_CD)        AS CMPNT_ID_CD              04570800
MFA-TR*          ,STRIP(REG_TYPE_CD)        AS REG_TYPE_CD              04570900
MFA-TR*          ,STRIP(ENERGY_UNIT_CD)     AS ENERGY_UNIT_CD           04571000
MFA-TR*          ,STRIP(ENERGY_SEAS_CD)     AS ENERGY_SEAS_CD           04571100
MFA-TR*          ,LAST_ENERGY_BLOCK                                     04571200
MFA-TR*          ,STRIP(DEM_REG_TYPE_CD)    AS DEM_REG_TYPE_CD          04571300
MFA-TR*          ,STRIP(DEM_UNIT_CD)        AS DEM_UNIT_CD              04571400
MFA-TR*          ,STRIP(DEM_SEASON_CD)      AS DEM_SEASON_CD            04571500
MFA-TR*          ,LAST_DEM_BLOCK                                        04571600
MFA-TR*          ,AMT_MIN_CHRG                                          04571700
MFA-TR*          ,QTY_MIN_USAGE                                         04571800
MFA-TR*          ,MIN_DMD_CHRG                                          04571900
MFA-TR*          ,MIN_DMD_QTY                                           04572000
MFA-TR*          ,PWR_FCTR_MIN_PCT                                      04572100
MFA-TR*          ,LFTM_PEAK_PCT                                         04572200
MFA-TR*          ,LD_FCTR_MIN_PCT                                       04572300
MFA-TR*          ,STRIP(ON_PEAK_DAYS)       AS ON_PEAK_DAYS             04572400
MFA-TR*          ,STRIP(CALENDAR_CD)        AS CALENDAR_CD              04572500
MFA-TR*          ,BAL_FWD_CD                                            04572600
MFA-TR*          ,BAL_RESET_MMDD                                        04572700
MFA-TR*          ,BAL_RESET_PRO_CD                                      04572800
MFA-TR*          ,BAL_OFFSET_TOU_CD                                     04572900
MFA-TR*        FROM SESSION.CSR04456_R1                                 04573000
MFA-TR*    END-EXEC.                                                    04573100
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************04611000
      * 0100B-DECLARE-GTT-R2 - CSS_PRICE_SCHED                         *04612000
      ******************************************************************04614000
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04456_R2'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04456_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04456_R2
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,CMPNT_ID_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,CODE_USE_INST_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,CODE_TIME_PERIOD         SMALLINT                        
              ,CODE_SEASON CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,BLOCK_NO                 SMALLINT                        
              ,BLOCK_USE_OR_SVCS        DECIMAL(09,0)                   
              ,BLOCK_DESC CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,SCHED_PRICE_AM           DECIMAL(11,6)                   
              ,PRICE_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,SCHED_WNA_RATE_AMT       DECIMAL(06,5)                   
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DELETE-GTT-ROWS   THRU 8000B-EXIT           
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL             
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100B'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE WS-GTT-NAME           TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,LTRIM(RTRIM(CMPNT_ID_CD))        AS CMPNT_ID_CD              
                 ,LTRIM(RTRIM(CODE_USE_INST_TYPE)) AS CODE_USE_INST_TYPE       
                 ,CODE_TIME_PERIOD          AS CODE_TIME_PERIOD         
                 ,LTRIM(RTRIM(CODE_SEASON))        AS CODE_SEASON              
                 ,BLOCK_NO                  AS BLOCK_NO                 
                 ,BLOCK_USE_OR_SVCS         AS BLOCK_USE_OR_SVCS        
                 ,LTRIM(RTRIM(BLOCK_DESC))         AS BLOCK_DESC               
                 ,SCHED_PRICE_AM            AS SCHED_PRICE_AM           
                 ,LTRIM(RTRIM(PRICE_TYPE_CD))      AS PRICE_TYPE_CD            
                 ,SCHED_WNA_RATE_AMT        AS SCHED_WNA_RATE_AMT       
               FROM #CSR04456_R2                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04624400
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                            04624500
MFA-TR*                          WITH ROWSET POSITIONING FOR            04624600
MFA-TR*        SELECT                                                   04624700
MFA-TR*           RETURN_CODE                                           04624800
MFA-TR*          ,APPL_RETURN_CODE                                      04624900
MFA-TR*          ,STRIP(CMPNT_ID_CD)        AS CMPNT_ID_CD              04625000
MFA-TR*          ,STRIP(CODE_USE_INST_TYPE) AS CODE_USE_INST_TYPE       04625100
MFA-TR*          ,CODE_TIME_PERIOD          AS CODE_TIME_PERIOD         04625200
MFA-TR*          ,STRIP(CODE_SEASON)        AS CODE_SEASON              04625300
MFA-TR*          ,BLOCK_NO                  AS BLOCK_NO                 04625400
MFA-TR*          ,BLOCK_USE_OR_SVCS         AS BLOCK_USE_OR_SVCS        04625500
MFA-TR*          ,STRIP(BLOCK_DESC)         AS BLOCK_DESC               04625600
MFA-TR*          ,SCHED_PRICE_AM            AS SCHED_PRICE_AM           04625700
MFA-TR*          ,STRIP(PRICE_TYPE_CD)      AS PRICE_TYPE_CD            04625800
MFA-TR*          ,SCHED_WNA_RATE_AMT        AS SCHED_WNA_RATE_AMT       04625900
MFA-TR*        FROM SESSION.CSR04456_R2                                 04627200
MFA-TR*    END-EXEC.                                                    04627300
                                                                        
       0100B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************04627800
      * 0100C-DECLARE-GTT-R3 - CSS_RATE_TOU_INSTR                      *04627900
      ******************************************************************04628100
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04456_R3'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04456_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04456_R3
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,CMPNT_ID_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,CODE_TIME_PERIOD         SMALLINT                        
              ,CODE_SEASON CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,MAX_DEMAND_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,RATE_MIN_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CNTRCT_MIN_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,MRG_OFF_PK_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,MRG_RT_MIN CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,MRG_CTR_MIN_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,RATCHET_ID_1 CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,RATCHET_ID_2 CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,RATCHET_ID_3 CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,CNTRCT_MIN_PCT           DECIMAL(05,3)                   
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DELETE-GTT-ROWS   THRU 8000C-EXIT           
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL             
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100C'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE WS-GTT-NAME           TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,LTRIM(RTRIM(CMPNT_ID_CD))        AS CMPNT_ID_CD              
                 ,CODE_TIME_PERIOD          AS CODE_TIME_PERIOD         
                 ,LTRIM(RTRIM(CODE_SEASON))        AS CODE_SEASON              
                 ,LTRIM(RTRIM(MAX_DEMAND_IND))     AS MAX_DEMAND_IND           
                 ,LTRIM(RTRIM(RATE_MIN_IND))       AS RATE_MIN_IND             
                 ,LTRIM(RTRIM(CNTRCT_MIN_IND))     AS CNTRCT_MIN_IND           
                 ,LTRIM(RTRIM(MRG_OFF_PK_IND))     AS MRG_OFF_PK_IND           
                 ,LTRIM(RTRIM(MRG_RT_MIN))         AS MRG_RT_MIN               
                 ,LTRIM(RTRIM(MRG_CTR_MIN_IND))    AS MRG_CTR_MIN_IND          
                 ,LTRIM(RTRIM(RATCHET_ID_1))       AS RATCHET_ID_1             
                 ,LTRIM(RTRIM(RATCHET_ID_2))       AS RATCHET_ID_2             
                 ,LTRIM(RTRIM(RATCHET_ID_3))       AS RATCHET_ID_3             
                 ,CNTRCT_MIN_PCT            AS CNTRCT_MIN_PCT           
               FROM #CSR04456_R3                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04633100
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                            04633200
MFA-TR*                          WITH ROWSET POSITIONING FOR            04633300
MFA-TR*        SELECT                                                   04633400
MFA-TR*           RETURN_CODE                                           04633500
MFA-TR*          ,APPL_RETURN_CODE                                      04633600
MFA-TR*          ,STRIP(CMPNT_ID_CD)        AS CMPNT_ID_CD              04633700
MFA-TR*          ,CODE_TIME_PERIOD          AS CODE_TIME_PERIOD         04633900
MFA-TR*          ,STRIP(CODE_SEASON)        AS CODE_SEASON              04634000
MFA-TR*          ,STRIP(MAX_DEMAND_IND)     AS MAX_DEMAND_IND           04634100
MFA-TR*          ,STRIP(RATE_MIN_IND)       AS RATE_MIN_IND             04634200
MFA-TR*          ,STRIP(CNTRCT_MIN_IND)     AS CNTRCT_MIN_IND           04634300
MFA-TR*          ,STRIP(MRG_OFF_PK_IND)     AS MRG_OFF_PK_IND           04634400
MFA-TR*          ,STRIP(MRG_RT_MIN)         AS MRG_RT_MIN               04634500
MFA-TR*          ,STRIP(MRG_CTR_MIN_IND)    AS MRG_CTR_MIN_IND          04634600
MFA-TR*          ,STRIP(RATCHET_ID_1)       AS RATCHET_ID_1             04634700
MFA-TR*          ,STRIP(RATCHET_ID_2)       AS RATCHET_ID_2             04634800
MFA-TR*          ,STRIP(RATCHET_ID_3)       AS RATCHET_ID_3             04634900
MFA-TR*          ,CNTRCT_MIN_PCT            AS CNTRCT_MIN_PCT           04635000
MFA-TR*        FROM SESSION.CSR04456_R3                                 04635100
MFA-TR*    END-EXEC.                                                    04635200
                                                                        
       0100C-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************04635700
      * 0100D-DECLARE-GTT-R4 - CSS_DEMAND_RATCHET                      *04635800
      ******************************************************************04636000
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE 'SESSION.CSR04456_R4'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04456_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04456_R4
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,RATCHET_ID               SMALLINT                        
              ,FROM_MONTH               SMALLINT                        
              ,TO_MONTH                 SMALLINT                        
              ,RATCHET_PCT              DECIMAL(05,2)                   
              ,RATCHET_YR_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,RATCHET_EXISTS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DELETE-GTT-ROWS   THRU 8000D-EXIT           
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL             
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100D'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE WS-GTT-NAME           TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,RATCHET_ID                                            
                 ,FROM_MONTH                                            
                 ,TO_MONTH                                              
                 ,RATCHET_PCT                                           
                 ,LTRIM(RTRIM(RATCHET_YR_IND))      AS RATCHET_YR_IND          
                 ,LTRIM(RTRIM(RATCHET_EXISTS))      AS RATCHET_EXISTS          
               FROM #CSR04456_R4                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04640900
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                            04641000
MFA-TR*                          WITH ROWSET POSITIONING FOR            04641100
MFA-TR*        SELECT                                                   04641200
MFA-TR*           RETURN_CODE                                           04641300
MFA-TR*          ,APPL_RETURN_CODE                                      04641400
MFA-TR*          ,RATCHET_ID                                            04641500
MFA-TR*          ,FROM_MONTH                                            04641600
MFA-TR*          ,TO_MONTH                                              04641700
MFA-TR*          ,RATCHET_PCT                                           04641800
MFA-TR*          ,STRIP(RATCHET_YR_IND)      AS RATCHET_YR_IND          04641900
MFA-TR*          ,STRIP(RATCHET_EXISTS)      AS RATCHET_EXISTS          04642000
MFA-TR*        FROM SESSION.CSR04456_R4                                 04642800
MFA-TR*    END-EXEC.                                                    04642900
                                                                        
       0100D-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************04643400
      * 0100E-DECLARE-GTT-R5 - CSS_SPCL_FCTR_APPL                      *04643500
      ******************************************************************04643700
       0100E-DECLARE-GTT-R5.                                            
                                                                        
           MOVE 'SESSION.CSR04456_R5'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04456_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04456_R5
              (                                                          
               RETURN_CODE              INT                         
              ,APPL_RETURN_CODE         INT                         
              ,BFC_SEASONAL_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,AMT_CUST_CHRG            DECIMAL(07,2)                   
              ,WINTER_AMT_CUST_CHRG     DECIMAL(07,2)                   
              ,WINTER_ADJ_AMT           DECIMAL(09,6)                   
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DELETE-GTT-ROWS   THRU 8000E-EXIT           
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL             
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100E'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE WS-GTT-NAME           TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT            
               END-IF                                                   
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
               SELECT                                                   
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,LTRIM(RTRIM(BFC_SEASONAL_FL))     AS BFC_SEASONAL_FL         
                 ,AMT_CUST_CHRG                                         
                 ,WINTER_AMT_CUST_CHRG                                  
                 ,WINTER_ADJ_AMT                                        
               FROM #CSR04456_R5                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     04647900
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                            04648000
MFA-TR*                          WITH ROWSET POSITIONING FOR            04648100
MFA-TR*        SELECT                                                   04648200
MFA-TR*           RETURN_CODE                                           04648300
MFA-TR*          ,APPL_RETURN_CODE                                      04648400
MFA-TR*          ,STRIP(BFC_SEASONAL_FL)     AS BFC_SEASONAL_FL         04648500
MFA-TR*          ,AMT_CUST_CHRG                                         04648600
MFA-TR*          ,WINTER_AMT_CUST_CHRG                                  04648700
MFA-TR*          ,WINTER_ADJ_AMT                                        04648800
MFA-TR*        FROM SESSION.CSR04456_R5                                 04649100
MFA-TR*    END-EXEC.                                                    04649200
                                                                        
       0100E-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************04649700
      * 1000-PROCESS-INPUT                                             *04650000
      *     1. RECEIVE PARMS.                                          *04680000
      ******************************************************************04690000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-VERSION-NO-CNTRL        TO WS-VERSION-NO-CNTRL.    
                                                                        
           PERFORM 1100-VALIDATE-INPUT       THRU 1100-EXIT.            
                                                                        
           MOVE PARM-CODE-UTIL-TYPE          TO WS-CODE-UTIL-TYPE       
                                                J1-CODE-UTIL-TYPE       
                                                J2-CODE-UTIL-TYPE       
                                                J4-CODE-UTIL-TYPE       
                                                DI-CODE-UTIL-TYPE       
                                                RT-CODE-UTIL-TYPE.      
                                                                        
           MOVE PARM-RATE-PLAN-NO            TO WS-RATE-PLAN-NO         
                                                J1-RATE-PLAN-NO         
                                                J2-RATE-PLAN-NO         
                                                J4-RATE-PLAN-NO         
                                                DI-RATE-PLAN-NO         
                                                RT-RATE-PLAN-NO.        
                                                                        
           MOVE PARM-VERSION-NO-CNTRL        TO J1-VERSION-NO-CNTRL     
                                                J2-VERSION-NO-CNTRL     
                                                J4-VERSION-NO-CNTRL     
                                                DI-VERSION-NO-CNTRL     
                                                RT-VERSION-NO-CNTRL.    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1       THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-R2       THRU 0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT-R3       THRU 0100C-EXIT.          
           PERFORM 0100D-DECLARE-GTT-R4       THRU 0100D-EXIT.          
           PERFORM 0100E-DECLARE-GTT-R5       THRU 0100E-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05450000
      * 1100-VALIDATE-INPUT.                                           *05460000
      *      VALIDATE INPUT PARAMETERS                                 *05520000
      * WHEN INPUT PARAMETERS ARE INVALID PASS APPROPRIATE RETURN CODE *05530000
      ******************************************************************05540000
                                                                        
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF  PARM-CODE-UTIL-TYPE       > SPACES                       
           AND PARM-RATE-PLAN-NO         > SPACES                       
           AND WS-VERSION-NO-CNTRL       > 0                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE SPACES                    TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              MOVE WS-ERROR-CODE-295         TO WS-APPL-RETURN-CODE     
                                                                        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05640000
      * 2000-PROCESS-OUTPUT.                                           *05650000
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *05660000
      *      AND SENDS THEN BACK                                       *05670000
      ******************************************************************05680000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14730000
      * 2200-BUILD-RESULT                                              *14740000
      *     BUILD THE RESULT SET DESCRIBED ABOVE. RETRIEVE COMPONENT   *14810000
      *     DEFINITIONS AND PRICING FOR RATE VERSION.                  *14820000
      ******************************************************************14840000
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 2300-PROCESS-RATE-COMP-PRC THRU 2300-EXIT.           
           PERFORM 2400-PROCESS-DMND-RTCHT    THRU 2400-EXIT.           
           PERFORM 2500-PROCESS-FCLTY-CHRG    THRU 2500-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15162000
      * 2300-PROCESS-RATE-COMP-PRC                                     *15163000
      *     RETRIEVE THE RATE COMPONENT DEFINITION & PRICING.          *15164000
      *     USING COMPONENT ID AND RATE VERSION RETRIEVE PRICE SCHEDULE*15165000
      *     & RATE TOU DETAILS.                                        *15166000
      ******************************************************************15167000
                                                                        
       2300-PROCESS-RATE-COMP-PRC.                                      
                                                                        
           PERFORM 7100-OPEN-J1-RT-COMP-DEF   THRU 7100-EXIT.           
                                                                        
           PERFORM 2310-PROCESS-FETCH-R1      THRU 2310-EXIT            
              UNTIL WS-J1-ACTIVE-RETURN-CODE = NOT-FOUND.               
                                                                        
           IF CTR-ROWS-RS1                = 0                           
              MOVE WS-J1-ACTIVE-RETURN-CODE  TO WS-PS-ACTIVE-RETURN-CODE
              MOVE WS-J1-ACTIVE-RETURN-CODE  TO WS-RK-ACTIVE-RETURN-CODE
              PERFORM 2320-PROCESS-FORMAT-RS1 THRU 2320-EXIT            
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2                = 0                           
              INITIALIZE DCLCSS-PRICE-SCHED                             
              PERFORM 2350-PROCESS-FORMAT-RS2 THRU 2350-EXIT            
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS3                = 0                           
              INITIALIZE DCLCSS-RATE-TOU-INSTR                          
              PERFORM 2380-PROCESS-FORMAT-RS3 THRU 2380-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7120-CLOSE-J1-RT-COMP-DEF  THRU 7120-EXIT.           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15173000
      * 2310-PROCESS-FETCH-R1                                          *15180000
      *     READ EACH RETURNED ROW OF   CSS-RATE-COMP-DEF, FORMAT IT   *15240000
      *     AND SEND IT BACK                                           *15250000
      ******************************************************************15260000
                                                                        
       2310-PROCESS-FETCH-R1.                                           
                                                                        
           PERFORM 7110-FETCH-RATE-COMP-DEF   THRU 7110-EXIT.           
                                                                        
           IF WS-J1-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL             
              MOVE PARM-CODE-UTIL-TYPE       TO PS-CODE-UTIL-TYPE       
                                                RK-CODE-UTIL-TYPE       
                                                                        
              MOVE PARM-RATE-PLAN-NO         TO PS-RATE-PLAN-NO         
                                                RK-RATE-PLAN-NO         
                                                                        
              MOVE PARM-VERSION-NO-CNTRL     TO PS-VERSION-NO-CNTRL     
                                                RK-VERSION-NO-CNTRL     
                                                                        
              MOVE J1-CMPNT-ID-CD            TO DI-CMPNT-ID-CD          
                                                PS-CMPNT-ID-CD          
                                                RK-CMPNT-ID-CD          
                                                                        
              PERFORM 2320-PROCESS-FORMAT-RS1   THRU 2320-EXIT          
              PERFORM 2330-PROCESS-PRC-SCHED    THRU 2330-EXIT          
              PERFORM 2360-PROCESS-RT-TOU-INSTR THRU 2360-EXIT          
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15460100
      * 2320-PROCESS-FORMAT-RS1                                        *15460200
      *     FIND RECORDS CSS_DEMAND_INSTR AND SEND RESULTS BACK        *15460300
      ******************************************************************15460500
                                                                        
       2320-PROCESS-FORMAT-RS1.                                         
                                                                        
           MOVE WS-J1-ACTIVE-RETURN-CODE     TO S-R1-RETURN-CODE.       
           MOVE J1-CMPNT-ID-CD               TO S-R1-CMPNT-ID-CD.       
           MOVE J1-REG-TYPE-CD               TO S-R1-REG-TYPE-CD.       
           MOVE J1-ENERGY-UNIT-CD            TO S-R1-ENERGY-UNIT-CD.    
           MOVE J1-ENERGY-SEAS-CD            TO S-R1-ENERGY-SEAS-CD.    
           MOVE J1-LAST-ENERGY-BLOCK         TO S-R1-LAST-ENERGY-BLOCK. 
           MOVE J1-DEM-REG-TYPE-CD           TO S-R1-DEM-REG-TYPE-CD.   
           MOVE J1-DEM-UNIT-CD               TO S-R1-DEM-UNIT-CD.       
           MOVE J1-DEM-SEASON-CD             TO S-R1-DEM-SEASON-CD.     
           MOVE J1-LAST-DEM-BLOCK            TO S-R1-LAST-DEM-BLOCK.    
           MOVE J1-ON-PEAK-DAYS              TO S-R1-ON-PEAK-DAYS.      
           MOVE J1-CALENDAR-CD               TO S-R1-CALENDAR-CD.       
           MOVE J1-BAL-FWD-CD                TO S-R1-BAL-FWD-CD.        
           MOVE J1-BAL-RESET-MMDD            TO S-R1-BAL-RESET-MMDD.    
           MOVE J1-BAL-RESET-PRO-CD          TO S-R1-BAL-RESET-PRO-CD.  
           MOVE J1-BAL-OFFSET-TOU-CD         TO S-R1-BAL-OFFSET-TOU-CD. 
                                                                        
           MOVE ZEROES                    TO S-R1-AMT-MIN-CHRG.         
           MOVE ZEROES                    TO S-R1-QTY-MIN-USAGE.        
                                                                        
           PERFORM 7010-SELECT-DEMAND-INSTR   THRU 7010-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              MOVE DI-MIN-DMD-CHRG           TO S-R1-MIN-DMD-CHRG       
              MOVE DI-MIN-DMD-QTY            TO S-R1-MIN-DMD-QTY        
              COMPUTE S-R1-LFTM-PEAK-PCT    =                           
                                         DI-LFTM-PEAK-PCT * 100         
              COMPUTE S-R1-PWR-FCTR-MIN-PCT =                           
                                         DI-PWR-FCTR-MIN-PCT / 100      
              COMPUTE S-R1-LD-FCTR-MIN-PCT  =                           
                                         DI-LD-FCTR-MIN-PCT / 100       
           ELSE                                                         
              MOVE ZEROES                    TO S-R1-MIN-DMD-CHRG       
              MOVE ZEROES                    TO S-R1-MIN-DMD-QTY        
              MOVE ZEROES                    TO S-R1-PWR-FCTR-MIN-PCT   
              MOVE ZEROES                    TO S-R1-LFTM-PEAK-PCT      
              MOVE ZEROES                    TO S-R1-LD-FCTR-MIN-PCT    
           END-IF.                                                      
                                                                        
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15466300
      * 2330-PROCESS-PRC-SCHED                                         *15466400
      *     READ EACH RETURNED ROW OF CSS-PRICE-SCHED, FORMAT IT AND   *15466500
      *     SEND IT BACK                                               *15466600
      ******************************************************************15466700
                                                                        
       2330-PROCESS-PRC-SCHED.                                          
           MOVE 0                            TO                         
                                             WS-PS-ACTIVE-RETURN-CODE.  
           PERFORM 7200-OPEN-PS-PRICE-SCHED   THRU 7200-EXIT.           
                                                                        
           PERFORM 2340-PROCESS-FETCH-RS2     THRU 2340-EXIT            
              UNTIL WS-PS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.           
                                                                        
           PERFORM 7220-CLOSE-PS-PRICE-SCHED  THRU 7220-EXIT.           
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15471600
      * 2340-PROCESS-FETCH-RS2                                         *15471700
      * RETRIEVE ROW FROM CSS-PRICE-SCHED                               15471800
      ******************************************************************15472000
                                                                        
       2340-PROCESS-FETCH-RS2.                                          
                                                                        
           PERFORM 7210-FETCH-PRICE-SCHED     THRU 7210-EXIT            
                                                                        
           IF WS-PS-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL             
              PERFORM 2350-PROCESS-FORMAT-RS2 THRU 2350-EXIT            
           END-IF.                                                      
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15475000
      * 2350-PROCESS-FORMAT-RS2                                        *15480000
      *     FORMAT RECORDS AND SEND RESULTS BACK                       *15550000
      ******************************************************************15570000
                                                                        
       2350-PROCESS-FORMAT-RS2.                                         
                                                                        
           MOVE WS-PS-ACTIVE-RETURN-CODE     TO S-R2-RETURN-CODE.       
           MOVE PS-CMPNT-ID-CD               TO S-R2-CMPNT-ID-CD.       
           MOVE PS-CODE-USE-INST-TYPE        TO S-R2-CODE-USE-INST-TYPE.
           MOVE PS-CODE-TIME-PERIOD          TO S-R2-CODE-TIME-PERIOD.  
           MOVE PS-CODE-SEASON               TO S-R2-CODE-SEASON.       
           MOVE PS-BLOCK-NO                  TO S-R2-BLOCK-NO.          
           MOVE PS-BLOCK-USE-OR-SVCS         TO S-R2-BLOCK-USE-OR-SVCS. 
           MOVE PS-BLOCK-DESC                TO S-R2-BLOCK-DESC.        
           MOVE PS-SCHED-PRICE-AM            TO S-R2-SCHED-PRICE-AM.    
           MOVE PS-PRICE-TYPE-CD             TO S-R2-PRICE-TYPE-CD.     
           MOVE PS-SCHED-WNA-RATE-AMT        TO S-R2-SCHED-WNA-RATE-AMT.
                                                                        
           PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT.           
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16120100
      * 2360-PROCESS-RT-TOU-INSTR                                      *16120200
      *     READ EACH RETURNED ROW OF CSS-RATE-PRICE-TOU, FORMAT IT AND*16120300
      *     SEND IT BACK                                               *16120400
      ******************************************************************16120500
                                                                        
       2360-PROCESS-RT-TOU-INSTR.                                       
                                                                        
           MOVE 0                            TO                         
                                             WS-RK-ACTIVE-RETURN-CODE.  
                                                                        
           PERFORM 7300-OPEN-RK-PRICE-TOU     THRU 7300-EXIT.           
                                                                        
           PERFORM 2370-PROCESS-FETCH-RS3     THRU 2370-EXIT            
              UNTIL WS-RK-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.           
                                                                        
           PERFORM 7320-CLOSE-RK-PRICE-TOU    THRU 7320-EXIT.           
                                                                        
       2360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16122300
      * 2370-PROCESS-FETCH-RS3                                         *16122400
      *     RETRIEVE ROWS FROM CSS-RATE-PRICE-TOU                      *16122500
      ******************************************************************16122600
                                                                        
       2370-PROCESS-FETCH-RS3.                                          
                                                                        
           PERFORM 7310-FETCH-PRICE-TOU       THRU 7310-EXIT            
                                                                        
           IF WS-RK-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL             
              PERFORM 2380-PROCESS-FORMAT-RS3 THRU 2380-EXIT            
           END-IF.                                                      
                                                                        
       2370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16125700
      * 2380-PROCESS-FORMAT-RS3                                        *16125800
      *     FORMAT RECORDS AND SEND RESULTS BACK                       *16125900
      ******************************************************************16126200
                                                                        
       2380-PROCESS-FORMAT-RS3.                                         
                                                                        
           MOVE WS-RK-ACTIVE-RETURN-CODE     TO S-R3-RETURN-CODE.       
           MOVE RK-CMPNT-ID-CD               TO S-R3-CMPNT-ID-CD.       
           MOVE RK-CODE-TIME-PERIOD          TO S-R3-CODE-TIME-PERIOD.  
           MOVE RK-CODE-SEASON               TO S-R3-CODE-SEASON.       
           MOVE RK-MAX-DEMAND-IND            TO S-R3-MAX-DEMAND-IND.    
           MOVE RK-RATE-MIN-IND              TO S-R3-RATE-MIN-IND.      
           MOVE RK-CNTRCT-MIN-IND            TO S-R3-CNTRCT-MIN-IND.    
           MOVE RK-MRG-OFF-PK-IND            TO S-R3-MRG-OFF-PK-IND.    
           MOVE RK-MRG-RT-MIN                TO S-R3-MRG-RT-MIN.        
           MOVE RK-MRG-CTR-MIN-IND           TO S-R3-MRG-CTR-MIN-IND.   
           MOVE RK-RATCHET-ID-1              TO S-R3-RATCHET-ID-1.      
           MOVE RK-RATCHET-ID-2              TO S-R3-RATCHET-ID-2.      
           MOVE RK-RATCHET-ID-3              TO S-R3-RATCHET-ID-3.      
           MOVE RK-CNTRCT-MIN-PCT            TO S-R3-CNTRCT-MIN-PCT.    
                                                                        
           PERFORM 8030-INSERT-GTT-R3         THRU 8030-EXIT.           
                                                                        
       2380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16134700
      * 2400-PROCESS-DMND-RTCHT                                        *16134800
      *     READ EACH RETURNED ROW OF CSS-DEMAND-RATCHET, FORMAT IT AND 16134900
      *     SEND IT BACK                                                16135000
      ******************************************************************16135400
                                                                        
       2400-PROCESS-DMND-RTCHT.                                         
                                                                        
           PERFORM 7400-OPEN-J2-DMND-RTCHT    THRU 7400-EXIT.           
                                                                        
           PERFORM 2410-PROCESS-FETCH-RS4     THRU 2410-EXIT            
              UNTIL WS-J2-ACTIVE-RETURN-CODE = NOT-FOUND                
                 OR WS-FETCH-COUNT           > WS-MAX-FETCH-COUNT.      
                                                                        
           IF CTR-ROWS-RS4                   = 0                        
              MOVE WS-NO                     TO WS-RATCHET-EXISTS       
              INITIALIZE DCLCSS-DEMAND-RATCHET                          
              PERFORM 2420-PROCESS-FORMAT-RS4 THRU 2420-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7420-CLOSE-J2-DMND-RTCHT   THRU 7420-EXIT.           
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16137800
      * 2410-PROCESS-FETCH-RS4                                         *16137900
      *     RETRIEVE ROWS FROM CSS-DEMAND-RATCHET                      *16138000
      ******************************************************************16138100
                                                                        
       2410-PROCESS-FETCH-RS4.                                          
                                                                        
           PERFORM 7410-FETCH-DEMAND-RATCHET  THRU 7410-EXIT.           
                                                                        
           IF WS-J2-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL             
              ADD  +1                        TO WS-FETCH-COUNT          
              PERFORM 2420-PROCESS-FORMAT-RS4 THRU 2420-EXIT            
           END-IF.                                                      
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16139700
      * 2420-PROCESS-FORMAT-RS4                                        *16139800
      *     FORMAT RECORDS AND SEND RESULTS BACK                       *16139900
      ******************************************************************16140000
                                                                        
       2420-PROCESS-FORMAT-RS4.                                         
                                                                        
           MOVE WS-J2-ACTIVE-RETURN-CODE     TO S-R4-RETURN-CODE.       
           MOVE J2-RATCHET-ID                TO S-R4-RATCHET-ID.        
           MOVE J2-FROM-MONTH                TO S-R4-FROM-MONTH.        
           MOVE J2-TO-MONTH                  TO S-R4-TO-MONTH.          
           COMPUTE S-R4-RATCHET-PCT         =                           
                                         J2-RATCHET-PCT * 100.          
           MOVE J2-RATCHET-YR-IND            TO S-R4-RATCHET-YR-IND.    
           MOVE WS-RATCHET-EXISTS            TO S-R4-RATCHET-EXISTS.    
                                                                        
           PERFORM 8040-INSERT-GTT-R4         THRU 8040-EXIT.           
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16141900
      * 2500-PROCESS-FCLTY-CHRG                                        *16142000
      *     RETRIEVE FACILITY CHARGE FROM SPCL_FCTR_APPL               *16142100
      ******************************************************************16142200
                                                                        
       2500-PROCESS-FCLTY-CHRG.                                         
                                                                        
           PERFORM 7020-SELECT-AMT-CUST-CHRG  THRU 7020-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              MOVE J4-AMT-CUST-CHRG          TO WS-AMT-CUST-CHRG        
           ELSE                                                         
              MOVE ZEROES                    TO WS-AMT-CUST-CHRG        
           END-IF.                                                      
                                                                        
           PERFORM 7025-SELECT-MAX-RATE-VRSN  THRU 7025-EXIT.           
                                                                        
           IF WS-MAX-VRSN-NO = RT-VERSION-NO-CNTRL                      
              PERFORM 7030A-SELECT-WINTER-BFC THRU 7030A-EXIT           
           ELSE                                                         
              PERFORM 7030B-SELECT-WINTER-BFC THRU 7030B-EXIT           
           END-IF.                                                      
                                                                        
           IF WS-RT-ACTIVE-RETURN-CODE    = NOT-FOUND                   
              MOVE WS-NO                     TO WS-BFC-SEASONAL-FL      
              MOVE ZEROES                    TO WS-WINTER-AMT-CUST-CHRG 
              MOVE ZEROES                    TO WS-WINTER-ADJ-AMT       
              PERFORM 2510-PROCESS-FORMAT-RS5 THRU 2510-EXIT            
           ELSE                                                         
              MOVE SA-FACTOR                 TO WS-WINTER-ADJ-AMT       
                                                                        
              EVALUATE SF-ADJUST-ELEMENT                                
                  WHEN WS-ADD-TO-BFC                                    
                       COMPUTE WS-WINTER-AMT-CUST-CHRG =                
                               WS-AMT-CUST-CHRG + WS-WINTER-ADJ-AMT     
                  WHEN WS-SUB-FROM-BFC                                  
                       COMPUTE WS-WINTER-AMT-CUST-CHRG =                
                               WS-AMT-CUST-CHRG - WS-WINTER-ADJ-AMT     
              END-EVALUATE                                              
                                                                        
              PERFORM 2510-PROCESS-FORMAT-RS5 THRU 2510-EXIT            
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16147100
      * 2510-PROCESS-FORMAT-RS5                                        *16147200
      *     FORMAT RECORDS AND SEND RESULTS BACK                       *16147300
      ******************************************************************16147400
                                                                        
       2510-PROCESS-FORMAT-RS5.                                         
                                                                        
           MOVE WS-RT-ACTIVE-RETURN-CODE     TO S-R5-RETURN-CODE.       
           MOVE WS-BFC-SEASONAL-FL           TO S-R5-BFC-SEASONAL-FL.   
           MOVE WS-AMT-CUST-CHRG             TO S-R5-AMT-CUST-CHRG.     
           MOVE WS-WINTER-AMT-CUST-CHRG      TO                         
                                             S-R5-WINTER-AMT-CUST-CHRG. 
           MOVE WS-WINTER-ADJ-AMT            TO S-R5-WINTER-ADJ-AMT.    
                                                                        
           PERFORM 8050-INSERT-GTT-R5         THRU 8050-EXIT.           
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16153500
      * 7010-SELECT-DEMAND-INSTR                                       *16153600
      *     SELECTS A ROW FROM THE TABLES CSS_DEMAND_INSTR             *16153700
      ******************************************************************16153800
                                                                        
       7010-SELECT-DEMAND-INSTR.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) MIN_DMD_CHRG,
              MIN_DMD_QTY,
              PWR_FCTR_MIN_PCT,
              LFTM_PEAK_PCT,
              LD_FCTR_MIN_PCT                                  
                 INTO  :DI-MIN-DMD-CHRG                                 
                      ,:DI-MIN-DMD-QTY                                  
                      ,:DI-PWR-FCTR-MIN-PCT                             
                      ,:DI-LFTM-PEAK-PCT                                
                      ,:DI-LD-FCTR-MIN-PCT                              
                 FROM  CSS_DEMAND_INSTR WITH(READUNCOMMITTED)                   
                WHERE  CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE          
                  AND  RATE_PLAN_NO       = :DI-RATE-PLAN-NO            
                  AND  VERSION_NO_CNTRL   = :DI-VERSION-NO-CNTRL        
                  AND  CMPNT_ID_CD        = :DI-CMPNT-ID-CD             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16154200
MFA-TR*        SELECT  MIN_DMD_CHRG                                     16154300
MFA-TR*               ,MIN_DMD_QTY                                      16154400
MFA-TR*               ,PWR_FCTR_MIN_PCT                                 16154500
MFA-TR*               ,LFTM_PEAK_PCT                                    16154600
MFA-TR*               ,LD_FCTR_MIN_PCT                                  16154700
MFA-TR*          INTO  :DI-MIN-DMD-CHRG                                 16154800
MFA-TR*               ,:DI-MIN-DMD-QTY                                  16154900
MFA-TR*               ,:DI-PWR-FCTR-MIN-PCT                             16155000
MFA-TR*               ,:DI-LFTM-PEAK-PCT                                16155100
MFA-TR*               ,:DI-LD-FCTR-MIN-PCT                              16155200
MFA-TR*          FROM  CSS_DEMAND_INSTR                                 16155300
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :DI-CODE-UTIL-TYPE          16155400
MFA-TR*           AND  RATE_PLAN_NO       = :DI-RATE-PLAN-NO            16155500
MFA-TR*           AND  VERSION_NO_CNTRL   = :DI-VERSION-NO-CNTRL        16155600
MFA-TR*           AND  CMPNT_ID_CD        = :DI-CMPNT-ID-CD             16155700
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            16155800
MFA-TR*         QUERYNO 7010                                            16155900
MFA-TR*    END-EXEC.                                                    16156000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DEMAND_INSTR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE DI-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE DI-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE DI-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE DI-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16158600
      * 7020-SELECT-AMT-CUST-CHRG                                      *16158700
      *     SELECTS AMT-CUST-CHRG FROM RATE-VERSN-DEF TABLE            *16158800
      ******************************************************************16158900
                                                                        
       7020-SELECT-AMT-CUST-CHRG.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) AMT_CUST_CHRG                                    
                 INTO  :J4-AMT-CUST-CHRG                                
                 FROM  CSS_RATE_VRSN_DEF WITH(READUNCOMMITTED)                  
                WHERE  CODE_UTIL_TYPE     = :J4-CODE-UTIL-TYPE          
                  AND  RATE_PLAN_NO       = :J4-RATE-PLAN-NO            
                  AND  VERSION_NO_CNTRL   = :J4-VERSION-NO-CNTRL        
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16159300
MFA-TR*        SELECT  AMT_CUST_CHRG                                    16159400
MFA-TR*          INTO  :J4-AMT-CUST-CHRG                                16159500
MFA-TR*          FROM  CSS_RATE_VRSN_DEF                                16159600
MFA-TR*         WHERE  CODE_UTIL_TYPE     = :J4-CODE-UTIL-TYPE          16159700
MFA-TR*           AND  RATE_PLAN_NO       = :J4-RATE-PLAN-NO            16159800
MFA-TR*           AND  VERSION_NO_CNTRL   = :J4-VERSION-NO-CNTRL        16159900
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                            16160000
MFA-TR*         QUERYNO 7020                                            16160100
MFA-TR*    END-EXEC.                                                    16160200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_VRSN_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J4-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J4-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J4-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16162600
      * 7025-SELECT-MAX-RATE-VRSN                                      *16162700
      *     SELECTS RATE MAX VRSN FROM RATE-VERSN-DEF TABLE            *16162800
      ******************************************************************16162900
                                                                        
       7025-SELECT-MAX-RATE-VRSN.                                       
                                                                        
           EXEC SQL                                                     
               SELECT  MAX(VERSION_NO_CNTRL)                            
                 INTO  :WS-MAX-VRSN-NO                                  
                 FROM  CSS_RATE_CREATOR   RT                            
                WHERE  RT.CODE_UTIL_TYPE    = :RT-CODE-UTIL-TYPE        
                  AND  RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     16163300
MFA-TR*        SELECT  MAX(VERSION_NO_CNTRL)                            16163400
MFA-TR*          INTO  :WS-MAX-VRSN-NO                                  16163500
MFA-TR*          FROM  CSS_RATE_CREATOR   RT                            16163600
MFA-TR*         WHERE  RT.CODE_UTIL_TYPE    = :RT-CODE-UTIL-TYPE        16163700
MFA-TR*           AND  RT.RATE_PLAN_NO      = :RT-RATE-PLAN-NO          16163800
MFA-TR*         QUERYNO 7025                                            16163900
MFA-TR*    END-EXEC.                                                    16164000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7025'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE RT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RT-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
                                                                        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16166300
      * 7030A-SELECT-WINTER-BFC                                        *16166400
      *     SELECTS FACILITY CHARGE FOR MAX RATE VERSION FROM SPCL_FCTR*16166500
      *     & SPCL_FCTR_APPL TABLES                                    *16166600
      *     A. SHOULD SELECT ACTIVE FACTORS AS OF RATE VRSN EFFT DATE  *16166700
      *        & AS OF CURRENT DATE                                    *16166800
      ******************************************************************16166900
                                                                        
       7030A-SELECT-WINTER-BFC.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              SA.FACTOR,
              SF.ADJUST_ELEMENT,
              SA.FACTOR_ID                                     
                 INTO  :WS-BFC-SEASONAL-FL                              
                      ,:SA-FACTOR                                       
                      ,:SF-ADJUST-ELEMENT                               
                      ,:SA-FACTOR-ID                                    
                 FROM  CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)              
                      ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
                      ,CSS_RATE_CREATOR   RT WITH(READUNCOMMITTED)              
                WHERE  RT.CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE       
                  AND  RT.RATE_PLAN_NO       = :RT-RATE-PLAN-NO         
                  AND  RT.VERSION_NO_CNTRL   = :RT-VERSION-NO-CNTRL     
                  AND  SA.CODE_UTIL_TYPE     = RT.CODE_UTIL_TYPE        
                  AND  SA.RATE_PLAN_NO       = RT.RATE_PLAN_NO          
                  AND  SA.FACTOR_ID          = SF.FACTOR_ID             
                  AND  SF.SPCL_GROUP_CD      = 'BC'                     
                  AND  SF.ADJUST_ELEMENT    IN ('L','O')                
                  AND  SA.CODE_STATUS       IN ('A','T')                
                  AND  SA.DATE_TO           >= RT.FROM_EFFECTIVE_DT     
                  AND  SA.DATE_TO           >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)             
               ORDER BY SA.DATE_TO   ASC                                
                       ,SA.DATE_FROM ASC                                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16167300
MFA-TR*        SELECT  'Y'                                              16167400
MFA-TR*               ,SA.FACTOR                                        16167500
MFA-TR*               ,SF.ADJUST_ELEMENT                                16167600
MFA-TR*               ,SA.FACTOR_ID                                     16167700
MFA-TR*          INTO  :WS-BFC-SEASONAL-FL                              16167800
MFA-TR*               ,:SA-FACTOR                                       16167900
MFA-TR*               ,:SF-ADJUST-ELEMENT                               16168000
MFA-TR*               ,:SA-FACTOR-ID                                    16168100
MFA-TR*          FROM  CSS_SPCL_FCTR_APPL SA                            16168200
MFA-TR*               ,CSS_SPCL_FCTR      SF                            16168300
MFA-TR*               ,CSS_RATE_CREATOR   RT                            16168400
MFA-TR*         WHERE  RT.CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE       16168500
MFA-TR*           AND  RT.RATE_PLAN_NO       = :RT-RATE-PLAN-NO         16168600
MFA-TR*           AND  RT.VERSION_NO_CNTRL   = :RT-VERSION-NO-CNTRL     16168700
MFA-TR*           AND  SA.CODE_UTIL_TYPE     = RT.CODE_UTIL_TYPE        16168800
MFA-TR*           AND  SA.RATE_PLAN_NO       = RT.RATE_PLAN_NO          16168900
MFA-TR*           AND  SA.FACTOR_ID          = SF.FACTOR_ID             16169000
MFA-TR*           AND  SF.SPCL_GROUP_CD      = 'BC'                     16169100
MFA-TR*           AND  SF.ADJUST_ELEMENT    IN ('L','O')                16169200
MFA-TR*           AND  SA.CODE_STATUS       IN ('A','T')                16169300
MFA-TR*           AND  SA.DATE_TO           >= RT.FROM_EFFECTIVE_DT     16169400
MFA-TR*           AND  SA.DATE_TO           >= CURRENT DATE             16169500
MFA-TR*        ORDER BY SA.DATE_TO   ASC                                16169800
MFA-TR*                ,SA.DATE_FROM ASC                                16169900
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             16170000
MFA-TR*        QUERYNO 7030                                             16170100
MFA-TR*    END-EXEC.                                                    16170200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-RT-ACTIVE-RETURN-CODE
                                                WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-RT-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE RT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RT-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RT-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7030A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************16172700
      * 7030B-SELECT-WINTER-BFC                                        *16172800
      *     SELECTS FACILITY CHARGE FOR RATE VRSN (OTHER THAN MAX VRSN)*16172900
      *     FROM SPCL_FCTR & SPCL_FCTR_APPL TABLES                     *16173000
      *     A. SHOULD SELECT ACTIVE FACTORS AS OF RATE VRSN EFFT DATE  *16173100
      ******************************************************************16173300
                                                                        
       7030B-SELECT-WINTER-BFC.                                         
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              SA.FACTOR,
              SF.ADJUST_ELEMENT,
              SA.FACTOR_ID                                     
                 INTO  :WS-BFC-SEASONAL-FL                              
                      ,:SA-FACTOR                                       
                      ,:SF-ADJUST-ELEMENT                               
                      ,:SA-FACTOR-ID                                    
                 FROM  CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)              
                      ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)              
                      ,CSS_RATE_CREATOR   RT WITH(READUNCOMMITTED)              
                WHERE  RT.CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE       
                  AND  RT.RATE_PLAN_NO       = :RT-RATE-PLAN-NO         
                  AND  RT.VERSION_NO_CNTRL   = :RT-VERSION-NO-CNTRL     
                  AND  SA.CODE_UTIL_TYPE     = RT.CODE_UTIL_TYPE        
                  AND  SA.RATE_PLAN_NO       = RT.RATE_PLAN_NO          
                  AND  SA.FACTOR_ID          = SF.FACTOR_ID             
                  AND  SF.SPCL_GROUP_CD      = 'BC'                     
                  AND  SF.ADJUST_ELEMENT    IN ('L','O')                
                  AND  SA.CODE_STATUS       IN ('A','T')                
                  AND  SA.DATE_FROM         <= RT.FROM_EFFECTIVE_DT     
                  AND  SA.DATE_TO           >= RT.FROM_EFFECTIVE_DT     
               ORDER BY SA.DATE_FROM DESC                               
                       ,SA.DATE_TO   DESC                               
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16173700
MFA-TR*        SELECT  'Y'                                              16173800
MFA-TR*               ,SA.FACTOR                                        16173900
MFA-TR*               ,SF.ADJUST_ELEMENT                                16174000
MFA-TR*               ,SA.FACTOR_ID                                     16174100
MFA-TR*          INTO  :WS-BFC-SEASONAL-FL                              16174200
MFA-TR*               ,:SA-FACTOR                                       16174300
MFA-TR*               ,:SF-ADJUST-ELEMENT                               16174400
MFA-TR*               ,:SA-FACTOR-ID                                    16174500
MFA-TR*          FROM  CSS_SPCL_FCTR_APPL SA                            16174600
MFA-TR*               ,CSS_SPCL_FCTR      SF                            16174700
MFA-TR*               ,CSS_RATE_CREATOR   RT                            16174800
MFA-TR*         WHERE  RT.CODE_UTIL_TYPE     = :RT-CODE-UTIL-TYPE       16174900
MFA-TR*           AND  RT.RATE_PLAN_NO       = :RT-RATE-PLAN-NO         16175000
MFA-TR*           AND  RT.VERSION_NO_CNTRL   = :RT-VERSION-NO-CNTRL     16175100
MFA-TR*           AND  SA.CODE_UTIL_TYPE     = RT.CODE_UTIL_TYPE        16175200
MFA-TR*           AND  SA.RATE_PLAN_NO       = RT.RATE_PLAN_NO          16175300
MFA-TR*           AND  SA.FACTOR_ID          = SF.FACTOR_ID             16175400
MFA-TR*           AND  SF.SPCL_GROUP_CD      = 'BC'                     16175500
MFA-TR*           AND  SF.ADJUST_ELEMENT    IN ('L','O')                16175600
MFA-TR*           AND  SA.CODE_STATUS       IN ('A','T')                16175700
MFA-TR*           AND  SA.DATE_FROM         <= RT.FROM_EFFECTIVE_DT     16175800
MFA-TR*           AND  SA.DATE_TO           >= RT.FROM_EFFECTIVE_DT     16175900
MFA-TR*        ORDER BY SA.DATE_FROM DESC                               16176000
MFA-TR*                ,SA.DATE_TO   DESC                               16176100
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                             16176200
MFA-TR*        QUERYNO 7030                                             16176300
MFA-TR*    END-EXEC.                                                    16176400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-RT-ACTIVE-RETURN-CODE
                                                WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-RT-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7030B'                   TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE RT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RT-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RT-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7030B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************16178900
      * 7100-OPEN-J1-RT-COMP-DEF                                       *16179000
      *     OPENS THE CURSOR                                           *16179100
      ******************************************************************16179200
                                                                        
       7100-OPEN-J1-RT-COMP-DEF.                                        
                                                                        
           EXEC SQL                                                     
              OPEN J1-RT-COMP-DEF                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J1-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J1-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J1-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16183000
      * 7110-FETCH-RATE-COMP-DEF                                       *16190000
      *     FETCHES A ROW FROM THE TABLE CSS_RATE_COMP_DEF             *16200000
      ******************************************************************16220000
                                                                        
       7110-FETCH-RATE-COMP-DEF.                                        
                                                                        
           EXEC SQL                                                     
              FETCH  J1-RT-COMP-DEF                                     
              INTO  :J1-CMPNT-ID-CD                                     
                   ,:J1-REG-TYPE-CD                                     
                   ,:J1-ENERGY-UNIT-CD                                  
                   ,:J1-ENERGY-SEAS-CD                                  
                   ,:J1-LAST-ENERGY-BLOCK                               
                   ,:J1-DEM-REG-TYPE-CD                                 
                   ,:J1-DEM-UNIT-CD                                     
                   ,:J1-DEM-SEASON-CD                                   
                   ,:J1-LAST-DEM-BLOCK                                  
                   ,:J1-ON-PEAK-DAYS                                    
                   ,:J1-CALENDAR-CD                                     
                   ,:J1-BAL-FWD-CD                                      
                   ,:J1-BAL-RESET-MMDD                                  
                   ,:J1-BAL-RESET-PRO-CD                                
                   ,:J1-BAL-OFFSET-TOU-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-J1-ACTIVE-RETURN-CODE
                                                WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-J1-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J1-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J1-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J1-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16660000
      * 7120-CLOSE-J1-RT-COMP-DEF                                      *16670000
      *     CLOSES THE CURSOR                                          *16680000
      ******************************************************************16690000
                                                                        
       7120-CLOSE-J1-RT-COMP-DEF.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE  J1-RT-COMP-DEF                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_COMP_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J1-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J1-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J1-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16990100
      * 7200-OPEN-PS-PRICE-SCHED                                       *16990200
      *     OPENS THE CURSOR                                           *16990300
      ******************************************************************16990400
                                                                        
       7200-OPEN-PS-PRICE-SCHED.                                        
                                                                        
           EXEC SQL                                                     
                OPEN PS-PRICE-SCHED                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PRICE-SCHED'         TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE PS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE PS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE PS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE PS-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17001000
      * 7210-FETCH-PRICE-SCHED                                         *17001100
      *     FETCHES A ROW FROM THE TABLE CSS_PRICE-SCHED               *17001200
      ******************************************************************17001400
                                                                        
       7210-FETCH-PRICE-SCHED.                                          
                                                                        
           EXEC SQL                                                     
                FETCH PS-PRICE-SCHED                                    
           INTO :PS-CMPNT-ID-CD                                         
               ,:PS-CODE-USE-INST-TYPE                                  
               ,:PS-CODE-TIME-PERIOD                                    
               ,:PS-CODE-SEASON                                         
               ,:PS-BLOCK-NO                                            
               ,:PS-BLOCK-USE-OR-SVCS                                   
               ,:PS-BLOCK-DESC                                          
               ,:PS-SCHED-PRICE-AM                                      
               ,:PS-PRICE-TYPE-CD                                       
               ,:PS-SCHED-WNA-RATE-AMT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-PS-ACTIVE-RETURN-CODE
                                                WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-PS-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL OR NOT-FOUND
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7210'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE PS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE PS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE PS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE PS-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17006100
      * 7220-CLOSE-PS-PRICE-SCHED                                      *17006200
      *     CLOSES THE CURSOR                                          *17006300
      ******************************************************************17006400
                                                                        
       7220-CLOSE-PS-PRICE-SCHED.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE PS-PRICE-SCHED                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PRICE_SCHED'         TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE PS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE PS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE PS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE PS-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17009700
      * 7300-OPEN-RK-PRICE-TOU                                         *17009800
      *     OPENS THE CURSOR                                           *17009900
      ******************************************************************17010000
                                                                        
       7300-OPEN-RK-PRICE-TOU.                                          
                                                                        
           EXEC SQL                                                     
                OPEN RK-PRICE-TOU                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_RATE_TOU_INSTR'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE RK-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RK-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RK-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RK-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17261000
      * 7310-FETCH-PRICE-TOU                                           *17262000
      *     FETCHES A ROW FROM THE TABLE CSS_RATE_PRICE-TOU            *17263000
      ******************************************************************17265000
                                                                        
       7310-FETCH-PRICE-TOU.                                            
                                                                        
           EXEC SQL                                                     
                FETCH RK-PRICE-TOU                                      
           INTO :RK-CMPNT-ID-CD                                         
               ,:RK-CODE-TIME-PERIOD                                    
               ,:RK-CODE-SEASON                                         
               ,:RK-MAX-DEMAND-IND                                      
               ,:RK-RATE-MIN-IND                                        
               ,:RK-CNTRCT-MIN-IND                                      
               ,:RK-MRG-OFF-PK-IND                                      
               ,:RK-MRG-RT-MIN                                          
               ,:RK-MRG-CTR-MIN-IND                                     
               ,:RK-RATCHET-ID-1                                        
               ,:RK-RATCHET-ID-2                                        
               ,:RK-RATCHET-ID-3                                        
               ,:RK-CNTRCT-MIN-PCT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-RK-ACTIVE-RETURN-CODE
                                                WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-RK-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_RATE_TOU_INSTR'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE RK-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RK-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RK-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RK-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17791000
      * 7320-CLOSE-RK-PRICE-TOU                                        *17792000
      *     CLOSES THE CURSOR                                          *17793000
      ******************************************************************17794000
                                                                        
       7320-CLOSE-RK-PRICE-TOU.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE RK-PRICE-TOU                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7320'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_RATE_TOU_INSTR'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CMPNT_ID_CD'             TO TABLE-ELEMENT-4         
              MOVE RK-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RK-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RK-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RK-CMPNT-ID-CD            TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT
           END-IF.           
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************18061000
      * 7400-OPEN-J2-DMND-RTCHT                                        *18062000
      *     OPENS THE CURSOR                                           *18063000
      ******************************************************************18064000
                                                                        
       7400-OPEN-J2-DMND-RTCHT.                                         
                                                                        
           EXEC SQL                                                     
              OPEN J2-DMND-RTCHT                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_DEMAND_RATCHET'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J2-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************18072000
      * 7410-FETCH-DEMAND-RATCHET                                      *18080000
      *     FETCHES A ROW FROM THE TABLE CSS_DEMAND_RATCHET            *18140000
      ******************************************************************18160000
                                                                        
       7410-FETCH-DEMAND-RATCHET.                                       
                                                                        
           EXEC SQL                                                     
              FETCH  J2-DMND-RTCHT                                      
              INTO  :J2-RATCHET-ID                                      
                   ,:J2-FROM-MONTH                                      
                   ,:J2-TO-MONTH                                        
                   ,:J2-RATCHET-PCT                                     
                   ,:J2-RATCHET-YR-IND                                  
                   ,:WS-RATCHET-EXISTS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-J2-ACTIVE-RETURN-CODE
                                                WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-J2-ACTIVE-RETURN-CODE    = SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7410'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_DEMAND_RATCHET'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J2-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************18960000
      * 7420-CLOSE-J2-DMND-RTCHT                                       *18970000
      *     CLOSES THE CURSOR                                          *19030000
      ******************************************************************19040000
                                                                        
       7420-CLOSE-J2-DMND-RTCHT.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE  J2-DMND-RTCHT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7420'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_DEMAND_RATCHET'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE J2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J2-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************20150100
      * 8000A-DELETE-GTT-ROWS.                                         *20150200
      ******************************************************************20150300
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04456_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     20151000
MFA-TR*        DELETE FROM SESSION.CSR04456_R1                          20151100
MFA-TR*    END-EXEC.                                                    20151200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE   
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '8000A'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DELETE'             TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04456_R1'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************20161800
      * 8000B-DELETE-GTT-ROWS.                                         *20161900
      ******************************************************************20162000
       8000B-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04456_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     20162300
MFA-TR*        DELETE FROM SESSION.CSR04456_R2                          20162400
MFA-TR*    END-EXEC.                                                    20162500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE   
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '8000B'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DELETE'             TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04456_R2'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************20165300
      * 8000C-DELETE-GTT-ROWS.                                         *20165400
      ******************************************************************20165500
       8000C-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04456_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     20165800
MFA-TR*        DELETE FROM SESSION.CSR04456_R3                          20165900
MFA-TR*    END-EXEC.                                                    20166000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE   
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '8000C'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DELETE'             TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04456_R3'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************20168800
      * 8000D-DELETE-GTT-ROWS.                                         *20168900
      ******************************************************************20169000
       8000D-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04456_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     20169300
MFA-TR*        DELETE FROM SESSION.CSR04456_R4                          20169400
MFA-TR*    END-EXEC.                                                    20169500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE   
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '8000D'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DELETE'             TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04456_R4'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************20172300
      * 8000E-DELETE-GTT-ROWS.                                         *20172400
      ******************************************************************20172500
       8000E-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04456_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     20172800
MFA-TR*        DELETE FROM SESSION.CSR04456_R5                          20172900
MFA-TR*    END-EXEC.                                                    20173000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                   CONTINUE                                             
              WHEN NOT-FOUND                                            
                   MOVE ZEROES               TO WS-ACTIVE-RETURN-CODE   
              WHEN OTHER                                                
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE SQLCODE              TO ABEND-SQLCODE           
                   MOVE SQLSTATE             TO ABEND-SQLSTATE          
                   MOVE '8000E'              TO ACTIVE-PARAGRAPH        
                   MOVE 'DELETE'             TO ABEND-FUNCTION          
                   MOVE SPACES               TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                   MOVE 'CSR04456_R5'        TO TABLE-1                 
                   MOVE SPACES               TO TABLE-ELEMENT-1         
                   MOVE SPACES               TO HOSTVAR-ELEMENT-1       
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       8000E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************20280100
      * 8010-INSERT-GTT-R1.                                            *20280300
      ******************************************************************20280400
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04456_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,CMPNT_ID_CD                                               
             ,REG_TYPE_CD                                               
             ,ENERGY_UNIT_CD                                            
             ,ENERGY_SEAS_CD                                            
             ,LAST_ENERGY_BLOCK                                         
             ,DEM_REG_TYPE_CD                                           
             ,DEM_UNIT_CD                                               
             ,DEM_SEASON_CD                                             
             ,LAST_DEM_BLOCK                                            
             ,AMT_MIN_CHRG                                              
             ,QTY_MIN_USAGE                                             
             ,MIN_DMD_CHRG                                              
             ,MIN_DMD_QTY                                               
             ,PWR_FCTR_MIN_PCT                                          
             ,LFTM_PEAK_PCT                                             
             ,LD_FCTR_MIN_PCT                                           
             ,ON_PEAK_DAYS                                              
             ,CALENDAR_CD                                               
             ,BAL_FWD_CD                                                
             ,BAL_RESET_MMDD                                            
             ,BAL_RESET_PRO_CD                                          
             ,BAL_OFFSET_TOU_CD                                         
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R1-RETURN-CODE                                         
             ,:S-R1-APPL-RETURN-CODE                                    
             ,:S-R1-CMPNT-ID-CD                                         
             ,:S-R1-REG-TYPE-CD                                         
             ,:S-R1-ENERGY-UNIT-CD                                      
             ,:S-R1-ENERGY-SEAS-CD                                      
             ,:S-R1-LAST-ENERGY-BLOCK                                   
             ,:S-R1-DEM-REG-TYPE-CD                                     
             ,:S-R1-DEM-UNIT-CD                                         
             ,:S-R1-DEM-SEASON-CD                                       
             ,:S-R1-LAST-DEM-BLOCK                                      
             ,:S-R1-AMT-MIN-CHRG                                        
             ,:S-R1-QTY-MIN-USAGE                                       
             ,:S-R1-MIN-DMD-CHRG                                        
             ,:S-R1-MIN-DMD-QTY                                         
             ,:S-R1-PWR-FCTR-MIN-PCT                                    
             ,:S-R1-LFTM-PEAK-PCT                                       
             ,:S-R1-LD-FCTR-MIN-PCT                                     
             ,:S-R1-ON-PEAK-DAYS                                        
             ,:S-R1-CALENDAR-CD                                         
             ,:S-R1-BAL-FWD-CD                                          
             ,:S-R1-BAL-RESET-MMDD                                      
             ,:S-R1-BAL-RESET-PRO-CD                                    
             ,:S-R1-BAL-OFFSET-TOU-CD                                   
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     20290000
MFA-TR*      INSERT INTO SESSION.CSR04456_R1                            20300000
MFA-TR*      (                                                          20310000
MFA-TR*       RETURN_CODE                                               20320000
MFA-TR*      ,APPL_RETURN_CODE                                          20321000
MFA-TR*      ,CMPNT_ID_CD                                               20330000
MFA-TR*      ,REG_TYPE_CD                                               20340000
MFA-TR*      ,ENERGY_UNIT_CD                                            20350000
MFA-TR*      ,ENERGY_SEAS_CD                                            20360000
MFA-TR*      ,LAST_ENERGY_BLOCK                                         20370000
MFA-TR*      ,DEM_REG_TYPE_CD                                           20380000
MFA-TR*      ,DEM_UNIT_CD                                               20390000
MFA-TR*      ,DEM_SEASON_CD                                             20400000
MFA-TR*      ,LAST_DEM_BLOCK                                            20410000
MFA-TR*      ,AMT_MIN_CHRG                                              20420000
MFA-TR*      ,QTY_MIN_USAGE                                             20430000
MFA-TR*      ,MIN_DMD_CHRG                                              20440000
MFA-TR*      ,MIN_DMD_QTY                                               20450000
MFA-TR*      ,PWR_FCTR_MIN_PCT                                          20460000
MFA-TR*      ,LFTM_PEAK_PCT                                             20470000
MFA-TR*      ,LD_FCTR_MIN_PCT                                           20480000
MFA-TR*      ,ON_PEAK_DAYS                                              20500000
MFA-TR*      ,CALENDAR_CD                                               20510000
MFA-TR*      ,BAL_FWD_CD                                                20521000
MFA-TR*      ,BAL_RESET_MMDD                                            20522000
MFA-TR*      ,BAL_RESET_PRO_CD                                          20523000
MFA-TR*      ,BAL_OFFSET_TOU_CD                                         20524000
MFA-TR*      )                                                          20530000
MFA-TR*      VALUES                                                     20540000
MFA-TR*      (                                                          20550000
MFA-TR*       :S-R1-RETURN-CODE                                         20560000
MFA-TR*      ,:S-R1-APPL-RETURN-CODE                                    20570000
MFA-TR*      ,:S-R1-CMPNT-ID-CD                                         20571000
MFA-TR*      ,:S-R1-REG-TYPE-CD                                         20580000
MFA-TR*      ,:S-R1-ENERGY-UNIT-CD                                      20590000
MFA-TR*      ,:S-R1-ENERGY-SEAS-CD                                      20600000
MFA-TR*      ,:S-R1-LAST-ENERGY-BLOCK                                   20610000
MFA-TR*      ,:S-R1-DEM-REG-TYPE-CD                                     20620000
MFA-TR*      ,:S-R1-DEM-UNIT-CD                                         20630000
MFA-TR*      ,:S-R1-DEM-SEASON-CD                                       20640000
MFA-TR*      ,:S-R1-LAST-DEM-BLOCK                                      20650000
MFA-TR*      ,:S-R1-AMT-MIN-CHRG                                        20660000
MFA-TR*      ,:S-R1-QTY-MIN-USAGE                                       20670000
MFA-TR*      ,:S-R1-MIN-DMD-CHRG                                        20680000
MFA-TR*      ,:S-R1-MIN-DMD-QTY                                         20690000
MFA-TR*      ,:S-R1-PWR-FCTR-MIN-PCT                                    20700000
MFA-TR*      ,:S-R1-LFTM-PEAK-PCT                                       20710000
MFA-TR*      ,:S-R1-LD-FCTR-MIN-PCT                                     20720000
MFA-TR*      ,:S-R1-ON-PEAK-DAYS                                        20740000
MFA-TR*      ,:S-R1-CALENDAR-CD                                         20750000
MFA-TR*      ,:S-R1-BAL-FWD-CD                                          20761000
MFA-TR*      ,:S-R1-BAL-RESET-MMDD                                      20762000
MFA-TR*      ,:S-R1-BAL-RESET-PRO-CD                                    20763000
MFA-TR*      ,:S-R1-BAL-OFFSET-TOU-CD                                   20764000
MFA-TR*      )                                                          20770000
MFA-TR*    END-EXEC.                                                    20780000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                         TO  CTR-ROWS-RS1           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04456_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************20980000
      * 8020-INSERT-GTT-R2.                                            *20990000
      ******************************************************************21000000
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04456_R2                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,CMPNT_ID_CD                                               
             ,CODE_USE_INST_TYPE                                        
             ,CODE_TIME_PERIOD                                          
             ,CODE_SEASON                                               
             ,BLOCK_NO                                                  
             ,BLOCK_USE_OR_SVCS                                         
             ,BLOCK_DESC                                                
             ,SCHED_PRICE_AM                                            
             ,PRICE_TYPE_CD                                             
             ,SCHED_WNA_RATE_AMT                                        
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R2-RETURN-CODE                                         
             ,:S-R2-APPL-RETURN-CODE                                    
             ,:S-R2-CMPNT-ID-CD                                         
             ,:S-R2-CODE-USE-INST-TYPE                                  
             ,:S-R2-CODE-TIME-PERIOD                                    
             ,:S-R2-CODE-SEASON                                         
             ,:S-R2-BLOCK-NO                                            
             ,:S-R2-BLOCK-USE-OR-SVCS                                   
             ,:S-R2-BLOCK-DESC                                          
             ,:S-R2-SCHED-PRICE-AM                                      
             ,:S-R2-PRICE-TYPE-CD                                       
             ,:S-R2-SCHED-WNA-RATE-AMT                                  
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     21020000
MFA-TR*      INSERT INTO SESSION.CSR04456_R2                            21030000
MFA-TR*      (                                                          21040000
MFA-TR*       RETURN_CODE                                               21050000
MFA-TR*      ,APPL_RETURN_CODE                                          21060000
MFA-TR*      ,CMPNT_ID_CD                                               21070000
MFA-TR*      ,CODE_USE_INST_TYPE                                        21080000
MFA-TR*      ,CODE_TIME_PERIOD                                          21090000
MFA-TR*      ,CODE_SEASON                                               21100000
MFA-TR*      ,BLOCK_NO                                                  21110000
MFA-TR*      ,BLOCK_USE_OR_SVCS                                         21120000
MFA-TR*      ,BLOCK_DESC                                                21130000
MFA-TR*      ,SCHED_PRICE_AM                                            21140000
MFA-TR*      ,PRICE_TYPE_CD                                             21150000
MFA-TR*      ,SCHED_WNA_RATE_AMT                                        21160000
MFA-TR*      )                                                          21290000
MFA-TR*      VALUES                                                     21300000
MFA-TR*      (                                                          21301000
MFA-TR*       :S-R2-RETURN-CODE                                         21302000
MFA-TR*      ,:S-R2-APPL-RETURN-CODE                                    21303000
MFA-TR*      ,:S-R2-CMPNT-ID-CD                                         21304000
MFA-TR*      ,:S-R2-CODE-USE-INST-TYPE                                  21305000
MFA-TR*      ,:S-R2-CODE-TIME-PERIOD                                    21306000
MFA-TR*      ,:S-R2-CODE-SEASON                                         21307000
MFA-TR*      ,:S-R2-BLOCK-NO                                            21308000
MFA-TR*      ,:S-R2-BLOCK-USE-OR-SVCS                                   21309000
MFA-TR*      ,:S-R2-BLOCK-DESC                                          21309100
MFA-TR*      ,:S-R2-SCHED-PRICE-AM                                      21309200
MFA-TR*      ,:S-R2-PRICE-TYPE-CD                                       21309300
MFA-TR*      ,:S-R2-SCHED-WNA-RATE-AMT                                  21309400
MFA-TR*      )                                                          21310700
MFA-TR*    END-EXEC.                                                    21310800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                         TO  CTR-ROWS-RS2           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04456_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21312800
      * 8030-INSERT-GTT-R3.                                            *21312900
      ******************************************************************21313000
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04456_R3                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,CMPNT_ID_CD                                               
             ,CODE_TIME_PERIOD                                          
             ,CODE_SEASON                                               
             ,MAX_DEMAND_IND                                            
             ,RATE_MIN_IND                                              
             ,CNTRCT_MIN_IND                                            
             ,MRG_OFF_PK_IND                                            
             ,MRG_RT_MIN                                                
             ,MRG_CTR_MIN_IND                                           
             ,RATCHET_ID_1                                              
             ,RATCHET_ID_2                                              
             ,RATCHET_ID_3                                              
             ,CNTRCT_MIN_PCT                                            
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R3-RETURN-CODE                                         
             ,:S-R3-APPL-RETURN-CODE                                    
             ,:S-R3-CMPNT-ID-CD                                         
             ,:S-R3-CODE-TIME-PERIOD                                    
             ,:S-R3-CODE-SEASON                                         
             ,:S-R3-MAX-DEMAND-IND                                      
             ,:S-R3-RATE-MIN-IND                                        
             ,:S-R3-CNTRCT-MIN-IND                                      
             ,:S-R3-MRG-OFF-PK-IND                                      
             ,:S-R3-MRG-RT-MIN                                          
             ,:S-R3-MRG-CTR-MIN-IND                                     
             ,:S-R3-RATCHET-ID-1                                        
             ,:S-R3-RATCHET-ID-2                                        
             ,:S-R3-RATCHET-ID-3                                        
             ,:S-R3-CNTRCT-MIN-PCT                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     21313300
MFA-TR*      INSERT INTO SESSION.CSR04456_R3                            21313400
MFA-TR*      (                                                          21313500
MFA-TR*       RETURN_CODE                                               21313600
MFA-TR*      ,APPL_RETURN_CODE                                          21313700
MFA-TR*      ,CMPNT_ID_CD                                               21313800
MFA-TR*      ,CODE_TIME_PERIOD                                          21313900
MFA-TR*      ,CODE_SEASON                                               21314000
MFA-TR*      ,MAX_DEMAND_IND                                            21314100
MFA-TR*      ,RATE_MIN_IND                                              21314200
MFA-TR*      ,CNTRCT_MIN_IND                                            21314300
MFA-TR*      ,MRG_OFF_PK_IND                                            21314400
MFA-TR*      ,MRG_RT_MIN                                                21314500
MFA-TR*      ,MRG_CTR_MIN_IND                                           21314600
MFA-TR*      ,RATCHET_ID_1                                              21314700
MFA-TR*      ,RATCHET_ID_2                                              21314800
MFA-TR*      ,RATCHET_ID_3                                              21314900
MFA-TR*      ,CNTRCT_MIN_PCT                                            21315000
MFA-TR*      )                                                          21315200
MFA-TR*      VALUES                                                     21315300
MFA-TR*      (                                                          21315400
MFA-TR*       :S-R3-RETURN-CODE                                         21315500
MFA-TR*      ,:S-R3-APPL-RETURN-CODE                                    21315600
MFA-TR*      ,:S-R3-CMPNT-ID-CD                                         21315700
MFA-TR*      ,:S-R3-CODE-TIME-PERIOD                                    21315800
MFA-TR*      ,:S-R3-CODE-SEASON                                         21315900
MFA-TR*      ,:S-R3-MAX-DEMAND-IND                                      21316000
MFA-TR*      ,:S-R3-RATE-MIN-IND                                        21316100
MFA-TR*      ,:S-R3-CNTRCT-MIN-IND                                      21316200
MFA-TR*      ,:S-R3-MRG-OFF-PK-IND                                      21316300
MFA-TR*      ,:S-R3-MRG-RT-MIN                                          21316400
MFA-TR*      ,:S-R3-MRG-CTR-MIN-IND                                     21316500
MFA-TR*      ,:S-R3-RATCHET-ID-1                                        21316600
MFA-TR*      ,:S-R3-RATCHET-ID-2                                        21316700
MFA-TR*      ,:S-R3-RATCHET-ID-3                                        21316800
MFA-TR*      ,:S-R3-CNTRCT-MIN-PCT                                      21316900
MFA-TR*      )                                                          21317100
MFA-TR*    END-EXEC.                                                    21317200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                         TO  CTR-ROWS-RS3           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04456_R3'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21319100
      * 8040-INSERT-GTT-R4.                                            *21319200
      ******************************************************************21319300
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04456_R4                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,RATCHET_ID                                                
             ,FROM_MONTH                                                
             ,TO_MONTH                                                  
             ,RATCHET_PCT                                               
             ,RATCHET_YR_IND                                            
             ,RATCHET_EXISTS                                            
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R4-RETURN-CODE                                         
             ,:S-R4-APPL-RETURN-CODE                                    
             ,:S-R4-RATCHET-ID                                          
             ,:S-R4-FROM-MONTH                                          
             ,:S-R4-TO-MONTH                                            
             ,:S-R4-RATCHET-PCT                                         
             ,:S-R4-RATCHET-YR-IND                                      
             ,:S-R4-RATCHET-EXISTS                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     21319600
MFA-TR*      INSERT INTO SESSION.CSR04456_R4                            21319700
MFA-TR*      (                                                          21319800
MFA-TR*       RETURN_CODE                                               21319900
MFA-TR*      ,APPL_RETURN_CODE                                          21320000
MFA-TR*      ,RATCHET_ID                                                21320100
MFA-TR*      ,FROM_MONTH                                                21320200
MFA-TR*      ,TO_MONTH                                                  21320300
MFA-TR*      ,RATCHET_PCT                                               21320400
MFA-TR*      ,RATCHET_YR_IND                                            21320500
MFA-TR*      ,RATCHET_EXISTS                                            21320600
MFA-TR*      )                                                          21321300
MFA-TR*      VALUES                                                     21321400
MFA-TR*      (                                                          21321500
MFA-TR*       :S-R4-RETURN-CODE                                         21321600
MFA-TR*      ,:S-R4-APPL-RETURN-CODE                                    21321700
MFA-TR*      ,:S-R4-RATCHET-ID                                          21321800
MFA-TR*      ,:S-R4-FROM-MONTH                                          21321900
MFA-TR*      ,:S-R4-TO-MONTH                                            21322000
MFA-TR*      ,:S-R4-RATCHET-PCT                                         21322100
MFA-TR*      ,:S-R4-RATCHET-YR-IND                                      21322200
MFA-TR*      ,:S-R4-RATCHET-EXISTS                                      21322300
MFA-TR*      )                                                          21323100
MFA-TR*    END-EXEC.                                                    21323200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                         TO  CTR-ROWS-RS4           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8040'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04456_R4'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21325100
      * 8050-INSERT-GTT-R5.                                            *21325200
      ******************************************************************21325300
       8050-INSERT-GTT-R5.                                              
                                                                        
           EXEC SQL                                                     
             INSERT INTO #CSR04456_R5                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,BFC_SEASONAL_FL                                           
             ,AMT_CUST_CHRG                                             
             ,WINTER_AMT_CUST_CHRG                                      
             ,WINTER_ADJ_AMT                                            
             )                                                          
             VALUES                                                     
             (                                                          
              :S-R5-RETURN-CODE                                         
             ,:S-R5-APPL-RETURN-CODE                                    
             ,:S-R5-BFC-SEASONAL-FL                                     
             ,:S-R5-AMT-CUST-CHRG                                       
             ,:S-R5-WINTER-AMT-CUST-CHRG                                
             ,:S-R5-WINTER-ADJ-AMT                                      
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     21325600
MFA-TR*      INSERT INTO SESSION.CSR04456_R5                            21325700
MFA-TR*      (                                                          21325800
MFA-TR*       RETURN_CODE                                               21325900
MFA-TR*      ,APPL_RETURN_CODE                                          21326000
MFA-TR*      ,BFC_SEASONAL_FL                                           21326100
MFA-TR*      ,AMT_CUST_CHRG                                             21326200
MFA-TR*      ,WINTER_AMT_CUST_CHRG                                      21326300
MFA-TR*      ,WINTER_ADJ_AMT                                            21326400
MFA-TR*      )                                                          21326600
MFA-TR*      VALUES                                                     21326700
MFA-TR*      (                                                          21326800
MFA-TR*       :S-R5-RETURN-CODE                                         21326900
MFA-TR*      ,:S-R5-APPL-RETURN-CODE                                    21327000
MFA-TR*      ,:S-R5-BFC-SEASONAL-FL                                     21327100
MFA-TR*      ,:S-R5-AMT-CUST-CHRG                                       21327200
MFA-TR*      ,:S-R5-WINTER-AMT-CUST-CHRG                                21327300
MFA-TR*      ,:S-R5-WINTER-ADJ-AMT                                      21327400
MFA-TR*      )                                                          21327700
MFA-TR*    END-EXEC.                                                    21327800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              ADD +1                         TO  CTR-ROWS-RS5           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04456_R5'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21336200
      * 8900-SEND-DONE.                                                *21336400
      ******************************************************************21336500
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                 TO ABEND-PROGRAM           
           MOVE '8900'                       TO ACTIVE-PARAGRAPH        
           MOVE 'OPEN'                       TO ABEND-FUNCTION          
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-R1-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04456_R1'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-R2-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04456_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-R3-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04456_R3'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-R4-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04456_R4'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                 S-R5-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE       = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04456_R5'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21350300
      * 9000-SEND-ERROR-RESULT                                         *21350500
      ******************************************************************21350600
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-R1-RETURN-CODE        
                                                S-R2-RETURN-CODE        
                                                S-R3-RETURN-CODE        
                                                S-R4-RETURN-CODE        
                                                S-R5-RETURN-CODE.       
                                                                        
           MOVE WS-APPL-RETURN-CODE          TO S-R1-APPL-RETURN-CODE   
                                                S-R2-APPL-RETURN-CODE   
                                                S-R3-APPL-RETURN-CODE   
                                                S-R4-APPL-RETURN-CODE   
                                                S-R5-APPL-RETURN-CODE.  
                                                                        
                                                                        
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE                     = SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1       THRU 0100A-EXIT.          
           PERFORM 0100B-DECLARE-GTT-R2       THRU 0100B-EXIT.          
           PERFORM 0100C-DECLARE-GTT-R3       THRU 0100C-EXIT.          
           PERFORM 0100D-DECLARE-GTT-R4       THRU 0100D-EXIT.          
           PERFORM 0100E-DECLARE-GTT-R5       THRU 0100E-EXIT.          
                                                                        
           PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT.           
           PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT.           
           PERFORM 8030-INSERT-GTT-R3         THRU 8030-EXIT.           
           PERFORM 8040-INSERT-GTT-R4         THRU 8040-EXIT.           
           PERFORM 8050-INSERT-GTT-R5         THRU 8050-EXIT.           
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21356300
      * 9700-ABEND-PROCESSING.                                         *21356400
      ******************************************************************21356500
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT.           
           PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT.           
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21357400
      * 9900-SQL-ERROR-ROUTINE.                                        *21357500
      ******************************************************************21357600
                                                                        
           EXEC SQL                                                     21357800
              INCLUDE CPDSP300                                          21357900
           END-EXEC.                                                    21358000
                                                                        
      ******************************************************************21358200
      * 9999-END-PROGRAM.                                              *21358300
      ******************************************************************21358400
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS-RS1 < 1 OR                                       
              CTR-ROWS-RS2 < 1 OR                                       
              CTR-ROWS-RS3 < 1 OR                                       
              CTR-ROWS-RS4 < 1 OR                                       
              CTR-ROWS-RS5 < 1                                          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '9999-END-PROGRAM'        TO ABEND-FUNCTION          
              MOVE 'PROGRAMMER LOGIC'        TO TABLE-1                 
              MOVE 'FAILED TO SEND'          TO TABLE-ELEMENT-1         
              MOVE 'RESULT SET'              TO HOSTVAR-ELEMENT-1       
              MOVE -1                        TO WS-ACTIVE-RETURN-CODE   
                                                                        
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE          THRU 8900-EXIT            
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
      *                                                                 21370000
