       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04455.                                      
       AUTHOR.       HA7A338.                                           
COB303 DATE-WRITTEN.     MAR 29, 2012.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *        CSR04455 CLONED FROM SP'S CSR02219/CSR02236/CSR03623    *        
      *        FOR RATE MANAGEMENT MODULE (RMM)                        *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *          THIS PROGRAM INSERT/UPDATE/DELETE RATE VERSION        *        
      *                                                                *        
      *  THIS PROCEDURE INSERTES/UPDATES/DELETES ROWS                  *00200065
      *  IF THE UPDATE FLAG IS I :                                     *00200265
      *     THE INSERT CAN BE FOR A NEW RATE PLAN OR A NEW VERSION     *00200365
      *     IF CSS_RATE_PLAN_DESC EXISTS THEN UPDATE RD, INSERT RC, J4 *00200465
      *     AND INSERT RS IF A VALUE HAS BEEN ENTERED.                 *00200565
      *     IF CSS_RATE_PLAN_DESC DOES NOT EXISTS INSERT RD, RC, J4    *00200665
      *     AND INSERT RS IF A VALUE HAS BEEN ENTERED.                 *00200765
      *   IF THE UPDATE FLAG IS U:                                     *00200865
      *     UPDATE RD, J4. IF A VALUE HAS BEEN ENTERED FOR RS          *00200965
      *     UPDATE IT IF IT EXISTS ELSE INSERT IT.                     *00201065
      *   IF THE UPDATE FLAG IS F(FILE):                               *00201165
      *     UPDATE RC.                                                 *00201265
      *  THE VERSION-NO-CNTRL THAT IS RETURNED IS TO ENABLE THE        *00201378
      *  WINDOW TO RETRIEVE THE NEW VERSION                            *00201578
      *                                                                *00200157
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             APPL_PROG_ID               CHAR(03)                *        
      *             RTVRSN_UPD_FLAG            CHAR(01)                *        
      *             CODE_UTIL_TYPE             CHAR(01)                *        
      *             RATE_PLAN_NO               CHAR(03)                *        
      *             VERSION_NO_CNTRL           SMALLINT                *        
      *             RATE_DESC                  CHAR(50)                *        
      *             VERS_PRORATE_CD            CHAR(01)                *        
      *             CODE_STATUS                CHAR(01)                *        
      *             SEAS_PRORATE_CD            CHAR(01)                *        
      *             DATE_FROM                  SMALLINT                *        
      *             DATE_TO                    SMALLINT                *        
      *             USER_ID                    CHAR(07)                *        
      *             EFFECTIVE_DATE             CHAR(10)                *        
      *             BILL_FORMAT_CD             CHAR(02)                *        
      *             COMPANY_NO                 CHAR(02)                *        
      *             SECURED_RATE_FL            CHAR(01)                *        
      *             SUM_REVENUE_FL             CHAR(01)                *        
      *             UNMETER_FL                 CHAR(01)                *        
      *             SEASONAL_DEP_IND           CHAR(01)                *        
      *             BASE_LOAD_THERMS           CHAR(09)                *        
      *             HEAT_SENSITIVE_FAC         CHAR(05)                *        
      *             REG_GROUP_CD               CHAR(03)                *        
      *             BILL_LITERAL_TX            CHAR(50)                *        
      *             SEASNAL_BLK_CHG_CD         CHAR(01)                *        
      *             SENIOR_RATE_FL             CHAR(01)                *        
      *             DEF_COG_FL                 CHAR(01)                *        
      *             MKT_PROGRAM_CD             CHAR(02)                *        
      *             RATE_CALC_TYPE_CD          CHAR(02)                *        
      *             RATE_DEFINITION_CD         CHAR(01)                *        
      *             RATE_DEPT_CD               CHAR(03)                *        
      *             DISPLAY_START_TS           CHAR(26)                *        
      *             DISPLAY_END_TS             CHAR(26)                *        
      *             VRSN_DISPLAY_START_TS      CHAR(26)                *        
      *             VRSN_DISPLAY_END_TS        CHAR(26)                *        
      *             REV_CUST_COUNT_CD          CHAR(01)                *        
      *             CODE_SERVICE_TYPE          CHAR(01)                *        
      *             PROC_REQ_ID                CHAR(10)                *        
      *             PROC_REQ_ID                CHAR(10)                *        
      *             CODE_SERVICE_TYPE          CHAR(01)                *        
      *             DELETE_BY_REQUEST          CHAR(01)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -----------------                                             *        
      *             RETURN_CODE                INTEGER                 *        
      *             APPL_RETURN_CODE           INTEGER                 *        
      *             CODE_UTIL_TYPE             CHAR(01)                *        
      *             RATE_PLAN_NO               CHAR(03)                *        
      *             VERSION_NO_CNTRL           INTEGER                 *        
      *                                                                *00209857
      *  THE FOLLOWING TABLES ARE USED :                               *00209957
      *      TABLE NAME          DCLGEN NAME    2 CHAR ID              *00210057
      *      ------------------  -----------    ---------              *00210157
      *      CSS_RATE_PLAN_DESC  TBRTDESC       RD                     *00210257
      *      CSS_RATE_CREATOR    TBRTCRTR       RT                     *00210357
      *      CSS_RATE_USE_SEASN  TBRTUSES       RS                     *00210457
      *      CSS_RATE_VRSN_DEF   TBRTVRSN       J4                     *00210557
      *      CSS_RATE_HIGH_LOW   TBRTHGLW       O9                     *00210557
      *      CSS_DMT_PGM_ID      TBDMTPI        T2                     *00210557
      *      CSS_BTU_WNA_RANGE   TBBTUWNA       BR                     *00210557
      *      CSS_REV_CLS_RATE    TBRVCLS        Q8                     *00210557
      *      CSS_SPCL_FCTR_APPL  TBSPLAPL       SA                     *00210557
      *      CSS_UTIL_ENVRNMT    TBUTLENV       UT                     *00210557
      *      CSS_ACCOUNT         TBACCT         AT                     *00210557
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *  --------    --------   ------------------------------         *        
      *  03-29-2012  HA7A338    NEW PROGRAM                            *        
      *  08-22-2012  AW41078    MODIFIED 5100-GET-VRSN-NO SO IF        *        
      *                         PARM-EFFECTIVE-DATE IS PASSED IT       *        
      *                         UPDATES CSS_RATE_CREATOR               *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04455'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04455 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC   RD                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR     RT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_VRSN_DEF    J4                                              
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTVRSN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_USE_SEASN   RS                                              
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTUSES                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_RATE_HIGH_LOW, O9                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTHGLW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DMT_PGM_ID, T2                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDMTPI                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BTU_WNA_RANGE, BR                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBTUWNA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_REV_CLS_RATE, Q8                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVCLS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SPCL_FCTR_APPL, SA                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM, G6                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_UTIL_ENVRNMT, UT                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_ACCOUNT, AT                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                       
      ******************************************************************        
           COPY CWS00027.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  WS-PROGRAM-NAME           PIC X(08) VALUE 'CSR04455'.    
           05  WS-CODE-UTIL-TYPE         PIC X(1)  VALUE SPACES.        
           05  WS-RATE-PLAN-NO           PIC X(3)  VALUE SPACES.        
           05  WS-VERSION-NO-CNTRL       PIC S9(4) USAGE COMP.          
           05  WS-MAX-VERSION-NO-CNTRL   PIC S9(4) USAGE COMP.          
           05  WS-MAX-VERS-NO-CNTRL-NULL PIC S9(4) USAGE COMP.          
           05  WS-MAX-ACTIVE-VERS-NO     PIC S9(4) USAGE COMP.          
           05  WS-BASE-LOAD-INT          PIC S9(9).                     
COB305     05 WS-BASE-LOAD        PIC S9(4)V9(5) COMP-3 VALUE 0.         
           05  WS-HEAT-SENS-FAC-INT      PIC S9(5).                     
COB305     05 WS-HEAT-SENS-FAC        PIC SV9(5) COMP-3 VALUE 0.             
           05  WS-RATE-PLAN-EXISTS       PIC X(1)  VALUE 'N'.           
           05  WS-RATE-EXISTS            PIC X(1)  VALUE 'N'.           
           05  WS-RATE-USE-SEASN-EXISTS  PIC X(1)  VALUE 'N'.           
           05  WS-TOMORROW               PIC X(10) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.        
           05  WS-COMPANY-NO             PIC X(02) VALUE '01'.          
           05  WS-SEASONAL-DEP-IND-NULL  PIC S9(4) USAGE COMP.          
           05  WS-OK-TO-INACT-RATE       PIC X(01) VALUE ' '.           
           05  WS-BILL-LITERAL-TX        PIC X(50) VALUE ' '.           
           05  WS-FACTOR-INSRTD          PIC X(01) VALUE 'N'.           
           05  WS-PROC-REQ-ID            PIC X(10) VALUE SPACES.        
           05  WS-PROC-REQ-ID-RED    REDEFINES WS-PROC-REQ-ID           
                                         PIC 9(10).                     
           05  WS-PROC-REQ-ID-INT        PIC S9(10) COMP-3 VALUE 0.     
                                                                        
       01  WS-SWITCHES.                                                 
           05  CSR04455-DONE-SW        PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05 WS-NO-MORE-ROWS          PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
           05 WS-ACTIVE-RT-UPDATE      PIC X(01) VALUE 'N'.             
               88 ACTIVE-RT-UPDATABLE            VALUE 'Y'.             
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-01          PIC S9(4) COMP.                   
           05 WS-NULL-IND-02          PIC S9(4) COMP.                   
           05 WS-NULL-IND-03          PIC S9(4) COMP.                   
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-COMMON                PIC X(1) VALUE 'C'.             
           05  WS-SUMMER                PIC X(1) VALUE 'S'.             
           05  WS-TEST                  PIC X(1) VALUE 'T'.             
           05  WS-ACTIVE                PIC X(1) VALUE 'A'.             
           05  WS-INACTIVE              PIC X(1) VALUE 'I'.             
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04455'.      
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-GTT-NAME             PIC X(19) VALUE SPACES.          
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME               PIC X(26)                        
                                       VALUE 'SESSION.CSR04455_R1'.     
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN         PIC S9(04) COMP.                 
                49 GTT-ROW-CHAR        PIC X(1024).                     
            05  GTT-SQLCODE            PIC S9(09) COMP.                 
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(09) COMP VALUE 1.         
           05  CTR-ROWS                PIC S9(09) COMP VALUE 0.         
           05  WS-ROW-COUNT            PIC S9(09) COMP VALUE 0.         
           05  WS-NO-ROWS              PIC S9(04) COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(09) COMP.                 
           05  WRKLEN1                 PIC S9(09) COMP.                 
           05  WRKLEN2                 PIC S9(09) COMP.                 
           05  WRK-DONE-STATUS         PIC S9(09) COMP.                 
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
           05  S-APPL-RETURN-CODE      PIC S9(09) COMP VALUE 0.         
           05  S-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACE.          
           05  S-RATE-PLAN-NO          PIC X(03)  VALUE SPACE.          
           05  S-VERSION-NO-CNTRL      PIC S9(04) USAGE COMP.           
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
      *    NOT USING ANY CURSOR IN THIS SP                             *        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID          PIC X(03).                        
       01  PARM-RTVRSN-UPD-FLAG       PIC X(01).                        
       01  PARM-CODE-UTIL-TYPE        PIC X(01).                        
       01  PARM-RATE-PLAN-NO          PIC X(03).                        
       01  PARM-VERSION-NO-CNTRL      PIC S9(4) USAGE COMP.             
       01  PARM-RATE-DESC             PIC X(50).                        
       01  PARM-VERS-PRORATE-CD       PIC X(01).                        
       01  PARM-CODE-STATUS           PIC X(01).                        
       01  PARM-SEAS-PRORATE-CD       PIC X(01).                        
       01  PARM-DATE-FROM             PIC S9(4) USAGE COMP.             
       01  PARM-DATE-TO               PIC S9(4) USAGE COMP.             
       01  PARM-USER-ID               PIC X(07).                        
       01  PARM-EFFECTIVE-DATE        PIC X(10).                        
       01  PARM-BILL-FORMAT-CD        PIC X(02).                        
       01  PARM-COMPANY-NO            PIC X(02).                        
       01  PARM-SECURED-RATE-FL       PIC X(01).                        
       01  PARM-SUM-REVENUE-FL        PIC X(01).                        
       01  PARM-UNMETER-FL            PIC X(01).                        
       01  PARM-SEASONAL-DEP-IND      PIC X(01).                        
       01  PARM-BASE-LOAD-THERMS      PIC X(09).                        
       01  PARM-HEAT-SENSITIVE-FAC    PIC X(05).                        
       01  PARM-REG-GROUP-CD          PIC X(03).                        
       01  PARM-BILL-LITERAL-TX       PIC X(50).                        
       01  PARM-SEASNAL-BLK-CHG-CD    PIC X(01).                        
       01  PARM-SENIOR-RATE-FL        PIC X(01).                        
       01  PARM-DEF-COG-FL            PIC X(01).                        
       01  PARM-MKT-PROGRAM-CD        PIC X(02).                        
       01  PARM-RATE-CALC-TYPE-CD     PIC X(02).                        
       01  PARM-RATE-DEFINITION-CD    PIC X(01).                        
       01  PARM-RATE-DEPT-CD          PIC X(03).                        
       01  PARM-DISPLAY-START-TS      PIC X(26).                        
       01  PARM-DISPLAY-END-TS        PIC X(26).                        
       01  PARM-VRSN-DISPLAY-START-TS PIC X(26).                        
       01  PARM-VRSN-DISPLAY-END-TS   PIC X(26).                        
       01  PARM-REV-CUST-COUNT-CD     PIC X(01).                        
       01  PARM-PROC-REQ-ID           PIC X(10).                        
       01  PARM-CODE-SERVICE-TYPE     PIC X(01).                        
       01  PARM-DELETE-BY-REQUEST     PIC X(01).                        
       PROCEDURE DIVISION USING PARM-APPL-PROG-ID                       
                                PARM-RTVRSN-UPD-FLAG                    
                                PARM-CODE-UTIL-TYPE                     
                                PARM-RATE-PLAN-NO                       
                                PARM-VERSION-NO-CNTRL                   
                                PARM-RATE-DESC                          
                                PARM-VERS-PRORATE-CD                    
                                PARM-CODE-STATUS                        
                                PARM-SEAS-PRORATE-CD                    
                                PARM-DATE-FROM                          
                                PARM-DATE-TO                            
                                PARM-USER-ID                            
                                PARM-EFFECTIVE-DATE                     
                                PARM-BILL-FORMAT-CD                     
                                PARM-COMPANY-NO                         
                                PARM-SECURED-RATE-FL                    
                                PARM-SUM-REVENUE-FL                     
                                PARM-UNMETER-FL                         
                                PARM-SEASONAL-DEP-IND                   
                                PARM-BASE-LOAD-THERMS                   
                                PARM-HEAT-SENSITIVE-FAC                 
                                PARM-REG-GROUP-CD                       
                                PARM-BILL-LITERAL-TX                    
                                PARM-SEASNAL-BLK-CHG-CD                 
                                PARM-SENIOR-RATE-FL                     
                                PARM-DEF-COG-FL                         
                                PARM-MKT-PROGRAM-CD                     
                                PARM-RATE-CALC-TYPE-CD                  
                                PARM-RATE-DEFINITION-CD                 
                                PARM-RATE-DEPT-CD                       
                                PARM-DISPLAY-START-TS                   
                                PARM-DISPLAY-END-TS                     
                                PARM-VRSN-DISPLAY-START-TS              
                                PARM-VRSN-DISPLAY-END-TS                
                                PARM-REV-CUST-COUNT-CD                  
                                PARM-PROC-REQ-ID                        
                                PARM-CODE-SERVICE-TYPE                  
                                PARM-DELETE-BY-REQUEST.                 
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO  ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                      :S-RETURN-CODE            AS RETURN_CODE          
                     ,:S-APPL-RETURN-CODE       AS APPL_RETURN_CODE     
                     , LTRIM(RTRIM(:S-CODE-UTIL-TYPE)) AS CODE_UTIL_TYPE       
                     , LTRIM(RTRIM(:S-RATE-PLAN-NO))   AS RATE_PLAN_NO         
                     ,:S-VERSION-NO-CNTRL       AS VERSION_NO_CNTRL     
                FROM                                                    
                      CIS.SYSDUMMY1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*               :S-RETURN-CODE            AS RETURN_CODE                  
MFA-TR*              ,:S-APPL-RETURN-CODE       AS APPL_RETURN_CODE             
MFA-TR*              , STRIP(:S-CODE-UTIL-TYPE) AS CODE_UTIL_TYPE               
MFA-TR*              , STRIP(:S-RATE-PLAN-NO)   AS RATE_PLAN_NO                 
MFA-TR*              ,:S-VERSION-NO-CNTRL       AS VERSION_NO_CNTRL             
MFA-TR*         FROM                                                            
MFA-TR*               SYSIBM.SYSDUMMY1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     FORMATS A ROW BASED ON THE PASSED PARMS                    *05675019
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
      *    WHEN THE RATE VERSION UPDATE FLAG IS DELETE AND DELETE BY            
      *    REQUEST FLAG IS 'Y' ( INPUT),SHOULD GET THE KEY VALUES FROM          
      *    CSS_RATE_CREATOR TABLE TO PROCEED FURTHER.                           
                                                                        
           IF PARM-RTVRSN-UPD-FLAG   = 'D' AND                          
              PARM-DELETE-BY-REQUEST = 'Y'                              
              MOVE PARM-PROC-REQ-ID          TO WS-PROC-REQ-ID          
              MOVE WS-PROC-REQ-ID-RED        TO WS-PROC-REQ-ID-INT      
              IF WS-PROC-REQ-ID-INT  > 0                                
                 MOVE WS-PROC-REQ-ID-INT     TO RT-PROC-REQ-ID          
                 PERFORM 7000-GET-KEY-VALUE-RT  THRU 7000-EXIT          
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE RT-CODE-UTIL-TYPE   TO WS-CODE-UTIL-TYPE       
                                                SA-CODE-UTIL-TYPE       
                                                BR-CODE-UTIL-TYPE       
                                                O9-CODE-UTIL-TYPE       
                                                T2-CODE-UTIL-TYPE       
                                                RT-CODE-UTIL-TYPE       
                                                Q8-CODE-UTIL-TYPE       
                                                 S-CODE-UTIL-TYPE       
                                                                        
                    MOVE RT-RATE-PLAN-NO TO WS-RATE-PLAN-NO             
                                                SA-RATE-PLAN-NO         
                                                BR-RATE-PLAN-NO         
                                                O9-RATE-PLAN-NO         
                                                T2-RATE-PLAN-NO         
                                                RT-RATE-PLAN-NO         
                                                Q8-RATE-PLAN-NO         
                                                 S-RATE-PLAN-NO         
                 ELSE                                                   
                    MOVE 0                   TO S-RETURN-CODE           
                    MOVE 237                 TO S-APPL-RETURN-CODE      
                    ADD 1                    TO CTR-ROWS                
                    PERFORM 9999-END-PROGRAM    THRU 9999-EXIT          
                 END-IF                                                 
              ELSE                                                      
                 MOVE 0                      TO S-RETURN-CODE           
                 MOVE 237                    TO S-APPL-RETURN-CODE      
                 ADD 1                       TO CTR-ROWS                
                 PERFORM 9999-END-PROGRAM       THRU 9999-EXIT          
              END-IF                                                    
           ELSE                                                         
              MOVE PARM-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE       
                                                SA-CODE-UTIL-TYPE       
                                                BR-CODE-UTIL-TYPE       
                                                O9-CODE-UTIL-TYPE       
                                                T2-CODE-UTIL-TYPE       
                                                RT-CODE-UTIL-TYPE       
                                                Q8-CODE-UTIL-TYPE       
                                                 S-CODE-UTIL-TYPE       
              MOVE PARM-RATE-PLAN-NO         TO WS-RATE-PLAN-NO         
                                                SA-RATE-PLAN-NO         
                                                BR-RATE-PLAN-NO         
                                                O9-RATE-PLAN-NO         
                                                T2-RATE-PLAN-NO         
                                                RT-RATE-PLAN-NO         
                                                Q8-RATE-PLAN-NO         
                                                 S-RATE-PLAN-NO         
           END-IF.                                                      
                                                                        
           MOVE PARM-USER-ID                 TO RD-LAST-UPDATE-USERID   
                                                RT-LAST-UPDATE-USERID   
                                                RT-USER-ID.             
           MOVE PARM-COMPANY-NO              TO WS-COMPANY-NO.          
                                                                        
           MOVE PARM-SENIOR-RATE-FL          TO RD-SENIOR-RATE-FL.      
           MOVE PARM-DEF-COG-FL              TO RD-DEFERRED-COG-FL.     
           MOVE PARM-MKT-PROGRAM-CD          TO RD-MKT-PROGRAM-CD.      
           MOVE PARM-RATE-CALC-TYPE-CD       TO RD-RATE-CALC-TYPE-CD.   
           MOVE PARM-RATE-DEFINITION-CD      TO RD-RATE-DEFINITION-CD.  
           MOVE PARM-RATE-DEPT-CD            TO RD-RATE-DEPT-CD.        
           MOVE PARM-REV-CUST-COUNT-CD       TO RD-REV-CUST-COUNT-CD.   
           MOVE PARM-RATE-DESC               TO RD-RATE-DESC.           
           MOVE PARM-COMPANY-NO              TO RD-COMPANY-NO.          
           MOVE PARM-SECURED-RATE-FL         TO RD-SECURED-RATE-FL.     
           MOVE PARM-SUM-REVENUE-FL          TO RD-SUM-REVENUE-FL.      
           MOVE PARM-UNMETER-FL              TO RD-UNMTR-PROV-FL.       
           MOVE PARM-REG-GROUP-CD            TO RD-REG-GROUP-CD.        
           MOVE PARM-CODE-SERVICE-TYPE       TO RD-CODE-SERVICE-TYPE.   
           MOVE PARM-BILL-LITERAL-TX         TO WS-BILL-LITERAL-TX.     
           MOVE LENGTH OF WS-BILL-LITERAL-TX                            
                                             TO RD-BILL-LITERAL-TX-LEN. 
           MOVE WS-BILL-LITERAL-TX           TO RD-BILL-LITERAL-TX-TEXT.
                                                                        
           IF PARM-DISPLAY-START-TS > SPACES                            
              MOVE PARM-DISPLAY-START-TS     TO RD-DISPLAY-START-TS     
           ELSE                                                         
              MOVE '1900-01-01-00.00.00.000000'                         
                                             TO RD-DISPLAY-START-TS     
           END-IF                                                       
                                                                        
           IF PARM-DISPLAY-END-TS   > SPACES                            
              MOVE PARM-DISPLAY-END-TS       TO RD-DISPLAY-END-TS       
           ELSE                                                         
              MOVE '2999-12-31-00.00.00.000000'                         
                                             TO RD-DISPLAY-START-TS     
           END-IF                                                       
                                                                        
           MOVE PARM-SEASNAL-BLK-CHG-CD      TO RT-SEASNAL-BLK-CHG-CD.  
           MOVE PARM-VERS-PRORATE-CD         TO RT-VERS-PRORATE-CD.     
           MOVE PARM-BILL-FORMAT-CD          TO RT-BILL-FORMAT-CD.      
           MOVE WS-TEST                      TO RT-CODE-STATUS.         
           MOVE PARM-VRSN-DISPLAY-START-TS   TO RT-DISPLAY-START-TS.    
           MOVE PARM-VRSN-DISPLAY-END-TS     TO RT-DISPLAY-END-TS.      
           MOVE PARM-PROC-REQ-ID             TO RT-PROC-REQ-ID.         
                                                                        
           MOVE PARM-BASE-LOAD-THERMS        TO WS-BASE-LOAD-INT.       
           DIVIDE WS-BASE-LOAD-INT                                      
           BY     100000                                                
           GIVING WS-BASE-LOAD.                                         
           MOVE WS-BASE-LOAD                 TO RT-BASE-LOAD-THERMS.    
                                                                        
           MOVE PARM-HEAT-SENSITIVE-FAC      TO WS-HEAT-SENS-FAC-INT.   
           DIVIDE WS-HEAT-SENS-FAC-INT                                  
           BY     100000                                                
           GIVING WS-HEAT-SENS-FAC.                                     
           MOVE WS-HEAT-SENS-FAC             TO RT-HEAT-SENSITIVE-FAC.  
                                                                        
           MOVE WS-COMMON                    TO RS-CODE-USE-INST-TYPE.  
           MOVE WS-SUMMER                    TO RS-CODE-SEASON.         
           MOVE PARM-DATE-FROM               TO RS-DATE-FROM.           
           MOVE PARM-DATE-TO                 TO RS-DATE-TO.             
                                                                        
           MOVE ZEROES                       TO J4-LIM-PRO-RATE-CC.     
           MOVE PARM-SEAS-PRORATE-CD         TO J4-SEAS-PRORATE-CD.     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE             THRU 5000-EXIT.              
           ADD 1                             TO CTR-ROWS.               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05650013
      * 5000-UPDATE                                                    *05660013
      *     DETERMINES WHETHER THIS IS AN INSERT/UPDATE/DELETE. NEXT   *05680019
      *     THE APPROPRIATE PARAGRAPH IS CALLED TO DO THE INSERT /     *05690019
      *     UPDATE/DELETE TABLE ENTRIES                                *05700065
      ******************************************************************05710013
                                                                        
       5000-UPDATE.                                                     
                                                                        
           PERFORM 7050-GET-DATES              THRU 7050-EXIT.          
           PERFORM 5100-GET-VRSN-NO            THRU 5100-EXIT.          
                                                                        
           EVALUATE PARM-RTVRSN-UPD-FLAG                                
              WHEN 'I'                                                  
                 PERFORM 7200-SELECT-RTDESC-EXISTS    THRU 7200-EXIT    
                 IF WS-RATE-PLAN-EXISTS = 'Y'                           
                    PERFORM 8100-UPDATE-RTDESC        THRU 8100-EXIT    
                 ELSE                                                   
                    PERFORM 8400-INSERT-RTDESC        THRU 8400-EXIT    
                 END-IF                                                 
                 PERFORM 8410-INSERT-RTCRTR           THRU 8410-EXIT    
                 IF WS-CODE-UTIL-TYPE   NOT = 'U'                       
                    IF RS-DATE-FROM > 0 OR  RS-DATE-TO > 0              
                       PERFORM 8420-INSERT-RTUSES     THRU 8420-EXIT    
                    END-IF                                              
                    PERFORM 8430-INSERT-RTVRSN        THRU 8430-EXIT    
                 END-IF                                                 
                                                                        
              WHEN 'U'                                                  
                 PERFORM 8100-UPDATE-RTDESC           THRU 8100-EXIT    
                 PERFORM 8110-UPDATE-RTCRTR           THRU 8110-EXIT    
                 IF WS-CODE-UTIL-TYPE   NOT = 'U'                       
                    PERFORM 8130-UPDATE-RTVRSN        THRU 8130-EXIT    
                    PERFORM 7300-SELECT-RTUSES-EXISTS THRU 7300-EXIT    
                    IF WS-RATE-USE-SEASN-EXISTS = 'Y'                   
                       PERFORM 8120-UPDATE-RTUSES     THRU 8120-EXIT    
                    ELSE                                                
                       PERFORM 8420-INSERT-RTUSES     THRU 8420-EXIT    
                    END-IF                                              
                 END-IF                                                 
                                                                        
              WHEN 'E'                                                  
                 PERFORM 8100-UPDATE-RTDESC           THRU 8100-EXIT    
                 PERFORM 8112-UPDATE-SEAS-FL          THRU 8112-EXIT    
                 PERFORM 5200-CHK-ACT-RT-UPD       THRU 5200-EXIT       
                 IF ACTIVE-RT-UPDATABLE                                 
                    MOVE WS-ACTIVE        TO       RT-CODE-STATUS       
                    PERFORM 8110-UPDATE-RTCRTR     THRU 8110-EXIT       
                    IF WS-CODE-UTIL-TYPE NOT = 'U'                      
                       PERFORM 8130-UPDATE-RTVRSN     THRU 8130-EXIT    
                    END-IF                                              
                 END-IF                                                 
                 IF NOT ACTIVE-RT-UPDATABLE  AND                        
                    PARM-EFFECTIVE-DATE > SPACES                        
                    PERFORM 8113-UPDATE-RT-EFF-DT     THRU 8113-EXIT    
                 END-IF                                                 
                                                                        
              WHEN 'N'                                                  
                 MOVE SPACES                 TO WS-OK-TO-INACT-RATE     
                 PERFORM 7400-SELECT-AT-UT            THRU 7400-EXIT    
                 IF WS-OK-TO-INACT-RATE = 'N'                           
                    MOVE 0                   TO S-RETURN-CODE           
                    MOVE 289                 TO S-APPL-RETURN-CODE      
                    ADD 1                    TO CTR-ROWS                
                    PERFORM 9999-END-PROGRAM          THRU 9999-EXIT    
                 END-IF                                                 
                 MOVE WS-INACTIVE            TO RT-CODE-STATUS          
                 PERFORM 8111-UPDATE-RTCRTR           THRU 8111-EXIT    
                                                                        
              WHEN 'D'                                                  
                 PERFORM 7100-SELECT-CNT-N-MAX-VRSN     THRU 7100-EXIT  
                 PERFORM 8500-DELETE-RATE-CREATOR       THRU 8500-EXIT  
                                                                        
                 IF WS-NO-ROWS = 1                                      
                    PERFORM 8510-DELETE-BTU-WNA-RNGE    THRU 8510-EXIT  
                    PERFORM 8520-DELETE-SPCL-FCTR       THRU 8520-EXIT  
                    PERFORM 8530-DELETE-RATE-HI-LOW     THRU 8530-EXIT  
                    PERFORM 8540-DELETE-DTM-PGM-ID      THRU 8540-EXIT  
                    PERFORM 8550-DELETE-REV-CLS-RATE    THRU 8550-EXIT  
                    PERFORM 8560-DELETE-RATE-PLAN-DESC  THRU 8560-EXIT  
                 END-IF                                                 
           END-EVALUATE.                                                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE    TO  S-RETURN-CODE          
           END-IF.                                                      
                                                                        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10961019
      * 5100-GET-VRSN-NO                                               *10962019
      *     CALLS NOTHING                                              *10963019
      *                                                                *10964019
      *     CALLED FROM 5000-UPDATE                                    *10965019
      ******************************************************************10969019
                                                                        
       5100-GET-VRSN-NO.                                                
      *----------< WORK OUT WHAT THE NEW VERSION NO SHOULD BE - IF    > 10970065
      *----------< THE NULL INDICATOR IS NEGATIVE THEN NO VERSIONS    > 10969557
      *----------< EXIST AND THE NEW VERSION IS 1 ELSE ADD 1 TO THE   > 10969657
      *----------< LAST VERSION FOUND                                 > 10969757
           IF PARM-RTVRSN-UPD-FLAG  = 'I'                               
              PERFORM 7100-SELECT-CNT-N-MAX-VRSN THRU 7100-EXIT         
                                                                        
              IF WS-MAX-VERS-NO-CNTRL-NULL < 0                          
              OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 1                       TO WS-VERSION-NO-CNTRL    
              ELSE                                                      
                 MOVE WS-MAX-VERSION-NO-CNTRL TO WS-VERSION-NO-CNTRL    
                 ADD  1                       TO WS-VERSION-NO-CNTRL    
              END-IF                                                    
           ELSE                                                         
              IF PARM-RTVRSN-UPD-FLAG   = 'D' AND                       
                 PARM-DELETE-BY-REQUEST = 'Y'                           
                 MOVE RT-VERSION-NO-CNTRL     TO WS-VERSION-NO-CNTRL    
              ELSE                                                      
                 MOVE  PARM-VERSION-NO-CNTRL  TO WS-VERSION-NO-CNTRL    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE  WS-VERSION-NO-CNTRL          TO S-VERSION-NO-CNTRL.    
                                                                        
           IF PARM-EFFECTIVE-DATE > SPACE                               
              MOVE PARM-EFFECTIVE-DATE        TO RT-FROM-EFFECTIVE-DT   
           ELSE                                                         
              MOVE WS-TOMORROW                TO RT-FROM-EFFECTIVE-DT   
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-CHK-ACT-RT-UPD.                                           *        
      ******************************************************************        
       5200-CHK-ACT-RT-UPD.                                             
                                                                        
           MOVE 'N'                          TO WS-ACTIVE-RT-UPDATE.    
           MOVE 'PANEL395'                   TO G6-PROGRAM-NAME.        
           MOVE '01'                         TO G6-COMPANY-NO.          
           MOVE 'PARM'                       TO G6-CMND-CODE.           
           MOVE +01                          TO G6-SEQ-NO.              
           MOVE 'A'                          TO G6-STATUS.              
                                                                        
           PERFORM 7310-SELECT-JOB-PARM               THRU 7310-EXIT.   
           IF WS-ACTIVE-RETURN-CODE       EQUAL SUCCESSFUL-CALL         
              AND G6-PARM-DATA(1:3)       EQUAL WS-RATE-PLAN-NO         
              PERFORM 7320-GET-ACTIVE-MAX-VERS-NO     THRU 7320-EXIT    
              IF WS-MAX-ACTIVE-VERS-NO    EQUAL WS-VERSION-NO-CNTRL     
                 MOVE 'Y'                    TO WS-ACTIVE-RT-UPDATE     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 10984257
      * 7000-GET-KEY-VALUE-RT.                                        * 10984365
      ***************************************************************** 10990013
       7000-GET-KEY-VALUE-RT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RT.CODE_UTIL_TYPE                                  
                    ,RT.RATE_PLAN_NO                                    
                    ,RT.VERSION_NO_CNTRL                                
              INTO   :RT-CODE-UTIL-TYPE                                 
                    ,:RT-RATE-PLAN-NO                                   
                    ,:RT-VERSION-NO-CNTRL                               
              FROM   CSS_RATE_CREATOR    RT WITH(READUNCOMMITTED)               
              WHERE  RT.PROC_REQ_ID    = :RT-PROC-REQ-ID                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11030013
MFA-TR*       SELECT RT.CODE_UTIL_TYPE                                  10976257
MFA-TR*             ,RT.RATE_PLAN_NO                                    10976257
MFA-TR*             ,RT.VERSION_NO_CNTRL                                10976257
MFA-TR*       INTO   :RT-CODE-UTIL-TYPE                                 10976357
MFA-TR*             ,:RT-RATE-PLAN-NO                                   10976357
MFA-TR*             ,:RT-VERSION-NO-CNTRL                               10976357
MFA-TR*       FROM   CSS_RATE_CREATOR    RT                             10976457
MFA-TR*       WHERE  RT.PROC_REQ_ID    = :RT-PROC-REQ-ID                10976557
MFA-TR*       WITH UR                                                   11120013
MFA-TR*       QUERYNO 7000                                              11120013
MFA-TR*    END-EXEC.                                                    11120013

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'PROC_REQ_ID'              TO TABLE-ELEMENT-1        
              MOVE RT-PROC-REQ-ID             TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10993913
      * 7050-GET-DATES                                                  10994074
      *     SELECTS TOMORROWS DATE                                    * 10994674
      ***************************************************************** 10994874
       7050-GET-DATES.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, 1, CAST(SYSDATETIMEOFFSET() AS DATE) ),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TOMORROW,
              :WS-CURRENT-TIMESTAMP             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10995674
MFA-TR*       SET :WS-TOMORROW          = CURRENT DATE + 1 DAYS         10995874
MFA-TR*          ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                    10996274

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET DATES'                TO ABEND-FUNCTION         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10984257
      * 7100-SELECT-CNT-N-MAX-VRSN                                    * 10984365
      *     SELECTS CSS_RATE_CREATOR                                  * 10975457
      ***************************************************************** 10990013
       7100-SELECT-CNT-N-MAX-VRSN.                                      
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
                    ,COUNT(*)                                           
              INTO   :WS-MAX-VERSION-NO-CNTRL :WS-MAX-VERS-NO-CNTRL-NULL        
                    ,:WS-NO-ROWS                                        
              FROM   CSS_RATE_CREATOR WITH(READUNCOMMITTED)                     
              WHERE  CODE_UTIL_TYPE    =:WS-CODE-UTIL-TYPE              
              AND    RATE_PLAN_NO      =:WS-RATE-PLAN-NO                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11030013
MFA-TR*       SELECT MAX(VERSION_NO_CNTRL)                              10976257
MFA-TR*             ,COUNT(*)                                           10976257
MFA-TR*       INTO   :WS-MAX-VERSION-NO-CNTRL                           10976357
MFA-TR*              :WS-MAX-VERS-NO-CNTRL-NULL                         10976357
MFA-TR*             ,:WS-NO-ROWS                                        10976357
MFA-TR*       FROM   CSS_RATE_CREATOR                                   10976457
MFA-TR*       WHERE  CODE_UTIL_TYPE    =:WS-CODE-UTIL-TYPE              10976557
MFA-TR*       AND    RATE_PLAN_NO      =:WS-RATE-PLAN-NO                10976657
MFA-TR*       WITH UR                                                   11120013
MFA-TR*       QUERYNO 7100                                              11120013
MFA-TR*    END-EXEC.                                                    11120013

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10972013
      * 7200-SELECT-RTDESC-EXISTS                                     * 10975365
      *     SELECTS CSS_RATE_PLAN_DESC - CHECKS TO SEE IF THE NEW     * 10975965
      *     RATE PLAN ALREADY EXISTS                                  * 10976065
      ***************************************************************** 10976165
       7200-SELECT-RTDESC-EXISTS.                                       
                                                                        
           MOVE WS-N                         TO WS-RATE-PLAN-EXISTS.    
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO  :WS-RATE-PLAN-EXISTS                                
              FROM   CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                   
              WHERE  CODE_UTIL_TYPE  =:WS-CODE-UTIL-TYPE                
              AND    RATE_PLAN_NO    =:WS-RATE-PLAN-NO                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10976965
MFA-TR*       SELECT 'Y'                                                10977074
MFA-TR*       INTO  :WS-RATE-PLAN-EXISTS                                10977274
MFA-TR*       FROM   CSS_RATE_PLAN_DESC                                 10977465
MFA-TR*       WHERE  CODE_UTIL_TYPE  =:WS-CODE-UTIL-TYPE                10977565
MFA-TR*       AND    RATE_PLAN_NO    =:WS-RATE-PLAN-NO                  10977665
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    10977765

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11640013
      * 7300-SELECT-RTUSES-EXISTS                                     * 10988565
      *     SELECTS CSS_RATE_USE_SEASN - CHECKS TO SEE IF THE NEW     * 10989165
      *     RATE PLAN SEASON  EXISTS                                  * 10989265
      ***************************************************************** 10989365
       7300-SELECT-RTUSES-EXISTS.                                       
                                                                        
           MOVE WS-N                        TO WS-RATE-USE-SEASN-EXISTS.
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO   :WS-RATE-USE-SEASN-EXISTS                          
              FROM   CSS_RATE_USE_SEASN WITH(READUNCOMMITTED)                   
              WHERE  CODE_UTIL_TYPE      =:WS-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO        =:WS-RATE-PLAN-NO              
              AND    VERSION_NO_CNTRL    =:WS-VERSION-NO-CNTRL          
              AND    CODE_USE_INST_TYPE  ='C'                           
              AND    CODE_SEASON         ='S'                           
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10990165
MFA-TR*       SELECT 'Y'                                                10990265
MFA-TR*       INTO   :WS-RATE-USE-SEASN-EXISTS                          10990465
MFA-TR*       FROM   CSS_RATE_USE_SEASN                                 10990665
MFA-TR*       WHERE  CODE_UTIL_TYPE      =:WS-CODE-UTIL-TYPE            10990773
MFA-TR*       AND    RATE_PLAN_NO        =:WS-RATE-PLAN-NO              10990873
MFA-TR*       AND    VERSION_NO_CNTRL    =:WS-VERSION-NO-CNTRL          10990973
MFA-TR*       AND    CODE_USE_INST_TYPE  ='C'                           10991073
MFA-TR*       AND    CODE_SEASON         ='S'                           10991173
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                    10991065

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_USE_SEASN'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-SELECT-JOB-PARM.                                          *        
      ******************************************************************        
       7310-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
               WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                 
                 AND G6.COMPANY_NO   = :G6-COMPANY-NO                   
                 AND G6.CMND_CODE    = :G6-CMND-CODE                    
                 AND G6.SEQ_NO       = :G6-SEQ-NO                       
                 AND G6.STATUS       = :G6-STATUS                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT G6.PARM_DATA                                               
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                         
MFA-TR*          AND G6.COMPANY_NO   = :G6-COMPANY-NO                           
MFA-TR*          AND G6.CMND_CODE    = :G6-CMND-CODE                            
MFA-TR*          AND G6.SEQ_NO       = :G6-SEQ-NO                               
MFA-TR*          AND G6.STATUS       = :G6-STATUS                               
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7310                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7310'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'PROGRAM_NAME'             TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CMND_CODE'                TO TABLE-ELEMENT-3        
              MOVE 'SEQ_NO'                   TO TABLE-ELEMENT-4        
              MOVE G6-PROGRAM-NAME            TO HOSTVAR-ELEMENT-1      
              MOVE G6-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE G6-CMND-CODE               TO HOSTVAR-ELEMENT-3      
              MOVE G6-SEQ-NO                  TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10984257
      * 7320-GET-ACTIVE-MAX-VERS-NO                                   * 10984365
      *     SELECTS CSS_RATE_CREATOR TO GET MAX ACTIVE VERSION NO     * 10975457
      ***************************************************************** 10990013
       7320-GET-ACTIVE-MAX-VERS-NO.                                     
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
              INTO   :WS-MAX-ACTIVE-VERS-NO :WS-NULL-IND-03              
              FROM   CSS_RATE_CREATOR WITH(READUNCOMMITTED)                     
              WHERE  CODE_UTIL_TYPE    =:WS-CODE-UTIL-TYPE              
              AND    RATE_PLAN_NO      =:WS-RATE-PLAN-NO                
              AND    CODE_STATUS       = 'A'                            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11030013
MFA-TR*       SELECT MAX(VERSION_NO_CNTRL)                              10976257
MFA-TR*       INTO   :WS-MAX-ACTIVE-VERS-NO:WS-NULL-IND-03              10976357
MFA-TR*       FROM   CSS_RATE_CREATOR                                   10976457
MFA-TR*       WHERE  CODE_UTIL_TYPE    =:WS-CODE-UTIL-TYPE              10976557
MFA-TR*       AND    RATE_PLAN_NO      =:WS-RATE-PLAN-NO                10976657
MFA-TR*       AND    CODE_STATUS       = 'A'                                    
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7320                                                      
MFA-TR*    END-EXEC.                                                    11120013

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-03 < 0                                     
                 MOVE ZERO                   TO WS-MAX-ACTIVE-VERS-NO   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7320'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-AT-UT.                                             *        
      *     FIND IF THERE IS ANY ACCOUNT WHICH USES THE RATE PLAN NO.  *        
      ******************************************************************        
       7400-SELECT-AT-UT.                                               
                                                                        
           EXEC SQL                                                     
             SELECT TOP(1) 'N'                                                 
               INTO :WS-OK-TO-INACT-RATE                                
               FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED)                   
                   ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
              WHERE AT.ACCOUNT_NO  = UT.ACCOUNT_NO                      
                AND RATE_PLAN_NO   = :WS-RATE-PLAN-NO                   
                AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                 
                AND CODE_ACCT_STAT IN ('A','P')                         
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT 'N'                                                         
MFA-TR*        INTO :WS-OK-TO-INACT-RATE                                        
MFA-TR*        FROM CSS_ACCOUNT      AT                                         
MFA-TR*            ,CSS_UTIL_ENVRNMT UT                                         
MFA-TR*       WHERE AT.ACCOUNT_NO  = UT.ACCOUNT_NO                            04
MFA-TR*         AND RATE_PLAN_NO   = :WS-RATE-PLAN-NO                         07
MFA-TR*         AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                       07
MFA-TR*         AND CODE_ACCT_STAT IN ('A','P')                               06
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                     06
MFA-TR*      QUERYNO 7400                                                     06
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-2                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10998613
      * 8100-UPDATE-RTDESC                                            * 10980057
      *     UPDATES CSS_RATE_PLAN_DESC                                * 10985057
      ***************************************************************** 11660013
       8100-UPDATE-RTDESC.                                              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_PLAN_DESC                                 
              SET    RATE_DESC          = :RD-RATE-DESC                 
                    ,COMPANY_NO         = :RD-COMPANY-NO                
                    ,SECURED_RATE_FL    = :RD-SECURED-RATE-FL           
                    ,SUM_REVENUE_FL     = :RD-SUM-REVENUE-FL            
                    ,UNMTR_PROV_FL      = :RD-UNMTR-PROV-FL             
                    ,REG_GROUP_CD       = :RD-REG-GROUP-CD              
                    ,BILL_LITERAL_TX    = :RD-BILL-LITERAL-TX           
                    ,SENIOR_RATE_FL     = :RD-SENIOR-RATE-FL            
                    ,DEFERRED_COG_FL    = :RD-DEFERRED-COG-FL           
                    ,MKT_PROGRAM_CD     = :RD-MKT-PROGRAM-CD            
                    ,RATE_CALC_TYPE_CD  = :RD-RATE-CALC-TYPE-CD         
                    ,RATE_DEFINITION_CD = :RD-RATE-DEFINITION-CD        
                    ,RATE_DEPT_CD       = :RD-RATE-DEPT-CD              
                    ,REV_CUST_COUNT_CD  = :RD-REV-CUST-COUNT-CD         
                    ,DISPLAY_START_TS   = CIS.CHAR2TIMESTAMP(
                                                   :RD-DISPLAY-START-TS
              )          
                    ,DISPLAY_END_TS     = CIS.CHAR2TIMESTAMP(
                                                     :RD-DISPLAY-END-TS
              )            
                    ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
                    ,LAST_UPDATE_USERID = :RD-LAST-UPDATE-USERID        
                    ,CODE_SERVICE_TYPE  = :RD-CODE-SERVICE-TYPE         
              WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO       = :WS-RATE-PLAN-NO              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11030013
MFA-TR*       UPDATE CSS_RATE_PLAN_DESC                                 11040057
MFA-TR*       SET    RATE_DESC          = :RD-RATE-DESC                 11050057
MFA-TR*             ,COMPANY_NO         = :RD-COMPANY-NO                11070057
MFA-TR*             ,SECURED_RATE_FL    = :RD-SECURED-RATE-FL           11070057
MFA-TR*             ,SUM_REVENUE_FL     = :RD-SUM-REVENUE-FL            11070057
MFA-TR*             ,UNMTR_PROV_FL      = :RD-UNMTR-PROV-FL                     
MFA-TR*             ,REG_GROUP_CD       = :RD-REG-GROUP-CD                      
MFA-TR*             ,BILL_LITERAL_TX    = :RD-BILL-LITERAL-TX                   
MFA-TR*             ,SENIOR_RATE_FL     = :RD-SENIOR-RATE-FL                    
MFA-TR*             ,DEFERRED_COG_FL    = :RD-DEFERRED-COG-FL                   
MFA-TR*             ,MKT_PROGRAM_CD     = :RD-MKT-PROGRAM-CD                    
MFA-TR*             ,RATE_CALC_TYPE_CD  = :RD-RATE-CALC-TYPE-CD                 
MFA-TR*             ,RATE_DEFINITION_CD = :RD-RATE-DEFINITION-CD                
MFA-TR*             ,RATE_DEPT_CD       = :RD-RATE-DEPT-CD                      
MFA-TR*             ,REV_CUST_COUNT_CD  = :RD-REV-CUST-COUNT-CD                 
MFA-TR*             ,DISPLAY_START_TS   = :RD-DISPLAY-START-TS                  
MFA-TR*             ,DISPLAY_END_TS     = :RD-DISPLAY-END-TS                    
MFA-TR*             ,LAST_UPDATE_TS     = :WS-CURRENT-TIMESTAMP                 
MFA-TR*             ,LAST_UPDATE_USERID = :RD-LAST-UPDATE-USERID                
MFA-TR*             ,CODE_SERVICE_TYPE  = :RD-CODE-SERVICE-TYPE                 
MFA-TR*       WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            11110057
MFA-TR*       AND    RATE_PLAN_NO       = :WS-RATE-PLAN-NO              11111057
MFA-TR*       QUERYNO 8100                                              11610028
MFA-TR*    END-EXEC.                                                    11610028

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RD-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11641013
      * 8110-UPDATE-RTCRTR                                            * 11332057
      *     UPDATES CSS_RATE_CREATOR                                  * 11338057
      ***************************************************************** 11660013
       8110-UPDATE-RTCRTR.                                              
                                                                        
           MOVE PARM-SEASONAL-DEP-IND        TO RT-SEASONAL-DEP-IND.    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_CREATOR                                   
              SET    CODE_STATUS         =:RT-CODE-STATUS               
                    ,DATE_CREATED        = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
                    ,FROM_EFFECTIVE_DT   =IIF(TRY_CONVERT(DATE, 
                                                  :RT-FROM-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :RT-FROM-EFFECTIVE-DT
              ) <> 0) OR (LEN(:RT-FROM-EFFECTIVE-DT
              ) <> 10), CIS.CHAR2DATE(:RT-FROM-EFFECTIVE-DT
              ), CONVERT(DATE, :RT-FROM-EFFECTIVE-DT) )         
                    ,USER_ID             =:RT-USER-ID                   
                    ,BILL_FORMAT_CD      =:RT-BILL-FORMAT-CD            
                    ,SEASONAL_DEP_IND    =:RT-SEASONAL-DEP-IND 
                                          :WS-SEASONAL-DEP-IND-NULL     
                    ,BASE_LOAD_THERMS    =:RT-BASE-LOAD-THERMS          
                    ,HEAT_SENSITIVE_FAC  =:RT-HEAT-SENSITIVE-FAC        
                    ,VERS_PRORATE_CD     =:RT-VERS-PRORATE-CD           
                    ,SEASNAL_BLK_CHG_CD  =:RT-SEASNAL-BLK-CHG-CD        
                    ,DISPLAY_START_TS    =CIS.CHAR2TIMESTAMP(
                                                   :RT-DISPLAY-START-TS
              )          
                    ,DISPLAY_END_TS      =CIS.CHAR2TIMESTAMP(
                                                     :RT-DISPLAY-END-TS
              )            
                    ,LAST_UPDATE_USERID  =:RT-LAST-UPDATE-USERID        
                    ,LAST_UPDATE_TS      =CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
              WHERE  CODE_UTIL_TYPE      =:WS-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO        =:WS-RATE-PLAN-NO              
              AND    VERSION_NO_CNTRL    =:WS-VERSION-NO-CNTRL          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11700013
MFA-TR*       UPDATE CSS_RATE_CREATOR                                   11339757
MFA-TR*       SET    CODE_STATUS         =:RT-CODE-STATUS               11339857
MFA-TR*             ,DATE_CREATED        = CURRENT DATE                 11339957
MFA-TR*             ,FROM_EFFECTIVE_DT   =:RT-FROM-EFFECTIVE-DT         11340083
MFA-TR*             ,USER_ID             =:RT-USER-ID                   11340157
MFA-TR*             ,BILL_FORMAT_CD      =:RT-BILL-FORMAT-CD            11340157
MFA-TR*             ,SEASONAL_DEP_IND    =:RT-SEASONAL-DEP-IND          11340157
MFA-TR*                                   :WS-SEASONAL-DEP-IND-NULL     11340157
MFA-TR*             ,BASE_LOAD_THERMS    =:RT-BASE-LOAD-THERMS          11340157
MFA-TR*             ,HEAT_SENSITIVE_FAC  =:RT-HEAT-SENSITIVE-FAC        11340157
MFA-TR*             ,VERS_PRORATE_CD     =:RT-VERS-PRORATE-CD                   
MFA-TR*             ,SEASNAL_BLK_CHG_CD  =:RT-SEASNAL-BLK-CHG-CD                
MFA-TR*             ,DISPLAY_START_TS    =:RT-DISPLAY-START-TS                  
MFA-TR*             ,DISPLAY_END_TS      =:RT-DISPLAY-END-TS                    
MFA-TR*             ,LAST_UPDATE_USERID  =:RT-LAST-UPDATE-USERID                
MFA-TR*             ,LAST_UPDATE_TS      =:WS-CURRENT-TIMESTAMP                 
MFA-TR*       WHERE  CODE_UTIL_TYPE      =:WS-CODE-UTIL-TYPE            11340457
MFA-TR*       AND    RATE_PLAN_NO        =:WS-RATE-PLAN-NO              11340557
MFA-TR*       AND    VERSION_NO_CNTRL    =:WS-VERSION-NO-CNTRL          11340657
MFA-TR*       QUERYNO 8110                                              11340657
MFA-TR*    END-EXEC.                                                    11870013

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'FROM_EFFECTIVE_DT'       TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RT-FROM-EFFECTIVE-DT      TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11343157
      * 8111-UPDATE-RTCRTR                                            * 11343280
      *     UPDATES CSS_RATE_CREATOR - SETS ACTIVE FLAG TO INACTIVE   * 11343880
      ***************************************************************** 11343980
                                                                        
       8111-UPDATE-RTCRTR.                                              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_CREATOR                                   
              SET    CODE_STATUS         =:RT-CODE-STATUS               
                    ,USER_ID             =:RT-USER-ID                   
                    ,LAST_UPDATE_USERID  =:RT-LAST-UPDATE-USERID        
                    ,LAST_UPDATE_TS      =CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
              WHERE  CODE_UTIL_TYPE      =:WS-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO        =:WS-RATE-PLAN-NO              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11344580
MFA-TR*       UPDATE CSS_RATE_CREATOR                                   11344680
MFA-TR*       SET    CODE_STATUS         =:RT-CODE-STATUS               11344781
MFA-TR*             ,USER_ID             =:RT-USER-ID                   11345081
MFA-TR*             ,LAST_UPDATE_USERID  =:RT-LAST-UPDATE-USERID                
MFA-TR*             ,LAST_UPDATE_TS      =:WS-CURRENT-TIMESTAMP         11345081
MFA-TR*       WHERE  CODE_UTIL_TYPE      =:WS-CODE-UTIL-TYPE            11345180
MFA-TR*       AND    RATE_PLAN_NO        =:WS-RATE-PLAN-NO              11345280
MFA-TR*       QUERYNO 8111                                              11345280
MFA-TR*    END-EXEC.                                                    11345580

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8111'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RT-USER-ID                TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8111-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11641013
      *                                                               * 11655019
      * 8112-UPDATE-SEAS-FL.                                          * 11332057
      ***************************************************************** 11660013
       8112-UPDATE-SEAS-FL.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_CREATOR                                   
                 SET SEASNAL_BLK_CHG_CD = :RT-SEASNAL-BLK-CHG-CD        
                    ,LAST_UPDATE_USERID = :RT-LAST-UPDATE-USERID        
                    ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
               WHERE CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :WS-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11700013
MFA-TR*       UPDATE CSS_RATE_CREATOR                                   11339757
MFA-TR*          SET SEASNAL_BLK_CHG_CD = :RT-SEASNAL-BLK-CHG-CD        11339857
MFA-TR*             ,LAST_UPDATE_USERID = :RT-LAST-UPDATE-USERID                
MFA-TR*             ,LAST_UPDATE_TS     = :WS-CURRENT-TIMESTAMP                 
MFA-TR*        WHERE CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            11340457
MFA-TR*          AND RATE_PLAN_NO       = :WS-RATE-PLAN-NO              11340557
MFA-TR*          AND VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL          11340657
MFA-TR*        QUERYNO 8112                                             11340657
MFA-TR*    END-EXEC.                                                    11870013

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8112'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8112-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11641013
      *                                                               * 11655019
      * 8113-UPDATE-RT-EFF-DT.                                        * 11332057
      ***************************************************************** 11660013
       8113-UPDATE-RT-EFF-DT.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_CREATOR                                   
                 SET FROM_EFFECTIVE_DT  = IIF(TRY_CONVERT(DATE, 
                                                  :RT-FROM-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :RT-FROM-EFFECTIVE-DT
              ) <> 0) OR (LEN(:RT-FROM-EFFECTIVE-DT
              ) <> 10), CIS.CHAR2DATE(:RT-FROM-EFFECTIVE-DT
              ), CONVERT(DATE, :RT-FROM-EFFECTIVE-DT) )         
                    ,LAST_UPDATE_USERID = :RT-LAST-UPDATE-USERID        
                    ,LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )         
               WHERE CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :WS-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11700013
MFA-TR*       UPDATE CSS_RATE_CREATOR                                   11339757
MFA-TR*          SET FROM_EFFECTIVE_DT  = :RT-FROM-EFFECTIVE-DT         11339857
MFA-TR*             ,LAST_UPDATE_USERID = :RT-LAST-UPDATE-USERID                
MFA-TR*             ,LAST_UPDATE_TS     = :WS-CURRENT-TIMESTAMP         11339857
MFA-TR*        WHERE CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            11340457
MFA-TR*          AND RATE_PLAN_NO       = :WS-RATE-PLAN-NO              11340557
MFA-TR*          AND VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL          11340657
MFA-TR*        QUERYNO 8113                                             11340657
MFA-TR*    END-EXEC.                                                    11870013

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8113'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8113-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11348057
      * 8120-UPDATE-RTUSES                                            * 11343257
      *     UPDATES CSS_RATE_USE_SEASN                                * 11343857
      ***************************************************************** 11343957
                                                                        
       8120-UPDATE-RTUSES.                                              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_USE_SEASN                                 
              SET    DATE_FROM          = :RS-DATE-FROM                 
                    ,DATE_TO            = :RS-DATE-TO                   
              WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO       = :WS-RATE-PLAN-NO              
              AND    VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL          
              AND    CODE_USE_INST_TYPE = :RS-CODE-USE-INST-TYPE        
              AND    CODE_SEASON        = :RS-CODE-SEASON               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     11344557
MFA-TR*       UPDATE CSS_RATE_USE_SEASN                                 11344657
MFA-TR*       SET    DATE_FROM          = :RS-DATE-FROM                 11344757
MFA-TR*             ,DATE_TO            = :RS-DATE-TO                   11344857
MFA-TR*       WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            11345357
MFA-TR*       AND    RATE_PLAN_NO       = :WS-RATE-PLAN-NO              11345457
MFA-TR*       AND    VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL          11345557
MFA-TR*       AND    CODE_USE_INST_TYPE = :RS-CODE-USE-INST-TYPE        11345657
MFA-TR*       AND    CODE_SEASON        = :RS-CODE-SEASON               11345757
MFA-TR*       QUERYNO 8120                                              11345757
MFA-TR*    END-EXEC.                                                    11345857

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_USE_SEASN'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CODE_USE_INST_TYPE'      TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RS-CODE-USE-INST-TYPE     TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11348957
      * 8130-UPDATE-RTVRSN                                            * 11349057
      *     UPDATES CSS_RATE_VRSN_DEF.                                * 11349657
      ***************************************************************** 11349757
                                                                        
       8130-UPDATE-RTVRSN.                                              
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_VRSN_DEF                                  
              SET    LIM_PRO_RATE_CC    = :J4-LIM-PRO-RATE-CC           
                    ,SEAS_PRORATE_CD    = :J4-SEAS-PRORATE-CD           
              WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO       = :WS-RATE-PLAN-NO              
              AND    VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     11350357
MFA-TR*       UPDATE CSS_RATE_VRSN_DEF                                  11350457
MFA-TR*       SET    LIM_PRO_RATE_CC    = :J4-LIM-PRO-RATE-CC           11350665
MFA-TR*             ,SEAS_PRORATE_CD    = :J4-SEAS-PRORATE-CD           11350757
MFA-TR*       WHERE  CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE            11351157
MFA-TR*       AND    RATE_PLAN_NO       = :WS-RATE-PLAN-NO              11351257
MFA-TR*       AND    VERSION_NO_CNTRL   = :WS-VERSION-NO-CNTRL          11351357
MFA-TR*       QUERYNO 8130                                              11351357
MFA-TR*    END-EXEC.                                                    11351457

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_VRSN_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11641013
      * 8400-INSERT-RTDESC                                            * 11650057
      *     INSERTS CSS_RATE_PLAN_DESC                                * 11656057
      ***************************************************************** 11660013
                                                                        
       8400-INSERT-RTDESC.                                              
                                                                        
           MOVE PARM-SENIOR-RATE-FL          TO RD-SENIOR-RATE-FL.      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_PLAN_DESC                            
                    (CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,COMPANY_NO                                         
                    ,RATE_DESC                                          
                    ,SECURED_RATE_FL                                    
                    ,SUM_REVENUE_FL                                     
                    ,UNMTR_PROV_FL                                      
                    ,REG_GROUP_CD                                       
                    ,BILL_LITERAL_TX                                    
                    ,DEFERRED_COG_FL                                    
                    ,MKT_PROGRAM_CD                                     
                    ,RATE_CALC_TYPE_CD                                  
                    ,RATE_DEFINITION_CD                                 
                    ,RATE_DEPT_CD                                       
                    ,REV_CUST_COUNT_CD                                  
                    ,SENIOR_RATE_FL                                     
                    ,LAST_UPDATE_USERID                                 
                    ,LAST_UPDATE_TS                                     
                    ,DISPLAY_START_TS                                   
                    ,DISPLAY_END_TS                                     
                    ,CODE_SERVICE_TYPE)                                 
              VALUES                                                    
                   (:WS-CODE-UTIL-TYPE                                  
                   ,:WS-RATE-PLAN-NO                                    
                   ,:WS-COMPANY-NO                                      
                   ,:RD-RATE-DESC                                       
                   ,:RD-SECURED-RATE-FL                                 
                   ,:RD-SUM-REVENUE-FL                                  
                   ,:RD-UNMTR-PROV-FL                                   
                   ,:RD-REG-GROUP-CD                                    
                   ,:RD-BILL-LITERAL-TX                                 
                   ,:RD-DEFERRED-COG-FL                                 
                   ,:RD-MKT-PROGRAM-CD                                  
                   ,:RD-RATE-CALC-TYPE-CD                               
                   ,:RD-RATE-DEFINITION-CD                              
                   ,:RD-RATE-DEPT-CD                                    
                   ,:RD-REV-CUST-COUNT-CD                               
                   ,:RD-SENIOR-RATE-FL                                  
                   ,:RD-LAST-UPDATE-USERID                              
                   ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)                   
                   ,CIS.CHAR2TIMESTAMP(:RD-DISPLAY-START-TS)                    
                   ,CIS.CHAR2TIMESTAMP(:RD-DISPLAY-END-TS)                      
                   ,:RD-CODE-SERVICE-TYPE)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11700013
MFA-TR*       INSERT INTO CSS_RATE_PLAN_DESC                            11710057
MFA-TR*             (CODE_UTIL_TYPE                                     11722056
MFA-TR*             ,RATE_PLAN_NO                                       11723019
MFA-TR*             ,COMPANY_NO                                         11723019
MFA-TR*             ,RATE_DESC                                          11725057
MFA-TR*             ,SECURED_RATE_FL                                    11740057
MFA-TR*             ,SUM_REVENUE_FL                                     11740057
MFA-TR*             ,UNMTR_PROV_FL                                              
MFA-TR*             ,REG_GROUP_CD                                               
MFA-TR*             ,BILL_LITERAL_TX                                            
MFA-TR*             ,DEFERRED_COG_FL                                            
MFA-TR*             ,MKT_PROGRAM_CD                                             
MFA-TR*             ,RATE_CALC_TYPE_CD                                          
MFA-TR*             ,RATE_DEFINITION_CD                                         
MFA-TR*             ,RATE_DEPT_CD                                               
MFA-TR*             ,REV_CUST_COUNT_CD                                          
MFA-TR*             ,SENIOR_RATE_FL                                             
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,DISPLAY_START_TS                                           
MFA-TR*             ,DISPLAY_END_TS                                             
MFA-TR*             ,CODE_SERVICE_TYPE)                                         
MFA-TR*       VALUES                                                    11790013
MFA-TR*            (:WS-CODE-UTIL-TYPE                                  11792057
MFA-TR*            ,:WS-RATE-PLAN-NO                                    11793057
MFA-TR*            ,:WS-COMPANY-NO                                      11793057
MFA-TR*            ,:RD-RATE-DESC                                       11800057
MFA-TR*            ,:RD-SECURED-RATE-FL                                 11820057
MFA-TR*            ,:RD-SUM-REVENUE-FL                                  11820057
MFA-TR*            ,:RD-UNMTR-PROV-FL                                           
MFA-TR*            ,:RD-REG-GROUP-CD                                            
MFA-TR*            ,:RD-BILL-LITERAL-TX                                         
MFA-TR*            ,:RD-DEFERRED-COG-FL                                         
MFA-TR*            ,:RD-MKT-PROGRAM-CD                                          
MFA-TR*            ,:RD-RATE-CALC-TYPE-CD                                       
MFA-TR*            ,:RD-RATE-DEFINITION-CD                                      
MFA-TR*            ,:RD-RATE-DEPT-CD                                            
MFA-TR*            ,:RD-REV-CUST-COUNT-CD                                       
MFA-TR*            ,:RD-SENIOR-RATE-FL                                          
MFA-TR*            ,:RD-LAST-UPDATE-USERID                                      
MFA-TR*            ,:WS-CURRENT-TIMESTAMP                                       
MFA-TR*            ,:RD-DISPLAY-START-TS                                        
MFA-TR*            ,:RD-DISPLAY-END-TS                                          
MFA-TR*            ,:RD-CODE-SERVICE-TYPE)                                      
MFA-TR*    END-EXEC.                                                    11870013

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE WS-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12541057
      * 8410-INSERT-RTCRTR                                            * 12542057
      *     INSERTS CSS_RATE_CREATOR                                  * 12548057
      ***************************************************************** 12549057
                                                                        
       8410-INSERT-RTCRTR.                                              
                                                                        
           MOVE PARM-SEASONAL-DEP-IND        TO RT-SEASONAL-DEP-IND.    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_CREATOR                              
                    (CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,VERSION_NO_CNTRL                                   
                    ,CODE_STATUS                                        
                    ,DATE_CREATED                                       
                    ,FROM_EFFECTIVE_DT                                  
                    ,USER_ID                                            
                    ,BILL_FORMAT_CD                                     
                    ,SEASONAL_DEP_IND                                   
                    ,BASE_LOAD_THERMS                                   
                    ,HEAT_SENSITIVE_FAC                                 
                    ,VERS_PRORATE_CD                                    
                    ,SEASNAL_BLK_CHG_CD                                 
                    ,LAST_UPDATE_USERID                                 
                    ,LAST_UPDATE_TS                                     
                    ,DISPLAY_START_TS                                   
                    ,DISPLAY_END_TS                                     
                    ,PROC_REQ_ID)                                       
              VALUES                                                    
                   (:WS-CODE-UTIL-TYPE                                  
                   ,:WS-RATE-PLAN-NO                                    
                   ,:WS-VERSION-NO-CNTRL                                
                   ,:RT-CODE-STATUS                                     
                   , CAST(SYSDATETIMEOFFSET() AS DATE)                          
                   ,IIF(TRY_CONVERT(DATE, :WS-TOMORROW
              ) IS NULL OR (PATINDEX('%.%', :WS-TOMORROW
              ) <> 0) OR (LEN(:WS-TOMORROW) <> 10), CIS.CHAR2DATE(
                                                           :WS-TOMORROW
              ), CONVERT(DATE, :WS-TOMORROW) )                                 
                   ,:RT-USER-ID                                         
                   ,:RT-BILL-FORMAT-CD                                  
                   ,:RT-SEASONAL-DEP-IND :WS-SEASONAL-DEP-IND-NULL       
                   ,:RT-BASE-LOAD-THERMS                                
                   ,:RT-HEAT-SENSITIVE-FAC                              
                   ,:RT-VERS-PRORATE-CD                                 
                   ,:RT-SEASNAL-BLK-CHG-CD                              
                   ,:RT-LAST-UPDATE-USERID                              
                   ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)                   
                   ,CIS.CHAR2TIMESTAMP(:RT-DISPLAY-START-TS)                    
                   ,CIS.CHAR2TIMESTAMP(:RT-DISPLAY-END-TS)                      
                   ,:RT-PROC-REQ-ID)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     12549657
MFA-TR*       INSERT INTO CSS_RATE_CREATOR                              12549757
MFA-TR*             (CODE_UTIL_TYPE                                     12549857
MFA-TR*             ,RATE_PLAN_NO                                       12549957
MFA-TR*             ,VERSION_NO_CNTRL                                   12550057
MFA-TR*             ,CODE_STATUS                                        12550157
MFA-TR*             ,DATE_CREATED                                       12550257
MFA-TR*             ,FROM_EFFECTIVE_DT                                  12550357
MFA-TR*             ,USER_ID                                            12550457
MFA-TR*             ,BILL_FORMAT_CD                                             
MFA-TR*             ,SEASONAL_DEP_IND                                           
MFA-TR*             ,BASE_LOAD_THERMS                                           
MFA-TR*             ,HEAT_SENSITIVE_FAC                                         
MFA-TR*             ,VERS_PRORATE_CD                                            
MFA-TR*             ,SEASNAL_BLK_CHG_CD                                         
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,DISPLAY_START_TS                                           
MFA-TR*             ,DISPLAY_END_TS                                             
MFA-TR*             ,PROC_REQ_ID)                                               
MFA-TR*       VALUES                                                    12550757
MFA-TR*            (:WS-CODE-UTIL-TYPE                                  12550857
MFA-TR*            ,:WS-RATE-PLAN-NO                                    12550957
MFA-TR*            ,:WS-VERSION-NO-CNTRL                                12551057
MFA-TR*            ,:RT-CODE-STATUS                                     12551157
MFA-TR*            , CURRENT DATE                                       12551257
MFA-TR*            ,:WS-TOMORROW                                        12551368
MFA-TR*            ,:RT-USER-ID                                         12551457
MFA-TR*            ,:RT-BILL-FORMAT-CD                                          
MFA-TR*            ,:RT-SEASONAL-DEP-IND:WS-SEASONAL-DEP-IND-NULL               
MFA-TR*            ,:RT-BASE-LOAD-THERMS                                        
MFA-TR*            ,:RT-HEAT-SENSITIVE-FAC                                      
MFA-TR*            ,:RT-VERS-PRORATE-CD                                         
MFA-TR*            ,:RT-SEASNAL-BLK-CHG-CD                                      
MFA-TR*            ,:RT-LAST-UPDATE-USERID                                      
MFA-TR*            ,:WS-CURRENT-TIMESTAMP                                       
MFA-TR*            ,:RT-DISPLAY-START-TS                                        
MFA-TR*            ,:RT-DISPLAY-END-TS                                          
MFA-TR*            ,:RT-PROC-REQ-ID)                                            
MFA-TR*    END-EXEC.                                                    12551757

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8410'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'FROM_EFFECTIVE_DT'       TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE WS-TOMORROW               TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12554157
      * 8420-INSERT-RTUSES                                            * 12554257
      *     INSERTS CSS_RATE_USE_SEASN                                * 12554857
      ***************************************************************** 12554957
                                                                        
       8420-INSERT-RTUSES.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_USE_SEASN                            
                    (CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,VERSION_NO_CNTRL                                   
                    ,CODE_USE_INST_TYPE                                 
                    ,CODE_SEASON                                        
                    ,DATE_FROM                                          
                    ,DATE_TO)                                           
              VALUES                                                    
                   (:WS-CODE-UTIL-TYPE                                  
                   ,:WS-RATE-PLAN-NO                                    
                   ,:WS-VERSION-NO-CNTRL                                
                   ,:RS-CODE-USE-INST-TYPE                              
                   ,:RS-CODE-SEASON                                     
                   ,:RS-DATE-FROM                                       
                   ,:RS-DATE-TO)                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8420'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_USE_SEASN'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CODE_USE_INST_TYPE'      TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RS-CODE-USE-INST-TYPE     TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12560157
      * 8430-INSERT-RTVRSN                                            * 12560257
      *     INSERTS CSS_RATE_VRSN_DEF.                                * 12560857
      ***************************************************************** 12560957
                                                                        
       8430-INSERT-RTVRSN.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_VRSN_DEF                             
                    (CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,VERSION_NO_CNTRL                                   
                    ,AMT_CUST_CHRG                                      
                    ,LIM_PRO_RATE_CC                                    
                    ,SEAS_PRORATE_CD)                                   
              VALUES                                                    
                   (:WS-CODE-UTIL-TYPE                                  
                   ,:WS-RATE-PLAN-NO                                    
                   ,:WS-VERSION-NO-CNTRL                                
                   ,0                                                   
                   ,:J4-LIM-PRO-RATE-CC                                 
                   ,:J4-SEAS-PRORATE-CD)                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8430'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_VRSN_DEF'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8500-DELETE-RATE-CREATOR                                       *        
      *     DELETES THE RATE CREATOR                                   *        
      ******************************************************************        
                                                                        
       8500-DELETE-RATE-CREATOR.                                        
                                                                        
           EXEC SQL                                                     
              DELETE                                                    
              FROM CSS_RATE_CREATOR                                     
              WHERE CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE               
              AND   RATE_PLAN_NO     = :WS-RATE-PLAN-NO                 
              AND   VERSION_NO_CNTRL = :WS-VERSION-NO-CNTRL             
              AND   CODE_STATUS      = 'T'                              
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE                                                            
MFA-TR*       FROM CSS_RATE_CREATOR                                             
MFA-TR*       WHERE CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE                       
MFA-TR*       AND   RATE_PLAN_NO     = :WS-RATE-PLAN-NO                         
MFA-TR*       AND   VERSION_NO_CNTRL = :WS-VERSION-NO-CNTRL                     
MFA-TR*       AND   CODE_STATUS      = 'T'                                      
MFA-TR*       QUERYNO 8500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_CREATOR'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'CODE_STATUS'             TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE WS-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE 'T'                       TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8510-DELETE-BTU-WNA-RNGE.                                      *        
      *     DELETES BTU WNA RANGE                                      *        
      ******************************************************************        
       8510-DELETE-BTU-WNA-RNGE.                                        
                                                                        
               EXEC SQL                                                 
                 DELETE FROM CSS_BTU_WNA_RANGE                          
                  WHERE CODE_UTIL_TYPE = :BR-CODE-UTIL-TYPE             
                    AND RATE_PLAN_NO   = :BR-RATE-PLAN-NO               
                                                            
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*        EXEC SQL                                                         
MFA-TR*          DELETE FROM CSS_BTU_WNA_RANGE                                  
MFA-TR*           WHERE CODE_UTIL_TYPE = :BR-CODE-UTIL-TYPE                     
MFA-TR*             AND RATE_PLAN_NO   = :BR-RATE-PLAN-NO                       
MFA-TR*          QUERYNO 8510                                                   
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '8510'                TO ACTIVE-PARAGRAPH        
                  MOVE 'DELETE'              TO ABEND-FUNCTION          
                  MOVE 'CSS_BTU_WNA_RANGE'   TO TABLE-1                 
                  MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1         
                  MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2         
                  MOVE 'EFFECTIVE_DT'        TO TABLE-ELEMENT-3         
                  MOVE SA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
                  MOVE SA-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2       
                  MOVE BR-EFFECTIVE-DT       TO HOSTVAR-ELEMENT-3       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF.                                                  
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8520-DELETE-SPCL-FCTR.                                         *        
      *     DELETES SPECIAL FACTOR                                     *        
      ******************************************************************        
       8520-DELETE-SPCL-FCTR.                                           
                                                                        
               EXEC SQL                                                 
                 DELETE FROM CSS_SPCL_FCTR_APPL                         
                  WHERE CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE             
                    AND RATE_PLAN_NO   = :SA-RATE-PLAN-NO               
                                                            
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*        EXEC SQL                                                         
MFA-TR*          DELETE FROM CSS_SPCL_FCTR_APPL                                 
MFA-TR*           WHERE CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                     
MFA-TR*             AND RATE_PLAN_NO   = :SA-RATE-PLAN-NO                       
MFA-TR*          QUERYNO 8520                                                   
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '8520'                TO ACTIVE-PARAGRAPH        
                  MOVE 'DELETE'              TO ABEND-FUNCTION          
                  MOVE 'CSS_SPCL_FCTR_APPL'  TO TABLE-1                 
                  MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1         
                  MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2         
                  MOVE 'DATE_FROM'           TO TABLE-ELEMENT-3         
                  MOVE SA-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
                  MOVE SA-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2       
                  MOVE SA-DATE-FROM          TO HOSTVAR-ELEMENT-3       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF.                                                  
                                                                        
       8520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8530-DELETE-RATE-HI-LOW.                                                
      *     DELETES RATE HIGH LOW                                      *        
      ******************************************************************        
       8530-DELETE-RATE-HI-LOW.                                         
                                                                        
               EXEC SQL                                                 
                 DELETE FROM CSS_RATE_HIGH_LOW                          
                  WHERE CODE_UTIL_TYPE     = :O9-CODE-UTIL-TYPE         
                    AND RATE_PLAN_NO       = :O9-RATE-PLAN-NO           
                                                            
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*        EXEC SQL                                                         
MFA-TR*          DELETE FROM CSS_RATE_HIGH_LOW                                  
MFA-TR*           WHERE CODE_UTIL_TYPE     = :O9-CODE-UTIL-TYPE                 
MFA-TR*             AND RATE_PLAN_NO       = :O9-RATE-PLAN-NO                   
MFA-TR*           QUERYNO 8530                                                  
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '8530'                TO ACTIVE-PARAGRAPH        
                  MOVE 'DELETE'              TO ABEND-FUNCTION          
                  MOVE 'CSS_RATE_HIGH_LOW'   TO TABLE-1                 
                  MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1         
                  MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2         
                  MOVE O9-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
                  MOVE O9-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF.                                                  
                                                                        
       8530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8540-DELETE-DTM-PGM-ID.                                        *        
      *     DELETES DMT PROGRAM ID                                     *        
      ******************************************************************        
       8540-DELETE-DTM-PGM-ID.                                          
                                                                        
               EXEC SQL                                                 
                 DELETE FROM CSS_DMT_PGM_ID                             
                  WHERE CODE_UTIL_TYPE     = :T2-CODE-UTIL-TYPE         
                    AND RATE_PLAN_NO       = :T2-RATE-PLAN-NO           
                                                            
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*        EXEC SQL                                                         
MFA-TR*          DELETE FROM CSS_DMT_PGM_ID                                     
MFA-TR*           WHERE CODE_UTIL_TYPE     = :T2-CODE-UTIL-TYPE                 
MFA-TR*             AND RATE_PLAN_NO       = :T2-RATE-PLAN-NO                   
MFA-TR*           QUERYNO 8540                                                  
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '8540'                TO ACTIVE-PARAGRAPH        
                  MOVE 'DELETE'              TO ABEND-FUNCTION          
                  MOVE 'CSS_DMT_PGM_ID'      TO TABLE-1                 
                  MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1         
                  MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2         
                  MOVE T2-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
                  MOVE T2-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF.                                                  
                                                                        
       8540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8550-DELETE-REV-CLS-RATE.                                      *        
      *     DELETES REVENUE CLASS RATE                                 *        
      ******************************************************************        
       8550-DELETE-REV-CLS-RATE.                                        
                                                                        
               EXEC SQL                                                 
                 DELETE FROM CSS_REV_CLS_RATE                           
                  WHERE CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE         
                    AND RATE_PLAN_NO       = :Q8-RATE-PLAN-NO           
                                                            
               END-EXEC                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*        EXEC SQL                                                         
MFA-TR*          DELETE FROM CSS_REV_CLS_RATE                                   
MFA-TR*           WHERE CODE_UTIL_TYPE     = :Q8-CODE-UTIL-TYPE                 
MFA-TR*             AND RATE_PLAN_NO       = :Q8-RATE-PLAN-NO                   
MFA-TR*           QUERYNO 8550                                                  
MFA-TR*        END-EXEC                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE   
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND  
                  CONTINUE                                              
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '8550'                TO ACTIVE-PARAGRAPH        
                  MOVE 'DELETE'              TO ABEND-FUNCTION          
                  MOVE 'CSS_REV_CLS_RATE'    TO TABLE-1                 
                  MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1         
                  MOVE 'RATE_PLAN_NO'        TO TABLE-ELEMENT-2         
                  MOVE Q8-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1       
                  MOVE Q8-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2       
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF.                                                  
                                                                        
       8550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8560-DELETE-RATE-PLAN-DESC                                     *        
      *     DELETES THE RATE PLAN - IF THE LAST VERSION WAS DELETED    *        
      ******************************************************************        
       8560-DELETE-RATE-PLAN-DESC.                                      
                                                                        
           EXEC SQL                                                     
              DELETE                                                    
              FROM CSS_RATE_PLAN_DESC                                   
              WHERE CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE               
              AND   RATE_PLAN_NO     = :WS-RATE-PLAN-NO                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE                                                            
MFA-TR*       FROM CSS_RATE_PLAN_DESC                                           
MFA-TR*       WHERE CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE                       
MFA-TR*       AND   RATE_PLAN_NO     = :WS-RATE-PLAN-NO                         
MFA-TR*       QUERYNO 8560                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8560'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
