       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     CSR04454.                                        
       AUTHOR.         MS93554.                                         
COB303 DATE-WRITTEN.   MARCH 20, 2012.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00000100
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000200
      *                                                                *00000200
      *     CSR04454 CLONED FROM SP CSR02235 ON 03/20/2012.             00000300
      *     FOR RATE MANAGEMENT MODULE.                                 00000400
      *                                                                *00000500
      ******************************************************************00000600
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  TO RETRIEVE RATE PLAN VERSIONS FROM CSS_RATE_CREATOR  TO      *        
      *  POPULATE RATE MANAGEMENT MODULE.                              *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             COMPANY_NO                 CHAR(02)                *        
      *             CODE_UTIL_TYPE             CHAR(01)                *        
      *             RATE_PLAN_NO               CHAR(03)                *        
      *             CODE_STATUS                CHAR(01)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  ------------------                                            *        
      *             RETURN_CODE                INTEGER                 *        
      *             APPL_RETURN_CODE           INTEGER                 *        
      *             COMPANY_NO                 CHAR(02)                         
      *             CODE_UTIL_TYPE             CHAR(01)                *        
      *             RATE_PLAN_NO               CHAR(03)                *        
      *             VERSION_NO_CNTRL           SMALLINT                *        
      *             CODE_STATUS                CHAR(1)                 *        
      *             DATE_CREATED               CHAR(10)                *        
      *             FROM_EFFECTIVE_DT          CHAR(10)                *        
      *             USER_ID                    CHAR(07)                *        
      *             UNMETER_FL                 CHAR(01)                *        
      *             VERS_PRORATE_CD            CHAR(01)                *        
      *             CODE_SERVICE_TYPE          CHAR(01)                         
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS    COMMENTS                                *        
      *  --------  --------    ----------------------------            *        
      *  03/20/12   MS93554    NEW PROGRAM                             *        
      *  06/19/12   AW41078    ADDED CODE_SERVICE_TYPE TO RESULT SET   *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04454'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04454 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR   RT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC RD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04454'.      
           05 WS-YES                   PIC X(01) VALUE 'Y'.             
           05 WS-NO                    PIC X(01) VALUE 'N'.             
           05 GTT-NAME                 PIC X(26)                        
                                            VALUE 'SESSION.CSR04454_R1'.
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  MISC-FIELD.                                                  
           05  WS-CHK-ALL-STAT         PIC X(01) VALUE 'Y'.             
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
                49 GTT-ROW-LEN         PIC S9(04) COMP.                 
                49 GTT-ROW-CHAR        PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(9) COMP VALUE 0.          
           05  S-COMPANY-NO            PIC X(02).                       
           05  S-CODE-UTIL-TYPE        PIC X(01).                       
           05  S-RATE-PLAN-NO          PIC X(03).                       
           05  S-VERSION-NO-CNTRL      PIC S9(4) COMP.                  
           05  S-CODE-STATUS           PIC X(1)  VALUE SPACES.          
           05  S-DATE-CREATED          PIC X(10) VALUE SPACES.          
           05  S-FROM-EFFECTIVE-DT     PIC X(10) VALUE SPACES.          
           05  S-USER-ID               PIC X(07) VALUE SPACES.          
           05  S-UNMETER-FL            PIC X(1)  VALUE SPACES.          
           05  S-VERS-PRORATE-CD       PIC X(1)  VALUE SPACES.          
           05  S-CODE-SERVICE-TYPE     PIC X(1)  VALUE SPACES.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    CURSOR TO FETCH RATE PLAN VERSIONS FROM CSS_RATE_CREATOR    *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE RATE_CREATOR_CUR CURSOR FOR                      
                SELECT  RD.COMPANY_NO                                   
                       ,RT.CODE_UTIL_TYPE                               
                       ,RT.RATE_PLAN_NO                                 
                       ,RT.VERSION_NO_CNTRL                             
                       ,RT.CODE_STATUS                                  
                       ,CIS.CHAR2$DATE(RT.DATE_CREATED,'USA')                 
                       ,CIS.CHAR2$DATE(RT.FROM_EFFECTIVE_DT,'USA')            
                       ,RT.USER_ID                                      
                       ,RT.VERS_PRORATE_CD                              
                       ,RD.UNMTR_PROV_FL                                
                       ,RD.CODE_SERVICE_TYPE                            
                  FROM  CSS_RATE_CREATOR     RT WITH(READUNCOMMITTED)           
                       ,CSS_RATE_PLAN_DESC   RD WITH(READUNCOMMITTED)           
                WHERE   RT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE          
                   AND  RT.RATE_PLAN_NO    = RD.RATE_PLAN_NO            
                   AND  RD.COMPANY_NO      = :RD-COMPANY-NO             
                   AND  RT.CODE_UTIL_TYPE  = :RT-CODE-UTIL-TYPE         
                   AND  RT.RATE_PLAN_NO    = :RT-RATE-PLAN-NO           
                   AND  ( :WS-CHK-ALL-STAT = 'Y'  OR                    
                        ( :WS-CHK-ALL-STAT = 'N' AND                    
                           RT.CODE_STATUS  = :RT-CODE-STATUS ))         
                   ORDER BY RT.VERSION_NO_CNTRL DESC                    
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_CREATOR_CUR CURSOR FOR                              
MFA-TR*         SELECT  RD.COMPANY_NO                                           
MFA-TR*                ,RT.CODE_UTIL_TYPE                                       
MFA-TR*                ,RT.RATE_PLAN_NO                                         
MFA-TR*                ,RT.VERSION_NO_CNTRL                                     
MFA-TR*                ,RT.CODE_STATUS                                          
MFA-TR*                ,CHAR(DATE(RT.DATE_CREATED),USA)                         
MFA-TR*                ,CHAR(DATE(RT.FROM_EFFECTIVE_DT),USA)                    
MFA-TR*                ,RT.USER_ID                                              
MFA-TR*                ,RT.VERS_PRORATE_CD                                      
MFA-TR*                ,RD.UNMTR_PROV_FL                                        
MFA-TR*                ,RD.CODE_SERVICE_TYPE                                    
MFA-TR*           FROM  CSS_RATE_CREATOR     RT                                 
MFA-TR*                ,CSS_RATE_PLAN_DESC   RD                                 
MFA-TR*         WHERE   RT.CODE_UTIL_TYPE  = RD.CODE_UTIL_TYPE                  
MFA-TR*            AND  RT.RATE_PLAN_NO    = RD.RATE_PLAN_NO                    
MFA-TR*            AND  RD.COMPANY_NO      = :RD-COMPANY-NO                     
MFA-TR*            AND  RT.CODE_UTIL_TYPE  = :RT-CODE-UTIL-TYPE                 
MFA-TR*            AND  RT.RATE_PLAN_NO    = :RT-RATE-PLAN-NO                   
MFA-TR*            AND  ( :WS-CHK-ALL-STAT = 'Y'  OR                            
MFA-TR*                 ( :WS-CHK-ALL-STAT = 'N' AND                            
MFA-TR*                    RT.CODE_STATUS  = :RT-CODE-STATUS ))                 
MFA-TR*            ORDER BY RT.VERSION_NO_CNTRL DESC                            
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-COMPANY-NO          PIC X(02).                          
       01  PARM-CODE-UTIL-TYPE      PIC X(01).                          
       01  PARM-RATE-PLAN-NO        PIC X(03).                          
       01  PARM-CODE-STATUS         PIC X(01).                          
                                                                        
       PROCEDURE DIVISION  USING PARM-COMPANY-NO                        
                                ,PARM-CODE-UTIL-TYPE                    
                                ,PARM-RATE-PLAN-NO                      
                                ,PARM-CODE-STATUS.                      
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04454_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04454_R1
              (                                                        
                 RETURN_CODE                INT                     
                ,APPL_RETURN_CODE           INT                     
                ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2           
                ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
                ,RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,VERSION_NO_CNTRL           SMALLINT                    
                ,CODE_STATUS CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
                ,DATE_CREATED CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
                ,FROM_EFFECTIVE_DT CHAR(10)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
                ,USER_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2              
                ,UNMETER_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
                ,VERS_PRORATE_CD CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
                ,CODE_SERVICE_TYPE CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                    
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT RETURN_CODE              AS RETURN_CODE           
                     ,APPL_RETURN_CODE         AS APPL_RETURN_CODE      
                     ,LTRIM(RTRIM(COMPANY_NO))        AS COMPANY_NO            
                     ,LTRIM(RTRIM(CODE_UTIL_TYPE))    AS CODE_UTIL_TYPE        
                     ,LTRIM(RTRIM(RATE_PLAN_NO))      AS RATE_PLAN_NO          
                     ,VERSION_NO_CNTRL         AS VERSION_NO_CNTRL      
                     ,LTRIM(RTRIM(CODE_STATUS))       AS CODE_STATUS           
                     ,LTRIM(RTRIM(DATE_CREATED))      AS DATE_CREATED          
                     ,LTRIM(RTRIM(FROM_EFFECTIVE_DT)) AS 
           FROM_EFFECTIVE_DT     
                     ,LTRIM(RTRIM(USER_ID))           AS USER_ID               
                     ,LTRIM(RTRIM(UNMETER_FL))        AS UNMETER_FL            
                     ,VERS_PRORATE_CD          AS VERS_PRORATE_CD       
                     ,LTRIM(RTRIM(CODE_SERVICE_TYPE)) AS 
           CODE_SERVICE_TYPE     
               FROM #CSR04454_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT RETURN_CODE              AS RETURN_CODE           00000400
MFA-TR*              ,APPL_RETURN_CODE         AS APPL_RETURN_CODE              
MFA-TR*              ,STRIP(COMPANY_NO)        AS COMPANY_NO                    
MFA-TR*              ,STRIP(CODE_UTIL_TYPE)    AS CODE_UTIL_TYPE                
MFA-TR*              ,STRIP(RATE_PLAN_NO)      AS RATE_PLAN_NO                  
MFA-TR*              ,VERSION_NO_CNTRL         AS VERSION_NO_CNTRL           000
MFA-TR*              ,STRIP(CODE_STATUS)       AS CODE_STATUS                000
MFA-TR*              ,STRIP(DATE_CREATED)      AS DATE_CREATED               000
MFA-TR*              ,STRIP(FROM_EFFECTIVE_DT) AS FROM_EFFECTIVE_DT          000
MFA-TR*              ,STRIP(USER_ID)           AS USER_ID                    000
MFA-TR*              ,STRIP(UNMETER_FL)        AS UNMETER_FL                 000
MFA-TR*              ,VERS_PRORATE_CD          AS VERS_PRORATE_CD            000
MFA-TR*              ,STRIP(CODE_SERVICE_TYPE) AS CODE_SERVICE_TYPE             
MFA-TR*        FROM SESSION.CSR04454_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-COMPANY-NO       TO RD-COMPANY-NO.                 
           MOVE PARM-CODE-UTIL-TYPE   TO RT-CODE-UTIL-TYPE.             
           MOVE PARM-RATE-PLAN-NO     TO RT-RATE-PLAN-NO.               
           MOVE PARM-CODE-STATUS      TO RT-CODE-STATUS.                
                                                                        
           IF RT-CODE-STATUS > SPACES                                   
              MOVE WS-NO           TO WS-CHK-ALL-STAT                   
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-NO         TO WS-NO-MORE-ROWS.                       
                                                                        
           PERFORM 7100-OPEN-RATE-CREATOR-CUR     THRU 7100-EXIT        
           PERFORM 7200-FETCH-RATE-CREATOR-CUR    THRU 7200-EXIT        
           PERFORM 2100-RATE-CREATOR-PROCESS      THRU 2100-EXIT        
                                                     UNTIL NO-MORE-ROWS 
           PERFORM 7300-CLOSE-RATE-CREATOR-CUR    THRU 7300-EXIT        
                                                                        
           IF CTR-ROWS EQUAL ZERO                                       
              MOVE 100                         TO S-RETURN-CODE         
              MOVE   0                         TO S-APPL-RETURN-CODE    
              PERFORM 8100-SEND-RESULT            THRU 8100-EXIT        
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-RATE-CREATOR-PROCESS.                               *              
      ******************************************************************        
       2100-RATE-CREATOR-PROCESS.                                       
                                                                        
           MOVE RD-COMPANY-NO            TO S-COMPANY-NO.               
           MOVE RT-CODE-UTIL-TYPE        TO S-CODE-UTIL-TYPE.           
           MOVE RT-RATE-PLAN-NO          TO S-RATE-PLAN-NO.             
           MOVE RT-VERSION-NO-CNTRL      TO S-VERSION-NO-CNTRL.         
           MOVE RT-CODE-STATUS           TO S-CODE-STATUS.              
           MOVE RT-DATE-CREATED          TO S-DATE-CREATED.             
           MOVE RT-FROM-EFFECTIVE-DT     TO S-FROM-EFFECTIVE-DT.        
           MOVE RT-USER-ID               TO S-USER-ID.                  
           MOVE RD-UNMTR-PROV-FL         TO S-UNMETER-FL.               
           MOVE RT-VERS-PRORATE-CD       TO S-VERS-PRORATE-CD.          
           MOVE RD-CODE-SERVICE-TYPE     TO S-CODE-SERVICE-TYPE.        
                                                                        
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
           PERFORM 7200-FETCH-RATE-CREATOR-CUR THRU 7200-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-RATE-CREATOR-CUR.                                         *        
      ******************************************************************        
       7100-OPEN-RATE-CREATOR-CUR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN RATE_CREATOR_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'CODE_STATUS'              TO TABLE-ELEMENT-3        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
              MOVE RT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE RT-CODE-STATUS             TO HOSTVAR-ELEMENT-3      
              MOVE RD-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-FETCH-RATE-CREATOR-CUR.                                   *        
      ******************************************************************        
       7200-FETCH-RATE-CREATOR-CUR.                                     
                                                                        
           EXEC SQL                                                     
              FETCH RATE_CREATOR_CUR                                    
               INTO :RD-COMPANY-NO                                      
                   ,:RT-CODE-UTIL-TYPE                                  
                   ,:RT-RATE-PLAN-NO                                    
                   ,:RT-VERSION-NO-CNTRL                                
                   ,:RT-CODE-STATUS                                     
                   ,:RT-DATE-CREATED                                    
                   ,:RT-FROM-EFFECTIVE-DT                               
                   ,:RT-USER-ID                                         
                   ,:RT-VERS-PRORATE-CD                                 
                   ,:RD-UNMTR-PROV-FL                                   
                   ,:RD-CODE-SERVICE-TYPE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES                     TO WS-NO-MORE-ROWS  
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME               TO ABEND-PROGRAM    
                    MOVE '7200'                     TO ACTIVE-PARAGRAPH 
                    MOVE 'FETCH'                    TO ABEND-FUNCTION   
                    MOVE 'CSS_RATE_CREATOR'         TO TABLE-1          
                    MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1  
                    MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2  
                    MOVE 'CODE_STATUS'              TO TABLE-ELEMENT-3  
                    MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4  
                    MOVE RT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1
                    MOVE RT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2
                    MOVE RT-CODE-STATUS             TO HOSTVAR-ELEMENT-3
                    MOVE RD-COMPANY-NO              TO HOSTVAR-ELEMENT-4
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-CLOSE-RATE-CREATOR-CUR.                                   *        
      ******************************************************************        
       7300-CLOSE-RATE-CREATOR-CUR.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE RATE_CREATOR_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'CODE_STATUS'              TO TABLE-ELEMENT-3        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
              MOVE RT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE RT-CODE-STATUS             TO HOSTVAR-ELEMENT-3      
              MOVE RD-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04454_R1                           
                (                                                       
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,CODE_UTIL_TYPE                                       
                  ,RATE_PLAN_NO                                         
                  ,VERSION_NO_CNTRL                                     
                  ,CODE_STATUS                                          
                  ,DATE_CREATED                                         
                  ,FROM_EFFECTIVE_DT                                    
                  ,USER_ID                                              
                  ,UNMETER_FL                                           
                  ,VERS_PRORATE_CD                                      
                  ,CODE_SERVICE_TYPE                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-COMPANY-NO                                        
                  ,:S-CODE-UTIL-TYPE                                    
                  ,:S-RATE-PLAN-NO                                      
                  ,:S-VERSION-NO-CNTRL                                  
                  ,:S-CODE-STATUS                                       
                  ,:S-DATE-CREATED                                      
                  ,:S-FROM-EFFECTIVE-DT                                 
                  ,:S-USER-ID                                           
                  ,:S-UNMETER-FL                                        
                  ,:S-VERS-PRORATE-CD                                   
                  ,:S-CODE-SERVICE-TYPE                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04454_R1                                   
MFA-TR*         (                                                               
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,VERSION_NO_CNTRL                                             
MFA-TR*           ,CODE_STATUS                                                  
MFA-TR*           ,DATE_CREATED                                                 
MFA-TR*           ,FROM_EFFECTIVE_DT                                            
MFA-TR*           ,USER_ID                                                      
MFA-TR*           ,UNMETER_FL                                                   
MFA-TR*           ,VERS_PRORATE_CD                                              
MFA-TR*           ,CODE_SERVICE_TYPE                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-COMPANY-NO                                                
MFA-TR*           ,:S-CODE-UTIL-TYPE                                            
MFA-TR*           ,:S-RATE-PLAN-NO                                              
MFA-TR*           ,:S-VERSION-NO-CNTRL                                          
MFA-TR*           ,:S-CODE-STATUS                                               
MFA-TR*           ,:S-DATE-CREATED                                              
MFA-TR*           ,:S-FROM-EFFECTIVE-DT                                         
MFA-TR*           ,:S-USER-ID                                                   
MFA-TR*           ,:S-UNMETER-FL                                                
MFA-TR*           ,:S-VERS-PRORATE-CD                                           
MFA-TR*           ,:S-CODE-SERVICE-TYPE                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04454_R1'         TO  TABLE-1                    
              MOVE 'RATE_PLAN_NO'        TO  TABLE-ELEMENT-1            
              MOVE 'CODE_UTUL_TYPE'      TO  TABLE-ELEMENT-2            
              MOVE 'CODE_STATUS'         TO  TABLE-ELEMENT-3            
              MOVE 'COMPNAY_NO'          TO  TABLE-ELEMENT-4            
              MOVE RT-RATE-PLAN-NO       TO  HOSTVAR-ELEMENT-1          
              MOVE RT-CODE-UTIL-TYPE     TO  HOSTVAR-ELEMENT-2          
              MOVE RT-CODE-STATUS        TO  HOSTVAR-ELEMENT-3          
              MOVE RD-COMPANY-NO         TO  HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04454_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04454_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04454_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
                                                                        
