       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04452.                                      
       AUTHOR.           MS93554.                                       
COB303 DATE-WRITTEN.     JAN 20, 2012.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *        CSR04452 CLONED FROM SP CSR02218 ON 01/20/2012.                  
      *        FOR RATE MANAGEMENT MODULE.                                      
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES RATE PLAN DESC, RATE PLAN VERSION AND  *        
      *  RATE USE SEASON DETAILS DESCRIBED BY THE KEY THAT IT RECEIVES *        
      *  AS PARAMETERS.                                                *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             CODE_UTIL_TYPE             CHAR(01)                *        
      *             RATE_PLAN_NO               CHAR(03)                *        
      *             VERSION_NO_CNTRL           SMALLINT                *        
      *             PROC_REQ_ID                CHAR(10)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -----------------                                             *        
      *             RETURN_CODE                INTEGER                 *        
      *             APPL_RETURN_CODE           INTEGER                 *        
      *             CODE_UTIL_TYPE             CHAR(01)                *        
      *             RATE_PLAN_NO               CHAR(03)                *        
      *             VERSION_NO_CNTRL           INTEGER                 *        
      *             RATE_DESC                  CHAR(50)                *        
      *             VERS_PRORATE_CD            CHAR(01)                *        
      *             CODE_STATUS                CHAR(01)                *        
      *             SEAS_PRORATE_CD            CHAR(01)                *        
      *             DATE_FROM                  INTEGER                 *        
      *             DATE_TO                    INTEGER                 *        
      *             BILL_FORMAT_CD             CHAR(02)                *        
      *             COMPANY_NO                 CHAR(02)                *        
      *             SECURED_RATE_FL            CHAR(01)                *        
      *             INACTIVATE_FL              CHAR(01)                *        
      *             SUM_REVENUE_FL             CHAR(01)                *        
      *             SEASONAL_DEP_IND           CHAR(01)                *        
      *             BASE_LOAD_THERM            DECIMAL                 *        
      *             HEAT_SENSITIVE_FAC         INTEGER                 *        
      *             REG_GROUP_CD               CHAR(03)                *        
      *             BILL_LITERAL_TX            CHAR(50)                *        
      *             SENIOR_RATE_FL             CHAR(01)                *        
      *             MKT_PROGRAM_CD             CHAR(02)                *        
      *             RATE_CALC_TYPE_CD          CHAR(02)                *        
      *             UNMETER_FL                 CHAR(01)                *        
      *             START_TS                   CHAR(26)                *        
      *             END_TS                     CHAR(26)                *        
      *             SEASNAL_BLK_CHG_CD         CHAR(01)                *        
      *             DEFERRED_COG_FL            CHAR(01)                *        
      *             RATE_DEFINITION_CD         CHAR(01)                *        
      *             ACTIVE_RT_UPD_FL           CHAR(01)                *        
      *             RATE_EFF_DATE              CHAR(10)                *        
      *             RATE_VER_DISP_STRT_TS      CHAR(26)                *        
      *             RATE_VER_DISP_END_TS       CHAR(26)                *        
      *             USER_ID                    CHAR(07)                *        
      *             RATE_DEPT_CD               CHAR(03)                *        
      *             REV_CUST_COUNT_CD          CHAR(01)                *        
      *             CODE_SERVICE_TYPE          CHAR(01)                *        
      *             PROC_REQ_ID                CHAR(10)                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *  --------    --------   ------------------------------         *        
      *  01-20-2012  MS93554    NEW PROGRAM                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04452'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04452 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_PLAN_DESC   RD                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR     RT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_VRSN_DEF    J4                                              
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTVRSN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_USE_SEASN   RS                                              
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTUSES                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_JOB_PARM, G6                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                       
      ******************************************************************        
           COPY CWS00027.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04452'.      
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-GTT-NAME             PIC X(19) VALUE SPACES.          
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME               PIC X(26)                        
                                       VALUE 'SESSION.CSR04452_R1'.     
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN         PIC S9(04) COMP.                 
                49 GTT-ROW-CHAR        PIC X(1024).                     
            05  GTT-SQLCODE            PIC S9(9) COMP.                  
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-NULL-INDICATOR       PIC S9(4) USAGE COMP.            
           05  WS-NULL-INDICATOR1      PIC S9(4) USAGE COMP.            
           05  WS-NULL-IND2            PIC S9(4) USAGE COMP.            
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(9) COMP VALUE 0.          
           05  S-CODE-UTIL-TYPE        PIC X(1)  VALUE SPACE.           
           05  S-RATE-PLAN-NO          PIC X(3)  VALUE SPACE.           
           05  S-VERSION-NO-CNTRL      PIC S9(4) USAGE COMP.            
           05  S-RATE-DESC             PIC X(50) VALUE SPACE.           
           05  S-VERS-PRORATE-CD       PIC X(1)  VALUE SPACE.           
           05  S-CODE-STATUS           PIC X(1)  VALUE SPACE.           
           05  S-SEAS-PRORATE-CD       PIC X(1)  VALUE SPACE.           
           05  S-FROM-DATE             PIC S9(4) USAGE COMP.            
           05  S-TO-DATE               PIC S9(4) USAGE COMP.            
           05  S-BILL-FORMAT-CD        PIC X(2)  VALUE SPACES.          
           05  S-COMPANY-NO            PIC X(02) VALUE SPACES.          
           05  S-SECURED-RATE-FL       PIC X(01) VALUE SPACES.          
           05  S-INACTIVATE-FL         PIC X(01) VALUE SPACES.          
           05  S-SUM-REVENUE-FL        PIC X(01) VALUE SPACES.          
           05  S-SEASONAL-DEP-IND      PIC X(01) VALUE SPACES.          
           05  S-BASE-LOAD-THERMS      PIC S9(4)V9(5) VALUE 0 COMP-3.   
           05  S-HEAT-SENSITIVE-FAC    PIC SV9(5) VALUE 0 COMP-3.       
           05  S-REG-GROUP-CD          PIC X(03) VALUE SPACES.          
           05  S-BILL-LITERAL-TX.                                       
               49 S-BILL-LITERAL-TX-LEN  PIC S9(4) USAGE COMP.          
               49 S-BILL-LITERAL-TX-TEXT PIC X(50).                     
           05  S-SENIOR-RATE-FL        PIC X(01) VALUE SPACE.           
           05  S-MKT-PROGRAM-CD        PIC X(02) VALUE SPACE.           
           05  S-RATE-CALC-TYPE-CD     PIC X(02) VALUE SPACE.           
           05  S-UNMETER-FL            PIC X(01) VALUE SPACE.           
           05  S-DISPLAY-START-TS      PIC X(26) VALUE SPACE.           
           05  S-DISPLAY-END-TS        PIC X(26) VALUE SPACE.           
           05  S-SEASNAL-BLK-CHG-CD    PIC X(01) VALUE SPACE.           
           05  S-DEFERRED-COG-FL       PIC X(01) VALUE SPACE.           
           05  S-RATE-DEFINITION-CD    PIC X(01) VALUE SPACE.           
           05  S-ACTIVE-RT-UPD-FLAG    PIC X(01) VALUE SPACE.           
           05  S-RATE-EFF-DATE         PIC X(10) VALUE SPACE.           
           05  S-RATE-VER-DISP-STRT-TS PIC X(26) VALUE SPACES.          
           05  S-RATE-VER-DISP-END-TS  PIC X(26) VALUE SPACES.          
           05  S-USER-ID               PIC X(07) VALUE SPACES.          
           05  S-RATE-DEPT-CD          PIC X(03) VALUE SPACE.           
           05  S-REV-CUST-COUNT-CD     PIC X(01) VALUE SPACE.           
           05  S-CODE-SERVICE-TYPE     PIC X(01) VALUE SPACE.           
           05  S-PROC-REQ-ID           PIC X(10) VALUE SPACE.           
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-CODE-UTIL-TYPE       PIC X(1)   VALUE SPACE.          
           05  WS-RATE-PLAN-NO         PIC X(3)   VALUE SPACE.          
           05  WS-VERSION-NO-CNTRL     PIC S9(4)  USAGE COMP.           
           05  WS-MAX-VER-NO-CNTRL     PIC S9(4)  USAGE COMP.           
COB305     05 WS-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-UNMETERED            PIC X(01)  VALUE 'U'.            
                                                                        
       01  SWITCHES.                                                    
           05  CSR04452-DONE-SW        PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-CODE-UTIL-TYPE     PIC X(1).                            
       01  PARM-RATE-PLAN-NO       PIC X(3).                            
       01  PARM-VERSION-NO-CNTRL   PIC S9(4) USAGE COMP.                
       01  PARM-PROC-REQ-ID        PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING PARM-CODE-UTIL-TYPE                     
                                PARM-RATE-PLAN-NO                       
                                PARM-VERSION-NO-CNTRL                   
                                PARM-PROC-REQ-ID.                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE            AS RETURN_CODE         
                     ,:S-APPL-RETURN-CODE        AS APPL_RETURN_CODE    
                     ,LTRIM(RTRIM(:S-CODE-UTIL-TYPE))   AS 
           CODE_UTIL_TYPE      
                     ,LTRIM(RTRIM(:S-RATE-PLAN-NO))     AS RATE_PLAN_NO        
                     ,:S-VERSION-NO-CNTRL        AS VERSION_NO_CNTRL    
                     ,LTRIM(RTRIM(:S-RATE-DESC))        AS RATE_DESC           
                     ,LTRIM(RTRIM(:S-VERS-PRORATE-CD))  AS 
           VERS_PRORATE_CD     
                     ,LTRIM(RTRIM(:S-CODE-STATUS))      AS CODE_STATUS         
                     ,:S-SEAS-PRORATE-CD         AS SEAS_PRORATE_CD     
                     ,:S-FROM-DATE               AS DATE_FROM           
                     ,:S-TO-DATE                 AS DATE_TO             
                     ,LTRIM(RTRIM(:S-BILL-FORMAT-CD))   AS 
           BILL_FORMAT_CD      
                     ,LTRIM(RTRIM(:S-COMPANY-NO))       AS COMPANY_NO          
                     ,LTRIM(RTRIM(:S-SECURED-RATE-FL))  AS 
           SECURED_RATE_FL     
                     ,LTRIM(RTRIM(:S-INACTIVATE-FL))    AS INACTIVATE_FL       
                     ,LTRIM(RTRIM(:S-SUM-REVENUE-FL))   AS 
           SUM_REVENUE_FL      
                     ,LTRIM(RTRIM(:S-SEASONAL-DEP-IND)) AS 
           SEASONAL_DEP_IND    
                     ,:S-BASE-LOAD-THERMS        AS BASE_LOAD_THERM     
                     ,:S-HEAT-SENSITIVE-FAC      AS HEAT_SENSITIVE_FAC  
                     ,LTRIM(RTRIM(:S-REG-GROUP-CD))     AS REG_GROUP_CD        
                     ,LTRIM(RTRIM(:S-BILL-LITERAL-TX))  AS 
           BILL_LITERAL_TX     
                     ,LTRIM(RTRIM(:S-SENIOR-RATE-FL))   AS 
           SENIOR_RATE_FL      
                     ,LTRIM(RTRIM(:S-MKT-PROGRAM-CD))   AS  
           MKT_PROGRAM_CD     
                     ,LTRIM(RTRIM(:S-RATE-CALC-TYPE-CD)) AS 
           RATE_CALC_TYPE_CD  
                     ,LTRIM(RTRIM(:S-UNMETER-FL))       AS UNMETER_FL          
                     ,LTRIM(RTRIM(:S-DISPLAY-START-TS)) AS 
           DISPLAY_START_TS    
                     ,LTRIM(RTRIM(:S-DISPLAY-END-TS))   AS 
           DISPLAY_END_TS      
                     ,LTRIM(RTRIM(:S-SEASNAL-BLK-CHG-CD)) AS 
           SEASNAL_BLK_CHG_CD
                     ,LTRIM(RTRIM(:S-DEFERRED-COG-FL))  AS 
           DEFERRED_COG_FL     
                     ,LTRIM(RTRIM(:S-RATE-DEFINITION-CD)) AS 
           RATE_DEFINITION_CD
                     ,LTRIM(RTRIM(:S-ACTIVE-RT-UPD-FLAG)) AS 
           ACTIVE_RT_UPD_FL  
                     ,LTRIM(RTRIM(:S-RATE-EFF-DATE))    AS RATE_EFF_DATE       
                     ,LTRIM(RTRIM(:S-RATE-VER-DISP-STRT-TS)) AS                
                                                  RATE_VER_DISP_STRT_TS 
                     ,LTRIM(RTRIM(:S-RATE-VER-DISP-END-TS)) AS                 
                                                  RATE_VER_DISP_END_TS  
                     ,LTRIM(RTRIM(:S-USER-ID))          AS USER_ID             
                     ,LTRIM(RTRIM(:S-RATE-DEPT-CD))     AS RATE_DEPT_CD        
                     ,LTRIM(RTRIM(:S-REV-CUST-COUNT-CD)) AS 
           REV_CUST_COUNT_CD  
                     ,LTRIM(RTRIM(:S-CODE-SERVICE-TYPE)) AS 
           CODE_SERVICE_TYPE  
                     ,LTRIM(RTRIM(:S-PROC-REQ-ID))      AS PROC_REQ_ID         
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE            AS RETURN_CODE                 
MFA-TR*              ,:S-APPL-RETURN-CODE        AS APPL_RETURN_CODE            
MFA-TR*              ,STRIP(:S-CODE-UTIL-TYPE)   AS CODE_UTIL_TYPE              
MFA-TR*              ,STRIP(:S-RATE-PLAN-NO)     AS RATE_PLAN_NO                
MFA-TR*              ,:S-VERSION-NO-CNTRL        AS VERSION_NO_CNTRL            
MFA-TR*              ,STRIP(:S-RATE-DESC)        AS RATE_DESC                   
MFA-TR*              ,STRIP(:S-VERS-PRORATE-CD)  AS VERS_PRORATE_CD             
MFA-TR*              ,STRIP(:S-CODE-STATUS)      AS CODE_STATUS                 
MFA-TR*              ,:S-SEAS-PRORATE-CD         AS SEAS_PRORATE_CD             
MFA-TR*              ,:S-FROM-DATE               AS DATE_FROM                   
MFA-TR*              ,:S-TO-DATE                 AS DATE_TO                     
MFA-TR*              ,STRIP(:S-BILL-FORMAT-CD)   AS BILL_FORMAT_CD              
MFA-TR*              ,STRIP(:S-COMPANY-NO)       AS COMPANY_NO                  
MFA-TR*              ,STRIP(:S-SECURED-RATE-FL)  AS SECURED_RATE_FL             
MFA-TR*              ,STRIP(:S-INACTIVATE-FL)    AS INACTIVATE_FL               
MFA-TR*              ,STRIP(:S-SUM-REVENUE-FL)   AS SUM_REVENUE_FL              
MFA-TR*              ,STRIP(:S-SEASONAL-DEP-IND) AS SEASONAL_DEP_IND            
MFA-TR*              ,:S-BASE-LOAD-THERMS        AS BASE_LOAD_THERM             
MFA-TR*              ,:S-HEAT-SENSITIVE-FAC      AS HEAT_SENSITIVE_FAC          
MFA-TR*              ,STRIP(:S-REG-GROUP-CD)     AS REG_GROUP_CD                
MFA-TR*              ,STRIP(:S-BILL-LITERAL-TX)  AS BILL_LITERAL_TX             
MFA-TR*              ,STRIP(:S-SENIOR-RATE-FL)   AS SENIOR_RATE_FL              
MFA-TR*              ,STRIP(:S-MKT-PROGRAM-CD)   AS  MKT_PROGRAM_CD             
MFA-TR*              ,STRIP(:S-RATE-CALC-TYPE-CD) AS RATE_CALC_TYPE_CD          
MFA-TR*              ,STRIP(:S-UNMETER-FL)       AS UNMETER_FL                  
MFA-TR*              ,STRIP(:S-DISPLAY-START-TS) AS DISPLAY_START_TS            
MFA-TR*              ,STRIP(:S-DISPLAY-END-TS)   AS DISPLAY_END_TS              
MFA-TR*              ,STRIP(:S-SEASNAL-BLK-CHG-CD) AS SEASNAL_BLK_CHG_CD        
MFA-TR*              ,STRIP(:S-DEFERRED-COG-FL)  AS DEFERRED_COG_FL             
MFA-TR*              ,STRIP(:S-RATE-DEFINITION-CD) AS RATE_DEFINITION_CD        
MFA-TR*              ,STRIP(:S-ACTIVE-RT-UPD-FLAG) AS ACTIVE_RT_UPD_FL          
MFA-TR*              ,STRIP(:S-RATE-EFF-DATE)    AS RATE_EFF_DATE               
MFA-TR*              ,STRIP(:S-RATE-VER-DISP-STRT-TS) AS                        
MFA-TR*                                           RATE_VER_DISP_STRT_TS         
MFA-TR*              ,STRIP(:S-RATE-VER-DISP-END-TS) AS                         
MFA-TR*                                           RATE_VER_DISP_END_TS          
MFA-TR*              ,STRIP(:S-USER-ID)          AS USER_ID                     
MFA-TR*              ,STRIP(:S-RATE-DEPT-CD)     AS RATE_DEPT_CD                
MFA-TR*              ,STRIP(:S-REV-CUST-COUNT-CD) AS REV_CUST_COUNT_CD          
MFA-TR*              ,STRIP(:S-CODE-SERVICE-TYPE) AS CODE_SERVICE_TYPE          
MFA-TR*              ,STRIP(:S-PROC-REQ-ID)      AS PROC_REQ_ID                 
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CODE-UTIL-TYPE      TO WS-CODE-UTIL-TYPE.          
           MOVE PARM-RATE-PLAN-NO        TO WS-RATE-PLAN-NO.            
           MOVE PARM-VERSION-NO-CNTRL    TO WS-VERSION-NO-CNTRL.        
           MOVE PARM-PROC-REQ-ID         TO WS-PROC-REQ-ID.             
                                                                        
      *    IF VALUE PASSED FOR PROC_REQ_ID PARAMETER THEN IGNORE                
      *    OTHER PARAMETERS AND RETRIEVE RATE VERSION WITH MATCH ON             
      *    CSS_RATE_CREATOR.PROC_REQ_ID.                                        
           IF WS-PROC-REQ-ID > 0                                        
              MOVE WS-PROC-REQ-ID        TO RT-PROC-REQ-ID              
              PERFORM 7400-GET-RATE-PLAN-NO THRU 7400-EXIT              
              MOVE RT-CODE-UTIL-TYPE     TO WS-CODE-UTIL-TYPE           
              MOVE RT-RATE-PLAN-NO       TO WS-RATE-PLAN-NO             
              MOVE RT-VERSION-NO-CNTRL   TO WS-VERSION-NO-CNTRL         
           END-IF.                                                      
                                                                        
           MOVE WS-CODE-UTIL-TYPE        TO RT-CODE-UTIL-TYPE           
                                            RS-CODE-UTIL-TYPE           
                                            J4-CODE-UTIL-TYPE.          
           MOVE WS-RATE-PLAN-NO          TO RT-RATE-PLAN-NO             
                                            RS-RATE-PLAN-NO             
                                            J4-RATE-PLAN-NO.            
           MOVE WS-VERSION-NO-CNTRL      TO RT-VERSION-NO-CNTRL         
                                            RS-VERSION-NO-CNTRL         
                                            J4-VERSION-NO-CNTRL.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
           ADD 1                           TO CTR-ROWS.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
      *    IF UNMETERED THEN FIND INFO FROM CSS_RATE_PLAN_DESC                  
      *    AND CSS_RATE_CREATOR.                                                
           IF WS-CODE-UTIL-TYPE EQUAL WS-UNMETERED                      
              PERFORM 7200-SELECT-UNMETERED-DEF  THRU 7200-EXIT         
           ELSE                                                         
              PERFORM 7100-SELECT-RATE-VRSN-DEF  THRU 7100-EXIT         
              PERFORM 7000-SELECT-RATE-USE-SEASN THRU 7000-EXIT         
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE RS-DATE-TO            TO S-TO-DATE                
                 MOVE RS-DATE-FROM          TO S-FROM-DATE              
              ELSE                                                      
                 MOVE ZEROES                TO S-TO-DATE                
                 MOVE ZEROES                TO S-FROM-DATE              
                 MOVE ZEROES                TO WS-ACTIVE-RETURN-CODE    
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 5100-GET-ACTV-RT-UPD-FLAG THRU 5100-EXIT          
              PERFORM 7300-SELECT-UNMETER-FLAG  THRU 7300-EXIT          
              PERFORM 2300-MOVE-RESULT-SET      THRU 2300-EXIT          
           EXIT
           END-IF.                                                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-MOVE-RESULT-SET.                                                   
      ******************************************************************        
       2300-MOVE-RESULT-SET.                                            
                                                                        
           MOVE WS-CODE-UTIL-TYPE        TO S-CODE-UTIL-TYPE            
           MOVE WS-RATE-PLAN-NO          TO S-RATE-PLAN-NO              
           MOVE WS-VERSION-NO-CNTRL      TO S-VERSION-NO-CNTRL          
           MOVE RD-RATE-DESC             TO S-RATE-DESC                 
           MOVE RD-BILL-LITERAL-TX       TO S-BILL-LITERAL-TX           
           MOVE RD-SENIOR-RATE-FL        TO S-SENIOR-RATE-FL            
           MOVE RD-MKT-PROGRAM-CD        TO S-MKT-PROGRAM-CD            
           MOVE RD-RATE-CALC-TYPE-CD     TO S-RATE-CALC-TYPE-CD         
           MOVE RD-RATE-DEFINITION-CD    TO S-RATE-DEFINITION-CD        
           MOVE RD-RATE-DEPT-CD          TO S-RATE-DEPT-CD              
           MOVE RD-REV-CUST-COUNT-CD     TO S-REV-CUST-COUNT-CD         
           MOVE RD-DISPLAY-START-TS      TO S-DISPLAY-START-TS          
           MOVE RD-DISPLAY-END-TS        TO S-DISPLAY-END-TS            
           MOVE RT-DISPLAY-START-TS      TO S-RATE-VER-DISP-STRT-TS     
           MOVE RT-DISPLAY-END-TS        TO S-RATE-VER-DISP-END-TS      
           MOVE RT-USER-ID               TO S-USER-ID                   
           MOVE RT-VERS-PRORATE-CD       TO S-VERS-PRORATE-CD           
           MOVE RD-COMPANY-NO            TO S-COMPANY-NO                
           IF RD-SECURED-RATE-FL = 'Y'                                  
              MOVE RD-SECURED-RATE-FL    TO S-SECURED-RATE-FL           
           ELSE                                                         
              MOVE 'N'                   TO S-SECURED-RATE-FL           
           END-IF                                                       
           IF RD-SUM-REVENUE-FL = 'Y'                                   
              MOVE RD-SUM-REVENUE-FL     TO S-SUM-REVENUE-FL            
           ELSE                                                         
              MOVE 'N'                   TO S-SUM-REVENUE-FL            
           END-IF                                                       
P00473*    IF RD-REG-GROUP-CD = SPACES                                          
P00473*       MOVE 'NON'                 TO S-REG-GROUP-CD                      
P00473*    ELSE                                                                 
              MOVE RD-REG-GROUP-CD       TO S-REG-GROUP-CD              
P00473*    END-IF                                                               
                                                                        
           MOVE RT-CODE-STATUS           TO S-CODE-STATUS               
           MOVE RT-BILL-FORMAT-CD        TO S-BILL-FORMAT-CD            
           MOVE RT-BASE-LOAD-THERMS      TO S-BASE-LOAD-THERMS          
           MOVE RT-HEAT-SENSITIVE-FAC    TO S-HEAT-SENSITIVE-FAC        
           MOVE 'Y'                      TO S-INACTIVATE-FL             
                                                                        
           IF WS-CODE-UTIL-TYPE = 'U'                                   
              MOVE SPACES                TO S-SEAS-PRORATE-CD           
              MOVE ZEROES                TO S-FROM-DATE                 
              MOVE ZEROES                TO S-TO-DATE                   
           ELSE                                                         
              MOVE J4-SEAS-PRORATE-CD    TO S-SEAS-PRORATE-CD           
           END-IF                                                       
                                                                        
           MOVE RT-FROM-EFFECTIVE-DT     TO S-RATE-EFF-DATE             
           MOVE RD-CODE-SERVICE-TYPE     TO S-CODE-SERVICE-TYPE         
           MOVE RT-PROC-REQ-ID           TO S-PROC-REQ-ID               
           MOVE RD-UNMTR-PROV-FL         TO S-UNMETER-FL                
           MOVE RD-DEFERRED-COG-FL       TO S-DEFERRED-COG-FL.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5100-GET-ACTV-RT-UPD-FLAG.                                     *        
      ******************************************************************        
       5100-GET-ACTV-RT-UPD-FLAG.                                       
                                                                        
           MOVE 'N'                          TO S-ACTIVE-RT-UPD-FLAG.   
           MOVE 'PANEL395'                   TO G6-PROGRAM-NAME.        
           MOVE '01'                         TO G6-COMPANY-NO.          
           MOVE 'PARM'                       TO G6-CMND-CODE.           
           MOVE +01                          TO G6-SEQ-NO.              
           MOVE 'A'                          TO G6-STATUS.              
                                                                        
           PERFORM 7310-SELECT-JOB-PARM         THRU 7310-EXIT.         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                          AND G6-PARM-DATA(1:3) EQUAL WS-RATE-PLAN-NO   
              PERFORM 7320-GET-MAX-VRSN-NO-CNTRL THRU 7320-EXIT         
              IF WS-MAX-VER-NO-CNTRL EQUAL WS-VERSION-NO-CNTRL          
                 MOVE 'Y'                  TO S-ACTIVE-RT-UPD-FLAG      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-RATE-USE-SEASN                                     *        
      ******************************************************************        
       7000-SELECT-RATE-USE-SEASN.                                      
                                                                        
           EXEC SQL                                                     
              SELECT RS.DATE_TO                                         
                    ,RS.DATE_FROM                                       
                INTO :RS-DATE-TO                                        
                    ,:RS-DATE-FROM                                      
                FROM CSS_RATE_USE_SEASN RS WITH(READUNCOMMITTED)                
               WHERE RS.CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE           
                 AND RS.RATE_PLAN_NO     = :RS-RATE-PLAN-NO             
                 AND RS.VERSION_NO_CNTRL = :RS-VERSION-NO-CNTRL         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RS.DATE_TO                                                 
MFA-TR*             ,RS.DATE_FROM                                               
MFA-TR*         INTO :RS-DATE-TO                                                
MFA-TR*             ,:RS-DATE-FROM                                              
MFA-TR*         FROM CSS_RATE_USE_SEASN RS                                      
MFA-TR*        WHERE RS.CODE_UTIL_TYPE   = :RS-CODE-UTIL-TYPE                   
MFA-TR*          AND RS.RATE_PLAN_NO     = :RS-RATE-PLAN-NO                     
MFA-TR*          AND RS.VERSION_NO_CNTRL = :RS-VERSION-NO-CNTRL                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_USE_SEASN'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-RATE-VRSN-DEF                                      *        
      ******************************************************************        
       7100-SELECT-RATE-VRSN-DEF.                                       
                                                                        
           EXEC SQL                                                     
              SELECT J4.SEAS_PRORATE_CD,                                
                     RD.RATE_DESC,                                      
                     RT.VERS_PRORATE_CD,                                
                     RD.COMPANY_NO,                                     
                     RD.SECURED_RATE_FL,                                
                     RD.SUM_REVENUE_FL,                                 
                     RT.CODE_STATUS,                                    
                     RT.BILL_FORMAT_CD,                                 
                     RT.SEASONAL_DEP_IND,                               
                     RT.BASE_LOAD_THERMS,                               
                     RT.HEAT_SENSITIVE_FAC,                             
                     RD.REG_GROUP_CD,                                   
                     RD.BILL_LITERAL_TX,                                
                     RD.SENIOR_RATE_FL,                                 
                     RD.MKT_PROGRAM_CD,                                 
                     RD.RATE_CALC_TYPE_CD,                              
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           RD.DISPLAY_START_TS, 121), ' ', '-'), ':', '.') 
           DISPLAY_START_TS,                               
                     REPLACE(REPLACE(CONVERT(CHAR(26), RD.DISPLAY_END_TS
           , 121), ' ', '-'), ':', '.') DISPLAY_END_TS,                        
                     RT.SEASNAL_BLK_CHG_CD,                             
                     RD.DEFERRED_COG_FL,                                
                     RD.RATE_DEFINITION_CD,                             
                     RD.RATE_DEPT_CD,                                   
                     RD.REV_CUST_COUNT_CD,                              
                     RD.CODE_SERVICE_TYPE,                              
                     RT.FROM_EFFECTIVE_DT,                              
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           RT.DISPLAY_START_TS, 121), ' ', '-'), ':', '.') 
           DISPLAY_START_TS,                               
                     REPLACE(REPLACE(CONVERT(CHAR(26), RT.DISPLAY_END_TS
           , 121), ' ', '-'), ':', '.') DISPLAY_END_TS,                        
                     RT.USER_ID,                                        
                     RT.PROC_REQ_ID                                     
              INTO  :J4-SEAS-PRORATE-CD,                                
                    :RD-RATE-DESC,                                      
                    :RT-VERS-PRORATE-CD,                                
                    :RD-COMPANY-NO,                                     
                    :RD-SECURED-RATE-FL,                                
                    :RD-SUM-REVENUE-FL,                                 
                    :RT-CODE-STATUS,                                    
                    :RT-BILL-FORMAT-CD,                                 
                    :RT-SEASONAL-DEP-IND :WS-NULL-INDICATOR,            
                    :RT-BASE-LOAD-THERMS,                               
                    :RT-HEAT-SENSITIVE-FAC,                             
                    :RD-REG-GROUP-CD,                                   
                    :RD-BILL-LITERAL-TX,                                
                    :RD-SENIOR-RATE-FL,                                 
                    :RD-MKT-PROGRAM-CD,                                 
                    :RD-RATE-CALC-TYPE-CD,                              
                    :RD-DISPLAY-START-TS,                               
                    :RD-DISPLAY-END-TS,                                 
                    :RT-SEASNAL-BLK-CHG-CD :WS-NULL-INDICATOR1,         
                    :RD-DEFERRED-COG-FL,                                
                    :RD-RATE-DEFINITION-CD,                             
                    :RD-RATE-DEPT-CD,                                   
                    :RD-REV-CUST-COUNT-CD,                              
                    :RD-CODE-SERVICE-TYPE,                              
                    :RT-FROM-EFFECTIVE-DT,                              
                    :RT-DISPLAY-START-TS,                               
                    :RT-DISPLAY-END-TS,                                 
                    :RT-USER-ID,                                        
                    :RT-PROC-REQ-ID                                     
              FROM  CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED),                 
                    CSS_RATE_CREATOR RT WITH(READUNCOMMITTED),                  
                    CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
             WHERE  J4.CODE_UTIL_TYPE     = :J4-CODE-UTIL-TYPE          
               AND  J4.RATE_PLAN_NO       = :J4-RATE-PLAN-NO            
               AND  J4.VERSION_NO_CNTRL   = :J4-VERSION-NO-CNTRL        
               AND  RT.CODE_UTIL_TYPE     =  J4.CODE_UTIL_TYPE          
               AND  RT.RATE_PLAN_NO       =  J4.RATE_PLAN_NO            
               AND  RT.VERSION_NO_CNTRL   =  J4.VERSION_NO_CNTRL        
               AND  RD.CODE_UTIL_TYPE     =  RT.CODE_UTIL_TYPE          
               AND  RD.RATE_PLAN_NO       =  RT.RATE_PLAN_NO            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT J4.SEAS_PRORATE_CD,                                        
MFA-TR*              RD.RATE_DESC,                                              
MFA-TR*              RT.VERS_PRORATE_CD,                                        
MFA-TR*              RD.COMPANY_NO,                                             
MFA-TR*              RD.SECURED_RATE_FL,                                        
MFA-TR*              RD.SUM_REVENUE_FL,                                         
MFA-TR*              RT.CODE_STATUS,                                            
MFA-TR*              RT.BILL_FORMAT_CD,                                         
MFA-TR*              RT.SEASONAL_DEP_IND,                                       
MFA-TR*              RT.BASE_LOAD_THERMS,                                       
MFA-TR*              RT.HEAT_SENSITIVE_FAC,                                     
MFA-TR*              RD.REG_GROUP_CD,                                           
MFA-TR*              RD.BILL_LITERAL_TX,                                        
MFA-TR*              RD.SENIOR_RATE_FL,                                         
MFA-TR*              RD.MKT_PROGRAM_CD,                                         
MFA-TR*              RD.RATE_CALC_TYPE_CD,                                      
MFA-TR*              RD.DISPLAY_START_TS,                                       
MFA-TR*              RD.DISPLAY_END_TS,                                         
MFA-TR*              RT.SEASNAL_BLK_CHG_CD,                                     
MFA-TR*              RD.DEFERRED_COG_FL,                                        
MFA-TR*              RD.RATE_DEFINITION_CD,                                     
MFA-TR*              RD.RATE_DEPT_CD,                                           
MFA-TR*              RD.REV_CUST_COUNT_CD,                                      
MFA-TR*              RD.CODE_SERVICE_TYPE,                                      
MFA-TR*              RT.FROM_EFFECTIVE_DT,                                      
MFA-TR*              RT.DISPLAY_START_TS,                                       
MFA-TR*              RT.DISPLAY_END_TS,                                         
MFA-TR*              RT.USER_ID,                                                
MFA-TR*              RT.PROC_REQ_ID                                             
MFA-TR*       INTO  :J4-SEAS-PRORATE-CD,                                        
MFA-TR*             :RD-RATE-DESC,                                              
MFA-TR*             :RT-VERS-PRORATE-CD,                                        
MFA-TR*             :RD-COMPANY-NO,                                             
MFA-TR*             :RD-SECURED-RATE-FL,                                        
MFA-TR*             :RD-SUM-REVENUE-FL,                                         
MFA-TR*             :RT-CODE-STATUS,                                            
MFA-TR*             :RT-BILL-FORMAT-CD,                                         
MFA-TR*             :RT-SEASONAL-DEP-IND :WS-NULL-INDICATOR,                    
MFA-TR*             :RT-BASE-LOAD-THERMS,                                       
MFA-TR*             :RT-HEAT-SENSITIVE-FAC,                                     
MFA-TR*             :RD-REG-GROUP-CD,                                           
MFA-TR*             :RD-BILL-LITERAL-TX,                                        
MFA-TR*             :RD-SENIOR-RATE-FL,                                         
MFA-TR*             :RD-MKT-PROGRAM-CD,                                         
MFA-TR*             :RD-RATE-CALC-TYPE-CD,                                      
MFA-TR*             :RD-DISPLAY-START-TS,                                       
MFA-TR*             :RD-DISPLAY-END-TS,                                         
MFA-TR*             :RT-SEASNAL-BLK-CHG-CD :WS-NULL-INDICATOR1,                 
MFA-TR*             :RD-DEFERRED-COG-FL,                                        
MFA-TR*             :RD-RATE-DEFINITION-CD,                                     
MFA-TR*             :RD-RATE-DEPT-CD,                                           
MFA-TR*             :RD-REV-CUST-COUNT-CD,                                      
MFA-TR*             :RD-CODE-SERVICE-TYPE,                                      
MFA-TR*             :RT-FROM-EFFECTIVE-DT,                                      
MFA-TR*             :RT-DISPLAY-START-TS,                                       
MFA-TR*             :RT-DISPLAY-END-TS,                                         
MFA-TR*             :RT-USER-ID,                                                
MFA-TR*             :RT-PROC-REQ-ID                                             
MFA-TR*       FROM  CSS_RATE_VRSN_DEF J4,                                       
MFA-TR*             CSS_RATE_CREATOR RT,                                        
MFA-TR*             CSS_RATE_PLAN_DESC RD                                       
MFA-TR*      WHERE  J4.CODE_UTIL_TYPE     = :J4-CODE-UTIL-TYPE                  
MFA-TR*        AND  J4.RATE_PLAN_NO       = :J4-RATE-PLAN-NO                    
MFA-TR*        AND  J4.VERSION_NO_CNTRL   = :J4-VERSION-NO-CNTRL                
MFA-TR*        AND  RT.CODE_UTIL_TYPE     =  J4.CODE_UTIL_TYPE                  
MFA-TR*        AND  RT.RATE_PLAN_NO       =  J4.RATE_PLAN_NO                    
MFA-TR*        AND  RT.VERSION_NO_CNTRL   =  J4.VERSION_NO_CNTRL                
MFA-TR*        AND  RD.CODE_UTIL_TYPE     =  RT.CODE_UTIL_TYPE                  
MFA-TR*        AND  RD.RATE_PLAN_NO       =  RT.RATE_PLAN_NO                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-INDICATOR  EQUAL -1                            
                 MOVE SPACES                  TO S-SEASONAL-DEP-IND     
              ELSE                                                      
                 MOVE RT-SEASONAL-DEP-IND     TO S-SEASONAL-DEP-IND     
              END-IF                                                    
                                                                        
              IF WS-NULL-INDICATOR1 EQUAL -1                            
                 MOVE SPACES                  TO S-SEASNAL-BLK-CHG-CD   
              ELSE                                                      
                 MOVE RT-SEASNAL-BLK-CHG-CD   TO S-SEASNAL-BLK-CHG-CD   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_VRSN_DEF'        TO TABLE-1                
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-2                
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-3                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-UNMETERED-DEF                                      *        
      ******************************************************************        
       7200-SELECT-UNMETERED-DEF.                                       
                                                                        
           EXEC SQL                                                     
              SELECT RD.RATE_DESC,                                      
                     RT.VERS_PRORATE_CD,                                
                     RD.COMPANY_NO,                                     
                     RD.SECURED_RATE_FL,                                
                     RD.SUM_REVENUE_FL,                                 
                     RT.CODE_STATUS,                                    
                     RT.BILL_FORMAT_CD,                                 
                     RT.SEASONAL_DEP_IND,                               
                     RT.BASE_LOAD_THERMS,                               
                     RT.HEAT_SENSITIVE_FAC,                             
                     RD.REG_GROUP_CD,                                   
                     RD.BILL_LITERAL_TX,                                
                     RD.SENIOR_RATE_FL,                                 
                     RD.MKT_PROGRAM_CD,                                 
                     RD.RATE_CALC_TYPE_CD,                              
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           RD.DISPLAY_START_TS, 121), ' ', '-'), ':', '.') 
           DISPLAY_START_TS,                               
                     REPLACE(REPLACE(CONVERT(CHAR(26), RD.DISPLAY_END_TS
           , 121), ' ', '-'), ':', '.') DISPLAY_END_TS,                        
                     RT.SEASNAL_BLK_CHG_CD,                             
                     RD.DEFERRED_COG_FL,                                
                     RD.RATE_DEFINITION_CD,                             
                     RD.RATE_DEPT_CD,                                   
                     RD.REV_CUST_COUNT_CD,                              
                     RD.CODE_SERVICE_TYPE,                              
                     RT.FROM_EFFECTIVE_DT,                              
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           RT.DISPLAY_START_TS, 121), ' ', '-'), ':', '.') 
           DISPLAY_START_TS,                               
                     REPLACE(REPLACE(CONVERT(CHAR(26), RT.DISPLAY_END_TS
           , 121), ' ', '-'), ':', '.') DISPLAY_END_TS,                        
                     RT.PROC_REQ_ID                                     
              INTO  :RD-RATE-DESC,                                      
                    :RT-VERS-PRORATE-CD,                                
                    :RD-COMPANY-NO,                                     
                    :RD-SECURED-RATE-FL,                                
                    :RD-SUM-REVENUE-FL,                                 
                    :RT-CODE-STATUS,                                    
                    :RT-BILL-FORMAT-CD,                                 
                    :RT-SEASONAL-DEP-IND :WS-NULL-INDICATOR,            
                    :RT-BASE-LOAD-THERMS,                               
                    :RT-HEAT-SENSITIVE-FAC,                             
                    :RD-REG-GROUP-CD,                                   
                    :RD-BILL-LITERAL-TX,                                
                    :RD-SENIOR-RATE-FL,                                 
                    :RD-MKT-PROGRAM-CD,                                 
                    :RD-RATE-CALC-TYPE-CD,                              
                    :RD-DISPLAY-START-TS,                               
                    :RD-DISPLAY-END-TS,                                 
                    :RT-SEASNAL-BLK-CHG-CD :WS-NULL-INDICATOR1,         
                    :RD-DEFERRED-COG-FL,                                
                    :RD-RATE-DEFINITION-CD,                             
                    :RD-RATE-DEPT-CD,                                   
                    :RD-REV-CUST-COUNT-CD,                              
                    :RD-CODE-SERVICE-TYPE,                              
                    :RT-FROM-EFFECTIVE-DT,                              
                    :RT-DISPLAY-START-TS,                               
                    :RT-DISPLAY-END-TS,                                 
                    :RT-PROC-REQ-ID                                     
              FROM  CSS_RATE_CREATOR RT WITH(READUNCOMMITTED),                  
                    CSS_RATE_PLAN_DESC RD WITH(READUNCOMMITTED)                 
             WHERE  RT.CODE_UTIL_TYPE      = :RT-CODE-UTIL-TYPE         
               AND  RT.RATE_PLAN_NO        = :RT-RATE-PLAN-NO           
               AND  RT.VERSION_NO_CNTRL    = :RT-VERSION-NO-CNTRL       
               AND  RD.CODE_UTIL_TYPE      =  RT.CODE_UTIL_TYPE         
               AND  RD.RATE_PLAN_NO        =  RT.RATE_PLAN_NO           
                                                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RD.RATE_DESC,                                              
MFA-TR*              RT.VERS_PRORATE_CD,                                        
MFA-TR*              RD.COMPANY_NO,                                             
MFA-TR*              RD.SECURED_RATE_FL,                                        
MFA-TR*              RD.SUM_REVENUE_FL,                                         
MFA-TR*              RT.CODE_STATUS,                                            
MFA-TR*              RT.BILL_FORMAT_CD,                                         
MFA-TR*              RT.SEASONAL_DEP_IND,                                       
MFA-TR*              RT.BASE_LOAD_THERMS,                                       
MFA-TR*              RT.HEAT_SENSITIVE_FAC,                                     
MFA-TR*              RD.REG_GROUP_CD,                                           
MFA-TR*              RD.BILL_LITERAL_TX,                                        
MFA-TR*              RD.SENIOR_RATE_FL,                                         
MFA-TR*              RD.MKT_PROGRAM_CD,                                         
MFA-TR*              RD.RATE_CALC_TYPE_CD,                                      
MFA-TR*              RD.DISPLAY_START_TS,                                       
MFA-TR*              RD.DISPLAY_END_TS,                                         
MFA-TR*              RT.SEASNAL_BLK_CHG_CD,                                     
MFA-TR*              RD.DEFERRED_COG_FL,                                        
MFA-TR*              RD.RATE_DEFINITION_CD,                                     
MFA-TR*              RD.RATE_DEPT_CD,                                           
MFA-TR*              RD.REV_CUST_COUNT_CD,                                      
MFA-TR*              RD.CODE_SERVICE_TYPE,                                      
MFA-TR*              RT.FROM_EFFECTIVE_DT,                                      
MFA-TR*              RT.DISPLAY_START_TS,                                       
MFA-TR*              RT.DISPLAY_END_TS,                                         
MFA-TR*              RT.PROC_REQ_ID                                             
MFA-TR*       INTO  :RD-RATE-DESC,                                              
MFA-TR*             :RT-VERS-PRORATE-CD,                                        
MFA-TR*             :RD-COMPANY-NO,                                             
MFA-TR*             :RD-SECURED-RATE-FL,                                        
MFA-TR*             :RD-SUM-REVENUE-FL,                                         
MFA-TR*             :RT-CODE-STATUS,                                            
MFA-TR*             :RT-BILL-FORMAT-CD,                                         
MFA-TR*             :RT-SEASONAL-DEP-IND :WS-NULL-INDICATOR,                    
MFA-TR*             :RT-BASE-LOAD-THERMS,                                       
MFA-TR*             :RT-HEAT-SENSITIVE-FAC,                                     
MFA-TR*             :RD-REG-GROUP-CD,                                           
MFA-TR*             :RD-BILL-LITERAL-TX,                                        
MFA-TR*             :RD-SENIOR-RATE-FL,                                         
MFA-TR*             :RD-MKT-PROGRAM-CD,                                         
MFA-TR*             :RD-RATE-CALC-TYPE-CD,                                      
MFA-TR*             :RD-DISPLAY-START-TS,                                       
MFA-TR*             :RD-DISPLAY-END-TS,                                         
MFA-TR*             :RT-SEASNAL-BLK-CHG-CD :WS-NULL-INDICATOR1,                 
MFA-TR*             :RD-DEFERRED-COG-FL,                                        
MFA-TR*             :RD-RATE-DEFINITION-CD,                                     
MFA-TR*             :RD-RATE-DEPT-CD,                                           
MFA-TR*             :RD-REV-CUST-COUNT-CD,                                      
MFA-TR*             :RD-CODE-SERVICE-TYPE,                                      
MFA-TR*             :RT-FROM-EFFECTIVE-DT,                                      
MFA-TR*             :RT-DISPLAY-START-TS,                                       
MFA-TR*             :RT-DISPLAY-END-TS,                                         
MFA-TR*             :RT-PROC-REQ-ID                                             
MFA-TR*       FROM  CSS_RATE_CREATOR RT,                                        
MFA-TR*             CSS_RATE_PLAN_DESC RD                                       
MFA-TR*      WHERE  RT.CODE_UTIL_TYPE      = :RT-CODE-UTIL-TYPE                 
MFA-TR*        AND  RT.RATE_PLAN_NO        = :RT-RATE-PLAN-NO                   
MFA-TR*        AND  RT.VERSION_NO_CNTRL    = :RT-VERSION-NO-CNTRL               
MFA-TR*        AND  RD.CODE_UTIL_TYPE      =  RT.CODE_UTIL_TYPE                 
MFA-TR*        AND  RD.RATE_PLAN_NO        =  RT.RATE_PLAN_NO                   
MFA-TR*       WITH  UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-INDICATOR EQUAL -1                             
                 MOVE SPACES                  TO S-SEASONAL-DEP-IND     
              ELSE                                                      
                 MOVE RT-SEASONAL-DEP-IND     TO S-SEASONAL-DEP-IND     
              END-IF                                                    
                                                                        
              IF WS-NULL-INDICATOR1 EQUAL -1                            
                 MOVE SPACES                  TO S-SEASNAL-BLK-CHG-CD   
              ELSE                                                      
                 MOVE RT-SEASNAL-BLK-CHG-CD   TO S-SEASNAL-BLK-CHG-CD   
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-2                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-UNMETER-FLAG                                       *        
      ******************************************************************        
       7300-SELECT-UNMETER-FLAG.                                        
                                                                        
           MOVE SPACES               TO RD-UNMTR-PROV-FL.               
                                                                        
           EXEC SQL                                                     
              SELECT UNMTR_PROV_FL                                      
                INTO :RD-UNMTR-PROV-FL                                  
                FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                   
               WHERE CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE               
                 AND RATE_PLAN_NO    = :WS-RATE-PLAN-NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT UNMTR_PROV_FL                                              
MFA-TR*         INTO :RD-UNMTR-PROV-FL                                          
MFA-TR*         FROM CSS_RATE_PLAN_DESC                                         
MFA-TR*        WHERE CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                       
MFA-TR*          AND RATE_PLAN_NO    = :WS-RATE-PLAN-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7310-SELECT-JOB-PARM.                                          *        
      ******************************************************************        
       7310-SELECT-JOB-PARM.                                            
                                                                        
           EXEC SQL                                                     
              SELECT G6.PARM_DATA                                       
                INTO :G6-PARM-DATA                                      
                FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                      
               WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                 
                 AND G6.COMPANY_NO   = :G6-COMPANY-NO                   
                 AND G6.CMND_CODE    = :G6-CMND-CODE                    
                 AND G6.SEQ_NO       = :G6-SEQ-NO                       
                 AND G6.STATUS       = :G6-STATUS                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT G6.PARM_DATA                                               
MFA-TR*         INTO :G6-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM G6                                            
MFA-TR*        WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                         
MFA-TR*          AND G6.COMPANY_NO   = :G6-COMPANY-NO                           
MFA-TR*          AND G6.CMND_CODE    = :G6-CMND-CODE                            
MFA-TR*          AND G6.SEQ_NO       = :G6-SEQ-NO                               
MFA-TR*          AND G6.STATUS       = :G6-STATUS                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7310'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_JOB_PARM'             TO TABLE-1                
              MOVE 'PROGRAM_NAME'             TO TABLE-ELEMENT-1        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
              MOVE 'CMND_CODE'                TO TABLE-ELEMENT-3        
              MOVE 'SEQ_NO'                   TO TABLE-ELEMENT-4        
              MOVE G6-PROGRAM-NAME            TO HOSTVAR-ELEMENT-1      
              MOVE G6-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
              MOVE G6-CMND-CODE               TO HOSTVAR-ELEMENT-3      
              MOVE G6-SEQ-NO                  TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-GET-MAX-VRSN-NO-CNTRL.                                    *        
      ******************************************************************        
       7320-GET-MAX-VRSN-NO-CNTRL.                                      
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
                INTO :WS-MAX-VER-NO-CNTRL :WS-NULL-IND2                  
                FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                  
               WHERE RT.CODE_UTIL_TYPE   = :RT-CODE-UTIL-TYPE           
                 AND RT.RATE_PLAN_NO     = :RT-RATE-PLAN-NO             
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(VERSION_NO_CNTRL)                                      
MFA-TR*         INTO :WS-MAX-VER-NO-CNTRL:WS-NULL-IND2                          
MFA-TR*         FROM CSS_RATE_CREATOR RT                                        
MFA-TR*        WHERE RT.CODE_UTIL_TYPE   = :RT-CODE-UTIL-TYPE                   
MFA-TR*          AND RT.RATE_PLAN_NO     = :RT-RATE-PLAN-NO                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE RT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-GET-RATE-PLAN-NO.                                         *        
      ******************************************************************        
       7400-GET-RATE-PLAN-NO.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RT.CODE_UTIL_TYPE                                  
                    ,RT.RATE_PLAN_NO                                    
                    ,RT.VERSION_NO_CNTRL                                
                INTO :RT-CODE-UTIL-TYPE                                 
                    ,:RT-RATE-PLAN-NO                                   
                    ,:RT-VERSION-NO-CNTRL                               
                FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                  
               WHERE RT.PROC_REQ_ID    = :RT-PROC-REQ-ID                
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RT.CODE_UTIL_TYPE                                          
MFA-TR*             ,RT.RATE_PLAN_NO                                            
MFA-TR*             ,RT.VERSION_NO_CNTRL                                        
MFA-TR*         INTO :RT-CODE-UTIL-TYPE                                         
MFA-TR*             ,:RT-RATE-PLAN-NO                                           
MFA-TR*             ,:RT-VERSION-NO-CNTRL                                       
MFA-TR*         FROM CSS_RATE_CREATOR RT                                        
MFA-TR*        WHERE RT.PROC_REQ_ID    = :RT-PROC-REQ-ID                        
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'PROC_REQ_ID'              TO TABLE-ELEMENT-1        
              MOVE RT-PROC-REQ-ID             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
