       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04451.                                         
       DATE-WRITTEN.  07/02/2012.                                       
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM WILL BE USED ON RATE MANAGEMENT MODULE. THIS SP  *        
      *  WILL RETRIEVE DATA NEEDED FOR FACTOR PRICING VALIDATION CRYSTAL        
      *  REPORT.                                                       *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00473*  07/02/12  HA7A338    PROCEDURE ORIGINALLY CODED.              *        
P00473*  01/03/13  AW41078    ADDED USE CODE, TIME PERIOD, AND SEASON  *        
P00473*                       TO RESULT SET.                           *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04451'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR CSR04451 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * INCLUDE SQLCA                                                           
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---<CSS_SPCL_FCTR_APPL  SA>                                              
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
                                                                        
      *---<CSS_SPCL_FCTR       SF>                                              
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      *---<CSS_RATE_PLAN_DESC  RD>                                              
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      *---<CSS_USER_PROFILE    PF>                                              
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *---<CSS_PROCESS_REQ     P1>                                              
           EXEC SQL                                                             
              INCLUDE TBPRCREQ                                                  
           END-EXEC.                                                            
                                                                        
      *---<CSS_PROCESS_STATUS  P3>                                              
           EXEC SQL                                                             
              INCLUDE TBPRCSTA                                                  
           END-EXEC.                                                            
                                                                        
      *---<CSS_CODE_VALUE      UV>                                              
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
                                                                        
      *---<CSS_RATE_COMPONENT  N6>                                              
           EXEC SQL                                                             
              INCLUDE TBRTCPNT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SUPPORTS ERROR PROCESSING                                            
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CWSSP001                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                       
      ******************************************************************        
           COPY CWS00027.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WORK-FIELDS.                                                 
COB305     05 SUB1        PIC S9(3) COMP-3 VALUE 0.                
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04451'.      
                                                                        
       01  WS-NULL-IND1                PIC S9(4) COMP VALUE 0.          
       01  WS-NULL-IND2                PIC S9(4) COMP VALUE 0.          
       01  WS-NULL-IND3                PIC S9(4) COMP VALUE 0.          
       01  WS-NULL-IND4                PIC S9(4) COMP VALUE 0.          
       01  WS-BLOCK-NULL-ID            PIC S9(4) COMP VALUE 0.          
                                                                        
      *                                                                 02556000
       01  WS-STORAGE-FIELDS.                                           
           05  WS-INVALID-INPUT.                                        
              10 WS-TEXT               PIC X(14) VALUE 'INVALID INPUT '.
              10 WS-FIELD              PIC X(15) VALUE SPACES.          
              10 WS-VALUE              PIC X(31) VALUE SPACES.          
           05  WS-NO-RECORDS-FOUND     PIC X(60) VALUE                  
              'NO RECORDS FOUND FOR THE GIVEN INPUT'.                   
           05  WS-HARD-ERROR           PIC X(60) VALUE                  
              'ERROR OCCURED. PLEASE CONTACT SYSTEM ADMINISTRATOR'.     
           05  WS-DATE-FROM            PIC X(10) VALUE SPACES.          
           05  WS-INT-DISP-START-TS    PIC X(26) VALUE SPACES.          
           05  WS-LAST-UPDATE-TS       PIC X(26) VALUE SPACES.          
           05  WS-TIMESTAMP            PIC X(26) VALUE SPACES.          
           05  WS-CODE-STATUS          PIC X(01) VALUE SPACES.          
           05  WS-USER-ID-UPD-BY       PIC X(07) VALUE SPACES.          
           05  WS-FULL-NAME            PIC X(50) VALUE SPACES.          
           05  WS-INT-DISP-STRT-DT     PIC X(10) VALUE SPACES.          
           05  WS-INT-DISP-STRT-TM     PIC X(15) VALUE SPACES.          
           05  WS-CODE-STATUS-DESC     PIC X(15) VALUE SPACES.          
           05  WS-VERS-PRORATE-DESC    PIC X(15) VALUE SPACES.          
           05  WS-USE-CODE-DESC        PIC X(15) VALUE SPACES.          
           05  WS-TIME-PERIOD-DESC     PIC X(15) VALUE SPACES.          
           05  WS-SEASON-DESC          PIC X(15) VALUE SPACES.          
           05  WS-PROC-REQ-ID          PIC 9(10) VALUE 0.               
           05  S-FACTOR-DESC           PIC X(60) VALUE SPACES.          
           05  S-RETURN-CODE           PIC S9(9) VALUE 0 COMP.          
      *                                                                 02556000
       01  WS-FILTERS-LITERALS.                                         
           05  WS-STARTDT-FLTR         PIC X(01) VALUE 'N'.             
           05  WS-INTSTARTDT-FLTR      PIC X(01) VALUE 'N'.             
           05  WS-STATUS-FLTR          PIC X(01) VALUE 'N'.             
           05  WS-LASTUPDATEBY-FLTR    PIC X(01) VALUE 'N'.             
           05  WS-LASTUPDTS-FLTR       PIC X(01) VALUE 'N'.             
           05  WS-EXCRATEFCTR-FLTR     PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE               PIC X(01) VALUE 'A'.             
           05  WS-DISP-START-TS-FLD    PIC X(15) VALUE 'DISP-START-TS '.
           05  WS-LAST-UPDATE-TS-FLD   PIC X(15) VALUE 'LAST-UPDATE-TS'.
           05  WS-FROM-DATE            PIC X(15) VALUE 'FROM DATE     '.
      *                                                                         
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-FACTOR-ID              PIC X(09)  VALUE SPACES.        
           05  S-DATE-FROM              PIC X(10)  VALUE SPACES.        
           05  S-DATE-TO                PIC X(10)  VALUE SPACES.        
           05  S-INT-DISP-START-DT      PIC X(10)  VALUE SPACES.        
           05  S-INT-DISP-START-TM      PIC X(15)  VALUE SPACES.        
           05  S-FACTOR                 PIC S9(3)V9(6)   USAGE COMP-3   
                                                   VALUE 0.             
           05  S-RATE-PLAN-NO           PIC X(03)  VALUE SPACES.        
           05  S-RATE-DESC              PIC X(50)  VALUE SPACES.        
           05  S-USER-ID-UPD-BY         PIC X(07)  VALUE SPACES.        
           05  S-FULL-NAME              PIC X(50)  VALUE SPACES.        
           05  S-BLOCK-NO               PIC S9(04) COMP VALUE 0.        
           05  S-RATE-CMPNT-DESC        PIC X(15)  VALUE SPACES.        
           05  S-USE-CODE               PIC X(15)  VALUE SPACES.        
           05  S-TIME-PERIOD            PIC X(15)  VALUE SPACES.        
           05  S-SEASON                 PIC X(15)  VALUE SPACES.        
           05  S-CODE-STATUS            PIC X(01)  VALUE SPACES.        
           05  S-CODE-STATUS-DESC       PIC X(15)  VALUE SPACES.        
           05  S-VERS-PRORATE-CD        PIC X(01)  VALUE SPACES.        
           05  S-VERS-PRORATE-DESC      PIC X(15)  VALUE SPACES.        
           05  S-PROC-REQ-ID            PIC X(10)  VALUE SPACES.        
           05  S-PROC-STATUS-CD         PIC X(02)  VALUE SPACES.        
           05  S-PROC-STATUS-DESC       PIC X(50)  VALUE SPACES.        
           05  S-LAST-UPDATE-TS         PIC X(26)  VALUE SPACES.        
                                                                        
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION                                          *        
      ******************************************************************        
      * CURSOR TO FETCH FACTOR PRICING DETAILS FOR                      03984000
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE FCTR_PRC_CUR CURSOR FOR                           
                SELECT   SA.FACTOR_ID               AS FACTOR_ID        
                       , SF.FACTOR_DESC                                 
                       , SA.DATE_FROM               AS DATE_FROM        
                       , SA.DATE_TO                 AS DATE_TO          
                       , CAST(SA.INT_DISP_START_TS AS DATE)                     
                       , REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(SA.INT_DISP_START_TS AS TIME)), 
           CAST(SA.INT_DISP_START_TS AS TIME)), 108), ':', '.')                
                       , SA.FACTOR                                      
                       , SA.RATE_PLAN_NO            AS RATE_PLAN_NO     
                       , RD.RATE_DESC                                   
                       , SA.USER_ID_UPD_BY                              
                       , RTRIM(PF.LAST_NAME) + ',' + RTRIM(PF.FIRST_NAME
           ) + ' ' + RTRIM(PF.MIDDLE_NAME)
                       , SA.BLOCK_NO                                    
                       , N6.RATE_CMPNT_DESC                             
                       , UV3.CODE_SHORT_DESC                            
                       , UV4.CODE_SHORT_DESC                            
                       , UV5.CODE_SHORT_DESC                            
                       , SA.CODE_STATUS                                 
                       , UV1.CODE_SHORT_DESC                            
                       , SA.VERS_PRORATE_CD                             
                       , UV2.CODE_SHORT_DESC                            
                       , SA.PROC_REQ_ID                                 
                       , P3.PROC_STATUS_CD                              
                       , P3.PROC_STATUS_DESC                            
                       , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                  FROM  CSS_SPCL_FCTR_APPL       SA
                           WITH(READUNCOMMITTED)                     
                       ,CSS_SPCL_FCTR            SF
                           WITH(READUNCOMMITTED)                     
                       ,CSS_RATE_PLAN_DESC       RD
                           WITH(READUNCOMMITTED)                     
                       ,CSS_USER_PROFILE         PF
                           WITH(READUNCOMMITTED)                     
                       ,CSS_PROCESS_REQ          P1
                           WITH(READUNCOMMITTED)                     
                       ,CSS_PROCESS_STATUS       P3
                           WITH(READUNCOMMITTED)                     
                       ,CSS_CODE_VALUE           UV1
                           WITH(READUNCOMMITTED)                    
                       ,CSS_CODE_VALUE           UV2
                           WITH(READUNCOMMITTED)                    
                       ,CSS_CODE_VALUE           UV3
                           WITH(READUNCOMMITTED)                    
                       ,CSS_CODE_VALUE           UV4
                           WITH(READUNCOMMITTED)                    
                       ,CSS_CODE_VALUE           UV5
                           WITH(READUNCOMMITTED)                    
                       ,CSS_RATE_COMPONENT       N6
                           WITH(READUNCOMMITTED)                     
                 WHERE   SA.FACTOR_ID           = SF.FACTOR_ID          
                   AND   SA.RATE_PLAN_NO        = RD.RATE_PLAN_NO       
                   AND   SA.CODE_UTIL_TYPE      = RD.CODE_UTIL_TYPE     
                   AND   SA.USER_ID_UPD_BY      = PF.USER_ID            
                   AND   SA.PROC_REQ_ID         = P1.PROC_REQ_ID        
                   AND   P1.PROC_STATUS_CD      = P3.PROC_STATUS_CD     
                   AND  UV1.CODE_VALUE          = SA.CODE_STATUS        
                   AND  UV1.COLUMN_NA           = 'CODE_STATUS'         
                   AND  UV1.TABLE_NA            = 'CSS_SPCL_FCTR_APPL'  
                   AND  UV2.CODE_VALUE          = SA.VERS_PRORATE_CD    
                   AND  UV2.COLUMN_NA           = 'VERS_PRORATE_CD'     
                   AND  UV2.TABLE_NA            = 'CSS_RATE_CREATOR'    
                   AND  UV3.CODE_VALUE          = SA.INSTR_USE_TYPE_CD  
                   AND  UV3.COLUMN_NA           = 'INSTR_USE_TYPE_CD'   
                   AND  UV3.TABLE_NA            = 'CSS_BILL_CALC_DET'   
                   AND  UV4.CODE_VALUE      = LEFT(CAST(
           SA.CODE_TIME_PERIOD AS VARCHAR(6)) + '      ', 6) 
                   AND  UV4.COLUMN_NA           = 'CODE_TIME_PERIOD'    
                   AND  UV4.TABLE_NA            = 'CSS_SPCL_FCTR_APPL'  
                   AND  UV5.CODE_VALUE          = SA.CODE_SEASON        
                   AND  UV5.COLUMN_NA           = 'CODE_SEASON'         
                   AND  UV5.TABLE_NA            = 'CSS_RATE_USE_SEASN'  
                   AND   SA.PROC_REQ_ID        <> 0                     
                   AND  SA.CMPNT_ID_CD          = N6.RATE_CMPNT_ID      
                   AND  (:WS-STARTDT-FLTR       = 'N'                   
                    OR  (:WS-STARTDT-FLTR       = 'Y'                   
                   AND   SA.DATE_FROM          >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-FROM
              ) <> 0) OR (LEN(:WS-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-FROM
              ), CONVERT(DATE, :WS-DATE-FROM) )     ))  
                   AND  (:WS-INTSTARTDT-FLTR    = 'N'                   
                    OR  (:WS-INTSTARTDT-FLTR    = 'Y'                   
                   AND   SA.INT_DISP_START_TS  >=CIS.CHAR2TIMESTAMP(
                                                  :WS-INT-DISP-START-TS
              )))
                   AND  (:WS-STATUS-FLTR        = 'N'                   
                    OR  (:WS-STATUS-FLTR        = 'Y'                   
                   AND   SA.CODE_STATUS         = :WS-CODE-STATUS   ))  
                   AND  (:WS-LASTUPDATEBY-FLTR  = 'N'                   
                    OR  (:WS-LASTUPDATEBY-FLTR  = 'Y'                   
                   AND   SA.USER_ID_UPD_BY      = :WS-USER-ID-UPD-BY))  
                   AND  (:WS-LASTUPDTS-FLTR     = 'N'                   
                    OR  (:WS-LASTUPDTS-FLTR     = 'Y'                   
                   AND   SA.LAST_UPDATE_TS     >= CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )))  
                   AND  (:WS-EXCRATEFCTR-FLTR   = 'N'                   
                    OR  (:WS-EXCRATEFCTR-FLTR   = 'Y'                   
                   AND   SF.FACTOR_TYPE        <> :WS-ACTIVE        ))  
                 UNION                                                  
                SELECT   SA.FACTOR_ID                AS FACTOR_ID       
                       , SF.FACTOR_DESC                                 
                       , SA.DATE_FROM                AS DATE_FROM       
                       , SA.DATE_TO                  AS DATE_TO         
                       , CAST(SA.INT_DISP_START_TS AS DATE)                     
                       , REPLACE(CONVERT(CHAR(8), DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(SA.INT_DISP_START_TS AS TIME)), 
           CAST(SA.INT_DISP_START_TS AS TIME)), 108), ':', '.')                
                       , SA.FACTOR                                      
                       , SA.RATE_PLAN_NO             AS RATE_PLAN_NO    
                       , RD.RATE_DESC                                   
                       , SA.USER_ID_UPD_BY                              
                       , RTRIM(PF.LAST_NAME) + ',' + RTRIM(PF.FIRST_NAME
           ) + ' ' + RTRIM(PF.MIDDLE_NAME)
                       , SA.BLOCK_NO                                    
                       , N6.RATE_CMPNT_DESC                             
                       , UV3.CODE_SHORT_DESC                            
                       , UV4.CODE_SHORT_DESC                            
                       , UV5.CODE_SHORT_DESC                            
                       , SA.CODE_STATUS                                 
                       , UV1.CODE_SHORT_DESC                            
                       , SA.VERS_PRORATE_CD                             
                       , UV2.CODE_SHORT_DESC                            
                       , SA.PROC_REQ_ID                                 
                       , 'NA'                                           
                       , 'NA'                                           
                       , REPLACE(REPLACE(CONVERT(CHAR(26), 
           SA.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                  FROM  CSS_SPCL_FCTR_APPL       SA
                           WITH(READUNCOMMITTED)                     
                       ,CSS_SPCL_FCTR            SF
                           WITH(READUNCOMMITTED)                     
                       ,CSS_RATE_PLAN_DESC       RD
                           WITH(READUNCOMMITTED)                     
                       ,CSS_USER_PROFILE         PF
                           WITH(READUNCOMMITTED)                     
                       ,CSS_CODE_VALUE           UV1
                           WITH(READUNCOMMITTED)                    
                       ,CSS_CODE_VALUE           UV2
                           WITH(READUNCOMMITTED)                    
                       ,CSS_CODE_VALUE           UV3
                           WITH(READUNCOMMITTED)                    
                       ,CSS_CODE_VALUE           UV4
                           WITH(READUNCOMMITTED)                    
                       ,CSS_CODE_VALUE           UV5
                           WITH(READUNCOMMITTED)                    
                       ,CSS_RATE_COMPONENT       N6
                           WITH(READUNCOMMITTED)                     
                 WHERE   SA.FACTOR_ID           = SF.FACTOR_ID          
                   AND   SA.RATE_PLAN_NO        = RD.RATE_PLAN_NO       
                   AND   SA.CODE_UTIL_TYPE      = RD.CODE_UTIL_TYPE     
                   AND   SA.USER_ID_UPD_BY      = PF.USER_ID            
                   AND  UV1.CODE_VALUE          = SA.CODE_STATUS        
                   AND  UV1.COLUMN_NA           = 'CODE_STATUS'         
                   AND  UV1.TABLE_NA            = 'CSS_SPCL_FCTR_APPL'  
                   AND  UV2.CODE_VALUE          = SA.VERS_PRORATE_CD    
                   AND  UV2.COLUMN_NA           = 'VERS_PRORATE_CD'     
                   AND  UV2.TABLE_NA            = 'CSS_RATE_CREATOR'    
                   AND  UV3.CODE_VALUE          = SA.INSTR_USE_TYPE_CD  
                   AND  UV3.COLUMN_NA           = 'INSTR_USE_TYPE_CD'   
                   AND  UV3.TABLE_NA            = 'CSS_BILL_CALC_DET'   
                   AND  UV4.CODE_VALUE      = LEFT(CAST(
           SA.CODE_TIME_PERIOD AS VARCHAR(6)) + '      ', 6) 
                   AND  UV4.COLUMN_NA           = 'CODE_TIME_PERIOD'    
                   AND  UV4.TABLE_NA            = 'CSS_SPCL_FCTR_APPL'  
                   AND  UV5.CODE_VALUE          = SA.CODE_SEASON        
                   AND  UV5.COLUMN_NA           = 'CODE_SEASON'         
                   AND  UV5.TABLE_NA            = 'CSS_RATE_USE_SEASN'  
                   AND   SA.PROC_REQ_ID         = 0                     
                   AND  SA.CMPNT_ID_CD          = N6.RATE_CMPNT_ID      
                   AND  (:WS-STARTDT-FLTR       = 'N'                   
                    OR  (:WS-STARTDT-FLTR       = 'Y'                   
                   AND   SA.DATE_FROM          >= IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-FROM
              ) <> 0) OR (LEN(:WS-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-FROM
              ), CONVERT(DATE, :WS-DATE-FROM) )     ))  
                   AND  (:WS-INTSTARTDT-FLTR    = 'N'                   
                    OR  (:WS-INTSTARTDT-FLTR    = 'Y'                   
                   AND   SA.INT_DISP_START_TS  >=CIS.CHAR2TIMESTAMP(
                                                  :WS-INT-DISP-START-TS
              )))
                   AND  (:WS-STATUS-FLTR        = 'N'                   
                    OR  (:WS-STATUS-FLTR        = 'Y'                   
                   AND   SA.CODE_STATUS         = :WS-CODE-STATUS   ))  
                   AND  (:WS-LASTUPDATEBY-FLTR  = 'N'                   
                    OR  (:WS-LASTUPDATEBY-FLTR  = 'Y'                   
                   AND   SA.USER_ID_UPD_BY      = :WS-USER-ID-UPD-BY))  
                   AND  (:WS-LASTUPDTS-FLTR     = 'N'                   
                    OR  (:WS-LASTUPDTS-FLTR     = 'Y'                   
                   AND   SA.LAST_UPDATE_TS     >= CIS.CHAR2TIMESTAMP(
                                                     :WS-LAST-UPDATE-TS
              )))  
                   AND  (:WS-EXCRATEFCTR-FLTR   = 'N'                   
                    OR  (:WS-EXCRATEFCTR-FLTR   = 'Y'                   
                   AND   SF.FACTOR_TYPE        <> :WS-ACTIVE        ))  
              ORDER BY   FACTOR_ID                                      
                       , RATE_PLAN_NO                                   
                       , DATE_FROM                                      
                       , DATE_TO                                        
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03985000
MFA-TR*       DECLARE FCTR_PRC_CUR CURSOR FOR                           03986000
MFA-TR*         SELECT   SA.FACTOR_ID               AS FACTOR_ID                
MFA-TR*                , SF.FACTOR_DESC                                         
MFA-TR*                , SA.DATE_FROM               AS DATE_FROM                
MFA-TR*                , SA.DATE_TO                 AS DATE_TO                  
MFA-TR*                , DATE(SA.INT_DISP_START_TS)                             
MFA-TR*                , TIME(SA.INT_DISP_START_TS)                             
MFA-TR*                , SA.FACTOR                                              
MFA-TR*                , SA.RATE_PLAN_NO            AS RATE_PLAN_NO             
MFA-TR*                , RD.RATE_DESC                                           
MFA-TR*                , SA.USER_ID_UPD_BY                                      
MFA-TR*                , RTRIM(PF.LAST_NAME)||','||RTRIM(PF.FIRST_NAME )        
MFA-TR*                                     ||' '||RTRIM(PF.MIDDLE_NAME)        
MFA-TR*                , SA.BLOCK_NO                                            
MFA-TR*                , N6.RATE_CMPNT_DESC                                     
MFA-TR*                , UV3.CODE_SHORT_DESC                                    
MFA-TR*                , UV4.CODE_SHORT_DESC                                    
MFA-TR*                , UV5.CODE_SHORT_DESC                                    
MFA-TR*                , SA.CODE_STATUS                                         
MFA-TR*                , UV1.CODE_SHORT_DESC                                    
MFA-TR*                , SA.VERS_PRORATE_CD                                     
MFA-TR*                , UV2.CODE_SHORT_DESC                                    
MFA-TR*                , SA.PROC_REQ_ID                                         
MFA-TR*                , P3.PROC_STATUS_CD                                      
MFA-TR*                , P3.PROC_STATUS_DESC                                    
MFA-TR*                , SA.LAST_UPDATE_TS                                      
MFA-TR*           FROM  CSS_SPCL_FCTR_APPL       SA                             
MFA-TR*                ,CSS_SPCL_FCTR            SF                             
MFA-TR*                ,CSS_RATE_PLAN_DESC       RD                             
MFA-TR*                ,CSS_USER_PROFILE         PF                             
MFA-TR*                ,CSS_PROCESS_REQ          P1                             
MFA-TR*                ,CSS_PROCESS_STATUS       P3                             
MFA-TR*                ,CSS_CODE_VALUE           UV1                            
MFA-TR*                ,CSS_CODE_VALUE           UV2                            
MFA-TR*                ,CSS_CODE_VALUE           UV3                            
MFA-TR*                ,CSS_CODE_VALUE           UV4                            
MFA-TR*                ,CSS_CODE_VALUE           UV5                            
MFA-TR*                ,CSS_RATE_COMPONENT       N6                             
MFA-TR*          WHERE   SA.FACTOR_ID           = SF.FACTOR_ID                  
MFA-TR*            AND   SA.RATE_PLAN_NO        = RD.RATE_PLAN_NO               
MFA-TR*            AND   SA.CODE_UTIL_TYPE      = RD.CODE_UTIL_TYPE             
MFA-TR*            AND   SA.USER_ID_UPD_BY      = PF.USER_ID                    
MFA-TR*            AND   SA.PROC_REQ_ID         = P1.PROC_REQ_ID                
MFA-TR*            AND   P1.PROC_STATUS_CD      = P3.PROC_STATUS_CD             
MFA-TR*            AND  UV1.CODE_VALUE          = SA.CODE_STATUS                
MFA-TR*            AND  UV1.COLUMN_NA           = 'CODE_STATUS'                 
MFA-TR*            AND  UV1.TABLE_NA            = 'CSS_SPCL_FCTR_APPL'          
MFA-TR*            AND  UV2.CODE_VALUE          = SA.VERS_PRORATE_CD            
MFA-TR*            AND  UV2.COLUMN_NA           = 'VERS_PRORATE_CD'             
MFA-TR*            AND  UV2.TABLE_NA            = 'CSS_RATE_CREATOR'            
MFA-TR*            AND  UV3.CODE_VALUE          = SA.INSTR_USE_TYPE_CD          
MFA-TR*            AND  UV3.COLUMN_NA           = 'INSTR_USE_TYPE_CD'           
MFA-TR*            AND  UV3.TABLE_NA            = 'CSS_BILL_CALC_DET'           
MFA-TR*            AND  UV4.CODE_VALUE      = CHAR(SA.CODE_TIME_PERIOD)         
MFA-TR*            AND  UV4.COLUMN_NA           = 'CODE_TIME_PERIOD'            
MFA-TR*            AND  UV4.TABLE_NA            = 'CSS_SPCL_FCTR_APPL'          
MFA-TR*            AND  UV5.CODE_VALUE          = SA.CODE_SEASON                
MFA-TR*            AND  UV5.COLUMN_NA           = 'CODE_SEASON'                 
MFA-TR*            AND  UV5.TABLE_NA            = 'CSS_RATE_USE_SEASN'          
MFA-TR*            AND   SA.PROC_REQ_ID        <> 0                             
MFA-TR*            AND  SA.CMPNT_ID_CD          = N6.RATE_CMPNT_ID              
MFA-TR*            AND  (:WS-STARTDT-FLTR       = 'N'                           
MFA-TR*             OR  (:WS-STARTDT-FLTR       = 'Y'                           
MFA-TR*            AND   SA.DATE_FROM          >= :WS-DATE-FROM     ))          
MFA-TR*            AND  (:WS-INTSTARTDT-FLTR    = 'N'                           
MFA-TR*             OR  (:WS-INTSTARTDT-FLTR    = 'Y'                           
MFA-TR*            AND   SA.INT_DISP_START_TS  >=:WS-INT-DISP-START-TS))        
MFA-TR*            AND  (:WS-STATUS-FLTR        = 'N'                           
MFA-TR*             OR  (:WS-STATUS-FLTR        = 'Y'                           
MFA-TR*            AND   SA.CODE_STATUS         = :WS-CODE-STATUS   ))          
MFA-TR*            AND  (:WS-LASTUPDATEBY-FLTR  = 'N'                           
MFA-TR*             OR  (:WS-LASTUPDATEBY-FLTR  = 'Y'                           
MFA-TR*            AND   SA.USER_ID_UPD_BY      = :WS-USER-ID-UPD-BY))          
MFA-TR*            AND  (:WS-LASTUPDTS-FLTR     = 'N'                           
MFA-TR*             OR  (:WS-LASTUPDTS-FLTR     = 'Y'                           
MFA-TR*            AND   SA.LAST_UPDATE_TS     >= :WS-LAST-UPDATE-TS))          
MFA-TR*            AND  (:WS-EXCRATEFCTR-FLTR   = 'N'                           
MFA-TR*             OR  (:WS-EXCRATEFCTR-FLTR   = 'Y'                           
MFA-TR*            AND   SF.FACTOR_TYPE        <> :WS-ACTIVE        ))          
MFA-TR*          UNION                                                          
MFA-TR*         SELECT   SA.FACTOR_ID                AS FACTOR_ID               
MFA-TR*                , SF.FACTOR_DESC                                         
MFA-TR*                , SA.DATE_FROM                AS DATE_FROM               
MFA-TR*                , SA.DATE_TO                  AS DATE_TO                 
MFA-TR*                , DATE(SA.INT_DISP_START_TS)                             
MFA-TR*                , TIME(SA.INT_DISP_START_TS)                             
MFA-TR*                , SA.FACTOR                                              
MFA-TR*                , SA.RATE_PLAN_NO             AS RATE_PLAN_NO            
MFA-TR*                , RD.RATE_DESC                                           
MFA-TR*                , SA.USER_ID_UPD_BY                                      
MFA-TR*                , RTRIM(PF.LAST_NAME)||','||RTRIM(PF.FIRST_NAME )        
MFA-TR*                                     ||' '||RTRIM(PF.MIDDLE_NAME)        
MFA-TR*                , SA.BLOCK_NO                                            
MFA-TR*                , N6.RATE_CMPNT_DESC                                     
MFA-TR*                , UV3.CODE_SHORT_DESC                                    
MFA-TR*                , UV4.CODE_SHORT_DESC                                    
MFA-TR*                , UV5.CODE_SHORT_DESC                                    
MFA-TR*                , SA.CODE_STATUS                                         
MFA-TR*                , UV1.CODE_SHORT_DESC                                    
MFA-TR*                , SA.VERS_PRORATE_CD                                     
MFA-TR*                , UV2.CODE_SHORT_DESC                                    
MFA-TR*                , SA.PROC_REQ_ID                                         
MFA-TR*                , 'NA'                                                   
MFA-TR*                , 'NA'                                                   
MFA-TR*                , SA.LAST_UPDATE_TS                                      
MFA-TR*           FROM  CSS_SPCL_FCTR_APPL       SA                             
MFA-TR*                ,CSS_SPCL_FCTR            SF                             
MFA-TR*                ,CSS_RATE_PLAN_DESC       RD                             
MFA-TR*                ,CSS_USER_PROFILE         PF                             
MFA-TR*                ,CSS_CODE_VALUE           UV1                            
MFA-TR*                ,CSS_CODE_VALUE           UV2                            
MFA-TR*                ,CSS_CODE_VALUE           UV3                            
MFA-TR*                ,CSS_CODE_VALUE           UV4                            
MFA-TR*                ,CSS_CODE_VALUE           UV5                            
MFA-TR*                ,CSS_RATE_COMPONENT       N6                             
MFA-TR*          WHERE   SA.FACTOR_ID           = SF.FACTOR_ID                  
MFA-TR*            AND   SA.RATE_PLAN_NO        = RD.RATE_PLAN_NO               
MFA-TR*            AND   SA.CODE_UTIL_TYPE      = RD.CODE_UTIL_TYPE             
MFA-TR*            AND   SA.USER_ID_UPD_BY      = PF.USER_ID                    
MFA-TR*            AND  UV1.CODE_VALUE          = SA.CODE_STATUS                
MFA-TR*            AND  UV1.COLUMN_NA           = 'CODE_STATUS'                 
MFA-TR*            AND  UV1.TABLE_NA            = 'CSS_SPCL_FCTR_APPL'          
MFA-TR*            AND  UV2.CODE_VALUE          = SA.VERS_PRORATE_CD            
MFA-TR*            AND  UV2.COLUMN_NA           = 'VERS_PRORATE_CD'             
MFA-TR*            AND  UV2.TABLE_NA            = 'CSS_RATE_CREATOR'            
MFA-TR*            AND  UV3.CODE_VALUE          = SA.INSTR_USE_TYPE_CD          
MFA-TR*            AND  UV3.COLUMN_NA           = 'INSTR_USE_TYPE_CD'           
MFA-TR*            AND  UV3.TABLE_NA            = 'CSS_BILL_CALC_DET'           
MFA-TR*            AND  UV4.CODE_VALUE      = CHAR(SA.CODE_TIME_PERIOD)         
MFA-TR*            AND  UV4.COLUMN_NA           = 'CODE_TIME_PERIOD'            
MFA-TR*            AND  UV4.TABLE_NA            = 'CSS_SPCL_FCTR_APPL'          
MFA-TR*            AND  UV5.CODE_VALUE          = SA.CODE_SEASON                
MFA-TR*            AND  UV5.COLUMN_NA           = 'CODE_SEASON'                 
MFA-TR*            AND  UV5.TABLE_NA            = 'CSS_RATE_USE_SEASN'          
MFA-TR*            AND   SA.PROC_REQ_ID         = 0                             
MFA-TR*            AND  SA.CMPNT_ID_CD          = N6.RATE_CMPNT_ID              
MFA-TR*            AND  (:WS-STARTDT-FLTR       = 'N'                           
MFA-TR*             OR  (:WS-STARTDT-FLTR       = 'Y'                           
MFA-TR*            AND   SA.DATE_FROM          >= :WS-DATE-FROM     ))          
MFA-TR*            AND  (:WS-INTSTARTDT-FLTR    = 'N'                           
MFA-TR*             OR  (:WS-INTSTARTDT-FLTR    = 'Y'                           
MFA-TR*            AND   SA.INT_DISP_START_TS  >=:WS-INT-DISP-START-TS))        
MFA-TR*            AND  (:WS-STATUS-FLTR        = 'N'                           
MFA-TR*             OR  (:WS-STATUS-FLTR        = 'Y'                           
MFA-TR*            AND   SA.CODE_STATUS         = :WS-CODE-STATUS   ))          
MFA-TR*            AND  (:WS-LASTUPDATEBY-FLTR  = 'N'                           
MFA-TR*             OR  (:WS-LASTUPDATEBY-FLTR  = 'Y'                           
MFA-TR*            AND   SA.USER_ID_UPD_BY      = :WS-USER-ID-UPD-BY))          
MFA-TR*            AND  (:WS-LASTUPDTS-FLTR     = 'N'                           
MFA-TR*             OR  (:WS-LASTUPDTS-FLTR     = 'Y'                           
MFA-TR*            AND   SA.LAST_UPDATE_TS     >= :WS-LAST-UPDATE-TS))          
MFA-TR*            AND  (:WS-EXCRATEFCTR-FLTR   = 'N'                           
MFA-TR*             OR  (:WS-EXCRATEFCTR-FLTR   = 'Y'                           
MFA-TR*            AND   SF.FACTOR_TYPE        <> :WS-ACTIVE        ))          
MFA-TR*       ORDER BY   FACTOR_ID                                              
MFA-TR*                , RATE_PLAN_NO                                           
MFA-TR*                , DATE_FROM                                              
MFA-TR*                , DATE_TO                                                
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 5100                                                      
MFA-TR*    END-EXEC.                                                    03991100
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPLY-STARTDT-FLTR      PIC X(01).                      
       01  PARM-DATE-FROM               PIC X(10).                      
       01  PARM-APPLY-INTSTARTDT-FLTR   PIC X(01).                      
       01  PARM-INT-DISP-START-TS       PIC X(26).                      
       01  PARM-APPLY-STATUS-FLTR       PIC X(01).                      
       01  PARM-CODE-STATUS             PIC X(01).                      
       01  PARM-APPLY-LASTUPDATEBY-FLTR PIC X(01).                      
       01  PARM-USER-ID-UPD-BY          PIC X(07).                      
       01  PARM-APPLY-LASTUPDTS-FLTR    PIC X(01).                      
       01  PARM-LAST-UPDATE-TS          PIC X(26).                      
       01  PARM-APPLY-EXCRATEFCTR-FLTR  PIC X(01).                      
                                                                        
       PROCEDURE DIVISION USING PARM-APPLY-STARTDT-FLTR                 
                              , PARM-DATE-FROM                          
                              , PARM-APPLY-INTSTARTDT-FLTR              
                              , PARM-INT-DISP-START-TS                  
                              , PARM-APPLY-STATUS-FLTR                  
                              , PARM-CODE-STATUS                        
                              , PARM-APPLY-LASTUPDATEBY-FLTR            
                              , PARM-USER-ID-UPD-BY                     
                              , PARM-APPLY-LASTUPDTS-FLTR               
                              , PARM-LAST-UPDATE-TS                     
                              , PARM-APPLY-EXCRATEFCTR-FLTR.            
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE.                                               *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT          THRU 0100A-EXIT.          
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *0100A-DECLARE-GTT.                                                       
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE '0100A'                      TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04451_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04451_R1
              (                                                        
                   FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,FACTOR_DESC CHAR(60)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,DATE_FROM CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,DATE_TO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
                  ,INT_DISP_START_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,INT_DISP_START_TM CHAR(15)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,FACTOR                DECIMAL(9,6)                   
                  ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,USER_ID_UPD_BY CHAR(07)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,FULL_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2          
                  ,BLOCK_NO              SMALLINT                       
                  ,RATE_CMPNT_DESC CHAR(15)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,USE_CODE CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2           
                  ,TIME_PERIOD CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,SEASON CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2             
                  ,CODE_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,CODE_STATUS_DESC CHAR(15)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,VERS_PRORATE_CD CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,VERS_PRORATE_DESC CHAR(15)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,PROC_REQ_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                  ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,PROC_STATUS_DESC CHAR(50)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
                  ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                       
               )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS   THRU 8000A-EXIT           
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 ADD 1                       TO CTR-ROWS                
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE 'CSR04451_R1'          TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR                               
               WITH ROWSET POSITIONING FOR                              
                    SELECT  FACTOR_ID                                   
                           ,FACTOR_DESC                                 
                           ,DATE_FROM                                   
                           ,DATE_TO                                     
                           ,INT_DISP_START_DT                           
                           ,INT_DISP_START_TM                           
                           ,FACTOR                                      
                           ,RATE_PLAN_NO                                
                           ,RATE_DESC                                   
                           ,USER_ID_UPD_BY                              
                           ,FULL_NAME                                   
                           ,BLOCK_NO                                    
                           ,RATE_CMPNT_DESC                             
                           ,USE_CODE                                    
                           ,TIME_PERIOD                                 
                           ,SEASON                                      
                           ,CODE_STATUS                                 
                           ,CODE_STATUS_DESC                            
                           ,VERS_PRORATE_CD                             
                           ,VERS_PRORATE_DESC                           
                           ,PROC_REQ_ID                                 
                           ,PROC_STATUS_CD                              
                           ,PROC_STATUS_DESC                            
                           ,LAST_UPDATE_TS                              
                    FROM #CSR04451_R1                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*             SELECT  FACTOR_ID                                           
MFA-TR*                    ,FACTOR_DESC                                         
MFA-TR*                    ,DATE_FROM                                           
MFA-TR*                    ,DATE_TO                                             
MFA-TR*                    ,INT_DISP_START_DT                                   
MFA-TR*                    ,INT_DISP_START_TM                                   
MFA-TR*                    ,FACTOR                                              
MFA-TR*                    ,RATE_PLAN_NO                                        
MFA-TR*                    ,RATE_DESC                                           
MFA-TR*                    ,USER_ID_UPD_BY                                      
MFA-TR*                    ,FULL_NAME                                           
MFA-TR*                    ,BLOCK_NO                                            
MFA-TR*                    ,RATE_CMPNT_DESC                                     
MFA-TR*                    ,USE_CODE                                            
MFA-TR*                    ,TIME_PERIOD                                         
MFA-TR*                    ,SEASON                                              
MFA-TR*                    ,CODE_STATUS                                         
MFA-TR*                    ,CODE_STATUS_DESC                                    
MFA-TR*                    ,VERS_PRORATE_CD                                     
MFA-TR*                    ,VERS_PRORATE_DESC                                   
MFA-TR*                    ,PROC_REQ_ID                                         
MFA-TR*                    ,PROC_STATUS_CD                                      
MFA-TR*                    ,PROC_STATUS_DESC                                    
MFA-TR*                    ,LAST_UPDATE_TS                                      
MFA-TR*             FROM SESSION.CSR04451_R1                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *        VALIDATE INPUT PARMS                                    *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-APPLY-STARTDT-FLTR      TO WS-STARTDT-FLTR.        
           MOVE PARM-APPLY-INTSTARTDT-FLTR   TO WS-INTSTARTDT-FLTR.     
           MOVE PARM-APPLY-STATUS-FLTR       TO WS-STATUS-FLTR.         
           MOVE PARM-CODE-STATUS             TO WS-CODE-STATUS.         
           MOVE PARM-APPLY-LASTUPDATEBY-FLTR TO WS-LASTUPDATEBY-FLTR.   
           MOVE PARM-USER-ID-UPD-BY          TO WS-USER-ID-UPD-BY.      
           MOVE PARM-APPLY-LASTUPDTS-FLTR    TO WS-LASTUPDTS-FLTR.      
           MOVE PARM-APPLY-EXCRATEFCTR-FLTR  TO WS-EXCRATEFCTR-FLTR.    
                                                                        
           IF WS-STARTDT-FLTR         = 'Y'                             
              MOVE WS-FROM-DATE              TO WS-FIELD                
              MOVE PARM-DATE-FROM            TO WS-VALUE                
                                                WS-DATE-FROM            
              IF WS-DATE-FROM         > SPACES                          
                 PERFORM 7000-VALIDATE-DATE   THRU  7000-EXIT           
              ELSE                                                      
                 MOVE WS-INVALID-INPUT       TO S-FACTOR-DESC           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           ELSE                                                         
              MOVE '0001-01-01'              TO WS-DATE-FROM            
           END-IF.                                                      
                                                                        
           IF WS-INTSTARTDT-FLTR      = 'Y'                             
              MOVE WS-DISP-START-TS-FLD      TO WS-FIELD                
              MOVE PARM-INT-DISP-START-TS    TO WS-VALUE                
                                                WS-TIMESTAMP            
                                                WS-INT-DISP-START-TS    
              IF WS-INT-DISP-START-TS > SPACES                          
                 PERFORM 7100-VALIDATE-TS     THRU  7100-EXIT           
              ELSE                                                      
                 MOVE WS-INVALID-INPUT       TO S-FACTOR-DESC           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           ELSE                                                         
              MOVE '0001-01-01-00.00.00.000000'                         
                                             TO WS-INT-DISP-START-TS    
           END-IF.                                                      
                                                                        
           IF WS-LASTUPDTS-FLTR       = 'Y'                             
              MOVE WS-LAST-UPDATE-TS-FLD     TO WS-FIELD                
              MOVE PARM-LAST-UPDATE-TS       TO WS-VALUE                
                                                WS-TIMESTAMP            
                                                WS-LAST-UPDATE-TS       
              IF WS-LAST-UPDATE-TS    > SPACES                          
                 PERFORM 7100-VALIDATE-TS     THRU  7100-EXIT           
              ELSE                                                      
                 MOVE WS-INVALID-INPUT       TO S-FACTOR-DESC           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           ELSE                                                         
              MOVE '0001-01-01-00.00.00.000000'                         
                                             TO WS-LAST-UPDATE-TS       
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. BUILD RESULT SET                                        *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           PERFORM 2100-GET-FCTR-PRC-DTLS     THRU 2100-EXIT.           
                                                                        
           IF CTR-ROWS = 0                                              
              MOVE WS-NO-RECORDS-FOUND       TO S-FACTOR-DESC           
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 16233300
      ******************************************************************16234000
      * 2100-GET-FCTR-PRC-DTLS                                         *16240000
      *                                                                *16250000
      *  1. OPEN CURSOR                                                *16260000
      *  2. FETCH DEPENDENT ACCOUNT INFORMATION                        *16270000
      *  3. CLOSE CURSOR                                               *16271000
      *  4. DETERMINE MASTER ACCOUNT INFORMATION                       *16280000
      *                                                                *16281000
      ******************************************************************16290000
       2100-GET-FCTR-PRC-DTLS.                                          
      *                                                                 16310000
           PERFORM 5000-OPEN-FCTR-PRC-CURSOR  THRU 5000-EXIT.           
           PERFORM 5100-FETCH-FCTR-PRC-CURSOR THRU 5100-EXIT.           
           PERFORM 2200-PROCESS-FCTR-PRC      THRU 2200-EXIT            
                       UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.         
           PERFORM 5200-CLOSE-FCTR-PRC-CURSOR THRU 5200-EXIT.           
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 16651000
      ******************************************************************16234000
      * 2200-PROCESS-FCTR-PRC                                          *16240000
      *  2. FETCH DEPENDENT ACCOUNT INFORMATION                        *16270000
      *  4. DETERMINE MASTER ACCOUNT INFORMATION                       *16280000
      ******************************************************************16290000
       2200-PROCESS-FCTR-PRC.                                           
                                                                        
           PERFORM 2300-SET-RETURNS           THRU 2300-EXIT.           
           PERFORM 8100-SEND-RESULT           THRU 8100-EXIT.           
           PERFORM 5100-FETCH-FCTR-PRC-CURSOR THRU 5100-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 16651000
      ******************************************************************16663000
      * 2300 SET RETURNS                                               *16670000
      *    -- THIS PARA SET UP THE VALUES FOR THE VARIABLES THAT ARE TO*16680000
      *       BE RETURNED TO THE RMM APPLICATION.                      *16690000
      ******************************************************************16700000
       2300-SET-RETURNS.                                                
                                                                        
           MOVE SA-FACTOR-ID          TO S-FACTOR-ID        .           
           MOVE SF-FACTOR-DESC        TO S-FACTOR-DESC      .           
           MOVE SA-DATE-FROM          TO S-DATE-FROM        .           
           MOVE SA-DATE-TO            TO S-DATE-TO          .           
           MOVE WS-INT-DISP-STRT-DT   TO S-INT-DISP-START-DT.           
           MOVE WS-INT-DISP-STRT-TM   TO S-INT-DISP-START-TM.           
           MOVE SA-FACTOR             TO S-FACTOR           .           
           MOVE SA-RATE-PLAN-NO       TO S-RATE-PLAN-NO     .           
           MOVE RD-RATE-DESC          TO S-RATE-DESC        .           
           MOVE SA-USER-ID-UPD-BY     TO S-USER-ID-UPD-BY   .           
           MOVE WS-FULL-NAME          TO S-FULL-NAME        .           
           MOVE SA-BLOCK-NO           TO S-BLOCK-NO         .           
           MOVE N6-RATE-CMPNT-DESC    TO S-RATE-CMPNT-DESC  .           
           MOVE WS-USE-CODE-DESC      TO S-USE-CODE         .           
           MOVE WS-TIME-PERIOD-DESC   TO S-TIME-PERIOD      .           
           MOVE WS-SEASON-DESC        TO S-SEASON           .           
           MOVE SA-CODE-STATUS        TO S-CODE-STATUS      .           
           MOVE WS-CODE-STATUS-DESC   TO S-CODE-STATUS-DESC .           
           MOVE SA-VERS-PRORATE-CD    TO S-VERS-PRORATE-CD  .           
           MOVE WS-VERS-PRORATE-DESC  TO S-VERS-PRORATE-DESC.           
           MOVE SA-PROC-REQ-ID        TO WS-PROC-REQ-ID     .           
           MOVE WS-PROC-REQ-ID        TO S-PROC-REQ-ID      .           
           MOVE 3P-PROC-STATUS-CD     TO S-PROC-STATUS-CD   .           
           MOVE 3P-PROC-STATUS-DESC   TO S-PROC-STATUS-DESC .           
           MOVE SA-LAST-UPDATE-TS     TO S-LAST-UPDATE-TS   .           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42239500
      ******************************************************************42239600
      * 5000-OPEN-FCTR-PRC-CURSOR                                      *42239700
      *       -- THIS PARA OPEN THE CURSOR THAT WILL CRAETE THE RESULT *42239800
      *          SET OF FACTOR PRICING                                 *42239900
      ******************************************************************42240000
       5000-OPEN-FCTR-PRC-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN FCTR_PRC_CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE WS-HARD-ERROR             TO S-FACTOR-DESC           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 42242800
      ******************************************************************42242900
      * 5100-FETCH-FCTR-PRC-CURSOR                                     *42243000
      *     -- THIS PARA FETCH THE RESULT ROWS OF FACTOR PRICING       *42243100
      ******************************************************************42243300
       5100-FETCH-FCTR-PRC-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH FCTR_PRC_CUR                                       
                  INTO :SA-FACTOR-ID                                    
                      ,:SF-FACTOR-DESC                                  
                      ,:SA-DATE-FROM                                    
                      ,:SA-DATE-TO                                      
                      ,:WS-INT-DISP-STRT-DT                             
                      ,:WS-INT-DISP-STRT-TM                             
                      ,:SA-FACTOR                                       
                      ,:SA-RATE-PLAN-NO                                 
                      ,:RD-RATE-DESC                                    
                      ,:SA-USER-ID-UPD-BY                               
                      ,:WS-FULL-NAME                                    
                      ,:SA-BLOCK-NO                                     
                      ,:N6-RATE-CMPNT-DESC                              
                      ,:WS-USE-CODE-DESC                                
                      ,:WS-TIME-PERIOD-DESC                             
                      ,:WS-SEASON-DESC                                  
                      ,:SA-CODE-STATUS                                  
                      ,:WS-CODE-STATUS-DESC                             
                      ,:SA-VERS-PRORATE-CD                              
                      ,:WS-VERS-PRORATE-DESC                            
                      ,:SA-PROC-REQ-ID                                  
                      ,:3P-PROC-STATUS-CD                               
                      ,:3P-PROC-STATUS-DESC                             
                      ,:SA-LAST-UPDATE-TS                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
      *    IF WS-NULL-IND1 < 0 THEN                                             
      *       MOVE SPACES                    TO SA-INT-DISP-START-TS            
      *    END-IF.                                                              
      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE WS-HARD-ERROR             TO S-FACTOR-DESC           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 42239500
      ******************************************************************42269700
      * 5200-CLOSE-FCTR-PRC-CURSOR                                     *42269800
      *       -- THIS MODULE CLOSES THE FACTOR CURSOR                  *42269900
      ******************************************************************42270000
       5200-CLOSE-FCTR-PRC-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE FCTR_PRC_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '5200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE WS-HARD-ERROR             TO S-FACTOR-DESC           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 42269600
      ******************************************************************42269700
      * 7000-VALIDATE-DATE                                             *42269800
      *       -- THIS MODULE CLOSES THE FACTOR CURSOR                  *42269900
      ******************************************************************42270000
       7000-VALIDATE-DATE.                                              
                                                                        
           EXEC SQL                                                     
              SELECT IIF(TRY_CONVERT(DATE, :WS-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-FROM
              ) <> 0) OR (LEN(:WS-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-FROM
              ), CONVERT(DATE, :WS-DATE-FROM) )                                
                INTO :WS-DATE-FROM                                      
                FROM CIS.SYSDUMMY1                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     42270300
MFA-TR*       SELECT DATE(:WS-DATE-FROM)                                42270400
MFA-TR*         INTO :WS-DATE-FROM                                      42270400
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                   42270400
MFA-TR*       QUERYNO 7000                                              42270400
MFA-TR*    END-EXEC.                                                    42270500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE WS-INVALID-INPUT          TO S-FACTOR-DESC           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 42269600
      ******************************************************************42269700
      * 7100-VALIDATE-TS                                               *42269800
      *       -- THIS MODULE CLOSES THE FACTOR CURSOR                  *42269900
      ******************************************************************42270000
       7100-VALIDATE-TS.                                                
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CHAR2TIMESTAMP(:WS-TIMESTAMP), 121), ' ', '-'), ':', 
           '.')                          
                 INTO :WS-TIMESTAMP                                     
                 FROM CIS.SYSDUMMY1                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     42270300
MFA-TR*        SELECT TIMESTAMP(:WS-TIMESTAMP)                          42270400
MFA-TR*          INTO :WS-TIMESTAMP                                     42270400
MFA-TR*          FROM SYSIBM.SYSDUMMY1                                  42270400
MFA-TR*        QUERYNO 7100                                             42270400
MFA-TR*    END-EXEC.                                                    42270500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE WS-INVALID-INPUT          TO S-FACTOR-DESC           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 42269600
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE '8000A'                      TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE 'DELETE ROWS'                TO S-SQL-STATEMENT-V.      
                                                                        
           EXEC SQL                                                     
              DELETE FROM #CSR04451_R1                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM SESSION.CSR04451_R1                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              ADD 1                          TO CTR-ROWS                
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8000A'                   TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04451_R1'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************42269700
      * 8100-SEND-RESULT.                                              *42269800
      *       -- THIS MODULE CLOSES THE FACTOR CURSOR                  *42269900
      ******************************************************************42270000
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
                  INSERT INTO #CSR04451_R1                       
                  (    FACTOR_ID                                        
                      ,FACTOR_DESC                                      
                      ,DATE_FROM                                        
                      ,DATE_TO                                          
                      ,INT_DISP_START_DT                                
                      ,INT_DISP_START_TM                                
                      ,FACTOR                                           
                      ,RATE_PLAN_NO                                     
                      ,RATE_DESC                                        
                      ,USER_ID_UPD_BY                                   
                      ,FULL_NAME                                        
                      ,BLOCK_NO                                         
                      ,RATE_CMPNT_DESC                                  
                      ,USE_CODE                                         
                      ,TIME_PERIOD                                      
                      ,SEASON                                           
                      ,CODE_STATUS                                      
                      ,CODE_STATUS_DESC                                 
                      ,VERS_PRORATE_CD                                  
                      ,VERS_PRORATE_DESC                                
                      ,PROC_REQ_ID                                      
                      ,PROC_STATUS_CD                                   
                      ,PROC_STATUS_DESC                                 
                      ,LAST_UPDATE_TS                                   
                  )                                                     
                  VALUES                                                
                  (                                                     
                       :S-FACTOR-ID                                     
                      ,:S-FACTOR-DESC                                   
                      ,:S-DATE-FROM                                     
                      ,:S-DATE-TO                                       
                      ,:S-INT-DISP-START-DT                             
                      ,:S-INT-DISP-START-TM                             
                      ,:S-FACTOR                                        
                      ,:S-RATE-PLAN-NO                                  
                      ,:S-RATE-DESC                                     
                      ,:S-USER-ID-UPD-BY                                
                      ,:S-FULL-NAME                                     
                      ,:S-BLOCK-NO                                      
                      ,:S-RATE-CMPNT-DESC                               
                      ,:S-USE-CODE                                      
                      ,:S-TIME-PERIOD                                   
                      ,:S-SEASON                                        
                      ,:S-CODE-STATUS                                   
                      ,:S-CODE-STATUS-DESC                              
                      ,:S-VERS-PRORATE-CD                               
                      ,:S-VERS-PRORATE-DESC                             
                      ,:S-PROC-REQ-ID                                   
                      ,:S-PROC-STATUS-CD                                
                      ,:S-PROC-STATUS-DESC                              
                      ,:S-LAST-UPDATE-TS                                
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*           INSERT INTO SESSION.CSR04451_R1                               
MFA-TR*           (    FACTOR_ID                                                
MFA-TR*               ,FACTOR_DESC                                              
MFA-TR*               ,DATE_FROM                                                
MFA-TR*               ,DATE_TO                                                  
MFA-TR*               ,INT_DISP_START_DT                                        
MFA-TR*               ,INT_DISP_START_TM                                        
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,RATE_DESC                                                
MFA-TR*               ,USER_ID_UPD_BY                                           
MFA-TR*               ,FULL_NAME                                                
MFA-TR*               ,BLOCK_NO                                                 
MFA-TR*               ,RATE_CMPNT_DESC                                          
MFA-TR*               ,USE_CODE                                                 
MFA-TR*               ,TIME_PERIOD                                              
MFA-TR*               ,SEASON                                                   
MFA-TR*               ,CODE_STATUS                                              
MFA-TR*               ,CODE_STATUS_DESC                                         
MFA-TR*               ,VERS_PRORATE_CD                                          
MFA-TR*               ,VERS_PRORATE_DESC                                        
MFA-TR*               ,PROC_REQ_ID                                              
MFA-TR*               ,PROC_STATUS_CD                                           
MFA-TR*               ,PROC_STATUS_DESC                                         
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*           )                                                             
MFA-TR*           VALUES                                                        
MFA-TR*           (                                                             
MFA-TR*                :S-FACTOR-ID                                             
MFA-TR*               ,:S-FACTOR-DESC                                           
MFA-TR*               ,:S-DATE-FROM                                             
MFA-TR*               ,:S-DATE-TO                                               
MFA-TR*               ,:S-INT-DISP-START-DT                                     
MFA-TR*               ,:S-INT-DISP-START-TM                                     
MFA-TR*               ,:S-FACTOR                                                
MFA-TR*               ,:S-RATE-PLAN-NO                                          
MFA-TR*               ,:S-RATE-DESC                                             
MFA-TR*               ,:S-USER-ID-UPD-BY                                        
MFA-TR*               ,:S-FULL-NAME                                             
MFA-TR*               ,:S-BLOCK-NO                                              
MFA-TR*               ,:S-RATE-CMPNT-DESC                                       
MFA-TR*               ,:S-USE-CODE                                              
MFA-TR*               ,:S-TIME-PERIOD                                           
MFA-TR*               ,:S-SEASON                                                
MFA-TR*               ,:S-CODE-STATUS                                           
MFA-TR*               ,:S-CODE-STATUS-DESC                                      
MFA-TR*               ,:S-VERS-PRORATE-CD                                       
MFA-TR*               ,:S-VERS-PRORATE-DESC                                     
MFA-TR*               ,:S-PROC-REQ-ID                                           
MFA-TR*               ,:S-PROC-STATUS-CD                                        
MFA-TR*               ,:S-PROC-STATUS-DESC                                      
MFA-TR*               ,:S-LAST-UPDATE-TS                                        
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD 1                          TO CTR-ROWS                
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSR04451_R1'             TO TABLE-1                 
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * JOURNALING / ERROR HANDLING ROUTINE                            *        
      * 9900-SQL-ERROR-ROUTINE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00320                                                 
           END-EXEC.                                                            
                                                                        
