       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04450.                                         
COB303 DATE-WRITTEN.  APRIL 20, 2012                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00160013
      *                 P R O G R A M  S U M M A R Y                   *00170013
      *                                                                *00180013
      *  THIS PROCEDURE UPDATE/INSERT/DELETE ROWS IN RATE_DISCOUNT/    *00200037
      *  RATE_RIDER_EXP TABLES                                         *00200037
      *                                                                *00180013
      ******************************************************************00210013
      *ERROR CODES:                                                    *00210013
      *      291  - DELETE ALL EXPOSURE PERIODS FIRST                  *00210013
      *      294  - SYSTEM ERROR | CONTACT SYSTEM ADMINISTRATOR        *00210013
      ******************************************************************00210013
      *                                                                *00220013
      *                     PROGRAM MODIFICATION LOG                   *00230013
      *                                                                *00240013
      *    DATE    INITIALS   COMMENTS                                 *00250013
      *  --------  --------   ---------------------------------------  *00260013
      *  04/20/12  HA7A338    PROCEDURE ORIGINALLY CODED.              *00270037
      ******************************************************************00320013
      ******************************************************************00330013
      *                                                                *00340013
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350013
      *                                                                *00360013
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370013
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380013
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390013
      *  3000 - 4999  NOT USED                                         *00400013
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410013
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420013
      *  7000 - 7999  INPUT MODULES                                    *00430013
      *  8000 - 8999  OUTPUT MODULES                                   *00440013
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450013
      *                                                                *00460013
      ******************************************************************00470013
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04450'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04450 STARTS HERE'.                  
                                                                        
      ******************************************************************00560013
      *    DB2 INCLUDES                                                *00570013
      ******************************************************************00580013
           EXEC SQL                                                     00600013
              INCLUDE SQLCA                                             00610013
           END-EXEC.                                                    00620013
                                                                        
      ******************************************************************00632037
      *    CSS_RATE_DISCOUNT, J5                                       *00632037
      ******************************************************************00632037
           EXEC SQL                                                     00640013
              INCLUDE TBRTDISC                                          00650037
           END-EXEC.                                                    00660013
                                                                        
      ******************************************************************00670013
      *    CSS_RATE_RIDER_EXP, RZ                                      *00670013
      ******************************************************************00670013
           EXEC SQL                                                     00680043
              INCLUDE TBRTRDR                                           00690043
           END-EXEC.                                                    00700043
                                                                        
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090013
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************01126017
      *    ERROR HANDLING COPY BOOK.                                   *01126017
      ******************************************************************01126017
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
      ******************************************************************        
      *    ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                       
      ******************************************************************        
           COPY CWS00027.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************01240013
      *    WORK AREAS                                                  *01250013
      ******************************************************************01260013
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR04450'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                 PIC S9(9) COMP.                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS          PIC S9(9) COMP.                 
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WS-GENERAL-FIELDS.                                           
           05  WS-DISC-RATE-AMT-C       PIC X(09).                      
           05  WS-DISC-RATE-AMT-N REDEFINES WS-DISC-RATE-AMT-C          
                                        PIC S9(4)V9(5).                 
COB305     05 WS-DISC-RATE-AMT        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.   
           05  WS-DEL-EXP-ERRCD-291     PIC 9(04) VALUE 291.            
           05  WS-SYSTEM-ERRCD-294      PIC 9(04) VALUE 294.            
           05  S-APPL-RETURN-CODE       PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-RATE-CURTAILMENT-OPT  PIC X(01) VALUE 'C'.            
           05  WS-RATE-DISCOUNT-OPT     PIC X(01) VALUE 'V'.            
           05  WS-RIDER-EXP-EXIST       PIC X(01) VALUE 'N'.            
           05  WS-RIDER-EXIST           PIC X(01) VALUE 'N'.            
           05  WS-DISCOUNT              PIC X(01) VALUE 'D'.            
           05  WS-EXPOSURE              PIC X(01) VALUE 'E'.            
           05  WS-INSERT                PIC X(01) VALUE 'I'.            
           05  WS-UPDATE                PIC X(01) VALUE 'U'.            
           05  WS-DELETE                PIC X(01) VALUE 'D'.            
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID            PIC X(03).                      
       01  PARM-USER-ID                 PIC X(07).                      
       01  PARM-CODE-UTIL-TYPE          PIC X(01).                      
       01  PARM-RATE-PLAN-NO            PIC X(03).                      
       01  PARM-VERSION-NO-CNTRL        PIC X(04).                      
       01  PARM-ACTION-IND              PIC X(01).                      
       01  PARM-DISCOUNT-EXPOSURE-FL    PIC X(01).                      
       01  PARM-RATE-DISC-CD            PIC X(01).                      
       01  PARM-RATE-DISC-OPT           PIC X(01).                      
       01  PARM-DISC-RATE-AMT           PIC X(10).                      
       01  PARM-FROM-MONTH              PIC X(04).                      
       01  PARM-TO-MONTH                PIC X(04).                      
       01  PARM-FROM-HHMM               PIC X(04).                      
       01  PARM-TO-HHMM                 PIC X(04).                      
                                                                        
       PROCEDURE DIVISION USING                                         
                    PARM-APPL-PROG-ID                                   
                  , PARM-USER-ID                                        
                  , PARM-CODE-UTIL-TYPE                                 
                  , PARM-RATE-PLAN-NO                                   
                  , PARM-VERSION-NO-CNTRL                               
                  , PARM-ACTION-IND                                     
                  , PARM-DISCOUNT-EXPOSURE-FL                           
                  , PARM-RATE-DISC-CD                                   
                  , PARM-RATE-DISC-OPT                                  
                  , PARM-DISC-RATE-AMT                                  
                  , PARM-FROM-MONTH                                     
                  , PARM-TO-MONTH                                       
                  , PARM-FROM-HHMM                                      
                  , PARM-TO-HHMM                                        
                  .                                                     
                                                                        
      ******************************************************************02140013
      * 0000-MAINLINE                                                  *02150013
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160013
      ******************************************************************02170013
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02290013
      * 0100-INITIALIZE                                                *02300013
      *     1. RESET DB2 ERROR HANDLERS                                *02320013
      *                                                                *02360013
      ******************************************************************02370013
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
               SELECT                                                   
                  :S-RETURN-CODE       AS    RETURN_CODE                
                 ,:S-APPL-RETURN-CODE  AS    APPL_RETURN_CODE           
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE       AS    RETURN_CODE                        
MFA-TR*          ,:S-APPL-RETURN-CODE  AS    APPL_RETURN_CODE                   
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05116013
      * 2000-PROCESS-OUTPUT.                                           *05120013
      *     1. DESCRIBE RESULT SET                                     *05140013
      *     2. UPDATE DB2 DATA                                         *05150013
      *     3. SEND RESULT SET                                         *05170019
      ******************************************************************05190013
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE               THRU 5000-EXIT.            
           PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05300013
      * 2000A-MOVE-RESULT                                                       
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
            MOVE WS-ACTIVE-RETURN-CODE       TO S-RETURN-CODE.          
            ADD 1                            TO CTR-ROWS.               
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************05650013
      * 5000-UPDATE                                                    *05660013
      *     BASED ON DISCOUNT-EXPOSURE-FL & ACTION-IND THE APPROPRIATE *05675019
      *     PARA IS CALLED TO DO THE INSERT/UPDATE/DELETE              *05690019
      *     DISCOUNT-EXPOSEURE-FL - 'D'                                *05700032
      *       ACTION-IND - 'I' RATE_DISCOUNT TABLE INSERT              *05700032
      *       ACTION-IND - 'U' RATE_DISCOUNT TABLE UPDATE              *05700032
      *       ACTION-IND - 'D' RATE_DISCOUNT TABLE DELETE              *05700032
      *     DISCOUNT-EXPOSEURE-FL - 'E'                                *05700032
      *       ACTION-IND - 'I' RATE_RIDER_EXP TABLE INSERT             *05700032
      *       ACTION-IND - 'U' RATE_RIDER_EXP TABLE UPDATE             *05700032
      *       ACTION-IND - 'D' RATE_RIDER_EXP TABLE DELETE             *05700032
      ******************************************************************05710013
                                                                        
       5000-UPDATE.                                                     
                                                                        
           PERFORM 5100-FORMAT-ROW               THRU 5100-EXIT.        
                                                                        
           EVALUATE PARM-DISCOUNT-EXPOSURE-FL    ALSO PARM-ACTION-IND   
                                                                        
              WHEN WS-DISCOUNT ALSO WS-UPDATE                           
                 PERFORM 8100-UPDATE-RIDERDISC   THRU 8100-EXIT         
                                                                        
              WHEN WS-DISCOUNT ALSO WS-DELETE                           
                 PERFORM 8200-DELETE-RIDERDISC   THRU 8200-EXIT         
                 PERFORM 7000-CHECK-RIDERS       THRU 7000-EXIT         
                                                                        
                 IF WS-RIDER-EXIST           =  WS-NO                   
                    IF PARM-RATE-DISC-CD     =  WS-RATE-CURTAILMENT-OPT 
                       PERFORM 7100-CHECK-RIDER-EXP THRU 7100-EXIT      
                       IF WS-RIDER-EXP-EXIST =  WS-YES                  
                          MOVE WS-DEL-EXP-ERRCD-291                     
                                             TO S-APPL-RETURN-CODE      
                          PERFORM 8800-ABEND-PROGRAM THRU 8800-EXIT     
                       ELSE                                             
                          MOVE ZEROES        TO WS-ACTIVE-RETURN-CODE   
                       END-IF                                           
                    ELSE                                                
                       MOVE ZEROES           TO WS-ACTIVE-RETURN-CODE   
                    END-IF                                              
                 END-IF                                                 
                                                                        
              WHEN WS-DISCOUNT ALSO WS-INSERT                           
                 PERFORM 8300-INSERT-RIDERDISC   THRU 8300-EXIT         
                                                                        
              WHEN WS-EXPOSURE ALSO WS-UPDATE                           
                 PERFORM 8400-UPDATE-RIDEREXP    THRU 8400-EXIT         
                                                                        
              WHEN WS-EXPOSURE ALSO WS-DELETE                           
                 PERFORM 8500-DELETE-RIDEREXP    THRU 8500-EXIT         
                                                                        
              WHEN WS-EXPOSURE ALSO WS-INSERT                           
                 PERFORM 7000-CHECK-RIDERS       THRU 7000-EXIT         
                                                                        
                 IF WS-RIDER-EXIST           = WS-YES                   
                    PERFORM 8600-INSERT-RIDEREXP THRU 8600-EXIT         
                 ELSE                                                   
                    MOVE WS-SYSTEM-ERRCD-294 TO S-APPL-RETURN-CODE      
                    PERFORM 8800-ABEND-PROGRAM   THRU 8800-EXIT         
                 END-IF                                                 
                                                                        
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10961019
      * 5100-FORMAT-ROW                                                *10962019
      *     FORMATS THE CSS_RATE_DISCOUNT & CSS_RATE_RIDER_EXP ROWS FROM10967038
      *     THE PASSED PARM VALUES                                     *10967038
      ******************************************************************10969019
                                                                        
       5100-FORMAT-ROW.                                                 
                                                                        
           IF PARM-DISC-RATE-AMT > SPACES                               
              MOVE  PARM-DISC-RATE-AMT       TO  WS-DISC-RATE-AMT-C     
              MOVE  WS-DISC-RATE-AMT-N       TO  WS-DISC-RATE-AMT       
              MOVE  WS-DISC-RATE-AMT         TO  J5-DISC-RATE-AMT       
           ELSE                                                         
              MOVE  ZEROES                   TO  J5-DISC-RATE-AMT       
           END-IF.                                                      
           MOVE  PARM-CODE-UTIL-TYPE         TO  J5-CODE-UTIL-TYPE      
                                                 RZ-CODE-UTIL-TYPE.     
           MOVE  PARM-RATE-PLAN-NO           TO  J5-RATE-PLAN-NO        
                                                 RZ-RATE-PLAN-NO.       
           MOVE  PARM-VERSION-NO-CNTRL       TO  J5-VERSION-NO-CNTRL    
                                                 RZ-VERSION-NO-CNTRL.   
           MOVE  PARM-RATE-DISC-CD           TO  J5-RATE-DISC-CD.       
           MOVE  PARM-RATE-DISC-OPT          TO  J5-RATE-DISC-OPT.      
           MOVE  PARM-FROM-MONTH             TO  RZ-FROM-MONTH.         
           MOVE  PARM-TO-MONTH               TO  RZ-TO-MONTH.           
           MOVE  PARM-FROM-HHMM              TO  RZ-FROM-HHMM.          
           MOVE  PARM-TO-HHMM                TO  RZ-TO-HHMM.            
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 10972013
      * 7000-CHECK-RIDERS                                             * 10980038
      *     CHECK IF ROW EXIST IN RATE_DISCOUNT TABLE                 * 10985038
      ***************************************************************** 10990013
                                                                        
       7000-CHECK-RIDERS.                                               
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-RIDER-EXIST                                    
                FROM  CSS_RATE_DISCOUNT J5 WITH(READUNCOMMITTED)                
               WHERE  J5.CODE_UTIL_TYPE     = :J5-CODE-UTIL-TYPE        
                 AND  J5.RATE_PLAN_NO       = :J5-RATE-PLAN-NO          
                 AND  J5.VERSION_NO_CNTRL   = :J5-VERSION-NO-CNTRL      
                 AND  J5.RATE_DISC_CD       = :WS-RATE-CURTAILMENT-OPT  
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04450000
MFA-TR*       SELECT 'Y'                                                04460000
MFA-TR*         INTO :WS-RIDER-EXIST                                    04470000
MFA-TR*         FROM  CSS_RATE_DISCOUNT J5                              04480000
MFA-TR*        WHERE  J5.CODE_UTIL_TYPE     = :J5-CODE-UTIL-TYPE        04490000
MFA-TR*          AND  J5.RATE_PLAN_NO       = :J5-RATE-PLAN-NO          04500000
MFA-TR*          AND  J5.VERSION_NO_CNTRL   = :J5-VERSION-NO-CNTRL      04510000
MFA-TR*          AND  J5.RATE_DISC_CD       = :WS-RATE-CURTAILMENT-OPT  04520000
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    04530000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_DISCOUNT'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'RATE_DISC_CD'            TO TABLE-ELEMENT-4         
              MOVE PARM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1       
              MOVE PARM-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-2       
              MOVE PARM-VERSION-NO-CNTRL     TO HOSTVAR-ELEMENT-3       
              MOVE WS-RATE-CURTAILMENT-OPT   TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 10972013
      * 7100-CHECK-RIDER-EXP                                          * 10980038
      *     CHECK IF ROW EXIST IN RATE_RIDER_EXP TABLE                * 10985038
      ***************************************************************** 10990013
                                                                        
       7100-CHECK-RIDER-EXP.                                            
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-RIDER-EXP-EXIST                               
                 FROM  CSS_RATE_RIDER_EXP RZ WITH(READUNCOMMITTED)              
                WHERE  RZ.CODE_UTIL_TYPE     = :RZ-CODE-UTIL-TYPE       
                  AND  RZ.RATE_PLAN_NO       = :RZ-RATE-PLAN-NO         
                  AND  RZ.VERSION_NO_CNTRL   = :RZ-VERSION-NO-CNTRL     
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10980145
MFA-TR*        SELECT 'Y'                                               10980245
MFA-TR*          INTO :WS-RIDER-EXP-EXIST                               10980345
MFA-TR*          FROM  CSS_RATE_RIDER_EXP RZ                            10980445
MFA-TR*         WHERE  RZ.CODE_UTIL_TYPE     = :RZ-CODE-UTIL-TYPE       10980545
MFA-TR*           AND  RZ.RATE_PLAN_NO       = :RZ-RATE-PLAN-NO         10980645
MFA-TR*           AND  RZ.VERSION_NO_CNTRL   = :RZ-VERSION-NO-CNTRL     10980745
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                    10980845

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_RIDER_EXP'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE PARM-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-1       
              MOVE PARM-RATE-PLAN-NO         TO HOSTVAR-ELEMENT-2       
              MOVE PARM-VERSION-NO-CNTRL     TO HOSTVAR-ELEMENT-3       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 10972013
      * 8100-UPDATE-RIDERDISC                                         * 10980038
      *     UPDATES CSS_RATE_DISCOUNT.                                * 10985038
      ***************************************************************** 10990013
                                                                        
       8100-UPDATE-RIDERDISC.                                           
                                                                        
           MOVE '8100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_DISCOUNT                                  
              SET    DISC_RATE_AMT      = :J5-DISC-RATE-AMT             
              WHERE  CODE_UTIL_TYPE     = :J5-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO       = :J5-RATE-PLAN-NO              
              AND    VERSION_NO_CNTRL   = :J5-VERSION-NO-CNTRL          
              AND    RATE_DISC_CD       = :J5-RATE-DISC-CD              
              AND    RATE_DISC_OPT      = :J5-RATE-DISC-OPT             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_DISCOUNT'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'RATE_DISC_CD'            TO TABLE-ELEMENT-4         
              MOVE J5-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J5-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J5-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE J5-RATE-DISC-CD           TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 11640013
      * 8200-DELETE-RIDERDISC                                         * 11650038
      *     DELETES CSS_RATE_DISCOUNT.                                * 11656038
      ***************************************************************** 11660013
                                                                        
       8200-DELETE-RIDERDISC.                                           
                                                                        
           MOVE '8200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_RATE_DISCOUNT                             
              WHERE  CODE_UTIL_TYPE     = :J5-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO       = :J5-RATE-PLAN-NO              
              AND    VERSION_NO_CNTRL   = :J5-VERSION-NO-CNTRL          
              AND    RATE_DISC_CD       = :J5-RATE-DISC-CD              
              AND    RATE_DISC_OPT      = :J5-RATE-DISC-OPT             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_DISCOUNT'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'RATE_DISC_CD'            TO TABLE-ELEMENT-4         
              MOVE J5-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J5-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J5-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE J5-RATE-DISC-CD           TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 12541032
      * 8300-INSERT-RIDERDISC                                         * 12542038
      *     INSERTS CSS_RATE_DISCOUNT.                                * 12548038
      ***************************************************************** 12549032
                                                                        
       8300-INSERT-RIDERDISC.                                           
                                                                        
           MOVE '8300'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_DISCOUNT                             
                    (CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,VERSION_NO_CNTRL                                   
                    ,RATE_DISC_CD                                       
                    ,RATE_DISC_OPT                                      
                    ,DISC_RATE_AMT)                                     
              VALUES                                                    
                   (:J5-CODE-UTIL-TYPE                                  
                   ,:J5-RATE-PLAN-NO                                    
                   ,:J5-VERSION-NO-CNTRL                                
                   ,:J5-RATE-DISC-CD                                    
                   ,:J5-RATE-DISC-OPT                                   
                   ,:J5-DISC-RATE-AMT)                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_DISCOUNT'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'RATE_DISC_CD'            TO TABLE-ELEMENT-4         
              MOVE J5-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE J5-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE J5-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE J5-RATE-DISC-CD           TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 04830000
      * 8400-UPDATE-RIDEREXP                                          * 04840000
      *     UPDATES CSS_RATE_RIDER_EXP.                               * 04900000
      ***************************************************************** 04910000
                                                                        
       8400-UPDATE-RIDEREXP.                                            
                                                                        
           MOVE '8400'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_RATE_RIDER_EXP                                 
              SET    TO_MONTH           = :RZ-TO-MONTH                  
                    ,TO_HHMM            = :RZ-TO-HHMM                   
              WHERE  CODE_UTIL_TYPE     = :RZ-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO       = :RZ-RATE-PLAN-NO              
              AND    VERSION_NO_CNTRL   = :RZ-VERSION-NO-CNTRL          
              AND    FROM_MONTH         = :RZ-FROM-MONTH                
              AND    FROM_HHMM          = :RZ-FROM-HHMM                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_RIDER_EXP'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'FROM_MONTH'              TO TABLE-ELEMENT-4         
              MOVE RZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RZ-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RZ-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RZ-FROM-MONTH             TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 05320000
      * 8500-DELETE-RIDEREXP                                          * 05330000
      *     DELETES CSS_RATE_RIDER_EXP.                               * 05390000
      ***************************************************************** 05400000
                                                                        
       8500-DELETE-RIDEREXP.                                            
                                                                        
           MOVE '8500'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_RATE_RIDER_EXP                            
              WHERE  CODE_UTIL_TYPE     = :RZ-CODE-UTIL-TYPE            
              AND    RATE_PLAN_NO       = :RZ-RATE-PLAN-NO              
              AND    VERSION_NO_CNTRL   = :RZ-VERSION-NO-CNTRL          
              AND    FROM_MONTH         = :RZ-FROM-MONTH                
              AND    FROM_HHMM          = :RZ-FROM-HHMM                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_RIDER_EXP'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'FROM_MONTH'              TO TABLE-ELEMENT-4         
              MOVE RZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RZ-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RZ-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RZ-FROM-MONTH             TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 05790000
      * 8600-INSERT-RIDEREXP                                          * 05800000
      *     INSERTS CSS_RATE_RIDER_EXP.                               * 05860000
      ***************************************************************** 05870000
                                                                        
       8600-INSERT-RIDEREXP.                                            
                                                                        
           MOVE '8600'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_RIDER_EXP                            
                    (CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,VERSION_NO_CNTRL                                   
                    ,FROM_MONTH                                         
                    ,TO_MONTH                                           
                    ,FROM_HHMM                                          
                    ,TO_HHMM)                                           
              VALUES                                                    
                   (:RZ-CODE-UTIL-TYPE                                  
                   ,:RZ-RATE-PLAN-NO                                    
                   ,:RZ-VERSION-NO-CNTRL                                
                   ,:RZ-FROM-MONTH                                      
                   ,:RZ-TO-MONTH                                        
                   ,:RZ-FROM-HHMM                                       
                   ,:RZ-TO-HHMM)                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_RIDER_EXP'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'VERSION_NO_CNTRL'        TO TABLE-ELEMENT-3         
              MOVE 'FROM_MONTH'              TO TABLE-ELEMENT-4         
              MOVE RZ-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE RZ-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE RZ-VERSION-NO-CNTRL       TO HOSTVAR-ELEMENT-3       
              MOVE RZ-FROM-MONTH             TO HOSTVAR-ELEMENT-4       
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
      ***************************************************************** 05320000
      * 8800-ABEND-PROGRAM                                            * 05330000
      *     DELETES CSS_RATE_RIDER_EXP.                               * 05390000
      ***************************************************************** 05400000
                                                                        
       8800-ABEND-PROGRAM.                                              
                                                                        
           ADD 1                             TO CTR-ROWS.               
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT.            
           PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT.            
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************12557013
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     12560013
      ******************************************************************12570013
           EXEC SQL                                                     12580013
              INCLUDE CPDSP300                                          12590013
           END-EXEC.                                                    12600013
                                                                        
      ******************************************************************12620013
      *       END PROGRAM COPYLIB                                      *12630013
      ******************************************************************12640013
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
                                                                        
