       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04449.                                         
COB303 DATE-WRITTEN.  APRIL 17, 2012.                                   
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                 SOUTH CAROLINA ELECTRIC & GAS              --         
      *----------------------------------------------------------------         
      *--                  STORED PROCEDURE:  CSR04449               --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04449 :                                                --         
      *--                                                            --         
      *--     INVOKED FROM RMM WIZARD TO RETRIEVE RIDERS/DISCOUNTS   --         
      *--     AND EXPOSURE PERIODS FOR A PARTICULAR RATE VERSION.    --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--           APPL_PROG_ID            CHAR(03)                 --         
      *--           USER_ID                 CHAR(07)                 --         
      *--           CODE_UTIL_TYPE          CHAR(01)                 --         
      *--           RATE_PLAN_NO            CHAR(03)                 --         
      *--           VERSION_NO_CNTRL        CHAR(04)                 --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--           NONE                                             --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04449_R1 - RIDERS AND DISCOUNTS.                --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           RATE_OPT_IND            CHAR(01)                 --         
      *--           RATE_DISC_CD            CHAR(01)                 --         
      *--           RATE_DISC_DESC          CHAR(80)                 --         
      *--           RATE_DISC_OPT           CHAR(01)                 --         
      *--           RATE_DISC_OPT_DESC      CHAR(20)                 --         
      *--           DISC_RATE_AMT           DECIMAL(09,5)            --         
      *--                                                            --         
      *--      2. CSR04449_R2 - EXPOSURE PERIODS.                    --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           FROM_MONTH              SMALLINT                 --         
      *--           TO_MONTH                SMALLINT                 --         
      *--           FROM_HHMM               SMALLINT                 --         
      *--           TO_HHMM                 SMALLINT                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                      MODIFICATION LOG                      --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00639*--  04/17/2012    SS97726     PROCEDURE ORIGINALLY CODED.     --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04449'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                          PIC X(40) VALUE             
            'WORKING STORAGE FOR CSR04449 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04449'. 
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                       PIC S9(9) COMP.             
           05  PARM-CODE-UTIL-TYPE          PIC X(01).                  
           05  PARM-RATE-PLAN-NO            PIC X(03).                  
           05  PARM-VERSION-NO-CNTRL        PIC X(04).                  
           05  PARM-VERSION-NO-CNTRL-NUM REDEFINES PARM-VERSION-NO-CNTRL
                                            PIC 9(04).                  
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-YES                       PIC X(01) VALUE 'Y'.        
           05  WS-NO                        PIC X(01) VALUE 'N'.        
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(4) VALUE 0.          
           05  WS-RATE-OPT-IND              PIC X(1)  VALUE SPACE.      
           05  WS-RATE-DISC-DESC            PIC X(80) VALUE SPACES.     
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  WS-NO-MORE-ROWS              PIC X(01) VALUE 'N'.        
               88  NO-MORE-ROWS                       VALUE 'Y'.        
      *                                                                         
       01  WS-FLAGS.                                                    
           05 WS-ERR-INSRT-R1               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R2               PIC X(01) VALUE 'N'.        
                                                                        
      ******************************************************************        
      *    ERROR PROCESSING VARIABLES                                  *        
      ******************************************************************        
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                    PIC X(18) VALUE SPACES.     
           10  S-SQLCODE                    PIC S9(9) COMP VALUE 0.     
           10  S-SQLSTATE                   PIC X(5)  VALUE ' '.        
           10  S-TABLE-NAME                 PIC X(18) VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L       PIC S9(4) USAGE COMP.       
               49  S-HOST-VARIABLES-V       PIC X(255).                 
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L        PIC S9(4) USAGE COMP.       
               49  S-SQL-STATEMENT-V        PIC X(255).                 
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L      PIC S9(4) USAGE COMP.       
               49  S-SQL-DESCRIPTION-V      PIC X(255).                 
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L      PIC S9(4) USAGE COMP.       
               49  WS-ABEND-SQLERRMC-V      PIC X(255).                 
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR RIDERS AND DISCOUNTS.                   *        
      ******************************************************************        
          05 S-RETURN-CODE                  PIC S9(4) COMP VALUE 0.     
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(4) COMP VALUE 0.     
             10 S-APPL-RETURN-CODE-1        PIC S9(4) COMP VALUE 0.     
             10 S-RS1-RATE-OPT-IND          PIC X(01).                  
             10 S-RS1-RATE-DISC-CD          PIC X(01).                  
             10 S-RS1-RATE-DISC-DESC        PIC X(80).                  
             10 S-RS1-RATE-DISC-OPT         PIC X(01).                  
             10 S-RS1-RATE-DISC-OPT-DESC    PIC X(20).                  
COB305       10 S-RS1-DISC-RATE-AMT        PIC S9(4)V9(5) COMP-3 
COB305          VALUE 0.      
                                                                        
      ******************************************************************        
      *   GTT TABLE LAYOUT FOR EXPOSURE PERIODS.                       *        
      ******************************************************************        
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(4) COMP VALUE 0.     
             10 S-APPL-RETURN-CODE-2        PIC S9(4) COMP VALUE 0.     
             10 S-RS2-FROM-MONTH            PIC S9(4) COMP VALUE 0.     
             10 S-RS2-TO-MONTH              PIC S9(4) COMP VALUE 0.     
             10 S-RS2-FROM-HHMM             PIC S9(4) COMP VALUE 0.     
             10 S-RS2-TO-HHMM               PIC S9(4) COMP VALUE 0.     
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_DISCOUNT  (J5)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTDISC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_OPT_DESC  (O1)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTOPTD                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_RATE_RIDER_EXP (RZ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTRDR                                                   
           END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *    CSS_CODE_VALUE (UV)                                         *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH ALL THE RIDERS AND DISCOUNTS    *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE RIDER_DISCOUNT CURSOR FOR                        
                SELECT 'Y'                                              
                      , J5.RATE_DISC_CD                                 
                      , UV.CODE_LONG_DESC                               
                      , J5.RATE_DISC_OPT                                
                      , O1.RATE_DISC_OPT_DESC                           
                      , J5.DISC_RATE_AMT                                
                      , UV.SORT_ORDER                                   
                  FROM  CSS_RATE_DISCOUNT  J5 WITH(READUNCOMMITTED)             
                      , CSS_RATE_OPT_DESC  O1 WITH(READUNCOMMITTED)             
                      , CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                 
                 WHERE  J5.CODE_UTIL_TYPE   = :J5-CODE-UTIL-TYPE        
                   AND  J5.RATE_PLAN_NO     = :J5-RATE-PLAN-NO          
                   AND  J5.VERSION_NO_CNTRL = :J5-VERSION-NO-CNTRL      
                   AND  J5.RATE_DISC_CD     =  O1.RATE_DISC_CD          
                   AND  J5.RATE_DISC_OPT    =  O1.RATE_DISC_OPT         
                   AND  UV.CODE_VALUE       =  O1.RATE_DISC_CD          
                   AND  UV.COLUMN_NA        = 'RATE_DISC_CD'            
                   AND  UV.TABLE_NA         = 'CSS_RATE_OPT_DESC'       
                   AND  UV.COMPANY_NO       = '01'                      
                   AND  UV.PROGRAM_ID       = 'ALL'                     
                                                                        
                 UNION  ALL                                             
                                                                        
                SELECT 'N'                                              
                      , O1.RATE_DISC_CD                                 
                      , UV.CODE_LONG_DESC                               
                      , O1.RATE_DISC_OPT                                
                      , O1.RATE_DISC_OPT_DESC                           
                      , 0.00                                            
                      , UV.SORT_ORDER                                   
                  FROM  CSS_RATE_OPT_DESC  O1 WITH(READUNCOMMITTED)             
                       ,CSS_CODE_VALUE UV WITH(READUNCOMMITTED)                 
                 WHERE  NOT EXISTS                                      
                     (SELECT  'Y'                                       
                        FROM  CSS_RATE_DISCOUNT  J5
                           WITH(READUNCOMMITTED)                     
                       WHERE  J5.CODE_UTIL_TYPE   = :J5-CODE-UTIL-TYPE  
                         AND  J5.RATE_PLAN_NO     = :J5-RATE-PLAN-NO    
                         AND  J5.VERSION_NO_CNTRL = :J5-VERSION-NO-CNTRL
                         AND  J5.RATE_DISC_CD     =  O1.RATE_DISC_CD    
                         AND  J5.RATE_DISC_OPT    =  O1.RATE_DISC_OPT)  
                    AND  UV.CODE_VALUE       =  O1.RATE_DISC_CD         
                    AND  UV.COLUMN_NA        = 'RATE_DISC_CD'           
                    AND  UV.TABLE_NA         = 'CSS_RATE_OPT_DESC'      
                    AND  UV.COMPANY_NO       = '01'                     
                    AND  UV.PROGRAM_ID       = 'ALL'                    
                   ORDER BY 7, 4                                        
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RIDER_DISCOUNT CURSOR FOR                                
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*               , J5.RATE_DISC_CD                                         
MFA-TR*               , UV.CODE_LONG_DESC                                       
MFA-TR*               , J5.RATE_DISC_OPT                                        
MFA-TR*               , O1.RATE_DISC_OPT_DESC                                   
MFA-TR*               , J5.DISC_RATE_AMT                                        
MFA-TR*               , UV.SORT_ORDER                                           
MFA-TR*           FROM  CSS_RATE_DISCOUNT  J5                                   
MFA-TR*               , CSS_RATE_OPT_DESC  O1                                   
MFA-TR*               , CSS_CODE_VALUE UV                                       
MFA-TR*          WHERE  J5.CODE_UTIL_TYPE   = :J5-CODE-UTIL-TYPE                
MFA-TR*            AND  J5.RATE_PLAN_NO     = :J5-RATE-PLAN-NO                  
MFA-TR*            AND  J5.VERSION_NO_CNTRL = :J5-VERSION-NO-CNTRL              
MFA-TR*            AND  J5.RATE_DISC_CD     =  O1.RATE_DISC_CD                  
MFA-TR*            AND  J5.RATE_DISC_OPT    =  O1.RATE_DISC_OPT                 
MFA-TR*            AND  UV.CODE_VALUE       =  O1.RATE_DISC_CD                  
MFA-TR*            AND  UV.COLUMN_NA        = 'RATE_DISC_CD'                    
MFA-TR*            AND  UV.TABLE_NA         = 'CSS_RATE_OPT_DESC'               
MFA-TR*            AND  UV.COMPANY_NO       = '01'                              
MFA-TR*            AND  UV.PROGRAM_ID       = 'ALL'                             
MFA-TR*                                                                         
MFA-TR*          UNION  ALL                                                     
MFA-TR*                                                                         
MFA-TR*         SELECT 'N'                                                      
MFA-TR*               , O1.RATE_DISC_CD                                         
MFA-TR*               , UV.CODE_LONG_DESC                                       
MFA-TR*               , O1.RATE_DISC_OPT                                        
MFA-TR*               , O1.RATE_DISC_OPT_DESC                                   
MFA-TR*               , 0.00                                                    
MFA-TR*               , UV.SORT_ORDER                                           
MFA-TR*           FROM  CSS_RATE_OPT_DESC  O1                                   
MFA-TR*                ,CSS_CODE_VALUE UV                                       
MFA-TR*          WHERE  NOT EXISTS                                              
MFA-TR*              (SELECT  'Y'                                               
MFA-TR*                 FROM  CSS_RATE_DISCOUNT  J5                             
MFA-TR*                WHERE  J5.CODE_UTIL_TYPE   = :J5-CODE-UTIL-TYPE          
MFA-TR*                  AND  J5.RATE_PLAN_NO     = :J5-RATE-PLAN-NO            
MFA-TR*                  AND  J5.VERSION_NO_CNTRL = :J5-VERSION-NO-CNTRL        
MFA-TR*                  AND  J5.RATE_DISC_CD     =  O1.RATE_DISC_CD            
MFA-TR*                  AND  J5.RATE_DISC_OPT    =  O1.RATE_DISC_OPT)          
MFA-TR*             AND  UV.CODE_VALUE       =  O1.RATE_DISC_CD                 
MFA-TR*             AND  UV.COLUMN_NA        = 'RATE_DISC_CD'                   
MFA-TR*             AND  UV.TABLE_NA         = 'CSS_RATE_OPT_DESC'              
MFA-TR*             AND  UV.COMPANY_NO       = '01'                             
MFA-TR*             AND  UV.PROGRAM_ID       = 'ALL'                            
MFA-TR*            ORDER BY 7, 4                                                
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH EXPOSURE PERIODS.               *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE RIDER_EXPOSURE CURSOR FOR                        
                SELECT  RZ.FROM_MONTH                                   
                      , RZ.TO_MONTH                                     
                      , RZ.FROM_HHMM                                    
                      , RZ.TO_HHMM                                      
                  FROM  CSS_RATE_RIDER_EXP RZ WITH(READUNCOMMITTED)             
                 WHERE  RZ.CODE_UTIL_TYPE   = :RZ-CODE-UTIL-TYPE        
                   AND  RZ.RATE_PLAN_NO     = :RZ-RATE-PLAN-NO          
                   AND  RZ.VERSION_NO_CNTRL = :RZ-VERSION-NO-CNTRL      
                 ORDER BY RZ.FROM_MONTH                                 
                         ,RZ.TO_MONTH                                   
                         ,RZ.FROM_HHMM                                  
                         ,RZ.TO_HHMM                                    
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RIDER_EXPOSURE CURSOR FOR                                
MFA-TR*         SELECT  RZ.FROM_MONTH                                           
MFA-TR*               , RZ.TO_MONTH                                             
MFA-TR*               , RZ.FROM_HHMM                                            
MFA-TR*               , RZ.TO_HHMM                                              
MFA-TR*           FROM  CSS_RATE_RIDER_EXP RZ                                   
MFA-TR*          WHERE  RZ.CODE_UTIL_TYPE   = :RZ-CODE-UTIL-TYPE                
MFA-TR*            AND  RZ.RATE_PLAN_NO     = :RZ-RATE-PLAN-NO                  
MFA-TR*            AND  RZ.VERSION_NO_CNTRL = :RZ-VERSION-NO-CNTRL              
MFA-TR*          ORDER BY RZ.FROM_MONTH                                         
MFA-TR*                  ,RZ.TO_MONTH                                           
MFA-TR*                  ,RZ.FROM_HHMM                                          
MFA-TR*                  ,RZ.TO_HHMM                                            
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  I-APPL-PROG-ID                   PIC  X(03).                 
       01  I-USER-ID                        PIC  X(07).                 
       01  I-CODE-UTIL-TYPE                 PIC  X(01).                 
       01  I-RATE-PLAN-NO                   PIC  X(03).                 
       01  I-VERSION-NO-CNTRL               PIC  X(04).                 
      *                                                                         
       PROCEDURE DIVISION USING I-APPL-PROG-ID                          
                               ,I-USER-ID                               
                               ,I-CODE-UTIL-TYPE                        
                               ,I-RATE-PLAN-NO                          
                               ,I-VERSION-NO-CNTRL.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1  -  RIDERS AND DISCOUNTS                  *        
      ******************************************************************        
                                                                        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04449_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04449_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04449_R1
              (                                                      
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,RATE_OPT_IND CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DISC_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DISC_DESC CHAR(80)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DISC_OPT CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_DISC_OPT_DESC CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISC_RATE_AMT           DECIMAL(9,5)                
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(RATE_OPT_IND))       AS RATE_OPT_IND        
                      ,LTRIM(RTRIM(RATE_DISC_CD))       AS RATE_DISC_CD        
                      ,LTRIM(RTRIM(RATE_DISC_DESC))     AS 
           RATE_DISC_DESC      
                      ,LTRIM(RTRIM(RATE_DISC_OPT))      AS RATE_DISC_OPT       
                      ,LTRIM(RTRIM(RATE_DISC_OPT_DESC)) AS 
           RATE_DISC_OPT_DESC  
                      ,DISC_RATE_AMT             AS DISC_RATE_AMT       
                  FROM #CSR04449_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(RATE_OPT_IND)       AS RATE_OPT_IND                
MFA-TR*               ,STRIP(RATE_DISC_CD)       AS RATE_DISC_CD                
MFA-TR*               ,STRIP(RATE_DISC_DESC)     AS RATE_DISC_DESC              
MFA-TR*               ,STRIP(RATE_DISC_OPT)      AS RATE_DISC_OPT               
MFA-TR*               ,STRIP(RATE_DISC_OPT_DESC) AS RATE_DISC_OPT_DESC          
MFA-TR*               ,DISC_RATE_AMT             AS DISC_RATE_AMT               
MFA-TR*           FROM SESSION.CSR04449_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2 - RIDER EXPOSURE PERIODS                  *        
      ******************************************************************        
                                                                        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04449_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04449_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04449_R2
              (                                                      
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,FROM_MONTH              SMALLINT                    
                   ,TO_MONTH                SMALLINT                    
                   ,FROM_HHMM               SMALLINT                    
                   ,TO_HHMM                 SMALLINT                    
                 )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,FROM_MONTH                                       
                      ,TO_MONTH                                         
                      ,FROM_HHMM                                        
                      ,TO_HHMM                                          
                  FROM #CSR04449_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,FROM_MONTH                                               
MFA-TR*               ,TO_MONTH                                                 
MFA-TR*               ,FROM_HHMM                                                
MFA-TR*               ,TO_HHMM                                                  
MFA-TR*           FROM SESSION.CSR04449_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE I-CODE-UTIL-TYPE            TO PARM-CODE-UTIL-TYPE.     
           MOVE I-RATE-PLAN-NO              TO PARM-RATE-PLAN-NO.       
           MOVE I-VERSION-NO-CNTRL          TO PARM-VERSION-NO-CNTRL.   
                                                                        
           PERFORM 1100-VALIDATE-INPUT         THRU 1100-EXIT.          
                                                                        
           MOVE PARM-CODE-UTIL-TYPE         TO J5-CODE-UTIL-TYPE        
                                               RZ-CODE-UTIL-TYPE.       
           MOVE PARM-RATE-PLAN-NO           TO J5-RATE-PLAN-NO          
                                               RZ-RATE-PLAN-NO.         
           MOVE PARM-VERSION-NO-CNTRL-NUM   TO J5-VERSION-NO-CNTRL      
                                               RZ-VERSION-NO-CNTRL.     
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * VALIDATION FOR INPUT VARIABLES                                 *        
      ******************************************************************        
                                                                        
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF PARM-CODE-UTIL-TYPE            > SPACES AND               
                   PARM-RATE-PLAN-NO         > SPACES AND               
                   PARM-VERSION-NO-CNTRL-NUM > 0                        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '1100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'RECEIVE INPUT'          TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE SPACES                   TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
                                                                        
      * WHEN INPUT PARAMETERS ARE INVALID PASS APPROPRIATE RETURN CODE          
              MOVE +0                       TO WS-ACTIVE-RETURN-CODE    
              MOVE +1000                    TO WS-APPL-RETURN-CODE      
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      * PROCESS ALL RIDERS AND DISCOUNT.                                        
           MOVE 'N'                         TO WS-NO-MORE-ROWS.         
           PERFORM 7000-OPEN-RIDER-DISCOUNT    THRU 7000-EXIT.          
           PERFORM 7100-FETCH-RIDER-DISCOUNT   THRU 7100-EXIT.          
           PERFORM 2100-PROCESS-RIDERS         THRU 2100-EXIT           
                                               UNTIL NO-MORE-ROWS.      
           PERFORM 7200-CLOSE-RIDER-DISCOUNT   THRU 7200-EXIT.          
                                                                        
      * PROCESS ALL EXPOSURE PERIODS FOR RIDERS.                                
           MOVE 'N'                         TO WS-NO-MORE-ROWS.         
           PERFORM 7300-OPEN-RIDER-EXPOSURE    THRU 7300-EXIT.          
           PERFORM 7400-FETCH-RIDER-EXPOSURE   THRU 7400-EXIT.          
           PERFORM 2200-PROCESS-EXPOSURE       THRU 2200-EXIT           
                                               UNTIL NO-MORE-ROWS.      
           PERFORM 7500-CLOSE-RIDER-EXPOSURE   THRU 7500-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET DETAILS FOR ALL RIDERS AND DISCOUNTS.                      *        
      ******************************************************************        
                                                                        
       2100-PROCESS-RIDERS.                                             
                                                                        
           PERFORM 2100A-MOVE-RIDERS-RS1       THRU 2100A-EXIT.         
           PERFORM 7100-FETCH-RIDER-DISCOUNT   THRU 7100-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100A-MOVE-RIDERS-RS1.                                         *        
      ******************************************************************        
                                                                        
       2100A-MOVE-RIDERS-RS1.                                           
                                                                        
           MOVE WS-RATE-OPT-IND             TO S-RS1-RATE-OPT-IND       
           MOVE J5-RATE-DISC-CD             TO S-RS1-RATE-DISC-CD       
           MOVE WS-RATE-DISC-DESC           TO S-RS1-RATE-DISC-DESC     
           MOVE J5-RATE-DISC-OPT            TO S-RS1-RATE-DISC-OPT      
           MOVE O1-RATE-DISC-OPT-DESC       TO S-RS1-RATE-DISC-OPT-DESC 
           MOVE J5-DISC-RATE-AMT            TO S-RS1-DISC-RATE-AMT      
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
       2100A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET DETAILS FOR EXPOSURE PERIODS FOR RATE RIDERS.              *        
      ******************************************************************        
                                                                        
       2200-PROCESS-EXPOSURE.                                           
                                                                        
           PERFORM 2200A-MOVE-EXPOSURE-RS2     THRU 2200A-EXIT.         
           PERFORM 7400-FETCH-RIDER-EXPOSURE   THRU 7400-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200A-MOVE-EXPOSURE-RS2.                                       *        
      ******************************************************************        
                                                                        
       2200A-MOVE-EXPOSURE-RS2.                                         
                                                                        
           MOVE RZ-FROM-MONTH               TO S-RS2-FROM-MONTH         
           MOVE RZ-TO-MONTH                 TO S-RS2-TO-MONTH           
           MOVE RZ-FROM-HHMM                TO S-RS2-FROM-HHMM          
           MOVE RZ-TO-HHMM                  TO S-RS2-TO-HHMM            
                                                                        
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       2200A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7000-OPEN-RIDER-DISCOUNT.                                     *        
      ******************************************************************        
                                                                        
       7000-OPEN-RIDER-DISCOUNT.                                        
                                                                        
           EXEC SQL                                                     
               OPEN RIDER_DISCOUNT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_DISCOUNT'      TO TABLE-1                  
              MOVE 'CSS_RATE_OPT_DESC'      TO TABLE-2                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'VERSION_NO_CNTRL'       TO TABLE-ELEMENT-3          
              MOVE J5-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE J5-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE J5-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET ALL THE RIDERS AND DISCOUNTS BASED ON THE RATE PLAN        *        
      * 7100-FETCH-RIDER-DISCOUNT.                                     *        
      ******************************************************************        
                                                                        
       7100-FETCH-RIDER-DISCOUNT.                                       
                                                                        
           EXEC SQL                                                     
               FETCH RIDER_DISCOUNT                                     
                INTO :WS-RATE-OPT-IND                                   
                    ,:J5-RATE-DISC-CD                                   
                    ,:WS-RATE-DISC-DESC                                 
                    ,:J5-RATE-DISC-OPT                                  
                    ,:O1-RATE-DISC-OPT-DESC                             
                    ,:J5-DISC-RATE-AMT                                  
                    ,:UV-SORT-ORDER                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                  TO WS-NO-MORE-ROWS          
                  MOVE 0                    TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7100'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_RATE_DISCOUNT'  TO TABLE-1                  
                  MOVE 'CSS_RATE_OPT_DESC'  TO TABLE-2                  
                  MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-1          
                  MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2          
                  MOVE 'VERSION_NO_CNTRL'   TO TABLE-ELEMENT-3          
                  MOVE J5-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1        
                  MOVE J5-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2        
                  MOVE J5-VERSION-NO-CNTRL  TO HOSTVAR-ELEMENT-3        
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-RIDER-DISCOUNT.                                     *        
      ******************************************************************        
                                                                        
       7200-CLOSE-RIDER-DISCOUNT.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE RIDER_DISCOUNT                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_DISCOUNT'      TO TABLE-1                  
              MOVE 'CSS_RATE_OPT_DESC'      TO TABLE-2                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'VERSION_NO_CNTRL'       TO TABLE-ELEMENT-3          
              MOVE J5-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE J5-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE J5-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7300-OPEN-RIDER-EXPOSURE.                                     *        
      ******************************************************************        
                                                                        
       7300-OPEN-RIDER-EXPOSURE.                                        
                                                                        
           EXEC SQL                                                     
               OPEN RIDER_EXPOSURE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7300'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_RIDER_EXP'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'VERSION_NO_CNTRL'       TO TABLE-ELEMENT-3          
              MOVE RZ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE RZ-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE RZ-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET ALL THE EXPOSURE PERIODS FOR THE RIDERS.                   *        
      * 7400-FETCH-RIDER-EXPOSURE.                                     *        
      ******************************************************************        
                                                                        
       7400-FETCH-RIDER-EXPOSURE.                                       
                                                                        
           EXEC SQL                                                     
               FETCH RIDER_EXPOSURE                                     
                INTO :RZ-FROM-MONTH                                     
                    ,:RZ-TO-MONTH                                       
                    ,:RZ-FROM-HHMM                                      
                    ,:RZ-TO-HHMM                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                  CONTINUE                                              
               WHEN NOT-FOUND                                           
                  MOVE 'Y'                  TO WS-NO-MORE-ROWS          
                  MOVE 0                    TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7400'               TO ACTIVE-PARAGRAPH         
                  MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSS_RATE_RIDER_EXP' TO TABLE-1                  
                  MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-1          
                  MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-2          
                  MOVE 'VERSION_NO_CNTRL'   TO TABLE-ELEMENT-3          
                  MOVE RZ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-1        
                  MOVE RZ-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2        
                  MOVE RZ-VERSION-NO-CNTRL  TO HOSTVAR-ELEMENT-3        
                  PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-CLOSE-RIDER-EXPOSURE.                                     *        
      ******************************************************************        
                                                                        
       7500-CLOSE-RIDER-EXPOSURE.                                       
                                                                        
           EXEC SQL                                                     
               CLOSE RIDER_EXPOSURE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_RATE_RIDER_EXP'     TO TABLE-1                  
              MOVE 'CODE_UTIL_TYPE'         TO TABLE-ELEMENT-1          
              MOVE 'RATE_PLAN_NO'           TO TABLE-ELEMENT-2          
              MOVE 'VERSION_NO_CNTRL'       TO TABLE-ELEMENT-3          
              MOVE RZ-CODE-UTIL-TYPE        TO HOSTVAR-ELEMENT-1        
              MOVE RZ-RATE-PLAN-NO          TO HOSTVAR-ELEMENT-2        
              MOVE RZ-VERSION-NO-CNTRL      TO HOSTVAR-ELEMENT-3        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
                                                                        
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04449_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04449_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04449_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
                                                                        
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04449_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04449_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04449_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.   RIDERS AND DISCOUNTS                     *        
      ******************************************************************        
                                                                        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04449_R1                          
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,RATE_OPT_IND                                         
                  ,RATE_DISC_CD                                         
                  ,RATE_DISC_DESC                                       
                  ,RATE_DISC_OPT                                        
                  ,RATE_DISC_OPT_DESC                                   
                  ,DISC_RATE_AMT                                        
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-RATE-OPT-IND                                  
                  ,:S-RS1-RATE-DISC-CD                                  
                  ,:S-RS1-RATE-DISC-DESC                                
                  ,:S-RS1-RATE-DISC-OPT                                 
                  ,:S-RS1-RATE-DISC-OPT-DESC                            
                  ,:S-RS1-DISC-RATE-AMT                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04449_R1                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,RATE_OPT_IND                                                 
MFA-TR*           ,RATE_DISC_CD                                                 
MFA-TR*           ,RATE_DISC_DESC                                               
MFA-TR*           ,RATE_DISC_OPT                                                
MFA-TR*           ,RATE_DISC_OPT_DESC                                           
MFA-TR*           ,DISC_RATE_AMT                                                
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-RATE-OPT-IND                                          
MFA-TR*           ,:S-RS1-RATE-DISC-CD                                          
MFA-TR*           ,:S-RS1-RATE-DISC-DESC                                        
MFA-TR*           ,:S-RS1-RATE-DISC-OPT                                         
MFA-TR*           ,:S-RS1-RATE-DISC-OPT-DESC                                    
MFA-TR*           ,:S-RS1-DISC-RATE-AMT                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS1             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8010'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'Y'                      TO WS-ERR-INSRT-R1          
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04449_R1'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  RIDER EXPOSURE PERIODS.                   *        
      ******************************************************************        
                                                                        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
               INSERT INTO #CSR04449_R2                          
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,FROM_MONTH                                           
                  ,TO_MONTH                                             
                  ,FROM_HHMM                                            
                  ,TO_HHMM                                              
                 )                                                      
               VALUES                                                   
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-FROM-MONTH                                    
                  ,:S-RS2-TO-MONTH                                      
                  ,:S-RS2-FROM-HHMM                                     
                  ,:S-RS2-TO-HHMM                                       
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR04449_R2                                  
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,FROM_MONTH                                                   
MFA-TR*           ,TO_MONTH                                                     
MFA-TR*           ,FROM_HHMM                                                    
MFA-TR*           ,TO_HHMM                                                      
MFA-TR*          )                                                              
MFA-TR*        VALUES                                                           
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-FROM-MONTH                                            
MFA-TR*           ,:S-RS2-TO-MONTH                                              
MFA-TR*           ,:S-RS2-FROM-HHMM                                             
MFA-TR*           ,:S-RS2-TO-HHMM                                               
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                        TO CTR-ROWS-RS2             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8020'                   TO ACTIVE-PARAGRAPH         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE 'INSERT'                 TO ABEND-FUNCTION           
              MOVE 'Y'                      TO WS-ERR-INSRT-R2          
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSR04449_R2'            TO TABLE-1                  
              MOVE SPACES                   TO TABLE-ELEMENT-1          
              MOVE SPACES                   TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
                                                                        
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-1      
              MOVE   0                      TO S-RETURN-CODE-1          
              MOVE 100                      TO S-APPL-RETURN-CODE-1     
              PERFORM 8010-INSERT-GTT-R1       THRU 8010-EXIT           
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE                       GTT-RETURN-FIELDS-2      
              MOVE   0                      TO S-RETURN-CODE-2          
              MOVE 100                      TO S-APPL-RETURN-CODE-2     
              PERFORM 8020-INSERT-GTT-R2       THRU 8020-EXIT           
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
                                                                        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                TO ABEND-PROGRAM.           
           MOVE '8900'                      TO ACTIVE-PARAGRAPH.        
           MOVE 'OPEN'                      TO ABEND-FUNCTION.          
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04449_R1'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                  TO ABEND-SQLCODE            
              MOVE SQLSTATE                 TO ABEND-SQLSTATE           
              MOVE 'CSR04449_R2'            TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
                                                                        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE                          GTT-RETURN-FIELDS.       
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2.    
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
                                                                        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT.          
           PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT.          
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
           PERFORM 8800-CHECK-RESULTS          THRU 8800-EXIT.          
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT.          
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
