       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04448.                                         
       AUTHOR.        MS93554.                                          
COB303 DATE-WRITTEN.  APRIL 20,2012                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  CSR04448 CLONED FROM SP CSR02298 ON 04/20/2012.               *        
      *  FOR RATE MANAGEMENT MODULE.                                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *      USED TO DELETE/INSERT/UPDATE TIME OF USE DEFINITION       *        
      *      DATA IN DATABASE PER TIME OF USE DEFINITION STEP OF       *        
      *      RATE WIZARD.                                              *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  -------------------                                           *        
      *  APPL_PROG_ID         CHAR(3)                                  *        
      *  USER_ID              CHAR(7)                                  *        
      *  CODE_UTIL_TYPE       CHAR(1)                                  *        
      *  RATE_PLAN_NO         CHAR(3)                                  *        
      *  VERSION_NO_CNTRL     CHAR(04)                                 *        
      *  CMPNT_ID_CD          CHAR(2)                                  *        
      *  ON_PEAK_DAYS         CHAR(7)                                  *        
      *  CALENDAR_CD          CHAR(2)                                  *        
      *  TOU_NO_OF_ROWS       CHAR(04)                                 *        
      *  TOU_ROW_DET_01       CHAR(21)                                 *        
      *  TOU_ROW_DET_02       CHAR(21)                                 *        
      *  TOU_ROW_DET_03       CHAR(21)                                 *        
      *  TOU_ROW_DET_04       CHAR(21)                                 *        
      *  TOU_ROW_DET_05       CHAR(21)                                 *        
      *  TOU_ROW_DET_06       CHAR(21)                                 *        
      *  TOU_ROW_DET_07       CHAR(21)                                 *        
      *  TOU_ROW_DET_08       CHAR(21)                                 *        
      *  TOU_ROW_DET_09       CHAR(21)                                 *        
      *  TOU_ROW_DET_10       CHAR(21)                                 *        
      *  TOU_ROW_DET_11       CHAR(21)                                 *        
      *  TOU_ROW_DET_12       CHAR(21)                                 *        
      *  TOU_ROW_DET_13       CHAR(21)                                 *        
      *  TOU_ROW_DET_14       CHAR(21)                                 *        
      *  TOU_ROW_DET_15       CHAR(21)                                 *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -------------------------                                     *        
      *  RETURN_CODE           INTEGER                                 *        
      *  APPL_RETURN_CODE      INTEGER                                 *        
      *                                                                *        
      *  APPL_RETURN_CODE                                              *        
      *  -------------------------                                     *        
      *  278 - ROW ALREADY EXISTS IN RATE TOU DEF TABLE.               *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/20/12  MS93554    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04448'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04448 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_TOU_DEF   RJ                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTTOUD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_COMP_DEF  J1                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *  COMMON SYSTEM AREA                                            *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *  ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                *        
      ******************************************************************        
           COPY CWS00027.                                                       
                                                                        
      ******************************************************************        
      *  SUPPORTS DB2 AND SQL ERROR CHECKING                           *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *  ERROR HANDLING                                              *          
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04448'. 
           05  ALL-DONE-SW                  PIC X(01) VALUE 'N'.        
               88 NOT-ALL-DONE                        VALUE 'N'.        
               88 ALL-DONE                            VALUE 'Y'.        
           05  SEND-DONE-SW                 PIC X(01) VALUE 'Y'.        
               88 SEND-DONE-ERROR                     VALUE 'N'.        
               88 SEND-DONE-OK                        VALUE 'Y'.        
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-ROWS                      PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-LITERALS.                                                 
           05 WS-ONE                        PIC S9(4) COMP VALUE 1.     
           05 WS-ZERO                       PIC S9(4) COMP VALUE 0.     
           05 WS-MAX                        PIC S9(4) COMP VALUE 15.    
           05 WS-YES                        PIC X(01) VALUE 'Y'.        
           05 WS-NO                         PIC X(01) VALUE 'N'.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE                 PIC S9(9) COMP VALUE 0.     
           05 S-APPL-RETURN-CODE            PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-GENERAL-FIELDS.                                           
           05 WS-CODE-UTIL-TYPE             PIC X(01).                  
           05 WS-RATE-PLAN-NO               PIC X(03).                  
           05 WS-VERSION-NO-CNTRL-C         PIC X(04).                  
           05 WS-VERSION-NO-CNTRL-N REDEFINES WS-VERSION-NO-CNTRL-C     
                                            PIC S9(04).                 
           05 WS-CMPNT-ID-CD                PIC X(02).                  
           05 WS-ON-PEAK-DAYS               PIC X(07).                  
           05 WS-CALENDAR-CD                PIC X(02).                  
           05 WS-NO-OF-ROWS-C               PIC X(04).                  
           05 WS-NO-OF-ROWS-N       REDEFINES WS-NO-OF-ROWS-C           
                                            PIC 9(04).                  
           05 WS-DELETED-FLAG               PIC X(01)  VALUE 'N'.       
           05 WS-ON-PEAK-EXISTS             PIC X(01)  VALUE 'N'.       
           05 WS-ON-PEAK-VAL                PIC S9(04) COMP VALUE 1.    
                                                                        
       01  WS-RATE-TOU-DEF-DET.                                         
           05 WS-RATE-TOU-DEF-RJ OCCURS 15 TIMES                        
                                   INDEXED BY WS-RATE-TOU-INDX.         
              10 WS-CODE-TIME-PERIOD-C      PIC X(4).                   
              10 WS-CODE-TIME-PERIOD-N REDEFINES WS-CODE-TIME-PERIOD-C  
                                            PIC S9(04).                 
              10 WS-TOU-FROM-MMDD-C         PIC X(4).                   
              10 WS-TOU-FROM-MMDD-N REDEFINES WS-TOU-FROM-MMDD-C        
                                            PIC S9(04).                 
              10 WS-TOU-TO-MMDD-C           PIC X(4).                   
              10 WS-TOU-TO-MMDD-N   REDEFINES WS-TOU-TO-MMDD-C          
                                            PIC S9(04).                 
              10 WS-TOU-FROM-HOUR-C         PIC X(4).                   
              10 WS-TOU-FROM-HOUR-N REDEFINES WS-TOU-FROM-HOUR-C        
                                            PIC S9(04).                 
              10 WS-TOU-TO-HOUR-C           PIC X(4).                   
              10 WS-TOU-TO-HOUR-N   REDEFINES WS-TOU-TO-HOUR-C          
                                            PIC S9(04).                 
              10 WS-ACTION-FLAG             PIC X(1) VALUE SPACES.      
                 88 RATE-TOU-DEF-DELETE              VALUE 'D'.         
                 88 RATE-TOU-DEF-INSERT              VALUE 'I'.         
                 88 RATE-TOU-DEF-UPDATE              VALUE 'U'.         
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
           10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID             PIC X(03).                     
       01  PARM-USER-ID                  PIC X(07).                     
       01  PARM-CODE-UTIL-TYPE           PIC X(01).                     
       01  PARM-RATE-PLAN-NO             PIC X(03).                     
       01  PARM-VERSION-NO-CNTRL         PIC X(04).                     
       01  PARM-CMPNT-ID-CD              PIC X(02).                     
       01  PARM-ON-PEAK-DAYS             PIC X(07).                     
       01  PARM-CALENDAR-CD              PIC X(02).                     
       01  PARM-TOU-NO-OF-ROWS           PIC X(04).                     
       01  PARM-TOU-ROW-DET-01           PIC X(21).                     
       01  PARM-TOU-ROW-DET-02           PIC X(21).                     
       01  PARM-TOU-ROW-DET-03           PIC X(21).                     
       01  PARM-TOU-ROW-DET-04           PIC X(21).                     
       01  PARM-TOU-ROW-DET-05           PIC X(21).                     
       01  PARM-TOU-ROW-DET-06           PIC X(21).                     
       01  PARM-TOU-ROW-DET-07           PIC X(21).                     
       01  PARM-TOU-ROW-DET-08           PIC X(21).                     
       01  PARM-TOU-ROW-DET-09           PIC X(21).                     
       01  PARM-TOU-ROW-DET-10           PIC X(21).                     
       01  PARM-TOU-ROW-DET-11           PIC X(21).                     
       01  PARM-TOU-ROW-DET-12           PIC X(21).                     
       01  PARM-TOU-ROW-DET-13           PIC X(21).                     
       01  PARM-TOU-ROW-DET-14           PIC X(21).                     
       01  PARM-TOU-ROW-DET-15           PIC X(21).                     
                                                                        
       PROCEDURE DIVISION USING PARM-APPL-PROG-ID                       
                                PARM-USER-ID                            
                                PARM-CODE-UTIL-TYPE                     
                                PARM-RATE-PLAN-NO                       
                                PARM-VERSION-NO-CNTRL                   
                                PARM-CMPNT-ID-CD                        
                                PARM-ON-PEAK-DAYS                       
                                PARM-CALENDAR-CD                        
                                PARM-TOU-NO-OF-ROWS                     
                                PARM-TOU-ROW-DET-01                     
                                PARM-TOU-ROW-DET-02                     
                                PARM-TOU-ROW-DET-03                     
                                PARM-TOU-ROW-DET-04                     
                                PARM-TOU-ROW-DET-05                     
                                PARM-TOU-ROW-DET-06                     
                                PARM-TOU-ROW-DET-07                     
                                PARM-TOU-ROW-DET-08                     
                                PARM-TOU-ROW-DET-09                     
                                PARM-TOU-ROW-DET-10                     
                                PARM-TOU-ROW-DET-11                     
                                PARM-TOU-ROW-DET-12                     
                                PARM-TOU-ROW-DET-13                     
                                PARM-TOU-ROW-DET-14                     
                                PARM-TOU-ROW-DET-15.                    
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                  :S-RETURN-CODE              AS  RETURN_CODE           
                 ,:S-APPL-RETURN-CODE         AS  APPL_RETURN_CODE      
             FROM CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*           :S-RETURN-CODE              AS  RETURN_CODE                   
MFA-TR*          ,:S-APPL-RETURN-CODE         AS  APPL_RETURN_CODE              
MFA-TR*      FROM SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CODE-UTIL-TYPE          
           MOVE PARM-RATE-PLAN-NO         TO WS-RATE-PLAN-NO            
           MOVE PARM-VERSION-NO-CNTRL     TO WS-VERSION-NO-CNTRL-C      
           MOVE PARM-CMPNT-ID-CD          TO WS-CMPNT-ID-CD             
           MOVE PARM-ON-PEAK-DAYS         TO WS-ON-PEAK-DAYS            
           MOVE PARM-CALENDAR-CD          TO WS-CALENDAR-CD             
           MOVE PARM-TOU-NO-OF-ROWS       TO WS-NO-OF-ROWS-C            
           MOVE PARM-TOU-ROW-DET-01       TO WS-RATE-TOU-DEF-RJ(01)     
           MOVE PARM-TOU-ROW-DET-02       TO WS-RATE-TOU-DEF-RJ(02)     
           MOVE PARM-TOU-ROW-DET-03       TO WS-RATE-TOU-DEF-RJ(03)     
           MOVE PARM-TOU-ROW-DET-04       TO WS-RATE-TOU-DEF-RJ(04)     
           MOVE PARM-TOU-ROW-DET-05       TO WS-RATE-TOU-DEF-RJ(05)     
           MOVE PARM-TOU-ROW-DET-06       TO WS-RATE-TOU-DEF-RJ(06)     
           MOVE PARM-TOU-ROW-DET-07       TO WS-RATE-TOU-DEF-RJ(07)     
           MOVE PARM-TOU-ROW-DET-08       TO WS-RATE-TOU-DEF-RJ(08)     
           MOVE PARM-TOU-ROW-DET-09       TO WS-RATE-TOU-DEF-RJ(09)     
           MOVE PARM-TOU-ROW-DET-10       TO WS-RATE-TOU-DEF-RJ(10)     
           MOVE PARM-TOU-ROW-DET-11       TO WS-RATE-TOU-DEF-RJ(11)     
           MOVE PARM-TOU-ROW-DET-12       TO WS-RATE-TOU-DEF-RJ(12)     
           MOVE PARM-TOU-ROW-DET-13       TO WS-RATE-TOU-DEF-RJ(13)     
           MOVE PARM-TOU-ROW-DET-14       TO WS-RATE-TOU-DEF-RJ(14)     
           MOVE PARM-TOU-ROW-DET-15       TO WS-RATE-TOU-DEF-RJ(15).    
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE WS-CODE-UTIL-TYPE           TO RJ-CODE-UTIL-TYPE        
                                               J1-CODE-UTIL-TYPE.       
           MOVE WS-RATE-PLAN-NO             TO RJ-RATE-PLAN-NO          
                                               J1-RATE-PLAN-NO.         
           MOVE WS-VERSION-NO-CNTRL-N       TO RJ-VERSION-NO-CNTRL      
                                               J1-VERSION-NO-CNTRL.     
           MOVE WS-CMPNT-ID-CD              TO RJ-CMPNT-ID-CD           
                                               J1-CMPNT-ID-CD.          
                                                                        
      *    DELETE/INSERT/UPDATE PROCESSS FOR CSS_RATE_TOU_DEF.                  
           IF WS-NO-OF-ROWS-N > WS-ZERO                                 
              PERFORM 2100-DETERMINE-OPERATION THRU 2100-EXIT           
           END-IF.                                                      
      *    UPDATE PROCESSS FOR CSS_RATE_COMP_DEF.                               
           PERFORM 2200-UPD-RATE-COMP-DEF      THRU 2200-EXIT.          
           ADD +1                          TO CTR-ROWS.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-DETERMINE-OPERATION.                                      *        
      ******************************************************************        
       2100-DETERMINE-OPERATION.                                        
                                                                        
           PERFORM VARYING WS-RATE-TOU-INDX FROM 1 BY 1                 
                           UNTIL WS-RATE-TOU-INDX > (WS-MAX OR          
                                                     WS-NO-OF-ROWS-N)   
             OR WS-ACTION-FLAG(WS-RATE-TOU-INDX)  = SPACES              
             OR WS-ACTION-FLAG(WS-RATE-TOU-INDX)  = LOW-VALUES          
                                                                        
             MOVE WS-CODE-TIME-PERIOD-N(WS-RATE-TOU-INDX)               
                                            TO RJ-CODE-TIME-PERIOD      
             MOVE WS-TOU-FROM-MMDD-N(WS-RATE-TOU-INDX)                  
                                            TO RJ-TOU-FROM-MMDD         
             MOVE WS-TOU-TO-MMDD-N(WS-RATE-TOU-INDX)                    
                                            TO RJ-TOU-TO-MMDD           
             MOVE WS-TOU-FROM-HOUR-N(WS-RATE-TOU-INDX)                  
                                            TO RJ-TOU-FROM-HOUR         
             MOVE WS-TOU-TO-HOUR-N(WS-RATE-TOU-INDX)                    
                                            TO RJ-TOU-TO-HOUR           
                                                                        
             EVALUATE TRUE                                              
                 WHEN RATE-TOU-DEF-DELETE(WS-RATE-TOU-INDX)             
                      PERFORM 8000-DELETE-RATE-TOU THRU 8000-EXIT       
                 WHEN RATE-TOU-DEF-INSERT(WS-RATE-TOU-INDX)             
                      PERFORM 8100-INSERT-RATE-TOU THRU 8100-EXIT       
                      IF WS-ACTIVE-RETURN-CODE EQUAL ALREADY-EXISTS     
                         MOVE 278           TO S-APPL-RETURN-CODE       
                         MOVE 100           TO S-RETURN-CODE            
                         ADD +1             TO CTR-ROWS                 
                         PERFORM 9999-END-PROGRAM  THRU 9999-EXIT       
                      END-IF                                            
                 WHEN RATE-TOU-DEF-UPDATE(WS-RATE-TOU-INDX)             
                      PERFORM 8200-UPDATE-RATE-TOU THRU 8200-EXIT       
             END-EVALUATE                                               
                                                                        
           END-PERFORM.                                                 
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 2200-UPD-RATE-COMP-DEF                                        *         
      *****************************************************************         
       2200-UPD-RATE-COMP-DEF.                                          
                                                                        
           PERFORM 7000-CHECK-ON-PEAK-STAT     THRU 7000-EXIT.          
                                                                        
           IF WS-DELETED-FLAG EQUAL WS-YES AND                          
              WS-ON-PEAK-EXISTS EQUAL WS-NO                             
              MOVE SPACES                   TO WS-ON-PEAK-DAYS          
              MOVE SPACES                   TO WS-CALENDAR-CD           
              PERFORM 8300-UPDATE-RATE-COMP-DEF THRU 8300-EXIT          
           ELSE                                                         
      *       IF WS-DELETED-FLAG EQUAL WS-NO AND                                
              IF WS-ON-PEAK-EXISTS EQUAL WS-YES                         
                 PERFORM 8300-UPDATE-RATE-COMP-DEF                      
                                               THRU 8300-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7000-CHECK-ON-PEAK-STAT                                       *         
      *****************************************************************         
       7000-CHECK-ON-PEAK-STAT.                                         
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT 'Y'                                       
                INTO :WS-ON-PEAK-EXISTS                                 
                FROM CSS_RATE_TOU_DEF WITH(READUNCOMMITTED)                     
               WHERE CODE_UTIL_TYPE     = :RJ-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :RJ-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :RJ-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :RJ-CMPNT-ID-CD               
                 AND CODE_TIME_PERIOD   = :WS-ON-PEAK-VAL               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT 'Y'                                               
MFA-TR*         INTO :WS-ON-PEAK-EXISTS                                         
MFA-TR*         FROM CSS_RATE_TOU_DEF                                           
MFA-TR*        WHERE CODE_UTIL_TYPE     = :RJ-CODE-UTIL-TYPE                    
MFA-TR*          AND RATE_PLAN_NO       = :RJ-RATE-PLAN-NO                      
MFA-TR*          AND VERSION_NO_CNTRL   = :RJ-VERSION-NO-CNTRL                  
MFA-TR*          AND CMPNT_ID_CD        = :RJ-CMPNT-ID-CD                       
MFA-TR*          AND CODE_TIME_PERIOD   = :WS-ON-PEAK-VAL                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE RJ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RJ-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE RJ-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              MOVE RJ-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000-DELETE-RATE-TOU                                          *         
      *****************************************************************         
       8000-DELETE-RATE-TOU.                                            
                                                                        
           MOVE WS-YES                        TO WS-DELETED-FLAG.       
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_RATE_TOU_DEF                              
               WHERE CODE_UTIL_TYPE     = :RJ-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :RJ-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :RJ-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :RJ-CMPNT-ID-CD               
                 AND TOU_FROM_MMDD      = :RJ-TOU-FROM-MMDD             
                 AND TOU_FROM_HOUR      = :RJ-TOU-FROM-HOUR             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE RJ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RJ-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE RJ-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              MOVE RJ-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8100-INSERT-RATE-TOU                                          *         
      *****************************************************************         
       8100-INSERT-RATE-TOU.                                            
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_TOU_DEF                              
                   (                                                    
                     CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,VERSION_NO_CNTRL                                   
                    ,CMPNT_ID_CD                                        
                    ,CODE_TIME_PERIOD                                   
                    ,TOU_FROM_MMDD                                      
                    ,TOU_TO_MMDD                                        
                    ,TOU_FROM_HOUR                                      
                    ,TOU_TO_HOUR                                        
                   )                                                    
              VALUES                                                    
                   (                                                    
                     :RJ-CODE-UTIL-TYPE                                 
                    ,:RJ-RATE-PLAN-NO                                   
                    ,:RJ-VERSION-NO-CNTRL                               
                    ,:RJ-CMPNT-ID-CD                                    
                    ,:RJ-CODE-TIME-PERIOD                               
                    ,:RJ-TOU-FROM-MMDD                                  
                    ,:RJ-TOU-TO-MMDD                                    
                    ,:RJ-TOU-FROM-HOUR                                  
                    ,:RJ-TOU-TO-HOUR                                    
                   )                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
                                                      OR ALREADY-EXISTS 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'TOU_FROM_MMDD'            TO TABLE-ELEMENT-3        
              MOVE 'TOU_TO_MMDD'              TO TABLE-ELEMENT-4        
              MOVE RJ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RJ-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE RJ-TOU-FROM-MMDD           TO HOSTVAR-ELEMENT-3      
              MOVE RJ-TOU-TO-MMDD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8200-UPDATE-RATE-TOU                                          *         
      *****************************************************************         
       8200-UPDATE-RATE-TOU.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE RJ                                 
                 SET CODE_TIME_PERIOD   = :RJ-CODE-TIME-PERIOD          
                    ,TOU_TO_MMDD        = :RJ-TOU-TO-MMDD               
                    ,TOU_TO_HOUR        = :RJ-TOU-TO-HOUR               
              FROM CSS_RATE_TOU_DEF RJ
               WHERE CODE_UTIL_TYPE     = :RJ-CODE-UTIL-TYPE            
                 AND RATE_PLAN_NO       = :RJ-RATE-PLAN-NO              
                 AND VERSION_NO_CNTRL   = :RJ-VERSION-NO-CNTRL          
                 AND CMPNT_ID_CD        = :RJ-CMPNT-ID-CD               
                 AND TOU_FROM_MMDD      = :RJ-TOU-FROM-MMDD             
                 AND TOU_FROM_HOUR      = :RJ-TOU-FROM-HOUR             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_RATE_TOU_DEF RJ                                        
MFA-TR*          SET CODE_TIME_PERIOD   = :RJ-CODE-TIME-PERIOD                  
MFA-TR*             ,TOU_TO_MMDD        = :RJ-TOU-TO-MMDD                       
MFA-TR*             ,TOU_TO_HOUR        = :RJ-TOU-TO-HOUR                       
MFA-TR*        WHERE CODE_UTIL_TYPE     = :RJ-CODE-UTIL-TYPE                    
MFA-TR*          AND RATE_PLAN_NO       = :RJ-RATE-PLAN-NO                      
MFA-TR*          AND VERSION_NO_CNTRL   = :RJ-VERSION-NO-CNTRL                  
MFA-TR*          AND CMPNT_ID_CD        = :RJ-CMPNT-ID-CD                       
MFA-TR*          AND TOU_FROM_MMDD      = :RJ-TOU-FROM-MMDD                     
MFA-TR*          AND TOU_FROM_HOUR      = :RJ-TOU-FROM-HOUR                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE RJ-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE RJ-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE RJ-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              MOVE RJ-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8300-UPDATE-RATE-COMP-DEF                                     *         
      *****************************************************************         
       8300-UPDATE-RATE-COMP-DEF.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE J1                                
                 SET ON_PEAK_DAYS       = :WS-ON-PEAK-DAYS              
                    ,CALENDAR_CD        = :WS-CALENDAR-CD               
              FROM CSS_RATE_COMP_DEF J1
              WHERE  CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE            
                AND  RATE_PLAN_NO       = :J1-RATE-PLAN-NO              
                AND  VERSION_NO_CNTRL   = :J1-VERSION-NO-CNTRL          
                AND  CMPNT_ID_CD        = :J1-CMPNT-ID-CD               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_RATE_COMP_DEF J1                                       
MFA-TR*          SET ON_PEAK_DAYS       = :WS-ON-PEAK-DAYS                      
MFA-TR*             ,CALENDAR_CD        = :WS-CALENDAR-CD                       
MFA-TR*       WHERE  CODE_UTIL_TYPE     = :J1-CODE-UTIL-TYPE                    
MFA-TR*         AND  RATE_PLAN_NO       = :J1-RATE-PLAN-NO                      
MFA-TR*         AND  VERSION_NO_CNTRL   = :J1-VERSION-NO-CNTRL                  
MFA-TR*         AND  CMPNT_ID_CD        = :J1-CMPNT-ID-CD                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-VERSION-NO-CNTRL-N      TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
              PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
                                                                        
