       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04447.                                         
       AUTHOR.        GOPI DUGGIRALA.                                   
       DATE-WRITTEN.  APR 16, 2012.                                     
      *****************************************************************         
      **                          SCE&G                              **         
      *****************************************************************         
      **                STORED PROCEDURE: CSR04447                   **         
      *****************************************************************         
      **                P R O G R A M   S U M M A R Y                **         
      **                                                             **         
      ** "TIME OF USE DEFINITION STEP OF RATE WIZARD" FROM "RATE     **         
      ** MANAGEMENT MODULE" PROJECT WILL USE THIS PROGRAM.           **         
      **                                                             **         
      ** PARAMETERS                                                  **         
      **                                                             **         
      **  INPUT                                                      **         
      **   APPL_PROG_ID           CHAR(03)                           **         
      **   USER_ID                CHAR(07)                           **         
      **   CODE_UTIL_TYPE         CHAR(01)                           **         
      **   RATE_PLAN_NO           CHAR(03)                           **         
      **   VERSION_NO_CNTRL       SMALLINT                           **         
      **                                                             **         
      **  OUTPUT                                                     **         
      **   RETURN_CODE            INTEGER                            **         
      **   APPL_RETURN_CODE       INTEGER                            **         
      **   CMPNT_ID_CD            CHAR(02)                           **         
      **   REG_TYPE_CD            CHAR(01)                           **         
      **   DEM_REG_TYPE_CD        CHAR(01)                           **         
      **   CALENDAR_CD            CHAR(02)                           **         
      **   ON_PEAK_DAYS           CHAR(07)                           **         
      **   CODE_TIME_PERIOD       SMALLINT                           **         
      **   TOU_FROM_MMDD          SMALLINT                           **         
      **   TOU_TO_MMDD            SMALLINT                           **         
      **   TOU_FROM_HOUR          SMALLINT                           **         
      **   TOU_TO_HOUR            SMALLINT                           **         
      **                                                             **         
      *****************************************************************         
      **              PROGRAM MODIFICATION LOG                       **         
      ** DATE        INITIALS     REASON                             **         
      ** --------    ---------    ---------------------------------- **         
      ** 04/16/12    GD97441      NEW PROGRAM.                       **         
      *****************************************************************         
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04447'.
MSQ017     COPY MFASQLM.
      *                                                                         
      **********************************                                        
      **   DB2 INCLUDES               **                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE SQLCA                                                   
           END-EXEC.                                                            
      *                                                                         
      **** CSS_RATE_COMP_DEF, J1                                                
           EXEC SQL                                                             
                INCLUDE TBRTCDEF                                                
           END-EXEC.                                                            
      *                                                                         
      **** CSS_RATE_TOU_DEF, RJ                                                 
           EXEC SQL                                                             
                INCLUDE TBRTTOUD                                                
           END-EXEC.                                                            
      *                                                                         
       01  WS-LITERALS.                                                 
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04447'.      
      *                                                                         
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-APPL-PROG-ID       PIC X(03) VALUE SPACES.          
           05  PARM-USER-ID            PIC X(07) VALUE SPACES.          
           05  PARM-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.          
           05  PARM-RATE-PLAN-NO       PIC X(03) VALUE SPACES.          
           05  PARM-VERSION-NO-CNTRL   PIC S9(4) USAGE COMP.            
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(9) COMP VALUE 0.          
           05  S-CMPNT-ID-CD           PIC X(02) VALUE SPACES.          
           05  S-REG-TYPE-CD           PIC X(01) VALUE SPACES.          
           05  S-DEM-REG-TYPE-CD       PIC X(01) VALUE SPACES.          
           05  S-CALENDAR-CD           PIC X(02) VALUE SPACES.          
           05  S-ON-PEAK-DAYS          PIC X(07) VALUE SPACES.          
           05  S-CODE-TIME-PERIOD      PIC S9(4) COMP VALUE 0.          
           05  S-TOU-FROM-MMDD         PIC S9(4) COMP VALUE 0.          
           05  S-TOU-TO-MMDD           PIC S9(4) COMP VALUE 0.          
           05  S-TOU-FROM-HOUR         PIC S9(4) COMP VALUE 0.          
           05  S-TOU-TO-HOUR           PIC S9(4) COMP VALUE 0.          
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88  SEND-DONE-ERROR               VALUE 'N'.             
               88  SEND-DONE-OK                  VALUE 'Y'.             
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18) VALUE SPACES.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(05) VALUE ' '.             
           10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                         
      **** ERROR HANDLING (ABEND VARIABLES)                                     
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      **** SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      **** SELECT TOU DATA                                                      
      *                                                                         
           EXEC SQL                                                     
             DECLARE  MAIN_CURSOR CURSOR FOR                            
              SELECT J1.CMPNT_ID_CD                                     
                    ,J1.REG_TYPE_CD                                     
                    ,J1.DEM_REG_TYPE_CD                                 
                    ,J1.CALENDAR_CD                                     
                    ,J1.ON_PEAK_DAYS                                    
                    ,RJ.CODE_TIME_PERIOD                                
                    ,RJ.TOU_FROM_MMDD                                   
                    ,RJ.TOU_TO_MMDD                                     
                    ,RJ.TOU_FROM_HOUR                                   
                    ,RJ.TOU_TO_HOUR                                     
                FROM CSS_RATE_COMP_DEF  J1 WITH(READUNCOMMITTED)                
                    ,CSS_RATE_TOU_DEF   RJ WITH(READUNCOMMITTED)                
               WHERE J1.CODE_UTIL_TYPE    =   RJ.CODE_UTIL_TYPE         
                 AND J1.RATE_PLAN_NO      =   RJ.RATE_PLAN_NO           
                 AND J1.VERSION_NO_CNTRL  =   RJ.VERSION_NO_CNTRL       
                 AND J1.CMPNT_ID_CD       =   RJ.CMPNT_ID_CD            
                 AND J1.CODE_UTIL_TYPE    =  :J1-CODE-UTIL-TYPE         
                 AND J1.RATE_PLAN_NO      =  :J1-RATE-PLAN-NO           
                 AND J1.VERSION_NO_CNTRL  =  :J1-VERSION-NO-CNTRL       
              ORDER BY J1.CMPNT_ID_CD,RJ.TOU_FROM_MMDD,RJ.TOU_TO_MMDD   
                      ,RJ.TOU_FROM_HOUR,RJ.TOU_TO_HOUR                  
              FOR READ ONLY                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE  MAIN_CURSOR CURSOR FOR                                    
MFA-TR*       SELECT J1.CMPNT_ID_CD                                             
MFA-TR*             ,J1.REG_TYPE_CD                                             
MFA-TR*             ,J1.DEM_REG_TYPE_CD                                         
MFA-TR*             ,J1.CALENDAR_CD                                             
MFA-TR*             ,J1.ON_PEAK_DAYS                                            
MFA-TR*             ,RJ.CODE_TIME_PERIOD                                        
MFA-TR*             ,RJ.TOU_FROM_MMDD                                           
MFA-TR*             ,RJ.TOU_TO_MMDD                                             
MFA-TR*             ,RJ.TOU_FROM_HOUR                                           
MFA-TR*             ,RJ.TOU_TO_HOUR                                             
MFA-TR*         FROM CSS_RATE_COMP_DEF  J1                                      
MFA-TR*             ,CSS_RATE_TOU_DEF   RJ                                      
MFA-TR*        WHERE J1.CODE_UTIL_TYPE    =   RJ.CODE_UTIL_TYPE                 
MFA-TR*          AND J1.RATE_PLAN_NO      =   RJ.RATE_PLAN_NO                   
MFA-TR*          AND J1.VERSION_NO_CNTRL  =   RJ.VERSION_NO_CNTRL               
MFA-TR*          AND J1.CMPNT_ID_CD       =   RJ.CMPNT_ID_CD                    
MFA-TR*          AND J1.CODE_UTIL_TYPE    =  :J1-CODE-UTIL-TYPE                 
MFA-TR*          AND J1.RATE_PLAN_NO      =  :J1-RATE-PLAN-NO                   
MFA-TR*          AND J1.VERSION_NO_CNTRL  =  :J1-VERSION-NO-CNTRL               
MFA-TR*       ORDER BY J1.CMPNT_ID_CD,RJ.TOU_FROM_MMDD,RJ.TOU_TO_MMDD           
MFA-TR*               ,RJ.TOU_FROM_HOUR,RJ.TOU_TO_HOUR                          
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
      *                                                                         
       01  LINK-APPL-PROG-ID       PIC X(03) VALUE SPACES.              
       01  LINK-USER-ID            PIC X(07) VALUE SPACES.              
       01  LINK-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.              
       01  LINK-RATE-PLAN-NO       PIC X(03) VALUE SPACES.              
       01  LINK-VERSION-NO-CNTRL   PIC S9(4) USAGE COMP.                
      *                                                                         
       PROCEDURE DIVISION USING  LINK-APPL-PROG-ID                      
                                ,LINK-USER-ID                           
                                ,LINK-CODE-UTIL-TYPE                    
                                ,LINK-RATE-PLAN-NO                      
                                ,LINK-VERSION-NO-CNTRL.                 
      *                                                                         
      ******************************************************************        
      **   CONTROLS THE MAIN PATH OF THE PROGRAM                      **        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE        THRU  0100-EXIT.              
           PERFORM 1000-PROCESS-INPUT     THRU  1000-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT    THRU  2000-EXIT.              
           PERFORM 9999-END-PROGRAM       THRU  9999-EXIT.              
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** INITIALIZE REQUIRED VARIABLES                                **        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           MOVE '0100'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS.         
      *                                                                         
           PERFORM 0100A-DECLARE-GTT      THRU  0100A-EXIT.             
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DECLARE GLOBAL TEMPORARY TABLE                               **        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR04447_R1'                 
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04447_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04447_R1
              (                                                    
                       RETURN_CODE            INT                   
                      ,APPL_RETURN_CODE       INT                   
                      ,CMPNT_ID_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,REG_TYPE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,DEM_REG_TYPE_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CALENDAR_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,ON_PEAK_DAYS CHAR(07)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                  
                      ,CODE_TIME_PERIOD       SMALLINT                  
                      ,TOU_FROM_MMDD          SMALLINT                  
                      ,TOU_TO_MMDD            SMALLINT                  
                      ,TOU_FROM_HOUR          SMALLINT                  
                      ,TOU_TO_HOUR            SMALLINT                  
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF SQLSTATE = '42710'                                        
              PERFORM 8000A-DELETE-GTT-ROWS  THRU  8000A-EXIT           
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE SQLCODE               TO ABEND-SQLCODE           
                  MOVE SQLSTATE              TO ABEND-SQLSTATE          
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'         TO ABEND-FUNCTION          
                  MOVE SPACES                TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                  MOVE 'CSR04447_R1'         TO TABLE-1                 
                  MOVE SPACES                TO TABLE-ELEMENT-1         
                  MOVE SPACES                TO HOSTVAR-ELEMENT-1       
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                       WITH ROWSET POSITIONING FOR                      
               SELECT  RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,CMPNT_ID_CD                                      
                      ,REG_TYPE_CD                                      
                      ,DEM_REG_TYPE_CD                                  
                      ,CALENDAR_CD                                      
                      ,ON_PEAK_DAYS                                     
                      ,CODE_TIME_PERIOD                                 
                      ,TOU_FROM_MMDD                                    
                      ,TOU_TO_MMDD                                      
                      ,TOU_FROM_HOUR                                    
                      ,TOU_TO_HOUR                                      
               FROM #CSR04447_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                WITH ROWSET POSITIONING FOR                              
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,CMPNT_ID_CD                                              
MFA-TR*               ,REG_TYPE_CD                                              
MFA-TR*               ,DEM_REG_TYPE_CD                                          
MFA-TR*               ,CALENDAR_CD                                              
MFA-TR*               ,ON_PEAK_DAYS                                             
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,TOU_FROM_MMDD                                            
MFA-TR*               ,TOU_TO_MMDD                                              
MFA-TR*               ,TOU_FROM_HOUR                                            
MFA-TR*               ,TOU_TO_HOUR                                              
MFA-TR*        FROM SESSION.CSR04447_R1                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** RECEIVE INPUT PARMS                                          **        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE '1000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE LINK-APPL-PROG-ID         TO PARM-APPL-PROG-ID.         
           MOVE LINK-USER-ID              TO PARM-USER-ID.              
           MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE.       
           MOVE LINK-RATE-PLAN-NO         TO PARM-RATE-PLAN-NO.         
           MOVE LINK-VERSION-NO-CNTRL     TO PARM-VERSION-NO-CNTRL.     
      *                                                                         
           MOVE PARM-CODE-UTIL-TYPE       TO J1-CODE-UTIL-TYPE.         
           MOVE PARM-RATE-PLAN-NO         TO J1-RATE-PLAN-NO.           
           MOVE PARM-VERSION-NO-CNTRL     TO J1-VERSION-NO-CNTRL.       
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** GET TOU DATA AND POPULATE RESULT SET                         **        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
      *                                                                         
           PERFORM 7100-OPEN-MAIN-CURSOR   THRU  7100-EXIT.             
      *                                                                         
           PERFORM 7110-FETCH-MAIN-CURSOR  THRU  7110-EXIT.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2500-MOVE-RESULT     THRU  2500-EXIT              
                UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                 
           ELSE                                                         
              MOVE 100                     TO S-RETURN-CODE             
              PERFORM 8100-SEND-RESULT     THRU  8100-EXIT              
           END-IF.                                                      
      *                                                                         
           PERFORM 7120-CLOSE-MAIN-CURSOR  THRU  7120-EXIT.             
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** MOVE RESULT SET                                              **        
      ******************************************************************        
      *                                                                         
       2500-MOVE-RESULT.                                                
      *                                                                         
           MOVE '2500'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE J1-CMPNT-ID-CD            TO S-CMPNT-ID-CD.             
           MOVE J1-REG-TYPE-CD            TO S-REG-TYPE-CD.             
           MOVE J1-DEM-REG-TYPE-CD        TO S-DEM-REG-TYPE-CD.         
           MOVE J1-CALENDAR-CD            TO S-CALENDAR-CD.             
           MOVE J1-ON-PEAK-DAYS           TO S-ON-PEAK-DAYS.            
           MOVE RJ-CODE-TIME-PERIOD       TO S-CODE-TIME-PERIOD.        
           MOVE RJ-TOU-FROM-MMDD          TO S-TOU-FROM-MMDD.           
           MOVE RJ-TOU-TO-MMDD            TO S-TOU-TO-MMDD.             
           MOVE RJ-TOU-FROM-HOUR          TO S-TOU-FROM-HOUR.           
           MOVE RJ-TOU-TO-HOUR            TO S-TOU-TO-HOUR.             
      *                                                                         
           PERFORM 8100-SEND-RESULT       THRU  8100-EXIT.              
      *                                                                         
           INITIALIZE                        GTT-RETURN-FIELDS          
                                             J1-CMPNT-ID-CD             
                                             J1-CALENDAR-CD             
                                             J1-ON-PEAK-DAYS            
                                             RJ-CODE-TIME-PERIOD        
                                             RJ-TOU-FROM-MMDD           
                                             RJ-TOU-TO-MMDD             
                                             RJ-TOU-FROM-HOUR           
                                             RJ-TOU-TO-HOUR.            
      *                                                                         
           PERFORM 7110-FETCH-MAIN-CURSOR THRU  7110-EXIT.              
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  OPEN MAN_DET_CUR CURSOR                                     **        
      ******************************************************************        
      *                                                                         
       7100-OPEN-MAIN-CURSOR.                                           
      *                                                                         
           EXEC SQL                                                     
               OPEN MAIN_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE J1-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  FETCH MAN_DET_CUR CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7110-FETCH-MAIN-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
              FETCH MAIN_CURSOR                                         
               INTO :J1-CMPNT-ID-CD                                     
                   ,:J1-REG-TYPE-CD                                     
                   ,:J1-DEM-REG-TYPE-CD                                 
                   ,:J1-CALENDAR-CD                                     
                   ,:J1-ON-PEAK-DAYS                                    
                   ,:RJ-CODE-TIME-PERIOD                                
                   ,:RJ-TOU-FROM-MMDD                                   
                   ,:RJ-TOU-TO-MMDD                                     
                   ,:RJ-TOU-FROM-HOUR                                   
                   ,:RJ-TOU-TO-HOUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7110'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE J1-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  CLOSE MAN_DET_CUR CURSOR                                    **        
      ******************************************************************        
      *                                                                         
       7120-CLOSE-MAIN-CURSOR.                                          
      *                                                                         
           EXEC SQL                                                     
              CLOSE MAIN_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7120'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE J1-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** DELETE SESSION TABLE                                         **        
      ******************************************************************        
      *                                                                         
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE GLOBAL TEMPORARY TABLE CSR04447_R1'                  
                                             TO S-SQL-STATEMENT-V.      
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR04447_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR04447_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE           
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000A'                  TO ACTIVE-PARAGRAPH        
               MOVE 'DELETE'                 TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CSR04447_R1'            TO TABLE-1                 
               MOVE SPACES                   TO TABLE-ELEMENT-1         
               MOVE SPACES                   TO HOSTVAR-ELEMENT-1       
               PERFORM 9000-SEND-ERROR-RESULT THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** SEND RESULT SET                                              **        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO #CSR04447_R1                            
             (                                                          
              RETURN_CODE                                               
             ,APPL_RETURN_CODE                                          
             ,CMPNT_ID_CD                                               
             ,REG_TYPE_CD                                               
             ,DEM_REG_TYPE_CD                                           
             ,CALENDAR_CD                                               
             ,ON_PEAK_DAYS                                              
             ,CODE_TIME_PERIOD                                          
             ,TOU_FROM_MMDD                                             
             ,TOU_TO_MMDD                                               
             ,TOU_FROM_HOUR                                             
             ,TOU_TO_HOUR                                               
             )                                                          
             VALUES                                                     
             (                                                          
              :S-RETURN-CODE                                            
             ,:S-APPL-RETURN-CODE                                       
             ,:S-CMPNT-ID-CD                                            
             ,:S-REG-TYPE-CD                                            
             ,:S-DEM-REG-TYPE-CD                                        
             ,:S-CALENDAR-CD                                            
             ,:S-ON-PEAK-DAYS                                           
             ,:S-CODE-TIME-PERIOD                                       
             ,:S-TOU-FROM-MMDD                                          
             ,:S-TOU-TO-MMDD                                            
             ,:S-TOU-FROM-HOUR                                          
             ,:S-TOU-TO-HOUR                                            
             )                                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR04447_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,APPL_RETURN_CODE                                                  
MFA-TR*      ,CMPNT_ID_CD                                                       
MFA-TR*      ,REG_TYPE_CD                                                       
MFA-TR*      ,DEM_REG_TYPE_CD                                                   
MFA-TR*      ,CALENDAR_CD                                                       
MFA-TR*      ,ON_PEAK_DAYS                                                      
MFA-TR*      ,CODE_TIME_PERIOD                                                  
MFA-TR*      ,TOU_FROM_MMDD                                                     
MFA-TR*      ,TOU_TO_MMDD                                                       
MFA-TR*      ,TOU_FROM_HOUR                                                     
MFA-TR*      ,TOU_TO_HOUR                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-APPL-RETURN-CODE                                               
MFA-TR*      ,:S-CMPNT-ID-CD                                                    
MFA-TR*      ,:S-REG-TYPE-CD                                                    
MFA-TR*      ,:S-DEM-REG-TYPE-CD                                                
MFA-TR*      ,:S-CALENDAR-CD                                                    
MFA-TR*      ,:S-ON-PEAK-DAYS                                                   
MFA-TR*      ,:S-CODE-TIME-PERIOD                                               
MFA-TR*      ,:S-TOU-FROM-MMDD                                                  
MFA-TR*      ,:S-TOU-TO-MMDD                                                    
MFA-TR*      ,:S-TOU-FROM-HOUR                                                  
MFA-TR*      ,:S-TOU-TO-HOUR                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE          
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSR04447_R1'              TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE J1-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE J1-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE J1-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
           END-IF.                                                      
      *                                                                         
           ADD 1                              TO CTR-ROWS.              
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      ** 9000-SEND-ERROR-RESULT                                       **        
      ******************************************************************        
      *                                                                 00003400
           EXEC SQL                                                     00000100
               INCLUDE CPD00320                                         00000200
           END-EXEC.                                                    00000300
      *                                                                         
      ******************************************************************        
      ** 9900-SQL-ERROR-ROUTINE                                       **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
