       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04446.                                      
COB303 DATE-WRITTEN.     MARCH 14, 2011.                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04446              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04446 :                                                --         
      *--                                                            --         
      *--     UPDATES CRM TABLES BASED ON PROC REQUEST ID            --         
      *--                                                            --         
      *--       CRM_RT_PKG_OFFER                                     --         
      *--       CRM_RT_PKG_OPTION                                    --         
      *--       CRM_MKT_PROMOTION                                    --         
      *--       CRM_OFF_MKT_TIER                                     --         
      *--       CRM_OPT_ATTR_INCTV                                   --         
      *--       CRM_RATE_GRP_OFFER                                   --         
      *--       CRM_ACCESS_OFF_OPT                                   --         
      *--       CRM_OFFER_OPTION                                     --         
      *--                                                            --         
      *--  # APPL-RETURN-CODE.                                       --         
      *--   +1000 - INPUT IS INVALID                                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             APPLICATION_ID      CHAR(03)                   --         
      *--             USER_ID             CHAR(07)                   --         
      *--             RESOURCE_ID         CHAR(32)                   --         
      *--             PROC_REQ_ID         DECIMAL(10,0)              --         
      *--             PROC_REQ_STATUS     CHAR(02)                   --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04446_R1 - OFFER CODE DEATILS                   --         
      *--           RETURN_CODE             INTEGER                 --          
      *--           APPL_RETURN_CODE        INTEGER                 --          
      *--           RULE_NO                 CHAR(08)                 --         
      *--           RULE_FLAG               CHAR(01)                 --         
      *--           ERROR_HEADER_DESC       CHAR(200)                --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00473*--  10/25/2011    MN90523     UPDATES CRM TABLES              --         
PRJ680*--  02/27/2013    MS93554     A NEW COLUMN MAX_PRICE_OFFER_CD --         
      *--                            HAS BEEN ADDED INTO CRM TABLE   --         
      *--                            CRM_RT_PKG_OFFER.               --         
A04805*--  11/06/2013    MS93554     NEW COLUMNS ARE ADDED IN CRM_   --         
      *                              OFFER_OPTION & CRM_RT_PKG_OPTION--         
      *                              TABLES.                         --         
PRJ892*--  04/16/2015    SS95855     NEW COLUMNS ADDED TO TABLE      --         
PRJ892*--                            CRM_RT_PKG_OPTION.              --         
P00863*--  07/08/2015    SS45239     A NEW COLUMN RTCHG_PUB_OFFER_CD --         
      *--                            HAS BEEN ADDED INTO CRM TABLE   --         
      *--                            CRM_RT_PKG_OFFER.               --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04446'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04446 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-SUBROUTINE-IDS.                                        
              10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'.  
           05 PROGRAM-NAME                 PIC X(08) VALUE 'CSR04446'.  
           05 MCSCB826                     PIC X(08) VALUE 'MCSCB826'.  
           05 MCSCB829                     PIC X(08) VALUE 'MCSCB829'.  
           05 WS-REJECTED                  PIC X(02) VALUE 'RJ'.        
           05 WS-UPDATE                    PIC X(01) VALUE 'U'.         
           05 WS-REFERENCE                 PIC X(01) VALUE 'R'.         
           05 WS-YES                       PIC X(01) VALUE 'Y'.         
           05 WS-NO                        PIC X(01) VALUE 'N'.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(04) VALUE 0.         
           05  WS-VERSION-START-TS          PIC X(26).                  
           05  WS-VERSION-END-TS            PIC X(26).                  
           05  WS-ACTIVE-START-DT           PIC X(10).                  
           05  WS-ACTIVE-END-DT             PIC X(10).                  
           05  WS-PROC-REQ-FLAG             PIC X(01).                  
COB305     05 WS-PROCESS-REQ-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.   
           05  WS-PROC-STATUS-CD            PIC X(02) VALUE SPACES.     
           05  WS-OFFER-TYPE                PIC X(08) VALUE 'NORMAL'.   
           05  WS-NORMAL-OFFER              PIC X(08) VALUE 'NORMAL'.   
           05  WS-TEMPLATE-OFFER            PIC X(08) VALUE 'TEMPLATE'. 
           05  WS-REPLACE-OFFER             PIC X(08) VALUE 'REPLACE'.  
           05  WS-APPL-PGM-ID               PIC X(08).                  
           05  WS-SMALLINT-NUM              PIC 9(04).                  
           05  WS-INTEGER-NUM               PIC 9(09).                  
           05  WS-DECIMAL-5V6-NUM           PIC S9(11).                 
           05  WS-DECIMAL-5V6-NUM-RED REDEFINES WS-DECIMAL-5V6-NUM      
                                            PIC S9(5)V9(6).             
           05  WS-DECIMAL-3V4-NUM           PIC S9(07).                 
           05  WS-DECIMAL-3V4-NUM-RED REDEFINES WS-DECIMAL-3V4-NUM      
                                            PIC S9(3)V9(4).             
           05  WS-DECIMAL-10V0-NUM          PIC S9(10).                 
           05  WS-DECIMAL-10V0-NUM-RED REDEFINES WS-DECIMAL-10V0-NUM    
                                            PIC S9(10)V.                
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
           05  WS-NULL-EFF-TS               PIC S9(04) COMP.            
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.        
              88 SEND-DONE-ERROR                      VALUE 'N'.        
              88 SEND-DONE-OK                         VALUE 'Y'.        
           05 WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.        
              88 NO-MORE-ROWS                         VALUE 'Y'.        
           05 WS-EOF-ATTR-CURSOR            PIC X(01) VALUE 'N'.        
              88 NO-MORE-ATTR-ROWS                    VALUE 'Y'.        
           05 WS-NO-MORE-OFFER-MKT-ROWS     PIC X(01) VALUE 'N'.        
              88 NO-MORE-OFFER-MKT-ROWS               VALUE 'Y'.        
           05 WS-NO-MORE-RATE-GRP-OFF-ROWS  PIC X(01) VALUE 'N'.        
              88 NO-MORE-RATE-GRP-OFF-ROWS            VALUE 'Y'.        
           05 WS-NO-MORE-OFFER-ACCESS-ROWS  PIC X(01) VALUE 'N'.        
              88 NO-MORE-OFFER-ACCESS-ROWS            VALUE 'Y'.        
           05 WS-NO-MORE-OFFER-OPTION-ROWS  PIC X(01) VALUE 'N'.        
              88 NO-MORE-OFFER-OPTION-ROWS            VALUE 'Y'.        
           05 WS-NO-MORE-OPTN-ATRB-ROWS     PIC X(01) VALUE 'N'.        
              88 NO-MORE-OPTN-ATRB-ROWS               VALUE 'Y'.        
           05 WS-NO-MORE-OPTN-ACCESS-ROWS   PIC X(01) VALUE 'N'.        
              88 NO-MORE-OPTN-ACCESS-ROWS             VALUE 'Y'.        
           05 WS-NO-MORE-OPTION-ROWS        PIC X(01) VALUE 'N'.        
              88 NO-MORE-OPTION-ROWS                  VALUE 'Y'.        
           05 WS-OFFER-LOADED               PIC X(01) VALUE 'N'.        
           05 WS-OFFER-CD                   PIC X(12) VALUE SPACES.     
           05 WS-OPTION-LOADED              PIC X(01) VALUE 'N'.        
           05 WS-OPTION-CD                  PIC X(12) VALUE SPACES.     
           05 WS-RPM-WIZARDS                PIC X(06) VALUE ' '.        
              88 CREATE-OFFER-WIZARD                  VALUE 'RPM001'.   
              88 MODIFY-OFFER-WIZARD                  VALUE 'RPM002'.   
              88 CREATE-REPLACE-OFFER-WIZARD          VALUE 'RPM003'.   
              88 MODIFY-OPTION-WIZARD                 VALUE 'RPM004'.   
              88 CREATE-PROMO-WIZARD                  VALUE 'RPM005'.   
              88 MODIFY-PROMO-WIZARD                  VALUE 'RPM006'.   
              88 VIEW-OPTION-WIZARD                   VALUE 'RPM013'.   
              88 VIEW-PROMOTION-WIZARD                VALUE 'RPM014'.   
           05 WS-PROC-STAT-CD-REJECTED      PIC X(01) VALUE 'N'.        
              88 PROC-STAT-CD-REJECTED                VALUE 'Y'.        
      *                                                                         
       01  WS-FLAGS.                                                    
           05 WS-ERR-INSRT-R1               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R2               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R3               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R4               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R5               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R6               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R7               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R8               PIC X(01) VALUE 'N'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05 RS-APPL-RETURN-CODE       PIC S9(09) COMP VALUE 0.        
           05 RS-RULE-NO                PIC X(08)  VALUE SPACES.        
           05 RS-RULE-FLAG              PIC X(01)  VALUE SPACES.        
           05 RS-ERROR-HEADER-DESC      PIC X(200) VALUE SPACES.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05  S-APPL-RETURN-CODE       PIC S9(09) COMP VALUE 0.        
           05  S-RULE-NO                PIC X(08)  VALUE SPACES.        
           05  S-RULE-FLAG              PIC X(01)  VALUE SPACES.        
           05  S-ERROR-HEADER-DESC      PIC X(200) VALUE SPACES.        
                                                                        
       01 WS-SWITCH.                                                    
           05 WS-RULES-EXISTS           PIC X(01)  VALUE 'Y'.           
              88 RULES-EXISTS                      VALUE 'Y'.           
              88 RULES-NOT-EXISTS                  VALUE 'N'.           
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OPTION  (FI)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_ATTR_INCV   (G7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTINCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OFFER   (FG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFF_MKT_TIER   (DU)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFMKT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFFER_OPTION   (E9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFOPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV (HQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_PROMOTION  (KM)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_ACCESS_OFF_OPT  (CI)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRMACC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GRP_OFFER  (G5)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PROCESS_REQ     (1P)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPRCREQ                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PROCESS_REQ_CH  (4P)                                             
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPRCCHG                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR UPDATE                          *        
      ******************************************************************        
           COPY CWS00826.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR VALIDATION                      *        
      ******************************************************************        
           COPY CWS00829.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OFFER DETAILS BASED ON           *        
      *   OPTION CODE.                                                 *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH MARKET TIER DETAILS             *        
      *    BASED ON OFFER CODE AND PROCESS REQ ID                      *        
      *    FOR CREATEREPLACE WIZARD TEMPLATE AND REPLACE OFFER WILL    *        
      *    HAVE SAME PROCESS REQUEST ID SO BASED ON OFFER TYPE SELECT  *        
      *    THE RIGHT OFFER MARKET TIER                                 *        
      *    FOR TEMPLATE OFFER, VERSION WILL BE GREATER THAN 1 SINCE    *        
      *    THEY MIGHT HAVE CHANGES SUCH UNDEFAULTING THE OFFER TIERS   *        
      *    FOR REPLACE OFFER WHICH IS CREATED USING TEMPLATE OFFER     *        
      *    WILL HAVE VERSION 1                                         *        
      *    FOR OTHER WIZARDS OFFER TYPE WILL BE 'NORMAL'               *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFFER_MKT_CUR    CURSOR FOR                      
                SELECT DU.COMPANY_NO                                    
                      ,DU.OFFER_CD                                      
                      ,DU.TIER_CUST_STAT_CD                             
                      ,DU.TIER_ACCT_TYPE_CD                             
                      ,DU.MKT_TIER_RANKING                              
                      ,DU.MKT_TIER_START_DT                             
                      ,DU.OFFER_TIER_STRT_DT                            
                      ,DU.MKT_TIER_APPLY_CD                             
                      ,DU.TIER_DEFLT_OFFR_CD                            
                      ,DU.OFFER_TIER_END_DT                             
                      ,DU.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,DU.OFF_TIER_VRSN_NO                              
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VSTART_TS                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VEND_TS                              
                      ,DU.PROC_STATUS_CD                                
                      ,DU.PROC_REQ_ID                                   
                  FROM CRM_OFF_MKT_TIER  DU WITH(READUNCOMMITTED)               
                 WHERE ( ( DU.OFFER_CD  = :DU-OFFER-CD                  
                     AND :WS-OFFER-LOADED = :WS-YES ) OR                
                         :WS-OFFER-LOADED = :WS-NO )                    
                   AND DU.COMPANY_NO  = :DU-COMPANY-NO                  
                   AND DU.PROC_REQ_ID = :DU-PROC-REQ-ID                 
                   AND (                                                
                     ( DU.OFF_TIER_VRSN_NO = (                          
                   SELECT MAX(D1.OFF_TIER_VRSN_NO)                      
                     FROM CRM_OFF_MKT_TIER D1 WITH(READUNCOMMITTED)             
                    WHERE D1.COMPANY_NO         = DU.COMPANY_NO         
                      AND D1.OFFER_CD           = DU.OFFER_CD           
                      AND D1.TIER_CUST_STAT_CD  = DU.TIER_CUST_STAT_CD  
                      AND D1.TIER_ACCT_TYPE_CD  = DU.TIER_ACCT_TYPE_CD  
                      AND D1.MKT_TIER_RANKING   = DU.MKT_TIER_RANKING   
                      AND D1.MKT_TIER_START_DT  = DU.MKT_TIER_START_DT  
                      AND D1.OFFER_TIER_STRT_DT = DU.OFFER_TIER_STRT_DT)
                     AND ( :WS-OFFER-TYPE = :WS-NORMAL-OFFER            
                        OR ( :WS-OFFER-TYPE = :WS-TEMPLATE-OFFER        
                           AND DU.OFF_TIER_VRSN_NO > 1 ) ) )            
                      OR ( :WS-OFFER-TYPE = :WS-REPLACE-OFFER           
                           AND DU.OFF_TIER_VRSN_NO = 1 ) )              
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_MKT_CUR    CURSOR FOR                              
MFA-TR*         SELECT DU.COMPANY_NO                                            
MFA-TR*               ,DU.OFFER_CD                                              
MFA-TR*               ,DU.TIER_CUST_STAT_CD                                     
MFA-TR*               ,DU.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,DU.MKT_TIER_RANKING                                      
MFA-TR*               ,DU.MKT_TIER_START_DT                                     
MFA-TR*               ,DU.OFFER_TIER_STRT_DT                                    
MFA-TR*               ,DU.MKT_TIER_APPLY_CD                                     
MFA-TR*               ,DU.TIER_DEFLT_OFFR_CD                                    
MFA-TR*               ,DU.OFFER_TIER_END_DT                                     
MFA-TR*               ,DU.LAST_UPDATE_USERID                                    
MFA-TR*               ,DU.LAST_UPDATE_TS                                        
MFA-TR*               ,DU.OFF_TIER_VRSN_NO                                      
MFA-TR*               ,DU.OFF_TIER_VSTART_TS                                    
MFA-TR*               ,DU.OFF_TIER_VEND_TS                                      
MFA-TR*               ,DU.PROC_STATUS_CD                                        
MFA-TR*               ,DU.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_OFF_MKT_TIER  DU                                     
MFA-TR*          WHERE ( ( DU.OFFER_CD  = :DU-OFFER-CD                          
MFA-TR*              AND :WS-OFFER-LOADED = :WS-YES ) OR                        
MFA-TR*                  :WS-OFFER-LOADED = :WS-NO )                            
MFA-TR*            AND DU.COMPANY_NO  = :DU-COMPANY-NO                          
MFA-TR*            AND DU.PROC_REQ_ID = :DU-PROC-REQ-ID                         
MFA-TR*            AND (                                                        
MFA-TR*              ( DU.OFF_TIER_VRSN_NO = (                                  
MFA-TR*            SELECT MAX(D1.OFF_TIER_VRSN_NO)                              
MFA-TR*              FROM CRM_OFF_MKT_TIER D1                                   
MFA-TR*             WHERE D1.COMPANY_NO         = DU.COMPANY_NO                 
MFA-TR*               AND D1.OFFER_CD           = DU.OFFER_CD                   
MFA-TR*               AND D1.TIER_CUST_STAT_CD  = DU.TIER_CUST_STAT_CD          
MFA-TR*               AND D1.TIER_ACCT_TYPE_CD  = DU.TIER_ACCT_TYPE_CD          
MFA-TR*               AND D1.MKT_TIER_RANKING   = DU.MKT_TIER_RANKING           
MFA-TR*               AND D1.MKT_TIER_START_DT  = DU.MKT_TIER_START_DT          
MFA-TR*               AND D1.OFFER_TIER_STRT_DT = DU.OFFER_TIER_STRT_DT)        
MFA-TR*              AND ( :WS-OFFER-TYPE = :WS-NORMAL-OFFER                    
MFA-TR*                 OR ( :WS-OFFER-TYPE = :WS-TEMPLATE-OFFER                
MFA-TR*                    AND DU.OFF_TIER_VRSN_NO > 1 ) ) )                    
MFA-TR*               OR ( :WS-OFFER-TYPE = :WS-REPLACE-OFFER                   
MFA-TR*                    AND DU.OFF_TIER_VRSN_NO = 1 ) )                      
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7050                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH RATE GROUP  DETAILS             *        
      *    BASED ON OFFER CODE OR PROC REQ ID                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE RATE_GRP_OFF_CUR CURSOR FOR                      
                SELECT G5.COMPANY_NO                                    
                      ,G5.RATE_GROUP_TYPE_CD                            
                      ,G5.RATE_GROUP_CD                                 
                      ,G5.SORT_SEQ_NO                                   
                      ,G5.EFF_START_DT                                  
                      ,G5.EFF_END_DT                                    
                      ,G5.OFFER_CD                                      
                      ,G5.OPTION_CD                                     
                      ,G5.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,G5.GRP_OFF_VRSN_NO                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.GRP_OFF_VSTART_TS, 121), ' ', '-'), ':', '.') 
           GRP_OFF_VSTART_TS                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.GRP_OFF_VEND_TS, 121), ' ', '-'), ':', '.') 
           GRP_OFF_VEND_TS                               
                      ,G5.PROC_STATUS_CD                                
                      ,G5.PROC_REQ_ID                                   
                  FROM CRM_RATE_GRP_OFFER G5 WITH(READUNCOMMITTED)              
                 WHERE ( ( G5.OFFER_CD  = :G5-OFFER-CD                  
                     AND :WS-OFFER-LOADED = :WS-YES ) OR                
                         :WS-OFFER-LOADED = :WS-NO )                    
                   AND G5.COMPANY_NO  = :G5-COMPANY-NO                  
                   AND G5.PROC_REQ_ID = :G5-PROC-REQ-ID                 
                   AND G5.GRP_OFF_VRSN_NO  = (                          
                   SELECT MAX(G1.GRP_OFF_VRSN_NO )                      
                     FROM CRM_RATE_GRP_OFFER G1 WITH(READUNCOMMITTED)           
                    WHERE G1.COMPANY_NO         = G5.COMPANY_NO         
                      AND G1.RATE_GROUP_TYPE_CD = G5.RATE_GROUP_TYPE_CD 
                      AND G1.RATE_GROUP_CD      = G5.RATE_GROUP_CD      
                      AND G1.SORT_SEQ_NO        = G5.SORT_SEQ_NO        
                      AND G1.EFF_START_DT       = G5.EFF_START_DT )     
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_GRP_OFF_CUR CURSOR FOR                              
MFA-TR*         SELECT G5.COMPANY_NO                                            
MFA-TR*               ,G5.RATE_GROUP_TYPE_CD                                    
MFA-TR*               ,G5.RATE_GROUP_CD                                         
MFA-TR*               ,G5.SORT_SEQ_NO                                           
MFA-TR*               ,G5.EFF_START_DT                                          
MFA-TR*               ,G5.EFF_END_DT                                            
MFA-TR*               ,G5.OFFER_CD                                              
MFA-TR*               ,G5.OPTION_CD                                             
MFA-TR*               ,G5.LAST_UPDATE_USERID                                    
MFA-TR*               ,G5.LAST_UPDATE_TS                                        
MFA-TR*               ,G5.GRP_OFF_VRSN_NO                                       
MFA-TR*               ,G5.GRP_OFF_VSTART_TS                                     
MFA-TR*               ,G5.GRP_OFF_VEND_TS                                       
MFA-TR*               ,G5.PROC_STATUS_CD                                        
MFA-TR*               ,G5.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_RATE_GRP_OFFER G5                                    
MFA-TR*          WHERE ( ( G5.OFFER_CD  = :G5-OFFER-CD                          
MFA-TR*              AND :WS-OFFER-LOADED = :WS-YES ) OR                        
MFA-TR*                  :WS-OFFER-LOADED = :WS-NO )                            
MFA-TR*            AND G5.COMPANY_NO  = :G5-COMPANY-NO                          
MFA-TR*            AND G5.PROC_REQ_ID = :G5-PROC-REQ-ID                         
MFA-TR*            AND G5.GRP_OFF_VRSN_NO  = (                                  
MFA-TR*            SELECT MAX(G1.GRP_OFF_VRSN_NO )                              
MFA-TR*              FROM CRM_RATE_GRP_OFFER G1                                 
MFA-TR*             WHERE G1.COMPANY_NO         = G5.COMPANY_NO                 
MFA-TR*               AND G1.RATE_GROUP_TYPE_CD = G5.RATE_GROUP_TYPE_CD         
MFA-TR*               AND G1.RATE_GROUP_CD      = G5.RATE_GROUP_CD              
MFA-TR*               AND G1.SORT_SEQ_NO        = G5.SORT_SEQ_NO                
MFA-TR*               AND G1.EFF_START_DT       = G5.EFF_START_DT )             
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7100                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH OFFER ACCESS DETAILS            *        
      *    BASED ON OFFER CODE OR PROC REQ ID                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFFER_ACCESS_CUR CURSOR FOR                      
                SELECT CI.COMPANY_NO                                    
                      ,CI.OPTION_CD                                     
                      ,CI.OFFER_CD                                      
                      ,CI.CATEGORY_ID                                   
                      ,CI.ACCESS_START_DT                               
                      ,CI.ACCESS_END_DT                                 
                      ,CI.VIEW_APPLY_CD                                 
                      ,CI.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,CI.COMMENTS_TX                                   
                      ,CI.ACCESS_VRSN_NO                                
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.ACCESS_VSTART_TS, 121), ' ', '-'), ':', '.') 
           ACCESS_VSTART_TS                              
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.ACCESS_VEND_TS, 121), ' ', '-'), ':', '.') ACCESS_VEND_TS        
                      ,CI.PROC_STATUS_CD                                
                      ,CI.PROC_REQ_ID                                   
                  FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)              
                 WHERE CI.OPTION_CD  = ' '                              
                   AND ( ( CI.OFFER_CD  = :CI-OFFER-CD                  
                     AND :WS-OFFER-LOADED = :WS-YES ) OR                
                         :WS-OFFER-LOADED = :WS-NO )                    
                   AND CI.COMPANY_NO  = :CI-COMPANY-NO                  
                   AND CI.PROC_REQ_ID = :CI-PROC-REQ-ID                 
                   AND CI.ACCESS_VRSN_NO   = (                          
                   SELECT MAX(C1.ACCESS_VRSN_NO  )                      
                     FROM CRM_ACCESS_OFF_OPT C1 WITH(READUNCOMMITTED)           
                    WHERE C1.COMPANY_NO   = CI.COMPANY_NO               
                      AND C1.OPTION_CD    = CI.OPTION_CD                
                      AND C1.OFFER_CD     = CI.OFFER_CD                 
                      AND C1.CATEGORY_ID  = CI.CATEGORY_ID )            
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_ACCESS_CUR CURSOR FOR                              
MFA-TR*         SELECT CI.COMPANY_NO                                            
MFA-TR*               ,CI.OPTION_CD                                             
MFA-TR*               ,CI.OFFER_CD                                              
MFA-TR*               ,CI.CATEGORY_ID                                           
MFA-TR*               ,CI.ACCESS_START_DT                                       
MFA-TR*               ,CI.ACCESS_END_DT                                         
MFA-TR*               ,CI.VIEW_APPLY_CD                                         
MFA-TR*               ,CI.LAST_UPDATE_USERID                                    
MFA-TR*               ,CI.LAST_UPDATE_TS                                        
MFA-TR*               ,CI.COMMENTS_TX                                           
MFA-TR*               ,CI.ACCESS_VRSN_NO                                        
MFA-TR*               ,CI.ACCESS_VSTART_TS                                      
MFA-TR*               ,CI.ACCESS_VEND_TS                                        
MFA-TR*               ,CI.PROC_STATUS_CD                                        
MFA-TR*               ,CI.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_ACCESS_OFF_OPT CI                                    
MFA-TR*          WHERE CI.OPTION_CD  = ' '                                      
MFA-TR*            AND ( ( CI.OFFER_CD  = :CI-OFFER-CD                          
MFA-TR*              AND :WS-OFFER-LOADED = :WS-YES ) OR                        
MFA-TR*                  :WS-OFFER-LOADED = :WS-NO )                            
MFA-TR*            AND CI.COMPANY_NO  = :CI-COMPANY-NO                          
MFA-TR*            AND CI.PROC_REQ_ID = :CI-PROC-REQ-ID                         
MFA-TR*            AND CI.ACCESS_VRSN_NO   = (                                  
MFA-TR*            SELECT MAX(C1.ACCESS_VRSN_NO  )                              
MFA-TR*              FROM CRM_ACCESS_OFF_OPT C1                                 
MFA-TR*             WHERE C1.COMPANY_NO   = CI.COMPANY_NO                       
MFA-TR*               AND C1.OPTION_CD    = CI.OPTION_CD                        
MFA-TR*               AND C1.OFFER_CD     = CI.OFFER_CD                         
MFA-TR*               AND C1.CATEGORY_ID  = CI.CATEGORY_ID )                    
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7150                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH OFFER OPTION DETAILS            *        
      *    BASED ON OFFER CODE OR PROC REQ ID                          *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE OFFER_OPTION_CUR CURSOR FOR                      
                SELECT E9.COMPANY_NO                                    
                      ,E9.OFFER_CD                                      
                      ,E9.OPTION_CD                                     
                      ,E9.OPTION_SORT_SEQ_NO                            
                      ,E9.OPTION_URL_TX                                 
                      ,E9.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,E9.DROP_OPTION_CD                                
                      ,E9.OFFER_OPT_START_DT                            
                      ,E9.OFFER_OPT_END_DT                              
                      ,E9.OFF_OPT_VRSN_NO                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VSTART_TS                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VEND_TS                               
                      ,E9.PROC_STATUS_CD                                
                      ,E9.PROC_REQ_ID                                   
A04805                ,E9.WEB_NEW_EXISTS_CD                             
A04805                ,E9.WEB_SIGN_UP_FL                                
A04805                ,E9.OFF_OPT_EXCLUDE_CD                            
                  FROM CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)               
                 WHERE ( ( E9.OFFER_CD  = :E9-OFFER-CD                  
                     AND :WS-OFFER-LOADED = :WS-YES ) OR                
                         :WS-OFFER-LOADED = :WS-NO )                    
                   AND E9.COMPANY_NO  = :E9-COMPANY-NO                  
                   AND E9.PROC_REQ_ID = :E9-PROC-REQ-ID                 
                   AND E9.OFF_OPT_VRSN_NO  = (                          
                   SELECT MAX(E1.OFF_OPT_VRSN_NO )                      
                     FROM CRM_OFFER_OPTION  E1 WITH(READUNCOMMITTED)            
                    WHERE E1.COMPANY_NO         = E9.COMPANY_NO         
                      AND E1.OFFER_CD           = E9.OFFER_CD           
                      AND E1.OPTION_CD          = E9.OPTION_CD          
                      AND E1.OFFER_OPT_START_DT = E9.OFFER_OPT_START_DT)
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_OPTION_CUR CURSOR FOR                              
MFA-TR*         SELECT E9.COMPANY_NO                                            
MFA-TR*               ,E9.OFFER_CD                                              
MFA-TR*               ,E9.OPTION_CD                                             
MFA-TR*               ,E9.OPTION_SORT_SEQ_NO                                    
MFA-TR*               ,E9.OPTION_URL_TX                                         
MFA-TR*               ,E9.LAST_UPDATE_USERID                                    
MFA-TR*               ,E9.LAST_UPDATE_TS                                        
MFA-TR*               ,E9.DROP_OPTION_CD                                        
MFA-TR*               ,E9.OFFER_OPT_START_DT                                    
MFA-TR*               ,E9.OFFER_OPT_END_DT                                      
MFA-TR*               ,E9.OFF_OPT_VRSN_NO                                       
MFA-TR*               ,E9.OFF_OPT_VSTART_TS                                     
MFA-TR*               ,E9.OFF_OPT_VEND_TS                                       
MFA-TR*               ,E9.PROC_STATUS_CD                                        
MFA-TR*               ,E9.PROC_REQ_ID                                           
MFA-TR*               ,E9.WEB_NEW_EXISTS_CD                                     
MFA-TR*               ,E9.WEB_SIGN_UP_FL                                        
MFA-TR*               ,E9.OFF_OPT_EXCLUDE_CD                                    
MFA-TR*           FROM CRM_OFFER_OPTION  E9                                     
MFA-TR*          WHERE ( ( E9.OFFER_CD  = :E9-OFFER-CD                          
MFA-TR*              AND :WS-OFFER-LOADED = :WS-YES ) OR                        
MFA-TR*                  :WS-OFFER-LOADED = :WS-NO )                            
MFA-TR*            AND E9.COMPANY_NO  = :E9-COMPANY-NO                          
MFA-TR*            AND E9.PROC_REQ_ID = :E9-PROC-REQ-ID                         
MFA-TR*            AND E9.OFF_OPT_VRSN_NO  = (                                  
MFA-TR*            SELECT MAX(E1.OFF_OPT_VRSN_NO )                              
MFA-TR*              FROM CRM_OFFER_OPTION  E1                                  
MFA-TR*             WHERE E1.COMPANY_NO         = E9.COMPANY_NO                 
MFA-TR*               AND E1.OFFER_CD           = E9.OFFER_CD                   
MFA-TR*               AND E1.OPTION_CD          = E9.OPTION_CD                  
MFA-TR*               AND E1.OFFER_OPT_START_DT = E9.OFFER_OPT_START_DT)        
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7200                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CURSOR DECLARATION TO FETCH ATTRIBUTE INCENTIVE DETAILS     *         
      *   BASED ON OPTION CODE AND PROC_REQ_ID                        *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE OPT_ATTR_INCTV_CUR CURSOR FOR                     
               SELECT HQ.COMPANY_NO                                     
                     ,HQ.OPTION_CD                                      
                     ,HQ.ATTR_INCTV_SEQ_NO                              
                     ,HQ.RT_ATTR_INCTV_TYPE                             
                     ,HQ.PRIMRY_OPT_ATTR_FL                             
                     ,HQ.FACTOR_ID                                      
                     ,HQ.DURATION_NO                                    
                     ,HQ.APPL_PROGRAM_ID                                
                     ,HQ.ATTR_INCTV_VALUE                               
                     ,HQ.ATTR_INCTV_VAL_TX                              
                     ,HQ.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,HQ.GL_ACCT_CREDIT                                 
                     ,HQ.GL_ACCT_DEBIT                                  
                     ,HQ.CATEGORY_ID                                    
                     ,HQ.WQ_ROUTE_CATEGORY                              
                     ,HQ.OPT_CHG_ACTION_CD                              
                     ,HQ.ATTR_INCTV_STRT_DT                             
                     ,HQ.ATTR_INCTV_END_DT                              
                     ,HQ.OPT_ATTR_VRSN_NO                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.OPT_ATTR_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OPT_ATTR_VSTART_TS                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.OPT_ATTR_VEND_TS, 121), ' ', '-'), ':', '.') 
           OPT_ATTR_VEND_TS                               
                     ,HQ.PROC_STATUS_CD                                 
                     ,HQ.PROC_REQ_ID                                    
                 FROM CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)              
                 WHERE ( ( HQ.OPTION_CD = :HQ-OPTION-CD                 
                     AND :WS-OPTION-LOADED = :WS-YES ) OR               
                         :WS-OPTION-LOADED = :WS-NO )                   
                   AND HQ.COMPANY_NO  = :HQ-COMPANY-NO                  
                   AND HQ.PROC_REQ_ID = :HQ-PROC-REQ-ID                 
                   AND HQ.OPT_ATTR_VRSN_NO = (                          
                   SELECT MAX(H1.OPT_ATTR_VRSN_NO)                      
                     FROM CRM_OPT_ATTR_INCTV H1 WITH(READUNCOMMITTED)           
                    WHERE H1.COMPANY_NO        = HQ.COMPANY_NO          
                      AND H1.OPTION_CD         = HQ.OPTION_CD           
                      AND H1.ATTR_INCTV_SEQ_NO = HQ.ATTR_INCTV_SEQ_NO ) 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPT_ATTR_INCTV_CUR CURSOR FOR                             
MFA-TR*        SELECT HQ.COMPANY_NO                                             
MFA-TR*              ,HQ.OPTION_CD                                              
MFA-TR*              ,HQ.ATTR_INCTV_SEQ_NO                                      
MFA-TR*              ,HQ.RT_ATTR_INCTV_TYPE                                     
MFA-TR*              ,HQ.PRIMRY_OPT_ATTR_FL                                     
MFA-TR*              ,HQ.FACTOR_ID                                              
MFA-TR*              ,HQ.DURATION_NO                                            
MFA-TR*              ,HQ.APPL_PROGRAM_ID                                        
MFA-TR*              ,HQ.ATTR_INCTV_VALUE                                       
MFA-TR*              ,HQ.ATTR_INCTV_VAL_TX                                      
MFA-TR*              ,HQ.LAST_UPDATE_USERID                                     
MFA-TR*              ,HQ.LAST_UPDATE_TS                                         
MFA-TR*              ,HQ.GL_ACCT_CREDIT                                         
MFA-TR*              ,HQ.GL_ACCT_DEBIT                                          
MFA-TR*              ,HQ.CATEGORY_ID                                            
MFA-TR*              ,HQ.WQ_ROUTE_CATEGORY                                      
MFA-TR*              ,HQ.OPT_CHG_ACTION_CD                                      
MFA-TR*              ,HQ.ATTR_INCTV_STRT_DT                                     
MFA-TR*              ,HQ.ATTR_INCTV_END_DT                                      
MFA-TR*              ,HQ.OPT_ATTR_VRSN_NO                                       
MFA-TR*              ,HQ.OPT_ATTR_VSTART_TS                                     
MFA-TR*              ,HQ.OPT_ATTR_VEND_TS                                       
MFA-TR*              ,HQ.PROC_STATUS_CD                                         
MFA-TR*              ,HQ.PROC_REQ_ID                                            
MFA-TR*          FROM CRM_OPT_ATTR_INCTV  HQ                                    
MFA-TR*          WHERE ( ( HQ.OPTION_CD = :HQ-OPTION-CD                         
MFA-TR*              AND :WS-OPTION-LOADED = :WS-YES ) OR                       
MFA-TR*                  :WS-OPTION-LOADED = :WS-NO )                           
MFA-TR*            AND HQ.COMPANY_NO  = :HQ-COMPANY-NO                          
MFA-TR*            AND HQ.PROC_REQ_ID = :HQ-PROC-REQ-ID                         
MFA-TR*            AND HQ.OPT_ATTR_VRSN_NO = (                                  
MFA-TR*            SELECT MAX(H1.OPT_ATTR_VRSN_NO)                              
MFA-TR*              FROM CRM_OPT_ATTR_INCTV H1                                 
MFA-TR*             WHERE H1.COMPANY_NO        = HQ.COMPANY_NO                  
MFA-TR*               AND H1.OPTION_CD         = HQ.OPTION_CD                   
MFA-TR*               AND H1.ATTR_INCTV_SEQ_NO = HQ.ATTR_INCTV_SEQ_NO )         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7350                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH OPTION ACCESS DETAILS           *        
      *    BASED ON OPTION CODE AND PROC REQ ID                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OPTION_ACCESS_CUR CURSOR FOR                     
                SELECT CI.COMPANY_NO                                    
                      ,CI.OPTION_CD                                     
                      ,CI.OFFER_CD                                      
                      ,CI.CATEGORY_ID                                   
                      ,CI.ACCESS_START_DT                               
                      ,CI.ACCESS_END_DT                                 
                      ,CI.VIEW_APPLY_CD                                 
                      ,CI.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,CI.COMMENTS_TX                                   
                      ,CI.ACCESS_VRSN_NO                                
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.ACCESS_VSTART_TS, 121), ' ', '-'), ':', '.') 
           ACCESS_VSTART_TS                              
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.ACCESS_VEND_TS, 121), ' ', '-'), ':', '.') ACCESS_VEND_TS        
                      ,CI.PROC_STATUS_CD                                
                      ,CI.PROC_REQ_ID                                   
                  FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)              
                 WHERE CI.OFFER_CD   = ' '                              
                   AND ( ( CI.OPTION_CD = :CI-OPTION-CD                 
                     AND :WS-OPTION-LOADED = :WS-YES ) OR               
                         :WS-OPTION-LOADED = :WS-NO )                   
                   AND CI.COMPANY_NO  = :CI-COMPANY-NO                  
                   AND CI.PROC_REQ_ID = :CI-PROC-REQ-ID                 
                   AND CI.ACCESS_VRSN_NO   = (                          
                   SELECT MAX(C1.ACCESS_VRSN_NO  )                      
                     FROM CRM_ACCESS_OFF_OPT C1 WITH(READUNCOMMITTED)           
                    WHERE C1.COMPANY_NO   = CI.COMPANY_NO               
                      AND C1.OPTION_CD    = CI.OPTION_CD                
                      AND C1.OFFER_CD     = CI.OFFER_CD                 
                      AND C1.CATEGORY_ID  = CI.CATEGORY_ID )            
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OPTION_ACCESS_CUR CURSOR FOR                             
MFA-TR*         SELECT CI.COMPANY_NO                                            
MFA-TR*               ,CI.OPTION_CD                                             
MFA-TR*               ,CI.OFFER_CD                                              
MFA-TR*               ,CI.CATEGORY_ID                                           
MFA-TR*               ,CI.ACCESS_START_DT                                       
MFA-TR*               ,CI.ACCESS_END_DT                                         
MFA-TR*               ,CI.VIEW_APPLY_CD                                         
MFA-TR*               ,CI.LAST_UPDATE_USERID                                    
MFA-TR*               ,CI.LAST_UPDATE_TS                                        
MFA-TR*               ,CI.COMMENTS_TX                                           
MFA-TR*               ,CI.ACCESS_VRSN_NO                                        
MFA-TR*               ,CI.ACCESS_VSTART_TS                                      
MFA-TR*               ,CI.ACCESS_VEND_TS                                        
MFA-TR*               ,CI.PROC_STATUS_CD                                        
MFA-TR*               ,CI.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_ACCESS_OFF_OPT CI                                    
MFA-TR*          WHERE CI.OFFER_CD   = ' '                                      
MFA-TR*            AND ( ( CI.OPTION_CD = :CI-OPTION-CD                         
MFA-TR*              AND :WS-OPTION-LOADED = :WS-YES ) OR                       
MFA-TR*                  :WS-OPTION-LOADED = :WS-NO )                           
MFA-TR*            AND CI.COMPANY_NO  = :CI-COMPANY-NO                          
MFA-TR*            AND CI.PROC_REQ_ID = :CI-PROC-REQ-ID                         
MFA-TR*            AND CI.ACCESS_VRSN_NO   = (                                  
MFA-TR*            SELECT MAX(C1.ACCESS_VRSN_NO  )                              
MFA-TR*              FROM CRM_ACCESS_OFF_OPT C1                                 
MFA-TR*             WHERE C1.COMPANY_NO   = CI.COMPANY_NO                       
MFA-TR*               AND C1.OPTION_CD    = CI.OPTION_CD                        
MFA-TR*               AND C1.OFFER_CD     = CI.OFFER_CD                         
MFA-TR*               AND C1.CATEGORY_ID  = CI.CATEGORY_ID )                    
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7150                                                 
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGM-ID        PIC X(08).                           
       01  PARM-RESOURCE-ID        PIC X(32).                           
       01  PARM-USER-ID            PIC X(07).                           
       01  PARM-COMPANY-NO         PIC X(02).                           
       01  PARM-CODE-UTIL-TYPE     PIC X(01).                           
COB305 01 PARM-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.            
       01  PARM-PROC-STATUS-CD     PIC X(02).                           
      *                                                                         
       PROCEDURE DIVISION USING PARM-APPL-PGM-ID                        
                               ,PARM-RESOURCE-ID                        
                               ,PARM-USER-ID                            
                               ,PARM-COMPANY-NO                         
                               ,PARM-CODE-UTIL-TYPE                     
                               ,PARM-PROC-REQ-ID                        
                               ,PARM-PROC-STATUS-CD.                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04446_R1'       TO WS-GTT-NAME.             
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04446_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04446_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,RULE_NO CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,RULE_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,ERROR_HEADER_DESC CHAR(200)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(RULE_NO))              AS RULE_NO           
                      ,RULE_FLAG                   AS RULE_FLAG         
                      ,LTRIM(RTRIM(ERROR_HEADER_DESC))    AS 
           ERROR_HEADER_DESC 
                  FROM #CSR04446_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(RULE_NO)              AS RULE_NO                   
MFA-TR*               ,RULE_FLAG                   AS RULE_FLAG                 
MFA-TR*               ,STRIP(ERROR_HEADER_DESC)    AS ERROR_HEADER_DESC         
MFA-TR*           FROM SESSION.CSR04446_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           MOVE PARM-APPL-PGM-ID          TO WS-APPL-PGM-ID             
                                             WS-CRM-APPL-PGM-ID         
           MOVE PARM-RESOURCE-ID          TO WS-RPM-WIZARDS             
                                             WS-CRM-RESOURCE-ID         
                                                                        
           MOVE PARM-USER-ID              TO WS-CRM-USER-ID             
           MOVE PARM-COMPANY-NO           TO WS-CRM-COMPANY-NO          
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CRM-CODE-UTIL-TYPE      
           MOVE PARM-PROC-STATUS-CD       TO WS-PROC-STATUS-CD.         
           MOVE PARM-PROC-REQ-ID          TO WS-CRM-PROC-REQ-ID         
                                             1P-PROC-REQ-ID             
                                             4P-PROC-REQ-ID             
                                             WS-PROCESS-REQ-ID.         
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE PROGRAM-NAME              TO WS-CALLING-PGM-ID.         
                                                                        
           PERFORM 7105-ACCEPT-TIMESTAMP     THRU 7105-EXIT.            
      * WHEN THE PROC STAT CD IS REJECT WILL DEMOTE THE PROC STAT TO NW.        
           IF WS-PROC-STATUS-CD = WS-REJECTED                           
              SET PROC-STAT-CD-REJECTED   TO TRUE                       
              PERFORM 7106-GET-PROC-STAT-CD  THRU 7106-EXIT             
              MOVE 4P-PROC-STATUS-CD      TO WS-PROC-STATUS-CD          
           END-IF.                                                      
                                                                        
           PERFORM 2100-LOAD-PROCESS         THRU 2100-EXIT.            
                                                                        
           PERFORM 5000-UPDATE-PROCESS       THRU 5000-EXIT.            
                                                                        
           IF RULES-NOT-EXISTS                                          
              MOVE SPACES                 TO RS-RULE-NO                 
                                                RS-RULE-FLAG            
                                                RS-ERROR-HEADER-DESC    
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE             TO S-RETURN-CODE.            
           MOVE RS-APPL-RETURN-CODE        TO S-APPL-RETURN-CODE.       
           MOVE RS-RULE-NO                 TO S-RULE-NO.                
           MOVE RS-RULE-FLAG               TO S-RULE-FLAG.              
           MOVE RS-ERROR-HEADER-DESC       TO S-ERROR-HEADER-DESC.      
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-LOAD-PROCESS                                                       
      ******************************************************************        
       2100-LOAD-PROCESS.                                               
                                                                        
      *    LOAD OFFER, OPTION PROMOTION TO CWS00826                             
           MOVE WS-NORMAL-OFFER              TO WS-OFFER-TYPE           
                                                                        
           EVALUATE TRUE                                                
                                                                        
               WHEN CREATE-OFFER-WIZARD                                 
               WHEN MODIFY-OFFER-WIZARD                                 
                    PERFORM 2110-LOAD-OFFER-DETAILS                     
                                                THRU 2110-EXIT          
               WHEN CREATE-REPLACE-OFFER-WIZARD                         
                    MOVE WS-TEMPLATE-OFFER   TO WS-OFFER-TYPE           
                    MOVE WS-NO       TO WS-CRM-SET-PROMO-INT-EXT-FLGS   
                    MOVE WS-NO       TO WS-CRM-UNDFLT-TMPLT-OFFR-TIERS  
                    MOVE SPACES      TO WS-CRM-TEMPLATE-OFFER-CD        
                                                                        
                    PERFORM 2115-LOAD-TEMPLATE-OFFER                    
                                                THRU 2115-EXIT          
                    IF CRM-OFFER-CHANGE                                 
      *                TEMPLATE OFFER GOT CHANGED                               
      *                UPDATE THE STATUS FOR TEMPLATE OFFER                     
                       PERFORM 5000-UPDATE-PROCESS                      
                                                THRU 5000-EXIT          
                       MOVE SPACES           TO WS-CRM-OPERATION-ID     
                       IF WS-ERR-MSG-RETURN-CD <= 1 THEN                
      *                   NO ERRORS IN TEMPLATE OFFER                           
      *                   UPDATE THE STATUS FOR REPLACE OFFER                   
                          MOVE WS-REPLACE-OFFER                         
                                             TO WS-OFFER-TYPE           
                          PERFORM 2110-LOAD-OFFER-DETAILS               
                                                THRU 2110-EXIT          
                       END-IF                                           
                    ELSE                                                
      *                TEMPLATE OFFER WAS NOT CHANGED                           
      *                UPDATE THE STATUS FOR REPLACE OFFER                      
                       MOVE WS-REPLACE-OFFER TO WS-OFFER-TYPE           
                                                                        
                       PERFORM 2110-LOAD-OFFER-DETAILS                  
                                                THRU 2110-EXIT          
                    END-IF                                              
               WHEN MODIFY-OPTION-WIZARD                                
                    PERFORM 2120-LOAD-OPTION-DETAILS                    
                                                THRU 2120-EXIT          
               WHEN CREATE-PROMO-WIZARD                                 
               WHEN MODIFY-PROMO-WIZARD                                 
                    PERFORM 2130-LOAD-PROMOTION-DETAILS                 
                                                THRU 2130-EXIT          
           END-EVALUATE.                                                
                                                                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-LOAD-OFFER-DETAILS.                                       *        
      ******************************************************************        
       2110-LOAD-OFFER-DETAILS.                                         
                                                                        
           INITIALIZE WS-CRM-DATA-LAYOUT                                
                      WS-CRM-RETURN-INFO                                
                      WS-CRM-VLDT-INPUT-PARMS                           
                      WS-CRM-ERR-MSG-RETURN-INFO                        
                      WS-CRM-VALD-ERR-TABLE.                            
                                                                        
           MOVE SPACES                     TO WS-OFFER-CD.              
           MOVE PARM-COMPANY-NO            TO FG-COMPANY-NO             
                                              DU-COMPANY-NO             
                                              CI-COMPANY-NO             
                                              G5-COMPANY-NO             
                                              E9-COMPANY-NO.            
                                                                        
           MOVE WS-PROCESS-REQ-ID          TO FG-PROC-REQ-ID            
                                              DU-PROC-REQ-ID            
                                              CI-PROC-REQ-ID            
                                              G5-PROC-REQ-ID            
                                              E9-PROC-REQ-ID.           
                                                                        
                                                                        
      *    GETTING OFFER DETAILS BASED ON OFFER CD                              
           MOVE WS-YES                     TO WS-PROC-REQ-FLAG.         
           MOVE WS-NO                      TO WS-OFFER-LOADED.          
                                                                        
           PERFORM 7000-GET-OFFER-DETAILS     THRU 7000-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2200-MOVE-OFFER-DTLS    THRU 2200-EXIT            
              MOVE WS-YES                  TO WS-OFFER-LOADED           
           END-IF                                                       
                                                                        
           IF WS-OFFER-LOADED = WS-YES                                  
              MOVE FG-OFFER-CD             TO FG-OFFER-CD               
                                              DU-OFFER-CD               
                                              CI-OFFER-CD               
                                              G5-OFFER-CD               
                                              E9-OFFER-CD               
           END-IF.                                                      
                                                                        
           MOVE WS-NO                      TO WS-NO-MORE-OFFER-MKT-ROWS 
           SET WS-CRM-OFFR-TIER-INDX       TO +1.                       
                                                                        
           PERFORM 7050-OPEN-OFFER-MKT-CUR    THRU 7050-EXIT.           
           PERFORM 7060-FETCH-OFFER-MKT-CUR   THRU 7060-EXIT.           
           PERFORM 2210-MOVE-OFFER-MKT-DTLS   THRU 2210-EXIT            
             UNTIL NO-MORE-OFFER-MKT-ROWS.                              
           PERFORM 7070-CLOSE-OFFER-MKT-CUR   THRU 7070-EXIT.           
                                                                        
           MOVE WS-NO                   TO WS-NO-MORE-RATE-GRP-OFF-ROWS.
           SET WS-CRM-RT-GRP-OFFR-INDX     TO +1.                       
                                                                        
           PERFORM 7100-OPEN-RATE-GRP-OFF-CUR  THRU 7100-EXIT.          
           PERFORM 7110-FETCH-RATE-GRP-OFF-CUR THRU 7110-EXIT.          
           PERFORM 2220-MOVE-RATE-GRP-OFF-DTLS THRU 2220-EXIT           
             UNTIL NO-MORE-RATE-GRP-OFF-ROWS.                           
           PERFORM 7120-CLOSE-RATE-GRP-OFF-CUR THRU 7120-EXIT.          
                                                                        
           MOVE WS-NO                   TO WS-NO-MORE-OFFER-ACCESS-ROWS.
           SET WS-CRM-OFFR-ACCS-INDX       TO +1.                       
                                                                        
           PERFORM 7150-OPEN-OFFER-ACCESS-CUR  THRU 7150-EXIT.          
           PERFORM 7160-FETCH-OFFER-ACCESS-CUR THRU 7160-EXIT.          
           PERFORM 2230-MOVE-OFFER-ACCESS-DTLS THRU 2230-EXIT           
             UNTIL NO-MORE-OFFER-ACCESS-ROWS.                           
           PERFORM 7170-CLOSE-OFFER-ACCESS-CUR THRU 7170-EXIT.          
                                                                        
                                                                        
           IF WS-OFFER-CD > SPACES AND WS-OFFER-LOADED = WS-NO          
              MOVE WS-OFFER-CD          TO FG-OFFER-CD                  
                                           E9-OFFER-CD                  
              MOVE WS-NO                TO WS-PROC-REQ-FLAG             
                                                                        
              PERFORM 7000-GET-OFFER-DETAILS                            
                                        THRU 7000-EXIT                  
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2200-MOVE-OFFER-DTLS    THRU 2200-EXIT         
                 MOVE WS-YES                  TO WS-OFFER-LOADED        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES                     TO WS-CRM-OFFER-OPERATION    
           IF WS-OFFER-LOADED = WS-YES                                  
              SET CRM-OFFER-CHANGE         TO TRUE                      
           END-IF.                                                      
                                                                        
           MOVE WS-NO                   TO WS-NO-MORE-OFFER-OPTION-ROWS.
           SET WS-CRM-OPT-INDX             TO +1.                       
                                                                        
           PERFORM 7200-OPEN-OFFER-OPTION-CUR  THRU 7200-EXIT.          
           PERFORM 7210-FETCH-OFFER-OPTION-CUR THRU 7210-EXIT.          
           PERFORM 2240-MOVE-OFFER-OPTION-DTLS THRU 2240-EXIT           
             UNTIL NO-MORE-OFFER-OPTION-ROWS.                           
           PERFORM 7220-CLOSE-OFFER-OPTION-CUR THRU 7220-EXIT.          
                                                                        
           PERFORM 2130-LOAD-PROMOTION-DETAILS THRU 2130-EXIT.          
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2115-LOAD-TEMPLATE-OFFER.                                      *        
      ******************************************************************        
       2115-LOAD-TEMPLATE-OFFER.                                        
                                                                        
           MOVE SPACES                     TO WS-OFFER-CD.              
                                                                        
           MOVE PARM-COMPANY-NO            TO FG-COMPANY-NO             
                                              DU-COMPANY-NO.            
                                                                        
           MOVE WS-PROCESS-REQ-ID          TO FG-PROC-REQ-ID            
                                              DU-PROC-REQ-ID            
                                              CI-PROC-REQ-ID            
                                              G5-PROC-REQ-ID            
                                              E9-PROC-REQ-ID.           
                                                                        
      *    GETTING OFFER DETAILS BASED ON PROC REQ ID FIRST                     
           MOVE WS-YES                     TO WS-PROC-REQ-FLAG.         
           MOVE WS-NO                      TO WS-OFFER-LOADED.          
                                                                        
           PERFORM 7000-GET-OFFER-DETAILS     THRU 7000-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE FG-OFFER-CD TO WS-CRM-TEMPLATE-OFFER-CD              
              MOVE WS-YES      TO WS-CRM-SET-PROMO-INT-EXT-FLGS         
              PERFORM 2200-MOVE-OFFER-DTLS    THRU 2200-EXIT            
              MOVE WS-YES                  TO WS-OFFER-LOADED           
           END-IF                                                       
                                                                        
           IF WS-OFFER-LOADED = WS-YES                                  
              MOVE FG-OFFER-CD             TO FG-OFFER-CD               
                                              DU-OFFER-CD               
           END-IF.                                                      
                                                                        
           MOVE WS-NO                      TO WS-NO-MORE-OFFER-MKT-ROWS 
           SET WS-CRM-OFFR-TIER-INDX       TO +1.                       
                                                                        
           PERFORM 7050-OPEN-OFFER-MKT-CUR    THRU 7050-EXIT.           
           PERFORM 7060-FETCH-OFFER-MKT-CUR   THRU 7060-EXIT.           
           PERFORM 2210-MOVE-OFFER-MKT-DTLS   THRU 2210-EXIT            
             UNTIL NO-MORE-OFFER-MKT-ROWS.                              
           PERFORM 7070-CLOSE-OFFER-MKT-CUR   THRU 7070-EXIT.           
                                                                        
                                                                        
           IF WS-OFFER-CD > SPACES AND WS-OFFER-LOADED = WS-NO          
      * SINCE OLD OFFER IS NOT CHANGED BUT WE NEED THE OFFER                    
      * DETAIL FOR VALIDATION SO OFFER TYPE IS SET AS NORMAL OFFER              
      * TO GET THE MAX VERSION OF THE OFFER. ONCE DONE CHANGE THE               
      * OFFER TYE BACK TO TEMPLATE OFFER                                        
              MOVE WS-NORMAL-OFFER      TO WS-OFFER-TYPE                
              MOVE WS-OFFER-CD          TO FG-OFFER-CD                  
              MOVE WS-NO                TO WS-PROC-REQ-FLAG             
                                                                        
              PERFORM 7000-GET-OFFER-DETAILS                            
                                        THRU 7000-EXIT                  
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2200-MOVE-OFFER-DTLS    THRU 2200-EXIT         
                 MOVE WS-YES                  TO WS-OFFER-LOADED        
              END-IF                                                    
              MOVE WS-TEMPLATE-OFFER    TO WS-OFFER-TYPE                
           END-IF.                                                      
                                                                        
           MOVE SPACES                     TO WS-CRM-OFFER-OPERATION    
           IF WS-OFFER-LOADED = WS-YES                                  
              SET CRM-OFFER-CHANGE         TO TRUE                      
           END-IF.                                                      
                                                                        
       2115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2120-LOAD-OPTION-DETAILS.                                      *        
      ******************************************************************        
       2120-LOAD-OPTION-DETAILS.                                        
                                                                        
           MOVE SPACE                      TO WS-OPTION-CD.             
                                                                        
           MOVE PARM-COMPANY-NO            TO FI-COMPANY-NO             
                                              HQ-COMPANY-NO             
                                              CI-COMPANY-NO             
                                              E9-COMPANY-NO.            
                                                                        
           MOVE WS-PROCESS-REQ-ID          TO FI-PROC-REQ-ID            
                                              HQ-PROC-REQ-ID            
                                              CI-PROC-REQ-ID            
                                              E9-PROC-REQ-ID.           
                                                                        
                                                                        
      *    GETTING OPTION DETAILS BASED ON OPTION_CD                            
           IF MODIFY-OPTION-WIZARD                                      
              MOVE WS-YES                     TO WS-PROC-REQ-FLAG       
               SET WS-CRM-OPT-INDX            TO +1                     
           END-IF.                                                      
                                                                        
           MOVE WS-NO                      TO WS-OPTION-LOADED.         
                                                                        
           PERFORM 7300-GET-OPTION-DETAILS    THRU 7300-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2300-MOVE-OPTION-DTLS   THRU 2300-EXIT            
              MOVE WS-YES                  TO WS-OPTION-LOADED          
           END-IF.                                                      
                                                                        
           IF WS-OPTION-LOADED = WS-YES                                 
              MOVE FI-OPTION-CD            TO HQ-OPTION-CD              
                                              CI-OPTION-CD              
                                              E9-OPTION-CD              
           END-IF.                                                      
                                                                        
      * LOAD THE OPTION ATTRIBUTE DETAILS                                       
           MOVE WS-NO                      TO WS-NO-MORE-OPTN-ATRB-ROWS 
           SET WS-CRM-ATTRB-INDX           TO +1.                       
                                                                        
           PERFORM 7350-OPEN-OPTION-ATRB-CUR   THRU 7350-EXIT.          
           PERFORM 7360-FETCH-OPTION-ATRB-CUR  THRU 7360-EXIT.          
           PERFORM 2310-MOVE-OPTION-ATRB-DTLS  THRU 2310-EXIT           
             UNTIL NO-MORE-OPTN-ATRB-ROWS.                              
           PERFORM 7370-CLOSE-OPTION-ATRB-CUR  THRU 7370-EXIT.          
                                                                        
      * LOAD THE OPTION ACCESS DETAILS                                          
           MOVE WS-NO                   TO WS-NO-MORE-OPTN-ACCESS-ROWS. 
           SET WS-CRM-OPTN-ACCS-INDX       TO +1.                       
                                                                        
           PERFORM 7400-OPEN-OPTION-ACCESS-CUR  THRU 7400-EXIT.         
           PERFORM 7410-FETCH-OPTION-ACCESS-CUR THRU 7410-EXIT.         
           PERFORM 2320-MOVE-OPTION-ACCESS-DTLS THRU 2320-EXIT          
             UNTIL NO-MORE-OPTN-ACCESS-ROWS.                            
           PERFORM 7420-CLOSE-OPTION-ACCESS-CUR THRU 7420-EXIT.         
                                                                        
      * LOAD THE OPTION DETAILS IF STILL OPTION IS NOT LOADED.                  
      * BUT THERE IS OPTION ATTRIBUTE OR OPTION ACCESS LOADED.                  
      * FOR REQUESTED PROC-REQ-ID                                               
      * FOLLOWING HAS TO BE DONE ONLY WHEN IT IS MODIFY OPTION WIZARD           
           IF WS-OPTION-CD       > SPACES                               
            AND WS-OPTION-LOADED = WS-NO                                
            AND MODIFY-OPTION-WIZARD                                    
              MOVE WS-OPTION-CD         TO FI-OPTION-CD                 
              MOVE WS-NO                TO WS-PROC-REQ-FLAG             
                                                                        
              PERFORM 7300-GET-OPTION-DETAILS                           
                                        THRU 7300-EXIT                  
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 2300-MOVE-OPTION-DTLS   THRU 2300-EXIT         
                 MOVE WS-YES                  TO WS-OPTION-LOADED       
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE SPACES                     TO WS-CRM-OPTION-OPERATION   
           IF WS-OPTION-LOADED = WS-YES                                 
              SET CRM-OPTION-CHANGE        TO TRUE                      
      * LOAD THE OFFER OPTION DETAILS ONLY WHEN MODIFY OPTION WIZARD            
              IF MODIFY-OPTION-WIZARD                                   
                 PERFORM 7320-GET-OFF-OPT-FOR-OPTION                    
                                        THRU 7320-EXIT                  
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    PERFORM 2240-MOVE-OFFER-OPTION-DTLS                 
                                        THRU 2240-EXIT                  
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2130-LOAD-PROMOTION-DETAILS.                                   *        
      ******************************************************************        
       2130-LOAD-PROMOTION-DETAILS.                                     
                                                                        
           MOVE PARM-COMPANY-NO            TO KM-COMPANY-NO             
                                                                        
           MOVE WS-PROCESS-REQ-ID          TO KM-PROC-REQ-ID            
                                                                        
                                                                        
      *    GETTING PROMO DETAILS BASED ON PROC-REQ-ID                           
           MOVE SPACES                     TO WS-CRM-PROMO-OPERATION    
                                                                        
           PERFORM 7500-GET-PROMO-DETAILS     THRU 7500-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              SET WS-CRM-PROMO-INDX    TO +1                            
              PERFORM 2500-MOVE-PROMO-DTLS    THRU 2500-EXIT            
              SET CRM-PROMOTION-CHANGE     TO TRUE                      
           END-IF.                                                      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 2200-MOVE-OFFER-DTLS                                           *        
      ******************************************************************        
       2200-MOVE-OFFER-DTLS.                                            
                                                                        
           MOVE FG-OFFER-CD            TO WS-CRM-OFFER-CD-FG            
                                          WS-OFFER-CD                   
           MOVE FG-OFFER-DESC-INT      TO WS-CRM-OFFER-DESC-INT-FG      
           MOVE FG-OFFER-DESC-EXT      TO WS-CRM-OFFER-DESC-EXT-FG      
           MOVE FG-PROMO-CD-INT-FL     TO WS-CRM-PROMO-CD-INT-FL-FG     
           MOVE FG-PROMO-CD-EXT-FL     TO WS-CRM-PROMO-CD-EXT-FL-FG     
           MOVE FG-OFFER-START-DT      TO WS-CRM-OFFER-START-DT-FG      
           MOVE FG-OFFER-END-DT        TO WS-CRM-OFFER-END-DT-FG        
           MOVE FG-DISP-START-INT-TS   TO WS-CRM-DISP-START-INT-TS-FG   
           MOVE FG-DISP-END-INT-TS     TO WS-CRM-DISP-END-INT-TS-FG     
           MOVE FG-DISP-START-EXT-TS   TO WS-CRM-DISP-START-EXT-TS-FG   
           MOVE FG-DISP-END-EXT-TS     TO WS-CRM-DISP-END-EXT-TS-FG     
           MOVE FG-LAST-UPDATE-TS      TO WS-CRM-LAST-UPDATE-TS-FG      
                                                                        
           MOVE FG-OFFER-DESC-INT-LNG-LEN                               
                                       TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO WS-CRM-OFFR-DSC-INT-LNG-LEN-FG
           MOVE FG-OFFER-DESC-INT-LNG-TEXT                              
                                       TO WS-CRM-OFFR-DSC-INT-LNG-TXT-FG
                                                                        
           MOVE FG-OFFER-DESC-EXT-LNG-LEN                               
                                       TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO WS-CRM-OFFR-DSC-EXT-LNG-LEN-FG
           MOVE FG-OFFER-DESC-EXT-LNG-TEXT                              
                                       TO WS-CRM-OFFR-DSC-EXT-LNG-TXT-FG
                                                                        
           MOVE FG-SPCL-OFFER-TYPE-CD  TO WS-CRM-SPCL-OFFER-TYPE-CD-FG  
           MOVE FG-RENEWAL-OFFER-CD    TO WS-CRM-RENEWAL-OFFER-CD-FG    
           MOVE FG-RENEW-PUB-OFFER-CD  TO WS-CRM-RENEW-PUB-OFFER-CD-FG  
                                                                        
           MOVE FG-OFF-VRSN-NO         TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO WS-CRM-OFF-VRSN-NO-FG         
           MOVE FG-OFF-VSTART-TS       TO WS-CRM-OFF-VSTART-TS-FG       
           MOVE FG-OFF-VEND-TS         TO WS-CRM-OFF-VEND-TS-FG         
PRJ680     MOVE FG-MAX-PRICE-OFFER-CD  TO WS-CRM-MAX-PRICE-OFFER-CD-FG  
P00863     MOVE FG-RTCHG-PUB-OFFER-CD  TO WS-CRM-RTCHG-PUB-OFFER-CD-FG  
                                                                        
           IF FG-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE FG-OFF-VSTART-TS    TO WS-CRM-VRSN-TIMESTAMP         
              MOVE WS-UPDATE           TO WS-CRM-OFFER-UPDT-IND         
              MOVE WS-PROC-STATUS-CD   TO WS-CRM-OFF-PRC-STAT-CD-FG     
              MOVE WS-PROCESS-REQ-ID   TO WS-DECIMAL-10V0-NUM-RED       
              MOVE WS-DECIMAL-10V0-NUM TO WS-CRM-OFF-PRC-REQ-ID-FG      
           ELSE                                                         
              MOVE WS-REFERENCE        TO WS-CRM-OFFER-UPDT-IND         
              MOVE FG-PROC-STATUS-CD   TO WS-CRM-OFF-PRC-STAT-CD-FG     
              MOVE FG-PROC-REQ-ID      TO WS-DECIMAL-10V0-NUM-RED       
              MOVE WS-DECIMAL-10V0-NUM TO WS-CRM-OFF-PRC-REQ-ID-FG      
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-MOVE-OFFER-MKT-DTLS                                       *        
      ******************************************************************        
       2210-MOVE-OFFER-MKT-DTLS.                                        
                                                                        
           IF CREATE-REPLACE-OFFER-WIZARD AND                           
              WS-OFFER-TYPE = WS-TEMPLATE-OFFER                         
              MOVE DU-OFFER-CD       TO WS-CRM-TEMPLATE-OFFER-CD        
              MOVE WS-YES            TO WS-CRM-UNDFLT-TMPLT-OFFR-TIERS  
           END-IF                                                       
                                                                        
           MOVE DU-OFFER-CD            TO                               
                   WS-CRM-OFFER-CD-DU(WS-CRM-OFFR-TIER-INDX)            
                   WS-OFFER-CD                                          
           MOVE DU-TIER-CUST-STAT-CD   TO                               
                   WS-CRM-TIER-CUST-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX)   
           MOVE DU-TIER-ACCT-TYPE-CD   TO                               
                   WS-CRM-TIER-ACCT-TYPE-CD-DU(WS-CRM-OFFR-TIER-INDX)   
                                                                        
           MOVE DU-MKT-TIER-RANKING    TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO                               
                   WS-CRM-MKT-TIER-RANKING-DU(WS-CRM-OFFR-TIER-INDX)    
                                                                        
           MOVE DU-MKT-TIER-START-DT   TO                               
                   WS-CRM-MKT-TIER-START-DT-DU(WS-CRM-OFFR-TIER-INDX)   
           MOVE DU-OFFER-TIER-STRT-DT  TO                               
                   WS-CRM-OFFER-TIER-STRT-DT-DU(WS-CRM-OFFR-TIER-INDX)  
           MOVE DU-MKT-TIER-APPLY-CD   TO                               
                   WS-CRM-MKT-TIER-APPLY-CD-DU(WS-CRM-OFFR-TIER-INDX)   
           MOVE DU-TIER-DEFLT-OFFR-CD  TO                               
                   WS-CRM-TIER-DEFLT-OFFR-CD-DU(WS-CRM-OFFR-TIER-INDX)  
           MOVE DU-OFFER-TIER-END-DT   TO                               
                   WS-CRM-OFFER-TIER-END-DT-DU(WS-CRM-OFFR-TIER-INDX)   
           MOVE DU-LAST-UPDATE-TS      TO                               
                   WS-CRM-LAST-UPDATE-TS-DU(WS-CRM-OFFR-TIER-INDX)      
                                                                        
           MOVE DU-OFF-TIER-VRSN-NO   TO WS-SMALLINT-NUM                
           MOVE WS-SMALLINT-NUM       TO                                
                   WS-CRM-OFF-TER-VRSN-NO-DU(WS-CRM-OFFR-TIER-INDX)     
           MOVE DU-OFF-TIER-VSTART-TS TO                                
                   WS-CRM-OFF-TER-VSTART-TS-DU(WS-CRM-OFFR-TIER-INDX)   
           MOVE DU-OFF-TIER-VEND-TS   TO                                
                   WS-CRM-OFF-TER-VEND-TS-DU(WS-CRM-OFFR-TIER-INDX)     
           MOVE DU-PROC-REQ-ID        TO WS-DECIMAL-10V0-NUM-RED        
           MOVE WS-DECIMAL-10V0-NUM   TO                                
                   WS-CRM-OFF-TER-PRC-REQ-ID-DU(WS-CRM-OFFR-TIER-INDX)  
                                                                        
           IF FG-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE DU-OFF-TIER-VSTART-TS TO WS-CRM-VRSN-TIMESTAMP       
              MOVE WS-UPDATE           TO                               
                   WS-CRM-OFFR-TIER-IND-DU(WS-CRM-OFFR-TIER-INDX)       
              MOVE WS-PROC-STATUS-CD   TO                               
                   WS-CRM-OFF-TER-PRC-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX) 
           ELSE                                                         
              MOVE WS-REFERENCE        TO                               
                   WS-CRM-OFFR-TIER-IND-DU(WS-CRM-OFFR-TIER-INDX)       
              MOVE DU-PROC-STATUS-CD   TO                               
                   WS-CRM-OFF-TER-PRC-STAT-CD-DU(WS-CRM-OFFR-TIER-INDX) 
           END-IF.                                                      
                                                                        
           PERFORM 7060-FETCH-OFFER-MKT-CUR   THRU 7060-EXIT.           
           SET WS-CRM-OFFR-TIER-INDX   UP BY +1.                        
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2220-MOVE-RATE-GRP-OFF-DTLS                                             
      ******************************************************************        
       2220-MOVE-RATE-GRP-OFF-DTLS.                                     
                                                                        
           MOVE G5-RATE-GROUP-TYPE-CD  TO                               
                 WS-CRM-RATE-GROUP-TYPE-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)  
           MOVE G5-RATE-GROUP-CD       TO                               
                 WS-CRM-RATE-GROUP-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)       
           MOVE G5-SORT-SEQ-NO         TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO                               
                 WS-CRM-SORT-SEQ-NO-G5(WS-CRM-RT-GRP-OFFR-INDX)         
           MOVE G5-EFF-START-DT        TO                               
                 WS-CRM-EFF-START-DT-G5 (WS-CRM-RT-GRP-OFFR-INDX)       
           MOVE G5-EFF-END-DT          TO                               
                 WS-CRM-EFF-END-DT-G5   (WS-CRM-RT-GRP-OFFR-INDX)       
           MOVE G5-OFFER-CD            TO                               
                 WS-CRM-OFFER-CD-G5     (WS-CRM-RT-GRP-OFFR-INDX)       
                 WS-OFFER-CD                                            
           MOVE G5-OPTION-CD           TO                               
                 WS-CRM-OPTION-CD-G5    (WS-CRM-RT-GRP-OFFR-INDX)       
           MOVE G5-LAST-UPDATE-TS      TO                               
                 WS-CRM-LAST-UPDATE-TS-G5(WS-CRM-RT-GRP-OFFR-INDX)      
           MOVE G5-GRP-OFF-VRSN-NO     TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO                               
                 WS-CRM-GRP-OFF-VRSN-NO-G5(WS-CRM-RT-GRP-OFFR-INDX)     
           MOVE G5-GRP-OFF-VSTART-TS   TO                               
                 WS-CRM-GRP-OFF-VSTART-TS-G5(WS-CRM-RT-GRP-OFFR-INDX)   
                                                                        
           MOVE G5-GRP-OFF-VEND-TS     TO                               
                 WS-CRM-GRP-OFF-VEND-TS-G5  (WS-CRM-RT-GRP-OFFR-INDX)   
           MOVE G5-PROC-REQ-ID         TO WS-DECIMAL-10V0-NUM-RED       
           MOVE WS-DECIMAL-10V0-NUM    TO                               
                   WS-CRM-GRP-OFF-PRC-REQ-ID-G5(WS-CRM-RT-GRP-OFFR-INDX)
                                                                        
           IF G5-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE G5-GRP-OFF-VSTART-TS  TO WS-CRM-VRSN-TIMESTAMP       
              MOVE WS-UPDATE           TO                               
                   WS-CRM-RT-GRP-OFFR-IND-G5(WS-CRM-RT-GRP-OFFR-INDX)   
              MOVE WS-PROC-STATUS-CD   TO                               
                  WS-CRM-GRP-OFF-PRC-STAT-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)
           ELSE                                                         
              MOVE WS-REFERENCE        TO                               
                   WS-CRM-RT-GRP-OFFR-IND-G5(WS-CRM-RT-GRP-OFFR-INDX)   
              MOVE G5-PROC-STATUS-CD      TO                            
                  WS-CRM-GRP-OFF-PRC-STAT-CD-G5(WS-CRM-RT-GRP-OFFR-INDX)
           END-IF.                                                      
                                                                        
           PERFORM 7110-FETCH-RATE-GRP-OFF-CUR THRU 7110-EXIT.          
           SET WS-CRM-RT-GRP-OFFR-INDX UP BY +1.                        
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2230-MOVE-OFFER-ACCESS-DTLS                                             
      ******************************************************************        
       2230-MOVE-OFFER-ACCESS-DTLS.                                     
                                                                        
           MOVE CI-OPTION-CD           TO                               
                WS-CRM-OFFR-OPTION-CD-CI    (WS-CRM-OFFR-ACCS-INDX)     
           MOVE CI-OFFER-CD            TO WS-OFFER-CD                   
                WS-CRM-OFFR-OFFER-CD-CI     (WS-CRM-OFFR-ACCS-INDX)     
           MOVE CI-CATEGORY-ID         TO  WS-INTEGER-NUM               
           MOVE WS-INTEGER-NUM         TO                               
                WS-CRM-OFFR-CATEGORY-ID-CI  (WS-CRM-OFFR-ACCS-INDX)     
           MOVE CI-ACCESS-START-DT     TO                               
                WS-CRM-OFFR-ACCES-START-DT-CI(WS-CRM-OFFR-ACCS-INDX)    
           MOVE CI-ACCESS-END-DT       TO                               
                WS-CRM-OFFR-ACCESS-END-DT-CI (WS-CRM-OFFR-ACCS-INDX)    
           MOVE CI-VIEW-APPLY-CD       TO                               
                WS-CRM-OFFR-VIEW-APPLY-CD-CI (WS-CRM-OFFR-ACCS-INDX)    
           MOVE CI-LAST-UPDATE-TS      TO                               
                WS-CRM-OFFR-LAST-UPDATE-TS-CI(WS-CRM-OFFR-ACCS-INDX)    
           MOVE CI-COMMENTS-TX         TO                               
                WS-CRM-OFFR-COMMENTS-TX-CI   (WS-CRM-OFFR-ACCS-INDX)    
           MOVE CI-ACCESS-VRSN-NO      TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO                               
                WS-CRM-OFF-ACS-VRSN-NO-CI    (WS-CRM-OFFR-ACCS-INDX)    
           MOVE CI-ACCESS-VSTART-TS    TO                               
                WS-CRM-OFF-ACS-VSTART-TS-CI  (WS-CRM-OFFR-ACCS-INDX)    
           MOVE CI-ACCESS-VEND-TS      TO                               
                WS-CRM-OFF-ACS-VEND-TS-CI    (WS-CRM-OFFR-ACCS-INDX)    
           MOVE CI-PROC-REQ-ID         TO WS-DECIMAL-10V0-NUM-RED       
           MOVE WS-DECIMAL-10V0-NUM    TO                               
                WS-CRM-OFF-ACS-PRC-REQ-ID-CI(WS-CRM-OFFR-ACCS-INDX)     
                                                                        
           IF CI-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE CI-ACCESS-VSTART-TS TO WS-CRM-VRSN-TIMESTAMP         
              MOVE WS-UPDATE           TO                               
                WS-CRM-OFFR-ACCS-IND-CI(WS-CRM-OFFR-ACCS-INDX)          
              MOVE WS-PROC-STATUS-CD   TO                               
                WS-CRM-OFF-ACS-PRC-STAT-CD-CI(WS-CRM-OFFR-ACCS-INDX)    
           ELSE                                                         
              MOVE WS-REFERENCE        TO                               
                WS-CRM-OFFR-ACCS-IND-CI(WS-CRM-OFFR-ACCS-INDX)          
              MOVE CI-PROC-STATUS-CD      TO                            
                WS-CRM-OFF-ACS-PRC-STAT-CD-CI(WS-CRM-OFFR-ACCS-INDX)    
           END-IF.                                                      
                                                                        
           PERFORM 7160-FETCH-OFFER-ACCESS-CUR THRU 7160-EXIT.          
           SET WS-CRM-OFFR-ACCS-INDX   UP BY +1.                        
                                                                        
       2230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2240-MOVE-OFFER-OPTION-DTLS                                             
      ******************************************************************        
       2240-MOVE-OFFER-OPTION-DTLS.                                     
                                                                        
           MOVE E9-OFFER-CD            TO                               
                 WS-CRM-OFFER-CD-E9      (WS-CRM-OPT-INDX)              
           MOVE E9-OPTION-CD           TO FI-OPTION-CD                  
                 WS-CRM-OPTION-CD-E9     (WS-CRM-OPT-INDX)              
           MOVE E9-OPTION-SORT-SEQ-NO  TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO                               
              WS-CRM-OPTION-SORT-SEQ-NO-E9(WS-CRM-OPT-INDX)             
                                                                        
           MOVE E9-OPTION-URL-TX-LEN   TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO                               
              WS-CRM-OPTION-URL-TX-LEN-E9 (WS-CRM-OPT-INDX)             
           MOVE E9-OPTION-URL-TX-TEXT  TO                               
              WS-CRM-OPTION-URL-TX-TXT-E9 (WS-CRM-OPT-INDX)             
           MOVE E9-LAST-UPDATE-TS      TO                               
              WS-CRM-LAST-UPDATE-TS-E9    (WS-CRM-OPT-INDX)             
           MOVE E9-DROP-OPTION-CD      TO                               
              WS-CRM-DROP-OPTION-CD-E9    (WS-CRM-OPT-INDX)             
           MOVE E9-OFFER-OPT-START-DT  TO                               
              WS-CRM-OFFER-OPT-START-DT-E9(WS-CRM-OPT-INDX)             
           MOVE E9-OFFER-OPT-END-DT    TO                               
              WS-CRM-OFFER-OPT-END-DT-E9  (WS-CRM-OPT-INDX)             
           MOVE E9-OFF-OPT-VRSN-NO     TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO                               
              WS-CRM-OFF-OPT-VRSN-NO-E9   (WS-CRM-OPT-INDX)             
           MOVE E9-OFF-OPT-VSTART-TS   TO                               
              WS-CRM-OFF-OPT-VSTART-TS-E9 (WS-CRM-OPT-INDX)             
           MOVE E9-OFF-OPT-VEND-TS     TO                               
              WS-CRM-OFF-OPT-VEND-TS-E9   (WS-CRM-OPT-INDX)             
           MOVE E9-PROC-REQ-ID         TO WS-DECIMAL-10V0-NUM-RED       
           MOVE WS-DECIMAL-10V0-NUM    TO                               
              WS-CRM-OFF-OPT-PRC-REQ-ID-E9(WS-CRM-OPT-INDX)             
                                                                        
           IF E9-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE E9-OFF-OPT-VSTART-TS TO WS-CRM-VRSN-TIMESTAMP        
              MOVE WS-UPDATE           TO                               
                WS-CRM-OFFER-OPT-IND   (WS-CRM-OPT-INDX)                
              MOVE WS-PROC-STATUS-CD   TO                               
                WS-CRM-OFF-OPT-PRC-STAT-CD-E9(WS-CRM-OPT-INDX)          
           ELSE                                                         
              MOVE WS-REFERENCE        TO                               
                WS-CRM-OFFER-OPT-IND   (WS-CRM-OPT-INDX)                
              MOVE E9-PROC-STATUS-CD      TO                            
                WS-CRM-OFF-OPT-PRC-STAT-CD-E9(WS-CRM-OPT-INDX)          
           END-IF.                                                      
                                                                        
A04805     MOVE E9-WEB-NEW-EXISTS-CD   TO                               
A04805        WS-CRM-WEB-NEW-EXISTS-CD-E9(WS-CRM-OPT-INDX)              
A04805     MOVE E9-WEB-SIGN-UP-FL      TO                               
A04805        WS-CRM-WEB-SIGN-UP-FL-E9(WS-CRM-OPT-INDX)                 
A04805     MOVE E9-OFF-OPT-EXCLUDE-CD  TO                               
A04805        WS-CRM-OFF-OPT-EXCLUDE-CD-E9(WS-CRM-OPT-INDX)             
                                                                        
      *                                                                         
      * GET THE OPTION DETAILS ONLY FOR OFFER WIZARDS                           
      * OFFER OPTION IS LOADED SEPARATELY IN MODIFY OPTION WIZARD               
      * AND NOT REQUIRED TO PERFORM THE FOLLOWING                               
      *                                                                         
           IF CREATE-OFFER-WIZARD                                       
            OR MODIFY-OFFER-WIZARD                                      
            OR CREATE-REPLACE-OFFER-WIZARD                              
              MOVE WS-NO                       TO WS-PROC-REQ-FLAG      
              PERFORM 2120-LOAD-OPTION-DETAILS    THRU 2120-EXIT        
              PERFORM 7210-FETCH-OFFER-OPTION-CUR THRU 7210-EXIT        
                                                                        
              SET WS-CRM-OPT-INDX         UP BY +1                      
           END-IF.                                                      
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-MOVE-OPTION-DTLS                                                   
      ******************************************************************        
       2300-MOVE-OPTION-DTLS.                                           
                                                                        
           MOVE FI-OPTION-CD                  TO WS-OPTION-CD           
                WS-CRM-OPTION-CD-FI          (WS-CRM-OPT-INDX)          
           MOVE FI-RATE-PLAN-NO               TO                        
                WS-CRM-RATE-PLAN-NO-FI       (WS-CRM-OPT-INDX)          
           MOVE FI-OPTION-START-DT            TO                        
                WS-CRM-OPTION-START-DT-FI    (WS-CRM-OPT-INDX)          
           MOVE FI-OPTION-END-DT              TO                        
                WS-CRM-OPTION-END-DT-FI      (WS-CRM-OPT-INDX)          
           MOVE FI-OPT-DESC-INT               TO                        
                WS-CRM-OPT-DESC-INT-FI       (WS-CRM-OPT-INDX)          
           MOVE FI-OPT-DESC-INT-LONG-LEN      TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-OPT-DESC-INT-LNG-LEN-FI(WS-CRM-OPT-INDX)         
           MOVE FI-OPT-DESC-INT-LONG-TEXT     TO                        
                WS-CRM-OPT-DESC-INT-LNG-TXT-FI(WS-CRM-OPT-INDX)         
           MOVE FI-CURR-EXT-DESC-LONG-LEN     TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-CURR-EXT-DSC-LNG-LEN-FI(WS-CRM-OPT-INDX)         
           MOVE FI-CURR-EXT-DESC-LONG-TEXT    TO                        
                WS-CRM-CURR-EXT-DSC-LNG-TXT-FI(WS-CRM-OPT-INDX)         
           MOVE FI-RENEWAL-DESC-LONG-LEN      TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-RENEWAL-DESC-LNG-LEN-FI(WS-CRM-OPT-INDX)         
           MOVE FI-RENEWAL-DESC-LONG-TEXT     TO                        
                WS-CRM-RENEWAL-DESC-LNG-TXT-FI(WS-CRM-OPT-INDX)         
           MOVE FI-WEB-DESC-LONG-LEN          TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-WEB-DESC-LONG-LEN-FI   (WS-CRM-OPT-INDX)         
           MOVE FI-WEB-DESC-LONG-TEXT         TO                        
                WS-CRM-WEB-DESC-LONG-TXT-FI   (WS-CRM-OPT-INDX)         
           MOVE FI-STATUS-CD                  TO                        
                WS-CRM-STATUS-CD-FI           (WS-CRM-OPT-INDX)         
           MOVE FI-LAST-UPDATE-TS             TO                        
                WS-CRM-LAST-UPDATE-TS-FI      (WS-CRM-OPT-INDX)         
           MOVE FI-OPT-CALC-TYPE-CD           TO                        
                WS-CRM-OPT-CALC-TYPE-CD-FI    (WS-CRM-OPT-INDX)         
           MOVE FI-WEB-MKT-DESC-LONG-LEN      TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-WEB-MKT-DESC-LNG-LEN-FI(WS-CRM-OPT-INDX)         
           MOVE FI-WEB-MKT-DESC-LONG-TEXT     TO                        
                WS-CRM-WEB-MKT-DESC-LNG-TXT-FI(WS-CRM-OPT-INDX)         
           MOVE FI-OPT-VRSN-NO                TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-OPT-VRSN-NO-FI         (WS-CRM-OPT-INDX)         
           MOVE FI-OPT-VSTART-TS              TO                        
                WS-CRM-OPT-VSTART-TS-FI       (WS-CRM-OPT-INDX)         
           MOVE FI-OPT-VEND-TS                TO                        
                WS-CRM-OPT-VEND-TS-FI         (WS-CRM-OPT-INDX)         
           MOVE FI-PROC-REQ-ID         TO WS-DECIMAL-10V0-NUM-RED       
           MOVE WS-DECIMAL-10V0-NUM    TO                               
                        WS-CRM-OPT-PRC-REQ-ID-FI(WS-CRM-OPT-INDX)       
                                                                        
           IF FI-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE FI-OPT-VSTART-TS           TO WS-CRM-VRSN-TIMESTAMP  
              MOVE WS-UPDATE                  TO                        
                WS-CRM-OPTION-UPDT-IND-FI     (WS-CRM-OPT-INDX)         
              MOVE WS-PROC-STATUS-CD          TO                        
                WS-CRM-OPT-PRC-STAT-CD-FI     (WS-CRM-OPT-INDX)         
           ELSE                                                         
              MOVE WS-REFERENCE        TO                               
                WS-CRM-OPTION-UPDT-IND-FI     (WS-CRM-OPT-INDX)         
              MOVE FI-PROC-STATUS-CD      TO                            
                WS-CRM-OPT-PRC-STAT-CD-FI     (WS-CRM-OPT-INDX)         
           END-IF.                                                      
                                                                        
A04805     MOVE FI-OPTION-TYPE-DESC           TO                        
A04805          WS-CRM-OPTION-TYPE-DESC-FI    (WS-CRM-OPT-INDX).        
PRJ892     MOVE FI-AUTO-RENEWAL-FL            TO                        
PRJ892          WS-CRM-AUTO-RENEWAL-FL-FI     (WS-CRM-OPT-INDX).        
PRJ892     MOVE FI-OPTION-PROMO-DESC-LEN      TO                        
PRJ892          WS-CRM-OPTION-PROMO-DES-LEN-FI(WS-CRM-OPT-INDX).        
PRJ892     MOVE FI-OPTION-PROMO-DESC-TEXT     TO                        
PRJ892          WS-CRM-OPTION-PROMO-DES-TXT-FI(WS-CRM-OPT-INDX).        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2310-MOVE-OPTION-ATRB-DTLS.                                             
      ******************************************************************        
       2310-MOVE-OPTION-ATRB-DTLS.                                      
                                                                        
           MOVE HQ-OPTION-CD                  TO WS-OPTION-CD           
                WS-CRM-OPTION-CD-HQ           ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-ATTR-INCTV-SEQ-NO          TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-ATTR-INCTV-SEQ-NO-HQ   ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-RT-ATTR-INCTV-TYPE         TO                        
                WS-CRM-RT-ATTR-INCTV-TYPE-HQ  ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-PRIMRY-OPT-ATTR-FL         TO                        
                WS-CRM-PRIMRY-OPT-ATTR-FL-HQ  ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-FACTOR-ID                  TO                        
                WS-CRM-FACTOR-ID-HQ           ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-DURATION-NO                TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-DURATION-NO-HQ         ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-APPL-PROGRAM-ID            TO                        
                WS-CRM-APPL-PROGRAM-ID-HQ     ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           IF HQ-ATTR-INCTV-VALUE < 0                                   
              MOVE '-'                        TO                        
                WS-CRM-ATTR-INCTV-VALUE-SGN-HQ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           ELSE                                                         
              MOVE '0'                        TO                        
                WS-CRM-ATTR-INCTV-VALUE-SGN-HQ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           END-IF                                                       
           MOVE HQ-ATTR-INCTV-VALUE           TO WS-DECIMAL-5V6-NUM-RED 
           MOVE WS-DECIMAL-5V6-NUM            TO                        
                WS-CRM-ATTR-INCTV-VALUE-VAL-HQ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-ATTR-INCTV-VAL-TX          TO                        
                WS-CRM-ATTR-INCTV-VAL-TX-HQ   ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-LAST-UPDATE-TS             TO                        
                WS-CRM-LAST-UPDATE-TS-HQ      ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           IF HQ-GL-ACCT-CREDIT   < 0                                   
              MOVE '-'                        TO                        
                WS-CRM-GL-ACCT-CREDIT-SGN-HQ  ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           ELSE                                                         
              MOVE '0'                        TO                        
                WS-CRM-GL-ACCT-CREDIT-SGN-HQ  ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           END-IF                                                       
           MOVE HQ-GL-ACCT-CREDIT             TO WS-DECIMAL-3V4-NUM-RED 
           MOVE WS-DECIMAL-3V4-NUM            TO                        
                WS-CRM-GL-ACCT-CREDIT-VAL-HQ  ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           IF HQ-GL-ACCT-DEBIT    < 0                                   
              MOVE '-'                        TO                        
                WS-CRM-GL-ACCT-DEBIT-SGN-HQ   ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           ELSE                                                         
              MOVE '0'                        TO                        
                WS-CRM-GL-ACCT-DEBIT-SGN-HQ   ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           END-IF                                                       
           MOVE HQ-GL-ACCT-DEBIT              TO WS-DECIMAL-3V4-NUM-RED 
           MOVE WS-DECIMAL-3V4-NUM            TO                        
                WS-CRM-GL-ACCT-DEBIT-VAL-HQ   ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-CATEGORY-ID                TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-CATEGORY-ID-HQ         ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-WQ-ROUTE-CATEGORY          TO                        
                WS-CRM-WQ-ROUTE-CATEGORY-HQ   ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-OPT-CHG-ACTION-CD          TO                        
                WS-CRM-OPT-CHG-ACTION-CD-HQ   ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-ATTR-INCTV-STRT-DT         TO                        
                WS-CRM-ATTR-INCTV-STRT-DT-HQ  ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-ATTR-INCTV-END-DT          TO                        
                WS-CRM-ATTR-INCTV-END-DT-HQ   ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-OPT-ATTR-VRSN-NO           TO WS-SMALLINT-NUM        
           MOVE WS-SMALLINT-NUM               TO                        
                WS-CRM-OPT-ATRB-VRSN-NO-HQ    ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-OPT-ATTR-VSTART-TS         TO                        
                WS-CRM-OPT-ATRB-VSTART-TS-HQ  ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-OPT-ATTR-VEND-TS           TO                        
                WS-CRM-OPT-ATRB-VEND-TS-HQ    ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           MOVE HQ-PROC-REQ-ID         TO WS-DECIMAL-10V0-NUM-RED       
           MOVE WS-DECIMAL-10V0-NUM    TO                               
                   WS-CRM-OPT-ATRB-PRC-REQ-ID-HQ(WS-CRM-OPT-INDX        
                                                 ,WS-CRM-ATTRB-INDX )   
                                                                        
           IF HQ-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE HQ-OPT-ATTR-VSTART-TS      TO WS-CRM-VRSN-TIMESTAMP  
              MOVE WS-UPDATE                  TO                        
                WS-CRM-OPT-ATTRB-IND          ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
              MOVE WS-PROC-STATUS-CD          TO                        
                WS-CRM-OPT-ATRB-PRC-STAT-CD-HQ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           ELSE                                                         
              MOVE WS-REFERENCE        TO                               
                WS-CRM-OPT-ATTRB-IND          ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
              MOVE HQ-PROC-STATUS-CD          TO                        
                WS-CRM-OPT-ATRB-PRC-STAT-CD-HQ( WS-CRM-OPT-INDX         
                                                 ,WS-CRM-ATTRB-INDX )   
           END-IF.                                                      
                                                                        
           PERFORM 7360-FETCH-OPTION-ATRB-CUR  THRU 7360-EXIT.          
           SET WS-CRM-ATTRB-INDX              UP BY +1.                 
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2320-MOVE-OPTION-ACCESS-DTLS                                            
      ******************************************************************        
       2320-MOVE-OPTION-ACCESS-DTLS.                                    
                                                                        
           MOVE CI-OPTION-CD           TO WS-OPTION-CD                  
                WS-CRM-OPTN-OPTION-CD-CI    (  WS-CRM-OPT-INDX          
                                             ,WS-CRM-OPTN-ACCS-INDX )   
           MOVE CI-OFFER-CD            TO WS-OFFER-CD                   
                WS-CRM-OPTN-OFFER-CD-CI     (  WS-CRM-OPT-INDX          
                                             ,WS-CRM-OPTN-ACCS-INDX )   
           MOVE CI-CATEGORY-ID         TO  WS-INTEGER-NUM               
           MOVE WS-INTEGER-NUM         TO                               
                WS-CRM-OPTN-CATEGORY-ID-CI  (  WS-CRM-OPT-INDX          
                                             ,WS-CRM-OPTN-ACCS-INDX )   
           MOVE CI-ACCESS-START-DT     TO                               
                WS-CRM-OPTN-ACCES-START-DT-CI(  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           MOVE CI-ACCESS-END-DT       TO                               
                WS-CRM-OPTN-ACCESS-END-DT-CI (  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           MOVE CI-VIEW-APPLY-CD       TO                               
                WS-CRM-OPTN-VIEW-APPLY-CD-CI (  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           MOVE CI-LAST-UPDATE-TS      TO                               
                WS-CRM-OPTN-LAST-UPDATE-TS-CI(  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           MOVE CI-COMMENTS-TX         TO                               
                WS-CRM-OPTN-COMMENTS-TX-CI   (  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           MOVE CI-ACCESS-VRSN-NO      TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM        TO                               
                WS-CRM-OPT-ACS-VRSN-NO-CI    (  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           MOVE CI-ACCESS-VSTART-TS    TO                               
                WS-CRM-OPT-ACS-VSTART-TS-CI  (  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           MOVE CI-ACCESS-VEND-TS      TO                               
                WS-CRM-OPT-ACS-VEND-TS-CI    (  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           MOVE CI-PROC-REQ-ID         TO WS-DECIMAL-10V0-NUM-RED       
           MOVE WS-DECIMAL-10V0-NUM    TO                               
                WS-CRM-OPT-ACS-PRC-REQ-ID-CI(  WS-CRM-OPT-INDX          
                                             ,WS-CRM-OPTN-ACCS-INDX )   
                                                                        
           IF CI-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE CI-ACCESS-VSTART-TS TO WS-CRM-VRSN-TIMESTAMP         
              MOVE WS-UPDATE           TO                               
                WS-CRM-OPTN-ACCS-IND-CI(  WS-CRM-OPT-INDX               
                                        ,WS-CRM-OPTN-ACCS-INDX )        
              MOVE WS-PROC-STATUS-CD   TO                               
                WS-CRM-OPT-ACS-PRC-STAT-CD-CI(  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           ELSE                                                         
              MOVE WS-REFERENCE        TO                               
                WS-CRM-OPTN-ACCS-IND-CI(  WS-CRM-OPT-INDX               
                                        ,WS-CRM-OPTN-ACCS-INDX )        
              MOVE CI-PROC-STATUS-CD      TO                            
                WS-CRM-OPT-ACS-PRC-STAT-CD-CI(  WS-CRM-OPT-INDX         
                                              ,WS-CRM-OPTN-ACCS-INDX )  
           END-IF.                                                      
                                                                        
           PERFORM 7410-FETCH-OPTION-ACCESS-CUR THRU 7410-EXIT.         
           SET WS-CRM-OPTN-ACCS-INDX   UP BY +1.                        
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-MOVE-PROMO-DTLS                                                    
      ******************************************************************        
       2500-MOVE-PROMO-DTLS.                                            
                                                                        
           MOVE KM-PROMO-CD                                             
                         TO WS-CRM-PROMO-CD-KM(WS-CRM-PROMO-INDX)       
           MOVE KM-PROMO-DESC                                           
                         TO WS-CRM-PROMO-DESC-KM(WS-CRM-PROMO-INDX)     
           MOVE KM-OFFER-CD                                             
                         TO WS-CRM-OFFER-CD-KM(WS-CRM-PROMO-INDX)       
           MOVE KM-MKT-PLAN-CD                                          
                         TO WS-CRM-MKT-PLAN-CD-KM(WS-CRM-PROMO-INDX)    
           MOVE KM-PROMO-START-DT                                       
                         TO WS-CRM-PROMO-START-DT-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-PROMO-START-TM                                       
                         TO WS-CRM-PROMO-START-TM-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-PROMO-END-DT                                         
                         TO WS-CRM-PROMO-END-DT-KM(WS-CRM-PROMO-INDX)   
           MOVE KM-PROMO-END-TM                                         
                         TO WS-CRM-PROMO-END-TM-KM(WS-CRM-PROMO-INDX)   
           MOVE KM-AD-CHANNEL-CD                                        
                         TO WS-CRM-AD-CHANNEL-CD-KM(WS-CRM-PROMO-INDX)  
           MOVE KM-PROMO-DESC-LONG-LEN TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM                                         
           TO WS-CRM-PROMO-DESC-LONG-LEN-KM(WS-CRM-PROMO-INDX)          
           MOVE KM-PROMO-DESC-LONG-TEXT                                 
                    TO WS-CRM-PROMO-DESC-LONG-TXT-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-EXT-LANDING-PG-URL-LEN                               
                    TO WS-SMALLINT-NUM                                  
           MOVE WS-SMALLINT-NUM                                         
                    TO WS-CRM-EXT-LNDG-PG-URL-LEN-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-EXT-LANDING-PG-URL-TEXT                              
                    TO WS-CRM-EXT-LNDG-PG-URL-TXT-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-PROMO-TYPE-CD                                        
                    TO WS-CRM-PROMO-TYPE-CD-KM(WS-CRM-PROMO-INDX)       
           MOVE KM-WEB-IMAGE-FILE-NM-LEN                                
                                    TO WS-SMALLINT-NUM                  
           MOVE WS-SMALLINT-NUM                                         
                    TO WS-CRM-WEB-IMG-FILE-NM-LEN-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-WEB-IMAGE-FILE-NM-TEXT                               
                    TO WS-CRM-WEB-IMG-FILE-NM-TXT-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-LAST-UPDATE-TS                                       
                    TO WS-CRM-LAST-UPDATE-TS-KM(WS-CRM-PROMO-INDX)      
           MOVE KM-REPLACMNT-PROMO-CD                                   
                    TO WS-CRM-REPLACMNT-PROMO-CD-KM(WS-CRM-PROMO-INDX)  
           MOVE KM-DISPLAY-END-DT                                       
                    TO WS-CRM-DISPLAY-END-DT-KM(WS-CRM-PROMO-INDX)      
           MOVE KM-INT-LANDING-PG-URL-LEN                               
                    TO WS-SMALLINT-NUM                                  
           MOVE WS-SMALLINT-NUM                                         
                    TO WS-CRM-INT-LNDG-PG-URL-LEN-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-INT-LANDING-PG-URL-TEXT                              
                    TO WS-CRM-INT-LNDG-PG-URL-TXT-KM(WS-CRM-PROMO-INDX) 
           MOVE KM-PROMO-VRSN-NO       TO WS-SMALLINT-NUM               
           MOVE WS-SMALLINT-NUM                                         
                    TO WS-CRM-PROMO-VRSN-NO-KM(WS-CRM-PROMO-INDX)       
           MOVE KM-PROMO-VSTART-TS                                      
                    TO WS-CRM-PROMO-VSTART-TS-KM(WS-CRM-PROMO-INDX)     
           MOVE KM-PROMO-VEND-TS                                        
                    TO WS-CRM-PROMO-VEND-TS-KM(WS-CRM-PROMO-INDX)       
           MOVE KM-PROC-REQ-ID         TO WS-DECIMAL-10V0-NUM-RED       
           MOVE WS-DECIMAL-10V0-NUM                                     
                    TO WS-CRM-PROMO-PRC-REQ-ID-KM(WS-CRM-PROMO-INDX)    
                                                                        
           IF KM-PROC-REQ-ID = WS-PROCESS-REQ-ID                        
              MOVE KM-PROMO-VSTART-TS  TO WS-CRM-VRSN-TIMESTAMP         
              MOVE WS-UPDATE                                            
                    TO WS-CRM-PROMO-UPDT-IND(WS-CRM-PROMO-INDX)         
              MOVE WS-PROC-STATUS-CD                                    
                    TO WS-CRM-PROMO-PRC-STAT-CD-KM(WS-CRM-PROMO-INDX)   
           ELSE                                                         
              MOVE WS-REFERENCE                                         
                    TO WS-CRM-PROMO-UPDT-IND(WS-CRM-PROMO-INDX)         
              MOVE KM-PROC-STATUS-CD                                    
                    TO WS-CRM-PROMO-PRC-STAT-CD-KM(WS-CRM-PROMO-INDX)   
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5000-UPDATE-PROCESS.                                          *         
      *****************************************************************         
       5000-UPDATE-PROCESS.                                             
                                                                        
           IF CRM-OFFER-CHANGE                                          
            OR CRM-OPTION-CHANGE                                        
            OR CRM-PROMOTION-CHANGE                                     
                                                                        
      * GET THE VERSION START TIME STAMP FROM THE PROCESS REQ ID                
      * WHICH WILL BE USED IN CRM TABLES.                                       
              MOVE ZERO                      TO WS-NULL-EFF-TS          
              PERFORM 7010-GET-VRSN-START-TS                            
                                          THRU 7010-EXIT                
              IF WS-NULL-EFF-TS = 0                                     
                 MOVE 1P-EFFECTIVE-TS        TO WS-CRM-VRSN-TIMESTAMP   
              END-IF                                                    
      * WHEN PROC STAT CODE IS REJECT, NO NEED TO CALL VALIDATION               
      *       IF PROC-STAT-CD-REJECTED                                          
      *          PERFORM 6100-UPDATE-CRM-ENTRIES THRU 6100-EXIT                 
      *       ELSE                                                              
              PERFORM 6000-VALIDATE-CRM-ENTRIES THRU 6000-EXIT          
                                                                        
      *       END-IF                                                            
                                                                        
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5100-PROCESS-VALIDATION-MSG.                                  *         
      *****************************************************************         
       5100-PROCESS-VALIDATION-MSG.                                     
                                                                        
           SET RULES-NOT-EXISTS              TO TRUE.                   
                                                                        
           PERFORM VARYING WS-ERR-MESS-INDX FROM 1 BY 1                 
             UNTIL WS-ERR-MESS-INDX    > WS-ERR-MAX-ENTRY   OR          
                   WS-RULE-NO(WS-ERR-MESS-INDX) EQUAL SPACES            
                                                                        
              SET RULES-EXISTS                TO TRUE                   
                                                                        
              MOVE WS-RULE-NO(WS-ERR-MESS-INDX)                         
                                             TO RS-RULE-NO              
              MOVE WS-RULE-FLAG(WS-ERR-MESS-INDX)                       
                                             TO RS-RULE-FLAG            
              MOVE WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)               
                                             TO RS-ERROR-HEADER-DESC    
                                                                        
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
                                                                        
           END-PERFORM.                                                 
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-VALIDATE-CRM-ENTRIES.                                   *          
      *****************************************************************         
       6000-VALIDATE-CRM-ENTRIES.                                       
                                                                        
           CALL MCSCB829 USING ABEND-FILE                               
                               WS-WARNING-DATA-ELEMENTS                 
                               WS-CRM-HEADER-PARMS                      
                               WS-CRM-COMMON-PARMS                      
                               WS-CRM-DATA-LAYOUT                       
                               WS-CRM-RETURN-INFO                       
                               WS-CRM-VLDT-INPUT-PARMS                  
                               WS-CRM-ERR-MSG-RETURN-INFO               
                               WS-CRM-VALD-ERR-TABLE.                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL ZEROES                    
                                AND NOT EQUAL NOT-FOUND                 
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              IF WS-ERR-MSG-RETURN-CD > 1 THEN                          
                 MOVE ZERO                    TO RS-RETURN-CODE         
                 MOVE WS-ERR-MSG-RETURN-CD    TO RS-APPL-RETURN-CODE    
                 PERFORM 5100-PROCESS-VALIDATION-MSG THRU 5100-EXIT     
              ELSE                                                      
                 PERFORM 6100-UPDATE-CRM-ENTRIES THRU 6100-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6100-UPDATE-CRM-ENTRIES                                      *          
      *****************************************************************         
       6100-UPDATE-CRM-ENTRIES.                                         
                                                                        
           CALL MCSCB826 USING ABEND-FILE                               
                               WS-WARNING-DATA-ELEMENTS                 
                               WS-CRM-HEADER-PARMS                      
                               WS-CRM-COMMON-PARMS                      
                               WS-CRM-DATA-LAYOUT                       
                               WS-CRM-RETURN-INFO.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL ZEROES                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              MOVE ZERO                    TO RS-RETURN-CODE            
              MOVE WS-ERR-MSG-RETURN-CD    TO RS-APPL-RETURN-CODE       
              PERFORM 5100-PROCESS-VALIDATION-MSG THRU 5100-EXIT        
           END-IF                                                       
           .                                                            
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-GET-OFFER-DETAILS.                                        *        
      *    FOR CREATEREPLACE WIZARD TEMPLATE AND REPLACE OFFER WILL    *        
      *    HAVE SAME PROCESS REQUEST ID SO BASED ON OFFER TYPE SELECT  *        
      *    THE RIGHT OFFER                                             *        
      *    FOR TEMPLATE OFFER, VERSION WILL BE GREATER THAN 1 SINCE    *        
      *    THEY MIGHT HAVE CHANGES SUCH PROMO INT AND EXT FLAGS SET 'Y'*        
      *    FOR REPLACE OFFER WHICH IS CREATED USING TEMPLATE OFFER     *        
      *    WILL HAVE VERSION 1                                         *        
      *    FOR OTHER WIZARDS OFFER TYPE WILL BE 'NORMAL'               *        
      ******************************************************************        
       7000-GET-OFFER-DETAILS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT FG.COMPANY_NO                                     
                     ,FG.OFFER_CD                                       
                     ,FG.OFFER_DESC_INT                                 
                     ,FG.OFFER_DESC_EXT                                 
                     ,FG.PROMO_CD_INT_FL                                
                     ,FG.PROMO_CD_EXT_FL                                
                     ,FG.OFFER_START_DT                                 
                     ,FG.OFFER_END_DT                                   
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_INT_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_INT_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_EXT_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_EXT_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FG.LAST_UPDATE_USERID                             
                     ,FG.OFFER_DESC_INT_LNG                             
                     ,FG.OFFER_DESC_EXT_LNG                             
                     ,FG.SPCL_OFFER_TYPE_CD                             
                     ,FG.RENEWAL_OFFER_CD                               
                     ,FG.RENEW_PUB_OFFER_CD                             
                     ,FG.OFF_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VSTART_TS
           , 121), ' ', '-'), ':', '.') OFF_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS
           , 121), ' ', '-'), ':', '.') OFF_VEND_TS                            
                     ,FG.PROC_STATUS_CD                                 
                     ,FG.PROC_REQ_ID                                    
PRJ680               ,FG.MAX_PRICE_OFFER_CD                             
P00863               ,FG.RTCHG_PUB_OFFER_CD                             
                 INTO :FG-COMPANY-NO                                    
                     ,:FG-OFFER-CD                                      
                     ,:FG-OFFER-DESC-INT                                
                     ,:FG-OFFER-DESC-EXT                                
                     ,:FG-PROMO-CD-INT-FL                               
                     ,:FG-PROMO-CD-EXT-FL                               
                     ,:FG-OFFER-START-DT                                
                     ,:FG-OFFER-END-DT                                  
                     ,:FG-DISP-START-INT-TS                             
                     ,:FG-DISP-END-INT-TS                               
                     ,:FG-DISP-START-EXT-TS                             
                     ,:FG-DISP-END-EXT-TS                               
                     ,:FG-LAST-UPDATE-TS                                
                     ,:FG-LAST-UPDATE-USERID                            
                     ,:FG-OFFER-DESC-INT-LNG                            
                     ,:FG-OFFER-DESC-EXT-LNG                            
                     ,:FG-SPCL-OFFER-TYPE-CD                            
                     ,:FG-RENEWAL-OFFER-CD                              
                     ,:FG-RENEW-PUB-OFFER-CD                            
                     ,:FG-OFF-VRSN-NO                                   
                     ,:FG-OFF-VSTART-TS                                 
                     ,:FG-OFF-VEND-TS                                   
                     ,:FG-PROC-STATUS-CD                                
                     ,:FG-PROC-REQ-ID                                   
PRJ680               ,:FG-MAX-PRICE-OFFER-CD                            
P00863               ,:FG-RTCHG-PUB-OFFER-CD                            
                 FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
                WHERE FG.COMPANY_NO   = :FG-COMPANY-NO                  
                  AND ( (FG.PROC_REQ_ID  = :FG-PROC-REQ-ID              
                     AND :WS-PROC-REQ-FLAG = :WS-YES ) OR               
                        (FG.OFFER_CD  = :FG-OFFER-CD                    
                     AND :WS-PROC-REQ-FLAG = :WS-NO ) )                 
                  AND (                                                 
                    ( FG.OFF_VRSN_NO  = (                               
                        SELECT MAX(OFF_VRSN_NO)                         
                          FROM CRM_RT_PKG_OFFER WITH(READUNCOMMITTED)           
                         WHERE OFFER_CD = FG.OFFER_CD )                 
                      AND ( :WS-OFFER-TYPE = :WS-NORMAL-OFFER           
                        OR ( :WS-OFFER-TYPE = :WS-TEMPLATE-OFFER        
                           AND FG.OFF_VRSN_NO  > 1 ) ) )                
                      OR ( :WS-OFFER-TYPE = :WS-REPLACE-OFFER           
                           AND FG.OFF_VRSN_NO  = 1 ) )                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FG.COMPANY_NO                                             
MFA-TR*              ,FG.OFFER_CD                                               
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*              ,FG.OFFER_DESC_EXT                                         
MFA-TR*              ,FG.PROMO_CD_INT_FL                                        
MFA-TR*              ,FG.PROMO_CD_EXT_FL                                        
MFA-TR*              ,FG.OFFER_START_DT                                         
MFA-TR*              ,FG.OFFER_END_DT                                           
MFA-TR*              ,FG.DISP_START_INT_TS                                      
MFA-TR*              ,FG.DISP_END_INT_TS                                        
MFA-TR*              ,FG.DISP_START_EXT_TS                                      
MFA-TR*              ,FG.DISP_END_EXT_TS                                        
MFA-TR*              ,FG.LAST_UPDATE_TS                                         
MFA-TR*              ,FG.LAST_UPDATE_USERID                                     
MFA-TR*              ,FG.OFFER_DESC_INT_LNG                                     
MFA-TR*              ,FG.OFFER_DESC_EXT_LNG                                     
MFA-TR*              ,FG.SPCL_OFFER_TYPE_CD                                     
MFA-TR*              ,FG.RENEWAL_OFFER_CD                                       
MFA-TR*              ,FG.RENEW_PUB_OFFER_CD                                     
MFA-TR*              ,FG.OFF_VRSN_NO                                            
MFA-TR*              ,FG.OFF_VSTART_TS                                          
MFA-TR*              ,FG.OFF_VEND_TS                                            
MFA-TR*              ,FG.PROC_STATUS_CD                                         
MFA-TR*              ,FG.PROC_REQ_ID                                            
MFA-TR*              ,FG.MAX_PRICE_OFFER_CD                                     
MFA-TR*              ,FG.RTCHG_PUB_OFFER_CD                                     
MFA-TR*          INTO :FG-COMPANY-NO                                            
MFA-TR*              ,:FG-OFFER-CD                                              
MFA-TR*              ,:FG-OFFER-DESC-INT                                        
MFA-TR*              ,:FG-OFFER-DESC-EXT                                        
MFA-TR*              ,:FG-PROMO-CD-INT-FL                                       
MFA-TR*              ,:FG-PROMO-CD-EXT-FL                                       
MFA-TR*              ,:FG-OFFER-START-DT                                        
MFA-TR*              ,:FG-OFFER-END-DT                                          
MFA-TR*              ,:FG-DISP-START-INT-TS                                     
MFA-TR*              ,:FG-DISP-END-INT-TS                                       
MFA-TR*              ,:FG-DISP-START-EXT-TS                                     
MFA-TR*              ,:FG-DISP-END-EXT-TS                                       
MFA-TR*              ,:FG-LAST-UPDATE-TS                                        
MFA-TR*              ,:FG-LAST-UPDATE-USERID                                    
MFA-TR*              ,:FG-OFFER-DESC-INT-LNG                                    
MFA-TR*              ,:FG-OFFER-DESC-EXT-LNG                                    
MFA-TR*              ,:FG-SPCL-OFFER-TYPE-CD                                    
MFA-TR*              ,:FG-RENEWAL-OFFER-CD                                      
MFA-TR*              ,:FG-RENEW-PUB-OFFER-CD                                    
MFA-TR*              ,:FG-OFF-VRSN-NO                                           
MFA-TR*              ,:FG-OFF-VSTART-TS                                         
MFA-TR*              ,:FG-OFF-VEND-TS                                           
MFA-TR*              ,:FG-PROC-STATUS-CD                                        
MFA-TR*              ,:FG-PROC-REQ-ID                                           
MFA-TR*              ,:FG-MAX-PRICE-OFFER-CD                                    
MFA-TR*              ,:FG-RTCHG-PUB-OFFER-CD                                    
MFA-TR*          FROM CRM_RT_PKG_OFFER  FG                                      
MFA-TR*         WHERE FG.COMPANY_NO   = :FG-COMPANY-NO                          
MFA-TR*           AND ( (FG.PROC_REQ_ID  = :FG-PROC-REQ-ID                      
MFA-TR*              AND :WS-PROC-REQ-FLAG = :WS-YES ) OR                       
MFA-TR*                 (FG.OFFER_CD  = :FG-OFFER-CD                            
MFA-TR*              AND :WS-PROC-REQ-FLAG = :WS-NO ) )                         
MFA-TR*           AND (                                                         
MFA-TR*             ( FG.OFF_VRSN_NO  = (                                       
MFA-TR*                 SELECT MAX(OFF_VRSN_NO)                                 
MFA-TR*                   FROM CRM_RT_PKG_OFFER                                 
MFA-TR*                  WHERE OFFER_CD = FG.OFFER_CD )                         
MFA-TR*               AND ( :WS-OFFER-TYPE = :WS-NORMAL-OFFER                   
MFA-TR*                 OR ( :WS-OFFER-TYPE = :WS-TEMPLATE-OFFER                
MFA-TR*                    AND FG.OFF_VRSN_NO  > 1 ) ) )                        
MFA-TR*               OR ( :WS-OFFER-TYPE = :WS-REPLACE-OFFER                   
MFA-TR*                    AND FG.OFF_VRSN_NO  = 1 ) )                          
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OFFER'    TO TABLE-1                     
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-1             
              MOVE FG-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-VRSN-START-TS                                         *        
      *    BASED ON THE PROC REQ ID GET THE EFFECTIVE TS WHICH WILL    *        
      *    BE USED AS IN VERSION START TS                              *        
      ******************************************************************        
       7010-GET-VRSN-START-TS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           [1P].EFFECTIVE_TS, 121), ' ', '-'), ':', '.') EFFECTIVE_TS          
                 INTO :1P-EFFECTIVE-TS :WS-NULL-EFF-TS                   
                 FROM CSS_PROCESS_REQ [1P] WITH(READUNCOMMITTED)                
                WHERE [1P].PROC_REQ_ID = :1P-PROC-REQ-ID                  
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 1P.EFFECTIVE_TS                                           
MFA-TR*          INTO :1P-EFFECTIVE-TS:WS-NULL-EFF-TS                           
MFA-TR*          FROM CSS_PROCESS_REQ 1P                                        
MFA-TR*         WHERE 1P.PROC_REQ_ID = :1P-PROC-REQ-ID                          
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7010                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PROCESS_REQ'     TO TABLE-1                     
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-1             
              MOVE 1P-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7050-OPEN-OFFER-MKT-CUR.                                      *        
      ******************************************************************        
       7050-OPEN-OFFER-MKT-CUR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_MKT_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE DU-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE DU-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7060-FETCH-OFFER-MKT-CUR.                                      *        
      ******************************************************************        
       7060-FETCH-OFFER-MKT-CUR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH OFFER_MKT_CUR                                      
                INTO :DU-COMPANY-NO                                     
                    ,:DU-OFFER-CD                                       
                    ,:DU-TIER-CUST-STAT-CD                              
                    ,:DU-TIER-ACCT-TYPE-CD                              
                    ,:DU-MKT-TIER-RANKING                               
                    ,:DU-MKT-TIER-START-DT                              
                    ,:DU-OFFER-TIER-STRT-DT                             
                    ,:DU-MKT-TIER-APPLY-CD                              
                    ,:DU-TIER-DEFLT-OFFR-CD                             
                    ,:DU-OFFER-TIER-END-DT                              
                    ,:DU-LAST-UPDATE-USERID                             
                    ,:DU-LAST-UPDATE-TS                                 
                    ,:DU-OFF-TIER-VRSN-NO                               
                    ,:DU-OFF-TIER-VSTART-TS                             
                    ,:DU-OFF-TIER-VEND-TS                               
                    ,:DU-PROC-STATUS-CD                                 
                    ,:DU-PROC-REQ-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES             TO WS-NO-MORE-OFFER-MKT-ROWS
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7060'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_OFF_MKT_TIER' TO TABLE-1                  
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE 'PROC_REQ_ID'      TO TABLE-ELEMENT-2          
                    MOVE DU-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    MOVE DU-PROC-REQ-ID     TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7070-CLOSE-OFFER-MKT-CUR.                                      *        
      ******************************************************************        
       7070-CLOSE-OFFER-MKT-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_MKT_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-2          
              MOVE DU-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              MOVE DU-PROC-REQ-ID           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7100-OPEN-RATE-GRP-OFF-CUR.                                   *        
      ******************************************************************        
       7100-OPEN-RATE-GRP-OFF-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN RATE_GRP_OFF_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RATE_GRP_OFFER'  TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE G5-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE G5-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-RATE-GRP-OFF-CUR.                                   *        
      ******************************************************************        
       7110-FETCH-RATE-GRP-OFF-CUR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH RATE_GRP_OFF_CUR                                   
                INTO :G5-COMPANY-NO                                     
                    ,:G5-RATE-GROUP-TYPE-CD                             
                    ,:G5-RATE-GROUP-CD                                  
                    ,:G5-SORT-SEQ-NO                                    
                    ,:G5-EFF-START-DT                                   
                    ,:G5-EFF-END-DT                                     
                    ,:G5-OFFER-CD                                       
                    ,:G5-OPTION-CD                                      
                    ,:G5-LAST-UPDATE-USERID                             
                    ,:G5-LAST-UPDATE-TS                                 
                    ,:G5-GRP-OFF-VRSN-NO                                
                    ,:G5-GRP-OFF-VSTART-TS                              
                    ,:G5-GRP-OFF-VEND-TS                                
                    ,:G5-PROC-STATUS-CD                                 
                    ,:G5-PROC-REQ-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES      TO WS-NO-MORE-RATE-GRP-OFF-ROWS    
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7110'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_RATE_GRP_OFFER' TO TABLE-1                
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE 'PROC_REQ_ID'      TO TABLE-ELEMENT-2          
                    MOVE G5-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    MOVE G5-PROC-REQ-ID     TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7120-CLOSE-RATE-GRP-OFF-CUR                                    *        
      ******************************************************************        
       7120-CLOSE-RATE-GRP-OFF-CUR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE RATE_GRP_OFF_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RATE_GRP_OFFER'     TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-2          
              MOVE G5-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              MOVE G5-PROC-REQ-ID           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7150-OPEN-OFFER-ACCESS-CUR.                                   *        
      ******************************************************************        
       7150-OPEN-OFFER-ACCESS-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_ACCESS_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_ACCESS_OFF_OPT'  TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE CI-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE CI-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7160-FETCH-OFFER-ACCESS-CUR.                                   *        
      ******************************************************************        
       7160-FETCH-OFFER-ACCESS-CUR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH OFFER_ACCESS_CUR                                   
                INTO :CI-COMPANY-NO                                     
                    ,:CI-OPTION-CD                                      
                    ,:CI-OFFER-CD                                       
                    ,:CI-CATEGORY-ID                                    
                    ,:CI-ACCESS-START-DT                                
                    ,:CI-ACCESS-END-DT                                  
                    ,:CI-VIEW-APPLY-CD                                  
                    ,:CI-LAST-UPDATE-USERID                             
                    ,:CI-LAST-UPDATE-TS                                 
                    ,:CI-COMMENTS-TX                                    
                    ,:CI-ACCESS-VRSN-NO                                 
                    ,:CI-ACCESS-VSTART-TS                               
                    ,:CI-ACCESS-VEND-TS                                 
                    ,:CI-PROC-STATUS-CD                                 
                    ,:CI-PROC-REQ-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES      TO WS-NO-MORE-OFFER-ACCESS-ROWS    
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7160'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_ACCESS_OFF_OPT' TO TABLE-1                
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE 'PROC_REQ_ID'      TO TABLE-ELEMENT-2          
                    MOVE CI-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    MOVE CI-PROC-REQ-ID     TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7170-CLOSE-OFFER-ACCESS-CUR.                                   *        
      ******************************************************************        
       7170-CLOSE-OFFER-ACCESS-CUR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_ACCESS_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7170'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_ACCESS_OFF_OPT'     TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-2          
              MOVE CI-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              MOVE CI-PROC-REQ-ID           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7200-OPEN-OFFER-OPTION-CUR.                                   *        
      ******************************************************************        
       7200-OPEN-OFFER-OPTION-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_OPTION_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OFFER_OPTION'    TO TABLE-1                     
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-1             
              MOVE E9-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-FETCH-OFFER-OPTION-CUR.                                   *        
      ******************************************************************        
       7210-FETCH-OFFER-OPTION-CUR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH OFFER_OPTION_CUR                                   
                INTO :E9-COMPANY-NO                                     
                    ,:E9-OFFER-CD                                       
                    ,:E9-OPTION-CD                                      
                    ,:E9-OPTION-SORT-SEQ-NO                             
                    ,:E9-OPTION-URL-TX                                  
                    ,:E9-LAST-UPDATE-USERID                             
                    ,:E9-LAST-UPDATE-TS                                 
                    ,:E9-DROP-OPTION-CD                                 
                    ,:E9-OFFER-OPT-START-DT                             
                    ,:E9-OFFER-OPT-END-DT                               
                    ,:E9-OFF-OPT-VRSN-NO                                
                    ,:E9-OFF-OPT-VSTART-TS                              
                    ,:E9-OFF-OPT-VEND-TS                                
                    ,:E9-PROC-STATUS-CD                                 
                    ,:E9-PROC-REQ-ID                                    
A04805              ,:E9-WEB-NEW-EXISTS-CD                              
A04805              ,:E9-WEB-SIGN-UP-FL                                 
A04805              ,:E9-OFF-OPT-EXCLUDE-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES      TO WS-NO-MORE-OFFER-OPTION-ROWS    
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7210'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_OFFER_OPTION' TO TABLE-1                  
                    MOVE 'PROC_REQ_ID'      TO TABLE-ELEMENT-1          
                    MOVE E9-PROC-REQ-ID     TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7220-CLOSE-OFFER-OPTION-CUR.                                   *        
      ******************************************************************        
       7220-CLOSE-OFFER-OPTION-CUR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_OPTION_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFFER_OPTION'       TO TABLE-1                  
              MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-1          
              MOVE E9-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-OPTION-DET-DRIVE                                      *        
      ******************************************************************        
       7300-GET-OPTION-DETAILS.                                         
                                                                        
           EXEC SQL                                                     
               SELECT FI.COMPANY_NO                                     
                     ,FI.OPTION_CD                                      
                     ,FI.CODE_UTIL_TYPE                                 
                     ,FI.RATE_PLAN_NO                                   
                     ,FI.OPTION_START_DT                                
                     ,FI.OPTION_END_DT                                  
                     ,FI.OPT_DESC_INT                                   
                     ,FI.OPT_DESC_INT_LONG                              
                     ,FI.CURR_EXT_DESC_LONG                             
                     ,FI.RENEWAL_DESC_LONG                              
                     ,FI.WEB_DESC_LONG                                  
                     ,FI.STATUS_CD                                      
                     ,FI.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FI.OPT_CALC_TYPE_CD                               
                     ,FI.WEB_MKT_DESC_LONG                              
                     ,FI.OPT_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VSTART_TS
           , 121), ' ', '-'), ':', '.') OPT_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VEND_TS
           , 121), ' ', '-'), ':', '.') OPT_VEND_TS                            
                     ,FI.PROC_STATUS_CD                                 
                     ,FI.PROC_REQ_ID                                    
A04805               ,FI.OPTION_TYPE_DESC                               
PRJ892               ,FI.AUTO_RENEWAL_FL                                
PRJ892               ,FI.OPTION_PROMO_DESC                              
                 INTO :FI-COMPANY-NO                                    
                     ,:FI-OPTION-CD                                     
                     ,:FI-CODE-UTIL-TYPE                                
                     ,:FI-RATE-PLAN-NO                                  
                     ,:FI-OPTION-START-DT                               
                     ,:FI-OPTION-END-DT                                 
                     ,:FI-OPT-DESC-INT                                  
                     ,:FI-OPT-DESC-INT-LONG                             
                     ,:FI-CURR-EXT-DESC-LONG                            
                     ,:FI-RENEWAL-DESC-LONG                             
                     ,:FI-WEB-DESC-LONG                                 
                     ,:FI-STATUS-CD                                     
                     ,:FI-LAST-UPDATE-USERID                            
                     ,:FI-LAST-UPDATE-TS                                
                     ,:FI-OPT-CALC-TYPE-CD                              
                     ,:FI-WEB-MKT-DESC-LONG                             
                     ,:FI-OPT-VRSN-NO                                   
                     ,:FI-OPT-VSTART-TS                                 
                     ,:FI-OPT-VEND-TS                                   
                     ,:FI-PROC-STATUS-CD                                
                     ,:FI-PROC-REQ-ID                                   
A04805               ,:FI-OPTION-TYPE-DESC                              
PRJ892               ,:FI-AUTO-RENEWAL-FL                               
PRJ892               ,:FI-OPTION-PROMO-DESC                             
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.COMPANY_NO   = :FI-COMPANY-NO                  
                  AND ( (FI.PROC_REQ_ID  = :FI-PROC-REQ-ID              
                     AND :WS-PROC-REQ-FLAG = :WS-YES ) OR               
                        (FI.OPTION_CD = :FI-OPTION-CD                   
                     AND :WS-PROC-REQ-FLAG = :WS-NO ) )                 
                  AND FI.OPT_VRSN_NO  =                                 
                      ( SELECT MAX(OPT_VRSN_NO)                         
                          FROM CRM_RT_PKG_OPTION WITH(READUNCOMMITTED)          
                         WHERE OPTION_CD = FI.OPTION_CD)                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FI.COMPANY_NO                                             
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CODE_UTIL_TYPE                                         
MFA-TR*              ,FI.RATE_PLAN_NO                                           
MFA-TR*              ,FI.OPTION_START_DT                                        
MFA-TR*              ,FI.OPTION_END_DT                                          
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,FI.OPT_DESC_INT_LONG                                      
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,FI.RENEWAL_DESC_LONG                                      
MFA-TR*              ,FI.WEB_DESC_LONG                                          
MFA-TR*              ,FI.STATUS_CD                                              
MFA-TR*              ,FI.LAST_UPDATE_USERID                                     
MFA-TR*              ,FI.LAST_UPDATE_TS                                         
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.WEB_MKT_DESC_LONG                                      
MFA-TR*              ,FI.OPT_VRSN_NO                                            
MFA-TR*              ,FI.OPT_VSTART_TS                                          
MFA-TR*              ,FI.OPT_VEND_TS                                            
MFA-TR*              ,FI.PROC_STATUS_CD                                         
MFA-TR*              ,FI.PROC_REQ_ID                                            
MFA-TR*              ,FI.OPTION_TYPE_DESC                                       
MFA-TR*              ,FI.AUTO_RENEWAL_FL                                        
MFA-TR*              ,FI.OPTION_PROMO_DESC                                      
MFA-TR*          INTO :FI-COMPANY-NO                                            
MFA-TR*              ,:FI-OPTION-CD                                             
MFA-TR*              ,:FI-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FI-RATE-PLAN-NO                                          
MFA-TR*              ,:FI-OPTION-START-DT                                       
MFA-TR*              ,:FI-OPTION-END-DT                                         
MFA-TR*              ,:FI-OPT-DESC-INT                                          
MFA-TR*              ,:FI-OPT-DESC-INT-LONG                                     
MFA-TR*              ,:FI-CURR-EXT-DESC-LONG                                    
MFA-TR*              ,:FI-RENEWAL-DESC-LONG                                     
MFA-TR*              ,:FI-WEB-DESC-LONG                                         
MFA-TR*              ,:FI-STATUS-CD                                             
MFA-TR*              ,:FI-LAST-UPDATE-USERID                                    
MFA-TR*              ,:FI-LAST-UPDATE-TS                                        
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*              ,:FI-WEB-MKT-DESC-LONG                                     
MFA-TR*              ,:FI-OPT-VRSN-NO                                           
MFA-TR*              ,:FI-OPT-VSTART-TS                                         
MFA-TR*              ,:FI-OPT-VEND-TS                                           
MFA-TR*              ,:FI-PROC-STATUS-CD                                        
MFA-TR*              ,:FI-PROC-REQ-ID                                           
MFA-TR*              ,:FI-OPTION-TYPE-DESC                                      
MFA-TR*              ,:FI-AUTO-RENEWAL-FL                                       
MFA-TR*              ,:FI-OPTION-PROMO-DESC                                     
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.COMPANY_NO   = :FI-COMPANY-NO                          
MFA-TR*           AND ( (FI.PROC_REQ_ID  = :FI-PROC-REQ-ID                      
MFA-TR*              AND :WS-PROC-REQ-FLAG = :WS-YES ) OR                       
MFA-TR*                 (FI.OPTION_CD = :FI-OPTION-CD                           
MFA-TR*              AND :WS-PROC-REQ-FLAG = :WS-NO ) )                         
MFA-TR*           AND FI.OPT_VRSN_NO  =                                         
MFA-TR*               ( SELECT MAX(OPT_VRSN_NO)                                 
MFA-TR*                   FROM CRM_RT_PKG_OPTION                                
MFA-TR*                  WHERE OPTION_CD = FI.OPTION_CD)                        
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OPTION'   TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE FI-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              MOVE FI-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-GET-OFF-OPT-FOR-OPTION                                    *        
      ******************************************************************        
       7320-GET-OFF-OPT-FOR-OPTION.                                     
                                                                        
           EXEC SQL                                                     
                SELECT E9.COMPANY_NO                                    
                      ,E9.OFFER_CD                                      
                      ,E9.OPTION_CD                                     
                      ,E9.OPTION_SORT_SEQ_NO                            
                      ,E9.OPTION_URL_TX                                 
                      ,E9.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,E9.DROP_OPTION_CD                                
                      ,E9.OFFER_OPT_START_DT                            
                      ,E9.OFFER_OPT_END_DT                              
                      ,E9.OFF_OPT_VRSN_NO                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VSTART_TS                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VEND_TS                               
                      ,E9.PROC_STATUS_CD                                
                      ,E9.PROC_REQ_ID                                   
A04805                ,E9.WEB_NEW_EXISTS_CD                             
A04805                ,E9.WEB_SIGN_UP_FL                                
A04805                ,E9.OFF_OPT_EXCLUDE_CD                            
                  INTO :E9-COMPANY-NO                                   
                      ,:E9-OFFER-CD                                     
                      ,:E9-OPTION-CD                                    
                      ,:E9-OPTION-SORT-SEQ-NO                           
                      ,:E9-OPTION-URL-TX                                
                      ,:E9-LAST-UPDATE-USERID                           
                      ,:E9-LAST-UPDATE-TS                               
                      ,:E9-DROP-OPTION-CD                               
                      ,:E9-OFFER-OPT-START-DT                           
                      ,:E9-OFFER-OPT-END-DT                             
                      ,:E9-OFF-OPT-VRSN-NO                              
                      ,:E9-OFF-OPT-VSTART-TS                            
                      ,:E9-OFF-OPT-VEND-TS                              
                      ,:E9-PROC-STATUS-CD                               
                      ,:E9-PROC-REQ-ID                                  
A04805                ,:E9-WEB-NEW-EXISTS-CD                            
A04805                ,:E9-WEB-SIGN-UP-FL                               
A04805                ,:E9-OFF-OPT-EXCLUDE-CD                           
                  FROM CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)               
                 WHERE E9.OFFER_CD    = :E9-OPTION-CD                   
                   AND E9.COMPANY_NO  = :E9-COMPANY-NO                  
                   AND E9.PROC_REQ_ID = :E9-PROC-REQ-ID                 
                   AND E9.OFF_OPT_VRSN_NO  = (                          
                   SELECT MAX(E1.OFF_OPT_VRSN_NO )                      
                     FROM CRM_OFFER_OPTION  E1 WITH(READUNCOMMITTED)            
                    WHERE E1.COMPANY_NO         = E9.COMPANY_NO         
                      AND E1.OFFER_CD           = E9.OFFER_CD           
                      AND E1.OPTION_CD          = E9.OPTION_CD          
                      AND E1.OFFER_OPT_START_DT = E9.OFFER_OPT_START_DT)
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT E9.COMPANY_NO                                            
MFA-TR*               ,E9.OFFER_CD                                              
MFA-TR*               ,E9.OPTION_CD                                             
MFA-TR*               ,E9.OPTION_SORT_SEQ_NO                                    
MFA-TR*               ,E9.OPTION_URL_TX                                         
MFA-TR*               ,E9.LAST_UPDATE_USERID                                    
MFA-TR*               ,E9.LAST_UPDATE_TS                                        
MFA-TR*               ,E9.DROP_OPTION_CD                                        
MFA-TR*               ,E9.OFFER_OPT_START_DT                                    
MFA-TR*               ,E9.OFFER_OPT_END_DT                                      
MFA-TR*               ,E9.OFF_OPT_VRSN_NO                                       
MFA-TR*               ,E9.OFF_OPT_VSTART_TS                                     
MFA-TR*               ,E9.OFF_OPT_VEND_TS                                       
MFA-TR*               ,E9.PROC_STATUS_CD                                        
MFA-TR*               ,E9.PROC_REQ_ID                                           
MFA-TR*               ,E9.WEB_NEW_EXISTS_CD                                     
MFA-TR*               ,E9.WEB_SIGN_UP_FL                                        
MFA-TR*               ,E9.OFF_OPT_EXCLUDE_CD                                    
MFA-TR*           INTO :E9-COMPANY-NO                                           
MFA-TR*               ,:E9-OFFER-CD                                             
MFA-TR*               ,:E9-OPTION-CD                                            
MFA-TR*               ,:E9-OPTION-SORT-SEQ-NO                                   
MFA-TR*               ,:E9-OPTION-URL-TX                                        
MFA-TR*               ,:E9-LAST-UPDATE-USERID                                   
MFA-TR*               ,:E9-LAST-UPDATE-TS                                       
MFA-TR*               ,:E9-DROP-OPTION-CD                                       
MFA-TR*               ,:E9-OFFER-OPT-START-DT                                   
MFA-TR*               ,:E9-OFFER-OPT-END-DT                                     
MFA-TR*               ,:E9-OFF-OPT-VRSN-NO                                      
MFA-TR*               ,:E9-OFF-OPT-VSTART-TS                                    
MFA-TR*               ,:E9-OFF-OPT-VEND-TS                                      
MFA-TR*               ,:E9-PROC-STATUS-CD                                       
MFA-TR*               ,:E9-PROC-REQ-ID                                          
MFA-TR*               ,:E9-WEB-NEW-EXISTS-CD                                    
MFA-TR*               ,:E9-WEB-SIGN-UP-FL                                       
MFA-TR*               ,:E9-OFF-OPT-EXCLUDE-CD                                   
MFA-TR*           FROM CRM_OFFER_OPTION  E9                                     
MFA-TR*          WHERE E9.OFFER_CD    = :E9-OPTION-CD                           
MFA-TR*            AND E9.COMPANY_NO  = :E9-COMPANY-NO                          
MFA-TR*            AND E9.PROC_REQ_ID = :E9-PROC-REQ-ID                         
MFA-TR*            AND E9.OFF_OPT_VRSN_NO  = (                                  
MFA-TR*            SELECT MAX(E1.OFF_OPT_VRSN_NO )                              
MFA-TR*              FROM CRM_OFFER_OPTION  E1                                  
MFA-TR*             WHERE E1.COMPANY_NO         = E9.COMPANY_NO                 
MFA-TR*               AND E1.OFFER_CD           = E9.OFFER_CD                   
MFA-TR*               AND E1.OPTION_CD          = E9.OPTION_CD                  
MFA-TR*               AND E1.OFFER_OPT_START_DT = E9.OFFER_OPT_START_DT)        
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7320                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL  OR NOT-FOUND                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7320'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OFFER_OPTION'    TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE FI-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              MOVE FI-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7350-OPEN-OPTION-ATRB-CUR.                                    *        
      ******************************************************************        
       7350-OPEN-OPTION-ATRB-CUR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN OPT_ATTR_INCTV_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7350'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OPT_ATTR_INCTV'  TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE HQ-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              MOVE HQ-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7360-FETCH-OPTION-ATRB-CUR.                                    *        
      ******************************************************************        
       7360-FETCH-OPTION-ATRB-CUR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH OPT_ATTR_INCTV_CUR                                 
                INTO :HQ-COMPANY-NO                                     
                    ,:HQ-OPTION-CD                                      
                    ,:HQ-ATTR-INCTV-SEQ-NO                              
                    ,:HQ-RT-ATTR-INCTV-TYPE                             
                    ,:HQ-PRIMRY-OPT-ATTR-FL                             
                    ,:HQ-FACTOR-ID                                      
                    ,:HQ-DURATION-NO                                    
                    ,:HQ-APPL-PROGRAM-ID                                
                    ,:HQ-ATTR-INCTV-VALUE                               
                    ,:HQ-ATTR-INCTV-VAL-TX                              
                    ,:HQ-LAST-UPDATE-USERID                             
                    ,:HQ-LAST-UPDATE-TS                                 
                    ,:HQ-GL-ACCT-CREDIT                                 
                    ,:HQ-GL-ACCT-DEBIT                                  
                    ,:HQ-CATEGORY-ID                                    
                    ,:HQ-WQ-ROUTE-CATEGORY                              
                    ,:HQ-OPT-CHG-ACTION-CD                              
                    ,:HQ-ATTR-INCTV-STRT-DT                             
                    ,:HQ-ATTR-INCTV-END-DT                              
                    ,:HQ-OPT-ATTR-VRSN-NO                               
                    ,:HQ-OPT-ATTR-VSTART-TS                             
                    ,:HQ-OPT-ATTR-VEND-TS                               
                    ,:HQ-PROC-STATUS-CD                                 
                    ,:HQ-PROC-REQ-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES             TO WS-NO-MORE-OPTN-ATRB-ROWS
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7360'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_OPT_ATTR_INCTV' TO TABLE-1                
                    MOVE 'OPTION_CD'        TO TABLE-ELEMENT-1          
                    MOVE 'PROC_REQ_ID'      TO TABLE-ELEMENT-2          
                    MOVE HQ-OPTION-CD       TO HOSTVAR-ELEMENT-1        
                    MOVE HQ-PROC-REQ-ID     TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7370-CLOSE-OPTION-ATRB-CUR.                                    *        
      ******************************************************************        
       7370-CLOSE-OPTION-ATRB-CUR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE OPT_ATTR_INCTV_CUR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7370'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OPT_ATTR_INCTV'     TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-2          
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              MOVE HQ-PROC-REQ-ID           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7400-OPEN-OPTION-ACCESS-CUR.                                  *        
      ******************************************************************        
       7400-OPEN-OPTION-ACCESS-CUR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN OPTION_ACCESS_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_ACCESS_OFF_OPT'  TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE CI-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              MOVE CI-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-FETCH-OPTION-ACCESS-CUR.                                  *        
      ******************************************************************        
       7410-FETCH-OPTION-ACCESS-CUR.                                    
                                                                        
           EXEC SQL                                                     
               FETCH OPTION_ACCESS_CUR                                  
                INTO :CI-COMPANY-NO                                     
                    ,:CI-OPTION-CD                                      
                    ,:CI-OFFER-CD                                       
                    ,:CI-CATEGORY-ID                                    
                    ,:CI-ACCESS-START-DT                                
                    ,:CI-ACCESS-END-DT                                  
                    ,:CI-VIEW-APPLY-CD                                  
                    ,:CI-LAST-UPDATE-USERID                             
                    ,:CI-LAST-UPDATE-TS                                 
                    ,:CI-COMMENTS-TX                                    
                    ,:CI-ACCESS-VRSN-NO                                 
                    ,:CI-ACCESS-VSTART-TS                               
                    ,:CI-ACCESS-VEND-TS                                 
                    ,:CI-PROC-STATUS-CD                                 
                    ,:CI-PROC-REQ-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE WS-YES      TO WS-NO-MORE-OPTN-ACCESS-ROWS     
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7410'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_ACCESS_OFF_OPT' TO TABLE-1                
                    MOVE 'OPTION_CD'        TO TABLE-ELEMENT-1          
                    MOVE 'PROC_REQ_ID'      TO TABLE-ELEMENT-2          
                    MOVE CI-OPTION-CD       TO HOSTVAR-ELEMENT-1        
                    MOVE CI-PROC-REQ-ID     TO HOSTVAR-ELEMENT-2        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420-CLOSE-OPTION-ACCESS-CUR.                                  *        
      ******************************************************************        
       7420-CLOSE-OPTION-ACCESS-CUR.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE OPTION_ACCESS_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7420'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_ACCESS_OFF_OPT'     TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-2          
              MOVE CI-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              MOVE CI-PROC-REQ-ID           TO HOSTVAR-ELEMENT-2        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7105-ACCEPT-TIMESTAMP.                                         *        
      ******************************************************************        
       7105-ACCEPT-TIMESTAMP.                                           
                                                                        
           MOVE '7105'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7105'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7106-GET-PROC-STAT-CD.                                                  
      ******************************************************************        
       7106-GET-PROC-STAT-CD.                                           
                                                                        
           MOVE '7106'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) T4P.PROC_STATUS_CD                                 
                INTO :4P-PROC-STATUS-CD                                 
                FROM CSS_PROCESS_REQ_CH T4P WITH(READUNCOMMITTED)               
               WHERE T4P.PROC_REQ_ID = :4P-PROC-REQ-ID                  
              ORDER BY T4P.REQ_CHG_TS DESC                              
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT T4P.PROC_STATUS_CD                                         
MFA-TR*         INTO :4P-PROC-STATUS-CD                                         
MFA-TR*         FROM CSS_PROCESS_REQ_CH T4P                                     
MFA-TR*        WHERE T4P.PROC_REQ_ID = :4P-PROC-REQ-ID                          
MFA-TR*       ORDER BY T4P.REQ_CHG_TS DESC                                      
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7106'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_PROCESS_REQ_CH'     TO TABLE-1                  
              MOVE 'T4P.PROC_REQ_ID'        TO TABLE-ELEMENT-1          
              MOVE 4P-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7106-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GET PROMOTION DEATILS BASED ON PROC REQ ID                    *         
      * 7500-GET-PROMO-DETAILS                                        *         
      *****************************************************************         
       7500-GET-PROMO-DETAILS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT KM.COMPANY_NO                                     
                     ,KM.PROMO_CD                                       
                     ,KM.PROMO_DESC                                     
                     ,KM.OFFER_CD                                       
                     ,KM.MKT_PLAN_CD                                    
                     ,KM.PROMO_START_DT                                 
                     ,REPLACE(CONVERT(CHAR(8), KM.PROMO_START_TM, 108), 
           ':', '.') PROMO_START_TM                                 
                     ,KM.PROMO_END_DT                                   
                     ,REPLACE(CONVERT(CHAR(8), KM.PROMO_END_TM, 108), 
           ':', '.') PROMO_END_TM                                   
                     ,KM.AD_CHANNEL_CD                                  
                     ,KM.PROMO_DESC_LONG                                
                     ,KM.EXT_LANDING_PG_URL                             
                     ,KM.PROMO_TYPE_CD                                  
                     ,KM.WEB_IMAGE_FILE_NM                              
                     ,KM.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,KM.REPLACMNT_PROMO_CD                             
                     ,KM.DISPLAY_END_DT                                 
                     ,KM.INT_LANDING_PG_URL                             
                     ,KM.PROMO_VRSN_NO                                  
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VSTART_TS, 121), ' ', '-'), ':', '.') 
           PROMO_VSTART_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), KM.PROMO_VEND_TS
           , 121), ' ', '-'), ':', '.') PROMO_VEND_TS                          
                     ,KM.PROC_STATUS_CD                                 
                     ,KM.PROC_REQ_ID                                    
                 INTO :KM-COMPANY-NO                                    
                     ,:KM-PROMO-CD                                      
                     ,:KM-PROMO-DESC                                    
                     ,:KM-OFFER-CD                                      
                     ,:KM-MKT-PLAN-CD                                   
                     ,:KM-PROMO-START-DT                                
                     ,:KM-PROMO-START-TM                                
                     ,:KM-PROMO-END-DT                                  
                     ,:KM-PROMO-END-TM                                  
                     ,:KM-AD-CHANNEL-CD                                 
                     ,:KM-PROMO-DESC-LONG                               
                     ,:KM-EXT-LANDING-PG-URL                            
                     ,:KM-PROMO-TYPE-CD                                 
                     ,:KM-WEB-IMAGE-FILE-NM                             
                     ,:KM-LAST-UPDATE-USERID                            
                     ,:KM-LAST-UPDATE-TS                                
                     ,:KM-REPLACMNT-PROMO-CD                            
                     ,:KM-DISPLAY-END-DT                                
                     ,:KM-INT-LANDING-PG-URL                            
                     ,:KM-PROMO-VRSN-NO                                 
                     ,:KM-PROMO-VSTART-TS                               
                     ,:KM-PROMO-VEND-TS                                 
                     ,:KM-PROC-STATUS-CD                                
                     ,:KM-PROC-REQ-ID                                   
                 FROM CRM_MKT_PROMOTION  KM WITH(READUNCOMMITTED)               
                WHERE KM.COMPANY_NO    = :KM-COMPANY-NO                 
                  AND KM.PROC_REQ_ID   = :KM-PROC-REQ-ID                
                  AND KM.PROMO_VRSN_NO =                                
                      ( SELECT MAX(K1.PROMO_VRSN_NO)                    
                          FROM CRM_MKT_PROMOTION  K1
                           WITH(READUNCOMMITTED)                    
                         WHERE K1.PROMO_CD  = KM.PROMO_CD )             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KM.COMPANY_NO                                             
MFA-TR*              ,KM.PROMO_CD                                               
MFA-TR*              ,KM.PROMO_DESC                                             
MFA-TR*              ,KM.OFFER_CD                                               
MFA-TR*              ,KM.MKT_PLAN_CD                                            
MFA-TR*              ,KM.PROMO_START_DT                                         
MFA-TR*              ,KM.PROMO_START_TM                                         
MFA-TR*              ,KM.PROMO_END_DT                                           
MFA-TR*              ,KM.PROMO_END_TM                                           
MFA-TR*              ,KM.AD_CHANNEL_CD                                          
MFA-TR*              ,KM.PROMO_DESC_LONG                                        
MFA-TR*              ,KM.EXT_LANDING_PG_URL                                     
MFA-TR*              ,KM.PROMO_TYPE_CD                                          
MFA-TR*              ,KM.WEB_IMAGE_FILE_NM                                      
MFA-TR*              ,KM.LAST_UPDATE_USERID                                     
MFA-TR*              ,KM.LAST_UPDATE_TS                                         
MFA-TR*              ,KM.REPLACMNT_PROMO_CD                                     
MFA-TR*              ,KM.DISPLAY_END_DT                                         
MFA-TR*              ,KM.INT_LANDING_PG_URL                                     
MFA-TR*              ,KM.PROMO_VRSN_NO                                          
MFA-TR*              ,KM.PROMO_VSTART_TS                                        
MFA-TR*              ,KM.PROMO_VEND_TS                                          
MFA-TR*              ,KM.PROC_STATUS_CD                                         
MFA-TR*              ,KM.PROC_REQ_ID                                            
MFA-TR*          INTO :KM-COMPANY-NO                                            
MFA-TR*              ,:KM-PROMO-CD                                              
MFA-TR*              ,:KM-PROMO-DESC                                            
MFA-TR*              ,:KM-OFFER-CD                                              
MFA-TR*              ,:KM-MKT-PLAN-CD                                           
MFA-TR*              ,:KM-PROMO-START-DT                                        
MFA-TR*              ,:KM-PROMO-START-TM                                        
MFA-TR*              ,:KM-PROMO-END-DT                                          
MFA-TR*              ,:KM-PROMO-END-TM                                          
MFA-TR*              ,:KM-AD-CHANNEL-CD                                         
MFA-TR*              ,:KM-PROMO-DESC-LONG                                       
MFA-TR*              ,:KM-EXT-LANDING-PG-URL                                    
MFA-TR*              ,:KM-PROMO-TYPE-CD                                         
MFA-TR*              ,:KM-WEB-IMAGE-FILE-NM                                     
MFA-TR*              ,:KM-LAST-UPDATE-USERID                                    
MFA-TR*              ,:KM-LAST-UPDATE-TS                                        
MFA-TR*              ,:KM-REPLACMNT-PROMO-CD                                    
MFA-TR*              ,:KM-DISPLAY-END-DT                                        
MFA-TR*              ,:KM-INT-LANDING-PG-URL                                    
MFA-TR*              ,:KM-PROMO-VRSN-NO                                         
MFA-TR*              ,:KM-PROMO-VSTART-TS                                       
MFA-TR*              ,:KM-PROMO-VEND-TS                                         
MFA-TR*              ,:KM-PROC-STATUS-CD                                        
MFA-TR*              ,:KM-PROC-REQ-ID                                           
MFA-TR*          FROM CRM_MKT_PROMOTION  KM                                     
MFA-TR*         WHERE KM.COMPANY_NO    = :KM-COMPANY-NO                         
MFA-TR*           AND KM.PROC_REQ_ID   = :KM-PROC-REQ-ID                        
MFA-TR*           AND KM.PROMO_VRSN_NO =                                        
MFA-TR*               ( SELECT MAX(K1.PROMO_VRSN_NO)                            
MFA-TR*                   FROM CRM_MKT_PROMOTION  K1                            
MFA-TR*                  WHERE K1.PROMO_CD  = KM.PROMO_CD )                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_MKT_PROMOTION'      TO TABLE-1                  
              MOVE 'PROC_REQ_ID'            TO TABLE-ELEMENT-1          
              MOVE KM-PROC-REQ-ID           TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04446_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04446_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04446_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04446_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,RULE_NO                                              
                  ,RULE_FLAG                                            
                  ,ERROR_HEADER_DESC                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-RULE-NO                                           
                  ,:S-RULE-FLAG                                         
                  ,:S-ERROR-HEADER-DESC                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04446_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,RULE_NO                                                      
MFA-TR*           ,RULE_FLAG                                                    
MFA-TR*           ,ERROR_HEADER_DESC                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-RULE-NO                                                   
MFA-TR*           ,:S-RULE-FLAG                                                 
MFA-TR*           ,:S-ERROR-HEADER-DESC                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = WS-YES          
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE WS-YES                TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04446_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
        9700-PROCESS-ABEND.                                             
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT.            
                                                                        
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.            
                                                                        
        9700-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
