       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04444.                                      
       AUTHOR.           MS93554.                                       
COB303 DATE-WRITTEN.     22-SEP-2011.                                   
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *              STORED PROCEDURE:  CSR04444                       *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  PURPOSE : DELETE 'NW' STATUS ROWS FOR THE BELOW CRM TABLES    *        
      *            BASED ON THE PROCESS REQUEST IDENTIFIER.            *        
      *                                                                *        
      *               CRM_OFFER_OPTION                                 *        
      *               CRM_ACCESS_OFF_OPT                               *        
      *               CRM_MKT_PROMOTION                                *        
      *               CRM_OFF_MKT_TIER                                 *        
      *               CRM_OPT_ATTR_INCTV                               *        
      *               CRM_RATE_GRP_OFFER                               *        
      *               CRM_RT_PKG_OFFER                                 *        
      *               CRM_RT_PKG_OPTION                                *        
      *                                                                *        
      *                                                                *        
      *  # APPL_RETURN_CD                                              *        
      *  +1000 - PROC-REQ-ID VALUE IS INVALID                          *        
      *  +1001 - ACTIVE OFFERS ATTCHED WITH OPTION                     *        
      *  +1002 - OFFER USED AS RENEWAL OFFER WITH ANOTHER OFFER        *        
      *                                                                *        
      ******************************************************************        
      *  PARAMETERS                                                    *        
      *                                                                *        
      *        IN                                                      *        
      *            I_APPL_PGM_ID     CHAR(03)                          *        
      *           ,I_RESOURCE_ID     CHAR(32)                          *        
      *           ,I_USER_ID         CHAR(07)                          *        
      *           ,I_PROC_REQ_ID     DECIMAL(10)                       *        
      *                                                                *        
      *                                                                *        
      *        OUT                                                     *        
      *              NONE                                              *        
      *                                                                *        
      *        INOUT                                                   *        
      *              NONE                                              *        
      *                                                                *        
      *    RESULT SET                                                  *        
      *                                                                *        
      *              RETURN_CODE              INTEGER                  *        
      *              APPL_RETURN_CODE         INTEGER                  *        
      *              DELETE_TOT_COUNT         INTEGER                  *        
      *              OFFER_CD                 CHAR                     *        
      *              OPTION_CD                CHAR                     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00473*  22/09/11  MS93554    DELETE NW STATUS ROWS FROM CRM TABLES    *        
      *                       BASED ON THE PROC REQ ID.                *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04444'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                           PIC X(40) VALUE            
            'WORKING STORAGE FOR CSR04444 STARTS HERE'.                 
      *                                                                         
       01 WORK-VARIABLES.                                               
          05 PROGRAM-NAME                    PIC X(08) VALUE 'CSR04444'.
          05 WS-SQLSTATE                     PIC X(05) VALUE SPACES.    
      *                                                                         
       01 WS-MISC-FIELDS.                                               
          05 WS-APPL-PGM-ID                  PIC X(08).                 
          05 WS-RESOURCE-ID                  PIC X(32).                 
          05 WS-USER-ID                      PIC X(07).                 
          05 WS-OFFER-COUNT                  PIC S9(09) COMP VALUE 0.   
          05 WS-GTT-NAME                     PIC X(19)  VALUE SPACES.   
          05 WS-NEW                          PIC X(02)  VALUE 'NW'.     
          05 WS-PEND-APRVL                   PIC X(02)  VALUE 'PA'.     
          05 WS-ERLY-APRVL                   PIC X(02)  VALUE 'EA'.     
          05 WS-APRVL-CMPLT                  PIC X(02)  VALUE 'AC'.     
          05 WS-YES                          PIC X(02)  VALUE 'Y'.      
          05 WS-NO                           PIC X(02)  VALUE 'N'.      
          05 WS-OPTION-EXISTS                PIC X(01)  VALUE 'N'.      
          05 WS-OFF-USED-AS-RNWL-OFF         PIC X(01)  VALUE 'N'.      
          05 WS-CREATED-OFFER                PIC X(12)  VALUE SPACES.   
                                                                        
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE                  PIC S9(09) COMP VALUE 0.   
          05 RS-APPL-RETURN-CODE             PIC S9(09) COMP VALUE 0.   
          05 RS-DELETED-ROW-CNT              PIC S9(09) COMP VALUE 0.   
          05 RS-CREATED-OFFER                PIC X(12)  VALUE SPACES.   
          05 RS-OFFER-CD                     PIC X(12)  VALUE SPACES.   
          05 RS-OPTION-CD                    PIC X(12)  VALUE SPACES.   
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                   PIC S9(09) COMP VALUE 0.   
          05 S-APPL-RETURN-CODE              PIC S9(09) COMP VALUE 0.   
          05 S-DELETED-ROW-COUNT             PIC S9(09) COMP VALUE 0.   
          05 S-CREATED-OFFER                 PIC X(12)  VALUE SPACES.   
          05 S-OFFER-CD                      PIC X(12)  VALUE SPACES.   
          05 S-OPTION-CD                     PIC X(12)  VALUE SPACES.   
                                                                        
      *                                                                         
       01 COUNTER-FIELDS.                                               
          05  CTR-COLUMN                     PIC S9(9)  COMP VALUE 1.   
          05  CTR-ROWS                       PIC S9(9)  COMP VALUE 0.   
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW                    PIC X(01)  VALUE 'N'.      
              88 NOT-ALL-DONE                           VALUE 'N'.      
              88 ALL-DONE                               VALUE 'Y'.      
           05 SEND-DONE-SW                   PIC X(01)  VALUE 'Y'.      
              88 SEND-DONE-ERROR                        VALUE 'N'.      
              88 SEND-DONE-OK                           VALUE 'Y'.      
           05 WS-NO-MORE-ROWS                PIC X(01)  VALUE 'N'.      
              88 NO-MORE-ROWS                           VALUE 'Y'.      
           05 WS-DEL-FUNCTION-FL             PIC X(01)  VALUE 'Y'.      
              88 CRM-DEL-ALLOWED                        VALUE 'Y'.      
              88 CRM-DEL-NOT-ALLOWED                    VALUE 'N'.      
           05 WS-RPM-WIZARDS                 PIC X(06)  VALUE ' '.      
              88 CREATE-OFFER-WIZARD                    VALUE 'RPM001'. 
              88 MODIFY-OFFER-WIZARD                    VALUE 'RPM002'. 
      *                                                                         
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME                    PIC X(18)  VALUE SPACES.   
            10  S-SQLCODE                    PIC S9(9)  COMP VALUE 0.   
            10  S-SQLSTATE                   PIC X(5)   VALUE ' '.      
            10  S-TABLE-NAME                 PIC X(18)  VALUE SPACES.   
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L       PIC S9(4)  USAGE COMP.     
                49  S-HOST-VARIABLES-V       PIC X(255).                
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L        PIC S9(4)  USAGE COMP.     
                49  S-SQL-STATEMENT-V        PIC X(255).                
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L      PIC S9(4)  USAGE COMP.     
                49  S-SQL-DESCRIPTION-V      PIC X(255).                
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OPTION  (FI)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_ATTR_INCV   (G7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTINCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OFFER   (FG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFF_MKT_TIER   (DU)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFMKT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFFER_OPTION   (E9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFOPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV (HQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_PROMOTION  (KM)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_ACCESS_OFF_OPT  (CI)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRMACC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GRP_OFFER  (G5)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PROCESS_REQ     (1P)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPRCREQ                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
      ******************************************************************        
                                                                        
      ******************************************************************        
      * CURSOR TO FETCH ALL OFFER THAT ATTACHED WITH OPTION            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFFER_OPTION_CUR CURSOR FOR                      
                SELECT E9.OFFER_CD                                      
                      ,FI.OPTION_CD                                     
                  FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)               
                      ,CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)               
                 WHERE FI.PROC_REQ_ID     = :FI-PROC-REQ-ID             
                   AND FI.PROC_STATUS_CD  = :WS-NEW                     
                   AND FI.OPT_VRSN_NO     = 1                           
                   AND E9.OPTION_CD       = FI.OPTION_CD                
                   AND E9.PROC_REQ_ID    <> :FI-PROC-REQ-ID             
      *            AND E9.PROC_STATUS_CD  = :WS-NEW                             
                   AND E9.OFF_OPT_VRSN_NO = 1                           
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_OPTION_CUR CURSOR FOR                              
MFA-TR*         SELECT E9.OFFER_CD                                              
MFA-TR*               ,FI.OPTION_CD                                             
MFA-TR*           FROM CRM_RT_PKG_OPTION FI                                     
MFA-TR*               ,CRM_OFFER_OPTION  E9                                     
MFA-TR*          WHERE FI.PROC_REQ_ID     = :FI-PROC-REQ-ID                     
MFA-TR*            AND FI.PROC_STATUS_CD  = :WS-NEW                             
MFA-TR*            AND FI.OPT_VRSN_NO     = 1                                   
MFA-TR*            AND E9.OPTION_CD       = FI.OPTION_CD                        
MFA-TR*            AND E9.PROC_REQ_ID    <> :FI-PROC-REQ-ID                     
MFA-TR*            AND E9.PROC_STATUS_CD  = :WS-NEW                             
MFA-TR*            AND E9.OFF_OPT_VRSN_NO = 1                                   
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*        QUERYNO 7010                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGM-ID        PIC X(03).                           
       01  PARM-RESOURCE-ID        PIC X(32).                           
       01  PARM-USER-ID            PIC X(07).                           
COB305 01 PARM-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.            
                                                                        
       PROCEDURE DIVISION  USING PARM-APPL-PGM-ID                       
                                 PARM-RESOURCE-ID                       
                                 PARM-USER-ID                           
                                 PARM-PROC-REQ-ID.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'SESSION.CSR04444_R1'       TO WS-GTT-NAME.             
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04444_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04444_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,DELETED_ROW_COUNT       INT                     
                   ,CREATED_OFFER CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,DELETED_ROW_COUNT           AS DELETED_ROW_COUNT 
                      ,LTRIM(RTRIM(CREATED_OFFER))        AS 
           CREATED_OFFER     
                      ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD          
                      ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD         
                  FROM #CSR04444_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,DELETED_ROW_COUNT           AS DELETED_ROW_COUNT         
MFA-TR*               ,STRIP(CREATED_OFFER)        AS CREATED_OFFER             
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD                  
MFA-TR*               ,STRIP(OPTION_CD)            AS OPTION_CD                 
MFA-TR*           FROM SESSION.CSR04444_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * INPUT PROCESS                                                  *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
           PERFORM 1100-VALIDATE-INPUT       THRU 1100-EXIT.            
                                                                        
           MOVE PARM-APPL-PGM-ID          TO WS-APPL-PGM-ID             
           MOVE PARM-RESOURCE-ID          TO WS-RESOURCE-ID             
           MOVE PARM-USER-ID              TO WS-USER-ID                 
           MOVE PARM-PROC-REQ-ID          TO E9-PROC-REQ-ID             
                                             CI-PROC-REQ-ID             
                                             KM-PROC-REQ-ID             
                                             DU-PROC-REQ-ID             
                                             HQ-PROC-REQ-ID             
                                             G5-PROC-REQ-ID             
                                             FG-PROC-REQ-ID             
                                             FI-PROC-REQ-ID             
                                             1P-PROC-REQ-ID.            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * VALIDATION FOR PROCESS REQUEST IDENTIFIER ( PROC-REQ-ID )     *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF PARM-PROC-REQ-ID > 0                                      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '1100'                  TO ACTIVE-PARAGRAPH          
              MOVE 'RECEIVE INPUT'         TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE SPACES                  TO TABLE-1                   
              MOVE SPACES                  TO TABLE-ELEMENT-1           
              MOVE SPACES                  TO HOSTVAR-ELEMENT-1         
      **********************************************************                
      *      IF PROC-REQ-ID VALUE IS INVALID                   *                
      **********************************************************                
              MOVE +0                      TO WS-ACTIVE-RETURN-CODE     
              MOVE +1000                   TO RS-APPL-RETURN-CODE       
              PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2010-VALIDATION-4DEL           THRU 2010-EXIT.       
           IF CRM-DEL-ALLOWED                                           
              PERFORM 2100-CRM-DELETE-PROCESS     THRU 2100-EXIT        
              PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT       
              PERFORM 8100-SEND-RESULT            THRU 8100-EXIT        
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE WON'T HAPPEN WHEN OPTION ( WITH SAME PROC REQ ID )      *        
      * ATTCHED WITH MULTIPLE OFFERS.                                  *        
      ******************************************************************        
       2010-VALIDATION-4DEL.                                            
                                                                        
      * IF OFFER AS USED AS RENEWAL OFFER WITH ANOTHER OFFER,SHOULD             
      * NOT ALLOW TO DELETE IN DASHBOARD SCREEN FOR THE BASE VERSION.           
                                                                        
           PERFORM 7100-GET-PROC-TYPE-CD          THRU 7100-EXIT.       
           MOVE 1P-PROC-TYPE-CD   TO WS-RPM-WIZARDS                     
           IF CREATE-OFFER-WIZARD OR MODIFY-OFFER-WIZARD                
              PERFORM 7105-GET-OFF-CD-FOR-REQID   THRU 7105-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 7110-CHK-RNWL-OFF-STATUS THRU 7110-EXIT        
                 IF WS-OFF-USED-AS-RNWL-OFF EQUAL WS-YES                
                    MOVE 1002                  TO RS-APPL-RETURN-CODE   
                    MOVE SPACES                TO RS-CREATED-OFFER      
                    MOVE E9-OFFER-CD           TO RS-OFFER-CD           
                    MOVE SPACES                TO RS-OPTION-CD          
                                                                        
                    PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT       
                    PERFORM 8100-SEND-RESULT      THRU 8100-EXIT        
                    PERFORM 9999-END-PROGRAM      THRU 9999-EXIT        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7000-CHK-OFFER-OPTION          THRU 7000-EXIT        
           IF WS-OPTION-EXISTS = 'Y'                                    
              PERFORM 7010-OPEN-OFFER-OPTION-CUR  THRU 7010-EXIT        
              PERFORM 7020-FETCH-OFFER-OPTION-CUR THRU 7020-EXIT        
              PERFORM 2200-MOVE-RESULT-SET        THRU 2200-EXIT        
                                                  UNTIL NO-MORE-ROWS    
              PERFORM 7030-CLOSE-OFFER-OPTION-CUR THRU 7030-EXIT        
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * IF OPTION ATTACHED WITH MUTLIPLE OFFERS,IT SHOULD RETURN THE   *        
      * APPL RETURN CODE AS +1001 AND RESULT SET CAN CONTAIN THE                
      * OFFERS AND CREATED OFFER THAT ATTACHED WITH OPTION.                     
      ******************************************************************        
       2200-MOVE-RESULT-SET.                                            
                                                                        
           MOVE 1001                        TO RS-APPL-RETURN-CODE      
           MOVE WS-CREATED-OFFER            TO RS-CREATED-OFFER.        
           MOVE E9-OFFER-CD                 TO RS-OFFER-CD.             
           MOVE E9-OPTION-CD                TO RS-OPTION-CD.            
                                                                        
           PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
           PERFORM 7020-FETCH-OFFER-OPTION-CUR THRU 7020-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * MOVING RESULT SET TO GTT TABLE VARIABLES                       *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
            IF RS-DELETED-ROW-CNT > 0                                   
               MOVE 0                       TO RS-APPL-RETURN-CODE      
            END-IF.                                                     
                                                                        
            MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
            MOVE RS-APPL-RETURN-CODE        TO S-APPL-RETURN-CODE.      
            MOVE RS-DELETED-ROW-CNT         TO S-DELETED-ROW-COUNT.     
            MOVE RS-CREATED-OFFER           TO S-CREATED-OFFER.         
            MOVE RS-OFFER-CD                TO S-OFFER-CD.              
            MOVE RS-OPTION-CD               TO S-OPTION-CD.             
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
      *                                                                         
      ******************************************************************        
      * MAIN DELETE PROCESS FOR ALL CRM TABLES                         *        
      ******************************************************************        
       2100-CRM-DELETE-PROCESS.                                         
                                                                        
           PERFORM 8000-DEL-OFFER-OPTION          THRU 8000-EXIT        
           PERFORM 8010-DEL-ACCESS-OFF-OPT        THRU 8010-EXIT        
           PERFORM 8020-DEL-MKT-PROMOTION         THRU 8020-EXIT        
           PERFORM 8030-DEL-OFF-MKT-TIER          THRU 8030-EXIT        
           PERFORM 8040-DEL-OPT-ATTR-INCTV        THRU 8040-EXIT        
           PERFORM 8050-DEL-RATE-GRP-OFFER        THRU 8050-EXIT        
           PERFORM 8060-DEL-RT-PKG-OFFER          THRU 8060-EXIT        
           PERFORM 8070-DEL-RT-PKG-OPTION         THRU 8070-EXIT.       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-CHK-OFFER-OPTION                                                   
      ******************************************************************        
       7000-CHK-OFFER-OPTION.                                           
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              E9.OFFER_CD                                       
                 INTO :WS-OPTION-EXISTS                                 
                     ,:WS-CREATED-OFFER                                 
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                     ,CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)                
                WHERE FI.PROC_REQ_ID     = :FI-PROC-REQ-ID              
                  AND FI.PROC_STATUS_CD  = :WS-NEW                      
                  AND FI.OPT_VRSN_NO     = 1                            
                  AND E9.OPTION_CD       = FI.OPTION_CD                 
                  AND E9.PROC_REQ_ID     = :FI-PROC-REQ-ID              
                  AND E9.PROC_STATUS_CD  = :WS-NEW                      
                  AND E9.OFF_OPT_VRSN_NO = 1                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,E9.OFFER_CD                                               
MFA-TR*          INTO :WS-OPTION-EXISTS                                         
MFA-TR*              ,:WS-CREATED-OFFER                                         
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*              ,CRM_OFFER_OPTION  E9                                      
MFA-TR*         WHERE FI.PROC_REQ_ID     = :FI-PROC-REQ-ID                      
MFA-TR*           AND FI.PROC_STATUS_CD  = :WS-NEW                              
MFA-TR*           AND FI.OPT_VRSN_NO     = 1                                    
MFA-TR*           AND E9.OPTION_CD       = FI.OPTION_CD                         
MFA-TR*           AND E9.PROC_REQ_ID     = :FI-PROC-REQ-ID                      
MFA-TR*           AND E9.PROC_STATUS_CD  = :WS-NEW                              
MFA-TR*           AND E9.OFF_OPT_VRSN_NO = 1                                    
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7000'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CRM_OFFER_OPTION'      TO TABLE-1                   
              MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1           
              MOVE FI-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  7010-OPEN-OFFER-OPTION-CUR.                                   *        
      ******************************************************************        
       7010-OPEN-OFFER-OPTION-CUR.                                      
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_OPTION_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7010'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CRM_OFFER_OPTION'      TO TABLE-1                   
              MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1           
              MOVE E9-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7020-FETCH-OFFER-OPTION-CUR.                                   *        
      ******************************************************************        
       7020-FETCH-OFFER-OPTION-CUR.                                     
                                                                        
           EXEC SQL                                                     
               FETCH OFFER_OPTION_CUR                                   
                INTO :E9-OFFER-CD                                       
                    ,:E9-OPTION-CD                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 'N'                    TO WS-DEL-FUNCTION-FL   
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                    TO WS-NO-MORE-ROWS      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME           TO ABEND-PROGRAM        
                    MOVE '7020'                 TO ACTIVE-PARAGRAPH     
                    MOVE 'FETCH'                TO ABEND-FUNCTION       
                    MOVE SPACES                 TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
                    MOVE 'CRM_OFFER_OPTION'     TO TABLE-1              
                    MOVE 'PROC_REQ_ID'          TO TABLE-ELEMENT-1      
                    MOVE E9-PROC-REQ-ID         TO HOSTVAR-ELEMENT-1    
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7030-CLOSE-OFFER-OPTION-CUR.                                   *        
      ******************************************************************        
       7030-CLOSE-OFFER-OPTION-CUR.                                     
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_OPTION_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7030'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CRM_OFFER_OPTION'      TO TABLE-1                   
              MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1           
              MOVE E9-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GET PROCESS TYPE CODE FOR THE INPUT PROCESS REQ ID.           *         
      *****************************************************************         
       7100-GET-PROC-TYPE-CD.                                           
                                                                        
           EXEC SQL                                                     
               SELECT T1P.PROC_TYPE_CD                                  
                 INTO :1P-PROC-TYPE-CD                                  
                 FROM CSS_PROCESS_REQ T1P WITH(READUNCOMMITTED)                 
                WHERE T1P.PROC_REQ_ID   = :1P-PROC-REQ-ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT T1P.PROC_TYPE_CD                                          
MFA-TR*          INTO :1P-PROC-TYPE-CD                                          
MFA-TR*          FROM CSS_PROCESS_REQ T1P                                       
MFA-TR*         WHERE T1P.PROC_REQ_ID   = :1P-PROC-REQ-ID                       
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PROCESS_REQ'     TO TABLE-1                     
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-1             
              MOVE 1P-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7105-GET-OFF-CD-FOR-REQID.                                              
      ******************************************************************        
       7105-GET-OFF-CD-FOR-REQID.                                       
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FG.OFFER_CD                                       
                 INTO :FG-OFFER-CD                                      
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                WHERE FG.PROC_REQ_ID    = :FG-PROC-REQ-ID               
                  AND FG.PROC_STATUS_CD = :WS-NEW                       
                  AND FG.OFF_VRSN_NO    = 1                             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FG.OFFER_CD                                               
MFA-TR*          INTO :FG-OFFER-CD                                              
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.PROC_REQ_ID    = :FG-PROC-REQ-ID                       
MFA-TR*           AND FG.PROC_STATUS_CD = :WS-NEW                               
MFA-TR*           AND FG.OFF_VRSN_NO    = 1                                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7105                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7105'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CRM_RT_PKG_OFFER'      TO TABLE-1                   
              MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1           
              MOVE FI-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-CHK-RNWL-OFF-STATUS.                                               
      ******************************************************************        
       7110-CHK-RNWL-OFF-STATUS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-OFF-USED-AS-RNWL-OFF                          
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                WHERE FG.RENEWAL_OFFER_CD  =  :FG-OFFER-CD              
                  AND FG.RENEWAL_OFFER_CD <>  FG.OFFER_CD               
      *           AND FG.PROC_STATUS_CD  IN (:WS-PEND-APRVL,                    
      *                                      :WS-ERLY-APRVL,                    
      *                                      :WS-APRVL-CMPLT )                  
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-OFF-USED-AS-RNWL-OFF                                  
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.RENEWAL_OFFER_CD  =  :FG-OFFER-CD                      
MFA-TR*           AND FG.RENEWAL_OFFER_CD <>  FG.OFFER_CD                       
MFA-TR*           AND FG.PROC_STATUS_CD  IN (:WS-PEND-APRVL,                    
MFA-TR*                                      :WS-ERLY-APRVL,                    
MFA-TR*                                      :WS-APRVL-CMPLT )                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7110                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7110'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CRM_RT_PKG_OFFER'      TO TABLE-1                   
              MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1           
              MOVE FG-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04444_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04444_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04444_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * DELETE THE ROWS HAVING 'NW' STATUS FROM OFFER-OPTION TABLE     *        
      ******************************************************************        
       8000-DEL-OFFER-OPTION.                                           
                                                                        
           EXEC SQL                                                     
             DELETE FROM E9                             
             FROM CRM_OFFER_OPTION E9
              WHERE E9.PROC_STATUS_CD  = :WS-NEW                        
                AND E9.PROC_REQ_ID     = :E9-PROC-REQ-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CRM_OFFER_OPTION E9                                    
MFA-TR*       WHERE E9.PROC_STATUS_CD  = :WS-NEW                                
MFA-TR*         AND E9.PROC_REQ_ID     = :E9-PROC-REQ-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD SQLERRD(3)               TO RS-DELETED-ROW-CNT  
                    MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE      
               WHEN NOT-FOUND                                           
                    MOVE 100                     TO RS-APPL-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '8000'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DELETE'                TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CRM_OFFER_OPTION'      TO TABLE-1             
                    MOVE 'E9-PROC-REQ-ID'        TO TABLE-ELEMENT-1     
                    MOVE E9-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE THE ROWS HAVING 'NW' STATUS FROM ACCESS-OFF-OPT TABLE   *        
      ******************************************************************        
       8010-DEL-ACCESS-OFF-OPT.                                         
                                                                        
           EXEC SQL                                                     
             DELETE FROM CI                           
             FROM CRM_ACCESS_OFF_OPT CI
              WHERE CI.PROC_STATUS_CD  = :WS-NEW                        
                AND CI.PROC_REQ_ID     = :CI-PROC-REQ-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CRM_ACCESS_OFF_OPT CI                                  
MFA-TR*       WHERE CI.PROC_STATUS_CD  = :WS-NEW                                
MFA-TR*         AND CI.PROC_REQ_ID     = :CI-PROC-REQ-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD SQLERRD(3)               TO RS-DELETED-ROW-CNT  
                    MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE      
               WHEN NOT-FOUND                                           
                    MOVE 100                     TO RS-APPL-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '8010'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DELETE'                TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CRM_ACCESS_OFF_OPT'    TO TABLE-1             
                    MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1     
                    MOVE CI-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE THE ROWS HAVING 'NW' STATUS FROM MKT PROMOTION TABLE    *        
      ******************************************************************        
       8020-DEL-MKT-PROMOTION.                                          
                                                                        
           EXEC SQL                                                     
             DELETE FROM KM                            
             FROM CRM_MKT_PROMOTION KM
              WHERE KM.PROC_STATUS_CD  = :WS-NEW                        
                AND KM.PROC_REQ_ID     = :KM-PROC-REQ-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CRM_MKT_PROMOTION KM                                   
MFA-TR*       WHERE KM.PROC_STATUS_CD  = :WS-NEW                                
MFA-TR*         AND KM.PROC_REQ_ID     = :KM-PROC-REQ-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD SQLERRD(3)               TO RS-DELETED-ROW-CNT  
                    MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE      
               WHEN NOT-FOUND                                           
                    MOVE 100                     TO RS-APPL-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '8020'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DELETE'                TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CRM_MKT_PROMOTION'     TO TABLE-1             
                    MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1     
                    MOVE KM-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE THE ROWS HAVING 'NW' STATUS FROM OFF-MKT-TIER TABLE     *        
      ******************************************************************        
       8030-DEL-OFF-MKT-TIER.                                           
                                                                        
           EXEC SQL                                                     
             DELETE FROM DU                             
             FROM CRM_OFF_MKT_TIER DU
              WHERE DU.PROC_STATUS_CD  = :WS-NEW                        
                AND DU.PROC_REQ_ID     = :DU-PROC-REQ-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CRM_OFF_MKT_TIER DU                                    
MFA-TR*       WHERE DU.PROC_STATUS_CD  = :WS-NEW                                
MFA-TR*         AND DU.PROC_REQ_ID     = :DU-PROC-REQ-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD SQLERRD(3)               TO RS-DELETED-ROW-CNT  
                    MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE      
               WHEN NOT-FOUND                                           
                    MOVE 100                     TO RS-APPL-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '8030'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DELETE'                TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CRM_OFF_MKT_TIER'      TO TABLE-1             
                    MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1     
                    MOVE DU-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE THE ROWS HAVING 'NW' STATUS FROM OPT-ATTR-INCTV TABLE   *        
      ******************************************************************        
       8040-DEL-OPT-ATTR-INCTV.                                         
                                                                        
           EXEC SQL                                                     
             DELETE FROM HQ                           
             FROM CRM_OPT_ATTR_INCTV HQ
              WHERE HQ.PROC_STATUS_CD  = :WS-NEW                        
                AND HQ.PROC_REQ_ID     = :HQ-PROC-REQ-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CRM_OPT_ATTR_INCTV HQ                                  
MFA-TR*       WHERE HQ.PROC_STATUS_CD  = :WS-NEW                                
MFA-TR*         AND HQ.PROC_REQ_ID     = :HQ-PROC-REQ-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD SQLERRD(3)               TO RS-DELETED-ROW-CNT  
                    MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE      
               WHEN NOT-FOUND                                           
                    MOVE 100                     TO RS-APPL-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '8040'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DELETE'                TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CRM_OPT_ATTR_INCTV'    TO TABLE-1             
                    MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1     
                    MOVE HQ-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE THE ROWS HAVING 'NW' STATUS FROM RATE-GRP-OFFER TABLE   *        
      ******************************************************************        
       8050-DEL-RATE-GRP-OFFER.                                         
                                                                        
           EXEC SQL                                                     
             DELETE FROM G5                           
             FROM CRM_RATE_GRP_OFFER G5
              WHERE G5.PROC_STATUS_CD  = :WS-NEW                        
                AND G5.PROC_REQ_ID     = :G5-PROC-REQ-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CRM_RATE_GRP_OFFER G5                                  
MFA-TR*       WHERE G5.PROC_STATUS_CD  = :WS-NEW                                
MFA-TR*         AND G5.PROC_REQ_ID     = :G5-PROC-REQ-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD SQLERRD(3)               TO RS-DELETED-ROW-CNT  
                    MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE      
               WHEN NOT-FOUND                                           
                    MOVE 100                     TO RS-APPL-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '8050'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DELETE'                TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CRM_RATE_GRP_OFFER'    TO TABLE-1             
                    MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1     
                    MOVE G5-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE THE ROWS HAVING 'NW' STATUS FROM RT-PKG-OFFER TABLE     *        
      ******************************************************************        
       8060-DEL-RT-PKG-OFFER.                                           
                                                                        
           EXEC SQL                                                     
             DELETE FROM FG                             
             FROM CRM_RT_PKG_OFFER FG
              WHERE FG.PROC_STATUS_CD  = :WS-NEW                        
                AND FG.PROC_REQ_ID     = :FG-PROC-REQ-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CRM_RT_PKG_OFFER FG                                    
MFA-TR*       WHERE FG.PROC_STATUS_CD  = :WS-NEW                                
MFA-TR*         AND FG.PROC_REQ_ID     = :FG-PROC-REQ-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD SQLERRD(3)               TO RS-DELETED-ROW-CNT  
                    MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE      
               WHEN NOT-FOUND                                           
                    MOVE 100                     TO RS-APPL-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '8060'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DELETE'                TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CRM_RT_PKG_OFFER'      TO TABLE-1             
                    MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1     
                    MOVE FG-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DELETE THE ROWS HAVING 'NW' STATUS FROM RT-PKG-OPTION TABLE    *        
      ******************************************************************        
       8070-DEL-RT-PKG-OPTION.                                          
                                                                        
           EXEC SQL                                                     
             DELETE FROM FI                            
             FROM CRM_RT_PKG_OPTION FI
              WHERE FI.PROC_STATUS_CD  = :WS-NEW                        
                AND FI.PROC_REQ_ID     = :FI-PROC-REQ-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DELETE FROM CRM_RT_PKG_OPTION FI                                   
MFA-TR*       WHERE FI.PROC_STATUS_CD  = :WS-NEW                                
MFA-TR*         AND FI.PROC_REQ_ID     = :FI-PROC-REQ-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    ADD SQLERRD(3)               TO RS-DELETED-ROW-CNT  
                    MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE      
               WHEN NOT-FOUND                                           
                    MOVE 100                     TO RS-APPL-RETURN-CODE 
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME            TO ABEND-PROGRAM       
                    MOVE '8070'                  TO ACTIVE-PARAGRAPH    
                    MOVE 'DELETE'                TO ABEND-FUNCTION      
                    MOVE SPACES                  TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
                    MOVE 'CRM_RT_PKG_OPTION'     TO TABLE-1             
                    MOVE 'PROC_REQ_ID'           TO TABLE-ELEMENT-1     
                    MOVE FI-PROC-REQ-ID          TO HOSTVAR-ELEMENT-1   
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04444_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,DELETED_ROW_COUNT                                    
                  ,CREATED_OFFER                                        
                  ,OFFER_CD                                             
                  ,OPTION_CD                                            
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-DELETED-ROW-COUNT                                 
                  ,:S-CREATED-OFFER                                     
                  ,:S-OFFER-CD                                          
                  ,:S-OPTION-CD                                         
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04444_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,DELETED_ROW_COUNT                                            
MFA-TR*           ,CREATED_OFFER                                                
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-DELETED-ROW-COUNT                                         
MFA-TR*           ,:S-CREATED-OFFER                                             
MFA-TR*           ,:S-OFFER-CD                                                  
MFA-TR*           ,:S-OPTION-CD                                                 
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04444_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
        8100-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE                                         *        
      * JOURNALING / ERROR HANDLING ROUTINE                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                                  
      * END PROGRAM COPYLIB                                            *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
                                                                        
