       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR04439.                                         
       AUTHOR.        MS93554.                                          
COB303 DATE-WRITTEN.  APRIL 04, 2012.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  CSR04439 CLONED FROM SP CSR02238 ON 04/04/2012.               *        
      *  FOR RATE MANAGEMENT MODULE.                                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *      UPDATE TEMPLATE RATE VERSION.                             *        
      *                                                                *        
      *                                                                *        
      *  INPUT PARAMETERS                                                       
      *  -------------------------                                              
      *  APPL_PROG_ID          CHAR(03)                                *        
      *  USER-ID               CHAR(07)                                *        
      *  TEMP_RATE_PLAN_NO     CHAR(03)                                *        
      *  TEMP_VERSION_NO_CNTRL SMALLINT                                *        
      *  COMPANY_NO            CHAR(02)                                *        
      *  CODE_UTIL_TYPE        CHAR(01)                                *        
      *  RATE_PLAN_NO          CHAR(03)                                *        
      *  RATE_DESCRIPTION      CHAR(50)                                *        
      *  EFFECTIVE_DATE        CHAR(10)                                *        
      *  PROC_REQ_ID           CHAR(10)                                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  -------------------------                                     *        
      *  RETURN_CODE           INTEGER                                 *        
      *  APPL_RETURN_CODE      INTEGER                                 *        
      *  CODE_UTIL_TYPE        CHAR(03)                                *        
      *  RATE_PLAN_NO          CHAR(03)                                *        
      *  VERSION_NO_CNTRL      INTEGER                                 *        
      *                                                                *        
      *  APPL RETURN CODE                                              *        
      *  -------------------------                                     *        
      *  +295 - INPUT INVALID.                                         *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/04/12  MS93554    NEW PROGRAM.                             *        
      *  06/19/12  AW41078    ADDED CODE_SERVICE_TYPE TO RD INSERT     *        
      *  09/28/12  MS93554    COPY CSS_REV_CLS_RATE ROWS FOR NEW       *        
      *                       UNMETERED RATE CREATED VIA TEMPLATE.     *        
      *  11/01/12  AW41078    FIX ISSUE WHERE UNMETERED PLAN NOT COPIED*        
      *                       FOR METERED PLANS WITH UNMETERED         *        
      *                       PROVISION.                               *        
A04177*  01/09/13  AW41078    ADD PS.BLOCK_DESC TO TEMPLATE PROCESS    *        
A04177*  01/09/13  AW41078    ADD PS.BLOCK_DESC TO TEMPLATE PROCESS    *        
A04177*  06/12/13  MS93554    ADD RD.RATE_DEFINITION_CD TO TEMPLATE    *        
      *             ACT039    PROCESS.                                 *        
A05136*  11/13/15  RS7M249    MADE THE NEW RATE PLAN NO TO INSERT IN   *        
A05136*             ACT228    CSS_DMT_PGM_ID TABLE FOR CODE UTIL TYPE  *        
A05136*                       'G' AND DELETED UNUSED COPYBOOKS.        *        
      *  09/15/16  DB41297    REMOVE CSS_RATE_MIN                      *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04439'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04439 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_PLAN_DESC   RD                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_CREATOR     RT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_USE_SEASN   RS                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTUSES                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_DISCOUNT   J5                                       *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDISC                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_DEMAND_RATCHET  J2                                       *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDEMRCH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_VRSN_DEF   J4                                       *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTVRSN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_COMP_DEF   J1                                      *          
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_DEMAND_INST     DI                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDMDINS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_PRICE_SCHED     PS                                   *             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RTP_DETAIL      J3                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTPDET                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_DELINQUENCY - C8                                        *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE TBDELQ                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *  CSS_UNMETERED_PLAN  UP                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_TOU_INSTR  RK                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTTOU                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_TOU        RJ                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTTOUD                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CSS_RATE_RIDER_E    RZ                                      *          
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTRDR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_RATE_HIGH_LOW,   O9                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTHGLW                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_DMT_PGM_ID, T2                                             *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDMTPI                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_BTU_WNA_RANGE, BR                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBTUWNA                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_REV_CLS_RATE, Q8                                           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRVCLS                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SPCL_FCTR, SF                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * CSS_SPCL_FCTR_APPL, SA                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *  ERROR HANDLING                                              *          
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                *        
      ******************************************************************        
           COPY CWS00027.                                                       
      ******************************************************************        
      *  SUPPORTS DB2 AND SQL ERROR CHECKING                           *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME                PIC X(08) VALUE 'CSR04439'.  
           05  ALL-DONE-SW                 PIC X(01) VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  WS-TEMP-RATE-PLAN-NO        PIC X(3)  VALUE SPACES.      
           05  WS-TEMP-VERSION-NO-CNTRL    PIC S9(4) USAGE COMP.        
           05  WS-NEW-VERSION-NO-CNTRL     PIC S9(4) USAGE COMP.        
           05  WS-MAX-VERSION-NO-CNTRL     PIC S9(4) USAGE COMP.        
           05  WS-CODE-UTIL-TYPE           PIC X(1)  VALUE SPACES.      
           05  WS-RATE-PLAN-NO             PIC X(3)  VALUE SPACES.      
           05  WS-RATE-DESCRIPTION         PIC X(50) VALUE SPACES.      
           05  WS-USER-ID                  PIC X(7)  VALUE SPACES.      
           05  WS-CMPNT-ID-CD              PIC X(2)  VALUE SPACES.      
           05  WS-CODE-USE-INST-TYPE       PIC X(1)  VALUE SPACES.      
           05  WS-NEW-RATE-PLAN-EXISTS     PIC X(1)  VALUE 'N'.         
           05  WS-TBRTDESC-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTCRTR-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTUSES-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTDISC-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBDEMRCH-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTVRSN-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTCDEF-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTMIN-RETURN-CODE      PIC S9(4) VALUE ZEROES.      
           05  WS-TBDMDINS-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBPRCSCH-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTPDET-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBUMPLAN-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTTOU-RETURN-CODE      PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTTOUD-RETURN-CODE     PIC S9(4) VALUE ZEROES.      
           05  WS-TBRTRDR-RETURN-CODE      PIC S9(4) VALUE ZEROES.      
           05  WS-COMPANY-NO               PIC X(02) VALUE '01'.        
           05  WS-EFFECTIVE-DATE           PIC X(10) VALUE SPACES.      
           05  WS-ROW-EXISTS               PIC X(01) VALUE SPACES.      
           05  WS-HOLD-DATE-TO             PIC X(10) VALUE SPACES.      
           05  WS-HOLD-PREV-DT             PIC X(10) VALUE SPACES.      
           05  WS-PROC-REQ-ID              PIC X(10).                   
           05  WS-CURRENT-DATE             PIC X(10).                   
                                                                        
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.              
              88 NO-MORE-ROWS                   VALUE 'Y'.              
                                                                        
       01  WS-INDICATOR-VARIABLES.                                      
           05  WS-RT-DATE-CREATED-NULL     PIC S9(4) USAGE COMP.        
           05  WS-RT-FROM-EFF-DT-NULL      PIC S9(4) USAGE COMP.        
           05  WS-RS-DATE-FROM-NULL        PIC S9(4) USAGE COMP.        
           05  WS-RS-DATE-TO-NULL          PIC S9(4) USAGE COMP.        
           05  WS-MAX-VERS-NO-CNTRL-NULL   PIC S9(4) USAGE COMP.        
           05  WS-SEASONAL-DEP-IND-NULL    PIC S9(4) USAGE COMP.        
           05  WS-SEASNAL-BLK-CHG-CD-NULL  PIC S9(4) USAGE COMP.        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-1                        PIC S9(4) VALUE 1 USAGE COMP.
           05  WS-STATUS-IS-TEST           PIC X(1)  VALUE 'T'.         
           05  WS-UNMETERED-PLAN-CODE      PIC X(1)  VALUE 'U'.         
           05  WS-ZERO                     PIC S9(4) VALUE 0 USAGE COMP.
           05  WS-TEST                     PIC X(01) VALUE 'T'.         
           05  WS-REVENUE-MONTH            PIC X(01) VALUE 'R'.         
           05  WS-YES                      PIC X(01) VALUE 'Y'.         
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-01            PIC S9(4) COMP.                 
           05 WS-MAX-ENTRY-NO-NULL      PIC S9(4) COMP.                 
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR04439_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-APPL-RETURN-CODE       PIC S9(9) COMP VALUE 0.         
           05  S-CODE-UTIL-TYPE         PIC X(01) VALUE SPACES.         
           05  S-RATE-PLAN-NO           PIC X(03) VALUE SPACES.         
           05  S-VERSION-NO-CNTRL       PIC S9(4) COMP VALUE 0.         
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_RATE_COMP_DEF                              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE TBRTCDEF_CURSOR CURSOR FOR                       
                SELECT CMPNT_ID_CD                                      
                      ,REG_TYPE_CD                                      
                      ,ENERGY_UNIT_CD                                   
                      ,ENERGY_SEAS_CD                                   
                      ,LAST_ENERGY_BLOCK                                
                      ,LAST_DEM_BLOCK                                   
                      ,DEM_REG_TYPE_CD                                  
                      ,DEM_UNIT_CD                                      
                      ,DEM_SEASON_CD                                    
                      ,ON_PEAK_DAYS                                     
                      ,CALENDAR_CD                                      
                      ,RTP_BASELINE_RATE                                
                      ,BAL_FWD_CD                                       
                      ,BAL_RESET_MMDD                                   
                      ,BAL_RESET_PRO_CD                                 
                      ,BAL_OFFSET_TOU_CD                                
                  FROM CSS_RATE_COMP_DEF WITH(READUNCOMMITTED)                  
                 WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE           
                   AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO        
                   AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL    
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE TBRTCDEF_CURSOR CURSOR FOR                               
MFA-TR*         SELECT CMPNT_ID_CD                                              
MFA-TR*               ,REG_TYPE_CD                                              
MFA-TR*               ,ENERGY_UNIT_CD                                           
MFA-TR*               ,ENERGY_SEAS_CD                                           
MFA-TR*               ,LAST_ENERGY_BLOCK                                        
MFA-TR*               ,LAST_DEM_BLOCK                                           
MFA-TR*               ,DEM_REG_TYPE_CD                                          
MFA-TR*               ,DEM_UNIT_CD                                              
MFA-TR*               ,DEM_SEASON_CD                                            
MFA-TR*               ,ON_PEAK_DAYS                                             
MFA-TR*               ,CALENDAR_CD                                              
MFA-TR*               ,RTP_BASELINE_RATE                                        
MFA-TR*               ,BAL_FWD_CD                                               
MFA-TR*               ,BAL_RESET_MMDD                                           
MFA-TR*               ,BAL_RESET_PRO_CD                                         
MFA-TR*               ,BAL_OFFSET_TOU_CD                                        
MFA-TR*           FROM CSS_RATE_COMP_DEF                                        
MFA-TR*          WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                   
MFA-TR*            AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                
MFA-TR*            AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL            
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_PRICE_SCHED                                *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBPRCSCH_CURSOR CURSOR FOR                        
               SELECT CODE_SEASON                                       
                     ,CODE_TIME_PERIOD                                  
                     ,CODE_USE_INST_TYPE                                
                     ,BLOCK_NO                                          
                     ,BLOCK_USE_OR_SVCS                                 
                     ,BLOCK_DESC                                        
                     ,SCHED_PRICE_AM                                    
                     ,PRICE_TYPE_CD                                     
                     ,LAST_PRICE_DAY_MTH                                
                     ,BEGN_PRICE_DAY_MTH                                
                     ,ITEM_ID                                           
                     ,DATE_PRICE_END                                    
                     ,DAYS_PRICE_APPLIES                                
                     ,SCHED_WNA_RATE_AMT                                
                 FROM CSS_PRICE_SCHED WITH(READUNCOMMITTED)                     
                WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO         
                  AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL     
                  AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBPRCSCH_CURSOR CURSOR FOR                                
MFA-TR*        SELECT CODE_SEASON                                               
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,CODE_USE_INST_TYPE                                        
MFA-TR*              ,BLOCK_NO                                                  
MFA-TR*              ,BLOCK_USE_OR_SVCS                                         
MFA-TR*              ,BLOCK_DESC                                                
MFA-TR*              ,SCHED_PRICE_AM                                            
MFA-TR*              ,PRICE_TYPE_CD                                             
MFA-TR*              ,LAST_PRICE_DAY_MTH                                        
MFA-TR*              ,BEGN_PRICE_DAY_MTH                                        
MFA-TR*              ,ITEM_ID                                                   
MFA-TR*              ,DATE_PRICE_END                                            
MFA-TR*              ,DAYS_PRICE_APPLIES                                        
MFA-TR*              ,SCHED_WNA_RATE_AMT                                        
MFA-TR*          FROM CSS_PRICE_SCHED                                           
MFA-TR*         WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                 
MFA-TR*           AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL             
MFA-TR*           AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_RTP_DETAIL                                 *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBRTPDET_CURSOR CURSOR FOR                        
               SELECT CODE_USE_INST_TYPE                                
                     ,RTP_PRICE_AMT                                     
                     ,PRICE_APPLIES_DT                                  
                     ,PRICE_APPLIES_HR                                  
                 FROM CSS_RTP_DETAIL WITH(READUNCOMMITTED)                      
                WHERE CODE_UTIL_TYPE      = :WS-CODE-UTIL-TYPE          
                  AND RATE_PLAN_NO        = :WS-TEMP-RATE-PLAN-NO       
                  AND VERSION_NO_CNTRL    = :WS-TEMP-VERSION-NO-CNTRL   
                  AND CMPNT_ID_CD         = :WS-CMPNT-ID-CD             
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBRTPDET_CURSOR CURSOR FOR                                
MFA-TR*        SELECT CODE_USE_INST_TYPE                                        
MFA-TR*              ,RTP_PRICE_AMT                                             
MFA-TR*              ,PRICE_APPLIES_DT                                          
MFA-TR*              ,PRICE_APPLIES_HR                                          
MFA-TR*          FROM CSS_RTP_DETAIL                                            
MFA-TR*         WHERE CODE_UTIL_TYPE      = :WS-CODE-UTIL-TYPE                  
MFA-TR*           AND RATE_PLAN_NO        = :WS-TEMP-RATE-PLAN-NO               
MFA-TR*           AND VERSION_NO_CNTRL    = :WS-TEMP-VERSION-NO-CNTRL           
MFA-TR*           AND CMPNT_ID_CD         = :WS-CMPNT-ID-CD                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7900                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_RATE_USE_SEASN                             *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBRTUSES_CURSOR CURSOR FOR                        
               SELECT CODE_USE_INST_TYPE                                
                     ,DATE_FROM                                         
                     ,CODE_SEASON                                       
                     ,DATE_TO                                           
                 FROM CSS_RATE_USE_SEASN WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO         
                  AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL     
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBRTUSES_CURSOR CURSOR FOR                                
MFA-TR*        SELECT CODE_USE_INST_TYPE                                        
MFA-TR*              ,DATE_FROM                                                 
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*              ,DATE_TO                                                   
MFA-TR*          FROM CSS_RATE_USE_SEASN                                        
MFA-TR*         WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                 
MFA-TR*           AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_RATE_DISCOUNT                              *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBRTDISC_CURSOR CURSOR FOR                        
               SELECT RATE_DISC_CD                                      
                     ,RATE_DISC_OPT                                     
                     ,DISC_RATE_AMT                                     
                 FROM CSS_RATE_DISCOUNT WITH(READUNCOMMITTED)                   
                WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO         
                  AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL     
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBRTDISC_CURSOR CURSOR FOR                                
MFA-TR*        SELECT RATE_DISC_CD                                              
MFA-TR*              ,RATE_DISC_OPT                                             
MFA-TR*              ,DISC_RATE_AMT                                             
MFA-TR*          FROM CSS_RATE_DISCOUNT                                         
MFA-TR*         WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                 
MFA-TR*           AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_DEMAND_RATCHET                             *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBDEMRCH_CURSOR CURSOR FOR                        
               SELECT RATCHET_ID                                        
                     ,FROM_MONTH                                        
                     ,TO_MONTH                                          
                     ,RATCHET_PCT                                       
                     ,RATCHET_YR_IND                                    
                 FROM CSS_DEMAND_RATCHET WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO         
                  AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL     
               FOR READ ONLY                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBDEMRCH_CURSOR CURSOR FOR                                
MFA-TR*        SELECT RATCHET_ID                                                
MFA-TR*              ,FROM_MONTH                                                
MFA-TR*              ,TO_MONTH                                                  
MFA-TR*              ,RATCHET_PCT                                               
MFA-TR*              ,RATCHET_YR_IND                                            
MFA-TR*          FROM CSS_DEMAND_RATCHET                                        
MFA-TR*         WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                 
MFA-TR*           AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL             
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS-UNMTR-PLAN                                 *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBUMPLAN_CURSOR CURSOR FOR                        
               SELECT RATE_ITEM_CODE                                    
                     ,UM_EQUIP_ID                                       
                     ,CUST_PER_SERVICE                                  
                     ,PRICE_PER_SERV                                    
                 FROM CSS_UNMTR_PLAN WITH(READUNCOMMITTED)                      
                WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO         
                  AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL     
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBUMPLAN_CURSOR CURSOR FOR                                
MFA-TR*        SELECT RATE_ITEM_CODE                                            
MFA-TR*              ,UM_EQUIP_ID                                               
MFA-TR*              ,CUST_PER_SERVICE                                          
MFA-TR*              ,PRICE_PER_SERV                                            
MFA-TR*          FROM CSS_UNMTR_PLAN                                            
MFA-TR*         WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                 
MFA-TR*           AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7250                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_RATE_TOU_INSTR                             *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBRTTOU_CURSOR CURSOR FOR                         
               SELECT CODE_UTIL_TYPE                                    
                     ,RATE_PLAN_NO                                      
                     ,VERSION_NO_CNTRL                                  
                     ,CMPNT_ID_CD                                       
                     ,CODE_TIME_PERIOD                                  
                     ,RATE_MIN_IND                                      
                     ,CNTRCT_MIN_IND                                    
                     ,MAX_DEMAND_IND                                    
                     ,RATCHET_ID_1                                      
                     ,RATCHET_ID_2                                      
                     ,RATCHET_ID_3                                      
                     ,MRG_OFF_PK_IND                                    
                     ,MRG_CTR_MIN_IND                                   
                     ,MRG_RT_MIN                                        
                     ,CODE_SEASON                                       
                     ,CNTRCT_MIN_PCT                                    
                 FROM CSS_RATE_TOU_INSTR WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO         
                  AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL     
                  AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBRTTOU_CURSOR CURSOR FOR                                 
MFA-TR*        SELECT CODE_UTIL_TYPE                                            
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,VERSION_NO_CNTRL                                          
MFA-TR*              ,CMPNT_ID_CD                                               
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,RATE_MIN_IND                                              
MFA-TR*              ,CNTRCT_MIN_IND                                            
MFA-TR*              ,MAX_DEMAND_IND                                            
MFA-TR*              ,RATCHET_ID_1                                              
MFA-TR*              ,RATCHET_ID_2                                              
MFA-TR*              ,RATCHET_ID_3                                              
MFA-TR*              ,MRG_OFF_PK_IND                                            
MFA-TR*              ,MRG_CTR_MIN_IND                                           
MFA-TR*              ,MRG_RT_MIN                                                
MFA-TR*              ,CODE_SEASON                                               
MFA-TR*              ,CNTRCT_MIN_PCT                                            
MFA-TR*          FROM CSS_RATE_TOU_INSTR                                        
MFA-TR*         WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                 
MFA-TR*           AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL             
MFA-TR*           AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 8000                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_RATE_TOU_DEF                               *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBRTTOUD_CURSOR CURSOR FOR                        
               SELECT CODE_UTIL_TYPE                                    
                     ,RATE_PLAN_NO                                      
                     ,VERSION_NO_CNTRL                                  
                     ,CMPNT_ID_CD                                       
                     ,CODE_TIME_PERIOD                                  
                     ,TOU_TO_HOUR                                       
                     ,TOU_FROM_HOUR                                     
                     ,TOU_TO_MMDD                                       
                     ,TOU_FROM_MMDD                                     
                 FROM CSS_RATE_TOU_DEF WITH(READUNCOMMITTED)                    
                WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO         
                  AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL     
                  AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBRTTOUD_CURSOR CURSOR FOR                                
MFA-TR*        SELECT CODE_UTIL_TYPE                                            
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,VERSION_NO_CNTRL                                          
MFA-TR*              ,CMPNT_ID_CD                                               
MFA-TR*              ,CODE_TIME_PERIOD                                          
MFA-TR*              ,TOU_TO_HOUR                                               
MFA-TR*              ,TOU_FROM_HOUR                                             
MFA-TR*              ,TOU_TO_MMDD                                               
MFA-TR*              ,TOU_FROM_MMDD                                             
MFA-TR*          FROM CSS_RATE_TOU_DEF                                          
MFA-TR*         WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                 
MFA-TR*           AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL             
MFA-TR*           AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7930                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      CURSOR FOR CSS_RATE_RIDER_EXP                             *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE TBRTRDR_CURSOR CURSOR FOR                         
               SELECT CODE_UTIL_TYPE                                    
                     ,VERSION_NO_CNTRL                                  
                     ,RATE_PLAN_NO                                      
                     ,TO_HHMM                                           
                     ,FROM_HHMM                                         
                     ,TO_MONTH                                          
                     ,FROM_MONTH                                        
                 FROM CSS_RATE_RIDER_EXP WITH(READUNCOMMITTED)                  
                WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE            
                  AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO         
                  AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL     
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TBRTRDR_CURSOR CURSOR FOR                                 
MFA-TR*        SELECT CODE_UTIL_TYPE                                            
MFA-TR*              ,VERSION_NO_CNTRL                                          
MFA-TR*              ,RATE_PLAN_NO                                              
MFA-TR*              ,TO_HHMM                                                   
MFA-TR*              ,FROM_HHMM                                                 
MFA-TR*              ,TO_MONTH                                                  
MFA-TR*              ,FROM_MONTH                                                
MFA-TR*          FROM CSS_RATE_RIDER_EXP                                        
MFA-TR*         WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                 
MFA-TR*           AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 8030                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR SELECT REV CLASS RATE                                  *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE REV_CLASS_CSR CURSOR FOR                          
               SELECT Q8.CODE_REVENUE_CLASS                             
                     ,Q8.GL_ACCT_NO                                     
                     ,Q8.STATUS_CD                                      
                     ,Q8.COMPANY_NO                                     
                     ,Q8.STATUS_CHANGE_DT                               
                 FROM CSS_REV_CLS_RATE  Q8 WITH(READUNCOMMITTED)                
                WHERE Q8.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE           
                  AND Q8.RATE_PLAN_NO    = :WS-TEMP-RATE-PLAN-NO        
                  AND Q8.COMPANY_NO      = :WS-COMPANY-NO               
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE REV_CLASS_CSR CURSOR FOR                                  
MFA-TR*        SELECT Q8.CODE_REVENUE_CLASS                                     
MFA-TR*              ,Q8.GL_ACCT_NO                                             
MFA-TR*              ,Q8.STATUS_CD                                              
MFA-TR*              ,Q8.COMPANY_NO                                             
MFA-TR*              ,Q8.STATUS_CHANGE_DT                                       
MFA-TR*          FROM CSS_REV_CLS_RATE  Q8                                      
MFA-TR*         WHERE Q8.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                   
MFA-TR*           AND Q8.RATE_PLAN_NO    = :WS-TEMP-RATE-PLAN-NO                
MFA-TR*           AND Q8.COMPANY_NO      = :WS-COMPANY-NO                       
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR SELECT SPECIAL FACTOR                                  *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE SPCL_FCT_CSR CURSOR FOR                           
                 SELECT SA.FACTOR_ID                                    
                       ,SA.ENTRY_NO                                     
                       ,SA.CMPNT_ID_CD                                  
                       ,SA.CODE_SEASON                                  
                       ,SA.INSTR_USE_TYPE_CD                            
                       ,SA.CODE_TIME_PERIOD                             
                       ,SA.CODE_REVENUE_CLASS                           
                       ,SA.FACTOR                                       
                       ,SA.VERS_PRORATE_CD                              
                       ,SA.CODE_UTIL_TYPE                               
                       ,SA.RATE_PLAN_NO                                 
                       ,SA.DATE_FROM                                    
                       ,SA.DATE_TO                                      
                       ,SA.CODE_STATUS                                  
                       ,SA.BLOCK_NO                                     
                   FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)             
                       ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)             
                  WHERE SA.FACTOR_ID        = SF.FACTOR_ID              
                    AND SA.CODE_STATUS      = SF.CODE_STATUS            
                    AND SF.RATE_TEMPLATE_FL = 'Y'                       
                    AND SA.CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE        
                    AND SA.RATE_PLAN_NO     = :WS-TEMP-RATE-PLAN-NO     
                    AND SA.CMPNT_ID_CD      = :SA-CMPNT-ID-CD           
                    AND SA.CODE_STATUS      = 'A'                       
                    AND (SA.DATE_FROM       > IIF(TRY_CONVERT(DATE, 
                                                     :WS-EFFECTIVE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-EFFECTIVE-DATE
              ) <> 0) OR (LEN(:WS-EFFECTIVE-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-EFFECTIVE-DATE
              ), CONVERT(DATE, :WS-EFFECTIVE-DATE) )        
                         OR SA.DATE_TO      > IIF(TRY_CONVERT(DATE, 
                                                     :WS-EFFECTIVE-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-EFFECTIVE-DATE
              ) <> 0) OR (LEN(:WS-EFFECTIVE-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-EFFECTIVE-DATE
              ), CONVERT(DATE, :WS-EFFECTIVE-DATE) ))       
                  ORDER BY SA.DATE_FROM ASC                             
                    FOR READ ONLY                               
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SPCL_FCT_CSR CURSOR FOR                                   
MFA-TR*          SELECT SA.FACTOR_ID                                            
MFA-TR*                ,SA.ENTRY_NO                                             
MFA-TR*                ,SA.CMPNT_ID_CD                                          
MFA-TR*                ,SA.CODE_SEASON                                          
MFA-TR*                ,SA.INSTR_USE_TYPE_CD                                    
MFA-TR*                ,SA.CODE_TIME_PERIOD                                     
MFA-TR*                ,SA.CODE_REVENUE_CLASS                                   
MFA-TR*                ,SA.FACTOR                                               
MFA-TR*                ,SA.VERS_PRORATE_CD                                      
MFA-TR*                ,SA.CODE_UTIL_TYPE                                       
MFA-TR*                ,SA.RATE_PLAN_NO                                         
MFA-TR*                ,SA.DATE_FROM                                            
MFA-TR*                ,SA.DATE_TO                                              
MFA-TR*                ,SA.CODE_STATUS                                          
MFA-TR*                ,SA.BLOCK_NO                                             
MFA-TR*            FROM CSS_SPCL_FCTR_APPL SA                                   
MFA-TR*                ,CSS_SPCL_FCTR      SF                                   
MFA-TR*           WHERE SA.FACTOR_ID        = SF.FACTOR_ID                      
MFA-TR*             AND SA.CODE_STATUS      = SF.CODE_STATUS                    
MFA-TR*             AND SF.RATE_TEMPLATE_FL = 'Y'                               
MFA-TR*             AND SA.CODE_UTIL_TYPE   = :WS-CODE-UTIL-TYPE                
MFA-TR*             AND SA.RATE_PLAN_NO     = :WS-TEMP-RATE-PLAN-NO             
MFA-TR*             AND SA.CMPNT_ID_CD      = :SA-CMPNT-ID-CD                   
MFA-TR*             AND SA.CODE_STATUS      = 'A'                               
MFA-TR*             AND (SA.DATE_FROM       > :WS-EFFECTIVE-DATE                
MFA-TR*                  OR SA.DATE_TO      > :WS-EFFECTIVE-DATE)               
MFA-TR*           ORDER BY SA.DATE_FROM ASC                                     
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR SELECT DTM PGM ID                                      *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE DTM_PGM_ID_CSR CURSOR FOR                         
                SELECT T2.CODE_UTIL_TYPE                                
                      ,T2.DIGTL_MTR_TYPE                                
                      ,T2.PROGRAM_ID                                    
                      ,T2.RATE_PLAN_NO                                  
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           T2.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,T2.LAST_UPDATE_USERID                            
                 FROM CSS_DMT_PGM_ID T2 WITH(READUNCOMMITTED)                   
                WHERE T2.CODE_UTIL_TYPE  = :T2-CODE-UTIL-TYPE           
                  AND T2.RATE_PLAN_NO    = :T2-RATE-PLAN-NO             
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DTM_PGM_ID_CSR CURSOR FOR                                 
MFA-TR*         SELECT T2.CODE_UTIL_TYPE                                        
MFA-TR*               ,T2.DIGTL_MTR_TYPE                                        
MFA-TR*               ,T2.PROGRAM_ID                                            
MFA-TR*               ,T2.RATE_PLAN_NO                                          
MFA-TR*               ,T2.LAST_UPDATE_TS                                        
MFA-TR*               ,T2.LAST_UPDATE_USERID                                    
MFA-TR*          FROM CSS_DMT_PGM_ID T2                                         
MFA-TR*         WHERE T2.CODE_UTIL_TYPE  = :T2-CODE-UTIL-TYPE                   
MFA-TR*           AND T2.RATE_PLAN_NO    = :T2-RATE-PLAN-NO                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  CURSOR SELECT DTM PGM ID                                      *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE BTU_WNA_RANGE_CSR CURSOR FOR                      
                SELECT BR.CODE_UTIL_TYPE                                
                      ,BR.RATE_PLAN_NO                                  
                      ,COALESCE(CAST(BR.EFFECTIVE_DT
            AS CHAR(10)),'          ')       
                      ,BR.BTU_UPPER_LIMIT                               
                      ,BR.BTU_LOWER_LIMIT                               
                      ,BR.WNA_UPPER_LIMIT                               
                      ,BR.WNA_LOWER_LIMIT                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           BR.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,BR.LAST_UPDATE_USERID                            
                      ,BR.WNA_LOWER_LIMIT_WQ                            
                      ,BR.WNA_UPPER_LIMIT_WQ                            
                      ,BR.GAS_BASE_HIGH_RATE                            
                      ,BR.GAS_BASE_LOW_RATE                             
                      ,BR.GAS_BASE_USE_DFLT                             
                      ,BR.GAS_BASE_USE_MIN                              
                      ,BR.WNA_GAS_RATE                                  
                 FROM CSS_BTU_WNA_RANGE BR WITH(READUNCOMMITTED)                
                WHERE BR.CODE_UTIL_TYPE  = :BR-CODE-UTIL-TYPE           
                  AND BR.RATE_PLAN_NO    = :BR-RATE-PLAN-NO             
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE BTU_WNA_RANGE_CSR CURSOR FOR                              
MFA-TR*         SELECT BR.CODE_UTIL_TYPE                                        
MFA-TR*               ,BR.RATE_PLAN_NO                                          
MFA-TR*               ,IFNULL(CHAR(BR.EFFECTIVE_DT),'          ')               
MFA-TR*               ,BR.BTU_UPPER_LIMIT                                       
MFA-TR*               ,BR.BTU_LOWER_LIMIT                                       
MFA-TR*               ,BR.WNA_UPPER_LIMIT                                       
MFA-TR*               ,BR.WNA_LOWER_LIMIT                                       
MFA-TR*               ,BR.LAST_UPDATE_TS                                        
MFA-TR*               ,BR.LAST_UPDATE_USERID                                    
MFA-TR*               ,BR.WNA_LOWER_LIMIT_WQ                                    
MFA-TR*               ,BR.WNA_UPPER_LIMIT_WQ                                    
MFA-TR*               ,BR.GAS_BASE_HIGH_RATE                                    
MFA-TR*               ,BR.GAS_BASE_LOW_RATE                                     
MFA-TR*               ,BR.GAS_BASE_USE_DFLT                                     
MFA-TR*               ,BR.GAS_BASE_USE_MIN                                      
MFA-TR*               ,BR.WNA_GAS_RATE                                          
MFA-TR*          FROM CSS_BTU_WNA_RANGE BR                                      
MFA-TR*         WHERE BR.CODE_UTIL_TYPE  = :BR-CODE-UTIL-TYPE                   
MFA-TR*           AND BR.RATE_PLAN_NO    = :BR-RATE-PLAN-NO                     
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID           PIC X(03).                       
       01  PARM-USER-ID                PIC X(07).                       
       01  PARM-TEMP-RATE-PLAN-NO      PIC X(03).                       
       01  PARM-TEMP-VERSION-NO-CNTRL  PIC S9(4) USAGE COMP.            
       01  PARM-COMPANY-NO             PIC X(02).                       
       01  PARM-CODE-UTIL-TYPE         PIC X(01).                       
       01  PARM-RATE-PLAN-NO           PIC X(03).                       
       01  PARM-RATE-DESC              PIC X(50).                       
       01  PARM-EFFECTIVE-DATE         PIC X(10).                       
       01  PARM-PROC-REQ-ID            PIC X(10).                       
                                                                        
       PROCEDURE DIVISION USING PARM-APPL-PROG-ID                       
                                PARM-USER-ID                            
                                PARM-TEMP-RATE-PLAN-NO                  
                                PARM-TEMP-VERSION-NO-CNTRL              
                                PARM-COMPANY-NO                         
                                PARM-CODE-UTIL-TYPE                     
                                PARM-RATE-PLAN-NO                       
                                PARM-RATE-DESC                          
                                PARM-EFFECTIVE-DATE                     
                                PARM-PROC-REQ-ID.                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE                AS  RETURN_CODE        
                  ,:S-APPL-RETURN-CODE           AS  APPL_RETURN_CODE   
                  ,:S-CODE-UTIL-TYPE             AS  CODE_UTIL_TYPE     
                  ,:S-RATE-PLAN-NO               AS  RATE_PLAN_NO       
                  ,:S-VERSION-NO-CNTRL           AS  VERSION_NO_CNTRL   
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE                AS  RETURN_CODE                
MFA-TR*           ,:S-APPL-RETURN-CODE           AS  APPL_RETURN_CODE           
MFA-TR*           ,:S-CODE-UTIL-TYPE             AS  CODE_UTIL_TYPE             
MFA-TR*           ,:S-RATE-PLAN-NO               AS  RATE_PLAN_NO               
MFA-TR*           ,:S-VERSION-NO-CNTRL           AS  VERSION_NO_CNTRL           
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-TEMP-RATE-PLAN-NO      TO WS-TEMP-RATE-PLAN-NO.    
           MOVE PARM-TEMP-VERSION-NO-CNTRL  TO WS-TEMP-VERSION-NO-CNTRL.
           MOVE PARM-COMPANY-NO             TO WS-COMPANY-NO.           
           MOVE PARM-CODE-UTIL-TYPE         TO WS-CODE-UTIL-TYPE        
                                               S-CODE-UTIL-TYPE.        
           MOVE PARM-RATE-PLAN-NO           TO WS-RATE-PLAN-NO          
                                               S-RATE-PLAN-NO.          
           MOVE PARM-RATE-DESC              TO WS-RATE-DESCRIPTION.     
           MOVE PARM-USER-ID                TO WS-USER-ID.              
           MOVE PARM-EFFECTIVE-DATE         TO WS-EFFECTIVE-DATE.       
           MOVE PARM-PROC-REQ-ID            TO WS-PROC-REQ-ID           
                                               RT-PROC-REQ-ID.          
                                                                        
           PERFORM 1100-VALIDATE-INPUT         THRU 1100-EXIT.          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * BASIC INPUT VALIDATION                                        *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF WS-CODE-UTIL-TYPE        > SPACES AND                     
              WS-TEMP-RATE-PLAN-NO     > SPACES AND                     
              WS-EFFECTIVE-DATE        > SPACES AND                     
              WS-TEMP-VERSION-NO-CNTRL > 0                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '1100'                  TO ACTIVE-PARAGRAPH          
              MOVE 'RECEIVE INPUT'         TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE SPACES                  TO TABLE-1                   
              MOVE SPACES                  TO TABLE-ELEMENT-1           
              MOVE SPACES                  TO HOSTVAR-ELEMENT-1         
      **********************************************************                
      *      IF PASSED INPUT VALUES ARE INVALID                *                
      **********************************************************                
              MOVE 0                       TO S-RETURN-CODE             
              MOVE +295                    TO S-APPL-RETURN-CODE        
              ADD 1                        TO  CTR-ROWS                 
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-PROCESS-FETCH-CUR-INS-NEW THRU 2200-EXIT.       
           ADD 1                                TO  CTR-ROWS.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2200-PROCESS-FETCH-CUR-INS-NEW                                 *        
      ******************************************************************        
       2200-PROCESS-FETCH-CUR-INS-NEW.                                  
                                                                        
      *    CHECK TO SEE IF THERE IS ALREADY A RATE PLAN DESC                    
      *    FOR THE NEW RATE PLAN. IF THERE IS DO NOTHING TO                     
      *    IT ELSE ADD A NEW RATE PLAN DESC.                                    
           MOVE WS-N                     TO WS-NEW-RATE-PLAN-EXISTS.    
           PERFORM 7201-SELECT-NEW-TBRTDESC-ROW      THRU 7201-EXIT.    
           PERFORM 7200-SELECT-TBRTDESC-ROW       THRU 7200-EXIT        
                                                                        
      *    INSERT NEW CSS_RATE_PLAN_DESC ROW                                    
           IF WS-NEW-RATE-PLAN-EXISTS EQUAL WS-N                        
              PERFORM 8200-INSERT-NEW-TBRTDESC-ROW   THRU 8200-EXIT     
           END-IF.                                                      
                                                                        
      *    WORK OUT WHAT THE NEW VERSION NO SHOULD BE - IF THE NULL             
      *    INDICATOR IS NEGATIVE THEN NO VERSIONS EXIST AND THE NEW             
      *    VERSION IS 1 ELSE ADD 1 TO THE LAST VERSION FOUND                    
           PERFORM 7221-SELECT-MAX-VERS-NO           THRU 7221-EXIT.    
           IF WS-MAX-VERS-NO-CNTRL-NULL < WS-ZERO                       
              MOVE WS-1                    TO WS-NEW-VERSION-NO-CNTRL   
           ELSE                                                         
              ADD  WS-1                    TO WS-MAX-VERSION-NO-CNTRL   
              MOVE WS-MAX-VERSION-NO-CNTRL TO WS-NEW-VERSION-NO-CNTRL   
           END-IF.                                                      
                                                                        
           MOVE WS-NEW-VERSION-NO-CNTRL    TO S-VERSION-NO-CNTRL.       
                                                                        
      *    INSERT NEW ROW INTO CSS_RATE_CREATOR                                 
           PERFORM 7220-SELECT-TBRTCRTR-ROW          THRU 7220-EXIT.    
           MOVE WS-EFFECTIVE-DATE          TO RT-FROM-EFFECTIVE-DT.     
           PERFORM 7210-ACCEPT-CURRENTDATE           THRU 7210-EXIT.    
           MOVE WS-CURRENT-DATE            TO RT-DISPLAY-START-TS(1:10).
           MOVE '-08.00.00.000000'         TO RT-DISPLAY-START-TS(11:16)
           MOVE '2999-12-31-00.00.00.000000'                            
                                           TO RT-DISPLAY-END-TS.        
           PERFORM 8220-INSERT-NEW-TBRTCRTR-ROW      THRU 8220-EXIT.    
                                                                        
      *    IF UNMETERED PROVISIONS FLAG IS YES AND INPUT CODE UTIL TYPE         
      *    IS NOT EQUAL TO UNMETERED, UNMETER ROWS NEED TO BE COPIED.           
           IF (RD-UNMTR-PROV-FL EQUAL WS-YES) AND                       
              (WS-CODE-UTIL-TYPE NOT EQUAL WS-UNMETERED-PLAN-CODE)      
              PERFORM 5250-CREATE-NEW-UNMETERED-PLAN THRU 5250-EXIT     
           END-IF                                                       
                                                                        
      *    IF THE CODE UTIL TYPE IS UNMETERED,ONLY UNMETER PLAN AND             
      *    CSS_REV_CLS_RATE ROWS NEEDS TO BE DUPLICATED IN ADDITION             
      *    TO RATE PLAN DESC AND RATE CREATOR ALREADY DUPLICATED ELSE           
      *    ALL THE OTHER TABLES MUST BE PROCESSED.                              
           IF (WS-CODE-UTIL-TYPE EQUAL WS-UNMETERED-PLAN-CODE)          
              PERFORM 5250-CREATE-NEW-UNMETERED-PLAN THRU 5250-EXIT     
      *       INSERT NEW ROW INTO CSS_REV_CLS_RATE                              
              MOVE WS-CODE-UTIL-TYPE         TO Q8-CODE-UTIL-TYPE       
              MOVE WS-RATE-PLAN-NO           TO Q8-RATE-PLAN-NO         
              PERFORM 7990-SELECT-REV-CLS       THRU 7990-EXIT          
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 5600-CREATE-NEW-REV-CLS-RATE THRU 5600-EXIT    
              END-IF                                                    
           ELSE                                                         
                                                                        
      *    GET RATE VERSION INFORMATION FROM CSS_RATE_VRSN_DEF TABLE            
      *    FOR THE TEMP RATE PLAN NO AND INSERT WITH NEW ARTE PLAN NO.          
              PERFORM 7240-SELECT-TBRTVRSN-ROW       THRU 7240-EXIT     
              IF WS-TBRTVRSN-RETURN-CODE = SUCCESSFUL-CALL              
                 PERFORM 8240-INSERT-NEW-TBRTVRSN-ROW                   
                                                     THRU 8240-EXIT     
              END-IF                                                    
                                                                        
      ******************************************************************        
      *    IF NEW RATE PLAN NO AND TEMPLATE RATE PLAN NO IS NOT SAME  *         
      *    NEED TO CREATE A NEW ENTRIES FOR THE BELOW TABLES BASED ON  *        
      *    THE TEMP RATE PLAN NO.                                      *        
      *                          CSS_RATE_HIGH_LOW                     *        
      *                          CSS_DMT_PGM_ID                        *        
      *                          CSS_BTU_WNA_RANGE                     *        
      *                          CSS_REV_CLS_RATE.                     *        
      ******************************************************************        
              IF WS-RATE-PLAN-NO NOT EQUAL WS-TEMP-RATE-PLAN-NO         
                 PERFORM 5650-CREATE-NEW-ENTRIES     THRU 5650-EXIT     
              END-IF                                                    
                                                                        
      ******************************************************************        
      *       INSERT NEW ROWS INTO                                     *        
      *                           CSS_RATE_COMP_DEF                    *        
      *                           CSS_PRICE_SCHED                               
      *                           CSS_RTP_DETAIL                                
      *                           CSS_RATE_MIN                                  
      *                           CSS_DEMAND_INSTR                              
      *                           CSS_RATE_TOU_DEF                              
      *                           CSS_RATE_TOU_INSTR TABLES.                    
      ******************************************************************        
              PERFORM 5700-CREATE-NEW-RATE-COMPONENT THRU 5700-EXIT     
                                                                        
      *       INSERT NEW ROW INTO CSS_RATE_RIDER_EXP TABLE                      
              PERFORM 5710-CREATE-RATE-RIDER-XCPTN   THRU 5710-EXIT     
                                                                        
      *       INSERT NEW ROW INTO CSS_RATE_RIDER_EXP TABLE                      
              PERFORM 5300-CREATE-NEW-DEMAND-RATCHET THRU 5300-EXIT     
                                                                        
      *       INSERT NEW ROW INTO CSS_RATE_DISCOUNT  TABLE                      
              PERFORM 5400-CREATE-NEW-RATE-DISCOUNT  THRU 5400-EXIT     
                                                                        
      *       INSERT NEW ROW INTO CSS_RATE_USE_SEASN TABLE                      
              PERFORM 5500-CREATE-NEW-RATE-USE-SEASN THRU 5500-EXIT     
                                                                        
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2250-PROCESS-FETCH-TBUMPLAN                                    *        
      ******************************************************************        
       2250-PROCESS-FETCH-TBUMPLAN.                                     
                                                                        
           PERFORM 7260-FETCH-TBUMPLAN-CURSOR   THRU 7260-EXIT.         
           IF WS-TBUMPLAN-RETURN-CODE = SUCCESSFUL-CALL                 
              PERFORM 8250-INSERT-NEW-TBUMPLAN-ROW                      
                                                THRU 8250-EXIT          
           END-IF.                                                      
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-PROCESS-FETCH-TBDEMRCH                                    *        
      ******************************************************************        
       2300-PROCESS-FETCH-TBDEMRCH.                                     
                                                                        
           PERFORM 7310-FETCH-TBDEMRCH-CURSOR        THRU 7310-EXIT.    
           IF WS-TBDEMRCH-RETURN-CODE EQUAL SUCCESSFUL-CALL             
              PERFORM 8300-INSERT-NEW-TBDEMRCH-ROW   THRU 8300-EXIT     
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-PROCESS-FETCH-TBRTDISC                                    *        
      ******************************************************************        
       2400-PROCESS-FETCH-TBRTDISC.                                     
                                                                        
           PERFORM 7410-FETCH-TBRTDISC-CURSOR        THRU 7410-EXIT.    
           IF WS-TBRTDISC-RETURN-CODE = SUCCESSFUL-CALL                 
              PERFORM 8400-INSERT-NEW-TBRTDISC-ROW   THRU 8400-EXIT     
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2500-PROCESS-FETCH-TBRTUSES                                    *        
      ******************************************************************        
                                                                        
       2500-PROCESS-FETCH-TBRTUSES.                                     
                                                                        
           PERFORM 7510-FETCH-TBRTUSES-CURSOR        THRU 7510-EXIT.    
           IF WS-TBRTUSES-RETURN-CODE = SUCCESSFUL-CALL                 
              PERFORM 8500-INSERT-NEW-TBRTUSES-ROW   THRU 8500-EXIT     
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2700-PROCESS-FETCH-TBRTCDEF                                    *        
      *     FETCHES A ROW FROM THE TABLE CSS_RATE_COMP_DEF.            *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      *     IF THE ROW EXISTS EVERY CORRESPONDING TBPRCSCH ROW IS      *        
      *     PROCESSED AND IF TBRTMIN AND TBDMDINS ROWS EXIST THEN      *        
      *     NEW ROWS ARE INSERTED. TOU DEFINITIONS (RJ) AND DEMAND     *        
      *     DETERMINANTS (RK) ARE ALSO INSERTED IF NECESSARY.          *        
      ******************************************************************        
       2700-PROCESS-FETCH-TBRTCDEF.                                     
                                                                        
           PERFORM 7710-FETCH-TBRTCDEF-CURSOR     THRU 7710-EXIT.       
                                                                        
           IF WS-TBRTCDEF-RETURN-CODE = SUCCESSFUL-CALL                 
              MOVE J1-CMPNT-ID-CD TO WS-CMPNT-ID-CD                     
                                     SA-CMPNT-ID-CD                     
                                                                        
      *       INSERT NEW ROW INTO CSS_RATE_COMP_DEF TABLE                       
              PERFORM 8700-INSERT-NEW-TBRTCDEF-ROW   THRU 8700-EXIT     
                                                                        
      *       INSERT NEW ROW INTO CSS_PRICE_SCHED TABLE                         
              PERFORM 7800-OPEN-TBPRCSCH-CURSOR      THRU 7800-EXIT     
              PERFORM 2800-PROCESS-FETCH-TBPRCSCH    THRU 2800-EXIT     
                 UNTIL WS-TBPRCSCH-RETURN-CODE = NOT-FOUND              
              PERFORM 7820-CLOSE-TBPRCSCH-CURSOR     THRU 7820-EXIT     
                                                                        
      *       INSERT NEW ROW INTO CSS_RTP_DETAIL TABLE                          
              PERFORM 7900-OPEN-TBRTPDET-CURSOR      THRU 7900-EXIT     
              PERFORM 2900-PROCESS-FETCH-TBRTPDET    THRU 2900-EXIT     
                 UNTIL WS-TBRTPDET-RETURN-CODE = NOT-FOUND              
              PERFORM 7920-CLOSE-TBRTPDET-CURSOR     THRU 7920-EXIT     
                                                                        
                                                                        
      *       INSERT NEW ROW INTO CSS_DEMAND_INSTR TABLE                        
              PERFORM 7650-SELECT-TBDMDINS-ROW       THRU 7650-EXIT     
              IF WS-TBDMDINS-RETURN-CODE = SUCCESSFUL-CALL              
                 PERFORM 8650-INSERT-NEW-TBDMDINS-ROW THRU 8650-EXIT    
              END-IF                                                    
                                                                        
      *       INSERT NEW ROW INTO CSS_RATE_TOU_DEF TABLE                        
              PERFORM 7930-OPEN-TBRTTOUD-CURSOR      THRU 7930-EXIT     
              PERFORM 2810-PROCESS-FETCH-TBRTTOUD    THRU 2810-EXIT     
                 UNTIL WS-TBRTTOUD-RETURN-CODE = NOT-FOUND              
              PERFORM 7950-CLOSE-TBRTTOUD-CURSOR     THRU 7950-EXIT     
                                                                        
      *       INSERT NEW ROW INTO CSS_RATE_TOU_INSTR TABLE                      
              PERFORM 8000-OPEN-TBRTTOU-CURSOR      THRU 8000-EXIT      
              PERFORM 2820-PROCESS-FETCH-TBRTTOU    THRU 2820-EXIT      
                 UNTIL WS-TBRTTOU-RETURN-CODE = NOT-FOUND               
              PERFORM 8020-CLOSE-TBRTTOU-CURSOR     THRU 8020-EXIT      
                                                                        
      *       SPECIAL FACTOR APPLICATION PROCESS                                
              IF WS-TEMP-RATE-PLAN-NO NOT EQUAL WS-RATE-PLAN-NO         
                 MOVE WS-CODE-UTIL-TYPE      TO SA-CODE-UTIL-TYPE       
                 MOVE WS-RATE-PLAN-NO        TO SA-RATE-PLAN-NO         
                 PERFORM 7995-SELECT-SPCL-FCT-APPL THRU 7995-EXIT       
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    PERFORM 5660-CREATE-SPCL-FCTR THRU 5660-EXIT        
                 END-IF                                                 
              END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2800-PROCESS-FETCH-TBPRCSCH                                    *        
      *     FETCHES A ROW FROM THE TABLE CSS_PRICE_SCHED.              *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      *     IF THE ROW EXISTS EVERY CORRESPONDING TBRTPDET ROW IS      *        
      *     PROCESSED.                                                 *        
      ******************************************************************        
       2800-PROCESS-FETCH-TBPRCSCH.                                     
                                                                        
           PERFORM 7810-FETCH-TBPRCSCH-CURSOR        THRU 7810-EXIT.    
           IF WS-TBPRCSCH-RETURN-CODE = SUCCESSFUL-CALL                 
              MOVE PS-CODE-USE-INST-TYPE TO WS-CODE-USE-INST-TYPE       
              PERFORM 8800-INSERT-NEW-TBPRCSCH-ROW   THRU 8800-EXIT     
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2810-PROCESS-FETCH-TBRTTOUD                                    *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      ******************************************************************        
       2810-PROCESS-FETCH-TBRTTOUD.                                     
                                                                        
           PERFORM 7940-FETCH-TBRTTOUD-CURSOR        THRU 7940-EXIT.    
           IF WS-TBRTTOUD-RETURN-CODE = SUCCESSFUL-CALL                 
              PERFORM 8870-INSERT-NEW-TBRTTOUD-ROW   THRU 8870-EXIT     
           END-IF.                                                      
                                                                        
       2810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2820-PROCESS-FETCH-TBRTTOU                                     *        
      *     FETCHES A ROW FROM THE TABLE CSS_RATE_TOU_INSTR.           *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      ******************************************************************        
                                                                        
       2820-PROCESS-FETCH-TBRTTOU.                                      
                                                                        
           PERFORM 8010-FETCH-TBRTTOU-CURSOR         THRU 8010-EXIT.    
           IF WS-TBRTTOU-RETURN-CODE = SUCCESSFUL-CALL                  
              PERFORM 8860-INSERT-NEW-TBRTTOU-ROW    THRU 8860-EXIT     
           END-IF.                                                      
                                                                        
       2820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2820-PROCESS-FETCH-TBRTRDR                                     *        
      *     CALLED FROM 2700-PROCESS-FETCH-TBRTRDR                     *        
      *     FETCHES A ROW FROM THE TABLE CSS_RATE_RIDER_EXP.           *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      ******************************************************************        
                                                                        
       2830-PROCESS-FETCH-TBRTRDR.                                      
                                                                        
           PERFORM 8040-FETCH-TBRTRDR-CURSOR         THRU 8040-EXIT.    
           IF WS-TBRTRDR-RETURN-CODE = SUCCESSFUL-CALL                  
              PERFORM 8880-INSERT-NEW-TBRTRDR-ROW    THRU 8880-EXIT     
           END-IF.                                                      
                                                                        
       2830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2900-PROCESS-FETCH-TBRTPDET                                    *        
      *     FETCHES A ROW FROM THE TABLE CSS_RTP_DETAIL.               *        
      *     IF THE ROW EXISTS A NEW ROW IS FORMATTED AND INSERTED.     *        
      ******************************************************************        
       2900-PROCESS-FETCH-TBRTPDET.                                     
                                                                        
           PERFORM 7910-FETCH-TBRTPDET-CURSOR        THRU 7910-EXIT.    
           IF WS-TBRTPDET-RETURN-CODE = SUCCESSFUL-CALL                 
              PERFORM 8850-INSERT-NEW-TBRTPDET-ROW   THRU 8850-EXIT     
           END-IF.                                                      
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5250-CREATE-NEW-UNMETERED-PLAN                                 *        
      ******************************************************************        
       5250-CREATE-NEW-UNMETERED-PLAN.                                  
                                                                        
            PERFORM 7250-OPEN-TBUMPLAN-CURSOR        THRU 7250-EXIT.    
            PERFORM 2250-PROCESS-FETCH-TBUMPLAN      THRU 2250-EXIT     
               UNTIL WS-TBUMPLAN-RETURN-CODE = NOT-FOUND.               
            PERFORM 7270-CLOSE-TBUMPLAN-CURSOR       THRU 7270-EXIT.    
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5300-CREATE-NEW-DEMAND-RATCHET                                 *        
      ******************************************************************        
                                                                        
       5300-CREATE-NEW-DEMAND-RATCHET.                                  
                                                                        
            PERFORM 7300-OPEN-TBDEMRCH-CURSOR        THRU 7300-EXIT.    
            PERFORM 2300-PROCESS-FETCH-TBDEMRCH      THRU 2300-EXIT     
               UNTIL WS-TBDEMRCH-RETURN-CODE = NOT-FOUND.               
            PERFORM 7320-CLOSE-TBDEMRCH-CURSOR       THRU 7320-EXIT.    
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5400-CREATE-NEW-RATE-DISCOUNT                                  *        
      ******************************************************************        
       5400-CREATE-NEW-RATE-DISCOUNT.                                   
                                                                        
            PERFORM 7400-OPEN-TBRTDISC-CURSOR        THRU 7400-EXIT.    
            PERFORM 2400-PROCESS-FETCH-TBRTDISC      THRU 2400-EXIT     
               UNTIL WS-TBRTDISC-RETURN-CODE = NOT-FOUND.               
            PERFORM 7420-CLOSE-TBRTDISC-CURSOR       THRU 7420-EXIT.    
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5500-CREATE-NEW-RATE-USE-SEASN                                 *        
      ******************************************************************        
                                                                        
       5500-CREATE-NEW-RATE-USE-SEASN.                                  
                                                                        
            PERFORM 7500-OPEN-TBRTUSES-CURSOR        THRU 7500-EXIT.    
            PERFORM 2500-PROCESS-FETCH-TBRTUSES      THRU 2500-EXIT     
               UNTIL WS-TBRTUSES-RETURN-CODE = NOT-FOUND.               
            PERFORM 7520-CLOSE-TBRTUSES-CURSOR       THRU 7520-EXIT.    
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5600-CREATE-NEW-REV-CLS-RATE                                  *         
      *****************************************************************         
       5600-CREATE-NEW-REV-CLS-RATE.                                    
                                                                        
           MOVE 'N'                          TO WS-NO-MORE-ROWS         
           PERFORM 7000-OPEN-REV-CLASS-CSR           THRU 7000-EXIT.    
           PERFORM 7010-FETCH-REV-CLASS-CSR          THRU 7010-EXIT.    
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 PERFORM 8930-INSERT-REV-CLS-RATE    THRU 8930-EXIT     
              END-IF                                                    
              PERFORM 7010-FETCH-REV-CLASS-CSR       THRU 7010-EXIT     
           END-PERFORM.                                                 
                                                                        
           PERFORM 7020-CLOSE-REV-CLASS-CSR          THRU 7020-EXIT.    
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5650-CREATE-NEW-ENTRIES.                                      *         
      *****************************************************************         
       5650-CREATE-NEW-ENTRIES.                                         
                                                                        
      *    SELECT THE DATA FROM CSS_RATE_HIGH_LOW TABLE FOR THE                 
      *    TEMP RATE PLAN NO AND INSERT WITH NEW RATE PLAN NO.                  
           MOVE WS-CODE-UTIL-TYPE           TO O9-CODE-UTIL-TYPE        
           MOVE WS-TEMP-RATE-PLAN-NO        TO O9-RATE-PLAN-NO          
           PERFORM 7960-SELECT-RT-HIGH-LOW     THRU 7960-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 8905-INSERT-RT-HIGH-LOW  THRU 8905-EXIT           
           END-IF                                                       
                                                                        
      ****************************************************************          
      *    CHECK IF ROW ALREADY EXISTS IN THE TABLE FOR THE NEW RATE *          
      *    RATE PLAN NO. IF NO ROW PRESENT,COPY ALL THE ROWS FOR THE *          
      *    TEMP RATE PLAN NO AND INSERT INTO TABLE WITH NEW RATE.    *          
      ****************************************************************          
                                                                        
ACT228     IF WS-CODE-UTIL-TYPE = 'G'                                   
      *    INSERT NEW ROW INTO CSS_DMT_PGM_ID                                   
           MOVE WS-CODE-UTIL-TYPE           TO T2-CODE-UTIL-TYPE        
           MOVE WS-RATE-PLAN-NO             TO T2-RATE-PLAN-NO          
           PERFORM 7970-SELECT-DTM-PGM-ID      THRU 7970-EXIT           
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'N'                      TO WS-NO-MORE-ROWS          
              MOVE WS-CODE-UTIL-TYPE        TO T2-CODE-UTIL-TYPE        
              MOVE WS-TEMP-RATE-PLAN-NO     TO T2-RATE-PLAN-NO          
              PERFORM 7100-OPEN-DTM-PGM-ID     THRU 7100-EXIT           
              PERFORM 7110-FETCH-DTM-PGM-ID    THRU 7110-EXIT           
                                                                        
              PERFORM UNTIL NO-MORE-ROWS                                
                PERFORM 8910-INSERT-DTM-PGM-ID THRU 8910-EXIT           
                PERFORM 7110-FETCH-DTM-PGM-ID  THRU 7110-EXIT           
              END-PERFORM                                               
                                                                        
              PERFORM 7120-CLOSE-DTM-PGM-ID    THRU 7120-EXIT           
           END-IF                                                       
ACT228     END-IF                                                       
                                                                        
      *    INSERT NEW ROW INTO CSS_BTU_WNA_RANGE                                
           MOVE WS-CODE-UTIL-TYPE         TO BR-CODE-UTIL-TYPE          
           MOVE WS-RATE-PLAN-NO           TO BR-RATE-PLAN-NO            
           PERFORM 7980-SELECT-BTU-WNA-RNG   THRU 7980-EXIT             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'N'                       TO WS-NO-MORE-ROWS         
              MOVE WS-TEMP-RATE-PLAN-NO      TO BR-RATE-PLAN-NO         
              PERFORM 7150-OPEN-BTU-WNA-RANGE   THRU 7150-EXIT          
              PERFORM 7160-FETCH-BTU-WNA-RANGE  THRU 7160-EXIT          
                                                                        
              PERFORM UNTIL NO-MORE-ROWS                                
                 MOVE WS-EFFECTIVE-DATE      TO BR-EFFECTIVE-DT         
                 PERFORM 8920-INSERT-BTU-WNA-ROW     THRU 8920-EXIT     
                 PERFORM 7160-FETCH-BTU-WNA-RANGE    THRU 7160-EXIT     
              END-PERFORM                                               
                                                                        
              PERFORM 7170-CLOSE-BTU-WNA-RANGE       THRU 7170-EXIT     
           END-IF                                                       
                                                                        
      *    INSERT NEW ROW INTO CSS_REV_CLS_RATE                                 
           MOVE WS-CODE-UTIL-TYPE         TO Q8-CODE-UTIL-TYPE          
           MOVE WS-RATE-PLAN-NO           TO Q8-RATE-PLAN-NO            
           PERFORM 7990-SELECT-REV-CLS       THRU 7990-EXIT             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 5600-CREATE-NEW-REV-CLS-RATE   THRU 5600-EXIT     
           END-IF.                                                      
                                                                        
       5650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5660-CREATE-SPCL-FCTR.                                        *         
      *****************************************************************         
       5660-CREATE-SPCL-FCTR.                                           
                                                                        
           MOVE 'N'                          TO WS-NO-MORE-ROWS         
           PERFORM 7050-OPEN-SPCL-FCT-CSR       THRU 7050-EXIT          
           PERFORM 7060-FETCH-SPCL-FCT-CSR      THRU 7060-EXIT          
           MOVE SA-DATE-TO                   TO WS-HOLD-DATE-TO         
                                                                        
           PERFORM UNTIL NO-MORE-ROWS                                   
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
                MOVE WS-TEST                 TO SA-CODE-STATUS          
                                                                        
                IF SA-VERS-PRORATE-CD EQUAL WS-REVENUE-MONTH            
                   MOVE '01'                 TO SA-DATE-FROM(9:2)       
                ELSE                                                    
                   MOVE SA-FACTOR-ID         TO SF-FACTOR-ID            
                   PERFORM 7996-SELECT-SPCL-FCTR THRU 7996-EXIT         
                   IF SF-VERS-PRORATE-CD EQUAL WS-REVENUE-MONTH         
                      MOVE '01'               TO SA-DATE-FROM(9:2)      
                      MOVE SF-VERS-PRORATE-CD TO SA-VERS-PRORATE-CD     
                   END-IF                                               
                END-IF                                                  
                                                                        
                PERFORM 7998-SEL-ENTRY-NO       THRU 7998-EXIT          
                IF WS-MAX-ENTRY-NO-NULL < WS-ZERO                       
                   MOVE WS-1            TO SA-ENTRY-NO                  
                ELSE                                                    
                   ADD WS-1             TO SA-ENTRY-NO                  
                END-IF                                                  
                                                                        
                PERFORM 8940-INSRT-SPCL-FCT-CSR THRU 8940-EXIT          
             END-IF                                                     
                                                                        
             PERFORM 7060-FETCH-SPCL-FCT-CSR    THRU 7060-EXIT          
                                                                        
           END-PERFORM                                                  
                                                                        
           PERFORM 7070-CLOSE-SPCL-FCT-CSR      THRU 7070-EXIT.         
                                                                        
       5660-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5700-CREATE-NEW-RATE-COMPONENT                                 *        
      *     CALLED FROM 2200-PROCESS-FETCH-CUR-INS-NEW                 *        
      *     CREATES NEW RATE COMPONENTS, INSERTS ALL PRICE SCHEDULES   *        
      *     FOR EACH COMPONENT, AND INSERTS ALL RTP DETAILS FOR EACH   *        
      *     PRICE SCHEDULE.  ALSO, INSERTS TOU DEFINITIONS (RJ) AND    *        
      *     DEMAND DETERMINANTS (RK) IF NECESSARY.                     *        
      ******************************************************************        
       5700-CREATE-NEW-RATE-COMPONENT.                                  
                                                                        
           PERFORM 7700-OPEN-TBRTCDEF-CURSOR         THRU 7700-EXIT.    
           PERFORM 2700-PROCESS-FETCH-TBRTCDEF       THRU 2700-EXIT     
               UNTIL WS-TBRTCDEF-RETURN-CODE = NOT-FOUND.               
           PERFORM 7720-CLOSE-TBRTCDEF-CURSOR        THRU 7720-EXIT.    
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5710-CREATE-RATE-RIDER-XCPTN                                  *         
      *****************************************************************         
       5710-CREATE-RATE-RIDER-XCPTN.                                    
                                                                        
           PERFORM 8030-OPEN-TBRTRDR-CURSOR          THRU 8030-EXIT.    
           PERFORM 2830-PROCESS-FETCH-TBRTRDR        THRU 2830-EXIT     
                      UNTIL WS-TBRTRDR-RETURN-CODE = NOT-FOUND.         
           PERFORM 8050-CLOSE-TBRTRDR-CURSOR         THRU 8050-EXIT.    
                                                                        
       5710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-OPEN-REV-CLASS-CSR.                                      *         
      *****************************************************************         
       7000-OPEN-REV-CLASS-CSR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN REV_CLASS_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_REV_CLS_RATE'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-TEMP-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2       
              MOVE Q8-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7010-FETCH-REV-CLASS-CSR.                                     *         
      *****************************************************************         
       7010-FETCH-REV-CLASS-CSR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH REV_CLASS_CSR                                      
                INTO :Q8-CODE-REVENUE-CLASS                             
                    ,:Q8-GL-ACCT-NO                                     
                    ,:Q8-STATUS-CD                                      
                    ,:Q8-COMPANY-NO                                     
                    ,:Q8-STATUS-CHANGE-DT :WS-NULL-IND-01                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y'                      TO WS-NO-MORE-ROWS         
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_REV_CLS_RATE'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-TEMP-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2       
              MOVE Q8-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7020-FETCH-REV-CLASS-CSR.                                     *         
      *****************************************************************         
       7020-CLOSE-REV-CLASS-CSR.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE REV_CLASS_CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_REV_CLS_RATE'        TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-TEMP-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2       
              MOVE Q8-COMPANY-NO             TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7050-OPEN-SPCL-FCT-CSR.                                       *         
      *****************************************************************         
       7050-OPEN-SPCL-FCT-CSR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN SPCL_FCT_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-TEMP-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7060-FETCH-SPCL-FCT-CSR.                                    *           
      *****************************************************************         
       7060-FETCH-SPCL-FCT-CSR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH SPCL_FCT_CSR                                       
                INTO :SA-FACTOR-ID                                      
                    ,:SA-ENTRY-NO                                       
                    ,:SA-CMPNT-ID-CD                                    
                    ,:SA-CODE-SEASON                                    
                    ,:SA-INSTR-USE-TYPE-CD                              
                    ,:SA-CODE-TIME-PERIOD                               
                    ,:SA-CODE-REVENUE-CLASS                             
                    ,:SA-FACTOR                                         
                    ,:SA-VERS-PRORATE-CD                                
                    ,:SA-CODE-UTIL-TYPE                                 
                    ,:SA-RATE-PLAN-NO                                   
                    ,:SA-DATE-FROM                                      
                    ,:SA-DATE-TO                                        
                    ,:SA-CODE-STATUS                                    
                    ,:SA-BLOCK-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y' TO WS-NO-MORE-ROWS                              
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7060'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-TEMP-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7070-FETCH-SPCL-FCT-CSR.                                      *         
      *****************************************************************         
       7070-CLOSE-SPCL-FCT-CSR.                                         
                                                                        
           EXEC SQL                                                     
               CLOSE SPCL_FCT_CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-TEMP-RATE-PLAN-NO      TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7100-OPEN-DTM-PGM-ID.                                         *         
      *****************************************************************         
       7100-OPEN-DTM-PGM-ID.                                            
                                                                        
           EXEC SQL                                                     
                OPEN DTM_PGM_ID_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_DMT_PGM_ID'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE T2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE T2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7110-FETCH-DTM-PGM-ID.                                      *           
      *****************************************************************         
       7110-FETCH-DTM-PGM-ID.                                           
                                                                        
           EXEC SQL                                                     
               FETCH DTM_PGM_ID_CSR                                     
                INTO :T2-CODE-UTIL-TYPE                                 
                    ,:T2-DIGTL-MTR-TYPE                                 
                    ,:T2-PROGRAM-ID                                     
                    ,:T2-RATE-PLAN-NO                                   
                    ,:T2-LAST-UPDATE-TS                                 
                    ,:T2-LAST-UPDATE-USERID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y' TO WS-NO-MORE-ROWS                              
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_DMT_PGM_ID'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE T2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE T2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7120-FETCH-SPCL-FCT-CSR.                                      *         
      *****************************************************************         
       7120-CLOSE-DTM-PGM-ID.                                           
                                                                        
           EXEC SQL                                                     
               CLOSE DTM_PGM_ID_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_DMT_PGM_ID'          TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE T2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE T2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7150-OPEN-BTU-WNA-RANGE.                                      *         
      *****************************************************************         
       7150-OPEN-BTU-WNA-RANGE.                                         
                                                                        
           EXEC SQL                                                     
                OPEN BTU_WNA_RANGE_CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_WNA_RANGE'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE BR-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE BR-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7160-FETCH-BTU-WNA-RANGE.                                   *           
      *****************************************************************         
       7160-FETCH-BTU-WNA-RANGE.                                        
                                                                        
           EXEC SQL                                                     
               FETCH BTU_WNA_RANGE_CSR                                  
                INTO :BR-CODE-UTIL-TYPE                                 
                    ,:BR-RATE-PLAN-NO                                   
                    ,:BR-EFFECTIVE-DT                                   
                    ,:BR-BTU-UPPER-LIMIT                                
                    ,:BR-BTU-LOWER-LIMIT                                
                    ,:BR-WNA-UPPER-LIMIT                                
                    ,:BR-WNA-LOWER-LIMIT                                
                    ,:BR-LAST-UPDATE-TS                                 
                    ,:BR-LAST-UPDATE-USERID                             
                    ,:BR-WNA-LOWER-LIMIT-WQ                             
                    ,:BR-WNA-UPPER-LIMIT-WQ                             
                    ,:BR-GAS-BASE-HIGH-RATE                             
                    ,:BR-GAS-BASE-LOW-RATE                              
                    ,:BR-GAS-BASE-USE-DFLT                              
                    ,:BR-GAS-BASE-USE-MIN                               
                    ,:BR-WNA-GAS-RATE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
               MOVE 'Y' TO WS-NO-MORE-ROWS                              
             END-IF                                                     
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7160'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_WNA_RANGE'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE BR-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE BR-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7170-FETCH-BTU-WNA-RANGE.                                     *         
      *****************************************************************         
       7170-CLOSE-BTU-WNA-RANGE.                                        
                                                                        
           EXEC SQL                                                     
               CLOSE BTU_WNA_RANGE_CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_WNA_RANGE'       TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE BR-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE BR-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7200-SELECT-TBRTDESC-ROW                                      *         
      *****************************************************************         
       7200-SELECT-TBRTDESC-ROW.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RATE_DESC                                          
                    ,COMPANY_NO                                         
                    ,SECURED_RATE_FL                                    
                    ,SUM_REVENUE_FL                                     
                    ,UNMTR_PROV_FL                                      
                    ,REG_GROUP_CD                                       
                    ,BILL_LITERAL_TX                                    
                    ,MKT_PROGRAM_CD                                     
                    ,RATE_CALC_TYPE_CD                                  
                    ,SENIOR_RATE_FL                                     
                    ,RATE_DEPT_CD                                       
                    ,REV_CUST_COUNT_CD                                  
                    ,DEFERRED_COG_FL                                    
                    ,CODE_SERVICE_TYPE                                  
A04177              ,RATE_DEFINITION_CD                                 
                INTO :RD-RATE-DESC                                      
                    ,:RD-COMPANY-NO                                     
                    ,:RD-SECURED-RATE-FL                                
                    ,:RD-SUM-REVENUE-FL                                 
                    ,:RD-UNMTR-PROV-FL                                  
                    ,:RD-REG-GROUP-CD                                   
                    ,:RD-BILL-LITERAL-TX                                
                    ,:RD-MKT-PROGRAM-CD                                 
                    ,:RD-RATE-CALC-TYPE-CD                              
                    ,:RD-SENIOR-RATE-FL                                 
                    ,:RD-RATE-DEPT-CD                                   
                    ,:RD-REV-CUST-COUNT-CD                              
                    ,:RD-DEFERRED-COG-FL                                
                    ,:RD-CODE-SERVICE-TYPE                              
A04177              ,:RD-RATE-DEFINITION-CD                             
               FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                    
              WHERE CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                
                AND RATE_PLAN_NO    = :WS-TEMP-RATE-PLAN-NO             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_DESC                                                  
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,SECURED_RATE_FL                                            
MFA-TR*             ,SUM_REVENUE_FL                                             
MFA-TR*             ,UNMTR_PROV_FL                                              
MFA-TR*             ,REG_GROUP_CD                                               
MFA-TR*             ,BILL_LITERAL_TX                                            
MFA-TR*             ,MKT_PROGRAM_CD                                             
MFA-TR*             ,RATE_CALC_TYPE_CD                                          
MFA-TR*             ,SENIOR_RATE_FL                                             
MFA-TR*             ,RATE_DEPT_CD                                               
MFA-TR*             ,REV_CUST_COUNT_CD                                          
MFA-TR*             ,DEFERRED_COG_FL                                            
MFA-TR*             ,CODE_SERVICE_TYPE                                          
MFA-TR*             ,RATE_DEFINITION_CD                                         
MFA-TR*         INTO :RD-RATE-DESC                                              
MFA-TR*             ,:RD-COMPANY-NO                                             
MFA-TR*             ,:RD-SECURED-RATE-FL                                        
MFA-TR*             ,:RD-SUM-REVENUE-FL                                         
MFA-TR*             ,:RD-UNMTR-PROV-FL                                          
MFA-TR*             ,:RD-REG-GROUP-CD                                           
MFA-TR*             ,:RD-BILL-LITERAL-TX                                        
MFA-TR*             ,:RD-MKT-PROGRAM-CD                                         
MFA-TR*             ,:RD-RATE-CALC-TYPE-CD                                      
MFA-TR*             ,:RD-SENIOR-RATE-FL                                         
MFA-TR*             ,:RD-RATE-DEPT-CD                                           
MFA-TR*             ,:RD-REV-CUST-COUNT-CD                                      
MFA-TR*             ,:RD-DEFERRED-COG-FL                                        
MFA-TR*             ,:RD-CODE-SERVICE-TYPE                                      
MFA-TR*             ,:RD-RATE-DEFINITION-CD                                     
MFA-TR*        FROM CSS_RATE_PLAN_DESC                                          
MFA-TR*       WHERE CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                        
MFA-TR*         AND RATE_PLAN_NO    = :WS-TEMP-RATE-PLAN-NO                     
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7200                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTDESC-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTDESC-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7201-SELECT-NEW-TBRTDESC-ROW                                  *         
      *     SELECTS CSS_RATE_PLAN_DESC - CHECKS TO SEE IF THE NEW     *         
      *     RATE PLAN ALREADY EXISTS                                  *         
      *****************************************************************         
                                                                        
       7201-SELECT-NEW-TBRTDESC-ROW.                                    
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
                INTO :WS-NEW-RATE-PLAN-EXISTS                           
                FROM CSS_RATE_PLAN_DESC WITH(READUNCOMMITTED)                   
               WHERE CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE               
                 AND RATE_PLAN_NO    = :WS-RATE-PLAN-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-NEW-RATE-PLAN-EXISTS                                   
MFA-TR*         FROM CSS_RATE_PLAN_DESC                                         
MFA-TR*        WHERE CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                       
MFA-TR*          AND RATE_PLAN_NO    = :WS-RATE-PLAN-NO                         
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7201                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTDESC-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTDESC-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7201'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7201-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7210-ACCEPT-CURRENTDATE.                                      *         
      *****************************************************************         
       7210-ACCEPT-CURRENTDATE.                                         
                                                                        
           EXEC SQL                                                     
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-DATE    =  CURRENT DATE                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE '7210'                   TO ACTIVE-PARAGRAPH         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7105'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7220-SELECT-TBRTCRTR-ROW                                      *         
      *****************************************************************         
       7220-SELECT-TBRTCRTR-ROW.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CODE_STATUS                                        
                    ,CAST(SYSDATETIMEOFFSET() AS DATE)                          
      *             ,CURRENT DATE                                               
                    ,USER_ID                                            
                    ,BILL_FORMAT_CD                                     
                    ,SEASONAL_DEP_IND                                   
                    ,BASE_LOAD_THERMS                                   
                    ,HEAT_SENSITIVE_FAC                                 
                    ,VERS_PRORATE_CD                                    
                    ,SEASNAL_BLK_CHG_CD                                 
               INTO  :RT-CODE-STATUS                                    
                    ,:RT-DATE-CREATED :WS-RT-DATE-CREATED-NULL           
      *             ,:RT-FROM-EFFECTIVE-DT:WS-RT-FROM-EFF-DT-NULL               
                    ,:RT-USER-ID                                        
                    ,:RT-BILL-FORMAT-CD                                 
                    ,:RT-SEASONAL-DEP-IND :WS-SEASONAL-DEP-IND-NULL      
                    ,:RT-BASE-LOAD-THERMS                               
                    ,:RT-HEAT-SENSITIVE-FAC                             
                    ,:RT-VERS-PRORATE-CD                                
                    ,:RT-SEASNAL-BLK-CHG-CD :WS-SEASNAL-BLK-CHG-CD-NULL  
               FROM  CSS_RATE_CREATOR WITH(READUNCOMMITTED)                     
              WHERE  CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE             
                AND  RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO          
                AND  VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CODE_STATUS                                                
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*             ,CURRENT DATE                                               
MFA-TR*             ,USER_ID                                                    
MFA-TR*             ,BILL_FORMAT_CD                                             
MFA-TR*             ,SEASONAL_DEP_IND                                           
MFA-TR*             ,BASE_LOAD_THERMS                                           
MFA-TR*             ,HEAT_SENSITIVE_FAC                                         
MFA-TR*             ,VERS_PRORATE_CD                                            
MFA-TR*             ,SEASNAL_BLK_CHG_CD                                         
MFA-TR*        INTO  :RT-CODE-STATUS                                            
MFA-TR*             ,:RT-DATE-CREATED:WS-RT-DATE-CREATED-NULL                   
MFA-TR*             ,:RT-FROM-EFFECTIVE-DT:WS-RT-FROM-EFF-DT-NULL               
MFA-TR*             ,:RT-USER-ID                                                
MFA-TR*             ,:RT-BILL-FORMAT-CD                                         
MFA-TR*             ,:RT-SEASONAL-DEP-IND:WS-SEASONAL-DEP-IND-NULL              
MFA-TR*             ,:RT-BASE-LOAD-THERMS                                       
MFA-TR*             ,:RT-HEAT-SENSITIVE-FAC                                     
MFA-TR*             ,:RT-VERS-PRORATE-CD                                        
MFA-TR*             ,:RT-SEASNAL-BLK-CHG-CD:WS-SEASNAL-BLK-CHG-CD-NULL          
MFA-TR*        FROM  CSS_RATE_CREATOR                                           
MFA-TR*       WHERE  CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                     
MFA-TR*         AND  RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                  
MFA-TR*         AND  VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL              
MFA-TR*        WITH UR                                                          
MFA-TR*    QUERYNO 7220                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTCRTR-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTCRTR-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7221-SELECT-MAX-VERS-NO                                       *         
      *****************************************************************         
       7221-SELECT-MAX-VERS-NO.                                         
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VERSION_NO_CNTRL)                              
                INTO :WS-MAX-VERSION-NO-CNTRL :WS-MAX-VERS-NO-CNTRL-NULL 
                FROM CSS_RATE_CREATOR WITH(READUNCOMMITTED)                     
               WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE             
                 AND RATE_PLAN_NO      = :WS-RATE-PLAN-NO               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(VERSION_NO_CNTRL)                                      
MFA-TR*         INTO :WS-MAX-VERSION-NO-CNTRL:WS-MAX-VERS-NO-CNTRL-NULL         
MFA-TR*         FROM CSS_RATE_CREATOR                                           
MFA-TR*        WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                     
MFA-TR*          AND RATE_PLAN_NO      = :WS-RATE-PLAN-NO                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7221                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTCRTR-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTCRTR-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7221'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7221-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7240-SELECT-TBRTVRSN-ROW                                    *           
      *****************************************************************         
       7240-SELECT-TBRTVRSN-ROW.                                        
                                                                        
           EXEC SQL                                                     
              SELECT AMT_CUST_CHRG                                      
                    ,LIM_PRO_RATE_CC                                    
                    ,SEAS_PRORATE_CD                                    
                INTO :J4-AMT-CUST-CHRG                                  
                    ,:J4-LIM-PRO-RATE-CC                                
                    ,:J4-SEAS-PRORATE-CD                                
                FROM CSS_RATE_VRSN_DEF WITH(READUNCOMMITTED)                    
               WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE             
                 AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO          
                 AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_CUST_CHRG                                              
MFA-TR*             ,LIM_PRO_RATE_CC                                            
MFA-TR*             ,SEAS_PRORATE_CD                                            
MFA-TR*         INTO :J4-AMT-CUST-CHRG                                          
MFA-TR*             ,:J4-LIM-PRO-RATE-CC                                        
MFA-TR*             ,:J4-SEAS-PRORATE-CD                                        
MFA-TR*         FROM CSS_RATE_VRSN_DEF                                          
MFA-TR*        WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                     
MFA-TR*          AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                  
MFA-TR*          AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTVRSN-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTVRSN-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7240'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_VRSN_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7250-OPEN-TBUMPLAN-CURSOR                                      *        
      ******************************************************************        
       7250-OPEN-TBUMPLAN-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN TBUMPLAN_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBUMPLAN-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBUMPLAN-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7260-FETCH-TBUMPLAN-CURSOR                                     *        
      ******************************************************************        
       7260-FETCH-TBUMPLAN-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  TBUMPLAN_CURSOR                                    
               INTO :UP-RATE-ITEM-CODE                                  
                   ,:UP-UM-EQUIP-ID                                     
                   ,:UP-CUST-PER-SERVICE                                
                   ,:UP-PRICE-PER-SERV                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBUMPLAN-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBUMPLAN-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7260'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7270-CLOSE-TBUMPLAN-CURSOR                                     *        
      ******************************************************************        
       7270-CLOSE-TBUMPLAN-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE  TBUMPLAN_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBUMPLAN-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBUMPLAN-RETURN-CODE         = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7270'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-OPEN-TBDEMRCH-CURSOR                                      *        
      ******************************************************************        
       7300-OPEN-TBDEMRCH-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN TBDEMRCH_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBDEMRCH-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBDEMRCH-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_DEMAND_RATCHET'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7310-FETCH-TBDEMRCH-CURSOR                                     *        
      ******************************************************************        
       7310-FETCH-TBDEMRCH-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  TBDEMRCH_CURSOR                                    
              INTO  :J2-RATCHET-ID,                                     
                    :J2-FROM-MONTH,                                     
                    :J2-TO-MONTH,                                       
                    :J2-RATCHET-PCT,                                    
                    :J2-RATCHET-YR-IND                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBDEMRCH-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBDEMRCH-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7310'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_DEMAND_RATCHET'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7320-CLOSE-TBDEMRCH-CURSOR                                     *        
      ******************************************************************        
       7320-CLOSE-TBDEMRCH-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE  TBDEMRCH_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBDEMRCH-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBDEMRCH-RETURN-CODE         = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_DEMAND_RATCHET'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-OPEN-TBRTDISC-CURSOR                                      *        
      ******************************************************************        
       7400-OPEN-TBRTDISC-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN TBRTDISC_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTDISC-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTDISC-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_DISCOUNT'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7410-FETCH-TBRTDISC-CURSOR                                     *        
      ******************************************************************        
       7410-FETCH-TBRTDISC-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  TBRTDISC_CURSOR                                    
              INTO  :J5-RATE-DISC-CD,                                   
                    :J5-RATE-DISC-OPT,                                  
                    :J5-DISC-RATE-AMT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTDISC-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTDISC-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7410'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_DISCOUNT'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7420-CLOSE-TBRTDISC-CURSOR                                     *        
      ******************************************************************        
       7420-CLOSE-TBRTDISC-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE  TBRTDISC_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTDISC-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTDISC-RETURN-CODE = SUCCESSFUL-CALL                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7420'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_DISCOUNT'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-OPEN-TBRTUSES-CURSOR                                      *        
      ******************************************************************        
       7500-OPEN-TBRTUSES-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN TBRTUSES_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTUSES-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTUSES-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_USE_SEASN'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7510-FETCH-TBRTUSES-CURSOR                                     *        
      ******************************************************************        
       7510-FETCH-TBRTUSES-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  TBRTUSES_CURSOR                                    
              INTO  :RS-CODE-USE-INST-TYPE,                             
                    :RS-DATE-FROM :WS-RS-DATE-FROM-NULL,                 
                    :RS-CODE-SEASON,                                    
                    :RS-DATE-TO :WS-RS-DATE-TO-NULL                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTUSES-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTUSES-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7510'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_USE_SEASN'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7520-CLOSE-TBRTUSES-CURSOR                                     *        
      ******************************************************************        
                                                                        
       7520-CLOSE-TBRTUSES-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE  TBRTUSES_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTUSES-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTUSES-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7520'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_USE_SEASN'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7650-SELECT-TBDMDINS-ROW                                      *         
      *****************************************************************         
       7650-SELECT-TBDMDINS-ROW.                                        
                                                                        
           EXEC SQL                                                     
              SELECT DMD_YLD_PR_RTE_LMT                                 
                    ,MIN_DMD_CHRG                                       
                    ,MIN_DMD_QTY                                        
                    ,PWR_FCTR_MIN_PCT                                   
                    ,LFTM_PEAK_PCT                                      
                    ,LD_FCTR_MIN_PCT                                    
                INTO :DI-DMD-YLD-PR-RTE-LMT                             
                    ,:DI-MIN-DMD-CHRG                                   
                    ,:DI-MIN-DMD-QTY                                    
                    ,:DI-PWR-FCTR-MIN-PCT                               
                    ,:DI-LFTM-PEAK-PCT                                  
                    ,:DI-LD-FCTR-MIN-PCT                                
                FROM CSS_DEMAND_INSTR WITH(READUNCOMMITTED)                     
               WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE             
                 AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO          
                 AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL      
                 AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DMD_YLD_PR_RTE_LMT                                         
MFA-TR*             ,MIN_DMD_CHRG                                               
MFA-TR*             ,MIN_DMD_QTY                                                
MFA-TR*             ,PWR_FCTR_MIN_PCT                                           
MFA-TR*             ,LFTM_PEAK_PCT                                              
MFA-TR*             ,LD_FCTR_MIN_PCT                                            
MFA-TR*         INTO :DI-DMD-YLD-PR-RTE-LMT                                     
MFA-TR*             ,:DI-MIN-DMD-CHRG                                           
MFA-TR*             ,:DI-MIN-DMD-QTY                                            
MFA-TR*             ,:DI-PWR-FCTR-MIN-PCT                                       
MFA-TR*             ,:DI-LFTM-PEAK-PCT                                          
MFA-TR*             ,:DI-LD-FCTR-MIN-PCT                                        
MFA-TR*         FROM CSS_DEMAND_INSTR                                           
MFA-TR*        WHERE CODE_UTIL_TYPE    = :WS-CODE-UTIL-TYPE                     
MFA-TR*          AND RATE_PLAN_NO      = :WS-TEMP-RATE-PLAN-NO                  
MFA-TR*          AND VERSION_NO_CNTRL  = :WS-TEMP-VERSION-NO-CNTRL              
MFA-TR*          AND CMPNT_ID_CD       = :WS-CMPNT-ID-CD                        
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7650                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBDMDINS-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBDMDINS-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7650'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DEMAND_INSTR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7700-OPEN-TBRTCDEF-CURSOR                                      *        
      ******************************************************************        
                                                                        
       7700-OPEN-TBRTCDEF-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN TBRTCDEF_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTCDEF-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTCDEF-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7710-FETCH-TBRTCDEF-CURSOR                                     *        
      ******************************************************************        
       7710-FETCH-TBRTCDEF-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  TBRTCDEF_CURSOR                                    
              INTO  :J1-CMPNT-ID-CD                                     
                   ,:J1-REG-TYPE-CD                                     
                   ,:J1-ENERGY-UNIT-CD                                  
                   ,:J1-ENERGY-SEAS-CD                                  
                   ,:J1-LAST-ENERGY-BLOCK                               
                   ,:J1-LAST-DEM-BLOCK                                  
                   ,:J1-DEM-REG-TYPE-CD                                 
                   ,:J1-DEM-UNIT-CD                                     
                   ,:J1-DEM-SEASON-CD                                   
                   ,:J1-ON-PEAK-DAYS                                    
                   ,:J1-CALENDAR-CD                                     
                   ,:J1-RTP-BASELINE-RATE                               
                   ,:J1-BAL-FWD-CD                                      
                   ,:J1-BAL-RESET-MMDD                                  
                   ,:J1-BAL-RESET-PRO-CD                                
                   ,:J1-BAL-OFFSET-TOU-CD                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTCDEF-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTCDEF-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7710'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7720-CLOSE-TBRTCDEF-CURSOR                                     *        
      ******************************************************************        
       7720-CLOSE-TBRTCDEF-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE  TBRTCDEF_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTCDEF-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTCDEF-RETURN-CODE  = SUCCESSFUL-CALL                
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7720'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7800-OPEN-TBPRCSCH-CURSOR                                      *        
      ******************************************************************        
       7800-OPEN-TBPRCSCH-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN TBPRCSCH_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBPRCSCH-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBPRCSCH-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7810-FETCH-TBPRCSCH-CURSOR                                     *        
      ******************************************************************        
       7810-FETCH-TBPRCSCH-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  TBPRCSCH_CURSOR                                    
              INTO  :PS-CODE-SEASON                                     
                   ,:PS-CODE-TIME-PERIOD                                
                   ,:PS-CODE-USE-INST-TYPE                              
                   ,:PS-BLOCK-NO                                        
                   ,:PS-BLOCK-USE-OR-SVCS                               
                   ,:PS-BLOCK-DESC                                      
                   ,:PS-SCHED-PRICE-AM                                  
                   ,:PS-PRICE-TYPE-CD                                   
                   ,:PS-LAST-PRICE-DAY-MTH                              
                   ,:PS-BEGN-PRICE-DAY-MTH                              
                   ,:PS-ITEM-ID                                         
                   ,:PS-DATE-PRICE-END                                  
                   ,:PS-DAYS-PRICE-APPLIES                              
                   ,:PS-SCHED-WNA-RATE-AMT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBPRCSCH-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBPRCSCH-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7810'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7820-CLOSE-TBPRCSCH-CURSOR                                     *        
      ******************************************************************        
       7820-CLOSE-TBPRCSCH-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE  TBPRCSCH_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBPRCSCH-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBPRCSCH-RETURN-CODE         =  SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7820'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7900-OPEN-TBRTPDET-CURSOR                                      *        
      ******************************************************************        
       7900-OPEN-TBRTPDET-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN TBRTPDET_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTPDET-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTPDET-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7900'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE 'CSS_RTP_DETAIL'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7910-FETCH-TBRTPDET-CURSOR                                     *        
      ******************************************************************        
       7910-FETCH-TBRTPDET-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  TBRTPDET_CURSOR                                    
               INTO :J3-CODE-USE-INST-TYPE                              
                   ,:J3-RTP-PRICE-AMT                                   
                   ,:J3-PRICE-APPLIES-DT                                
                   ,:J3-PRICE-APPLIES-HR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTPDET-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTPDET-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7910'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RTP_DETAIL'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7920-CLOSE-TBRTPDET-CURSOR                                     *        
      ******************************************************************        
       7920-CLOSE-TBRTPDET-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE TBRTPDET_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTPDET-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTPDET-RETURN-CODE         =  SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7920'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RTP_DETAIL'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7930-OPEN-TBRTTOUD-CURSOR                                      *        
      ******************************************************************        
       7930-OPEN-TBRTTOUD-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN TBRTTOUD_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTTOUD-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTTOUD-RETURN-CODE         =  SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7930'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7940-FETCH-TBRTTOUD-CURSOR                                     *        
      ******************************************************************        
       7940-FETCH-TBRTTOUD-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH  TBRTTOUD_CURSOR                                    
              INTO  :RJ-CODE-UTIL-TYPE                                  
                   ,:RJ-RATE-PLAN-NO                                    
                   ,:RJ-VERSION-NO-CNTRL                                
                   ,:RJ-CMPNT-ID-CD                                     
                   ,:RJ-CODE-TIME-PERIOD                                
                   ,:RJ-TOU-TO-HOUR                                     
                   ,:RJ-TOU-FROM-HOUR                                   
                   ,:RJ-TOU-TO-MMDD                                     
                   ,:RJ-TOU-FROM-MMDD                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTTOUD-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTTOUD-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7940'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               **        
      * 7950-CLOSE-TBRTTOUD-CURSOR                                     *        
      ******************************************************************        
       7950-CLOSE-TBRTTOUD-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE  TBRTTOUD_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTTOUD-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTTOUD-RETURN-CODE         =  SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7950'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               **        
      * 7960-SELECT-RT-HIGH-LOW.                                    *           
      ******************************************************************        
       7960-SELECT-RT-HIGH-LOW.                                         
                                                                        
           EXEC SQL                                                     
                SELECT CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,PREVIOUS_MONTH1                                  
                      ,PREVIOUS_MONTH2                                  
                      ,PREVIOUS_MONTH3                                  
                      ,PREVIOUS_MONTH4                                  
                      ,USAGE_HIGH_PCT                                   
                      ,USAGE_LOW_PCT                                    
                      ,DEMAND_HIGH_PCT                                  
                      ,DEMAND_LOW_PCT                                   
                      ,INIT_BILL_MIN_KVA                                
                      ,INIT_BILL_MAX_KVA                                
                      ,INIT_BILL_MIN_KW                                 
                      ,INIT_BILL_MAX_KW                                 
                      ,INIT_BILL_MIN_KWH                                
                      ,INIT_BILL_MAX_KWH                                
                      ,MIN_POWER_FACTOR                                 
                      ,MAX_POWER_FACTOR                                 
                      ,MIN_LOAD_FACTOR                                  
                      ,MAX_LOAD_FACTOR                                  
                      ,NO_CNSMPTN_YR_HIST                               
                      ,MKT_DEMAND_LOW_PCT                               
                      ,MKT_DEMAND_HI_PCT                                
                      ,MKT_USAGE_LOW_PCT                                
                      ,MKT_USAGE_HIGH_PCT                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                      ,LAST_UPDATE_USERID                               
                  INTO :O9-CODE-UTIL-TYPE                               
                      ,:O9-RATE-PLAN-NO                                 
                      ,:O9-PREVIOUS-MONTH1                              
                      ,:O9-PREVIOUS-MONTH2                              
                      ,:O9-PREVIOUS-MONTH3                              
                      ,:O9-PREVIOUS-MONTH4                              
                      ,:O9-USAGE-HIGH-PCT                               
                      ,:O9-USAGE-LOW-PCT                                
                      ,:O9-DEMAND-HIGH-PCT                              
                      ,:O9-DEMAND-LOW-PCT                               
                      ,:O9-INIT-BILL-MIN-KVA                            
                      ,:O9-INIT-BILL-MAX-KVA                            
                      ,:O9-INIT-BILL-MIN-KW                             
                      ,:O9-INIT-BILL-MAX-KW                             
                      ,:O9-INIT-BILL-MIN-KWH                            
                      ,:O9-INIT-BILL-MAX-KWH                            
                      ,:O9-MIN-POWER-FACTOR                             
                      ,:O9-MAX-POWER-FACTOR                             
                      ,:O9-MIN-LOAD-FACTOR                              
                      ,:O9-MAX-LOAD-FACTOR                              
                      ,:O9-NO-CNSMPTN-YR-HIST                           
                      ,:O9-MKT-DEMAND-LOW-PCT                           
                      ,:O9-MKT-DEMAND-HI-PCT                            
                      ,:O9-MKT-USAGE-LOW-PCT                            
                      ,:O9-MKT-USAGE-HIGH-PCT                           
                      ,:O9-LAST-UPDATE-TS                               
                      ,:O9-LAST-UPDATE-USERID                           
                 FROM CSS_RATE_HIGH_LOW O9 WITH(READUNCOMMITTED)                
                WHERE CODE_UTIL_TYPE = :O9-CODE-UTIL-TYPE               
                  AND RATE_PLAN_NO   = :O9-RATE-PLAN-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,PREVIOUS_MONTH1                                          
MFA-TR*               ,PREVIOUS_MONTH2                                          
MFA-TR*               ,PREVIOUS_MONTH3                                          
MFA-TR*               ,PREVIOUS_MONTH4                                          
MFA-TR*               ,USAGE_HIGH_PCT                                           
MFA-TR*               ,USAGE_LOW_PCT                                            
MFA-TR*               ,DEMAND_HIGH_PCT                                          
MFA-TR*               ,DEMAND_LOW_PCT                                           
MFA-TR*               ,INIT_BILL_MIN_KVA                                        
MFA-TR*               ,INIT_BILL_MAX_KVA                                        
MFA-TR*               ,INIT_BILL_MIN_KW                                         
MFA-TR*               ,INIT_BILL_MAX_KW                                         
MFA-TR*               ,INIT_BILL_MIN_KWH                                        
MFA-TR*               ,INIT_BILL_MAX_KWH                                        
MFA-TR*               ,MIN_POWER_FACTOR                                         
MFA-TR*               ,MAX_POWER_FACTOR                                         
MFA-TR*               ,MIN_LOAD_FACTOR                                          
MFA-TR*               ,MAX_LOAD_FACTOR                                          
MFA-TR*               ,NO_CNSMPTN_YR_HIST                                       
MFA-TR*               ,MKT_DEMAND_LOW_PCT                                       
MFA-TR*               ,MKT_DEMAND_HI_PCT                                        
MFA-TR*               ,MKT_USAGE_LOW_PCT                                        
MFA-TR*               ,MKT_USAGE_HIGH_PCT                                       
MFA-TR*               ,LAST_UPDATE_TS                                           
MFA-TR*               ,LAST_UPDATE_USERID                                       
MFA-TR*           INTO :O9-CODE-UTIL-TYPE                                       
MFA-TR*               ,:O9-RATE-PLAN-NO                                         
MFA-TR*               ,:O9-PREVIOUS-MONTH1                                      
MFA-TR*               ,:O9-PREVIOUS-MONTH2                                      
MFA-TR*               ,:O9-PREVIOUS-MONTH3                                      
MFA-TR*               ,:O9-PREVIOUS-MONTH4                                      
MFA-TR*               ,:O9-USAGE-HIGH-PCT                                       
MFA-TR*               ,:O9-USAGE-LOW-PCT                                        
MFA-TR*               ,:O9-DEMAND-HIGH-PCT                                      
MFA-TR*               ,:O9-DEMAND-LOW-PCT                                       
MFA-TR*               ,:O9-INIT-BILL-MIN-KVA                                    
MFA-TR*               ,:O9-INIT-BILL-MAX-KVA                                    
MFA-TR*               ,:O9-INIT-BILL-MIN-KW                                     
MFA-TR*               ,:O9-INIT-BILL-MAX-KW                                     
MFA-TR*               ,:O9-INIT-BILL-MIN-KWH                                    
MFA-TR*               ,:O9-INIT-BILL-MAX-KWH                                    
MFA-TR*               ,:O9-MIN-POWER-FACTOR                                     
MFA-TR*               ,:O9-MAX-POWER-FACTOR                                     
MFA-TR*               ,:O9-MIN-LOAD-FACTOR                                      
MFA-TR*               ,:O9-MAX-LOAD-FACTOR                                      
MFA-TR*               ,:O9-NO-CNSMPTN-YR-HIST                                   
MFA-TR*               ,:O9-MKT-DEMAND-LOW-PCT                                   
MFA-TR*               ,:O9-MKT-DEMAND-HI-PCT                                    
MFA-TR*               ,:O9-MKT-USAGE-LOW-PCT                                    
MFA-TR*               ,:O9-MKT-USAGE-HIGH-PCT                                   
MFA-TR*               ,:O9-LAST-UPDATE-TS                                       
MFA-TR*               ,:O9-LAST-UPDATE-USERID                                   
MFA-TR*          FROM CSS_RATE_HIGH_LOW O9                                      
MFA-TR*         WHERE CODE_UTIL_TYPE = :O9-CODE-UTIL-TYPE                       
MFA-TR*           AND RATE_PLAN_NO   = :O9-RATE-PLAN-NO                         
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7960                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7960'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_HIGH_LOW'       TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE O9-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE O9-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7960-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 7970-SELECT-DTM-PGM-ID.                                       *         
      *****************************************************************         
        7970-SELECT-DTM-PGM-ID.                                         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXISTS                                   
                  FROM CSS_DMT_PGM_ID T2 WITH(READUNCOMMITTED)                  
                 WHERE T2.CODE_UTIL_TYPE  = :T2-CODE-UTIL-TYPE          
                   AND T2.RATE_PLAN_NO    = :T2-RATE-PLAN-NO            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXISTS                                           
MFA-TR*           FROM CSS_DMT_PGM_ID T2                                        
MFA-TR*          WHERE T2.CODE_UTIL_TYPE  = :T2-CODE-UTIL-TYPE                  
MFA-TR*            AND T2.RATE_PLAN_NO    = :T2-RATE-PLAN-NO                    
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7970                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7970'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DTM_PGM_ID'          TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE T2-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE T2-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
        7970-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7980-SELECT-BTU-WNA-RNG.                                      *         
      *****************************************************************         
        7980-SELECT-BTU-WNA-RNG.                                        
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXISTS                                   
                  FROM CSS_BTU_WNA_RANGE BR WITH(READUNCOMMITTED)               
                 WHERE BR.CODE_UTIL_TYPE  = :BR-CODE-UTIL-TYPE          
                   AND BR.RATE_PLAN_NO    = :BR-RATE-PLAN-NO            
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXISTS                                           
MFA-TR*           FROM CSS_BTU_WNA_RANGE BR                                     
MFA-TR*          WHERE BR.CODE_UTIL_TYPE  = :BR-CODE-UTIL-TYPE                  
MFA-TR*            AND BR.RATE_PLAN_NO    = :BR-RATE-PLAN-NO                    
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7980                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7980'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_WNA_RANGE'       TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE BR-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE BR-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7980-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 7990-SELECT-REV-CLS.                                                    
      *****************************************************************         
       7990-SELECT-REV-CLS.                                             
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXISTS                                   
                  FROM CSS_REV_CLS_RATE Q8 WITH(READUNCOMMITTED)                
                 WHERE Q8.CODE_UTIL_TYPE = :Q8-CODE-UTIL-TYPE           
                   AND Q8.RATE_PLAN_NO   = :Q8-RATE-PLAN-NO             
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXISTS                                           
MFA-TR*           FROM CSS_REV_CLS_RATE Q8                                      
MFA-TR*          WHERE Q8.CODE_UTIL_TYPE = :Q8-CODE-UTIL-TYPE                   
MFA-TR*            AND Q8.RATE_PLAN_NO   = :Q8-RATE-PLAN-NO                     
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7990                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7990'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_REV_CLS_RATE'        TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE Q8-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE Q8-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7990-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 7995-SELECT-SPCL-FCT-APPL.                                              
      *****************************************************************         
       7995-SELECT-SPCL-FCT-APPL.                                       
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) 'Y'                                              
                  INTO :WS-ROW-EXISTS                                   
                   FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)             
                  WHERE SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE          
                    AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO            
                    AND SA.CODE_STATUS    = 'A'                         
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ROW-EXISTS                                           
MFA-TR*            FROM CSS_SPCL_FCTR_APPL SA                                   
MFA-TR*           WHERE SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                  
MFA-TR*             AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                    
MFA-TR*             AND SA.CODE_STATUS    = 'A'                                 
MFA-TR*           FETCH FIRST ROW ONLY                                          
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7995                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7995'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE SA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7995-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 7996-SELECT-SPCL-FCTR.                                                  
      *****************************************************************         
       7996-SELECT-SPCL-FCTR.                                           
                                                                        
           EXEC SQL                                                     
                SELECT SF.VERS_PRORATE_CD                               
                  INTO :SF-VERS-PRORATE-CD                              
                  FROM CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                   
                 WHERE SF.FACTOR_ID = :SF-FACTOR-ID                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT SF.VERS_PRORATE_CD                                       
MFA-TR*           INTO :SF-VERS-PRORATE-CD                                      
MFA-TR*           FROM CSS_SPCL_FCTR SF                                         
MFA-TR*          WHERE SF.FACTOR_ID = :SF-FACTOR-ID                             
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7996                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7996'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR'           TO TABLE-1                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE SF-FACTOR-ID              TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7996-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 7997-SELECT-PREV-DAY.                                                   
      *****************************************************************         
       7997-SELECT-PREV-DAY.                                            
                                                                        
           EXEC SQL                                                     
                SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE-TO
              ) <> 0) OR (LEN(:WS-HOLD-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                       :WS-HOLD-DATE-TO
              ), CONVERT(DATE, :WS-HOLD-DATE-TO) ) )
            INTO
              :WS-HOLD-PREV-DT  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-HOLD-PREV-DT = DATE(:WS-HOLD-DATE-TO) - 1 DAYS          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7997'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE 'HOLD DATE'               TO TABLE-ELEMENT-1         
              MOVE WS-HOLD-DATE-TO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7997-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 7998-SEL-ENTRY-NO.                                                      
      *****************************************************************         
       7998-SEL-ENTRY-NO.                                               
                                                                        
           EXEC SQL                                                     
                SELECT MAX(SA.ENTRY_NO)                                 
                  INTO :SA-ENTRY-NO :WS-MAX-ENTRY-NO-NULL               
                  FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)              
                 WHERE SA.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE           
                   AND SA.RATE_PLAN_NO   = :WS-RATE-PLAN-NO             
                   AND SA.FACTOR_ID      = :SA-FACTOR-ID                
                   AND SA.DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )                
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MAX(SA.ENTRY_NO)                                         
MFA-TR*           INTO :SA-ENTRY-NO :WS-MAX-ENTRY-NO-NULL                       
MFA-TR*           FROM CSS_SPCL_FCTR_APPL SA                                    
MFA-TR*          WHERE SA.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                   
MFA-TR*            AND SA.RATE_PLAN_NO   = :WS-RATE-PLAN-NO                     
MFA-TR*            AND SA.FACTOR_ID      = :SA-FACTOR-ID                        
MFA-TR*            AND SA.DATE_FROM      = :SA-DATE-FROM                        
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7998                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7998'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-3         
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-3       
              MOVE SA-DATE-FROM              TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7998-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000-OPEN-TBRTTOU-CURSOR                                       *        
      ******************************************************************        
       8000-OPEN-TBRTTOU-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN TBRTTOU_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTTOU-RETURN-CODE 
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTTOU-RETURN-CODE           = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_INSTR'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8010-FETCH-TBRTTOU-CURSOR                                      *        
      ******************************************************************        
       8010-FETCH-TBRTTOU-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH  TBRTTOU_CURSOR                                     
               INTO :RK-CODE-UTIL-TYPE                                  
                   ,:RK-RATE-PLAN-NO                                    
                   ,:RK-VERSION-NO-CNTRL                                
                   ,:RK-CMPNT-ID-CD                                     
                   ,:RK-CODE-TIME-PERIOD                                
                   ,:RK-RATE-MIN-IND                                    
                   ,:RK-CNTRCT-MIN-IND                                  
                   ,:RK-MAX-DEMAND-IND                                  
                   ,:RK-RATCHET-ID-1                                    
                   ,:RK-RATCHET-ID-2                                    
                   ,:RK-RATCHET-ID-3                                    
                   ,:RK-MRG-OFF-PK-IND                                  
                   ,:RK-MRG-CTR-MIN-IND                                 
                   ,:RK-MRG-RT-MIN                                      
                   ,:RK-CODE-SEASON                                     
                   ,:RK-CNTRCT-MIN-PCT                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTTOU-RETURN-CODE 
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTTOU-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_INSTR'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-CLOSE-TBRTTOU-CURSOR                                      *        
      ******************************************************************        
       8020-CLOSE-TBRTTOU-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE  TBRTTOU_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTTOU-RETURN-CODE 
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTTOU-RETURN-CODE           = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8020'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_INSTR'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8030-OPEN-TBRTRDR-CURSOR                                                
      ******************************************************************        
       8030-OPEN-TBRTRDR-CURSOR.                                        
                                                                        
           EXEC SQL                                                     
              OPEN TBRTRDR_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTRDR-RETURN-CODE 
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTRDR-RETURN-CODE           = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8030'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN '                    TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_RIDER_EXP'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8040-FETCH-TBRTRDR-CURSOR.                                    *         
      *****************************************************************         
       8040-FETCH-TBRTRDR-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH  TBRTRDR_CURSOR                                     
               INTO :RZ-CODE-UTIL-TYPE                                  
                   ,:RZ-VERSION-NO-CNTRL                                
                   ,:RZ-RATE-PLAN-NO                                    
                   ,:RZ-TO-HHMM                                         
                   ,:RZ-FROM-HHMM                                       
                   ,:RZ-TO-MONTH                                        
                   ,:RZ-FROM-MONTH                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTRDR-RETURN-CODE 
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTRDR-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8040'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_RIDER_EXP'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8050-CLOSE-TBRTRDR-CURSOR                                               
      ******************************************************************        
       8050-CLOSE-TBRTRDR-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE  TBRTRDR_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTRDR-RETURN-CODE 
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTRDR-RETURN-CODE           = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8050'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_RIDER_EXP'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-TEMP-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-2      
              MOVE WS-TEMP-VERSION-NO-CNTRL   TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8200-INSERT-NEW-TBRTDESC-ROW                                  *         
      *****************************************************************         
       8200-INSERT-NEW-TBRTDESC-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_PLAN_DESC                            
              (                                                         
                 CODE_UTIL_TYPE                                         
                ,COMPANY_NO                                             
                ,SECURED_RATE_FL                                        
                ,SUM_REVENUE_FL                                         
                ,RATE_PLAN_NO                                           
                ,RATE_DESC                                              
                ,BILL_LITERAL_TX                                        
                ,MKT_PROGRAM_CD                                         
                ,RATE_CALC_TYPE_CD                                      
                ,UNMTR_PROV_FL                                          
                ,REG_GROUP_CD                                           
                ,DEFERRED_COG_FL                                        
                ,RATE_DEPT_CD                                           
                ,REV_CUST_COUNT_CD                                      
                ,SENIOR_RATE_FL                                         
                ,LAST_UPDATE_TS                                         
                ,LAST_UPDATE_USERID                                     
                ,CODE_SERVICE_TYPE                                      
A04177          ,RATE_DEFINITION_CD                                     
              )                                                         
              VALUES                                                    
              (                                                         
                 :WS-CODE-UTIL-TYPE                                     
                ,:WS-COMPANY-NO                                         
                ,:RD-SECURED-RATE-FL                                    
                ,:RD-SUM-REVENUE-FL                                     
                ,:WS-RATE-PLAN-NO                                       
                ,:WS-RATE-DESCRIPTION                                   
                ,:RD-BILL-LITERAL-TX                                    
                ,:RD-MKT-PROGRAM-CD                                     
                ,:RD-RATE-CALC-TYPE-CD                                  
                ,:RD-UNMTR-PROV-FL                                      
                ,:RD-REG-GROUP-CD                                       
                ,:RD-DEFERRED-COG-FL                                    
                ,:RD-RATE-DEPT-CD                                       
                ,:RD-REV-CUST-COUNT-CD                                  
                ,:RD-SENIOR-RATE-FL                                     
                , CIS.CURRENT$TIMESTAMP()                                     
                ,:WS-USER-ID                                            
                ,:RD-CODE-SERVICE-TYPE                                  
A04177          ,:RD-RATE-DEFINITION-CD                                 
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_RATE_PLAN_DESC                                    
MFA-TR*       (                                                                 
MFA-TR*          CODE_UTIL_TYPE                                                 
MFA-TR*         ,COMPANY_NO                                                     
MFA-TR*         ,SECURED_RATE_FL                                                
MFA-TR*         ,SUM_REVENUE_FL                                                 
MFA-TR*         ,RATE_PLAN_NO                                                   
MFA-TR*         ,RATE_DESC                                                      
MFA-TR*         ,BILL_LITERAL_TX                                                
MFA-TR*         ,MKT_PROGRAM_CD                                                 
MFA-TR*         ,RATE_CALC_TYPE_CD                                              
MFA-TR*         ,UNMTR_PROV_FL                                                  
MFA-TR*         ,REG_GROUP_CD                                                   
MFA-TR*         ,DEFERRED_COG_FL                                                
MFA-TR*         ,RATE_DEPT_CD                                                   
MFA-TR*         ,REV_CUST_COUNT_CD                                              
MFA-TR*         ,SENIOR_RATE_FL                                                 
MFA-TR*         ,LAST_UPDATE_TS                                                 
MFA-TR*         ,LAST_UPDATE_USERID                                             
MFA-TR*         ,CODE_SERVICE_TYPE                                              
MFA-TR*         ,RATE_DEFINITION_CD                                             
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*          :WS-CODE-UTIL-TYPE                                             
MFA-TR*         ,:WS-COMPANY-NO                                                 
MFA-TR*         ,:RD-SECURED-RATE-FL                                            
MFA-TR*         ,:RD-SUM-REVENUE-FL                                             
MFA-TR*         ,:WS-RATE-PLAN-NO                                               
MFA-TR*         ,:WS-RATE-DESCRIPTION                                           
MFA-TR*         ,:RD-BILL-LITERAL-TX                                            
MFA-TR*         ,:RD-MKT-PROGRAM-CD                                             
MFA-TR*         ,:RD-RATE-CALC-TYPE-CD                                          
MFA-TR*         ,:RD-UNMTR-PROV-FL                                              
MFA-TR*         ,:RD-REG-GROUP-CD                                               
MFA-TR*         ,:RD-DEFERRED-COG-FL                                            
MFA-TR*         ,:RD-RATE-DEPT-CD                                               
MFA-TR*         ,:RD-REV-CUST-COUNT-CD                                          
MFA-TR*         ,:RD-SENIOR-RATE-FL                                             
MFA-TR*         , CURRENT TIMESTAMP                                             
MFA-TR*         ,:WS-USER-ID                                                    
MFA-TR*         ,:RD-CODE-SERVICE-TYPE                                          
MFA-TR*         ,:RD-RATE-DEFINITION-CD                                         
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTDESC-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTDESC-RETURN-CODE         = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN_DESC'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8220-INSERT-NEW-TBRTCRTR-ROW                                  *         
      *****************************************************************         
                                                                        
       8220-INSERT-NEW-TBRTCRTR-ROW.                                    
                                                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_CREATOR                              
              (                                                         
                 CODE_UTIL_TYPE                                         
                ,RATE_PLAN_NO                                           
                ,VERSION_NO_CNTRL                                       
                ,CODE_STATUS                                            
                ,DATE_CREATED                                           
                ,FROM_EFFECTIVE_DT                                      
                ,USER_ID                                                
                ,BILL_FORMAT_CD                                         
                ,SEASONAL_DEP_IND                                       
                ,BASE_LOAD_THERMS                                       
                ,HEAT_SENSITIVE_FAC                                     
                ,VERS_PRORATE_CD                                        
                ,SEASNAL_BLK_CHG_CD                                     
                ,LAST_UPDATE_TS                                         
                ,LAST_UPDATE_USERID                                     
                ,DISPLAY_START_TS                                       
                ,DISPLAY_END_TS                                         
                ,PROC_REQ_ID                                            
              )                                                         
              VALUES                                                    
              (                                                         
                 :WS-CODE-UTIL-TYPE                                     
                ,:WS-RATE-PLAN-NO                                       
                ,:WS-NEW-VERSION-NO-CNTRL                               
                ,:WS-STATUS-IS-TEST                                     
                ,IIF(TRY_CONVERT(DATE, :RT-DATE-CREATED 
                                       :WS-RT-DATE-CREATED-NULL
              ) IS NULL OR (PATINDEX('%.%', :RT-DATE-CREATED 
                                               :WS-RT-DATE-CREATED-NULL
              ) <> 0) OR (LEN(:RT-DATE-CREATED :WS-RT-DATE-CREATED-NULL
              ) <> 10), CIS.CHAR2DATE(:RT-DATE-CREATED 
                                               :WS-RT-DATE-CREATED-NULL
              ), CONVERT(DATE, :RT-DATE-CREATED 
                                               :WS-RT-DATE-CREATED-NULL
              ) )               
                ,IIF(TRY_CONVERT(DATE, :RT-FROM-EFFECTIVE-DT 
                                       :WS-RT-FROM-EFF-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :RT-FROM-EFFECTIVE-DT 
                                                :WS-RT-FROM-EFF-DT-NULL
              ) <> 0) OR (LEN(:RT-FROM-EFFECTIVE-DT 
                                                :WS-RT-FROM-EFF-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:RT-FROM-EFFECTIVE-DT 
                                                :WS-RT-FROM-EFF-DT-NULL
              ), CONVERT(DATE, :RT-FROM-EFFECTIVE-DT 
                                                :WS-RT-FROM-EFF-DT-NULL
              ) )           
                ,:WS-USER-ID                                            
                ,:RT-BILL-FORMAT-CD                                     
                ,:RT-SEASONAL-DEP-IND :WS-SEASONAL-DEP-IND-NULL          
                ,:RT-BASE-LOAD-THERMS                                   
                ,:RT-HEAT-SENSITIVE-FAC                                 
                ,:RT-VERS-PRORATE-CD                                    
                ,:RT-SEASNAL-BLK-CHG-CD :WS-SEASNAL-BLK-CHG-CD-NULL      
                , CIS.CURRENT$TIMESTAMP()                                     
                ,:WS-USER-ID                                            
                ,CIS.CHAR2TIMESTAMP(:RT-DISPLAY-START-TS)                       
                ,CIS.CHAR2TIMESTAMP(:RT-DISPLAY-END-TS)                         
                ,:RT-PROC-REQ-ID                                        
               )                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_RATE_CREATOR                                      
MFA-TR*       (                                                                 
MFA-TR*          CODE_UTIL_TYPE                                                 
MFA-TR*         ,RATE_PLAN_NO                                                   
MFA-TR*         ,VERSION_NO_CNTRL                                               
MFA-TR*         ,CODE_STATUS                                                    
MFA-TR*         ,DATE_CREATED                                                   
MFA-TR*         ,FROM_EFFECTIVE_DT                                              
MFA-TR*         ,USER_ID                                                        
MFA-TR*         ,BILL_FORMAT_CD                                                 
MFA-TR*         ,SEASONAL_DEP_IND                                               
MFA-TR*         ,BASE_LOAD_THERMS                                               
MFA-TR*         ,HEAT_SENSITIVE_FAC                                             
MFA-TR*         ,VERS_PRORATE_CD                                                
MFA-TR*         ,SEASNAL_BLK_CHG_CD                                             
MFA-TR*         ,LAST_UPDATE_TS                                                 
MFA-TR*         ,LAST_UPDATE_USERID                                             
MFA-TR*         ,DISPLAY_START_TS                                               
MFA-TR*         ,DISPLAY_END_TS                                                 
MFA-TR*         ,PROC_REQ_ID                                                    
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*          :WS-CODE-UTIL-TYPE                                             
MFA-TR*         ,:WS-RATE-PLAN-NO                                               
MFA-TR*         ,:WS-NEW-VERSION-NO-CNTRL                                       
MFA-TR*         ,:WS-STATUS-IS-TEST                                             
MFA-TR*         ,:RT-DATE-CREATED:WS-RT-DATE-CREATED-NULL                       
MFA-TR*         ,:RT-FROM-EFFECTIVE-DT:WS-RT-FROM-EFF-DT-NULL                   
MFA-TR*         ,:WS-USER-ID                                                    
MFA-TR*         ,:RT-BILL-FORMAT-CD                                             
MFA-TR*         ,:RT-SEASONAL-DEP-IND:WS-SEASONAL-DEP-IND-NULL                  
MFA-TR*         ,:RT-BASE-LOAD-THERMS                                           
MFA-TR*         ,:RT-HEAT-SENSITIVE-FAC                                         
MFA-TR*         ,:RT-VERS-PRORATE-CD                                            
MFA-TR*         ,:RT-SEASNAL-BLK-CHG-CD:WS-SEASNAL-BLK-CHG-CD-NULL              
MFA-TR*         , CURRENT TIMESTAMP                                             
MFA-TR*         ,:WS-USER-ID                                                    
MFA-TR*         ,:RT-DISPLAY-START-TS                                           
MFA-TR*         ,:RT-DISPLAY-END-TS                                             
MFA-TR*         ,:RT-PROC-REQ-ID                                                
MFA-TR*        )                                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTCRTR-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTCRTR-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8220'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8240-INSERT-NEW-TBRTVRSN-ROW                                  *         
      *****************************************************************         
       8240-INSERT-NEW-TBRTVRSN-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_VRSN_DEF                             
              (                                                         
                 CODE_UTIL_TYPE                                         
                ,RATE_PLAN_NO                                           
                ,VERSION_NO_CNTRL                                       
                ,AMT_CUST_CHRG                                          
                ,LIM_PRO_RATE_CC                                        
                ,SEAS_PRORATE_CD                                        
              )                                                         
              VALUES                                                    
              (                                                         
                 :WS-CODE-UTIL-TYPE                                     
                ,:WS-RATE-PLAN-NO                                       
                ,:WS-NEW-VERSION-NO-CNTRL                               
                ,:J4-AMT-CUST-CHRG                                      
                ,:J4-LIM-PRO-RATE-CC                                    
                ,:J4-SEAS-PRORATE-CD                                    
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTVRSN-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTVRSN-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8240'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_VRSN_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               *         
      * 8250-INSERT-NEW-TBUMPLAN-ROW                                  *         
      *****************************************************************         
       8250-INSERT-NEW-TBUMPLAN-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_UNMTR_PLAN                                
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,RATE_ITEM_CODE                                          
               ,UM_EQUIP_ID                                             
               ,CUST_PER_SERVICE                                        
               ,PRICE_PER_SERV                                          
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:UP-RATE-ITEM-CODE                                      
               ,:UP-UM-EQUIP-ID                                         
               ,:UP-CUST-PER-SERVICE                                    
               ,:UP-PRICE-PER-SERV                                      
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBUMPLAN-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBUMPLAN-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8250'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'RATE_ITEM_CODE'           TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE UP-RATE-ITEM-CODE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               *         
      * 8300-INSERT-NEW-TBDEMRCH-ROW                                  *         
      *****************************************************************         
       8300-INSERT-NEW-TBDEMRCH-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_DEMAND_RATCHET                            
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,RATCHET_ID                                              
               ,FROM_MONTH                                              
               ,TO_MONTH                                                
               ,RATCHET_PCT                                             
               ,RATCHET_YR_IND                                          
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:J2-RATCHET-ID                                          
               ,:J2-FROM-MONTH                                          
               ,:J2-TO-MONTH                                            
               ,:J2-RATCHET-PCT                                         
               ,:J2-RATCHET-YR-IND                                      
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBDEMRCH-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBDEMRCH-RETURN-CODE         = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DEMAND_RATCHET'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'RATCHET_ID'               TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE J2-RATCHET-ID              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               *         
      * 8400-INSERT-NEW-TBRTDISC-ROW                                  *         
      *****************************************************************         
       8400-INSERT-NEW-TBRTDISC-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_DISCOUNT                             
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,RATE_DISC_CD                                            
               ,RATE_DISC_OPT                                           
               ,DISC_RATE_AMT                                           
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:J5-RATE-DISC-CD                                        
               ,:J5-RATE-DISC-OPT                                       
               ,:J5-DISC-RATE-AMT                                       
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTDISC-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTDISC-RETURN-CODE         = SUCCESSFUL-CALL         
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_DISCOUNT'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'RATE_DISC_CD'             TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE J5-RATE-DISC-CD            TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8500-INSERT-NEW-TBRTUSES-ROW                                  *         
      *****************************************************************         
       8500-INSERT-NEW-TBRTUSES-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_USE_SEASN                            
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,CODE_USE_INST_TYPE                                      
               ,DATE_FROM                                               
               ,CODE_SEASON                                             
               ,DATE_TO                                                 
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:RS-CODE-USE-INST-TYPE                                  
               ,:RS-DATE-FROM :WS-RS-DATE-FROM-NULL                      
               ,:RS-CODE-SEASON                                         
               ,:RS-DATE-TO :WS-RS-DATE-TO-NULL                          
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTUSES-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTUSES-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_USE_SEASN'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CODE_USE_INST_TYPE'       TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE RS-CODE-USE-INST-TYPE      TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                               *         
      * 8650-INSERT-NEW-TBDMDINS-ROW                                  *         
      *****************************************************************         
       8650-INSERT-NEW-TBDMDINS-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_DEMAND_INSTR                              
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,CMPNT_ID_CD                                             
               ,DMD_YLD_PR_RTE_LMT                                      
               ,MIN_DMD_CHRG                                            
               ,MIN_DMD_QTY                                             
               ,PWR_FCTR_MIN_PCT                                        
               ,LFTM_PEAK_PCT                                           
               ,LD_FCTR_MIN_PCT                                         
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:WS-CMPNT-ID-CD                                         
               ,:DI-DMD-YLD-PR-RTE-LMT                                  
               ,:DI-MIN-DMD-CHRG                                        
               ,:DI-MIN-DMD-QTY                                         
               ,:DI-PWR-FCTR-MIN-PCT                                    
               ,:DI-LFTM-PEAK-PCT                                       
               ,:DI-LD-FCTR-MIN-PCT                                     
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBDMDINS-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBDMDINS-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8650'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_DEMAND_INSTR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8700-INSERT-NEW-TBRTCDEF-ROW                                  *         
      *****************************************************************         
       8700-INSERT-NEW-TBRTCDEF-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_COMP_DEF                             
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,CMPNT_ID_CD                                             
               ,REG_TYPE_CD                                             
               ,ENERGY_UNIT_CD                                          
               ,ENERGY_SEAS_CD                                          
               ,LAST_ENERGY_BLOCK                                       
               ,DEM_REG_TYPE_CD                                         
               ,DEM_UNIT_CD                                             
               ,DEM_SEASON_CD                                           
               ,LAST_DEM_BLOCK                                          
               ,ON_PEAK_DAYS                                            
               ,CALENDAR_CD                                             
               ,RTP_BASELINE_RATE                                       
               ,BAL_FWD_CD                                              
               ,BAL_RESET_MMDD                                          
               ,BAL_RESET_PRO_CD                                        
               ,BAL_OFFSET_TOU_CD                                       
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:WS-CMPNT-ID-CD                                         
               ,:J1-REG-TYPE-CD                                         
               ,:J1-ENERGY-UNIT-CD                                      
               ,:J1-ENERGY-SEAS-CD                                      
               ,:J1-LAST-ENERGY-BLOCK                                   
               ,:J1-DEM-REG-TYPE-CD                                     
               ,:J1-DEM-UNIT-CD                                         
               ,:J1-DEM-SEASON-CD                                       
               ,:J1-LAST-DEM-BLOCK                                      
               ,:J1-ON-PEAK-DAYS                                        
               ,:J1-CALENDAR-CD                                         
               ,:J1-RTP-BASELINE-RATE                                   
               ,:J1-BAL-FWD-CD                                          
               ,:J1-BAL-RESET-MMDD                                      
               ,:J1-BAL-RESET-PRO-CD                                    
               ,:J1-BAL-OFFSET-TOU-CD                                   
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTCDEF-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTCDEF-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8700'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_COMP_DEF'        TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-INSERT-NEW-TBPRCSCH-ROW                                  *         
      *****************************************************************         
       8800-INSERT-NEW-TBPRCSCH-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_PRICE_SCHED                               
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,CMPNT_ID_CD                                             
               ,CODE_SEASON                                             
               ,CODE_TIME_PERIOD                                        
               ,CODE_USE_INST_TYPE                                      
               ,BLOCK_NO                                                
               ,BLOCK_USE_OR_SVCS                                       
               ,BLOCK_DESC                                              
               ,SCHED_PRICE_AM                                          
               ,PRICE_TYPE_CD                                           
               ,LAST_PRICE_DAY_MTH                                      
               ,BEGN_PRICE_DAY_MTH                                      
               ,ITEM_ID                                                 
               ,DATE_PRICE_END                                          
               ,DAYS_PRICE_APPLIES                                      
               ,SCHED_WNA_RATE_AMT                                      
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:WS-CMPNT-ID-CD                                         
               ,:PS-CODE-SEASON                                         
               ,:PS-CODE-TIME-PERIOD                                    
               ,:PS-CODE-USE-INST-TYPE                                  
               ,:PS-BLOCK-NO                                            
               ,:PS-BLOCK-USE-OR-SVCS                                   
               ,:PS-BLOCK-DESC                                          
               ,:PS-SCHED-PRICE-AM                                      
               ,:PS-PRICE-TYPE-CD                                       
               ,:PS-LAST-PRICE-DAY-MTH                                  
               ,:PS-BEGN-PRICE-DAY-MTH                                  
               ,:PS-ITEM-ID                                             
               ,:PS-DATE-PRICE-END                                      
               ,:PS-DAYS-PRICE-APPLIES                                  
               ,:PS-SCHED-WNA-RATE-AMT                                  
             )                                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBPRCSCH-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBPRCSCH-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8800'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8850-INSERT-NEW-TBRTPDET-ROW                                  *         
      *****************************************************************         
       8850-INSERT-NEW-TBRTPDET-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RTP_DETAIL                                
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,CMPNT_ID_CD                                             
               ,CODE_USE_INST_TYPE                                      
               ,PRICE_APPLIES_DT                                        
               ,PRICE_APPLIES_HR                                        
               ,RTP_PRICE_AMT                                           
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:WS-CMPNT-ID-CD                                         
               ,:J3-CODE-USE-INST-TYPE                                  
               ,IIF(TRY_CONVERT(DATE, :J3-PRICE-APPLIES-DT
              ) IS NULL OR (PATINDEX('%.%', :J3-PRICE-APPLIES-DT
              ) <> 0) OR (LEN(:J3-PRICE-APPLIES-DT
              ) <> 10), CIS.CHAR2DATE(:J3-PRICE-APPLIES-DT
              ), CONVERT(DATE, :J3-PRICE-APPLIES-DT) )                         
               ,:J3-PRICE-APPLIES-HR                                    
               ,:J3-RTP-PRICE-AMT                                       
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_RTP_DETAIL                                        
MFA-TR*       (                                                                 
MFA-TR*         CODE_UTIL_TYPE                                                  
MFA-TR*        ,RATE_PLAN_NO                                                    
MFA-TR*        ,VERSION_NO_CNTRL                                                
MFA-TR*        ,CMPNT_ID_CD                                                     
MFA-TR*        ,CODE_USE_INST_TYPE                                              
MFA-TR*        ,PRICE_APPLIES_DT                                                
MFA-TR*        ,PRICE_APPLIES_HR                                                
MFA-TR*        ,RTP_PRICE_AMT                                                   
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*         :WS-CODE-UTIL-TYPE                                              
MFA-TR*        ,:WS-RATE-PLAN-NO                                                
MFA-TR*        ,:WS-NEW-VERSION-NO-CNTRL                                        
MFA-TR*        ,:WS-CMPNT-ID-CD                                                 
MFA-TR*        ,:J3-CODE-USE-INST-TYPE                                          
MFA-TR*        ,:J3-PRICE-APPLIES-DT                                            
MFA-TR*        ,:J3-PRICE-APPLIES-HR                                            
MFA-TR*        ,:J3-RTP-PRICE-AMT                                               
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTPDET-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTPDET-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8850'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RTP_DETAIL'           TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8860-INSERT-NEW-TBRTTOU-ROW                                   *         
      *****************************************************************         
       8860-INSERT-NEW-TBRTTOU-ROW.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_TOU_INSTR                            
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,CMPNT_ID_CD                                             
               ,CODE_TIME_PERIOD                                        
               ,RATE_MIN_IND                                            
               ,CNTRCT_MIN_IND                                          
               ,MAX_DEMAND_IND                                          
               ,RATCHET_ID_1                                            
               ,RATCHET_ID_2                                            
               ,RATCHET_ID_3                                            
               ,MRG_OFF_PK_IND                                          
               ,MRG_CTR_MIN_IND                                         
               ,MRG_RT_MIN                                              
               ,CODE_SEASON                                             
               ,CNTRCT_MIN_PCT                                          
              )                                                         
         VALUES                                                         
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:WS-CMPNT-ID-CD                                         
               ,:RK-CODE-TIME-PERIOD                                    
               ,:RK-RATE-MIN-IND                                        
               ,:RK-CNTRCT-MIN-IND                                      
               ,:RK-MAX-DEMAND-IND                                      
               ,:RK-RATCHET-ID-1                                        
               ,:RK-RATCHET-ID-2                                        
               ,:RK-RATCHET-ID-3                                        
               ,:RK-MRG-OFF-PK-IND                                      
               ,:RK-MRG-CTR-MIN-IND                                     
               ,:RK-MRG-RT-MIN                                          
               ,:RK-CODE-SEASON                                         
               ,:RK-CNTRCT-MIN-PCT                                      
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTTOU-RETURN-CODE 
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTTOU-RETURN-CODE           = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8860'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_INSTR'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8870-INSERT-NEW-TBRTTOUD-ROW                                  *         
      *****************************************************************         
       8870-INSERT-NEW-TBRTTOUD-ROW.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_TOU_DEF                              
              (                                                         
                CODE_UTIL_TYPE                                          
               ,RATE_PLAN_NO                                            
               ,VERSION_NO_CNTRL                                        
               ,CMPNT_ID_CD                                             
               ,CODE_TIME_PERIOD                                        
               ,TOU_TO_HOUR                                             
               ,TOU_FROM_HOUR                                           
               ,TOU_TO_MMDD                                             
               ,TOU_FROM_MMDD                                           
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-RATE-PLAN-NO                                        
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:WS-CMPNT-ID-CD                                         
               ,:RJ-CODE-TIME-PERIOD                                    
               ,:RJ-TOU-TO-HOUR                                         
               ,:RJ-TOU-FROM-HOUR                                       
               ,:RJ-TOU-TO-MMDD                                         
               ,:RJ-TOU-FROM-MMDD                                       
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTTOUD-RETURN-CODE
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTTOUD-RETURN-CODE          = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8870'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_TOU_DEF'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'CMPNT_ID_CD'              TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE WS-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8870-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8880-INSERT-NEW-TBRTRDR-ROW                                             
      *****************************************************************         
       8880-INSERT-NEW-TBRTRDR-ROW.                                     
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_RIDER_EXP                            
              (                                                         
                CODE_UTIL_TYPE                                          
               ,VERSION_NO_CNTRL                                        
               ,RATE_PLAN_NO                                            
               ,TO_HHMM                                                 
               ,FROM_HHMM                                               
               ,TO_MONTH                                                
               ,FROM_MONTH                                              
              )                                                         
              VALUES                                                    
              (                                                         
                :WS-CODE-UTIL-TYPE                                      
               ,:WS-NEW-VERSION-NO-CNTRL                                
               ,:WS-RATE-PLAN-NO                                        
               ,:RZ-TO-HHMM                                             
               ,:RZ-FROM-HHMM                                           
               ,:RZ-TO-MONTH                                            
               ,:RZ-FROM-MONTH                                          
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-TBRTRDR-RETURN-CODE 
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-TBRTRDR-RETURN-CODE           = SUCCESSFUL-CALL        
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '8880'                     TO ACTIVE-PARAGRAPH       
              MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_RIDER_EXP'       TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE 'FROM_HHMM'                TO TABLE-ELEMENT-4        
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-NEW-VERSION-NO-CNTRL    TO HOSTVAR-ELEMENT-3      
              MOVE RZ-FROM-HHMM               TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8880-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8905-INSERT-RT-HIGH-LOW.                                      *         
      *****************************************************************         
       8905-INSERT-RT-HIGH-LOW.                                         
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_RATE_HIGH_LOW                             
              (                                                         
                 CODE_UTIL_TYPE                                         
                ,RATE_PLAN_NO                                           
                ,PREVIOUS_MONTH1                                        
                ,PREVIOUS_MONTH2                                        
                ,PREVIOUS_MONTH3                                        
                ,PREVIOUS_MONTH4                                        
                ,USAGE_HIGH_PCT                                         
                ,USAGE_LOW_PCT                                          
                ,DEMAND_HIGH_PCT                                        
                ,DEMAND_LOW_PCT                                         
                ,INIT_BILL_MIN_KVA                                      
                ,INIT_BILL_MAX_KVA                                      
                ,INIT_BILL_MIN_KW                                       
                ,INIT_BILL_MAX_KW                                       
                ,INIT_BILL_MIN_KWH                                      
                ,INIT_BILL_MAX_KWH                                      
                ,MIN_POWER_FACTOR                                       
                ,MAX_POWER_FACTOR                                       
                ,MIN_LOAD_FACTOR                                        
                ,MAX_LOAD_FACTOR                                        
                ,NO_CNSMPTN_YR_HIST                                     
                ,MKT_DEMAND_LOW_PCT                                     
                ,MKT_DEMAND_HI_PCT                                      
                ,MKT_USAGE_LOW_PCT                                      
                ,MKT_USAGE_HIGH_PCT                                     
                ,LAST_UPDATE_TS                                         
                ,LAST_UPDATE_USERID                                     
              )                                                         
              VALUES                                                    
              (                                                         
                 :WS-CODE-UTIL-TYPE                                     
                ,:WS-RATE-PLAN-NO                                       
                ,:O9-PREVIOUS-MONTH1                                    
                ,:O9-PREVIOUS-MONTH2                                    
                ,:O9-PREVIOUS-MONTH3                                    
                ,:O9-PREVIOUS-MONTH4                                    
                ,:O9-USAGE-HIGH-PCT                                     
                ,:O9-USAGE-LOW-PCT                                      
                ,:O9-DEMAND-HIGH-PCT                                    
                ,:O9-DEMAND-LOW-PCT                                     
                ,:O9-INIT-BILL-MIN-KVA                                  
                ,:O9-INIT-BILL-MAX-KVA                                  
                ,:O9-INIT-BILL-MIN-KW                                   
                ,:O9-INIT-BILL-MAX-KW                                   
                ,:O9-INIT-BILL-MIN-KWH                                  
                ,:O9-INIT-BILL-MAX-KWH                                  
                ,:O9-MIN-POWER-FACTOR                                   
                ,:O9-MAX-POWER-FACTOR                                   
                ,:O9-MIN-LOAD-FACTOR                                    
                ,:O9-MAX-LOAD-FACTOR                                    
                ,:O9-NO-CNSMPTN-YR-HIST                                 
                ,:O9-MKT-DEMAND-LOW-PCT                                 
                ,:O9-MKT-DEMAND-HI-PCT                                  
                ,:O9-MKT-USAGE-LOW-PCT                                  
                ,:O9-MKT-USAGE-HIGH-PCT                                 
                , CIS.CURRENT$TIMESTAMP()                                     
                ,:WS-USER-ID                                            
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_RATE_HIGH_LOW                                     
MFA-TR*       (                                                                 
MFA-TR*          CODE_UTIL_TYPE                                                 
MFA-TR*         ,RATE_PLAN_NO                                                   
MFA-TR*         ,PREVIOUS_MONTH1                                                
MFA-TR*         ,PREVIOUS_MONTH2                                                
MFA-TR*         ,PREVIOUS_MONTH3                                                
MFA-TR*         ,PREVIOUS_MONTH4                                                
MFA-TR*         ,USAGE_HIGH_PCT                                                 
MFA-TR*         ,USAGE_LOW_PCT                                                  
MFA-TR*         ,DEMAND_HIGH_PCT                                                
MFA-TR*         ,DEMAND_LOW_PCT                                                 
MFA-TR*         ,INIT_BILL_MIN_KVA                                              
MFA-TR*         ,INIT_BILL_MAX_KVA                                              
MFA-TR*         ,INIT_BILL_MIN_KW                                               
MFA-TR*         ,INIT_BILL_MAX_KW                                               
MFA-TR*         ,INIT_BILL_MIN_KWH                                              
MFA-TR*         ,INIT_BILL_MAX_KWH                                              
MFA-TR*         ,MIN_POWER_FACTOR                                               
MFA-TR*         ,MAX_POWER_FACTOR                                               
MFA-TR*         ,MIN_LOAD_FACTOR                                                
MFA-TR*         ,MAX_LOAD_FACTOR                                                
MFA-TR*         ,NO_CNSMPTN_YR_HIST                                             
MFA-TR*         ,MKT_DEMAND_LOW_PCT                                             
MFA-TR*         ,MKT_DEMAND_HI_PCT                                              
MFA-TR*         ,MKT_USAGE_LOW_PCT                                              
MFA-TR*         ,MKT_USAGE_HIGH_PCT                                             
MFA-TR*         ,LAST_UPDATE_TS                                                 
MFA-TR*         ,LAST_UPDATE_USERID                                             
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*          :WS-CODE-UTIL-TYPE                                             
MFA-TR*         ,:WS-RATE-PLAN-NO                                               
MFA-TR*         ,:O9-PREVIOUS-MONTH1                                            
MFA-TR*         ,:O9-PREVIOUS-MONTH2                                            
MFA-TR*         ,:O9-PREVIOUS-MONTH3                                            
MFA-TR*         ,:O9-PREVIOUS-MONTH4                                            
MFA-TR*         ,:O9-USAGE-HIGH-PCT                                             
MFA-TR*         ,:O9-USAGE-LOW-PCT                                              
MFA-TR*         ,:O9-DEMAND-HIGH-PCT                                            
MFA-TR*         ,:O9-DEMAND-LOW-PCT                                             
MFA-TR*         ,:O9-INIT-BILL-MIN-KVA                                          
MFA-TR*         ,:O9-INIT-BILL-MAX-KVA                                          
MFA-TR*         ,:O9-INIT-BILL-MIN-KW                                           
MFA-TR*         ,:O9-INIT-BILL-MAX-KW                                           
MFA-TR*         ,:O9-INIT-BILL-MIN-KWH                                          
MFA-TR*         ,:O9-INIT-BILL-MAX-KWH                                          
MFA-TR*         ,:O9-MIN-POWER-FACTOR                                           
MFA-TR*         ,:O9-MAX-POWER-FACTOR                                           
MFA-TR*         ,:O9-MIN-LOAD-FACTOR                                            
MFA-TR*         ,:O9-MAX-LOAD-FACTOR                                            
MFA-TR*         ,:O9-NO-CNSMPTN-YR-HIST                                         
MFA-TR*         ,:O9-MKT-DEMAND-LOW-PCT                                         
MFA-TR*         ,:O9-MKT-DEMAND-HI-PCT                                          
MFA-TR*         ,:O9-MKT-USAGE-LOW-PCT                                          
MFA-TR*         ,:O9-MKT-USAGE-HIGH-PCT                                         
MFA-TR*         , CURRENT TIMESTAMP                                             
MFA-TR*         ,:WS-USER-ID                                                    
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                             OR ALREADY-EXISTS          
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8900'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_RATE_HIGH_LOW'       TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8905-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 8910-INSERT-DTM-PGM-ID.                                                 
      *****************************************************************         
       8910-INSERT-DTM-PGM-ID.                                          
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_DMT_PGM_ID                              
                (                                                       
                  CODE_UTIL_TYPE                                        
                 ,DIGTL_MTR_TYPE                                        
                 ,PROGRAM_ID                                            
                 ,RATE_PLAN_NO                                          
                 ,LAST_UPDATE_TS                                        
                 ,LAST_UPDATE_USERID                                    
                )                                                       
                VALUES                                                  
                (                                                       
                  :WS-CODE-UTIL-TYPE                                    
                 ,:T2-DIGTL-MTR-TYPE                                    
                 ,:T2-PROGRAM-ID                                        
                 ,:WS-RATE-PLAN-NO                                      
                 , CIS.CURRENT$TIMESTAMP()                                    
                 ,:WS-USER-ID                                           
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_DMT_PGM_ID                                      
MFA-TR*         (                                                               
MFA-TR*           CODE_UTIL_TYPE                                                
MFA-TR*          ,DIGTL_MTR_TYPE                                                
MFA-TR*          ,PROGRAM_ID                                                    
MFA-TR*          ,RATE_PLAN_NO                                                  
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*           :WS-CODE-UTIL-TYPE                                            
MFA-TR*          ,:T2-DIGTL-MTR-TYPE                                            
MFA-TR*          ,:T2-PROGRAM-ID                                                
MFA-TR*          ,:WS-RATE-PLAN-NO                                              
MFA-TR*          , CURRENT TIMESTAMP                                            
MFA-TR*          ,:WS-USER-ID                                                   
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -530       
                                             OR ALREADY-EXISTS          
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8910'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DMT_PGM_ID'          TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 8920-INSERT-BTU-WNA-ROW.                                                
      *****************************************************************         
       8920-INSERT-BTU-WNA-ROW.                                         
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_BTU_WNA_RANGE                           
                (                                                       
                  CODE_UTIL_TYPE                                        
                 ,RATE_PLAN_NO                                          
                 ,EFFECTIVE_DT                                          
                 ,BTU_UPPER_LIMIT                                       
                 ,BTU_LOWER_LIMIT                                       
                 ,WNA_UPPER_LIMIT                                       
                 ,WNA_LOWER_LIMIT                                       
                 ,LAST_UPDATE_TS                                        
                 ,LAST_UPDATE_USERID                                    
                 ,WNA_LOWER_LIMIT_WQ                                    
                 ,WNA_UPPER_LIMIT_WQ                                    
                 ,GAS_BASE_HIGH_RATE                                    
                 ,GAS_BASE_LOW_RATE                                     
                 ,GAS_BASE_USE_DFLT                                     
                 ,GAS_BASE_USE_MIN                                      
                 ,WNA_GAS_RATE                                          
                )                                                       
                VALUES                                                  
                (                                                       
                  :WS-CODE-UTIL-TYPE                                    
                 ,:WS-RATE-PLAN-NO                                      
                 ,IIF(TRY_CONVERT(DATE, :BR-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :BR-EFFECTIVE-DT
              ) <> 0) OR (LEN(:BR-EFFECTIVE-DT) <> 10), CIS.CHAR2DATE(
                                                       :BR-EFFECTIVE-DT
              ), CONVERT(DATE, :BR-EFFECTIVE-DT) )                             
                 ,:BR-BTU-UPPER-LIMIT                                   
                 ,:BR-BTU-LOWER-LIMIT                                   
                 ,:BR-WNA-UPPER-LIMIT                                   
                 ,:BR-WNA-LOWER-LIMIT                                   
                 , CIS.CURRENT$TIMESTAMP()                                    
                 ,:WS-USER-ID                                           
                 ,:BR-WNA-LOWER-LIMIT-WQ                                
                 ,:BR-WNA-UPPER-LIMIT-WQ                                
                 ,:BR-GAS-BASE-HIGH-RATE                                
                 ,:BR-GAS-BASE-LOW-RATE                                 
                 ,:BR-GAS-BASE-USE-DFLT                                 
                 ,:BR-GAS-BASE-USE-MIN                                  
                 ,:BR-WNA-GAS-RATE                                      
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_BTU_WNA_RANGE                                   
MFA-TR*         (                                                               
MFA-TR*           CODE_UTIL_TYPE                                                
MFA-TR*          ,RATE_PLAN_NO                                                  
MFA-TR*          ,EFFECTIVE_DT                                                  
MFA-TR*          ,BTU_UPPER_LIMIT                                               
MFA-TR*          ,BTU_LOWER_LIMIT                                               
MFA-TR*          ,WNA_UPPER_LIMIT                                               
MFA-TR*          ,WNA_LOWER_LIMIT                                               
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,WNA_LOWER_LIMIT_WQ                                            
MFA-TR*          ,WNA_UPPER_LIMIT_WQ                                            
MFA-TR*          ,GAS_BASE_HIGH_RATE                                            
MFA-TR*          ,GAS_BASE_LOW_RATE                                             
MFA-TR*          ,GAS_BASE_USE_DFLT                                             
MFA-TR*          ,GAS_BASE_USE_MIN                                              
MFA-TR*          ,WNA_GAS_RATE                                                  
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*           :WS-CODE-UTIL-TYPE                                            
MFA-TR*          ,:WS-RATE-PLAN-NO                                              
MFA-TR*          ,:BR-EFFECTIVE-DT                                              
MFA-TR*          ,:BR-BTU-UPPER-LIMIT                                           
MFA-TR*          ,:BR-BTU-LOWER-LIMIT                                           
MFA-TR*          ,:BR-WNA-UPPER-LIMIT                                           
MFA-TR*          ,:BR-WNA-LOWER-LIMIT                                           
MFA-TR*          , CURRENT TIMESTAMP                                            
MFA-TR*          ,:WS-USER-ID                                                   
MFA-TR*          ,:BR-WNA-LOWER-LIMIT-WQ                                        
MFA-TR*          ,:BR-WNA-UPPER-LIMIT-WQ                                        
MFA-TR*          ,:BR-GAS-BASE-HIGH-RATE                                        
MFA-TR*          ,:BR-GAS-BASE-LOW-RATE                                         
MFA-TR*          ,:BR-GAS-BASE-USE-DFLT                                         
MFA-TR*          ,:BR-GAS-BASE-USE-MIN                                          
MFA-TR*          ,:BR-WNA-GAS-RATE                                              
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                             OR ALREADY-EXISTS          
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8920'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_WNA_RANGE'       TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'EFFECTIVE_DATE'          TO TABLE-ELEMENT-3         
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE BR-EFFECTIVE-DT           TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 8930-INSERT-REV-CLS-RATE.                                               
      *****************************************************************         
       8930-INSERT-REV-CLS-RATE.                                        
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_REV_CLS_RATE                            
                (                                                       
                  RATE_PLAN_NO                                          
                 ,CODE_REVENUE_CLASS                                    
                 ,CODE_UTIL_TYPE                                        
                 ,GL_ACCT_NO                                            
                 ,COMPANY_NO                                            
                 ,STATUS_CD                                             
                 ,STATUS_CHANGE_DT                                      
                 ,LAST_UPDATE_TS                                        
                 ,LAST_UPDATE_USERID                                    
                )                                                       
                VALUES                                                  
                (                                                       
                  :WS-RATE-PLAN-NO                                      
                 ,:Q8-CODE-REVENUE-CLASS                                
                 ,:WS-CODE-UTIL-TYPE                                    
                 ,:Q8-GL-ACCT-NO                                        
                 ,:Q8-COMPANY-NO                                        
                 ,:Q8-STATUS-CD                                         
                 ,IIF(TRY_CONVERT(DATE, :Q8-STATUS-CHANGE-DT 
                                        :WS-NULL-IND-01
              ) IS NULL OR (PATINDEX('%.%', :Q8-STATUS-CHANGE-DT 
                                                        :WS-NULL-IND-01
              ) <> 0) OR (LEN(:Q8-STATUS-CHANGE-DT :WS-NULL-IND-01
              ) <> 10), CIS.CHAR2DATE(:Q8-STATUS-CHANGE-DT 
                                                        :WS-NULL-IND-01
              ), CONVERT(DATE, :Q8-STATUS-CHANGE-DT :WS-NULL-IND-01) )         
                 , CIS.CURRENT$TIMESTAMP()                                    
                 ,:WS-USER-ID                                           
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_REV_CLS_RATE                                    
MFA-TR*         (                                                               
MFA-TR*           RATE_PLAN_NO                                                  
MFA-TR*          ,CODE_REVENUE_CLASS                                            
MFA-TR*          ,CODE_UTIL_TYPE                                                
MFA-TR*          ,GL_ACCT_NO                                                    
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,STATUS_CD                                                     
MFA-TR*          ,STATUS_CHANGE_DT                                              
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*           :WS-RATE-PLAN-NO                                              
MFA-TR*          ,:Q8-CODE-REVENUE-CLASS                                        
MFA-TR*          ,:WS-CODE-UTIL-TYPE                                            
MFA-TR*          ,:Q8-GL-ACCT-NO                                                
MFA-TR*          ,:Q8-COMPANY-NO                                                
MFA-TR*          ,:Q8-STATUS-CD                                                 
MFA-TR*          ,:Q8-STATUS-CHANGE-DT:WS-NULL-IND-01                           
MFA-TR*          , CURRENT TIMESTAMP                                            
MFA-TR*          ,:WS-USER-ID                                                   
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8930'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_REV_CLS_RATE'        TO TABLE-1                 
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-1         
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2         
              MOVE 'CODE_REVENUE_CLASS'      TO TABLE-ELEMENT-3         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4         
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-1       
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2       
              MOVE Q8-CODE-REVENUE-CLASS     TO HOSTVAR-ELEMENT-3       
              MOVE Q8-COMPANY-NO             TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                                         
      * 8940-INSRT-SPCL-FCT-CSR.                                                
      *****************************************************************         
       8940-INSRT-SPCL-FCT-CSR.                                         
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_SPCL_FCTR_APPL                          
                (                                                       
                  CODE_UTIL_TYPE                                        
                 ,RATE_PLAN_NO                                          
                 ,FACTOR_ID                                             
                 ,DATE_FROM                                             
                 ,ENTRY_NO                                              
                 ,DATE_TO                                               
                 ,CMPNT_ID_CD                                           
                 ,CODE_SEASON                                           
                 ,INSTR_USE_TYPE_CD                                     
                 ,CODE_TIME_PERIOD                                      
                 ,CODE_REVENUE_CLASS                                    
                 ,FACTOR                                                
                 ,CODE_STATUS                                           
                 ,USER_ID_UPD_BY                                        
                 ,VERS_PRORATE_CD                                       
                 ,BLOCK_NO                                              
                )                                                       
                VALUES                                                  
                (                                                       
                  :WS-CODE-UTIL-TYPE                                    
                 ,:WS-RATE-PLAN-NO                                      
                 ,:SA-FACTOR-ID                                         
                 ,IIF(TRY_CONVERT(DATE, :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )                                
                 ,:SA-ENTRY-NO                                          
                 ,IIF(TRY_CONVERT(DATE, :SA-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO) <> 0) OR (LEN(
                                                            :SA-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO), CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) )                                           
                 ,:SA-CMPNT-ID-CD                                       
                 ,:SA-CODE-SEASON                                       
                 ,:SA-INSTR-USE-TYPE-CD                                 
                 ,:SA-CODE-TIME-PERIOD                                  
                 ,:SA-CODE-REVENUE-CLASS                                
                 ,:SA-FACTOR                                            
                 ,:SA-CODE-STATUS                                       
                 ,:WS-USER-ID                                           
                 ,:SA-VERS-PRORATE-CD                                   
                 ,:SA-BLOCK-NO                                          
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_SPCL_FCTR_APPL                                  
MFA-TR*         (                                                               
MFA-TR*           CODE_UTIL_TYPE                                                
MFA-TR*          ,RATE_PLAN_NO                                                  
MFA-TR*          ,FACTOR_ID                                                     
MFA-TR*          ,DATE_FROM                                                     
MFA-TR*          ,ENTRY_NO                                                      
MFA-TR*          ,DATE_TO                                                       
MFA-TR*          ,CMPNT_ID_CD                                                   
MFA-TR*          ,CODE_SEASON                                                   
MFA-TR*          ,INSTR_USE_TYPE_CD                                             
MFA-TR*          ,CODE_TIME_PERIOD                                              
MFA-TR*          ,CODE_REVENUE_CLASS                                            
MFA-TR*          ,FACTOR                                                        
MFA-TR*          ,CODE_STATUS                                                   
MFA-TR*          ,USER_ID_UPD_BY                                                
MFA-TR*          ,VERS_PRORATE_CD                                               
MFA-TR*          ,BLOCK_NO                                                      
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*           :WS-CODE-UTIL-TYPE                                            
MFA-TR*          ,:WS-RATE-PLAN-NO                                              
MFA-TR*          ,:SA-FACTOR-ID                                                 
MFA-TR*          ,:SA-DATE-FROM                                                 
MFA-TR*          ,:SA-ENTRY-NO                                                  
MFA-TR*          ,:SA-DATE-TO                                                   
MFA-TR*          ,:SA-CMPNT-ID-CD                                               
MFA-TR*          ,:SA-CODE-SEASON                                               
MFA-TR*          ,:SA-INSTR-USE-TYPE-CD                                         
MFA-TR*          ,:SA-CODE-TIME-PERIOD                                          
MFA-TR*          ,:SA-CODE-REVENUE-CLASS                                        
MFA-TR*          ,:SA-FACTOR                                                    
MFA-TR*          ,:SA-CODE-STATUS                                               
MFA-TR*          ,:WS-USER-ID                                                   
MFA-TR*          ,:SA-VERS-PRORATE-CD                                           
MFA-TR*          ,:SA-BLOCK-NO                                                  
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8940'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-3         
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-4         
              MOVE WS-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE WS-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-3       
              MOVE SA-DATE-FROM              TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8940-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
