       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.      CSR04437.                                       
       AUTHOR.       MN90523.                                           
COB303 DATE-WRITTEN. MAR 2011.                                           
       DATE-COMPILED.                                                   
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04437              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04437 :                                                --         
      *--                                                            --         
      *--  #  INVOKED FROM BPA RATE ENTRY SCREENS                    --         
      *--  #  UPDATE CRM BPA ENTRIES                                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            I_APPL_PGM_ID     CHAR(08)                      --         
      *--            I_RESOURCE_ID     CHAR(32)                      --         
      *--            I_USER_ID         CHAR(07)                      --         
      *--            I_OPERATION_ID    CHAR(03)                      --         
      *--            I_COMPANY_NO      CHAR(02)                      --         
      *--            I_CODE_UTIL_TYPE  CHAR(01)                      --         
      *--            I_PROC_REQ_ID     DECIMAL(10)                   --         
      *--            I_VERSION_TS      CHAR(26)                      --         
      *--            I_PROMOTION_DATA  VARCHAR(1300)                 --         
      *--            I_OFFER_DATA      VARCHAR(6500)                 --         
      *--            I_OPTION01_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION02_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION03_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION04_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION05_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION06_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION07_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION08_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION09_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION10_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION11_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION12_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION13_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION14_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION15_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION16_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION17_DATA   VARCHAR(8000)                 --         
      *--            I_OPTION18_DATA   VARCHAR(8000)                 --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--            RETURN_CODE           CHAR(9)                   --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00473*--  05/15/2007    MN90523     PROGRAM INTIALLY WRITTEN.       --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04437'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    SQL ERROR CHECKING COPYBOOK.                                *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR UPDATE                          *        
      ******************************************************************        
           COPY CWS00826.                                                       
                                                                        
      ******************************************************************        
      *    WORKING STORAGE SUPPORT FOR VALIDATION                      *        
      ******************************************************************        
           COPY CWS00829.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
                                                                        
       01  WS-WORKING-STORAGE.                                          
           05 WS-SQLSTATE             PIC X(05) VALUE SPACES.           
                                                                        
       01  WS-SWITCHES.                                                 
           05 ALL-DONE-SW             PIC X(01) VALUE 'N'.              
              88 NOT-ALL-DONE             VALUE 'N'.                    
              88 ALL-DONE                 VALUE 'Y'.                    
           05 SEND-DONE-SW            PIC X(01) VALUE 'Y'.              
              88 SEND-DONE-ERROR          VALUE 'N'.                    
              88 SEND-DONE-OK             VALUE 'Y'.                    
                                                                        
       01 WS-OPTION-DATA-INFO.                                          
           05 WS-OPTION-DATA-LEN          PIC S9(4) COMP.               
           05 WS-OPTION-DATA-TEXT         PIC X(8000).                  
                                                                        
       01 WS-OFFER-DATA-INFO.                                           
           05 WS-OFFER-DATA-LEN           PIC S9(4) COMP.               
           05 WS-OFFER-DATA-TEXT          PIC X(6500).                  
                                                                        
       01 WS-PROMO-DATA-INFO.                                           
           05 WS-PROMO-DATA-LEN           PIC S9(4) COMP.               
           05 WS-PROMO-DATA-TEXT          PIC X(1300).                  
                                                                        
       01 WS-APPL-PGM-ID                  PIC X(08).                    
       01 WS-RESOURCE-ID                  PIC X(32).                    
       01 WS-OPERATION-ID                 PIC X(04).                    
                                                                        
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME            PIC X(08) VALUE 'CSR04437'.       
           05 MCSCB826                PIC X(08) VALUE 'MCSCB826'.       
           05 MCSCB829                PIC X(08) VALUE 'MCSCB829'.       
           05 WS-N                    PIC X(01) VALUE 'N'.              
           05 WS-RED-FLAG             PIC X(01) VALUE 'R'.              
           05 WS-YELLOW-FLAG          PIC X(01) VALUE 'Y'.              
           05 WS-GREEN-FLAG           PIC X(01) VALUE 'G'.              
           05 GTT-NAME                PIC X(26)                         
                                            VALUE 'SESSION.CSR04437_R1'.
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05 RS-APPL-RETURN-CODE       PIC S9(09) COMP VALUE 0.        
           05 RS-RULE-NO                PIC X(08)  VALUE SPACES.        
           05 RS-RULE-FLAG              PIC X(01)  VALUE SPACES.        
           05 RS-ERROR-HEADER-DESC      PIC X(200) VALUE SPACES.        
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE 0.        
           05  S-APPL-RETURN-CODE       PIC S9(09) COMP VALUE 0.        
           05  S-RULE-NO                PIC X(08)  VALUE SPACES.        
           05  S-RULE-FLAG              PIC X(01)  VALUE SPACES.        
           05  S-ERROR-HEADER-DESC      PIC X(200) VALUE SPACES.        
                                                                        
       01 WS-SWITCH.                                                    
           05 WS-RULES-EXISTS           PIC X(01)  VALUE 'Y'.           
              88 RULES-EXISTS                      VALUE 'Y'.           
              88 RULES-NOT-EXISTS                  VALUE 'N'.           
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      ******************************************************************        
      *  CURSOR DECLARATIONS.                                          *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PGM-ID        PIC X(08).                           
       01  PARM-RESOURCE-ID        PIC X(32).                           
       01  PARM-USER-ID            PIC X(07).                           
       01  PARM-OPERATION-ID       PIC X(04).                           
       01  PARM-COMPANY-NO         PIC X(02).                           
       01  PARM-CODE-UTIL-TYPE     PIC X(01).                           
COB305 01 PARM-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.            
       01  PARM-VERSION-TS         PIC X(26).                           
       01  PARM-PROMOTION1-DATA    PIC X(1300).                         
       01  PARM-PROMOTION2-DATA    PIC X(1300).                         
       01  PARM-OFFER-DATA         PIC X(6500).                         
       01  PARM-TEMPLATE-OFFER     PIC X(12).                           
       01  PARM-UNDFLT-OFFR-TIER   PIC X(01).                           
       01  PARM-SET-PROMO-FLGS     PIC X(01).                           
       01  PARM-OPTION01-DATA      PIC X(8000).                         
       01  PARM-OPTION02-DATA      PIC X(8000).                         
       01  PARM-OPTION03-DATA      PIC X(8000).                         
       01  PARM-OPTION04-DATA      PIC X(8000).                         
       01  PARM-OPTION05-DATA      PIC X(8000).                         
       01  PARM-OPTION06-DATA      PIC X(8000).                         
       01  PARM-OPTION07-DATA      PIC X(8000).                         
       01  PARM-OPTION08-DATA      PIC X(8000).                         
       01  PARM-OPTION09-DATA      PIC X(8000).                         
       01  PARM-OPTION10-DATA      PIC X(8000).                         
       01  PARM-OPTION11-DATA      PIC X(8000).                         
       01  PARM-OPTION12-DATA      PIC X(8000).                         
       01  PARM-OPTION13-DATA      PIC X(8000).                         
       01  PARM-OPTION14-DATA      PIC X(8000).                         
       01  PARM-OPTION15-DATA      PIC X(8000).                         
       01  PARM-OPTION16-DATA      PIC X(8000).                         
       01  PARM-OPTION17-DATA      PIC X(8000).                         
       01  PARM-OPTION18-DATA      PIC X(8000).                         
                                                                        
       PROCEDURE DIVISION  USING PARM-APPL-PGM-ID                       
                                 PARM-RESOURCE-ID                       
                                 PARM-USER-ID                           
                                 PARM-OPERATION-ID                      
                                 PARM-COMPANY-NO                        
                                 PARM-CODE-UTIL-TYPE                    
                                 PARM-PROC-REQ-ID                       
                                 PARM-VERSION-TS                        
                                 PARM-PROMOTION1-DATA                   
                                 PARM-PROMOTION2-DATA                   
                                 PARM-OFFER-DATA                        
                                 PARM-TEMPLATE-OFFER                    
                                 PARM-UNDFLT-OFFR-TIER                  
                                 PARM-SET-PROMO-FLGS                    
                                 PARM-OPTION01-DATA                     
                                 PARM-OPTION02-DATA                     
                                 PARM-OPTION03-DATA                     
                                 PARM-OPTION04-DATA                     
                                 PARM-OPTION05-DATA                     
                                 PARM-OPTION06-DATA                     
                                 PARM-OPTION07-DATA                     
                                 PARM-OPTION08-DATA                     
                                 PARM-OPTION09-DATA                     
                                 PARM-OPTION10-DATA                     
                                 PARM-OPTION11-DATA                     
                                 PARM-OPTION12-DATA                     
                                 PARM-OPTION13-DATA                     
                                 PARM-OPTION14-DATA                     
                                 PARM-OPTION15-DATA                     
                                 PARM-OPTION16-DATA                     
                                 PARM-OPTION17-DATA                     
                                 PARM-OPTION18-DATA.                    
      ******************************************************************        
      *                                                                *        
      * 0000-MAINLINE.                                                 *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT        THRU 0100A-EXIT.            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04437_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04437_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,RULE_NO CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2           
                   ,RULE_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,ERROR_HEADER_DESC CHAR(200)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100'                TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE GTT-NAME              TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(RULE_NO))              AS RULE_NO           
                      ,RULE_FLAG                   AS RULE_FLAG         
                      ,LTRIM(RTRIM(ERROR_HEADER_DESC))    AS 
           ERROR_HEADER_DESC 
                  FROM #CSR04437_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(RULE_NO)              AS RULE_NO                   
MFA-TR*               ,RULE_FLAG                   AS RULE_FLAG                 
MFA-TR*               ,STRIP(ERROR_HEADER_DESC)    AS ERROR_HEADER_DESC         
MFA-TR*           FROM SESSION.CSR04437_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PROGRAM-NAME              TO WS-CALLING-PGM-ID.         
                                                                        
                                                                        
           MOVE PARM-APPL-PGM-ID          TO WS-APPL-PGM-ID             
                                             WS-CRM-APPL-PGM-ID         
           MOVE PARM-RESOURCE-ID          TO WS-RESOURCE-ID             
                                             WS-CRM-RESOURCE-ID         
           MOVE PARM-OPERATION-ID         TO WS-OPERATION-ID            
                                             WS-CRM-OPERATION-ID        
                                                                        
           MOVE PARM-USER-ID              TO WS-CRM-USER-ID             
           MOVE PARM-COMPANY-NO           TO WS-CRM-COMPANY-NO          
           MOVE PARM-CODE-UTIL-TYPE       TO WS-CRM-CODE-UTIL-TYPE      
           MOVE PARM-PROC-REQ-ID          TO WS-CRM-PROC-REQ-ID         
           MOVE PARM-VERSION-TS           TO WS-CRM-VRSN-TIMESTAMP      
           MOVE PARM-TEMPLATE-OFFER       TO WS-CRM-TEMPLATE-OFFER-CD   
           MOVE PARM-UNDFLT-OFFR-TIER     TO                            
                                WS-CRM-UNDFLT-TMPLT-OFFR-TIERS          
           MOVE PARM-SET-PROMO-FLGS       TO                            
                                WS-CRM-SET-PROMO-INT-EXT-FLGS           
                                                                        
           MOVE PARM-PROMOTION1-DATA      TO WS-PROMO-DATA-INFO         
           MOVE WS-PROMO-DATA-TEXT        TO WS-CRM-PROMO-DATA-KM(01)   
                                                                        
           MOVE PARM-PROMOTION2-DATA      TO WS-PROMO-DATA-INFO         
           MOVE WS-PROMO-DATA-TEXT        TO WS-CRM-PROMO-DATA-KM(02)   
                                                                        
           MOVE PARM-OFFER-DATA           TO WS-OFFER-DATA-INFO         
           MOVE WS-OFFER-DATA-TEXT        TO WS-CRM-OFFER-INFO-FG       
                                                                        
           MOVE PARM-OPTION01-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(01)  
                                                                        
           MOVE PARM-OPTION02-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(02)  
                                                                        
           MOVE PARM-OPTION03-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(03)  
                                                                        
           MOVE PARM-OPTION04-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(04)  
                                                                        
           MOVE PARM-OPTION05-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(05)  
                                                                        
           MOVE PARM-OPTION06-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(06)  
                                                                        
           MOVE PARM-OPTION07-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(07)  
                                                                        
           MOVE PARM-OPTION08-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(08)  
                                                                        
           MOVE PARM-OPTION09-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(09)  
                                                                        
           MOVE PARM-OPTION10-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(10)  
                                                                        
           MOVE PARM-OPTION11-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(11)  
                                                                        
           MOVE PARM-OPTION12-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(12)  
                                                                        
           MOVE PARM-OPTION13-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(13)  
                                                                        
           MOVE PARM-OPTION14-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(14)  
                                                                        
           MOVE PARM-OPTION15-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(15)  
                                                                        
           MOVE PARM-OPTION16-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(16)  
                                                                        
           MOVE PARM-OPTION17-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(17)  
                                                                        
           MOVE PARM-OPTION18-DATA        TO WS-OPTION-DATA-INFO        
           MOVE WS-OPTION-DATA-TEXT       TO WS-CRM-OPTION-DATA-FI(18). 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 6000-VALIDATE-CRM-ENTRIES   THRU 6000-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT.                                             *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE             TO S-RETURN-CODE.            
           MOVE RS-APPL-RETURN-CODE        TO S-APPL-RETURN-CODE.       
           MOVE RS-RULE-NO                 TO S-RULE-NO.                
           MOVE RS-RULE-FLAG               TO S-RULE-FLAG.              
           MOVE RS-ERROR-HEADER-DESC       TO S-ERROR-HEADER-DESC.      
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5000-PROCESS-VALIDATION-MSG.                                  *         
      *****************************************************************         
       5000-PROCESS-VALIDATION-MSG.                                     
                                                                        
           SET RULES-NOT-EXISTS              TO TRUE.                   
                                                                        
           PERFORM VARYING WS-ERR-MESS-INDX FROM 1 BY 1                 
             UNTIL WS-ERR-MESS-INDX    > WS-ERR-MAX-ENTRY   OR          
                   WS-RULE-NO(WS-ERR-MESS-INDX) EQUAL SPACES            
                                                                        
              SET RULES-EXISTS                TO TRUE                   
                                                                        
              MOVE WS-RULE-NO(WS-ERR-MESS-INDX)                         
                                             TO RS-RULE-NO              
              MOVE WS-RULE-FLAG(WS-ERR-MESS-INDX)                       
                                             TO RS-RULE-FLAG            
              MOVE WS-ERROR-HEADER-DESC(WS-ERR-MESS-INDX)               
                                             TO RS-ERROR-HEADER-DESC    
                                                                        
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
                                                                        
           END-PERFORM.                                                 
                                                                        
           IF RULES-NOT-EXISTS                                          
              MOVE SPACES                    TO RS-RULE-NO              
                                                RS-RULE-FLAG            
                                                RS-ERROR-HEADER-DESC    
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 8100-SEND-RESULT       THRU 8100-EXIT             
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 6000-VALIDATE-CRM-ENTRIES.                                   *          
      *****************************************************************         
       6000-VALIDATE-CRM-ENTRIES.                                       
                                                                        
           CALL MCSCB829 USING ABEND-FILE                               
                               WS-WARNING-DATA-ELEMENTS                 
                               WS-CRM-HEADER-PARMS                      
                               WS-CRM-COMMON-PARMS                      
                               WS-CRM-DATA-LAYOUT                       
                               WS-CRM-RETURN-INFO                       
                               WS-CRM-VLDT-INPUT-PARMS                  
                               WS-CRM-ERR-MSG-RETURN-INFO               
                               WS-CRM-VALD-ERR-TABLE.                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL ZEROES                    
                                AND NOT EQUAL NOT-FOUND                 
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              IF WS-ERR-MSG-RETURN-CD > 1 THEN                          
                 MOVE ZERO                    TO RS-RETURN-CODE         
                 MOVE WS-ERR-MSG-RETURN-CD    TO RS-APPL-RETURN-CODE    
                 PERFORM 5000-PROCESS-VALIDATION-MSG THRU 5000-EXIT     
              ELSE                                                      
                 PERFORM 6100-UPDATE-CRM-ENTRIES THRU 6100-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 6100-UPDATE-CRM-ENTRIES                                      *          
      *****************************************************************         
       6100-UPDATE-CRM-ENTRIES.                                         
                                                                        
                                                                        
           CALL MCSCB826 USING ABEND-FILE                               
                               WS-WARNING-DATA-ELEMENTS                 
                               WS-CRM-HEADER-PARMS                      
                               WS-CRM-COMMON-PARMS                      
                               WS-CRM-DATA-LAYOUT                       
                               WS-CRM-RETURN-INFO.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL ZEROES                    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              MOVE ZERO                    TO RS-RETURN-CODE            
              MOVE WS-ERR-MSG-RETURN-CD    TO RS-APPL-RETURN-CODE       
              PERFORM 5000-PROCESS-VALIDATION-MSG THRU 5000-EXIT        
           END-IF                                                       
           .                                                            
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04437_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04437_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
      *                                        S-RETURN-CODE-1.                 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04437_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04437_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,RULE_NO                                              
                  ,RULE_FLAG                                            
                  ,ERROR_HEADER_DESC                                    
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE                                       
                  ,:S-APPL-RETURN-CODE                                  
                  ,:S-RULE-NO                                           
                  ,:S-RULE-FLAG                                         
                  ,:S-ERROR-HEADER-DESC                                 
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04437_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,RULE_NO                                                      
MFA-TR*           ,RULE_FLAG                                                    
MFA-TR*           ,ERROR_HEADER_DESC                                            
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-APPL-RETURN-CODE                                          
MFA-TR*           ,:S-RULE-NO                                                   
MFA-TR*           ,:S-RULE-FLAG                                                 
MFA-TR*           ,:S-ERROR-HEADER-DESC                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04437_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
             INCLUDE CPD00320                                                   
           END-EXEC.                                                            
                                                                        
