       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04436.                                      
       AUTHOR.           MS93554.                                       
COB303 DATE-WRITTEN.     MAR 28, 2012.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *      BUSOP:  DEVELOP-RMM-UPDRMMBUSPROCSTATUSBUSINESSOP         *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATE THE STATUS CODE OF NEW RATE VERSIONS,     *        
      *  FACTORS ,OR RATE FACTOR PRICES TO ACTIVATE, ONCE THE          *        
      *  APPROVAL PROCESS IS COMPLETE FOR THE BELOW TABLES.            *        
      *                                                                *        
      *  CSS_RATE_CREATOR                                              *        
      *  CSS_SPCL_FCTR                                                 *        
      *  CSS_SPCL_FCTR_APPL.                                           *        
      *                                                                *        
      *  INPUT PARAMETERS.                                             *        
      *  ----------------                                              *        
      *             APPL_PROG_ID               CHAR(03)                *        
      *             USER_ID                    CHAR(07)                *        
      *             PROC_REQ_ID                SMALLINT                *        
      *                                                                *        
      *  OUTPUT PARAMETERS.                                            *        
      *  -----------------                                             *        
      *             RETURN_CODE                INTEGER                 *        
      *             APPL_RETURN_CODE           INTEGER                 *        
      *             PROC_REQ_ID                CHAR(10)                *        
      *                                                                *        
      * APPL RETURN CODE.                                              *        
      * -----------------                                              *        
      * 290 - TABLE UPDATE FAILED.                                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE      INITIALS   COMMENTS                               *        
      *  --------    --------   ------------------------------         *        
P00473*  03-28-2012  MS93554    NEW PROGRAM                            *        
A04177*  08-20-2012  MS93554    WHEN NEW-FACTOR-PRICE-WIZARD - CALL    *        
A04177*                         CSR04519 TO UPDATE THE STATUS OF       *        
A04177*                         CSS_SPCL_FCTR_APPL PASSING ACTION      *        
A04177*                         CODE AS 'F' AND PROC REQ ID.           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04436'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR04436 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PROCESS_REQ      1P                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCREQ                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_PROCESS_CNTRL    6P                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCTLN                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_RATE_CREATOR     RT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR        SF                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_SPCL_FCTR_APPL   SA                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
                                                                        
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                       
      ******************************************************************        
           COPY CWS00027.                                                       
                                                                        
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR04436'.      
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-GTT-NAME             PIC X(19) VALUE SPACES.          
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME               PIC X(26)                        
                                       VALUE 'SESSION.CSR04436_R1'.     
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN         PIC S9(04) COMP.                 
                49 GTT-ROW-CHAR        PIC X(1024).                     
            05  GTT-SQLCODE            PIC S9(9) COMP.                  
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE               PIC X(01) VALUE 'A'.             
           05  WS-PROMOTE              PIC X(01) VALUE 'P'.             
           05  WS-REVENUE-MONTH        PIC X(01) VALUE 'R'.             
A04177     05  WS-ACTION-CODE          PIC X(01) VALUE 'F'.             
           05  WS-YES-NULL             PIC S9(04) VALUE -1.             
A04177     05  WS-PROC-REQ-ID          PIC X(10) VALUE SPACES.          
A04177     05  WS-FACTOR               PIC X(10) VALUE '0000000000'.    
A04177     05  WS-APPL-PROG-ID         PIC X(03) VALUE SPACES.          
A04177     05  WS-USER-ID              PIC X(07) VALUE SPACES.          
A04177     05  WS-BLOCK-NO             PIC X(07) VALUE '0000'.          
A04177     05  WS-ENTRY-NUMBER         PIC X(07) VALUE '0000'.          
                                                                        
A04177 01  WS-04519-RETURN-VALUES.                                      
A04177     05  WS-04519-RETURN-CODE    PIC S9(9) VALUE 0 COMP.          
A04177     05  WS-APPL-RETURN-CODE     PIC S9(09) COMP VALUE +0.        
A04177     05  WS-ENTRY-NO             PIC S9(09) COMP VALUE +0.        
A04177     05  WS-DELETE-BPR           PIC X(01) VALUE 'N'.             
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-01           PIC S9(4) COMP.                  
           05 WS-NULL-IND-02           PIC S9(4) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-APPL-RETURN-CODE      PIC S9(9) COMP VALUE 0.          
           05  S-PROC-REQ-ID           PIC X(10) VALUE SPACE.           
                                                                        
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       01  SWITCHES.                                                    
           05  CSR04436-DONE-SW        PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-LAST-BRP-STEP-FLAG   PIC X(01) VALUE 'N'.             
               88  WS-NOT-LAST-BPR-STEP          VALUE 'Y'.             
               88  WS-LAST-BPR-STEP              VALUE 'N'.             
           05  WS-NO-MORE-ROWS         PIC X(01) VALUE 'N'.             
               88 NO-MORE-ROWS                   VALUE 'Y'.             
           05  WS-PROCESS-TYPE-WIZARD  PIC X(06) VALUE ' '.             
               88 NEW-RATE-WIZARD                VALUE 'RMM001'.        
               88 NEW-FACTOR-WIZARD              VALUE 'RMM002'.        
               88 NEW-RATE-PRICE-WIZARD          VALUE 'RMM003'.        
               88 NEW-FACTOR-PRICE-WIZARD        VALUE 'RMM004'.        
                                                                        
      *01 LOC-RESLTSET USAGE SQL TYPE IS RESULT-SET-LOCATOR VARYING.    
                                                                        
C34568******************************************************************03389685
      *                                                                *03389685
      * CURSOR TO FETCH SPECIAL FCTR APPLICATION DETAILS FOR THE RATE  *03389685
      * WITH ACTIVE / TEST STATUS.                                     *03389685
      ******************************************************************03389685
           EXEC SQL                                                     
              DECLARE SPCL_FCTR_APPL_CSR CURSOR FOR                     
                 SELECT SA.FACTOR_ID                                    
                       ,SA.ENTRY_NO                                     
                       ,SA.CMPNT_ID_CD                                  
                       ,SA.CODE_SEASON                                  
                       ,SA.INSTR_USE_TYPE_CD                            
                       ,SA.CODE_TIME_PERIOD                             
                       ,SA.CODE_REVENUE_CLASS                           
                       ,SA.FACTOR                                       
                       ,SA.VERS_PRORATE_CD                              
                       ,SA.DATE_FROM                                    
                       ,SA.DATE_TO                                      
                       ,SA.BLOCK_NO                                     
                   FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)             
                  WHERE SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE          
                    AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO            
                    AND SA.CODE_STATUS    IN ('A','T')                  
                  ORDER BY SA.DATE_FROM ASC                             
                    FOR READ ONLY                               
                                                            
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     03389685
MFA-TR*       DECLARE SPCL_FCTR_APPL_CSR CURSOR FOR                     03389685
MFA-TR*          SELECT SA.FACTOR_ID                                    03389685
MFA-TR*                ,SA.ENTRY_NO                                     03389685
MFA-TR*                ,SA.CMPNT_ID_CD                                  03389685
MFA-TR*                ,SA.CODE_SEASON                                  03389685
MFA-TR*                ,SA.INSTR_USE_TYPE_CD                            03389685
MFA-TR*                ,SA.CODE_TIME_PERIOD                             03389685
MFA-TR*                ,SA.CODE_REVENUE_CLASS                           03389685
MFA-TR*                ,SA.FACTOR                                       03389685
MFA-TR*                ,SA.VERS_PRORATE_CD                              03389685
MFA-TR*                ,SA.DATE_FROM                                    03389685
MFA-TR*                ,SA.DATE_TO                                      03389685
MFA-TR*                ,SA.BLOCK_NO                                     03389685
MFA-TR*            FROM CSS_SPCL_FCTR_APPL SA                           03389685
MFA-TR*           WHERE SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE          03389685
MFA-TR*             AND SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO            03389685
MFA-TR*             AND SA.CODE_STATUS    IN ('A','T')                  03389685
MFA-TR*           ORDER BY SA.DATE_FROM ASC                             03389685
MFA-TR*             FOR FETCH ONLY WITH UR                              03389685
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                    03389685
MSQ001        EXEC SQL
MSQ001          DECLARE UPDATE_CUR CURSOR
MSQ001          FOR CALL CSR04519( :WS-APPL-PROG-ID
                  , :WS-USER-ID
                  , :WS-ACTION-CODE
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , :WS-FACTOR
                  , ' '
                  , :WS-ENTRY-NUMBER
                  , :WS-USER-ID
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , ' '
                  , :WS-BLOCK-NO
                  , ' '
                  , :WS-PROC-REQ-ID
                  , ' '
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
      ******************************************************************        
      *   LINKAGE SECTION.                                             *        
      ******************************************************************        
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-APPL-PROG-ID       PIC X(03).                           
       01  PARM-USER-ID            PIC X(07).                           
       01  PARM-PROC-REQ-ID        PIC X(10).                           
                                                                        
       PROCEDURE DIVISION USING PARM-APPL-PROG-ID                       
                                PARM-USER-ID                            
                                PARM-PROC-REQ-ID.                       
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
                SELECT :S-RETURN-CODE             AS RETURN_CODE        
                      ,:S-APPL-RETURN-CODE        AS APPL_RETURN_CODE   
                      ,LTRIM(RTRIM(:S-PROC-REQ-ID))      AS PROC_REQ_ID        
                  FROM CIS.SYSDUMMY1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE             AS RETURN_CODE                
MFA-TR*               ,:S-APPL-RETURN-CODE        AS APPL_RETURN_CODE           
MFA-TR*               ,STRIP(:S-PROC-REQ-ID)      AS PROC_REQ_ID                
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-APPL-PROG-ID          TO WS-APPL-PROG-ID           
           MOVE PARM-USER-ID               TO WS-USER-ID                
           MOVE PARM-PROC-REQ-ID           TO 1P-PROC-REQ-ID            
                                              SF-PROC-REQ-ID            
                                              SA-PROC-REQ-ID            
                                              RT-PROC-REQ-ID            
A04177                                        WS-PROC-REQ-ID.           
                                                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
      *    GET PROCESS REQUEST DETAILS FROM CSS_PROCESS_REQ                     
           PERFORM 7100-GET-BUSINESS-PROC-REQ THRU 7100-EXIT.           
                                                                        
           MOVE 1P-COMPANY-NO              TO 6P-COMPANY-NO.            
           MOVE 1P-CODE-UTIL-TYPE          TO 6P-CODE-UTIL-TYPE         
                                              RT-CODE-UTIL-TYPE.        
           MOVE 1P-PROC-TYPE-CD            TO 6P-PROC-TYPE-CD.          
           MOVE 1P-STATUS-SEQ-NO           TO 6P-STATUS-SEQ-NO.         
           MOVE 1P-PROC-STATUS-CD          TO 6P-PROC-STATUS-CD.        
           MOVE WS-PROMOTE                 TO 6P-PROC-FLOW-IND.         
                                                                        
      *    GET RATE PLAN NO AND VERSION NO FROM CSS_RATE_CREATOR                
           PERFORM 7000-SELECT-RATE-CREATOR   THRU 7000-EXIT.           
           MOVE RT-CODE-UTIL-TYPE          TO SA-CODE-UTIL-TYPE.        
           MOVE RT-RATE-PLAN-NO            TO SA-RATE-PLAN-NO.          
                                                                        
                                                                        
           PERFORM 2100-VLDTE-LAST-BPR-STEP   THRU 2100-EXIT.           
           MOVE 1P-PROC-REQ-ID             TO S-PROC-REQ-ID.            
           ADD +1                          TO CTR-ROWS.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-VLDTE-LAST-BPR-STEP.                                      *        
      ******************************************************************        
       2100-VLDTE-LAST-BPR-STEP.                                        
                                                                        
           MOVE 6P-PROC-TYPE-CD             TO WS-PROCESS-TYPE-WIZARD.  
      *    DETERMINE IF IT IS THE LAST STEP IN THE UPDATE PROCESS               
           PERFORM 7200-GET-LAST-BRP-STEP-FLAG THRU 7200-EXIT.          
                                                                        
           IF WS-NOT-LAST-BPR-STEP                                      
              CONTINUE                                                  
           ELSE                                                         
              EVALUATE TRUE                                             
                  WHEN NEW-RATE-WIZARD                                  
                       PERFORM 2200-RATE-TMPLT-PROCESS  THRU 2200-EXIT  
                       PERFORM 8100-UPD-RATE-CREATOR    THRU 8100-EXIT  
                  WHEN NEW-RATE-PRICE-WIZARD                            
                       PERFORM 8100-UPD-RATE-CREATOR    THRU 8100-EXIT  
                  WHEN NEW-FACTOR-WIZARD                                
                       PERFORM 8200-UPD-SPCL-FACTOR     THRU 8200-EXIT  
                  WHEN NEW-FACTOR-PRICE-WIZARD                          
A04177                 PERFORM 2400-CALL-CSR04519       THRU 2400-EXIT  
                       MOVE WS-04519-RETURN-CODE TO S-RETURN-CODE       
                       MOVE WS-APPL-RETURN-CODE  TO S-APPL-RETURN-CODE  
              END-EVALUATE                                              
                                                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 100                   TO S-RETURN-CODE            
                 MOVE 290                   TO S-APPL-RETURN-CODE       
                 MOVE 1P-PROC-REQ-ID        TO S-PROC-REQ-ID            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09900019
      *                                                               * 09900019
      * 2200-RATE-TMPLT-PROCESS.                                      * 09900019
      ***************************************************************** 09900019
       2200-RATE-TMPLT-PROCESS.                                         
                                                                        
      *    INTEGRATED THE BELOW LOGIC FROM PARA 5150-SET-SPCL-FACTORS           
      *    OF CSR02219 WHEN VERSION CNTRL NO IS 1.                              
           IF RT-VERSION-NO-CNTRL  EQUAL 1                              
              MOVE WS-NO                        TO WS-NO-MORE-ROWS      
              PERFORM 7300-OPEN-SPCL-FCT-APPL-CUR  THRU 7300-EXIT       
              PERFORM 7400-FETCH-SPCL-FCT-APPL-CUR THRU 7400-EXIT       
              PERFORM 2300-SET-SPCL-FCTR-APPL      THRU 2300-EXIT       
                                                   UNTIL NO-MORE-ROWS   
              PERFORM 7500-CLOSE-SPCL-FCT-APPL-CUR THRU 7500-EXIT       
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09900019
      *                                                               * 09900019
      * 2300-SET-SPCL-FCTR-APPL.                                      * 09900019
      ***************************************************************** 09900019
       2300-SET-SPCL-FCTR-APPL.                                         
                                                                        
      *    WHEN SPCL FACTOR PRICE START DATE IS SAME AS EFFECTIVE DATE          
      *    AND SPCL FACTOR PRICE START DATE'S DAY IS NOT THE 1ST DAY OF         
      *    THE MONTH AND SPCL FACTOR PRICE'S VERS_PRORATE IS REVENUE            
      *    MONTH THEN WILL DELETE THE EXISTING ROW AND INSERT NEW ROW.          
           IF SA-DATE-FROM EQUAL RT-FROM-EFFECTIVE-DT                   
              IF SA-VERS-PRORATE-CD EQUAL WS-REVENUE-MONTH AND          
                                     SA-DATE-FROM(9:2) NOT EQUAL '01'   
                 PERFORM 8400-DELETE-SPCL-FCTR THRU 8400-EXIT           
                 MOVE RT-FROM-EFFECTIVE-DT   TO SA-DATE-FROM            
                 MOVE '01'                   TO SA-DATE-FROM(9:2)       
                 MOVE WS-ACTIVE              TO SA-CODE-STATUS          
                 MOVE PARM-USER-ID           TO SA-USER-ID-UPD-BY       
                 PERFORM 8500-INSERT-SPCL-FCTR  THRU 8500-EXIT          
              ELSE                                                      
                 PERFORM 8600-UPDATE-SPCL-FCTR  THRU 8600-EXIT          
              END-IF                                                    
           ELSE                                                         
      *       SPCL FACTOR PRICE START AND END DATE ARE LESS THAN                
      *       EFFECTIVE DATE,DELETE THE SPCL FCTR ROW.                          
              IF SA-DATE-FROM    <  RT-FROM-EFFECTIVE-DT AND            
                 SA-DATE-TO      <  RT-FROM-EFFECTIVE-DT                
                 PERFORM 8400-DELETE-SPCL-FCTR THRU 8400-EXIT           
              ELSE                                                      
                 PERFORM 8400-DELETE-SPCL-FCTR THRU 8400-EXIT           
                 MOVE WS-ACTIVE             TO SA-CODE-STATUS           
                 MOVE PARM-USER-ID          TO SA-USER-ID-UPD-BY        
                 IF SA-VERS-PRORATE-CD EQUAL WS-REVENUE-MONTH           
                    MOVE '01'               TO SA-DATE-FROM(9:2)        
                 END-IF                                                 
                 PERFORM 8500-INSERT-SPCL-FCTR THRU 8500-EXIT           
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7400-FETCH-SPCL-FCT-APPL-CUR THRU 7400-EXIT.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09900019
      *                                                               * 09900019
A04177* 2400-CALL-CSR04519.                                           * 09900019
A04177***************************************************************** 09900019
A04177 2400-CALL-CSR04519.                                              
A04177                                                                  
A04177*     EXEC SQL                                                    
A04177*         CALL CSR04519(:WS-APPL-PROG-ID,                         
A04177*                       :WS-USER-ID,                              
A04177*                       :WS-ACTION-CODE,                          
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       :WS-FACTOR,                               
A04177*                       ' ',                                      
A04177*                       :WS-ENTRY-NUMBER,                         
A04177*                       :WS-USER-ID,                              
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       ' ',                                      
A04177*                       :WS-BLOCK-NO,                             
A04177*                       ' ',                                      
A04177*                       :WS-PROC-REQ-ID,                          
A04177*                       ' ')                                      
A04177*     END-EXEC.                                                   

MSQ001        EXEC SQL
MSQ001          CLOSE UPDATE_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN UPDATE_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR UPDATE_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
A04177                                                                  
A04177     MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
A04177                                                                  
A04177     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
A04177        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
A04177        MOVE '2400'                    TO ACTIVE-PARAGRAPH        
A04177        MOVE 'DB2 SP CALL'             TO ABEND-FUNCTION          
A04177        MOVE 'CSR04519'                TO TABLE-1                 
A04177        MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
A04177        MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
A04177        MOVE 'PROC_REQ_ID'             TO TABLE-ELEMENT-2         
A04177        MOVE WS-PROC-REQ-ID            TO HOSTVAR-ELEMENT-2       
A04177        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A04177        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A04177     END-IF.                                                      
A04177                                                                  
A04177*    EXEC SQL                                                     
A04177*         ASSOCIATE LOCATORS                                      
A04177*         (:LOC-RESLTSET)                                         
A04177*         WITH PROCEDURE CSR04519                                 
A04177*    END-EXEC.                                                    
A04177*                                                                         
A04177*    EXEC SQL                                                     
A04177*      ALLOCATE UPDATE_CUR CURSOR FOR RESULT SET                  
A04177*      :LOC-RESLTSET                                              
A04177*    END-EXEC.                                                    
A04177*                                                                         
A04177     PERFORM 7600-FETCH-CSR04519      THRU 7600-EXIT              
A04177*                                                                         
A04177     EXEC SQL                                                     
A04177       CLOSE UPDATE_CUR                                           
A04177     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04177                                                                  
A04177     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A04177                                                                  
A04177     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A04177         CONTINUE                                                 
A04177     ELSE                                                         
A04177        MOVE '2400'                TO ACTIVE-PARAGRAPH            
A04177        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A04177        MOVE 'CLOSE'               TO ABEND-FUNCTION              
A04177        MOVE 'CSR04519'            TO TABLE-1                     
A04177        MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-1             
A04177        MOVE WS-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1           
A04177        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A04177        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A04177     END-IF.                                                      
A04177                                                                  
A04177 2400-EXIT.                                                       
A04177     EXIT.                                                        
A04177                                                                  
      ******************************************************************        
      *                                                                *        
      * 7000-SELECT-RATE-CREATOR.                                      *        
      ******************************************************************        
       7000-SELECT-RATE-CREATOR.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RT.CODE_UTIL_TYPE                                  
                    ,RT.RATE_PLAN_NO                                    
                    ,RT.VERSION_NO_CNTRL                                
                    ,RT.DATE_CREATED                                    
                    ,RT.FROM_EFFECTIVE_DT                               
                INTO :RT-CODE-UTIL-TYPE                                 
                    ,:RT-RATE-PLAN-NO                                   
                    ,:RT-VERSION-NO-CNTRL                               
                    ,:RT-DATE-CREATED                                   
                    ,:RT-FROM-EFFECTIVE-DT                              
                FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)                  
               WHERE RT.CODE_UTIL_TYPE  = :RT-CODE-UTIL-TYPE            
                 AND RT.PROC_REQ_ID     = :RT-PROC-REQ-ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RT.CODE_UTIL_TYPE                                          
MFA-TR*             ,RT.RATE_PLAN_NO                                            
MFA-TR*             ,RT.VERSION_NO_CNTRL                                        
MFA-TR*             ,RT.DATE_CREATED                                            
MFA-TR*             ,RT.FROM_EFFECTIVE_DT                                       
MFA-TR*         INTO :RT-CODE-UTIL-TYPE                                         
MFA-TR*             ,:RT-RATE-PLAN-NO                                           
MFA-TR*             ,:RT-VERSION-NO-CNTRL                                       
MFA-TR*             ,:RT-DATE-CREATED                                           
MFA-TR*             ,:RT-FROM-EFFECTIVE-DT                                      
MFA-TR*         FROM CSS_RATE_CREATOR RT                                        
MFA-TR*        WHERE RT.CODE_UTIL_TYPE  = :RT-CODE-UTIL-TYPE                    
MFA-TR*          AND RT.PROC_REQ_ID     = :RT-PROC-REQ-ID                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'PROC_REQ_ID'              TO TABLE-ELEMENT-1        
              MOVE RT-PROC-REQ-ID             TO HOSTVAR-ELEMENT-1      
              MOVE RT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-GET-BUSINESS-PROC-REQ.                                    *        
      ******************************************************************        
       7100-GET-BUSINESS-PROC-REQ.                                      
                                                                        
           EXEC SQL                                                     
              SELECT [1P].PROC_REQ_ID                                     
                    ,[1P].COMPANY_NO                                      
                    ,[1P].CODE_UTIL_TYPE                                  
                    ,[1P].PROC_TYPE_CD                                    
                    ,[1P].STATUS_SEQ_NO                                   
                    ,[1P].PROC_FLOW_IND                                   
                    ,[1P].PROC_STATUS_CD                                  
                INTO :1P-PROC-REQ-ID                                    
                    ,:1P-COMPANY-NO                                     
                    ,:1P-CODE-UTIL-TYPE                                 
                    ,:1P-PROC-TYPE-CD                                   
                    ,:1P-STATUS-SEQ-NO                                  
                    ,:1P-PROC-FLOW-IND                                  
                    ,:1P-PROC-STATUS-CD                                 
                FROM CSS_PROCESS_REQ   [1P] WITH(READUNCOMMITTED)               
               WHERE [1P].PROC_REQ_ID = :1P-PROC-REQ-ID                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 1P.PROC_REQ_ID                                             
MFA-TR*             ,1P.COMPANY_NO                                              
MFA-TR*             ,1P.CODE_UTIL_TYPE                                          
MFA-TR*             ,1P.PROC_TYPE_CD                                            
MFA-TR*             ,1P.STATUS_SEQ_NO                                           
MFA-TR*             ,1P.PROC_FLOW_IND                                           
MFA-TR*             ,1P.PROC_STATUS_CD                                          
MFA-TR*         INTO :1P-PROC-REQ-ID                                            
MFA-TR*             ,:1P-COMPANY-NO                                             
MFA-TR*             ,:1P-CODE-UTIL-TYPE                                         
MFA-TR*             ,:1P-PROC-TYPE-CD                                           
MFA-TR*             ,:1P-STATUS-SEQ-NO                                          
MFA-TR*             ,:1P-PROC-FLOW-IND                                          
MFA-TR*             ,:1P-PROC-STATUS-CD                                         
MFA-TR*         FROM CSS_PROCESS_REQ   1P                                       
MFA-TR*        WHERE 1P.PROC_REQ_ID = :1P-PROC-REQ-ID                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PROCESS_REQ'          TO TABLE-1                
              MOVE 'PROC_REQ_ID'              TO TABLE-ELEMENT-1        
              MOVE 1P-PROC-REQ-ID             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-GET-LAST-BRP-STEP-FLAG.                                   *        
      ******************************************************************        
       7200-GET-LAST-BRP-STEP-FLAG.                                     
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
                INTO :WS-LAST-BRP-STEP-FLAG                             
                FROM CSS_PROCESS_CNTRL [6P] WITH(READUNCOMMITTED)               
               WHERE [6P].COMPANY_NO         = :6P-COMPANY-NO             
                 AND [6P].CODE_UTIL_TYPE     = :6P-CODE-UTIL-TYPE         
                 AND [6P].PROC_TYPE_CD       = :6P-PROC-TYPE-CD           
                 AND [6P].STATUS_SEQ_NO      > :6P-STATUS-SEQ-NO          
                 AND [6P].PROC_FLOW_IND      = :6P-PROC-FLOW-IND          
               ORDER BY [6P].STATUS_SEQ_NO                                
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ026
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-LAST-BRP-STEP-FLAG                                     
MFA-TR*         FROM CSS_PROCESS_CNTRL 6P                                       
MFA-TR*        WHERE 6P.COMPANY_NO         = :6P-COMPANY-NO                     
MFA-TR*          AND 6P.CODE_UTIL_TYPE     = :6P-CODE-UTIL-TYPE                 
MFA-TR*          AND 6P.PROC_TYPE_CD       = :6P-PROC-TYPE-CD                   
MFA-TR*          AND 6P.STATUS_SEQ_NO      > :6P-STATUS-SEQ-NO                  
MFA-TR*          AND 6P.PROC_FLOW_IND      = :6P-PROC-FLOW-IND                  
MFA-TR*        ORDER BY 6P.STATUS_SEQ_NO                                        
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE      TO WS-ACTIVE-RETURN-CODE.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PROCESS_CNTRL'        TO TABLE-1                
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'PROC_TYPE_CD'             TO TABLE-ELEMENT-3        
              MOVE 'STATUS_SEQ_NO'            TO TABLE-ELEMENT-4        
              MOVE 6P-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 6P-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE 6P-PROC-TYPE-CD            TO HOSTVAR-ELEMENT-3      
              MOVE 6P-STATUS-SEQ-NO           TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7300-OPEN-SPCL-FCT-APPL-CUR.                                  *         
      *****************************************************************         
       7300-OPEN-SPCL-FCT-APPL-CUR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN SPCL_FCTR_APPL_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE SA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7400-FETCH-SPCL-FCT-APPL-CUR.                                *          
      *****************************************************************         
       7400-FETCH-SPCL-FCT-APPL-CUR.                                    
                                                                        
           EXEC SQL                                                     
               FETCH SPCL_FCTR_APPL_CSR                                 
                INTO :SA-FACTOR-ID                                      
                    ,:SA-ENTRY-NO                                       
                    ,:SA-CMPNT-ID-CD                                    
                    ,:SA-CODE-SEASON                                    
                    ,:SA-INSTR-USE-TYPE-CD                              
                    ,:SA-CODE-TIME-PERIOD                               
                    ,:SA-CODE-REVENUE-CLASS                             
                    ,:SA-FACTOR                                         
                    ,:SA-VERS-PRORATE-CD                                
                    ,:SA-DATE-FROM :WS-NULL-IND-01                       
                    ,:SA-DATE-TO :WS-NULL-IND-02                         
                    ,:SA-BLOCK-NO                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND-01 EQUAL WS-YES-NULL                 
                       MOVE SPACES           TO SA-DATE-FROM            
                    END-IF                                              
                    IF WS-NULL-IND-02 EQUAL WS-YES-NULL                 
                        MOVE SPACES          TO SA-DATE-TO              
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ROWS         
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7400'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE 'CSS_SPCL_FCTR_APPL'TO TABLE-1                 
                    MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-1         
                    MOVE 'RATE_PLAN_NO'      TO TABLE-ELEMENT-2         
                    MOVE SA-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-1       
                    MOVE SA-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-2       
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7500-CLOSE-SPCL-FCT-APPL-CUR.                                 *         
      *****************************************************************         
       7500-CLOSE-SPCL-FCT-APPL-CUR.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE SPCL_FCTR_APPL_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE SA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04177******************************************************************        
A04177* 7600-FETCH-CSR04519                                            *        
A04177******************************************************************        
A04177 7600-FETCH-CSR04519.                                             
A04177                                                                  
A04177     EXEC SQL                                                     
A04177       FETCH UPDATE_CUR                                           
A04177        INTO  :WS-04519-RETURN-CODE                               
A04177             ,:WS-APPL-RETURN-CODE                                
A04177             ,:WS-ENTRY-NO                                        
A04177             ,:WS-DELETE-BPR                                      
A04177     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04177                                                                  
A04177     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
A04177                                                                  
A04177     EVALUATE WS-ACTIVE-RETURN-CODE                               
A04177         WHEN SUCCESSFUL-CALL                                     
A04177              IF WS-04519-RETURN-CODE = 0                         
A04177                 CONTINUE                                         
A04177              ELSE                                                
A04177                 MOVE WS-04519-RETURN-CODE                        
A04177                                         TO WS-ACTIVE-RETURN-CODE 
A04177                 MOVE '7600'             TO ACTIVE-PARAGRAPH      
A04177                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM         
A04177                 MOVE 'FETCH'            TO ABEND-FUNCTION        
A04177                 MOVE 'CSR04519'         TO TABLE-1               
A04177                 MOVE WS-PROC-REQ-ID     TO HOSTVAR-ELEMENT-1     
A04177                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT    
A04177                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT    
A04177              END-IF                                              
A04177         WHEN NOT-FOUND                                           
A04177              MOVE 0                     TO WS-ACTIVE-RETURN-CODE 
A04177         WHEN OTHER                                               
A04177              MOVE '7600'                TO ACTIVE-PARAGRAPH      
A04177              MOVE PROGRAM-NAME          TO ABEND-PROGRAM         
A04177              MOVE 'FETCH'               TO ABEND-FUNCTION        
A04177              MOVE 'CSR04519'            TO TABLE-1               
A04177              MOVE WS-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1     
A04177              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
A04177              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
A04177     END-EVALUATE.                                                
A04177                                                                  
A04177 7600-EXIT.                                                       
A04177     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8100-UPD-RATE-CREATOR                                          *        
      ******************************************************************        
       8100-UPD-RATE-CREATOR.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE RT                                 
                 SET RT.CODE_STATUS   = 'A'                             
              FROM CSS_RATE_CREATOR RT
               WHERE RT.PROC_REQ_ID   = :RT-PROC-REQ-ID                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_RATE_CREATOR  RT                                       
MFA-TR*          SET RT.CODE_STATUS   = 'A'                                     
MFA-TR*        WHERE RT.PROC_REQ_ID   = :RT-PROC-REQ-ID                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '8100'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_CREATOR'         TO TABLE-1                
              MOVE 'PROC_REQ_ID'              TO TABLE-ELEMENT-1        
              MOVE RT-PROC-REQ-ID             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8200-UPD-SPCL-FACTOR.                                          *        
      ******************************************************************        
       8200-UPD-SPCL-FACTOR.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE SF                                    
                 SET SF.CODE_STATUS   = 'A'                             
              FROM CSS_SPCL_FCTR SF
               WHERE SF.PROC_REQ_ID   = :SF-PROC-REQ-ID                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ019
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SPCL_FCTR  SF                                          
MFA-TR*          SET SF.CODE_STATUS   = 'A'                                     
MFA-TR*        WHERE SF.PROC_REQ_ID   = :SF-PROC-REQ-ID                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE          TO WS-ACTIVE-RETURN-CODE.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE '8200'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'UPDATE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'PROC_REQ_ID'              TO TABLE-ELEMENT-1        
              MOVE SF-PROC-REQ-ID             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8400-DELETE-SPCL-FCTR.                                        *         
      *****************************************************************         
       8400-DELETE-SPCL-FCTR.                                           
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_SPCL_FCTR_APPL                          
                 WHERE CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE              
                   AND RATE_PLAN_NO   = :SA-RATE-PLAN-NO                
                   AND FACTOR_ID      = :SA-FACTOR-ID                   
                   AND DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )                   
                   AND ENTRY_NO       = :SA-ENTRY-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_SPCL_FCTR_APPL                                  
MFA-TR*          WHERE CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                      
MFA-TR*            AND RATE_PLAN_NO   = :SA-RATE-PLAN-NO                        
MFA-TR*            AND FACTOR_ID      = :SA-FACTOR-ID                           
MFA-TR*            AND DATE_FROM      = :SA-DATE-FROM                           
MFA-TR*            AND ENTRY_NO       = :SA-ENTRY-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-3         
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-4         
              MOVE SA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-3       
              MOVE SA-DATE-FROM              TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8500-INSERT-SPCL-FCTR.                                        *         
      *****************************************************************         
       8500-INSERT-SPCL-FCTR.                                           
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_SPCL_FCTR_APPL                          
                     (                                                  
                       CODE_UTIL_TYPE                                   
                      ,RATE_PLAN_NO                                     
                      ,FACTOR_ID                                        
                      ,DATE_FROM                                        
                      ,ENTRY_NO                                         
                      ,DATE_TO                                          
                      ,CMPNT_ID_CD                                      
                      ,CODE_SEASON                                      
                      ,INSTR_USE_TYPE_CD                                
                      ,CODE_TIME_PERIOD                                 
                      ,CODE_REVENUE_CLASS                               
                      ,FACTOR                                           
                      ,CODE_STATUS                                      
                      ,USER_ID_UPD_BY                                   
                      ,VERS_PRORATE_CD                                  
                      ,BLOCK_NO                                         
                     )                                                  
                     VALUES                                             
                     (                                                  
                       :SA-CODE-UTIL-TYPE                               
                      ,:SA-RATE-PLAN-NO                                 
                      ,:SA-FACTOR-ID                                    
                      ,IIF(TRY_CONVERT(DATE, :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )                                
                      ,:SA-ENTRY-NO                                     
                      ,IIF(TRY_CONVERT(DATE, :SA-DATE-TO :WS-NULL-IND-02
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO :WS-NULL-IND-02
              ) <> 0) OR (LEN(:SA-DATE-TO :WS-NULL-IND-02
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO :WS-NULL-IND-02
              ), CONVERT(DATE, :SA-DATE-TO :WS-NULL-IND-02) )                  
                      ,:SA-CMPNT-ID-CD                                  
                      ,:SA-CODE-SEASON                                  
                      ,:SA-INSTR-USE-TYPE-CD                            
                      ,:SA-CODE-TIME-PERIOD                             
                      ,:SA-CODE-REVENUE-CLASS                           
                      ,:SA-FACTOR                                       
                      ,:SA-CODE-STATUS                                  
                      ,:SA-USER-ID-UPD-BY                               
                      ,:SA-VERS-PRORATE-CD                              
                      ,:SA-BLOCK-NO                                     
                     )                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_SPCL_FCTR_APPL                                  
MFA-TR*              (                                                          
MFA-TR*                CODE_UTIL_TYPE                                           
MFA-TR*               ,RATE_PLAN_NO                                             
MFA-TR*               ,FACTOR_ID                                                
MFA-TR*               ,DATE_FROM                                                
MFA-TR*               ,ENTRY_NO                                                 
MFA-TR*               ,DATE_TO                                                  
MFA-TR*               ,CMPNT_ID_CD                                              
MFA-TR*               ,CODE_SEASON                                              
MFA-TR*               ,INSTR_USE_TYPE_CD                                        
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,CODE_REVENUE_CLASS                                       
MFA-TR*               ,FACTOR                                                   
MFA-TR*               ,CODE_STATUS                                              
MFA-TR*               ,USER_ID_UPD_BY                                           
MFA-TR*               ,VERS_PRORATE_CD                                          
MFA-TR*               ,BLOCK_NO                                                 
MFA-TR*              )                                                          
MFA-TR*              VALUES                                                     
MFA-TR*              (                                                          
MFA-TR*                :SA-CODE-UTIL-TYPE                                       
MFA-TR*               ,:SA-RATE-PLAN-NO                                         
MFA-TR*               ,:SA-FACTOR-ID                                            
MFA-TR*               ,:SA-DATE-FROM                                            
MFA-TR*               ,:SA-ENTRY-NO                                             
MFA-TR*               ,:SA-DATE-TO:WS-NULL-IND-02                               
MFA-TR*               ,:SA-CMPNT-ID-CD                                          
MFA-TR*               ,:SA-CODE-SEASON                                          
MFA-TR*               ,:SA-INSTR-USE-TYPE-CD                                    
MFA-TR*               ,:SA-CODE-TIME-PERIOD                                     
MFA-TR*               ,:SA-CODE-REVENUE-CLASS                                   
MFA-TR*               ,:SA-FACTOR                                               
MFA-TR*               ,:SA-CODE-STATUS                                          
MFA-TR*               ,:SA-USER-ID-UPD-BY                                       
MFA-TR*               ,:SA-VERS-PRORATE-CD                                      
MFA-TR*               ,:SA-BLOCK-NO                                             
MFA-TR*              )                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                                  OR ALREADY-EXISTS     
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8700'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-3         
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-4         
              MOVE SA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-3       
              MOVE SA-DATE-FROM              TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8600-UPDATE-SPCL-FCTR.                                        *         
      *****************************************************************         
       8600-UPDATE-SPCL-FCTR.                                           
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_SPCL_FCTR_APPL                               
                   SET CODE_STATUS = 'A'                                
                 WHERE CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE              
                   AND RATE_PLAN_NO   = :SA-RATE-PLAN-NO                
                   AND FACTOR_ID      = :SA-FACTOR-ID                   
                   AND DATE_FROM      = IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )                   
                   AND ENTRY_NO       = :SA-ENTRY-NO                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_SPCL_FCTR_APPL                                       
MFA-TR*            SET CODE_STATUS = 'A'                                        
MFA-TR*          WHERE CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                      
MFA-TR*            AND RATE_PLAN_NO   = :SA-RATE-PLAN-NO                        
MFA-TR*            AND FACTOR_ID      = :SA-FACTOR-ID                           
MFA-TR*            AND DATE_FROM      = :SA-DATE-FROM                           
MFA-TR*            AND ENTRY_NO       = :SA-ENTRY-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCTR_APPL'      TO TABLE-1                 
              MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-1         
              MOVE 'RATE_PLAN_NO'            TO TABLE-ELEMENT-2         
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-3         
              MOVE 'DATE_FROM'               TO TABLE-ELEMENT-4         
              MOVE SA-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-1       
              MOVE SA-RATE-PLAN-NO           TO HOSTVAR-ELEMENT-2       
              MOVE SA-FACTOR-ID              TO HOSTVAR-ELEMENT-3       
              MOVE SA-DATE-FROM              TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
