       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04435.                                     
COB303 DATE-WRITTEN.     APRIL 22, 2011.                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04435              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04435 :                                                --         
      *--                                                            --         
      *--     REALITY VIEW OF OFFER/OPTION/PROMOTION/TIER RANK       --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *-- SPECIAL NOTE : ANY TIME WE MAKE CHANGES TO CSR04005, WE    --         
      *-- NEED TO ANALYZE THIS PROGRAM FOR THE RESPECTIVE CHANGES.   --         
      *----------------------------------------------------------------         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             APPLICATION_ID      CHAR(03)                   --         
      *--             USER_ID             CHAR(07)                   --         
      *--             OFFER_CD            CHAR(12)                   --         
      *--             OPTION_CD           CHAR(12)                   --         
      *--             PROMO_CD            CHAR(12)                   --         
      *--             TIER_RANKING        INTEGER                    --         
      *--             CUST_STAT_CODE      CHAR(01)                   --         
      *--             ACCT_TYPE_CD        CHAR(01)                   --         
      *--             REALITY_TS          CHAR(26)                   --         
      *--             SECURE_CATEGORY     INTEGER                    --         
      *--             COMPANY_NO          CHAR(02)                   --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1. CSR04435_R1 - OFFER MKT TIER DETAILS               --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           TIER_CUST_STAT_CD       CHAR(01)                 --         
      *--           TIER_ACCT_TYPE_CD       CHAR(01)                 --         
      *--           MKT_TIER_RANKING        SMALLINT                 --         
      *--           MKT_TIER_START_DT       CHAR(10)                 --         
      *--           OFFER_TIER_STRT_DT      CHAR(10)                 --         
      *--           MKT_TIER_APPLY_CD       CHAR(01)                 --         
      *--           TIER_DEFLT_OFFR_CD      CHAR(01)                 --         
      *--           OFFER_TIER_END_DT       CHAR(10)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           OFF_TIER_VRSN_NO        SMALLINT                 --         
      *--           OFF_TIER_VSTART_TS      CHAR(26)                 --         
      *--           OFF_TIER_VEND_TS        CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--                                                            --         
      *--      2. CSR04435_R2 - OFFER DETAILS                        --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           OFFER_DESC_INT          CHAR(50)                 --         
      *--           OFFER_DESC_EXT          CHAR(50)                 --         
      *--           PROMO_CD_INT_FL         CHAR(01)                 --         
      *--           PROMO_CD_EXT_FL         CHAR(01)                 --         
      *--           OFFER_START_DT          CHAR(10)                 --         
      *--           OFFER_END_DT            CHAR(10)                 --         
      *--           DISP_START_INT_TS       CHAR(26)                 --         
      *--           DISP_END_INT_TS         CHAR(26)                 --         
      *--           DISP_START_EXT_TS       CHAR(26)                 --         
      *--           DISP_END_EXT_TS         CHAR(26)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           OFFER_DESC_INT_LNG      VARCHAR(255)             --         
      *--           OFFER_DESC_EXT_LNG      VARCHAR(255)             --         
      *--           SPCL_OFFER_TYPE_CD      CHAR(02)                 --         
      *--           RENEWAL_OFFER_CD        CHAR(12)                 --         
      *--           RENEW_PUB_OFFER_CD      CHAR(01)                 --         
      *--           OFF_VRSN_NO             SMALLINT                 --         
      *--           OFF_VSTART_TS           CHAR(26)                 --         
      *--           OFF_VEND_TS             CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--           TIER_CUST_STAT_CD_DU    CHAR(01)                 --         
      *--           TIER_ACCT_TYPE_CD_DU    CHAR(01)                 --         
      *--           MKT_TIER_RANKING_DU     SMALLINT                 --         
      *--           MKT_TIER_START_DT_DU    CHAR(10)                 --         
PRJ680*--           MAX_PRICE_OFFER_CD      CHAR(12)                 --         
PRJ892*--           RTCHG_PUB_OFFER_CD      CHAR(12)                 --         
      *--                                                            --         
      *--    3. CSR04435_R3  OPTION DETAILS                          --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           CODE_UTIL_TYPE          CHAR(01)                 --         
      *--           RATE_PLAN_NO            CHAR(03)                 --         
      *--           OPTION_START_DT         CHAR(10)                 --         
      *--           OPTION_END_DT           CHAR(10)                 --         
      *--           OPT_DESC_INT            CHAR(50)                 --         
      *--           OPT_DESC_INT_LONG       VARCHAR(255)             --         
      *--           CURR_EXT_DESC_LONG      VARCHAR(255)             --         
      *--           RENEWAL_DESC_LONG       VARCHAR(255)             --         
      *--           WEB_DESC_LONG           VARCHAR(255)             --         
      *--           STATUS_CD               CHAR(01)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           OPT_CALC_TYPE_CD        CHAR(02)                 --         
      *--           WEB_MKT_DESC_LONG       VARCHAR(1024)            --         
      *--           OPT_VRSN_NO             SMALLINT                 --         
      *--           OPT_VSTART_TS           CHAR(26)                 --         
      *--           OPT_VEND_TS             CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--           TIER_CUST_STAT_CD_DU    CHAR(01)                 --         
      *--           TIER_ACCT_TYPE_CD_DU    CHAR(01)                 --         
      *--           MKT_TIER_RANKING_DU     SMALLINT                 --         
      *--           MKT_TIER_START_DT_DU    CHAR(10)                 --         
      *--           OFFER_CD_DU             CHAR(12)                 --         
PRJ892*--           AUTO_RENEWAL_FL         CHAR(01)                 --         
PRJ892*--           OPTION_PROMO_DESC       VARCHAR(255)             --         
      *--                                                            --         
      *--    4. CSR04435_R4 - OPT ATTRB INCENTIVE DETAILS            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           ATTR_INCTV_SEQ_NO       SMALLINT                 --         
      *--           RT_ATTR_INCTV_TYPE      CHAR(15)                 --         
      *--           PRIMRY_OPT_ATTR_FL      CHAR(01)                 --         
      *--           FACTOR_ID               CHAR(09)                 --         
      *--           DURATION_NO             SMALLINT                 --         
      *--           APPL_PROGRAM_ID         CHAR(09)                 --         
      *--           ATTR_INCTV_VALUE        DECIMAL(11,6)            --         
      *--           ATTR_INCTV_VAL_TX       CHAR(20)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           GL_ACCT_CREDIT          DECIMAL(7,4)             --         
      *--           GL_ACCT_DEBIT           DECIMAL(7,4)             --         
      *--           CATEGORY_ID             SMALLINT                 --         
      *--           WQ_ROUTE_CATEGORY       CHAR(01)                 --         
      *--           OPT_CHG_ACTION_CD       CHAR(01)                 --         
      *--           ATTR_INCTV_STRT_DT      CHAR(10)                 --         
      *--           ATTR_INCTV_END_DT       CHAR(10)                 --         
      *--           OPT_ATTR_VRSN_NO        SMALLINT                 --         
      *--           OPT_ATTR_VSTART_TS      CHAR(26)                 --         
      *--           OPT_ATTR_VEND_TS        CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--           TIER_CUST_STAT_CD_DU    CHAR(01)                 --         
      *--           TIER_ACCT_TYPE_CD_DU    CHAR(01)                 --         
      *--           MKT_TIER_RANKING_DU     SMALLINT                 --         
      *--           MKT_TIER_START_DT_DU    CHAR(10)                 --         
      *--           OFFER_CD_DU             CHAR(12)                 --         
      *--                                                            --         
      *--    5. CSR04435_R5 - PROMOTION DETAILS                      --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           PROMO_CD                CHAR(12)                 --         
      *--           PROMO_DESC              CHAR(50)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           MKT_PLAN_CD             CHAR(12)                 --         
      *--           PROMO_START_DT          CHAR(10)                 --         
      *--           PROMO_START_TM          CHAR(08)                 --         
      *--           PROMO_END_DT            CHAR(10)                 --         
      *--           PROMO_END_TM            CHAR(08)                 --         
      *--           AD_CHANNEL_CD           CHAR(10)                 --         
      *--           PROMO_DESC_LONG         VARCHAR(255)             --         
      *--           EXT_LANDING_PG_URL      VARCHAR(255)             --         
      *--           PROMO_TYPE_CD           CHAR(02)                 --         
      *--           WEB_IMAGE_FILE_NM       VARCHAR(100)             --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           REPLACMNT_PROMO_CD      CHAR(12)                 --         
      *--           DISPLAY_END_DT          CHAR(10)                 --         
      *--           INT_LANDING_PG_URL      VARCHAR(255)             --         
      *--           PROMO_VRSN_NO           SMALLINT                 --         
      *--           PROMO_VSTART_TS         CHAR(26)                 --         
      *--           PROMO_VEND_TS           CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(2)                  --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--           TIER_CUST_STAT_CD_DU    CHAR(01)                 --         
      *--           TIER_ACCT_TYPE_CD_DU    CHAR(01)                 --         
      *--           MKT_TIER_RANKING_DU     SMALLINT                 --         
      *--           MKT_TIER_START_DT_DU    CHAR(10)                 --         
      *--                                                            --         
      *--    6. CSR04435_R6 - RATE GROUP OFFER DETAILS               --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           RATE_GROUP_TYPE_CD      CHAR(01)                 --         
      *--           RATE_GROUP_CD           CHAR(02)                 --         
      *--           SORT_SEQ_NO             SMALLINT                 --         
      *--           EFF_START_DT            CHAR(10)                 --         
      *--           EFF_END_DT              CHAR(10)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           GRP_OFF_VRSN_NO         SMALLINT                 --         
      *--           GRP_OFF_VSTART_TS       CHAR(26)                 --         
      *--           GRP_OFF_VEND_TS         CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--           TIER_CUST_STAT_CD_DU    CHAR(01)                 --         
      *--           TIER_ACCT_TYPE_CD_DU    CHAR(01)                 --         
      *--           MKT_TIER_RANKING_DU     SMALLINT                 --         
      *--           MKT_TIER_START_DT_DU    CHAR(10)                 --         
      *--                                                            --         
      *--    7. CSR04435_R7 - OFFER OPTION DETAILS                   --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(2)                  --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           OPTION_SORT_SEQ_NO      SMALLINT                 --         
      *--           OPTION_URL_TX           VARCHAR(255)             --         
      *--           DROP_OPTION_CD          CHAR(1)                  --         
      *--           OFFER_OPT_START_DT      CHAR(10)                 --         
      *--           OFFER_OPT_END_DT        CHAR(10)                 --         
      *--           OFF_OPT_VRSN_NO         SMALLINT                 --         
      *--           OFF_OPT_VSTART_TS       CHAR(26)                 --         
      *--           OFF_OPT_VEND_TS         CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(2)                  --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00473*--  05/27/2011    MN90523     REALITY VIEW OF CRM TABLES      --         
      *--  02/12/2012    JC91900     Fix issues.                     --         
PRJ680*--  02/16/2013    MS93554     A new column MAX_PRICE_OFFER_CD --         
      *--                            has been added into CRM table   --         
      *--                            CRM_RT_PKG_OFFER.               --         
PRJ892*--  07/14/2015    SS95855     NEW COLUMNs added to            --         
      *                              CRM_RT_PKG_OPTION &             --         
      *                              CRM_RT_PKG_OFFER.               --         
ACT006*--  01/13/2017    TP7R341     REPLACE CSS NAVIGATION          --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04435'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04435 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04435'. 
           05  WS-CRM-SECURITY-ALL          PIC X(40) VALUE             
                                'CRM_RATE_SELECTION_RATE_SECURITY_ALL'. 
           05  WS-PRP-DEFAULT-TIER          PIC X(20) VALUE             
                                                    'PRP-DEFAULT-TIER'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS5                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS6                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS7                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-REALITY-TS                PIC X(26) VALUE SPACES.     
           05  WS-REALITY-DT                PIC X(10) VALUE SPACES.     
           05  WS-MIN-TIER-RANKING          PIC S9(04) COMP VALUE 0.    
           05  WS-MAX-TIER-RANKING          PIC S9(04) COMP VALUE 0.    
           05  WS-SECURE-CATEGORY           PIC S9(04) COMP VALUE 0.    
ACT006     05  WS-SUPER-USER-CATEGORY       PIC S9(04) COMP VALUE 346.  
           05  WS-SECURE-FLAG               PIC X(01) VALUE 'N'.        
           05  WS-PROMO-CD                  PIC X(12) VALUE SPACES.     
           05  WS-PROMO-CD-FLAG             PIC X(01) VALUE 'N'.        
           05  WS-TIER-CUST-STAT-CD         PIC X(01) VALUE SPACES.     
           05  WS-TIER-CUST-STAT-FLAG       PIC X(01) VALUE 'N'.        
           05  WS-PREV-TIER-CUST-STAT-CD    PIC X(01) VALUE SPACES.     
           05  WS-PREV-TIER-ACCT-TYPE-CD    PIC X(01) VALUE SPACES.     
           05  WS-PREV-MKT-TIER-RANKING     PIC S9(04) COMP VALUE 0.    
           05  WS-PREV-MKT-TIER-START-DT    PIC X(10) VALUE SPACES.     
           05  WS-PREV-OFFER-CD             PIC X(12) VALUE SPACES.     
           05  WS-MKT-TIER-RANKING          PIC S9(04) COMP VALUE 0.    
           05  WS-TIER-ACCT-TYPE-CD         PIC X(01) VALUE SPACES.     
           05  WS-APPLICATION-ID            PIC X(03) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(04) VALUE 0.         
           05  WS-USER-ID                   PIC X(07) VALUE SPACES.     
           05  WS-SECURE-OFF-OPT-TABLE OCCURS 100 TIMES                 
                                       INDEXED BY WS-SEC-TAB-INDX.      
               10 WS-SEC-OFFER              PIC X(12).                  
               10 WS-SEC-OPTION             PIC X(12).                  
               10 WS-SEC-VIEW-APPLY-CD      PIC X(01).                  
               10 WS-SEC-CATEGORY-ID        PIC S9(09) COMP VALUE 0.    
           05  WS-ACCESS-FLAG               PIC X(01) VALUE SPACES.     
           05  WS-CHECK-OFFER               PIC X(12) VALUE SPACES.     
           05  WS-CHECK-OPTION              PIC X(12) VALUE SPACES.     
           05  WS-SUPER-USER-FLAG           PIC X(01) VALUE 'N'.        
           05  WS-PRP-TIER-RANK-FL          PIC X(01) VALUE 'N'.        
           05  WS-PRP-TIER-RANK             PIC S9(04) COMP VALUE 0.    
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.        
              88 NO-MORE-ROWS                         VALUE 'Y'.        
           05 WS-NO-OFFER-OPTIONS           PIC X(01) VALUE 'N'.        
              88 NO-OFFER-OPTIONS                     VALUE 'Y'.        
           05 WS-NO-MORE-RTGRP-OFFR-ROWS    PIC X(01) VALUE 'N'.        
              88 NO-MORE-RTGRP-OFFR-ROWS              VALUE 'Y'.        
           05 WS-SECURE-OFFER-SW            PIC X(01) VALUE 'N'.        
              88 SECURE-OFFER                         VALUE 'Y'.        
              88 OFFER-NOT-SECURE                     VALUE 'N'.        
           05 WS-SECURE-OPTION-SW           PIC X(01) VALUE 'N'.        
              88 SECURE-OPTION                        VALUE 'Y'.        
              88 OPTION-NOT-SECURE                    VALUE 'N'.        
           05 WS-HAS-SECURITY               PIC X(01) VALUE 'N'.        
              88 HAS-SECURITY                         VALUE 'Y'.        
           05 WS-OPTION-FOUND               PIC X(01) VALUE 'N'.        
              88 OPTION-FOUND                         VALUE 'Y'.        
           05 WS-PROCESS-OFFER              PIC X(01) VALUE 'N'.        
              88 PROCESS-OFFER                        VALUE 'Y'.        
           05 WS-PROMOTION-FOUND            PIC X(01) VALUE 'N'.        
              88 PROMOTION-FOUND                      VALUE 'Y'.        
           05 WS-DISPLAY-OFFER-SW           PIC X(01) VALUE 'N'.        
              88 DISPLAY-OFFER                        VALUE 'Y'.        
           05 WS-DISPLAY-OPTION-SW          PIC X(01) VALUE 'N'.        
              88 DISPLAY-OPTION                       VALUE 'Y'.        
           05 WS-SUPER-USER-SW              PIC X(01) VALUE 'N'.        
              88 SUPER-USER                           VALUE 'Y'.        
           05 WS-OK-TO-DISPLAY              PIC X(01) VALUE 'N'.        
              88 OK-TO-DISPLAY                        VALUE 'Y'.        
      *                                                                         
       01  WS-FLAGS.                                                    
           05 WS-ERR-INSRT-R1               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R2               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R3               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R5               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R6               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R7               PIC X(01) VALUE 'N'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                  PIC S9(04)  COMP VALUE 0.   
      *************************************************************             
      *      LATYOUT FOR OFF MKT TIER- CRM_OFF_MKT_TIER           *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1            PIC S9(04) COMP VALUE 0.     
             10 S-APPL-RETURN-CODE-1       PIC S9(04) COMP VALUE 0.     
             10 S-RS1-COMPANY-NO           PIC X(02).                   
             10 S-RS1-OFFER-CD             PIC X(12).                   
             10 S-RS1-TIER-CUST-STAT-CD    PIC X(01).                   
             10 S-RS1-TIER-ACCT-TYPE-CD    PIC X(01).                   
             10 S-RS1-MKT-TIER-RANKING     PIC S9(4) USAGE COMP.        
             10 S-RS1-MKT-TIER-START-DT    PIC X(10).                   
             10 S-RS1-MKT-TIER-DESC        PIC X(50).                   
             10 S-RS1-MKT-TIER-END-DT      PIC X(10).                   
             10 S-RS1-TIER-OFFER-VIEW      PIC S9(04) USAGE COMP.       
             10 S-RS1-OFFER-TIER-STRT-DT   PIC X(10).                   
             10 S-RS1-MKT-TIER-APPLY-CD    PIC X(01).                   
             10 S-RS1-TIER-DEFLT-OFFR-CD   PIC X(01).                   
             10 S-RS1-OFFER-TIER-END-DT    PIC X(10).                   
             10 S-RS1-CUST-ACCT-DEFLT-FL   PIC X(01).                   
             10 S-RS1-MKT-TIER-DESC-LONG.                               
                49 IG-MKT-TIER-DESC-LONG-LEN                            
                                           PIC S9(4) USAGE COMP.        
                49 IG-MKT-TIER-DESC-LONG-TEXT                           
                                           PIC X(255).                  
             10 S-RS1-LAST-UPDATE-USERID   PIC X(7).                    
             10 S-RS1-LAST-UPDATE-TS       PIC X(26).                   
             10 S-RS1-OFF-TIER-VRSN-NO     PIC S9(4) USAGE COMP.        
             10 S-RS1-OFF-TIER-VSTART-TS   PIC X(26).                   
             10 S-RS1-OFF-TIER-VEND-TS     PIC X(26).                   
             10 S-RS1-PROC-STATUS-CD       PIC X(2).                    
COB305       10 S-RS1-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.    
                                                                        
      *************************************************************             
      *      LATYOUT FOR OFFER TABLE - CRM_RT_PKG_OFFER           *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-COMPANY-NO            PIC X(2).                   
             10 S-RS2-OFFER-CD              PIC X(12).                  
             10 S-RS2-OFFER-DESC-INT        PIC X(50).                  
             10 S-RS2-OFFER-DESC-EXT        PIC X(50).                  
             10 S-RS2-PROMO-CD-INT-FL       PIC X(1).                   
             10 S-RS2-PROMO-CD-EXT-FL       PIC X(1).                   
             10 S-RS2-OFFER-START-DT        PIC X(10).                  
             10 S-RS2-OFFER-END-DT          PIC X(10).                  
             10 S-RS2-DISP-START-INT-TS     PIC X(26).                  
             10 S-RS2-DISP-END-INT-TS       PIC X(26).                  
             10 S-RS2-DISP-START-EXT-TS     PIC X(26).                  
             10 S-RS2-DISP-END-EXT-TS       PIC X(26).                  
             10 S-RS2-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS2-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS2-OFFER-DESC-INT-LNG.                               
                49 S-RS2-OFFER-DESC-INT-LNG-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-OFFER-DESC-INT-LNG-TEXT                        
                                            PIC X(255).                 
             10 S-RS2-OFFER-DESC-EXT-LNG.                               
                49 S-RS2-OFFER-DESC-EXT-LNG-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-OFFER-DESC-EXT-LNG-TEXT                        
                                            PIC X(255).                 
             10 S-RS2-SPCL-OFFER-TYPE-CD    PIC X(2).                   
             10 S-RS2-RENEWAL-OFFER-CD      PIC X(12).                  
             10 S-RS2-RENEW-PUB-OFFER-CD    PIC X(1).                   
             10 S-RS2-OFF-VRSN-NO           PIC S9(4) USAGE COMP.       
             10 S-RS2-OFF-VSTART-TS         PIC X(26).                  
             10 S-RS2-OFF-VEND-TS           PIC X(26).                  
             10 S-RS2-PROC-STATUS-CD        PIC X(2).                   
COB305       10 S-RS2-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
             10 S-RS2-PROMO-CD              PIC X(12).                  
PRJ680       10 S-RS2-MAX-PRICE-OFFER-CD    PIC X(12).                  
PRJ892       10 S-RS2-RTCHG-PUB-OFFER-CD    PIC X(12).                  
                                                                        
      *************************************************************             
      *      LATYOUT FOR OPTION TABLE - CRM_RT_PKG_OPTION         *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.    
             10 S-RS3-COMPANY-NO            PIC X(2).                   
             10 S-RS3-OPTION-CD             PIC X(12).                  
             10 S-RS3-CODE-UTIL-TYPE        PIC X(1).                   
             10 S-RS3-RATE-PLAN-NO          PIC X(3).                   
             10 S-RS3-OPTION-START-DT       PIC X(10).                  
             10 S-RS3-OPTION-END-DT         PIC X(10).                  
             10 S-RS3-OPT-DESC-INT          PIC X(50).                  
             10 S-RS3-OPT-DESC-INT-LONG.                                
                49 S-RS3-OPT-DESC-INT-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS3-OPT-DESC-INT-LONG-TEXT                         
                                            PIC X(255).                 
             10 S-RS3-CURR-EXT-DESC-LONG.                               
                49 S-RS3-CURR-EXT-DESC-LONG-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS3-CURR-EXT-DESC-LONG-TEXT                        
                                            PIC X(255).                 
             10 S-RS3-RENEWAL-DESC-LONG.                                
                49 S-RS3-RENEWAL-DESC-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS3-RENEWAL-DESC-LONG-TEXT                         
                                            PIC X(255).                 
             10 S-RS3-WEB-DESC-LONG.                                    
                49 S-RS3-WEB-DESC-LONG-LEN  PIC S9(4) USAGE COMP.       
                49 S-RS3-WEB-DESC-LONG-TEXT PIC X(255).                 
             10 S-RS3-STATUS-CD             PIC X(1).                   
             10 S-RS3-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS3-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS3-OPT-CALC-TYPE-CD      PIC X(2).                   
             10 S-RS3-WEB-MKT-DESC-LONG.                                
                49 S-RS3-WEB-MKT-DESC-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS3-WEB-MKT-DESC-LONG-TEXT                         
                                            PIC X(1024).                
             10 S-RS3-OPT-VRSN-NO           PIC S9(4) USAGE COMP.       
             10 S-RS3-OPT-VSTART-TS         PIC X(26).                  
             10 S-RS3-OPT-VEND-TS           PIC X(26).                  
             10 S-RS3-PROC-STATUS-CD        PIC X(2).                   
COB305       10 S-RS3-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
PRJ892       10 S-RS3-AUTO-RENEWAL-FL       PIC X(01) VALUE SPACES.     
PRJ892       10 S-RS3-OPTION-PROMO-DESC.                                
PRJ892          49 S-RS3-OPTION-PROMO-DESC-LEN  PIC S9(4) USAGE COMP.   
PRJ892          49 S-RS3-OPTION-PROMO-DESC-TEXT PIC X(255).             
                                                                        
      *************************************************************             
      *      LATYOUT FOR OFFER TABLE - CRM_MKT_PROMOTION          *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-5        PIC S9(04) COMP VALUE 0.    
             10 S-RS5-COMPANY-NO            PIC X(2).                   
             10 S-RS5-PROMO-CD              PIC X(12).                  
             10 S-RS5-PROMO-DESC            PIC X(50).                  
             10 S-RS5-OFFER-CD              PIC X(12).                  
             10 S-RS5-MKT-PLAN-CD           PIC X(12).                  
             10 S-RS5-PROMO-START-DT        PIC X(10).                  
             10 S-RS5-PROMO-START-TM        PIC X(8).                   
             10 S-RS5-PROMO-END-DT          PIC X(10).                  
             10 S-RS5-PROMO-END-TM          PIC X(8).                   
             10 S-RS5-AD-CHANNEL-CD         PIC X(10).                  
             10 S-RS5-PROMO-DESC-LONG.                                  
                49 S-RS5-PROMO-DESC-LONG-LEN   PIC S9(4) USAGE COMP.    
                49 S-RS5-PROMO-DESC-LONG-TEXT  PIC X(255).              
             10 S-RS5-EXT-LANDING-PG-URL.                               
                49 S-RS5-EXT-LANDING-PG-URL-LEN PIC S9(4) USAGE COMP.   
                49 S-RS5-EXT-LANDING-PG-URL-TEXT                        
                                            PIC X(255).                 
             10 S-RS5-PROMO-TYPE-CD         PIC X(2).                   
             10 S-RS5-WEB-IMAGE-FILE-NM.                                
                49 S-RS5-WEB-IMAGE-FILE-NM-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS5-WEB-IMAGE-FILE-NM-TEXT PIC X(100).             
             10 S-RS5-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS5-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS5-REPLACMNT-PROMO-CD    PIC X(12).                  
             10 S-RS5-DISPLAY-END-DT        PIC X(10).                  
             10 S-RS5-INT-LANDING-PG-URL.                               
                49 S-RS5-INT-LANDING-PG-URL-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS5-INT-LANDING-PG-URL-TEXT                        
                                            PIC X(255).                 
             10 S-RS5-PROMO-VRSN-NO         PIC S9(4) USAGE COMP.       
             10 S-RS5-PROMO-VSTART-TS       PIC X(26).                  
             10 S-RS5-PROMO-VEND-TS         PIC X(26).                  
             10 S-RS5-PROC-STATUS-CD        PIC X(2).                   
COB305       10 S-RS5-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
                                                                        
      *************************************************************             
      *      LATYOUT FOR OFFER TABLE - CRM_RATE_GRP_OFFER         *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-6        PIC S9(04) COMP VALUE 0.    
             10 S-RS6-COMPANY-NO            PIC X(02).                  
             10 S-RS6-RATE-GROUP-TYPE-CD    PIC X(01).                  
             10 S-RS6-RATE-GROUP-CD         PIC X(02) .                 
             10 S-RS6-SORT-SEQ-NO           PIC S9(04) USAGE COMP.      
             10 S-RS6-EFF-START-DT          PIC X(10).                  
             10 S-RS6-EFF-END-DT            PIC X(10).                  
             10 S-RS6-OFFER-CD              PIC X(12).                  
             10 S-RS6-OPTION-CD             PIC X(12).                  
             10 S-RS6-LAST-UPDATE-USERID    PIC X(07).                  
             10 S-RS6-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS6-GRP-OFF-VRSN-NO       PIC S9(4) USAGE COMP.       
             10 S-RS6-GRP-OFF-VSTART-TS     PIC X(26).                  
             10 S-RS6-GRP-OFF-VEND-TS       PIC X(26).                  
             10 S-RS6-PROC-STATUS-CD        PIC X(2).                   
COB305       10 S-RS6-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
                                                                        
      *************************************************************             
      *      LATYOUT FOR OFFER TABLE - CRM_OFFER_OPTION           *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-7.                                       
             10 S-RETURN-CODE-7             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-7        PIC S9(04) COMP VALUE 0.    
             10 S-RS7-COMPANY-NO            PIC X(02).                  
             10 S-RS7-OFFER-CD              PIC X(12).                  
             10 S-RS7-OPTION-CD             PIC X(12) .                 
             10 S-RS7-OPTION-SORT-SEQ-NO    PIC S9(04) USAGE COMP.      
             10 S-RS7-OPTION-URL-TX.                                    
                49 S-RS7-OPTION-URL-TX-LEN  PIC S9(4) USAGE COMP.       
                49 S-RS7-OPTION-URL-TX-TEXT PIC X(255).                 
             10 S-RS7-DROP-OPTION-CD        PIC X(01).                  
             10 S-RS7-OFFER-OPT-START-DT    PIC X(10).                  
             10 S-RS7-OFFER-OPT-END-DT      PIC X(10).                  
             10 S-RS7-OFF-OPT-VRSN-NO       PIC S9(4) USAGE COMP.       
             10 S-RS7-OFF-OPT-VSTART-TS     PIC X(26).                  
             10 S-RS7-OFF-OPT-VEND-TS       PIC X(26).                  
             10 S-RS7-PROC-STATUS-CD        PIC X(02).                  
COB305       10 S-RS7-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OPTION  (FI)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_ATTR_INCV   (G7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTINCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OFFER   (FG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFFER_OPTION   (E9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFOPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV (HQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_PROMOTION  (KM)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_ACCESS_OFF_OPT  (CI)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRMACC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GRP_OFFER  (G5)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_TIER        (IG)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFF_MKT_TIER   (DU)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFMKT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_CATEGORY        (F5)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCAT                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_DELINQUENCY     (C8)                                    *        
      ******************************************************************        
            EXEC SQL                                                            
                 INCLUDE TBDELQ                                                 
            END-EXEC.                                                           
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   Offer Market tier driving cursor.                            *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE OFFER_MKT_TIER_CUR CURSOR FOR                     
                 SELECT DU.COMPANY_NO                                   
                       ,DU.OFFER_CD                                     
                       ,DU.TIER_CUST_STAT_CD                            
                       ,DU.TIER_ACCT_TYPE_CD                            
                       ,DU.MKT_TIER_RANKING                             
                       ,DU.MKT_TIER_START_DT                            
                       ,DU.OFFER_TIER_STRT_DT                           
                       ,DU.MKT_TIER_APPLY_CD                            
                       ,DU.TIER_DEFLT_OFFR_CD                           
                       ,DU.OFFER_TIER_END_DT                            
                       ,DU.LAST_UPDATE_USERID                           
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                       ,DU.OFF_TIER_VRSN_NO                             
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VSTART_TS                           
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VEND_TS                             
                       ,DU.PROC_STATUS_CD                               
                       ,DU.PROC_REQ_ID                                  
                   FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)               
                  WHERE DU.TIER_CUST_STAT_CD  =  :DU-TIER-CUST-STAT-CD  
                    AND DU.TIER_ACCT_TYPE_CD  =  :DU-TIER-ACCT-TYPE-CD  
                    AND DU.COMPANY_NO         =  :DU-COMPANY-NO         
                    AND ((DU.MKT_TIER_RANKING >= :WS-MIN-TIER-RANKING   
                    AND   DU.MKT_TIER_RANKING <= :WS-MAX-TIER-RANKING ) 
                         OR                                             
                        ((DU.MKT_TIER_APPLY_CD = 'A'                    
                     OR   DU.MKT_TIER_RANKING  = 999)                   
                    AND   :WS-PRP-TIER-RANK-FL = 'N'                    
                        ))                                              
                    AND DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )         
                    AND DU.OFFER_TIER_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )         
                    AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )         
                    AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )         
                    AND NOT EXISTS (                                    
                     SELECT 1                                           
                       FROM CRM_OFF_MKT_TIER  D1 WITH(READUNCOMMITTED)          
                      WHERE D1.COMPANY_NO         = DU.COMPANY_NO       
                        AND D1.OFFER_CD           = DU.OFFER_CD         
                        AND D1.TIER_CUST_STAT_CD  = DU.TIER_CUST_STAT_CD
                        AND D1.TIER_ACCT_TYPE_CD  = DU.TIER_ACCT_TYPE_CD
                        AND D1.MKT_TIER_RANKING   = DU.MKT_TIER_RANKING 
                        AND D1.MKT_TIER_START_DT  = DU.MKT_TIER_START_DT
                        AND D1.OFF_TIER_VRSN_NO   =                     
                                                DU.OFF_TIER_VRSN_NO + 1 
                        AND ((                                          
                             D1.OFFER_TIER_END_DT  >= 
              IIF(TRY_CONVERT(DATE, :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )    
                         AND D1.OFF_TIER_VSTART_TS <= 
              CIS.CHAR2TIMESTAMP(:WS-REALITY-TS)    
                         AND D1.OFF_TIER_VEND_TS   >= 
              CIS.CHAR2TIMESTAMP(:WS-REALITY-TS) )  
                                           OR                           
                            (                                           
                            D1.OFFER_TIER_END_DT  <= 
              IIF(TRY_CONVERT(DATE, :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )     
                        AND D1.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )     
                            ))     )                                    
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFFER_MKT_TIER_CUR CURSOR FOR                             
MFA-TR*          SELECT DU.COMPANY_NO                                           
MFA-TR*                ,DU.OFFER_CD                                             
MFA-TR*                ,DU.TIER_CUST_STAT_CD                                    
MFA-TR*                ,DU.TIER_ACCT_TYPE_CD                                    
MFA-TR*                ,DU.MKT_TIER_RANKING                                     
MFA-TR*                ,DU.MKT_TIER_START_DT                                    
MFA-TR*                ,DU.OFFER_TIER_STRT_DT                                   
MFA-TR*                ,DU.MKT_TIER_APPLY_CD                                    
MFA-TR*                ,DU.TIER_DEFLT_OFFR_CD                                   
MFA-TR*                ,DU.OFFER_TIER_END_DT                                    
MFA-TR*                ,DU.LAST_UPDATE_USERID                                   
MFA-TR*                ,DU.LAST_UPDATE_TS                                       
MFA-TR*                ,DU.OFF_TIER_VRSN_NO                                     
MFA-TR*                ,DU.OFF_TIER_VSTART_TS                                   
MFA-TR*                ,DU.OFF_TIER_VEND_TS                                     
MFA-TR*                ,DU.PROC_STATUS_CD                                       
MFA-TR*                ,DU.PROC_REQ_ID                                          
MFA-TR*            FROM CRM_OFF_MKT_TIER DU                                     
MFA-TR*           WHERE DU.TIER_CUST_STAT_CD  =  :DU-TIER-CUST-STAT-CD          
MFA-TR*             AND DU.TIER_ACCT_TYPE_CD  =  :DU-TIER-ACCT-TYPE-CD          
MFA-TR*             AND DU.COMPANY_NO         =  :DU-COMPANY-NO                 
MFA-TR*             AND ((DU.MKT_TIER_RANKING >= :WS-MIN-TIER-RANKING           
MFA-TR*             AND   DU.MKT_TIER_RANKING <= :WS-MAX-TIER-RANKING )         
MFA-TR*                  OR                                                     
MFA-TR*                 ((DU.MKT_TIER_APPLY_CD = 'A'                            
MFA-TR*              OR   DU.MKT_TIER_RANKING  = 999)                           
MFA-TR*             AND   :WS-PRP-TIER-RANK-FL = 'N'                            
MFA-TR*                 ))                                                      
MFA-TR*             AND DU.OFFER_TIER_STRT_DT <= :WS-REALITY-DT                 
MFA-TR*             AND DU.OFFER_TIER_END_DT  >= :WS-REALITY-DT                 
MFA-TR*             AND DU.OFF_TIER_VSTART_TS <= :WS-REALITY-TS                 
MFA-TR*             AND DU.OFF_TIER_VEND_TS   >= :WS-REALITY-TS                 
MFA-TR*             AND NOT EXISTS (                                            
MFA-TR*              SELECT 1                                                   
MFA-TR*                FROM CRM_OFF_MKT_TIER  D1                                
MFA-TR*               WHERE D1.COMPANY_NO         = DU.COMPANY_NO               
MFA-TR*                 AND D1.OFFER_CD           = DU.OFFER_CD                 
MFA-TR*                 AND D1.TIER_CUST_STAT_CD  = DU.TIER_CUST_STAT_CD        
MFA-TR*                 AND D1.TIER_ACCT_TYPE_CD  = DU.TIER_ACCT_TYPE_CD        
MFA-TR*                 AND D1.MKT_TIER_RANKING   = DU.MKT_TIER_RANKING         
MFA-TR*                 AND D1.MKT_TIER_START_DT  = DU.MKT_TIER_START_DT        
MFA-TR*                 AND D1.OFF_TIER_VRSN_NO   =                             
MFA-TR*                                         DU.OFF_TIER_VRSN_NO + 1         
MFA-TR*                 AND ((                                                  
MFA-TR*                      D1.OFFER_TIER_END_DT  >= :WS-REALITY-DT            
MFA-TR*                  AND D1.OFF_TIER_VSTART_TS <= :WS-REALITY-TS            
MFA-TR*                  AND D1.OFF_TIER_VEND_TS   >= :WS-REALITY-TS )          
MFA-TR*                                    OR                                   
MFA-TR*                     (                                                   
MFA-TR*                     D1.OFFER_TIER_END_DT  <= :WS-REALITY-DT             
MFA-TR*                 AND D1.OFF_TIER_VSTART_TS <= :WS-REALITY-TS             
MFA-TR*                     ))     )                                            
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*          QUERYNO 7130                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   Offer Options cursor.                                        *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE OFFER_OPTION_CUR CURSOR FOR                       
                 SELECT E9.COMPANY_NO                                   
                       ,E9.OFFER_CD                                     
                       ,E9.OPTION_CD                                    
                       ,E9.OPTION_SORT_SEQ_NO                           
                       ,E9.OPTION_URL_TX                                
                       ,E9.DROP_OPTION_CD                               
                       ,E9.OFFER_OPT_START_DT                           
                       ,E9.OFFER_OPT_END_DT                             
                       ,E9.OFF_OPT_VRSN_NO                              
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VSTART_TS                            
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VEND_TS                              
                       ,E9.PROC_STATUS_CD                               
                       ,E9.PROC_REQ_ID                                  
                   FROM CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)               
                  WHERE E9.OFFER_CD           = :E9-OFFER-CD            
                    AND E9.COMPANY_NO         = :E9-COMPANY-NO          
                    AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )         
                    AND E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )         
                    AND E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )         
                    AND E9.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )         
                    AND NOT EXISTS (                                    
                     SELECT 1                                           
                       FROM CRM_OFFER_OPTION E1 WITH(READUNCOMMITTED)           
                      WHERE E1.COMPANY_NO      = E9.COMPANY_NO          
                        AND E1.OPTION_CD       = E9.OPTION_CD           
                        AND E1.OFFER_CD        = E9.OFFER_CD            
                        AND E1.OFFER_OPT_START_DT                       
                                               = E9.OFFER_OPT_START_DT  
                        AND E1.OFF_OPT_VRSN_NO = E9.OFF_OPT_VRSN_NO + 1 
                        AND ((                                          
                             E1.OFFER_OPT_END_DT   >= 
              IIF(TRY_CONVERT(DATE, :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )    
                         AND E1.OFF_OPT_VSTART_TS  <= 
              CIS.CHAR2TIMESTAMP(:WS-REALITY-TS)    
                         AND E1.OFF_OPT_VEND_TS    >= 
              CIS.CHAR2TIMESTAMP(:WS-REALITY-TS) )  
                                           OR                           
                            (                                           
                            E1.OFFER_OPT_END_DT   <= 
              IIF(TRY_CONVERT(DATE, :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )     
                        AND E1.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )     
                            ))     )                                    
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFFER_OPTION_CUR CURSOR FOR                               
MFA-TR*          SELECT E9.COMPANY_NO                                           
MFA-TR*                ,E9.OFFER_CD                                             
MFA-TR*                ,E9.OPTION_CD                                            
MFA-TR*                ,E9.OPTION_SORT_SEQ_NO                                   
MFA-TR*                ,E9.OPTION_URL_TX                                        
MFA-TR*                ,E9.DROP_OPTION_CD                                       
MFA-TR*                ,E9.OFFER_OPT_START_DT                                   
MFA-TR*                ,E9.OFFER_OPT_END_DT                                     
MFA-TR*                ,E9.OFF_OPT_VRSN_NO                                      
MFA-TR*                ,E9.OFF_OPT_VSTART_TS                                    
MFA-TR*                ,E9.OFF_OPT_VEND_TS                                      
MFA-TR*                ,E9.PROC_STATUS_CD                                       
MFA-TR*                ,E9.PROC_REQ_ID                                          
MFA-TR*            FROM CRM_OFFER_OPTION E9                                     
MFA-TR*           WHERE E9.OFFER_CD           = :E9-OFFER-CD                    
MFA-TR*             AND E9.COMPANY_NO         = :E9-COMPANY-NO                  
MFA-TR*             AND E9.OFFER_OPT_START_DT <= :WS-REALITY-DT                 
MFA-TR*             AND E9.OFFER_OPT_END_DT   >= :WS-REALITY-DT                 
MFA-TR*             AND E9.OFF_OPT_VSTART_TS  <= :WS-REALITY-TS                 
MFA-TR*             AND E9.OFF_OPT_VEND_TS    >= :WS-REALITY-TS                 
MFA-TR*             AND NOT EXISTS (                                            
MFA-TR*              SELECT 1                                                   
MFA-TR*                FROM CRM_OFFER_OPTION E1                                 
MFA-TR*               WHERE E1.COMPANY_NO      = E9.COMPANY_NO                  
MFA-TR*                 AND E1.OPTION_CD       = E9.OPTION_CD                   
MFA-TR*                 AND E1.OFFER_CD        = E9.OFFER_CD                    
MFA-TR*                 AND E1.OFFER_OPT_START_DT                               
MFA-TR*                                        = E9.OFFER_OPT_START_DT          
MFA-TR*                 AND E1.OFF_OPT_VRSN_NO = E9.OFF_OPT_VRSN_NO + 1         
MFA-TR*                 AND ((                                                  
MFA-TR*                      E1.OFFER_OPT_END_DT   >= :WS-REALITY-DT            
MFA-TR*                  AND E1.OFF_OPT_VSTART_TS  <= :WS-REALITY-TS            
MFA-TR*                  AND E1.OFF_OPT_VEND_TS    >= :WS-REALITY-TS )          
MFA-TR*                                    OR                                   
MFA-TR*                     (                                                   
MFA-TR*                     E1.OFFER_OPT_END_DT   <= :WS-REALITY-DT             
MFA-TR*                 AND E1.OFF_OPT_VSTART_TS  <= :WS-REALITY-TS             
MFA-TR*                     ))     )                                            
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*          QUERYNO 7550                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   Secure offer and options cursor.                             *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE SEC_OFF_OPT_CUR CURSOR FOR                       
               SELECT CI.OFFER_CD                                       
                     ,CI.OPTION_CD                                      
                     ,CI.VIEW_APPLY_CD                                  
                     ,CI.CATEGORY_ID                                    
                 FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)               
                WHERE CI.ACCESS_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )             
                  AND CI.ACCESS_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )             
                  AND CI.COMPANY_NO        = :CI-COMPANY-NO             
                  AND CI.ACCESS_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )             
                  AND CI.ACCESS_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )             
                  AND NOT EXISTS (                                      
                   SELECT 1                                             
                     FROM CRM_ACCESS_OFF_OPT C1 WITH(READUNCOMMITTED)           
                    WHERE C1.COMPANY_NO      = CI.COMPANY_NO            
                      AND C1.OPTION_CD       = CI.OPTION_CD             
                      AND C1.OFFER_CD        = CI.OFFER_CD              
                      AND C1.CATEGORY_ID     = CI.CATEGORY_ID           
                      AND C1.ACCESS_VRSN_NO  = CI.ACCESS_VRSN_NO + 1    
                        AND ((                                          
                             C1.ACCESS_END_DT    >= 
              IIF(TRY_CONVERT(DATE, :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )      
                         AND C1.ACCESS_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )      
                         AND C1.ACCESS_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              ) )    
                                           OR                           
                            (                                           
                            C1.ACCESS_END_DT     <= 
              IIF(TRY_CONVERT(DATE, :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )      
                        AND C1.ACCESS_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )      
                            ))     )                                    
                ORDER BY  CI.OFFER_CD                                   
                         ,CI.OPTION_CD                                  
                         ,CI.VIEW_APPLY_CD                              
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SEC_OFF_OPT_CUR CURSOR FOR                               
MFA-TR*        SELECT CI.OFFER_CD                                               
MFA-TR*              ,CI.OPTION_CD                                              
MFA-TR*              ,CI.VIEW_APPLY_CD                                          
MFA-TR*              ,CI.CATEGORY_ID                                            
MFA-TR*          FROM CRM_ACCESS_OFF_OPT CI                                     
MFA-TR*         WHERE CI.ACCESS_START_DT  <= :WS-REALITY-DT                     
MFA-TR*           AND CI.ACCESS_END_DT    >= :WS-REALITY-DT                     
MFA-TR*           AND CI.COMPANY_NO        = :CI-COMPANY-NO                     
MFA-TR*           AND CI.ACCESS_VSTART_TS <= :WS-REALITY-TS                     
MFA-TR*           AND CI.ACCESS_VEND_TS   >= :WS-REALITY-TS                     
MFA-TR*           AND NOT EXISTS (                                              
MFA-TR*            SELECT 1                                                     
MFA-TR*              FROM CRM_ACCESS_OFF_OPT C1                                 
MFA-TR*             WHERE C1.COMPANY_NO      = CI.COMPANY_NO                    
MFA-TR*               AND C1.OPTION_CD       = CI.OPTION_CD                     
MFA-TR*               AND C1.OFFER_CD        = CI.OFFER_CD                      
MFA-TR*               AND C1.CATEGORY_ID     = CI.CATEGORY_ID                   
MFA-TR*               AND C1.ACCESS_VRSN_NO  = CI.ACCESS_VRSN_NO + 1            
MFA-TR*                 AND ((                                                  
MFA-TR*                      C1.ACCESS_END_DT    >= :WS-REALITY-DT              
MFA-TR*                  AND C1.ACCESS_VSTART_TS <= :WS-REALITY-TS              
MFA-TR*                  AND C1.ACCESS_VEND_TS   >= :WS-REALITY-TS )            
MFA-TR*                                    OR                                   
MFA-TR*                     (                                                   
MFA-TR*                     C1.ACCESS_END_DT     <= :WS-REALITY-DT              
MFA-TR*                 AND C1.ACCESS_VSTART_TS  <= :WS-REALITY-TS              
MFA-TR*                     ))     )                                            
MFA-TR*         ORDER BY  CI.OFFER_CD                                           
MFA-TR*                  ,CI.OPTION_CD                                          
MFA-TR*                  ,CI.VIEW_APPLY_CD                                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 I-APPLICATION-ID      PIC X(03).                              
       01 I-USER-ID             PIC X(07).                              
       01 I-OFFER-CD            PIC X(12).                              
       01 I-OPTION-CD           PIC X(12).                              
       01 I-PROMO-CD            PIC X(12).                              
       01 I-TIER-RANKING        PIC S9(9) COMP.                         
       01 I-CUST-STAT-CODE      PIC X(01).                              
       01 I-ACCT-TYPE-CD        PIC X(01).                              
       01 I-REALITY-TS          PIC X(26).                              
       01 I-SECURE-CATEGORY     PIC S9(9) COMP.                         
       01 I-COMPANY-NO          PIC X(02).                              
      *                                                                         
       PROCEDURE DIVISION USING I-APPLICATION-ID                        
                               ,I-USER-ID                               
                               ,I-OFFER-CD                              
                               ,I-OPTION-CD                             
                               ,I-PROMO-CD                              
                               ,I-TIER-RANKING                          
                               ,I-CUST-STAT-CODE                        
                               ,I-ACCT-TYPE-CD                          
                               ,I-REALITY-TS                            
                               ,I-SECURE-CATEGORY                       
                               ,I-COMPANY-NO.                           
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 100-VALIDATE-INPUT.                                           *         
      *****************************************************************         
       0100-VALIDATE-INPUT.                                             
                                                                        
           IF I-TIER-RANKING > 0 OR I-PROMO-CD > SPACES                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '0100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SPACES                    TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              MOVE +0                        TO WS-ACTIVE-RETURN-CODE   
              MOVE +1000                     TO WS-APPL-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       0100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100A-DECLARE-GTT-R1   -  CRM_OFF_MKT_TIER                     *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04435_R1'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04435_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04435_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,TIER_CUST_STAT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_ACCT_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_RANKING        SMALLINT                    
                   ,MKT_TIER_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_TIER_STRT_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_APPLY_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_DEFLT_OFFR_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_TIER_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_TIER_VRSN_NO        SMALLINT                    
                   ,OFF_TIER_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_TIER_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS        THRU 8000A-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD          
                      ,LTRIM(RTRIM(TIER_CUST_STAT_CD))    AS 
           TIER_CUST_STAT_CD 
                      ,LTRIM(RTRIM(TIER_ACCT_TYPE_CD))    AS 
           TIER_ACCT_TYPE_CD 
                      ,MKT_TIER_RANKING            AS MKT_TIER_RANKING  
                      ,LTRIM(RTRIM(MKT_TIER_START_DT))    AS 
           MKT_TIER_START_DT 
                      ,LTRIM(RTRIM(OFFER_TIER_STRT_DT))   AS 
           OFFER_TIER_STRT_DT
                      ,LTRIM(RTRIM(MKT_TIER_APPLY_CD))    AS 
           MKT_TIER_APPLY_CD 
                      ,LTRIM(RTRIM(TIER_DEFLT_OFFR_CD))   AS 
           TIER_DEFLT_OFFR_CD
                      ,LTRIM(RTRIM(OFFER_TIER_END_DT))    AS 
           OFFER_TIER_END_DT 
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,OFF_TIER_VRSN_NO            AS OFF_TIER_VRSN_NO  
                      ,LTRIM(RTRIM(OFF_TIER_VSTART_TS))   AS 
           OFF_TIER_VSTART_TS
                      ,LTRIM(RTRIM(OFF_TIER_VEND_TS))     AS 
           OFF_TIER_VEND_TS  
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
                  FROM #CSR04435_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD                  
MFA-TR*               ,STRIP(TIER_CUST_STAT_CD)    AS TIER_CUST_STAT_CD         
MFA-TR*               ,STRIP(TIER_ACCT_TYPE_CD)    AS TIER_ACCT_TYPE_CD         
MFA-TR*               ,MKT_TIER_RANKING            AS MKT_TIER_RANKING          
MFA-TR*               ,STRIP(MKT_TIER_START_DT)    AS MKT_TIER_START_DT         
MFA-TR*               ,STRIP(OFFER_TIER_STRT_DT)   AS OFFER_TIER_STRT_DT        
MFA-TR*               ,STRIP(MKT_TIER_APPLY_CD)    AS MKT_TIER_APPLY_CD         
MFA-TR*               ,STRIP(TIER_DEFLT_OFFR_CD)   AS TIER_DEFLT_OFFR_CD        
MFA-TR*               ,STRIP(OFFER_TIER_END_DT)    AS OFFER_TIER_END_DT         
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,OFF_TIER_VRSN_NO            AS OFF_TIER_VRSN_NO          
MFA-TR*               ,STRIP(OFF_TIER_VSTART_TS)   AS OFF_TIER_VSTART_TS        
MFA-TR*               ,STRIP(OFF_TIER_VEND_TS)     AS OFF_TIER_VEND_TS          
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*           FROM SESSION.CSR04435_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2   -  CRM_RT_PKG_OFFER                     *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04435_R2'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04435_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04435_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OFFER_DESC_INT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_DESC_EXT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_CD_INT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_CD_EXT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_START_INT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_END_INT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_START_EXT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_END_EXT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_DESC_INT_LNG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,OFFER_DESC_EXT_LNG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,SPCL_OFFER_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RENEWAL_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RENEW_PUB_OFFER_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_VRSN_NO             SMALLINT                    
                   ,OFF_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
PRJ680             ,MAX_PRICE_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
PRJ692             ,RTCHG_PUB_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS        THRU 8000B-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100B'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                    ,APPL_RETURN_CODE                                   
                    ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO          
                    ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD            
                    ,LTRIM(RTRIM(OFFER_DESC_INT))       AS 
           OFFER_DESC_INT      
                    ,LTRIM(RTRIM(OFFER_DESC_EXT))       AS 
           OFFER_DESC_EXT      
                    ,LTRIM(RTRIM(PROMO_CD_INT_FL))      AS 
           PROMO_CD_INT_FL     
                    ,LTRIM(RTRIM(PROMO_CD_EXT_FL))      AS 
           PROMO_CD_EXT_FL     
                    ,LTRIM(RTRIM(OFFER_START_DT))       AS 
           OFFER_START_DT      
                    ,LTRIM(RTRIM(OFFER_END_DT))         AS OFFER_END_DT        
                    ,LTRIM(RTRIM(DISP_START_INT_TS))    AS 
           DISP_START_INT_TS   
                    ,LTRIM(RTRIM(DISP_END_INT_TS))      AS 
           DISP_END_INT_TS     
                    ,LTRIM(RTRIM(DISP_START_EXT_TS))    AS 
           DISP_START_EXT_TS   
                    ,LTRIM(RTRIM(DISP_END_EXT_TS))      AS 
           DISP_END_EXT_TS     
                    ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS      
                    ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID  
                    ,LTRIM(RTRIM(OFFER_DESC_INT_LNG))   AS 
           OFFER_DESC_INT_LNG  
                    ,LTRIM(RTRIM(OFFER_DESC_EXT_LNG))   AS 
           OFFER_DESC_EXT_LNG  
                    ,LTRIM(RTRIM(SPCL_OFFER_TYPE_CD))   AS 
           SPCL_OFFER_TYPE_CD  
                    ,LTRIM(RTRIM(RENEWAL_OFFER_CD))     AS 
           RENEWAL_OFFER_CD    
                    ,LTRIM(RTRIM(RENEW_PUB_OFFER_CD))   AS 
           RENEW_PUB_OFFER_CD  
                    ,OFF_VRSN_NO                 AS OFF_VRSN_NO         
                    ,LTRIM(RTRIM(OFF_VSTART_TS))        AS OFF_VSTART_TS       
                    ,LTRIM(RTRIM(OFF_VEND_TS))          AS OFF_VEND_TS         
                    ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD      
                    ,PROC_REQ_ID                                        
PRJ680              ,LTRIM(RTRIM(MAX_PRICE_OFFER_CD))   AS 
           MAX_PRICE_OFFER_CD  
PRJ892              ,LTRIM(RTRIM(RTCHG_PUB_OFFER_CD))   AS 
           RTCHG_PUB_OFFER_CD  
                  FROM #CSR04435_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,STRIP(COMPANY_NO)           AS COMPANY_NO                  
MFA-TR*             ,STRIP(OFFER_CD)             AS OFFER_CD                    
MFA-TR*             ,STRIP(OFFER_DESC_INT)       AS OFFER_DESC_INT              
MFA-TR*             ,STRIP(OFFER_DESC_EXT)       AS OFFER_DESC_EXT              
MFA-TR*             ,STRIP(PROMO_CD_INT_FL)      AS PROMO_CD_INT_FL             
MFA-TR*             ,STRIP(PROMO_CD_EXT_FL)      AS PROMO_CD_EXT_FL             
MFA-TR*             ,STRIP(OFFER_START_DT)       AS OFFER_START_DT              
MFA-TR*             ,STRIP(OFFER_END_DT)         AS OFFER_END_DT                
MFA-TR*             ,STRIP(DISP_START_INT_TS)    AS DISP_START_INT_TS           
MFA-TR*             ,STRIP(DISP_END_INT_TS)      AS DISP_END_INT_TS             
MFA-TR*             ,STRIP(DISP_START_EXT_TS)    AS DISP_START_EXT_TS           
MFA-TR*             ,STRIP(DISP_END_EXT_TS)      AS DISP_END_EXT_TS             
MFA-TR*             ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS              
MFA-TR*             ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID          
MFA-TR*             ,STRIP(OFFER_DESC_INT_LNG)   AS OFFER_DESC_INT_LNG          
MFA-TR*             ,STRIP(OFFER_DESC_EXT_LNG)   AS OFFER_DESC_EXT_LNG          
MFA-TR*             ,STRIP(SPCL_OFFER_TYPE_CD)   AS SPCL_OFFER_TYPE_CD          
MFA-TR*             ,STRIP(RENEWAL_OFFER_CD)     AS RENEWAL_OFFER_CD            
MFA-TR*             ,STRIP(RENEW_PUB_OFFER_CD)   AS RENEW_PUB_OFFER_CD          
MFA-TR*             ,OFF_VRSN_NO                 AS OFF_VRSN_NO                 
MFA-TR*             ,STRIP(OFF_VSTART_TS)        AS OFF_VSTART_TS               
MFA-TR*             ,STRIP(OFF_VEND_TS)          AS OFF_VEND_TS                 
MFA-TR*             ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD              
MFA-TR*             ,PROC_REQ_ID                                                
MFA-TR*             ,STRIP(MAX_PRICE_OFFER_CD)   AS MAX_PRICE_OFFER_CD          
MFA-TR*             ,STRIP(RTCHG_PUB_OFFER_CD)   AS RTCHG_PUB_OFFER_CD          
MFA-TR*           FROM SESSION.CSR04435_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100C-DECLARE-GTT-R3 - CRM_RT_PKG_OPTION                       *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04435_R3'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04435_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04435_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPTION_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPTION_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_DESC_INT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_DESC_INT_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,CURR_EXT_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,RENEWAL_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,WEB_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_CALC_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WEB_MKT_DESC_LONG VARCHAR(1024)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2               
                   ,OPT_VRSN_NO             SMALLINT                    
                   ,OPT_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
PRJ892             ,AUTO_RENEWAL_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
PRJ892             ,OPTION_PROMO_DESC VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS        THRU 8000C-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100C'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                    ,APPL_RETURN_CODE                                   
                    ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO          
                    ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD           
                    ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE      
                    ,LTRIM(RTRIM(RATE_PLAN_NO))         AS RATE_PLAN_NO        
                    ,LTRIM(RTRIM(OPTION_START_DT))      AS 
           OPTION_START_DT     
                    ,LTRIM(RTRIM(OPTION_END_DT))        AS OPTION_END_DT       
                    ,LTRIM(RTRIM(OPT_DESC_INT))         AS OPT_DESC_INT        
                    ,LTRIM(RTRIM(OPT_DESC_INT_LONG))    AS 
           OPT_DESC_INT_LONG   
                    ,LTRIM(RTRIM(CURR_EXT_DESC_LONG))   AS 
           CURR_EXT_DESC_LONG  
                    ,LTRIM(RTRIM(RENEWAL_DESC_LONG))    AS 
           RENEWAL_DESC_LONG   
                    ,LTRIM(RTRIM(WEB_DESC_LONG))        AS WEB_DESC_LONG       
                    ,LTRIM(RTRIM(STATUS_CD))            AS STATUS_CD           
                    ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID  
                    ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS      
                    ,LTRIM(RTRIM(OPT_CALC_TYPE_CD))     AS 
           OPT_CALC_TYPE_CD    
                    ,LTRIM(RTRIM(WEB_MKT_DESC_LONG))    AS 
           WEB_MKT_DESC_LONG   
                    ,OPT_VRSN_NO                                        
                    ,LTRIM(RTRIM(OPT_VSTART_TS))        AS OPT_VSTART_TS       
                    ,LTRIM(RTRIM(OPT_VEND_TS))          AS OPT_VEND_TS         
                    ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD      
                    ,PROC_REQ_ID                                        
PRJ892              ,AUTO_RENEWAL_FL                                    
PRJ892              ,LTRIM(RTRIM(OPTION_PROMO_DESC))    AS 
           OPTION_PROMO_DESC   
                  FROM #CSR04435_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,STRIP(COMPANY_NO)           AS COMPANY_NO                  
MFA-TR*             ,STRIP(OPTION_CD)            AS OPTION_CD                   
MFA-TR*             ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE              
MFA-TR*             ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO                
MFA-TR*             ,STRIP(OPTION_START_DT)      AS OPTION_START_DT             
MFA-TR*             ,STRIP(OPTION_END_DT)        AS OPTION_END_DT               
MFA-TR*             ,STRIP(OPT_DESC_INT)         AS OPT_DESC_INT                
MFA-TR*             ,STRIP(OPT_DESC_INT_LONG)    AS OPT_DESC_INT_LONG           
MFA-TR*             ,STRIP(CURR_EXT_DESC_LONG)   AS CURR_EXT_DESC_LONG          
MFA-TR*             ,STRIP(RENEWAL_DESC_LONG)    AS RENEWAL_DESC_LONG           
MFA-TR*             ,STRIP(WEB_DESC_LONG)        AS WEB_DESC_LONG               
MFA-TR*             ,STRIP(STATUS_CD)            AS STATUS_CD                   
MFA-TR*             ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID          
MFA-TR*             ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS              
MFA-TR*             ,STRIP(OPT_CALC_TYPE_CD)     AS OPT_CALC_TYPE_CD            
MFA-TR*             ,STRIP(WEB_MKT_DESC_LONG)    AS WEB_MKT_DESC_LONG           
MFA-TR*             ,OPT_VRSN_NO                                                
MFA-TR*             ,STRIP(OPT_VSTART_TS)        AS OPT_VSTART_TS               
MFA-TR*             ,STRIP(OPT_VEND_TS)          AS OPT_VEND_TS                 
MFA-TR*             ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD              
MFA-TR*             ,PROC_REQ_ID                                                
MFA-TR*             ,AUTO_RENEWAL_FL                                            
MFA-TR*             ,STRIP(OPTION_PROMO_DESC)    AS OPTION_PROMO_DESC           
MFA-TR*           FROM SESSION.CSR04435_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100E-DECLARE-GTT-R5   - CRM_MKT_PROMOTION                     *        
      ******************************************************************        
       0100E-DECLARE-GTT-R5.                                            
                                                                        
           MOVE 'SESSION.CSR04435_R5'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04435_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04435_R5
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,PROMO_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,PROMO_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,MKT_PLAN_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_START_TM CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_END_TM CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,AD_CHANNEL_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,EXT_LANDING_PG_URL VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMO_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WEB_IMAGE_FILE_NM VARCHAR(100)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REPLACMNT_PROMO_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISPLAY_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INT_LANDING_PG_URL VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMO_VRSN_NO           SMALLINT                    
                   ,PROMO_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS        THRU 8000E-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100E'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                    ,APPL_RETURN_CODE                                   
                    ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO          
                    ,LTRIM(RTRIM(PROMO_CD))             AS PROMO_CD            
                    ,LTRIM(RTRIM(PROMO_DESC))           AS PPROMO_DESC         
                    ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD            
                    ,LTRIM(RTRIM(MKT_PLAN_CD))          AS MKT_PLAN_CD         
                    ,LTRIM(RTRIM(PROMO_START_DT))       AS 
           PROMO_START_DT      
                    ,LTRIM(RTRIM(PROMO_START_TM))       AS 
           PROMO_START_TM      
                    ,LTRIM(RTRIM(PROMO_END_DT))         AS PROMO_END_DT        
                    ,LTRIM(RTRIM(PROMO_END_TM))         AS PROMO_END_TM        
                    ,LTRIM(RTRIM(AD_CHANNEL_CD))        AS AD_CHANNEL_CD       
                    ,LTRIM(RTRIM(PROMO_DESC_LONG))      AS 
           PROMO_DESC_LONG     
                    ,LTRIM(RTRIM(EXT_LANDING_PG_URL))   AS 
           EXT_LANDING_PG_URL  
                    ,LTRIM(RTRIM(PROMO_TYPE_CD))        AS PROMO_TYPE_CD       
                    ,LTRIM(RTRIM(WEB_IMAGE_FILE_NM))    AS 
           WEB_IMAGE_FILE_NM   
                    ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID  
                    ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS      
                    ,LTRIM(RTRIM(REPLACMNT_PROMO_CD))   AS 
           REPLACMNT_PROMO_CD  
                    ,LTRIM(RTRIM(DISPLAY_END_DT))       AS 
           DISPLAY_END_DT      
                    ,LTRIM(RTRIM(INT_LANDING_PG_URL))   AS 
           INT_LANDING_PG_URL  
                    ,PROMO_VRSN_NO                                      
                    ,LTRIM(RTRIM(PROMO_VSTART_TS))      AS 
           PROMO_VSTART_TS     
                    ,LTRIM(RTRIM(PROMO_VEND_TS))        AS PROMO_VEND_TS       
                    ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD      
                    ,PROC_REQ_ID                                        
                  FROM #CSR04435_R5                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,STRIP(COMPANY_NO)           AS COMPANY_NO                  
MFA-TR*             ,STRIP(PROMO_CD)             AS PROMO_CD                    
MFA-TR*             ,STRIP(PROMO_DESC)           AS PPROMO_DESC                 
MFA-TR*             ,STRIP(OFFER_CD)             AS OFFER_CD                    
MFA-TR*             ,STRIP(MKT_PLAN_CD)          AS MKT_PLAN_CD                 
MFA-TR*             ,STRIP(PROMO_START_DT)       AS PROMO_START_DT              
MFA-TR*             ,STRIP(PROMO_START_TM)       AS PROMO_START_TM              
MFA-TR*             ,STRIP(PROMO_END_DT)         AS PROMO_END_DT                
MFA-TR*             ,STRIP(PROMO_END_TM)         AS PROMO_END_TM                
MFA-TR*             ,STRIP(AD_CHANNEL_CD)        AS AD_CHANNEL_CD               
MFA-TR*             ,STRIP(PROMO_DESC_LONG)      AS PROMO_DESC_LONG             
MFA-TR*             ,STRIP(EXT_LANDING_PG_URL)   AS EXT_LANDING_PG_URL          
MFA-TR*             ,STRIP(PROMO_TYPE_CD)        AS PROMO_TYPE_CD               
MFA-TR*             ,STRIP(WEB_IMAGE_FILE_NM)    AS WEB_IMAGE_FILE_NM           
MFA-TR*             ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID          
MFA-TR*             ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS              
MFA-TR*             ,STRIP(REPLACMNT_PROMO_CD)   AS REPLACMNT_PROMO_CD          
MFA-TR*             ,STRIP(DISPLAY_END_DT)       AS DISPLAY_END_DT              
MFA-TR*             ,STRIP(INT_LANDING_PG_URL)   AS INT_LANDING_PG_URL          
MFA-TR*             ,PROMO_VRSN_NO                                              
MFA-TR*             ,STRIP(PROMO_VSTART_TS)      AS PROMO_VSTART_TS             
MFA-TR*             ,STRIP(PROMO_VEND_TS)        AS PROMO_VEND_TS               
MFA-TR*             ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD              
MFA-TR*             ,PROC_REQ_ID                                                
MFA-TR*           FROM SESSION.CSR04435_R5                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100F-DECLARE-GTT-R6   - CRM_RATE_GRP_OFFER                    *        
      ******************************************************************        
       0100F-DECLARE-GTT-R6.                                            
                                                                        
           MOVE 'SESSION.CSR04435_R6'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04435_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04435_R6
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,RATE_GROUP_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_GROUP_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SORT_SEQ_NO             SMALLINT                    
                   ,EFF_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EFF_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,GRP_OFF_VRSN_NO         SMALLINT                    
                   ,GRP_OFF_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,GRP_OFF_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000F-DEL-GTT-ROWS        THRU 8000F-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100F'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C6 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                    ,APPL_RETURN_CODE                                   
                    ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO          
                    ,LTRIM(RTRIM(RATE_GROUP_TYPE_CD))   AS 
           RATE_GROUP_TYPE_CD  
                    ,LTRIM(RTRIM(RATE_GROUP_CD))        AS RATE_GROUP_CD       
                    ,SORT_SEQ_NO                                        
                    ,LTRIM(RTRIM(EFF_START_DT))         AS EFF_START_DT        
                    ,LTRIM(RTRIM(EFF_END_DT))           AS EFF_END_DT          
                    ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD            
                    ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD           
                    ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID  
                    ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS      
                    ,GRP_OFF_VRSN_NO                                    
                    ,LTRIM(RTRIM(GRP_OFF_VSTART_TS))    AS 
           GRP_OFF_VSTART_TS   
                    ,LTRIM(RTRIM(GRP_OFF_VEND_TS))      AS 
           GRP_OFF_VEND_TS     
                    ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD      
                  FROM #CSR04435_R6                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,STRIP(COMPANY_NO)           AS COMPANY_NO                  
MFA-TR*             ,STRIP(RATE_GROUP_TYPE_CD)   AS RATE_GROUP_TYPE_CD          
MFA-TR*             ,STRIP(RATE_GROUP_CD)        AS RATE_GROUP_CD               
MFA-TR*             ,SORT_SEQ_NO                                                
MFA-TR*             ,STRIP(EFF_START_DT)         AS EFF_START_DT                
MFA-TR*             ,STRIP(EFF_END_DT)           AS EFF_END_DT                  
MFA-TR*             ,STRIP(OFFER_CD)             AS OFFER_CD                    
MFA-TR*             ,STRIP(OPTION_CD)            AS OPTION_CD                   
MFA-TR*             ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID          
MFA-TR*             ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS              
MFA-TR*             ,GRP_OFF_VRSN_NO                                            
MFA-TR*             ,STRIP(GRP_OFF_VSTART_TS)    AS GRP_OFF_VSTART_TS           
MFA-TR*             ,STRIP(GRP_OFF_VEND_TS)      AS GRP_OFF_VEND_TS             
MFA-TR*             ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD              
MFA-TR*           FROM SESSION.CSR04435_R6                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100F-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0100G-DECLARE-GTT-R7   - CRM_OFFER_OPTION                      *        
      ******************************************************************        
       0100G-DECLARE-GTT-R7.                                            
                                                                        
           MOVE 'SESSION.CSR04435_R7'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04435_R7')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04435_R7
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OPTION_SORT_SEQ_NO      SMALLINT                    
                   ,OPTION_URL_TX VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,DROP_OPTION_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,OFFER_OPT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_OPT_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_OPT_VRSN_NO         SMALLINT                    
                   ,OFF_OPT_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_OPT_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(2)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000G-DEL-GTT-ROWS        THRU 8000G-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100G'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C7 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                    ,APPL_RETURN_CODE                                   
                    ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO          
                    ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD            
                    ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD           
                    ,OPTION_SORT_SEQ_NO                                 
                    ,LTRIM(RTRIM(OPTION_URL_TX))        AS OPTION_URL_TX       
                    ,LTRIM(RTRIM(DROP_OPTION_CD))       AS 
           DROP_OPTION_CD      
                    ,LTRIM(RTRIM(OFFER_OPT_START_DT))   AS 
           OFFER_OPT_START_DT  
                    ,LTRIM(RTRIM(OFFER_OPT_END_DT))     AS 
           OFFER_OPT_END_DT    
                    ,OFF_OPT_VRSN_NO                                    
                    ,LTRIM(RTRIM(OFF_OPT_VSTART_TS))    AS 
           OFF_OPT_VSTART_TS   
                    ,LTRIM(RTRIM(OFF_OPT_VEND_TS))      AS 
           OFF_OPT_VEND_TS     
                    ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD      
                    ,PROC_REQ_ID                                        
                  FROM #CSR04435_R7                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C7 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,STRIP(COMPANY_NO)           AS COMPANY_NO                  
MFA-TR*             ,STRIP(OFFER_CD)             AS OFFER_CD                    
MFA-TR*             ,STRIP(OPTION_CD)            AS OPTION_CD                   
MFA-TR*             ,OPTION_SORT_SEQ_NO                                         
MFA-TR*             ,STRIP(OPTION_URL_TX)        AS OPTION_URL_TX               
MFA-TR*             ,STRIP(DROP_OPTION_CD)       AS DROP_OPTION_CD              
MFA-TR*             ,STRIP(OFFER_OPT_START_DT)   AS OFFER_OPT_START_DT          
MFA-TR*             ,STRIP(OFFER_OPT_END_DT)     AS OFFER_OPT_END_DT            
MFA-TR*             ,OFF_OPT_VRSN_NO                                            
MFA-TR*             ,STRIP(OFF_OPT_VSTART_TS)    AS OFF_OPT_VSTART_TS           
MFA-TR*             ,STRIP(OFF_OPT_VEND_TS)      AS OFF_OPT_VEND_TS             
MFA-TR*             ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD              
MFA-TR*             ,PROC_REQ_ID                                                
MFA-TR*           FROM SESSION.CSR04435_R7                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100G-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * GET PREPAID PLAN TIER RANK                                *             
      *****************************************************************         
       0200-GET-PREPAID-TIER-RANK.                                      
                                                                        
           MOVE 'N'                     TO WS-PRP-TIER-RANK-FL          
           MOVE I-COMPANY-NO            TO C8-COMPANY-NO                
           MOVE WS-PRP-DEFAULT-TIER     TO C8-DELINQ-CD                 
           PERFORM 7600-SELECT-DELINQ-VALUE  THRU 7600-EXIT             
           MOVE C8-DELINQ-VALUE         TO WS-PRP-TIER-RANK             
           IF I-TIER-RANKING = WS-PRP-TIER-RANK                         
              MOVE 'Y'                  TO WS-PRP-TIER-RANK-FL          
           END-IF.                                                      
                                                                        
       0200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 0100-VALIDATE-INPUT          THRU 0100-EXIT.         
                                                                        
           PERFORM 0200-GET-PREPAID-TIER-RANK   THRU 0200-EXIT.         
                                                                        
           MOVE I-APPLICATION-ID             TO WS-APPLICATION-ID       
           MOVE I-USER-ID                    TO F5-USER-ID              
                                                WS-USER-ID.             
                                                                        
           MOVE I-PROMO-CD                   TO WS-PROMO-CD             
                                                KM-PROMO-CD             
           IF WS-PROMO-CD > SPACES                                      
              MOVE 'Y'                       TO WS-PROMO-CD-FLAG        
           END-IF                                                       
                                                                        
           MOVE I-SECURE-CATEGORY            TO WS-SECURE-CATEGORY      
                                                                        
           MOVE I-CUST-STAT-CODE             TO WS-TIER-CUST-STAT-CD    
                                                IG-TIER-CUST-STAT-CD    
                                                DU-TIER-CUST-STAT-CD    
                                                                        
           MOVE I-TIER-RANKING               TO WS-MKT-TIER-RANKING     
                                                                        
           MOVE I-ACCT-TYPE-CD               TO WS-TIER-ACCT-TYPE-CD    
                                                IG-TIER-ACCT-TYPE-CD    
                                                DU-TIER-ACCT-TYPE-CD    
           MOVE I-REALITY-TS                 TO WS-REALITY-TS           
           MOVE WS-REALITY-TS(1:10)          TO WS-REALITY-DT           
                                                                        
           MOVE I-COMPANY-NO                 TO DU-COMPANY-NO           
                                                FG-COMPANY-NO           
                                                FI-COMPANY-NO           
                                                E9-COMPANY-NO           
                                                KM-COMPANY-NO           
                                                HQ-COMPANY-NO           
                                                G5-COMPANY-NO           
                                                CI-COMPANY-NO           
                                                IG-COMPANY-NO.          
      *                                                                         
           PERFORM 0100A-DECLARE-GTT-R1         THRU 0100A-EXIT.        
           PERFORM 0100B-DECLARE-GTT-R2         THRU 0100B-EXIT.        
           PERFORM 0100C-DECLARE-GTT-R3         THRU 0100C-EXIT.        
           PERFORM 0100E-DECLARE-GTT-R5         THRU 0100E-EXIT.        
           PERFORM 0100F-DECLARE-GTT-R6         THRU 0100F-EXIT.        
           PERFORM 0100G-DECLARE-GTT-R7         THRU 0100G-EXIT.        
                                                                        
           PERFORM 1200-PROCESS-SECURE-OFF-OPT   THRU 1200-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  1200-PROCESS-SECURE-OFF-OPT.                                **        
      **  CHECK IF SUPER USER OR ELSE LOAD SECURE OFFER AND OPTION    **        
      **  TABLE                                                       **        
      ******************************************************************        
      *                                                                         
       1200-PROCESS-SECURE-OFF-OPT.                                     
      *                                                                         
ACT006     IF WS-SUPER-USER-CATEGORY EQUAL WS-SECURE-CATEGORY           
ACT006        SET SUPER-USER TO TRUE                                    
ACT006     END-IF.                                                      
                                                                        
           IF SUPER-USER                                                
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 1250-LOAD-SECURE-DATA     THRU 1250-EXIT          
           END-IF.                                                      
      *                                                                         
       1200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  1250-LOAD-SECURE-DATA.                                      **        
      **      LOAD SECURE OFFER AND OPTION ACCESS DATA TO AN ARRAY.   **        
      ******************************************************************        
      *                                                                         
       1250-LOAD-SECURE-DATA.                                           
      *                                                                         
           SET  WS-SEC-TAB-INDX               TO 1.                     
                                                                        
           MOVE 'N'                          TO WS-NO-MORE-ROWS         
           PERFORM 7260-OPEN-SEC-OFF-OPT-CUR    THRU 7260-EXIT.         
           PERFORM 7270-FETCH-SEC-OFF-OPT-CUR   THRU 7270-EXIT.         
           PERFORM 5450-PROCESS-SEC-OFF-OPT     THRU 5450-EXIT          
                                                UNTIL NO-MORE-ROWS.     
           PERFORM 7280-CLOSE-SEC-OFF-OPT-CUR   THRU 7280-EXIT.         
      *                                                                         
       1250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
P00473     IF WS-PROMO-CD-FLAG = 'Y'                                    
P00473        PERFORM 2010-SELECT-PROMO-INFO       THRU 2010-EXIT       
P00473        PERFORM 2150-PROCESS-MKT-TIER        THRU 2150-EXIT       
P00473     ELSE                                                         
              PERFORM 2100-SELECT-TIER-INFO        THRU 2100-EXIT       
                                                                        
              MOVE 'N'                          TO WS-NO-MORE-ROWS      
              PERFORM 7500-OPEN-MKT-TIER-CUR       THRU 7500-EXIT       
              PERFORM 7510-FETCH-MKT-TIER-CUR      THRU 7510-EXIT       
              PERFORM 2150-PROCESS-MKT-TIER        THRU 2150-EXIT       
                                                UNTIL NO-MORE-ROWS      
              PERFORM 7520-CLOSE-MKT-TIER-CUR      THRU 7520-EXIT       
P00473     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DETERMINE MIN AND MAX RANK AND PROCESS OFFER TIER PROMO        *        
      ******************************************************************        
       2010-SELECT-PROMO-INFO.                                          
                                                                        
           PERFORM 7050-CHK-ACTV-PROMO          THRU  7050-EXIT         
           IF WS-ACTIVE-RETURN-CODE    = NOT-FOUND                      
              PERFORM 7060-CHK-EXPR-PROMO       THRU  7060-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF KM-REPLACMNT-PROMO-CD EQUAL SPACES                  
                    INITIALIZE                  GTT-RETURN-FIELDS       
                    MOVE +0                     TO WS-ACTIVE-RETURN-CODE
                    MOVE +111                   TO WS-APPL-RETURN-CODE  
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
                 ELSE                                                   
                    MOVE KM-REPLACMNT-PROMO-CD  TO KM-PROMO-CD          
                    PERFORM 7050-CHK-ACTV-PROMO THRU  7050-EXIT         
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * DETERMINE MIN AND MAX RANK AND PROCESS OFFER TIER PROMO        *        
      ******************************************************************        
       2100-SELECT-TIER-INFO.                                           
                                                                        
           PERFORM 7100-SELECT-MKT-TIER         THRU 7100-EXIT.         
                                                                        
           EVALUATE IG-TIER-OFFER-VIEW                                  
               WHEN 0                                                   
                    MOVE IG-MKT-TIER-RANKING  TO WS-MIN-TIER-RANKING    
                                                ,WS-MAX-TIER-RANKING    
               WHEN 999                                                 
                    MOVE  0                   TO WS-MIN-TIER-RANKING    
                    MOVE 999                  TO WS-MAX-TIER-RANKING    
               WHEN OTHER                                               
                    MOVE IG-MKT-TIER-RANKING  TO WS-MIN-TIER-RANKING    
                    MOVE IG-TIER-OFFER-VIEW   TO WS-MAX-TIER-RANKING    
           END-EVALUATE.                                                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2150-PROCESS-MKT-TIER.                                         *        
      ******************************************************************        
       2150-PROCESS-MKT-TIER.                                           
                                                                        
           MOVE DU-OFFER-CD                  TO FG-OFFER-CD             
                                                E9-OFFER-CD             
                                                KM-OFFER-CD             
                                                WS-CHECK-OFFER.         
                                                                        
           SET OK-TO-DISPLAY TO TRUE                                    
           IF SUPER-USER                                                
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 5460-CHECK-SECURITY          THRU 5460-EXIT       
              IF SECURE-OFFER                                           
                 IF DISPLAY-OFFER                                       
                    CONTINUE                                            
                 ELSE                                                   
                    MOVE 'N'                 TO WS-OK-TO-DISPLAY        
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF DU-MKT-TIER-RANKING = WS-PRP-TIER-RANK                    
             AND WS-PRP-TIER-RANK-FL = 'N'                              
              CONTINUE                                                  
           ELSE                                                         
             IF OK-TO-DISPLAY                                           
                PERFORM 2160-GET-OFFER-OPTIONS       THRU 2160-EXIT     
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF WS-PROMO-CD-FLAG NOT = 'Y'                                
              PERFORM 7510-FETCH-MKT-TIER-CUR      THRU 7510-EXIT       
           END-IF.                                                      
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2160-GET-OFFER-OPTIONS.                                        *        
      ******************************************************************        
       2160-GET-OFFER-OPTIONS.                                          
                                                                        
           MOVE 'N'                          TO WS-PROCESS-OFFER        
                                                WS-PROMOTION-FOUND.     
           PERFORM 7150-SELECT-OFFER-DET        THRU 7150-EXIT.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                                                        
P00473        IF WS-PROMO-CD-FLAG = 'Y'                                 
P00473           PERFORM 7180-SELECT-PROMO-DET  THRU 7180-EXIT          
P00473           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
P00473              SET PROCESS-OFFER        TO TRUE                    
P00473              SET PROMOTION-FOUND      TO TRUE                    
P00473           END-IF                                                 
P00473        ELSE                                                      
                 IF DU-MKT-TIER-RANKING EQUAL 999                       
                    SET PROCESS-OFFER              TO TRUE              
                 ELSE                                                   
                    IF FG-PROMO-CD-INT-FL = 'Y'                         
                       IF WS-PROMO-CD-FLAG = 'Y'                        
                          MOVE WS-PROMO-CD            TO KM-PROMO-CD    
                          PERFORM 7180-SELECT-PROMO-DET  THRU 7180-EXIT 
                          IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL    
                             SET PROCESS-OFFER        TO TRUE           
                             SET PROMOTION-FOUND      TO TRUE           
                          END-IF                                        
                       END-IF                                           
                    ELSE                                                
                    SET PROCESS-OFFER              TO TRUE              
                 END-IF                                                 
              END-IF                                                    
           END-IF
           END-IF.                                                      
                                                                        
           IF PROCESS-OFFER                                             
                 MOVE 'N'                       TO WS-NO-OFFER-OPTIONS  
                                                   WS-OPTION-FOUND      
                 PERFORM 7550-OPEN-OFFER-OPTIONS    THRU 7550-EXIT      
                 PERFORM 7560-FETCH-OFFER-OPTIONS   THRU 7560-EXIT      
                 PERFORM 2200-PROCESS-OFFER-OPTIONS THRU 2200-EXIT      
                   UNTIL NO-OFFER-OPTIONS                               
                 PERFORM 7570-CLOSE-OFFER-OPTIONS   THRU 7570-EXIT      
                                                                        
                 IF OPTION-FOUND                                        
                    PERFORM 2300-PROCESS-OFFER      THRU 2300-EXIT      
                 END-IF                                                 
           END-IF.                                                      
                                                                        
       2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETTING OFFER / PROMOTION / OPTION DETAILS                              
      ******************************************************************        
       2200-PROCESS-OFFER-OPTIONS.                                      
                                                                        
           PERFORM 2400-PROCESS-OPTIONS       THRU 2400-EXIT            
           IF WS-PROMO-CD-FLAG NOT = 'Y'                                
              PERFORM 2310-MOVE-OFFER-OPTIONS-RS1 THRU 2310-EXIT        
           END-IF                                                       
           PERFORM 7560-FETCH-OFFER-OPTIONS     THRU 7560-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET OFFER DETAILS                                              *        
      ******************************************************************        
       2300-PROCESS-OFFER.                                              
                                                                        
           MOVE DU-OFFER-CD                  TO G5-OFFER-CD.            
                                                                        
           PERFORM 7170-SELECT-RATE-GROUP       THRU 7170-EXIT.         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2360-MOVE-RATE-GRP-OFF-R6 THRU 2360-EXIT          
           ELSE                                                         
              PERFORM 2365-MOVE-BLANK-RATE-GRP-R6                       
                                                THRU 2365-EXIT          
           END-IF.                                                      
                                                                        
           IF PROMOTION-FOUND                                           
              PERFORM 2350-MOVE-PROMO-RS5       THRU 2350-EXIT          
           END-IF.                                                      
                                                                        
           PERFORM 2320-MOVE-OFFER-RS2          THRU 2320-EXIT.         
                                                                        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  GETTING OPTION DETAILS AND ATTRIBUTE INCENTIVE DETAILS        *        
      ******************************************************************        
       2400-PROCESS-OPTIONS.                                            
                                                                        
           MOVE E9-OPTION-CD                   TO G5-OPTION-CD          
                                                  FI-OPTION-CD.         
                                                                        
           IF WS-CHECK-OPTION NOT = E9-OPTION-CD THEN                   
                                                                        
              MOVE E9-OPTION-CD                TO WS-CHECK-OPTION       
              PERFORM 5470-CHECK-SECURE-OPTN-ACCESS                     
                                                 THRU 5470-EXIT         
           END-IF.                                                      
                                                                        
           IF SUPER-USER OR OPTION-NOT-SECURE                           
             OR ( SECURE-OPTION AND DISPLAY-OPTION  ) THEN              
              PERFORM 7000-GET-OPTION-DETAILS    THRU 7000-EXIT         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 SET OPTION-FOUND TO TRUE                               
                 PERFORM 2330-MOVE-OPTION-RS3       THRU 2330-EXIT      
                 PERFORM 2370-MOVE-OFF-OPT-RS7      THRU 2370-EXIT      
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2310-MOVE-OFFER-OPTIONS-RS1.       CRM_OFF_MKT_TIER - DU       *        
      ******************************************************************        
       2310-MOVE-OFFER-OPTIONS-RS1.                                     
                                                                        
           INITIALIZE   GTT-RETURN-FIELDS-1.                            
           MOVE DU-COMPANY-NO               TO S-RS1-COMPANY-NO         
           MOVE DU-OFFER-CD                 TO S-RS1-OFFER-CD           
           MOVE DU-TIER-CUST-STAT-CD        TO S-RS1-TIER-CUST-STAT-CD  
           MOVE DU-TIER-ACCT-TYPE-CD        TO S-RS1-TIER-ACCT-TYPE-CD  
           MOVE DU-MKT-TIER-RANKING         TO S-RS1-MKT-TIER-RANKING   
           MOVE DU-MKT-TIER-START-DT        TO S-RS1-MKT-TIER-START-DT  
           MOVE DU-OFFER-TIER-STRT-DT       TO S-RS1-OFFER-TIER-STRT-DT 
           MOVE DU-MKT-TIER-APPLY-CD        TO S-RS1-MKT-TIER-APPLY-CD  
           MOVE DU-TIER-DEFLT-OFFR-CD       TO S-RS1-TIER-DEFLT-OFFR-CD 
           MOVE DU-OFFER-TIER-END-DT        TO S-RS1-OFFER-TIER-END-DT  
           MOVE DU-LAST-UPDATE-USERID       TO S-RS1-LAST-UPDATE-USERID 
           MOVE DU-LAST-UPDATE-TS           TO S-RS1-LAST-UPDATE-TS     
           MOVE DU-OFF-TIER-VRSN-NO         TO S-RS1-OFF-TIER-VRSN-NO   
           MOVE DU-OFF-TIER-VSTART-TS       TO S-RS1-OFF-TIER-VSTART-TS 
           MOVE DU-OFF-TIER-VEND-TS         TO S-RS1-OFF-TIER-VEND-TS   
           MOVE DU-PROC-STATUS-CD           TO S-RS1-PROC-STATUS-CD     
           MOVE DU-PROC-REQ-ID              TO S-RS1-PROC-REQ-ID        
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2320-MOVE-OFFER-RS2.  CRM-RT-PKG-OFFER                         *        
      ******************************************************************        
       2320-MOVE-OFFER-RS2.                                             
                                                                        
           MOVE FG-COMPANY-NO               TO S-RS2-COMPANY-NO         
           MOVE FG-OFFER-CD                 TO S-RS2-OFFER-CD           
           MOVE FG-OFFER-DESC-INT           TO S-RS2-OFFER-DESC-INT     
           MOVE FG-OFFER-DESC-EXT           TO S-RS2-OFFER-DESC-EXT     
           MOVE FG-PROMO-CD-INT-FL          TO S-RS2-PROMO-CD-INT-FL    
           MOVE FG-PROMO-CD-EXT-FL          TO S-RS2-PROMO-CD-EXT-FL    
           MOVE FG-OFFER-START-DT           TO S-RS2-OFFER-START-DT     
           MOVE FG-OFFER-END-DT             TO S-RS2-OFFER-END-DT       
           MOVE FG-DISP-START-INT-TS        TO S-RS2-DISP-START-INT-TS  
           MOVE FG-DISP-END-INT-TS          TO S-RS2-DISP-END-INT-TS    
           MOVE FG-DISP-START-EXT-TS        TO S-RS2-DISP-START-EXT-TS  
           MOVE FG-DISP-END-EXT-TS          TO S-RS2-DISP-END-EXT-TS    
           MOVE FG-LAST-UPDATE-TS           TO S-RS2-LAST-UPDATE-TS     
           MOVE FG-LAST-UPDATE-USERID       TO S-RS2-LAST-UPDATE-USERID 
           MOVE FG-OFFER-DESC-INT-LNG       TO S-RS2-OFFER-DESC-INT-LNG 
           MOVE FG-OFFER-DESC-EXT-LNG       TO S-RS2-OFFER-DESC-EXT-LNG 
           MOVE FG-SPCL-OFFER-TYPE-CD       TO S-RS2-SPCL-OFFER-TYPE-CD 
           MOVE FG-RENEWAL-OFFER-CD         TO S-RS2-RENEWAL-OFFER-CD   
           MOVE FG-RENEW-PUB-OFFER-CD       TO S-RS2-RENEW-PUB-OFFER-CD 
           MOVE FG-OFF-VRSN-NO              TO S-RS2-OFF-VRSN-NO        
           MOVE FG-OFF-VSTART-TS            TO S-RS2-OFF-VSTART-TS      
           MOVE FG-OFF-VEND-TS              TO S-RS2-OFF-VEND-TS        
           MOVE FG-PROC-STATUS-CD           TO S-RS2-PROC-STATUS-CD     
           MOVE FG-PROC-REQ-ID              TO S-RS2-PROC-REQ-ID        
PRJ680     MOVE FG-MAX-PRICE-OFFER-CD       TO S-RS2-MAX-PRICE-OFFER-CD 
PRJ892     MOVE FG-RTCHG-PUB-OFFER-CD       TO S-RS2-RTCHG-PUB-OFFER-CD 
                                                                        
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-2.                            
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2330-MOVE-OPTION-RS3. CRM-RT-PKG-OPTION                        *        
      ******************************************************************        
       2330-MOVE-OPTION-RS3.                                            
                                                                        
           MOVE FI-COMPANY-NO               TO S-RS3-COMPANY-NO         
           MOVE FI-OPTION-CD                TO S-RS3-OPTION-CD          
           MOVE FI-CODE-UTIL-TYPE           TO S-RS3-CODE-UTIL-TYPE     
           MOVE FI-RATE-PLAN-NO             TO S-RS3-RATE-PLAN-NO       
           MOVE FI-OPTION-START-DT          TO S-RS3-OPTION-START-DT    
           MOVE FI-OPTION-END-DT            TO S-RS3-OPTION-END-DT      
           MOVE FI-OPT-DESC-INT             TO S-RS3-OPT-DESC-INT       
           MOVE FI-OPT-DESC-INT-LONG        TO S-RS3-OPT-DESC-INT-LONG  
           MOVE FI-CURR-EXT-DESC-LONG       TO S-RS3-CURR-EXT-DESC-LONG 
           MOVE FI-RENEWAL-DESC-LONG        TO S-RS3-RENEWAL-DESC-LONG  
           MOVE FI-WEB-DESC-LONG            TO S-RS3-WEB-DESC-LONG      
           MOVE FI-STATUS-CD                TO S-RS3-STATUS-CD          
           MOVE FI-LAST-UPDATE-USERID       TO S-RS3-LAST-UPDATE-USERID 
           MOVE FI-LAST-UPDATE-TS           TO S-RS3-LAST-UPDATE-TS     
           MOVE FI-OPT-CALC-TYPE-CD         TO S-RS3-OPT-CALC-TYPE-CD   
           MOVE FI-WEB-MKT-DESC-LONG        TO S-RS3-WEB-MKT-DESC-LONG  
           MOVE FI-OPT-VRSN-NO              TO S-RS3-OPT-VRSN-NO        
           MOVE FI-OPT-VSTART-TS            TO S-RS3-OPT-VSTART-TS      
           MOVE FI-OPT-VEND-TS              TO S-RS3-OPT-VEND-TS        
           MOVE FI-PROC-STATUS-CD           TO S-RS3-PROC-STATUS-CD     
           MOVE FI-PROC-REQ-ID              TO S-RS3-PROC-REQ-ID        
PRJ892     MOVE FI-AUTO-RENEWAL-FL          TO S-RS3-AUTO-RENEWAL-FL    
PRJ892     MOVE FI-OPTION-PROMO-DESC        TO S-RS3-OPTION-PROMO-DESC  
                                                                        
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-3.                            
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2350-MOVE-PROMO-RS5   CRM-MKT-PROMOTION                        *        
      ******************************************************************        
       2350-MOVE-PROMO-RS5.                                             
                                                                        
           MOVE KM-COMPANY-NO               TO S-RS5-COMPANY-NO         
           MOVE KM-PROMO-CD                 TO S-RS5-PROMO-CD           
           MOVE KM-PROMO-DESC               TO S-RS5-PROMO-DESC         
           MOVE KM-OFFER-CD                 TO S-RS5-OFFER-CD           
           MOVE KM-MKT-PLAN-CD              TO S-RS5-MKT-PLAN-CD        
           MOVE KM-PROMO-START-DT           TO S-RS5-PROMO-START-DT     
           MOVE KM-PROMO-START-TM           TO S-RS5-PROMO-START-TM     
           MOVE KM-PROMO-END-DT             TO S-RS5-PROMO-END-DT       
           MOVE KM-PROMO-END-TM             TO S-RS5-PROMO-END-TM       
           MOVE KM-AD-CHANNEL-CD            TO S-RS5-AD-CHANNEL-CD      
           MOVE KM-PROMO-DESC-LONG          TO S-RS5-PROMO-DESC-LONG    
           MOVE KM-EXT-LANDING-PG-URL       TO S-RS5-EXT-LANDING-PG-URL 
           MOVE KM-PROMO-TYPE-CD            TO S-RS5-PROMO-TYPE-CD      
           MOVE KM-WEB-IMAGE-FILE-NM        TO S-RS5-WEB-IMAGE-FILE-NM  
           MOVE KM-LAST-UPDATE-USERID       TO S-RS5-LAST-UPDATE-USERID 
           MOVE KM-LAST-UPDATE-TS           TO S-RS5-LAST-UPDATE-TS     
           MOVE KM-REPLACMNT-PROMO-CD       TO S-RS5-REPLACMNT-PROMO-CD 
           MOVE KM-DISPLAY-END-DT           TO S-RS5-DISPLAY-END-DT     
           MOVE KM-INT-LANDING-PG-URL       TO S-RS5-INT-LANDING-PG-URL 
           MOVE KM-PROMO-VRSN-NO            TO S-RS5-PROMO-VRSN-NO      
           MOVE KM-PROMO-VSTART-TS          TO S-RS5-PROMO-VSTART-TS    
           MOVE KM-PROMO-VEND-TS            TO S-RS5-PROMO-VEND-TS      
           MOVE KM-PROC-STATUS-CD           TO S-RS5-PROC-STATUS-CD     
           MOVE KM-PROC-REQ-ID              TO S-RS5-PROC-REQ-ID        
                                                                        
           PERFORM 8050-INSERT-GTT-R5          THRU 8050-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-5.                            
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2360-MOVE-RATE-GRP-OFF-R6 CRM_RATE_GRP_OFFER                   *        
      ******************************************************************        
       2360-MOVE-RATE-GRP-OFF-R6.                                       
                                                                        
           MOVE G5-COMPANY-NO               TO S-RS6-COMPANY-NO         
           MOVE G5-RATE-GROUP-TYPE-CD       TO S-RS6-RATE-GROUP-TYPE-CD 
           MOVE G5-RATE-GROUP-CD            TO S-RS6-RATE-GROUP-CD      
           MOVE G5-SORT-SEQ-NO              TO S-RS6-SORT-SEQ-NO        
           MOVE G5-EFF-START-DT             TO S-RS6-EFF-START-DT       
           MOVE G5-EFF-END-DT               TO S-RS6-EFF-END-DT         
           MOVE G5-OFFER-CD                 TO S-RS6-OFFER-CD           
           MOVE G5-OPTION-CD                TO S-RS6-OPTION-CD          
           MOVE G5-LAST-UPDATE-USERID       TO S-RS6-LAST-UPDATE-USERID 
           MOVE G5-LAST-UPDATE-TS           TO S-RS6-LAST-UPDATE-TS     
           MOVE G5-GRP-OFF-VRSN-NO          TO S-RS6-GRP-OFF-VRSN-NO    
           MOVE G5-GRP-OFF-VSTART-TS        TO S-RS6-GRP-OFF-VSTART-TS  
           MOVE G5-GRP-OFF-VEND-TS          TO S-RS6-GRP-OFF-VEND-TS    
           MOVE G5-PROC-STATUS-CD           TO S-RS6-PROC-STATUS-CD     
           MOVE G5-PROC-REQ-ID              TO S-RS6-PROC-REQ-ID        
                                                                        
           PERFORM 8060-INSERT-GTT-R6          THRU 8060-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-6.                            
                                                                        
                                                                        
       2360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2365-MOVE-BLANK-RATE-GRP-R6                                    *        
      ******************************************************************        
       2365-MOVE-BLANK-RATE-GRP-R6.                                     
                                                                        
           MOVE G5-COMPANY-NO               TO S-RS6-COMPANY-NO         
           MOVE ' '                         TO S-RS6-RATE-GROUP-TYPE-CD 
           MOVE '  '                        TO S-RS6-RATE-GROUP-CD      
           MOVE 0                           TO S-RS6-SORT-SEQ-NO        
           MOVE WS-REALITY-DT               TO S-RS6-EFF-START-DT       
           MOVE WS-REALITY-DT               TO S-RS6-EFF-END-DT         
           MOVE G5-OFFER-CD                 TO S-RS6-OFFER-CD           
           MOVE ' '                         TO S-RS6-OPTION-CD          
           MOVE ' '                         TO S-RS6-LAST-UPDATE-USERID 
           MOVE WS-REALITY-TS               TO S-RS6-LAST-UPDATE-TS     
           MOVE 0                           TO S-RS6-GRP-OFF-VRSN-NO    
           MOVE WS-REALITY-TS               TO S-RS6-GRP-OFF-VSTART-TS  
           MOVE WS-REALITY-TS               TO S-RS6-GRP-OFF-VEND-TS    
           MOVE 'AC'                        TO S-RS6-PROC-STATUS-CD     
           MOVE 0                           TO S-RS6-PROC-REQ-ID        
                                                                        
           PERFORM 8060-INSERT-GTT-R6          THRU 8060-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-6.                            
                                                                        
                                                                        
       2365-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2370-MOVE-OFF-OPT-RS7     CRM_OFFER_OPTION                     *        
      ******************************************************************        
       2370-MOVE-OFF-OPT-RS7.                                           
                                                                        
           MOVE E9-COMPANY-NO               TO S-RS7-COMPANY-NO         
           MOVE E9-OFFER-CD                 TO S-RS7-OFFER-CD           
           MOVE E9-OPTION-CD                TO S-RS7-OPTION-CD          
           MOVE E9-OPTION-SORT-SEQ-NO       TO S-RS7-OPTION-SORT-SEQ-NO 
           MOVE E9-OPTION-URL-TX            TO S-RS7-OPTION-URL-TX      
           MOVE E9-DROP-OPTION-CD           TO S-RS7-DROP-OPTION-CD     
           MOVE E9-OFFER-OPT-START-DT       TO S-RS7-OFFER-OPT-START-DT 
           MOVE E9-OFFER-OPT-END-DT         TO S-RS7-OFFER-OPT-END-DT   
           MOVE E9-OFF-OPT-VRSN-NO          TO S-RS7-OFF-OPT-VRSN-NO    
           MOVE E9-OFF-OPT-VSTART-TS        TO S-RS7-OFF-OPT-VSTART-TS  
           MOVE E9-OFF-OPT-VEND-TS          TO S-RS7-OFF-OPT-VEND-TS    
           MOVE E9-PROC-STATUS-CD           TO S-RS7-PROC-STATUS-CD     
           MOVE E9-PROC-REQ-ID              TO S-RS7-PROC-REQ-ID        
                                                                        
           PERFORM 8070-INSERT-GTT-R7          THRU 8070-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-7.                            
                                                                        
       2370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5450-PROCESS-SEC-OFF-OPT.                                    **         
      *                                                              **         
      *****************************************************************         
       5450-PROCESS-SEC-OFF-OPT.                                        
                                                                        
            MOVE CI-OFFER-CD                TO                          
                                   WS-SEC-OFFER(WS-SEC-TAB-INDX).       
            MOVE CI-OPTION-CD               TO                          
                                   WS-SEC-OPTION(WS-SEC-TAB-INDX).      
            MOVE CI-VIEW-APPLY-CD           TO                          
                                  WS-SEC-VIEW-APPLY-CD(WS-SEC-TAB-INDX).
            MOVE CI-CATEGORY-ID             TO                          
                                  WS-SEC-CATEGORY-ID(WS-SEC-TAB-INDX).  
                                                                        
            PERFORM 7270-FETCH-SEC-OFF-OPT-CUR                          
                                            THRU 7270-EXIT.             
                                                                        
            SET  WS-SEC-TAB-INDX            UP BY 1.                    
      *                                                                         
       5450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                              **         
      * 5460-CHECK-SECURITY.                                         **         
      *****************************************************************         
       5460-CHECK-SECURITY.                                             
                                                                        
            MOVE 'N'                       TO WS-SECURE-OFFER-SW        
            MOVE 'N'                       TO WS-DISPLAY-OFFER-SW       
                                                                        
            SET WS-SEC-TAB-INDX            TO 1                         
                                                                        
            SEARCH WS-SECURE-OFF-OPT-TABLE                              
               AT END                                                   
                  CONTINUE                                              
               WHEN WS-SEC-OFFER(WS-SEC-TAB-INDX)  = WS-CHECK-OFFER     
                AND WS-SEC-OPTION(WS-SEC-TAB-INDX) = SPACES             
                   IF WS-SEC-VIEW-APPLY-CD(WS-SEC-TAB-INDX) EQUAL 'B'   
                     OR WS-SEC-VIEW-APPLY-CD(WS-SEC-TAB-INDX) EQUAL 'P' 
                        SET SECURE-OFFER            TO TRUE             
                        IF WS-SEC-CATEGORY-ID(WS-SEC-TAB-INDX)          
                                           = WS-SECURE-CATEGORY         
                            SET DISPLAY-OFFER     TO TRUE               
                        END-IF                                          
                   END-IF                                               
                                                                        
                   IF WS-SEC-VIEW-APPLY-CD(WS-SEC-TAB-INDX) EQUAL 'S'   
                      MOVE WS-CHECK-OFFER         TO G5-OFFER-CD        
                      PERFORM 7170-SELECT-RATE-GROUP                    
                                                  THRU 7170-EXIT        
                      IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
                         SET SECURE-OFFER         TO TRUE               
                         IF WS-SEC-CATEGORY-ID(WS-SEC-TAB-INDX)         
                                                 = WS-SECURE-CATEGORY   
                            SET DISPLAY-OFFER     TO TRUE               
                         END-IF                                         
                      END-IF                                            
                   END-IF                                               
            END-SEARCH.                                                 
      *                                                                         
       5460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      *****************************************************************         
      * 5470-CHECK-SECURE-OPTN-ACCESS.                               **         
      *                                                              **         
      *****************************************************************         
       5470-CHECK-SECURE-OPTN-ACCESS.                                   
                                                                        
            MOVE 'N'                       TO WS-SECURE-OPTION-SW       
            MOVE 'N'                       TO WS-DISPLAY-OPTION-SW      
                                                                        
            SET WS-SEC-TAB-INDX            TO 1                         
                                                                        
            SEARCH WS-SECURE-OFF-OPT-TABLE                              
               AT END                                                   
                  CONTINUE                                              
               WHEN  WS-SEC-OFFER(WS-SEC-TAB-INDX)  = SPACES            
                 AND WS-SEC-OPTION(WS-SEC-TAB-INDX) = WS-CHECK-OPTION   
                    SET SECURE-OPTION           TO TRUE                 
                    IF WS-SEC-CATEGORY-ID(WS-SEC-TAB-INDX)              
                                           = WS-SECURE-CATEGORY         
                       SET DISPLAY-OPTION       TO TRUE                 
                    END-IF                                              
            END-SEARCH.                                                 
      *                                                                         
       5470-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET ALL THE OPTION DETAILS BASED ON OPTION CODE                *        
      * 7000-GET-OPTION-DETAILS.                                       *        
      ******************************************************************        
       7000-GET-OPTION-DETAILS.                                         
                                                                        
           EXEC SQL                                                     
               SELECT FI.COMPANY_NO                                     
                     ,FI.OPTION_CD                                      
                     ,FI.CODE_UTIL_TYPE                                 
                     ,FI.RATE_PLAN_NO                                   
                     ,FI.OPTION_START_DT                                
                     ,FI.OPTION_END_DT                                  
                     ,FI.OPT_DESC_INT                                   
                     ,FI.OPT_DESC_INT_LONG                              
                     ,FI.CURR_EXT_DESC_LONG                             
                     ,FI.RENEWAL_DESC_LONG                              
                     ,FI.WEB_DESC_LONG                                  
                     ,FI.STATUS_CD                                      
                     ,FI.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FI.OPT_CALC_TYPE_CD                               
                     ,FI.WEB_MKT_DESC_LONG                              
                     ,FI.OPT_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VSTART_TS
           , 121), ' ', '-'), ':', '.') OPT_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VEND_TS
           , 121), ' ', '-'), ':', '.') OPT_VEND_TS                            
                     ,FI.PROC_STATUS_CD                                 
                     ,FI.PROC_REQ_ID                                    
PRJ892               ,FI.AUTO_RENEWAL_FL                                
PRJ892               ,FI.OPTION_PROMO_DESC                              
                 INTO :FI-COMPANY-NO                                    
                     ,:FI-OPTION-CD                                     
                     ,:FI-CODE-UTIL-TYPE                                
                     ,:FI-RATE-PLAN-NO                                  
                     ,:FI-OPTION-START-DT                               
                     ,:FI-OPTION-END-DT                                 
                     ,:FI-OPT-DESC-INT                                  
                     ,:FI-OPT-DESC-INT-LONG                             
                     ,:FI-CURR-EXT-DESC-LONG                            
                     ,:FI-RENEWAL-DESC-LONG                             
                     ,:FI-WEB-DESC-LONG                                 
                     ,:FI-STATUS-CD                                     
                     ,:FI-LAST-UPDATE-USERID                            
                     ,:FI-LAST-UPDATE-TS                                
                     ,:FI-OPT-CALC-TYPE-CD                              
                     ,:FI-WEB-MKT-DESC-LONG                             
                     ,:FI-OPT-VRSN-NO                                   
                     ,:FI-OPT-VSTART-TS                                 
                     ,:FI-OPT-VEND-TS                                   
                     ,:FI-PROC-STATUS-CD                                
                     ,:FI-PROC-REQ-ID                                   
PRJ892               ,:FI-AUTO-RENEWAL-FL                               
PRJ892               ,:FI-OPTION-PROMO-DESC                             
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.OPTION_CD         = :FI-OPTION-CD              
                  AND FI.COMPANY_NO        = :FI-COMPANY-NO             
                  AND FI.OPTION_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )            
                  AND FI.OPTION_END_DT     >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )            
                  AND FI.OPT_VSTART_TS     <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )            
                  AND FI.OPT_VEND_TS       >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )            
                  AND NOT EXISTS (                                      
                   SELECT 1                                             
                     FROM CRM_RT_PKG_OPTION F1 WITH(READUNCOMMITTED)            
                    WHERE F1.COMPANY_NO     = FI.COMPANY_NO             
                      AND F1.OPTION_CD      = FI.OPTION_CD              
                      AND F1.OPT_VRSN_NO    = FI.OPT_VRSN_NO + 1        
                      AND ((                                            
                          F1.OPTION_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )           
                      AND F1.OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )           
                      AND F1.OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              ) )         
                                        OR                              
                         (                                              
                          F1.OPTION_END_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )           
                      AND F1.OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )           
                            ))     )                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FI.COMPANY_NO                                             
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CODE_UTIL_TYPE                                         
MFA-TR*              ,FI.RATE_PLAN_NO                                           
MFA-TR*              ,FI.OPTION_START_DT                                        
MFA-TR*              ,FI.OPTION_END_DT                                          
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,FI.OPT_DESC_INT_LONG                                      
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,FI.RENEWAL_DESC_LONG                                      
MFA-TR*              ,FI.WEB_DESC_LONG                                          
MFA-TR*              ,FI.STATUS_CD                                              
MFA-TR*              ,FI.LAST_UPDATE_USERID                                     
MFA-TR*              ,FI.LAST_UPDATE_TS                                         
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.WEB_MKT_DESC_LONG                                      
MFA-TR*              ,FI.OPT_VRSN_NO                                            
MFA-TR*              ,FI.OPT_VSTART_TS                                          
MFA-TR*              ,FI.OPT_VEND_TS                                            
MFA-TR*              ,FI.PROC_STATUS_CD                                         
MFA-TR*              ,FI.PROC_REQ_ID                                            
MFA-TR*              ,FI.AUTO_RENEWAL_FL                                        
MFA-TR*              ,FI.OPTION_PROMO_DESC                                      
MFA-TR*          INTO :FI-COMPANY-NO                                            
MFA-TR*              ,:FI-OPTION-CD                                             
MFA-TR*              ,:FI-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FI-RATE-PLAN-NO                                          
MFA-TR*              ,:FI-OPTION-START-DT                                       
MFA-TR*              ,:FI-OPTION-END-DT                                         
MFA-TR*              ,:FI-OPT-DESC-INT                                          
MFA-TR*              ,:FI-OPT-DESC-INT-LONG                                     
MFA-TR*              ,:FI-CURR-EXT-DESC-LONG                                    
MFA-TR*              ,:FI-RENEWAL-DESC-LONG                                     
MFA-TR*              ,:FI-WEB-DESC-LONG                                         
MFA-TR*              ,:FI-STATUS-CD                                             
MFA-TR*              ,:FI-LAST-UPDATE-USERID                                    
MFA-TR*              ,:FI-LAST-UPDATE-TS                                        
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*              ,:FI-WEB-MKT-DESC-LONG                                     
MFA-TR*              ,:FI-OPT-VRSN-NO                                           
MFA-TR*              ,:FI-OPT-VSTART-TS                                         
MFA-TR*              ,:FI-OPT-VEND-TS                                           
MFA-TR*              ,:FI-PROC-STATUS-CD                                        
MFA-TR*              ,:FI-PROC-REQ-ID                                           
MFA-TR*              ,:FI-AUTO-RENEWAL-FL                                       
MFA-TR*              ,:FI-OPTION-PROMO-DESC                                     
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.OPTION_CD         = :FI-OPTION-CD                      
MFA-TR*           AND FI.COMPANY_NO        = :FI-COMPANY-NO                     
MFA-TR*           AND FI.OPTION_START_DT   <= :WS-REALITY-DT                    
MFA-TR*           AND FI.OPTION_END_DT     >= :WS-REALITY-DT                    
MFA-TR*           AND FI.OPT_VSTART_TS     <= :WS-REALITY-TS                    
MFA-TR*           AND FI.OPT_VEND_TS       >= :WS-REALITY-TS                    
MFA-TR*           AND NOT EXISTS (                                              
MFA-TR*            SELECT 1                                                     
MFA-TR*              FROM CRM_RT_PKG_OPTION F1                                  
MFA-TR*             WHERE F1.COMPANY_NO     = FI.COMPANY_NO                     
MFA-TR*               AND F1.OPTION_CD      = FI.OPTION_CD                      
MFA-TR*               AND F1.OPT_VRSN_NO    = FI.OPT_VRSN_NO + 1                
MFA-TR*               AND ((                                                    
MFA-TR*                   F1.OPTION_END_DT  >= :WS-REALITY-DT                   
MFA-TR*               AND F1.OPT_VSTART_TS  <= :WS-REALITY-TS                   
MFA-TR*               AND F1.OPT_VEND_TS    >= :WS-REALITY-TS )                 
MFA-TR*                                 OR                                      
MFA-TR*                  (                                                      
MFA-TR*                   F1.OPTION_END_DT  <= :WS-REALITY-DT                   
MFA-TR*               AND F1.OPT_VSTART_TS  <= :WS-REALITY-TS                   
MFA-TR*                     ))     )                                            
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE 'REALITY TS'              TO TABLE-ELEMENT-2         
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              MOVE WS-REALITY-TS             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **  7050-CHK-ACTV-PROMO                                        **         
      *****************************************************************         
       7050-CHK-ACTV-PROMO.                                             
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) KM.PROMO_CD,
              DU.OFFER_CD                                      
                  INTO :KM-PROMO-CD                                     
                      ,:DU-OFFER-CD                                     
                  FROM CRM_MKT_PROMOTION    KM WITH(READUNCOMMITTED)            
                      ,CRM_OFF_MKT_TIER     DU WITH(READUNCOMMITTED)            
                 WHERE KM.PROMO_CD          = :KM-PROMO-CD              
                   AND KM.COMPANY_NO        = :KM-COMPANY-NO            
                   AND KM.PROMO_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )            
                   AND KM.PROMO_END_DT     >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )            
                   AND KM.PROMO_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )            
                   AND KM.PROMO_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )            
                   AND DU.OFFER_CD          = KM.OFFER_CD               
                   AND DU.COMPANY_NO        = KM.COMPANY_NO             
                   AND DU.TIER_CUST_STAT_CD = :DU-TIER-CUST-STAT-CD     
                   AND DU.TIER_ACCT_TYPE_CD = :DU-TIER-ACCT-TYPE-CD     
                   ORDER BY KM.PROMO_VRSN_NO DESC                       
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT KM.PROMO_CD                                              
MFA-TR*               ,DU.OFFER_CD                                              
MFA-TR*           INTO :KM-PROMO-CD                                             
MFA-TR*               ,:DU-OFFER-CD                                             
MFA-TR*           FROM CRM_MKT_PROMOTION    KM                                  
MFA-TR*               ,CRM_OFF_MKT_TIER     DU                                  
MFA-TR*          WHERE KM.PROMO_CD          = :KM-PROMO-CD                      
MFA-TR*            AND KM.COMPANY_NO        = :KM-COMPANY-NO                    
MFA-TR*            AND KM.PROMO_START_DT   <= :WS-REALITY-DT                    
MFA-TR*            AND KM.PROMO_END_DT     >= :WS-REALITY-DT                    
MFA-TR*            AND KM.PROMO_VSTART_TS  <= :WS-REALITY-TS                    
MFA-TR*            AND KM.PROMO_VEND_TS    >= :WS-REALITY-TS                    
MFA-TR*            AND DU.OFFER_CD          = KM.OFFER_CD                       
MFA-TR*            AND DU.COMPANY_NO        = KM.COMPANY_NO                     
MFA-TR*            AND DU.TIER_CUST_STAT_CD = :DU-TIER-CUST-STAT-CD             
MFA-TR*            AND DU.TIER_ACCT_TYPE_CD = :DU-TIER-ACCT-TYPE-CD             
MFA-TR*            ORDER BY KM.PROMO_VRSN_NO DESC                               
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
              MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-2                     
              MOVE 'PROMO_CD'            TO TABLE-ELEMENT-1             
              MOVE 'TIER_CUST_STAT_CD'   TO TABLE-ELEMENT-2             
              MOVE 'TIER_ACCT_TYPE_CD'   TO TABLE-ELEMENT-3             
              MOVE KM-PROMO-CD           TO HOSTVAR-ELEMENT-1           
              MOVE DU-TIER-CUST-STAT-CD  TO HOSTVAR-ELEMENT-2           
              MOVE DU-TIER-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **  7060-CHK-EXPR-PROMO                                        **         
      *****************************************************************         
       7060-CHK-EXPR-PROMO.                                             
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) KM.REPLACMNT_PROMO_CD                            
                  INTO :KM-REPLACMNT-PROMO-CD                           
                  FROM CRM_MKT_PROMOTION     KM WITH(READUNCOMMITTED)           
                      ,CRM_OFF_MKT_TIER      DU WITH(READUNCOMMITTED)           
                 WHERE KM.PROMO_CD           = :KM-PROMO-CD             
                   AND KM.COMPANY_NO         = :KM-COMPANY-NO           
                   AND DU.OFFER_CD           = KM.OFFER_CD              
                   AND DU.COMPANY_NO         = KM.COMPANY_NO            
                   AND DU.TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD    
                   AND DU.TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD    
                   ORDER BY KM.PROMO_VRSN_NO DESC                       
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT KM.REPLACMNT_PROMO_CD                                    
MFA-TR*           INTO :KM-REPLACMNT-PROMO-CD                                   
MFA-TR*           FROM CRM_MKT_PROMOTION     KM                                 
MFA-TR*               ,CRM_OFF_MKT_TIER      DU                                 
MFA-TR*          WHERE KM.PROMO_CD           = :KM-PROMO-CD                     
MFA-TR*            AND KM.COMPANY_NO         = :KM-COMPANY-NO                   
MFA-TR*            AND DU.OFFER_CD           = KM.OFFER_CD                      
MFA-TR*            AND DU.COMPANY_NO         = KM.COMPANY_NO                    
MFA-TR*            AND DU.TIER_CUST_STAT_CD  = :DU-TIER-CUST-STAT-CD            
MFA-TR*            AND DU.TIER_ACCT_TYPE_CD  = :DU-TIER-ACCT-TYPE-CD            
MFA-TR*            ORDER BY KM.PROMO_VRSN_NO DESC                               
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
              MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-2                     
              MOVE 'PROMO_CD'            TO TABLE-ELEMENT-1             
              MOVE 'TIER_CUST_STAT_CD'   TO TABLE-ELEMENT-2             
              MOVE 'TIER_ACCT_TYPE_CD'   TO TABLE-ELEMENT-3             
              MOVE KM-PROMO-CD           TO HOSTVAR-ELEMENT-1           
              MOVE DU-TIER-CUST-STAT-CD  TO HOSTVAR-ELEMENT-2           
              MOVE DU-TIER-ACCT-TYPE-CD  TO HOSTVAR-ELEMENT-3           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7060-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7100-SELECT-MKT-TIER.                                          *        
      ******************************************************************        
       7100-SELECT-MKT-TIER.                                            
                                                                        
           EXEC SQL                                                     
               SELECT IG.TIER_CUST_STAT_CD                              
                     ,IG.TIER_ACCT_TYPE_CD                              
                     ,IG.MKT_TIER_RANKING                               
                     ,IG.TIER_OFFER_VIEW                                
                     ,IG.CUST_ACCT_DEFLT_FL                             
                 INTO :IG-TIER-CUST-STAT-CD                             
                     ,:IG-TIER-ACCT-TYPE-CD                             
                     ,:IG-MKT-TIER-RANKING                              
                     ,:IG-TIER-OFFER-VIEW                               
                      ,:IG-CUST-ACCT-DEFLT-FL                           
                 FROM CRM_MKT_TIER IG WITH(READUNCOMMITTED)                     
                WHERE IG.COMPANY_NO         = :IG-COMPANY-NO            
                  AND IG.MKT_TIER_RANKING   = :WS-MKT-TIER-RANKING      
                  AND IG.TIER_ACCT_TYPE_CD  = :WS-TIER-ACCT-TYPE-CD     
                  AND IG.TIER_CUST_STAT_CD  = :WS-TIER-CUST-STAT-CD     
                  AND IG.MKT_TIER_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )            
                  AND IG.MKT_TIER_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT IG.TIER_CUST_STAT_CD                                      
MFA-TR*              ,IG.TIER_ACCT_TYPE_CD                                      
MFA-TR*              ,IG.MKT_TIER_RANKING                                       
MFA-TR*              ,IG.TIER_OFFER_VIEW                                        
MFA-TR*              ,IG.CUST_ACCT_DEFLT_FL                                     
MFA-TR*          INTO :IG-TIER-CUST-STAT-CD                                     
MFA-TR*              ,:IG-TIER-ACCT-TYPE-CD                                     
MFA-TR*              ,:IG-MKT-TIER-RANKING                                      
MFA-TR*              ,:IG-TIER-OFFER-VIEW                                       
MFA-TR*               ,:IG-CUST-ACCT-DEFLT-FL                                   
MFA-TR*          FROM CRM_MKT_TIER IG                                           
MFA-TR*         WHERE IG.COMPANY_NO         = :IG-COMPANY-NO                    
MFA-TR*           AND IG.MKT_TIER_RANKING   = :WS-MKT-TIER-RANKING              
MFA-TR*           AND IG.TIER_ACCT_TYPE_CD  = :WS-TIER-ACCT-TYPE-CD             
MFA-TR*           AND IG.TIER_CUST_STAT_CD  = :WS-TIER-CUST-STAT-CD             
MFA-TR*           AND IG.MKT_TIER_START_DT <= :WS-REALITY-DT                    
MFA-TR*           AND IG.MKT_TIER_END_DT   >= :WS-REALITY-DT                    
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-1         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-2         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-3         
              MOVE 'MKT_TIER_START_DT'       TO TABLE-ELEMENT-4         
              MOVE WS-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-1       
              MOVE WS-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-2       
              MOVE WS-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-3       
              MOVE WS-REALITY-DT             TO HOSTVAR-ELEMENT-4       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7150-SELECT-OFFER-DET.                                         *        
      ******************************************************************        
       7150-SELECT-OFFER-DET.                                           
                                                                        
           EXEC SQL                                                     
                 SELECT FG.COMPANY_NO                                   
                       ,FG.OFFER_CD                                     
                       ,FG.OFFER_DESC_INT                               
                       ,FG.OFFER_DESC_EXT                               
                       ,FG.PROMO_CD_INT_FL                              
                       ,FG.PROMO_CD_EXT_FL                              
                       ,FG.OFFER_START_DT                               
                       ,FG.OFFER_END_DT                                 
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_INT_TS                            
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_INT_TS                              
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_EXT_TS                            
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_EXT_TS                              
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                       ,FG.LAST_UPDATE_USERID                           
                       ,FG.OFFER_DESC_INT_LNG                           
                       ,FG.OFFER_DESC_EXT_LNG                           
                       ,FG.SPCL_OFFER_TYPE_CD                           
                       ,FG.RENEWAL_OFFER_CD                             
                       ,FG.RENEW_PUB_OFFER_CD                           
                       ,FG.OFF_VRSN_NO                                  
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.OFF_VSTART_TS, 121), ' ', '-'), ':', '.') OFF_VSTART_TS          
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS
           , 121), ' ', '-'), ':', '.') OFF_VEND_TS                            
                       ,FG.PROC_STATUS_CD                               
                       ,FG.PROC_REQ_ID                                  
PRJ680                 ,FG.MAX_PRICE_OFFER_CD                           
PRJ892                 ,FG.RTCHG_PUB_OFFER_CD                           
                   INTO :FG-COMPANY-NO                                  
                       ,:FG-OFFER-CD                                    
                       ,:FG-OFFER-DESC-INT                              
                       ,:FG-OFFER-DESC-EXT                              
                       ,:FG-PROMO-CD-INT-FL                             
                       ,:FG-PROMO-CD-EXT-FL                             
                       ,:FG-OFFER-START-DT                              
                       ,:FG-OFFER-END-DT                                
                       ,:FG-DISP-START-INT-TS                           
                       ,:FG-DISP-END-INT-TS                             
                       ,:FG-DISP-START-EXT-TS                           
                       ,:FG-DISP-END-EXT-TS                             
                       ,:FG-LAST-UPDATE-TS                              
                       ,:FG-LAST-UPDATE-USERID                          
                       ,:FG-OFFER-DESC-INT-LNG                          
                       ,:FG-OFFER-DESC-EXT-LNG                          
                       ,:FG-SPCL-OFFER-TYPE-CD                          
                       ,:FG-RENEWAL-OFFER-CD                            
                       ,:FG-RENEW-PUB-OFFER-CD                          
                       ,:FG-OFF-VRSN-NO                                 
                       ,:FG-OFF-VSTART-TS                               
                       ,:FG-OFF-VEND-TS                                 
                       ,:FG-PROC-STATUS-CD                              
                       ,:FG-PROC-REQ-ID                                 
PRJ680                 ,:FG-MAX-PRICE-OFFER-CD                          
PRJ892                 ,:FG-RTCHG-PUB-OFFER-CD                          
                   FROM CRM_RT_PKG_OFFER FG                             
                  WHERE FG.OFFER_CD          =  :FG-OFFER-CD            
                    AND FG.COMPANY_NO        =  :FG-COMPANY-NO          
                    AND FG.OFFER_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )          
                    AND FG.OFFER_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )          
                    AND FG.DISP_START_INT_TS <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )          
                    AND FG.DISP_END_INT_TS   >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )          
                    AND FG.DISP_START_EXT_TS <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )          
                    AND FG.DISP_END_EXT_TS   >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )          
                    AND FG.OFF_VSTART_TS     <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )          
                    AND FG.OFF_VEND_TS       >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )          
                    AND NOT EXISTS (                                    
                     SELECT 1                                           
                       FROM CRM_RT_PKG_OFFER F1                         
                      WHERE F1.COMPANY_NO       = FG.COMPANY_NO         
                        AND F1.OFFER_CD         = FG.OFFER_CD           
                        AND F1.OFF_VRSN_NO      = FG.OFF_VRSN_NO + 1    
                        AND F1.OFF_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )        
                        AND F1.OFF_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )        
                        AND F1.OFF_VEND_TS     >  FG.OFF_VSTART_TS )    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT FG.COMPANY_NO                                           
MFA-TR*                ,FG.OFFER_CD                                             
MFA-TR*                ,FG.OFFER_DESC_INT                                       
MFA-TR*                ,FG.OFFER_DESC_EXT                                       
MFA-TR*                ,FG.PROMO_CD_INT_FL                                      
MFA-TR*                ,FG.PROMO_CD_EXT_FL                                      
MFA-TR*                ,FG.OFFER_START_DT                                       
MFA-TR*                ,FG.OFFER_END_DT                                         
MFA-TR*                ,FG.DISP_START_INT_TS                                    
MFA-TR*                ,FG.DISP_END_INT_TS                                      
MFA-TR*                ,FG.DISP_START_EXT_TS                                    
MFA-TR*                ,FG.DISP_END_EXT_TS                                      
MFA-TR*                ,FG.LAST_UPDATE_TS                                       
MFA-TR*                ,FG.LAST_UPDATE_USERID                                   
MFA-TR*                ,FG.OFFER_DESC_INT_LNG                                   
MFA-TR*                ,FG.OFFER_DESC_EXT_LNG                                   
MFA-TR*                ,FG.SPCL_OFFER_TYPE_CD                                   
MFA-TR*                ,FG.RENEWAL_OFFER_CD                                     
MFA-TR*                ,FG.RENEW_PUB_OFFER_CD                                   
MFA-TR*                ,FG.OFF_VRSN_NO                                          
MFA-TR*                ,FG.OFF_VSTART_TS                                        
MFA-TR*                ,FG.OFF_VEND_TS                                          
MFA-TR*                ,FG.PROC_STATUS_CD                                       
MFA-TR*                ,FG.PROC_REQ_ID                                          
MFA-TR*                ,FG.MAX_PRICE_OFFER_CD                                   
MFA-TR*                ,FG.RTCHG_PUB_OFFER_CD                                   
MFA-TR*            INTO :FG-COMPANY-NO                                          
MFA-TR*                ,:FG-OFFER-CD                                            
MFA-TR*                ,:FG-OFFER-DESC-INT                                      
MFA-TR*                ,:FG-OFFER-DESC-EXT                                      
MFA-TR*                ,:FG-PROMO-CD-INT-FL                                     
MFA-TR*                ,:FG-PROMO-CD-EXT-FL                                     
MFA-TR*                ,:FG-OFFER-START-DT                                      
MFA-TR*                ,:FG-OFFER-END-DT                                        
MFA-TR*                ,:FG-DISP-START-INT-TS                                   
MFA-TR*                ,:FG-DISP-END-INT-TS                                     
MFA-TR*                ,:FG-DISP-START-EXT-TS                                   
MFA-TR*                ,:FG-DISP-END-EXT-TS                                     
MFA-TR*                ,:FG-LAST-UPDATE-TS                                      
MFA-TR*                ,:FG-LAST-UPDATE-USERID                                  
MFA-TR*                ,:FG-OFFER-DESC-INT-LNG                                  
MFA-TR*                ,:FG-OFFER-DESC-EXT-LNG                                  
MFA-TR*                ,:FG-SPCL-OFFER-TYPE-CD                                  
MFA-TR*                ,:FG-RENEWAL-OFFER-CD                                    
MFA-TR*                ,:FG-RENEW-PUB-OFFER-CD                                  
MFA-TR*                ,:FG-OFF-VRSN-NO                                         
MFA-TR*                ,:FG-OFF-VSTART-TS                                       
MFA-TR*                ,:FG-OFF-VEND-TS                                         
MFA-TR*                ,:FG-PROC-STATUS-CD                                      
MFA-TR*                ,:FG-PROC-REQ-ID                                         
MFA-TR*                ,:FG-MAX-PRICE-OFFER-CD                                  
MFA-TR*                ,:FG-RTCHG-PUB-OFFER-CD                                  
MFA-TR*            FROM CRM_RT_PKG_OFFER FG                                     
MFA-TR*           WHERE FG.OFFER_CD          =  :FG-OFFER-CD                    
MFA-TR*             AND FG.COMPANY_NO        =  :FG-COMPANY-NO                  
MFA-TR*             AND FG.OFFER_START_DT    <= :WS-REALITY-DT                  
MFA-TR*             AND FG.OFFER_END_DT      >= :WS-REALITY-DT                  
MFA-TR*             AND FG.DISP_START_INT_TS <= :WS-REALITY-TS                  
MFA-TR*             AND FG.DISP_END_INT_TS   >= :WS-REALITY-TS                  
MFA-TR*             AND FG.DISP_START_EXT_TS <= :WS-REALITY-TS                  
MFA-TR*             AND FG.DISP_END_EXT_TS   >= :WS-REALITY-TS                  
MFA-TR*             AND FG.OFF_VSTART_TS     <= :WS-REALITY-TS                  
MFA-TR*             AND FG.OFF_VEND_TS       >= :WS-REALITY-TS                  
MFA-TR*             AND NOT EXISTS (                                            
MFA-TR*              SELECT 1                                                   
MFA-TR*                FROM CRM_RT_PKG_OFFER F1                                 
MFA-TR*               WHERE F1.COMPANY_NO       = FG.COMPANY_NO                 
MFA-TR*                 AND F1.OFFER_CD         = FG.OFFER_CD                   
MFA-TR*                 AND F1.OFF_VRSN_NO      = FG.OFF_VRSN_NO + 1            
MFA-TR*                 AND F1.OFF_VSTART_TS   <= :WS-REALITY-TS                
MFA-TR*                 AND F1.OFF_VEND_TS     >= :WS-REALITY-TS                
MFA-TR*                 AND F1.OFF_VEND_TS     >  FG.OFF_VSTART_TS )            
MFA-TR*          QUERYNO 7150                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE 'REALITY TS'              TO TABLE-ELEMENT-3         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE FG-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              MOVE WS-REALITY-TS             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7170-SELECT-RATE-GROUP.                                       *         
      *****************************************************************         
       7170-SELECT-RATE-GROUP.                                          
                                                                        
           EXEC SQL                                                     
               SELECT G5.COMPANY_NO                                     
                     ,G5.RATE_GROUP_TYPE_CD                             
                     ,G5.RATE_GROUP_CD                                  
                     ,G5.SORT_SEQ_NO                                    
                     ,G5.EFF_START_DT                                   
                     ,G5.EFF_END_DT                                     
                     ,G5.OFFER_CD                                       
                     ,G5.OPTION_CD                                      
                     ,G5.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,G5.GRP_OFF_VRSN_NO                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.GRP_OFF_VSTART_TS, 121), ' ', '-'), ':', '.') 
           GRP_OFF_VSTART_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.GRP_OFF_VEND_TS, 121), ' ', '-'), ':', '.') 
           GRP_OFF_VEND_TS                                
                     ,G5.PROC_STATUS_CD                                 
                     ,G5.PROC_REQ_ID                                    
                 INTO :G5-COMPANY-NO                                    
                     ,:G5-RATE-GROUP-TYPE-CD                            
                     ,:G5-RATE-GROUP-CD                                 
                     ,:G5-SORT-SEQ-NO                                   
                     ,:G5-EFF-START-DT                                  
                     ,:G5-EFF-END-DT                                    
                     ,:G5-OFFER-CD                                      
                     ,:G5-OPTION-CD                                     
                     ,:G5-LAST-UPDATE-USERID                            
                     ,:G5-LAST-UPDATE-TS                                
                     ,:G5-GRP-OFF-VRSN-NO                               
                     ,:G5-GRP-OFF-VSTART-TS                             
                     ,:G5-GRP-OFF-VEND-TS                               
                     ,:G5-PROC-STATUS-CD                                
                     ,:G5-PROC-REQ-ID                                   
                 FROM CRM_RATE_GRP_OFFER G5                             
                     ,CRM_RATE_GROUP F7                                 
                WHERE G5.COMPANY_NO         = :G5-COMPANY-NO            
                  AND G5.OFFER_CD           = :G5-OFFER-CD              
                  AND G5.EFF_START_DT       <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )           
                  AND G5.EFF_END_DT         >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )           
                  AND G5.RATE_GROUP_TYPE_CD = 'C'                       
                  AND G5.RATE_GROUP_TYPE_CD = F7.RATE_GROUP_TYPE_CD     
                  AND G5.COMPANY_NO         = F7.COMPANY_NO             
                  AND G5.RATE_GROUP_CD      = F7.RATE_GROUP_CD          
                  AND F7.RT_GRP_START_DT    <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )           
                  AND F7.RT_GRP_END_DT      >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )           
                  AND G5.EFF_START_DT       <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )           
                  AND G5.EFF_END_DT         >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )           
                  AND G5.GRP_OFF_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )           
                  AND G5.GRP_OFF_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )           
                  AND NOT EXISTS (                                      
                     SELECT 1                                           
                       FROM CRM_RATE_GRP_OFFER G1                       
                      WHERE G1.COMPANY_NO      = G5.COMPANY_NO          
                        AND G1.OFFER_CD        = G5.OFFER_CD            
                        AND G1.EFF_START_DT    = G5.EFF_START_DT        
                        AND G1.GRP_OFF_VRSN_NO = G5.GRP_OFF_VRSN_NO + 1 
                        AND ((                                          
                             G1.EFF_END_DT         >= 
              IIF(TRY_CONVERT(DATE, :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )    
                         AND G1.GRP_OFF_VSTART_TS  <= 
              CIS.CHAR2TIMESTAMP(:WS-REALITY-TS)    
                         AND G1.GRP_OFF_VEND_TS    >= 
              CIS.CHAR2TIMESTAMP(:WS-REALITY-TS) )  
                                           OR                           
                            (                                           
                            G1.EFF_END_DT         <= 
              IIF(TRY_CONVERT(DATE, :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )     
                        AND G1.GRP_OFF_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )     
                            ))     )                                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT G5.COMPANY_NO                                             
MFA-TR*              ,G5.RATE_GROUP_TYPE_CD                                     
MFA-TR*              ,G5.RATE_GROUP_CD                                          
MFA-TR*              ,G5.SORT_SEQ_NO                                            
MFA-TR*              ,G5.EFF_START_DT                                           
MFA-TR*              ,G5.EFF_END_DT                                             
MFA-TR*              ,G5.OFFER_CD                                               
MFA-TR*              ,G5.OPTION_CD                                              
MFA-TR*              ,G5.LAST_UPDATE_USERID                                     
MFA-TR*              ,G5.LAST_UPDATE_TS                                         
MFA-TR*              ,G5.GRP_OFF_VRSN_NO                                        
MFA-TR*              ,G5.GRP_OFF_VSTART_TS                                      
MFA-TR*              ,G5.GRP_OFF_VEND_TS                                        
MFA-TR*              ,G5.PROC_STATUS_CD                                         
MFA-TR*              ,G5.PROC_REQ_ID                                            
MFA-TR*          INTO :G5-COMPANY-NO                                            
MFA-TR*              ,:G5-RATE-GROUP-TYPE-CD                                    
MFA-TR*              ,:G5-RATE-GROUP-CD                                         
MFA-TR*              ,:G5-SORT-SEQ-NO                                           
MFA-TR*              ,:G5-EFF-START-DT                                          
MFA-TR*              ,:G5-EFF-END-DT                                            
MFA-TR*              ,:G5-OFFER-CD                                              
MFA-TR*              ,:G5-OPTION-CD                                             
MFA-TR*              ,:G5-LAST-UPDATE-USERID                                    
MFA-TR*              ,:G5-LAST-UPDATE-TS                                        
MFA-TR*              ,:G5-GRP-OFF-VRSN-NO                                       
MFA-TR*              ,:G5-GRP-OFF-VSTART-TS                                     
MFA-TR*              ,:G5-GRP-OFF-VEND-TS                                       
MFA-TR*              ,:G5-PROC-STATUS-CD                                        
MFA-TR*              ,:G5-PROC-REQ-ID                                           
MFA-TR*          FROM CRM_RATE_GRP_OFFER G5                                     
MFA-TR*              ,CRM_RATE_GROUP F7                                         
MFA-TR*         WHERE G5.COMPANY_NO         = :G5-COMPANY-NO                    
MFA-TR*           AND G5.OFFER_CD           = :G5-OFFER-CD                      
MFA-TR*           AND G5.EFF_START_DT       <= :WS-REALITY-DT                   
MFA-TR*           AND G5.EFF_END_DT         >= :WS-REALITY-DT                   
MFA-TR*           AND G5.RATE_GROUP_TYPE_CD = 'C'                               
MFA-TR*           AND G5.RATE_GROUP_TYPE_CD = F7.RATE_GROUP_TYPE_CD             
MFA-TR*           AND G5.COMPANY_NO         = F7.COMPANY_NO                     
MFA-TR*           AND G5.RATE_GROUP_CD      = F7.RATE_GROUP_CD                  
MFA-TR*           AND F7.RT_GRP_START_DT    <= :WS-REALITY-DT                   
MFA-TR*           AND F7.RT_GRP_END_DT      >= :WS-REALITY-DT                   
MFA-TR*           AND G5.EFF_START_DT       <= :WS-REALITY-DT                   
MFA-TR*           AND G5.EFF_END_DT         >= :WS-REALITY-DT                   
MFA-TR*           AND G5.GRP_OFF_VSTART_TS  <= :WS-REALITY-TS                   
MFA-TR*           AND G5.GRP_OFF_VEND_TS    >= :WS-REALITY-TS                   
MFA-TR*           AND NOT EXISTS (                                              
MFA-TR*              SELECT 1                                                   
MFA-TR*                FROM CRM_RATE_GRP_OFFER G1                               
MFA-TR*               WHERE G1.COMPANY_NO      = G5.COMPANY_NO                  
MFA-TR*                 AND G1.OFFER_CD        = G5.OFFER_CD                    
MFA-TR*                 AND G1.EFF_START_DT    = G5.EFF_START_DT                
MFA-TR*                 AND G1.GRP_OFF_VRSN_NO = G5.GRP_OFF_VRSN_NO + 1         
MFA-TR*                 AND ((                                                  
MFA-TR*                      G1.EFF_END_DT         >= :WS-REALITY-DT            
MFA-TR*                  AND G1.GRP_OFF_VSTART_TS  <= :WS-REALITY-TS            
MFA-TR*                  AND G1.GRP_OFF_VEND_TS    >= :WS-REALITY-TS )          
MFA-TR*                                    OR                                   
MFA-TR*                     (                                                   
MFA-TR*                     G1.EFF_END_DT         <= :WS-REALITY-DT             
MFA-TR*                 AND G1.GRP_OFF_VSTART_TS  <= :WS-REALITY-TS             
MFA-TR*                     ))     )                                            
MFA-TR*          QUERYNO 7170                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7170'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RATE_GRP_OFFER'      TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'REALITY TS'              TO TABLE-ELEMENT-2         
              MOVE G5-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE WS-REALITY-TS             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7180-SELECT-PROMO-DET.                                         *        
      ******************************************************************        
       7180-SELECT-PROMO-DET.                                           
                                                                        
           EXEC SQL                                                     
                 SELECT KM.COMPANY_NO                                   
                       ,KM.PROMO_CD                                     
                       ,KM.PROMO_DESC                                   
                       ,KM.OFFER_CD                                     
                       ,KM.MKT_PLAN_CD                                  
                       ,KM.PROMO_START_DT                               
                       ,REPLACE(CONVERT(CHAR(8), KM.PROMO_START_TM
           , 108), ':', '.') PROMO_START_TM                               
                       ,KM.PROMO_END_DT                                 
                       ,REPLACE(CONVERT(CHAR(8), KM.PROMO_END_TM, 108), 
           ':', '.') PROMO_END_TM                                 
                       ,KM.AD_CHANNEL_CD                                
                       ,KM.PROMO_DESC_LONG                              
                       ,KM.EXT_LANDING_PG_URL                           
                       ,KM.PROMO_TYPE_CD                                
                       ,KM.WEB_IMAGE_FILE_NM                            
                       ,KM.LAST_UPDATE_USERID                           
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                       ,KM.REPLACMNT_PROMO_CD                           
                       ,KM.DISPLAY_END_DT                               
                       ,KM.INT_LANDING_PG_URL                           
                       ,KM.PROMO_VRSN_NO                                
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VSTART_TS, 121), ' ', '-'), ':', '.') 
           PROMO_VSTART_TS                              
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VEND_TS, 121), ' ', '-'), ':', '.') PROMO_VEND_TS          
                       ,KM.PROC_STATUS_CD                               
                       ,KM.PROC_REQ_ID                                  
                   INTO :KM-COMPANY-NO                                  
                       ,:KM-PROMO-CD                                    
                       ,:KM-PROMO-DESC                                  
                       ,:KM-OFFER-CD                                    
                       ,:KM-MKT-PLAN-CD                                 
                       ,:KM-PROMO-START-DT                              
                       ,:KM-PROMO-START-TM                              
                       ,:KM-PROMO-END-DT                                
                       ,:KM-PROMO-END-TM                                
                       ,:KM-AD-CHANNEL-CD                               
                       ,:KM-PROMO-DESC-LONG                             
                       ,:KM-EXT-LANDING-PG-URL                          
                       ,:KM-PROMO-TYPE-CD                               
                       ,:KM-WEB-IMAGE-FILE-NM                           
                       ,:KM-LAST-UPDATE-USERID                          
                       ,:KM-LAST-UPDATE-TS                              
                       ,:KM-REPLACMNT-PROMO-CD                          
                       ,:KM-DISPLAY-END-DT                              
                       ,:KM-INT-LANDING-PG-URL                          
                       ,:KM-PROMO-VRSN-NO                               
                       ,:KM-PROMO-VSTART-TS                             
                       ,:KM-PROMO-VEND-TS                               
                       ,:KM-PROC-STATUS-CD                              
                       ,:KM-PROC-REQ-ID                                 
                   FROM CRM_MKT_PROMOTION KM                            
                  WHERE KM.OFFER_CD          =  :KM-OFFER-CD            
                    AND KM.COMPANY_NO        =  :KM-COMPANY-NO          
                    AND KM.PROMO_CD          =  :KM-PROMO-CD            
                    AND KM.PROMO_START_DT   <=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )          
                    AND KM.PROMO_END_DT     >=  IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )          
                    AND KM.PROMO_VSTART_TS  <=  CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )          
                    AND KM.PROMO_VEND_TS    >=  CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )          
                    AND KM.PROMO_VRSN_NO     =                          
                    (SELECT MAX(K1.PROMO_VRSN_NO)                       
                       FROM CRM_MKT_PROMOTION K1                        
                      WHERE K1.COMPANY_NO       = KM.COMPANY_NO         
                        AND K1.PROMO_CD         = KM.PROMO_CD           
                        AND K1.PROMO_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )        
                        AND K1.PROMO_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                         :WS-REALITY-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-REALITY-DT
              ) <> 0) OR (LEN(:WS-REALITY-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-REALITY-DT
              ), CONVERT(DATE, :WS-REALITY-DT) )        
                        AND K1.PROMO_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )        
                        AND K1.PROMO_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                         :WS-REALITY-TS
              )        
                     )                                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT KM.COMPANY_NO                                           
MFA-TR*                ,KM.PROMO_CD                                             
MFA-TR*                ,KM.PROMO_DESC                                           
MFA-TR*                ,KM.OFFER_CD                                             
MFA-TR*                ,KM.MKT_PLAN_CD                                          
MFA-TR*                ,KM.PROMO_START_DT                                       
MFA-TR*                ,KM.PROMO_START_TM                                       
MFA-TR*                ,KM.PROMO_END_DT                                         
MFA-TR*                ,KM.PROMO_END_TM                                         
MFA-TR*                ,KM.AD_CHANNEL_CD                                        
MFA-TR*                ,KM.PROMO_DESC_LONG                                      
MFA-TR*                ,KM.EXT_LANDING_PG_URL                                   
MFA-TR*                ,KM.PROMO_TYPE_CD                                        
MFA-TR*                ,KM.WEB_IMAGE_FILE_NM                                    
MFA-TR*                ,KM.LAST_UPDATE_USERID                                   
MFA-TR*                ,KM.LAST_UPDATE_TS                                       
MFA-TR*                ,KM.REPLACMNT_PROMO_CD                                   
MFA-TR*                ,KM.DISPLAY_END_DT                                       
MFA-TR*                ,KM.INT_LANDING_PG_URL                                   
MFA-TR*                ,KM.PROMO_VRSN_NO                                        
MFA-TR*                ,KM.PROMO_VSTART_TS                                      
MFA-TR*                ,KM.PROMO_VEND_TS                                        
MFA-TR*                ,KM.PROC_STATUS_CD                                       
MFA-TR*                ,KM.PROC_REQ_ID                                          
MFA-TR*            INTO :KM-COMPANY-NO                                          
MFA-TR*                ,:KM-PROMO-CD                                            
MFA-TR*                ,:KM-PROMO-DESC                                          
MFA-TR*                ,:KM-OFFER-CD                                            
MFA-TR*                ,:KM-MKT-PLAN-CD                                         
MFA-TR*                ,:KM-PROMO-START-DT                                      
MFA-TR*                ,:KM-PROMO-START-TM                                      
MFA-TR*                ,:KM-PROMO-END-DT                                        
MFA-TR*                ,:KM-PROMO-END-TM                                        
MFA-TR*                ,:KM-AD-CHANNEL-CD                                       
MFA-TR*                ,:KM-PROMO-DESC-LONG                                     
MFA-TR*                ,:KM-EXT-LANDING-PG-URL                                  
MFA-TR*                ,:KM-PROMO-TYPE-CD                                       
MFA-TR*                ,:KM-WEB-IMAGE-FILE-NM                                   
MFA-TR*                ,:KM-LAST-UPDATE-USERID                                  
MFA-TR*                ,:KM-LAST-UPDATE-TS                                      
MFA-TR*                ,:KM-REPLACMNT-PROMO-CD                                  
MFA-TR*                ,:KM-DISPLAY-END-DT                                      
MFA-TR*                ,:KM-INT-LANDING-PG-URL                                  
MFA-TR*                ,:KM-PROMO-VRSN-NO                                       
MFA-TR*                ,:KM-PROMO-VSTART-TS                                     
MFA-TR*                ,:KM-PROMO-VEND-TS                                       
MFA-TR*                ,:KM-PROC-STATUS-CD                                      
MFA-TR*                ,:KM-PROC-REQ-ID                                         
MFA-TR*            FROM CRM_MKT_PROMOTION KM                                    
MFA-TR*           WHERE KM.OFFER_CD          =  :KM-OFFER-CD                    
MFA-TR*             AND KM.COMPANY_NO        =  :KM-COMPANY-NO                  
MFA-TR*             AND KM.PROMO_CD          =  :KM-PROMO-CD                    
MFA-TR*             AND KM.PROMO_START_DT   <=  :WS-REALITY-DT                  
MFA-TR*             AND KM.PROMO_END_DT     >=  :WS-REALITY-DT                  
MFA-TR*             AND KM.PROMO_VSTART_TS  <=  :WS-REALITY-TS                  
MFA-TR*             AND KM.PROMO_VEND_TS    >=  :WS-REALITY-TS                  
MFA-TR*             AND KM.PROMO_VRSN_NO     =                                  
MFA-TR*             (SELECT MAX(K1.PROMO_VRSN_NO)                               
MFA-TR*                FROM CRM_MKT_PROMOTION K1                                
MFA-TR*               WHERE K1.COMPANY_NO       = KM.COMPANY_NO                 
MFA-TR*                 AND K1.PROMO_CD         = KM.PROMO_CD                   
MFA-TR*                 AND K1.PROMO_START_DT  <= :WS-REALITY-DT                
MFA-TR*                 AND K1.PROMO_END_DT    >= :WS-REALITY-DT                
MFA-TR*                 AND K1.PROMO_VSTART_TS <= :WS-REALITY-TS                
MFA-TR*                 AND K1.PROMO_VEND_TS   >= :WS-REALITY-TS                
MFA-TR*              )                                                          
MFA-TR*          QUERYNO 7180                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7180'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE 'REALITY TS'              TO TABLE-ELEMENT-3         
              MOVE KM-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              MOVE KM-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              MOVE WS-REALITY-TS             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      *                                                               *         
      * 7500-OPEN-MKT-TIER-CUR.                                       *         
      *****************************************************************         
       7500-OPEN-MKT-TIER-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_MKT_TIER_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-1         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-2         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-3         
              MOVE DU-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-1       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7510-FETCH-MKT-TIER-CUR.                                     *         
      *****************************************************************         
       7510-FETCH-MKT-TIER-CUR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH OFFER_MKT_TIER_CUR                                  
               INTO :DU-COMPANY-NO                                      
                   ,:DU-OFFER-CD                                        
                   ,:DU-TIER-CUST-STAT-CD                               
                   ,:DU-TIER-ACCT-TYPE-CD                               
                   ,:DU-MKT-TIER-RANKING                                
                   ,:DU-MKT-TIER-START-DT                               
                   ,:DU-OFFER-TIER-STRT-DT                              
                   ,:DU-MKT-TIER-APPLY-CD                               
                   ,:DU-TIER-DEFLT-OFFR-CD                              
                   ,:DU-OFFER-TIER-END-DT                               
                   ,:DU-LAST-UPDATE-USERID                              
                   ,:DU-LAST-UPDATE-TS                                  
                   ,:DU-OFF-TIER-VRSN-NO                                
                   ,:DU-OFF-TIER-VSTART-TS                              
                   ,:DU-OFF-TIER-VEND-TS                                
                   ,:DU-PROC-STATUS-CD                                  
                   ,:DU-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                    TO WS-NO-MORE-ROWS         
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7510'                   TO ACTIVE-PARAGRAPH        
               MOVE 'FETCH'                  TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                 
               MOVE 'MKT_TIER_RANKING'       TO TABLE-ELEMENT-1         
               MOVE 'TIER_CUST_STAT_CD'      TO TABLE-ELEMENT-2         
               MOVE 'TIER_ACCT_TYPE_CD'      TO TABLE-ELEMENT-3         
               MOVE DU-MKT-TIER-RANKING      TO HOSTVAR-ELEMENT-1       
               MOVE DU-TIER-CUST-STAT-CD     TO HOSTVAR-ELEMENT-2       
               MOVE DU-TIER-ACCT-TYPE-CD     TO HOSTVAR-ELEMENT-3       
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7520-CLOSE-MKT-TIER-CUR.                                      *         
      *****************************************************************         
       7520-CLOSE-MKT-TIER-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_MKT_TIER_CUR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7520'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-1         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-2         
              MOVE IG-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-1       
              MOVE IG-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7550-OPEN-OFFER-OPTIONS.                                      *         
      *****************************************************************         
       7550-OPEN-OFFER-OPTIONS.                                         
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_OPTION_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7550'                   TO ACTIVE-PARAGRAPH        
               MOVE 'OPEN'                   TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CRM_OFFER_OPTION'       TO TABLE-1                 
               MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1         
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE 'REALITY TS'             TO TABLE-ELEMENT-3         
               MOVE E9-OFFER-CD              TO HOSTVAR-ELEMENT-1       
               MOVE E9-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               MOVE WS-REALITY-TS            TO HOSTVAR-ELEMENT-3       
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7560-FETCH-OFFER-OPTIONS.                                    *         
      *****************************************************************         
       7560-FETCH-OFFER-OPTIONS.                                        
                                                                        
           EXEC SQL                                                     
              FETCH OFFER_OPTION_CUR                                    
               INTO :E9-COMPANY-NO                                      
                   ,:E9-OFFER-CD                                        
                   ,:E9-OPTION-CD                                       
                   ,:E9-OPTION-SORT-SEQ-NO                              
                   ,:E9-OPTION-URL-TX                                   
                   ,:E9-DROP-OPTION-CD                                  
                   ,:E9-OFFER-OPT-START-DT                              
                   ,:E9-OFFER-OPT-END-DT                                
                   ,:E9-OFF-OPT-VRSN-NO                                 
                   ,:E9-OFF-OPT-VSTART-TS                               
                   ,:E9-OFF-OPT-VEND-TS                                 
                   ,:E9-PROC-STATUS-CD                                  
                   ,:E9-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'Y'                    TO WS-NO-OFFER-OPTIONS     
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7560'                   TO ACTIVE-PARAGRAPH        
               MOVE 'FETCH'                  TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CRM_OFFER_OPTION'       TO TABLE-1                 
               MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1         
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE 'REALITY TS'             TO TABLE-ELEMENT-3         
               MOVE E9-OFFER-CD              TO HOSTVAR-ELEMENT-1       
               MOVE E9-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               MOVE WS-REALITY-TS            TO HOSTVAR-ELEMENT-3       
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7570-CLOSE-OFFER-OPTIONS.                                     *         
      *****************************************************************-        
       7570-CLOSE-OFFER-OPTIONS.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_OPTION_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '7570'                   TO ACTIVE-PARAGRAPH        
               MOVE 'CLOSE'                  TO ABEND-FUNCTION          
               MOVE SPACES                   TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
               MOVE 'CRM_OFFER_OPTION'       TO TABLE-1                 
               MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1         
               MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2         
               MOVE 'REALITY TS'             TO TABLE-ELEMENT-3         
               MOVE E9-OFFER-CD              TO HOSTVAR-ELEMENT-1       
               MOVE E9-COMPANY-NO            TO HOSTVAR-ELEMENT-2       
               MOVE WS-REALITY-TS            TO HOSTVAR-ELEMENT-3       
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7260-OPEN-SEC-OFF-OPT-CUR.                                   **         
      *                                                              **         
      *****************************************************************         
       7260-OPEN-SEC-OFF-OPT-CUR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN SEC_OFF_OPT_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7260'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE F5-USER-ID                TO HOSTVAR-ELEMENT-1       
              MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7270-FETCH-SEC-OFF-OPT-CUR.                                  **         
      *****************************************************************         
       7270-FETCH-SEC-OFF-OPT-CUR.                                      
                                                                        
           EXEC SQL                                                     
               FETCH SEC_OFF_OPT_CUR                                    
                INTO :CI-OFFER-CD                                       
                    ,:CI-OPTION-CD                                      
                    ,:CI-VIEW-APPLY-CD                                  
                    ,:CI-CATEGORY-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
                  CONTINUE                                              
             WHEN NOT-FOUND                                             
                  MOVE 'Y'                   TO WS-NO-MORE-ROWS         
             WHEN OTHER                                                 
                  MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
                  MOVE '7270'                TO ACTIVE-PARAGRAPH        
                  MOVE 'FETCH'               TO ABEND-FUNCTION          
                  MOVE 'CRM_ACCESS_OFF_OPT'  TO TABLE-1                 
                  MOVE 'USER_ID'             TO TABLE-ELEMENT-1         
                  MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2         
                  MOVE CI-COMPANY-NO         TO HOSTVAR-ELEMENT-2       
                  PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT       
           END-EVALUATE.                                                
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7280-CLOSE-SEC-OFF-OPT-CUR.                                  **         
      *                                                              **         
      *****************************************************************         
      *                                                                         
       7280-CLOSE-SEC-OFF-OPT-CUR.                                      
                                                                        
           EXEC SQL                                                     
               CLOSE SEC_OFF_OPT_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7280'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CRM_ACCESS_OFF_OPT'      TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE F5-USER-ID                TO HOSTVAR-ELEMENT-1       
              MOVE CI-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      *****************************************************************         
      * 7600-SELECT-DELINQ-VALUE.                                     *         
      *****************************************************************         
       7600-SELECT-DELINQ-VALUE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT C8.DELINQ_VALUE                                    
                INTO :C8-DELINQ-VALUE                                   
                FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                   
               WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                     
                 AND C8.COMPANY_NO  = :C8-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT C8.DELINQ_VALUE                                            
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY C8                                         
MFA-TR*        WHERE C8.DELINQ_CD   = :C8-DELINQ-CD                             
MFA-TR*          AND C8.COMPANY_NO  = :C8-COMPANY-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_DELINQUENCY'         TO TABLE-1                 
              MOVE 'DELINQ_CD'               TO TABLE-ELEMENT-1         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-2         
              MOVE C8-DELINQ-CD              TO HOSTVAR-ELEMENT-1       
              MOVE C8-COMPANY-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04435_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04435_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04435_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04435_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04435_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000B'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04435_R2'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04435_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04435_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000C'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04435_R3'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000E-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000E-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04435_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04435_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000E'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04435_R5'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000E-EXIT.                                                      
            EXIT.                                                       
      *****************************************************************         
      *                                                               *         
      * 8000F-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000F-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04435_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04435_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000F'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04435_R6'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000F-EXIT.                                                      
            EXIT.                                                       
      *****************************************************************         
      *                                                               *         
      * 8000G-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000G-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04435_R7                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04435_R7                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000G'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04435_R7'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000G-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 8010-INSERT-GTT-R1.   OFFER MKT_TIER TABLE                     *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04435_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,OFFER_CD                                             
                  ,TIER_CUST_STAT_CD                                    
                  ,TIER_ACCT_TYPE_CD                                    
                  ,MKT_TIER_RANKING                                     
                  ,MKT_TIER_START_DT                                    
                  ,OFFER_TIER_STRT_DT                                   
                  ,MKT_TIER_APPLY_CD                                    
                  ,TIER_DEFLT_OFFR_CD                                   
                  ,OFFER_TIER_END_DT                                    
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,OFF_TIER_VRSN_NO                                     
                  ,OFF_TIER_VSTART_TS                                   
                  ,OFF_TIER_VEND_TS                                     
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-COMPANY-NO                                    
                  ,:S-RS1-OFFER-CD                                      
                  ,:S-RS1-TIER-CUST-STAT-CD                             
                  ,:S-RS1-TIER-ACCT-TYPE-CD                             
                  ,:S-RS1-MKT-TIER-RANKING                              
                  ,:S-RS1-MKT-TIER-START-DT                             
                  ,:S-RS1-OFFER-TIER-STRT-DT                            
                  ,:S-RS1-MKT-TIER-APPLY-CD                             
                  ,:S-RS1-TIER-DEFLT-OFFR-CD                            
                  ,:S-RS1-OFFER-TIER-END-DT                             
                  ,:S-RS1-LAST-UPDATE-USERID                            
                  ,:S-RS1-LAST-UPDATE-TS                                
                  ,:S-RS1-OFF-TIER-VRSN-NO                              
                  ,:S-RS1-OFF-TIER-VSTART-TS                            
                  ,:S-RS1-OFF-TIER-VEND-TS                              
                  ,:S-RS1-PROC-STATUS-CD                                
                  ,:S-RS1-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04435_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,TIER_CUST_STAT_CD                                            
MFA-TR*           ,TIER_ACCT_TYPE_CD                                            
MFA-TR*           ,MKT_TIER_RANKING                                             
MFA-TR*           ,MKT_TIER_START_DT                                            
MFA-TR*           ,OFFER_TIER_STRT_DT                                           
MFA-TR*           ,MKT_TIER_APPLY_CD                                            
MFA-TR*           ,TIER_DEFLT_OFFR_CD                                           
MFA-TR*           ,OFFER_TIER_END_DT                                            
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,OFF_TIER_VRSN_NO                                             
MFA-TR*           ,OFF_TIER_VSTART_TS                                           
MFA-TR*           ,OFF_TIER_VEND_TS                                             
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-COMPANY-NO                                            
MFA-TR*           ,:S-RS1-OFFER-CD                                              
MFA-TR*           ,:S-RS1-TIER-CUST-STAT-CD                                     
MFA-TR*           ,:S-RS1-TIER-ACCT-TYPE-CD                                     
MFA-TR*           ,:S-RS1-MKT-TIER-RANKING                                      
MFA-TR*           ,:S-RS1-MKT-TIER-START-DT                                     
MFA-TR*           ,:S-RS1-OFFER-TIER-STRT-DT                                    
MFA-TR*           ,:S-RS1-MKT-TIER-APPLY-CD                                     
MFA-TR*           ,:S-RS1-TIER-DEFLT-OFFR-CD                                    
MFA-TR*           ,:S-RS1-OFFER-TIER-END-DT                                     
MFA-TR*           ,:S-RS1-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS1-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS1-OFF-TIER-VRSN-NO                                      
MFA-TR*           ,:S-RS1-OFF-TIER-VSTART-TS                                    
MFA-TR*           ,:S-RS1-OFF-TIER-VEND-TS                                      
MFA-TR*           ,:S-RS1-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS1-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                         TO  CTR-ROWS-RS1           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R1         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04435_R1'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  CRM_RT_PKG_OFFER                          *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04435_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,COMPANY_NO                                         
                    ,OFFER_CD                                           
                    ,OFFER_DESC_INT                                     
                    ,OFFER_DESC_EXT                                     
                    ,PROMO_CD_INT_FL                                    
                    ,PROMO_CD_EXT_FL                                    
                    ,OFFER_START_DT                                     
                    ,OFFER_END_DT                                       
                    ,DISP_START_INT_TS                                  
                    ,DISP_END_INT_TS                                    
                    ,DISP_START_EXT_TS                                  
                    ,DISP_END_EXT_TS                                    
                    ,LAST_UPDATE_TS                                     
                    ,LAST_UPDATE_USERID                                 
                    ,OFFER_DESC_INT_LNG                                 
                    ,OFFER_DESC_EXT_LNG                                 
                    ,SPCL_OFFER_TYPE_CD                                 
                    ,RENEWAL_OFFER_CD                                   
                    ,RENEW_PUB_OFFER_CD                                 
                    ,OFF_VRSN_NO                                        
                    ,OFF_VSTART_TS                                      
                    ,OFF_VEND_TS                                        
                    ,PROC_STATUS_CD                                     
                    ,PROC_REQ_ID                                        
PRJ680              ,MAX_PRICE_OFFER_CD                                 
PRJ892              ,RTCHG_PUB_OFFER_CD                                 
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-COMPANY-NO                                    
                  ,:S-RS2-OFFER-CD                                      
                  ,:S-RS2-OFFER-DESC-INT                                
                  ,:S-RS2-OFFER-DESC-EXT                                
                  ,:S-RS2-PROMO-CD-INT-FL                               
                  ,:S-RS2-PROMO-CD-EXT-FL                               
                  ,:S-RS2-OFFER-START-DT                                
                  ,:S-RS2-OFFER-END-DT                                  
                  ,:S-RS2-DISP-START-INT-TS                             
                  ,:S-RS2-DISP-END-INT-TS                               
                  ,:S-RS2-DISP-START-EXT-TS                             
                  ,:S-RS2-DISP-END-EXT-TS                               
                  ,:S-RS2-LAST-UPDATE-TS                                
                  ,:S-RS2-LAST-UPDATE-USERID                            
                  ,:S-RS2-OFFER-DESC-INT-LNG                            
                  ,:S-RS2-OFFER-DESC-EXT-LNG                            
                  ,:S-RS2-SPCL-OFFER-TYPE-CD                            
                  ,:S-RS2-RENEWAL-OFFER-CD                              
                  ,:S-RS2-RENEW-PUB-OFFER-CD                            
                  ,:S-RS2-OFF-VRSN-NO                                   
                  ,:S-RS2-OFF-VSTART-TS                                 
                  ,:S-RS2-OFF-VEND-TS                                   
                  ,:S-RS2-PROC-STATUS-CD                                
                  ,:S-RS2-PROC-REQ-ID                                   
PRJ680            ,:S-RS2-MAX-PRICE-OFFER-CD                            
PRJ892            ,:S-RS2-RTCHG-PUB-OFFER-CD                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04435_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,OFFER_CD                                                   
MFA-TR*             ,OFFER_DESC_INT                                             
MFA-TR*             ,OFFER_DESC_EXT                                             
MFA-TR*             ,PROMO_CD_INT_FL                                            
MFA-TR*             ,PROMO_CD_EXT_FL                                            
MFA-TR*             ,OFFER_START_DT                                             
MFA-TR*             ,OFFER_END_DT                                               
MFA-TR*             ,DISP_START_INT_TS                                          
MFA-TR*             ,DISP_END_INT_TS                                            
MFA-TR*             ,DISP_START_EXT_TS                                          
MFA-TR*             ,DISP_END_EXT_TS                                            
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,OFFER_DESC_INT_LNG                                         
MFA-TR*             ,OFFER_DESC_EXT_LNG                                         
MFA-TR*             ,SPCL_OFFER_TYPE_CD                                         
MFA-TR*             ,RENEWAL_OFFER_CD                                           
MFA-TR*             ,RENEW_PUB_OFFER_CD                                         
MFA-TR*             ,OFF_VRSN_NO                                                
MFA-TR*             ,OFF_VSTART_TS                                              
MFA-TR*             ,OFF_VEND_TS                                                
MFA-TR*             ,PROC_STATUS_CD                                             
MFA-TR*             ,PROC_REQ_ID                                                
MFA-TR*             ,MAX_PRICE_OFFER_CD                                         
MFA-TR*             ,RTCHG_PUB_OFFER_CD                                         
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-COMPANY-NO                                            
MFA-TR*           ,:S-RS2-OFFER-CD                                              
MFA-TR*           ,:S-RS2-OFFER-DESC-INT                                        
MFA-TR*           ,:S-RS2-OFFER-DESC-EXT                                        
MFA-TR*           ,:S-RS2-PROMO-CD-INT-FL                                       
MFA-TR*           ,:S-RS2-PROMO-CD-EXT-FL                                       
MFA-TR*           ,:S-RS2-OFFER-START-DT                                        
MFA-TR*           ,:S-RS2-OFFER-END-DT                                          
MFA-TR*           ,:S-RS2-DISP-START-INT-TS                                     
MFA-TR*           ,:S-RS2-DISP-END-INT-TS                                       
MFA-TR*           ,:S-RS2-DISP-START-EXT-TS                                     
MFA-TR*           ,:S-RS2-DISP-END-EXT-TS                                       
MFA-TR*           ,:S-RS2-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS2-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS2-OFFER-DESC-INT-LNG                                    
MFA-TR*           ,:S-RS2-OFFER-DESC-EXT-LNG                                    
MFA-TR*           ,:S-RS2-SPCL-OFFER-TYPE-CD                                    
MFA-TR*           ,:S-RS2-RENEWAL-OFFER-CD                                      
MFA-TR*           ,:S-RS2-RENEW-PUB-OFFER-CD                                    
MFA-TR*           ,:S-RS2-OFF-VRSN-NO                                           
MFA-TR*           ,:S-RS2-OFF-VSTART-TS                                         
MFA-TR*           ,:S-RS2-OFF-VEND-TS                                           
MFA-TR*           ,:S-RS2-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS2-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS2-MAX-PRICE-OFFER-CD                                    
MFA-TR*           ,:S-RS2-RTCHG-PUB-OFFER-CD                                    
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                         TO CTR-ROWS-RS2            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R2         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04435_R2'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8030-INSERT-GTT-R3.   CRM_RT_PKG_OPTION                        *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04435_R3                           
              (                                                         
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,OPTION_CD                                            
                  ,CODE_UTIL_TYPE                                       
                  ,RATE_PLAN_NO                                         
                  ,OPTION_START_DT                                      
                  ,OPTION_END_DT                                        
                  ,OPT_DESC_INT                                         
                  ,OPT_DESC_INT_LONG                                    
                  ,CURR_EXT_DESC_LONG                                   
                  ,RENEWAL_DESC_LONG                                    
                  ,WEB_DESC_LONG                                        
                  ,STATUS_CD                                            
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,OPT_CALC_TYPE_CD                                     
                  ,WEB_MKT_DESC_LONG                                    
                  ,OPT_VRSN_NO                                          
                  ,OPT_VSTART_TS                                        
                  ,OPT_VEND_TS                                          
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
PRJ892            ,AUTO_RENEWAL_FL                                      
PRJ892            ,OPTION_PROMO_DESC                                    
              )                                                         
              VALUES                                                    
              (                                                         
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-COMPANY-NO                                    
                  ,:S-RS3-OPTION-CD                                     
                  ,:S-RS3-CODE-UTIL-TYPE                                
                  ,:S-RS3-RATE-PLAN-NO                                  
                  ,:S-RS3-OPTION-START-DT                               
                  ,:S-RS3-OPTION-END-DT                                 
                  ,:S-RS3-OPT-DESC-INT                                  
                  ,:S-RS3-OPT-DESC-INT-LONG                             
                  ,:S-RS3-CURR-EXT-DESC-LONG                            
                  ,:S-RS3-RENEWAL-DESC-LONG                             
                  ,:S-RS3-WEB-DESC-LONG                                 
                  ,:S-RS3-STATUS-CD                                     
                  ,:S-RS3-LAST-UPDATE-USERID                            
                  ,:S-RS3-LAST-UPDATE-TS                                
                  ,:S-RS3-OPT-CALC-TYPE-CD                              
                  ,:S-RS3-WEB-MKT-DESC-LONG                             
                  ,:S-RS3-OPT-VRSN-NO                                   
                  ,:S-RS3-OPT-VSTART-TS                                 
                  ,:S-RS3-OPT-VEND-TS                                   
                  ,:S-RS3-PROC-STATUS-CD                                
                  ,:S-RS3-PROC-REQ-ID                                   
PRJ892            ,:S-RS3-AUTO-RENEWAL-FL                               
PRJ892            ,:S-RS3-OPTION-PROMO-DESC                             
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04435_R3                                   
MFA-TR*       (                                                                 
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,OPTION_START_DT                                              
MFA-TR*           ,OPTION_END_DT                                                
MFA-TR*           ,OPT_DESC_INT                                                 
MFA-TR*           ,OPT_DESC_INT_LONG                                            
MFA-TR*           ,CURR_EXT_DESC_LONG                                           
MFA-TR*           ,RENEWAL_DESC_LONG                                            
MFA-TR*           ,WEB_DESC_LONG                                                
MFA-TR*           ,STATUS_CD                                                    
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,OPT_CALC_TYPE_CD                                             
MFA-TR*           ,WEB_MKT_DESC_LONG                                            
MFA-TR*           ,OPT_VRSN_NO                                                  
MFA-TR*           ,OPT_VSTART_TS                                                
MFA-TR*           ,OPT_VEND_TS                                                  
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,AUTO_RENEWAL_FL                                              
MFA-TR*           ,OPTION_PROMO_DESC                                            
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-COMPANY-NO                                            
MFA-TR*           ,:S-RS3-OPTION-CD                                             
MFA-TR*           ,:S-RS3-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS3-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS3-OPTION-START-DT                                       
MFA-TR*           ,:S-RS3-OPTION-END-DT                                         
MFA-TR*           ,:S-RS3-OPT-DESC-INT                                          
MFA-TR*           ,:S-RS3-OPT-DESC-INT-LONG                                     
MFA-TR*           ,:S-RS3-CURR-EXT-DESC-LONG                                    
MFA-TR*           ,:S-RS3-RENEWAL-DESC-LONG                                     
MFA-TR*           ,:S-RS3-WEB-DESC-LONG                                         
MFA-TR*           ,:S-RS3-STATUS-CD                                             
MFA-TR*           ,:S-RS3-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS3-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS3-OPT-CALC-TYPE-CD                                      
MFA-TR*           ,:S-RS3-WEB-MKT-DESC-LONG                                     
MFA-TR*           ,:S-RS3-OPT-VRSN-NO                                           
MFA-TR*           ,:S-RS3-OPT-VSTART-TS                                         
MFA-TR*           ,:S-RS3-OPT-VEND-TS                                           
MFA-TR*           ,:S-RS3-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS3-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS3-AUTO-RENEWAL-FL                                       
MFA-TR*           ,:S-RS3-OPTION-PROMO-DESC                                     
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = 'Y'             
              ADD +1                         TO  CTR-ROWS-RS3           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8030'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R3         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04435_R3'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8050-INSERT-GTT-R5.   MKT PROMOTION TABLE                      *        
      ******************************************************************        
       8050-INSERT-GTT-R5.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04435_R5                           
              (                                                         
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,PROMO_CD                                             
                  ,PROMO_DESC                                           
                  ,OFFER_CD                                             
                  ,MKT_PLAN_CD                                          
                  ,PROMO_START_DT                                       
                  ,PROMO_START_TM                                       
                  ,PROMO_END_DT                                         
                  ,PROMO_END_TM                                         
                  ,AD_CHANNEL_CD                                        
                  ,PROMO_DESC_LONG                                      
                  ,EXT_LANDING_PG_URL                                   
                  ,PROMO_TYPE_CD                                        
                  ,WEB_IMAGE_FILE_NM                                    
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,REPLACMNT_PROMO_CD                                   
                  ,DISPLAY_END_DT                                       
                  ,INT_LANDING_PG_URL                                   
                  ,PROMO_VRSN_NO                                        
                  ,PROMO_VSTART_TS                                      
                  ,PROMO_VEND_TS                                        
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
              )                                                         
              VALUES                                                    
              (                                                         
                   :S-RETURN-CODE-5                                     
                  ,:S-APPL-RETURN-CODE-5                                
                  ,:S-RS5-COMPANY-NO                                    
                  ,:S-RS5-PROMO-CD                                      
                  ,:S-RS5-PROMO-DESC                                    
                  ,:S-RS5-OFFER-CD                                      
                  ,:S-RS5-MKT-PLAN-CD                                   
                  ,:S-RS5-PROMO-START-DT                                
                  ,:S-RS5-PROMO-START-TM                                
                  ,:S-RS5-PROMO-END-DT                                  
                  ,:S-RS5-PROMO-END-TM                                  
                  ,:S-RS5-AD-CHANNEL-CD                                 
                  ,:S-RS5-PROMO-DESC-LONG                               
                  ,:S-RS5-EXT-LANDING-PG-URL                            
                  ,:S-RS5-PROMO-TYPE-CD                                 
                  ,:S-RS5-WEB-IMAGE-FILE-NM                             
                  ,:S-RS5-LAST-UPDATE-USERID                            
                  ,:S-RS5-LAST-UPDATE-TS                                
                  ,:S-RS5-REPLACMNT-PROMO-CD                            
                  ,:S-RS5-DISPLAY-END-DT                                
                  ,:S-RS5-INT-LANDING-PG-URL                            
                  ,:S-RS5-PROMO-VRSN-NO                                 
                  ,:S-RS5-PROMO-VSTART-TS                               
                  ,:S-RS5-PROMO-VEND-TS                                 
                  ,:S-RS5-PROC-STATUS-CD                                
                  ,:S-RS5-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04435_R5                                   
MFA-TR*       (                                                                 
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,PROMO_CD                                                     
MFA-TR*           ,PROMO_DESC                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,MKT_PLAN_CD                                                  
MFA-TR*           ,PROMO_START_DT                                               
MFA-TR*           ,PROMO_START_TM                                               
MFA-TR*           ,PROMO_END_DT                                                 
MFA-TR*           ,PROMO_END_TM                                                 
MFA-TR*           ,AD_CHANNEL_CD                                                
MFA-TR*           ,PROMO_DESC_LONG                                              
MFA-TR*           ,EXT_LANDING_PG_URL                                           
MFA-TR*           ,PROMO_TYPE_CD                                                
MFA-TR*           ,WEB_IMAGE_FILE_NM                                            
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,REPLACMNT_PROMO_CD                                           
MFA-TR*           ,DISPLAY_END_DT                                               
MFA-TR*           ,INT_LANDING_PG_URL                                           
MFA-TR*           ,PROMO_VRSN_NO                                                
MFA-TR*           ,PROMO_VSTART_TS                                              
MFA-TR*           ,PROMO_VEND_TS                                                
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*            :S-RETURN-CODE-5                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-5                                        
MFA-TR*           ,:S-RS5-COMPANY-NO                                            
MFA-TR*           ,:S-RS5-PROMO-CD                                              
MFA-TR*           ,:S-RS5-PROMO-DESC                                            
MFA-TR*           ,:S-RS5-OFFER-CD                                              
MFA-TR*           ,:S-RS5-MKT-PLAN-CD                                           
MFA-TR*           ,:S-RS5-PROMO-START-DT                                        
MFA-TR*           ,:S-RS5-PROMO-START-TM                                        
MFA-TR*           ,:S-RS5-PROMO-END-DT                                          
MFA-TR*           ,:S-RS5-PROMO-END-TM                                          
MFA-TR*           ,:S-RS5-AD-CHANNEL-CD                                         
MFA-TR*           ,:S-RS5-PROMO-DESC-LONG                                       
MFA-TR*           ,:S-RS5-EXT-LANDING-PG-URL                                    
MFA-TR*           ,:S-RS5-PROMO-TYPE-CD                                         
MFA-TR*           ,:S-RS5-WEB-IMAGE-FILE-NM                                     
MFA-TR*           ,:S-RS5-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS5-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS5-REPLACMNT-PROMO-CD                                    
MFA-TR*           ,:S-RS5-DISPLAY-END-DT                                        
MFA-TR*           ,:S-RS5-INT-LANDING-PG-URL                                    
MFA-TR*           ,:S-RS5-PROMO-VRSN-NO                                         
MFA-TR*           ,:S-RS5-PROMO-VSTART-TS                                       
MFA-TR*           ,:S-RS5-PROMO-VEND-TS                                         
MFA-TR*           ,:S-RS5-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS5-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R5 = 'Y'             
              ADD +1                         TO  CTR-ROWS-RS5           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8050'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R5         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04435_R5'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8050-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8060-INSERT-GTT-R6.   CRM_MKT_TIER TABLE                       *        
      ******************************************************************        
       8060-INSERT-GTT-R6.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04435_R6                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,RATE_GROUP_TYPE_CD                                   
                  ,RATE_GROUP_CD                                        
                  ,SORT_SEQ_NO                                          
                  ,EFF_START_DT                                         
                  ,EFF_END_DT                                           
                  ,OFFER_CD                                             
                  ,OPTION_CD                                            
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,GRP_OFF_VRSN_NO                                      
                  ,GRP_OFF_VSTART_TS                                    
                  ,GRP_OFF_VEND_TS                                      
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-6                                     
                  ,:S-APPL-RETURN-CODE-6                                
                  ,:S-RS6-COMPANY-NO                                    
                  ,:S-RS6-RATE-GROUP-TYPE-CD                            
                  ,:S-RS6-RATE-GROUP-CD                                 
                  ,:S-RS6-SORT-SEQ-NO                                   
                  ,:S-RS6-EFF-START-DT                                  
                  ,:S-RS6-EFF-END-DT                                    
                  ,:S-RS6-OFFER-CD                                      
                  ,:S-RS6-OPTION-CD                                     
                  ,:S-RS6-LAST-UPDATE-USERID                            
                  ,:S-RS6-LAST-UPDATE-TS                                
                  ,:S-RS6-GRP-OFF-VRSN-NO                               
                  ,:S-RS6-GRP-OFF-VSTART-TS                             
                  ,:S-RS6-GRP-OFF-VEND-TS                               
                  ,:S-RS6-PROC-STATUS-CD                                
                  ,:S-RS6-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04435_R6                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,RATE_GROUP_TYPE_CD                                           
MFA-TR*           ,RATE_GROUP_CD                                                
MFA-TR*           ,SORT_SEQ_NO                                                  
MFA-TR*           ,EFF_START_DT                                                 
MFA-TR*           ,EFF_END_DT                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,GRP_OFF_VRSN_NO                                              
MFA-TR*           ,GRP_OFF_VSTART_TS                                            
MFA-TR*           ,GRP_OFF_VEND_TS                                              
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-6                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-6                                        
MFA-TR*           ,:S-RS6-COMPANY-NO                                            
MFA-TR*           ,:S-RS6-RATE-GROUP-TYPE-CD                                    
MFA-TR*           ,:S-RS6-RATE-GROUP-CD                                         
MFA-TR*           ,:S-RS6-SORT-SEQ-NO                                           
MFA-TR*           ,:S-RS6-EFF-START-DT                                          
MFA-TR*           ,:S-RS6-EFF-END-DT                                            
MFA-TR*           ,:S-RS6-OFFER-CD                                              
MFA-TR*           ,:S-RS6-OPTION-CD                                             
MFA-TR*           ,:S-RS6-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS6-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS6-GRP-OFF-VRSN-NO                                       
MFA-TR*           ,:S-RS6-GRP-OFF-VSTART-TS                                     
MFA-TR*           ,:S-RS6-GRP-OFF-VEND-TS                                       
MFA-TR*           ,:S-RS6-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS6-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R6 = 'Y'             
              ADD +1                         TO  CTR-ROWS-RS6           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8060'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R6         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04435_R6'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8060-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8070-INSERT-GTT-R7.   CRM_OFFER_OPTION                         *        
      ******************************************************************        
       8070-INSERT-GTT-R7.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04435_R7                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,OFFER_CD                                             
                  ,OPTION_CD                                            
                  ,OPTION_SORT_SEQ_NO                                   
                  ,OPTION_URL_TX                                        
                  ,DROP_OPTION_CD                                       
                  ,OFFER_OPT_START_DT                                   
                  ,OFFER_OPT_END_DT                                     
                  ,OFF_OPT_VRSN_NO                                      
                  ,OFF_OPT_VSTART_TS                                    
                  ,OFF_OPT_VEND_TS                                      
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-7                                     
                  ,:S-APPL-RETURN-CODE-7                                
                  ,:S-RS7-COMPANY-NO                                    
                  ,:S-RS7-OFFER-CD                                      
                  ,:S-RS7-OPTION-CD                                     
                  ,:S-RS7-OPTION-SORT-SEQ-NO                            
                  ,:S-RS7-OPTION-URL-TX                                 
                  ,:S-RS7-DROP-OPTION-CD                                
                  ,:S-RS7-OFFER-OPT-START-DT                            
                  ,:S-RS7-OFFER-OPT-END-DT                              
                  ,:S-RS7-OFF-OPT-VRSN-NO                               
                  ,:S-RS7-OFF-OPT-VSTART-TS                             
                  ,:S-RS7-OFF-OPT-VEND-TS                               
                  ,:S-RS7-PROC-STATUS-CD                                
                  ,:S-RS7-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04435_R7                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,OPTION_SORT_SEQ_NO                                           
MFA-TR*           ,OPTION_URL_TX                                                
MFA-TR*           ,DROP_OPTION_CD                                               
MFA-TR*           ,OFFER_OPT_START_DT                                           
MFA-TR*           ,OFFER_OPT_END_DT                                             
MFA-TR*           ,OFF_OPT_VRSN_NO                                              
MFA-TR*           ,OFF_OPT_VSTART_TS                                            
MFA-TR*           ,OFF_OPT_VEND_TS                                              
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-7                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-7                                        
MFA-TR*           ,:S-RS7-COMPANY-NO                                            
MFA-TR*           ,:S-RS7-OFFER-CD                                              
MFA-TR*           ,:S-RS7-OPTION-CD                                             
MFA-TR*           ,:S-RS7-OPTION-SORT-SEQ-NO                                    
MFA-TR*           ,:S-RS7-OPTION-URL-TX                                         
MFA-TR*           ,:S-RS7-DROP-OPTION-CD                                        
MFA-TR*           ,:S-RS7-OFFER-OPT-START-DT                                    
MFA-TR*           ,:S-RS7-OFFER-OPT-END-DT                                      
MFA-TR*           ,:S-RS7-OFF-OPT-VRSN-NO                                       
MFA-TR*           ,:S-RS7-OFF-OPT-VSTART-TS                                     
MFA-TR*           ,:S-RS7-OFF-OPT-VEND-TS                                       
MFA-TR*           ,:S-RS7-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS7-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R7 = 'Y'             
              ADD +1                         TO  CTR-ROWS-RS7           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8070'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R6         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04435_R7'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8070-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 0                          TO S-RETURN-CODE-1        
              MOVE 100                        TO S-APPL-RETURN-CODE-1   
              PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                          TO S-RETURN-CODE-2        
              MOVE 100                        TO S-APPL-RETURN-CODE-2   
              PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 0                          TO S-RETURN-CODE-3        
              MOVE 100                        TO S-APPL-RETURN-CODE-3   
              PERFORM 8030-INSERT-GTT-R3         THRU 8030-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS5 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 0                          TO S-RETURN-CODE-5        
              MOVE 100                        TO S-APPL-RETURN-CODE-5   
              PERFORM 8050-INSERT-GTT-R5         THRU 8050-EXIT         
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS6 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-6                            
              MOVE 0                          TO S-RETURN-CODE-6        
              MOVE 100                        TO S-APPL-RETURN-CODE-6   
              PERFORM 8060-INSERT-GTT-R6         THRU 8060-EXIT         
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS7 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-7                            
              MOVE 0                          TO S-RETURN-CODE-7        
              MOVE 100                        TO S-APPL-RETURN-CODE-7   
              PERFORM 8070-INSERT-GTT-R7         THRU 8070-EXIT         
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                  TO ABEND-PROGRAM          
           MOVE '8900'                        TO ACTIVE-PARAGRAPH       
           MOVE 'OPEN'                        TO ABEND-FUNCTION         
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE SQLSTATE                   TO ABEND-SQLSTATE         
              MOVE 'CSR04435_R1'              TO TABLE-1                
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04435_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04435_R3'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04435_R5'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C6                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04435_R6'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C7                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04435_R7'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-RETURN-CODE-1         
                                                S-RETURN-CODE-2         
                                                S-RETURN-CODE-3         
                                                S-RETURN-CODE-5         
                                                S-RETURN-CODE-6         
                                                S-RETURN-CODE-7.        
                                                                        
           MOVE WS-APPL-RETURN-CODE          TO S-APPL-RETURN-CODE-1    
                                                S-APPL-RETURN-CODE-2    
                                                S-APPL-RETURN-CODE-3    
                                                S-APPL-RETURN-CODE-5    
                                                S-APPL-RETURN-CODE-6    
                                                S-APPL-RETURN-CODE-7.   
                                                                        
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1         THRU 0100A-EXIT.        
           PERFORM 0100B-DECLARE-GTT-R2         THRU 0100B-EXIT.        
           PERFORM 0100C-DECLARE-GTT-R3         THRU 0100C-EXIT.        
           PERFORM 0100E-DECLARE-GTT-R5         THRU 0100E-EXIT.        
           PERFORM 0100F-DECLARE-GTT-R6         THRU 0100F-EXIT.        
           PERFORM 0100G-DECLARE-GTT-R7         THRU 0100G-EXIT.        
                                                                        
           PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
           PERFORM 8020-INSERT-GTT-R2           THRU 8020-EXIT.         
           PERFORM 8030-INSERT-GTT-R3           THRU 8030-EXIT.         
           PERFORM 8050-INSERT-GTT-R5           THRU 8050-EXIT.         
           PERFORM 8060-INSERT-GTT-R6           THRU 8060-EXIT.         
           PERFORM 8070-INSERT-GTT-R7           THRU 8070-EXIT.         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT.         
           PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT.         
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS       THRU 8800-EXIT             
            PERFORM 8900-SEND-DONE           THRU 8900-EXIT             
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
