       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04431.                                      
COB303 DATE-WRITTEN.     APRIL 22, 2011.                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04431              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04431 :                                                --         
      *--                                                            --         
      *--  SEARCH CRM TABLE INFORMATION FROM THE BELOW TABLE         --         
      *--  USED BY RPM WIZARDS.                                      --         
      *--                                                            --         
      *--       CRM_RT_PKG_OFFER                                     --         
      *--       CRM_RT_PKG_OPTION                                    --         
      *--       CRM_MKT_PROMOTION                                    --         
      *--       CRM_MKT_TIER                                         --         
      *--       CRM_OPT_ATTR_INCTV                                   --         
      *--                                                            --         
      *--                                                            --         
      *--  APPLICATION RETURN CODE:                                  --         
      *--       +1000 - SEARCH METHOD INVALID                        --         
      *--       +1010 - SEARCH CRITERIA INVALID                      --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             APPLICATION_ID      CHAR(03)                   --         
      *--             RESOURCE_ID         CHAR(32)                   --         
      *--             USER_ID             CHAR(07)                   --         
      *--             COMPANY_NO          CHAR(02)                   --         
      *--             SEARCH_METHOD       CHAR(05)                   --         
      *--             SEARCH_CRITERIA     CHAR(50)                   --         
      *--             WILDCARD_FLAG       CHAR(01)                   --         
      *--             ACTV_PRD_FLAG       CHAR(01)                   --         
      *--             PROC_STATUS_FLAG    CHAR(01)                   --         
      *--             PROC_STATUS         CHAR(02)                   --         
      *--             VRSN_TS_FLAG        CHAR(01)                   --         
      *--             CHK_START_TS        CHAR(26)                   --         
      *--             CHK_END_TS          CHAR(26)                   --         
      *--             CUSTOMER_TYPE_CD    CHAR(01)                   --         
      *--             ACCOUNT_TYPE_CD     CHAR(01)                   --         
      *--             MKT_TIER_RANKING    SMALLINT                   --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04431_R1 - OFFER CODE DEATILS                   --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           OFFER_DESC_INT          CHAR(50)                 --         
      *--           OFFER_DESC_EXT          CHAR(50)                 --         
      *--           PROMO_CD_INT_FL         CHAR(01)                 --         
      *--           PROMO_CD_EXT_FL         CHAR(01)                 --         
      *--           OFFER_START_DT          CHAR(10)                 --         
      *--           OFFER_END_DT            CHAR(10)                 --         
      *--           DISP_START_INT_TS       CHAR(26)                 --         
      *--           DISP_END_INT_TS         CHAR(26)                 --         
      *--           DISP_START_EXT_TS       CHAR(26)                 --         
      *--           DISP_END_EXT_TS         CHAR(26)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           OFFER_DESC_INT_LNG      VARCHAR(255)             --         
      *--           OFFER_DESC_EXT_LNG      VARCHAR(255)             --         
      *--           SPCL_OFFER_TYPE_CD      CHAR(02)                 --         
      *--           RENEWAL_OFFER_CD        CHAR(12)                 --         
      *--           RENEW_PUB_OFFER_CD      CHAR(01)                 --         
      *--           OFF_VRSN_NO             SMALLINT                 --         
      *--           OFF_VSTART_TS           CHAR(26)                 --         
      *--           OFF_VEND_TS             CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
PRJ892*--           MAX_PRICE_OFFER_CD      CHAR(12)                 --         
PRJ892*--           RTCHG_PUB_OFFER_CD      CHAR(12)                 --         
      *--                                                            --         
      *--    2. CSR04431_R2  OPTION CODE DETAILS                     --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           CODE_UTIL_TYPE          CHAR(01)                 --         
      *--           RATE_PLAN_NO            CHAR(03)                 --         
      *--           OPTION_START_DT         CHAR(10)                 --         
      *--           OPTION_END_DT           CHAR(10)                 --         
      *--           OPT_DESC_INT            CHAR(50)                 --         
      *--           OPT_DESC_INT_LONG       VARCHAR(255)             --         
      *--           CURR_EXT_DESC_LONG      VARCHAR(255)             --         
      *--           RENEWAL_DESC_LONG       VARCHAR(255)             --         
      *--           WEB_DESC_LONG           VARCHAR(255)             --         
      *--           STATUS_CD               CHAR(01)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           OPT_CALC_TYPE_CD        CHAR(02)                 --         
      *--           WEB_MKT_DESC_LONG       VARCHAR(1024)            --         
      *--           OPT_VRSN_NO             SMALLINT                 --         
      *--           OPT_VSTART_TS           CHAR(26)                 --         
      *--           OPT_VEND_TS             CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
A04805*--           OPTION_TYPE_DESC        CHAR(50)                 --         
PRJ892*--           AUTO_RENEWAL_FL         CHAR(01)                 --         
PRJ892*--           OPTION_PROMO_DESC       VARCHAR(255)             --         
      *--                                                            --         
      *--    3. CSR04431_R3 - MARKETTING PROMOTION                   --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           PROMO_CD                CHAR(12)                 --         
      *--           PROMO_DESC              CHAR(50)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           MKT_PLAN_CD             CHAR(12)                 --         
      *--           PROMO_START_DT          CHAR(10)                 --         
      *--           PROMO_START_TM          CHAR(08)                 --         
      *--           PROMO_END_DT            CHAR(10)                 --         
      *--           PROMO_END_TM            CHAR(08)                 --         
      *--           AD_CHANNEL_CD           CHAR(10)                 --         
      *--           PROMO_DESC_LONG         VARCHAR(255)             --         
      *--           EXT_LANDING_PG_URL      VARCHAR(255)             --         
      *--           PROMO_TYPE_CD           CHAR(02)                 --         
      *--           WEB_IMAGE_FILE_NM       VARCHAR(100)             --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           REPLACMNT_PROMO_CD      CHAR(12)                 --         
      *--           DISPLAY_END_DT          CHAR(10)                 --         
      *--           INT_LANDING_PG_URL      VARCHAR(255)             --         
      *--           PROMO_VRSN_NO           SMALLINT                 --         
      *--           PROMO_VSTART_TS         CHAR(26)                 --         
      *--           PROMO_VEND_TS           CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--                                                            --         
      *--    4. CSR04431_R4 - OFFER MARKETTING TIER                  --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           TIER_CUST_STAT_CD       CHAR(01)                 --         
      *--           TIER_ACCT_TYPE_CD       CHAR(01)                 --         
      *--           MKT_TIER_RANKING        SMALLINT                 --         
      *--           MKT_TIER_START_DT       CHAR(10)                 --         
      *--           MKT_TIER_DESC           CHAR(50)                 --         
      *--           MKT_TIER_END_DT         CHAR(10)                 --         
      *--           TIER_OFFER_VIEW         SMALLINT                 --         
      *--           OFFER_TIER_STRT_DT      CHAR(10)                 --         
      *--           MKT_TIER_APPLY_CD       CHAR(01)                 --         
      *--           TIER_DEFLT_OFFR_CD      CHAR(01)                 --         
      *--           OFFER_TIER_END_DT       CHAR(10)                 --         
      *--           CUST_ACCT_DEFLT_FL      CHAR(01)                 --         
      *--           MKT_TIER_DESC_LONG      VARCHAR(255)             --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           OFF_TIER_VRSN_NO        SMALLINT                 --         
      *--           OFF_TIER_VSTART_TS      CHAR(26)                 --         
      *--           OFF_TIER_VEND_TS        CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--                                                            --         
      *--    5. CSR04431_R5 - OPTION ATTR INCTV                      --         
      *--           RETURN_CODE             INTEGER                  --         
      *--          ,APPL_RETURN_CODE        INTEGER                  --         
      *--          ,COMPANY_NO              CHAR(02)                 --         
      *--          ,OPTION_CD               CHAR(12)                 --         
      *--          ,ATTR_INCTV_SEQ_NO       SMALLINT                 --         
      *--          ,RT_ATTR_INCTV_TYPE      CHAR(15)                 --         
      *--          ,PRIMRY_OPT_ATTR_FL      CHAR(01)                 --         
      *--          ,FACTOR_ID               CHAR(09)                 --         
      *--          ,DURATION_NO             SMALLINT                 --         
      *--          ,APPL_PROGRAM_ID         CHAR(09)                 --         
      *--          ,ATTR_INCTV_VALUE        DECIMAL(11,6)            --         
      *--          ,ATTR_INCTV_VAL_TX       CHAR(20)                 --         
      *--          ,LAST_UPDATE_USERID      CHAR(07)                 --         
      *--          ,LAST_UPDATE_TS          CHAR(26)                 --         
      *--          ,GL_ACCT_CREDIT          DECIMAL(7,4)             --         
      *--          ,GL_ACCT_DEBIT           DECIMAL(7,4)             --         
      *--          ,CATEGORY_ID             SMALLINT                 --         
      *--          ,WQ_ROUTE_CATEGORY       CHAR(01)                 --         
      *--          ,OPT_CHG_ACTION_CD       CHAR(01)                 --         
      *--          ,ATTR_INCTV_STRT_DT      CHAR(10)                 --         
      *--          ,ATTR_INCTV_END_DT       CHAR(10)                 --         
      *--          ,OPT_ATTR_VRSN_NO        SMALLINT                 --         
      *--          ,OPT_ATTR_VSTART_TS      CHAR(26)                 --         
      *--          ,OPT_ATTR_VEND_TS        CHAR(26)                 --         
      *--          ,PROC_STATUS_CD          CHAR(02)                 --         
      *--          ,PROC_REQ_ID             DECIMAL(10,0)            --         
      *--                                                            --         
      *--    5. CSR04431_R6 - OFFER OPTION DETAILS                   --         
      *--          ,RETURN_CODE             INTEGER                  --         
      *--          ,APPL_RETURN_CODE        INTEGER                  --         
      *--          ,COMPANY_NO              CHAR(02)                 --         
      *--          ,OFFER_CD                CHAR(12)                 --         
      *--          ,OPTION_CD               CHAR(12)                 --         
      *--          ,OPTION_SORT_SEQ_NO      SMALLINT                 --         
      *--          ,OFFER_OPT_START_DT      CHAR(10)                 --         
      *--          ,OFFER_OPT_END_DT        CHAR(10)                 --         
      *--          ,OFF_OPT_VRSN_NO         SMALLINT                 --         
      *--          ,OFF_OPT_VSTART_TS       CHAR(26)                 --         
      *--          ,OFF_OPT_VEND_TS         CHAR(26)                 --         
      *--          ,PROC_STATUS_CD          CHAR(02)                 --         
      *--          ,PROC_REQ_ID             DECIMAL(10,0)            --         
A04805*--          ,WEB_NEW_EXISTS_CD       CHAR(1)                  --         
A04805*--          ,WEB_SIGN_UP_FL          CHAR(1)                  --         
A04805*--          ,OFF_OPT_EXCLUDE_CD      CHAR(1)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00473*--  03/22/2011    MS93554     SEARCH CRM TABLE INFORMATION    --         
      *--                            USED BY RPM WIZARDS.            --         
A04805*--  12/04/2013    MS93554     NEW COLUMNS ARE ADDED IN CRM_   --         
      *                              OFFER_OPTION & CRM_RT_PKG_OPTION--         
      *                              TABLES.                         --         
PRJ892*--  04/14/2015    SS95855     NEW COLUMNS ARE ADDED IN        --         
      *                              CRM_RT_PKG_OPTION &             --         
      *                              CRM_RT_PKG_OFFER TABLE.         --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04431'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04431 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04431'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS4                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS5                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS6                 PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WS-MISC.                                                     
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-WILDCARD-FLAG             PIC X(01).                  
           05  WS-PENDING-FLAG              PIC X(01).                  
           05  WS-ACTV-PRD-FLAG             PIC X(01).                  
           05  WS-PROC-STATUS-FLAG          PIC X(01).                  
           05  WS-SEARCH-CRITERIA           PIC X(52) VALUE SPACES.     
           05  WS-FRMT-SRCH-TXT.                                        
             10  WS-FRMT-SRCH-CHAR          PIC X(01) VALUE '%'.        
             10  WS-FRMT-SRCH-STRNG         PIC X(51) VALUE SPACES.     
           05  WS-CHK-VSTART-TS             PIC X(26).                  
           05  WS-CHK-VEND-TS               PIC X(26).                  
           05  WS-CHK-START-DT              PIC X(10).                  
           05  WS-CHK-END-DT                PIC X(10).                  
           05  WS-VERSION-START-TS          PIC X(26).                  
           05  WS-VERSION-END-TS            PIC X(26).                  
           05  WS-PROC-STATUS-CD            PIC X(02).                  
           05  WS-APRVL-CMPLT               PIC X(02) VALUE 'AC'.       
           05  WS-TIER-ACCT-TYPE-CD         PIC X(01).                  
           05  WS-TIER-CUST-STAT-CD         PIC X(01).                  
           05  WS-MKT-TIER-RANKING          PIC S9(04) USAGE COMP       
                                                           VALUE 0.     
           05  WS-VRSN-TS-FLAG              PIC X(01).                  
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-OFFER-CD-KEY              PIC X(12) VALUE SPACES.     
           05  WS-CURR-TIMESTAMP            PIC X(26) VALUE SPACES.     
           05  WS-CURRENT-DATE              PIC X(10) VALUE SPACES.     
           05  WS-ACTIVE-ONLY               PIC X(01) VALUE SPACES.     
           05  WS-ACTIVE-START-DT           PIC X(10) VALUE SPACES.     
           05  WS-ACTIVE-END-DT             PIC X(10) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(04) VALUE 0.         
                                                                        
       01  WS-OFFER-KEYS.                                               
           05 WS-OPTION-CD-KEY              PIC X(12).                  
           05 WS-PROMO-CD-KEY               PIC X(12).                  
           05 WS-MKT-TIER-RANKING-KEY       PIC S9(4) USAGE COMP.       
           05 WS-TIER-CUST-STAT-CD-KEY      PIC X(01).                  
           05 WS-TIER-ACCT-TYPE-CD-KEY      PIC X(01).                  
           05 WS-MKT-TIER-START-DT-KEY      PIC X(10).                  
                                                                        
       01  WS-NULL-IND.                                                 
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.        
              88 NO-MORE-ROWS                         VALUE 'Y'.        
           05 WS-NO-MORE-ATTR-INC-ROWS      PIC X(01) VALUE 'N'.        
              88 NO-MORE-ATTR-ROWS                    VALUE 'Y'.        
           05 WS-NO-MORE-OFF-OPT-ROWS       PIC X(01) VALUE 'N'.        
              88 NO-MORE-OFF-OPT-ROWS                 VALUE 'Y'.        
           05 WS-NO-MORE-TIER-ROWS          PIC X(01) VALUE 'N'.        
              88 NO-MORE-TIER-ROWS                    VALUE 'Y'.        
           05 WS-NO-MORE-PROMO-ROWS         PIC X(01) VALUE 'N'.        
              88 NO-MORE-PROMO-ROWS                   VALUE 'Y'.        
           05 WS-NO-MORE-OFFER-ROWS         PIC X(01) VALUE 'N'.        
              88 NO-MORE-OFFER-ROWS                   VALUE 'Y'.        
           05 WS-NO-MORE-OPTION-ROWS        PIC X(01) VALUE 'N'.        
              88 NO-MORE-OPTION-ROWS                  VALUE 'Y'.        
           05 WS-STATUS-FOR-OFFER           PIC X(01) VALUE 'N'.        
              88 ROW-FOUND-FOR-OFFER                  VALUE 'Y'.        
           05 WS-STATUS-FOR-OPTION          PIC X(01) VALUE 'N'.        
              88 ROW-FOUND-FOR-OPTION                 VALUE 'Y'.        
           05 WS-RPM-WIZARDS-SW             PIC X(06) VALUE ' '.        
              88 RPM001-CREATE-NEW-OFFER              VALUE 'RPM001'.   
              88 RPM002-MODIFY-OFFER                  VALUE 'RPM002'.   
              88 RPM012-GLOBAL-SEARCH                 VALUE 'RPM012'.   
      *                                                                         
       01  WS-FLAGS.                                                    
           05 WS-ERR-INSRT-R1               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R2               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R3               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R4               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R5               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R6               PIC X(01) VALUE 'N'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                  PIC S9(04)  COMP VALUE 0.   
      *************************************************************             
      *      LATYOUT FOR OFFER TABLE - CRM_RT_PKG_OFFER           *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-COMPANY-NO            PIC X(2).                   
             10 S-RS1-OFFER-CD              PIC X(12).                  
             10 S-RS1-OPTION-CD-KEY         PIC X(12).                  
             10 S-RS1-PROMO-CD-KEY          PIC X(12).                  
             10 S-RS1-MKT-TIER-RANK-KEY     PIC S9(4) USAGE COMP.       
             10 S-RS1-TIER-CUST-STAT-CD-KEY PIC X(01).                  
             10 S-RS1-TIER-ACCT-TYPE-CD-KEY PIC X(01).                  
             10 S-RS1-MKT-TIER-START-DT     PIC X(10).                  
             10 S-RS1-OFFER-DESC-INT        PIC X(50).                  
             10 S-RS1-OFFER-DESC-EXT        PIC X(50).                  
             10 S-RS1-PROMO-CD-INT-FL       PIC X(1).                   
             10 S-RS1-PROMO-CD-EXT-FL       PIC X(1).                   
             10 S-RS1-OFFER-START-DT        PIC X(10).                  
             10 S-RS1-OFFER-END-DT          PIC X(10).                  
             10 S-RS1-DISP-START-INT-TS     PIC X(26).                  
             10 S-RS1-DISP-END-INT-TS       PIC X(26).                  
             10 S-RS1-DISP-START-EXT-TS     PIC X(26).                  
             10 S-RS1-DISP-END-EXT-TS       PIC X(26).                  
             10 S-RS1-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS1-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS1-OFFER-DESC-INT-LNG.                               
                49 S-RS1-OFFER-DESC-INT-LNG-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS1-OFFER-DESC-INT-LNG-TEXT                        
                                            PIC X(255).                 
             10 S-RS1-OFFER-DESC-EXT-LNG.                               
                49 S-RS1-OFFER-DESC-EXT-LNG-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS1-OFFER-DESC-EXT-LNG-TEXT                        
                                            PIC X(255).                 
             10 S-RS1-SPCL-OFFER-TYPE-CD    PIC X(2).                   
             10 S-RS1-RENEWAL-OFFER-CD      PIC X(12).                  
             10 S-RS1-RENEW-PUB-OFFER-CD    PIC X(1).                   
             10 S-RS1-OFF-VRSN-NO           PIC S9(4)  USAGE COMP.      
             10 S-RS1-OFF-VSTART-TS         PIC X(26).                  
             10 S-RS1-OFF-VEND-TS           PIC X(26).                  
             10 S-RS1-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS1-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
PRJ892       10 S-RS1-MAX-PRICE-OFFER-CD    PIC X(12).                  
PRJ892       10 S-RS1-RTCHG-PUB-OFFER-CD    PIC X(12).                  
                                                                        
      *************************************************************             
      *      LATYOUT FOR OPTION TABLE - CRM_RT_PKG_OPTION         *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-COMPANY-NO            PIC X(2).                   
             10 S-RS2-OPTION-CD             PIC X(12).                  
             10 S-RS2-OFFER-CD-KEY          PIC X(12).                  
             10 S-RS2-CODE-UTIL-TYPE        PIC X(1).                   
             10 S-RS2-RATE-PLAN-NO          PIC X(3).                   
             10 S-RS2-OPTION-START-DT       PIC X(10).                  
             10 S-RS2-OPTION-END-DT         PIC X(10).                  
             10 S-RS2-OPT-DESC-INT          PIC X(50).                  
             10 S-RS2-OPT-DESC-INT-LONG.                                
                49 S-RS2-OPT-DESC-INT-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-OPT-DESC-INT-LONG-TEXT                         
                                            PIC X(255).                 
             10 S-RS2-CURR-EXT-DESC-LONG.                               
                49 S-RS2-CURR-EXT-DESC-LONG-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-CURR-EXT-DESC-LONG-TEXT                        
                                            PIC X(255).                 
             10 S-RS2-RENEWAL-DESC-LONG.                                
                49 S-RS2-RENEWAL-DESC-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-RENEWAL-DESC-LONG-TEXT                         
                                            PIC X(255).                 
             10 S-RS2-WEB-DESC-LONG.                                    
                49 S-RS2-WEB-DESC-LONG-LEN  PIC S9(4) USAGE COMP.       
                49 S-RS2-WEB-DESC-LONG-TEXT PIC X(255).                 
             10 S-RS2-STATUS-CD             PIC X(1).                   
             10 S-RS2-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS2-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS2-OPT-CALC-TYPE-CD      PIC X(2).                   
             10 S-RS2-WEB-MKT-DESC-LONG.                                
                49 S-RS2-WEB-MKT-DESC-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-WEB-MKT-DESC-LONG-TEXT                         
                                            PIC X(1024).                
             10 S-RS2-OPT-VRSN-NO           PIC S9(4) USAGE COMP.       
             10 S-RS2-OPT-VSTART-TS         PIC X(26).                  
             10 S-RS2-OPT-VEND-TS           PIC X(26).                  
             10 S-RS2-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS2-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
A04805       10 S-RS2-OPTION-TYPE-DESC      PIC X(50) VALUE SPACES.     
PRJ892       10 S-RS2-AUTO-RENEWAL-FL       PIC X(01) VALUE SPACES.     
PRJ892       10 S-RS2-OPTION-PROMO-DESC.                                
PRJ892          49 S-RS2-OPTION-PROMO-DESC-LEN  PIC S9(4) USAGE COMP.   
PRJ892          49 S-RS2-OPTION-PROMO-DESC-TEXT PIC X(255).             
                                                                        
                                                                        
      *************************************************************             
      *   LATYOUT FOR MKT PROMOTION TABLE - CRM_MKT_PROMOTION     *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.    
             10 S-RS3-COMPANY-NO            PIC X(2).                   
             10 S-RS3-PROMO-CD              PIC X(12).                  
             10 S-RS3-PROMO-DESC            PIC X(50).                  
             10 S-RS3-OFFER-CD              PIC X(12).                  
             10 S-RS3-MKT-PLAN-CD           PIC X(12).                  
             10 S-RS3-PROMO-START-DT        PIC X(10).                  
             10 S-RS3-PROMO-START-TM        PIC X(8).                   
             10 S-RS3-PROMO-END-DT          PIC X(10).                  
             10 S-RS3-PROMO-END-TM          PIC X(8).                   
             10 S-RS3-AD-CHANNEL-CD         PIC X(10).                  
             10 S-RS3-PROMO-DESC-LONG.                                  
                49 S-RS3-PROMO-DESC-LONG-LEN   PIC S9(4) USAGE COMP.    
                49 S-RS3-PROMO-DESC-LONG-TEXT  PIC X(255).              
             10 S-RS3-EXT-LANDING-PG-URL.                               
                49 S-RS3-EXT-LANDING-PG-URL-LEN PIC S9(4) USAGE COMP.   
                49 S-RS3-EXT-LANDING-PG-URL-TEXT                        
                                            PIC X(255).                 
             10 S-RS3-PROMO-TYPE-CD         PIC X(2).                   
             10 S-RS3-WEB-IMAGE-FILE-NM.                                
                49 S-RS3-WEB-IMAGE-FILE-NM-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS3-WEB-IMAGE-FILE-NM-TEXT PIC X(100).             
             10 S-RS3-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS3-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS3-REPLACMNT-PROMO-CD    PIC X(12).                  
             10 S-RS3-DISPLAY-END-DT        PIC X(10).                  
             10 S-RS3-INT-LANDING-PG-URL.                               
                49 S-RS3-INT-LANDING-PG-URL-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS3-INT-LANDING-PG-URL-TEXT                        
                                            PIC X(255).                 
             10 S-RS3-PROMO-VRSN-NO         PIC S9(4)  USAGE COMP.      
             10 S-RS3-PROMO-VSTART-TS       PIC X(26).                  
             10 S-RS3-PROMO-VEND-TS         PIC X(26).                  
             10 S-RS3-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS3-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
                                                                        
      *************************************************************             
      *      LATYOUT FOR MKT TIER TABLE - CRM_MKT_TIER            *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4            PIC S9(04) COMP VALUE 0.     
             10 S-APPL-RETURN-CODE-4        PIC S9(04) COMP VALUE 0.    
             10 S-RS4-COMPANY-NO           PIC X(02).                   
             10 S-RS4-OFFER-CD             PIC X(12).                   
             10 S-RS4-TIER-CUST-STAT-CD    PIC X(01).                   
             10 S-RS4-TIER-ACCT-TYPE-CD    PIC X(01).                   
             10 S-RS4-MKT-TIER-RANKING     PIC S9(4) USAGE COMP.        
             10 S-RS4-MKT-TIER-START-DT    PIC X(10).                   
             10 S-RS4-MKT-TIER-DESC        PIC X(50).                   
             10 S-RS4-MKT-TIER-END-DT      PIC X(10).                   
             10 S-RS4-TIER-OFFER-VIEW      PIC S9(04) USAGE COMP.       
             10 S-RS4-OFFER-TIER-STRT-DT   PIC X(10).                   
             10 S-RS4-MKT-TIER-APPLY-CD    PIC X(01).                   
             10 S-RS4-TIER-DEFLT-OFFR-CD   PIC X(01).                   
             10 S-RS4-OFFER-TIER-END-DT    PIC X(10).                   
             10 S-RS4-CUST-ACCT-DEFLT-FL   PIC X(01).                   
             10 S-RS4-MKT-TIER-DESC-LONG.                               
                49 IG-MKT-TIER-DESC-LONG-LEN                            
                                           PIC S9(4) USAGE COMP.        
                49 IG-MKT-TIER-DESC-LONG-TEXT                           
                                           PIC X(255).                  
             10 S-RS4-LAST-UPDATE-USERID   PIC X(7).                    
             10 S-RS4-LAST-UPDATE-TS       PIC X(26).                   
             10 S-RS4-OFF-TIER-VRSN-NO     PIC S9(4) USAGE COMP.        
             10 S-RS4-OFF-TIER-VSTART-TS   PIC X(26).                   
             10 S-RS4-OFF-TIER-VEND-TS     PIC X(26).                   
             10 S-RS4-PROC-STATUS-CD       PIC X(06).                   
COB305       10 S-RS4-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.    
                                                                        
      *************************************************************             
      *      LAYOUT FOR ATTR INCEN TABLE - CRM_OPT_ATTR_INCEN     *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5            PIC S9(04) COMP VALUE 0.     
             10 S-APPL-RETURN-CODE-5        PIC S9(04) COMP VALUE 0.    
             10 S-RS5-COMPANY-NO           PIC X(2).                    
             10 S-RS5-OPTION-CD            PIC X(12).                   
             10 S-RS5-ATTR-INCTV-SEQ-NO    PIC S9(4) USAGE COMP.        
             10 S-RS5-RT-ATTR-INCTV-TYPE   PIC X(15).                   
             10 S-RS5-PRIMRY-OPT-ATTR-FL   PIC X(1).                    
             10 S-RS5-FACTOR-ID            PIC X(9).                    
             10 S-RS5-DURATION-NO          PIC S9(4) USAGE COMP.        
             10 S-RS5-APPL-PROGRAM-ID      PIC X(9).                    
COB305       10 S-RS5-ATTR-INCTV-VALUE        PIC S9(5)V9(6) 
COB305          USAGE COMP-3 VALUE 0. 
             10 S-RS5-ATTR-INCTV-VAL-TX    PIC X(20).                   
             10 S-RS5-LAST-UPDATE-USERID   PIC X(7).                    
             10 S-RS5-LAST-UPDATE-TS       PIC X(26).                   
COB305       10 S-RS5-GL-ACCT-CREDIT        PIC S9(3)V9(4) USAGE COMP-3 
COB305          VALUE 0. 
COB305       10 S-RS5-GL-ACCT-DEBIT        PIC S9(3)V9(4) USAGE COMP-3 
COB305          VALUE 0. 
             10 S-RS5-CATEGORY-ID          PIC S9(4) USAGE COMP.        
             10 S-RS5-WQ-ROUTE-CATEGORY    PIC X(01).                   
             10 S-RS5-OPT-CHG-ACTION-CD    PIC X(1).                    
             10 S-RS5-ATTR-INCTV-STRT-DT   PIC X(10).                   
             10 S-RS5-ATTR-INCTV-END-DT    PIC X(10).                   
             10 S-RS5-OPT-ATTR-VRSN-NO     PIC S9(4) USAGE COMP.        
             10 S-RS5-OPT-ATTR-VSTART-TS   PIC X(26).                   
             10 S-RS5-OPT-ATTR-VEND-TS     PIC X(26).                   
             10 S-RS5-PROC-STATUS-CD       PIC X(06).                   
COB305       10 S-RS5-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.    
                                                                        
      *************************************************************             
      *      LATYOUT FOR OFFER OPTION TABLE - CRM_OFFER_OPTION E9 *             
      *************************************************************             
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6            PIC S9(04) COMP VALUE 0.     
             10 S-APPL-RETURN-CODE-6       PIC S9(04) COMP VALUE 0.     
             10 S-RS6-COMPANY-NO           PIC X(2).                    
             10 S-RS6-OFFER-CD             PIC X(12).                   
             10 S-RS6-OPTION-CD            PIC X(12).                   
             10 S-RS6-OPTION-SORT-SEQ-NO   PIC S9(4) USAGE COMP.        
             10 S-RS6-OFFER-OPT-START-DT   PIC X(10).                   
             10 S-RS6-OFFER-OPT-END-DT     PIC X(10).                   
             10 S-RS6-OFF-OPT-VRSN-NO      PIC S9(4) USAGE COMP.        
             10 S-RS6-OFF-OPT-VSTART-TS    PIC X(26).                   
             10 S-RS6-OFF-OPT-VEND-TS      PIC X(26).                   
             10 S-RS6-PROC-STATUS-CD       PIC X(2).                    
COB305       10 S-RS6-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.    
A04805       10 S-RS6-WEB-NEW-EXISTS-CD    PIC X(1) VALUE SPACES.       
A04805       10 S-RS6-WEB-SIGN-UP-FL       PIC X(1) VALUE SPACES.       
A04805       10 S-RS6-OFF-OPT-EXCLUDE-CD   PIC X(1) VALUE SPACES.       
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OPTION  (FI)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_ATTR_INCV   (G7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTINCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OFFER   (FG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFFER_OPTION   (E9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFOPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV (HQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_PROMOTION  (KM)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_ACCESS_OFF_OPT  (CI)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRMACC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GRP_OFFER  (G5)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_TIER        (IG)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTTER                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFF_MKT_TIER   (DU)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFMKT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   DRIVER CURSOR DECLARATION TO SEARCH OFFER DETAILS BASED ON            
      *   SEARCH CRITERIA.                                                      
      * THIS CURSOR GET TRIGGERS WHEN USER SEARCH FROM                 *        
      *                                                                *        
      * GLOBAL SEARCH WIZARD:                                          *        
      * OFFER SEARCH                                                   *        
      *             A.WILD CARD SEARCH.                                *        
      *             B.ADVANCED SEARCH -BY DATE/BY STATS/BY ACTV IN PROD*        
      *                                                                *        
      * MODIFY OFFER WIZARD:                                           *        
      * OFFER SEARCH  WITH/WITHOUT WILD CARD.                          *        
      *                                                                *        
      * CREATE & REPLACE WIZARD:                                       *        
      * OFFER SEARCH  WITH/WITHOUT WILD CARD.                          *        
      *                                                                *        
      * CREATE/MODIFY WIZARD:                                          *        
      * ACTV OPTION SEARCH                                             *        
      *               OFFER CODE WITH/WITHOUT WILD CARD.               *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE OFFER_DRIVE_CUR CURSOR FOR                         
             SELECT FG.COMPANY_NO                                       
                   ,FG.OFFER_CD                                         
                   ,FG.OFFER_DESC_INT                                   
                   ,FG.OFFER_DESC_EXT                                   
                   ,FG.PROMO_CD_INT_FL                                  
                   ,FG.PROMO_CD_EXT_FL                                  
                   ,FG.OFFER_START_DT                                   
                   ,FG.OFFER_END_DT                                     
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_INT_TS                                
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_END_INT_TS
           , 121), ' ', '-'), ':', '.') DISP_END_INT_TS                        
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_EXT_TS                                
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_END_EXT_TS
           , 121), ' ', '-'), ':', '.') DISP_END_EXT_TS                        
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                   ,FG.LAST_UPDATE_USERID                               
                   ,FG.OFFER_DESC_INT_LNG                               
                   ,FG.OFFER_DESC_EXT_LNG                               
                   ,FG.SPCL_OFFER_TYPE_CD                               
                   ,FG.RENEWAL_OFFER_CD                                 
                   ,FG.RENEW_PUB_OFFER_CD                               
                   ,FG.OFF_VRSN_NO                                      
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VSTART_TS
           , 121), ' ', '-'), ':', '.') OFF_VSTART_TS                          
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS
           , 121), ' ', '-'), ':', '.') OFF_VEND_TS                            
                   ,FG.PROC_STATUS_CD                                   
                   ,FG.PROC_REQ_ID                                      
PRJ892             ,FG.MAX_PRICE_OFFER_CD                               
PRJ892             ,FG.RTCHG_PUB_OFFER_CD                               
               FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                  
      *WILD CARD SEARCH                                                         
              WHERE ((:WS-WILDCARD-FLAG  = 'Y'                          
                AND (FG.OFFER_CD             LIKE :WS-SEARCH-CRITERIA   
                 OR UPPER(FG.OFFER_DESC_INT) LIKE :WS-SEARCH-CRITERIA)) 
                 OR (:WS-WILDCARD-FLAG   = 'N'                          
                AND FG.OFFER_CD          = :WS-SEARCH-CRITERIA))        
      *SEARCH FOR MODIFY/CREATE OFFER WIZARDS                                   
      *       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=Y                             
      *GLOBAL SEARCH - SEARCH BY ACTIVE IN PRODUCTION FILTER                    
      *       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=N                             
                AND ((:WS-ACTV-PRD-FLAG  = 'Y'                          
                AND FG.OFF_VRSN_NO       =                              
                   (SELECT MAX(OFF_VRSN_NO)                             
                      FROM CRM_RT_PKG_OFFER F1 WITH(READUNCOMMITTED)            
                     WHERE F1.OFFER_CD         = FG.OFFER_CD            
                       AND ((F1.PROC_STATUS_CD  = :WS-APRVL-CMPLT       
                       AND  F1.OFF_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )    
                       AND  F1.OFF_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )    
                       AND  F1.OFFER_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )      
                       AND  F1.OFFER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )      
                       AND  :WS-ACTIVE-ONLY     = 'N')                  
                        OR (:WS-ACTIVE-ONLY     = 'Y'                   
                       AND  F1.OFFER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )))))  
                 OR  :WS-ACTV-PRD-FLAG   = 'N')                         
      *GLOBAL SEARCH - FILTER BY DATE RANGE                                     
                AND ((:WS-VRSN-TS-FLAG   = 'Y'                          
                AND ((FG.OFF_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              )            
                AND FG.OFF_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              ))           
                 OR (FG.OFF_VSTART_TS   >= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              )            
                AND FG.OFF_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                        :WS-CHK-VEND-TS
              ) ))           
                AND ((FG.OFFER_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) )             
                AND FG.OFFER_END_DT     >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) ))            
                 OR (FG.OFFER_START_DT  >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) )             
                AND FG.OFFER_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHK-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-END-DT
              ) <> 0) OR (LEN(:WS-CHK-END-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHK-END-DT
              ), CONVERT(DATE, :WS-CHK-END-DT) ))))            
                 OR (:WS-VRSN-TS-FLAG    = 'N') )                       
      *GLOBAL SEARCH - FILTER BY PROCESS STATUS CODE                            
                AND ((FG.PROC_STATUS_CD  = :WS-PROC-STATUS-CD           
                AND :WS-PROC-STATUS-FLAG = 'Y')                         
                 OR :WS-PROC-STATUS-FLAG = 'N')                         
                ORDER BY OFFER_CD,OFF_VRSN_NO DESC                      
                FOR READ ONLY                                   
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE OFFER_DRIVE_CUR CURSOR FOR                                 
MFA-TR*      SELECT FG.COMPANY_NO                                               
MFA-TR*            ,FG.OFFER_CD                                                 
MFA-TR*            ,FG.OFFER_DESC_INT                                           
MFA-TR*            ,FG.OFFER_DESC_EXT                                           
MFA-TR*            ,FG.PROMO_CD_INT_FL                                          
MFA-TR*            ,FG.PROMO_CD_EXT_FL                                          
MFA-TR*            ,FG.OFFER_START_DT                                           
MFA-TR*            ,FG.OFFER_END_DT                                             
MFA-TR*            ,FG.DISP_START_INT_TS                                        
MFA-TR*            ,FG.DISP_END_INT_TS                                          
MFA-TR*            ,FG.DISP_START_EXT_TS                                        
MFA-TR*            ,FG.DISP_END_EXT_TS                                          
MFA-TR*            ,FG.LAST_UPDATE_TS                                           
MFA-TR*            ,FG.LAST_UPDATE_USERID                                       
MFA-TR*            ,FG.OFFER_DESC_INT_LNG                                       
MFA-TR*            ,FG.OFFER_DESC_EXT_LNG                                       
MFA-TR*            ,FG.SPCL_OFFER_TYPE_CD                                       
MFA-TR*            ,FG.RENEWAL_OFFER_CD                                         
MFA-TR*            ,FG.RENEW_PUB_OFFER_CD                                       
MFA-TR*            ,FG.OFF_VRSN_NO                                              
MFA-TR*            ,FG.OFF_VSTART_TS                                            
MFA-TR*            ,FG.OFF_VEND_TS                                              
MFA-TR*            ,FG.PROC_STATUS_CD                                           
MFA-TR*            ,FG.PROC_REQ_ID                                              
MFA-TR*            ,FG.MAX_PRICE_OFFER_CD                                       
MFA-TR*            ,FG.RTCHG_PUB_OFFER_CD                                       
MFA-TR*        FROM CRM_RT_PKG_OFFER  FG                                        
MFA-TR*WILD CARD SEARCH                                                         
MFA-TR*       WHERE ((:WS-WILDCARD-FLAG  = 'Y'                                  
MFA-TR*         AND (FG.OFFER_CD             LIKE :WS-SEARCH-CRITERIA           
MFA-TR*          OR UPPER(FG.OFFER_DESC_INT) LIKE :WS-SEARCH-CRITERIA))         
MFA-TR*          OR (:WS-WILDCARD-FLAG   = 'N'                                  
MFA-TR*         AND FG.OFFER_CD          = :WS-SEARCH-CRITERIA))                
MFA-TR*SEARCH FOR MODIFY/CREATE OFFER WIZARDS                                   
MFA-TR*       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=Y                             
MFA-TR*GLOBAL SEARCH - SEARCH BY ACTIVE IN PRODUCTION FILTER                    
MFA-TR*       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=N                             
MFA-TR*         AND ((:WS-ACTV-PRD-FLAG  = 'Y'                                  
MFA-TR*         AND FG.OFF_VRSN_NO       =                                      
MFA-TR*            (SELECT MAX(OFF_VRSN_NO)                                     
MFA-TR*               FROM CRM_RT_PKG_OFFER F1                                  
MFA-TR*              WHERE F1.OFFER_CD         = FG.OFFER_CD                    
MFA-TR*                AND ((F1.PROC_STATUS_CD  = :WS-APRVL-CMPLT               
MFA-TR*                AND  F1.OFF_VSTART_TS   <= :WS-CURR-TIMESTAMP            
MFA-TR*                AND  F1.OFF_VEND_TS     >= :WS-CURR-TIMESTAMP            
MFA-TR*                AND  F1.OFFER_START_DT  <= :WS-CURRENT-DATE              
MFA-TR*                AND  F1.OFFER_END_DT    >= :WS-CURRENT-DATE              
MFA-TR*                AND  :WS-ACTIVE-ONLY     = 'N')                          
MFA-TR*                 OR (:WS-ACTIVE-ONLY     = 'Y'                           
MFA-TR*                AND  F1.OFFER_END_DT    >= :WS-CURRENT-DATE))))          
MFA-TR*          OR  :WS-ACTV-PRD-FLAG   = 'N')                                 
MFA-TR*GLOBAL SEARCH - FILTER BY DATE RANGE                                     
MFA-TR*         AND ((:WS-VRSN-TS-FLAG   = 'Y'                                  
MFA-TR*         AND ((FG.OFF_VSTART_TS  <= :WS-CHK-VSTART-TS                    
MFA-TR*         AND FG.OFF_VEND_TS      >= :WS-CHK-VSTART-TS)                   
MFA-TR*          OR (FG.OFF_VSTART_TS   >= :WS-CHK-VSTART-TS                    
MFA-TR*         AND FG.OFF_VSTART_TS    <= :WS-CHK-VEND-TS ))                   
MFA-TR*         AND ((FG.OFFER_START_DT <= :WS-CHK-START-DT                     
MFA-TR*         AND FG.OFFER_END_DT     >= :WS-CHK-START-DT)                    
MFA-TR*          OR (FG.OFFER_START_DT  >= :WS-CHK-START-DT                     
MFA-TR*         AND FG.OFFER_START_DT   <= :WS-CHK-END-DT)))                    
MFA-TR*          OR (:WS-VRSN-TS-FLAG    = 'N') )                               
MFA-TR*GLOBAL SEARCH - FILTER BY PROCESS STATUS CODE                            
MFA-TR*         AND ((FG.PROC_STATUS_CD  = :WS-PROC-STATUS-CD                   
MFA-TR*         AND :WS-PROC-STATUS-FLAG = 'Y')                                 
MFA-TR*          OR :WS-PROC-STATUS-FLAG = 'N')                                 
MFA-TR*         ORDER BY OFFER_CD,OFF_VRSN_NO DESC                              
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*        QUERYNO 7150                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   DRIVER CURSOR DECLARATION TO SEARCH OPTION DETAILS BASED ON  *        
      *   SEARCH CRITERIA.                                             *        
      * THIS CURSOR GET TRIGGERS WHEN USER SEARCH FROM                 *        
      *                                                                *        
      * GLOBAL SEARCH WIZARD:                                          *        
      * OPTION SEARCH                                                  *        
      *             A.WILD CARD SEARCH                                 *        
      *             B.ADVANCED SEARCH -BY DATE/BY STATS/BY ACTV IN PROD*        
      *                                                                *        
      * MODIFY OPTION WIZARD:                                          *        
      * OPTION SEARCH WITH/WITHOUT WILD CARD.                          *        
      *                                                                *        
      * CREATE/MODIFY WIZARD:                                          *        
      * ACTV OPTION SEARCH                                             *        
      *               OPTION CODE WITH/WITHOUT WILD CARD.              *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE OPTION_DRIVE_CUR CURSOR FOR                      
                SELECT  FI.COMPANY_NO                                   
                       ,FI.OPTION_CD                                    
                       ,FI.CODE_UTIL_TYPE                               
                       ,FI.RATE_PLAN_NO                                 
                       ,FI.OPTION_START_DT                              
                       ,FI.OPTION_END_DT                                
                       ,FI.OPT_DESC_INT                                 
                       ,FI.OPT_DESC_INT_LONG                            
                       ,FI.CURR_EXT_DESC_LONG                           
                       ,FI.RENEWAL_DESC_LONG                            
                       ,FI.WEB_DESC_LONG                                
                       ,FI.STATUS_CD                                    
                       ,FI.LAST_UPDATE_USERID                           
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                       ,FI.OPT_CALC_TYPE_CD                             
                       ,FI.WEB_MKT_DESC_LONG                            
                       ,FI.OPT_VRSN_NO                                  
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FI.OPT_VSTART_TS, 121), ' ', '-'), ':', '.') OPT_VSTART_TS          
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VEND_TS
           , 121), ' ', '-'), ':', '.') OPT_VEND_TS                            
                       ,FI.PROC_STATUS_CD                               
                       ,FI.PROC_REQ_ID                                  
A04805                 ,FI.OPTION_TYPE_DESC                             
PRJ892                 ,FI.AUTO_RENEWAL_FL                              
PRJ892                 ,FI.OPTION_PROMO_DESC                            
                  FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)               
      *WILD CARD SEARCH                                                         
                 WHERE ((:WS-WILDCARD-FLAG   = 'Y'                      
                   AND (FI.OPTION_CD         LIKE :WS-SEARCH-CRITERIA   
                    OR UPPER(FI.OPT_DESC_INT)LIKE :WS-SEARCH-CRITERIA)) 
                    OR (:WS-WILDCARD-FLAG    = 'N'                      
                   AND FI.OPTION_CD          = :WS-SEARCH-CRITERIA))    
      *SEARCH FOR MODIFY/CREATE OFFER WIZARDS                                   
      *       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=Y                             
      *GLOBAL SEARCH - FILTER BY ACTIVE IN PRODUCTION                           
      *       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=N                             
                   AND ((:WS-ACTV-PRD-FLAG   = 'Y'                      
                   AND FI.OPT_VRSN_NO        =                          
                     (SELECT MAX(OPT_VRSN_NO)                           
                        FROM CRM_RT_PKG_OPTION F1 WITH(READUNCOMMITTED)         
                       WHERE F1.OPTION_CD      = FI.OPTION_CD           
                         AND ((F1.PROC_STATUS_CD = :WS-APRVL-CMPLT      
                         AND F1.OPT_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
                         AND F1.OPT_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )   
                         AND :WS-ACTIVE-ONLY     = 'N')                 
                          OR (:WS-ACTIVE-ONLY    = 'Y'                  
                         AND FI.OPTION_END_DT   >= 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))))) 
                 OR :WS-ACTV-PRD-FLAG     = 'N')                        
      *GLOBAL SEARCH - FILTER BY DATE RANGE                                     
                   AND ((:WS-VRSN-TS-FLAG    = 'Y'                      
                   AND ((FI.OPT_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              )        
                   AND FI.OPT_VEND_TS       >= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              ))       
                    OR (FI.OPT_VSTART_TS    >= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              )        
                   AND FI.OPT_VSTART_TS     <= CIS.CHAR2TIMESTAMP(
                                                        :WS-CHK-VEND-TS
              ) ))       
                   AND ((FI.OPTION_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) )         
                   AND FI.OPTION_END_DT     >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) ))        
                    OR (FI.OPTION_START_DT  >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) )         
                   AND FI.OPTION_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHK-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-END-DT
              ) <> 0) OR (LEN(:WS-CHK-END-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHK-END-DT
              ), CONVERT(DATE, :WS-CHK-END-DT) ) )))       
                    OR  :WS-VRSN-TS-FLAG     = 'N')                     
      *GLOBAL SEARCH - FILTER BY PROCESS STATUS CODE                            
                   AND ((FI.PROC_STATUS_CD   = :WS-PROC-STATUS-CD       
                   AND :WS-PROC-STATUS-FLAG  = 'Y')                     
                    OR :WS-PROC-STATUS-FLAG  = 'N')                     
                 ORDER BY OPTION_CD,OPT_VRSN_NO DESC                    
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OPTION_DRIVE_CUR CURSOR FOR                              
MFA-TR*         SELECT  FI.COMPANY_NO                                           
MFA-TR*                ,FI.OPTION_CD                                            
MFA-TR*                ,FI.CODE_UTIL_TYPE                                       
MFA-TR*                ,FI.RATE_PLAN_NO                                         
MFA-TR*                ,FI.OPTION_START_DT                                      
MFA-TR*                ,FI.OPTION_END_DT                                        
MFA-TR*                ,FI.OPT_DESC_INT                                         
MFA-TR*                ,FI.OPT_DESC_INT_LONG                                    
MFA-TR*                ,FI.CURR_EXT_DESC_LONG                                   
MFA-TR*                ,FI.RENEWAL_DESC_LONG                                    
MFA-TR*                ,FI.WEB_DESC_LONG                                        
MFA-TR*                ,FI.STATUS_CD                                            
MFA-TR*                ,FI.LAST_UPDATE_USERID                                   
MFA-TR*                ,FI.LAST_UPDATE_TS                                       
MFA-TR*                ,FI.OPT_CALC_TYPE_CD                                     
MFA-TR*                ,FI.WEB_MKT_DESC_LONG                                    
MFA-TR*                ,FI.OPT_VRSN_NO                                          
MFA-TR*                ,FI.OPT_VSTART_TS                                        
MFA-TR*                ,FI.OPT_VEND_TS                                          
MFA-TR*                ,FI.PROC_STATUS_CD                                       
MFA-TR*                ,FI.PROC_REQ_ID                                          
MFA-TR*                ,FI.OPTION_TYPE_DESC                                     
MFA-TR*                ,FI.AUTO_RENEWAL_FL                                      
MFA-TR*                ,FI.OPTION_PROMO_DESC                                    
MFA-TR*           FROM CRM_RT_PKG_OPTION FI                                     
MFA-TR*WILD CARD SEARCH                                                         
MFA-TR*          WHERE ((:WS-WILDCARD-FLAG   = 'Y'                              
MFA-TR*            AND (FI.OPTION_CD         LIKE :WS-SEARCH-CRITERIA           
MFA-TR*             OR UPPER(FI.OPT_DESC_INT)LIKE :WS-SEARCH-CRITERIA))         
MFA-TR*             OR (:WS-WILDCARD-FLAG    = 'N'                              
MFA-TR*            AND FI.OPTION_CD          = :WS-SEARCH-CRITERIA))            
MFA-TR*SEARCH FOR MODIFY/CREATE OFFER WIZARDS                                   
MFA-TR*       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=Y                             
MFA-TR*GLOBAL SEARCH - FILTER BY ACTIVE IN PRODUCTION                           
MFA-TR*       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=N                             
MFA-TR*            AND ((:WS-ACTV-PRD-FLAG   = 'Y'                              
MFA-TR*            AND FI.OPT_VRSN_NO        =                                  
MFA-TR*              (SELECT MAX(OPT_VRSN_NO)                                   
MFA-TR*                 FROM CRM_RT_PKG_OPTION F1                               
MFA-TR*                WHERE F1.OPTION_CD      = FI.OPTION_CD                   
MFA-TR*                  AND ((F1.PROC_STATUS_CD = :WS-APRVL-CMPLT              
MFA-TR*                  AND F1.OPT_VSTART_TS   <= :WS-CURR-TIMESTAMP           
MFA-TR*                  AND F1.OPT_VEND_TS     >= :WS-CURR-TIMESTAMP           
MFA-TR*                  AND :WS-ACTIVE-ONLY     = 'N')                         
MFA-TR*                   OR (:WS-ACTIVE-ONLY    = 'Y'                          
MFA-TR*                  AND FI.OPTION_END_DT   >= :WS-CURRENT-DATE))))         
MFA-TR*          OR :WS-ACTV-PRD-FLAG     = 'N')                                
MFA-TR*GLOBAL SEARCH - FILTER BY DATE RANGE                                     
MFA-TR*            AND ((:WS-VRSN-TS-FLAG    = 'Y'                              
MFA-TR*            AND ((FI.OPT_VSTART_TS   <= :WS-CHK-VSTART-TS                
MFA-TR*            AND FI.OPT_VEND_TS       >= :WS-CHK-VSTART-TS)               
MFA-TR*             OR (FI.OPT_VSTART_TS    >= :WS-CHK-VSTART-TS                
MFA-TR*            AND FI.OPT_VSTART_TS     <= :WS-CHK-VEND-TS ))               
MFA-TR*            AND ((FI.OPTION_START_DT <= :WS-CHK-START-DT                 
MFA-TR*            AND FI.OPTION_END_DT     >= :WS-CHK-START-DT)                
MFA-TR*             OR (FI.OPTION_START_DT  >= :WS-CHK-START-DT                 
MFA-TR*            AND FI.OPTION_START_DT   <= :WS-CHK-END-DT )))               
MFA-TR*             OR  :WS-VRSN-TS-FLAG     = 'N')                             
MFA-TR*GLOBAL SEARCH - FILTER BY PROCESS STATUS CODE                            
MFA-TR*            AND ((FI.PROC_STATUS_CD   = :WS-PROC-STATUS-CD               
MFA-TR*            AND :WS-PROC-STATUS-FLAG  = 'Y')                             
MFA-TR*             OR :WS-PROC-STATUS-FLAG  = 'N')                             
MFA-TR*          ORDER BY OPTION_CD,OPT_VRSN_NO DESC                            
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7120                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   DRIVER CURSOR DECLARATION TO SEARCH PROMO  DETAILS BASED ON  *        
      *   SEARCH CRITERIA.                                             *        
      * THIS CURSOR GET TRIGGERS WHEN USER SEARCH FROM                 *        
      *                                                                *        
      * GLOBAL SEARCH WIZARD:                                          *        
      * PROMO SEARCH                                                   *        
      *             A.WILD CARD SEARCH                                 *        
      *             B.ADVANCED SEARCH -BY DATE/BY STATS/BY ACTV IN PRD *        
      *                                                                *        
      * CREATE/MODIFY WIZARD:                                          *        
      * ACTV OPTION SEARCH                                             *        
      *               PROMO CODE WITH/WITHOUT WILD CARD                *        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE PROMO_DRIVE_CUR CURSOR FOR                       
                SELECT KM.COMPANY_NO                                    
                      ,KM.PROMO_CD                                      
                      ,KM.PROMO_DESC                                    
                      ,KM.OFFER_CD                                      
                      ,KM.MKT_PLAN_CD                                   
                      ,KM.PROMO_START_DT                                
                      ,REPLACE(CONVERT(CHAR(8), KM.PROMO_START_TM
           , 108), ':', '.') PROMO_START_TM                                
                      ,KM.PROMO_END_DT                                  
                      ,REPLACE(CONVERT(CHAR(8), KM.PROMO_END_TM, 108), 
           ':', '.') PROMO_END_TM                                  
                      ,KM.AD_CHANNEL_CD                                 
                      ,KM.PROMO_DESC_LONG                               
                      ,KM.EXT_LANDING_PG_URL                            
                      ,KM.PROMO_TYPE_CD                                 
                      ,KM.WEB_IMAGE_FILE_NM                             
                      ,KM.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,KM.REPLACMNT_PROMO_CD                            
                      ,KM.DISPLAY_END_DT                                
                      ,KM.INT_LANDING_PG_URL                            
                      ,KM.PROMO_VRSN_NO                                 
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VSTART_TS, 121), ' ', '-'), ':', '.') 
           PROMO_VSTART_TS                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VEND_TS, 121), ' ', '-'), ':', '.') PROMO_VEND_TS          
                      ,KM.PROC_STATUS_CD                                
                      ,KM.PROC_REQ_ID                                   
                  FROM CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)               
      *WILD CARD SEARCH                                                         
                 WHERE ((:WS-WILDCARD-FLAG    = 'Y'                     
                   AND (KM.PROMO_CD          LIKE :WS-SEARCH-CRITERIA   
                    OR UPPER(KM.PROMO_DESC)  LIKE :WS-SEARCH-CRITERIA)) 
                    OR (:WS-WILDCARD-FLAG     = 'N'                     
                   AND KM.PROMO_CD            = :WS-SEARCH-CRITERIA))   
      *SEARCH FOR MODIFY/CREATE OFFER WIZARDS                                   
      *       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=Y                             
      *GLOBAL SEARCH - FILTER BY ACTIVE IN PRODUCTION                           
      *       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=N                             
                   AND ((:WS-ACTV-PRD-FLAG    = 'Y'                     
                   AND KM.PROMO_VRSN_NO       =                         
                      (SELECT MAX(PROMO_VRSN_NO)                        
                         FROM CRM_MKT_PROMOTION K1 WITH(READUNCOMMITTED)        
                        WHERE K1.PROMO_CD       = KM.PROMO_CD           
                        AND ((K1.PROC_STATUS_CD = :WS-APRVL-CMPLT       
                        AND K1.PROMO_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )    
                        AND K1.PROMO_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )    
                        AND :WS-ACTIVE-ONLY     = 'N')                  
                         OR (:WS-ACTIVE-ONLY     = 'Y'                  
                        AND KM.PROMO_END_DT     >= 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ))))) 
                    OR :WS-ACTV-PRD-FLAG      = 'N')                    
      *GLOBAL SEARCH - FILTER BY DATE RANGE                                     
                   AND ((:WS-VRSN-TS-FLAG     = 'Y'                     
                   AND ((KM.PROMO_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              )       
                   AND KM.PROMO_VEND_TS      >= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              ) )     
                    OR (KM.PROMO_VSTART_TS   >= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              )       
                   AND KM.PROMO_VSTART_TS    <= CIS.CHAR2TIMESTAMP(
                                                        :WS-CHK-VEND-TS
              ) ))      
                   AND ((KM.PROMO_START_DT   <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) )        
                   AND KM.PROMO_END_DT       >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) ))       
                    OR (KM.PROMO_START_DT    >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) )        
                   AND KM.PROMO_START_DT     <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHK-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-END-DT
              ) <> 0) OR (LEN(:WS-CHK-END-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHK-END-DT
              ), CONVERT(DATE, :WS-CHK-END-DT) ) )))      
                    OR :WS-VRSN-TS-FLAG      = 'N')                     
      *GLOBAL SEARCH - FILTER BY PROCESS STATUS CODE                            
                   AND ((KM.PROC_STATUS_CD    = :WS-PROC-STATUS-CD      
                   AND :WS-PROC-STATUS-FLAG   = 'Y')                    
                    OR :WS-PROC-STATUS-FLAG   = 'N')                    
                 ORDER BY PROMO_CD,PROMO_VRSN_NO DESC                   
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE PROMO_DRIVE_CUR CURSOR FOR                               
MFA-TR*         SELECT KM.COMPANY_NO                                            
MFA-TR*               ,KM.PROMO_CD                                              
MFA-TR*               ,KM.PROMO_DESC                                            
MFA-TR*               ,KM.OFFER_CD                                              
MFA-TR*               ,KM.MKT_PLAN_CD                                           
MFA-TR*               ,KM.PROMO_START_DT                                        
MFA-TR*               ,KM.PROMO_START_TM                                        
MFA-TR*               ,KM.PROMO_END_DT                                          
MFA-TR*               ,KM.PROMO_END_TM                                          
MFA-TR*               ,KM.AD_CHANNEL_CD                                         
MFA-TR*               ,KM.PROMO_DESC_LONG                                       
MFA-TR*               ,KM.EXT_LANDING_PG_URL                                    
MFA-TR*               ,KM.PROMO_TYPE_CD                                         
MFA-TR*               ,KM.WEB_IMAGE_FILE_NM                                     
MFA-TR*               ,KM.LAST_UPDATE_USERID                                    
MFA-TR*               ,KM.LAST_UPDATE_TS                                        
MFA-TR*               ,KM.REPLACMNT_PROMO_CD                                    
MFA-TR*               ,KM.DISPLAY_END_DT                                        
MFA-TR*               ,KM.INT_LANDING_PG_URL                                    
MFA-TR*               ,KM.PROMO_VRSN_NO                                         
MFA-TR*               ,KM.PROMO_VSTART_TS                                       
MFA-TR*               ,KM.PROMO_VEND_TS                                         
MFA-TR*               ,KM.PROC_STATUS_CD                                        
MFA-TR*               ,KM.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_MKT_PROMOTION KM                                     
MFA-TR*WILD CARD SEARCH                                                         
MFA-TR*          WHERE ((:WS-WILDCARD-FLAG    = 'Y'                             
MFA-TR*            AND (KM.PROMO_CD          LIKE :WS-SEARCH-CRITERIA           
MFA-TR*             OR UPPER(KM.PROMO_DESC)  LIKE :WS-SEARCH-CRITERIA))         
MFA-TR*             OR (:WS-WILDCARD-FLAG     = 'N'                             
MFA-TR*            AND KM.PROMO_CD            = :WS-SEARCH-CRITERIA))           
MFA-TR*SEARCH FOR MODIFY/CREATE OFFER WIZARDS                                   
MFA-TR*       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=Y                             
MFA-TR*GLOBAL SEARCH - FILTER BY ACTIVE IN PRODUCTION                           
MFA-TR*       WS-ACTV-PRD-FLAG=Y & WS-ACTIVE-ONLY=N                             
MFA-TR*            AND ((:WS-ACTV-PRD-FLAG    = 'Y'                             
MFA-TR*            AND KM.PROMO_VRSN_NO       =                                 
MFA-TR*               (SELECT MAX(PROMO_VRSN_NO)                                
MFA-TR*                  FROM CRM_MKT_PROMOTION K1                              
MFA-TR*                 WHERE K1.PROMO_CD       = KM.PROMO_CD                   
MFA-TR*                 AND ((K1.PROC_STATUS_CD = :WS-APRVL-CMPLT               
MFA-TR*                 AND K1.PROMO_VSTART_TS <= :WS-CURR-TIMESTAMP            
MFA-TR*                 AND K1.PROMO_VEND_TS   >= :WS-CURR-TIMESTAMP            
MFA-TR*                 AND :WS-ACTIVE-ONLY     = 'N')                          
MFA-TR*                  OR (:WS-ACTIVE-ONLY     = 'Y'                          
MFA-TR*                 AND KM.PROMO_END_DT     >= :WS-CURRENT-DATE))))         
MFA-TR*             OR :WS-ACTV-PRD-FLAG      = 'N')                            
MFA-TR*GLOBAL SEARCH - FILTER BY DATE RANGE                                     
MFA-TR*            AND ((:WS-VRSN-TS-FLAG     = 'Y'                             
MFA-TR*            AND ((KM.PROMO_VSTART_TS  <= :WS-CHK-VSTART-TS               
MFA-TR*            AND KM.PROMO_VEND_TS      >= :WS-CHK-VSTART-TS )             
MFA-TR*             OR (KM.PROMO_VSTART_TS   >= :WS-CHK-VSTART-TS               
MFA-TR*            AND KM.PROMO_VSTART_TS    <= :WS-CHK-VEND-TS ))              
MFA-TR*            AND ((KM.PROMO_START_DT   <= :WS-CHK-START-DT                
MFA-TR*            AND KM.PROMO_END_DT       >= :WS-CHK-START-DT)               
MFA-TR*             OR (KM.PROMO_START_DT    >= :WS-CHK-START-DT                
MFA-TR*            AND KM.PROMO_START_DT     <= :WS-CHK-END-DT )))              
MFA-TR*             OR :WS-VRSN-TS-FLAG      = 'N')                             
MFA-TR*GLOBAL SEARCH - FILTER BY PROCESS STATUS CODE                            
MFA-TR*            AND ((KM.PROC_STATUS_CD    = :WS-PROC-STATUS-CD              
MFA-TR*            AND :WS-PROC-STATUS-FLAG   = 'Y')                            
MFA-TR*             OR :WS-PROC-STATUS-FLAG   = 'N')                            
MFA-TR*          ORDER BY PROMO_CD,PROMO_VRSN_NO DESC                           
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7180                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   DRIVER CURSOR DECLARATION TO SEARCH TIER  DETAILS BASED ON   *        
      *   SEARCH CRITERIA.                                             *        
      * THIS CURSOR GET TRIGGERS WHEN USER SEARCH FROM                 *        
      *                                                                *        
      * GLOBAL SEARCH WIZARD:                                          *        
      * MKT TIER SEARCH                                                *        
      *               A.WILD CARD SEARCH                               *        
      *               B.CUST TYPE/ACCT STATUS/TIER RANKING             *        
      *               C.ADVANCED SEARCH -BY DATE/BY STATS/BY ACTV IN PRD        
      *                                                                *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE MKT_TIER_DRIVE_CUR CURSOR FOR                     
               SELECT IG.COMPANY_NO                                     
                     ,DU.OFFER_CD                                       
                     ,DU.TIER_CUST_STAT_CD                              
                     ,DU.TIER_ACCT_TYPE_CD                              
                     ,DU.MKT_TIER_RANKING                               
                     ,DU.MKT_TIER_START_DT                              
                     ,IG.MKT_TIER_DESC                                  
                     ,IG.MKT_TIER_END_DT                                
                     ,IG.TIER_OFFER_VIEW                                
                     ,DU.OFFER_TIER_STRT_DT                             
                     ,DU.MKT_TIER_APPLY_CD                              
                     ,DU.TIER_DEFLT_OFFR_CD                             
                     ,DU.OFFER_TIER_END_DT                              
                     ,IG.CUST_ACCT_DEFLT_FL                             
                     ,IG.MKT_TIER_DESC_LONG                             
                     ,DU.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,DU.OFF_TIER_VRSN_NO                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VSTART_TS                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VEND_TS                               
                     ,DU.PROC_STATUS_CD                                 
                     ,DU.PROC_REQ_ID                                    
                 FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                 
                     ,CRM_MKT_TIER     IG WITH(READUNCOMMITTED)                 
      *SEARCH BY CUST STATUS/ACCOUNT TYPE/TIER RANKING                          
                WHERE (DU.TIER_CUST_STAT_CD   = :WS-TIER-CUST-STAT-CD   
                   OR :WS-TIER-CUST-STAT-CD   = ' ')                    
                  AND (DU.TIER_ACCT_TYPE_CD   = :WS-TIER-ACCT-TYPE-CD   
                   OR :WS-TIER-ACCT-TYPE-CD   = ' ')                    
                  AND (DU.MKT_TIER_RANKING    = :WS-MKT-TIER-RANKING    
                   OR :WS-MKT-TIER-RANKING    = 0)                      
                  AND DU.TIER_CUST_STAT_CD    = IG.TIER_CUST_STAT_CD    
                  AND DU.TIER_ACCT_TYPE_CD    = IG.TIER_ACCT_TYPE_CD    
                  AND DU.MKT_TIER_RANKING     = IG.MKT_TIER_RANKING     
                  AND DU.MKT_TIER_START_DT    = IG.MKT_TIER_START_DT    
                  AND DU.COMPANY_NO           = IG.COMPANY_NO           
      *WILD CARD SEARCH                                                         
                  AND ((:WS-WILDCARD-FLAG     = 'Y'                     
                  AND UPPER(IG.MKT_TIER_DESC) LIKE :WS-SEARCH-CRITERIA) 
                   OR (:WS-WILDCARD-FLAG      = 'N'                     
                  AND (:WS-SEARCH-CRITERIA    = ' '                     
                   OR UPPER(IG.MKT_TIER_DESC) = :WS-SEARCH-CRITERIA)))  
      *GLOBAL SEARCH - FILTER BY DATE RANGE                                     
                  AND ((:WS-VRSN-TS-FLAG       = 'Y'                    
                  AND ((DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              )      
                  AND DU.OFF_TIER_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              ))     
                   OR (DU.OFF_TIER_VSTART_TS  >= CIS.CHAR2TIMESTAMP(
                                                      :WS-CHK-VSTART-TS
              )      
                  AND DU.OFF_TIER_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                        :WS-CHK-VEND-TS
              ) ))     
                  AND ((DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) )       
                  AND DU.OFFER_TIER_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) ) )     
                   OR (DU.OFFER_TIER_STRT_DT  >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CHK-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-START-DT
              ) <> 0) OR (LEN(:WS-CHK-START-DT) <> 10), CIS.CHAR2DATE(
                                                       :WS-CHK-START-DT
              ), CONVERT(DATE, :WS-CHK-START-DT) )       
                  AND DU.OFFER_TIER_STRT_DT   <= IIF(TRY_CONVERT(DATE, 
                                                         :WS-CHK-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-CHK-END-DT
              ) <> 0) OR (LEN(:WS-CHK-END-DT) <> 10), CIS.CHAR2DATE(
                                                         :WS-CHK-END-DT
              ), CONVERT(DATE, :WS-CHK-END-DT) ) )))     
                   OR :WS-VRSN-TS-FLAG         = 'N')                   
                ORDER BY MKT_TIER_RANKING,OFF_TIER_VRSN_NO DESC         
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_TIER_DRIVE_CUR CURSOR FOR                             
MFA-TR*        SELECT IG.COMPANY_NO                                             
MFA-TR*              ,DU.OFFER_CD                                               
MFA-TR*              ,DU.TIER_CUST_STAT_CD                                      
MFA-TR*              ,DU.TIER_ACCT_TYPE_CD                                      
MFA-TR*              ,DU.MKT_TIER_RANKING                                       
MFA-TR*              ,DU.MKT_TIER_START_DT                                      
MFA-TR*              ,IG.MKT_TIER_DESC                                          
MFA-TR*              ,IG.MKT_TIER_END_DT                                        
MFA-TR*              ,IG.TIER_OFFER_VIEW                                        
MFA-TR*              ,DU.OFFER_TIER_STRT_DT                                     
MFA-TR*              ,DU.MKT_TIER_APPLY_CD                                      
MFA-TR*              ,DU.TIER_DEFLT_OFFR_CD                                     
MFA-TR*              ,DU.OFFER_TIER_END_DT                                      
MFA-TR*              ,IG.CUST_ACCT_DEFLT_FL                                     
MFA-TR*              ,IG.MKT_TIER_DESC_LONG                                     
MFA-TR*              ,DU.LAST_UPDATE_USERID                                     
MFA-TR*              ,DU.LAST_UPDATE_TS                                         
MFA-TR*              ,DU.OFF_TIER_VRSN_NO                                       
MFA-TR*              ,DU.OFF_TIER_VSTART_TS                                     
MFA-TR*              ,DU.OFF_TIER_VEND_TS                                       
MFA-TR*              ,DU.PROC_STATUS_CD                                         
MFA-TR*              ,DU.PROC_REQ_ID                                            
MFA-TR*          FROM CRM_OFF_MKT_TIER DU                                       
MFA-TR*              ,CRM_MKT_TIER     IG                                       
MFA-TR*SEARCH BY CUST STATUS/ACCOUNT TYPE/TIER RANKING                          
MFA-TR*         WHERE (DU.TIER_CUST_STAT_CD   = :WS-TIER-CUST-STAT-CD           
MFA-TR*            OR :WS-TIER-CUST-STAT-CD   = ' ')                            
MFA-TR*           AND (DU.TIER_ACCT_TYPE_CD   = :WS-TIER-ACCT-TYPE-CD           
MFA-TR*            OR :WS-TIER-ACCT-TYPE-CD   = ' ')                            
MFA-TR*           AND (DU.MKT_TIER_RANKING    = :WS-MKT-TIER-RANKING            
MFA-TR*            OR :WS-MKT-TIER-RANKING    = 0)                              
MFA-TR*           AND DU.TIER_CUST_STAT_CD    = IG.TIER_CUST_STAT_CD            
MFA-TR*           AND DU.TIER_ACCT_TYPE_CD    = IG.TIER_ACCT_TYPE_CD            
MFA-TR*           AND DU.MKT_TIER_RANKING     = IG.MKT_TIER_RANKING             
MFA-TR*           AND DU.MKT_TIER_START_DT    = IG.MKT_TIER_START_DT            
MFA-TR*           AND DU.COMPANY_NO           = IG.COMPANY_NO                   
MFA-TR*WILD CARD SEARCH                                                         
MFA-TR*           AND ((:WS-WILDCARD-FLAG     = 'Y'                             
MFA-TR*           AND UPPER(IG.MKT_TIER_DESC) LIKE :WS-SEARCH-CRITERIA)         
MFA-TR*            OR (:WS-WILDCARD-FLAG      = 'N'                             
MFA-TR*           AND (:WS-SEARCH-CRITERIA    = ' '                             
MFA-TR*            OR UPPER(IG.MKT_TIER_DESC) = :WS-SEARCH-CRITERIA)))          
MFA-TR*GLOBAL SEARCH - FILTER BY DATE RANGE                                     
MFA-TR*           AND ((:WS-VRSN-TS-FLAG       = 'Y'                            
MFA-TR*           AND ((DU.OFF_TIER_VSTART_TS <= :WS-CHK-VSTART-TS              
MFA-TR*           AND DU.OFF_TIER_VEND_TS     >= :WS-CHK-VSTART-TS)             
MFA-TR*            OR (DU.OFF_TIER_VSTART_TS  >= :WS-CHK-VSTART-TS              
MFA-TR*           AND DU.OFF_TIER_VSTART_TS   <= :WS-CHK-VEND-TS ))             
MFA-TR*           AND ((DU.OFFER_TIER_STRT_DT <= :WS-CHK-START-DT               
MFA-TR*           AND DU.OFFER_TIER_END_DT    >= :WS-CHK-START-DT )             
MFA-TR*            OR (DU.OFFER_TIER_STRT_DT  >= :WS-CHK-START-DT               
MFA-TR*           AND DU.OFFER_TIER_STRT_DT   <= :WS-CHK-END-DT )))             
MFA-TR*            OR :WS-VRSN-TS-FLAG         = 'N')                           
MFA-TR*         ORDER BY MKT_TIER_RANKING,OFF_TIER_VRSN_NO DESC                 
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*          QUERYNO 7300                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OFFER DETAILS BASED ON           *        
      *   OPTION CODE.                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFFER_OPTION_CUR CURSOR FOR                      
                SELECT E9.COMPANY_NO                                    
                      ,E9.OFFER_CD                                      
                      ,E9.OPTION_CD                                     
                      ,E9.OPTION_SORT_SEQ_NO                            
                      ,E9.OPTION_URL_TX                                 
                      ,E9.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,E9.DROP_OPTION_CD                                
                      ,E9.OFFER_OPT_START_DT                            
                      ,E9.OFFER_OPT_END_DT                              
                      ,E9.OFF_OPT_VRSN_NO                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VSTART_TS                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VEND_TS                               
                      ,E9.PROC_STATUS_CD                                
                      ,E9.PROC_REQ_ID                                   
A04805                ,E9.WEB_NEW_EXISTS_CD                             
A04805                ,E9.WEB_SIGN_UP_FL                                
A04805                ,E9.OFF_OPT_EXCLUDE_CD                            
                  FROM CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)               
                 WHERE (E9.OPTION_CD          = :E9-OPTION-CD           
                   AND E9.COMPANY_NO          = :E9-COMPANY-NO )        
                   AND ((E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ))  
                     OR (E9.OFFER_OPT_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )))   
                   AND ((E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND E9.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )) 
                     OR (E9.OFF_OPT_VSTART_TS  >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )))  
                   ORDER BY OPTION_CD, OFFER_CD                         
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_OPTION_CUR CURSOR FOR                              
MFA-TR*         SELECT E9.COMPANY_NO                                            
MFA-TR*               ,E9.OFFER_CD                                              
MFA-TR*               ,E9.OPTION_CD                                             
MFA-TR*               ,E9.OPTION_SORT_SEQ_NO                                    
MFA-TR*               ,E9.OPTION_URL_TX                                         
MFA-TR*               ,E9.LAST_UPDATE_USERID                                    
MFA-TR*               ,E9.LAST_UPDATE_TS                                        
MFA-TR*               ,E9.DROP_OPTION_CD                                        
MFA-TR*               ,E9.OFFER_OPT_START_DT                                    
MFA-TR*               ,E9.OFFER_OPT_END_DT                                      
MFA-TR*               ,E9.OFF_OPT_VRSN_NO                                       
MFA-TR*               ,E9.OFF_OPT_VSTART_TS                                     
MFA-TR*               ,E9.OFF_OPT_VEND_TS                                       
MFA-TR*               ,E9.PROC_STATUS_CD                                        
MFA-TR*               ,E9.PROC_REQ_ID                                           
MFA-TR*               ,E9.WEB_NEW_EXISTS_CD                                     
MFA-TR*               ,E9.WEB_SIGN_UP_FL                                        
MFA-TR*               ,E9.OFF_OPT_EXCLUDE_CD                                    
MFA-TR*           FROM CRM_OFFER_OPTION  E9                                     
MFA-TR*          WHERE (E9.OPTION_CD          = :E9-OPTION-CD                   
MFA-TR*            AND E9.COMPANY_NO          = :E9-COMPANY-NO )                
MFA-TR*            AND ((E9.OFFER_OPT_START_DT <= :WS-ACTIVE-START-DT           
MFA-TR*              AND E9.OFFER_OPT_END_DT   >= :WS-ACTIVE-START-DT)          
MFA-TR*              OR (E9.OFFER_OPT_START_DT >= :WS-ACTIVE-START-DT           
MFA-TR*              AND E9.OFFER_OPT_START_DT <= :WS-ACTIVE-END-DT))           
MFA-TR*            AND ((E9.OFF_OPT_VSTART_TS  <= :WS-VERSION-START-TS          
MFA-TR*              AND E9.OFF_OPT_VEND_TS    >= :WS-VERSION-START-TS)         
MFA-TR*              OR (E9.OFF_OPT_VSTART_TS  >= :WS-VERSION-START-TS          
MFA-TR*              AND E9.OFF_OPT_VSTART_TS  <= :WS-VERSION-END-TS))          
MFA-TR*            ORDER BY OPTION_CD, OFFER_CD                                 
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7240                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OFFER  DETAILS BASED             *        
      *   OPTION CODE.                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFFER_CD_CUR CURSOR FOR                          
               SELECT FG.COMPANY_NO                                     
                     ,FG.OFFER_CD                                       
                     ,FG.OFFER_DESC_INT                                 
                     ,FG.OFFER_DESC_EXT                                 
                     ,FG.PROMO_CD_INT_FL                                
                     ,FG.PROMO_CD_EXT_FL                                
                     ,FG.OFFER_START_DT                                 
                     ,FG.OFFER_END_DT                                   
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_INT_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_INT_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_EXT_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_EXT_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FG.LAST_UPDATE_USERID                             
                     ,FG.OFFER_DESC_INT_LNG                             
                     ,FG.OFFER_DESC_EXT_LNG                             
                     ,FG.SPCL_OFFER_TYPE_CD                             
                     ,FG.RENEWAL_OFFER_CD                               
                     ,FG.RENEW_PUB_OFFER_CD                             
                     ,FG.OFF_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VSTART_TS
           , 121), ' ', '-'), ':', '.') OFF_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS
           , 121), ' ', '-'), ':', '.') OFF_VEND_TS                            
                     ,FG.PROC_STATUS_CD                                 
                     ,FG.PROC_REQ_ID                                    
PRJ892               ,FG.MAX_PRICE_OFFER_CD                             
PRJ892               ,FG.RTCHG_PUB_OFFER_CD                             
                 FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
                WHERE (FG.OFFER_CD       = :FG-OFFER-CD                 
                  AND FG.COMPANY_NO      = :FG-COMPANY-NO)              
                  AND ((FG.OFFER_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )        
                    AND FG.OFFER_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ))       
                    OR (FG.OFFER_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )        
                    AND FG.OFFER_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )))        
                  AND ((FG.OFF_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )       
                    AND FG.OFF_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ))      
                    OR (FG.OFF_VSTART_TS  >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )       
                    AND FG.OFF_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )))       
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_CD_CUR CURSOR FOR                                  
MFA-TR*        SELECT FG.COMPANY_NO                                             
MFA-TR*              ,FG.OFFER_CD                                               
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*              ,FG.OFFER_DESC_EXT                                         
MFA-TR*              ,FG.PROMO_CD_INT_FL                                        
MFA-TR*              ,FG.PROMO_CD_EXT_FL                                        
MFA-TR*              ,FG.OFFER_START_DT                                         
MFA-TR*              ,FG.OFFER_END_DT                                           
MFA-TR*              ,FG.DISP_START_INT_TS                                      
MFA-TR*              ,FG.DISP_END_INT_TS                                        
MFA-TR*              ,FG.DISP_START_EXT_TS                                      
MFA-TR*              ,FG.DISP_END_EXT_TS                                        
MFA-TR*              ,FG.LAST_UPDATE_TS                                         
MFA-TR*              ,FG.LAST_UPDATE_USERID                                     
MFA-TR*              ,FG.OFFER_DESC_INT_LNG                                     
MFA-TR*              ,FG.OFFER_DESC_EXT_LNG                                     
MFA-TR*              ,FG.SPCL_OFFER_TYPE_CD                                     
MFA-TR*              ,FG.RENEWAL_OFFER_CD                                       
MFA-TR*              ,FG.RENEW_PUB_OFFER_CD                                     
MFA-TR*              ,FG.OFF_VRSN_NO                                            
MFA-TR*              ,FG.OFF_VSTART_TS                                          
MFA-TR*              ,FG.OFF_VEND_TS                                            
MFA-TR*              ,FG.PROC_STATUS_CD                                         
MFA-TR*              ,FG.PROC_REQ_ID                                            
MFA-TR*              ,FG.MAX_PRICE_OFFER_CD                                     
MFA-TR*              ,FG.RTCHG_PUB_OFFER_CD                                     
MFA-TR*          FROM CRM_RT_PKG_OFFER  FG                                      
MFA-TR*         WHERE (FG.OFFER_CD       = :FG-OFFER-CD                         
MFA-TR*           AND FG.COMPANY_NO      = :FG-COMPANY-NO)                      
MFA-TR*           AND ((FG.OFFER_START_DT <= :WS-ACTIVE-START-DT                
MFA-TR*             AND FG.OFFER_END_DT   >= :WS-ACTIVE-START-DT)               
MFA-TR*             OR (FG.OFFER_START_DT >= :WS-ACTIVE-START-DT                
MFA-TR*             AND FG.OFFER_START_DT <= :WS-ACTIVE-END-DT))                
MFA-TR*           AND ((FG.OFF_VSTART_TS  <= :WS-VERSION-START-TS               
MFA-TR*             AND FG.OFF_VEND_TS    >= :WS-VERSION-START-TS)              
MFA-TR*             OR (FG.OFF_VSTART_TS  >= :WS-VERSION-START-TS               
MFA-TR*             AND FG.OFF_VSTART_TS  <= :WS-VERSION-END-TS))               
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OPTION DETAILS BASED             *        
      *   OFFER CODE.                                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFFER_OPTION_CUR2 CURSOR FOR                     
                SELECT E9.COMPANY_NO                                    
                      ,E9.OFFER_CD                                      
                      ,E9.OPTION_CD                                     
                      ,E9.OPTION_SORT_SEQ_NO                            
                      ,E9.OPTION_URL_TX                                 
                      ,E9.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,E9.DROP_OPTION_CD                                
                      ,E9.OFFER_OPT_START_DT                            
                      ,E9.OFFER_OPT_END_DT                              
                      ,E9.OFF_OPT_VRSN_NO                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VSTART_TS                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VEND_TS                               
                      ,E9.PROC_STATUS_CD                                
                      ,E9.PROC_REQ_ID                                   
A04805                ,E9.WEB_NEW_EXISTS_CD                             
A04805                ,E9.WEB_SIGN_UP_FL                                
A04805                ,E9.OFF_OPT_EXCLUDE_CD                            
                  FROM CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)               
                 WHERE ( E9.OFFER_CD           = :E9-OFFER-CD           
                   AND   E9.COMPANY_NO         = :E9-COMPANY-NO )       
                   AND ((E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ))  
                     OR (E9.OFFER_OPT_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )))   
                   AND ((E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND E9.OFF_OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )) 
                     OR (E9.OFF_OPT_VSTART_TS  >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND E9.OFF_OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )))  
                   ORDER BY OFFER_CD,OPTION_CD                          
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_OPTION_CUR2 CURSOR FOR                             
MFA-TR*         SELECT E9.COMPANY_NO                                            
MFA-TR*               ,E9.OFFER_CD                                              
MFA-TR*               ,E9.OPTION_CD                                             
MFA-TR*               ,E9.OPTION_SORT_SEQ_NO                                    
MFA-TR*               ,E9.OPTION_URL_TX                                         
MFA-TR*               ,E9.LAST_UPDATE_USERID                                    
MFA-TR*               ,E9.LAST_UPDATE_TS                                        
MFA-TR*               ,E9.DROP_OPTION_CD                                        
MFA-TR*               ,E9.OFFER_OPT_START_DT                                    
MFA-TR*               ,E9.OFFER_OPT_END_DT                                      
MFA-TR*               ,E9.OFF_OPT_VRSN_NO                                       
MFA-TR*               ,E9.OFF_OPT_VSTART_TS                                     
MFA-TR*               ,E9.OFF_OPT_VEND_TS                                       
MFA-TR*               ,E9.PROC_STATUS_CD                                        
MFA-TR*               ,E9.PROC_REQ_ID                                           
MFA-TR*               ,E9.WEB_NEW_EXISTS_CD                                     
MFA-TR*               ,E9.WEB_SIGN_UP_FL                                        
MFA-TR*               ,E9.OFF_OPT_EXCLUDE_CD                                    
MFA-TR*           FROM CRM_OFFER_OPTION  E9                                     
MFA-TR*          WHERE ( E9.OFFER_CD           = :E9-OFFER-CD                   
MFA-TR*            AND   E9.COMPANY_NO         = :E9-COMPANY-NO )               
MFA-TR*            AND ((E9.OFFER_OPT_START_DT <= :WS-ACTIVE-START-DT           
MFA-TR*              AND E9.OFFER_OPT_END_DT   >= :WS-ACTIVE-START-DT)          
MFA-TR*              OR (E9.OFFER_OPT_START_DT >= :WS-ACTIVE-START-DT           
MFA-TR*              AND E9.OFFER_OPT_START_DT <= :WS-ACTIVE-END-DT))           
MFA-TR*            AND ((E9.OFF_OPT_VSTART_TS  <= :WS-VERSION-START-TS          
MFA-TR*              AND E9.OFF_OPT_VEND_TS    >= :WS-VERSION-START-TS)         
MFA-TR*              OR (E9.OFF_OPT_VSTART_TS  >= :WS-VERSION-START-TS          
MFA-TR*              AND E9.OFF_OPT_VSTART_TS  <= :WS-VERSION-END-TS))          
MFA-TR*            ORDER BY OFFER_CD,OPTION_CD                                  
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7270                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OPTION DETAILS BASED             *        
      *   OFFER CODE.                                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE OPTION_CD_CUR CURSOR FOR                          
               SELECT FI.COMPANY_NO                                     
                     ,FI.OPTION_CD                                      
                     ,FI.CODE_UTIL_TYPE                                 
                     ,FI.RATE_PLAN_NO                                   
                     ,FI.OPTION_START_DT                                
                     ,FI.OPTION_END_DT                                  
                     ,FI.OPT_DESC_INT                                   
                     ,FI.OPT_DESC_INT_LONG                              
                     ,FI.CURR_EXT_DESC_LONG                             
                     ,FI.RENEWAL_DESC_LONG                              
                     ,FI.WEB_DESC_LONG                                  
                     ,FI.STATUS_CD                                      
                     ,FI.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FI.OPT_CALC_TYPE_CD                               
                     ,FI.WEB_MKT_DESC_LONG                              
                     ,FI.OPT_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VSTART_TS
           , 121), ' ', '-'), ':', '.') OPT_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VEND_TS
           , 121), ' ', '-'), ':', '.') OPT_VEND_TS                            
                     ,FI.PROC_STATUS_CD                                 
                     ,FI.PROC_REQ_ID                                    
A04805               ,FI.OPTION_TYPE_DESC                               
PRJ892               ,FI.AUTO_RENEWAL_FL                                
PRJ892               ,FI.OPTION_PROMO_DESC                              
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE (FI.OPTION_CD         = :FI-OPTION-CD             
                  AND FI.COMPANY_NO         = :FI-COMPANY-NO )          
                  AND (( :WS-ACTIVE-ONLY = 'Y'                          
                     AND FI.OPTION_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )       
                      OR :WS-ACTIVE-ONLY     = 'N' )                    
                  AND (( FI.OPTION_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )      
                     AND FI.OPTION_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ))     
                     OR (FI.OPTION_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )      
                     AND FI.OPTION_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) ) ))     
                  AND (( FI.OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )      
                     AND FI.OPT_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ))     
                     OR (FI.OPT_VSTART_TS  >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )      
                     AND FI.OPT_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )))      
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OPTION_CD_CUR CURSOR FOR                                  
MFA-TR*        SELECT FI.COMPANY_NO                                             
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CODE_UTIL_TYPE                                         
MFA-TR*              ,FI.RATE_PLAN_NO                                           
MFA-TR*              ,FI.OPTION_START_DT                                        
MFA-TR*              ,FI.OPTION_END_DT                                          
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,FI.OPT_DESC_INT_LONG                                      
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,FI.RENEWAL_DESC_LONG                                      
MFA-TR*              ,FI.WEB_DESC_LONG                                          
MFA-TR*              ,FI.STATUS_CD                                              
MFA-TR*              ,FI.LAST_UPDATE_USERID                                     
MFA-TR*              ,FI.LAST_UPDATE_TS                                         
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.WEB_MKT_DESC_LONG                                      
MFA-TR*              ,FI.OPT_VRSN_NO                                            
MFA-TR*              ,FI.OPT_VSTART_TS                                          
MFA-TR*              ,FI.OPT_VEND_TS                                            
MFA-TR*              ,FI.PROC_STATUS_CD                                         
MFA-TR*              ,FI.PROC_REQ_ID                                            
MFA-TR*              ,FI.OPTION_TYPE_DESC                                       
MFA-TR*              ,FI.AUTO_RENEWAL_FL                                        
MFA-TR*              ,FI.OPTION_PROMO_DESC                                      
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE (FI.OPTION_CD         = :FI-OPTION-CD                     
MFA-TR*           AND FI.COMPANY_NO         = :FI-COMPANY-NO )                  
MFA-TR*           AND (( :WS-ACTIVE-ONLY = 'Y'                                  
MFA-TR*              AND FI.OPTION_END_DT   >= :WS-CURRENT-DATE )               
MFA-TR*               OR :WS-ACTIVE-ONLY     = 'N' )                            
MFA-TR*           AND (( FI.OPTION_START_DT <= :WS-ACTIVE-START-DT              
MFA-TR*              AND FI.OPTION_END_DT   >= :WS-ACTIVE-START-DT)             
MFA-TR*              OR (FI.OPTION_START_DT >= :WS-ACTIVE-START-DT              
MFA-TR*              AND FI.OPTION_START_DT <= :WS-ACTIVE-END-DT ))             
MFA-TR*           AND (( FI.OPT_VSTART_TS  <= :WS-VERSION-START-TS              
MFA-TR*              AND FI.OPT_VEND_TS    >= :WS-VERSION-START-TS)             
MFA-TR*              OR (FI.OPT_VSTART_TS  >= :WS-VERSION-START-TS              
MFA-TR*              AND FI.OPT_VSTART_TS  <= :WS-VERSION-END-TS))              
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*           QUERYNO 7101                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OFFER DETAILS BASED              *        
      *   MARKET RANKING CD.                                                    
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFF_MKT_TIER_CUR  CURSOR FOR                     
                SELECT IG.COMPANY_NO                                    
                      ,DU.OFFER_CD                                      
                      ,DU.TIER_CUST_STAT_CD                             
                      ,DU.TIER_ACCT_TYPE_CD                             
                      ,DU.MKT_TIER_RANKING                              
                      ,DU.MKT_TIER_START_DT                             
                      ,IG.MKT_TIER_DESC                                 
                      ,IG.MKT_TIER_END_DT                               
                      ,IG.TIER_OFFER_VIEW                               
                      ,DU.OFFER_TIER_STRT_DT                            
                      ,DU.MKT_TIER_APPLY_CD                             
                      ,DU.TIER_DEFLT_OFFR_CD                            
                      ,DU.OFFER_TIER_END_DT                             
                      ,IG.CUST_ACCT_DEFLT_FL                            
                      ,IG.MKT_TIER_DESC_LONG                            
                      ,DU.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,DU.OFF_TIER_VRSN_NO                              
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VSTART_TS                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VEND_TS                              
                      ,DU.PROC_STATUS_CD                                
                      ,DU.PROC_REQ_ID                                   
                  FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                
                      ,CRM_MKT_TIER IG WITH(READUNCOMMITTED)                    
                 WHERE (DU.TIER_CUST_STAT_CD  = IG.TIER_CUST_STAT_CD    
                   AND DU.TIER_ACCT_TYPE_CD   = IG.TIER_ACCT_TYPE_CD    
                   AND DU.MKT_TIER_RANKING    = IG.MKT_TIER_RANKING     
                   AND DU.MKT_TIER_START_DT   = IG.MKT_TIER_START_DT    
                   AND DU.OFFER_CD            = :DU-OFFER-CD            
                   AND DU.COMPANY_NO          = :DU-COMPANY-NO )        
                   AND (( IG.MKT_TIER_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                      AND IG.MKT_TIER_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ))  
                      OR (IG.MKT_TIER_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                      AND IG.MKT_TIER_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) ) ))  
                   AND (( DU.OFFER_TIER_STRT_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )  
                      AND DU.OFFER_TIER_END_DT  >= 
              IIF(TRY_CONVERT(DATE, :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )) 
                      OR (DU.OFFER_TIER_STRT_DT >= 
              IIF(TRY_CONVERT(DATE, :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )  
                      AND DU.OFFER_TIER_STRT_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )))  
                   AND ((DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )) 
                     OR (DU.OFF_TIER_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )))  
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFF_MKT_TIER_CUR  CURSOR FOR                             
MFA-TR*         SELECT IG.COMPANY_NO                                            
MFA-TR*               ,DU.OFFER_CD                                              
MFA-TR*               ,DU.TIER_CUST_STAT_CD                                     
MFA-TR*               ,DU.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,DU.MKT_TIER_RANKING                                      
MFA-TR*               ,DU.MKT_TIER_START_DT                                     
MFA-TR*               ,IG.MKT_TIER_DESC                                         
MFA-TR*               ,IG.MKT_TIER_END_DT                                       
MFA-TR*               ,IG.TIER_OFFER_VIEW                                       
MFA-TR*               ,DU.OFFER_TIER_STRT_DT                                    
MFA-TR*               ,DU.MKT_TIER_APPLY_CD                                     
MFA-TR*               ,DU.TIER_DEFLT_OFFR_CD                                    
MFA-TR*               ,DU.OFFER_TIER_END_DT                                     
MFA-TR*               ,IG.CUST_ACCT_DEFLT_FL                                    
MFA-TR*               ,IG.MKT_TIER_DESC_LONG                                    
MFA-TR*               ,DU.LAST_UPDATE_USERID                                    
MFA-TR*               ,DU.LAST_UPDATE_TS                                        
MFA-TR*               ,DU.OFF_TIER_VRSN_NO                                      
MFA-TR*               ,DU.OFF_TIER_VSTART_TS                                    
MFA-TR*               ,DU.OFF_TIER_VEND_TS                                      
MFA-TR*               ,DU.PROC_STATUS_CD                                        
MFA-TR*               ,DU.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_OFF_MKT_TIER DU                                      
MFA-TR*               ,CRM_MKT_TIER IG                                          
MFA-TR*          WHERE (DU.TIER_CUST_STAT_CD  = IG.TIER_CUST_STAT_CD            
MFA-TR*            AND DU.TIER_ACCT_TYPE_CD   = IG.TIER_ACCT_TYPE_CD            
MFA-TR*            AND DU.MKT_TIER_RANKING    = IG.MKT_TIER_RANKING             
MFA-TR*            AND DU.MKT_TIER_START_DT   = IG.MKT_TIER_START_DT            
MFA-TR*            AND DU.OFFER_CD            = :DU-OFFER-CD                    
MFA-TR*            AND DU.COMPANY_NO          = :DU-COMPANY-NO )                
MFA-TR*            AND (( IG.MKT_TIER_START_DT <= :WS-ACTIVE-START-DT           
MFA-TR*               AND IG.MKT_TIER_END_DT   >= :WS-ACTIVE-START-DT)          
MFA-TR*               OR (IG.MKT_TIER_START_DT >= :WS-ACTIVE-START-DT           
MFA-TR*               AND IG.MKT_TIER_START_DT <= :WS-ACTIVE-END-DT ))          
MFA-TR*            AND (( DU.OFFER_TIER_STRT_DT <= :WS-ACTIVE-START-DT          
MFA-TR*               AND DU.OFFER_TIER_END_DT  >= :WS-ACTIVE-START-DT)         
MFA-TR*               OR (DU.OFFER_TIER_STRT_DT >= :WS-ACTIVE-START-DT          
MFA-TR*               AND DU.OFFER_TIER_STRT_DT <= :WS-ACTIVE-END-DT))          
MFA-TR*            AND ((DU.OFF_TIER_VSTART_TS <= :WS-VERSION-START-TS          
MFA-TR*              AND DU.OFF_TIER_VEND_TS   >= :WS-VERSION-START-TS)         
MFA-TR*              OR (DU.OFF_TIER_VSTART_TS >= :WS-VERSION-START-TS          
MFA-TR*              AND DU.OFF_TIER_VSTART_TS <= :WS-VERSION-END-TS))          
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7330                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CURSOR DECLARATION TO FETCH ATTRIBUTE INCENTIVE DETAILS     *         
      *   BASED ON OPTION CODE.                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE ATTR_INCEN_CUR CURSOR FOR                         
               SELECT HQ.COMPANY_NO                                     
                     ,HQ.OPTION_CD                                      
                     ,HQ.ATTR_INCTV_SEQ_NO                              
                     ,HQ.RT_ATTR_INCTV_TYPE                             
                     ,HQ.PRIMRY_OPT_ATTR_FL                             
                     ,HQ.FACTOR_ID                                      
                     ,HQ.DURATION_NO                                    
                     ,HQ.APPL_PROGRAM_ID                                
                     ,HQ.ATTR_INCTV_VALUE                               
                     ,HQ.ATTR_INCTV_VAL_TX                              
                     ,HQ.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,HQ.GL_ACCT_CREDIT                                 
                     ,HQ.GL_ACCT_DEBIT                                  
                     ,HQ.CATEGORY_ID                                    
                     ,HQ.WQ_ROUTE_CATEGORY                              
                     ,HQ.OPT_CHG_ACTION_CD                              
                     ,HQ.ATTR_INCTV_STRT_DT                             
                     ,HQ.ATTR_INCTV_END_DT                              
                     ,HQ.OPT_ATTR_VRSN_NO                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.OPT_ATTR_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OPT_ATTR_VSTART_TS                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.OPT_ATTR_VEND_TS, 121), ' ', '-'), ':', '.') 
           OPT_ATTR_VEND_TS                               
                     ,HQ.PROC_STATUS_CD                                 
                     ,HQ.PROC_REQ_ID                                    
                 FROM CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)              
                WHERE (HQ.OPTION_CD       = :HQ-OPTION-CD               
                  AND HQ.COMPANY_NO       = :HQ-COMPANY-NO)             
                  AND (( HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ))  
                     OR (HQ.ATTR_INCTV_STRT_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )))   
                  AND (( HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )) 
                     OR (HQ.OPT_ATTR_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )))  
                ORDER BY HQ.ATTR_INCTV_SEQ_NO                           
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ATTR_INCEN_CUR CURSOR FOR                                 
MFA-TR*        SELECT HQ.COMPANY_NO                                             
MFA-TR*              ,HQ.OPTION_CD                                              
MFA-TR*              ,HQ.ATTR_INCTV_SEQ_NO                                      
MFA-TR*              ,HQ.RT_ATTR_INCTV_TYPE                                     
MFA-TR*              ,HQ.PRIMRY_OPT_ATTR_FL                                     
MFA-TR*              ,HQ.FACTOR_ID                                              
MFA-TR*              ,HQ.DURATION_NO                                            
MFA-TR*              ,HQ.APPL_PROGRAM_ID                                        
MFA-TR*              ,HQ.ATTR_INCTV_VALUE                                       
MFA-TR*              ,HQ.ATTR_INCTV_VAL_TX                                      
MFA-TR*              ,HQ.LAST_UPDATE_USERID                                     
MFA-TR*              ,HQ.LAST_UPDATE_TS                                         
MFA-TR*              ,HQ.GL_ACCT_CREDIT                                         
MFA-TR*              ,HQ.GL_ACCT_DEBIT                                          
MFA-TR*              ,HQ.CATEGORY_ID                                            
MFA-TR*              ,HQ.WQ_ROUTE_CATEGORY                                      
MFA-TR*              ,HQ.OPT_CHG_ACTION_CD                                      
MFA-TR*              ,HQ.ATTR_INCTV_STRT_DT                                     
MFA-TR*              ,HQ.ATTR_INCTV_END_DT                                      
MFA-TR*              ,HQ.OPT_ATTR_VRSN_NO                                       
MFA-TR*              ,HQ.OPT_ATTR_VSTART_TS                                     
MFA-TR*              ,HQ.OPT_ATTR_VEND_TS                                       
MFA-TR*              ,HQ.PROC_STATUS_CD                                         
MFA-TR*              ,HQ.PROC_REQ_ID                                            
MFA-TR*          FROM CRM_OPT_ATTR_INCTV  HQ                                    
MFA-TR*         WHERE (HQ.OPTION_CD       = :HQ-OPTION-CD                       
MFA-TR*           AND HQ.COMPANY_NO       = :HQ-COMPANY-NO)                     
MFA-TR*           AND (( HQ.ATTR_INCTV_STRT_DT <= :WS-ACTIVE-START-DT           
MFA-TR*              AND HQ.ATTR_INCTV_END_DT  >= :WS-ACTIVE-START-DT)          
MFA-TR*              OR (HQ.ATTR_INCTV_STRT_DT >= :WS-ACTIVE-START-DT           
MFA-TR*              AND HQ.ATTR_INCTV_STRT_DT <= :WS-ACTIVE-END-DT))           
MFA-TR*           AND (( HQ.OPT_ATTR_VSTART_TS <= :WS-VERSION-START-TS          
MFA-TR*              AND HQ.OPT_ATTR_VEND_TS   >= :WS-VERSION-START-TS)         
MFA-TR*              OR (HQ.OPT_ATTR_VSTART_TS >= :WS-VERSION-START-TS          
MFA-TR*              AND HQ.OPT_ATTR_VSTART_TS <= :WS-VERSION-END-TS))          
MFA-TR*         ORDER BY HQ.ATTR_INCTV_SEQ_NO                                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7210                                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR TO GET THE PROMOTION DETAILS BASED ON THE OFFER                
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE OFFER_PROMO_CUR CURSOR FOR                       
                SELECT KM.COMPANY_NO                                    
                      ,KM.PROMO_CD                                      
                      ,KM.PROMO_DESC                                    
                      ,KM.OFFER_CD                                      
                      ,KM.MKT_PLAN_CD                                   
                      ,KM.PROMO_START_DT                                
                      ,REPLACE(CONVERT(CHAR(8), KM.PROMO_START_TM
           , 108), ':', '.') PROMO_START_TM                                
                      ,KM.PROMO_END_DT                                  
                      ,REPLACE(CONVERT(CHAR(8), KM.PROMO_END_TM, 108), 
           ':', '.') PROMO_END_TM                                  
                      ,KM.AD_CHANNEL_CD                                 
                      ,KM.PROMO_DESC_LONG                               
                      ,KM.EXT_LANDING_PG_URL                            
                      ,KM.PROMO_TYPE_CD                                 
                      ,KM.WEB_IMAGE_FILE_NM                             
                      ,KM.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,KM.REPLACMNT_PROMO_CD                            
                      ,KM.DISPLAY_END_DT                                
                      ,KM.INT_LANDING_PG_URL                            
                      ,KM.PROMO_VRSN_NO                                 
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VSTART_TS, 121), ' ', '-'), ':', '.') 
           PROMO_VSTART_TS                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VEND_TS, 121), ' ', '-'), ':', '.') PROMO_VEND_TS          
                      ,KM.PROC_STATUS_CD                                
                      ,KM.PROC_REQ_ID                                   
                  FROM CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)               
                 WHERE KM.OFFER_CD         = :KM-OFFER-CD               
                   AND (( KM.PROMO_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )      
                      AND KM.PROMO_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ))     
                     OR ( KM.PROMO_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )      
                      AND KM.PROMO_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )))      
                   AND (( KM.PROMO_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )    
                      AND KM.PROMO_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ))   
                     OR ( KM.PROMO_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )    
                      AND KM.PROMO_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )))    
                 ORDER BY PROMO_CD,PROMO_VRSN_NO DESC                   
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_PROMO_CUR CURSOR FOR                               
MFA-TR*         SELECT KM.COMPANY_NO                                            
MFA-TR*               ,KM.PROMO_CD                                              
MFA-TR*               ,KM.PROMO_DESC                                            
MFA-TR*               ,KM.OFFER_CD                                              
MFA-TR*               ,KM.MKT_PLAN_CD                                           
MFA-TR*               ,KM.PROMO_START_DT                                        
MFA-TR*               ,KM.PROMO_START_TM                                        
MFA-TR*               ,KM.PROMO_END_DT                                          
MFA-TR*               ,KM.PROMO_END_TM                                          
MFA-TR*               ,KM.AD_CHANNEL_CD                                         
MFA-TR*               ,KM.PROMO_DESC_LONG                                       
MFA-TR*               ,KM.EXT_LANDING_PG_URL                                    
MFA-TR*               ,KM.PROMO_TYPE_CD                                         
MFA-TR*               ,KM.WEB_IMAGE_FILE_NM                                     
MFA-TR*               ,KM.LAST_UPDATE_USERID                                    
MFA-TR*               ,KM.LAST_UPDATE_TS                                        
MFA-TR*               ,KM.REPLACMNT_PROMO_CD                                    
MFA-TR*               ,KM.DISPLAY_END_DT                                        
MFA-TR*               ,KM.INT_LANDING_PG_URL                                    
MFA-TR*               ,KM.PROMO_VRSN_NO                                         
MFA-TR*               ,KM.PROMO_VSTART_TS                                       
MFA-TR*               ,KM.PROMO_VEND_TS                                         
MFA-TR*               ,KM.PROC_STATUS_CD                                        
MFA-TR*               ,KM.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_MKT_PROMOTION KM                                     
MFA-TR*          WHERE KM.OFFER_CD         = :KM-OFFER-CD                       
MFA-TR*            AND (( KM.PROMO_START_DT <= :WS-ACTIVE-START-DT              
MFA-TR*               AND KM.PROMO_END_DT   >= :WS-ACTIVE-START-DT)             
MFA-TR*              OR ( KM.PROMO_START_DT >= :WS-ACTIVE-START-DT              
MFA-TR*               AND KM.PROMO_START_DT <= :WS-ACTIVE-END-DT))              
MFA-TR*            AND (( KM.PROMO_VSTART_TS <= :WS-VERSION-START-TS            
MFA-TR*               AND KM.PROMO_VEND_TS   >= :WS-VERSION-START-TS)           
MFA-TR*              OR ( KM.PROMO_VSTART_TS >= :WS-VERSION-START-TS            
MFA-TR*               AND KM.PROMO_VSTART_TS <= :WS-VERSION-END-TS))            
MFA-TR*          ORDER BY PROMO_CD,PROMO_VRSN_NO DESC                           
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7350                                                  
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01 I-APPLICATION-ID      PIC  X(03).                             
       01 I-RESOURCE-ID         PIC  X(32).                             
       01 I-USER-ID             PIC  X(07).                             
       01 I-COMPANY-NO          PIC  X(02).                             
       01 I-SEARCH-METHOD       PIC  X(05).                             
       01 I-SEARCH-CRITERIA     PIC  X(50).                             
       01 I-WILDCARD-FLAG       PIC  X(01).                             
       01 I-ACTV-PRD-FLAG       PIC  X(01).                             
       01 I-PROC-STATUS-FLAG    PIC  X(01).                             
       01 I-PROC-STATUS         PIC  X(02).                             
       01 I-VRSN-TS-FLAG        PIC  X(01).                             
       01 I-CHK-START-TS        PIC  X(26).                             
       01 I-CHK-END-TS          PIC  X(26).                             
       01 I-CUSTOMER-TYPE-CD    PIC  X(01).                             
       01 I-ACCOUNT-TYPE-CD     PIC  X(01).                             
       01 I-MKT-TIER-RANKING    PIC  S9(04) USAGE COMP.                 
      *                                                                         
       PROCEDURE DIVISION USING I-APPLICATION-ID                        
                               ,I-RESOURCE-ID                           
                               ,I-USER-ID                               
                               ,I-COMPANY-NO                            
                               ,I-SEARCH-METHOD                         
                               ,I-SEARCH-CRITERIA                       
                               ,I-WILDCARD-FLAG                         
                               ,I-ACTV-PRD-FLAG                         
                               ,I-PROC-STATUS-FLAG                      
                               ,I-PROC-STATUS                           
                               ,I-VRSN-TS-FLAG                          
                               ,I-CHK-START-TS                          
                               ,I-CHK-END-TS                            
                               ,I-CUSTOMER-TYPE-CD                      
                               ,I-ACCOUNT-TYPE-CD                       
                               ,I-MKT-TIER-RANKING.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1   -  CRM_RT_PKG_OFFER                     *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04431_R1'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04431_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04431_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,MKT_TIER_RANKING        SMALLINT                    
                   ,TIER_CUST_STAT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_ACCT_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_DESC_INT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_DESC_EXT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_CD_INT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_CD_EXT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_START_INT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_END_INT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_START_EXT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_END_EXT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_DESC_INT_LNG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,OFFER_DESC_EXT_LNG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,SPCL_OFFER_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RENEWAL_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RENEW_PUB_OFFER_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_VRSN_NO             SMALLINT                    
                   ,OFF_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
PRJ892             ,MAX_PRICE_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
PRJ892             ,RTCHG_PUB_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS        THRU 8000A-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100A'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD          
                      ,MKT_TIER_RANKING         AS MKT_TIER_RANKING_KEY 
                      ,LTRIM(RTRIM(TIER_CUST_STAT_CD))                         
                                                AS TIER_CUST_STAT_CD_KEY
                      ,LTRIM(RTRIM(TIER_ACCT_TYPE_CD))                         
                                                AS TIER_ACCT_TYPE_CD_KEY
                      ,LTRIM(RTRIM(MKT_TIER_START_DT))                         
                                                AS MKT_TIER_START_DT_KEY
                      ,LTRIM(RTRIM(OFFER_DESC_INT))       AS 
           OFFER_DESC_INT    
                      ,LTRIM(RTRIM(OFFER_DESC_EXT))       AS 
           OFFER_DESC_EXT    
                      ,LTRIM(RTRIM(PROMO_CD_INT_FL))      AS 
           PROMO_CD_INT_FL   
                      ,LTRIM(RTRIM(PROMO_CD_EXT_FL))      AS 
           PROMO_CD_EXT_FL   
                      ,LTRIM(RTRIM(OFFER_START_DT))       AS 
           OFFER_START_DT    
                      ,LTRIM(RTRIM(OFFER_END_DT))         AS 
           OFFER_END_DT      
                      ,LTRIM(RTRIM(DISP_START_INT_TS))    AS 
           DISP_START_INT_TS 
                      ,LTRIM(RTRIM(DISP_END_INT_TS))      AS 
           DISP_END_INT_TS   
                      ,LTRIM(RTRIM(DISP_START_EXT_TS))    AS 
           DISP_START_EXT_TS 
                      ,LTRIM(RTRIM(DISP_END_EXT_TS))      AS 
           DISP_END_EXT_TS   
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(OFFER_DESC_INT_LNG))   AS 
           OFFER_DESC_INT_LNG
                      ,LTRIM(RTRIM(OFFER_DESC_EXT_LNG))   AS 
           OFFER_DESC_EXT_LNG
                      ,LTRIM(RTRIM(SPCL_OFFER_TYPE_CD))   AS 
           SPCL_OFFER_TYPE_CD
                      ,LTRIM(RTRIM(RENEWAL_OFFER_CD))     AS 
           RENEWAL_OFFER_CD  
                      ,LTRIM(RTRIM(RENEW_PUB_OFFER_CD))   AS 
           RENEW_PUB_OFFER_CD
                      ,OFF_VRSN_NO                 AS OFF_VRSN_NO       
                      ,LTRIM(RTRIM(OFF_VSTART_TS))        AS 
           OFF_VSTART_TS     
                      ,LTRIM(RTRIM(OFF_VEND_TS))          AS OFF_VEND_TS       
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
PRJ892                ,LTRIM(RTRIM(MAX_PRICE_OFFER_CD))   AS 
           MAX_PRICE_OFFER_CD
PRJ892                ,LTRIM(RTRIM(RTCHG_PUB_OFFER_CD))   AS 
           RTCHG_PUB_OFFER_CD
                  FROM #CSR04431_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD                  
MFA-TR*               ,MKT_TIER_RANKING         AS MKT_TIER_RANKING_KEY         
MFA-TR*               ,STRIP(TIER_CUST_STAT_CD)                                 
MFA-TR*                                         AS TIER_CUST_STAT_CD_KEY        
MFA-TR*               ,STRIP(TIER_ACCT_TYPE_CD)                                 
MFA-TR*                                         AS TIER_ACCT_TYPE_CD_KEY        
MFA-TR*               ,STRIP(MKT_TIER_START_DT)                                 
MFA-TR*                                         AS MKT_TIER_START_DT_KEY        
MFA-TR*               ,STRIP(OFFER_DESC_INT)       AS OFFER_DESC_INT            
MFA-TR*               ,STRIP(OFFER_DESC_EXT)       AS OFFER_DESC_EXT            
MFA-TR*               ,STRIP(PROMO_CD_INT_FL)      AS PROMO_CD_INT_FL           
MFA-TR*               ,STRIP(PROMO_CD_EXT_FL)      AS PROMO_CD_EXT_FL           
MFA-TR*               ,STRIP(OFFER_START_DT)       AS OFFER_START_DT            
MFA-TR*               ,STRIP(OFFER_END_DT)         AS OFFER_END_DT              
MFA-TR*               ,STRIP(DISP_START_INT_TS)    AS DISP_START_INT_TS         
MFA-TR*               ,STRIP(DISP_END_INT_TS)      AS DISP_END_INT_TS           
MFA-TR*               ,STRIP(DISP_START_EXT_TS)    AS DISP_START_EXT_TS         
MFA-TR*               ,STRIP(DISP_END_EXT_TS)      AS DISP_END_EXT_TS           
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(OFFER_DESC_INT_LNG)   AS OFFER_DESC_INT_LNG        
MFA-TR*               ,STRIP(OFFER_DESC_EXT_LNG)   AS OFFER_DESC_EXT_LNG        
MFA-TR*               ,STRIP(SPCL_OFFER_TYPE_CD)   AS SPCL_OFFER_TYPE_CD        
MFA-TR*               ,STRIP(RENEWAL_OFFER_CD)     AS RENEWAL_OFFER_CD          
MFA-TR*               ,STRIP(RENEW_PUB_OFFER_CD)   AS RENEW_PUB_OFFER_CD        
MFA-TR*               ,OFF_VRSN_NO                 AS OFF_VRSN_NO               
MFA-TR*               ,STRIP(OFF_VSTART_TS)        AS OFF_VSTART_TS             
MFA-TR*               ,STRIP(OFF_VEND_TS)          AS OFF_VEND_TS               
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*               ,STRIP(MAX_PRICE_OFFER_CD)   AS MAX_PRICE_OFFER_CD        
MFA-TR*               ,STRIP(RTCHG_PUB_OFFER_CD)   AS RTCHG_PUB_OFFER_CD        
MFA-TR*           FROM SESSION.CSR04431_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2 - CRM_RT_PKG_OPTION                       *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04431_R2'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04431_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04431_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPTION_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPTION_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_DESC_INT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_DESC_INT_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,CURR_EXT_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,RENEWAL_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,WEB_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_CALC_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WEB_MKT_DESC_LONG VARCHAR(1024)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2               
                   ,OPT_VRSN_NO             SMALLINT                    
                   ,OPT_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
A04805             ,OPTION_TYPE_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
PRJ892             ,AUTO_RENEWAL_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
PRJ892             ,OPTION_PROMO_DESC VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS        THRU 8000B-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100B'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD         
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,LTRIM(RTRIM(OPTION_START_DT))      AS 
           OPTION_START_DT   
                      ,LTRIM(RTRIM(OPTION_END_DT))        AS 
           OPTION_END_DT     
                      ,LTRIM(RTRIM(OPT_DESC_INT))         AS 
           OPT_DESC_INT      
                      ,LTRIM(RTRIM(OPT_DESC_INT_LONG))    AS 
           OPT_DESC_INT_LONG 
                      ,LTRIM(RTRIM(CURR_EXT_DESC_LONG))   AS 
           CURR_EXT_DESC_LONG
                      ,LTRIM(RTRIM(RENEWAL_DESC_LONG))    AS 
           RENEWAL_DESC_LONG 
                      ,LTRIM(RTRIM(WEB_DESC_LONG))        AS 
           WEB_DESC_LONG     
                      ,LTRIM(RTRIM(STATUS_CD))            AS STATUS_CD         
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,LTRIM(RTRIM(OPT_CALC_TYPE_CD))     AS 
           OPT_CALC_TYPE_CD  
                      ,LTRIM(RTRIM(WEB_MKT_DESC_LONG))    AS 
           WEB_MKT_DESC_LONG 
                      ,OPT_VRSN_NO                 AS OPT_VRSN_NO       
                      ,LTRIM(RTRIM(OPT_VSTART_TS))        AS 
           OPT_VSTART_TS     
                      ,LTRIM(RTRIM(OPT_VEND_TS))          AS OPT_VEND_TS       
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
A04805                ,LTRIM(RTRIM(OPTION_TYPE_DESC))     AS 
           OPTION_TYPE_DESC  
PRJ892                ,AUTO_RENEWAL_FL             AS AUTO_RENEWAL_FL   
PRJ892                ,LTRIM(RTRIM(OPTION_PROMO_DESC))    AS 
           OPTION_PROMO_DESC 
                  FROM #CSR04431_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OPTION_CD)            AS OPTION_CD                 
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,STRIP(OPTION_START_DT)      AS OPTION_START_DT           
MFA-TR*               ,STRIP(OPTION_END_DT)        AS OPTION_END_DT             
MFA-TR*               ,STRIP(OPT_DESC_INT)         AS OPT_DESC_INT              
MFA-TR*               ,STRIP(OPT_DESC_INT_LONG)    AS OPT_DESC_INT_LONG         
MFA-TR*               ,STRIP(CURR_EXT_DESC_LONG)   AS CURR_EXT_DESC_LONG        
MFA-TR*               ,STRIP(RENEWAL_DESC_LONG)    AS RENEWAL_DESC_LONG         
MFA-TR*               ,STRIP(WEB_DESC_LONG)        AS WEB_DESC_LONG             
MFA-TR*               ,STRIP(STATUS_CD)            AS STATUS_CD                 
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,STRIP(OPT_CALC_TYPE_CD)     AS OPT_CALC_TYPE_CD          
MFA-TR*               ,STRIP(WEB_MKT_DESC_LONG)    AS WEB_MKT_DESC_LONG         
MFA-TR*               ,OPT_VRSN_NO                 AS OPT_VRSN_NO               
MFA-TR*               ,STRIP(OPT_VSTART_TS)        AS OPT_VSTART_TS             
MFA-TR*               ,STRIP(OPT_VEND_TS)          AS OPT_VEND_TS               
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*               ,STRIP(OPTION_TYPE_DESC)     AS OPTION_TYPE_DESC          
MFA-TR*               ,AUTO_RENEWAL_FL             AS AUTO_RENEWAL_FL           
MFA-TR*               ,STRIP(OPTION_PROMO_DESC)    AS OPTION_PROMO_DESC         
MFA-TR*           FROM SESSION.CSR04431_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100C-DECLARE-GTT-R3   - CRM_MKT_PROMOTION                     *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04431_R3'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04431_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04431_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,PROMO_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,PROMO_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,MKT_PLAN_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_START_TM CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_END_TM CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,AD_CHANNEL_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,EXT_LANDING_PG_URL VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMO_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WEB_IMAGE_FILE_NM VARCHAR(100)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REPLACMNT_PROMO_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISPLAY_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INT_LANDING_PG_URL VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMO_VRSN_NO           SMALLINT                    
                   ,PROMO_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS        THRU 8000C-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100C'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(PROMO_CD))             AS PROMO_CD          
                      ,LTRIM(RTRIM(PROMO_DESC))           AS PPROMO_DESC       
                      ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD          
                      ,LTRIM(RTRIM(MKT_PLAN_CD))          AS MKT_PLAN_CD       
                      ,LTRIM(RTRIM(PROMO_START_DT))       AS 
           PROMO_START_DT    
                      ,LTRIM(RTRIM(PROMO_START_TM))       AS 
           PROMO_START_TM    
                      ,LTRIM(RTRIM(PROMO_END_DT))         AS 
           PROMO_END_DT      
                      ,LTRIM(RTRIM(PROMO_END_TM))         AS 
           PROMO_END_TM      
                      ,LTRIM(RTRIM(AD_CHANNEL_CD))        AS 
           AD_CHANNEL_CD     
                      ,LTRIM(RTRIM(PROMO_DESC_LONG))      AS 
           PROMO_DESC_LONG   
                      ,LTRIM(RTRIM(EXT_LANDING_PG_URL))   AS 
           EXT_LANDING_PG_URL
                      ,LTRIM(RTRIM(PROMO_TYPE_CD))        AS 
           PROMO_TYPE_CD     
                      ,LTRIM(RTRIM(WEB_IMAGE_FILE_NM))    AS 
           WEB_IMAGE_FILE_NM 
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,LTRIM(RTRIM(REPLACMNT_PROMO_CD))   AS 
           REPLACMNT_PROMO_CD
                      ,LTRIM(RTRIM(DISPLAY_END_DT))       AS 
           DISPLAY_END_DT    
                      ,LTRIM(RTRIM(INT_LANDING_PG_URL))   AS 
           INT_LANDING_PG_URL
                      ,PROMO_VRSN_NO               AS PROMO_VRSN_NO     
                      ,LTRIM(RTRIM(PROMO_VSTART_TS))      AS 
           PROMO_VSTART_TS   
                      ,LTRIM(RTRIM(PROMO_VEND_TS))        AS 
           PROMO_VEND_TS     
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
                  FROM #CSR04431_R3                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(PROMO_CD)             AS PROMO_CD                  
MFA-TR*               ,STRIP(PROMO_DESC)           AS PPROMO_DESC               
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD                  
MFA-TR*               ,STRIP(MKT_PLAN_CD)          AS MKT_PLAN_CD               
MFA-TR*               ,STRIP(PROMO_START_DT)       AS PROMO_START_DT            
MFA-TR*               ,STRIP(PROMO_START_TM)       AS PROMO_START_TM            
MFA-TR*               ,STRIP(PROMO_END_DT)         AS PROMO_END_DT              
MFA-TR*               ,STRIP(PROMO_END_TM)         AS PROMO_END_TM              
MFA-TR*               ,STRIP(AD_CHANNEL_CD)        AS AD_CHANNEL_CD             
MFA-TR*               ,STRIP(PROMO_DESC_LONG)      AS PROMO_DESC_LONG           
MFA-TR*               ,STRIP(EXT_LANDING_PG_URL)   AS EXT_LANDING_PG_URL        
MFA-TR*               ,STRIP(PROMO_TYPE_CD)        AS PROMO_TYPE_CD             
MFA-TR*               ,STRIP(WEB_IMAGE_FILE_NM)    AS WEB_IMAGE_FILE_NM         
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,STRIP(REPLACMNT_PROMO_CD)   AS REPLACMNT_PROMO_CD        
MFA-TR*               ,STRIP(DISPLAY_END_DT)       AS DISPLAY_END_DT            
MFA-TR*               ,STRIP(INT_LANDING_PG_URL)   AS INT_LANDING_PG_URL        
MFA-TR*               ,PROMO_VRSN_NO               AS PROMO_VRSN_NO             
MFA-TR*               ,STRIP(PROMO_VSTART_TS)      AS PROMO_VSTART_TS           
MFA-TR*               ,STRIP(PROMO_VEND_TS)        AS PROMO_VEND_TS             
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*           FROM SESSION.CSR04431_R3                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100D-DECLARE-GTT-R4 - CRM_MKT_TIER                            *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE 'SESSION.CSR04431_R4'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04431_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04431_R4
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,TIER_CUST_STAT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_ACCT_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_RANKING        SMALLINT                    
                   ,MKT_TIER_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_OFFER_VIEW         SMALLINT                    
                   ,OFFER_TIER_STRT_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_APPLY_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_DEFLT_OFFR_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_TIER_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,CUST_ACCT_DEFLT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_TIER_VRSN_NO        SMALLINT                    
                   ,OFF_TIER_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_TIER_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                     TO WS-SQLSTATE.            
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS        THRU 8000D-EXIT         
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '0100D'                TO ACTIVE-PARAGRAPH        
                 MOVE SQLCODE                TO ABEND-SQLCODE           
                 MOVE SQLSTATE               TO ABEND-SQLSTATE          
                 MOVE 'DECLARE GTT'          TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                 MOVE WS-GTT-NAME            TO TABLE-1                 
                 MOVE SPACES                 TO TABLE-ELEMENT-1         
                 MOVE SPACES                 TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OFFER_CD))             AS 
           OFFER_CD_KEY      
                      ,LTRIM(RTRIM(TIER_CUST_STAT_CD))    AS 
           TIER_CUST_STAT_CD 
                      ,LTRIM(RTRIM(TIER_ACCT_TYPE_CD))    AS 
           TIER_ACCT_TYPE_CD 
                      ,MKT_TIER_RANKING            AS MKT_TIER_RANKING  
                      ,LTRIM(RTRIM(MKT_TIER_START_DT))    AS 
           MKT_TIER_START_DT 
                      ,LTRIM(RTRIM(MKT_TIER_DESC))        AS 
           MKT_TIER_DESC     
                      ,LTRIM(RTRIM(MKT_TIER_END_DT))      AS 
           MKT_TIER_END_DT   
                      ,TIER_OFFER_VIEW             AS TIER_OFFER_VIEW   
                      ,LTRIM(RTRIM(OFFER_TIER_STRT_DT))   AS 
           OFFER_TIER_STRT_DT
                      ,LTRIM(RTRIM(MKT_TIER_APPLY_CD))    AS 
           MKT_TIER_APPLY_CD 
                      ,LTRIM(RTRIM(TIER_DEFLT_OFFR_CD))   AS 
           TIER_DEFLT_OFFR_CD
                      ,LTRIM(RTRIM(OFFER_TIER_END_DT))    AS 
           OFFER_TIER_END_DT 
                      ,LTRIM(RTRIM(CUST_ACCT_DEFLT_FL))   AS 
           CUST_ACCT_DEFLT_FL
                      ,LTRIM(RTRIM(MKT_TIER_DESC_LONG))   AS 
           MKT_TIER_DESC_LONG
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,OFF_TIER_VRSN_NO            AS OFF_TIER_VRSN_NO  
                      ,LTRIM(RTRIM(OFF_TIER_VSTART_TS))   AS 
           OFF_TIER_VSTART_TS
                      ,LTRIM(RTRIM(OFF_TIER_VEND_TS))     AS 
           OFF_TIER_VEND_TS  
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
                  FROM #CSR04431_R4                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD_KEY              
MFA-TR*               ,STRIP(TIER_CUST_STAT_CD)    AS TIER_CUST_STAT_CD         
MFA-TR*               ,STRIP(TIER_ACCT_TYPE_CD)    AS TIER_ACCT_TYPE_CD         
MFA-TR*               ,MKT_TIER_RANKING            AS MKT_TIER_RANKING          
MFA-TR*               ,STRIP(MKT_TIER_START_DT)    AS MKT_TIER_START_DT         
MFA-TR*               ,STRIP(MKT_TIER_DESC)        AS MKT_TIER_DESC             
MFA-TR*               ,STRIP(MKT_TIER_END_DT)      AS MKT_TIER_END_DT           
MFA-TR*               ,TIER_OFFER_VIEW             AS TIER_OFFER_VIEW           
MFA-TR*               ,STRIP(OFFER_TIER_STRT_DT)   AS OFFER_TIER_STRT_DT        
MFA-TR*               ,STRIP(MKT_TIER_APPLY_CD)    AS MKT_TIER_APPLY_CD         
MFA-TR*               ,STRIP(TIER_DEFLT_OFFR_CD)   AS TIER_DEFLT_OFFR_CD        
MFA-TR*               ,STRIP(OFFER_TIER_END_DT)    AS OFFER_TIER_END_DT         
MFA-TR*               ,STRIP(CUST_ACCT_DEFLT_FL)   AS CUST_ACCT_DEFLT_FL        
MFA-TR*               ,STRIP(MKT_TIER_DESC_LONG)   AS MKT_TIER_DESC_LONG        
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,OFF_TIER_VRSN_NO            AS OFF_TIER_VRSN_NO          
MFA-TR*               ,STRIP(OFF_TIER_VSTART_TS)   AS OFF_TIER_VSTART_TS        
MFA-TR*               ,STRIP(OFF_TIER_VEND_TS)     AS OFF_TIER_VEND_TS          
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*           FROM SESSION.CSR04431_R4                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100E-DECLARE-GTT-R5  -  CRM_OPT_ATTR_INCTV                    *        
      ******************************************************************        
       0100E-DECLARE-GTT-R5.                                            
                                                                        
           MOVE 'SESSION.CSR04431_R5'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04431_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04431_R5
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,ATTR_INCTV_SEQ_NO       SMALLINT                    
                   ,RT_ATTR_INCTV_TYPE CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PRIMRY_OPT_ATTR_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,DURATION_NO             SMALLINT                    
                   ,APPL_PROGRAM_ID CHAR(09)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ATTR_INCTV_VALUE        DECIMAL(11,6)               
                   ,ATTR_INCTV_VAL_TX CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,GL_ACCT_CREDIT          DECIMAL(7,4)                
                   ,GL_ACCT_DEBIT           DECIMAL(7,4)                
                   ,CATEGORY_ID             SMALLINT                    
                   ,WQ_ROUTE_CATEGORY CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_CHG_ACTION_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ATTR_INCTV_STRT_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ATTR_INCTV_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_ATTR_VRSN_NO        SMALLINT                    
                   ,OPT_ATTR_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_ATTR_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS    THRU 8000E-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100E'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD         
                      ,ATTR_INCTV_SEQ_NO           AS ATTR_INCTV_SEQ_NO 
                      ,LTRIM(RTRIM(RT_ATTR_INCTV_TYPE))   AS 
           RT_ATTR_INCTV_TYPE
                      ,LTRIM(RTRIM(PRIMRY_OPT_ATTR_FL))   AS 
           PRIMRY_OPT_ATTR_FL
                      ,LTRIM(RTRIM(FACTOR_ID))            AS FACTOR_ID         
                      ,DURATION_NO                 AS DURATION_NO       
                      ,LTRIM(RTRIM(APPL_PROGRAM_ID))      AS 
           APPL_PROGRAM_ID   
                      ,ATTR_INCTV_VALUE            AS ATTR_INCTV_VALUE  
                      ,LTRIM(RTRIM(ATTR_INCTV_VAL_TX))    AS 
           ATTR_INCTV_VAL_TX 
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,GL_ACCT_CREDIT              AS GL_ACCT_CREDIT    
                      ,GL_ACCT_DEBIT               AS GL_ACCT_DEBIT     
                      ,CATEGORY_ID                 AS CATEGORY_ID       
                      ,LTRIM(RTRIM(WQ_ROUTE_CATEGORY))    AS 
           WQ_ROUTE_CATEGORY 
                      ,LTRIM(RTRIM(OPT_CHG_ACTION_CD))    AS 
           OPT_CHG_ACTION_CD 
                      ,LTRIM(RTRIM(ATTR_INCTV_STRT_DT))   AS 
           ATTR_INCTV_STRT_DT
                      ,LTRIM(RTRIM(ATTR_INCTV_END_DT))    AS 
           ATTR_INCTV_END_DT 
                      ,OPT_ATTR_VRSN_NO            AS OPT_ATTR_VRSN_NO  
                      ,LTRIM(RTRIM(OPT_ATTR_VSTART_TS))   AS 
           OPT_ATTR_VSTART_TS
                      ,LTRIM(RTRIM(OPT_ATTR_VEND_TS))     AS 
           OPT_ATTR_VEND_TS  
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
                 FROM #CSR04431_R5                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OPTION_CD)            AS OPTION_CD                 
MFA-TR*               ,ATTR_INCTV_SEQ_NO           AS ATTR_INCTV_SEQ_NO         
MFA-TR*               ,STRIP(RT_ATTR_INCTV_TYPE)   AS RT_ATTR_INCTV_TYPE        
MFA-TR*               ,STRIP(PRIMRY_OPT_ATTR_FL)   AS PRIMRY_OPT_ATTR_FL        
MFA-TR*               ,STRIP(FACTOR_ID)            AS FACTOR_ID                 
MFA-TR*               ,DURATION_NO                 AS DURATION_NO               
MFA-TR*               ,STRIP(APPL_PROGRAM_ID)      AS APPL_PROGRAM_ID           
MFA-TR*               ,ATTR_INCTV_VALUE            AS ATTR_INCTV_VALUE          
MFA-TR*               ,STRIP(ATTR_INCTV_VAL_TX)    AS ATTR_INCTV_VAL_TX         
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,GL_ACCT_CREDIT              AS GL_ACCT_CREDIT            
MFA-TR*               ,GL_ACCT_DEBIT               AS GL_ACCT_DEBIT             
MFA-TR*               ,CATEGORY_ID                 AS CATEGORY_ID               
MFA-TR*               ,STRIP(WQ_ROUTE_CATEGORY)    AS WQ_ROUTE_CATEGORY         
MFA-TR*               ,STRIP(OPT_CHG_ACTION_CD)    AS OPT_CHG_ACTION_CD         
MFA-TR*               ,STRIP(ATTR_INCTV_STRT_DT)   AS ATTR_INCTV_STRT_DT        
MFA-TR*               ,STRIP(ATTR_INCTV_END_DT)    AS ATTR_INCTV_END_DT         
MFA-TR*               ,OPT_ATTR_VRSN_NO            AS OPT_ATTR_VRSN_NO          
MFA-TR*               ,STRIP(OPT_ATTR_VSTART_TS)   AS OPT_ATTR_VSTART_TS        
MFA-TR*               ,STRIP(OPT_ATTR_VEND_TS)     AS OPT_ATTR_VEND_TS          
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*          FROM SESSION.CSR04431_R5                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100F-DECLARE-GTT-R6  -  CRM_OFFER_OPTION                      *        
      ******************************************************************        
       0100F-DECLARE-GTT-R6.                                            
                                                                        
           MOVE 'SESSION.CSR04431_R6'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04431_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04431_R6
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OPTION_SORT_SEQ_NO      SMALLINT                    
                   ,OFFER_OPT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_OPT_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_OPT_VRSN_NO         SMALLINT                    
                   ,OFF_OPT_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_OPT_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
A04805             ,WEB_NEW_EXISTS_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
A04805             ,WEB_SIGN_UP_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
A04805             ,OFF_OPT_EXCLUDE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000F-DEL-GTT-ROWS    THRU 8000E-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100F'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C6 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD          
                      ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD         
                      ,OPTION_SORT_SEQ_NO          AS OPTION_SORT_SEQ_NO
                      ,LTRIM(RTRIM(OFFER_OPT_START_DT))   AS 
           OFFER_OPT_START_DT
                      ,LTRIM(RTRIM(OFFER_OPT_END_DT))     AS 
           OFFER_OPT_END_DT  
                      ,OFF_OPT_VRSN_NO             AS OFF_OPT_VRSN_NO   
                      ,LTRIM(RTRIM(OFF_OPT_VSTART_TS))    AS 
           OFF_OPT_VSTART_TS 
                      ,LTRIM(RTRIM(OFF_OPT_VEND_TS))      AS 
           OFF_OPT_VEND_TS   
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
A04805                ,LTRIM(RTRIM(WEB_NEW_EXISTS_CD))    AS 
           WEB_NEW_EXISTS_CD 
A04805                ,LTRIM(RTRIM(WEB_SIGN_UP_FL))       AS 
           WEB_SIGN_UP_FL    
A04805                ,LTRIM(RTRIM(OFF_OPT_EXCLUDE_CD))   AS 
           OFF_OPT_EXCLUDE_CD
                 FROM #CSR04431_R6                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD                  
MFA-TR*               ,STRIP(OPTION_CD)            AS OPTION_CD                 
MFA-TR*               ,OPTION_SORT_SEQ_NO          AS OPTION_SORT_SEQ_NO        
MFA-TR*               ,STRIP(OFFER_OPT_START_DT)   AS OFFER_OPT_START_DT        
MFA-TR*               ,STRIP(OFFER_OPT_END_DT)     AS OFFER_OPT_END_DT          
MFA-TR*               ,OFF_OPT_VRSN_NO             AS OFF_OPT_VRSN_NO           
MFA-TR*               ,STRIP(OFF_OPT_VSTART_TS)    AS OFF_OPT_VSTART_TS         
MFA-TR*               ,STRIP(OFF_OPT_VEND_TS)      AS OFF_OPT_VEND_TS           
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*               ,STRIP(WEB_NEW_EXISTS_CD)    AS WEB_NEW_EXISTS_CD         
MFA-TR*               ,STRIP(WEB_SIGN_UP_FL)       AS WEB_SIGN_UP_FL            
MFA-TR*               ,STRIP(OFF_OPT_EXCLUDE_CD)   AS OFF_OPT_EXCLUDE_CD        
MFA-TR*          FROM SESSION.CSR04431_R6                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100F-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-VALIDATE-INPUT          THRU 1100-EXIT.         
                                                                        
           MOVE I-SEARCH-CRITERIA            TO WS-SEARCH-CRITERIA.     
           MOVE I-WILDCARD-FLAG              TO WS-WILDCARD-FLAG.       
           MOVE I-ACTV-PRD-FLAG              TO WS-ACTV-PRD-FLAG.       
           MOVE I-CHK-START-TS               TO WS-CHK-VSTART-TS.       
           MOVE WS-CHK-VSTART-TS(1:10)       TO WS-CHK-START-DT.        
           MOVE I-CHK-END-TS                 TO WS-CHK-VEND-TS.         
           MOVE WS-CHK-VEND-TS(1:10)         TO WS-CHK-END-DT.          
           MOVE I-PROC-STATUS-FLAG           TO WS-PROC-STATUS-FLAG.    
           MOVE I-PROC-STATUS                TO WS-PROC-STATUS-CD.      
           MOVE I-VRSN-TS-FLAG               TO WS-VRSN-TS-FLAG.        
           MOVE I-ACCOUNT-TYPE-CD            TO WS-TIER-ACCT-TYPE-CD.   
           MOVE I-CUSTOMER-TYPE-CD           TO WS-TIER-CUST-STAT-CD.   
           MOVE I-MKT-TIER-RANKING           TO WS-MKT-TIER-RANKING.    
           MOVE I-RESOURCE-ID                TO WS-RPM-WIZARDS-SW.      
                                                                        
           IF WS-WILDCARD-FLAG = 'Y'                                    
              MOVE I-SEARCH-CRITERIA         TO WS-FRMT-SRCH-STRNG      
              MOVE FUNCTION REVERSE(WS-FRMT-SRCH-STRNG)                 
                                             TO WS-FRMT-SRCH-STRNG      
              INSPECT WS-FRMT-SRCH-STRNG REPLACING LEADING SPACES BY '%'
              MOVE FUNCTION REVERSE(WS-FRMT-SRCH-STRNG)                 
                                             TO WS-FRMT-SRCH-STRNG      
              MOVE WS-FRMT-SRCH-TXT TO WS-SEARCH-CRITERIA               
           END-IF.                                                      
                                                                        
           IF RPM012-GLOBAL-SEARCH                                      
              MOVE 'N'                       TO WS-ACTIVE-ONLY          
           ELSE                                                         
              MOVE 'Y'                       TO WS-ACTIVE-ONLY          
           END-IF.                                                      
                                                                        
           MOVE I-COMPANY-NO                 TO FG-COMPANY-NO           
                                                FI-COMPANY-NO           
                                                E9-COMPANY-NO           
                                                KM-COMPANY-NO           
                                                HQ-COMPANY-NO           
                                                DU-COMPANY-NO.          
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1         THRU 0100A-EXIT.        
           PERFORM 0100B-DECLARE-GTT-R2         THRU 0100B-EXIT.        
           PERFORM 0100C-DECLARE-GTT-R3         THRU 0100C-EXIT.        
           PERFORM 0100D-DECLARE-GTT-R4         THRU 0100D-EXIT.        
           PERFORM 0100E-DECLARE-GTT-R5         THRU 0100E-EXIT.        
           PERFORM 0100F-DECLARE-GTT-R6         THRU 0100F-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 1100-VALIDATE-INPUT.                                          *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF I-SEARCH-METHOD  > SPACES                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SPACES                    TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
      *************************************************************             
      *    SEARCH METHOD INVALID                                  *             
      *************************************************************             
              MOVE +0                        TO WS-ACTIVE-RETURN-CODE   
              MOVE +1000                     TO WS-APPL-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
      *                                                                         
           IF I-SEARCH-CRITERIA > SPACES OR                             
             (I-SEARCH-CRITERIA = SPACES AND I-WILDCARD-FLAG = 'N' )    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'RECEIVE INPUT'           TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE SPACES                    TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
      *************************************************************             
      *    SEARCH CRITIRIA INVALID                                *             
      *************************************************************             
              MOVE +0                        TO WS-ACTIVE-RETURN-CODE   
              MOVE +1010                     TO WS-APPL-RETURN-CODE     
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7105-ACCEPT-TIMESTAMP    THRU 7105-EXIT.             
                                                                        
           EVALUATE TRUE                                                
               WHEN I-SEARCH-METHOD      = 'OPTN'                       
                    PERFORM 2010-PROCESS-OPTION-CD   THRU 2010-EXIT     
                                                                        
               WHEN I-SEARCH-METHOD      = 'OFFER'                      
                    PERFORM 2020-PROCESS-OFFER-CD    THRU 2020-EXIT     
                                                                        
               WHEN I-SEARCH-METHOD      = 'PROMO'                      
                    PERFORM 2030-PROCESS-PROMO-CD    THRU 2030-EXIT     
                                                                        
               WHEN I-SEARCH-METHOD      = 'TIER'                       
                    PERFORM 2040-PROCESS-MKT-TIER-CD THRU 2040-EXIT     
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2010-PROCESS-OPTION-CD.    SEARCH METHOD - 'OPTION'            *        
      *                                                                *        
      * GLOBAL SEARCH - RETRIEVE OPTION/OFFER/ATTRIBUTE DETAILS IRRESPE*        
      *                -CTIVE OF DATE & STATUS & VERSION               *        
      * MODIFY OPTION - RETRIEVE ACTIVE & FUTURE DATED OPTION ALONG    *        
      *    SEARCH       WITH ASSOCIATED OFFER DETAILS                  *        
      * CREATE/MODIFY - RETRIEVE ACTIVE & FUTURE DATED OPTION ALONG    *        
      *  ACTIVE OPTN    WITH ASSOCIATED OFFER DETAILS                  *        
      *    SEARCH                                                      *        
      *                                                                *        
      * PROCESS FLOW:                                                  *        
      * 1. WITH THE SEARCH PARAMETER FETCH THE OPTION DETAILS          *        
      *    OPTION DETAILS - OPTION_DRIVE_CUR                           *        
      * 2. WITH RETRIVED OPTION DETAILS FETCH ATTRIBUTE INCENTIVES &   *        
      *    OFFER-OPTION DETAILS                                        *        
      *    ATTRIBUTE DETAILS - ATTR_INCEN_CUR                          *        
      *    OFFER-OPTION DETAILS - OFFER_OPTION_CUR                     *        
      * 3. WITH THE OFFER-OPTION DETAILS FETCH OFFER DETAILS           *        
      *    OFFER DETAILS - OFFER_CD_CUR                                *        
      ******************************************************************        
       2010-PROCESS-OPTION-CD.                                          
                                                                        
           PERFORM 7110-OPEN-OPTION-CD-CUR     THRU 7110-EXIT.          
           PERFORM 7120-FETCH-OPTION-CD-CUR    THRU 7120-EXIT.          
           PERFORM 2100-PROCESS-SEARCH-OPTION  THRU 2100-EXIT           
                                               UNTIL NO-MORE-ROWS.      
           PERFORM 7130-CLOSE-OPTION-CD-CUR    THRU 7130-EXIT.          
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2020-PROCESS-OFFER-CD.     SEARCH METHOD - 'OFFER'             *        
      *                                                                *        
      * GLOBAL SEARCH - RETRIEVE OFFER/OPTION/TIER DETAILS IRRESPECTIVE*        
      *                 OF DATE, STATUS & VERSION                      *        
      * MODIFY OFFER  - RETRIEVE ACTIVE & FUTURE DATED OFFER DETAILS   *        
      *    SEARCH                                                      *        
      * TEMPLATE OFF  - RETRIEVE ACTIVE & FUTURE DATED OFFER DETAILS   *        
      *    SEARCH                                                      *        
      * CREATE/MODIFY - RETRIEVE ACTIVE & FUTURE DATED OPTION ALONG    *        
      *  ACTIVE OPTN    WITH ASSOCIATED OFFER DETAILS                  *        
      *    SEARCH                                                      *        
      *                                                                *        
      * PROCESS FLOW:                                                  *        
      * 1. WITH THE SEARCH PARAMETER FETCH THE OFFER DETAILS           *        
      *    OFFER  DETAILS - OFFER_DRIVE_CUR                            *        
      * 2. WITH RETRIVED OFFER DETAILS FETCH OFF-MKT-TIER, PROMOTION & *        
      *    OFFER-OPTION DETAILS                                        *        
      *    OFFER MKT DETAILS - OFF_MKT_TIER_CUR                        *        
      *    PROMOTION DETAILS - OFFER_PROMO_CUR                         *        
      *    OFFER-OPTION DETAILS - OFFER_OPTION_CUR2                    *        
      * 3. WITH THE OFFER-OPTION DETAILS FETCH OPTION DETAILS          *        
      *    OPTION DETAILS - OPTION_CD_CUR                              *        
      ******************************************************************        
       2020-PROCESS-OFFER-CD.                                           
                                                                        
           PERFORM 7140-OPEN-OFFER-CD-CUR      THRU 7140-EXIT.          
           PERFORM 7150-FETCH-OFFER-CD-CUR     THRU 7150-EXIT.          
           PERFORM 2200-PROCESS-SEARCH-OFFER   THRU 2200-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7160-CLOSE-OFFER-CD-CUR     THRU 7160-EXIT.          
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2030-PROCESS-PROMO-CD  -  SEARCH METHOD - 'PROMO'             *         
      *                                                                *        
      * GLOBAL SEARCH - RETRIEVE PROMO/OFFER/TIER DETAILS IRRESPECTIVE *        
      *                 OF DATE, STATUS & VERSION                      *        
      * CREATE/MODIFY - RETRIEVE ACTIVE & FUTURE DATED OPTION ALONG    *        
      *  ACTIVE OPTN    WITH PROMOTION DETAILS                         *        
      *    SEARCH                                                      *        
      *                                                                *        
      * PROCESS FLOW:                                                  *        
      * 1. WITH THE SEARCH PARAMETER FETCH THE PROMOTION DETAILS       *        
      *    PROMO  DETAILS - PROMO_DRIVE_CUR                            *        
      * 2. WITH RETRIVED PROMO DETAILS FETCH OFF-MKT-TIER & OFFER-OPTN *        
      *    DETAILS                                                     *        
      *    OFFER MKT DETAILS - OFF_MKT_TIER_CUR                        *        
      *    OFFER-OPTION DETAILS - OFFER_OPTION_CUR2                    *        
      * 3. WITH THE OFFER-OPTION DETAILS FETCH OPTION DETAILS          *        
      *    OPTION DETAILS - OPTION_CD_CUR                              *        
      ******************************************************************        
       2030-PROCESS-PROMO-CD.                                           
                                                                        
           PERFORM 7170-OPEN-PROMO-CD-CUR      THRU 7170-EXIT.          
           PERFORM 7180-FETCH-PROMO-CD-CUR     THRU 7180-EXIT.          
           PERFORM 2300-PROCESS-SEARCH-PROMO   THRU 2300-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7190-CLOSE-PROMO-CD-CUR     THRU 7190-EXIT.          
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2040-PROCESS-MKT-TIER-CD  SEARCH METHOD - 'TIER'              *         
      *                                                                *        
      * GLOBAL SEARCH - RETRIEVE TIER/OFFER/OPTION DETAILS IRRESPECTIVE*        
      *                 OF DATE, STATUS & VERSION                      *        
      *                                                                *        
      * PROCESS FLOW:                                                  *        
      * 1. WITH THE SEARCH PARAMETER FETCH THE MARKET TIER & OFFER-MKT-*        
      *    TIER DETAILS                                                *        
      *    MKT-TIER / OFF-MKT-TIER DETAILS - MKT_TIER_DRIVE_CUR        *        
      * 2. WITH RETRIVED OFF-MKT-TIER DETAILS FETCH OFFER DETAILS      *        
      *    OFFER DETAILS - OFFER_CD_CUR                                *        
      * 3. WITH THE OFFER DETAILS FETCH OFFER-OPTION DETAILS           *        
      *    OFFER-OPTION DETAILS - OFFER_OPTION_CUR2                    *        
      * 4. WITH THE OFFER-OPTION DETAILS FETCH OPTION DETAILS          *        
      *    OPTION DETAILS - OPTION_CD_CUR                              *        
      ******************************************************************        
       2040-PROCESS-MKT-TIER-CD.                                        
                                                                        
           PERFORM 7290-OPEN-MKT-TIER-CUR      THRU 7290-EXIT.          
           PERFORM 7300-FETCH-MKT-TIER-CUR     THRU 7300-EXIT.          
           PERFORM 2400-PROCESS-SEARCH-TIER    THRU 2400-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7310-CLOSE-MKT-TIER-CUR     THRU 7310-EXIT.          
                                                                        
       2040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETTING OPTION / OFFER / ATTR INCTV DETAILS BASED ON THE       *        
      * SEARCHED OPTION CD.                                            *        
      ******************************************************************        
       2100-PROCESS-SEARCH-OPTION.                                      
                                                                        
           INITIALIZE      WS-OFFER-CD-KEY                              
           MOVE FI-OPT-VSTART-TS             TO WS-VERSION-START-TS     
           MOVE FI-OPT-VEND-TS               TO WS-VERSION-END-TS       
           MOVE FI-OPTION-START-DT           TO WS-ACTIVE-START-DT      
           MOVE FI-OPTION-END-DT             TO WS-ACTIVE-END-DT        
                                                                        
      **************************************************************            
      *    GETTING ATTRIBUTE INCENTIVE DETAILS BASED ON OPTION CD  *            
      **************************************************************            
           INITIALIZE    WS-NO-MORE-ATTR-INC-ROWS                       
           MOVE FI-OPTION-CD                  TO HQ-OPTION-CD           
                                                                        
           PERFORM 7200-OPEN-ATTR-INCEN-CUR      THRU 7200-EXIT         
           PERFORM 7210-FETCH-ATTR-INCEN-CUR     THRU 7210-EXIT         
           PERFORM 2330-MOVE-ATTR-INCEN-RS5      THRU 2330-EXIT         
                                                UNTIL NO-MORE-ATTR-ROWS 
           PERFORM 7220-CLOSE-ATTR-INCEN-CUR     THRU 7220-EXIT.        
                                                                        
      **************************************************************            
      *    GETTING OFFER DETAILS BASED ON OPTION CD                *            
      **************************************************************            
           INITIALIZE    WS-NO-MORE-OFF-OPT-ROWS                        
           MOVE 'N'                           TO WS-STATUS-FOR-OPTION   
           MOVE FI-OPTION-CD                  TO E9-OPTION-CD.          
                                                                        
           PERFORM 7230-OPEN-OFF-OPT-FOR-OPTION  THRU 7230-EXIT.        
           PERFORM 7240-FETCH-OFF-OPT-FOR-OPTION THRU 7240-EXIT.        
           PERFORM 2350-GET-OFFER-DET-FOR-OPTION THRU 2350-EXIT         
                                         UNTIL NO-MORE-OFF-OPT-ROWS.    
           PERFORM 7250-CLOSE-OFF-OPT-FOR-OPTION THRU 7250-EXIT.        
                                                                        
      ***************************************************************           
      *    MOVING OPTION DETAILS BASED ON OPTION CD                 *           
      ***************************************************************           
           IF ROW-FOUND-FOR-OPTION                                      
              PERFORM 2315-MOVE-OPTION-RS2       THRU 2315-EXIT         
           END-IF.                                                      
                                                                        
                                                                        
           PERFORM 7120-FETCH-OPTION-CD-CUR      THRU 7120-EXIT.        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * GETTING OFFER / MKT TIER  / OPTION / ATTR INCTV DETAILS      *          
      * BASEB ON THE SEARCHED OFFER CODE.                            *          
      ****************************************************************          
       2200-PROCESS-SEARCH-OFFER.                                       
                                                                        
           INITIALIZE  WS-OFFER-KEYS                                    
           MOVE FG-OFF-VSTART-TS             TO WS-VERSION-START-TS     
           MOVE FG-OFF-VEND-TS               TO WS-VERSION-END-TS       
           MOVE FG-OFFER-START-DT            TO WS-ACTIVE-START-DT      
           MOVE FG-OFFER-END-DT              TO WS-ACTIVE-END-DT        
                                                                        
      ****************************************************************          
      *    GETTING OFFER DETAILS BASED ON OFFER CD                   *          
      ****************************************************************          
                                                                        
      *    IF ROW-FOUND-FOR-OFFER                                               
           PERFORM 2310-MOVE-OFFER-RS1       THRU 2310-EXIT             
                                                                        
      ****************************************************************          
      *    GETTING MKT TIER DETAILS BASED ON OFFER CODE              *          
      ****************************************************************          
           INITIALIZE    WS-NO-MORE-TIER-ROWS                           
           MOVE FG-OFFER-CD                  TO DU-OFFER-CD             
                                                                        
           PERFORM 7320-OPEN-OFF-MKT-TIER       THRU 7320-EXIT          
           PERFORM 7330-FETCH-OFF-MKT-TIER      THRU 7330-EXIT          
           PERFORM 2360-PROCESS-MKT-TIER        THRU 2360-EXIT          
                                                UNTIL NO-MORE-TIER-ROWS 
           PERFORM 7340-CLOSE-OFF-MKT-TIER      THRU 7340-EXIT.         
                                                                        
      ****************************************************************          
      *    GETTING PROMO DETAILS BASED ON THE OFFER CODE             *          
      ****************************************************************          
           INITIALIZE    WS-NO-MORE-PROMO-ROWS                          
           MOVE FG-OFFER-CD                  TO KM-OFFER-CD             
                                                                        
           PERFORM 7350-OPEN-OFFER-PROMO-CUR    THRU 7350-EXIT          
           PERFORM 7360-FETCH-OFFER-PROMO-CUR   THRU 7360-EXIT          
           PERFORM 2390-PROCESS-FOR-OFFER-PROMO THRU 2390-EXIT          
                                                UNTIL NO-MORE-PROMO-ROWS
           PERFORM 7370-CLOSE-OFFER-PROMO-CUR   THRU 7370-EXIT.         
                                                                        
      ****************************************************************          
      *    GETTING OPTION DETAILS BASED ON OFFER CD                  *          
      ****************************************************************          
           INITIALIZE    WS-NO-MORE-OFF-OPT-ROWS.                       
           MOVE 'N'                          TO WS-STATUS-FOR-OFFER     
           MOVE FG-OFFER-CD                  TO E9-OFFER-CD.            
                                                                        
           PERFORM 7260-OPEN-OFF-OPT-FOR-OFFER  THRU 7260-EXIT.         
           PERFORM 7270-FETCH-OFF-OPT-FOR-OFFER THRU 7270-EXIT.         
           PERFORM 2340-GET-OPT-DET-FOR-OFF     THRU 2340-EXIT          
                                          UNTIL NO-MORE-OFF-OPT-ROWS.   
           PERFORM 7280-CLOSE-OFF-OPT-FOR-OFFER THRU 7280-EXIT.         
                                                                        
           PERFORM 7150-FETCH-OFFER-CD-CUR      THRU 7150-EXIT.         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETTING PROMO / OFFER / OPTION / ATTRINCTV / MKT TIER /        *        
      * OFF OPT DETAILS BASEB ON THE SEARCHED PROMO CD                 *        
      ******************************************************************        
       2300-PROCESS-SEARCH-PROMO.                                       
                                                                        
           MOVE KM-PROMO-VSTART-TS           TO WS-VERSION-START-TS     
           MOVE KM-PROMO-VEND-TS             TO WS-VERSION-END-TS       
           MOVE KM-PROMO-START-DT            TO WS-ACTIVE-START-DT      
           MOVE KM-PROMO-END-DT              TO WS-ACTIVE-END-DT        
                                                                        
      ****************************************************************          
      *    GETTING OFFER DETAILS BASED ON OFFER CD                   *          
      ****************************************************************          
           INITIALIZE    WS-OFFER-KEYS.                                 
           MOVE 'N'                          TO WS-NO-MORE-OFFER-ROWS   
                                                WS-STATUS-FOR-OFFER.    
           MOVE KM-PROMO-CD                  TO WS-PROMO-CD-KEY         
           MOVE KM-OFFER-CD                  TO FG-OFFER-CD.            
           PERFORM 7000-OPEN-OFFER-CD-CUR       THRU 7000-EXIT.         
           PERFORM 7001-FETCH-OFFER-CD-CUR      THRU 7001-EXIT.         
           PERFORM 2380-PROCESS-FOR-OFFER       THRU 2380-EXIT          
                                                UNTIL NO-MORE-OFFER-ROWS
           PERFORM 7002-CLOSE-OFFER-CD-CUR      THRU 7002-EXIT.         
                                                                        
      ****************************************************************          
      *    GETTING PROMOTION DETAILS BASED ON PROMO CD               *          
      ****************************************************************          
           IF ROW-FOUND-FOR-OFFER                                       
              PERFORM 2320-MOVE-PROMO-RS3          THRU 2320-EXIT       
           END-IF.                                                      
                                                                        
      ****************************************************************          
      *    GETTING OPTION DETAILS BASED ON OFFER CD                  *          
      ****************************************************************          
           INITIALIZE    WS-NO-MORE-OFF-OPT-ROWS.                       
           MOVE 'N'                          TO WS-STATUS-FOR-OFFER     
           MOVE FG-OFFER-CD                  TO E9-OFFER-CD.            
                                                                        
           MOVE FG-OFF-VSTART-TS             TO WS-VERSION-START-TS     
           MOVE FG-OFF-VEND-TS               TO WS-VERSION-END-TS       
           MOVE FG-OFFER-START-DT            TO WS-ACTIVE-START-DT      
           MOVE FG-OFFER-END-DT              TO WS-ACTIVE-END-DT        
                                                                        
      ****************************************************************          
      *    GETTING MKT TIER DETAILS BASED ON OFFER CODE              *          
      ****************************************************************          
           INITIALIZE    WS-NO-MORE-TIER-ROWS                           
           MOVE FG-OFFER-CD                  TO DU-OFFER-CD             
                                                                        
           PERFORM 7320-OPEN-OFF-MKT-TIER       THRU 7320-EXIT          
           PERFORM 7330-FETCH-OFF-MKT-TIER      THRU 7330-EXIT          
           PERFORM 2360-PROCESS-MKT-TIER        THRU 2360-EXIT          
                                                UNTIL NO-MORE-TIER-ROWS 
           PERFORM 7340-CLOSE-OFF-MKT-TIER      THRU 7340-EXIT.         
                                                                        
           PERFORM 7260-OPEN-OFF-OPT-FOR-OFFER  THRU 7260-EXIT.         
           PERFORM 7270-FETCH-OFF-OPT-FOR-OFFER THRU 7270-EXIT.         
           PERFORM 2340-GET-OPT-DET-FOR-OFF     THRU 2340-EXIT          
                                          UNTIL NO-MORE-OFF-OPT-ROWS.   
           PERFORM 7280-CLOSE-OFF-OPT-FOR-OFFER THRU 7280-EXIT.         
                                                                        
      *                                                                         
           PERFORM 7180-FETCH-PROMO-CD-CUR      THRU 7180-EXIT.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  GETTING OFFER DETAILS BASEB ON THE MKT RANKING CODE           *        
      ******************************************************************        
       2400-PROCESS-SEARCH-TIER.                                        
                                                                        
           MOVE DU-OFF-TIER-VSTART-TS        TO WS-VERSION-START-TS     
           MOVE DU-OFF-TIER-VEND-TS          TO WS-VERSION-END-TS       
           MOVE DU-OFFER-TIER-STRT-DT        TO WS-ACTIVE-START-DT      
           MOVE DU-OFFER-TIER-END-DT         TO WS-ACTIVE-END-DT        
                                                                        
      ****************************************************************          
      *    GETTING OFFER DETAILS BASED ON OFFER CD                   *          
      ****************************************************************          
           INITIALIZE WS-OFFER-KEYS                                     
           MOVE 'N'                          TO WS-NO-MORE-OFFER-ROWS   
           MOVE DU-TIER-CUST-STAT-CD         TO WS-TIER-CUST-STAT-CD-KEY
           MOVE DU-TIER-ACCT-TYPE-CD         TO WS-TIER-ACCT-TYPE-CD-KEY
           MOVE DU-MKT-TIER-RANKING          TO WS-MKT-TIER-RANKING-KEY.
           MOVE DU-MKT-TIER-START-DT         TO WS-MKT-TIER-START-DT-KEY
           MOVE DU-OFFER-CD                  TO FG-OFFER-CD.            
                                                                        
           PERFORM 7000-OPEN-OFFER-CD-CUR       THRU 7000-EXIT.         
           PERFORM 7001-FETCH-OFFER-CD-CUR      THRU 7001-EXIT.         
           PERFORM 2380-PROCESS-FOR-OFFER       THRU 2380-EXIT          
                                                UNTIL NO-MORE-OFFER-ROWS
           PERFORM 7002-CLOSE-OFFER-CD-CUR      THRU 7002-EXIT.         
                                                                        
      ****************************************************************          
      *    GETTING MKT TIER DETAILS BASED ON MKT TIER DESCRIPTION    *          
      ****************************************************************          
                                                                        
           IF ROW-FOUND-FOR-OFFER                                       
              PERFORM 2325-MOVE-MKT-TIERO-RS4      THRU 2325-EXIT       
           END-IF.                                                      
                                                                        
      ****************************************************************          
      *    GETTING OPTION DETAILS BASED ON OFFER CD                  *          
      ****************************************************************          
           INITIALIZE  WS-NO-MORE-OFF-OPT-ROWS.                         
           MOVE FG-OFFER-CD                  TO E9-OFFER-CD             
           MOVE FG-OFF-VSTART-TS             TO WS-VERSION-START-TS     
           MOVE FG-OFF-VEND-TS               TO WS-VERSION-END-TS       
           MOVE FG-OFFER-START-DT            TO WS-ACTIVE-START-DT      
           MOVE FG-OFFER-END-DT              TO WS-ACTIVE-END-DT        
                                                                        
           PERFORM 7260-OPEN-OFF-OPT-FOR-OFFER  THRU 7260-EXIT          
           PERFORM 7270-FETCH-OFF-OPT-FOR-OFFER THRU 7270-EXIT          
           PERFORM 2340-GET-OPT-DET-FOR-OFF     THRU 2340-EXIT          
                                          UNTIL NO-MORE-OFF-OPT-ROWS    
           PERFORM 7280-CLOSE-OFF-OPT-FOR-OFFER THRU 7280-EXIT.         
                                                                        
           PERFORM 7300-FETCH-MKT-TIER-CUR     THRU 7300-EXIT.          
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2310-MOVE-OFFER-RS1.  CRM-RT-PKG-OFFER                         *        
      ******************************************************************        
       2310-MOVE-OFFER-RS1.                                             
                                                                        
           MOVE FG-COMPANY-NO               TO S-RS1-COMPANY-NO         
           MOVE FG-OFFER-CD                 TO S-RS1-OFFER-CD           
           MOVE WS-OPTION-CD-KEY            TO S-RS1-OPTION-CD-KEY      
           MOVE WS-PROMO-CD-KEY             TO S-RS1-PROMO-CD-KEY       
           MOVE WS-MKT-TIER-RANKING-KEY     TO S-RS1-MKT-TIER-RANK-KEY  
           MOVE WS-TIER-CUST-STAT-CD-KEY                                
                                         TO S-RS1-TIER-CUST-STAT-CD-KEY 
           MOVE WS-TIER-ACCT-TYPE-CD-KEY                                
                                         TO S-RS1-TIER-ACCT-TYPE-CD-KEY 
           MOVE WS-MKT-TIER-START-DT-KEY    TO S-RS1-MKT-TIER-START-DT  
           MOVE FG-OFFER-DESC-INT           TO S-RS1-OFFER-DESC-INT     
           MOVE FG-OFFER-DESC-EXT           TO S-RS1-OFFER-DESC-EXT     
           MOVE FG-PROMO-CD-INT-FL          TO S-RS1-PROMO-CD-INT-FL    
           MOVE FG-PROMO-CD-EXT-FL          TO S-RS1-PROMO-CD-EXT-FL    
           MOVE FG-OFFER-START-DT           TO S-RS1-OFFER-START-DT     
           MOVE FG-OFFER-END-DT             TO S-RS1-OFFER-END-DT       
           MOVE FG-DISP-START-INT-TS        TO S-RS1-DISP-START-INT-TS  
           MOVE FG-DISP-END-INT-TS          TO S-RS1-DISP-END-INT-TS    
           MOVE FG-DISP-START-EXT-TS        TO S-RS1-DISP-START-EXT-TS  
           MOVE FG-DISP-END-EXT-TS          TO S-RS1-DISP-END-EXT-TS    
           MOVE FG-LAST-UPDATE-TS           TO S-RS1-LAST-UPDATE-TS     
           MOVE FG-LAST-UPDATE-USERID       TO S-RS1-LAST-UPDATE-USERID 
           MOVE FG-OFFER-DESC-INT-LNG       TO S-RS1-OFFER-DESC-INT-LNG 
           MOVE FG-OFFER-DESC-EXT-LNG       TO S-RS1-OFFER-DESC-EXT-LNG 
           MOVE FG-SPCL-OFFER-TYPE-CD       TO S-RS1-SPCL-OFFER-TYPE-CD 
           MOVE FG-RENEWAL-OFFER-CD         TO S-RS1-RENEWAL-OFFER-CD   
           MOVE FG-RENEW-PUB-OFFER-CD       TO S-RS1-RENEW-PUB-OFFER-CD 
           MOVE FG-OFF-VRSN-NO              TO S-RS1-OFF-VRSN-NO        
           MOVE FG-OFF-VSTART-TS            TO S-RS1-OFF-VSTART-TS      
           MOVE FG-OFF-VEND-TS              TO S-RS1-OFF-VEND-TS        
           MOVE FG-PROC-STATUS-CD           TO S-RS1-PROC-STATUS-CD     
           MOVE FG-PROC-REQ-ID              TO S-RS1-PROC-REQ-ID        
PRJ892     MOVE FG-MAX-PRICE-OFFER-CD       TO S-RS1-MAX-PRICE-OFFER-CD 
PRJ892     MOVE FG-RTCHG-PUB-OFFER-CD       TO S-RS1-RTCHG-PUB-OFFER-CD 
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-1.                            
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2314-MOVE-OFF-OPT-FOR-OPT-RS6. CRM_OFFER_OPTION E9             *        
      ******************************************************************        
       2314-MOVE-OFF-OPT-FOR-OPT-RS6.                                   
                                                                        
           INITIALIZE   GTT-RETURN-FIELDS-6                             
                        E9-PROC-REQ-ID.                                 
                                                                        
           MOVE E9-COMPANY-NO               TO S-RS6-COMPANY-NO         
           MOVE E9-OFFER-CD                 TO S-RS6-OFFER-CD           
           MOVE E9-OPTION-CD                TO S-RS6-OPTION-CD          
           MOVE E9-OPTION-SORT-SEQ-NO       TO S-RS6-OPTION-SORT-SEQ-NO 
           MOVE E9-OFFER-OPT-START-DT       TO S-RS6-OFFER-OPT-START-DT 
           MOVE E9-OFFER-OPT-END-DT         TO S-RS6-OFFER-OPT-END-DT   
           MOVE E9-OFF-OPT-VRSN-NO          TO S-RS6-OFF-OPT-VRSN-NO    
           MOVE E9-OFF-OPT-VSTART-TS        TO S-RS6-OFF-OPT-VSTART-TS  
           MOVE E9-OFF-OPT-VEND-TS          TO S-RS6-OFF-OPT-VEND-TS    
           MOVE E9-PROC-STATUS-CD           TO S-RS6-PROC-STATUS-CD     
           MOVE E9-PROC-REQ-ID              TO S-RS6-PROC-REQ-ID.       
A04805     MOVE E9-WEB-NEW-EXISTS-CD        TO S-RS6-WEB-NEW-EXISTS-CD. 
A04805     MOVE E9-WEB-SIGN-UP-FL           TO S-RS6-WEB-SIGN-UP-FL.    
A04805     MOVE E9-OFF-OPT-EXCLUDE-CD       TO S-RS6-OFF-OPT-EXCLUDE-CD.
                                                                        
           PERFORM 8060-INSERT-GTT-R6          THRU 8060-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-6.                            
                                                                        
       2314-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2315-MOVE-OPTION-RS2. CRM-RT-PKG-OPTION                        *        
      ******************************************************************        
       2315-MOVE-OPTION-RS2.                                            
                                                                        
           MOVE FI-COMPANY-NO               TO S-RS2-COMPANY-NO         
           MOVE FI-OPTION-CD                TO S-RS2-OPTION-CD          
           MOVE SPACES                      TO S-RS2-OFFER-CD-KEY       
           MOVE FI-CODE-UTIL-TYPE           TO S-RS2-CODE-UTIL-TYPE     
           MOVE FI-RATE-PLAN-NO             TO S-RS2-RATE-PLAN-NO       
           MOVE FI-OPTION-START-DT          TO S-RS2-OPTION-START-DT    
           MOVE FI-OPTION-END-DT            TO S-RS2-OPTION-END-DT      
           MOVE FI-OPT-DESC-INT             TO S-RS2-OPT-DESC-INT       
           MOVE FI-OPT-DESC-INT-LONG        TO S-RS2-OPT-DESC-INT-LONG  
           MOVE FI-CURR-EXT-DESC-LONG       TO S-RS2-CURR-EXT-DESC-LONG 
           MOVE FI-RENEWAL-DESC-LONG        TO S-RS2-RENEWAL-DESC-LONG  
           MOVE FI-WEB-DESC-LONG            TO S-RS2-WEB-DESC-LONG      
           MOVE FI-STATUS-CD                TO S-RS2-STATUS-CD          
           MOVE FI-LAST-UPDATE-USERID       TO S-RS2-LAST-UPDATE-USERID 
           MOVE FI-LAST-UPDATE-TS           TO S-RS2-LAST-UPDATE-TS     
           MOVE FI-OPT-CALC-TYPE-CD         TO S-RS2-OPT-CALC-TYPE-CD   
           MOVE FI-WEB-MKT-DESC-LONG        TO S-RS2-WEB-MKT-DESC-LONG  
           MOVE FI-OPT-VRSN-NO              TO S-RS2-OPT-VRSN-NO        
           MOVE FI-OPT-VSTART-TS            TO S-RS2-OPT-VSTART-TS      
           MOVE FI-OPT-VEND-TS              TO S-RS2-OPT-VEND-TS        
           MOVE FI-PROC-STATUS-CD           TO S-RS2-PROC-STATUS-CD     
           MOVE FI-PROC-REQ-ID              TO S-RS2-PROC-REQ-ID        
A04805     MOVE FI-OPTION-TYPE-DESC         TO S-RS2-OPTION-TYPE-DESC   
PRJ892     MOVE FI-AUTO-RENEWAL-FL          TO S-RS2-AUTO-RENEWAL-FL    
PRJ892     MOVE FI-OPTION-PROMO-DESC        TO S-RS2-OPTION-PROMO-DESC  
                                                                        
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-2.                            
                                                                        
       2315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2320-MOVE-PROMO-RS3   CRM-MKT-PROMOTION                        *        
      ******************************************************************        
       2320-MOVE-PROMO-RS3.                                             
                                                                        
           MOVE KM-COMPANY-NO               TO S-RS3-COMPANY-NO         
           MOVE KM-PROMO-CD                 TO S-RS3-PROMO-CD           
           MOVE KM-PROMO-DESC               TO S-RS3-PROMO-DESC         
           MOVE KM-OFFER-CD                 TO S-RS3-OFFER-CD           
           MOVE KM-MKT-PLAN-CD              TO S-RS3-MKT-PLAN-CD        
           MOVE KM-PROMO-START-DT           TO S-RS3-PROMO-START-DT     
           MOVE KM-PROMO-START-TM           TO S-RS3-PROMO-START-TM     
           MOVE KM-PROMO-END-DT             TO S-RS3-PROMO-END-DT       
           MOVE KM-PROMO-END-TM             TO S-RS3-PROMO-END-TM       
           MOVE KM-AD-CHANNEL-CD            TO S-RS3-AD-CHANNEL-CD      
           MOVE KM-PROMO-DESC-LONG          TO S-RS3-PROMO-DESC-LONG    
           MOVE KM-EXT-LANDING-PG-URL       TO S-RS3-EXT-LANDING-PG-URL 
           MOVE KM-PROMO-TYPE-CD            TO S-RS3-PROMO-TYPE-CD      
           MOVE KM-WEB-IMAGE-FILE-NM        TO S-RS3-WEB-IMAGE-FILE-NM  
           MOVE KM-LAST-UPDATE-USERID       TO S-RS3-LAST-UPDATE-USERID 
           MOVE KM-LAST-UPDATE-TS           TO S-RS3-LAST-UPDATE-TS     
           MOVE KM-REPLACMNT-PROMO-CD       TO S-RS3-REPLACMNT-PROMO-CD 
           MOVE KM-DISPLAY-END-DT           TO S-RS3-DISPLAY-END-DT     
           MOVE KM-INT-LANDING-PG-URL       TO S-RS3-INT-LANDING-PG-URL 
           MOVE KM-PROMO-VRSN-NO            TO S-RS3-PROMO-VRSN-NO      
           MOVE KM-PROMO-VSTART-TS          TO S-RS3-PROMO-VSTART-TS    
           MOVE KM-PROMO-VEND-TS            TO S-RS3-PROMO-VEND-TS      
           MOVE KM-PROC-STATUS-CD           TO S-RS3-PROC-STATUS-CD     
           MOVE KM-PROC-REQ-ID              TO S-RS3-PROC-REQ-ID        
                                                                        
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-3.                            
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2325-MOVE-MKT-TIERO-RS4.           CRM_MKT_TIER -IG            *        
      ******************************************************************        
       2325-MOVE-MKT-TIERO-RS4.                                         
                                                                        
           MOVE IG-COMPANY-NO               TO S-RS4-COMPANY-NO         
           MOVE DU-OFFER-CD                 TO S-RS4-OFFER-CD           
           MOVE DU-TIER-CUST-STAT-CD        TO S-RS4-TIER-CUST-STAT-CD  
           MOVE DU-TIER-ACCT-TYPE-CD        TO S-RS4-TIER-ACCT-TYPE-CD  
           MOVE DU-MKT-TIER-RANKING         TO S-RS4-MKT-TIER-RANKING   
           MOVE DU-MKT-TIER-START-DT        TO S-RS4-MKT-TIER-START-DT  
           MOVE IG-MKT-TIER-DESC            TO S-RS4-MKT-TIER-DESC      
           MOVE IG-MKT-TIER-END-DT          TO S-RS4-MKT-TIER-END-DT    
           MOVE IG-TIER-OFFER-VIEW          TO S-RS4-TIER-OFFER-VIEW    
           MOVE DU-OFFER-TIER-STRT-DT       TO S-RS4-OFFER-TIER-STRT-DT 
           MOVE DU-MKT-TIER-APPLY-CD        TO S-RS4-MKT-TIER-APPLY-CD  
           MOVE DU-TIER-DEFLT-OFFR-CD       TO S-RS4-TIER-DEFLT-OFFR-CD 
           MOVE DU-OFFER-TIER-END-DT        TO S-RS4-OFFER-TIER-END-DT  
           MOVE IG-CUST-ACCT-DEFLT-FL       TO S-RS4-CUST-ACCT-DEFLT-FL 
           MOVE IG-MKT-TIER-DESC-LONG       TO S-RS4-MKT-TIER-DESC-LONG 
           MOVE DU-LAST-UPDATE-USERID       TO S-RS4-LAST-UPDATE-USERID 
           MOVE DU-LAST-UPDATE-TS           TO S-RS4-LAST-UPDATE-TS     
           MOVE DU-OFF-TIER-VRSN-NO         TO S-RS4-OFF-TIER-VRSN-NO   
           MOVE DU-OFF-TIER-VSTART-TS       TO S-RS4-OFF-TIER-VSTART-TS 
           MOVE DU-OFF-TIER-VEND-TS         TO S-RS4-OFF-TIER-VEND-TS   
           MOVE DU-PROC-STATUS-CD           TO S-RS4-PROC-STATUS-CD     
           MOVE DU-PROC-REQ-ID              TO S-RS4-PROC-REQ-ID        
                                                                        
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
           INITIALIZE   GTT-RETURN-FIELDS-4.                            
                                                                        
       2325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2330-MOVE-ATTR-INCEN-RS5. CRM_OPT_ATTR_INCTV                   *        
      ******************************************************************        
       2330-MOVE-ATTR-INCEN-RS5.                                        
                                                                        
           MOVE HQ-COMPANY-NO               TO S-RS5-COMPANY-NO         
           MOVE HQ-OPTION-CD                TO S-RS5-OPTION-CD          
           MOVE HQ-ATTR-INCTV-SEQ-NO        TO S-RS5-ATTR-INCTV-SEQ-NO  
           MOVE HQ-RT-ATTR-INCTV-TYPE       TO S-RS5-RT-ATTR-INCTV-TYPE 
           MOVE HQ-PRIMRY-OPT-ATTR-FL       TO S-RS5-PRIMRY-OPT-ATTR-FL 
           MOVE HQ-FACTOR-ID                TO S-RS5-FACTOR-ID          
           MOVE HQ-DURATION-NO              TO S-RS5-DURATION-NO        
           MOVE HQ-APPL-PROGRAM-ID          TO S-RS5-APPL-PROGRAM-ID    
           MOVE HQ-ATTR-INCTV-VALUE         TO S-RS5-ATTR-INCTV-VALUE   
           MOVE HQ-ATTR-INCTV-VAL-TX        TO S-RS5-ATTR-INCTV-VAL-TX  
           MOVE HQ-LAST-UPDATE-USERID       TO S-RS5-LAST-UPDATE-USERID 
           MOVE HQ-LAST-UPDATE-TS           TO S-RS5-LAST-UPDATE-TS     
           MOVE HQ-GL-ACCT-CREDIT           TO S-RS5-GL-ACCT-CREDIT     
           MOVE HQ-GL-ACCT-DEBIT            TO S-RS5-GL-ACCT-DEBIT      
           MOVE HQ-CATEGORY-ID              TO S-RS5-CATEGORY-ID        
           MOVE HQ-WQ-ROUTE-CATEGORY        TO S-RS5-WQ-ROUTE-CATEGORY  
           MOVE HQ-OPT-CHG-ACTION-CD        TO S-RS5-OPT-CHG-ACTION-CD  
           MOVE HQ-ATTR-INCTV-STRT-DT       TO S-RS5-ATTR-INCTV-STRT-DT 
           MOVE HQ-ATTR-INCTV-END-DT        TO S-RS5-ATTR-INCTV-END-DT  
           MOVE HQ-OPT-ATTR-VRSN-NO         TO S-RS5-OPT-ATTR-VRSN-NO   
           MOVE HQ-OPT-ATTR-VSTART-TS       TO S-RS5-OPT-ATTR-VSTART-TS 
           MOVE HQ-OPT-ATTR-VEND-TS         TO S-RS5-OPT-ATTR-VEND-TS   
           MOVE HQ-PROC-STATUS-CD           TO S-RS5-PROC-STATUS-CD     
           MOVE HQ-PROC-REQ-ID              TO S-RS5-PROC-REQ-ID        
                                                                        
           PERFORM 8050-INSERT-GTT-R5          THRU 8050-EXIT           
           PERFORM 7210-FETCH-ATTR-INCEN-CUR    THRU 7210-EXIT.         
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *2340-GET-OPT-DET-FOR-OFF.                                      *         
      ******************************************************************        
       2340-GET-OPT-DET-FOR-OFF.                                        
                                                                        
           INITIALIZE    WS-NO-MORE-OPTION-ROWS.                        
           MOVE 'N'                          TO WS-STATUS-FOR-OPTION.   
           MOVE E9-OPTION-CD                 TO FI-OPTION-CD.           
           MOVE E9-OFFER-CD                  TO WS-OFFER-CD-KEY.        
           MOVE E9-OFFER-OPT-START-DT        TO WS-ACTIVE-START-DT.     
           MOVE E9-OFFER-OPT-END-DT          TO WS-ACTIVE-END-DT.       
           MOVE E9-OFF-OPT-VSTART-TS         TO WS-VERSION-START-TS.    
           MOVE E9-OFF-OPT-VEND-TS           TO WS-VERSION-END-TS.      
           PERFORM 7100-OPEN-OPTION-DETAILS     THRU 7100-EXIT.         
           PERFORM 7101-FECTH-OPTION-DETAILS    THRU 7101-EXIT.         
           PERFORM 2370-PROCESS-FOR-OPTION      THRU 2370-EXIT          
                                             UNTIL NO-MORE-OPTION-ROWS. 
           PERFORM 7102-CLOSE-OPTION-DETAILS    THRU 7102-EXIT.         
                                                                        
           IF ROW-FOUND-FOR-OPTION                                      
              PERFORM 2314-MOVE-OFF-OPT-FOR-OPT-RS6 THRU 2314-EXIT      
           END-IF.                                                      
                                                                        
           PERFORM 7270-FETCH-OFF-OPT-FOR-OFFER THRU 7270-EXIT.         
                                                                        
       2340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *2350-GET-OFFER-DET-FOR-OPTION.                                  *        
      ******************************************************************        
       2350-GET-OFFER-DET-FOR-OPTION.                                   
                                                                        
           INITIALIZE  WS-OFFER-KEYS.                                   
           MOVE 'N'                          TO WS-NO-MORE-OFFER-ROWS   
                                                WS-STATUS-FOR-OFFER.    
           MOVE E9-OFFER-CD                  TO FG-OFFER-CD.            
           MOVE FI-OPTION-CD                 TO WS-OPTION-CD-KEY.       
                                                                        
           MOVE E9-OFFER-OPT-START-DT        TO WS-ACTIVE-START-DT.     
           MOVE E9-OFFER-OPT-END-DT          TO WS-ACTIVE-END-DT.       
           MOVE E9-OFF-OPT-VSTART-TS         TO WS-VERSION-START-TS.    
           MOVE E9-OFF-OPT-VEND-TS           TO WS-VERSION-END-TS.      
                                                                        
           PERFORM 7000-OPEN-OFFER-CD-CUR       THRU 7000-EXIT.         
           PERFORM 7001-FETCH-OFFER-CD-CUR      THRU 7001-EXIT.         
           PERFORM 2380-PROCESS-FOR-OFFER       THRU 2380-EXIT          
                                                UNTIL NO-MORE-OFFER-ROWS
           PERFORM 7002-CLOSE-OFFER-CD-CUR      THRU 7002-EXIT.         
                                                                        
           IF ROW-FOUND-FOR-OFFER                                       
              PERFORM 2314-MOVE-OFF-OPT-FOR-OPT-RS6 THRU 2314-EXIT      
           END-IF.                                                      
                                                                        
           PERFORM 7240-FETCH-OFF-OPT-FOR-OPTION                        
                                                THRU 7240-EXIT.         
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *2360-PROCESS-MKT-TIER.                                          *        
      ******************************************************************        
       2360-PROCESS-MKT-TIER.                                           
                                                                        
           PERFORM 2325-MOVE-MKT-TIERO-RS4      THRU 2325-EXIT.         
           PERFORM 7330-FETCH-OFF-MKT-TIER      THRU 7330-EXIT.         
                                                                        
       2360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GETTING ATTRIBUTE INCENTIVE DETAILS BASED ON OPTION CD         *        
      * AND MOVING ALL OPTION DETAILS TO RESULT SET.                   *        
      ******************************************************************        
       2370-PROCESS-FOR-OPTION.                                         
                                                                        
      **************************************************************            
      *    GETTING ATTRIBUTE INCENTIVE DETAILS BASED ON OPTION CD  *            
      **************************************************************            
           IF RPM001-CREATE-NEW-OFFER OR RPM002-MODIFY-OFFER            
              INITIALIZE    WS-NO-MORE-ATTR-INC-ROWS                    
              MOVE FI-OPTION-CD                  TO HQ-OPTION-CD        
                                                                        
              MOVE FI-OPTION-START-DT           TO WS-ACTIVE-START-DT   
              MOVE FI-OPTION-END-DT             TO WS-ACTIVE-END-DT     
              MOVE FI-OPT-VSTART-TS             TO WS-VERSION-START-TS  
              MOVE FI-OPT-VEND-TS               TO WS-VERSION-END-TS    
              PERFORM 7200-OPEN-ATTR-INCEN-CUR      THRU 7200-EXIT      
              PERFORM 7210-FETCH-ATTR-INCEN-CUR     THRU 7210-EXIT      
              PERFORM 2330-MOVE-ATTR-INCEN-RS5      THRU 2330-EXIT      
                                                UNTIL NO-MORE-ATTR-ROWS 
              PERFORM 7220-CLOSE-ATTR-INCEN-CUR     THRU 7220-EXIT      
           END-IF                                                       
                                                                        
           PERFORM 2315-MOVE-OPTION-RS2         THRU 2315-EXIT.         
           PERFORM 7101-FECTH-OPTION-DETAILS    THRU 7101-EXIT.         
                                                                        
       2370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *2380-PROCESS-FOR-OFFER.                                         *        
      ******************************************************************        
       2380-PROCESS-FOR-OFFER.                                          
                                                                        
           PERFORM 2310-MOVE-OFFER-RS1          THRU 2310-EXIT.         
           PERFORM 7001-FETCH-OFFER-CD-CUR      THRU 7001-EXIT.         
                                                                        
       2380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *2390-PROCESS-FOR-OFFER-PROMO.                                   *        
      ******************************************************************        
       2390-PROCESS-FOR-OFFER-PROMO.                                    
                                                                        
           PERFORM 2320-MOVE-PROMO-RS3          THRU 2320-EXIT.         
           PERFORM 7360-FETCH-OFFER-PROMO-CUR   THRU 7360-EXIT.         
                                                                        
       2390-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7000-OPEN-OFFER-CD-CUR   -   CRM_RT_PKG_OFFER                  *        
      ******************************************************************        
       7000-OPEN-OFFER-CD-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_CD_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7001-FETCH-OFFER-CD-CUR.                                       *        
      * GET ALL THE OFFER DETAILS BASED ON OPTION CODE                 * *      
      ******************************************************************        
       7001-FETCH-OFFER-CD-CUR.                                         
                                                                        
           EXEC SQL                                                     
               FETCH OFFER_CD_CUR                                       
                INTO :FG-COMPANY-NO                                     
                    ,:FG-OFFER-CD                                       
                    ,:FG-OFFER-DESC-INT                                 
                    ,:FG-OFFER-DESC-EXT                                 
                    ,:FG-PROMO-CD-INT-FL                                
                    ,:FG-PROMO-CD-EXT-FL                                
                    ,:FG-OFFER-START-DT                                 
                    ,:FG-OFFER-END-DT                                   
                    ,:FG-DISP-START-INT-TS                              
                    ,:FG-DISP-END-INT-TS                                
                    ,:FG-DISP-START-EXT-TS                              
                    ,:FG-DISP-END-EXT-TS                                
                    ,:FG-LAST-UPDATE-TS                                 
                    ,:FG-LAST-UPDATE-USERID                             
                    ,:FG-OFFER-DESC-INT-LNG                             
                    ,:FG-OFFER-DESC-EXT-LNG                             
                    ,:FG-SPCL-OFFER-TYPE-CD                             
                    ,:FG-RENEWAL-OFFER-CD                               
                    ,:FG-RENEW-PUB-OFFER-CD                             
                    ,:FG-OFF-VRSN-NO                                    
                    ,:FG-OFF-VSTART-TS                                  
                    ,:FG-OFF-VEND-TS                                    
                    ,:FG-PROC-STATUS-CD                                 
                    ,:FG-PROC-REQ-ID                                    
PRJ892              ,:FG-MAX-PRICE-OFFER-CD                             
PRJ892              ,:FG-RTCHG-PUB-OFFER-CD                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 'Y'                 TO WS-STATUS-FOR-OFFER     
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-OFFER-ROWS   
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7001'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_RT_PKG_OFFER'  TO TABLE-1                 
                    MOVE 'OFFER_CD'          TO TABLE-ELEMENT-1         
                    MOVE FG-OFFER-CD         TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7002-CLOSE-OFFER-CD-CUR   - CRM_RT_PKG_OFFER                  *         
      *****************************************************************         
       7002-CLOSE-OFFER-CD-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_CD_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7002'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-OPTION-DETAILS -   CRM_RT_PKG_OPTION                 *        
      ******************************************************************        
       7100-OPEN-OPTION-DETAILS.                                        
                                                                        
           EXEC SQL                                                     
                OPEN OPTION_CD_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7101-FECTH-OPTION-DETAILS                                      *        
      ******************************************************************        
       7101-FECTH-OPTION-DETAILS.                                       
                                                                        
           EXEC SQL                                                     
              FETCH OPTION_CD_CUR                                       
               INTO :FI-COMPANY-NO                                      
                   ,:FI-OPTION-CD                                       
                   ,:FI-CODE-UTIL-TYPE                                  
                   ,:FI-RATE-PLAN-NO                                    
                   ,:FI-OPTION-START-DT                                 
                   ,:FI-OPTION-END-DT                                   
                   ,:FI-OPT-DESC-INT                                    
                   ,:FI-OPT-DESC-INT-LONG                               
                   ,:FI-CURR-EXT-DESC-LONG                              
                   ,:FI-RENEWAL-DESC-LONG                               
                   ,:FI-WEB-DESC-LONG                                   
                   ,:FI-STATUS-CD                                       
                   ,:FI-LAST-UPDATE-USERID                              
                   ,:FI-LAST-UPDATE-TS                                  
                   ,:FI-OPT-CALC-TYPE-CD                                
                   ,:FI-WEB-MKT-DESC-LONG                               
                   ,:FI-OPT-VRSN-NO                                     
                   ,:FI-OPT-VSTART-TS                                   
                   ,:FI-OPT-VEND-TS                                     
                   ,:FI-PROC-STATUS-CD                                  
                   ,:FI-PROC-REQ-ID                                     
A04805             ,:FI-OPTION-TYPE-DESC                                
PRJ892             ,:FI-AUTO-RENEWAL-FL                                 
PRJ892             ,:FI-OPTION-PROMO-DESC                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 'Y'                 TO WS-STATUS-FOR-OPTION    
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-OPTION-ROWS  
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7101'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_RT_PKG_OPTION' TO TABLE-1                 
                    MOVE 'OPTION_CD'         TO TABLE-ELEMENT-1         
                    MOVE FI-OPTION-CD        TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7102-CLOSE-OPTION-DETAILS - CRM_RT_PKG_OPTION                 *         
      *****************************************************************         
       7102-CLOSE-OPTION-DETAILS.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE OPTION_CD_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7102'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7105-ACCEPT-TIMESTAMP.                                         *        
      ******************************************************************        
       7105-ACCEPT-TIMESTAMP.                                           
                                                                        
           MOVE '7105'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-TIMESTAMP,
              :WS-CURRENT-DATE                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURR-TIMESTAMP = CURRENT TIMESTAMP                     
MFA-TR*             ,:WS-CURRENT-DATE   = CURRENT DATE                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7105'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SEARCH DRIVING CURSOR FOR OPTION.                              *        
      * 7110-OPEN-OPTION-CD-CUR.     CRM_RT_PKG_OPTION                 *        
      ******************************************************************        
       7110-OPEN-OPTION-CD-CUR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN OPTION_DRIVE_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7110'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7120-FETCH-OPTION-CD-CUR.     CRM_RT_PKG_OPTION                         
      *****************************************************************         
       7120-FETCH-OPTION-CD-CUR.                                        
                                                                        
           EXEC SQL                                                     
              FETCH OPTION_DRIVE_CUR                                    
               INTO :FI-COMPANY-NO                                      
                   ,:FI-OPTION-CD                                       
                   ,:FI-CODE-UTIL-TYPE                                  
                   ,:FI-RATE-PLAN-NO                                    
                   ,:FI-OPTION-START-DT                                 
                   ,:FI-OPTION-END-DT                                   
                   ,:FI-OPT-DESC-INT                                    
                   ,:FI-OPT-DESC-INT-LONG                               
                   ,:FI-CURR-EXT-DESC-LONG                              
                   ,:FI-RENEWAL-DESC-LONG                               
                   ,:FI-WEB-DESC-LONG                                   
                   ,:FI-STATUS-CD                                       
                   ,:FI-LAST-UPDATE-USERID                              
                   ,:FI-LAST-UPDATE-TS                                  
                   ,:FI-OPT-CALC-TYPE-CD                                
                   ,:FI-WEB-MKT-DESC-LONG                               
                   ,:FI-OPT-VRSN-NO                                     
                   ,:FI-OPT-VSTART-TS                                   
                   ,:FI-OPT-VEND-TS                                     
                   ,:FI-PROC-STATUS-CD                                  
                   ,:FI-PROC-REQ-ID                                     
A04805             ,:FI-OPTION-TYPE-DESC                                
PRJ892             ,:FI-AUTO-RENEWAL-FL                                 
PRJ892             ,:FI-OPTION-PROMO-DESC                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ROWS         
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7120'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_RT_PKG_OPTION' TO TABLE-1                 
                    MOVE 'OPTION_CD'         TO TABLE-ELEMENT-1         
                    MOVE FI-OPTION-CD        TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7130-CLOSE-OPTION-CD-CUR. CRM_RT_PKG_OPTION                   *         
      *****************************************************************         
       7130-CLOSE-OPTION-CD-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE OPTION_DRIVE_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7130'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OPTION'       TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE FI-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SEARCH DRIVING CURSOR FOR OFFER.  CRM_RT_PKG_OFFER             *        
      * 7140-OPEN-OFFER-CD-CUR.                                        *        
      ******************************************************************        
       7140-OPEN-OFFER-CD-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_DRIVE_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7140'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7150-FETCH-OFFER-CD-CUR.   CRM_RT_PKG_OFFER                             
      *****************************************************************         
       7150-FETCH-OFFER-CD-CUR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH OFFER_DRIVE_CUR                                     
               INTO :FG-COMPANY-NO                                      
                   ,:FG-OFFER-CD                                        
                   ,:FG-OFFER-DESC-INT                                  
                   ,:FG-OFFER-DESC-EXT                                  
                   ,:FG-PROMO-CD-INT-FL                                 
                   ,:FG-PROMO-CD-EXT-FL                                 
                   ,:FG-OFFER-START-DT                                  
                   ,:FG-OFFER-END-DT                                    
                   ,:FG-DISP-START-INT-TS                               
                   ,:FG-DISP-END-INT-TS                                 
                   ,:FG-DISP-START-EXT-TS                               
                   ,:FG-DISP-END-EXT-TS                                 
                   ,:FG-LAST-UPDATE-TS                                  
                   ,:FG-LAST-UPDATE-USERID                              
                   ,:FG-OFFER-DESC-INT-LNG                              
                   ,:FG-OFFER-DESC-EXT-LNG                              
                   ,:FG-SPCL-OFFER-TYPE-CD                              
                   ,:FG-RENEWAL-OFFER-CD                                
                   ,:FG-RENEW-PUB-OFFER-CD                              
                   ,:FG-OFF-VRSN-NO                                     
                   ,:FG-OFF-VSTART-TS                                   
                   ,:FG-OFF-VEND-TS                                     
                   ,:FG-PROC-STATUS-CD                                  
                   ,:FG-PROC-REQ-ID                                     
PRJ892             ,:FG-MAX-PRICE-OFFER-CD                              
PRJ892             ,:FG-RTCHG-PUB-OFFER-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ROWS         
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7150'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_RT_PKG_OFFER'  TO TABLE-1                 
                    MOVE 'OFFER_CD'          TO TABLE-ELEMENT-1         
                    MOVE FG-OFFER-CD         TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7160-CLOSE-OFFER-CD-CUR.   CRM_RT_PKG_OFFER                   *         
      *****************************************************************         
       7160-CLOSE-OFFER-CD-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_DRIVE_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7160'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_RT_PKG_OFFER'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE FG-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SEARCH DRIVING CURSOR FOR OFFER. RT_MKT_PROMOTION              *        
      * 7170-OPEN-PROMO-CD-CUR.                                        *        
      ******************************************************************        
       7170-OPEN-PROMO-CD-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN PROMO_DRIVE_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7170'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-1         
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7180-FETCH-PROMO-CD-CUR.   CRM-MKT-PROMOTION                            
      *****************************************************************         
       7180-FETCH-PROMO-CD-CUR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH PROMO_DRIVE_CUR                                     
               INTO :KM-COMPANY-NO                                      
                   ,:KM-PROMO-CD                                        
                   ,:KM-PROMO-DESC                                      
                   ,:KM-OFFER-CD                                        
                   ,:KM-MKT-PLAN-CD                                     
                   ,:KM-PROMO-START-DT                                  
                   ,:KM-PROMO-START-TM                                  
                   ,:KM-PROMO-END-DT                                    
                   ,:KM-PROMO-END-TM                                    
                   ,:KM-AD-CHANNEL-CD                                   
                   ,:KM-PROMO-DESC-LONG                                 
                   ,:KM-EXT-LANDING-PG-URL                              
                   ,:KM-PROMO-TYPE-CD                                   
                   ,:KM-WEB-IMAGE-FILE-NM                               
                   ,:KM-LAST-UPDATE-USERID                              
                   ,:KM-LAST-UPDATE-TS                                  
                   ,:KM-REPLACMNT-PROMO-CD                              
                   ,:KM-DISPLAY-END-DT                                  
                   ,:KM-INT-LANDING-PG-URL                              
                   ,:KM-PROMO-VRSN-NO                                   
                   ,:KM-PROMO-VSTART-TS                                 
                   ,:KM-PROMO-VEND-TS                                   
                   ,:KM-PROC-STATUS-CD                                  
                   ,:KM-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ROWS         
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7180'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_MKT_PROMOTION' TO TABLE-1                 
                    MOVE 'PROMO_CD'          TO TABLE-ELEMENT-1         
                    MOVE KM-PROMO-CD         TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7190-CLOSE-PROMO-CD-CUR. RT_MKT_PROMOTION                     *         
      *****************************************************************         
       7190-CLOSE-PROMO-CD-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE PROMO_DRIVE_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7190'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'PROMO_CD'                TO TABLE-ELEMENT-1         
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-OPEN-ATTR-INCEN-CUR.                                      *        
      ******************************************************************        
       7200-OPEN-ATTR-INCEN-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN ATTR_INCEN_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7210-FETCH-ATTR-INCEN-CUR.                                    *         
      *****************************************************************         
       7210-FETCH-ATTR-INCEN-CUR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH ATTR_INCEN_CUR                                      
               INTO :HQ-COMPANY-NO                                      
                   ,:HQ-OPTION-CD                                       
                   ,:HQ-ATTR-INCTV-SEQ-NO                               
                   ,:HQ-RT-ATTR-INCTV-TYPE                              
                   ,:HQ-PRIMRY-OPT-ATTR-FL                              
                   ,:HQ-FACTOR-ID                                       
                   ,:HQ-DURATION-NO :WS-NULL-IND-01                      
                   ,:HQ-APPL-PROGRAM-ID                                 
                   ,:HQ-ATTR-INCTV-VALUE :WS-NULL-IND-02                 
                   ,:HQ-ATTR-INCTV-VAL-TX                               
                   ,:HQ-LAST-UPDATE-USERID                              
                   ,:HQ-LAST-UPDATE-TS                                  
                   ,:HQ-GL-ACCT-CREDIT                                  
                   ,:HQ-GL-ACCT-DEBIT                                   
                   ,:HQ-CATEGORY-ID                                     
                   ,:HQ-WQ-ROUTE-CATEGORY                               
                   ,:HQ-OPT-CHG-ACTION-CD                               
                   ,:HQ-ATTR-INCTV-STRT-DT                              
                   ,:HQ-ATTR-INCTV-END-DT                               
                   ,:HQ-OPT-ATTR-VRSN-NO                                
                   ,:HQ-OPT-ATTR-VSTART-TS                              
                   ,:HQ-OPT-ATTR-VEND-TS                                
                   ,:HQ-PROC-STATUS-CD                                  
                   ,:HQ-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                                                                        
                    IF WS-NULL-IND-01       =  WS-YES-NULL              
                       MOVE ZEROS           TO HQ-DURATION-NO           
                    END-IF                                              
                                                                        
                    IF WS-NULL-IND-02 = WS-YES-NULL                     
                       MOVE ZEROES          TO HQ-ATTR-INCTV-VALUE      
                    END-IF                                              
                                                                        
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ATTR-INC-ROWS
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7210'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_OPT_ATTR_INCTV' TO TABLE-1                
                    MOVE 'OPTION_CD'         TO TABLE-ELEMENT-1         
                    MOVE HQ-OPTION-CD        TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7220-CLOSE-ATTR-INCEN-CUR.                                    *         
      *****************************************************************         
       7220-CLOSE-ATTR-INCEN-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE ATTR_INCEN_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7220'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OPT_ATTR_INCTV'      TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE HQ-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7230-OPEN-OFF-OPT-FOR-OPTION.                                 *         
      *****************************************************************         
       7230-OPEN-OFF-OPT-FOR-OPTION.                                    
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_OPTION_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  FETCH OFFER_OPTION_CUR                                       *         
      *****************************************************************         
       7240-FETCH-OFF-OPT-FOR-OPTION.                                   
                                                                        
           EXEC SQL                                                     
              FETCH OFFER_OPTION_CUR                                    
               INTO :E9-COMPANY-NO                                      
                   ,:E9-OFFER-CD                                        
                   ,:E9-OPTION-CD                                       
                   ,:E9-OPTION-SORT-SEQ-NO                              
                   ,:E9-OPTION-URL-TX                                   
                   ,:E9-LAST-UPDATE-USERID                              
                   ,:E9-LAST-UPDATE-TS                                  
                   ,:E9-DROP-OPTION-CD                                  
                   ,:E9-OFFER-OPT-START-DT                              
                   ,:E9-OFFER-OPT-END-DT                                
                   ,:E9-OFF-OPT-VRSN-NO                                 
                   ,:E9-OFF-OPT-VSTART-TS                               
                   ,:E9-OFF-OPT-VEND-TS                                 
                   ,:E9-PROC-STATUS-CD                                  
                   ,:E9-PROC-REQ-ID                                     
A04805             ,:E9-WEB-NEW-EXISTS-CD                               
A04805             ,:E9-WEB-SIGN-UP-FL                                  
A04805             ,:E9-OFF-OPT-EXCLUDE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 'Y'                 TO WS-STATUS-FOR-OPTION    
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-OFF-OPT-ROWS 
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7240'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_OFFER_OPTION'  TO TABLE-1                 
                    MOVE 'OPTION_CD'         TO TABLE-ELEMENT-1         
                    MOVE E9-OPTION-CD        TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7250-CLOSE-OFF-OPT-FOR-OPTION.                                 *        
      ******************************************************************        
       7250-CLOSE-OFF-OPT-FOR-OPTION.                                   
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_OPTION_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'OPTION_CD'               TO TABLE-ELEMENT-1         
              MOVE E9-OPTION-CD              TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7260-OPEN-OFF-OPT-FOR-OFFER.                                  *         
      *****************************************************************         
       7260-OPEN-OFF-OPT-FOR-OFFER.                                     
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_OPTION_CUR2                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7260'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7270-FETCH-OFF-OPT-FOR-OFFER.                                *         
      *****************************************************************         
       7270-FETCH-OFF-OPT-FOR-OFFER.                                    
                                                                        
           EXEC SQL                                                     
              FETCH OFFER_OPTION_CUR2                                   
               INTO :E9-COMPANY-NO                                      
                   ,:E9-OFFER-CD                                        
                   ,:E9-OPTION-CD                                       
                   ,:E9-OPTION-SORT-SEQ-NO                              
                   ,:E9-OPTION-URL-TX                                   
                   ,:E9-LAST-UPDATE-USERID                              
                   ,:E9-LAST-UPDATE-TS                                  
                   ,:E9-DROP-OPTION-CD                                  
                   ,:E9-OFFER-OPT-START-DT                              
                   ,:E9-OFFER-OPT-END-DT                                
                   ,:E9-OFF-OPT-VRSN-NO                                 
                   ,:E9-OFF-OPT-VSTART-TS                               
                   ,:E9-OFF-OPT-VEND-TS                                 
                   ,:E9-PROC-STATUS-CD                                  
                   ,:E9-PROC-REQ-ID                                     
A04805             ,:E9-WEB-NEW-EXISTS-CD                               
A04805             ,:E9-WEB-SIGN-UP-FL                                  
A04805             ,:E9-OFF-OPT-EXCLUDE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 'Y'                 TO WS-STATUS-FOR-OFFER     
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-OFF-OPT-ROWS 
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7270'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_OFFER_OPTION'  TO TABLE-1                 
                    MOVE 'OFFER_CD'          TO TABLE-ELEMENT-1         
                    MOVE E9-OFFER-CD         TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7280-CLOSE-OFF-OPT-FOR-OFFER.                                 *         
      *****************************************************************-        
       7280-CLOSE-OFF-OPT-FOR-OFFER.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_OPTION_CUR2                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7280'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OFFER_OPTION'        TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE E9-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7290-OPEN-MKT-TIER-CUR.                                       *         
      *****************************************************************         
       7290-OPEN-MKT-TIER-CUR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN MKT_TIER_DRIVE_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-1         
              MOVE IG-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7300-FETCH-MKT-TIER-CUR.                                     *         
      *****************************************************************         
       7300-FETCH-MKT-TIER-CUR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH MKT_TIER_DRIVE_CUR                                  
               INTO :IG-COMPANY-NO                                      
                   ,:DU-OFFER-CD                                        
                   ,:DU-TIER-CUST-STAT-CD                               
                   ,:DU-TIER-ACCT-TYPE-CD                               
                   ,:DU-MKT-TIER-RANKING                                
                   ,:DU-MKT-TIER-START-DT                               
                   ,:IG-MKT-TIER-DESC                                   
                   ,:IG-MKT-TIER-END-DT                                 
                   ,:IG-TIER-OFFER-VIEW                                 
                   ,:DU-OFFER-TIER-STRT-DT                              
                   ,:DU-MKT-TIER-APPLY-CD                               
                   ,:DU-TIER-DEFLT-OFFR-CD                              
                   ,:DU-OFFER-TIER-END-DT                               
                   ,:IG-CUST-ACCT-DEFLT-FL                              
                   ,:IG-MKT-TIER-DESC-LONG                              
                   ,:DU-LAST-UPDATE-USERID                              
                   ,:DU-LAST-UPDATE-TS                                  
                   ,:DU-OFF-TIER-VRSN-NO                                
                   ,:DU-OFF-TIER-VSTART-TS                              
                   ,:DU-OFF-TIER-VEND-TS                                
                   ,:DU-PROC-STATUS-CD                                  
                   ,:DU-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-ROWS         
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7300'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_MKT_TIER'      TO TABLE-1                 
                    MOVE 'MKT_TIER_RANKING'  TO TABLE-ELEMENT-1         
                    MOVE IG-MKT-TIER-RANKING TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7310-CLOSE-MKT-TIER-CUR.                                      *         
      *****************************************************************-        
       7310-CLOSE-MKT-TIER-CUR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE MKT_TIER_DRIVE_CUR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7310'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_TIER'            TO TABLE-1                 
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-1         
              MOVE IG-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7320-OPEN-OFF-MKT-TIER.                                       *         
      *****************************************************************         
       7320-OPEN-OFF-MKT-TIER.                                          
                                                                        
           EXEC SQL                                                     
                OPEN OFF_MKT_TIER_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7320'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-1         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-2         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-3         
              MOVE DU-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-1       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7330-FETCH-OFF-MKT-TIER.                                     *         
      *****************************************************************         
       7330-FETCH-OFF-MKT-TIER.                                         
                                                                        
           EXEC SQL                                                     
              FETCH OFF_MKT_TIER_CUR                                    
               INTO :IG-COMPANY-NO                                      
                   ,:DU-OFFER-CD                                        
                   ,:DU-TIER-CUST-STAT-CD                               
                   ,:DU-TIER-ACCT-TYPE-CD                               
                   ,:DU-MKT-TIER-RANKING                                
                   ,:DU-MKT-TIER-START-DT                               
                   ,:IG-MKT-TIER-DESC                                   
                   ,:IG-MKT-TIER-END-DT                                 
                   ,:IG-TIER-OFFER-VIEW                                 
                   ,:DU-OFFER-TIER-STRT-DT                              
                   ,:DU-MKT-TIER-APPLY-CD                               
                   ,:DU-TIER-DEFLT-OFFR-CD                              
                   ,:DU-OFFER-TIER-END-DT                               
                   ,:IG-CUST-ACCT-DEFLT-FL                              
                   ,:IG-MKT-TIER-DESC-LONG                              
                   ,:DU-LAST-UPDATE-USERID                              
                   ,:DU-LAST-UPDATE-TS                                  
                   ,:DU-OFF-TIER-VRSN-NO                                
                   ,:DU-OFF-TIER-VSTART-TS                              
                   ,:DU-OFF-TIER-VEND-TS                                
                   ,:DU-PROC-STATUS-CD                                  
                   ,:DU-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-TIER-ROWS    
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7330'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_OFF_MKT_TIER'  TO TABLE-1                 
                    MOVE 'MKT_TIER_RANKING'  TO TABLE-ELEMENT-1         
                    MOVE 'TIER_CUST_STAT_CD' TO TABLE-ELEMENT-2         
                    MOVE 'TIER_ACCT_TYPE_CD' TO TABLE-ELEMENT-3         
                    MOVE DU-MKT-TIER-RANKING TO HOSTVAR-ELEMENT-1       
                    MOVE DU-TIER-CUST-STAT-CD TO HOSTVAR-ELEMENT-2      
                    MOVE DU-TIER-ACCT-TYPE-CD TO HOSTVAR-ELEMENT-3      
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7340-CLOSE-OFF-MKT-TIER.                                      *         
      *****************************************************************-        
       7340-CLOSE-OFF-MKT-TIER.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE OFF_MKT_TIER_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7340'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_OFF_MKT_TIER'        TO TABLE-1                 
              MOVE 'MKT_TIER_RANKING'        TO TABLE-ELEMENT-1         
              MOVE 'TIER_CUST_STAT_CD'       TO TABLE-ELEMENT-2         
              MOVE 'TIER_ACCT_TYPE_CD'       TO TABLE-ELEMENT-3         
              MOVE DU-MKT-TIER-RANKING       TO HOSTVAR-ELEMENT-1       
              MOVE DU-TIER-CUST-STAT-CD      TO HOSTVAR-ELEMENT-2       
              MOVE DU-TIER-ACCT-TYPE-CD      TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET PROMOTION DETAILS BASED ON THE OFFER CODE                  *        
      * 7350-OPEN-OFFER-PROMO-CUR.                                     *        
      ******************************************************************        
       7350-OPEN-OFFER-PROMO-CUR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_PROMO_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7350'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE KM-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7360-FETCH-OFFER-PROMO-CUR.                                             
      *****************************************************************         
       7360-FETCH-OFFER-PROMO-CUR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH OFFER_PROMO_CUR                                     
               INTO :KM-COMPANY-NO                                      
                   ,:KM-PROMO-CD                                        
                   ,:KM-PROMO-DESC                                      
                   ,:KM-OFFER-CD                                        
                   ,:KM-MKT-PLAN-CD                                     
                   ,:KM-PROMO-START-DT                                  
                   ,:KM-PROMO-START-TM                                  
                   ,:KM-PROMO-END-DT                                    
                   ,:KM-PROMO-END-TM                                    
                   ,:KM-AD-CHANNEL-CD                                   
                   ,:KM-PROMO-DESC-LONG                                 
                   ,:KM-EXT-LANDING-PG-URL                              
                   ,:KM-PROMO-TYPE-CD                                   
                   ,:KM-WEB-IMAGE-FILE-NM                               
                   ,:KM-LAST-UPDATE-USERID                              
                   ,:KM-LAST-UPDATE-TS                                  
                   ,:KM-REPLACMNT-PROMO-CD                              
                   ,:KM-DISPLAY-END-DT                                  
                   ,:KM-INT-LANDING-PG-URL                              
                   ,:KM-PROMO-VRSN-NO                                   
                   ,:KM-PROMO-VSTART-TS                                 
                   ,:KM-PROMO-VEND-TS                                   
                   ,:KM-PROC-STATUS-CD                                  
                   ,:KM-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                 TO WS-NO-MORE-PROMO-ROWS   
                    MOVE 0                   TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '7360'              TO ACTIVE-PARAGRAPH        
                    MOVE 'FETCH'             TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CRM_MKT_PROMOTION' TO TABLE-1                 
                    MOVE 'OFFER_CD'          TO TABLE-ELEMENT-1         
                    MOVE KM-OFFER-CD         TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7370-CLOSE-OFFER-PROMO-CUR                                    *         
      *****************************************************************         
       7370-CLOSE-OFFER-PROMO-CUR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_PROMO_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7370'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'OFFER_CD'                TO TABLE-ELEMENT-1         
              MOVE KM-OFFER-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GET ALL MARKET PROMOTION DETAILS BASED ON PROMOTION CODE      *         
      *****************************************************************         
       7500-GET-MKT-PROMOTION-DET.                                      
                                                                        
           EXEC SQL                                                     
               SELECT KM.COMPANY_NO                                     
                     ,KM.PROMO_CD                                       
                     ,KM.PROMO_DESC                                     
                     ,KM.OFFER_CD                                       
                     ,KM.MKT_PLAN_CD                                    
                     ,KM.PROMO_START_DT                                 
                     ,REPLACE(CONVERT(CHAR(8), KM.PROMO_START_TM, 108), 
           ':', '.') PROMO_START_TM                                 
                     ,KM.PROMO_END_DT                                   
                     ,REPLACE(CONVERT(CHAR(8), KM.PROMO_END_TM, 108), 
           ':', '.') PROMO_END_TM                                   
                     ,KM.AD_CHANNEL_CD                                  
                     ,KM.PROMO_DESC_LONG                                
                     ,KM.EXT_LANDING_PG_URL                             
                     ,KM.PROMO_TYPE_CD                                  
                     ,KM.WEB_IMAGE_FILE_NM                              
                     ,KM.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,KM.REPLACMNT_PROMO_CD                             
                     ,KM.DISPLAY_END_DT                                 
                     ,KM.INT_LANDING_PG_URL                             
                 INTO :KM-COMPANY-NO                                    
                     ,:KM-PROMO-CD                                      
                     ,:KM-PROMO-DESC                                    
                     ,:KM-OFFER-CD                                      
                     ,:KM-MKT-PLAN-CD                                   
                     ,:KM-PROMO-START-DT                                
                     ,:KM-PROMO-START-TM                                
                     ,:KM-PROMO-END-DT                                  
                     ,:KM-PROMO-END-TM                                  
                     ,:KM-AD-CHANNEL-CD                                 
                     ,:KM-PROMO-DESC-LONG                               
                     ,:KM-EXT-LANDING-PG-URL                            
                     ,:KM-PROMO-TYPE-CD                                 
                     ,:KM-WEB-IMAGE-FILE-NM                             
                     ,:KM-LAST-UPDATE-USERID                            
                     ,:KM-LAST-UPDATE-TS                                
                     ,:KM-REPLACMNT-PROMO-CD                            
                     ,:KM-DISPLAY-END-DT                                
                     ,:KM-INT-LANDING-PG-URL                            
                 FROM CRM_MKT_PROMOTION  KM WITH(READUNCOMMITTED)               
                WHERE KM.PROMO_CD      = :KM-PROMO-CD                   
                  AND KM.COMPANY_NO    = :KM-COMPANY-NO                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KM.COMPANY_NO                                             
MFA-TR*              ,KM.PROMO_CD                                               
MFA-TR*              ,KM.PROMO_DESC                                             
MFA-TR*              ,KM.OFFER_CD                                               
MFA-TR*              ,KM.MKT_PLAN_CD                                            
MFA-TR*              ,KM.PROMO_START_DT                                         
MFA-TR*              ,KM.PROMO_START_TM                                         
MFA-TR*              ,KM.PROMO_END_DT                                           
MFA-TR*              ,KM.PROMO_END_TM                                           
MFA-TR*              ,KM.AD_CHANNEL_CD                                          
MFA-TR*              ,KM.PROMO_DESC_LONG                                        
MFA-TR*              ,KM.EXT_LANDING_PG_URL                                     
MFA-TR*              ,KM.PROMO_TYPE_CD                                          
MFA-TR*              ,KM.WEB_IMAGE_FILE_NM                                      
MFA-TR*              ,KM.LAST_UPDATE_USERID                                     
MFA-TR*              ,KM.LAST_UPDATE_TS                                         
MFA-TR*              ,KM.REPLACMNT_PROMO_CD                                     
MFA-TR*              ,KM.DISPLAY_END_DT                                         
MFA-TR*              ,KM.INT_LANDING_PG_URL                                     
MFA-TR*          INTO :KM-COMPANY-NO                                            
MFA-TR*              ,:KM-PROMO-CD                                              
MFA-TR*              ,:KM-PROMO-DESC                                            
MFA-TR*              ,:KM-OFFER-CD                                              
MFA-TR*              ,:KM-MKT-PLAN-CD                                           
MFA-TR*              ,:KM-PROMO-START-DT                                        
MFA-TR*              ,:KM-PROMO-START-TM                                        
MFA-TR*              ,:KM-PROMO-END-DT                                          
MFA-TR*              ,:KM-PROMO-END-TM                                          
MFA-TR*              ,:KM-AD-CHANNEL-CD                                         
MFA-TR*              ,:KM-PROMO-DESC-LONG                                       
MFA-TR*              ,:KM-EXT-LANDING-PG-URL                                    
MFA-TR*              ,:KM-PROMO-TYPE-CD                                         
MFA-TR*              ,:KM-WEB-IMAGE-FILE-NM                                     
MFA-TR*              ,:KM-LAST-UPDATE-USERID                                    
MFA-TR*              ,:KM-LAST-UPDATE-TS                                        
MFA-TR*              ,:KM-REPLACMNT-PROMO-CD                                    
MFA-TR*              ,:KM-DISPLAY-END-DT                                        
MFA-TR*              ,:KM-INT-LANDING-PG-URL                                    
MFA-TR*          FROM CRM_MKT_PROMOTION  KM                                     
MFA-TR*         WHERE KM.PROMO_CD      = :KM-PROMO-CD                           
MFA-TR*           AND KM.COMPANY_NO    = :KM-COMPANY-NO                         
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7500                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CRM_MKT_PROMOTION'       TO TABLE-1                 
              MOVE 'KM-PROMO-CD'             TO TABLE-ELEMENT-1         
              MOVE KM-PROMO-CD               TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04431_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04431_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04431_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04431_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04431_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000B'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04431_R2'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04431_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04431_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000C'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04431_R3'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000D-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04431_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04431_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000D'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04431_R4'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000E-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000E-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04431_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04431_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000E'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04431_R5'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8000F-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000F-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04431_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04431_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000F'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR04431_R6'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000F-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8010-INSERT-GTT-R1.   OFFER CODE TABLE                         *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04431_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,OFFER_CD                                             
                  ,MKT_TIER_RANKING                                     
                  ,TIER_CUST_STAT_CD                                    
                  ,TIER_ACCT_TYPE_CD                                    
                  ,MKT_TIER_START_DT                                    
                  ,OFFER_DESC_INT                                       
                  ,OFFER_DESC_EXT                                       
                  ,PROMO_CD_INT_FL                                      
                  ,PROMO_CD_EXT_FL                                      
                  ,OFFER_START_DT                                       
                  ,OFFER_END_DT                                         
                  ,DISP_START_INT_TS                                    
                  ,DISP_END_INT_TS                                      
                  ,DISP_START_EXT_TS                                    
                  ,DISP_END_EXT_TS                                      
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                  ,OFFER_DESC_INT_LNG                                   
                  ,OFFER_DESC_EXT_LNG                                   
                  ,SPCL_OFFER_TYPE_CD                                   
                  ,RENEWAL_OFFER_CD                                     
                  ,RENEW_PUB_OFFER_CD                                   
                  ,OFF_VRSN_NO                                          
                  ,OFF_VSTART_TS                                        
                  ,OFF_VEND_TS                                          
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
PRJ892            ,MAX_PRICE_OFFER_CD                                   
PRJ892            ,RTCHG_PUB_OFFER_CD                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-COMPANY-NO                                    
                  ,:S-RS1-OFFER-CD                                      
                  ,:S-RS1-MKT-TIER-RANK-KEY                             
                  ,:S-RS1-TIER-CUST-STAT-CD-KEY                         
                  ,:S-RS1-TIER-ACCT-TYPE-CD-KEY                         
                  ,:S-RS1-MKT-TIER-START-DT                             
                  ,:S-RS1-OFFER-DESC-INT                                
                  ,:S-RS1-OFFER-DESC-EXT                                
                  ,:S-RS1-PROMO-CD-INT-FL                               
                  ,:S-RS1-PROMO-CD-EXT-FL                               
                  ,:S-RS1-OFFER-START-DT                                
                  ,:S-RS1-OFFER-END-DT                                  
                  ,:S-RS1-DISP-START-INT-TS                             
                  ,:S-RS1-DISP-END-INT-TS                               
                  ,:S-RS1-DISP-START-EXT-TS                             
                  ,:S-RS1-DISP-END-EXT-TS                               
                  ,:S-RS1-LAST-UPDATE-TS                                
                  ,:S-RS1-LAST-UPDATE-USERID                            
                  ,:S-RS1-OFFER-DESC-INT-LNG                            
                  ,:S-RS1-OFFER-DESC-EXT-LNG                            
                  ,:S-RS1-SPCL-OFFER-TYPE-CD                            
                  ,:S-RS1-RENEWAL-OFFER-CD                              
                  ,:S-RS1-RENEW-PUB-OFFER-CD                            
                  ,:S-RS1-OFF-VRSN-NO                                   
                  ,:S-RS1-OFF-VSTART-TS                                 
                  ,:S-RS1-OFF-VEND-TS                                   
                  ,:S-RS1-PROC-STATUS-CD                                
                  ,:S-RS1-PROC-REQ-ID                                   
PRJ892            ,:S-RS1-MAX-PRICE-OFFER-CD                            
PRJ892            ,:S-RS1-RTCHG-PUB-OFFER-CD                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04431_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,MKT_TIER_RANKING                                             
MFA-TR*           ,TIER_CUST_STAT_CD                                            
MFA-TR*           ,TIER_ACCT_TYPE_CD                                            
MFA-TR*           ,MKT_TIER_START_DT                                            
MFA-TR*           ,OFFER_DESC_INT                                               
MFA-TR*           ,OFFER_DESC_EXT                                               
MFA-TR*           ,PROMO_CD_INT_FL                                              
MFA-TR*           ,PROMO_CD_EXT_FL                                              
MFA-TR*           ,OFFER_START_DT                                               
MFA-TR*           ,OFFER_END_DT                                                 
MFA-TR*           ,DISP_START_INT_TS                                            
MFA-TR*           ,DISP_END_INT_TS                                              
MFA-TR*           ,DISP_START_EXT_TS                                            
MFA-TR*           ,DISP_END_EXT_TS                                              
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,OFFER_DESC_INT_LNG                                           
MFA-TR*           ,OFFER_DESC_EXT_LNG                                           
MFA-TR*           ,SPCL_OFFER_TYPE_CD                                           
MFA-TR*           ,RENEWAL_OFFER_CD                                             
MFA-TR*           ,RENEW_PUB_OFFER_CD                                           
MFA-TR*           ,OFF_VRSN_NO                                                  
MFA-TR*           ,OFF_VSTART_TS                                                
MFA-TR*           ,OFF_VEND_TS                                                  
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,MAX_PRICE_OFFER_CD                                           
MFA-TR*           ,RTCHG_PUB_OFFER_CD                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-COMPANY-NO                                            
MFA-TR*           ,:S-RS1-OFFER-CD                                              
MFA-TR*           ,:S-RS1-MKT-TIER-RANK-KEY                                     
MFA-TR*           ,:S-RS1-TIER-CUST-STAT-CD-KEY                                 
MFA-TR*           ,:S-RS1-TIER-ACCT-TYPE-CD-KEY                                 
MFA-TR*           ,:S-RS1-MKT-TIER-START-DT                                     
MFA-TR*           ,:S-RS1-OFFER-DESC-INT                                        
MFA-TR*           ,:S-RS1-OFFER-DESC-EXT                                        
MFA-TR*           ,:S-RS1-PROMO-CD-INT-FL                                       
MFA-TR*           ,:S-RS1-PROMO-CD-EXT-FL                                       
MFA-TR*           ,:S-RS1-OFFER-START-DT                                        
MFA-TR*           ,:S-RS1-OFFER-END-DT                                          
MFA-TR*           ,:S-RS1-DISP-START-INT-TS                                     
MFA-TR*           ,:S-RS1-DISP-END-INT-TS                                       
MFA-TR*           ,:S-RS1-DISP-START-EXT-TS                                     
MFA-TR*           ,:S-RS1-DISP-END-EXT-TS                                       
MFA-TR*           ,:S-RS1-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS1-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS1-OFFER-DESC-INT-LNG                                    
MFA-TR*           ,:S-RS1-OFFER-DESC-EXT-LNG                                    
MFA-TR*           ,:S-RS1-SPCL-OFFER-TYPE-CD                                    
MFA-TR*           ,:S-RS1-RENEWAL-OFFER-CD                                      
MFA-TR*           ,:S-RS1-RENEW-PUB-OFFER-CD                                    
MFA-TR*           ,:S-RS1-OFF-VRSN-NO                                           
MFA-TR*           ,:S-RS1-OFF-VSTART-TS                                         
MFA-TR*           ,:S-RS1-OFF-VEND-TS                                           
MFA-TR*           ,:S-RS1-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS1-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS1-MAX-PRICE-OFFER-CD                                    
MFA-TR*           ,:S-RS1-RTCHG-PUB-OFFER-CD                                    
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                         TO  CTR-ROWS-RS1           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8010'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R1         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04431_R1'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8020-INSERT-GTT-R2.  OPTION CODE TABLE                         *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04431_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,COMPANY_NO                                         
                    ,OPTION_CD                                          
                    ,CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,OPTION_START_DT                                    
                    ,OPTION_END_DT                                      
                    ,OPT_DESC_INT                                       
                    ,OPT_DESC_INT_LONG                                  
                    ,CURR_EXT_DESC_LONG                                 
                    ,RENEWAL_DESC_LONG                                  
                    ,WEB_DESC_LONG                                      
                    ,STATUS_CD                                          
                    ,LAST_UPDATE_USERID                                 
                    ,LAST_UPDATE_TS                                     
                    ,OPT_CALC_TYPE_CD                                   
                    ,WEB_MKT_DESC_LONG                                  
                    ,OPT_VRSN_NO                                        
                    ,OPT_VSTART_TS                                      
                    ,OPT_VEND_TS                                        
                    ,PROC_STATUS_CD                                     
                    ,PROC_REQ_ID                                        
A04805              ,OPTION_TYPE_DESC                                   
PRJ892              ,AUTO_RENEWAL_FL                                    
PRJ892              ,OPTION_PROMO_DESC                                  
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-COMPANY-NO                                    
                  ,:S-RS2-OPTION-CD                                     
                  ,:S-RS2-CODE-UTIL-TYPE                                
                  ,:S-RS2-RATE-PLAN-NO                                  
                  ,:S-RS2-OPTION-START-DT                               
                  ,:S-RS2-OPTION-END-DT                                 
                  ,:S-RS2-OPT-DESC-INT                                  
                  ,:S-RS2-OPT-DESC-INT-LONG                             
                  ,:S-RS2-CURR-EXT-DESC-LONG                            
                  ,:S-RS2-RENEWAL-DESC-LONG                             
                  ,:S-RS2-WEB-DESC-LONG                                 
                  ,:S-RS2-STATUS-CD                                     
                  ,:S-RS2-LAST-UPDATE-USERID                            
                  ,:S-RS2-LAST-UPDATE-TS                                
                  ,:S-RS2-OPT-CALC-TYPE-CD                              
                  ,:S-RS2-WEB-MKT-DESC-LONG                             
                  ,:S-RS2-OPT-VRSN-NO                                   
                  ,:S-RS2-OPT-VSTART-TS                                 
                  ,:S-RS2-OPT-VEND-TS                                   
                  ,:S-RS2-PROC-STATUS-CD                                
                  ,:S-RS2-PROC-REQ-ID                                   
A04805            ,:S-RS2-OPTION-TYPE-DESC                              
PRJ892            ,:S-RS2-AUTO-RENEWAL-FL                               
PRJ892            ,:S-RS2-OPTION-PROMO-DESC                             
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04431_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,OPTION_START_DT                                            
MFA-TR*             ,OPTION_END_DT                                              
MFA-TR*             ,OPT_DESC_INT                                               
MFA-TR*             ,OPT_DESC_INT_LONG                                          
MFA-TR*             ,CURR_EXT_DESC_LONG                                         
MFA-TR*             ,RENEWAL_DESC_LONG                                          
MFA-TR*             ,WEB_DESC_LONG                                              
MFA-TR*             ,STATUS_CD                                                  
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,OPT_CALC_TYPE_CD                                           
MFA-TR*             ,WEB_MKT_DESC_LONG                                          
MFA-TR*             ,OPT_VRSN_NO                                                
MFA-TR*             ,OPT_VSTART_TS                                              
MFA-TR*             ,OPT_VEND_TS                                                
MFA-TR*             ,PROC_STATUS_CD                                             
MFA-TR*             ,PROC_REQ_ID                                                
MFA-TR*             ,OPTION_TYPE_DESC                                           
MFA-TR*             ,AUTO_RENEWAL_FL                                            
MFA-TR*             ,OPTION_PROMO_DESC                                          
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-COMPANY-NO                                            
MFA-TR*           ,:S-RS2-OPTION-CD                                             
MFA-TR*           ,:S-RS2-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS2-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS2-OPTION-START-DT                                       
MFA-TR*           ,:S-RS2-OPTION-END-DT                                         
MFA-TR*           ,:S-RS2-OPT-DESC-INT                                          
MFA-TR*           ,:S-RS2-OPT-DESC-INT-LONG                                     
MFA-TR*           ,:S-RS2-CURR-EXT-DESC-LONG                                    
MFA-TR*           ,:S-RS2-RENEWAL-DESC-LONG                                     
MFA-TR*           ,:S-RS2-WEB-DESC-LONG                                         
MFA-TR*           ,:S-RS2-STATUS-CD                                             
MFA-TR*           ,:S-RS2-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS2-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS2-OPT-CALC-TYPE-CD                                      
MFA-TR*           ,:S-RS2-WEB-MKT-DESC-LONG                                     
MFA-TR*           ,:S-RS2-OPT-VRSN-NO                                           
MFA-TR*           ,:S-RS2-OPT-VSTART-TS                                         
MFA-TR*           ,:S-RS2-OPT-VEND-TS                                           
MFA-TR*           ,:S-RS2-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS2-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS2-OPTION-TYPE-DESC                                      
MFA-TR*           ,:S-RS2-AUTO-RENEWAL-FL                                       
MFA-TR*           ,:S-RS2-OPTION-PROMO-DESC                                     
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                         TO CTR-ROWS-RS2            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8020'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R2         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04431_R2'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8030-INSERT-GTT-R3.   MKT PROMOTION TABLE                      *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04431_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,PROMO_CD                                             
                  ,PROMO_DESC                                           
                  ,OFFER_CD                                             
                  ,MKT_PLAN_CD                                          
                  ,PROMO_START_DT                                       
                  ,PROMO_START_TM                                       
                  ,PROMO_END_DT                                         
                  ,PROMO_END_TM                                         
                  ,AD_CHANNEL_CD                                        
                  ,PROMO_DESC_LONG                                      
                  ,EXT_LANDING_PG_URL                                   
                  ,PROMO_TYPE_CD                                        
                  ,WEB_IMAGE_FILE_NM                                    
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,REPLACMNT_PROMO_CD                                   
                  ,DISPLAY_END_DT                                       
                  ,INT_LANDING_PG_URL                                   
                  ,PROMO_VRSN_NO                                        
                  ,PROMO_VSTART_TS                                      
                  ,PROMO_VEND_TS                                        
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-COMPANY-NO                                    
                  ,:S-RS3-PROMO-CD                                      
                  ,:S-RS3-PROMO-DESC                                    
                  ,:S-RS3-OFFER-CD                                      
                  ,:S-RS3-MKT-PLAN-CD                                   
                  ,:S-RS3-PROMO-START-DT                                
                  ,:S-RS3-PROMO-START-TM                                
                  ,:S-RS3-PROMO-END-DT                                  
                  ,:S-RS3-PROMO-END-TM                                  
                  ,:S-RS3-AD-CHANNEL-CD                                 
                  ,:S-RS3-PROMO-DESC-LONG                               
                  ,:S-RS3-EXT-LANDING-PG-URL                            
                  ,:S-RS3-PROMO-TYPE-CD                                 
                  ,:S-RS3-WEB-IMAGE-FILE-NM                             
                  ,:S-RS3-LAST-UPDATE-USERID                            
                  ,:S-RS3-LAST-UPDATE-TS                                
                  ,:S-RS3-REPLACMNT-PROMO-CD                            
                  ,:S-RS3-DISPLAY-END-DT                                
                  ,:S-RS3-INT-LANDING-PG-URL                            
                  ,:S-RS3-PROMO-VRSN-NO                                 
                  ,:S-RS3-PROMO-VSTART-TS                               
                  ,:S-RS3-PROMO-VEND-TS                                 
                  ,:S-RS3-PROC-STATUS-CD                                
                  ,:S-RS3-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04431_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,PROMO_CD                                                     
MFA-TR*           ,PROMO_DESC                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,MKT_PLAN_CD                                                  
MFA-TR*           ,PROMO_START_DT                                               
MFA-TR*           ,PROMO_START_TM                                               
MFA-TR*           ,PROMO_END_DT                                                 
MFA-TR*           ,PROMO_END_TM                                                 
MFA-TR*           ,AD_CHANNEL_CD                                                
MFA-TR*           ,PROMO_DESC_LONG                                              
MFA-TR*           ,EXT_LANDING_PG_URL                                           
MFA-TR*           ,PROMO_TYPE_CD                                                
MFA-TR*           ,WEB_IMAGE_FILE_NM                                            
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,REPLACMNT_PROMO_CD                                           
MFA-TR*           ,DISPLAY_END_DT                                               
MFA-TR*           ,INT_LANDING_PG_URL                                           
MFA-TR*           ,PROMO_VRSN_NO                                                
MFA-TR*           ,PROMO_VSTART_TS                                              
MFA-TR*           ,PROMO_VEND_TS                                                
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-COMPANY-NO                                            
MFA-TR*           ,:S-RS3-PROMO-CD                                              
MFA-TR*           ,:S-RS3-PROMO-DESC                                            
MFA-TR*           ,:S-RS3-OFFER-CD                                              
MFA-TR*           ,:S-RS3-MKT-PLAN-CD                                           
MFA-TR*           ,:S-RS3-PROMO-START-DT                                        
MFA-TR*           ,:S-RS3-PROMO-START-TM                                        
MFA-TR*           ,:S-RS3-PROMO-END-DT                                          
MFA-TR*           ,:S-RS3-PROMO-END-TM                                          
MFA-TR*           ,:S-RS3-AD-CHANNEL-CD                                         
MFA-TR*           ,:S-RS3-PROMO-DESC-LONG                                       
MFA-TR*           ,:S-RS3-EXT-LANDING-PG-URL                                    
MFA-TR*           ,:S-RS3-PROMO-TYPE-CD                                         
MFA-TR*           ,:S-RS3-WEB-IMAGE-FILE-NM                                     
MFA-TR*           ,:S-RS3-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS3-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS3-REPLACMNT-PROMO-CD                                    
MFA-TR*           ,:S-RS3-DISPLAY-END-DT                                        
MFA-TR*           ,:S-RS3-INT-LANDING-PG-URL                                    
MFA-TR*           ,:S-RS3-PROMO-VRSN-NO                                         
MFA-TR*           ,:S-RS3-PROMO-VSTART-TS                                       
MFA-TR*           ,:S-RS3-PROMO-VEND-TS                                         
MFA-TR*           ,:S-RS3-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS3-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = 'Y'             
              ADD +1                         TO  CTR-ROWS-RS3           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8030'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R3         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04431_R3'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 8040-INSERT-GTT-R4.   CRM_MKT_TIER TABLE                       *        
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04431_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,OFFER_CD                                             
                  ,TIER_CUST_STAT_CD                                    
                  ,TIER_ACCT_TYPE_CD                                    
                  ,MKT_TIER_RANKING                                     
                  ,MKT_TIER_START_DT                                    
                  ,MKT_TIER_DESC                                        
                  ,MKT_TIER_END_DT                                      
                  ,TIER_OFFER_VIEW                                      
                  ,OFFER_TIER_STRT_DT                                   
                  ,MKT_TIER_APPLY_CD                                    
                  ,TIER_DEFLT_OFFR_CD                                   
                  ,OFFER_TIER_END_DT                                    
                  ,CUST_ACCT_DEFLT_FL                                   
                  ,MKT_TIER_DESC_LONG                                   
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,OFF_TIER_VRSN_NO                                     
                  ,OFF_TIER_VSTART_TS                                   
                  ,OFF_TIER_VEND_TS                                     
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-4                                     
                  ,:S-APPL-RETURN-CODE-4                                
                  ,:S-RS4-COMPANY-NO                                    
                  ,:S-RS4-OFFER-CD                                      
                  ,:S-RS4-TIER-CUST-STAT-CD                             
                  ,:S-RS4-TIER-ACCT-TYPE-CD                             
                  ,:S-RS4-MKT-TIER-RANKING                              
                  ,:S-RS4-MKT-TIER-START-DT                             
                  ,:S-RS4-MKT-TIER-DESC                                 
                  ,:S-RS4-MKT-TIER-END-DT                               
                  ,:S-RS4-TIER-OFFER-VIEW                               
                  ,:S-RS4-OFFER-TIER-STRT-DT                            
                  ,:S-RS4-MKT-TIER-APPLY-CD                             
                  ,:S-RS4-TIER-DEFLT-OFFR-CD                            
                  ,:S-RS4-OFFER-TIER-END-DT                             
                  ,:S-RS4-CUST-ACCT-DEFLT-FL                            
                  ,:S-RS4-MKT-TIER-DESC-LONG                            
                  ,:S-RS4-LAST-UPDATE-USERID                            
                  ,:S-RS4-LAST-UPDATE-TS                                
                  ,:S-RS4-OFF-TIER-VRSN-NO                              
                  ,:S-RS4-OFF-TIER-VSTART-TS                            
                  ,:S-RS4-OFF-TIER-VEND-TS                              
                  ,:S-RS4-PROC-STATUS-CD                                
                  ,:S-RS4-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04431_R4                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,TIER_CUST_STAT_CD                                            
MFA-TR*           ,TIER_ACCT_TYPE_CD                                            
MFA-TR*           ,MKT_TIER_RANKING                                             
MFA-TR*           ,MKT_TIER_START_DT                                            
MFA-TR*           ,MKT_TIER_DESC                                                
MFA-TR*           ,MKT_TIER_END_DT                                              
MFA-TR*           ,TIER_OFFER_VIEW                                              
MFA-TR*           ,OFFER_TIER_STRT_DT                                           
MFA-TR*           ,MKT_TIER_APPLY_CD                                            
MFA-TR*           ,TIER_DEFLT_OFFR_CD                                           
MFA-TR*           ,OFFER_TIER_END_DT                                            
MFA-TR*           ,CUST_ACCT_DEFLT_FL                                           
MFA-TR*           ,MKT_TIER_DESC_LONG                                           
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,OFF_TIER_VRSN_NO                                             
MFA-TR*           ,OFF_TIER_VSTART_TS                                           
MFA-TR*           ,OFF_TIER_VEND_TS                                             
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-4                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-4                                        
MFA-TR*           ,:S-RS4-COMPANY-NO                                            
MFA-TR*           ,:S-RS4-OFFER-CD                                              
MFA-TR*           ,:S-RS4-TIER-CUST-STAT-CD                                     
MFA-TR*           ,:S-RS4-TIER-ACCT-TYPE-CD                                     
MFA-TR*           ,:S-RS4-MKT-TIER-RANKING                                      
MFA-TR*           ,:S-RS4-MKT-TIER-START-DT                                     
MFA-TR*           ,:S-RS4-MKT-TIER-DESC                                         
MFA-TR*           ,:S-RS4-MKT-TIER-END-DT                                       
MFA-TR*           ,:S-RS4-TIER-OFFER-VIEW                                       
MFA-TR*           ,:S-RS4-OFFER-TIER-STRT-DT                                    
MFA-TR*           ,:S-RS4-MKT-TIER-APPLY-CD                                     
MFA-TR*           ,:S-RS4-TIER-DEFLT-OFFR-CD                                    
MFA-TR*           ,:S-RS4-OFFER-TIER-END-DT                                     
MFA-TR*           ,:S-RS4-CUST-ACCT-DEFLT-FL                                    
MFA-TR*           ,:S-RS4-MKT-TIER-DESC-LONG                                    
MFA-TR*           ,:S-RS4-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS4-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS4-OFF-TIER-VRSN-NO                                      
MFA-TR*           ,:S-RS4-OFF-TIER-VSTART-TS                                    
MFA-TR*           ,:S-RS4-OFF-TIER-VEND-TS                                      
MFA-TR*           ,:S-RS4-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS4-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R4 = 'Y'             
              ADD +1                         TO  CTR-ROWS-RS4           
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8040'                    TO ACTIVE-PARAGRAPH        
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'Y'                       TO WS-ERR-INSRT-R4         
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04431_R4'             TO TABLE-1                 
              MOVE SPACES                    TO TABLE-ELEMENT-1         
              MOVE SPACES                    TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
        8040-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8050-INSERT-GTT-R5. ATTIBUTE / INCENTIVE TABLE                 *        
      ******************************************************************        
       8050-INSERT-GTT-R5.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04431_R5                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,OPTION_CD                                            
                  ,ATTR_INCTV_SEQ_NO                                    
                  ,RT_ATTR_INCTV_TYPE                                   
                  ,PRIMRY_OPT_ATTR_FL                                   
                  ,FACTOR_ID                                            
                  ,DURATION_NO                                          
                  ,APPL_PROGRAM_ID                                      
                  ,ATTR_INCTV_VALUE                                     
                  ,ATTR_INCTV_VAL_TX                                    
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,GL_ACCT_CREDIT                                       
                  ,GL_ACCT_DEBIT                                        
                  ,CATEGORY_ID                                          
                  ,WQ_ROUTE_CATEGORY                                    
                  ,OPT_CHG_ACTION_CD                                    
                  ,ATTR_INCTV_STRT_DT                                   
                  ,ATTR_INCTV_END_DT                                    
                  ,OPT_ATTR_VRSN_NO                                     
                  ,OPT_ATTR_VSTART_TS                                   
                  ,OPT_ATTR_VEND_TS                                     
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-5                                     
                  ,:S-APPL-RETURN-CODE-5                                
                  ,:S-RS5-COMPANY-NO                                    
                  ,:S-RS5-OPTION-CD                                     
                  ,:S-RS5-ATTR-INCTV-SEQ-NO                             
                  ,:S-RS5-RT-ATTR-INCTV-TYPE                            
                  ,:S-RS5-PRIMRY-OPT-ATTR-FL                            
                  ,:S-RS5-FACTOR-ID                                     
                  ,:S-RS5-DURATION-NO                                   
                  ,:S-RS5-APPL-PROGRAM-ID                               
                  ,:S-RS5-ATTR-INCTV-VALUE                              
                  ,:S-RS5-ATTR-INCTV-VAL-TX                             
                  ,:S-RS5-LAST-UPDATE-USERID                            
                  ,:S-RS5-LAST-UPDATE-TS                                
                  ,:S-RS5-GL-ACCT-CREDIT                                
                  ,:S-RS5-GL-ACCT-DEBIT                                 
                  ,:S-RS5-CATEGORY-ID                                   
                  ,:S-RS5-WQ-ROUTE-CATEGORY                             
                  ,:S-RS5-OPT-CHG-ACTION-CD                             
                  ,:S-RS5-ATTR-INCTV-STRT-DT                            
                  ,:S-RS5-ATTR-INCTV-END-DT                             
                  ,:S-RS5-OPT-ATTR-VRSN-NO                              
                  ,:S-RS5-OPT-ATTR-VSTART-TS                            
                  ,:S-RS5-OPT-ATTR-VEND-TS                              
                  ,:S-RS5-PROC-STATUS-CD                                
                  ,:S-RS5-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04431_R5                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,ATTR_INCTV_SEQ_NO                                            
MFA-TR*           ,RT_ATTR_INCTV_TYPE                                           
MFA-TR*           ,PRIMRY_OPT_ATTR_FL                                           
MFA-TR*           ,FACTOR_ID                                                    
MFA-TR*           ,DURATION_NO                                                  
MFA-TR*           ,APPL_PROGRAM_ID                                              
MFA-TR*           ,ATTR_INCTV_VALUE                                             
MFA-TR*           ,ATTR_INCTV_VAL_TX                                            
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,GL_ACCT_CREDIT                                               
MFA-TR*           ,GL_ACCT_DEBIT                                                
MFA-TR*           ,CATEGORY_ID                                                  
MFA-TR*           ,WQ_ROUTE_CATEGORY                                            
MFA-TR*           ,OPT_CHG_ACTION_CD                                            
MFA-TR*           ,ATTR_INCTV_STRT_DT                                           
MFA-TR*           ,ATTR_INCTV_END_DT                                            
MFA-TR*           ,OPT_ATTR_VRSN_NO                                             
MFA-TR*           ,OPT_ATTR_VSTART_TS                                           
MFA-TR*           ,OPT_ATTR_VEND_TS                                             
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-5                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-5                                        
MFA-TR*           ,:S-RS5-COMPANY-NO                                            
MFA-TR*           ,:S-RS5-OPTION-CD                                             
MFA-TR*           ,:S-RS5-ATTR-INCTV-SEQ-NO                                     
MFA-TR*           ,:S-RS5-RT-ATTR-INCTV-TYPE                                    
MFA-TR*           ,:S-RS5-PRIMRY-OPT-ATTR-FL                                    
MFA-TR*           ,:S-RS5-FACTOR-ID                                             
MFA-TR*           ,:S-RS5-DURATION-NO                                           
MFA-TR*           ,:S-RS5-APPL-PROGRAM-ID                                       
MFA-TR*           ,:S-RS5-ATTR-INCTV-VALUE                                      
MFA-TR*           ,:S-RS5-ATTR-INCTV-VAL-TX                                     
MFA-TR*           ,:S-RS5-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS5-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS5-GL-ACCT-CREDIT                                        
MFA-TR*           ,:S-RS5-GL-ACCT-DEBIT                                         
MFA-TR*           ,:S-RS5-CATEGORY-ID                                           
MFA-TR*           ,:S-RS5-WQ-ROUTE-CATEGORY                                     
MFA-TR*           ,:S-RS5-OPT-CHG-ACTION-CD                                     
MFA-TR*           ,:S-RS5-ATTR-INCTV-STRT-DT                                    
MFA-TR*           ,:S-RS5-ATTR-INCTV-END-DT                                     
MFA-TR*           ,:S-RS5-OPT-ATTR-VRSN-NO                                      
MFA-TR*           ,:S-RS5-OPT-ATTR-VSTART-TS                                    
MFA-TR*           ,:S-RS5-OPT-ATTR-VEND-TS                                      
MFA-TR*           ,:S-RS5-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS5-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R5 = 'Y'             
              ADD +1                         TO CTR-ROWS-RS5            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8030'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE 'Y'                       TO  WS-ERR-INSRT-R5        
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04431_R5'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
        8050-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 8060-INSERT-GTT-R6. OFFER_OPTION TABLE                         *        
      ******************************************************************        
       8060-INSERT-GTT-R6.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04431_R6                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,COMPANY_NO                                           
                  ,OFFER_CD                                             
                  ,OPTION_CD                                            
                  ,OPTION_SORT_SEQ_NO                                   
                  ,OFFER_OPT_START_DT                                   
                  ,OFFER_OPT_END_DT                                     
                  ,OFF_OPT_VRSN_NO                                      
                  ,OFF_OPT_VSTART_TS                                    
                  ,OFF_OPT_VEND_TS                                      
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
A04805            ,WEB_NEW_EXISTS_CD                                    
A04805            ,WEB_SIGN_UP_FL                                       
A04805            ,OFF_OPT_EXCLUDE_CD                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-6                                     
                  ,:S-APPL-RETURN-CODE-6                                
                  ,:S-RS6-COMPANY-NO                                    
                  ,:S-RS6-OFFER-CD                                      
                  ,:S-RS6-OPTION-CD                                     
                  ,:S-RS6-OPTION-SORT-SEQ-NO                            
                  ,:S-RS6-OFFER-OPT-START-DT                            
                  ,:S-RS6-OFFER-OPT-END-DT                              
                  ,:S-RS6-OFF-OPT-VRSN-NO                               
                  ,:S-RS6-OFF-OPT-VSTART-TS                             
                  ,:S-RS6-OFF-OPT-VEND-TS                               
                  ,:S-RS6-PROC-STATUS-CD                                
                  ,:S-RS6-PROC-REQ-ID                                   
A04805            ,:S-RS6-WEB-NEW-EXISTS-CD                             
A04805            ,:S-RS6-WEB-SIGN-UP-FL                                
A04805            ,:S-RS6-OFF-OPT-EXCLUDE-CD                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04431_R6                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,OPTION_SORT_SEQ_NO                                           
MFA-TR*           ,OFFER_OPT_START_DT                                           
MFA-TR*           ,OFFER_OPT_END_DT                                             
MFA-TR*           ,OFF_OPT_VRSN_NO                                              
MFA-TR*           ,OFF_OPT_VSTART_TS                                            
MFA-TR*           ,OFF_OPT_VEND_TS                                              
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,WEB_NEW_EXISTS_CD                                            
MFA-TR*           ,WEB_SIGN_UP_FL                                               
MFA-TR*           ,OFF_OPT_EXCLUDE_CD                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-6                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-6                                        
MFA-TR*           ,:S-RS6-COMPANY-NO                                            
MFA-TR*           ,:S-RS6-OFFER-CD                                              
MFA-TR*           ,:S-RS6-OPTION-CD                                             
MFA-TR*           ,:S-RS6-OPTION-SORT-SEQ-NO                                    
MFA-TR*           ,:S-RS6-OFFER-OPT-START-DT                                    
MFA-TR*           ,:S-RS6-OFFER-OPT-END-DT                                      
MFA-TR*           ,:S-RS6-OFF-OPT-VRSN-NO                                       
MFA-TR*           ,:S-RS6-OFF-OPT-VSTART-TS                                     
MFA-TR*           ,:S-RS6-OFF-OPT-VEND-TS                                       
MFA-TR*           ,:S-RS6-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS6-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS6-WEB-NEW-EXISTS-CD                                     
MFA-TR*           ,:S-RS6-WEB-SIGN-UP-FL                                        
MFA-TR*           ,:S-RS6-OFF-OPT-EXCLUDE-CD                                    
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R6 = 'Y'             
              ADD +1                         TO CTR-ROWS-RS6            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO  ABEND-PROGRAM          
              MOVE '8060'                    TO  ACTIVE-PARAGRAPH       
              MOVE SQLCODE                   TO  ABEND-SQLCODE          
              MOVE 'INSERT'                  TO  ABEND-FUNCTION         
              MOVE 'Y'                       TO  WS-ERR-INSRT-R5        
              MOVE SPACES                    TO  ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSR04431_R6'             TO  TABLE-1                
              MOVE SPACES                    TO  TABLE-ELEMENT-1        
              MOVE SPACES                    TO  HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
        8060-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE 0                          TO S-RETURN-CODE-1        
              MOVE 100                        TO S-APPL-RETURN-CODE-1   
              PERFORM 8010-INSERT-GTT-R1         THRU 8010-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE 0                          TO S-RETURN-CODE-2        
              MOVE 100                        TO S-APPL-RETURN-CODE-2   
              PERFORM 8020-INSERT-GTT-R2         THRU 8020-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE 0                          TO S-RETURN-CODE-3        
              MOVE 100                        TO S-APPL-RETURN-CODE-3   
              PERFORM 8030-INSERT-GTT-R3         THRU 8030-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE 0                          TO S-RETURN-CODE-4        
              MOVE 100                        TO S-APPL-RETURN-CODE-4   
              PERFORM 8040-INSERT-GTT-R4         THRU 8040-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS5 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE 0                          TO S-RETURN-CODE-5        
              MOVE 100                        TO S-APPL-RETURN-CODE-5   
              PERFORM 8050-INSERT-GTT-R5         THRU 8050-EXIT         
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS6 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-6                            
              MOVE 0                          TO S-RETURN-CODE-6        
              MOVE 100                        TO S-APPL-RETURN-CODE-6   
              PERFORM 8060-INSERT-GTT-R6         THRU 8060-EXIT         
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME                  TO ABEND-PROGRAM          
           MOVE '8900'                        TO ACTIVE-PARAGRAPH       
           MOVE 'OPEN'                        TO ABEND-FUNCTION         
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                    TO ABEND-SQLCODE          
              MOVE SQLSTATE                   TO ABEND-SQLSTATE         
              MOVE 'CSR04431_R1'              TO TABLE-1                
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04431_R2'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04431_R3'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04431_R4'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04431_R5'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C6                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE                   TO ABEND-SQLCODE           
              MOVE SQLSTATE                  TO ABEND-SQLSTATE          
              MOVE 'CSR04431_R6'             TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE        TO ABEND-SQLCODE           
                                                S-RETURN-CODE-1         
                                                S-RETURN-CODE-2         
                                                S-RETURN-CODE-3         
                                                S-RETURN-CODE-4         
                                                S-RETURN-CODE-5         
                                                S-RETURN-CODE-6.        
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                               S-APPL-RETURN-CODE-3     
                                               S-APPL-RETURN-CODE-4     
                                               S-APPL-RETURN-CODE-5     
                                               S-APPL-RETURN-CODE-6.    
                                                                        
           MOVE SQLERRMC                     TO ABEND-SQLERRMC.         
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'                TO ABEND-FUNCTION          
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1         THRU 0100A-EXIT.        
           PERFORM 0100B-DECLARE-GTT-R2         THRU 0100B-EXIT.        
           PERFORM 0100C-DECLARE-GTT-R3         THRU 0100C-EXIT.        
           PERFORM 0100D-DECLARE-GTT-R4         THRU 0100D-EXIT.        
           PERFORM 0100E-DECLARE-GTT-R5         THRU 0100E-EXIT.        
           PERFORM 0100F-DECLARE-GTT-R6         THRU 0100F-EXIT.        
                                                                        
           PERFORM 8010-INSERT-GTT-R1           THRU 8010-EXIT.         
           PERFORM 8020-INSERT-GTT-R2           THRU 8020-EXIT.         
           PERFORM 8030-INSERT-GTT-R3           THRU 8030-EXIT.         
           PERFORM 8040-INSERT-GTT-R4           THRU 8040-EXIT.         
           PERFORM 8050-INSERT-GTT-R5           THRU 8050-EXIT.         
           PERFORM 8060-INSERT-GTT-R6           THRU 8060-EXIT.         
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT.         
           PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT.         
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS       THRU 8800-EXIT             
            PERFORM 8900-SEND-DONE           THRU 8900-EXIT             
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
