       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04427.                                      
COB303 DATE-WRITTEN.     MARCH 22, 2011.                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04427              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--  CSR04427 :                                                --         
      *--     RETRIEVE CRM RATE GROUP TABLE INFO  USED BY WIZARD#    --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--            I_APPLICATION_ID      CHAR(03)                  --         
      *--            I_USER_ID             CHAR(07)                  --         
      *--            I_OFFER_CODE          CHAR(12)                  --         
      *--            I_VERSION_NO          INTEGER                   --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SETS   2.                                          --         
      *--                                                            --         
      *--       WHEN TABLE-ID = F7 CRM_RATE_GROUP (RESULT SET1)      --         
      *--                       G5 & FG CRM_RATE_GRP_OFFER(RESULT SET2)-        
      *--                          & CRM_RT_PKG_OFFER(RESULT SET2)   --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00473*--  03/22/2011    SB93596     RETRIEVE CRM USER TABLE DETAILS --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04427'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04427 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01 WS-LITERALS.                                                  
          05 WS-SUBROUTINE-IDS.                                         
             10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'.   
          05 PROGRAM-NAME                 PIC X(08) VALUE 'CSR04427'.   
                                                                        
       01 COUNTER-FIELDS.                                               
          05 CTR-ROWS-R2A                 PIC S9(9) COMP VALUE 0.       
          05 CTR-ROWS-R2B                 PIC S9(9) COMP VALUE 0.       
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-SQLSTATE                  PIC X(05) VALUE SPACES.       
          05 WS-GTT-NAME                  PIC X(19) VALUE SPACES.       
          05 WS-APPL-RETURN-CODE          PIC S9(04) VALUE 0.           
          05 WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.       
          05 WS-VRSN-START-TS             PIC X(26) VALUE SPACES.       
          05 WS-VRSN-END-TS               PIC X(26) VALUE SPACES.       
          05 WS-CURRENT-DATE              PIC X(10) VALUE SPACES.       
          05 WS-OFF-STRT-DATE             PIC X(10) VALUE SPACES.       
          05 WS-OFF-END-DATE              PIC X(10) VALUE SPACES.       
          05 WS-INFINITE-END-TS           PIC X(26) VALUE               
                                    '2999-12-31-00.00.00.000000'.       
          05 WS-INFINITE-END-DT           PIC X(10) VALUE               
                                    '2999-12-31'.                       
                                                                        
       01 WS-SWITCHES.                                                  
          05 WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.         
             88 NO-MORE-ROWS                         VALUE 'Y'.         
          05 WS-NO-MORE-ROWS-OFFR-RATE     PIC X(01) VALUE 'N'.         
             88 NO-MORE-ROWS-OFFR-RATE               VALUE 'Y'.         
                                                                        
          05 SEND-DONE-SW                  PIC X(01) VALUE 'Y'.         
             88 SEND-DONE-ERROR                      VALUE 'N'.         
             88 SEND-DONE-OK                         VALUE 'Y'.         
      *                                                                         
       01 TDS-RETURN-FIELDS.                                            
          05 RS-RETURN-CODE                PIC S9(9) COMP VALUE 0.      
      *                                                                         
       01 WS-FLAGS.                                                     
          05 WS-ERR-INSRT-R                PIC X(01) VALUE 'N'.         
          05 WS-ERR-INSRT-R2               PIC X(01) VALUE 'N'.         
      *                                                                         
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01 CSRERLOG-P.                                                   
          10 S-SP-NAME                 PIC X(18) VALUE SPACES.          
          10 S-SQLCODE                 PIC S9(9) COMP VALUE 0.          
          10 S-SQLSTATE                PIC X(5)  VALUE ' '.             
          10 S-TABLE-NAME              PIC X(18) VALUE SPACES.          
          10 S-HOST-VARIABLES.                                          
             49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.            
             49  S-HOST-VARIABLES-V    PIC X(255).                      
          10 S-SQL-STATEMENT.                                           
             49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.            
             49  S-SQL-STATEMENT-V     PIC X(255).                      
          10 S-SQL-DESCRIPTION.                                         
             49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.            
             49  S-SQL-DESCRIPTION-V   PIC X(255).                      
          10 WS-ABEND-SQLERRMC.                                         
             49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.            
             49  WS-ABEND-SQLERRMC-V   PIC X(255).                      
                                                                        
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                    PIC S9(04) COMP VALUE 0.  
          05 S-APPL-RETURN-CODE               PIC S9(04) COMP VALUE 0.  
                                                                        
      *CRM_RATE_GROUP--F7                                                       
                                                                        
          05 GTT-RETURN-FIELDS-2A.                                      
             10 S-F7-COMPANY-NO               PIC X(02) VALUE SPACES.   
             10 S-F7-RATE-GROUP-TYPE-CD       PIC X(01) VALUE SPACES.   
             10 S-F7-RATE-GROUP-CD            PIC X(02) VALUE SPACES.   
             10 S-F7-RT-GRP-SORT-SEQ-NO       PIC S9(4) USAGE COMP.     
             10 S-F7-RATE-GRP-DESC            PIC X(50) VALUE SPACES.   
             10 S-F7-RATE-GRP-DESC-LONG       PIC X(255) VALUE SPACES.  
             10 S-F7-RT-GRP-START-DT          PIC X(10) VALUE SPACES.   
             10 S-F7-RT-GRP-END-DT            PIC X(10) VALUE SPACES.   
             10 S-F7-LAST-UPDATE-USERID       PIC X(07) VALUE SPACES.   
             10 S-F7-LAST-UPDATE-TS           PIC X(26) VALUE SPACES.   
                                                                        
      *CRM_RATE_GRP_OFFER--G5 CRM_RT_PKG_OFFER--FG                              
                                                                        
          05 GTT-RETURN-FIELDS-2B.                                      
             10 S-RETURN-CODE-1               PIC S9(4) USAGE COMP.     
             10 S-APPL-RETURN-CODE-1          PIC S9(04) COMP VALUE 0.  
             10 S-G5-COMPANY-NO               PIC X(02) VALUE SPACES.   
             10 S-G5-RATE-GROUP-TYPE-CD       PIC X(01) VALUE SPACES.   
             10 S-G5-RATE-GROUP-CD            PIC X(02) VALUE SPACES.   
             10 S-G5-SORT-SEQ-NO              PIC S9(4) USAGE COMP.     
             10 S-G5-EFF-START-DT             PIC X(10) VALUE SPACES.   
             10 S-G5-EFF-END-DT               PIC X(10) VALUE SPACES.   
             10 S-G5-OFFER-CD                 PIC X(12) VALUE SPACES.   
             10 S-G5-OPTION-CD                PIC X(12) VALUE SPACES.   
             10 S-G5-LAST-UPDATE-USERID       PIC X(07) VALUE SPACES.   
             10 S-G5-LAST-UPDATE-TS           PIC X(26) VALUE SPACES.   
             10 S-G5-GRP-OFF-VRSN-NO          PIC S9(4) USAGE COMP.     
             10 S-G5-GRP-OFF-VSTART-TS        PIC X(26) VALUE SPACES.   
             10 S-G5-GRP-OFF-VEND-TS          PIC X(26) VALUE SPACES.   
             10 S-G5-PROC-STATUS-CD           PIC X(02) VALUE SPACES.   
             10 S-G5-PROC-REQ-ID              PIC S9(10)V USAGE COMP.   
             10 S-FG-OFFER-DESC-INT           PIC X(50) VALUE SPACES.   
             10 S-FG-OFFER-DESC-EXT           PIC X(50) VALUE SPACES.   
             10 S-FG-PROMO-CD-INT-FL          PIC X(01) VALUE SPACES.   
             10 S-FG-PROMO-CD-EXT-FL          PIC X(01) VALUE SPACES.   
             10 S-FG-OFFER-START-DT           PIC X(10) VALUE SPACES.   
             10 S-FG-OFFER-END-DT             PIC X(10) VALUE SPACES.   
             10 S-FG-DISP-START-INT-TS        PIC X(26) VALUE SPACES.   
             10 S-FG-DISP-END-INT-TS          PIC X(26) VALUE SPACES.   
             10 S-FG-DISP-START-EXT-TS        PIC X(26) VALUE SPACES.   
             10 S-FG-DISP-END-EXT-TS          PIC X(26) VALUE SPACES.   
             10 S-FG-LAST-UPDATE-TS           PIC X(26) VALUE SPACES.   
             10 S-FG-LAST-UPDATE-USERID       PIC X(07) VALUE SPACES.   
             10 S-FG-OFFER-DESC-INT-LNG.                                
                49 S-FG-OFFR-DESC-INT-LNG-LEN                           
                                              PIC S9(4) USAGE COMP.     
                49 S-FG-OFFR-DESC-INT-LNG-TXT                           
                                              PIC X(255) VALUE SPACES.  
             10 S-FG-OFFER-DESC-EXT-LNG.                                
                49 S-FG-OFFR-DESC-EXT-LNG-LEN                           
                                              PIC S9(4) USAGE COMP.     
                49 S-FG-OFFR-DESC-EXT-LNG-TXT                           
                                              PIC X(255) VALUE SPACES.  
             10 S-FG-SPCL-OFFER-TYPE-CD       PIC X(02) VALUE SPACES.   
             10 S-FG-RENEWAL-OFFER-CD         PIC X(12) VALUE SPACES.   
             10 S-FG-RENEW-PUB-OFFER-CD       PIC X(01) VALUE SPACES.   
             10 S-FG-OFF-VRSN-NO              PIC S9(4) USAGE COMP.     
             10 S-FG-OFF-VSTART-TS            PIC X(26) VALUE SPACES.   
             10 S-FG-OFF-VEND-TS              PIC X(26) VALUE SPACES.   
             10 S-FG-PROC-STATUS-CD           PIC X(02) VALUE SPACES.   
             10 S-FG-PROC-REQ-ID              PIC S9(10)V USAGE COMP.   
                                                                        
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OFFER   (FG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GROUP     (F7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRATGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GRP_OFFER (G5)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH CRM_RATE_GROUP TABLEAILS.        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE RATE_GROUP_CUR CURSOR FOR                         
               SELECT COMPANY_NO                                        
                     ,RATE_GROUP_TYPE_CD                                
                     ,RATE_GROUP_CD                                     
                     ,RT_GRP_SORT_SEQ_NO                                
                     ,RATE_GRP_DESC                                     
                     ,RATE_GRP_DESC_LONG                                
                     ,RT_GRP_START_DT                                   
                     ,RT_GRP_END_DT                                     
                     ,LAST_UPDATE_USERID                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                 FROM CRM_RATE_GROUP F7 WITH(READUNCOMMITTED)                   
                WHERE RT_GRP_START_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                  AND RT_GRP_END_DT   >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                   
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RATE_GROUP_CUR CURSOR FOR                                 
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*              ,RATE_GROUP_TYPE_CD                                        
MFA-TR*              ,RATE_GROUP_CD                                             
MFA-TR*              ,RT_GRP_SORT_SEQ_NO                                        
MFA-TR*              ,RATE_GRP_DESC                                             
MFA-TR*              ,RATE_GRP_DESC_LONG                                        
MFA-TR*              ,RT_GRP_START_DT                                           
MFA-TR*              ,RT_GRP_END_DT                                             
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*          FROM CRM_RATE_GROUP F7                                         
MFA-TR*         WHERE RT_GRP_START_DT <= CURRENT DATE                           
MFA-TR*           AND RT_GRP_END_DT   >= CURRENT DATE                           
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH CRM_RATE_GROUP TABLEAILS.        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE OFFR_RATE_GRP_CUR CURSOR FOR                      
               SELECT G5.COMPANY_NO                                     
                     ,G5.RATE_GROUP_TYPE_CD                             
                     ,G5.RATE_GROUP_CD                                  
                     ,G5.SORT_SEQ_NO                                    
                     ,G5.EFF_START_DT                                   
                     ,G5.EFF_END_DT                                     
                     ,G5.OFFER_CD                                       
                     ,G5.OPTION_CD                                      
                     ,G5.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,G5.GRP_OFF_VRSN_NO                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.GRP_OFF_VSTART_TS, 121), ' ', '-'), ':', '.') 
           GRP_OFF_VSTART_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.GRP_OFF_VEND_TS, 121), ' ', '-'), ':', '.') 
           GRP_OFF_VEND_TS                                
                     ,G5.PROC_STATUS_CD                                 
                     ,G5.PROC_REQ_ID                                    
                     ,FG.OFFER_DESC_INT                                 
                     ,FG.OFFER_DESC_EXT                                 
                     ,FG.PROMO_CD_INT_FL                                
                     ,FG.PROMO_CD_EXT_FL                                
                     ,FG.OFFER_START_DT                                 
                     ,FG.OFFER_END_DT                                   
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_INT_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_INT_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_EXT_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_EXT_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FG.LAST_UPDATE_USERID                             
                     ,FG.OFFER_DESC_INT_LNG                             
                     ,FG.OFFER_DESC_EXT_LNG                             
                     ,FG.SPCL_OFFER_TYPE_CD                             
                     ,FG.RENEWAL_OFFER_CD                               
                     ,FG.RENEW_PUB_OFFER_CD                             
                     ,FG.OFF_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VSTART_TS
           , 121), ' ', '-'), ':', '.') OFF_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS
           , 121), ' ', '-'), ':', '.') OFF_VEND_TS                            
                     ,FG.PROC_STATUS_CD                                 
                     ,FG.PROC_REQ_ID                                    
                 FROM CRM_RATE_GRP_OFFER G5 WITH(READUNCOMMITTED)               
                     ,CRM_RT_PKG_OFFER   FG WITH(READUNCOMMITTED)               
                WHERE G5.COMPANY_NO         = :G5-COMPANY-NO            
                  AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD    
                  AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD         
                  AND ((G5.EFF_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-OFF-STRT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-STRT-DATE
              ) <> 0) OR (LEN(:WS-OFF-STRT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-OFF-STRT-DATE
              ), CONVERT(DATE, :WS-OFF-STRT-DATE) )       
                  AND   G5.EFF_END_DT        >= IIF(TRY_CONVERT(DATE, 
                                                      :WS-OFF-STRT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-STRT-DATE
              ) <> 0) OR (LEN(:WS-OFF-STRT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-OFF-STRT-DATE
              ), CONVERT(DATE, :WS-OFF-STRT-DATE) ) )     
                   OR  (G5.EFF_START_DT      >= IIF(TRY_CONVERT(DATE, 
                                                      :WS-OFF-STRT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-STRT-DATE
              ) <> 0) OR (LEN(:WS-OFF-STRT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-OFF-STRT-DATE
              ), CONVERT(DATE, :WS-OFF-STRT-DATE) )       
                  AND   G5.EFF_START_DT      <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-OFF-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-END-DATE
              ) <> 0) OR (LEN(:WS-OFF-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-OFF-END-DATE
              ), CONVERT(DATE, :WS-OFF-END-DATE) )  ))    
                  AND ((G5.GRP_OFF_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                      :WS-VRSN-START-TS
              )       
                  AND   G5.GRP_OFF_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                      :WS-VRSN-START-TS
              ) )     
                   OR  (G5.GRP_OFF_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                      :WS-VRSN-START-TS
              )       
                  AND   G5.GRP_OFF_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                        :WS-VRSN-END-TS
              )   ))    
                  AND FG.OFFER_CD             = G5.OFFER_CD             
                  AND FG.OFF_VRSN_NO          = (                       
                     SELECT MAX(F1.OFF_VRSN_NO)                         
                       FROM CRM_RT_PKG_OFFER F1 WITH(READUNCOMMITTED)           
                      WHERE F1.OFFER_CD = FG.OFFER_CD                   
                        AND ((FG.OFFER_START_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-OFF-STRT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-STRT-DATE
              ) <> 0) OR (LEN(:WS-OFF-STRT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-OFF-STRT-DATE
              ), CONVERT(DATE, :WS-OFF-STRT-DATE) )    
                        AND   FG.OFFER_END_DT   >= 
              IIF(TRY_CONVERT(DATE, :WS-OFF-STRT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-STRT-DATE
              ) <> 0) OR (LEN(:WS-OFF-STRT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-OFF-STRT-DATE
              ), CONVERT(DATE, :WS-OFF-STRT-DATE) ) )  
                         OR  (FG.OFFER_START_DT >= 
              IIF(TRY_CONVERT(DATE, :WS-OFF-STRT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-STRT-DATE
              ) <> 0) OR (LEN(:WS-OFF-STRT-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-OFF-STRT-DATE
              ), CONVERT(DATE, :WS-OFF-STRT-DATE) )    
                        AND   FG.OFFER_START_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-OFF-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OFF-END-DATE
              ) <> 0) OR (LEN(:WS-OFF-END-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-OFF-END-DATE
              ), CONVERT(DATE, :WS-OFF-END-DATE) )  )) 
                        AND ((FG.OFF_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                      :WS-VRSN-START-TS
              )    
                        AND   FG.OFF_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                      :WS-VRSN-START-TS
              ) )  
                         OR  (FG.OFF_VSTART_TS  >= CIS.CHAR2TIMESTAMP(
                                                      :WS-VRSN-START-TS
              )    
                        AND   FG.OFF_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                        :WS-VRSN-END-TS
              ) )))  
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OFFR_RATE_GRP_CUR CURSOR FOR                              
MFA-TR*        SELECT G5.COMPANY_NO                                             
MFA-TR*              ,G5.RATE_GROUP_TYPE_CD                                     
MFA-TR*              ,G5.RATE_GROUP_CD                                          
MFA-TR*              ,G5.SORT_SEQ_NO                                            
MFA-TR*              ,G5.EFF_START_DT                                           
MFA-TR*              ,G5.EFF_END_DT                                             
MFA-TR*              ,G5.OFFER_CD                                               
MFA-TR*              ,G5.OPTION_CD                                              
MFA-TR*              ,G5.LAST_UPDATE_USERID                                     
MFA-TR*              ,G5.LAST_UPDATE_TS                                         
MFA-TR*              ,G5.GRP_OFF_VRSN_NO                                        
MFA-TR*              ,G5.GRP_OFF_VSTART_TS                                      
MFA-TR*              ,G5.GRP_OFF_VEND_TS                                        
MFA-TR*              ,G5.PROC_STATUS_CD                                         
MFA-TR*              ,G5.PROC_REQ_ID                                            
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*              ,FG.OFFER_DESC_EXT                                         
MFA-TR*              ,FG.PROMO_CD_INT_FL                                        
MFA-TR*              ,FG.PROMO_CD_EXT_FL                                        
MFA-TR*              ,FG.OFFER_START_DT                                         
MFA-TR*              ,FG.OFFER_END_DT                                           
MFA-TR*              ,FG.DISP_START_INT_TS                                      
MFA-TR*              ,FG.DISP_END_INT_TS                                        
MFA-TR*              ,FG.DISP_START_EXT_TS                                      
MFA-TR*              ,FG.DISP_END_EXT_TS                                        
MFA-TR*              ,FG.LAST_UPDATE_TS                                         
MFA-TR*              ,FG.LAST_UPDATE_USERID                                     
MFA-TR*              ,FG.OFFER_DESC_INT_LNG                                     
MFA-TR*              ,FG.OFFER_DESC_EXT_LNG                                     
MFA-TR*              ,FG.SPCL_OFFER_TYPE_CD                                     
MFA-TR*              ,FG.RENEWAL_OFFER_CD                                       
MFA-TR*              ,FG.RENEW_PUB_OFFER_CD                                     
MFA-TR*              ,FG.OFF_VRSN_NO                                            
MFA-TR*              ,FG.OFF_VSTART_TS                                          
MFA-TR*              ,FG.OFF_VEND_TS                                            
MFA-TR*              ,FG.PROC_STATUS_CD                                         
MFA-TR*              ,FG.PROC_REQ_ID                                            
MFA-TR*          FROM CRM_RATE_GRP_OFFER G5                                     
MFA-TR*              ,CRM_RT_PKG_OFFER   FG                                     
MFA-TR*         WHERE G5.COMPANY_NO         = :G5-COMPANY-NO                    
MFA-TR*           AND G5.RATE_GROUP_TYPE_CD = :G5-RATE-GROUP-TYPE-CD            
MFA-TR*           AND G5.RATE_GROUP_CD      = :G5-RATE-GROUP-CD                 
MFA-TR*           AND ((G5.EFF_START_DT      <= :WS-OFF-STRT-DATE               
MFA-TR*           AND   G5.EFF_END_DT        >= :WS-OFF-STRT-DATE )             
MFA-TR*            OR  (G5.EFF_START_DT      >= :WS-OFF-STRT-DATE               
MFA-TR*           AND   G5.EFF_START_DT      <= :WS-OFF-END-DATE  ))            
MFA-TR*           AND ((G5.GRP_OFF_VSTART_TS <= :WS-VRSN-START-TS               
MFA-TR*           AND   G5.GRP_OFF_VEND_TS   >= :WS-VRSN-START-TS )             
MFA-TR*            OR  (G5.GRP_OFF_VSTART_TS >= :WS-VRSN-START-TS               
MFA-TR*           AND   G5.GRP_OFF_VSTART_TS <= :WS-VRSN-END-TS   ))            
MFA-TR*           AND FG.OFFER_CD             = G5.OFFER_CD                     
MFA-TR*           AND FG.OFF_VRSN_NO          = (                               
MFA-TR*              SELECT MAX(F1.OFF_VRSN_NO)                                 
MFA-TR*                FROM CRM_RT_PKG_OFFER F1                                 
MFA-TR*               WHERE F1.OFFER_CD = FG.OFFER_CD                           
MFA-TR*                 AND ((FG.OFFER_START_DT <= :WS-OFF-STRT-DATE            
MFA-TR*                 AND   FG.OFFER_END_DT   >= :WS-OFF-STRT-DATE )          
MFA-TR*                  OR  (FG.OFFER_START_DT >= :WS-OFF-STRT-DATE            
MFA-TR*                 AND   FG.OFFER_START_DT <= :WS-OFF-END-DATE  ))         
MFA-TR*                 AND ((FG.OFF_VSTART_TS  <= :WS-VRSN-START-TS            
MFA-TR*                 AND   FG.OFF_VEND_TS    >= :WS-VRSN-START-TS )          
MFA-TR*                  OR  (FG.OFF_VSTART_TS  >= :WS-VRSN-START-TS            
MFA-TR*                 AND   FG.OFF_VSTART_TS  <= :WS-VRSN-END-TS )))          
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*       QUERYNO 7160                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       LINKAGE SECTION.                                                 
       01 PARM-APPLICATION-ID      PIC  X(03).                          
       01 PARM-USER-ID             PIC  X(07).                          
       01 PARM-OFFER-CD            PIC  X(12).                          
       01 PARM-VERSION-NO          PIC S9(04) COMP VALUE 0.             
      *                                                                         
       PROCEDURE DIVISION USING PARM-APPLICATION-ID                     
                               ,PARM-USER-ID                            
                               ,PARM-OFFER-CD                           
                               ,PARM-VERSION-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100B-DECLARE-GTT-R2A  -  CRM_RT_GROUP.                        *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2A.                                           
                                                                        
           MOVE 'SESSION.CSR04427_R2A'      TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04427_R2A')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04427_R2A
              (                                                         
                  RETURN_CODE               INT                     
                 ,APPL_RETURN_CODE          INT                     
                 ,COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,RATE_GROUP_TYPE_CD CHAR(1)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,RATE_GROUP_CD CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,RT_GRP_SORT_SEQ_NO        SMALLINT                    
                 ,RATE_GRP_DESC CHAR(50)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,RATE_GRP_DESC_LONG CHAR(255)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                   
                 ,RT_GRP_START_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,RT_GRP_END_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,LAST_UPDATE_USERID CHAR(7)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                     
                 ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 800B1-DEL-GTT-ROWS    THRU 800B1-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                   CONTINUE                                             
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              DECLARE C2A CURSOR                             
                                WITH ROWSET POSITIONING FOR             
               SELECT RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO           
                     ,LTRIM(RTRIM(RATE_GROUP_TYPE_CD)) AS 
           RATE_GROUP_TYPE_CD   
                     ,LTRIM(RTRIM(RATE_GROUP_CD))      AS RATE_GROUP_CD        
                     ,RT_GRP_SORT_SEQ_NO                                
                     ,LTRIM(RTRIM(RATE_GRP_DESC))      AS RATE_GRP_DESC        
                     ,LTRIM(RTRIM(RATE_GRP_DESC_LONG)) AS 
           RATE_GRP_DESC_LONG   
                     ,RT_GRP_START_DT                                   
                     ,RT_GRP_END_DT                                     
                     ,LTRIM(RTRIM(LAST_UPDATE_USERID)) AS 
           LAST_UPDATE_USERID   
                     ,LTRIM(RTRIM(LAST_UPDATE_TS))     AS LAST_UPDATE_TS       
                 FROM #CSR04427_R2A                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2A CURSOR WITH RETURN                                    
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*        SELECT RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,STRIP(COMPANY_NO)         AS COMPANY_NO                   
MFA-TR*              ,STRIP(RATE_GROUP_TYPE_CD) AS RATE_GROUP_TYPE_CD           
MFA-TR*              ,STRIP(RATE_GROUP_CD)      AS RATE_GROUP_CD                
MFA-TR*              ,RT_GRP_SORT_SEQ_NO                                        
MFA-TR*              ,STRIP(RATE_GRP_DESC)      AS RATE_GRP_DESC                
MFA-TR*              ,STRIP(RATE_GRP_DESC_LONG) AS RATE_GRP_DESC_LONG           
MFA-TR*              ,RT_GRP_START_DT                                           
MFA-TR*              ,RT_GRP_END_DT                                             
MFA-TR*              ,STRIP(LAST_UPDATE_USERID) AS LAST_UPDATE_USERID           
MFA-TR*              ,STRIP(LAST_UPDATE_TS)     AS LAST_UPDATE_TS               
MFA-TR*          FROM SESSION.CSR04427_R2A                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 0110B-DECLARE-GTT-R2B  -  CRM_RT_GROUP.                        *        
      ******************************************************************        
       0110B-DECLARE-GTT-R2B.                                           
                                                                        
           MOVE 'SESSION.CSR04427_R2B'      TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04427_R2B')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04427_R2B
              (                                                         
                  RETURN_CODE               INT                     
                 ,APPL_RETURN_CODE          INT                     
                 ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,RATE_GROUP_TYPE_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,RATE_GROUP_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,SORT_SEQ_NO               SMALLINT                    
                 ,EFF_START_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,EFF_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
                 ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2            
                 ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
                 ,LAST_UPDATE_USERID_G5 CHAR(07)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,LAST_UPDATE_TS_G5 CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,GRP_OFF_VRSN_NO           SMALLINT                    
                 ,GRP_OFF_VSTART_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,GRP_OFF_VEND_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,PROC_STATUS_CD_G5 CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,PROC_REQ_ID_G5            DECIMAL(10)                 
                 ,OFFER_DESC_INT CHAR(50)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,OFFER_DESC_EXT CHAR(50)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,PROMO_CD_INT_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,PROMO_CD_EXT_FL CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,OFFER_START_DT CHAR(10)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,OFFER_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                 ,DISP_START_INT_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,DISP_END_INT_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,DISP_START_EXT_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,DISP_END_EXT_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,LAST_UPDATE_TS_FG CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,LAST_UPDATE_USERID_FG CHAR(07)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,OFFER_DESC_INT_LNG VARCHAR(255)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                
                 ,OFFER_DESC_EXT_LNG VARCHAR(255)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                
                 ,SPCL_OFFER_TYPE_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,RENEWAL_OFFER_CD CHAR(12)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,RENEW_PUB_OFFER_CD CHAR(01)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,OFF_VRSN_NO               SMALLINT                    
                 ,OFF_VSTART_TS CHAR(26)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,OFF_VEND_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
                 ,PROC_STATUS_CD CHAR(02)  COLLATE 
                               LATIN1_GENERAL_100_BIN2                    
                 ,PROC_REQ_ID               DECIMAL(10)                 
              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 800B2-DEL-GTT-ROWS    THRU 800B2-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                   CONTINUE                                             
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0110B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              DECLARE C2B CURSOR                             
                                WITH ROWSET POSITIONING FOR             
               SELECT RETURN_CODE                                       
                     ,APPL_RETURN_CODE                                  
                     ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO         
                     ,LTRIM(RTRIM(RATE_GROUP_TYPE_CD))   AS 
           RATE_GROUP_TYPE_CD 
                     ,LTRIM(RTRIM(RATE_GROUP_CD))        AS 
           RATE_GROUP_CD      
                     ,SORT_SEQ_NO                 AS SORT_SEQ_NO        
                     ,LTRIM(RTRIM(EFF_START_DT))         AS EFF_START_DT       
                     ,LTRIM(RTRIM(EFF_END_DT))           AS EFF_END_DT         
                     ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD           
                     ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD          
                     ,LTRIM(RTRIM(LAST_UPDATE_USERID_G5))                      
                                                AS LAST_UPDATE_USERID_G5
                     ,LTRIM(RTRIM(LAST_UPDATE_TS_G5))    AS 
           LAST_UPDATE_TS_G5  
                     ,GRP_OFF_VRSN_NO             AS GRP_OFF_VRSN_NO    
                     ,LTRIM(RTRIM(GRP_OFF_VSTART_TS))    AS 
           GRP_OFF_VSTART_TS  
                     ,LTRIM(RTRIM(GRP_OFF_VEND_TS))      AS 
           GRP_OFF_VEND_TS    
                     ,LTRIM(RTRIM(PROC_STATUS_CD_G5))    AS 
           PROC_STATUS_CD_G5  
                     ,PROC_REQ_ID_G5                                    
                     ,LTRIM(RTRIM(OFFER_DESC_INT))       AS 
           OFFER_DESC_INT     
                     ,LTRIM(RTRIM(OFFER_DESC_EXT))       AS 
           OFFER_DESC_EXT     
                     ,LTRIM(RTRIM(PROMO_CD_INT_FL))      AS 
           PROMO_CD_INT_FL    
                     ,LTRIM(RTRIM(PROMO_CD_EXT_FL))      AS 
           PROMO_CD_EXT_FL    
                     ,LTRIM(RTRIM(OFFER_START_DT))       AS 
           OFFER_START_DT     
                     ,LTRIM(RTRIM(OFFER_END_DT))         AS OFFER_END_DT       
                     ,LTRIM(RTRIM(DISP_START_INT_TS))    AS 
           DISP_START_INT_TS  
                     ,LTRIM(RTRIM(DISP_END_INT_TS))      AS 
           DISP_END_INT_TS    
                     ,LTRIM(RTRIM(DISP_START_EXT_TS))    AS 
           DISP_START_EXT_TS  
                     ,LTRIM(RTRIM(DISP_END_EXT_TS))      AS 
           DISP_END_EXT_TS    
                     ,LTRIM(RTRIM(LAST_UPDATE_TS_FG))    AS 
           LAST_UPDATE_TS_FG  
                     ,LTRIM(RTRIM(LAST_UPDATE_USERID_FG))                      
                                                AS LAST_UPDATE_USERID_FG
                     ,LTRIM(RTRIM(OFFER_DESC_INT_LNG))   AS 
           OFFER_DESC_INT_LNG 
                     ,LTRIM(RTRIM(OFFER_DESC_EXT_LNG))   AS 
           OFFER_DESC_EXT_LNG 
                     ,LTRIM(RTRIM(SPCL_OFFER_TYPE_CD))   AS 
           SPCL_OFFER_TYPE_CD 
                     ,LTRIM(RTRIM(RENEWAL_OFFER_CD))     AS 
           RENEWAL_OFFER_CD   
                     ,LTRIM(RTRIM(RENEW_PUB_OFFER_CD))   AS 
           RENEW_PUB_OFFER_CD 
                     ,OFF_VRSN_NO                 AS OFF_VRSN_NO        
                     ,LTRIM(RTRIM(OFF_VSTART_TS))        AS 
           OFF_VSTART_TS      
                     ,LTRIM(RTRIM(OFF_VEND_TS))          AS OFF_VEND_TS        
                     ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD     
                     ,PROC_REQ_ID                                       
                 FROM #CSR04427_R2B                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2B CURSOR WITH RETURN                                    
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*        SELECT RETURN_CODE                                               
MFA-TR*              ,APPL_RETURN_CODE                                          
MFA-TR*              ,STRIP(COMPANY_NO)           AS COMPANY_NO                 
MFA-TR*              ,STRIP(RATE_GROUP_TYPE_CD)   AS RATE_GROUP_TYPE_CD         
MFA-TR*              ,STRIP(RATE_GROUP_CD)        AS RATE_GROUP_CD              
MFA-TR*              ,SORT_SEQ_NO                 AS SORT_SEQ_NO                
MFA-TR*              ,STRIP(EFF_START_DT)         AS EFF_START_DT               
MFA-TR*              ,STRIP(EFF_END_DT)           AS EFF_END_DT                 
MFA-TR*              ,STRIP(OFFER_CD)             AS OFFER_CD                   
MFA-TR*              ,STRIP(OPTION_CD)            AS OPTION_CD                  
MFA-TR*              ,STRIP(LAST_UPDATE_USERID_G5)                              
MFA-TR*                                         AS LAST_UPDATE_USERID_G5        
MFA-TR*              ,STRIP(LAST_UPDATE_TS_G5)    AS LAST_UPDATE_TS_G5          
MFA-TR*              ,GRP_OFF_VRSN_NO             AS GRP_OFF_VRSN_NO            
MFA-TR*              ,STRIP(GRP_OFF_VSTART_TS)    AS GRP_OFF_VSTART_TS          
MFA-TR*              ,STRIP(GRP_OFF_VEND_TS)      AS GRP_OFF_VEND_TS            
MFA-TR*              ,STRIP(PROC_STATUS_CD_G5)    AS PROC_STATUS_CD_G5          
MFA-TR*              ,PROC_REQ_ID_G5                                            
MFA-TR*              ,STRIP(OFFER_DESC_INT)       AS OFFER_DESC_INT             
MFA-TR*              ,STRIP(OFFER_DESC_EXT)       AS OFFER_DESC_EXT             
MFA-TR*              ,STRIP(PROMO_CD_INT_FL)      AS PROMO_CD_INT_FL            
MFA-TR*              ,STRIP(PROMO_CD_EXT_FL)      AS PROMO_CD_EXT_FL            
MFA-TR*              ,STRIP(OFFER_START_DT)       AS OFFER_START_DT             
MFA-TR*              ,STRIP(OFFER_END_DT)         AS OFFER_END_DT               
MFA-TR*              ,STRIP(DISP_START_INT_TS)    AS DISP_START_INT_TS          
MFA-TR*              ,STRIP(DISP_END_INT_TS)      AS DISP_END_INT_TS            
MFA-TR*              ,STRIP(DISP_START_EXT_TS)    AS DISP_START_EXT_TS          
MFA-TR*              ,STRIP(DISP_END_EXT_TS)      AS DISP_END_EXT_TS            
MFA-TR*              ,STRIP(LAST_UPDATE_TS_FG)    AS LAST_UPDATE_TS_FG          
MFA-TR*              ,STRIP(LAST_UPDATE_USERID_FG)                              
MFA-TR*                                         AS LAST_UPDATE_USERID_FG        
MFA-TR*              ,STRIP(OFFER_DESC_INT_LNG)   AS OFFER_DESC_INT_LNG         
MFA-TR*              ,STRIP(OFFER_DESC_EXT_LNG)   AS OFFER_DESC_EXT_LNG         
MFA-TR*              ,STRIP(SPCL_OFFER_TYPE_CD)   AS SPCL_OFFER_TYPE_CD         
MFA-TR*              ,STRIP(RENEWAL_OFFER_CD)     AS RENEWAL_OFFER_CD           
MFA-TR*              ,STRIP(RENEW_PUB_OFFER_CD)   AS RENEW_PUB_OFFER_CD         
MFA-TR*              ,OFF_VRSN_NO                 AS OFF_VRSN_NO                
MFA-TR*              ,STRIP(OFF_VSTART_TS)        AS OFF_VSTART_TS              
MFA-TR*              ,STRIP(OFF_VEND_TS)          AS OFF_VEND_TS                
MFA-TR*              ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD             
MFA-TR*              ,PROC_REQ_ID                                               
MFA-TR*          FROM SESSION.CSR04427_R2B                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0110B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 0100B-DECLARE-GTT-R2A         THRU 0100B-EXIT        
           PERFORM 0110B-DECLARE-GTT-R2B         THRU 0110B-EXIT.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * PROCESS THE RECORDS FROM RATE GROUP CURSOR                    *         
      *****************************************************************         
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE WS-NO-MORE-ROWS.                                  
                                                                        
           PERFORM 7050-OPEN-RATE-GROUP-CUR       THRU 7050-EXIT.       
           PERFORM 7060-FETCH-RATE-GROUP-CUR      THRU 7060-EXIT.       
                                                                        
           PERFORM 2250-PROCESS-OFF-RATE-GROUP    THRU 2250-EXIT        
             UNTIL NO-MORE-ROWS.                                        
                                                                        
           PERFORM 7070-CLOSE-RATE-GROUP          THRU 7070-EXIT.       
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * PROCESS THE RECORDS FROM OFFER RATE GROUP CURSOR              *         
      *****************************************************************         
       2250-PROCESS-OFF-RATE-GROUP.                                     
                                                                        
           PERFORM 3000-MOVE-RATE-GROUP           THRU 3000-EXIT.       
                                                                        
           INITIALIZE  WS-NO-MORE-ROWS-OFFR-RATE.                       
                                                                        
           MOVE F7-RATE-GROUP-TYPE-CD          TO G5-RATE-GROUP-TYPE-CD 
           MOVE F7-RATE-GROUP-CD               TO G5-RATE-GROUP-CD      
           MOVE F7-COMPANY-NO                  TO G5-COMPANY-NO         
           MOVE PARM-OFFER-CD                  TO FG-OFFER-CD           
           MOVE PARM-VERSION-NO                TO FG-OFF-VRSN-NO        
                                                                        
           PERFORM 7010-GET-OFF-DATE-TS           THRU 7010-EXIT.       
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7020-GET-CURRNT-DT-TS THRU 7020-EXIT              
              MOVE WS-CURRENT-TIMESTAMP     TO WS-VRSN-START-TS         
              MOVE WS-INFINITE-END-TS       TO WS-VRSN-END-TS           
              MOVE WS-CURRENT-DATE          TO WS-OFF-STRT-DATE         
              MOVE WS-INFINITE-END-DT       TO WS-OFF-END-DATE          
           END-IF.                                                      
                                                                        
           PERFORM 7100-OPEN-OFFR-RATE-GRP-CUR    THRU 7100-EXIT.       
           PERFORM 7110-FETCH-OFFR-RATE-GRP-CUR   THRU 7110-EXIT.       
                                                                        
           PERFORM 3150-PROCESS-OFF-RATE-GROUP    THRU 3150-EXIT        
             UNTIL NO-MORE-ROWS-OFFR-RATE.                              
                                                                        
           PERFORM 7120-CLOSE-OFFR-RATE-GRP-CUR   THRU 7120-EXIT.       
                                                                        
           PERFORM 7060-FETCH-RATE-GROUP-CUR      THRU 7060-EXIT.       
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3000-MOVE-RATE-GROUP.                                                   
      ******************************************************************        
       3000-MOVE-RATE-GROUP.                                            
                                                                        
           MOVE F7-COMPANY-NO            TO S-F7-COMPANY-NO             
           MOVE F7-RATE-GROUP-TYPE-CD    TO S-F7-RATE-GROUP-TYPE-CD     
           MOVE F7-RATE-GROUP-CD         TO S-F7-RATE-GROUP-CD          
           MOVE F7-RT-GRP-SORT-SEQ-NO    TO S-F7-RT-GRP-SORT-SEQ-NO     
           MOVE F7-RATE-GRP-DESC         TO S-F7-RATE-GRP-DESC          
           MOVE F7-RATE-GRP-DESC-LONG    TO S-F7-RATE-GRP-DESC-LONG     
           MOVE F7-RT-GRP-START-DT       TO S-F7-RT-GRP-START-DT        
           MOVE F7-RT-GRP-END-DT         TO S-F7-RT-GRP-END-DT          
           MOVE F7-LAST-UPDATE-USERID    TO S-F7-LAST-UPDATE-USERID     
           MOVE F7-LAST-UPDATE-TS        TO S-F7-LAST-UPDATE-TS         
                                                                        
           PERFORM 8020-INSERT-GTT-R2A      THRU 8020-EXIT.             
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3150-PROCESS-OFF-RATE-GROUP                                             
      ******************************************************************        
       3150-PROCESS-OFF-RATE-GROUP.                                     
                                                                        
           MOVE G5-COMPANY-NO            TO S-G5-COMPANY-NO             
           MOVE G5-RATE-GROUP-TYPE-CD    TO S-G5-RATE-GROUP-TYPE-CD     
           MOVE G5-RATE-GROUP-CD         TO S-G5-RATE-GROUP-CD          
           MOVE G5-SORT-SEQ-NO           TO S-G5-SORT-SEQ-NO            
           MOVE G5-EFF-START-DT          TO S-G5-EFF-START-DT           
           MOVE G5-EFF-END-DT            TO S-G5-EFF-END-DT             
           MOVE G5-OFFER-CD              TO S-G5-OFFER-CD               
           MOVE G5-OPTION-CD             TO S-G5-OPTION-CD              
           MOVE G5-LAST-UPDATE-USERID    TO S-G5-LAST-UPDATE-USERID     
           MOVE G5-LAST-UPDATE-TS        TO S-G5-LAST-UPDATE-TS         
           MOVE G5-GRP-OFF-VRSN-NO       TO S-G5-GRP-OFF-VRSN-NO        
           MOVE G5-GRP-OFF-VSTART-TS     TO S-G5-GRP-OFF-VSTART-TS      
           MOVE G5-GRP-OFF-VEND-TS       TO S-G5-GRP-OFF-VEND-TS        
           MOVE G5-PROC-STATUS-CD        TO S-G5-PROC-STATUS-CD         
           MOVE G5-PROC-REQ-ID           TO S-G5-PROC-REQ-ID            
           MOVE FG-OFFER-DESC-INT        TO S-FG-OFFER-DESC-INT         
           MOVE FG-OFFER-DESC-EXT        TO S-FG-OFFER-DESC-EXT         
           MOVE FG-PROMO-CD-INT-FL       TO S-FG-PROMO-CD-INT-FL        
           MOVE FG-PROMO-CD-EXT-FL       TO S-FG-PROMO-CD-EXT-FL        
           MOVE FG-OFFER-START-DT        TO S-FG-OFFER-START-DT         
           MOVE FG-OFFER-END-DT          TO S-FG-OFFER-END-DT           
           MOVE FG-DISP-START-INT-TS     TO S-FG-DISP-START-INT-TS      
           MOVE FG-DISP-END-INT-TS       TO S-FG-DISP-END-INT-TS        
           MOVE FG-DISP-START-EXT-TS     TO S-FG-DISP-START-EXT-TS      
           MOVE FG-DISP-END-EXT-TS       TO S-FG-DISP-END-EXT-TS        
           MOVE FG-LAST-UPDATE-TS        TO S-FG-LAST-UPDATE-TS         
           MOVE FG-LAST-UPDATE-USERID    TO S-FG-LAST-UPDATE-USERID     
           MOVE FG-OFFER-DESC-INT-LNG    TO S-FG-OFFER-DESC-INT-LNG     
           MOVE FG-OFFER-DESC-EXT-LNG    TO S-FG-OFFER-DESC-EXT-LNG     
           MOVE FG-SPCL-OFFER-TYPE-CD    TO S-FG-SPCL-OFFER-TYPE-CD     
           MOVE FG-RENEWAL-OFFER-CD      TO S-FG-RENEWAL-OFFER-CD       
           MOVE FG-RENEW-PUB-OFFER-CD    TO S-FG-RENEW-PUB-OFFER-CD     
           MOVE FG-OFF-VRSN-NO           TO S-FG-OFF-VRSN-NO            
           MOVE FG-OFF-VSTART-TS         TO S-FG-OFF-VSTART-TS          
           MOVE FG-OFF-VEND-TS           TO S-FG-OFF-VEND-TS            
           MOVE FG-PROC-STATUS-CD        TO S-FG-PROC-STATUS-CD         
           MOVE FG-PROC-REQ-ID           TO S-FG-PROC-REQ-ID            
                                                                        
           PERFORM 8025-INSERT-GTT-R2B      THRU 8025-EXIT.             
           PERFORM 7110-FETCH-OFFR-RATE-GRP-CUR                         
                                            THRU 7110-EXIT.             
                                                                        
       3150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7010-GET-OFF-DATE-TS.                                                   
      ******************************************************************        
       7010-GET-OFF-DATE-TS.                                            
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.OFF_VSTART_TS, 121), ' ', '-'), ':', '.') OFF_VSTART_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS, 121), 
           ' ', '-'), ':', '.') OFF_VEND_TS,
              FG.OFFER_START_DT,
              FG.OFFER_END_DT                                    
               INTO  :WS-VRSN-START-TS                                  
                    ,:WS-VRSN-END-TS                                    
                    ,:WS-OFF-STRT-DATE                                  
                    ,:WS-OFF-END-DATE                                   
               FROM  CRM_RT_PKG_OFFER FG                                
              WHERE  FG.OFFER_CD    = :FG-OFFER-CD                      
                AND  FG.OFF_VRSN_NO = :FG-OFF-VRSN-NO                   
                                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT FG.OFF_VSTART_TS                                           
MFA-TR*             ,FG.OFF_VEND_TS                                             
MFA-TR*             ,FG.OFFER_START_DT                                          
MFA-TR*             ,FG.OFFER_END_DT                                            
MFA-TR*        INTO  :WS-VRSN-START-TS                                          
MFA-TR*             ,:WS-VRSN-END-TS                                            
MFA-TR*             ,:WS-OFF-STRT-DATE                                          
MFA-TR*             ,:WS-OFF-END-DATE                                           
MFA-TR*        FROM  CRM_RT_PKG_OFFER FG                                        
MFA-TR*       WHERE  FG.OFFER_CD    = :FG-OFFER-CD                              
MFA-TR*         AND  FG.OFF_VRSN_NO = :FG-OFF-VRSN-NO                           
MFA-TR*    FETCH FIRST ROW ONLY                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                    CONTINUE                                            
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7010'             TO ACTIVE-PARAGRAPH         
                    MOVE 'SELECT'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_RT_PKG_OFFER' TO TABLE-1                  
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7020-GET-CURRNT-DT-TS.                                                  
      ******************************************************************        
       7020-GET-CURRNT-DT-TS.                                           
                                                                        
           MOVE '7020'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*             ,:WS-CURRENT-DATE      = CURRENT DATE                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7020'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7050-OPEN-RATE-GROUP-CUR.                                               
      ******************************************************************        
       7050-OPEN-RATE-GROUP-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN RATE_GROUP_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RATE_GROUP'         TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7060-FETCH-RATE-GROUP-CUR.                                   *          
      *****************************************************************         
       7060-FETCH-RATE-GROUP-CUR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH RATE_GROUP_CUR                                      
               INTO :F7-COMPANY-NO                                      
                   ,:F7-RATE-GROUP-TYPE-CD                              
                   ,:F7-RATE-GROUP-CD                                   
                   ,:F7-RT-GRP-SORT-SEQ-NO                              
                   ,:F7-RATE-GRP-DESC                                   
                   ,:F7-RATE-GRP-DESC-LONG                              
                   ,:F7-RT-GRP-START-DT                                 
                   ,:F7-RT-GRP-END-DT                                   
                   ,:F7-LAST-UPDATE-USERID                              
                   ,:F7-LAST-UPDATE-TS                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-ROWS  TO TRUE                           
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7060'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_RATE_GROUP'   TO TABLE-1                  
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  7070-CLOSE-RATE-GROUP.                                                 
      *****************************************************************         
        7070-CLOSE-RATE-GROUP.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE  RATE_GROUP_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7070'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RATE_GROUP'         TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                *        
      ******************************************************************        
      * 7100-OPEN-OFFR-RATE-GRP-CUR                                             
      ******************************************************************        
       7100-OPEN-OFFR-RATE-GRP-CUR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN OFFR_RATE_GRP_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7100'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RATE_GRP_OFFER'     TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 7110-FETCH-OFFR-RATE-GRP-CUR                                            
      *****************************************************************         
       7110-FETCH-OFFR-RATE-GRP-CUR.                                    
                                                                        
           EXEC SQL                                                     
              FETCH OFFR_RATE_GRP_CUR                                   
               INTO :G5-COMPANY-NO                                      
                   ,:G5-RATE-GROUP-TYPE-CD                              
                   ,:G5-RATE-GROUP-CD                                   
                   ,:G5-SORT-SEQ-NO                                     
                   ,:G5-EFF-START-DT                                    
                   ,:G5-EFF-END-DT                                      
                   ,:G5-OFFER-CD                                        
                   ,:G5-OPTION-CD                                       
                   ,:G5-LAST-UPDATE-USERID                              
                   ,:G5-LAST-UPDATE-TS                                  
                   ,:G5-GRP-OFF-VRSN-NO                                 
                   ,:G5-GRP-OFF-VSTART-TS                               
                   ,:G5-GRP-OFF-VEND-TS                                 
                   ,:G5-PROC-STATUS-CD                                  
                   ,:G5-PROC-REQ-ID                                     
                   ,:FG-OFFER-DESC-INT                                  
                   ,:FG-OFFER-DESC-EXT                                  
                   ,:FG-PROMO-CD-INT-FL                                 
                   ,:FG-PROMO-CD-EXT-FL                                 
                   ,:FG-OFFER-START-DT                                  
                   ,:FG-OFFER-END-DT                                    
                   ,:FG-DISP-START-INT-TS                               
                   ,:FG-DISP-END-INT-TS                                 
                   ,:FG-DISP-START-EXT-TS                               
                   ,:FG-DISP-END-EXT-TS                                 
                   ,:FG-LAST-UPDATE-TS                                  
                   ,:FG-LAST-UPDATE-USERID                              
                   ,:FG-OFFER-DESC-INT-LNG                              
                   ,:FG-OFFER-DESC-EXT-LNG                              
                   ,:FG-SPCL-OFFER-TYPE-CD                              
                   ,:FG-RENEWAL-OFFER-CD                                
                   ,:FG-RENEW-PUB-OFFER-CD                              
                   ,:FG-OFF-VRSN-NO                                     
                   ,:FG-OFF-VSTART-TS                                   
                   ,:FG-OFF-VEND-TS                                     
                   ,:FG-PROC-STATUS-CD                                  
                   ,:FG-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                                        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET NO-MORE-ROWS-OFFR-RATE TO TRUE                  
                    MOVE 0                    TO WS-ACTIVE-RETURN-CODE  
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7110'               TO ACTIVE-PARAGRAPH       
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CRM_RATE_GRP_OFFER' TO TABLE-1                
                    PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT         
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7120-CLOSE-OFFR-RATE-GRP-CUR                                  *         
      *****************************************************************         
       7120-CLOSE-OFFR-RATE-GRP-CUR.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE OFFR_RATE_GRP_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7120'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RATE_GRP_OFFER'     TO TABLE-1                  
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 800B1-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       800B1-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04427_R2A                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04427_R2A                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '800B1'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04427_R2A'     TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       800B1-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * 800B2-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       800B2-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04427_R2B                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04427_R2B                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '800B2'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04427_R2B'     TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       800B2-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      * 8020-INSERT-GTT-R2A                                                     
      ******************************************************************        
       8020-INSERT-GTT-R2A.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04427_R2A                          
              (                                                         
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,COMPANY_NO                                            
                 ,RATE_GROUP_TYPE_CD                                    
                 ,RATE_GROUP_CD                                         
                 ,RT_GRP_SORT_SEQ_NO                                    
                 ,RATE_GRP_DESC                                         
                 ,RATE_GRP_DESC_LONG                                    
                 ,RT_GRP_START_DT                                       
                 ,RT_GRP_END_DT                                         
                 ,LAST_UPDATE_USERID                                    
                 ,LAST_UPDATE_TS                                        
              )                                                         
              VALUES                                                    
              (                                                         
                  :S-RETURN-CODE                                        
                 ,:S-APPL-RETURN-CODE                                   
                 ,:S-F7-COMPANY-NO                                      
                 ,:S-F7-RATE-GROUP-TYPE-CD                              
                 ,:S-F7-RATE-GROUP-CD                                   
                 ,:S-F7-RT-GRP-SORT-SEQ-NO                              
                 ,:S-F7-RATE-GRP-DESC                                   
                 ,:S-F7-RATE-GRP-DESC-LONG                              
                 ,:S-F7-RT-GRP-START-DT                                 
                 ,:S-F7-RT-GRP-END-DT                                   
                 ,:S-F7-LAST-UPDATE-USERID                              
                 ,:S-F7-LAST-UPDATE-TS                                  
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04427_R2A                                  
MFA-TR*       (                                                                 
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,APPL_RETURN_CODE                                              
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,RATE_GROUP_TYPE_CD                                            
MFA-TR*          ,RATE_GROUP_CD                                                 
MFA-TR*          ,RT_GRP_SORT_SEQ_NO                                            
MFA-TR*          ,RATE_GRP_DESC                                                 
MFA-TR*          ,RATE_GRP_DESC_LONG                                            
MFA-TR*          ,RT_GRP_START_DT                                               
MFA-TR*          ,RT_GRP_END_DT                                                 
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,LAST_UPDATE_TS                                                
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*           :S-RETURN-CODE                                                
MFA-TR*          ,:S-APPL-RETURN-CODE                                           
MFA-TR*          ,:S-F7-COMPANY-NO                                              
MFA-TR*          ,:S-F7-RATE-GROUP-TYPE-CD                                      
MFA-TR*          ,:S-F7-RATE-GROUP-CD                                           
MFA-TR*          ,:S-F7-RT-GRP-SORT-SEQ-NO                                      
MFA-TR*          ,:S-F7-RATE-GRP-DESC                                           
MFA-TR*          ,:S-F7-RATE-GRP-DESC-LONG                                      
MFA-TR*          ,:S-F7-RT-GRP-START-DT                                         
MFA-TR*          ,:S-F7-RT-GRP-END-DT                                           
MFA-TR*          ,:S-F7-LAST-UPDATE-USERID                                      
MFA-TR*          ,:S-F7-LAST-UPDATE-TS                                          
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R   = 'Y'            
              ADD +1                        TO  CTR-ROWS-R2A            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8020'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'Y'                      TO  WS-ERR-INSRT-R          
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04427_R2A'           TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      * 8025-INSERT-GTT-R2B                                                     
      ******************************************************************        
       8025-INSERT-GTT-R2B.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04427_R2B                          
              (                                                         
                  RETURN_CODE                                           
                 ,APPL_RETURN_CODE                                      
                 ,COMPANY_NO                                            
                 ,RATE_GROUP_TYPE_CD                                    
                 ,RATE_GROUP_CD                                         
                 ,SORT_SEQ_NO                                           
                 ,EFF_START_DT                                          
                 ,EFF_END_DT                                            
                 ,OFFER_CD                                              
                 ,OPTION_CD                                             
                 ,LAST_UPDATE_USERID_G5                                 
                 ,LAST_UPDATE_TS_G5                                     
                 ,GRP_OFF_VRSN_NO                                       
                 ,GRP_OFF_VSTART_TS                                     
                 ,GRP_OFF_VEND_TS                                       
                 ,PROC_STATUS_CD_G5                                     
                 ,PROC_REQ_ID_G5                                        
                 ,OFFER_DESC_INT                                        
                 ,OFFER_DESC_EXT                                        
                 ,PROMO_CD_INT_FL                                       
                 ,PROMO_CD_EXT_FL                                       
                 ,OFFER_START_DT                                        
                 ,OFFER_END_DT                                          
                 ,DISP_START_INT_TS                                     
                 ,DISP_END_INT_TS                                       
                 ,DISP_START_EXT_TS                                     
                 ,DISP_END_EXT_TS                                       
                 ,LAST_UPDATE_TS_FG                                     
                 ,LAST_UPDATE_USERID_FG                                 
                 ,OFFER_DESC_INT_LNG                                    
                 ,OFFER_DESC_EXT_LNG                                    
                 ,SPCL_OFFER_TYPE_CD                                    
                 ,RENEWAL_OFFER_CD                                      
                 ,RENEW_PUB_OFFER_CD                                    
                 ,OFF_VRSN_NO                                           
                 ,OFF_VSTART_TS                                         
                 ,OFF_VEND_TS                                           
                 ,PROC_STATUS_CD                                        
                 ,PROC_REQ_ID                                           
              )                                                         
              VALUES                                                    
              (                                                         
                  :S-RETURN-CODE-1                                      
                 ,:S-APPL-RETURN-CODE-1                                 
                 ,:S-G5-COMPANY-NO                                      
                 ,:S-G5-RATE-GROUP-TYPE-CD                              
                 ,:S-G5-RATE-GROUP-CD                                   
                 ,:S-G5-SORT-SEQ-NO                                     
                 ,:S-G5-EFF-START-DT                                    
                 ,:S-G5-EFF-END-DT                                      
                 ,:S-G5-OFFER-CD                                        
                 ,:S-G5-OPTION-CD                                       
                 ,:S-G5-LAST-UPDATE-USERID                              
                 ,:S-G5-LAST-UPDATE-TS                                  
                 ,:S-G5-GRP-OFF-VRSN-NO                                 
                 ,:S-G5-GRP-OFF-VSTART-TS                               
                 ,:S-G5-GRP-OFF-VEND-TS                                 
                 ,:S-G5-PROC-STATUS-CD                                  
                 ,:S-G5-PROC-REQ-ID                                     
                 ,:S-FG-OFFER-DESC-INT                                  
                 ,:S-FG-OFFER-DESC-EXT                                  
                 ,:S-FG-PROMO-CD-INT-FL                                 
                 ,:S-FG-PROMO-CD-EXT-FL                                 
                 ,:S-FG-OFFER-START-DT                                  
                 ,:S-FG-OFFER-END-DT                                    
                 ,:S-FG-DISP-START-INT-TS                               
                 ,:S-FG-DISP-END-INT-TS                                 
                 ,:S-FG-DISP-START-EXT-TS                               
                 ,:S-FG-DISP-END-EXT-TS                                 
                 ,:S-FG-LAST-UPDATE-TS                                  
                 ,:S-FG-LAST-UPDATE-USERID                              
                 ,:S-FG-OFFER-DESC-INT-LNG                              
                 ,:S-FG-OFFER-DESC-EXT-LNG                              
                 ,:S-FG-SPCL-OFFER-TYPE-CD                              
                 ,:S-FG-RENEWAL-OFFER-CD                                
                 ,:S-FG-RENEW-PUB-OFFER-CD                              
                 ,:S-FG-OFF-VRSN-NO                                     
                 ,:S-FG-OFF-VSTART-TS                                   
                 ,:S-FG-OFF-VEND-TS                                     
                 ,:S-FG-PROC-STATUS-CD                                  
                 ,:S-FG-PROC-REQ-ID                                     
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04427_R2B                                  
MFA-TR*       (                                                                 
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,APPL_RETURN_CODE                                              
MFA-TR*          ,COMPANY_NO                                                    
MFA-TR*          ,RATE_GROUP_TYPE_CD                                            
MFA-TR*          ,RATE_GROUP_CD                                                 
MFA-TR*          ,SORT_SEQ_NO                                                   
MFA-TR*          ,EFF_START_DT                                                  
MFA-TR*          ,EFF_END_DT                                                    
MFA-TR*          ,OFFER_CD                                                      
MFA-TR*          ,OPTION_CD                                                     
MFA-TR*          ,LAST_UPDATE_USERID_G5                                         
MFA-TR*          ,LAST_UPDATE_TS_G5                                             
MFA-TR*          ,GRP_OFF_VRSN_NO                                               
MFA-TR*          ,GRP_OFF_VSTART_TS                                             
MFA-TR*          ,GRP_OFF_VEND_TS                                               
MFA-TR*          ,PROC_STATUS_CD_G5                                             
MFA-TR*          ,PROC_REQ_ID_G5                                                
MFA-TR*          ,OFFER_DESC_INT                                                
MFA-TR*          ,OFFER_DESC_EXT                                                
MFA-TR*          ,PROMO_CD_INT_FL                                               
MFA-TR*          ,PROMO_CD_EXT_FL                                               
MFA-TR*          ,OFFER_START_DT                                                
MFA-TR*          ,OFFER_END_DT                                                  
MFA-TR*          ,DISP_START_INT_TS                                             
MFA-TR*          ,DISP_END_INT_TS                                               
MFA-TR*          ,DISP_START_EXT_TS                                             
MFA-TR*          ,DISP_END_EXT_TS                                               
MFA-TR*          ,LAST_UPDATE_TS_FG                                             
MFA-TR*          ,LAST_UPDATE_USERID_FG                                         
MFA-TR*          ,OFFER_DESC_INT_LNG                                            
MFA-TR*          ,OFFER_DESC_EXT_LNG                                            
MFA-TR*          ,SPCL_OFFER_TYPE_CD                                            
MFA-TR*          ,RENEWAL_OFFER_CD                                              
MFA-TR*          ,RENEW_PUB_OFFER_CD                                            
MFA-TR*          ,OFF_VRSN_NO                                                   
MFA-TR*          ,OFF_VSTART_TS                                                 
MFA-TR*          ,OFF_VEND_TS                                                   
MFA-TR*          ,PROC_STATUS_CD                                                
MFA-TR*          ,PROC_REQ_ID                                                   
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*           :S-RETURN-CODE-1                                              
MFA-TR*          ,:S-APPL-RETURN-CODE-1                                         
MFA-TR*          ,:S-G5-COMPANY-NO                                              
MFA-TR*          ,:S-G5-RATE-GROUP-TYPE-CD                                      
MFA-TR*          ,:S-G5-RATE-GROUP-CD                                           
MFA-TR*          ,:S-G5-SORT-SEQ-NO                                             
MFA-TR*          ,:S-G5-EFF-START-DT                                            
MFA-TR*          ,:S-G5-EFF-END-DT                                              
MFA-TR*          ,:S-G5-OFFER-CD                                                
MFA-TR*          ,:S-G5-OPTION-CD                                               
MFA-TR*          ,:S-G5-LAST-UPDATE-USERID                                      
MFA-TR*          ,:S-G5-LAST-UPDATE-TS                                          
MFA-TR*          ,:S-G5-GRP-OFF-VRSN-NO                                         
MFA-TR*          ,:S-G5-GRP-OFF-VSTART-TS                                       
MFA-TR*          ,:S-G5-GRP-OFF-VEND-TS                                         
MFA-TR*          ,:S-G5-PROC-STATUS-CD                                          
MFA-TR*          ,:S-G5-PROC-REQ-ID                                             
MFA-TR*          ,:S-FG-OFFER-DESC-INT                                          
MFA-TR*          ,:S-FG-OFFER-DESC-EXT                                          
MFA-TR*          ,:S-FG-PROMO-CD-INT-FL                                         
MFA-TR*          ,:S-FG-PROMO-CD-EXT-FL                                         
MFA-TR*          ,:S-FG-OFFER-START-DT                                          
MFA-TR*          ,:S-FG-OFFER-END-DT                                            
MFA-TR*          ,:S-FG-DISP-START-INT-TS                                       
MFA-TR*          ,:S-FG-DISP-END-INT-TS                                         
MFA-TR*          ,:S-FG-DISP-START-EXT-TS                                       
MFA-TR*          ,:S-FG-DISP-END-EXT-TS                                         
MFA-TR*          ,:S-FG-LAST-UPDATE-TS                                          
MFA-TR*          ,:S-FG-LAST-UPDATE-USERID                                      
MFA-TR*          ,:S-FG-OFFER-DESC-INT-LNG                                      
MFA-TR*          ,:S-FG-OFFER-DESC-EXT-LNG                                      
MFA-TR*          ,:S-FG-SPCL-OFFER-TYPE-CD                                      
MFA-TR*          ,:S-FG-RENEWAL-OFFER-CD                                        
MFA-TR*          ,:S-FG-RENEW-PUB-OFFER-CD                                      
MFA-TR*          ,:S-FG-OFF-VRSN-NO                                             
MFA-TR*          ,:S-FG-OFF-VSTART-TS                                           
MFA-TR*          ,:S-FG-OFF-VEND-TS                                             
MFA-TR*          ,:S-FG-PROC-STATUS-CD                                          
MFA-TR*          ,:S-FG-PROC-REQ-ID                                             
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2  = 'Y'            
              ADD +1                        TO  CTR-ROWS-R2B            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO  ABEND-PROGRAM           
              MOVE '8025'                   TO  ACTIVE-PARAGRAPH        
              MOVE SQLCODE                  TO  ABEND-SQLCODE           
              MOVE 'INSERT'                 TO  ABEND-FUNCTION          
              MOVE 'Y'                      TO  WS-ERR-INSRT-R2         
              MOVE SPACES                   TO  ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSR04427_R2B'           TO  TABLE-1                 
              MOVE SPACES                   TO  TABLE-ELEMENT-1         
              MOVE SPACES                   TO  HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT         
           END-IF.                                                      
                                                                        
        8025-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-R2A <= 0 AND CTR-ROWS-R2B <= 0                   
                                                                        
              INITIALIZE GTT-RETURN-FIELDS                              
                                                                        
              MOVE 0                        TO S-RETURN-CODE            
              MOVE 100                      TO S-APPL-RETURN-CODE       
                                               S-APPL-RETURN-CODE-1     
              PERFORM 8020-INSERT-GTT-R2A        THRU 8020-EXIT         
              PERFORM 8025-INSERT-GTT-R2B        THRU 8025-EXIT         
                                                                        
           END-IF.                                                      
      *                                                                         
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
                EXEC SQL                                                
                   OPEN C2A                                             
                END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2A WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
                EXEC SQL                                                
                   OPEN C2B                                             
                END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2B WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE '8900'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE 'CSR04427_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE 'N'                         TO SEND-DONE-SW.            
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE            
                                               S-RETURN-CODE-1.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE       
                                               S-APPL-RETURN-CODE-1.    
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100B-DECLARE-GTT-R2A  THRU 0100B-EXIT               
           PERFORM 8020-INSERT-GTT-R2A    THRU 8020-EXIT                
                                                                        
           PERFORM 0110B-DECLARE-GTT-R2B  THRU 0110B-EXIT               
           PERFORM 8025-INSERT-GTT-R2B    THRU 8025-EXIT.               
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
