       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR04426.                                      
COB303 DATE-WRITTEN.     MARCH 14, 2011.                                
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR04426              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR04426 :                                                --         
      *--                                                            --         
      *--     RETRIEVE CRM TABLE INFORMATION FROM THE BELOW TABLES   --         
      *--     USED BY RPM WIZARDS.                                   --         
      *--                                                            --         
      *--       CRM_RT_PKG_OFFER                                     --         
      *--       CRM_RT_PKG_OPTION                                    --         
      *--       CRM_MKT_PROMOTION                                    --         
      *--       CRM_OFF_MKT_TIER                                     --         
      *--       CRM_OPT_ATTR_INCTV                                   --         
      *--       CRM_RATE_GRP_OFFER                                   --         
      *--       CRM_ACCESS_OFF_OPT                                   --         
      *--       CRM_OFFER_OPTION                                     --         
      *--                                                            --         
      *--  # APPL-RETURN-CODE.                                       --         
      *--   +1000 - INPUT IS INVALID                                 --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      INPUT                                                 --         
      *--             APPLICATION_ID      CHAR(03)                   --         
      *--             USER_ID             CHAR(07)                   --         
      *--             RESOURCE_ID         CHAR(32)                   --         
      *--             OFFER_CD            CHAR(12)                   --         
      *--             OPTION_CD           CHAR(12)                   --         
      *--             PROMO_CD            CHAR(12)                   --         
      *--             PENDING_FLAG        CHAR(01)                   --         
      *--             VERSION_NO          CHAR(02)                   --         
      *--             PROC_REQ_ID         DECIMAL(10,0)              --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--      1. CSR04426_R1 - OFFER CODE DEATILS                   --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           TABLE_ID                CHAR(02)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           OFFER_DESC_INT          CHAR(50)                 --         
      *--           OFFER_DESC_EXT          CHAR(50)                 --         
      *--           PROMO_CD_INT_FL         CHAR(01)                 --         
      *--           PROMO_CD_EXT_FL         CHAR(01)                 --         
      *--           OFFER_START_DT          CHAR(10)                 --         
      *--           OFFER_END_DT            CHAR(10)                 --         
      *--           DISP_START_INT_TS       CHAR(26)                 --         
      *--           DISP_END_INT_TS         CHAR(26)                 --         
      *--           DISP_START_EXT_TS       CHAR(26)                 --         
      *--           DISP_END_EXT_TS         CHAR(26)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           OFFER_DESC_INT_LNG      VARCHAR(255)             --         
      *--           OFFER_DESC_EXT_LNG      VARCHAR(255)             --         
      *--           SPCL_OFFER_TYPE_CD      CHAR(02)                 --         
      *--           RENEWAL_OFFER_CD        CHAR(12)                 --         
      *--           RENEW_PUB_OFFER_CD      CHAR(01)                 --         
      *--           OFF_VRSN_NO             SMALLINT                 --         
      *--           OFF_VSTART_TS           TIMESTMP                 --         
      *--           OFF_VEND_TS             TIMESTMP                 --         
      *--           PROC_STATUS_CD          CHAR(2)                  --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
      *--           TEMPLATE_OFFER          CHAR (12)                --         
      *--           SET_PROMO_FLGS          CHAR (01)                --         
      *--           UNDFLT_OFF_TIER_FLAG    CHAR (01)                --         
      *--           MAX_PRICE_OFFER_CD      CHAR (12)                --         
      *--                                                            --         
      *--    2. CSR04426_R2  OPTION CODE DETAILS                     --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           TABLE_ID                CHAR(02)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           CODE_UTIL_TYPE          CHAR(01)                 --         
      *--           RATE_PLAN_NO            CHAR(03)                 --         
      *--           OPTION_START_DT         CHAR(10)                 --         
      *--           OPTION_END_DT           CHAR(10)                 --         
      *--           OPT_DESC_INT            CHAR(50)                 --         
      *--           OPT_DESC_INT_LONG       VARCHAR(255)             --         
      *--           CURR_EXT_DESC_LONG      VARCHAR(255)             --         
      *--           RENEWAL_DESC_LONG       VARCHAR(255)             --         
      *--           WEB_DESC_LONG           VARCHAR(255)             --         
      *--           STATUS_CD               CHAR(01)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           OPT_CALC_TYPE_CD        CHAR(02)                 --         
      *--           WEB_MKT_DESC_LONG       VARCHAR(1024)            --         
      *--           OPT_VRSN_NO             SMALLINT                 --         
      *--           OPT_VSTART_TS           TIMESTMP                 --         
      *--           OPT_VEND_TS             TIMESTMP                 --         
      *--           PROC_STATUS_CD          CHAR(2)                  --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
A04805*--           OPTION_TYPE_DESC        CHAR(50)                 --         
PRJ892*--           AUTO_RENEWAL_FL         CHAR(01)                 --         
PRJ892*--           OPTION_PROMO_DESC       VARCHAR(255)             --         
      *--                                                            --         
      *--    3. CSR04426_R3 - ATTRIBUTE INCENTIVE DETAILS            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           TABLE_ID                CHAR(02)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           ATTR_INCTV_SEQ_NO       SMALLINT                 --         
      *--           RT_ATTR_INCTV_TYPE      CHAR(15)                 --         
      *--           PRIMRY_OPT_ATTR_FL      CHAR(01)                 --         
      *--           FACTOR_ID               CHAR(09)                 --         
      *--           DURATION_NO             SMALLINT                 --         
      *--           APPL_PROGRAM_ID         CHAR(09)                 --         
      *--           ATTR_INCTV_VALUE        DECIMAL(11,6)            --         
      *--           ATTR_INCTV_VAL_TX       CHAR(20)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           GL_ACCT_CREDIT          DECIMAL(7,4)             --         
      *--           GL_ACCT_DEBIT           DECIMAL(7,4)             --         
      *--           CATEGORY_ID             SMALLINT                 --         
      *--           WQ_ROUTE_CATEGORY       CHAR(01)                 --         
      *--           OPT_CHG_ACTION_CD       CHAR(01)                 --         
      *--           ATTR_INCTV_STRT_DT      CHAR(10)                 --         
      *--           ATTR_INCTV_END_DT       CHAR(10)                 --         
      *--                                                            --         
      *--    4. CSR04426_R4 - SECURED OFFER / OPTION                 --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           TABLE_ID                CHAR(02)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           CATEGORY_ID             INTEGER                  --         
      *--           ACCESS_START_DT         CHAR(10)                 --         
      *--           ACCESS_END_DT           CHAR(10)                 --         
      *--           VIEW_APPLY_CD           CHAR(01)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           COMMENTS_TX             CHAR(255)                --         
      *--                                                            --         
      *--    5. CSR04426_R5 - MARKETTING PROMOTION                   --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           TABLE_ID                CHAR(02)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           PROMO_CD                CHAR(12)                 --         
      *--           PROMO_DESC              CHAR(50)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           MKT_PLAN_CD             CHAR(12)                 --         
      *--           PROMO_START_DT          CHAR(10)                 --         
      *--           PROMO_START_TM          CHAR(08)                 --         
      *--           PROMO_END_DT            CHAR(10)                 --         
      *--           PROMO_END_TM            CHAR(08)                 --         
      *--           AD_CHANNEL_CD           CHAR(10)                 --         
      *--           PROMO_DESC_LONG         VARCHAR(255)             --         
      *--           EXT_LANDING_PG_URL      VARCHAR(255)             --         
      *--           PROMO_TYPE_CD           CHAR(02)                 --         
      *--           WEB_IMAGE_FILE_NM       VARCHAR(100)             --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           REPLACMNT_PROMO_CD      CHAR(12)                 --         
      *--           DISPLAY_END_DT          CHAR(10)                 --         
      *--           INT_LANDING_PG_URL      VARCHAR(255)             --         
      *--                                                            --         
      *--    6. CSR04426_R6 - MARKET TIER                            --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           TABLE_ID                CHAR(02)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           TIER_CUST_STAT_CD       CHAR(01)                 --         
      *--           TIER_ACCT_TYPE_CD       CHAR(01)                 --         
      *--           MKT_TIER_RANKING        SMALLINT                 --         
      *--           MKT_TIER_START_DT       CHAR(10)                 --         
      *--           OFFER_TIER_STRT_DT      CHAR(10)                 --         
      *--           MKT_TIER_APPLY_CD       CHAR(01)                 --         
      *--           TIER_DEFLT_OFFR_CD      CHAR(01)                 --         
      *--           OFFER_TIER_END_DT       CHAR(10)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--                                                            --         
      *--    7. CSR04426_R7 - RATE GRP OFFER                         --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           TABLE_ID                CHAR(02)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           RATE_GROUP_TYPE_CD      CHAR(01)                 --         
      *--           RATE_GROUP_CD           CHAR(02)                 --         
      *--           SORT_SEQ_NO             SMALLINT                 --         
      *--           EFF_START_DT            CHAR(10)                 --         
      *--           EFF_END_DT              CHAR(10)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--                                                            --         
      *--    8. CSR04426_R8 - OFFER_OPTION                           --         
      *--           RETURN_CODE             INTEGER                  --         
      *--           APPL_RETURN_CODE        INTEGER                  --         
      *--           TABLE_ID                CHAR(02)                 --         
      *--           COMPANY_NO              CHAR(02)                 --         
      *--           OFFER_CD                CHAR(12)                 --         
      *--           OPTION_CD               CHAR(12)                 --         
      *--           OPTION_SORT_SEQ_NO      SMALLINT                 --         
      *--           LAST_UPDATE_USERID      CHAR(07)                 --         
      *--           LAST_UPDATE_TS          CHAR(26)                 --         
      *--           OFFER_OPT_START_DT      CHAR(10)                 --         
      *--           OFFER_OPT_END_DT        CHAR(10)                 --         
      *--           OFF_OPT_VRSN_NO         SMALLINT                 --         
      *--           OFF_OPT_VSTART_TS       CHAR(26)                 --         
      *--           OFF_OPT_VEND_TS         CHAR(26)                 --         
      *--           PROC_STATUS_CD          CHAR(02)                 --         
      *--           PROC_REQ_ID             DECIMAL(10,0)            --         
A04805*--           WEB_NEW_EXISTS_CD       CHAR(1)                  --         
A04805*--           WEB_SIGN_UP_FL          CHAR(1)                  --         
A04805*--           OFF_OPT_EXCLUDE_CD      CHAR(1)                  --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
P00473*--  03/14/2011    MS93554     RETRIEVE CRM TABLE              --         
      *--                            INFORMATION USED BY WIZARD#     --         
PRJ473*--  06/19/2012    JC91900     RPM warranty tasks.             --         
PRJ680*--  02/12/2013    MS93554     A new column MAX_PRICE_OFFER_CD --         
      *--                            has been added into CRM table              
      *--                            CRM_RT_PKG_OFFER.                          
A04805*--  10/31/2013    MR7E794     ADD FIELDS TO TABLES            --         
      *--                            CRM_OFFER_OPTION ,                         
      *--                            CRM_RT_PKG_OPTION.                         
PRJ892*--  04/13/2015    SS95855     NEW COLUMNS ADDED TO TABLE      --         
      *--                            CRM_RT_PKG_OPTION.              --         
P00863*--  07/08/2015    SS45239     A new column RTCHG_PUB_OFFER_CD --         
      *--                            has been added into CRM table              
      *--                            CRM_RT_PKG_OFFER.                          
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04426'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                   PIC X(40) VALUE                    
            'WORKING STORAGE FOR CSR04426 STARTS HERE'.                 
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG                 PIC X(8)  VALUE 'CSRERLOG'. 
           05  PROGRAM-NAME                 PIC X(08) VALUE 'CSR04426'. 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS-RS1                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS2                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS3                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS4                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS5                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS6                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS7                 PIC S9(9) COMP VALUE 0.     
           05  CTR-ROWS-RS8                 PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-YES-NULL                  PIC S9(04) VALUE -1.        
           05  WS-YES                       PIC X(01)  VALUE 'Y'.       
           05  WS-NO                        PIC X(01)  VALUE 'N'.       
           05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
           05  WS-GTT-NAME                  PIC X(19) VALUE SPACES.     
           05  WS-CURRENT-TIMESTAMP         PIC X(26) VALUE SPACES.     
           05  WS-APPL-RETURN-CODE          PIC S9(04) VALUE 0.         
           05  WS-VERSION-START-TS          PIC X(26).                  
           05  WS-VERSION-END-TS            PIC X(26).                  
           05  WS-ACTIVE-START-DT           PIC X(10).                  
           05  WS-ACTIVE-END-DT             PIC X(10).                  
           05  WS-TEMPLATE-OFFER-EXIST      PIC X(01) VALUE 'N'.        
           05  WS-PROMO-PROC-STATUS-CD      PIC X(02) VALUE SPACES.     
           05  WS-TMPLT-OFF-TIER-EXIST      PIC X(01) VALUE 'N'.        
           05  WS-UNDFLT-OFF-TIER-FLAG      PIC X(01) VALUE 'N'.        
           05  WS-PROMO-START-DT-TM         PIC X(26) VALUE SPACES.     
           05  WS-SET-PROMO-FLGS            PIC X(01) VALUE 'N'.        
           05  WS-PROMO-REUSED-FLAG         PIC X(01) VALUE 'N'.        
           05  WS-PROMO-FIRST-FETCH         PIC X(01) VALUE 'Y'.        
           05  WS-PROMO-OFFER-CD            PIC X(12) VALUE SPACES.     
           05  WS-TEMPLATE-OFFER            PIC X(12) VALUE SPACES.     
PRJ473     05  WS-TEMPLATE-INT-DESC         PIC X(50) VALUE SPACES.     
PRJ473     05  WS-TEMPLATE-REN-OFFR         PIC X(12) VALUE SPACES.     
PRJ473     05  WS-TEMPLATE-EXT-DESC         PIC X(50) VALUE SPACES.     
PRJ473     05  WS-ORIG-PROMO-OFFER          PIC X(12) VALUE SPACES.     
COB305     05 WS-PROCESS-REQ-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.   
           05  WS-PROC-STATUS-NEW           PIC X(02) VALUE 'NW'.       
           05  WS-PROC-STATUS-PEND-APRVL    PIC X(02) VALUE 'PA'.       
           05  WS-PROC-STATUS-ERLY-APRVL    PIC X(02) VALUE 'EA'.       
           05  WS-PROC-STATUS-APRVL-CMPLT   PIC X(02) VALUE 'AC'.       
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-NULL-IND-01               PIC S9(04) COMP.            
           05  WS-NULL-IND-02               PIC S9(04) COMP.            
      *                                                                         
       01  WS-SWITCHES.                                                 
           05 WS-NO-MORE-ROWS               PIC X(01) VALUE 'N'.        
              88 NO-MORE-ROWS                         VALUE 'Y'.        
           05 WS-EOF-ATTR-CURSOR            PIC X(01) VALUE 'N'.        
              88 NO-MORE-ATTR-ROWS                    VALUE 'Y'.        
           05 WS-NO-MORE-OFFER-ROWS         PIC X(01) VALUE 'N'.        
              88 NO-MORE-OFFER-ROWS                   VALUE 'Y'.        
           05 WS-NO-MORE-OPTION-ROWS        PIC X(01) VALUE 'N'.        
              88 NO-MORE-OPTION-ROWS                  VALUE 'Y'.        
           05 WS-STATUS-FOR-OPTION          PIC X(01) VALUE 'N'.        
              88 ROW-FOUND-FOR-OPTION                 VALUE 'Y'.        
           05 WS-OFFER-FOUND-FL             PIC X(01) VALUE 'N'.        
              88 OFFER-FOUND                          VALUE 'Y'.        
              88 OFFER-NOT-FOUND                      VALUE 'N'.        
           05 WS-OPTION-FOUND-FL            PIC X(01) VALUE 'N'.        
              88 OPTION-FOUND                         VALUE 'Y'.        
              88 OPTION-NOT-FOUND                     VALUE 'N'.        
           05 WS-RPM003-WIZARD              PIC X(06) VALUE ' '.        
              88 CREATE-REPLACE-OFF-WIZARD            VALUE 'RPM003'.   
           05 WS-RPM-WIZARDS                PIC X(06) VALUE ' '.        
              88 CREATE-OFFER-WIZARD                  VALUE 'RPM001'.   
              88 MODIFY-OFFER-WIZARD                  VALUE 'RPM002'.   
              88 CREATE-REPLACE-OFFER-WIZARD          VALUE 'RPM003'.   
              88 MODIFY-OPTION-WIZARD                 VALUE 'RPM004'.   
              88 CREATE-PROMO-WIZARD                  VALUE 'RPM005'.   
              88 MODIFY-PROMO-WIZARD                  VALUE 'RPM006'.   
              88 VIEW-OPTION-WIZARD                   VALUE 'RPM013'.   
              88 VIEW-PROMOTION-WIZARD                VALUE 'RPM014'.   
      *                                                                         
       01  WS-FLAGS.                                                    
           05 WS-ERR-INSRT-R1               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R2               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R3               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R4               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R5               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R6               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R7               PIC X(01) VALUE 'N'.        
           05 WS-ERR-INSRT-R8               PIC X(01) VALUE 'N'.        
                                                                        
      ****************************************************************          
      *                                                              *          
      *    ERROR PROCESSING VARIABLES                                *          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01 GTT-RETURN-FIELDS.                                            
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CRM_RT_PKG_OFFER               *                 
      *********************************************************                 
          05 S-RETURN-CODE                  PIC S9(04) COMP VALUE 0.    
          05 GTT-RETURN-FIELDS-1.                                       
             10 S-RETURN-CODE-1             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-1        PIC S9(04) COMP VALUE 0.    
             10 S-RS1-TABLE-ID              PIC X(2).                   
             10 S-RS1-COMPANY-NO            PIC X(2).                   
             10 S-RS1-OFFER-CD              PIC X(12).                  
             10 S-RS1-OFFER-DESC-INT        PIC X(50).                  
             10 S-RS1-OFFER-DESC-EXT        PIC X(50).                  
             10 S-RS1-PROMO-CD-INT-FL       PIC X(1).                   
             10 S-RS1-PROMO-CD-EXT-FL       PIC X(1).                   
             10 S-RS1-OFFER-START-DT        PIC X(10).                  
             10 S-RS1-OFFER-END-DT          PIC X(10).                  
             10 S-RS1-DISP-START-INT-TS     PIC X(26).                  
             10 S-RS1-DISP-END-INT-TS       PIC X(26).                  
             10 S-RS1-DISP-START-EXT-TS     PIC X(26).                  
             10 S-RS1-DISP-END-EXT-TS       PIC X(26).                  
             10 S-RS1-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS1-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS1-OFFER-DESC-INT-LNG.                               
                49 S-RS1-OFFER-DESC-INT-LNG-LEN                         
                                            PIC S9(4)  USAGE COMP.      
                49 S-RS1-OFFER-DESC-INT-LNG-TEXT                        
                                            PIC X(255).                 
             10 S-RS1-OFFER-DESC-EXT-LNG.                               
                49 S-RS1-OFFER-DESC-EXT-LNG-LEN                         
                                            PIC S9(4)  USAGE COMP.      
                49 S-RS1-OFFER-DESC-EXT-LNG-TEXT                        
                                            PIC X(255).                 
             10 S-RS1-SPCL-OFFER-TYPE-CD    PIC X(2).                   
             10 S-RS1-RENEWAL-OFFER-CD      PIC X(12).                  
             10 S-RS1-RENEW-PUB-OFFER-CD    PIC X(1).                   
             10 S-RS1-OFF-VRSN-NO           PIC S9(4)  USAGE COMP.      
             10 S-RS1-OFF-VSTART-TS         PIC X(26).                  
             10 S-RS1-OFF-VEND-TS           PIC X(26).                  
             10 S-RS1-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS1-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
             10 S-RS1-TEMPLATE-OFFER        PIC X(12).                  
             10 S-RS1-SET-PROMO-FLGS        PIC X(01).                  
             10 S-RS1-UNDFLT-OFF-TIER-FLAG  PIC X(01).                  
PRJ473       10 S-RS1-TEMPLATE-INT-DESC     PIC X(50).                  
PRJ473       10 S-RS1-TEMPLATE-REN-OFFR     PIC X(12).                  
PRJ473       10 S-RS1-TEMPLATE-EXT-DESC     PIC X(50).                  
PRJ473       10 S-RS1-ORIG-PROMO-OFFER      PIC X(12).                  
PRJ680       10 S-RS1-MAX-PRICE-OFFER-CD    PIC X(12).                  
P00863       10 S-RS1-RTCHG-PUB-OFFER-CD    PIC X(12).                  
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CRM_RT_PKG_OPTION              *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-2.                                       
             10 S-RETURN-CODE-2             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-2        PIC S9(04) COMP VALUE 0.    
             10 S-RS2-TABLE-ID              PIC X(2).                   
             10 S-RS2-COMPANY-NO            PIC X(2).                   
             10 S-RS2-OPTION-CD             PIC X(12).                  
             10 S-RS2-CODE-UTIL-TYPE        PIC X(1).                   
             10 S-RS2-RATE-PLAN-NO          PIC X(3).                   
             10 S-RS2-OPTION-START-DT       PIC X(10).                  
             10 S-RS2-OPTION-END-DT         PIC X(10).                  
             10 S-RS2-OPT-DESC-INT          PIC X(50).                  
             10 S-RS2-OPT-DESC-INT-LONG.                                
                49 S-RS2-OPT-DESC-INT-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-OPT-DESC-INT-LONG-TEXT                         
                                            PIC X(255).                 
             10 S-RS2-CURR-EXT-DESC-LONG.                               
                49 S-RS2-CURR-EXT-DESC-LONG-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-CURR-EXT-DESC-LONG-TEXT                        
                                            PIC X(255).                 
             10 S-RS2-RENEWAL-DESC-LONG.                                
                49 S-RS2-RENEWAL-DESC-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-RENEWAL-DESC-LONG-TEXT                         
                                            PIC X(255).                 
             10 S-RS2-WEB-DESC-LONG.                                    
                49 S-RS2-WEB-DESC-LONG-LEN  PIC S9(4) USAGE COMP.       
                49 S-RS2-WEB-DESC-LONG-TEXT PIC X(255).                 
             10 S-RS2-STATUS-CD             PIC X(1).                   
             10 S-RS2-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS2-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS2-OPT-CALC-TYPE-CD      PIC X(2).                   
             10 S-RS2-WEB-MKT-DESC-LONG.                                
                49 S-RS2-WEB-MKT-DESC-LONG-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS2-WEB-MKT-DESC-LONG-TEXT                         
                                            PIC X(1024).                
             10 S-RS2-OPT-VRSN-NO           PIC S9(4) USAGE COMP.       
             10 S-RS2-OPT-VSTART-TS         PIC X(26).                  
             10 S-RS2-OPT-VEND-TS           PIC X(26).                  
             10 S-RS2-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS2-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
A04805       10 S-RS2-OPTION-TYPE-DESC      PIC X(50).                  
PRJ892       10 S-RS2-AUTO-RENEWAL-FL       PIC X(01).                  
PRJ892       10 S-RS2-OPTION-PROMO-DESC.                                
PRJ892          49 S-RS2-OPTION-PROMO-DESC-LEN  PIC S9(4) USAGE COMP.   
PRJ892          49 S-RS2-OPTION-PROMO-DESC-TEXT PIC X(255).             
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CRM_OPT_ATTR_INCTV             *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-3.                                       
             10 S-RETURN-CODE-3             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-3        PIC S9(04) COMP VALUE 0.    
             10 S-RS3-TABLE-ID              PIC X(2).                   
             10 S-RS3-COMPANY-NO            PIC X(2).                   
             10 S-RS3-OPTION-CD             PIC X(12).                  
             10 S-RS3-ATTR-INCTV-SEQ-NO     PIC S9(4) USAGE COMP.       
             10 S-RS3-RT-ATTR-INCTV-TYPE    PIC X(15).                  
             10 S-RS3-PRIMRY-OPT-ATTR-FL    PIC X(1).                   
             10 S-RS3-FACTOR-ID             PIC X(9).                   
             10 S-RS3-DURATION-NO           PIC S9(4) USAGE COMP.       
             10 S-RS3-APPL-PROGRAM-ID       PIC X(9).                   
COB305       10 S-RS3-ATTR-INCTV-VALUE        PIC S9(5)V9(6) 
COB305          USAGE COMP-3 VALUE 0.
             10 S-RS3-ATTR-INCTV-VAL-TX     PIC X(20).                  
             10 S-RS3-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS3-LAST-UPDATE-TS        PIC X(26).                  
COB305       10 S-RS3-GL-ACCT-CREDIT        PIC S9(3)V9(4) USAGE COMP-3 
COB305          VALUE 0.
COB305       10 S-RS3-GL-ACCT-DEBIT        PIC S9(3)V9(4) USAGE COMP-3 
COB305          VALUE 0.
             10 S-RS3-CATEGORY-ID           PIC S9(4) USAGE COMP.       
             10 S-RS3-WQ-ROUTE-CATEGORY     PIC X(1).                   
             10 S-RS3-OPT-CHG-ACTION-CD     PIC X(1).                   
             10 S-RS3-ATTR-INCTV-STRT-DT    PIC X(10).                  
             10 S-RS3-ATTR-INCTV-END-DT     PIC X(10).                  
             10 S-RS3-OPT-ATTR-VRSN-NO      PIC S9(4) USAGE COMP.       
             10 S-RS3-OPT-ATTR-VSTART-TS    PIC X(26).                  
             10 S-RS3-OPT-ATTR-VEND-TS      PIC X(26).                  
             10 S-RS3-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS3-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CRM_ACCESS_OFF_OPT            *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-4.                                       
             10 S-RETURN-CODE-4             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-4        PIC S9(04) COMP VALUE 0.    
             10 S-RS4-TABLE-ID              PIC X(2).                   
             10 S-RS4-COMPANY-NO            PIC X(2).                   
             10 S-RS4-OPTION-CD             PIC X(12).                  
             10 S-RS4-OFFER-CD              PIC X(12).                  
             10 S-RS4-CATEGORY-ID           PIC S9(9) USAGE COMP.       
             10 S-RS4-ACCESS-START-DT       PIC X(10).                  
             10 S-RS4-ACCESS-END-DT         PIC X(10).                  
             10 S-RS4-VIEW-APPLY-CD         PIC X(1).                   
             10 S-RS4-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS4-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS4-COMMENTS-TX           PIC X(255).                 
             10 S-RS4-ACCESS-VRSN-NO        PIC S9(4)  USAGE COMP.      
             10 S-RS4-ACCESS-VSTART-TS      PIC X(26).                  
             10 S-RS4-ACCESS-VEND-TS        PIC X(26).                  
             10 S-RS4-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS4-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CRM_MKT_PROMOTION             *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-5.                                       
             10 S-RETURN-CODE-5             PIC S9(04)  COMP VALUE 0.   
             10 S-APPL-RETURN-CODE-5        PIC S9(04) COMP VALUE 0.    
             10 S-RS5-TABLE-ID              PIC X(2).                   
             10 S-RS5-COMPANY-NO            PIC X(2).                   
             10 S-RS5-PROMO-CD              PIC X(12).                  
             10 S-RS5-PROMO-DESC            PIC X(50).                  
             10 S-RS5-OFFER-CD              PIC X(12).                  
             10 S-RS5-MKT-PLAN-CD           PIC X(12).                  
             10 S-RS5-PROMO-START-DT        PIC X(10).                  
             10 S-RS5-PROMO-START-TM        PIC X(8).                   
             10 S-RS5-PROMO-END-DT          PIC X(10).                  
             10 S-RS5-PROMO-END-TM          PIC X(8).                   
             10 S-RS5-AD-CHANNEL-CD         PIC X(10).                  
             10 S-RS5-PROMO-DESC-LONG.                                  
                49 S-RS5-PROMO-DESC-LONG-LEN   PIC S9(4) USAGE COMP.    
                49 S-RS5-PROMO-DESC-LONG-TEXT  PIC X(255).              
             10 S-RS5-EXT-LANDING-PG-URL.                               
                49 S-RS5-EXT-LANDING-PG-URL-LEN PIC S9(4) USAGE COMP.   
                49 S-RS5-EXT-LANDING-PG-URL-TEXT                        
                                            PIC X(255).                 
             10 S-RS5-PROMO-TYPE-CD         PIC X(2).                   
             10 S-RS5-WEB-IMAGE-FILE-NM.                                
                49 S-RS5-WEB-IMAGE-FILE-NM-LEN                          
                                            PIC S9(4) USAGE COMP.       
                49 S-RS5-WEB-IMAGE-FILE-NM-TEXT PIC X(100).             
             10 S-RS5-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS5-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS5-REPLACMNT-PROMO-CD    PIC X(12).                  
             10 S-RS5-DISPLAY-END-DT        PIC X(10).                  
             10 S-RS5-INT-LANDING-PG-URL.                               
                49 S-RS5-INT-LANDING-PG-URL-LEN                         
                                            PIC S9(4) USAGE COMP.       
                49 S-RS5-INT-LANDING-PG-URL-TEXT                        
                                            PIC X(255).                 
             10 S-RS5-PROMO-VRSN-NO         PIC S9(4)  USAGE COMP.      
             10 S-RS5-PROMO-VSTART-TS       PIC X(26).                  
             10 S-RS5-PROMO-VEND-TS         PIC X(26).                  
             10 S-RS5-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS5-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
             10 S-RS5-PROMO-REUSED-FLAG     PIC X(01).                  
             10 S-RS5-ORIG-PROMO-OFFER      PIC X(12).                  
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CRM_OFF_MKT_TIER              *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-6.                                       
             10 S-RETURN-CODE-6             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-6        PIC S9(04) COMP VALUE 0.    
             10 S-RS6-TABLE-ID              PIC X(2).                   
             10 S-RS6-COMPANY-NO            PIC X(2).                   
             10 S-RS6-OFFER-CD              PIC X(12).                  
             10 S-RS6-TIER-CUST-STAT-CD     PIC X(1).                   
             10 S-RS6-TIER-ACCT-TYPE-CD     PIC X(1).                   
             10 S-RS6-MKT-TIER-RANKING      PIC S9(4) USAGE COMP.       
             10 S-RS6-MKT-TIER-START-DT     PIC X(10).                  
             10 S-RS6-OFFER-TIER-STRT-DT    PIC X(10).                  
             10 S-RS6-MKT-TIER-APPLY-CD     PIC X(1).                   
             10 S-RS6-TIER-DEFLT-OFFR-CD    PIC X(1).                   
             10 S-RS6-OFFER-TIER-END-DT     PIC X(10).                  
             10 S-RS6-LAST-UPDATE-USERID    PIC X(7).                   
             10 S-RS6-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS6-OFF-TIER-VRSN-NO      PIC S9(4)  USAGE COMP.      
             10 S-RS6-OFF-TIER-VSTART-TS    PIC X(26).                  
             10 S-RS6-OFF-TIER-VEND-TS      PIC X(26).                  
             10 S-RS6-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS6-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CRM_RATE_GRP_OFFER            *                  
      *********************************************************                 
          05 GTT-RETURN-FIELDS-7.                                       
             10 S-RETURN-CODE-7             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-7        PIC S9(04) COMP VALUE 0.    
             10 S-RS7-TABLE-ID              PIC X(2).                   
             10 S-RS7-COMPANY-NO            PIC X(2).                   
             10 S-RS7-RATE-GROUP-TYPE-CD    PIC X(1).                   
             10 S-RS7-RATE-GROUP-CD         PIC X(2).                   
             10 S-RS7-SORT-SEQ-NO           PIC S9(4) USAGE COMP.       
             10 S-RS7-EFF-START-DT          PIC X(10).                  
             10 S-RS7-EFF-END-DT            PIC X(10).                  
             10 S-RS7-OFFER-CD              PIC X(12).                  
             10 S-RS7-OPTION-CD             PIC X(12).                  
             10 S-RS7-LAST-UPDATE-USERID    PIC X(07).                  
             10 S-RS7-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS7-GRP-OFF-VRSN-NO       PIC S9(4)  USAGE COMP.      
             10 S-RS7-GRP-OFF-VSTART-TS     PIC X(26).                  
             10 S-RS7-GRP-OFF-VEND-TS       PIC X(26).                  
             10 S-RS7-PROC-STATUS-CD        PIC X(06).                  
COB305       10 S-RS7-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
                                                                        
      *********************************************************                 
      *   GTT TABLE LAYOUT FOR CRM_OFFER_OPTION               *                 
      *********************************************************                 
          05 GTT-RETURN-FIELDS-8.                                       
             10 S-RETURN-CODE-8             PIC S9(04) COMP VALUE 0.    
             10 S-APPL-RETURN-CODE-8        PIC S9(04) COMP VALUE 0.    
             10 S-RS8-TABLE-ID              PIC X(2).                   
             10 S-RS8-COMPANY-NO            PIC X(2).                   
             10 S-RS8-OFFER-CD              PIC X(12).                  
             10 S-RS8-OPTION-CD             PIC X(12).                  
             10 S-RS8-OPTION-SORT-SEQ-NO    PIC S9(4) USAGE COMP.       
             10 S-RS8-LAST-UPDATE-USERID    PIC X(07).                  
             10 S-RS8-LAST-UPDATE-TS        PIC X(26).                  
             10 S-RS8-OFFER-OPT-START-DT    PIC X(10).                  
             10 S-RS8-OFFER-OPT-END-DT      PIC X(10).                  
             10 S-RS8-OFF-OPT-VRSN-NO       PIC S9(4) USAGE COMP.       
             10 S-RS8-OFF-OPT-VSTART-TS     PIC X(26).                  
             10 S-RS8-OFF-OPT-VEND-TS       PIC X(26).                  
             10 S-RS8-PROC-STATUS-CD        PIC X(2).                   
COB305       10 S-RS8-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 
COB305          VALUE 0.   
A04805       10 S-RS8-WEB-NEW-EXISTS-CD     PIC X(1).                   
A04805       10 S-RS8-WEB-SIGN-UP-FL        PIC X(1).                   
A04805       10 S-RS8-OFF-OPT-EXCLUDE-CD    PIC X(1).                   
                                                                        
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OPTION  (FI)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPKGO                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_ATTR_INCV   (G7)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTINCT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RT_PKG_OFFER   (FG)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTPOFF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFF_MKT_TIER   (DU)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFMKT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OFFER_OPTION   (E9)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOFFOPT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_OPT_ATTR_INCTV (HQ)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBOPTATT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_MKT_PROMOTION  (KM)                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMKTPRM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_ACCESS_OFF_OPT  (CI)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRMACC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CRM_RATE_GRP_OFFER  (G5)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBRTEGRP                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_PROCESS_REQ     (1P)                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBPRCREQ                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OFFER DETAILS BASED ON           *        
      *   OPTION CODE.                                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFFER_OPTION_CUR CURSOR FOR                      
                SELECT E9.COMPANY_NO                                    
                      ,E9.OFFER_CD                                      
                      ,E9.OPTION_CD                                     
                      ,E9.OPTION_SORT_SEQ_NO                            
                      ,E9.OPTION_URL_TX                                 
                      ,E9.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,E9.DROP_OPTION_CD                                
                      ,E9.OFFER_OPT_START_DT                            
                      ,E9.OFFER_OPT_END_DT                              
                      ,E9.OFF_OPT_VRSN_NO                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VSTART_TS                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VEND_TS                               
                      ,E9.PROC_STATUS_CD                                
                      ,E9.PROC_REQ_ID                                   
A04805                ,E9.WEB_NEW_EXISTS_CD                             
A04805                ,E9.WEB_SIGN_UP_FL                                
A04805                ,E9.OFF_OPT_EXCLUDE_CD                            
                  FROM CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)               
                 WHERE E9.OPTION_CD          = :E9-OPTION-CD            
                   AND ((E9.OFF_OPT_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )   
                     AND E9.OFF_OPT_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ) ) 
                     OR (E9.OFF_OPT_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )   
                     AND E9.OFF_OPT_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )  )) 
                   AND ((E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ) ) 
                     OR (E9.OFFER_OPT_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )  )) 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_OPTION_CUR CURSOR FOR                              
MFA-TR*         SELECT E9.COMPANY_NO                                            
MFA-TR*               ,E9.OFFER_CD                                              
MFA-TR*               ,E9.OPTION_CD                                             
MFA-TR*               ,E9.OPTION_SORT_SEQ_NO                                    
MFA-TR*               ,E9.OPTION_URL_TX                                         
MFA-TR*               ,E9.LAST_UPDATE_USERID                                    
MFA-TR*               ,E9.LAST_UPDATE_TS                                        
MFA-TR*               ,E9.DROP_OPTION_CD                                        
MFA-TR*               ,E9.OFFER_OPT_START_DT                                    
MFA-TR*               ,E9.OFFER_OPT_END_DT                                      
MFA-TR*               ,E9.OFF_OPT_VRSN_NO                                       
MFA-TR*               ,E9.OFF_OPT_VSTART_TS                                     
MFA-TR*               ,E9.OFF_OPT_VEND_TS                                       
MFA-TR*               ,E9.PROC_STATUS_CD                                        
MFA-TR*               ,E9.PROC_REQ_ID                                           
MFA-TR*               ,E9.WEB_NEW_EXISTS_CD                                     
MFA-TR*               ,E9.WEB_SIGN_UP_FL                                        
MFA-TR*               ,E9.OFF_OPT_EXCLUDE_CD                                    
MFA-TR*           FROM CRM_OFFER_OPTION  E9                                     
MFA-TR*          WHERE E9.OPTION_CD          = :E9-OPTION-CD                    
MFA-TR*            AND ((E9.OFF_OPT_VSTART_TS <= :WS-VERSION-START-TS           
MFA-TR*              AND E9.OFF_OPT_VEND_TS   >= :WS-VERSION-START-TS )         
MFA-TR*              OR (E9.OFF_OPT_VSTART_TS >= :WS-VERSION-START-TS           
MFA-TR*              AND E9.OFF_OPT_VSTART_TS <= :WS-VERSION-END-TS  ))         
MFA-TR*            AND ((E9.OFFER_OPT_START_DT <= :WS-ACTIVE-START-DT           
MFA-TR*              AND E9.OFFER_OPT_END_DT   >= :WS-ACTIVE-START-DT )         
MFA-TR*              OR (E9.OFFER_OPT_START_DT >= :WS-ACTIVE-START-DT           
MFA-TR*              AND E9.OFFER_OPT_START_DT <= :WS-ACTIVE-END-DT  ))         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7240                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OFFER  DETAILS BASED             *        
      *   OPTION CODE.                                                 *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE OFFER_DET_CUR CURSOR FOR                         
               SELECT FG.COMPANY_NO                                     
                     ,FG.OFFER_CD                                       
                     ,FG.OFFER_DESC_INT                                 
                     ,FG.OFFER_DESC_EXT                                 
                     ,FG.PROMO_CD_INT_FL                                
                     ,FG.PROMO_CD_EXT_FL                                
                     ,FG.OFFER_START_DT                                 
                     ,FG.OFFER_END_DT                                   
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_INT_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_INT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_INT_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_START_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_START_EXT_TS                              
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.DISP_END_EXT_TS, 121), ' ', '-'), ':', '.') 
           DISP_END_EXT_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FG.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FG.LAST_UPDATE_USERID                             
                     ,FG.OFFER_DESC_INT_LNG                             
                     ,FG.OFFER_DESC_EXT_LNG                             
                     ,FG.SPCL_OFFER_TYPE_CD                             
                     ,FG.RENEWAL_OFFER_CD                               
                     ,FG.RENEW_PUB_OFFER_CD                             
                     ,FG.OFF_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VSTART_TS
           , 121), ' ', '-'), ':', '.') OFF_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS
           , 121), ' ', '-'), ':', '.') OFF_VEND_TS                            
                     ,FG.PROC_STATUS_CD                                 
                     ,FG.PROC_REQ_ID                                    
PRJ680               ,FG.MAX_PRICE_OFFER_CD                             
P00863               ,FG.RTCHG_PUB_OFFER_CD                             
                 FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
                WHERE FG.OFFER_CD       = :FG-OFFER-CD                  
                  AND FG.COMPANY_NO     = :FG-COMPANY-NO                
                  AND ((FG.OFF_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )        
                    AND FG.OFF_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ) )      
                    OR (FG.OFF_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )        
                    AND FG.OFF_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )   ))     
                  AND ((FG.OFFER_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )        
                    AND FG.OFFER_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ) )      
                    OR (FG.OFFER_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )        
                    AND FG.OFFER_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )    ))    
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_DET_CUR CURSOR FOR                                 
MFA-TR*        SELECT FG.COMPANY_NO                                             
MFA-TR*              ,FG.OFFER_CD                                               
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*              ,FG.OFFER_DESC_EXT                                         
MFA-TR*              ,FG.PROMO_CD_INT_FL                                        
MFA-TR*              ,FG.PROMO_CD_EXT_FL                                        
MFA-TR*              ,FG.OFFER_START_DT                                         
MFA-TR*              ,FG.OFFER_END_DT                                           
MFA-TR*              ,FG.DISP_START_INT_TS                                      
MFA-TR*              ,FG.DISP_END_INT_TS                                        
MFA-TR*              ,FG.DISP_START_EXT_TS                                      
MFA-TR*              ,FG.DISP_END_EXT_TS                                        
MFA-TR*              ,FG.LAST_UPDATE_TS                                         
MFA-TR*              ,FG.LAST_UPDATE_USERID                                     
MFA-TR*              ,FG.OFFER_DESC_INT_LNG                                     
MFA-TR*              ,FG.OFFER_DESC_EXT_LNG                                     
MFA-TR*              ,FG.SPCL_OFFER_TYPE_CD                                     
MFA-TR*              ,FG.RENEWAL_OFFER_CD                                       
MFA-TR*              ,FG.RENEW_PUB_OFFER_CD                                     
MFA-TR*              ,FG.OFF_VRSN_NO                                            
MFA-TR*              ,FG.OFF_VSTART_TS                                          
MFA-TR*              ,FG.OFF_VEND_TS                                            
MFA-TR*              ,FG.PROC_STATUS_CD                                         
MFA-TR*              ,FG.PROC_REQ_ID                                            
MFA-TR*              ,FG.MAX_PRICE_OFFER_CD                                     
MFA-TR*              ,FG.RTCHG_PUB_OFFER_CD                                     
MFA-TR*          FROM CRM_RT_PKG_OFFER  FG                                      
MFA-TR*         WHERE FG.OFFER_CD       = :FG-OFFER-CD                          
MFA-TR*           AND FG.COMPANY_NO     = :FG-COMPANY-NO                        
MFA-TR*           AND ((FG.OFF_VSTART_TS <= :WS-VERSION-START-TS                
MFA-TR*             AND FG.OFF_VEND_TS   >= :WS-VERSION-START-TS )              
MFA-TR*             OR (FG.OFF_VSTART_TS >= :WS-VERSION-START-TS                
MFA-TR*             AND FG.OFF_VSTART_TS <= :WS-VERSION-END-TS   ))             
MFA-TR*           AND ((FG.OFFER_START_DT <= :WS-ACTIVE-START-DT                
MFA-TR*             AND FG.OFFER_END_DT   >= :WS-ACTIVE-START-DT )              
MFA-TR*             OR (FG.OFFER_START_DT >= :WS-ACTIVE-START-DT                
MFA-TR*             AND FG.OFFER_START_DT <= :WS-ACTIVE-END-DT    ))            
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7002                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH OPTION DETAILS BASED             *        
      *   OFFER CODE.                                                  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFFER_OPTION_CUR2 CURSOR FOR                     
                SELECT E9.COMPANY_NO                                    
                      ,E9.OFFER_CD                                      
                      ,E9.OPTION_CD                                     
                      ,E9.OPTION_SORT_SEQ_NO                            
                      ,E9.OPTION_URL_TX                                 
                      ,E9.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,E9.DROP_OPTION_CD                                
                      ,E9.OFFER_OPT_START_DT                            
                      ,E9.OFFER_OPT_END_DT                              
                      ,E9.OFF_OPT_VRSN_NO                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VSTART_TS                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           E9.OFF_OPT_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_OPT_VEND_TS                               
                      ,E9.PROC_STATUS_CD                                
                      ,E9.PROC_REQ_ID                                   
A04805                ,E9.WEB_NEW_EXISTS_CD                             
A04805                ,E9.WEB_SIGN_UP_FL                                
A04805                ,E9.OFF_OPT_EXCLUDE_CD                            
                  FROM CRM_OFFER_OPTION  E9 WITH(READUNCOMMITTED)               
                 WHERE E9.OFFER_CD    = :E9-OFFER-CD                    
                   AND E9.COMPANY_NO  = :E9-COMPANY-NO                  
                   AND ((E9.OFF_OPT_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )   
                     AND E9.OFF_OPT_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ) ) 
                     OR (E9.OFF_OPT_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )   
                     AND E9.OFF_OPT_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              ) ))  
                   AND ((E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND E9.OFFER_OPT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ) ) 
                     OR (E9.OFFER_OPT_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND E9.OFFER_OPT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )  )) 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFFER_OPTION_CUR2 CURSOR FOR                             
MFA-TR*         SELECT E9.COMPANY_NO                                            
MFA-TR*               ,E9.OFFER_CD                                              
MFA-TR*               ,E9.OPTION_CD                                             
MFA-TR*               ,E9.OPTION_SORT_SEQ_NO                                    
MFA-TR*               ,E9.OPTION_URL_TX                                         
MFA-TR*               ,E9.LAST_UPDATE_USERID                                    
MFA-TR*               ,E9.LAST_UPDATE_TS                                        
MFA-TR*               ,E9.DROP_OPTION_CD                                        
MFA-TR*               ,E9.OFFER_OPT_START_DT                                    
MFA-TR*               ,E9.OFFER_OPT_END_DT                                      
MFA-TR*               ,E9.OFF_OPT_VRSN_NO                                       
MFA-TR*               ,E9.OFF_OPT_VSTART_TS                                     
MFA-TR*               ,E9.OFF_OPT_VEND_TS                                       
MFA-TR*               ,E9.PROC_STATUS_CD                                        
MFA-TR*               ,E9.PROC_REQ_ID                                           
MFA-TR*               ,E9.WEB_NEW_EXISTS_CD                                     
MFA-TR*               ,E9.WEB_SIGN_UP_FL                                        
MFA-TR*               ,E9.OFF_OPT_EXCLUDE_CD                                    
MFA-TR*           FROM CRM_OFFER_OPTION  E9                                     
MFA-TR*          WHERE E9.OFFER_CD    = :E9-OFFER-CD                            
MFA-TR*            AND E9.COMPANY_NO  = :E9-COMPANY-NO                          
MFA-TR*            AND ((E9.OFF_OPT_VSTART_TS <= :WS-VERSION-START-TS           
MFA-TR*              AND E9.OFF_OPT_VEND_TS   >= :WS-VERSION-START-TS )         
MFA-TR*              OR (E9.OFF_OPT_VSTART_TS >= :WS-VERSION-START-TS           
MFA-TR*              AND E9.OFF_OPT_VSTART_TS <= :WS-VERSION-END-TS ))          
MFA-TR*            AND ((E9.OFFER_OPT_START_DT <= :WS-ACTIVE-START-DT           
MFA-TR*              AND E9.OFFER_OPT_END_DT   >= :WS-ACTIVE-START-DT )         
MFA-TR*              OR (E9.OFFER_OPT_START_DT >= :WS-ACTIVE-START-DT           
MFA-TR*              AND E9.OFFER_OPT_START_DT <= :WS-ACTIVE-END-DT  ))         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*           QUERYNO 7270                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CURSOR DECLARATION TO FETCH OPTION DETAILS BASED ON         *         
      *   OFFER CODE.                                                 *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
               DECLARE OPTION_DET_CUR CURSOR FOR                        
               SELECT FI.COMPANY_NO                                     
                     ,FI.OPTION_CD                                      
                     ,FI.CODE_UTIL_TYPE                                 
                     ,FI.RATE_PLAN_NO                                   
                     ,FI.OPTION_START_DT                                
                     ,FI.OPTION_END_DT                                  
                     ,FI.OPT_DESC_INT                                   
                     ,FI.OPT_DESC_INT_LONG                              
                     ,FI.CURR_EXT_DESC_LONG                             
                     ,FI.RENEWAL_DESC_LONG                              
                     ,FI.WEB_DESC_LONG                                  
                     ,FI.STATUS_CD                                      
                     ,FI.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FI.OPT_CALC_TYPE_CD                               
                     ,FI.WEB_MKT_DESC_LONG                              
                     ,FI.OPT_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VSTART_TS
           , 121), ' ', '-'), ':', '.') OPT_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VEND_TS
           , 121), ' ', '-'), ':', '.') OPT_VEND_TS                            
                     ,FI.PROC_STATUS_CD                                 
                     ,FI.PROC_REQ_ID                                    
A04805               ,FI.OPTION_TYPE_DESC                               
PRJ892               ,FI.AUTO_RENEWAL_FL                                
PRJ892               ,FI.OPTION_PROMO_DESC                              
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.OPTION_CD        = :FI-OPTION-CD               
                  AND FI.COMPANY_NO       = :FI-COMPANY-NO              
                  AND ((FI.OPT_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )      
                    AND FI.OPT_VEND_TS     >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ) )    
                    OR (FI.OPT_VSTART_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )      
                    AND FI.OPT_VSTART_TS   <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )   ))   
                  AND ((FI.OPTION_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )       
                    AND FI.OPTION_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )  )    
                    OR (FI.OPTION_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )       
                    AND FI.OPTION_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )    ))   
                 FOR READ ONLY                                  
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OPTION_DET_CUR CURSOR FOR                                
MFA-TR*        SELECT FI.COMPANY_NO                                             
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CODE_UTIL_TYPE                                         
MFA-TR*              ,FI.RATE_PLAN_NO                                           
MFA-TR*              ,FI.OPTION_START_DT                                        
MFA-TR*              ,FI.OPTION_END_DT                                          
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,FI.OPT_DESC_INT_LONG                                      
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,FI.RENEWAL_DESC_LONG                                      
MFA-TR*              ,FI.WEB_DESC_LONG                                          
MFA-TR*              ,FI.STATUS_CD                                              
MFA-TR*              ,FI.LAST_UPDATE_USERID                                     
MFA-TR*              ,FI.LAST_UPDATE_TS                                         
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.WEB_MKT_DESC_LONG                                      
MFA-TR*              ,FI.OPT_VRSN_NO                                            
MFA-TR*              ,FI.OPT_VSTART_TS                                          
MFA-TR*              ,FI.OPT_VEND_TS                                            
MFA-TR*              ,FI.PROC_STATUS_CD                                         
MFA-TR*              ,FI.PROC_REQ_ID                                            
MFA-TR*              ,FI.OPTION_TYPE_DESC                                       
MFA-TR*              ,FI.AUTO_RENEWAL_FL                                        
MFA-TR*              ,FI.OPTION_PROMO_DESC                                      
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.OPTION_CD        = :FI-OPTION-CD                       
MFA-TR*           AND FI.COMPANY_NO       = :FI-COMPANY-NO                      
MFA-TR*           AND ((FI.OPT_VSTART_TS   <= :WS-VERSION-START-TS              
MFA-TR*             AND FI.OPT_VEND_TS     >= :WS-VERSION-START-TS )            
MFA-TR*             OR (FI.OPT_VSTART_TS   >= :WS-VERSION-START-TS              
MFA-TR*             AND FI.OPT_VSTART_TS   <= :WS-VERSION-END-TS   ))           
MFA-TR*           AND ((FI.OPTION_START_DT <= :WS-ACTIVE-START-DT               
MFA-TR*             AND FI.OPTION_END_DT   >= :WS-ACTIVE-START-DT  )            
MFA-TR*             OR (FI.OPTION_START_DT >= :WS-ACTIVE-START-DT               
MFA-TR*             AND FI.OPTION_START_DT <= :WS-ACTIVE-END-DT    ))           
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7102                                                   
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *   CURSOR DECLARATION TO FETCH ATTRIBUTE INCENTIVE DETAILS     *         
      *   BASED ON OPTION CODE.                                       *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                     
              DECLARE ATTR_INCEN_CUR CURSOR FOR                         
               SELECT HQ.COMPANY_NO                                     
                     ,HQ.OPTION_CD                                      
                     ,HQ.ATTR_INCTV_SEQ_NO                              
                     ,HQ.RT_ATTR_INCTV_TYPE                             
                     ,HQ.PRIMRY_OPT_ATTR_FL                             
                     ,HQ.FACTOR_ID                                      
                     ,HQ.DURATION_NO                                    
                     ,HQ.APPL_PROGRAM_ID                                
                     ,HQ.ATTR_INCTV_VALUE                               
                     ,HQ.ATTR_INCTV_VAL_TX                              
                     ,HQ.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,HQ.GL_ACCT_CREDIT                                 
                     ,HQ.GL_ACCT_DEBIT                                  
                     ,HQ.CATEGORY_ID                                    
                     ,HQ.WQ_ROUTE_CATEGORY                              
                     ,HQ.OPT_CHG_ACTION_CD                              
                     ,HQ.ATTR_INCTV_STRT_DT                             
                     ,HQ.ATTR_INCTV_END_DT                              
                     ,HQ.OPT_ATTR_VRSN_NO                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.OPT_ATTR_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OPT_ATTR_VSTART_TS                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HQ.OPT_ATTR_VEND_TS, 121), ' ', '-'), ':', '.') 
           OPT_ATTR_VEND_TS                               
                     ,HQ.PROC_STATUS_CD                                 
                     ,HQ.PROC_REQ_ID                                    
                 FROM CRM_OPT_ATTR_INCTV  HQ WITH(READUNCOMMITTED)              
                WHERE HQ.OPTION_CD           = :HQ-OPTION-CD            
                  AND HQ.COMPANY_NO          = :HQ-COMPANY-NO           
                  AND ((HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )   
                    AND HQ.OPT_ATTR_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ) ) 
                    OR (HQ.OPT_ATTR_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )   
                    AND HQ.OPT_ATTR_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              ) ))  
                  AND ((HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )    
                    AND HQ.ATTR_INCTV_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )  ) 
                    OR (HQ.ATTR_INCTV_STRT_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )    
                    AND HQ.ATTR_INCTV_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )  ))  
                ORDER BY HQ.ATTR_INCTV_SEQ_NO                           
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE ATTR_INCEN_CUR CURSOR FOR                                 
MFA-TR*        SELECT HQ.COMPANY_NO                                             
MFA-TR*              ,HQ.OPTION_CD                                              
MFA-TR*              ,HQ.ATTR_INCTV_SEQ_NO                                      
MFA-TR*              ,HQ.RT_ATTR_INCTV_TYPE                                     
MFA-TR*              ,HQ.PRIMRY_OPT_ATTR_FL                                     
MFA-TR*              ,HQ.FACTOR_ID                                              
MFA-TR*              ,HQ.DURATION_NO                                            
MFA-TR*              ,HQ.APPL_PROGRAM_ID                                        
MFA-TR*              ,HQ.ATTR_INCTV_VALUE                                       
MFA-TR*              ,HQ.ATTR_INCTV_VAL_TX                                      
MFA-TR*              ,HQ.LAST_UPDATE_USERID                                     
MFA-TR*              ,HQ.LAST_UPDATE_TS                                         
MFA-TR*              ,HQ.GL_ACCT_CREDIT                                         
MFA-TR*              ,HQ.GL_ACCT_DEBIT                                          
MFA-TR*              ,HQ.CATEGORY_ID                                            
MFA-TR*              ,HQ.WQ_ROUTE_CATEGORY                                      
MFA-TR*              ,HQ.OPT_CHG_ACTION_CD                                      
MFA-TR*              ,HQ.ATTR_INCTV_STRT_DT                                     
MFA-TR*              ,HQ.ATTR_INCTV_END_DT                                      
MFA-TR*              ,HQ.OPT_ATTR_VRSN_NO                                       
MFA-TR*              ,HQ.OPT_ATTR_VSTART_TS                                     
MFA-TR*              ,HQ.OPT_ATTR_VEND_TS                                       
MFA-TR*              ,HQ.PROC_STATUS_CD                                         
MFA-TR*              ,HQ.PROC_REQ_ID                                            
MFA-TR*          FROM CRM_OPT_ATTR_INCTV  HQ                                    
MFA-TR*         WHERE HQ.OPTION_CD           = :HQ-OPTION-CD                    
MFA-TR*           AND HQ.COMPANY_NO          = :HQ-COMPANY-NO                   
MFA-TR*           AND ((HQ.OPT_ATTR_VSTART_TS <= :WS-VERSION-START-TS           
MFA-TR*             AND HQ.OPT_ATTR_VEND_TS   >= :WS-VERSION-START-TS )         
MFA-TR*             OR (HQ.OPT_ATTR_VSTART_TS >= :WS-VERSION-START-TS           
MFA-TR*             AND HQ.OPT_ATTR_VSTART_TS <= :WS-VERSION-END-TS ))          
MFA-TR*           AND ((HQ.ATTR_INCTV_STRT_DT <= :WS-ACTIVE-START-DT            
MFA-TR*             AND HQ.ATTR_INCTV_END_DT  >= :WS-ACTIVE-START-DT  )         
MFA-TR*             OR (HQ.ATTR_INCTV_STRT_DT >= :WS-ACTIVE-START-DT            
MFA-TR*             AND HQ.ATTR_INCTV_STRT_DT <= :WS-ACTIVE-END-DT  ))          
MFA-TR*         ORDER BY HQ.ATTR_INCTV_SEQ_NO                                   
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7120                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH SECURED OFFER / OPTION           *        
      *   DETAILS BASED ON OPTION CODE / OFFER CODE.                   *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE SECURED_OPT_CUR CURSOR FOR                        
               SELECT CI.COMPANY_NO                                     
                     ,CI.OPTION_CD                                      
                     ,CI.OFFER_CD                                       
                     ,CI.CATEGORY_ID                                    
                     ,CI.ACCESS_START_DT                                
                     ,CI.ACCESS_END_DT                                  
                     ,CI.VIEW_APPLY_CD                                  
                     ,CI.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,CI.COMMENTS_TX                                    
                     ,CI.ACCESS_VRSN_NO                                 
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.ACCESS_VSTART_TS, 121), ' ', '-'), ':', '.') 
           ACCESS_VSTART_TS                               
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           CI.ACCESS_VEND_TS, 121), ' ', '-'), ':', '.') ACCESS_VEND_TS        
                     ,CI.PROC_STATUS_CD                                 
                     ,CI.PROC_REQ_ID                                    
                 FROM CRM_ACCESS_OFF_OPT   CI WITH(READUNCOMMITTED)             
                WHERE CI.COMPANY_NO        = :CI-COMPANY-NO             
                  AND CI.OPTION_CD         = :CI-OPTION-CD              
                  AND CI.OFFER_CD          = :CI-OFFER-CD               
                  AND ((CI.ACCESS_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )     
                    AND CI.ACCESS_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ))    
                    OR (CI.ACCESS_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )     
                    AND CI.ACCESS_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              ) ))    
                  AND ((CI.ACCESS_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )      
                    AND CI.ACCESS_END_DT    >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ) )    
                    OR (CI.ACCESS_START_DT  >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )      
                    AND CI.ACCESS_START_DT  <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) ) ))     
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE SECURED_OPT_CUR CURSOR FOR                                
MFA-TR*        SELECT CI.COMPANY_NO                                             
MFA-TR*              ,CI.OPTION_CD                                              
MFA-TR*              ,CI.OFFER_CD                                               
MFA-TR*              ,CI.CATEGORY_ID                                            
MFA-TR*              ,CI.ACCESS_START_DT                                        
MFA-TR*              ,CI.ACCESS_END_DT                                          
MFA-TR*              ,CI.VIEW_APPLY_CD                                          
MFA-TR*              ,CI.LAST_UPDATE_USERID                                     
MFA-TR*              ,CI.LAST_UPDATE_TS                                         
MFA-TR*              ,CI.COMMENTS_TX                                            
MFA-TR*              ,CI.ACCESS_VRSN_NO                                         
MFA-TR*              ,CI.ACCESS_VSTART_TS                                       
MFA-TR*              ,CI.ACCESS_VEND_TS                                         
MFA-TR*              ,CI.PROC_STATUS_CD                                         
MFA-TR*              ,CI.PROC_REQ_ID                                            
MFA-TR*          FROM CRM_ACCESS_OFF_OPT   CI                                   
MFA-TR*         WHERE CI.COMPANY_NO        = :CI-COMPANY-NO                     
MFA-TR*           AND CI.OPTION_CD         = :CI-OPTION-CD                      
MFA-TR*           AND CI.OFFER_CD          = :CI-OFFER-CD                       
MFA-TR*           AND ((CI.ACCESS_VSTART_TS <= :WS-VERSION-START-TS             
MFA-TR*             AND CI.ACCESS_VEND_TS   >= :WS-VERSION-START-TS)            
MFA-TR*             OR (CI.ACCESS_VSTART_TS >= :WS-VERSION-START-TS             
MFA-TR*             AND CI.ACCESS_VSTART_TS <= :WS-VERSION-END-TS ))            
MFA-TR*           AND ((CI.ACCESS_START_DT  <= :WS-ACTIVE-START-DT              
MFA-TR*             AND CI.ACCESS_END_DT    >= :WS-ACTIVE-START-DT )            
MFA-TR*             OR (CI.ACCESS_START_DT  >= :WS-ACTIVE-START-DT              
MFA-TR*             AND CI.ACCESS_START_DT  <= :WS-ACTIVE-END-DT ))             
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7150                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CURSOR DECLARATION TO FETCH PROMOTION DETAILS                *        
      *   BASED ON PROMO CODE.                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE MKT_PROMOTION_CUR CURSOR FOR                      
               SELECT KM.COMPANY_NO                                     
                     ,KM.PROMO_CD                                       
                     ,KM.PROMO_DESC                                     
                     ,KM.OFFER_CD                                       
                     ,KM.MKT_PLAN_CD                                    
                     ,KM.PROMO_START_DT                                 
                     ,REPLACE(CONVERT(CHAR(8), KM.PROMO_START_TM, 108), 
           ':', '.') PROMO_START_TM                                 
                     ,KM.PROMO_END_DT                                   
                     ,REPLACE(CONVERT(CHAR(8), KM.PROMO_END_TM, 108), 
           ':', '.') PROMO_END_TM                                   
                     ,KM.AD_CHANNEL_CD                                  
                     ,KM.PROMO_DESC_LONG                                
                     ,KM.EXT_LANDING_PG_URL                             
                     ,KM.PROMO_TYPE_CD                                  
                     ,KM.WEB_IMAGE_FILE_NM                              
                     ,KM.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,KM.REPLACMNT_PROMO_CD                             
                     ,KM.DISPLAY_END_DT                                 
                     ,KM.INT_LANDING_PG_URL                             
                     ,KM.PROMO_VRSN_NO                                  
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VSTART_TS, 121), ' ', '-'), ':', '.') 
           PROMO_VSTART_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), KM.PROMO_VEND_TS
           , 121), ' ', '-'), ':', '.') PROMO_VEND_TS                          
                     ,KM.PROC_STATUS_CD                                 
                     ,KM.PROC_REQ_ID                                    
                 FROM CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)                
                WHERE KM.COMPANY_NO        = :KM-COMPANY-NO             
                  AND KM.OFFER_CD          = :KM-OFFER-CD               
                  AND ((KM.PROMO_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )     
                    AND KM.PROMO_VEND_TS    >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ) )   
                    OR (KM.PROMO_VSTART_TS  >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )     
                    AND KM.PROMO_VSTART_TS  <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              ) ))    
                  AND ((KM.PROMO_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )        
                    AND KM.PROMO_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ) )      
                    OR (KM.PROMO_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )        
                    AND KM.PROMO_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) ) ))       
                  FOR READ ONLY                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE MKT_PROMOTION_CUR CURSOR FOR                              
MFA-TR*        SELECT KM.COMPANY_NO                                             
MFA-TR*              ,KM.PROMO_CD                                               
MFA-TR*              ,KM.PROMO_DESC                                             
MFA-TR*              ,KM.OFFER_CD                                               
MFA-TR*              ,KM.MKT_PLAN_CD                                            
MFA-TR*              ,KM.PROMO_START_DT                                         
MFA-TR*              ,KM.PROMO_START_TM                                         
MFA-TR*              ,KM.PROMO_END_DT                                           
MFA-TR*              ,KM.PROMO_END_TM                                           
MFA-TR*              ,KM.AD_CHANNEL_CD                                          
MFA-TR*              ,KM.PROMO_DESC_LONG                                        
MFA-TR*              ,KM.EXT_LANDING_PG_URL                                     
MFA-TR*              ,KM.PROMO_TYPE_CD                                          
MFA-TR*              ,KM.WEB_IMAGE_FILE_NM                                      
MFA-TR*              ,KM.LAST_UPDATE_USERID                                     
MFA-TR*              ,KM.LAST_UPDATE_TS                                         
MFA-TR*              ,KM.REPLACMNT_PROMO_CD                                     
MFA-TR*              ,KM.DISPLAY_END_DT                                         
MFA-TR*              ,KM.INT_LANDING_PG_URL                                     
MFA-TR*              ,KM.PROMO_VRSN_NO                                          
MFA-TR*              ,KM.PROMO_VSTART_TS                                        
MFA-TR*              ,KM.PROMO_VEND_TS                                          
MFA-TR*              ,KM.PROC_STATUS_CD                                         
MFA-TR*              ,KM.PROC_REQ_ID                                            
MFA-TR*          FROM CRM_MKT_PROMOTION KM                                      
MFA-TR*         WHERE KM.COMPANY_NO        = :KM-COMPANY-NO                     
MFA-TR*           AND KM.OFFER_CD          = :KM-OFFER-CD                       
MFA-TR*           AND ((KM.PROMO_VSTART_TS  <= :WS-VERSION-START-TS             
MFA-TR*             AND KM.PROMO_VEND_TS    >= :WS-VERSION-START-TS )           
MFA-TR*             OR (KM.PROMO_VSTART_TS  >= :WS-VERSION-START-TS             
MFA-TR*             AND KM.PROMO_VSTART_TS  <= :WS-VERSION-END-TS ))            
MFA-TR*           AND ((KM.PROMO_START_DT <= :WS-ACTIVE-START-DT                
MFA-TR*             AND KM.PROMO_END_DT   >= :WS-ACTIVE-START-DT )              
MFA-TR*             OR (KM.PROMO_START_DT >= :WS-ACTIVE-START-DT                
MFA-TR*             AND KM.PROMO_START_DT <= :WS-ACTIVE-END-DT ))               
MFA-TR*           FOR FETCH ONLY WITH UR                                        
MFA-TR*           QUERYNO 7180                                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH MARKET TIER DETAILS             *        
      *    BASED ON OFFER CODE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE OFF_MKT_TIER_CUR CURSOR FOR                      
                SELECT DU.COMPANY_NO                                    
                      ,DU.OFFER_CD                                      
                      ,DU.TIER_CUST_STAT_CD                             
                      ,DU.TIER_ACCT_TYPE_CD                             
                      ,DU.MKT_TIER_RANKING                              
                      ,DU.MKT_TIER_START_DT                             
                      ,DU.OFFER_TIER_STRT_DT                            
                      ,DU.MKT_TIER_APPLY_CD                             
                      ,DU.TIER_DEFLT_OFFR_CD                            
                      ,DU.OFFER_TIER_END_DT                             
                      ,DU.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,DU.OFF_TIER_VRSN_NO                              
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VSTART_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VSTART_TS                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DU.OFF_TIER_VEND_TS, 121), ' ', '-'), ':', '.') 
           OFF_TIER_VEND_TS                              
                      ,DU.PROC_STATUS_CD                                
                      ,DU.PROC_REQ_ID                                   
                  FROM CRM_OFF_MKT_TIER  DU WITH(READUNCOMMITTED)               
                 WHERE DU.OFFER_CD            = :DU-OFFER-CD            
                   AND DU.COMPANY_NO          = :DU-COMPANY-NO          
                   AND ((DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND DU.OFF_TIER_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ) )
                     OR (DU.OFF_TIER_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )  
                     AND DU.OFF_TIER_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              ) )) 
                   AND ((DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND DU.OFFER_TIER_END_DT  >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )  )
                     OR (DU.OFFER_TIER_STRT_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )   
                     AND DU.OFFER_TIER_STRT_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) )  )) 
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE OFF_MKT_TIER_CUR CURSOR FOR                              
MFA-TR*         SELECT DU.COMPANY_NO                                            
MFA-TR*               ,DU.OFFER_CD                                              
MFA-TR*               ,DU.TIER_CUST_STAT_CD                                     
MFA-TR*               ,DU.TIER_ACCT_TYPE_CD                                     
MFA-TR*               ,DU.MKT_TIER_RANKING                                      
MFA-TR*               ,DU.MKT_TIER_START_DT                                     
MFA-TR*               ,DU.OFFER_TIER_STRT_DT                                    
MFA-TR*               ,DU.MKT_TIER_APPLY_CD                                     
MFA-TR*               ,DU.TIER_DEFLT_OFFR_CD                                    
MFA-TR*               ,DU.OFFER_TIER_END_DT                                     
MFA-TR*               ,DU.LAST_UPDATE_USERID                                    
MFA-TR*               ,DU.LAST_UPDATE_TS                                        
MFA-TR*               ,DU.OFF_TIER_VRSN_NO                                      
MFA-TR*               ,DU.OFF_TIER_VSTART_TS                                    
MFA-TR*               ,DU.OFF_TIER_VEND_TS                                      
MFA-TR*               ,DU.PROC_STATUS_CD                                        
MFA-TR*               ,DU.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_OFF_MKT_TIER  DU                                     
MFA-TR*          WHERE DU.OFFER_CD            = :DU-OFFER-CD                    
MFA-TR*            AND DU.COMPANY_NO          = :DU-COMPANY-NO                  
MFA-TR*            AND ((DU.OFF_TIER_VSTART_TS <= :WS-VERSION-START-TS          
MFA-TR*              AND DU.OFF_TIER_VEND_TS   >= :WS-VERSION-START-TS )        
MFA-TR*              OR (DU.OFF_TIER_VSTART_TS >= :WS-VERSION-START-TS          
MFA-TR*              AND DU.OFF_TIER_VSTART_TS <= :WS-VERSION-END-TS ))         
MFA-TR*            AND ((DU.OFFER_TIER_STRT_DT <= :WS-ACTIVE-START-DT           
MFA-TR*              AND DU.OFFER_TIER_END_DT  >= :WS-ACTIVE-START-DT  )        
MFA-TR*              OR (DU.OFFER_TIER_STRT_DT >= :WS-ACTIVE-START-DT           
MFA-TR*              AND DU.OFFER_TIER_STRT_DT <= :WS-ACTIVE-END-DT  ))         
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7210                                                 
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATION TO FETCH RATE GROUP  DETAILS             *        
      *    BASED ON OFFER CODE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE RATE_GRP_OFF_CUR CURSOR FOR                      
                SELECT G5.COMPANY_NO                                    
                      ,G5.RATE_GROUP_TYPE_CD                            
                      ,G5.RATE_GROUP_CD                                 
                      ,G5.SORT_SEQ_NO                                   
                      ,G5.EFF_START_DT                                  
                      ,G5.EFF_END_DT                                    
                      ,G5.OFFER_CD                                      
                      ,G5.OPTION_CD                                     
                      ,G5.LAST_UPDATE_USERID                            
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                      ,G5.GRP_OFF_VRSN_NO                               
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.GRP_OFF_VSTART_TS, 121), ' ', '-'), ':', '.') 
           GRP_OFF_VSTART_TS                             
                      ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           G5.GRP_OFF_VEND_TS, 121), ' ', '-'), ':', '.') 
           GRP_OFF_VEND_TS                               
                      ,G5.PROC_STATUS_CD                                
                      ,G5.PROC_REQ_ID                                   
                  FROM CRM_RATE_GRP_OFFER G5 WITH(READUNCOMMITTED)              
                 WHERE G5.OFFER_CD            = :G5-OFFER-CD            
                   AND G5.COMPANY_NO          = :G5-COMPANY-NO          
                   AND ((G5.GRP_OFF_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )   
                     AND G5.GRP_OFF_VEND_TS   >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              ) ) 
                     OR (G5.GRP_OFF_VSTART_TS >= CIS.CHAR2TIMESTAMP(
                                                   :WS-VERSION-START-TS
              )   
                     AND G5.GRP_OFF_VSTART_TS <= CIS.CHAR2TIMESTAMP(
                                                     :WS-VERSION-END-TS
              )  )) 
                   AND ((G5.EFF_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )         
                     AND G5.EFF_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) ) )       
                     OR (G5.EFF_START_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-ACTIVE-START-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-START-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-START-DT
              ) <> 10), CIS.CHAR2DATE(:WS-ACTIVE-START-DT
              ), CONVERT(DATE, :WS-ACTIVE-START-DT) )         
                     AND G5.EFF_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                      :WS-ACTIVE-END-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-ACTIVE-END-DT
              ) <> 0) OR (LEN(:WS-ACTIVE-END-DT) <> 10), CIS.CHAR2DATE(
                                                      :WS-ACTIVE-END-DT
              ), CONVERT(DATE, :WS-ACTIVE-END-DT) ) ))        
                   FOR READ ONLY                                
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_GRP_OFF_CUR CURSOR FOR                              
MFA-TR*         SELECT G5.COMPANY_NO                                            
MFA-TR*               ,G5.RATE_GROUP_TYPE_CD                                    
MFA-TR*               ,G5.RATE_GROUP_CD                                         
MFA-TR*               ,G5.SORT_SEQ_NO                                           
MFA-TR*               ,G5.EFF_START_DT                                          
MFA-TR*               ,G5.EFF_END_DT                                            
MFA-TR*               ,G5.OFFER_CD                                              
MFA-TR*               ,G5.OPTION_CD                                             
MFA-TR*               ,G5.LAST_UPDATE_USERID                                    
MFA-TR*               ,G5.LAST_UPDATE_TS                                        
MFA-TR*               ,G5.GRP_OFF_VRSN_NO                                       
MFA-TR*               ,G5.GRP_OFF_VSTART_TS                                     
MFA-TR*               ,G5.GRP_OFF_VEND_TS                                       
MFA-TR*               ,G5.PROC_STATUS_CD                                        
MFA-TR*               ,G5.PROC_REQ_ID                                           
MFA-TR*           FROM CRM_RATE_GRP_OFFER G5                                    
MFA-TR*          WHERE G5.OFFER_CD            = :G5-OFFER-CD                    
MFA-TR*            AND G5.COMPANY_NO          = :G5-COMPANY-NO                  
MFA-TR*            AND ((G5.GRP_OFF_VSTART_TS <= :WS-VERSION-START-TS           
MFA-TR*              AND G5.GRP_OFF_VEND_TS   >= :WS-VERSION-START-TS )         
MFA-TR*              OR (G5.GRP_OFF_VSTART_TS >= :WS-VERSION-START-TS           
MFA-TR*              AND G5.GRP_OFF_VSTART_TS <= :WS-VERSION-END-TS  ))         
MFA-TR*            AND ((G5.EFF_START_DT <= :WS-ACTIVE-START-DT                 
MFA-TR*              AND G5.EFF_END_DT   >= :WS-ACTIVE-START-DT )               
MFA-TR*              OR (G5.EFF_START_DT >= :WS-ACTIVE-START-DT                 
MFA-TR*              AND G5.EFF_START_DT <= :WS-ACTIVE-END-DT ))                
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*            QUERYNO 7300                                                 
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01 I-APPLICATION-ID      PIC  X(03).                             
       01 I-USER-ID             PIC  X(07).                             
       01 I-RESOURCE-ID         PIC  X(32).                             
       01 I-OFFER-CD            PIC  X(12).                             
       01 I-OPTION-CD           PIC  X(12).                             
       01 I-PROMO-CD            PIC  X(12).                             
       01 I-PENDING-FLAG        PIC  X(01).                             
       01 I-VERSION-NO          PIC S9(4) USAGE COMP.                   
COB305 01 I-PROC-REQ-ID        PIC S9(10)V USAGE COMP-3 VALUE 0.               
      *                                                                         
       PROCEDURE DIVISION USING I-APPLICATION-ID                        
                               ,I-USER-ID                               
                               ,I-RESOURCE-ID                           
                               ,I-OFFER-CD                              
                               ,I-OPTION-CD                             
                               ,I-PROMO-CD                              
                               ,I-PENDING-FLAG                          
                               ,I-VERSION-NO                            
                               ,I-PROC-REQ-ID.                          
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100A-DECLARE-GTT-R1   -  CRM_RT_PKG_OFFER                     *        
      ******************************************************************        
       0100A-DECLARE-GTT-R1.                                            
                                                                        
           MOVE 'SESSION.CSR04426_R1'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04426_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04426_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TABLE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OFFER_DESC_INT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_DESC_EXT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_CD_INT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_CD_EXT_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_START_INT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_END_INT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_START_EXT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISP_END_EXT_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_DESC_INT_LNG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,OFFER_DESC_EXT_LNG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,SPCL_OFFER_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RENEWAL_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RENEW_PUB_OFFER_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_VRSN_NO             SMALLINT                    
                   ,OFF_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                   ,TEMPLATE_OFFER CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,SET_PROMO_FLGS CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,UNDFLT_OFF_TIER_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
PRJ473             ,TEMPLATE_INT_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
PRJ473             ,TEMPLATE_REN_OFFR CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
PRJ473             ,TEMPLATE_EXT_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
PRJ680             ,MAX_PRICE_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
P00863             ,RTCHG_PUB_OFFER_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS    THRU 8000A-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100A'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(TABLE_ID))             AS TABLE_ID          
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD          
                      ,LTRIM(RTRIM(OFFER_DESC_INT))       AS 
           OFFER_DESC_INT    
                      ,LTRIM(RTRIM(OFFER_DESC_EXT))       AS 
           OFFER_DESC_EXT    
                      ,LTRIM(RTRIM(PROMO_CD_INT_FL))      AS 
           PROMO_CD_INT_FL   
                      ,LTRIM(RTRIM(PROMO_CD_EXT_FL))      AS 
           PROMO_CD_EXT_FL   
                      ,LTRIM(RTRIM(OFFER_START_DT))       AS 
           OFFER_START_DT    
                      ,LTRIM(RTRIM(OFFER_END_DT))         AS 
           OFFER_END_DT      
                      ,LTRIM(RTRIM(DISP_START_INT_TS))    AS 
           DISP_START_INT_TS 
                      ,LTRIM(RTRIM(DISP_END_INT_TS))      AS 
           DISP_END_INT_TS   
                      ,LTRIM(RTRIM(DISP_START_EXT_TS))    AS 
           DISP_START_EXT_TS 
                      ,LTRIM(RTRIM(DISP_END_EXT_TS))      AS 
           DISP_END_EXT_TS   
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(OFFER_DESC_INT_LNG))   AS 
           OFFER_DESC_INT_LNG
                      ,LTRIM(RTRIM(OFFER_DESC_EXT_LNG))   AS 
           OFFER_DESC_EXT_LNG
                      ,LTRIM(RTRIM(SPCL_OFFER_TYPE_CD))   AS 
           SPCL_OFFER_TYPE_CD
                      ,LTRIM(RTRIM(RENEWAL_OFFER_CD))     AS 
           RENEWAL_OFFER_CD  
                      ,LTRIM(RTRIM(RENEW_PUB_OFFER_CD))   AS 
           RENEW_PUB_OFFER_CD
                      ,OFF_VRSN_NO                 AS OFF_VRSN_NO       
                      ,LTRIM(RTRIM(OFF_VSTART_TS))        AS 
           OFF_VSTART_TS     
                      ,LTRIM(RTRIM(OFF_VEND_TS))          AS OFF_VEND_TS       
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
                      ,LTRIM(RTRIM(TEMPLATE_OFFER))       AS 
           TEMPLATE_OFFER    
                      ,LTRIM(RTRIM(SET_PROMO_FLGS))       AS 
           SET_PROMO_FLGS    
                      ,LTRIM(RTRIM(UNDFLT_OFF_TIER_FLAG)) AS 
           DFLT_OFF_TIER_FLAG
PRJ473                ,LTRIM(RTRIM(TEMPLATE_INT_DESC))    AS 
           TEMPLATE_INT_DESC 
PRJ473                ,LTRIM(RTRIM(TEMPLATE_REN_OFFR))    AS 
           TEMPLATE_REN_OFFR 
PRJ473                ,LTRIM(RTRIM(TEMPLATE_EXT_DESC))    AS 
           TEMPLATE_EXT_DESC 
PRJ680                ,LTRIM(RTRIM(MAX_PRICE_OFFER_CD))   AS 
           MAX_PRICE_OFFER_CD
P00863                ,LTRIM(RTRIM(RTCHG_PUB_OFFER_CD))   AS 
           RTCHG_PUB_OFFER_CD
                  FROM #CSR04426_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(TABLE_ID)             AS TABLE_ID                  
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD                  
MFA-TR*               ,STRIP(OFFER_DESC_INT)       AS OFFER_DESC_INT            
MFA-TR*               ,STRIP(OFFER_DESC_EXT)       AS OFFER_DESC_EXT            
MFA-TR*               ,STRIP(PROMO_CD_INT_FL)      AS PROMO_CD_INT_FL           
MFA-TR*               ,STRIP(PROMO_CD_EXT_FL)      AS PROMO_CD_EXT_FL           
MFA-TR*               ,STRIP(OFFER_START_DT)       AS OFFER_START_DT            
MFA-TR*               ,STRIP(OFFER_END_DT)         AS OFFER_END_DT              
MFA-TR*               ,STRIP(DISP_START_INT_TS)    AS DISP_START_INT_TS         
MFA-TR*               ,STRIP(DISP_END_INT_TS)      AS DISP_END_INT_TS           
MFA-TR*               ,STRIP(DISP_START_EXT_TS)    AS DISP_START_EXT_TS         
MFA-TR*               ,STRIP(DISP_END_EXT_TS)      AS DISP_END_EXT_TS           
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(OFFER_DESC_INT_LNG)   AS OFFER_DESC_INT_LNG        
MFA-TR*               ,STRIP(OFFER_DESC_EXT_LNG)   AS OFFER_DESC_EXT_LNG        
MFA-TR*               ,STRIP(SPCL_OFFER_TYPE_CD)   AS SPCL_OFFER_TYPE_CD        
MFA-TR*               ,STRIP(RENEWAL_OFFER_CD)     AS RENEWAL_OFFER_CD          
MFA-TR*               ,STRIP(RENEW_PUB_OFFER_CD)   AS RENEW_PUB_OFFER_CD        
MFA-TR*               ,OFF_VRSN_NO                 AS OFF_VRSN_NO               
MFA-TR*               ,STRIP(OFF_VSTART_TS)        AS OFF_VSTART_TS             
MFA-TR*               ,STRIP(OFF_VEND_TS)          AS OFF_VEND_TS               
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*               ,STRIP(TEMPLATE_OFFER)       AS TEMPLATE_OFFER            
MFA-TR*               ,STRIP(SET_PROMO_FLGS)       AS SET_PROMO_FLGS            
MFA-TR*               ,STRIP(UNDFLT_OFF_TIER_FLAG) AS DFLT_OFF_TIER_FLAG        
MFA-TR*               ,STRIP(TEMPLATE_INT_DESC)    AS TEMPLATE_INT_DESC         
MFA-TR*               ,STRIP(TEMPLATE_REN_OFFR)    AS TEMPLATE_REN_OFFR         
MFA-TR*               ,STRIP(TEMPLATE_EXT_DESC)    AS TEMPLATE_EXT_DESC         
MFA-TR*               ,STRIP(MAX_PRICE_OFFER_CD)   AS MAX_PRICE_OFFER_CD        
MFA-TR*               ,STRIP(RTCHG_PUB_OFFER_CD)   AS RTCHG_PUB_OFFER_CD        
MFA-TR*           FROM SESSION.CSR04426_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100B-DECLARE-GTT-R2 - CRM_RT_PKG_OPTION                       *        
      ******************************************************************        
       0100B-DECLARE-GTT-R2.                                            
                                                                        
           MOVE 'SESSION.CSR04426_R2'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04426_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04426_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TABLE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPTION_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPTION_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_DESC_INT CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_DESC_INT_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,CURR_EXT_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,RENEWAL_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,WEB_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_CALC_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WEB_MKT_DESC_LONG VARCHAR(1024)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2               
                   ,OPT_VRSN_NO             SMALLINT                    
                   ,OPT_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
A04805             ,OPTION_TYPE_DESC CHAR(50)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
PRJ892             ,AUTO_RENEWAL_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
PRJ892             ,OPTION_PROMO_DESC VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS    THRU 8000B-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100B'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(TABLE_ID))             AS TABLE_ID          
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD         
                      ,LTRIM(RTRIM(CODE_UTIL_TYPE))       AS 
           CODE_UTIL_TYPE    
                      ,LTRIM(RTRIM(RATE_PLAN_NO))         AS 
           RATE_PLAN_NO      
                      ,LTRIM(RTRIM(OPTION_START_DT))      AS 
           OPTION_START_DT   
                      ,LTRIM(RTRIM(OPTION_END_DT))        AS 
           OPTION_END_DT     
                      ,LTRIM(RTRIM(OPT_DESC_INT))         AS 
           OPT_DESC_INT      
                      ,LTRIM(RTRIM(OPT_DESC_INT_LONG))    AS 
           OPT_DESC_INT_LONG 
                      ,LTRIM(RTRIM(CURR_EXT_DESC_LONG))   AS 
           CURR_EXT_DESC_LONG
                      ,LTRIM(RTRIM(RENEWAL_DESC_LONG))    AS 
           RENEWAL_DESC_LONG 
                      ,LTRIM(RTRIM(WEB_DESC_LONG))        AS 
           WEB_DESC_LONG     
                      ,LTRIM(RTRIM(STATUS_CD))            AS STATUS_CD         
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,LTRIM(RTRIM(OPT_CALC_TYPE_CD))     AS 
           OPT_CALC_TYPE_CD  
                      ,LTRIM(RTRIM(WEB_MKT_DESC_LONG))    AS 
           WEB_MKT_DESC_LONG 
                      ,OPT_VRSN_NO                 AS OPT_VRSN_NO       
                      ,LTRIM(RTRIM(OPT_VSTART_TS))        AS 
           OPT_VSTART_TS     
                      ,LTRIM(RTRIM(OPT_VEND_TS))          AS OPT_VEND_TS       
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
A04805                ,LTRIM(RTRIM(OPTION_TYPE_DESC))     AS 
           OPTION_TYPE_DESC  
PRJ892                ,AUTO_RENEWAL_FL             AS AUTO_RENEWAL_FL   
PRJ892                ,LTRIM(RTRIM(OPTION_PROMO_DESC))    AS 
           OPTION_PROMO_DESC 
                  FROM #CSR04426_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(TABLE_ID)             AS TABLE_ID                  
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OPTION_CD)            AS OPTION_CD                 
MFA-TR*               ,STRIP(CODE_UTIL_TYPE)       AS CODE_UTIL_TYPE            
MFA-TR*               ,STRIP(RATE_PLAN_NO)         AS RATE_PLAN_NO              
MFA-TR*               ,STRIP(OPTION_START_DT)      AS OPTION_START_DT           
MFA-TR*               ,STRIP(OPTION_END_DT)        AS OPTION_END_DT             
MFA-TR*               ,STRIP(OPT_DESC_INT)         AS OPT_DESC_INT              
MFA-TR*               ,STRIP(OPT_DESC_INT_LONG)    AS OPT_DESC_INT_LONG         
MFA-TR*               ,STRIP(CURR_EXT_DESC_LONG)   AS CURR_EXT_DESC_LONG        
MFA-TR*               ,STRIP(RENEWAL_DESC_LONG)    AS RENEWAL_DESC_LONG         
MFA-TR*               ,STRIP(WEB_DESC_LONG)        AS WEB_DESC_LONG             
MFA-TR*               ,STRIP(STATUS_CD)            AS STATUS_CD                 
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,STRIP(OPT_CALC_TYPE_CD)     AS OPT_CALC_TYPE_CD          
MFA-TR*               ,STRIP(WEB_MKT_DESC_LONG)    AS WEB_MKT_DESC_LONG         
MFA-TR*               ,OPT_VRSN_NO                 AS OPT_VRSN_NO               
MFA-TR*               ,STRIP(OPT_VSTART_TS)        AS OPT_VSTART_TS             
MFA-TR*               ,STRIP(OPT_VEND_TS)          AS OPT_VEND_TS               
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*               ,STRIP(OPTION_TYPE_DESC)     AS OPTION_TYPE_DESC          
MFA-TR*               ,AUTO_RENEWAL_FL             AS AUTO_RENEWAL_FL           
MFA-TR*               ,STRIP(OPTION_PROMO_DESC)    AS OPTION_PROMO_DESC         
MFA-TR*           FROM SESSION.CSR04426_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100C-DECLARE-GTT-R3  -  CRM_OPT_ATTR_INCTV                    *        
      ******************************************************************        
       0100C-DECLARE-GTT-R3.                                            
                                                                        
           MOVE 'SESSION.CSR04426_R3'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04426_R3')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04426_R3
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TABLE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,ATTR_INCTV_SEQ_NO       SMALLINT                    
                   ,RT_ATTR_INCTV_TYPE CHAR(15)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PRIMRY_OPT_ATTR_FL CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,FACTOR_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,DURATION_NO             SMALLINT                    
                   ,APPL_PROGRAM_ID CHAR(09)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ATTR_INCTV_VALUE        DECIMAL(11,6)               
                   ,ATTR_INCTV_VAL_TX CHAR(20)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,GL_ACCT_CREDIT          DECIMAL(7,4)                
                   ,GL_ACCT_DEBIT           DECIMAL(7,4)                
                   ,CATEGORY_ID             SMALLINT                    
                   ,WQ_ROUTE_CATEGORY CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_CHG_ACTION_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ATTR_INCTV_STRT_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ATTR_INCTV_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_ATTR_VRSN_NO        SMALLINT                    
                   ,OPT_ATTR_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OPT_ATTR_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000C-DEL-GTT-ROWS    THRU 8000C-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100C'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C3 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(TABLE_ID))             AS TABLE_ID          
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD         
                      ,ATTR_INCTV_SEQ_NO                                
                      ,LTRIM(RTRIM(RT_ATTR_INCTV_TYPE))   AS 
           RT_ATTR_INCTV_TYPE
                      ,LTRIM(RTRIM(PRIMRY_OPT_ATTR_FL))   AS 
           PRIMRY_OPT_ATTR_FL
                      ,LTRIM(RTRIM(FACTOR_ID))            AS FACTOR_ID         
                      ,DURATION_NO                                      
                      ,LTRIM(RTRIM(APPL_PROGRAM_ID))      AS 
           APPL_PROGRAM_ID   
                      ,ATTR_INCTV_VALUE                                 
                      ,LTRIM(RTRIM(ATTR_INCTV_VAL_TX))    AS 
           ATTR_INCTV_VAL_TX 
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,GL_ACCT_CREDIT              AS GL_ACCT_CREDIT    
                      ,GL_ACCT_DEBIT               AS GL_ACCT_DEBIT     
                      ,CATEGORY_ID                 AS CATEGORY_ID       
                      ,LTRIM(RTRIM(WQ_ROUTE_CATEGORY))    AS 
           WQ_ROUTE_CATEGORY 
                      ,LTRIM(RTRIM(OPT_CHG_ACTION_CD))    AS 
           OPT_CHG_ACTION_CD 
                      ,LTRIM(RTRIM(ATTR_INCTV_STRT_DT))   AS 
           ATTR_INCTV_STRT_DT
                      ,LTRIM(RTRIM(ATTR_INCTV_END_DT))    AS 
           ATTR_INCTV_END_DT 
                      ,OPT_ATTR_VRSN_NO            AS OPT_ATTR_VRSN_NO  
                      ,LTRIM(RTRIM(OPT_ATTR_VSTART_TS))   AS 
           OPT_ATTR_VSTART_TS
                      ,LTRIM(RTRIM(OPT_ATTR_VEND_TS))     AS 
           OPT_ATTR_VEND_TS  
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
                 FROM #CSR04426_R3                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C3 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(TABLE_ID)             AS TABLE_ID                  
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OPTION_CD)            AS OPTION_CD                 
MFA-TR*               ,ATTR_INCTV_SEQ_NO                                        
MFA-TR*               ,STRIP(RT_ATTR_INCTV_TYPE)   AS RT_ATTR_INCTV_TYPE        
MFA-TR*               ,STRIP(PRIMRY_OPT_ATTR_FL)   AS PRIMRY_OPT_ATTR_FL        
MFA-TR*               ,STRIP(FACTOR_ID)            AS FACTOR_ID                 
MFA-TR*               ,DURATION_NO                                              
MFA-TR*               ,STRIP(APPL_PROGRAM_ID)      AS APPL_PROGRAM_ID           
MFA-TR*               ,ATTR_INCTV_VALUE                                         
MFA-TR*               ,STRIP(ATTR_INCTV_VAL_TX)    AS ATTR_INCTV_VAL_TX         
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,GL_ACCT_CREDIT              AS GL_ACCT_CREDIT            
MFA-TR*               ,GL_ACCT_DEBIT               AS GL_ACCT_DEBIT             
MFA-TR*               ,CATEGORY_ID                 AS CATEGORY_ID               
MFA-TR*               ,STRIP(WQ_ROUTE_CATEGORY)    AS WQ_ROUTE_CATEGORY         
MFA-TR*               ,STRIP(OPT_CHG_ACTION_CD)    AS OPT_CHG_ACTION_CD         
MFA-TR*               ,STRIP(ATTR_INCTV_STRT_DT)   AS ATTR_INCTV_STRT_DT        
MFA-TR*               ,STRIP(ATTR_INCTV_END_DT)    AS ATTR_INCTV_END_DT         
MFA-TR*               ,OPT_ATTR_VRSN_NO            AS OPT_ATTR_VRSN_NO          
MFA-TR*               ,STRIP(OPT_ATTR_VSTART_TS)   AS OPT_ATTR_VSTART_TS        
MFA-TR*               ,STRIP(OPT_ATTR_VEND_TS)     AS OPT_ATTR_VEND_TS          
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*          FROM SESSION.CSR04426_R3                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100D-DECLARE-GTT-R4   - CRM_ACCESS_OFF_OPT                    *        
      ******************************************************************        
       0100D-DECLARE-GTT-R4.                                            
                                                                        
           MOVE 'SESSION.CSR04426_R4'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04426_R4')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04426_R4
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TABLE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,CATEGORY_ID             INT                     
                   ,ACCESS_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCESS_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,VIEW_APPLY_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,COMMENTS_TX CHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                   
                   ,ACCESS_VRSN_NO          SMALLINT                    
                   ,ACCESS_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,ACCESS_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000D-DEL-GTT-ROWS    THRU 8000D-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100D'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C4 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(TABLE_ID))             AS TABLE_ID          
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(OPTION_CD))            AS OPTION_CD         
                      ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD          
                      ,CATEGORY_ID                                      
                      ,LTRIM(RTRIM(ACCESS_START_DT))      AS 
           ACCESS_START_DT   
                      ,LTRIM(RTRIM(ACCESS_END_DT))        AS 
           ACCESS_END_DT     
                      ,LTRIM(RTRIM(VIEW_APPLY_CD))        AS 
           VIEW_APPLY_CD     
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,LTRIM(RTRIM(COMMENTS_TX))          AS COMMENTS_TX       
                      ,ACCESS_VRSN_NO              AS ACCESS_VRSN_NO    
                      ,LTRIM(RTRIM(ACCESS_VSTART_TS))     AS 
           ACCESS_VSTART_TS  
                      ,LTRIM(RTRIM(ACCESS_VEND_TS))       AS 
           ACCESS_VEND_TS    
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
                  FROM #CSR04426_R4                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C4 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(TABLE_ID)             AS TABLE_ID                  
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(OPTION_CD)            AS OPTION_CD                 
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD                  
MFA-TR*               ,CATEGORY_ID                                              
MFA-TR*               ,STRIP(ACCESS_START_DT)      AS ACCESS_START_DT           
MFA-TR*               ,STRIP(ACCESS_END_DT)        AS ACCESS_END_DT             
MFA-TR*               ,STRIP(VIEW_APPLY_CD)        AS VIEW_APPLY_CD             
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,STRIP(COMMENTS_TX)          AS COMMENTS_TX               
MFA-TR*               ,ACCESS_VRSN_NO              AS ACCESS_VRSN_NO            
MFA-TR*               ,STRIP(ACCESS_VSTART_TS)     AS ACCESS_VSTART_TS          
MFA-TR*               ,STRIP(ACCESS_VEND_TS)       AS ACCESS_VEND_TS            
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*           FROM SESSION.CSR04426_R4                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100E-DECLARE-GTT-R5   - CRM_MKT_PROMOTION                     *        
      ******************************************************************        
       0100E-DECLARE-GTT-R5.                                            
                                                                        
           MOVE 'SESSION.CSR04426_R5'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04426_R5')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04426_R5
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TABLE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,PROMO_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,PROMO_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,MKT_PLAN_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_START_TM CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_END_TM CHAR(08)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,AD_CHANNEL_CD CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_DESC_LONG VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,EXT_LANDING_PG_URL VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMO_TYPE_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,WEB_IMAGE_FILE_NM VARCHAR(100)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,REPLACMNT_PROMO_CD CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,DISPLAY_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,INT_LANDING_PG_URL VARCHAR(255)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                
                   ,PROMO_VRSN_NO           SMALLINT                    
                   ,PROMO_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROMO_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                   ,PROMO_REUSED_FLAG CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
PRJ473             ,ORIG_PROMO_OFFER CHAR(12)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000E-DEL-GTT-ROWS    THRU 8000E-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100E'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C5 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT DISTINCT RETURN_CODE                             
                      ,APPL_RETURN_CODE                                 
                      ,LTRIM(RTRIM(TABLE_ID))             AS TABLE_ID          
                      ,LTRIM(RTRIM(COMPANY_NO))           AS COMPANY_NO        
                      ,LTRIM(RTRIM(PROMO_CD))             AS PROMO_CD          
                      ,LTRIM(RTRIM(PROMO_DESC))           AS PPROMO_DESC       
                      ,LTRIM(RTRIM(OFFER_CD))             AS OFFER_CD          
                      ,LTRIM(RTRIM(MKT_PLAN_CD))          AS MKT_PLAN_CD       
                      ,LTRIM(RTRIM(PROMO_START_DT))       AS 
           PROMO_START_DT    
                      ,LTRIM(RTRIM(PROMO_START_TM))       AS 
           PROMO_START_TM    
                      ,LTRIM(RTRIM(PROMO_END_DT))         AS 
           PROMO_END_DT      
                      ,LTRIM(RTRIM(PROMO_END_TM))         AS 
           PROMO_END_TM      
                      ,LTRIM(RTRIM(AD_CHANNEL_CD))        AS 
           AD_CHANNEL_CD     
                      ,LTRIM(RTRIM(PROMO_DESC_LONG))      AS 
           PROMO_DESC_LONG   
                      ,LTRIM(RTRIM(EXT_LANDING_PG_URL))   AS 
           EXT_LANDING_PG_URL
                      ,LTRIM(RTRIM(PROMO_TYPE_CD))        AS 
           PROMO_TYPE_CD     
                      ,LTRIM(RTRIM(WEB_IMAGE_FILE_NM))    AS 
           WEB_IMAGE_FILE_NM 
                      ,LTRIM(RTRIM(LAST_UPDATE_USERID))   AS 
           LAST_UPDATE_USERID
                      ,LTRIM(RTRIM(LAST_UPDATE_TS))       AS 
           LAST_UPDATE_TS    
                      ,LTRIM(RTRIM(REPLACMNT_PROMO_CD))   AS 
           REPLACMNT_PROMO_CD
                      ,LTRIM(RTRIM(DISPLAY_END_DT))       AS 
           DISPLAY_END_DT    
                      ,LTRIM(RTRIM(INT_LANDING_PG_URL))   AS 
           INT_LANDING_PG_URL
                      ,PROMO_VRSN_NO               AS PROMO_VRSN_NO     
                      ,LTRIM(RTRIM(PROMO_VSTART_TS))      AS 
           PROMO_VSTART_TS   
                      ,LTRIM(RTRIM(PROMO_VEND_TS))        AS 
           PROMO_VEND_TS     
                      ,LTRIM(RTRIM(PROC_STATUS_CD))       AS 
           PROC_STATUS_CD    
                      ,PROC_REQ_ID                 AS PROC_REQ_ID       
                      ,LTRIM(RTRIM(PROMO_REUSED_FLAG))    AS 
           PROMO_REUSED_FLAG 
PRJ473                ,LTRIM(RTRIM(ORIG_PROMO_OFFER))     AS 
           ORIG_PROMO_OFFER  
                  FROM #CSR04426_R5                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C5 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT DISTINCT RETURN_CODE                                     
MFA-TR*               ,APPL_RETURN_CODE                                         
MFA-TR*               ,STRIP(TABLE_ID)             AS TABLE_ID                  
MFA-TR*               ,STRIP(COMPANY_NO)           AS COMPANY_NO                
MFA-TR*               ,STRIP(PROMO_CD)             AS PROMO_CD                  
MFA-TR*               ,STRIP(PROMO_DESC)           AS PPROMO_DESC               
MFA-TR*               ,STRIP(OFFER_CD)             AS OFFER_CD                  
MFA-TR*               ,STRIP(MKT_PLAN_CD)          AS MKT_PLAN_CD               
MFA-TR*               ,STRIP(PROMO_START_DT)       AS PROMO_START_DT            
MFA-TR*               ,STRIP(PROMO_START_TM)       AS PROMO_START_TM            
MFA-TR*               ,STRIP(PROMO_END_DT)         AS PROMO_END_DT              
MFA-TR*               ,STRIP(PROMO_END_TM)         AS PROMO_END_TM              
MFA-TR*               ,STRIP(AD_CHANNEL_CD)        AS AD_CHANNEL_CD             
MFA-TR*               ,STRIP(PROMO_DESC_LONG)      AS PROMO_DESC_LONG           
MFA-TR*               ,STRIP(EXT_LANDING_PG_URL)   AS EXT_LANDING_PG_URL        
MFA-TR*               ,STRIP(PROMO_TYPE_CD)        AS PROMO_TYPE_CD             
MFA-TR*               ,STRIP(WEB_IMAGE_FILE_NM)    AS WEB_IMAGE_FILE_NM         
MFA-TR*               ,STRIP(LAST_UPDATE_USERID)   AS LAST_UPDATE_USERID        
MFA-TR*               ,STRIP(LAST_UPDATE_TS)       AS LAST_UPDATE_TS            
MFA-TR*               ,STRIP(REPLACMNT_PROMO_CD)   AS REPLACMNT_PROMO_CD        
MFA-TR*               ,STRIP(DISPLAY_END_DT)       AS DISPLAY_END_DT            
MFA-TR*               ,STRIP(INT_LANDING_PG_URL)   AS INT_LANDING_PG_URL        
MFA-TR*               ,PROMO_VRSN_NO               AS PROMO_VRSN_NO             
MFA-TR*               ,STRIP(PROMO_VSTART_TS)      AS PROMO_VSTART_TS           
MFA-TR*               ,STRIP(PROMO_VEND_TS)        AS PROMO_VEND_TS             
MFA-TR*               ,STRIP(PROC_STATUS_CD)       AS PROC_STATUS_CD            
MFA-TR*               ,PROC_REQ_ID                 AS PROC_REQ_ID               
MFA-TR*               ,STRIP(PROMO_REUSED_FLAG)    AS PROMO_REUSED_FLAG         
MFA-TR*               ,STRIP(ORIG_PROMO_OFFER)     AS ORIG_PROMO_OFFER          
MFA-TR*           FROM SESSION.CSR04426_R5                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100F-DECLARE-GTT-R6  -  CRM_OFF_MKT_TIER                      *        
      ******************************************************************        
       0100F-DECLARE-GTT-R6.                                            
                                                                        
           MOVE 'SESSION.CSR04426_R6'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04426_R6')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04426_R6
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TABLE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,TIER_CUST_STAT_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_ACCT_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_RANKING        SMALLINT                    
                   ,MKT_TIER_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_TIER_STRT_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,MKT_TIER_APPLY_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,TIER_DEFLT_OFFR_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_TIER_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_TIER_VRSN_NO        SMALLINT                    
                   ,OFF_TIER_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_TIER_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000F-DEL-GTT-ROWS    THRU 8000F-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100F'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C6 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT  DISTINCT RETURN_CODE                            
                       ,APPL_RETURN_CODE                                
                       ,LTRIM(RTRIM(TABLE_ID))            AS TABLE_ID          
                       ,LTRIM(RTRIM(COMPANY_NO))          AS COMPANY_NO        
                       ,LTRIM(RTRIM(OFFER_CD))            AS OFFER_CD          
                       ,LTRIM(RTRIM(TIER_CUST_STAT_CD))   AS 
           TIER_CUST_STAT_CD 
                       ,LTRIM(RTRIM(TIER_ACCT_TYPE_CD))   AS 
           TIER_ACCT_TYPE_CD 
                       ,MKT_TIER_RANKING                                
                       ,LTRIM(RTRIM(MKT_TIER_START_DT))   AS 
           MKT_TIER_START_DT 
                       ,LTRIM(RTRIM(OFFER_TIER_STRT_DT))  AS 
           OFFER_TIER_STRT_DT
                       ,LTRIM(RTRIM(MKT_TIER_APPLY_CD))   AS 
           MKT_TIER_APPLY_CD 
                       ,LTRIM(RTRIM(TIER_DEFLT_OFFR_CD))  AS 
           TIER_DEFLT_OFFR_CD
                       ,LTRIM(RTRIM(OFFER_TIER_END_DT))   AS 
           OFFER_TIER_END_DT 
                       ,LTRIM(RTRIM(LAST_UPDATE_USERID))  AS 
           LAST_UPDATE_USERID
                       ,LTRIM(RTRIM(LAST_UPDATE_TS))      AS 
           LAST_UPDATE_TS    
                       ,OFF_TIER_VRSN_NO           AS OFF_TIER_VRSN_NO  
                       ,LTRIM(RTRIM(OFF_TIER_VSTART_TS))  AS 
           OFF_TIER_VSTART_TS
                       ,LTRIM(RTRIM(OFF_TIER_VEND_TS))    AS 
           OFF_TIER_VEND_TS  
                       ,LTRIM(RTRIM(PROC_STATUS_CD))      AS 
           PROC_STATUS_CD    
                       ,PROC_REQ_ID                AS PROC_REQ_ID       
                  FROM #CSR04426_R6                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C6 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT  DISTINCT RETURN_CODE                                    
MFA-TR*                ,APPL_RETURN_CODE                                        
MFA-TR*                ,STRIP(TABLE_ID)            AS TABLE_ID                  
MFA-TR*                ,STRIP(COMPANY_NO)          AS COMPANY_NO                
MFA-TR*                ,STRIP(OFFER_CD)            AS OFFER_CD                  
MFA-TR*                ,STRIP(TIER_CUST_STAT_CD)   AS TIER_CUST_STAT_CD         
MFA-TR*                ,STRIP(TIER_ACCT_TYPE_CD)   AS TIER_ACCT_TYPE_CD         
MFA-TR*                ,MKT_TIER_RANKING                                        
MFA-TR*                ,STRIP(MKT_TIER_START_DT)   AS MKT_TIER_START_DT         
MFA-TR*                ,STRIP(OFFER_TIER_STRT_DT)  AS OFFER_TIER_STRT_DT        
MFA-TR*                ,STRIP(MKT_TIER_APPLY_CD)   AS MKT_TIER_APPLY_CD         
MFA-TR*                ,STRIP(TIER_DEFLT_OFFR_CD)  AS TIER_DEFLT_OFFR_CD        
MFA-TR*                ,STRIP(OFFER_TIER_END_DT)   AS OFFER_TIER_END_DT         
MFA-TR*                ,STRIP(LAST_UPDATE_USERID)  AS LAST_UPDATE_USERID        
MFA-TR*                ,STRIP(LAST_UPDATE_TS)      AS LAST_UPDATE_TS            
MFA-TR*                ,OFF_TIER_VRSN_NO           AS OFF_TIER_VRSN_NO          
MFA-TR*                ,STRIP(OFF_TIER_VSTART_TS)  AS OFF_TIER_VSTART_TS        
MFA-TR*                ,STRIP(OFF_TIER_VEND_TS)    AS OFF_TIER_VEND_TS          
MFA-TR*                ,STRIP(PROC_STATUS_CD)      AS PROC_STATUS_CD            
MFA-TR*                ,PROC_REQ_ID                AS PROC_REQ_ID               
MFA-TR*           FROM SESSION.CSR04426_R6                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100F-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 0100G-DECLARE-GTT-R7  -  CRM_RATE_GRP_OFFER                    *        
      ******************************************************************        
       0100G-DECLARE-GTT-R7.                                            
                                                                        
           MOVE 'SESSION.CSR04426_R7'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04426_R7')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04426_R7
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TABLE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,RATE_GROUP_TYPE_CD CHAR(01)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,RATE_GROUP_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,SORT_SEQ_NO             SMALLINT                    
                   ,EFF_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,EFF_END_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,GRP_OFF_VRSN_NO         SMALLINT                    
                   ,GRP_OFF_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,GRP_OFF_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000G-DEL-GTT-ROWS    THRU 8000G-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100G'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C7 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT  DISTINCT RETURN_CODE                            
                       ,APPL_RETURN_CODE                                
                       ,LTRIM(RTRIM(TABLE_ID))            AS TABLE_ID          
                       ,LTRIM(RTRIM(COMPANY_NO))          AS COMPANY_NO        
                       ,LTRIM(RTRIM(RATE_GROUP_TYPE_CD))  AS 
           RATE_GROUP_TYPE_CD
                       ,LTRIM(RTRIM(RATE_GROUP_CD))       AS 
           RATE_GROUP_CD     
                       ,SORT_SEQ_NO                AS SORT_SEQ_NO       
                       ,LTRIM(RTRIM(EFF_START_DT))        AS 
           EFF_START_DT      
                       ,LTRIM(RTRIM(EFF_END_DT))          AS EFF_END_DT        
                       ,LTRIM(RTRIM(OFFER_CD))            AS OFFER_CD          
                       ,LTRIM(RTRIM(OPTION_CD))           AS OPTION_CD         
                       ,LTRIM(RTRIM(LAST_UPDATE_USERID))  AS 
           LAST_UPDATE_USERID
                       ,LTRIM(RTRIM(LAST_UPDATE_TS))      AS 
           LAST_UPDATE_TS    
                       ,GRP_OFF_VRSN_NO            AS GRP_OFF_VRSN_NO   
                       ,LTRIM(RTRIM(GRP_OFF_VSTART_TS))   AS 
           GRP_OFF_VSTART_TS 
                       ,LTRIM(RTRIM(GRP_OFF_VEND_TS))     AS 
           GRP_OFF_VEND_TS   
                       ,LTRIM(RTRIM(PROC_STATUS_CD))      AS 
           PROC_STATUS_CD    
                       ,PROC_REQ_ID                AS PROC_REQ_ID       
                  FROM #CSR04426_R7                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C7 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT  DISTINCT RETURN_CODE                                    
MFA-TR*                ,APPL_RETURN_CODE                                        
MFA-TR*                ,STRIP(TABLE_ID)            AS TABLE_ID                  
MFA-TR*                ,STRIP(COMPANY_NO)          AS COMPANY_NO                
MFA-TR*                ,STRIP(RATE_GROUP_TYPE_CD)  AS RATE_GROUP_TYPE_CD        
MFA-TR*                ,STRIP(RATE_GROUP_CD)       AS RATE_GROUP_CD             
MFA-TR*                ,SORT_SEQ_NO                AS SORT_SEQ_NO               
MFA-TR*                ,STRIP(EFF_START_DT)        AS EFF_START_DT              
MFA-TR*                ,STRIP(EFF_END_DT)          AS EFF_END_DT                
MFA-TR*                ,STRIP(OFFER_CD)            AS OFFER_CD                  
MFA-TR*                ,STRIP(OPTION_CD)           AS OPTION_CD                 
MFA-TR*                ,STRIP(LAST_UPDATE_USERID)  AS LAST_UPDATE_USERID        
MFA-TR*                ,STRIP(LAST_UPDATE_TS)      AS LAST_UPDATE_TS            
MFA-TR*                ,GRP_OFF_VRSN_NO            AS GRP_OFF_VRSN_NO           
MFA-TR*                ,STRIP(GRP_OFF_VSTART_TS)   AS GRP_OFF_VSTART_TS         
MFA-TR*                ,STRIP(GRP_OFF_VEND_TS)     AS GRP_OFF_VEND_TS           
MFA-TR*                ,STRIP(PROC_STATUS_CD)      AS PROC_STATUS_CD            
MFA-TR*                ,PROC_REQ_ID                AS PROC_REQ_ID               
MFA-TR*           FROM SESSION.CSR04426_R7                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100G-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 0100H-DECLARE-GTT-R8  -  CRM_OFFER_OPTION                      *        
      ******************************************************************        
       0100H-DECLARE-GTT-R8.                                            
                                                                        
           MOVE 'SESSION.CSR04426_R8'       TO WS-GTT-NAME.             
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04426_R8')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04426_R8
              (                                                       
                    RETURN_CODE             INT                     
                   ,APPL_RETURN_CODE        INT                     
                   ,TABLE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,OFFER_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2          
                   ,OPTION_CD CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,OPTION_SORT_SEQ_NO      SMALLINT                    
                   ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_OPT_START_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFFER_OPT_END_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_OPT_VRSN_NO         SMALLINT                    
                   ,OFF_OPT_VSTART_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,OFF_OPT_VEND_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_STATUS_CD CHAR(02)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,PROC_REQ_ID             DECIMAL(10,0)               
A04805             ,WEB_NEW_EXISTS_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
A04805             ,WEB_SIGN_UP_FL CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
A04805             ,OFF_OPT_EXCLUDE_CD CHAR(1)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000H-DEL-GTT-ROWS    THRU 8000H-EXIT             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '0100H'               TO ACTIVE-PARAGRAPH         
                 MOVE SQLCODE               TO ABEND-SQLCODE            
                 MOVE SQLSTATE              TO ABEND-SQLSTATE           
                 MOVE 'DECLARE GTT'         TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE WS-GTT-NAME           TO TABLE-1                  
                 MOVE SPACES                TO TABLE-ELEMENT-1          
                 MOVE SPACES                TO HOSTVAR-ELEMENT-1        
                 PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C8 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT  DISTINCT RETURN_CODE                            
                       ,APPL_RETURN_CODE                                
                       ,LTRIM(RTRIM(TABLE_ID))           AS TABLE_ID           
                       ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO         
                       ,LTRIM(RTRIM(OFFER_CD))           AS OFFER_CD           
                       ,LTRIM(RTRIM(OPTION_CD))          AS OPTION_CD          
                       ,OPTION_SORT_SEQ_NO        AS OPTION_SORT_SEQ_NO 
                       ,LTRIM(RTRIM(LAST_UPDATE_USERID)) AS 
           LAST_UPDATE_USERID 
                       ,LTRIM(RTRIM(LAST_UPDATE_TS))     AS 
           LAST_UPDATE_TS     
                       ,LTRIM(RTRIM(OFFER_OPT_START_DT)) AS 
           OFFER_OPT_START_DT 
                       ,LTRIM(RTRIM(OFFER_OPT_END_DT))   AS 
           OFFER_OPT_END_DT   
                       ,OFF_OPT_VRSN_NO           AS OFF_OPT_VRSN_NO    
                       ,LTRIM(RTRIM(OFF_OPT_VSTART_TS))  AS 
           OFF_OPT_VSTART_TS  
                       ,LTRIM(RTRIM(OFF_OPT_VEND_TS))    AS 
           OFF_OPT_VEND_TS    
                       ,LTRIM(RTRIM(PROC_STATUS_CD))     AS 
           PROC_STATUS_CD     
                       ,PROC_REQ_ID               AS PROC_REQ_ID        
A04805                 ,LTRIM(RTRIM(WEB_NEW_EXISTS_CD))  AS 
           WEB_NEW_EXISTS_CD  
A04805                 ,LTRIM(RTRIM(WEB_SIGN_UP_FL))     AS 
           WEB_SIGN_UP_FL     
A04805                 ,LTRIM(RTRIM(OFF_OPT_EXCLUDE_CD)) AS 
           OFF_OPT_EXCLUDE_CD 
                  FROM #CSR04426_R8                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C8 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT  DISTINCT RETURN_CODE                                    
MFA-TR*                ,APPL_RETURN_CODE                                        
MFA-TR*                ,STRIP(TABLE_ID)           AS TABLE_ID                   
MFA-TR*                ,STRIP(COMPANY_NO)         AS COMPANY_NO                 
MFA-TR*                ,STRIP(OFFER_CD)           AS OFFER_CD                   
MFA-TR*                ,STRIP(OPTION_CD)          AS OPTION_CD                  
MFA-TR*                ,OPTION_SORT_SEQ_NO        AS OPTION_SORT_SEQ_NO         
MFA-TR*                ,STRIP(LAST_UPDATE_USERID) AS LAST_UPDATE_USERID         
MFA-TR*                ,STRIP(LAST_UPDATE_TS)     AS LAST_UPDATE_TS             
MFA-TR*                ,STRIP(OFFER_OPT_START_DT) AS OFFER_OPT_START_DT         
MFA-TR*                ,STRIP(OFFER_OPT_END_DT)   AS OFFER_OPT_END_DT           
MFA-TR*                ,OFF_OPT_VRSN_NO           AS OFF_OPT_VRSN_NO            
MFA-TR*                ,STRIP(OFF_OPT_VSTART_TS)  AS OFF_OPT_VSTART_TS          
MFA-TR*                ,STRIP(OFF_OPT_VEND_TS)    AS OFF_OPT_VEND_TS            
MFA-TR*                ,STRIP(PROC_STATUS_CD)     AS PROC_STATUS_CD             
MFA-TR*                ,PROC_REQ_ID               AS PROC_REQ_ID                
MFA-TR*                ,STRIP(WEB_NEW_EXISTS_CD)  AS WEB_NEW_EXISTS_CD          
MFA-TR*                ,STRIP(WEB_SIGN_UP_FL)     AS WEB_SIGN_UP_FL             
MFA-TR*                ,STRIP(OFF_OPT_EXCLUDE_CD) AS OFF_OPT_EXCLUDE_CD         
MFA-TR*           FROM SESSION.CSR04426_R8                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100H-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-VALIDATE-INPUT      THRU 1100-EXIT.             
                                                                        
           MOVE I-OFFER-CD                  TO E9-OFFER-CD              
                                               FG-OFFER-CD              
                                               CI-OFFER-CD              
                                               DU-OFFER-CD              
                                               KM-OFFER-CD              
                                               G5-OFFER-CD.             
                                                                        
           MOVE I-OPTION-CD                 TO FI-OPTION-CD             
                                               HQ-OPTION-CD             
                                               E9-OPTION-CD             
                                               CI-OPTION-CD.            
                                                                        
           MOVE I-PROMO-CD                  TO KM-PROMO-CD.             
                                                                        
           MOVE I-VERSION-NO                TO FG-OFF-VRSN-NO           
                                               DU-OFF-TIER-VRSN-NO      
                                               FI-OPT-VRSN-NO           
                                               KM-PROMO-VRSN-NO.        
                                                                        
           MOVE I-PROC-REQ-ID               TO FG-PROC-REQ-ID           
                                               FI-PROC-REQ-ID           
                                               DU-PROC-REQ-ID           
                                               G5-PROC-REQ-ID           
                                               CI-PROC-REQ-ID           
                                               HQ-PROC-REQ-ID           
                                               KM-PROC-REQ-ID           
                                               E9-PROC-REQ-ID           
                                               WS-PROCESS-REQ-ID.       
                                                                        
           MOVE I-RESOURCE-ID               TO WS-RPM-WIZARDS.          
                                                                        
           MOVE '01'                        TO E9-COMPANY-NO            
                                               FG-COMPANY-NO            
                                               CI-COMPANY-NO            
                                               DU-COMPANY-NO            
                                               FI-COMPANY-NO            
                                               HQ-COMPANY-NO            
                                               KM-COMPANY-NO            
                                               G5-COMPANY-NO.           
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
           PERFORM 0100E-DECLARE-GTT-R5        THRU 0100E-EXIT.         
           PERFORM 0100F-DECLARE-GTT-R6        THRU 0100F-EXIT.         
           PERFORM 0100G-DECLARE-GTT-R7        THRU 0100G-EXIT.         
           PERFORM 0100H-DECLARE-GTT-R8        THRU 0100H-EXIT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * VALIDATION FOR INPUT VARIABLES                                *         
      *****************************************************************         
       1100-VALIDATE-INPUT.                                             
                                                                        
           IF (((I-OFFER-CD > SPACES   OR I-OPTION-CD > SPACES OR       
                 I-PROMO-CD > SPACES) AND I-VERSION-NO > 0 )            
                 OR I-PROC-REQ-ID > 0 AND I-RESOURCE-ID > SPACES)       
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '1100'                TO ACTIVE-PARAGRAPH            
              MOVE 'RECEIVE INPUT'       TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE SPACES                TO TABLE-1                     
              MOVE SPACES                TO TABLE-ELEMENT-1             
              MOVE SPACES                TO HOSTVAR-ELEMENT-1           
      *************************************************************             
      * IF OFFER OR OPTION OR PROMO OR PROC REQ ID IS INVALID     *             
      *************************************************************             
              MOVE +0                    TO WS-ACTIVE-RETURN-CODE       
              MOVE +1000                 TO WS-APPL-RETURN-CODE         
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7105-ACCEPT-TIMESTAMP  THRU 7105-EXIT.               
                                                                        
           EVALUATE TRUE                                                
               WHEN I-OFFER-CD    > SPACES                              
               WHEN CREATE-OFFER-WIZARD                                 
               WHEN MODIFY-OFFER-WIZARD                                 
               WHEN CREATE-REPLACE-OFFER-WIZARD                         
                    PERFORM 2200-PROCESS-OFFER-CD    THRU 2200-EXIT     
               WHEN I-OPTION-CD   > SPACES                              
               WHEN MODIFY-OPTION-WIZARD                                
               WHEN VIEW-OPTION-WIZARD                                  
                    PERFORM 2100-PROCESS-OPTION-CODE THRU 2100-EXIT     
               WHEN I-PROMO-CD    > SPACES                              
               WHEN CREATE-PROMO-WIZARD                                 
               WHEN MODIFY-PROMO-WIZARD                                 
               WHEN VIEW-PROMOTION-WIZARD                               
                    PERFORM 2300-PROCESS-PROMO-CD    THRU 2300-EXIT     
           END-EVALUATE.                                                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * INPUT  - OPTION CODE.                                          *        
      * GETTING  OPTION CODE ,ATTRIBUTE INCENTIVE AND OFFER DETAILS.   *        
      ******************************************************************        
       2100-PROCESS-OPTION-CODE.                                        
                                                                        
      *    GETTING OPTION DETAILS BASED ON OPTION CD                            
           PERFORM 7100-GET-OPTION-DET-DRIVE   THRU 7100-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                     
                                      FI-PROC-REQ-ID > 0                
              SET OPTION-NOT-FOUND    TO TRUE                           
      *    IN MODIFY OPTION WIZARD,IF THERE IS NO OPTION CHANGE AND             
      *    ADDING NEW ATTR INCTV / SECUTITY ACCESS, IN THIS CASE ITT            
      *    SHOULD PULL THE OPTION CODE FROM THE CHILD TABLE TO                  
      *    PROCEED FURTHER.                                                     
              PERFORM 2220-GET-OPT-FROM-CHILD-TBL THRU 2220-EXIT        
              IF OPTION-FOUND                                           
                 PERFORM 7060-GET-OFF-MAX-VRSN-NO THRU 7060-EXIT        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    PERFORM 9999-END-PROGRAM      THRU 9999-EXIT        
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 2400-MOVE-OPTION-RS2        THRU 2400-EXIT.          
                                                                        
           MOVE FI-OPTION-CD                TO HQ-OPTION-CD             
                                               E9-OPTION-CD             
                                               CI-OPTION-CD             
      *                                                                         
           MOVE FI-OPT-VSTART-TS            TO WS-VERSION-START-TS      
           MOVE FI-OPT-VEND-TS              TO WS-VERSION-END-TS        
           MOVE FI-OPTION-START-DT          TO WS-ACTIVE-START-DT       
           MOVE FI-OPTION-END-DT            TO WS-ACTIVE-END-DT         
                                                                        
      *    GETTING ATTRIBUTE INCENTIVE DETAILS BASED ON OPTION CD               
           MOVE 'N'                         TO WS-NO-MORE-ROWS          
           PERFORM 7110-OPEN-ATTR-INCEN-CUR    THRU 7110-EXIT           
           PERFORM 7120-FETCH-ATTR-INCEN-CUR   THRU 7120-EXIT           
           PERFORM 2410-MOVE-ATTR-INCEN-RS3    THRU 2410-EXIT           
                                               UNTIL NO-MORE-ATTR-ROWS  
           PERFORM 7130-CLOSE-ATTR-INCEN-CUR   THRU 7130-EXIT           
                                                                        
      *    GETTING SECURED OFF/OPT DETAILS BASED ON OPTION CD                   
           MOVE 'N'                         TO WS-NO-MORE-ROWS          
           MOVE SPACES                      TO CI-OFFER-CD              
           PERFORM 7140-OPEN-SECURED-OFF-OPT   THRU 7140-EXIT           
           PERFORM 7150-FETCH-SECURED-OFF-OPT  THRU 7150-EXIT           
           PERFORM 2440-MOVE-SECURE-OFF-OPT-RS4                         
                                               THRU 2440-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7160-CLOSE-SECURED-OFF-OPT  THRU 7160-EXIT           
                                                                        
      *    GETTING OFFER DETAILS BASED ON OPTION CD                             
           MOVE 'N'                         TO WS-NO-MORE-ROWS          
           PERFORM 7230-OPEN-OFF-OPT-FOR-OPTION                         
                                               THRU 7230-EXIT           
           PERFORM 7240-FETCH-OFF-OPT-FOR-OPTION                        
                                               THRU 7240-EXIT           
           PERFORM 2415-GET-OFFER-DET-FOR-OPTION                        
                                               THRU 2415-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7250-CLOSE-OFF-OPT-FOR-OPTION                        
                                               THRU 7250-EXIT.          
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * INPUT - OFFER CODE                                             *        
      * GETTING OFFER ,PROMOTION,SECURED OFF/OPT,MARKET TIER           *        
      * ATTR/INCENV AND OPTION CODE DETAILS                            *        
      ******************************************************************        
       2200-PROCESS-OFFER-CD.                                           
                                                                        
                                                                        
      *    GETTING OFFER DETAILS BASED ON OFFER CD.                             
           PERFORM 7000-GET-OFFER-DET-DRIVE   THRU 7000-EXIT.           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                     
                                      FG-PROC-REQ-ID > 0                
              SET OFFER-NOT-FOUND    TO TRUE                            
      *    IN MODIFY OFFER WIZARD,IF THERE IS NO OFFER CHANGE AND               
      *    ADDING NEW TIER/GRP/ACCESS/PROMO/OFFER-OPTION, IN THIS               
      *    CASE IT SHOULD PULL THE OFFER CODE FROM THE CHILD TABLE              
      *    TO PROCESS FURTHER.                                                  
              PERFORM 2210-GET-OFF-FROM-CHILD-TBL THRU 2210-EXIT        
              IF OFFER-FOUND                                            
      *    GETTING MAX VERSION OF OFFER TO PROCEED FURTHER                      
                 PERFORM 7050-GET-OFF-MAX-VRSN-NO THRU 7050-EXIT        
                 IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    PERFORM 9999-END-PROGRAM      THRU 9999-EXIT        
                 END-IF                                                 
              ELSE                                                      
                 PERFORM 9999-END-PROGRAM         THRU 9999-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *    TO GET TEMPLATE OFFER / PROMO FLAG / DFLT OFF TIER FLAG.             
           MOVE FG-PROC-REQ-ID  TO 1P-PROC-REQ-ID                       
                                   DU-PROC-REQ-ID.                      
           PERFORM 7004-GET-PROC-TYPE-CD      THRU 7004-EXIT.           
           MOVE 1P-PROC-TYPE-CD TO WS-RPM003-WIZARD                     
           IF CREATE-REPLACE-OFF-WIZARD                                 
              PERFORM 7005-CHK-TMPLT-OFF-IS-EXIST                       
                                              THRU 7005-EXIT            
              IF WS-TEMPLATE-OFFER-EXIST = WS-YES                       
                 MOVE WS-YES    TO WS-SET-PROMO-FLGS                    
              END-IF                                                    
                                                                        
              PERFORM 7006-CHK-TMPLT-OFF-TIER-EXIST                     
                                              THRU 7006-EXIT            
              IF WS-TMPLT-OFF-TIER-EXIST = WS-YES                       
                 MOVE WS-YES    TO WS-UNDFLT-OFF-TIER-FLAG              
              END-IF                                                    
                                                                        
PRJ473        MOVE FG-OFFER-CD                TO KM-OFFER-CD            
PRJ473        IF FG-PROC-STATUS-CD NOT EQUAL 'AC'                       
PRJ473           PERFORM 7070-GET-TEMPLATED-OFFER THRU 7070-EXIT        
PRJ473        END-IF                                                    
                                                                        
           END-IF.                                                      
                                                                        
           PERFORM 2420-MOVE-OFFER-RS1        THRU 2420-EXIT.           
                                                                        
           MOVE FG-OFFER-CD                TO KM-OFFER-CD               
                                              CI-OFFER-CD               
                                              DU-OFFER-CD               
                                              G5-OFFER-CD               
                                              E9-OFFER-CD               
      *                                                                         
           MOVE FG-OFF-VSTART-TS           TO WS-VERSION-START-TS       
           MOVE FG-OFF-VEND-TS             TO WS-VERSION-END-TS         
           MOVE FG-OFFER-START-DT          TO WS-ACTIVE-START-DT        
           MOVE FG-OFFER-END-DT            TO WS-ACTIVE-END-DT          
                                                                        
      *    GETTING PROMOTION DETAILS BASED ON OFFER CD                          
           MOVE 'N'                        TO WS-NO-MORE-ROWS           
           PERFORM 7170-OPEN-MKT-PROMOTION     THRU 7170-EXIT           
           PERFORM 7180-FETCH-MKT-PROMOTION    THRU 7180-EXIT           
           PERFORM 2240-GET-PROMOTION-DET      THRU 2240-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7190-CLOSE-MKT-PROMOTION    THRU 7190-EXIT           
                                                                        
      *    GETTING SECURED OFF/OPT DETAILS BASED ON OFFER CD                    
           MOVE 'N'                         TO WS-NO-MORE-ROWS          
           MOVE SPACES                      TO CI-OPTION-CD             
           PERFORM 7140-OPEN-SECURED-OFF-OPT   THRU 7140-EXIT           
           PERFORM 7150-FETCH-SECURED-OFF-OPT  THRU 7150-EXIT           
           PERFORM 2440-MOVE-SECURE-OFF-OPT-RS4                         
                                               THRU 2440-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7160-CLOSE-SECURED-OFF-OPT  THRU 7160-EXIT           
                                                                        
      *    GETTING MARKET TIER DETAILS BASED ON OFFER CD                        
           MOVE 'N'                         TO WS-NO-MORE-ROWS          
           PERFORM 7200-OPEN-OFF-MKT-TIER      THRU 7200-EXIT           
           PERFORM 7210-FETCH-OFF-MKT-TIER     THRU 7210-EXIT           
           PERFORM 2450-MOVE-MKT-TIER-RS6      THRU 2450-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7220-CLOSE-OFF-MKT-TIER     THRU 7220-EXIT           
                                                                        
      *    GETTING RATE GROUP OFFER DETAILS BASED ON OFFER CD                   
           MOVE 'N'                         TO WS-NO-MORE-ROWS          
           PERFORM 7290-OPEN-RATE-GRP-OFFER    THRU 7290-EXIT           
           PERFORM 7300-FETCH-RATE-GRP-OFFER   THRU 7300-EXIT           
           PERFORM 2460-MOVE-RATE-GRP-OFF-RS7  THRU 2460-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7310-CLOSE-RATE-GRP-OFFER   THRU 7310-EXIT.          
                                                                        
      *    GETTING OFFER-OPTION / ATTR/INCENV / OPTION DETAILS                  
      *    BASED ON OFFER CODE.                                                 
           MOVE 'N'                         TO WS-NO-MORE-ROWS          
           PERFORM 7260-OPEN-OFF-OPT-FOR-OFFER THRU 7260-EXIT.          
           PERFORM 7270-FETCH-OFF-OPT-FOR-OFFER                         
                                               THRU 7270-EXIT.          
           PERFORM 2250-GET-OPT-ATTR-INCEV     THRU 2250-EXIT           
                                               UNTIL NO-MORE-ROWS.      
           PERFORM 7280-CLOSE-OFF-OPT-FOR-OFFER                         
                                               THRU 7280-EXIT.          
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2210-GET-OFF-FROM-CHILD-TBL.                  *                         
      ******************************************************************        
       2210-GET-OFF-FROM-CHILD-TBL.                                     
                                                                        
      *    GET OFFER CODE FROM OFF MARKET TIER TABLE.                           
           PERFORM 7007-GET-OFF-FRM-OFF-MKT-TR THRU 7007-EXIT           
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DU-OFFER-CD    TO FG-OFFER-CD                        
              SET OFFER-FOUND     TO TRUE                               
           END-IF.                                                      
      *    GET OFFER CODE FROM RATE GROUP OFFER TABLE                           
           IF OFFER-NOT-FOUND                                           
              PERFORM 7008-GET-OFF-FRM-OFF-RT-GRP THRU 7008-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE G5-OFFER-CD    TO FG-OFFER-CD                     
                 SET OFFER-FOUND     TO TRUE                            
              END-IF                                                    
           END-IF.                                                      
      *    GET OFFER CODE FROM OFF ACCESS TABLE.                                
           IF OFFER-NOT-FOUND                                           
              PERFORM 7009-GET-OFF-FRM-OFF-ACCESS THRU 7009-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE CI-OFFER-CD    TO FG-OFFER-CD                     
                 SET OFFER-FOUND     TO TRUE                            
              END-IF                                                    
           END-IF.                                                      
      *    GET OFFER CODE FROM MKT PROMOTION TABLE.                             
           IF OFFER-NOT-FOUND                                           
              PERFORM 7010-GET-OFF-FRM-OFF-PROMO  THRU 7010-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE KM-OFFER-CD    TO FG-OFFER-CD                     
                 SET OFFER-FOUND     TO TRUE                            
              END-IF                                                    
           END-IF.                                                      
      *    GET OFFER CODE FROM OFFER OPTION TABLE                               
           IF OFFER-NOT-FOUND                                           
              PERFORM 7011-GET-OFF-FRM-OFF-OPT    THRU 7011-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE E9-OFFER-CD    TO FG-OFFER-CD                     
                 SET OFFER-FOUND     TO TRUE                            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2220-GET-OPT-FROM-CHILD-TBL.                  *                         
      ******************************************************************        
       2220-GET-OPT-FROM-CHILD-TBL.                                     
                                                                        
      *    GET OPTION CODE FROM ATTR INCTV TABLE.                               
           PERFORM 7012-GET-OPT-FRM-ATTR-INCTV    THRU 7012-EXIT        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE HQ-OPTION-CD      TO FI-OPTION-CD                    
              SET OPTION-FOUND       TO TRUE                            
           END-IF.                                                      
      *    GET OPTION CODE FROM SECURITY ACCESS TABLE.                          
           IF OFFER-NOT-FOUND                                           
              PERFORM 7013-GET-OPT-FRM-OFF-ACCESS THRU 7013-EXIT        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE CI-OPTION-CD   TO FI-OPTION-CD                    
                 SET OPTION-FOUND    TO TRUE                            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *2240-GET-PROMOTION-DET.                                        *         
      ******************************************************************        
       2240-GET-PROMOTION-DET.                                          
                                                                        
           IF WS-PROMO-FIRST-FETCH EQUAL  WS-YES                        
              PERFORM 7014-GET-PROMO-REUSED-FLAG THRU 7014-EXIT         
              MOVE WS-NO                 TO WS-PROMO-FIRST-FETCH        
      * WHEN THE PROMOTION HAS REUSED WITH OTHER OFFERS(PROMO STATUS            
      * NW/PA/EA ) SHOULD NOT ALLOW TO EDIT THE PROMO THROUGH OLD OFFER.        
              IF WS-PROMO-OFFER-CD NOT EQUAL KM-OFFER-CD AND            
                 ((WS-PROMO-PROC-STATUS-CD NOT EQUAL                    
                                    WS-PROC-STATUS-APRVL-CMPLT )        
                                    OR                                  
      * WHEN THE PROMOTION HAS REUSED WITH OTHER OFFERS( PROMOTION              
      * STATUS AC ) SHOULD NOT ALLOW TO EDIT THE PROMO THROUGH OLD OFFER        
      * WHEN THE LATEST VERSION IS FUTURE DATE.                                 
                 (WS-PROMO-PROC-STATUS-CD  EQUAL                        
                  WS-PROC-STATUS-APRVL-CMPLT AND                        
                  WS-PROMO-START-DT-TM >= WS-CURRENT-TIMESTAMP ))       
                                                                        
                 MOVE WS-YES             TO WS-PROMO-REUSED-FLAG        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 2430-MOVE-PROMO-RS5         THRU 2430-EXIT           
           PERFORM 7180-FETCH-MKT-PROMOTION    THRU 7180-EXIT.          
                                                                        
       2240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *2250-GET-OPT-ATTR-INCEV.                                       *         
      ******************************************************************        
       2250-GET-OPT-ATTR-INCEV.                                         
                                                                        
           MOVE WS-NO                       TO WS-NO-MORE-OPTION-ROWS   
           MOVE E9-OPTION-CD                TO FI-OPTION-CD             
           MOVE E9-OFFER-OPT-START-DT       TO WS-ACTIVE-START-DT       
           MOVE E9-OFFER-OPT-END-DT         TO WS-ACTIVE-END-DT         
           MOVE E9-OFF-OPT-VSTART-TS        TO WS-VERSION-START-TS      
           MOVE E9-OFF-OPT-VEND-TS          TO WS-VERSION-END-TS        
                                                                        
           PERFORM 7101-OPEN-OPTION-DET-CUR    THRU 7101-EXIT           
           PERFORM 7102-FETCH-OPTION-DET-CUR   THRU 7102-EXIT           
           PERFORM 2310-MOVE-OPTION-DET        THRU 2310-EXIT           
                                               UNTIL NO-MORE-OPTION-ROWS
           PERFORM 7103-CLOSE-OPTION-DET-CUR   THRU 7103-EXIT           
                                                                        
      *    GETTING ATTR/INCENV DETAILS BASED ON OPTION CD                       
           IF ROW-FOUND-FOR-OPTION                                      
              MOVE WS-NO                    TO WS-EOF-ATTR-CURSOR       
              MOVE FI-OPTION-CD             TO HQ-OPTION-CD             
              MOVE FI-OPTION-START-DT       TO WS-ACTIVE-START-DT       
              MOVE FI-OPTION-END-DT         TO WS-ACTIVE-END-DT         
              MOVE FI-OPT-VSTART-TS         TO WS-VERSION-START-TS      
              MOVE FI-OPT-VEND-TS           TO WS-VERSION-END-TS        
                                                                        
              PERFORM 7110-OPEN-ATTR-INCEN-CUR  THRU 7110-EXIT          
              PERFORM 7120-FETCH-ATTR-INCEN-CUR THRU 7120-EXIT          
              PERFORM 2410-MOVE-ATTR-INCEN-RS3  THRU 2410-EXIT          
                                                UNTIL NO-MORE-ATTR-ROWS 
              PERFORM 7130-CLOSE-ATTR-INCEN-CUR THRU 7130-EXIT          
           END-IF                                                       
                                                                        
           PERFORM 2470-MOVE-OFFER-OPTION-RS8  THRU 2470-EXIT.          
           PERFORM 7270-FETCH-OFF-OPT-FOR-OFFER                         
                                               THRU 7270-EXIT.          
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * INPUT - PROMOTION CODE                                        *         
      * GETTING PROMOTION DETAILS AND GETTING OFFER DETAILS           *         
      ******************************************************************        
       2300-PROCESS-PROMO-CD.                                           
                                                                        
      *    GETTING PROMOTION DETAILS BASED ON PROMO CD                          
           PERFORM 7500-GET-MKT-PROMOTION-DET  THRU 7500-EXIT.          
           PERFORM 2430-MOVE-PROMO-RS5         THRU 2430-EXIT.          
      *                                                                         
           MOVE KM-PROMO-VSTART-TS          TO WS-VERSION-START-TS      
           MOVE KM-PROMO-VEND-TS            TO WS-VERSION-END-TS        
           MOVE KM-PROMO-START-DT           TO WS-ACTIVE-START-DT       
           MOVE KM-PROMO-END-DT             TO WS-ACTIVE-END-DT         
                                                                        
      *    GETTING OFFER DETAILS BASED ON OFFER CD                              
           MOVE WS-NO                       TO WS-NO-MORE-OFFER-ROWS    
           MOVE KM-OFFER-CD                 TO FG-OFFER-CD.             
           PERFORM 7001-OPEN-OFFER-DET-CUR     THRU 7001-EXIT           
           PERFORM 7002-FETCH-OFFER-DET-CUR    THRU 7002-EXIT           
           PERFORM 2416-MOVE-OFFER-DATA        THRU 2416-EXIT           
                                               UNTIL NO-MORE-OFFER-ROWS 
           PERFORM 7003-CLOSE-OFFER-DET-CUR    THRU 7003-EXIT           
                                                                        
      *    GETTING RATE GROUP OFFER DETAILS BASED ON OFFER CD                   
           MOVE WS-NO                       TO WS-NO-MORE-ROWS          
           MOVE KM-OFFER-CD                 TO G5-OFFER-CD              
           MOVE FG-OFF-VSTART-TS            TO WS-VERSION-START-TS      
           MOVE FG-OFF-VEND-TS              TO WS-VERSION-END-TS        
           MOVE FG-OFFER-START-DT           TO WS-ACTIVE-START-DT       
           MOVE FG-OFFER-END-DT             TO WS-ACTIVE-END-DT         
                                                                        
           PERFORM 7290-OPEN-RATE-GRP-OFFER    THRU 7290-EXIT           
           PERFORM 7300-FETCH-RATE-GRP-OFFER   THRU 7300-EXIT           
           PERFORM 2460-MOVE-RATE-GRP-OFF-RS7  THRU 2460-EXIT           
                                               UNTIL NO-MORE-ROWS       
           PERFORM 7310-CLOSE-RATE-GRP-OFFER   THRU 7310-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2310-MOVE-OPTION-DET.                                            
                                                                        
           PERFORM 2400-MOVE-OPTION-RS2        THRU 2400-EXIT           
           PERFORM 7102-FETCH-OPTION-DET-CUR   THRU 7102-EXIT.          
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-MOVE-OPTION-RS2. CRM-RT-PKG-OPTION                        *        
      ******************************************************************        
       2400-MOVE-OPTION-RS2.                                            
                                                                        
           MOVE 'FI'                        TO S-RS2-TABLE-ID           
           MOVE FI-COMPANY-NO               TO S-RS2-COMPANY-NO         
           MOVE FI-OPTION-CD                TO S-RS2-OPTION-CD          
           MOVE FI-CODE-UTIL-TYPE           TO S-RS2-CODE-UTIL-TYPE     
           MOVE FI-RATE-PLAN-NO             TO S-RS2-RATE-PLAN-NO       
           MOVE FI-OPTION-START-DT          TO S-RS2-OPTION-START-DT    
           MOVE FI-OPTION-END-DT            TO S-RS2-OPTION-END-DT      
           MOVE FI-OPT-DESC-INT             TO S-RS2-OPT-DESC-INT       
           MOVE FI-OPT-DESC-INT-LONG        TO S-RS2-OPT-DESC-INT-LONG  
           MOVE FI-CURR-EXT-DESC-LONG       TO S-RS2-CURR-EXT-DESC-LONG 
           MOVE FI-RENEWAL-DESC-LONG        TO S-RS2-RENEWAL-DESC-LONG  
           MOVE FI-WEB-DESC-LONG            TO S-RS2-WEB-DESC-LONG      
           MOVE FI-STATUS-CD                TO S-RS2-STATUS-CD          
           MOVE FI-LAST-UPDATE-USERID       TO S-RS2-LAST-UPDATE-USERID 
           MOVE FI-LAST-UPDATE-TS           TO S-RS2-LAST-UPDATE-TS     
           MOVE FI-OPT-CALC-TYPE-CD         TO S-RS2-OPT-CALC-TYPE-CD   
           MOVE FI-WEB-MKT-DESC-LONG        TO S-RS2-WEB-MKT-DESC-LONG  
           MOVE FI-OPT-VRSN-NO              TO S-RS2-OPT-VRSN-NO        
           MOVE FI-OPT-VSTART-TS            TO S-RS2-OPT-VSTART-TS      
           MOVE FI-OPT-VEND-TS              TO S-RS2-OPT-VEND-TS        
           MOVE FI-PROC-STATUS-CD           TO S-RS2-PROC-STATUS-CD     
           MOVE FI-PROC-REQ-ID              TO S-RS2-PROC-REQ-ID        
A04805     MOVE FI-OPTION-TYPE-DESC         TO S-RS2-OPTION-TYPE-DESC   
PRJ892     MOVE FI-AUTO-RENEWAL-FL          TO S-RS2-AUTO-RENEWAL-FL    
PRJ892     MOVE FI-OPTION-PROMO-DESC        TO S-RS2-OPTION-PROMO-DESC  
                                                                        
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2410-MOVE-ATTR-INCEN-RS3. CRM_OPT_ATTR_INCTV                   *        
      ******************************************************************        
       2410-MOVE-ATTR-INCEN-RS3.                                        
                                                                        
           MOVE 'HQ'                        TO S-RS3-TABLE-ID           
           MOVE HQ-COMPANY-NO               TO S-RS3-COMPANY-NO         
           MOVE HQ-OPTION-CD                TO S-RS3-OPTION-CD          
           MOVE HQ-ATTR-INCTV-SEQ-NO        TO S-RS3-ATTR-INCTV-SEQ-NO  
           MOVE HQ-RT-ATTR-INCTV-TYPE       TO S-RS3-RT-ATTR-INCTV-TYPE 
           MOVE HQ-PRIMRY-OPT-ATTR-FL       TO S-RS3-PRIMRY-OPT-ATTR-FL 
           MOVE HQ-FACTOR-ID                TO S-RS3-FACTOR-ID          
           MOVE HQ-DURATION-NO              TO S-RS3-DURATION-NO        
           MOVE HQ-APPL-PROGRAM-ID          TO S-RS3-APPL-PROGRAM-ID    
           MOVE HQ-ATTR-INCTV-VALUE         TO S-RS3-ATTR-INCTV-VALUE   
           MOVE HQ-ATTR-INCTV-VAL-TX        TO S-RS3-ATTR-INCTV-VAL-TX  
           MOVE HQ-LAST-UPDATE-USERID       TO S-RS3-LAST-UPDATE-USERID 
           MOVE HQ-LAST-UPDATE-TS           TO S-RS3-LAST-UPDATE-TS     
           MOVE HQ-GL-ACCT-CREDIT           TO S-RS3-GL-ACCT-CREDIT     
           MOVE HQ-GL-ACCT-DEBIT            TO S-RS3-GL-ACCT-DEBIT      
           MOVE HQ-CATEGORY-ID              TO S-RS3-CATEGORY-ID        
           MOVE HQ-WQ-ROUTE-CATEGORY        TO S-RS3-WQ-ROUTE-CATEGORY  
           MOVE HQ-OPT-CHG-ACTION-CD        TO S-RS3-OPT-CHG-ACTION-CD  
           MOVE HQ-ATTR-INCTV-STRT-DT       TO S-RS3-ATTR-INCTV-STRT-DT 
           MOVE HQ-ATTR-INCTV-END-DT        TO S-RS3-ATTR-INCTV-END-DT  
           MOVE HQ-OPT-ATTR-VRSN-NO         TO S-RS3-OPT-ATTR-VRSN-NO   
           MOVE HQ-OPT-ATTR-VSTART-TS       TO S-RS3-OPT-ATTR-VSTART-TS 
           MOVE HQ-OPT-ATTR-VEND-TS         TO S-RS3-OPT-ATTR-VEND-TS   
           MOVE HQ-PROC-STATUS-CD           TO S-RS3-PROC-STATUS-CD     
           MOVE HQ-PROC-REQ-ID              TO S-RS3-PROC-REQ-ID        
                                                                        
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT           
           PERFORM 7120-FETCH-ATTR-INCEN-CUR   THRU 7120-EXIT.          
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *2415-GET-OFFER-DET-FOR-OPTION.                                  *        
      ******************************************************************        
       2415-GET-OFFER-DET-FOR-OPTION.                                   
                                                                        
           MOVE WS-NO                       TO WS-NO-MORE-OFFER-ROWS    
           MOVE E9-OFFER-CD                 TO FG-OFFER-CD              
           MOVE E9-OFFER-OPT-START-DT       TO WS-ACTIVE-START-DT       
           MOVE E9-OFFER-OPT-END-DT         TO WS-ACTIVE-END-DT         
           MOVE E9-OFF-OPT-VSTART-TS        TO WS-VERSION-START-TS      
           MOVE E9-OFF-OPT-VEND-TS          TO WS-VERSION-END-TS        
                                                                        
           PERFORM 7001-OPEN-OFFER-DET-CUR     THRU 7001-EXIT           
           PERFORM 7002-FETCH-OFFER-DET-CUR    THRU 7002-EXIT           
           PERFORM 2416-MOVE-OFFER-DATA        THRU 2416-EXIT           
                                               UNTIL NO-MORE-OFFER-ROWS 
           PERFORM 7003-CLOSE-OFFER-DET-CUR    THRU 7003-EXIT           
                                                                        
           PERFORM 2470-MOVE-OFFER-OPTION-RS8  THRU 2470-EXIT.          
           PERFORM 7240-FETCH-OFF-OPT-FOR-OPTION                        
                                               THRU 7240-EXIT.          
                                                                        
       2415-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2416-MOVE-OFFER-DATA.                                            
                                                                        
           PERFORM 2420-MOVE-OFFER-RS1         THRU 2420-EXIT           
           PERFORM 7002-FETCH-OFFER-DET-CUR    THRU 7002-EXIT.          
                                                                        
       2416-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2420-MOVE-OFFER-RS1.  CRM-RT-PKG-OFFER                         *        
      ******************************************************************        
       2420-MOVE-OFFER-RS1.                                             
                                                                        
           MOVE 'FG'                        TO S-RS1-TABLE-ID           
           MOVE FG-COMPANY-NO               TO S-RS1-COMPANY-NO         
           MOVE FG-OFFER-CD                 TO S-RS1-OFFER-CD           
           MOVE FG-OFFER-DESC-INT           TO S-RS1-OFFER-DESC-INT     
           MOVE FG-OFFER-DESC-EXT           TO S-RS1-OFFER-DESC-EXT     
           MOVE FG-PROMO-CD-INT-FL          TO S-RS1-PROMO-CD-INT-FL    
           MOVE FG-PROMO-CD-EXT-FL          TO S-RS1-PROMO-CD-EXT-FL    
           MOVE FG-OFFER-START-DT           TO S-RS1-OFFER-START-DT     
           MOVE FG-OFFER-END-DT             TO S-RS1-OFFER-END-DT       
           MOVE FG-DISP-START-INT-TS        TO S-RS1-DISP-START-INT-TS  
           MOVE FG-DISP-END-INT-TS          TO S-RS1-DISP-END-INT-TS    
           MOVE FG-DISP-START-EXT-TS        TO S-RS1-DISP-START-EXT-TS  
           MOVE FG-DISP-END-EXT-TS          TO S-RS1-DISP-END-EXT-TS    
           MOVE FG-LAST-UPDATE-TS           TO S-RS1-LAST-UPDATE-TS     
           MOVE FG-LAST-UPDATE-USERID       TO S-RS1-LAST-UPDATE-USERID 
           MOVE FG-OFFER-DESC-INT-LNG       TO S-RS1-OFFER-DESC-INT-LNG 
           MOVE FG-OFFER-DESC-EXT-LNG       TO S-RS1-OFFER-DESC-EXT-LNG 
           MOVE FG-SPCL-OFFER-TYPE-CD       TO S-RS1-SPCL-OFFER-TYPE-CD 
           MOVE FG-RENEWAL-OFFER-CD         TO S-RS1-RENEWAL-OFFER-CD   
           MOVE FG-RENEW-PUB-OFFER-CD       TO S-RS1-RENEW-PUB-OFFER-CD 
           MOVE FG-OFF-VRSN-NO              TO S-RS1-OFF-VRSN-NO        
           MOVE FG-OFF-VSTART-TS            TO S-RS1-OFF-VSTART-TS      
           MOVE FG-OFF-VEND-TS              TO S-RS1-OFF-VEND-TS        
           MOVE FG-PROC-STATUS-CD           TO S-RS1-PROC-STATUS-CD     
           MOVE FG-PROC-REQ-ID              TO S-RS1-PROC-REQ-ID        
           MOVE WS-TEMPLATE-OFFER           TO S-RS1-TEMPLATE-OFFER     
           MOVE WS-SET-PROMO-FLGS           TO S-RS1-SET-PROMO-FLGS     
           MOVE WS-UNDFLT-OFF-TIER-FLAG    TO S-RS1-UNDFLT-OFF-TIER-FLAG
PRJ473     MOVE WS-TEMPLATE-INT-DESC        TO S-RS1-TEMPLATE-INT-DESC. 
PRJ473     MOVE WS-TEMPLATE-REN-OFFR        TO S-RS1-TEMPLATE-REN-OFFR. 
PRJ473     MOVE WS-TEMPLATE-EXT-DESC        TO S-RS1-TEMPLATE-EXT-DESC. 
PRJ680     MOVE FG-MAX-PRICE-OFFER-CD       TO S-RS1-MAX-PRICE-OFFER-CD.
P00863     MOVE FG-RTCHG-PUB-OFFER-CD       TO S-RS1-RTCHG-PUB-OFFER-CD.
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2430-MOVE-PROMO-RS5   CRM-MKT-PROMOTION                        *        
      ******************************************************************        
       2430-MOVE-PROMO-RS5.                                             
                                                                        
           MOVE 'KM'                        TO S-RS5-TABLE-ID           
           MOVE KM-COMPANY-NO               TO S-RS5-COMPANY-NO         
           MOVE KM-PROMO-CD                 TO S-RS5-PROMO-CD           
           MOVE KM-PROMO-DESC               TO S-RS5-PROMO-DESC         
           MOVE KM-OFFER-CD                 TO S-RS5-OFFER-CD           
           MOVE KM-MKT-PLAN-CD              TO S-RS5-MKT-PLAN-CD        
           MOVE KM-PROMO-START-DT           TO S-RS5-PROMO-START-DT     
           MOVE KM-PROMO-START-TM           TO S-RS5-PROMO-START-TM     
           MOVE KM-PROMO-END-DT             TO S-RS5-PROMO-END-DT       
           MOVE KM-PROMO-END-TM             TO S-RS5-PROMO-END-TM       
           MOVE KM-AD-CHANNEL-CD            TO S-RS5-AD-CHANNEL-CD      
           MOVE KM-PROMO-DESC-LONG          TO S-RS5-PROMO-DESC-LONG    
           MOVE KM-EXT-LANDING-PG-URL       TO S-RS5-EXT-LANDING-PG-URL 
           MOVE KM-PROMO-TYPE-CD            TO S-RS5-PROMO-TYPE-CD      
           MOVE KM-WEB-IMAGE-FILE-NM        TO S-RS5-WEB-IMAGE-FILE-NM  
           MOVE KM-LAST-UPDATE-USERID       TO S-RS5-LAST-UPDATE-USERID 
           MOVE KM-LAST-UPDATE-TS           TO S-RS5-LAST-UPDATE-TS     
           MOVE KM-REPLACMNT-PROMO-CD       TO S-RS5-REPLACMNT-PROMO-CD 
           MOVE KM-DISPLAY-END-DT           TO S-RS5-DISPLAY-END-DT     
           MOVE KM-INT-LANDING-PG-URL       TO S-RS5-INT-LANDING-PG-URL 
           MOVE KM-PROMO-VRSN-NO            TO S-RS5-PROMO-VRSN-NO      
           MOVE KM-PROMO-VSTART-TS          TO S-RS5-PROMO-VSTART-TS    
           MOVE KM-PROMO-VEND-TS            TO S-RS5-PROMO-VEND-TS      
           MOVE KM-PROC-STATUS-CD           TO S-RS5-PROC-STATUS-CD     
           MOVE KM-PROC-REQ-ID              TO S-RS5-PROC-REQ-ID        
           MOVE WS-PROMO-REUSED-FLAG        TO S-RS5-PROMO-REUSED-FLAG  
PRJ473     MOVE WS-ORIG-PROMO-OFFER         TO S-RS5-ORIG-PROMO-OFFER.  
                                                                        
           PERFORM 8050-INSERT-GTT-R5          THRU 8050-EXIT.          
                                                                        
       2430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2440-MOVE-SECURE-OFF-OPT-RS4.   CRM_ACCESS_OFF_OPT             *        
      ******************************************************************        
       2440-MOVE-SECURE-OFF-OPT-RS4.                                    
                                                                        
           MOVE 'CI'                        TO S-RS4-TABLE-ID           
           MOVE CI-COMPANY-NO               TO S-RS4-COMPANY-NO         
           MOVE CI-OPTION-CD                TO S-RS4-OPTION-CD          
           MOVE CI-OFFER-CD                 TO S-RS4-OFFER-CD           
           MOVE CI-CATEGORY-ID              TO S-RS4-CATEGORY-ID        
           MOVE CI-ACCESS-START-DT          TO S-RS4-ACCESS-START-DT    
           MOVE CI-ACCESS-END-DT            TO S-RS4-ACCESS-END-DT      
           MOVE CI-VIEW-APPLY-CD            TO S-RS4-VIEW-APPLY-CD      
           MOVE CI-LAST-UPDATE-USERID       TO S-RS4-LAST-UPDATE-USERID 
           MOVE CI-LAST-UPDATE-TS           TO S-RS4-LAST-UPDATE-TS     
           MOVE CI-COMMENTS-TX              TO S-RS4-COMMENTS-TX        
           MOVE CI-ACCESS-VRSN-NO           TO S-RS4-ACCESS-VRSN-NO     
           MOVE CI-ACCESS-VSTART-TS         TO S-RS4-ACCESS-VSTART-TS   
           MOVE CI-ACCESS-VEND-TS           TO S-RS4-ACCESS-VEND-TS     
           MOVE CI-PROC-STATUS-CD           TO S-RS4-PROC-STATUS-CD     
           MOVE CI-PROC-REQ-ID              TO S-RS4-PROC-REQ-ID        
                                                                        
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT           
           PERFORM 7150-FETCH-SECURED-OFF-OPT  THRU 7150-EXIT.          
                                                                        
       2440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2450-MOVE-MKT-TIER-RS6         CRM_OFF_MKT_TIER                *        
      ******************************************************************        
       2450-MOVE-MKT-TIER-RS6.                                          
                                                                        
           MOVE 'DU'                        TO S-RS6-TABLE-ID           
           MOVE DU-COMPANY-NO               TO S-RS6-COMPANY-NO         
           MOVE DU-OFFER-CD                 TO S-RS6-OFFER-CD           
           MOVE DU-TIER-CUST-STAT-CD        TO S-RS6-TIER-CUST-STAT-CD  
           MOVE DU-TIER-ACCT-TYPE-CD        TO S-RS6-TIER-ACCT-TYPE-CD  
           MOVE DU-MKT-TIER-RANKING         TO S-RS6-MKT-TIER-RANKING   
           MOVE DU-MKT-TIER-START-DT        TO S-RS6-MKT-TIER-START-DT  
           MOVE DU-OFFER-TIER-STRT-DT       TO S-RS6-OFFER-TIER-STRT-DT 
           MOVE DU-MKT-TIER-APPLY-CD        TO S-RS6-MKT-TIER-APPLY-CD  
           MOVE DU-TIER-DEFLT-OFFR-CD       TO S-RS6-TIER-DEFLT-OFFR-CD 
           MOVE DU-OFFER-TIER-END-DT        TO S-RS6-OFFER-TIER-END-DT  
           MOVE DU-LAST-UPDATE-USERID       TO S-RS6-LAST-UPDATE-USERID 
           MOVE DU-LAST-UPDATE-TS           TO S-RS6-LAST-UPDATE-TS     
           MOVE DU-OFF-TIER-VRSN-NO         TO S-RS6-OFF-TIER-VRSN-NO   
           MOVE DU-OFF-TIER-VSTART-TS       TO S-RS6-OFF-TIER-VSTART-TS 
           MOVE DU-OFF-TIER-VEND-TS         TO S-RS6-OFF-TIER-VEND-TS   
           MOVE DU-PROC-STATUS-CD           TO S-RS6-PROC-STATUS-CD     
           MOVE DU-PROC-REQ-ID              TO S-RS6-PROC-REQ-ID        
                                                                        
           PERFORM 8060-INSERT-GTT-R6          THRU 8060-EXIT           
           PERFORM 7210-FETCH-OFF-MKT-TIER     THRU 7210-EXIT.          
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2460-MOVE-RATE-GRP-OFF-RS7     CRM_RATE_GRP_OFFER              *        
      ******************************************************************        
       2460-MOVE-RATE-GRP-OFF-RS7.                                      
                                                                        
           MOVE 'G5'                        TO S-RS7-TABLE-ID           
           MOVE G5-COMPANY-NO               TO S-RS7-COMPANY-NO         
           MOVE G5-RATE-GROUP-TYPE-CD       TO S-RS7-RATE-GROUP-TYPE-CD 
           MOVE G5-RATE-GROUP-CD            TO S-RS7-RATE-GROUP-CD      
           MOVE G5-SORT-SEQ-NO              TO S-RS7-SORT-SEQ-NO        
           MOVE G5-EFF-START-DT             TO S-RS7-EFF-START-DT       
           MOVE G5-EFF-END-DT               TO S-RS7-EFF-END-DT         
           MOVE G5-OFFER-CD                 TO S-RS7-OFFER-CD           
           MOVE G5-OPTION-CD                TO S-RS7-OPTION-CD          
           MOVE G5-LAST-UPDATE-USERID       TO S-RS7-LAST-UPDATE-USERID 
           MOVE G5-LAST-UPDATE-TS           TO S-RS7-LAST-UPDATE-TS     
           MOVE G5-GRP-OFF-VRSN-NO          TO S-RS7-GRP-OFF-VRSN-NO    
           MOVE G5-GRP-OFF-VSTART-TS        TO S-RS7-GRP-OFF-VSTART-TS  
           MOVE G5-GRP-OFF-VEND-TS          TO S-RS7-GRP-OFF-VEND-TS    
           MOVE G5-PROC-STATUS-CD           TO S-RS7-PROC-STATUS-CD     
           MOVE G5-PROC-REQ-ID              TO S-RS7-PROC-REQ-ID        
                                                                        
           PERFORM 8070-INSERT-GTT-R7          THRU 8070-EXIT           
           PERFORM 7300-FETCH-RATE-GRP-OFFER   THRU 7300-EXIT.          
                                                                        
       2460-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2470-MOVE-OFFER-OPTION-RS8     CRM_OFFER_OPTION                *        
      ******************************************************************        
       2470-MOVE-OFFER-OPTION-RS8.                                      
                                                                        
           MOVE 'E9'                        TO S-RS8-TABLE-ID.          
           MOVE E9-COMPANY-NO               TO S-RS8-COMPANY-NO.        
           MOVE E9-OFFER-CD                 TO S-RS8-OFFER-CD.          
           MOVE E9-OPTION-CD                TO S-RS8-OPTION-CD.         
           MOVE E9-OPTION-SORT-SEQ-NO       TO S-RS8-OPTION-SORT-SEQ-NO.
           MOVE E9-LAST-UPDATE-USERID       TO S-RS8-LAST-UPDATE-USERID.
           MOVE E9-LAST-UPDATE-TS           TO S-RS8-LAST-UPDATE-TS.    
           MOVE E9-OFFER-OPT-START-DT       TO S-RS8-OFFER-OPT-START-DT.
           MOVE E9-OFFER-OPT-END-DT         TO S-RS8-OFFER-OPT-END-DT.  
           MOVE E9-OFF-OPT-VRSN-NO          TO S-RS8-OFF-OPT-VRSN-NO.   
           MOVE E9-OFF-OPT-VSTART-TS        TO S-RS8-OFF-OPT-VSTART-TS. 
           MOVE E9-OFF-OPT-VEND-TS          TO S-RS8-OFF-OPT-VEND-TS.   
           MOVE E9-PROC-STATUS-CD           TO S-RS8-PROC-STATUS-CD.    
           MOVE E9-PROC-REQ-ID              TO S-RS8-PROC-REQ-ID.       
A04805     MOVE E9-WEB-NEW-EXISTS-CD        TO S-RS8-WEB-NEW-EXISTS-CD. 
A04805     MOVE E9-WEB-SIGN-UP-FL           TO S-RS8-WEB-SIGN-UP-FL.    
A04805     MOVE E9-OFF-OPT-EXCLUDE-CD       TO S-RS8-OFF-OPT-EXCLUDE-CD.
                                                                        
           PERFORM 8080-INSERT-GTT-R8          THRU 8080-EXIT.          
                                                                        
       2470-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * DRIVER QUERY - TO GET OFFER DETAILS BASED ON OFFER CODE        *        
      * 7000-GET-OFFER-DET-DRIVE.                                      *        
      ******************************************************************        
       7000-GET-OFFER-DET-DRIVE.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FG.COMPANY_NO,
              FG.OFFER_CD,
              FG.OFFER_DESC_INT,
              FG.OFFER_DESC_EXT,
              FG.PROMO_CD_INT_FL,
              FG.PROMO_CD_EXT_FL,
              FG.OFFER_START_DT,
              FG.OFFER_END_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_START_INT_TS
           , 121), ' ', '-'), ':', '.') DISP_START_INT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_END_INT_TS
           , 121), ' ', '-'), ':', '.') DISP_END_INT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_START_EXT_TS
           , 121), ' ', '-'), ':', '.') DISP_START_EXT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_END_EXT_TS
           , 121), ' ', '-'), ':', '.') DISP_END_EXT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              FG.LAST_UPDATE_USERID,
              FG.OFFER_DESC_INT_LNG,
              FG.OFFER_DESC_EXT_LNG,
              FG.SPCL_OFFER_TYPE_CD,
              FG.RENEWAL_OFFER_CD,
              FG.RENEW_PUB_OFFER_CD,
              FG.OFF_VRSN_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VSTART_TS, 121), 
           ' ', '-'), ':', '.') OFF_VSTART_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS, 121), 
           ' ', '-'), ':', '.') OFF_VEND_TS,
              FG.PROC_STATUS_CD,
              FG.PROC_REQ_ID,
              FG.MAX_PRICE_OFFER_CD,
              FG.RTCHG_PUB_OFFER_CD                             
                 INTO :FG-COMPANY-NO                                    
                     ,:FG-OFFER-CD                                      
                     ,:FG-OFFER-DESC-INT                                
                     ,:FG-OFFER-DESC-EXT                                
                     ,:FG-PROMO-CD-INT-FL                               
                     ,:FG-PROMO-CD-EXT-FL                               
                     ,:FG-OFFER-START-DT                                
                     ,:FG-OFFER-END-DT                                  
                     ,:FG-DISP-START-INT-TS                             
                     ,:FG-DISP-END-INT-TS                               
                     ,:FG-DISP-START-EXT-TS                             
                     ,:FG-DISP-END-EXT-TS                               
                     ,:FG-LAST-UPDATE-TS                                
                     ,:FG-LAST-UPDATE-USERID                            
                     ,:FG-OFFER-DESC-INT-LNG                            
                     ,:FG-OFFER-DESC-EXT-LNG                            
                     ,:FG-SPCL-OFFER-TYPE-CD                            
                     ,:FG-RENEWAL-OFFER-CD                              
                     ,:FG-RENEW-PUB-OFFER-CD                            
                     ,:FG-OFF-VRSN-NO                                   
                     ,:FG-OFF-VSTART-TS                                 
                     ,:FG-OFF-VEND-TS                                   
                     ,:FG-PROC-STATUS-CD                                
                     ,:FG-PROC-REQ-ID                                   
PRJ680               ,:FG-MAX-PRICE-OFFER-CD                            
P00863               ,:FG-RTCHG-PUB-OFFER-CD                            
                 FROM CRM_RT_PKG_OFFER  FG WITH(READUNCOMMITTED)                
                WHERE FG.COMPANY_NO     = :FG-COMPANY-NO                
                  AND ((FG.OFF_VRSN_NO  = :FG-OFF-VRSN-NO               
                        AND FG.OFFER_CD = :FG-OFFER-CD                  
                        AND :WS-PROCESS-REQ-ID = 0 )                    
                         OR                                             
                       (FG.PROC_REQ_ID  = :FG-PROC-REQ-ID               
                        AND :WS-PROCESS-REQ-ID > 0 ))                   
              ORDER BY FG.OFFER_START_DT DESC                           
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FG.COMPANY_NO                                             
MFA-TR*              ,FG.OFFER_CD                                               
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*              ,FG.OFFER_DESC_EXT                                         
MFA-TR*              ,FG.PROMO_CD_INT_FL                                        
MFA-TR*              ,FG.PROMO_CD_EXT_FL                                        
MFA-TR*              ,FG.OFFER_START_DT                                         
MFA-TR*              ,FG.OFFER_END_DT                                           
MFA-TR*              ,FG.DISP_START_INT_TS                                      
MFA-TR*              ,FG.DISP_END_INT_TS                                        
MFA-TR*              ,FG.DISP_START_EXT_TS                                      
MFA-TR*              ,FG.DISP_END_EXT_TS                                        
MFA-TR*              ,FG.LAST_UPDATE_TS                                         
MFA-TR*              ,FG.LAST_UPDATE_USERID                                     
MFA-TR*              ,FG.OFFER_DESC_INT_LNG                                     
MFA-TR*              ,FG.OFFER_DESC_EXT_LNG                                     
MFA-TR*              ,FG.SPCL_OFFER_TYPE_CD                                     
MFA-TR*              ,FG.RENEWAL_OFFER_CD                                       
MFA-TR*              ,FG.RENEW_PUB_OFFER_CD                                     
MFA-TR*              ,FG.OFF_VRSN_NO                                            
MFA-TR*              ,FG.OFF_VSTART_TS                                          
MFA-TR*              ,FG.OFF_VEND_TS                                            
MFA-TR*              ,FG.PROC_STATUS_CD                                         
MFA-TR*              ,FG.PROC_REQ_ID                                            
MFA-TR*              ,FG.MAX_PRICE_OFFER_CD                                     
MFA-TR*              ,FG.RTCHG_PUB_OFFER_CD                                     
MFA-TR*          INTO :FG-COMPANY-NO                                            
MFA-TR*              ,:FG-OFFER-CD                                              
MFA-TR*              ,:FG-OFFER-DESC-INT                                        
MFA-TR*              ,:FG-OFFER-DESC-EXT                                        
MFA-TR*              ,:FG-PROMO-CD-INT-FL                                       
MFA-TR*              ,:FG-PROMO-CD-EXT-FL                                       
MFA-TR*              ,:FG-OFFER-START-DT                                        
MFA-TR*              ,:FG-OFFER-END-DT                                          
MFA-TR*              ,:FG-DISP-START-INT-TS                                     
MFA-TR*              ,:FG-DISP-END-INT-TS                                       
MFA-TR*              ,:FG-DISP-START-EXT-TS                                     
MFA-TR*              ,:FG-DISP-END-EXT-TS                                       
MFA-TR*              ,:FG-LAST-UPDATE-TS                                        
MFA-TR*              ,:FG-LAST-UPDATE-USERID                                    
MFA-TR*              ,:FG-OFFER-DESC-INT-LNG                                    
MFA-TR*              ,:FG-OFFER-DESC-EXT-LNG                                    
MFA-TR*              ,:FG-SPCL-OFFER-TYPE-CD                                    
MFA-TR*              ,:FG-RENEWAL-OFFER-CD                                      
MFA-TR*              ,:FG-RENEW-PUB-OFFER-CD                                    
MFA-TR*              ,:FG-OFF-VRSN-NO                                           
MFA-TR*              ,:FG-OFF-VSTART-TS                                         
MFA-TR*              ,:FG-OFF-VEND-TS                                           
MFA-TR*              ,:FG-PROC-STATUS-CD                                        
MFA-TR*              ,:FG-PROC-REQ-ID                                           
MFA-TR*              ,:FG-MAX-PRICE-OFFER-CD                                    
MFA-TR*              ,:FG-RTCHG-PUB-OFFER-CD                                    
MFA-TR*          FROM CRM_RT_PKG_OFFER  FG                                      
MFA-TR*         WHERE FG.COMPANY_NO     = :FG-COMPANY-NO                        
MFA-TR*           AND ((FG.OFF_VRSN_NO  = :FG-OFF-VRSN-NO                       
MFA-TR*                 AND FG.OFFER_CD = :FG-OFFER-CD                          
MFA-TR*                 AND :WS-PROCESS-REQ-ID = 0 )                            
MFA-TR*                  OR                                                     
MFA-TR*                (FG.PROC_REQ_ID  = :FG-PROC-REQ-ID                       
MFA-TR*                 AND :WS-PROCESS-REQ-ID > 0 ))                           
MFA-TR*       ORDER BY FG.OFFER_START_DT DESC                                   
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OFFER'    TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE FG-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  7001-OPEN-OFFER-DET-CUR.                                      *        
      ******************************************************************        
       7001-OPEN-OFFER-DET-CUR.                                         
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_DET_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7001'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OFFER'    TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE FG-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET ALL THE OFFER  DETAILS BASED ON OPTION CODE                *        
      * 7002-FETCH-OFFER-DET-CUR.                                      *        
      ******************************************************************        
       7002-FETCH-OFFER-DET-CUR.                                        
                                                                        
           EXEC SQL                                                     
               FETCH OFFER_DET_CUR                                      
                INTO :FG-COMPANY-NO                                     
                    ,:FG-OFFER-CD                                       
                    ,:FG-OFFER-DESC-INT                                 
                    ,:FG-OFFER-DESC-EXT                                 
                    ,:FG-PROMO-CD-INT-FL                                
                    ,:FG-PROMO-CD-EXT-FL                                
                    ,:FG-OFFER-START-DT                                 
                    ,:FG-OFFER-END-DT                                   
                    ,:FG-DISP-START-INT-TS                              
                    ,:FG-DISP-END-INT-TS                                
                    ,:FG-DISP-START-EXT-TS                              
                    ,:FG-DISP-END-EXT-TS                                
                    ,:FG-LAST-UPDATE-TS                                 
                    ,:FG-LAST-UPDATE-USERID                             
                    ,:FG-OFFER-DESC-INT-LNG                             
                    ,:FG-OFFER-DESC-EXT-LNG                             
                    ,:FG-SPCL-OFFER-TYPE-CD                             
                    ,:FG-RENEWAL-OFFER-CD                               
                    ,:FG-RENEW-PUB-OFFER-CD                             
                    ,:FG-OFF-VRSN-NO                                    
                    ,:FG-OFF-VSTART-TS                                  
                    ,:FG-OFF-VEND-TS                                    
                    ,:FG-PROC-STATUS-CD                                 
                    ,:FG-PROC-REQ-ID                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-OFFER-ROWS    
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7002'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_RT_PKG_OFFER'   TO TABLE-1                
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE FG-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7103-CLOSE-OFFER-DET-CUR.                                      *        
      ******************************************************************        
       7003-CLOSE-OFFER-DET-CUR.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_DET_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7003'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RT_PKG_OFFER'       TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE FG-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7003-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * GET PROCESS TYPE CODE FOR THE INPUT OFFER'S PROCESS REQ ID.   *         
      *****************************************************************         
       7004-GET-PROC-TYPE-CD.                                           
                                                                        
           EXEC SQL                                                     
               SELECT T1P.PROC_TYPE_CD                                  
                 INTO :1P-PROC-TYPE-CD                                  
                 FROM CSS_PROCESS_REQ T1P WITH(READUNCOMMITTED)                 
                WHERE T1P.PROC_REQ_ID   = :1P-PROC-REQ-ID               
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT T1P.PROC_TYPE_CD                                          
MFA-TR*          INTO :1P-PROC-TYPE-CD                                          
MFA-TR*          FROM CSS_PROCESS_REQ T1P                                       
MFA-TR*         WHERE T1P.PROC_REQ_ID   = :1P-PROC-REQ-ID                       
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7004                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7004'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_PROCESS_REQ'     TO TABLE-1                     
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-1             
              MOVE 1P-PROC-REQ-ID        TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7004-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CHECK TEMPLATE OFFER IS EXIST FOR THE INPUT OFFER'S PROC REQ ID         
      * IN RATE PACKAGE OFFER TABLE.                                            
      ******************************************************************        
       7005-CHK-TMPLT-OFF-IS-EXIST.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              FG.OFFER_CD,
              FG.OFFER_DESC_INT,
              FG.RENEWAL_OFFER_CD,
              FG.OFFER_DESC_EXT                                 
                 INTO :WS-TEMPLATE-OFFER-EXIST                          
                     ,:WS-TEMPLATE-OFFER                                
PRJ473               ,:WS-TEMPLATE-INT-DESC                             
PRJ473               ,:WS-TEMPLATE-REN-OFFR                             
PRJ473               ,:WS-TEMPLATE-EXT-DESC                             
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                WHERE FG.PROC_REQ_ID   = :FG-PROC-REQ-ID                
                  AND FG.OFFER_CD     <> :FG-OFFER-CD                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,FG.OFFER_CD                                               
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*              ,FG.RENEWAL_OFFER_CD                                       
MFA-TR*              ,FG.OFFER_DESC_EXT                                         
MFA-TR*          INTO :WS-TEMPLATE-OFFER-EXIST                                  
MFA-TR*              ,:WS-TEMPLATE-OFFER                                        
MFA-TR*              ,:WS-TEMPLATE-INT-DESC                                     
MFA-TR*              ,:WS-TEMPLATE-REN-OFFR                                     
MFA-TR*              ,:WS-TEMPLATE-EXT-DESC                                     
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.PROC_REQ_ID   = :FG-PROC-REQ-ID                        
MFA-TR*           AND FG.OFFER_CD     <> :FG-OFFER-CD                           
MFA-TR*        FETCH FIRST ROW ONLY WITH UR                                     
MFA-TR*          QUERYNO 7005                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7005'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OFFER'    TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE FG-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE FG-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CHECK TEMPLATE OFFER IS EXIST FOR THE INPUT OFFER'S PROC REQ ID         
      * IN OFFER MARKET TIER TABLE.                                             
      ******************************************************************        
       7006-CHK-TMPLT-OFF-TIER-EXIST.                                   
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              DU.OFFER_CD                                       
                 INTO :WS-TMPLT-OFF-TIER-EXIST                          
                     ,:WS-TEMPLATE-OFFER                                
                 FROM CRM_OFF_MKT_TIER DU WITH(READUNCOMMITTED)                 
                WHERE DU.PROC_REQ_ID   = :DU-PROC-REQ-ID                
                  AND DU.OFFER_CD     <> :DU-OFFER-CD                   
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,DU.OFFER_CD                                               
MFA-TR*          INTO :WS-TMPLT-OFF-TIER-EXIST                                  
MFA-TR*              ,:WS-TEMPLATE-OFFER                                        
MFA-TR*          FROM CRM_OFF_MKT_TIER DU                                       
MFA-TR*         WHERE DU.PROC_REQ_ID   = :DU-PROC-REQ-ID                        
MFA-TR*           AND DU.OFFER_CD     <> :DU-OFFER-CD                           
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7006                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7006'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE DU-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE DU-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7006-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7007-GET-OFF-FRM-OFF-MKK-TR.                                   *        
      ******************************************************************        
       7007-GET-OFF-FRM-OFF-MKT-TR.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) DU.OFFER_CD                                       
                 INTO :DU-OFFER-CD                                      
                 FROM CRM_OFF_MKT_TIER   DU WITH(READUNCOMMITTED)               
                WHERE DU.COMPANY_NO       = :DU-COMPANY-NO              
                  AND DU.PROC_REQ_ID      = :DU-PROC-REQ-ID             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DU.OFFER_CD                                               
MFA-TR*          INTO :DU-OFFER-CD                                              
MFA-TR*          FROM CRM_OFF_MKT_TIER   DU                                     
MFA-TR*         WHERE DU.COMPANY_NO       = :DU-COMPANY-NO                      
MFA-TR*           AND DU.PROC_REQ_ID      = :DU-PROC-REQ-ID                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7007                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7007'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OFF_MKT_TIER'    TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE DU-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE DU-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7007-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7008-GET-OFF-FRM-OFF-RT-GRP.                                   *        
      ******************************************************************        
       7008-GET-OFF-FRM-OFF-RT-GRP.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) G5.OFFER_CD                                       
                 INTO :G5-OFFER-CD                                      
                 FROM CRM_RATE_GRP_OFFER G5 WITH(READUNCOMMITTED)               
                WHERE G5.COMPANY_NO       = :G5-COMPANY-NO              
                  AND G5.PROC_REQ_ID      = :G5-PROC-REQ-ID             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT G5.OFFER_CD                                               
MFA-TR*          INTO :G5-OFFER-CD                                              
MFA-TR*          FROM CRM_RATE_GRP_OFFER G5                                     
MFA-TR*         WHERE G5.COMPANY_NO       = :G5-COMPANY-NO                      
MFA-TR*           AND G5.PROC_REQ_ID      = :G5-PROC-REQ-ID                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7008                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7008'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RATE_GRP_OFFER'  TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE G5-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE G5-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7008-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7009-GET-OFF-FRM-OFF-ACCESS.                                   *        
      ******************************************************************        
       7009-GET-OFF-FRM-OFF-ACCESS.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CI.OFFER_CD                                       
                 INTO :CI-OFFER-CD                                      
                 FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)               
                WHERE CI.COMPANY_NO       = :CI-COMPANY-NO              
                  AND CI.PROC_REQ_ID      = :CI-PROC-REQ-ID             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CI.OFFER_CD                                               
MFA-TR*          INTO :CI-OFFER-CD                                              
MFA-TR*          FROM CRM_ACCESS_OFF_OPT CI                                     
MFA-TR*         WHERE CI.COMPANY_NO       = :CI-COMPANY-NO                      
MFA-TR*           AND CI.PROC_REQ_ID      = :CI-PROC-REQ-ID                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7009                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7009'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_ACCESS_OFF_OPT'  TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE CI-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE CI-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7009-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7010-GET-OFF-FRM-OFF-PROMO.                                    *        
      ******************************************************************        
       7010-GET-OFF-FRM-OFF-PROMO.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) KM.OFFER_CD                                       
                 INTO :KM-OFFER-CD                                      
                 FROM CRM_MKT_PROMOTION  KM WITH(READUNCOMMITTED)               
                WHERE KM.COMPANY_NO       = :KM-COMPANY-NO              
                  AND KM.PROC_REQ_ID      = :KM-PROC-REQ-ID             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KM.OFFER_CD                                               
MFA-TR*          INTO :KM-OFFER-CD                                              
MFA-TR*          FROM CRM_MKT_PROMOTION  KM                                     
MFA-TR*         WHERE KM.COMPANY_NO       = :KM-COMPANY-NO                      
MFA-TR*           AND KM.PROC_REQ_ID      = :KM-PROC-REQ-ID                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7010                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7010'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE KM-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE KM-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7011-GET-OFF-FRM-OFF-OPT.                                      *        
      ******************************************************************        
       7011-GET-OFF-FRM-OFF-OPT.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) E9.OFFER_CD                                       
                 INTO :E9-OFFER-CD                                      
                 FROM CRM_OFFER_OPTION E9 WITH(READUNCOMMITTED)                 
                WHERE E9.COMPANY_NO       = :E9-COMPANY-NO              
                  AND E9.PROC_REQ_ID      = :E9-PROC-REQ-ID             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT E9.OFFER_CD                                               
MFA-TR*          INTO :E9-OFFER-CD                                              
MFA-TR*          FROM CRM_OFFER_OPTION E9                                       
MFA-TR*         WHERE E9.COMPANY_NO       = :E9-COMPANY-NO                      
MFA-TR*           AND E9.PROC_REQ_ID      = :E9-PROC-REQ-ID                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7011                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7011'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OFFER_OPTION'    TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE E9-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE E9-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7011-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7012-GET-OPT-FRM-ATTR-INCTV.                                   *        
      ******************************************************************        
       7012-GET-OPT-FRM-ATTR-INCTV.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) HQ.OPTION_CD                                      
                 INTO :HQ-OPTION-CD                                     
                 FROM CRM_OPT_ATTR_INCTV HQ WITH(READUNCOMMITTED)               
                WHERE HQ.COMPANY_NO       = :HQ-COMPANY-NO              
                  AND HQ.PROC_REQ_ID      = :HQ-PROC-REQ-ID             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HQ.OPTION_CD                                              
MFA-TR*          INTO :HQ-OPTION-CD                                             
MFA-TR*          FROM CRM_OPT_ATTR_INCTV HQ                                     
MFA-TR*         WHERE HQ.COMPANY_NO       = :HQ-COMPANY-NO                      
MFA-TR*           AND HQ.PROC_REQ_ID      = :HQ-PROC-REQ-ID                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7012                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7012'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OPT_ATTR_INCTV'  TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE HQ-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              MOVE HQ-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7012-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7013-GET-OPT-FRM-OFF-ACCESS.                                   *        
      ******************************************************************        
       7013-GET-OPT-FRM-OFF-ACCESS.                                     
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) CI.OPTION_CD                                      
                 INTO :CI-OPTION-CD                                     
                 FROM CRM_ACCESS_OFF_OPT CI WITH(READUNCOMMITTED)               
                WHERE CI.COMPANY_NO       = :CI-COMPANY-NO              
                  AND CI.PROC_REQ_ID      = :CI-PROC-REQ-ID             
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CI.OPTION_CD                                              
MFA-TR*          INTO :CI-OPTION-CD                                             
MFA-TR*          FROM CRM_ACCESS_OFF_OPT CI                                     
MFA-TR*         WHERE CI.COMPANY_NO       = :CI-COMPANY-NO                      
MFA-TR*           AND CI.PROC_REQ_ID      = :CI-PROC-REQ-ID                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7013                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7013'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_ACCESS_OFF_OPT'  TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE 'PROC_REQ_ID'         TO TABLE-ELEMENT-2             
              MOVE CI-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              MOVE CI-PROC-REQ-ID        TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7013-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * CHECK WHETHER PROMOTION CODE IS RE-USED FOR OTHER OFFERS.      *        
      ******************************************************************        
       7014-GET-PROMO-REUSED-FLAG.                                      
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) KM.OFFER_CD,
              KM.PROC_STATUS_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.TIMESTAMP2(
           KM.PROMO_START_DT,KM.PROMO_START_TM), 121), ' ', '-'), ':', 
           '.')    
                 INTO :WS-PROMO-OFFER-CD                                
                     ,:WS-PROMO-PROC-STATUS-CD                          
                     ,:WS-PROMO-START-DT-TM                             
                 FROM CRM_MKT_PROMOTION KM WITH(READUNCOMMITTED)                
                WHERE KM.COMPANY_NO      = :KM-COMPANY-NO               
                  AND KM.PROMO_CD        = :KM-PROMO-CD                 
                ORDER BY KM.PROMO_VRSN_NO DESC                          
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KM.OFFER_CD                                               
MFA-TR*              ,KM.PROC_STATUS_CD                                         
MFA-TR*              ,TIMESTAMP(KM.PROMO_START_DT,KM.PROMO_START_TM)            
MFA-TR*          INTO :WS-PROMO-OFFER-CD                                        
MFA-TR*              ,:WS-PROMO-PROC-STATUS-CD                                  
MFA-TR*              ,:WS-PROMO-START-DT-TM                                     
MFA-TR*          FROM CRM_MKT_PROMOTION KM                                      
MFA-TR*         WHERE KM.COMPANY_NO      = :KM-COMPANY-NO                       
MFA-TR*           AND KM.PROMO_CD        = :KM-PROMO-CD                         
MFA-TR*         ORDER BY KM.PROMO_VRSN_NO DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7014                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7014'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
              MOVE 'PROMO_CD'            TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE KM-PROMO-CD           TO HOSTVAR-ELEMENT-1           
              MOVE KM-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7014-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7050-GET-OFF-MAX-VRSN-NO.                                      *        
      ******************************************************************        
       7050-GET-OFF-MAX-VRSN-NO.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FG.COMPANY_NO,
              FG.OFFER_CD,
              FG.OFFER_DESC_INT,
              FG.OFFER_DESC_EXT,
              FG.PROMO_CD_INT_FL,
              FG.PROMO_CD_EXT_FL,
              FG.OFFER_START_DT,
              FG.OFFER_END_DT,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_START_INT_TS
           , 121), ' ', '-'), ':', '.') DISP_START_INT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_END_INT_TS
           , 121), ' ', '-'), ':', '.') DISP_END_INT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_START_EXT_TS
           , 121), ' ', '-'), ':', '.') DISP_START_EXT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.DISP_END_EXT_TS
           , 121), ' ', '-'), ':', '.') DISP_END_EXT_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              FG.LAST_UPDATE_USERID,
              FG.OFFER_DESC_INT_LNG,
              FG.OFFER_DESC_EXT_LNG,
              FG.SPCL_OFFER_TYPE_CD,
              FG.RENEWAL_OFFER_CD,
              FG.RENEW_PUB_OFFER_CD,
              FG.OFF_VRSN_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VSTART_TS, 121), 
           ' ', '-'), ':', '.') OFF_VSTART_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FG.OFF_VEND_TS, 121), 
           ' ', '-'), ':', '.') OFF_VEND_TS,
              FG.PROC_STATUS_CD,
              FG.PROC_REQ_ID,
              FG.MAX_PRICE_OFFER_CD,
              FG.RTCHG_PUB_OFFER_CD                             
                 INTO :FG-COMPANY-NO                                    
                     ,:FG-OFFER-CD                                      
                     ,:FG-OFFER-DESC-INT                                
                     ,:FG-OFFER-DESC-EXT                                
                     ,:FG-PROMO-CD-INT-FL                               
                     ,:FG-PROMO-CD-EXT-FL                               
                     ,:FG-OFFER-START-DT                                
                     ,:FG-OFFER-END-DT                                  
                     ,:FG-DISP-START-INT-TS                             
                     ,:FG-DISP-END-INT-TS                               
                     ,:FG-DISP-START-EXT-TS                             
                     ,:FG-DISP-END-EXT-TS                               
                     ,:FG-LAST-UPDATE-TS                                
                     ,:FG-LAST-UPDATE-USERID                            
                     ,:FG-OFFER-DESC-INT-LNG                            
                     ,:FG-OFFER-DESC-EXT-LNG                            
                     ,:FG-SPCL-OFFER-TYPE-CD                            
                     ,:FG-RENEWAL-OFFER-CD                              
                     ,:FG-RENEW-PUB-OFFER-CD                            
                     ,:FG-OFF-VRSN-NO                                   
                     ,:FG-OFF-VSTART-TS                                 
                     ,:FG-OFF-VEND-TS                                   
                     ,:FG-PROC-STATUS-CD                                
                     ,:FG-PROC-REQ-ID                                   
PRJ680               ,:FG-MAX-PRICE-OFFER-CD                            
P00863               ,:FG-RTCHG-PUB-OFFER-CD                            
                 FROM CRM_RT_PKG_OFFER FG WITH(READUNCOMMITTED)                 
                WHERE FG.COMPANY_NO       = :FG-COMPANY-NO              
                  AND FG.OFFER_CD         = :FG-OFFER-CD                
                ORDER BY FG.OFF_VRSN_NO DESC                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FG.COMPANY_NO                                             
MFA-TR*              ,FG.OFFER_CD                                               
MFA-TR*              ,FG.OFFER_DESC_INT                                         
MFA-TR*              ,FG.OFFER_DESC_EXT                                         
MFA-TR*              ,FG.PROMO_CD_INT_FL                                        
MFA-TR*              ,FG.PROMO_CD_EXT_FL                                        
MFA-TR*              ,FG.OFFER_START_DT                                         
MFA-TR*              ,FG.OFFER_END_DT                                           
MFA-TR*              ,FG.DISP_START_INT_TS                                      
MFA-TR*              ,FG.DISP_END_INT_TS                                        
MFA-TR*              ,FG.DISP_START_EXT_TS                                      
MFA-TR*              ,FG.DISP_END_EXT_TS                                        
MFA-TR*              ,FG.LAST_UPDATE_TS                                         
MFA-TR*              ,FG.LAST_UPDATE_USERID                                     
MFA-TR*              ,FG.OFFER_DESC_INT_LNG                                     
MFA-TR*              ,FG.OFFER_DESC_EXT_LNG                                     
MFA-TR*              ,FG.SPCL_OFFER_TYPE_CD                                     
MFA-TR*              ,FG.RENEWAL_OFFER_CD                                       
MFA-TR*              ,FG.RENEW_PUB_OFFER_CD                                     
MFA-TR*              ,FG.OFF_VRSN_NO                                            
MFA-TR*              ,FG.OFF_VSTART_TS                                          
MFA-TR*              ,FG.OFF_VEND_TS                                            
MFA-TR*              ,FG.PROC_STATUS_CD                                         
MFA-TR*              ,FG.PROC_REQ_ID                                            
MFA-TR*              ,FG.MAX_PRICE_OFFER_CD                                     
MFA-TR*              ,FG.RTCHG_PUB_OFFER_CD                                     
MFA-TR*          INTO :FG-COMPANY-NO                                            
MFA-TR*              ,:FG-OFFER-CD                                              
MFA-TR*              ,:FG-OFFER-DESC-INT                                        
MFA-TR*              ,:FG-OFFER-DESC-EXT                                        
MFA-TR*              ,:FG-PROMO-CD-INT-FL                                       
MFA-TR*              ,:FG-PROMO-CD-EXT-FL                                       
MFA-TR*              ,:FG-OFFER-START-DT                                        
MFA-TR*              ,:FG-OFFER-END-DT                                          
MFA-TR*              ,:FG-DISP-START-INT-TS                                     
MFA-TR*              ,:FG-DISP-END-INT-TS                                       
MFA-TR*              ,:FG-DISP-START-EXT-TS                                     
MFA-TR*              ,:FG-DISP-END-EXT-TS                                       
MFA-TR*              ,:FG-LAST-UPDATE-TS                                        
MFA-TR*              ,:FG-LAST-UPDATE-USERID                                    
MFA-TR*              ,:FG-OFFER-DESC-INT-LNG                                    
MFA-TR*              ,:FG-OFFER-DESC-EXT-LNG                                    
MFA-TR*              ,:FG-SPCL-OFFER-TYPE-CD                                    
MFA-TR*              ,:FG-RENEWAL-OFFER-CD                                      
MFA-TR*              ,:FG-RENEW-PUB-OFFER-CD                                    
MFA-TR*              ,:FG-OFF-VRSN-NO                                           
MFA-TR*              ,:FG-OFF-VSTART-TS                                         
MFA-TR*              ,:FG-OFF-VEND-TS                                           
MFA-TR*              ,:FG-PROC-STATUS-CD                                        
MFA-TR*              ,:FG-PROC-REQ-ID                                           
MFA-TR*              ,:FG-MAX-PRICE-OFFER-CD                                    
MFA-TR*              ,:FG-RTCHG-PUB-OFFER-CD                                    
MFA-TR*          FROM CRM_RT_PKG_OFFER FG                                       
MFA-TR*         WHERE FG.COMPANY_NO       = :FG-COMPANY-NO                      
MFA-TR*           AND FG.OFFER_CD         = :FG-OFFER-CD                        
MFA-TR*         ORDER BY FG.OFF_VRSN_NO DESC                                    
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7050                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OFFER'    TO TABLE-1                     
              MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE FG-OFFER-CD           TO HOSTVAR-ELEMENT-1           
              MOVE FG-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7060-GET-OPT-MAX-VRSN-NO.                                      *        
      ******************************************************************        
       7060-GET-OFF-MAX-VRSN-NO.                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) FI.COMPANY_NO,
              FI.OPTION_CD,
              FI.CODE_UTIL_TYPE,
              FI.RATE_PLAN_NO,
              FI.OPTION_START_DT,
              FI.OPTION_END_DT,
              FI.OPT_DESC_INT,
              FI.OPT_DESC_INT_LONG,
              FI.CURR_EXT_DESC_LONG,
              FI.RENEWAL_DESC_LONG,
              FI.WEB_DESC_LONG,
              FI.STATUS_CD,
              FI.LAST_UPDATE_USERID,
              REPLACE(REPLACE(CONVERT(CHAR(26), FI.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,
              FI.OPT_CALC_TYPE_CD,
              FI.WEB_MKT_DESC_LONG,
              FI.OPT_VRSN_NO,
              REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VSTART_TS, 121), 
           ' ', '-'), ':', '.') OPT_VSTART_TS,
              REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VEND_TS, 121), 
           ' ', '-'), ':', '.') OPT_VEND_TS,
              FI.PROC_STATUS_CD,
              FI.PROC_REQ_ID,
              FI.OPTION_TYPE_DESC,
              FI.AUTO_RENEWAL_FL,
              FI.OPTION_PROMO_DESC                              
                 INTO :FI-COMPANY-NO                                    
                     ,:FI-OPTION-CD                                     
                     ,:FI-CODE-UTIL-TYPE                                
                     ,:FI-RATE-PLAN-NO                                  
                     ,:FI-OPTION-START-DT                               
                     ,:FI-OPTION-END-DT                                 
                     ,:FI-OPT-DESC-INT                                  
                     ,:FI-OPT-DESC-INT-LONG                             
                     ,:FI-CURR-EXT-DESC-LONG                            
                     ,:FI-RENEWAL-DESC-LONG                             
                     ,:FI-WEB-DESC-LONG                                 
                     ,:FI-STATUS-CD                                     
                     ,:FI-LAST-UPDATE-USERID                            
                     ,:FI-LAST-UPDATE-TS                                
                     ,:FI-OPT-CALC-TYPE-CD                              
                     ,:FI-WEB-MKT-DESC-LONG                             
                     ,:FI-OPT-VRSN-NO                                   
                     ,:FI-OPT-VSTART-TS                                 
                     ,:FI-OPT-VEND-TS                                   
                     ,:FI-PROC-STATUS-CD                                
                     ,:FI-PROC-REQ-ID                                   
A04805               ,:FI-OPTION-TYPE-DESC                              
PRJ892               ,:FI-AUTO-RENEWAL-FL                               
PRJ892               ,:FI-OPTION-PROMO-DESC                             
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.COMPANY_NO       = :FI-COMPANY-NO              
                  AND FI.OPTION_CD        = :FI-OPTION-CD               
                ORDER BY FI.OPT_VRSN_NO DESC                            
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FI.COMPANY_NO                                             
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CODE_UTIL_TYPE                                         
MFA-TR*              ,FI.RATE_PLAN_NO                                           
MFA-TR*              ,FI.OPTION_START_DT                                        
MFA-TR*              ,FI.OPTION_END_DT                                          
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,FI.OPT_DESC_INT_LONG                                      
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,FI.RENEWAL_DESC_LONG                                      
MFA-TR*              ,FI.WEB_DESC_LONG                                          
MFA-TR*              ,FI.STATUS_CD                                              
MFA-TR*              ,FI.LAST_UPDATE_USERID                                     
MFA-TR*              ,FI.LAST_UPDATE_TS                                         
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.WEB_MKT_DESC_LONG                                      
MFA-TR*              ,FI.OPT_VRSN_NO                                            
MFA-TR*              ,FI.OPT_VSTART_TS                                          
MFA-TR*              ,FI.OPT_VEND_TS                                            
MFA-TR*              ,FI.PROC_STATUS_CD                                         
MFA-TR*              ,FI.PROC_REQ_ID                                            
MFA-TR*              ,FI.OPTION_TYPE_DESC                                       
MFA-TR*              ,FI.AUTO_RENEWAL_FL                                        
MFA-TR*              ,FI.OPTION_PROMO_DESC                                      
MFA-TR*          INTO :FI-COMPANY-NO                                            
MFA-TR*              ,:FI-OPTION-CD                                             
MFA-TR*              ,:FI-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FI-RATE-PLAN-NO                                          
MFA-TR*              ,:FI-OPTION-START-DT                                       
MFA-TR*              ,:FI-OPTION-END-DT                                         
MFA-TR*              ,:FI-OPT-DESC-INT                                          
MFA-TR*              ,:FI-OPT-DESC-INT-LONG                                     
MFA-TR*              ,:FI-CURR-EXT-DESC-LONG                                    
MFA-TR*              ,:FI-RENEWAL-DESC-LONG                                     
MFA-TR*              ,:FI-WEB-DESC-LONG                                         
MFA-TR*              ,:FI-STATUS-CD                                             
MFA-TR*              ,:FI-LAST-UPDATE-USERID                                    
MFA-TR*              ,:FI-LAST-UPDATE-TS                                        
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*              ,:FI-WEB-MKT-DESC-LONG                                     
MFA-TR*              ,:FI-OPT-VRSN-NO                                           
MFA-TR*              ,:FI-OPT-VSTART-TS                                         
MFA-TR*              ,:FI-OPT-VEND-TS                                           
MFA-TR*              ,:FI-PROC-STATUS-CD                                        
MFA-TR*              ,:FI-PROC-REQ-ID                                           
MFA-TR*              ,:FI-OPTION-TYPE-DESC                                      
MFA-TR*              ,:FI-AUTO-RENEWAL-FL                                       
MFA-TR*              ,:FI-OPTION-PROMO-DESC                                     
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.COMPANY_NO       = :FI-COMPANY-NO                      
MFA-TR*           AND FI.OPTION_CD        = :FI-OPTION-CD                       
MFA-TR*         ORDER BY FI.OPT_VRSN_NO DESC                                    
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7060                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7060'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OPTION'   TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE FI-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              MOVE FI-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
PRJ473******************************************************************        
PRJ473*                                                                *        
PRJ473* 7070-GET-TEMPLATED-OFFER.                                      *        
PRJ473******************************************************************        
PRJ473 7070-GET-TEMPLATED-OFFER.                                        
PRJ473                                                                  
PRJ473     EXEC SQL                                                     
PRJ473         SELECT TOP(1) K1.OFFER_CD                                       
PRJ473           INTO :WS-ORIG-PROMO-OFFER                              
PRJ473           FROM CRM_MKT_PROMOTION  KM WITH(READUNCOMMITTED)               
PRJ473               ,CRM_MKT_PROMOTION  K1 WITH(READUNCOMMITTED)               
PRJ473          WHERE KM.PROMO_CD         = K1.PROMO_CD                 
PRJ473            AND KM.OFFER_CD         = :KM-OFFER-CD                
PRJ473            AND KM.OFFER_CD        <> K1.OFFER_CD                 
PRJ473            AND CIS.TIMESTAMP2(K1.PROMO_END_DT,K1.PROMO_END_TM) >=     
PRJ473                   CIS.TIMESTAMP2(KM.PROMO_START_DT,
           KM.PROMO_START_TM) 
PRJ473            AND K1.PROMO_VEND_TS >= KM.PROMO_VSTART_TS            
PRJ473          ORDER BY K1.PROMO_VRSN_NO DESC                          
PRJ473                                       
PRJ473                                                      
PRJ473     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT K1.OFFER_CD                                               
MFA-TR*          INTO :WS-ORIG-PROMO-OFFER                                      
MFA-TR*          FROM CRM_MKT_PROMOTION  KM                                     
MFA-TR*              ,CRM_MKT_PROMOTION  K1                                     
MFA-TR*         WHERE KM.PROMO_CD         = K1.PROMO_CD                         
MFA-TR*           AND KM.OFFER_CD         = :KM-OFFER-CD                        
MFA-TR*           AND KM.OFFER_CD        <> K1.OFFER_CD                         
MFA-TR*           AND TIMESTAMP(K1.PROMO_END_DT,K1.PROMO_END_TM) >=             
MFA-TR*                  TIMESTAMP(KM.PROMO_START_DT,KM.PROMO_START_TM)         
MFA-TR*           AND K1.PROMO_VEND_TS >= KM.PROMO_VSTART_TS                    
MFA-TR*         ORDER BY K1.PROMO_VRSN_NO DESC                                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*          QUERYNO 7010                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ473                                                                  
PRJ473     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
PRJ473                                                                  
PRJ473     IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
PRJ473        CONTINUE                                                  
PRJ473     ELSE                                                         
PRJ473        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
PRJ473        MOVE '7070'                TO ACTIVE-PARAGRAPH            
PRJ473        MOVE 'SELECT'              TO ABEND-FUNCTION              
PRJ473        MOVE SPACES                TO ABEND-SQL-PREDICATES        
PRJ473                                      ABEND-TABLES                
PRJ473        MOVE 'CRM_MKT_PROMOTION'   TO TABLE-1                     
PRJ473        MOVE 'OFFER_CD'            TO TABLE-ELEMENT-1             
PRJ473        MOVE KM-OFFER-CD           TO HOSTVAR-ELEMENT-1           
PRJ473        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
PRJ473     END-IF.                                                      
PRJ473                                                                  
PRJ473 7070-EXIT.                                                       
PRJ473     EXIT.                                                        
                                                                        
      ******************************************************************        
      * DRIVER QUERY - TO OPTION DETAILS BASED ON OPTION CODE          *        
      * 7100-GET-OPTION-DETAILS.                                       *        
      ******************************************************************        
       7100-GET-OPTION-DET-DRIVE.                                       
                                                                        
           EXEC SQL                                                     
               SELECT FI.COMPANY_NO                                     
                     ,FI.OPTION_CD                                      
                     ,FI.CODE_UTIL_TYPE                                 
                     ,FI.RATE_PLAN_NO                                   
                     ,FI.OPTION_START_DT                                
                     ,FI.OPTION_END_DT                                  
                     ,FI.OPT_DESC_INT                                   
                     ,FI.OPT_DESC_INT_LONG                              
                     ,FI.CURR_EXT_DESC_LONG                             
                     ,FI.RENEWAL_DESC_LONG                              
                     ,FI.WEB_DESC_LONG                                  
                     ,FI.STATUS_CD                                      
                     ,FI.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           FI.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,FI.OPT_CALC_TYPE_CD                               
                     ,FI.WEB_MKT_DESC_LONG                              
                     ,FI.OPT_VRSN_NO                                    
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VSTART_TS
           , 121), ' ', '-'), ':', '.') OPT_VSTART_TS                          
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), FI.OPT_VEND_TS
           , 121), ' ', '-'), ':', '.') OPT_VEND_TS                            
                     ,FI.PROC_STATUS_CD                                 
                     ,FI.PROC_REQ_ID                                    
A04805               ,FI.OPTION_TYPE_DESC                               
PRJ892               ,FI.AUTO_RENEWAL_FL                                
PRJ892               ,FI.OPTION_PROMO_DESC                              
                 INTO :FI-COMPANY-NO                                    
                     ,:FI-OPTION-CD                                     
                     ,:FI-CODE-UTIL-TYPE                                
                     ,:FI-RATE-PLAN-NO                                  
                     ,:FI-OPTION-START-DT                               
                     ,:FI-OPTION-END-DT                                 
                     ,:FI-OPT-DESC-INT                                  
                     ,:FI-OPT-DESC-INT-LONG                             
                     ,:FI-CURR-EXT-DESC-LONG                            
                     ,:FI-RENEWAL-DESC-LONG                             
                     ,:FI-WEB-DESC-LONG                                 
                     ,:FI-STATUS-CD                                     
                     ,:FI-LAST-UPDATE-USERID                            
                     ,:FI-LAST-UPDATE-TS                                
                     ,:FI-OPT-CALC-TYPE-CD                              
                     ,:FI-WEB-MKT-DESC-LONG                             
                     ,:FI-OPT-VRSN-NO                                   
                     ,:FI-OPT-VSTART-TS                                 
                     ,:FI-OPT-VEND-TS                                   
                     ,:FI-PROC-STATUS-CD                                
                     ,:FI-PROC-REQ-ID                                   
A04805               ,:FI-OPTION-TYPE-DESC                              
PRJ892               ,:FI-AUTO-RENEWAL-FL                               
PRJ892               ,:FI-OPTION-PROMO-DESC                             
                 FROM CRM_RT_PKG_OPTION FI WITH(READUNCOMMITTED)                
                WHERE FI.COMPANY_NO      = :FI-COMPANY-NO               
                  AND ((FI.OPT_VRSN_NO   = :FI-OPT-VRSN-NO              
                        AND FI.OPTION_CD = :FI-OPTION-CD                
                        AND :WS-PROCESS-REQ-ID = 0 )                    
                         OR                                             
                       (FI.PROC_REQ_ID = :FI-PROC-REQ-ID                
                        AND :WS-PROCESS-REQ-ID > 0 ))                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FI.COMPANY_NO                                             
MFA-TR*              ,FI.OPTION_CD                                              
MFA-TR*              ,FI.CODE_UTIL_TYPE                                         
MFA-TR*              ,FI.RATE_PLAN_NO                                           
MFA-TR*              ,FI.OPTION_START_DT                                        
MFA-TR*              ,FI.OPTION_END_DT                                          
MFA-TR*              ,FI.OPT_DESC_INT                                           
MFA-TR*              ,FI.OPT_DESC_INT_LONG                                      
MFA-TR*              ,FI.CURR_EXT_DESC_LONG                                     
MFA-TR*              ,FI.RENEWAL_DESC_LONG                                      
MFA-TR*              ,FI.WEB_DESC_LONG                                          
MFA-TR*              ,FI.STATUS_CD                                              
MFA-TR*              ,FI.LAST_UPDATE_USERID                                     
MFA-TR*              ,FI.LAST_UPDATE_TS                                         
MFA-TR*              ,FI.OPT_CALC_TYPE_CD                                       
MFA-TR*              ,FI.WEB_MKT_DESC_LONG                                      
MFA-TR*              ,FI.OPT_VRSN_NO                                            
MFA-TR*              ,FI.OPT_VSTART_TS                                          
MFA-TR*              ,FI.OPT_VEND_TS                                            
MFA-TR*              ,FI.PROC_STATUS_CD                                         
MFA-TR*              ,FI.PROC_REQ_ID                                            
MFA-TR*              ,FI.OPTION_TYPE_DESC                                       
MFA-TR*              ,FI.AUTO_RENEWAL_FL                                        
MFA-TR*              ,FI.OPTION_PROMO_DESC                                      
MFA-TR*          INTO :FI-COMPANY-NO                                            
MFA-TR*              ,:FI-OPTION-CD                                             
MFA-TR*              ,:FI-CODE-UTIL-TYPE                                        
MFA-TR*              ,:FI-RATE-PLAN-NO                                          
MFA-TR*              ,:FI-OPTION-START-DT                                       
MFA-TR*              ,:FI-OPTION-END-DT                                         
MFA-TR*              ,:FI-OPT-DESC-INT                                          
MFA-TR*              ,:FI-OPT-DESC-INT-LONG                                     
MFA-TR*              ,:FI-CURR-EXT-DESC-LONG                                    
MFA-TR*              ,:FI-RENEWAL-DESC-LONG                                     
MFA-TR*              ,:FI-WEB-DESC-LONG                                         
MFA-TR*              ,:FI-STATUS-CD                                             
MFA-TR*              ,:FI-LAST-UPDATE-USERID                                    
MFA-TR*              ,:FI-LAST-UPDATE-TS                                        
MFA-TR*              ,:FI-OPT-CALC-TYPE-CD                                      
MFA-TR*              ,:FI-WEB-MKT-DESC-LONG                                     
MFA-TR*              ,:FI-OPT-VRSN-NO                                           
MFA-TR*              ,:FI-OPT-VSTART-TS                                         
MFA-TR*              ,:FI-OPT-VEND-TS                                           
MFA-TR*              ,:FI-PROC-STATUS-CD                                        
MFA-TR*              ,:FI-PROC-REQ-ID                                           
MFA-TR*              ,:FI-OPTION-TYPE-DESC                                      
MFA-TR*              ,:FI-AUTO-RENEWAL-FL                                       
MFA-TR*              ,:FI-OPTION-PROMO-DESC                                     
MFA-TR*          FROM CRM_RT_PKG_OPTION FI                                      
MFA-TR*         WHERE FI.COMPANY_NO      = :FI-COMPANY-NO                       
MFA-TR*           AND ((FI.OPT_VRSN_NO   = :FI-OPT-VRSN-NO                      
MFA-TR*                 AND FI.OPTION_CD = :FI-OPTION-CD                        
MFA-TR*                 AND :WS-PROCESS-REQ-ID = 0 )                            
MFA-TR*                  OR                                                     
MFA-TR*                (FI.PROC_REQ_ID = :FI-PROC-REQ-ID                        
MFA-TR*                 AND :WS-PROCESS-REQ-ID > 0 ))                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND                    
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OPTION'   TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE FI-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *  7101-OPEN-OPTION-DET-CUR.                                     *        
      ******************************************************************        
       7101-OPEN-OPTION-DET-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN OPTION_DET_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7101'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_RT_PKG_OPTION'   TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE FI-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7101-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET ALL THE OPTION DETAILS BASED ON OPTION CODE                *        
      * 7102-FETCH-OPTION-DET-CUR.                                     *        
      ******************************************************************        
       7102-FETCH-OPTION-DET-CUR.                                       
                                                                        
           EXEC SQL                                                     
               FETCH OPTION_DET_CUR                                     
                INTO :FI-COMPANY-NO                                     
                    ,:FI-OPTION-CD                                      
                    ,:FI-CODE-UTIL-TYPE                                 
                    ,:FI-RATE-PLAN-NO                                   
                    ,:FI-OPTION-START-DT                                
                    ,:FI-OPTION-END-DT                                  
                    ,:FI-OPT-DESC-INT                                   
                    ,:FI-OPT-DESC-INT-LONG                              
                    ,:FI-CURR-EXT-DESC-LONG                             
                    ,:FI-RENEWAL-DESC-LONG                              
                    ,:FI-WEB-DESC-LONG                                  
                    ,:FI-STATUS-CD                                      
                    ,:FI-LAST-UPDATE-USERID                             
                    ,:FI-LAST-UPDATE-TS                                 
                    ,:FI-OPT-CALC-TYPE-CD                               
                    ,:FI-WEB-MKT-DESC-LONG                              
                    ,:FI-OPT-VRSN-NO                                    
                    ,:FI-OPT-VSTART-TS                                  
                    ,:FI-OPT-VEND-TS                                    
                    ,:FI-PROC-STATUS-CD                                 
                    ,:FI-PROC-REQ-ID                                    
A04805              ,:FI-OPTION-TYPE-DESC                               
PRJ892              ,:FI-AUTO-RENEWAL-FL                                
PRJ892              ,:FI-OPTION-PROMO-DESC                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    MOVE 'Y'                TO WS-STATUS-FOR-OPTION     
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-OPTION-ROWS   
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7102'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_RT_PKG_OPTION'  TO TABLE-1                
                    MOVE 'OPTION_CD'        TO TABLE-ELEMENT-1          
                    MOVE FI-OPTION-CD       TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7102-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7103-CLOSE-OPTION-DET-CUR.                                     *        
      ******************************************************************        
       7103-CLOSE-OPTION-DET-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE OPTION_DET_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7103'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RT_PKG_OPTION'      TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE FI-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7103-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7105-ACCEPT-TIMESTAMP.                                         *        
      ******************************************************************        
       7105-ACCEPT-TIMESTAMP.                                           
                                                                        
           MOVE '7105'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
                 SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE            
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7105'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SET'                    TO ABEND-FUNCTION           
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7105-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      *  7110-OPEN-ATTR-INCEN-CUR.                                     *        
      ******************************************************************        
       7110-OPEN-ATTR-INCEN-CUR.                                        
                                                                        
           EXEC SQL                                                     
                OPEN ATTR_INCEN_CUR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7110'                TO ACTIVE-PARAGRAPH            
              MOVE 'OPEN'                TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CRM_OPT_ATTR_INCTV'  TO TABLE-1                     
              MOVE 'OPTION_CD'           TO TABLE-ELEMENT-1             
              MOVE HQ-OPTION-CD          TO HOSTVAR-ELEMENT-1           
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *   7120-FETCH-ATTR-INCEN-CUR.                                   *        
      ******************************************************************        
       7120-FETCH-ATTR-INCEN-CUR.                                       
                                                                        
           EXEC SQL                                                     
              FETCH ATTR_INCEN_CUR                                      
               INTO :HQ-COMPANY-NO                                      
                   ,:HQ-OPTION-CD                                       
                   ,:HQ-ATTR-INCTV-SEQ-NO                               
                   ,:HQ-RT-ATTR-INCTV-TYPE                              
                   ,:HQ-PRIMRY-OPT-ATTR-FL                              
                   ,:HQ-FACTOR-ID                                       
                   ,:HQ-DURATION-NO :WS-NULL-IND-01                      
                   ,:HQ-APPL-PROGRAM-ID                                 
                   ,:HQ-ATTR-INCTV-VALUE :WS-NULL-IND-02                 
                   ,:HQ-ATTR-INCTV-VAL-TX                               
                   ,:HQ-LAST-UPDATE-USERID                              
                   ,:HQ-LAST-UPDATE-TS                                  
                   ,:HQ-GL-ACCT-CREDIT                                  
                   ,:HQ-GL-ACCT-DEBIT                                   
                   ,:HQ-CATEGORY-ID                                     
                   ,:HQ-WQ-ROUTE-CATEGORY                               
                   ,:HQ-OPT-CHG-ACTION-CD                               
                   ,:HQ-ATTR-INCTV-STRT-DT                              
                   ,:HQ-ATTR-INCTV-END-DT                               
                   ,:HQ-OPT-ATTR-VRSN-NO                                
                   ,:HQ-OPT-ATTR-VSTART-TS                              
                   ,:HQ-OPT-ATTR-VEND-TS                                
                   ,:HQ-PROC-STATUS-CD                                  
                   ,:HQ-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-NULL-IND-01       =  WS-YES-NULL              
                       MOVE ZEROS           TO HQ-DURATION-NO           
                    END-IF                                              
                                                                        
                    IF WS-NULL-IND-02 = WS-YES-NULL                     
                       MOVE ZEROES          TO HQ-ATTR-INCTV-VALUE      
                    END-IF                                              
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-EOF-ATTR-CURSOR       
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7120'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_OPT_ATTR_INCTV'                           
                                            TO TABLE-1                  
                    MOVE 'OPTION_CD'        TO TABLE-ELEMENT-1          
                    MOVE HQ-OPTION-CD       TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7130-CLOSE-ATTR-INCEN-CUR.                                     *        
      ******************************************************************        
       7130-CLOSE-ATTR-INCEN-CUR.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE ATTR_INCEN_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-3.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7130'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OPT_ATTR_INCTV'     TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE HQ-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7140-OPEN-SECURED-OFF-OPT.                                     *        
      ******************************************************************        
       7140-OPEN-SECURED-OFF-OPT.                                       
                                                                        
           EXEC SQL                                                     
                OPEN SECURED_OPT_CUR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7140'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_ACCESS_OFF_OPT'     TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE CI-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7150-FETCH-SECURED-OFF-OPT.                                    *        
      ******************************************************************        
       7150-FETCH-SECURED-OFF-OPT.                                      
                                                                        
           EXEC SQL                                                     
              FETCH SECURED_OPT_CUR                                     
               INTO :CI-COMPANY-NO                                      
                   ,:CI-OPTION-CD                                       
                   ,:CI-OFFER-CD                                        
                   ,:CI-CATEGORY-ID                                     
                   ,:CI-ACCESS-START-DT                                 
                   ,:CI-ACCESS-END-DT                                   
                   ,:CI-VIEW-APPLY-CD                                   
                   ,:CI-LAST-UPDATE-USERID                              
                   ,:CI-LAST-UPDATE-TS                                  
                   ,:CI-COMMENTS-TX                                     
                   ,:CI-ACCESS-VRSN-NO                                  
                   ,:CI-ACCESS-VSTART-TS                                
                   ,:CI-ACCESS-VEND-TS                                  
                   ,:CI-PROC-STATUS-CD                                  
                   ,:CI-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7150'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_ACCESS_OFF_OPT' TO TABLE-1                
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE CI-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7160-CLOSE-SECURED-OFF-OPT.                                    *        
      ******************************************************************        
       7160-CLOSE-SECURED-OFF-OPT.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE SECURED_OPT_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-4.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7160'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OPT_ATTR_INCTV'     TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE CI-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *                                                                *        
      * 7170-OPEN-MKT-PROMOTION.                                       *        
      ******************************************************************        
       7170-OPEN-MKT-PROMOTION.                                         
                                                                        
           EXEC SQL                                                     
                OPEN MKT_PROMOTION_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-5.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7170'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_MKT_PROMOTION'      TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE KM-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7180-FETCH-MKT-PROMOTION.                                     *         
      *****************************************************************         
       7180-FETCH-MKT-PROMOTION.                                        
                                                                        
           EXEC SQL                                                     
              FETCH MKT_PROMOTION_CUR                                   
               INTO :KM-COMPANY-NO                                      
                   ,:KM-PROMO-CD                                        
                   ,:KM-PROMO-DESC                                      
                   ,:KM-OFFER-CD                                        
                   ,:KM-MKT-PLAN-CD                                     
                   ,:KM-PROMO-START-DT                                  
                   ,:KM-PROMO-START-TM                                  
                   ,:KM-PROMO-END-DT                                    
                   ,:KM-PROMO-END-TM                                    
                   ,:KM-AD-CHANNEL-CD                                   
                   ,:KM-PROMO-DESC-LONG                                 
                   ,:KM-EXT-LANDING-PG-URL                              
                   ,:KM-PROMO-TYPE-CD                                   
                   ,:KM-WEB-IMAGE-FILE-NM                               
                   ,:KM-LAST-UPDATE-USERID                              
                   ,:KM-LAST-UPDATE-TS                                  
                   ,:KM-REPLACMNT-PROMO-CD                              
                   ,:KM-DISPLAY-END-DT                                  
                   ,:KM-INT-LANDING-PG-URL                              
                   ,:KM-PROMO-VRSN-NO                                   
                   ,:KM-PROMO-VSTART-TS                                 
                   ,:KM-PROMO-VEND-TS                                   
                   ,:KM-PROC-STATUS-CD                                  
                   ,:KM-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-5          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7180'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                            ABEND-TABLES                
                    MOVE 'CRM_MKT_PROMOTION' TO TABLE-1                 
                    MOVE 'PROMO_CD'         TO TABLE-ELEMENT-1          
                    MOVE KM-PROMO-CD        TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7180-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7190-CLOSE-MKT-PROMOTION.                                     *         
      *****************************************************************         
       7190-CLOSE-MKT-PROMOTION.                                        
                                                                        
           EXEC SQL                                                     
                CLOSE MKT_PROMOTION_CUR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-5.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7190'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_MKT_PROMOTION'      TO TABLE-1                  
              MOVE 'PROMO_CD'               TO TABLE-ELEMENT-1          
              MOVE KM-PROMO-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7200-OPEN-OFF-MKT-TIER.                                       *         
      *****************************************************************         
       7200-OPEN-OFF-MKT-TIER.                                          
                                                                        
           EXEC SQL                                                     
                OPEN OFF_MKT_TIER_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-6.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE DU-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7210-FETCH-OFF-MKT-TIER.                                      *         
      *****************************************************************         
       7210-FETCH-OFF-MKT-TIER.                                         
                                                                        
           EXEC SQL                                                     
              FETCH OFF_MKT_TIER_CUR                                    
               INTO :DU-COMPANY-NO                                      
                   ,:DU-OFFER-CD                                        
                   ,:DU-TIER-CUST-STAT-CD                               
                   ,:DU-TIER-ACCT-TYPE-CD                               
                   ,:DU-MKT-TIER-RANKING                                
                   ,:DU-MKT-TIER-START-DT                               
                   ,:DU-OFFER-TIER-STRT-DT                              
                   ,:DU-MKT-TIER-APPLY-CD                               
                   ,:DU-TIER-DEFLT-OFFR-CD                              
                   ,:DU-OFFER-TIER-END-DT                               
                   ,:DU-LAST-UPDATE-USERID                              
                   ,:DU-LAST-UPDATE-TS                                  
                   ,:DU-OFF-TIER-VRSN-NO                                
                   ,:DU-OFF-TIER-VSTART-TS                              
                   ,:DU-OFF-TIER-VEND-TS                                
                   ,:DU-PROC-STATUS-CD                                  
                   ,:DU-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-6          
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7210'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_OFF_MKT_TIER' TO TABLE-1                  
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE DU-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7220-CLOSE-OFF-MKT-TIER. CLOSE OFF_MKT_TIER_CUR               *         
      *****************************************************************         
       7220-CLOSE-OFF-MKT-TIER.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE OFF_MKT_TIER_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-6.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7220'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFF_MKT_TIER'       TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE DU-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7230-OPEN-OFF-OPT-FOR-OPTION.                                 *         
      *****************************************************************         
       7230-OPEN-OFF-OPT-FOR-OPTION.                                    
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_OPTION_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7230'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFFER_OPTION'       TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE E9-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *  FETCH OFFER_OPTION_CUR                                       *         
      *****************************************************************         
       7240-FETCH-OFF-OPT-FOR-OPTION.                                   
                                                                        
           EXEC SQL                                                     
              FETCH OFFER_OPTION_CUR                                    
               INTO :E9-COMPANY-NO                                      
                   ,:E9-OFFER-CD                                        
                   ,:E9-OPTION-CD                                       
                   ,:E9-OPTION-SORT-SEQ-NO                              
                   ,:E9-OPTION-URL-TX                                   
                   ,:E9-LAST-UPDATE-USERID                              
                   ,:E9-LAST-UPDATE-TS                                  
                   ,:E9-DROP-OPTION-CD                                  
                   ,:E9-OFFER-OPT-START-DT                              
                   ,:E9-OFFER-OPT-END-DT                                
                   ,:E9-OFF-OPT-VRSN-NO                                 
                   ,:E9-OFF-OPT-VSTART-TS                               
                   ,:E9-OFF-OPT-VEND-TS                                 
                   ,:E9-PROC-STATUS-CD                                  
                   ,:E9-PROC-REQ-ID                                     
A04805             ,:E9-WEB-NEW-EXISTS-CD                               
A04805             ,:E9-WEB-SIGN-UP-FL                                  
A04805             ,:E9-OFF-OPT-EXCLUDE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7240'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_OFFER_OPTION' TO TABLE-1                  
                    MOVE 'OPTION_CD'        TO TABLE-ELEMENT-1          
                    MOVE E9-OPTION-CD       TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7250-CLOSE-OFF-OPT-FOR-OPTION.                                 *        
      ******************************************************************        
       7250-CLOSE-OFF-OPT-FOR-OPTION.                                   
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_OPTION_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7250'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFFER_OPTION'       TO TABLE-1                  
              MOVE 'OPTION_CD'              TO TABLE-ELEMENT-1          
              MOVE E9-OPTION-CD             TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7260-OPEN-OFF-OPT-FOR-OFFER.                                  *         
      *****************************************************************         
       7260-OPEN-OFF-OPT-FOR-OFFER.                                     
                                                                        
           EXEC SQL                                                     
                OPEN OFFER_OPTION_CUR2                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7260'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFFER_OPTION'       TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE E9-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *  7270-FETCH-OFF-OPT-FOR-OFFER.                                *         
      *****************************************************************         
       7270-FETCH-OFF-OPT-FOR-OFFER.                                    
                                                                        
           EXEC SQL                                                     
              FETCH OFFER_OPTION_CUR2                                   
               INTO :E9-COMPANY-NO                                      
                   ,:E9-OFFER-CD                                        
                   ,:E9-OPTION-CD                                       
                   ,:E9-OPTION-SORT-SEQ-NO                              
                   ,:E9-OPTION-URL-TX                                   
                   ,:E9-LAST-UPDATE-USERID                              
                   ,:E9-LAST-UPDATE-TS                                  
                   ,:E9-DROP-OPTION-CD                                  
                   ,:E9-OFFER-OPT-START-DT                              
                   ,:E9-OFFER-OPT-END-DT                                
                   ,:E9-OFF-OPT-VRSN-NO                                 
                   ,:E9-OFF-OPT-VSTART-TS                               
                   ,:E9-OFF-OPT-VEND-TS                                 
                   ,:E9-PROC-STATUS-CD                                  
                   ,:E9-PROC-REQ-ID                                     
A04805             ,:E9-WEB-NEW-EXISTS-CD                               
A04805             ,:E9-WEB-SIGN-UP-FL                                  
A04805             ,:E9-OFF-OPT-EXCLUDE-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7270'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_OFFER_OPTION' TO TABLE-1                  
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE E9-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7270-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7280-CLOSE-OFF-OPT-FOR-OFFER.                                 *         
      *****************************************************************-        
       7280-CLOSE-OFF-OPT-FOR-OFFER.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE OFFER_OPTION_CUR2                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7280'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_OFFER_OPTION'       TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE E9-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7280-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7290-OPEN-RATE-GRP-OFFER.                                     *         
      *****************************************************************         
       7290-OPEN-RATE-GRP-OFFER.                                        
                                                                        
           EXEC SQL                                                     
                OPEN RATE_GRP_OFF_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-7.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7290'                   TO ACTIVE-PARAGRAPH         
              MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RATE_GRP_OFFER'     TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE G5-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      *  7300-FETCH-RATE-GRP-OFFER.                                   *         
      *****************************************************************         
       7300-FETCH-RATE-GRP-OFFER.                                       
                                                                        
           EXEC SQL                                                     
              FETCH RATE_GRP_OFF_CUR                                    
               INTO :G5-COMPANY-NO                                      
                   ,:G5-RATE-GROUP-TYPE-CD                              
                   ,:G5-RATE-GROUP-CD                                   
                   ,:G5-SORT-SEQ-NO                                     
                   ,:G5-EFF-START-DT                                    
                   ,:G5-EFF-END-DT                                      
                   ,:G5-OFFER-CD                                        
                   ,:G5-OPTION-CD                                       
                   ,:G5-LAST-UPDATE-USERID                              
                   ,:G5-LAST-UPDATE-TS                                  
                   ,:G5-GRP-OFF-VRSN-NO                                 
                   ,:G5-GRP-OFF-VSTART-TS                               
                   ,:G5-GRP-OFF-VEND-TS                                 
                   ,:G5-PROC-STATUS-CD                                  
                   ,:G5-PROC-REQ-ID                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-7.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE 'Y'                TO WS-NO-MORE-ROWS          
                    MOVE 0                  TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '7300'             TO ACTIVE-PARAGRAPH         
                    MOVE 'FETCH'            TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CRM_RATE_GRP_OFFER' TO TABLE-1                
                    MOVE 'OFFER_CD'         TO TABLE-ELEMENT-1          
                    MOVE G5-OFFER-CD        TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 7310-CLOSE-RATE-GRP-OFFER.                                    *         
      *****************************************************************-        
       7310-CLOSE-RATE-GRP-OFFER.                                       
                                                                        
           EXEC SQL                                                     
                CLOSE RATE_GRP_OFF_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-7.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7310'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_RATE_GRP_OFFER'     TO TABLE-1                  
              MOVE 'OFFER_CD'               TO TABLE-ELEMENT-1          
              MOVE G5-OFFER-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * DRIVER QUERY - TO GET ALL PROMOTION DEATILS BASED ON PROMO CD *         
      * 7500-GET-MKT-PROMOTION-DET.                                   *         
      *****************************************************************         
       7500-GET-MKT-PROMOTION-DET.                                      
                                                                        
           EXEC SQL                                                     
               SELECT KM.COMPANY_NO                                     
                     ,KM.PROMO_CD                                       
                     ,KM.PROMO_DESC                                     
                     ,KM.OFFER_CD                                       
                     ,KM.MKT_PLAN_CD                                    
                     ,KM.PROMO_START_DT                                 
                     ,REPLACE(CONVERT(CHAR(8), KM.PROMO_START_TM, 108), 
           ':', '.') PROMO_START_TM                                 
                     ,KM.PROMO_END_DT                                   
                     ,REPLACE(CONVERT(CHAR(8), KM.PROMO_END_TM, 108), 
           ':', '.') PROMO_END_TM                                   
                     ,KM.AD_CHANNEL_CD                                  
                     ,KM.PROMO_DESC_LONG                                
                     ,KM.EXT_LANDING_PG_URL                             
                     ,KM.PROMO_TYPE_CD                                  
                     ,KM.WEB_IMAGE_FILE_NM                              
                     ,KM.LAST_UPDATE_USERID                             
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,KM.REPLACMNT_PROMO_CD                             
                     ,KM.DISPLAY_END_DT                                 
                     ,KM.INT_LANDING_PG_URL                             
                     ,KM.PROMO_VRSN_NO                                  
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           KM.PROMO_VSTART_TS, 121), ' ', '-'), ':', '.') 
           PROMO_VSTART_TS                                
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), KM.PROMO_VEND_TS
           , 121), ' ', '-'), ':', '.') PROMO_VEND_TS                          
                     ,KM.PROC_STATUS_CD                                 
                     ,KM.PROC_REQ_ID                                    
                 INTO :KM-COMPANY-NO                                    
                     ,:KM-PROMO-CD                                      
                     ,:KM-PROMO-DESC                                    
                     ,:KM-OFFER-CD                                      
                     ,:KM-MKT-PLAN-CD                                   
                     ,:KM-PROMO-START-DT                                
                     ,:KM-PROMO-START-TM                                
                     ,:KM-PROMO-END-DT                                  
                     ,:KM-PROMO-END-TM                                  
                     ,:KM-AD-CHANNEL-CD                                 
                     ,:KM-PROMO-DESC-LONG                               
                     ,:KM-EXT-LANDING-PG-URL                            
                     ,:KM-PROMO-TYPE-CD                                 
                     ,:KM-WEB-IMAGE-FILE-NM                             
                     ,:KM-LAST-UPDATE-USERID                            
                     ,:KM-LAST-UPDATE-TS                                
                     ,:KM-REPLACMNT-PROMO-CD                            
                     ,:KM-DISPLAY-END-DT                                
                     ,:KM-INT-LANDING-PG-URL                            
                     ,:KM-PROMO-VRSN-NO                                 
                     ,:KM-PROMO-VSTART-TS                               
                     ,:KM-PROMO-VEND-TS                                 
                     ,:KM-PROC-STATUS-CD                                
                     ,:KM-PROC-REQ-ID                                   
                 FROM CRM_MKT_PROMOTION  KM WITH(READUNCOMMITTED)               
                WHERE KM.COMPANY_NO      = :KM-COMPANY-NO               
                  AND ((KM.PROMO_VRSN_NO = :KM-PROMO-VRSN-NO            
                        AND KM.PROMO_CD  = :KM-PROMO-CD                 
                        AND :WS-PROCESS-REQ-ID = 0 )                    
                         OR                                             
                       (KM.PROC_REQ_ID   = :KM-PROC-REQ-ID              
                        AND :WS-PROCESS-REQ-ID > 0 ))                   
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT KM.COMPANY_NO                                             
MFA-TR*              ,KM.PROMO_CD                                               
MFA-TR*              ,KM.PROMO_DESC                                             
MFA-TR*              ,KM.OFFER_CD                                               
MFA-TR*              ,KM.MKT_PLAN_CD                                            
MFA-TR*              ,KM.PROMO_START_DT                                         
MFA-TR*              ,KM.PROMO_START_TM                                         
MFA-TR*              ,KM.PROMO_END_DT                                           
MFA-TR*              ,KM.PROMO_END_TM                                           
MFA-TR*              ,KM.AD_CHANNEL_CD                                          
MFA-TR*              ,KM.PROMO_DESC_LONG                                        
MFA-TR*              ,KM.EXT_LANDING_PG_URL                                     
MFA-TR*              ,KM.PROMO_TYPE_CD                                          
MFA-TR*              ,KM.WEB_IMAGE_FILE_NM                                      
MFA-TR*              ,KM.LAST_UPDATE_USERID                                     
MFA-TR*              ,KM.LAST_UPDATE_TS                                         
MFA-TR*              ,KM.REPLACMNT_PROMO_CD                                     
MFA-TR*              ,KM.DISPLAY_END_DT                                         
MFA-TR*              ,KM.INT_LANDING_PG_URL                                     
MFA-TR*              ,KM.PROMO_VRSN_NO                                          
MFA-TR*              ,KM.PROMO_VSTART_TS                                        
MFA-TR*              ,KM.PROMO_VEND_TS                                          
MFA-TR*              ,KM.PROC_STATUS_CD                                         
MFA-TR*              ,KM.PROC_REQ_ID                                            
MFA-TR*          INTO :KM-COMPANY-NO                                            
MFA-TR*              ,:KM-PROMO-CD                                              
MFA-TR*              ,:KM-PROMO-DESC                                            
MFA-TR*              ,:KM-OFFER-CD                                              
MFA-TR*              ,:KM-MKT-PLAN-CD                                           
MFA-TR*              ,:KM-PROMO-START-DT                                        
MFA-TR*              ,:KM-PROMO-START-TM                                        
MFA-TR*              ,:KM-PROMO-END-DT                                          
MFA-TR*              ,:KM-PROMO-END-TM                                          
MFA-TR*              ,:KM-AD-CHANNEL-CD                                         
MFA-TR*              ,:KM-PROMO-DESC-LONG                                       
MFA-TR*              ,:KM-EXT-LANDING-PG-URL                                    
MFA-TR*              ,:KM-PROMO-TYPE-CD                                         
MFA-TR*              ,:KM-WEB-IMAGE-FILE-NM                                     
MFA-TR*              ,:KM-LAST-UPDATE-USERID                                    
MFA-TR*              ,:KM-LAST-UPDATE-TS                                        
MFA-TR*              ,:KM-REPLACMNT-PROMO-CD                                    
MFA-TR*              ,:KM-DISPLAY-END-DT                                        
MFA-TR*              ,:KM-INT-LANDING-PG-URL                                    
MFA-TR*              ,:KM-PROMO-VRSN-NO                                         
MFA-TR*              ,:KM-PROMO-VSTART-TS                                       
MFA-TR*              ,:KM-PROMO-VEND-TS                                         
MFA-TR*              ,:KM-PROC-STATUS-CD                                        
MFA-TR*              ,:KM-PROC-REQ-ID                                           
MFA-TR*          FROM CRM_MKT_PROMOTION  KM                                     
MFA-TR*         WHERE KM.COMPANY_NO      = :KM-COMPANY-NO                       
MFA-TR*           AND ((KM.PROMO_VRSN_NO = :KM-PROMO-VRSN-NO                    
MFA-TR*                 AND KM.PROMO_CD  = :KM-PROMO-CD                         
MFA-TR*                 AND :WS-PROCESS-REQ-ID = 0 )                            
MFA-TR*                  OR                                                     
MFA-TR*                (KM.PROC_REQ_ID   = :KM-PROC-REQ-ID                      
MFA-TR*                 AND :WS-PROCESS-REQ-ID > 0 ))                           
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-5.         
                                                                        
           IF SQLCODE = SUCCESSFUL-CALL                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7500'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CRM_MKT_PROMOTION'      TO TABLE-1                  
              MOVE 'KM-PROMO-CD'            TO TABLE-ELEMENT-1          
              MOVE KM-PROMO-CD              TO HOSTVAR-ELEMENT-1        
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000A-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000A-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04426_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04426_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-1          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04426_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000B-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000B-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04426_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04426_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2.         
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE-2          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000B'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04426_R2'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000B-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000C-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000C-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04426_R3                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04426_R3                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000C'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04426_R3'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000C-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000D-DEL-GTT-ROWS.                                           *         
      *****************************************************************         
       8000D-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04426_R4                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04426_R4                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000D'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04426_R4'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000D-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8000E-DEL-GTT-ROWS.                                            *        
      *****************************************************************         
       8000E-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04426_R5                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04426_R5                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000E'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04426_R5'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000E-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000F-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
       8000F-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04426_R6                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04426_R6                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000F'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04426_R6'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000F-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8000G-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
       8000G-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04426_R7                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04426_R7                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-7.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-7             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000G'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04426_R7'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000G-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 8000H-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
       8000H-DEL-GTT-ROWS.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04426_R8                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04426_R8                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-8.            
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES          TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-8             
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE SQLCODE         TO ABEND-SQLCODE               
                    MOVE SQLSTATE        TO ABEND-SQLSTATE              
                    MOVE '8000H'         TO ACTIVE-PARAGRAPH            
                    MOVE 'DELETE'        TO ABEND-FUNCTION              
                    MOVE SPACES          TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                    MOVE 'CSR04426_R8'   TO TABLE-1                     
                    MOVE SPACES          TO TABLE-ELEMENT-1             
                    MOVE SPACES          TO HOSTVAR-ELEMENT-1           
                    PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
       8000H-EXIT.                                                      
            EXIT.                                                       
      ******************************************************************        
      *                                                                *        
      * 8010-INSERT-GTT-R1.   OFFER CODE TABLE                         *        
      ******************************************************************        
       8010-INSERT-GTT-R1.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04426_R1                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TABLE_ID                                             
                  ,COMPANY_NO                                           
                  ,OFFER_CD                                             
                  ,OFFER_DESC_INT                                       
                  ,OFFER_DESC_EXT                                       
                  ,PROMO_CD_INT_FL                                      
                  ,PROMO_CD_EXT_FL                                      
                  ,OFFER_START_DT                                       
                  ,OFFER_END_DT                                         
                  ,DISP_START_INT_TS                                    
                  ,DISP_END_INT_TS                                      
                  ,DISP_START_EXT_TS                                    
                  ,DISP_END_EXT_TS                                      
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                  ,OFFER_DESC_INT_LNG                                   
                  ,OFFER_DESC_EXT_LNG                                   
                  ,SPCL_OFFER_TYPE_CD                                   
                  ,RENEWAL_OFFER_CD                                     
                  ,RENEW_PUB_OFFER_CD                                   
                  ,OFF_VRSN_NO                                          
                  ,OFF_VSTART_TS                                        
                  ,OFF_VEND_TS                                          
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                  ,TEMPLATE_OFFER                                       
                  ,SET_PROMO_FLGS                                       
                  ,UNDFLT_OFF_TIER_FLAG                                 
PRJ473            ,TEMPLATE_INT_DESC                                    
PRJ473            ,TEMPLATE_REN_OFFR                                    
PRJ473            ,TEMPLATE_EXT_DESC                                    
PRJ680            ,MAX_PRICE_OFFER_CD                                   
P00863            ,RTCHG_PUB_OFFER_CD                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-1                                     
                  ,:S-APPL-RETURN-CODE-1                                
                  ,:S-RS1-TABLE-ID                                      
                  ,:S-RS1-COMPANY-NO                                    
                  ,:S-RS1-OFFER-CD                                      
                  ,:S-RS1-OFFER-DESC-INT                                
                  ,:S-RS1-OFFER-DESC-EXT                                
                  ,:S-RS1-PROMO-CD-INT-FL                               
                  ,:S-RS1-PROMO-CD-EXT-FL                               
                  ,:S-RS1-OFFER-START-DT                                
                  ,:S-RS1-OFFER-END-DT                                  
                  ,:S-RS1-DISP-START-INT-TS                             
                  ,:S-RS1-DISP-END-INT-TS                               
                  ,:S-RS1-DISP-START-EXT-TS                             
                  ,:S-RS1-DISP-END-EXT-TS                               
                  ,:S-RS1-LAST-UPDATE-TS                                
                  ,:S-RS1-LAST-UPDATE-USERID                            
                  ,:S-RS1-OFFER-DESC-INT-LNG                            
                  ,:S-RS1-OFFER-DESC-EXT-LNG                            
                  ,:S-RS1-SPCL-OFFER-TYPE-CD                            
                  ,:S-RS1-RENEWAL-OFFER-CD                              
                  ,:S-RS1-RENEW-PUB-OFFER-CD                            
                  ,:S-RS1-OFF-VRSN-NO                                   
                  ,:S-RS1-OFF-VSTART-TS                                 
                  ,:S-RS1-OFF-VEND-TS                                   
                  ,:S-RS1-PROC-STATUS-CD                                
                  ,:S-RS1-PROC-REQ-ID                                   
                  ,:S-RS1-TEMPLATE-OFFER                                
                  ,:S-RS1-SET-PROMO-FLGS                                
                  ,:S-RS1-UNDFLT-OFF-TIER-FLAG                          
PRJ473            ,:S-RS1-TEMPLATE-INT-DESC                             
PRJ473            ,:S-RS1-TEMPLATE-REN-OFFR                             
PRJ473            ,:S-RS1-TEMPLATE-EXT-DESC                             
PRJ680            ,:S-RS1-MAX-PRICE-OFFER-CD                            
P00863            ,:S-RS1-RTCHG-PUB-OFFER-CD                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04426_R1                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OFFER_DESC_INT                                               
MFA-TR*           ,OFFER_DESC_EXT                                               
MFA-TR*           ,PROMO_CD_INT_FL                                              
MFA-TR*           ,PROMO_CD_EXT_FL                                              
MFA-TR*           ,OFFER_START_DT                                               
MFA-TR*           ,OFFER_END_DT                                                 
MFA-TR*           ,DISP_START_INT_TS                                            
MFA-TR*           ,DISP_END_INT_TS                                              
MFA-TR*           ,DISP_START_EXT_TS                                            
MFA-TR*           ,DISP_END_EXT_TS                                              
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,OFFER_DESC_INT_LNG                                           
MFA-TR*           ,OFFER_DESC_EXT_LNG                                           
MFA-TR*           ,SPCL_OFFER_TYPE_CD                                           
MFA-TR*           ,RENEWAL_OFFER_CD                                             
MFA-TR*           ,RENEW_PUB_OFFER_CD                                           
MFA-TR*           ,OFF_VRSN_NO                                                  
MFA-TR*           ,OFF_VSTART_TS                                                
MFA-TR*           ,OFF_VEND_TS                                                  
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,TEMPLATE_OFFER                                               
MFA-TR*           ,SET_PROMO_FLGS                                               
MFA-TR*           ,UNDFLT_OFF_TIER_FLAG                                         
MFA-TR*           ,TEMPLATE_INT_DESC                                            
MFA-TR*           ,TEMPLATE_REN_OFFR                                            
MFA-TR*           ,TEMPLATE_EXT_DESC                                            
MFA-TR*           ,MAX_PRICE_OFFER_CD                                           
MFA-TR*           ,RTCHG_PUB_OFFER_CD                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-1                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-1                                        
MFA-TR*           ,:S-RS1-TABLE-ID                                              
MFA-TR*           ,:S-RS1-COMPANY-NO                                            
MFA-TR*           ,:S-RS1-OFFER-CD                                              
MFA-TR*           ,:S-RS1-OFFER-DESC-INT                                        
MFA-TR*           ,:S-RS1-OFFER-DESC-EXT                                        
MFA-TR*           ,:S-RS1-PROMO-CD-INT-FL                                       
MFA-TR*           ,:S-RS1-PROMO-CD-EXT-FL                                       
MFA-TR*           ,:S-RS1-OFFER-START-DT                                        
MFA-TR*           ,:S-RS1-OFFER-END-DT                                          
MFA-TR*           ,:S-RS1-DISP-START-INT-TS                                     
MFA-TR*           ,:S-RS1-DISP-END-INT-TS                                       
MFA-TR*           ,:S-RS1-DISP-START-EXT-TS                                     
MFA-TR*           ,:S-RS1-DISP-END-EXT-TS                                       
MFA-TR*           ,:S-RS1-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS1-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS1-OFFER-DESC-INT-LNG                                    
MFA-TR*           ,:S-RS1-OFFER-DESC-EXT-LNG                                    
MFA-TR*           ,:S-RS1-SPCL-OFFER-TYPE-CD                                    
MFA-TR*           ,:S-RS1-RENEWAL-OFFER-CD                                      
MFA-TR*           ,:S-RS1-RENEW-PUB-OFFER-CD                                    
MFA-TR*           ,:S-RS1-OFF-VRSN-NO                                           
MFA-TR*           ,:S-RS1-OFF-VSTART-TS                                         
MFA-TR*           ,:S-RS1-OFF-VEND-TS                                           
MFA-TR*           ,:S-RS1-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS1-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS1-TEMPLATE-OFFER                                        
MFA-TR*           ,:S-RS1-SET-PROMO-FLGS                                        
MFA-TR*           ,:S-RS1-UNDFLT-OFF-TIER-FLAG                                  
MFA-TR*           ,:S-RS1-TEMPLATE-INT-DESC                                     
MFA-TR*           ,:S-RS1-TEMPLATE-REN-OFFR                                     
MFA-TR*           ,:S-RS1-TEMPLATE-EXT-DESC                                     
MFA-TR*           ,:S-RS1-MAX-PRICE-OFFER-CD                                    
MFA-TR*           ,:S-RS1-RTCHG-PUB-OFFER-CD                                    
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R1 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS1               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8010'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R1            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04426_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8010-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8020-INSERT-GTT-R2.  OPTION CODE TABLE                         *        
      ******************************************************************        
       8020-INSERT-GTT-R2.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04426_R2                           
                 (                                                      
                     RETURN_CODE                                        
                    ,APPL_RETURN_CODE                                   
                    ,TABLE_ID                                           
                    ,COMPANY_NO                                         
                    ,OPTION_CD                                          
                    ,CODE_UTIL_TYPE                                     
                    ,RATE_PLAN_NO                                       
                    ,OPTION_START_DT                                    
                    ,OPTION_END_DT                                      
                    ,OPT_DESC_INT                                       
                    ,OPT_DESC_INT_LONG                                  
                    ,CURR_EXT_DESC_LONG                                 
                    ,RENEWAL_DESC_LONG                                  
                    ,WEB_DESC_LONG                                      
                    ,STATUS_CD                                          
                    ,LAST_UPDATE_USERID                                 
                    ,LAST_UPDATE_TS                                     
                    ,OPT_CALC_TYPE_CD                                   
                    ,WEB_MKT_DESC_LONG                                  
                    ,OPT_VRSN_NO                                        
                    ,OPT_VSTART_TS                                      
                    ,OPT_VEND_TS                                        
                    ,PROC_STATUS_CD                                     
                    ,PROC_REQ_ID                                        
A04805              ,OPTION_TYPE_DESC                                   
PRJ892              ,AUTO_RENEWAL_FL                                    
PRJ892              ,OPTION_PROMO_DESC                                  
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-2                                     
                  ,:S-APPL-RETURN-CODE-2                                
                  ,:S-RS2-TABLE-ID                                      
                  ,:S-RS2-COMPANY-NO                                    
                  ,:S-RS2-OPTION-CD                                     
                  ,:S-RS2-CODE-UTIL-TYPE                                
                  ,:S-RS2-RATE-PLAN-NO                                  
                  ,:S-RS2-OPTION-START-DT                               
                  ,:S-RS2-OPTION-END-DT                                 
                  ,:S-RS2-OPT-DESC-INT                                  
                  ,:S-RS2-OPT-DESC-INT-LONG                             
                  ,:S-RS2-CURR-EXT-DESC-LONG                            
                  ,:S-RS2-RENEWAL-DESC-LONG                             
                  ,:S-RS2-WEB-DESC-LONG                                 
                  ,:S-RS2-STATUS-CD                                     
                  ,:S-RS2-LAST-UPDATE-USERID                            
                  ,:S-RS2-LAST-UPDATE-TS                                
                  ,:S-RS2-OPT-CALC-TYPE-CD                              
                  ,:S-RS2-WEB-MKT-DESC-LONG                             
                  ,:S-RS2-OPT-VRSN-NO                                   
                  ,:S-RS2-OPT-VSTART-TS                                 
                  ,:S-RS2-OPT-VEND-TS                                   
                  ,:S-RS2-PROC-STATUS-CD                                
                  ,:S-RS2-PROC-REQ-ID                                   
A04805            ,:S-RS2-OPTION-TYPE-DESC                              
PRJ892            ,:S-RS2-AUTO-RENEWAL-FL                               
PRJ892            ,:S-RS2-OPTION-PROMO-DESC                             
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04426_R2                                   
MFA-TR*          (                                                              
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,APPL_RETURN_CODE                                           
MFA-TR*             ,TABLE_ID                                                   
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*             ,OPTION_CD                                                  
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,OPTION_START_DT                                            
MFA-TR*             ,OPTION_END_DT                                              
MFA-TR*             ,OPT_DESC_INT                                               
MFA-TR*             ,OPT_DESC_INT_LONG                                          
MFA-TR*             ,CURR_EXT_DESC_LONG                                         
MFA-TR*             ,RENEWAL_DESC_LONG                                          
MFA-TR*             ,WEB_DESC_LONG                                              
MFA-TR*             ,STATUS_CD                                                  
MFA-TR*             ,LAST_UPDATE_USERID                                         
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,OPT_CALC_TYPE_CD                                           
MFA-TR*             ,WEB_MKT_DESC_LONG                                          
MFA-TR*             ,OPT_VRSN_NO                                                
MFA-TR*             ,OPT_VSTART_TS                                              
MFA-TR*             ,OPT_VEND_TS                                                
MFA-TR*             ,PROC_STATUS_CD                                             
MFA-TR*             ,PROC_REQ_ID                                                
MFA-TR*             ,OPTION_TYPE_DESC                                           
MFA-TR*             ,AUTO_RENEWAL_FL                                            
MFA-TR*             ,OPTION_PROMO_DESC                                          
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-2                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-2                                        
MFA-TR*           ,:S-RS2-TABLE-ID                                              
MFA-TR*           ,:S-RS2-COMPANY-NO                                            
MFA-TR*           ,:S-RS2-OPTION-CD                                             
MFA-TR*           ,:S-RS2-CODE-UTIL-TYPE                                        
MFA-TR*           ,:S-RS2-RATE-PLAN-NO                                          
MFA-TR*           ,:S-RS2-OPTION-START-DT                                       
MFA-TR*           ,:S-RS2-OPTION-END-DT                                         
MFA-TR*           ,:S-RS2-OPT-DESC-INT                                          
MFA-TR*           ,:S-RS2-OPT-DESC-INT-LONG                                     
MFA-TR*           ,:S-RS2-CURR-EXT-DESC-LONG                                    
MFA-TR*           ,:S-RS2-RENEWAL-DESC-LONG                                     
MFA-TR*           ,:S-RS2-WEB-DESC-LONG                                         
MFA-TR*           ,:S-RS2-STATUS-CD                                             
MFA-TR*           ,:S-RS2-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS2-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS2-OPT-CALC-TYPE-CD                                      
MFA-TR*           ,:S-RS2-WEB-MKT-DESC-LONG                                     
MFA-TR*           ,:S-RS2-OPT-VRSN-NO                                           
MFA-TR*           ,:S-RS2-OPT-VSTART-TS                                         
MFA-TR*           ,:S-RS2-OPT-VEND-TS                                           
MFA-TR*           ,:S-RS2-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS2-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS2-OPTION-TYPE-DESC                                      
MFA-TR*           ,:S-RS2-AUTO-RENEWAL-FL                                       
MFA-TR*           ,:S-RS2-OPTION-PROMO-DESC                                     
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R2 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS2               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8020'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R2            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04426_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8020-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8030-INSERT-GTT-R3. ATTIBUTE / INCENTIVE TABLE                 *        
      ******************************************************************        
       8030-INSERT-GTT-R3.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04426_R3                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TABLE_ID                                             
                  ,COMPANY_NO                                           
                  ,OPTION_CD                                            
                  ,ATTR_INCTV_SEQ_NO                                    
                  ,RT_ATTR_INCTV_TYPE                                   
                  ,PRIMRY_OPT_ATTR_FL                                   
                  ,FACTOR_ID                                            
                  ,DURATION_NO                                          
                  ,APPL_PROGRAM_ID                                      
                  ,ATTR_INCTV_VALUE                                     
                  ,ATTR_INCTV_VAL_TX                                    
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,GL_ACCT_CREDIT                                       
                  ,GL_ACCT_DEBIT                                        
                  ,CATEGORY_ID                                          
                  ,WQ_ROUTE_CATEGORY                                    
                  ,OPT_CHG_ACTION_CD                                    
                  ,ATTR_INCTV_STRT_DT                                   
                  ,ATTR_INCTV_END_DT                                    
                  ,OPT_ATTR_VRSN_NO                                     
                  ,OPT_ATTR_VSTART_TS                                   
                  ,OPT_ATTR_VEND_TS                                     
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-3                                     
                  ,:S-APPL-RETURN-CODE-3                                
                  ,:S-RS3-TABLE-ID                                      
                  ,:S-RS3-COMPANY-NO                                    
                  ,:S-RS3-OPTION-CD                                     
                  ,:S-RS3-ATTR-INCTV-SEQ-NO                             
                  ,:S-RS3-RT-ATTR-INCTV-TYPE                            
                  ,:S-RS3-PRIMRY-OPT-ATTR-FL                            
                  ,:S-RS3-FACTOR-ID                                     
                  ,:S-RS3-DURATION-NO                                   
                  ,:S-RS3-APPL-PROGRAM-ID                               
                  ,:S-RS3-ATTR-INCTV-VALUE                              
                  ,:S-RS3-ATTR-INCTV-VAL-TX                             
                  ,:S-RS3-LAST-UPDATE-USERID                            
                  ,:S-RS3-LAST-UPDATE-TS                                
                  ,:S-RS3-GL-ACCT-CREDIT                                
                  ,:S-RS3-GL-ACCT-DEBIT                                 
                  ,:S-RS3-CATEGORY-ID                                   
                  ,:S-RS3-WQ-ROUTE-CATEGORY                             
                  ,:S-RS3-OPT-CHG-ACTION-CD                             
                  ,:S-RS3-ATTR-INCTV-STRT-DT                            
                  ,:S-RS3-ATTR-INCTV-END-DT                             
                  ,:S-RS3-OPT-ATTR-VRSN-NO                              
                  ,:S-RS3-OPT-ATTR-VSTART-TS                            
                  ,:S-RS3-OPT-ATTR-VEND-TS                              
                  ,:S-RS3-PROC-STATUS-CD                                
                  ,:S-RS3-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04426_R3                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,ATTR_INCTV_SEQ_NO                                            
MFA-TR*           ,RT_ATTR_INCTV_TYPE                                           
MFA-TR*           ,PRIMRY_OPT_ATTR_FL                                           
MFA-TR*           ,FACTOR_ID                                                    
MFA-TR*           ,DURATION_NO                                                  
MFA-TR*           ,APPL_PROGRAM_ID                                              
MFA-TR*           ,ATTR_INCTV_VALUE                                             
MFA-TR*           ,ATTR_INCTV_VAL_TX                                            
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,GL_ACCT_CREDIT                                               
MFA-TR*           ,GL_ACCT_DEBIT                                                
MFA-TR*           ,CATEGORY_ID                                                  
MFA-TR*           ,WQ_ROUTE_CATEGORY                                            
MFA-TR*           ,OPT_CHG_ACTION_CD                                            
MFA-TR*           ,ATTR_INCTV_STRT_DT                                           
MFA-TR*           ,ATTR_INCTV_END_DT                                            
MFA-TR*           ,OPT_ATTR_VRSN_NO                                             
MFA-TR*           ,OPT_ATTR_VSTART_TS                                           
MFA-TR*           ,OPT_ATTR_VEND_TS                                             
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-3                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-3                                        
MFA-TR*           ,:S-RS3-TABLE-ID                                              
MFA-TR*           ,:S-RS3-COMPANY-NO                                            
MFA-TR*           ,:S-RS3-OPTION-CD                                             
MFA-TR*           ,:S-RS3-ATTR-INCTV-SEQ-NO                                     
MFA-TR*           ,:S-RS3-RT-ATTR-INCTV-TYPE                                    
MFA-TR*           ,:S-RS3-PRIMRY-OPT-ATTR-FL                                    
MFA-TR*           ,:S-RS3-FACTOR-ID                                             
MFA-TR*           ,:S-RS3-DURATION-NO                                           
MFA-TR*           ,:S-RS3-APPL-PROGRAM-ID                                       
MFA-TR*           ,:S-RS3-ATTR-INCTV-VALUE                                      
MFA-TR*           ,:S-RS3-ATTR-INCTV-VAL-TX                                     
MFA-TR*           ,:S-RS3-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS3-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS3-GL-ACCT-CREDIT                                        
MFA-TR*           ,:S-RS3-GL-ACCT-DEBIT                                         
MFA-TR*           ,:S-RS3-CATEGORY-ID                                           
MFA-TR*           ,:S-RS3-WQ-ROUTE-CATEGORY                                     
MFA-TR*           ,:S-RS3-OPT-CHG-ACTION-CD                                     
MFA-TR*           ,:S-RS3-ATTR-INCTV-STRT-DT                                    
MFA-TR*           ,:S-RS3-ATTR-INCTV-END-DT                                     
MFA-TR*           ,:S-RS3-OPT-ATTR-VRSN-NO                                      
MFA-TR*           ,:S-RS3-OPT-ATTR-VSTART-TS                                    
MFA-TR*           ,:S-RS3-OPT-ATTR-VEND-TS                                      
MFA-TR*           ,:S-RS3-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS3-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R3 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS3               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8030'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R3            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04426_R3'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8030-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8040-INSERT-GTT-R4. SECURED OFFER / OPTION                     *        
      ******************************************************************        
       8040-INSERT-GTT-R4.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04426_R4                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TABLE_ID                                             
                  ,COMPANY_NO                                           
                  ,OPTION_CD                                            
                  ,OFFER_CD                                             
                  ,CATEGORY_ID                                          
                  ,ACCESS_START_DT                                      
                  ,ACCESS_END_DT                                        
                  ,VIEW_APPLY_CD                                        
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,COMMENTS_TX                                          
                  ,ACCESS_VRSN_NO                                       
                  ,ACCESS_VSTART_TS                                     
                  ,ACCESS_VEND_TS                                       
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-4                                     
                  ,:S-APPL-RETURN-CODE-4                                
                  ,:S-RS4-TABLE-ID                                      
                  ,:S-RS4-COMPANY-NO                                    
                  ,:S-RS4-OPTION-CD                                     
                  ,:S-RS4-OFFER-CD                                      
                  ,:S-RS4-CATEGORY-ID                                   
                  ,:S-RS4-ACCESS-START-DT                               
                  ,:S-RS4-ACCESS-END-DT                                 
                  ,:S-RS4-VIEW-APPLY-CD                                 
                  ,:S-RS4-LAST-UPDATE-USERID                            
                  ,:S-RS4-LAST-UPDATE-TS                                
                  ,:S-RS4-COMMENTS-TX                                   
                  ,:S-RS4-ACCESS-VRSN-NO                                
                  ,:S-RS4-ACCESS-VSTART-TS                              
                  ,:S-RS4-ACCESS-VEND-TS                                
                  ,:S-RS4-PROC-STATUS-CD                                
                  ,:S-RS4-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04426_R4                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,CATEGORY_ID                                                  
MFA-TR*           ,ACCESS_START_DT                                              
MFA-TR*           ,ACCESS_END_DT                                                
MFA-TR*           ,VIEW_APPLY_CD                                                
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,COMMENTS_TX                                                  
MFA-TR*           ,ACCESS_VRSN_NO                                               
MFA-TR*           ,ACCESS_VSTART_TS                                             
MFA-TR*           ,ACCESS_VEND_TS                                               
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-4                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-4                                        
MFA-TR*           ,:S-RS4-TABLE-ID                                              
MFA-TR*           ,:S-RS4-COMPANY-NO                                            
MFA-TR*           ,:S-RS4-OPTION-CD                                             
MFA-TR*           ,:S-RS4-OFFER-CD                                              
MFA-TR*           ,:S-RS4-CATEGORY-ID                                           
MFA-TR*           ,:S-RS4-ACCESS-START-DT                                       
MFA-TR*           ,:S-RS4-ACCESS-END-DT                                         
MFA-TR*           ,:S-RS4-VIEW-APPLY-CD                                         
MFA-TR*           ,:S-RS4-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS4-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS4-COMMENTS-TX                                           
MFA-TR*           ,:S-RS4-ACCESS-VRSN-NO                                        
MFA-TR*           ,:S-RS4-ACCESS-VSTART-TS                                      
MFA-TR*           ,:S-RS4-ACCESS-VEND-TS                                        
MFA-TR*           ,:S-RS4-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS4-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R4 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS4               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8040'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R4            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04426_R4'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8040-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8050-INSERT-GTT-R5.                                            *        
      ******************************************************************        
       8050-INSERT-GTT-R5.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04426_R5                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TABLE_ID                                             
                  ,COMPANY_NO                                           
                  ,PROMO_CD                                             
                  ,PROMO_DESC                                           
                  ,OFFER_CD                                             
                  ,MKT_PLAN_CD                                          
                  ,PROMO_START_DT                                       
                  ,PROMO_START_TM                                       
                  ,PROMO_END_DT                                         
                  ,PROMO_END_TM                                         
                  ,AD_CHANNEL_CD                                        
                  ,PROMO_DESC_LONG                                      
                  ,EXT_LANDING_PG_URL                                   
                  ,PROMO_TYPE_CD                                        
                  ,WEB_IMAGE_FILE_NM                                    
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,REPLACMNT_PROMO_CD                                   
                  ,DISPLAY_END_DT                                       
                  ,INT_LANDING_PG_URL                                   
                  ,PROMO_VRSN_NO                                        
                  ,PROMO_VSTART_TS                                      
                  ,PROMO_VEND_TS                                        
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                  ,PROMO_REUSED_FLAG                                    
PRJ473            ,ORIG_PROMO_OFFER                                     
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-5                                     
                  ,:S-APPL-RETURN-CODE-5                                
                  ,:S-RS5-TABLE-ID                                      
                  ,:S-RS5-COMPANY-NO                                    
                  ,:S-RS5-PROMO-CD                                      
                  ,:S-RS5-PROMO-DESC                                    
                  ,:S-RS5-OFFER-CD                                      
                  ,:S-RS5-MKT-PLAN-CD                                   
                  ,:S-RS5-PROMO-START-DT                                
                  ,:S-RS5-PROMO-START-TM                                
                  ,:S-RS5-PROMO-END-DT                                  
                  ,:S-RS5-PROMO-END-TM                                  
                  ,:S-RS5-AD-CHANNEL-CD                                 
                  ,:S-RS5-PROMO-DESC-LONG                               
                  ,:S-RS5-EXT-LANDING-PG-URL                            
                  ,:S-RS5-PROMO-TYPE-CD                                 
                  ,:S-RS5-WEB-IMAGE-FILE-NM                             
                  ,:S-RS5-LAST-UPDATE-USERID                            
                  ,:S-RS5-LAST-UPDATE-TS                                
                  ,:S-RS5-REPLACMNT-PROMO-CD                            
                  ,:S-RS5-DISPLAY-END-DT                                
                  ,:S-RS5-INT-LANDING-PG-URL                            
                  ,:S-RS5-PROMO-VRSN-NO                                 
                  ,:S-RS5-PROMO-VSTART-TS                               
                  ,:S-RS5-PROMO-VEND-TS                                 
                  ,:S-RS5-PROC-STATUS-CD                                
                  ,:S-RS5-PROC-REQ-ID                                   
                  ,:S-RS5-PROMO-REUSED-FLAG                             
PRJ473            ,:S-RS5-ORIG-PROMO-OFFER                              
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04426_R5                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,PROMO_CD                                                     
MFA-TR*           ,PROMO_DESC                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,MKT_PLAN_CD                                                  
MFA-TR*           ,PROMO_START_DT                                               
MFA-TR*           ,PROMO_START_TM                                               
MFA-TR*           ,PROMO_END_DT                                                 
MFA-TR*           ,PROMO_END_TM                                                 
MFA-TR*           ,AD_CHANNEL_CD                                                
MFA-TR*           ,PROMO_DESC_LONG                                              
MFA-TR*           ,EXT_LANDING_PG_URL                                           
MFA-TR*           ,PROMO_TYPE_CD                                                
MFA-TR*           ,WEB_IMAGE_FILE_NM                                            
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,REPLACMNT_PROMO_CD                                           
MFA-TR*           ,DISPLAY_END_DT                                               
MFA-TR*           ,INT_LANDING_PG_URL                                           
MFA-TR*           ,PROMO_VRSN_NO                                                
MFA-TR*           ,PROMO_VSTART_TS                                              
MFA-TR*           ,PROMO_VEND_TS                                                
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,PROMO_REUSED_FLAG                                            
MFA-TR*           ,ORIG_PROMO_OFFER                                             
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-5                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-5                                        
MFA-TR*           ,:S-RS5-TABLE-ID                                              
MFA-TR*           ,:S-RS5-COMPANY-NO                                            
MFA-TR*           ,:S-RS5-PROMO-CD                                              
MFA-TR*           ,:S-RS5-PROMO-DESC                                            
MFA-TR*           ,:S-RS5-OFFER-CD                                              
MFA-TR*           ,:S-RS5-MKT-PLAN-CD                                           
MFA-TR*           ,:S-RS5-PROMO-START-DT                                        
MFA-TR*           ,:S-RS5-PROMO-START-TM                                        
MFA-TR*           ,:S-RS5-PROMO-END-DT                                          
MFA-TR*           ,:S-RS5-PROMO-END-TM                                          
MFA-TR*           ,:S-RS5-AD-CHANNEL-CD                                         
MFA-TR*           ,:S-RS5-PROMO-DESC-LONG                                       
MFA-TR*           ,:S-RS5-EXT-LANDING-PG-URL                                    
MFA-TR*           ,:S-RS5-PROMO-TYPE-CD                                         
MFA-TR*           ,:S-RS5-WEB-IMAGE-FILE-NM                                     
MFA-TR*           ,:S-RS5-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS5-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS5-REPLACMNT-PROMO-CD                                    
MFA-TR*           ,:S-RS5-DISPLAY-END-DT                                        
MFA-TR*           ,:S-RS5-INT-LANDING-PG-URL                                    
MFA-TR*           ,:S-RS5-PROMO-VRSN-NO                                         
MFA-TR*           ,:S-RS5-PROMO-VSTART-TS                                       
MFA-TR*           ,:S-RS5-PROMO-VEND-TS                                         
MFA-TR*           ,:S-RS5-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS5-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS5-PROMO-REUSED-FLAG                                     
MFA-TR*           ,:S-RS5-ORIG-PROMO-OFFER                                      
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R5 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS5               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8050'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R5            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04426_R5'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
        8050-EXIT.                                                      
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8060-INSERT-GTT-R6.                                            *        
      ******************************************************************        
       8060-INSERT-GTT-R6.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04426_R6                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TABLE_ID                                             
                  ,COMPANY_NO                                           
                  ,OFFER_CD                                             
                  ,TIER_CUST_STAT_CD                                    
                  ,TIER_ACCT_TYPE_CD                                    
                  ,MKT_TIER_RANKING                                     
                  ,MKT_TIER_START_DT                                    
                  ,OFFER_TIER_STRT_DT                                   
                  ,MKT_TIER_APPLY_CD                                    
                  ,TIER_DEFLT_OFFR_CD                                   
                  ,OFFER_TIER_END_DT                                    
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,OFF_TIER_VRSN_NO                                     
                  ,OFF_TIER_VSTART_TS                                   
                  ,OFF_TIER_VEND_TS                                     
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-6                                     
                  ,:S-APPL-RETURN-CODE-6                                
                  ,:S-RS6-TABLE-ID                                      
                  ,:S-RS6-COMPANY-NO                                    
                  ,:S-RS6-OFFER-CD                                      
                  ,:S-RS6-TIER-CUST-STAT-CD                             
                  ,:S-RS6-TIER-ACCT-TYPE-CD                             
                  ,:S-RS6-MKT-TIER-RANKING                              
                  ,:S-RS6-MKT-TIER-START-DT                             
                  ,:S-RS6-OFFER-TIER-STRT-DT                            
                  ,:S-RS6-MKT-TIER-APPLY-CD                             
                  ,:S-RS6-TIER-DEFLT-OFFR-CD                            
                  ,:S-RS6-OFFER-TIER-END-DT                             
                  ,:S-RS6-LAST-UPDATE-USERID                            
                  ,:S-RS6-LAST-UPDATE-TS                                
                  ,:S-RS6-OFF-TIER-VRSN-NO                              
                  ,:S-RS6-OFF-TIER-VSTART-TS                            
                  ,:S-RS6-OFF-TIER-VEND-TS                              
                  ,:S-RS6-PROC-STATUS-CD                                
                  ,:S-RS6-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04426_R6                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,TIER_CUST_STAT_CD                                            
MFA-TR*           ,TIER_ACCT_TYPE_CD                                            
MFA-TR*           ,MKT_TIER_RANKING                                             
MFA-TR*           ,MKT_TIER_START_DT                                            
MFA-TR*           ,OFFER_TIER_STRT_DT                                           
MFA-TR*           ,MKT_TIER_APPLY_CD                                            
MFA-TR*           ,TIER_DEFLT_OFFR_CD                                           
MFA-TR*           ,OFFER_TIER_END_DT                                            
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,OFF_TIER_VRSN_NO                                             
MFA-TR*           ,OFF_TIER_VSTART_TS                                           
MFA-TR*           ,OFF_TIER_VEND_TS                                             
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-6                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-6                                        
MFA-TR*           ,:S-RS6-TABLE-ID                                              
MFA-TR*           ,:S-RS6-COMPANY-NO                                            
MFA-TR*           ,:S-RS6-OFFER-CD                                              
MFA-TR*           ,:S-RS6-TIER-CUST-STAT-CD                                     
MFA-TR*           ,:S-RS6-TIER-ACCT-TYPE-CD                                     
MFA-TR*           ,:S-RS6-MKT-TIER-RANKING                                      
MFA-TR*           ,:S-RS6-MKT-TIER-START-DT                                     
MFA-TR*           ,:S-RS6-OFFER-TIER-STRT-DT                                    
MFA-TR*           ,:S-RS6-MKT-TIER-APPLY-CD                                     
MFA-TR*           ,:S-RS6-TIER-DEFLT-OFFR-CD                                    
MFA-TR*           ,:S-RS6-OFFER-TIER-END-DT                                     
MFA-TR*           ,:S-RS6-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS6-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS6-OFF-TIER-VRSN-NO                                      
MFA-TR*           ,:S-RS6-OFF-TIER-VSTART-TS                                    
MFA-TR*           ,:S-RS6-OFF-TIER-VEND-TS                                      
MFA-TR*           ,:S-RS6-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS6-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R6 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS6               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8050'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R6            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04426_R6'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8070-INSERT-GTT-R7.                                            *        
      ******************************************************************        
       8070-INSERT-GTT-R7.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04426_R7                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TABLE_ID                                             
                  ,COMPANY_NO                                           
                  ,RATE_GROUP_TYPE_CD                                   
                  ,RATE_GROUP_CD                                        
                  ,SORT_SEQ_NO                                          
                  ,EFF_START_DT                                         
                  ,EFF_END_DT                                           
                  ,OFFER_CD                                             
                  ,OPTION_CD                                            
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,GRP_OFF_VRSN_NO                                      
                  ,GRP_OFF_VSTART_TS                                    
                  ,GRP_OFF_VEND_TS                                      
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-7                                     
                  ,:S-APPL-RETURN-CODE-7                                
                  ,:S-RS7-TABLE-ID                                      
                  ,:S-RS7-COMPANY-NO                                    
                  ,:S-RS7-RATE-GROUP-TYPE-CD                            
                  ,:S-RS7-RATE-GROUP-CD                                 
                  ,:S-RS7-SORT-SEQ-NO                                   
                  ,:S-RS7-EFF-START-DT                                  
                  ,:S-RS7-EFF-END-DT                                    
                  ,:S-RS7-OFFER-CD                                      
                  ,:S-RS7-OPTION-CD                                     
                  ,:S-RS7-LAST-UPDATE-USERID                            
                  ,:S-RS7-LAST-UPDATE-TS                                
                  ,:S-RS7-GRP-OFF-VRSN-NO                               
                  ,:S-RS7-GRP-OFF-VSTART-TS                             
                  ,:S-RS7-GRP-OFF-VEND-TS                               
                  ,:S-RS7-PROC-STATUS-CD                                
                  ,:S-RS7-PROC-REQ-ID                                   
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04426_R7                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,RATE_GROUP_TYPE_CD                                           
MFA-TR*           ,RATE_GROUP_CD                                                
MFA-TR*           ,SORT_SEQ_NO                                                  
MFA-TR*           ,EFF_START_DT                                                 
MFA-TR*           ,EFF_END_DT                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,GRP_OFF_VRSN_NO                                              
MFA-TR*           ,GRP_OFF_VSTART_TS                                            
MFA-TR*           ,GRP_OFF_VEND_TS                                              
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-7                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-7                                        
MFA-TR*           ,:S-RS7-TABLE-ID                                              
MFA-TR*           ,:S-RS7-COMPANY-NO                                            
MFA-TR*           ,:S-RS7-RATE-GROUP-TYPE-CD                                    
MFA-TR*           ,:S-RS7-RATE-GROUP-CD                                         
MFA-TR*           ,:S-RS7-SORT-SEQ-NO                                           
MFA-TR*           ,:S-RS7-EFF-START-DT                                          
MFA-TR*           ,:S-RS7-EFF-END-DT                                            
MFA-TR*           ,:S-RS7-OFFER-CD                                              
MFA-TR*           ,:S-RS7-OPTION-CD                                             
MFA-TR*           ,:S-RS7-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS7-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS7-GRP-OFF-VRSN-NO                                       
MFA-TR*           ,:S-RS7-GRP-OFF-VSTART-TS                                     
MFA-TR*           ,:S-RS7-GRP-OFF-VEND-TS                                       
MFA-TR*           ,:S-RS7-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS7-PROC-REQ-ID                                           
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-7.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R7 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS7               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8070'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R7            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04426_R7'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8080-INSERT-GTT-R8.                                            *        
      ******************************************************************        
       8080-INSERT-GTT-R8.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04426_R8                           
                 (                                                      
                   RETURN_CODE                                          
                  ,APPL_RETURN_CODE                                     
                  ,TABLE_ID                                             
                  ,COMPANY_NO                                           
                  ,OFFER_CD                                             
                  ,OPTION_CD                                            
                  ,OPTION_SORT_SEQ_NO                                   
                  ,LAST_UPDATE_USERID                                   
                  ,LAST_UPDATE_TS                                       
                  ,OFFER_OPT_START_DT                                   
                  ,OFFER_OPT_END_DT                                     
                  ,OFF_OPT_VRSN_NO                                      
                  ,OFF_OPT_VSTART_TS                                    
                  ,OFF_OPT_VEND_TS                                      
                  ,PROC_STATUS_CD                                       
                  ,PROC_REQ_ID                                          
A04805            ,WEB_NEW_EXISTS_CD                                    
A04805            ,WEB_SIGN_UP_FL                                       
A04805            ,OFF_OPT_EXCLUDE_CD                                   
                 )                                                      
              VALUES                                                    
                 (                                                      
                   :S-RETURN-CODE-8                                     
                  ,:S-APPL-RETURN-CODE-8                                
                  ,:S-RS8-TABLE-ID                                      
                  ,:S-RS8-COMPANY-NO                                    
                  ,:S-RS8-OFFER-CD                                      
                  ,:S-RS8-OPTION-CD                                     
                  ,:S-RS8-OPTION-SORT-SEQ-NO                            
                  ,:S-RS8-LAST-UPDATE-USERID                            
                  ,:S-RS8-LAST-UPDATE-TS                                
                  ,:S-RS8-OFFER-OPT-START-DT                            
                  ,:S-RS8-OFFER-OPT-END-DT                              
                  ,:S-RS8-OFF-OPT-VRSN-NO                               
                  ,:S-RS8-OFF-OPT-VSTART-TS                             
                  ,:S-RS8-OFF-OPT-VEND-TS                               
                  ,:S-RS8-PROC-STATUS-CD                                
                  ,:S-RS8-PROC-REQ-ID                                   
A04805            ,:S-RS8-WEB-NEW-EXISTS-CD                             
A04805            ,:S-RS8-WEB-SIGN-UP-FL                                
A04805            ,:S-RS8-OFF-OPT-EXCLUDE-CD                            
                 )                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04426_R8                                   
MFA-TR*          (                                                              
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,APPL_RETURN_CODE                                             
MFA-TR*           ,TABLE_ID                                                     
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,OFFER_CD                                                     
MFA-TR*           ,OPTION_CD                                                    
MFA-TR*           ,OPTION_SORT_SEQ_NO                                           
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,OFFER_OPT_START_DT                                           
MFA-TR*           ,OFFER_OPT_END_DT                                             
MFA-TR*           ,OFF_OPT_VRSN_NO                                              
MFA-TR*           ,OFF_OPT_VSTART_TS                                            
MFA-TR*           ,OFF_OPT_VEND_TS                                              
MFA-TR*           ,PROC_STATUS_CD                                               
MFA-TR*           ,PROC_REQ_ID                                                  
MFA-TR*           ,WEB_NEW_EXISTS_CD                                            
MFA-TR*           ,WEB_SIGN_UP_FL                                               
MFA-TR*           ,OFF_OPT_EXCLUDE_CD                                           
MFA-TR*          )                                                              
MFA-TR*       VALUES                                                            
MFA-TR*          (                                                              
MFA-TR*            :S-RETURN-CODE-8                                             
MFA-TR*           ,:S-APPL-RETURN-CODE-8                                        
MFA-TR*           ,:S-RS8-TABLE-ID                                              
MFA-TR*           ,:S-RS8-COMPANY-NO                                            
MFA-TR*           ,:S-RS8-OFFER-CD                                              
MFA-TR*           ,:S-RS8-OPTION-CD                                             
MFA-TR*           ,:S-RS8-OPTION-SORT-SEQ-NO                                    
MFA-TR*           ,:S-RS8-LAST-UPDATE-USERID                                    
MFA-TR*           ,:S-RS8-LAST-UPDATE-TS                                        
MFA-TR*           ,:S-RS8-OFFER-OPT-START-DT                                    
MFA-TR*           ,:S-RS8-OFFER-OPT-END-DT                                      
MFA-TR*           ,:S-RS8-OFF-OPT-VRSN-NO                                       
MFA-TR*           ,:S-RS8-OFF-OPT-VSTART-TS                                     
MFA-TR*           ,:S-RS8-OFF-OPT-VEND-TS                                       
MFA-TR*           ,:S-RS8-PROC-STATUS-CD                                        
MFA-TR*           ,:S-RS8-PROC-REQ-ID                                           
MFA-TR*           ,:S-RS8-WEB-NEW-EXISTS-CD                                     
MFA-TR*           ,:S-RS8-WEB-SIGN-UP-FL                                        
MFA-TR*           ,:S-RS8-OFF-OPT-EXCLUDE-CD                                    
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-8.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
                                      WS-ERR-INSRT-R8 = 'Y'             
              ADD +1                     TO  CTR-ROWS-RS8               
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8080'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE 'Y'                   TO  WS-ERR-INSRT-R8            
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR04426_R8'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8080-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *                                                               *         
      * 8800-CHECK-RESULTS.                                           *         
      *****************************************************************         
       8800-CHECK-RESULTS.                                              
                                                                        
           IF CTR-ROWS-RS1 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-1                            
              MOVE   0                       TO S-RETURN-CODE-1         
              MOVE 100                       TO S-APPL-RETURN-CODE-1    
              PERFORM 8010-INSERT-GTT-R1     THRU 8010-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS2 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-2                            
              MOVE   0                       TO S-RETURN-CODE-2         
              MOVE 100                       TO S-APPL-RETURN-CODE-2    
              PERFORM 8020-INSERT-GTT-R2     THRU 8020-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS3 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-3                            
              MOVE   0                       TO S-RETURN-CODE-3         
              MOVE 100                       TO S-APPL-RETURN-CODE-3    
              PERFORM 8030-INSERT-GTT-R3     THRU 8030-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS4 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-4                            
              MOVE   0                       TO S-RETURN-CODE-4         
              MOVE 100                       TO S-APPL-RETURN-CODE-4    
              PERFORM 8040-INSERT-GTT-R4     THRU 8040-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS5 <= 0                                         
              INITIALIZE GTT-RETURN-FIELDS-5                            
              MOVE   0                       TO S-RETURN-CODE-5         
              MOVE 100                       TO S-APPL-RETURN-CODE-5    
              PERFORM 8050-INSERT-GTT-R5     THRU 8050-EXIT             
           END-IF.                                                      
      *                                                                         
           IF CTR-ROWS-RS6 = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-6                            
              MOVE   0                       TO S-RETURN-CODE-6         
              MOVE 100                       TO S-APPL-RETURN-CODE-6    
              PERFORM 8060-INSERT-GTT-R6     THRU 8060-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS7 = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-7                            
              MOVE   0                       TO S-RETURN-CODE-7         
              MOVE 100                       TO S-APPL-RETURN-CODE-7    
              PERFORM 8070-INSERT-GTT-R7     THRU 8070-EXIT             
           END-IF.                                                      
                                                                        
           IF CTR-ROWS-RS8 = 0                                          
              INITIALIZE GTT-RETURN-FIELDS-8                            
              MOVE   0                       TO S-RETURN-CODE-8         
              MOVE 100                       TO S-APPL-RETURN-CODE-8    
              PERFORM 8080-INSERT-GTT-R8     THRU 8080-EXIT             
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8900-SEND-DONE.                                                *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
           MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
           MOVE '8900'                TO ACTIVE-PARAGRAPH               
           MOVE 'OPEN'                TO ABEND-FUNCTION                 
                                                                        
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-1.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04426_R1'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-2.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04426_R2'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C3                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C3 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-3.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04426_R3'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C4                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C4 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-4.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04426_R4'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C5                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C5 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-5.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04426_R5'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C6                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C6 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-6.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04426_R6'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C7                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C7 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-7.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04426_R7'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               OPEN C8                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C8 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE-8.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE SQLSTATE              TO ABEND-SQLSTATE              
              MOVE 'CSR04426_R8'         TO TABLE-1                     
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       8900-EXIT.                                                       
                                                                        
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE       TO ABEND-SQLCODE            
                                               S-RETURN-CODE-1          
                                               S-RETURN-CODE-2          
                                               S-RETURN-CODE-3          
                                               S-RETURN-CODE-4          
                                               S-RETURN-CODE-5          
                                               S-RETURN-CODE-6          
                                               S-RETURN-CODE-7          
                                               S-RETURN-CODE-8.         
                                                                        
           MOVE WS-APPL-RETURN-CODE         TO S-APPL-RETURN-CODE-1     
                                               S-APPL-RETURN-CODE-2     
                                               S-APPL-RETURN-CODE-3     
                                               S-APPL-RETURN-CODE-4     
                                               S-APPL-RETURN-CODE-5     
                                               S-APPL-RETURN-CODE-6     
                                               S-APPL-RETURN-CODE-7     
                                               S-APPL-RETURN-CODE-8.    
                                                                        
                                                                        
           MOVE SQLERRMC                    TO ABEND-SQLERRMC.          
                                                                        
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'               TO ABEND-FUNCTION           
           END-IF.                                                      
                                                                        
           PERFORM 0100A-DECLARE-GTT-R1        THRU 0100A-EXIT.         
           PERFORM 0100B-DECLARE-GTT-R2        THRU 0100B-EXIT.         
           PERFORM 0100C-DECLARE-GTT-R3        THRU 0100C-EXIT.         
           PERFORM 0100D-DECLARE-GTT-R4        THRU 0100D-EXIT.         
           PERFORM 0100E-DECLARE-GTT-R5        THRU 0100E-EXIT.         
           PERFORM 0100F-DECLARE-GTT-R6        THRU 0100F-EXIT.         
           PERFORM 0100G-DECLARE-GTT-R7        THRU 0100G-EXIT.         
           PERFORM 0100H-DECLARE-GTT-R8        THRU 0100H-EXIT.         
                                                                        
           PERFORM 8010-INSERT-GTT-R1          THRU 8010-EXIT.          
           PERFORM 8020-INSERT-GTT-R2          THRU 8020-EXIT.          
           PERFORM 8030-INSERT-GTT-R3          THRU 8030-EXIT.          
           PERFORM 8040-INSERT-GTT-R4          THRU 8040-EXIT.          
           PERFORM 8050-INSERT-GTT-R5          THRU 8050-EXIT.          
           PERFORM 8060-INSERT-GTT-R6          THRU 8060-EXIT.          
           PERFORM 8070-INSERT-GTT-R7          THRU 8070-EXIT.          
           PERFORM 8080-INSERT-GTT-R8          THRU 8080-EXIT.          
                                                                        
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-ABEND-PROCESSING.                                         *        
      ******************************************************************        
       9700-PROCESS-ABEND.                                              
                                                                        
           PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT.             
           PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT.             
                                                                        
       9700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900-SQL-ERROR-ROUTINE.                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9999-END-PROGRAM.                                              *        
      ******************************************************************        
                                                                        
       9999-END-PROGRAM.                                                
                                                                        
            PERFORM 8800-CHECK-RESULTS THRU 8800-EXIT                   
            PERFORM 8900-SEND-DONE     THRU 8900-EXIT                   
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
