       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR04425.                                            
       AUTHOR. SATISH S.                                                
       INSTALLATION. SCANA.                                             
       DATE-WRITTEN. 08/20/12.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *       THIS PROCEDURE IS USED TO RETRIEVE DATA NEEDED FOR       *        
      *             RATE PRICING VALIDATION CRYSTAL REPORT             *        
      *                                                                *        
      *  TO RETRIEVE RATE PLAN VERSIONS FROM CSS_RATE_CREATOR  TO      *        
      *  POPULATE RATE MANAGEMENT MODULE.                              *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  ----------------                                              *        
      *             SECURED-RATE-FL            CHAR(01)                *        
      *             COMPANY-NO                 CHAR(02)                *        
      *             CODE-UTIL-TYPE             CHAR(01)                *        
      *             RATE-PLAN-NO               CHAR(03)                *        
      *             FROM-EFFECTIVE-DT          CHAR(10)                *        
      *             RATE-DEPT-CD               CHAR(03)                *        
      *                                                                *        
      *  OUTPUT PARAMETERS                                             *        
      *  ------------------                                            *        
      *             RETURN_CODE              INTEGER                   *        
      *             COMPANY_NO               CHAR(02)                  *        
      *             RATE_DEPT_CD             CHAR(03)                  *        
      *             RATE_DEPT_DESC           CHAR(80)                  *        
      *             CODE_UTIL_TYPE           CHAR(01)                  *        
      *             UTIL_TYPE_DESC           CHAR(15)                  *        
      *             RATE_PLAN_NO             CHAR(03)                  *        
      *             RATE_DESC                CHAR(50)                  *        
      *             CMPNT_ID_CD              CHAR(03)                  *        
      *             RATE_CMPNT_DESC          CHAR(60)                  *        
      *             CODE_USE_INST_TYPE       CHAR(01)                  *        
      *             USE_INST_TYPE_DESC       CHAR(15)                  *        
      *             UNIT_CD                  CHAR(02)                  *        
      *             UNIT_DESC                CHAR(15)                  *        
      *             CODE_SEASON              CHAR(01)                  *        
      *             SEASON                   CHAR(15)                  *        
      *             CODE_TIME_PERIOD         SMALLINT                  *        
      *             TIME_PERIOD              CHAR(15)                  *        
      *             BLOCK_NO                 SMALLINT                  *        
      *             BLOCK_SIZE               CHAR(09)                  *        
      *             PRICE_TYPE_CD            CHAR(01)                  *        
      *             PRICE_TYPE_DESC          CHAR(15)                  *        
      *             PRICE_GROUP              CHAR(15)                  *        
      *             PRICE                    DECIMAL(15,6)             *        
      *             SORT_ORDER               SMALLINT                  *        
      *             LAST_ENERGY_BLOCK        SMALLINT                  *        
      *             LAST_DEM_BLOCK           SMALLINT                  *        
      *             RATE_ITEM_CODE           SMALLINT                  *        
      *             UM_EQUIP_KWH             SMALLINT                  *        
      *             VERS_PRORATE             CHAR(50)                  *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  08/20/2012 SS95855   PROJ#00473 PROCEDURE ORIGINALLY CODED.   *        
A04177*  02/05/2013 AW41078   REMOVED DATE_CREATED FROM WHERE CLAUSE OF*        
      *                       RATE_PLAN_VRSN_CUR.                      *        
      *  10/07/2013 AW41078   ADDED RATE VERSION PRORATE TO RESULT SET *        
      *  12/18/2013 AW41078   REMOVED '065'/'066' LOGIC FOR STATELINE  *        
      *                       WHICH PULLS RATE 023 PRICING             *        
ACT189*  06/05/2016 VIJAY     DO NOT PASS FACTOR PRICE FOR LIGHTING    *        
ACT189*  A05460               POLES.                                   *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04425'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
           'WORKING STORAGE FOR CSR04425 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-LITERALS.                                                 
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR04425'.      
           05 WS-YES                   PIC X(01) VALUE 'Y'.             
           05 WS-NO                    PIC X(01) VALUE 'N'.             
           05 WS-METERED               PIC X(01) VALUE 'M'.             
           05 WS-UNMETERED             PIC X(01) VALUE 'U'.             
           05 WS-ELEC                  PIC X(01) VALUE 'E'.             
           05 WS-GAS                   PIC X(01) VALUE 'G'.             
           05 WS-DATE-TO               PIC X(10) VALUE '2999-12-31'.    
           05 GTT-NAME                 PIC X(26) VALUE                  
                                                  'SESSION.CSR04425_R1'.
           05 WS-INVALID-UTIL-TYPE     PIC X(43) VALUE                  
                'INVALID PARAMETER: UTILITY TYPE IS REQUIRED'.          
           05 WS-INVALID-EFFECTIVE-DT  PIC X(44) VALUE                  
                'INVALID PARAMETER: EFFECTIVE DATE IS INVALID'.         
           05 WS-RATE-VRSN-NOT-FOUND   PIC X(44) VALUE                  
                'NO RATE VERSIONS FOUND WHICH MATCH CRITERIA'.          
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE ZERO.       
           05  S-COMPANY-NO            PIC X(02) VALUE SPACES.          
           05  S-RATE-DEPT-CD          PIC X(03) VALUE SPACES.          
           05  S-RATE-DEPT-DESC        PIC X(80) VALUE SPACES.          
           05  S-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.          
           05  S-UTIL-TYPE-DESC        PIC X(15) VALUE SPACES.          
           05  S-RATE-PLAN-NO          PIC X(03) VALUE SPACES.          
           05  S-RATE-DESC             PIC X(50) VALUE SPACES.          
           05  S-CMPNT-ID-CD           PIC X(03) VALUE SPACES.          
           05  S-RATE-CMPNT-DESC       PIC X(60) VALUE SPACES.          
           05  S-CODE-USE-INST-TYPE    PIC X(01) VALUE SPACES.          
           05  S-USE-INST-TYPE-DESC    PIC X(15) VALUE SPACES.          
           05  S-UNIT-CD               PIC X(02) VALUE SPACES.          
           05  S-UNIT-DESC             PIC X(15) VALUE SPACES.          
           05  S-CODE-SEASON           PIC X(01) VALUE SPACES.          
           05  S-SEASON                PIC X(15) VALUE SPACES.          
           05  S-CODE-TIME-PERIOD      PIC S9(4) USAGE COMP VALUE 0.    
           05  S-TIME-PERIOD           PIC X(15) VALUE SPACES.          
           05  S-BLOCK-NO              PIC S9(4) USAGE COMP VALUE 0.    
           05  S-BLOCK-SIZE            PIC X(09) VALUE SPACES.          
           05  S-PRICE-TYPE-CD         PIC X(01) VALUE SPACES.          
           05  S-PRICE-TYPE-DESC       PIC X(15) VALUE SPACES.          
           05  S-PRICE-GROUP           PIC X(15) VALUE SPACES.          
           05  S-PRICE                 PIC S9(5)V9(6) USAGE COMP-3      
                                                            VALUE 0.    
           05  S-SORT-ORDER            PIC S9(4) USAGE COMP VALUE 0.    
           05  S-LAST-ENERGY-BLOCK     PIC S9(4) USAGE COMP VALUE 0.    
           05  S-LAST-DEM-BLOCK        PIC S9(4) USAGE COMP VALUE 0.    
           05  S-RATE-ITEM-CODE        PIC S9(4) USAGE COMP VALUE 0.    
           05  S-UM-EQUIP-KWH          PIC S9(9) USAGE COMP VALUE 0.    
           05  S-VERS-PRORATE          PIC X(50) VALUE SPACES.          
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE ZERO.       
           05  RS-COMPANY-NO           PIC X(02) VALUE SPACES.          
           05  RS-RATE-DEPT-CD         PIC X(03) VALUE SPACES.          
           05  RS-RATE-DEPT-DESC       PIC X(80) VALUE SPACES.          
           05  RS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.          
           05  RS-UTIL-TYPE-DESC       PIC X(15) VALUE SPACES.          
           05  RS-RATE-PLAN-NO         PIC X(03) VALUE SPACES.          
           05  RS-RATE-DESC            PIC X(50) VALUE SPACES.          
           05  RS-CMPNT-ID-CD          PIC X(03) VALUE SPACES.          
           05  RS-RATE-CMPNT-DESC      PIC X(60) VALUE SPACES.          
           05  RS-CODE-USE-INST-TYPE   PIC X(01) VALUE SPACES.          
           05  RS-USE-INST-TYPE-DESC   PIC X(15) VALUE SPACES.          
           05  RS-UNIT-CD              PIC X(02) VALUE SPACES.          
           05  RS-UNIT-DESC            PIC X(15) VALUE SPACES.          
           05  RS-CODE-SEASON          PIC X(01) VALUE SPACES.          
           05  RS-SEASON               PIC X(15) VALUE SPACES.          
           05  RS-CODE-TIME-PERIOD     PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-TIME-PERIOD          PIC X(15) VALUE SPACES.          
           05  RS-BLOCK-NO             PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-BLOCK-SIZE           PIC X(09) VALUE SPACES.          
           05  RS-PRICE-TYPE-CD        PIC X(01) VALUE SPACES.          
           05  RS-PRICE-TYPE-DESC      PIC X(15) VALUE SPACES.          
           05  RS-PRICE-GROUP          PIC X(15) VALUE SPACES.          
           05  RS-PRICE                PIC S9(5)V9(6) USAGE COMP-3      
                                                            VALUE 0.    
           05  RS-SORT-ORDER           PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-LAST-ENERGY-BLOCK    PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-LAST-DEM-BLOCK       PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-RATE-ITEM-CODE       PIC S9(4) USAGE COMP VALUE 0.    
           05  RS-UM-EQUIP-KWH         PIC S9(9) USAGE COMP VALUE 0.    
           05  RS-VERS-PRORATE         PIC X(50) VALUE SPACES.          
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-END-OF-CURSOR-7200   PIC X(01) VALUE 'N'.             
               88 END-OF-CURSOR-7200             VALUE 'Y'.             
               88 NOT-END-OF-CURSOR-7200         VALUE 'N'.             
           05  WS-END-OF-CURSOR-7620   PIC X(01) VALUE 'N'.             
               88 END-OF-CURSOR-7620             VALUE 'Y'.             
               88 NOT-END-OF-CURSOR-7620         VALUE 'N'.             
           05  WS-END-OF-CURSOR-7650   PIC X(01) VALUE 'N'.             
               88 END-OF-CURSOR-7650             VALUE 'Y'.             
               88 NOT-END-OF-CURSOR-7650         VALUE 'N'.             
           05  WS-END-OF-CURSOR-7680   PIC X(01) VALUE 'N'.             
               88 END-OF-CURSOR-7680             VALUE 'Y'.             
               88 NOT-END-OF-CURSOR-7680         VALUE 'N'.             
           05  WS-END-OF-CURSOR-7820   PIC X(01) VALUE 'N'.             
               88 END-OF-CURSOR-7820             VALUE 'Y'.             
               88 NOT-END-OF-CURSOR-7820         VALUE 'N'.             
           05  WS-END-OF-CURSOR-7860   PIC X(01) VALUE 'N'.             
               88 END-OF-CURSOR-7860             VALUE 'Y'.             
               88 NOT-END-OF-CURSOR-7860         VALUE 'N'.             
           05  WS-RATE-PLAN-PASSED     PIC X(01) VALUE 'N'.             
               88 RATE-PLAN-PASSED               VALUE 'Y'.             
               88 RATE-PLAN-NOT-PASSED           VALUE 'N'.             
           05  WS-PARAMETER            PIC X(01) VALUE 'Y'.             
               88 VALID-PARAMETER                VALUE 'Y'.             
               88 INVALID-PARAMETER              VALUE 'N'.             
           05  WS-WINTER-BFC           PIC X(01) VALUE 'N'.             
               88 WS-WINTER-BFC-EXISTS           VALUE 'Y'.             
               88 WS-WINTER-BFC-NOT-EXISTS       VALUE 'N'.             
           05  WS-CODE-SEASON          PIC X(01) VALUE SPACES.          
               88 SUMMER                         VALUE 'S'.             
               88 NON-SUMMER                     VALUE 'N'.             
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18) VALUE SPACES.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
           10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L PIC S9(4) USAGE COMP.            
               49  WS-ABEND-SQLERRMC-V PIC X(255).                      
           10  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                         
       01  WS-WORK-AREA.                                                
           05  WS-METERED-FL           PIC X(01) VALUE SPACES.          
           05  WS-SECURED-RATE-FL      PIC X(01) VALUE SPACES.          
           05  WS-COMPANY-NO           PIC X(02) VALUE SPACES.          
           05  WS-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.          
           05  WS-RATE-PLAN-NO         PIC X(03) VALUE SPACES.          
           05  WS-FROM-EFF-DT          PIC X(10) VALUE SPACES.          
           05  WS-RATE-DEPT-CD         PIC X(03) VALUE SPACES.          
           05  WS-FILTER-BY-COMP       PIC X(01) VALUE SPACES.          
           05  WS-FILTER-BY-UTIL       PIC X(01) VALUE SPACES.          
           05  WS-FILTER-BY-RATE       PIC X(01) VALUE SPACES.          
           05  WS-FILTER-BY-DATE       PIC X(01) VALUE SPACES.          
           05  WS-FILTER-BY-RDEPT      PIC X(01) VALUE SPACES.          
           05  WS-FILTER-BY-SECURE     PIC X(01) VALUE SPACES.          
           05  WS-UNIT-CD              PIC X(02) VALUE SPACES.          
           05  WS-UNIT-DESC            PIC X(15) VALUE SPACES.          
           05  WS-NUMBER-BLOCKS        PIC S9(4) USAGE COMP VALUE 0.    
           05  WS-COMPUTE-PRICE-2      PIC S999V99 USAGE COMP-3 VALUE 0.
                                                                        
       01  WS-MISC-AREA.                                                
                                                                        
           10 WS-UV2-CODE-SHORT-DESC.                                   
              49 UV2-CODE-SHORT-DESC-LEN   PIC S9(4) USAGE COMP.        
              49 UV2-CODE-SHORT-DESC-TEXT  PIC X(15).                   
           10 WS-UV3-CODE-SHORT-DESC.                                   
              49 UV3-CODE-SHORT-DESC-LEN   PIC S9(4) USAGE COMP.        
              49 UV3-CODE-SHORT-DESC-TEXT  PIC X(15).                   
           10 WS-UV4-CODE-SHORT-DESC.                                   
              49 UV4-CODE-SHORT-DESC-LEN   PIC S9(4) USAGE COMP.        
              49 UV4-CODE-SHORT-DESC-TEXT  PIC X(15).                   
           10 WS-UV5-CODE-SHORT-DESC.                                   
              49 UV5-CODE-SHORT-DESC-LEN   PIC S9(4) USAGE COMP.        
              49 UV5-CODE-SHORT-DESC-TEXT  PIC X(15).                   
           10 WS-UV6-CODE-SHORT-DESC.                                   
              49 UV6-CODE-SHORT-DESC-LEN   PIC S9(4) USAGE COMP.        
              49 UV6-CODE-SHORT-DESC-TEXT  PIC X(15).                   
           10 WS-UV7-CODE-SHORT-DESC.                                   
              49 UV7-CODE-SHORT-DESC-LEN   PIC S9(4) USAGE COMP.        
              49 UV7-CODE-SHORT-DESC-TEXT  PIC X(15).                   
           10 WS-UV8-CODE-SHORT-DESC.                                   
              49 UV8-CODE-SHORT-DESC-LEN   PIC S9(4) USAGE COMP.        
              49 UV8-CODE-SHORT-DESC-TEXT  PIC X(15).                   
           10 WS-UV9-CODE-SHORT-DESC.                                   
              49 UV9-CODE-SHORT-DESC-LEN   PIC S9(4) USAGE COMP.        
              49 UV9-CODE-SHORT-DESC-TEXT  PIC X(15).                   
      *                                                                         
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    RD - CSS_RATE_PLAN_DESC                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTDESC                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    RT - CSS_RATE_CREATOR                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCRTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    UV - CSS_CODE_VALUE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDVALU                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    J4 - CSS_RATE_VRSN_DEF                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTVRSN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SA - CSS_SPCL_FCTR_APPL                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLAPL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SF - CSS_SPCL_FCTR                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    PS - CSS_PRICE_SCHED                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPRCSCH                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    N6 - CSS_RATE_COMPONENT                                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCPNT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    J1 - CSS_RATE_COMP_DEF                                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRTCDEF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    UP - CSS_UNMTR_PLAN                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMPLAN                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    L9 - CSS_UM_EQUIPMENT                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUMEQP                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      *    WORK AREAS TO XFER DATA.                                    *        
      ******************************************************************        
           COPY CCA00001.                                                       
      *                                                                         
      ******************************************************************        
      *    COPYBOOK TO SUPPORT DB2 AND SQL ERROR CHECKING.             *        
      ******************************************************************        
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING COPY BOOK.                                   *        
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      * CURSOR TO FETCH RATE PLAN VERSIONS BASED ON PARAMETRES PASSED  *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE RATE_PLAN_VRSN_CUR CURSOR FOR                    
           SELECT RD.COMPANY_NO                                         
                 ,RD.CODE_UTIL_TYPE                                     
                 ,UPPER(UV1.CODE_SHORT_DESC)                            
                 ,RD.RATE_PLAN_NO                                       
                 ,RD.RATE_DESC                                          
                 ,RD.RATE_DEPT_CD                                       
                 ,UPPER(UV2.CODE_SHORT_DESC)                            
                 ,RT1.VERSION_NO_CNTRL                                  
                 ,RT1.FROM_EFFECTIVE_DT                                 
                 ,UPPER(UV3.CODE_SHORT_DESC)                            
           FROM   CSS_RATE_PLAN_DESC  RD WITH(READUNCOMMITTED)                  
                 ,CSS_RATE_CREATOR    RT1 WITH(READUNCOMMITTED)                 
                 ,CSS_CODE_VALUE      UV1 WITH(READUNCOMMITTED)                 
                 ,CSS_CODE_VALUE      UV2 WITH(READUNCOMMITTED)                 
                 ,CSS_CODE_VALUE      UV3 WITH(READUNCOMMITTED)                 
           WHERE RD.RATE_PLAN_NO     = RT1.RATE_PLAN_NO                 
             AND RD.CODE_UTIL_TYPE   = RT1.CODE_UTIL_TYPE               
             AND UV1.COLUMN_NA       = 'CODE_UTIL_TYPE'                 
             AND UV1.TABLE_NA        = 'CSS_RATE_PLAN_DESC'             
             AND UV1.COMPANY_NO      = RD.COMPANY_NO                    
             AND UV1.CODE_VALUE      = RD.CODE_UTIL_TYPE                
             AND UV2.COLUMN_NA       = 'RATE_DEPT_CD'                   
             AND UV2.TABLE_NA        = 'CSS_RATE_PLAN_DESC'             
             AND UV2.COMPANY_NO      = '01'                             
             AND UV2.CODE_VALUE      = RD.RATE_DEPT_CD                  
             AND UV3.COLUMN_NA       = 'VERS_PRORATE_CD'                
             AND UV3.TABLE_NA        = 'CSS_RATE_CREATOR'               
             AND UV3.COMPANY_NO      = '01'                             
             AND UV3.CODE_VALUE      = RT1.VERS_PRORATE_CD              
             AND ((:WS-METERED-FL    = 'M'                              
             AND    RD.CODE_UTIL_TYPE IN ('E','G'))                     
              OR (:WS-METERED-FL     = 'U'                              
             AND   RD.CODE_UTIL_TYPE = 'U'))                            
             AND (:WS-FILTER-BY-RATE = 'N'                              
              OR (:WS-FILTER-BY-RATE = 'Y'                              
             AND   RD.RATE_PLAN_NO   = :WS-RATE-PLAN-NO))               
             AND (:WS-FILTER-BY-UTIL = 'N'                              
              OR (:WS-FILTER-BY-UTIL = 'Y'                              
             AND   RD.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE))             
             AND (:WS-FILTER-BY-COMP = 'N'                              
              OR (:WS-FILTER-BY-COMP = 'Y'                              
             AND   RD.COMPANY_NO     = :WS-COMPANY-NO))                 
             AND ((:WS-FILTER-BY-DATE = 'N'                             
             AND    RT1.VERSION_NO_CNTRL =                              
                       (SELECT MAX(RT2.VERSION_NO_CNTRL)                
                          FROM CSS_RATE_CREATOR RT2
                           WITH(READUNCOMMITTED)                     
                         WHERE RT2.RATE_PLAN_NO = RT1.RATE_PLAN_NO      
                           AND RT2.CODE_UTIL_TYPE = RT1.CODE_UTIL_TYPE  
                           AND RT2.CODE_STATUS <> 'I'))                 
              OR (:WS-FILTER-BY-DATE  = 'Y'                             
             AND   RT1.VERSION_NO_CNTRL =                               
                       (SELECT MAX(RT3.VERSION_NO_CNTRL)                
                          FROM CSS_RATE_CREATOR RT3
                           WITH(READUNCOMMITTED)                     
                         WHERE RT3.RATE_PLAN_NO = RT1.RATE_PLAN_NO      
                         AND RT3.CODE_UTIL_TYPE = RT1.CODE_UTIL_TYPE    
                         AND RT3.CODE_STATUS <> 'I'                     
                         AND RT3.FROM_EFFECTIVE_DT <= 
              IIF(TRY_CONVERT(DATE, :WS-FROM-EFF-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-FROM-EFF-DT
              ) <> 0) OR (LEN(:WS-FROM-EFF-DT) <> 10), CIS.CHAR2DATE(
                                                        :WS-FROM-EFF-DT
              ), CONVERT(DATE, :WS-FROM-EFF-DT) ))))
A04177*                  AND RT3.DATE_CREATED  <= :WS-FROM-EFF-DT)))            
             AND (:WS-FILTER-BY-RDEPT = 'N'                             
              OR (:WS-FILTER-BY-RDEPT = 'Y'                             
                   AND RD.RATE_DEPT_CD = :WS-RATE-DEPT-CD))             
             AND (:WS-FILTER-BY-SECURE = 'N'                            
              OR (:WS-FILTER-BY-SECURE = 'Y'                            
                   AND RD.SECURED_RATE_FL = :WS-SECURED-RATE-FL))       
      *      AND RD.SECURED_RATE_FL = :WS-SECURED-RATE-FL                       
             ORDER BY RD.COMPANY_NO                                     
                     ,RD.CODE_UTIL_TYPE                                 
                     ,RD.RATE_DEPT_CD                                   
                     ,RD.RATE_PLAN_NO                                   
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_PLAN_VRSN_CUR CURSOR FOR                            
MFA-TR*    SELECT RD.COMPANY_NO                                                 
MFA-TR*          ,RD.CODE_UTIL_TYPE                                             
MFA-TR*          ,UPPER(UV1.CODE_SHORT_DESC)                                    
MFA-TR*          ,RD.RATE_PLAN_NO                                               
MFA-TR*          ,RD.RATE_DESC                                                  
MFA-TR*          ,RD.RATE_DEPT_CD                                               
MFA-TR*          ,UPPER(UV2.CODE_SHORT_DESC)                                    
MFA-TR*          ,RT1.VERSION_NO_CNTRL                                          
MFA-TR*          ,RT1.FROM_EFFECTIVE_DT                                         
MFA-TR*          ,UPPER(UV3.CODE_SHORT_DESC)                                    
MFA-TR*    FROM   CSS_RATE_PLAN_DESC  RD                                        
MFA-TR*          ,CSS_RATE_CREATOR    RT1                                       
MFA-TR*          ,CSS_CODE_VALUE      UV1                                       
MFA-TR*          ,CSS_CODE_VALUE      UV2                                       
MFA-TR*          ,CSS_CODE_VALUE      UV3                                       
MFA-TR*    WHERE RD.RATE_PLAN_NO     = RT1.RATE_PLAN_NO                         
MFA-TR*      AND RD.CODE_UTIL_TYPE   = RT1.CODE_UTIL_TYPE                       
MFA-TR*      AND UV1.COLUMN_NA       = 'CODE_UTIL_TYPE'                         
MFA-TR*      AND UV1.TABLE_NA        = 'CSS_RATE_PLAN_DESC'                     
MFA-TR*      AND UV1.COMPANY_NO      = RD.COMPANY_NO                            
MFA-TR*      AND UV1.CODE_VALUE      = RD.CODE_UTIL_TYPE                        
MFA-TR*      AND UV2.COLUMN_NA       = 'RATE_DEPT_CD'                           
MFA-TR*      AND UV2.TABLE_NA        = 'CSS_RATE_PLAN_DESC'                     
MFA-TR*      AND UV2.COMPANY_NO      = '01'                                     
MFA-TR*      AND UV2.CODE_VALUE      = RD.RATE_DEPT_CD                          
MFA-TR*      AND UV3.COLUMN_NA       = 'VERS_PRORATE_CD'                        
MFA-TR*      AND UV3.TABLE_NA        = 'CSS_RATE_CREATOR'                       
MFA-TR*      AND UV3.COMPANY_NO      = '01'                                     
MFA-TR*      AND UV3.CODE_VALUE      = RT1.VERS_PRORATE_CD                      
MFA-TR*      AND ((:WS-METERED-FL    = 'M'                                      
MFA-TR*      AND    RD.CODE_UTIL_TYPE IN ('E','G'))                             
MFA-TR*       OR (:WS-METERED-FL     = 'U'                                      
MFA-TR*      AND   RD.CODE_UTIL_TYPE = 'U'))                                    
MFA-TR*      AND (:WS-FILTER-BY-RATE = 'N'                                      
MFA-TR*       OR (:WS-FILTER-BY-RATE = 'Y'                                      
MFA-TR*      AND   RD.RATE_PLAN_NO   = :WS-RATE-PLAN-NO))                       
MFA-TR*      AND (:WS-FILTER-BY-UTIL = 'N'                                      
MFA-TR*       OR (:WS-FILTER-BY-UTIL = 'Y'                                      
MFA-TR*      AND   RD.CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE))                     
MFA-TR*      AND (:WS-FILTER-BY-COMP = 'N'                                      
MFA-TR*       OR (:WS-FILTER-BY-COMP = 'Y'                                      
MFA-TR*      AND   RD.COMPANY_NO     = :WS-COMPANY-NO))                         
MFA-TR*      AND ((:WS-FILTER-BY-DATE = 'N'                                     
MFA-TR*      AND    RT1.VERSION_NO_CNTRL =                                      
MFA-TR*                (SELECT MAX(RT2.VERSION_NO_CNTRL)                        
MFA-TR*                   FROM CSS_RATE_CREATOR RT2                             
MFA-TR*                  WHERE RT2.RATE_PLAN_NO = RT1.RATE_PLAN_NO              
MFA-TR*                    AND RT2.CODE_UTIL_TYPE = RT1.CODE_UTIL_TYPE          
MFA-TR*                    AND RT2.CODE_STATUS <> 'I'))                         
MFA-TR*       OR (:WS-FILTER-BY-DATE  = 'Y'                                     
MFA-TR*      AND   RT1.VERSION_NO_CNTRL =                                       
MFA-TR*                (SELECT MAX(RT3.VERSION_NO_CNTRL)                        
MFA-TR*                   FROM CSS_RATE_CREATOR RT3                             
MFA-TR*                  WHERE RT3.RATE_PLAN_NO = RT1.RATE_PLAN_NO              
MFA-TR*                  AND RT3.CODE_UTIL_TYPE = RT1.CODE_UTIL_TYPE            
MFA-TR*                  AND RT3.CODE_STATUS <> 'I'                             
MFA-TR*                  AND RT3.FROM_EFFECTIVE_DT <= :WS-FROM-EFF-DT)))        
MFA-TR*                  AND RT3.DATE_CREATED  <= :WS-FROM-EFF-DT)))            
MFA-TR*      AND (:WS-FILTER-BY-RDEPT = 'N'                                     
MFA-TR*       OR (:WS-FILTER-BY-RDEPT = 'Y'                                     
MFA-TR*            AND RD.RATE_DEPT_CD = :WS-RATE-DEPT-CD))                     
MFA-TR*      AND (:WS-FILTER-BY-SECURE = 'N'                                    
MFA-TR*       OR (:WS-FILTER-BY-SECURE = 'Y'                                    
MFA-TR*            AND RD.SECURED_RATE_FL = :WS-SECURED-RATE-FL))               
MFA-TR*      AND RD.SECURED_RATE_FL = :WS-SECURED-RATE-FL                       
MFA-TR*      ORDER BY RD.COMPANY_NO                                             
MFA-TR*              ,RD.CODE_UTIL_TYPE                                         
MFA-TR*              ,RD.RATE_DEPT_CD                                           
MFA-TR*              ,RD.RATE_PLAN_NO                                           
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO GET FIXED RATE SCHEDULE PRICE FOR EACH VERSION OF    *        
      * THE METERED PLAN.                                              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE FIXED_RT_SCHED_CSR CURSOR FOR                    
                 SELECT PS.CMPNT_ID_CD                                  
                       ,N6.RATE_CMPNT_DESC                              
                       ,PS.CODE_USE_INST_TYPE                           
                       ,UPPER(UV1.CODE_SHORT_DESC)                      
                       ,CASE PS.CODE_USE_INST_TYPE                      
                          WHEN 'R' THEN J1.ENERGY_UNIT_CD               
                          WHEN 'D' THEN J1.DEM_UNIT_CD                  
                        ELSE                                            
                          'NA'                                          
                        END AS UNITS                                    
                       ,PS.CODE_SEASON                                  
                       ,UPPER(UV4.CODE_SHORT_DESC) AS SEASON            
                       ,PS.CODE_TIME_PERIOD                             
                       ,UPPER(UV3.CODE_SHORT_DESC) AS TIME_PERIOD       
                       ,PS.BLOCK_NO                                     
                       ,PS.BLOCK_USE_OR_SVCS                            
                       ,PS.PRICE_TYPE_CD                                
                       ,UPPER(UV2.CODE_SHORT_DESC)                      
                       ,PS.SCHED_PRICE_AM                               
                       ,J1.LAST_ENERGY_BLOCK                            
                       ,J1.LAST_DEM_BLOCK                               
                 FROM  CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                 
                     , CSS_RATE_COMPONENT N6 WITH(READUNCOMMITTED)              
                     , CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)               
                     , CSS_CODE_VALUE UV1 WITH(READUNCOMMITTED)                 
                     , CSS_CODE_VALUE UV2 WITH(READUNCOMMITTED)                 
                     , CSS_CODE_VALUE UV3 WITH(READUNCOMMITTED)                 
                     , CSS_CODE_VALUE UV4 WITH(READUNCOMMITTED)                 
                 WHERE PS.RATE_PLAN_NO     = :PS-RATE-PLAN-NO           
                   AND PS.CODE_UTIL_TYPE   = :PS-CODE-UTIL-TYPE         
                   AND PS.VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL       
                   AND PS.CMPNT_ID_CD      = N6.RATE_CMPNT_ID           
                   AND PS.RATE_PLAN_NO     = J1.RATE_PLAN_NO            
                   AND PS.CODE_UTIL_TYPE   = J1.CODE_UTIL_TYPE          
                   AND PS.VERSION_NO_CNTRL = J1.VERSION_NO_CNTRL        
                   AND PS.CMPNT_ID_CD      = J1.CMPNT_ID_CD             
                   AND PS.PRICE_TYPE_CD    = 'F'                        
                   AND UV1.TABLE_NA        = 'CSS_BILL_CALC_DET'        
                   AND UV1.COLUMN_NA       = 'INSTR_USE_TYPE_CD'        
                   AND UV1.COMPANY_NO      = '01'                       
                   AND UV1.CODE_VALUE      = PS.CODE_USE_INST_TYPE      
                   AND UV2.TABLE_NA        = 'CSS_PRICE_SCHED'          
                   AND UV2.COLUMN_NA       = 'PRICE_TYPE_CD'            
                   AND UV2.COMPANY_NO      = '01'                       
                   AND UV2.CODE_VALUE      = PS.PRICE_TYPE_CD           
                   AND UV3.TABLE_NA        = 'CSS_PRICE_SCHED'          
                   AND UV3.COLUMN_NA       = 'CODE_TIME_PERIOD'         
                   AND UV3.COMPANY_NO      = '01'                       
                   AND UV3.CODE_VALUE      = LEFT(CAST(
           PS.CODE_TIME_PERIOD AS VARCHAR(6)) + '      ', 6)  
                   AND UV4.TABLE_NA        = 'CSS_RATE_USE_SEASN'       
                   AND UV4.COLUMN_NA       = 'CODE_SEASON'              
                   AND UV4.COMPANY_NO      = '01'                       
                   AND UV4.CODE_VALUE      = PS.CODE_SEASON             
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE FIXED_RT_SCHED_CSR CURSOR FOR                            
MFA-TR*          SELECT PS.CMPNT_ID_CD                                          
MFA-TR*                ,N6.RATE_CMPNT_DESC                                      
MFA-TR*                ,PS.CODE_USE_INST_TYPE                                   
MFA-TR*                ,UPPER(UV1.CODE_SHORT_DESC)                              
MFA-TR*                ,CASE PS.CODE_USE_INST_TYPE                              
MFA-TR*                   WHEN 'R' THEN J1.ENERGY_UNIT_CD                       
MFA-TR*                   WHEN 'D' THEN J1.DEM_UNIT_CD                          
MFA-TR*                 ELSE                                                    
MFA-TR*                   'NA'                                                  
MFA-TR*                 END AS UNITS                                            
MFA-TR*                ,PS.CODE_SEASON                                          
MFA-TR*                ,UPPER(UV4.CODE_SHORT_DESC) AS SEASON                    
MFA-TR*                ,PS.CODE_TIME_PERIOD                                     
MFA-TR*                ,UPPER(UV3.CODE_SHORT_DESC) AS TIME_PERIOD               
MFA-TR*                ,PS.BLOCK_NO                                             
MFA-TR*                ,PS.BLOCK_USE_OR_SVCS                                    
MFA-TR*                ,PS.PRICE_TYPE_CD                                        
MFA-TR*                ,UPPER(UV2.CODE_SHORT_DESC)                              
MFA-TR*                ,PS.SCHED_PRICE_AM                                       
MFA-TR*                ,J1.LAST_ENERGY_BLOCK                                    
MFA-TR*                ,J1.LAST_DEM_BLOCK                                       
MFA-TR*          FROM  CSS_PRICE_SCHED PS                                       
MFA-TR*              , CSS_RATE_COMPONENT N6                                    
MFA-TR*              , CSS_RATE_COMP_DEF J1                                     
MFA-TR*              , CSS_CODE_VALUE UV1                                       
MFA-TR*              , CSS_CODE_VALUE UV2                                       
MFA-TR*              , CSS_CODE_VALUE UV3                                       
MFA-TR*              , CSS_CODE_VALUE UV4                                       
MFA-TR*          WHERE PS.RATE_PLAN_NO     = :PS-RATE-PLAN-NO                   
MFA-TR*            AND PS.CODE_UTIL_TYPE   = :PS-CODE-UTIL-TYPE                 
MFA-TR*            AND PS.VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL               
MFA-TR*            AND PS.CMPNT_ID_CD      = N6.RATE_CMPNT_ID                   
MFA-TR*            AND PS.RATE_PLAN_NO     = J1.RATE_PLAN_NO                    
MFA-TR*            AND PS.CODE_UTIL_TYPE   = J1.CODE_UTIL_TYPE                  
MFA-TR*            AND PS.VERSION_NO_CNTRL = J1.VERSION_NO_CNTRL                
MFA-TR*            AND PS.CMPNT_ID_CD      = J1.CMPNT_ID_CD                     
MFA-TR*            AND PS.PRICE_TYPE_CD    = 'F'                                
MFA-TR*            AND UV1.TABLE_NA        = 'CSS_BILL_CALC_DET'                
MFA-TR*            AND UV1.COLUMN_NA       = 'INSTR_USE_TYPE_CD'                
MFA-TR*            AND UV1.COMPANY_NO      = '01'                               
MFA-TR*            AND UV1.CODE_VALUE      = PS.CODE_USE_INST_TYPE              
MFA-TR*            AND UV2.TABLE_NA        = 'CSS_PRICE_SCHED'                  
MFA-TR*            AND UV2.COLUMN_NA       = 'PRICE_TYPE_CD'                    
MFA-TR*            AND UV2.COMPANY_NO      = '01'                               
MFA-TR*            AND UV2.CODE_VALUE      = PS.PRICE_TYPE_CD                   
MFA-TR*            AND UV3.TABLE_NA        = 'CSS_PRICE_SCHED'                  
MFA-TR*            AND UV3.COLUMN_NA       = 'CODE_TIME_PERIOD'                 
MFA-TR*            AND UV3.COMPANY_NO      = '01'                               
MFA-TR*            AND UV3.CODE_VALUE      = CHAR(PS.CODE_TIME_PERIOD)          
MFA-TR*            AND UV4.TABLE_NA        = 'CSS_RATE_USE_SEASN'               
MFA-TR*            AND UV4.COLUMN_NA       = 'CODE_SEASON'                      
MFA-TR*            AND UV4.COMPANY_NO      = '01'                               
MFA-TR*            AND UV4.CODE_VALUE      = PS.CODE_SEASON                     
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*        QUERYNO 7620                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO GET RATE SCHEDULE PRICE FOR EACH VERSION OF          *        
      * THE METERED PLAN.  (PER UNIT PRICE)                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE RATE_SCHED_PRICE_CSR CURSOR FOR                  
                 SELECT PS.CMPNT_ID_CD                                  
                       ,N6.RATE_CMPNT_DESC                              
                       ,PS.CODE_USE_INST_TYPE                           
                       ,UPPER(UV1.CODE_SHORT_DESC)                      
                       ,CASE PS.CODE_USE_INST_TYPE                      
                          WHEN 'R' THEN J1.ENERGY_UNIT_CD               
                          WHEN 'D' THEN J1.DEM_UNIT_CD                  
                        ELSE                                            
                          'NA'                                          
                        END AS UNITS                                    
                       ,PS.CODE_SEASON                                  
                       ,UPPER(UV4.CODE_SHORT_DESC) AS SEASON            
                       ,PS.CODE_TIME_PERIOD                             
                       ,UPPER(UV3.CODE_SHORT_DESC) AS TIME_PERIOD       
                       ,PS.BLOCK_NO                                     
                       ,PS.BLOCK_USE_OR_SVCS                            
                       ,PS.PRICE_TYPE_CD                                
                       ,UPPER(UV2.CODE_SHORT_DESC)                      
                       ,PS.SCHED_PRICE_AM                               
                       ,J1.LAST_ENERGY_BLOCK                            
                       ,J1.LAST_DEM_BLOCK                               
                 FROM  CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                 
                     , CSS_RATE_COMPONENT N6 WITH(READUNCOMMITTED)              
                     , CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)               
                     , CSS_CODE_VALUE UV1 WITH(READUNCOMMITTED)                 
                     , CSS_CODE_VALUE UV2 WITH(READUNCOMMITTED)                 
                     , CSS_CODE_VALUE UV3 WITH(READUNCOMMITTED)                 
                     , CSS_CODE_VALUE UV4 WITH(READUNCOMMITTED)                 
                 WHERE PS.RATE_PLAN_NO     = :PS-RATE-PLAN-NO           
                   AND PS.CODE_UTIL_TYPE   = :PS-CODE-UTIL-TYPE         
                   AND PS.VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL       
                   AND PS.CMPNT_ID_CD      = N6.RATE_CMPNT_ID           
                   AND PS.RATE_PLAN_NO     = J1.RATE_PLAN_NO            
                   AND PS.CODE_UTIL_TYPE   = J1.CODE_UTIL_TYPE          
                   AND PS.VERSION_NO_CNTRL = J1.VERSION_NO_CNTRL        
                   AND PS.CMPNT_ID_CD      = J1.CMPNT_ID_CD             
                   AND PS.PRICE_TYPE_CD    IN ('P','U')                 
                   AND (PS.CODE_SEASON     = :PS-CODE-SEASON            
                    OR  PS.CODE_SEASON     = 'B')                       
                   AND UV1.TABLE_NA        = 'CSS_BILL_CALC_DET'        
                   AND UV1.COLUMN_NA       = 'INSTR_USE_TYPE_CD'        
                   AND UV1.COMPANY_NO      = '01'                       
                   AND UV1.CODE_VALUE      = PS.CODE_USE_INST_TYPE      
                   AND UV2.TABLE_NA        = 'CSS_PRICE_SCHED'          
                   AND UV2.COLUMN_NA       = 'PRICE_TYPE_CD'            
                   AND UV2.COMPANY_NO      = '01'                       
                   AND UV2.CODE_VALUE      = PS.PRICE_TYPE_CD           
                   AND UV3.TABLE_NA        = 'CSS_PRICE_SCHED'          
                   AND UV3.COLUMN_NA       = 'CODE_TIME_PERIOD'         
                   AND UV3.COMPANY_NO      = '01'                       
                   AND UV3.CODE_VALUE      = LEFT(CAST(
           PS.CODE_TIME_PERIOD AS VARCHAR(6)) + '      ', 6)  
                   AND UV4.TABLE_NA        = 'CSS_RATE_USE_SEASN'       
                   AND UV4.COLUMN_NA       = 'CODE_SEASON'              
                   AND UV4.COMPANY_NO      = '01'                       
                   AND UV4.CODE_VALUE      = :PS-CODE-SEASON            
                 ORDER BY PS.CMPNT_ID_CD                                
                         ,PS.CODE_USE_INST_TYPE DESC                    
                         ,PS.CODE_SEASON DESC                           
                         ,PS.BLOCK_NO                                   
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RATE_SCHED_PRICE_CSR CURSOR FOR                          
MFA-TR*          SELECT PS.CMPNT_ID_CD                                          
MFA-TR*                ,N6.RATE_CMPNT_DESC                                      
MFA-TR*                ,PS.CODE_USE_INST_TYPE                                   
MFA-TR*                ,UPPER(UV1.CODE_SHORT_DESC)                              
MFA-TR*                ,CASE PS.CODE_USE_INST_TYPE                              
MFA-TR*                   WHEN 'R' THEN J1.ENERGY_UNIT_CD                       
MFA-TR*                   WHEN 'D' THEN J1.DEM_UNIT_CD                          
MFA-TR*                 ELSE                                                    
MFA-TR*                   'NA'                                                  
MFA-TR*                 END AS UNITS                                            
MFA-TR*                ,PS.CODE_SEASON                                          
MFA-TR*                ,UPPER(UV4.CODE_SHORT_DESC) AS SEASON                    
MFA-TR*                ,PS.CODE_TIME_PERIOD                                     
MFA-TR*                ,UPPER(UV3.CODE_SHORT_DESC) AS TIME_PERIOD               
MFA-TR*                ,PS.BLOCK_NO                                             
MFA-TR*                ,PS.BLOCK_USE_OR_SVCS                                    
MFA-TR*                ,PS.PRICE_TYPE_CD                                        
MFA-TR*                ,UPPER(UV2.CODE_SHORT_DESC)                              
MFA-TR*                ,PS.SCHED_PRICE_AM                                       
MFA-TR*                ,J1.LAST_ENERGY_BLOCK                                    
MFA-TR*                ,J1.LAST_DEM_BLOCK                                       
MFA-TR*          FROM  CSS_PRICE_SCHED PS                                       
MFA-TR*              , CSS_RATE_COMPONENT N6                                    
MFA-TR*              , CSS_RATE_COMP_DEF J1                                     
MFA-TR*              , CSS_CODE_VALUE UV1                                       
MFA-TR*              , CSS_CODE_VALUE UV2                                       
MFA-TR*              , CSS_CODE_VALUE UV3                                       
MFA-TR*              , CSS_CODE_VALUE UV4                                       
MFA-TR*          WHERE PS.RATE_PLAN_NO     = :PS-RATE-PLAN-NO                   
MFA-TR*            AND PS.CODE_UTIL_TYPE   = :PS-CODE-UTIL-TYPE                 
MFA-TR*            AND PS.VERSION_NO_CNTRL = :PS-VERSION-NO-CNTRL               
MFA-TR*            AND PS.CMPNT_ID_CD      = N6.RATE_CMPNT_ID                   
MFA-TR*            AND PS.RATE_PLAN_NO     = J1.RATE_PLAN_NO                    
MFA-TR*            AND PS.CODE_UTIL_TYPE   = J1.CODE_UTIL_TYPE                  
MFA-TR*            AND PS.VERSION_NO_CNTRL = J1.VERSION_NO_CNTRL                
MFA-TR*            AND PS.CMPNT_ID_CD      = J1.CMPNT_ID_CD                     
MFA-TR*            AND PS.PRICE_TYPE_CD    IN ('P','U')                         
MFA-TR*            AND (PS.CODE_SEASON     = :PS-CODE-SEASON                    
MFA-TR*             OR  PS.CODE_SEASON     = 'B')                               
MFA-TR*            AND UV1.TABLE_NA        = 'CSS_BILL_CALC_DET'                
MFA-TR*            AND UV1.COLUMN_NA       = 'INSTR_USE_TYPE_CD'                
MFA-TR*            AND UV1.COMPANY_NO      = '01'                               
MFA-TR*            AND UV1.CODE_VALUE      = PS.CODE_USE_INST_TYPE              
MFA-TR*            AND UV2.TABLE_NA        = 'CSS_PRICE_SCHED'                  
MFA-TR*            AND UV2.COLUMN_NA       = 'PRICE_TYPE_CD'                    
MFA-TR*            AND UV2.COMPANY_NO      = '01'                               
MFA-TR*            AND UV2.CODE_VALUE      = PS.PRICE_TYPE_CD                   
MFA-TR*            AND UV3.TABLE_NA        = 'CSS_PRICE_SCHED'                  
MFA-TR*            AND UV3.COLUMN_NA       = 'CODE_TIME_PERIOD'                 
MFA-TR*            AND UV3.COMPANY_NO      = '01'                               
MFA-TR*            AND UV3.CODE_VALUE      = CHAR(PS.CODE_TIME_PERIOD)          
MFA-TR*            AND UV4.TABLE_NA        = 'CSS_RATE_USE_SEASN'               
MFA-TR*            AND UV4.COLUMN_NA       = 'CODE_SEASON'                      
MFA-TR*            AND UV4.COMPANY_NO      = '01'                               
MFA-TR*            AND UV4.CODE_VALUE      = :PS-CODE-SEASON                    
MFA-TR*          ORDER BY PS.CMPNT_ID_CD                                        
MFA-TR*                  ,PS.CODE_USE_INST_TYPE DESC                            
MFA-TR*                  ,PS.CODE_SEASON DESC                                   
MFA-TR*                  ,PS.BLOCK_NO                                           
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*        QUERYNO 7650                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO GET RATE FACTOR ADJUSTMENTS FOR EACH PRICE FOUND IN  *        
      * PRICE SCHED TABLE.                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE RT_FCTR_ADJUST_CSR   CURSOR FOR                  
                 SELECT SA.CODE_UTIL_TYPE                               
                       ,SA.RATE_PLAN_NO                                 
                       ,SA.CMPNT_ID_CD                                  
                       ,SA.INSTR_USE_TYPE_CD                            
                       ,SA.FACTOR_ID                                    
                       ,SF.FACTOR_TEXT                                  
                       ,SF.ADJUST_ELEMENT                               
                       ,SA.FACTOR                                       
               FROM  CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
                    ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)                
               WHERE SA.RATE_PLAN_NO      = :SA-RATE-PLAN-NO            
                 AND SA.CODE_UTIL_TYPE    = :SA-CODE-UTIL-TYPE          
                 AND SA.CMPNT_ID_CD       = :SA-CMPNT-ID-CD             
                 AND SA.INSTR_USE_TYPE_CD = :SA-INSTR-USE-TYPE-CD       
                 AND SA.FACTOR_ID         = SF.FACTOR_ID                
                 AND SF.CHECK_ELEMENT    IN ('A', 'B')                  
                 AND (SA.CODE_SEASON      = :SA-CODE-SEASON OR          
                      SA.CODE_SEASON      = 'B')                        
                 AND (SA.CODE_TIME_PERIOD = :SA-CODE-TIME-PERIOD OR     
                      SA.CODE_TIME_PERIOD = 0)                          
                 AND (SA.BLOCK_NO         = :SA-BLOCK-NO OR             
                      SA.BLOCK_NO         = 0)                          
                 AND SA.DATE_FROM         =                             
                     (SELECT MAX(SA2.DATE_FROM)                         
                      FROM CSS_SPCL_FCTR_APPL SA2 WITH(READUNCOMMITTED)         
                      WHERE SA2.RATE_PLAN_NO      = SA.RATE_PLAN_NO     
                        AND SA2.CODE_UTIL_TYPE    = SA.CODE_UTIL_TYPE   
                        AND SA2.FACTOR_ID         = SA.FACTOR_ID        
                        AND SA2.CMPNT_ID_CD       = SA.CMPNT_ID_CD      
                        AND SA2.INSTR_USE_TYPE_CD = SA.INSTR_USE_TYPE_CD
                        AND SA2.CODE_SEASON       = SA.CODE_SEASON      
                        AND SA2.CODE_TIME_PERIOD  = SA.CODE_TIME_PERIOD 
                        AND SA2.BLOCK_NO          = SA.BLOCK_NO         
                        AND SA2.CODE_STATUS <> 'I'                      
                        AND SA2.DATE_FROM   <= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )            
                        AND SA2.DATE_TO     >= IIF(TRY_CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO) <> 0) OR (LEN(
                                                            :SA-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO), CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) ))             
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE RT_FCTR_ADJUST_CSR   CURSOR FOR                          
MFA-TR*          SELECT SA.CODE_UTIL_TYPE                                       
MFA-TR*                ,SA.RATE_PLAN_NO                                         
MFA-TR*                ,SA.CMPNT_ID_CD                                          
MFA-TR*                ,SA.INSTR_USE_TYPE_CD                                    
MFA-TR*                ,SA.FACTOR_ID                                            
MFA-TR*                ,SF.FACTOR_TEXT                                          
MFA-TR*                ,SF.ADJUST_ELEMENT                                       
MFA-TR*                ,SA.FACTOR                                               
MFA-TR*        FROM  CSS_SPCL_FCTR_APPL SA                                      
MFA-TR*             ,CSS_SPCL_FCTR      SF                                      
MFA-TR*        WHERE SA.RATE_PLAN_NO      = :SA-RATE-PLAN-NO                    
MFA-TR*          AND SA.CODE_UTIL_TYPE    = :SA-CODE-UTIL-TYPE                  
MFA-TR*          AND SA.CMPNT_ID_CD       = :SA-CMPNT-ID-CD                     
MFA-TR*          AND SA.INSTR_USE_TYPE_CD = :SA-INSTR-USE-TYPE-CD               
MFA-TR*          AND SA.FACTOR_ID         = SF.FACTOR_ID                        
MFA-TR*          AND SF.CHECK_ELEMENT    IN ('A', 'B')                          
MFA-TR*          AND (SA.CODE_SEASON      = :SA-CODE-SEASON OR                  
MFA-TR*               SA.CODE_SEASON      = 'B')                                
MFA-TR*          AND (SA.CODE_TIME_PERIOD = :SA-CODE-TIME-PERIOD OR             
MFA-TR*               SA.CODE_TIME_PERIOD = 0)                                  
MFA-TR*          AND (SA.BLOCK_NO         = :SA-BLOCK-NO OR                     
MFA-TR*               SA.BLOCK_NO         = 0)                                  
MFA-TR*          AND SA.DATE_FROM         =                                     
MFA-TR*              (SELECT MAX(SA2.DATE_FROM)                                 
MFA-TR*               FROM CSS_SPCL_FCTR_APPL SA2                               
MFA-TR*               WHERE SA2.RATE_PLAN_NO      = SA.RATE_PLAN_NO             
MFA-TR*                 AND SA2.CODE_UTIL_TYPE    = SA.CODE_UTIL_TYPE           
MFA-TR*                 AND SA2.FACTOR_ID         = SA.FACTOR_ID                
MFA-TR*                 AND SA2.CMPNT_ID_CD       = SA.CMPNT_ID_CD              
MFA-TR*                 AND SA2.INSTR_USE_TYPE_CD = SA.INSTR_USE_TYPE_CD        
MFA-TR*                 AND SA2.CODE_SEASON       = SA.CODE_SEASON              
MFA-TR*                 AND SA2.CODE_TIME_PERIOD  = SA.CODE_TIME_PERIOD         
MFA-TR*                 AND SA2.BLOCK_NO          = SA.BLOCK_NO                 
MFA-TR*                 AND SA2.CODE_STATUS <> 'I'                              
MFA-TR*                 AND SA2.DATE_FROM   <= :SA-DATE-FROM                    
MFA-TR*                 AND SA2.DATE_TO     >= :SA-DATE-TO)                     
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*        QUERYNO 7680                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO FETCH UNMETERED PLAN PRICES                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE UNMETERED_PLAN_CUR CURSOR FOR                    
                 SELECT UP.RATE_ITEM_CODE                               
                       ,UP.UM_EQUIP_ID                                  
                       ,L9.UM_EQUIP_LONG_DESC                           
                       ,L9.UM_EQUIP_KWH                                 
ACT189                 ,L9.UM_EQUIP_TYPE_CD                             
                       ,UP.CUST_PER_SERVICE                             
                       ,UP.PRICE_PER_SERV                               
                 FROM CSS_UNMTR_PLAN UP WITH(READUNCOMMITTED)                   
                     ,CSS_UM_EQUIPMENT L9 WITH(READUNCOMMITTED)                 
                 WHERE UP.RATE_PLAN_NO     = :UP-RATE-PLAN-NO           
                   AND UP.CODE_UTIL_TYPE   = :UP-CODE-UTIL-TYPE         
                   AND UP.VERSION_NO_CNTRL = :UP-VERSION-NO-CNTRL       
                   AND UP.UM_EQUIP_ID      = L9.UM_EQUIP_ID             
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UNMETERED_PLAN_CUR CURSOR FOR                            
MFA-TR*          SELECT UP.RATE_ITEM_CODE                                       
MFA-TR*                ,UP.UM_EQUIP_ID                                          
MFA-TR*                ,L9.UM_EQUIP_LONG_DESC                                   
MFA-TR*                ,L9.UM_EQUIP_KWH                                         
MFA-TR*                ,L9.UM_EQUIP_TYPE_CD                                     
MFA-TR*                ,UP.CUST_PER_SERVICE                                     
MFA-TR*                ,UP.PRICE_PER_SERV                                       
MFA-TR*          FROM CSS_UNMTR_PLAN UP                                         
MFA-TR*              ,CSS_UM_EQUIPMENT L9                                       
MFA-TR*          WHERE UP.RATE_PLAN_NO     = :UP-RATE-PLAN-NO                   
MFA-TR*            AND UP.CODE_UTIL_TYPE   = :UP-CODE-UTIL-TYPE                 
MFA-TR*            AND UP.VERSION_NO_CNTRL = :UP-VERSION-NO-CNTRL               
MFA-TR*            AND UP.UM_EQUIP_ID      = L9.UM_EQUIP_ID                     
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * CURSOR TO FETCH RATE FACTOR ADJUSTMENTS FOR EACH PRICE FOUND   *        
      * IN UNMETERED PLAN FOR THE CURRENT RATE VERSION.                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
               DECLARE UNMTR_RATEFCTR_CUR CURSOR FOR                    
                 SELECT SA.CODE_UTIL_TYPE                               
                       ,SA.RATE_PLAN_NO                                 
                       ,SA.FACTOR_ID                                    
                       ,SF.FACTOR_TEXT                                  
                       ,SF.ADJUST_ELEMENT                               
                       ,SA.FACTOR                                       
                 FROM CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)               
                     ,CSS_SPCL_FCTR SF WITH(READUNCOMMITTED)                    
                 WHERE SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO             
                   AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE           
                   AND SA.FACTOR_ID      = SF.FACTOR_ID                 
                   AND SF.CHECK_ELEMENT IN ('A','B')                    
                   AND SA.DATE_FROM =                                   
                       (SELECT MAX(SA2.DATE_FROM)                       
                        FROM CSS_SPCL_FCTR_APPL SA2
                           WITH(READUNCOMMITTED)                     
                        WHERE SA2.RATE_PLAN_NO = SA.RATE_PLAN_NO        
                        AND SA2.CODE_UTIL_TYPE = SA.CODE_UTIL_TYPE      
                        AND SA2.FACTOR_ID      = SA.FACTOR_ID           
                        AND SA2.CMPNT_ID_CD    = SA.CMPNT_ID_CD         
                        AND SA2.INSTR_USE_TYPE_CD = SA.INSTR_USE_TYPE_CD
                        AND SA2.CODE_SEASON    = SA.CODE_SEASON         
                        AND SA2.CODE_TIME_PERIOD = SA.CODE_TIME_PERIOD  
                        AND SA2.BLOCK_NO       = SA.BLOCK_NO            
                        AND SA2.CODE_STATUS    <> 'I'                   
                        AND SA2.DATE_FROM      <= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )         
                        AND SA2.DATE_TO        >= IIF(TRY_CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO) <> 0) OR (LEN(
                                                            :SA-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO), CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) ))          
             FOR READ ONLY                                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UNMTR_RATEFCTR_CUR CURSOR FOR                            
MFA-TR*          SELECT SA.CODE_UTIL_TYPE                                       
MFA-TR*                ,SA.RATE_PLAN_NO                                         
MFA-TR*                ,SA.FACTOR_ID                                            
MFA-TR*                ,SF.FACTOR_TEXT                                          
MFA-TR*                ,SF.ADJUST_ELEMENT                                       
MFA-TR*                ,SA.FACTOR                                               
MFA-TR*          FROM CSS_SPCL_FCTR_APPL SA                                     
MFA-TR*              ,CSS_SPCL_FCTR SF                                          
MFA-TR*          WHERE SA.RATE_PLAN_NO   = :SA-RATE-PLAN-NO                     
MFA-TR*            AND SA.CODE_UTIL_TYPE = :SA-CODE-UTIL-TYPE                   
MFA-TR*            AND SA.FACTOR_ID      = SF.FACTOR_ID                         
MFA-TR*            AND SF.CHECK_ELEMENT IN ('A','B')                            
MFA-TR*            AND SA.DATE_FROM =                                           
MFA-TR*                (SELECT MAX(SA2.DATE_FROM)                               
MFA-TR*                 FROM CSS_SPCL_FCTR_APPL SA2                             
MFA-TR*                 WHERE SA2.RATE_PLAN_NO = SA.RATE_PLAN_NO                
MFA-TR*                 AND SA2.CODE_UTIL_TYPE = SA.CODE_UTIL_TYPE              
MFA-TR*                 AND SA2.FACTOR_ID      = SA.FACTOR_ID                   
MFA-TR*                 AND SA2.CMPNT_ID_CD    = SA.CMPNT_ID_CD                 
MFA-TR*                 AND SA2.INSTR_USE_TYPE_CD = SA.INSTR_USE_TYPE_CD        
MFA-TR*                 AND SA2.CODE_SEASON    = SA.CODE_SEASON                 
MFA-TR*                 AND SA2.CODE_TIME_PERIOD = SA.CODE_TIME_PERIOD          
MFA-TR*                 AND SA2.BLOCK_NO       = SA.BLOCK_NO                    
MFA-TR*                 AND SA2.CODE_STATUS    <> 'I'                           
MFA-TR*                 AND SA2.DATE_FROM      <= :SA-DATE-FROM                 
MFA-TR*                 AND SA2.DATE_TO        >= :SA-DATE-TO)                  
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
       LINKAGE SECTION.                                                 
       01 PARM-SECURED-RATE-FL         PIC X(01).                       
       01 PARM-COMPANY-NO              PIC X(02).                       
       01 PARM-CODE-UTIL-TYPE          PIC X(01).                       
       01 PARM-RATE-PLAN-NO            PIC X(03).                       
       01 PARM-FROM-EFFECTIVE-DT       PIC X(10).                       
       01 PARM-RATE-DEPT-CD            PIC X(03).                       
      *                                                                         
       PROCEDURE DIVISION USING PARM-SECURED-RATE-FL                    
                              , PARM-COMPANY-NO                         
                              , PARM-CODE-UTIL-TYPE                     
                              , PARM-RATE-PLAN-NO                       
                              , PARM-FROM-EFFECTIVE-DT                  
                              , PARM-RATE-DEPT-CD.                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
                                                                        
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
                                                                        
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
                                                                        
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM  0100A-DECLARE-GTT   THRU 0100A-EXIT.                
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR04425_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR04425_R1
              (                                                          
               RETURN_CODE              INT                         
              ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,RATE_DEPT_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,RATE_DEPT_DESC CHAR(80)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,CODE_UTIL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,UTIL_TYPE_DESC CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2         
              ,RATE_PLAN_NO CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
              ,RATE_DESC CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,CMPNT_ID_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,RATE_CMPNT_DESC CHAR(60)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,CODE_USE_INST_TYPE CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,USE_INST_TYPE_DESC CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
              ,UNIT_CD CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2                
              ,UNIT_DESC CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2              
              ,CODE_SEASON CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,SEASON CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2                 
              ,CODE_TIME_PERIOD         SMALLINT                        
              ,TIME_PERIOD CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,BLOCK_NO                 SMALLINT                        
              ,BLOCK_SIZE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2             
              ,PRICE_TYPE_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
              ,PRICE_TYPE_DESC CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
              ,PRICE_GROUP CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2            
              ,PRICE                    DECIMAL(15,6)                   
              ,SORT_ORDER               SMALLINT                        
              ,LAST_ENERGY_BLOCK        SMALLINT                        
              ,LAST_DEM_BLOCK           SMALLINT                        
              ,RATE_ITEM_CODE           SMALLINT                        
              ,UM_EQUIP_KWH             SMALLINT                        
              ,VERS_PRORATE CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2           
             )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                    TO WS-SQLSTATE.             
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS    THRU 8000A-EXIT          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   CONTINUE                                             
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'              TO ACTIVE-PARAGRAPH         
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE GTT-NAME             TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
                  PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   RETURN_CODE                                          
                  ,COMPANY_NO                                           
                  ,RATE_DEPT_CD                                         
                  ,LTRIM(RTRIM(RATE_DEPT_DESC))     AS RATE_DEPT_DESC          
                  ,CODE_UTIL_TYPE                                       
                  ,LTRIM(RTRIM(UTIL_TYPE_DESC))     AS UTIL_TYPE_DESC          
                  ,RATE_PLAN_NO                                         
                  ,LTRIM(RTRIM(RATE_DESC))          AS RATE_DESC               
                  ,CMPNT_ID_CD                                          
                  ,LTRIM(RTRIM(RATE_CMPNT_DESC))    AS RATE_CMPNT_DESC         
                  ,CODE_USE_INST_TYPE                                   
                  ,LTRIM(RTRIM(USE_INST_TYPE_DESC)) AS 
           USE_INST_TYPE_DESC      
                  ,UNIT_CD                                              
                  ,LTRIM(RTRIM(UNIT_DESC))          AS UNIT_DESC               
                  ,CODE_SEASON                                          
                  ,LTRIM(RTRIM(SEASON))             AS SEASON                  
                  ,CODE_TIME_PERIOD                                     
                  ,LTRIM(RTRIM(TIME_PERIOD))        AS TIME_PERIOD             
                  ,BLOCK_NO                                             
                  ,BLOCK_SIZE                                           
                  ,PRICE_TYPE_CD                                        
                  ,LTRIM(RTRIM(PRICE_TYPE_DESC))    AS PRICE_TYPE_DESC         
                  ,LTRIM(RTRIM(PRICE_GROUP))        AS PRICE_GROUP             
                  ,PRICE                                                
                  ,SORT_ORDER                                           
                  ,LAST_ENERGY_BLOCK                                    
                  ,LAST_DEM_BLOCK                                       
                  ,RATE_ITEM_CODE                                       
                  ,UM_EQUIP_KWH                                         
                  ,LTRIM(RTRIM(VERS_PRORATE))       AS VERS_PRORATE            
               FROM                                                     
                   #CSR04425_R1                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,RATE_DEPT_CD                                                 
MFA-TR*           ,STRIP(RATE_DEPT_DESC)     AS RATE_DEPT_DESC                  
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,STRIP(UTIL_TYPE_DESC)     AS UTIL_TYPE_DESC                  
MFA-TR*           ,RATE_PLAN_NO                                                 
MFA-TR*           ,STRIP(RATE_DESC)          AS RATE_DESC                       
MFA-TR*           ,CMPNT_ID_CD                                                  
MFA-TR*           ,STRIP(RATE_CMPNT_DESC)    AS RATE_CMPNT_DESC                 
MFA-TR*           ,CODE_USE_INST_TYPE                                           
MFA-TR*           ,STRIP(USE_INST_TYPE_DESC) AS USE_INST_TYPE_DESC              
MFA-TR*           ,UNIT_CD                                                      
MFA-TR*           ,STRIP(UNIT_DESC)          AS UNIT_DESC                       
MFA-TR*           ,CODE_SEASON                                                  
MFA-TR*           ,STRIP(SEASON)             AS SEASON                          
MFA-TR*           ,CODE_TIME_PERIOD                                             
MFA-TR*           ,STRIP(TIME_PERIOD)        AS TIME_PERIOD                     
MFA-TR*           ,BLOCK_NO                                                     
MFA-TR*           ,BLOCK_SIZE                                                   
MFA-TR*           ,PRICE_TYPE_CD                                                
MFA-TR*           ,STRIP(PRICE_TYPE_DESC)    AS PRICE_TYPE_DESC                 
MFA-TR*           ,STRIP(PRICE_GROUP)        AS PRICE_GROUP                     
MFA-TR*           ,PRICE                                                        
MFA-TR*           ,SORT_ORDER                                                   
MFA-TR*           ,LAST_ENERGY_BLOCK                                            
MFA-TR*           ,LAST_DEM_BLOCK                                               
MFA-TR*           ,RATE_ITEM_CODE                                               
MFA-TR*           ,UM_EQUIP_KWH                                                 
MFA-TR*           ,STRIP(VERS_PRORATE)       AS VERS_PRORATE                    
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR04425_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *                                                                *        
      *     CALLED BY: 0000-MAINLINE                                   *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-VALIDATE-INPUT                                  
              THRU 1100-EXIT.                                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-VALIDATE-INPUT                                            *        
      *                                                                *        
      *     1. RECEIVE & VALIDATE EACH PARAMETER PASSED                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1100-VALIDATE-INPUT.                                             
                                                                        
           SET VALID-PARAMETER      TO TRUE.                            
           SET RATE-PLAN-NOT-PASSED TO TRUE.                            
                                                                        
           MOVE WS-NO               TO WS-FILTER-BY-RATE                
                                       WS-FILTER-BY-UTIL                
                                       WS-FILTER-BY-COMP                
                                       WS-FILTER-BY-RDEPT               
                                       WS-FILTER-BY-DATE                
                                       WS-FILTER-BY-SECURE.             
                                                                        
           PERFORM 7910-GET-CURRENT-DT       THRU 7910-EXIT.            
                                                                        
      *    UTILITY TYPE IS A REQUIRED PARAMETER.  IF VALID UTILITY TYPE         
      *    ISN'T PASSED THEN ERROR AND RETURN.                                  
           IF PARM-CODE-UTIL-TYPE > SPACES                              
              MOVE PARM-CODE-UTIL-TYPE     TO WS-CODE-UTIL-TYPE         
              MOVE WS-YES                  TO WS-FILTER-BY-UTIL         
              EVALUATE WS-CODE-UTIL-TYPE                                
                 WHEN WS-ELEC                                           
                 WHEN WS-GAS                                            
                    MOVE WS-METERED    TO WS-METERED-FL                 
                 WHEN WS-UNMETERED                                      
                    MOVE WS-UNMETERED  TO WS-METERED-FL                 
                 WHEN OTHER                                             
                    MOVE WS-INVALID-UTIL-TYPE TO RS-RATE-DEPT-DESC      
                    PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT      
                    PERFORM 9999-END-PROGRAM       THRU 9999-EXIT       
              END-EVALUATE                                              
           ELSE                                                         
              MOVE WS-INVALID-UTIL-TYPE TO RS-RATE-DEPT-DESC            
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              PERFORM 9999-END-PROGRAM       THRU 9999-EXIT             
           END-IF.                                                      
                                                                        
           IF PARM-SECURED-RATE-FL > SPACES                             
              MOVE PARM-SECURED-RATE-FL   TO WS-SECURED-RATE-FL         
              MOVE WS-YES                 TO WS-FILTER-BY-SECURE        
           END-IF.                                                      
                                                                        
           IF PARM-RATE-PLAN-NO > SPACES                                
              SET RATE-PLAN-PASSED TO TRUE                              
              MOVE PARM-RATE-PLAN-NO      TO WS-RATE-PLAN-NO            
              MOVE WS-YES                 TO WS-FILTER-BY-RATE          
           END-IF.                                                      
                                                                        
           IF PARM-COMPANY-NO > SPACES                                  
              MOVE PARM-COMPANY-NO        TO WS-COMPANY-NO              
              MOVE WS-YES                 TO WS-FILTER-BY-COMP          
           END-IF.                                                      
                                                                        
           IF PARM-RATE-DEPT-CD > SPACES                                
              MOVE PARM-RATE-DEPT-CD      TO WS-RATE-DEPT-CD            
              MOVE WS-YES                 TO WS-FILTER-BY-RDEPT         
           END-IF.                                                      
                                                                        
           IF PARM-FROM-EFFECTIVE-DT > SPACES                           
              PERFORM 7900-VALIDATE-EFF-DT   THRU 7900-EXIT             
              MOVE WS-YES                 TO WS-FILTER-BY-DATE          
           END-IF.                                                      
                                                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           IF VALID-PARAMETER                                           
              PERFORM 7100-OPEN-RATE-PLAN-VRSN-CSR  THRU 7100-EXIT      
              PERFORM 7200-FETCH-RATE-PLAN-VRSN-CSR THRU 7200-EXIT      
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE WS-RATE-VRSN-NOT-FOUND    TO RS-RATE-DEPT-DESC    
                 PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
              ELSE                                                      
                 PERFORM 2100-PROCESS-RATE-VERSION     THRU 2100-EXIT   
                     UNTIL END-OF-CURSOR-7200                           
              END-IF                                                    
              PERFORM 7300-CLOSE-RATE-PLAN-VRSN-CSR THRU 7300-EXIT      
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
                                                                        
             INITIALIZE GTT-RETURN-FIELDS.                              
                                                                        
             MOVE RS-RETURN-CODE         TO  S-RETURN-CODE.             
             MOVE RS-COMPANY-NO          TO  S-COMPANY-NO.              
             MOVE RS-RATE-DEPT-CD        TO  S-RATE-DEPT-CD.            
             MOVE RS-RATE-DEPT-DESC      TO  S-RATE-DEPT-DESC.          
             MOVE RS-CODE-UTIL-TYPE      TO  S-CODE-UTIL-TYPE.          
             MOVE RS-UTIL-TYPE-DESC      TO  S-UTIL-TYPE-DESC.          
             MOVE RS-RATE-PLAN-NO        TO  S-RATE-PLAN-NO.            
             MOVE RS-RATE-DESC           TO  S-RATE-DESC.               
             MOVE RS-CMPNT-ID-CD         TO  S-CMPNT-ID-CD.             
             MOVE RS-RATE-CMPNT-DESC     TO  S-RATE-CMPNT-DESC.         
             MOVE RS-CODE-USE-INST-TYPE  TO  S-CODE-USE-INST-TYPE.      
             MOVE RS-USE-INST-TYPE-DESC  TO  S-USE-INST-TYPE-DESC.      
             MOVE RS-UNIT-CD             TO  S-UNIT-CD.                 
             MOVE RS-UNIT-DESC           TO  S-UNIT-DESC.               
             MOVE RS-CODE-SEASON         TO  S-CODE-SEASON.             
             MOVE RS-SEASON              TO  S-SEASON.                  
             MOVE RS-CODE-TIME-PERIOD    TO  S-CODE-TIME-PERIOD.        
             MOVE RS-TIME-PERIOD         TO  S-TIME-PERIOD.             
             MOVE RS-BLOCK-NO            TO  S-BLOCK-NO.                
             MOVE RS-BLOCK-SIZE          TO  S-BLOCK-SIZE.              
             MOVE RS-PRICE-TYPE-CD       TO  S-PRICE-TYPE-CD.           
             MOVE RS-PRICE-TYPE-DESC     TO  S-PRICE-TYPE-DESC.         
             MOVE RS-PRICE-GROUP         TO  S-PRICE-GROUP.             
             MOVE RS-PRICE               TO  S-PRICE.                   
             MOVE RS-SORT-ORDER          TO  S-SORT-ORDER.              
             MOVE RS-LAST-ENERGY-BLOCK   TO  S-LAST-ENERGY-BLOCK.       
             MOVE RS-LAST-DEM-BLOCK      TO  S-LAST-DEM-BLOCK.          
             MOVE RS-RATE-ITEM-CODE      TO  S-RATE-ITEM-CODE.          
             MOVE RS-UM-EQUIP-KWH        TO  S-UM-EQUIP-KWH.            
             MOVE RS-VERS-PRORATE        TO  S-VERS-PRORATE.            
                                                                        
             PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.            
                                                                        
       2000A-EXIT.                                                      
             EXIT.                                                      
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2100-PROCESS-RATE-VERSION                                      *        
      ******************************************************************        
       2100-PROCESS-RATE-VERSION.                                       
                                                                        
           MOVE RD-COMPANY-NO            TO RS-COMPANY-NO.              
           MOVE RD-RATE-DEPT-CD          TO RS-RATE-DEPT-CD.            
           MOVE RD-RATE-DESC             TO RS-RATE-DESC.               
           MOVE RD-CODE-UTIL-TYPE        TO J4-CODE-UTIL-TYPE           
                                            SA-CODE-UTIL-TYPE           
                                            PS-CODE-UTIL-TYPE           
                                            UP-CODE-UTIL-TYPE           
                                            RS-CODE-UTIL-TYPE.          
           MOVE UV-CODE-SHORT-DESC-TEXT  TO RS-UTIL-TYPE-DESC.          
           MOVE RD-RATE-PLAN-NO          TO J4-RATE-PLAN-NO             
                                            PS-RATE-PLAN-NO             
                                            SA-RATE-PLAN-NO             
                                            UP-RATE-PLAN-NO             
                                            RS-RATE-PLAN-NO.            
           MOVE UV2-CODE-SHORT-DESC-TEXT TO RS-RATE-DEPT-DESC.          
           MOVE RT-VERSION-NO-CNTRL      TO J4-VERSION-NO-CNTRL         
                                            PS-VERSION-NO-CNTRL         
                                            UP-VERSION-NO-CNTRL.        
                                                                        
           MOVE UV9-CODE-SHORT-DESC-TEXT TO RS-VERS-PRORATE.            
                                                                        
           IF WS-FILTER-BY-DATE EQUAL WS-YES                            
              MOVE WS-FROM-EFF-DT           TO SA-DATE-FROM             
                                               SA-DATE-TO               
           ELSE                                                         
              MOVE '2999-12-31'             TO SA-DATE-FROM             
                                               SA-DATE-TO               
           END-IF.                                                      
                                                                        
           IF WS-METERED-FL = WS-METERED                                
              PERFORM 2200-PROCESS-METERED  THRU 2200-EXIT              
           ELSE                                                         
              PERFORM 3000-PROCESS-UNMETERD THRU 3000-EXIT              
           END-IF.                                                      
                                                                        
           MOVE SPACES                   TO UV-CODE-SHORT-DESC-TEXT     
                                            UV2-CODE-SHORT-DESC-TEXT    
                                            UV9-CODE-SHORT-DESC-TEXT.   
           INITIALIZE TDS-RETURN-FIELDS.                                
                                                                        
           PERFORM 7200-FETCH-RATE-PLAN-VRSN-CSR  THRU 7200-EXIT.       
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * GET SUMMER BFC, WINTER BFC, FIXED PRICE, PER UNIT PRICE        *        
      * 2200-PROCESS-METERED                                           *        
      ******************************************************************        
       2200-PROCESS-METERED.                                            
                                                                        
           PERFORM 7400-GET-SUMMER-BFC            THRU 7400-EXIT.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'S'                      TO RS-CODE-SEASON           
              MOVE 'SUMMER'                 TO RS-SEASON                
              MOVE 0                        TO RS-BLOCK-NO              
                                               RS-LAST-ENERGY-BLOCK     
                                               RS-LAST-DEM-BLOCK        
                                               RS-RATE-ITEM-CODE        
                                               RS-UM-EQUIP-KWH          
              MOVE 30                       TO RS-SORT-ORDER            
              MOVE J4-AMT-CUST-CHRG         TO RS-PRICE                 
              MOVE '0'                      TO RS-CMPNT-ID-CD           
              MOVE 'BASIC FACILITY CHARGE'  TO RS-RATE-CMPNT-DESC       
              MOVE 'MARGIN'                 TO RS-PRICE-GROUP           
              MOVE +0                       TO RS-CODE-TIME-PERIOD      
              MOVE SPACES                   TO RS-CODE-USE-INST-TYPE    
                                               RS-USE-INST-TYPE-DESC    
                                               RS-UNIT-CD               
                                               RS-UNIT-DESC             
                                               RS-TIME-PERIOD           
                                               RS-BLOCK-SIZE            
                                               RS-PRICE-TYPE-CD         
                                               RS-PRICE-TYPE-DESC       
              PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
           END-IF.                                                      
                                                                        
           MOVE 'N'                          TO RS-CODE-SEASON.         
           MOVE 'NON-SUMMER'                 TO RS-SEASON.              
           SET WS-WINTER-BFC-NOT-EXISTS TO TRUE                         
           PERFORM 7500-GET-WINTER-BFC      THRU 7500-EXIT              
           IF WS-WINTER-BFC-EXISTS                                      
              COMPUTE RS-PRICE = J4-AMT-CUST-CHRG + SA-FACTOR           
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
                                                                        
           SET NOT-END-OF-CURSOR-7620 TO TRUE.                          
           PERFORM 7610-OPEN-FIXED-RT-SCHED-CSR   THRU 7610-EXIT.       
           PERFORM 7620-FETCH-FIXED-RT-SCHED-CSR  THRU 7620-EXIT.       
           PERFORM 2300-PROCESS-FIXED-RT-SCHED    THRU 2300-EXIT        
             UNTIL END-OF-CURSOR-7620.                                  
           PERFORM 7630-CLOSE-FIXED-RT-SCHED-CSR  THRU 7630-EXIT.       
                                                                        
      ***  PROCESS SUMMER PRICES                                                
           MOVE 'S' TO WS-CODE-SEASON                                   
                       PS-CODE-SEASON.                                  
           SET NOT-END-OF-CURSOR-7650 TO TRUE.                          
           PERFORM 7640-OPEN-RT-SCHED-PRICE-CSR   THRU 7640-EXIT.       
           PERFORM 7650-FETCH-RT-SCHED-PRICE-CSR  THRU 7650-EXIT.       
           PERFORM 2400-PROCESS-RT-SCHED-PRICE    THRU 2400-EXIT        
             UNTIL END-OF-CURSOR-7650.                                  
           PERFORM 7660-CLOSE-RT-SCHED-PRICE-CSR  THRU 7660-EXIT.       
                                                                        
      ***  PROCESS NON-SUMMER PRICES                                            
           MOVE 'N' TO WS-CODE-SEASON                                   
                       PS-CODE-SEASON.                                  
           SET NOT-END-OF-CURSOR-7650 TO TRUE.                          
           PERFORM 7640-OPEN-RT-SCHED-PRICE-CSR   THRU 7640-EXIT.       
           PERFORM 7650-FETCH-RT-SCHED-PRICE-CSR  THRU 7650-EXIT.       
           PERFORM 2400-PROCESS-RT-SCHED-PRICE    THRU 2400-EXIT        
             UNTIL END-OF-CURSOR-7650.                                  
           PERFORM 7660-CLOSE-RT-SCHED-PRICE-CSR  THRU 7660-EXIT.       
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2300-PROCESS-FIXED-RT-SCHED                                    *        
      ******************************************************************        
       2300-PROCESS-FIXED-RT-SCHED.                                     
                                                                        
           MOVE PS-CMPNT-ID-CD           TO RS-CMPNT-ID-CD.             
           MOVE N6-RATE-CMPNT-DESC       TO RS-RATE-CMPNT-DESC.         
           MOVE PS-CODE-USE-INST-TYPE    TO RS-CODE-USE-INST-TYPE.      
           MOVE UV3-CODE-SHORT-DESC-TEXT TO RS-USE-INST-TYPE-DESC.      
           MOVE UV4-CODE-SHORT-DESC-TEXT TO RS-PRICE-TYPE-DESC.         
           MOVE WS-UNIT-CD               TO RS-UNIT-CD.                 
           MOVE SPACES                   TO WS-UNIT-DESC.               
           EVALUATE TRUE                                                
              WHEN PS-CODE-USE-INST-TYPE = 'R' AND WS-UNIT-CD = 'B'     
                 MOVE 'KWH'     TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'R' AND WS-UNIT-CD = 'C'     
                 MOVE 'THERMS'  TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'R' AND WS-UNIT-CD = 'D'     
                 MOVE 'DT'      TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'D' AND WS-UNIT-CD = 'E'     
                 MOVE 'KVA'     TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'D' AND WS-UNIT-CD = 'J'     
                 MOVE 'KW'      TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'D' AND WS-UNIT-CD = 'Q'     
                 MOVE 'MDQ'     TO WS-UNIT-DESC                         
           END-EVALUATE.                                                
           MOVE WS-UNIT-DESC             TO RS-UNIT-DESC.               
                                                                        
           MOVE PS-CODE-SEASON           TO RS-CODE-SEASON.             
           MOVE UV6-CODE-SHORT-DESC-TEXT TO RS-SEASON.                  
           MOVE PS-CODE-TIME-PERIOD      TO RS-CODE-TIME-PERIOD.        
           MOVE UV7-CODE-SHORT-DESC-TEXT TO RS-TIME-PERIOD.             
           MOVE PS-BLOCK-NO              TO RS-BLOCK-NO.                
                                                                        
           PERFORM 7920-COUNT-NUMBER-BLOCKS       THRU 7920-EXIT.       
           IF PS-CODE-USE-INST-TYPE EQUAL 'R'                           
              MOVE WS-NUMBER-BLOCKS         TO RS-LAST-ENERGY-BLOCK     
              MOVE 0                        TO RS-LAST-DEM-BLOCK        
           ELSE                                                         
              MOVE WS-NUMBER-BLOCKS         TO RS-LAST-DEM-BLOCK        
              MOVE 0                        TO RS-LAST-ENERGY-BLOCK     
           END-IF.                                                      
                                                                        
           MOVE PS-BLOCK-USE-OR-SVCS     TO RS-BLOCK-SIZE.              
           MOVE PS-PRICE-TYPE-CD         TO RS-PRICE-TYPE-CD.           
           MOVE 'MARGIN'                 TO RS-PRICE-GROUP.             
           MOVE PS-SCHED-PRICE-AM        TO RS-PRICE.                   
           MOVE 30                       TO RS-SORT-ORDER.              
                                                                        
           PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
                                                                        
           MOVE SPACES                   TO UV3-CODE-SHORT-DESC-TEXT    
                                            UV4-CODE-SHORT-DESC-TEXT    
                                            UV6-CODE-SHORT-DESC-TEXT    
                                            UV7-CODE-SHORT-DESC-TEXT    
                                            WS-UNIT-CD.                 
                                                                        
           MOVE 0                        TO WS-NUMBER-BLOCKS.           
                                                                        
           PERFORM 7620-FETCH-FIXED-RT-SCHED-CSR  THRU 7620-EXIT.       
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 2400-PROCESS-RT-SCHED-PRICE                                    *        
      ******************************************************************        
       2400-PROCESS-RT-SCHED-PRICE.                                     
                                                                        
           MOVE PS-CMPNT-ID-CD           TO RS-CMPNT-ID-CD              
                                            SA-CMPNT-ID-CD.             
           MOVE N6-RATE-CMPNT-DESC       TO RS-RATE-CMPNT-DESC.         
           MOVE PS-CODE-USE-INST-TYPE    TO RS-CODE-USE-INST-TYPE       
                                            SA-INSTR-USE-TYPE-CD.       
           MOVE UV5-CODE-SHORT-DESC-TEXT TO RS-USE-INST-TYPE-DESC.      
           MOVE UV6-CODE-SHORT-DESC-TEXT TO RS-SEASON.                  
           MOVE UV7-CODE-SHORT-DESC-TEXT TO RS-TIME-PERIOD.             
           MOVE UV8-CODE-SHORT-DESC-TEXT TO RS-PRICE-TYPE-DESC.         
                                                                        
           MOVE WS-UNIT-CD               TO RS-UNIT-CD.                 
           MOVE SPACES                   TO WS-UNIT-DESC.               
           EVALUATE TRUE                                                
              WHEN PS-CODE-USE-INST-TYPE = 'R' AND WS-UNIT-CD = 'B'     
                 MOVE 'KWH'     TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'R' AND WS-UNIT-CD = 'C'     
                 MOVE 'THERMS'  TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'R' AND WS-UNIT-CD = 'D'     
                 MOVE 'DT'      TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'D' AND WS-UNIT-CD = 'E'     
                 MOVE 'KVA'     TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'D' AND WS-UNIT-CD = 'J'     
                 MOVE 'KW'      TO WS-UNIT-DESC                         
              WHEN PS-CODE-USE-INST-TYPE = 'D' AND WS-UNIT-CD = 'Q'     
                 MOVE 'MDQ'     TO WS-UNIT-DESC                         
           END-EVALUATE.                                                
           MOVE WS-UNIT-DESC             TO RS-UNIT-DESC.               
           MOVE WS-CODE-SEASON           TO RS-CODE-SEASON              
                                            SA-CODE-SEASON.             
           MOVE PS-CODE-TIME-PERIOD      TO RS-CODE-TIME-PERIOD         
                                            SA-CODE-TIME-PERIOD.        
           MOVE PS-BLOCK-NO              TO RS-BLOCK-NO                 
                                            SA-BLOCK-NO.                
                                                                        
           PERFORM 7920-COUNT-NUMBER-BLOCKS       THRU 7920-EXIT.       
           IF PS-CODE-USE-INST-TYPE EQUAL 'R'                           
              MOVE WS-NUMBER-BLOCKS         TO RS-LAST-ENERGY-BLOCK     
              MOVE 0                        TO RS-LAST-DEM-BLOCK        
           ELSE                                                         
              MOVE WS-NUMBER-BLOCKS         TO RS-LAST-DEM-BLOCK        
              MOVE 0                        TO RS-LAST-ENERGY-BLOCK     
           END-IF.                                                      
                                                                        
           MOVE PS-BLOCK-USE-OR-SVCS     TO RS-BLOCK-SIZE.              
           MOVE PS-PRICE-TYPE-CD         TO RS-PRICE-TYPE-CD.           
           MOVE 'MARGIN'                 TO RS-PRICE-GROUP.             
           MOVE PS-SCHED-PRICE-AM        TO RS-PRICE.                   
           MOVE 30                       TO RS-SORT-ORDER.              
                                                                        
           PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
                                                                        
           SET NOT-END-OF-CURSOR-7680 TO TRUE.                          
           PERFORM 7670-OPEN-RT-FCTR-ADJUST-CSR   THRU 7670-EXIT.       
           PERFORM 7680-FETCH-RT-FCTR-ADJUST-CSR  THRU 7680-EXIT.       
           PERFORM 2500-PROCESS-RT-FCTR-ADJUST    THRU 2500-EXIT        
             UNTIL END-OF-CURSOR-7680.                                  
           PERFORM 7690-CLOSE-RT-FCTR-ADJUST-CSR  THRU 7690-EXIT.       
                                                                        
           MOVE SPACES                   TO UV5-CODE-SHORT-DESC-TEXT    
                                            UV6-CODE-SHORT-DESC-TEXT    
                                            UV7-CODE-SHORT-DESC-TEXT    
                                            UV8-CODE-SHORT-DESC-TEXT    
                                            WS-UNIT-CD                  
                                            WS-UNIT-DESC.               
                                                                        
           MOVE 0                        TO WS-NUMBER-BLOCKS.           
                                                                        
           PERFORM 7650-FETCH-RT-SCHED-PRICE-CSR  THRU 7650-EXIT.       
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *2500-PROCESS-RT-FCTR-ADJUST                                     *        
      ******************************************************************        
       2500-PROCESS-RT-FCTR-ADJUST.                                     
                                                                        
           IF SF-ADJUST-ELEMENT EQUAL 'H' OR 'I' OR 'J' OR 'K'          
              COMPUTE SA-FACTOR = SA-FACTOR * -1                        
           END-IF.                                                      
                                                                        
           MOVE SA-FACTOR                TO RS-PRICE.                   
           MOVE SA-FACTOR-ID             TO RS-PRICE-GROUP.             
           MOVE 40                       TO RS-SORT-ORDER.              
                                                                        
           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
           PERFORM 7680-FETCH-RT-FCTR-ADJUST-CSR  THRU 7680-EXIT.       
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 3000-PROCESS-UNMETERD.                                         *        
      ******************************************************************        
       3000-PROCESS-UNMETERD.                                           
                                                                        
           SET NOT-END-OF-CURSOR-7820 TO TRUE.                          
                                                                        
           PERFORM 7810-OPEN-UNMETERED-PLAN-CSR   THRU 7810-EXIT.       
                                                                        
           PERFORM 7820-FETCH-UNMETERED-PLAN-CSR  THRU 7820-EXIT.       
                                                                        
           PERFORM 3100-PROCESS-UNMETRED-PRICE    THRU 3100-EXIT        
             UNTIL END-OF-CURSOR-7820.                                  
                                                                        
           PERFORM 7830-CLOSE-UNMETERED-PLAN-CSR  THRU 7830-EXIT.       
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 3100-PROCESS-UNMETRED-PRICE                                    *        
      ******************************************************************        
       3100-PROCESS-UNMETRED-PRICE.                                     
                                                                        
           MOVE UP-UM-EQUIP-ID           TO RS-CMPNT-ID-CD.             
           MOVE L9-UM-EQUIP-LONG-DESC    TO RS-RATE-CMPNT-DESC.         
           MOVE 'U'                      TO RS-CODE-USE-INST-TYPE.      
           MOVE UV2-CODE-SHORT-DESC-TEXT TO RS-USE-INST-TYPE-DESC.      
           MOVE UP-RATE-ITEM-CODE        TO RS-RATE-ITEM-CODE.          
           MOVE L9-UM-EQUIP-KWH          TO RS-UM-EQUIP-KWH.            
           MOVE 0                        TO RS-LAST-ENERGY-BLOCK        
                                            RS-LAST-DEM-BLOCK           
                                            RS-BLOCK-NO                 
                                            RS-BLOCK-SIZE.              
                                                                        
           MOVE 'TOTAL'                  TO RS-PRICE-GROUP.             
           MOVE UP-PRICE-PER-SERV        TO RS-PRICE                    
           MOVE 50                       TO RS-SORT-ORDER               
           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
                                                                        
           SET NOT-END-OF-CURSOR-7860 TO TRUE.                          
           PERFORM 7850-OPEN-UNMTR-RATEFCTR-CSR   THRU 7850-EXIT.       
           PERFORM 7860-FETCH-UNMTR-RATEFCTR-CSR  THRU 7860-EXIT.       
                                                                        
           MOVE 'MARGIN'                 TO RS-PRICE-GROUP.             
           PERFORM 3300-PROCESS-MARGIN-PRICE      THRU 3300-EXIT        
             UNTIL END-OF-CURSOR-7860.                                  
           PERFORM 7870-CLOSE-UNMTR-RATEFCTR-CSR  THRU 7870-EXIT.       
           COMPUTE WS-COMPUTE-PRICE-2 ROUNDED = UP-PRICE-PER-SERV * 1   
           MOVE WS-COMPUTE-PRICE-2       TO RS-PRICE.                   
                                                                        
           MOVE +0                       TO RS-CODE-TIME-PERIOD.        
           MOVE SPACES                   TO RS-UNIT-CD                  
                                            RS-CODE-SEASON              
                                            RS-SEASON                   
                                            RS-TIME-PERIOD              
                                            RS-PRICE-TYPE-CD            
                                            RS-PRICE-TYPE-DESC.         
           MOVE 30                       TO RS-SORT-ORDER.              
                                                                        
           PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT.      
                                                                        
           SET NOT-END-OF-CURSOR-7860 TO TRUE.                          
           PERFORM 7850-OPEN-UNMTR-RATEFCTR-CSR   THRU 7850-EXIT.       
           PERFORM 7860-FETCH-UNMTR-RATEFCTR-CSR  THRU 7860-EXIT.       
           PERFORM 3200-PROCESS-UNMTR-RATEFCTR    THRU 3200-EXIT        
             UNTIL END-OF-CURSOR-7860.                                  
           PERFORM 7870-CLOSE-UNMTR-RATEFCTR-CSR  THRU 7870-EXIT.       
                                                                        
           MOVE SPACES                   TO UV2-CODE-SHORT-DESC-TEXT    
                                            UV9-CODE-SHORT-DESC-TEXT.   
                                                                        
           PERFORM 7820-FETCH-UNMETERED-PLAN-CSR  THRU 7820-EXIT.       
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 3200-PROCESS-UNMTR-RATEFCTR                                    *        
      ******************************************************************        
       3200-PROCESS-UNMTR-RATEFCTR.                                     
                                                                        
           MOVE L9-UM-EQUIP-KWH          TO RS-UNIT-DESC.               
           MOVE 0                        TO RS-BLOCK-NO                 
                                            RS-LAST-ENERGY-BLOCK        
                                            RS-LAST-DEM-BLOCK.          
           MOVE UP-CUST-PER-SERVICE      TO RS-BLOCK-SIZE.              
           IF SF-ADJUST-ELEMENT EQUAL 'H' OR 'I' OR 'J' OR 'K'          
              COMPUTE SA-FACTOR = SA-FACTOR * -1                        
           END-IF.                                                      
           MOVE SA-FACTOR-ID             TO RS-PRICE-GROUP.             
           MOVE SA-FACTOR                TO RS-PRICE.                   
           MOVE 40                       TO RS-SORT-ORDER.              
                                                                        
ACT189     IF L9-UM-EQUIP-TYPE-CD = 'P'                                 
ACT189        MOVE 0 TO RS-PRICE                                        
ACT189     END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
                                                                        
           PERFORM 7860-FETCH-UNMTR-RATEFCTR-CSR THRU 7860-EXIT.        
                                                                        
       3200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 3300-PROCESS-MARGIN-PRICE                                      *        
      ******************************************************************        
       3300-PROCESS-MARGIN-PRICE.                                       
                                                                        
           IF SF-ADJUST-ELEMENT EQUAL 'G'                               
              COMPUTE UP-PRICE-PER-SERV =                               
                 UP-PRICE-PER-SERV - (SA-FACTOR * L9-UM-EQUIP-KWH)      
           END-IF.                                                      
                                                                        
           PERFORM 7860-FETCH-UNMTR-RATEFCTR-CSR THRU 7860-EXIT.        
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-OPEN-RATE-PLAN-VRSN-CSR                                   *        
      ******************************************************************        
       7100-OPEN-RATE-PLAN-VRSN-CSR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN RATE_PLAN_VRSN_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7100-OPEN-RATE-PLAN-VRSN-CSR'                       
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN'            TO TABLE-1                
              MOVE 'METERED_FL'               TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-3        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
              MOVE WS-METERED-FL              TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-FETCH-RATE-PLAN-VRSN-CSR                                  *        
      ******************************************************************        
       7200-FETCH-RATE-PLAN-VRSN-CSR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH RATE_PLAN_VRSN_CUR                                  
               INTO :RD-COMPANY-NO                                      
                   ,:RD-CODE-UTIL-TYPE                                  
                   ,:UV-CODE-SHORT-DESC                                 
                   ,:RD-RATE-PLAN-NO                                    
                   ,:RD-RATE-DESC                                       
                   ,:RD-RATE-DEPT-CD                                    
                   ,:WS-UV2-CODE-SHORT-DESC                             
                   ,:RT-VERSION-NO-CNTRL                                
                   ,:RT-FROM-EFFECTIVE-DT                               
                   ,:WS-UV9-CODE-SHORT-DESC                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET END-OF-CURSOR-7200 TO TRUE                      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME               TO ABEND-PROGRAM    
                    MOVE '7200-FETCH-RATE-PLAN-VRSN-CSR'                
                                              TO RS-RATE-DEPT-DESC      
                    MOVE '7200'                     TO ACTIVE-PARAGRAPH 
                    MOVE 'FETCH'                    TO ABEND-FUNCTION   
                    MOVE 'CSS_RATE_PLAN'            TO TABLE-1          
                    MOVE 'METERED_FL'               TO TABLE-ELEMENT-1  
                    MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-3  
                    MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2  
                    MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4  
                    MOVE WS-METERED-FL              TO HOSTVAR-ELEMENT-1
                    MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2
                    MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3
                    MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-4
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-CLOSE-RATE-PLAN-VRSN-CSR                                  *        
      ******************************************************************        
       7300-CLOSE-RATE-PLAN-VRSN-CSR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE RATE_PLAN_VRSN_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300-CLOSE-RATE-PLAN-VRSN-CSR'                      
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_PLAN'            TO TABLE-1                
              MOVE 'METERED_FL'               TO TABLE-ELEMENT-1        
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-2        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-3        
              MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-4        
              MOVE WS-METERED-FL              TO HOSTVAR-ELEMENT-1      
              MOVE WS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-2      
              MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3      
              MOVE WS-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7400-GET-SUMMER-BFC                                            *        
      ******************************************************************        
       7400-GET-SUMMER-BFC.                                             
                                                                        
           EXEC SQL                                                     
               SELECT J4.AMT_CUST_CHRG                                  
                 INTO :J4-AMT-CUST-CHRG                                 
                 FROM CSS_RATE_VRSN_DEF J4 WITH(READUNCOMMITTED)                
                WHERE J4.RATE_PLAN_NO     = :J4-RATE-PLAN-NO            
                  AND J4.CODE_UTIL_TYPE   = :J4-CODE-UTIL-TYPE          
                  AND J4.VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT J4.AMT_CUST_CHRG                                          
MFA-TR*          INTO :J4-AMT-CUST-CHRG                                         
MFA-TR*          FROM CSS_RATE_VRSN_DEF J4                                      
MFA-TR*         WHERE J4.RATE_PLAN_NO     = :J4-RATE-PLAN-NO                    
MFA-TR*           AND J4.CODE_UTIL_TYPE   = :J4-CODE-UTIL-TYPE                  
MFA-TR*           AND J4.VERSION_NO_CNTRL = :J4-VERSION-NO-CNTRL                
MFA-TR*           WITH UR                                                       
MFA-TR*             QUERYNO 7400                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7400-GET-SUMMER-BFC         '                       
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7400'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RATE_VRSN_DEF'        TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CTRL'          TO TABLE-ELEMENT-3        
              MOVE J4-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE J4-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE J4-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7500-GET-WINTER-BFC                                            *        
      ******************************************************************        
       7500-GET-WINTER-BFC.                                             
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              SA.FACTOR,
              SF.ADJUST_ELEMENT,
              SA.FACTOR_ID                                      
               INTO  :WS-WINTER-BFC                                     
                    ,:SA-FACTOR                                         
                    ,:SF-ADJUST-ELEMENT                                 
                    ,:SA-FACTOR-ID                                      
               FROM  CSS_SPCL_FCTR_APPL SA WITH(READUNCOMMITTED)                
                    ,CSS_SPCL_FCTR      SF WITH(READUNCOMMITTED)                
               WHERE  SA.FACTOR_ID       = SF.FACTOR_ID                 
                 AND  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE           
                 AND  SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO             
                 AND  SA.CODE_STATUS     IN ('A','T')                   
                 AND  SF.ADJUST_ELEMENT  IN ('L','O')                   
                 AND  SA.DATE_FROM       <= IIF(TRY_CONVERT(DATE, 
                                                          :SA-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-FROM
              ) <> 0) OR (LEN(:SA-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                          :SA-DATE-FROM
              ), CONVERT(DATE, :SA-DATE-FROM) )               
                 AND  SA.DATE_TO         >= IIF(TRY_CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :SA-DATE-TO) <> 0) OR (LEN(
                                                            :SA-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:SA-DATE-TO), CONVERT(DATE, 
                                                            :SA-DATE-TO
              ) )                 
                 ORDER BY SA.ENTRY_NO DESC                              
                                                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*              ,SA.FACTOR                                                 
MFA-TR*              ,SF.ADJUST_ELEMENT                                         
MFA-TR*              ,SA.FACTOR_ID                                              
MFA-TR*        INTO  :WS-WINTER-BFC                                             
MFA-TR*             ,:SA-FACTOR                                                 
MFA-TR*             ,:SF-ADJUST-ELEMENT                                         
MFA-TR*             ,:SA-FACTOR-ID                                              
MFA-TR*        FROM  CSS_SPCL_FCTR_APPL SA                                      
MFA-TR*             ,CSS_SPCL_FCTR      SF                                      
MFA-TR*        WHERE  SA.FACTOR_ID       = SF.FACTOR_ID                         
MFA-TR*          AND  SA.CODE_UTIL_TYPE  = :SA-CODE-UTIL-TYPE                   
MFA-TR*          AND  SA.RATE_PLAN_NO    = :SA-RATE-PLAN-NO                     
MFA-TR*          AND  SA.CODE_STATUS     IN ('A','T')                           
MFA-TR*          AND  SF.ADJUST_ELEMENT  IN ('L','O')                           
MFA-TR*          AND  SA.DATE_FROM       <= :SA-DATE-FROM                       
MFA-TR*          AND  SA.DATE_TO         >= :SA-DATE-TO                         
MFA-TR*          ORDER BY SA.ENTRY_NO DESC                                      
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*          WITH UR                                                        
MFA-TR*             QUERYNO 7500                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7500-GET-WINTER-BFC         '                       
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7500'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR_APPL'       TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'DATE_FROM'                TO TABLE-ELEMENT-3        
              MOVE SA-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE SA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE SA-DATE-FROM               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7610-OPEN-FIXED-RT-SCHED-CSR                                    *        
      ******************************************************************        
       7610-OPEN-FIXED-RT-SCHED-CSR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN FIXED_RT_SCHED_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7610-OPEN-FIXED-RT-SCHED-CSR'                       
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7610'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE PS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE PS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE PS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7620-FETCH-FIXED-RT-SCHED-CSR                                  *        
      ******************************************************************        
       7620-FETCH-FIXED-RT-SCHED-CSR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH FIXED_RT_SCHED_CSR                                  
               INTO :PS-CMPNT-ID-CD                                     
                   ,:N6-RATE-CMPNT-DESC                                 
                   ,:PS-CODE-USE-INST-TYPE                              
                   ,:WS-UV3-CODE-SHORT-DESC                             
                   ,:WS-UNIT-CD                                         
                   ,:PS-CODE-SEASON                                     
                   ,:WS-UV6-CODE-SHORT-DESC                             
                   ,:PS-CODE-TIME-PERIOD                                
                   ,:WS-UV7-CODE-SHORT-DESC                             
                   ,:PS-BLOCK-NO                                        
                   ,:PS-BLOCK-USE-OR-SVCS                               
                   ,:PS-PRICE-TYPE-CD                                   
                   ,:WS-UV4-CODE-SHORT-DESC                             
                   ,:PS-SCHED-PRICE-AM                                  
                   ,:J1-LAST-ENERGY-BLOCK                               
                   ,:J1-LAST-DEM-BLOCK                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET END-OF-CURSOR-7620 TO TRUE                      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME               TO ABEND-PROGRAM    
                    MOVE '7620-FETCH-FIXED-RT-SCHED-CSR'                
                                                    TO RS-RATE-DEPT-DESC
                    MOVE '7620'                     TO ACTIVE-PARAGRAPH 
                    MOVE 'FETCH'                    TO ABEND-FUNCTION   
                    MOVE 'CSS_PRICE_SCHED'          TO TABLE-1          
                    MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1  
                    MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2  
                    MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3  
                    MOVE PS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1
                    MOVE PS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2
                    MOVE PS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7630-CLOSE-FIXED-RT-SCHED-CSR                                  *        
      ******************************************************************        
       7630-CLOSE-FIXED-RT-SCHED-CSR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE FIXED_RT_SCHED_CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7630-CLOSE-FIXED-RT-SCHED-CSR'                      
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7630'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE PS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE PS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE PS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7640-OPEN-RT-SCHED-PRICE-CSR                                    *        
      ******************************************************************        
       7640-OPEN-RT-SCHED-PRICE-CSR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN RATE_SCHED_PRICE_CSR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7640-OPEN-RT-SCHED-PRICE-CSR'                       
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7640'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE PS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE PS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE PS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7650-FETCH-RT-SCHED-PRICE-CSR                                  *        
      ******************************************************************        
       7650-FETCH-RT-SCHED-PRICE-CSR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH RATE_SCHED_PRICE_CSR                                
               INTO :PS-CMPNT-ID-CD                                     
                   ,:N6-RATE-CMPNT-DESC                                 
                   ,:PS-CODE-USE-INST-TYPE                              
                   ,:WS-UV5-CODE-SHORT-DESC                             
                   ,:WS-UNIT-CD                                         
                   ,:PS-CODE-SEASON                                     
                   ,:WS-UV6-CODE-SHORT-DESC                             
                   ,:PS-CODE-TIME-PERIOD                                
                   ,:WS-UV7-CODE-SHORT-DESC                             
                   ,:PS-BLOCK-NO                                        
                   ,:PS-BLOCK-USE-OR-SVCS                               
                   ,:PS-PRICE-TYPE-CD                                   
                   ,:WS-UV8-CODE-SHORT-DESC                             
                   ,:PS-SCHED-PRICE-AM                                  
                   ,:J1-LAST-ENERGY-BLOCK                               
                   ,:J1-LAST-DEM-BLOCK                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                SET END-OF-CURSOR-7650 TO TRUE                          
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME               TO ABEND-PROGRAM    
                    MOVE '7650-FETCH-RT-SCHED-PRICE-CSR'                
                                                    TO RS-RATE-DEPT-DESC
                    MOVE '7650'                     TO ACTIVE-PARAGRAPH 
                    MOVE 'FETCH'                    TO ABEND-FUNCTION   
                    MOVE 'CSS_PRICE_SCHED'          TO TABLE-1          
                    MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1  
                    MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2  
                    MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3  
                    MOVE PS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1
                    MOVE PS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2
                    MOVE PS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7660-CLOSE-RT-SCHED-PRICE-CSR                                  *        
      ******************************************************************        
       7660-CLOSE-RT-SCHED-PRICE-CSR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE RATE_SCHED_PRICE_CSR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7660-CLOSE-RT-SCHED-PRICE-CSR'                      
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7660'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE PS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE PS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE PS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7670-OPEN-RT-FCTR-ADJUST-CSR                                    *        
      ******************************************************************        
       7670-OPEN-RT-FCTR-ADJUST-CSR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN RT_FCTR_ADJUST_CSR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7670-OPEN-RT-FCTR-ADJUST-CSR '                      
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7670'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR_APPL'       TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'CMPNT-ID-CD'              TO TABLE-ELEMENT-3        
              MOVE SA-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE SA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE SA-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7670-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7680-FETCH-RT-FCTR-ADJUST-CSR                                  *        
      ******************************************************************        
       7680-FETCH-RT-FCTR-ADJUST-CSR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH RT_FCTR_ADJUST_CSR                                  
               INTO :SA-CODE-UTIL-TYPE                                  
                   ,:SA-RATE-PLAN-NO                                    
                   ,:SA-CMPNT-ID-CD                                     
                   ,:SA-INSTR-USE-TYPE-CD                               
                   ,:SA-FACTOR-ID                                       
                   ,:SF-FACTOR-TEXT                                     
                   ,:SF-ADJUST-ELEMENT                                  
                   ,:SA-FACTOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET END-OF-CURSOR-7680 TO TRUE                      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME               TO ABEND-PROGRAM    
                    MOVE '7680-FETCH-RT-FCTR-ADJUST-CSR'                
                                                    TO RS-RATE-DEPT-DESC
                    MOVE '7680'                     TO ACTIVE-PARAGRAPH 
                    MOVE 'FETCH'                    TO ABEND-FUNCTION   
                    MOVE 'CSS_SPCL_FCTR_APPL'       TO TABLE-1          
                    MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1  
                    MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2  
                    MOVE 'CMPNT-ID-CD'              TO TABLE-ELEMENT-3  
                    MOVE SA-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1
                    MOVE SA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2
                    MOVE SA-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7690-CLOSE-RT-FCTR-ADJUST-CSR                                   *        
      ******************************************************************        
       7690-CLOSE-RT-FCTR-ADJUST-CSR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE RT_FCTR_ADJUST_CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7690-CLOSE-RT-FCTR-ADJUST-CSR'                      
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7690'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR_APPL'       TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'CMPNT-ID-CD'              TO TABLE-ELEMENT-3        
              MOVE SA-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE SA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE SA-CMPNT-ID-CD             TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7690-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7810-OPEN-UNMETERED-PLAN-CSR                                   *        
      ******************************************************************        
       7810-OPEN-UNMETERED-PLAN-CSR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN UNMETERED_PLAN_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7810-OPEN-UNMETERED-PLAN-CSR'                       
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7810'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-4        
              MOVE UP-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE UP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE UP-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7820-FETCH-UNMETERED-PLAN-CSR                                  *        
      ******************************************************************        
       7820-FETCH-UNMETERED-PLAN-CSR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH UNMETERED_PLAN_CUR                                  
               INTO :UP-RATE-ITEM-CODE                                  
                   ,:UP-UM-EQUIP-ID                                     
                   ,:L9-UM-EQUIP-LONG-DESC                              
                   ,:L9-UM-EQUIP-KWH                                    
ACT189             ,:L9-UM-EQUIP-TYPE-CD                                
                   ,:UP-CUST-PER-SERVICE                                
                   ,:UP-PRICE-PER-SERV                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET END-OF-CURSOR-7820 TO TRUE                      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME               TO ABEND-PROGRAM    
                    MOVE '7820-FETCH-UNMETERED-PLAN-CSR'                
                                                    TO RS-RATE-DEPT-DESC
                    MOVE '7820'                     TO ACTIVE-PARAGRAPH 
                    MOVE 'FETCH'                    TO ABEND-FUNCTION   
                    MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1          
                    MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1  
                    MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2  
                    MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3  
                    MOVE UP-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1
                    MOVE UP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2
                    MOVE UP-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7830-CLOSE-UNMETERED-PLAN-CSR                                  *        
      ******************************************************************        
       7830-CLOSE-UNMETERED-PLAN-CSR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE UNMETERED_PLAN_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7830-CLOSE-UNMETERED-PLAN-CSR'                      
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7830'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_UNMTR_PLAN'           TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CNTRL'         TO TABLE-ELEMENT-3        
              MOVE UP-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE UP-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE UP-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *7850-OPEN-UNMTR-RATEFCTR-CSR                                    *        
      ******************************************************************        
       7850-OPEN-UNMTR-RATEFCTR-CSR.                                    
                                                                        
           EXEC SQL                                                     
              OPEN UNMTR_RATEFCTR_CUR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7850-OPEN-UNMTR-RATEFCTR-CSR'                       
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7850'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'DATE_FROM'                TO TABLE-ELEMENT-3        
              MOVE SA-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE SA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE SA-DATE-FROM               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7860-FETCH-UNMTR-RATEFCTR-CSR                                  *        
      ******************************************************************        
       7860-FETCH-UNMTR-RATEFCTR-CSR.                                   
                                                                        
           EXEC SQL                                                     
              FETCH UNMTR_RATEFCTR_CUR                                  
               INTO :SA-CODE-UTIL-TYPE                                  
                   ,:SA-RATE-PLAN-NO                                    
                   ,:SA-FACTOR-ID                                       
                   ,:SF-FACTOR-TEXT                                     
                   ,:SF-ADJUST-ELEMENT                                  
                   ,:SA-FACTOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    SET END-OF-CURSOR-7860 TO TRUE                      
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME               TO ABEND-PROGRAM    
                    MOVE '7860-FETCH-UNMTR-RATEFCTR-CSR.'               
                                                    TO RS-RATE-DEPT-DESC
                    MOVE '7860'                     TO ACTIVE-PARAGRAPH 
                    MOVE 'FETCH'                    TO ABEND-FUNCTION   
                    MOVE 'CSS_SPCL_FCTR'            TO TABLE-1          
                    MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1  
                    MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2  
                    MOVE 'DATE_FROM'                TO TABLE-ELEMENT-3  
                    MOVE SA-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1
                    MOVE SA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2
                    MOVE SA-DATE-FROM               TO HOSTVAR-ELEMENT-3
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       7860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7870-CLOSE-UNMTR-RATEFCTR-CSR                                  *        
      ******************************************************************        
       7870-CLOSE-UNMTR-RATEFCTR-CSR.                                   
                                                                        
           EXEC SQL                                                     
              CLOSE UNMTR_RATEFCTR_CUR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7870-CLOSE-UNMTR-RATEFCTR-CSR'                      
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7870'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCTR'            TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'DATE_FROM'                TO TABLE-ELEMENT-3        
              MOVE SA-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE SA-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE SA-DATE-FROM               TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7870-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7900-VALIDATE-EFF-DT.                                          *        
      ******************************************************************        
       7900-VALIDATE-EFF-DT.                                            
                                                                        
            EXEC SQL                                                    
                SELECT
              IIF(TRY_CONVERT(DATE, :PARM-FROM-EFFECTIVE-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-FROM-EFFECTIVE-DT
              ) <> 0) OR (LEN(:PARM-FROM-EFFECTIVE-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-FROM-EFFECTIVE-DT
              ), CONVERT(DATE, :PARM-FROM-EFFECTIVE-DT) )
            INTO
              :WS-FROM-EFF-DT     
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SET :WS-FROM-EFF-DT = DATE(:PARM-FROM-EFFECTIVE-DT)             
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               SET INVALID-PARAMETER TO TRUE                            
               MOVE WS-INVALID-EFFECTIVE-DT TO RS-RATE-DEPT-DESC        
               PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT           
               PERFORM 9999-END-PROGRAM       THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7910-GET-CURRENT-DT.                                           *        
      ******************************************************************        
       7910-GET-CURRENT-DT.                                             
                                                                        
            EXEC SQL                                                    
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-FROM-EFF-DT                      
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SET :WS-FROM-EFF-DT = CURRENT DATE                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7910-GET-CURRENT-DT'                                
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7910'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE 'WS-FROM-EFF-DT'           TO TABLE-ELEMENT-1        
              MOVE WS-FROM-EFF-DT             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7910-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7920-COUNT-NUMBER-BLOCKS                                       *        
      ******************************************************************        
       7920-COUNT-NUMBER-BLOCKS.                                        
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(BLOCK_NO)                                   
                 INTO :WS-NUMBER-BLOCKS                                 
                 FROM CSS_PRICE_SCHED PS WITH(READUNCOMMITTED)                  
                WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO          
                  AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE        
                  AND PS.VERSION_NO_CNTRL   = :PS-VERSION-NO-CNTRL      
                  AND PS.CMPNT_ID_CD        = :PS-CMPNT-ID-CD           
                  AND PS.CODE_USE_INST_TYPE = :PS-CODE-USE-INST-TYPE    
                  AND PS.CODE_SEASON        = :PS-CODE-SEASON           
                  AND PS.CODE_TIME_PERIOD   = :PS-CODE-TIME-PERIOD      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(BLOCK_NO)                                           
MFA-TR*          INTO :WS-NUMBER-BLOCKS                                         
MFA-TR*          FROM CSS_PRICE_SCHED PS                                        
MFA-TR*         WHERE PS.RATE_PLAN_NO       = :PS-RATE-PLAN-NO                  
MFA-TR*           AND PS.CODE_UTIL_TYPE     = :PS-CODE-UTIL-TYPE                
MFA-TR*           AND PS.VERSION_NO_CNTRL   = :PS-VERSION-NO-CNTRL              
MFA-TR*           AND PS.CMPNT_ID_CD        = :PS-CMPNT-ID-CD                   
MFA-TR*           AND PS.CODE_USE_INST_TYPE = :PS-CODE-USE-INST-TYPE            
MFA-TR*           AND PS.CODE_SEASON        = :PS-CODE-SEASON                   
MFA-TR*           AND PS.CODE_TIME_PERIOD   = :PS-CODE-TIME-PERIOD              
MFA-TR*           WITH UR                                                       
MFA-TR*             QUERYNO 7920                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7920-COUNT-NUMBER-BLOCKS    '                       
                                              TO RS-RATE-DEPT-DESC      
              MOVE '7920'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PRICE_SCHED'          TO TABLE-1                
              MOVE 'RATE_PLAN_NO'             TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE 'VERSION_NO_CTRL'          TO TABLE-ELEMENT-3        
              MOVE PS-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-1      
              MOVE PS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
              MOVE PS-VERSION-NO-CNTRL        TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           EXEC SQL                                                     
              INSERT INTO #CSR04425_R1                           
                  (                                                     
                    RETURN_CODE                                         
                   ,COMPANY_NO                                          
                   ,RATE_DEPT_CD                                        
                   ,RATE_DEPT_DESC                                      
                   ,CODE_UTIL_TYPE                                      
                   ,UTIL_TYPE_DESC                                      
                   ,RATE_PLAN_NO                                        
                   ,RATE_DESC                                           
                   ,CMPNT_ID_CD                                         
                   ,RATE_CMPNT_DESC                                     
                   ,CODE_USE_INST_TYPE                                  
                   ,USE_INST_TYPE_DESC                                  
                   ,UNIT_CD                                             
                   ,UNIT_DESC                                           
                   ,CODE_SEASON                                         
                   ,SEASON                                              
                   ,CODE_TIME_PERIOD                                    
                   ,TIME_PERIOD                                         
                   ,BLOCK_NO                                            
                   ,BLOCK_SIZE                                          
                   ,PRICE_TYPE_CD                                       
                   ,PRICE_TYPE_DESC                                     
                   ,PRICE_GROUP                                         
                   ,PRICE                                               
                   ,SORT_ORDER                                          
                   ,LAST_ENERGY_BLOCK                                   
                   ,LAST_DEM_BLOCK                                      
                   ,RATE_ITEM_CODE                                      
                   ,UM_EQUIP_KWH                                        
                   ,VERS_PRORATE                                        
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE                                      
                   ,:S-COMPANY-NO                                       
                   ,:S-RATE-DEPT-CD                                     
                   ,:S-RATE-DEPT-DESC                                   
                   ,:S-CODE-UTIL-TYPE                                   
                   ,:S-UTIL-TYPE-DESC                                   
                   ,:S-RATE-PLAN-NO                                     
                   ,:S-RATE-DESC                                        
                   ,:S-CMPNT-ID-CD                                      
                   ,:S-RATE-CMPNT-DESC                                  
                   ,:S-CODE-USE-INST-TYPE                               
                   ,:S-USE-INST-TYPE-DESC                               
                   ,:S-UNIT-CD                                          
                   ,:S-UNIT-DESC                                        
                   ,:S-CODE-SEASON                                      
                   ,:S-SEASON                                           
                   ,:S-CODE-TIME-PERIOD                                 
                   ,:S-TIME-PERIOD                                      
                   ,:S-BLOCK-NO                                         
                   ,:S-BLOCK-SIZE                                       
                   ,:S-PRICE-TYPE-CD                                    
                   ,:S-PRICE-TYPE-DESC                                  
                   ,:S-PRICE-GROUP                                      
                   ,:S-PRICE                                            
                   ,:S-SORT-ORDER                                       
                   ,:S-LAST-ENERGY-BLOCK                                
                   ,:S-LAST-DEM-BLOCK                                   
                   ,:S-RATE-ITEM-CODE                                   
                   ,:S-UM-EQUIP-KWH                                     
                   ,:S-VERS-PRORATE                                     
                  )                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO SESSION.CSR04425_R1                                   
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,RATE_DEPT_CD                                                
MFA-TR*            ,RATE_DEPT_DESC                                              
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*            ,UTIL_TYPE_DESC                                              
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,RATE_DESC                                                   
MFA-TR*            ,CMPNT_ID_CD                                                 
MFA-TR*            ,RATE_CMPNT_DESC                                             
MFA-TR*            ,CODE_USE_INST_TYPE                                          
MFA-TR*            ,USE_INST_TYPE_DESC                                          
MFA-TR*            ,UNIT_CD                                                     
MFA-TR*            ,UNIT_DESC                                                   
MFA-TR*            ,CODE_SEASON                                                 
MFA-TR*            ,SEASON                                                      
MFA-TR*            ,CODE_TIME_PERIOD                                            
MFA-TR*            ,TIME_PERIOD                                                 
MFA-TR*            ,BLOCK_NO                                                    
MFA-TR*            ,BLOCK_SIZE                                                  
MFA-TR*            ,PRICE_TYPE_CD                                               
MFA-TR*            ,PRICE_TYPE_DESC                                             
MFA-TR*            ,PRICE_GROUP                                                 
MFA-TR*            ,PRICE                                                       
MFA-TR*            ,SORT_ORDER                                                  
MFA-TR*            ,LAST_ENERGY_BLOCK                                           
MFA-TR*            ,LAST_DEM_BLOCK                                              
MFA-TR*            ,RATE_ITEM_CODE                                              
MFA-TR*            ,UM_EQUIP_KWH                                                
MFA-TR*            ,VERS_PRORATE                                                
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-COMPANY-NO                                               
MFA-TR*            ,:S-RATE-DEPT-CD                                             
MFA-TR*            ,:S-RATE-DEPT-DESC                                           
MFA-TR*            ,:S-CODE-UTIL-TYPE                                           
MFA-TR*            ,:S-UTIL-TYPE-DESC                                           
MFA-TR*            ,:S-RATE-PLAN-NO                                             
MFA-TR*            ,:S-RATE-DESC                                                
MFA-TR*            ,:S-CMPNT-ID-CD                                              
MFA-TR*            ,:S-RATE-CMPNT-DESC                                          
MFA-TR*            ,:S-CODE-USE-INST-TYPE                                       
MFA-TR*            ,:S-USE-INST-TYPE-DESC                                       
MFA-TR*            ,:S-UNIT-CD                                                  
MFA-TR*            ,:S-UNIT-DESC                                                
MFA-TR*            ,:S-CODE-SEASON                                              
MFA-TR*            ,:S-SEASON                                                   
MFA-TR*            ,:S-CODE-TIME-PERIOD                                         
MFA-TR*            ,:S-TIME-PERIOD                                              
MFA-TR*            ,:S-BLOCK-NO                                                 
MFA-TR*            ,:S-BLOCK-SIZE                                               
MFA-TR*            ,:S-PRICE-TYPE-CD                                            
MFA-TR*            ,:S-PRICE-TYPE-DESC                                          
MFA-TR*            ,:S-PRICE-GROUP                                              
MFA-TR*            ,:S-PRICE                                                    
MFA-TR*            ,:S-SORT-ORDER                                               
MFA-TR*            ,:S-LAST-ENERGY-BLOCK                                        
MFA-TR*            ,:S-LAST-DEM-BLOCK                                           
MFA-TR*            ,:S-RATE-ITEM-CODE                                           
MFA-TR*            ,:S-UM-EQUIP-KWH                                             
MFA-TR*            ,:S-VERS-PRORATE                                             
MFA-TR*           )                                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                    TO  CTR-ROWS                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100-SEND-RESULT           '                        
                                        TO RS-RATE-DEPT-DESC            
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR04425_R1'        TO TABLE-1                      
              MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-1              
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-2              
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-3              
              MOVE 'RATE_DEPT_DESC'     TO TABLE-ELEMENT-4              
              MOVE S-RATE-PLAN-NO       TO HOSTVAR-ELEMENT-1            
              MOVE S-COMPANY-NO         TO HOSTVAR-ELEMENT-2            
              MOVE S-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3            
              MOVE S-RATE-DEPT-DESC     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 8000A-DELETE-GTT-ROWS                                         *         
      *****************************************************************         
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           EXEC SQL                                                     
               DELETE FROM #CSR04425_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR04425_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES             TO WS-ACTIVE-RETURN-CODE    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
                    MOVE '8000A-DELETE-GTT-ROWS      '                  
                                            TO RS-RATE-DEPT-DESC        
                    MOVE SQLCODE            TO ABEND-SQLCODE            
                    MOVE SQLSTATE           TO ABEND-SQLSTATE           
                    MOVE '8000A'            TO ACTIVE-PARAGRAPH         
                    MOVE 'DELETE'           TO ABEND-FUNCTION           
                    MOVE SPACES             TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                    MOVE 'CSR04425_R1'      TO TABLE-1                  
                    MOVE SPACES             TO TABLE-ELEMENT-1          
                    MOVE SPACES             TO HOSTVAR-ELEMENT-1        
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
           END-EVALUATE.                                                
                                                                        
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00320.                                                       
           EXEC SQL                                                             
                INCLUDE CPD00320                                                
           END-EXEC.                                                            
      *                                                                         
                                                                        
