       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR04422.                                          
       DATE-WRITTEN. FEB 2011.                                          
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  CSR04422 :                                                    *        
      *  THIS COBOL STORED PROCEDURE UPDATES RECONNECT ORDERS TO       *        
      *  ACTIVE OR TURNED DOWN CUSTOMER BASED ON THE CRITERIA.         *        
      *                                                                *        
      *  THIS PROGRAM IS CALLED BY PAYMENT MODULES -MCS03413(CPD03413),*        
      *  CSR02336 AND VOUCHER PANEL 378. IT IS A REWRITE FOR CSR00644. *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS    COMMENTS                                *        
      *  --------  --------    --------------------------------------  *        
P00481*  02/16/11    LAT       NEW PROGRAM.                            *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04422'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ** CSS_SO_DATA       - VO                                                 
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
      ** CSS_SO_ORDER_INST - VI                                                 
           EXEC SQL                                                             
              INCLUDE TBSOODR                                                   
           END-EXEC.                                                            
                                                                        
      ** CSS_SO_UPDATE     - VW                                                 
           EXEC SQL                                                             
              INCLUDE TBSOUPD                                                   
           END-EXEC.                                                            
                                                                        
      ** CSS_CODE_VALUE    - UV                                                 
           EXEC SQL                                                             
               INCLUDE TBCDVALU                                                 
           END-EXEC.                                                            
                                                                        
      ** CSS_ACCOUNT       - AT                                                 
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ** CSS_DELINQUENCY   - C8                                                 
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
      ** CSS_HOLIDAY       - J8                                                 
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
      ** CSS_UTIL_ENVRNMT  - UT                                                 
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ** CSS_ELEC_METER    - EM                                                 
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      ** ERROR HANDLING                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS04422                                                  
           END-EXEC.                                                            
                                                                        
      ** SUPPORTS DB2 AND SQL ERROR CHECKING                                    
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GTT-MISC-FIELDS.                                             
           05  GTT-NAME                PIC X(26) VALUE                  
                                             'SESSION.CSR04422_R1'.     
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18) VALUE SPACES.          
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
           10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
       01  GENERAL-WORKING-STORAGE.                                     
           05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR04422'.    
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-NO-NUM    REDEFINES WS-ACCOUNT-NO             
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
           05  WS-SERV-ORDER-NUM       PIC 9(13).                       
           05  WS-SERV-ORDER-NO     REDEFINES WS-SERV-ORDER-NUM         
                                       PIC X(13).                       
COB305     05 WS-SERV-ORDER-NO-COMP3        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
                                                                        
           05  WS-DELINQ-RECNT-UPDT    PIC S9(4)V9(5) USAGE COMP-3      
                                                 VALUE 0.               
           05  WS-NEW-ORDER-STATE-CD   PIC X(01) VALUE 'D'.             
           05  WS-DB2SP-RET-CODE       PIC S9(4).                       
           05  WS-DB2SP-ITEM-ID        PIC 9(10).                       
           05  WS-SO-DATE-RECVED       PIC X(10).                       
           05  WS-CURR-DATE            PIC X(10).                       
           05  WS-CURR-DATE-TIME       PIC X(26).                       
           05  WS-CURR-TIMESTAMP       PIC X(26).                       
                                                                        
       01  WS-MISC-FLAGS.                                               
           05  WS-ORDER-VALID-FL       PIC X(01) VALUE 'Y'.             
           05  WS-RECON-FOR-ELEC       PIC X(01) VALUE 'N'.             
           05  WS-RECNT-UPDATE-ON      PIC X(01) VALUE 'N'.             
                                                                        
       01  SWITCHES.                                                    
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*EJECT                                                                    
       LINKAGE SECTION.                                                 
      *                                                                         
       01 PARM-ACCOUNT-NO              PIC X(13).                       
       01 PARM-ORDER-TYPE-CD           PIC X(05).                       
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-ORDER-TYPE-CD.                     
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *0100-INITIALIZE.                                                         
      ****************************************************************          
       0100-INITIALIZE.                                                 
           MOVE '0100'                     TO ACTIVE-PARAGRAPH.         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS RETURN_CODE               
               FROM CIS.SYSDUMMY1                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS RETURN_CODE                       
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 1000-PROCESS-INPUT.                                                     
      ****************************************************************          
       1000-PROCESS-INPUT.                                              
           INITIALIZE GTT-RETURN-FIELDS.                                
           ADD 1                           TO CTR-ROWS.                 
           MOVE PARM-ACCOUNT-NO            TO WS-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NO-NUM          TO WS-ACCOUNT-NO-COMP3.      
           MOVE WS-ACCOUNT-NO-COMP3        TO VO-ACCOUNT-NO.            
           MOVE PARM-ORDER-TYPE-CD         TO VO-ORDER-TYPE-CD.         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2000-PROCESS-OUTPUT.                                                    
      ****************************************************************          
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 7050-SELECT-RECONNECT       THRU 7050-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 9999-END-PROGRAM         THRU 9999-EXIT           
           END-IF.                                                      
                                                                        
           MOVE VO-SERV-ORDER-NO           TO VI-SERV-ORDER-NO,         
                                              VW-SERV-ORDER-NO.         
           MOVE VO-COMPANY-NO              TO C8-COMPANY-NO.            
           PERFORM 7100-CHECK-ELEC-SERVICE     THRU 7100-EXIT.          
           IF WS-RECON-FOR-ELEC = 'Y'                                   
              PERFORM 7150-SELECT-DELINQUENCY  THRU 7150-EXIT           
           END-IF.                                                      
           PERFORM 7250-GET-DATE-TIME          THRU 7250-EXIT.          
           PERFORM 5000-UPDATE-PROCESS         THRU 5000-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      ** 5000-UPDATE-PROCESS.                                                   
      ****************************************************************          
       5000-UPDATE-PROCESS.                                             
           MOVE WS-CURR-DATE-TIME          TO VW-ASSIGNED-DATETIME,     
                                              VO-ASSIGNED-DATETIME.     
           MOVE WS-CURR-TIMESTAMP          TO VW-WANTED-BY-DATETIME,    
                                              VO-WANTED-BY-DATETIME.    
                                                                        
           IF (WS-RECON-FOR-ELEC = 'N') OR                              
                        (WS-DELINQ-RECNT-UPDT NOT = 1) OR               
                        (WS-SO-DATE-RECVED NOT EQUAL WS-CURR-DATE)      
              PERFORM 8100-UPDATE-TURNED-DOWN    THRU 8100-EXIT         
           ELSE                                                         
              PERFORM 7600-CHECK-FOR-EXCEPTIONS  THRU 7600-EXIT         
              IF (WS-ORDER-VALID-FL = 'Y' AND WS-SAME-DAY-FL = 'Y')     
                 PERFORM 8200-UPDATE-TO-ACTIVE   THRU 8200-EXIT         
              ELSE                                                      
                 PERFORM 8100-UPDATE-TURNED-DOWN THRU 8100-EXIT         
              END-IF                                                    
           END-IF.                                                      
           PERFORM 8400-INSERT-SO-UPDATE         THRU 8400-EXIT.        
                                                                        
      * PRINT ACTIVE ORDERS AND SEND TO CAD                                     
           IF WS-NEW-ORDER-STATE-CD = 'A'                               
              PERFORM 9820-CALL-CSR01334         THRU 9820-EXIT         
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7050-SELECT-RECONNECT                                                   
      * SELECT RECONNECT ROW IN 'HOLD' STATUS.                                  
      ****************************************************************          
       7050-SELECT-RECONNECT.                                           
           EXEC SQL                                                     
               SELECT TOP(1) VO.SERV_ORDER_NO,
              VO.ORDER_STATE_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), VO.DATE_RECVED, 121), 
           ' ', '-'), ':', '.') DATE_RECVED,
              CAST(VO.DATE_RECVED AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), VO.WANTED_BY_DATETIME
           , 121), ' ', '-'), ':', '.') WANTED_BY_DATETIME,
              REPLACE(REPLACE(CONVERT(CHAR(26), VO.ASSIGNED_DATETIME
           , 121), ' ', '-'), ':', '.') ASSIGNED_DATETIME,
              VO.COMPANY_NO                                     
                 INTO :VO-SERV-ORDER-NO,                                
                      :VO-ORDER-STATE-CD,                               
                      :VO-DATE-RECVED,                                  
                      :WS-SO-DATE-RECVED,                               
                      :VO-WANTED-BY-DATETIME,                           
                      :VO-ASSIGNED-DATETIME,                            
                      :VO-COMPANY-NO                                    
                 FROM CSS_SO_DATA  VO WITH(READUNCOMMITTED)                     
                WHERE VO.ACCOUNT_NO     = :VO-ACCOUNT-NO                
                  AND VO.ORDER_TYPE_CD  = :VO-ORDER-TYPE-CD             
                  AND VO.ORDER_STATE_CD = 'H'                           
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT VO.SERV_ORDER_NO,                                         
MFA-TR*               VO.ORDER_STATE_CD,                                        
MFA-TR*               VO.DATE_RECVED,                                           
MFA-TR*               DATE(VO.DATE_RECVED),                                     
MFA-TR*               VO.WANTED_BY_DATETIME,                                    
MFA-TR*               VO.ASSIGNED_DATETIME,                                     
MFA-TR*               VO.COMPANY_NO                                             
MFA-TR*          INTO :VO-SERV-ORDER-NO,                                        
MFA-TR*               :VO-ORDER-STATE-CD,                                       
MFA-TR*               :VO-DATE-RECVED,                                          
MFA-TR*               :WS-SO-DATE-RECVED,                                       
MFA-TR*               :VO-WANTED-BY-DATETIME,                                   
MFA-TR*               :VO-ASSIGNED-DATETIME,                                    
MFA-TR*               :VO-COMPANY-NO                                            
MFA-TR*          FROM CSS_SO_DATA  VO                                           
MFA-TR*         WHERE VO.ACCOUNT_NO     = :VO-ACCOUNT-NO                        
MFA-TR*           AND VO.ORDER_TYPE_CD  = :VO-ORDER-TYPE-CD                     
MFA-TR*           AND VO.ORDER_STATE_CD = 'H'                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE,    
                                              S-RETURN-CODE.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7050'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_SO_DATA'           TO TABLE-1                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE VO-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      **************************************************************            
      * CHECK IF THE RECONNECT ORDER IS FOR ELECTRIC SERVICE AND NO             
      * RECONNECT ORDER EXISTS FOR GAS.                                         
      **************************************************************            
       7100-CHECK-ELEC-SERVICE.                                         
           EXEC SQL                                                     
               SELECT TOP(1) 'Y',
              CODE_UTIL_TYPE,
              METER_NO                                          
                 INTO :WS-RECON-FOR-ELEC,                               
                      :VI-CODE-UTIL-TYPE,                               
                      :VI-METER-NO                                      
                 FROM CSS_SO_ORDER_INST WITH(READUNCOMMITTED)                   
                WHERE SERV_ORDER_NO  = :VI-SERV-ORDER-NO                
                  AND CODE_UTIL_TYPE = 'E'                              
                  AND WORK_TYPE_CD  <> ' '                              
                  AND NOT EXISTS (SELECT '1' FROM CSS_SO_ORDER_INST
                           WITH(READUNCOMMITTED)     
                             WHERE SERV_ORDER_NO  = :VI-SERV-ORDER-NO   
                               AND CODE_UTIL_TYPE = 'G'                 
                               AND WORK_TYPE_CD  <> ' ')                
                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y',                                                      
MFA-TR*               CODE_UTIL_TYPE,                                           
MFA-TR*               METER_NO                                                  
MFA-TR*          INTO :WS-RECON-FOR-ELEC,                                       
MFA-TR*               :VI-CODE-UTIL-TYPE,                                       
MFA-TR*               :VI-METER-NO                                              
MFA-TR*          FROM CSS_SO_ORDER_INST                                         
MFA-TR*         WHERE SERV_ORDER_NO  = :VI-SERV-ORDER-NO                        
MFA-TR*           AND CODE_UTIL_TYPE = 'E'                                      
MFA-TR*           AND WORK_TYPE_CD  <> ' '                                      
MFA-TR*           AND NOT EXISTS (SELECT '1' FROM CSS_SO_ORDER_INST             
MFA-TR*                      WHERE SERV_ORDER_NO  = :VI-SERV-ORDER-NO           
MFA-TR*                        AND CODE_UTIL_TYPE = 'G'                         
MFA-TR*                        AND WORK_TYPE_CD  <> ' ')                        
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE,    
                                              S-RETURN-CODE.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7100'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_SO_ORDER_INST'     TO TABLE-1                   
              MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1           
              MOVE VI-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * CHECK IF AUTO RECONNECT UPDATE TO ACTIVE FOR ELECTRIC SERVICE           
      * FROM PAYMENT PROGRAMS IS TURNED ON.                                     
      ****************************************************************          
       7150-SELECT-DELINQUENCY.                                         
           EXEC SQL                                                     
               SELECT C8.DELINQ_VALUE                                   
                 INTO :C8-DELINQ-VALUE                                  
                 FROM CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                  
                WHERE C8.DELINQ_CD  = 'AUTO-RECONNECT-UPDT'             
                  AND C8.COMPANY_NO = :C8-COMPANY-NO                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT C8.DELINQ_VALUE                                           
MFA-TR*          INTO :C8-DELINQ-VALUE                                          
MFA-TR*          FROM CSS_DELINQUENCY C8                                        
MFA-TR*         WHERE C8.DELINQ_CD  = 'AUTO-RECONNECT-UPDT'                     
MFA-TR*           AND C8.COMPANY_NO = :C8-COMPANY-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE,    
                                              S-RETURN-CODE.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE C8-DELINQ-VALUE         TO WS-DELINQ-RECNT-UPDT      
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7150'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSS_DELINQUENCY'    TO TABLE-1                   
                 MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1           
                 MOVE C8-COMPANY-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7250-GET-DATE-TIME.                                                     
      * GET CURRENT DATE AND TIME                                               
      **************************************************************            
       7250-GET-DATE-TIME.                                              
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.TIMESTAMP2( 
           CAST(SYSDATETIMEOFFSET() AS DATE), CIS.CHAR2TIME( '0.00' ) )
           , 121), ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURR-DATE,
              :WS-CURR-DATE-TIME,
              :WS-CURR-TIMESTAMP                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-DATE = CURRENT DATE,                                 
MFA-TR*           :WS-CURR-DATE-TIME= TIMESTAMP(CURRENT DATE,'0.00'),           
MFA-TR*           :WS-CURR-TIMESTAMP = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7250'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SET'                   TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7600-CHECK-FOR-EXCEPTIONS                                               
      **************************************************************            
           EXEC SQL                                                             
                INCLUDE CPD04422                                                
           END-EXEC.                                                            
                                                                        
      ****************************************************************          
      * UPDATE RECONNECT ORDER TO 'D' - TURNED DOWN CUSTOMER STATUS.            
      ****************************************************************          
       8100-UPDATE-TURNED-DOWN.                                         
                                                                        
           MOVE 'D'                        TO WS-NEW-ORDER-STATE-CD.    
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_SO_DATA                                       
                  SET ORDER_STATE_CD = 'D'                              
                WHERE SERV_ORDER_NO  = :VO-SERV-ORDER-NO                
                  AND ORDER_TYPE_CD  = 'FM006'                          
                  AND ORDER_STATE_CD = 'H'                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE,    
                                              S-RETURN-CODE.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '8100'                  TO ACTIVE-PARAGRAPH          
              MOVE 'UPDATE'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_SO_DATA'           TO TABLE-1                   
              MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1           
              MOVE VO-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * UPDATE RECONNECT ORDER TO 'A' - ACTIVE.                                 
      **************************************************************            
       8200-UPDATE-TO-ACTIVE.                                           
           MOVE 'A'                        TO WS-NEW-ORDER-STATE-CD     
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_SO_DATA                                        
              SET ORDER_STATE_CD     = 'A',                             
                  ASSIGNED_DATETIME  = CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-DATE-TIME
              ),              
                  WANTED_BY_DATETIME = CIS.CHAR2TIMESTAMP(
                                                     :WS-CURR-TIMESTAMP
              )               
              WHERE SERV_ORDER_NO    = :VO-SERV-ORDER-NO                
                AND ORDER_TYPE_CD    = 'FM006'                          
                AND ORDER_STATE_CD   = 'H'                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_SO_DATA                                                
MFA-TR*       SET ORDER_STATE_CD     = 'A',                                     
MFA-TR*           ASSIGNED_DATETIME  = :WS-CURR-DATE-TIME,                      
MFA-TR*           WANTED_BY_DATETIME = :WS-CURR-TIMESTAMP                       
MFA-TR*       WHERE SERV_ORDER_NO    = :VO-SERV-ORDER-NO                        
MFA-TR*         AND ORDER_TYPE_CD    = 'FM006'                                  
MFA-TR*         AND ORDER_STATE_CD   = 'H'                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE,    
                                              S-RETURN-CODE.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '8200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'UPDATE'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_SO_DATA'           TO TABLE-1                   
              MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1           
              MOVE VO-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      *INSERT A ROW INTO CSS_SO_UPDATE WITH THE CURRENT ORDER STATUS            
      **************************************************************            
       8400-INSERT-SO-UPDATE.                                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_SO_UPDATE                                
                    (SERV_ORDER_NO,                                     
                     USER_ID_UPDT_BY,                                   
                     UPDATE_DATETIME,                                   
                     PANEL_NO,                                          
                     ASSIGNED_DATETIME,                                 
                     ORDER_TYPE_CD,                                     
                     SERV_ORDER_STATUS,                                 
                     ORDER_STATE_CD,                                    
                     WANTED_BY_DATETIME)                                
               VALUES                                                   
                    (:VW-SERV-ORDER-NO,                                 
                     'SYSTEM',                                          
                      CIS.CURRENT$TIMESTAMP(),                                
                     'BMX',                                             
                     CIS.CHAR2TIMESTAMP(:VW-ASSIGNED-DATETIME),                 
                     :VO-ORDER-TYPE-CD,                                 
                     '10',                                              
                     :WS-NEW-ORDER-STATE-CD,                            
                     CIS.CHAR2TIMESTAMP(:VW-WANTED-BY-DATETIME))                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_SO_UPDATE                                        
MFA-TR*             (SERV_ORDER_NO,                                             
MFA-TR*              USER_ID_UPDT_BY,                                           
MFA-TR*              UPDATE_DATETIME,                                           
MFA-TR*              PANEL_NO,                                                  
MFA-TR*              ASSIGNED_DATETIME,                                         
MFA-TR*              ORDER_TYPE_CD,                                             
MFA-TR*              SERV_ORDER_STATUS,                                         
MFA-TR*              ORDER_STATE_CD,                                            
MFA-TR*              WANTED_BY_DATETIME)                                        
MFA-TR*        VALUES                                                           
MFA-TR*             (:VW-SERV-ORDER-NO,                                         
MFA-TR*              'SYSTEM',                                                  
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*              'BMX',                                                     
MFA-TR*              :VW-ASSIGNED-DATETIME,                                     
MFA-TR*              :VO-ORDER-TYPE-CD,                                         
MFA-TR*              '10',                                                      
MFA-TR*              :WS-NEW-ORDER-STATE-CD,                                    
MFA-TR*              :VW-WANTED-BY-DATETIME)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE,    
                                              S-RETURN-CODE.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '8400'                  TO ACTIVE-PARAGRAPH          
              MOVE 'INSERT'                TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_SO_UPDATE'         TO TABLE-1                   
              MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1           
              MOVE VW-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * CALL THE STORED PROCEDURE CSR01334 TO PRINT AND SEND THE                
      * ORDER TO CAD.                                                           
      ****************************************************************          
       9820-CALL-CSR01334.                                              
           MOVE VO-SERV-ORDER-NO           TO WS-SERV-ORDER-NO-COMP3.   
           MOVE WS-SERV-ORDER-NO-COMP3     TO WS-SERV-ORDER-NUM.        
                                                                        
           EXEC SQL                                                     
              CALL CSR01334 (:WS-SERV-ORDER-NO,                         
                             ' ',                                       
                             ' ',                                       
                             'SYSTEM',                                  
                             'A')                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE,    
                                              S-RETURN-CODE.            
           IF WS-ACTIVE-RETURN-CODE = +466                              
              MOVE 0                       TO S-RETURN-CODE             
           ELSE                                                         
              MOVE -1                      TO WS-ACTIVE-RETURN-CODE,    
                                              S-RETURN-CODE             
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '9820'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SP CALL'               TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSR01334 CALL'         TO TABLE-1                   
              MOVE 'SERV_ORDER_NO'         TO TABLE-ELEMENT-1           
              MOVE WS-SERV-ORDER-NO        TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       9820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 9900 - ERROR HANDLING                                                   
      **************************************************************            
           EXEC SQL                                                             
               INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
      *                                                                         
      **************************************************************            
      * END PROGRAM COPYLIB                                                     
      **************************************************************            
                                                                        
           EXEC SQL                                                             
               INCLUDE CPD00321                                                 
           END-EXEC.                                                            
                                                                        
