       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR04421.                                     
COB303 DATE-WRITTEN.  JAN 27,2011                                       
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM CHECKING THE PAY AND GO USER IS ELIGIBLE FOR     *        
      *  OR NORMAL  DNP PROCESS OR NOT.                                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
P00453*  01/27/11  SV95326    PROCEDURE ORIGINALLY CODED.              *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR04421'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-START                           PIC X(40) VALUE            
            'WORKING STORAGE FOR CSR04421 STARTS HERE'.                 
      *                                                                         
       01 WORK-VARIABLES.                                               
          05 PROGRAM-NAME                    PIC X(08) VALUE 'CSR04421'.
          05 WS-CURR-REV-MONTH               PIC X(06) VALUE SPACES.    
          05 WS-CURRENT-DATE                 PIC X(10) VALUE SPACES.    
          05 WS-TRAN-APPL-NO                 PIC S9(4) COMP VALUE 0.    
          05 WS-TRANS-HIST-SEQ-NO            PIC X(26) VALUE SPACES.    
      *                                                                         
       01 SWITCHES.                                                     
          05 SEND-DONE-SW                    PIC X(01) VALUE 'Y'.       
             88 SEND-DONE-ERROR                        VALUE 'N'.       
             88 SEND-DONE-OK                           VALUE 'Y'.       
      *                                                                         
       01 WS-COUNTERS.                                                  
          05 CTR-ROWS                        PIC S9(09) COMP VALUE 0.   
      *                                                                         
       01 GTT-RETURN-FIELDS.                                            
          05 S-RETURN-CODE                   PIC S9(04) COMP VALUE 0.   
      *                                                                         
      ******************************************************************        
      *               COBOL WORKING STORAGE COPY BOOKS                 *        
      ******************************************************************        
      *                                                                         
      ******************************************************************        
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_ACCOUNT        - AT                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_CRED_FORECAST  - CM                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCRFCST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_JOB_PARM       - G6                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_MNT_TRANS_HIST - MH                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_MT_TRN_HST_DET - MI                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_USER_PROFILE   - PF                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_ACCT-ATTRIBUTE - YP                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
      *                                                                         
       LINKAGE SECTION.                                                 
       01  PARM-APPL-IND               PIC  X(08) VALUE SPACES.         
       01  PARM-ACCOUNT-NO             PIC  X(13) VALUE SPACES.         
       01  PARM-USER-ID                PIC  X(07) VALUE SPACES.         
       01  PARM-EFFECTIVE-DATE         PIC  X(10) VALUE SPACES.         
      *                                                                         
       PROCEDURE DIVISION USING  PARM-APPL-IND                          
                               , PARM-ACCOUNT-NO                        
                               , PARM-USER-ID                           
                               , PARM-EFFECTIVE-DATE.                   
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL                                                     
              DECLARE C1 CURSOR                              
              WITH ROWSET POSITIONING FOR                               
              SELECT                                                    
                  :S-RETURN-CODE              AS    RETURN_CODE         
              FROM                                                      
                  CIS.SYSDUMMY1                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*       WITH ROWSET POSITIONING FOR                                       
MFA-TR*       SELECT                                                            
MFA-TR*           :S-RETURN-CODE              AS    RETURN_CODE                 
MFA-TR*       FROM                                                              
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE PARM-ACCOUNT-NO             TO AT-ACCOUNT-NO.           
           MOVE PARM-USER-ID                TO PF-USER-ID.              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 7000-GET-CURR-DATE-TIME       THRU 7000-EXIT.        
           PERFORM 7100-GET-BILL-CYCLE-AT        THRU 7100-EXIT.        
           PERFORM 7200-GET-JOB-PARM-REV-MONTH   THRU 7200-EXIT.        
           MOVE WS-CURR-REV-MONTH                TO CM-REVENUE-MONTH.   
           MOVE WS-CURRENT-DATE                  TO CM-BILL-DT          
           MOVE AT-BILL-CYCLE                    TO CM-BILL-CYCLE.      
           MOVE 'B'                              TO CM-CRED-FORECAST-CD.
           MOVE '01'                             TO CM-COMPANY-NO.      
           PERFORM 7300-GET-BILL-DUE-DT          THRU 7300-EXIT.        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 7400-GET-BILL-DUE-DT       THRU 7400-EXIT         
           END-IF.                                                      
           IF PARM-EFFECTIVE-DATE > CM-CURR-CHG-DUE-DT                  
              MOVE AT-ACCOUNT-NO               TO YP-ACCOUNT-NO         
              MOVE 'SET_PRP_EXEMPTIONS'        TO YP-ATTRIBUTE-DESC     
              MOVE 'D'                         TO YP-ATTRIBUTE-VALUE-CD 
              MOVE WS-TRANS-HIST-SEQ-NO(1:10)  TO YP-ATTRIBUTE-VALUE-DT 
              MOVE WS-TRANS-HIST-SEQ-NO        TO YP-CREATED-TS         
              MOVE SPACES                      TO                       
                                            YP-ATTRIBUTE-VALUE-TX-TEXT  
              MOVE ZERO                     TO YP-ATTRIBUTE-VALUE-TX-LEN
              MOVE 'A'                         TO YP-STATUS-CD          
              PERFORM 8000-INSERT-PRP-ATTR       THRU 8000-EXIT         
              PERFORM 5000-JRNL-TRAN-HEAD        THRU 5000-EXIT         
              PERFORM 5100-JRNL-ACCT-DTLS        THRU 5100-EXIT         
           END-IF.                                                      
           PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *2000A-MOVE-RESULT.                                              *        
      ******************************************************************        
      *                                                                         
       2000A-MOVE-RESULT.                                               
      *                                                                         
           ADD +1                           TO CTR-ROWS.                
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-JRNL-TRAN-HEAD.                                           *        
      *     JOURNALS THE MAINTENANCE TRANSACTION HEADER                *        
      ******************************************************************        
      *                                                                         
       5000-JRNL-TRAN-HEAD.                                             
      *                                                                         
           PERFORM 7500-SELECT-RESP-AREA-ID THRU 7500-EXIT.             
      *                                                                         
           MOVE 1                           TO WS-TRAN-APPL-NO          
                                               MI-TRAN-APPL-NO.         
      *                                                                        0
           MOVE WS-TRANS-HIST-SEQ-NO        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE PF-RESP-AREA-ID             TO MH-RESP-AREA-ID.         
           MOVE AT-ACCOUNT-NO               TO MH-ACCOUNT-NO.           
           MOVE ZEROS                       TO MH-CUSTOMER-NO.          
           MOVE ZEROS                       TO MH-PREMISE-NO.           
           MOVE PARM-USER-ID                TO MH-USER-ID.              
           MOVE 'PANEL085'                  TO MH-APPL-PROGRAM-ID.      
      *    IF PARM-COMMENTS = SPACE                                             
           MOVE 0                           TO MH-TRAN-COMMENT-TEXT.    
      *    ELSE                                                                 
      *       MOVE PARM-COMMENTS       TO MH-TRAN-COMMENT                       
      *       MOVE LENGTH OF PARM-COMMENTS TO MH-TRAN-COMMENT-LEN               
      *       MOVE PARM-COMMENTS           TO MH-TRAN-COMMENT-TEXT              
      *    END-IF.                                                              
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-JRNL-ACCT-DTLS.                                           *        
      ******************************************************************        
      *                                                                         
       5100-JRNL-ACCT-DTLS.                                             
      *                                                                         
           MOVE WS-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE '*INSERT*'                  TO MI-COLUMN-DESC.          
           MOVE ' '                         TO MI-TABLE-ID.             
           MOVE 18                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE 'SET_PRP_EXEMPTIONS'        TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 10                          TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE SPACES                      TO MI-PRV-COLUMN-VALUE-TEXT.
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                            TO WS-TRAN-APPL-NO.         
      *                                                                         
      *    MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.                 
      *    MOVE 'SEND NOTICE EXMPTN'        TO MI-COLUMN-DESC.                  
      *    MOVE '13'                        TO MI-TABLE-ID.                     
      *    MOVE 23                          TO MI-CHG-COLUMN-VALUE-LEN.         
      *    MOVE 'CURRENT MONTH + 1 MONTH'   TO MI-CHG-COLUMN-VALUE-TEXT.        
      *    MOVE 10                          TO MI-PRV-COLUMN-VALUE-LEN.         
      *    MOVE SPACES                      TO MI-PRV-COLUMN-VALUE-TEXT         
      *    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.                     
      *    ADD 1                            TO WS-TRAN-APPL-NO.                 
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      *  6530-LOAD-MNT-TRANS-HIST.                                     *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 7000-GET-CURR-DATE-TIME.                                       *        
      ******************************************************************        
      *                                                                         
       7000-GET-CURR-DATE-TIME.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE      = CURRENT DATE                          
MFA-TR*          ,:WS-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7100-GET-BILL-CYCLE-AT.                                       *        
      ******************************************************************        
      *                                                                         
       7100-GET-BILL-CYCLE-AT.                                          
      *                                                                         
           EXEC SQL                                                     
               SELECT AT.BILL_CYCLE                                     
                 INTO :AT-BILL-CYCLE                                    
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.BILL_CYCLE                                             
MFA-TR*          INTO :AT-BILL-CYCLE                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7200-GET-JOB-PARM-REV-MONTH.                                  *        
      ******************************************************************        
      *                                                                         
       7200-GET-JOB-PARM-REV-MONTH.                                     
      *                                                                         
           EXEC SQL                                                     
               SELECT CIS.SUBSTR3(G6.PARM_DATA,15,6)                         
                 INTO :WS-CURR-REV-MONTH                                
                 FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
                WHERE G6.PROGRAM_NAME = 'COMMON'                        
                  AND G6.COMPANY_NO   = '01'                            
                  AND G6.CMND_CODE    = 'DATE'                          
                  AND G6.SEQ_NO       = 20                              
                  AND G6.STATUS       = 'A'                             
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBSTR(G6.PARM_DATA,15,6)                                 
MFA-TR*          INTO :WS-CURR-REV-MONTH                                        
MFA-TR*          FROM CSS_JOB_PARM G6                                           
MFA-TR*         WHERE G6.PROGRAM_NAME = 'COMMON'                                
MFA-TR*           AND G6.COMPANY_NO   = '01'                                    
MFA-TR*           AND G6.CMND_CODE    = 'DATE'                                  
MFA-TR*           AND G6.SEQ_NO       = 20                                      
MFA-TR*           AND G6.STATUS       = 'A'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7200'                   TO ACTIVE-PARAGRAPH         
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE 'CSS_JOB_PARM'           TO TABLE-1                  
              MOVE 'PROGRAM_NAME'           TO TABLE-ELEMENT-1          
              MOVE 'COMPANY_NO'             TO TABLE-ELEMENT-2          
              MOVE 'CMND_CODE'              TO TABLE-ELEMENT-3          
              MOVE 'SEQ_NO'                 TO TABLE-ELEMENT-4          
              MOVE 'COMMON'                 TO HOSTVAR-ELEMENT-1        
              MOVE '01'                     TO HOSTVAR-ELEMENT-2        
              MOVE 'DATE'                   TO HOSTVAR-ELEMENT-3        
              MOVE '20'                     TO HOSTVAR-ELEMENT-4        
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7300-GET-BILL-DUE-DT.                                         *        
      ******************************************************************        
      *                                                                         
       7300-GET-BILL-DUE-DT.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) CM.CURR_CHG_DUE_DT                                
                 INTO :CM-CURR-CHG-DUE-DT                               
                 FROM CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)                
                WHERE CM.REVENUE_MONTH     = :CM-REVENUE-MONTH          
                  AND CM.BILL_DT           > IIF(TRY_CONVERT(DATE, 
                                                            :CM-BILL-DT
              ) IS NULL OR (PATINDEX('%.%', :CM-BILL-DT) <> 0) OR (LEN(
                                                            :CM-BILL-DT
              ) <> 10), CIS.CHAR2DATE(:CM-BILL-DT), CONVERT(DATE, 
                                                            :CM-BILL-DT
              ) )                
                  AND CM.BILL_CYCLE        = :CM-BILL-CYCLE             
                  AND CM.CRED_FORECAST_CD  = :CM-CRED-FORECAST-CD       
                  AND CM.COMPANY_NO        = :CM-COMPANY-NO             
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CM.CURR_CHG_DUE_DT                                        
MFA-TR*          INTO :CM-CURR-CHG-DUE-DT                                       
MFA-TR*          FROM CSS_CRED_FORECAST CM                                      
MFA-TR*         WHERE CM.REVENUE_MONTH     = :CM-REVENUE-MONTH                  
MFA-TR*           AND CM.BILL_DT           > :CM-BILL-DT                        
MFA-TR*           AND CM.BILL_CYCLE        = :CM-BILL-CYCLE                     
MFA-TR*           AND CM.CRED_FORECAST_CD  = :CM-CRED-FORECAST-CD               
MFA-TR*           AND CM.COMPANY_NO        = :CM-COMPANY-NO                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE 'CSS_CRED_FORECAST'       TO TABLE-1                 
              MOVE 'REVENUE_MONTH'           TO TABLE-ELEMENT-1         
              MOVE 'BILL_DT'                 TO TABLE-ELEMENT-2         
              MOVE 'BILL_CYCLE'              TO TABLE-ELEMENT-3         
              MOVE CM-REVENUE-MONTH          TO HOSTVAR-ELEMENT-1       
              MOVE CM-BILL-DT                TO HOSTVAR-ELEMENT-2       
              MOVE CM-BILL-CYCLE             TO HOSTVAR-ELEMENT-3       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *  7400-GET-BILL-DUE-DT.                                         *        
      ******************************************************************        
      *                                                                         
       7400-GET-BILL-DUE-DT.                                            
      *                                                                         
           EXEC SQL                                                     
               SELECT TOP(1) CM.CURR_CHG_DUE_DT                                
                 INTO :CM-CURR-CHG-DUE-DT                               
                 FROM CSS_CRED_FORECAST CM WITH(READUNCOMMITTED)                
                WHERE CM.REVENUE_MONTH     = :CM-REVENUE-MONTH          
                  AND CM.BILL_DT           > IIF(TRY_CONVERT(DATE, 
                                                            :CM-BILL-DT
              ) IS NULL OR (PATINDEX('%.%', :CM-BILL-DT) <> 0) OR (LEN(
                                                            :CM-BILL-DT
              ) <> 10), CIS.CHAR2DATE(:CM-BILL-DT), CONVERT(DATE, 
                                                            :CM-BILL-DT
              ) )                
                  AND CM.CRED_FORECAST_CD  = :CM-CRED-FORECAST-CD       
                  AND CM.COMPANY_NO        = :CM-COMPANY-NO             
                                             
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CM.CURR_CHG_DUE_DT                                        
MFA-TR*          INTO :CM-CURR-CHG-DUE-DT                                       
MFA-TR*          FROM CSS_CRED_FORECAST CM                                      
MFA-TR*         WHERE CM.REVENUE_MONTH     = :CM-REVENUE-MONTH                  
MFA-TR*           AND CM.BILL_DT           > :CM-BILL-DT                        
MFA-TR*           AND CM.CRED_FORECAST_CD  = :CM-CRED-FORECAST-CD               
MFA-TR*           AND CM.COMPANY_NO        = :CM-COMPANY-NO                     
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*       QUERYNO 7400                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE 'CSS_CRED_FORECAST'       TO TABLE-1                 
              MOVE 'REVENUE_MONTH'           TO TABLE-ELEMENT-1         
              MOVE 'BILL_DT'                 TO TABLE-ELEMENT-2         
              MOVE CM-REVENUE-MONTH          TO HOSTVAR-ELEMENT-1       
              MOVE CM-BILL-DT                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-SELECT-RESP-AREA-ID.                                      *        
      ******************************************************************        
      *                                                                         
       7500-SELECT-RESP-AREA-ID.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                  
               WHERE USER_ID  = :PF-USER-ID                             
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE PF                                        
MFA-TR*        WHERE USER_ID  = :PF-USER-ID                                     
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                    TO ABEND-TABLES            
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
              MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-1       
              MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                        0
      ******************************************************************44280000
      * 8000-INSERT-PRP-ATTR.                                          *44300000
      ******************************************************************44310000
      *                                                                         
       8000-INSERT-PRP-ATTR.                                            
      *                                                                         
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                     (ACCOUNT_NO                                        
                     ,ATTRIBUTE_DESC                                    
                     ,ATTRIBUTE_VALUE_CD                                
                     ,ATTRIBUTE_VALUE_DT                                
                     ,ATTRIBUTE_VALUE_TX                                
                     ,CREATED_TS                                        
                     ,STATUS_CD)                                        
              VALUES                                                    
                     (:YP-ACCOUNT-NO                                    
                     ,:YP-ATTRIBUTE-DESC                                
                     ,:YP-ATTRIBUTE-VALUE-CD                            
                     ,IIF(TRY_CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT
              ) IS NULL OR (PATINDEX('%.%', :YP-ATTRIBUTE-VALUE-DT
              ) <> 0) OR (LEN(:YP-ATTRIBUTE-VALUE-DT
              ) <> 10), CIS.CHAR2DATE(:YP-ATTRIBUTE-VALUE-DT
              ), CONVERT(DATE, :YP-ATTRIBUTE-VALUE-DT) )                       
                     ,:YP-ATTRIBUTE-VALUE-TX                            
                     ,CIS.CHAR2TIMESTAMP(:YP-CREATED-TS)                        
                     ,:YP-STATUS-CD)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                                    
MFA-TR*              (ACCOUNT_NO                                                
MFA-TR*              ,ATTRIBUTE_DESC                                            
MFA-TR*              ,ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*              ,ATTRIBUTE_VALUE_TX                                        
MFA-TR*              ,CREATED_TS                                                
MFA-TR*              ,STATUS_CD)                                                
MFA-TR*       VALUES                                                            
MFA-TR*              (:YP-ACCOUNT-NO                                            
MFA-TR*              ,:YP-ATTRIBUTE-DESC                                        
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-DT                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX                                    
MFA-TR*              ,:YP-CREATED-TS                                            
MFA-TR*              ,:YP-STATUS-CD)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE.           
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR -803       
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
               MOVE '8000'                   TO ACTIVE-PARAGRAPH        
               MOVE 'INSERT'                 TO ABEND-FUNCTION          
               MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                 
               MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
               MOVE YP-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
               PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   9700-PROCESS-ABENDG / ABEND PROCESSING                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       9900 - JOURNALING / ERROR HANDLING ROUTINE               *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
      *                                                                         
